/* valaccodeenumvalue.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEENUMVALUE_H__
#define __CCODE_VALACCODEENUMVALUE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ENUM_VALUE (vala_ccode_enum_value_get_type ())
#define VALA_CCODE_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ENUM_VALUE, ValaCCodeEnumValue))
#define VALA_CCODE_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ENUM_VALUE, ValaCCodeEnumValueClass))
#define VALA_IS_CCODE_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ENUM_VALUE))
#define VALA_IS_CCODE_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ENUM_VALUE))
#define VALA_CCODE_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ENUM_VALUE, ValaCCodeEnumValueClass))

typedef struct _ValaCCodeEnumValue ValaCCodeEnumValue;
typedef struct _ValaCCodeEnumValueClass ValaCCodeEnumValueClass;
typedef struct _ValaCCodeEnumValuePrivate ValaCCodeEnumValuePrivate;

/**
 * Represents an enum value in the C code.
 */
struct _ValaCCodeEnumValue {
	ValaCCodeNode parent_instance;
	ValaCCodeEnumValuePrivate * priv;
};

struct _ValaCCodeEnumValueClass {
	ValaCCodeNodeClass parent_class;
};


ValaCCodeEnumValue* vala_ccode_enum_value_new (const char* name, ValaCCodeExpression* value);
char* vala_ccode_enum_value_get_name (ValaCCodeEnumValue* self);
void vala_ccode_enum_value_set_name (ValaCCodeEnumValue* self, const char* value);
ValaCCodeExpression* vala_ccode_enum_value_get_value (ValaCCodeEnumValue* self);
void vala_ccode_enum_value_set_value (ValaCCodeEnumValue* self, ValaCCodeExpression* value);
GType vala_ccode_enum_value_get_type (void);


G_END_DECLS

#endif
