/* valaccodeassignmentbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeassignmentbinding.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaexpressionstatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadynamicsignal.h>
#include <vala/valamember.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valalambdaexpression.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodefragment.h>
#include <vala/valaelementaccess.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valascope.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valapointertype.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodedynamicsignalbinding.h>




struct _ValaCCodeAssignmentBindingPrivate {
	ValaAssignment* _assignment;
};

#define VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBindingPrivate))
enum  {
	VALA_CCODE_ASSIGNMENT_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT
};
static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self);
static char* vala_ccode_assignment_binding_generate_signal_handler_wrapper (ValaCCodeAssignmentBinding* self, ValaMethod* m, ValaSignal* sig);
static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_assignment_binding_parent_class = NULL;
static void vala_ccode_assignment_binding_dispose (GObject * obj);



ValaCCodeAssignmentBinding* vala_ccode_assignment_binding_new (ValaCCodeGenerator* codegen, ValaAssignment* assignment) {
	ValaCCodeAssignmentBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (assignment), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ASSIGNMENT_BINDING, 0, NULL);
	vala_ccode_assignment_binding_set_assignment (self, assignment);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (self->priv->_assignment), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method) {
		ValaCCodeExpression* _tmp4;
		ValaCCodeConstant* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), (_tmp4 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), (_tmp3 = vala_property_get_canonical_cconstant (prop)), vala_property_get_type_reference (prop), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	} else {
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* cexpr;
		ValaCCodeExpression* _tmp6;
		ValaCCodeFunctionCall* ccall;
		_tmp5 = NULL;
		cexpr = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
		/* ensure to pass the value correctly typed (especially important for varargs)*/
		_tmp6 = NULL;
		cexpr = (_tmp6 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cexpr, vala_expression_get_static_type (vala_assignment_get_right (self->priv->_assignment)), vala_property_get_type_reference (prop)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp6);
		if (!vala_property_get_no_accessor_method (prop)) {
			if (vala_data_type_is_real_struct_type (vala_property_get_type_reference (prop))) {
				ValaCCodeExpression* _tmp7;
				_tmp7 = NULL;
				cexpr = (_tmp7 = vala_ccode_generator_get_address_of_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment), cexpr), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp7);
			}
		}
		if (vala_assignment_get_operator (self->priv->_assignment) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			ValaCCodeBinaryOperator cop;
			ValaCCodeExpression* _tmp9;
			ValaCCodeParenthesizedExpression* _tmp8;
			cop = 0;
			if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
						} else {
							if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
							} else {
								if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_BINARY_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_BINARY_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_BINARY_OPERATOR_MOD;
										} else {
											if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp9 = NULL;
			_tmp8 = NULL;
			cexpr = (_tmp9 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_parenthesized_expression_new (cexpr))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp9);
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		}
		ccall = vala_ccode_generator_get_property_set_call (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), prop, ma, cexpr);
		/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
		if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_assignment))))) {
			ValaCCodeCommaExpression* ccomma;
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		} else {
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
		}
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
}


static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaSignal* _tmp2;
	ValaSignal* sig;
	ValaMethod* _tmp3;
	ValaMethod* m;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* ccall;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (self->priv->_assignment), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	sig = (_tmp2 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	m = (_tmp3 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (self->priv->_assignment))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp5;
			ValaCCodeDynamicSignalBinding* _tmp4;
			_tmp5 = NULL;
			_tmp4 = NULL;
			connect_func = (_tmp5 = vala_ccode_dynamic_signal_binding_get_connect_wrapper_name ((_tmp4 = vala_ccode_generator_dynamic_signal_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_SIGNAL (sig)))), (connect_func = (g_free (connect_func), NULL)), _tmp5);
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		} else {
			char* _tmp6;
			_tmp6 = NULL;
			connect_func = (_tmp6 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), _tmp6);
			if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
				char* _tmp7;
				_tmp7 = NULL;
				connect_func = (_tmp7 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp7);
			}
		}
	} else {
		if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
				char* _tmp9;
				ValaCCodeDynamicSignalBinding* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				connect_func = (_tmp9 = vala_ccode_dynamic_signal_binding_get_disconnect_wrapper_name ((_tmp8 = vala_ccode_generator_dynamic_signal_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_SIGNAL (sig)))), (connect_func = (g_free (connect_func), NULL)), _tmp9);
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			} else {
				char* _tmp10;
				_tmp10 = NULL;
				connect_func = (_tmp10 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), _tmp10);
			}
			disconnect = TRUE;
		} else {
			vala_code_node_set_error (VALA_CODE_NODE (self->priv->_assignment), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_assignment)), "Specified compound assignment type for signals not supported.");
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			connect_func = (g_free (connect_func), NULL);
			return;
		}
	}
	_tmp11 = NULL;
	_tmp12 = NULL;
	ccall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new (connect_func)))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
	/* first argument: instance of sender*/
	if (vala_member_access_get_inner (ma) != NULL) {
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
	} else {
		ValaCCodeIdentifier* _tmp13;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp15;
		char* _tmp14;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp15 = NULL;
		_tmp14 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (sig))))))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		_tmp14 = (g_free (_tmp14), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp16;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_signal_get_canonical_cconstant (sig))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		} else {
			ValaCCodeConstant* _tmp17;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp18;
			ValaCCodeFunctionCall* _tmp19;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp20;
			ValaTypesymbol* _tmp21;
			ValaTypesymbol* decl_type;
			ValaCCodeIdentifier* _tmp23;
			char* _tmp22;
			ValaCCodeUnaryExpression* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeConstant* _tmp26;
			ValaCCodeConstant* _tmp27;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeConstant* _tmp29;
			ValaCCodeConstant* _tmp30;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->uint_type, TRUE, NULL);
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			_tmp18 = NULL;
			_tmp19 = NULL;
			parse_call = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("g_signal_parse_name")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19);
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp20 = vala_signal_get_canonical_cconstant (sig))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			_tmp21 = NULL;
			decl_type = (_tmp21 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21)));
			_tmp23 = NULL;
			_tmp22 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ((_tmp22 = vala_typesymbol_get_type_id (decl_type))))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			_tmp22 = (g_free (_tmp22), NULL);
			_tmp25 = NULL;
			_tmp24 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))))));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			_tmp26 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ("NULL"))));
			(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			_tmp27 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("FALSE"))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
			_tmp28 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
			/* fourth argument: detail*/
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("0"))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
			/* fifth argument: closure*/
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("NULL"))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
			(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
		}
	}
	/* third resp. sixth argument: handler*/
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeCastExpression* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		char* _tmp31;
		/* signal handler wrappers not used for dynamic signals*/
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = vala_method_get_cname (m))))), "GCallback"))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		_tmp31 = (g_free (_tmp31), NULL);
		vala_method_set_cinstance_parameter_position (m, ((double) -1));
	} else {
		ValaCCodeCastExpression* _tmp36;
		ValaCCodeIdentifier* _tmp35;
		char* _tmp34;
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = vala_ccode_assignment_binding_generate_signal_handler_wrapper (self, m, sig))))), "GCallback"))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		_tmp34 = (g_free (_tmp34), NULL);
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (self->priv->_assignment))) {
			ValaMemberAccess* _tmp37;
			ValaMemberAccess* right_ma;
			_tmp37 = NULL;
			right_ma = (_tmp37 = VALA_MEMBER_ACCESS (vala_assignment_get_right (self->priv->_assignment)), (_tmp37 == NULL ? NULL : g_object_ref (_tmp37)));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
			} else {
				ValaCCodeIdentifier* _tmp38;
				_tmp38 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("self"))));
				(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
			}
			(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (self->priv->_assignment))) {
				ValaCCodeIdentifier* _tmp39;
				_tmp39 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("self"))));
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
			}
		}
		if (!disconnect && !(VALA_IS_DYNAMIC_SIGNAL (sig))) {
			ValaCCodeConstant* _tmp40;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp40 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_constant_new ("0"))));
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		}
	} else {
		ValaCCodeConstant* _tmp41;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("NULL"))));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	}
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	connect_func = (g_free (connect_func), NULL);
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static char* vala_ccode_assignment_binding_generate_signal_handler_wrapper (ValaCCodeAssignmentBinding* self, ValaMethod* m, ValaSignal* sig) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* wrapper_name;
	char* _tmp5;
	ValaCCodeFunction* _tmp6;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* cparam;
	ValaCCodeFormalParameter* _tmp9;
	char* _tmp8;
	char* _tmp7;
	GeeList* sig_params;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	ValaCCodeIdentifier* _tmp17;
	char* _tmp16;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp22;
	char* _tmp23;
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	wrapper_name = (_tmp3 = g_strdup_printf ("_%s_%s%s", (_tmp0 = vala_method_get_cname (m)), (_tmp1 = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)))), (_tmp2 = vala_signal_get_cname (sig))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	if (!vala_ccode_generator_add_wrapper (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), wrapper_name)) {
		/* wrapper already defined*/
		return wrapper_name;
	}
	/* declaration*/
	_tmp5 = NULL;
	_tmp6 = NULL;
	function = (_tmp6 = vala_ccode_function_new (wrapper_name, (_tmp5 = vala_data_type_get_cname (vala_method_get_return_type (m)))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (function));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
	gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), cparam);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	cparam = (_tmp9 = vala_ccode_formal_parameter_new ("sender", (_tmp8 = g_strconcat ((_tmp7 = vala_typesymbol_get_cname ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)))), FALSE)), "*", NULL))), (cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL))), _tmp9);
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp7 = (g_free (_tmp7), NULL);
	gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) 0), FALSE)), cparam);
	sig_params = vala_signal_get_parameters (sig);
	{
		GeeList* param_collection;
		GeeIterator* param_it;
		param_collection = sig_params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				/* ensure that C code node has been generated*/
				vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
				gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp10;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (cparam_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp10 = NULL;
		vala_ccode_function_add_parameter (function, (_tmp10 = ((ValaCCodeFormalParameter*) gee_map_get (GEE_MAP (cparam_map), GINT_TO_POINTER (min_pos)))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeIdentifier* _tmp11;
		_tmp11 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), (_tmp11 = vala_ccode_identifier_new ("self")));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	}
	i = -1;
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				ValaCCodeExpression* arg;
				arg = NULL;
				if (i < 0) {
					ValaCCodeExpression* _tmp12;
					_tmp12 = NULL;
					arg = (_tmp12 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("sender")), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), _tmp12);
				} else {
					ValaCCodeExpression* _tmp15;
					ValaFormalParameter* _tmp13;
					ValaCCodeNode* _tmp14;
					_tmp15 = NULL;
					_tmp13 = NULL;
					_tmp14 = NULL;
					arg = (_tmp15 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp14 = vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp13 = ((ValaFormalParameter*) gee_list_get (sig_params, i))))), (VALA_IS_CCODE_FORMAL_PARAMETER (_tmp14) ? ((ValaCCodeFormalParameter*) _tmp14) : NULL)))))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), _tmp15);
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp18 = NULL;
	ccall = (_tmp18 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_method_get_cname (m)))))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp19;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp19 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp19 = ((ValaCCodeExpression*) gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp20;
		_tmp20 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp20 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	} else {
		ValaCCodeReturnStatement* _tmp21;
		_tmp21 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp21 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	}
	/* append to file*/
	_tmp22 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp22 = vala_ccode_function_copy (function))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	_tmp23 = NULL;
	return (_tmp23 = wrapper_name, (function == NULL ? NULL : (function = (g_object_unref (function), NULL))), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), (cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL))), (sig_params == NULL ? NULL : (sig_params = (g_object_unref (sig_params), NULL))), (carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp23);
}


static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaCCodeExpression* _tmp1;
	ValaElementAccess* _tmp2;
	ValaElementAccess* expr;
	ValaTypesymbol* _tmp3;
	ValaTypesymbol* container_type;
	GeeCollection* indices;
	GeeIterator* indices_it;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp6;
	ValaExpression* _tmp5;
	ValaCCodeExpression* _tmp7;
	ValaCCodeExpression* cindex;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	/* custom element access*/
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	rhs = (_tmp1 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (vala_assignment_get_right (self->priv->_assignment)), vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp1);
	_tmp2 = NULL;
	expr = (_tmp2 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	container_type = (_tmp3 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	indices = GEE_COLLECTION (vala_element_access_get_indices (expr));
	indices_it = gee_iterable_iterator (GEE_ITERABLE (indices));
	gee_iterator_next (indices_it);
	_tmp4 = NULL;
	ccontainer = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	cindex = (_tmp7 = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp5 = ((ValaExpression*) gee_iterator_get (indices_it)))))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
	if (container_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type)) || vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type)))) {
		ValaTypesymbol* collection_iface;
		ValaMethod* set_method;
		GeeCollection* set_params;
		GeeIterator* set_params_it;
		ValaFormalParameter* set_param;
		ValaCCodeIdentifier* _tmp14;
		char* _tmp13;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeFunctionCall* set_ccall;
		ValaCCodeCastExpression* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaCCodeExpression* _tmp19;
		/* lookup symbol in interface instead of class as implemented interface methods are not in VAPI files*/
		collection_iface = NULL;
		if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type))) {
			ValaTypesymbol* _tmp9;
			ValaInterface* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			collection_iface = (_tmp9 = VALA_TYPESYMBOL ((_tmp8 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp9);
		} else {
			if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type))) {
				ValaTypesymbol* _tmp11;
				ValaInterface* _tmp10;
				_tmp11 = NULL;
				_tmp10 = NULL;
				collection_iface = (_tmp11 = VALA_TYPESYMBOL ((_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp11);
			}
		}
		set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (collection_iface)), "set"));
		set_params = vala_method_get_parameters (set_method);
		set_params_it = gee_iterable_iterator (GEE_ITERABLE (set_params));
		gee_iterator_next (set_params_it);
		set_param = ((ValaFormalParameter*) gee_iterator_get (set_params_it));
		if (vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (set_param)) != NULL) {
			ValaDataType* index_type;
			ValaCCodeExpression* _tmp12;
			index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (set_method), vala_formal_parameter_get_type_reference (set_param), VALA_CODE_NODE (self->priv->_assignment));
			_tmp12 = NULL;
			cindex = (_tmp12 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp12);
			(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
		}
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp15 = NULL;
		set_ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = vala_method_get_cname (set_method)))))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_cast_expression_new (ccontainer, (_tmp17 = g_strconcat ((_tmp16 = vala_typesymbol_get_cname (collection_iface, FALSE)), "*", NULL))))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp16 = (g_free (_tmp16), NULL);
		vala_ccode_function_call_add_argument (set_ccall, cindex);
		_tmp19 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, (_tmp19 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (VALA_EXPRESSION (expr)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (set_ccall));
		(collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL)));
		(set_method == NULL ? NULL : (set_method = (g_object_unref (set_method), NULL)));
		(set_params == NULL ? NULL : (set_params = (g_object_unref (set_params), NULL)));
		(set_params_it == NULL ? NULL : (set_params_it = (g_object_unref (set_params_it), NULL)));
		(set_param == NULL ? NULL : (set_param = (g_object_unref (set_param), NULL)));
		(set_ccall == NULL ? NULL : (set_ccall = (g_object_unref (set_ccall), NULL)));
	} else {
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_assignment)), "internal error: unsupported element access");
		vala_code_node_set_error (VALA_CODE_NODE (self->priv->_assignment), TRUE);
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(indices_it == NULL ? NULL : (indices_it = (g_object_unref (indices_it), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaCCodeExpression* _tmp1;
	gboolean unref_old;
	gboolean array;
	gboolean instance_delegate;
	ValaCCodeAssignmentOperator cop;
	ValaCCodeAssignment* _tmp13;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	rhs = (_tmp1 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_static_type (vala_assignment_get_right (self->priv->_assignment)), vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp1);
	unref_old = (vala_data_type_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))));
	array = FALSE;
	instance_delegate = FALSE;
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment)))) {
		array = !(VALA_IS_CCODE_CONSTANT (vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment), 1)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment)))) {
			ValaDelegateType* _tmp2;
			ValaDelegateType* delegate_type;
			_tmp2 = NULL;
			delegate_type = (_tmp2 = VALA_DELEGATE_TYPE (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
			instance_delegate = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type));
			(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
		}
	}
	if (unref_old || array || instance_delegate) {
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeExpression* _tmp12;
		ValaCCodeCommaExpression* _tmp11;
		ccomma = vala_ccode_comma_expression_new ();
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment)), TRUE, NULL);
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		if (unref_old) {
			ValaCCodeExpression* _tmp5;
			/* unref old value */
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (_tmp5 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment)), vala_assignment_get_left (self->priv->_assignment))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		}
		if (array) {
			ValaArrayType* _tmp6;
			ValaArrayType* array_type;
			_tmp6 = NULL;
			array_type = (_tmp6 = VALA_ARRAY_TYPE (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp7;
					lhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment), dim);
					rhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment), dim);
					_tmp7 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (g_object_unref (rhs_array_len), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (instance_delegate) {
				ValaDelegateType* _tmp8;
				ValaDelegateType* delegate_type;
				ValaCCodeExpression* lhs_delegate_target;
				ValaCCodeExpression* rhs_delegate_target;
				ValaCCodeAssignment* _tmp9;
				_tmp8 = NULL;
				delegate_type = (_tmp8 = VALA_DELEGATE_TYPE (vala_expression_get_static_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
				lhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment));
				rhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment));
				_tmp9 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
				(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (g_object_unref (lhs_delegate_target), NULL)));
				(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (g_object_unref (rhs_delegate_target), NULL)));
			}
		}
		_tmp10 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		rhs = (_tmp12 = VALA_CCODE_EXPRESSION ((_tmp11 = ccomma, (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp12);
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	}
	cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
	if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} else {
		if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
		} else {
			if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			} else {
				if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
				} else {
					if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
					} else {
						if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
						} else {
							if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
							} else {
								if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
								} else {
									if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
									} else {
										if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp13 = NULL;
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), rhs, cop))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	if (unref_old && VALA_IS_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment))))) {
		ValaCCodeElementAccess* _tmp14;
		ValaCCodeElementAccess* cea;
		/* ensure that index expression in element access doesn't get evaluated more than once
		 except when it's a simple expression*/
		_tmp14 = NULL;
		cea = (_tmp14 = VALA_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
		if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
			ValaLocalVariable* index_temp_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp16;
			ValaCCodeIdentifier* _tmp15;
			ValaCCodeIdentifier* _tmp17;
			index_temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, index_temp_decl);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp16 = NULL;
			_tmp15 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self)));
			_tmp17 = NULL;
			vala_ccode_element_access_set_index (cea, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(index_temp_decl == NULL ? NULL : (index_temp_decl = (g_object_unref (index_temp_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_ccode_assignment_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (base);
	vala_code_node_accept_children (VALA_CODE_NODE (self->priv->_assignment), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment)))) {
		vala_ccode_assignment_binding_emit_property_assignment (self);
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment)))) {
			vala_ccode_assignment_binding_emit_signal_assignment (self);
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)) && !(VALA_IS_ARRAY_TYPE (vala_expression_get_static_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment))))))) && !(VALA_IS_POINTER_TYPE (vala_expression_get_static_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)))))))) {
				vala_ccode_assignment_binding_emit_non_array_element_access (self);
			} else {
				vala_ccode_assignment_binding_emit_simple_assignment (self);
			}
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (self->priv->_assignment), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
	vala_ccode_generator_visit_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_EXPRESSION (self->priv->_assignment));
}


ValaAssignment* vala_ccode_assignment_binding_get_assignment (ValaCCodeAssignmentBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self), NULL);
	return self->priv->_assignment;
}


void vala_ccode_assignment_binding_set_assignment (ValaCCodeAssignmentBinding* self, ValaAssignment* value) {
	ValaAssignment* _tmp2;
	ValaAssignment* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_assignment = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL))), _tmp2);
}


static void vala_ccode_assignment_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		g_value_set_object (value, vala_ccode_assignment_binding_get_assignment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		vala_ccode_assignment_binding_set_assignment (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_class_init (ValaCCodeAssignmentBindingClass * klass) {
	vala_ccode_assignment_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeAssignmentBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_assignment_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_assignment_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_assignment_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_assignment_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT, g_param_spec_object ("assignment", "assignment", "assignment", VALA_TYPE_ASSIGNMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_assignment_binding_init (ValaCCodeAssignmentBinding * self) {
	self->priv = VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_assignment_binding_dispose (GObject * obj) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (obj);
	(self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL)));
	G_OBJECT_CLASS (vala_ccode_assignment_binding_parent_class)->dispose (obj);
}


GType vala_ccode_assignment_binding_get_type (void) {
	static GType vala_ccode_assignment_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_assignment_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignmentBinding), 0, (GInstanceInitFunc) vala_ccode_assignment_binding_init };
		vala_ccode_assignment_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeAssignmentBinding", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_binding_type_id;
}




