/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodegenerator.h>
#include <vala/valavaluetype.h>
#include <vala/valascope.h>
#include <vala/valaclassinstancetype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <vala/valalockable.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valareport.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <gee/list.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <vala/valavoidtype.h>
#include <vala/valareferencetype.h>
#include <vala/valainterfaceinstancetype.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valastatement.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodelabel.h>
#include <vala/valamemberinitializer.h>
#include <vala/valanulltype.h>
#include <vala/valamethodtype.h>
#include <gee/map.h>
#include <vala/valainvalidtype.h>
#include <ccode/valaccodeincludedirective.h>
#include <gee/hashset.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valaccodeclassbinding.h>
#include <gobject/valaccodeinterfacebinding.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>
#include <gobject/valaccodecreationmethodbinding.h>
#include <gobject/valaccodedynamicsignalbinding.h>
#include <gobject/valaccodearraycreationexpressionbinding.h>
#include <gobject/valaccodememberaccessbinding.h>
#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <gobject/valaccodeelementaccessbinding.h>
#include <gobject/valaccodeassignmentbinding.h>




struct _ValaCCodeGeneratorPrivate {
	gint current_try_id;
	gint next_try_id;
	gboolean in_constructor;
	gboolean requires_free_checked;
	gboolean requires_array_free;
	gboolean requires_strcmp0;
	GeeSet* wrappers;
};

#define VALA_CCODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorPrivate))
enum  {
	VALA_CCODE_GENERATOR_DUMMY_PROPERTY
};
static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context);
static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void vala_ccode_generator_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static gboolean vala_ccode_generator_is_constant_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr);
static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaCCodeExpression* vala_ccode_generator_get_type_id_expression (ValaCCodeGenerator* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_generator_get_dup_func_expression (ValaCCodeGenerator* self, ValaDataType* type, ValaSourceReference* source_reference);
static ValaCCodeExpression* vala_ccode_generator_get_destroy_func_expression (ValaCCodeGenerator* self, ValaDataType* type);
static char* vala_ccode_generator_generate_glist_free_wrapper (ValaCCodeGenerator* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression);
static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_ccode_generator_append_temp_decl (ValaCCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars);
static void vala_ccode_generator_add_simple_check (ValaCCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_ccode_generator_create_temp_decl (ValaCCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars);
static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_ccode_generator_append_local_free (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_ccode_generator_append_param_free (ValaCCodeGenerator* self, ValaMethod* m, ValaCCodeFragment* cfrag);
static void vala_ccode_generator_create_local_free (ValaCCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static gboolean vala_ccode_generator_append_local_free_expr (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static gboolean vala_ccode_generator_append_param_free_expr (ValaCCodeGenerator* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma);
static void vala_ccode_generator_create_local_free_expr (ValaCCodeGenerator* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static char* vala_ccode_generator_get_symbol_lock_name (ValaCCodeGenerator* self, ValaSymbol* sym);
static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt);
static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_ccode_generator_find_property_access (ValaCCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_generator_get_ref_expression (ValaCCodeGenerator* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static ValaCCodeFunctionCall* vala_ccode_generator_create_type_check (ValaCCodeNode* ccodenode, ValaTypesymbol* type);
static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static char* vala_ccode_generator_generate_delegate_wrapper (ValaCCodeGenerator* self, ValaMethod* m, ValaDelegate* d);
static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeStatement* vala_ccode_generator_create_property_type_check_statement (ValaCCodeGenerator* self, ValaProperty* prop, gboolean check_return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCodeBinding* vala_ccode_generator_real_create_namespace_binding (ValaCodeGenerator* base, ValaNamespace* node);
static ValaCodeBinding* vala_ccode_generator_real_create_class_binding (ValaCodeGenerator* base, ValaClass* node);
static ValaCodeBinding* vala_ccode_generator_real_create_struct_binding (ValaCodeGenerator* base, ValaStruct* node);
static ValaCodeBinding* vala_ccode_generator_real_create_interface_binding (ValaCodeGenerator* base, ValaInterface* node);
static ValaCodeBinding* vala_ccode_generator_real_create_enum_binding (ValaCodeGenerator* base, ValaEnum* node);
static ValaCodeBinding* vala_ccode_generator_real_create_enum_value_binding (ValaCodeGenerator* base, ValaEnumValue* node);
static ValaCodeBinding* vala_ccode_generator_real_create_error_domain_binding (ValaCodeGenerator* base, ValaErrorDomain* node);
static ValaCodeBinding* vala_ccode_generator_real_create_error_code_binding (ValaCodeGenerator* base, ValaErrorCode* node);
static ValaCodeBinding* vala_ccode_generator_real_create_delegate_binding (ValaCodeGenerator* base, ValaDelegate* node);
static ValaCodeBinding* vala_ccode_generator_real_create_constant_binding (ValaCodeGenerator* base, ValaConstant* node);
static ValaCodeBinding* vala_ccode_generator_real_create_field_binding (ValaCodeGenerator* base, ValaField* node);
static ValaCodeBinding* vala_ccode_generator_real_create_method_binding (ValaCodeGenerator* base, ValaMethod* node);
static ValaCodeBinding* vala_ccode_generator_real_create_dynamic_method_binding (ValaCodeGenerator* base, ValaDynamicMethod* node);
static ValaCodeBinding* vala_ccode_generator_real_create_creation_method_binding (ValaCodeGenerator* base, ValaCreationMethod* node);
static ValaCodeBinding* vala_ccode_generator_real_create_formal_parameter_binding (ValaCodeGenerator* base, ValaFormalParameter* node);
static ValaCodeBinding* vala_ccode_generator_real_create_property_binding (ValaCodeGenerator* base, ValaProperty* node);
static ValaCodeBinding* vala_ccode_generator_real_create_property_accessor_binding (ValaCodeGenerator* base, ValaPropertyAccessor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_signal_binding (ValaCodeGenerator* base, ValaSignal* node);
static ValaCodeBinding* vala_ccode_generator_real_create_dynamic_signal_binding (ValaCodeGenerator* base, ValaDynamicSignal* node);
static ValaCodeBinding* vala_ccode_generator_real_create_constructor_binding (ValaCodeGenerator* base, ValaConstructor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_destructor_binding (ValaCodeGenerator* base, ValaDestructor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_type_parameter_binding (ValaCodeGenerator* base, ValaTypeParameter* node);
static ValaCodeBinding* vala_ccode_generator_real_create_block_binding (ValaCodeGenerator* base, ValaBlock* node);
static ValaCodeBinding* vala_ccode_generator_real_create_empty_statement_binding (ValaCodeGenerator* base, ValaEmptyStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_declaration_statement_binding (ValaCodeGenerator* base, ValaDeclarationStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_local_variable_binding (ValaCodeGenerator* base, ValaLocalVariable* node);
static ValaCodeBinding* vala_ccode_generator_real_create_initializer_list_binding (ValaCodeGenerator* base, ValaInitializerList* node);
static ValaCodeBinding* vala_ccode_generator_real_create_expression_statement_binding (ValaCodeGenerator* base, ValaExpressionStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_if_statement_binding (ValaCodeGenerator* base, ValaIfStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_statement_binding (ValaCodeGenerator* base, ValaSwitchStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_section_binding (ValaCodeGenerator* base, ValaSwitchSection* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_label_binding (ValaCodeGenerator* base, ValaSwitchLabel* node);
static ValaCodeBinding* vala_ccode_generator_real_create_while_statement_binding (ValaCodeGenerator* base, ValaWhileStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_do_statement_binding (ValaCodeGenerator* base, ValaDoStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_for_statement_binding (ValaCodeGenerator* base, ValaForStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_foreach_statement_binding (ValaCodeGenerator* base, ValaForeachStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_break_statement_binding (ValaCodeGenerator* base, ValaBreakStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_continue_statement_binding (ValaCodeGenerator* base, ValaContinueStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_return_statement_binding (ValaCodeGenerator* base, ValaReturnStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_throw_statement_binding (ValaCodeGenerator* base, ValaThrowStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_try_statement_binding (ValaCodeGenerator* base, ValaTryStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_catch_clause_binding (ValaCodeGenerator* base, ValaCatchClause* node);
static ValaCodeBinding* vala_ccode_generator_real_create_lock_statement_binding (ValaCodeGenerator* base, ValaLockStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_delete_statement_binding (ValaCodeGenerator* base, ValaDeleteStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* base, ValaArrayCreationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_boolean_literal_binding (ValaCodeGenerator* base, ValaBooleanLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_character_literal_binding (ValaCodeGenerator* base, ValaCharacterLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_integer_literal_binding (ValaCodeGenerator* base, ValaIntegerLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_real_literal_binding (ValaCodeGenerator* base, ValaRealLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_string_literal_binding (ValaCodeGenerator* base, ValaStringLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_null_literal_binding (ValaCodeGenerator* base, ValaNullLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* base, ValaParenthesizedExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_member_access_binding (ValaCodeGenerator* base, ValaMemberAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_invocation_expression_binding (ValaCodeGenerator* base, ValaInvocationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_element_access_binding (ValaCodeGenerator* base, ValaElementAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_base_access_binding (ValaCodeGenerator* base, ValaBaseAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_postfix_expression_binding (ValaCodeGenerator* base, ValaPostfixExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* base, ValaObjectCreationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* base, ValaSizeofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_typeof_expression_binding (ValaCodeGenerator* base, ValaTypeofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_unary_expression_binding (ValaCodeGenerator* base, ValaUnaryExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_cast_expression_binding (ValaCodeGenerator* base, ValaCastExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* base, ValaPointerIndirection* node);
static ValaCodeBinding* vala_ccode_generator_real_create_addressof_expression_binding (ValaCodeGenerator* base, ValaAddressofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* base, ValaReferenceTransferExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_binary_expression_binding (ValaCodeGenerator* base, ValaBinaryExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_type_check_binding (ValaCodeGenerator* base, ValaTypeCheck* node);
static ValaCodeBinding* vala_ccode_generator_real_create_conditional_expression_binding (ValaCodeGenerator* base, ValaConditionalExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_binding (ValaCodeGenerator* base, ValaLambdaExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_assignment_binding (ValaCodeGenerator* base, ValaAssignment* node);
static char* vala_ccode_generator_get_marshaller_type_name (ValaCCodeGenerator* self, ValaDataType* t);
static char* vala_ccode_generator_get_marshaller_type_name_for_parameter (ValaCCodeGenerator* self, ValaFormalParameter* param);
static char* vala_ccode_generator_get_value_type_name_from_type_reference (ValaCCodeGenerator* self, ValaDataType* t);
static char* vala_ccode_generator_get_value_type_name_from_parameter (ValaCCodeGenerator* self, ValaFormalParameter* p);
static char* vala_ccode_generator_get_marshaller_signature (ValaCCodeGenerator* self, GeeCollection* params, ValaDataType* return_type);
static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_ccode_generator_get_internal_include (ValaCCodeGenerator* self, const char* filename);
static ValaCCodeForStatement* vala_ccode_generator_get_vala_array_free_loop (ValaCCodeGenerator* self, gboolean have_length);
static void vala_ccode_generator_append_vala_array_free (ValaCCodeGenerator* self);
static void vala_ccode_generator_append_vala_array_move (ValaCCodeGenerator* self);
static void vala_ccode_generator_append_vala_strcmp0 (ValaCCodeGenerator* self);
static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_ccode_generator_get_define_for_filename (const char* filename);
static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_ccode_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_ccode_generator_parent_class = NULL;
static void vala_ccode_generator_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeGenerator* vala_ccode_generator_new (void) {
	ValaCCodeGenerator * self;
	self = g_object_newv (VALA_TYPE_CCODE_GENERATOR, 0, NULL);
	return self;
}


static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context) {
	ValaCCodeGenerator * self;
	ValaCodeContext* _tmp1;
	ValaCodeContext* _tmp0;
	ValaSymbol* _tmp3;
	ValaNamespace* _tmp2;
	ValaDataType* _tmp5;
	ValaTypesymbol* _tmp4;
	ValaDataType* _tmp7;
	ValaTypesymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypesymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypesymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypesymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypesymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypesymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypesymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypesymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypesymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypesymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypesymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypesymbol* _tmp28;
	ValaDataType* _tmp31;
	ValaTypesymbol* _tmp30;
	ValaDataType* _tmp33;
	ValaTypesymbol* _tmp32;
	ValaDataType* _tmp35;
	ValaClass* _tmp34;
	ValaMethod* _tmp36;
	ValaSymbol* glib_ns;
	ValaTypesymbol* _tmp37;
	ValaTypesymbol* _tmp38;
	ValaTypesymbol* _tmp39;
	ValaErrorType* _tmp40;
	ValaClass* _tmp41;
	ValaClass* _tmp42;
	ValaTypesymbol* _tmp43;
	ValaTypesymbol* _tmp44;
	ValaDataType* _tmp46;
	ValaTypesymbol* _tmp45;
	ValaDataType* _tmp48;
	ValaClass* _tmp47;
	ValaTypesymbol* _tmp49;
	ValaSymbol* gee_ns;
	ValaSymbol* dbus_ns;
	GeeCollection* source_files;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->context = (_tmp1 = (_tmp0 = context, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->context == NULL ? NULL : (self->context = (g_object_unref (self->context), NULL))), _tmp1);
	vala_code_context_find_header_cycles (context);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->root_symbol = (_tmp3 = VALA_SYMBOL ((_tmp2 = vala_code_context_get_root (context), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)))), (self->root_symbol == NULL ? NULL : (self->root_symbol = (g_object_unref (self->root_symbol), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->bool_type = (_tmp5 = VALA_DATA_TYPE (vala_value_type_new ((_tmp4 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))))), (self->bool_type == NULL ? NULL : (self->bool_type = (g_object_unref (self->bool_type), NULL))), _tmp5);
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->char_type = (_tmp7 = VALA_DATA_TYPE (vala_value_type_new ((_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "char"))))), (self->char_type == NULL ? NULL : (self->char_type = (g_object_unref (self->char_type), NULL))), _tmp7);
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->unichar_type = (_tmp9 = VALA_DATA_TYPE (vala_value_type_new ((_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar"))))), (self->unichar_type == NULL ? NULL : (self->unichar_type = (g_object_unref (self->unichar_type), NULL))), _tmp9);
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->short_type = (_tmp11 = VALA_DATA_TYPE (vala_value_type_new ((_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short"))))), (self->short_type == NULL ? NULL : (self->short_type = (g_object_unref (self->short_type), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->ushort_type = (_tmp13 = VALA_DATA_TYPE (vala_value_type_new ((_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort"))))), (self->ushort_type == NULL ? NULL : (self->ushort_type = (g_object_unref (self->ushort_type), NULL))), _tmp13);
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->int_type = (_tmp15 = VALA_DATA_TYPE (vala_value_type_new ((_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int"))))), (self->int_type == NULL ? NULL : (self->int_type = (g_object_unref (self->int_type), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->uint_type = (_tmp17 = VALA_DATA_TYPE (vala_value_type_new ((_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint"))))), (self->uint_type == NULL ? NULL : (self->uint_type = (g_object_unref (self->uint_type), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->long_type = (_tmp19 = VALA_DATA_TYPE (vala_value_type_new ((_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long"))))), (self->long_type == NULL ? NULL : (self->long_type = (g_object_unref (self->long_type), NULL))), _tmp19);
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->ulong_type = (_tmp21 = VALA_DATA_TYPE (vala_value_type_new ((_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong"))))), (self->ulong_type == NULL ? NULL : (self->ulong_type = (g_object_unref (self->ulong_type), NULL))), _tmp21);
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->int8_type = (_tmp23 = VALA_DATA_TYPE (vala_value_type_new ((_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8"))))), (self->int8_type == NULL ? NULL : (self->int8_type = (g_object_unref (self->int8_type), NULL))), _tmp23);
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint8_type = (_tmp25 = VALA_DATA_TYPE (vala_value_type_new ((_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint8"))))), (self->uint8_type == NULL ? NULL : (self->uint8_type = (g_object_unref (self->uint8_type), NULL))), _tmp25);
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->int64_type = (_tmp27 = VALA_DATA_TYPE (vala_value_type_new ((_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int64"))))), (self->int64_type == NULL ? NULL : (self->int64_type = (g_object_unref (self->int64_type), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->uint64_type = (_tmp29 = VALA_DATA_TYPE (vala_value_type_new ((_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64"))))), (self->uint64_type == NULL ? NULL : (self->uint64_type = (g_object_unref (self->uint64_type), NULL))), _tmp29);
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->float_type = (_tmp31 = VALA_DATA_TYPE (vala_value_type_new ((_tmp30 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "float"))))), (self->float_type == NULL ? NULL : (self->float_type = (g_object_unref (self->float_type), NULL))), _tmp31);
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp33 = NULL;
	_tmp32 = NULL;
	self->double_type = (_tmp33 = VALA_DATA_TYPE (vala_value_type_new ((_tmp32 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))))), (self->double_type == NULL ? NULL : (self->double_type = (g_object_unref (self->double_type), NULL))), _tmp33);
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	_tmp35 = NULL;
	_tmp34 = NULL;
	self->string_type = (_tmp35 = VALA_DATA_TYPE (vala_class_instance_type_new ((_tmp34 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string"))))), (self->string_type == NULL ? NULL : (self->string_type = (g_object_unref (self->string_type), NULL))), _tmp35);
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp36 = NULL;
	self->substring_method = (_tmp36 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->string_type))), "substring")), (self->substring_method == NULL ? NULL : (self->substring_method = (g_object_unref (self->substring_method), NULL))), _tmp36);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	_tmp37 = NULL;
	self->gtype_type = (_tmp37 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), (self->gtype_type == NULL ? NULL : (self->gtype_type = (g_object_unref (self->gtype_type), NULL))), _tmp37);
	_tmp38 = NULL;
	self->gtypeinstance_type = (_tmp38 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeInstance")), (self->gtypeinstance_type == NULL ? NULL : (self->gtypeinstance_type = (g_object_unref (self->gtypeinstance_type), NULL))), _tmp38);
	_tmp39 = NULL;
	self->gobject_type = (_tmp39 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL ? NULL : (self->gobject_type = (g_object_unref (self->gobject_type), NULL))), _tmp39);
	_tmp40 = NULL;
	self->gerror_type = (_tmp40 = vala_error_type_new (NULL, NULL), (self->gerror_type == NULL ? NULL : (self->gerror_type = (g_object_unref (self->gerror_type), NULL))), _tmp40);
	_tmp41 = NULL;
	self->glist_type = (_tmp41 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL ? NULL : (self->glist_type = (g_object_unref (self->glist_type), NULL))), _tmp41);
	_tmp42 = NULL;
	self->gslist_type = (_tmp42 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL ? NULL : (self->gslist_type = (g_object_unref (self->gslist_type), NULL))), _tmp42);
	_tmp43 = NULL;
	self->gstringbuilder_type = (_tmp43 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StringBuilder")), (self->gstringbuilder_type == NULL ? NULL : (self->gstringbuilder_type = (g_object_unref (self->gstringbuilder_type), NULL))), _tmp43);
	_tmp44 = NULL;
	self->garray_type = (_tmp44 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL ? NULL : (self->garray_type = (g_object_unref (self->garray_type), NULL))), _tmp44);
	_tmp46 = NULL;
	_tmp45 = NULL;
	self->gquark_type = (_tmp46 = VALA_DATA_TYPE (vala_value_type_new ((_tmp45 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark"))))), (self->gquark_type == NULL ? NULL : (self->gquark_type = (g_object_unref (self->gquark_type), NULL))), _tmp46);
	(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
	_tmp48 = NULL;
	_tmp47 = NULL;
	self->mutex_type = (_tmp48 = VALA_DATA_TYPE (vala_class_instance_type_new ((_tmp47 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Mutex"))))), (self->mutex_type == NULL ? NULL : (self->mutex_type = (g_object_unref (self->mutex_type), NULL))), _tmp48);
	(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
	_tmp49 = NULL;
	self->type_module_type = (_tmp49 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL ? NULL : (self->type_module_type = (g_object_unref (self->type_module_type), NULL))), _tmp49);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp50;
		_tmp50 = NULL;
		self->module_init_fragment = (_tmp50 = vala_ccode_fragment_new (), (self->module_init_fragment == NULL ? NULL : (self->module_init_fragment = (g_object_unref (self->module_init_fragment), NULL))), _tmp50);
		{
			GeeCollection* parameter_collection;
			GeeIterator* parameter_it;
			parameter_collection = vala_method_get_parameters (vala_code_context_get_module_init_method (context));
			parameter_it = gee_iterable_iterator (GEE_ITERABLE (parameter_collection));
			while (gee_iterator_next (parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = ((ValaFormalParameter*) gee_iterator_get (parameter_it));
				{
					if (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->type_module_type) {
						char* _tmp52;
						const char* _tmp51;
						self->in_plugin = TRUE;
						_tmp52 = NULL;
						_tmp51 = NULL;
						self->module_init_param_name = (_tmp52 = (_tmp51 = vala_symbol_get_name (VALA_SYMBOL (parameter)), (_tmp51 == NULL ? NULL : g_strdup (_tmp51))), (self->module_init_param_name = (g_free (self->module_init_param_name), NULL)), _tmp52);
						(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
						break;
					}
					(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
				}
			}
			(parameter_collection == NULL ? NULL : (parameter_collection = (g_object_unref (parameter_collection), NULL)));
			(parameter_it == NULL ? NULL : (parameter_it = (g_object_unref (parameter_it), NULL)));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaInterface* _tmp53;
		ValaInterface* _tmp54;
		ValaInterface* _tmp55;
		ValaInterface* _tmp56;
		_tmp53 = NULL;
		self->iterable_type = (_tmp53 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")), (self->iterable_type == NULL ? NULL : (self->iterable_type = (g_object_unref (self->iterable_type), NULL))), _tmp53);
		_tmp54 = NULL;
		self->iterator_type = (_tmp54 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->iterator_type == NULL ? NULL : (self->iterator_type = (g_object_unref (self->iterator_type), NULL))), _tmp54);
		_tmp55 = NULL;
		self->list_type = (_tmp55 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->list_type == NULL ? NULL : (self->list_type = (g_object_unref (self->list_type), NULL))), _tmp55);
		_tmp56 = NULL;
		self->map_type = (_tmp56 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->map_type == NULL ? NULL : (self->map_type = (g_object_unref (self->map_type), NULL))), _tmp56);
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaTypesymbol* _tmp57;
		_tmp57 = NULL;
		self->dbus_object_type = (_tmp57 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Object")), (self->dbus_object_type == NULL ? NULL : (self->dbus_object_type = (g_object_unref (self->dbus_object_type), NULL))), _tmp57);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeCollection* file_collection;
		GeeIterator* file_it;
		file_collection = source_files;
		file_it = gee_iterable_iterator (GEE_ITERABLE (file_collection));
		while (gee_iterator_next (file_it)) {
			ValaSourceFile* file;
			file = ((ValaSourceFile*) gee_iterator_get (file_it));
			{
				if (!vala_source_file_get_external_package (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
				(file == NULL ? NULL : (file = (g_object_unref (file), NULL)));
			}
		}
		(file_it == NULL ? NULL : (file_it = (g_object_unref (file_it), NULL)));
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (g_object_unref (gee_ns), NULL)));
	(dbus_ns == NULL ? NULL : (dbus_ns = (g_object_unref (dbus_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_object_unref (source_files), NULL)));
}


static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (cl))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (iface))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaCCodeGenerator * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaCCodeNewline* _tmp11;
	ValaCCodeNewline* _tmp12;
	char* _tmp13;
	char* _tmp14;
	char* macro;
	ValaCCodeMacroReplacement* _tmp16;
	char* _tmp15;
	ValaCCodeInitializerList* clist;
	ValaCCodeInitializerList* clist_ev;
	ValaCCodeInitializerList* _tmp24;
	ValaCCodeConstant* _tmp25;
	ValaCCodeConstant* _tmp26;
	ValaCCodeConstant* _tmp27;
	ValaCCodeVariableDeclarator* enum_decl;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeBlock* type_init;
	char* _tmp30;
	char* _tmp31;
	char* fun_name;
	ValaCCodeFunction* regfun;
	ValaCCodeBlock* regblock;
	ValaCCodeDeclaration* _tmp32;
	char* _tmp33;
	char* _tmp34;
	char* type_id_name;
	ValaCCodeVariableDeclarator* _tmp36;
	ValaCCodeConstant* _tmp35;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp43;
	char* _tmp42;
	char* _tmp41;
	ValaCCodeIdentifier* _tmp44;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeAssignment* _tmp46;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeFunctionCall* _tmp49;
	ValaCCodeFunctionCall* cond;
	ValaCCodeBinaryExpression* _tmp52;
	ValaCCodeConstant* _tmp51;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp54;
	ValaCCodeConstant* _tmp53;
	ValaCCodeNewline* _tmp57;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->cenum = (_tmp1 = vala_ccode_enum_new ((_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (en), FALSE))), (self->cenum == NULL ? NULL : (self->cenum = (g_object_unref (self->cenum), NULL))), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en))) != NULL) {
		ValaCCodeComment* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->header_type_definition, VALA_CCODE_NODE ((_tmp2 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (en)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp4;
		ValaCCodeFragment* _tmp3;
		ValaCCodeFragment* _tmp6;
		ValaCCodeFragment* _tmp5;
		_tmp4 = NULL;
		_tmp3 = NULL;
		decl_frag = (_tmp4 = (_tmp3 = self->header_type_declaration, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp4);
		_tmp6 = NULL;
		_tmp5 = NULL;
		def_frag = (_tmp6 = (_tmp5 = self->header_type_definition, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp6);
	} else {
		ValaCCodeFragment* _tmp8;
		ValaCCodeFragment* _tmp7;
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp9;
		_tmp8 = NULL;
		_tmp7 = NULL;
		decl_frag = (_tmp8 = (_tmp7 = self->source_type_declaration, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp8);
		_tmp10 = NULL;
		_tmp9 = NULL;
		def_frag = (_tmp10 = (_tmp9 = self->source_type_definition, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp10);
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->cenum));
	_tmp11 = NULL;
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp11 = vala_ccode_newline_new ())));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	if (!vala_enum_get_has_type_id (en)) {
		(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
		(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
		return;
	}
	_tmp12 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp12 = vala_ccode_newline_new ())));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	_tmp14 = NULL;
	macro = (_tmp14 = g_strdup_printf ("(%s_get_type ())", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp16 = vala_ccode_macro_replacement_new ((_tmp15 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (en), "TYPE_")), macro))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp15 = (g_free (_tmp15), NULL);
	clist = vala_ccode_initializer_list_new ();
	/* or during visit time? */
	clist_ev = NULL;
	{
		GeeCollection* ev_collection;
		GeeIterator* ev_it;
		ev_collection = vala_enum_get_values (en);
		ev_it = gee_iterable_iterator (GEE_ITERABLE (ev_collection));
		while (gee_iterator_next (ev_it)) {
			ValaEnumValue* ev;
			ev = ((ValaEnumValue*) gee_iterator_get (ev_it));
			{
				ValaCCodeInitializerList* _tmp17;
				ValaCCodeConstant* _tmp19;
				char* _tmp18;
				ValaCCodeIdentifier* _tmp22;
				char* _tmp21;
				char* _tmp20;
				ValaCCodeConstant* _tmp23;
				_tmp17 = NULL;
				clist_ev = (_tmp17 = vala_ccode_initializer_list_new (), (clist_ev == NULL ? NULL : (clist_ev = (g_object_unref (clist_ev), NULL))), _tmp17);
				_tmp19 = NULL;
				_tmp18 = NULL;
				vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ((_tmp18 = vala_enum_value_get_cname (ev))))));
				(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				_tmp18 = (g_free (_tmp18), NULL);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp20 = NULL;
				vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = g_strdup_printf ("\"%s\"", (_tmp20 = vala_enum_value_get_cname (ev))))))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				_tmp21 = (g_free (_tmp21), NULL);
				_tmp20 = (g_free (_tmp20), NULL);
				_tmp23 = NULL;
				vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp23 = vala_enum_value_get_canonical_cconstant (ev))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (clist_ev));
				(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
			}
		}
		(ev_collection == NULL ? NULL : (ev_collection = (g_object_unref (ev_collection), NULL)));
		(ev_it == NULL ? NULL : (ev_it = (g_object_unref (ev_it), NULL)));
	}
	_tmp24 = NULL;
	clist_ev = (_tmp24 = vala_ccode_initializer_list_new (), (clist_ev == NULL ? NULL : (clist_ev = (g_object_unref (clist_ev), NULL))), _tmp24);
	_tmp25 = NULL;
	vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("0"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	_tmp26 = NULL;
	vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ("NULL"))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	vala_ccode_initializer_list_append (clist_ev, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("NULL"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (clist_ev));
	enum_decl = vala_ccode_variable_declarator_new_with_initializer ("values[]", VALA_CCODE_EXPRESSION (clist));
	cdecl_ = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeDeclaration* _tmp28;
		_tmp28 = NULL;
		cdecl_ = (_tmp28 = vala_ccode_declaration_new ("const GFlagsValue"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp28);
	} else {
		ValaCCodeDeclaration* _tmp29;
		_tmp29 = NULL;
		cdecl_ = (_tmp29 = vala_ccode_declaration_new ("const GEnumValue"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp29);
	}
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (enum_decl));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	type_init = vala_ccode_block_new ();
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (cdecl_));
	_tmp30 = NULL;
	_tmp31 = NULL;
	fun_name = (_tmp31 = g_strdup_printf ("%s_get_type", (_tmp30 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL))), (_tmp30 = (g_free (_tmp30), NULL)), _tmp31);
	regfun = vala_ccode_function_new (fun_name, "GType");
	regblock = vala_ccode_block_new ();
	_tmp32 = NULL;
	cdecl_ = (_tmp32 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp32);
	_tmp33 = NULL;
	_tmp34 = NULL;
	type_id_name = (_tmp34 = g_strdup_printf ("%s_type_id", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL))), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34);
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp36 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("0")))))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_block_add_statement (regblock, VALA_CCODE_NODE (cdecl_));
	reg_call = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeIdentifier* _tmp37;
		_tmp38 = NULL;
		_tmp37 = NULL;
		reg_call = (_tmp38 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("g_flags_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp38);
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	} else {
		ValaCCodeFunctionCall* _tmp40;
		ValaCCodeIdentifier* _tmp39;
		_tmp40 = NULL;
		_tmp39 = NULL;
		reg_call = (_tmp40 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("g_enum_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp40);
		(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	}
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_constant_new ((_tmp42 = g_strdup_printf ("\"%s\"", (_tmp41 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (en), FALSE))))))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp44 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ("values"))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp47 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
	(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
	(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
	_tmp48 = NULL;
	_tmp49 = NULL;
	cond = (_tmp49 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("G_UNLIKELY")))), (_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL))), _tmp49);
	_tmp52 = NULL;
	_tmp51 = NULL;
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_constant_new ("0")))))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
	(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
	cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
	vala_ccode_block_add_statement (regblock, VALA_CCODE_NODE (cif));
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (regblock, VALA_CCODE_NODE ((_tmp54 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_constant_new (type_id_name)))))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	if (vala_symbol_get_access (VALA_SYMBOL (en)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp55;
		_tmp55 = NULL;
		vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE ((_tmp55 = vala_ccode_function_copy (regfun))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	} else {
		ValaCCodeFunction* _tmp56;
		_tmp56 = NULL;
		vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp56 = vala_ccode_function_copy (regfun))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	}
	vala_ccode_function_set_block (regfun, regblock);
	_tmp57 = NULL;
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE ((_tmp57 = vala_ccode_newline_new ())));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (regfun));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
	macro = (g_free (macro), NULL);
	(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	(clist_ev == NULL ? NULL : (clist_ev = (g_object_unref (clist_ev), NULL)));
	(enum_decl == NULL ? NULL : (enum_decl = (g_object_unref (enum_decl), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL ? NULL : (regfun = (g_object_unref (regfun), NULL)));
	(regblock == NULL ? NULL : (regblock = (g_object_unref (regblock), NULL)));
	type_id_name = (g_free (type_id_name), NULL);
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
}


static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	if (vala_enum_value_get_value (ev) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_enum_value_get_cname (ev)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept (VALA_CODE_NODE (vala_enum_value_get_value (ev)), VALA_CODE_VISITOR (self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp3 = vala_ccode_enum_value_new ((_tmp2 = vala_enum_value_get_cname (ev)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_enum_value_get_value (ev)))))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_generator_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaCCodeGenerator * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* _tmp4;
	char* quark_fun_name;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeMacroReplacement* _tmp7;
	ValaCCodeMacroReplacement* error_domain_define;
	char* _tmp8;
	ValaCCodeFunction* _tmp9;
	ValaCCodeFunction* cquark_fun;
	ValaCCodeBlock* cquark_block;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* cquark_call;
	ValaCCodeConstant* _tmp15;
	char* _tmp14;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeReturnStatement* _tmp16;
	ValaCCodeFunction* _tmp17;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ERROR_DOMAIN (edomain));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->cenum = (_tmp1 = vala_ccode_enum_new ((_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (edomain), FALSE))), (self->cenum == NULL ? NULL : (self->cenum = (g_object_unref (self->cenum), NULL))), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (edomain))) != NULL) {
		ValaCCodeComment* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->header_type_definition, VALA_CCODE_NODE ((_tmp2 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (edomain)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	vala_ccode_fragment_append (self->header_type_definition, VALA_CCODE_NODE (self->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (edomain), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp4 = NULL;
	quark_fun_name = (_tmp4 = g_strconcat ((_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (edomain))), "quark", NULL), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	error_domain_define = (_tmp7 = vala_ccode_macro_replacement_new ((_tmp5 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (edomain), NULL)), (_tmp6 = g_strconcat (quark_fun_name, " ()", NULL))), (_tmp6 = (g_free (_tmp6), NULL)), (_tmp5 = (g_free (_tmp5), NULL)), _tmp7);
	vala_ccode_fragment_append (self->header_type_definition, VALA_CCODE_NODE (error_domain_define));
	_tmp8 = NULL;
	_tmp9 = NULL;
	cquark_fun = (_tmp9 = vala_ccode_function_new (quark_fun_name, (_tmp8 = vala_typesymbol_get_cname (vala_data_type_get_data_type (self->gquark_type), FALSE))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
	cquark_block = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	cquark_call = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp11);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (cquark_call, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strconcat ((_tmp13 = g_strconcat ("\"", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (edomain), NULL)), NULL)), "-quark\"", NULL))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp16 = NULL;
	vala_ccode_block_add_statement (cquark_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cquark_call)))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE ((_tmp17 = vala_ccode_function_copy (cquark_fun))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	vala_ccode_function_set_block (cquark_fun, cquark_block);
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (cquark_fun));
	quark_fun_name = (g_free (quark_fun_name), NULL);
	(error_domain_define == NULL ? NULL : (error_domain_define = (g_object_unref (error_domain_define), NULL)));
	(cquark_fun == NULL ? NULL : (cquark_fun = (g_object_unref (cquark_fun), NULL)));
	(cquark_block == NULL ? NULL : (cquark_block = (g_object_unref (cquark_block), NULL)));
	(cquark_call == NULL ? NULL : (cquark_call = (g_object_unref (cquark_call), NULL)));
}


static void vala_ccode_generator_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ERROR_CODE (ecode));
	if (vala_error_code_get_value (ecode) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_error_code_get_cname (ecode)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept (VALA_CODE_NODE (vala_error_code_get_value (ecode)), VALA_CODE_VISITOR (self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->cenum, (_tmp3 = vala_ccode_enum_value_new ((_tmp2 = vala_error_code_get_cname (ecode)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_error_code_get_value (ecode)))))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaCCodeGenerator * self;
	char* _tmp0;
	ValaCCodeFunctionDeclarator* _tmp1;
	ValaCCodeFunctionDeclarator* cfundecl;
	char* _tmp2;
	ValaCCodeTypeDefinition* _tmp3;
	ValaCCodeTypeDefinition* ctypedef;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DELEGATE (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cfundecl = (_tmp1 = vala_ccode_function_declarator_new ((_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (d), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	{
		GeeList* param_collection;
		GeeIterator* param_it;
		param_collection = vala_delegate_get_parameters (d);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	ctypedef = (_tmp3 = vala_ccode_type_definition_new ((_tmp2 = vala_data_type_get_cname (vala_delegate_get_return_type (d))), VALA_CCODE_DECLARATOR (cfundecl)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
	if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (d))) {
		vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->source_type_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* _tmp1;
		char* _tmp0;
		ValaCCodeExpressionStatement* _tmp10;
		ValaCCodeAssignment* _tmp9;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeMemberAccess* _tmp5;
		char* _tmp4;
		ValaCCodeMemberAccess* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* _tmp16;
		char* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp17;
		gboolean _tmp18;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_struct_add_field (self->instance_priv_struct, (_tmp0 = vala_data_type_get_cname (self->mutex_type)), (_tmp1 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m))));
		_tmp1 = (g_free (_tmp1), NULL);
		_tmp0 = (g_free (_tmp0), NULL);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->instance_init_fragment, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp4 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_method_get_cname (vala_class_get_default_construction_method ((VALA_CLASS (vala_data_type_get_data_type (self->mutex_type)))))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp4 = (g_free (_tmp4), NULL);
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		self->priv->requires_free_checked = TRUE;
		_tmp11 = NULL;
		_tmp12 = NULL;
		fc = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("VALA_FREE_CHECKED")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp15 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		_tmp15 = (g_free (_tmp15), NULL);
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp17 = NULL;
		if ((_tmp18 = (_tmp17 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (self->mutex_type))) == NULL, (_tmp17 = (g_free (_tmp17), NULL)), _tmp18)) {
			char* _tmp20;
			char* _tmp19;
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_data_type_get_data_type (self->mutex_type))), (_tmp20 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp19 = vala_symbol_get_full_name (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type)))))));
			_tmp20 = (g_free (_tmp20), NULL);
			_tmp19 = (g_free (_tmp19), NULL);
			(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
			return;
		}
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (self->mutex_type)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp21 = (g_free (_tmp21), NULL);
		if (self->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp23;
			_tmp23 = NULL;
			vala_ccode_fragment_append (self->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (c)) && !(VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c)))) {
		char* _tmp0;
		ValaCCodeMacroReplacement* _tmp1;
		ValaCCodeMacroReplacement* cdefine;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cdefine = (_tmp1 = vala_ccode_macro_replacement_new_with_expression ((_tmp0 = vala_constant_get_cname (c)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
		vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE (cdefine));
		(cdefine == NULL ? NULL : (cdefine = (g_object_unref (cdefine), NULL)));
	} else {
		char* _tmp2;
		ValaCCodeDeclaration* _tmp3;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* _tmp7;
		char* _tmp6;
		char* _tmp5;
		_tmp2 = NULL;
		_tmp3 = NULL;
		cdecl_ = (_tmp3 = vala_ccode_declaration_new ((_tmp2 = vala_data_type_get_const_cname (vala_constant_get_type_reference (c)))), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c))) {
			char* _tmp4;
			_tmp4 = NULL;
			arr = (_tmp4 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), _tmp4);
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp7 = vala_ccode_variable_declarator_new_with_initializer ((_tmp6 = g_strdup_printf ("%s%s", (_tmp5 = vala_constant_get_cname (c)), arr)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp6 = (g_free (_tmp6), NULL);
		_tmp5 = (g_free (_tmp5), NULL);
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (c))) {
			vala_ccode_fragment_append (self->header_constant_declaration, VALA_CCODE_NODE (cdecl_));
		} else {
			vala_ccode_fragment_append (self->source_constant_declaration, VALA_CCODE_NODE (cdecl_));
		}
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		arr = (g_free (arr), NULL);
	}
}


static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaCCodeGenerator * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	char* field_ctype;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (f)), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	is_gtypeinstance = (cl != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gtypeinstance_type));
	lhs = NULL;
	st = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_type_reference (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp2;
		_tmp2 = NULL;
		field_ctype = (_tmp2 = g_strconcat ("volatile ", field_ctype, NULL), (field_ctype = (g_free (field_ctype), NULL)), _tmp2);
	}
	if (vala_symbol_get_access (VALA_SYMBOL (f)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
			ValaCCodeStruct* _tmp4;
			ValaCCodeStruct* _tmp3;
			ValaCCodeExpression* _tmp7;
			char* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			_tmp4 = NULL;
			_tmp3 = NULL;
			st = (_tmp4 = (_tmp3 = self->instance_struct, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp4);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			lhs = (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("self"))), (_tmp6 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		} else {
			if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
				ValaCCodeStruct* _tmp9;
				ValaCCodeStruct* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				st = (_tmp9 = (_tmp8 = self->type_struct, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp9);
			} else {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp11;
				char* _tmp10;
				char* _tmp12;
				ValaCCodeVariableDeclarator* _tmp13;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp14;
				ValaCCodeDeclaration* var_def;
				ValaCCodeExpression* _tmp17;
				char* _tmp16;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp11 = vala_ccode_variable_declarator_new ((_tmp10 = vala_field_get_cname (f))))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
				_tmp10 = (g_free (_tmp10), NULL);
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
				_tmp12 = NULL;
				_tmp13 = NULL;
				var_decl = (_tmp13 = vala_ccode_variable_declarator_new ((_tmp12 = vala_field_get_cname (f))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
				_tmp14 = NULL;
				vala_ccode_variable_declarator_set_initializer (var_decl, (_tmp14 = vala_ccode_generator_default_value_for_type (self, vala_field_get_type_reference (f), TRUE)));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp15;
					ValaCCodeExpression* init;
					_tmp15 = NULL;
					init = (_tmp15 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp15 == NULL ? NULL : g_object_ref (_tmp15)));
					if (vala_ccode_generator_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
				var_def = vala_ccode_declaration_new (field_ctype);
				vala_ccode_declaration_add_declarator (var_def, VALA_CCODE_DECLARATOR (var_decl));
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE (var_def));
				_tmp17 = NULL;
				_tmp16 = NULL;
				lhs = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp16 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp17);
				_tmp16 = (g_free (_tmp16), NULL);
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				(var_def == NULL ? NULL : (var_def = (g_object_unref (var_def), NULL)));
			}
		}
	} else {
		if (vala_symbol_get_access (VALA_SYMBOL (f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				if (is_gtypeinstance) {
					ValaCCodeStruct* _tmp19;
					ValaCCodeStruct* _tmp18;
					ValaCCodeExpression* _tmp23;
					char* _tmp22;
					ValaCCodeMemberAccess* _tmp21;
					ValaCCodeIdentifier* _tmp20;
					_tmp19 = NULL;
					_tmp18 = NULL;
					st = (_tmp19 = (_tmp18 = self->instance_priv_struct, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp19);
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp20 = NULL;
					lhs = (_tmp23 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp22 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp23);
					_tmp22 = (g_free (_tmp22), NULL);
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
				} else {
					ValaCCodeStruct* _tmp25;
					ValaCCodeStruct* _tmp24;
					ValaCCodeExpression* _tmp28;
					char* _tmp27;
					ValaCCodeIdentifier* _tmp26;
					_tmp25 = NULL;
					_tmp24 = NULL;
					st = (_tmp25 = (_tmp24 = self->instance_struct, (_tmp24 == NULL ? NULL : g_object_ref (_tmp24))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp25);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp26 = NULL;
					lhs = (_tmp28 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("self"))), (_tmp27 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp28);
					_tmp27 = (g_free (_tmp27), NULL);
					(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				}
			} else {
				ValaCCodeDeclaration* cdecl_;
				char* _tmp29;
				ValaCCodeVariableDeclarator* _tmp30;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp33;
				char* _tmp32;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp29 = NULL;
				_tmp30 = NULL;
				var_decl = (_tmp30 = vala_ccode_variable_declarator_new ((_tmp29 = vala_field_get_cname (f))), (_tmp29 = (g_free (_tmp29), NULL)), _tmp30);
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp31;
					ValaCCodeExpression* init;
					_tmp31 = NULL;
					init = (_tmp31 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
					if (vala_ccode_generator_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
				_tmp33 = NULL;
				_tmp32 = NULL;
				lhs = (_tmp33 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp32 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp33);
				_tmp32 = (g_free (_tmp32), NULL);
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
			}
		}
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		char* _tmp34;
		_tmp34 = NULL;
		vala_ccode_struct_add_field (st, field_ctype, (_tmp34 = vala_field_get_cname (f)));
		_tmp34 = (g_free (_tmp34), NULL);
		if (VALA_IS_ARRAY_TYPE (vala_field_get_type_reference (f)) && !vala_field_get_no_array_length (f)) {
			ValaArrayType* _tmp35;
			ValaArrayType* array_type;
			/* create fields to store array dimensions*/
			_tmp35 = NULL;
			array_type = (_tmp35 = VALA_ARRAY_TYPE (vala_field_get_type_reference (f)), (_tmp35 == NULL ? NULL : g_object_ref (_tmp35)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaDataType* len_type;
					char* _tmp37;
					char* _tmp36;
					len_type = vala_data_type_copy (self->int_type);
					_tmp37 = NULL;
					_tmp36 = NULL;
					vala_ccode_struct_add_field (st, (_tmp36 = vala_data_type_get_cname (len_type)), (_tmp37 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (f)), dim)));
					_tmp37 = (g_free (_tmp37), NULL);
					_tmp36 = (g_free (_tmp36), NULL);
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_field_get_type_reference (f))) {
				ValaDelegateType* _tmp38;
				ValaDelegateType* delegate_type;
				_tmp38 = NULL;
				delegate_type = (_tmp38 = VALA_DELEGATE_TYPE (vala_field_get_type_reference (f)), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)));
				if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
					char* _tmp39;
					/* create field to store delegate target*/
					_tmp39 = NULL;
					vala_ccode_struct_add_field (st, "gpointer", (_tmp39 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (f)))));
					_tmp39 = (g_free (_tmp39), NULL);
				}
				(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
			}
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp40;
			ValaCCodeExpression* rhs;
			ValaCCodeExpression* _tmp41;
			ValaCCodeExpressionStatement* _tmp43;
			ValaCCodeAssignment* _tmp42;
			_tmp40 = NULL;
			rhs = (_tmp40 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp40 == NULL ? NULL : g_object_ref (_tmp40)));
			_tmp41 = NULL;
			rhs = (_tmp41 = vala_ccode_generator_get_implicit_cast_expression (self, rhs, vala_expression_get_static_type (vala_field_get_initializer (f)), vala_field_get_type_reference (f)), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp41);
			_tmp43 = NULL;
			_tmp42 = NULL;
			vala_ccode_fragment_append (self->instance_init_fragment, VALA_CCODE_NODE ((_tmp43 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
			if (VALA_IS_ARRAY_TYPE (vala_field_get_type_reference (f)) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaArrayType* _tmp44;
				ValaArrayType* array_type;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp44 = NULL;
				array_type = (_tmp44 = VALA_ARRAY_TYPE (vala_field_get_type_reference (f)), (_tmp44 == NULL ? NULL : g_object_ref (_tmp44)));
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (f)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp46;
						ValaCCodeAssignment* _tmp45;
						array_len_lhs = vala_ccode_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), dim);
						size = ((ValaExpression*) gee_list_get (((GeeList*) sizes), dim - 1));
						_tmp46 = NULL;
						_tmp45 = NULL;
						vala_ccode_fragment_append (self->instance_init_fragment, VALA_CCODE_NODE ((_tmp46 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
						(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
						(array_len_lhs == NULL ? NULL : (array_len_lhs = (g_object_unref (array_len_lhs), NULL)));
						(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
					}
				}
				(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(sizes == NULL ? NULL : (sizes = (g_object_unref (sizes), NULL)));
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
		if (vala_data_type_get_takes_ownership (vala_field_get_type_reference (f)) && self->instance_dispose_fragment != NULL) {
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp48;
			ValaCCodeExpression* _tmp47;
			ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (f)), NULL);
			vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
			_tmp48 = NULL;
			_tmp47 = NULL;
			vala_ccode_fragment_append (self->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp48 = vala_ccode_expression_statement_new ((_tmp47 = vala_ccode_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f), VALA_EXPRESSION (ma)))))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			char* _tmp49;
			_tmp49 = NULL;
			vala_ccode_struct_add_field (st, field_ctype, (_tmp49 = vala_field_get_cname (f)));
			_tmp49 = (g_free (_tmp49), NULL);
		} else {
			/* add array length fields where necessary */
			if (VALA_IS_ARRAY_TYPE (vala_field_get_type_reference (f)) && !vala_field_get_no_array_length (f)) {
				ValaArrayType* _tmp50;
				ValaArrayType* array_type;
				_tmp50 = NULL;
				array_type = (_tmp50 = VALA_ARRAY_TYPE (vala_field_get_type_reference (f)), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaDataType* len_type;
						char* _tmp51;
						ValaCCodeDeclaration* _tmp52;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp55;
						char* _tmp54;
						char* _tmp53;
						len_type = vala_data_type_copy (self->int_type);
						_tmp51 = NULL;
						_tmp52 = NULL;
						cdecl_ = (_tmp52 = vala_ccode_declaration_new ((_tmp51 = vala_data_type_get_cname (len_type))), (_tmp51 = (g_free (_tmp51), NULL)), _tmp52);
						_tmp55 = NULL;
						_tmp54 = NULL;
						_tmp53 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp55 = vala_ccode_variable_declarator_new ((_tmp54 = vala_ccode_generator_get_array_length_cname (self, (_tmp53 = vala_field_get_cname (f)), dim))))));
						(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
						_tmp54 = (g_free (_tmp54), NULL);
						_tmp53 = (g_free (_tmp53), NULL);
						if (vala_symbol_get_access (VALA_SYMBOL (f)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
						}
						(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
				}
				(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_field_get_type_reference (f))) {
					ValaDelegateType* _tmp56;
					ValaDelegateType* delegate_type;
					_tmp56 = NULL;
					delegate_type = (_tmp56 = VALA_DELEGATE_TYPE (vala_field_get_type_reference (f)), (_tmp56 == NULL ? NULL : g_object_ref (_tmp56)));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp59;
						char* _tmp58;
						char* _tmp57;
						/* create field to store delegate target*/
						cdecl_ = vala_ccode_declaration_new ("gpointer");
						_tmp59 = NULL;
						_tmp58 = NULL;
						_tmp57 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp59 = vala_ccode_variable_declarator_new ((_tmp58 = vala_ccode_generator_get_delegate_target_cname (self, (_tmp57 = vala_field_get_cname (f))))))));
						(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
						_tmp58 = (g_free (_tmp58), NULL);
						_tmp57 = (g_free (_tmp57), NULL);
						if (vala_symbol_get_access (VALA_SYMBOL (f)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
						}
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
				}
			}
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp60;
				ValaCCodeExpression* rhs;
				_tmp60 = NULL;
				rhs = (_tmp60 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp60 == NULL ? NULL : g_object_ref (_tmp60)));
				if (!vala_ccode_generator_is_constant_ccode_expression (self, rhs)) {
					if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (f)))) {
						ValaCCodeExpressionStatement* _tmp62;
						ValaCCodeAssignment* _tmp61;
						_tmp62 = NULL;
						_tmp61 = NULL;
						vala_ccode_fragment_append (self->class_init_fragment, VALA_CCODE_NODE ((_tmp62 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
						(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
					} else {
						vala_code_node_set_error (VALA_CODE_NODE (f), TRUE);
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (f)), "Non-constant field initializers not supported in this context");
						(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
						(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
						field_ctype = (g_free (field_ctype), NULL);
						return;
					}
				}
				(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
			}
		}
	}
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	field_ctype = (g_free (field_ctype), NULL);
}


static gboolean vala_ccode_generator_is_constant_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp4;
	ValaCCodeExpression* _tmp3;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			return (_tmp2 = vala_ccode_generator_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary)) && vala_ccode_generator_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary)), (cbinary == NULL ? NULL : (cbinary = (g_object_unref (cbinary), NULL))), _tmp2);
		}
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	cparenthesized = (_tmp4 = ((_tmp3 = cexpr, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp3) ? ((ValaCCodeParenthesizedExpression*) _tmp3) : NULL))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	return (_tmp5 = (NULL != cparenthesized && vala_ccode_generator_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized))), (cparenthesized == NULL ? NULL : (cparenthesized = (g_object_unref (cparenthesized), NULL))), _tmp5);
}


/**
 * Returns whether the passed cexpr is a pure expression, i.e. an
 * expression without side-effects.
 */
gboolean vala_ccode_generator_is_pure_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp6;
	ValaCCodeExpression* _tmp5;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp7;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr) || VALA_IS_CCODE_IDENTIFIER (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			return (_tmp2 = vala_ccode_generator_is_pure_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary)) && vala_ccode_generator_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary)), (cbinary == NULL ? NULL : (cbinary = (g_object_unref (cbinary), NULL))), _tmp2);
		} else {
			if (VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
				ValaCCodeMemberAccess* _tmp3;
				ValaCCodeMemberAccess* cma;
				gboolean _tmp4;
				_tmp3 = NULL;
				cma = (_tmp3 = VALA_CCODE_MEMBER_ACCESS (cexpr), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
				return (_tmp4 = vala_ccode_generator_is_pure_ccode_expression (self, vala_ccode_member_access_get_inner (cma)), (cma == NULL ? NULL : (cma = (g_object_unref (cma), NULL))), _tmp4);
			}
		}
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	cparenthesized = (_tmp6 = ((_tmp5 = cexpr, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp5) ? ((ValaCCodeParenthesizedExpression*) _tmp5) : NULL))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	return (_tmp7 = (NULL != cparenthesized && vala_ccode_generator_is_pure_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized))), (cparenthesized == NULL ? NULL : (cparenthesized = (g_object_unref (cparenthesized), NULL))), _tmp7);
}


static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (m))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (m))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		char* ctypename;
		const char* _tmp0;
		char* cname;
		ValaCCodeFormalParameter* _tmp4;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_type_reference (p));
		_tmp0 = NULL;
		cname = (_tmp0 = vala_symbol_get_name (VALA_SYMBOL (p)), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
		/* pass non-simple structs always by reference*/
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p)))) {
			ValaStruct* _tmp1;
			ValaStruct* st;
			_tmp1 = NULL;
			st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (!vala_struct_is_simple_type (st) && vala_formal_parameter_get_direction (p) == VALA_PARAMETER_DIRECTION_IN && !vala_data_type_get_nullable (vala_formal_parameter_get_type_reference (p))) {
				char* _tmp2;
				_tmp2 = NULL;
				ctypename = (_tmp2 = g_strconcat (ctypename, ("*"), NULL), (ctypename = (g_free (ctypename), NULL)), _tmp2);
			}
			(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
		}
		if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp3;
			_tmp3 = NULL;
			ctypename = (_tmp3 = g_strconcat (ctypename, ("*"), NULL), (ctypename = (g_free (ctypename), NULL)), _tmp3);
		}
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((_tmp4 = vala_ccode_formal_parameter_new (cname, ctypename))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		ctypename = (g_free (ctypename), NULL);
		cname = (g_free (cname), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp5;
		_tmp5 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((_tmp5 = vala_ccode_formal_parameter_new_with_ellipsis ())));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	}
}


static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaCCodeGenerator * self;
	gint old_next_temp_var_id;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	old_next_temp_var_id = self->next_temp_var_id;
	self->next_temp_var_id = 0;
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	self->next_temp_var_id = old_next_temp_var_id;
	/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet
	 don't register private properties*/
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))) && !vala_data_type_is_real_struct_type (vala_property_get_type_reference (prop)) && vala_symbol_get_access (VALA_SYMBOL (prop)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->prop_enum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_property_get_upper_case_cname (prop)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		_tmp0 = (g_free (_tmp0), NULL);
	}
}


static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaCCodeGenerator * self;
	ValaPropertyAccessor* _tmp1;
	ValaPropertyAccessor* _tmp0;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	gboolean returns_real_struct;
	ValaDataType* _tmp6;
	ValaTypesymbol* _tmp7;
	ValaTypesymbol* t;
	ValaReferenceType* this_type;
	char* _tmp10;
	ValaCCodeFormalParameter* _tmp11;
	ValaCCodeFormalParameter* cselfparam;
	ValaDataType* value_type;
	char* _tmp12;
	ValaCCodeFormalParameter* _tmp13;
	ValaCCodeFormalParameter* cvalueparam;
	ValaPropertyAccessor* _tmp77;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_property_accessor = (_tmp1 = (_tmp0 = acc, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (g_object_unref (self->current_property_accessor), NULL))), _tmp1);
	self->current_method_inner_error = FALSE;
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_type_reference (prop));
	if (vala_property_accessor_get_readable (acc) && !returns_real_struct) {
		ValaDataType* _tmp4;
		ValaDataType* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		self->current_return_type = (_tmp4 = (_tmp3 = vala_property_get_type_reference (prop), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (self->current_return_type == NULL ? NULL : (self->current_return_type = (g_object_unref (self->current_return_type), NULL))), _tmp4);
	} else {
		ValaDataType* _tmp5;
		_tmp5 = NULL;
		self->current_return_type = (_tmp5 = VALA_DATA_TYPE (vala_void_type_new ()), (self->current_return_type == NULL ? NULL : (self->current_return_type = (g_object_unref (self->current_return_type), NULL))), _tmp5);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	_tmp6 = NULL;
	self->current_return_type = (_tmp6 = NULL, (self->current_return_type == NULL ? NULL : (self->current_return_type = (g_object_unref (self->current_return_type), NULL))), _tmp6);
	_tmp7 = NULL;
	t = (_tmp7 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	this_type = NULL;
	if (VALA_IS_CLASS (t)) {
		ValaReferenceType* _tmp8;
		_tmp8 = NULL;
		this_type = (_tmp8 = VALA_REFERENCE_TYPE (vala_class_instance_type_new (VALA_CLASS (t))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp8);
	} else {
		ValaReferenceType* _tmp9;
		_tmp9 = NULL;
		this_type = (_tmp9 = VALA_REFERENCE_TYPE (vala_interface_instance_type_new (VALA_INTERFACE (t))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp9);
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	cselfparam = (_tmp11 = vala_ccode_formal_parameter_new ("self", (_tmp10 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type)))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	value_type = vala_data_type_copy (vala_property_get_type_reference (prop));
	vala_data_type_set_takes_ownership (value_type, vala_data_type_get_transfers_ownership (value_type));
	_tmp12 = NULL;
	_tmp13 = NULL;
	cvalueparam = (_tmp13 = vala_ccode_formal_parameter_new ("value", (_tmp12 = vala_data_type_get_cname (value_type))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp17;
			char* _tmp16;
			char* _tmp15;
			char* _tmp14;
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			self->function = (_tmp17 = vala_ccode_function_new ((_tmp15 = g_strdup_printf ("%s_get_%s", (_tmp14 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop)))), (_tmp16 = vala_data_type_get_cname (vala_property_get_type_reference (prop)))), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp17);
			_tmp16 = (g_free (_tmp16), NULL);
			_tmp15 = (g_free (_tmp15), NULL);
			_tmp14 = (g_free (_tmp14), NULL);
		} else {
			ValaCCodeFunction* _tmp20;
			char* _tmp19;
			char* _tmp18;
			_tmp20 = NULL;
			_tmp19 = NULL;
			_tmp18 = NULL;
			self->function = (_tmp20 = vala_ccode_function_new ((_tmp19 = g_strdup_printf ("%s_set_%s", (_tmp18 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop)))), "void"), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp20);
			_tmp19 = (g_free (_tmp19), NULL);
			_tmp18 = (g_free (_tmp18), NULL);
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop)) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc)) && vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFunction* _tmp21;
			/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
			_tmp21 = NULL;
			vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE ((_tmp21 = vala_ccode_function_copy (self->function))));
			(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		} else {
			ValaCCodeFunction* _tmp22;
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp22 = NULL;
			vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp22 = vala_ccode_function_copy (self->function))));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->function, block);
		if (vala_property_accessor_get_readable (acc)) {
			char* _tmp23;
			ValaCCodeDeclaration* _tmp24;
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* _tmp25;
			ValaCCodeIdentifier* _tmp26;
			ValaCCodeFunctionCall* _tmp27;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeFunctionCall* _tmp29;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeConstant* _tmp31;
			ValaCCodeUnaryExpression* _tmp33;
			ValaCCodeIdentifier* _tmp32;
			ValaCCodeConstant* _tmp34;
			ValaCCodeExpressionStatement* _tmp35;
			ValaCCodeReturnStatement* _tmp45;
			ValaCCodeIdentifier* _tmp44;
			/* declare temporary variable to save the property value*/
			_tmp23 = NULL;
			_tmp24 = NULL;
			decl = (_tmp24 = vala_ccode_declaration_new ((_tmp23 = vala_data_type_get_cname (vala_property_get_type_reference (prop)))), (_tmp23 = (g_free (_tmp23), NULL)), _tmp24);
			_tmp25 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp25 = vala_ccode_variable_declarator_new ("value"))));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			_tmp26 = NULL;
			_tmp27 = NULL;
			ccall = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_object_get")))), (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27);
			_tmp28 = NULL;
			_tmp29 = NULL;
			ccast = (_tmp29 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp29);
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("self"))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_property_get_canonical_cconstant (prop))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			_tmp33 = NULL;
			_tmp32 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("value")))))));
			(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			_tmp34 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("NULL"))));
			(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
			_tmp35 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			/* HACK: decrement the refcount before returning the value to simulate a weak reference getter function*/
			if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeConstant* _tmp37;
				ValaCCodeIdentifier* _tmp36;
				ValaCCodeBinaryExpression* _tmp38;
				ValaCCodeBinaryExpression* unref_cond;
				ValaCCodeExpression* _tmp39;
				ValaCCodeFunctionCall* _tmp40;
				ValaCCodeFunctionCall* unref_function;
				ValaCCodeIdentifier* _tmp41;
				ValaCCodeBlock* unref_block;
				ValaCCodeExpressionStatement* _tmp42;
				ValaCCodeIfStatement* _tmp43;
				_tmp37 = NULL;
				_tmp36 = NULL;
				_tmp38 = NULL;
				unref_cond = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("value"))), VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("NULL")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp38);
				_tmp39 = NULL;
				_tmp40 = NULL;
				unref_function = (_tmp40 = vala_ccode_function_call_new ((_tmp39 = vala_ccode_generator_get_destroy_func_expression (self, vala_property_get_type_reference (prop)))), (_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL))), _tmp40);
				_tmp41 = NULL;
				vala_ccode_function_call_add_argument (unref_function, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("value"))));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				unref_block = vala_ccode_block_new ();
				_tmp42 = NULL;
				vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (unref_function)))));
				(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				_tmp43 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp43 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (unref_cond), VALA_CCODE_STATEMENT (unref_block), NULL))));
				(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
				(unref_cond == NULL ? NULL : (unref_cond = (g_object_unref (unref_cond), NULL)));
				(unref_function == NULL ? NULL : (unref_function = (g_object_unref (unref_function), NULL)));
				(unref_block == NULL ? NULL : (unref_block = (g_object_unref (unref_block), NULL)));
			}
			_tmp45 = NULL;
			_tmp44 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp45 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ("value")))))));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
			(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp46;
			ValaCCodeFunctionCall* _tmp47;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp48;
			ValaCCodeFunctionCall* _tmp49;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp50;
			ValaCCodeConstant* _tmp51;
			ValaCCodeIdentifier* _tmp52;
			ValaCCodeConstant* _tmp53;
			ValaCCodeExpressionStatement* _tmp54;
			_tmp46 = NULL;
			_tmp47 = NULL;
			ccall = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("g_object_set")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
			_tmp48 = NULL;
			_tmp49 = NULL;
			ccast = (_tmp49 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL))), _tmp49);
			_tmp50 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("self"))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			_tmp51 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp51 = vala_property_get_canonical_cconstant (prop))));
			(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
			_tmp52 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("value"))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
			_tmp53 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_constant_new ("NULL"))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
			_tmp54 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (self->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL);
		if (is_virtual) {
			char* _tmp55;
			_tmp55 = NULL;
			prefix = (_tmp55 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp55);
		}
		if (vala_property_accessor_get_readable (acc)) {
			if (returns_real_struct) {
				ValaCCodeFunction* _tmp57;
				char* _tmp56;
				/* return non simple structs as out parameter*/
				_tmp57 = NULL;
				_tmp56 = NULL;
				self->function = (_tmp57 = vala_ccode_function_new ((_tmp56 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))), "void"), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp57);
				_tmp56 = (g_free (_tmp56), NULL);
			} else {
				ValaCCodeFunction* _tmp60;
				char* _tmp59;
				char* _tmp58;
				_tmp60 = NULL;
				_tmp59 = NULL;
				_tmp58 = NULL;
				self->function = (_tmp60 = vala_ccode_function_new ((_tmp58 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))), (_tmp59 = vala_data_type_get_cname (vala_property_get_type_reference (prop)))), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp60);
				_tmp59 = (g_free (_tmp59), NULL);
				_tmp58 = (g_free (_tmp58), NULL);
			}
		} else {
			ValaCCodeFunction* _tmp62;
			char* _tmp61;
			_tmp62 = NULL;
			_tmp61 = NULL;
			self->function = (_tmp62 = vala_ccode_function_new ((_tmp61 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))), "void"), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp62);
			_tmp61 = (g_free (_tmp61), NULL);
		}
		if (is_virtual) {
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		if (returns_real_struct) {
			char* _tmp63;
			char* _tmp64;
			char* coutparamname;
			ValaCCodeFormalParameter* coutparam;
			/* return non simple structs as out parameter*/
			_tmp63 = NULL;
			_tmp64 = NULL;
			coutparamname = (_tmp64 = g_strdup_printf ("%s*", (_tmp63 = vala_data_type_get_cname (vala_property_get_type_reference (prop)))), (_tmp63 = (g_free (_tmp63), NULL)), _tmp64);
			coutparam = vala_ccode_formal_parameter_new ("value", coutparamname);
			vala_ccode_function_add_parameter (self->function, coutparam);
			coutparamname = (g_free (coutparamname), NULL);
			(coutparam == NULL ? NULL : (coutparam = (g_object_unref (coutparam), NULL)));
		} else {
			if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
				vala_ccode_function_add_parameter (self->function, cvalueparam);
			}
		}
		if (!is_virtual) {
			if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop)) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc)) && vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp65;
				/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
				_tmp65 = NULL;
				vala_ccode_fragment_append (self->header_type_member_declaration, VALA_CCODE_NODE ((_tmp65 = vala_ccode_function_copy (self->function))));
				(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
			} else {
				ValaCCodeFunction* _tmp66;
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp66 = NULL;
				vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp66 = vala_ccode_function_copy (self->function))));
				(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
			}
		}
		vala_ccode_function_set_block (self->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_accessor_get_body (acc)))));
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp68;
			ValaCCodeConstant* _tmp67;
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp68 = NULL;
			_tmp67 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp68 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_constant_new ("NULL")))))));
			(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
			(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), VALA_CCODE_NODE (cdecl_));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
		if (returns_real_struct) {
			ValaCCodeStatement* _tmp69;
			_tmp69 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), VALA_CCODE_NODE ((_tmp69 = vala_ccode_generator_create_property_type_check_statement (self, prop, FALSE, t, TRUE, "self"))));
			(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
		} else {
			ValaCCodeStatement* _tmp70;
			_tmp70 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), VALA_CCODE_NODE ((_tmp70 = vala_ccode_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
		}
		/* notify on property changes*/
		if (vala_property_get_notify (prop) && (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc))) {
			ValaCCodeIdentifier* _tmp71;
			ValaCCodeFunctionCall* _tmp72;
			ValaCCodeFunctionCall* notify_call;
			ValaCCodeCastExpression* _tmp74;
			ValaCCodeIdentifier* _tmp73;
			ValaCCodeConstant* _tmp75;
			ValaCCodeExpressionStatement* _tmp76;
			_tmp71 = NULL;
			_tmp72 = NULL;
			notify_call = (_tmp72 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("g_object_notify")))), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), _tmp72);
			_tmp74 = NULL;
			_tmp73 = NULL;
			vala_ccode_function_call_add_argument (notify_call, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("self"))), "GObject *"))));
			(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
			(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
			_tmp75 = NULL;
			vala_ccode_function_call_add_argument (notify_call, VALA_CCODE_EXPRESSION ((_tmp75 = vala_property_get_canonical_cconstant (prop))));
			(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
			_tmp76 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->function), VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (notify_call)))));
			(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
			(notify_call == NULL ? NULL : (notify_call = (g_object_unref (notify_call), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (self->function));
		prefix = (g_free (prefix), NULL);
	}
	_tmp77 = NULL;
	self->current_property_accessor = (_tmp77 = NULL, (self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (g_object_unref (self->current_property_accessor), NULL))), _tmp77);
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(value_type == NULL ? NULL : (value_type = (g_object_unref (value_type), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaCCodeGenerator * self;
	ValaClass* _tmp0;
	ValaClass* cl;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	self->current_method_inner_error = FALSE;
	self->priv->in_constructor = TRUE;
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	self->priv->in_constructor = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (c))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeFunction* _tmp3;
		char* _tmp2;
		char* _tmp1;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeFormalParameter* _tmp6;
		ValaCCodeFunction* _tmp7;
		ValaCCodeBlock* cblock;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp8;
		ValaCCodeDeclaration* _tmp11;
		char* _tmp10;
		char* _tmp9;
		ValaCCodeVariableDeclarator* _tmp12;
		ValaCCodeDeclaration* _tmp13;
		ValaCCodeVariableDeclarator* _tmp14;
		ValaCCodeIdentifier* _tmp15;
		ValaCCodeFunctionCall* _tmp16;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp18;
		char* _tmp17;
		ValaCCodeIdentifier* _tmp21;
		char* _tmp20;
		char* _tmp19;
		ValaCCodeFunctionCall* _tmp22;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpressionStatement* _tmp25;
		ValaCCodeAssignment* _tmp24;
		ValaCCodeIdentifier* _tmp23;
		ValaCCodeFunctionCall* _tmp27;
		ValaCCodeIdentifier* _tmp26;
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeFunctionCall* _tmp30;
		ValaCCodeIdentifier* _tmp29;
		ValaCCodeExpressionStatement* _tmp33;
		ValaCCodeAssignment* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeFunctionCall* _tmp36;
		ValaCCodeMemberAccess* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeExpressionStatement* _tmp42;
		ValaCCodeAssignment* _tmp41;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeFunctionCall* _tmp44;
		ValaCCodeIdentifier* _tmp43;
		ValaCCodeDeclaration* _tmp47;
		char* _tmp46;
		char* _tmp45;
		ValaCCodeVariableDeclarator* _tmp48;
		ValaCCodeReturnStatement* _tmp52;
		ValaCCodeIdentifier* _tmp51;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->function = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_constructor", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "GObject *"), (self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL))), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp1 = (g_free (_tmp1), NULL);
		vala_ccode_function_set_modifiers (self->function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp4 = vala_ccode_formal_parameter_new ("type", "GType")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp5 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_add_parameter (self->function, (_tmp6 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		_tmp7 = NULL;
		vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp7 = vala_ccode_function_copy (self->function))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		cblock = vala_ccode_block_new ();
		cdecl_ = vala_ccode_declaration_new ("GObject *");
		_tmp8 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp8 = vala_ccode_variable_declarator_new ("obj"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%sClass *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp11);
		_tmp10 = (g_free (_tmp10), NULL);
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp12 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new ("klass"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		_tmp13 = NULL;
		cdecl_ = (_tmp13 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp13);
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new ("parent_class"))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		_tmp15 = NULL;
		_tmp16 = NULL;
		ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_type_class_peek")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ((_tmp17 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_"))))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp22 = NULL;
		ccast = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		_tmp27 = NULL;
		_tmp26 = NULL;
		ccall = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp27);
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
		_tmp28 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("klass"))));
		(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
		_tmp30 = NULL;
		_tmp29 = NULL;
		ccast = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), _tmp30);
		(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		ccall = (_tmp36 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("parent_class"))), "constructor")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp36);
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		_tmp37 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("type"))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("n_construct_properties"))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("construct_properties"))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
		_tmp42 = NULL;
		_tmp41 = NULL;
		_tmp40 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("obj"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		_tmp44 = NULL;
		_tmp43 = NULL;
		ccall = (_tmp44 = VALA_CCODE_FUNCTION_CALL (vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("obj"))), VALA_TYPESYMBOL (cl))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp44);
		(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
		_tmp47 = NULL;
		_tmp46 = NULL;
		_tmp45 = NULL;
		cdecl_ = (_tmp47 = vala_ccode_declaration_new ((_tmp46 = g_strdup_printf ("%s *", (_tmp45 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp47);
		_tmp46 = (g_free (_tmp46), NULL);
		_tmp45 = (g_free (_tmp45), NULL);
		_tmp48 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp48 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp50;
			ValaCCodeConstant* _tmp49;
			/* always separate error parameter and inner_error local variable
			 * as error may be set to NULL but we're always interested in inner errors
			 */
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp50 = NULL;
			_tmp49 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp50 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("NULL")))))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
		_tmp52 = NULL;
		_tmp51 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp52 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("obj")))))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		vala_ccode_function_set_block (self->function, cblock);
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c))) != NULL) {
			ValaCCodeComment* _tmp53;
			_tmp53 = NULL;
			vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE ((_tmp53 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c)))))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (self->function));
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	} else {
		if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
			char* _tmp55;
			char* _tmp54;
			ValaCCodeFunction* _tmp56;
			ValaCCodeFunction* base_init;
			ValaCCodeFormalParameter* _tmp59;
			char* _tmp58;
			char* _tmp57;
			ValaCCodeFunction* _tmp60;
			/* class constructor*/
			_tmp55 = NULL;
			_tmp54 = NULL;
			_tmp56 = NULL;
			base_init = (_tmp56 = vala_ccode_function_new ((_tmp55 = g_strdup_printf ("%s_base_init", (_tmp54 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp55 = (g_free (_tmp55), NULL)), (_tmp54 = (g_free (_tmp54), NULL)), _tmp56);
			_tmp59 = NULL;
			_tmp58 = NULL;
			_tmp57 = NULL;
			vala_ccode_function_add_parameter (base_init, (_tmp59 = vala_ccode_formal_parameter_new ("klass", (_tmp58 = g_strdup_printf ("%sClass *", (_tmp57 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			_tmp58 = (g_free (_tmp58), NULL);
			_tmp57 = (g_free (_tmp57), NULL);
			vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
			_tmp60 = NULL;
			vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp60 = vala_ccode_function_copy (base_init))));
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			vala_ccode_function_set_block (base_init, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c)))));
			vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (base_init));
			(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
		} else {
			if (vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC) {
				/* static class constructor
				 add to class_init*/
				if (self->current_method_inner_error) {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp62;
					ValaCCodeConstant* _tmp61;
					/* always separate error parameter and inner_error local variable
					 * as error may be set to NULL but we're always interested in inner errors
					 */
					cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp62 = NULL;
					_tmp61 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp62 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_constant_new ("NULL")))))));
					(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
					(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
					vala_ccode_fragment_append (self->class_init_fragment, VALA_CCODE_NODE (cdecl_));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				}
				vala_ccode_fragment_append (self->class_init_fragment, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
			} else {
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (c)), "internal error: constructors must have instance, class, or static binding");
			}
		}
	}
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
}


static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaCCodeGenerator * self;
	ValaSymbol* _tmp1;
	ValaBlock* _tmp0;
	GeeCollection* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp14;
	ValaSymbol* _tmp13;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_symbol = (_tmp1 = VALA_SYMBOL ((_tmp0 = b, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)))), (self->current_symbol == NULL ? NULL : (self->current_symbol = (g_object_unref (self->current_symbol), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (b), VALA_CODE_VISITOR (self));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = local_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				vala_symbol_set_active (VALA_SYMBOL (local), FALSE);
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	cblock = vala_ccode_block_new ();
	{
		GeeCollection* stmt_collection;
		GeeIterator* stmt_it;
		stmt_collection = vala_block_get_statements (b);
		stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
		while (gee_iterator_next (stmt_it)) {
			ValaCodeNode* stmt;
			stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (stmt_it)));
			{
				ValaSourceReference* _tmp2;
				ValaSourceReference* src;
				_tmp2 = NULL;
				src = (_tmp2 = vala_code_node_get_source_reference (stmt), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* _tmp3;
					_tmp3 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp3 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
					{
						GeeCollection* cstmt_collection;
						GeeIterator* cstmt_it;
						cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
						cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
						while (gee_iterator_next (cstmt_it)) {
							ValaCCodeNode* cstmt;
							cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
							{
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
							}
						}
						(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
						(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
				}
				(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
		(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
	}
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = local_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				if (vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp7;
					ValaCCodeExpression* _tmp6;
					ValaCCodeIdentifier* _tmp5;
					char* _tmp4;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
					_tmp7 = NULL;
					_tmp6 = NULL;
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new ((_tmp6 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma)))))));
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
					_tmp4 = (g_free (_tmp4), NULL);
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (VALA_SYMBOL (b)))) {
		ValaMethod* _tmp8;
		ValaMethod* m;
		_tmp8 = NULL;
		m = (_tmp8 = VALA_METHOD (vala_symbol_get_parent_symbol (VALA_SYMBOL (b))), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = vala_method_get_parameters (m);
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) gee_iterator_get (param_it));
				{
					if (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_data_type_get_takes_ownership (vala_formal_parameter_get_type_reference (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* _tmp12;
						ValaCCodeExpression* _tmp11;
						ValaCCodeIdentifier* _tmp10;
						char* _tmp9;
						ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (param)), NULL);
						vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (param));
						_tmp12 = NULL;
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new ((_tmp11 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (param))))))), vala_formal_parameter_get_type_reference (param), VALA_EXPRESSION (ma)))))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
						(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
						(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
						_tmp9 = (g_free (_tmp9), NULL);
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock));
	_tmp14 = NULL;
	_tmp13 = NULL;
	self->current_symbol = (_tmp14 = (_tmp13 = vala_symbol_get_parent_symbol (self->current_symbol), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (self->current_symbol == NULL ? NULL : (self->current_symbol = (g_object_unref (self->current_symbol), NULL))), _tmp14);
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_empty_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_declaration_statement_get_declaration (stmt))));
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (stmt), (VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (local != NULL && vala_local_variable_get_initializer (local) != NULL) {
		vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_local_variable_get_initializer (local)->temp_vars));
	}
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (self->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
}


char* vala_ccode_generator_get_variable_cname (ValaCCodeGenerator* self, const char* name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_collection_contains (GEE_COLLECTION (self->c_keywords), name)) {
		return g_strconcat (name, "_", NULL);
	} else {
		const char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = name, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	}
}


static void vala_ccode_generator_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* rhs;
	char* _tmp40;
	ValaCCodeVariableDeclarator* _tmp41;
	ValaCCodeVariableDeclarator* cvar;
	ValaCCodeFragment* cfrag;
	char* _tmp42;
	ValaCCodeDeclaration* _tmp43;
	ValaCCodeDeclaration* cdecl_;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LOCAL_VARIABLE (local));
	vala_code_node_accept_children (VALA_CODE_NODE (local), VALA_CODE_VISITOR (self));
	if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
		ValaArrayType* _tmp0;
		ValaArrayType* array_type;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp2;
				ValaDataType* _tmp1;
				ValaLocalVariable* _tmp3;
				ValaLocalVariable* len_var;
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp3 = NULL;
				len_var = (_tmp3 = vala_local_variable_new ((_tmp1 = vala_data_type_copy (self->int_type)), (_tmp2 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)), dim)), NULL, NULL), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp3);
				gee_list_insert (GEE_LIST (self->temp_vars), 0, len_var);
				(len_var == NULL ? NULL : (len_var = (g_object_unref (len_var), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaDelegateType* _tmp4;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp5;
			ValaDelegate* d;
			_tmp4 = NULL;
			deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
			_tmp5 = NULL;
			d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp8;
				ValaPointerType* _tmp7;
				ValaVoidType* _tmp6;
				ValaLocalVariable* _tmp9;
				ValaLocalVariable* target_var;
				/* create variable to store delegate target*/
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp9 = NULL;
				target_var = (_tmp9 = vala_local_variable_new (VALA_DATA_TYPE ((_tmp7 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp6 = vala_void_type_new ()))))), (_tmp8 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)))), NULL, NULL), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp9);
				gee_list_insert (GEE_LIST (self->temp_vars), 0, target_var);
				(target_var == NULL ? NULL : (target_var = (g_object_unref (target_var), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	rhs = NULL;
	if (vala_local_variable_get_initializer (local) != NULL && vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_local_variable_get_initializer (local))) != NULL) {
		ValaCCodeExpression* _tmp11;
		ValaCCodeExpression* _tmp10;
		ValaCCodeExpression* _tmp12;
		_tmp11 = NULL;
		_tmp10 = NULL;
		rhs = (_tmp11 = (_tmp10 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_local_variable_get_initializer (local)))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp11);
		_tmp12 = NULL;
		rhs = (_tmp12 = vala_ccode_generator_get_implicit_cast_expression (self, rhs, vala_expression_get_static_type (vala_local_variable_get_initializer (local)), vala_local_variable_get_variable_type (local)), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp12);
		if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaArrayType* _tmp13;
			ValaArrayType* array_type;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_var;
			ValaCCodeAssignment* _tmp15;
			ValaCCodeIdentifier* _tmp14;
			ValaCCodeIdentifier* _tmp19;
			ValaCCodeExpression* _tmp21;
			ValaCCodeCommaExpression* _tmp20;
			_tmp13 = NULL;
			array_type = (_tmp13 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			ccomma = vala_ccode_comma_expression_new ();
			temp_var = vala_ccode_generator_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, VALA_CODE_NODE (local));
			gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_var);
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp16;
					ValaCCodeIdentifier* _tmp17;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp18;
					_tmp16 = NULL;
					_tmp17 = NULL;
					lhs_array_len = (_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)), dim))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
					rhs_array_len = vala_ccode_generator_get_array_length_cexpression (self, vala_local_variable_get_initializer (local), dim);
					_tmp18 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (g_object_unref (rhs_array_len), NULL)));
				}
			}
			_tmp19 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
			_tmp21 = NULL;
			_tmp20 = NULL;
			rhs = (_tmp21 = VALA_CCODE_EXPRESSION ((_tmp20 = ccomma, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp21);
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaDelegateType* _tmp22;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp23;
				ValaDelegate* d;
				_tmp22 = NULL;
				deleg_type = (_tmp22 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
				_tmp23 = NULL;
				d = (_tmp23 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)));
				if (vala_delegate_get_has_target (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp25;
					ValaCCodeIdentifier* _tmp24;
					char* _tmp26;
					ValaCCodeIdentifier* _tmp27;
					ValaCCodeIdentifier* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp28;
					ValaCCodeIdentifier* _tmp29;
					ValaCCodeExpression* _tmp31;
					ValaCCodeCommaExpression* _tmp30;
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_generator_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, VALA_CODE_NODE (local));
					gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_var);
					_tmp25 = NULL;
					_tmp24 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp26 = NULL;
					_tmp27 = NULL;
					lhs_delegate_target = (_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
					rhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (self, vala_local_variable_get_initializer (local));
					_tmp28 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_delegate_target), rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
					_tmp29 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))));
					(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
					_tmp31 = NULL;
					_tmp30 = NULL;
					rhs = (_tmp31 = VALA_CCODE_EXPRESSION ((_tmp30 = ccomma, (_tmp30 == NULL ? NULL : g_object_ref (_tmp30)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp31);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (g_object_unref (lhs_delegate_target), NULL)));
					(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (g_object_unref (rhs_delegate_target), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
	} else {
		if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
			ValaCCodeExpression* _tmp32;
			_tmp32 = NULL;
			rhs = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp32);
			if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaArrayType* _tmp33;
				ValaArrayType* array_type;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp39;
				ValaCCodeCommaExpression* _tmp38;
				/* initialize array length variables*/
				_tmp33 = NULL;
				array_type = (_tmp33 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)));
				ccomma = vala_ccode_comma_expression_new ();
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeAssignment* _tmp37;
						ValaCCodeConstant* _tmp36;
						ValaCCodeIdentifier* _tmp35;
						char* _tmp34;
						_tmp37 = NULL;
						_tmp36 = NULL;
						_tmp35 = NULL;
						_tmp34 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)), dim))))), VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
						(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
						(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
						_tmp34 = (g_free (_tmp34), NULL);
					}
				}
				vala_ccode_comma_expression_append_expression (ccomma, rhs);
				_tmp39 = NULL;
				_tmp38 = NULL;
				rhs = (_tmp39 = VALA_CCODE_EXPRESSION ((_tmp38 = ccomma, (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp39);
				(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			}
		}
	}
	_tmp40 = NULL;
	_tmp41 = NULL;
	cvar = (_tmp41 = vala_ccode_variable_declarator_new_with_initializer ((_tmp40 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)))), rhs), (_tmp40 = (g_free (_tmp40), NULL)), _tmp41);
	cfrag = vala_ccode_fragment_new ();
	_tmp42 = NULL;
	_tmp43 = NULL;
	cdecl_ = (_tmp43 = vala_ccode_declaration_new ((_tmp42 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)))), (_tmp42 = (g_free (_tmp42), NULL)), _tmp43);
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (cvar));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
	if (vala_local_variable_get_initializer (local) != NULL && vala_expression_get_can_fail (vala_local_variable_get_initializer (local))) {
		vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_local_variable_get_initializer (local)), cfrag);
	}
	/* try to initialize uninitialized variables */
	if (vala_ccode_variable_declarator_get_initializer (cvar) == NULL) {
		ValaCCodeExpression* _tmp44;
		_tmp44 = NULL;
		vala_ccode_variable_declarator_set_initializer (cvar, (_tmp44 = vala_ccode_generator_default_value_for_type (self, vala_local_variable_get_variable_type (local), TRUE)));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (local), VALA_CCODE_NODE (cfrag));
	vala_symbol_set_active (VALA_SYMBOL (local), TRUE);
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaCCodeGenerator * self;
	ValaCCodeInitializerList* clist;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	vala_code_node_accept_children (VALA_CODE_NODE (list), VALA_CODE_VISITOR (self));
	clist = vala_ccode_initializer_list_new ();
	{
		GeeCollection* expr_collection;
		GeeIterator* expr_it;
		expr_collection = vala_initializer_list_get_initializers (list);
		expr_it = gee_iterable_iterator (GEE_ITERABLE (expr_collection));
		while (gee_iterator_next (expr_it)) {
			ValaExpression* expr;
			expr = ((ValaExpression*) gee_iterator_get (expr_it));
			{
				ValaCCodeExpression* _tmp0;
				_tmp0 = NULL;
				vala_ccode_initializer_list_append (clist, (_tmp0 = vala_ccode_generator_get_implicit_cast_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), vala_expression_get_static_type (expr), vala_expression_get_expected_type (expr))));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			}
		}
		(expr_collection == NULL ? NULL : (expr_collection = (g_object_unref (expr_collection), NULL)));
		(expr_it == NULL ? NULL : (expr_it = (g_object_unref (expr_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist));
	(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
}


ValaLocalVariable* vala_ccode_generator_get_temp_variable (ValaCCodeGenerator* self, ValaDataType* type, gboolean takes_ownership, ValaCodeNode* node_reference) {
	ValaDataType* var_type;
	char* _tmp0;
	ValaLocalVariable* _tmp1;
	ValaLocalVariable* local;
	ValaLocalVariable* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	g_return_val_if_fail (node_reference == NULL || VALA_IS_CODE_NODE (node_reference), NULL);
	var_type = vala_data_type_copy (type);
	vala_data_type_set_takes_ownership (var_type, takes_ownership);
	_tmp0 = NULL;
	_tmp1 = NULL;
	local = (_tmp1 = vala_local_variable_new (var_type, (_tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id)), NULL, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference (VALA_CODE_NODE (local), vala_code_node_get_source_reference (node_reference));
	}
	self->next_temp_var_id++;
	_tmp2 = NULL;
	return (_tmp2 = local, (var_type == NULL ? NULL : (var_type = (g_object_unref (var_type), NULL))), _tmp2);
}


static ValaCCodeExpression* vala_ccode_generator_get_type_id_expression (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (type)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1));
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL) {
			char* _tmp3;
			char* _tmp4;
			char* var_name;
			ValaCCodeMemberAccess* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeMemberAccess* _tmp7;
			ValaCCodeMemberAccess* _tmp8;
			_tmp3 = NULL;
			_tmp4 = NULL;
			var_name = (_tmp4 = g_strdup_printf ("%s_type", (_tmp3 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			_tmp8 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp8 = (_tmp7 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("self"))), "priv"))), var_name), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7), (var_name = (g_free (var_name), NULL)), _tmp8));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_TYPE_NONE"));
		}
	}
}


static ValaCCodeExpression* vala_ccode_generator_get_dup_func_expression (ValaCCodeGenerator* self, ValaDataType* type, ValaSourceReference* source_reference) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* dup_function;
		ValaCCodeIdentifier* _tmp4;
		dup_function = NULL;
		if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
			char* _tmp0;
			_tmp0 = NULL;
			dup_function = (_tmp0 = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp0);
		} else {
			if (vala_data_type_get_data_type (type) == vala_data_type_get_data_type (self->string_type)) {
				char* _tmp1;
				_tmp1 = NULL;
				dup_function = (_tmp1 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp1);
			} else {
				char* _tmp2;
				gpointer _tmp3;
				/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
				_tmp2 = NULL;
				vala_report_error (source_reference, (_tmp2 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_data_type (type))))));
				_tmp2 = (g_free (_tmp2), NULL);
				return (_tmp3 = NULL, (dup_function = (g_free (dup_function), NULL)), _tmp3);
			}
		}
		_tmp4 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new (dup_function), (dup_function = (g_free (dup_function), NULL)), _tmp4));
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
			char* _tmp5;
			char* _tmp6;
			char* func_name;
			ValaCCodeMemberAccess* _tmp8;
			ValaCCodeIdentifier* _tmp7;
			ValaCCodeMemberAccess* _tmp9;
			ValaCCodeMemberAccess* _tmp10;
			_tmp5 = NULL;
			_tmp6 = NULL;
			func_name = (_tmp6 = g_strdup_printf ("%s_dup_func", (_tmp5 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp9 = NULL;
			_tmp10 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp10 = (_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp9), (func_name = (g_free (func_name), NULL)), _tmp10));
		} else {
			if (VALA_IS_ARRAY_TYPE (type)) {
				char* _tmp12;
				char* _tmp11;
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_report_error (source_reference, (_tmp12 = g_strdup_printf ("internal error: duplicating %s instances not yet supported", (_tmp11 = vala_code_node_to_string (VALA_CODE_NODE (type))))));
				_tmp12 = (g_free (_tmp12), NULL);
				_tmp11 = (g_free (_tmp11), NULL);
				return NULL;
			} else {
				if (VALA_IS_POINTER_TYPE (type)) {
					ValaPointerType* _tmp14;
					ValaPointerType* pointer_type;
					ValaCCodeExpression* _tmp15;
					_tmp14 = NULL;
					pointer_type = (_tmp14 = VALA_POINTER_TYPE (type), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
					_tmp15 = NULL;
					return (_tmp15 = vala_ccode_generator_get_dup_func_expression (self, vala_pointer_type_get_base_type (pointer_type), source_reference), (pointer_type == NULL ? NULL : (pointer_type = (g_object_unref (pointer_type), NULL))), _tmp15);
				} else {
					return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
				}
			}
		}
	}
}


static ValaCCodeExpression* vala_ccode_generator_get_destroy_func_expression (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->glist_type) || vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gslist_type)) {
		gboolean takes_ownership;
		ValaCCodeExpression* element_destroy_func_expression;
		/* create wrapper function to free list elements if necessary*/
		takes_ownership = FALSE;
		element_destroy_func_expression = NULL;
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_data_type_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) gee_iterator_get (type_arg_it));
				{
					takes_ownership = vala_data_type_get_takes_ownership (type_arg);
					if (takes_ownership) {
						ValaCCodeExpression* _tmp0;
						_tmp0 = NULL;
						element_destroy_func_expression = (_tmp0 = vala_ccode_generator_get_destroy_func_expression (self, type_arg), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (g_object_unref (element_destroy_func_expression), NULL))), _tmp0);
					}
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		if (takes_ownership && VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression)) {
			char* _tmp1;
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeIdentifier* _tmp3;
			_tmp1 = NULL;
			_tmp2 = NULL;
			_tmp3 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp3 = (_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_generator_generate_glist_free_wrapper (self, type, VALA_CCODE_IDENTIFIER (element_destroy_func_expression)))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (g_object_unref (element_destroy_func_expression), NULL))), _tmp3));
		} else {
			char* _tmp4;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeIdentifier* _tmp6;
			_tmp4 = NULL;
			_tmp5 = NULL;
			_tmp6 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp6 = (_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5), (element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (g_object_unref (element_destroy_func_expression), NULL))), _tmp6));
		}
		(element_destroy_func_expression == NULL ? NULL : (element_destroy_func_expression = (g_object_unref (element_destroy_func_expression), NULL)));
	} else {
		if (vala_data_type_get_data_type (type) != NULL) {
			char* unref_function;
			ValaCCodeIdentifier* _tmp12;
			unref_function = NULL;
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
				char* _tmp7;
				_tmp7 = NULL;
				unref_function = (_tmp7 = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp7);
			} else {
				char* _tmp8;
				_tmp8 = NULL;
				unref_function = (_tmp8 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp8);
			}
			if (unref_function == NULL) {
				char* _tmp10;
				char* _tmp9;
				gpointer _tmp11;
				_tmp10 = NULL;
				_tmp9 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_data_type_get_data_type (type))), (_tmp10 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp9 = vala_symbol_get_full_name (VALA_SYMBOL (vala_data_type_get_data_type (type)))))));
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp9 = (g_free (_tmp9), NULL);
				return (_tmp11 = NULL, (unref_function = (g_free (unref_function), NULL)), _tmp11);
			}
			_tmp12 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), _tmp12));
		} else {
			if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
				char* _tmp13;
				char* _tmp14;
				char* func_name;
				ValaCCodeMemberAccess* _tmp16;
				ValaCCodeIdentifier* _tmp15;
				ValaCCodeMemberAccess* _tmp17;
				ValaCCodeMemberAccess* _tmp18;
				_tmp13 = NULL;
				_tmp14 = NULL;
				func_name = (_tmp14 = g_strdup_printf ("%s_destroy_func", (_tmp13 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp17 = NULL;
				_tmp18 = NULL;
				return VALA_CCODE_EXPRESSION ((_tmp18 = (_tmp17 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp17), (func_name = (g_free (func_name), NULL)), _tmp18));
			} else {
				if (VALA_IS_ARRAY_TYPE (type)) {
					return VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_free"));
				} else {
					if (VALA_IS_POINTER_TYPE (type)) {
						return VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_free"));
					} else {
						return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
					}
				}
			}
		}
	}
}


static char* vala_ccode_generator_generate_glist_free_wrapper (ValaCCodeGenerator* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression) {
	char* _tmp0;
	char* _tmp1;
	char* destroy_func;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* element_free_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeCastExpression* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeIdentifier* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeFunction* _tmp18;
	char* _tmp19;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (list_type), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	destroy_func = (_tmp1 = g_strdup_printf ("_%s_%s", (_tmp0 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))), vala_ccode_identifier_get_name (element_destroy_func_expression)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	if (!vala_ccode_generator_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		return destroy_func;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("self", (_tmp3 = vala_data_type_get_cname (list_type)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	element_free_call = NULL;
	if (vala_data_type_get_data_type (list_type) == VALA_TYPESYMBOL (self->glist_type)) {
		ValaCCodeFunctionCall* _tmp6;
		ValaCCodeIdentifier* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		element_free_call = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_list_foreach")))), (element_free_call == NULL ? NULL : (element_free_call = (g_object_unref (element_free_call), NULL))), _tmp6);
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	} else {
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		element_free_call = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("g_slist_foreach")))), (element_free_call == NULL ? NULL : (element_free_call = (g_object_unref (element_free_call), NULL))), _tmp8);
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	}
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("self"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (element_destroy_func_expression), "GFunc"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("NULL"))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (element_free_call)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp15 = NULL;
	cfreecall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))))))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (cfreecall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("self"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	/* append to file*/
	_tmp18 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp18 = vala_ccode_function_copy (function))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (function));
	_tmp19 = NULL;
	return (_tmp19 = destroy_func, (function == NULL ? NULL : (function = (g_object_unref (function), NULL))), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), (element_free_call == NULL ? NULL : (element_free_call = (g_object_unref (element_free_call), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL))), _tmp19);
}


ValaCCodeExpression* vala_ccode_generator_get_unref_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeConstant* _tmp0;
	ValaCCodeBinaryExpression* _tmp1;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeExpression* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* _tmp17;
	ValaCCodeAssignment* cassign;
	char* _tmp18;
	gboolean _tmp19;
	gboolean uses_gfree;
	ValaCCodeParenthesizedExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeConditionalExpression* _tmp23;
	ValaCCodeConditionalExpression* _tmp24;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	_tmp0 = NULL;
	_tmp1 = NULL;
	cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_constant_new ("NULL")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	if (vala_data_type_get_type_parameter (type) != NULL) {
		ValaCCodeConstant* _tmp4;
		ValaCCodeExpression* _tmp3;
		ValaCCodeBinaryExpression* _tmp5;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp6;
		if (!(VALA_IS_CLASS (self->current_type_symbol)) || !vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->current_class), self->gobject_type)) {
			ValaCCodeConstant* _tmp2;
			_tmp2 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp2));
		}
		/* unref functions are optional for type parameters*/
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		cunrefisnull = (_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp3 = vala_ccode_generator_get_destroy_func_expression (self, type)), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("NULL")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
		_tmp6 = NULL;
		cisnull = (_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp6);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new ((_tmp7 = vala_ccode_generator_get_destroy_func_expression (self, type))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	if (vala_data_type_get_data_type (type) == self->gstringbuilder_type) {
		ValaCCodeConstant* _tmp9;
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("TRUE"))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaArrayType* _tmp10;
			ValaArrayType* array_type;
			_tmp10 = NULL;
			array_type = (_tmp10 = VALA_ARRAY_TYPE (type), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == NULL || vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)))) {
				gboolean first;
				ValaCCodeExpression* csizeexpr;
				ValaCCodeIdentifier* _tmp14;
				ValaCCodeCastExpression* _tmp16;
				ValaCCodeExpression* _tmp15;
				self->priv->requires_array_free = TRUE;
				first = TRUE;
				csizeexpr = NULL;
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						if (first) {
							ValaCCodeExpression* _tmp11;
							_tmp11 = NULL;
							csizeexpr = (_tmp11 = vala_ccode_generator_get_array_length_cexpression (self, expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp11);
							first = FALSE;
						} else {
							ValaCCodeExpression* _tmp13;
							ValaCCodeExpression* _tmp12;
							_tmp13 = NULL;
							_tmp12 = NULL;
							csizeexpr = (_tmp13 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (_tmp12 = vala_ccode_generator_get_array_length_cexpression (self, expr, dim)))), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp13);
							(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
						}
					}
				}
				_tmp14 = NULL;
				vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("_vala_array_free"))));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				vala_ccode_function_call_add_argument (ccall, csizeexpr);
				_tmp16 = NULL;
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_cast_expression_new ((_tmp15 = vala_ccode_generator_get_destroy_func_expression (self, vala_array_type_get_element_type (array_type))), "GDestroyNotify"))));
				(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				(csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL)));
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	_tmp17 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL"))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	_tmp18 = NULL;
	uses_gfree = (_tmp19 = (vala_data_type_get_data_type (type) != NULL && !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type)) && _vala_strcmp0 ((_tmp18 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), "g_free") == 0), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19);
	uses_gfree = uses_gfree || VALA_IS_ARRAY_TYPE (type);
	if (uses_gfree) {
		ValaCCodeParenthesizedExpression* _tmp20;
		_tmp20 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp20));
	}
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp23 = NULL;
	_tmp24 = NULL;
	return VALA_CCODE_EXPRESSION ((_tmp24 = (_tmp23 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign))))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), _tmp23), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp24));
}


static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	ValaLocalVariable* full_expr_var;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp4;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear (GEE_COLLECTION (expr->temp_vars));
	{
		GeeArrayList* local_collection;
		GeeIterator* local_it;
		local_collection = self->temp_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				gee_collection_add (GEE_COLLECTION (expr->temp_vars), local);
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	if (gee_collection_get_size (GEE_COLLECTION ((GEE_LIST (self->temp_ref_vars)))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	full_expr_var = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), full_expr_var);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (full_expr_var))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	{
		GeeArrayList* local_collection;
		GeeIterator* local_it;
		local_collection = self->temp_ref_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp3;
				ValaCCodeIdentifier* _tmp2;
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (local))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	_tmp4 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (full_expr_var))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list));
	gee_collection_clear (GEE_COLLECTION (self->temp_ref_vars));
	(full_expr_var == NULL ? NULL : (full_expr_var = (g_object_unref (full_expr_var), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_ccode_generator_append_temp_decl (ValaCCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	g_return_if_fail (GEE_IS_COLLECTION (temp_vars));
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = temp_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				ValaStruct* _tmp3;
				ValaTypesymbol* _tmp2;
				ValaStruct* st;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (local)));
				/* sets #line*/
				vala_code_node_set_ccodenode (VALA_CODE_NODE (local), VALA_CCODE_NODE (vardecl));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				st = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_local_variable_get_variable_type (local)), (VALA_IS_STRUCT (_tmp2) ? ((ValaStruct*) _tmp2) : NULL)), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
				if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
					ValaCCodeConstant* _tmp4;
					_tmp4 = NULL;
					vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("NULL"))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
				} else {
					if (st != NULL && !vala_struct_is_simple_type (st)) {
						ValaCCodeInitializerList* clist;
						ValaCCodeConstant* _tmp5;
						/* 0-initialize struct with struct initializer { 0 }
						 necessary as they will be passed by reference*/
						clist = vala_ccode_initializer_list_new ();
						_tmp5 = NULL;
						vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("0"))));
						(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
						vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION (clist));
						(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
					}
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
}


static void vala_ccode_generator_add_simple_check (ValaCCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag) {
	ValaCCodeFragment* cprint_frag;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeExpressionStatement* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeExpressionStatement* _tmp12;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	self->current_method_inner_error = TRUE;
	cprint_frag = vala_ccode_fragment_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccritical = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_critical")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("__FILE__"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("__LINE__"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), "message"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp7 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccritical)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	_tmp9 = NULL;
	cclear = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_clear_error")))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (cclear, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cclear)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	if (self->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeConstant* _tmp20;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeBinaryExpression* _tmp21;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeIfStatement* _tmp22;
		/* surrounding try found
		 TODO might be the wrong one when using nested try statements*/
		cerror_block = vala_ccode_block_new ();
		{
			GeeList* clause_collection;
			GeeIterator* clause_it;
			clause_collection = vala_try_statement_get_catch_clauses (self->current_try);
			clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
			while (gee_iterator_next (clause_it)) {
				ValaCatchClause* clause;
				clause = ((ValaCatchClause*) gee_iterator_get (clause_it));
				{
					ValaCCodeGotoStatement* cgoto_stmt;
					/* go to catch clause if error domain matches*/
					cgoto_stmt = vala_ccode_goto_statement_new (vala_catch_clause_get_clabel_name (clause));
					if (vala_data_type_equals (vala_catch_clause_get_error_type (clause), VALA_DATA_TYPE (self->gerror_type))) {
						/* general catch clause*/
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cgoto_stmt));
					} else {
						ValaCCodeIdentifier* _tmp16;
						char* _tmp15;
						ValaCCodeMemberAccess* _tmp14;
						ValaCCodeIdentifier* _tmp13;
						ValaCCodeBinaryExpression* _tmp17;
						ValaCCodeBinaryExpression* ccond;
						ValaCCodeBlock* cgoto_block;
						ValaCCodeIfStatement* _tmp18;
						_tmp16 = NULL;
						_tmp15 = NULL;
						_tmp14 = NULL;
						_tmp13 = NULL;
						_tmp17 = NULL;
						ccond = (_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("inner_error"))), "domain"))), VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ((_tmp15 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_catch_clause_get_error_type (clause)), NULL)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), (_tmp15 = (g_free (_tmp15), NULL)), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp17);
						cgoto_block = vala_ccode_block_new ();
						vala_ccode_block_add_statement (cgoto_block, VALA_CCODE_NODE (cgoto_stmt));
						_tmp18 = NULL;
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp18 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cgoto_block), NULL))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
						(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
						(cgoto_block == NULL ? NULL : (cgoto_block = (g_object_unref (cgoto_block), NULL)));
					}
					(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
					(cgoto_stmt == NULL ? NULL : (cgoto_stmt = (g_object_unref (cgoto_stmt), NULL)));
				}
			}
			(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
			(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
		}
		/* print critical message if no catch clause matches*/
		vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
		/* check error domain if expression failed*/
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp21 = NULL;
		ccond = (_tmp21 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("NULL")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp21);
		_tmp22 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp22 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	} else {
		GeeCollection* _tmp23;
		gboolean _tmp24;
		_tmp23 = NULL;
		if ((_tmp24 = self->current_method != NULL && gee_collection_get_size ((_tmp23 = vala_method_get_error_domains (self->current_method))) > 0, (_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL))), _tmp24)) {
			ValaCCodeIdentifier* _tmp25;
			ValaCCodeFunctionCall* _tmp26;
			ValaCCodeFunctionCall* cpropagate;
			ValaCCodeIdentifier* _tmp27;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeBlock* cerror_block;
			ValaCCodeExpressionStatement* _tmp29;
			ValaCCodeConstant* _tmp34;
			ValaCCodeIdentifier* _tmp33;
			ValaCCodeBinaryExpression* _tmp35;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp36;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			_tmp25 = NULL;
			_tmp26 = NULL;
			cpropagate = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("g_propagate_error")))), (_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL))), _tmp26);
			_tmp27 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("error"))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			_tmp28 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("inner_error"))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			cerror_block = vala_ccode_block_new ();
			_tmp29 = NULL;
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cpropagate)))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
			if (VALA_IS_VOID_TYPE (self->current_return_type)) {
				ValaCCodeReturnStatement* _tmp30;
				_tmp30 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp30 = vala_ccode_return_statement_new (NULL))));
				(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			} else {
				ValaCCodeReturnStatement* _tmp32;
				ValaCCodeExpression* _tmp31;
				_tmp32 = NULL;
				_tmp31 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp32 = vala_ccode_return_statement_new ((_tmp31 = vala_ccode_generator_default_value_for_type (self, self->current_return_type, FALSE))))));
				(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
				(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			}
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp35 = NULL;
			ccond = (_tmp35 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("NULL")))), (_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL))), (_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL))), _tmp35);
			_tmp36 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp36 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			(cpropagate == NULL ? NULL : (cpropagate = (g_object_unref (cpropagate), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeConstant* _tmp38;
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeBinaryExpression* _tmp39;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp40;
			/* TODO improve check and move to semantic analyzer*/
			vala_report_warning (vala_code_node_get_source_reference (node), "unhandled error");
			cerror_block = vala_ccode_block_new ();
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
			/* check error domain if expression failed*/
			_tmp38 = NULL;
			_tmp37 = NULL;
			_tmp39 = NULL;
			ccond = (_tmp39 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_constant_new ("NULL")))), (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp39);
			_tmp40 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp40 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		}
	}
	(cprint_frag == NULL ? NULL : (cprint_frag = (g_object_unref (cprint_frag), NULL)));
	(ccritical == NULL ? NULL : (ccritical = (g_object_unref (ccritical), NULL)));
	(cclear == NULL ? NULL : (cclear = (g_object_unref (cclear), NULL)));
}


static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeExpressionStatement* _tmp0;
	ValaCCodeFragment* cfrag;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_expression_statement_get_expression (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (stmt)) && vala_expression_get_can_fail (vala_expression_statement_get_expression (stmt))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)), cfrag);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (gee_collection_get_size (GEE_COLLECTION ((GEE_LIST (self->temp_vars)))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GeeArrayList* local_collection;
		GeeIterator* local_it;
		local_collection = self->temp_ref_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp3;
				ValaCCodeExpression* _tmp2;
				ValaCCodeIdentifier* _tmp1;
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (local))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma)))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->temp_ref_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_create_temp_decl (ValaCCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	g_return_if_fail (GEE_IS_COLLECTION (temp_vars));
	/* declare temporary variables */
	if (gee_collection_get_size (temp_vars) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_false_statement (stmt))))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), NULL))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	}
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_if_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaLocalVariable* temp_var;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	gboolean is_string_cmp;
	ValaCCodeExpressionStatement* _tmp14;
	GeeCollection* default_statements;
	gint label_count;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_var = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE, VALA_CODE_NODE (stmt));
	gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_var);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock));
	is_string_cmp = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_local_variable_get_variable_type (temp_var)), vala_data_type_get_data_type (self->string_type));
	if (is_string_cmp) {
		ValaCCodeConstant* _tmp0;
		ValaCCodeBinaryExpression* _tmp1;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeFunctionCall* _tmp3;
		ValaCCodeFunctionCall* cquark;
		ValaCCodeConstant* _tmp4;
		ValaCCodeConditionalExpression* _tmp5;
		ValaCCodeConditionalExpression* ccond;
		ValaLocalVariable* _tmp6;
		gint label_count;
		ValaCCodeExpressionStatement* _tmp11;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeAssignment* _tmp13;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION (ctemp)), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		_tmp2 = NULL;
		_tmp3 = NULL;
		cquark = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("g_quark_from_string")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		vala_ccode_function_call_add_argument (cquark, VALA_CCODE_EXPRESSION (ctemp));
		_tmp4 = NULL;
		_tmp5 = NULL;
		ccond = (_tmp5 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("0"))), VALA_CCODE_EXPRESSION (cquark)), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
		_tmp6 = NULL;
		temp_var = (_tmp6 = vala_ccode_generator_get_temp_variable (self, self->gquark_type, TRUE, NULL), (temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL))), _tmp6);
		gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_var);
		label_count = 0;
		{
			GeeCollection* section_collection;
			GeeIterator* section_it;
			section_collection = vala_switch_statement_get_sections (stmt);
			section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
			while (gee_iterator_next (section_it)) {
				ValaSwitchSection* section;
				section = ((ValaSwitchSection*) gee_iterator_get (section_it));
				{
					if (vala_switch_section_has_default_label (section)) {
						(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
						continue;
					}
					{
						GeeCollection* label_collection;
						GeeIterator* label_it;
						label_collection = vala_switch_section_get_labels (section);
						label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
						while (gee_iterator_next (label_it)) {
							ValaSwitchLabel* label;
							label = ((ValaSwitchLabel*) gee_iterator_get (label_it));
							{
								ValaCCodeExpression* _tmp7;
								ValaCCodeExpression* cexpr;
								_tmp7 = NULL;
								cexpr = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
								if (vala_ccode_generator_is_constant_ccode_expression (self, cexpr)) {
									char* cname;
									char* _tmp8;
									ValaCCodeDeclaration* _tmp9;
									ValaCCodeDeclaration* cdecl_;
									ValaCCodeVariableDeclarator* _tmp10;
									cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name (VALA_SYMBOL (temp_var)), label_count++);
									_tmp8 = NULL;
									_tmp9 = NULL;
									cdecl_ = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = vala_data_type_get_cname (self->gquark_type))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
									vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
									_tmp10 = NULL;
									vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer (cname, VALA_CCODE_EXPRESSION (czero)))));
									(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
									vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (cdecl_));
									cname = (g_free (cname), NULL);
									(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								}
								(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
								(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
							}
						}
						(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
						(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
					}
					(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
				}
			}
			(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
			(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
		}
		_tmp11 = NULL;
		vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		_tmp12 = NULL;
		ctemp = (_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), _tmp12);
		_tmp13 = NULL;
		cinit = (_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL))), _tmp13);
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(cquark == NULL ? NULL : (cquark = (g_object_unref (cquark), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	}
	_tmp14 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((_tmp14 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_switch_statement_get_expression (stmt)->temp_vars));
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeCollection* section_collection;
		GeeIterator* section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
		while (gee_iterator_next (section_it)) {
			ValaSwitchSection* section;
			section = ((ValaSwitchSection*) gee_iterator_get (section_it));
			{
				ValaCCodeBinaryExpression* cor;
				ValaCCodeBlock* cblock;
				ValaCCodeConstant* _tmp31;
				ValaCCodeDoStatement* _tmp32;
				ValaCCodeDoStatement* cdo;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp36;
				ValaCCodeIfStatement* _tmp35;
				if (vala_switch_section_has_default_label (section)) {
					GeeCollection* _tmp15;
					_tmp15 = NULL;
					default_statements = (_tmp15 = vala_block_get_statements (VALA_BLOCK (section)), (default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL))), _tmp15);
					(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
					continue;
				}
				cor = NULL;
				{
					GeeCollection* label_collection;
					GeeIterator* label_it;
					label_collection = vala_switch_section_get_labels (section);
					label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
					while (gee_iterator_next (label_it)) {
						ValaSwitchLabel* label;
						label = ((ValaSwitchLabel*) gee_iterator_get (label_it));
						{
							ValaCCodeExpression* _tmp16;
							ValaCCodeExpression* cexpr;
							ValaCCodeBinaryExpression* ccmp;
							_tmp16 = NULL;
							cexpr = (_tmp16 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
							if (is_string_cmp) {
								if (vala_ccode_generator_is_constant_ccode_expression (self, cexpr)) {
									char* _tmp17;
									ValaCCodeIdentifier* _tmp18;
									ValaCCodeIdentifier* cname;
									ValaCCodeBinaryExpression* ccond;
									ValaCCodeIdentifier* _tmp19;
									ValaCCodeFunctionCall* _tmp20;
									ValaCCodeFunctionCall* ccall;
									ValaCCodeAssignment* _tmp21;
									ValaCCodeParenthesizedExpression* _tmp22;
									ValaCCodeParenthesizedExpression* cinit;
									ValaCCodeExpression* _tmp23;
									_tmp17 = NULL;
									_tmp18 = NULL;
									cname = (_tmp18 = vala_ccode_identifier_new ((_tmp17 = g_strdup_printf ("%s_label%d", vala_symbol_get_name (VALA_SYMBOL (temp_var)), label_count++))), (_tmp17 = (g_free (_tmp17), NULL)), _tmp18);
									ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION (cname));
									_tmp19 = NULL;
									_tmp20 = NULL;
									ccall = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
									_tmp21 = NULL;
									_tmp22 = NULL;
									cinit = (_tmp22 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cname), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), _tmp22);
									vala_ccode_function_call_add_argument (ccall, cexpr);
									_tmp23 = NULL;
									cexpr = (_tmp23 = VALA_CCODE_EXPRESSION (vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_EXPRESSION (cname), VALA_CCODE_EXPRESSION (cinit))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp23);
									(cname == NULL ? NULL : (cname = (g_object_unref (cname), NULL)));
									(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
								} else {
									ValaCCodeIdentifier* _tmp24;
									ValaCCodeFunctionCall* _tmp25;
									ValaCCodeFunctionCall* ccall;
									ValaCCodeExpression* _tmp27;
									ValaCCodeFunctionCall* _tmp26;
									_tmp24 = NULL;
									_tmp25 = NULL;
									ccall = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_quark_from_string")))), (_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL))), _tmp25);
									vala_ccode_function_call_add_argument (ccall, cexpr);
									_tmp27 = NULL;
									_tmp26 = NULL;
									cexpr = (_tmp27 = VALA_CCODE_EXPRESSION ((_tmp26 = ccall, (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp27);
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								}
							}
							ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), cexpr);
							if (cor == NULL) {
								ValaCCodeBinaryExpression* _tmp29;
								ValaCCodeBinaryExpression* _tmp28;
								_tmp29 = NULL;
								_tmp28 = NULL;
								cor = (_tmp29 = (_tmp28 = ccmp, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp29);
							} else {
								ValaCCodeBinaryExpression* _tmp30;
								_tmp30 = NULL;
								cor = (_tmp30 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp30);
							}
							(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
							(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
							(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
						}
					}
					(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
					(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
				}
				cblock = vala_ccode_block_new ();
				{
					GeeCollection* body_stmt_collection;
					GeeIterator* body_stmt_it;
					body_stmt_collection = vala_block_get_statements (VALA_BLOCK (section));
					body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
					while (gee_iterator_next (body_stmt_it)) {
						ValaCodeNode* body_stmt;
						body_stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (body_stmt_it)));
						{
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
							}
							(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
						}
					}
					(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (g_object_unref (body_stmt_collection), NULL)));
					(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
				}
				_tmp31 = NULL;
				_tmp32 = NULL;
				cdo = (_tmp32 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("0")))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
				cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
				if (coldif != NULL) {
					vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif));
				} else {
					ValaCCodeStatement* _tmp34;
					ValaCCodeIfStatement* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					ctopstmt = (_tmp34 = VALA_CCODE_STATEMENT ((_tmp33 = cif, (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp34);
				}
				_tmp36 = NULL;
				_tmp35 = NULL;
				coldif = (_tmp36 = (_tmp35 = cif, (_tmp35 == NULL ? NULL : g_object_ref (_tmp35))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), _tmp36);
				(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
				(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
				(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
				(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
				(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
		(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp37;
		ValaCCodeDoStatement* _tmp38;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeCollection* body_stmt_collection;
			GeeIterator* body_stmt_it;
			body_stmt_collection = default_statements;
			body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
			while (gee_iterator_next (body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (body_stmt_it)));
				{
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
				}
			}
			(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
		}
		_tmp37 = NULL;
		_tmp38 = NULL;
		cdo = (_tmp38 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("0")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp40;
			ValaCCodeDoStatement* _tmp39;
			/* there is only one section and that section
			 contains a default label*/
			_tmp40 = NULL;
			_tmp39 = NULL;
			ctopstmt = (_tmp40 = VALA_CCODE_STATEMENT ((_tmp39 = cdo, (_tmp39 == NULL ? NULL : g_object_ref (_tmp39)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp40);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SWITCH_SECTION (section));
	vala_code_visitor_visit_block (VALA_CODE_VISITOR (self), VALA_BLOCK (section));
}


static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeWhileStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_body (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_while_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeDoStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_condition (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_do_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* ccondition;
	ValaCCodeForStatement* cfor;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	ccondition = NULL;
	if (vala_for_statement_get_condition (stmt) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccondition = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_condition (stmt)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (ccondition == NULL ? NULL : (ccondition = (g_object_unref (ccondition), NULL))), _tmp1);
	}
	cfor = vala_ccode_for_statement_new (ccondition, VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_body (stmt)))));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor));
	{
		GeeCollection* init_expr_collection;
		GeeIterator* init_expr_it;
		init_expr_collection = vala_for_statement_get_initializer (stmt);
		init_expr_it = gee_iterable_iterator (GEE_ITERABLE (init_expr_collection));
		while (gee_iterator_next (init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = ((ValaExpression*) gee_iterator_get (init_expr_it));
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (init_expr))));
				vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (init_expr->temp_vars));
				(init_expr == NULL ? NULL : (init_expr = (g_object_unref (init_expr), NULL)));
			}
		}
		(init_expr_collection == NULL ? NULL : (init_expr_collection = (g_object_unref (init_expr_collection), NULL)));
		(init_expr_it == NULL ? NULL : (init_expr_it = (g_object_unref (init_expr_it), NULL)));
	}
	{
		GeeCollection* it_expr_collection;
		GeeIterator* it_expr_it;
		it_expr_collection = vala_for_statement_get_iterator (stmt);
		it_expr_it = gee_iterable_iterator (GEE_ITERABLE (it_expr_collection));
		while (gee_iterator_next (it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = ((ValaExpression*) gee_iterator_get (it_expr_it));
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (it_expr))));
				vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (it_expr->temp_vars));
				(it_expr == NULL ? NULL : (it_expr = (g_object_unref (it_expr), NULL)));
			}
		}
		(it_expr_collection == NULL ? NULL : (it_expr_collection = (g_object_unref (it_expr_collection), NULL)));
		(it_expr_it == NULL ? NULL : (it_expr_it = (g_object_unref (it_expr_it), NULL)));
	}
	if (vala_for_statement_get_condition (stmt) != NULL) {
		vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_for_statement_get_condition (stmt)->temp_vars));
	}
	(ccondition == NULL ? NULL : (ccondition = (g_object_unref (ccondition), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaLocalVariable* _tmp0;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	char* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* ccolvardecl;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_element_variable (stmt)), TRUE);
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_collection_variable (stmt)), TRUE);
	if (vala_foreach_statement_get_iterator_variable (stmt) != NULL) {
		vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_iterator_variable (stmt)), TRUE);
	}
	vala_code_visitor_visit_block (VALA_CODE_VISITOR (self), VALA_BLOCK (stmt));
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (vala_foreach_statement_get_collection (stmt)->temp_vars));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable (stmt), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	collection_type = vala_data_type_copy (vala_local_variable_get_variable_type (collection_backup));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccoldecl = (_tmp2 = vala_ccode_declaration_new ((_tmp1 = vala_data_type_get_cname (collection_type))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	ccolvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (VALA_SYMBOL (collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)))));
	vala_ccode_node_set_line (VALA_CCODE_NODE (ccolvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
	vala_ccode_declaration_add_declarator (ccoldecl, VALA_CCODE_DECLARATOR (ccolvardecl));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (ccoldecl));
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (stmt)) && vala_expression_get_can_fail (vala_foreach_statement_get_collection (stmt))) {
		ValaCCodeFragment* cfrag;
		/* exception handling*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)), cfrag);
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp3;
		ValaArrayType* array_type;
		ValaCCodeExpression* array_len;
		_tmp3 = NULL;
		array_type = (_tmp3 = VALA_ARRAY_TYPE (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
		array_len = vala_ccode_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), -1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* _tmp4;
			ValaCCodeDeclaration* _tmp5;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp6;
			ValaCCodeBlock* cbody;
			char* _tmp7;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeExpression* element_expr;
			ValaCCodeExpression* _tmp9;
			char* _tmp13;
			ValaCCodeDeclaration* _tmp14;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp15;
			ValaCCodeConstant* _tmp18;
			ValaCCodeIdentifier* _tmp17;
			char* _tmp16;
			ValaCCodeBinaryExpression* _tmp19;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp22;
			ValaCCodeIdentifier* _tmp21;
			ValaCCodeIdentifier* _tmp20;
			ValaCCodeAssignment* _tmp27;
			ValaCCodeBinaryExpression* _tmp26;
			ValaCCodeConstant* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeIdentifier* _tmp23;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp4 = NULL;
			_tmp5 = NULL;
			citdecl = (_tmp5 = vala_ccode_declaration_new ((_tmp4 = vala_data_type_get_cname (collection_type))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
			_tmp6 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp6 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp7 = NULL;
			_tmp8 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = g_strdup_printf ("*%s", it_name))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8));
			_tmp9 = NULL;
			element_expr = (_tmp9 = vala_ccode_generator_get_implicit_cast_expression (self, element_expr, vala_array_type_get_element_type (array_type), vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp9);
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp10;
				ValaCCodeDeclaration* clendecl;
				ValaCCodeVariableDeclarator* _tmp12;
				char* _tmp11;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp10 = NULL;
				element_expr = (_tmp10 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp10);
				clendecl = vala_ccode_declaration_new ("int");
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_ccode_declaration_add_declarator (clendecl, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ((_tmp11 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (collection_backup)), 1)), array_len))));
				(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
				_tmp11 = (g_free (_tmp11), NULL);
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (clendecl));
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(clendecl == NULL ? NULL : (clendecl = (g_object_unref (clendecl), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp13 = NULL;
			_tmp14 = NULL;
			cdecl_ = (_tmp14 = vala_ccode_declaration_new ((_tmp13 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
			_tmp15 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp15 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp18 = NULL;
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp19 = NULL;
			ccond = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = g_strdup_printf ("*%s", it_name))))), VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp19);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
			(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp28;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeElementAccess* _tmp31;
			ValaCCodeExpression* element_expr;
			ValaCCodeExpression* _tmp32;
			char* _tmp34;
			ValaCCodeDeclaration* _tmp35;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp36;
			ValaCCodeConstant* _tmp37;
			ValaCCodeBinaryExpression* _tmp38;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* _tmp39;
			ValaCCodeBinaryExpression* _tmp40;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp58;
			ValaCCodeConstant* _tmp57;
			ValaCCodeIdentifier* _tmp56;
			ValaCCodeAssignment* _tmp63;
			ValaCCodeBinaryExpression* _tmp62;
			ValaCCodeConstant* _tmp61;
			ValaCCodeIdentifier* _tmp60;
			ValaCCodeIdentifier* _tmp59;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			_tmp28 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp28 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp31 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new (it_name)))), (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp31));
			_tmp32 = NULL;
			element_expr = (_tmp32 = vala_ccode_generator_get_implicit_cast_expression (self, element_expr, vala_array_type_get_element_type (array_type), vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp32);
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp33;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp33 = NULL;
				element_expr = (_tmp33 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp33);
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp34 = NULL;
			_tmp35 = NULL;
			cdecl_ = (_tmp35 = vala_ccode_declaration_new ((_tmp34 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp34 = (g_free (_tmp34), NULL)), _tmp35);
			_tmp36 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp36 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp37 = NULL;
			_tmp38 = NULL;
			ccond_ind1 = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("-1")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
			_tmp39 = NULL;
			_tmp40 = NULL;
			ccond_ind2 = (_tmp40 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new (it_name))), array_len), (_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL))), _tmp40);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)))) {
				ValaCCodeConstant* _tmp41;
				ValaCCodeBinaryExpression* _tmp42;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* _tmp46;
				ValaCCodeElementAccess* _tmp45;
				ValaCCodeIdentifier* _tmp44;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeBinaryExpression* _tmp47;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* _tmp50;
				ValaCCodeParenthesizedExpression* _tmp49;
				ValaCCodeParenthesizedExpression* _tmp48;
				_tmp41 = NULL;
				_tmp42 = NULL;
				ccond_term1 = (_tmp42 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("-1")))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), _tmp42);
				_tmp46 = NULL;
				_tmp45 = NULL;
				_tmp44 = NULL;
				_tmp43 = NULL;
				_tmp47 = NULL;
				ccond_term2 = (_tmp47 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new (it_name)))))), VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ("NULL")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), (_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), _tmp47);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				_tmp50 = NULL;
				_tmp49 = NULL;
				_tmp48 = NULL;
				ccond = (_tmp50 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind)))), VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term))))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp50);
				(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
				(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp51;
				ValaCCodeFunctionCall* _tmp52;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* _tmp53;
				ValaCCodeBinaryExpression* _tmp55;
				ValaCCodeBinaryExpression* _tmp54;
				/* assert when trying to iterate over value-type arrays of unknown length */
				_tmp51 = NULL;
				_tmp52 = NULL;
				cassert = (_tmp52 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("g_assert")))), (_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL))), _tmp52);
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				_tmp53 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp53 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
				_tmp55 = NULL;
				_tmp54 = NULL;
				ccond = (_tmp55 = (_tmp54 = ccond_ind2, (_tmp54 == NULL ? NULL : g_object_ref (_tmp54))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp55);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp58 = NULL;
			_tmp57 = NULL;
			_tmp56 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
			(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
			_tmp63 = NULL;
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			_tmp59 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
			(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
			(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(array_len == NULL ? NULL : (array_len = (g_object_unref (array_len), NULL)));
	} else {
		ValaClassInstanceType* _tmp65;
		ValaClassInstanceType* _tmp64;
		gboolean _tmp66;
		_tmp65 = NULL;
		_tmp64 = NULL;
		if ((_tmp66 = vala_data_type_compatible (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_DATA_TYPE ((_tmp64 = vala_class_instance_type_new (self->glist_type)))) || vala_data_type_compatible (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_DATA_TYPE ((_tmp65 = vala_class_instance_type_new (self->gslist_type)))), (_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL))), (_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL))), _tmp66)) {
			char* it_name;
			char* _tmp67;
			ValaCCodeDeclaration* _tmp68;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* citvardecl;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp69;
			ValaCCodeMemberAccess* _tmp70;
			ValaCCodeExpression* element_expr;
			GeeList* _tmp71;
			gboolean _tmp72;
			GeeList* _tmp73;
			ValaDataType* _tmp74;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp75;
			ValaCCodeExpression* _tmp76;
			char* _tmp78;
			ValaCCodeDeclaration* _tmp79;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* cvardecl;
			ValaCCodeConstant* _tmp81;
			ValaCCodeIdentifier* _tmp80;
			ValaCCodeBinaryExpression* _tmp82;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			ValaCCodeIdentifier* _tmp83;
			ValaCCodeAssignment* _tmp89;
			ValaCCodeMemberAccess* _tmp88;
			ValaCCodeIdentifier* _tmp87;
			ValaCCodeIdentifier* _tmp86;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp67 = NULL;
			_tmp68 = NULL;
			citdecl = (_tmp68 = vala_ccode_declaration_new ((_tmp67 = vala_data_type_get_cname (collection_type))), (_tmp67 = (g_free (_tmp67), NULL)), _tmp68);
			citvardecl = vala_ccode_variable_declarator_new (it_name);
			vala_ccode_node_set_line (VALA_CCODE_NODE (citvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR (citvardecl));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp69 = NULL;
			_tmp70 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new (it_name))), "data"), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), _tmp70));
			_tmp71 = NULL;
			if ((_tmp72 = gee_collection_get_size (GEE_COLLECTION ((_tmp71 = vala_data_type_get_type_arguments (collection_type)))) != 1, (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), _tmp72)) {
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), "internal error: missing generic type argument");
				vala_code_node_set_error (VALA_CODE_NODE (stmt), TRUE);
				it_name = (g_free (it_name), NULL);
				(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
				(citvardecl == NULL ? NULL : (citvardecl = (g_object_unref (citvardecl), NULL)));
				(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
				(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
				(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
				(collection_type == NULL ? NULL : (collection_type = (g_object_unref (collection_type), NULL)));
				(ccoldecl == NULL ? NULL : (ccoldecl = (g_object_unref (ccoldecl), NULL)));
				(ccolvardecl == NULL ? NULL : (ccolvardecl = (g_object_unref (ccolvardecl), NULL)));
				return;
			}
			_tmp73 = NULL;
			_tmp74 = NULL;
			element_data_type = (_tmp74 = ((ValaDataType*) gee_list_get ((_tmp73 = vala_data_type_get_type_arguments (collection_type)), 0)), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), _tmp74);
			_tmp75 = NULL;
			element_expr = (_tmp75 = vala_ccode_generator_get_implicit_cast_expression (self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp75);
			_tmp76 = NULL;
			element_expr = (_tmp76 = vala_ccode_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp76);
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp77;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp77 = NULL;
				element_expr = (_tmp77 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp77);
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp78 = NULL;
			_tmp79 = NULL;
			cdecl_ = (_tmp79 = vala_ccode_declaration_new ((_tmp78 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp78 = (g_free (_tmp78), NULL)), _tmp79);
			cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
			vala_ccode_node_set_line (VALA_CCODE_NODE (cvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (cvardecl));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp82 = NULL;
			ccond = (_tmp82 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_constant_new ("NULL")))), (_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL))), (_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL))), _tmp82);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
			(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
			(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
			_tmp89 = NULL;
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp86 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new (it_name))), "next"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
			(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
			(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
			(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(citvardecl == NULL ? NULL : (citvardecl = (g_object_unref (citvardecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(element_data_type == NULL ? NULL : (element_data_type = (g_object_unref (element_data_type), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(cvardecl == NULL ? NULL : (cvardecl = (g_object_unref (cvardecl), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			ValaInterfaceInstanceType* _tmp90;
			gboolean _tmp91;
			_tmp90 = NULL;
			if ((_tmp91 = self->iterable_type != NULL && vala_data_type_compatible (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_DATA_TYPE ((_tmp90 = vala_interface_instance_type_new (self->iterable_type)))), (_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL))), _tmp91)) {
				char* it_name;
				char* _tmp93;
				char* _tmp92;
				ValaCCodeDeclaration* _tmp94;
				ValaCCodeDeclaration* citdecl;
				ValaMethod* it_method;
				ValaCCodeIdentifier* _tmp96;
				char* _tmp95;
				ValaCCodeFunctionCall* _tmp97;
				ValaCCodeFunctionCall* it_ccall;
				ValaInstanceCast* _tmp99;
				ValaCCodeIdentifier* _tmp98;
				ValaCCodeVariableDeclarator* citvardecl;
				ValaCCodeBlock* cbody;
				ValaMethod* get_method;
				ValaCCodeIdentifier* _tmp101;
				char* _tmp100;
				ValaCCodeFunctionCall* _tmp102;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeIdentifier* _tmp103;
				ValaCCodeFunctionCall* _tmp104;
				ValaCCodeExpression* element_expr;
				ValaCCodeExpression* _tmp105;
				GeeList* _tmp106;
				GeeIterator* _tmp107;
				GeeIterator* type_arg_it;
				ValaDataType* _tmp108;
				ValaDataType* _tmp109;
				ValaDataType* it_type;
				ValaCCodeExpression* _tmp110;
				char* _tmp112;
				ValaCCodeDeclaration* _tmp113;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* cvardecl;
				ValaMethod* next_method;
				ValaCCodeIdentifier* _tmp115;
				char* _tmp114;
				ValaCCodeFunctionCall* _tmp116;
				ValaCCodeFunctionCall* next_ccall;
				ValaCCodeIdentifier* _tmp117;
				ValaCCodeWhileStatement* cwhile;
				it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
				_tmp93 = NULL;
				_tmp92 = NULL;
				_tmp94 = NULL;
				citdecl = (_tmp94 = vala_ccode_declaration_new ((_tmp93 = g_strconcat ((_tmp92 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->iterator_type), FALSE)), "*", NULL))), (_tmp93 = (g_free (_tmp93), NULL)), (_tmp92 = (g_free (_tmp92), NULL)), _tmp94);
				it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterable_type)), "iterator"));
				_tmp96 = NULL;
				_tmp95 = NULL;
				_tmp97 = NULL;
				it_ccall = (_tmp97 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new ((_tmp95 = vala_method_get_cname (it_method)))))), (_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL))), (_tmp95 = (g_free (_tmp95), NULL)), _tmp97);
				_tmp99 = NULL;
				_tmp98 = NULL;
				vala_ccode_function_call_add_argument (it_ccall, VALA_CCODE_EXPRESSION ((_tmp99 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_TYPESYMBOL (self->iterable_type)))));
				(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
				(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
				citvardecl = vala_ccode_variable_declarator_new_with_initializer (it_name, VALA_CCODE_EXPRESSION (it_ccall));
				vala_ccode_node_set_line (VALA_CCODE_NODE (citvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR (citvardecl));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
				cbody = vala_ccode_block_new ();
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterator_type)), "get"));
				_tmp101 = NULL;
				_tmp100 = NULL;
				_tmp102 = NULL;
				get_ccall = (_tmp102 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = vala_method_get_cname (get_method)))))), (_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL))), (_tmp100 = (g_free (_tmp100), NULL)), _tmp102);
				_tmp103 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new (it_name))));
				(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
				_tmp104 = NULL;
				element_expr = VALA_CCODE_EXPRESSION ((_tmp104 = get_ccall, (_tmp104 == NULL ? NULL : g_object_ref (_tmp104))));
				_tmp105 = NULL;
				element_expr = (_tmp105 = vala_ccode_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp105);
				_tmp106 = NULL;
				_tmp107 = NULL;
				type_arg_it = (_tmp107 = gee_iterable_iterator (GEE_ITERABLE ((_tmp106 = vala_data_type_get_type_arguments (vala_method_get_return_type (it_method))))), (_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL))), _tmp107);
				gee_iterator_next (type_arg_it);
				_tmp108 = NULL;
				_tmp109 = NULL;
				it_type = (_tmp109 = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_SYMBOL (it_method), (_tmp108 = ((ValaDataType*) gee_iterator_get (type_arg_it))), VALA_CODE_NODE (stmt)), (_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL))), _tmp109);
				_tmp110 = NULL;
				element_expr = (_tmp110 = vala_ccode_generator_get_implicit_cast_expression (self, element_expr, it_type, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp110);
				if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt)) && !vala_data_type_get_takes_ownership (it_type)) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp111;
					ValaCCodeFragment* cfrag;
					ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
					vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
					_tmp111 = NULL;
					element_expr = (_tmp111 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp111);
					cfrag = vala_ccode_fragment_new ();
					vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
					vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
					gee_collection_clear (GEE_COLLECTION (self->temp_vars));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
				}
				_tmp112 = NULL;
				_tmp113 = NULL;
				cdecl_ = (_tmp113 = vala_ccode_declaration_new ((_tmp112 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)))), (_tmp112 = (g_free (_tmp112), NULL)), _tmp113);
				cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (cvardecl));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
				next_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterator_type)), "next"));
				_tmp115 = NULL;
				_tmp114 = NULL;
				_tmp116 = NULL;
				next_ccall = (_tmp116 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp115 = vala_ccode_identifier_new ((_tmp114 = vala_method_get_cname (next_method)))))), (_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL))), (_tmp114 = (g_free (_tmp114), NULL)), _tmp116);
				_tmp117 = NULL;
				vala_ccode_function_call_add_argument (next_ccall, VALA_CCODE_EXPRESSION ((_tmp117 = vala_ccode_identifier_new (it_name))));
				(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
				cwhile = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (next_ccall), VALA_CCODE_STATEMENT (cbody));
				vala_ccode_node_set_line (VALA_CCODE_NODE (cwhile), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cwhile));
				it_name = (g_free (it_name), NULL);
				(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
				(it_method == NULL ? NULL : (it_method = (g_object_unref (it_method), NULL)));
				(it_ccall == NULL ? NULL : (it_ccall = (g_object_unref (it_ccall), NULL)));
				(citvardecl == NULL ? NULL : (citvardecl = (g_object_unref (citvardecl), NULL)));
				(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
				(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				(it_type == NULL ? NULL : (it_type = (g_object_unref (it_type), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(cvardecl == NULL ? NULL : (cvardecl = (g_object_unref (cvardecl), NULL)));
				(next_method == NULL ? NULL : (next_method = (g_object_unref (next_method), NULL)));
				(next_ccall == NULL ? NULL : (next_ccall = (g_object_unref (next_ccall), NULL)));
				(cwhile == NULL ? NULL : (cwhile = (g_object_unref (cwhile), NULL)));
			}
		}
	}
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = vala_block_get_local_variables (VALA_BLOCK (stmt));
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				if (vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp120;
					ValaCCodeIdentifier* _tmp119;
					char* _tmp118;
					ValaCCodeExpressionStatement* _tmp121;
					ValaCCodeExpressionStatement* cunref;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
					_tmp120 = NULL;
					_tmp119 = NULL;
					_tmp118 = NULL;
					_tmp121 = NULL;
					cunref = (_tmp121 = vala_ccode_expression_statement_new ((_tmp120 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_identifier_new ((_tmp118 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma)))), (_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL))), (_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL))), (_tmp118 = (g_free (_tmp118), NULL)), _tmp121);
					vala_ccode_node_set_line (VALA_CCODE_NODE (cunref), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cunref));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cunref == NULL ? NULL : (cunref = (g_object_unref (cunref), NULL)));
				}
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_collection == NULL ? NULL : (local_collection = (g_object_unref (local_collection), NULL)));
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(collection_type == NULL ? NULL : (collection_type = (g_object_unref (collection_type), NULL)));
	(ccoldecl == NULL ? NULL : (ccoldecl = (g_object_unref (ccoldecl), NULL)));
	(ccolvardecl == NULL ? NULL : (ccolvardecl = (g_object_unref (ccolvardecl), NULL)));
}


static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeBreakStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_break_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeContinueStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_continue_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_ccode_generator_append_local_free (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_SYMBOL (sym));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = local_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				if (vala_symbol_get_active (VALA_SYMBOL (local)) && vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local)) && vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp4;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp4 = vala_ccode_expression_statement_new ((_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma)))))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	if (stop_at_loop) {
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b)))) {
			(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
			(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_generator_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_ccode_generator_append_param_free (ValaCCodeGenerator* self, ValaMethod* m, ValaCCodeFragment* cfrag) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_METHOD (m));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_data_type_get_takes_ownership (vala_formal_parameter_get_type_reference (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp3;
					ValaCCodeExpression* _tmp2;
					ValaCCodeIdentifier* _tmp1;
					char* _tmp0;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (param)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (param));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (param))))))), vala_formal_parameter_get_type_reference (param), VALA_EXPRESSION (ma)))))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
					_tmp0 = (g_free (_tmp0), NULL);
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
}


static void vala_ccode_generator_create_local_free (ValaCCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_NODE (stmt));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_local_free (self, self->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_ccode_generator_append_local_free_expr (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop) {
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	gboolean _tmp4;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* local_collection;
		GeeIterator* local_it;
		local_collection = local_vars;
		local_it = gee_iterable_iterator (GEE_ITERABLE (local_collection));
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) gee_iterator_get (local_it));
			{
				if (vala_symbol_get_active (VALA_SYMBOL (local)) && vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local)) && vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (local)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (local));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))))), vala_local_variable_get_variable_type (local), VALA_EXPRESSION (ma))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
			}
		}
		(local_it == NULL ? NULL : (local_it = (g_object_unref (local_it), NULL)));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		found = vala_ccode_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop) || found;
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			found = vala_ccode_generator_append_param_free_expr (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), ccomma) || found;
		}
	}
	return (_tmp4 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL))), _tmp4);
}


static gboolean vala_ccode_generator_append_param_free_expr (ValaCCodeGenerator* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma) {
	gboolean found;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	g_return_val_if_fail (VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_data_type_get_takes_ownership (vala_formal_parameter_get_type_reference (param)) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp2;
					ValaCCodeIdentifier* _tmp1;
					char* _tmp0;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (param)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (param));
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp2 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (param))))))), vala_formal_parameter_get_type_reference (param), VALA_EXPRESSION (ma))));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
					_tmp0 = (g_free (_tmp0), NULL);
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	return found;
}


static void vala_ccode_generator_create_local_free_expr (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaLocalVariable* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp2;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	return_expr_decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
	ccomma = vala_ccode_comma_expression_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (!vala_ccode_generator_append_local_free_expr (self, self->current_symbol, ccomma, FALSE)) {
		/* no local variables need to be freed */
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), return_expr_decl);
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaLocalVariable* _tmp0;
			ValaLocalVariable* local;
			_tmp0 = NULL;
			local = (_tmp0 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
			if (vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE);
				/* don't ref expression*/
				vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE);
			}
			(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
		}
	}
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp1 = vala_ccode_return_statement_new (NULL))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeExpression* _tmp13;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaLocalVariable* _tmp2;
			ValaLocalVariable* local;
			_tmp2 = NULL;
			local = (_tmp2 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
			if (vala_data_type_get_takes_ownership (vala_local_variable_get_variable_type (local))) {
				ValaSymbol* _tmp4;
				ValaLocalVariable* _tmp3;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				_tmp4 = NULL;
				_tmp3 = NULL;
				return_expression_symbol = (_tmp4 = VALA_SYMBOL ((_tmp3 = local, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), _tmp4);
				vala_symbol_set_active (return_expression_symbol, FALSE);
			}
			(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
		}
		/* return array length if appropriate*/
		if (self->current_method != NULL && !vala_method_get_no_array_length (self->current_method) && VALA_IS_ARRAY_TYPE (self->current_return_type)) {
			ValaLocalVariable* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaArrayType* _tmp7;
			ValaArrayType* array_type;
			ValaCCodeIdentifier* _tmp12;
			return_expr_decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), TRUE, VALA_CODE_NODE (stmt));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
			_tmp7 = NULL;
			array_type = (_tmp7 = VALA_ARRAY_TYPE (self->current_return_type), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeIdentifier* _tmp9;
					char* _tmp8;
					ValaCCodeUnaryExpression* _tmp10;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp11;
					_tmp9 = NULL;
					_tmp8 = NULL;
					_tmp10 = NULL;
					len_l = (_tmp10 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_ccode_generator_get_array_length_cname (self, "result", dim)))))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp10);
					len_r = vala_ccode_generator_get_array_length_cexpression (self, vala_return_statement_get_return_expression (stmt), dim);
					_tmp11 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (len_l), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
					(len_l == NULL ? NULL : (len_l = (g_object_unref (len_l), NULL)));
					(len_r == NULL ? NULL : (len_r = (g_object_unref (len_r), NULL)));
				}
			}
			_tmp12 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))));
			(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE (ccomma));
			gee_collection_add (GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars), return_expr_decl);
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
		vala_ccode_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		_tmp13 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((_tmp13 = vala_ccode_generator_get_implicit_cast_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), self->current_return_type))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		/* Property getters of non simple structs shall return the struct value as out parameter,
		 therefore replace any return statement with an assignment statement to the out formal
		 paramenter and insert an empty return statement afterwards.*/
		if (self->current_property_accessor != NULL && vala_property_accessor_get_readable (self->current_property_accessor) && vala_data_type_is_real_struct_type (vala_property_get_type_reference (vala_property_accessor_get_prop (self->current_property_accessor)))) {
			ValaCCodeFragment* cfragment;
			ValaCCodeExpressionStatement* _tmp16;
			ValaCCodeAssignment* _tmp15;
			ValaCCodeIdentifier* _tmp14;
			ValaCCodeReturnStatement* _tmp17;
			cfragment = vala_ccode_fragment_new ();
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_fragment_append (cfragment, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("*value"))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			_tmp17 = NULL;
			vala_ccode_fragment_append (cfragment, VALA_CCODE_NODE ((_tmp17 = vala_ccode_return_statement_new (NULL))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfragment));
			(cfragment == NULL ? NULL : (cfragment = (g_object_unref (cfragment), NULL)));
		} else {
			ValaCCodeReturnStatement* _tmp18;
			_tmp18 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp18 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))))))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		}
		vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars));
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeAssignment* cassign;
	ValaCCodeExpressionStatement* _tmp2;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = vala_ccode_fragment_new ();
	/* declare temporary objects */
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
	/* method will fail*/
	self->current_method_inner_error = TRUE;
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassign = (_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_throw_statement_get_error_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp2 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (stmt), cfrag);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaCCodeGenerator * self;
	gint this_try_id;
	ValaTryStatement* _tmp0;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* _tmp2;
	ValaTryStatement* _tmp1;
	ValaTryStatement* _tmp6;
	ValaTryStatement* _tmp5;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp10;
	char* _tmp9;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	this_try_id = self->priv->next_try_id++;
	_tmp0 = NULL;
	old_try = (_tmp0 = self->current_try, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	old_try_id = self->priv->current_try_id;
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->current_try = (_tmp2 = (_tmp1 = stmt, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->current_try == NULL ? NULL : (self->current_try = (g_object_unref (self->current_try), NULL))), _tmp2);
	self->priv->current_try_id = this_try_id;
	{
		GeeList* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = ((ValaCatchClause*) gee_iterator_get (clause_it));
			{
				char* _tmp4;
				char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_catch_clause_set_clabel_name (clause, (_tmp4 = g_strdup_printf ("__catch%d_%s", this_try_id, (_tmp3 = vala_data_type_get_lower_case_cname (vala_catch_clause_get_error_type (clause), NULL)))));
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp3 = (g_free (_tmp3), NULL);
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_try_statement_get_finally_body (stmt)), VALA_CODE_VISITOR (self));
	}
	vala_code_node_accept (VALA_CODE_NODE (vala_try_statement_get_body (stmt)), VALA_CODE_VISITOR (self));
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->current_try = (_tmp6 = (_tmp5 = old_try, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (self->current_try == NULL ? NULL : (self->current_try = (g_object_unref (self->current_try), NULL))), _tmp6);
	self->priv->current_try_id = old_try_id;
	{
		GeeList* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = ((ValaCatchClause*) gee_iterator_get (clause_it));
			{
				vala_code_node_accept (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_try_statement_get_finally_body (stmt)), VALA_CODE_VISITOR (self));
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_body (stmt))));
	{
		GeeList* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = ((ValaCatchClause*) gee_iterator_get (clause_it));
			{
				ValaCCodeGotoStatement* _tmp8;
				char* _tmp7;
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp8 = vala_ccode_goto_statement_new ((_tmp7 = g_strdup_printf ("__finally%d", this_try_id))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp7 = (g_free (_tmp7), NULL);
				vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (clause)));
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp10 = vala_ccode_label_new ((_tmp9 = g_strdup_printf ("__finally%d", this_try_id))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp9 = (g_free (_tmp9), NULL);
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_finally_body (stmt))));
	} else {
		ValaCCodeEmptyStatement* _tmp11;
		/* avoid gcc error: label at end of compound statement*/
		_tmp11 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp11 = vala_ccode_empty_statement_new ())));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	(old_try == NULL ? NULL : (old_try = (g_object_unref (old_try), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp0;
	ValaCCodeBlock* cblock;
	const char* _tmp1;
	char* variable_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeAssignment* _tmp7;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	self->current_method_inner_error = TRUE;
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
	cfrag = vala_ccode_fragment_new ();
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp0 = vala_ccode_label_new (vala_catch_clause_get_clabel_name (clause)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	cblock = vala_ccode_block_new ();
	_tmp1 = NULL;
	variable_name = (_tmp1 = vala_catch_clause_get_variable_name (clause), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	if (variable_name == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		variable_name = (_tmp2 = g_strdup ("__err"), (variable_name = (g_free (variable_name), NULL)), _tmp2);
	}
	cdecl_ = vala_ccode_declaration_new ("GError *");
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new_with_initializer (variable_name, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp8 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_catch_clause_get_body (clause))));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cblock));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (clause), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	variable_name = (g_free (variable_name), NULL);
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static char* vala_ccode_generator_get_symbol_lock_name (ValaCCodeGenerator* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp7;
	char* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaMethod* _tmp8;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	ValaMethod* _tmp13;
	ValaCCodeExpressionStatement* _tmp17;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			l = (_tmp2 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp2);
		} else {
			ValaCCodeExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			l = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp4);
		}
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	l = (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (l, "priv"))), (_tmp6 = vala_ccode_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	fc = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname ((_tmp8 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type))), "lock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp9 = (g_free (_tmp9), NULL);
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp12 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_lock_statement_get_body (stmt))));
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	fc = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_method_get_cname ((_tmp13 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type))), "unlock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp16);
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	_tmp14 = (g_free (_tmp14), NULL);
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp17 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


static void vala_ccode_generator_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaPointerType* _tmp0;
	ValaPointerType* pointer_type;
	ValaPointerType* _tmp1;
	ValaDataType* type;
	ValaCCodeExpression* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp6;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DELETE_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	pointer_type = (_tmp0 = VALA_POINTER_TYPE (vala_expression_get_static_type (vala_delete_statement_get_expression (stmt))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	type = VALA_DATA_TYPE ((_tmp1 = pointer_type, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))));
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)))) {
		ValaDataType* _tmp3;
		ValaDataType* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		type = (_tmp3 = (_tmp2 = vala_pointer_type_get_base_type (pointer_type), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp3);
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	ccall = (_tmp5 = vala_ccode_function_call_new ((_tmp4 = vala_ccode_generator_get_destroy_func_expression (self, type))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_delete_statement_get_expression (stmt)))));
	_tmp6 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp6 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(pointer_type == NULL ? NULL : (pointer_type = (g_object_unref (pointer_type), NULL)));
	(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (expr))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_character_literal_get_value (expr)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeConstant* _tmp2;
		char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		_tmp1 = (g_free (_tmp1), NULL);
	}
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_real_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ("NULL"))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeParenthesizedExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (expr))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (expr))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


char* vala_ccode_generator_get_array_length_cname (ValaCCodeGenerator* self, const char* array_cname, gint dim) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


ValaCCodeExpression* vala_ccode_generator_get_array_length_cexpression (ValaCCodeGenerator* self, ValaExpression* array_expr, gint dim) {
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	/* dim == -1 => total size over all dimensions*/
	if (dim == -1) {
		ValaArrayType* _tmp1;
		ValaDataType* _tmp0;
		ValaArrayType* array_type;
		_tmp1 = NULL;
		_tmp0 = NULL;
		array_type = (_tmp1 = (_tmp0 = vala_expression_get_static_type (array_expr), (VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (array_type != NULL && vala_array_type_get_rank (array_type) > 1) {
			ValaCCodeExpression* cexpr;
			ValaCCodeExpression* _tmp4;
			cexpr = vala_ccode_generator_get_array_length_cexpression (self, array_expr, 1);
			for (dim = 2; dim <= vala_array_type_get_rank (array_type); dim++) {
				ValaCCodeExpression* _tmp3;
				ValaCCodeExpression* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				cexpr = (_tmp3 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, (_tmp2 = vala_ccode_generator_get_array_length_cexpression (self, array_expr, dim)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp3);
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			}
			_tmp4 = NULL;
			return (_tmp4 = cexpr, (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp4);
		} else {
			dim = 1;
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	}
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp5;
		ValaUnaryExpression* unary_expr;
		_tmp5 = NULL;
		unary_expr = (_tmp5 = VALA_UNARY_EXPRESSION (array_expr), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp6;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp6 = NULL;
			reftransfer_expr = (_tmp6 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL ? NULL : (reftransfer_expr = (g_object_unref (reftransfer_expr), NULL)));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp8;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = ((ValaExpression*) gee_list_get (((GeeList*) size), dim - 1));
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (length_expr))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp8);
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* _tmp9;
			ValaInvocationExpression* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* _tmp10;
			_tmp9 = NULL;
			invocation_expr = (_tmp9 = VALA_INVOCATION_EXPRESSION (array_expr), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			_tmp10 = NULL;
			return (_tmp10 = ((ValaCCodeExpression*) gee_list_get (((GeeList*) size), dim - 1)), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), _tmp10);
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp11;
					ValaFormalParameter* param;
					_tmp11 = NULL;
					param = (_tmp11 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						char* _tmp12;
						ValaCCodeIdentifier* _tmp13;
						ValaCCodeExpression* length_expr;
						_tmp12 = NULL;
						_tmp13 = NULL;
						length_expr = VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)), dim))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13));
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							ValaCCodeExpression* _tmp15;
							ValaCCodeUnaryExpression* _tmp14;
							/* accessing argument of out/ref param*/
							_tmp15 = NULL;
							_tmp14 = NULL;
							length_expr = (_tmp15 = VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr))))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp15);
							(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
						}
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp16;
							/* passing array as out/ref*/
							_tmp16 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp16));
						} else {
							ValaCCodeExpression* _tmp17;
							_tmp17 = NULL;
							return (_tmp17 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp17);
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
						ValaLocalVariable* _tmp18;
						ValaLocalVariable* local;
						char* _tmp19;
						ValaCCodeIdentifier* _tmp20;
						ValaCCodeIdentifier* length_expr;
						_tmp18 = NULL;
						local = (_tmp18 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
						_tmp19 = NULL;
						_tmp20 = NULL;
						length_expr = (_tmp20 = vala_ccode_identifier_new ((_tmp19 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (local)), dim))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20);
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp21;
							_tmp21 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (local == NULL ? NULL : (local = (g_object_unref (local), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp21));
						} else {
							ValaCCodeIdentifier* _tmp22;
							_tmp22 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp22 = length_expr, (local == NULL ? NULL : (local = (g_object_unref (local), NULL))), _tmp22));
						}
						(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp23;
							ValaField* field;
							_tmp23 = NULL;
							field = (_tmp23 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)));
							if (!vala_field_get_no_array_length (field)) {
								ValaMemberAccess* _tmp24;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaTypesymbol* base_type;
								ValaCCodeExpression* length_expr;
								_tmp24 = NULL;
								ma = (_tmp24 = VALA_MEMBER_ACCESS (array_expr), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* _tmp25;
									_tmp25 = NULL;
									pub_inst = (_tmp25 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp25);
									if (self->current_type_symbol != NULL) {
										ValaTypesymbol* _tmp27;
										ValaTypesymbol* _tmp26;
										/* base type is available if this is a type method */
										_tmp27 = NULL;
										_tmp26 = NULL;
										base_type = (_tmp27 = (_tmp26 = VALA_TYPESYMBOL (self->current_type_symbol), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp27);
									}
								} else {
									ValaCCodeExpression* _tmp29;
									ValaCCodeExpression* _tmp28;
									_tmp29 = NULL;
									_tmp28 = NULL;
									pub_inst = (_tmp29 = (_tmp28 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp29);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaTypesymbol* _tmp31;
										ValaTypesymbol* _tmp30;
										_tmp31 = NULL;
										_tmp30 = NULL;
										base_type = (_tmp31 = (_tmp30 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp30 == NULL ? NULL : g_object_ref (_tmp30))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp31);
									}
								}
								if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
									char* length_cname;
									ValaDataType* instance_expression_type;
									ValaDataType* instance_target_type;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									length_cname = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (field)), dim);
									instance_expression_type = vala_ccode_generator_get_data_type_for_symbol (base_type);
									instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field))));
									typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
									inst = NULL;
									if (vala_symbol_get_access (VALA_SYMBOL (field)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* _tmp32;
										_tmp32 = NULL;
										inst = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp32);
									} else {
										ValaCCodeExpression* _tmp34;
										ValaCCodeExpression* _tmp33;
										_tmp34 = NULL;
										_tmp33 = NULL;
										inst = (_tmp34 = (_tmp33 = typed_inst, (_tmp33 == NULL ? NULL : g_object_ref (_tmp33))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp34);
									}
									if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field)))))) {
										ValaCCodeExpression* _tmp35;
										_tmp35 = NULL;
										length_expr = (_tmp35 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp35);
									} else {
										ValaCCodeExpression* _tmp36;
										_tmp36 = NULL;
										length_expr = (_tmp36 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp36);
									}
									length_cname = (g_free (length_cname), NULL);
									(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
									(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* _tmp39;
									char* _tmp38;
									char* _tmp37;
									_tmp39 = NULL;
									_tmp38 = NULL;
									_tmp37 = NULL;
									length_expr = (_tmp39 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp38 = vala_ccode_generator_get_array_length_cname (self, (_tmp37 = vala_field_get_cname (field)), dim)))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp39);
									_tmp38 = (g_free (_tmp38), NULL);
									_tmp37 = (g_free (_tmp37), NULL);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* _tmp40;
									_tmp40 = NULL;
									return VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp40));
								} else {
									ValaCCodeExpression* _tmp41;
									_tmp41 = NULL;
									return (_tmp41 = length_expr, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp41);
								}
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						} else {
							if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (array_expr))) {
								ValaConstant* _tmp42;
								ValaConstant* constant;
								ValaCCodeIdentifier* _tmp43;
								ValaCCodeFunctionCall* _tmp44;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp46;
								char* _tmp45;
								ValaCCodeFunctionCall* _tmp47;
								_tmp42 = NULL;
								constant = (_tmp42 = VALA_CONSTANT (vala_expression_get_symbol_reference (array_expr)), (_tmp42 == NULL ? NULL : g_object_ref (_tmp42)));
								_tmp43 = NULL;
								_tmp44 = NULL;
								ccall = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("G_N_ELEMENTS")))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), _tmp44);
								_tmp46 = NULL;
								_tmp45 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ((_tmp45 = vala_constant_get_cname (constant))))));
								(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
								_tmp45 = (g_free (_tmp45), NULL);
								_tmp47 = NULL;
								return VALA_CCODE_EXPRESSION ((_tmp47 = ccall, (constant == NULL ? NULL : (constant = (g_object_unref (constant), NULL))), _tmp47));
							}
						}
					}
				}
			} else {
				if (VALA_IS_NULL_LITERAL (array_expr)) {
					return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"));
				}
			}
		}
	}
	if (!is_out) {
		/* allow arrays with unknown length even for value types
		 * as else it may be impossible to bind some libraries
		 * users of affected libraries should explicitly set
		 * the array length as early as possible
		 * by setting the virtual length field of the array
		 */
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


char* vala_ccode_generator_get_delegate_target_cname (ValaCCodeGenerator* self, const char* delegate_cname) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target", delegate_cname);
}


ValaCCodeExpression* vala_ccode_generator_get_delegate_target_cexpression (ValaCCodeGenerator* self, ValaExpression* delegate_expr) {
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (delegate_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	}
	if (VALA_IS_INVOCATION_EXPRESSION (delegate_expr)) {
		ValaInvocationExpression* _tmp1;
		ValaInvocationExpression* invocation_expr;
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp3;
		_tmp1 = NULL;
		invocation_expr = (_tmp1 = VALA_INVOCATION_EXPRESSION (delegate_expr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = vala_invocation_expression_get_delegate_target (invocation_expr), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), _tmp3);
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			if ((self->current_method != NULL && vala_method_get_binding (self->current_method) == MEMBER_BINDING_INSTANCE) || self->priv->in_constructor) {
				return VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self"));
			} else {
				return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
			}
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* _tmp6;
					ValaFormalParameter* param;
					char* _tmp7;
					ValaCCodeIdentifier* _tmp8;
					ValaCCodeExpression* target_expr;
					_tmp6 = NULL;
					param = (_tmp6 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
					_tmp7 = NULL;
					_tmp8 = NULL;
					target_expr = VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (param))))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8));
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeExpression* _tmp10;
						ValaCCodeUnaryExpression* _tmp9;
						/* accessing argument of out/ref param*/
						_tmp10 = NULL;
						_tmp9 = NULL;
						target_expr = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr))))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp10);
						(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
					}
					if (is_out) {
						ValaCCodeUnaryExpression* _tmp11;
						/* passing array as out/ref*/
						_tmp11 = NULL;
						return VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp11));
					} else {
						ValaCCodeExpression* _tmp12;
						_tmp12 = NULL;
						return (_tmp12 = target_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp12);
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* _tmp13;
						ValaLocalVariable* local;
						char* _tmp14;
						ValaCCodeIdentifier* _tmp15;
						ValaCCodeIdentifier* target_expr;
						_tmp13 = NULL;
						local = (_tmp13 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
						_tmp14 = NULL;
						_tmp15 = NULL;
						target_expr = (_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (local))))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15);
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp16;
							_tmp16 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (target_expr)), (local == NULL ? NULL : (local = (g_object_unref (local), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp16));
						} else {
							ValaCCodeIdentifier* _tmp17;
							_tmp17 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp17 = target_expr, (local == NULL ? NULL : (local = (g_object_unref (local), NULL))), _tmp17));
						}
						(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
						(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* _tmp18;
							ValaField* field;
							char* target_cname;
							ValaMemberAccess* _tmp19;
							ValaMemberAccess* ma;
							ValaCCodeExpression* pub_inst;
							ValaTypesymbol* base_type;
							ValaCCodeExpression* target_expr;
							_tmp18 = NULL;
							field = (_tmp18 = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
							target_cname = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (field)));
							_tmp19 = NULL;
							ma = (_tmp19 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19)));
							pub_inst = NULL;
							base_type = NULL;
							target_expr = NULL;
							if (vala_member_access_get_inner (ma) == NULL) {
								ValaCCodeExpression* _tmp20;
								_tmp20 = NULL;
								pub_inst = (_tmp20 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp20);
								if (self->current_type_symbol != NULL) {
									ValaTypesymbol* _tmp22;
									ValaTypesymbol* _tmp21;
									/* base type is available if this is a type method */
									_tmp22 = NULL;
									_tmp21 = NULL;
									base_type = (_tmp22 = (_tmp21 = VALA_TYPESYMBOL (self->current_type_symbol), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp22);
								}
							} else {
								ValaCCodeExpression* _tmp24;
								ValaCCodeExpression* _tmp23;
								_tmp24 = NULL;
								_tmp23 = NULL;
								pub_inst = (_tmp24 = (_tmp23 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp24);
								if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
									ValaTypesymbol* _tmp26;
									ValaTypesymbol* _tmp25;
									_tmp26 = NULL;
									_tmp25 = NULL;
									base_type = (_tmp26 = (_tmp25 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp25 == NULL ? NULL : g_object_ref (_tmp25))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp26);
								}
							}
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								instance_expression_type = vala_ccode_generator_get_data_type_for_symbol (base_type);
								instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field))));
								typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
								inst = NULL;
								if (vala_symbol_get_access (VALA_SYMBOL (field)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp27;
									_tmp27 = NULL;
									inst = (_tmp27 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp27);
								} else {
									ValaCCodeExpression* _tmp29;
									ValaCCodeExpression* _tmp28;
									_tmp29 = NULL;
									_tmp28 = NULL;
									inst = (_tmp29 = (_tmp28 = typed_inst, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp29);
								}
								if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field)))))) {
									ValaCCodeExpression* _tmp30;
									_tmp30 = NULL;
									target_expr = (_tmp30 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, target_cname)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp30);
								} else {
									ValaCCodeExpression* _tmp31;
									_tmp31 = NULL;
									target_expr = (_tmp31 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, target_cname, FALSE)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp31);
								}
								(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
								(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
								(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
								(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
							} else {
								ValaCCodeExpression* _tmp32;
								_tmp32 = NULL;
								target_expr = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (target_cname)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp32);
							}
							if (is_out) {
								ValaCCodeUnaryExpression* _tmp33;
								_tmp33 = NULL;
								return VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp33));
							} else {
								ValaCCodeExpression* _tmp34;
								_tmp34 = NULL;
								return (_tmp34 = target_expr, (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp34);
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
							target_cname = (g_free (target_cname), NULL);
							(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
							(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
							(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
							(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMemberAccess* _tmp35;
								ValaMemberAccess* ma;
								_tmp35 = NULL;
								ma = (_tmp35 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp35 == NULL ? NULL : g_object_ref (_tmp35)));
								if (vala_member_access_get_inner (ma) == NULL) {
									if ((self->current_method != NULL && vala_method_get_binding (self->current_method) == MEMBER_BINDING_INSTANCE) || self->priv->in_constructor) {
										ValaCCodeIdentifier* _tmp36;
										_tmp36 = NULL;
										return VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("self"), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp36));
									} else {
										ValaCCodeConstant* _tmp37;
										_tmp37 = NULL;
										return VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("NULL"), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp37));
									}
								} else {
									ValaCCodeExpression* _tmp38;
									ValaCCodeExpression* _tmp39;
									_tmp38 = NULL;
									_tmp39 = NULL;
									return (_tmp39 = (_tmp38 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp39);
								}
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
							}
						}
					}
				}
			}
		}
	}
	return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
}


static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (expr))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr) {
	ValaCCodeGenerator * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp1 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("self"))), vala_data_type_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaCCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp7;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_ccode_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeBinaryExpression* _tmp5;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp6;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_generator_get_temp_variable (self, vala_property_get_type_reference (prop), TRUE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		cexpr = (_tmp5 = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("1")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
		ccall = vala_ccode_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		_tmp6 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	_tmp7 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp7 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_ccode_generator_find_property_access (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaMemberAccess* _tmp3;
	ValaMemberAccess* ma;
	gpointer _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), _tmp1);
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return NULL;
	}
	_tmp3 = NULL;
	ma = (_tmp3 = VALA_MEMBER_ACCESS (expr), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
		return ma;
	}
	return (_tmp5 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp5);
}


static ValaCCodeExpression* vala_ccode_generator_get_ref_expression (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr), vala_code_node_get_source_reference (VALA_CODE_NODE (expr)));
	if (dupexpr == NULL) {
		gpointer _tmp0;
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		return (_tmp0 = NULL, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp0);
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	if (VALA_IS_STRING_LITERAL (expr)) {
		ValaCCodeFunctionCall* _tmp1;
		/* expression is non-null*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp1 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp1 = ccall, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp1));
	} else {
		ValaLocalVariable* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* _tmp2;
		ValaCCodeBinaryExpression* _tmp3;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp11;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp14;
		ValaCCodeCommaExpression* _tmp15;
		decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (expr), FALSE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (decl)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		cisnull = (_tmp3 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) == NULL) {
			ValaCCodeConstant* _tmp7;
			ValaCCodeExpression* _tmp6;
			ValaCCodeBinaryExpression* _tmp8;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp9;
			if (!(VALA_IS_CLASS (self->current_type_symbol))) {
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp5;
				_tmp4 = NULL;
				_tmp5 = NULL;
				return (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp5);
			}
			/* dup functions are optional for type parameters*/
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp8 = NULL;
			cdupisnull = (_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp6 = vala_ccode_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr), vala_code_node_get_source_reference (VALA_CODE_NODE (expr)))), VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp8);
			_tmp9 = NULL;
			cisnull = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cdupisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp9);
			(cdupisnull == NULL ? NULL : (cdupisnull = (g_object_unref (cdupisnull), NULL)));
		}
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		} else {
			ValaCCodeCastExpression* _tmp10;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp10 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), "gpointer"))));
			(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp11 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		cifnull = NULL;
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			ValaCCodeExpression* _tmp12;
			_tmp12 = NULL;
			cifnull = (_tmp12 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp12);
		} else {
			ValaCCodeExpression* _tmp13;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp13 = NULL;
			cifnull = (_tmp13 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), "gpointer")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp13);
		}
		_tmp14 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), cifnull, VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp15 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp15));
	}
	(dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


void vala_ccode_generator_visit_expression (ValaCCodeGenerator* self, ValaExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_data_type_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_data_type_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		_tmp0 = NULL;
		_tmp1 = NULL;
		csink = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_object_ref_sink")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaLocalVariable* decl;
		ValaCCodeParenthesizedExpression* _tmp5;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, decl);
		gee_list_insert (GEE_LIST (self->temp_ref_vars), 0, decl);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp2 = (g_free (_tmp2), NULL);
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* _tmp6;
			_tmp6 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_ccode_generator_get_ref_expression (self, expr))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		}
	}
}


static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* instance;
	ValaCCodeFunctionCall* creation_call;
	GeeCollection* _tmp0;
	gboolean _tmp1;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (self));
	instance = NULL;
	creation_call = NULL;
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) || gee_collection_get_size ((_tmp0 = vala_object_creation_expression_get_object_initializer (expr))) > 0, (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* _tmp3;
		char* _tmp2;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_generator_get_temp_variable (self, vala_object_creation_expression_get_type_reference (expr), FALSE, VALA_CODE_NODE (expr));
		gee_collection_add (GEE_COLLECTION (self->temp_vars), temp_decl);
		_tmp3 = NULL;
		_tmp2 = NULL;
		instance = (_tmp3 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp2 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	}
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)) == NULL) {
		/* no creation method*/
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->glist_type) || vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->gslist_type)) {
			ValaCCodeConstant* _tmp4;
			/* NULL is an empty list*/
			_tmp4 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp4 = vala_ccode_constant_new ("NULL"))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type)) {
				ValaCCodeFunctionCall* _tmp6;
				ValaCCodeIdentifier* _tmp5;
				ValaCCodeConstant* _tmp8;
				char* _tmp7;
				ValaCCodeConstant* _tmp9;
				_tmp6 = NULL;
				_tmp5 = NULL;
				creation_call = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_object_new")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp6);
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ((_tmp7 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp7 = (g_free (_tmp7), NULL);
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp11;
					ValaCCodeIdentifier* _tmp10;
					ValaCCodeConstant* _tmp13;
					char* _tmp12;
					ValaCCodeConstant* _tmp14;
					_tmp11 = NULL;
					_tmp10 = NULL;
					creation_call = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_new0")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp11);
					(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))))));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					_tmp12 = (g_free (_tmp12), NULL);
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("1"))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp16;
						ValaCCodeIdentifier* _tmp15;
						ValaCCodeUnaryExpression* _tmp17;
						ValaCCodeConstant* _tmp18;
						ValaCCodeIdentifier* _tmp21;
						char* _tmp20;
						char* _tmp19;
						/* memset needs string.h*/
						self->string_h_needed = TRUE;
						_tmp16 = NULL;
						_tmp15 = NULL;
						creation_call = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("memset")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp16);
						(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("0"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
						_tmp21 = NULL;
						_tmp20 = NULL;
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("sizeof (%s)", (_tmp19 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr)))))))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
						_tmp20 = (g_free (_tmp20), NULL);
						_tmp19 = (g_free (_tmp19), NULL);
					}
				}
			}
		}
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
			ValaMethod* _tmp22;
			ValaMethod* m;
			GeeCollection* params;
			ValaCCodeFunctionCall* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			char* _tmp23;
			gboolean ellipsis;
			gint i;
			GeeIterator* params_it;
			/* use creation method*/
			_tmp22 = NULL;
			m = (_tmp22 = VALA_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
			params = vala_method_get_parameters (m);
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			creation_call = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ((_tmp23 = vala_method_get_cname (m)))))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp25);
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			_tmp23 = (g_free (_tmp23), NULL);
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && !(vala_method_get_cinstance_parameter_position (m) < 0)) {
				ValaCCodeUnaryExpression* _tmp26;
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaClass* _tmp27;
					ValaClass* cl;
					_tmp27 = NULL;
					cl = (_tmp27 = VALA_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))), (_tmp27 == NULL ? NULL : g_object_ref (_tmp27)));
					if (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == self->gtypeinstance_type) {
						ValaCCodeIdentifier* _tmp29;
						char* _tmp28;
						_tmp29 = NULL;
						_tmp28 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						_tmp28 = (g_free (_tmp28), NULL);
					}
					(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
				}
			}
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type)) {
				{
					GeeList* type_arg_collection;
					GeeIterator* type_arg_it;
					type_arg_collection = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
					while (gee_iterator_next (type_arg_it)) {
						ValaDataType* type_arg;
						type_arg = ((ValaDataType*) gee_iterator_get (type_arg_it));
						{
							ValaCCodeExpression* _tmp30;
							_tmp30 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (_tmp30 = vala_ccode_generator_get_type_id_expression (self, type_arg)));
							(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
							if (vala_data_type_get_takes_ownership (type_arg)) {
								ValaCCodeExpression* dup_func;
								ValaCCodeCastExpression* _tmp31;
								ValaCCodeExpression* _tmp32;
								dup_func = vala_ccode_generator_get_dup_func_expression (self, type_arg, vala_code_node_get_source_reference (VALA_CODE_NODE (type_arg)));
								if (dup_func == NULL) {
									/* type doesn't contain a copy function*/
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(dup_func == NULL ? NULL : (dup_func = (g_object_unref (dup_func), NULL)));
									(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
									(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
									(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									(creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL)));
									return;
								}
								_tmp31 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc"))));
								(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
								_tmp32 = NULL;
								vala_ccode_function_call_add_argument (creation_call, (_tmp32 = vala_ccode_generator_get_destroy_func_expression (self, type_arg)));
								(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
								(dup_func == NULL ? NULL : (dup_func = (g_object_unref (dup_func), NULL)));
							} else {
								ValaCCodeConstant* _tmp33;
								ValaCCodeConstant* _tmp34;
								_tmp33 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("NULL"))));
								(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
								_tmp34 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("NULL"))));
								(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
							}
							(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
						}
					}
					(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
					(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				}
			}
			ellipsis = FALSE;
			i = 1;
			params_it = gee_iterable_iterator (GEE_ITERABLE (params));
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_object_creation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = ((ValaExpression*) gee_iterator_get (arg_it));
					{
						ValaCCodeExpression* _tmp35;
						ValaCCodeExpression* cexpr;
						ValaFormalParameter* param;
						_tmp35 = NULL;
						cexpr = (_tmp35 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp35 == NULL ? NULL : g_object_ref (_tmp35)));
						param = NULL;
						if (gee_iterator_next (params_it)) {
							ValaFormalParameter* _tmp36;
							_tmp36 = NULL;
							param = (_tmp36 = ((ValaFormalParameter*) gee_iterator_get (params_it)), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp36);
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!vala_formal_parameter_get_ellipsis (param)) {
								ValaCCodeExpression* _tmp37;
								_tmp37 = NULL;
								cexpr = (_tmp37 = vala_ccode_generator_get_implicit_cast_expression (self, cexpr, vala_expression_get_static_type (arg), vala_formal_parameter_get_type_reference (param)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp37);
								/* pass non-simple struct instances always by reference*/
								if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))))) {
									/* we already use a reference for arguments of ref and out parameters*/
									if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
										if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
											ValaCCodeExpression* _tmp38;
											_tmp38 = NULL;
											cexpr = (_tmp38 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp38);
										} else {
											ValaCCodeCommaExpression* ccomma;
											ValaLocalVariable* temp_var;
											ValaCCodeAssignment* _tmp40;
											ValaCCodeIdentifier* _tmp39;
											ValaCCodeUnaryExpression* _tmp42;
											ValaCCodeIdentifier* _tmp41;
											ValaCCodeExpression* _tmp44;
											ValaCCodeCommaExpression* _tmp43;
											/* if cexpr is e.g. a function call, we can't take the address of the expression
											 (tmp = expr, &tmp)*/
											ccomma = vala_ccode_comma_expression_new ();
											temp_var = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (arg), TRUE, NULL);
											gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_var);
											_tmp40 = NULL;
											_tmp39 = NULL;
											vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
											(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
											(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
											_tmp42 = NULL;
											_tmp41 = NULL;
											vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
											(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
											(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
											_tmp44 = NULL;
											_tmp43 = NULL;
											cexpr = (_tmp44 = VALA_CCODE_EXPRESSION ((_tmp43 = ccomma, (_tmp43 == NULL ? NULL : g_object_ref (_tmp43)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp44);
											(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
											(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
										}
									}
								}
							}
						}
						vala_ccode_function_call_add_argument (creation_call, cexpr);
						if (param != NULL && VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
							ValaDelegateType* _tmp45;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp46;
							ValaDelegate* d;
							_tmp45 = NULL;
							deleg_type = (_tmp45 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp45 == NULL ? NULL : g_object_ref (_tmp45)));
							_tmp46 = NULL;
							d = (_tmp46 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp46 == NULL ? NULL : g_object_ref (_tmp46)));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* _tmp47;
								_tmp47 = NULL;
								vala_ccode_function_call_add_argument (creation_call, (_tmp47 = vala_ccode_generator_get_delegate_target_cexpression (self, arg)));
								(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
							}
							(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
							(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
						}
						i++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) gee_iterator_get (params_it));
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp48;
					_tmp48 = NULL;
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp48 = g_strdup_printf ("no default expression for argument %d", i)));
					_tmp48 = (g_free (_tmp48), NULL);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
					(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
					(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
					(creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_method_get_cinstance_parameter_position (m) < 0) {
				ValaCCodeUnaryExpression* _tmp49;
				/* instance parameter is at the end in a struct creation method*/
				_tmp49 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))));
				(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			}
			if (vala_expression_get_can_fail (VALA_EXPRESSION (expr))) {
				ValaCCodeUnaryExpression* _tmp51;
				ValaCCodeIdentifier* _tmp50;
				/* method can fail*/
				self->current_method_inner_error = TRUE;
				_tmp51 = NULL;
				_tmp50 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("inner_error")))))));
				(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
				(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
			}
			if (ellipsis) {
				ValaCCodeConstant* _tmp52;
				/* ensure variable argument list ends with NULL*/
				_tmp52 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_constant_new ("NULL"))));
				(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
			}
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
		} else {
			if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
				ValaErrorCode* _tmp53;
				ValaErrorCode* ecode;
				ValaErrorDomain* _tmp54;
				ValaErrorDomain* edomain;
				ValaCCodeFunctionCall* _tmp56;
				ValaCCodeIdentifier* _tmp55;
				ValaCCodeIdentifier* _tmp58;
				char* _tmp57;
				ValaCCodeIdentifier* _tmp60;
				char* _tmp59;
				_tmp53 = NULL;
				ecode = (_tmp53 = VALA_ERROR_CODE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp53 == NULL ? NULL : g_object_ref (_tmp53)));
				_tmp54 = NULL;
				edomain = (_tmp54 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (VALA_SYMBOL (ecode))), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
				_tmp56 = NULL;
				_tmp55 = NULL;
				creation_call = (_tmp56 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new ("g_error_new")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp56);
				(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
				_tmp58 = NULL;
				_tmp57 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ((_tmp57 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (edomain), NULL))))));
				(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
				_tmp57 = (g_free (_tmp57), NULL);
				_tmp60 = NULL;
				_tmp59 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new ((_tmp59 = vala_error_code_get_cname (ecode))))));
				(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
				_tmp59 = (g_free (_tmp59), NULL);
				{
					GeeCollection* arg_collection;
					GeeIterator* arg_it;
					arg_collection = vala_object_creation_expression_get_argument_list (expr);
					arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
					while (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = ((ValaExpression*) gee_iterator_get (arg_it));
						{
							vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))));
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						}
					}
					(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
					(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
				}
				(ecode == NULL ? NULL : (ecode = (g_object_unref (ecode), NULL)));
				(edomain == NULL ? NULL : (edomain = (g_object_unref (edomain), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (creation_call));
		} else {
			ValaCCodeAssignment* _tmp61;
			_tmp61 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (creation_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
		}
		{
			GeeCollection* init_collection;
			GeeIterator* init_it;
			init_collection = vala_object_creation_expression_get_object_initializer (expr);
			init_it = gee_iterable_iterator (GEE_ITERABLE (init_collection));
			while (gee_iterator_next (init_it)) {
				ValaMemberInitializer* init;
				init = ((ValaMemberInitializer*) gee_iterator_get (init_it));
				{
					if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
						ValaField* _tmp62;
						ValaField* f;
						ValaDataType* instance_target_type;
						ValaCCodeExpression* typed_inst;
						ValaCCodeExpression* lhs;
						ValaCCodeAssignment* _tmp67;
						_tmp62 = NULL;
						f = (_tmp62 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp62 == NULL ? NULL : g_object_ref (_tmp62)));
						instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))));
						typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type);
						lhs = NULL;
						if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
							ValaCCodeExpression* _tmp64;
							char* _tmp63;
							_tmp64 = NULL;
							_tmp63 = NULL;
							lhs = (_tmp64 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (typed_inst, (_tmp63 = vala_field_get_cname (f)), FALSE)), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp64);
							_tmp63 = (g_free (_tmp63), NULL);
						} else {
							ValaCCodeExpression* _tmp66;
							char* _tmp65;
							_tmp66 = NULL;
							_tmp65 = NULL;
							lhs = (_tmp66 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, (_tmp65 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp66);
							_tmp65 = (g_free (_tmp65), NULL);
						}
						_tmp67 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_initializer_get_initializer (init)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
						(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
						(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
						(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
						(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
					} else {
						if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
							ValaMemberAccess* inst_ma;
							ValaMemberAccess* ma;
							ValaCCodeFunctionCall* _tmp68;
							inst_ma = vala_member_access_new_simple ("new", NULL);
							vala_expression_set_static_type (VALA_EXPRESSION (inst_ma), vala_object_creation_expression_get_type_reference (expr));
							vala_code_node_set_ccodenode (VALA_CODE_NODE (inst_ma), VALA_CCODE_NODE (instance));
							ma = vala_member_access_new (VALA_EXPRESSION (inst_ma), vala_member_initializer_get_name (init), NULL);
							_tmp68 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_generator_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_initializer_get_initializer (init))))))));
							(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
							(inst_ma == NULL ? NULL : (inst_ma = (g_object_unref (inst_ma), NULL)));
							(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
						}
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
			}
			(init_collection == NULL ? NULL : (init_collection = (g_object_unref (init_collection), NULL)));
			(init_it == NULL ? NULL : (init_it = (g_object_unref (init_it), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (creation_call != NULL) {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (creation_call));
		}
	}
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL)));
}


static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIZEOF_EXPRESSION (expr));
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("sizeof")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_generator_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	op = 0;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if (vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), self->gtypeinstance_type) && vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)) != self->gtypeinstance_type) {
		/* checked cast for strict subtypes of GTypeInstance*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeFunctionCall* ccheck;
			char* _tmp0;
			ValaCCodeCastExpression* _tmp1;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp2;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (vala_cast_expression_get_inner (expr)), TRUE, VALA_CODE_NODE (expr));
			gee_collection_add (GEE_COLLECTION (self->temp_vars), temp_decl);
			ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_generator_create_type_check (VALA_CCODE_NODE (ctemp), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)));
			_tmp0 = NULL;
			_tmp1 = NULL;
			ccast = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), (_tmp0 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cinit));
			_tmp2 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_EXPRESSION (cnull)))));
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
			(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		} else {
			ValaInstanceCast* _tmp3;
			_tmp3 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp3 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr))))));
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		}
	} else {
		ValaCCodeCastExpression* _tmp5;
		char* _tmp4;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Operation not supported for this type");
			return;
		}
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), (_tmp4 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp4 = (g_free (_tmp4), NULL);
	}
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_pointer_indirection_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_addressof_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE, VALA_CODE_NODE (expr));
	gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	ValaCCodeBinaryExpression* _tmp23;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_left (expr)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_right (expr)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	op = 0;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaCCodeBinaryExpression* _tmp7;
																				ValaCCodeParenthesizedExpression* _tmp6;
																				ValaCCodeParenthesizedExpression* _tmp5;
																				ValaCCodeBinaryExpression* _tmp4;
																				ValaCCodeParenthesizedExpression* _tmp3;
																				ValaCCodeParenthesizedExpression* _tmp2;
																				_tmp7 = NULL;
																				_tmp6 = NULL;
																				_tmp5 = NULL;
																				_tmp4 = NULL;
																				_tmp3 = NULL;
																				_tmp2 = NULL;
																				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_parenthesized_expression_new (cright))), VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_parenthesized_expression_new (cleft))))))))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_parenthesized_expression_new (cleft)))))));
																				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
																				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
																				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
																				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
																				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
																				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
																				vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
																				(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
																				(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
																				return;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		ValaStruct* _tmp9;
		ValaTypesymbol* _tmp8;
		ValaStruct* left_type_as_struct;
		ValaStruct* _tmp11;
		ValaTypesymbol* _tmp10;
		ValaStruct* right_type_as_struct;
		_tmp9 = NULL;
		_tmp8 = NULL;
		left_type_as_struct = (_tmp9 = (_tmp8 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr))), (VALA_IS_STRUCT (_tmp8) ? ((ValaStruct*) _tmp8) : NULL)), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		right_type_as_struct = (_tmp11 = (_tmp10 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr))), (VALA_IS_STRUCT (_tmp10) ? ((ValaStruct*) _tmp10) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))))), self->gobject_type) && VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))))), self->gobject_type)) {
			ValaClass* _tmp12;
			ValaClass* left_cl;
			ValaClass* _tmp13;
			ValaClass* right_cl;
			_tmp12 = NULL;
			left_cl = (_tmp12 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12)));
			_tmp13 = NULL;
			right_cl = (_tmp13 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (left_cl), VALA_TYPESYMBOL (right_cl))) {
					ValaCCodeExpression* _tmp14;
					_tmp14 = NULL;
					cleft = (_tmp14 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_TYPESYMBOL (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), _tmp14);
				} else {
					if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (right_cl), VALA_TYPESYMBOL (left_cl))) {
						ValaCCodeExpression* _tmp15;
						_tmp15 = NULL;
						cright = (_tmp15 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_TYPESYMBOL (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), _tmp15);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		} else {
			if (left_type_as_struct != NULL && VALA_IS_NULL_TYPE (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))) {
				ValaCCodeExpression* _tmp16;
				_tmp16 = NULL;
				cleft = (_tmp16 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cleft)), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), _tmp16);
			} else {
				if (right_type_as_struct != NULL && VALA_IS_NULL_TYPE (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) {
					ValaCCodeExpression* _tmp17;
					_tmp17 = NULL;
					cright = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cright)), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), _tmp17);
				}
			}
		}
		(left_type_as_struct == NULL ? NULL : (left_type_as_struct = (g_object_unref (left_type_as_struct), NULL)));
		(right_type_as_struct == NULL ? NULL : (right_type_as_struct = (g_object_unref (right_type_as_struct), NULL)));
	}
	if (!(VALA_IS_NULL_TYPE (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && vala_data_type_compatible (vala_expression_get_static_type (vala_binary_expression_get_left (expr)), self->string_type) && !(VALA_IS_NULL_TYPE (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))) && vala_data_type_compatible (vala_expression_get_static_type (vala_binary_expression_get_right (expr)), self->string_type) && (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL)) {
		ValaCCodeIdentifier* _tmp18;
		ValaCCodeFunctionCall* _tmp19;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeExpression* _tmp21;
		ValaCCodeFunctionCall* _tmp20;
		ValaCCodeExpression* _tmp22;
		self->priv->requires_strcmp0 = TRUE;
		_tmp18 = NULL;
		_tmp19 = NULL;
		ccall = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("_vala_strcmp0")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19);
		vala_ccode_function_call_add_argument (ccall, cleft);
		vala_ccode_function_call_add_argument (ccall, cright);
		_tmp21 = NULL;
		_tmp20 = NULL;
		cleft = (_tmp21 = VALA_CCODE_EXPRESSION ((_tmp20 = ccall, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), _tmp21);
		_tmp22 = NULL;
		cright = (_tmp22 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), _tmp22);
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	_tmp23 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp23 = vala_ccode_binary_expression_new (op, cleft, cright))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static ValaCCodeFunctionCall* vala_ccode_generator_create_type_check (ValaCCodeNode* ccodenode, ValaTypesymbol* type) {
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccheck;
	g_return_val_if_fail (VALA_IS_CCODE_NODE (ccodenode), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	ccheck = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_upper_case_cname (type, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
	return ccheck;
}


static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeFunctionCall* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPECHECK (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_generator_create_type_check (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_typecheck_get_expression (expr))), vala_data_type_get_data_type (vala_typecheck_get_type_reference (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConditionalExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_false_expression (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaCCodeGenerator * self;
	ValaDelegateType* _tmp0;
	ValaDelegateType* dt;
	GeeArrayList* _tmp1;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp2;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp3;
	GeeArrayList* _tmp4;
	GeeArrayList* _tmp6;
	GeeArrayList* _tmp5;
	GeeArrayList* _tmp8;
	GeeArrayList* _tmp7;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	/* use instance position from delegate*/
	_tmp0 = NULL;
	dt = (_tmp0 = VALA_DELEGATE_TYPE (vala_expression_get_expected_type (VALA_EXPRESSION (l))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_method_set_cinstance_parameter_position (vala_lambda_expression_get_method (l), vala_delegate_get_cinstance_parameter_position (vala_delegate_type_get_delegate_symbol (dt)));
	_tmp1 = NULL;
	old_temp_vars = (_tmp1 = self->temp_vars, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_temp_ref_vars = (_tmp2 = self->temp_ref_vars, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	self->temp_vars = (_tmp3 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal), (self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL))), _tmp3);
	_tmp4 = NULL;
	self->temp_ref_vars = (_tmp4 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal), (self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (g_object_unref (self->temp_ref_vars), NULL))), _tmp4);
	vala_code_node_accept_children (VALA_CODE_NODE (l), VALA_CODE_VISITOR (self));
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->temp_vars = (_tmp6 = (_tmp5 = old_temp_vars, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->temp_ref_vars = (_tmp8 = (_tmp7 = old_temp_ref_vars, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (g_object_unref (self->temp_ref_vars), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname (vala_lambda_expression_get_method (l)))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp9 = (g_free (_tmp9), NULL);
	(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
	(old_temp_vars == NULL ? NULL : (old_temp_vars = (g_object_unref (old_temp_vars), NULL)));
	(old_temp_ref_vars == NULL ? NULL : (old_temp_ref_vars = (g_object_unref (old_temp_ref_vars), NULL)));
}


ValaCCodeExpression* vala_ccode_generator_convert_from_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (actual_type), NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeFunctionCall* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("GPOINTER_TO_UINT")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = VALA_CCODE_EXPRESSION ((_tmp4 = cconv, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeFunctionCall* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("GPOINTER_TO_INT")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = VALA_CCODE_EXPRESSION ((_tmp8 = cconv, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	} else {
		if (vala_data_type_get_data_type (actual_type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (actual_type))) {
			ValaCCodeExpression* _tmp11;
			char* _tmp10;
			_tmp11 = NULL;
			_tmp10 = NULL;
			result = (_tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, (_tmp10 = vala_data_type_get_cname (actual_type)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp11);
			_tmp10 = (g_free (_tmp10), NULL);
		}
	}
	return result;
}


ValaCCodeExpression* vala_ccode_generator_convert_to_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (actual_type), NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeFunctionCall* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("GUINT_TO_POINTER")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = VALA_CCODE_EXPRESSION ((_tmp4 = cconv, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeFunctionCall* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("GINT_TO_POINTER")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = VALA_CCODE_EXPRESSION ((_tmp8 = cconv, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
}


ValaCCodeExpression* vala_ccode_generator_get_implicit_cast_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* expression_type, ValaDataType* target_type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (expression_type == NULL || VALA_IS_DATA_TYPE (expression_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), NULL);
	if (expression_type == NULL) {
		ValaCCodeExpression* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	}
	if (vala_data_type_get_data_type (expression_type) != NULL && vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type)) {
		ValaCCodeExpression* _tmp2;
		/* same type, no cast required*/
		_tmp2 = NULL;
		return (_tmp2 = cexpr, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	}
	if (vala_data_type_get_type_parameter (expression_type) != NULL) {
		return vala_ccode_generator_convert_from_generic_pointer (self, cexpr, target_type);
	} else {
		if (vala_data_type_get_type_parameter (target_type) != NULL) {
			return vala_ccode_generator_convert_to_generic_pointer (self, cexpr, expression_type);
		}
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		ValaCCodeExpression* _tmp6;
		/* null literal, no cast required when not converting to generic type pointer*/
		_tmp6 = NULL;
		return (_tmp6 = cexpr, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	}
	if (vala_code_context_get_checking (self->context) && vala_data_type_get_data_type (target_type) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (target_type), self->gtypeinstance_type) && vala_data_type_get_data_type (target_type) != self->gtypeinstance_type) {
		/* checked cast for strict subtypes of GTypeInstance*/
		return VALA_CCODE_EXPRESSION (vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type)));
	} else {
		char* _tmp10;
		char* _tmp9;
		gboolean _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		if ((_tmp11 = vala_data_type_get_data_type (target_type) != NULL && _vala_strcmp0 ((_tmp9 = vala_data_type_get_cname (expression_type)), (_tmp10 = vala_data_type_get_cname (target_type))) != 0, (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11)) {
			ValaStruct* _tmp13;
			ValaTypesymbol* _tmp12;
			ValaStruct* st;
			_tmp13 = NULL;
			_tmp12 = NULL;
			st = (_tmp13 = (_tmp12 = vala_data_type_get_data_type (target_type), (VALA_IS_STRUCT (_tmp12) ? ((ValaStruct*) _tmp12) : NULL)), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type)) || (st != NULL && vala_struct_is_simple_type (st))) {
				char* _tmp14;
				ValaCCodeCastExpression* _tmp15;
				ValaCCodeCastExpression* _tmp16;
				/* don't cast non-simple structs*/
				_tmp14 = NULL;
				_tmp15 = NULL;
				_tmp16 = NULL;
				return VALA_CCODE_EXPRESSION ((_tmp16 = (_tmp15 = vala_ccode_cast_expression_new (cexpr, (_tmp14 = vala_data_type_get_cname (target_type))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp16));
			} else {
				ValaCCodeExpression* _tmp17;
				ValaCCodeExpression* _tmp18;
				_tmp17 = NULL;
				_tmp18 = NULL;
				return (_tmp18 = (_tmp17 = cexpr, (_tmp17 == NULL ? NULL : g_object_ref (_tmp17))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp18);
			}
			(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (target_type) && VALA_IS_METHOD_TYPE (expression_type)) {
				ValaDelegateType* _tmp19;
				ValaDelegateType* dt;
				ValaMethodType* _tmp20;
				ValaMethodType* mt;
				ValaMethod* _tmp21;
				ValaMethod* method;
				char* _tmp26;
				ValaCCodeIdentifier* _tmp27;
				ValaCCodeIdentifier* _tmp28;
				_tmp19 = NULL;
				dt = (_tmp19 = VALA_DELEGATE_TYPE (target_type), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19)));
				_tmp20 = NULL;
				mt = (_tmp20 = VALA_METHOD_TYPE (expression_type), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
				_tmp21 = NULL;
				method = (_tmp21 = vala_method_type_get_method_symbol (mt), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21)));
				if (vala_method_get_base_method (method) != NULL) {
					ValaMethod* _tmp23;
					ValaMethod* _tmp22;
					_tmp23 = NULL;
					_tmp22 = NULL;
					method = (_tmp23 = (_tmp22 = vala_method_get_base_method (method), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp23);
				} else {
					if (vala_method_get_base_interface_method (method) != NULL) {
						ValaMethod* _tmp25;
						ValaMethod* _tmp24;
						_tmp25 = NULL;
						_tmp24 = NULL;
						method = (_tmp25 = (_tmp24 = vala_method_get_base_interface_method (method), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp25);
					}
				}
				_tmp26 = NULL;
				_tmp27 = NULL;
				_tmp28 = NULL;
				return VALA_CCODE_EXPRESSION ((_tmp28 = (_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_ccode_generator_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt)))), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27), (dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL))), (mt == NULL ? NULL : (mt = (g_object_unref (mt), NULL))), (method == NULL ? NULL : (method = (g_object_unref (method), NULL))), _tmp28));
			} else {
				ValaCCodeExpression* _tmp29;
				_tmp29 = NULL;
				return (_tmp29 = cexpr, (_tmp29 == NULL ? NULL : g_object_ref (_tmp29)));
			}
		}
	}
}


static char* vala_ccode_generator_generate_delegate_wrapper (ValaCCodeGenerator* self, ValaMethod* m, ValaDelegate* d) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* wrapper_name;
	char* _tmp5;
	ValaCCodeFunction* _tmp6;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	GeeCollection* _tmp11;
	gboolean _tmp12;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	GeeCollection* _tmp28;
	gboolean _tmp29;
	ValaCCodeIdentifier* _tmp32;
	char* _tmp31;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp37;
	char* _tmp38;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DELEGATE (d), NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	wrapper_name = (_tmp3 = g_strdup_printf ("_%s_%s", (_tmp0 = vala_method_get_cname (m)), (_tmp2 = vala_symbol_camel_case_to_lower_case ((_tmp1 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (d), FALSE))))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	if (!vala_ccode_generator_add_wrapper (self, wrapper_name)) {
		/* wrapper already defined*/
		return wrapper_name;
	}
	/* declaration*/
	_tmp5 = NULL;
	_tmp6 = NULL;
	function = (_tmp6 = vala_ccode_function_new (wrapper_name, (_tmp5 = vala_data_type_get_cname (vala_method_get_return_type (m)))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (function));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeList* param_collection;
		GeeIterator* param_it;
		param_collection = d_params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				/* ensure that C code node has been generated*/
				vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (self));
				gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				/* handle array parameters*/
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaArrayType* _tmp7;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp7 = NULL;
					array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp8;
						_tmp8 = NULL;
						length_ctype = (_tmp8 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp8);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp9;
							ValaCCodeFormalParameter* _tmp10;
							ValaCCodeFormalParameter* cparam;
							_tmp9 = NULL;
							_tmp10 = NULL;
							cparam = (_tmp10 = vala_ccode_formal_parameter_new ((_tmp9 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp9 = (g_free (_tmp9), NULL)), _tmp10);
							gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp11 = NULL;
	if ((_tmp12 = gee_collection_get_size ((_tmp11 = vala_method_get_error_domains (m))) > 0, (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, ((double) -1), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp13;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (cparam_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp13 = NULL;
		vala_ccode_function_add_parameter (function, (_tmp13 = ((ValaCCodeFormalParameter*) gee_map_get (GEE_MAP (cparam_map), GINT_TO_POINTER (min_pos)))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp14;
			_tmp14 = NULL;
			arg = (_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), _tmp14);
		} else {
			ValaCCodeExpression* _tmp17;
			ValaFormalParameter* _tmp15;
			ValaCCodeNode* _tmp16;
			/* use first delegate parameter as instance*/
			_tmp17 = NULL;
			_tmp15 = NULL;
			_tmp16 = NULL;
			arg = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp16 = vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp15 = ((ValaFormalParameter*) gee_list_get (d_params, 0))))), (VALA_IS_CCODE_FORMAL_PARAMETER (_tmp16) ? ((ValaCCodeFormalParameter*) _tmp16) : NULL)))))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), _tmp17);
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			i = 1;
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
	}
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				ValaCCodeExpression* arg;
				ValaCCodeExpression* _tmp20;
				ValaFormalParameter* _tmp18;
				ValaCCodeNode* _tmp19;
				arg = NULL;
				_tmp20 = NULL;
				_tmp18 = NULL;
				_tmp19 = NULL;
				arg = (_tmp20 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (((_tmp19 = vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp18 = ((ValaFormalParameter*) gee_list_get (d_params, i))))), (VALA_IS_CCODE_FORMAL_PARAMETER (_tmp19) ? ((ValaCCodeFormalParameter*) _tmp19) : NULL)))))), (arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL))), _tmp20);
				(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
				/* handle array arguments*/
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaArrayType* _tmp21;
					ValaArrayType* array_type;
					_tmp21 = NULL;
					array_type = (_tmp21 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21)));
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							ValaCCodeExpression* clength;
							ValaFormalParameter* _tmp22;
							gboolean _tmp23;
							clength = NULL;
							_tmp22 = NULL;
							if ((_tmp23 = vala_formal_parameter_get_no_array_length ((_tmp22 = ((ValaFormalParameter*) gee_list_get (d_params, i)))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), _tmp23)) {
								ValaCCodeExpression* _tmp24;
								_tmp24 = NULL;
								clength = (_tmp24 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")), (clength == NULL ? NULL : (clength = (g_object_unref (clength), NULL))), _tmp24);
							} else {
								ValaCCodeExpression* _tmp27;
								char* _tmp26;
								ValaFormalParameter* _tmp25;
								_tmp27 = NULL;
								_tmp26 = NULL;
								_tmp25 = NULL;
								clength = (_tmp27 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp26 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL ((_tmp25 = ((ValaFormalParameter*) gee_list_get (d_params, i))))), dim)))), (clength == NULL ? NULL : (clength = (g_object_unref (clength), NULL))), _tmp27);
								_tmp26 = (g_free (_tmp26), NULL);
								(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
							}
							gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), clength);
							(clength == NULL ? NULL : (clength = (g_object_unref (clength), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
				}
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp28 = NULL;
	if ((_tmp29 = gee_collection_get_size ((_tmp28 = vala_method_get_error_domains (m))) > 0, (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp29)) {
		ValaCCodeIdentifier* _tmp30;
		_tmp30 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (self, ((double) -1), FALSE)), (_tmp30 = vala_ccode_identifier_new ("error")));
		(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	}
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp33 = NULL;
	ccall = (_tmp33 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = vala_method_get_cname (m)))))), (_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL))), (_tmp31 = (g_free (_tmp31), NULL)), _tmp33);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp34;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp34 = ((ValaCCodeExpression*) gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos)))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp35;
		_tmp35 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	} else {
		ValaCCodeReturnStatement* _tmp36;
		_tmp36 = NULL;
		vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp36 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	}
	/* append to file*/
	_tmp37 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp37 = vala_ccode_function_copy (function))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (function));
	_tmp38 = NULL;
	return (_tmp38 = wrapper_name, (function == NULL ? NULL : (function = (g_object_unref (function), NULL))), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), (d_params == NULL ? NULL : (d_params = (g_object_unref (d_params), NULL))), (carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp38);
}


static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaCCodeGenerator * self;
	ValaCCodeBinding* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	_tmp0 = NULL;
	vala_ccode_binding_emit ((_tmp0 = vala_ccode_generator_code_binding (self, VALA_CODE_NODE (a))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


ValaCCodeFunctionCall* vala_ccode_generator_get_property_set_call (ValaCCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr) {
	char* set_func;
	ValaProperty* _tmp0;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	ValaDataType* instance_expression_type;
	ValaDataType* instance_target_type;
	ValaCCodeExpression* _tmp16;
	ValaCCodeFunctionCall* _tmp19;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	set_func = g_strdup ("g_object_set");
	_tmp0 = NULL;
	base_property = (_tmp0 = prop, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaTypesymbol* _tmp5;
		ValaTypesymbol* base_property_type;
		char* _tmp7;
		char* _tmp6;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp2;
			ValaProperty* _tmp1;
			_tmp2 = NULL;
			_tmp1 = NULL;
			base_property = (_tmp2 = (_tmp1 = vala_property_get_base_property (prop), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp2);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp4;
				ValaProperty* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				base_property = (_tmp4 = (_tmp3 = vala_property_get_base_interface_property (prop), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp4);
			}
		}
		_tmp5 = NULL;
		base_property_type = (_tmp5 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		set_func = (_tmp7 = g_strdup_printf ("%s_set_%s", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (VALA_SYMBOL (base_property))), (set_func = (g_free (set_func), NULL)), _tmp7);
		_tmp6 = (g_free (_tmp6), NULL);
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new (set_func)))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	/* target instance is first argument */
	instance = NULL;
	instance_expression_type = NULL;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* _tmp10;
		ValaDataType* _tmp11;
		_tmp10 = NULL;
		instance = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp10);
		_tmp11 = NULL;
		instance_expression_type = (_tmp11 = vala_ccode_generator_get_data_type_for_symbol (self->current_type_symbol), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp11);
	} else {
		ValaCCodeExpression* _tmp13;
		ValaCCodeExpression* _tmp12;
		ValaDataType* _tmp15;
		ValaDataType* _tmp14;
		_tmp13 = NULL;
		_tmp12 = NULL;
		instance = (_tmp13 = (_tmp12 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		instance_expression_type = (_tmp15 = (_tmp14 = vala_expression_get_static_type (vala_member_access_get_inner (ma)), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp15);
	}
	instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))));
	_tmp16 = NULL;
	instance = (_tmp16 = vala_ccode_generator_get_implicit_cast_expression (self, instance, instance_expression_type, instance_target_type), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp16);
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp17;
		/* property name is second argument of g_object_set */
		_tmp17 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_property_get_canonical_cconstant (prop))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp18;
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL"))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	}
	_tmp19 = NULL;
	return (_tmp19 = ccall, (set_func = (g_free (set_func), NULL)), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), (instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL))), _tmp19);
}


/* indicates whether a given Expression eligable for an ADDRESS_OF operator
 * from a vala to C point of view all expressions denoting locals, fields and
 * parameters are eligable to an ADDRESS_OF operator */
gboolean vala_ccode_generator_is_address_of_possible (ValaCCodeGenerator* self, ValaExpression* e) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	gboolean _tmp7;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_EXPRESSION (e), FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = e, (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (ma == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp2);
	}
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)) == NULL) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp3);
	}
	if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
		gboolean _tmp4;
		return (_tmp4 = TRUE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp4);
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
		gboolean _tmp5;
		return (_tmp5 = TRUE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp5);
	}
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
		gboolean _tmp6;
		return (_tmp6 = TRUE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp6);
	}
	return (_tmp7 = FALSE, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp7);
}


/* retrieve the correct address_of expression for a give expression, creates temporary variables
 * where necessary, ce is the corresponding ccode expression for e */
ValaCCodeExpression* vala_ccode_generator_get_address_of_expression (ValaCCodeGenerator* self, ValaExpression* e, ValaCCodeExpression* ce) {
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeUnaryExpression* _tmp2;
	ValaCCodeCommaExpression* _tmp3;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (e), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (ce), NULL);
	/* is address of trivially possible?*/
	if (vala_ccode_generator_is_address_of_possible (self, e)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ce));
	}
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_generator_get_temp_variable (self, vala_expression_get_static_type (e), TRUE, NULL);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
	gee_collection_add (GEE_COLLECTION (self->temp_vars), temp_decl);
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), ce, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	return VALA_CCODE_EXPRESSION ((_tmp3 = ccomma, (temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), _tmp3));
}


gboolean vala_ccode_generator_add_wrapper (ValaCCodeGenerator* self, const char* wrapper_name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (wrapper_name != NULL, FALSE);
	return gee_collection_add (GEE_COLLECTION (self->priv->wrappers), wrapper_name);
}


ValaDataType* vala_ccode_generator_get_data_type_for_symbol (ValaTypesymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (sym), NULL);
	type = NULL;
	if (VALA_IS_CLASS (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = VALA_DATA_TYPE (vala_class_instance_type_new (VALA_CLASS (sym))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp0);
	} else {
		if (VALA_IS_INTERFACE (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = VALA_DATA_TYPE (vala_interface_instance_type_new (VALA_INTERFACE (sym))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp1);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				type = (_tmp2 = VALA_DATA_TYPE (vala_value_type_new (VALA_TYPESYMBOL (VALA_STRUCT (sym)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp2);
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = VALA_DATA_TYPE (vala_value_type_new (VALA_TYPESYMBOL (VALA_ENUM (sym)))), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp3);
				} else {
					if (VALA_IS_ERROR_DOMAIN (sym)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = VALA_DATA_TYPE (vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL)), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp4);
					} else {
						char* _tmp6;
						char* _tmp5;
						ValaInvalidType* _tmp7;
						_tmp6 = NULL;
						_tmp5 = NULL;
						vala_report_error (NULL, (_tmp6 = g_strdup_printf ("internal error: `%s' is not a supported type", (_tmp5 = vala_symbol_get_full_name (VALA_SYMBOL (sym))))));
						_tmp6 = (g_free (_tmp6), NULL);
						_tmp5 = (g_free (_tmp5), NULL);
						_tmp7 = NULL;
						return VALA_DATA_TYPE ((_tmp7 = vala_invalid_type_new (), (type == NULL ? NULL : (type = (g_object_unref (type), NULL))), _tmp7));
					}
				}
			}
		}
	}
	return type;
}


ValaCCodeExpression* vala_ccode_generator_default_value_for_type (ValaCCodeGenerator* self, ValaDataType* type, gboolean initializer_expression) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if ((vala_data_type_get_data_type (type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type))) || VALA_IS_POINTER_TYPE (type) || VALA_IS_ARRAY_TYPE (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	} else {
		char* _tmp1;
		gboolean _tmp2;
		_tmp1 = NULL;
		if ((_tmp2 = vala_data_type_get_data_type (type) != NULL && (_tmp1 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL, (_tmp1 = (g_free (_tmp1), NULL)), _tmp2)) {
			char* _tmp3;
			ValaCCodeConstant* _tmp4;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type)))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4));
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type)) && initializer_expression) {
				ValaCCodeInitializerList* clist;
				ValaCCodeConstant* _tmp6;
				/* 0-initialize struct with struct initializer { 0 }
				 only allowed as initializer expression in C*/
				clist = vala_ccode_initializer_list_new ();
				_tmp6 = NULL;
				vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("0"))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				return VALA_CCODE_EXPRESSION (clist);
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL) {
					return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
				} else {
					if (VALA_IS_ERROR_TYPE (type)) {
						return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
					}
				}
			}
		}
	}
	return NULL;
}


static ValaCCodeStatement* vala_ccode_generator_create_property_type_check_statement (ValaCCodeGenerator* self, ValaProperty* prop, gboolean check_return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (check_return_type) {
		return vala_ccode_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_property_get_type_reference (prop), t, non_null, var_name);
	} else {
		ValaVoidType* _tmp1;
		ValaCCodeStatement* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = vala_ccode_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), VALA_DATA_TYPE ((_tmp1 = vala_void_type_new ())), t, non_null, var_name), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	}
}


ValaCCodeStatement* vala_ccode_generator_create_type_check_statement (ValaCCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp18;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if ((VALA_IS_CLASS (t) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (t))), self->gobject_type)) || VALA_IS_INTERFACE (t)) {
		ValaCCodeIdentifier* _tmp1;
		char* _tmp0;
		ValaCCodeFunctionCall* _tmp2;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeExpression* cexpr;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		ctype_check = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_upper_case_cname (t, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (var_name))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((_tmp4 = ctype_check, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))));
		if (!non_null) {
			ValaCCodeConstant* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeBinaryExpression* _tmp7;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp8;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			cnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
			_tmp8 = NULL;
			cexpr = (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp8);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer _tmp9;
			return (_tmp9 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp9);
		} else {
			ValaCCodeConstant* _tmp11;
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeBinaryExpression* _tmp12;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp12 = NULL;
			cnonnull = (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("NULL")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp12);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp13;
		/* void function */
		_tmp13 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeExpression* cdefault;
		_tmp14 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp15;
			ValaCCodeExpressionStatement* _tmp16;
			ValaCCodeExpressionStatement* _tmp17;
			_tmp15 = NULL;
			_tmp16 = NULL;
			_tmp17 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp17 = (_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("0")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp17));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp18 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp18));
}


gint vala_ccode_generator_get_param_pos (ValaCCodeGenerator* self, double param_pos, gboolean ellipsis) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), 0);
	if (!ellipsis) {
		if (param_pos >= 0) {
			return ((gint) (param_pos * 1000));
		} else {
			return ((gint) ((100 + param_pos) * 1000));
		}
	} else {
		if (param_pos >= 0) {
			return ((gint) ((100 + param_pos) * 1000));
		} else {
			return ((gint) ((200 + param_pos) * 1000));
		}
	}
}


static ValaCodeBinding* vala_ccode_generator_real_create_namespace_binding (ValaCodeGenerator* base, ValaNamespace* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_NAMESPACE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_class_binding (ValaCodeGenerator* base, ValaClass* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CLASS (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_class_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_struct_binding (ValaCodeGenerator* base, ValaStruct* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_STRUCT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_interface_binding (ValaCodeGenerator* base, ValaInterface* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_INTERFACE (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_interface_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_enum_binding (ValaCodeGenerator* base, ValaEnum* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ENUM (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_enum_value_binding (ValaCodeGenerator* base, ValaEnumValue* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ENUM_VALUE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_error_domain_binding (ValaCodeGenerator* base, ValaErrorDomain* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ERROR_DOMAIN (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_error_code_binding (ValaCodeGenerator* base, ValaErrorCode* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ERROR_CODE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_delegate_binding (ValaCodeGenerator* base, ValaDelegate* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DELEGATE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_constant_binding (ValaCodeGenerator* base, ValaConstant* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CONSTANT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_field_binding (ValaCodeGenerator* base, ValaField* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_FIELD (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_method_binding (ValaCodeGenerator* base, ValaMethod* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_METHOD (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_method_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_dynamic_method_binding (ValaCodeGenerator* base, ValaDynamicMethod* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_dynamic_method_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_creation_method_binding (ValaCodeGenerator* base, ValaCreationMethod* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_creation_method_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_formal_parameter_binding (ValaCodeGenerator* base, ValaFormalParameter* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_property_binding (ValaCodeGenerator* base, ValaProperty* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_PROPERTY (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_property_accessor_binding (ValaCodeGenerator* base, ValaPropertyAccessor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_signal_binding (ValaCodeGenerator* base, ValaSignal* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_SIGNAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_dynamic_signal_binding (ValaCodeGenerator* base, ValaDynamicSignal* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_dynamic_signal_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_constructor_binding (ValaCodeGenerator* base, ValaConstructor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CONSTRUCTOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_destructor_binding (ValaCodeGenerator* base, ValaDestructor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DESTRUCTOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_type_parameter_binding (ValaCodeGenerator* base, ValaTypeParameter* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_TYPEPARAMETER (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_block_binding (ValaCodeGenerator* base, ValaBlock* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_BLOCK (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_empty_statement_binding (ValaCodeGenerator* base, ValaEmptyStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_EMPTY_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_declaration_statement_binding (ValaCodeGenerator* base, ValaDeclarationStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DECLARATION_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_local_variable_binding (ValaCodeGenerator* base, ValaLocalVariable* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_initializer_list_binding (ValaCodeGenerator* base, ValaInitializerList* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_INITIALIZER_LIST (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_expression_statement_binding (ValaCodeGenerator* base, ValaExpressionStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_EXPRESSION_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_if_statement_binding (ValaCodeGenerator* base, ValaIfStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_IF_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_statement_binding (ValaCodeGenerator* base, ValaSwitchStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_SWITCH_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_section_binding (ValaCodeGenerator* base, ValaSwitchSection* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_SWITCH_SECTION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_label_binding (ValaCodeGenerator* base, ValaSwitchLabel* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_SWITCH_LABEL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_while_statement_binding (ValaCodeGenerator* base, ValaWhileStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_WHILE_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_do_statement_binding (ValaCodeGenerator* base, ValaDoStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DO_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_for_statement_binding (ValaCodeGenerator* base, ValaForStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_foreach_statement_binding (ValaCodeGenerator* base, ValaForeachStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_break_statement_binding (ValaCodeGenerator* base, ValaBreakStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_BREAK_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_continue_statement_binding (ValaCodeGenerator* base, ValaContinueStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CONTINUE_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_return_statement_binding (ValaCodeGenerator* base, ValaReturnStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_RETURN_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_throw_statement_binding (ValaCodeGenerator* base, ValaThrowStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_THROW_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_try_statement_binding (ValaCodeGenerator* base, ValaTryStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_TRY_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_catch_clause_binding (ValaCodeGenerator* base, ValaCatchClause* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_lock_statement_binding (ValaCodeGenerator* base, ValaLockStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_delete_statement_binding (ValaCodeGenerator* base, ValaDeleteStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_DELETE_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* base, ValaArrayCreationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_array_creation_expression_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_boolean_literal_binding (ValaCodeGenerator* base, ValaBooleanLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_BOOLEAN_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_character_literal_binding (ValaCodeGenerator* base, ValaCharacterLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CHARACTER_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_integer_literal_binding (ValaCodeGenerator* base, ValaIntegerLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_INTEGER_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_real_literal_binding (ValaCodeGenerator* base, ValaRealLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_REAL_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_string_literal_binding (ValaCodeGenerator* base, ValaStringLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_STRING_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_null_literal_binding (ValaCodeGenerator* base, ValaNullLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_NULL_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* base, ValaParenthesizedExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_member_access_binding (ValaCodeGenerator* base, ValaMemberAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_member_access_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_invocation_expression_binding (ValaCodeGenerator* base, ValaInvocationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_invocation_expression_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_element_access_binding (ValaCodeGenerator* base, ValaElementAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_element_access_binding_new (self, node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_base_access_binding (ValaCodeGenerator* base, ValaBaseAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_BASE_ACCESS (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_postfix_expression_binding (ValaCodeGenerator* base, ValaPostfixExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_POSTFIX_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* base, ValaObjectCreationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* base, ValaSizeofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_SIZEOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_typeof_expression_binding (ValaCodeGenerator* base, ValaTypeofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_TYPEOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_unary_expression_binding (ValaCodeGenerator* base, ValaUnaryExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_UNARY_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_cast_expression_binding (ValaCodeGenerator* base, ValaCastExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CAST_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* base, ValaPointerIndirection* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_POINTER_INDIRECTION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_addressof_expression_binding (ValaCodeGenerator* base, ValaAddressofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* base, ValaReferenceTransferExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_binary_expression_binding (ValaCodeGenerator* base, ValaBinaryExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_BINARY_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_type_check_binding (ValaCodeGenerator* base, ValaTypeCheck* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_TYPECHECK (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_conditional_expression_binding (ValaCodeGenerator* base, ValaConditionalExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_binding (ValaCodeGenerator* base, ValaLambdaExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_assignment_binding (ValaCodeGenerator* base, ValaAssignment* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_assignment_binding_new (self, node));
}


ValaCCodeBinding* vala_ccode_generator_code_binding (ValaCCodeGenerator* self, ValaCodeNode* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), NULL);
	return VALA_CCODE_BINDING (vala_code_node_get_code_binding (node, VALA_CODE_GENERATOR (self)));
}


ValaCCodeMethodBinding* vala_ccode_generator_method_binding (ValaCCodeGenerator* self, ValaMethod* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (node), NULL);
	return VALA_CCODE_METHOD_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


ValaCCodeDynamicMethodBinding* vala_ccode_generator_dynamic_method_binding (ValaCCodeGenerator* self, ValaDynamicMethod* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (node), NULL);
	return VALA_CCODE_DYNAMIC_METHOD_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


ValaCCodeDynamicSignalBinding* vala_ccode_generator_dynamic_signal_binding (ValaCCodeGenerator* self, ValaDynamicSignal* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (node), NULL);
	return VALA_CCODE_DYNAMIC_SIGNAL_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


ValaCCodeArrayCreationExpressionBinding* vala_ccode_generator_array_creation_expression_binding (ValaCCodeGenerator* self, ValaArrayCreationExpression* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (node), NULL);
	return VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


ValaCCodeElementAccessBinding* vala_ccode_generator_element_access_binding (ValaCCodeGenerator* self, ValaElementAccess* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (node), NULL);
	return VALA_CCODE_ELEMENT_ACCESS_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


ValaCCodeAssignmentBinding* vala_ccode_generator_assignment_binding (ValaCCodeGenerator* self, ValaAssignment* node) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (node), NULL);
	return VALA_CCODE_ASSIGNMENT_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self)));
}


static char* vala_ccode_generator_get_marshaller_type_name (ValaCCodeGenerator* self, ValaDataType* t) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			const char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = ("POINTER"), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (t)))) == vala_data_type_get_data_type (self->string_type)) {
					const char* _tmp4;
					_tmp4 = NULL;
					return (_tmp4 = ("BOXED"), (_tmp4 == NULL ? NULL : g_strdup (_tmp4)));
				} else {
					const char* _tmp6;
					_tmp6 = NULL;
					return (_tmp6 = ("POINTER"), (_tmp6 == NULL ? NULL : g_strdup (_tmp6)));
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					const char* _tmp8;
					_tmp8 = NULL;
					return (_tmp8 = ("VOID"), (_tmp8 == NULL ? NULL : g_strdup (_tmp8)));
				} else {
					return vala_typesymbol_get_marshaller_type_name (vala_data_type_get_data_type (t));
				}
			}
		}
	}
}


static char* vala_ccode_generator_get_marshaller_type_name_for_parameter (ValaCCodeGenerator* self, ValaFormalParameter* param) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (param), NULL);
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		return vala_ccode_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (param));
	}
}


char* vala_ccode_generator_get_marshaller_function (ValaCCodeGenerator* self, GeeCollection* params, ValaDataType* return_type, const char* prefix) {
	char* signature;
	char* ret;
	char* _tmp1;
	char* _tmp0;
	char* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (GEE_IS_COLLECTION (params), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	signature = vala_ccode_generator_get_marshaller_signature (self, params, return_type);
	ret = NULL;
	if (prefix == NULL) {
		if (gee_collection_contains (GEE_COLLECTION (self->predefined_marshal_set), signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	ret = (_tmp1 = g_strdup_printf ("%s_%s_", prefix, (_tmp0 = vala_ccode_generator_get_marshaller_type_name (self, return_type))), (ret = (g_free (ret), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (params == NULL || gee_collection_get_size (params) == 0) {
		char* _tmp2;
		_tmp2 = NULL;
		ret = (_tmp2 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), _tmp2);
	} else {
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) gee_iterator_get (p_it));
				{
					char* _tmp4;
					char* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					ret = (_tmp4 = g_strdup_printf ("%s_%s", ret, (_tmp3 = vala_ccode_generator_get_marshaller_type_name_for_parameter (self, p))), (ret = (g_free (ret), NULL)), _tmp4);
					_tmp3 = (g_free (_tmp3), NULL);
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	_tmp5 = NULL;
	return (_tmp5 = ret, (signature = (g_free (signature), NULL)), _tmp5);
}


static char* vala_ccode_generator_get_value_type_name_from_type_reference (ValaCCodeGenerator* self, ValaDataType* t) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			return g_strdup ("void");
		} else {
			if (vala_data_type_get_data_type (t) == vala_data_type_get_data_type (self->string_type)) {
				return g_strdup ("const char*");
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (t)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (t))) {
					return g_strdup ("gpointer");
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (t))) {
						ValaStruct* _tmp4;
						ValaStruct* st;
						_tmp4 = NULL;
						st = (_tmp4 = VALA_STRUCT (vala_data_type_get_data_type (t)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
						if (vala_struct_is_simple_type (st)) {
							char* _tmp5;
							_tmp5 = NULL;
							return (_tmp5 = vala_typesymbol_get_cname (vala_data_type_get_data_type (t), FALSE), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp5);
						} else {
							char* _tmp6;
							_tmp6 = NULL;
							return (_tmp6 = g_strdup ("gpointer"), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp6);
						}
						(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							return g_strdup ("gint");
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								return g_strdup ("gpointer");
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									return g_strdup ("gpointer");
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_ccode_generator_get_value_type_name_from_parameter (ValaCCodeGenerator* self, ValaFormalParameter* p) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (p), NULL);
	if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
		return g_strdup ("gpointer");
	} else {
		return vala_ccode_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p));
	}
}


static char* vala_ccode_generator_get_marshaller_signature (ValaCCodeGenerator* self, GeeCollection* params, ValaDataType* return_type) {
	char* signature;
	char* _tmp1;
	char* _tmp0;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (GEE_IS_COLLECTION (params), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	signature = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	signature = (_tmp1 = g_strdup_printf ("%s:", (_tmp0 = vala_ccode_generator_get_marshaller_type_name (self, return_type))), (signature = (g_free (signature), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (params == NULL || gee_collection_get_size (params) == 0) {
		char* _tmp2;
		_tmp2 = NULL;
		signature = (_tmp2 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), _tmp2);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = ((ValaFormalParameter*) gee_iterator_get (p_it));
				{
					if (first) {
						char* _tmp4;
						char* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						signature = (_tmp4 = g_strconcat (signature, (_tmp3 = vala_ccode_generator_get_marshaller_type_name_for_parameter (self, p)), NULL), (signature = (g_free (signature), NULL)), _tmp4);
						_tmp3 = (g_free (_tmp3), NULL);
						first = FALSE;
					} else {
						char* _tmp6;
						char* _tmp5;
						_tmp6 = NULL;
						_tmp5 = NULL;
						signature = (_tmp6 = g_strdup_printf ("%s,%s", signature, (_tmp5 = vala_ccode_generator_get_marshaller_type_name_for_parameter (self, p))), (signature = (g_free (signature), NULL)), _tmp6);
						_tmp5 = (g_free (_tmp5), NULL);
					}
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	return signature;
}


static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaCCodeGenerator * self;
	GeeList* _tmp4;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	/* parent_symbol may be null for late bound signals*/
	if (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)) != NULL) {
		ValaTypesymbol* _tmp1;
		ValaSymbol* _tmp0;
		ValaTypesymbol* dt;
		_tmp1 = NULL;
		_tmp0 = NULL;
		dt = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)), (VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypesymbol*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (!vala_typesymbol_is_subtype_of (dt, self->gobject_type)) {
			char* _tmp3;
			char* _tmp2;
			vala_code_node_set_error (VALA_CODE_NODE (sig), TRUE);
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sig)), (_tmp3 = g_strdup_printf ("Only classes and interfaces deriving from GLib.Object support signals. `%s' does not derive from GLib.Object.", (_tmp2 = vala_symbol_get_full_name (VALA_SYMBOL (dt))))));
			_tmp3 = (g_free (_tmp3), NULL);
			_tmp2 = (g_free (_tmp2), NULL);
			(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
			return;
		}
		(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	_tmp4 = NULL;
	vala_ccode_generator_generate_marshaller (self, GEE_COLLECTION ((_tmp4 = vala_signal_get_parameters (sig))), vala_signal_get_return_type (sig));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
}


void vala_ccode_generator_generate_marshaller (ValaCCodeGenerator* self, GeeCollection* params, ValaDataType* return_type) {
	char* signature;
	gint n_params;
	gint i;
	char* _tmp0;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFunction* _tmp9;
	ValaCCodeBlock* marshaller_body;
	char* _tmp10;
	ValaCCodeFunctionDeclarator* _tmp11;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFormalParameter* _tmp16;
	ValaCCodeTypeDefinition* _tmp18;
	char* _tmp17;
	char* _tmp19;
	ValaCCodeDeclaration* _tmp20;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp21;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeVariableDeclarator* _tmp25;
	ValaCCodeCastExpression* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeDeclaration* _tmp26;
	ValaCCodeVariableDeclarator* _tmp27;
	ValaCCodeVariableDeclarator* _tmp28;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* _tmp39;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeBinaryExpression* _tmp43;
	ValaCCodeConstant* _tmp42;
	char* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeExpressionStatement* _tmp44;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeMemberAccess* _tmp46;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp48;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeMemberAccess* _tmp49;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp50;
	ValaCCodeFunctionCall* _tmp51;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeAssignment* _tmp54;
	ValaCCodeIdentifier* _tmp53;
	ValaCCodeExpressionStatement* _tmp58;
	ValaCCodeAssignment* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp61;
	ValaCCodeAssignment* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeExpressionStatement* _tmp64;
	ValaCCodeAssignment* _tmp63;
	ValaCCodeIdentifier* _tmp62;
	ValaCCodeIfStatement* _tmp65;
	ValaCCodeCastExpression* _tmp73;
	char* _tmp72;
	ValaCCodeConditionalExpression* _tmp71;
	ValaCCodeMemberAccess* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeIdentifier* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeIdentifier* _tmp66;
	ValaCCodeAssignment* _tmp74;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp75;
	ValaCCodeFunctionCall* _tmp77;
	ValaCCodeIdentifier* _tmp76;
	ValaCCodeIdentifier* _tmp78;
	ValaCCodeIdentifier* _tmp88;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (GEE_IS_COLLECTION (params));
	g_return_if_fail (VALA_IS_DATA_TYPE (return_type));
	signature = NULL;
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp0 = NULL;
	signature = (_tmp0 = vala_ccode_generator_get_marshaller_signature (self, params, return_type), (signature = (g_free (signature), NULL)), _tmp0);
	if (gee_collection_contains (GEE_COLLECTION (self->predefined_marshal_set), signature) || gee_collection_contains (GEE_COLLECTION (self->user_marshal_set), signature)) {
		signature = (g_free (signature), NULL);
		return;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	signal_marshaller = (_tmp2 = vala_ccode_function_new ((_tmp1 = vala_ccode_generator_get_marshaller_function (self, params, return_type, NULL)), "void"), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp3 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp4 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp5 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp6 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp7 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp8 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_fragment_append (self->source_signal_marshaller_declaration, VALA_CCODE_NODE ((_tmp9 = vala_ccode_function_copy (signal_marshaller))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	marshaller_body = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	callback_decl = (_tmp11 = vala_ccode_function_declarator_new ((_tmp10 = vala_ccode_generator_get_marshaller_function (self, params, return_type, "GMarshalFunc"))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp12 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	n_params = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = ((ValaFormalParameter*) gee_iterator_get (p_it));
			{
				ValaCCodeFormalParameter* _tmp15;
				char* _tmp14;
				char* _tmp13;
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp15 = vala_ccode_formal_parameter_new ((_tmp13 = g_strdup_printf ("arg_%d", n_params)), (_tmp14 = vala_ccode_generator_get_value_type_name_from_parameter (self, p)))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				_tmp14 = (g_free (_tmp14), NULL);
				_tmp13 = (g_free (_tmp13), NULL);
				n_params++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp16 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp16 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp18 = vala_ccode_type_definition_new ((_tmp17 = vala_ccode_generator_get_value_type_name_from_type_reference (self, return_type)), VALA_CCODE_DECLARATOR (callback_decl)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp19 = NULL;
	_tmp20 = NULL;
	var_decl = (_tmp20 = vala_ccode_declaration_new ((_tmp19 = vala_ccode_generator_get_marshaller_function (self, params, return_type, "GMarshalFunc"))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp21 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp21 = vala_ccode_variable_declarator_new ("callback"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp22 = NULL;
	var_decl = (_tmp22 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp22);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp25 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("closure"))), "GCClosure *")))))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp26 = NULL;
	var_decl = (_tmp26 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp26);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp27 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp27 = vala_ccode_variable_declarator_new ("data1"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp28 = vala_ccode_variable_declarator_new ("data2"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_data_type_get_data_type (return_type) != NULL || vala_data_type_is_array (return_type)) {
		ValaCCodeDeclaration* _tmp30;
		char* _tmp29;
		ValaCCodeVariableDeclarator* _tmp31;
		ValaCCodeFunctionCall* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeBinaryExpression* _tmp36;
		ValaCCodeConstant* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeExpressionStatement* _tmp37;
		_tmp30 = NULL;
		_tmp29 = NULL;
		var_decl = (_tmp30 = vala_ccode_declaration_new ((_tmp29 = vala_ccode_generator_get_value_type_name_from_type_reference (self, return_type))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp30);
		_tmp29 = (g_free (_tmp29), NULL);
		_tmp31 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp31 = vala_ccode_variable_declarator_new ("v_return"))));
		(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		_tmp33 = NULL;
		_tmp32 = NULL;
		fc = (_tmp33 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp33);
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("return_value"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL")))))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		_tmp37 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	}
	_tmp39 = NULL;
	_tmp38 = NULL;
	fc = (_tmp39 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp39);
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("n_param_values"))), VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ((_tmp41 = g_strdup_printf ("%i", n_params)))))))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	_tmp41 = (g_free (_tmp41), NULL);
	(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	_tmp44 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp44 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	_tmp45 = NULL;
	_tmp46 = NULL;
	data = (_tmp46 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("closure"))), "data", TRUE), (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), _tmp46);
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp49 = NULL;
	param = (_tmp49 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("param_values"))), "data[0]", TRUE))), "v_pointer", FALSE), (_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL))), (_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL))), _tmp49);
	_tmp50 = NULL;
	_tmp51 = NULL;
	cond = (_tmp51 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")))), (_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL))), _tmp51);
	_tmp52 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("closure"))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	true_block = vala_ccode_block_new ();
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp55 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	_tmp58 = NULL;
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp58 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	false_block = vala_ccode_block_new ();
	_tmp61 = NULL;
	_tmp60 = NULL;
	_tmp59 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	_tmp64 = NULL;
	_tmp63 = NULL;
	_tmp62 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp64 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	_tmp65 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp65 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	_tmp73 = NULL;
	_tmp72 = NULL;
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp67 = NULL;
	_tmp66 = NULL;
	_tmp74 = NULL;
	c_assign = (_tmp74 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("callback"))), VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ("cc"))), "callback", TRUE)))))), (_tmp72 = vala_ccode_generator_get_marshaller_function (self, params, return_type, "GMarshalFunc"))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), (_tmp72 = (g_free (_tmp72), NULL)), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), (_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL))), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp74);
	_tmp75 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp75 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
	_tmp77 = NULL;
	_tmp76 = NULL;
	fc = (_tmp77 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("callback")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp77);
	(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
	_tmp78 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ("data1"))));
	(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
	i = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = ((ValaFormalParameter*) gee_iterator_get (p_it));
			{
				char* get_value_function;
				ValaCCodeIdentifier* _tmp82;
				ValaCCodeFunctionCall* _tmp83;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* _tmp87;
				ValaCCodeIdentifier* _tmp86;
				char* _tmp85;
				ValaCCodeIdentifier* _tmp84;
				get_value_function = NULL;
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_type_reference (p)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL || vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp79;
					_tmp79 = NULL;
					get_value_function = (_tmp79 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp79);
				} else {
					if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_type_reference (p))) {
						char* _tmp80;
						_tmp80 = NULL;
						get_value_function = (_tmp80 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp80);
					} else {
						char* _tmp81;
						_tmp81 = NULL;
						get_value_function = (_tmp81 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), _tmp81);
					}
				}
				_tmp82 = NULL;
				_tmp83 = NULL;
				inner_fc = (_tmp83 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new (get_value_function)))), (_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL))), _tmp83);
				_tmp87 = NULL;
				_tmp86 = NULL;
				_tmp85 = NULL;
				_tmp84 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ("param_values"))), VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ((_tmp85 = g_strdup_printf ("%i", i)))))))));
				(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
				(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
				_tmp85 = (g_free (_tmp85), NULL);
				(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				get_value_function = (g_free (get_value_function), NULL);
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp88 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("data2"))));
	(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
	if (vala_data_type_get_data_type (return_type) != NULL || vala_data_type_is_array (return_type)) {
		ValaCCodeExpressionStatement* _tmp91;
		ValaCCodeAssignment* _tmp90;
		ValaCCodeIdentifier* _tmp89;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp107;
		ValaCCodeIdentifier* _tmp108;
		ValaCCodeExpressionStatement* _tmp109;
		_tmp91 = NULL;
		_tmp90 = NULL;
		_tmp89 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp91 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ("v_return"))), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
		(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
		(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
		set_fc = NULL;
		if (vala_data_type_is_array (return_type)) {
			if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (return_type)))) == vala_data_type_get_data_type (self->string_type)) {
				ValaCCodeFunctionCall* _tmp93;
				ValaCCodeIdentifier* _tmp92;
				_tmp93 = NULL;
				_tmp92 = NULL;
				set_fc = (_tmp93 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("g_value_take_boxed")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp93);
				(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
			} else {
				ValaCCodeFunctionCall* _tmp95;
				ValaCCodeIdentifier* _tmp94;
				_tmp95 = NULL;
				_tmp94 = NULL;
				set_fc = (_tmp95 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp95);
				(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
			}
		} else {
			if (vala_data_type_get_type_parameter (return_type) != NULL) {
				ValaCCodeFunctionCall* _tmp97;
				ValaCCodeIdentifier* _tmp96;
				_tmp97 = NULL;
				_tmp96 = NULL;
				set_fc = (_tmp97 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp97);
				(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeFunctionCall* _tmp99;
					ValaCCodeIdentifier* _tmp98;
					_tmp99 = NULL;
					_tmp98 = NULL;
					set_fc = (_tmp99 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp99);
					(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
				} else {
					if (vala_data_type_get_data_type (return_type) == vala_data_type_get_data_type (self->string_type)) {
						ValaCCodeFunctionCall* _tmp101;
						ValaCCodeIdentifier* _tmp100;
						_tmp101 = NULL;
						_tmp100 = NULL;
						set_fc = (_tmp101 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_identifier_new ("g_value_take_string")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp101);
						(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
					} else {
						if (VALA_IS_CLASS (vala_data_type_get_data_type (return_type)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (return_type))) {
							ValaCCodeFunctionCall* _tmp103;
							ValaCCodeIdentifier* _tmp102;
							_tmp103 = NULL;
							_tmp102 = NULL;
							set_fc = (_tmp103 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new ("g_value_take_object")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp103);
							(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
						} else {
							ValaCCodeFunctionCall* _tmp106;
							ValaCCodeIdentifier* _tmp105;
							char* _tmp104;
							_tmp106 = NULL;
							_tmp105 = NULL;
							_tmp104 = NULL;
							set_fc = (_tmp106 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ((_tmp104 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (return_type))))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp106);
							(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
							_tmp104 = (g_free (_tmp104), NULL);
						}
					}
				}
			}
		}
		_tmp107 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("return_value"))));
		(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
		_tmp108 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new ("v_return"))));
		(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
		_tmp109 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp109 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp110;
		_tmp110 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp110 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (self->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	gee_collection_add (GEE_COLLECTION (self->user_marshal_set), signature);
	signature = (g_free (signature), NULL);
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_ccode_generator_get_internal_include (ValaCCodeGenerator* self, const char* filename) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->context) == NULL);
}


static ValaCCodeForStatement* vala_ccode_generator_get_vala_array_free_loop (ValaCCodeGenerator* self, gboolean have_length) {
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeCastExpression* _tmp1;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeElementAccess* _tmp3;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeExpression* cforcond;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeForStatement* _tmp24;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	cbody = vala_ccode_block_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	cptrarray = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("array"))), "gpointer*"), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cea = (_tmp3 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (cptrarray), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("i")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cfreecall = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("destroy_func")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cfreecall, VALA_CCODE_EXPRESSION (cea));
	cforcond = NULL;
	if (have_length) {
		ValaCCodeConstant* _tmp6;
		ValaCCodeBinaryExpression* _tmp7;
		ValaCCodeBinaryExpression* cfreecond;
		ValaCCodeExpression* _tmp10;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeIfStatement* _tmp12;
		ValaCCodeExpressionStatement* _tmp11;
		_tmp6 = NULL;
		_tmp7 = NULL;
		cfreecond = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		cforcond = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("array_length"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp10);
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp12 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cfreecond), VALA_CCODE_STATEMENT ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))), NULL))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		(cfreecond == NULL ? NULL : (cfreecond = (g_object_unref (cfreecond), NULL)));
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeExpressionStatement* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		cforcond = (_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp14);
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp15 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp15 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	}
	cfor = vala_ccode_for_statement_new (cforcond, VALA_CCODE_STATEMENT (cbody));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp24 = NULL;
	return (_tmp24 = cfor, (cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL))), (cptrarray == NULL ? NULL : (cptrarray = (g_object_unref (cptrarray), NULL))), (cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp24);
}


static void vala_ccode_generator_append_vala_array_free (ValaCCodeGenerator* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* clencheck;
	ValaCCodeForStatement* _tmp9;
	ValaCCodeForStatement* _tmp8;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* ciflen;
	ValaCCodeConstant* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	fun = vala_ccode_function_new ("_vala_array_free", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("array_length", "gint")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp3 = vala_ccode_function_copy (fun))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new ("i"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (citdecl));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	clencheck = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("array_length"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("0")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	ciflen = (_tmp10 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (clencheck), VALA_CCODE_STATEMENT ((_tmp8 = vala_ccode_generator_get_vala_array_free_loop (self, TRUE))), VALA_CCODE_STATEMENT ((_tmp9 = vala_ccode_generator_get_vala_array_free_loop (self, FALSE)))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp10);
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (ciflen));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	ccondarr = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("array"))), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("NULL")))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp16 = NULL;
	ccondfunc = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("destroy_func"))), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("NULL")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp16);
	_tmp17 = NULL;
	_tmp18 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccondarr), VALA_CCODE_EXPRESSION (ccondfunc)))), VALA_CCODE_STATEMENT (cdofree), NULL), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_set_block (fun, (_tmp19 = vala_ccode_block_new ()));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
	_tmp20 = NULL;
	_tmp21 = NULL;
	carrfree = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_free")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (carrfree, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("array"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (carrfree)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(cdofree == NULL ? NULL : (cdofree = (g_object_unref (cdofree), NULL)));
	(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
	(clencheck == NULL ? NULL : (clencheck = (g_object_unref (clencheck), NULL)));
	(ciflen == NULL ? NULL : (ciflen = (g_object_unref (ciflen), NULL)));
	(ccondarr == NULL ? NULL : (ccondarr = (g_object_unref (ccondarr), NULL)));
	(ccondfunc == NULL ? NULL : (ccondfunc = (g_object_unref (ccondfunc), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(carrfree == NULL ? NULL : (carrfree = (g_object_unref (carrfree), NULL)));
}


static void vala_ccode_generator_append_vala_array_move (ValaCCodeGenerator* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeIdentifier* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp6;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeParenthesizedExpression* _tmp11;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeCastExpression* _tmp21;
	ValaCCodeConstant* _tmp22;
	ValaCCodeBinaryExpression* _tmp25;
	ValaCCodeParenthesizedExpression* _tmp24;
	ValaCCodeBinaryExpression* _tmp23;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp26;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp28;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeCastExpression* _tmp29;
	ValaCCodeConstant* _tmp30;
	ValaCCodeBinaryExpression* _tmp33;
	ValaCCodeParenthesizedExpression* _tmp32;
	ValaCCodeBinaryExpression* _tmp31;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeIfStatement* _tmp36;
	ValaCCodeBinaryExpression* _tmp35;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	self->string_h_needed = TRUE;
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("element_size", "gsize")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("src", "gint")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp3 = vala_ccode_formal_parameter_new ("dest", "gint")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp4 = vala_ccode_formal_parameter_new ("length", "gint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp5 = vala_ccode_function_copy (fun))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	array = vala_ccode_identifier_new ("array");
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp6 = NULL;
	_tmp7 = NULL;
	src_address = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (element_size))))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
	_tmp8 = NULL;
	_tmp9 = NULL;
	dest_address = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (element_size))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp13 = NULL;
	dest_end_address = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (length))))))), VALA_CCODE_EXPRESSION (element_size))))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_set_block (fun, (_tmp14 = vala_ccode_block_new ()));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp15 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_memmove")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (dest_address));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (src_address));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (length), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	_tmp20 = NULL;
	czero1 = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("memset")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (src_address), "char *"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("0"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (src))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	czeroblock1 = vala_ccode_block_new ();
	_tmp26 = NULL;
	vala_ccode_block_add_statement (czeroblock1, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero1)))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	_tmp28 = NULL;
	czero2 = (_tmp28 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("memset")))), (_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL))), _tmp28);
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (dest_end_address), "char *"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("0"))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	czeroblock2 = vala_ccode_block_new ();
	_tmp34 = NULL;
	vala_ccode_block_add_statement (czeroblock2, VALA_CCODE_NODE ((_tmp34 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero2)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp36 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest)))), VALA_CCODE_STATEMENT (czeroblock1), VALA_CCODE_STATEMENT (czeroblock2)))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	(element_size == NULL ? NULL : (element_size = (g_object_unref (element_size), NULL)));
	(length == NULL ? NULL : (length = (g_object_unref (length), NULL)));
	(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
	(dest == NULL ? NULL : (dest = (g_object_unref (dest), NULL)));
	(src_address == NULL ? NULL : (src_address = (g_object_unref (src_address), NULL)));
	(dest_address == NULL ? NULL : (dest_address = (g_object_unref (dest_address), NULL)));
	(dest_end_address == NULL ? NULL : (dest_end_address = (g_object_unref (dest_end_address), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(czero1 == NULL ? NULL : (czero1 = (g_object_unref (czero1), NULL)));
	(czeroblock1 == NULL ? NULL : (czeroblock1 = (g_object_unref (czeroblock1), NULL)));
	(czero2 == NULL ? NULL : (czero2 = (g_object_unref (czero2), NULL)));
	(czeroblock2 == NULL ? NULL : (czeroblock2 = (g_object_unref (czeroblock2), NULL)));
}


static void vala_ccode_generator_append_vala_strcmp0 (ValaCCodeGenerator* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeBinaryExpression* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeParenthesizedExpression* _tmp6;
	ValaCCodeParenthesizedExpression* cineq;
	ValaCCodeBlock* _tmp7;
	ValaCCodeBlock* cblock;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeIfStatement* _tmp11;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp13;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeConstant* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeReturnStatement* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeReturnStatement* _tmp24;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	fun = vala_ccode_function_new ("_vala_strcmp0", "int");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("str1", "const char *")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("str2", "const char *")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, VALA_CCODE_NODE ((_tmp2 = vala_ccode_function_copy (fun))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	/* (str1 != str2)*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp6 = NULL;
	cineq = (_tmp6 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("str1"))), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("str2"))))))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp6);
	_tmp7 = NULL;
	vala_ccode_function_set_block (fun, (_tmp7 = vala_ccode_block_new ()));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	cblock = vala_ccode_block_new ();
	/* if (str1 == NULL)*/
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp11 = NULL;
	cif = (_tmp11 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("str1"))), VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL")))))), VALA_CCODE_STATEMENT (cblock), NULL), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp11);
	/* return -(str1 != str2);*/
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp13 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (cineq))))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
	_tmp14 = NULL;
	cblock = (_tmp14 = vala_ccode_block_new (), (cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL))), _tmp14);
	/* if (str2 == NULL)*/
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("str2"))), VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("NULL")))))), VALA_CCODE_STATEMENT (cblock), NULL), (cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL))), _tmp18);
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	/* return (str1 != str2);*/
	_tmp19 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp19 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cineq)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
	/* strcmp (str1, str2)*/
	_tmp20 = NULL;
	_tmp21 = NULL;
	ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("strcmp")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("str1"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("str2"))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	/* return strcmp (str1, str2);*/
	_tmp24 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp24 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	vala_ccode_fragment_append (self->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(cineq == NULL ? NULL : (cineq = (g_object_unref (cineq), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* _tmp0;
	ValaCCodeFragment* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* _tmp10;
	ValaCCodeFragment* _tmp11;
	ValaCCodeFragment* _tmp12;
	ValaCCodeFragment* _tmp13;
	GeeSet* _tmp14;
	GeeSet* _tmp15;
	ValaCCodeIncludeDirective* _tmp16;
	ValaCCodeIncludeDirective* _tmp17;
	GeeList* used_includes;
	char* _tmp22;
	char* _tmp57;
	char* _tmp58;
	char* header_define;
	ValaCCodeComment* comment;
	char* _tmp63;
	ValaCCodeWriter* _tmp64;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* _tmp66;
	ValaCCodeNewline* _tmp67;
	ValaCCodeIdentifier* _tmp68;
	ValaCCodeNewline* _tmp69;
	ValaCCodeNewline* _tmp70;
	ValaCCodeNewline* _tmp71;
	ValaCCodeNewline* _tmp72;
	ValaCCodeNewline* _tmp73;
	ValaCCodeNewline* _tmp74;
	ValaCCodeIdentifier* _tmp75;
	ValaCCodeNewline* _tmp76;
	ValaCCodeNewline* _tmp77;
	ValaCCodeWriter* _tmp79;
	char* _tmp78;
	ValaCCodeFragment* _tmp81;
	ValaCCodeFragment* _tmp82;
	ValaCCodeFragment* _tmp83;
	ValaCCodeFragment* _tmp84;
	ValaCCodeFragment* _tmp85;
	ValaCCodeFragment* _tmp86;
	ValaCCodeFragment* _tmp87;
	ValaCCodeFragment* _tmp88;
	ValaCCodeFragment* _tmp89;
	ValaCCodeFragment* _tmp90;
	ValaCCodeFragment* _tmp91;
	ValaCCodeFragment* _tmp92;
	ValaCCodeFragment* _tmp93;
	ValaCCodeFragment* _tmp94;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	_tmp0 = NULL;
	self->header_begin = (_tmp0 = vala_ccode_fragment_new (), (self->header_begin == NULL ? NULL : (self->header_begin = (g_object_unref (self->header_begin), NULL))), _tmp0);
	_tmp1 = NULL;
	self->header_type_declaration = (_tmp1 = vala_ccode_fragment_new (), (self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (g_object_unref (self->header_type_declaration), NULL))), _tmp1);
	_tmp2 = NULL;
	self->header_type_definition = (_tmp2 = vala_ccode_fragment_new (), (self->header_type_definition == NULL ? NULL : (self->header_type_definition = (g_object_unref (self->header_type_definition), NULL))), _tmp2);
	_tmp3 = NULL;
	self->header_type_member_declaration = (_tmp3 = vala_ccode_fragment_new (), (self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (g_object_unref (self->header_type_member_declaration), NULL))), _tmp3);
	_tmp4 = NULL;
	self->header_constant_declaration = (_tmp4 = vala_ccode_fragment_new (), (self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (g_object_unref (self->header_constant_declaration), NULL))), _tmp4);
	_tmp5 = NULL;
	self->source_begin = (_tmp5 = vala_ccode_fragment_new (), (self->source_begin == NULL ? NULL : (self->source_begin = (g_object_unref (self->source_begin), NULL))), _tmp5);
	_tmp6 = NULL;
	self->source_include_directives = (_tmp6 = vala_ccode_fragment_new (), (self->source_include_directives == NULL ? NULL : (self->source_include_directives = (g_object_unref (self->source_include_directives), NULL))), _tmp6);
	_tmp7 = NULL;
	self->source_type_declaration = (_tmp7 = vala_ccode_fragment_new (), (self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (g_object_unref (self->source_type_declaration), NULL))), _tmp7);
	_tmp8 = NULL;
	self->source_type_definition = (_tmp8 = vala_ccode_fragment_new (), (self->source_type_definition == NULL ? NULL : (self->source_type_definition = (g_object_unref (self->source_type_definition), NULL))), _tmp8);
	_tmp9 = NULL;
	self->source_type_member_declaration = (_tmp9 = vala_ccode_fragment_new (), (self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (g_object_unref (self->source_type_member_declaration), NULL))), _tmp9);
	_tmp10 = NULL;
	self->source_constant_declaration = (_tmp10 = vala_ccode_fragment_new (), (self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (g_object_unref (self->source_constant_declaration), NULL))), _tmp10);
	_tmp11 = NULL;
	self->source_type_member_definition = (_tmp11 = vala_ccode_fragment_new (), (self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (g_object_unref (self->source_type_member_definition), NULL))), _tmp11);
	_tmp12 = NULL;
	self->source_signal_marshaller_definition = (_tmp12 = vala_ccode_fragment_new (), (self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (g_object_unref (self->source_signal_marshaller_definition), NULL))), _tmp12);
	_tmp13 = NULL;
	self->source_signal_marshaller_declaration = (_tmp13 = vala_ccode_fragment_new (), (self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (g_object_unref (self->source_signal_marshaller_declaration), NULL))), _tmp13);
	_tmp14 = NULL;
	self->user_marshal_set = (_tmp14 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->user_marshal_set == NULL ? NULL : (self->user_marshal_set = (g_object_unref (self->user_marshal_set), NULL))), _tmp14);
	self->next_temp_var_id = 0;
	self->string_h_needed = FALSE;
	self->dbus_glib_h_needed = FALSE;
	self->priv->requires_free_checked = FALSE;
	self->priv->requires_array_free = FALSE;
	self->requires_array_move = FALSE;
	self->priv->requires_strcmp0 = FALSE;
	_tmp15 = NULL;
	self->priv->wrappers = (_tmp15 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->priv->wrappers == NULL ? NULL : (self->priv->wrappers = (g_object_unref (self->priv->wrappers), NULL))), _tmp15);
	_tmp16 = NULL;
	vala_ccode_fragment_append (self->header_begin, VALA_CCODE_NODE ((_tmp16 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_fragment_append (self->header_begin, VALA_CCODE_NODE ((_tmp17 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	if (vala_code_context_get_basedir (self->context) != NULL || vala_code_context_get_library (self->context) != NULL) {
		ValaCCodeIncludeDirective* _tmp19;
		char* _tmp18;
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp19 = vala_ccode_include_directive_new ((_tmp18 = vala_source_file_get_cinclude_filename (source_file)), FALSE))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		_tmp18 = (g_free (_tmp18), NULL);
	} else {
		ValaCCodeIncludeDirective* _tmp21;
		char* _tmp20;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp21 = vala_ccode_include_directive_new ((_tmp20 = vala_source_file_get_cinclude_filename (source_file)), TRUE))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		_tmp20 = (g_free (_tmp20), NULL);
	}
	used_includes = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_equal));
	gee_collection_add (GEE_COLLECTION (used_includes), "glib.h");
	gee_collection_add (GEE_COLLECTION (used_includes), "glib-object.h");
	_tmp22 = NULL;
	gee_collection_add (GEE_COLLECTION (used_includes), (_tmp22 = vala_source_file_get_cinclude_filename (source_file)));
	_tmp22 = (g_free (_tmp22), NULL);
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = ((char*) gee_iterator_get (filename_it));
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp23;
					_tmp23 = NULL;
					vala_ccode_fragment_append (self->header_begin, VALA_CCODE_NODE ((_tmp23 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = ((char*) gee_iterator_get (filename_it));
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp24;
					_tmp24 = NULL;
					vala_ccode_fragment_append (self->header_begin, VALA_CCODE_NODE ((_tmp24 = vala_ccode_generator_get_internal_include (self, filename))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = ((char*) gee_iterator_get (filename_it));
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp25;
					_tmp25 = NULL;
					vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp25 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = ((char*) gee_iterator_get (filename_it));
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp26;
					_tmp26 = NULL;
					vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp26 = vala_ccode_generator_get_internal_include (self, filename))));
					(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				filename = (g_free (filename), NULL);
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeList* cycle_file_collection;
			GeeIterator* cycle_file_it;
			cycle_file_collection = vala_source_file_get_cycle (source_file)->files;
			cycle_file_it = gee_iterable_iterator (GEE_ITERABLE (cycle_file_collection));
			while (gee_iterator_next (cycle_file_it)) {
				ValaSourceFile* _tmp56;
				ValaSourceFile* cycle_file;
				_tmp56 = NULL;
				cycle_file = (_tmp56 = ((ValaSourceFile*) gee_iterator_get (cycle_file_it)), (_tmp56 == NULL ? NULL : g_object_ref (_tmp56)));
				{
					{
						GeeCollection* node_collection;
						GeeIterator* node_it;
						node_collection = vala_source_file_get_nodes (cycle_file);
						node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
						while (gee_iterator_next (node_it)) {
							ValaCodeNode* node;
							node = ((ValaCodeNode*) gee_iterator_get (node_it));
							{
								if (VALA_IS_STRUCT (node)) {
									ValaStruct* _tmp27;
									ValaStruct* st;
									ValaCCodeTypeDefinition* _tmp32;
									ValaCCodeVariableDeclarator* _tmp31;
									char* _tmp30;
									char* _tmp29;
									char* _tmp28;
									_tmp27 = NULL;
									st = (_tmp27 = VALA_STRUCT (node), (_tmp27 == NULL ? NULL : g_object_ref (_tmp27)));
									_tmp32 = NULL;
									_tmp31 = NULL;
									_tmp30 = NULL;
									_tmp29 = NULL;
									_tmp28 = NULL;
									vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE ((_tmp32 = vala_ccode_type_definition_new ((_tmp29 = g_strdup_printf ("struct _%s", (_tmp28 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp31 = vala_ccode_variable_declarator_new ((_tmp30 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))))))));
									(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
									(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
									_tmp30 = (g_free (_tmp30), NULL);
									_tmp29 = (g_free (_tmp29), NULL);
									_tmp28 = (g_free (_tmp28), NULL);
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								} else {
									if (VALA_IS_CLASS (node)) {
										ValaClass* _tmp33;
										ValaClass* cl;
										_tmp33 = NULL;
										cl = (_tmp33 = VALA_CLASS (node), (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)));
										if (!vala_class_get_is_static (cl)) {
											ValaCCodeTypeDefinition* _tmp38;
											ValaCCodeVariableDeclarator* _tmp37;
											char* _tmp36;
											char* _tmp35;
											char* _tmp34;
											ValaCCodeTypeDefinition* _tmp44;
											ValaCCodeVariableDeclarator* _tmp43;
											char* _tmp42;
											char* _tmp41;
											char* _tmp40;
											char* _tmp39;
											_tmp38 = NULL;
											_tmp37 = NULL;
											_tmp36 = NULL;
											_tmp35 = NULL;
											_tmp34 = NULL;
											vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE ((_tmp38 = vala_ccode_type_definition_new ((_tmp35 = g_strdup_printf ("struct _%s", (_tmp34 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp37 = vala_ccode_variable_declarator_new ((_tmp36 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))));
											(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
											(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
											_tmp36 = (g_free (_tmp36), NULL);
											_tmp35 = (g_free (_tmp35), NULL);
											_tmp34 = (g_free (_tmp34), NULL);
											_tmp44 = NULL;
											_tmp43 = NULL;
											_tmp42 = NULL;
											_tmp41 = NULL;
											_tmp40 = NULL;
											_tmp39 = NULL;
											vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE ((_tmp44 = vala_ccode_type_definition_new ((_tmp40 = g_strdup_printf ("struct _%sClass", (_tmp39 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp43 = vala_ccode_variable_declarator_new ((_tmp42 = g_strdup_printf ("%sClass", (_tmp41 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))))));
											(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
											(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
											_tmp42 = (g_free (_tmp42), NULL);
											_tmp41 = (g_free (_tmp41), NULL);
											_tmp40 = (g_free (_tmp40), NULL);
											_tmp39 = (g_free (_tmp39), NULL);
										}
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									} else {
										if (VALA_IS_INTERFACE (node)) {
											ValaInterface* _tmp45;
											ValaInterface* iface;
											_tmp45 = NULL;
											iface = (_tmp45 = VALA_INTERFACE (node), (_tmp45 == NULL ? NULL : g_object_ref (_tmp45)));
											if (!vala_interface_get_is_static (iface)) {
												ValaCCodeTypeDefinition* _tmp50;
												ValaCCodeVariableDeclarator* _tmp49;
												char* _tmp48;
												char* _tmp47;
												char* _tmp46;
												ValaCCodeTypeDefinition* _tmp55;
												ValaCCodeVariableDeclarator* _tmp54;
												char* _tmp53;
												char* _tmp52;
												char* _tmp51;
												_tmp50 = NULL;
												_tmp49 = NULL;
												_tmp48 = NULL;
												_tmp47 = NULL;
												_tmp46 = NULL;
												vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE ((_tmp50 = vala_ccode_type_definition_new ((_tmp47 = g_strdup_printf ("struct _%s", (_tmp46 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp49 = vala_ccode_variable_declarator_new ((_tmp48 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))))))));
												(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
												(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
												_tmp48 = (g_free (_tmp48), NULL);
												_tmp47 = (g_free (_tmp47), NULL);
												_tmp46 = (g_free (_tmp46), NULL);
												_tmp55 = NULL;
												_tmp54 = NULL;
												_tmp53 = NULL;
												_tmp52 = NULL;
												_tmp51 = NULL;
												vala_ccode_fragment_append (self->header_type_declaration, VALA_CCODE_NODE ((_tmp55 = vala_ccode_type_definition_new ((_tmp52 = g_strdup_printf ("struct _%s", (_tmp51 = vala_interface_get_type_cname (iface)))), VALA_CCODE_DECLARATOR ((_tmp54 = vala_ccode_variable_declarator_new ((_tmp53 = vala_interface_get_type_cname (iface)))))))));
												(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
												(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
												_tmp53 = (g_free (_tmp53), NULL);
												_tmp52 = (g_free (_tmp52), NULL);
												_tmp51 = (g_free (_tmp51), NULL);
											}
											(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
										}
									}
								}
								(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
							}
						}
						(node_collection == NULL ? NULL : (node_collection = (g_object_unref (node_collection), NULL)));
						(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
					}
					(cycle_file == NULL ? NULL : (cycle_file = (g_object_unref (cycle_file), NULL)));
				}
			}
			(cycle_file_it == NULL ? NULL : (cycle_file_it = (g_object_unref (cycle_file_it), NULL)));
		}
	}
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	if (vala_report_get_errors () > 0) {
		(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
		return;
	}
	_tmp57 = NULL;
	_tmp58 = NULL;
	header_define = (_tmp58 = vala_ccode_generator_get_define_for_filename ((_tmp57 = vala_source_file_get_cinclude_filename (source_file))), (_tmp57 = (g_free (_tmp57), NULL)), _tmp58);
	/* generate hardcoded "well-known" macros */
	if (self->priv->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp59;
		_tmp59 = NULL;
		vala_ccode_fragment_append (self->source_begin, VALA_CCODE_NODE ((_tmp59 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
		(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	}
	if (self->priv->requires_array_free) {
		vala_ccode_generator_append_vala_array_free (self);
	}
	if (self->requires_array_move) {
		vala_ccode_generator_append_vala_array_move (self);
	}
	if (self->priv->requires_strcmp0) {
		vala_ccode_generator_append_vala_strcmp0 (self);
	}
	if (self->string_h_needed) {
		ValaCCodeIncludeDirective* _tmp60;
		_tmp60 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp60 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	}
	if (self->dbus_glib_h_needed) {
		ValaCCodeIncludeDirective* _tmp61;
		_tmp61 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, VALA_CCODE_NODE ((_tmp61 = vala_ccode_include_directive_new ("dbus/dbus-glib.h", FALSE))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp62;
		_tmp62 = NULL;
		comment = (_tmp62 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), _tmp62);
	}
	_tmp63 = NULL;
	_tmp64 = NULL;
	writer = (_tmp64 = vala_ccode_writer_new ((_tmp63 = vala_source_file_get_cheader_filename (source_file))), (_tmp63 = (g_free (_tmp63), NULL)), _tmp64);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp65;
		_tmp65 = NULL;
		vala_report_error (NULL, (_tmp65 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer))));
		_tmp65 = (g_free (_tmp65), NULL);
		(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
		header_define = (g_free (header_define), NULL);
		(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
		(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
		return;
	}
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	_tmp66 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp66 = vala_ccode_newline_new ())));
	(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->header_begin));
	_tmp67 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp67 = vala_ccode_newline_new ())));
	(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
	_tmp68 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp68 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
	_tmp69 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp69 = vala_ccode_newline_new ())));
	(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
	_tmp70 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp70 = vala_ccode_newline_new ())));
	(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->header_type_declaration));
	_tmp71 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp71 = vala_ccode_newline_new ())));
	(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->header_type_definition));
	_tmp72 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp72 = vala_ccode_newline_new ())));
	(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->header_type_member_declaration));
	_tmp73 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp73 = vala_ccode_newline_new ())));
	(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->header_constant_declaration));
	_tmp74 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp74 = vala_ccode_newline_new ())));
	(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
	_tmp75 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp75 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
	_tmp76 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp76 = vala_ccode_newline_new ())));
	(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
	_tmp77 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp77 = vala_ccode_newline_new ())));
	(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	_tmp79 = NULL;
	_tmp78 = NULL;
	writer = (_tmp79 = vala_ccode_writer_new ((_tmp78 = vala_source_file_get_csource_filename (source_file))), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), _tmp79);
	_tmp78 = (g_free (_tmp78), NULL);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp80;
		_tmp80 = NULL;
		vala_report_error (NULL, (_tmp80 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer))));
		_tmp80 = (g_free (_tmp80), NULL);
		(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
		header_define = (g_free (header_define), NULL);
		(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
		(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
		(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
		return;
	}
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->context));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined (VALA_CCODE_NODE (self->source_type_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined (VALA_CCODE_NODE (self->source_type_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_constant_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp81 = NULL;
	self->header_begin = (_tmp81 = NULL, (self->header_begin == NULL ? NULL : (self->header_begin = (g_object_unref (self->header_begin), NULL))), _tmp81);
	_tmp82 = NULL;
	self->header_type_declaration = (_tmp82 = NULL, (self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (g_object_unref (self->header_type_declaration), NULL))), _tmp82);
	_tmp83 = NULL;
	self->header_type_definition = (_tmp83 = NULL, (self->header_type_definition == NULL ? NULL : (self->header_type_definition = (g_object_unref (self->header_type_definition), NULL))), _tmp83);
	_tmp84 = NULL;
	self->header_type_member_declaration = (_tmp84 = NULL, (self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (g_object_unref (self->header_type_member_declaration), NULL))), _tmp84);
	_tmp85 = NULL;
	self->header_constant_declaration = (_tmp85 = NULL, (self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (g_object_unref (self->header_constant_declaration), NULL))), _tmp85);
	_tmp86 = NULL;
	self->source_begin = (_tmp86 = NULL, (self->source_begin == NULL ? NULL : (self->source_begin = (g_object_unref (self->source_begin), NULL))), _tmp86);
	_tmp87 = NULL;
	self->source_include_directives = (_tmp87 = NULL, (self->source_include_directives == NULL ? NULL : (self->source_include_directives = (g_object_unref (self->source_include_directives), NULL))), _tmp87);
	_tmp88 = NULL;
	self->source_type_declaration = (_tmp88 = NULL, (self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (g_object_unref (self->source_type_declaration), NULL))), _tmp88);
	_tmp89 = NULL;
	self->source_type_definition = (_tmp89 = NULL, (self->source_type_definition == NULL ? NULL : (self->source_type_definition = (g_object_unref (self->source_type_definition), NULL))), _tmp89);
	_tmp90 = NULL;
	self->source_type_member_declaration = (_tmp90 = NULL, (self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (g_object_unref (self->source_type_member_declaration), NULL))), _tmp90);
	_tmp91 = NULL;
	self->source_constant_declaration = (_tmp91 = NULL, (self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (g_object_unref (self->source_constant_declaration), NULL))), _tmp91);
	_tmp92 = NULL;
	self->source_type_member_definition = (_tmp92 = NULL, (self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (g_object_unref (self->source_type_member_definition), NULL))), _tmp92);
	_tmp93 = NULL;
	self->source_signal_marshaller_definition = (_tmp93 = NULL, (self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (g_object_unref (self->source_signal_marshaller_definition), NULL))), _tmp93);
	_tmp94 = NULL;
	self->source_signal_marshaller_declaration = (_tmp94 = NULL, (self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (g_object_unref (self->source_signal_marshaller_declaration), NULL))), _tmp94);
	(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
	header_define = (g_free (header_define), NULL);
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_ccode_generator_get_define_for_filename (const char* filename) {
	GString* define;
	const char* _tmp0;
	char* i;
	const char* _tmp3;
	char* _tmp4;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	_tmp0 = NULL;
	i = (_tmp0 = filename, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* _tmp2;
		const char* _tmp1;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		i = (_tmp2 = (_tmp1 = g_utf8_next_char (i), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (i = (g_free (i), NULL)), _tmp2);
	}
	g_string_append (define, "__");
	_tmp3 = NULL;
	_tmp4 = NULL;
	return (_tmp4 = (_tmp3 = define->str, (_tmp3 == NULL ? NULL : g_strdup (_tmp3))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), _tmp4);
}


static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaCCodeGenerator * self;
	ValaTypesymbol* _tmp0;
	ValaTypesymbol* old_type_symbol;
	ValaCCodeStruct* _tmp1;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaTypesymbol* _tmp4;
	ValaStruct* _tmp3;
	ValaCCodeStruct* _tmp7;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypesymbol* _tmp24;
	ValaTypesymbol* _tmp23;
	ValaCCodeStruct* _tmp26;
	ValaCCodeStruct* _tmp25;
	ValaCCodeFragment* _tmp28;
	ValaCCodeFragment* _tmp27;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = self->current_type_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_instance_struct = (_tmp1 = self->instance_struct, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_instance_dispose_fragment = (_tmp2 = self->instance_dispose_fragment, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->current_type_symbol = (_tmp4 = VALA_TYPESYMBOL ((_tmp3 = st, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp4);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->instance_struct = (_tmp7 = vala_ccode_struct_new ((_tmp6 = g_strdup_printf ("_%s", (_tmp5 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))), (self->instance_struct == NULL ? NULL : (self->instance_struct = (g_object_unref (self->instance_struct), NULL))), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp8 = NULL;
	self->instance_dispose_fragment = (_tmp8 = vala_ccode_fragment_new (), (self->instance_dispose_fragment == NULL ? NULL : (self->instance_dispose_fragment = (g_object_unref (self->instance_dispose_fragment), NULL))), _tmp8);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (st)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		decl_frag = (_tmp10 = (_tmp9 = self->header_type_declaration, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		def_frag = (_tmp12 = (_tmp11 = self->header_type_definition, (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp12);
	} else {
		ValaCCodeFragment* _tmp14;
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp16;
		ValaCCodeFragment* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		decl_frag = (_tmp14 = (_tmp13 = self->source_type_declaration, (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		def_frag = (_tmp16 = (_tmp15 = self->source_type_definition, (_tmp15 == NULL ? NULL : g_object_ref (_tmp15))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp16);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp21;
		ValaCCodeVariableDeclarator* _tmp20;
		char* _tmp19;
		char* _tmp18;
		char* _tmp17;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp21 = vala_ccode_type_definition_new ((_tmp18 = g_strdup_printf ("struct _%s", (_tmp17 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp20 = vala_ccode_variable_declarator_new ((_tmp19 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		_tmp17 = (g_free (_tmp17), NULL);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st))) != NULL) {
		ValaCCodeComment* _tmp22;
		_tmp22 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp22 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	_tmp24 = NULL;
	_tmp23 = NULL;
	self->current_type_symbol = (_tmp24 = (_tmp23 = old_type_symbol, (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp24);
	_tmp26 = NULL;
	_tmp25 = NULL;
	self->instance_struct = (_tmp26 = (_tmp25 = old_instance_struct, (_tmp25 == NULL ? NULL : g_object_ref (_tmp25))), (self->instance_struct == NULL ? NULL : (self->instance_struct = (g_object_unref (self->instance_struct), NULL))), _tmp26);
	_tmp28 = NULL;
	_tmp27 = NULL;
	self->instance_dispose_fragment = (_tmp28 = (_tmp27 = old_instance_dispose_fragment, (_tmp27 == NULL ? NULL : g_object_ref (_tmp27))), (self->instance_dispose_fragment == NULL ? NULL : (self->instance_dispose_fragment = (g_object_unref (self->instance_dispose_fragment), NULL))), _tmp28);
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static GObject * vala_ccode_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaCCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCCodeGenerator * self;
	klass = VALA_CCODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CCODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CCODE_GENERATOR (obj);
	{
		GeeSet* _tmp0;
		GeeSet* _tmp1;
		_tmp0 = NULL;
		self->predefined_marshal_set = (_tmp0 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->predefined_marshal_set == NULL ? NULL : (self->predefined_marshal_set = (g_object_unref (self->predefined_marshal_set), NULL))), _tmp0);
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:VOID");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:BOOLEAN");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:CHAR");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:UCHAR");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:INT");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:UINT");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:LONG");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:ULONG");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:ENUM");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:FLAGS");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:FLOAT");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:DOUBLE");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:STRING");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:POINTER");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:OBJECT");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "STRING:OBJECT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "VOID:UINT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->predefined_marshal_set), "BOOLEAN:FLAGS");
		_tmp1 = NULL;
		self->c_keywords = (_tmp1 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->c_keywords == NULL ? NULL : (self->c_keywords = (g_object_unref (self->c_keywords), NULL))), _tmp1);
		/* C99 keywords*/
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "_Bool");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "_Complex");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "_Imaginary");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "auto");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "break");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "case");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "char");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "const");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "continue");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "default");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "do");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "double");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "else");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "enum");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "extern");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "float");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "for");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "goto");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "if");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "inline");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "int");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "long");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "register");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "restrict");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "return");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "short");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "signed");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "sizeof");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "static");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "struct");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "switch");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "typedef");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "union");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "unsigned");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "void");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "volatile");
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "while");
		/* MSVC keywords*/
		gee_collection_add (GEE_COLLECTION (self->c_keywords), "cdecl");
	}
	return obj;
}


static void vala_ccode_generator_class_init (ValaCCodeGeneratorClass * klass) {
	vala_ccode_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->constructor = vala_ccode_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_generator_dispose;
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_ccode_generator_real_emit;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_ccode_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_ccode_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_ccode_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_ccode_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_ccode_generator_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_ccode_generator_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_ccode_generator_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_ccode_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_ccode_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_ccode_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_ccode_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_ccode_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_ccode_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_ccode_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_ccode_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_ccode_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_ccode_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = vala_ccode_generator_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_ccode_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_ccode_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = vala_ccode_generator_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_ccode_generator_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_ccode_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_ccode_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_ccode_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_ccode_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = vala_ccode_generator_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_ccode_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_ccode_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_ccode_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_ccode_generator_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_ccode_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_ccode_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = vala_ccode_generator_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_ccode_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_ccode_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_ccode_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_ccode_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delete_statement = vala_ccode_generator_real_visit_delete_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_ccode_generator_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_ccode_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_ccode_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_ccode_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_ccode_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_ccode_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_ccode_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_ccode_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_ccode_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_invocation_expression = vala_ccode_generator_real_visit_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_ccode_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_ccode_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_ccode_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = vala_ccode_generator_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_ccode_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_ccode_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_ccode_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_ccode_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_ccode_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_ccode_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_ccode_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_ccode_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_ccode_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = vala_ccode_generator_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_ccode_generator_real_visit_assignment;
	VALA_CODE_GENERATOR_CLASS (klass)->create_namespace_binding = vala_ccode_generator_real_create_namespace_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_class_binding = vala_ccode_generator_real_create_class_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_struct_binding = vala_ccode_generator_real_create_struct_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_interface_binding = vala_ccode_generator_real_create_interface_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_binding = vala_ccode_generator_real_create_enum_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_value_binding = vala_ccode_generator_real_create_enum_value_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_error_domain_binding = vala_ccode_generator_real_create_error_domain_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_error_code_binding = vala_ccode_generator_real_create_error_code_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_delegate_binding = vala_ccode_generator_real_create_delegate_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constant_binding = vala_ccode_generator_real_create_constant_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_field_binding = vala_ccode_generator_real_create_field_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_method_binding = vala_ccode_generator_real_create_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_dynamic_method_binding = vala_ccode_generator_real_create_dynamic_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_creation_method_binding = vala_ccode_generator_real_create_creation_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_formal_parameter_binding = vala_ccode_generator_real_create_formal_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_binding = vala_ccode_generator_real_create_property_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_accessor_binding = vala_ccode_generator_real_create_property_accessor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_signal_binding = vala_ccode_generator_real_create_signal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_dynamic_signal_binding = vala_ccode_generator_real_create_dynamic_signal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constructor_binding = vala_ccode_generator_real_create_constructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_destructor_binding = vala_ccode_generator_real_create_destructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_parameter_binding = vala_ccode_generator_real_create_type_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_block_binding = vala_ccode_generator_real_create_block_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_empty_statement_binding = vala_ccode_generator_real_create_empty_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_declaration_statement_binding = vala_ccode_generator_real_create_declaration_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_local_variable_binding = vala_ccode_generator_real_create_local_variable_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_initializer_list_binding = vala_ccode_generator_real_create_initializer_list_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_expression_statement_binding = vala_ccode_generator_real_create_expression_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_if_statement_binding = vala_ccode_generator_real_create_if_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_statement_binding = vala_ccode_generator_real_create_switch_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_section_binding = vala_ccode_generator_real_create_switch_section_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_label_binding = vala_ccode_generator_real_create_switch_label_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_while_statement_binding = vala_ccode_generator_real_create_while_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_do_statement_binding = vala_ccode_generator_real_create_do_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_for_statement_binding = vala_ccode_generator_real_create_for_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_foreach_statement_binding = vala_ccode_generator_real_create_foreach_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_break_statement_binding = vala_ccode_generator_real_create_break_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_continue_statement_binding = vala_ccode_generator_real_create_continue_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_return_statement_binding = vala_ccode_generator_real_create_return_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_throw_statement_binding = vala_ccode_generator_real_create_throw_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_try_statement_binding = vala_ccode_generator_real_create_try_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_catch_clause_binding = vala_ccode_generator_real_create_catch_clause_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lock_statement_binding = vala_ccode_generator_real_create_lock_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_delete_statement_binding = vala_ccode_generator_real_create_delete_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_array_creation_expression_binding = vala_ccode_generator_real_create_array_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_boolean_literal_binding = vala_ccode_generator_real_create_boolean_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_character_literal_binding = vala_ccode_generator_real_create_character_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_integer_literal_binding = vala_ccode_generator_real_create_integer_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_real_literal_binding = vala_ccode_generator_real_create_real_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_string_literal_binding = vala_ccode_generator_real_create_string_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_null_literal_binding = vala_ccode_generator_real_create_null_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_parenthesized_expression_binding = vala_ccode_generator_real_create_parenthesized_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_member_access_binding = vala_ccode_generator_real_create_member_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_invocation_expression_binding = vala_ccode_generator_real_create_invocation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_element_access_binding = vala_ccode_generator_real_create_element_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_base_access_binding = vala_ccode_generator_real_create_base_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_postfix_expression_binding = vala_ccode_generator_real_create_postfix_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_object_creation_expression_binding = vala_ccode_generator_real_create_object_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_sizeof_expression_binding = vala_ccode_generator_real_create_sizeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_typeof_expression_binding = vala_ccode_generator_real_create_typeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_unary_expression_binding = vala_ccode_generator_real_create_unary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_cast_expression_binding = vala_ccode_generator_real_create_cast_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_pointer_indirection_binding = vala_ccode_generator_real_create_pointer_indirection_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_addressof_expression_binding = vala_ccode_generator_real_create_addressof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_reference_transfer_expression_binding = vala_ccode_generator_real_create_reference_transfer_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_binary_expression_binding = vala_ccode_generator_real_create_binary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_check_binding = vala_ccode_generator_real_create_type_check_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_conditional_expression_binding = vala_ccode_generator_real_create_conditional_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lambda_expression_binding = vala_ccode_generator_real_create_lambda_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_assignment_binding = vala_ccode_generator_real_create_assignment_binding;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_ccode_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_ccode_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_ccode_generator_real_visit_struct;
}


static void vala_ccode_generator_init (ValaCCodeGenerator * self) {
	self->priv = VALA_CCODE_GENERATOR_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal);
	self->temp_ref_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal);
	self->next_temp_var_id = 0;
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->in_creation_method = FALSE;
	self->priv->in_constructor = FALSE;
	self->current_method_inner_error = FALSE;
	self->in_plugin = FALSE;
}


static void vala_ccode_generator_dispose (GObject * obj) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (obj);
	(self->context == NULL ? NULL : (self->context = (g_object_unref (self->context), NULL)));
	(self->root_symbol == NULL ? NULL : (self->root_symbol = (g_object_unref (self->root_symbol), NULL)));
	(self->current_symbol == NULL ? NULL : (self->current_symbol = (g_object_unref (self->current_symbol), NULL)));
	(self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL)));
	(self->current_class == NULL ? NULL : (self->current_class = (g_object_unref (self->current_class), NULL)));
	(self->current_method == NULL ? NULL : (self->current_method = (g_object_unref (self->current_method), NULL)));
	(self->current_return_type == NULL ? NULL : (self->current_return_type = (g_object_unref (self->current_return_type), NULL)));
	(self->current_try == NULL ? NULL : (self->current_try = (g_object_unref (self->current_try), NULL)));
	(self->current_property_accessor == NULL ? NULL : (self->current_property_accessor = (g_object_unref (self->current_property_accessor), NULL)));
	(self->header_begin == NULL ? NULL : (self->header_begin = (g_object_unref (self->header_begin), NULL)));
	(self->header_type_declaration == NULL ? NULL : (self->header_type_declaration = (g_object_unref (self->header_type_declaration), NULL)));
	(self->header_type_definition == NULL ? NULL : (self->header_type_definition = (g_object_unref (self->header_type_definition), NULL)));
	(self->header_type_member_declaration == NULL ? NULL : (self->header_type_member_declaration = (g_object_unref (self->header_type_member_declaration), NULL)));
	(self->header_constant_declaration == NULL ? NULL : (self->header_constant_declaration = (g_object_unref (self->header_constant_declaration), NULL)));
	(self->source_begin == NULL ? NULL : (self->source_begin = (g_object_unref (self->source_begin), NULL)));
	(self->source_include_directives == NULL ? NULL : (self->source_include_directives = (g_object_unref (self->source_include_directives), NULL)));
	(self->source_type_declaration == NULL ? NULL : (self->source_type_declaration = (g_object_unref (self->source_type_declaration), NULL)));
	(self->source_type_definition == NULL ? NULL : (self->source_type_definition = (g_object_unref (self->source_type_definition), NULL)));
	(self->source_type_member_declaration == NULL ? NULL : (self->source_type_member_declaration = (g_object_unref (self->source_type_member_declaration), NULL)));
	(self->source_constant_declaration == NULL ? NULL : (self->source_constant_declaration = (g_object_unref (self->source_constant_declaration), NULL)));
	(self->source_signal_marshaller_declaration == NULL ? NULL : (self->source_signal_marshaller_declaration = (g_object_unref (self->source_signal_marshaller_declaration), NULL)));
	(self->source_type_member_definition == NULL ? NULL : (self->source_type_member_definition = (g_object_unref (self->source_type_member_definition), NULL)));
	(self->class_init_fragment == NULL ? NULL : (self->class_init_fragment = (g_object_unref (self->class_init_fragment), NULL)));
	(self->instance_init_fragment == NULL ? NULL : (self->instance_init_fragment = (g_object_unref (self->instance_init_fragment), NULL)));
	(self->instance_dispose_fragment == NULL ? NULL : (self->instance_dispose_fragment = (g_object_unref (self->instance_dispose_fragment), NULL)));
	(self->source_signal_marshaller_definition == NULL ? NULL : (self->source_signal_marshaller_definition = (g_object_unref (self->source_signal_marshaller_definition), NULL)));
	(self->module_init_fragment == NULL ? NULL : (self->module_init_fragment = (g_object_unref (self->module_init_fragment), NULL)));
	(self->instance_struct == NULL ? NULL : (self->instance_struct = (g_object_unref (self->instance_struct), NULL)));
	(self->type_struct == NULL ? NULL : (self->type_struct = (g_object_unref (self->type_struct), NULL)));
	(self->instance_priv_struct == NULL ? NULL : (self->instance_priv_struct = (g_object_unref (self->instance_priv_struct), NULL)));
	(self->prop_enum == NULL ? NULL : (self->prop_enum = (g_object_unref (self->prop_enum), NULL)));
	(self->cenum == NULL ? NULL : (self->cenum = (g_object_unref (self->cenum), NULL)));
	(self->function == NULL ? NULL : (self->function = (g_object_unref (self->function), NULL)));
	(self->block == NULL ? NULL : (self->block = (g_object_unref (self->block), NULL)));
	(self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL)));
	(self->temp_ref_vars == NULL ? NULL : (self->temp_ref_vars = (g_object_unref (self->temp_ref_vars), NULL)));
	(self->user_marshal_set == NULL ? NULL : (self->user_marshal_set = (g_object_unref (self->user_marshal_set), NULL)));
	(self->predefined_marshal_set == NULL ? NULL : (self->predefined_marshal_set = (g_object_unref (self->predefined_marshal_set), NULL)));
	(self->c_keywords == NULL ? NULL : (self->c_keywords = (g_object_unref (self->c_keywords), NULL)));
	(self->bool_type == NULL ? NULL : (self->bool_type = (g_object_unref (self->bool_type), NULL)));
	(self->char_type == NULL ? NULL : (self->char_type = (g_object_unref (self->char_type), NULL)));
	(self->unichar_type == NULL ? NULL : (self->unichar_type = (g_object_unref (self->unichar_type), NULL)));
	(self->short_type == NULL ? NULL : (self->short_type = (g_object_unref (self->short_type), NULL)));
	(self->ushort_type == NULL ? NULL : (self->ushort_type = (g_object_unref (self->ushort_type), NULL)));
	(self->int_type == NULL ? NULL : (self->int_type = (g_object_unref (self->int_type), NULL)));
	(self->uint_type == NULL ? NULL : (self->uint_type = (g_object_unref (self->uint_type), NULL)));
	(self->long_type == NULL ? NULL : (self->long_type = (g_object_unref (self->long_type), NULL)));
	(self->ulong_type == NULL ? NULL : (self->ulong_type = (g_object_unref (self->ulong_type), NULL)));
	(self->int8_type == NULL ? NULL : (self->int8_type = (g_object_unref (self->int8_type), NULL)));
	(self->uint8_type == NULL ? NULL : (self->uint8_type = (g_object_unref (self->uint8_type), NULL)));
	(self->int64_type == NULL ? NULL : (self->int64_type = (g_object_unref (self->int64_type), NULL)));
	(self->uint64_type == NULL ? NULL : (self->uint64_type = (g_object_unref (self->uint64_type), NULL)));
	(self->string_type == NULL ? NULL : (self->string_type = (g_object_unref (self->string_type), NULL)));
	(self->float_type == NULL ? NULL : (self->float_type = (g_object_unref (self->float_type), NULL)));
	(self->double_type == NULL ? NULL : (self->double_type = (g_object_unref (self->double_type), NULL)));
	(self->gtype_type == NULL ? NULL : (self->gtype_type = (g_object_unref (self->gtype_type), NULL)));
	(self->gtypeinstance_type == NULL ? NULL : (self->gtypeinstance_type = (g_object_unref (self->gtypeinstance_type), NULL)));
	(self->gobject_type == NULL ? NULL : (self->gobject_type = (g_object_unref (self->gobject_type), NULL)));
	(self->gerror_type == NULL ? NULL : (self->gerror_type = (g_object_unref (self->gerror_type), NULL)));
	(self->glist_type == NULL ? NULL : (self->glist_type = (g_object_unref (self->glist_type), NULL)));
	(self->gslist_type == NULL ? NULL : (self->gslist_type = (g_object_unref (self->gslist_type), NULL)));
	(self->gstringbuilder_type == NULL ? NULL : (self->gstringbuilder_type = (g_object_unref (self->gstringbuilder_type), NULL)));
	(self->garray_type == NULL ? NULL : (self->garray_type = (g_object_unref (self->garray_type), NULL)));
	(self->gquark_type == NULL ? NULL : (self->gquark_type = (g_object_unref (self->gquark_type), NULL)));
	(self->mutex_type == NULL ? NULL : (self->mutex_type = (g_object_unref (self->mutex_type), NULL)));
	(self->type_module_type == NULL ? NULL : (self->type_module_type = (g_object_unref (self->type_module_type), NULL)));
	(self->iterable_type == NULL ? NULL : (self->iterable_type = (g_object_unref (self->iterable_type), NULL)));
	(self->iterator_type == NULL ? NULL : (self->iterator_type = (g_object_unref (self->iterator_type), NULL)));
	(self->list_type == NULL ? NULL : (self->list_type = (g_object_unref (self->list_type), NULL)));
	(self->map_type == NULL ? NULL : (self->map_type = (g_object_unref (self->map_type), NULL)));
	(self->dbus_object_type == NULL ? NULL : (self->dbus_object_type = (g_object_unref (self->dbus_object_type), NULL)));
	(self->substring_method == NULL ? NULL : (self->substring_method = (g_object_unref (self->substring_method), NULL)));
	self->module_init_param_name = (g_free (self->module_init_param_name), NULL);
	(self->priv->wrappers == NULL ? NULL : (self->priv->wrappers = (g_object_unref (self->priv->wrappers), NULL)));
	G_OBJECT_CLASS (vala_ccode_generator_parent_class)->dispose (obj);
}


GType vala_ccode_generator_get_type (void) {
	static GType vala_ccode_generator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeGenerator), 0, (GInstanceInitFunc) vala_ccode_generator_init };
		vala_ccode_generator_type_id = g_type_register_static (VALA_TYPE_CODE_GENERATOR, "ValaCCodeGenerator", &g_define_type_info, 0);
	}
	return vala_ccode_generator_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




