/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodemethodbinding.h>
#include <vala/valacreationmethod.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaclassinstancetype.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>
#include <vala/valainterface.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valainterfaceinstancetype.h>
#include <vala/valavaluetype.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodestruct.h>
#include <vala/valaclasstype.h>
#include <vala/valatypeparameter.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valamethodtype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeMethodBindingPrivate {
	ValaMethod* _method;
};

#define VALA_CCODE_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingPrivate))
enum  {
	VALA_CCODE_METHOD_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_METHOD_BINDING_METHOD,
	VALA_CCODE_METHOD_BINDING_HAS_WRAPPER
};
static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base);
static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition);
static ValaTypesymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym);
static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params);
static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl);
static gpointer vala_ccode_method_binding_parent_class = NULL;
static void vala_ccode_method_binding_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCCodeGenerator* codegen, ValaMethod* method) {
	ValaCCodeMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_METHOD_BINDING, 0, NULL);
	vala_ccode_method_binding_set_method (self, method);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMethodBinding * self;
	ValaMethod* _tmp0;
	ValaMethod* m;
	ValaMethod* _tmp1;
	ValaMethod* old_method;
	ValaDataType* _tmp2;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp4;
	ValaMethod* _tmp3;
	ValaMethod* _tmp6;
	ValaMethod* _tmp5;
	ValaDataType* _tmp8;
	ValaDataType* _tmp7;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp9;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp19;
	ValaSymbol* _tmp18;
	ValaMethod* _tmp21;
	ValaMethod* _tmp20;
	ValaDataType* _tmp23;
	ValaDataType* _tmp22;
	ValaCCodeFunction* _tmp27;
	char* _tmp26;
	char* _tmp25;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CCODE_METHOD_BINDING (base);
	_tmp0 = NULL;
	m = (_tmp0 = self->priv->_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_method = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_return_type = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	old_method_inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	old_next_temp_var_id = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp4 = VALA_SYMBOL ((_tmp3 = m, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp6 = (_tmp5 = m, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp8 = (_tmp7 = vala_method_get_return_type (m), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp8);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = FALSE;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp9 = NULL;
	creturn_type = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp11;
		ValaTypesymbol* _tmp10;
		ValaClass* cl;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = TRUE;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cl = (_tmp11 = (_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (VALA_IS_CLASS (_tmp10) ? ((ValaClass*) _tmp10) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (cl != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type)) {
			in_gtypeinstance_creation_method = TRUE;
			if (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp12;
			_tmp12 = NULL;
			creturn_type = (_tmp12 = VALA_DATA_TYPE (vala_class_instance_type_new (cl)), (creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL))), _tmp12);
		}
		(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			GeeCollection* _tmp15;
			cblock = vala_ccode_block_new ();
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (stmt_it)));
					{
						ValaProperty* _tmp13;
						gboolean _tmp14;
						_tmp13 = NULL;
						if ((_tmp14 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp13 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			_tmp15 = NULL;
			vala_ccode_method_binding_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size ((_tmp15 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0);
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = VALA_CODE_NODE (((ValaCodeNode*) gee_iterator_get (stmt_it)));
					{
						ValaProperty* _tmp16;
						gboolean _tmp17;
						_tmp16 = NULL;
						if ((_tmp17 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp16 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), _tmp17)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) gee_iterator_get (cstmt_it));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = FALSE;
	}
	inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp19 = (_tmp18 = vala_symbol_get_parent_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp19);
	_tmp21 = NULL;
	_tmp20 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp21 = (_tmp20 = old_method, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp21);
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp23 = (_tmp22 = old_return_type, (_tmp22 == NULL ? NULL : g_object_ref (_tmp22))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp23);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = old_method_inner_error;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
		ValaInterface* _tmp24;
		ValaInterface* iface;
		_tmp24 = NULL;
		iface = (_tmp24 = VALA_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (_tmp27 = vala_ccode_function_new ((_tmp25 = vala_method_get_real_cname (m)), (_tmp26 = vala_data_type_get_cname (creturn_type))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), NULL))), _tmp27);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp25 = (g_free (_tmp25), NULL);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m))) {
		ValaTypesymbol* parent_type;
		ValaDataType* this_type;
		ValaCCodeFormalParameter* instance_param;
		parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
		this_type = NULL;
		if (VALA_IS_CLASS (parent_type)) {
			ValaDataType* _tmp28;
			_tmp28 = NULL;
			this_type = (_tmp28 = VALA_DATA_TYPE (vala_class_instance_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp28);
		} else {
			if (VALA_IS_INTERFACE (parent_type)) {
				ValaDataType* _tmp29;
				_tmp29 = NULL;
				this_type = (_tmp29 = VALA_DATA_TYPE (vala_interface_instance_type_new (VALA_INTERFACE (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp29);
			} else {
				ValaDataType* _tmp30;
				_tmp30 = NULL;
				this_type = (_tmp30 = VALA_DATA_TYPE (vala_value_type_new (parent_type)), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp30);
			}
		}
		instance_param = NULL;
		if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
			ValaInterfaceInstanceType* base_type;
			ValaCCodeFormalParameter* _tmp32;
			char* _tmp31;
			base_type = vala_interface_instance_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))));
			_tmp32 = NULL;
			_tmp31 = NULL;
			instance_param = (_tmp32 = vala_ccode_formal_parameter_new ("base", (_tmp31 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp32);
			_tmp31 = (g_free (_tmp31), NULL);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaClassInstanceType* base_type;
				ValaCCodeFormalParameter* _tmp34;
				char* _tmp33;
				base_type = vala_class_instance_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))));
				_tmp34 = NULL;
				_tmp33 = NULL;
				instance_param = (_tmp34 = vala_ccode_formal_parameter_new ("base", (_tmp33 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp34);
				_tmp33 = (g_free (_tmp33), NULL);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))) {
					ValaCCodeFormalParameter* _tmp36;
					char* _tmp35;
					_tmp36 = NULL;
					_tmp35 = NULL;
					instance_param = (_tmp36 = vala_ccode_formal_parameter_new ("*self", (_tmp35 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp36);
					_tmp35 = (g_free (_tmp35), NULL);
				} else {
					ValaCCodeFormalParameter* _tmp38;
					char* _tmp37;
					_tmp38 = NULL;
					_tmp37 = NULL;
					instance_param = (_tmp38 = vala_ccode_formal_parameter_new ("self", (_tmp37 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp38);
					_tmp37 = (g_free (_tmp37), NULL);
				}
			}
		}
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* _tmp39;
			ValaCCodeDeclaration* _tmp40;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp41;
			_tmp39 = NULL;
			_tmp40 = NULL;
			vdecl = (_tmp40 = vala_ccode_declaration_new ((_tmp39 = vala_data_type_get_cname (creturn_type))), (_tmp39 = (g_free (_tmp39), NULL)), _tmp40);
			_tmp41 = NULL;
			vdeclarator = (_tmp41 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), _tmp41);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, vdecl);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaTypesymbol* parent_type;
			ValaDataType* this_type;
			ValaDataType* _tmp42;
			char* _tmp43;
			ValaCCodeFormalParameter* _tmp44;
			ValaCCodeFormalParameter* class_param;
			parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
			this_type = NULL;
			_tmp42 = NULL;
			this_type = (_tmp42 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp42);
			_tmp43 = NULL;
			_tmp44 = NULL;
			class_param = (_tmp44 = vala_ccode_formal_parameter_new ("klass", (_tmp43 = vala_data_type_get_cname (this_type))), (_tmp43 = (g_free (_tmp43), NULL)), _tmp44);
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
			(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
			(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
			(class_param == NULL ? NULL : (class_param = (g_object_unref (class_param), NULL)));
		}
	}
	if (in_fundamental_creation_method) {
		ValaCCodeFormalParameter* _tmp45;
		_tmp45 = NULL;
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), (_tmp45 = vala_ccode_formal_parameter_new ("type", "GType")));
		(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
	}
	if (in_gobject_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) gee_iterator_get (type_param_it));
				{
					ValaCCodeFormalParameter* _tmp48;
					char* _tmp47;
					char* _tmp46;
					ValaCCodeFormalParameter* _tmp51;
					char* _tmp50;
					char* _tmp49;
					ValaCCodeFormalParameter* _tmp54;
					char* _tmp53;
					char* _tmp52;
					_tmp48 = NULL;
					_tmp47 = NULL;
					_tmp46 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.01, FALSE)), (_tmp48 = vala_ccode_formal_parameter_new ((_tmp47 = g_strdup_printf ("%s_type", (_tmp46 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GType")));
					(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
					_tmp47 = (g_free (_tmp47), NULL);
					_tmp46 = (g_free (_tmp46), NULL);
					_tmp51 = NULL;
					_tmp50 = NULL;
					_tmp49 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.02, FALSE)), (_tmp51 = vala_ccode_formal_parameter_new ((_tmp50 = g_strdup_printf ("%s_dup_func", (_tmp49 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
					_tmp50 = (g_free (_tmp50), NULL);
					_tmp49 = (g_free (_tmp49), NULL);
					_tmp54 = NULL;
					_tmp53 = NULL;
					_tmp52 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.03, FALSE)), (_tmp54 = vala_ccode_formal_parameter_new ((_tmp53 = g_strdup_printf ("%s_destroy_func", (_tmp52 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GDestroyNotify")));
					(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
					_tmp53 = (g_free (_tmp53), NULL);
					_tmp52 = (g_free (_tmp52), NULL);
					type_param_index++;
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
	}
	vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, GEE_MAP (cparam_map), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vdeclarator);
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp55;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp55 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp55 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
		} else {
			ValaCCodeFunction* _tmp56;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp56 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp56 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
			vala_ccode_node_set_line (VALA_CCODE_NODE (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
				ValaClass* _tmp57;
				ValaClass* cl;
				_tmp57 = NULL;
				cl = (_tmp57 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp57 == NULL ? NULL : g_object_ref (_tmp57)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaClassInstanceType* self_target_type;
					ValaCCodeIdentifier* _tmp64;
					ValaCCodeExpression* _tmp65;
					ValaCCodeExpression* cself;
					char* _tmp67;
					char* _tmp66;
					ValaCCodeDeclaration* _tmp68;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp69;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp59;
						ValaMethod* _tmp58;
						ValaReferenceType* _tmp60;
						_tmp59 = NULL;
						_tmp58 = NULL;
						base_method = (_tmp59 = (_tmp58 = vala_method_get_base_method (m), (_tmp58 == NULL ? NULL : g_object_ref (_tmp58))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp59);
						_tmp60 = NULL;
						base_expression_type = (_tmp60 = VALA_REFERENCE_TYPE (vala_class_instance_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp60);
					} else {
						ValaMethod* _tmp62;
						ValaMethod* _tmp61;
						ValaReferenceType* _tmp63;
						_tmp62 = NULL;
						_tmp61 = NULL;
						base_method = (_tmp62 = (_tmp61 = vala_method_get_base_interface_method (m), (_tmp61 == NULL ? NULL : g_object_ref (_tmp61))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp62);
						_tmp63 = NULL;
						base_expression_type = (_tmp63 = VALA_REFERENCE_TYPE (vala_interface_instance_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp63);
					}
					self_target_type = vala_class_instance_type_new (cl);
					_tmp64 = NULL;
					_tmp65 = NULL;
					cself = (_tmp65 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("base"))), VALA_DATA_TYPE (base_expression_type), VALA_DATA_TYPE (self_target_type)), (_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL))), _tmp65);
					_tmp67 = NULL;
					_tmp66 = NULL;
					_tmp68 = NULL;
					cdecl_ = (_tmp68 = vala_ccode_declaration_new ((_tmp67 = g_strdup_printf ("%s *", (_tmp66 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp67 = (g_free (_tmp67), NULL)), (_tmp66 = (g_free (_tmp66), NULL)), _tmp68);
					_tmp69 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp69 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (g_object_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, VALA_TYPESYMBOL (cl), TRUE, "self");
						vala_ccode_node_set_line (VALA_CCODE_NODE (ccheckstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (ccheckstmt));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (g_object_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_method_get_parameters (m);
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) gee_iterator_get (param_it));
					{
						ValaTypesymbol* _tmp70;
						ValaTypesymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							break;
						}
						_tmp70 = NULL;
						t = (_tmp70 = vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)), (_tmp70 == NULL ? NULL : g_object_ref (_tmp70)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) && !vala_data_type_get_nullable (vala_formal_parameter_get_type_reference (param))), vala_symbol_get_name (VALA_SYMBOL (param)));
								if (type_check != NULL) {
									vala_ccode_node_set_line (VALA_CCODE_NODE (type_check), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
								}
								(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp73;
								ValaCCodeUnaryExpression* _tmp72;
								ValaCCodeIdentifier* _tmp71;
								ValaCCodeAssignment* _tmp74;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp75;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp73 = NULL;
								_tmp72 = NULL;
								_tmp71 = NULL;
								_tmp74 = NULL;
								a = (_tmp74 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))), VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), (_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL))), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), _tmp74);
								_tmp75 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp75 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (a)))));
								(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
								(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp77;
				ValaCCodeConstant* _tmp76;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp77 = NULL;
				_tmp76 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp77 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_constant_new ("NULL")))))));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* _tmp78;
				_tmp78 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp78 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
			}
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					GeeCollection* _tmp79;
					gboolean _tmp80;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp79 = NULL;
					if ((_tmp80 = n_params > 0 || gee_collection_get_size ((_tmp79 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0, (_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL))), _tmp80)) {
						ValaCCodeIdentifier* _tmp81;
						ValaCCodeFunctionCall* _tmp82;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp83;
						ValaCCodeConstant* _tmp86;
						char* _tmp85;
						GeeCollection* _tmp84;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp87;
						ValaCCodeDeclaration* _tmp88;
						ValaCCodeVariableDeclarator* _tmp90;
						ValaCCodeIdentifier* _tmp89;
						/* declare construction parameter array*/
						_tmp81 = NULL;
						_tmp82 = NULL;
						cparamsinit = (_tmp82 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ("g_new0")))), (_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL))), _tmp82);
						_tmp83 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
						_tmp86 = NULL;
						_tmp85 = NULL;
						_tmp84 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_constant_new ((_tmp85 = g_strdup_printf ("%i", (n_params + 3 * gee_collection_get_size ((_tmp84 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))))))))));
						(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
						_tmp85 = (g_free (_tmp85), NULL);
						(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp87 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp87 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp88 = NULL;
						cdecl_ = (_tmp88 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp88);
						_tmp90 = NULL;
						_tmp89 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp90 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ("__params")))))));
						(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
						(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeCollection* type_param_collection;
						GeeIterator* type_param_it;
						type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
						type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							type_param = ((ValaTypeParameter*) gee_iterator_get (type_param_it));
							{
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp93;
								char* _tmp92;
								char* _tmp91;
								ValaCCodeIdentifier* _tmp96;
								char* _tmp95;
								char* _tmp94;
								ValaCCodeExpressionStatement* _tmp99;
								ValaCCodeExpression* _tmp98;
								ValaValueType* _tmp97;
								ValaCCodeConstant* _tmp102;
								char* _tmp101;
								char* _tmp100;
								ValaCCodeIdentifier* _tmp105;
								char* _tmp104;
								char* _tmp103;
								ValaCCodeExpressionStatement* _tmp109;
								ValaCCodeExpression* _tmp108;
								ValaPointerType* _tmp107;
								ValaVoidType* _tmp106;
								ValaCCodeConstant* _tmp112;
								char* _tmp111;
								char* _tmp110;
								ValaCCodeIdentifier* _tmp115;
								char* _tmp114;
								char* _tmp113;
								ValaCCodeExpressionStatement* _tmp119;
								ValaCCodeExpression* _tmp118;
								ValaPointerType* _tmp117;
								ValaVoidType* _tmp116;
								prop_name = NULL;
								param_name = NULL;
								_tmp93 = NULL;
								_tmp92 = NULL;
								_tmp91 = NULL;
								prop_name = (_tmp93 = vala_ccode_constant_new ((_tmp92 = g_strdup_printf ("\"%s-type\"", (_tmp91 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp93);
								_tmp92 = (g_free (_tmp92), NULL);
								_tmp91 = (g_free (_tmp91), NULL);
								_tmp96 = NULL;
								_tmp95 = NULL;
								_tmp94 = NULL;
								param_name = (_tmp96 = vala_ccode_identifier_new ((_tmp95 = g_strdup_printf ("%s_type", (_tmp94 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp96);
								_tmp95 = (g_free (_tmp95), NULL);
								_tmp94 = (g_free (_tmp94), NULL);
								_tmp99 = NULL;
								_tmp98 = NULL;
								_tmp97 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp99 = vala_ccode_expression_statement_new ((_tmp98 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp97 = vala_value_type_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtype_type))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
								(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
								(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
								_tmp102 = NULL;
								_tmp101 = NULL;
								_tmp100 = NULL;
								prop_name = (_tmp102 = vala_ccode_constant_new ((_tmp101 = g_strdup_printf ("\"%s-dup-func\"", (_tmp100 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp102);
								_tmp101 = (g_free (_tmp101), NULL);
								_tmp100 = (g_free (_tmp100), NULL);
								_tmp105 = NULL;
								_tmp104 = NULL;
								_tmp103 = NULL;
								param_name = (_tmp105 = vala_ccode_identifier_new ((_tmp104 = g_strdup_printf ("%s_dup_func", (_tmp103 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp105);
								_tmp104 = (g_free (_tmp104), NULL);
								_tmp103 = (g_free (_tmp103), NULL);
								_tmp109 = NULL;
								_tmp108 = NULL;
								_tmp107 = NULL;
								_tmp106 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp109 = vala_ccode_expression_statement_new ((_tmp108 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp107 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp106 = vala_void_type_new ()))))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
								(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
								(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
								(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
								_tmp112 = NULL;
								_tmp111 = NULL;
								_tmp110 = NULL;
								prop_name = (_tmp112 = vala_ccode_constant_new ((_tmp111 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp110 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp112);
								_tmp111 = (g_free (_tmp111), NULL);
								_tmp110 = (g_free (_tmp110), NULL);
								_tmp115 = NULL;
								_tmp114 = NULL;
								_tmp113 = NULL;
								param_name = (_tmp115 = vala_ccode_identifier_new ((_tmp114 = g_strdup_printf ("%s_destroy_func", (_tmp113 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp115);
								_tmp114 = (g_free (_tmp114), NULL);
								_tmp113 = (g_free (_tmp113), NULL);
								_tmp119 = NULL;
								_tmp118 = NULL;
								_tmp117 = NULL;
								_tmp116 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp119 = vala_ccode_expression_statement_new ((_tmp118 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp117 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp116 = vala_void_type_new ()))))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL)));
								(_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL)));
								(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
								(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL)));
								(param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
					}
				} else {
					if (in_fundamental_creation_method) {
						ValaClass* _tmp120;
						ValaClass* cl;
						char* _tmp122;
						char* _tmp121;
						ValaCCodeDeclaration* _tmp123;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp124;
						ValaCCodeFunctionCall* _tmp125;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp126;
						ValaCCodeVariableDeclarator* _tmp130;
						ValaCCodeCastExpression* _tmp129;
						char* _tmp128;
						char* _tmp127;
						_tmp120 = NULL;
						cl = (_tmp120 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp120 == NULL ? NULL : g_object_ref (_tmp120)));
						_tmp122 = NULL;
						_tmp121 = NULL;
						_tmp123 = NULL;
						cdecl_ = (_tmp123 = vala_ccode_declaration_new ((_tmp122 = g_strconcat ((_tmp121 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp122 = (g_free (_tmp122), NULL)), (_tmp121 = (g_free (_tmp121), NULL)), _tmp123);
						_tmp124 = NULL;
						_tmp125 = NULL;
						ccall = (_tmp125 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("g_type_create_instance")))), (_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL))), _tmp125);
						_tmp126 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ("type"))));
						(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
						_tmp130 = NULL;
						_tmp129 = NULL;
						_tmp128 = NULL;
						_tmp127 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp130 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp128 = g_strconcat ((_tmp127 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))))))));
						(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
						(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
						_tmp128 = (g_free (_tmp128), NULL);
						_tmp127 = (g_free (_tmp127), NULL);
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						if (in_gtypeinstance_creation_method) {
							ValaClass* _tmp131;
							ValaClass* cl;
							char* _tmp133;
							char* _tmp132;
							ValaCCodeDeclaration* _tmp134;
							ValaCCodeDeclaration* cdecl_;
							ValaClass* fundamental_class;
							ValaCCodeIdentifier* _tmp136;
							char* _tmp135;
							ValaCCodeFunctionCall* _tmp137;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp139;
							char* _tmp138;
							ValaCCodeVariableDeclarator* _tmp140;
							_tmp131 = NULL;
							cl = (_tmp131 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp131 == NULL ? NULL : g_object_ref (_tmp131)));
							_tmp133 = NULL;
							_tmp132 = NULL;
							_tmp134 = NULL;
							cdecl_ = (_tmp134 = vala_ccode_declaration_new ((_tmp133 = g_strconcat ((_tmp132 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp133 = (g_free (_tmp133), NULL)), (_tmp132 = (g_free (_tmp132), NULL)), _tmp134);
							fundamental_class = vala_ccode_method_binding_find_fundamental_class (self, cl);
							_tmp136 = NULL;
							_tmp135 = NULL;
							_tmp137 = NULL;
							ccall = (_tmp137 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp136 = vala_ccode_identifier_new ((_tmp135 = vala_method_get_cname (vala_class_get_default_construction_method (fundamental_class))))))), (_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL))), (_tmp135 = (g_free (_tmp135), NULL)), _tmp137);
							_tmp139 = NULL;
							_tmp138 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp139 = vala_ccode_identifier_new ((_tmp138 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
							(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
							_tmp138 = (g_free (_tmp138), NULL);
							_tmp140 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp140 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
							(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
							(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							(fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						} else {
							if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
								ValaClass* _tmp141;
								ValaClass* cl;
								char* _tmp143;
								char* _tmp142;
								ValaCCodeDeclaration* _tmp144;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeIdentifier* _tmp145;
								ValaCCodeFunctionCall* _tmp146;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp148;
								char* _tmp147;
								ValaCCodeVariableDeclarator* _tmp149;
								_tmp141 = NULL;
								cl = (_tmp141 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp141 == NULL ? NULL : g_object_ref (_tmp141)));
								_tmp143 = NULL;
								_tmp142 = NULL;
								_tmp144 = NULL;
								cdecl_ = (_tmp144 = vala_ccode_declaration_new ((_tmp143 = g_strconcat ((_tmp142 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp143 = (g_free (_tmp143), NULL)), (_tmp142 = (g_free (_tmp142), NULL)), _tmp144);
								_tmp145 = NULL;
								_tmp146 = NULL;
								ccall = (_tmp146 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL))), _tmp146);
								_tmp148 = NULL;
								_tmp147 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ((_tmp147 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
								(_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL)));
								_tmp147 = (g_free (_tmp147), NULL);
								_tmp149 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp149 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
								(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
								(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							} else {
								ValaStruct* _tmp150;
								ValaStruct* st;
								ValaCCodeIdentifier* _tmp151;
								ValaCCodeFunctionCall* _tmp152;
								ValaCCodeFunctionCall* czero;
								ValaCCodeIdentifier* _tmp153;
								ValaCCodeConstant* _tmp154;
								ValaCCodeIdentifier* _tmp157;
								char* _tmp156;
								char* _tmp155;
								ValaCCodeExpressionStatement* _tmp158;
								_tmp150 = NULL;
								st = (_tmp150 = VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp150 == NULL ? NULL : g_object_ref (_tmp150)));
								/* memset needs string.h*/
								vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
								_tmp151 = NULL;
								_tmp152 = NULL;
								czero = (_tmp152 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new ("memset")))), (_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL))), _tmp152);
								_tmp153 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_identifier_new ("self"))));
								(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
								_tmp154 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_constant_new ("0"))));
								(_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL)));
								_tmp157 = NULL;
								_tmp156 = NULL;
								_tmp155 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ((_tmp156 = g_strdup_printf ("sizeof (%s)", (_tmp155 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))))));
								(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
								_tmp156 = (g_free (_tmp156), NULL);
								_tmp155 = (g_free (_tmp155), NULL);
								_tmp158 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp158 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							}
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) == m && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment));
			}
			{
				GeeCollection* precondition_collection;
				GeeIterator* precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
				while (gee_iterator_next (precondition_it)) {
					ValaExpression* precondition;
					precondition = ((ValaExpression*) gee_iterator_get (precondition_it));
					{
						ValaCCodeStatement* _tmp159;
						_tmp159 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp159 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
						(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
						(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
				(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp161;
		char* _tmp160;
		ValaCCodeFunction* _tmp162;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		GeeHashMap* _tmp165;
		GeeHashMap* carg_map;
		char* _tmp166;
		ValaCCodeFormalParameter* _tmp167;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp179;
		ValaCCodeMemberAccess* _tmp180;
		ValaCCodeFunctionCall* _tmp181;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp182;
		GeeCollection* params;
		GeeCollection* _tmp203;
		gboolean _tmp204;
		gint last_pos;
		gint min_pos;
		ValaCCodeStatement* cstmt;
		GeeCollection* _tmp217;
		gboolean _tmp218;
		_tmp161 = NULL;
		_tmp160 = NULL;
		_tmp162 = NULL;
		vfunc = (_tmp162 = vala_ccode_function_new ((_tmp160 = vala_method_get_cname (m)), (_tmp161 = vala_data_type_get_cname (creturn_type))), (_tmp161 = (g_free (_tmp161), NULL)), (_tmp160 = (g_free (_tmp160), NULL)), _tmp162);
		vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaReferenceType* _tmp163;
			_tmp163 = NULL;
			this_type = (_tmp163 = VALA_REFERENCE_TYPE (vala_class_instance_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp163);
		} else {
			ValaReferenceType* _tmp164;
			_tmp164 = NULL;
			this_type = (_tmp164 = VALA_REFERENCE_TYPE (vala_interface_instance_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp164);
		}
		_tmp165 = NULL;
		cparam_map = (_tmp165 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), _tmp165);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp166 = NULL;
		_tmp167 = NULL;
		cparam = (_tmp167 = vala_ccode_formal_parameter_new ("self", (_tmp166 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type)))), (_tmp166 = (g_free (_tmp166), NULL)), _tmp167);
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeCollection* precondition_collection;
			GeeIterator* precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
			while (gee_iterator_next (precondition_it)) {
				ValaExpression* precondition;
				precondition = ((ValaExpression*) gee_iterator_get (precondition_it));
				{
					ValaCCodeStatement* _tmp168;
					_tmp168 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp168 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
					(_tmp168 == NULL ? NULL : (_tmp168 = (g_object_unref (_tmp168), NULL)));
					(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
			(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaInterface* _tmp169;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp173;
			ValaCCodeIdentifier* _tmp172;
			char* _tmp171;
			char* _tmp170;
			_tmp169 = NULL;
			iface = (_tmp169 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp169 == NULL ? NULL : g_object_ref (_tmp169)));
			_tmp173 = NULL;
			_tmp172 = NULL;
			_tmp171 = NULL;
			_tmp170 = NULL;
			vcast = (_tmp173 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_identifier_new ((_tmp171 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp170 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp173);
			(_tmp172 == NULL ? NULL : (_tmp172 = (g_object_unref (_tmp172), NULL)));
			_tmp171 = (g_free (_tmp171), NULL);
			_tmp170 = (g_free (_tmp170), NULL);
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* _tmp174;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp178;
			ValaCCodeIdentifier* _tmp177;
			char* _tmp176;
			char* _tmp175;
			_tmp174 = NULL;
			cl = (_tmp174 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp174 == NULL ? NULL : g_object_ref (_tmp174)));
			_tmp178 = NULL;
			_tmp177 = NULL;
			_tmp176 = NULL;
			_tmp175 = NULL;
			vcast = (_tmp178 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_identifier_new ((_tmp176 = g_strdup_printf ("%s_GET_CLASS", (_tmp175 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp178);
			(_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL)));
			_tmp176 = (g_free (_tmp176), NULL);
			_tmp175 = (g_free (_tmp175), NULL);
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		_tmp179 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ("self"))));
		(_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL)));
		_tmp180 = NULL;
		_tmp181 = NULL;
		vcall = (_tmp181 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp180 == NULL ? NULL : (_tmp180 = (g_object_unref (_tmp180), NULL))), _tmp181);
		_tmp182 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), (_tmp182 = vala_ccode_identifier_new ("self")));
		(_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL)));
		params = vala_method_get_parameters (m);
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = params;
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) gee_iterator_get (param_it));
				{
					ValaCCodeIdentifier* _tmp188;
					if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
						ValaArrayType* _tmp183;
						ValaArrayType* array_type;
						char* length_ctype;
						_tmp183 = NULL;
						array_type = (_tmp183 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp183 == NULL ? NULL : g_object_ref (_tmp183)));
						length_ctype = g_strdup ("int");
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							char* _tmp184;
							_tmp184 = NULL;
							length_ctype = (_tmp184 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp184);
						}
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								char* _tmp185;
								ValaCCodeFormalParameter* _tmp186;
								ValaCCodeFormalParameter* cparam;
								ValaCCodeIdentifier* _tmp187;
								_tmp185 = NULL;
								_tmp186 = NULL;
								cparam = (_tmp186 = vala_ccode_formal_parameter_new ((_tmp185 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp185 = (g_free (_tmp185), NULL)), _tmp186);
								gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
								_tmp187 = NULL;
								gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp187 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
								(_tmp187 == NULL ? NULL : (_tmp187 = (g_object_unref (_tmp187), NULL)));
								(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
							}
						}
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						length_ctype = (g_free (length_ctype), NULL);
					}
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					_tmp188 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), (_tmp188 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))));
					(_tmp188 == NULL ? NULL : (_tmp188 = (g_object_unref (_tmp188), NULL)));
					if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
						ValaDelegateType* _tmp189;
						ValaDelegateType* deleg_type;
						ValaDelegate* _tmp190;
						ValaDelegate* d;
						_tmp189 = NULL;
						deleg_type = (_tmp189 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp189 == NULL ? NULL : g_object_ref (_tmp189)));
						_tmp190 = NULL;
						d = (_tmp190 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp190 == NULL ? NULL : g_object_ref (_tmp190)));
						if (vala_delegate_get_has_target (d)) {
							char* _tmp191;
							ValaCCodeFormalParameter* _tmp192;
							ValaCCodeFormalParameter* cparam;
							ValaCCodeIdentifier* _tmp193;
							_tmp191 = NULL;
							_tmp192 = NULL;
							cparam = (_tmp192 = vala_ccode_formal_parameter_new ((_tmp191 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp191 = (g_free (_tmp191), NULL)), _tmp192);
							gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
							_tmp193 = NULL;
							gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp193 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp193 == NULL ? NULL : (_tmp193 = (g_object_unref (_tmp193), NULL)));
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
						(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
						(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		/* return array length if appropriate*/
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
			ValaArrayType* _tmp194;
			ValaArrayType* array_type;
			_tmp194 = NULL;
			array_type = (_tmp194 = VALA_ARRAY_TYPE (creturn_type), (_tmp194 == NULL ? NULL : g_object_ref (_tmp194)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp195;
					ValaCCodeFormalParameter* _tmp196;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp197;
					_tmp195 = NULL;
					_tmp196 = NULL;
					cparam = (_tmp196 = vala_ccode_formal_parameter_new ((_tmp195 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp195 = (g_free (_tmp195), NULL)), _tmp196);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), cparam);
					_tmp197 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), (_tmp197 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp197 == NULL ? NULL : (_tmp197 = (g_object_unref (_tmp197), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp198;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp199;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp198 = NULL;
				deleg_type = (_tmp198 = VALA_DELEGATE_TYPE (creturn_type), (_tmp198 == NULL ? NULL : g_object_ref (_tmp198)));
				_tmp199 = NULL;
				d = (_tmp199 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp199 == NULL ? NULL : g_object_ref (_tmp199)));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp200;
					ValaCCodeFormalParameter* _tmp201;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp202;
					_tmp200 = NULL;
					_tmp201 = NULL;
					cparam = (_tmp201 = vala_ccode_formal_parameter_new ((_tmp200 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp200 = (g_free (_tmp200), NULL)), _tmp201);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					_tmp202 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (_tmp202 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp202 == NULL ? NULL : (_tmp202 = (g_object_unref (_tmp202), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
		_tmp203 = NULL;
		if ((_tmp204 = gee_collection_get_size ((_tmp203 = vala_method_get_error_domains (m))) > 0, (_tmp203 == NULL ? NULL : (_tmp203 = (g_object_unref (_tmp203), NULL))), _tmp204)) {
			ValaCCodeFormalParameter* cparam;
			ValaCCodeIdentifier* _tmp205;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), cparam);
			_tmp205 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), (_tmp205 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
			(_tmp205 == NULL ? NULL : (_tmp205 = (g_object_unref (_tmp205), NULL)));
			(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		}
		/* append C parameters and arguments in the right order*/
		last_pos = -1;
		min_pos = 0;
		while (TRUE) {
			ValaCCodeFormalParameter* _tmp206;
			ValaCCodeExpression* _tmp207;
			min_pos = -1;
			{
				GeeSet* pos_collection;
				GeeIterator* pos_it;
				pos_collection = gee_map_get_keys (GEE_MAP (cparam_map));
				pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
				while (gee_iterator_next (pos_it)) {
					gint pos;
					pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
					{
						if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
							min_pos = pos;
						}
					}
				}
				(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
				(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			}
			if (min_pos == -1) {
				break;
			}
			_tmp206 = NULL;
			vala_ccode_function_add_parameter (vfunc, (_tmp206 = ((ValaCCodeFormalParameter*) gee_map_get (GEE_MAP (cparam_map), GINT_TO_POINTER (min_pos)))));
			(_tmp206 == NULL ? NULL : (_tmp206 = (g_object_unref (_tmp206), NULL)));
			_tmp207 = NULL;
			vala_ccode_function_call_add_argument (vcall, (_tmp207 = ((ValaCCodeExpression*) gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos)))));
			(_tmp207 == NULL ? NULL : (_tmp207 = (g_object_unref (_tmp207), NULL)));
			last_pos = min_pos;
		}
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp208;
			_tmp208 = NULL;
			cstmt = (_tmp208 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp208);
		} else {
			GeeCollection* _tmp209;
			gboolean _tmp210;
			_tmp209 = NULL;
			if ((_tmp210 = gee_collection_get_size ((_tmp209 = vala_method_get_postconditions (m))) == 0, (_tmp209 == NULL ? NULL : (_tmp209 = (g_object_unref (_tmp209), NULL))), _tmp210)) {
				ValaCCodeStatement* _tmp211;
				/* pass method return value */
				_tmp211 = NULL;
				cstmt = (_tmp211 = VALA_CCODE_STATEMENT (vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp211);
			} else {
				char* _tmp212;
				ValaCCodeDeclaration* _tmp213;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp214;
				ValaCCodeStatement* _tmp216;
				ValaCCodeDeclaration* _tmp215;
				/* store method return value for postconditions */
				_tmp212 = NULL;
				_tmp213 = NULL;
				cdecl_ = (_tmp213 = vala_ccode_declaration_new ((_tmp212 = vala_data_type_get_cname (creturn_type))), (_tmp212 = (g_free (_tmp212), NULL)), _tmp213);
				_tmp214 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp214 = vala_ccode_variable_declarator_new_with_initializer ("result", VALA_CCODE_EXPRESSION (vcall)))));
				(_tmp214 == NULL ? NULL : (_tmp214 = (g_object_unref (_tmp214), NULL)));
				_tmp216 = NULL;
				_tmp215 = NULL;
				cstmt = (_tmp216 = VALA_CCODE_STATEMENT ((_tmp215 = cdecl_, (_tmp215 == NULL ? NULL : g_object_ref (_tmp215)))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp216);
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
		vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
		_tmp217 = NULL;
		if ((_tmp218 = gee_collection_get_size ((_tmp217 = vala_method_get_postconditions (m))) > 0, (_tmp217 == NULL ? NULL : (_tmp217 = (g_object_unref (_tmp217), NULL))), _tmp218)) {
			{
				GeeCollection* postcondition_collection;
				GeeIterator* postcondition_it;
				postcondition_collection = vala_method_get_postconditions (m);
				postcondition_it = gee_iterable_iterator (GEE_ITERABLE (postcondition_collection));
				while (gee_iterator_next (postcondition_it)) {
					ValaExpression* postcondition;
					postcondition = ((ValaExpression*) gee_iterator_get (postcondition_it));
					{
						ValaCCodeStatement* _tmp219;
						_tmp219 = NULL;
						vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp219 = vala_ccode_method_binding_create_postcondition_statement (self, postcondition))));
						(_tmp219 == NULL ? NULL : (_tmp219 = (g_object_unref (_tmp219), NULL)));
						(postcondition == NULL ? NULL : (postcondition = (g_object_unref (postcondition), NULL)));
					}
				}
				(postcondition_collection == NULL ? NULL : (postcondition_collection = (g_object_unref (postcondition_collection), NULL)));
				(postcondition_it == NULL ? NULL : (postcondition_it = (g_object_unref (postcondition_it), NULL)));
			}
			if (!(VALA_IS_VOID_TYPE (creturn_type))) {
				ValaCCodeIdentifier* _tmp220;
				ValaCCodeReturnStatement* _tmp221;
				ValaCCodeReturnStatement* cret_stmt;
				_tmp220 = NULL;
				_tmp221 = NULL;
				cret_stmt = (_tmp221 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp220 = vala_ccode_identifier_new ("result")))), (_tmp220 == NULL ? NULL : (_tmp220 = (g_object_unref (_tmp220), NULL))), _tmp221);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
				vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cret_stmt));
				(cret_stmt == NULL ? NULL : (cret_stmt = (g_object_unref (cret_stmt), NULL)));
			}
		}
		if (visible) {
			ValaCCodeFunction* _tmp222;
			_tmp222 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp222 = vala_ccode_function_copy (vfunc))));
			(_tmp222 == NULL ? NULL : (_tmp222 = (g_object_unref (_tmp222), NULL)));
		} else {
			ValaCCodeFunction* _tmp223;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp223 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp223 = vala_ccode_function_copy (vfunc))));
			(_tmp223 == NULL ? NULL : (_tmp223 = (g_object_unref (_tmp223), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
			ValaCCodeComment* _tmp224;
			_tmp224 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp224 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
			(_tmp224 == NULL ? NULL : (_tmp224 = (g_object_unref (_tmp224), NULL)));
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeCollection* _tmp225;
		gboolean _tmp226;
		_tmp225 = NULL;
		if ((_tmp226 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size ((_tmp225 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class))) > 0), (_tmp225 == NULL ? NULL : (_tmp225 = (g_object_unref (_tmp225), NULL))), _tmp226)) {
			ValaCCodeIdentifier* _tmp228;
			ValaCCodeIdentifier* _tmp227;
			ValaCCodeBinaryExpression* _tmp229;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp232;
			ValaCCodeUnaryExpression* _tmp231;
			ValaCCodeIdentifier* _tmp230;
			ValaCCodeIdentifier* _tmp233;
			ValaCCodeFunctionCall* _tmp234;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp237;
			ValaCCodeMemberAccess* _tmp236;
			ValaCCodeIdentifier* _tmp235;
			ValaCCodeExpressionStatement* _tmp238;
			ValaCCodeWhileStatement* _tmp239;
			ValaCCodeIdentifier* _tmp240;
			ValaCCodeFunctionCall* _tmp241;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp242;
			ValaCCodeExpressionStatement* _tmp243;
			_tmp228 = NULL;
			_tmp227 = NULL;
			_tmp229 = NULL;
			ccond = (_tmp229 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp227 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp228 = vala_ccode_identifier_new ("__params")))), (_tmp228 == NULL ? NULL : (_tmp228 = (g_object_unref (_tmp228), NULL))), (_tmp227 == NULL ? NULL : (_tmp227 = (g_object_unref (_tmp227), NULL))), _tmp229);
			cdofreeparam = vala_ccode_block_new ();
			_tmp232 = NULL;
			_tmp231 = NULL;
			_tmp230 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp232 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp231 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp230 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp232 == NULL ? NULL : (_tmp232 = (g_object_unref (_tmp232), NULL)));
			(_tmp231 == NULL ? NULL : (_tmp231 = (g_object_unref (_tmp231), NULL)));
			(_tmp230 == NULL ? NULL : (_tmp230 = (g_object_unref (_tmp230), NULL)));
			_tmp233 = NULL;
			_tmp234 = NULL;
			cunsetcall = (_tmp234 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp233 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp233 == NULL ? NULL : (_tmp233 = (g_object_unref (_tmp233), NULL))), _tmp234);
			_tmp237 = NULL;
			_tmp236 = NULL;
			_tmp235 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp237 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp236 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp235 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp237 == NULL ? NULL : (_tmp237 = (g_object_unref (_tmp237), NULL)));
			(_tmp236 == NULL ? NULL : (_tmp236 = (g_object_unref (_tmp236), NULL)));
			(_tmp235 == NULL ? NULL : (_tmp235 = (g_object_unref (_tmp235), NULL)));
			_tmp238 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp238 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp238 == NULL ? NULL : (_tmp238 = (g_object_unref (_tmp238), NULL)));
			_tmp239 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp239 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp239 == NULL ? NULL : (_tmp239 = (g_object_unref (_tmp239), NULL)));
			_tmp240 = NULL;
			_tmp241 = NULL;
			cfreeparams = (_tmp241 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp240 = vala_ccode_identifier_new ("g_free")))), (_tmp240 == NULL ? NULL : (_tmp240 = (g_object_unref (_tmp240), NULL))), _tmp241);
			_tmp242 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp242 = vala_ccode_identifier_new ("__params"))));
			(_tmp242 == NULL ? NULL : (_tmp242 = (g_object_unref (_tmp242), NULL)));
			_tmp243 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp243 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp243 == NULL ? NULL : (_tmp243 = (g_object_unref (_tmp243), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
			ValaCCodeReturnStatement* creturn;
			ValaCCodeIdentifier* _tmp244;
			creturn = vala_ccode_return_statement_new (NULL);
			_tmp244 = NULL;
			vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((_tmp244 = vala_ccode_identifier_new ("self"))));
			(_tmp244 == NULL ? NULL : (_tmp244 = (g_object_unref (_tmp244), NULL)));
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (creturn));
			(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_method_binding_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp245;
		ValaCCodeFormalParameter* _tmp246;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp252;
		ValaCCodeIdentifier* _tmp251;
		ValaCCodeExpressionStatement* _tmp253;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp254;
		ValaCCodeFunctionCall* _tmp255;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (VALA_CCODE_NODE (cmain), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		_tmp245 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp245 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp245 == NULL ? NULL : (_tmp245 = (g_object_unref (_tmp245), NULL)));
		_tmp246 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp246 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp246 == NULL ? NULL : (_tmp246 = (g_object_unref (_tmp246), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context)) {
			ValaCCodeIdentifier* _tmp247;
			ValaCCodeFunctionCall* _tmp248;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp249;
			ValaCCodeExpressionStatement* _tmp250;
			_tmp247 = NULL;
			_tmp248 = NULL;
			thread_init_call = (_tmp248 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp247 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp247 == NULL ? NULL : (_tmp247 = (g_object_unref (_tmp247), NULL))), _tmp248);
			vala_ccode_node_set_line (VALA_CCODE_NODE (thread_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			_tmp249 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp249 = vala_ccode_constant_new ("NULL"))));
			(_tmp249 == NULL ? NULL : (_tmp249 = (g_object_unref (_tmp249), NULL)));
			_tmp250 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp250 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp250 == NULL ? NULL : (_tmp250 = (g_object_unref (_tmp250), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		_tmp252 = NULL;
		_tmp251 = NULL;
		_tmp253 = NULL;
		type_init_call = (_tmp253 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp252 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp251 = vala_ccode_identifier_new ("g_type_init"))))))), (_tmp252 == NULL ? NULL : (_tmp252 = (g_object_unref (_tmp252), NULL))), (_tmp251 == NULL ? NULL : (_tmp251 = (g_object_unref (_tmp251), NULL))), _tmp253);
		vala_ccode_node_set_line (VALA_CCODE_NODE (type_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (type_init_call));
		_tmp254 = NULL;
		_tmp255 = NULL;
		main_call = (_tmp255 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp254 = vala_ccode_identifier_new (vala_ccode_function_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))))), (_tmp254 == NULL ? NULL : (_tmp254 = (g_object_unref (_tmp254), NULL))), _tmp255);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp256;
			ValaCCodeIdentifier* _tmp257;
			_tmp256 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp256 = vala_ccode_identifier_new ("argv"))));
			(_tmp256 == NULL ? NULL : (_tmp256 = (g_object_unref (_tmp256), NULL)));
			_tmp257 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp257 = vala_ccode_identifier_new ("argc"))));
			(_tmp257 == NULL ? NULL : (_tmp257 = (g_object_unref (_tmp257), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp258;
			ValaCCodeReturnStatement* _tmp259;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			_tmp258 = NULL;
			_tmp259 = NULL;
			ret_stmt = (_tmp259 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp258 = vala_ccode_constant_new ("0")))), (_tmp258 == NULL ? NULL : (_tmp258 = (g_object_unref (_tmp258), NULL))), _tmp259);
			vala_ccode_node_set_line (VALA_CCODE_NODE (ret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (ret_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (g_object_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (g_object_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
}


void vala_ccode_method_binding_generate_cparameters (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* creturn_type, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator) {
	GeeCollection* _tmp17;
	gboolean _tmp18;
	gint last_pos;
	gint min_pos;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_METHOD (m));
	g_return_if_fail (VALA_IS_DATA_TYPE (creturn_type));
	g_return_if_fail (GEE_IS_MAP (cparam_map));
	g_return_if_fail (VALA_IS_CCODE_FUNCTION (func));
	g_return_if_fail (vdeclarator == NULL || VALA_IS_CCODE_FUNCTION_DECLARATOR (vdeclarator));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaArrayType* _tmp0;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp0 = NULL;
					array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp1;
						_tmp1 = NULL;
						length_ctype = (_tmp1 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp1);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp2;
							ValaCCodeFormalParameter* _tmp3;
							ValaCCodeFormalParameter* cparam;
							_tmp2 = NULL;
							_tmp3 = NULL;
							cparam = (_tmp3 = vala_ccode_formal_parameter_new ((_tmp2 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaDelegateType* _tmp4;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp5;
					ValaDelegate* d;
					_tmp4 = NULL;
					deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
					_tmp5 = NULL;
					d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
					if (vala_delegate_get_has_target (d)) {
						char* _tmp6;
						ValaCCodeFormalParameter* _tmp7;
						ValaCCodeFormalParameter* cparam;
						_tmp6 = NULL;
						_tmp7 = NULL;
						cparam = (_tmp7 = vala_ccode_formal_parameter_new ((_tmp6 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
				} else {
					if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_type_reference (param))) {
						char* _tmp8;
						ValaCCodeFormalParameter* _tmp9;
						ValaCCodeFormalParameter* cparam;
						_tmp8 = NULL;
						_tmp9 = NULL;
						cparam = (_tmp9 = vala_ccode_formal_parameter_new ((_tmp8 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
		ValaArrayType* _tmp10;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp10 = NULL;
		array_type = (_tmp10 = VALA_ARRAY_TYPE (creturn_type), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp11;
				ValaCCodeFormalParameter* _tmp12;
				ValaCCodeFormalParameter* cparam;
				_tmp11 = NULL;
				_tmp12 = NULL;
				cparam = (_tmp12 = vala_ccode_formal_parameter_new ((_tmp11 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
			ValaDelegateType* _tmp13;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp14;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp13 = NULL;
			deleg_type = (_tmp13 = VALA_DELEGATE_TYPE (creturn_type), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			_tmp14 = NULL;
			d = (_tmp14 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp15;
				ValaCCodeFormalParameter* _tmp16;
				ValaCCodeFormalParameter* cparam;
				_tmp15 = NULL;
				_tmp16 = NULL;
				cparam = (_tmp16 = vala_ccode_formal_parameter_new ((_tmp15 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp15 = (g_free (_tmp15), NULL)), _tmp16);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	_tmp17 = NULL;
	if ((_tmp18 = gee_collection_get_size ((_tmp17 = vala_method_get_error_domains (m))) > 0, (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp19;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (cparam_map);
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp19 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp19 = ((ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp20;
			_tmp20 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, (_tmp20 = ((ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		}
		last_pos = min_pos;
	}
}


static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_generator_create_type_check_statement (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CODE_NODE (m), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (precondition), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (precondition))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeExpressionStatement* _tmp3;
			ValaCCodeExpressionStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp4 = (_tmp3 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("0")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp4));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp5 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp5));
}


static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeExpressionStatement* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (postcondition), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_assert")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (postcondition))));
	_tmp2 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp2 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)), (cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL))), _tmp2));
}


static ValaTypesymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypesymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeCollection* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp7;
	ValaArrayType* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (VALA_SYMBOL (m)) == NULL || _vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (m)), "main") != 0) {
		/* method must be called "main"*/
		return FALSE;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* method must be static*/
		return FALSE;
	}
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type)) {
			(*return_value) = TRUE;
		} else {
			/* return type must be void or int*/
			return FALSE;
		}
	}
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (params) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (params) > 1) {
		gboolean _tmp4;
		/* method must not have more than one parameter*/
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	}
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = ((ValaFormalParameter*) gee_iterator_get (params_it));
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		gboolean _tmp5;
		/* parameter must not be an out parameter*/
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp5);
	}
	if (!(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)))) {
		gboolean _tmp6;
		/* parameter must be an array*/
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp6);
	}
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
		gboolean _tmp8;
		/* parameter must be an array of strings*/
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp8);
	}
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if (has_params) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeConstant* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("__params_it - __params"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("__params"))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	} else {
		ValaCCodeConstant* _tmp7;
		ValaCCodeConstant* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdeclaration = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl) {
	ValaClass* _tmp0;
	ValaClass* fundamental_class;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	_tmp0 = NULL;
	fundamental_class = (_tmp0 = cl, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	while (fundamental_class != NULL && VALA_TYPESYMBOL (vala_class_get_base_class (fundamental_class)) != vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type) {
		ValaClass* _tmp2;
		ValaClass* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		fundamental_class = (_tmp2 = (_tmp1 = vala_class_get_base_class (fundamental_class), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL))), _tmp2);
	}
	return fundamental_class;
}


ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	return self->priv->_method;
}


void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL))), _tmp2);
}


gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self) {
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static void vala_ccode_method_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		g_value_set_object (value, vala_ccode_method_binding_get_method (self));
		break;
		case VALA_CCODE_METHOD_BINDING_HAS_WRAPPER:
		g_value_set_boolean (value, vala_ccode_method_binding_get_has_wrapper (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		vala_ccode_method_binding_set_method (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_class_init (ValaCCodeMethodBindingClass * klass) {
	vala_ccode_method_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMethodBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_method_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_method_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_method_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_method_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_METHOD, g_param_spec_object ("method", "method", "method", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_HAS_WRAPPER, g_param_spec_boolean ("has-wrapper", "has-wrapper", "has-wrapper", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_ccode_method_binding_init (ValaCCodeMethodBinding * self) {
	self->priv = VALA_CCODE_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_method_binding_dispose (GObject * obj) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (obj);
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL)));
	G_OBJECT_CLASS (vala_ccode_method_binding_parent_class)->dispose (obj);
}


GType vala_ccode_method_binding_get_type (void) {
	static GType vala_ccode_method_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_method_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodBinding), 0, (GInstanceInitFunc) vala_ccode_method_binding_init };
		vala_ccode_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_method_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




