/* valadeclarationstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadeclarationstatement.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaDeclarationStatementPrivate {
	ValaSymbol* _declaration;
};

#define VALA_DECLARATION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementPrivate))
enum  {
	VALA_DECLARATION_STATEMENT_DUMMY_PROPERTY,
	VALA_DECLARATION_STATEMENT_DECLARATION
};
static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_declaration_statement_parent_class = NULL;
static ValaStatementIface* vala_declaration_statement_vala_statement_parent_iface = NULL;
static void vala_declaration_statement_dispose (GObject * obj);



/**
 * Creates a new declaration statement.
 *
 * @param decl   local variable declaration
 * @param source reference to source code
 * @return       newly created declaration statement
 */
ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaDeclarationStatement * self;
	g_return_val_if_fail (VALA_IS_SYMBOL (declaration), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "declaration";
	g_value_init (&__params_it->value, VALA_TYPE_SYMBOL);
	g_value_set_object (&__params_it->value, declaration);
	__params_it++;
	self = g_object_newv (VALA_TYPE_DECLARATION_STATEMENT, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_declaration), visitor);
	vala_code_visitor_visit_declaration_statement (visitor, self);
}


ValaSymbol* vala_declaration_statement_get_declaration (ValaDeclarationStatement* self) {
	g_return_val_if_fail (VALA_IS_DECLARATION_STATEMENT (self), NULL);
	return self->priv->_declaration;
}


void vala_declaration_statement_set_declaration (ValaDeclarationStatement* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_declaration = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_declaration == NULL ? NULL : (self->priv->_declaration = (g_object_unref (self->priv->_declaration), NULL))), _tmp2);
}


static void vala_declaration_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (object);
	switch (property_id) {
		case VALA_DECLARATION_STATEMENT_DECLARATION:
		g_value_set_object (value, vala_declaration_statement_get_declaration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_declaration_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (object);
	switch (property_id) {
		case VALA_DECLARATION_STATEMENT_DECLARATION:
		vala_declaration_statement_set_declaration (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_declaration_statement_class_init (ValaDeclarationStatementClass * klass) {
	vala_declaration_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDeclarationStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_declaration_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_declaration_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_declaration_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_declaration_statement_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DECLARATION_STATEMENT_DECLARATION, g_param_spec_object ("declaration", "declaration", "declaration", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_declaration_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_declaration_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_declaration_statement_init (ValaDeclarationStatement * self) {
	self->priv = VALA_DECLARATION_STATEMENT_GET_PRIVATE (self);
}


static void vala_declaration_statement_dispose (GObject * obj) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (obj);
	(self->priv->_declaration == NULL ? NULL : (self->priv->_declaration = (g_object_unref (self->priv->_declaration), NULL)));
	G_OBJECT_CLASS (vala_declaration_statement_parent_class)->dispose (obj);
}


GType vala_declaration_statement_get_type (void) {
	static GType vala_declaration_statement_type_id = 0;
	if (G_UNLIKELY (vala_declaration_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDeclarationStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_declaration_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDeclarationStatement), 0, (GInstanceInitFunc) vala_declaration_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_declaration_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_declaration_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDeclarationStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_declaration_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_declaration_statement_type_id;
}




