/* valaccodeassignmentbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeassignmentbinding.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaexpressionstatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadynamicsignal.h>
#include <vala/valamember.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaelementaccess.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valascope.h>
#include <vala/valaformalparameter.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valacodevisitor.h>
#include <vala/valapointertype.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodedynamicsignalbinding.h>




struct _ValaCCodeAssignmentBindingPrivate {
	ValaAssignment* _assignment;
};

#define VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ASSIGNMENT_BINDING, ValaCCodeAssignmentBindingPrivate))
enum  {
	VALA_CCODE_ASSIGNMENT_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT
};
static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self);
static void vala_ccode_assignment_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_assignment_binding_parent_class = NULL;
static void vala_ccode_assignment_binding_dispose (GObject * obj);



ValaCCodeAssignmentBinding* vala_ccode_assignment_binding_new (ValaCCodeGenerator* codegen, ValaAssignment* assignment) {
	ValaCCodeAssignmentBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (assignment), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ASSIGNMENT_BINDING, 0, NULL);
	vala_ccode_assignment_binding_set_assignment (self, assignment);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_assignment_binding_emit_property_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (self->priv->_assignment), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method) {
		ValaCCodeExpression* _tmp4;
		ValaCCodeConstant* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), (_tmp4 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), (_tmp3 = vala_property_get_canonical_cconstant (prop)), vala_property_get_property_type (prop), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	} else {
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		_tmp5 = NULL;
		cexpr = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
		if (!vala_property_get_no_accessor_method (prop)) {
			if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
				ValaCCodeExpression* _tmp6;
				_tmp6 = NULL;
				cexpr = (_tmp6 = vala_ccode_generator_get_address_of_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment), cexpr), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp6);
			}
		}
		if (vala_assignment_get_operator (self->priv->_assignment) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			ValaCCodeBinaryOperator cop;
			ValaCCodeExpression* _tmp8;
			ValaCCodeParenthesizedExpression* _tmp7;
			cop = 0;
			if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
						} else {
							if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
							} else {
								if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_BINARY_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_BINARY_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_BINARY_OPERATOR_MOD;
										} else {
											if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp8 = NULL;
			_tmp7 = NULL;
			cexpr = (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_parenthesized_expression_new (cexpr))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp8);
			(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		}
		ccall = vala_ccode_generator_get_property_set_call (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), prop, ma, cexpr);
		/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
		if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_assignment))))) {
			ValaCCodeCommaExpression* ccomma;
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		} else {
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
		}
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
}


static void vala_ccode_assignment_binding_emit_signal_assignment (ValaCCodeAssignmentBinding* self) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaSignal* _tmp2;
	ValaSignal* sig;
	ValaMethod* _tmp3;
	ValaMethod* m;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCastExpression* _tmp31;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (self->priv->_assignment), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	sig = (_tmp2 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	m = (_tmp3 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (self->priv->_assignment))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp5;
			ValaCCodeDynamicSignalBinding* _tmp4;
			_tmp5 = NULL;
			_tmp4 = NULL;
			connect_func = (_tmp5 = vala_ccode_dynamic_signal_binding_get_connect_wrapper_name ((_tmp4 = vala_ccode_generator_dynamic_signal_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_SIGNAL (sig)))), (connect_func = (g_free (connect_func), NULL)), _tmp5);
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		} else {
			char* _tmp6;
			_tmp6 = NULL;
			connect_func = (_tmp6 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), _tmp6);
			if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
				char* _tmp7;
				_tmp7 = NULL;
				connect_func = (_tmp7 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp7);
			}
		}
	} else {
		if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
				char* _tmp9;
				ValaCCodeDynamicSignalBinding* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				connect_func = (_tmp9 = vala_ccode_dynamic_signal_binding_get_disconnect_wrapper_name ((_tmp8 = vala_ccode_generator_dynamic_signal_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_SIGNAL (sig)))), (connect_func = (g_free (connect_func), NULL)), _tmp9);
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			} else {
				char* _tmp10;
				_tmp10 = NULL;
				connect_func = (_tmp10 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), _tmp10);
			}
			disconnect = TRUE;
		} else {
			vala_code_node_set_error (VALA_CODE_NODE (self->priv->_assignment), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_assignment)), "Specified compound assignment type for signals not supported.");
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			connect_func = (g_free (connect_func), NULL);
			return;
		}
	}
	_tmp11 = NULL;
	_tmp12 = NULL;
	ccall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new (connect_func)))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
	/* first argument: instance of sender*/
	if (vala_member_access_get_inner (ma) != NULL) {
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
	} else {
		ValaCCodeIdentifier* _tmp13;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp15;
		char* _tmp14;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp15 = NULL;
		_tmp14 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (sig))))))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		_tmp14 = (g_free (_tmp14), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp16;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_signal_get_canonical_cconstant (sig))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		} else {
			ValaCCodeConstant* _tmp17;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp18;
			ValaCCodeFunctionCall* _tmp19;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp20;
			ValaTypeSymbol* _tmp21;
			ValaTypeSymbol* decl_type;
			ValaCCodeIdentifier* _tmp23;
			char* _tmp22;
			ValaCCodeUnaryExpression* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeConstant* _tmp26;
			ValaCCodeConstant* _tmp27;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeConstant* _tmp29;
			ValaCCodeConstant* _tmp30;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->uint_type, TRUE, NULL);
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			_tmp18 = NULL;
			_tmp19 = NULL;
			parse_call = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("g_signal_parse_name")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19);
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp20 = vala_signal_get_canonical_cconstant (sig))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			_tmp21 = NULL;
			decl_type = (_tmp21 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21)));
			_tmp23 = NULL;
			_tmp22 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ((_tmp22 = vala_typesymbol_get_type_id (decl_type))))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			_tmp22 = (g_free (_tmp22), NULL);
			_tmp25 = NULL;
			_tmp24 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))))));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			_tmp26 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ("NULL"))));
			(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			_tmp27 = NULL;
			vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("FALSE"))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
			_tmp28 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
			/* fourth argument: detail*/
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("0"))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
			/* fifth argument: closure*/
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("NULL"))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
			(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
		}
	}
	/* third resp. sixth argument: handler*/
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), "GCallback"))));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (self->priv->_assignment))) {
			ValaMemberAccess* _tmp32;
			ValaMemberAccess* right_ma;
			_tmp32 = NULL;
			right_ma = (_tmp32 = VALA_MEMBER_ACCESS (vala_assignment_get_right (self->priv->_assignment)), (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
			} else {
				ValaCCodeIdentifier* _tmp33;
				_tmp33 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("self"))));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			}
			(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (self->priv->_assignment))) {
				ValaCCodeIdentifier* _tmp34;
				_tmp34 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("self"))));
				(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
			}
		}
		if (!disconnect && !(VALA_IS_DYNAMIC_SIGNAL (sig))) {
			ValaCCodeConstant* _tmp35;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp35 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("0"))));
			(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		}
	} else {
		ValaCCodeConstant* _tmp36;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp36 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("NULL"))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	}
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	connect_func = (g_free (connect_func), NULL);
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_ccode_assignment_binding_emit_non_array_element_access (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaElementAccess* _tmp1;
	ValaElementAccess* expr;
	ValaTypeSymbol* _tmp2;
	ValaTypeSymbol* container_type;
	GeeList* indices;
	GeeIterator* indices_it;
	ValaCCodeExpression* _tmp3;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp5;
	ValaExpression* _tmp4;
	ValaCCodeExpression* _tmp6;
	ValaCCodeExpression* cindex;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	/* custom element access*/
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	container_type = (_tmp2 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	indices = vala_element_access_get_indices (expr);
	indices_it = gee_iterable_iterator (GEE_ITERABLE (indices));
	gee_iterator_next (indices_it);
	_tmp3 = NULL;
	ccontainer = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	cindex = (_tmp6 = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp4 = ((ValaExpression*) (gee_iterator_get (indices_it))))))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp6);
	if (container_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type)) || vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type)))) {
		ValaTypeSymbol* collection_iface;
		ValaMethod* set_method;
		GeeList* set_params;
		GeeIterator* set_params_it;
		ValaFormalParameter* set_param;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp12;
		ValaCCodeFunctionCall* _tmp14;
		ValaCCodeFunctionCall* set_ccall;
		ValaCCodeCastExpression* _tmp17;
		char* _tmp16;
		char* _tmp15;
		ValaCCodeExpression* _tmp18;
		/* lookup symbol in interface instead of class as implemented interface methods are not in VAPI files*/
		collection_iface = NULL;
		if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type))) {
			ValaTypeSymbol* _tmp8;
			ValaTypeSymbol* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			collection_iface = (_tmp8 = (_tmp7 = VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp8);
		} else {
			if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type))) {
				ValaTypeSymbol* _tmp10;
				ValaTypeSymbol* _tmp9;
				_tmp10 = NULL;
				_tmp9 = NULL;
				collection_iface = (_tmp10 = (_tmp9 = VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp10);
			}
		}
		set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (collection_iface)), "set"));
		set_params = vala_method_get_parameters (set_method);
		set_params_it = gee_iterable_iterator (GEE_ITERABLE (set_params));
		gee_iterator_next (set_params_it);
		set_param = ((ValaFormalParameter*) (gee_iterator_get (set_params_it)));
		if (vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (set_param)) != NULL) {
			ValaDataType* index_type;
			ValaCCodeExpression* _tmp11;
			index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), VALA_SYMBOL (set_method), vala_formal_parameter_get_parameter_type (set_param), VALA_CODE_NODE (self->priv->_assignment));
			_tmp11 = NULL;
			cindex = (_tmp11 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp11);
			(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
		}
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp14 = NULL;
		set_ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_method_get_cname (set_method)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp14);
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_cast_expression_new (ccontainer, (_tmp16 = g_strconcat ((_tmp15 = vala_typesymbol_get_cname (collection_iface, FALSE)), "*", NULL))))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		_tmp16 = (g_free (_tmp16), NULL);
		_tmp15 = (g_free (_tmp15), NULL);
		vala_ccode_function_call_add_argument (set_ccall, cindex);
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, (_tmp18 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), rhs, vala_expression_get_value_type (VALA_EXPRESSION (expr)))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (set_ccall));
		(collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL)));
		(set_method == NULL ? NULL : (set_method = (g_object_unref (set_method), NULL)));
		(set_params == NULL ? NULL : (set_params = (g_object_unref (set_params), NULL)));
		(set_params_it == NULL ? NULL : (set_params_it = (g_object_unref (set_params_it), NULL)));
		(set_param == NULL ? NULL : (set_param = (g_object_unref (set_param), NULL)));
		(set_ccall == NULL ? NULL : (set_ccall = (g_object_unref (set_ccall), NULL)));
	} else {
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_assignment)), "internal error: unsupported element access");
		vala_code_node_set_error (VALA_CODE_NODE (self->priv->_assignment), TRUE);
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(indices_it == NULL ? NULL : (indices_it = (g_object_unref (indices_it), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_ccode_assignment_binding_emit_simple_assignment (ValaCCodeAssignmentBinding* self) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	gboolean unref_old;
	gboolean array;
	gboolean instance_delegate;
	ValaCCodeAssignmentOperator cop;
	ValaCCodeAssignment* _tmp13;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (self->priv->_assignment)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	unref_old = vala_ccode_generator_requires_destroy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment)));
	array = FALSE;
	instance_delegate = FALSE;
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment)))) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		array = !(VALA_IS_CCODE_CONSTANT ((_tmp1 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment), 1))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment)))) {
			ValaDelegateType* _tmp2;
			ValaDelegateType* delegate_type;
			_tmp2 = NULL;
			delegate_type = (_tmp2 = VALA_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
			instance_delegate = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type));
			(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
		}
	}
	if (unref_old || array || instance_delegate) {
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeExpression* _tmp12;
		ValaCCodeExpression* _tmp11;
		ccomma = vala_ccode_comma_expression_new ();
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment)), TRUE, NULL);
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		if (unref_old) {
			ValaCCodeExpression* _tmp5;
			/* unref old value */
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (_tmp5 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment)), vala_assignment_get_left (self->priv->_assignment))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		}
		if (array) {
			ValaArrayType* _tmp6;
			ValaArrayType* array_type;
			_tmp6 = NULL;
			array_type = (_tmp6 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp7;
					lhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment), dim);
					rhs_array_len = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment), dim);
					_tmp7 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (g_object_unref (rhs_array_len), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (instance_delegate) {
				ValaDelegateType* _tmp8;
				ValaDelegateType* delegate_type;
				ValaCCodeExpression* lhs_delegate_target;
				ValaCCodeExpression* rhs_delegate_target;
				ValaCCodeAssignment* _tmp9;
				_tmp8 = NULL;
				delegate_type = (_tmp8 = VALA_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (self->priv->_assignment))), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
				lhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_left (self->priv->_assignment));
				rhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_assignment_get_right (self->priv->_assignment));
				_tmp9 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(delegate_type == NULL ? NULL : (delegate_type = (g_object_unref (delegate_type), NULL)));
				(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (g_object_unref (lhs_delegate_target), NULL)));
				(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (g_object_unref (rhs_delegate_target), NULL)));
			}
		}
		_tmp10 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		rhs = (_tmp12 = (_tmp11 = VALA_CCODE_EXPRESSION (ccomma), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp12);
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	}
	cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
	if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} else {
		if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
		} else {
			if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			} else {
				if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
				} else {
					if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
					} else {
						if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
						} else {
							if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
							} else {
								if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
								} else {
									if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
									} else {
										if (vala_assignment_get_operator (self->priv->_assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp13 = NULL;
	vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), rhs, cop))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	if (unref_old && VALA_IS_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment))))) {
		ValaCCodeElementAccess* _tmp14;
		ValaCCodeElementAccess* cea;
		/* ensure that index expression in element access doesn't get evaluated more than once
		 except when it's a simple expression*/
		_tmp14 = NULL;
		cea = (_tmp14 = VALA_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (self->priv->_assignment)))), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
		if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
			ValaLocalVariable* index_temp_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp16;
			ValaCCodeIdentifier* _tmp15;
			ValaCCodeIdentifier* _tmp17;
			index_temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, index_temp_decl);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp16 = NULL;
			_tmp15 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self)));
			_tmp17 = NULL;
			vala_ccode_element_access_set_index (cea, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (index_temp_decl))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccomma));
			(index_temp_decl == NULL ? NULL : (index_temp_decl = (g_object_unref (index_temp_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
	}
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_ccode_assignment_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (base);
	vala_code_node_accept_children (VALA_CODE_NODE (self->priv->_assignment), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment)))) {
		vala_ccode_assignment_binding_emit_property_assignment (self);
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (self->priv->_assignment)))) {
			vala_ccode_assignment_binding_emit_signal_assignment (self);
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)) && !(VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment))))))) && !(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (self->priv->_assignment)))))))) {
				vala_ccode_assignment_binding_emit_non_array_element_access (self);
			} else {
				vala_ccode_assignment_binding_emit_simple_assignment (self);
			}
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (self->priv->_assignment), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
}


ValaAssignment* vala_ccode_assignment_binding_get_assignment (ValaCCodeAssignmentBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self), NULL);
	return self->priv->_assignment;
}


void vala_ccode_assignment_binding_set_assignment (ValaCCodeAssignmentBinding* self, ValaAssignment* value) {
	ValaAssignment* _tmp2;
	ValaAssignment* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ASSIGNMENT_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_assignment = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL))), _tmp2);
}


static void vala_ccode_assignment_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		g_value_set_object (value, vala_ccode_assignment_binding_get_assignment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT:
		vala_ccode_assignment_binding_set_assignment (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_assignment_binding_class_init (ValaCCodeAssignmentBindingClass * klass) {
	vala_ccode_assignment_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeAssignmentBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_assignment_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_assignment_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_assignment_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_assignment_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ASSIGNMENT_BINDING_ASSIGNMENT, g_param_spec_object ("assignment", "assignment", "assignment", VALA_TYPE_ASSIGNMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_assignment_binding_instance_init (ValaCCodeAssignmentBinding * self) {
	self->priv = VALA_CCODE_ASSIGNMENT_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_assignment_binding_dispose (GObject * obj) {
	ValaCCodeAssignmentBinding * self;
	self = VALA_CCODE_ASSIGNMENT_BINDING (obj);
	(self->priv->_assignment == NULL ? NULL : (self->priv->_assignment = (g_object_unref (self->priv->_assignment), NULL)));
	G_OBJECT_CLASS (vala_ccode_assignment_binding_parent_class)->dispose (obj);
}


GType vala_ccode_assignment_binding_get_type (void) {
	static GType vala_ccode_assignment_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_assignment_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignmentBinding), 0, (GInstanceInitFunc) vala_ccode_assignment_binding_instance_init };
		vala_ccode_assignment_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeAssignmentBinding", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_binding_type_id;
}




