/* valaccodedynamicpropertybinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicpropertybinding.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefunction.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valatypesymbol.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeDynamicPropertyBindingPrivate {
	ValaProperty* _node;
	char* getter_cname;
	char* setter_cname;
};

#define VALA_CCODE_DYNAMIC_PROPERTY_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, ValaCCodeDynamicPropertyBindingPrivate))
enum  {
	VALA_CCODE_DYNAMIC_PROPERTY_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE
};
static gint vala_ccode_dynamic_property_binding_dynamic_property_id;
static void vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block);
static gpointer vala_ccode_dynamic_property_binding_parent_class = NULL;
static void vala_ccode_dynamic_property_binding_dispose (GObject * obj);



ValaCCodeDynamicPropertyBinding* vala_ccode_dynamic_property_binding_new (ValaCCodeGenerator* codegen, ValaDynamicProperty* property) {
	ValaCCodeDynamicPropertyBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_PROPERTY (property), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, 0, NULL);
	vala_ccode_dynamic_property_binding_set_node (self, VALA_PROPERTY (property));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


char* vala_ccode_dynamic_property_binding_get_getter_cname (ValaCCodeDynamicPropertyBinding* self) {
	char* _tmp2;
	ValaDynamicProperty* _tmp3;
	ValaDynamicProperty* dynamic_property;
	char* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp10;
	const char* _tmp11;
	char* _tmp12;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	if (self->priv->getter_cname != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->getter_cname, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	}
	_tmp2 = NULL;
	self->priv->getter_cname = (_tmp2 = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_property_binding_dynamic_property_id++), (self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL)), _tmp2);
	_tmp3 = NULL;
	dynamic_property = (_tmp3 = VALA_DYNAMIC_PROPERTY (self->priv->_node), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	_tmp5 = NULL;
	func = (_tmp5 = vala_ccode_function_new (self->priv->getter_cname, (_tmp4 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node)))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp7 = vala_ccode_formal_parameter_new ("obj", (_tmp6 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (self, block);
	} else {
		char* _tmp9;
		char* _tmp8;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp9 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp8 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_property_get_dynamic_type (dynamic_property)))))));
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp8 = (g_free (_tmp8), NULL);
	}
	/* append to C source file*/
	_tmp10 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp10 = vala_ccode_function_copy (func))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	_tmp11 = NULL;
	_tmp12 = NULL;
	return (_tmp12 = (_tmp11 = self->priv->getter_cname, (_tmp11 == NULL ? NULL : g_strdup (_tmp11))), (dynamic_property == NULL ? NULL : (dynamic_property = (g_object_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (g_object_unref (func), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp12);
}


char* vala_ccode_dynamic_property_binding_get_setter_cname (ValaCCodeDynamicPropertyBinding* self) {
	char* _tmp2;
	ValaDynamicProperty* _tmp3;
	ValaDynamicProperty* dynamic_property;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	ValaCCodeFormalParameter* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp10;
	const char* _tmp11;
	char* _tmp12;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	if (self->priv->setter_cname != NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->setter_cname, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	}
	_tmp2 = NULL;
	self->priv->getter_cname = (_tmp2 = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_property_binding_dynamic_property_id++), (self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL)), _tmp2);
	_tmp3 = NULL;
	dynamic_property = (_tmp3 = VALA_DYNAMIC_PROPERTY (self->priv->_node), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	func = vala_ccode_function_new (self->priv->getter_cname, "void");
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("obj", (_tmp4 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (dynamic_property))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, (_tmp7 = vala_ccode_formal_parameter_new ("value", (_tmp6 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (dynamic_property)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (self, block);
	} else {
		char* _tmp9;
		char* _tmp8;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp9 = g_strdup_printf ("dynamic properties are not supported for `%s'", (_tmp8 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_property_get_dynamic_type (dynamic_property)))))));
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp8 = (g_free (_tmp8), NULL);
	}
	/* append to C source file*/
	_tmp10 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp10 = vala_ccode_function_copy (func))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
	_tmp11 = NULL;
	_tmp12 = NULL;
	return (_tmp12 = (_tmp11 = self->priv->getter_cname, (_tmp11 == NULL ? NULL : g_strdup (_tmp11))), (dynamic_property == NULL ? NULL : (dynamic_property = (g_object_unref (dynamic_property), NULL))), (func == NULL ? NULL : (func = (g_object_unref (func), NULL))), (block == NULL ? NULL : (block = (g_object_unref (block), NULL))), _tmp12);
}


static void vala_ccode_dynamic_property_binding_generate_gobject_property_getter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeConstant* _tmp6;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeConstant* _tmp9;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_property_get_property_type (self->priv->_node)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp2 = vala_ccode_variable_declarator_new ("result"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp3 = NULL;
	_tmp4 = NULL;
	call = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("g_object_get")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("obj"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp6 = vala_property_get_canonical_cconstant (self->priv->_node))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("result")))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp12 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("result")))))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


static void vala_ccode_dynamic_property_binding_generate_gobject_property_setter_wrapper (ValaCCodeDynamicPropertyBinding* self, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	_tmp1 = NULL;
	call = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_object_set")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("obj"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp3 = vala_property_get_canonical_cconstant (self->priv->_node))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("value"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("NULL"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp6 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


ValaProperty* vala_ccode_dynamic_property_binding_get_node (ValaCCodeDynamicPropertyBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self), NULL);
	return self->priv->_node;
}


void vala_ccode_dynamic_property_binding_set_node (ValaCCodeDynamicPropertyBinding* self, ValaProperty* value) {
	ValaProperty* _tmp2;
	ValaProperty* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_node = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL))), _tmp2);
}


static void vala_ccode_dynamic_property_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE:
		g_value_set_object (value, vala_ccode_dynamic_property_binding_get_node (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_property_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE:
		vala_ccode_dynamic_property_binding_set_node (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_property_binding_class_init (ValaCCodeDynamicPropertyBindingClass * klass) {
	vala_ccode_dynamic_property_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDynamicPropertyBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_dynamic_property_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_dynamic_property_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_dynamic_property_binding_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DYNAMIC_PROPERTY_BINDING_NODE, g_param_spec_object ("node", "node", "node", VALA_TYPE_PROPERTY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_dynamic_property_binding_instance_init (ValaCCodeDynamicPropertyBinding * self) {
	self->priv = VALA_CCODE_DYNAMIC_PROPERTY_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_dynamic_property_binding_dispose (GObject * obj) {
	ValaCCodeDynamicPropertyBinding * self;
	self = VALA_CCODE_DYNAMIC_PROPERTY_BINDING (obj);
	(self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL)));
	self->priv->getter_cname = (g_free (self->priv->getter_cname), NULL);
	self->priv->setter_cname = (g_free (self->priv->setter_cname), NULL);
	G_OBJECT_CLASS (vala_ccode_dynamic_property_binding_parent_class)->dispose (obj);
}


GType vala_ccode_dynamic_property_binding_get_type (void) {
	static GType vala_ccode_dynamic_property_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_dynamic_property_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicPropertyBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_property_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicPropertyBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_property_binding_instance_init };
		vala_ccode_dynamic_property_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeDynamicPropertyBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_property_binding_type_id;
}




