/* valatypecheck.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALATYPECHECK_H__
#define __VALA_VALATYPECHECK_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheckPrivate ValaTypeCheckPrivate;

/**
 * Represents a type check (`is') expression in the source code.
 */
struct _ValaTypeCheck {
	ValaExpression parent_instance;
	ValaTypeCheckPrivate * priv;
};

struct _ValaTypeCheckClass {
	ValaExpressionClass parent_class;
};


ValaTypeCheck* vala_typecheck_new (ValaExpression* expr, ValaDataType* type, ValaSourceReference* source);
ValaExpression* vala_typecheck_get_expression (ValaTypeCheck* self);
void vala_typecheck_set_expression (ValaTypeCheck* self, ValaExpression* value);
ValaDataType* vala_typecheck_get_type_reference (ValaTypeCheck* self);
void vala_typecheck_set_type_reference (ValaTypeCheck* self, ValaDataType* value);
GType vala_typecheck_get_type (void);


G_END_DECLS

#endif
