/* gtkdoccommentparser.c generated by valac, the Vala compiler
 * generated from gtkdoccommentparser.vala, do not modify */

/* gtkcommentparser.vala
 *
 * Copyright (C) 2011-2014  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_GTKDOC_PARSER_DUMMY_PROPERTY,
	VALADOC_GTKDOC_PARSER_LAST_PROPERTY
};
static GParamSpec* valadoc_gtkdoc_parser_properties[VALADOC_GTKDOC_PARSER_LAST_PROPERTY];
#define _valadoc_gtkdoc_scanner_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_scanner_unref (var), NULL)))
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _valadoc_importer_internal_id_registrar_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_importer_internal_id_registrar_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocGtkdocParserPrivate {
	ValadocGtkdocScanner* scanner;
	ValadocGtkdocToken* current;
	ValaList* stack;
	ValaList* footnotes;
	ValadocContentContentFactory* factory;
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValadocApiTree* tree;
	ValadocApiNode* element;
	gboolean show_warnings;
	ValadocApiSourceComment* comment;
	const gchar* instance_param_name;
	gchar** comment_lines;
	gint comment_lines_length1;
	gint _comment_lines_size_;
	GRegex* is_numeric_regex;
	GRegex* normalize_regex;
	GRegex* regex_source_lang;
	ValadocImporterInternalIdRegistrar* id_registrar;
	ValadocGirMetaData* current_metadata;
};


static gpointer valadoc_gtkdoc_parser_parent_class = NULL;
static ValadocResourceLocatorIface * valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = NULL;

#define VALADOC_GTKDOC_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_GTKDOC_TYPE_PARSER, ValadocGtkdocParserPrivate))
static inline gchar* valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self, const gchar* path);
static void valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self, ValadocApiSourceComment* comment);
static gchar* valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self, const gchar* text);
static gboolean valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self, const gchar* str);
static void valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self, ValadocGtkdocToken* got, const gchar* expected);
static void valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self, ValadocGtkdocToken* got, const gchar* message);
static ValadocContentNote* _valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self, ValadocApiSourceComment* comment);
static ValadocContentComment* valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self, ValadocApiSourceComment* gir_comment);
static void valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self, ValadocContentComment* * comment, ValadocContentNote* note);
static void valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self, ValadocContentComment* * comment, ValadocContentTaglet* taglet);
G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment, ValadocContentContentFactory* factory);
static ValadocContentTaglet* valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self, ValadocApiSourceComment* gir_comment, const gchar* taglet_name);
G_GNUC_INTERNAL void valadoc_taglets_param_set_is_c_self_param (ValadocTagletsParam* self, gboolean value);
G_GNUC_INTERNAL void valadoc_taglets_param_set_parameter_name (ValadocTagletsParam* self, const gchar* value);
static ValadocGtkdocToken* valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self, gboolean accept_paragraphs);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self, const gchar* tagname);
static gboolean valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self, const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self, const gchar* tagname, gboolean is_internal);
G_GNUC_INTERNAL void valadoc_content_link_set_id_registrar (ValadocContentLink* self, ValadocImporterInternalIdRegistrar* value);
static ValadocContentInlineTaglet* valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self, const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self, const gchar* name, gboolean c_accept_plural);
static void valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self);
static ValadocContentLink* valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self, const gchar* tag_name, ValadocContentRunStyle style);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self);
static ValadocContentBlockContent* valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self, const gchar* tagname, ValadocContentBlockContent* container);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self);
static ValadocContentWarning* valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self, const gchar* tag_name, ValadocContentListBullet bullet_type);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self, ValaCollection* run, ValadocContentBlock* element);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self, const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self);
static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self);
G_GNUC_INTERNAL gboolean valadoc_highlighter_xml_scanner_is_xml (const gchar* source);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self);
static ValadocContentEmbedded* valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self, const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self, const gchar* tag_name);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self, gint nr);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self, ValaCollection* run, ValaCollection* elements);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self, ValadocContentRunStyle default_style);
static ValadocContentTableCell* valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self, ValadocContentRunStyle default_style);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self);
static ValadocContentList* valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self, ValadocContentRun* run, const gchar* current);
G_GNUC_INTERNAL void valadoc_taglets_link_set_c_accept_plural (ValadocTagletsLink* self, gboolean value);
G_GNUC_INTERNAL void valadoc_taglets_link_set_symbol_name (ValadocTagletsLink* self, const gchar* value);
static inline void valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self, ValadocContentRun* run, ValadocContentInline* element);
G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree, ValadocApiNode* element, const gchar* parameter_name, gchar* * param_name, gchar* * param_array_name, gboolean* is_return_type_len);
static gchar* valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base, const gchar* path);
static void valadoc_gtkdoc_parser_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gchar* valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self, const gchar* path) {
	gchar* result = NULL;
	ValadocGirMetaData* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->current_metadata;
	_tmp1_ = path;
	_tmp2_ = valadoc_gir_meta_data_get_resource_path (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gpointer _valadoc_api_source_comment_ref0 (gpointer self) {
	return self ? valadoc_api_source_comment_ref (self) : NULL;
}


static void valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self, ValadocApiSourceComment* comment) {
	ValadocGtkdocScanner* _tmp0_;
	ValadocApiSourceComment* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiSourceFile* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	ValadocApiPackage* _tmp7_;
	ValadocApiPackage* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	ValaList* _tmp11_;
	ValadocApiSourceComment* _tmp12_;
	ValadocApiSourceComment* _tmp13_;
	ValaList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = comment;
	_tmp2_ = valadoc_api_source_comment_get_content (_tmp1_);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_scanner_reset (_tmp0_, _tmp3_);
	_tmp4_ = comment;
	_tmp5_ = valadoc_api_source_comment_get_file (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_source_file_get_package (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_package_get_is_package (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->show_warnings = !_tmp10_;
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->comment_lines = NULL;
	self->priv->comment_lines_length1 = 0;
	self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	_tmp11_ = self->priv->footnotes;
	vala_collection_clear ((ValaCollection*) _tmp11_);
	_tmp12_ = comment;
	_tmp13_ = _valadoc_api_source_comment_ref0 (_tmp12_);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp14_ = self->priv->stack;
	vala_collection_clear ((ValaCollection*) _tmp14_);
}


static gchar* valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self, const gchar* text) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->normalize_regex;
		_tmp2_ = text;
		_tmp3_ = g_regex_replace (_tmp1_, _tmp2_, (gssize) -1, 0, " ", 0, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp4_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self, const gchar* str) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = self->priv->is_numeric_regex;
	_tmp1_ = str;
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
	result = _tmp2_;
	return result;
}


static void valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self, ValadocGtkdocToken* got, const gchar* expected) {
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (expected != NULL);
	_tmp0_ = got;
	_tmp1_ = got;
	_tmp2_ = valadoc_gtkdoc_token_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = expected;
	_tmp5_ = g_strdup_printf ("Unexpected Token: %s (Expected: %s)", _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	valadoc_gtkdoc_parser_report_warning (self, _tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
}


static void valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self, ValadocGtkdocToken* got, const gchar* message) {
	gboolean _tmp0_;
	gint _tmp1_ = 0;
	ValadocGtkdocToken* _tmp2_;
	gint _tmp3_;
	gint startpos = 0;
	gint _tmp11_ = 0;
	ValadocGtkdocToken* _tmp12_;
	gint _tmp13_;
	gint endpos = 0;
	gchar** _tmp21_;
	gint _tmp21__length1;
	ValadocErrorReporter* _tmp27_;
	ValadocApiSourceComment* _tmp28_;
	ValadocApiSourceFile* _tmp29_;
	ValadocApiSourceFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValadocApiSourceComment* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	ValadocGtkdocToken* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	ValadocGtkdocToken* _tmp41_;
	gint _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->show_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = got;
	_tmp3_ = _tmp2_->line;
	if (_tmp3_ == 0) {
		ValadocApiSourceComment* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		ValadocGtkdocToken* _tmp7_;
		gint _tmp8_;
		_tmp4_ = self->priv->comment;
		_tmp5_ = valadoc_api_source_comment_get_first_column (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = got;
		_tmp8_ = _tmp7_->first_column;
		_tmp1_ = _tmp6_ + _tmp8_;
	} else {
		ValadocGtkdocToken* _tmp9_;
		gint _tmp10_;
		_tmp9_ = got;
		_tmp10_ = _tmp9_->first_column;
		_tmp1_ = _tmp10_;
	}
	startpos = _tmp1_;
	_tmp12_ = got;
	_tmp13_ = _tmp12_->line;
	if (_tmp13_ == 0) {
		ValadocApiSourceComment* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		ValadocGtkdocToken* _tmp17_;
		gint _tmp18_;
		_tmp14_ = self->priv->comment;
		_tmp15_ = valadoc_api_source_comment_get_first_column (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = got;
		_tmp18_ = _tmp17_->last_column;
		_tmp11_ = _tmp16_ + _tmp18_;
	} else {
		ValadocGtkdocToken* _tmp19_;
		gint _tmp20_;
		_tmp19_ = got;
		_tmp20_ = _tmp19_->last_column;
		_tmp11_ = _tmp20_;
	}
	endpos = _tmp11_;
	_tmp21_ = self->priv->comment_lines;
	_tmp21__length1 = self->priv->comment_lines_length1;
	if (_tmp21_ == NULL) {
		ValadocApiSourceComment* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		_tmp22_ = self->priv->comment;
		_tmp23_ = valadoc_api_source_comment_get_content (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "\n", 0);
		self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
		self->priv->comment_lines = _tmp26_;
		self->priv->comment_lines_length1 = _vala_array_length (_tmp25_);
		self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	}
	_tmp27_ = self->priv->reporter;
	_tmp28_ = self->priv->comment;
	_tmp29_ = valadoc_api_source_comment_get_file (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = valadoc_api_source_file_get_name (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->comment;
	_tmp34_ = valadoc_api_source_comment_get_first_line (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = got;
	_tmp37_ = _tmp36_->line;
	_tmp38_ = startpos;
	_tmp39_ = endpos;
	_tmp40_ = self->priv->comment_lines;
	_tmp40__length1 = self->priv->comment_lines_length1;
	_tmp41_ = got;
	_tmp42_ = _tmp41_->line;
	_tmp43_ = _tmp40_[_tmp42_];
	_tmp44_ = message;
	valadoc_error_reporter_warning (_tmp27_, _tmp32_, (glong) (_tmp35_ + _tmp37_), (glong) (_tmp38_ + 1), (glong) (_tmp39_ + 1), _tmp43_, "%s", _tmp44_);
	_g_free0 (_tmp32_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _valadoc_api_tree_ref0 (gpointer self) {
	return self ? valadoc_api_tree_ref (self) : NULL;
}


ValadocGtkdocParser* valadoc_gtkdoc_parser_construct (GType object_type, ValadocSettings* settings, ValadocErrorReporter* reporter, ValadocApiTree* tree, ValadocModuleLoader* modules) {
	ValadocGtkdocParser * self = NULL;
	ValadocSettings* _tmp0_;
	ValadocModuleLoader* _tmp1_;
	ValadocContentContentFactory* _tmp2_;
	ValadocErrorReporter* _tmp3_;
	ValadocErrorReporter* _tmp4_;
	ValadocSettings* _tmp5_;
	ValadocSettings* _tmp6_;
	ValadocApiTree* _tmp7_;
	ValadocApiTree* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	self = (ValadocGtkdocParser*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = modules;
	_tmp2_ = valadoc_content_content_factory_new (_tmp0_, (ValadocResourceLocator*) self, _tmp1_);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp2_;
	_tmp3_ = reporter;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp4_;
	_tmp5_ = settings;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp6_;
	_tmp7_ = tree;
	_tmp8_ = _valadoc_api_tree_ref0 (_tmp7_);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp8_;
	{
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		GRegex* _tmp12_ = NULL;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		GRegex* _tmp15_ = NULL;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		_tmp10_ = g_regex_new ("^[+-]?([0-9]*\\.?[0-9]+|[0-9]+\\.?[0-9]*)([eE][+-]?[0-9]+)?$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_regex_unref0 (self->priv->is_numeric_regex);
		self->priv->is_numeric_regex = _tmp11_;
		_tmp13_ = g_regex_new ("( |\n|\t)+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp9_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (_tmp9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_regex_unref0 (self->priv->normalize_regex);
		self->priv->normalize_regex = _tmp14_;
		_tmp16_ = g_regex_new ("^<!--[ \t]+language=\"([A-Za-z]*)\"[ \t]+-->", 0, 0, &_inner_error_);
		_tmp15_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp9_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = _tmp15_;
		_tmp15_ = NULL;
		_g_regex_unref0 (self->priv->regex_source_lang);
		self->priv->regex_source_lang = _tmp17_;
		_g_regex_unref0 (_tmp15_);
		_g_regex_unref0 (_tmp12_);
		_g_regex_unref0 (_tmp9_);
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValadocGtkdocParser* valadoc_gtkdoc_parser_new (ValadocSettings* settings, ValadocErrorReporter* reporter, ValadocApiTree* tree, ValadocModuleLoader* modules) {
	return valadoc_gtkdoc_parser_construct (VALADOC_GTKDOC_TYPE_PARSER, settings, reporter, tree, modules);
}


static ValadocContentNote* _valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self, ValadocApiSourceComment* comment) {
	ValadocContentNote* result = NULL;
	ValadocContentComment* cmnt = NULL;
	ValadocApiSourceComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentNote* note = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValadocContentNote* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValadocContentComment* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (comment != NULL, NULL);
	_tmp0_ = comment;
	_tmp1_ = valadoc_gtkdoc_parser_parse_root_content (self, _tmp0_);
	cmnt = _tmp1_;
	_tmp2_ = cmnt;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (cmnt);
		return result;
	}
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_note (_tmp3_);
	note = _tmp4_;
	_tmp5_ = note;
	_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = cmnt;
	_tmp9_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	vala_collection_add_all ((ValaCollection*) _tmp7_, (ValaCollection*) _tmp10_);
	result = note;
	_g_object_unref0 (cmnt);
	return result;
}


static void valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self, ValadocContentComment* * comment, ValadocContentNote* note) {
	ValadocContentNote* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValadocContentComment* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValadocContentNote* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = note;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = *comment;
	if (_tmp1_ == NULL) {
		ValadocContentContentFactory* _tmp2_;
		ValadocContentComment* _tmp3_;
		_tmp2_ = self->priv->factory;
		_tmp3_ = valadoc_content_content_factory_create_comment (_tmp2_);
		_g_object_unref0 (*comment);
		*comment = _tmp3_;
	}
	_tmp4_ = *comment;
	_tmp5_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		ValadocContentComment* _tmp9_;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		ValadocContentContentFactory* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		ValadocContentParagraph* _tmp14_;
		_tmp9_ = *comment;
		_tmp10_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->factory;
		_tmp13_ = valadoc_content_content_factory_create_paragraph (_tmp12_);
		_tmp14_ = _tmp13_;
		vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentBlock*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = *comment;
	_tmp16_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = note;
	vala_list_insert (_tmp17_, 1, (ValadocContentBlock*) _tmp18_);
}


static void valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self, ValadocContentComment* * comment, ValadocContentTaglet* taglet) {
	ValadocContentTaglet* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentTaglet* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = taglet;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = *comment;
	if (_tmp1_ == NULL) {
		ValadocContentContentFactory* _tmp2_;
		ValadocContentComment* _tmp3_;
		_tmp2_ = self->priv->factory;
		_tmp3_ = valadoc_content_content_factory_create_comment (_tmp2_);
		_g_object_unref0 (*comment);
		*comment = _tmp3_;
	}
	_tmp4_ = *comment;
	_tmp5_ = valadoc_content_comment_get_taglets (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = taglet;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
}


static gpointer _valadoc_importer_internal_id_registrar_ref0 (gpointer self) {
	return self ? valadoc_importer_internal_id_registrar_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValadocContentComment* valadoc_gtkdoc_parser_parse (ValadocGtkdocParser* self, ValadocApiNode* element, ValadocApiGirSourceComment* gir_comment, ValadocGirMetaData* gir_metadata, ValadocImporterInternalIdRegistrar* id_registrar) {
	ValadocContentComment* result = NULL;
	ValadocApiGirSourceComment* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocGirMetaData* _tmp3_;
	ValadocGirMetaData* _tmp4_;
	ValadocImporterInternalIdRegistrar* _tmp5_;
	ValadocImporterInternalIdRegistrar* _tmp6_;
	ValadocApiNode* _tmp7_;
	ValadocApiNode* _tmp8_;
	ValadocContentComment* cmnt = NULL;
	ValadocApiGirSourceComment* _tmp9_;
	ValadocContentComment* _tmp10_;
	ValadocContentComment* _tmp11_;
	ValadocApiGirSourceComment* _tmp14_;
	ValadocApiSourceComment* _tmp15_;
	ValadocApiSourceComment* _tmp16_;
	ValadocApiGirSourceComment* _tmp22_;
	ValadocApiSourceComment* _tmp23_;
	ValadocApiSourceComment* _tmp24_;
	ValadocApiGirSourceComment* _tmp30_;
	ValadocApiSourceComment* _tmp31_;
	ValadocApiSourceComment* _tmp32_;
	ValadocApiGirSourceComment* _tmp38_;
	ValadocApiSourceComment* _tmp39_;
	ValadocApiSourceComment* _tmp40_;
	ValaMapIterator* iter = NULL;
	ValadocApiGirSourceComment* _tmp46_;
	ValaMapIterator* _tmp47_;
	gboolean first = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (gir_metadata != NULL, NULL);
	g_return_val_if_fail (id_registrar != NULL, NULL);
	_tmp0_ = gir_comment;
	_tmp1_ = valadoc_api_gir_source_comment_get_instance_param_name (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->instance_param_name = _tmp2_;
	_tmp3_ = gir_metadata;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->current_metadata);
	self->priv->current_metadata = _tmp4_;
	_tmp5_ = id_registrar;
	_tmp6_ = _valadoc_importer_internal_id_registrar_ref0 (_tmp5_);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	self->priv->id_registrar = _tmp6_;
	_tmp7_ = element;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->element);
	self->priv->element = _tmp8_;
	_tmp9_ = gir_comment;
	_tmp10_ = valadoc_gtkdoc_parser_parse_root_content (self, (ValadocApiSourceComment*) _tmp9_);
	cmnt = _tmp10_;
	_tmp11_ = cmnt;
	if (_tmp11_ != NULL) {
		ValadocContentComment* _tmp12_;
		ValadocContentContentFactory* _tmp13_;
		_tmp12_ = cmnt;
		_tmp13_ = self->priv->factory;
		valadoc_importer_helper_extract_short_desc (_tmp12_, _tmp13_);
	}
	_tmp14_ = gir_comment;
	_tmp15_ = valadoc_api_gir_source_comment_get_deprecated_comment (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiGirSourceComment* _tmp17_;
		ValadocApiSourceComment* _tmp18_;
		ValadocApiSourceComment* _tmp19_;
		ValadocContentNote* _tmp20_;
		ValadocContentNote* _tmp21_;
		_tmp17_ = gir_comment;
		_tmp18_ = valadoc_api_gir_source_comment_get_deprecated_comment (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp19_);
		note = _tmp20_;
		_tmp21_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp21_);
		_g_object_unref0 (note);
	}
	_tmp22_ = gir_comment;
	_tmp23_ = valadoc_api_gir_source_comment_get_version_comment (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiGirSourceComment* _tmp25_;
		ValadocApiSourceComment* _tmp26_;
		ValadocApiSourceComment* _tmp27_;
		ValadocContentNote* _tmp28_;
		ValadocContentNote* _tmp29_;
		_tmp25_ = gir_comment;
		_tmp26_ = valadoc_api_gir_source_comment_get_version_comment (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp27_);
		note = _tmp28_;
		_tmp29_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp29_);
		_g_object_unref0 (note);
	}
	_tmp30_ = gir_comment;
	_tmp31_ = valadoc_api_gir_source_comment_get_stability_comment (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiGirSourceComment* _tmp33_;
		ValadocApiSourceComment* _tmp34_;
		ValadocApiSourceComment* _tmp35_;
		ValadocContentNote* _tmp36_;
		ValadocContentNote* _tmp37_;
		_tmp33_ = gir_comment;
		_tmp34_ = valadoc_api_gir_source_comment_get_stability_comment (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp35_);
		note = _tmp36_;
		_tmp37_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp37_);
		_g_object_unref0 (note);
	}
	_tmp38_ = gir_comment;
	_tmp39_ = valadoc_api_gir_source_comment_get_return_comment (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ != NULL) {
		ValadocContentTaglet* taglet = NULL;
		ValadocApiGirSourceComment* _tmp41_;
		ValadocApiSourceComment* _tmp42_;
		ValadocApiSourceComment* _tmp43_;
		ValadocContentTaglet* _tmp44_;
		ValadocContentTaglet* _tmp45_;
		_tmp41_ = gir_comment;
		_tmp42_ = valadoc_api_gir_source_comment_get_return_comment (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp43_, "return");
		taglet = _tmp44_;
		_tmp45_ = taglet;
		valadoc_gtkdoc_parser_add_taglet (self, &cmnt, _tmp45_);
		_g_object_unref0 (taglet);
	}
	_tmp46_ = gir_comment;
	_tmp47_ = valadoc_api_gir_source_comment_parameter_iterator (_tmp46_);
	iter = _tmp47_;
	{
		gboolean has_next = FALSE;
		ValaMapIterator* _tmp48_;
		gboolean _tmp49_;
		_tmp48_ = iter;
		_tmp49_ = vala_map_iterator_next (_tmp48_);
		has_next = _tmp49_;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gboolean _tmp53_;
				ValadocTagletsParam* taglet = NULL;
				ValaMapIterator* _tmp54_;
				gpointer _tmp55_;
				ValadocApiSourceComment* _tmp56_;
				ValadocContentTaglet* _tmp57_;
				ValadocTagletsParam* _tmp58_;
				ValadocTagletsParam* _tmp59_;
				gchar* param_name = NULL;
				ValaMapIterator* _tmp60_;
				gpointer _tmp61_;
				ValadocTagletsParam* _tmp62_;
				const gchar* _tmp63_;
				ValadocApiGirSourceComment* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				ValadocTagletsParam* _tmp67_;
				const gchar* _tmp68_;
				ValadocTagletsParam* _tmp69_;
				if (!_tmp50_) {
					ValaMapIterator* _tmp51_;
					gboolean _tmp52_;
					_tmp51_ = iter;
					_tmp52_ = vala_map_iterator_next (_tmp51_);
					has_next = _tmp52_;
				}
				_tmp50_ = FALSE;
				_tmp53_ = has_next;
				if (!_tmp53_) {
					break;
				}
				_tmp54_ = iter;
				_tmp55_ = vala_map_iterator_get_value (_tmp54_);
				_tmp56_ = (ValadocApiSourceComment*) _tmp55_;
				_tmp57_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp56_, "param");
				_tmp58_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALADOC_TAGLETS_TYPE_PARAM) ? ((ValadocTagletsParam*) _tmp57_) : NULL;
				if (_tmp58_ == NULL) {
					_g_object_unref0 (_tmp57_);
				}
				_tmp59_ = _tmp58_;
				_valadoc_api_source_comment_unref0 (_tmp56_);
				taglet = _tmp59_;
				_tmp60_ = iter;
				_tmp61_ = vala_map_iterator_get_key (_tmp60_);
				param_name = (gchar*) _tmp61_;
				_tmp62_ = taglet;
				_tmp63_ = param_name;
				_tmp64_ = gir_comment;
				_tmp65_ = valadoc_api_gir_source_comment_get_instance_param_name (_tmp64_);
				_tmp66_ = _tmp65_;
				valadoc_taglets_param_set_is_c_self_param (_tmp62_, g_strcmp0 (_tmp63_, _tmp66_) == 0);
				_tmp67_ = taglet;
				_tmp68_ = param_name;
				valadoc_taglets_param_set_parameter_name (_tmp67_, _tmp68_);
				_tmp69_ = taglet;
				valadoc_gtkdoc_parser_add_taglet (self, &cmnt, (ValadocContentTaglet*) _tmp69_);
				_g_free0 (param_name);
				_g_object_unref0 (taglet);
			}
		}
	}
	first = TRUE;
	{
		ValaList* _note_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _note_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _note_index = 0;
		_tmp70_ = self->priv->footnotes;
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_note_list = _tmp71_;
		_tmp72_ = _note_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_note_size = _tmp74_;
		_note_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			ValaList* note = NULL;
			ValaList* _tmp78_;
			gint _tmp79_;
			gpointer _tmp80_;
			gboolean _tmp81_ = FALSE;
			gboolean _tmp82_;
			ValadocContentComment* _tmp103_;
			ValaList* _tmp104_;
			ValaList* _tmp105_;
			ValaList* _tmp106_;
			_tmp75_ = _note_index;
			_note_index = _tmp75_ + 1;
			_tmp76_ = _note_index;
			_tmp77_ = _note_size;
			if (!(_tmp76_ < _tmp77_)) {
				break;
			}
			_tmp78_ = _note_list;
			_tmp79_ = _note_index;
			_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
			note = (ValaList*) _tmp80_;
			_tmp82_ = first;
			if (_tmp82_ == TRUE) {
				ValaList* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				_tmp83_ = note;
				_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp81_ = _tmp85_ > 0;
			} else {
				_tmp81_ = FALSE;
			}
			if (_tmp81_) {
				ValadocContentParagraph* p = NULL;
				ValaList* _tmp86_;
				gpointer _tmp87_;
				ValadocContentBlock* _tmp88_;
				ValadocContentParagraph* _tmp89_;
				ValadocContentParagraph* _tmp90_;
				ValadocContentParagraph* _tmp97_;
				ValaList* _tmp98_;
				ValaList* _tmp99_;
				ValadocContentContentFactory* _tmp100_;
				ValadocContentText* _tmp101_;
				ValadocContentText* _tmp102_;
				_tmp86_ = note;
				_tmp87_ = vala_list_first (_tmp86_);
				_tmp88_ = (ValadocContentBlock*) _tmp87_;
				_tmp89_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALADOC_CONTENT_TYPE_PARAGRAPH) ? ((ValadocContentParagraph*) _tmp88_) : NULL;
				if (_tmp89_ == NULL) {
					_g_object_unref0 (_tmp88_);
				}
				p = _tmp89_;
				_tmp90_ = p;
				if (_tmp90_ == NULL) {
					ValadocContentContentFactory* _tmp91_;
					ValadocContentParagraph* _tmp92_;
					ValadocContentComment* _tmp93_;
					ValaList* _tmp94_;
					ValaList* _tmp95_;
					ValadocContentParagraph* _tmp96_;
					_tmp91_ = self->priv->factory;
					_tmp92_ = valadoc_content_content_factory_create_paragraph (_tmp91_);
					_g_object_unref0 (p);
					p = _tmp92_;
					_tmp93_ = cmnt;
					_tmp94_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = p;
					vala_collection_add ((ValaCollection*) _tmp95_, (ValadocContentBlock*) _tmp96_);
				}
				_tmp97_ = p;
				_tmp98_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = self->priv->factory;
				_tmp101_ = valadoc_content_content_factory_create_text (_tmp100_, "\n");
				_tmp102_ = _tmp101_;
				vala_list_insert (_tmp99_, 0, (ValadocContentInline*) _tmp102_);
				_g_object_unref0 (_tmp102_);
				_g_object_unref0 (p);
			}
			_tmp103_ = cmnt;
			_tmp104_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = note;
			vala_collection_add_all ((ValaCollection*) _tmp105_, (ValaCollection*) _tmp106_);
			first = FALSE;
			_vala_iterable_unref0 (note);
		}
		_vala_iterable_unref0 (_note_list);
	}
	result = cmnt;
	_vala_map_iterator_unref0 (iter);
	return result;
}


static ValadocContentTaglet* valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self, ValadocApiSourceComment* gir_comment, const gchar* taglet_name) {
	ValadocContentTaglet* result = NULL;
	ValadocApiSourceComment* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentRun* ic = NULL;
	ValadocContentRun* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocTokenType _tmp5_;
	ValadocContentBlockContent* taglet = NULL;
	ValadocContentContentFactory* _tmp7_;
	const gchar* _tmp8_;
	ValadocContentTaglet* _tmp9_;
	ValadocContentBlockContent* _tmp10_;
	ValadocContentBlockContent* _tmp11_;
	ValadocContentParagraph* paragraph = NULL;
	ValadocContentContentFactory* _tmp12_;
	ValadocContentParagraph* _tmp13_;
	ValadocContentParagraph* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValadocContentRun* _tmp17_;
	ValadocContentBlockContent* _tmp18_;
	ValaList* _tmp19_;
	ValaList* _tmp20_;
	ValadocContentParagraph* _tmp21_;
	ValadocContentBlockContent* _tmp22_;
	ValadocContentTaglet* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (taglet_name != NULL, NULL);
	_tmp0_ = gir_comment;
	valadoc_gtkdoc_parser_reset (self, _tmp0_);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp3_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	ic = _tmp3_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp4_ = self->priv->current;
	_tmp5_ = _tmp4_->type;
	if (_tmp5_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocGtkdocToken* _tmp6_;
		_tmp6_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp6_, "<EOF>");
		result = NULL;
		_g_object_unref0 (ic);
		return result;
	}
	_tmp7_ = self->priv->factory;
	_tmp8_ = taglet_name;
	_tmp9_ = valadoc_content_content_factory_create_taglet (_tmp7_, _tmp8_);
	_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT) ? ((ValadocContentBlockContent*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	taglet = _tmp10_;
	_tmp11_ = taglet;
	_vala_assert (_tmp11_ != NULL, "taglet != null");
	_tmp12_ = self->priv->factory;
	_tmp13_ = valadoc_content_content_factory_create_paragraph (_tmp12_);
	paragraph = _tmp13_;
	_tmp14_ = paragraph;
	_tmp15_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = ic;
	vala_collection_add ((ValaCollection*) _tmp16_, (ValadocContentInline*) _tmp17_);
	_tmp18_ = taglet;
	_tmp19_ = valadoc_content_block_content_get_content (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = paragraph;
	vala_collection_add ((ValaCollection*) _tmp20_, (ValadocContentBlock*) _tmp21_);
	_tmp22_ = taglet;
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALADOC_CONTENT_TYPE_TAGLET) ? ((ValadocContentTaglet*) _tmp22_) : NULL);
	result = _tmp23_;
	_g_object_unref0 (paragraph);
	_g_object_unref0 (taglet);
	_g_object_unref0 (ic);
	return result;
}


static gpointer _valadoc_gtkdoc_token_ref0 (gpointer self) {
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}


static ValadocContentComment* valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self, ValadocApiSourceComment* gir_comment) {
	ValadocContentComment* result = NULL;
	ValadocApiSourceComment* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* tmp = NULL;
	ValadocContentComment* comment = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentComment* _tmp4_;
	ValadocGtkdocToken* _tmp40_;
	ValadocGtkdocTokenType _tmp41_;
	ValadocContentComment* _tmp43_;
	ValadocContentContentFactory* _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	_tmp0_ = gir_comment;
	valadoc_gtkdoc_parser_reset (self, _tmp0_);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	tmp = NULL;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_comment (_tmp3_);
	comment = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		ValadocGtkdocToken* _tmp10_;
		ValadocGtkdocToken* _tmp11_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValadocContentRun* _tmp14_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp30_;
		gboolean _tmp31_ = FALSE;
		ValaCollection* _tmp32_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
			ValadocGtkdocToken* _tmp8_;
			ValadocGtkdocToken* _tmp9_;
			_tmp8_ = tmp;
			_tmp9_ = self->priv->current;
			_tmp5_ = _tmp8_ != _tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp10_ = self->priv->current;
		_tmp11_ = _valadoc_gtkdoc_token_ref0 (_tmp10_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp11_;
		_tmp12_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp12_;
		_tmp14_ = ic;
		if (_tmp14_ != NULL) {
			ValadocContentRun* _tmp15_;
			ValaList* _tmp16_;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp15_ = ic;
			_tmp16_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = _tmp19_ > 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			ValadocContentParagraph* _tmp22_;
			ValaList* _tmp23_;
			ValaList* _tmp24_;
			ValadocContentRun* _tmp25_;
			ValadocContentComment* _tmp26_;
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			ValadocContentParagraph* _tmp29_;
			_tmp20_ = self->priv->factory;
			_tmp21_ = valadoc_content_content_factory_create_paragraph (_tmp20_);
			p = _tmp21_;
			_tmp22_ = p;
			_tmp23_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = ic;
			vala_collection_add ((ValaCollection*) _tmp24_, (ValadocContentInline*) _tmp25_);
			_tmp26_ = comment;
			_tmp27_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = p;
			vala_collection_add ((ValaCollection*) _tmp28_, (ValadocContentBlock*) _tmp29_);
			_g_object_unref0 (p);
		}
		_tmp30_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp30_;
		_tmp32_ = bc;
		if (_tmp32_ != NULL) {
			ValaCollection* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			_tmp33_ = bc;
			_tmp34_ = vala_collection_get_size (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp31_ = _tmp35_ > 0;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValadocContentComment* _tmp36_;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			ValaCollection* _tmp39_;
			_tmp36_ = comment;
			_tmp37_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp38_, _tmp39_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	_tmp40_ = self->priv->current;
	_tmp41_ = _tmp40_->type;
	if (_tmp41_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocGtkdocToken* _tmp42_;
		_tmp42_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp42_, "<INLINE|BLOCK>");
		result = NULL;
		_g_object_unref0 (comment);
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp43_ = comment;
	_tmp44_ = self->priv->factory;
	valadoc_importer_helper_extract_short_desc (_tmp43_, _tmp44_);
	result = comment;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}


static ValadocGtkdocToken* valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self) {
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocScanner* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = valadoc_gtkdoc_scanner_next (_tmp0_);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = _tmp1_;
	_tmp2_ = self->priv->current;
	_tmp3_ = _valadoc_gtkdoc_token_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self) {
	gboolean result = FALSE;
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	gchar* name = NULL;
	ValadocGtkdocToken* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	ValaList* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->content;
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->stack;
	_tmp6_ = name;
	_tmp7_ = vala_collection_contains ((ValaCollection*) _tmp5_, _tmp6_);
	if (_tmp7_ == FALSE) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}


static gboolean valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self, const gchar* tagname) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocTokenType _tmp3_;
	ValaList* _tmp9_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->content;
		_tmp6_ = tagname;
		_tmp1_ = g_strcmp0 (_tmp5_, _tmp6_) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		_tmp0_ = _tmp8_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->stack;
	_tmp10_ = tagname;
	vala_list_insert (_tmp9_, 0, _tmp10_);
	result = TRUE;
	return result;
}


static gboolean valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self, const gchar* tagname) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocTokenType _tmp3_;
	ValaList* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		ValadocGtkdocToken* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->content;
		_tmp6_ = tagname;
		_tmp1_ = g_strcmp0 (_tmp5_, _tmp6_) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		_tmp0_ = _tmp8_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->stack;
	_tmp10_ = vala_list_remove_at (_tmp9_, 0);
	_tmp11_ = (gchar*) _tmp10_;
	_tmp12_ = tagname;
	_vala_assert (g_strcmp0 (_tmp11_, _tmp12_) == 0, "stack.remove_at (0) == tagname");
	_g_free0 (_tmp11_);
	result = TRUE;
	return result;
}


static void valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self, gboolean accept_paragraphs) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValadocGtkdocToken* _tmp0_;
		ValadocGtkdocTokenType _tmp1_;
		_tmp0_ = self->priv->current;
		_tmp1_ = _tmp0_->type;
		if (_tmp1_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE) {
			ValadocGtkdocToken* _tmp2_;
			ValadocGtkdocToken* _tmp3_;
			_tmp2_ = valadoc_gtkdoc_parser_next (self);
			_tmp3_ = _tmp2_;
			_valadoc_gtkdoc_token_unref0 (_tmp3_);
		} else {
			ValadocGtkdocToken* _tmp4_;
			ValadocGtkdocTokenType _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_->type;
			if (_tmp5_ == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
				ValadocGtkdocToken* _tmp6_;
				ValadocGtkdocToken* _tmp7_;
				_tmp6_ = valadoc_gtkdoc_parser_next (self);
				_tmp7_ = _tmp6_;
				_valadoc_gtkdoc_token_unref0 (_tmp7_);
			} else {
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_;
				_tmp9_ = accept_paragraphs;
				if (_tmp9_) {
					ValadocGtkdocToken* _tmp10_;
					ValadocGtkdocTokenType _tmp11_;
					_tmp10_ = self->priv->current;
					_tmp11_ = _tmp10_->type;
					_tmp8_ = _tmp11_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					ValadocGtkdocToken* _tmp12_;
					ValadocGtkdocToken* _tmp13_;
					_tmp12_ = valadoc_gtkdoc_parser_next (self);
					_tmp13_ = _tmp12_;
					_valadoc_gtkdoc_token_unref0 (_tmp13_);
				} else {
					break;
				}
			}
		}
	}
}


static ValadocContentInline* valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self, const gchar* tagname, gboolean is_internal) {
	ValadocContentInline* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GString* builder = NULL;
	GString* _tmp6_;
	gchar* url = NULL;
	ValadocGtkdocToken* _tmp7_;
	ValaHashMap* _tmp8_;
	gpointer _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp32_;
	ValadocContentLink* _tmp33_;
	gboolean _tmp34_;
	ValadocContentLink* _tmp37_;
	const gchar* _tmp38_;
	GString* _tmp39_;
	gssize _tmp40_;
	const gchar* _tmp58_;
	gboolean _tmp59_;
	ValadocGtkdocToken* _tmp64_;
	ValadocGtkdocToken* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	_tmp0_ = tagname;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tagname;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = g_string_new ("");
	builder = _tmp6_;
	_tmp7_ = self->priv->current;
	_tmp8_ = _tmp7_->attributes;
	_tmp9_ = vala_map_get ((ValaMap*) _tmp8_, "linkend");
	url = (gchar*) _tmp9_;
	_tmp10_ = valadoc_gtkdoc_parser_next (self);
	_tmp11_ = _tmp10_;
	_valadoc_gtkdoc_token_unref0 (_tmp11_);
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocTokenType _tmp15_;
		ValadocGtkdocToken* _tmp21_;
		ValadocGtkdocTokenType _tmp22_;
		ValadocGtkdocToken* _tmp30_;
		ValadocGtkdocToken* _tmp31_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_->type;
		if (_tmp15_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_->content;
			_tmp18_ = tagname;
			_tmp13_ = g_strcmp0 (_tmp17_, _tmp18_) == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			ValadocGtkdocToken* _tmp19_;
			ValadocGtkdocTokenType _tmp20_;
			_tmp19_ = self->priv->current;
			_tmp20_ = _tmp19_->type;
			_tmp12_ = _tmp20_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		_tmp21_ = self->priv->current;
		_tmp22_ = _tmp21_->type;
		if (_tmp22_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		} else {
			ValadocGtkdocToken* _tmp23_;
			ValadocGtkdocTokenType _tmp24_;
			_tmp23_ = self->priv->current;
			_tmp24_ = _tmp23_->type;
			if (_tmp24_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			} else {
				ValadocGtkdocToken* _tmp25_;
				ValadocGtkdocTokenType _tmp26_;
				_tmp25_ = self->priv->current;
				_tmp26_ = _tmp25_->type;
				if (_tmp26_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
				} else {
					GString* _tmp27_;
					ValadocGtkdocToken* _tmp28_;
					const gchar* _tmp29_;
					_tmp27_ = builder;
					_tmp28_ = self->priv->current;
					_tmp29_ = _tmp28_->content;
					g_string_append (_tmp27_, _tmp29_);
				}
			}
		}
		_tmp30_ = valadoc_gtkdoc_parser_next (self);
		_tmp31_ = _tmp30_;
		_valadoc_gtkdoc_token_unref0 (_tmp31_);
	}
	_tmp32_ = self->priv->factory;
	_tmp33_ = valadoc_content_content_factory_create_link (_tmp32_);
	link = _tmp33_;
	_tmp34_ = is_internal;
	if (_tmp34_) {
		ValadocContentLink* _tmp35_;
		ValadocImporterInternalIdRegistrar* _tmp36_;
		_tmp35_ = link;
		_tmp36_ = self->priv->id_registrar;
		valadoc_content_link_set_id_registrar (_tmp35_, _tmp36_);
	}
	_tmp37_ = link;
	_tmp38_ = url;
	valadoc_content_link_set_url (_tmp37_, _tmp38_);
	_tmp39_ = builder;
	_tmp40_ = _tmp39_->len;
	if (_tmp40_ == ((gssize) 0)) {
		ValadocContentLink* _tmp41_;
		ValaList* _tmp42_;
		ValaList* _tmp43_;
		ValadocContentContentFactory* _tmp44_;
		const gchar* _tmp45_;
		ValadocContentText* _tmp46_;
		ValadocContentText* _tmp47_;
		_tmp41_ = link;
		_tmp42_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = self->priv->factory;
		_tmp45_ = url;
		_tmp46_ = valadoc_content_content_factory_create_text (_tmp44_, _tmp45_);
		_tmp47_ = _tmp46_;
		vala_collection_add ((ValaCollection*) _tmp43_, (ValadocContentInline*) _tmp47_);
		_g_object_unref0 (_tmp47_);
	} else {
		ValadocContentLink* _tmp48_;
		ValaList* _tmp49_;
		ValaList* _tmp50_;
		ValadocContentContentFactory* _tmp51_;
		GString* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		ValadocContentText* _tmp56_;
		ValadocContentText* _tmp57_;
		_tmp48_ = link;
		_tmp49_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->factory;
		_tmp52_ = builder;
		_tmp53_ = _tmp52_->str;
		_tmp54_ = valadoc_gtkdoc_parser_normalize (self, _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = valadoc_content_content_factory_create_text (_tmp51_, _tmp55_);
		_tmp57_ = _tmp56_;
		vala_collection_add ((ValaCollection*) _tmp50_, (ValadocContentInline*) _tmp57_);
		_g_object_unref0 (_tmp57_);
		_g_free0 (_tmp55_);
	}
	_tmp58_ = tagname;
	_tmp59_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp58_);
	if (!_tmp59_) {
		ValadocGtkdocToken* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp60_ = self->priv->current;
		_tmp61_ = tagname;
		_tmp62_ = g_strdup_printf ("</%s>", _tmp61_);
		_tmp63_ = _tmp62_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp60_, _tmp63_);
		_g_free0 (_tmp63_);
		result = (ValadocContentInline*) link;
		_g_free0 (url);
		_g_string_free0 (builder);
		return result;
	}
	_tmp64_ = valadoc_gtkdoc_parser_next (self);
	_tmp65_ = _tmp64_;
	_valadoc_gtkdoc_token_unref0 (_tmp65_);
	result = (ValadocContentInline*) link;
	_g_free0 (url);
	_g_string_free0 (builder);
	return result;
}


static ValadocContentInlineTaglet* valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self, const gchar* tagname) {
	ValadocContentInlineTaglet* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocTokenType _tmp8_;
	gboolean _tmp9_;
	ValadocContentInlineTaglet* taglet = NULL;
	gboolean _tmp12_ = FALSE;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocTokenType _tmp14_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	ValadocGtkdocToken* _tmp30_;
	ValadocGtkdocTokenType _tmp31_;
	ValadocGtkdocToken* _tmp47_;
	ValadocGtkdocToken* _tmp48_;
	ValadocGtkdocTokenType _tmp49_;
	gboolean _tmp50_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	ValadocGtkdocToken* _tmp59_;
	ValadocGtkdocToken* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	_tmp0_ = tagname;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tagname;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->type;
	_tmp9_ = _tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	if (_tmp9_) {
		ValadocGtkdocToken* _tmp10_;
		ValadocGtkdocToken* _tmp11_;
		_tmp10_ = valadoc_gtkdoc_parser_next (self);
		_tmp11_ = _tmp10_;
		_valadoc_gtkdoc_token_unref0 (_tmp11_);
	}
	taglet = NULL;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->type;
	if (_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->content;
		_tmp12_ = g_strcmp0 (_tmp16_, "struct") == 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValadocGtkdocToken* _tmp17_;
		ValadocGtkdocToken* _tmp18_;
		ValadocGtkdocToken* _tmp19_;
		ValadocGtkdocToken* _tmp20_;
		ValadocGtkdocTokenType _tmp21_;
		gboolean _tmp22_;
		_tmp17_ = valadoc_gtkdoc_parser_next (self);
		_tmp18_ = _tmp17_;
		_valadoc_gtkdoc_token_unref0 (_tmp18_);
		_tmp19_ = valadoc_gtkdoc_parser_next (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_->type;
		_tmp22_ = _tmp21_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
		_valadoc_gtkdoc_token_unref0 (_tmp20_);
		if (_tmp22_) {
			ValadocGtkdocToken* _tmp23_;
			ValadocGtkdocToken* _tmp24_;
			_tmp23_ = valadoc_gtkdoc_parser_next (self);
			_tmp24_ = _tmp23_;
			_valadoc_gtkdoc_token_unref0 (_tmp24_);
		}
	}
	_tmp30_ = self->priv->current;
	_tmp31_ = _tmp30_->type;
	if (_tmp31_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
		_tmp29_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp32_;
		ValadocGtkdocTokenType _tmp33_;
		_tmp32_ = self->priv->current;
		_tmp33_ = _tmp32_->type;
		_tmp29_ = _tmp33_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp34_;
		ValadocGtkdocTokenType _tmp35_;
		_tmp34_ = self->priv->current;
		_tmp35_ = _tmp34_->type;
		_tmp28_ = _tmp35_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp36_;
		ValadocGtkdocTokenType _tmp37_;
		_tmp36_ = self->priv->current;
		_tmp37_ = _tmp36_->type;
		_tmp27_ = _tmp37_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp38_;
		ValadocGtkdocTokenType _tmp39_;
		_tmp38_ = self->priv->current;
		_tmp39_ = _tmp38_->type;
		_tmp26_ = _tmp39_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp40_;
		ValadocGtkdocTokenType _tmp41_;
		_tmp40_ = self->priv->current;
		_tmp41_ = _tmp40_->type;
		_tmp25_ = _tmp41_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL;
	}
	if (_tmp25_) {
		ValadocGtkdocToken* _tmp42_;
		const gchar* _tmp43_;
		ValadocContentInline* _tmp44_;
		ValadocContentInlineTaglet* _tmp45_;
		ValadocContentInlineTaglet* _tmp46_;
		_tmp42_ = self->priv->current;
		_tmp43_ = _tmp42_->content;
		_tmp44_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp43_, FALSE);
		_tmp45_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALADOC_CONTENT_TYPE_INLINE_TAGLET) ? ((ValadocContentInlineTaglet*) _tmp44_) : NULL;
		if (_tmp45_ == NULL) {
			_g_object_unref0 (_tmp44_);
		}
		_g_object_unref0 (taglet);
		taglet = _tmp45_;
		_tmp46_ = taglet;
		_vala_assert (_tmp46_ != NULL, "taglet != null");
	}
	_tmp47_ = valadoc_gtkdoc_parser_next (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _tmp48_->type;
	_tmp50_ = _tmp49_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp48_);
	if (_tmp50_) {
		ValadocGtkdocToken* _tmp51_;
		ValadocGtkdocToken* _tmp52_;
		_tmp51_ = valadoc_gtkdoc_parser_next (self);
		_tmp52_ = _tmp51_;
		_valadoc_gtkdoc_token_unref0 (_tmp52_);
	}
	_tmp53_ = tagname;
	_tmp54_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp53_);
	if (!_tmp54_) {
		ValadocGtkdocToken* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp55_ = self->priv->current;
		_tmp56_ = tagname;
		_tmp57_ = g_strdup_printf ("</%s>", _tmp56_);
		_tmp58_ = _tmp57_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp55_, _tmp58_);
		_g_free0 (_tmp58_);
		result = taglet;
		return result;
	}
	_tmp59_ = valadoc_gtkdoc_parser_next (self);
	_tmp60_ = _tmp59_;
	_valadoc_gtkdoc_token_unref0 (_tmp60_);
	result = taglet;
	return result;
}


static void valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self) {
	gboolean _tmp0_;
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp2_;
	ValaHashMap* _tmp3_;
	gpointer _tmp4_;
	const gchar* _tmp5_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	gboolean _tmp11_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "anchor");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<anchor>");
		return;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->attributes;
	_tmp4_ = vala_map_get ((ValaMap*) _tmp3_, "id");
	id = (gchar*) _tmp4_;
	_tmp5_ = id;
	if (_tmp5_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp6_;
		const gchar* _tmp7_;
		ValadocApiNode* _tmp8_;
		_tmp6_ = self->priv->id_registrar;
		_tmp7_ = id;
		_tmp8_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = valadoc_gtkdoc_parser_next (self);
	_tmp10_ = _tmp9_;
	_valadoc_gtkdoc_token_unref0 (_tmp10_);
	_tmp11_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "anchor");
	if (!_tmp11_) {
		ValadocGtkdocToken* _tmp12_;
		_tmp12_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp12_, "</anchor>");
		_g_free0 (id);
		return;
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	_g_free0 (id);
}


static ValadocContentLink* valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self) {
	ValadocContentLink* result = NULL;
	gboolean _tmp0_;
	gchar* linkend = NULL;
	ValadocGtkdocToken* _tmp2_;
	ValaHashMap* _tmp3_;
	gpointer _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp7_;
	ValadocContentLink* _tmp8_;
	ValadocContentLink* _tmp9_;
	ValaList* _tmp10_;
	ValaList* _tmp11_;
	ValadocContentContentFactory* _tmp12_;
	const gchar* _tmp13_;
	ValadocContentText* _tmp14_;
	ValadocContentText* _tmp15_;
	ValadocContentLink* _tmp16_;
	ValadocImporterInternalIdRegistrar* _tmp17_;
	ValadocContentLink* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	ValadocGtkdocToken* _tmp22_;
	ValadocGtkdocToken* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "xref");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<xref>");
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->attributes;
	_tmp4_ = vala_map_get ((ValaMap*) _tmp3_, "linkend");
	linkend = (gchar*) _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	_tmp7_ = self->priv->factory;
	_tmp8_ = valadoc_content_content_factory_create_link (_tmp7_);
	link = _tmp8_;
	_tmp9_ = link;
	_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->factory;
	_tmp13_ = linkend;
	_tmp14_ = valadoc_content_content_factory_create_text (_tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentInline*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = link;
	_tmp17_ = self->priv->id_registrar;
	valadoc_content_link_set_id_registrar (_tmp16_, _tmp17_);
	_tmp18_ = link;
	_tmp19_ = linkend;
	valadoc_content_link_set_url (_tmp18_, _tmp19_);
	_tmp20_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "xref");
	if (!_tmp20_) {
		ValadocGtkdocToken* _tmp21_;
		_tmp21_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp21_, "</xref>");
		result = link;
		_g_free0 (linkend);
		return result;
	}
	_tmp22_ = valadoc_gtkdoc_parser_next (self);
	_tmp23_ = _tmp22_;
	_valadoc_gtkdoc_token_unref0 (_tmp23_);
	result = link;
	_g_free0 (linkend);
	return result;
}


static ValadocContentRun* valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self, const gchar* tag_name, ValadocContentRunStyle style) {
	ValadocContentRun* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValadocContentRun* _tmp10_;
	ValadocContentRunStyle _tmp11_;
	ValadocContentRunStyle _tmp12_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	ValadocGtkdocToken* _tmp34_;
	ValadocGtkdocToken* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tag_name;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	_tmp8_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp8_;
	_tmp10_ = run;
	_tmp11_ = valadoc_content_run_get_style (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != VALADOC_CONTENT_RUN_STYLE_NONE) {
		ValadocContentRun* _tmp13_;
		ValadocContentRunStyle _tmp14_;
		ValadocContentRunStyle _tmp15_;
		ValadocContentRunStyle _tmp16_;
		_tmp13_ = run;
		_tmp14_ = valadoc_content_run_get_style (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = style;
		_tmp9_ = _tmp15_ != _tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValadocContentRun* tmp = NULL;
		ValadocContentContentFactory* _tmp17_;
		ValadocContentRunStyle _tmp18_;
		ValadocContentRun* _tmp19_;
		ValadocContentRun* _tmp20_;
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		ValadocContentRun* _tmp23_;
		ValadocContentRun* _tmp24_;
		ValadocContentRun* _tmp25_;
		_tmp17_ = self->priv->factory;
		_tmp18_ = style;
		_tmp19_ = valadoc_content_content_factory_create_run (_tmp17_, _tmp18_);
		tmp = _tmp19_;
		_tmp20_ = tmp;
		_tmp21_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = run;
		vala_collection_add ((ValaCollection*) _tmp22_, (ValadocContentInline*) _tmp23_);
		_tmp24_ = tmp;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (run);
		run = _tmp25_;
		_g_object_unref0 (tmp);
	} else {
		ValadocContentRun* _tmp26_;
		ValadocContentRunStyle _tmp27_;
		_tmp26_ = run;
		_tmp27_ = style;
		valadoc_content_run_set_style (_tmp26_, _tmp27_);
	}
	_tmp28_ = tag_name;
	_tmp29_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp28_);
	if (!_tmp29_) {
		ValadocGtkdocToken* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp30_ = self->priv->current;
		_tmp31_ = tag_name;
		_tmp32_ = g_strdup_printf ("</%s>", _tmp31_);
		_tmp33_ = _tmp32_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp30_, _tmp33_);
		_g_free0 (_tmp33_);
		result = run;
		return result;
	}
	_tmp34_ = valadoc_gtkdoc_parser_next (self);
	_tmp35_ = _tmp34_;
	_valadoc_gtkdoc_token_unref0 (_tmp35_);
	result = run;
	return result;
}


static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self) {
	ValadocContentListItem* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentListItem* _tmp5_;
	ValadocContentListItem* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	ValaCollection* _tmp9_;
	ValaCollection* _tmp10_;
	gboolean _tmp11_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "listitem");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<listitem>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_list_item (_tmp4_);
	item = _tmp5_;
	_tmp6_ = item;
	_tmp7_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp10_ = _tmp9_;
	vala_collection_add_all ((ValaCollection*) _tmp8_, _tmp10_);
	_vala_iterable_unref0 (_tmp10_);
	_tmp11_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "listitem");
	if (!_tmp11_) {
		ValadocGtkdocToken* _tmp12_;
		_tmp12_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp12_, "</listitem>");
		result = item;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	result = item;
	return result;
}


static ValadocContentBlockContent* valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self, const gchar* tagname, ValadocContentBlockContent* container) {
	ValadocContentBlockContent* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* tmp = NULL;
	const gchar* _tmp43_;
	gboolean _tmp44_;
	ValadocGtkdocToken* _tmp51_;
	ValadocGtkdocToken* _tmp52_;
	ValadocContentBlockContent* _tmp53_;
	ValadocContentBlockContent* _tmp54_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = tagname;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tagname;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	tmp = NULL;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		ValadocGtkdocToken* _tmp9_;
		ValadocGtkdocTokenType _tmp10_;
		ValadocGtkdocToken* _tmp13_;
		ValadocGtkdocToken* _tmp14_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp15_;
		gboolean _tmp16_ = FALSE;
		ValadocContentRun* _tmp17_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp33_;
		gboolean _tmp34_ = FALSE;
		ValaCollection* _tmp35_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->type;
		if (_tmp10_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp11_;
			ValadocGtkdocTokenType _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_->type;
			_tmp8_ = _tmp12_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp13_ = self->priv->current;
		_tmp14_ = _valadoc_gtkdoc_token_ref0 (_tmp13_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp14_;
		_tmp15_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp15_;
		_tmp17_ = ic;
		if (_tmp17_ != NULL) {
			ValadocContentRun* _tmp18_;
			ValaList* _tmp19_;
			ValaList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp18_ = ic;
			_tmp19_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ > 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp23_;
			ValadocContentParagraph* _tmp24_;
			ValadocContentParagraph* _tmp25_;
			ValaList* _tmp26_;
			ValaList* _tmp27_;
			ValadocContentRun* _tmp28_;
			ValadocContentBlockContent* _tmp29_;
			ValaList* _tmp30_;
			ValaList* _tmp31_;
			ValadocContentParagraph* _tmp32_;
			_tmp23_ = self->priv->factory;
			_tmp24_ = valadoc_content_content_factory_create_paragraph (_tmp23_);
			p = _tmp24_;
			_tmp25_ = p;
			_tmp26_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = ic;
			vala_collection_add ((ValaCollection*) _tmp27_, (ValadocContentInline*) _tmp28_);
			_tmp29_ = container;
			_tmp30_ = valadoc_content_block_content_get_content (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = p;
			vala_collection_add ((ValaCollection*) _tmp31_, (ValadocContentBlock*) _tmp32_);
			_g_object_unref0 (p);
		}
		_tmp33_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp33_;
		_tmp35_ = bc;
		if (_tmp35_ != NULL) {
			ValaCollection* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp36_ = bc;
			_tmp37_ = vala_collection_get_size (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp34_ = _tmp38_ > 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValadocContentBlockContent* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaCollection* _tmp42_;
			_tmp39_ = container;
			_tmp40_ = valadoc_content_block_content_get_content (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp41_, _tmp42_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp43_ = tagname;
	_tmp44_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp43_);
	if (!_tmp44_) {
		ValadocGtkdocToken* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		ValadocContentBlockContent* _tmp49_;
		ValadocContentBlockContent* _tmp50_;
		_tmp45_ = self->priv->current;
		_tmp46_ = tagname;
		_tmp47_ = g_strdup_printf ("</%s>", _tmp46_);
		_tmp48_ = _tmp47_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp45_, _tmp48_);
		_g_free0 (_tmp48_);
		_tmp49_ = container;
		_tmp50_ = _g_object_ref0 (_tmp49_);
		result = _tmp50_;
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp51_ = valadoc_gtkdoc_parser_next (self);
	_tmp52_ = _tmp51_;
	_valadoc_gtkdoc_token_unref0 (_tmp52_);
	_tmp53_ = container;
	_tmp54_ = _g_object_ref0 (_tmp53_);
	result = _tmp54_;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}


static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self) {
	ValadocContentNote* result = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "important", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self) {
	ValadocContentNote* result = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "note", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static ValadocContentWarning* valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self) {
	ValadocContentWarning* result = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentWarning* _tmp1_;
	ValadocContentWarning* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentWarning* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_warning (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "warning", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_WARNING, ValadocContentWarning);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	ValaCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "orderedlist", VALADOC_CONTENT_LIST_BULLET_ORDERED);
	result = _tmp0_;
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self, const gchar* tag_name, ValadocContentListBullet bullet_type) {
	ValaCollection* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	gboolean _tmp10_ = FALSE;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocTokenType _tmp12_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp18_;
	ValadocContentList* _tmp19_;
	ValadocContentList* _tmp20_;
	ValadocContentListBullet _tmp21_;
	ValaCollection* _tmp22_;
	ValadocContentList* _tmp23_;
	const gchar* _tmp33_;
	gboolean _tmp34_;
	ValadocGtkdocToken* _tmp39_;
	ValadocGtkdocToken* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tag_name;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp8_);
	content = (ValaCollection*) _tmp9_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->type;
	if (_tmp12_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = self->priv->current;
		_tmp14_ = _tmp13_->content;
		_tmp10_ = g_strcmp0 (_tmp14_, "title") == 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ValaCollection* _tmp15_;
		ValadocContentParagraph* _tmp16_;
		ValadocContentParagraph* _tmp17_;
		_tmp15_ = content;
		_tmp16_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp17_ = _tmp16_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp15_, (ValadocContentBlock*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp18_ = self->priv->factory;
	_tmp19_ = valadoc_content_content_factory_create_list (_tmp18_);
	list = _tmp19_;
	_tmp20_ = list;
	_tmp21_ = bullet_type;
	valadoc_content_list_set_bullet (_tmp20_, _tmp21_);
	_tmp22_ = content;
	_tmp23_ = list;
	vala_collection_add (_tmp22_, (ValadocContentBlock*) _tmp23_);
	while (TRUE) {
		ValadocGtkdocToken* _tmp24_;
		ValadocGtkdocTokenType _tmp25_;
		ValadocGtkdocToken* _tmp26_;
		const gchar* _tmp27_;
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_->type;
		if (!(_tmp25_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->content;
		if (g_strcmp0 (_tmp27_, "listitem") == 0) {
			ValadocContentList* _tmp28_;
			ValaList* _tmp29_;
			ValaList* _tmp30_;
			ValadocContentListItem* _tmp31_;
			ValadocContentListItem* _tmp32_;
			_tmp28_ = list;
			_tmp29_ = valadoc_content_list_get_items (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
			_tmp32_ = _tmp31_;
			vala_collection_add ((ValaCollection*) _tmp30_, _tmp32_);
			_g_object_unref0 (_tmp32_);
		} else {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp33_ = tag_name;
	_tmp34_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp33_);
	if (!_tmp34_) {
		ValadocGtkdocToken* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp35_ = self->priv->current;
		_tmp36_ = tag_name;
		_tmp37_ = g_strdup_printf ("</%s>", _tmp36_);
		_tmp38_ = _tmp37_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp35_, _tmp38_);
		_g_free0 (_tmp38_);
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp39_ = valadoc_gtkdoc_parser_next (self);
	_tmp40_ = _tmp39_;
	_valadoc_gtkdoc_token_unref0 (_tmp40_);
	result = content;
	_g_object_unref0 (list);
	return result;
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentRun* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
		ValadocGtkdocToken* _tmp2_;
		_tmp2_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, "<GTKDOC-PARAGRAPH>");
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_paragraph (_tmp5_);
	p = _tmp6_;
	_tmp7_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp7_;
	_tmp8_ = p;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = run;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp11_);
	result = p;
	_g_object_unref0 (run);
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocGtkdocToken* tmp = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	tmp = NULL;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocToken* _tmp3_;
		ValadocGtkdocToken* _tmp4_;
		ValadocGtkdocToken* _tmp5_;
		ValadocContentRun* run = NULL;
		ValadocContentRun* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValadocContentRun* _tmp8_;
		ValaCollection* lst = NULL;
		ValaCollection* _tmp22_;
		gboolean _tmp23_ = FALSE;
		ValaCollection* _tmp24_;
		_tmp2_ = tmp;
		_tmp3_ = self->priv->current;
		if (!(_tmp2_ != _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->current;
		_tmp5_ = _valadoc_gtkdoc_token_ref0 (_tmp4_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp5_;
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		run = _tmp6_;
		_tmp8_ = run;
		if (_tmp8_ != NULL) {
			ValadocContentRun* _tmp9_;
			ValaList* _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp9_ = run;
			_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = _tmp13_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp14_;
			ValadocContentParagraph* _tmp15_;
			ValadocContentParagraph* _tmp16_;
			ValaList* _tmp17_;
			ValaList* _tmp18_;
			ValadocContentRun* _tmp19_;
			ValaCollection* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			_tmp14_ = self->priv->factory;
			_tmp15_ = valadoc_content_content_factory_create_paragraph (_tmp14_);
			p = _tmp15_;
			_tmp16_ = p;
			_tmp17_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = run;
			vala_collection_add ((ValaCollection*) _tmp18_, (ValadocContentInline*) _tmp19_);
			_tmp20_ = content;
			_tmp21_ = p;
			vala_collection_add (_tmp20_, (ValadocContentBlock*) _tmp21_);
			_g_object_unref0 (p);
			_g_object_unref0 (run);
			continue;
		}
		_tmp22_ = valadoc_gtkdoc_parser_parse_block_content (self);
		lst = _tmp22_;
		_tmp24_ = lst;
		if (_tmp24_ != NULL) {
			ValaCollection* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp25_ = lst;
			_tmp26_ = vala_collection_get_size (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ > 0;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			ValaCollection* _tmp28_;
			ValaCollection* _tmp29_;
			_tmp28_ = content;
			_tmp29_ = lst;
			vala_collection_add_all (_tmp28_, _tmp29_);
			_vala_iterable_unref0 (lst);
			_g_object_unref0 (run);
			continue;
		}
		_vala_iterable_unref0 (lst);
		_g_object_unref0 (run);
	}
	result = content;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}


static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	ValaCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "simpara");
	result = _tmp0_;
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self, const gchar* tag_name) {
	ValaCollection* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tag_name;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	_tmp8_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp8_;
	_tmp10_ = tag_name;
	_tmp11_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp10_);
	if (!_tmp11_) {
		ValadocGtkdocToken* _tmp12_;
		ValadocGtkdocTokenType _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->type;
		_tmp9_ = _tmp13_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValadocGtkdocToken* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = self->priv->current;
		_tmp15_ = tag_name;
		_tmp16_ = g_strdup_printf ("</%s>", _tmp15_);
		_tmp17_ = _tmp16_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
		result = content;
		return result;
	}
	_tmp18_ = valadoc_gtkdoc_parser_next (self);
	_tmp19_ = _tmp18_;
	_valadoc_gtkdoc_token_unref0 (_tmp19_);
	result = content;
	return result;
}


static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self) {
	ValadocContentSourceCodeLanguage* dup;
	dup = g_new0 (ValadocContentSourceCodeLanguage, 1);
	memcpy (dup, self, sizeof (ValadocContentSourceCodeLanguage));
	return dup;
}


static gpointer __valadoc_content_source_code_language_dup0 (gpointer self) {
	return self ? _valadoc_content_source_code_language_dup (self) : NULL;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	GString* builder = NULL;
	GString* _tmp3_;
	ValadocGtkdocToken* source_token = NULL;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocContentSourceCode* code = NULL;
	ValadocContentContentFactory* _tmp28_;
	ValadocContentSourceCode* _tmp29_;
	GMatchInfo* info = NULL;
	const gchar* source = NULL;
	GString* _tmp30_;
	const gchar* _tmp31_;
	GRegex* _tmp32_;
	const gchar* _tmp33_;
	GMatchInfo* _tmp34_ = NULL;
	gboolean _tmp35_;
	ValadocContentSourceCode* _tmp59_;
	const gchar* _tmp60_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp61_;
	ValadocContentParagraph* _tmp62_;
	ValadocContentParagraph* _tmp63_;
	ValaList* _tmp64_;
	ValaList* _tmp65_;
	ValadocContentSourceCode* _tmp66_;
	ValadocGtkdocToken* _tmp67_;
	ValadocGtkdocTokenType _tmp68_;
	ValadocGtkdocToken* _tmp70_;
	ValadocGtkdocToken* _tmp71_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
		ValadocGtkdocToken* _tmp2_;
		_tmp2_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, "|[");
		result = NULL;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	_tmp4_ = self->priv->current;
	_tmp5_ = _valadoc_gtkdoc_token_ref0 (_tmp4_);
	source_token = _tmp5_;
	{
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocToken* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = valadoc_gtkdoc_parser_next (self);
		_tmp7_ = _tmp6_;
		_valadoc_gtkdoc_token_unref0 (_tmp7_);
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			ValadocGtkdocToken* _tmp12_;
			ValadocGtkdocTokenType _tmp13_;
			ValadocGtkdocToken* _tmp16_;
			ValadocGtkdocTokenType _tmp17_;
			if (!_tmp8_) {
				ValadocGtkdocToken* _tmp9_;
				ValadocGtkdocToken* _tmp10_;
				_tmp9_ = valadoc_gtkdoc_parser_next (self);
				_tmp10_ = _tmp9_;
				_valadoc_gtkdoc_token_unref0 (_tmp10_);
			}
			_tmp8_ = FALSE;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_->type;
			if (_tmp13_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				ValadocGtkdocToken* _tmp14_;
				ValadocGtkdocTokenType _tmp15_;
				_tmp14_ = self->priv->current;
				_tmp15_ = _tmp14_->type;
				_tmp11_ = _tmp15_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_->type;
			if (_tmp17_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp18_;
				ValadocGtkdocToken* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = builder;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_->content;
				g_string_append (_tmp18_, _tmp20_);
			} else {
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp23_;
					ValadocGtkdocToken* _tmp24_;
					const gchar* _tmp25_;
					ValadocGtkdocToken* _tmp26_;
					gint _tmp27_;
					_tmp23_ = builder;
					_tmp24_ = self->priv->current;
					_tmp25_ = _tmp24_->start;
					_tmp26_ = self->priv->current;
					_tmp27_ = _tmp26_->length;
					g_string_append_len (_tmp23_, _tmp25_, (gssize) _tmp27_);
				}
			}
		}
	}
	_tmp28_ = self->priv->factory;
	_tmp29_ = valadoc_content_content_factory_create_source_code (_tmp28_);
	code = _tmp29_;
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	source = _tmp31_;
	_tmp32_ = self->priv->regex_source_lang;
	_tmp33_ = source;
	_tmp35_ = g_regex_match (_tmp32_, _tmp33_, 0, &_tmp34_);
	_g_match_info_unref0 (info);
	info = _tmp34_;
	if (_tmp35_) {
		gchar* lang_name = NULL;
		GMatchInfo* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		ValadocContentSourceCodeLanguage* lang = NULL;
		const gchar* _tmp41_;
		ValadocContentSourceCodeLanguage _tmp42_;
		ValadocContentSourceCodeLanguage* _tmp43_;
		ValadocContentSourceCode* _tmp44_;
		ValadocContentSourceCodeLanguage* _tmp45_;
		ValadocContentSourceCodeLanguage* _tmp46_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gint _tmp53_;
		const gchar* _tmp54_;
		_tmp36_ = info;
		_tmp37_ = g_match_info_fetch (_tmp36_, 1);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_utf8_strdown (_tmp38_, (gssize) -1);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		lang_name = _tmp40_;
		_tmp41_ = lang_name;
		_tmp42_ = valadoc_content_source_code_language_from_string (_tmp41_, FALSE);
		_tmp43_ = __valadoc_content_source_code_language_dup0 (&_tmp42_);
		lang = _tmp43_;
		_tmp44_ = code;
		_tmp45_ = lang;
		valadoc_content_source_code_set_language (_tmp44_, *_tmp45_);
		_tmp46_ = lang;
		if (_tmp46_ == NULL) {
			ValadocGtkdocToken* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = source_token;
			_tmp48_ = lang_name;
			_tmp49_ = g_strdup_printf ("Unknown language `%s' in source code block |[<!-- language=\"\"", _tmp48_);
			_tmp50_ = _tmp49_;
			valadoc_gtkdoc_parser_report_warning (self, _tmp47_, _tmp50_);
			_g_free0 (_tmp50_);
		}
		_tmp51_ = source;
		_tmp52_ = source;
		_tmp53_ = string_index_of_char (_tmp52_, (gunichar) '>', 0);
		_tmp54_ = string_offset (_tmp51_, (glong) (_tmp53_ + 1));
		source = _tmp54_;
		_g_free0 (lang);
		_g_free0 (lang_name);
	} else {
		ValadocContentSourceCodeLanguage _tmp55_ = 0;
		const gchar* _tmp56_;
		gboolean _tmp57_;
		ValadocContentSourceCode* _tmp58_;
		_tmp56_ = source;
		_tmp57_ = valadoc_highlighter_xml_scanner_is_xml (_tmp56_);
		if (_tmp57_) {
			_tmp55_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
		} else {
			_tmp55_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
		}
		_tmp58_ = code;
		valadoc_content_source_code_set_language (_tmp58_, _tmp55_);
	}
	_tmp59_ = code;
	_tmp60_ = source;
	valadoc_content_source_code_set_code (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->factory;
	_tmp62_ = valadoc_content_content_factory_create_paragraph (_tmp61_);
	p = _tmp62_;
	_tmp63_ = p;
	_tmp64_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = code;
	vala_collection_add ((ValaCollection*) _tmp65_, (ValadocContentInline*) _tmp66_);
	_tmp67_ = self->priv->current;
	_tmp68_ = _tmp67_->type;
	if (_tmp68_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE) {
		ValadocGtkdocToken* _tmp69_;
		_tmp69_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp69_, "|]");
		result = p;
		_g_match_info_unref0 (info);
		_g_object_unref0 (code);
		_valadoc_gtkdoc_token_unref0 (source_token);
		_g_string_free0 (builder);
		return result;
	}
	_tmp70_ = valadoc_gtkdoc_parser_next (self);
	_tmp71_ = _tmp70_;
	_valadoc_gtkdoc_token_unref0 (_tmp71_);
	result = p;
	_g_match_info_unref0 (info);
	_g_object_unref0 (code);
	_valadoc_gtkdoc_token_unref0 (source_token);
	_g_string_free0 (builder);
	return result;
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentParagraph* _tmp5_;
	ValadocContentRun* content = NULL;
	ValadocContentRun* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentContentFactory* _tmp10_;
	ValadocContentText* _tmp11_;
	ValadocContentText* _tmp12_;
	ValadocContentRun* _tmp13_;
	ValadocContentParagraph* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValadocContentRun* _tmp17_;
	gboolean _tmp18_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "title");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<title>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_paragraph (_tmp4_);
	p = _tmp5_;
	_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	content = _tmp6_;
	_tmp7_ = content;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->factory;
	_tmp11_ = valadoc_content_content_factory_create_text (_tmp10_, ":");
	_tmp12_ = _tmp11_;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = content;
	valadoc_content_run_set_style (_tmp13_, VALADOC_CONTENT_RUN_STYLE_BOLD);
	_tmp14_ = p;
	_tmp15_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = content;
	vala_collection_add ((ValaCollection*) _tmp16_, (ValadocContentInline*) _tmp17_);
	_tmp18_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "title");
	if (!_tmp18_) {
		ValadocGtkdocToken* _tmp19_;
		_tmp19_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, "</title>");
		result = p;
		_g_object_unref0 (content);
		return result;
	}
	_tmp20_ = valadoc_gtkdoc_parser_next (self);
	_tmp21_ = _tmp20_;
	_valadoc_gtkdoc_token_unref0 (_tmp21_);
	result = p;
	_g_object_unref0 (content);
	return result;
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	ValadocContentEmbedded* tmp = NULL;
	ValadocContentEmbedded* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentParagraph* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentEmbedded* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "graphic");
	tmp = _tmp0_;
	_tmp1_ = tmp;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (tmp);
		return result;
	}
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_paragraph (_tmp2_);
	p = _tmp3_;
	_tmp4_ = p;
	_tmp5_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = tmp;
	vala_collection_add ((ValaCollection*) _tmp6_, (ValadocContentInline*) _tmp7_);
	result = p;
	_g_object_unref0 (tmp);
	return result;
}


static ValadocContentEmbedded* valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self, const gchar* tag_name) {
	ValadocContentEmbedded* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocContentEmbedded* e = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentEmbedded* _tmp7_;
	ValadocContentEmbedded* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValaHashMap* _tmp10_;
	gpointer _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	ValadocGtkdocToken* _tmp23_;
	ValadocGtkdocToken* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tag_name;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_embedded (_tmp6_);
	e = _tmp7_;
	_tmp8_ = e;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->attributes;
	_tmp11_ = vala_map_get ((ValaMap*) _tmp10_, "fileref");
	_tmp12_ = (gchar*) _tmp11_;
	_tmp13_ = valadoc_gtkdoc_parser_fix_resource_path (self, _tmp12_);
	_tmp14_ = _tmp13_;
	valadoc_content_embedded_set_url (_tmp8_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp15_ = valadoc_gtkdoc_parser_next (self);
	_tmp16_ = _tmp15_;
	_valadoc_gtkdoc_token_unref0 (_tmp16_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp17_ = tag_name;
	_tmp18_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp17_);
	if (!_tmp18_) {
		ValadocGtkdocToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = self->priv->current;
		_tmp20_ = tag_name;
		_tmp21_ = g_strdup_printf ("</%s>", _tmp20_);
		_tmp22_ = _tmp21_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, _tmp22_);
		_g_free0 (_tmp22_);
		result = e;
		return result;
	}
	_tmp23_ = valadoc_gtkdoc_parser_next (self);
	_tmp24_ = _tmp23_;
	_valadoc_gtkdoc_token_unref0 (_tmp24_);
	result = e;
	return result;
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	gboolean _tmp0_;
	GString* builder = NULL;
	GString* _tmp2_;
	ValadocContentSourceCode* src = NULL;
	ValadocContentContentFactory* _tmp28_;
	ValadocContentSourceCode* _tmp29_;
	ValadocContentSourceCode* _tmp30_;
	ValadocContentSourceCode* _tmp31_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp34_;
	ValadocContentParagraph* _tmp35_;
	ValadocContentParagraph* _tmp36_;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValadocContentSourceCode* _tmp39_;
	gboolean _tmp40_;
	ValadocGtkdocToken* _tmp42_;
	ValadocGtkdocToken* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "programlisting");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<programlisting>");
		result = NULL;
		return result;
	}
	_tmp2_ = g_string_new ("");
	builder = _tmp2_;
	{
		ValadocGtkdocToken* _tmp3_;
		ValadocGtkdocToken* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = valadoc_gtkdoc_parser_next (self);
		_tmp4_ = _tmp3_;
		_valadoc_gtkdoc_token_unref0 (_tmp4_);
		_tmp5_ = TRUE;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			ValadocGtkdocToken* _tmp9_;
			ValadocGtkdocTokenType _tmp10_;
			ValadocGtkdocToken* _tmp16_;
			ValadocGtkdocTokenType _tmp17_;
			if (!_tmp5_) {
				ValadocGtkdocToken* _tmp6_;
				ValadocGtkdocToken* _tmp7_;
				_tmp6_ = valadoc_gtkdoc_parser_next (self);
				_tmp7_ = _tmp6_;
				_valadoc_gtkdoc_token_unref0 (_tmp7_);
			}
			_tmp5_ = FALSE;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->type;
			if (_tmp10_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				gboolean _tmp11_ = FALSE;
				ValadocGtkdocToken* _tmp12_;
				ValadocGtkdocTokenType _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_->type;
				if (_tmp13_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
					ValadocGtkdocToken* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = self->priv->current;
					_tmp15_ = _tmp14_->content;
					_tmp11_ = g_strcmp0 (_tmp15_, "programlisting") == 0;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp8_ = !_tmp11_;
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_->type;
			if (_tmp17_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp18_;
				ValadocGtkdocToken* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = builder;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_->content;
				g_string_append (_tmp18_, _tmp20_);
			} else {
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp23_;
					ValadocGtkdocToken* _tmp24_;
					const gchar* _tmp25_;
					ValadocGtkdocToken* _tmp26_;
					gint _tmp27_;
					_tmp23_ = builder;
					_tmp24_ = self->priv->current;
					_tmp25_ = _tmp24_->start;
					_tmp26_ = self->priv->current;
					_tmp27_ = _tmp26_->length;
					g_string_append_len (_tmp23_, _tmp25_, (gssize) _tmp27_);
				}
			}
		}
	}
	_tmp28_ = self->priv->factory;
	_tmp29_ = valadoc_content_content_factory_create_source_code (_tmp28_);
	src = _tmp29_;
	_tmp30_ = src;
	valadoc_content_source_code_set_language (_tmp30_, VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C);
	_tmp31_ = src;
	_tmp32_ = builder;
	_tmp33_ = _tmp32_->str;
	valadoc_content_source_code_set_code (_tmp31_, _tmp33_);
	_tmp34_ = self->priv->factory;
	_tmp35_ = valadoc_content_content_factory_create_paragraph (_tmp34_);
	p = _tmp35_;
	_tmp36_ = p;
	_tmp37_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = src;
	vala_collection_add ((ValaCollection*) _tmp38_, (ValadocContentInline*) _tmp39_);
	_tmp40_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "programlisting");
	if (!_tmp40_) {
		ValadocGtkdocToken* _tmp41_;
		_tmp41_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp41_, "</programlisting>");
		result = p;
		_g_object_unref0 (src);
		_g_string_free0 (builder);
		return result;
	}
	_tmp42_ = valadoc_gtkdoc_parser_next (self);
	_tmp43_ = _tmp42_;
	_valadoc_gtkdoc_token_unref0 (_tmp43_);
	result = p;
	_g_object_unref0 (src);
	_g_string_free0 (builder);
	return result;
}


static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	ValaCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "informalexample");
	result = _tmp0_;
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self, const gchar* tag_name) {
	ValaCollection* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	ValaCollection* _tmp10_;
	ValaCollection* _tmp11_;
	ValaCollection* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	_tmp0_ = tag_name;
	_tmp1_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp0_);
	if (!_tmp1_) {
		ValadocGtkdocToken* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->current;
		_tmp3_ = tag_name;
		_tmp4_ = g_strdup_printf ("<%s>", _tmp3_);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = valadoc_gtkdoc_parser_next (self);
	_tmp7_ = _tmp6_;
	_valadoc_gtkdoc_token_unref0 (_tmp7_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp8_);
	content = (ValaCollection*) _tmp9_;
	_tmp10_ = content;
	_tmp11_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp12_ = _tmp11_;
	vala_collection_add_all (_tmp10_, _tmp12_);
	_vala_iterable_unref0 (_tmp12_);
	_tmp13_ = tag_name;
	_tmp14_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp13_);
	if (!_tmp14_) {
		ValadocGtkdocToken* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = self->priv->current;
		_tmp16_ = tag_name;
		_tmp17_ = g_strdup_printf ("</%s>", _tmp16_);
		_tmp18_ = _tmp17_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp15_, _tmp18_);
		_g_free0 (_tmp18_);
		result = content;
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_parser_next (self);
	_tmp20_ = _tmp19_;
	_valadoc_gtkdoc_token_unref0 (_tmp20_);
	result = content;
	return result;
}


static ValaList* valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self, gint nr) {
	ValaList* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp9_;
	ValaHashMap* _tmp10_;
	gpointer _tmp11_;
	const gchar* _tmp12_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValaList* content = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	ValaList* _tmp20_;
	ValaCollection* _tmp21_;
	ValaCollection* _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ValadocGtkdocToken* _tmp32_;
	ValadocGtkdocToken* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = nr;
	_tmp1_ = g_strdup_printf ("refsect%d", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_free0 (_tmp2_);
	if (_tmp4_) {
		ValadocGtkdocToken* _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = self->priv->current;
		_tmp6_ = nr;
		_tmp7_ = g_strdup_printf ("<refsect%d>", _tmp6_);
		_tmp8_ = _tmp7_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		result = NULL;
		return result;
	}
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->attributes;
	_tmp11_ = vala_map_get ((ValaMap*) _tmp10_, "id");
	id = (gchar*) _tmp11_;
	_tmp12_ = id;
	if (_tmp12_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp13_;
		const gchar* _tmp14_;
		ValadocApiNode* _tmp15_;
		_tmp13_ = self->priv->id_registrar;
		_tmp14_ = id;
		_tmp15_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp13_, _tmp14_, _tmp15_);
	}
	_tmp16_ = valadoc_gtkdoc_parser_next (self);
	_tmp17_ = _tmp16_;
	_valadoc_gtkdoc_token_unref0 (_tmp17_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp18_);
	content = (ValaList*) _tmp19_;
	_tmp20_ = content;
	_tmp21_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp22_ = _tmp21_;
	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, (ValaCollection*) _tmp20_, _tmp22_);
	_vala_iterable_unref0 (_tmp22_);
	_tmp23_ = nr;
	_tmp24_ = g_strdup_printf ("refsect%d", _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp25_);
	_tmp27_ = !_tmp26_;
	_g_free0 (_tmp25_);
	if (_tmp27_) {
		ValadocGtkdocToken* _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp28_ = self->priv->current;
		_tmp29_ = nr;
		_tmp30_ = g_strdup_printf ("</refsect%d>", _tmp29_);
		_tmp31_ = _tmp30_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp32_ = valadoc_gtkdoc_parser_next (self);
	_tmp33_ = _tmp32_;
	_valadoc_gtkdoc_token_unref0 (_tmp33_);
	result = content;
	_g_free0 (id);
	return result;
}


static ValaList* valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self) {
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValaList* content = NULL;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocTokenType _tmp8_;
	gboolean _tmp45_;
	ValadocGtkdocToken* _tmp47_;
	ValadocGtkdocToken* _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "figure");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<figure>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_);
	content = (ValaList*) _tmp5_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp7_ = self->priv->current;
	_tmp8_ = _tmp7_->type;
	if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->content;
		_tmp6_ = g_strcmp0 (_tmp10_, "title") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaList* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		_tmp11_ = content;
		_tmp12_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp13_ = _tmp12_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp11_, (ValadocContentBlock*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	while (TRUE) {
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocTokenType _tmp15_;
		ValadocGtkdocToken* _tmp16_;
		const gchar* _tmp17_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_->type;
		if (!(_tmp15_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp16_ = self->priv->current;
		_tmp17_ = _tmp16_->content;
		if (g_strcmp0 (_tmp17_, "inlinegraphic") == 0) {
			ValadocContentParagraph* _tmp18_ = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			ValadocContentParagraph* p = NULL;
			ValadocContentParagraph* _tmp26_;
			ValadocContentParagraph* _tmp27_;
			_tmp19_ = content;
			_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_ > 0) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValadocContentBlock* _tmp24_;
				ValadocContentParagraph* _tmp25_;
				_tmp22_ = content;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValadocContentBlock*) _tmp23_;
				_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALADOC_CONTENT_TYPE_PARAGRAPH) ? ((ValadocContentParagraph*) _tmp24_) : NULL;
				if (_tmp25_ == NULL) {
					_g_object_unref0 (_tmp24_);
				}
				_g_object_unref0 (_tmp18_);
				_tmp18_ = _tmp25_;
			} else {
				_g_object_unref0 (_tmp18_);
				_tmp18_ = NULL;
			}
			_tmp26_ = _g_object_ref0 (_tmp18_);
			p = _tmp26_;
			_tmp27_ = p;
			if (_tmp27_ == NULL) {
				ValadocContentContentFactory* _tmp28_;
				ValadocContentParagraph* _tmp29_;
				_tmp28_ = self->priv->factory;
				_tmp29_ = valadoc_content_content_factory_create_paragraph (_tmp28_);
				_g_object_unref0 (p);
				p = _tmp29_;
			}
			while (TRUE) {
				gboolean _tmp30_ = FALSE;
				ValadocGtkdocToken* _tmp31_;
				ValadocGtkdocTokenType _tmp32_;
				ValadocContentParagraph* _tmp35_;
				ValaList* _tmp36_;
				ValaList* _tmp37_;
				ValadocContentEmbedded* _tmp38_;
				ValadocContentEmbedded* _tmp39_;
				_tmp31_ = self->priv->current;
				_tmp32_ = _tmp31_->type;
				if (_tmp32_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp33_;
					const gchar* _tmp34_;
					_tmp33_ = self->priv->current;
					_tmp34_ = _tmp33_->content;
					_tmp30_ = g_strcmp0 (_tmp34_, "inlinegraphic") == 0;
				} else {
					_tmp30_ = FALSE;
				}
				if (!_tmp30_) {
					break;
				}
				_tmp35_ = p;
				_tmp36_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
				_tmp39_ = _tmp38_;
				vala_collection_add ((ValaCollection*) _tmp37_, (ValadocContentInline*) _tmp39_);
				_g_object_unref0 (_tmp39_);
				valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			}
			_g_object_unref0 (p);
			_g_object_unref0 (_tmp18_);
		} else {
			ValadocGtkdocToken* _tmp40_;
			const gchar* _tmp41_;
			_tmp40_ = self->priv->current;
			_tmp41_ = _tmp40_->content;
			if (g_strcmp0 (_tmp41_, "graphic") == 0) {
				ValaList* _tmp42_;
				ValadocContentParagraph* _tmp43_;
				ValadocContentParagraph* _tmp44_;
				_tmp42_ = content;
				_tmp43_ = valadoc_gtkdoc_parser_parse_docbook_graphic (self);
				_tmp44_ = _tmp43_;
				valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp42_, (ValadocContentBlock*) _tmp44_);
				_g_object_unref0 (_tmp44_);
			} else {
				break;
			}
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp45_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "figure");
	if (!_tmp45_) {
		ValadocGtkdocToken* _tmp46_;
		_tmp46_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp46_, "</figure>");
		result = content;
		return result;
	}
	_tmp47_ = valadoc_gtkdoc_parser_next (self);
	_tmp48_ = _tmp47_;
	_valadoc_gtkdoc_token_unref0 (_tmp48_);
	result = content;
	return result;
}


static ValadocContentRun* valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self) {
	ValadocContentRun* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	gint counter = 0;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValadocContentRun* nr = NULL;
	ValadocContentContentFactory* _tmp7_;
	ValadocContentRun* _tmp8_;
	ValadocContentRun* _tmp9_;
	ValaList* _tmp10_;
	ValaList* _tmp11_;
	ValadocContentContentFactory* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValadocContentText* _tmp16_;
	ValadocContentText* _tmp17_;
	ValaList* content = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	ValaList* _tmp20_;
	ValaList* _tmp21_;
	ValaList* _tmp22_;
	ValaCollection* _tmp23_;
	ValaCollection* _tmp24_;
	ValadocContentParagraph* _tmp25_ = NULL;
	ValaList* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	ValadocContentParagraph* first = NULL;
	ValadocContentParagraph* _tmp33_;
	ValadocContentParagraph* _tmp34_;
	ValadocContentRun* entry = NULL;
	ValadocContentContentFactory* _tmp39_;
	ValadocContentRun* _tmp40_;
	ValadocContentRun* _tmp41_;
	ValaList* _tmp42_;
	ValaList* _tmp43_;
	ValadocContentContentFactory* _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	ValadocContentText* _tmp50_;
	ValadocContentText* _tmp51_;
	ValadocContentParagraph* _tmp52_;
	ValaList* _tmp53_;
	ValaList* _tmp54_;
	ValadocContentRun* _tmp55_;
	gboolean _tmp56_;
	ValadocGtkdocToken* _tmp58_;
	ValadocGtkdocToken* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "footnote");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<footnote>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->footnotes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	counter = _tmp6_ + 1;
	_tmp7_ = self->priv->factory;
	_tmp8_ = valadoc_content_content_factory_create_run (_tmp7_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	nr = _tmp8_;
	_tmp9_ = nr;
	_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->factory;
	_tmp13_ = counter;
	_tmp14_ = g_strdup_printf ("[%d] ", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = valadoc_content_content_factory_create_text (_tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentInline*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp18_);
	content = (ValaList*) _tmp19_;
	_tmp20_ = self->priv->footnotes;
	_tmp21_ = content;
	vala_collection_add ((ValaCollection*) _tmp20_, _tmp21_);
	_tmp22_ = content;
	_tmp23_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp24_ = _tmp23_;
	vala_collection_add_all ((ValaCollection*) _tmp22_, _tmp24_);
	_vala_iterable_unref0 (_tmp24_);
	_tmp26_ = content;
	_tmp27_ = vala_collection_get_is_empty ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		_g_object_unref0 (_tmp25_);
		_tmp25_ = NULL;
	} else {
		ValaList* _tmp29_;
		gpointer _tmp30_;
		ValadocContentBlock* _tmp31_;
		ValadocContentParagraph* _tmp32_;
		_tmp29_ = content;
		_tmp30_ = vala_list_first (_tmp29_);
		_tmp31_ = (ValadocContentBlock*) _tmp30_;
		_tmp32_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALADOC_CONTENT_TYPE_PARAGRAPH) ? ((ValadocContentParagraph*) _tmp31_) : NULL;
		if (_tmp32_ == NULL) {
			_g_object_unref0 (_tmp31_);
		}
		_g_object_unref0 (_tmp25_);
		_tmp25_ = _tmp32_;
	}
	_tmp33_ = _g_object_ref0 (_tmp25_);
	first = _tmp33_;
	_tmp34_ = first;
	if (_tmp34_ == NULL) {
		ValadocContentContentFactory* _tmp35_;
		ValadocContentParagraph* _tmp36_;
		ValaList* _tmp37_;
		ValadocContentParagraph* _tmp38_;
		_tmp35_ = self->priv->factory;
		_tmp36_ = valadoc_content_content_factory_create_paragraph (_tmp35_);
		_g_object_unref0 (first);
		first = _tmp36_;
		_tmp37_ = content;
		_tmp38_ = first;
		vala_list_insert (_tmp37_, 0, (ValadocContentBlock*) _tmp38_);
	}
	_tmp39_ = self->priv->factory;
	_tmp40_ = valadoc_content_content_factory_create_run (_tmp39_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	entry = _tmp40_;
	_tmp41_ = entry;
	_tmp42_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = self->priv->factory;
	_tmp45_ = counter;
	_tmp46_ = g_strdup_printf ("%i", _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strconcat (_tmp47_, ": ", NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = valadoc_content_content_factory_create_text (_tmp44_, _tmp49_);
	_tmp51_ = _tmp50_;
	vala_collection_add ((ValaCollection*) _tmp43_, (ValadocContentInline*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	_g_free0 (_tmp49_);
	_g_free0 (_tmp47_);
	_tmp52_ = first;
	_tmp53_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = entry;
	vala_list_insert (_tmp54_, 0, (ValadocContentInline*) _tmp55_);
	_tmp56_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "footnote");
	if (!_tmp56_) {
		ValadocGtkdocToken* _tmp57_;
		_tmp57_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp57_, "</footnote>");
		result = nr;
		_g_object_unref0 (entry);
		_g_object_unref0 (first);
		_g_object_unref0 (_tmp25_);
		_vala_iterable_unref0 (content);
		return result;
	}
	_tmp58_ = valadoc_gtkdoc_parser_next (self);
	_tmp59_ = _tmp58_;
	_valadoc_gtkdoc_token_unref0 (_tmp59_);
	result = nr;
	_g_object_unref0 (entry);
	_g_object_unref0 (first);
	_g_object_unref0 (_tmp25_);
	_vala_iterable_unref0 (content);
	return result;
}


static inline void valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self, ValaCollection* run, ValaCollection* elements) {
	ValaCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	_tmp0_ = elements;
	if (_tmp0_ != NULL) {
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		_tmp1_ = run;
		_tmp2_ = elements;
		vala_collection_add_all (_tmp1_, _tmp2_);
	}
}


static inline void valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self, ValaCollection* run, ValadocContentBlock* element) {
	ValadocContentBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	_tmp0_ = element;
	if (_tmp0_ != NULL) {
		ValaCollection* _tmp1_;
		ValadocContentBlock* _tmp2_;
		_tmp1_ = run;
		_tmp2_ = element;
		vala_collection_add (_tmp1_, _tmp2_);
	}
}


static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self) {
	ValadocContentTableRow* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentTableRow* row = NULL;
	ValadocContentTableRow* _tmp4_;
	gboolean _tmp5_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "thead");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<thead>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_BOLD);
	row = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp5_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "thead");
	if (!_tmp5_) {
		ValadocGtkdocToken* _tmp6_;
		_tmp6_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp6_, "</thead>");
		result = row;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_parser_next (self);
	_tmp8_ = _tmp7_;
	_valadoc_gtkdoc_token_unref0 (_tmp8_);
	result = row;
	return result;
}


static ValadocContentTableCell* valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self, ValadocContentRunStyle default_style) {
	ValadocContentTableCell* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentTableCell* cell = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentTableCell* _tmp5_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentRunStyle _tmp7_;
	ValadocContentRun* _tmp8_;
	ValadocContentRun* _tmp9_;
	ValaList* _tmp10_;
	ValaList* _tmp11_;
	ValadocContentRun* _tmp12_;
	ValadocContentRun* _tmp13_;
	ValadocContentTableCell* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValadocContentRun* _tmp17_;
	gboolean _tmp18_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "entry");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<entry>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_table_cell (_tmp4_);
	cell = _tmp5_;
	_tmp6_ = self->priv->factory;
	_tmp7_ = default_style;
	_tmp8_ = valadoc_content_content_factory_create_run (_tmp6_, _tmp7_);
	run = _tmp8_;
	_tmp9_ = run;
	_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp13_ = _tmp12_;
	vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentInline*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = cell;
	_tmp15_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = run;
	vala_collection_add ((ValaCollection*) _tmp16_, (ValadocContentInline*) _tmp17_);
	_tmp18_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "entry");
	if (!_tmp18_) {
		ValadocGtkdocToken* _tmp19_;
		_tmp19_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, "</entry>");
		result = cell;
		_g_object_unref0 (run);
		return result;
	}
	_tmp20_ = valadoc_gtkdoc_parser_next (self);
	_tmp21_ = _tmp20_;
	_valadoc_gtkdoc_token_unref0 (_tmp21_);
	result = cell;
	_g_object_unref0 (run);
	return result;
}


static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self, ValadocContentRunStyle default_style) {
	ValadocContentTableRow* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentTableRow* row = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentTableRow* _tmp5_;
	gboolean _tmp18_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "row");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<row>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_table_row (_tmp4_);
	row = _tmp5_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		ValadocContentTableCell* table_cell = NULL;
		ValadocContentRunStyle _tmp11_;
		ValadocContentTableCell* _tmp12_;
		ValadocContentTableCell* _tmp13_;
		ValadocContentTableRow* _tmp14_;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		ValadocContentTableCell* _tmp17_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->content;
			_tmp6_ = g_strcmp0 (_tmp10_, "entry") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp11_ = default_style;
		_tmp12_ = valadoc_gtkdoc_parser_parse_docbook_entry (self, _tmp11_);
		table_cell = _tmp12_;
		_tmp13_ = table_cell;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (table_cell);
			break;
		}
		_tmp14_ = row;
		_tmp15_ = valadoc_content_table_row_get_cells (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = table_cell;
		vala_collection_add ((ValaCollection*) _tmp16_, _tmp17_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (table_cell);
	}
	_tmp18_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "row");
	if (!_tmp18_) {
		ValadocGtkdocToken* _tmp19_;
		_tmp19_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, "</row>");
		result = row;
		return result;
	}
	_tmp20_ = valadoc_gtkdoc_parser_next (self);
	_tmp21_ = _tmp20_;
	_valadoc_gtkdoc_token_unref0 (_tmp21_);
	result = row;
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValaCollection* rows = NULL;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	gboolean _tmp15_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "tbody");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<tbody>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALADOC_CONTENT_TYPE_TABLE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_);
	rows = (ValaCollection*) _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp11_;
		ValadocContentTableRow* _tmp12_;
		ValaCollection* _tmp13_;
		ValadocContentTableRow* _tmp14_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->content;
			_tmp6_ = g_strcmp0 (_tmp10_, "row") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_NONE);
		row = _tmp11_;
		_tmp12_ = row;
		if (_tmp12_ == NULL) {
			_g_object_unref0 (row);
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp13_ = rows;
		_tmp14_ = row;
		vala_collection_add (_tmp13_, _tmp14_);
		_g_object_unref0 (row);
	}
	_tmp15_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "tbody");
	if (!_tmp15_) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</tbody>");
		result = rows;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = rows;
	return result;
}


static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self) {
	ValadocContentTable* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentTable* table = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentTable* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocTokenType _tmp8_;
	gboolean _tmp17_ = FALSE;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocTokenType _tmp19_;
	gboolean _tmp28_;
	ValadocGtkdocToken* _tmp30_;
	ValadocGtkdocToken* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "tgroup");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<tgroup>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_table (_tmp4_);
	table = _tmp5_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp7_ = self->priv->current;
	_tmp8_ = _tmp7_->type;
	if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->content;
		_tmp6_ = g_strcmp0 (_tmp10_, "thead") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp11_;
		ValadocContentTableRow* _tmp12_;
		_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_thead (self);
		row = _tmp11_;
		_tmp12_ = row;
		if (_tmp12_ != NULL) {
			ValadocContentTable* _tmp13_;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			ValadocContentTableRow* _tmp16_;
			valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			_tmp13_ = table;
			_tmp14_ = valadoc_content_table_get_rows (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = row;
			vala_collection_add ((ValaCollection*) _tmp15_, _tmp16_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (row);
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = _tmp18_->type;
	if (_tmp19_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->content;
		_tmp17_ = g_strcmp0 (_tmp21_, "tbody") == 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaCollection* rows = NULL;
		ValaCollection* _tmp22_;
		ValaCollection* _tmp23_;
		_tmp22_ = valadoc_gtkdoc_parser_parse_docbook_tbody (self);
		rows = _tmp22_;
		_tmp23_ = rows;
		if (_tmp23_ != NULL) {
			ValadocContentTable* _tmp24_;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			ValaCollection* _tmp27_;
			_tmp24_ = table;
			_tmp25_ = valadoc_content_table_get_rows (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = rows;
			vala_collection_add_all ((ValaCollection*) _tmp26_, _tmp27_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_vala_iterable_unref0 (rows);
	}
	_tmp28_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "tgroup");
	if (!_tmp28_) {
		ValadocGtkdocToken* _tmp29_;
		_tmp29_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp29_, "</tgroup>");
		result = table;
		return result;
	}
	_tmp30_ = valadoc_gtkdoc_parser_next (self);
	_tmp31_ = _tmp30_;
	_valadoc_gtkdoc_token_unref0 (_tmp31_);
	result = table;
	return result;
}


static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self) {
	ValadocContentTable* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentTable* table = NULL;
	ValadocContentTable* _tmp4_;
	gboolean _tmp5_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "informaltable");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<informaltable>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = valadoc_gtkdoc_parser_parse_docbook_tgroup (self);
	table = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp5_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "informaltable");
	if (!_tmp5_) {
		ValadocGtkdocToken* _tmp6_;
		_tmp6_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp6_, "</informaltable>");
		result = table;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_parser_next (self);
	_tmp8_ = _tmp7_;
	_valadoc_gtkdoc_token_unref0 (_tmp8_);
	result = table;
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	gboolean _tmp0_;
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp2_;
	ValaHashMap* _tmp3_;
	gpointer _tmp4_;
	const gchar* _tmp5_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp11_;
	gboolean _tmp12_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "section");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<section>");
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->attributes;
	_tmp4_ = vala_map_get ((ValaMap*) _tmp3_, "id");
	id = (gchar*) _tmp4_;
	_tmp5_ = id;
	if (_tmp5_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp6_;
		const gchar* _tmp7_;
		ValadocApiNode* _tmp8_;
		_tmp6_ = self->priv->id_registrar;
		_tmp7_ = id;
		_tmp8_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = valadoc_gtkdoc_parser_next (self);
	_tmp10_ = _tmp9_;
	_valadoc_gtkdoc_token_unref0 (_tmp10_);
	_tmp11_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp11_;
	_tmp12_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "section");
	if (!_tmp12_) {
		ValadocGtkdocToken* _tmp13_;
		_tmp13_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp13_, "</section>");
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp14_ = valadoc_gtkdoc_parser_next (self);
	_tmp15_ = _tmp14_;
	_valadoc_gtkdoc_token_unref0 (_tmp15_);
	result = content;
	_g_free0 (id);
	return result;
}


static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self) {
	ValadocContentListItem* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentListItem* _tmp5_;
	ValadocContentParagraph* para = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentParagraph* _tmp7_;
	ValadocContentListItem* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentParagraph* _tmp11_;
	ValadocContentParagraph* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValadocContentRun* _tmp15_;
	ValadocContentRun* _tmp16_;
	gboolean _tmp17_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "member");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<member>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_list_item (_tmp4_);
	item = _tmp5_;
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_paragraph (_tmp6_);
	para = _tmp7_;
	_tmp8_ = item;
	_tmp9_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = para;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentBlock*) _tmp11_);
	_tmp12_ = para;
	_tmp13_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp16_ = _tmp15_;
	vala_collection_add ((ValaCollection*) _tmp14_, (ValadocContentInline*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp17_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "member");
	if (!_tmp17_) {
		ValadocGtkdocToken* _tmp18_;
		_tmp18_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp18_, "</member>");
		result = item;
		_g_object_unref0 (para);
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_parser_next (self);
	_tmp20_ = _tmp19_;
	_valadoc_gtkdoc_token_unref0 (_tmp20_);
	result = item;
	_g_object_unref0 (para);
	return result;
}


static ValadocContentList* valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self) {
	ValadocContentList* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentList* _tmp5_;
	gboolean _tmp17_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "simplelist");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<simplelist>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_list (_tmp4_);
	list = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp11_;
		ValadocContentListItem* _tmp12_;
		ValadocContentList* _tmp13_;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		ValadocContentListItem* _tmp16_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->content;
			_tmp6_ = g_strcmp0 (_tmp10_, "member") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_member (self);
		item = _tmp11_;
		_tmp12_ = item;
		if (_tmp12_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp13_ = list;
		_tmp14_ = valadoc_content_list_get_items (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = item;
		vala_collection_add ((ValaCollection*) _tmp15_, _tmp16_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	_tmp17_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "simplelist");
	if (!_tmp17_) {
		ValadocGtkdocToken* _tmp18_;
		_tmp18_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp18_, "</simplelist>");
		result = list;
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_parser_next (self);
	_tmp20_ = _tmp19_;
	_valadoc_gtkdoc_token_unref0 (_tmp20_);
	result = list;
	return result;
}


static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self) {
	ValadocContentParagraph* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp4_;
	ValadocContentParagraph* _tmp5_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentRun* _tmp11_;
	gboolean _tmp12_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "term");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<term>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = self->priv->factory;
	_tmp5_ = valadoc_content_content_factory_create_paragraph (_tmp4_);
	p = _tmp5_;
	_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp6_;
	_tmp7_ = run;
	valadoc_content_run_set_style (_tmp7_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	_tmp8_ = p;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = run;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp11_);
	_tmp12_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "term");
	if (!_tmp12_) {
		ValadocGtkdocToken* _tmp13_;
		_tmp13_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp13_, "</term>");
		result = p;
		_g_object_unref0 (run);
		return result;
	}
	_tmp14_ = valadoc_gtkdoc_parser_next (self);
	_tmp15_ = _tmp14_;
	_valadoc_gtkdoc_token_unref0 (_tmp15_);
	result = p;
	_g_object_unref0 (run);
	return result;
}


static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self) {
	ValadocContentListItem* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocTokenType _tmp6_;
	ValadocContentParagraph* term = NULL;
	ValadocContentParagraph* _tmp9_;
	ValadocContentParagraph* _tmp10_;
	ValadocContentListItem* desc = NULL;
	ValadocContentListItem* _tmp11_;
	ValadocContentListItem* _tmp12_;
	ValadocContentListItem* listitem = NULL;
	ValadocContentContentFactory* _tmp13_;
	ValadocContentListItem* _tmp14_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp15_;
	ValadocContentList* _tmp16_;
	ValadocContentListItem* _tmp17_;
	ValaList* _tmp18_;
	ValaList* _tmp19_;
	ValadocContentParagraph* _tmp20_;
	ValadocContentListItem* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	ValadocContentList* _tmp24_;
	ValadocContentList* _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValadocContentListItem* _tmp28_;
	gboolean _tmp29_;
	ValadocGtkdocToken* _tmp31_;
	ValadocGtkdocToken* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "varlistentry");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<varlistentry>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->type;
	if (_tmp6_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		_tmp4_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->content;
		_tmp4_ = g_strcmp0 (_tmp8_, "term") != 0;
	}
	if (_tmp4_) {
		result = NULL;
		return result;
	}
	_tmp9_ = valadoc_gtkdoc_parser_parse_docbook_term (self);
	term = _tmp9_;
	_tmp10_ = term;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
	desc = _tmp11_;
	_tmp12_ = desc;
	if (_tmp12_ == NULL) {
		result = NULL;
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp13_ = self->priv->factory;
	_tmp14_ = valadoc_content_content_factory_create_list_item (_tmp13_);
	listitem = _tmp14_;
	_tmp15_ = self->priv->factory;
	_tmp16_ = valadoc_content_content_factory_create_list (_tmp15_);
	list = _tmp16_;
	_tmp17_ = listitem;
	_tmp18_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = term;
	vala_collection_add ((ValaCollection*) _tmp19_, (ValadocContentBlock*) _tmp20_);
	_tmp21_ = listitem;
	_tmp22_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = list;
	vala_collection_add ((ValaCollection*) _tmp23_, (ValadocContentBlock*) _tmp24_);
	_tmp25_ = list;
	_tmp26_ = valadoc_content_list_get_items (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = desc;
	vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
	_tmp29_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "varlistentry");
	if (!_tmp29_) {
		ValadocGtkdocToken* _tmp30_;
		_tmp30_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp30_, "</varlistentry>");
		result = listitem;
		_g_object_unref0 (list);
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	_tmp31_ = valadoc_gtkdoc_parser_next (self);
	_tmp32_ = _tmp31_;
	_valadoc_gtkdoc_token_unref0 (_tmp32_);
	result = listitem;
	_g_object_unref0 (list);
	_g_object_unref0 (desc);
	_g_object_unref0 (term);
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	gboolean _tmp0_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocTokenType _tmp8_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp14_;
	ValadocContentList* _tmp15_;
	ValaCollection* _tmp16_;
	ValadocContentList* _tmp17_;
	gboolean _tmp29_;
	ValadocGtkdocToken* _tmp31_;
	ValadocGtkdocToken* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "variablelist");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<variablelist>");
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_gtkdoc_parser_next (self);
	_tmp3_ = _tmp2_;
	_valadoc_gtkdoc_token_unref0 (_tmp3_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_);
	content = (ValaCollection*) _tmp5_;
	_tmp7_ = self->priv->current;
	_tmp8_ = _tmp7_->type;
	if (_tmp8_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->content;
		_tmp6_ = g_strcmp0 (_tmp10_, "title") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaCollection* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		_tmp11_ = content;
		_tmp12_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp13_ = _tmp12_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp11_, (ValadocContentBlock*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp14_ = self->priv->factory;
	_tmp15_ = valadoc_content_content_factory_create_list (_tmp14_);
	list = _tmp15_;
	_tmp16_ = content;
	_tmp17_ = list;
	vala_collection_add (_tmp16_, (ValadocContentBlock*) _tmp17_);
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		ValadocGtkdocToken* _tmp19_;
		ValadocGtkdocTokenType _tmp20_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp23_;
		ValadocContentListItem* _tmp24_;
		ValadocContentList* _tmp25_;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		ValadocContentListItem* _tmp28_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->type;
		if (_tmp20_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = self->priv->current;
			_tmp22_ = _tmp21_->content;
			_tmp18_ = g_strcmp0 (_tmp22_, "varlistentry") == 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp23_ = valadoc_gtkdoc_parser_parse_docbook_varlistentry (self);
		item = _tmp23_;
		_tmp24_ = item;
		if (_tmp24_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp25_ = list;
		_tmp26_ = valadoc_content_list_get_items (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = item;
		vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	_tmp29_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "variablelist");
	if (!_tmp29_) {
		ValadocGtkdocToken* _tmp30_;
		_tmp30_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp30_, "</variablelist>");
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp31_ = valadoc_gtkdoc_parser_next (self);
	_tmp32_ = _tmp31_;
	_valadoc_gtkdoc_token_unref0 (_tmp32_);
	result = content;
	_g_object_unref0 (list);
	return result;
}


static ValaCollection* valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self) {
	ValaCollection* result = NULL;
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocTokenType _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocTokenType _tmp6_;
		_tmp2_ = self->priv->current;
		_tmp3_ = _tmp2_->type;
		if (!(_tmp3_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp4_ = g_strcmp0 (_tmp8_, "itemizedlist") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaCollection* _tmp9_;
			ValaCollection* _tmp10_;
			ValaCollection* _tmp11_;
			_tmp9_ = content;
			_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "itemizedlist", VALADOC_CONTENT_LIST_BULLET_UNORDERED);
			_tmp11_ = _tmp10_;
			valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp9_, _tmp11_);
			_vala_iterable_unref0 (_tmp11_);
		} else {
			gboolean _tmp12_ = FALSE;
			ValadocGtkdocToken* _tmp13_;
			ValadocGtkdocTokenType _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				_tmp12_ = g_strcmp0 (_tmp16_, "orderedlist") == 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaCollection* _tmp17_;
				ValaCollection* _tmp18_;
				ValaCollection* _tmp19_;
				_tmp17_ = content;
				_tmp18_ = valadoc_gtkdoc_parser_parse_docbook_orderedlist (self);
				_tmp19_ = _tmp18_;
				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp17_, _tmp19_);
				_vala_iterable_unref0 (_tmp19_);
			} else {
				gboolean _tmp20_ = FALSE;
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_->content;
					_tmp20_ = g_strcmp0 (_tmp24_, "variablelist") == 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValaCollection* _tmp25_;
					ValaCollection* _tmp26_;
					ValaCollection* _tmp27_;
					_tmp25_ = content;
					_tmp26_ = valadoc_gtkdoc_parser_parse_docbook_variablelist (self);
					_tmp27_ = _tmp26_;
					valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp25_, _tmp27_);
					_vala_iterable_unref0 (_tmp27_);
				} else {
					gboolean _tmp28_ = FALSE;
					ValadocGtkdocToken* _tmp29_;
					ValadocGtkdocTokenType _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_->type;
					if (_tmp30_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = self->priv->current;
						_tmp32_ = _tmp31_->content;
						_tmp28_ = g_strcmp0 (_tmp32_, "simplelist") == 0;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						ValaCollection* _tmp33_;
						ValadocContentList* _tmp34_;
						ValadocContentList* _tmp35_;
						_tmp33_ = content;
						_tmp34_ = valadoc_gtkdoc_parser_parse_docbook_simplelist (self);
						_tmp35_ = _tmp34_;
						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp33_, (ValadocContentBlock*) _tmp35_);
						_g_object_unref0 (_tmp35_);
					} else {
						gboolean _tmp36_ = FALSE;
						ValadocGtkdocToken* _tmp37_;
						ValadocGtkdocTokenType _tmp38_;
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_->type;
						if (_tmp38_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = self->priv->current;
							_tmp40_ = _tmp39_->content;
							_tmp36_ = g_strcmp0 (_tmp40_, "informaltable") == 0;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							ValaCollection* _tmp41_;
							ValadocContentTable* _tmp42_;
							ValadocContentTable* _tmp43_;
							_tmp41_ = content;
							_tmp42_ = valadoc_gtkdoc_parser_parse_docbook_informaltable (self);
							_tmp43_ = _tmp42_;
							valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp41_, (ValadocContentBlock*) _tmp43_);
							_g_object_unref0 (_tmp43_);
						} else {
							gboolean _tmp44_ = FALSE;
							ValadocGtkdocToken* _tmp45_;
							ValadocGtkdocTokenType _tmp46_;
							_tmp45_ = self->priv->current;
							_tmp46_ = _tmp45_->type;
							if (_tmp46_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp47_;
								const gchar* _tmp48_;
								_tmp47_ = self->priv->current;
								_tmp48_ = _tmp47_->content;
								_tmp44_ = g_strcmp0 (_tmp48_, "programlisting") == 0;
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								ValaCollection* _tmp49_;
								ValadocContentParagraph* _tmp50_;
								ValadocContentParagraph* _tmp51_;
								_tmp49_ = content;
								_tmp50_ = valadoc_gtkdoc_parser_parse_docbook_programlisting (self);
								_tmp51_ = _tmp50_;
								valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp49_, (ValadocContentBlock*) _tmp51_);
								_g_object_unref0 (_tmp51_);
							} else {
								gboolean _tmp52_ = FALSE;
								ValadocGtkdocToken* _tmp53_;
								ValadocGtkdocTokenType _tmp54_;
								_tmp53_ = self->priv->current;
								_tmp54_ = _tmp53_->type;
								if (_tmp54_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp55_;
									const gchar* _tmp56_;
									_tmp55_ = self->priv->current;
									_tmp56_ = _tmp55_->content;
									_tmp52_ = g_strcmp0 (_tmp56_, "para") == 0;
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									ValaCollection* _tmp57_;
									ValaCollection* _tmp58_;
									ValaCollection* _tmp59_;
									_tmp57_ = content;
									_tmp58_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "para");
									_tmp59_ = _tmp58_;
									valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp57_, _tmp59_);
									_vala_iterable_unref0 (_tmp59_);
								} else {
									gboolean _tmp60_ = FALSE;
									ValadocGtkdocToken* _tmp61_;
									ValadocGtkdocTokenType _tmp62_;
									_tmp61_ = self->priv->current;
									_tmp62_ = _tmp61_->type;
									if (_tmp62_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp63_;
										const gchar* _tmp64_;
										_tmp63_ = self->priv->current;
										_tmp64_ = _tmp63_->content;
										_tmp60_ = g_strcmp0 (_tmp64_, "simpara") == 0;
									} else {
										_tmp60_ = FALSE;
									}
									if (_tmp60_) {
										ValaCollection* _tmp65_;
										ValaCollection* _tmp66_;
										ValaCollection* _tmp67_;
										_tmp65_ = content;
										_tmp66_ = valadoc_gtkdoc_parser_parse_docbook_simpara (self);
										_tmp67_ = _tmp66_;
										valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp65_, _tmp67_);
										_vala_iterable_unref0 (_tmp67_);
									} else {
										gboolean _tmp68_ = FALSE;
										ValadocGtkdocToken* _tmp69_;
										ValadocGtkdocTokenType _tmp70_;
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_->type;
										if (_tmp70_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp71_;
											const gchar* _tmp72_;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_->content;
											_tmp68_ = g_strcmp0 (_tmp72_, "informalexample") == 0;
										} else {
											_tmp68_ = FALSE;
										}
										if (_tmp68_) {
											ValaCollection* _tmp73_;
											ValaCollection* _tmp74_;
											ValaCollection* _tmp75_;
											_tmp73_ = content;
											_tmp74_ = valadoc_gtkdoc_parser_parse_docbook_informalexample (self);
											_tmp75_ = _tmp74_;
											valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp73_, _tmp75_);
											_vala_iterable_unref0 (_tmp75_);
										} else {
											gboolean _tmp76_ = FALSE;
											ValadocGtkdocToken* _tmp77_;
											ValadocGtkdocTokenType _tmp78_;
											_tmp77_ = self->priv->current;
											_tmp78_ = _tmp77_->type;
											if (_tmp78_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp79_;
												const gchar* _tmp80_;
												_tmp79_ = self->priv->current;
												_tmp80_ = _tmp79_->content;
												_tmp76_ = g_strcmp0 (_tmp80_, "example") == 0;
											} else {
												_tmp76_ = FALSE;
											}
											if (_tmp76_) {
												ValaCollection* _tmp81_;
												ValaCollection* _tmp82_;
												ValaCollection* _tmp83_;
												_tmp81_ = content;
												_tmp82_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "example");
												_tmp83_ = _tmp82_;
												valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp81_, _tmp83_);
												_vala_iterable_unref0 (_tmp83_);
											} else {
												gboolean _tmp84_ = FALSE;
												ValadocGtkdocToken* _tmp85_;
												ValadocGtkdocTokenType _tmp86_;
												_tmp85_ = self->priv->current;
												_tmp86_ = _tmp85_->type;
												if (_tmp86_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp87_;
													const gchar* _tmp88_;
													_tmp87_ = self->priv->current;
													_tmp88_ = _tmp87_->content;
													_tmp84_ = g_strcmp0 (_tmp88_, "warning") == 0;
												} else {
													_tmp84_ = FALSE;
												}
												if (_tmp84_) {
													ValaCollection* _tmp89_;
													ValadocContentWarning* _tmp90_;
													ValadocContentWarning* _tmp91_;
													_tmp89_ = content;
													_tmp90_ = valadoc_gtkdoc_parser_parse_docbook_warning (self);
													_tmp91_ = _tmp90_;
													valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp89_, (ValadocContentBlock*) _tmp91_);
													_g_object_unref0 (_tmp91_);
												} else {
													gboolean _tmp92_ = FALSE;
													ValadocGtkdocToken* _tmp93_;
													ValadocGtkdocTokenType _tmp94_;
													_tmp93_ = self->priv->current;
													_tmp94_ = _tmp93_->type;
													if (_tmp94_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp95_;
														const gchar* _tmp96_;
														_tmp95_ = self->priv->current;
														_tmp96_ = _tmp95_->content;
														_tmp92_ = g_strcmp0 (_tmp96_, "note") == 0;
													} else {
														_tmp92_ = FALSE;
													}
													if (_tmp92_) {
														ValaCollection* _tmp97_;
														ValadocContentNote* _tmp98_;
														ValadocContentNote* _tmp99_;
														_tmp97_ = content;
														_tmp98_ = valadoc_gtkdoc_parser_parse_docbook_note (self);
														_tmp99_ = _tmp98_;
														valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp97_, (ValadocContentBlock*) _tmp99_);
														_g_object_unref0 (_tmp99_);
													} else {
														gboolean _tmp100_ = FALSE;
														ValadocGtkdocToken* _tmp101_;
														ValadocGtkdocTokenType _tmp102_;
														_tmp101_ = self->priv->current;
														_tmp102_ = _tmp101_->type;
														if (_tmp102_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp103_;
															const gchar* _tmp104_;
															_tmp103_ = self->priv->current;
															_tmp104_ = _tmp103_->content;
															_tmp100_ = g_strcmp0 (_tmp104_, "important") == 0;
														} else {
															_tmp100_ = FALSE;
														}
														if (_tmp100_) {
															ValaCollection* _tmp105_;
															ValadocContentNote* _tmp106_;
															ValadocContentNote* _tmp107_;
															_tmp105_ = content;
															_tmp106_ = valadoc_gtkdoc_parser_parse_docbook_important (self);
															_tmp107_ = _tmp106_;
															valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp105_, (ValadocContentBlock*) _tmp107_);
															_g_object_unref0 (_tmp107_);
														} else {
															gboolean _tmp108_ = FALSE;
															ValadocGtkdocToken* _tmp109_;
															ValadocGtkdocTokenType _tmp110_;
															_tmp109_ = self->priv->current;
															_tmp110_ = _tmp109_->type;
															if (_tmp110_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp111_;
																const gchar* _tmp112_;
																_tmp111_ = self->priv->current;
																_tmp112_ = _tmp111_->content;
																_tmp108_ = g_strcmp0 (_tmp112_, "refsect3") == 0;
															} else {
																_tmp108_ = FALSE;
															}
															if (_tmp108_) {
																ValaCollection* _tmp113_;
																ValaList* _tmp114_;
																ValaList* _tmp115_;
																_tmp113_ = content;
																_tmp114_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 3);
																_tmp115_ = _tmp114_;
																valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp113_, (ValaCollection*) _tmp115_);
																_vala_iterable_unref0 (_tmp115_);
															} else {
																gboolean _tmp116_ = FALSE;
																ValadocGtkdocToken* _tmp117_;
																ValadocGtkdocTokenType _tmp118_;
																_tmp117_ = self->priv->current;
																_tmp118_ = _tmp117_->type;
																if (_tmp118_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp119_;
																	const gchar* _tmp120_;
																	_tmp119_ = self->priv->current;
																	_tmp120_ = _tmp119_->content;
																	_tmp116_ = g_strcmp0 (_tmp120_, "refsect2") == 0;
																} else {
																	_tmp116_ = FALSE;
																}
																if (_tmp116_) {
																	ValaCollection* _tmp121_;
																	ValaList* _tmp122_;
																	ValaList* _tmp123_;
																	_tmp121_ = content;
																	_tmp122_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 2);
																	_tmp123_ = _tmp122_;
																	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp121_, (ValaCollection*) _tmp123_);
																	_vala_iterable_unref0 (_tmp123_);
																} else {
																	gboolean _tmp124_ = FALSE;
																	ValadocGtkdocToken* _tmp125_;
																	ValadocGtkdocTokenType _tmp126_;
																	_tmp125_ = self->priv->current;
																	_tmp126_ = _tmp125_->type;
																	if (_tmp126_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp127_;
																		const gchar* _tmp128_;
																		_tmp127_ = self->priv->current;
																		_tmp128_ = _tmp127_->content;
																		_tmp124_ = g_strcmp0 (_tmp128_, "figure") == 0;
																	} else {
																		_tmp124_ = FALSE;
																	}
																	if (_tmp124_) {
																		ValaCollection* _tmp129_;
																		ValaList* _tmp130_;
																		ValaList* _tmp131_;
																		_tmp129_ = content;
																		_tmp130_ = valadoc_gtkdoc_parser_parse_docbook_figure (self);
																		_tmp131_ = _tmp130_;
																		valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp129_, (ValaCollection*) _tmp131_);
																		_vala_iterable_unref0 (_tmp131_);
																	} else {
																		gboolean _tmp132_ = FALSE;
																		ValadocGtkdocToken* _tmp133_;
																		ValadocGtkdocTokenType _tmp134_;
																		_tmp133_ = self->priv->current;
																		_tmp134_ = _tmp133_->type;
																		if (_tmp134_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp135_;
																			const gchar* _tmp136_;
																			_tmp135_ = self->priv->current;
																			_tmp136_ = _tmp135_->content;
																			_tmp132_ = g_strcmp0 (_tmp136_, "title") == 0;
																		} else {
																			_tmp132_ = FALSE;
																		}
																		if (_tmp132_) {
																			ValaCollection* _tmp137_;
																			ValadocContentParagraph* _tmp138_;
																			ValadocContentParagraph* _tmp139_;
																			_tmp137_ = content;
																			_tmp138_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
																			_tmp139_ = _tmp138_;
																			valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp137_, (ValadocContentBlock*) _tmp139_);
																			_g_object_unref0 (_tmp139_);
																		} else {
																			gboolean _tmp140_ = FALSE;
																			ValadocGtkdocToken* _tmp141_;
																			ValadocGtkdocTokenType _tmp142_;
																			_tmp141_ = self->priv->current;
																			_tmp142_ = _tmp141_->type;
																			if (_tmp142_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp143_;
																				const gchar* _tmp144_;
																				_tmp143_ = self->priv->current;
																				_tmp144_ = _tmp143_->content;
																				_tmp140_ = g_strcmp0 (_tmp144_, "section") == 0;
																			} else {
																				_tmp140_ = FALSE;
																			}
																			if (_tmp140_) {
																				ValaCollection* _tmp145_;
																				ValaCollection* _tmp146_;
																				ValaCollection* _tmp147_;
																				_tmp145_ = content;
																				_tmp146_ = valadoc_gtkdoc_parser_parse_docbook_section (self);
																				_tmp147_ = _tmp146_;
																				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp145_, _tmp147_);
																				_vala_iterable_unref0 (_tmp147_);
																			} else {
																				ValadocGtkdocToken* _tmp148_;
																				ValadocGtkdocTokenType _tmp149_;
																				_tmp148_ = self->priv->current;
																				_tmp149_ = _tmp148_->type;
																				if (_tmp149_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
																					ValaCollection* _tmp150_;
																					ValadocContentParagraph* _tmp151_;
																					ValadocContentParagraph* _tmp152_;
																					_tmp150_ = content;
																					_tmp151_ = valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (self);
																					_tmp152_ = _tmp151_;
																					valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp150_, (ValadocContentBlock*) _tmp152_);
																					_g_object_unref0 (_tmp152_);
																				} else {
																					ValadocGtkdocToken* _tmp153_;
																					ValadocGtkdocTokenType _tmp154_;
																					_tmp153_ = self->priv->current;
																					_tmp154_ = _tmp153_->type;
																					if (_tmp154_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
																						ValaCollection* _tmp155_;
																						ValadocContentParagraph* _tmp156_;
																						ValadocContentParagraph* _tmp157_;
																						_tmp155_ = content;
																						_tmp156_ = valadoc_gtkdoc_parser_parse_gtkdoc_source (self);
																						_tmp157_ = _tmp156_;
																						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp155_, (ValadocContentBlock*) _tmp157_);
																						_g_object_unref0 (_tmp157_);
																					} else {
																						break;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = content;
	return result;
}


static ValadocContentRun* valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self) {
	ValadocContentRun* result = NULL;
	gboolean _tmp0_;
	gchar* _class = NULL;
	ValadocGtkdocToken* _tmp2_;
	ValaHashMap* _tmp3_;
	gpointer _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocTokenType _tmp8_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp10_;
	ValadocContentRun* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp48_;
	ValadocGtkdocToken* _tmp50_;
	ValadocGtkdocToken* _tmp51_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_check_xml_open_tag (self, "tag");
	if (!_tmp0_) {
		ValadocGtkdocToken* _tmp1_;
		_tmp1_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp1_, "<tag>");
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->attributes;
	_tmp4_ = vala_map_get ((ValaMap*) _tmp3_, "class");
	_class = (gchar*) _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp7_ = self->priv->current;
	_tmp8_ = _tmp7_->type;
	if (_tmp8_ != VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp9_;
		_tmp9_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp9_, "<WORD>");
		result = NULL;
		_g_free0 (_class);
		return result;
	}
	_tmp10_ = self->priv->factory;
	_tmp11_ = valadoc_content_content_factory_create_run (_tmp10_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
	run = _tmp11_;
	_tmp13_ = _class;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = _class;
		_tmp12_ = g_strcmp0 (_tmp14_, "starttag") == 0;
	}
	if (_tmp12_) {
		ValadocContentRun* _tmp15_;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		ValadocContentContentFactory* _tmp18_;
		ValadocGtkdocToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		ValadocContentText* _tmp25_;
		ValadocContentText* _tmp26_;
		ValadocGtkdocToken* _tmp27_;
		ValadocGtkdocToken* _tmp28_;
		_tmp15_ = run;
		_tmp16_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->factory;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->content;
		_tmp21_ = g_strconcat ("<", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, ">", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = valadoc_content_content_factory_create_text (_tmp18_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_collection_add ((ValaCollection*) _tmp17_, (ValadocContentInline*) _tmp26_);
		_g_object_unref0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp27_ = valadoc_gtkdoc_parser_next (self);
		_tmp28_ = _tmp27_;
		_valadoc_gtkdoc_token_unref0 (_tmp28_);
	} else {
		const gchar* _tmp29_;
		_tmp29_ = _class;
		if (g_strcmp0 (_tmp29_, "endtag") == 0) {
			ValadocContentRun* _tmp30_;
			ValaList* _tmp31_;
			ValaList* _tmp32_;
			ValadocContentContentFactory* _tmp33_;
			ValadocGtkdocToken* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			ValadocContentText* _tmp40_;
			ValadocContentText* _tmp41_;
			ValadocGtkdocToken* _tmp42_;
			ValadocGtkdocToken* _tmp43_;
			_tmp30_ = run;
			_tmp31_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->factory;
			_tmp34_ = self->priv->current;
			_tmp35_ = _tmp34_->content;
			_tmp36_ = g_strconcat ("</", _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp37_, ">", NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = valadoc_content_content_factory_create_text (_tmp33_, _tmp39_);
			_tmp41_ = _tmp40_;
			vala_collection_add ((ValaCollection*) _tmp32_, (ValadocContentInline*) _tmp41_);
			_g_object_unref0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp42_ = valadoc_gtkdoc_parser_next (self);
			_tmp43_ = _tmp42_;
			_valadoc_gtkdoc_token_unref0 (_tmp43_);
		} else {
			ValadocGtkdocToken* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp44_ = self->priv->current;
			_tmp45_ = _class;
			_tmp46_ = g_strdup_printf ("<tag class=\"%s\">", _tmp45_);
			_tmp47_ = _tmp46_;
			valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp44_, _tmp47_);
			_g_free0 (_tmp47_);
			result = run;
			_g_free0 (_class);
			return result;
		}
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp48_ = valadoc_gtkdoc_parser_check_xml_close_tag (self, "tag");
	if (!_tmp48_) {
		ValadocGtkdocToken* _tmp49_;
		_tmp49_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp49_, "</tag>");
		result = run;
		_g_free0 (_class);
		return result;
	}
	_tmp50_ = valadoc_gtkdoc_parser_next (self);
	_tmp51_ = _tmp50_;
	_valadoc_gtkdoc_token_unref0 (_tmp51_);
	result = run;
	_g_free0 (_class);
	return result;
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchug (_tmp1_);
	result = _result_;
	return result;
}


static void valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self, ValadocContentRun* run, const gchar* current) {
	ValadocContentText* last_as_text = NULL;
	ValadocContentRun* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValadocContentText* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (current != NULL);
	last_as_text = NULL;
	_tmp0_ = run;
	_tmp1_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		ValadocContentRun* _tmp5_;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValadocContentInline* _tmp9_;
		ValadocContentText* _tmp10_;
		_tmp5_ = run;
		_tmp6_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_list_last (_tmp7_);
		_tmp9_ = (ValadocContentInline*) _tmp8_;
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp9_) : NULL;
		if (_tmp10_ == NULL) {
			_g_object_unref0 (_tmp9_);
		}
		_g_object_unref0 (last_as_text);
		last_as_text = _tmp10_;
	}
	_tmp11_ = last_as_text;
	if (_tmp11_ == NULL) {
		ValadocContentRun* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		ValadocContentContentFactory* _tmp15_;
		const gchar* _tmp16_;
		ValadocContentText* _tmp17_;
		ValadocContentText* _tmp18_;
		_tmp12_ = run;
		_tmp13_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->factory;
		_tmp16_ = current;
		_tmp17_ = valadoc_content_content_factory_create_text (_tmp15_, _tmp16_);
		_tmp18_ = _tmp17_;
		vala_collection_add ((ValaCollection*) _tmp14_, (ValadocContentInline*) _tmp18_);
		_g_object_unref0 (_tmp18_);
	} else {
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = current;
		_tmp21_ = g_str_has_prefix (_tmp20_, " ");
		if (_tmp21_) {
			ValadocContentText* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_;
			_tmp22_ = last_as_text;
			_tmp23_ = valadoc_content_text_get_content (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_str_has_suffix (_tmp24_, " ");
			_tmp19_ = _tmp25_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValadocContentText* _tmp26_;
			ValadocContentText* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp26_ = last_as_text;
			_tmp27_ = last_as_text;
			_tmp28_ = valadoc_content_text_get_content (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = current;
			_tmp31_ = string_chug (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			valadoc_content_text_set_content (_tmp27_, _tmp34_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
		} else {
			ValadocContentText* _tmp35_;
			ValadocContentText* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp35_ = last_as_text;
			_tmp36_ = last_as_text;
			_tmp37_ = valadoc_content_text_get_content (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = current;
			_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			valadoc_content_text_set_content (_tmp36_, _tmp41_);
			_g_free0 (_tmp41_);
		}
	}
	_g_object_unref0 (last_as_text);
}


static ValadocContentInline* valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self, const gchar* name, gboolean c_accept_plural) {
	ValadocContentInline* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "TRUE") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = name;
		_tmp2_ = g_strcmp0 (_tmp4_, "FALSE") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = name;
		_tmp1_ = g_strcmp0 (_tmp5_, "NULL") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = name;
		_tmp7_ = valadoc_gtkdoc_parser_is_numeric (self, _tmp6_);
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		ValadocContentRun* monospaced = NULL;
		ValadocContentContentFactory* _tmp8_;
		ValadocContentRun* _tmp9_;
		ValadocContentRun* _tmp10_;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		ValadocContentContentFactory* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValadocContentText* _tmp17_;
		ValadocContentText* _tmp18_;
		_tmp8_ = self->priv->factory;
		_tmp9_ = valadoc_content_content_factory_create_run (_tmp8_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
		monospaced = _tmp9_;
		_tmp10_ = monospaced;
		_tmp11_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->factory;
		_tmp14_ = name;
		_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) -1);
		_tmp16_ = _tmp15_;
		_tmp17_ = valadoc_content_content_factory_create_text (_tmp13_, _tmp16_);
		_tmp18_ = _tmp17_;
		vala_collection_add ((ValaCollection*) _tmp12_, (ValadocContentInline*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		_g_free0 (_tmp16_);
		result = (ValadocContentInline*) monospaced;
		return result;
	} else {
		ValadocTagletsLink* taglet = NULL;
		ValadocContentContentFactory* _tmp19_;
		ValadocContentTaglet* _tmp20_;
		ValadocTagletsLink* _tmp21_;
		ValadocTagletsLink* _tmp22_;
		ValadocTagletsLink* _tmp23_;
		gboolean _tmp24_;
		ValadocTagletsLink* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp19_ = self->priv->factory;
		_tmp20_ = valadoc_content_content_factory_create_taglet (_tmp19_, "link");
		_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALADOC_TAGLETS_TYPE_LINK) ? ((ValadocTagletsLink*) _tmp20_) : NULL;
		if (_tmp21_ == NULL) {
			_g_object_unref0 (_tmp20_);
		}
		taglet = _tmp21_;
		_tmp22_ = taglet;
		_vala_assert (_tmp22_ != NULL, "taglet != null");
		_tmp23_ = taglet;
		_tmp24_ = c_accept_plural;
		valadoc_taglets_link_set_c_accept_plural (_tmp23_, _tmp24_);
		_tmp25_ = taglet;
		_tmp26_ = name;
		_tmp27_ = g_strconcat ("c::", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		valadoc_taglets_link_set_symbol_name (_tmp25_, _tmp28_);
		_g_free0 (_tmp28_);
		result = (ValadocContentInline*) taglet;
		return result;
	}
}


static inline void valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self, ValadocContentRun* run, ValadocContentInline* element) {
	ValadocContentInline* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	if (_tmp0_ != NULL) {
		ValadocContentRun* _tmp1_;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		ValadocContentInline* _tmp4_;
		_tmp1_ = run;
		_tmp2_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = element;
		vala_collection_add ((ValaCollection*) _tmp3_, _tmp4_);
	}
}


static ValadocContentRun* valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self) {
	ValadocContentRun* result = NULL;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_NONE);
	run = _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocTokenType _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocTokenType _tmp6_;
		_tmp2_ = self->priv->current;
		_tmp3_ = _tmp2_->type;
		if (!(_tmp3_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp4_ = g_strcmp0 (_tmp8_, "firstterm") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValadocContentRun* _tmp9_;
			ValadocContentRun* _tmp10_;
			ValadocContentRun* _tmp11_;
			_tmp9_ = run;
			_tmp10_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "firstterm", VALADOC_CONTENT_RUN_STYLE_ITALIC);
			_tmp11_ = _tmp10_;
			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp9_, (ValadocContentInline*) _tmp11_);
			_g_object_unref0 (_tmp11_);
		} else {
			gboolean _tmp12_ = FALSE;
			ValadocGtkdocToken* _tmp13_;
			ValadocGtkdocTokenType _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				_tmp12_ = g_strcmp0 (_tmp16_, "abbrev") == 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValadocContentRun* _tmp17_;
				ValadocContentRun* _tmp18_;
				ValadocContentRun* _tmp19_;
				_tmp17_ = run;
				_tmp18_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "abbrev", VALADOC_CONTENT_RUN_STYLE_ITALIC);
				_tmp19_ = _tmp18_;
				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp17_, (ValadocContentInline*) _tmp19_);
				_g_object_unref0 (_tmp19_);
			} else {
				gboolean _tmp20_ = FALSE;
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_->content;
					_tmp20_ = g_strcmp0 (_tmp24_, "term") == 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValadocContentRun* _tmp25_;
					ValadocContentRun* _tmp26_;
					ValadocContentRun* _tmp27_;
					_tmp25_ = run;
					_tmp26_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "term", VALADOC_CONTENT_RUN_STYLE_ITALIC);
					_tmp27_ = _tmp26_;
					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp25_, (ValadocContentInline*) _tmp27_);
					_g_object_unref0 (_tmp27_);
				} else {
					gboolean _tmp28_ = FALSE;
					ValadocGtkdocToken* _tmp29_;
					ValadocGtkdocTokenType _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_->type;
					if (_tmp30_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = self->priv->current;
						_tmp32_ = _tmp31_->content;
						_tmp28_ = g_strcmp0 (_tmp32_, "literal") == 0;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						ValadocContentRun* _tmp33_;
						ValadocContentRun* _tmp34_;
						ValadocContentRun* _tmp35_;
						_tmp33_ = run;
						_tmp34_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literal", VALADOC_CONTENT_RUN_STYLE_ITALIC);
						_tmp35_ = _tmp34_;
						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp33_, (ValadocContentInline*) _tmp35_);
						_g_object_unref0 (_tmp35_);
					} else {
						gboolean _tmp36_ = FALSE;
						ValadocGtkdocToken* _tmp37_;
						ValadocGtkdocTokenType _tmp38_;
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_->type;
						if (_tmp38_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = self->priv->current;
							_tmp40_ = _tmp39_->content;
							_tmp36_ = g_strcmp0 (_tmp40_, "literallayout") == 0;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							ValadocContentRun* _tmp41_;
							ValadocContentRun* _tmp42_;
							ValadocContentRun* _tmp43_;
							_tmp41_ = run;
							_tmp42_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literallayout", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
							_tmp43_ = _tmp42_;
							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp41_, (ValadocContentInline*) _tmp43_);
							_g_object_unref0 (_tmp43_);
						} else {
							gboolean _tmp44_ = FALSE;
							ValadocGtkdocToken* _tmp45_;
							ValadocGtkdocTokenType _tmp46_;
							_tmp45_ = self->priv->current;
							_tmp46_ = _tmp45_->type;
							if (_tmp46_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp47_;
								const gchar* _tmp48_;
								_tmp47_ = self->priv->current;
								_tmp48_ = _tmp47_->content;
								_tmp44_ = g_strcmp0 (_tmp48_, "application") == 0;
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								ValadocContentRun* _tmp49_;
								ValadocContentRun* _tmp50_;
								ValadocContentRun* _tmp51_;
								_tmp49_ = run;
								_tmp50_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "application", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
								_tmp51_ = _tmp50_;
								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp49_, (ValadocContentInline*) _tmp51_);
								_g_object_unref0 (_tmp51_);
							} else {
								gboolean _tmp52_ = FALSE;
								ValadocGtkdocToken* _tmp53_;
								ValadocGtkdocTokenType _tmp54_;
								_tmp53_ = self->priv->current;
								_tmp54_ = _tmp53_->type;
								if (_tmp54_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp55_;
									const gchar* _tmp56_;
									_tmp55_ = self->priv->current;
									_tmp56_ = _tmp55_->content;
									_tmp52_ = g_strcmp0 (_tmp56_, "varname") == 0;
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									ValadocContentRun* _tmp57_;
									ValadocContentRun* _tmp58_;
									ValadocContentRun* _tmp59_;
									_tmp57_ = run;
									_tmp58_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "varname", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
									_tmp59_ = _tmp58_;
									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp57_, (ValadocContentInline*) _tmp59_);
									_g_object_unref0 (_tmp59_);
								} else {
									gboolean _tmp60_ = FALSE;
									ValadocGtkdocToken* _tmp61_;
									ValadocGtkdocTokenType _tmp62_;
									_tmp61_ = self->priv->current;
									_tmp62_ = _tmp61_->type;
									if (_tmp62_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp63_;
										const gchar* _tmp64_;
										_tmp63_ = self->priv->current;
										_tmp64_ = _tmp63_->content;
										_tmp60_ = g_strcmp0 (_tmp64_, "computeroutput") == 0;
									} else {
										_tmp60_ = FALSE;
									}
									if (_tmp60_) {
										ValadocContentRun* _tmp65_;
										ValadocContentRun* _tmp66_;
										ValadocContentRun* _tmp67_;
										_tmp65_ = run;
										_tmp66_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "computeroutput", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
										_tmp67_ = _tmp66_;
										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp65_, (ValadocContentInline*) _tmp67_);
										_g_object_unref0 (_tmp67_);
									} else {
										gboolean _tmp68_ = FALSE;
										ValadocGtkdocToken* _tmp69_;
										ValadocGtkdocTokenType _tmp70_;
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_->type;
										if (_tmp70_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp71_;
											const gchar* _tmp72_;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_->content;
											_tmp68_ = g_strcmp0 (_tmp72_, "emphasis") == 0;
										} else {
											_tmp68_ = FALSE;
										}
										if (_tmp68_) {
											ValadocContentRun* _tmp73_;
											ValadocContentRun* _tmp74_;
											ValadocContentRun* _tmp75_;
											_tmp73_ = run;
											_tmp74_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "emphasis", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
											_tmp75_ = _tmp74_;
											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp73_, (ValadocContentInline*) _tmp75_);
											_g_object_unref0 (_tmp75_);
										} else {
											gboolean _tmp76_ = FALSE;
											ValadocGtkdocToken* _tmp77_;
											ValadocGtkdocTokenType _tmp78_;
											_tmp77_ = self->priv->current;
											_tmp78_ = _tmp77_->type;
											if (_tmp78_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp79_;
												const gchar* _tmp80_;
												_tmp79_ = self->priv->current;
												_tmp80_ = _tmp79_->content;
												_tmp76_ = g_strcmp0 (_tmp80_, "pre") == 0;
											} else {
												_tmp76_ = FALSE;
											}
											if (_tmp76_) {
												ValadocContentRun* _tmp81_;
												ValadocContentRun* _tmp82_;
												ValadocContentRun* _tmp83_;
												_tmp81_ = run;
												_tmp82_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "pre", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
												_tmp83_ = _tmp82_;
												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp81_, (ValadocContentInline*) _tmp83_);
												_g_object_unref0 (_tmp83_);
											} else {
												gboolean _tmp84_ = FALSE;
												ValadocGtkdocToken* _tmp85_;
												ValadocGtkdocTokenType _tmp86_;
												_tmp85_ = self->priv->current;
												_tmp86_ = _tmp85_->type;
												if (_tmp86_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp87_;
													const gchar* _tmp88_;
													_tmp87_ = self->priv->current;
													_tmp88_ = _tmp87_->content;
													_tmp84_ = g_strcmp0 (_tmp88_, "code") == 0;
												} else {
													_tmp84_ = FALSE;
												}
												if (_tmp84_) {
													ValadocContentRun* _tmp89_;
													ValadocContentRun* _tmp90_;
													ValadocContentRun* _tmp91_;
													_tmp89_ = run;
													_tmp90_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "code", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
													_tmp91_ = _tmp90_;
													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp89_, (ValadocContentInline*) _tmp91_);
													_g_object_unref0 (_tmp91_);
												} else {
													gboolean _tmp92_ = FALSE;
													ValadocGtkdocToken* _tmp93_;
													ValadocGtkdocTokenType _tmp94_;
													_tmp93_ = self->priv->current;
													_tmp94_ = _tmp93_->type;
													if (_tmp94_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp95_;
														const gchar* _tmp96_;
														_tmp95_ = self->priv->current;
														_tmp96_ = _tmp95_->content;
														_tmp92_ = g_strcmp0 (_tmp96_, "guimenuitem") == 0;
													} else {
														_tmp92_ = FALSE;
													}
													if (_tmp92_) {
														ValadocContentRun* _tmp97_;
														ValadocContentRun* _tmp98_;
														ValadocContentRun* _tmp99_;
														_tmp97_ = run;
														_tmp98_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "guimenuitem", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
														_tmp99_ = _tmp98_;
														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp97_, (ValadocContentInline*) _tmp99_);
														_g_object_unref0 (_tmp99_);
													} else {
														gboolean _tmp100_ = FALSE;
														ValadocGtkdocToken* _tmp101_;
														ValadocGtkdocTokenType _tmp102_;
														_tmp101_ = self->priv->current;
														_tmp102_ = _tmp101_->type;
														if (_tmp102_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp103_;
															const gchar* _tmp104_;
															_tmp103_ = self->priv->current;
															_tmp104_ = _tmp103_->content;
															_tmp100_ = g_strcmp0 (_tmp104_, "command") == 0;
														} else {
															_tmp100_ = FALSE;
														}
														if (_tmp100_) {
															ValadocContentRun* _tmp105_;
															ValadocContentRun* _tmp106_;
															ValadocContentRun* _tmp107_;
															_tmp105_ = run;
															_tmp106_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "command", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
															_tmp107_ = _tmp106_;
															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp105_, (ValadocContentInline*) _tmp107_);
															_g_object_unref0 (_tmp107_);
														} else {
															gboolean _tmp108_ = FALSE;
															ValadocGtkdocToken* _tmp109_;
															ValadocGtkdocTokenType _tmp110_;
															_tmp109_ = self->priv->current;
															_tmp110_ = _tmp109_->type;
															if (_tmp110_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp111_;
																const gchar* _tmp112_;
																_tmp111_ = self->priv->current;
																_tmp112_ = _tmp111_->content;
																_tmp108_ = g_strcmp0 (_tmp112_, "option") == 0;
															} else {
																_tmp108_ = FALSE;
															}
															if (_tmp108_) {
																ValadocContentRun* _tmp113_;
																ValadocContentRun* _tmp114_;
																ValadocContentRun* _tmp115_;
																_tmp113_ = run;
																_tmp114_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "option", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																_tmp115_ = _tmp114_;
																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp113_, (ValadocContentInline*) _tmp115_);
																_g_object_unref0 (_tmp115_);
															} else {
																gboolean _tmp116_ = FALSE;
																ValadocGtkdocToken* _tmp117_;
																ValadocGtkdocTokenType _tmp118_;
																_tmp117_ = self->priv->current;
																_tmp118_ = _tmp117_->type;
																if (_tmp118_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp119_;
																	const gchar* _tmp120_;
																	_tmp119_ = self->priv->current;
																	_tmp120_ = _tmp119_->content;
																	_tmp116_ = g_strcmp0 (_tmp120_, "keycap") == 0;
																} else {
																	_tmp116_ = FALSE;
																}
																if (_tmp116_) {
																	ValadocContentRun* _tmp121_;
																	ValadocContentRun* _tmp122_;
																	ValadocContentRun* _tmp123_;
																	_tmp121_ = run;
																	_tmp122_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycap", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																	_tmp123_ = _tmp122_;
																	valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp121_, (ValadocContentInline*) _tmp123_);
																	_g_object_unref0 (_tmp123_);
																} else {
																	gboolean _tmp124_ = FALSE;
																	ValadocGtkdocToken* _tmp125_;
																	ValadocGtkdocTokenType _tmp126_;
																	_tmp125_ = self->priv->current;
																	_tmp126_ = _tmp125_->type;
																	if (_tmp126_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp127_;
																		const gchar* _tmp128_;
																		_tmp127_ = self->priv->current;
																		_tmp128_ = _tmp127_->content;
																		_tmp124_ = g_strcmp0 (_tmp128_, "keycombo") == 0;
																	} else {
																		_tmp124_ = FALSE;
																	}
																	if (_tmp124_) {
																		ValadocContentRun* _tmp129_;
																		ValadocContentRun* _tmp130_;
																		ValadocContentRun* _tmp131_;
																		_tmp129_ = run;
																		_tmp130_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycombo", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																		_tmp131_ = _tmp130_;
																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp129_, (ValadocContentInline*) _tmp131_);
																		_g_object_unref0 (_tmp131_);
																	} else {
																		gboolean _tmp132_ = FALSE;
																		ValadocGtkdocToken* _tmp133_;
																		ValadocGtkdocTokenType _tmp134_;
																		_tmp133_ = self->priv->current;
																		_tmp134_ = _tmp133_->type;
																		if (_tmp134_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp135_;
																			const gchar* _tmp136_;
																			_tmp135_ = self->priv->current;
																			_tmp136_ = _tmp135_->content;
																			_tmp132_ = g_strcmp0 (_tmp136_, "envar") == 0;
																		} else {
																			_tmp132_ = FALSE;
																		}
																		if (_tmp132_) {
																			ValadocContentRun* _tmp137_;
																			ValadocContentRun* _tmp138_;
																			ValadocContentRun* _tmp139_;
																			_tmp137_ = run;
																			_tmp138_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "envar", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																			_tmp139_ = _tmp138_;
																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp137_, (ValadocContentInline*) _tmp139_);
																			_g_object_unref0 (_tmp139_);
																		} else {
																			gboolean _tmp140_ = FALSE;
																			ValadocGtkdocToken* _tmp141_;
																			ValadocGtkdocTokenType _tmp142_;
																			_tmp141_ = self->priv->current;
																			_tmp142_ = _tmp141_->type;
																			if (_tmp142_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp143_;
																				const gchar* _tmp144_;
																				_tmp143_ = self->priv->current;
																				_tmp144_ = _tmp143_->content;
																				_tmp140_ = g_strcmp0 (_tmp144_, "filename") == 0;
																			} else {
																				_tmp140_ = FALSE;
																			}
																			if (_tmp140_) {
																				ValadocContentRun* _tmp145_;
																				ValadocContentRun* _tmp146_;
																				ValadocContentRun* _tmp147_;
																				_tmp145_ = run;
																				_tmp146_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "filename", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																				_tmp147_ = _tmp146_;
																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp145_, (ValadocContentInline*) _tmp147_);
																				_g_object_unref0 (_tmp147_);
																			} else {
																				gboolean _tmp148_ = FALSE;
																				ValadocGtkdocToken* _tmp149_;
																				ValadocGtkdocTokenType _tmp150_;
																				_tmp149_ = self->priv->current;
																				_tmp150_ = _tmp149_->type;
																				if (_tmp150_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																					ValadocGtkdocToken* _tmp151_;
																					const gchar* _tmp152_;
																					_tmp151_ = self->priv->current;
																					_tmp152_ = _tmp151_->content;
																					_tmp148_ = g_strcmp0 (_tmp152_, "parameter") == 0;
																				} else {
																					_tmp148_ = FALSE;
																				}
																				if (_tmp148_) {
																					ValadocContentRun* _tmp153_;
																					ValadocContentRun* _tmp154_;
																					ValadocContentRun* _tmp155_;
																					_tmp153_ = run;
																					_tmp154_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "parameter", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																					_tmp155_ = _tmp154_;
																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp153_, (ValadocContentInline*) _tmp155_);
																					_g_object_unref0 (_tmp155_);
																				} else {
																					gboolean _tmp156_ = FALSE;
																					ValadocGtkdocToken* _tmp157_;
																					ValadocGtkdocTokenType _tmp158_;
																					_tmp157_ = self->priv->current;
																					_tmp158_ = _tmp157_->type;
																					if (_tmp158_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																						ValadocGtkdocToken* _tmp159_;
																						const gchar* _tmp160_;
																						_tmp159_ = self->priv->current;
																						_tmp160_ = _tmp159_->content;
																						_tmp156_ = g_strcmp0 (_tmp160_, "replaceable") == 0;
																					} else {
																						_tmp156_ = FALSE;
																					}
																					if (_tmp156_) {
																						ValadocContentRun* _tmp161_;
																						ValadocContentRun* _tmp162_;
																						ValadocContentRun* _tmp163_;
																						_tmp161_ = run;
																						_tmp162_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "replaceable", VALADOC_CONTENT_RUN_STYLE_ITALIC);
																						_tmp163_ = _tmp162_;
																						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp161_, (ValadocContentInline*) _tmp163_);
																						_g_object_unref0 (_tmp163_);
																					} else {
																						gboolean _tmp164_ = FALSE;
																						ValadocGtkdocToken* _tmp165_;
																						ValadocGtkdocTokenType _tmp166_;
																						_tmp165_ = self->priv->current;
																						_tmp166_ = _tmp165_->type;
																						if (_tmp166_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																							ValadocGtkdocToken* _tmp167_;
																							const gchar* _tmp168_;
																							_tmp167_ = self->priv->current;
																							_tmp168_ = _tmp167_->content;
																							_tmp164_ = g_strcmp0 (_tmp168_, "quote") == 0;
																						} else {
																							_tmp164_ = FALSE;
																						}
																						if (_tmp164_) {
																							ValadocContentRun* _tmp169_;
																							ValaList* _tmp170_;
																							ValaList* _tmp171_;
																							ValadocContentContentFactory* _tmp172_;
																							ValadocContentText* _tmp173_;
																							ValadocContentText* _tmp174_;
																							ValadocContentRun* _tmp175_;
																							ValadocContentRun* _tmp176_;
																							ValadocContentRun* _tmp177_;
																							ValadocContentRun* _tmp178_;
																							ValaList* _tmp179_;
																							ValaList* _tmp180_;
																							ValadocContentContentFactory* _tmp181_;
																							ValadocContentText* _tmp182_;
																							ValadocContentText* _tmp183_;
																							_tmp169_ = run;
																							_tmp170_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp169_);
																							_tmp171_ = _tmp170_;
																							_tmp172_ = self->priv->factory;
																							_tmp173_ = valadoc_content_content_factory_create_text (_tmp172_, "“");
																							_tmp174_ = _tmp173_;
																							vala_collection_add ((ValaCollection*) _tmp171_, (ValadocContentInline*) _tmp174_);
																							_g_object_unref0 (_tmp174_);
																							_tmp175_ = run;
																							_tmp176_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "quote", VALADOC_CONTENT_RUN_STYLE_NONE);
																							_tmp177_ = _tmp176_;
																							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp175_, (ValadocContentInline*) _tmp177_);
																							_g_object_unref0 (_tmp177_);
																							_tmp178_ = run;
																							_tmp179_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp178_);
																							_tmp180_ = _tmp179_;
																							_tmp181_ = self->priv->factory;
																							_tmp182_ = valadoc_content_content_factory_create_text (_tmp181_, "”");
																							_tmp183_ = _tmp182_;
																							vala_collection_add ((ValaCollection*) _tmp180_, (ValadocContentInline*) _tmp183_);
																							_g_object_unref0 (_tmp183_);
																						} else {
																							gboolean _tmp184_ = FALSE;
																							ValadocGtkdocToken* _tmp185_;
																							ValadocGtkdocTokenType _tmp186_;
																							_tmp185_ = self->priv->current;
																							_tmp186_ = _tmp185_->type;
																							if (_tmp186_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																								ValadocGtkdocToken* _tmp187_;
																								const gchar* _tmp188_;
																								_tmp187_ = self->priv->current;
																								_tmp188_ = _tmp187_->content;
																								_tmp184_ = g_strcmp0 (_tmp188_, "footnote") == 0;
																							} else {
																								_tmp184_ = FALSE;
																							}
																							if (_tmp184_) {
																								ValadocContentRun* _tmp189_;
																								ValadocContentRun* _tmp190_;
																								ValadocContentRun* _tmp191_;
																								_tmp189_ = run;
																								_tmp190_ = valadoc_gtkdoc_parser_parse_docbook_footnote (self);
																								_tmp191_ = _tmp190_;
																								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp189_, (ValadocContentInline*) _tmp191_);
																								_g_object_unref0 (_tmp191_);
																							} else {
																								gboolean _tmp192_ = FALSE;
																								ValadocGtkdocToken* _tmp193_;
																								ValadocGtkdocTokenType _tmp194_;
																								_tmp193_ = self->priv->current;
																								_tmp194_ = _tmp193_->type;
																								if (_tmp194_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																									ValadocGtkdocToken* _tmp195_;
																									const gchar* _tmp196_;
																									_tmp195_ = self->priv->current;
																									_tmp196_ = _tmp195_->content;
																									_tmp192_ = g_strcmp0 (_tmp196_, "type") == 0;
																								} else {
																									_tmp192_ = FALSE;
																								}
																								if (_tmp192_) {
																									ValadocContentRun* _tmp197_;
																									ValadocContentInlineTaglet* _tmp198_;
																									ValadocContentInlineTaglet* _tmp199_;
																									_tmp197_ = run;
																									_tmp198_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "type");
																									_tmp199_ = _tmp198_;
																									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp197_, (ValadocContentInline*) _tmp199_);
																									_g_object_unref0 (_tmp199_);
																								} else {
																									gboolean _tmp200_ = FALSE;
																									ValadocGtkdocToken* _tmp201_;
																									ValadocGtkdocTokenType _tmp202_;
																									_tmp201_ = self->priv->current;
																									_tmp202_ = _tmp201_->type;
																									if (_tmp202_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																										ValadocGtkdocToken* _tmp203_;
																										const gchar* _tmp204_;
																										_tmp203_ = self->priv->current;
																										_tmp204_ = _tmp203_->content;
																										_tmp200_ = g_strcmp0 (_tmp204_, "function") == 0;
																									} else {
																										_tmp200_ = FALSE;
																									}
																									if (_tmp200_) {
																										ValadocContentRun* _tmp205_;
																										ValadocContentInlineTaglet* _tmp206_;
																										ValadocContentInlineTaglet* _tmp207_;
																										_tmp205_ = run;
																										_tmp206_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "function");
																										_tmp207_ = _tmp206_;
																										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp205_, (ValadocContentInline*) _tmp207_);
																										_g_object_unref0 (_tmp207_);
																									} else {
																										gboolean _tmp208_ = FALSE;
																										ValadocGtkdocToken* _tmp209_;
																										ValadocGtkdocTokenType _tmp210_;
																										_tmp209_ = self->priv->current;
																										_tmp210_ = _tmp209_->type;
																										if (_tmp210_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																											ValadocGtkdocToken* _tmp211_;
																											const gchar* _tmp212_;
																											_tmp211_ = self->priv->current;
																											_tmp212_ = _tmp211_->content;
																											_tmp208_ = g_strcmp0 (_tmp212_, "classname") == 0;
																										} else {
																											_tmp208_ = FALSE;
																										}
																										if (_tmp208_) {
																											ValadocContentRun* _tmp213_;
																											ValadocContentInlineTaglet* _tmp214_;
																											ValadocContentInlineTaglet* _tmp215_;
																											_tmp213_ = run;
																											_tmp214_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "classname");
																											_tmp215_ = _tmp214_;
																											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp213_, (ValadocContentInline*) _tmp215_);
																											_g_object_unref0 (_tmp215_);
																										} else {
																											gboolean _tmp216_ = FALSE;
																											ValadocGtkdocToken* _tmp217_;
																											ValadocGtkdocTokenType _tmp218_;
																											_tmp217_ = self->priv->current;
																											_tmp218_ = _tmp217_->type;
																											if (_tmp218_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																												ValadocGtkdocToken* _tmp219_;
																												const gchar* _tmp220_;
																												_tmp219_ = self->priv->current;
																												_tmp220_ = _tmp219_->content;
																												_tmp216_ = g_strcmp0 (_tmp220_, "structname") == 0;
																											} else {
																												_tmp216_ = FALSE;
																											}
																											if (_tmp216_) {
																												ValadocContentRun* _tmp221_;
																												ValadocContentInlineTaglet* _tmp222_;
																												ValadocContentInlineTaglet* _tmp223_;
																												_tmp221_ = run;
																												_tmp222_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structname");
																												_tmp223_ = _tmp222_;
																												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp221_, (ValadocContentInline*) _tmp223_);
																												_g_object_unref0 (_tmp223_);
																											} else {
																												gboolean _tmp224_ = FALSE;
																												ValadocGtkdocToken* _tmp225_;
																												ValadocGtkdocTokenType _tmp226_;
																												_tmp225_ = self->priv->current;
																												_tmp226_ = _tmp225_->type;
																												if (_tmp226_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																													ValadocGtkdocToken* _tmp227_;
																													const gchar* _tmp228_;
																													_tmp227_ = self->priv->current;
																													_tmp228_ = _tmp227_->content;
																													_tmp224_ = g_strcmp0 (_tmp228_, "structfield") == 0;
																												} else {
																													_tmp224_ = FALSE;
																												}
																												if (_tmp224_) {
																													ValadocContentRun* _tmp229_;
																													ValadocContentInlineTaglet* _tmp230_;
																													ValadocContentInlineTaglet* _tmp231_;
																													_tmp229_ = run;
																													_tmp230_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structfield");
																													_tmp231_ = _tmp230_;
																													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp229_, (ValadocContentInline*) _tmp231_);
																													_g_object_unref0 (_tmp231_);
																												} else {
																													gboolean _tmp232_ = FALSE;
																													ValadocGtkdocToken* _tmp233_;
																													ValadocGtkdocTokenType _tmp234_;
																													_tmp233_ = self->priv->current;
																													_tmp234_ = _tmp233_->type;
																													if (_tmp234_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																														ValadocGtkdocToken* _tmp235_;
																														const gchar* _tmp236_;
																														_tmp235_ = self->priv->current;
																														_tmp236_ = _tmp235_->content;
																														_tmp232_ = g_strcmp0 (_tmp236_, "errorcode") == 0;
																													} else {
																														_tmp232_ = FALSE;
																													}
																													if (_tmp232_) {
																														ValadocContentRun* _tmp237_;
																														ValadocContentInlineTaglet* _tmp238_;
																														ValadocContentInlineTaglet* _tmp239_;
																														_tmp237_ = run;
																														_tmp238_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "errorcode");
																														_tmp239_ = _tmp238_;
																														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp237_, (ValadocContentInline*) _tmp239_);
																														_g_object_unref0 (_tmp239_);
																													} else {
																														gboolean _tmp240_ = FALSE;
																														ValadocGtkdocToken* _tmp241_;
																														ValadocGtkdocTokenType _tmp242_;
																														_tmp241_ = self->priv->current;
																														_tmp242_ = _tmp241_->type;
																														if (_tmp242_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																															ValadocGtkdocToken* _tmp243_;
																															const gchar* _tmp244_;
																															_tmp243_ = self->priv->current;
																															_tmp244_ = _tmp243_->content;
																															_tmp240_ = g_strcmp0 (_tmp244_, "constant") == 0;
																														} else {
																															_tmp240_ = FALSE;
																														}
																														if (_tmp240_) {
																															ValadocContentRun* _tmp245_;
																															ValadocContentInlineTaglet* _tmp246_;
																															ValadocContentInlineTaglet* _tmp247_;
																															_tmp245_ = run;
																															_tmp246_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "constant");
																															_tmp247_ = _tmp246_;
																															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp245_, (ValadocContentInline*) _tmp247_);
																															_g_object_unref0 (_tmp247_);
																														} else {
																															gboolean _tmp248_ = FALSE;
																															ValadocGtkdocToken* _tmp249_;
																															ValadocGtkdocTokenType _tmp250_;
																															_tmp249_ = self->priv->current;
																															_tmp250_ = _tmp249_->type;
																															if (_tmp250_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																ValadocGtkdocToken* _tmp251_;
																																const gchar* _tmp252_;
																																_tmp251_ = self->priv->current;
																																_tmp252_ = _tmp251_->content;
																																_tmp248_ = g_strcmp0 (_tmp252_, "inlinegraphic") == 0;
																															} else {
																																_tmp248_ = FALSE;
																															}
																															if (_tmp248_) {
																																ValadocContentRun* _tmp253_;
																																ValadocContentEmbedded* _tmp254_;
																																ValadocContentEmbedded* _tmp255_;
																																_tmp253_ = run;
																																_tmp254_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
																																_tmp255_ = _tmp254_;
																																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp253_, (ValadocContentInline*) _tmp255_);
																																_g_object_unref0 (_tmp255_);
																															} else {
																																gboolean _tmp256_ = FALSE;
																																ValadocGtkdocToken* _tmp257_;
																																ValadocGtkdocTokenType _tmp258_;
																																_tmp257_ = self->priv->current;
																																_tmp258_ = _tmp257_->type;
																																if (_tmp258_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																	ValadocGtkdocToken* _tmp259_;
																																	const gchar* _tmp260_;
																																	_tmp259_ = self->priv->current;
																																	_tmp260_ = _tmp259_->content;
																																	_tmp256_ = g_strcmp0 (_tmp260_, "anchor") == 0;
																																} else {
																																	_tmp256_ = FALSE;
																																}
																																if (_tmp256_) {
																																	valadoc_gtkdoc_parser_parse_anchor (self);
																																} else {
																																	gboolean _tmp261_ = FALSE;
																																	ValadocGtkdocToken* _tmp262_;
																																	ValadocGtkdocTokenType _tmp263_;
																																	_tmp262_ = self->priv->current;
																																	_tmp263_ = _tmp262_->type;
																																	if (_tmp263_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																		ValadocGtkdocToken* _tmp264_;
																																		const gchar* _tmp265_;
																																		_tmp264_ = self->priv->current;
																																		_tmp265_ = _tmp264_->content;
																																		_tmp261_ = g_strcmp0 (_tmp265_, "link") == 0;
																																	} else {
																																		_tmp261_ = FALSE;
																																	}
																																	if (_tmp261_) {
																																		ValadocContentRun* _tmp266_;
																																		ValadocContentInline* _tmp267_;
																																		ValadocContentInline* _tmp268_;
																																		_tmp266_ = run;
																																		_tmp267_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "link", TRUE);
																																		_tmp268_ = _tmp267_;
																																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp266_, _tmp268_);
																																		_g_object_unref0 (_tmp268_);
																																	} else {
																																		gboolean _tmp269_ = FALSE;
																																		ValadocGtkdocToken* _tmp270_;
																																		ValadocGtkdocTokenType _tmp271_;
																																		_tmp270_ = self->priv->current;
																																		_tmp271_ = _tmp270_->type;
																																		if (_tmp271_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																			ValadocGtkdocToken* _tmp272_;
																																			const gchar* _tmp273_;
																																			_tmp272_ = self->priv->current;
																																			_tmp273_ = _tmp272_->content;
																																			_tmp269_ = g_strcmp0 (_tmp273_, "ulink") == 0;
																																		} else {
																																			_tmp269_ = FALSE;
																																		}
																																		if (_tmp269_) {
																																			ValadocContentRun* _tmp274_;
																																			ValadocContentInline* _tmp275_;
																																			ValadocContentInline* _tmp276_;
																																			_tmp274_ = run;
																																			_tmp275_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "ulink", FALSE);
																																			_tmp276_ = _tmp275_;
																																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp274_, _tmp276_);
																																			_g_object_unref0 (_tmp276_);
																																		} else {
																																			gboolean _tmp277_ = FALSE;
																																			ValadocGtkdocToken* _tmp278_;
																																			ValadocGtkdocTokenType _tmp279_;
																																			_tmp278_ = self->priv->current;
																																			_tmp279_ = _tmp278_->type;
																																			if (_tmp279_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																				ValadocGtkdocToken* _tmp280_;
																																				const gchar* _tmp281_;
																																				_tmp280_ = self->priv->current;
																																				_tmp281_ = _tmp280_->content;
																																				_tmp277_ = g_strcmp0 (_tmp281_, "xref") == 0;
																																			} else {
																																				_tmp277_ = FALSE;
																																			}
																																			if (_tmp277_) {
																																				ValadocContentRun* _tmp282_;
																																				ValadocContentLink* _tmp283_;
																																				ValadocContentLink* _tmp284_;
																																				_tmp282_ = run;
																																				_tmp283_ = valadoc_gtkdoc_parser_parse_xref (self);
																																				_tmp284_ = _tmp283_;
																																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp282_, (ValadocContentInline*) _tmp284_);
																																				_g_object_unref0 (_tmp284_);
																																			} else {
																																				gboolean _tmp285_ = FALSE;
																																				ValadocGtkdocToken* _tmp286_;
																																				ValadocGtkdocTokenType _tmp287_;
																																				_tmp286_ = self->priv->current;
																																				_tmp287_ = _tmp286_->type;
																																				if (_tmp287_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																					ValadocGtkdocToken* _tmp288_;
																																					const gchar* _tmp289_;
																																					_tmp288_ = self->priv->current;
																																					_tmp289_ = _tmp288_->content;
																																					_tmp285_ = g_strcmp0 (_tmp289_, "tag") == 0;
																																				} else {
																																					_tmp285_ = FALSE;
																																				}
																																				if (_tmp285_) {
																																					ValadocContentRun* _tmp290_;
																																					ValadocContentRun* _tmp291_;
																																					ValadocContentRun* _tmp292_;
																																					_tmp290_ = run;
																																					_tmp291_ = valadoc_gtkdoc_parser_parse_xml_tag (self);
																																					_tmp292_ = _tmp291_;
																																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp290_, (ValadocContentInline*) _tmp292_);
																																					_g_object_unref0 (_tmp292_);
																																				} else {
																																					ValadocGtkdocToken* _tmp293_;
																																					ValadocGtkdocTokenType _tmp294_;
																																					_tmp293_ = self->priv->current;
																																					_tmp294_ = _tmp293_->type;
																																					if (_tmp294_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
																																						ValadocContentRun* _tmp295_;
																																						ValaList* _tmp296_;
																																						ValaList* _tmp297_;
																																						ValadocGtkdocToken* _tmp298_;
																																						const gchar* _tmp299_;
																																						ValadocContentInline* _tmp300_;
																																						ValadocContentInline* _tmp301_;
																																						ValadocGtkdocToken* _tmp302_;
																																						ValadocGtkdocToken* _tmp303_;
																																						_tmp295_ = run;
																																						_tmp296_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp295_);
																																						_tmp297_ = _tmp296_;
																																						_tmp298_ = self->priv->current;
																																						_tmp299_ = _tmp298_->content;
																																						_tmp300_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp299_, FALSE);
																																						_tmp301_ = _tmp300_;
																																						vala_collection_add ((ValaCollection*) _tmp297_, _tmp301_);
																																						_g_object_unref0 (_tmp301_);
																																						_tmp302_ = valadoc_gtkdoc_parser_next (self);
																																						_tmp303_ = _tmp302_;
																																						_valadoc_gtkdoc_token_unref0 (_tmp303_);
																																					} else {
																																						ValadocGtkdocToken* _tmp304_;
																																						ValadocGtkdocTokenType _tmp305_;
																																						_tmp304_ = self->priv->current;
																																						_tmp305_ = _tmp304_->type;
																																						if (_tmp305_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
																																							ValadocGtkdocToken* _tmp306_;
																																							const gchar* _tmp307_;
																																							const gchar* _tmp308_;
																																							ValadocGtkdocToken* _tmp387_;
																																							ValadocGtkdocToken* _tmp388_;
																																							_tmp306_ = self->priv->current;
																																							_tmp307_ = _tmp306_->content;
																																							_tmp308_ = self->priv->instance_param_name;
																																							if (g_strcmp0 (_tmp307_, _tmp308_) == 0) {
																																								ValadocContentRun* keyword_run = NULL;
																																								ValadocContentContentFactory* _tmp309_;
																																								ValadocContentRun* _tmp310_;
																																								ValadocContentText* text = NULL;
																																								ValadocContentContentFactory* _tmp311_;
																																								ValadocContentText* _tmp312_;
																																								ValadocContentRun* _tmp313_;
																																								ValaList* _tmp314_;
																																								ValaList* _tmp315_;
																																								ValadocContentText* _tmp316_;
																																								ValadocContentRun* _tmp317_;
																																								ValaList* _tmp318_;
																																								ValaList* _tmp319_;
																																								ValadocContentRun* _tmp320_;
																																								_tmp309_ = self->priv->factory;
																																								_tmp310_ = valadoc_content_content_factory_create_run (_tmp309_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																								keyword_run = _tmp310_;
																																								_tmp311_ = self->priv->factory;
																																								_tmp312_ = valadoc_content_content_factory_create_text (_tmp311_, "this");
																																								text = _tmp312_;
																																								_tmp313_ = keyword_run;
																																								_tmp314_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp313_);
																																								_tmp315_ = _tmp314_;
																																								_tmp316_ = text;
																																								vala_collection_add ((ValaCollection*) _tmp315_, (ValadocContentInline*) _tmp316_);
																																								_tmp317_ = run;
																																								_tmp318_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp317_);
																																								_tmp319_ = _tmp318_;
																																								_tmp320_ = keyword_run;
																																								vala_collection_add ((ValaCollection*) _tmp319_, (ValadocContentInline*) _tmp320_);
																																								_g_object_unref0 (text);
																																								_g_object_unref0 (keyword_run);
																																							} else {
																																								gchar* param_array_name = NULL;
																																								gboolean is_return_type_len = FALSE;
																																								gchar* param_name = NULL;
																																								gchar* cname = NULL;
																																								ValadocApiTree* _tmp321_;
																																								ValadocApiNode* _tmp322_;
																																								ValadocGtkdocToken* _tmp323_;
																																								const gchar* _tmp324_;
																																								gchar* _tmp325_ = NULL;
																																								gchar* _tmp326_ = NULL;
																																								gboolean _tmp327_ = FALSE;
																																								gchar* _tmp328_;
																																								ValadocContentRun* current_run = NULL;
																																								ValadocContentContentFactory* _tmp329_;
																																								ValadocContentRun* _tmp330_;
																																								ValadocContentRun* _tmp331_;
																																								ValaList* _tmp332_;
																																								ValaList* _tmp333_;
																																								ValadocContentRun* _tmp334_;
																																								gboolean _tmp335_;
																																								const gchar* _tmp371_;
																																								_tmp321_ = self->priv->tree;
																																								_tmp322_ = self->priv->element;
																																								_tmp323_ = self->priv->current;
																																								_tmp324_ = _tmp323_->content;
																																								_tmp328_ = valadoc_importer_helper_resolve_parameter_ctype (_tmp321_, _tmp322_, _tmp324_, &_tmp325_, &_tmp326_, &_tmp327_);
																																								_g_free0 (param_name);
																																								param_name = _tmp325_;
																																								_g_free0 (param_array_name);
																																								param_array_name = _tmp326_;
																																								is_return_type_len = _tmp327_;
																																								cname = _tmp328_;
																																								_tmp329_ = self->priv->factory;
																																								_tmp330_ = valadoc_content_content_factory_create_run (_tmp329_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																																								current_run = _tmp330_;
																																								_tmp331_ = run;
																																								_tmp332_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp331_);
																																								_tmp333_ = _tmp332_;
																																								_tmp334_ = current_run;
																																								vala_collection_add ((ValaCollection*) _tmp333_, (ValadocContentInline*) _tmp334_);
																																								_tmp335_ = is_return_type_len;
																																								if (_tmp335_) {
																																									ValadocContentRun* keyword_run = NULL;
																																									ValadocContentContentFactory* _tmp336_;
																																									ValadocContentRun* _tmp337_;
																																									ValadocContentRun* _tmp338_;
																																									ValaList* _tmp339_;
																																									ValaList* _tmp340_;
																																									ValadocContentContentFactory* _tmp341_;
																																									ValadocContentText* _tmp342_;
																																									ValadocContentText* _tmp343_;
																																									ValadocContentRun* _tmp344_;
																																									ValaList* _tmp345_;
																																									ValaList* _tmp346_;
																																									ValadocContentRun* _tmp347_;
																																									ValadocContentRun* _tmp348_;
																																									ValaList* _tmp349_;
																																									ValaList* _tmp350_;
																																									ValadocContentContentFactory* _tmp351_;
																																									ValadocContentText* _tmp352_;
																																									ValadocContentText* _tmp353_;
																																									_tmp336_ = self->priv->factory;
																																									_tmp337_ = valadoc_content_content_factory_create_run (_tmp336_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																									keyword_run = _tmp337_;
																																									_tmp338_ = keyword_run;
																																									_tmp339_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp338_);
																																									_tmp340_ = _tmp339_;
																																									_tmp341_ = self->priv->factory;
																																									_tmp342_ = valadoc_content_content_factory_create_text (_tmp341_, "return");
																																									_tmp343_ = _tmp342_;
																																									vala_collection_add ((ValaCollection*) _tmp340_, (ValadocContentInline*) _tmp343_);
																																									_g_object_unref0 (_tmp343_);
																																									_tmp344_ = current_run;
																																									_tmp345_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp344_);
																																									_tmp346_ = _tmp345_;
																																									_tmp347_ = keyword_run;
																																									vala_collection_add ((ValaCollection*) _tmp346_, (ValadocContentInline*) _tmp347_);
																																									_tmp348_ = current_run;
																																									_tmp349_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp348_);
																																									_tmp350_ = _tmp349_;
																																									_tmp351_ = self->priv->factory;
																																									_tmp352_ = valadoc_content_content_factory_create_text (_tmp351_, ".length");
																																									_tmp353_ = _tmp352_;
																																									vala_collection_add ((ValaCollection*) _tmp350_, (ValadocContentInline*) _tmp353_);
																																									_g_object_unref0 (_tmp353_);
																																									_g_object_unref0 (keyword_run);
																																								} else {
																																									const gchar* _tmp354_;
																																									_tmp354_ = param_array_name;
																																									if (_tmp354_ != NULL) {
																																										ValadocContentRun* _tmp355_;
																																										ValaList* _tmp356_;
																																										ValaList* _tmp357_;
																																										ValadocContentContentFactory* _tmp358_;
																																										const gchar* _tmp359_;
																																										gchar* _tmp360_;
																																										gchar* _tmp361_;
																																										ValadocContentText* _tmp362_;
																																										ValadocContentText* _tmp363_;
																																										_tmp355_ = current_run;
																																										_tmp356_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp355_);
																																										_tmp357_ = _tmp356_;
																																										_tmp358_ = self->priv->factory;
																																										_tmp359_ = param_array_name;
																																										_tmp360_ = g_strconcat (_tmp359_, ".length", NULL);
																																										_tmp361_ = _tmp360_;
																																										_tmp362_ = valadoc_content_content_factory_create_text (_tmp358_, _tmp361_);
																																										_tmp363_ = _tmp362_;
																																										vala_collection_add ((ValaCollection*) _tmp357_, (ValadocContentInline*) _tmp363_);
																																										_g_object_unref0 (_tmp363_);
																																										_g_free0 (_tmp361_);
																																									} else {
																																										ValadocContentRun* _tmp364_;
																																										ValaList* _tmp365_;
																																										ValaList* _tmp366_;
																																										ValadocContentContentFactory* _tmp367_;
																																										const gchar* _tmp368_;
																																										ValadocContentText* _tmp369_;
																																										ValadocContentText* _tmp370_;
																																										_tmp364_ = current_run;
																																										_tmp365_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp364_);
																																										_tmp366_ = _tmp365_;
																																										_tmp367_ = self->priv->factory;
																																										_tmp368_ = param_name;
																																										_tmp369_ = valadoc_content_content_factory_create_text (_tmp367_, _tmp368_);
																																										_tmp370_ = _tmp369_;
																																										vala_collection_add ((ValaCollection*) _tmp366_, (ValadocContentInline*) _tmp370_);
																																										_g_object_unref0 (_tmp370_);
																																									}
																																								}
																																								_tmp371_ = cname;
																																								if (_tmp371_ != NULL) {
																																									ValadocContentRun* _tmp372_;
																																									ValaList* _tmp373_;
																																									ValaList* _tmp374_;
																																									ValadocContentContentFactory* _tmp375_;
																																									ValadocContentText* _tmp376_;
																																									ValadocContentText* _tmp377_;
																																									ValadocTagletsLink* link = NULL;
																																									ValadocContentContentFactory* _tmp378_;
																																									ValadocContentTaglet* _tmp379_;
																																									ValadocTagletsLink* _tmp380_;
																																									ValadocTagletsLink* _tmp381_;
																																									const gchar* _tmp382_;
																																									ValadocContentRun* _tmp383_;
																																									ValaList* _tmp384_;
																																									ValaList* _tmp385_;
																																									ValadocTagletsLink* _tmp386_;
																																									_tmp372_ = run;
																																									_tmp373_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp372_);
																																									_tmp374_ = _tmp373_;
																																									_tmp375_ = self->priv->factory;
																																									_tmp376_ = valadoc_content_content_factory_create_text (_tmp375_, ".");
																																									_tmp377_ = _tmp376_;
																																									vala_collection_add ((ValaCollection*) _tmp374_, (ValadocContentInline*) _tmp377_);
																																									_g_object_unref0 (_tmp377_);
																																									_tmp378_ = self->priv->factory;
																																									_tmp379_ = valadoc_content_content_factory_create_taglet (_tmp378_, "link");
																																									_tmp380_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp379_, VALADOC_TAGLETS_TYPE_LINK) ? ((ValadocTagletsLink*) _tmp379_) : NULL;
																																									if (_tmp380_ == NULL) {
																																										_g_object_unref0 (_tmp379_);
																																									}
																																									link = _tmp380_;
																																									_tmp381_ = link;
																																									_tmp382_ = cname;
																																									valadoc_taglets_link_set_symbol_name (_tmp381_, _tmp382_);
																																									_tmp383_ = run;
																																									_tmp384_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp383_);
																																									_tmp385_ = _tmp384_;
																																									_tmp386_ = link;
																																									vala_collection_add ((ValaCollection*) _tmp385_, (ValadocContentInline*) _tmp386_);
																																									_g_object_unref0 (link);
																																								}
																																								_g_object_unref0 (current_run);
																																								_g_free0 (cname);
																																								_g_free0 (param_name);
																																								_g_free0 (param_array_name);
																																							}
																																							_tmp387_ = valadoc_gtkdoc_parser_next (self);
																																							_tmp388_ = _tmp387_;
																																							_valadoc_gtkdoc_token_unref0 (_tmp388_);
																																						} else {
																																							ValadocGtkdocToken* _tmp389_;
																																							ValadocGtkdocTokenType _tmp390_;
																																							_tmp389_ = self->priv->current;
																																							_tmp390_ = _tmp389_->type;
																																							if (_tmp390_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL) {
																																								ValadocContentRun* _tmp391_;
																																								ValaList* _tmp392_;
																																								ValaList* _tmp393_;
																																								ValadocGtkdocToken* _tmp394_;
																																								const gchar* _tmp395_;
																																								gchar* _tmp396_;
																																								gchar* _tmp397_;
																																								ValadocContentInline* _tmp398_;
																																								ValadocContentInline* _tmp399_;
																																								ValadocGtkdocToken* _tmp400_;
																																								ValadocGtkdocToken* _tmp401_;
																																								_tmp391_ = run;
																																								_tmp392_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp391_);
																																								_tmp393_ = _tmp392_;
																																								_tmp394_ = self->priv->current;
																																								_tmp395_ = _tmp394_->content;
																																								_tmp396_ = g_strconcat ("::", _tmp395_, NULL);
																																								_tmp397_ = _tmp396_;
																																								_tmp398_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp397_, TRUE);
																																								_tmp399_ = _tmp398_;
																																								vala_collection_add ((ValaCollection*) _tmp393_, _tmp399_);
																																								_g_object_unref0 (_tmp399_);
																																								_g_free0 (_tmp397_);
																																								_tmp400_ = valadoc_gtkdoc_parser_next (self);
																																								_tmp401_ = _tmp400_;
																																								_valadoc_gtkdoc_token_unref0 (_tmp401_);
																																							} else {
																																								ValadocGtkdocToken* _tmp402_;
																																								ValadocGtkdocTokenType _tmp403_;
																																								_tmp402_ = self->priv->current;
																																								_tmp403_ = _tmp402_->type;
																																								if (_tmp403_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY) {
																																									ValadocContentRun* _tmp404_;
																																									ValaList* _tmp405_;
																																									ValaList* _tmp406_;
																																									ValadocGtkdocToken* _tmp407_;
																																									const gchar* _tmp408_;
																																									gchar* _tmp409_;
																																									gchar* _tmp410_;
																																									ValadocContentInline* _tmp411_;
																																									ValadocContentInline* _tmp412_;
																																									ValadocGtkdocToken* _tmp413_;
																																									ValadocGtkdocToken* _tmp414_;
																																									_tmp404_ = run;
																																									_tmp405_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp404_);
																																									_tmp406_ = _tmp405_;
																																									_tmp407_ = self->priv->current;
																																									_tmp408_ = _tmp407_->content;
																																									_tmp409_ = g_strconcat (":", _tmp408_, NULL);
																																									_tmp410_ = _tmp409_;
																																									_tmp411_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp410_, TRUE);
																																									_tmp412_ = _tmp411_;
																																									vala_collection_add ((ValaCollection*) _tmp406_, _tmp412_);
																																									_g_object_unref0 (_tmp412_);
																																									_g_free0 (_tmp410_);
																																									_tmp413_ = valadoc_gtkdoc_parser_next (self);
																																									_tmp414_ = _tmp413_;
																																									_valadoc_gtkdoc_token_unref0 (_tmp414_);
																																								} else {
																																									ValadocGtkdocToken* _tmp415_;
																																									ValadocGtkdocTokenType _tmp416_;
																																									_tmp415_ = self->priv->current;
																																									_tmp416_ = _tmp415_->type;
																																									if (_tmp416_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST) {
																																										ValadocContentRun* _tmp417_;
																																										ValaList* _tmp418_;
																																										ValaList* _tmp419_;
																																										ValadocGtkdocToken* _tmp420_;
																																										const gchar* _tmp421_;
																																										ValadocContentInline* _tmp422_;
																																										ValadocContentInline* _tmp423_;
																																										ValadocGtkdocToken* _tmp424_;
																																										ValadocGtkdocToken* _tmp425_;
																																										_tmp417_ = run;
																																										_tmp418_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp417_);
																																										_tmp419_ = _tmp418_;
																																										_tmp420_ = self->priv->current;
																																										_tmp421_ = _tmp420_->content;
																																										_tmp422_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp421_, TRUE);
																																										_tmp423_ = _tmp422_;
																																										vala_collection_add ((ValaCollection*) _tmp419_, _tmp423_);
																																										_g_object_unref0 (_tmp423_);
																																										_tmp424_ = valadoc_gtkdoc_parser_next (self);
																																										_tmp425_ = _tmp424_;
																																										_valadoc_gtkdoc_token_unref0 (_tmp425_);
																																									} else {
																																										ValadocGtkdocToken* _tmp426_;
																																										ValadocGtkdocTokenType _tmp427_;
																																										_tmp426_ = self->priv->current;
																																										_tmp427_ = _tmp426_->type;
																																										if (_tmp427_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE) {
																																											ValadocContentRun* _tmp428_;
																																											ValaList* _tmp429_;
																																											ValaList* _tmp430_;
																																											ValadocGtkdocToken* _tmp431_;
																																											const gchar* _tmp432_;
																																											ValadocContentInline* _tmp433_;
																																											ValadocContentInline* _tmp434_;
																																											ValadocGtkdocToken* _tmp435_;
																																											ValadocGtkdocToken* _tmp436_;
																																											_tmp428_ = run;
																																											_tmp429_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp428_);
																																											_tmp430_ = _tmp429_;
																																											_tmp431_ = self->priv->current;
																																											_tmp432_ = _tmp431_->content;
																																											_tmp433_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp432_, TRUE);
																																											_tmp434_ = _tmp433_;
																																											vala_collection_add ((ValaCollection*) _tmp430_, _tmp434_);
																																											_g_object_unref0 (_tmp434_);
																																											_tmp435_ = valadoc_gtkdoc_parser_next (self);
																																											_tmp436_ = _tmp435_;
																																											_valadoc_gtkdoc_token_unref0 (_tmp436_);
																																										} else {
																																											gboolean _tmp437_ = FALSE;
																																											ValadocGtkdocToken* _tmp438_;
																																											ValadocGtkdocTokenType _tmp439_;
																																											_tmp438_ = self->priv->current;
																																											_tmp439_ = _tmp438_->type;
																																											if (_tmp439_ == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
																																												_tmp437_ = TRUE;
																																											} else {
																																												ValadocGtkdocToken* _tmp440_;
																																												ValadocGtkdocTokenType _tmp441_;
																																												_tmp440_ = self->priv->current;
																																												_tmp441_ = _tmp440_->type;
																																												_tmp437_ = _tmp441_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
																																											}
																																											if (_tmp437_) {
																																												ValadocContentRun* _tmp442_;
																																												ValadocGtkdocToken* _tmp443_;
																																												ValadocGtkdocToken* _tmp444_;
																																												_tmp442_ = run;
																																												valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp442_, " ");
																																												_tmp443_ = valadoc_gtkdoc_parser_next (self);
																																												_tmp444_ = _tmp443_;
																																												_valadoc_gtkdoc_token_unref0 (_tmp444_);
																																											} else {
																																												ValadocGtkdocToken* _tmp445_;
																																												ValadocGtkdocTokenType _tmp446_;
																																												_tmp445_ = self->priv->current;
																																												_tmp446_ = _tmp445_->type;
																																												if (_tmp446_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
																																													ValadocContentRun* _tmp447_;
																																													ValadocGtkdocToken* _tmp448_;
																																													const gchar* _tmp449_;
																																													ValadocGtkdocToken* _tmp450_;
																																													ValadocGtkdocToken* _tmp451_;
																																													_tmp447_ = run;
																																													_tmp448_ = self->priv->current;
																																													_tmp449_ = _tmp448_->content;
																																													valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp447_, _tmp449_);
																																													_tmp450_ = valadoc_gtkdoc_parser_next (self);
																																													_tmp451_ = _tmp450_;
																																													_valadoc_gtkdoc_token_unref0 (_tmp451_);
																																												} else {
																																													gboolean _tmp452_ = FALSE;
																																													ValadocGtkdocToken* _tmp453_;
																																													ValadocGtkdocTokenType _tmp454_;
																																													_tmp453_ = self->priv->current;
																																													_tmp454_ = _tmp453_->type;
																																													if (_tmp454_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
																																														gboolean _tmp455_;
																																														_tmp455_ = valadoc_gtkdoc_parser_ignore_current_xml_close (self);
																																														_tmp452_ = _tmp455_;
																																													} else {
																																														_tmp452_ = FALSE;
																																													}
																																													if (_tmp452_) {
																																														ValadocGtkdocToken* _tmp456_;
																																														ValadocGtkdocToken* _tmp457_;
																																														_tmp456_ = valadoc_gtkdoc_parser_next (self);
																																														_tmp457_ = _tmp456_;
																																														_valadoc_gtkdoc_token_unref0 (_tmp457_);
																																													} else {
																																														ValadocGtkdocToken* _tmp458_;
																																														ValadocGtkdocTokenType _tmp459_;
																																														_tmp458_ = self->priv->current;
																																														_tmp459_ = _tmp458_->type;
																																														if (_tmp459_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
																																															ValadocGtkdocToken* _tmp460_;
																																															ValadocGtkdocToken* _tmp461_;
																																															_tmp460_ = valadoc_gtkdoc_parser_next (self);
																																															_tmp461_ = _tmp460_;
																																															_valadoc_gtkdoc_token_unref0 (_tmp461_);
																																														} else {
																																															break;
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = run;
	return result;
}


static gchar* valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base, const gchar* path) {
	ValadocGtkdocParser * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocGtkdocParser*) base;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void valadoc_gtkdoc_parser_class_init (ValadocGtkdocParserClass * klass) {
	valadoc_gtkdoc_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocGtkdocParserPrivate));
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_parser_finalize;
}


static void valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init (ValadocResourceLocatorIface * iface) {
	valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = g_type_interface_peek_parent (iface);
	iface->resolve = (gchar* (*) (ValadocResourceLocator *, const gchar*)) valadoc_gtkdoc_parser_real_resolve;
}


static void valadoc_gtkdoc_parser_instance_init (ValadocGtkdocParser * self) {
	ValadocGtkdocScanner* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	self->priv = VALADOC_GTKDOC_PARSER_GET_PRIVATE (self);
	_tmp0_ = valadoc_gtkdoc_scanner_new ();
	self->priv->scanner = _tmp0_;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_);
	self->priv->stack = (ValaList*) _tmp2_;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp3_);
	self->priv->footnotes = (ValaList*) _tmp4_;
	self->priv->is_numeric_regex = NULL;
	self->priv->normalize_regex = NULL;
	self->priv->regex_source_lang = NULL;
	self->priv->id_registrar = NULL;
	self->priv->current_metadata = NULL;
}


static void valadoc_gtkdoc_parser_finalize (GObject * obj) {
	ValadocGtkdocParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_PARSER, ValadocGtkdocParser);
	_valadoc_gtkdoc_scanner_unref0 (self->priv->scanner);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	_vala_iterable_unref0 (self->priv->stack);
	_vala_iterable_unref0 (self->priv->footnotes);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_valadoc_api_tree_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->element);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (self->priv->is_numeric_regex);
	_g_regex_unref0 (self->priv->normalize_regex);
	_g_regex_unref0 (self->priv->regex_source_lang);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	_g_object_unref0 (self->priv->current_metadata);
	G_OBJECT_CLASS (valadoc_gtkdoc_parser_parent_class)->finalize (obj);
}


GType valadoc_gtkdoc_parser_get_type (void) {
	static volatile gsize valadoc_gtkdoc_parser_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocParser), 0, (GInstanceInitFunc) valadoc_gtkdoc_parser_instance_init, NULL };
		static const GInterfaceInfo valadoc_resource_locator_info = { (GInterfaceInitFunc) valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_gtkdoc_parser_type_id;
		valadoc_gtkdoc_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGtkdocParser", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_gtkdoc_parser_type_id, VALADOC_TYPE_RESOURCE_LOCATOR, &valadoc_resource_locator_info);
		g_once_init_leave (&valadoc_gtkdoc_parser_type_id__volatile, valadoc_gtkdoc_parser_type_id);
	}
	return valadoc_gtkdoc_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



