/* valastringliteral.c generated by valac, the Vala compiler
 * generated from valastringliteral.vala, do not modify */

/* valastringliteral.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_STRING_LITERAL_DUMMY_PROPERTY,
	VALA_STRING_LITERAL_LAST_PROPERTY
};
static GParamSpec* vala_string_literal_properties[VALA_STRING_LITERAL_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaStringLiteralPrivate {
	gchar* _value;
	gboolean _translate;
};


static gpointer vala_string_literal_parent_class = NULL;

#define VALA_STRING_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRING_LITERAL, ValaStringLiteralPrivate))
static void vala_string_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_string_literal_real_is_pure (ValaExpression* base);
static gboolean vala_string_literal_real_is_non_null (ValaExpression* base);
static gchar* vala_string_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_string_literal_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_string_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_string_literal_finalize (ValaCodeNode * obj);


/**
 * Creates a new string literal.
 *
 * @param value             the literal value
 * @param source_reference  reference to source code
 * @return                  newly created string literal
 */
ValaStringLiteral* vala_string_literal_construct (GType object_type, const gchar* value, ValaSourceReference* source_reference) {
	ValaStringLiteral* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (ValaStringLiteral*) vala_literal_construct (object_type);
	_tmp0_ = value;
	vala_string_literal_set_value (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaStringLiteral* vala_string_literal_new (const gchar* value, ValaSourceReference* source_reference) {
	return vala_string_literal_construct (VALA_TYPE_STRING_LITERAL, value, source_reference);
}


/**
 * Evaluates the literal string value.
 *
 * @return the unescaped string
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* vala_string_literal_eval (ValaStringLiteral* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* noquotes = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_value;
	_tmp2_ = self->priv->_value;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_substring (_tmp1_, (glong) 1, (glong) ((guint) (_tmp4_ - 2)));
	noquotes = _tmp5_;
	_tmp6_ = noquotes;
	_tmp7_ = g_strcompress (_tmp6_);
	result = _tmp7_;
	_g_free0 (noquotes);
	return result;
}


static void vala_string_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStringLiteral * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaStringLiteral*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_string_literal (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static gboolean vala_string_literal_real_is_pure (ValaExpression* base) {
	ValaStringLiteral * self;
	gboolean result = FALSE;
	self = (ValaStringLiteral*) base;
	result = TRUE;
	return result;
}


static gboolean vala_string_literal_real_is_non_null (ValaExpression* base) {
	ValaStringLiteral * self;
	gboolean result = FALSE;
	self = (ValaStringLiteral*) base;
	result = TRUE;
	return result;
}


static gchar* vala_string_literal_real_to_string (ValaCodeNode* base) {
	ValaStringLiteral * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValaStringLiteral*) base;
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean vala_string_literal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaStringLiteral * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	self = (ValaStringLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->string_type;
	_tmp8_ = vala_data_type_copy (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp9_);
	_vala_code_node_unref0 (_tmp9_);
	_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp11_ = _tmp10_;
	result = !_tmp11_;
	return result;
}


static void vala_string_literal_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaStringLiteral * self;
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	self = (ValaStringLiteral*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_string_literal ((ValaCodeVisitor*) _tmp0_, self);
	_tmp1_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp1_, (ValaExpression*) self);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaStringLiteral* vala_string_literal_get_format_literal (ValaExpression* expr) {
	ValaStringLiteral* result = NULL;
	ValaStringLiteral* format_literal = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	ValaMethodCall* call = NULL;
	ValaExpression* _tmp3_;
	ValaMethodCall* _tmp4_;
	ValaMethodCall* _tmp5_;
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = expr;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp0_) : NULL);
	format_literal = _tmp1_;
	_tmp2_ = format_literal;
	if (_tmp2_ != NULL) {
		result = format_literal;
		return result;
	}
	_tmp3_ = expr;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_CALL) ? ((ValaMethodCall*) _tmp3_) : NULL);
	call = _tmp4_;
	_tmp5_ = call;
	if (_tmp5_ != NULL) {
		ValaMethodCall* _tmp6_;
		ValaStringLiteral* _tmp7_;
		_tmp6_ = call;
		_tmp7_ = vala_method_call_get_format_literal (_tmp6_);
		result = _tmp7_;
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (format_literal);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (call);
	_vala_code_node_unref0 (format_literal);
	return result;
}


const gchar* vala_string_literal_get_value (ValaStringLiteral* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


void vala_string_literal_set_value (ValaStringLiteral* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp1_;
}


gboolean vala_string_literal_get_translate (ValaStringLiteral* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_translate;
	result = _tmp0_;
	return result;
}


void vala_string_literal_set_translate (ValaStringLiteral* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_translate = _tmp0_;
}


static void vala_string_literal_class_init (ValaStringLiteralClass * klass) {
	vala_string_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_string_literal_finalize;
	g_type_class_add_private (klass, sizeof (ValaStringLiteralPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_string_literal_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_string_literal_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression *)) vala_string_literal_real_is_non_null;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_string_literal_real_to_string;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_string_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_string_literal_real_emit;
}


static void vala_string_literal_instance_init (ValaStringLiteral * self) {
	self->priv = VALA_STRING_LITERAL_GET_PRIVATE (self);
}


static void vala_string_literal_finalize (ValaCodeNode * obj) {
	ValaStringLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_STRING_LITERAL, ValaStringLiteral);
	_g_free0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_string_literal_parent_class)->finalize (obj);
}


/**
 * Represents a string literal in the source code.
 */
GType vala_string_literal_get_type (void) {
	static volatile gsize vala_string_literal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_string_literal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStringLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_string_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStringLiteral), 0, (GInstanceInitFunc) vala_string_literal_instance_init, NULL };
		GType vala_string_literal_type_id;
		vala_string_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaStringLiteral", &g_define_type_info, 0);
		g_once_init_leave (&vala_string_literal_type_id__volatile, vala_string_literal_type_id);
	}
	return vala_string_literal_type_id__volatile;
}



