/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_UNARY_EXPRESSION_DUMMY_PROPERTY,
	VALA_UNARY_EXPRESSION_LAST_PROPERTY
};
static GParamSpec* vala_unary_expression_properties[VALA_UNARY_EXPRESSION_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};


static gpointer vala_unary_expression_parent_class = NULL;

#define VALA_UNARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionPrivate))
static void vala_unary_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static const gchar* vala_unary_expression_get_operator_string (ValaUnaryExpression* self);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self, ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self, ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self, ValaExpression* expr);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression* vala_unary_expression_construct (GType object_type, ValaUnaryOperator op, ValaExpression* _inner, ValaSourceReference* source) {
	ValaUnaryExpression* self = NULL;
	ValaUnaryOperator _tmp0_;
	ValaExpression* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	_tmp0_ = op;
	vala_unary_expression_set_operator (self, _tmp0_);
	_tmp1_ = _inner;
	vala_unary_expression_set_inner (self, _tmp1_);
	_tmp2_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	return self;
}


ValaUnaryExpression* vala_unary_expression_new (ValaUnaryOperator op, ValaExpression* _inner, ValaSourceReference* source) {
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}


static void vala_unary_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaUnaryExpression * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_unary_expression (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_unary_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static void vala_unary_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_unary_expression_set_inner (self, _tmp3_);
	}
}


static const gchar* vala_unary_expression_get_operator_string (ValaUnaryExpression* self) {
	const gchar* result = NULL;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base) {
	ValaUnaryExpression * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = vala_unary_expression_get_operator_string (self);
	_tmp1_ = self->priv->_inner;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_unary_expression_real_is_constant (ValaExpression* base) {
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	gboolean _tmp18_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaField* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValaField* _tmp12_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp9_) : NULL);
		field = _tmp10_;
		_tmp12_ = field;
		if (_tmp12_ != NULL) {
			ValaField* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp13_ = field;
			_tmp14_ = vala_field_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_vala_code_node_unref0 (field);
			return result;
		} else {
			result = FALSE;
			_vala_code_node_unref0 (field);
			return result;
		}
		_vala_code_node_unref0 (field);
	}
	_tmp16_ = vala_unary_expression_get_inner (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_expression_is_constant (_tmp17_);
	result = _tmp18_;
	return result;
}


static gboolean vala_unary_expression_real_is_pure (ValaExpression* base) {
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	gboolean _tmp5_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_expression_is_pure (_tmp4_);
	result = _tmp5_;
	return result;
}


static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	gboolean _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sym;
	_tmp3_ = vala_expression_is_accessible (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaStruct* st = NULL;
	ValaDataType* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	ValaStruct* _tmp6_;
	gboolean _tmp7_ = FALSE;
	ValaStruct* _tmp8_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_data_type_get_data_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = type;
	_tmp4_ = vala_data_type_get_data_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp6_;
	_tmp8_ = st;
	_tmp9_ = vala_struct_is_integer_type (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = TRUE;
	} else {
		ValaStruct* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = st;
		_tmp11_ = vala_struct_is_floating_type (_tmp10_);
		_tmp7_ = _tmp11_;
	}
	result = _tmp7_;
	_vala_code_node_unref0 (st);
	return result;
}


static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaStruct* st = NULL;
	ValaDataType* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	ValaStruct* _tmp6_;
	ValaStruct* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_data_type_get_data_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = type;
	_tmp4_ = vala_data_type_get_data_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp6_;
	_tmp7_ = st;
	_tmp8_ = vala_struct_is_integer_type (_tmp7_);
	result = _tmp8_;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self, ValaExpression* expr) {
	ValaMemberAccess* result = NULL;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = expr;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp1_;
		ValaMemberAccess* _tmp2_;
		_tmp1_ = expr;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}


static gboolean vala_unary_expression_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaCodeContext* _tmp20_;
	gboolean _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	gboolean _tmp38_ = FALSE;
	ValaUnaryOperator _tmp39_;
	gboolean _tmp206_;
	gboolean _tmp207_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = context;
	_tmp21_ = vala_code_node_check ((ValaCodeNode*) _tmp19_, _tmp20_);
	if (!_tmp21_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_unary_expression_get_inner (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_expression_get_value_type (_tmp23_);
	_tmp25_ = _tmp24_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_unary_expression_get_inner (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_unary_expression_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_full_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (_tmp29_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		result = FALSE;
		return result;
	}
	_tmp39_ = self->priv->_operator;
	if (_tmp39_ == VALA_UNARY_OPERATOR_PLUS) {
		_tmp38_ = TRUE;
	} else {
		ValaUnaryOperator _tmp40_;
		_tmp40_ = self->priv->_operator;
		_tmp38_ = _tmp40_ == VALA_UNARY_OPERATOR_MINUS;
	}
	if (_tmp38_) {
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		gboolean _tmp45_;
		ValaExpression* _tmp56_;
		ValaExpression* _tmp57_;
		ValaDataType* _tmp58_;
		ValaDataType* _tmp59_;
		_tmp41_ = vala_unary_expression_get_inner (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_expression_get_value_type (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_unary_expression_is_numeric_type (self, _tmp44_);
		if (!_tmp45_) {
			ValaSourceReference* _tmp46_;
			ValaSourceReference* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaDataType* _tmp50_;
			ValaDataType* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_unary_expression_get_inner (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_expression_get_value_type (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_code_node_to_string ((ValaCodeNode*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strdup_printf ("Operator not supported for `%s'", _tmp53_);
			_tmp55_ = _tmp54_;
			vala_report_error (_tmp47_, _tmp55_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			result = FALSE;
			return result;
		}
		_tmp56_ = vala_unary_expression_get_inner (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_expression_get_value_type (_tmp57_);
		_tmp59_ = _tmp58_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp59_);
	} else {
		ValaUnaryOperator _tmp60_;
		_tmp60_ = self->priv->_operator;
		if (_tmp60_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			ValaCodeContext* _tmp65_;
			ValaSemanticAnalyzer* _tmp66_;
			ValaSemanticAnalyzer* _tmp67_;
			ValaDataType* _tmp68_;
			gboolean _tmp69_;
			ValaExpression* _tmp80_;
			ValaExpression* _tmp81_;
			ValaDataType* _tmp82_;
			ValaDataType* _tmp83_;
			_tmp61_ = vala_unary_expression_get_inner (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_value_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = context;
			_tmp66_ = vala_code_context_get_analyzer (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _tmp67_->bool_type;
			_tmp69_ = vala_data_type_compatible (_tmp64_, _tmp68_);
			if (!_tmp69_) {
				ValaSourceReference* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaExpression* _tmp72_;
				ValaExpression* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_unary_expression_get_inner (self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_expression_get_value_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_code_node_to_string ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strdup_printf ("Operator not supported for `%s'", _tmp77_);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp71_, _tmp79_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				result = FALSE;
				return result;
			}
			_tmp80_ = vala_unary_expression_get_inner (self);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_expression_get_value_type (_tmp81_);
			_tmp83_ = _tmp82_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp83_);
		} else {
			ValaUnaryOperator _tmp84_;
			_tmp84_ = self->priv->_operator;
			if (_tmp84_ == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
				gboolean _tmp85_ = FALSE;
				ValaExpression* _tmp86_;
				ValaExpression* _tmp87_;
				ValaDataType* _tmp88_;
				ValaDataType* _tmp89_;
				gboolean _tmp90_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				ValaDataType* _tmp107_;
				ValaDataType* _tmp108_;
				_tmp86_ = vala_unary_expression_get_inner (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_expression_get_value_type (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = vala_unary_expression_is_integer_type (self, _tmp89_);
				if (!_tmp90_) {
					ValaExpression* _tmp91_;
					ValaExpression* _tmp92_;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					_tmp91_ = vala_unary_expression_get_inner (self);
					_tmp92_ = _tmp91_;
					_tmp93_ = vala_expression_get_value_type (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp85_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, VALA_TYPE_ENUM_VALUE_TYPE);
				} else {
					_tmp85_ = FALSE;
				}
				if (_tmp85_) {
					ValaSourceReference* _tmp95_;
					ValaSourceReference* _tmp96_;
					ValaExpression* _tmp97_;
					ValaExpression* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_unary_expression_get_inner (self);
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_expression_get_value_type (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_code_node_to_string ((ValaCodeNode*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = g_strdup_printf ("Operator not supported for `%s'", _tmp102_);
					_tmp104_ = _tmp103_;
					vala_report_error (_tmp96_, _tmp104_);
					_g_free0 (_tmp104_);
					_g_free0 (_tmp102_);
					result = FALSE;
					return result;
				}
				_tmp105_ = vala_unary_expression_get_inner (self);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_expression_get_value_type (_tmp106_);
				_tmp108_ = _tmp107_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp108_);
			} else {
				gboolean _tmp109_ = FALSE;
				ValaUnaryOperator _tmp110_;
				_tmp110_ = self->priv->_operator;
				if (_tmp110_ == VALA_UNARY_OPERATOR_INCREMENT) {
					_tmp109_ = TRUE;
				} else {
					ValaUnaryOperator _tmp111_;
					_tmp111_ = self->priv->_operator;
					_tmp109_ = _tmp111_ == VALA_UNARY_OPERATOR_DECREMENT;
				}
				if (_tmp109_) {
					ValaExpression* _tmp112_;
					ValaExpression* _tmp113_;
					ValaDataType* _tmp114_;
					ValaDataType* _tmp115_;
					gboolean _tmp116_;
					ValaMemberAccess* ma = NULL;
					ValaExpression* _tmp127_;
					ValaExpression* _tmp128_;
					ValaMemberAccess* _tmp129_;
					ValaMemberAccess* _tmp130_;
					ValaMemberAccess* old_value = NULL;
					ValaMemberAccess* _tmp133_;
					ValaExpression* _tmp134_;
					ValaExpression* _tmp135_;
					ValaMemberAccess* _tmp136_;
					const gchar* _tmp137_;
					const gchar* _tmp138_;
					ValaExpression* _tmp139_;
					ValaExpression* _tmp140_;
					ValaSourceReference* _tmp141_;
					ValaSourceReference* _tmp142_;
					ValaMemberAccess* _tmp143_;
					ValaBinaryOperator _tmp144_ = 0;
					ValaUnaryOperator _tmp145_;
					ValaBinaryExpression* bin = NULL;
					ValaMemberAccess* _tmp146_;
					ValaIntegerLiteral* _tmp147_;
					ValaIntegerLiteral* _tmp148_;
					ValaSourceReference* _tmp149_;
					ValaSourceReference* _tmp150_;
					ValaBinaryExpression* _tmp151_;
					ValaBinaryExpression* _tmp152_;
					ValaAssignment* assignment = NULL;
					ValaMemberAccess* _tmp153_;
					ValaBinaryExpression* _tmp154_;
					ValaSourceReference* _tmp155_;
					ValaSourceReference* _tmp156_;
					ValaAssignment* _tmp157_;
					ValaAssignment* _tmp158_;
					ValaDataType* _tmp159_;
					ValaDataType* _tmp160_;
					ValaCodeContext* _tmp161_;
					ValaSemanticAnalyzer* _tmp162_;
					ValaSemanticAnalyzer* _tmp163_;
					ValaList* _tmp164_;
					ValaCodeNode* _tmp165_;
					ValaCodeNode* _tmp166_;
					ValaAssignment* _tmp167_;
					ValaAssignment* _tmp168_;
					ValaCodeContext* _tmp169_;
					_tmp112_ = vala_unary_expression_get_inner (self);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_expression_get_value_type (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_unary_expression_is_integer_type (self, _tmp115_);
					if (!_tmp116_) {
						ValaSourceReference* _tmp117_;
						ValaSourceReference* _tmp118_;
						ValaExpression* _tmp119_;
						ValaExpression* _tmp120_;
						ValaDataType* _tmp121_;
						ValaDataType* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp118_ = _tmp117_;
						_tmp119_ = vala_unary_expression_get_inner (self);
						_tmp120_ = _tmp119_;
						_tmp121_ = vala_expression_get_value_type (_tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = vala_code_node_to_string ((ValaCodeNode*) _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = g_strdup_printf ("Operator not supported for `%s'", _tmp124_);
						_tmp126_ = _tmp125_;
						vala_report_error (_tmp118_, _tmp126_);
						_g_free0 (_tmp126_);
						_g_free0 (_tmp124_);
						result = FALSE;
						return result;
					}
					_tmp127_ = vala_unary_expression_get_inner (self);
					_tmp128_ = _tmp127_;
					_tmp129_ = vala_unary_expression_find_member_access (self, _tmp128_);
					ma = _tmp129_;
					_tmp130_ = ma;
					if (_tmp130_ == NULL) {
						ValaSourceReference* _tmp131_;
						ValaSourceReference* _tmp132_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp132_ = _tmp131_;
						vala_report_error (_tmp132_, "Prefix operators not supported for this expression");
						result = FALSE;
						_vala_code_node_unref0 (ma);
						return result;
					}
					_tmp133_ = ma;
					_tmp134_ = vala_member_access_get_inner (_tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = ma;
					_tmp137_ = vala_member_access_get_member_name (_tmp136_);
					_tmp138_ = _tmp137_;
					_tmp139_ = vala_unary_expression_get_inner (self);
					_tmp140_ = _tmp139_;
					_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = vala_member_access_new (_tmp135_, _tmp138_, _tmp142_);
					old_value = _tmp143_;
					_tmp145_ = self->priv->_operator;
					if (_tmp145_ == VALA_UNARY_OPERATOR_INCREMENT) {
						_tmp144_ = VALA_BINARY_OPERATOR_PLUS;
					} else {
						_tmp144_ = VALA_BINARY_OPERATOR_MINUS;
					}
					_tmp146_ = old_value;
					_tmp147_ = vala_integer_literal_new ("1", NULL);
					_tmp148_ = _tmp147_;
					_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp150_ = _tmp149_;
					_tmp151_ = vala_binary_expression_new (_tmp144_, (ValaExpression*) _tmp146_, (ValaExpression*) _tmp148_, _tmp150_);
					_tmp152_ = _tmp151_;
					_vala_code_node_unref0 (_tmp148_);
					bin = _tmp152_;
					_tmp153_ = ma;
					_tmp154_ = bin;
					_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp156_ = _tmp155_;
					_tmp157_ = vala_assignment_new ((ValaExpression*) _tmp153_, (ValaExpression*) _tmp154_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp156_);
					assignment = _tmp157_;
					_tmp158_ = assignment;
					_tmp159_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp160_ = _tmp159_;
					vala_expression_set_target_type ((ValaExpression*) _tmp158_, _tmp160_);
					_tmp161_ = context;
					_tmp162_ = vala_code_context_get_analyzer (_tmp161_);
					_tmp163_ = _tmp162_;
					_tmp164_ = _tmp163_->replaced_nodes;
					vala_collection_add ((ValaCollection*) _tmp164_, (ValaCodeNode*) self);
					_tmp165_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp166_ = _tmp165_;
					_tmp167_ = assignment;
					vala_code_node_replace_expression (_tmp166_, (ValaExpression*) self, (ValaExpression*) _tmp167_);
					_tmp168_ = assignment;
					_tmp169_ = context;
					vala_code_node_check ((ValaCodeNode*) _tmp168_, _tmp169_);
					result = TRUE;
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (bin);
					_vala_code_node_unref0 (old_value);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp170_ = FALSE;
					ValaUnaryOperator _tmp171_;
					_tmp171_ = self->priv->_operator;
					if (_tmp171_ == VALA_UNARY_OPERATOR_REF) {
						_tmp170_ = TRUE;
					} else {
						ValaUnaryOperator _tmp172_;
						_tmp172_ = self->priv->_operator;
						_tmp170_ = _tmp172_ == VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp170_) {
						ValaElementAccess* ea = NULL;
						ValaExpression* _tmp173_;
						ValaExpression* _tmp174_;
						ValaElementAccess* _tmp175_;
						gboolean _tmp176_ = FALSE;
						gboolean _tmp177_ = FALSE;
						gboolean _tmp178_ = FALSE;
						ValaExpression* _tmp179_;
						ValaExpression* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaSymbol* _tmp182_;
						_tmp173_ = vala_unary_expression_get_inner (self);
						_tmp174_ = _tmp173_;
						_tmp175_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp174_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp174_) : NULL);
						ea = _tmp175_;
						_tmp179_ = vala_unary_expression_get_inner (self);
						_tmp180_ = _tmp179_;
						_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
						_tmp182_ = _tmp181_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, VALA_TYPE_FIELD)) {
							_tmp178_ = TRUE;
						} else {
							ValaExpression* _tmp183_;
							ValaExpression* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							_tmp183_ = vala_unary_expression_get_inner (self);
							_tmp184_ = _tmp183_;
							_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
							_tmp186_ = _tmp185_;
							_tmp178_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp186_, VALA_TYPE_PARAMETER);
						}
						if (_tmp178_) {
							_tmp177_ = TRUE;
						} else {
							ValaExpression* _tmp187_;
							ValaExpression* _tmp188_;
							ValaSymbol* _tmp189_;
							ValaSymbol* _tmp190_;
							_tmp187_ = vala_unary_expression_get_inner (self);
							_tmp188_ = _tmp187_;
							_tmp189_ = vala_expression_get_symbol_reference (_tmp188_);
							_tmp190_ = _tmp189_;
							_tmp177_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, VALA_TYPE_LOCAL_VARIABLE);
						}
						if (_tmp177_) {
							_tmp176_ = TRUE;
						} else {
							gboolean _tmp191_ = FALSE;
							ValaElementAccess* _tmp192_;
							_tmp192_ = ea;
							if (_tmp192_ != NULL) {
								ValaElementAccess* _tmp193_;
								ValaExpression* _tmp194_;
								ValaExpression* _tmp195_;
								ValaDataType* _tmp196_;
								ValaDataType* _tmp197_;
								_tmp193_ = ea;
								_tmp194_ = vala_element_access_get_container (_tmp193_);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_expression_get_value_type (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp191_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp197_, VALA_TYPE_ARRAY_TYPE);
							} else {
								_tmp191_ = FALSE;
							}
							_tmp176_ = _tmp191_;
						}
						if (_tmp176_) {
							ValaExpression* _tmp198_;
							ValaExpression* _tmp199_;
							ValaDataType* _tmp200_;
							ValaDataType* _tmp201_;
							vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
							_tmp198_ = vala_unary_expression_get_inner (self);
							_tmp199_ = _tmp198_;
							_tmp200_ = vala_expression_get_value_type (_tmp199_);
							_tmp201_ = _tmp200_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp201_);
						} else {
							ValaSourceReference* _tmp202_;
							ValaSourceReference* _tmp203_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp203_ = _tmp202_;
							vala_report_error (_tmp203_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
							result = FALSE;
							_vala_code_node_unref0 (ea);
							return result;
						}
						_vala_code_node_unref0 (ea);
					} else {
						ValaSourceReference* _tmp204_;
						ValaSourceReference* _tmp205_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp205_ = _tmp204_;
						vala_report_error (_tmp205_, "internal error: unsupported unary operator");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp206_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp207_ = _tmp206_;
	result = !_tmp207_;
	return result;
}


static void vala_unary_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp3_;
	ValaCodeGenerator* _tmp4_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = codegen;
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) _tmp3_, self);
	_tmp4_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp4_, (ValaExpression*) self);
}


static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp3_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaLocalVariable* _tmp10_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaParameter* _tmp15_;
		ValaLocalVariable* _tmp16_;
		gboolean _tmp19_ = FALSE;
		ValaParameter* _tmp20_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp9_) : NULL);
		local = _tmp10_;
		_tmp11_ = vala_unary_expression_get_inner (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp14_) : NULL);
		param = _tmp15_;
		_tmp16_ = local;
		if (_tmp16_ != NULL) {
			ValaCollection* _tmp17_;
			ValaLocalVariable* _tmp18_;
			_tmp17_ = collection;
			_tmp18_ = local;
			vala_collection_add (_tmp17_, (ValaVariable*) _tmp18_);
		}
		_tmp20_ = param;
		if (_tmp20_ != NULL) {
			ValaParameter* _tmp21_;
			ValaParameterDirection _tmp22_;
			ValaParameterDirection _tmp23_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_direction (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp23_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaCollection* _tmp24_;
			ValaParameter* _tmp25_;
			_tmp24_ = collection;
			_tmp25_ = param;
			vala_collection_add (_tmp24_, (ValaVariable*) _tmp25_);
		}
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	}
}


static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		ValaCollection* _tmp3_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = collection;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, _tmp3_);
	}
}


ValaUnaryOperator vala_unary_expression_get_operator (ValaUnaryExpression* self) {
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void vala_unary_expression_set_operator (ValaUnaryExpression* self, ValaUnaryOperator value) {
	ValaUnaryOperator _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_operator = _tmp0_;
}


ValaExpression* vala_unary_expression_get_inner (ValaUnaryExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void vala_unary_expression_set_inner (ValaUnaryExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp1_;
	_tmp2_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_unary_expression_class_init (ValaUnaryExpressionClass * klass) {
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaUnaryExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}


static void vala_unary_expression_instance_init (ValaUnaryExpression * self) {
	self->priv = VALA_UNARY_EXPRESSION_GET_PRIVATE (self);
}


static void vala_unary_expression_finalize (ValaCodeNode * obj) {
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
GType vala_unary_expression_get_type (void) {
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}


GType vala_unary_operator_get_type (void) {
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}



