/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
enum  {
	VALA_COMPILER_0_PROPERTY,
	VALA_COMPILER_NUM_PROPERTIES
};
static GParamSpec* vala_compiler_properties[VALA_COMPILER_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args;
static gchar* vala_compiler_run_args = NULL;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, 
                                      const gchar* nick, 
                                      const gchar* blurb, 
                                      GType object_type, 
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, 
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, 
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_parse_color (const gchar* option_name, 
                                           const gchar* val, 
                                           void* data, 
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, 
                          int length);
static gchar** _vala_array_dup2 (gchar** self, 
                          int length);
static gchar** _vala_array_dup3 (gchar** self, 
                          int length);
static gchar** _vala_array_dup4 (gchar** self, 
                          int length);
static gchar** _vala_array_dup5 (gchar** self, 
                          int length);
static gint vala_compiler_run_source (gchar** args, 
                               int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, 
                  GPid pid, 
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid, 
                                     gint status, 
                                     gpointer self);
static gint vala_compiler_main (gchar** args, 
                         int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[59] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executeable", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gboolean
vala_compiler_option_parse_color (const gchar* option_name, 
                                  const gchar* val, 
                                  void* data, 
                                  GError** error)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error_ = _tmp3_;
				if (_inner_error_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gint
vala_compiler_quit (ValaCompiler* self)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp12_ = vala_compiler_fatal_warnings;
		if (!_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = vala_report_get_warnings (_tmp15_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp16_;
		_tmp16_ = vala_compiler_quiet_mode;
		if (!_tmp16_) {
			FILE* _tmp17_;
			ValaCodeContext* _tmp18_;
			ValaReport* _tmp19_;
			ValaReport* _tmp20_;
			_tmp17_ = stdout;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_report (_tmp18_);
			_tmp20_ = _tmp19_;
			fprintf (_tmp17_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp20_));
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_quiet_mode;
		if (!_tmp21_) {
			FILE* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			ValaCodeContext* _tmp26_;
			ValaReport* _tmp27_;
			ValaReport* _tmp28_;
			_tmp22_ = stdout;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->context;
			_tmp27_ = vala_code_context_get_report (_tmp26_);
			_tmp28_ = _tmp27_;
			fprintf (_tmp22_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp25_), vala_report_get_warnings (_tmp28_));
		}
		result = 1;
		return result;
	}
}


static gint
string_last_index_of_char (const gchar* self, 
                           gunichar c, 
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar**
_vala_array_dup1 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup2 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup3 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup4 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup5 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
string_contains (const gchar* self, 
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint
vala_compiler_run (ValaCompiler* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	ValaReportColored _tmp3_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	ValaCodeContext* _tmp30_;
	gboolean _tmp31_;
	ValaCodeContext* _tmp32_;
	gboolean _tmp33_;
	ValaCodeContext* _tmp34_;
	gboolean _tmp35_;
	ValaCodeContext* _tmp36_;
	gboolean _tmp37_;
	ValaCodeContext* _tmp38_;
	gboolean _tmp39_;
	ValaCodeContext* _tmp40_;
	gboolean _tmp41_;
	ValaCodeContext* _tmp42_;
	gboolean _tmp43_;
	ValaCodeContext* _tmp44_;
	gboolean _tmp45_;
	ValaCodeContext* _tmp46_;
	ValaReport* _tmp47_;
	ValaReport* _tmp48_;
	gboolean _tmp49_;
	ValaCodeContext* _tmp50_;
	ValaReport* _tmp51_;
	ValaReport* _tmp52_;
	gboolean _tmp53_;
	ValaCodeContext* _tmp54_;
	gboolean _tmp55_;
	ValaCodeContext* _tmp56_;
	gboolean _tmp57_;
	ValaCodeContext* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_;
	ValaCodeContext* _tmp63_;
	gboolean _tmp64_;
	ValaCodeContext* _tmp65_;
	const gchar* _tmp66_;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_;
	ValaCodeContext* _tmp70_;
	gboolean _tmp71_;
	ValaCodeContext* _tmp72_;
	const gchar* _tmp73_;
	ValaCodeContext* _tmp74_;
	const gchar* _tmp75_;
	ValaCodeContext* _tmp76_;
	const gchar* _tmp77_;
	ValaCodeContext* _tmp78_;
	const gchar* _tmp79_;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp81_;
	const gchar* _tmp83_;
	const gchar* _tmp91_;
	ValaCodeContext* _tmp100_;
	gchar** _tmp101_;
	gint _tmp101__length1;
	gchar** _tmp102_;
	gint _tmp102__length1;
	ValaCodeContext* _tmp103_;
	gboolean _tmp104_;
	ValaCodeContext* _tmp105_;
	gchar** _tmp106_;
	gint _tmp106__length1;
	gchar** _tmp107_;
	gint _tmp107__length1;
	ValaCodeContext* _tmp108_;
	gchar** _tmp109_;
	gint _tmp109__length1;
	gchar** _tmp110_;
	gint _tmp110__length1;
	ValaCodeContext* _tmp111_;
	gboolean _tmp112_;
	ValaCodeContext* _tmp113_;
	gboolean _tmp114_;
	ValaCodeContext* _tmp115_;
	gboolean _tmp116_;
	gboolean _tmp117_ = FALSE;
	gboolean _tmp118_;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	const gchar* _tmp122_;
	gboolean _tmp130_;
	const gchar* _tmp131_;
	ValaCodeContext* _tmp132_;
	gboolean _tmp133_;
	ValaCodeContext* _tmp134_;
	const gchar* _tmp135_;
	ValaCodeContext* _tmp136_;
	gboolean _tmp137_;
	gchar** _tmp138_;
	gint _tmp138__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp150_ = FALSE;
	const gchar* _tmp151_;
	ValaCodeContext* _tmp153_;
	gint _tmp154_;
	ValaCodeContext* _tmp155_;
	gint _tmp156_;
	ValaCodeContext* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	gboolean _tmp168_;
	gchar** _tmp171_;
	gint _tmp171__length1;
	gchar** _tmp176_;
	gint _tmp176__length1;
	ValaCodeContext* _tmp187_;
	gchar** _tmp188_;
	gint _tmp188__length1;
	gchar** _tmp189_;
	gint _tmp189__length1;
	ValaCodeContext* _tmp190_;
	gchar** _tmp191_;
	gint _tmp191__length1;
	gchar** _tmp192_;
	gint _tmp192__length1;
	gboolean _tmp193_ = FALSE;
	ValaCodeContext* _tmp194_;
	ValaReport* _tmp195_;
	ValaReport* _tmp196_;
	ValaCodeContext* _tmp202_;
	ValaGDBusServerModule* _tmp203_;
	ValaGDBusServerModule* _tmp204_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp205_;
	gint _tmp205__length1;
	gboolean _tmp212_ = FALSE;
	gboolean _tmp213_;
	gboolean _tmp217_ = FALSE;
	ValaCodeContext* _tmp218_;
	ValaReport* _tmp219_;
	ValaReport* _tmp220_;
	ValaParser* parser = NULL;
	ValaParser* _tmp226_;
	ValaParser* _tmp227_;
	ValaCodeContext* _tmp228_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp229_;
	ValaGenieParser* _tmp230_;
	ValaCodeContext* _tmp231_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp232_;
	ValaGirParser* _tmp233_;
	ValaCodeContext* _tmp234_;
	gboolean _tmp235_ = FALSE;
	ValaCodeContext* _tmp236_;
	ValaReport* _tmp237_;
	ValaReport* _tmp238_;
	const gchar* _tmp244_;
	ValaCodeContext* _tmp249_;
	gboolean _tmp250_ = FALSE;
	ValaCodeContext* _tmp251_;
	ValaReport* _tmp252_;
	ValaReport* _tmp253_;
	gboolean _tmp259_ = FALSE;
	gboolean _tmp260_ = FALSE;
	gboolean _tmp261_;
	const gchar* _tmp269_;
	gboolean _tmp274_ = FALSE;
	ValaCodeContext* _tmp275_;
	ValaReport* _tmp276_;
	ValaReport* _tmp277_;
	ValaCodeContext* _tmp283_;
	ValaCodeGenerator* _tmp284_;
	ValaCodeGenerator* _tmp285_;
	ValaCodeContext* _tmp286_;
	gboolean _tmp287_ = FALSE;
	ValaCodeContext* _tmp288_;
	ValaReport* _tmp289_;
	ValaReport* _tmp290_;
	gboolean _tmp296_ = FALSE;
	const gchar* _tmp297_;
	const gchar* _tmp301_;
	const gchar* _tmp349_;
	const gchar* _tmp362_;
	const gchar* _tmp383_;
	gboolean _tmp386_ = FALSE;
	ValaCodeContext* _tmp387_;
	ValaReport* _tmp388_;
	ValaReport* _tmp389_;
	gboolean _tmp395_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_colored_output;
	if (_tmp2_) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp3_ = vala_compiler_colored_output;
	if (_tmp3_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp4_;
		_tmp5_ = env_colors;
		if (_tmp5_ != NULL) {
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			const gchar* _tmp9_;
			ValaReportColored _tmp10_;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = env_colors;
			_tmp10_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp8_, _tmp9_, _tmp10_);
		} else {
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			ValaReportColored _tmp14_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp13_, VALA_COMPILER_DEFAULT_COLORS, _tmp14_);
		}
	}
	_tmp17_ = vala_compiler_ccode_only;
	if (!_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = vala_compiler_compile_only;
		_tmp16_ = !_tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_;
		_tmp19_ = vala_compiler_output;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		_tmp20_ = vala_compiler_sources;
		_tmp20__length1 = _vala_array_length (vala_compiler_sources);
		_tmp21_ = _tmp20_[0];
		if (string_last_index_of_char (_tmp21_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp22_ = vala_compiler_sources;
			_tmp22__length1 = _vala_array_length (vala_compiler_sources);
			_tmp23_ = _tmp22_[0];
			dot = string_last_index_of_char (_tmp23_, (gunichar) '.', 0);
			_tmp24_ = vala_compiler_sources;
			_tmp24__length1 = _vala_array_length (vala_compiler_sources);
			_tmp25_ = _tmp24_[0];
			_tmp26_ = dot;
			_tmp27_ = string_substring (_tmp25_, (glong) 0, (glong) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_path_get_basename (_tmp28_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp29_;
			_g_free0 (_tmp28_);
		}
	}
	_tmp30_ = self->priv->context;
	_tmp31_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp30_, !_tmp31_);
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp32_, _tmp33_);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp36_, !_tmp37_);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->context;
	_tmp43_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_code_context_get_report (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp48_, !_tmp49_);
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_code_context_get_report (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp52_, !_tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp56_, !_tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp58_, _tmp59_);
	_tmp61_ = vala_compiler_ccode_only;
	if (_tmp61_) {
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp62_ = vala_compiler_cc_options;
		_tmp62__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp60_ = _tmp62_ != NULL;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp65_, _tmp66_);
	_tmp68_ = vala_compiler_header_filename;
	if (_tmp68_ == NULL) {
		gboolean _tmp69_;
		_tmp69_ = vala_compiler_use_header;
		_tmp67_ = _tmp69_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp70_ = self->priv->context;
	_tmp71_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->context;
	_tmp77_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_compiler_output;
	vala_code_context_set_output (_tmp78_, _tmp79_);
	_tmp81_ = vala_compiler_output;
	if (_tmp81_ != NULL) {
		gboolean _tmp82_;
		_tmp82_ = vala_compiler_ccode_only;
		_tmp80_ = _tmp82_;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp83_ = vala_compiler_basedir;
	if (_tmp83_ == NULL) {
		ValaCodeContext* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		_tmp84_ = self->priv->context;
		_tmp85_ = vala_code_context_realpath (".");
		_tmp86_ = _tmp85_;
		vala_code_context_set_basedir (_tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
	} else {
		ValaCodeContext* _tmp87_;
		const gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp87_ = self->priv->context;
		_tmp88_ = vala_compiler_basedir;
		_tmp89_ = vala_code_context_realpath (_tmp88_);
		_tmp90_ = _tmp89_;
		vala_code_context_set_basedir (_tmp87_, _tmp90_);
		_g_free0 (_tmp90_);
	}
	_tmp91_ = vala_compiler_directory;
	if (_tmp91_ != NULL) {
		ValaCodeContext* _tmp92_;
		const gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp92_ = self->priv->context;
		_tmp93_ = vala_compiler_directory;
		_tmp94_ = vala_code_context_realpath (_tmp93_);
		_tmp95_ = _tmp94_;
		vala_code_context_set_directory (_tmp92_, _tmp95_);
		_g_free0 (_tmp95_);
	} else {
		ValaCodeContext* _tmp96_;
		ValaCodeContext* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		_tmp96_ = self->priv->context;
		_tmp97_ = self->priv->context;
		_tmp98_ = vala_code_context_get_basedir (_tmp97_);
		_tmp99_ = _tmp98_;
		vala_code_context_set_directory (_tmp96_, _tmp99_);
	}
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_compiler_vapi_directories;
	_tmp101__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp102_ = (_tmp101_ != NULL) ? _vala_array_dup1 (_tmp101_, _tmp101__length1) : ((gpointer) _tmp101_);
	_tmp102__length1 = _tmp101__length1;
	_tmp100_->vapi_directories = (_vala_array_free (_tmp100_->vapi_directories, _tmp100_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp100_->vapi_directories = _tmp102_;
	_tmp100_->vapi_directories_length1 = _tmp102__length1;
	_tmp103_ = self->priv->context;
	_tmp104_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp103_, _tmp104_);
	_tmp105_ = self->priv->context;
	_tmp106_ = vala_compiler_gir_directories;
	_tmp106__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp107_ = (_tmp106_ != NULL) ? _vala_array_dup2 (_tmp106_, _tmp106__length1) : ((gpointer) _tmp106_);
	_tmp107__length1 = _tmp106__length1;
	_tmp105_->gir_directories = (_vala_array_free (_tmp105_->gir_directories, _tmp105_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp105_->gir_directories = _tmp107_;
	_tmp105_->gir_directories_length1 = _tmp107__length1;
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_metadata_directories;
	_tmp109__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp110_ = (_tmp109_ != NULL) ? _vala_array_dup3 (_tmp109_, _tmp109__length1) : ((gpointer) _tmp109_);
	_tmp110__length1 = _tmp109__length1;
	_tmp108_->metadata_directories = (_vala_array_free (_tmp108_->metadata_directories, _tmp108_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp108_->metadata_directories = _tmp110_;
	_tmp108_->metadata_directories_length1 = _tmp110__length1;
	_tmp111_ = self->priv->context;
	_tmp112_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp111_, _tmp112_);
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp113_, _tmp114_);
	_tmp115_ = self->priv->context;
	_tmp116_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp115_, _tmp116_);
	_tmp118_ = vala_compiler_ccode_only;
	if (_tmp118_) {
		gboolean _tmp119_;
		_tmp119_ = vala_compiler_save_temps;
		_tmp117_ = _tmp119_;
	} else {
		_tmp117_ = FALSE;
	}
	if (_tmp117_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp122_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp122_, "gobject-2.0") == 0) {
		_tmp121_ = TRUE;
	} else {
		const gchar* _tmp123_;
		_tmp123_ = vala_compiler_profile;
		_tmp121_ = g_strcmp0 (_tmp123_, "gobject") == 0;
	}
	if (_tmp121_) {
		_tmp120_ = TRUE;
	} else {
		const gchar* _tmp124_;
		_tmp124_ = vala_compiler_profile;
		_tmp120_ = _tmp124_ == NULL;
	}
	if (_tmp120_) {
		ValaCodeContext* _tmp125_;
		ValaCodeContext* _tmp126_;
		_tmp125_ = self->priv->context;
		vala_code_context_set_profile (_tmp125_, VALA_PROFILE_GOBJECT);
		_tmp126_ = self->priv->context;
		vala_code_context_add_define (_tmp126_, "GOBJECT");
	} else {
		const gchar* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		_tmp127_ = vala_compiler_profile;
		_tmp128_ = g_strdup_printf ("Unknown profile %s", _tmp127_);
		_tmp129_ = _tmp128_;
		vala_report_error (NULL, _tmp129_);
		_g_free0 (_tmp129_);
	}
	_tmp130_ = vala_compiler_nostdpkg;
	_tmp131_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp130_ | (_tmp131_ != NULL);
	_tmp132_ = self->priv->context;
	_tmp133_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp132_, _tmp133_);
	_tmp134_ = self->priv->context;
	_tmp135_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp134_, _tmp135_);
	_tmp136_ = self->priv->context;
	_tmp137_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp136_, _tmp137_);
	_tmp138_ = vala_compiler_defines;
	_tmp138__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp138_ != NULL) {
		gchar** _tmp139_;
		gint _tmp139__length1;
		_tmp139_ = vala_compiler_defines;
		_tmp139__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp139_;
			define_collection_length1 = _tmp139__length1;
			for (define_it = 0; define_it < _tmp139__length1; define_it = define_it + 1) {
				gchar* _tmp140_;
				gchar* define = NULL;
				_tmp140_ = g_strdup (define_collection[define_it]);
				define = _tmp140_;
				{
					ValaCodeContext* _tmp141_;
					const gchar* _tmp142_;
					_tmp141_ = self->priv->context;
					_tmp142_ = define;
					vala_code_context_add_define (_tmp141_, _tmp142_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp143_ = FALSE;
			_tmp143_ = TRUE;
			while (TRUE) {
				gint _tmp145_;
				ValaCodeContext* _tmp146_;
				gint _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				if (!_tmp143_) {
					gint _tmp144_;
					_tmp144_ = i;
					i = _tmp144_ + 2;
				}
				_tmp143_ = FALSE;
				_tmp145_ = i;
				if (!(_tmp145_ <= 40)) {
					break;
				}
				_tmp146_ = self->priv->context;
				_tmp147_ = i;
				_tmp148_ = g_strdup_printf ("VALA_0_%d", _tmp147_);
				_tmp149_ = _tmp148_;
				vala_code_context_add_define (_tmp146_, _tmp149_);
				_g_free0 (_tmp149_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 40;
	_tmp151_ = vala_compiler_target_glib;
	if (_tmp151_ != NULL) {
		const gchar* _tmp152_;
		_tmp152_ = vala_compiler_target_glib;
		_tmp150_ = sscanf (_tmp152_, "%d.%d", &glib_major, &glib_minor) != 2;
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp153_ = self->priv->context;
	_tmp154_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp153_, _tmp154_);
	_tmp155_ = self->priv->context;
	_tmp156_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp155_, _tmp156_);
	_tmp157_ = self->priv->context;
	_tmp158_ = vala_code_context_get_target_glib_major (_tmp157_);
	_tmp159_ = _tmp158_;
	if (_tmp159_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp160_ = FALSE;
			_tmp160_ = TRUE;
			while (TRUE) {
				gint _tmp162_;
				gint _tmp163_;
				ValaCodeContext* _tmp164_;
				gint _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				if (!_tmp160_) {
					gint _tmp161_;
					_tmp161_ = i;
					i = _tmp161_ + 2;
				}
				_tmp160_ = FALSE;
				_tmp162_ = i;
				_tmp163_ = glib_minor;
				if (!(_tmp162_ <= _tmp163_)) {
					break;
				}
				_tmp164_ = self->priv->context;
				_tmp165_ = i;
				_tmp166_ = g_strdup_printf ("GLIB_2_%d", _tmp165_);
				_tmp167_ = _tmp166_;
				vala_code_context_add_define (_tmp164_, _tmp167_);
				_g_free0 (_tmp167_);
			}
		}
	}
	_tmp168_ = vala_compiler_nostdpkg;
	if (!_tmp168_) {
		ValaCodeContext* _tmp169_;
		ValaCodeContext* _tmp170_;
		_tmp169_ = self->priv->context;
		vala_code_context_add_external_package (_tmp169_, "glib-2.0");
		_tmp170_ = self->priv->context;
		vala_code_context_add_external_package (_tmp170_, "gobject-2.0");
	}
	_tmp171_ = vala_compiler_packages;
	_tmp171__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp171_ != NULL) {
		gchar** _tmp172_;
		gint _tmp172__length1;
		_tmp172_ = vala_compiler_packages;
		_tmp172__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp172_;
			package_collection_length1 = _tmp172__length1;
			for (package_it = 0; package_it < _tmp172__length1; package_it = package_it + 1) {
				gchar* _tmp173_;
				gchar* package = NULL;
				_tmp173_ = g_strdup (package_collection[package_it]);
				package = _tmp173_;
				{
					ValaCodeContext* _tmp174_;
					const gchar* _tmp175_;
					_tmp174_ = self->priv->context;
					_tmp175_ = package;
					vala_code_context_add_external_package (_tmp174_, _tmp175_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp176_ = vala_compiler_fast_vapis;
	_tmp176__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp176_ != NULL) {
		gchar** _tmp177_;
		gint _tmp177__length1;
		ValaCodeContext* _tmp186_;
		_tmp177_ = vala_compiler_fast_vapis;
		_tmp177__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp177_;
			vapi_collection_length1 = _tmp177__length1;
			for (vapi_it = 0; vapi_it < _tmp177__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp178_;
				gchar* vapi = NULL;
				_tmp178_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp178_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp179_;
					gchar* _tmp180_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp181_;
					const gchar* _tmp182_;
					ValaSourceFile* _tmp183_;
					ValaCodeContext* _tmp184_;
					ValaSourceFile* _tmp185_;
					_tmp179_ = vapi;
					_tmp180_ = vala_code_context_realpath (_tmp179_);
					rpath = _tmp180_;
					_tmp181_ = self->priv->context;
					_tmp182_ = rpath;
					_tmp183_ = vala_source_file_new (_tmp181_, VALA_SOURCE_FILE_TYPE_FAST, _tmp182_, NULL, FALSE);
					source_file = _tmp183_;
					_tmp184_ = self->priv->context;
					_tmp185_ = source_file;
					vala_code_context_add_source_file (_tmp184_, _tmp185_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp186_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp186_, TRUE);
	}
	_tmp187_ = self->priv->context;
	_tmp188_ = vala_compiler_gresources;
	_tmp188__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp189_ = (_tmp188_ != NULL) ? _vala_array_dup4 (_tmp188_, _tmp188__length1) : ((gpointer) _tmp188_);
	_tmp189__length1 = _tmp188__length1;
	_tmp187_->gresources = (_vala_array_free (_tmp187_->gresources, _tmp187_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp187_->gresources = _tmp189_;
	_tmp187_->gresources_length1 = _tmp189__length1;
	_tmp190_ = self->priv->context;
	_tmp191_ = vala_compiler_gresources_directories;
	_tmp191__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp192_ = (_tmp191_ != NULL) ? _vala_array_dup5 (_tmp191_, _tmp191__length1) : ((gpointer) _tmp191_);
	_tmp192__length1 = _tmp191__length1;
	_tmp190_->gresources_directories = (_vala_array_free (_tmp190_->gresources_directories, _tmp190_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp190_->gresources_directories = _tmp192_;
	_tmp190_->gresources_directories_length1 = _tmp192__length1;
	_tmp194_ = self->priv->context;
	_tmp195_ = vala_code_context_get_report (_tmp194_);
	_tmp196_ = _tmp195_;
	if (vala_report_get_errors (_tmp196_) > 0) {
		_tmp193_ = TRUE;
	} else {
		gboolean _tmp197_ = FALSE;
		gboolean _tmp198_;
		_tmp198_ = vala_compiler_fatal_warnings;
		if (_tmp198_) {
			ValaCodeContext* _tmp199_;
			ValaReport* _tmp200_;
			ValaReport* _tmp201_;
			_tmp199_ = self->priv->context;
			_tmp200_ = vala_code_context_get_report (_tmp199_);
			_tmp201_ = _tmp200_;
			_tmp197_ = vala_report_get_warnings (_tmp201_) > 0;
		} else {
			_tmp197_ = FALSE;
		}
		_tmp193_ = _tmp197_;
	}
	if (_tmp193_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp202_ = self->priv->context;
	_tmp203_ = vala_gd_bus_server_module_new ();
	_tmp204_ = _tmp203_;
	vala_code_context_set_codegen (_tmp202_, (ValaCodeGenerator*) _tmp204_);
	_vala_code_visitor_unref0 (_tmp204_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp205_ = vala_compiler_sources;
	_tmp205__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp205_;
		source_collection_length1 = _tmp205__length1;
		for (source_it = 0; source_it < _tmp205__length1; source_it = source_it + 1) {
			gchar* _tmp206_;
			gchar* source = NULL;
			_tmp206_ = g_strdup (source_collection[source_it]);
			source = _tmp206_;
			{
				ValaCodeContext* _tmp207_;
				const gchar* _tmp208_;
				gboolean _tmp209_;
				_tmp207_ = self->priv->context;
				_tmp208_ = source;
				_tmp209_ = vala_compiler_run_output;
				if (vala_code_context_add_source_filename (_tmp207_, _tmp208_, _tmp209_, TRUE)) {
					const gchar* _tmp210_;
					_tmp210_ = source;
					if (g_str_has_suffix (_tmp210_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp211_;
						_tmp211_ = source;
						if (g_str_has_suffix (_tmp211_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp213_ = vala_compiler_ccode_only;
	if (_tmp213_) {
		gboolean _tmp214_ = FALSE;
		gboolean _tmp215_;
		_tmp215_ = has_c_files;
		if (_tmp215_) {
			_tmp214_ = TRUE;
		} else {
			gboolean _tmp216_;
			_tmp216_ = has_h_files;
			_tmp214_ = _tmp216_;
		}
		_tmp212_ = _tmp214_;
	} else {
		_tmp212_ = FALSE;
	}
	if (_tmp212_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp218_ = self->priv->context;
	_tmp219_ = vala_code_context_get_report (_tmp218_);
	_tmp220_ = _tmp219_;
	if (vala_report_get_errors (_tmp220_) > 0) {
		_tmp217_ = TRUE;
	} else {
		gboolean _tmp221_ = FALSE;
		gboolean _tmp222_;
		_tmp222_ = vala_compiler_fatal_warnings;
		if (_tmp222_) {
			ValaCodeContext* _tmp223_;
			ValaReport* _tmp224_;
			ValaReport* _tmp225_;
			_tmp223_ = self->priv->context;
			_tmp224_ = vala_code_context_get_report (_tmp223_);
			_tmp225_ = _tmp224_;
			_tmp221_ = vala_report_get_warnings (_tmp225_) > 0;
		} else {
			_tmp221_ = FALSE;
		}
		_tmp217_ = _tmp221_;
	}
	if (_tmp217_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp226_ = vala_parser_new ();
	parser = _tmp226_;
	_tmp227_ = parser;
	_tmp228_ = self->priv->context;
	vala_parser_parse (_tmp227_, _tmp228_);
	_tmp229_ = vala_genie_parser_new ();
	genie_parser = _tmp229_;
	_tmp230_ = genie_parser;
	_tmp231_ = self->priv->context;
	vala_genie_parser_parse (_tmp230_, _tmp231_);
	_tmp232_ = vala_gir_parser_new ();
	gir_parser = _tmp232_;
	_tmp233_ = gir_parser;
	_tmp234_ = self->priv->context;
	vala_gir_parser_parse (_tmp233_, _tmp234_);
	_tmp236_ = self->priv->context;
	_tmp237_ = vala_code_context_get_report (_tmp236_);
	_tmp238_ = _tmp237_;
	if (vala_report_get_errors (_tmp238_) > 0) {
		_tmp235_ = TRUE;
	} else {
		gboolean _tmp239_ = FALSE;
		gboolean _tmp240_;
		_tmp240_ = vala_compiler_fatal_warnings;
		if (_tmp240_) {
			ValaCodeContext* _tmp241_;
			ValaReport* _tmp242_;
			ValaReport* _tmp243_;
			_tmp241_ = self->priv->context;
			_tmp242_ = vala_code_context_get_report (_tmp241_);
			_tmp243_ = _tmp242_;
			_tmp239_ = vala_report_get_warnings (_tmp243_) > 0;
		} else {
			_tmp239_ = FALSE;
		}
		_tmp235_ = _tmp239_;
	}
	if (_tmp235_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp244_ = vala_compiler_fast_vapi_filename;
	if (_tmp244_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp245_;
		ValaCodeWriter* _tmp246_;
		ValaCodeContext* _tmp247_;
		const gchar* _tmp248_;
		_tmp245_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp245_;
		_tmp246_ = interface_writer;
		_tmp247_ = self->priv->context;
		_tmp248_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp246_, _tmp247_, _tmp248_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp249_ = self->priv->context;
	vala_code_context_check (_tmp249_);
	_tmp251_ = self->priv->context;
	_tmp252_ = vala_code_context_get_report (_tmp251_);
	_tmp253_ = _tmp252_;
	if (vala_report_get_errors (_tmp253_) > 0) {
		_tmp250_ = TRUE;
	} else {
		gboolean _tmp254_ = FALSE;
		gboolean _tmp255_;
		_tmp255_ = vala_compiler_fatal_warnings;
		if (_tmp255_) {
			ValaCodeContext* _tmp256_;
			ValaReport* _tmp257_;
			ValaReport* _tmp258_;
			_tmp256_ = self->priv->context;
			_tmp257_ = vala_code_context_get_report (_tmp256_);
			_tmp258_ = _tmp257_;
			_tmp254_ = vala_report_get_warnings (_tmp258_) > 0;
		} else {
			_tmp254_ = FALSE;
		}
		_tmp250_ = _tmp254_;
	}
	if (_tmp250_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp261_ = vala_compiler_ccode_only;
	if (!_tmp261_) {
		gboolean _tmp262_;
		_tmp262_ = vala_compiler_compile_only;
		_tmp260_ = !_tmp262_;
	} else {
		_tmp260_ = FALSE;
	}
	if (_tmp260_) {
		const gchar* _tmp263_;
		_tmp263_ = vala_compiler_library;
		_tmp259_ = _tmp263_ == NULL;
	} else {
		_tmp259_ = FALSE;
	}
	if (_tmp259_) {
		gboolean _tmp264_ = FALSE;
		gboolean _tmp265_;
		_tmp265_ = has_c_files;
		if (!_tmp265_) {
			ValaCodeContext* _tmp266_;
			ValaMethod* _tmp267_;
			ValaMethod* _tmp268_;
			_tmp266_ = self->priv->context;
			_tmp267_ = vala_code_context_get_entry_point (_tmp266_);
			_tmp268_ = _tmp267_;
			_tmp264_ = _tmp268_ == NULL;
		} else {
			_tmp264_ = FALSE;
		}
		if (_tmp264_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp269_ = vala_compiler_dump_tree;
	if (_tmp269_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp270_;
		ValaCodeWriter* _tmp271_;
		ValaCodeContext* _tmp272_;
		const gchar* _tmp273_;
		_tmp270_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp270_;
		_tmp271_ = code_writer;
		_tmp272_ = self->priv->context;
		_tmp273_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp271_, _tmp272_, _tmp273_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp275_ = self->priv->context;
	_tmp276_ = vala_code_context_get_report (_tmp275_);
	_tmp277_ = _tmp276_;
	if (vala_report_get_errors (_tmp277_) > 0) {
		_tmp274_ = TRUE;
	} else {
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_;
		_tmp279_ = vala_compiler_fatal_warnings;
		if (_tmp279_) {
			ValaCodeContext* _tmp280_;
			ValaReport* _tmp281_;
			ValaReport* _tmp282_;
			_tmp280_ = self->priv->context;
			_tmp281_ = vala_code_context_get_report (_tmp280_);
			_tmp282_ = _tmp281_;
			_tmp278_ = vala_report_get_warnings (_tmp282_) > 0;
		} else {
			_tmp278_ = FALSE;
		}
		_tmp274_ = _tmp278_;
	}
	if (_tmp274_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp283_ = self->priv->context;
	_tmp284_ = vala_code_context_get_codegen (_tmp283_);
	_tmp285_ = _tmp284_;
	_tmp286_ = self->priv->context;
	vala_code_generator_emit (_tmp285_, _tmp286_);
	_tmp288_ = self->priv->context;
	_tmp289_ = vala_code_context_get_report (_tmp288_);
	_tmp290_ = _tmp289_;
	if (vala_report_get_errors (_tmp290_) > 0) {
		_tmp287_ = TRUE;
	} else {
		gboolean _tmp291_ = FALSE;
		gboolean _tmp292_;
		_tmp292_ = vala_compiler_fatal_warnings;
		if (_tmp292_) {
			ValaCodeContext* _tmp293_;
			ValaReport* _tmp294_;
			ValaReport* _tmp295_;
			_tmp293_ = self->priv->context;
			_tmp294_ = vala_code_context_get_report (_tmp293_);
			_tmp295_ = _tmp294_;
			_tmp291_ = vala_report_get_warnings (_tmp295_) > 0;
		} else {
			_tmp291_ = FALSE;
		}
		_tmp287_ = _tmp291_;
	}
	if (_tmp287_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp297_ = vala_compiler_vapi_filename;
	if (_tmp297_ == NULL) {
		const gchar* _tmp298_;
		_tmp298_ = vala_compiler_library;
		_tmp296_ = _tmp298_ != NULL;
	} else {
		_tmp296_ = FALSE;
	}
	if (_tmp296_) {
		const gchar* _tmp299_;
		gchar* _tmp300_;
		_tmp299_ = vala_compiler_library;
		_tmp300_ = g_strdup_printf ("%s.vapi", _tmp299_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp300_;
	}
	_tmp301_ = vala_compiler_library;
	if (_tmp301_ != NULL) {
		const gchar* _tmp302_;
		_tmp302_ = vala_compiler_gir;
		if (_tmp302_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp303_;
			gchar* _tmp304_;
			glong gir_len = 0L;
			const gchar* _tmp305_;
			gint _tmp306_;
			gint _tmp307_;
			gint last_hyphen = 0;
			const gchar* _tmp308_;
			gboolean _tmp309_ = FALSE;
			gint _tmp310_;
			_tmp303_ = vala_compiler_gir;
			_tmp304_ = g_path_get_basename (_tmp303_);
			gir_base = _tmp304_;
			_tmp305_ = gir_base;
			_tmp306_ = strlen (_tmp305_);
			_tmp307_ = _tmp306_;
			gir_len = (glong) _tmp307_;
			_tmp308_ = gir_base;
			last_hyphen = string_last_index_of_char (_tmp308_, (gunichar) '-', 0);
			_tmp310_ = last_hyphen;
			if (_tmp310_ == -1) {
				_tmp309_ = TRUE;
			} else {
				const gchar* _tmp311_;
				_tmp311_ = gir_base;
				_tmp309_ = !g_str_has_suffix (_tmp311_, ".gir");
			}
			if (_tmp309_) {
				const gchar* _tmp312_;
				gchar* _tmp313_;
				gchar* _tmp314_;
				_tmp312_ = vala_compiler_gir;
				_tmp313_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp312_);
				_tmp314_ = _tmp313_;
				vala_report_error (NULL, _tmp314_);
				_g_free0 (_tmp314_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp315_;
				gint _tmp316_;
				gchar* _tmp317_;
				gchar* gir_version = NULL;
				const gchar* _tmp318_;
				gint _tmp319_;
				glong _tmp320_;
				gint _tmp321_;
				gchar* _tmp322_;
				const gchar* _tmp323_;
				gboolean _tmp324_ = FALSE;
				gboolean _tmp325_ = FALSE;
				gboolean _tmp326_ = FALSE;
				const gchar* _tmp327_;
				_tmp315_ = gir_base;
				_tmp316_ = last_hyphen;
				_tmp317_ = string_substring (_tmp315_, (glong) 0, (glong) _tmp316_);
				gir_namespace = _tmp317_;
				_tmp318_ = gir_base;
				_tmp319_ = last_hyphen;
				_tmp320_ = gir_len;
				_tmp321_ = last_hyphen;
				_tmp322_ = string_substring (_tmp318_, (glong) (_tmp319_ + 1), (_tmp320_ - _tmp321_) - 5);
				gir_version = _tmp322_;
				_tmp323_ = gir_version;
				g_strcanon (_tmp323_, "0123456789.", '?');
				_tmp327_ = gir_namespace;
				if (g_strcmp0 (_tmp327_, "") == 0) {
					_tmp326_ = TRUE;
				} else {
					const gchar* _tmp328_;
					_tmp328_ = gir_version;
					_tmp326_ = g_strcmp0 (_tmp328_, "") == 0;
				}
				if (_tmp326_) {
					_tmp325_ = TRUE;
				} else {
					const gchar* _tmp329_;
					_tmp329_ = gir_version;
					_tmp325_ = !g_ascii_isdigit (string_get (_tmp329_, (glong) 0));
				}
				if (_tmp325_) {
					_tmp324_ = TRUE;
				} else {
					const gchar* _tmp330_;
					_tmp330_ = gir_version;
					_tmp324_ = string_contains (_tmp330_, "?");
				}
				if (_tmp324_) {
					const gchar* _tmp331_;
					gchar* _tmp332_;
					gchar* _tmp333_;
					_tmp331_ = vala_compiler_gir;
					_tmp332_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp331_);
					_tmp333_ = _tmp332_;
					vala_report_error (NULL, _tmp333_);
					_g_free0 (_tmp333_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp334_;
					gchar* gir_directory = NULL;
					gchar* _tmp335_;
					const gchar* _tmp336_;
					ValaGIRWriter* _tmp341_;
					ValaCodeContext* _tmp342_;
					const gchar* _tmp343_;
					const gchar* _tmp344_;
					const gchar* _tmp345_;
					const gchar* _tmp346_;
					const gchar* _tmp347_;
					const gchar* _tmp348_;
					_tmp334_ = vala_gir_writer_new ();
					gir_writer = _tmp334_;
					_tmp335_ = g_strdup (".");
					gir_directory = _tmp335_;
					_tmp336_ = vala_compiler_directory;
					if (_tmp336_ != NULL) {
						ValaCodeContext* _tmp337_;
						const gchar* _tmp338_;
						const gchar* _tmp339_;
						gchar* _tmp340_;
						_tmp337_ = self->priv->context;
						_tmp338_ = vala_code_context_get_directory (_tmp337_);
						_tmp339_ = _tmp338_;
						_tmp340_ = g_strdup (_tmp339_);
						_g_free0 (gir_directory);
						gir_directory = _tmp340_;
					}
					_tmp341_ = gir_writer;
					_tmp342_ = self->priv->context;
					_tmp343_ = gir_directory;
					_tmp344_ = vala_compiler_gir;
					_tmp345_ = gir_namespace;
					_tmp346_ = gir_version;
					_tmp347_ = vala_compiler_library;
					_tmp348_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp341_, _tmp342_, _tmp343_, _tmp344_, _tmp345_, _tmp346_, _tmp347_, _tmp348_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp349_ = vala_compiler_vapi_filename;
	if (_tmp349_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp350_;
		gboolean _tmp351_ = FALSE;
		const gchar* _tmp352_;
		ValaCodeWriter* _tmp359_;
		ValaCodeContext* _tmp360_;
		const gchar* _tmp361_;
		_tmp350_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp350_;
		_tmp352_ = vala_compiler_directory;
		if (_tmp352_ != NULL) {
			const gchar* _tmp353_;
			_tmp353_ = vala_compiler_vapi_filename;
			_tmp351_ = !g_path_is_absolute (_tmp353_);
		} else {
			_tmp351_ = FALSE;
		}
		if (_tmp351_) {
			ValaCodeContext* _tmp354_;
			const gchar* _tmp355_;
			const gchar* _tmp356_;
			const gchar* _tmp357_;
			gchar* _tmp358_;
			_tmp354_ = self->priv->context;
			_tmp355_ = vala_code_context_get_directory (_tmp354_);
			_tmp356_ = _tmp355_;
			_tmp357_ = vala_compiler_vapi_filename;
			_tmp358_ = g_strdup_printf ("%s%c%s", _tmp356_, (gint) G_DIR_SEPARATOR, _tmp357_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp358_;
		}
		_tmp359_ = interface_writer;
		_tmp360_ = self->priv->context;
		_tmp361_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp359_, _tmp360_, _tmp361_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp362_ = vala_compiler_internal_vapi_filename;
	if (_tmp362_ != NULL) {
		gboolean _tmp363_ = FALSE;
		const gchar* _tmp364_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp366_;
		ValaCodeWriter* _tmp367_;
		const gchar* _tmp368_;
		const gchar* _tmp369_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp370_;
		gchar* _tmp371_;
		gboolean _tmp372_ = FALSE;
		const gchar* _tmp373_;
		ValaCodeWriter* _tmp380_;
		ValaCodeContext* _tmp381_;
		const gchar* _tmp382_;
		_tmp364_ = vala_compiler_internal_header_filename;
		if (_tmp364_ == NULL) {
			_tmp363_ = TRUE;
		} else {
			const gchar* _tmp365_;
			_tmp365_ = vala_compiler_header_filename;
			_tmp363_ = _tmp365_ == NULL;
		}
		if (_tmp363_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp366_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp366_;
		_tmp367_ = interface_writer;
		_tmp368_ = vala_compiler_header_filename;
		_tmp369_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp367_, _tmp368_, _tmp369_);
		_tmp370_ = vala_compiler_internal_vapi_filename;
		_tmp371_ = g_strdup (_tmp370_);
		vapi_filename = _tmp371_;
		_tmp373_ = vala_compiler_directory;
		if (_tmp373_ != NULL) {
			const gchar* _tmp374_;
			_tmp374_ = vapi_filename;
			_tmp372_ = !g_path_is_absolute (_tmp374_);
		} else {
			_tmp372_ = FALSE;
		}
		if (_tmp372_) {
			ValaCodeContext* _tmp375_;
			const gchar* _tmp376_;
			const gchar* _tmp377_;
			const gchar* _tmp378_;
			gchar* _tmp379_;
			_tmp375_ = self->priv->context;
			_tmp376_ = vala_code_context_get_directory (_tmp375_);
			_tmp377_ = _tmp376_;
			_tmp378_ = vapi_filename;
			_tmp379_ = g_strdup_printf ("%s%c%s", _tmp377_, (gint) G_DIR_SEPARATOR, _tmp378_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp379_;
		}
		_tmp380_ = interface_writer;
		_tmp381_ = self->priv->context;
		_tmp382_ = vapi_filename;
		vala_code_writer_write_file (_tmp380_, _tmp381_, _tmp382_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp383_ = vala_compiler_dependencies;
	if (_tmp383_ != NULL) {
		ValaCodeContext* _tmp384_;
		const gchar* _tmp385_;
		_tmp384_ = self->priv->context;
		_tmp385_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp384_, _tmp385_);
	}
	_tmp387_ = self->priv->context;
	_tmp388_ = vala_code_context_get_report (_tmp387_);
	_tmp389_ = _tmp388_;
	if (vala_report_get_errors (_tmp389_) > 0) {
		_tmp386_ = TRUE;
	} else {
		gboolean _tmp390_ = FALSE;
		gboolean _tmp391_;
		_tmp391_ = vala_compiler_fatal_warnings;
		if (_tmp391_) {
			ValaCodeContext* _tmp392_;
			ValaReport* _tmp393_;
			ValaReport* _tmp394_;
			_tmp392_ = self->priv->context;
			_tmp393_ = vala_code_context_get_report (_tmp392_);
			_tmp394_ = _tmp393_;
			_tmp390_ = vala_report_get_warnings (_tmp394_) > 0;
		} else {
			_tmp390_ = FALSE;
		}
		_tmp386_ = _tmp390_;
	}
	if (_tmp386_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp395_ = vala_compiler_ccode_only;
	if (!_tmp395_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp396_;
		gboolean _tmp397_ = FALSE;
		const gchar* _tmp398_;
		gboolean _tmp402_ = FALSE;
		const gchar* _tmp403_;
		gchar** _tmp407_;
		gint _tmp407__length1;
		_tmp396_ = vala_ccode_compiler_new ();
		ccompiler = _tmp396_;
		_tmp398_ = vala_compiler_cc_command;
		if (_tmp398_ == NULL) {
			const gchar* _tmp399_;
			_tmp399_ = g_getenv ("CC");
			_tmp397_ = _tmp399_ != NULL;
		} else {
			_tmp397_ = FALSE;
		}
		if (_tmp397_) {
			const gchar* _tmp400_;
			gchar* _tmp401_;
			_tmp400_ = g_getenv ("CC");
			_tmp401_ = g_strdup (_tmp400_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp401_;
		}
		_tmp403_ = vala_compiler_pkg_config_command;
		if (_tmp403_ == NULL) {
			const gchar* _tmp404_;
			_tmp404_ = g_getenv ("PKG_CONFIG");
			_tmp402_ = _tmp404_ != NULL;
		} else {
			_tmp402_ = FALSE;
		}
		if (_tmp402_) {
			const gchar* _tmp405_;
			gchar* _tmp406_;
			_tmp405_ = g_getenv ("PKG_CONFIG");
			_tmp406_ = g_strdup (_tmp405_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp406_;
		}
		_tmp407_ = vala_compiler_cc_options;
		_tmp407__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp407_ == NULL) {
			ValaCCodeCompiler* _tmp408_;
			ValaCodeContext* _tmp409_;
			const gchar* _tmp410_;
			gchar** _tmp411_;
			gchar** _tmp412_;
			gint _tmp412__length1;
			const gchar* _tmp413_;
			_tmp408_ = ccompiler;
			_tmp409_ = self->priv->context;
			_tmp410_ = vala_compiler_cc_command;
			_tmp411_ = g_new0 (gchar*, 0 + 1);
			_tmp412_ = _tmp411_;
			_tmp412__length1 = 0;
			_tmp413_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp408_, _tmp409_, _tmp410_, _tmp412_, 0, _tmp413_);
			_tmp412_ = (_vala_array_free (_tmp412_, _tmp412__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp414_;
			ValaCodeContext* _tmp415_;
			const gchar* _tmp416_;
			gchar** _tmp417_;
			gint _tmp417__length1;
			const gchar* _tmp418_;
			_tmp414_ = ccompiler;
			_tmp415_ = self->priv->context;
			_tmp416_ = vala_compiler_cc_command;
			_tmp417_ = vala_compiler_cc_options;
			_tmp417__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp418_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp414_, _tmp415_, _tmp416_, _tmp417_, _tmp417__length1, _tmp418_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void
_vala_array_add1 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
___lambda4_ (Block1Data* _data1_, 
             GPid pid, 
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void
____lambda4__gchild_watch_func (GPid pid, 
                                gint status, 
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}


static gint
vala_compiler_run_source (gchar** args, 
                          int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint outputfd = 0;
	const gchar* _tmp23_;
	gint _tmp24_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp25_;
	gint ret = 0;
	ValaCompiler* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	const gchar* _tmp29_;
	gchar** target_args = NULL;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gint target_args_length1;
	gint _target_args_size_;
	gchar** target_run_args = NULL;
	const gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint target_run_args_length1;
	gint _target_run_args_size_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gint _tmp53_ = 0;
	GError * _inner_error_ = NULL;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = vala_compiler_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp13_;
		_tmp13_ = vala_compiler_api_version;
		if (_tmp13_) {
			FILE* _tmp14_;
			_tmp14_ = stdout;
			fprintf (_tmp14_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp15_ = vala_compiler_sources;
	_tmp15__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp15_ == NULL) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp17_ = g_get_tmp_dir ();
	_tmp18_ = vala_compiler_sources;
	_tmp18__length1 = _vala_array_length (vala_compiler_sources);
	_tmp19_ = _tmp18_[0];
	_tmp20_ = g_path_get_basename (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp17_, _tmp21_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp23_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp23_);
	_tmp24_ = outputfd;
	if (_tmp24_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp25_ = vala_compiler_new ();
	compiler = _tmp25_;
	_tmp26_ = compiler;
	ret = vala_compiler_run (_tmp26_);
	_tmp27_ = ret;
	if (_tmp27_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp28_ = outputfd;
	close (_tmp28_);
	_tmp29_ = vala_compiler_output;
	if (g_chmod (_tmp29_, 0700) != 0) {
		const gchar* _tmp30_;
		_tmp30_ = vala_compiler_output;
		g_unlink (_tmp30_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp31_ = vala_compiler_output;
	_tmp32_ = g_strdup (_tmp31_);
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	target_args = _tmp33_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp34_ = vala_compiler_run_args;
	_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, " ", 0);
	target_run_args = _tmp36_;
	target_run_args_length1 = _vala_array_length (_tmp35_);
	_target_run_args_size_ = target_run_args_length1;
	_tmp37_ = target_run_args;
	_tmp37__length1 = target_run_args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp37_;
		arg_collection_length1 = _tmp37__length1;
		for (arg_it = 0; arg_it < _tmp37__length1; arg_it = arg_it + 1) {
			gchar* _tmp38_;
			gchar* arg = NULL;
			_tmp38_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp38_;
			{
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp39_ = target_args;
				_tmp39__length1 = target_args_length1;
				_tmp40_ = arg;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp41_);
				_g_free0 (arg);
			}
		}
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		GPid _tmp44_ = 0;
		const gchar* _tmp46_;
		GPid _tmp47_;
		GMainLoop* _tmp48_;
		gint _tmp49_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp42_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp42_;
		_data1_->child_status = 0;
		_tmp43_ = target_args;
		_tmp43__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp43_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp44_, &_inner_error_);
		pid = _tmp44_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp45_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp45_;
		}
		_tmp46_ = vala_compiler_output;
		g_unlink (_tmp46_);
		_tmp47_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp47_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp48_ = _data1_->loop;
		g_main_loop_run (_tmp48_);
		_tmp49_ = _data1_->child_status;
		result = _tmp49_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = stdout;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		fprintf (_tmp50_, "%s\n", _tmp52_);
		result = 1;
		_g_error_free0 (e);
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp53_;
}


static gint
vala_compiler_main (gchar** args, 
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp19_;
	gboolean _tmp23_ = FALSE;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp27_;
	ValaCompiler* _tmp28_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "vala") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = args[0];
		_tmp6_ = g_path_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		GOptionContext* _tmp10_;
		GOptionContext* _tmp11_;
		_tmp8_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp8_;
		_tmp9_ = opt_context;
		g_option_context_set_help_enabled (_tmp9_, TRUE);
		_tmp10_ = opt_context;
		g_option_context_add_main_entries (_tmp10_, VALA_COMPILER_options, NULL);
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp12_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_tmp16_ = stdout;
		_tmp17_ = args[0];
		fprintf (_tmp16_, "Run '%s --help' to see a full list of available command line options.\n", _tmp17_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp18_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	_tmp19_ = vala_compiler_version;
	if (_tmp19_) {
		FILE* _tmp20_;
		_tmp20_ = stdout;
		fprintf (_tmp20_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_api_version;
		if (_tmp21_) {
			FILE* _tmp22_;
			_tmp22_ = stdout;
			fprintf (_tmp22_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp24_ = vala_compiler_sources;
	_tmp24__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp24_ == NULL) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = vala_compiler_fast_vapis;
		_tmp25__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp23_ = _tmp25_ == NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		FILE* _tmp26_;
		_tmp26_ = stderr;
		fprintf (_tmp26_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp27_ = vala_compiler_new ();
	compiler = _tmp27_;
	_tmp28_ = compiler;
	result = vala_compiler_run (_tmp28_);
	_vala_compiler_unref0 (compiler);
	return result;
}


int
main (int argc, 
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_compiler_copy_value (const GValue* src_value, 
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_compiler_collect_value (GValue* value, 
                                   guint n_collect_values, 
                                   GTypeCValue* collect_values, 
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_compiler_lcopy_value (const GValue* value, 
                                 guint n_collect_values, 
                                 GTypeCValue* collect_values, 
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name, 
                          const gchar* nick, 
                          const gchar* blurb, 
                          GType object_type, 
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value, 
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value, 
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void
vala_compiler_class_init (ValaCompilerClass * klass)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void
vala_compiler_instance_init (ValaCompiler * self)
{
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



