/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_ASSIGNMENT_0_PROPERTY,
	VALA_ASSIGNMENT_NUM_PROPERTIES
};
static GParamSpec* vala_assignment_properties[VALA_ASSIGNMENT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base, 
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base, 
                                           ValaCodeVisitor* visitor);
static void vala_assignment_real_replace_expression (ValaCodeNode* base, 
                                              ValaExpression* old_node, 
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base, 
                                             ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base, 
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base, 
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, 
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base, 
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type, 
                           ValaExpression* left, 
                           ValaExpression* right, 
                           ValaAssignmentOperator operator, 
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}


ValaAssignment*
vala_assignment_new (ValaExpression* left, 
                     ValaExpression* right, 
                     ValaAssignmentOperator operator, 
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void
vala_assignment_real_accept (ValaCodeNode* base, 
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_assignment_real_accept_children (ValaCodeNode* base, 
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static void
vala_assignment_real_replace_expression (ValaCodeNode* base, 
                                         ValaExpression* old_node, 
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}


static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_assignment_real_is_accessible (ValaExpression* base, 
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_assignment_real_check (ValaCodeNode* base, 
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp101_;
	ValaExpression* _tmp306_;
	ValaExpression* _tmp307_;
	gboolean _tmp308_ = FALSE;
	ValaAssignmentOperator _tmp309_;
	ValaExpression* _tmp371_;
	ValaExpression* _tmp372_;
	ValaSymbol* _tmp373_;
	ValaSymbol* _tmp374_;
	ValaExpression* _tmp816_;
	ValaExpression* _tmp817_;
	ValaDataType* _tmp818_;
	ValaDataType* _tmp819_;
	ValaExpression* _tmp828_;
	ValaExpression* _tmp829_;
	ValaList* _tmp830_;
	ValaList* _tmp831_;
	ValaExpression* _tmp832_;
	ValaExpression* _tmp833_;
	ValaList* _tmp834_;
	ValaList* _tmp835_;
	gboolean _tmp836_;
	gboolean _tmp837_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaBlock* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp85_;
		ValaSemanticAnalyzer* _tmp86_;
		ValaList* _tmp87_;
		ValaCodeNode* _tmp88_;
		ValaCodeNode* _tmp89_;
		ValaExpressionStatement* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		ValaExpressionStatement* _tmp93_;
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, context);
		_tmp29_ = vala_code_context_get_analyzer (context);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->insert_block;
		_tmp32_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp31_, (ValaStatement*) _tmp32_);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ValaExpression* expr = NULL;
				ValaList* _tmp41_;
				gint _tmp42_;
				gpointer _tmp43_;
				ValaExpressionStatement* _tmp44_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp58_;
				ValaExpression* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaElementAccess* _tmp62_;
				ValaElementAccess* _tmp63_;
				gint _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				ValaExpression* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaIntegerLiteral* _tmp70_;
				ValaIntegerLiteral* _tmp71_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp72_;
				ValaElementAccess* _tmp73_;
				ValaAssignmentOperator _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaAssignment* _tmp79_;
				ValaExpression* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaExpressionStatement* _tmp83_;
				gint _tmp84_;
				_tmp38_ = _expr_index;
				_expr_index = _tmp38_ + 1;
				_tmp39_ = _expr_index;
				_tmp40_ = _expr_size;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				_tmp41_ = _expr_list;
				_tmp42_ = _expr_index;
				_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
				expr = (ValaExpression*) _tmp43_;
				_tmp44_ = stmt;
				if (_tmp44_ != NULL) {
					ValaExpressionStatement* _tmp45_;
					ValaSemanticAnalyzer* _tmp46_;
					ValaSemanticAnalyzer* _tmp47_;
					ValaBlock* _tmp48_;
					ValaExpressionStatement* _tmp49_;
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
					_tmp46_ = vala_code_context_get_analyzer (context);
					_tmp47_ = _tmp46_;
					_tmp48_ = _tmp47_->insert_block;
					_tmp49_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp48_, (ValaStatement*) _tmp49_);
				}
				_tmp50_ = local;
				_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
				temp_access = _tmp57_;
				_tmp58_ = temp_access;
				_tmp59_ = expr;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_element_access_new ((ValaExpression*) _tmp58_, _tmp61_);
				ea = _tmp62_;
				_tmp63_ = ea;
				_tmp64_ = i;
				_tmp65_ = g_strdup_printf ("%i", _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = expr;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_integer_literal_new (_tmp66_, _tmp69_);
				_tmp71_ = _tmp70_;
				vala_element_access_append_index (_tmp63_, (ValaExpression*) _tmp71_);
				_vala_code_node_unref0 (_tmp71_);
				_g_free0 (_tmp66_);
				_tmp72_ = expr;
				_tmp73_ = ea;
				_tmp74_ = self->priv->_operator;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_assignment_new (_tmp72_, (ValaExpression*) _tmp73_, _tmp74_, _tmp77_);
				assign = _tmp78_;
				_tmp79_ = assign;
				_tmp80_ = expr;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_expression_statement_new ((ValaExpression*) _tmp79_, _tmp82_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp83_;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp85_ = vala_code_context_get_analyzer (context);
		_tmp86_ = _tmp85_;
		_tmp87_ = _tmp86_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp87_, (ValaCodeNode*) self);
		_tmp88_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = stmt;
		_tmp91_ = vala_expression_statement_get_expression (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_code_node_replace_expression (_tmp89_, (ValaExpression*) self, _tmp92_);
		_tmp93_ = stmt;
		_tmp94_ = vala_expression_statement_get_expression (_tmp93_);
		_tmp95_ = _tmp94_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp96_ = vala_assignment_get_left (self);
	_tmp97_ = _tmp96_;
	vala_expression_set_lvalue (_tmp97_, TRUE);
	_tmp98_ = vala_assignment_get_left (self);
	_tmp99_ = _tmp98_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp99_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp100_ = vala_assignment_get_left (self);
	_tmp101_ = _tmp100_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp102_;
		ValaExpression* _tmp103_;
		ValaMemberAccess* _tmp104_;
		ValaMemberAccess* _tmp105_;
		ValaSymbol* _tmp106_;
		ValaSymbol* _tmp107_;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		gboolean _tmp112_ = FALSE;
		ValaMemberAccess* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaMemberAccess* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp146_ = FALSE;
		ValaMemberAccess* _tmp147_;
		gboolean _tmp148_;
		gboolean _tmp149_;
		ValaMemberAccess* _tmp153_;
		ValaSymbol* _tmp154_;
		ValaSymbol* _tmp155_;
		_tmp102_ = vala_assignment_get_left (self);
		_tmp103_ = _tmp102_;
		_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp104_;
		_tmp105_ = ma;
		_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp105_);
		_tmp107_ = _tmp106_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			vala_report_error (_tmp109_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp113_ = ma;
		_tmp114_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp113_);
		_tmp115_ = _tmp114_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_SIGNAL)) {
			_tmp112_ = TRUE;
		} else {
			ValaMemberAccess* _tmp116_;
			ValaSymbol* _tmp117_;
			ValaSymbol* _tmp118_;
			_tmp116_ = ma;
			_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp112_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp118_, VALA_TYPE_DYNAMIC_PROPERTY);
		}
		if (!_tmp112_) {
			ValaMemberAccess* _tmp119_;
			ValaDataType* _tmp120_;
			ValaDataType* _tmp121_;
			_tmp119_ = ma;
			_tmp120_ = vala_expression_get_value_type ((ValaExpression*) _tmp119_);
			_tmp121_ = _tmp120_;
			_tmp111_ = _tmp121_ == NULL;
		} else {
			_tmp111_ = FALSE;
		}
		if (_tmp111_) {
			_tmp110_ = TRUE;
		} else {
			gboolean _tmp122_ = FALSE;
			gboolean _tmp123_ = FALSE;
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			if (_tmp126_ == NULL) {
				ValaMemberAccess* _tmp127_;
				const gchar* _tmp128_;
				const gchar* _tmp129_;
				_tmp127_ = ma;
				_tmp128_ = vala_member_access_get_member_name (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp123_ = g_strcmp0 (_tmp129_, "this") == 0;
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaSemanticAnalyzer* _tmp130_;
				ValaSemanticAnalyzer* _tmp131_;
				_tmp130_ = vala_code_context_get_analyzer (context);
				_tmp131_ = _tmp130_;
				_tmp122_ = vala_semantic_analyzer_is_in_instance_method (_tmp131_);
			} else {
				_tmp122_ = FALSE;
			}
			_tmp110_ = _tmp122_;
		}
		if (_tmp110_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp133_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp134_ = ma;
		_tmp135_ = vala_member_access_get_prototype_access (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaMemberAccess* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = ma;
			_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_symbol_get_full_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp143_);
			_tmp145_ = _tmp144_;
			vala_report_error (_tmp138_, _tmp145_);
			_g_free0 (_tmp145_);
			_g_free0 (_tmp143_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp147_ = ma;
		_tmp148_ = vala_code_node_get_error ((ValaCodeNode*) _tmp147_);
		_tmp149_ = _tmp148_;
		if (_tmp149_) {
			_tmp146_ = TRUE;
		} else {
			ValaMemberAccess* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			_tmp150_ = ma;
			_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp146_ = _tmp152_ == NULL;
		}
		if (_tmp146_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp153_ = ma;
		_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gboolean _tmp156_;
			gboolean _tmp157_;
			_tmp156_ = vala_code_context_get_deprecated (context);
			_tmp157_ = _tmp156_;
			if (!_tmp157_) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				vala_report_warning (_tmp159_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp160_;
			ValaSymbol* _tmp161_;
			ValaSymbol* _tmp162_;
			_tmp160_ = ma;
			_tmp161_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp160_);
			_tmp162_ = _tmp161_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_SIGNAL)) {
				gboolean _tmp163_;
				gboolean _tmp164_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSignal* _tmp170_;
				ValaExpression* _tmp171_;
				ValaExpression* _tmp172_;
				ValaSignal* _tmp173_;
				ValaMemberAccess* _tmp174_;
				ValaExpression* _tmp175_;
				ValaExpression* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDelegate* _tmp179_;
				ValaDelegate* _tmp180_;
				ValaDelegateType* _tmp181_;
				ValaDelegateType* _tmp182_;
				_tmp163_ = vala_code_context_get_deprecated (context);
				_tmp164_ = _tmp163_;
				if (!_tmp164_) {
					ValaSourceReference* _tmp165_;
					ValaSourceReference* _tmp166_;
					_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp166_ = _tmp165_;
					vala_report_warning (_tmp166_, "deprecated syntax, use `connect' method instead");
				}
				_tmp167_ = ma;
				_tmp168_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp170_;
				_tmp171_ = vala_assignment_get_right (self);
				_tmp172_ = _tmp171_;
				_tmp173_ = sig;
				_tmp174_ = ma;
				_tmp175_ = vala_member_access_get_inner (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_expression_get_value_type (_tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_signal_get_delegate (_tmp173_, _tmp178_, (ValaCodeNode*) self);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_delegate_type_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_expression_set_target_type (_tmp172_, (ValaDataType*) _tmp182_);
				_vala_code_node_unref0 (_tmp182_);
				_vala_code_node_unref0 (_tmp180_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp183_ = ma;
				_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp183_);
				_tmp185_ = _tmp184_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp185_, VALA_TYPE_DYNAMIC_PROPERTY)) {
				} else {
					ValaExpression* _tmp186_;
					ValaExpression* _tmp187_;
					ValaMemberAccess* _tmp188_;
					ValaDataType* _tmp189_;
					ValaDataType* _tmp190_;
					ValaDataType* _tmp191_;
					ValaDataType* _tmp192_;
					ValaExpression* _tmp193_;
					ValaExpression* _tmp194_;
					ValaMemberAccess* _tmp195_;
					ValaDataType* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					_tmp186_ = vala_assignment_get_right (self);
					_tmp187_ = _tmp186_;
					_tmp188_ = ma;
					_tmp189_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_data_type_copy (_tmp190_);
					_tmp192_ = _tmp191_;
					vala_expression_set_formal_target_type (_tmp187_, _tmp192_);
					_vala_code_node_unref0 (_tmp192_);
					_tmp193_ = vala_assignment_get_right (self);
					_tmp194_ = _tmp193_;
					_tmp195_ = ma;
					_tmp196_ = vala_expression_get_value_type ((ValaExpression*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_data_type_copy (_tmp197_);
					_tmp199_ = _tmp198_;
					vala_expression_set_target_type (_tmp194_, _tmp199_);
					_vala_code_node_unref0 (_tmp199_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp200_;
		ValaExpression* _tmp201_;
		_tmp200_ = vala_assignment_get_left (self);
		_tmp201_ = _tmp200_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp201_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp202_;
			ValaExpression* _tmp203_;
			ValaElementAccess* _tmp204_;
			ValaElementAccess* _tmp205_;
			ValaExpression* _tmp206_;
			ValaExpression* _tmp207_;
			ValaDataType* _tmp208_;
			ValaDataType* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			ValaTypeSymbol* _tmp211_;
			ValaSemanticAnalyzer* _tmp212_;
			ValaSemanticAnalyzer* _tmp213_;
			ValaDataType* _tmp214_;
			ValaTypeSymbol* _tmp215_;
			ValaTypeSymbol* _tmp216_;
			_tmp202_ = vala_assignment_get_left (self);
			_tmp203_ = _tmp202_;
			_tmp204_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp203_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp204_;
			_tmp205_ = ea;
			_tmp206_ = vala_element_access_get_container (_tmp205_);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_expression_get_value_type (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_data_type_get_data_type (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_code_context_get_analyzer (context);
			_tmp213_ = _tmp212_;
			_tmp214_ = _tmp213_->string_type;
			_tmp215_ = vala_data_type_get_data_type (_tmp214_);
			_tmp216_ = _tmp215_;
			if (_tmp211_ == _tmp216_) {
				ValaElementAccess* _tmp217_;
				ValaSourceReference* _tmp218_;
				ValaSourceReference* _tmp219_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp217_ = ea;
				_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp217_);
				_tmp219_ = _tmp218_;
				vala_report_error (_tmp219_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp220_ = FALSE;
				ValaElementAccess* _tmp221_;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				_tmp221_ = ea;
				_tmp222_ = vala_element_access_get_container (_tmp221_);
				_tmp223_ = _tmp222_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp223_, VALA_TYPE_MEMBER_ACCESS)) {
					ValaElementAccess* _tmp224_;
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSymbol* _tmp227_;
					ValaSymbol* _tmp228_;
					_tmp224_ = ea;
					_tmp225_ = vala_element_access_get_container (_tmp224_);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_expression_get_symbol_reference (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp220_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp228_, VALA_TYPE_SIGNAL);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp229_;
					ValaExpression* _tmp230_;
					ValaExpression* _tmp231_;
					ValaMemberAccess* _tmp232_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaSymbol* _tmp237_;
					ValaSignal* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSignal* _tmp241_;
					ValaMemberAccess* _tmp242_;
					ValaExpression* _tmp243_;
					ValaExpression* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDelegate* _tmp247_;
					ValaDelegate* _tmp248_;
					ValaDelegateType* _tmp249_;
					ValaDelegateType* _tmp250_;
					_tmp229_ = ea;
					_tmp230_ = vala_element_access_get_container (_tmp229_);
					_tmp231_ = _tmp230_;
					_tmp232_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp231_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp232_;
					_tmp233_ = ea;
					_tmp234_ = vala_element_access_get_container (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_symbol_reference (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp237_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp238_;
					_tmp239_ = vala_assignment_get_right (self);
					_tmp240_ = _tmp239_;
					_tmp241_ = sig;
					_tmp242_ = ma;
					_tmp243_ = vala_member_access_get_inner (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_expression_get_value_type (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_signal_get_delegate (_tmp241_, _tmp246_, (ValaCodeNode*) self);
					_tmp248_ = _tmp247_;
					_tmp249_ = vala_delegate_type_new (_tmp248_);
					_tmp250_ = _tmp249_;
					vala_expression_set_target_type (_tmp240_, (ValaDataType*) _tmp250_);
					_vala_code_node_unref0 (_tmp250_);
					_vala_code_node_unref0 (_tmp248_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp251_;
					ValaExpression* _tmp252_;
					ValaExpression* _tmp253_;
					ValaDataType* _tmp254_;
					ValaDataType* _tmp255_;
					ValaSymbol* _tmp256_;
					ValaSymbol* _tmp257_;
					gboolean _tmp258_;
					_tmp251_ = ea;
					_tmp252_ = vala_element_access_get_container (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_expression_get_value_type (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_data_type_get_member (_tmp255_, "set");
					_tmp257_ = _tmp256_;
					_tmp258_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_METHOD);
					_vala_code_node_unref0 (_tmp257_);
					if (_tmp258_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp259_;
						ValaExpression* _tmp260_;
						ValaExpression* _tmp261_;
						ValaSourceReference* _tmp262_;
						ValaSourceReference* _tmp263_;
						ValaMemberAccess* _tmp264_;
						ValaMemberAccess* _tmp265_;
						ValaSourceReference* _tmp266_;
						ValaSourceReference* _tmp267_;
						ValaMethodCall* _tmp268_;
						ValaMethodCall* _tmp269_;
						ValaMethodCall* _tmp283_;
						ValaExpression* _tmp284_;
						ValaExpression* _tmp285_;
						ValaCodeNode* _tmp286_;
						ValaCodeNode* _tmp287_;
						ValaMethodCall* _tmp288_;
						ValaMethodCall* _tmp289_;
						_tmp259_ = ea;
						_tmp260_ = vala_element_access_get_container (_tmp259_);
						_tmp261_ = _tmp260_;
						_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp263_ = _tmp262_;
						_tmp264_ = vala_member_access_new (_tmp261_, "set", _tmp263_);
						_tmp265_ = _tmp264_;
						_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp267_ = _tmp266_;
						_tmp268_ = vala_method_call_new ((ValaExpression*) _tmp265_, _tmp267_);
						_tmp269_ = _tmp268_;
						_vala_code_node_unref0 (_tmp265_);
						set_call = _tmp269_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp270_;
							ValaList* _tmp271_;
							gint _e_size = 0;
							ValaList* _tmp272_;
							gint _tmp273_;
							gint _tmp274_;
							gint _e_index = 0;
							_tmp270_ = ea;
							_tmp271_ = vala_element_access_get_indices (_tmp270_);
							_e_list = _tmp271_;
							_tmp272_ = _e_list;
							_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
							_tmp274_ = _tmp273_;
							_e_size = _tmp274_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp275_;
								gint _tmp276_;
								gint _tmp277_;
								ValaExpression* e = NULL;
								ValaList* _tmp278_;
								gint _tmp279_;
								gpointer _tmp280_;
								ValaMethodCall* _tmp281_;
								ValaExpression* _tmp282_;
								_tmp275_ = _e_index;
								_e_index = _tmp275_ + 1;
								_tmp276_ = _e_index;
								_tmp277_ = _e_size;
								if (!(_tmp276_ < _tmp277_)) {
									break;
								}
								_tmp278_ = _e_list;
								_tmp279_ = _e_index;
								_tmp280_ = vala_list_get (_tmp278_, _tmp279_);
								e = (ValaExpression*) _tmp280_;
								_tmp281_ = set_call;
								_tmp282_ = e;
								vala_method_call_add_argument (_tmp281_, _tmp282_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp283_ = set_call;
						_tmp284_ = vala_assignment_get_right (self);
						_tmp285_ = _tmp284_;
						vala_method_call_add_argument (_tmp283_, _tmp285_);
						_tmp286_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp287_ = _tmp286_;
						_tmp288_ = set_call;
						vala_code_node_replace_expression (_tmp287_, (ValaExpression*) self, (ValaExpression*) _tmp288_);
						_tmp289_ = set_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp290_;
						ValaExpression* _tmp291_;
						ValaExpression* _tmp292_;
						ValaExpression* _tmp293_;
						ValaDataType* _tmp294_;
						ValaDataType* _tmp295_;
						_tmp290_ = vala_assignment_get_right (self);
						_tmp291_ = _tmp290_;
						_tmp292_ = vala_assignment_get_left (self);
						_tmp293_ = _tmp292_;
						_tmp294_ = vala_expression_get_value_type (_tmp293_);
						_tmp295_ = _tmp294_;
						vala_expression_set_target_type (_tmp291_, _tmp295_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp296_;
			ValaExpression* _tmp297_;
			_tmp296_ = vala_assignment_get_left (self);
			_tmp297_ = _tmp296_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp297_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaExpression* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				_tmp298_ = vala_assignment_get_right (self);
				_tmp299_ = _tmp298_;
				_tmp300_ = vala_assignment_get_left (self);
				_tmp301_ = _tmp300_;
				_tmp302_ = vala_expression_get_value_type (_tmp301_);
				_tmp303_ = _tmp302_;
				vala_expression_set_target_type (_tmp299_, _tmp303_);
			} else {
				ValaSourceReference* _tmp304_;
				ValaSourceReference* _tmp305_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp305_ = _tmp304_;
				vala_report_error (_tmp305_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp306_ = vala_assignment_get_right (self);
	_tmp307_ = _tmp306_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp307_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp309_ = self->priv->_operator;
	if (_tmp309_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp310_;
		ValaExpression* _tmp311_;
		_tmp310_ = vala_assignment_get_left (self);
		_tmp311_ = _tmp310_;
		_tmp308_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp311_, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp308_ = FALSE;
	}
	if (_tmp308_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp312_;
		ValaExpression* _tmp313_;
		ValaMemberAccess* _tmp314_;
		ValaMemberAccess* _tmp315_;
		ValaSymbol* _tmp316_;
		ValaSymbol* _tmp317_;
		_tmp312_ = vala_assignment_get_left (self);
		_tmp313_ = _tmp312_;
		_tmp314_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp314_;
		_tmp315_ = ma;
		_tmp316_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp315_);
		_tmp317_ = _tmp316_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_SIGNAL)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp318_;
			ValaExpression* _tmp319_;
			ValaExpression* _tmp320_;
			ValaMemberAccess* _tmp321_;
			const gchar* _tmp322_;
			const gchar* _tmp323_;
			ValaMemberAccess* _tmp324_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp325_;
			ValaExpression* _tmp326_;
			ValaExpression* _tmp327_;
			ValaSourceReference* _tmp328_;
			ValaSourceReference* _tmp329_;
			ValaBinaryExpression* _tmp330_;
			ValaBinaryExpression* _tmp331_;
			ValaExpression* _tmp332_;
			ValaExpression* _tmp333_;
			ValaDataType* _tmp334_;
			ValaDataType* _tmp335_;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			ValaExpression* _tmp338_;
			ValaExpression* _tmp339_;
			ValaDataType* _tmp340_;
			ValaDataType* _tmp341_;
			ValaDataType* _tmp342_;
			ValaDataType* _tmp343_;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			ValaAssignmentOperator _tmp348_;
			ValaBinaryExpression* _tmp368_;
			ValaExpression* _tmp369_;
			ValaExpression* _tmp370_;
			_tmp318_ = ma;
			_tmp319_ = vala_member_access_get_inner (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = ma;
			_tmp322_ = vala_member_access_get_member_name (_tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = vala_member_access_new (_tmp320_, _tmp323_, NULL);
			old_value = _tmp324_;
			_tmp325_ = old_value;
			_tmp326_ = vala_assignment_get_right (self);
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp329_ = _tmp328_;
			_tmp330_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp325_, _tmp327_, _tmp329_);
			bin = _tmp330_;
			_tmp331_ = bin;
			_tmp332_ = vala_assignment_get_right (self);
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_expression_get_target_type (_tmp333_);
			_tmp335_ = _tmp334_;
			vala_expression_set_target_type ((ValaExpression*) _tmp331_, _tmp335_);
			_tmp336_ = vala_assignment_get_right (self);
			_tmp337_ = _tmp336_;
			_tmp338_ = vala_assignment_get_right (self);
			_tmp339_ = _tmp338_;
			_tmp340_ = vala_expression_get_target_type (_tmp339_);
			_tmp341_ = _tmp340_;
			_tmp342_ = vala_data_type_copy (_tmp341_);
			_tmp343_ = _tmp342_;
			vala_expression_set_target_type (_tmp337_, _tmp343_);
			_vala_code_node_unref0 (_tmp343_);
			_tmp344_ = vala_assignment_get_right (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			vala_data_type_set_value_owned (_tmp347_, FALSE);
			_tmp348_ = self->priv->_operator;
			if (_tmp348_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				ValaBinaryExpression* _tmp349_;
				_tmp349_ = bin;
				vala_binary_expression_set_operator (_tmp349_, VALA_BINARY_OPERATOR_BITWISE_OR);
			} else {
				ValaAssignmentOperator _tmp350_;
				_tmp350_ = self->priv->_operator;
				if (_tmp350_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					ValaBinaryExpression* _tmp351_;
					_tmp351_ = bin;
					vala_binary_expression_set_operator (_tmp351_, VALA_BINARY_OPERATOR_BITWISE_AND);
				} else {
					ValaAssignmentOperator _tmp352_;
					_tmp352_ = self->priv->_operator;
					if (_tmp352_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						ValaBinaryExpression* _tmp353_;
						_tmp353_ = bin;
						vala_binary_expression_set_operator (_tmp353_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					} else {
						ValaAssignmentOperator _tmp354_;
						_tmp354_ = self->priv->_operator;
						if (_tmp354_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
							ValaBinaryExpression* _tmp355_;
							_tmp355_ = bin;
							vala_binary_expression_set_operator (_tmp355_, VALA_BINARY_OPERATOR_PLUS);
						} else {
							ValaAssignmentOperator _tmp356_;
							_tmp356_ = self->priv->_operator;
							if (_tmp356_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
								ValaBinaryExpression* _tmp357_;
								_tmp357_ = bin;
								vala_binary_expression_set_operator (_tmp357_, VALA_BINARY_OPERATOR_MINUS);
							} else {
								ValaAssignmentOperator _tmp358_;
								_tmp358_ = self->priv->_operator;
								if (_tmp358_ == VALA_ASSIGNMENT_OPERATOR_MUL) {
									ValaBinaryExpression* _tmp359_;
									_tmp359_ = bin;
									vala_binary_expression_set_operator (_tmp359_, VALA_BINARY_OPERATOR_MUL);
								} else {
									ValaAssignmentOperator _tmp360_;
									_tmp360_ = self->priv->_operator;
									if (_tmp360_ == VALA_ASSIGNMENT_OPERATOR_DIV) {
										ValaBinaryExpression* _tmp361_;
										_tmp361_ = bin;
										vala_binary_expression_set_operator (_tmp361_, VALA_BINARY_OPERATOR_DIV);
									} else {
										ValaAssignmentOperator _tmp362_;
										_tmp362_ = self->priv->_operator;
										if (_tmp362_ == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											ValaBinaryExpression* _tmp363_;
											_tmp363_ = bin;
											vala_binary_expression_set_operator (_tmp363_, VALA_BINARY_OPERATOR_MOD);
										} else {
											ValaAssignmentOperator _tmp364_;
											_tmp364_ = self->priv->_operator;
											if (_tmp364_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												ValaBinaryExpression* _tmp365_;
												_tmp365_ = bin;
												vala_binary_expression_set_operator (_tmp365_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
											} else {
												ValaAssignmentOperator _tmp366_;
												_tmp366_ = self->priv->_operator;
												if (_tmp366_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													ValaBinaryExpression* _tmp367_;
													_tmp367_ = bin;
													vala_binary_expression_set_operator (_tmp367_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp368_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp368_);
			_tmp369_ = vala_assignment_get_right (self);
			_tmp370_ = _tmp369_;
			vala_code_node_check ((ValaCodeNode*) _tmp370_, context);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp371_ = vala_assignment_get_left (self);
	_tmp372_ = _tmp371_;
	_tmp373_ = vala_expression_get_symbol_reference (_tmp372_);
	_tmp374_ = _tmp373_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp374_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp375_;
		ValaExpression* _tmp376_;
		ValaSymbol* _tmp377_;
		ValaSymbol* _tmp378_;
		ValaSignal* _tmp379_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp380_;
		ValaExpression* _tmp381_;
		ValaSymbol* _tmp382_;
		ValaSymbol* _tmp383_;
		ValaMethod* _tmp384_;
		ValaMethod* _tmp385_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp390_;
		ValaDynamicSignal* _tmp391_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp392_;
		ValaExpression* _tmp393_;
		ValaMemberAccess* _tmp394_;
		ValaDynamicSignal* _tmp395_;
		_tmp375_ = vala_assignment_get_left (self);
		_tmp376_ = _tmp375_;
		_tmp377_ = vala_expression_get_symbol_reference (_tmp376_);
		_tmp378_ = _tmp377_;
		_tmp379_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp378_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp379_;
		_tmp380_ = vala_assignment_get_right (self);
		_tmp381_ = _tmp380_;
		_tmp382_ = vala_expression_get_symbol_reference (_tmp381_);
		_tmp383_ = _tmp382_;
		_tmp384_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp383_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp383_) : NULL);
		m = _tmp384_;
		_tmp385_ = m;
		if (_tmp385_ == NULL) {
			ValaExpression* _tmp386_;
			ValaExpression* _tmp387_;
			ValaSourceReference* _tmp388_;
			ValaSourceReference* _tmp389_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp386_ = vala_assignment_get_right (self);
			_tmp387_ = _tmp386_;
			_tmp388_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp387_);
			_tmp389_ = _tmp388_;
			vala_report_error (_tmp389_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp390_ = sig;
		_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp390_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp390_) : NULL);
		dynamic_sig = _tmp391_;
		_tmp392_ = vala_assignment_get_right (self);
		_tmp393_ = _tmp392_;
		_tmp394_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp393_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp393_) : NULL);
		right_ma = _tmp394_;
		_tmp395_ = dynamic_sig;
		if (_tmp395_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp416_;
			ValaExpression* _tmp417_;
			ValaSignal* _tmp418_;
			ValaSignal* _tmp419_;
			ValaSymbol* _tmp420_;
			ValaSymbol* _tmp421_;
			ValaObjectType* _tmp422_;
			ValaObjectType* _tmp423_;
			ValaDelegate* _tmp424_;
			ValaDelegate* _tmp425_;
			ValaDelegateType* _tmp426_;
			ValaDelegateType* _tmp427_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp396_;
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				ValaList* _tmp401_;
				gint _param_size = 0;
				ValaList* _tmp402_;
				gint _tmp403_;
				gint _tmp404_;
				gint _param_index = 0;
				_tmp396_ = dynamic_sig;
				_tmp397_ = vala_dynamic_signal_get_handler (_tmp396_);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_parameters (_tmp400_);
				_param_list = _tmp401_;
				_tmp402_ = _param_list;
				_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
				_tmp404_ = _tmp403_;
				_param_size = _tmp404_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp405_;
					gint _tmp406_;
					gint _tmp407_;
					ValaParameter* param = NULL;
					ValaList* _tmp408_;
					gint _tmp409_;
					gpointer _tmp410_;
					gboolean _tmp411_;
					_tmp405_ = _param_index;
					_param_index = _tmp405_ + 1;
					_tmp406_ = _param_index;
					_tmp407_ = _param_size;
					if (!(_tmp406_ < _tmp407_)) {
						break;
					}
					_tmp408_ = _param_list;
					_tmp409_ = _param_index;
					_tmp410_ = vala_list_get (_tmp408_, _tmp409_);
					param = (ValaParameter*) _tmp410_;
					_tmp411_ = first;
					if (_tmp411_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp412_;
						ValaParameter* _tmp413_;
						ValaParameter* _tmp414_;
						ValaParameter* _tmp415_;
						_tmp412_ = dynamic_sig;
						_tmp413_ = param;
						_tmp414_ = vala_parameter_copy (_tmp413_);
						_tmp415_ = _tmp414_;
						vala_callable_add_parameter ((ValaCallable*) _tmp412_, _tmp415_);
						_vala_code_node_unref0 (_tmp415_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp416_ = vala_assignment_get_right (self);
			_tmp417_ = _tmp416_;
			_tmp418_ = sig;
			_tmp419_ = sig;
			_tmp420_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp419_);
			_tmp421_ = _tmp420_;
			_tmp422_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp421_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp423_ = _tmp422_;
			_tmp424_ = vala_signal_get_delegate (_tmp418_, (ValaDataType*) _tmp423_, (ValaCodeNode*) self);
			_tmp425_ = _tmp424_;
			_tmp426_ = vala_delegate_type_new (_tmp425_);
			_tmp427_ = _tmp426_;
			vala_expression_set_target_type (_tmp417_, (ValaDataType*) _tmp427_);
			_vala_code_node_unref0 (_tmp427_);
			_vala_code_node_unref0 (_tmp425_);
			_vala_code_node_unref0 (_tmp423_);
		} else {
			ValaExpression* _tmp428_;
			ValaExpression* _tmp429_;
			ValaDataType* _tmp430_;
			ValaDataType* _tmp431_;
			ValaExpression* _tmp432_;
			ValaExpression* _tmp433_;
			ValaDataType* _tmp434_;
			ValaDataType* _tmp435_;
			_tmp428_ = vala_assignment_get_right (self);
			_tmp429_ = _tmp428_;
			_tmp430_ = vala_expression_get_value_type (_tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_assignment_get_right (self);
			_tmp433_ = _tmp432_;
			_tmp434_ = vala_expression_get_target_type (_tmp433_);
			_tmp435_ = _tmp434_;
			if (!vala_data_type_compatible (_tmp431_, _tmp435_)) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp436_;
				ValaExpression* _tmp437_;
				ValaDataType* _tmp438_;
				ValaDataType* _tmp439_;
				ValaDelegateType* _tmp440_;
				ValaExpression* _tmp441_;
				ValaExpression* _tmp442_;
				ValaSourceReference* _tmp443_;
				ValaSourceReference* _tmp444_;
				ValaExpression* _tmp445_;
				ValaExpression* _tmp446_;
				ValaDataType* _tmp447_;
				ValaDataType* _tmp448_;
				gchar* _tmp449_;
				gchar* _tmp450_;
				ValaExpression* _tmp451_;
				ValaExpression* _tmp452_;
				ValaDataType* _tmp453_;
				ValaDataType* _tmp454_;
				gchar* _tmp455_;
				gchar* _tmp456_;
				ValaDelegateType* _tmp457_;
				ValaMethod* _tmp458_;
				const gchar* _tmp459_;
				const gchar* _tmp460_;
				gchar* _tmp461_;
				gchar* _tmp462_;
				gchar* _tmp463_;
				gchar* _tmp464_;
				_tmp436_ = vala_assignment_get_right (self);
				_tmp437_ = _tmp436_;
				_tmp438_ = vala_expression_get_target_type (_tmp437_);
				_tmp439_ = _tmp438_;
				_tmp440_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp440_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp441_ = vala_assignment_get_right (self);
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp442_);
				_tmp444_ = _tmp443_;
				_tmp445_ = vala_assignment_get_right (self);
				_tmp446_ = _tmp445_;
				_tmp447_ = vala_expression_get_value_type (_tmp446_);
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_code_node_to_string ((ValaCodeNode*) _tmp448_);
				_tmp450_ = _tmp449_;
				_tmp451_ = vala_assignment_get_right (self);
				_tmp452_ = _tmp451_;
				_tmp453_ = vala_expression_get_target_type (_tmp452_);
				_tmp454_ = _tmp453_;
				_tmp455_ = vala_code_node_to_string ((ValaCodeNode*) _tmp454_);
				_tmp456_ = _tmp455_;
				_tmp457_ = delegate_type;
				_tmp458_ = m;
				_tmp459_ = vala_symbol_get_name ((ValaSymbol*) _tmp458_);
				_tmp460_ = _tmp459_;
				_tmp461_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp457_, _tmp460_);
				_tmp462_ = _tmp461_;
				_tmp463_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp450_, _tmp456_, _tmp462_);
				_tmp464_ = _tmp463_;
				vala_report_error (_tmp444_, _tmp464_);
				_g_free0 (_tmp464_);
				_g_free0 (_tmp462_);
				_g_free0 (_tmp456_);
				_g_free0 (_tmp450_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp465_ = FALSE;
				ValaMemberAccess* _tmp466_;
				_tmp466_ = right_ma;
				if (_tmp466_ != NULL) {
					ValaMemberAccess* _tmp467_;
					gboolean _tmp468_;
					gboolean _tmp469_;
					_tmp467_ = right_ma;
					_tmp468_ = vala_member_access_get_prototype_access (_tmp467_);
					_tmp469_ = _tmp468_;
					_tmp465_ = _tmp469_;
				} else {
					_tmp465_ = FALSE;
				}
				if (_tmp465_) {
					ValaExpression* _tmp470_;
					ValaExpression* _tmp471_;
					ValaSourceReference* _tmp472_;
					ValaSourceReference* _tmp473_;
					ValaMethod* _tmp474_;
					gchar* _tmp475_;
					gchar* _tmp476_;
					gchar* _tmp477_;
					gchar* _tmp478_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp470_ = vala_assignment_get_right (self);
					_tmp471_ = _tmp470_;
					_tmp472_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp471_);
					_tmp473_ = _tmp472_;
					_tmp474_ = m;
					_tmp475_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp474_);
					_tmp476_ = _tmp475_;
					_tmp477_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp476_);
					_tmp478_ = _tmp477_;
					vala_report_error (_tmp473_, _tmp478_);
					_g_free0 (_tmp478_);
					_g_free0 (_tmp476_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp479_;
		ValaExpression* _tmp480_;
		_tmp479_ = vala_assignment_get_left (self);
		_tmp480_ = _tmp479_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp480_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp481_;
			ValaExpression* _tmp482_;
			ValaMemberAccess* _tmp483_;
			ValaMemberAccess* _tmp484_;
			ValaSymbol* _tmp485_;
			ValaSymbol* _tmp486_;
			gboolean _tmp624_ = FALSE;
			ValaExpression* _tmp625_;
			ValaExpression* _tmp626_;
			ValaDataType* _tmp627_;
			ValaDataType* _tmp628_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp683_;
			ValaExpression* _tmp684_;
			ValaMemberAccess* _tmp685_;
			gboolean _tmp686_ = FALSE;
			ValaMemberAccess* _tmp687_;
			_tmp481_ = vala_assignment_get_left (self);
			_tmp482_ = _tmp481_;
			_tmp483_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp483_;
			_tmp484_ = ma;
			_tmp485_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp484_);
			_tmp486_ = _tmp485_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp486_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp487_;
				ValaSymbol* _tmp488_;
				ValaSymbol* _tmp489_;
				ValaProperty* _tmp490_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp491_;
				ValaDynamicProperty* _tmp492_;
				ValaDynamicProperty* _tmp493_;
				gboolean _tmp508_ = FALSE;
				ValaProperty* _tmp509_;
				ValaPropertyAccessor* _tmp510_;
				ValaPropertyAccessor* _tmp511_;
				_tmp487_ = ma;
				_tmp488_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp487_);
				_tmp489_ = _tmp488_;
				_tmp490_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp490_;
				_tmp491_ = prop;
				_tmp492_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp491_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp491_) : NULL);
				dynamic_prop = _tmp492_;
				_tmp493_ = dynamic_prop;
				if (_tmp493_ != NULL) {
					ValaDynamicProperty* _tmp494_;
					ValaExpression* _tmp495_;
					ValaExpression* _tmp496_;
					ValaDataType* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaDataType* _tmp500_;
					ValaExpression* _tmp501_;
					ValaExpression* _tmp502_;
					ValaDynamicProperty* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDataType* _tmp507_;
					_tmp494_ = dynamic_prop;
					_tmp495_ = vala_assignment_get_right (self);
					_tmp496_ = _tmp495_;
					_tmp497_ = vala_expression_get_value_type (_tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_data_type_copy (_tmp498_);
					_tmp500_ = _tmp499_;
					vala_property_set_property_type ((ValaProperty*) _tmp494_, _tmp500_);
					_vala_code_node_unref0 (_tmp500_);
					_tmp501_ = vala_assignment_get_left (self);
					_tmp502_ = _tmp501_;
					_tmp503_ = dynamic_prop;
					_tmp504_ = vala_property_get_property_type ((ValaProperty*) _tmp503_);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_data_type_copy (_tmp505_);
					_tmp507_ = _tmp506_;
					vala_expression_set_value_type (_tmp502_, _tmp507_);
					_vala_code_node_unref0 (_tmp507_);
				}
				_tmp509_ = prop;
				_tmp510_ = vala_property_get_set_accessor (_tmp509_);
				_tmp511_ = _tmp510_;
				if (_tmp511_ == NULL) {
					_tmp508_ = TRUE;
				} else {
					gboolean _tmp512_ = FALSE;
					ValaProperty* _tmp513_;
					ValaPropertyAccessor* _tmp514_;
					ValaPropertyAccessor* _tmp515_;
					gboolean _tmp516_;
					gboolean _tmp517_;
					_tmp513_ = prop;
					_tmp514_ = vala_property_get_set_accessor (_tmp513_);
					_tmp515_ = _tmp514_;
					_tmp516_ = vala_property_accessor_get_writable (_tmp515_);
					_tmp517_ = _tmp516_;
					if (!_tmp517_) {
						gboolean _tmp518_ = FALSE;
						ValaSemanticAnalyzer* _tmp519_;
						ValaSemanticAnalyzer* _tmp520_;
						ValaMethod* _tmp521_;
						ValaMethod* _tmp522_;
						gboolean _tmp523_;
						_tmp519_ = vala_code_context_get_analyzer (context);
						_tmp520_ = _tmp519_;
						_tmp521_ = vala_semantic_analyzer_find_current_method (_tmp520_);
						_tmp522_ = _tmp521_;
						_tmp523_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp522_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp522_);
						if (_tmp523_) {
							_tmp518_ = TRUE;
						} else {
							ValaSemanticAnalyzer* _tmp524_;
							ValaSemanticAnalyzer* _tmp525_;
							_tmp524_ = vala_code_context_get_analyzer (context);
							_tmp525_ = _tmp524_;
							_tmp518_ = vala_semantic_analyzer_is_in_constructor (_tmp525_);
						}
						_tmp512_ = !_tmp518_;
					} else {
						_tmp512_ = FALSE;
					}
					_tmp508_ = _tmp512_;
				}
				if (_tmp508_) {
					ValaMemberAccess* _tmp526_;
					ValaMemberAccess* _tmp527_;
					ValaSourceReference* _tmp528_;
					ValaSourceReference* _tmp529_;
					ValaProperty* _tmp530_;
					gchar* _tmp531_;
					gchar* _tmp532_;
					gchar* _tmp533_;
					gchar* _tmp534_;
					_tmp526_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp526_, TRUE);
					_tmp527_ = ma;
					_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp527_);
					_tmp529_ = _tmp528_;
					_tmp530_ = prop;
					_tmp531_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp530_);
					_tmp532_ = _tmp531_;
					_tmp533_ = g_strdup_printf ("Property `%s' is read-only", _tmp532_);
					_tmp534_ = _tmp533_;
					vala_report_error (_tmp529_, _tmp534_);
					_g_free0 (_tmp534_);
					_g_free0 (_tmp532_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp535_ = FALSE;
					gboolean _tmp536_ = FALSE;
					gboolean _tmp537_;
					gboolean _tmp538_;
					_tmp537_ = vala_code_context_get_deprecated (context);
					_tmp538_ = _tmp537_;
					if (!_tmp538_) {
						ValaProperty* _tmp539_;
						ValaPropertyAccessor* _tmp540_;
						ValaPropertyAccessor* _tmp541_;
						gboolean _tmp542_;
						gboolean _tmp543_;
						_tmp539_ = prop;
						_tmp540_ = vala_property_get_set_accessor (_tmp539_);
						_tmp541_ = _tmp540_;
						_tmp542_ = vala_property_accessor_get_writable (_tmp541_);
						_tmp543_ = _tmp542_;
						_tmp536_ = !_tmp543_;
					} else {
						_tmp536_ = FALSE;
					}
					if (_tmp536_) {
						ValaSemanticAnalyzer* _tmp544_;
						ValaSemanticAnalyzer* _tmp545_;
						ValaMethod* _tmp546_;
						ValaMethod* _tmp547_;
						_tmp544_ = vala_code_context_get_analyzer (context);
						_tmp545_ = _tmp544_;
						_tmp546_ = vala_semantic_analyzer_find_current_method (_tmp545_);
						_tmp547_ = _tmp546_;
						_tmp535_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp547_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp547_);
					} else {
						_tmp535_ = FALSE;
					}
					if (_tmp535_) {
						ValaMemberAccess* _tmp548_;
						ValaExpression* _tmp549_;
						ValaExpression* _tmp550_;
						ValaSymbol* _tmp551_;
						ValaSymbol* _tmp552_;
						ValaSemanticAnalyzer* _tmp553_;
						ValaSemanticAnalyzer* _tmp554_;
						ValaMethod* _tmp555_;
						ValaMethod* _tmp556_;
						ValaParameter* _tmp557_;
						ValaParameter* _tmp558_;
						gboolean _tmp559_;
						_tmp548_ = ma;
						_tmp549_ = vala_member_access_get_inner (_tmp548_);
						_tmp550_ = _tmp549_;
						_tmp551_ = vala_expression_get_symbol_reference (_tmp550_);
						_tmp552_ = _tmp551_;
						_tmp553_ = vala_code_context_get_analyzer (context);
						_tmp554_ = _tmp553_;
						_tmp555_ = vala_semantic_analyzer_find_current_method (_tmp554_);
						_tmp556_ = _tmp555_;
						_tmp557_ = vala_method_get_this_parameter (_tmp556_);
						_tmp558_ = _tmp557_;
						_tmp559_ = _tmp552_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp558_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp556_);
						if (_tmp559_) {
							ValaMemberAccess* _tmp560_;
							ValaSourceReference* _tmp561_;
							ValaSourceReference* _tmp562_;
							ValaProperty* _tmp563_;
							gchar* _tmp564_;
							gchar* _tmp565_;
							gchar* _tmp566_;
							gchar* _tmp567_;
							_tmp560_ = ma;
							_tmp561_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp560_);
							_tmp562_ = _tmp561_;
							_tmp563_ = prop;
							_tmp564_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp563_);
							_tmp565_ = _tmp564_;
							_tmp566_ = g_strdup_printf ("Property `%s' is read-only", _tmp565_);
							_tmp567_ = _tmp566_;
							vala_report_error (_tmp562_, _tmp567_);
							_g_free0 (_tmp567_);
							_g_free0 (_tmp565_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp568_;
							ValaSourceReference* _tmp569_;
							ValaSourceReference* _tmp570_;
							_tmp568_ = ma;
							_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp568_);
							_tmp570_ = _tmp569_;
							vala_report_error (_tmp570_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp571_ = FALSE;
				ValaMemberAccess* _tmp572_;
				ValaSymbol* _tmp573_;
				ValaSymbol* _tmp574_;
				_tmp572_ = ma;
				_tmp573_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp572_);
				_tmp574_ = _tmp573_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp574_, VALA_TYPE_VARIABLE)) {
					ValaExpression* _tmp575_;
					ValaExpression* _tmp576_;
					ValaDataType* _tmp577_;
					ValaDataType* _tmp578_;
					_tmp575_ = vala_assignment_get_right (self);
					_tmp576_ = _tmp575_;
					_tmp577_ = vala_expression_get_value_type (_tmp576_);
					_tmp578_ = _tmp577_;
					_tmp571_ = _tmp578_ == NULL;
				} else {
					_tmp571_ = FALSE;
				}
				if (_tmp571_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp579_;
					ValaSymbol* _tmp580_;
					ValaSymbol* _tmp581_;
					ValaVariable* _tmp582_;
					gboolean _tmp583_ = FALSE;
					ValaExpression* _tmp584_;
					ValaExpression* _tmp585_;
					ValaSymbol* _tmp586_;
					ValaSymbol* _tmp587_;
					_tmp579_ = ma;
					_tmp580_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp579_);
					_tmp581_ = _tmp580_;
					_tmp582_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp582_;
					_tmp584_ = vala_assignment_get_right (self);
					_tmp585_ = _tmp584_;
					_tmp586_ = vala_expression_get_symbol_reference (_tmp585_);
					_tmp587_ = _tmp586_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp587_, VALA_TYPE_METHOD)) {
						ValaVariable* _tmp588_;
						ValaDataType* _tmp589_;
						ValaDataType* _tmp590_;
						_tmp588_ = variable;
						_tmp589_ = vala_variable_get_variable_type (_tmp588_);
						_tmp590_ = _tmp589_;
						_tmp583_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp590_, VALA_TYPE_DELEGATE_TYPE);
					} else {
						_tmp583_ = FALSE;
					}
					if (_tmp583_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp591_;
						ValaExpression* _tmp592_;
						ValaSymbol* _tmp593_;
						ValaSymbol* _tmp594_;
						ValaMethod* _tmp595_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp596_;
						ValaDataType* _tmp597_;
						ValaDataType* _tmp598_;
						ValaDelegateType* _tmp599_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp600_;
						ValaDelegate* _tmp601_;
						ValaDelegate* _tmp602_;
						ValaDelegate* _tmp603_;
						ValaDelegate* _tmp604_;
						ValaMethod* _tmp605_;
						ValaDelegateType* _tmp606_;
						ValaExpression* _tmp617_;
						ValaExpression* _tmp618_;
						ValaVariable* _tmp619_;
						ValaDataType* _tmp620_;
						ValaDataType* _tmp621_;
						_tmp591_ = vala_assignment_get_right (self);
						_tmp592_ = _tmp591_;
						_tmp593_ = vala_expression_get_symbol_reference (_tmp592_);
						_tmp594_ = _tmp593_;
						_tmp595_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp594_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp595_;
						_tmp596_ = variable;
						_tmp597_ = vala_variable_get_variable_type (_tmp596_);
						_tmp598_ = _tmp597_;
						_tmp599_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp598_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp599_;
						_tmp600_ = dt;
						_tmp601_ = vala_delegate_type_get_delegate_symbol (_tmp600_);
						_tmp602_ = _tmp601_;
						_tmp603_ = _vala_code_node_ref0 (_tmp602_);
						cb = _tmp603_;
						_tmp604_ = cb;
						_tmp605_ = m;
						_tmp606_ = dt;
						if (!vala_delegate_matches_method (_tmp604_, _tmp605_, (ValaDataType*) _tmp606_)) {
							ValaSourceReference* _tmp607_;
							ValaSourceReference* _tmp608_;
							ValaMethod* _tmp609_;
							gchar* _tmp610_;
							gchar* _tmp611_;
							ValaDelegate* _tmp612_;
							gchar* _tmp613_;
							gchar* _tmp614_;
							gchar* _tmp615_;
							gchar* _tmp616_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp607_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp608_ = _tmp607_;
							_tmp609_ = m;
							_tmp610_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp609_);
							_tmp611_ = _tmp610_;
							_tmp612_ = cb;
							_tmp613_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp612_);
							_tmp614_ = _tmp613_;
							_tmp615_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp611_, _tmp614_);
							_tmp616_ = _tmp615_;
							vala_report_error (_tmp608_, _tmp616_);
							_g_free0 (_tmp616_);
							_g_free0 (_tmp614_);
							_g_free0 (_tmp611_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_tmp617_ = vala_assignment_get_right (self);
						_tmp618_ = _tmp617_;
						_tmp619_ = variable;
						_tmp620_ = vala_variable_get_variable_type (_tmp619_);
						_tmp621_ = _tmp620_;
						vala_expression_set_value_type (_tmp618_, _tmp621_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp622_;
						ValaSourceReference* _tmp623_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp622_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp623_ = _tmp622_;
						vala_report_error (_tmp623_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						_vala_code_node_unref0 (ma);
						return result;
					}
					_vala_code_node_unref0 (variable);
				}
			}
			_tmp625_ = vala_assignment_get_left (self);
			_tmp626_ = _tmp625_;
			_tmp627_ = vala_expression_get_value_type (_tmp626_);
			_tmp628_ = _tmp627_;
			if (_tmp628_ != NULL) {
				ValaExpression* _tmp629_;
				ValaExpression* _tmp630_;
				ValaDataType* _tmp631_;
				ValaDataType* _tmp632_;
				_tmp629_ = vala_assignment_get_right (self);
				_tmp630_ = _tmp629_;
				_tmp631_ = vala_expression_get_value_type (_tmp630_);
				_tmp632_ = _tmp631_;
				_tmp624_ = _tmp632_ != NULL;
			} else {
				_tmp624_ = FALSE;
			}
			if (_tmp624_) {
				ValaExpression* _tmp633_;
				ValaExpression* _tmp634_;
				ValaDataType* _tmp635_;
				ValaDataType* _tmp636_;
				ValaExpression* _tmp637_;
				ValaExpression* _tmp638_;
				ValaDataType* _tmp639_;
				ValaDataType* _tmp640_;
				ValaMemberAccess* _tmp657_;
				ValaSymbol* _tmp658_;
				ValaSymbol* _tmp659_;
				_tmp633_ = vala_assignment_get_right (self);
				_tmp634_ = _tmp633_;
				_tmp635_ = vala_expression_get_value_type (_tmp634_);
				_tmp636_ = _tmp635_;
				_tmp637_ = vala_assignment_get_left (self);
				_tmp638_ = _tmp637_;
				_tmp639_ = vala_expression_get_value_type (_tmp638_);
				_tmp640_ = _tmp639_;
				if (!vala_data_type_compatible (_tmp636_, _tmp640_)) {
					ValaSourceReference* _tmp641_;
					ValaSourceReference* _tmp642_;
					ValaExpression* _tmp643_;
					ValaExpression* _tmp644_;
					ValaDataType* _tmp645_;
					ValaDataType* _tmp646_;
					gchar* _tmp647_;
					gchar* _tmp648_;
					ValaExpression* _tmp649_;
					ValaExpression* _tmp650_;
					ValaDataType* _tmp651_;
					ValaDataType* _tmp652_;
					gchar* _tmp653_;
					gchar* _tmp654_;
					gchar* _tmp655_;
					gchar* _tmp656_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp641_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_assignment_get_right (self);
					_tmp644_ = _tmp643_;
					_tmp645_ = vala_expression_get_value_type (_tmp644_);
					_tmp646_ = _tmp645_;
					_tmp647_ = vala_code_node_to_string ((ValaCodeNode*) _tmp646_);
					_tmp648_ = _tmp647_;
					_tmp649_ = vala_assignment_get_left (self);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_expression_get_value_type (_tmp650_);
					_tmp652_ = _tmp651_;
					_tmp653_ = vala_code_node_to_string ((ValaCodeNode*) _tmp652_);
					_tmp654_ = _tmp653_;
					_tmp655_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp648_, _tmp654_);
					_tmp656_ = _tmp655_;
					vala_report_error (_tmp642_, _tmp656_);
					_g_free0 (_tmp656_);
					_g_free0 (_tmp654_);
					_g_free0 (_tmp648_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp657_ = ma;
				_tmp658_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp657_);
				_tmp659_ = _tmp658_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp659_, VALA_TYPE_PROPERTY)) {
					ValaExpression* _tmp660_;
					ValaExpression* _tmp661_;
					ValaDataType* _tmp662_;
					ValaDataType* _tmp663_;
					_tmp660_ = vala_assignment_get_right (self);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_expression_get_value_type (_tmp661_);
					_tmp663_ = _tmp662_;
					if (vala_data_type_is_disposable (_tmp663_)) {
						gboolean _tmp664_ = FALSE;
						ValaExpression* _tmp665_;
						ValaExpression* _tmp666_;
						ValaDataType* _tmp667_;
						ValaDataType* _tmp668_;
						_tmp665_ = vala_assignment_get_left (self);
						_tmp666_ = _tmp665_;
						_tmp667_ = vala_expression_get_value_type (_tmp666_);
						_tmp668_ = _tmp667_;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp668_, VALA_TYPE_POINTER_TYPE)) {
							ValaExpression* _tmp669_;
							ValaExpression* _tmp670_;
							ValaDataType* _tmp671_;
							ValaDataType* _tmp672_;
							gboolean _tmp673_;
							gboolean _tmp674_;
							_tmp669_ = vala_assignment_get_left (self);
							_tmp670_ = _tmp669_;
							_tmp671_ = vala_expression_get_value_type (_tmp670_);
							_tmp672_ = _tmp671_;
							_tmp673_ = vala_data_type_get_value_owned (_tmp672_);
							_tmp674_ = _tmp673_;
							_tmp664_ = !_tmp674_;
						} else {
							_tmp664_ = FALSE;
						}
						if (_tmp664_) {
							ValaSourceReference* _tmp675_;
							ValaSourceReference* _tmp676_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp675_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp676_ = _tmp675_;
							vala_report_error (_tmp676_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp677_;
						ValaExpression* _tmp678_;
						ValaDataType* _tmp679_;
						ValaDataType* _tmp680_;
						gboolean _tmp681_;
						gboolean _tmp682_;
						_tmp677_ = vala_assignment_get_left (self);
						_tmp678_ = _tmp677_;
						_tmp679_ = vala_expression_get_value_type (_tmp678_);
						_tmp680_ = _tmp679_;
						_tmp681_ = vala_data_type_get_value_owned (_tmp680_);
						_tmp682_ = _tmp681_;
						if (_tmp682_) {
						}
					}
				}
			}
			_tmp683_ = vala_assignment_get_right (self);
			_tmp684_ = _tmp683_;
			_tmp685_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp684_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp684_) : NULL);
			right_ma = _tmp685_;
			_tmp687_ = right_ma;
			if (_tmp687_ != NULL) {
				ValaMemberAccess* _tmp688_;
				ValaSymbol* _tmp689_;
				ValaSymbol* _tmp690_;
				ValaMemberAccess* _tmp691_;
				ValaSymbol* _tmp692_;
				ValaSymbol* _tmp693_;
				_tmp688_ = ma;
				_tmp689_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp688_);
				_tmp690_ = _tmp689_;
				_tmp691_ = right_ma;
				_tmp692_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp691_);
				_tmp693_ = _tmp692_;
				_tmp686_ = _tmp690_ == _tmp693_;
			} else {
				_tmp686_ = FALSE;
			}
			if (_tmp686_) {
				gboolean _tmp694_ = FALSE;
				ValaMemberAccess* _tmp695_;
				ValaSymbol* _tmp696_;
				ValaSymbol* _tmp697_;
				_tmp695_ = ma;
				_tmp696_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp695_);
				_tmp697_ = _tmp696_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp697_, VALA_TYPE_LOCAL_VARIABLE)) {
					_tmp694_ = TRUE;
				} else {
					ValaMemberAccess* _tmp698_;
					ValaSymbol* _tmp699_;
					ValaSymbol* _tmp700_;
					_tmp698_ = ma;
					_tmp699_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp698_);
					_tmp700_ = _tmp699_;
					_tmp694_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp700_, VALA_TYPE_PARAMETER);
				}
				if (_tmp694_) {
					ValaSourceReference* _tmp701_;
					ValaSourceReference* _tmp702_;
					_tmp701_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp702_ = _tmp701_;
					vala_report_warning (_tmp702_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp703_;
					ValaSymbol* _tmp704_;
					ValaSymbol* _tmp705_;
					_tmp703_ = ma;
					_tmp704_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp703_);
					_tmp705_ = _tmp704_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp705_, VALA_TYPE_FIELD)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp706_;
						ValaSymbol* _tmp707_;
						ValaSymbol* _tmp708_;
						ValaField* _tmp709_;
						ValaField* _tmp710_;
						ValaMemberBinding _tmp711_;
						ValaMemberBinding _tmp712_;
						_tmp706_ = ma;
						_tmp707_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp706_);
						_tmp708_ = _tmp707_;
						_tmp709_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp708_, VALA_TYPE_FIELD, ValaField));
						f = _tmp709_;
						_tmp710_ = f;
						_tmp711_ = vala_field_get_binding (_tmp710_);
						_tmp712_ = _tmp711_;
						if (_tmp712_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp713_;
							ValaSourceReference* _tmp714_;
							_tmp713_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp714_ = _tmp713_;
							vala_report_warning (_tmp714_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp715_;
							ValaExpression* _tmp716_;
							ValaExpression* _tmp717_;
							ValaMemberAccess* _tmp718_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp719_;
							ValaExpression* _tmp720_;
							ValaExpression* _tmp721_;
							ValaMemberAccess* _tmp722_;
							gboolean _tmp723_ = FALSE;
							gboolean _tmp724_ = FALSE;
							gboolean _tmp725_ = FALSE;
							gboolean _tmp726_ = FALSE;
							gboolean _tmp727_ = FALSE;
							ValaMemberAccess* _tmp728_;
							_tmp715_ = ma;
							_tmp716_ = vala_member_access_get_inner (_tmp715_);
							_tmp717_ = _tmp716_;
							_tmp718_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp717_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp717_) : NULL);
							ma_inner = _tmp718_;
							_tmp719_ = right_ma;
							_tmp720_ = vala_member_access_get_inner (_tmp719_);
							_tmp721_ = _tmp720_;
							_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp721_) : NULL);
							right_ma_inner = _tmp722_;
							_tmp728_ = ma_inner;
							if (_tmp728_ != NULL) {
								ValaMemberAccess* _tmp729_;
								const gchar* _tmp730_;
								const gchar* _tmp731_;
								_tmp729_ = ma_inner;
								_tmp730_ = vala_member_access_get_member_name (_tmp729_);
								_tmp731_ = _tmp730_;
								_tmp727_ = g_strcmp0 (_tmp731_, "this") == 0;
							} else {
								_tmp727_ = FALSE;
							}
							if (_tmp727_) {
								ValaMemberAccess* _tmp732_;
								ValaExpression* _tmp733_;
								ValaExpression* _tmp734_;
								_tmp732_ = ma_inner;
								_tmp733_ = vala_member_access_get_inner (_tmp732_);
								_tmp734_ = _tmp733_;
								_tmp726_ = _tmp734_ == NULL;
							} else {
								_tmp726_ = FALSE;
							}
							if (_tmp726_) {
								ValaMemberAccess* _tmp735_;
								_tmp735_ = right_ma_inner;
								_tmp725_ = _tmp735_ != NULL;
							} else {
								_tmp725_ = FALSE;
							}
							if (_tmp725_) {
								ValaMemberAccess* _tmp736_;
								const gchar* _tmp737_;
								const gchar* _tmp738_;
								_tmp736_ = right_ma_inner;
								_tmp737_ = vala_member_access_get_member_name (_tmp736_);
								_tmp738_ = _tmp737_;
								_tmp724_ = g_strcmp0 (_tmp738_, "this") == 0;
							} else {
								_tmp724_ = FALSE;
							}
							if (_tmp724_) {
								ValaMemberAccess* _tmp739_;
								ValaExpression* _tmp740_;
								ValaExpression* _tmp741_;
								_tmp739_ = right_ma_inner;
								_tmp740_ = vala_member_access_get_inner (_tmp739_);
								_tmp741_ = _tmp740_;
								_tmp723_ = _tmp741_ == NULL;
							} else {
								_tmp723_ = FALSE;
							}
							if (_tmp723_) {
								ValaSourceReference* _tmp742_;
								ValaSourceReference* _tmp743_;
								_tmp742_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp743_ = _tmp742_;
								vala_report_warning (_tmp743_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp744_;
			ValaExpression* _tmp745_;
			_tmp744_ = vala_assignment_get_left (self);
			_tmp745_ = _tmp744_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp745_, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp746_;
				ValaExpression* _tmp747_;
				ValaElementAccess* _tmp748_;
				ValaExpression* _tmp749_;
				ValaExpression* _tmp750_;
				ValaDataType* _tmp751_;
				ValaDataType* _tmp752_;
				ValaExpression* _tmp753_;
				ValaExpression* _tmp754_;
				ValaDataType* _tmp755_;
				ValaDataType* _tmp756_;
				ValaExpression* _tmp773_;
				ValaExpression* _tmp774_;
				ValaDataType* _tmp775_;
				ValaDataType* _tmp776_;
				_tmp746_ = vala_assignment_get_left (self);
				_tmp747_ = _tmp746_;
				_tmp748_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp748_;
				_tmp749_ = vala_assignment_get_right (self);
				_tmp750_ = _tmp749_;
				_tmp751_ = vala_expression_get_value_type (_tmp750_);
				_tmp752_ = _tmp751_;
				_tmp753_ = vala_assignment_get_left (self);
				_tmp754_ = _tmp753_;
				_tmp755_ = vala_expression_get_value_type (_tmp754_);
				_tmp756_ = _tmp755_;
				if (!vala_data_type_compatible (_tmp752_, _tmp756_)) {
					ValaSourceReference* _tmp757_;
					ValaSourceReference* _tmp758_;
					ValaExpression* _tmp759_;
					ValaExpression* _tmp760_;
					ValaDataType* _tmp761_;
					ValaDataType* _tmp762_;
					gchar* _tmp763_;
					gchar* _tmp764_;
					ValaExpression* _tmp765_;
					ValaExpression* _tmp766_;
					ValaDataType* _tmp767_;
					ValaDataType* _tmp768_;
					gchar* _tmp769_;
					gchar* _tmp770_;
					gchar* _tmp771_;
					gchar* _tmp772_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp757_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp758_ = _tmp757_;
					_tmp759_ = vala_assignment_get_right (self);
					_tmp760_ = _tmp759_;
					_tmp761_ = vala_expression_get_value_type (_tmp760_);
					_tmp762_ = _tmp761_;
					_tmp763_ = vala_code_node_to_string ((ValaCodeNode*) _tmp762_);
					_tmp764_ = _tmp763_;
					_tmp765_ = vala_assignment_get_left (self);
					_tmp766_ = _tmp765_;
					_tmp767_ = vala_expression_get_value_type (_tmp766_);
					_tmp768_ = _tmp767_;
					_tmp769_ = vala_code_node_to_string ((ValaCodeNode*) _tmp768_);
					_tmp770_ = _tmp769_;
					_tmp771_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp764_, _tmp770_);
					_tmp772_ = _tmp771_;
					vala_report_error (_tmp758_, _tmp772_);
					_g_free0 (_tmp772_);
					_g_free0 (_tmp770_);
					_g_free0 (_tmp764_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp773_ = vala_assignment_get_right (self);
				_tmp774_ = _tmp773_;
				_tmp775_ = vala_expression_get_value_type (_tmp774_);
				_tmp776_ = _tmp775_;
				if (vala_data_type_is_disposable (_tmp776_)) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp777_;
					ValaExpression* _tmp778_;
					ValaExpression* _tmp779_;
					ValaDataType* _tmp780_;
					ValaDataType* _tmp781_;
					gboolean _tmp803_ = FALSE;
					ValaDataType* _tmp804_;
					_tmp777_ = ea;
					_tmp778_ = vala_element_access_get_container (_tmp777_);
					_tmp779_ = _tmp778_;
					_tmp780_ = vala_expression_get_value_type (_tmp779_);
					_tmp781_ = _tmp780_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp781_, VALA_TYPE_ARRAY_TYPE)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp782_;
						ValaExpression* _tmp783_;
						ValaExpression* _tmp784_;
						ValaDataType* _tmp785_;
						ValaDataType* _tmp786_;
						ValaArrayType* _tmp787_;
						ValaArrayType* _tmp788_;
						ValaDataType* _tmp789_;
						ValaDataType* _tmp790_;
						ValaDataType* _tmp791_;
						_tmp782_ = ea;
						_tmp783_ = vala_element_access_get_container (_tmp782_);
						_tmp784_ = _tmp783_;
						_tmp785_ = vala_expression_get_value_type (_tmp784_);
						_tmp786_ = _tmp785_;
						_tmp787_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp786_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp787_;
						_tmp788_ = array_type;
						_tmp789_ = vala_array_type_get_element_type (_tmp788_);
						_tmp790_ = _tmp789_;
						_tmp791_ = _vala_code_node_ref0 (_tmp790_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp791_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp792_;
						ValaExpression* _tmp793_;
						ValaExpression* _tmp794_;
						ValaDataType* _tmp795_;
						ValaDataType* _tmp796_;
						ValaList* _tmp797_;
						ValaList* _tmp798_;
						gint _tmp799_;
						gint _tmp800_;
						ValaList* _tmp801_;
						gpointer _tmp802_;
						_tmp792_ = ea;
						_tmp793_ = vala_element_access_get_container (_tmp792_);
						_tmp794_ = _tmp793_;
						_tmp795_ = vala_expression_get_value_type (_tmp794_);
						_tmp796_ = _tmp795_;
						_tmp797_ = vala_data_type_get_type_arguments (_tmp796_);
						args = _tmp797_;
						_tmp798_ = args;
						_tmp799_ = vala_collection_get_size ((ValaCollection*) _tmp798_);
						_tmp800_ = _tmp799_;
						_vala_assert (_tmp800_ == 1, "args.size == 1");
						_tmp801_ = args;
						_tmp802_ = vala_list_get (_tmp801_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp802_;
						_vala_iterable_unref0 (args);
					}
					_tmp804_ = element_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp804_, VALA_TYPE_POINTER_TYPE)) {
						ValaDataType* _tmp805_;
						gboolean _tmp806_;
						gboolean _tmp807_;
						_tmp805_ = element_type;
						_tmp806_ = vala_data_type_get_value_owned (_tmp805_);
						_tmp807_ = _tmp806_;
						_tmp803_ = !_tmp807_;
					} else {
						_tmp803_ = FALSE;
					}
					if (_tmp803_) {
						ValaSourceReference* _tmp808_;
						ValaSourceReference* _tmp809_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp808_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp809_ = _tmp808_;
						vala_report_error (_tmp809_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp810_;
					ValaExpression* _tmp811_;
					ValaDataType* _tmp812_;
					ValaDataType* _tmp813_;
					gboolean _tmp814_;
					gboolean _tmp815_;
					_tmp810_ = vala_assignment_get_left (self);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_expression_get_value_type (_tmp811_);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_data_type_get_value_owned (_tmp813_);
					_tmp815_ = _tmp814_;
					if (_tmp815_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp816_ = vala_assignment_get_left (self);
	_tmp817_ = _tmp816_;
	_tmp818_ = vala_expression_get_value_type (_tmp817_);
	_tmp819_ = _tmp818_;
	if (_tmp819_ != NULL) {
		ValaExpression* _tmp820_;
		ValaExpression* _tmp821_;
		ValaDataType* _tmp822_;
		ValaDataType* _tmp823_;
		ValaDataType* _tmp824_;
		ValaDataType* _tmp825_;
		ValaDataType* _tmp826_;
		ValaDataType* _tmp827_;
		_tmp820_ = vala_assignment_get_left (self);
		_tmp821_ = _tmp820_;
		_tmp822_ = vala_expression_get_value_type (_tmp821_);
		_tmp823_ = _tmp822_;
		_tmp824_ = vala_data_type_copy (_tmp823_);
		_tmp825_ = _tmp824_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp825_);
		_vala_code_node_unref0 (_tmp825_);
		_tmp826_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp827_ = _tmp826_;
		vala_data_type_set_value_owned (_tmp827_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp828_ = vala_assignment_get_left (self);
	_tmp829_ = _tmp828_;
	_tmp830_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp829_);
	_tmp831_ = _tmp830_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp831_);
	_vala_iterable_unref0 (_tmp831_);
	_tmp832_ = vala_assignment_get_right (self);
	_tmp833_ = _tmp832_;
	_tmp834_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp833_);
	_tmp835_ = _tmp834_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp835_);
	_vala_iterable_unref0 (_tmp835_);
	_tmp836_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp837_ = _tmp836_;
	result = !_tmp837_;
	return result;
}


static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static void
vala_assignment_real_emit (ValaCodeNode* base, 
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp136_;
	ValaExpression* _tmp137_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaTargetValue* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaCodeNode* _tmp96_;
			ValaCodeNode* _tmp97_;
			_tmp56_ = instance;
			if (_tmp56_) {
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp55_ = _tmp59_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp60_ = ma;
				_tmp61_ = vala_member_access_get_inner (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_code_node_emit ((ValaCodeNode*) _tmp62_, codegen);
			}
			_tmp63_ = vala_assignment_get_right (self);
			_tmp64_ = _tmp63_;
			vala_code_node_emit ((ValaCodeNode*) _tmp64_, codegen);
			_tmp65_ = vala_assignment_get_right (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_target_value (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _vala_target_value_ref0 (_tmp68_);
			new_value = _tmp69_;
			_tmp70_ = local;
			if (_tmp70_ != NULL) {
				ValaLocalVariable* _tmp71_;
				ValaTargetValue* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				_tmp71_ = local;
				_tmp72_ = new_value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				vala_code_generator_store_local (codegen, _tmp71_, _tmp72_, FALSE, _tmp74_);
			} else {
				ValaParameter* _tmp75_;
				_tmp75_ = param;
				if (_tmp75_ != NULL) {
					ValaParameter* _tmp76_;
					ValaTargetValue* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp76_ = param;
					_tmp77_ = new_value;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					vala_code_generator_store_parameter (codegen, _tmp76_, _tmp77_, FALSE, _tmp79_);
				} else {
					ValaField* _tmp80_;
					_tmp80_ = field;
					if (_tmp80_ != NULL) {
						ValaTargetValue* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						gboolean _tmp83_;
						ValaField* _tmp92_;
						ValaTargetValue* _tmp93_;
						ValaSourceReference* _tmp94_;
						ValaSourceReference* _tmp95_;
						_tmp83_ = instance;
						if (_tmp83_) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = ma;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaTargetValue* _tmp90_;
							ValaTargetValue* _tmp91_;
							_tmp87_ = ma;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_target_value (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp81_ = _tmp91_;
						} else {
							_tmp81_ = NULL;
						}
						_tmp92_ = field;
						_tmp93_ = new_value;
						_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp95_ = _tmp94_;
						vala_code_generator_store_field (codegen, _tmp92_, _tmp81_, _tmp93_, _tmp95_);
					}
				}
			}
			_tmp96_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp98_;
				_tmp98_ = local;
				if (_tmp98_ != NULL) {
					ValaLocalVariable* _tmp99_;
					ValaTargetValue* _tmp100_;
					ValaTargetValue* _tmp101_;
					_tmp99_ = local;
					_tmp100_ = vala_code_generator_load_local (codegen, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp101_);
					_vala_target_value_unref0 (_tmp101_);
				} else {
					ValaParameter* _tmp102_;
					_tmp102_ = param;
					if (_tmp102_ != NULL) {
						ValaParameter* _tmp103_;
						ValaTargetValue* _tmp104_;
						ValaTargetValue* _tmp105_;
						_tmp103_ = param;
						_tmp104_ = vala_code_generator_load_parameter (codegen, _tmp103_);
						_tmp105_ = _tmp104_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp105_);
						_vala_target_value_unref0 (_tmp105_);
					} else {
						ValaField* _tmp106_;
						_tmp106_ = field;
						if (_tmp106_ != NULL) {
							ValaTargetValue* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
							gboolean _tmp109_;
							ValaField* _tmp118_;
							ValaTargetValue* _tmp119_;
							ValaTargetValue* _tmp120_;
							_tmp109_ = instance;
							if (_tmp109_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp108_ = _tmp112_ != NULL;
							} else {
								_tmp108_ = FALSE;
							}
							if (_tmp108_) {
								ValaMemberAccess* _tmp113_;
								ValaExpression* _tmp114_;
								ValaExpression* _tmp115_;
								ValaTargetValue* _tmp116_;
								ValaTargetValue* _tmp117_;
								_tmp113_ = ma;
								_tmp114_ = vala_member_access_get_inner (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_expression_get_target_value (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp107_ = _tmp117_;
							} else {
								_tmp107_ = NULL;
							}
							_tmp118_ = field;
							_tmp119_ = vala_code_generator_load_field (codegen, _tmp118_, _tmp107_);
							_tmp120_ = _tmp119_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp120_);
							_vala_target_value_unref0 (_tmp120_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp123_ = instance;
		if (_tmp123_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = _tmp126_ != NULL;
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			_tmp121_ = _tmp127_ != NULL;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_member_access_get_inner (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaMemberAccess* _tmp131_;
			_tmp131_ = ma;
			vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp132_;
		_tmp132_ = ea;
		if (_tmp132_ != NULL) {
			ValaElementAccess* _tmp133_;
			_tmp133_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp133_, codegen);
		} else {
			ValaPointerIndirection* _tmp134_;
			_tmp134_ = pi;
			if (_tmp134_ != NULL) {
				ValaPointerIndirection* _tmp135_;
				_tmp135_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp135_, codegen);
			}
		}
	}
	_tmp136_ = vala_assignment_get_right (self);
	_tmp137_ = _tmp136_;
	vala_code_node_emit ((ValaCodeNode*) _tmp137_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base, 
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void
vala_assignment_real_get_used_variables (ValaCodeNode* base, 
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_left (ValaAssignment* self, 
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_operator (ValaAssignment* self, 
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_right (ValaAssignment* self, 
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



