/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
enum  {
	VALA_GIR_PARSER_0_PROPERTY,
	VALA_GIR_PARSER_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_properties[VALA_GIR_PARSER_NUM_PROPERTIES];

#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
enum  {
	VALA_GIR_PARSER_ARGUMENT_0_PROPERTY,
	VALA_GIR_PARSER_ARGUMENT_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_argument_properties[VALA_GIR_PARSER_ARGUMENT_NUM_PROPERTIES];
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
enum  {
	VALA_GIR_PARSER_METADATA_SET_0_PROPERTY,
	VALA_GIR_PARSER_METADATA_SET_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_metadata_set_properties[VALA_GIR_PARSER_METADATA_SET_NUM_PROPERTIES];
enum  {
	VALA_GIR_PARSER_METADATA_0_PROPERTY,
	VALA_GIR_PARSER_METADATA_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_metadata_properties[VALA_GIR_PARSER_METADATA_NUM_PROPERTIES];
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
enum  {
	VALA_GIR_PARSER_METADATA_PARSER_0_PROPERTY,
	VALA_GIR_PARSER_METADATA_PARSER_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_metadata_parser_properties[VALA_GIR_PARSER_METADATA_PARSER_NUM_PROPERTIES];
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
enum  {
	VALA_GIR_PARSER_NODE_0_PROPERTY,
	VALA_GIR_PARSER_NODE_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_node_properties[VALA_GIR_PARSER_NODE_NUM_PROPERTIES];
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
enum  {
	VALA_GIR_PARSER_PARAMETER_INFO_0_PROPERTY,
	VALA_GIR_PARSER_PARAMETER_INFO_NUM_PROPERTIES
};
static GParamSpec* vala_gir_parser_parameter_info_properties[VALA_GIR_PARSER_PARAMETER_INFO_NUM_PROPERTIES];
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaNamespace* glib_ns;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaArrayList* unresolved_type_arguments;
};

typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME
} ValaGirParserArgumentType;

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNodePrivate * priv;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserParameterInfoPrivate * priv;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataPrivate * priv;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserArgumentPrivate * priv;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};


static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name, 
                                             const gchar* nick, 
                                             const gchar* blurb, 
                                             GType object_type, 
                                             GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_node (GValue* value, 
                                     gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_node (GValue* value, 
                                      gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name, 
                                                 const gchar* nick, 
                                                 const gchar* blurb, 
                                                 GType object_type, 
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata (GValue* value, 
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata (GValue* value, 
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_GIR_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_PARSER, ValaGirParserPrivate))
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1, 
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a, 
                                                               gconstpointer b);
#define VALA_GIR_PARSER_GIR_VERSION "1.2"
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type, 
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name, 
                                                       const gchar* nick, 
                                                       const gchar* blurb, 
                                                       GType object_type, 
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_parameter_info (GValue* value, 
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_parameter_info (GValue* value, 
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self, 
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self, 
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self, 
                                         ValaUnresolvedSymbol* map_from, 
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base, 
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self, 
                                    const gchar* name);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_end_element (ValaGirParser* self, 
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container, 
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self, 
                                                                const gchar* symbol_string, 
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self, 
                                             ValaSignal* sig, 
                                             ValaSymbol* sym, 
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self, 
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self, 
                                                             const gchar* name, 
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self, 
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self, 
                                            ValaGirParserArgumentType arg, 
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self, 
                                                           ValaDataType* parent_type, 
                                                           const gchar* type_arguments, 
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self, 
                                                      const gchar* type_string, 
                                                      gboolean owned_by_default, 
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self, 
                                           const gchar* attribute_name, 
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self, 
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self, 
                                                ValaDataType* orig_type, 
                                                gboolean owned_by_default, 
                                                gboolean* no_array_length, 
                                                gboolean* array_null_terminated, 
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self, 
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self, 
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self, 
                                      ValaSymbol* sym, 
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self, 
                                                const gchar* name, 
                                                gboolean create_namespace, 
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self, 
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add1 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self, 
                                                 ValaGirParserNode* parent_scope, 
                                                 ValaUnresolvedSymbol* unresolved_sym, 
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self, 
                                            ValaGirParserNode* parent_scope, 
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self, 
                                const gchar* name, 
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self, 
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name, 
                                                        const gchar* nick, 
                                                        const gchar* blurb, 
                                                        GType object_type, 
                                                        GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata_parser (GValue* value, 
                                                gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata_parser (GValue* value, 
                                                 gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self, 
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self, 
                                        const gchar* element_name, 
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self, 
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self, 
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self, 
                                          gchar* * ctype, 
                                          gint* array_length_idx, 
                                          gboolean transfer_elements, 
                                          gboolean* no_array_length, 
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self, 
                                              gchar* * common_prefix, 
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self, 
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self, 
                                                  gchar* * ctype, 
                                                  gint* array_length_idx, 
                                                  gboolean* no_array_length, 
                                                  gboolean* array_null_terminated, 
                                                  ValaComment* * comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self, 
                                                gint* array_length_idx, 
                                                gint* closure_idx, 
                                                gint* destroy_idx, 
                                                gchar* * scope, 
                                                ValaComment* * comment, 
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self, 
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self, 
                                                        const gchar* type_name, 
                                                        gboolean* no_array_length, 
                                                        gboolean* array_null_terminated, 
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self, 
                                     const gchar* element_name);
G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self, 
                                                 const gchar* name, 
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param, 
                                                                gint array_length_idx, 
                                                                gint closure_idx, 
                                                                gint destroy_idx, 
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type, 
                                                                      ValaParameter* param, 
                                                                      gint array_length_idx, 
                                                                      gint closure_idx, 
                                                                      gint destroy_idx, 
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name, 
                                                 const gchar* nick, 
                                                 const gchar* blurb, 
                                                 GType object_type, 
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_argument (GValue* value, 
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_argument (GValue* value, 
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_process_interface (ValaGirParser* self, 
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self, 
                                    ValaGirParserNode* alias);
static void vala_gir_parser_process_callable (ValaGirParser* self, 
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self, 
                                  const gchar* cname, 
                                  ValaGirParserNode* current, 
                                  ValaGirParserNode* * best, 
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self, 
                                   ValaSymbol* gir_component, 
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self, 
                                               ValaGirParserNode* ns, 
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self, 
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self, 
                                                   ValaGirParserNode* node, 
                                                   ValaDelegate* d, 
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self, 
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self, 
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self, 
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression, 
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type, 
                                                           ValaExpression* expression, 
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type, 
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern, 
                                                     const gchar* selector, 
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type, 
                                                           const gchar* pattern, 
                                                           const gchar* selector, 
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self, 
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self, 
                                         ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self, 
                                            ValaGirParserArgumentType key, 
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
#define VALA_GIR_PARSER_METADATA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserPrivate))
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self, 
                                                              ValaSourceLocation* begin, 
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self, 
                                                   ValaSourceLocation* begin, 
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self, 
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self, 
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar*
string_replace (const gchar* self, 
                const gchar* old, 
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}


static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}


static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	ValaGirParserArgumentType* result = NULL;
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		gint _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		_tmp5_ = enum_value;
		_tmp6_ = (*_tmp5_).value;
		value = (ValaGirParserArgumentType) _tmp6_;
		_tmp7_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp7_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}


static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {0, NULL, NULL}};
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__volatile, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__volatile;
}


static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}


static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a, 
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}


/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
vala_gir_parser_parse (ValaGirParser* self, 
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaGirParserNode* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaSymbol* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaGirParserNode* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_root (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_scope_lookup (_tmp4_, "GLib");
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	_vala_code_node_unref0 (self->priv->glib_ns);
	self->priv->glib_ns = _tmp6_;
	_tmp7_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = vala_code_context_get_root (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
	_vala_code_node_unref0 (_tmp8_->symbol);
	_tmp8_->symbol = _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp12_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp13_;
	_tmp14_ = self->priv->root;
	_tmp15_ = _vala_gir_parser_node_ref0 (_tmp14_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp15_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp16_ = self->priv->root;
	vala_gir_parser_node_process (_tmp16_, self);
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp17_;
		ValaArrayList* _tmp18_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _metadata_index = 0;
		_tmp17_ = self->priv->metadata_roots;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_metadata_list = _tmp18_;
		_tmp19_ = _metadata_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_metadata_size = _tmp21_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaGirParserMetadata* _tmp28_;
			_tmp22_ = _metadata_index;
			_metadata_index = _tmp22_ + 1;
			_tmp23_ = _metadata_index;
			_tmp24_ = _metadata_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _metadata_list;
			_tmp26_ = _metadata_index;
			_tmp27_ = vala_list_get ((ValaList*) _tmp25_, _tmp26_);
			metadata = (ValaGirParserMetadata*) _tmp27_;
			_tmp28_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp28_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
}


static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		gint _source_file_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp19_;
			const gchar* _tmp39_;
			ValaSet* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp45_;
			ValaUnresolvedSymbol* _tmp46_;
			const gchar* _tmp47_;
			ValaNamespace* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp5_ = _source_file_index;
			_source_file_index = _tmp5_ + 1;
			_tmp6_ = _source_file_index;
			_tmp7_ = _source_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _source_file_list;
			_tmp9_ = _source_file_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			source_file = (ValaSourceFile*) _tmp10_;
			_tmp11_ = source_file;
			_tmp12_ = vala_source_file_get_gir_namespace (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			gir_namespace = _tmp14_;
			_tmp15_ = source_file;
			_tmp16_ = vala_source_file_get_gir_version (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup (_tmp17_);
			gir_version = _tmp18_;
			ns = NULL;
			_tmp19_ = gir_namespace;
			if (_tmp19_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp20_;
					ValaList* _tmp21_;
					gint _node_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _node_index = 0;
					_tmp20_ = source_file;
					_tmp21_ = vala_source_file_get_nodes (_tmp20_);
					_node_list = _tmp21_;
					_tmp22_ = _node_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_node_size = _tmp24_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						ValaCodeNode* node = NULL;
						ValaList* _tmp28_;
						gint _tmp29_;
						gpointer _tmp30_;
						ValaCodeNode* _tmp31_;
						_tmp25_ = _node_index;
						_node_index = _tmp25_ + 1;
						_tmp26_ = _node_index;
						_tmp27_ = _node_size;
						if (!(_tmp26_ < _tmp27_)) {
							break;
						}
						_tmp28_ = _node_list;
						_tmp29_ = _node_index;
						_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
						node = (ValaCodeNode*) _tmp30_;
						_tmp31_ = node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_NAMESPACE)) {
							ValaCodeNode* _tmp32_;
							ValaNamespace* _tmp33_;
							ValaNamespace* _tmp34_;
							gchar* _tmp35_;
							const gchar* _tmp36_;
							_tmp32_ = node;
							_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp33_;
							_tmp34_ = ns;
							_tmp35_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp34_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp35_;
							_tmp36_ = gir_namespace;
							if (_tmp36_ != NULL) {
								ValaNamespace* _tmp37_;
								gchar* _tmp38_;
								_tmp37_ = ns;
								_tmp38_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp37_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp38_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
			}
			_tmp39_ = gir_namespace;
			if (_tmp39_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp40_ = self->priv->provided_namespaces;
			_tmp41_ = gir_namespace;
			_tmp42_ = gir_version;
			_tmp43_ = g_strdup_printf ("%s-%s", _tmp41_, _tmp42_);
			_tmp44_ = _tmp43_;
			vala_collection_add ((ValaCollection*) _tmp40_, _tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = gir_namespace;
			_tmp46_ = vala_unresolved_symbol_new (NULL, _tmp45_, NULL);
			gir_symbol = _tmp46_;
			_tmp47_ = gir_namespace;
			_tmp48_ = ns;
			_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (g_strcmp0 (_tmp47_, _tmp50_) != 0) {
				ValaUnresolvedSymbol* _tmp51_;
				ValaNamespace* _tmp52_;
				_tmp51_ = gir_symbol;
				_tmp52_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp51_, (ValaSymbol*) _tmp52_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp53_;
				ValaList* _tmp54_;
				gint _node_size = 0;
				ValaList* _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				gint _node_index = 0;
				_tmp53_ = source_file;
				_tmp54_ = vala_source_file_get_nodes (_tmp53_);
				_node_list = _tmp54_;
				_tmp55_ = _node_list;
				_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
				_tmp57_ = _tmp56_;
				_node_size = _tmp57_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp61_;
					gint _tmp62_;
					gpointer _tmp63_;
					ValaCodeNode* _tmp64_;
					_tmp58_ = _node_index;
					_node_index = _tmp58_ + 1;
					_tmp59_ = _node_index;
					_tmp60_ = _node_size;
					if (!(_tmp59_ < _tmp60_)) {
						break;
					}
					_tmp61_ = _node_list;
					_tmp62_ = _node_index;
					_tmp63_ = vala_list_get (_tmp61_, _tmp62_);
					node = (ValaCodeNode*) _tmp63_;
					_tmp64_ = node;
					if (vala_code_node_has_attribute_argument (_tmp64_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp65_;
						ValaCodeNode* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						ValaUnresolvedSymbol* _tmp69_;
						ValaUnresolvedSymbol* _tmp70_;
						ValaUnresolvedSymbol* _tmp71_;
						ValaCodeNode* _tmp72_;
						_tmp65_ = gir_symbol;
						_tmp66_ = node;
						_tmp67_ = vala_code_node_get_attribute_string (_tmp66_, "GIR", "name", NULL);
						_tmp68_ = _tmp67_;
						_tmp69_ = vala_unresolved_symbol_new (_tmp65_, _tmp68_, NULL);
						_tmp70_ = _tmp69_;
						_g_free0 (_tmp68_);
						map_from = _tmp70_;
						_tmp71_ = map_from;
						_tmp72_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp71_, G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base, 
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}


static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


void
vala_gir_parser_parse_file (ValaGirParser* self, 
                            ValaSourceFile* source_file)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserMetadata* _tmp3_;
	ValaGirParserMetadata* _tmp4_;
	ValaSourceFile* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValaMarkupReader* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp1_;
	_tmp2_ = vala_gir_parser_metadata_get_empty ();
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp4_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp5_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp5_;
	_tmp6_ = vala_source_file_get_filename (source_file);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_markup_reader_new (_tmp7_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp8_;
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
}


static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}


static void
vala_gir_parser_start_element (ValaGirParser* self, 
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
	}
}


static void
vala_gir_parser_end_element (ValaGirParser* self, 
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaMarkupTokenType _tmp1_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->reader;
			_tmp3_ = vala_markup_reader_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_warning (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}


static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}


static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container, 
                                         ValaSymbol* sym)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
												ValaNamespace* _tmp25_;
												_tmp25_ = ns;
												vala_symbol_add_field ((ValaSymbol*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
											} else {
												if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp26_;
													_tmp26_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
														ValaNamespace* _tmp27_;
														_tmp27_ = ns;
														vala_symbol_add_method ((ValaSymbol*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
													} else {
														if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
															ValaNamespace* _tmp28_;
															_tmp28_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp28_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp29_;
							_tmp29_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp30_;
								_tmp30_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp31_;
									_tmp31_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp32_;
										_tmp32_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ERROR_DOMAIN)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_CODE)) {
								ValaErrorDomain* _tmp33_;
								_tmp33_ = ed;
								vala_error_domain_add_code (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaErrorDomain* _tmp34_;
									_tmp34_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp35_;
							ValaSourceReference* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp36_ = _tmp35_;
							_tmp37_ = vala_symbol_get_name (sym);
							_tmp38_ = _tmp37_;
							_tmp39_ = vala_symbol_get_name (container);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup_printf ("impossible to add `%s' to container `%s'", _tmp38_, _tmp40_);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp36_, _tmp42_);
							_g_free0 (_tmp42_);
						}
					}
				}
			}
		}
	}
}


static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM);
	}
	result = _tmp0_;
	return result;
}


static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self, 
                                          const gchar* symbol_string, 
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < _vala_array_length (_tmp0_); s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self, 
                                    ValaUnresolvedSymbol* map_from, 
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (map_from, VALA_TYPE_UNRESOLVED_SYMBOL)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}


static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self, 
                                        ValaSignal* sig, 
                                        ValaSymbol* sym, 
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValaIterator* _tmp3_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_iterable_unref0 (_tmp1_);
	iter = _tmp3_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp4_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaParameter* param = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaIterator* _tmp14_;
			gboolean _tmp15_ = FALSE;
			ValaParameter* _tmp18_;
			ValaIterator* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp8_ = _param_index;
			_param_index = _tmp8_ + 1;
			_tmp9_ = _param_index;
			_tmp10_ = _param_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _param_list;
			_tmp12_ = _param_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			param = (ValaParameter*) _tmp13_;
			_tmp14_ = iter;
			if (!vala_iterator_next (_tmp14_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				gboolean _tmp16_;
				_tmp16_ = first;
				_tmp15_ = _tmp16_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				ValaIterator* _tmp17_;
				_tmp17_ = iter;
				if (!vala_iterator_next (_tmp17_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp18_ = param;
			_tmp19_ = iter;
			_tmp20_ = vala_iterator_get (_tmp19_);
			_tmp21_ = (ValaParameter*) _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_symbol_set_name ((ValaSymbol*) _tmp18_, _tmp23_);
			_vala_code_node_unref0 (_tmp21_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_vala_iterator_unref0 (iter);
}


static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self, 
                              ValaGirParserNode* node)
{
	ValaGirParserNode* result = NULL;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _n_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_n_list = _tmp8_;
		_tmp9_ = _n_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_n_size = _tmp11_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMethod* _tmp23_;
			gboolean _tmp24_ = FALSE;
			ValaMethod* _tmp25_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp36_;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			ValaIterator* _tmp39_;
			ValaIterator* _tmp40_;
			ValaMethod* _tmp62_;
			_tmp12_ = _n_index;
			_n_index = _tmp12_ + 1;
			_tmp13_ = _n_index;
			_tmp14_ = _n_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _n_list;
			_tmp16_ = _n_index;
			_tmp17_ = vala_list_get ((ValaList*) _tmp15_, _tmp16_);
			n = (ValaGirParserNode*) _tmp17_;
			_tmp18_ = n;
			_tmp19_ = _tmp18_->name;
			_tmp20_ = prefix;
			if (!g_str_has_prefix (_tmp19_, _tmp20_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp21_ = n;
			_tmp22_ = _tmp21_->symbol;
			_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp22_) : NULL);
			invoker = _tmp23_;
			_tmp25_ = invoker;
			if (_tmp25_ == NULL) {
				_tmp24_ = TRUE;
			} else {
				ValaMethod* _tmp26_;
				ValaList* _tmp27_;
				ValaList* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				ValaMethod* _tmp31_;
				ValaList* _tmp32_;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp26_ = m;
				_tmp27_ = vala_callable_get_parameters ((ValaCallable*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = invoker;
				_tmp32_ = vala_callable_get_parameters ((ValaCallable*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp24_ = _tmp30_ != _tmp35_;
				_vala_iterable_unref0 (_tmp33_);
				_vala_iterable_unref0 (_tmp28_);
			}
			if (_tmp24_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp36_ = invoker;
			_tmp37_ = vala_callable_get_parameters ((ValaCallable*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_iterable_iterator ((ValaIterable*) _tmp38_);
			_tmp40_ = _tmp39_;
			_vala_iterable_unref0 (_tmp38_);
			iter = _tmp40_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp41_;
				ValaList* _tmp42_;
				gint _param_size = 0;
				ValaList* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				gint _param_index = 0;
				_tmp41_ = m;
				_tmp42_ = vala_callable_get_parameters ((ValaCallable*) _tmp41_);
				_param_list = _tmp42_;
				_tmp43_ = _param_list;
				_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				_param_size = _tmp45_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					ValaParameter* param = NULL;
					ValaList* _tmp49_;
					gint _tmp50_;
					gpointer _tmp51_;
					ValaIterator* _tmp52_;
					ValaParameter* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					ValaIterator* _tmp56_;
					gpointer _tmp57_;
					ValaParameter* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gboolean _tmp61_;
					_tmp46_ = _param_index;
					_param_index = _tmp46_ + 1;
					_tmp47_ = _param_index;
					_tmp48_ = _param_size;
					if (!(_tmp47_ < _tmp48_)) {
						break;
					}
					_tmp49_ = _param_list;
					_tmp50_ = _param_index;
					_tmp51_ = vala_list_get (_tmp49_, _tmp50_);
					param = (ValaParameter*) _tmp51_;
					_tmp52_ = iter;
					_vala_assert (vala_iterator_next (_tmp52_), "iter.next ()");
					_tmp53_ = param;
					_tmp54_ = vala_symbol_get_name ((ValaSymbol*) _tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = iter;
					_tmp57_ = vala_iterator_get (_tmp56_);
					_tmp58_ = (ValaParameter*) _tmp57_;
					_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strcmp0 (_tmp55_, _tmp60_) != 0;
					_vala_code_node_unref0 (_tmp58_);
					if (_tmp61_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp62_ = invoker;
			if (_tmp62_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_vala_iterable_unref0 (_n_list);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* result = NULL;
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}


static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	gboolean result = FALSE;
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}


static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self, 
                                                  ValaDataType* parent_type, 
                                                  const gchar* type_arguments, 
                                                  ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	gint _tmp2_;
	GString* _tmp3_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp32_;
	const gchar* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = type_arguments_length;
	_tmp3_ = g_string_sized_new ((gsize) _tmp2_);
	current = _tmp3_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				gint _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = c;
					c = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = c;
				_tmp7_ = type_arguments_length;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp9_ = c;
				if (string_get (type_arguments, (glong) _tmp9_) == '<') {
					_tmp8_ = TRUE;
				} else {
					gint _tmp10_;
					_tmp10_ = c;
					_tmp8_ = string_get (type_arguments, (glong) _tmp10_) == '[';
				}
				if (_tmp8_) {
					gint _tmp11_;
					GString* _tmp12_;
					gint _tmp13_;
					_tmp11_ = depth;
					depth = _tmp11_ + 1;
					_tmp12_ = current;
					_tmp13_ = c;
					g_string_append_unichar (_tmp12_, (gunichar) string_get (type_arguments, (glong) _tmp13_));
				} else {
					gboolean _tmp14_ = FALSE;
					gint _tmp15_;
					_tmp15_ = c;
					if (string_get (type_arguments, (glong) _tmp15_) == '>') {
						_tmp14_ = TRUE;
					} else {
						gint _tmp16_;
						_tmp16_ = c;
						_tmp14_ = string_get (type_arguments, (glong) _tmp16_) == ']';
					}
					if (_tmp14_) {
						gint _tmp17_;
						GString* _tmp18_;
						gint _tmp19_;
						_tmp17_ = depth;
						depth = _tmp17_ - 1;
						_tmp18_ = current;
						_tmp19_ = c;
						g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) _tmp19_));
					} else {
						gint _tmp20_;
						_tmp20_ = c;
						if (string_get (type_arguments, (glong) _tmp20_) == ',') {
							gint _tmp21_;
							_tmp21_ = depth;
							if (_tmp21_ == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp22_;
								const gchar* _tmp23_;
								ValaDataType* _tmp24_;
								ValaDataType* _tmp25_;
								ValaDataType* _tmp26_;
								GString* _tmp27_;
								_tmp22_ = current;
								_tmp23_ = _tmp22_->str;
								_tmp24_ = vala_gir_parser_parse_type_from_string (self, _tmp23_, TRUE, source_reference);
								dt = _tmp24_;
								_tmp25_ = dt;
								if (_tmp25_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp26_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp26_);
								_tmp27_ = current;
								g_string_truncate (_tmp27_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp28_;
								gint _tmp29_;
								_tmp28_ = current;
								_tmp29_ = c;
								g_string_append_unichar (_tmp28_, (gunichar) string_get (type_arguments, (glong) _tmp29_));
							}
						} else {
							GString* _tmp30_;
							gint _tmp31_;
							_tmp30_ = current;
							_tmp31_ = c;
							g_string_append_unichar (_tmp30_, (gunichar) string_get (type_arguments, (glong) _tmp31_));
						}
					}
				}
			}
		}
	}
	_tmp32_ = current;
	_tmp33_ = _tmp32_->str;
	_tmp34_ = vala_gir_parser_parse_type_from_string (self, _tmp33_, TRUE, source_reference);
	dt = _tmp34_;
	_tmp35_ = dt;
	if (_tmp35_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp36_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp36_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self, 
                                        const gchar* type_string, 
                                        gboolean owned_by_default, 
                                        ValaSourceReference* source_reference)
{
	ValaDataType* result = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedSymbol* _tmp45_;
	ValaUnresolvedSymbol* _tmp46_;
	ValaUnresolvedType* _tmp47_;
	gboolean _tmp48_ = FALSE;
	const gchar* _tmp49_;
	const gchar* _tmp55_;
	gboolean _tmp64_ = FALSE;
	const gchar* _tmp65_;
	ValaDataType* _tmp75_;
	gboolean _tmp76_;
	ValaDataType* _tmp77_;
	gboolean _tmp78_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1675: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			gboolean _tmp30_;
			_tmp30_ = nullable;
			_tmp28_ = !_tmp30_;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp31_;
			_tmp32_ = pointers_data;
			if (_tmp32_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							gint _tmp35_;
							const gchar* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							ValaDataType* _tmp39_;
							ValaPointerType* _tmp40_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = i;
								i = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							_tmp35_ = i;
							_tmp36_ = pointers_data;
							_tmp37_ = strlen (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(_tmp35_ < _tmp38_)) {
								break;
							}
							_tmp39_ = type;
							_tmp40_ = vala_pointer_type_new (_tmp39_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp40_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp41_ = ownership_data;
	if (g_strcmp0 (_tmp41_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp42_;
		_tmp42_ = ownership_data;
		if (g_strcmp0 (_tmp42_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp43_ = type_name;
	_tmp44_ = vala_gir_parser_parse_symbol_from_string (self, _tmp43_, source_reference);
	sym = _tmp44_;
	_tmp45_ = sym;
	if (_tmp45_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp46_ = sym;
	_tmp47_ = vala_unresolved_type_new_from_symbol (_tmp46_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp47_;
	_tmp49_ = type_arguments_data;
	if (_tmp49_ != NULL) {
		const gchar* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp50_ = type_arguments_data;
		_tmp51_ = strlen (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_ > 0;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaDataType* _tmp53_;
		const gchar* _tmp54_;
		_tmp53_ = type;
		_tmp54_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp53_, _tmp54_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp55_ = pointers_data;
	if (_tmp55_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					gint _tmp58_;
					const gchar* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					ValaDataType* _tmp62_;
					ValaPointerType* _tmp63_;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp58_ = i;
					_tmp59_ = pointers_data;
					_tmp60_ = strlen (_tmp59_);
					_tmp61_ = _tmp60_;
					if (!(_tmp58_ < _tmp61_)) {
						break;
					}
					_tmp62_ = type;
					_tmp63_ = vala_pointer_type_new (_tmp62_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp63_;
				}
			}
		}
	}
	_tmp65_ = array_data;
	if (_tmp65_ != NULL) {
		const gchar* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		_tmp66_ = array_data;
		_tmp67_ = strlen (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp64_ = _tmp68_ != 0;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		const gchar* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		ValaArrayType* _tmp74_;
		_tmp69_ = type;
		vala_data_type_set_value_owned (_tmp69_, TRUE);
		_tmp70_ = type;
		_tmp71_ = array_data;
		_tmp72_ = strlen (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_array_type_new (_tmp70_, ((gint) _tmp73_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp74_;
	}
	_tmp75_ = type;
	_tmp76_ = nullable;
	vala_data_type_set_nullable (_tmp75_, _tmp76_);
	_tmp77_ = type;
	_tmp78_ = value_owned;
	vala_data_type_set_value_owned (_tmp77_, _tmp78_);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}


static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self, 
                                    const gchar* attribute_name, 
                                    ValaGirParserArgumentType arg_type)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}


static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self, 
                                  ValaDataType* orig_type, 
                                  gboolean owned_by_default, 
                                  gboolean* no_array_length, 
                                  gboolean* array_null_terminated, 
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_VOID_TYPE)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ARRAY_TYPE)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		ValaGirParserMetadata* _tmp44_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (orig_type, VALA_TYPE_ARRAY_TYPE)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}


static gint
string_index_of_char (const gchar* self, 
                      gunichar c, 
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self, 
                                  const gchar* gir_name)
{
	gchar* result = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (gir_name);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ == NULL) {
		ValaMarkupReader* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "name");
		_g_free0 (name);
		name = _tmp3_;
	}
	_tmp4_ = self->priv->metadata;
	_tmp5_ = vala_gir_parser_metadata_get_string (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp5_;
	_tmp6_ = pattern;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = pattern;
		if (string_index_of_char (_tmp7_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = pattern;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp10_;
				gchar** split = NULL;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				GRegex* regex = NULL;
				const gchar* _tmp21_;
				GRegex* _tmp22_;
				gchar* _tmp23_ = NULL;
				GRegex* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp10_ = g_strdup ("\\1");
				replacement = _tmp10_;
				_tmp11_ = pattern;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "/", 0);
				split = _tmp13_;
				split_length1 = _vala_array_length (_tmp12_);
				_split_size_ = split_length1;
				_tmp14_ = split;
				_tmp14__length1 = split_length1;
				if (_tmp14__length1 > 1) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp15_ = split;
					_tmp15__length1 = split_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (pattern);
					pattern = _tmp17_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (replacement);
					replacement = _tmp20_;
				}
				_tmp21_ = pattern;
				_tmp22_ = g_regex_new (_tmp21_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error_);
				regex = _tmp22_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch7_g_error;
				}
				_tmp24_ = regex;
				_tmp25_ = name;
				_tmp26_ = replacement;
				_tmp27_ = g_regex_replace (_tmp24_, _tmp25_, (gssize) -1, 0, _tmp26_, 0, &_inner_error_);
				_tmp23_ = _tmp27_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch7_g_error;
				}
				_tmp28_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (name);
				name = _tmp28_;
				_g_free0 (_tmp23_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally7;
			__catch7_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp29_ = pattern;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (name);
				name = _tmp30_;
				_g_error_free0 (e);
			}
			__finally7:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_;
		_tmp32_ = name;
		if (_tmp32_ != NULL) {
			const gchar* _tmp33_;
			_tmp33_ = name;
			_tmp31_ = g_str_has_suffix (_tmp33_, "Enum");
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			_tmp34_ = name;
			_tmp35_ = name;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen ("Enum");
			_tmp39_ = _tmp38_;
			_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
			_g_free0 (name);
			name = _tmp40_;
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}


static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}


static void
vala_gir_parser_set_array_ccode (ValaGirParser* self, 
                                 ValaSymbol* sym, 
                                 ValaGirParserParameterInfo* info)
{
	gfloat _tmp0_;
	gchar* type_name = NULL;
	ValaParameter* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info->vala_idx;
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) _tmp0_, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PARAMETER)) {
		ValaParameter* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = info->param;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp3_, NULL);
	}
	_tmp4_ = info->param;
	_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_data_type_to_qualified_string (_tmp6_, NULL);
	type_name = _tmp7_;
	_tmp8_ = type_name;
	if (g_strcmp0 (_tmp8_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaGirParserNode* _tmp12_;
		_tmp9_ = self->priv->root;
		_tmp10_ = type_name;
		_tmp11_ = vala_gir_parser_node_lookup (_tmp9_, _tmp10_, FALSE, NULL);
		st = _tmp11_;
		_tmp12_ = st;
		if (_tmp12_ != NULL) {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
				ValaMethod* m = NULL;
				ValaMethod* _tmp13_;
				ValaMethod* _tmp14_;
				ValaGirParserNode* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp13_;
				_tmp14_ = m;
				_tmp15_ = st;
				_tmp16_ = vala_gir_parser_node_get_cname (_tmp15_);
				_tmp17_ = _tmp16_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp14_, "CCode", "array_length_type", _tmp17_, NULL);
				_g_free0 (_tmp17_);
				_vala_code_node_unref0 (m);
			} else {
				ValaParameter* param = NULL;
				ValaParameter* _tmp18_;
				ValaParameter* _tmp19_;
				ValaGirParserNode* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp18_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PARAMETER, ValaParameter));
				param = _tmp18_;
				_tmp19_ = param;
				_tmp20_ = st;
				_tmp21_ = vala_gir_parser_node_get_cname (_tmp20_);
				_tmp22_ = _tmp21_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp19_, "CCode", "array_length_type", _tmp22_, NULL);
				_g_free0 (_tmp22_);
				_vala_code_node_unref0 (param);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}


static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self, 
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}


static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp21_;
					ValaSourceFile* _tmp22_;
					const gchar* _tmp23_;
					ValaCodeContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = vala_gir_parser_parse_package (self);
					pkg = _tmp21_;
					_tmp22_ = self->priv->current_source_file;
					_tmp23_ = pkg;
					vala_source_file_set_package_name (_tmp22_, _tmp23_);
					_tmp24_ = self->priv->context;
					_tmp25_ = pkg;
					if (vala_code_context_has_package (_tmp24_, _tmp25_)) {
						ValaSourceFile* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = self->priv->current_source_file;
						_tmp27_ = vala_source_file_get_explicit (_tmp26_);
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = self->priv->context;
						_tmp30_ = pkg;
						vala_code_context_add_package (_tmp29_, _tmp30_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = self->priv->reader;
					_tmp32_ = vala_markup_reader_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					if (g_strcmp0 (_tmp33_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaMarkupReader* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = vala_gir_parser_get_current_src (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->reader;
						_tmp37_ = vala_markup_reader_get_name (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_vala_source_reference_unref0 (_tmp35_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}


static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}


static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}


static void
_vala_array_add1 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	ValaMarkupReader* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->cheader_filenames;
	_tmp0__length1 = self->priv->cheader_filenames_length1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_attribute (_tmp1_, "name");
	_vala_array_add1 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp2_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}


static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		gint _tmp0_;
		ValaMarkupTokenType _tmp1_;
		_tmp0_ = level;
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp2_;
			_tmp2_ = level;
			level = _tmp2_ + 1;
		} else {
			ValaMarkupTokenType _tmp3_;
			_tmp3_ = self->priv->current_token;
			if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp4_;
				_tmp4_ = level;
				level = _tmp4_ - 1;
			} else {
				ValaMarkupTokenType _tmp5_;
				_tmp5_ = self->priv->current_token;
				if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp6_;
					ValaSourceReference* _tmp7_;
					_tmp6_ = vala_gir_parser_get_current_src (self);
					_tmp7_ = _tmp6_;
					vala_report_error (_tmp7_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp7_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}


static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self, 
                              ValaGirParserNode* parent_scope, 
                              ValaUnresolvedSymbol* unresolved_sym, 
                              gboolean create_namespace)
{
	ValaGirParserNode* result = NULL;
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}


static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self, 
                                ValaGirParserNode* parent_scope, 
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaSymbol* result = NULL;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}


static void
vala_gir_parser_push_node (ValaGirParser* self, 
                           const gchar* name, 
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}


static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}


static gint
string_index_of (const gchar* self, 
                 const gchar* needle, 
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}


static gchar*
_vala_g_strjoinv (const gchar* separator, 
                  gchar** str_array, 
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaSet* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp28_;
	ValaSourceFile* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp50_;
	const gchar* _tmp51_;
	ValaGirParserMetadata* _tmp52_;
	ValaGirParserMetadata* _tmp53_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp59_;
	const gchar* _tmp60_;
	ValaSourceFile* _tmp61_;
	const gchar* _tmp62_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp63_;
	ValaGirParserNode* _tmp64_;
	gboolean _tmp65_;
	ValaGirParserNode* _tmp80_;
	ValaGirParserMetadata* _tmp81_;
	ValaGirParserMetadata* _tmp82_;
	ValaGirParserMetadata* _tmp83_;
	ValaGirParserMetadata* _tmp86_;
	ValaNamespace* _tmp92_;
	const gchar* _tmp93_;
	ValaNamespace* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp106_;
	gchar** _tmp109_;
	gint _tmp109__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		gint _tmp4_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		_tmp4_ = idx;
		if (_tmp4_ != -1) {
			const gchar* _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = cprefix;
			_tmp6_ = idx;
			_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
			_g_free0 (cprefix);
			cprefix = _tmp7_;
		}
	}
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp9_;
	_tmp10_ = cprefix;
	_tmp11_ = g_strdup (_tmp10_);
	vala_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "name");
	gir_namespace = _tmp13_;
	_tmp14_ = self->priv->reader;
	_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "version");
	gir_version = _tmp15_;
	_tmp16_ = lower_case_cprefix;
	if (_tmp16_ != NULL) {
		gint idx = 0;
		const gchar* _tmp17_;
		gint _tmp18_;
		_tmp17_ = lower_case_cprefix;
		idx = string_index_of (_tmp17_, ",", 0);
		_tmp18_ = idx;
		if (_tmp18_ != -1) {
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = lower_case_cprefix;
			_tmp20_ = idx;
			_tmp21_ = string_substring (_tmp19_, (glong) 0, (glong) _tmp20_);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp21_;
		}
	}
	_tmp22_ = self->priv->provided_namespaces;
	_tmp23_ = gir_namespace;
	_tmp24_ = gir_version;
	_tmp25_ = g_strdup_printf ("%s-%s", _tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_collection_contains ((ValaCollection*) _tmp22_, _tmp26_);
	_g_free0 (_tmp26_);
	if (_tmp27_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp28_ = self->priv->context;
	_tmp29_ = self->priv->current_source_file;
	_tmp30_ = vala_source_file_get_filename (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_metadata_path (_tmp28_, _tmp31_);
	metadata_filename = _tmp32_;
	_tmp34_ = metadata_filename;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		_tmp35_ = metadata_filename;
		_tmp33_ = g_file_test (_tmp35_, G_FILE_TEST_EXISTS);
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp36_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFileType _tmp39_;
		ValaSourceFileType _tmp40_;
		const gchar* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaCodeContext* _tmp43_;
		ValaSourceFile* _tmp44_;
		ValaGirParserMetadataParser* _tmp45_;
		ValaSourceFile* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaArrayList* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		_tmp36_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp36_;
		_tmp37_ = self->priv->context;
		_tmp38_ = self->priv->current_source_file;
		_tmp39_ = vala_source_file_get_file_type (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = metadata_filename;
		_tmp42_ = vala_source_file_new (_tmp37_, _tmp40_, _tmp41_, NULL, FALSE);
		metadata_file = _tmp42_;
		_tmp43_ = self->priv->context;
		_tmp44_ = metadata_file;
		vala_code_context_add_source_file (_tmp43_, _tmp44_);
		_tmp45_ = metadata_parser;
		_tmp46_ = metadata_file;
		_tmp47_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp45_, _tmp46_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp47_;
		_tmp48_ = self->priv->metadata_roots;
		_tmp49_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp48_, _tmp49_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp50_ = self->priv->metadata;
	_tmp51_ = gir_namespace;
	_tmp52_ = vala_gir_parser_metadata_match_child (_tmp50_, _tmp51_, NULL);
	ns_metadata = _tmp52_;
	_tmp53_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp54_;
		gchar* _tmp55_;
		_tmp54_ = ns_metadata;
		_tmp55_ = vala_gir_parser_metadata_get_string (_tmp54_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp55_;
	}
	_tmp56_ = vala_namespace;
	if (_tmp56_ == NULL) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp57_ = gir_namespace;
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp58_;
	}
	_tmp59_ = self->priv->current_source_file;
	_tmp60_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->current_source_file;
	_tmp62_ = gir_version;
	vala_source_file_set_gir_version (_tmp61_, _tmp62_);
	_tmp63_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp63_, TRUE);
	_tmp64_ = self->priv->current;
	_tmp65_ = _tmp64_->new_symbol;
	if (_tmp65_) {
		const gchar* _tmp66_;
		ValaGirParserNode* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaNamespace* _tmp69_;
		ValaGirParserNode* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaSymbol* _tmp72_;
		_tmp66_ = vala_namespace;
		_tmp67_ = self->priv->current;
		_tmp68_ = _tmp67_->source_reference;
		_tmp69_ = vala_namespace_new (_tmp66_, _tmp68_);
		_vala_code_node_unref0 (ns);
		ns = _tmp69_;
		_tmp70_ = self->priv->current;
		_tmp71_ = ns;
		_tmp72_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp71_);
		_vala_code_node_unref0 (_tmp70_->symbol);
		_tmp70_->symbol = _tmp72_;
	} else {
		ValaGirParserNode* _tmp73_;
		ValaSymbol* _tmp74_;
		ValaNamespace* _tmp75_;
		ValaNamespace* _tmp76_;
		ValaNamespace* _tmp77_;
		ValaGirParserNode* _tmp78_;
		ValaSourceReference* _tmp79_;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->symbol;
		_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp75_;
		_tmp76_ = ns;
		__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) _tmp76_)->attributes);
		((ValaCodeNode*) _tmp76_)->attributes = NULL;
		_tmp77_ = ns;
		_tmp78_ = self->priv->current;
		_tmp79_ = _tmp78_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp77_, _tmp79_);
	}
	_tmp80_ = self->priv->current;
	_tmp81_ = ns_metadata;
	_tmp82_ = _vala_gir_parser_metadata_ref0 (_tmp81_);
	_vala_gir_parser_metadata_unref0 (_tmp80_->metadata);
	_tmp80_->metadata = _tmp82_;
	_tmp83_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp83_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp84_;
		gchar* _tmp85_;
		_tmp84_ = ns_metadata;
		_tmp85_ = vala_gir_parser_metadata_get_string (_tmp84_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp85_;
	}
	_tmp86_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp86_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp87_;
		gchar* _tmp88_;
		_tmp87_ = ns_metadata;
		_tmp88_ = vala_gir_parser_metadata_get_string (_tmp87_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp88_;
	} else {
		const gchar* _tmp89_;
		_tmp89_ = lower_case_cprefix;
		if (_tmp89_ != NULL) {
			const gchar* _tmp90_;
			gchar* _tmp91_;
			_tmp90_ = lower_case_cprefix;
			_tmp91_ = g_strconcat (_tmp90_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp91_;
		}
	}
	_tmp92_ = ns;
	_tmp93_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "gir_namespace", _tmp93_, NULL);
	_tmp94_ = ns;
	_tmp95_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp94_, "CCode", "gir_version", _tmp95_, NULL);
	_tmp96_ = cprefix;
	if (_tmp96_ != NULL) {
		ValaNamespace* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		_tmp97_ = ns;
		_tmp98_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "CCode", "cprefix", _tmp98_, NULL);
		_tmp99_ = lower_case_cprefix;
		if (_tmp99_ == NULL) {
			ValaNamespace* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			_tmp100_ = ns;
			_tmp101_ = cprefix;
			_tmp102_ = vala_symbol_camel_case_to_lower_case (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = g_strconcat (_tmp103_, "_", NULL);
			_tmp105_ = _tmp104_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp100_, "CCode", "lower_case_cprefix", _tmp105_, NULL);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp103_);
		}
	}
	_tmp106_ = lower_case_cprefix;
	if (_tmp106_ != NULL) {
		ValaNamespace* _tmp107_;
		const gchar* _tmp108_;
		_tmp107_ = ns;
		_tmp108_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp107_, "CCode", "lower_case_cprefix", _tmp108_, NULL);
	}
	_tmp109_ = self->priv->cheader_filenames;
	_tmp109__length1 = self->priv->cheader_filenames_length1;
	if (_tmp109_ != NULL) {
		ValaNamespace* _tmp110_;
		gchar** _tmp111_;
		gint _tmp111__length1;
		gchar* _tmp112_;
		gchar* _tmp113_;
		_tmp110_ = ns;
		_tmp111_ = self->priv->cheader_filenames;
		_tmp111__length1 = self->priv->cheader_filenames_length1;
		_tmp112_ = _vala_g_strjoinv (",", _tmp111_, _tmp111__length1);
		_tmp113_ = _tmp112_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "CCode", "cheader_filename", _tmp113_, NULL);
		_g_free0 (_tmp113_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp114_;
		ValaMarkupReader* _tmp115_;
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		_tmp114_ = self->priv->current_token;
		if (!(_tmp114_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp115_ = self->priv->reader;
		_tmp116_ = vala_markup_reader_get_name (_tmp115_);
		_tmp117_ = _tmp116_;
		if (g_strcmp0 (_tmp117_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp118_;
			const gchar* _tmp119_;
			const gchar* _tmp120_;
			_tmp118_ = self->priv->reader;
			_tmp119_ = vala_markup_reader_get_name (_tmp118_);
			_tmp120_ = _tmp119_;
			if (g_strcmp0 (_tmp120_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp121_;
				_tmp121_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp121_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp122_;
					_tmp122_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp122_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp123_ = FALSE;
					ValaMarkupReader* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gboolean _tmp127_;
					_tmp124_ = self->priv->reader;
					_tmp125_ = vala_markup_reader_get_attribute (_tmp124_, "glib:error-quark");
					_tmp126_ = _tmp125_;
					_tmp127_ = _tmp126_ != NULL;
					_g_free0 (_tmp126_);
					if (_tmp127_) {
						_tmp123_ = TRUE;
					} else {
						ValaMarkupReader* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						_tmp128_ = self->priv->reader;
						_tmp129_ = vala_markup_reader_get_attribute (_tmp128_, "glib:error-domain");
						_tmp130_ = _tmp129_;
						_tmp123_ = _tmp130_ != NULL;
						_g_free0 (_tmp130_);
					}
					if (_tmp123_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp131_;
				const gchar* _tmp132_;
				const gchar* _tmp133_;
				_tmp131_ = self->priv->reader;
				_tmp132_ = vala_markup_reader_get_name (_tmp131_);
				_tmp133_ = _tmp132_;
				if (g_strcmp0 (_tmp133_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp134_;
					const gchar* _tmp135_;
					const gchar* _tmp136_;
					_tmp134_ = self->priv->reader;
					_tmp135_ = vala_markup_reader_get_name (_tmp134_);
					_tmp136_ = _tmp135_;
					if (g_strcmp0 (_tmp136_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp137_;
						const gchar* _tmp138_;
						const gchar* _tmp139_;
						_tmp137_ = self->priv->reader;
						_tmp138_ = vala_markup_reader_get_name (_tmp137_);
						_tmp139_ = _tmp138_;
						if (g_strcmp0 (_tmp139_, "callback") == 0) {
							vala_gir_parser_parse_callback (self);
						} else {
							ValaMarkupReader* _tmp140_;
							const gchar* _tmp141_;
							const gchar* _tmp142_;
							_tmp140_ = self->priv->reader;
							_tmp141_ = vala_markup_reader_get_name (_tmp140_);
							_tmp142_ = _tmp141_;
							if (g_strcmp0 (_tmp142_, "record") == 0) {
								ValaGirParserMetadata* _tmp143_;
								_tmp143_ = self->priv->metadata;
								if (vala_gir_parser_metadata_has_argument (_tmp143_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
									ValaGirParserMetadata* _tmp144_;
									_tmp144_ = self->priv->metadata;
									if (vala_gir_parser_metadata_get_bool (_tmp144_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
										vala_gir_parser_parse_record (self);
									} else {
										vala_gir_parser_parse_boxed (self, "record");
									}
								} else {
									gchar* _tmp145_;
									gchar* _tmp146_;
									gboolean _tmp147_;
									_tmp145_ = vala_gir_parser_element_get_type_id (self);
									_tmp146_ = _tmp145_;
									_tmp147_ = _tmp146_ != NULL;
									_g_free0 (_tmp146_);
									if (_tmp147_) {
										vala_gir_parser_parse_boxed (self, "record");
									} else {
										ValaMarkupReader* _tmp148_;
										gchar* _tmp149_;
										gchar* _tmp150_;
										gboolean _tmp151_;
										_tmp148_ = self->priv->reader;
										_tmp149_ = vala_markup_reader_get_attribute (_tmp148_, "name");
										_tmp150_ = _tmp149_;
										_tmp151_ = !g_str_has_suffix (_tmp150_, "Private");
										_g_free0 (_tmp150_);
										if (_tmp151_) {
											gboolean _tmp152_ = FALSE;
											ValaMarkupReader* _tmp153_;
											gchar* _tmp154_;
											gchar* _tmp155_;
											gboolean _tmp156_;
											_tmp153_ = self->priv->reader;
											_tmp154_ = vala_markup_reader_get_attribute (_tmp153_, "glib:is-gtype-struct-for");
											_tmp155_ = _tmp154_;
											_tmp156_ = _tmp155_ == NULL;
											_g_free0 (_tmp155_);
											if (_tmp156_) {
												ValaMarkupReader* _tmp157_;
												gchar* _tmp158_;
												gchar* _tmp159_;
												_tmp157_ = self->priv->reader;
												_tmp158_ = vala_markup_reader_get_attribute (_tmp157_, "disguised");
												_tmp159_ = _tmp158_;
												_tmp152_ = g_strcmp0 (_tmp159_, "1") == 0;
												_g_free0 (_tmp159_);
											} else {
												_tmp152_ = FALSE;
											}
											if (_tmp152_) {
												vala_gir_parser_parse_boxed (self, "record");
											} else {
												vala_gir_parser_parse_record (self);
											}
										} else {
											vala_gir_parser_skip_element (self);
										}
									}
								}
							} else {
								ValaMarkupReader* _tmp160_;
								const gchar* _tmp161_;
								const gchar* _tmp162_;
								_tmp160_ = self->priv->reader;
								_tmp161_ = vala_markup_reader_get_name (_tmp160_);
								_tmp162_ = _tmp161_;
								if (g_strcmp0 (_tmp162_, "class") == 0) {
									vala_gir_parser_parse_class (self);
								} else {
									ValaMarkupReader* _tmp163_;
									const gchar* _tmp164_;
									const gchar* _tmp165_;
									_tmp163_ = self->priv->reader;
									_tmp164_ = vala_markup_reader_get_name (_tmp163_);
									_tmp165_ = _tmp164_;
									if (g_strcmp0 (_tmp165_, "interface") == 0) {
										vala_gir_parser_parse_interface (self);
									} else {
										ValaMarkupReader* _tmp166_;
										const gchar* _tmp167_;
										const gchar* _tmp168_;
										_tmp166_ = self->priv->reader;
										_tmp167_ = vala_markup_reader_get_name (_tmp166_);
										_tmp168_ = _tmp167_;
										if (g_strcmp0 (_tmp168_, "glib:boxed") == 0) {
											vala_gir_parser_parse_boxed (self, "glib:boxed");
										} else {
											ValaMarkupReader* _tmp169_;
											const gchar* _tmp170_;
											const gchar* _tmp171_;
											_tmp169_ = self->priv->reader;
											_tmp170_ = vala_markup_reader_get_name (_tmp169_);
											_tmp171_ = _tmp170_;
											if (g_strcmp0 (_tmp171_, "union") == 0) {
												gboolean _tmp172_ = FALSE;
												gchar* _tmp173_;
												gchar* _tmp174_;
												gboolean _tmp175_;
												_tmp173_ = vala_gir_parser_element_get_type_id (self);
												_tmp174_ = _tmp173_;
												_tmp175_ = _tmp174_ != NULL;
												_g_free0 (_tmp174_);
												if (_tmp175_) {
													ValaGirParserMetadata* _tmp176_;
													_tmp176_ = self->priv->metadata;
													_tmp172_ = !vala_gir_parser_metadata_get_bool (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
												} else {
													_tmp172_ = FALSE;
												}
												if (_tmp172_) {
													vala_gir_parser_parse_boxed (self, "union");
												} else {
													vala_gir_parser_parse_union (self);
												}
											} else {
												ValaMarkupReader* _tmp177_;
												const gchar* _tmp178_;
												const gchar* _tmp179_;
												_tmp177_ = self->priv->reader;
												_tmp178_ = vala_markup_reader_get_name (_tmp177_);
												_tmp179_ = _tmp178_;
												if (g_strcmp0 (_tmp179_, "constant") == 0) {
													vala_gir_parser_parse_constant (self);
												} else {
													ValaSourceReference* _tmp180_;
													ValaSourceReference* _tmp181_;
													ValaMarkupReader* _tmp182_;
													const gchar* _tmp183_;
													const gchar* _tmp184_;
													gchar* _tmp185_;
													gchar* _tmp186_;
													_tmp180_ = vala_gir_parser_get_current_src (self);
													_tmp181_ = _tmp180_;
													_tmp182_ = self->priv->reader;
													_tmp183_ = vala_markup_reader_get_name (_tmp182_);
													_tmp184_ = _tmp183_;
													_tmp185_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp184_);
													_tmp186_ = _tmp185_;
													vala_report_error (_tmp181_, _tmp186_);
													_g_free0 (_tmp186_);
													_vala_source_reference_unref0 (_tmp181_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}


static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}


static gunichar
string_get_char (const gchar* self, 
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self, 
                                         gchar* * common_prefix, 
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}


static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* result = NULL;
	ValaGirComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaGirComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_gir_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				break;
			}
		}
	}
	result = comment;
	return result;
}


static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* result = NULL;
	ValaComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				break;
			}
		}
	}
	result = comment;
	return result;
}


static void
vala_gir_parser_parse_enumeration (ValaGirParser* self, 
                                   const gchar* element_name, 
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	gchar* common_prefix = NULL;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp26_;
	ValaGirComment* _tmp27_;
	ValaGirComment* _tmp28_;
	gboolean _tmp49_;
	const gchar* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		ValaGirParserNode* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		if (error_domain) {
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			ValaGirParserNode* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaErrorDomain* _tmp8_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_->name;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_->source_reference;
			_tmp8_ = vala_error_domain_new (_tmp5_, _tmp7_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp8_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp9_;
			const gchar* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaEnum* _tmp13_;
			ValaEnum* _tmp15_;
			ValaSymbol* _tmp16_;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->name;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_->source_reference;
			_tmp13_ = vala_enum_new (_tmp10_, _tmp12_, NULL);
			en = _tmp13_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp14_;
				_tmp14_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp14_, "Flags", TRUE, NULL);
			}
			_tmp15_ = en;
			_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp15_);
			_vala_code_node_unref0 (sym);
			sym = _tmp16_;
			_vala_code_node_unref0 (en);
		}
		_tmp17_ = self->priv->current;
		_tmp18_ = sym;
		_tmp19_ = _vala_code_node_ref0 (_tmp18_);
		_vala_code_node_unref0 (_tmp17_->symbol);
		_tmp17_->symbol = _tmp19_;
	} else {
		ValaGirParserNode* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->symbol;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		_vala_code_node_unref0 (sym);
		sym = _tmp22_;
	}
	if (!error_domain) {
		ValaSymbol* _tmp23_;
		_tmp23_ = sym;
		vala_gir_parser_set_type_id_ccode (self, _tmp23_);
	}
	_tmp24_ = sym;
	vala_symbol_set_external (_tmp24_, TRUE);
	_tmp25_ = sym;
	vala_symbol_set_access (_tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp26_ = sym;
	_tmp27_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp28_ = _tmp27_;
	vala_symbol_set_comment (_tmp26_, (ValaComment*) _tmp28_);
	_vala_comment_unref0 (_tmp28_);
	while (TRUE) {
		ValaMarkupTokenType _tmp29_;
		ValaMarkupReader* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp29_ = self->priv->current_token;
		if (!(_tmp29_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp30_ = self->priv->reader;
		_tmp31_ = vala_markup_reader_get_name (_tmp30_);
		_tmp32_ = _tmp31_;
		if (g_strcmp0 (_tmp32_, "member") == 0) {
			has_member = TRUE;
			if (error_domain) {
				ValaGirParserNode* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				vala_gir_parser_parse_error_member (self);
				_tmp33_ = self->priv->old_current;
				_tmp34_ = vala_gir_parser_node_get_cname (_tmp33_);
				_tmp35_ = _tmp34_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp35_);
				_g_free0 (_tmp35_);
			} else {
				ValaGirParserNode* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_gir_parser_parse_enumeration_member (self);
				_tmp36_ = self->priv->old_current;
				_tmp37_ = vala_gir_parser_node_get_cname (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp38_);
				_g_free0 (_tmp38_);
			}
		} else {
			ValaMarkupReader* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			_tmp39_ = self->priv->reader;
			_tmp40_ = vala_markup_reader_get_name (_tmp39_);
			_tmp41_ = _tmp40_;
			if (g_strcmp0 (_tmp41_, "function") == 0) {
				vala_gir_parser_skip_element (self);
			} else {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaMarkupReader* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp42_ = vala_gir_parser_get_current_src (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = self->priv->reader;
				_tmp45_ = vala_markup_reader_get_name (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp46_, element_name);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp43_, _tmp48_);
				_g_free0 (_tmp48_);
				_vala_source_reference_unref0 (_tmp43_);
				vala_gir_parser_skip_element (self);
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp49_ = has_member;
	if (!_tmp49_) {
		ValaSourceReference* _tmp50_;
		ValaSourceReference* _tmp51_;
		ValaGirParserNode* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp50_ = vala_gir_parser_get_current_src (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = self->priv->current;
		_tmp53_ = _tmp52_->name;
		_tmp54_ = g_strdup_printf ("%s `%s' has no members", element_name, _tmp53_);
		_tmp55_ = _tmp54_;
		vala_report_error (_tmp51_, _tmp55_);
		_g_free0 (_tmp55_);
		_vala_source_reference_unref0 (_tmp51_);
	}
	_tmp56_ = common_prefix;
	if (_tmp56_ != NULL) {
		ValaSymbol* _tmp57_;
		const gchar* _tmp58_;
		_tmp57_ = sym;
		_tmp58_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp57_, "CCode", "cprefix", _tmp58_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}


static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}


static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}


static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}


static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}


static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self, 
                                    gchar* * ctype, 
                                    gint* array_length_idx, 
                                    gboolean* no_array_length, 
                                    gboolean* array_null_terminated, 
                                    ValaComment* * comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	ValaDataType* result = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gboolean _tmp8_;
	gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp8_ = transfer_elements;
	_tmp13_ = vala_gir_parser_parse_type (self, &_tmp9_, &_tmp10_, _tmp8_, &_tmp11_, &_tmp12_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp9_;
	_vala_array_length_idx = _tmp10_;
	_vala_no_array_length = _tmp11_;
	_vala_array_null_terminated = _tmp12_;
	type = _tmp13_;
	_tmp15_ = transfer;
	if (g_strcmp0 (_tmp15_, "full") == 0) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = transfer;
		_tmp14_ = g_strcmp0 (_tmp16_, "container") == 0;
	}
	if (_tmp14_) {
		ValaDataType* _tmp17_;
		_tmp17_ = type;
		vala_data_type_set_value_owned (_tmp17_, TRUE);
	}
	_tmp19_ = nullable;
	if (g_strcmp0 (_tmp19_, "1") == 0) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = allow_none;
		_tmp18_ = g_strcmp0 (_tmp20_, "1") == 0;
	}
	if (_tmp18_) {
		ValaDataType* _tmp21_;
		_tmp21_ = type;
		vala_data_type_set_nullable (_tmp21_, TRUE);
	}
	_tmp22_ = type;
	_tmp23_ = vala_gir_parser_element_get_type (self, _tmp22_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp23_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}


static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self, 
                                 gint* array_length_idx, 
                                 gint* closure_idx, 
                                 gint* destroy_idx, 
                                 gchar* * scope, 
                                 ValaComment* * comment, 
                                 const gchar* default_name)
{
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaParameter* result = NULL;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMarkupTokenType _tmp5_;
	const gchar* _tmp11_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp19_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp27_;
	gchar* _tmp28_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp29_;
	gchar* _tmp30_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp34_;
	gchar* _tmp35_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp36_;
	gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	gboolean _tmp41_ = FALSE;
	const gchar* _tmp42_;
	ValaGirParserMetadata* _tmp44_;
	ValaGirParserMetadata* _tmp46_;
	ValaComment* _tmp48_;
	ValaMarkupReader* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp111_;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	element_type = _tmp3_;
	_tmp5_ = self->priv->current_token;
	if (_tmp5_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = element_type;
		if (g_strcmp0 (_tmp7_, "parameter") != 0) {
			const gchar* _tmp8_;
			_tmp8_ = element_type;
			_tmp6_ = g_strcmp0 (_tmp8_, "instance-parameter") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_gir_parser_get_current_src (self);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp10_);
	}
	_tmp11_ = element_type;
	vala_gir_parser_start_element (self, _tmp11_);
	_tmp12_ = self->priv->metadata;
	_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp13_;
	_tmp14_ = name;
	if (_tmp14_ == NULL) {
		ValaMarkupReader* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->reader;
		_tmp16_ = vala_markup_reader_get_attribute (_tmp15_, "name");
		_g_free0 (name);
		name = _tmp16_;
	}
	_tmp17_ = name;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp18_;
	}
	direction = NULL;
	_tmp19_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp19_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp20_;
		_tmp20_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp20_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp21_;
		}
	} else {
		ValaGirParserMetadata* _tmp22_;
		_tmp22_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp22_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp23_;
			_tmp23_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp23_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp24_;
				_tmp24_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp24_;
			}
		} else {
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "direction");
			_g_free0 (direction);
			direction = _tmp26_;
		}
	}
	_tmp27_ = self->priv->reader;
	_tmp28_ = vala_markup_reader_get_attribute (_tmp27_, "transfer-ownership");
	transfer = _tmp28_;
	_tmp29_ = self->priv->reader;
	_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "nullable");
	nullable = _tmp30_;
	_tmp31_ = self->priv->reader;
	_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "allow-none");
	allow_none = _tmp32_;
	_tmp33_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp33_;
	_tmp34_ = self->priv->reader;
	_tmp35_ = vala_markup_reader_get_attribute (_tmp34_, "closure");
	closure = _tmp35_;
	_tmp36_ = self->priv->reader;
	_tmp37_ = vala_markup_reader_get_attribute (_tmp36_, "destroy");
	destroy = _tmp37_;
	_tmp39_ = closure;
	if (_tmp39_ != NULL) {
		_tmp38_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		const gchar* _tmp40_;
		_tmp40_ = closure;
		_vala_closure_idx = atoi (_tmp40_);
	}
	_tmp42_ = destroy;
	if (_tmp42_ != NULL) {
		_tmp41_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		const gchar* _tmp43_;
		_tmp43_ = destroy;
		_vala_destroy_idx = atoi (_tmp43_);
	}
	_tmp44_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp45_;
		_tmp45_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp45_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp46_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp46_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp47_;
		_tmp47_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp47_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp48_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp48_;
	_tmp49_ = self->priv->reader;
	_tmp50_ = vala_markup_reader_get_name (_tmp49_);
	_tmp51_ = _tmp50_;
	if (g_strcmp0 (_tmp51_, "varargs") == 0) {
		ValaSourceReference* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaParameter* _tmp54_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp52_ = vala_gir_parser_get_current_src (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_parameter_new_with_ellipsis (_tmp53_);
		_vala_code_node_unref0 (param);
		param = _tmp54_;
		_vala_source_reference_unref0 (_tmp53_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp55_;
		gchar* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		ValaDataType* _tmp60_;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		const gchar* _tmp63_;
		gboolean _tmp67_ = FALSE;
		const gchar* _tmp68_;
		gboolean changed = FALSE;
		gboolean _tmp73_ = FALSE;
		const gchar* _tmp74_;
		ValaDataType* _tmp76_;
		gboolean _tmp77_ = FALSE;
		ValaDataType* _tmp78_;
		gboolean _tmp79_;
		const gchar* _tmp80_;
		ValaDataType* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaSourceReference* _tmp83_;
		ValaParameter* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp88_;
		ValaDataType* _tmp92_;
		ValaParameter* _tmp103_;
		ValaGirParserMetadata* _tmp104_;
		ValaExpression* _tmp105_;
		ValaExpression* _tmp106_;
		ValaParameter* _tmp107_;
		ValaExpression* _tmp108_;
		ValaExpression* _tmp109_;
		_tmp55_ = transfer;
		_tmp60_ = vala_gir_parser_parse_type (self, &_tmp56_, &_tmp57_, g_strcmp0 (_tmp55_, "container") != 0, &_tmp58_, &_tmp59_);
		_g_free0 (ctype);
		ctype = _tmp56_;
		_vala_array_length_idx = _tmp57_;
		no_array_length = _tmp58_;
		array_null_terminated = _tmp59_;
		type = _tmp60_;
		_tmp63_ = transfer;
		if (g_strcmp0 (_tmp63_, "full") == 0) {
			_tmp62_ = TRUE;
		} else {
			const gchar* _tmp64_;
			_tmp64_ = transfer;
			_tmp62_ = g_strcmp0 (_tmp64_, "container") == 0;
		}
		if (_tmp62_) {
			_tmp61_ = TRUE;
		} else {
			const gchar* _tmp65_;
			_tmp65_ = destroy;
			_tmp61_ = _tmp65_ != NULL;
		}
		if (_tmp61_) {
			ValaDataType* _tmp66_;
			_tmp66_ = type;
			vala_data_type_set_value_owned (_tmp66_, TRUE);
		}
		_tmp68_ = nullable;
		if (g_strcmp0 (_tmp68_, "1") == 0) {
			_tmp67_ = TRUE;
		} else {
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_;
			_tmp70_ = allow_none;
			if (g_strcmp0 (_tmp70_, "1") == 0) {
				const gchar* _tmp71_;
				_tmp71_ = direction;
				_tmp69_ = g_strcmp0 (_tmp71_, "out") != 0;
			} else {
				_tmp69_ = FALSE;
			}
			_tmp67_ = _tmp69_;
		}
		if (_tmp67_) {
			ValaDataType* _tmp72_;
			_tmp72_ = type;
			vala_data_type_set_nullable (_tmp72_, TRUE);
		}
		_tmp74_ = direction;
		if (g_strcmp0 (_tmp74_, "out") == 0) {
			_tmp73_ = TRUE;
		} else {
			const gchar* _tmp75_;
			_tmp75_ = direction;
			_tmp73_ = g_strcmp0 (_tmp75_, "inout") == 0;
		}
		_tmp76_ = type;
		_tmp78_ = vala_gir_parser_element_get_type (self, _tmp76_, _tmp73_, &no_array_length, &array_null_terminated, &_tmp77_);
		changed = _tmp77_;
		_vala_code_node_unref0 (type);
		type = _tmp78_;
		_tmp79_ = changed;
		if (!_tmp79_) {
			_g_free0 (ctype);
			ctype = NULL;
		}
		_tmp80_ = name;
		_tmp81_ = type;
		_tmp82_ = vala_gir_parser_get_current_src (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_parameter_new (_tmp80_, _tmp81_, _tmp83_);
		_vala_code_node_unref0 (param);
		param = _tmp84_;
		_vala_source_reference_unref0 (_tmp83_);
		_tmp85_ = ctype;
		if (_tmp85_ != NULL) {
			ValaParameter* _tmp86_;
			const gchar* _tmp87_;
			_tmp86_ = param;
			_tmp87_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp86_, "CCode", "type", _tmp87_, NULL);
		}
		_tmp88_ = direction;
		if (g_strcmp0 (_tmp88_, "out") == 0) {
			ValaParameter* _tmp89_;
			_tmp89_ = param;
			vala_parameter_set_direction (_tmp89_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp90_;
			_tmp90_ = direction;
			if (g_strcmp0 (_tmp90_, "inout") == 0) {
				ValaParameter* _tmp91_;
				_tmp91_ = param;
				vala_parameter_set_direction (_tmp91_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp92_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_ARRAY_TYPE)) {
			ValaGirParserMetadata* _tmp93_;
			_tmp93_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp93_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp94_;
				_tmp94_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp94_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_;
				gboolean _tmp100_;
				_tmp96_ = no_array_length;
				if (_tmp96_) {
					_tmp95_ = TRUE;
				} else {
					gboolean _tmp97_;
					_tmp97_ = array_null_terminated;
					_tmp95_ = _tmp97_;
				}
				if (_tmp95_) {
					ValaParameter* _tmp98_;
					gboolean _tmp99_;
					_tmp98_ = param;
					_tmp99_ = no_array_length;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp98_, "CCode", "array_length", !_tmp99_, NULL);
				}
				_tmp100_ = array_null_terminated;
				if (_tmp100_) {
					ValaParameter* _tmp101_;
					gboolean _tmp102_;
					_tmp101_ = param;
					_tmp102_ = array_null_terminated;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp101_, "CCode", "array_null_terminated", _tmp102_, NULL);
				}
			}
		}
		_tmp103_ = param;
		_tmp104_ = self->priv->metadata;
		_tmp105_ = vala_gir_parser_metadata_get_expression (_tmp104_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp106_ = _tmp105_;
		vala_variable_set_initializer ((ValaVariable*) _tmp103_, _tmp106_);
		_vala_code_node_unref0 (_tmp106_);
		_tmp107_ = param;
		_tmp108_ = vala_variable_get_initializer ((ValaVariable*) _tmp107_);
		_tmp109_ = _tmp108_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_TUPLE)) {
			ValaParameter* _tmp110_;
			_tmp110_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp110_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp111_ = element_type;
	vala_gir_parser_end_element (self, _tmp111_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self, 
                            gchar* * ctype, 
                            gint* array_length_idx, 
                            gboolean transfer_elements, 
                            gboolean* no_array_length, 
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaMarkupReader* _tmp51_;
	gchar* _tmp52_;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp54_;
	ValaDataType* type = NULL;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaDataType* _tmp61_;
	const gchar* _tmp70_ = NULL;
	gboolean _tmp71_;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			ValaMarkupReader* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			ValaMarkupReader* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaArrayType* _tmp36_;
			gint _tmp37_;
			_tmp7_ = self->priv->reader;
			_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "length");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "length");
				_tmp13_ = _tmp12_;
				_vala_array_length_idx = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "fixed-size");
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ != NULL;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "fixed-size");
				_tmp20_ = _tmp19_;
				fixed_length = atoi (_tmp20_);
				_g_free0 (_tmp20_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp21_ = self->priv->reader;
			_tmp22_ = vala_markup_reader_get_attribute (_tmp21_, "c:type");
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "GStrv") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "zero-terminated");
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_ != NULL;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				ValaMarkupReader* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->reader;
				_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "zero-terminated");
				_tmp31_ = _tmp30_;
				_vala_array_null_terminated = atoi (_tmp31_) != 0;
				_g_free0 (_tmp31_);
			}
			vala_gir_parser_next (self);
			_tmp32_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp32_;
			_tmp33_ = element_type;
			vala_data_type_set_value_owned (_tmp33_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp34_ = element_type;
			_tmp35_ = src;
			_tmp36_ = vala_array_type_new (_tmp34_, 1, _tmp35_);
			array_type = _tmp36_;
			_tmp37_ = fixed_length;
			if (_tmp37_ > 0) {
				ValaArrayType* _tmp38_;
				ValaArrayType* _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				ValaIntegerLiteral* _tmp43_;
				ValaIntegerLiteral* _tmp44_;
				_tmp38_ = array_type;
				vala_array_type_set_fixed_length (_tmp38_, TRUE);
				_tmp39_ = array_type;
				_tmp40_ = fixed_length;
				_tmp41_ = g_strdup_printf ("%i", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_integer_literal_new (_tmp42_, NULL);
				_tmp44_ = _tmp43_;
				vala_array_type_set_length (_tmp39_, (ValaExpression*) _tmp44_);
				_vala_code_node_unref0 (_tmp44_);
				_g_free0 (_tmp42_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		_tmp45_ = self->priv->reader;
		_tmp46_ = vala_markup_reader_get_name (_tmp45_);
		_tmp47_ = _tmp46_;
		if (g_strcmp0 (_tmp47_, "callback") == 0) {
			ValaGirParserNode* _tmp48_;
			ValaSymbol* _tmp49_;
			ValaDelegateType* _tmp50_;
			vala_gir_parser_parse_callback (self);
			_tmp48_ = self->priv->old_current;
			_tmp49_ = _tmp48_->symbol;
			_tmp50_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_DELEGATE, ValaDelegate));
			result = (ValaDataType*) _tmp50_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp51_ = self->priv->reader;
	_tmp52_ = vala_markup_reader_get_attribute (_tmp51_, "c:type");
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp52_;
	vala_gir_parser_next (self);
	_tmp54_ = type_name;
	if (g_strcmp0 (_tmp54_, "GLib.PtrArray") == 0) {
		ValaMarkupTokenType _tmp55_;
		_tmp55_ = self->priv->current_token;
		_tmp53_ = _tmp55_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		gchar* _tmp56_;
		_tmp56_ = g_strdup ("GLib.GenericArray");
		_g_free0 (type_name);
		type_name = _tmp56_;
	}
	_tmp57_ = type_name;
	_tmp58_ = _vala_ctype;
	_tmp61_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp57_, &_tmp59_, &_tmp60_, _tmp58_);
	_vala_no_array_length = _tmp59_;
	_vala_array_null_terminated = _tmp60_;
	type = _tmp61_;
	while (TRUE) {
		ValaMarkupTokenType _tmp62_;
		const gchar* _tmp63_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaArrayList* _tmp68_;
		ValaDataType* _tmp69_;
		_tmp62_ = self->priv->current_token;
		if (!(_tmp62_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp63_ = type_name;
		if (g_strcmp0 (_tmp63_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp64_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp64_;
		_tmp65_ = element_type;
		vala_data_type_set_value_owned (_tmp65_, transfer_elements);
		_tmp66_ = type;
		_tmp67_ = element_type;
		vala_data_type_add_type_argument (_tmp66_, _tmp67_);
		_tmp68_ = self->priv->unresolved_type_arguments;
		_tmp69_ = element_type;
		vala_collection_add ((ValaCollection*) _tmp68_, _tmp69_);
		_vala_code_node_unref0 (element_type);
	}
	_tmp71_ = is_array;
	if (_tmp71_) {
		_tmp70_ = "array";
	} else {
		_tmp70_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp70_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self, 
                                          const gchar* type_name, 
                                          gboolean* no_array_length, 
                                          gboolean* array_null_terminated, 
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp31_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp19_;
						ValaNamespace* _tmp20_;
						ValaNamespace* _tmp21_;
						ValaScope* _tmp22_;
						ValaScope* _tmp23_;
						ValaSymbol* _tmp24_;
						ValaStruct* _tmp25_;
						ValaBooleanType* _tmp26_;
						_tmp19_ = self->priv->context;
						_tmp20_ = vala_code_context_get_root (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = vala_scope_lookup (_tmp23_, "bool");
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp26_ = vala_boolean_type_new (_tmp25_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp26_;
						_vala_code_node_unref0 (_tmp25_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp27_ = FALSE;
												if (ctype != NULL) {
													_tmp27_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp27_ = FALSE;
												}
												if (_tmp27_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp28_ = FALSE;
													if (ctype != NULL) {
														_tmp28_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp28_ = FALSE;
													}
													if (_tmp28_) {
														type_name = "intptr";
													} else {
														type_name = "long";
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp29_ = FALSE;
													if (ctype != NULL) {
														_tmp29_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp29_ = FALSE;
													}
													if (_tmp29_) {
														type_name = "size_t";
													} else {
														gboolean _tmp30_ = FALSE;
														if (ctype != NULL) {
															_tmp30_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp30_ = FALSE;
														}
														if (_tmp30_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										type_name = "size_t";
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GLib.String") == 0) {
																															type_name = "GLib.StringBuilder";
																														} else {
																															if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																																type_name = "GLib.ObjectClass";
																															} else {
																																if (g_strcmp0 (type_name, "gunichar") == 0) {
																																	type_name = "unichar";
																																} else {
																																	if (g_strcmp0 (type_name, "GLib.Data") == 0) {
																																		type_name = "GLib.Datalist";
																																	} else {
																																		if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																			type_name = "Atk.Implementor";
																																		} else {
																																			known_type = FALSE;
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = type;
				if (_tmp31_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaUnresolvedSymbol* _tmp34_;
					ValaUnresolvedSymbol* _tmp35_;
					ValaUnresolvedSymbol* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedType* _tmp39_;
					gboolean _tmp40_;
					_tmp32_ = vala_gir_parser_get_current_src (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp33_);
					_tmp35_ = _tmp34_;
					_vala_source_reference_unref0 (_tmp33_);
					sym = _tmp35_;
					_tmp36_ = sym;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_unresolved_type_new_from_symbol (_tmp36_, _tmp38_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					_tmp40_ = known_type;
					if (!_tmp40_) {
						ValaArrayList* _tmp41_;
						ValaUnresolvedSymbol* _tmp42_;
						_tmp41_ = self->priv->unresolved_gir_symbols;
						_tmp42_ = sym;
						vala_collection_add ((ValaCollection*) _tmp41_, _tmp42_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}


static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	ValaStruct* _tmp17_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp29_;
	ValaGirComment* _tmp30_;
	ValaGirComment* _tmp31_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserNode* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaStruct* _tmp8_;
		ValaGirParserNode* _tmp9_;
		ValaStruct* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp4_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->source_reference;
		_tmp8_ = vala_struct_new (_tmp5_, _tmp7_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp8_;
		_g_free0 (_tmp5_);
		_tmp9_ = self->priv->current;
		_tmp10_ = st;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (_tmp9_->symbol);
		_tmp9_->symbol = _tmp11_;
	} else {
		ValaGirParserNode* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaStruct* _tmp14_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->symbol;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp14_;
	}
	_tmp15_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp16_, TRUE);
	_tmp17_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp18_ = self->priv->reader;
	_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp19_;
	_tmp20_ = gtype_struct_for;
	if (_tmp20_ != NULL) {
		ValaGirParserNode* _tmp21_;
		const gchar* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaArrayList* _tmp26_;
		ValaGirParserNode* _tmp27_;
		ValaUnresolvedSymbol* _tmp28_;
		_tmp21_ = self->priv->current;
		_tmp22_ = gtype_struct_for;
		_tmp23_ = self->priv->current;
		_tmp24_ = _tmp23_->source_reference;
		_tmp25_ = vala_gir_parser_parse_symbol_from_string (self, _tmp22_, _tmp24_);
		_vala_code_node_unref0 (_tmp21_->gtype_struct_for);
		_tmp21_->gtype_struct_for = _tmp25_;
		_tmp26_ = self->priv->unresolved_gir_symbols;
		_tmp27_ = self->priv->current;
		_tmp28_ = _tmp27_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp26_, _tmp28_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp29_ = st;
	_tmp30_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp31_ = _tmp30_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp29_, (ValaComment*) _tmp31_);
	_vala_comment_unref0 (_tmp31_);
	while (TRUE) {
		ValaMarkupTokenType _tmp32_;
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp32_ = self->priv->current_token;
		if (!(_tmp32_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_;
			_tmp34_ = first_field;
			if (_tmp34_) {
				ValaMarkupReader* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp35_ = self->priv->reader;
				_tmp36_ = vala_markup_reader_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp33_ = g_strcmp0 (_tmp37_, "field") == 0;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "field") == 0) {
			gboolean _tmp41_ = FALSE;
			ValaMarkupReader* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gboolean _tmp45_;
			_tmp42_ = self->priv->reader;
			_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "name");
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strcmp0 (_tmp44_, "priv") != 0;
			_g_free0 (_tmp44_);
			if (_tmp45_) {
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_;
				_tmp47_ = first_field;
				if (_tmp47_) {
					const gchar* _tmp48_;
					_tmp48_ = gtype_struct_for;
					_tmp46_ = _tmp48_ != NULL;
				} else {
					_tmp46_ = FALSE;
				}
				_tmp41_ = !_tmp46_;
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp49_ = self->priv->reader;
			_tmp50_ = vala_markup_reader_get_name (_tmp49_);
			_tmp51_ = _tmp50_;
			if (g_strcmp0 (_tmp51_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				_tmp52_ = self->priv->reader;
				_tmp53_ = vala_markup_reader_get_name (_tmp52_);
				_tmp54_ = _tmp53_;
				if (g_strcmp0 (_tmp54_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp55_ = self->priv->reader;
					_tmp56_ = vala_markup_reader_get_name (_tmp55_);
					_tmp57_ = _tmp56_;
					if (g_strcmp0 (_tmp57_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp58_;
						const gchar* _tmp59_;
						const gchar* _tmp60_;
						_tmp58_ = self->priv->reader;
						_tmp59_ = vala_markup_reader_get_name (_tmp58_);
						_tmp60_ = _tmp59_;
						if (g_strcmp0 (_tmp60_, "union") == 0) {
							vala_gir_parser_parse_union (self);
						} else {
							ValaSourceReference* _tmp61_;
							ValaSourceReference* _tmp62_;
							ValaMarkupReader* _tmp63_;
							const gchar* _tmp64_;
							const gchar* _tmp65_;
							gchar* _tmp66_;
							gchar* _tmp67_;
							_tmp61_ = vala_gir_parser_get_current_src (self);
							_tmp62_ = _tmp61_;
							_tmp63_ = self->priv->reader;
							_tmp64_ = vala_markup_reader_get_name (_tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp65_);
							_tmp67_ = _tmp66_;
							vala_report_error (_tmp62_, _tmp67_);
							_g_free0 (_tmp67_);
							_vala_source_reference_unref0 (_tmp62_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}


static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	gboolean _tmp5_;
	ValaClass* _tmp27_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaClass* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	_tmp5_ = _tmp4_->new_symbol;
	if (_tmp5_) {
		ValaGirParserNode* _tmp6_;
		const gchar* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaClass* _tmp10_;
		ValaClass* _tmp11_;
		ValaGirParserMetadata* _tmp12_;
		ValaMarkupReader* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		ValaGirParserNode* _tmp21_;
		ValaClass* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->name;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_->source_reference;
		_tmp10_ = vala_class_new (_tmp7_, _tmp9_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp10_;
		_tmp11_ = cl;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = self->priv->reader;
		_tmp14_ = vala_markup_reader_get_attribute (_tmp13_, "abstract");
		_tmp15_ = _tmp14_;
		vala_class_set_is_abstract (_tmp11_, vala_gir_parser_metadata_get_bool (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp15_, "1") == 0));
		_g_free0 (_tmp15_);
		_tmp16_ = parent;
		if (_tmp16_ != NULL) {
			ValaClass* _tmp17_;
			const gchar* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			_tmp17_ = cl;
			_tmp18_ = parent;
			_tmp19_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp18_, NULL, NULL, NULL);
			_tmp20_ = _tmp19_;
			vala_class_add_base_type (_tmp17_, _tmp20_);
			_vala_code_node_unref0 (_tmp20_);
		}
		_tmp21_ = self->priv->current;
		_tmp22_ = cl;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (_tmp21_->symbol);
		_tmp21_->symbol = _tmp23_;
	} else {
		ValaGirParserNode* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaClass* _tmp26_;
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_->symbol;
		_tmp26_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp26_;
	}
	_tmp27_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp28_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp29_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp29_, TRUE);
	vala_gir_parser_next (self);
	_tmp30_ = cl;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_;
			_tmp35_ = first_field;
			if (_tmp35_) {
				ValaMarkupReader* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = self->priv->reader;
				_tmp37_ = vala_markup_reader_get_name (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp34_ = g_strcmp0 (_tmp38_, "field") == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp39_ = self->priv->reader;
		_tmp40_ = vala_markup_reader_get_name (_tmp39_);
		_tmp41_ = _tmp40_;
		if (g_strcmp0 (_tmp41_, "implements") == 0) {
			ValaClass* _tmp42_;
			ValaMarkupReader* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			vala_gir_parser_start_element (self, "implements");
			_tmp42_ = cl;
			_tmp43_ = self->priv->reader;
			_tmp44_ = vala_markup_reader_get_attribute (_tmp43_, "name");
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp45_, NULL, NULL, NULL);
			_tmp47_ = _tmp46_;
			vala_class_add_base_type (_tmp42_, _tmp47_);
			_vala_code_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp48_ = self->priv->reader;
			_tmp49_ = vala_markup_reader_get_name (_tmp48_);
			_tmp50_ = _tmp49_;
			if (g_strcmp0 (_tmp50_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				_tmp51_ = self->priv->reader;
				_tmp52_ = vala_markup_reader_get_name (_tmp51_);
				_tmp53_ = _tmp52_;
				if (g_strcmp0 (_tmp53_, "field") == 0) {
					gboolean _tmp54_ = FALSE;
					gboolean _tmp55_;
					_tmp55_ = first_field;
					if (_tmp55_) {
						const gchar* _tmp56_;
						_tmp56_ = parent;
						_tmp54_ = _tmp56_ != NULL;
					} else {
						_tmp54_ = FALSE;
					}
					if (_tmp54_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gboolean _tmp60_;
						_tmp57_ = self->priv->reader;
						_tmp58_ = vala_markup_reader_get_attribute (_tmp57_, "name");
						_tmp59_ = _tmp58_;
						_tmp60_ = g_strcmp0 (_tmp59_, "priv") != 0;
						_g_free0 (_tmp59_);
						if (_tmp60_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					_tmp61_ = self->priv->reader;
					_tmp62_ = vala_markup_reader_get_name (_tmp61_);
					_tmp63_ = _tmp62_;
					if (g_strcmp0 (_tmp63_, "property") == 0) {
						ValaProperty* _tmp64_;
						ValaProperty* _tmp65_;
						_tmp64_ = vala_gir_parser_parse_property (self);
						_tmp65_ = _tmp64_;
						_vala_code_node_unref0 (_tmp65_);
					} else {
						ValaMarkupReader* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						_tmp66_ = self->priv->reader;
						_tmp67_ = vala_markup_reader_get_name (_tmp66_);
						_tmp68_ = _tmp67_;
						if (g_strcmp0 (_tmp68_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp69_;
							const gchar* _tmp70_;
							const gchar* _tmp71_;
							_tmp69_ = self->priv->reader;
							_tmp70_ = vala_markup_reader_get_name (_tmp69_);
							_tmp71_ = _tmp70_;
							if (g_strcmp0 (_tmp71_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp72_;
								const gchar* _tmp73_;
								const gchar* _tmp74_;
								_tmp72_ = self->priv->reader;
								_tmp73_ = vala_markup_reader_get_name (_tmp72_);
								_tmp74_ = _tmp73_;
								if (g_strcmp0 (_tmp74_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp75_;
									const gchar* _tmp76_;
									const gchar* _tmp77_;
									_tmp75_ = self->priv->reader;
									_tmp76_ = vala_markup_reader_get_name (_tmp75_);
									_tmp77_ = _tmp76_;
									if (g_strcmp0 (_tmp77_, "virtual-method") == 0) {
										vala_gir_parser_parse_method (self, "virtual-method");
									} else {
										ValaMarkupReader* _tmp78_;
										const gchar* _tmp79_;
										const gchar* _tmp80_;
										_tmp78_ = self->priv->reader;
										_tmp79_ = vala_markup_reader_get_name (_tmp78_);
										_tmp80_ = _tmp79_;
										if (g_strcmp0 (_tmp80_, "union") == 0) {
											vala_gir_parser_parse_union (self);
										} else {
											ValaMarkupReader* _tmp81_;
											const gchar* _tmp82_;
											const gchar* _tmp83_;
											_tmp81_ = self->priv->reader;
											_tmp82_ = vala_markup_reader_get_name (_tmp81_);
											_tmp83_ = _tmp82_;
											if (g_strcmp0 (_tmp83_, "glib:signal") == 0) {
												vala_gir_parser_parse_signal (self);
											} else {
												ValaSourceReference* _tmp84_;
												ValaSourceReference* _tmp85_;
												ValaMarkupReader* _tmp86_;
												const gchar* _tmp87_;
												const gchar* _tmp88_;
												gchar* _tmp89_;
												gchar* _tmp90_;
												_tmp84_ = vala_gir_parser_get_current_src (self);
												_tmp85_ = _tmp84_;
												_tmp86_ = self->priv->reader;
												_tmp87_ = vala_markup_reader_get_name (_tmp86_);
												_tmp88_ = _tmp87_;
												_tmp89_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp88_);
												_tmp90_ = _tmp89_;
												vala_report_error (_tmp85_, _tmp90_);
												_g_free0 (_tmp90_);
												_vala_source_reference_unref0 (_tmp85_);
												vala_gir_parser_skip_element (self);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}


static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaInterface* _tmp15_;
	ValaInterface* _tmp16_;
	ValaInterface* _tmp17_;
	ValaInterface* _tmp18_;
	ValaGirComment* _tmp19_;
	ValaGirComment* _tmp20_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		ValaGirParserNode* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserNode* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaInterface* _tmp8_;
		ValaGirParserNode* _tmp9_;
		ValaInterface* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->name;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->source_reference;
		_tmp8_ = vala_interface_new (_tmp5_, _tmp7_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp8_;
		_tmp9_ = self->priv->current;
		_tmp10_ = iface;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (_tmp9_->symbol);
		_tmp9_->symbol = _tmp11_;
	} else {
		ValaGirParserNode* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaInterface* _tmp14_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->symbol;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp14_;
	}
	_tmp15_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = iface;
	vala_symbol_set_external ((ValaSymbol*) _tmp17_, TRUE);
	vala_gir_parser_next (self);
	_tmp18_ = iface;
	_tmp19_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp20_ = _tmp19_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp18_, (ValaComment*) _tmp20_);
	_vala_comment_unref0 (_tmp20_);
	while (TRUE) {
		ValaMarkupTokenType _tmp21_;
		ValaMarkupReader* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp21_ = self->priv->current_token;
		if (!(_tmp21_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp22_ = self->priv->reader;
		_tmp23_ = vala_markup_reader_get_name (_tmp22_);
		_tmp24_ = _tmp23_;
		if (g_strcmp0 (_tmp24_, "prerequisite") == 0) {
			ValaInterface* _tmp25_;
			ValaMarkupReader* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp25_ = iface;
			_tmp26_ = self->priv->reader;
			_tmp27_ = vala_markup_reader_get_attribute (_tmp26_, "name");
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp28_, NULL, NULL, NULL);
			_tmp30_ = _tmp29_;
			vala_interface_add_prerequisite (_tmp25_, _tmp30_);
			_vala_code_node_unref0 (_tmp30_);
			_g_free0 (_tmp28_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp31_ = self->priv->reader;
			_tmp32_ = vala_markup_reader_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			if (g_strcmp0 (_tmp33_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp34_ = self->priv->reader;
				_tmp35_ = vala_markup_reader_get_name (_tmp34_);
				_tmp36_ = _tmp35_;
				if (g_strcmp0 (_tmp36_, "property") == 0) {
					ValaProperty* _tmp37_;
					ValaProperty* _tmp38_;
					_tmp37_ = vala_gir_parser_parse_property (self);
					_tmp38_ = _tmp37_;
					_vala_code_node_unref0 (_tmp38_);
				} else {
					ValaMarkupReader* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					_tmp39_ = self->priv->reader;
					_tmp40_ = vala_markup_reader_get_name (_tmp39_);
					_tmp41_ = _tmp40_;
					if (g_strcmp0 (_tmp41_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						_tmp42_ = self->priv->reader;
						_tmp43_ = vala_markup_reader_get_name (_tmp42_);
						_tmp44_ = _tmp43_;
						if (g_strcmp0 (_tmp44_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp45_;
							const gchar* _tmp46_;
							const gchar* _tmp47_;
							_tmp45_ = self->priv->reader;
							_tmp46_ = vala_markup_reader_get_name (_tmp45_);
							_tmp47_ = _tmp46_;
							if (g_strcmp0 (_tmp47_, "method") == 0) {
								vala_gir_parser_parse_method (self, "method");
							} else {
								ValaMarkupReader* _tmp48_;
								const gchar* _tmp49_;
								const gchar* _tmp50_;
								_tmp48_ = self->priv->reader;
								_tmp49_ = vala_markup_reader_get_name (_tmp48_);
								_tmp50_ = _tmp49_;
								if (g_strcmp0 (_tmp50_, "glib:signal") == 0) {
									vala_gir_parser_parse_signal (self);
								} else {
									ValaSourceReference* _tmp51_;
									ValaSourceReference* _tmp52_;
									ValaMarkupReader* _tmp53_;
									const gchar* _tmp54_;
									const gchar* _tmp55_;
									gchar* _tmp56_;
									gchar* _tmp57_;
									_tmp51_ = vala_gir_parser_get_current_src (self);
									_tmp52_ = _tmp51_;
									_tmp53_ = self->priv->reader;
									_tmp54_ = vala_markup_reader_get_name (_tmp53_);
									_tmp55_ = _tmp54_;
									_tmp56_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp55_);
									_tmp57_ = _tmp56_;
									vala_report_error (_tmp52_, _tmp57_);
									_g_free0 (_tmp57_);
									_vala_source_reference_unref0 (_tmp52_);
									vala_gir_parser_skip_element (self);
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}


static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	ValaGirParserNode* _tmp48_;
	ValaField* _tmp49_;
	ValaSymbol* _tmp50_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_;
		gboolean _tmp42_;
		_tmp33_ = no_array_length;
		if (!_tmp33_) {
			gint _tmp34_;
			_tmp34_ = array_length_idx;
			_tmp32_ = _tmp34_ > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp35_;
			gint _tmp36_;
			_tmp35_ = self->priv->current;
			_tmp36_ = array_length_idx;
			_tmp35_->array_length_idx = _tmp36_;
		}
		_tmp38_ = no_array_length;
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			gboolean _tmp39_;
			_tmp39_ = array_null_terminated;
			_tmp37_ = _tmp39_;
		}
		if (_tmp37_) {
			ValaField* _tmp40_;
			gboolean _tmp41_;
			_tmp40_ = field;
			_tmp41_ = no_array_length;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp40_, "CCode", "array_length", !_tmp41_, NULL);
		}
		_tmp42_ = array_null_terminated;
		if (_tmp42_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp43_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp45_ = nullable;
	if (g_strcmp0 (_tmp45_, "1") == 0) {
		_tmp44_ = TRUE;
	} else {
		const gchar* _tmp46_;
		_tmp46_ = allow_none;
		_tmp44_ = g_strcmp0 (_tmp46_, "1") == 0;
	}
	if (_tmp44_) {
		ValaDataType* _tmp47_;
		_tmp47_ = type;
		vala_data_type_set_nullable (_tmp47_, TRUE);
	}
	_tmp48_ = self->priv->current;
	_tmp49_ = field;
	_tmp50_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp49_);
	_vala_code_node_unref0 (_tmp48_->symbol);
	_tmp48_->symbol = _tmp50_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}


static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	ValaProperty* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	ValaProperty* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	gboolean _tmp34_;
	ValaGirParserNode* _tmp36_;
	ValaProperty* _tmp37_;
	ValaSymbol* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_symbol_set_external ((ValaSymbol*) _tmp26_, TRUE);
	_tmp27_ = prop;
	_tmp28_ = is_abstract;
	vala_property_set_is_abstract (_tmp27_, _tmp28_);
	_tmp30_ = no_array_length;
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		gboolean _tmp31_;
		_tmp31_ = array_null_terminated;
		_tmp29_ = _tmp31_;
	}
	if (_tmp29_) {
		ValaProperty* _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = prop;
		_tmp33_ = no_array_length;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp32_, "CCode", "array_length", !_tmp33_, NULL);
	}
	_tmp34_ = array_null_terminated;
	if (_tmp34_) {
		ValaProperty* _tmp35_;
		_tmp35_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp36_ = self->priv->current;
	_tmp37_ = prop;
	_tmp38_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp37_);
	_vala_code_node_unref0 (_tmp36_->symbol);
	_tmp36_->symbol = _tmp38_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}


static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}


static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}


static void
vala_gir_parser_parse_function (ValaGirParser* self, 
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp14_;
	gchar* _tmp15_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp16_;
	gchar* _tmp17_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp18_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp19_ = FALSE;
	ValaMarkupTokenType _tmp20_;
	ValaSymbol* s = NULL;
	const gchar* _tmp38_;
	ValaSymbol* _tmp95_;
	ValaSymbol* _tmp96_;
	ValaGirComment* _tmp97_;
	ValaSymbol* _tmp98_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp99_;
	ValaArrayType* _tmp100_;
	gboolean _tmp101_ = FALSE;
	ValaArrayType* _tmp102_;
	ValaSymbol* _tmp114_;
	ValaSymbol* _tmp128_;
	gboolean _tmp165_ = FALSE;
	ValaSymbol* _tmp166_;
	ValaGirParserMetadata* _tmp190_;
	ValaExpression* _tmp191_;
	ValaExpression* _tmp192_;
	gboolean _tmp193_;
	ValaSymbol* _tmp214_;
	gboolean _tmp224_ = FALSE;
	ValaDataType* _tmp225_;
	ValaGirParserNode* _tmp235_;
	gint _tmp236_;
	ValaGirParserNode* _tmp237_;
	ValaSymbol* _tmp238_;
	ValaSymbol* _tmp239_;
	ValaGirParserMetadata* _tmp240_;
	ValaGirParserMetadata* _tmp245_;
	gint instance_idx = 0;
	gboolean _tmp248_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp257_;
	ValaArrayList* _tmp258_;
	ValaGirParserNode* _tmp259_;
	GEqualFunc _tmp260_;
	ValaArrayList* _tmp261_;
	ValaGirParserNode* _tmp262_;
	GEqualFunc _tmp263_;
	ValaArrayList* _tmp264_;
	ValaGirParserNode* _tmp265_;
	GEqualFunc _tmp266_;
	ValaArrayList* _tmp267_;
	gboolean _tmp268_ = FALSE;
	ValaMarkupTokenType _tmp269_;
	ValaGirParserNode* _tmp365_;
	ValaArrayList* _tmp366_;
	ValaList* _tmp367_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->name;
	_tmp13_ = g_strdup (_tmp12_);
	name = _tmp13_;
	_tmp14_ = self->priv->reader;
	_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "throws");
	throws_string = _tmp15_;
	_tmp16_ = self->priv->reader;
	_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "invoker");
	invoker = _tmp17_;
	vala_gir_parser_next (self);
	_tmp18_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp18_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	_tmp20_ = self->priv->current_token;
	if (_tmp20_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = self->priv->reader;
		_tmp22_ = vala_markup_reader_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp19_ = g_strcmp0 (_tmp23_, "return-value") == 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaComment* _tmp28_ = NULL;
		ValaDataType* _tmp29_;
		ValaComment* _tmp30_;
		_tmp29_ = vala_gir_parser_parse_return_value (self, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
		_g_free0 (return_ctype);
		return_ctype = _tmp24_;
		return_array_length_idx = _tmp25_;
		return_no_array_length = _tmp26_;
		return_array_null_terminated = _tmp27_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp28_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp29_;
		_tmp30_ = return_comment;
		if (_tmp30_ != NULL) {
			ValaGirComment* _tmp31_;
			ValaGirComment* _tmp35_;
			ValaComment* _tmp36_;
			_tmp31_ = comment;
			if (_tmp31_ == NULL) {
				ValaGirParserNode* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaGirComment* _tmp34_;
				_tmp32_ = self->priv->current;
				_tmp33_ = _tmp32_->source_reference;
				_tmp34_ = vala_gir_comment_new (NULL, _tmp33_);
				_vala_comment_unref0 (comment);
				comment = _tmp34_;
			}
			_tmp35_ = comment;
			_tmp36_ = return_comment;
			vala_gir_comment_set_return_content (_tmp35_, _tmp36_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp37_;
		_tmp37_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp37_;
	}
	_tmp38_ = symbol_type;
	if (g_strcmp0 (_tmp38_, "callback") == 0) {
		const gchar* _tmp39_;
		ValaDataType* _tmp40_;
		ValaGirParserNode* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaDelegate* _tmp43_;
		ValaSymbol* _tmp44_;
		_tmp39_ = name;
		_tmp40_ = return_type;
		_tmp41_ = self->priv->current;
		_tmp42_ = _tmp41_->source_reference;
		_tmp43_ = vala_delegate_new (_tmp39_, _tmp40_, _tmp42_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp43_;
		_tmp44_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp45_;
		_tmp45_ = symbol_type;
		if (g_strcmp0 (_tmp45_, "constructor") == 0) {
			const gchar* _tmp46_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp52_;
			ValaGirParserNode* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaCreationMethod* _tmp55_;
			ValaCreationMethod* _tmp56_;
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp66_;
			ValaGirParserNode* _tmp67_;
			ValaSymbol* _tmp68_;
			gboolean _tmp72_ = FALSE;
			const gchar* _tmp73_;
			ValaCreationMethod* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp46_ = name;
			if (g_strcmp0 (_tmp46_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp47_;
				_tmp47_ = name;
				if (g_str_has_prefix (_tmp47_, "new_")) {
					const gchar* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = name;
					_tmp49_ = strlen ("new_");
					_tmp50_ = _tmp49_;
					_tmp51_ = string_substring (_tmp48_, (glong) _tmp50_, (glong) -1);
					_g_free0 (name);
					name = _tmp51_;
				}
			}
			_tmp52_ = name;
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_->source_reference;
			_tmp55_ = vala_creation_method_new (NULL, _tmp52_, _tmp54_, NULL);
			m = _tmp55_;
			_tmp56_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp56_, FALSE);
			_tmp58_ = name;
			if (_tmp58_ != NULL) {
				ValaGirParserNode* _tmp59_;
				const gchar* _tmp60_;
				_tmp59_ = self->priv->current;
				_tmp60_ = _tmp59_->name;
				_tmp57_ = !g_str_has_prefix (_tmp60_, "new_");
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCreationMethod* _tmp61_;
				ValaGirParserNode* _tmp62_;
				ValaMap* _tmp63_;
				gpointer _tmp64_;
				gchar* _tmp65_;
				_tmp61_ = m;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_->girdata;
				_tmp64_ = vala_map_get (_tmp63_, "c:identifier");
				_tmp65_ = (gchar*) _tmp64_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "CCode", "cname", _tmp65_, NULL);
				_g_free0 (_tmp65_);
			}
			parent_ctype = NULL;
			_tmp66_ = self->priv->current;
			_tmp67_ = _tmp66_->parent;
			_tmp68_ = _tmp67_->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_CLASS)) {
				ValaGirParserNode* _tmp69_;
				ValaGirParserNode* _tmp70_;
				gchar* _tmp71_;
				_tmp69_ = self->priv->current;
				_tmp70_ = _tmp69_->parent;
				_tmp71_ = vala_gir_parser_node_get_cname (_tmp70_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp71_;
			}
			_tmp73_ = return_ctype;
			if (_tmp73_ != NULL) {
				gboolean _tmp74_ = FALSE;
				const gchar* _tmp75_;
				_tmp75_ = parent_ctype;
				if (_tmp75_ == NULL) {
					_tmp74_ = TRUE;
				} else {
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp76_ = return_ctype;
					_tmp77_ = parent_ctype;
					_tmp78_ = g_strconcat (_tmp77_, "*", NULL);
					_tmp79_ = _tmp78_;
					_tmp74_ = g_strcmp0 (_tmp76_, _tmp79_) != 0;
					_g_free0 (_tmp79_);
				}
				_tmp72_ = _tmp74_;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ValaCreationMethod* _tmp80_;
				const gchar* _tmp81_;
				_tmp80_ = m;
				_tmp81_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp80_, "CCode", "type", _tmp81_, NULL);
			}
			_tmp82_ = m;
			_tmp83_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp82_);
			_vala_code_node_unref0 (s);
			s = _tmp83_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp84_;
			_tmp84_ = symbol_type;
			if (g_strcmp0 (_tmp84_, "glib:signal") == 0) {
				const gchar* _tmp85_;
				ValaDataType* _tmp86_;
				ValaGirParserNode* _tmp87_;
				ValaSourceReference* _tmp88_;
				ValaSignal* _tmp89_;
				_tmp85_ = name;
				_tmp86_ = return_type;
				_tmp87_ = self->priv->current;
				_tmp88_ = _tmp87_->source_reference;
				_tmp89_ = vala_signal_new (_tmp85_, _tmp86_, _tmp88_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp89_;
			} else {
				const gchar* _tmp90_;
				ValaDataType* _tmp91_;
				ValaGirParserNode* _tmp92_;
				ValaSourceReference* _tmp93_;
				ValaMethod* _tmp94_;
				_tmp90_ = name;
				_tmp91_ = return_type;
				_tmp92_ = self->priv->current;
				_tmp93_ = _tmp92_->source_reference;
				_tmp94_ = vala_method_new (_tmp90_, _tmp91_, _tmp93_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp94_;
			}
		}
	}
	_tmp95_ = s;
	vala_symbol_set_access (_tmp95_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp96_ = s;
	_tmp97_ = comment;
	vala_symbol_set_comment (_tmp96_, (ValaComment*) _tmp97_);
	_tmp98_ = s;
	vala_symbol_set_external (_tmp98_, TRUE);
	_tmp99_ = return_type;
	_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp99_) : NULL);
	array_type = _tmp100_;
	_tmp102_ = array_type;
	if (_tmp102_ != NULL) {
		ValaArrayType* _tmp103_;
		gboolean _tmp104_;
		gboolean _tmp105_;
		_tmp103_ = array_type;
		_tmp104_ = vala_array_type_get_fixed_length (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp101_ = _tmp105_;
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		ValaSymbol* _tmp106_;
		ValaArrayType* _tmp107_;
		ValaExpression* _tmp108_;
		ValaExpression* _tmp109_;
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		ValaArrayType* _tmp112_;
		ValaArrayType* _tmp113_;
		_tmp106_ = s;
		_tmp107_ = array_type;
		_tmp108_ = vala_array_type_get_length (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp111_ = _tmp110_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp106_, "CCode", "array_length_cexpr", _tmp111_, NULL);
		_tmp112_ = array_type;
		vala_array_type_set_fixed_length (_tmp112_, FALSE);
		_tmp113_ = array_type;
		vala_array_type_set_length (_tmp113_, NULL);
	}
	_tmp114_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_SIGNAL)) {
		ValaGirParserNode* _tmp115_;
		ValaMap* _tmp116_;
		gpointer _tmp117_;
		gchar* _tmp118_;
		const gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gboolean _tmp122_;
		_tmp115_ = self->priv->current;
		_tmp116_ = _tmp115_->girdata;
		_tmp117_ = vala_map_get (_tmp116_, "name");
		_tmp118_ = (gchar*) _tmp117_;
		_tmp119_ = name;
		_tmp120_ = string_replace (_tmp119_, "_", "-");
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strcmp0 (_tmp118_, _tmp121_) != 0;
		_g_free0 (_tmp121_);
		_g_free0 (_tmp118_);
		if (_tmp122_) {
			ValaSymbol* _tmp123_;
			ValaGirParserNode* _tmp124_;
			ValaMap* _tmp125_;
			gpointer _tmp126_;
			gchar* _tmp127_;
			_tmp123_ = s;
			_tmp124_ = self->priv->current;
			_tmp125_ = _tmp124_->girdata;
			_tmp126_ = vala_map_get (_tmp125_, "name");
			_tmp127_ = (gchar*) _tmp126_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp123_, "CCode", "cname", _tmp127_, NULL);
			_g_free0 (_tmp127_);
		}
	}
	_tmp128_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp129_;
		ValaMethod* _tmp130_;
		gboolean _tmp131_ = FALSE;
		const gchar* _tmp132_;
		ValaGirParserMetadata* _tmp159_;
		_tmp129_ = s;
		_tmp130_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp130_;
		_tmp132_ = symbol_type;
		if (g_strcmp0 (_tmp132_, "virtual-method") == 0) {
			_tmp131_ = TRUE;
		} else {
			const gchar* _tmp133_;
			_tmp133_ = symbol_type;
			_tmp131_ = g_strcmp0 (_tmp133_, "callback") == 0;
		}
		if (_tmp131_) {
			ValaGirParserNode* _tmp134_;
			ValaGirParserNode* _tmp135_;
			ValaSymbol* _tmp136_;
			gboolean _tmp139_ = FALSE;
			const gchar* _tmp140_;
			ValaGirParserNode* _tmp146_;
			ValaMap* _tmp147_;
			gpointer _tmp148_;
			gchar* _tmp149_;
			const gchar* _tmp150_;
			gboolean _tmp151_;
			_tmp134_ = self->priv->current;
			_tmp135_ = _tmp134_->parent;
			_tmp136_ = _tmp135_->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp136_, VALA_TYPE_INTERFACE)) {
				ValaMethod* _tmp137_;
				_tmp137_ = m;
				vala_method_set_is_abstract (_tmp137_, TRUE);
			} else {
				ValaMethod* _tmp138_;
				_tmp138_ = m;
				vala_method_set_is_virtual (_tmp138_, TRUE);
			}
			_tmp140_ = invoker;
			if (_tmp140_ == NULL) {
				ValaGirParserMetadata* _tmp141_;
				_tmp141_ = self->priv->metadata;
				_tmp139_ = !vala_gir_parser_metadata_has_argument (_tmp141_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			} else {
				_tmp139_ = FALSE;
			}
			if (_tmp139_) {
				ValaSymbol* _tmp142_;
				ValaSymbol* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				_tmp142_ = s;
				_tmp143_ = s;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp143_);
				_tmp145_ = _tmp144_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp142_, "NoWrapper", TRUE, _tmp145_);
			}
			_tmp146_ = self->priv->current;
			_tmp147_ = _tmp146_->girdata;
			_tmp148_ = vala_map_get (_tmp147_, "name");
			_tmp149_ = (gchar*) _tmp148_;
			_tmp150_ = name;
			_tmp151_ = g_strcmp0 (_tmp149_, _tmp150_) != 0;
			_g_free0 (_tmp149_);
			if (_tmp151_) {
				ValaMethod* _tmp152_;
				ValaGirParserNode* _tmp153_;
				ValaMap* _tmp154_;
				gpointer _tmp155_;
				gchar* _tmp156_;
				_tmp152_ = m;
				_tmp153_ = self->priv->current;
				_tmp154_ = _tmp153_->girdata;
				_tmp155_ = vala_map_get (_tmp154_, "name");
				_tmp156_ = (gchar*) _tmp155_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp152_, "CCode", "vfunc_name", _tmp156_, NULL);
				_g_free0 (_tmp156_);
			}
		} else {
			const gchar* _tmp157_;
			_tmp157_ = symbol_type;
			if (g_strcmp0 (_tmp157_, "function") == 0) {
				ValaMethod* _tmp158_;
				_tmp158_ = m;
				vala_method_set_binding (_tmp158_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp159_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp159_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp160_;
			ValaGirParserMetadata* _tmp161_;
			ValaMethod* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			_tmp160_ = m;
			_tmp161_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp160_, vala_gir_parser_metadata_get_bool (_tmp161_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp162_ = m;
			_tmp163_ = vala_callable_get_return_type ((ValaCallable*) _tmp162_);
			_tmp164_ = _tmp163_;
			vala_data_type_set_value_owned (_tmp164_, TRUE);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp166_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_METHOD)) {
		ValaSymbol* _tmp167_;
		_tmp167_ = s;
		_tmp165_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp167_, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp165_ = FALSE;
	}
	if (_tmp165_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp168_;
		ValaMethod* _tmp169_;
		ValaGirParserMetadata* _tmp170_;
		ValaGirParserMetadata* _tmp178_;
		ValaGirParserMetadata* _tmp184_;
		_tmp168_ = s;
		_tmp169_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp169_;
		_tmp170_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp170_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp171_;
			ValaGirParserMetadata* _tmp172_;
			ValaMethod* _tmp173_;
			_tmp171_ = method;
			_tmp172_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp171_, vala_gir_parser_metadata_get_bool (_tmp172_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp173_ = method;
			vala_method_set_is_abstract (_tmp173_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp174_;
			_tmp174_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp175_;
				ValaGirParserMetadata* _tmp176_;
				ValaMethod* _tmp177_;
				_tmp175_ = method;
				_tmp176_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp175_, vala_gir_parser_metadata_get_bool (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp177_ = method;
				vala_method_set_is_virtual (_tmp177_, FALSE);
			}
		}
		_tmp178_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp178_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp179_;
			ValaGirParserMetadata* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			ValaMethod* _tmp183_;
			_tmp179_ = method;
			_tmp180_ = self->priv->metadata;
			_tmp181_ = vala_gir_parser_metadata_get_string (_tmp180_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp182_ = _tmp181_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp179_, "CCode", "vfunc_name", _tmp182_, NULL);
			_g_free0 (_tmp182_);
			_tmp183_ = method;
			vala_method_set_is_virtual (_tmp183_, TRUE);
		}
		_tmp184_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp184_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp185_;
			ValaGirParserMetadata* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			ValaMethod* _tmp189_;
			_tmp185_ = method;
			_tmp186_ = self->priv->metadata;
			_tmp187_ = vala_gir_parser_metadata_get_string (_tmp186_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp188_ = _tmp187_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp185_, "CCode", "finish_vfunc_name", _tmp188_, NULL);
			_g_free0 (_tmp188_);
			_tmp189_ = method;
			vala_method_set_is_virtual (_tmp189_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp190_ = self->priv->metadata;
	_tmp191_ = vala_gir_parser_metadata_get_expression (_tmp190_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp192_ = _tmp191_;
	_tmp193_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_NULL_LITERAL);
	_vala_code_node_unref0 (_tmp192_);
	if (_tmp193_) {
		ValaGirParserMetadata* _tmp194_;
		_tmp194_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp194_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp195_;
			gchar* _tmp196_;
			gchar* _tmp197_;
			gchar** _tmp198_;
			gchar** _tmp199_;
			gchar** _tmp200_;
			gint _tmp200__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp201_;
			gint _tmp201__length1;
			_tmp195_ = self->priv->metadata;
			_tmp196_ = vala_gir_parser_metadata_get_string (_tmp195_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp197_ = _tmp196_;
			_tmp199_ = _tmp198_ = g_strsplit (_tmp197_, ",", 0);
			_tmp200_ = _tmp199_;
			_tmp200__length1 = _vala_array_length (_tmp198_);
			_g_free0 (_tmp197_);
			error_types = _tmp200_;
			error_types_length1 = _tmp200__length1;
			_error_types_size_ = error_types_length1;
			_tmp201_ = error_types;
			_tmp201__length1 = error_types_length1;
			{
				gchar** error_type_collection = NULL;
				gint error_type_collection_length1 = 0;
				gint _error_type_collection_size_ = 0;
				gint error_type_it = 0;
				error_type_collection = _tmp201_;
				error_type_collection_length1 = _tmp201__length1;
				for (error_type_it = 0; error_type_it < _tmp201__length1; error_type_it = error_type_it + 1) {
					gchar* _tmp202_;
					gchar* error_type = NULL;
					_tmp202_ = g_strdup (error_type_collection[error_type_it]);
					error_type = _tmp202_;
					{
						ValaSymbol* _tmp203_;
						const gchar* _tmp204_;
						ValaGirParserMetadata* _tmp205_;
						ValaSourceReference* _tmp206_;
						ValaSourceReference* _tmp207_;
						ValaDataType* _tmp208_;
						ValaDataType* _tmp209_;
						_tmp203_ = s;
						_tmp204_ = error_type;
						_tmp205_ = self->priv->metadata;
						_tmp206_ = vala_gir_parser_metadata_get_source_reference (_tmp205_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp207_ = _tmp206_;
						_tmp208_ = vala_gir_parser_parse_type_from_string (self, _tmp204_, TRUE, _tmp207_);
						_tmp209_ = _tmp208_;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp203_, _tmp209_);
						_vala_code_node_unref0 (_tmp209_);
						_vala_source_reference_unref0 (_tmp207_);
						_g_free0 (error_type);
					}
				}
			}
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp210_;
			_tmp210_ = throws_string;
			if (g_strcmp0 (_tmp210_, "1") == 0) {
				ValaSymbol* _tmp211_;
				ValaErrorType* _tmp212_;
				ValaErrorType* _tmp213_;
				_tmp211_ = s;
				_tmp212_ = vala_error_type_new (NULL, NULL, NULL);
				_tmp213_ = _tmp212_;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp211_, (ValaDataType*) _tmp213_);
				_vala_code_node_unref0 (_tmp213_);
			}
		}
	}
	_tmp214_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp215_;
		ValaMethod* _tmp216_;
		ValaMethod* _tmp217_;
		ValaGirParserMetadata* _tmp218_;
		ValaGirParserMetadata* _tmp219_;
		_tmp215_ = s;
		_tmp216_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp215_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp216_;
		_tmp217_ = m;
		_tmp218_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp217_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp218_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp219_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp219_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp220_;
			ValaGirParserMetadata* _tmp221_;
			gchar* _tmp222_;
			gchar* _tmp223_;
			_tmp220_ = m;
			_tmp221_ = self->priv->metadata;
			_tmp222_ = vala_gir_parser_metadata_get_string (_tmp221_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp223_ = _tmp222_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp220_, "CCode", "sentinel", _tmp223_, NULL);
			_g_free0 (_tmp223_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp225_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp225_, VALA_TYPE_ARRAY_TYPE)) {
		ValaGirParserMetadata* _tmp226_;
		_tmp226_ = self->priv->metadata;
		_tmp224_ = vala_gir_parser_metadata_has_argument (_tmp226_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp224_ = FALSE;
	}
	if (_tmp224_) {
		ValaGirParserMetadata* _tmp227_;
		_tmp227_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp227_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_;
		gboolean _tmp233_;
		_tmp229_ = return_no_array_length;
		if (_tmp229_) {
			_tmp228_ = TRUE;
		} else {
			gboolean _tmp230_;
			_tmp230_ = return_array_null_terminated;
			_tmp228_ = _tmp230_;
		}
		if (_tmp228_) {
			ValaSymbol* _tmp231_;
			gboolean _tmp232_;
			_tmp231_ = s;
			_tmp232_ = return_no_array_length;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp231_, "CCode", "array_length", !_tmp232_, NULL);
		}
		_tmp233_ = return_array_null_terminated;
		if (_tmp233_) {
			ValaSymbol* _tmp234_;
			_tmp234_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp234_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp235_ = self->priv->current;
	_tmp236_ = return_array_length_idx;
	_tmp235_->return_array_length_idx = _tmp236_;
	_tmp237_ = self->priv->current;
	_tmp238_ = s;
	_tmp239_ = _vala_code_node_ref0 (_tmp238_);
	_vala_code_node_unref0 (_tmp237_->symbol);
	_tmp237_->symbol = _tmp239_;
	_tmp240_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp240_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp241_;
		ValaGirParserMetadata* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		_tmp241_ = s;
		_tmp242_ = self->priv->metadata;
		_tmp243_ = vala_gir_parser_metadata_get_string (_tmp242_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp244_ = _tmp243_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp241_, "CCode", "finish_name", _tmp244_, NULL);
		_g_free0 (_tmp244_);
	}
	_tmp245_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp245_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp246_;
		ValaGirParserMetadata* _tmp247_;
		_tmp246_ = s;
		_tmp247_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp246_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp247_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp249_;
		_tmp249_ = symbol_type;
		_tmp248_ = g_strcmp0 (_tmp249_, "method") == 0;
	} else {
		_tmp248_ = FALSE;
	}
	if (_tmp248_) {
		ValaGirParserMetadata* _tmp250_;
		_tmp250_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp250_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp251_;
			gint _tmp252_;
			_tmp251_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp251_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			_tmp252_ = instance_idx;
			if (_tmp252_ != 0) {
				ValaSymbol* _tmp253_;
				gint _tmp254_;
				_tmp253_ = s;
				_tmp254_ = instance_idx;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp253_, "CCode", "instance_pos", _tmp254_ + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp255_;
			ValaSourceReference* _tmp256_;
			_tmp255_ = vala_gir_parser_get_current_src (self);
			_tmp256_ = _tmp255_;
			vala_report_error (_tmp256_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp256_);
		}
	}
	_tmp257_ = g_direct_equal;
	_tmp258_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp257_);
	parameters = _tmp258_;
	_tmp259_ = self->priv->current;
	_tmp260_ = g_direct_equal;
	_tmp261_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp260_);
	_vala_iterable_unref0 (_tmp259_->array_length_parameters);
	_tmp259_->array_length_parameters = _tmp261_;
	_tmp262_ = self->priv->current;
	_tmp263_ = g_direct_equal;
	_tmp264_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp263_);
	_vala_iterable_unref0 (_tmp262_->closure_parameters);
	_tmp262_->closure_parameters = _tmp264_;
	_tmp265_ = self->priv->current;
	_tmp266_ = g_direct_equal;
	_tmp267_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp266_);
	_vala_iterable_unref0 (_tmp265_->destroy_parameters);
	_tmp265_->destroy_parameters = _tmp267_;
	_tmp269_ = self->priv->current_token;
	if (_tmp269_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp270_;
		const gchar* _tmp271_;
		const gchar* _tmp272_;
		_tmp270_ = self->priv->reader;
		_tmp271_ = vala_markup_reader_get_name (_tmp270_);
		_tmp272_ = _tmp271_;
		_tmp268_ = g_strcmp0 (_tmp272_, "parameters") == 0;
	} else {
		_tmp268_ = FALSE;
	}
	if (_tmp268_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			ValaMarkupTokenType _tmp273_;
			gint _tmp274_;
			gboolean _tmp275_ = FALSE;
			ValaMarkupReader* _tmp276_;
			const gchar* _tmp277_;
			const gchar* _tmp278_;
			gboolean _tmp282_ = FALSE;
			gint _tmp283_;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp286_;
			gint _tmp287_;
			gint _tmp288_;
			gchar* _tmp289_;
			ValaParameter* param = NULL;
			const gchar* _tmp290_;
			gint _tmp291_ = 0;
			gint _tmp292_ = 0;
			gint _tmp293_ = 0;
			gchar* _tmp294_ = NULL;
			ValaComment* _tmp295_ = NULL;
			ValaParameter* _tmp296_;
			gint _tmp297_;
			gint _tmp306_;
			gint _tmp315_;
			ValaComment* _tmp324_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp341_;
			gint _tmp342_;
			gint _tmp343_;
			gint _tmp344_;
			const gchar* _tmp345_;
			ValaGirParserParameterInfo* _tmp346_;
			gboolean _tmp347_ = FALSE;
			ValaSymbol* _tmp348_;
			ValaArrayList* _tmp363_;
			ValaGirParserParameterInfo* _tmp364_;
			_tmp273_ = self->priv->current_token;
			if (!(_tmp273_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp274_ = current_parameter_idx;
			current_parameter_idx = _tmp274_ + 1;
			_tmp276_ = self->priv->reader;
			_tmp277_ = vala_markup_reader_get_name (_tmp276_);
			_tmp278_ = _tmp277_;
			if (g_strcmp0 (_tmp278_, "instance-parameter") == 0) {
				gboolean _tmp279_ = FALSE;
				const gchar* _tmp280_;
				_tmp280_ = symbol_type;
				if (g_strcmp0 (_tmp280_, "function") == 0) {
					_tmp279_ = TRUE;
				} else {
					const gchar* _tmp281_;
					_tmp281_ = symbol_type;
					_tmp279_ = g_strcmp0 (_tmp281_, "constructor") == 0;
				}
				_tmp275_ = !_tmp279_;
			} else {
				_tmp275_ = FALSE;
			}
			if (_tmp275_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp283_ = instance_idx;
			if (_tmp283_ > -2) {
				gint _tmp284_;
				gint _tmp285_;
				_tmp284_ = instance_idx;
				_tmp285_ = current_parameter_idx;
				_tmp282_ = _tmp284_ == _tmp285_;
			} else {
				_tmp282_ = FALSE;
			}
			if (_tmp282_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp286_ = parameters;
			_tmp287_ = vala_collection_get_size ((ValaCollection*) _tmp286_);
			_tmp288_ = _tmp287_;
			_tmp289_ = g_strdup_printf ("arg%d", _tmp288_);
			_g_free0 (default_param_name);
			default_param_name = _tmp289_;
			_tmp290_ = default_param_name;
			_tmp296_ = vala_gir_parser_parse_parameter (self, &_tmp291_, &_tmp292_, &_tmp293_, &_tmp294_, &_tmp295_, _tmp290_);
			array_length_idx = _tmp291_;
			closure_idx = _tmp292_;
			destroy_idx = _tmp293_;
			_g_free0 (scope);
			scope = _tmp294_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp295_;
			param = _tmp296_;
			_tmp297_ = array_length_idx;
			if (_tmp297_ != -1) {
				gboolean _tmp298_ = FALSE;
				gint _tmp299_;
				ValaGirParserNode* _tmp303_;
				ValaArrayList* _tmp304_;
				gint _tmp305_;
				_tmp299_ = instance_idx;
				if (_tmp299_ > -2) {
					gint _tmp300_;
					gint _tmp301_;
					_tmp300_ = instance_idx;
					_tmp301_ = array_length_idx;
					_tmp298_ = _tmp300_ < _tmp301_;
				} else {
					_tmp298_ = FALSE;
				}
				if (_tmp298_) {
					gint _tmp302_;
					_tmp302_ = array_length_idx;
					array_length_idx = _tmp302_ - 1;
				}
				_tmp303_ = self->priv->current;
				_tmp304_ = _tmp303_->array_length_parameters;
				_tmp305_ = array_length_idx;
				vala_collection_add ((ValaCollection*) _tmp304_, (gpointer) ((gintptr) _tmp305_));
			}
			_tmp306_ = closure_idx;
			if (_tmp306_ != -1) {
				gboolean _tmp307_ = FALSE;
				gint _tmp308_;
				ValaGirParserNode* _tmp312_;
				ValaArrayList* _tmp313_;
				gint _tmp314_;
				_tmp308_ = instance_idx;
				if (_tmp308_ > -2) {
					gint _tmp309_;
					gint _tmp310_;
					_tmp309_ = instance_idx;
					_tmp310_ = closure_idx;
					_tmp307_ = _tmp309_ < _tmp310_;
				} else {
					_tmp307_ = FALSE;
				}
				if (_tmp307_) {
					gint _tmp311_;
					_tmp311_ = closure_idx;
					closure_idx = _tmp311_ - 1;
				}
				_tmp312_ = self->priv->current;
				_tmp313_ = _tmp312_->closure_parameters;
				_tmp314_ = closure_idx;
				vala_collection_add ((ValaCollection*) _tmp313_, (gpointer) ((gintptr) _tmp314_));
			}
			_tmp315_ = destroy_idx;
			if (_tmp315_ != -1) {
				gboolean _tmp316_ = FALSE;
				gint _tmp317_;
				ValaGirParserNode* _tmp321_;
				ValaArrayList* _tmp322_;
				gint _tmp323_;
				_tmp317_ = instance_idx;
				if (_tmp317_ > -2) {
					gint _tmp318_;
					gint _tmp319_;
					_tmp318_ = instance_idx;
					_tmp319_ = destroy_idx;
					_tmp316_ = _tmp318_ < _tmp319_;
				} else {
					_tmp316_ = FALSE;
				}
				if (_tmp316_) {
					gint _tmp320_;
					_tmp320_ = destroy_idx;
					destroy_idx = _tmp320_ - 1;
				}
				_tmp321_ = self->priv->current;
				_tmp322_ = _tmp321_->destroy_parameters;
				_tmp323_ = destroy_idx;
				vala_collection_add ((ValaCollection*) _tmp322_, (gpointer) ((gintptr) _tmp323_));
			}
			_tmp324_ = param_comment;
			if (_tmp324_ != NULL) {
				ValaGirComment* _tmp325_;
				const gchar* _tmp332_ = NULL;
				ValaParameter* _tmp333_;
				gboolean _tmp334_;
				gboolean _tmp335_;
				ValaGirComment* _tmp339_;
				ValaComment* _tmp340_;
				_tmp325_ = comment;
				if (_tmp325_ == NULL) {
					ValaSymbol* _tmp326_;
					ValaSourceReference* _tmp327_;
					ValaSourceReference* _tmp328_;
					ValaGirComment* _tmp329_;
					ValaSymbol* _tmp330_;
					ValaGirComment* _tmp331_;
					_tmp326_ = s;
					_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp326_);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_gir_comment_new (NULL, _tmp328_);
					_vala_comment_unref0 (comment);
					comment = _tmp329_;
					_tmp330_ = s;
					_tmp331_ = comment;
					vala_symbol_set_comment (_tmp330_, (ValaComment*) _tmp331_);
				}
				_tmp333_ = param;
				_tmp334_ = vala_parameter_get_ellipsis (_tmp333_);
				_tmp335_ = _tmp334_;
				if (_tmp335_) {
					_tmp332_ = "...";
				} else {
					ValaParameter* _tmp336_;
					const gchar* _tmp337_;
					const gchar* _tmp338_;
					_tmp336_ = param;
					_tmp337_ = vala_symbol_get_name ((ValaSymbol*) _tmp336_);
					_tmp338_ = _tmp337_;
					_tmp332_ = _tmp338_;
				}
				_tmp339_ = comment;
				_tmp340_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp339_, _tmp332_, _tmp340_);
			}
			_tmp341_ = param;
			_tmp342_ = array_length_idx;
			_tmp343_ = closure_idx;
			_tmp344_ = destroy_idx;
			_tmp345_ = scope;
			_tmp346_ = vala_gir_parser_parameter_info_new (_tmp341_, _tmp342_, _tmp343_, _tmp344_, g_strcmp0 (_tmp345_, "async") == 0);
			info = _tmp346_;
			_tmp348_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp348_, VALA_TYPE_METHOD)) {
				const gchar* _tmp349_;
				_tmp349_ = scope;
				_tmp347_ = g_strcmp0 (_tmp349_, "async") == 0;
			} else {
				_tmp347_ = FALSE;
			}
			if (_tmp347_) {
				ValaUnresolvedType* unresolved_type = NULL;
				ValaParameter* _tmp350_;
				ValaDataType* _tmp351_;
				ValaDataType* _tmp352_;
				ValaUnresolvedType* _tmp353_;
				gboolean _tmp354_ = FALSE;
				ValaUnresolvedType* _tmp355_;
				_tmp350_ = param;
				_tmp351_ = vala_variable_get_variable_type ((ValaVariable*) _tmp350_);
				_tmp352_ = _tmp351_;
				_tmp353_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp352_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp352_) : NULL);
				unresolved_type = _tmp353_;
				_tmp355_ = unresolved_type;
				if (_tmp355_ != NULL) {
					ValaUnresolvedType* _tmp356_;
					ValaUnresolvedSymbol* _tmp357_;
					ValaUnresolvedSymbol* _tmp358_;
					const gchar* _tmp359_;
					const gchar* _tmp360_;
					_tmp356_ = unresolved_type;
					_tmp357_ = vala_unresolved_type_get_unresolved_symbol (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_symbol_get_name ((ValaSymbol*) _tmp358_);
					_tmp360_ = _tmp359_;
					_tmp354_ = g_strcmp0 (_tmp360_, "AsyncReadyCallback") == 0;
				} else {
					_tmp354_ = FALSE;
				}
				if (_tmp354_) {
					ValaSymbol* _tmp361_;
					ValaGirParserParameterInfo* _tmp362_;
					_tmp361_ = s;
					vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_METHOD, ValaMethod), TRUE);
					_tmp362_ = info;
					_tmp362_->keep = FALSE;
				}
				_vala_code_node_unref0 (unresolved_type);
			}
			_tmp363_ = parameters;
			_tmp364_ = info;
			vala_collection_add ((ValaCollection*) _tmp363_, _tmp364_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp365_ = self->priv->current;
	_tmp366_ = parameters;
	_tmp367_ = _vala_iterable_ref0 ((ValaList*) _tmp366_);
	_vala_iterable_unref0 (_tmp365_->parameters);
	_tmp365_->parameters = _tmp367_;
	{
		gint param_n = 0;
		ValaArrayList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		_tmp368_ = parameters;
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		param_n = _tmp370_ - 1;
		{
			gboolean _tmp371_ = FALSE;
			_tmp371_ = TRUE;
			while (TRUE) {
				gint _tmp373_;
				ValaGirParserParameterInfo* pi = NULL;
				ValaArrayList* _tmp374_;
				gint _tmp375_;
				gpointer _tmp376_;
				gboolean _tmp377_ = FALSE;
				ValaGirParserParameterInfo* _tmp378_;
				ValaParameter* _tmp379_;
				gboolean _tmp380_;
				gboolean _tmp381_;
				if (!_tmp371_) {
					gint _tmp372_;
					_tmp372_ = param_n;
					param_n = _tmp372_ - 1;
				}
				_tmp371_ = FALSE;
				_tmp373_ = param_n;
				if (!(_tmp373_ >= 0)) {
					break;
				}
				_tmp374_ = parameters;
				_tmp375_ = param_n;
				_tmp376_ = vala_list_get ((ValaList*) _tmp374_, _tmp375_);
				pi = (ValaGirParserParameterInfo*) _tmp376_;
				_tmp378_ = pi;
				_tmp379_ = _tmp378_->param;
				_tmp380_ = vala_parameter_get_ellipsis (_tmp379_);
				_tmp381_ = _tmp380_;
				if (!_tmp381_) {
					ValaGirParserParameterInfo* _tmp382_;
					ValaParameter* _tmp383_;
					ValaExpression* _tmp384_;
					ValaExpression* _tmp385_;
					_tmp382_ = pi;
					_tmp383_ = _tmp382_->param;
					_tmp384_ = vala_variable_get_initializer ((ValaVariable*) _tmp383_);
					_tmp385_ = _tmp384_;
					_tmp377_ = _tmp385_ == NULL;
				} else {
					_tmp377_ = FALSE;
				}
				if (_tmp377_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp386_;
					ValaParameter* _tmp387_;
					ValaDataType* _tmp388_;
					ValaDataType* _tmp389_;
					gchar* _tmp390_;
					const gchar* _tmp391_;
					_tmp386_ = pi;
					_tmp387_ = _tmp386_->param;
					_tmp388_ = vala_variable_get_variable_type ((ValaVariable*) _tmp387_);
					_tmp389_ = _tmp388_;
					_tmp390_ = vala_code_node_to_string ((ValaCodeNode*) _tmp389_);
					type_string = _tmp390_;
					_tmp391_ = type_string;
					if (g_strcmp0 (_tmp391_, "Gio.Cancellable?") == 0) {
						ValaGirParserParameterInfo* _tmp392_;
						ValaParameter* _tmp393_;
						ValaNullLiteral* _tmp394_;
						ValaNullLiteral* _tmp395_;
						_tmp392_ = pi;
						_tmp393_ = _tmp392_->param;
						_tmp394_ = vala_null_literal_new (NULL);
						_tmp395_ = _tmp394_;
						vala_variable_set_initializer ((ValaVariable*) _tmp393_, (ValaExpression*) _tmp395_);
						_vala_code_node_unref0 (_tmp395_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (pi);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (pi);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (symbol_type);
}


static void
vala_gir_parser_parse_method (ValaGirParser* self, 
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}


static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}


static void
vala_gir_parser_parse_boxed (ValaGirParser* self, 
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	gboolean _tmp9_;
	ValaClass* _tmp22_;
	ValaClass* _tmp23_;
	ValaClass* _tmp24_;
	ValaClass* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	ValaClass* _tmp36_;
	ValaGirComment* _tmp37_;
	ValaGirComment* _tmp38_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	ValaClass* _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = _tmp8_->new_symbol;
	if (_tmp9_) {
		ValaGirParserNode* _tmp10_;
		const gchar* _tmp11_;
		ValaGirParserNode* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaClass* _tmp14_;
		ValaClass* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaClass* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp10_ = self->priv->current;
		_tmp11_ = _tmp10_->name;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->source_reference;
		_tmp14_ = vala_class_new (_tmp11_, _tmp13_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp14_;
		_tmp15_ = cl;
		vala_class_set_is_compact (_tmp15_, TRUE);
		_tmp16_ = self->priv->current;
		_tmp17_ = cl;
		_tmp18_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaClass* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp21_;
	}
	_tmp22_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp23_, "CCode", "type_id");
	_tmp24_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp25_, TRUE);
	_tmp26_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp27_;
		ValaGirParserMetadata* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		ValaGirParserMetadata* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp27_ = cl;
		_tmp28_ = self->priv->metadata;
		_tmp29_ = vala_gir_parser_metadata_get_string (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->metadata;
		_tmp32_ = vala_gir_parser_metadata_get_source_reference (_tmp31_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_gir_parser_parse_type_from_string (self, _tmp30_, TRUE, _tmp33_);
		_tmp35_ = _tmp34_;
		vala_class_add_base_type (_tmp27_, _tmp35_);
		_vala_code_node_unref0 (_tmp35_);
		_vala_source_reference_unref0 (_tmp33_);
		_g_free0 (_tmp30_);
	}
	vala_gir_parser_next (self);
	_tmp36_ = cl;
	_tmp37_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp38_ = _tmp37_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp36_, (ValaComment*) _tmp38_);
	_vala_comment_unref0 (_tmp38_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp39_;
		ValaMarkupReader* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp39_ = self->priv->current_token;
		if (!(_tmp39_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp40_ = self->priv->reader;
		_tmp41_ = vala_markup_reader_get_name (_tmp40_);
		_tmp42_ = _tmp41_;
		if (g_strcmp0 (_tmp42_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			_tmp43_ = self->priv->reader;
			_tmp44_ = vala_markup_reader_get_name (_tmp43_);
			_tmp45_ = _tmp44_;
			if (g_strcmp0 (_tmp45_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp46_ = self->priv->reader;
				_tmp47_ = vala_markup_reader_get_name (_tmp46_);
				_tmp48_ = _tmp47_;
				if (g_strcmp0 (_tmp48_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp49_;
					gchar* _tmp50_;
					gboolean _tmp51_ = FALSE;
					const gchar* _tmp52_;
					vala_gir_parser_parse_method (self, "method");
					_tmp49_ = self->priv->old_current;
					_tmp50_ = vala_gir_parser_node_get_cname (_tmp49_);
					cname = _tmp50_;
					_tmp52_ = cname;
					if (g_str_has_suffix (_tmp52_, "_ref")) {
						gboolean _tmp53_ = FALSE;
						ValaGirParserNode* _tmp54_;
						_tmp54_ = ref_method;
						if (_tmp54_ == NULL) {
							_tmp53_ = TRUE;
						} else {
							ValaGirParserNode* _tmp55_;
							const gchar* _tmp56_;
							_tmp55_ = self->priv->old_current;
							_tmp56_ = _tmp55_->name;
							_tmp53_ = g_strcmp0 (_tmp56_, "ref") == 0;
						}
						_tmp51_ = _tmp53_;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						ValaGirParserNode* _tmp57_;
						ValaGirParserNode* _tmp58_;
						_tmp57_ = self->priv->old_current;
						_tmp58_ = _vala_gir_parser_node_ref0 (_tmp57_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp58_;
					} else {
						gboolean _tmp59_ = FALSE;
						const gchar* _tmp60_;
						_tmp60_ = cname;
						if (g_str_has_suffix (_tmp60_, "_unref")) {
							gboolean _tmp61_ = FALSE;
							ValaGirParserNode* _tmp62_;
							_tmp62_ = unref_method;
							if (_tmp62_ == NULL) {
								_tmp61_ = TRUE;
							} else {
								ValaGirParserNode* _tmp63_;
								const gchar* _tmp64_;
								_tmp63_ = self->priv->old_current;
								_tmp64_ = _tmp63_->name;
								_tmp61_ = g_strcmp0 (_tmp64_, "unref") == 0;
							}
							_tmp59_ = _tmp61_;
						} else {
							_tmp59_ = FALSE;
						}
						if (_tmp59_) {
							ValaGirParserNode* _tmp65_;
							ValaGirParserNode* _tmp66_;
							_tmp65_ = self->priv->old_current;
							_tmp66_ = _vala_gir_parser_node_ref0 (_tmp65_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp66_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp67_;
					const gchar* _tmp68_;
					const gchar* _tmp69_;
					_tmp67_ = self->priv->reader;
					_tmp68_ = vala_markup_reader_get_name (_tmp67_);
					_tmp69_ = _tmp68_;
					if (g_strcmp0 (_tmp69_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp70_;
						const gchar* _tmp71_;
						const gchar* _tmp72_;
						_tmp70_ = self->priv->reader;
						_tmp71_ = vala_markup_reader_get_name (_tmp70_);
						_tmp72_ = _tmp71_;
						if (g_strcmp0 (_tmp72_, "union") == 0) {
							vala_gir_parser_parse_union (self);
						} else {
							ValaSourceReference* _tmp73_;
							ValaSourceReference* _tmp74_;
							ValaMarkupReader* _tmp75_;
							const gchar* _tmp76_;
							const gchar* _tmp77_;
							gchar* _tmp78_;
							gchar* _tmp79_;
							_tmp73_ = vala_gir_parser_get_current_src (self);
							_tmp74_ = _tmp73_;
							_tmp75_ = self->priv->reader;
							_tmp76_ = vala_markup_reader_get_name (_tmp75_);
							_tmp77_ = _tmp76_;
							_tmp78_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp77_);
							_tmp79_ = _tmp78_;
							vala_report_error (_tmp74_, _tmp79_);
							_g_free0 (_tmp79_);
							_vala_source_reference_unref0 (_tmp74_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp83_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp83_, "CCode", "ref_function")) {
		_tmp82_ = TRUE;
	} else {
		ValaClass* _tmp84_;
		_tmp84_ = cl;
		_tmp82_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp84_, "CCode", "unref_function");
	}
	if (_tmp82_) {
		_tmp81_ = TRUE;
	} else {
		ValaClass* _tmp85_;
		_tmp85_ = cl;
		_tmp81_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp85_, "CCode", "copy_function");
	}
	if (_tmp81_) {
		_tmp80_ = TRUE;
	} else {
		ValaClass* _tmp86_;
		_tmp86_ = cl;
		_tmp80_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp86_, "CCode", "free_function");
	}
	if (_tmp80_) {
	} else {
		gboolean _tmp87_ = FALSE;
		ValaGirParserNode* _tmp88_;
		_tmp88_ = ref_method;
		if (_tmp88_ != NULL) {
			ValaGirParserNode* _tmp89_;
			_tmp89_ = unref_method;
			_tmp87_ = _tmp89_ != NULL;
		} else {
			_tmp87_ = FALSE;
		}
		if (_tmp87_) {
			ValaClass* _tmp90_;
			ValaGirParserNode* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			ValaClass* _tmp94_;
			ValaGirParserNode* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp90_ = cl;
			_tmp91_ = ref_method;
			_tmp92_ = vala_gir_parser_node_get_cname (_tmp91_);
			_tmp93_ = _tmp92_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp90_, "CCode", "ref_function", _tmp93_, NULL);
			_g_free0 (_tmp93_);
			_tmp94_ = cl;
			_tmp95_ = unref_method;
			_tmp96_ = vala_gir_parser_node_get_cname (_tmp95_);
			_tmp97_ = _tmp96_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp94_, "CCode", "unref_function", _tmp97_, NULL);
			_g_free0 (_tmp97_);
		} else {
			gboolean _tmp98_;
			_tmp98_ = require_copy_free;
			if (_tmp98_) {
				ValaClass* _tmp99_;
				ValaClass* _tmp100_;
				_tmp99_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp99_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp100_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp100_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}


static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp13_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp14_;
	gboolean _tmp15_;
	ValaStruct* _tmp28_;
	ValaStruct* _tmp29_;
	ValaStruct* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		vala_gir_parser_next (self);
		while (TRUE) {
			ValaMarkupTokenType _tmp2_;
			ValaMarkupReader* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp2_ = self->priv->current_token;
			if (!(_tmp2_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp3_ = self->priv->reader;
			_tmp4_ = vala_markup_reader_get_name (_tmp3_);
			_tmp5_ = _tmp4_;
			if (g_strcmp0 (_tmp5_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaSourceReference* _tmp6_;
				ValaSourceReference* _tmp7_;
				ValaMarkupReader* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp6_ = vala_gir_parser_get_current_src (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->reader;
				_tmp9_ = vala_markup_reader_get_name (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("unknown child element `%s' in `transparent union'", _tmp10_);
				_tmp12_ = _tmp11_;
				vala_report_error (_tmp7_, _tmp12_);
				_g_free0 (_tmp12_);
				_vala_source_reference_unref0 (_tmp7_);
				vala_gir_parser_skip_element (self);
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp13_ = element_name;
	vala_gir_parser_push_node (self, _tmp13_, TRUE);
	_tmp14_ = self->priv->current;
	_tmp15_ = _tmp14_->new_symbol;
	if (_tmp15_) {
		ValaMarkupReader* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaGirParserNode* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaStruct* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaStruct* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp16_ = self->priv->reader;
		_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "name");
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->source_reference;
		_tmp21_ = vala_struct_new (_tmp18_, _tmp20_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp21_;
		_g_free0 (_tmp18_);
		_tmp22_ = self->priv->current;
		_tmp23_ = st;
		_tmp24_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp23_);
		_vala_code_node_unref0 (_tmp22_->symbol);
		_tmp22_->symbol = _tmp24_;
	} else {
		ValaGirParserNode* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaStruct* _tmp27_;
		_tmp25_ = self->priv->current;
		_tmp26_ = _tmp25_->symbol;
		_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp27_;
	}
	_tmp28_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp28_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp29_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp29_, TRUE);
	vala_gir_parser_next (self);
	_tmp30_ = st;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp34_ = self->priv->reader;
		_tmp35_ = vala_markup_reader_get_name (_tmp34_);
		_tmp36_ = _tmp35_;
		if (g_strcmp0 (_tmp36_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = self->priv->reader;
			_tmp38_ = vala_markup_reader_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			if (g_strcmp0 (_tmp39_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = self->priv->reader;
				_tmp41_ = vala_markup_reader_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				if (g_strcmp0 (_tmp42_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp43_ = self->priv->reader;
					_tmp44_ = vala_markup_reader_get_name (_tmp43_);
					_tmp45_ = _tmp44_;
					if (g_strcmp0 (_tmp45_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp46_;
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						_tmp46_ = self->priv->reader;
						_tmp47_ = vala_markup_reader_get_name (_tmp46_);
						_tmp48_ = _tmp47_;
						if (g_strcmp0 (_tmp48_, "record") == 0) {
							vala_gir_parser_parse_record (self);
						} else {
							ValaSourceReference* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaMarkupReader* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp49_ = vala_gir_parser_get_current_src (self);
							_tmp50_ = _tmp49_;
							_tmp51_ = self->priv->reader;
							_tmp52_ = vala_markup_reader_get_name (_tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp53_);
							_tmp55_ = _tmp54_;
							vala_report_error (_tmp50_, _tmp55_);
							_g_free0 (_tmp55_);
							_vala_source_reference_unref0 (_tmp50_);
							vala_gir_parser_skip_element (self);
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}


static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	ValaDataType* type = NULL;
	ValaDataType* _tmp3_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaConstant* _tmp8_;
	ValaGirParserNode* _tmp9_;
	ValaSymbol* _tmp10_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp3_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	type = _tmp3_;
	_tmp4_ = self->priv->current;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->source_reference;
	_tmp8_ = vala_constant_new (_tmp5_, type, NULL, _tmp7_, NULL);
	c = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) c);
	_vala_code_node_unref0 (_tmp9_->symbol);
	_tmp9_->symbol = _tmp10_;
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_symbol_set_comment ((ValaSymbol*) c, (ValaComment*) comment);
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}


static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self, 
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			gboolean _tmp22_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = arg_type;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			arg = (ValaGirParserArgument*) _tmp20_;
			_tmp21_ = arg;
			_tmp22_ = _tmp21_->used;
			if (!_tmp22_) {
				ValaGirParserArgument* _tmp23_;
				ValaSourceReference* _tmp24_;
				_tmp23_ = arg;
				_tmp24_ = _tmp23_->source_reference;
				vala_report_warning (_tmp24_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp25_;
		ValaArrayList* _tmp26_;
		gint _child_size = 0;
		ValaArrayList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _child_index = 0;
		_tmp25_ = metadata->children;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_child_list = _tmp26_;
		_tmp27_ = _child_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_child_size = _tmp29_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaGirParserMetadata* _tmp36_;
			gboolean _tmp37_;
			_tmp30_ = _child_index;
			_child_index = _tmp30_ + 1;
			_tmp31_ = _child_index;
			_tmp32_ = _child_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _child_list;
			_tmp34_ = _child_index;
			_tmp35_ = vala_list_get ((ValaList*) _tmp33_, _tmp34_);
			child = (ValaGirParserMetadata*) _tmp35_;
			_tmp36_ = child;
			_tmp37_ = _tmp36_->used;
			if (!_tmp37_) {
				ValaGirParserMetadata* _tmp38_;
				ValaSourceReference* _tmp39_;
				_tmp38_ = child;
				_tmp39_ = _tmp38_->source_reference;
				vala_report_warning (_tmp39_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp40_;
				_tmp40_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp40_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
}


static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_map_from_list = _tmp1_;
		_tmp2_ = _map_from_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_map_from_size = _tmp4_;
		_map_from_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			_tmp5_ = _map_from_index;
			_map_from_index = _tmp5_ + 1;
			_tmp6_ = _map_from_index;
			_tmp7_ = _map_from_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _map_from_list;
			_tmp9_ = _map_from_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			map_from = (ValaUnresolvedSymbol*) _tmp10_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp11_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp12_;
				ValaUnresolvedSymbol* _tmp13_;
				gpointer _tmp14_;
				ValaSymbol* _tmp15_;
				ValaUnresolvedSymbol* _tmp65_;
				ValaUnresolvedSymbol* _tmp66_;
				ValaUnresolvedSymbol* _tmp67_;
				ValaUnresolvedSymbol* _tmp68_;
				_tmp11_ = map_from;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = self->priv->unresolved_symbols_map;
				_tmp13_ = map_from;
				_tmp14_ = vala_map_get ((ValaMap*) _tmp12_, _tmp13_);
				map_to = (ValaSymbol*) _tmp14_;
				_tmp15_ = map_to;
				if (_tmp15_ != NULL) {
					ValaUnresolvedSymbol* _tmp16_;
					ValaUnresolvedSymbol* _tmp17_;
					ValaSymbol* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					ValaSymbol* _tmp21_;
					_tmp16_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp16_, NULL);
					_tmp17_ = map_from;
					_tmp18_ = map_to;
					_tmp19_ = vala_symbol_get_name (_tmp18_);
					_tmp20_ = _tmp19_;
					vala_symbol_set_name ((ValaSymbol*) _tmp17_, _tmp20_);
					_tmp21_ = map_to;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_UNRESOLVED_SYMBOL)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp22_;
						ValaUnresolvedSymbol* _tmp23_;
						_tmp22_ = map_to;
						_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp23_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							ValaUnresolvedSymbol* _tmp29_;
							ValaUnresolvedSymbol* _tmp30_;
							ValaUnresolvedSymbol* _tmp31_;
							ValaUnresolvedSymbol* _tmp32_;
							const gchar* _tmp33_;
							const gchar* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							ValaUnresolvedSymbol* _tmp37_;
							ValaUnresolvedSymbol* _tmp38_;
							ValaUnresolvedSymbol* _tmp39_;
							ValaUnresolvedSymbol* _tmp40_;
							_tmp24_ = umap_to;
							_tmp25_ = vala_unresolved_symbol_get_inner (_tmp24_);
							_tmp26_ = _tmp25_;
							if (!(_tmp26_ != NULL)) {
								break;
							}
							_tmp27_ = umap_to;
							_tmp28_ = vala_unresolved_symbol_get_inner (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = _vala_code_node_ref0 (_tmp29_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp30_;
							_tmp31_ = map_from;
							_tmp32_ = umap_to;
							_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = vala_unresolved_symbol_new (NULL, _tmp34_, NULL);
							_tmp36_ = _tmp35_;
							vala_unresolved_symbol_set_inner (_tmp31_, _tmp36_);
							_vala_code_node_unref0 (_tmp36_);
							_tmp37_ = map_from;
							_tmp38_ = vala_unresolved_symbol_get_inner (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = _vala_code_node_ref0 (_tmp39_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp40_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp41_ = FALSE;
							ValaSymbol* _tmp42_;
							ValaSymbol* _tmp43_;
							ValaSymbol* _tmp44_;
							ValaSymbol* _tmp51_;
							ValaSymbol* _tmp52_;
							ValaSymbol* _tmp53_;
							ValaSymbol* _tmp54_;
							ValaUnresolvedSymbol* _tmp55_;
							ValaSymbol* _tmp56_;
							const gchar* _tmp57_;
							const gchar* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							ValaUnresolvedSymbol* _tmp61_;
							ValaUnresolvedSymbol* _tmp62_;
							ValaUnresolvedSymbol* _tmp63_;
							ValaUnresolvedSymbol* _tmp64_;
							_tmp42_ = map_to;
							_tmp43_ = vala_symbol_get_parent_symbol (_tmp42_);
							_tmp44_ = _tmp43_;
							if (_tmp44_ != NULL) {
								ValaSymbol* _tmp45_;
								ValaSymbol* _tmp46_;
								ValaSymbol* _tmp47_;
								ValaCodeContext* _tmp48_;
								ValaNamespace* _tmp49_;
								ValaNamespace* _tmp50_;
								_tmp45_ = map_to;
								_tmp46_ = vala_symbol_get_parent_symbol (_tmp45_);
								_tmp47_ = _tmp46_;
								_tmp48_ = self->priv->context;
								_tmp49_ = vala_code_context_get_root (_tmp48_);
								_tmp50_ = _tmp49_;
								_tmp41_ = _tmp47_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp41_ = FALSE;
							}
							if (!_tmp41_) {
								break;
							}
							_tmp51_ = map_to;
							_tmp52_ = vala_symbol_get_parent_symbol (_tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = _vala_code_node_ref0 (_tmp53_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp54_;
							_tmp55_ = map_from;
							_tmp56_ = map_to;
							_tmp57_ = vala_symbol_get_name (_tmp56_);
							_tmp58_ = _tmp57_;
							_tmp59_ = vala_unresolved_symbol_new (NULL, _tmp58_, NULL);
							_tmp60_ = _tmp59_;
							vala_unresolved_symbol_set_inner (_tmp55_, _tmp60_);
							_vala_code_node_unref0 (_tmp60_);
							_tmp61_ = map_from;
							_tmp62_ = vala_unresolved_symbol_get_inner (_tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp64_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp65_ = map_from;
				_tmp66_ = vala_unresolved_symbol_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = _vala_code_node_ref0 (_tmp67_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp68_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
		_vala_iterable_unref0 (_map_from_list);
	}
}


static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaSymbol* _tmp12_;
			_tmp5_ = _node_index;
			_node_index = _tmp5_ + 1;
			_tmp6_ = _node_index;
			_tmp7_ = _node_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _node_list;
			_tmp9_ = _node_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			node = (ValaGirParserNode*) _tmp10_;
			_tmp11_ = node;
			_tmp12_ = _tmp11_->symbol;
			if (_tmp12_ == NULL) {
				ValaGirParserNode* _tmp13_;
				ValaGirParserNode* _tmp14_;
				const gchar* _tmp15_;
				ValaGirParserNode* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaNamespace* _tmp18_;
				_tmp13_ = node;
				_tmp14_ = node;
				_tmp15_ = _tmp14_->name;
				_tmp16_ = node;
				_tmp17_ = _tmp16_->source_reference;
				_tmp18_ = vala_namespace_new (_tmp15_, _tmp17_);
				_vala_code_node_unref0 (_tmp13_->symbol);
				_tmp13_->symbol = (ValaSymbol*) _tmp18_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _element_type_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _element_type_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_type_index = 0;
		_tmp0_ = self->priv->unresolved_type_arguments;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_element_type_list = _tmp1_;
		_tmp2_ = _element_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_type_size = _tmp4_;
		_element_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* element_type = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeSymbol* sym = NULL;
			ValaDataType* _tmp11_;
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp24_;
			ValaStruct* _tmp25_;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			ValaStruct* _tmp28_;
			_tmp5_ = _element_type_index;
			_element_type_index = _tmp5_ + 1;
			_tmp6_ = _element_type_index;
			_tmp7_ = _element_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _element_type_list;
			_tmp9_ = _element_type_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			element_type = (ValaDataType*) _tmp10_;
			sym = NULL;
			_tmp11_ = element_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_UNRESOLVED_TYPE)) {
				ValaGirParserNode* _tmp12_;
				ValaDataType* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaSymbol* _tmp16_;
				_tmp12_ = self->priv->root;
				_tmp13_ = element_type;
				_tmp14_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_gir_parser_resolve_symbol (self, _tmp12_, _tmp15_);
				_vala_code_node_unref0 (sym);
				sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				ValaDataType* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				_tmp17_ = element_type;
				_tmp18_ = vala_data_type_get_data_type (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ != NULL) {
					ValaDataType* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					ValaTypeSymbol* _tmp22_;
					ValaTypeSymbol* _tmp23_;
					_tmp20_ = element_type;
					_tmp21_ = vala_data_type_get_data_type (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = _vala_code_node_ref0 (_tmp22_);
					_vala_code_node_unref0 (sym);
					sym = _tmp23_;
				}
			}
			_tmp24_ = sym;
			_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp24_) : NULL);
			st = _tmp25_;
			_tmp28_ = st;
			if (_tmp28_ != NULL) {
				ValaStruct* _tmp29_;
				_tmp29_ = st;
				_tmp27_ = !vala_struct_is_integer_type (_tmp29_);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				ValaStruct* _tmp30_;
				_tmp30_ = st;
				_tmp26_ = !vala_struct_is_floating_type (_tmp30_);
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				ValaDataType* _tmp31_;
				_tmp31_ = element_type;
				vala_data_type_set_nullable (_tmp31_, TRUE);
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (element_type);
		}
		_vala_iterable_unref0 (_element_type_list);
	}
}


static void
vala_gir_parser_process_interface (ValaGirParser* self, 
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		gint _prereq_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_prereq_list = _tmp3_;
		_tmp4_ = _prereq_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_prereq_size = _tmp6_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp13_;
			ValaSymbol* _tmp25_;
			_tmp7_ = _prereq_index;
			_prereq_index = _tmp7_ + 1;
			_tmp8_ = _prereq_index;
			_tmp9_ = _prereq_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _prereq_list;
			_tmp11_ = _prereq_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			prereq = (ValaDataType*) _tmp12_;
			sym = NULL;
			_tmp13_ = prereq;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_UNRESOLVED_TYPE)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaUnresolvedSymbol* _tmp16_;
				ValaUnresolvedSymbol* _tmp17_;
				ValaGirParserNode* _tmp18_;
				ValaUnresolvedSymbol* _tmp19_;
				ValaSymbol* _tmp20_;
				_tmp14_ = prereq;
				_tmp15_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp16_ = _tmp15_;
				_tmp17_ = _vala_code_node_ref0 (_tmp16_);
				unresolved_symbol = _tmp17_;
				_tmp18_ = iface_node->parent;
				_tmp19_ = unresolved_symbol;
				_tmp20_ = vala_gir_parser_resolve_symbol (self, _tmp18_, _tmp19_);
				_vala_code_node_unref0 (sym);
				sym = _tmp20_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaSymbol* _tmp24_;
				_tmp21_ = prereq;
				_tmp22_ = vala_data_type_get_data_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp23_);
				_vala_code_node_unref0 (sym);
				sym = _tmp24_;
			}
			_tmp25_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_CLASS)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp26_ = has_instantiable_prereq;
	if (!_tmp26_) {
		ValaInterface* _tmp27_;
		ValaNamespace* _tmp28_;
		ValaScope* _tmp29_;
		ValaScope* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaObjectTypeSymbol* _tmp32_;
		ValaObjectType* _tmp33_;
		ValaObjectType* _tmp34_;
		_tmp27_ = iface;
		_tmp28_ = self->priv->glib_ns;
		_tmp29_ = vala_symbol_get_scope ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_scope_lookup (_tmp30_, "Object");
		_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
		_tmp33_ = vala_object_type_new (_tmp32_);
		_tmp34_ = _tmp33_;
		vala_interface_add_prerequisite (_tmp27_, (ValaDataType*) _tmp34_);
		_vala_code_node_unref0 (_tmp34_);
		_vala_code_node_unref0 (_tmp32_);
	}
	_vala_code_node_unref0 (iface);
}


static void
vala_gir_parser_process_alias (ValaGirParser* self, 
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp144_ = FALSE;
	ValaSymbol* _tmp145_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_UNRESOLVED_TYPE)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_POINTER_TYPE)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_data_type (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_STRUCT)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_STRUCT);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		gboolean _tmp51_;
		ValaStruct* _tmp52_;
		ValaSymbol* _tmp53_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_symbol_set_external ((ValaSymbol*) _tmp49_, TRUE);
		_tmp50_ = st;
		_tmp51_ = simple_type;
		vala_struct_set_simple_type (_tmp50_, _tmp51_);
		_tmp52_ = st;
		_tmp53_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp52_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp53_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp54_;
		_tmp54_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			const gchar* _tmp55_;
			ValaSourceReference* _tmp56_;
			ValaClass* _tmp57_;
			ValaClass* _tmp58_;
			ValaDataType* _tmp59_;
			ValaClass* _tmp62_;
			ValaGirComment* _tmp63_;
			ValaClass* _tmp64_;
			ValaClass* _tmp65_;
			ValaSymbol* _tmp66_;
			gboolean _tmp67_;
			gboolean _tmp68_;
			ValaClass* _tmp69_;
			ValaSymbol* _tmp70_;
			_tmp55_ = alias->name;
			_tmp56_ = alias->source_reference;
			_tmp57_ = vala_class_new (_tmp55_, _tmp56_, NULL);
			cl = _tmp57_;
			_tmp58_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp58_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp59_ = base_type;
			if (_tmp59_ != NULL) {
				ValaClass* _tmp60_;
				ValaDataType* _tmp61_;
				_tmp60_ = cl;
				_tmp61_ = base_type;
				vala_class_add_base_type (_tmp60_, _tmp61_);
			}
			_tmp62_ = cl;
			_tmp63_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp62_, (ValaComment*) _tmp63_);
			_tmp64_ = cl;
			vala_symbol_set_external ((ValaSymbol*) _tmp64_, TRUE);
			_tmp65_ = cl;
			_tmp66_ = type_sym;
			_tmp67_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
			_tmp68_ = _tmp67_;
			vala_class_set_is_compact (_tmp65_, _tmp68_);
			_tmp69_ = cl;
			_tmp70_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp69_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp70_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp71_;
			_tmp71_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaInterface* _tmp74_;
				ValaInterface* _tmp75_;
				ValaDataType* _tmp76_;
				ValaInterface* _tmp79_;
				ValaGirComment* _tmp80_;
				ValaInterface* _tmp81_;
				ValaInterface* _tmp82_;
				ValaSymbol* _tmp83_;
				_tmp72_ = alias->name;
				_tmp73_ = alias->source_reference;
				_tmp74_ = vala_interface_new (_tmp72_, _tmp73_, NULL);
				iface = _tmp74_;
				_tmp75_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp75_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp76_ = base_type;
				if (_tmp76_ != NULL) {
					ValaInterface* _tmp77_;
					ValaDataType* _tmp78_;
					_tmp77_ = iface;
					_tmp78_ = base_type;
					vala_interface_add_prerequisite (_tmp77_, _tmp78_);
				}
				_tmp79_ = iface;
				_tmp80_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp79_, (ValaComment*) _tmp80_);
				_tmp81_ = iface;
				vala_symbol_set_external ((ValaSymbol*) _tmp81_, TRUE);
				_tmp82_ = iface;
				_tmp83_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp82_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp83_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp84_;
				_tmp84_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_DELEGATE)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp85_;
					ValaDelegate* _tmp86_;
					ValaGirParserNode* _tmp87_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp92_;
					ValaDelegate* _tmp93_;
					ValaDataType* _tmp94_;
					ValaDataType* _tmp95_;
					ValaDataType* _tmp96_;
					ValaDataType* _tmp97_;
					ValaSourceReference* _tmp98_;
					ValaDelegate* _tmp99_;
					ValaDelegate* _tmp100_;
					ValaDelegate* _tmp101_;
					ValaDelegate* _tmp102_;
					ValaSymbolAccessibility _tmp103_;
					ValaSymbolAccessibility _tmp104_;
					ValaDelegate* _tmp135_;
					GList* _tmp136_;
					ValaDelegate* _tmp141_;
					ValaDelegate* _tmp142_;
					ValaSymbol* _tmp143_;
					_tmp85_ = type_sym;
					_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp86_;
					_tmp87_ = base_node;
					if (_tmp87_ != NULL) {
						ValaGirParserNode* _tmp88_;
						ValaGirParserNode* _tmp89_;
						ValaSymbol* _tmp90_;
						ValaDelegate* _tmp91_;
						_tmp88_ = base_node;
						vala_gir_parser_node_process (_tmp88_, self);
						_tmp89_ = base_node;
						_tmp90_ = _tmp89_->symbol;
						_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp91_;
					}
					_tmp92_ = alias->name;
					_tmp93_ = orig;
					_tmp94_ = vala_callable_get_return_type ((ValaCallable*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_data_type_copy (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = alias->source_reference;
					_tmp99_ = vala_delegate_new (_tmp92_, _tmp97_, _tmp98_, NULL);
					_tmp100_ = _tmp99_;
					_vala_code_node_unref0 (_tmp97_);
					deleg = _tmp100_;
					_tmp101_ = deleg;
					_tmp102_ = orig;
					_tmp103_ = vala_symbol_get_access ((ValaSymbol*) _tmp102_);
					_tmp104_ = _tmp103_;
					vala_symbol_set_access ((ValaSymbol*) _tmp101_, _tmp104_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp105_;
						ValaList* _tmp106_;
						gint _param_size = 0;
						ValaList* _tmp107_;
						gint _tmp108_;
						gint _tmp109_;
						gint _param_index = 0;
						_tmp105_ = orig;
						_tmp106_ = vala_callable_get_parameters ((ValaCallable*) _tmp105_);
						_param_list = _tmp106_;
						_tmp107_ = _param_list;
						_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
						_tmp109_ = _tmp108_;
						_param_size = _tmp109_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp110_;
							gint _tmp111_;
							gint _tmp112_;
							ValaParameter* param = NULL;
							ValaList* _tmp113_;
							gint _tmp114_;
							gpointer _tmp115_;
							ValaDelegate* _tmp116_;
							ValaParameter* _tmp117_;
							ValaParameter* _tmp118_;
							ValaParameter* _tmp119_;
							_tmp110_ = _param_index;
							_param_index = _tmp110_ + 1;
							_tmp111_ = _param_index;
							_tmp112_ = _param_size;
							if (!(_tmp111_ < _tmp112_)) {
								break;
							}
							_tmp113_ = _param_list;
							_tmp114_ = _param_index;
							_tmp115_ = vala_list_get (_tmp113_, _tmp114_);
							param = (ValaParameter*) _tmp115_;
							_tmp116_ = deleg;
							_tmp117_ = param;
							_tmp118_ = vala_parameter_copy (_tmp117_);
							_tmp119_ = _tmp118_;
							vala_callable_add_parameter ((ValaCallable*) _tmp116_, _tmp119_);
							_vala_code_node_unref0 (_tmp119_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _error_type_list = NULL;
						ValaDelegate* _tmp120_;
						ValaList* _tmp121_;
						gint _error_type_size = 0;
						ValaList* _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						gint _error_type_index = 0;
						_tmp120_ = orig;
						_tmp121_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp120_);
						_error_type_list = _tmp121_;
						_tmp122_ = _error_type_list;
						_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
						_tmp124_ = _tmp123_;
						_error_type_size = _tmp124_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp125_;
							gint _tmp126_;
							gint _tmp127_;
							ValaDataType* error_type = NULL;
							ValaList* _tmp128_;
							gint _tmp129_;
							gpointer _tmp130_;
							ValaDelegate* _tmp131_;
							ValaDataType* _tmp132_;
							ValaDataType* _tmp133_;
							ValaDataType* _tmp134_;
							_tmp125_ = _error_type_index;
							_error_type_index = _tmp125_ + 1;
							_tmp126_ = _error_type_index;
							_tmp127_ = _error_type_size;
							if (!(_tmp126_ < _tmp127_)) {
								break;
							}
							_tmp128_ = _error_type_list;
							_tmp129_ = _error_type_index;
							_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
							error_type = (ValaDataType*) _tmp130_;
							_tmp131_ = deleg;
							_tmp132_ = error_type;
							_tmp133_ = vala_data_type_copy (_tmp132_);
							_tmp134_ = _tmp133_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp131_, _tmp134_);
							_vala_code_node_unref0 (_tmp134_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp135_ = orig;
					_tmp136_ = ((ValaCodeNode*) _tmp135_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp136_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp137_;
							ValaAttribute* attribute = NULL;
							_tmp137_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp137_;
							{
								ValaDelegate* _tmp138_;
								ValaAttribute* _tmp139_;
								ValaAttribute* _tmp140_;
								_tmp138_ = deleg;
								_tmp139_ = attribute;
								_tmp140_ = _vala_code_node_ref0 (_tmp139_);
								((ValaCodeNode*) _tmp138_)->attributes = g_list_append (((ValaCodeNode*) _tmp138_)->attributes, _tmp140_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp141_ = deleg;
					vala_symbol_set_external ((ValaSymbol*) _tmp141_, TRUE);
					_tmp142_ = deleg;
					_tmp143_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp142_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp143_;
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				}
			}
		}
	}
	_tmp145_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp145_, VALA_TYPE_CLASS)) {
		_tmp144_ = TRUE;
	} else {
		gboolean _tmp146_ = FALSE;
		ValaSymbol* _tmp147_;
		_tmp147_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_STRUCT)) {
			gboolean _tmp148_;
			_tmp148_ = simple_type;
			_tmp146_ = !_tmp148_;
		} else {
			_tmp146_ = FALSE;
		}
		_tmp144_ = _tmp146_;
	}
	if (_tmp144_) {
		ValaSymbol* _tmp149_;
		_tmp149_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp149_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			_tmp150_ = alias->symbol;
			_tmp151_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp150_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp151_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp152_;
			_tmp152_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp152_, "CCode", "type_id")) {
				ValaSymbol* _tmp153_;
				ValaSymbol* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				_tmp153_ = alias->symbol;
				_tmp154_ = type_sym;
				_tmp155_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp154_, "CCode", "type_id", NULL);
				_tmp156_ = _tmp155_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "type_id", _tmp156_, NULL);
				_g_free0 (_tmp156_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}


static void
vala_gir_parser_process_callable (ValaGirParser* self, 
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	ValaList* _tmp162_;
	gint _tmp163_;
	gint _tmp164_;
	gint i = 0;
	gint j = 0;
	gint last = 0;
	gboolean _tmp405_ = FALSE;
	ValaDataType* _tmp406_;
	ValaSymbol* _tmp413_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_DELEGATE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_CALLABLE)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_ARRAY_TYPE)) {
		gint _tmp14_;
		_tmp14_ = node->return_array_length_idx;
		_tmp12_ = _tmp14_ >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gint _tmp15_;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp15_ = node->return_array_length_idx;
		_tmp16_ = parameters;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp15_ >= _tmp18_) {
			ValaDataType* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			_tmp19_ = return_type;
			_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			vala_report_error (_tmp21_, "invalid array length index");
		} else {
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaGirParserParameterInfo* _tmp25_;
			ValaArrayList* _tmp26_;
			gint _tmp27_;
			_tmp22_ = parameters;
			_tmp23_ = node->return_array_length_idx;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			_tmp25_ = (ValaGirParserParameterInfo*) _tmp24_;
			_tmp25_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp25_);
			_tmp26_ = node->array_length_parameters;
			_tmp27_ = node->return_array_length_idx;
			vala_collection_add ((ValaCollection*) _tmp26_, (gpointer) ((gintptr) _tmp27_));
		}
	} else {
		gboolean _tmp28_ = FALSE;
		ValaDataType* _tmp29_;
		_tmp29_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_VOID_TYPE)) {
			ValaList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp30_ = parameters;
			_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp28_ = _tmp32_ > 0;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gint n_out_parameters = 0;
			gint _tmp49_;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp33_;
				ValaList* _tmp34_;
				gint _info_size = 0;
				ValaList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _info_index = 0;
				_tmp33_ = parameters;
				_tmp34_ = _vala_iterable_ref0 (_tmp33_);
				_info_list = _tmp34_;
				_tmp35_ = _info_list;
				_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_info_size = _tmp37_;
				_info_index = -1;
				while (TRUE) {
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp41_;
					gint _tmp42_;
					gpointer _tmp43_;
					ValaGirParserParameterInfo* _tmp44_;
					ValaParameter* _tmp45_;
					ValaParameterDirection _tmp46_;
					ValaParameterDirection _tmp47_;
					_tmp38_ = _info_index;
					_info_index = _tmp38_ + 1;
					_tmp39_ = _info_index;
					_tmp40_ = _info_size;
					if (!(_tmp39_ < _tmp40_)) {
						break;
					}
					_tmp41_ = _info_list;
					_tmp42_ = _info_index;
					_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
					info = (ValaGirParserParameterInfo*) _tmp43_;
					_tmp44_ = info;
					_tmp45_ = _tmp44_->param;
					_tmp46_ = vala_parameter_get_direction (_tmp45_);
					_tmp47_ = _tmp46_;
					if (_tmp47_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp48_;
						_tmp48_ = n_out_parameters;
						n_out_parameters = _tmp48_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
				_vala_iterable_unref0 (_info_list);
			}
			_tmp49_ = n_out_parameters;
			if (_tmp49_ == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp50_;
				ValaList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_;
				ValaGirParserParameterInfo* _tmp55_;
				ValaParameter* _tmp56_;
				ValaParameterDirection _tmp57_;
				ValaParameterDirection _tmp58_;
				_tmp50_ = parameters;
				_tmp51_ = parameters;
				_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_list_get (_tmp50_, _tmp53_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp54_;
				_tmp55_ = last_param;
				_tmp56_ = _tmp55_->param;
				_tmp57_ = vala_parameter_get_direction (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp59_;
					ValaParameter* _tmp60_;
					ValaDataType* _tmp61_;
					ValaDataType* _tmp62_;
					_tmp59_ = last_param;
					_tmp60_ = _tmp59_->param;
					_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) _tmp60_);
					_tmp62_ = _tmp61_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_UNRESOLVED_TYPE)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp63_;
						ValaGirParserParameterInfo* _tmp64_;
						ValaParameter* _tmp65_;
						ValaDataType* _tmp66_;
						ValaDataType* _tmp67_;
						ValaUnresolvedSymbol* _tmp68_;
						ValaUnresolvedSymbol* _tmp69_;
						ValaSymbol* _tmp70_;
						ValaStruct* _tmp71_;
						gboolean _tmp72_ = FALSE;
						gboolean _tmp73_ = FALSE;
						ValaStruct* _tmp74_;
						_tmp63_ = node->parent;
						_tmp64_ = last_param;
						_tmp65_ = _tmp64_->param;
						_tmp66_ = vala_variable_get_variable_type ((ValaVariable*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp69_ = _tmp68_;
						_tmp70_ = vala_gir_parser_resolve_symbol (self, _tmp63_, _tmp69_);
						_tmp71_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp70_) : NULL;
						if (_tmp71_ == NULL) {
							_vala_code_node_unref0 (_tmp70_);
						}
						st = _tmp71_;
						_tmp74_ = st;
						if (_tmp74_ != NULL) {
							ValaStruct* _tmp75_;
							_tmp75_ = st;
							_tmp73_ = !vala_struct_is_simple_type (_tmp75_);
						} else {
							_tmp73_ = FALSE;
						}
						if (_tmp73_) {
							ValaGirParserParameterInfo* _tmp76_;
							ValaParameter* _tmp77_;
							ValaDataType* _tmp78_;
							ValaDataType* _tmp79_;
							gboolean _tmp80_;
							gboolean _tmp81_;
							_tmp76_ = last_param;
							_tmp77_ = _tmp76_->param;
							_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) _tmp77_);
							_tmp79_ = _tmp78_;
							_tmp80_ = vala_data_type_get_nullable (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp72_ = !_tmp81_;
						} else {
							_tmp72_ = FALSE;
						}
						if (_tmp72_) {
							ValaGirParserMetadata* _tmp82_;
							_tmp82_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp83_;
								ValaGirParserParameterInfo* _tmp84_;
								ValaParameter* _tmp85_;
								ValaDataType* _tmp86_;
								ValaDataType* _tmp87_;
								ValaDataType* _tmp88_;
								_tmp83_ = last_param;
								_tmp83_->keep = FALSE;
								_tmp84_ = last_param;
								_tmp85_ = _tmp84_->param;
								_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = vala_data_type_copy (_tmp87_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp88_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp89_ = FALSE;
			ValaDataType* _tmp90_;
			_tmp90_ = return_type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_UNRESOLVED_TYPE)) {
				ValaDataType* _tmp91_;
				gboolean _tmp92_;
				gboolean _tmp93_;
				_tmp91_ = return_type;
				_tmp92_ = vala_data_type_get_nullable (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp89_ = !_tmp93_;
			} else {
				_tmp89_ = FALSE;
			}
			if (_tmp89_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp94_;
				ValaDataType* _tmp95_;
				ValaUnresolvedSymbol* _tmp96_;
				ValaUnresolvedSymbol* _tmp97_;
				ValaSymbol* _tmp98_;
				ValaStruct* _tmp99_;
				ValaStruct* _tmp100_;
				_tmp94_ = node->parent;
				_tmp95_ = return_type;
				_tmp96_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_gir_parser_resolve_symbol (self, _tmp94_, _tmp97_);
				_tmp99_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp98_) : NULL;
				if (_tmp99_ == NULL) {
					_vala_code_node_unref0 (_tmp98_);
				}
				st = _tmp99_;
				_tmp100_ = st;
				if (_tmp100_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp101_;
					ValaStruct* _tmp102_;
					gboolean _tmp120_;
					is_simple_type = FALSE;
					_tmp101_ = st;
					_tmp102_ = _vala_code_node_ref0 (_tmp101_);
					base_st = _tmp102_;
					while (TRUE) {
						ValaStruct* _tmp103_;
						ValaStruct* _tmp104_;
						ValaStruct* _tmp105_;
						ValaDataType* _tmp106_;
						ValaDataType* _tmp107_;
						_tmp103_ = base_st;
						if (!(_tmp103_ != NULL)) {
							break;
						}
						_tmp104_ = base_st;
						if (vala_struct_is_simple_type (_tmp104_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp105_ = base_st;
						_tmp106_ = vala_struct_get_base_type (_tmp105_);
						_tmp107_ = _tmp106_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_UNRESOLVED_TYPE)) {
							ValaGirParserNode* _tmp108_;
							ValaStruct* _tmp109_;
							ValaDataType* _tmp110_;
							ValaDataType* _tmp111_;
							ValaUnresolvedSymbol* _tmp112_;
							ValaUnresolvedSymbol* _tmp113_;
							ValaSymbol* _tmp114_;
							ValaStruct* _tmp115_;
							_tmp108_ = node->parent;
							_tmp109_ = base_st;
							_tmp110_ = vala_struct_get_base_type (_tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp113_ = _tmp112_;
							_tmp114_ = vala_gir_parser_resolve_symbol (self, _tmp108_, _tmp113_);
							_tmp115_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp114_) : NULL;
							if (_tmp115_ == NULL) {
								_vala_code_node_unref0 (_tmp114_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp115_;
						} else {
							ValaStruct* _tmp116_;
							ValaStruct* _tmp117_;
							ValaStruct* _tmp118_;
							ValaStruct* _tmp119_;
							_tmp116_ = base_st;
							_tmp117_ = vala_struct_get_base_struct (_tmp116_);
							_tmp118_ = _tmp117_;
							_tmp119_ = _vala_code_node_ref0 (_tmp118_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp119_;
						}
					}
					_tmp120_ = is_simple_type;
					if (!_tmp120_) {
						ValaDataType* _tmp121_;
						_tmp121_ = return_type;
						vala_data_type_set_nullable (_tmp121_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp122_;
		ValaList* _tmp123_;
		gint _info_size = 0;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gint _info_index = 0;
		_tmp122_ = parameters;
		_tmp123_ = _vala_iterable_ref0 (_tmp122_);
		_info_list = _tmp123_;
		_tmp124_ = _info_list;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		_info_size = _tmp126_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp130_;
			gint _tmp131_;
			gpointer _tmp132_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp133_;
			ValaParameter* _tmp134_;
			ValaDataType* _tmp135_;
			ValaDataType* _tmp136_;
			ValaDataType* _tmp137_;
			gboolean _tmp138_ = FALSE;
			ValaGirParserParameterInfo* _tmp139_;
			ValaParameter* _tmp140_;
			ValaParameterDirection _tmp141_;
			ValaParameterDirection _tmp142_;
			_tmp127_ = _info_index;
			_info_index = _tmp127_ + 1;
			_tmp128_ = _info_index;
			_tmp129_ = _info_size;
			if (!(_tmp128_ < _tmp129_)) {
				break;
			}
			_tmp130_ = _info_list;
			_tmp131_ = _info_index;
			_tmp132_ = vala_list_get (_tmp130_, _tmp131_);
			info = (ValaGirParserParameterInfo*) _tmp132_;
			_tmp133_ = info;
			_tmp134_ = _tmp133_->param;
			_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = _vala_code_node_ref0 (_tmp136_);
			type = _tmp137_;
			_tmp139_ = info;
			_tmp140_ = _tmp139_->param;
			_tmp141_ = vala_parameter_get_direction (_tmp140_);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp143_;
				gboolean _tmp144_;
				gboolean _tmp145_;
				_tmp143_ = type;
				_tmp144_ = vala_data_type_get_nullable (_tmp143_);
				_tmp145_ = _tmp144_;
				_tmp138_ = _tmp145_;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp146_;
				gboolean _tmp158_ = FALSE;
				ValaStruct* _tmp159_;
				st = NULL;
				_tmp146_ = type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp146_, VALA_TYPE_UNRESOLVED_TYPE)) {
					ValaGirParserNode* _tmp147_;
					ValaDataType* _tmp148_;
					ValaUnresolvedSymbol* _tmp149_;
					ValaUnresolvedSymbol* _tmp150_;
					ValaSymbol* _tmp151_;
					ValaStruct* _tmp152_;
					_tmp147_ = node->parent;
					_tmp148_ = type;
					_tmp149_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp150_ = _tmp149_;
					_tmp151_ = vala_gir_parser_resolve_symbol (self, _tmp147_, _tmp150_);
					_tmp152_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp151_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp151_) : NULL;
					if (_tmp152_ == NULL) {
						_vala_code_node_unref0 (_tmp151_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp152_;
				} else {
					ValaDataType* _tmp153_;
					_tmp153_ = type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp154_;
						ValaTypeSymbol* _tmp155_;
						ValaTypeSymbol* _tmp156_;
						ValaStruct* _tmp157_;
						_tmp154_ = type;
						_tmp155_ = vala_data_type_get_data_type (_tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp156_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp156_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp157_;
					}
				}
				_tmp159_ = st;
				if (_tmp159_ != NULL) {
					ValaStruct* _tmp160_;
					_tmp160_ = st;
					_tmp158_ = vala_struct_is_simple_type (_tmp160_);
				} else {
					_tmp158_ = FALSE;
				}
				if (_tmp158_) {
					ValaDataType* _tmp161_;
					_tmp161_ = type;
					vala_data_type_set_nullable (_tmp161_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_vala_code_node_unref0 (type);
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp162_ = parameters;
	_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
	_tmp164_ = _tmp163_;
	if (_tmp164_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp165_;
		ValaList* _tmp166_;
		gint _tmp167_;
		gint _tmp168_;
		gpointer _tmp169_;
		ValaGirParserParameterInfo* _tmp170_;
		ValaParameter* _tmp171_;
		gboolean _tmp172_;
		gboolean _tmp173_;
		_tmp165_ = parameters;
		_tmp166_ = parameters;
		_tmp167_ = vala_collection_get_size ((ValaCollection*) _tmp166_);
		_tmp168_ = _tmp167_;
		_tmp169_ = vala_list_get (_tmp165_, _tmp168_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp169_;
		_tmp170_ = last_param;
		_tmp171_ = _tmp170_->param;
		_tmp172_ = vala_parameter_get_ellipsis (_tmp171_);
		_tmp173_ = _tmp172_;
		if (_tmp173_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp174_;
			ValaList* _tmp175_;
			gint _tmp176_;
			gint _tmp177_;
			gpointer _tmp178_;
			ValaGirParserParameterInfo* _tmp179_;
			ValaParameter* _tmp180_;
			const gchar* _tmp181_;
			const gchar* _tmp182_;
			_tmp174_ = parameters;
			_tmp175_ = parameters;
			_tmp176_ = vala_collection_get_size ((ValaCollection*) _tmp175_);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_list_get (_tmp174_, _tmp177_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp178_;
			_tmp179_ = first_vararg_param;
			_tmp180_ = _tmp179_->param;
			_tmp181_ = vala_symbol_get_name ((ValaSymbol*) _tmp180_);
			_tmp182_ = _tmp181_;
			if (g_str_has_prefix (_tmp182_, "first_")) {
				ValaGirParserParameterInfo* _tmp183_;
				_tmp183_ = first_vararg_param;
				_tmp183_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp184_;
		ValaList* _tmp185_;
		gint _info_size = 0;
		ValaList* _tmp186_;
		gint _tmp187_;
		gint _tmp188_;
		gint _info_index = 0;
		_tmp184_ = parameters;
		_tmp185_ = _vala_iterable_ref0 (_tmp184_);
		_info_list = _tmp185_;
		_tmp186_ = _info_list;
		_tmp187_ = vala_collection_get_size ((ValaCollection*) _tmp186_);
		_tmp188_ = _tmp187_;
		_info_size = _tmp188_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp189_;
			gint _tmp190_;
			gint _tmp191_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp192_;
			gint _tmp193_;
			gpointer _tmp194_;
			gboolean _tmp195_ = FALSE;
			ValaSymbol* _tmp196_;
			gint _tmp249_;
			_tmp189_ = _info_index;
			_info_index = _tmp189_ + 1;
			_tmp190_ = _info_index;
			_tmp191_ = _info_size;
			if (!(_tmp190_ < _tmp191_)) {
				break;
			}
			_tmp192_ = _info_list;
			_tmp193_ = _info_index;
			_tmp194_ = vala_list_get (_tmp192_, _tmp193_);
			info = (ValaGirParserParameterInfo*) _tmp194_;
			_tmp196_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp196_, VALA_TYPE_DELEGATE)) {
				ValaGirParserParameterInfo* _tmp197_;
				gint _tmp198_;
				gint _tmp199_;
				_tmp197_ = info;
				_tmp198_ = _tmp197_->closure_idx;
				_tmp199_ = i;
				_tmp195_ = _tmp198_ == _tmp199_;
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp200_;
				ValaDelegate* _tmp201_;
				ValaDelegate* _tmp202_;
				ValaDelegate* _tmp203_;
				gint _tmp204_;
				ValaGirParserParameterInfo* _tmp205_;
				_tmp200_ = s;
				_tmp201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp201_;
				_tmp202_ = d;
				vala_delegate_set_has_target (_tmp202_, TRUE);
				_tmp203_ = d;
				_tmp204_ = j;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp203_, "CCode", "instance_pos", _tmp204_ - 0.1, NULL);
				_tmp205_ = info;
				_tmp205_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp206_ = FALSE;
				gboolean _tmp207_ = FALSE;
				gboolean _tmp208_ = FALSE;
				ValaGirParserParameterInfo* _tmp209_;
				gboolean _tmp210_;
				_tmp209_ = info;
				_tmp210_ = _tmp209_->keep;
				if (_tmp210_) {
					ValaArrayList* _tmp211_;
					gint _tmp212_;
					_tmp211_ = node->array_length_parameters;
					_tmp212_ = i;
					_tmp208_ = !vala_collection_contains ((ValaCollection*) _tmp211_, (gpointer) ((gintptr) _tmp212_));
				} else {
					_tmp208_ = FALSE;
				}
				if (_tmp208_) {
					ValaArrayList* _tmp213_;
					gint _tmp214_;
					_tmp213_ = node->closure_parameters;
					_tmp214_ = i;
					_tmp207_ = !vala_collection_contains ((ValaCollection*) _tmp213_, (gpointer) ((gintptr) _tmp214_));
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaArrayList* _tmp215_;
					gint _tmp216_;
					_tmp215_ = node->destroy_parameters;
					_tmp216_ = i;
					_tmp206_ = !vala_collection_contains ((ValaCollection*) _tmp215_, (gpointer) ((gintptr) _tmp216_));
				} else {
					_tmp206_ = FALSE;
				}
				if (_tmp206_) {
					ValaGirParserParameterInfo* _tmp217_;
					gint _tmp218_;
					ValaGirParserParameterInfo* _tmp219_;
					gfloat last_idx = 0.0F;
					gint _tmp220_;
					gint _tmp242_;
					gint _tmp243_;
					_tmp217_ = info;
					_tmp218_ = j;
					_tmp217_->vala_idx = (gfloat) _tmp218_;
					_tmp219_ = info;
					_tmp219_->keep = TRUE;
					last_idx = 0.0F;
					_tmp220_ = last;
					if (_tmp220_ != -1) {
						ValaList* _tmp221_;
						gint _tmp222_;
						gpointer _tmp223_;
						ValaGirParserParameterInfo* _tmp224_;
						gfloat _tmp225_;
						_tmp221_ = parameters;
						_tmp222_ = last;
						_tmp223_ = vala_list_get (_tmp221_, _tmp222_);
						_tmp224_ = (ValaGirParserParameterInfo*) _tmp223_;
						_tmp225_ = _tmp224_->vala_idx;
						last_idx = _tmp225_;
						_vala_gir_parser_parameter_info_unref0 (_tmp224_);
					}
					{
						gint k = 0;
						gint _tmp226_;
						_tmp226_ = last;
						k = _tmp226_ + 1;
						{
							gboolean _tmp227_ = FALSE;
							_tmp227_ = TRUE;
							while (TRUE) {
								gint _tmp229_;
								gint _tmp230_;
								ValaList* _tmp231_;
								gint _tmp232_;
								gpointer _tmp233_;
								ValaGirParserParameterInfo* _tmp234_;
								gfloat _tmp235_;
								gint _tmp236_;
								gfloat _tmp237_;
								gint _tmp238_;
								gint _tmp239_;
								gint _tmp240_;
								gint _tmp241_;
								if (!_tmp227_) {
									gint _tmp228_;
									_tmp228_ = k;
									k = _tmp228_ + 1;
								}
								_tmp227_ = FALSE;
								_tmp229_ = k;
								_tmp230_ = i;
								if (!(_tmp229_ < _tmp230_)) {
									break;
								}
								_tmp231_ = parameters;
								_tmp232_ = k;
								_tmp233_ = vala_list_get (_tmp231_, _tmp232_);
								_tmp234_ = (ValaGirParserParameterInfo*) _tmp233_;
								_tmp235_ = last_idx;
								_tmp236_ = j;
								_tmp237_ = last_idx;
								_tmp238_ = i;
								_tmp239_ = last;
								_tmp240_ = k;
								_tmp241_ = last;
								_tmp234_->vala_idx = _tmp235_ + (((_tmp236_ - _tmp237_) / (_tmp238_ - _tmp239_)) * (_tmp240_ - _tmp241_));
								_vala_gir_parser_parameter_info_unref0 (_tmp234_);
							}
						}
					}
					_tmp242_ = i;
					last = _tmp242_;
					_tmp243_ = j;
					j = _tmp243_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp244_;
					ValaGirParserParameterInfo* _tmp245_;
					gint _tmp246_;
					gint _tmp247_;
					gint _tmp248_;
					_tmp244_ = info;
					_tmp244_->keep = FALSE;
					_tmp245_ = info;
					_tmp246_ = j;
					_tmp247_ = i;
					_tmp248_ = last;
					_tmp245_->vala_idx = (_tmp246_ - 1) + ((_tmp247_ - _tmp248_) * 0.1F);
				}
			}
			_tmp249_ = i;
			i = _tmp249_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp250_;
		ValaList* _tmp251_;
		gint _info_size = 0;
		ValaList* _tmp252_;
		gint _tmp253_;
		gint _tmp254_;
		gint _info_index = 0;
		_tmp250_ = parameters;
		_tmp251_ = _vala_iterable_ref0 (_tmp250_);
		_info_list = _tmp251_;
		_tmp252_ = _info_list;
		_tmp253_ = vala_collection_get_size ((ValaCollection*) _tmp252_);
		_tmp254_ = _tmp253_;
		_info_size = _tmp254_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp255_;
			gint _tmp256_;
			gint _tmp257_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp258_;
			gint _tmp259_;
			gpointer _tmp260_;
			ValaGirParserParameterInfo* _tmp261_;
			gboolean _tmp262_;
			ValaSymbol* _tmp263_;
			ValaGirParserParameterInfo* _tmp267_;
			gint _tmp268_;
			ValaGirParserParameterInfo* _tmp285_;
			gint _tmp286_;
			ValaGirParserParameterInfo* _tmp317_;
			gint _tmp318_;
			ValaGirParserParameterInfo* _tmp349_;
			gboolean _tmp350_;
			_tmp255_ = _info_index;
			_info_index = _tmp255_ + 1;
			_tmp256_ = _info_index;
			_tmp257_ = _info_size;
			if (!(_tmp256_ < _tmp257_)) {
				break;
			}
			_tmp258_ = _info_list;
			_tmp259_ = _info_index;
			_tmp260_ = vala_list_get (_tmp258_, _tmp259_);
			info = (ValaGirParserParameterInfo*) _tmp260_;
			_tmp261_ = info;
			_tmp262_ = _tmp261_->keep;
			if (!_tmp262_) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp263_ = s;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_CALLABLE)) {
				ValaSymbol* _tmp264_;
				ValaGirParserParameterInfo* _tmp265_;
				ValaParameter* _tmp266_;
				_tmp264_ = s;
				_tmp265_ = info;
				_tmp266_ = _tmp265_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_CALLABLE, ValaCallable), _tmp266_);
			}
			_tmp267_ = info;
			_tmp268_ = _tmp267_->array_length_idx;
			if (_tmp268_ != -1) {
				ValaGirParserParameterInfo* _tmp269_;
				gint _tmp270_;
				ValaList* _tmp271_;
				gint _tmp272_;
				gint _tmp273_;
				ValaGirParserParameterInfo* _tmp278_;
				ValaParameter* _tmp279_;
				ValaList* _tmp280_;
				ValaGirParserParameterInfo* _tmp281_;
				gint _tmp282_;
				gpointer _tmp283_;
				ValaGirParserParameterInfo* _tmp284_;
				_tmp269_ = info;
				_tmp270_ = _tmp269_->array_length_idx;
				_tmp271_ = parameters;
				_tmp272_ = vala_collection_get_size ((ValaCollection*) _tmp271_);
				_tmp273_ = _tmp272_;
				if (_tmp270_ >= _tmp273_) {
					ValaGirParserParameterInfo* _tmp274_;
					ValaParameter* _tmp275_;
					ValaSourceReference* _tmp276_;
					ValaSourceReference* _tmp277_;
					_tmp274_ = info;
					_tmp275_ = _tmp274_->param;
					_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp275_);
					_tmp277_ = _tmp276_;
					vala_report_error (_tmp277_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp278_ = info;
				_tmp279_ = _tmp278_->param;
				_tmp280_ = parameters;
				_tmp281_ = info;
				_tmp282_ = _tmp281_->array_length_idx;
				_tmp283_ = vala_list_get (_tmp280_, _tmp282_);
				_tmp284_ = (ValaGirParserParameterInfo*) _tmp283_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp279_, _tmp284_);
				_vala_gir_parser_parameter_info_unref0 (_tmp284_);
			}
			_tmp285_ = info;
			_tmp286_ = _tmp285_->closure_idx;
			if (_tmp286_ != -1) {
				ValaGirParserParameterInfo* _tmp287_;
				gint _tmp288_;
				ValaList* _tmp289_;
				gint _tmp290_;
				gint _tmp291_;
				ValaList* _tmp296_;
				ValaGirParserParameterInfo* _tmp297_;
				gint _tmp298_;
				gpointer _tmp299_;
				ValaGirParserParameterInfo* _tmp300_;
				gfloat _tmp301_;
				gchar* _tmp302_;
				gchar* _tmp303_;
				ValaGirParserParameterInfo* _tmp304_;
				gfloat _tmp305_;
				gchar* _tmp306_;
				gchar* _tmp307_;
				gboolean _tmp308_;
				_tmp287_ = info;
				_tmp288_ = _tmp287_->closure_idx;
				_tmp289_ = parameters;
				_tmp290_ = vala_collection_get_size ((ValaCollection*) _tmp289_);
				_tmp291_ = _tmp290_;
				if (_tmp288_ >= _tmp291_) {
					ValaGirParserParameterInfo* _tmp292_;
					ValaParameter* _tmp293_;
					ValaSourceReference* _tmp294_;
					ValaSourceReference* _tmp295_;
					_tmp292_ = info;
					_tmp293_ = _tmp292_->param;
					_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp293_);
					_tmp295_ = _tmp294_;
					vala_report_error (_tmp295_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp296_ = parameters;
				_tmp297_ = info;
				_tmp298_ = _tmp297_->closure_idx;
				_tmp299_ = vala_list_get (_tmp296_, _tmp298_);
				_tmp300_ = (ValaGirParserParameterInfo*) _tmp299_;
				_tmp301_ = _tmp300_->vala_idx;
				_tmp302_ = g_strdup_printf ("%g", (gdouble) _tmp301_);
				_tmp303_ = _tmp302_;
				_tmp304_ = info;
				_tmp305_ = _tmp304_->vala_idx;
				_tmp306_ = g_strdup_printf ("%g", _tmp305_ + 0.1);
				_tmp307_ = _tmp306_;
				_tmp308_ = g_strcmp0 (_tmp303_, _tmp307_) != 0;
				_g_free0 (_tmp307_);
				_g_free0 (_tmp303_);
				_vala_gir_parser_parameter_info_unref0 (_tmp300_);
				if (_tmp308_) {
					ValaGirParserParameterInfo* _tmp309_;
					ValaParameter* _tmp310_;
					ValaList* _tmp311_;
					ValaGirParserParameterInfo* _tmp312_;
					gint _tmp313_;
					gpointer _tmp314_;
					ValaGirParserParameterInfo* _tmp315_;
					gfloat _tmp316_;
					_tmp309_ = info;
					_tmp310_ = _tmp309_->param;
					_tmp311_ = parameters;
					_tmp312_ = info;
					_tmp313_ = _tmp312_->closure_idx;
					_tmp314_ = vala_list_get (_tmp311_, _tmp313_);
					_tmp315_ = (ValaGirParserParameterInfo*) _tmp314_;
					_tmp316_ = _tmp315_->vala_idx;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp310_, "CCode", "delegate_target_pos", (gdouble) _tmp316_, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp315_);
				}
			}
			_tmp317_ = info;
			_tmp318_ = _tmp317_->destroy_idx;
			if (_tmp318_ != -1) {
				ValaGirParserParameterInfo* _tmp319_;
				gint _tmp320_;
				ValaList* _tmp321_;
				gint _tmp322_;
				gint _tmp323_;
				ValaList* _tmp328_;
				ValaGirParserParameterInfo* _tmp329_;
				gint _tmp330_;
				gpointer _tmp331_;
				ValaGirParserParameterInfo* _tmp332_;
				gfloat _tmp333_;
				gchar* _tmp334_;
				gchar* _tmp335_;
				ValaGirParserParameterInfo* _tmp336_;
				gfloat _tmp337_;
				gchar* _tmp338_;
				gchar* _tmp339_;
				gboolean _tmp340_;
				_tmp319_ = info;
				_tmp320_ = _tmp319_->destroy_idx;
				_tmp321_ = parameters;
				_tmp322_ = vala_collection_get_size ((ValaCollection*) _tmp321_);
				_tmp323_ = _tmp322_;
				if (_tmp320_ >= _tmp323_) {
					ValaGirParserParameterInfo* _tmp324_;
					ValaParameter* _tmp325_;
					ValaSourceReference* _tmp326_;
					ValaSourceReference* _tmp327_;
					_tmp324_ = info;
					_tmp325_ = _tmp324_->param;
					_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp325_);
					_tmp327_ = _tmp326_;
					vala_report_error (_tmp327_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp328_ = parameters;
				_tmp329_ = info;
				_tmp330_ = _tmp329_->destroy_idx;
				_tmp331_ = vala_list_get (_tmp328_, _tmp330_);
				_tmp332_ = (ValaGirParserParameterInfo*) _tmp331_;
				_tmp333_ = _tmp332_->vala_idx;
				_tmp334_ = g_strdup_printf ("%g", (gdouble) _tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = info;
				_tmp337_ = _tmp336_->vala_idx;
				_tmp338_ = g_strdup_printf ("%g", _tmp337_ + 0.2);
				_tmp339_ = _tmp338_;
				_tmp340_ = g_strcmp0 (_tmp335_, _tmp339_) != 0;
				_g_free0 (_tmp339_);
				_g_free0 (_tmp335_);
				_vala_gir_parser_parameter_info_unref0 (_tmp332_);
				if (_tmp340_) {
					ValaGirParserParameterInfo* _tmp341_;
					ValaParameter* _tmp342_;
					ValaList* _tmp343_;
					ValaGirParserParameterInfo* _tmp344_;
					gint _tmp345_;
					gpointer _tmp346_;
					ValaGirParserParameterInfo* _tmp347_;
					gfloat _tmp348_;
					_tmp341_ = info;
					_tmp342_ = _tmp341_->param;
					_tmp343_ = parameters;
					_tmp344_ = info;
					_tmp345_ = _tmp344_->destroy_idx;
					_tmp346_ = vala_list_get (_tmp343_, _tmp345_);
					_tmp347_ = (ValaGirParserParameterInfo*) _tmp346_;
					_tmp348_ = _tmp347_->vala_idx;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp342_, "CCode", "destroy_notify_pos", (gdouble) _tmp348_, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp347_);
				}
			}
			_tmp349_ = info;
			_tmp350_ = _tmp349_->is_async;
			if (_tmp350_) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp351_;
				ValaParameter* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				ValaDataType* _tmp355_;
				ValaDataType* _tmp356_;
				ValaDataType* _tmp365_;
				_tmp351_ = info;
				_tmp352_ = _tmp351_->param;
				_tmp353_ = vala_variable_get_variable_type ((ValaVariable*) _tmp352_);
				_tmp354_ = _tmp353_;
				_tmp355_ = _vala_code_node_ref0 (_tmp354_);
				resolved_type = _tmp355_;
				_tmp356_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp356_, VALA_TYPE_UNRESOLVED_TYPE)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp357_;
					ValaDataType* _tmp358_;
					ValaUnresolvedSymbol* _tmp359_;
					ValaUnresolvedSymbol* _tmp360_;
					ValaSymbol* _tmp361_;
					ValaSymbol* _tmp362_;
					_tmp357_ = node->parent;
					_tmp358_ = resolved_type;
					_tmp359_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp358_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_gir_parser_resolve_symbol (self, _tmp357_, _tmp360_);
					resolved_symbol = _tmp361_;
					_tmp362_ = resolved_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp362_, VALA_TYPE_DELEGATE)) {
						ValaSymbol* _tmp363_;
						ValaDelegateType* _tmp364_;
						_tmp363_ = resolved_symbol;
						_tmp364_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp363_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp364_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp365_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp365_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp366_;
					ValaDelegate* _tmp367_;
					ValaDelegate* _tmp368_;
					ValaDelegate* _tmp369_;
					gboolean _tmp370_ = FALSE;
					ValaDelegate* _tmp371_;
					const gchar* _tmp372_;
					const gchar* _tmp373_;
					_tmp366_ = resolved_type;
					_tmp367_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp366_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp368_ = _tmp367_;
					_tmp369_ = _vala_code_node_ref0 (_tmp368_);
					d = _tmp369_;
					_tmp371_ = d;
					_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
					_tmp373_ = _tmp372_;
					if (g_strcmp0 (_tmp373_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp374_;
						ValaSymbol* _tmp375_;
						ValaSymbol* _tmp376_;
						const gchar* _tmp377_;
						const gchar* _tmp378_;
						_tmp374_ = d;
						_tmp375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp374_);
						_tmp376_ = _tmp375_;
						_tmp377_ = vala_symbol_get_name (_tmp376_);
						_tmp378_ = _tmp377_;
						_tmp370_ = g_strcmp0 (_tmp378_, "GLib") == 0;
					} else {
						_tmp370_ = FALSE;
					}
					if (!_tmp370_) {
						ValaGirParserParameterInfo* _tmp379_;
						ValaParameter* _tmp380_;
						gboolean _tmp381_ = FALSE;
						ValaGirParserParameterInfo* _tmp382_;
						gint _tmp383_;
						ValaGirParserParameterInfo* _tmp386_;
						ValaParameter* _tmp387_;
						ValaDataType* _tmp388_;
						ValaDataType* _tmp389_;
						_tmp379_ = info;
						_tmp380_ = _tmp379_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp380_, "CCode", "scope", "async", NULL);
						_tmp382_ = info;
						_tmp383_ = _tmp382_->closure_idx;
						if (_tmp383_ != -1) {
							ValaGirParserParameterInfo* _tmp384_;
							gint _tmp385_;
							_tmp384_ = info;
							_tmp385_ = _tmp384_->destroy_idx;
							_tmp381_ = _tmp385_ != -1;
						} else {
							_tmp381_ = FALSE;
						}
						_tmp386_ = info;
						_tmp387_ = _tmp386_->param;
						_tmp388_ = vala_variable_get_variable_type ((ValaVariable*) _tmp387_);
						_tmp389_ = _tmp388_;
						vala_data_type_set_value_owned (_tmp389_, _tmp381_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp390_;
				ValaParameter* _tmp391_;
				ValaDataType* _tmp392_;
				ValaDataType* _tmp393_;
				ValaDataType* _tmp394_;
				ValaDataType* _tmp395_;
				_tmp390_ = info;
				_tmp391_ = _tmp390_->param;
				_tmp392_ = vala_variable_get_variable_type ((ValaVariable*) _tmp391_);
				_tmp393_ = _tmp392_;
				_tmp394_ = _vala_code_node_ref0 (_tmp393_);
				resolved_type = _tmp394_;
				_tmp395_ = resolved_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp395_, VALA_TYPE_DELEGATE_TYPE)) {
					gboolean _tmp396_ = FALSE;
					ValaGirParserParameterInfo* _tmp397_;
					gint _tmp398_;
					ValaGirParserParameterInfo* _tmp401_;
					ValaParameter* _tmp402_;
					ValaDataType* _tmp403_;
					ValaDataType* _tmp404_;
					_tmp397_ = info;
					_tmp398_ = _tmp397_->closure_idx;
					if (_tmp398_ != -1) {
						ValaGirParserParameterInfo* _tmp399_;
						gint _tmp400_;
						_tmp399_ = info;
						_tmp400_ = _tmp399_->destroy_idx;
						_tmp396_ = _tmp400_ != -1;
					} else {
						_tmp396_ = FALSE;
					}
					_tmp401_ = info;
					_tmp402_ = _tmp401_->param;
					_tmp403_ = vala_variable_get_variable_type ((ValaVariable*) _tmp402_);
					_tmp404_ = _tmp403_;
					vala_data_type_set_value_owned (_tmp404_, _tmp396_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp406_ = return_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp406_, VALA_TYPE_ARRAY_TYPE)) {
		gint _tmp407_;
		_tmp407_ = node->return_array_length_idx;
		_tmp405_ = _tmp407_ >= 0;
	} else {
		_tmp405_ = FALSE;
	}
	if (_tmp405_) {
		ValaSymbol* _tmp408_;
		ValaList* _tmp409_;
		gint _tmp410_;
		gpointer _tmp411_;
		ValaGirParserParameterInfo* _tmp412_;
		_tmp408_ = s;
		_tmp409_ = parameters;
		_tmp410_ = node->return_array_length_idx;
		_tmp411_ = vala_list_get (_tmp409_, _tmp410_);
		_tmp412_ = (ValaGirParserParameterInfo*) _tmp411_;
		vala_gir_parser_set_array_ccode (self, _tmp408_, _tmp412_);
		_vala_gir_parser_parameter_info_unref0 (_tmp412_);
	}
	_tmp413_ = s;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp413_, VALA_TYPE_CALLABLE)) {
		ValaSymbol* _tmp414_;
		ValaDataType* _tmp415_;
		_tmp414_ = s;
		_tmp415_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_CALLABLE, ValaCallable), _tmp415_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}


static void
vala_gir_parser_find_parent (ValaGirParser* self, 
                             const gchar* cname, 
                             ValaGirParserNode* current, 
                             ValaGirParserNode* * best, 
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp23_;
	gint current_match = 0;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_NAMESPACE)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			ValaArrayList* _tmp3_;
			gint _child_size = 0;
			ValaArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_tmp3_ = _vala_iterable_ref0 (_tmp2_);
			_child_list = _tmp3_;
			_tmp4_ = _child_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_child_size = _tmp6_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				ValaGirParserNode* _tmp15_;
				ValaSymbol* _tmp16_;
				_tmp7_ = _child_index;
				_child_index = _tmp7_ + 1;
				_tmp8_ = _child_index;
				_tmp9_ = _child_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _child_list;
				_tmp11_ = _child_index;
				_tmp12_ = vala_list_get ((ValaList*) _tmp10_, _tmp11_);
				child = (ValaGirParserNode*) _tmp12_;
				_tmp15_ = child;
				_tmp16_ = _tmp15_->symbol;
				if (_tmp16_ == NULL) {
					_tmp14_ = TRUE;
				} else {
					ValaGirParserNode* _tmp17_;
					ValaSymbol* _tmp18_;
					_tmp17_ = child;
					_tmp18_ = _tmp17_->symbol;
					_tmp14_ = vala_gir_parser_is_container (_tmp18_);
				}
				if (_tmp14_) {
					ValaGirParserNode* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp19_ = child;
					_tmp20_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp13_ = g_str_has_prefix (cname, _tmp21_);
					_g_free0 (_tmp21_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					ValaGirParserNode* _tmp22_;
					_tmp22_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp22_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	}
	_tmp23_ = old_best;
	if ((*best) != _tmp23_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp24_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp25_ = _tmp24_;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp25_);
	current_match = _tmp28_;
	_tmp29_ = current_match;
	if (_tmp29_ > (*match)) {
		gint _tmp30_;
		ValaGirParserNode* _tmp31_;
		_tmp30_ = current_match;
		*match = _tmp30_;
		_tmp31_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp31_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}


static gboolean
string_contains (const gchar* self, 
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean
vala_gir_parser_same_gir (ValaGirParser* self, 
                          ValaSymbol* gir_component, 
                          ValaSymbol* sym)
{
	gboolean result = FALSE;
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}


static void
vala_gir_parser_process_namespace_method (ValaGirParser* self, 
                                          ValaGirParserNode* ns, 
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaMethod* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp14_ = FALSE;
	ValaParameter* _tmp15_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp72_;
	const gchar* _tmp73_;
	gchar* new_name = NULL;
	ValaMethod* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	ValaGirParserNode* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	const gchar* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gboolean _tmp87_ = FALSE;
	ValaMethod* _tmp88_;
	ValaGirParserNode* _tmp89_;
	ValaSymbol* _tmp90_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = method;
	_tmp5_ = vala_callable_get_parameters ((ValaCallable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ > 0;
	_vala_iterable_unref0 (_tmp6_);
	if (_tmp9_) {
		ValaMethod* _tmp10_;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gpointer _tmp13_;
		_tmp10_ = method;
		_tmp11_ = vala_callable_get_parameters ((ValaCallable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_list_get (_tmp12_, 0);
		_vala_code_node_unref0 (first_param);
		first_param = (ValaParameter*) _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
	}
	_tmp15_ = first_param;
	if (_tmp15_ != NULL) {
		ValaParameter* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp16_ = first_param;
		_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_UNRESOLVED_TYPE);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaUnresolvedSymbol* _tmp22_;
		ValaUnresolvedSymbol* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp25_;
		ValaGirParserNode* _tmp26_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaGirParserNode* _tmp31_;
		_tmp19_ = first_param;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp23_ = _tmp22_;
		_tmp24_ = _vala_code_node_ref0 (_tmp23_);
		sym = _tmp24_;
		_tmp25_ = sym;
		_tmp26_ = vala_gir_parser_resolve_node (self, ns, _tmp25_, FALSE);
		parent = _tmp26_;
		_tmp31_ = parent;
		if (_tmp31_ != NULL) {
			ValaMethod* _tmp32_;
			ValaGirParserNode* _tmp33_;
			ValaSymbol* _tmp34_;
			_tmp32_ = method;
			_tmp33_ = parent;
			_tmp34_ = _tmp33_->symbol;
			_tmp30_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp32_, _tmp34_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaGirParserNode* _tmp35_;
			ValaGirParserNode* _tmp36_;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->parent;
			_tmp29_ = _tmp36_ == ns;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaGirParserNode* _tmp37_;
			ValaSymbol* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->symbol;
			_tmp28_ = vala_gir_parser_is_container (_tmp38_);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			const gchar* _tmp39_;
			ValaGirParserNode* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp39_ = cname;
			_tmp40_ = parent;
			_tmp41_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp27_ = g_str_has_prefix (_tmp39_, _tmp42_);
			_g_free0 (_tmp42_);
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			ValaGirParserNode* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			const gchar* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			ValaGirParserNode* _tmp56_;
			const gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			ValaGirParserNode* _tmp59_;
			gboolean _tmp60_;
			_tmp43_ = method;
			_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = parent;
			_tmp47_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = strlen (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = ns_cprefix;
			_tmp52_ = strlen (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = string_substring (_tmp45_, (glong) (_tmp50_ - _tmp53_), (glong) -1);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp48_);
			new_name = _tmp55_;
			_tmp56_ = parent;
			_tmp57_ = new_name;
			_tmp58_ = vala_gir_parser_node_lookup (_tmp56_, _tmp57_, FALSE, NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = _tmp59_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp59_);
			if (_tmp60_) {
				const gchar* _tmp61_;
				gchar* _tmp62_;
				ValaMethod* _tmp63_;
				const gchar* _tmp64_;
				ValaMethod* _tmp65_;
				ValaList* _tmp66_;
				ValaList* _tmp67_;
				gpointer _tmp68_;
				ValaParameter* _tmp69_;
				ValaMethod* _tmp70_;
				ValaGirParserNode* _tmp71_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp61_ = new_name;
				_tmp62_ = g_strdup (_tmp61_);
				_g_free0 (node->name);
				node->name = _tmp62_;
				_tmp63_ = method;
				_tmp64_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp63_, _tmp64_);
				_tmp65_ = method;
				_tmp66_ = vala_callable_get_parameters ((ValaCallable*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_list_remove_at (_tmp67_, 0);
				_tmp69_ = (ValaParameter*) _tmp68_;
				_vala_code_node_unref0 (_tmp69_);
				_vala_iterable_unref0 (_tmp67_);
				_tmp70_ = method;
				vala_method_set_binding (_tmp70_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp71_ = parent;
				vala_gir_parser_node_add_member (_tmp71_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp72_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp72_;
	_tmp73_ = cname;
	vala_gir_parser_find_parent (self, _tmp73_, ns, &parent, &match);
	_tmp74_ = method;
	_tmp75_ = vala_symbol_get_name ((ValaSymbol*) _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = parent;
	_tmp78_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = strlen (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = ns_cprefix;
	_tmp83_ = strlen (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = string_substring (_tmp76_, (glong) (_tmp81_ - _tmp84_), (glong) -1);
	_tmp86_ = _tmp85_;
	_g_free0 (_tmp79_);
	new_name = _tmp86_;
	_tmp88_ = method;
	_tmp89_ = parent;
	_tmp90_ = _tmp89_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp88_, _tmp90_)) {
		ValaGirParserNode* _tmp91_;
		const gchar* _tmp92_;
		ValaGirParserNode* _tmp93_;
		ValaGirParserNode* _tmp94_;
		_tmp91_ = parent;
		_tmp92_ = new_name;
		_tmp93_ = vala_gir_parser_node_lookup (_tmp91_, _tmp92_, FALSE, NULL);
		_tmp94_ = _tmp93_;
		_tmp87_ = _tmp94_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp94_);
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		const gchar* _tmp95_;
		gchar* _tmp96_;
		ValaMethod* _tmp97_;
		const gchar* _tmp98_;
		ValaGirParserNode* _tmp99_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp95_ = new_name;
		_tmp96_ = g_strdup (_tmp95_);
		_g_free0 (node->name);
		node->name = _tmp96_;
		_tmp97_ = method;
		_tmp98_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp97_, _tmp98_);
		_tmp99_ = parent;
		vala_gir_parser_node_add_member (_tmp99_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}


static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self, 
                                              ValaGirParserNode* node, 
                                              ValaDelegate* d, 
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp7_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp14_ = gtype_node;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_gir_parser_node_lookup_all (_tmp14_, _tmp16_);
	nodes = _tmp17_;
	_tmp18_ = nodes;
	if (_tmp18_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp19_;
		ValaArrayList* _tmp20_;
		gint _n_size = 0;
		ValaArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _n_index = 0;
		_tmp19_ = nodes;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_n_list = _tmp20_;
		_tmp21_ = _n_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_n_size = _tmp23_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaGirParserNode* _tmp30_;
			_tmp24_ = _n_index;
			_n_index = _tmp24_ + 1;
			_tmp25_ = _n_index;
			_tmp26_ = _n_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _n_list;
			_tmp28_ = _n_index;
			_tmp29_ = vala_list_get ((ValaList*) _tmp27_, _tmp28_);
			n = (ValaGirParserNode*) _tmp29_;
			_tmp30_ = n;
			if (node != _tmp30_) {
				ValaGirParserNode* _tmp31_;
				_tmp31_ = n;
				vala_gir_parser_node_process (_tmp31_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp32_;
		ValaArrayList* _tmp33_;
		gint _n_size = 0;
		ValaArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _n_index = 0;
		_tmp32_ = nodes;
		_tmp33_ = _vala_iterable_ref0 (_tmp32_);
		_n_list = _tmp33_;
		_tmp34_ = _n_list;
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_n_size = _tmp36_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp40_;
			gint _tmp41_;
			gpointer _tmp42_;
			ValaGirParserNode* _tmp43_;
			gboolean _tmp44_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp45_;
			ValaSymbol* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaSymbol* _tmp48_;
			_tmp37_ = _n_index;
			_n_index = _tmp37_ + 1;
			_tmp38_ = _n_index;
			_tmp39_ = _n_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _n_list;
			_tmp41_ = _n_index;
			_tmp42_ = vala_list_get ((ValaList*) _tmp40_, _tmp41_);
			n = (ValaGirParserNode*) _tmp42_;
			_tmp43_ = n;
			_tmp44_ = _tmp43_->merged;
			if (_tmp44_) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp45_ = n;
			_tmp46_ = _tmp45_->symbol;
			_tmp47_ = _vala_code_node_ref0 (_tmp46_);
			sym = _tmp47_;
			_tmp48_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp49_;
				ValaSignal* _tmp50_;
				ValaSignal* _tmp51_;
				ValaSignal* _tmp52_;
				_tmp49_ = sym;
				_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp50_;
				_tmp51_ = sig;
				vala_signal_set_is_virtual (_tmp51_, TRUE);
				_tmp52_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp52_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp53_;
				_tmp53_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_PROPERTY)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp54_;
					ValaProperty* _tmp55_;
					ValaProperty* _tmp56_;
					_tmp54_ = sym;
					_tmp55_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp55_;
					_tmp56_ = prop;
					vala_property_set_is_virtual (_tmp56_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}


static void
vala_gir_parser_process_async_method (ValaGirParser* self, 
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	ValaGirParserNode* _tmp29_;
	ValaGirParserNode* _tmp30_;
	ValaGirParserNode* _tmp31_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp54_;
	ValaMethod* _tmp55_;
	gboolean _tmp56_ = FALSE;
	ValaGirParserNode* _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		ValaMethod* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = m;
		_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CREATION_METHOD), "m is CreationMethod");
		_tmp6_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp6_;
	} else {
		ValaMethod* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (g_str_has_suffix (_tmp9_, "_async")) {
			ValaMethod* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			ValaMethod* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			_tmp10_ = m;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = m;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = strlen (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = strlen ("_async");
			_tmp19_ = _tmp18_;
			_tmp20_ = string_substring (_tmp12_, (glong) 0, (glong) (_tmp17_ - _tmp19_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp20_;
		} else {
			ValaMethod* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = m;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp24_;
		}
	}
	_tmp25_ = node->parent;
	_tmp26_ = finish_method_base;
	_tmp27_ = g_strconcat (_tmp26_, "_finish", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_gir_parser_node_lookup (_tmp25_, _tmp28_, FALSE, NULL);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	finish_method_node = _tmp30_;
	_tmp31_ = finish_method_node;
	if (_tmp31_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp32_;
		_tmp32_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp32_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp33_;
			ValaArrayList* _tmp34_;
			ValaArrayList* _tmp35_;
			gint _n_size = 0;
			ValaArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _n_index = 0;
			_tmp33_ = node->parent;
			_tmp34_ = _tmp33_->members;
			_tmp35_ = _vala_iterable_ref0 (_tmp34_);
			_n_list = _tmp35_;
			_tmp36_ = _n_list;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_n_size = _tmp38_;
			_n_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_;
				gboolean _tmp45_ = FALSE;
				ValaGirParserNode* _tmp46_;
				ValaSymbol* _tmp47_;
				_tmp39_ = _n_index;
				_n_index = _tmp39_ + 1;
				_tmp40_ = _n_index;
				_tmp41_ = _n_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _n_list;
				_tmp43_ = _n_index;
				_tmp44_ = vala_list_get ((ValaList*) _tmp42_, _tmp43_);
				n = (ValaGirParserNode*) _tmp44_;
				_tmp46_ = n;
				_tmp47_ = _tmp46_->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_METHOD)) {
					ValaGirParserNode* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					const gchar* _tmp51_;
					_tmp48_ = n;
					_tmp49_ = vala_gir_parser_node_get_cname (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = method_cname;
					_tmp45_ = g_strcmp0 (_tmp50_, _tmp51_) == 0;
					_g_free0 (_tmp50_);
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					ValaGirParserNode* _tmp52_;
					ValaGirParserNode* _tmp53_;
					_tmp52_ = n;
					_tmp53_ = _vala_gir_parser_node_ref0 (_tmp52_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp53_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
			_vala_iterable_unref0 (_n_list);
		}
		_g_free0 (method_cname);
	}
	_tmp54_ = m;
	_tmp55_ = _vala_code_node_ref0 (_tmp54_);
	method = _tmp55_;
	_tmp57_ = finish_method_node;
	if (_tmp57_ != NULL) {
		ValaGirParserNode* _tmp58_;
		ValaSymbol* _tmp59_;
		_tmp58_ = finish_method_node;
		_tmp59_ = _tmp58_->symbol;
		_tmp56_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, VALA_TYPE_METHOD);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaGirParserNode* _tmp60_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp61_;
		ValaSymbol* _tmp62_;
		ValaMethod* _tmp63_;
		ValaMethod* _tmp64_;
		ValaGirParserNode* _tmp187_;
		ValaGirParserNode* _tmp188_;
		_tmp60_ = finish_method_node;
		vala_gir_parser_node_process (_tmp60_, self);
		_tmp61_ = finish_method_node;
		_tmp62_ = _tmp61_->symbol;
		_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp63_;
		_tmp64_ = finish_method;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			ValaMethod* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaSourceReference* _tmp70_;
			ValaCreationMethod* _tmp71_;
			ValaMethod* _tmp72_;
			ValaMethod* _tmp73_;
			ValaSymbolAccessibility _tmp74_;
			ValaSymbolAccessibility _tmp75_;
			ValaMethod* _tmp76_;
			ValaMethod* _tmp77_;
			ValaMemberBinding _tmp78_;
			ValaMemberBinding _tmp79_;
			ValaMethod* _tmp80_;
			ValaMethod* _tmp81_;
			ValaMethod* _tmp82_;
			ValaMethod* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			ValaMethod* _tmp86_;
			GList* _tmp87_;
			ValaMethod* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			const gchar* _tmp95_;
			ValaMethod* _tmp119_;
			ValaSymbol* _tmp120_;
			_tmp65_ = finish_method;
			_tmp66_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp67_ = _tmp66_;
			_tmp68_ = m;
			_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_creation_method_new (_tmp67_, NULL, _tmp70_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp71_;
			_tmp72_ = method;
			_tmp73_ = m;
			_tmp74_ = vala_symbol_get_access ((ValaSymbol*) _tmp73_);
			_tmp75_ = _tmp74_;
			vala_symbol_set_access ((ValaSymbol*) _tmp72_, _tmp75_);
			_tmp76_ = method;
			_tmp77_ = m;
			_tmp78_ = vala_method_get_binding (_tmp77_);
			_tmp79_ = _tmp78_;
			vala_method_set_binding (_tmp76_, _tmp79_);
			_tmp80_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp80_, TRUE);
			_tmp81_ = method;
			vala_method_set_coroutine (_tmp81_, TRUE);
			_tmp82_ = method;
			_tmp83_ = finish_method;
			_tmp84_ = vala_method_get_has_construct_function (_tmp83_);
			_tmp85_ = _tmp84_;
			vala_method_set_has_construct_function (_tmp82_, _tmp85_);
			_tmp86_ = m;
			_tmp87_ = ((ValaCodeNode*) _tmp86_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp87_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp88_;
					ValaAttribute* a = NULL;
					_tmp88_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp88_;
					{
						ValaMethod* _tmp89_;
						ValaAttribute* _tmp90_;
						ValaAttribute* _tmp91_;
						_tmp89_ = method;
						_tmp90_ = a;
						_tmp91_ = _vala_code_node_ref0 (_tmp90_);
						((ValaCodeNode*) _tmp89_)->attributes = g_list_append (((ValaCodeNode*) _tmp89_)->attributes, _tmp91_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp92_ = method;
			_tmp93_ = vala_gir_parser_node_get_cname (node);
			_tmp94_ = _tmp93_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "cname", _tmp94_, NULL);
			_g_free0 (_tmp94_);
			_tmp95_ = finish_method_base;
			if (g_strcmp0 (_tmp95_, "new") == 0) {
				ValaMethod* _tmp96_;
				_tmp96_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp96_, NULL);
			} else {
				const gchar* _tmp97_;
				_tmp97_ = finish_method_base;
				if (g_str_has_prefix (_tmp97_, "new_")) {
					ValaMethod* _tmp98_;
					ValaMethod* _tmp99_;
					const gchar* _tmp100_;
					const gchar* _tmp101_;
					gint _tmp102_;
					gint _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					_tmp98_ = method;
					_tmp99_ = m;
					_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = strlen ("new_");
					_tmp103_ = _tmp102_;
					_tmp104_ = string_substring (_tmp101_, (glong) _tmp103_, (glong) -1);
					_tmp105_ = _tmp104_;
					vala_symbol_set_name ((ValaSymbol*) _tmp98_, _tmp105_);
					_g_free0 (_tmp105_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp106_;
				ValaList* _tmp107_;
				gint _param_size = 0;
				ValaList* _tmp108_;
				gint _tmp109_;
				gint _tmp110_;
				gint _param_index = 0;
				_tmp106_ = m;
				_tmp107_ = vala_callable_get_parameters ((ValaCallable*) _tmp106_);
				_param_list = _tmp107_;
				_tmp108_ = _param_list;
				_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
				_tmp110_ = _tmp109_;
				_param_size = _tmp110_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp111_;
					gint _tmp112_;
					gint _tmp113_;
					ValaParameter* param = NULL;
					ValaList* _tmp114_;
					gint _tmp115_;
					gpointer _tmp116_;
					ValaMethod* _tmp117_;
					ValaParameter* _tmp118_;
					_tmp111_ = _param_index;
					_param_index = _tmp111_ + 1;
					_tmp112_ = _param_index;
					_tmp113_ = _param_size;
					if (!(_tmp112_ < _tmp113_)) {
						break;
					}
					_tmp114_ = _param_list;
					_tmp115_ = _param_index;
					_tmp116_ = vala_list_get (_tmp114_, _tmp115_);
					param = (ValaParameter*) _tmp116_;
					_tmp117_ = method;
					_tmp118_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp117_, _tmp118_);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp119_ = method;
			_tmp120_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp119_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp120_;
		} else {
			ValaMethod* _tmp121_;
			ValaMethod* _tmp122_;
			ValaDataType* _tmp123_;
			ValaDataType* _tmp124_;
			ValaDataType* _tmp125_;
			ValaDataType* _tmp126_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp127_;
			ValaAttribute* _tmp128_;
			gboolean _tmp129_ = FALSE;
			ValaAttribute* _tmp130_;
			gboolean _tmp134_ = FALSE;
			ValaAttribute* _tmp135_;
			_tmp121_ = method;
			_tmp122_ = finish_method;
			_tmp123_ = vala_callable_get_return_type ((ValaCallable*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_data_type_copy (_tmp124_);
			_tmp126_ = _tmp125_;
			vala_callable_set_return_type ((ValaCallable*) _tmp121_, _tmp126_);
			_vala_code_node_unref0 (_tmp126_);
			_tmp127_ = finish_method;
			_tmp128_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp127_, "CCode");
			a = _tmp128_;
			_tmp130_ = a;
			if (_tmp130_ != NULL) {
				ValaAttribute* _tmp131_;
				_tmp131_ = a;
				_tmp129_ = vala_attribute_has_argument (_tmp131_, "array_length");
			} else {
				_tmp129_ = FALSE;
			}
			if (_tmp129_) {
				ValaMethod* _tmp132_;
				ValaAttribute* _tmp133_;
				_tmp132_ = method;
				_tmp133_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp132_, "CCode", "array_length", vala_attribute_get_bool (_tmp133_, "array_length", FALSE), NULL);
			}
			_tmp135_ = a;
			if (_tmp135_ != NULL) {
				ValaAttribute* _tmp136_;
				_tmp136_ = a;
				_tmp134_ = vala_attribute_has_argument (_tmp136_, "array_null_terminated");
			} else {
				_tmp134_ = FALSE;
			}
			if (_tmp134_) {
				ValaMethod* _tmp137_;
				ValaAttribute* _tmp138_;
				_tmp137_ = method;
				_tmp138_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp137_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp138_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp139_;
			ValaList* _tmp140_;
			gint _param_size = 0;
			ValaList* _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			gint _param_index = 0;
			_tmp139_ = finish_method;
			_tmp140_ = vala_callable_get_parameters ((ValaCallable*) _tmp139_);
			_param_list = _tmp140_;
			_tmp141_ = _param_list;
			_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
			_tmp143_ = _tmp142_;
			_param_size = _tmp143_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp144_;
				gint _tmp145_;
				gint _tmp146_;
				ValaParameter* param = NULL;
				ValaList* _tmp147_;
				gint _tmp148_;
				gpointer _tmp149_;
				ValaParameter* _tmp150_;
				ValaParameterDirection _tmp151_;
				ValaParameterDirection _tmp152_;
				_tmp144_ = _param_index;
				_param_index = _tmp144_ + 1;
				_tmp145_ = _param_index;
				_tmp146_ = _param_size;
				if (!(_tmp145_ < _tmp146_)) {
					break;
				}
				_tmp147_ = _param_list;
				_tmp148_ = _param_index;
				_tmp149_ = vala_list_get (_tmp147_, _tmp148_);
				param = (ValaParameter*) _tmp149_;
				_tmp150_ = param;
				_tmp151_ = vala_parameter_get_direction (_tmp150_);
				_tmp152_ = _tmp151_;
				if (_tmp152_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp153_;
					ValaParameter* _tmp154_;
					ValaMethod* _tmp155_;
					ValaScope* _tmp156_;
					ValaScope* _tmp157_;
					ValaParameter* _tmp158_;
					const gchar* _tmp159_;
					const gchar* _tmp160_;
					ValaSymbol* _tmp161_;
					ValaSymbol* _tmp162_;
					gboolean _tmp163_;
					ValaMethod* _tmp170_;
					ValaParameter* _tmp171_;
					_tmp153_ = param;
					_tmp154_ = vala_parameter_copy (_tmp153_);
					async_param = _tmp154_;
					_tmp155_ = method;
					_tmp156_ = vala_symbol_get_scope ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = param;
					_tmp159_ = vala_symbol_get_name ((ValaSymbol*) _tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = vala_scope_lookup (_tmp157_, _tmp160_);
					_tmp162_ = _tmp161_;
					_tmp163_ = _tmp162_ != NULL;
					_vala_code_node_unref0 (_tmp162_);
					if (_tmp163_) {
						ValaParameter* _tmp164_;
						ValaParameter* _tmp165_;
						const gchar* _tmp166_;
						const gchar* _tmp167_;
						gchar* _tmp168_;
						gchar* _tmp169_;
						_tmp164_ = async_param;
						_tmp165_ = async_param;
						_tmp166_ = vala_symbol_get_name ((ValaSymbol*) _tmp165_);
						_tmp167_ = _tmp166_;
						_tmp168_ = g_strconcat (_tmp167_, "_out", NULL);
						_tmp169_ = _tmp168_;
						vala_symbol_set_name ((ValaSymbol*) _tmp165_, _tmp169_);
						_g_free0 (_tmp169_);
					}
					_tmp170_ = method;
					_tmp171_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp170_, _tmp171_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp172_;
			ValaList* _tmp173_;
			gint _error_type_size = 0;
			ValaList* _tmp174_;
			gint _tmp175_;
			gint _tmp176_;
			gint _error_type_index = 0;
			_tmp172_ = finish_method;
			_tmp173_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp172_);
			_error_type_list = _tmp173_;
			_tmp174_ = _error_type_list;
			_tmp175_ = vala_collection_get_size ((ValaCollection*) _tmp174_);
			_tmp176_ = _tmp175_;
			_error_type_size = _tmp176_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp177_;
				gint _tmp178_;
				gint _tmp179_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp180_;
				gint _tmp181_;
				gpointer _tmp182_;
				ValaMethod* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				ValaDataType* _tmp186_;
				_tmp177_ = _error_type_index;
				_error_type_index = _tmp177_ + 1;
				_tmp178_ = _error_type_index;
				_tmp179_ = _error_type_size;
				if (!(_tmp178_ < _tmp179_)) {
					break;
				}
				_tmp180_ = _error_type_list;
				_tmp181_ = _error_type_index;
				_tmp182_ = vala_list_get (_tmp180_, _tmp181_);
				error_type = (ValaDataType*) _tmp182_;
				_tmp183_ = method;
				_tmp184_ = error_type;
				_tmp185_ = vala_data_type_copy (_tmp184_);
				_tmp186_ = _tmp185_;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp183_, _tmp186_);
				_vala_code_node_unref0 (_tmp186_);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_tmp187_ = finish_method_node;
		_tmp187_->processed = TRUE;
		_tmp188_ = finish_method_node;
		_tmp188_->merged = TRUE;
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}


static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	guint result = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}


static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1, 
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}


static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self, 
                                         ValaGirParserNode* prop_node)
{
	ValaGirParserNode* result = NULL;
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp16_;
			ValaDataType* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			ValaUnresolvedSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			gboolean _tmp21_ = FALSE;
			ValaGirParserNode* _tmp22_;
			_tmp9_ = _type_index;
			_type_index = _tmp9_ + 1;
			_tmp10_ = _type_index;
			_tmp11_ = _type_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_list;
			_tmp13_ = _type_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type = (ValaDataType*) _tmp14_;
			_tmp15_ = type;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_UNRESOLVED_TYPE)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp16_ = prop_node->parent;
			_tmp17_ = type;
			_tmp18_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_gir_parser_resolve_node (self, _tmp16_, _tmp19_, FALSE);
			base_node = _tmp20_;
			_tmp22_ = base_node;
			if (_tmp22_ != NULL) {
				ValaGirParserNode* _tmp23_;
				ValaSymbol* _tmp24_;
				_tmp23_ = base_node;
				_tmp24_ = _tmp23_->symbol;
				_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTERFACE);
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp25_;
				const gchar* _tmp26_;
				ValaGirParserNode* _tmp27_;
				gboolean _tmp28_ = FALSE;
				ValaGirParserNode* _tmp29_;
				_tmp25_ = base_node;
				_tmp26_ = prop_node->name;
				_tmp27_ = vala_gir_parser_node_lookup (_tmp25_, _tmp26_, FALSE, NULL);
				base_prop_node = _tmp27_;
				_tmp29_ = base_prop_node;
				if (_tmp29_ != NULL) {
					ValaGirParserNode* _tmp30_;
					ValaSymbol* _tmp31_;
					_tmp30_ = base_prop_node;
					_tmp31_ = _tmp30_->symbol;
					_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_PROPERTY);
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp32_;
					ValaSymbol* _tmp33_;
					ValaProperty* _tmp34_;
					gboolean _tmp35_ = FALSE;
					ValaProperty* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp32_ = base_prop_node;
					_tmp33_ = _tmp32_->symbol;
					_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp34_;
					_tmp36_ = base_property;
					_tmp37_ = vala_property_get_is_abstract (_tmp36_);
					_tmp38_ = _tmp37_;
					if (_tmp38_) {
						_tmp35_ = TRUE;
					} else {
						ValaProperty* _tmp39_;
						gboolean _tmp40_;
						gboolean _tmp41_;
						_tmp39_ = base_property;
						_tmp40_ = vala_property_get_is_virtual (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp35_ = _tmp41_;
					}
					if (_tmp35_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}


ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}


static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}


static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type, 
                                    ValaExpression* expression, 
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}


static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression, 
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}


static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value, 
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value, 
                                              guint n_collect_values, 
                                              GTypeCValue* collect_values, 
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value, 
                                            guint n_collect_values, 
                                            GTypeCValue* collect_values, 
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name, 
                                     const gchar* nick, 
                                     const gchar* blurb, 
                                     GType object_type, 
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_argument (GValue* value, 
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}


static void
vala_gir_parser_value_take_argument (GValue* value, 
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}


static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}


static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self)
{
	self->used = FALSE;
	self->ref_count = 1;
}


static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}


static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_argument_type_id__volatile, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__volatile;
}


static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type, 
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}


static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}


static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self, 
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _child_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaGirParserMetadata* _tmp11_;
			_tmp5_ = _child_index;
			_child_index = _tmp5_ + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = _child_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			child = (ValaGirParserMetadata*) _tmp10_;
			_tmp11_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp11_);
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp12_;
		ValaSet* _tmp13_;
		ValaSet* _tmp14_;
		ValaIterator* _tmp15_;
		ValaIterator* _tmp16_;
		_tmp12_ = metadata->args;
		_tmp13_ = vala_map_get_keys (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_iterable_iterator ((ValaIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_vala_iterable_unref0 (_tmp14_);
		_key_it = _tmp16_;
		while (TRUE) {
			ValaIterator* _tmp17_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp18_;
			gpointer _tmp19_;
			ValaMap* _tmp20_;
			ValaGirParserArgumentType _tmp21_;
			ValaMap* _tmp22_;
			ValaGirParserArgumentType _tmp23_;
			gpointer _tmp24_;
			ValaGirParserArgument* _tmp25_;
			_tmp17_ = _key_it;
			if (!vala_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _key_it;
			_tmp19_ = vala_iterator_get (_tmp18_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp19_);
			_tmp20_ = ((ValaGirParserMetadata*) self)->args;
			_tmp21_ = key;
			_tmp22_ = metadata->args;
			_tmp23_ = key;
			_tmp24_ = vala_map_get (_tmp22_, (gpointer) ((gintptr) _tmp23_));
			_tmp25_ = (ValaGirParserArgument*) _tmp24_;
			vala_map_set (_tmp20_, (gpointer) ((gintptr) _tmp21_), _tmp25_);
			_vala_gir_parser_argument_unref0 (_tmp25_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}


static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}


static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self)
{
}


static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__volatile, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__volatile;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type, 
                                    const gchar* pattern, 
                                    const gchar* selector, 
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern, 
                              const gchar* selector, 
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}


static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self, 
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self, 
                                      const gchar* name, 
                                      const gchar* selector)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_metadata_list = _tmp4_;
		_tmp5_ = _metadata_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_metadata_size = _tmp7_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			_tmp8_ = _metadata_index;
			_metadata_index = _tmp8_ + 1;
			_tmp9_ = _metadata_index;
			_tmp10_ = _metadata_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _metadata_list;
			_tmp12_ = _metadata_index;
			_tmp13_ = vala_list_get ((ValaList*) _tmp11_, _tmp12_);
			metadata = (ValaGirParserMetadata*) _tmp13_;
			if (selector == NULL) {
				_tmp16_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = metadata;
				_tmp18_ = _tmp17_->selector;
				_tmp16_ = _tmp18_ == NULL;
			}
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = metadata;
				_tmp20_ = _tmp19_->selector;
				_tmp15_ = g_strcmp0 (_tmp20_, selector) == 0;
			}
			if (_tmp15_) {
				ValaGirParserMetadata* _tmp21_;
				GPatternSpec* _tmp22_;
				_tmp21_ = metadata;
				_tmp22_ = _tmp21_->pattern_spec;
				_tmp14_ = g_pattern_match_string (_tmp22_, name);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				ValaGirParserMetadata* _tmp23_;
				ValaGirParserMetadata* _tmp24_;
				ValaGirParserMetadata* _tmp25_;
				ValaGirParserMetadata* _tmp26_;
				_tmp23_ = metadata;
				_tmp23_->used = TRUE;
				_tmp24_ = _result_;
				_tmp25_ = vala_gir_parser_metadata_get_empty ();
				_tmp26_ = _tmp25_;
				if (_tmp24_ == _tmp26_) {
					ValaGirParserMetadata* _tmp27_;
					ValaGirParserMetadata* _tmp28_;
					_tmp27_ = metadata;
					_tmp28_ = _vala_gir_parser_metadata_ref0 (_tmp27_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp28_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp29_;
					ValaGirParserMetadataSet* _tmp30_;
					ValaGirParserMetadataSet* _tmp31_;
					ValaGirParserMetadataSet* _tmp35_;
					ValaGirParserMetadata* _tmp36_;
					ValaGirParserMetadataSet* _tmp37_;
					ValaGirParserMetadata* _tmp38_;
					_tmp29_ = _result_;
					_tmp30_ = _vala_gir_parser_metadata_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_GIR_PARSER_TYPE_METADATA_SET) ? ((ValaGirParserMetadataSet*) _tmp29_) : NULL);
					ms = _tmp30_;
					_tmp31_ = ms;
					if (_tmp31_ == NULL) {
						ValaGirParserMetadataSet* _tmp32_;
						ValaGirParserMetadataSet* _tmp33_;
						ValaGirParserMetadata* _tmp34_;
						_tmp32_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp32_;
						_tmp33_ = ms;
						_tmp34_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp33_, _tmp34_);
					}
					_tmp35_ = ms;
					_tmp36_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp35_, _tmp36_);
					_tmp37_ = ms;
					_tmp38_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp37_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp38_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	result = _result_;
	return result;
}


static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self, 
                                       ValaGirParserArgumentType key, 
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}


static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self, 
                                       ValaGirParserArgumentType key)
{
	gboolean result = FALSE;
	ValaMap* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}


static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self, 
                                         ValaGirParserArgumentType arg)
{
	ValaExpression* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}


static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self, 
                                     ValaGirParserArgumentType arg)
{
	gchar* result = NULL;
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}


static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self, 
                                      ValaGirParserArgumentType arg)
{
	gint result = 0;
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_INTEGER_LITERAL) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}


static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self, 
                                   ValaGirParserArgumentType arg, 
                                   gboolean default_value)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}


static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self, 
                                               ValaGirParserArgumentType arg)
{
	ValaSourceReference* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}


static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value, 
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value, 
                                              guint n_collect_values, 
                                              GTypeCValue* collect_values, 
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value, 
                                            guint n_collect_values, 
                                            GTypeCValue* collect_values, 
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name, 
                                     const gchar* nick, 
                                     const gchar* blurb, 
                                     GType object_type, 
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_metadata (GValue* value, 
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}


static void
vala_gir_parser_value_take_metadata (GValue* value, 
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}


static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}


static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}


static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}


static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_type_id__volatile, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__volatile;
}


static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}


static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}


static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaSourceReference* result = NULL;
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}


static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self, 
                                         ValaSourceLocation* begin, 
                                         ValaSourceLocation* end)
{
	ValaSourceReference* result = NULL;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e;
	_tmp5_ = *begin;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp5_, &_tmp4_);
	result = _tmp6_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self, 
                                                ValaSourceFile* metadata_file)
{
	ValaGirParserMetadata* result = NULL;
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		ValaTokenType _tmp1_;
		_tmp1_ = self->priv->current;
		if (!(_tmp1_ != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			ValaGirParserMetadata* _tmp4_;
			_tmp2_ = vala_gir_parser_metadata_get_empty ();
			_tmp3_ = _tmp2_;
			_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = self->priv->tree;
	_tmp6_ = _vala_gir_parser_metadata_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}


static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaTokenType result = 0;
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	_tmp5_ = self->priv->current;
	result = _tmp5_;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	gint _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.line;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.line;
	result = _tmp1_ != _tmp3_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self, 
                                            ValaSourceLocation* begin, 
                                            ValaSourceLocation* end)
{
	gchar* result = NULL;
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self, 
                                                  gboolean is_glob)
{
	gchar* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaTokenType _tmp2_;
	ValaSourceLocation _tmp15_;
	ValaSourceLocation _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp2_ = self->priv->current;
	if (_tmp2_ == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		ValaTokenType _tmp3_;
		_tmp3_ = self->priv->current;
		_tmp1_ = _tmp3_ == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = begin;
			_tmp5_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp4_, NULL);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp6_);
		} else {
			ValaSourceLocation _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = begin;
			_tmp8_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "expected identifier");
			_vala_source_reference_unref0 (_tmp9_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaTokenType _tmp12_;
			_tmp12_ = self->priv->current;
			if (_tmp12_ != VALA_TOKEN_TYPE_EOF) {
				ValaTokenType _tmp13_;
				_tmp13_ = self->priv->current;
				_tmp11_ = _tmp13_ != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaTokenType _tmp14_;
				_tmp14_ = self->priv->current;
				_tmp10_ = _tmp14_ != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp15_ = begin;
	_tmp16_ = self->priv->old_end;
	_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp15_, &_tmp16_);
	result = _tmp17_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->current;
	if (_tmp1_ != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp2_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp2_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	ValaGirParserMetadata* _tmp12_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp15_;
	gchar* pattern = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	gboolean _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	_tmp1_ = self->priv->current;
	if (_tmp1_ == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		ValaTokenType _tmp2_;
		_tmp2_ = self->priv->current;
		_tmp0_ = _tmp2_ == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp3_;
		ValaGirParserMetadata* _tmp4_;
		_tmp3_ = self->priv->tree;
		_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp4_;
	} else {
		ValaTokenType _tmp5_;
		_tmp5_ = self->priv->current;
		if (_tmp5_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaTokenType _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->current;
			_tmp9_ = vala_token_type_to_string (_tmp8_);
			_tmp10_ = g_strdup_printf ("expected pattern or `.', got %s", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_vala_source_reference_unref0 (_tmp7_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp12_ = self->priv->parent_metadata;
	if (_tmp12_ == NULL) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp14_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp15_ = self->priv->begin;
	begin = _tmp15_;
	_tmp16_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp16_;
	_tmp17_ = pattern;
	if (_tmp17_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp18_ = pattern;
	_tmp19_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = begin;
	_tmp22_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gir_parser_metadata_new (_tmp18_, _tmp20_, _tmp23_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp25_ = self->priv->parent_metadata;
	_tmp26_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp25_, _tmp26_);
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		ValaTokenType _tmp28_;
		ValaTokenType _tmp29_;
		ValaSourceLocation _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaSourceLocation _tmp42_;
		ValaSourceLocation _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaGirParserMetadata* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaGirParserMetadata* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		ValaGirParserMetadata* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		_tmp28_ = self->priv->current;
		if (_tmp28_ != VALA_TOKEN_TYPE_EOF) {
			_tmp27_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = self->priv->current;
		if (_tmp29_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaTokenType _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->current;
			_tmp33_ = vala_token_type_to_string (_tmp32_);
			_tmp34_ = g_strdup_printf ("expected `.' got %s", _tmp33_);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_vala_source_reference_unref0 (_tmp31_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp36_ = self->priv->begin;
		begin = _tmp36_;
		_tmp37_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp37_;
		_tmp38_ = pattern;
		if (_tmp38_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp39_ = pattern;
		_tmp40_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = begin;
		_tmp43_ = self->priv->old_end;
		_tmp44_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp42_, &_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_gir_parser_metadata_new (_tmp39_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		_vala_source_reference_unref0 (_tmp45_);
		_g_free0 (_tmp41_);
		child = _tmp47_;
		_tmp48_ = metadata;
		_tmp49_ = child;
		vala_gir_parser_metadata_add_child (_tmp48_, _tmp49_);
		_tmp50_ = child;
		_tmp51_ = _vala_gir_parser_metadata_ref0 (_tmp50_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp51_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	_tmp52_ = is_relative;
	if (!_tmp52_) {
		ValaGirParserMetadata* _tmp53_;
		ValaGirParserMetadata* _tmp54_;
		_tmp53_ = metadata;
		_tmp54_ = _vala_gir_parser_metadata_ref0 (_tmp53_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp54_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}


static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaTokenType _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	_tmp2_ = self->priv->current;
	switch (_tmp2_) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp3_;
			ValaNullLiteral* _tmp4_;
			_tmp3_ = src;
			_tmp4_ = vala_null_literal_new (_tmp3_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp4_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp5_;
			ValaBooleanLiteral* _tmp6_;
			_tmp5_ = src;
			_tmp6_ = vala_boolean_literal_new (TRUE, _tmp5_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp7_;
			ValaBooleanLiteral* _tmp8_;
			_tmp7_ = src;
			_tmp8_ = vala_boolean_literal_new (FALSE, _tmp7_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp8_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp9_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp9_;
			_tmp10_ = inner;
			if (_tmp10_ == NULL) {
				ValaSourceReference* _tmp11_;
				ValaTokenType _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = src;
				_tmp12_ = self->priv->current;
				_tmp13_ = vala_token_type_to_string (_tmp12_);
				_tmp14_ = g_strdup_printf ("expected expression after `-', got %s", _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaUnaryExpression* _tmp20_;
				_tmp16_ = inner;
				_tmp17_ = begin;
				_tmp18_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp16_, _tmp19_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaIntegerLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_integer_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaRealLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_real_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaStringLiteral* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_string_literal_new (_tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaMemberAccess* _tmp36_;
			_tmp33_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = src;
			_tmp36_ = vala_member_access_new (NULL, _tmp34_, _tmp35_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp36_;
			_g_free0 (_tmp34_);
			while (TRUE) {
				ValaExpression* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaMemberAccess* _tmp48_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaTokenType _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->priv->current;
					_tmp40_ = vala_token_type_to_string (_tmp39_);
					_tmp41_ = g_strdup_printf ("expected identifier got %s", _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_vala_source_reference_unref0 (_tmp38_);
					break;
				}
				_tmp43_ = expr;
				_tmp44_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_member_access_new (_tmp43_, _tmp45_, _tmp47_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp48_;
				_vala_source_reference_unref0 (_tmp47_);
				_g_free0 (_tmp45_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp55_;
			ValaTuple* _tmp56_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTokenType _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->current;
				_tmp52_ = vala_token_type_to_string (_tmp51_);
				_tmp53_ = g_strdup_printf ("expected `)', got %s", _tmp52_);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
				_vala_source_reference_unref0 (_tmp50_);
				break;
			}
			_tmp55_ = src;
			_tmp56_ = vala_tuple_new (_tmp55_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp56_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp57_;
			ValaTokenType _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = src;
			_tmp58_ = self->priv->current;
			_tmp59_ = vala_token_type_to_string (_tmp58_);
			_tmp60_ = g_strdup_printf ("expected literal or symbol got %s", _tmp59_);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp57_, _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self, 
                                            ValaGirParserMetadata* metadata)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTokenType _tmp2_;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp3_;
		gchar* id = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaGirParserArgumentType* _tmp8_;
		ValaTokenType _tmp16_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaGirParserArgumentType* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserArgument* _tmp35_;
		ValaGirParserArgument* _tmp36_;
		_tmp2_ = self->priv->current;
		if (_tmp2_ != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->begin;
		begin = _tmp3_;
		_tmp4_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp4_;
		_tmp5_ = id;
		if (_tmp5_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp6_ = id;
		_tmp7_ = vala_gir_parser_argument_type_from_string (_tmp6_);
		arg_type = _tmp7_;
		_tmp8_ = arg_type;
		if (_tmp8_ == NULL) {
			ValaSourceLocation _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = begin;
			_tmp10_ = self->priv->old_end;
			_tmp11_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = id;
			_tmp14_ = g_strdup_printf ("unknown argument `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_warning (_tmp12_, _tmp15_);
			_g_free0 (_tmp15_);
			_vala_source_reference_unref0 (_tmp12_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		_tmp16_ = self->priv->current;
		if (_tmp16_ != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp17_;
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaBooleanLiteral* _tmp21_;
			ValaBooleanLiteral* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaGirParserArgument* _tmp26_;
			ValaGirParserArgument* _tmp27_;
			_tmp17_ = arg_type;
			_tmp18_ = begin;
			_tmp19_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_boolean_literal_new (TRUE, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = begin;
			_tmp24_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp17_, _tmp27_);
			_vala_gir_parser_argument_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_source_reference_unref0 (_tmp20_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp28_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp28_;
		_tmp29_ = expr;
		if (_tmp29_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp30_ = arg_type;
		_tmp31_ = expr;
		_tmp32_ = begin;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_argument_new (_tmp31_, _tmp34_);
		_tmp36_ = _tmp35_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp30_, _tmp36_);
		_vala_gir_parser_argument_unref0 (_tmp36_);
		_vala_source_reference_unref0 (_tmp34_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaTokenType _tmp4_;
	ValaGirParserMetadata* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp4_ = self->priv->current;
	if (_tmp4_ == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp5_;
		gint _tmp6_;
		ValaSourceLocation _tmp7_;
		gint _tmp8_;
		_tmp5_ = old_end;
		_tmp6_ = _tmp5_.line;
		_tmp7_ = self->priv->end;
		_tmp8_ = _tmp7_.line;
		_tmp3_ = _tmp6_ != _tmp8_;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp9_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp9_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}


static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value, 
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value, 
                                                     guint n_collect_values, 
                                                     GTypeCValue* collect_values, 
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value, 
                                                   guint n_collect_values, 
                                                   GTypeCValue* collect_values, 
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name, 
                                            const gchar* nick, 
                                            const gchar* blurb, 
                                            GType object_type, 
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_metadata_parser (GValue* value, 
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}


static void
vala_gir_parser_value_take_metadata_parser (GValue* value, 
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}


static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGirParserMetadataParserPrivate));
}


static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = VALA_GIR_PARSER_METADATA_PARSER_GET_PRIVATE (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}


static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}


static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__volatile, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__volatile;
}


static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type, 
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}


static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}


static void
vala_gir_parser_node_add_member (ValaGirParserNode* self, 
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}


static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self, 
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}


static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self, 
                             const gchar* name, 
                             gboolean create_namespace, 
                             ValaSourceReference* source_reference)
{
	ValaGirParserNode* result = NULL;
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}


static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self, 
                                 const gchar* name)
{
	ValaArrayList* result = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}


static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}


static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_NAMESPACE)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						break;
					}
				}
				_tmp12_ = default_name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				g_string_prepend (_tmp12_, _tmp14_);
			}
		}
	}
	_tmp15_ = default_name;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (default_name);
	return result;
}


static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}


static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp46_;
				ValaGirParserNode* _tmp47_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp41_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							gint _tmp37_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							_tmp37_ = idx;
							if (_tmp37_ >= 0) {
								const gchar* _tmp38_;
								gint _tmp39_;
								gchar* _tmp40_;
								_tmp38_ = p;
								_tmp39_ = idx;
								_tmp40_ = string_substring (_tmp38_, (glong) 0, (glong) _tmp39_);
								_g_free0 (p);
								p = _tmp40_;
							}
						}
					}
					_tmp41_ = p;
					if (_tmp41_ != NULL) {
						const gchar* _tmp42_ = NULL;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp43_ = prefix;
						_tmp42_ = _tmp43_;
						if (_tmp42_ == NULL) {
							_tmp42_ = "";
						}
						_tmp44_ = p;
						_tmp45_ = g_strdup_printf ("%s_%s", _tmp44_, _tmp42_);
						_g_free0 (prefix);
						prefix = _tmp45_;
					}
					_g_free0 (p);
				}
				_tmp46_ = cur;
				_tmp47_ = _tmp46_->parent;
				cur = _tmp47_;
			}
		}
	}
	_tmp48_ = prefix;
	if (_tmp48_ == NULL) {
		gchar* _tmp49_;
		_tmp49_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp49_;
	}
	result = prefix;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp5_ = suffix;
	if (_tmp5_ == NULL) {
		ValaMap* _tmp6_;
		_tmp6_ = self->girdata;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMap* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->girdata;
		_tmp8_ = vala_map_get (_tmp7_, "c:symbol-prefix");
		_tmp9_ = (gchar*) _tmp8_;
		_tmp3_ = _tmp9_ != NULL;
		_g_free0 (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaGirParserMetadata* _tmp10_;
		_tmp10_ = self->metadata;
		_tmp2_ = !vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp12_;
	}
	_tmp13_ = suffix;
	if (_tmp13_ == NULL) {
		gchar* _tmp14_;
		_tmp14_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp14_;
	}
	result = suffix;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		gint _tmp17_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		_tmp17_ = idx;
		if (_tmp17_ != -1) {
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = prefix;
			_tmp19_ = idx;
			_tmp20_ = string_substring (_tmp18_, (glong) 0, (glong) _tmp19_);
			_g_free0 (prefix);
			prefix = _tmp20_;
		}
	}
	_tmp21_ = prefix;
	if (_tmp21_ == NULL) {
		gboolean _tmp22_ = FALSE;
		ValaSymbol* _tmp23_;
		_tmp23_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ENUM)) {
			_tmp22_ = TRUE;
		} else {
			ValaSymbol* _tmp24_;
			_tmp24_ = self->symbol;
			_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp22_) {
			ValaGirParserNode* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp25_ = self->parent;
			_tmp26_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_ascii_strup (_tmp27_, (gssize) -1);
			_tmp29_ = _tmp28_;
			_tmp30_ = self->name;
			_tmp31_ = g_strdup_printf ("%s%s", _tmp29_, _tmp30_);
			_g_free0 (prefix);
			prefix = _tmp31_;
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
		} else {
			gchar* _tmp32_;
			_tmp32_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp32_;
		}
	}
	result = prefix;
	return result;
}


static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
	}
	_tmp14_ = cname;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp15_;
	}
	result = cname;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_METHOD)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}


static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}


static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}


static gboolean
int64_try_parse (const gchar* str, 
                 gint64* _result_, 
                 const gchar* * unparsed)
{
	gint64 _vala_result = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	guint64 result = 0ULL;
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < _tmp2__length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				gint64 _tmp6_;
				gint64 _tmp7_;
				gint64 _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp6_ = t;
				if (_tmp6_ > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp7_ = res;
				_tmp8_ = t;
				_tmp9_ = shift;
				res = _tmp7_ | (_tmp8_ << _tmp9_);
				_tmp10_ = shift;
				shift = _tmp10_ - 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
vala_gir_parser_node_process (ValaGirParserNode* self, 
                              ValaGirParser* parser)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSymbol* _tmp2_;
	gboolean _tmp45_ = FALSE;
	ValaSymbol* _tmp46_;
	ValaMap* _tmp90_;
	gboolean _tmp807_ = FALSE;
	gboolean _tmp808_ = FALSE;
	gboolean _tmp809_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	_tmp0_ = self->processed;
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_NAMESPACE)) {
		ValaGirParserNode* _tmp3_;
		ValaGirParserNode* _tmp4_;
		_tmp3_ = self->parent;
		_tmp4_ = parser->priv->root;
		_tmp1_ = _tmp3_ == _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp5_;
			ValaArrayList* _tmp6_;
			gint _node_size = 0;
			ValaArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _node_index = 0;
			_tmp5_ = self->members;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_node_list = _tmp6_;
			_tmp7_ = _node_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_node_size = _tmp9_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				ValaGirParserNode* _tmp16_;
				const gchar* _tmp17_;
				_tmp10_ = _node_index;
				_node_index = _tmp10_ + 1;
				_tmp11_ = _node_index;
				_tmp12_ = _node_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _node_list;
				_tmp14_ = _node_index;
				_tmp15_ = vala_list_get ((ValaList*) _tmp13_, _tmp14_);
				node = (ValaGirParserNode*) _tmp15_;
				_tmp16_ = node;
				_tmp17_ = _tmp16_->element_type;
				if (g_strcmp0 (_tmp17_, "alias") == 0) {
					ValaGirParserNode* _tmp18_;
					_tmp18_ = node;
					vala_gir_parser_process_alias (parser, _tmp18_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					gint _tmp21_;
					ValaArrayList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp25_;
					gint _tmp26_;
					gpointer _tmp27_;
					gboolean _tmp28_ = FALSE;
					ValaGirParserNode* _tmp29_;
					ValaSymbol* _tmp30_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = self->members;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					if (!(_tmp21_ < _tmp24_)) {
						break;
					}
					_tmp25_ = self->members;
					_tmp26_ = i;
					_tmp27_ = vala_list_get ((ValaList*) _tmp25_, _tmp26_);
					node = (ValaGirParserNode*) _tmp27_;
					_tmp29_ = node;
					_tmp30_ = _tmp29_->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_METHOD)) {
						ValaGirParserNode* _tmp31_;
						gboolean _tmp32_;
						_tmp31_ = node;
						_tmp32_ = _tmp31_->new_symbol;
						_tmp28_ = _tmp32_;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						ValaGirParserNode* _tmp33_;
						gboolean _tmp34_ = FALSE;
						gint _tmp35_;
						ValaArrayList* _tmp36_;
						gint _tmp37_;
						gint _tmp38_;
						_tmp33_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp33_);
						_tmp35_ = i;
						_tmp36_ = self->members;
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
						_tmp38_ = _tmp37_;
						if (_tmp35_ < _tmp38_) {
							ValaArrayList* _tmp39_;
							gint _tmp40_;
							gpointer _tmp41_;
							ValaGirParserNode* _tmp42_;
							ValaGirParserNode* _tmp43_;
							_tmp39_ = self->members;
							_tmp40_ = i;
							_tmp41_ = vala_list_get ((ValaList*) _tmp39_, _tmp40_);
							_tmp42_ = (ValaGirParserNode*) _tmp41_;
							_tmp43_ = node;
							_tmp34_ = _tmp42_ != _tmp43_;
							_vala_gir_parser_node_unref0 (_tmp42_);
						} else {
							_tmp34_ = FALSE;
						}
						if (_tmp34_) {
							gint _tmp44_;
							_tmp44_ = i;
							i = _tmp44_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp46_ = self->symbol;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_CLASS)) {
		ValaMap* _tmp47_;
		_tmp47_ = self->girdata;
		_tmp45_ = _tmp47_ != NULL;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		gchar* class_struct = NULL;
		ValaMap* _tmp48_;
		gpointer _tmp49_;
		const gchar* _tmp50_;
		_tmp48_ = self->girdata;
		_tmp49_ = vala_map_get (_tmp48_, "glib:type-struct");
		class_struct = (gchar*) _tmp49_;
		_tmp50_ = class_struct;
		if (_tmp50_ != NULL) {
			ValaGirParserNode* klass = NULL;
			ValaGirParserNode* _tmp51_;
			const gchar* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaUnresolvedSymbol* _tmp54_;
			ValaUnresolvedSymbol* _tmp55_;
			ValaGirParserNode* _tmp56_;
			ValaGirParserNode* _tmp57_;
			ValaGirParserNode* _tmp58_;
			_tmp51_ = self->parent;
			_tmp52_ = class_struct;
			_tmp53_ = self->source_reference;
			_tmp54_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp52_, _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_gir_parser_resolve_node (parser, _tmp51_, _tmp55_, FALSE);
			_tmp57_ = _tmp56_;
			_vala_code_node_unref0 (_tmp55_);
			klass = _tmp57_;
			_tmp58_ = klass;
			if (_tmp58_ != NULL) {
				gint i = 0;
				i = 0;
				while (TRUE) {
					gint _tmp59_;
					ValaGirParserNode* _tmp60_;
					ValaArrayList* _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					ValaGirParserNode* node = NULL;
					ValaGirParserNode* _tmp64_;
					ValaArrayList* _tmp65_;
					gint _tmp66_;
					gpointer _tmp67_;
					ValaGirParserNode* _tmp68_;
					ValaSymbol* _tmp69_;
					_tmp59_ = i;
					_tmp60_ = klass;
					_tmp61_ = _tmp60_->members;
					_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
					_tmp63_ = _tmp62_;
					if (!(_tmp59_ < _tmp63_)) {
						break;
					}
					_tmp64_ = klass;
					_tmp65_ = _tmp64_->members;
					_tmp66_ = i;
					_tmp67_ = vala_list_get ((ValaList*) _tmp65_, _tmp66_);
					node = (ValaGirParserNode*) _tmp67_;
					_tmp68_ = node;
					_tmp69_ = _tmp68_->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_METHOD)) {
						ValaGirParserNode* _tmp70_;
						ValaGirParserNode* _tmp71_;
						ValaGirParserNode* _tmp72_;
						ValaMethod* m = NULL;
						ValaGirParserNode* _tmp73_;
						ValaSymbol* _tmp74_;
						ValaMethod* _tmp75_;
						ValaMethod* _tmp76_;
						_tmp70_ = klass;
						_tmp71_ = node;
						vala_gir_parser_node_remove_member (_tmp70_, _tmp71_);
						_tmp72_ = node;
						vala_gir_parser_node_add_member (self, _tmp72_);
						_tmp73_ = node;
						_tmp74_ = _tmp73_->symbol;
						_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp75_;
						_tmp76_ = m;
						vala_method_set_binding (_tmp76_, VALA_MEMBER_BINDING_CLASS);
						_vala_code_node_unref0 (m);
					} else {
						gint _tmp77_;
						_tmp77_ = i;
						i = _tmp77_ + 1;
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_vala_gir_parser_node_unref0 (klass);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp78_;
		ValaArrayList* _tmp79_;
		gint _node_size = 0;
		ValaArrayList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _node_index = 0;
		_tmp78_ = self->members;
		_tmp79_ = _vala_iterable_ref0 (_tmp78_);
		_node_list = _tmp79_;
		_tmp80_ = _node_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_node_size = _tmp82_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp86_;
			gint _tmp87_;
			gpointer _tmp88_;
			ValaGirParserNode* _tmp89_;
			_tmp83_ = _node_index;
			_node_index = _tmp83_ + 1;
			_tmp84_ = _node_index;
			_tmp85_ = _node_size;
			if (!(_tmp84_ < _tmp85_)) {
				break;
			}
			_tmp86_ = _node_list;
			_tmp87_ = _node_index;
			_tmp88_ = vala_list_get ((ValaList*) _tmp86_, _tmp87_);
			node = (ValaGirParserNode*) _tmp88_;
			_tmp89_ = node;
			vala_gir_parser_node_process (_tmp89_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp90_ = self->girdata;
	if (_tmp90_ != NULL) {
		ValaSymbol* _tmp91_;
		ValaGirParserMetadata* _tmp718_;
		ValaGirParserMetadata* _tmp721_;
		ValaGirParserMetadata* _tmp730_;
		const gchar* _tmp737_;
		ValaGirParserMetadata* _tmp739_;
		ValaGirParserMetadata* _tmp742_;
		ValaGirParserNode* _tmp760_;
		ValaSymbol* _tmp761_;
		gchar* _tmp770_;
		gchar* _tmp771_;
		gchar* _tmp772_;
		gchar* _tmp773_;
		gboolean _tmp774_;
		gchar* _tmp778_;
		gchar* _tmp779_;
		gchar* _tmp780_;
		gchar* _tmp781_;
		gboolean _tmp782_;
		gchar* _tmp786_;
		gchar* _tmp787_;
		gchar* _tmp788_;
		gchar* _tmp789_;
		gboolean _tmp790_;
		gchar* gir_name = NULL;
		gchar* _tmp794_;
		gchar* default_gir_name = NULL;
		gchar* _tmp795_;
		gboolean _tmp796_ = FALSE;
		gboolean _tmp797_ = FALSE;
		ValaSymbol* _tmp798_;
		_tmp91_ = self->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp92_;
			ValaMethod* _tmp93_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp94_;
			const gchar* _tmp95_;
			ValaArrayList* _tmp96_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp212_;
			gboolean _tmp213_;
			gboolean _tmp214_;
			_tmp92_ = self->symbol;
			_tmp93_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp93_;
			vala_gir_parser_process_callable (parser, self);
			_tmp94_ = self->parent;
			_tmp95_ = self->name;
			_tmp96_ = vala_gir_parser_node_lookup_all (_tmp94_, _tmp95_);
			colliding = _tmp96_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp97_;
				ValaArrayList* _tmp98_;
				gint _node_size = 0;
				ValaArrayList* _tmp99_;
				gint _tmp100_;
				gint _tmp101_;
				gint _node_index = 0;
				_tmp97_ = colliding;
				_tmp98_ = _vala_iterable_ref0 (_tmp97_);
				_node_list = _tmp98_;
				_tmp99_ = _node_list;
				_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
				_tmp101_ = _tmp100_;
				_node_size = _tmp101_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp102_;
					gint _tmp103_;
					gint _tmp104_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp105_;
					gint _tmp106_;
					gpointer _tmp107_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp108_;
					ValaSymbol* _tmp109_;
					ValaSymbol* _tmp110_;
					gboolean _tmp111_ = FALSE;
					gboolean _tmp112_ = FALSE;
					ValaSymbol* _tmp113_;
					_tmp102_ = _node_index;
					_node_index = _tmp102_ + 1;
					_tmp103_ = _node_index;
					_tmp104_ = _node_size;
					if (!(_tmp103_ < _tmp104_)) {
						break;
					}
					_tmp105_ = _node_list;
					_tmp106_ = _node_index;
					_tmp107_ = vala_list_get ((ValaList*) _tmp105_, _tmp106_);
					node = (ValaGirParserNode*) _tmp107_;
					_tmp108_ = node;
					_tmp109_ = _tmp108_->symbol;
					_tmp110_ = _vala_code_node_ref0 (_tmp109_);
					sym = _tmp110_;
					_tmp113_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_FIELD)) {
						ValaMethod* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						_tmp114_ = m;
						_tmp115_ = vala_callable_get_return_type ((ValaCallable*) _tmp114_);
						_tmp116_ = _tmp115_;
						_tmp112_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_VOID_TYPE);
					} else {
						_tmp112_ = FALSE;
					}
					if (_tmp112_) {
						ValaMethod* _tmp117_;
						ValaList* _tmp118_;
						ValaList* _tmp119_;
						gint _tmp120_;
						gint _tmp121_;
						_tmp117_ = m;
						_tmp118_ = vala_callable_get_parameters ((ValaCallable*) _tmp117_);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp111_ = _tmp121_ == 0;
						_vala_iterable_unref0 (_tmp119_);
					} else {
						_tmp111_ = FALSE;
					}
					if (_tmp111_) {
						self->merged = TRUE;
					} else {
						ValaSymbol* _tmp122_;
						_tmp122_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp122_, VALA_TYPE_SIGNAL)) {
							ValaGirParserNode* _tmp123_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp124_;
							ValaSignal* _tmp125_;
							gboolean _tmp126_ = FALSE;
							ValaMethod* _tmp127_;
							gboolean _tmp128_;
							gboolean _tmp129_;
							ValaSignal* _tmp135_;
							ValaMethod* _tmp136_;
							ValaMethod* _tmp137_;
							ValaList* _tmp138_;
							ValaList* _tmp139_;
							gint _tmp140_;
							gint _tmp141_;
							ValaSignal* _tmp142_;
							ValaList* _tmp143_;
							ValaList* _tmp144_;
							gint _tmp145_;
							gint _tmp146_;
							gboolean _tmp147_;
							_tmp123_ = node;
							vala_gir_parser_node_process (_tmp123_, parser);
							_tmp124_ = sym;
							_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp125_;
							_tmp127_ = m;
							_tmp128_ = vala_method_get_is_virtual (_tmp127_);
							_tmp129_ = _tmp128_;
							if (_tmp129_) {
								_tmp126_ = TRUE;
							} else {
								ValaMethod* _tmp130_;
								gboolean _tmp131_;
								gboolean _tmp132_;
								_tmp130_ = m;
								_tmp131_ = vala_method_get_is_abstract (_tmp130_);
								_tmp132_ = _tmp131_;
								_tmp126_ = _tmp132_;
							}
							if (_tmp126_) {
								ValaSignal* _tmp133_;
								_tmp133_ = sig;
								vala_signal_set_is_virtual (_tmp133_, TRUE);
							} else {
								ValaSignal* _tmp134_;
								_tmp134_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp134_, "HasEmitter", TRUE, NULL);
							}
							_tmp135_ = sig;
							_tmp136_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp135_, (ValaSymbol*) _tmp136_, FALSE);
							_tmp137_ = m;
							_tmp138_ = vala_callable_get_parameters ((ValaCallable*) _tmp137_);
							_tmp139_ = _tmp138_;
							_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
							_tmp141_ = _tmp140_;
							_tmp142_ = sig;
							_tmp143_ = vala_callable_get_parameters ((ValaCallable*) _tmp142_);
							_tmp144_ = _tmp143_;
							_tmp145_ = vala_collection_get_size ((ValaCollection*) _tmp144_);
							_tmp146_ = _tmp145_;
							_tmp147_ = _tmp141_ != _tmp146_;
							_vala_iterable_unref0 (_tmp144_);
							_vala_iterable_unref0 (_tmp139_);
							if (_tmp147_) {
								ValaSymbol* _tmp148_;
								ValaSourceReference* _tmp149_;
								ValaSourceReference* _tmp150_;
								gchar* _tmp151_;
								gchar* _tmp152_;
								gchar* _tmp153_;
								gchar* _tmp154_;
								_tmp148_ = self->symbol;
								_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
								_tmp150_ = _tmp149_;
								_tmp151_ = vala_gir_parser_node_get_full_name (self);
								_tmp152_ = _tmp151_;
								_tmp153_ = g_strdup_printf ("Signal `%s' conflicts with method of the same name", _tmp152_);
								_tmp154_ = _tmp153_;
								vala_report_warning (_tmp150_, _tmp154_);
								_g_free0 (_tmp154_);
								_g_free0 (_tmp152_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp155_ = FALSE;
							gboolean _tmp156_ = FALSE;
							ValaSymbol* _tmp157_;
							_tmp157_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, VALA_TYPE_METHOD)) {
								ValaSymbol* _tmp158_;
								_tmp158_ = sym;
								_tmp156_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp158_, VALA_TYPE_CREATION_METHOD);
							} else {
								_tmp156_ = FALSE;
							}
							if (_tmp156_) {
								ValaGirParserNode* _tmp159_;
								_tmp159_ = node;
								_tmp155_ = _tmp159_ != self;
							} else {
								_tmp155_ = FALSE;
							}
							if (_tmp155_) {
								gboolean _tmp160_ = FALSE;
								ValaMethod* _tmp161_;
								gboolean _tmp162_;
								gboolean _tmp163_;
								_tmp161_ = m;
								_tmp162_ = vala_method_get_is_virtual (_tmp161_);
								_tmp163_ = _tmp162_;
								if (_tmp163_) {
									_tmp160_ = TRUE;
								} else {
									ValaMethod* _tmp164_;
									gboolean _tmp165_;
									gboolean _tmp166_;
									_tmp164_ = m;
									_tmp165_ = vala_method_get_is_abstract (_tmp164_);
									_tmp166_ = _tmp165_;
									_tmp160_ = _tmp166_;
								}
								if (_tmp160_) {
									gboolean different_invoker = FALSE;
									ValaAttribute* attr = NULL;
									ValaMethod* _tmp167_;
									ValaAttribute* _tmp168_;
									ValaAttribute* _tmp169_;
									gboolean _tmp183_;
									different_invoker = FALSE;
									_tmp167_ = m;
									_tmp168_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp167_, "NoWrapper");
									attr = _tmp168_;
									_tmp169_ = attr;
									if (_tmp169_ != NULL) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp170_;
										ValaGirParserNode* _tmp171_;
										_tmp170_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp170_;
										_tmp171_ = invoker;
										if (_tmp171_ != NULL) {
											ValaMethod* _tmp172_;
											ValaMethod* _tmp173_;
											const gchar* _tmp174_;
											const gchar* _tmp175_;
											ValaMethod* _tmp176_;
											ValaGirParserNode* _tmp177_;
											ValaSymbol* _tmp178_;
											const gchar* _tmp179_;
											const gchar* _tmp180_;
											ValaMethod* _tmp181_;
											ValaGirParserNode* _tmp182_;
											_tmp172_ = m;
											_tmp173_ = m;
											_tmp174_ = vala_symbol_get_name ((ValaSymbol*) _tmp173_);
											_tmp175_ = _tmp174_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp172_, "CCode", "vfunc_name", _tmp175_, NULL);
											_tmp176_ = m;
											_tmp177_ = invoker;
											_tmp178_ = _tmp177_->symbol;
											_tmp179_ = vala_symbol_get_name (_tmp178_);
											_tmp180_ = _tmp179_;
											vala_symbol_set_name ((ValaSymbol*) _tmp176_, _tmp180_);
											_tmp181_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp181_, "NoWrapper", FALSE, NULL);
											_tmp182_ = invoker;
											_tmp182_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									_tmp183_ = different_invoker;
									if (!_tmp183_) {
										ValaAttribute* _tmp184_;
										ValaGirParserNode* _tmp192_;
										_tmp184_ = attr;
										if (_tmp184_ != NULL) {
											ValaSymbol* _tmp185_;
											ValaSourceReference* _tmp186_;
											ValaSourceReference* _tmp187_;
											gchar* _tmp188_;
											gchar* _tmp189_;
											gchar* _tmp190_;
											gchar* _tmp191_;
											_tmp185_ = self->symbol;
											_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp185_);
											_tmp187_ = _tmp186_;
											_tmp188_ = vala_gir_parser_node_get_full_name (self);
											_tmp189_ = _tmp188_;
											_tmp190_ = g_strdup_printf ("Virtual method `%s' conflicts with method of the same name", _tmp189_);
											_tmp191_ = _tmp190_;
											vala_report_warning (_tmp187_, _tmp191_);
											_g_free0 (_tmp191_);
											_g_free0 (_tmp189_);
										}
										_tmp192_ = node;
										_tmp192_->merged = TRUE;
									}
									_vala_code_node_unref0 (attr);
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp193_ = m;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp193_, VALA_TYPE_CREATION_METHOD)) {
				ValaGirParserMetadata* _tmp194_;
				ValaGirParserMetadata* _tmp197_;
				ValaGirParserMetadata* _tmp200_;
				_tmp194_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp194_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp195_;
					ValaGirParserMetadata* _tmp196_;
					_tmp195_ = m;
					_tmp196_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp195_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp196_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp197_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp197_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp198_;
					ValaGirParserMetadata* _tmp199_;
					_tmp198_ = m;
					_tmp199_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp198_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp199_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp200_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp200_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp201_;
					ValaGirParserMetadata* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					ValaGirParserNode* _tmp205_;
					ValaGirParserNode* _tmp206_;
					gboolean _tmp207_ = FALSE;
					ValaGirParserNode* _tmp208_;
					_tmp201_ = self->parent;
					_tmp202_ = self->metadata;
					_tmp203_ = vala_gir_parser_metadata_get_string (_tmp202_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_gir_parser_node_lookup (_tmp201_, _tmp204_, FALSE, NULL);
					_tmp206_ = _tmp205_;
					_g_free0 (_tmp204_);
					vfunc = _tmp206_;
					_tmp208_ = vfunc;
					if (_tmp208_ != NULL) {
						ValaGirParserNode* _tmp209_;
						_tmp209_ = vfunc;
						_tmp207_ = _tmp209_ != self;
					} else {
						_tmp207_ = FALSE;
					}
					if (_tmp207_) {
						ValaGirParserNode* _tmp210_;
						ValaGirParserNode* _tmp211_;
						_tmp210_ = vfunc;
						_tmp210_->processed = TRUE;
						_tmp211_ = vfunc;
						_tmp211_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp212_ = m;
			_tmp213_ = vala_method_get_coroutine (_tmp212_);
			_tmp214_ = _tmp213_;
			if (_tmp214_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp215_;
			_tmp215_ = self->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp215_, VALA_TYPE_PROPERTY)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp216_;
				const gchar* _tmp217_;
				ValaArrayList* _tmp218_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp237_;
				ValaProperty* _tmp238_;
				gchar* readable = NULL;
				ValaMap* _tmp239_;
				gpointer _tmp240_;
				gchar* writable = NULL;
				ValaMap* _tmp241_;
				gpointer _tmp242_;
				gchar* construct_ = NULL;
				ValaMap* _tmp243_;
				gpointer _tmp244_;
				gchar* construct_only = NULL;
				ValaMap* _tmp245_;
				gpointer _tmp246_;
				const gchar* _tmp247_;
				gboolean _tmp256_ = FALSE;
				const gchar* _tmp257_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp273_;
				const gchar* _tmp274_;
				gchar* _tmp275_;
				gchar* _tmp276_;
				ValaArrayList* _tmp277_;
				ValaArrayList* _tmp278_;
				ValaArrayList* _tmp279_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp307_;
				const gchar* _tmp308_;
				gchar* _tmp309_;
				gchar* _tmp310_;
				ValaArrayList* _tmp311_;
				ValaArrayList* _tmp312_;
				ValaArrayList* _tmp313_;
				ValaProperty* _tmp341_;
				ValaProperty* _tmp342_;
				ValaPropertyAccessor* _tmp343_;
				ValaPropertyAccessor* _tmp344_;
				gboolean _tmp402_ = FALSE;
				gboolean _tmp403_ = FALSE;
				ValaProperty* _tmp404_;
				ValaAttribute* _tmp405_;
				ValaAttribute* _tmp406_;
				gboolean _tmp407_;
				ValaProperty* _tmp472_;
				ValaAttribute* _tmp473_;
				ValaAttribute* _tmp474_;
				gboolean _tmp475_;
				ValaProperty* _tmp523_;
				ValaAttribute* _tmp524_;
				ValaAttribute* _tmp525_;
				gboolean _tmp526_;
				_tmp216_ = self->parent;
				_tmp217_ = self->name;
				_tmp218_ = vala_gir_parser_node_lookup_all (_tmp216_, _tmp217_);
				colliding = _tmp218_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp219_;
					ValaArrayList* _tmp220_;
					gint _node_size = 0;
					ValaArrayList* _tmp221_;
					gint _tmp222_;
					gint _tmp223_;
					gint _node_index = 0;
					_tmp219_ = colliding;
					_tmp220_ = _vala_iterable_ref0 (_tmp219_);
					_node_list = _tmp220_;
					_tmp221_ = _node_list;
					_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
					_tmp223_ = _tmp222_;
					_node_size = _tmp223_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp224_;
						gint _tmp225_;
						gint _tmp226_;
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp227_;
						gint _tmp228_;
						gpointer _tmp229_;
						ValaGirParserNode* _tmp230_;
						ValaSymbol* _tmp231_;
						_tmp224_ = _node_index;
						_node_index = _tmp224_ + 1;
						_tmp225_ = _node_index;
						_tmp226_ = _node_size;
						if (!(_tmp225_ < _tmp226_)) {
							break;
						}
						_tmp227_ = _node_list;
						_tmp228_ = _node_index;
						_tmp229_ = vala_list_get ((ValaList*) _tmp227_, _tmp228_);
						node = (ValaGirParserNode*) _tmp229_;
						_tmp230_ = node;
						_tmp231_ = _tmp230_->symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp231_, VALA_TYPE_SIGNAL)) {
							ValaGirParserNode* _tmp232_;
							ValaGirParserNode* _tmp233_;
							_tmp232_ = node;
							_tmp232_->processed = TRUE;
							_tmp233_ = node;
							_tmp233_->merged = TRUE;
						} else {
							ValaGirParserNode* _tmp234_;
							ValaSymbol* _tmp235_;
							_tmp234_ = node;
							_tmp235_ = _tmp234_->symbol;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp235_, VALA_TYPE_METHOD)) {
								ValaGirParserNode* _tmp236_;
								_tmp236_ = node;
								_tmp236_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
				_tmp237_ = self->symbol;
				_tmp238_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp237_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp238_;
				_tmp239_ = self->girdata;
				_tmp240_ = vala_map_get (_tmp239_, "readable");
				readable = (gchar*) _tmp240_;
				_tmp241_ = self->girdata;
				_tmp242_ = vala_map_get (_tmp241_, "writable");
				writable = (gchar*) _tmp242_;
				_tmp243_ = self->girdata;
				_tmp244_ = vala_map_get (_tmp243_, "construct");
				construct_ = (gchar*) _tmp244_;
				_tmp245_ = self->girdata;
				_tmp246_ = vala_map_get (_tmp245_, "construct-only");
				construct_only = (gchar*) _tmp246_;
				_tmp247_ = readable;
				if (g_strcmp0 (_tmp247_, "0") != 0) {
					ValaProperty* _tmp248_;
					ValaProperty* _tmp249_;
					ValaDataType* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					ValaPropertyAccessor* _tmp254_;
					ValaPropertyAccessor* _tmp255_;
					_tmp248_ = prop;
					_tmp249_ = prop;
					_tmp250_ = vala_property_get_property_type (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_data_type_copy (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp253_, NULL, NULL, NULL);
					_tmp255_ = _tmp254_;
					vala_property_set_get_accessor (_tmp248_, _tmp255_);
					_vala_code_node_unref0 (_tmp255_);
					_vala_code_node_unref0 (_tmp253_);
				}
				_tmp257_ = writable;
				if (g_strcmp0 (_tmp257_, "1") == 0) {
					_tmp256_ = TRUE;
				} else {
					const gchar* _tmp258_;
					_tmp258_ = construct_only;
					_tmp256_ = g_strcmp0 (_tmp258_, "1") == 0;
				}
				if (_tmp256_) {
					gboolean _tmp259_ = FALSE;
					const gchar* _tmp260_;
					gboolean _tmp262_ = FALSE;
					const gchar* _tmp263_;
					ValaProperty* _tmp265_;
					ValaProperty* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaDataType* _tmp269_;
					ValaDataType* _tmp270_;
					ValaPropertyAccessor* _tmp271_;
					ValaPropertyAccessor* _tmp272_;
					_tmp260_ = construct_only;
					if (g_strcmp0 (_tmp260_, "1") != 0) {
						const gchar* _tmp261_;
						_tmp261_ = writable;
						_tmp259_ = g_strcmp0 (_tmp261_, "1") == 0;
					} else {
						_tmp259_ = FALSE;
					}
					_tmp263_ = construct_only;
					if (g_strcmp0 (_tmp263_, "1") == 0) {
						_tmp262_ = TRUE;
					} else {
						const gchar* _tmp264_;
						_tmp264_ = construct_;
						_tmp262_ = g_strcmp0 (_tmp264_, "1") == 0;
					}
					_tmp265_ = prop;
					_tmp266_ = prop;
					_tmp267_ = vala_property_get_property_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = vala_data_type_copy (_tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_property_accessor_new (FALSE, _tmp259_, _tmp262_, _tmp270_, NULL, NULL, NULL);
					_tmp272_ = _tmp271_;
					vala_property_set_set_accessor (_tmp265_, _tmp272_);
					_vala_code_node_unref0 (_tmp272_);
					_vala_code_node_unref0 (_tmp270_);
				}
				getter = NULL;
				_tmp273_ = self->parent;
				_tmp274_ = self->name;
				_tmp275_ = g_strdup_printf ("get_%s", _tmp274_);
				_tmp276_ = _tmp275_;
				_tmp277_ = vala_gir_parser_node_lookup_all (_tmp273_, _tmp276_);
				_tmp278_ = _tmp277_;
				_g_free0 (_tmp276_);
				getters = _tmp278_;
				_tmp279_ = getters;
				if (_tmp279_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp280_;
						ValaArrayList* _tmp281_;
						gint _g_size = 0;
						ValaArrayList* _tmp282_;
						gint _tmp283_;
						gint _tmp284_;
						gint _g_index = 0;
						_tmp280_ = getters;
						_tmp281_ = _vala_iterable_ref0 (_tmp280_);
						_g_list = _tmp281_;
						_tmp282_ = _g_list;
						_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
						_tmp284_ = _tmp283_;
						_g_size = _tmp284_;
						_g_index = -1;
						while (TRUE) {
							gint _tmp285_;
							gint _tmp286_;
							gint _tmp287_;
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp288_;
							gint _tmp289_;
							gpointer _tmp290_;
							gboolean _tmp291_ = FALSE;
							gboolean _tmp292_ = FALSE;
							ValaGirParserNode* _tmp293_;
							_tmp285_ = _g_index;
							_g_index = _tmp285_ + 1;
							_tmp286_ = _g_index;
							_tmp287_ = _g_size;
							if (!(_tmp286_ < _tmp287_)) {
								break;
							}
							_tmp288_ = _g_list;
							_tmp289_ = _g_index;
							_tmp290_ = vala_list_get ((ValaList*) _tmp288_, _tmp289_);
							g = (ValaGirParserNode*) _tmp290_;
							_tmp293_ = getter;
							if (_tmp293_ == NULL) {
								_tmp292_ = TRUE;
							} else {
								ValaGirParserNode* _tmp294_;
								gboolean _tmp295_;
								_tmp294_ = g;
								_tmp295_ = _tmp294_->merged;
								_tmp292_ = !_tmp295_;
							}
							if (_tmp292_) {
								ValaGirParserNode* _tmp296_;
								gchar* _tmp297_;
								gchar* _tmp298_;
								ValaGirParserNode* _tmp299_;
								gchar* _tmp300_;
								gchar* _tmp301_;
								const gchar* _tmp302_;
								gchar* _tmp303_;
								gchar* _tmp304_;
								_tmp296_ = g;
								_tmp297_ = vala_gir_parser_node_get_cname (_tmp296_);
								_tmp298_ = _tmp297_;
								_tmp299_ = self->parent;
								_tmp300_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp299_);
								_tmp301_ = _tmp300_;
								_tmp302_ = self->name;
								_tmp303_ = g_strdup_printf ("%sget_%s", _tmp301_, _tmp302_);
								_tmp304_ = _tmp303_;
								_tmp291_ = g_strcmp0 (_tmp298_, _tmp304_) == 0;
								_g_free0 (_tmp304_);
								_g_free0 (_tmp301_);
								_g_free0 (_tmp298_);
							} else {
								_tmp291_ = FALSE;
							}
							if (_tmp291_) {
								ValaGirParserNode* _tmp305_;
								ValaGirParserNode* _tmp306_;
								_tmp305_ = g;
								_tmp306_ = _vala_gir_parser_node_ref0 (_tmp305_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp306_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
						_vala_iterable_unref0 (_g_list);
					}
				}
				setter = NULL;
				_tmp307_ = self->parent;
				_tmp308_ = self->name;
				_tmp309_ = g_strdup_printf ("set_%s", _tmp308_);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_gir_parser_node_lookup_all (_tmp307_, _tmp310_);
				_tmp312_ = _tmp311_;
				_g_free0 (_tmp310_);
				setters = _tmp312_;
				_tmp313_ = setters;
				if (_tmp313_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp314_;
						ValaArrayList* _tmp315_;
						gint _s_size = 0;
						ValaArrayList* _tmp316_;
						gint _tmp317_;
						gint _tmp318_;
						gint _s_index = 0;
						_tmp314_ = setters;
						_tmp315_ = _vala_iterable_ref0 (_tmp314_);
						_s_list = _tmp315_;
						_tmp316_ = _s_list;
						_tmp317_ = vala_collection_get_size ((ValaCollection*) _tmp316_);
						_tmp318_ = _tmp317_;
						_s_size = _tmp318_;
						_s_index = -1;
						while (TRUE) {
							gint _tmp319_;
							gint _tmp320_;
							gint _tmp321_;
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp322_;
							gint _tmp323_;
							gpointer _tmp324_;
							gboolean _tmp325_ = FALSE;
							gboolean _tmp326_ = FALSE;
							ValaGirParserNode* _tmp327_;
							_tmp319_ = _s_index;
							_s_index = _tmp319_ + 1;
							_tmp320_ = _s_index;
							_tmp321_ = _s_size;
							if (!(_tmp320_ < _tmp321_)) {
								break;
							}
							_tmp322_ = _s_list;
							_tmp323_ = _s_index;
							_tmp324_ = vala_list_get ((ValaList*) _tmp322_, _tmp323_);
							s = (ValaGirParserNode*) _tmp324_;
							_tmp327_ = setter;
							if (_tmp327_ == NULL) {
								_tmp326_ = TRUE;
							} else {
								ValaGirParserNode* _tmp328_;
								gboolean _tmp329_;
								_tmp328_ = s;
								_tmp329_ = _tmp328_->merged;
								_tmp326_ = !_tmp329_;
							}
							if (_tmp326_) {
								ValaGirParserNode* _tmp330_;
								gchar* _tmp331_;
								gchar* _tmp332_;
								ValaGirParserNode* _tmp333_;
								gchar* _tmp334_;
								gchar* _tmp335_;
								const gchar* _tmp336_;
								gchar* _tmp337_;
								gchar* _tmp338_;
								_tmp330_ = s;
								_tmp331_ = vala_gir_parser_node_get_cname (_tmp330_);
								_tmp332_ = _tmp331_;
								_tmp333_ = self->parent;
								_tmp334_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp333_);
								_tmp335_ = _tmp334_;
								_tmp336_ = self->name;
								_tmp337_ = g_strdup_printf ("%sset_%s", _tmp335_, _tmp336_);
								_tmp338_ = _tmp337_;
								_tmp325_ = g_strcmp0 (_tmp332_, _tmp338_) == 0;
								_g_free0 (_tmp338_);
								_g_free0 (_tmp335_);
								_g_free0 (_tmp332_);
							} else {
								_tmp325_ = FALSE;
							}
							if (_tmp325_) {
								ValaGirParserNode* _tmp339_;
								ValaGirParserNode* _tmp340_;
								_tmp339_ = s;
								_tmp340_ = _vala_gir_parser_node_ref0 (_tmp339_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp340_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
						_vala_iterable_unref0 (_s_list);
					}
				}
				_tmp341_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp341_, "NoAccessorMethod", FALSE, NULL);
				_tmp342_ = prop;
				_tmp343_ = vala_property_get_get_accessor (_tmp342_);
				_tmp344_ = _tmp343_;
				if (_tmp344_ != NULL) {
					ValaMethod* _tmp345_ = NULL;
					ValaGirParserNode* _tmp346_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp349_;
					ValaMethod* _tmp350_;
					_tmp346_ = getter;
					if (_tmp346_ != NULL) {
						ValaGirParserNode* _tmp347_;
						ValaSymbol* _tmp348_;
						_tmp347_ = getter;
						_tmp348_ = _tmp347_->symbol;
						_tmp345_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp348_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp348_) : NULL;
					} else {
						_tmp345_ = NULL;
					}
					_tmp349_ = _vala_code_node_ref0 (_tmp345_);
					m = _tmp349_;
					_tmp350_ = m;
					if (_tmp350_ != NULL) {
						ValaGirParserNode* _tmp351_;
						gboolean _tmp352_ = FALSE;
						ValaMethod* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDataType* _tmp355_;
						_tmp351_ = getter;
						vala_gir_parser_node_process (_tmp351_, parser);
						_tmp353_ = m;
						_tmp354_ = vala_callable_get_return_type ((ValaCallable*) _tmp353_);
						_tmp355_ = _tmp354_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp355_, VALA_TYPE_VOID_TYPE)) {
							_tmp352_ = TRUE;
						} else {
							ValaMethod* _tmp356_;
							ValaList* _tmp357_;
							ValaList* _tmp358_;
							gint _tmp359_;
							gint _tmp360_;
							_tmp356_ = m;
							_tmp357_ = vala_callable_get_parameters ((ValaCallable*) _tmp356_);
							_tmp358_ = _tmp357_;
							_tmp359_ = vala_collection_get_size ((ValaCollection*) _tmp358_);
							_tmp360_ = _tmp359_;
							_tmp352_ = _tmp360_ != 0;
							_vala_iterable_unref0 (_tmp358_);
						}
						if (_tmp352_) {
							ValaProperty* _tmp361_;
							_tmp361_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp361_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp362_;
							const gchar* _tmp363_;
							const gchar* _tmp364_;
							ValaProperty* _tmp379_;
							ValaPropertyAccessor* _tmp380_;
							ValaPropertyAccessor* _tmp381_;
							ValaDataType* _tmp382_;
							ValaDataType* _tmp383_;
							ValaMethod* _tmp384_;
							ValaDataType* _tmp385_;
							ValaDataType* _tmp386_;
							gboolean _tmp387_;
							gboolean _tmp388_;
							gboolean _tmp389_ = FALSE;
							gboolean _tmp390_ = FALSE;
							ValaMethod* _tmp391_;
							gboolean _tmp392_;
							gboolean _tmp393_;
							_tmp362_ = getter;
							_tmp363_ = _tmp362_->name;
							_tmp364_ = self->name;
							if (g_strcmp0 (_tmp363_, _tmp364_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp365_;
									ValaArrayList* _tmp366_;
									gint _node_size = 0;
									ValaArrayList* _tmp367_;
									gint _tmp368_;
									gint _tmp369_;
									gint _node_index = 0;
									_tmp365_ = colliding;
									_tmp366_ = _vala_iterable_ref0 (_tmp365_);
									_node_list = _tmp366_;
									_tmp367_ = _node_list;
									_tmp368_ = vala_collection_get_size ((ValaCollection*) _tmp367_);
									_tmp369_ = _tmp368_;
									_node_size = _tmp369_;
									_node_index = -1;
									while (TRUE) {
										gint _tmp370_;
										gint _tmp371_;
										gint _tmp372_;
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp373_;
										gint _tmp374_;
										gpointer _tmp375_;
										ValaGirParserNode* _tmp376_;
										ValaSymbol* _tmp377_;
										_tmp370_ = _node_index;
										_node_index = _tmp370_ + 1;
										_tmp371_ = _node_index;
										_tmp372_ = _node_size;
										if (!(_tmp371_ < _tmp372_)) {
											break;
										}
										_tmp373_ = _node_list;
										_tmp374_ = _node_index;
										_tmp375_ = vala_list_get ((ValaList*) _tmp373_, _tmp374_);
										node = (ValaGirParserNode*) _tmp375_;
										_tmp376_ = node;
										_tmp377_ = _tmp376_->symbol;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp377_, VALA_TYPE_METHOD)) {
											ValaGirParserNode* _tmp378_;
											_tmp378_ = node;
											_tmp378_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
									_vala_iterable_unref0 (_node_list);
								}
							}
							_tmp379_ = prop;
							_tmp380_ = vala_property_get_get_accessor (_tmp379_);
							_tmp381_ = _tmp380_;
							_tmp382_ = vala_property_accessor_get_value_type (_tmp381_);
							_tmp383_ = _tmp382_;
							_tmp384_ = m;
							_tmp385_ = vala_callable_get_return_type ((ValaCallable*) _tmp384_);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_data_type_get_value_owned (_tmp386_);
							_tmp388_ = _tmp387_;
							vala_data_type_set_value_owned (_tmp383_, _tmp388_);
							_tmp391_ = m;
							_tmp392_ = vala_method_get_is_abstract (_tmp391_);
							_tmp393_ = _tmp392_;
							if (!_tmp393_) {
								ValaMethod* _tmp394_;
								gboolean _tmp395_;
								gboolean _tmp396_;
								_tmp394_ = m;
								_tmp395_ = vala_method_get_is_virtual (_tmp394_);
								_tmp396_ = _tmp395_;
								_tmp390_ = !_tmp396_;
							} else {
								_tmp390_ = FALSE;
							}
							if (_tmp390_) {
								ValaProperty* _tmp397_;
								gboolean _tmp398_;
								gboolean _tmp399_;
								_tmp397_ = prop;
								_tmp398_ = vala_property_get_is_abstract (_tmp397_);
								_tmp399_ = _tmp398_;
								_tmp389_ = _tmp399_;
							} else {
								_tmp389_ = FALSE;
							}
							if (_tmp389_) {
								ValaProperty* _tmp400_;
								_tmp400_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp400_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp401_;
						_tmp401_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp401_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp404_ = prop;
				_tmp405_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp404_, "NoAccessorMethod");
				_tmp406_ = _tmp405_;
				_tmp407_ = _tmp406_ == NULL;
				_vala_code_node_unref0 (_tmp406_);
				if (_tmp407_) {
					ValaProperty* _tmp408_;
					ValaPropertyAccessor* _tmp409_;
					ValaPropertyAccessor* _tmp410_;
					_tmp408_ = prop;
					_tmp409_ = vala_property_get_set_accessor (_tmp408_);
					_tmp410_ = _tmp409_;
					_tmp403_ = _tmp410_ != NULL;
				} else {
					_tmp403_ = FALSE;
				}
				if (_tmp403_) {
					ValaProperty* _tmp411_;
					ValaPropertyAccessor* _tmp412_;
					ValaPropertyAccessor* _tmp413_;
					gboolean _tmp414_;
					gboolean _tmp415_;
					_tmp411_ = prop;
					_tmp412_ = vala_property_get_set_accessor (_tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = vala_property_accessor_get_writable (_tmp413_);
					_tmp415_ = _tmp414_;
					_tmp402_ = _tmp415_;
				} else {
					_tmp402_ = FALSE;
				}
				if (_tmp402_) {
					ValaMethod* _tmp416_ = NULL;
					ValaGirParserNode* _tmp417_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp420_;
					ValaMethod* _tmp421_;
					_tmp417_ = setter;
					if (_tmp417_ != NULL) {
						ValaGirParserNode* _tmp418_;
						ValaSymbol* _tmp419_;
						_tmp418_ = setter;
						_tmp419_ = _tmp418_->symbol;
						_tmp416_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp419_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp419_) : NULL;
					} else {
						_tmp416_ = NULL;
					}
					_tmp420_ = _vala_code_node_ref0 (_tmp416_);
					m = _tmp420_;
					_tmp421_ = m;
					if (_tmp421_ != NULL) {
						ValaGirParserNode* _tmp422_;
						gboolean _tmp423_ = FALSE;
						gboolean _tmp424_ = FALSE;
						ValaMethod* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDataType* _tmp427_;
						_tmp422_ = setter;
						vala_gir_parser_node_process (_tmp422_, parser);
						_tmp425_ = m;
						_tmp426_ = vala_callable_get_return_type ((ValaCallable*) _tmp425_);
						_tmp427_ = _tmp426_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_VOID_TYPE)) {
							_tmp424_ = TRUE;
						} else {
							ValaMethod* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							_tmp428_ = m;
							_tmp429_ = vala_callable_get_return_type ((ValaCallable*) _tmp428_);
							_tmp430_ = _tmp429_;
							_tmp424_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp430_, VALA_TYPE_BOOLEAN_TYPE);
						}
						if (!_tmp424_) {
							_tmp423_ = TRUE;
						} else {
							ValaMethod* _tmp431_;
							ValaList* _tmp432_;
							ValaList* _tmp433_;
							gint _tmp434_;
							gint _tmp435_;
							_tmp431_ = m;
							_tmp432_ = vala_callable_get_parameters ((ValaCallable*) _tmp431_);
							_tmp433_ = _tmp432_;
							_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
							_tmp435_ = _tmp434_;
							_tmp423_ = _tmp435_ != 1;
							_vala_iterable_unref0 (_tmp433_);
						}
						if (_tmp423_) {
							ValaProperty* _tmp436_;
							ValaProperty* _tmp437_;
							_tmp436_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp436_, "NoAccessorMethod", TRUE, NULL);
							_tmp437_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp437_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp438_;
							ValaPropertyAccessor* _tmp439_;
							ValaPropertyAccessor* _tmp440_;
							ValaDataType* _tmp441_;
							ValaDataType* _tmp442_;
							ValaMethod* _tmp443_;
							ValaList* _tmp444_;
							ValaList* _tmp445_;
							gpointer _tmp446_;
							ValaParameter* _tmp447_;
							ValaDataType* _tmp448_;
							ValaDataType* _tmp449_;
							gboolean _tmp450_;
							gboolean _tmp451_;
							gboolean _tmp452_ = FALSE;
							gboolean _tmp453_ = FALSE;
							gboolean _tmp454_ = FALSE;
							ValaProperty* _tmp455_;
							ValaAttribute* _tmp456_;
							ValaAttribute* _tmp457_;
							gboolean _tmp458_;
							_tmp438_ = prop;
							_tmp439_ = vala_property_get_set_accessor (_tmp438_);
							_tmp440_ = _tmp439_;
							_tmp441_ = vala_property_accessor_get_value_type (_tmp440_);
							_tmp442_ = _tmp441_;
							_tmp443_ = m;
							_tmp444_ = vala_callable_get_parameters ((ValaCallable*) _tmp443_);
							_tmp445_ = _tmp444_;
							_tmp446_ = vala_list_get (_tmp445_, 0);
							_tmp447_ = (ValaParameter*) _tmp446_;
							_tmp448_ = vala_variable_get_variable_type ((ValaVariable*) _tmp447_);
							_tmp449_ = _tmp448_;
							_tmp450_ = vala_data_type_get_value_owned (_tmp449_);
							_tmp451_ = _tmp450_;
							vala_data_type_set_value_owned (_tmp442_, _tmp451_);
							_vala_code_node_unref0 (_tmp447_);
							_vala_iterable_unref0 (_tmp445_);
							_tmp455_ = prop;
							_tmp456_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp455_, "ConcreteAccessor");
							_tmp457_ = _tmp456_;
							_tmp458_ = _tmp457_ != NULL;
							_vala_code_node_unref0 (_tmp457_);
							if (_tmp458_) {
								ValaMethod* _tmp459_;
								gboolean _tmp460_;
								gboolean _tmp461_;
								_tmp459_ = m;
								_tmp460_ = vala_method_get_is_abstract (_tmp459_);
								_tmp461_ = _tmp460_;
								_tmp454_ = !_tmp461_;
							} else {
								_tmp454_ = FALSE;
							}
							if (_tmp454_) {
								ValaMethod* _tmp462_;
								gboolean _tmp463_;
								gboolean _tmp464_;
								_tmp462_ = m;
								_tmp463_ = vala_method_get_is_virtual (_tmp462_);
								_tmp464_ = _tmp463_;
								_tmp453_ = !_tmp464_;
							} else {
								_tmp453_ = FALSE;
							}
							if (_tmp453_) {
								ValaProperty* _tmp465_;
								gboolean _tmp466_;
								gboolean _tmp467_;
								_tmp465_ = prop;
								_tmp466_ = vala_property_get_is_abstract (_tmp465_);
								_tmp467_ = _tmp466_;
								_tmp452_ = _tmp467_;
							} else {
								_tmp452_ = FALSE;
							}
							if (_tmp452_) {
								ValaProperty* _tmp468_;
								ValaProperty* _tmp469_;
								_tmp468_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp468_, "ConcreteAccessor", TRUE, NULL);
								_tmp469_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp469_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp470_;
						ValaProperty* _tmp471_;
						_tmp470_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp470_, "NoAccessorMethod", TRUE, NULL);
						_tmp471_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp471_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp472_ = prop;
				_tmp473_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp472_, "NoAccessorMethod");
				_tmp474_ = _tmp473_;
				_tmp475_ = _tmp474_ != NULL;
				_vala_code_node_unref0 (_tmp474_);
				if (_tmp475_) {
					gboolean _tmp476_ = FALSE;
					ValaProperty* _tmp477_;
					gboolean _tmp478_;
					gboolean _tmp479_;
					_tmp477_ = prop;
					_tmp478_ = vala_property_get_overrides (_tmp477_);
					_tmp479_ = _tmp478_;
					if (!_tmp479_) {
						ValaGirParserNode* _tmp480_;
						ValaSymbol* _tmp481_;
						_tmp480_ = self->parent;
						_tmp481_ = _tmp480_->symbol;
						_tmp476_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_CLASS);
					} else {
						_tmp476_ = FALSE;
					}
					if (_tmp476_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp482_;
						ValaGirParserNode* _tmp483_;
						_tmp482_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp482_;
						_tmp483_ = base_prop_node;
						if (_tmp483_ != NULL) {
							ValaGirParserNode* _tmp484_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp485_;
							ValaSymbol* _tmp486_;
							ValaProperty* _tmp487_;
							ValaProperty* _tmp488_;
							ValaAttribute* _tmp489_;
							ValaAttribute* _tmp490_;
							gboolean _tmp491_;
							_tmp484_ = base_prop_node;
							vala_gir_parser_node_process (_tmp484_, parser);
							_tmp485_ = base_prop_node;
							_tmp486_ = _tmp485_->symbol;
							_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp487_;
							_tmp488_ = base_property;
							_tmp489_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp488_, "ConcreteAccessor");
							_tmp490_ = _tmp489_;
							_tmp491_ = _tmp490_ != NULL;
							_vala_code_node_unref0 (_tmp490_);
							if (_tmp491_) {
								ValaProperty* _tmp492_;
								ValaProperty* _tmp493_;
								ValaPropertyAccessor* _tmp494_;
								ValaPropertyAccessor* _tmp495_;
								ValaProperty* _tmp508_;
								ValaPropertyAccessor* _tmp509_;
								ValaPropertyAccessor* _tmp510_;
								_tmp492_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp492_, "NoAccessorMethod", FALSE, NULL);
								_tmp493_ = prop;
								_tmp494_ = vala_property_get_get_accessor (_tmp493_);
								_tmp495_ = _tmp494_;
								if (_tmp495_ != NULL) {
									ValaProperty* _tmp496_;
									ValaPropertyAccessor* _tmp497_;
									ValaPropertyAccessor* _tmp498_;
									ValaDataType* _tmp499_;
									ValaDataType* _tmp500_;
									ValaProperty* _tmp501_;
									ValaPropertyAccessor* _tmp502_;
									ValaPropertyAccessor* _tmp503_;
									ValaDataType* _tmp504_;
									ValaDataType* _tmp505_;
									gboolean _tmp506_;
									gboolean _tmp507_;
									_tmp496_ = prop;
									_tmp497_ = vala_property_get_get_accessor (_tmp496_);
									_tmp498_ = _tmp497_;
									_tmp499_ = vala_property_accessor_get_value_type (_tmp498_);
									_tmp500_ = _tmp499_;
									_tmp501_ = base_property;
									_tmp502_ = vala_property_get_get_accessor (_tmp501_);
									_tmp503_ = _tmp502_;
									_tmp504_ = vala_property_accessor_get_value_type (_tmp503_);
									_tmp505_ = _tmp504_;
									_tmp506_ = vala_data_type_get_value_owned (_tmp505_);
									_tmp507_ = _tmp506_;
									vala_data_type_set_value_owned (_tmp500_, _tmp507_);
								}
								_tmp508_ = prop;
								_tmp509_ = vala_property_get_set_accessor (_tmp508_);
								_tmp510_ = _tmp509_;
								if (_tmp510_ != NULL) {
									ValaProperty* _tmp511_;
									ValaPropertyAccessor* _tmp512_;
									ValaPropertyAccessor* _tmp513_;
									ValaDataType* _tmp514_;
									ValaDataType* _tmp515_;
									ValaProperty* _tmp516_;
									ValaPropertyAccessor* _tmp517_;
									ValaPropertyAccessor* _tmp518_;
									ValaDataType* _tmp519_;
									ValaDataType* _tmp520_;
									gboolean _tmp521_;
									gboolean _tmp522_;
									_tmp511_ = prop;
									_tmp512_ = vala_property_get_set_accessor (_tmp511_);
									_tmp513_ = _tmp512_;
									_tmp514_ = vala_property_accessor_get_value_type (_tmp513_);
									_tmp515_ = _tmp514_;
									_tmp516_ = base_property;
									_tmp517_ = vala_property_get_set_accessor (_tmp516_);
									_tmp518_ = _tmp517_;
									_tmp519_ = vala_property_accessor_get_value_type (_tmp518_);
									_tmp520_ = _tmp519_;
									_tmp521_ = vala_data_type_get_value_owned (_tmp520_);
									_tmp522_ = _tmp521_;
									vala_data_type_set_value_owned (_tmp515_, _tmp522_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp523_ = prop;
				_tmp524_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp523_, "NoAccessorMethod");
				_tmp525_ = _tmp524_;
				_tmp526_ = _tmp525_ != NULL;
				_vala_code_node_unref0 (_tmp525_);
				if (_tmp526_) {
					ValaProperty* _tmp527_;
					ValaPropertyAccessor* _tmp528_;
					ValaPropertyAccessor* _tmp529_;
					ValaProperty* _tmp535_;
					ValaPropertyAccessor* _tmp536_;
					ValaPropertyAccessor* _tmp537_;
					_tmp527_ = prop;
					_tmp528_ = vala_property_get_get_accessor (_tmp527_);
					_tmp529_ = _tmp528_;
					if (_tmp529_ != NULL) {
						ValaProperty* _tmp530_;
						ValaPropertyAccessor* _tmp531_;
						ValaPropertyAccessor* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						_tmp530_ = prop;
						_tmp531_ = vala_property_get_get_accessor (_tmp530_);
						_tmp532_ = _tmp531_;
						_tmp533_ = vala_property_accessor_get_value_type (_tmp532_);
						_tmp534_ = _tmp533_;
						vala_data_type_set_value_owned (_tmp534_, TRUE);
					}
					_tmp535_ = prop;
					_tmp536_ = vala_property_get_set_accessor (_tmp535_);
					_tmp537_ = _tmp536_;
					if (_tmp537_ != NULL) {
						ValaProperty* _tmp538_;
						ValaPropertyAccessor* _tmp539_;
						ValaPropertyAccessor* _tmp540_;
						ValaDataType* _tmp541_;
						ValaDataType* _tmp542_;
						_tmp538_ = prop;
						_tmp539_ = vala_property_get_set_accessor (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp541_ = vala_property_accessor_get_value_type (_tmp540_);
						_tmp542_ = _tmp541_;
						vala_data_type_set_value_owned (_tmp542_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp543_;
				_tmp543_ = self->symbol;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp543_, VALA_TYPE_FIELD)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp544_;
					ValaField* _tmp545_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp546_;
					const gchar* _tmp547_;
					ValaArrayList* _tmp548_;
					ValaArrayList* _tmp549_;
					gint _tmp550_;
					gint _tmp551_;
					ValaGirParserMetadata* _tmp552_;
					gboolean _tmp557_ = FALSE;
					ValaField* _tmp558_;
					ValaDataType* _tmp559_;
					ValaDataType* _tmp560_;
					_tmp544_ = self->symbol;
					_tmp545_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp544_, VALA_TYPE_FIELD, ValaField));
					field = _tmp545_;
					_tmp546_ = self->parent;
					_tmp547_ = self->name;
					_tmp548_ = vala_gir_parser_node_lookup_all (_tmp546_, _tmp547_);
					colliding = _tmp548_;
					_tmp549_ = colliding;
					_tmp550_ = vala_collection_get_size ((ValaCollection*) _tmp549_);
					_tmp551_ = _tmp550_;
					if (_tmp551_ > 1) {
						self->merged = TRUE;
					}
					_tmp552_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp552_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp553_;
						ValaGirParserMetadata* _tmp554_;
						gchar* _tmp555_;
						gchar* _tmp556_;
						_tmp553_ = field;
						_tmp554_ = self->metadata;
						_tmp555_ = vala_gir_parser_metadata_get_string (_tmp554_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp556_ = _tmp555_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp553_, "CCode", "delegate_target_cname", _tmp556_, NULL);
						_g_free0 (_tmp556_);
					}
					_tmp558_ = field;
					_tmp559_ = vala_variable_get_variable_type ((ValaVariable*) _tmp558_);
					_tmp560_ = _tmp559_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp560_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaGirParserNode* _tmp561_;
						ValaUnresolvedSymbol* _tmp562_;
						_tmp561_ = self->parent;
						_tmp562_ = _tmp561_->gtype_struct_for;
						_tmp557_ = _tmp562_ != NULL;
					} else {
						_tmp557_ = FALSE;
					}
					if (_tmp557_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp563_;
						ValaDataType* _tmp564_;
						ValaDataType* _tmp565_;
						ValaDelegate* _tmp566_;
						ValaDelegate* _tmp567_;
						ValaDelegate* _tmp568_;
						ValaDelegate* _tmp569_;
						ValaGirParserNode* _tmp570_;
						ValaUnresolvedSymbol* _tmp571_;
						_tmp563_ = field;
						_tmp564_ = vala_variable_get_variable_type ((ValaVariable*) _tmp563_);
						_tmp565_ = _tmp564_;
						_tmp566_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp565_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp567_ = _tmp566_;
						_tmp568_ = _vala_code_node_ref0 (_tmp567_);
						d = _tmp568_;
						_tmp569_ = d;
						_tmp570_ = self->parent;
						_tmp571_ = _tmp570_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp569_, _tmp571_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp572_;
						ValaDataType* _tmp573_;
						ValaDataType* _tmp574_;
						_tmp572_ = field;
						_tmp573_ = vala_variable_get_variable_type ((ValaVariable*) _tmp572_);
						_tmp574_ = _tmp573_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp574_, VALA_TYPE_ARRAY_TYPE)) {
							ValaGirParserNode* array_length = NULL;
							ValaGirParserMetadata* _tmp575_;
							gboolean _tmp615_ = FALSE;
							ValaGirParserNode* _tmp616_;
							_tmp575_ = self->metadata;
							if (vala_gir_parser_metadata_has_argument (_tmp575_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
								ValaGirParserNode* _tmp576_;
								ValaGirParserMetadata* _tmp577_;
								gchar* _tmp578_;
								gchar* _tmp579_;
								ValaGirParserNode* _tmp580_;
								_tmp576_ = self->parent;
								_tmp577_ = self->metadata;
								_tmp578_ = vala_gir_parser_metadata_get_string (_tmp577_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
								_tmp579_ = _tmp578_;
								_tmp580_ = vala_gir_parser_node_lookup (_tmp576_, _tmp579_, FALSE, NULL);
								_vala_gir_parser_node_unref0 (array_length);
								array_length = _tmp580_;
								_g_free0 (_tmp579_);
							} else {
								gboolean _tmp581_ = FALSE;
								gint _tmp582_;
								_tmp582_ = self->array_length_idx;
								if (_tmp582_ > -1) {
									ValaGirParserNode* _tmp583_;
									ValaArrayList* _tmp584_;
									gint _tmp585_;
									gint _tmp586_;
									gint _tmp587_;
									_tmp583_ = self->parent;
									_tmp584_ = _tmp583_->members;
									_tmp585_ = vala_collection_get_size ((ValaCollection*) _tmp584_);
									_tmp586_ = _tmp585_;
									_tmp587_ = self->array_length_idx;
									_tmp581_ = _tmp586_ > _tmp587_;
								} else {
									_tmp581_ = FALSE;
								}
								if (_tmp581_) {
									ValaGirParserNode* _tmp588_;
									ValaArrayList* _tmp589_;
									gint _tmp590_;
									gpointer _tmp591_;
									_tmp588_ = self->parent;
									_tmp589_ = _tmp588_->members;
									_tmp590_ = self->array_length_idx;
									_tmp591_ = vala_list_get ((ValaList*) _tmp589_, _tmp590_);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = (ValaGirParserNode*) _tmp591_;
								} else {
									ValaGirParserNode* _tmp592_;
									ValaField* _tmp593_;
									const gchar* _tmp594_;
									const gchar* _tmp595_;
									gchar* _tmp596_;
									gchar* _tmp597_;
									ValaGirParserNode* _tmp598_;
									ValaGirParserNode* _tmp599_;
									_tmp592_ = self->parent;
									_tmp593_ = field;
									_tmp594_ = vala_symbol_get_name ((ValaSymbol*) _tmp593_);
									_tmp595_ = _tmp594_;
									_tmp596_ = g_strdup_printf ("n_%s", _tmp595_);
									_tmp597_ = _tmp596_;
									_tmp598_ = vala_gir_parser_node_lookup (_tmp592_, _tmp597_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp598_;
									_g_free0 (_tmp597_);
									_tmp599_ = array_length;
									if (_tmp599_ == NULL) {
										ValaGirParserNode* _tmp600_;
										ValaField* _tmp601_;
										const gchar* _tmp602_;
										const gchar* _tmp603_;
										gchar* _tmp604_;
										gchar* _tmp605_;
										ValaGirParserNode* _tmp606_;
										ValaGirParserNode* _tmp607_;
										_tmp600_ = self->parent;
										_tmp601_ = field;
										_tmp602_ = vala_symbol_get_name ((ValaSymbol*) _tmp601_);
										_tmp603_ = _tmp602_;
										_tmp604_ = g_strdup_printf ("num_%s", _tmp603_);
										_tmp605_ = _tmp604_;
										_tmp606_ = vala_gir_parser_node_lookup (_tmp600_, _tmp605_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp606_;
										_g_free0 (_tmp605_);
										_tmp607_ = array_length;
										if (_tmp607_ == NULL) {
											ValaGirParserNode* _tmp608_;
											ValaField* _tmp609_;
											const gchar* _tmp610_;
											const gchar* _tmp611_;
											gchar* _tmp612_;
											gchar* _tmp613_;
											ValaGirParserNode* _tmp614_;
											_tmp608_ = self->parent;
											_tmp609_ = field;
											_tmp610_ = vala_symbol_get_name ((ValaSymbol*) _tmp609_);
											_tmp611_ = _tmp610_;
											_tmp612_ = g_strdup_printf ("%s_length", _tmp611_);
											_tmp613_ = _tmp612_;
											_tmp614_ = vala_gir_parser_node_lookup (_tmp608_, _tmp613_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp614_;
											_g_free0 (_tmp613_);
										}
									}
								}
							}
							_tmp616_ = array_length;
							if (_tmp616_ != NULL) {
								ValaGirParserNode* _tmp617_;
								ValaSymbol* _tmp618_;
								_tmp617_ = array_length;
								_tmp618_ = _tmp617_->symbol;
								_tmp615_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp618_, VALA_TYPE_FIELD);
							} else {
								_tmp615_ = FALSE;
							}
							if (_tmp615_) {
								ValaField* length_field = NULL;
								ValaGirParserNode* _tmp619_;
								ValaSymbol* _tmp620_;
								ValaField* _tmp621_;
								ValaField* _tmp622_;
								ValaField* _tmp623_;
								const gchar* _tmp624_;
								const gchar* _tmp625_;
								gchar* length_type = NULL;
								ValaField* _tmp626_;
								ValaDataType* _tmp627_;
								ValaDataType* _tmp628_;
								gchar* _tmp629_;
								const gchar* _tmp630_;
								ValaField* _tmp639_;
								ValaField* _tmp640_;
								_tmp619_ = array_length;
								_tmp620_ = _tmp619_->symbol;
								_tmp621_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp620_, VALA_TYPE_FIELD, ValaField));
								length_field = _tmp621_;
								_tmp622_ = field;
								_tmp623_ = length_field;
								_tmp624_ = vala_symbol_get_name ((ValaSymbol*) _tmp623_);
								_tmp625_ = _tmp624_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp622_, "CCode", "array_length_cname", _tmp625_, NULL);
								_tmp626_ = length_field;
								_tmp627_ = vala_variable_get_variable_type ((ValaVariable*) _tmp626_);
								_tmp628_ = _tmp627_;
								_tmp629_ = vala_data_type_to_qualified_string (_tmp628_, NULL);
								length_type = _tmp629_;
								_tmp630_ = length_type;
								if (g_strcmp0 (_tmp630_, "int") != 0) {
									ValaGirParserNode* st = NULL;
									ValaGirParserNode* _tmp631_;
									const gchar* _tmp632_;
									ValaGirParserNode* _tmp633_;
									ValaGirParserNode* _tmp634_;
									_tmp631_ = parser->priv->root;
									_tmp632_ = length_type;
									_tmp633_ = vala_gir_parser_node_lookup (_tmp631_, _tmp632_, FALSE, NULL);
									st = _tmp633_;
									_tmp634_ = st;
									if (_tmp634_ != NULL) {
										ValaField* _tmp635_;
										ValaGirParserNode* _tmp636_;
										gchar* _tmp637_;
										gchar* _tmp638_;
										_tmp635_ = field;
										_tmp636_ = st;
										_tmp637_ = vala_gir_parser_node_get_cname (_tmp636_);
										_tmp638_ = _tmp637_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp635_, "CCode", "array_length_type", _tmp638_, NULL);
										_g_free0 (_tmp638_);
									}
									_vala_gir_parser_node_unref0 (st);
								}
								_tmp639_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp639_, "CCode", "array_length");
								_tmp640_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp640_, "CCode", "array_null_terminated");
								_g_free0 (length_type);
								_vala_code_node_unref0 (length_field);
							}
							_vala_gir_parser_node_unref0 (array_length);
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp641_ = FALSE;
					ValaSymbol* _tmp642_;
					_tmp642_ = self->symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp642_, VALA_TYPE_SIGNAL)) {
						_tmp641_ = TRUE;
					} else {
						ValaSymbol* _tmp643_;
						_tmp643_ = self->symbol;
						_tmp641_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp643_, VALA_TYPE_DELEGATE);
					}
					if (_tmp641_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp644_;
						_tmp644_ = self->symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp644_, VALA_TYPE_INTERFACE)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp645_;
							_tmp645_ = self->symbol;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp645_, VALA_TYPE_STRUCT)) {
								gboolean _tmp646_ = FALSE;
								ValaGirParserNode* _tmp647_;
								ValaSymbol* _tmp648_;
								_tmp647_ = self->parent;
								_tmp648_ = _tmp647_->symbol;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp648_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
									_tmp646_ = TRUE;
								} else {
									ValaGirParserNode* _tmp649_;
									ValaSymbol* _tmp650_;
									_tmp649_ = self->parent;
									_tmp650_ = _tmp649_->symbol;
									_tmp646_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp650_, VALA_TYPE_STRUCT);
								}
								if (_tmp646_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp651_;
										ValaArrayList* _tmp652_;
										gint _fn_size = 0;
										ValaArrayList* _tmp653_;
										gint _tmp654_;
										gint _tmp655_;
										gint _fn_index = 0;
										_tmp651_ = self->members;
										_tmp652_ = _vala_iterable_ref0 (_tmp651_);
										_fn_list = _tmp652_;
										_tmp653_ = _fn_list;
										_tmp654_ = vala_collection_get_size ((ValaCollection*) _tmp653_);
										_tmp655_ = _tmp654_;
										_fn_size = _tmp655_;
										_fn_index = -1;
										while (TRUE) {
											gint _tmp656_;
											gint _tmp657_;
											gint _tmp658_;
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp659_;
											gint _tmp660_;
											gpointer _tmp661_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp662_;
											ValaSymbol* _tmp663_;
											ValaField* _tmp664_;
											ValaField* _tmp665_;
											_tmp656_ = _fn_index;
											_fn_index = _tmp656_ + 1;
											_tmp657_ = _fn_index;
											_tmp658_ = _fn_size;
											if (!(_tmp657_ < _tmp658_)) {
												break;
											}
											_tmp659_ = _fn_list;
											_tmp660_ = _fn_index;
											_tmp661_ = vala_list_get ((ValaList*) _tmp659_, _tmp660_);
											fn = (ValaGirParserNode*) _tmp661_;
											_tmp662_ = fn;
											_tmp663_ = _tmp662_->symbol;
											_tmp664_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp663_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp663_) : NULL);
											f = _tmp664_;
											_tmp665_ = f;
											if (_tmp665_ != NULL) {
												ValaField* _tmp666_;
												ValaMemberBinding _tmp667_;
												ValaMemberBinding _tmp668_;
												ValaField* _tmp676_;
												ValaSymbol* _tmp677_;
												const gchar* _tmp678_;
												const gchar* _tmp679_;
												ValaField* _tmp680_;
												const gchar* _tmp681_;
												const gchar* _tmp682_;
												gchar* _tmp683_;
												gchar* _tmp684_;
												ValaGirParserNode* _tmp685_;
												ValaField* _tmp686_;
												const gchar* _tmp687_;
												const gchar* _tmp688_;
												gchar* _tmp689_;
												ValaGirParserNode* _tmp690_;
												ValaGirParserNode* _tmp691_;
												_tmp666_ = f;
												_tmp667_ = vala_field_get_binding (_tmp666_);
												_tmp668_ = _tmp667_;
												if (_tmp668_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp669_;
													const gchar* _tmp670_;
													ValaGirParserNode* _tmp671_;
													gchar* _tmp672_;
													gchar* _tmp673_;
													gchar* _tmp674_;
													gchar* _tmp675_;
													_tmp669_ = f;
													_tmp670_ = self->name;
													_tmp671_ = fn;
													_tmp672_ = vala_gir_parser_node_get_cname (_tmp671_);
													_tmp673_ = _tmp672_;
													_tmp674_ = g_strdup_printf ("%s.%s", _tmp670_, _tmp673_);
													_tmp675_ = _tmp674_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp669_, "CCode", "cname", _tmp675_, NULL);
													_g_free0 (_tmp675_);
													_g_free0 (_tmp673_);
												}
												_tmp676_ = f;
												_tmp677_ = self->symbol;
												_tmp678_ = vala_symbol_get_name (_tmp677_);
												_tmp679_ = _tmp678_;
												_tmp680_ = f;
												_tmp681_ = vala_symbol_get_name ((ValaSymbol*) _tmp680_);
												_tmp682_ = _tmp681_;
												_tmp683_ = g_strdup_printf ("%s_%s", _tmp679_, _tmp682_);
												_tmp684_ = _tmp683_;
												vala_symbol_set_name ((ValaSymbol*) _tmp676_, _tmp684_);
												_g_free0 (_tmp684_);
												_tmp685_ = fn;
												_tmp686_ = f;
												_tmp687_ = vala_symbol_get_name ((ValaSymbol*) _tmp686_);
												_tmp688_ = _tmp687_;
												_tmp689_ = g_strdup (_tmp688_);
												_g_free0 (_tmp685_->name);
												_tmp685_->name = _tmp689_;
												_tmp690_ = self->parent;
												_tmp691_ = fn;
												vala_gir_parser_node_add_member (_tmp690_, _tmp691_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
										_vala_iterable_unref0 (_fn_list);
									}
									self->merged = TRUE;
								} else {
									gchar* gtype_struct_for = NULL;
									ValaMap* _tmp692_;
									gpointer _tmp693_;
									const gchar* _tmp694_;
									_tmp692_ = self->girdata;
									_tmp693_ = vala_map_get (_tmp692_, "glib:is-gtype-struct-for");
									gtype_struct_for = (gchar*) _tmp693_;
									_tmp694_ = gtype_struct_for;
									if (_tmp694_ != NULL) {
										ValaGirParserNode* iface = NULL;
										ValaGirParserNode* _tmp695_;
										const gchar* _tmp696_;
										ValaSourceReference* _tmp697_;
										ValaUnresolvedSymbol* _tmp698_;
										ValaUnresolvedSymbol* _tmp699_;
										ValaGirParserNode* _tmp700_;
										ValaGirParserNode* _tmp701_;
										gboolean _tmp702_ = FALSE;
										gboolean _tmp703_ = FALSE;
										ValaGirParserNode* _tmp704_;
										_tmp695_ = self->parent;
										_tmp696_ = gtype_struct_for;
										_tmp697_ = self->source_reference;
										_tmp698_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp696_, _tmp697_);
										_tmp699_ = _tmp698_;
										_tmp700_ = vala_gir_parser_resolve_node (parser, _tmp695_, _tmp699_, FALSE);
										_tmp701_ = _tmp700_;
										_vala_code_node_unref0 (_tmp699_);
										iface = _tmp701_;
										_tmp704_ = iface;
										if (_tmp704_ != NULL) {
											ValaGirParserNode* _tmp705_;
											ValaSymbol* _tmp706_;
											_tmp705_ = iface;
											_tmp706_ = _tmp705_->symbol;
											_tmp703_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp706_, VALA_TYPE_INTERFACE);
										} else {
											_tmp703_ = FALSE;
										}
										if (_tmp703_) {
											ValaGirParserNode* _tmp707_;
											gchar* _tmp708_;
											gchar* _tmp709_;
											gchar* _tmp710_;
											gchar* _tmp711_;
											gchar* _tmp712_;
											gchar* _tmp713_;
											_tmp707_ = iface;
											_tmp708_ = vala_gir_parser_node_get_cname (_tmp707_);
											_tmp709_ = _tmp708_;
											_tmp710_ = g_strdup_printf ("%sIface", _tmp709_);
											_tmp711_ = _tmp710_;
											_tmp712_ = vala_gir_parser_node_get_cname (self);
											_tmp713_ = _tmp712_;
											_tmp702_ = g_strcmp0 (_tmp711_, _tmp713_) != 0;
											_g_free0 (_tmp713_);
											_g_free0 (_tmp711_);
											_g_free0 (_tmp709_);
										} else {
											_tmp702_ = FALSE;
										}
										if (_tmp702_) {
											ValaGirParserNode* _tmp714_;
											ValaSymbol* _tmp715_;
											gchar* _tmp716_;
											gchar* _tmp717_;
											_tmp714_ = iface;
											_tmp715_ = _tmp714_->symbol;
											_tmp716_ = vala_gir_parser_node_get_cname (self);
											_tmp717_ = _tmp716_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp715_, "CCode", "type_cname", _tmp717_, NULL);
											_g_free0 (_tmp717_);
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (iface);
									}
									_g_free0 (gtype_struct_for);
								}
							}
						}
					}
				}
			}
		}
		_tmp718_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp718_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp719_;
			gchar* _tmp720_;
			self->deprecated = TRUE;
			_tmp719_ = self->metadata;
			_tmp720_ = vala_gir_parser_metadata_get_string (_tmp719_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp720_;
		}
		_tmp721_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp721_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp722_;
			gchar* _tmp723_;
			self->deprecated = TRUE;
			_tmp722_ = self->metadata;
			_tmp723_ = vala_gir_parser_metadata_get_string (_tmp722_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp723_;
		} else {
			ValaMap* _tmp724_;
			gpointer _tmp725_;
			gchar* _tmp726_;
			gboolean _tmp727_;
			_tmp724_ = self->girdata;
			_tmp725_ = vala_map_get (_tmp724_, "deprecated-version");
			_tmp726_ = (gchar*) _tmp725_;
			_tmp727_ = _tmp726_ != NULL;
			_g_free0 (_tmp726_);
			if (_tmp727_) {
				ValaMap* _tmp728_;
				gpointer _tmp729_;
				self->deprecated = TRUE;
				_tmp728_ = self->girdata;
				_tmp729_ = vala_map_get (_tmp728_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp729_;
			}
		}
		_tmp730_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp730_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp731_;
			gboolean _tmp732_;
			_tmp731_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp731_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			_tmp732_ = self->deprecated;
			if (!_tmp732_) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp733_;
			gpointer _tmp734_;
			gchar* _tmp735_;
			gboolean _tmp736_;
			_tmp733_ = self->girdata;
			_tmp734_ = vala_map_get (_tmp733_, "deprecated");
			_tmp735_ = (gchar*) _tmp734_;
			_tmp736_ = _tmp735_ != NULL;
			_g_free0 (_tmp735_);
			if (_tmp736_) {
				self->deprecated = TRUE;
			}
		}
		_tmp737_ = self->deprecated_since;
		if (_tmp737_ != NULL) {
			const gchar* _tmp738_;
			_tmp738_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp738_);
		}
		_tmp739_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp739_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp740_;
			ValaGirParserMetadata* _tmp741_;
			_tmp740_ = self->symbol;
			_tmp741_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp740_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp741_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp742_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp742_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp743_;
			ValaVersionAttribute* _tmp744_;
			ValaVersionAttribute* _tmp745_;
			ValaGirParserMetadata* _tmp746_;
			gchar* _tmp747_;
			gchar* _tmp748_;
			_tmp743_ = self->symbol;
			_tmp744_ = vala_symbol_get_version (_tmp743_);
			_tmp745_ = _tmp744_;
			_tmp746_ = self->metadata;
			_tmp747_ = vala_gir_parser_metadata_get_string (_tmp746_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp748_ = _tmp747_;
			vala_version_attribute_set_since (_tmp745_, _tmp748_);
			_g_free0 (_tmp748_);
		} else {
			gboolean _tmp749_ = FALSE;
			ValaSymbol* _tmp750_;
			_tmp750_ = self->symbol;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp750_, VALA_TYPE_NAMESPACE) == FALSE) {
				ValaMap* _tmp751_;
				gpointer _tmp752_;
				gchar* _tmp753_;
				_tmp751_ = self->girdata;
				_tmp752_ = vala_map_get (_tmp751_, "version");
				_tmp753_ = (gchar*) _tmp752_;
				_tmp749_ = _tmp753_ != NULL;
				_g_free0 (_tmp753_);
			} else {
				_tmp749_ = FALSE;
			}
			if (_tmp749_) {
				ValaSymbol* _tmp754_;
				ValaVersionAttribute* _tmp755_;
				ValaVersionAttribute* _tmp756_;
				ValaMap* _tmp757_;
				gpointer _tmp758_;
				gchar* _tmp759_;
				_tmp754_ = self->symbol;
				_tmp755_ = vala_symbol_get_version (_tmp754_);
				_tmp756_ = _tmp755_;
				_tmp757_ = self->girdata;
				_tmp758_ = vala_map_get (_tmp757_, "version");
				_tmp759_ = (gchar*) _tmp758_;
				vala_version_attribute_set_since (_tmp756_, _tmp759_);
				_g_free0 (_tmp759_);
			}
		}
		_tmp760_ = self->parent;
		_tmp761_ = _tmp760_->symbol;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp761_, VALA_TYPE_NAMESPACE)) {
			ValaSymbol* _tmp762_;
			gchar* _tmp763_;
			gchar* _tmp764_;
			_tmp762_ = self->symbol;
			_tmp763_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp764_ = _tmp763_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp762_, "CCode", "cheader_filename", _tmp764_, NULL);
			_g_free0 (_tmp764_);
		} else {
			ValaGirParserMetadata* _tmp765_;
			_tmp765_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp765_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp766_;
				ValaGirParserMetadata* _tmp767_;
				gchar* _tmp768_;
				gchar* _tmp769_;
				_tmp766_ = self->symbol;
				_tmp767_ = self->metadata;
				_tmp768_ = vala_gir_parser_metadata_get_string (_tmp767_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp769_ = _tmp768_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp766_, "CCode", "cheader_filename", _tmp769_, NULL);
				_g_free0 (_tmp769_);
			}
		}
		_tmp770_ = vala_gir_parser_node_get_cname (self);
		_tmp771_ = _tmp770_;
		_tmp772_ = vala_gir_parser_node_get_default_cname (self);
		_tmp773_ = _tmp772_;
		_tmp774_ = g_strcmp0 (_tmp771_, _tmp773_) != 0;
		_g_free0 (_tmp773_);
		_g_free0 (_tmp771_);
		if (_tmp774_) {
			ValaSymbol* _tmp775_;
			gchar* _tmp776_;
			gchar* _tmp777_;
			_tmp775_ = self->symbol;
			_tmp776_ = vala_gir_parser_node_get_cname (self);
			_tmp777_ = _tmp776_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp775_, "CCode", "cname", _tmp777_, NULL);
			_g_free0 (_tmp777_);
		}
		_tmp778_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp779_ = _tmp778_;
		_tmp780_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp781_ = _tmp780_;
		_tmp782_ = g_strcmp0 (_tmp779_, _tmp781_) != 0;
		_g_free0 (_tmp781_);
		_g_free0 (_tmp779_);
		if (_tmp782_) {
			ValaSymbol* _tmp783_;
			gchar* _tmp784_;
			gchar* _tmp785_;
			_tmp783_ = self->symbol;
			_tmp784_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp785_ = _tmp784_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp783_, "CCode", "lower_case_cprefix", _tmp785_, NULL);
			_g_free0 (_tmp785_);
		}
		_tmp786_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp787_ = _tmp786_;
		_tmp788_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp789_ = _tmp788_;
		_tmp790_ = g_strcmp0 (_tmp787_, _tmp789_) != 0;
		_g_free0 (_tmp789_);
		_g_free0 (_tmp787_);
		if (_tmp790_) {
			ValaSymbol* _tmp791_;
			gchar* _tmp792_;
			gchar* _tmp793_;
			_tmp791_ = self->symbol;
			_tmp792_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp793_ = _tmp792_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp791_, "CCode", "lower_case_csuffix", _tmp793_, NULL);
			_g_free0 (_tmp793_);
		}
		_tmp794_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp794_;
		_tmp795_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp795_;
		_tmp798_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp798_)) {
			ValaSymbol* _tmp799_;
			_tmp799_ = self->symbol;
			_tmp797_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp799_, VALA_TYPE_NAMESPACE);
		} else {
			_tmp797_ = FALSE;
		}
		if (_tmp797_) {
			gboolean _tmp800_ = FALSE;
			const gchar* _tmp801_;
			const gchar* _tmp802_;
			_tmp801_ = self->name;
			_tmp802_ = gir_name;
			if (g_strcmp0 (_tmp801_, _tmp802_) != 0) {
				_tmp800_ = TRUE;
			} else {
				const gchar* _tmp803_;
				const gchar* _tmp804_;
				_tmp803_ = gir_name;
				_tmp804_ = default_gir_name;
				_tmp800_ = g_strcmp0 (_tmp803_, _tmp804_) != 0;
			}
			_tmp796_ = _tmp800_;
		} else {
			_tmp796_ = FALSE;
		}
		if (_tmp796_) {
			ValaSymbol* _tmp805_;
			const gchar* _tmp806_;
			_tmp805_ = self->symbol;
			_tmp806_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp805_, "GIR", "name", _tmp806_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	_tmp809_ = self->new_symbol;
	if (_tmp809_) {
		gboolean _tmp810_;
		_tmp810_ = self->merged;
		_tmp808_ = _tmp810_;
	} else {
		_tmp808_ = FALSE;
	}
	if (!_tmp808_) {
		ValaSymbol* _tmp811_;
		_tmp811_ = self->symbol;
		_tmp807_ = vala_gir_parser_is_container (_tmp811_);
	} else {
		_tmp807_ = FALSE;
	}
	if (_tmp807_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp865_;
		ValaClass* _tmp866_;
		gboolean _tmp867_ = FALSE;
		gboolean _tmp868_ = FALSE;
		ValaClass* _tmp869_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp812_;
			ValaArrayList* _tmp813_;
			gint _node_size = 0;
			ValaArrayList* _tmp814_;
			gint _tmp815_;
			gint _tmp816_;
			gint _node_index = 0;
			_tmp812_ = self->members;
			_tmp813_ = _vala_iterable_ref0 (_tmp812_);
			_node_list = _tmp813_;
			_tmp814_ = _node_list;
			_tmp815_ = vala_collection_get_size ((ValaCollection*) _tmp814_);
			_tmp816_ = _tmp815_;
			_node_size = _tmp816_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp817_;
				gint _tmp818_;
				gint _tmp819_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp820_;
				gint _tmp821_;
				gpointer _tmp822_;
				gboolean _tmp823_ = FALSE;
				guint64 _tmp824_;
				ValaGirParserNode* _tmp833_;
				gboolean _tmp834_;
				ValaGirParserNode* _tmp839_;
				const gchar* _tmp840_;
				ValaGirParserNode* _tmp847_;
				const gchar* _tmp848_;
				gboolean _tmp855_ = FALSE;
				gboolean _tmp856_ = FALSE;
				ValaGirParserNode* _tmp857_;
				gboolean _tmp858_;
				_tmp817_ = _node_index;
				_node_index = _tmp817_ + 1;
				_tmp818_ = _node_index;
				_tmp819_ = _node_size;
				if (!(_tmp818_ < _tmp819_)) {
					break;
				}
				_tmp820_ = _node_list;
				_tmp821_ = _node_index;
				_tmp822_ = vala_list_get ((ValaList*) _tmp820_, _tmp821_);
				node = (ValaGirParserNode*) _tmp822_;
				_tmp824_ = self->deprecated_version;
				if (_tmp824_ > ((guint64) 0)) {
					ValaGirParserNode* _tmp825_;
					guint64 _tmp826_;
					_tmp825_ = node;
					_tmp826_ = _tmp825_->deprecated_version;
					_tmp823_ = _tmp826_ > ((guint64) 0);
				} else {
					_tmp823_ = FALSE;
				}
				if (_tmp823_) {
					guint64 _tmp827_;
					ValaGirParserNode* _tmp828_;
					guint64 _tmp829_;
					_tmp827_ = self->deprecated_version;
					_tmp828_ = node;
					_tmp829_ = _tmp828_->deprecated_version;
					if (_tmp827_ <= _tmp829_) {
						ValaGirParserNode* _tmp830_;
						ValaGirParserNode* _tmp831_;
						ValaGirParserNode* _tmp832_;
						_tmp830_ = node;
						_tmp830_->deprecated = FALSE;
						_tmp831_ = node;
						_g_free0 (_tmp831_->deprecated_since);
						_tmp831_->deprecated_since = NULL;
						_tmp832_ = node;
						_g_free0 (_tmp832_->deprecated_replacement);
						_tmp832_->deprecated_replacement = NULL;
					}
				}
				_tmp833_ = node;
				_tmp834_ = _tmp833_->deprecated;
				if (_tmp834_) {
					ValaGirParserNode* _tmp835_;
					ValaSymbol* _tmp836_;
					ValaVersionAttribute* _tmp837_;
					ValaVersionAttribute* _tmp838_;
					_tmp835_ = node;
					_tmp836_ = _tmp835_->symbol;
					_tmp837_ = vala_symbol_get_version (_tmp836_);
					_tmp838_ = _tmp837_;
					vala_version_attribute_set_deprecated (_tmp838_, TRUE);
				}
				_tmp839_ = node;
				_tmp840_ = _tmp839_->deprecated_since;
				if (_tmp840_ != NULL) {
					ValaGirParserNode* _tmp841_;
					ValaSymbol* _tmp842_;
					ValaVersionAttribute* _tmp843_;
					ValaVersionAttribute* _tmp844_;
					ValaGirParserNode* _tmp845_;
					const gchar* _tmp846_;
					_tmp841_ = node;
					_tmp842_ = _tmp841_->symbol;
					_tmp843_ = vala_symbol_get_version (_tmp842_);
					_tmp844_ = _tmp843_;
					_tmp845_ = node;
					_tmp846_ = _tmp845_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp844_, _tmp846_);
				}
				_tmp847_ = node;
				_tmp848_ = _tmp847_->deprecated_replacement;
				if (_tmp848_ != NULL) {
					ValaGirParserNode* _tmp849_;
					ValaSymbol* _tmp850_;
					ValaVersionAttribute* _tmp851_;
					ValaVersionAttribute* _tmp852_;
					ValaGirParserNode* _tmp853_;
					const gchar* _tmp854_;
					_tmp849_ = node;
					_tmp850_ = _tmp849_->symbol;
					_tmp851_ = vala_symbol_get_version (_tmp850_);
					_tmp852_ = _tmp851_;
					_tmp853_ = node;
					_tmp854_ = _tmp853_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp852_, _tmp854_);
				}
				_tmp857_ = node;
				_tmp858_ = _tmp857_->new_symbol;
				if (_tmp858_) {
					ValaGirParserNode* _tmp859_;
					gboolean _tmp860_;
					_tmp859_ = node;
					_tmp860_ = _tmp859_->merged;
					_tmp856_ = !_tmp860_;
				} else {
					_tmp856_ = FALSE;
				}
				if (_tmp856_) {
					ValaGirParserMetadata* _tmp861_;
					_tmp861_ = self->metadata;
					_tmp855_ = !vala_gir_parser_metadata_get_bool (_tmp861_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp855_ = FALSE;
				}
				if (_tmp855_) {
					ValaSymbol* _tmp862_;
					ValaGirParserNode* _tmp863_;
					ValaSymbol* _tmp864_;
					_tmp862_ = self->symbol;
					_tmp863_ = node;
					_tmp864_ = _tmp863_->symbol;
					vala_gir_parser_add_symbol_to_container (_tmp862_, _tmp864_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp865_ = self->symbol;
		_tmp866_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp865_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp865_) : NULL);
		cl = _tmp866_;
		_tmp869_ = cl;
		if (_tmp869_ != NULL) {
			ValaClass* _tmp870_;
			gboolean _tmp871_;
			gboolean _tmp872_;
			_tmp870_ = cl;
			_tmp871_ = vala_class_get_is_compact (_tmp870_);
			_tmp872_ = _tmp871_;
			_tmp868_ = !_tmp872_;
		} else {
			_tmp868_ = FALSE;
		}
		if (_tmp868_) {
			ValaClass* _tmp873_;
			ValaCreationMethod* _tmp874_;
			ValaCreationMethod* _tmp875_;
			_tmp873_ = cl;
			_tmp874_ = vala_class_get_default_construction_method (_tmp873_);
			_tmp875_ = _tmp874_;
			_tmp867_ = _tmp875_ == NULL;
		} else {
			_tmp867_ = FALSE;
		}
		if (_tmp867_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp876_;
			ValaSourceReference* _tmp877_;
			ValaSourceReference* _tmp878_;
			ValaCreationMethod* _tmp879_;
			ValaCreationMethod* _tmp880_;
			ValaCreationMethod* _tmp881_;
			ValaClass* _tmp882_;
			ValaCreationMethod* _tmp883_;
			_tmp876_ = cl;
			_tmp877_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp876_);
			_tmp878_ = _tmp877_;
			_tmp879_ = vala_creation_method_new (NULL, NULL, _tmp878_, NULL);
			cm = _tmp879_;
			_tmp880_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp880_, FALSE);
			_tmp881_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp881_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp882_ = cl;
			_tmp883_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp882_, (ValaMethod*) _tmp883_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}


static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}


static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_node_copy_value (const GValue* src_value, 
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_node_collect_value (GValue* value, 
                                          guint n_collect_values, 
                                          GTypeCValue* collect_values, 
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value, 
                                        guint n_collect_values, 
                                        GTypeCValue* collect_values, 
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name, 
                                 const gchar* nick, 
                                 const gchar* blurb, 
                                 GType object_type, 
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_node (GValue* value, 
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}


static void
vala_gir_parser_value_take_node (GValue* value, 
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}


static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}


static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}


static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}


static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_node_type_id__volatile, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__volatile;
}


static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type, 
                                          ValaParameter* param, 
                                          gint array_length_idx, 
                                          gint closure_idx, 
                                          gint destroy_idx, 
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}


static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param, 
                                    gint array_length_idx, 
                                    gint closure_idx, 
                                    gint destroy_idx, 
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}


static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value, 
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value, 
                                                    guint n_collect_values, 
                                                    GTypeCValue* collect_values, 
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value, 
                                                  guint n_collect_values, 
                                                  GTypeCValue* collect_values, 
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name, 
                                           const gchar* nick, 
                                           const gchar* blurb, 
                                           GType object_type, 
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_parameter_info (GValue* value, 
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}


static void
vala_gir_parser_value_take_parameter_info (GValue* value, 
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}


static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}


static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self)
{
	self->ref_count = 1;
}


static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}


static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__volatile, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__volatile;
}


static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
vala_gir_parser_class_init (ValaGirParserClass * klass)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGirParserPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}


static void
vala_gir_parser_instance_init (ValaGirParser * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	self->priv = VALA_GIR_PARSER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	self->priv->unresolved_type_arguments = _tmp10_;
}


static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->glib_ns);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_iterable_unref0 (self->priv->unresolved_type_arguments);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_parser_type_id__volatile, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



