/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
enum  {
	VALA_VAPI_GEN_0_PROPERTY,
	VALA_VAPI_GEN_NUM_PROPERTIES
};
static GParamSpec* vala_vapi_gen_properties[VALA_VAPI_GEN_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name, 
                                      const gchar* nick, 
                                      const gchar* blurb, 
                                      GType object_type, 
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value, 
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value, 
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
static gchar** _vala_array_dup1 (gchar** self, 
                          int length);
static gchar** _vala_array_dup2 (gchar** self, 
                          int length);
static gchar** _vala_array_dup3 (gchar** self, 
                          int length);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self, 
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack, 
                                      int stack_length, 
                                      gchar* needle);
static gint vala_vapi_gen_main (gchar** args, 
                         int args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		gboolean _tmp3_;
		_tmp3_ = vala_vapi_gen_quiet_mode;
		if (!_tmp3_) {
			FILE* _tmp4_;
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			_tmp4_ = stdout;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			fprintf (_tmp4_, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp7_));
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp8_;
		_tmp8_ = vala_vapi_gen_quiet_mode;
		if (!_tmp8_) {
			FILE* _tmp9_;
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp9_ = stdout;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			fprintf (_tmp9_, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp12_), vala_report_get_warnings (_tmp15_));
		}
		result = 1;
		return result;
	}
}


static gchar**
_vala_array_dup1 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup2 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar**
_vala_array_dup3 (gchar** self, 
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack, 
                             int stack_length, 
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValaCodeContext* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValaCodeContext* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	gboolean _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaReport* _tmp16_;
	ValaReport* _tmp17_;
	gboolean _tmp18_;
	ValaCodeContext* _tmp19_;
	ValaCodeContext* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ValaCodeContext* _tmp25_;
	ValaReport* _tmp26_;
	ValaReport* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValaCodeContext* _tmp43_;
	ValaReport* _tmp44_;
	ValaReport* _tmp45_;
	const gchar* _tmp46_;
	ValaCodeContext* _tmp51_;
	ValaReport* _tmp52_;
	ValaReport* _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	ValaCodeContext* _tmp59_;
	ValaReport* _tmp60_;
	ValaReport* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	ValaCodeContext* _tmp74_;
	ValaReport* _tmp75_;
	ValaReport* _tmp76_;
	ValaParser* parser = NULL;
	ValaParser* _tmp77_;
	ValaParser* _tmp78_;
	ValaCodeContext* _tmp79_;
	ValaCodeContext* _tmp80_;
	ValaReport* _tmp81_;
	ValaReport* _tmp82_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp83_;
	ValaGirParser* _tmp84_;
	ValaCodeContext* _tmp85_;
	ValaCodeContext* _tmp86_;
	ValaReport* _tmp87_;
	ValaReport* _tmp88_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp89_;
	ValaGIdlParser* _tmp90_;
	ValaCodeContext* _tmp91_;
	ValaCodeContext* _tmp92_;
	ValaReport* _tmp93_;
	ValaReport* _tmp94_;
	ValaCodeContext* _tmp95_;
	ValaCodeContext* _tmp96_;
	ValaReport* _tmp97_;
	ValaReport* _tmp98_;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp143_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp144_;
	gchar* _tmp145_;
	const gchar* _tmp146_;
	ValaCodeWriter* _tmp150_;
	ValaCodeContext* _tmp151_;
	const gchar* _tmp152_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = vala_vapi_gen_vapi_directories;
	_tmp3__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp2_->vapi_directories = (_vala_array_free (_tmp2_->vapi_directories, _tmp2_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp2_->vapi_directories = _tmp4_;
	_tmp2_->vapi_directories_length1 = _tmp4__length1;
	_tmp5_ = self->priv->context;
	_tmp6_ = vala_vapi_gen_gir_directories;
	_tmp6__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup2 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	_tmp5_->gir_directories = (_vala_array_free (_tmp5_->gir_directories, _tmp5_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp5_->gir_directories = _tmp7_;
	_tmp5_->gir_directories_length1 = _tmp7__length1;
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_vapi_gen_metadata_directories;
	_tmp9__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup3 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp8_->metadata_directories = (_vala_array_free (_tmp8_->metadata_directories, _tmp8_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp8_->metadata_directories = _tmp10_;
	_tmp8_->metadata_directories_length1 = _tmp10__length1;
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_vapi_gen_disable_warnings;
	vala_report_set_enable_warnings (_tmp13_, !_tmp14_);
	_tmp15_ = self->priv->context;
	_tmp16_ = vala_code_context_get_report (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_vapi_gen_quiet_mode;
	vala_report_set_verbose_errors (_tmp17_, !_tmp18_);
	_tmp19_ = self->priv->context;
	vala_code_context_push (_tmp19_);
	_tmp20_ = self->priv->context;
	_tmp21_ = vala_vapi_gen_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp20_, _tmp21_);
	_tmp22_ = vala_vapi_gen_nostdpkg;
	if (!_tmp22_) {
		ValaCodeContext* _tmp23_;
		ValaCodeContext* _tmp24_;
		_tmp23_ = self->priv->context;
		vala_code_context_add_external_package (_tmp23_, "glib-2.0");
		_tmp24_ = self->priv->context;
		vala_code_context_add_external_package (_tmp24_, "gobject-2.0");
	}
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_code_context_get_report (_tmp25_);
	_tmp27_ = _tmp26_;
	if (vala_report_get_errors (_tmp27_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp28_ = vala_vapi_gen_sources;
	_tmp28__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp28_;
		source_collection_length1 = _tmp28__length1;
		for (source_it = 0; source_it < _tmp28__length1; source_it = source_it + 1) {
			gchar* _tmp29_;
			gchar* source = NULL;
			_tmp29_ = g_strdup (source_collection[source_it]);
			source = _tmp29_;
			{
				const gchar* _tmp30_;
				gchar* depsfile = NULL;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaCodeContext* _tmp41_;
				const gchar* _tmp42_;
				_tmp30_ = source;
				if (!g_str_has_suffix (_tmp30_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp31_ = source;
				_tmp32_ = source;
				_tmp33_ = strlen (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = strlen ("gi");
				_tmp36_ = _tmp35_;
				_tmp37_ = string_substring (_tmp31_, (glong) 0, (glong) (_tmp34_ - _tmp36_));
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strconcat (_tmp38_, "deps", NULL);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				depsfile = _tmp40_;
				_tmp41_ = self->priv->context;
				_tmp42_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp41_, _tmp42_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_code_context_get_report (_tmp43_);
	_tmp45_ = _tmp44_;
	if (vala_report_get_errors (_tmp45_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp46_ = vala_vapi_gen_library;
	if (_tmp46_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		ValaCodeContext* _tmp49_;
		const gchar* _tmp50_;
		_tmp47_ = vala_vapi_gen_library;
		_tmp48_ = g_strconcat (_tmp47_, ".deps", NULL);
		depsfile = _tmp48_;
		_tmp49_ = self->priv->context;
		_tmp50_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp49_, _tmp50_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp51_ = self->priv->context;
	_tmp52_ = vala_code_context_get_report (_tmp51_);
	_tmp53_ = _tmp52_;
	if (vala_report_get_errors (_tmp53_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp54_ = vala_vapi_gen_packages;
	_tmp54__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp54_ != NULL) {
		gchar** _tmp55_;
		gint _tmp55__length1;
		_tmp55_ = vala_vapi_gen_packages;
		_tmp55__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp55_;
			package_collection_length1 = _tmp55__length1;
			for (package_it = 0; package_it < _tmp55__length1; package_it = package_it + 1) {
				gchar* _tmp56_;
				gchar* package = NULL;
				_tmp56_ = g_strdup (package_collection[package_it]);
				package = _tmp56_;
				{
					ValaCodeContext* _tmp57_;
					const gchar* _tmp58_;
					_tmp57_ = self->priv->context;
					_tmp58_ = package;
					vala_code_context_add_external_package (_tmp57_, _tmp58_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_code_context_get_report (_tmp59_);
	_tmp61_ = _tmp60_;
	if (vala_report_get_errors (_tmp61_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp62_ = vala_vapi_gen_sources;
	_tmp62__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp62_;
		source_collection_length1 = _tmp62__length1;
		for (source_it = 0; source_it < _tmp62__length1; source_it = source_it + 1) {
			gchar* _tmp63_;
			gchar* source = NULL;
			_tmp63_ = g_strdup (source_collection[source_it]);
			source = _tmp63_;
			{
				const gchar* _tmp64_;
				_tmp64_ = source;
				if (g_file_test (_tmp64_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp65_;
					const gchar* _tmp66_;
					ValaSourceFile* _tmp67_;
					ValaSourceFile* _tmp68_;
					ValaCodeContext* _tmp69_;
					ValaSourceFile* _tmp70_;
					_tmp65_ = self->priv->context;
					_tmp66_ = source;
					_tmp67_ = vala_source_file_new (_tmp65_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp66_, NULL, FALSE);
					source_file = _tmp67_;
					_tmp68_ = source_file;
					vala_source_file_set_explicit (_tmp68_, TRUE);
					_tmp69_ = self->priv->context;
					_tmp70_ = source_file;
					vala_code_context_add_source_file (_tmp69_, _tmp70_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					_tmp71_ = source;
					_tmp72_ = g_strdup_printf ("%s not found", _tmp71_);
					_tmp73_ = _tmp72_;
					vala_report_error (NULL, _tmp73_);
					_g_free0 (_tmp73_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_code_context_get_report (_tmp74_);
	_tmp76_ = _tmp75_;
	if (vala_report_get_errors (_tmp76_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp77_ = vala_parser_new ();
	parser = _tmp77_;
	_tmp78_ = parser;
	_tmp79_ = self->priv->context;
	vala_parser_parse (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_code_context_get_report (_tmp80_);
	_tmp82_ = _tmp81_;
	if (vala_report_get_errors (_tmp82_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp83_ = vala_gir_parser_new ();
	girparser = _tmp83_;
	_tmp84_ = girparser;
	_tmp85_ = self->priv->context;
	vala_gir_parser_parse (_tmp84_, _tmp85_);
	_tmp86_ = self->priv->context;
	_tmp87_ = vala_code_context_get_report (_tmp86_);
	_tmp88_ = _tmp87_;
	if (vala_report_get_errors (_tmp88_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp89_ = vala_gidl_parser_new ();
	gidlparser = _tmp89_;
	_tmp90_ = gidlparser;
	_tmp91_ = self->priv->context;
	vala_gidl_parser_parse (_tmp90_, _tmp91_);
	_tmp92_ = self->priv->context;
	_tmp93_ = vala_code_context_get_report (_tmp92_);
	_tmp94_ = _tmp93_;
	if (vala_report_get_errors (_tmp94_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp95_ = self->priv->context;
	vala_code_context_check (_tmp95_);
	_tmp96_ = self->priv->context;
	_tmp97_ = vala_code_context_get_report (_tmp96_);
	_tmp98_ = _tmp97_;
	if (vala_report_get_errors (_tmp98_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp99_;
		ValaList* _tmp100_;
		gint _file_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _file_index = 0;
		_tmp99_ = self->priv->context;
		_tmp100_ = vala_code_context_get_source_files (_tmp99_);
		_file_list = _tmp100_;
		_tmp101_ = _file_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_file_size = _tmp103_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaSourceFile* _tmp110_;
			const gchar* _tmp111_;
			const gchar* _tmp112_;
			ValaSourceFile* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			gchar** _tmp116_;
			gint _tmp116__length1;
			_tmp104_ = _file_index;
			_file_index = _tmp104_ + 1;
			_tmp105_ = _file_index;
			_tmp106_ = _file_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _file_list;
			_tmp108_ = _file_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			file = (ValaSourceFile*) _tmp109_;
			_tmp110_ = file;
			_tmp111_ = vala_source_file_get_filename (_tmp110_);
			_tmp112_ = _tmp111_;
			if (g_str_has_suffix (_tmp112_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp113_ = file;
			_tmp114_ = vala_source_file_get_filename (_tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_vapi_gen_sources;
			_tmp116__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp116_, _tmp116__length1, _tmp115_)) {
				ValaSourceFile* _tmp117_;
				ValaSourceFile* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				_tmp117_ = file;
				vala_source_file_set_file_type (_tmp117_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp118_ = file;
				_tmp119_ = vala_source_file_get_filename (_tmp118_);
				_tmp120_ = _tmp119_;
				if (g_str_has_suffix (_tmp120_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp121_;
					ValaSourceFile* _tmp122_;
					const gchar* _tmp123_;
					const gchar* _tmp124_;
					gchar* _tmp125_;
					const gchar* _tmp126_;
					_tmp121_ = self->priv->context;
					_tmp122_ = file;
					_tmp123_ = vala_source_file_get_filename (_tmp122_);
					_tmp124_ = _tmp123_;
					_tmp125_ = vala_code_context_get_metadata_path (_tmp121_, _tmp124_);
					metadata_filename = _tmp125_;
					_tmp126_ = metadata_filename;
					if (_tmp126_ != NULL) {
						{
							ValaList* _metadata_file_list = NULL;
							ValaCodeContext* _tmp127_;
							ValaList* _tmp128_;
							gint _metadata_file_size = 0;
							ValaList* _tmp129_;
							gint _tmp130_;
							gint _tmp131_;
							gint _metadata_file_index = 0;
							_tmp127_ = self->priv->context;
							_tmp128_ = vala_code_context_get_source_files (_tmp127_);
							_metadata_file_list = _tmp128_;
							_tmp129_ = _metadata_file_list;
							_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
							_tmp131_ = _tmp130_;
							_metadata_file_size = _tmp131_;
							_metadata_file_index = -1;
							while (TRUE) {
								gint _tmp132_;
								gint _tmp133_;
								gint _tmp134_;
								ValaSourceFile* metadata_file = NULL;
								ValaList* _tmp135_;
								gint _tmp136_;
								gpointer _tmp137_;
								ValaSourceFile* _tmp138_;
								const gchar* _tmp139_;
								const gchar* _tmp140_;
								const gchar* _tmp141_;
								_tmp132_ = _metadata_file_index;
								_metadata_file_index = _tmp132_ + 1;
								_tmp133_ = _metadata_file_index;
								_tmp134_ = _metadata_file_size;
								if (!(_tmp133_ < _tmp134_)) {
									break;
								}
								_tmp135_ = _metadata_file_list;
								_tmp136_ = _metadata_file_index;
								_tmp137_ = vala_list_get (_tmp135_, _tmp136_);
								metadata_file = (ValaSourceFile*) _tmp137_;
								_tmp138_ = metadata_file;
								_tmp139_ = vala_source_file_get_filename (_tmp138_);
								_tmp140_ = _tmp139_;
								_tmp141_ = metadata_filename;
								if (g_strcmp0 (_tmp140_, _tmp141_) == 0) {
									ValaSourceFile* _tmp142_;
									_tmp142_ = metadata_file;
									vala_source_file_set_file_type (_tmp142_, VALA_SOURCE_FILE_TYPE_SOURCE);
								}
								_vala_source_file_unref0 (metadata_file);
							}
							_vala_iterable_unref0 (_metadata_file_list);
						}
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp143_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
	interface_writer = _tmp143_;
	_tmp144_ = vala_vapi_gen_library;
	_tmp145_ = g_strdup_printf ("%s.vapi", _tmp144_);
	vapi_filename = _tmp145_;
	_tmp146_ = vala_vapi_gen_directory;
	if (_tmp146_ != NULL) {
		const gchar* _tmp147_;
		const gchar* _tmp148_;
		gchar* _tmp149_;
		_tmp147_ = vala_vapi_gen_directory;
		_tmp148_ = vapi_filename;
		_tmp149_ = g_build_path ("/", _tmp147_, _tmp148_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp149_;
	}
	_tmp150_ = interface_writer;
	_tmp151_ = self->priv->context;
	_tmp152_ = vapi_filename;
	vala_code_writer_write_file (_tmp150_, _tmp151_, _tmp152_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint
vala_vapi_gen_main (gchar** args, 
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp15_;
	ValaVAPIGen* _tmp16_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = vala_vapi_gen_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp13_ = vala_vapi_gen_sources;
	_tmp13__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = vala_vapi_gen_new ();
	vapigen = _tmp15_;
	_tmp16_ = vapigen;
	result = vala_vapi_gen_run (_tmp16_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}


int
main (int argc, 
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_vapi_gen_copy_value (const GValue* src_value, 
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_vapi_gen_collect_value (GValue* value, 
                                   guint n_collect_values, 
                                   GTypeCValue* collect_values, 
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value, 
                                 guint n_collect_values, 
                                 GTypeCValue* collect_values, 
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name, 
                          const gchar* nick, 
                          const gchar* blurb, 
                          GType object_type, 
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value, 
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value, 
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
}


static void
vala_vapi_gen_instance_init (ValaVAPIGen * self)
{
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



