/* valaccodedynamicpropertybinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDYNAMICPROPERTYBINDING_H__
#define __GOBJECT_VALACCODEDYNAMICPROPERTYBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadynamicproperty.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaproperty.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING (vala_ccode_dynamic_property_binding_get_type ())
#define VALA_CCODE_DYNAMIC_PROPERTY_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, ValaCCodeDynamicPropertyBinding))
#define VALA_CCODE_DYNAMIC_PROPERTY_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, ValaCCodeDynamicPropertyBindingClass))
#define VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING))
#define VALA_IS_CCODE_DYNAMIC_PROPERTY_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING))
#define VALA_CCODE_DYNAMIC_PROPERTY_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DYNAMIC_PROPERTY_BINDING, ValaCCodeDynamicPropertyBindingClass))

typedef struct _ValaCCodeDynamicPropertyBindingPrivate ValaCCodeDynamicPropertyBindingPrivate;

/**
 * The link between a dynamic property and generated code.
 */
struct _ValaCCodeDynamicPropertyBinding {
	ValaCCodeBinding parent_instance;
	ValaCCodeDynamicPropertyBindingPrivate * priv;
};

struct _ValaCCodeDynamicPropertyBindingClass {
	ValaCCodeBindingClass parent_class;
};


ValaCCodeDynamicPropertyBinding* vala_ccode_dynamic_property_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaDynamicProperty* property);
ValaCCodeDynamicPropertyBinding* vala_ccode_dynamic_property_binding_new (ValaCCodeGenerator* codegen, ValaDynamicProperty* property);
char* vala_ccode_dynamic_property_binding_get_getter_cname (ValaCCodeDynamicPropertyBinding* self);
char* vala_ccode_dynamic_property_binding_get_setter_cname (ValaCCodeDynamicPropertyBinding* self);
ValaProperty* vala_ccode_dynamic_property_binding_get_node (ValaCCodeDynamicPropertyBinding* self);
void vala_ccode_dynamic_property_binding_set_node (ValaCCodeDynamicPropertyBinding* self, ValaProperty* value);
GType vala_ccode_dynamic_property_binding_get_type (void);


G_END_DECLS

#endif
