/* valaaddressofexpression.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaaddressofexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaAddressofExpressionPrivate {
	ValaExpression* _inner;
};

#define VALA_ADDRESSOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionPrivate))
enum  {
	VALA_ADDRESSOF_EXPRESSION_DUMMY_PROPERTY
};
static void vala_addressof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_addressof_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_addressof_expression_real_is_pure (ValaExpression* base);
static gpointer vala_addressof_expression_parent_class = NULL;
static void vala_addressof_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new address-of expression.
 *
 * @param inner variable whose address is to be computed
 * @return      newly created address-of expression
 */
ValaAddressofExpression* vala_addressof_expression_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference) {
	ValaAddressofExpression* self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaAddressofExpression*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_addressof_expression_set_inner (self, inner);
	return self;
}


ValaAddressofExpression* vala_addressof_expression_new (ValaExpression* inner, ValaSourceReference* source_reference) {
	return vala_addressof_expression_construct (VALA_TYPE_ADDRESSOF_EXPRESSION, inner, source_reference);
}


static void vala_addressof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAddressofExpression * self;
	self = VALA_ADDRESSOF_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_addressof_expression_get_inner (self)), visitor);
	vala_code_visitor_visit_addressof_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, VALA_EXPRESSION (self));
}


static void vala_addressof_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaAddressofExpression * self;
	self = VALA_ADDRESSOF_EXPRESSION (base);
	g_return_if_fail (VALA_IS_EXPRESSION (old_node));
	g_return_if_fail (VALA_IS_EXPRESSION (new_node));
	if (vala_addressof_expression_get_inner (self) == old_node) {
		vala_addressof_expression_set_inner (self, new_node);
	}
}


static gboolean vala_addressof_expression_real_is_pure (ValaExpression* base) {
	ValaAddressofExpression * self;
	self = VALA_ADDRESSOF_EXPRESSION (base);
	return vala_expression_is_pure (vala_addressof_expression_get_inner (self));
}


ValaExpression* vala_addressof_expression_get_inner (ValaAddressofExpression* self) {
	g_return_val_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_addressof_expression_set_inner (ValaAddressofExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self));
}


static void vala_addressof_expression_class_init (ValaAddressofExpressionClass * klass) {
	vala_addressof_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_addressof_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaAddressofExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_addressof_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_addressof_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_addressof_expression_real_is_pure;
}


static void vala_addressof_expression_instance_init (ValaAddressofExpression * self) {
	self->priv = VALA_ADDRESSOF_EXPRESSION_GET_PRIVATE (self);
}


static void vala_addressof_expression_finalize (ValaCodeNode* obj) {
	ValaAddressofExpression * self;
	self = VALA_ADDRESSOF_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)));
	VALA_CODE_NODE_CLASS (vala_addressof_expression_parent_class)->finalize (obj);
}


GType vala_addressof_expression_get_type (void) {
	static GType vala_addressof_expression_type_id = 0;
	if (vala_addressof_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAddressofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_addressof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAddressofExpression), 0, (GInstanceInitFunc) vala_addressof_expression_instance_init, NULL };
		vala_addressof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAddressofExpression", &g_define_type_info, 0);
	}
	return vala_addressof_expression_type_id;
}




