/* valaunresolvedsymbol.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaunresolvedsymbol.h>
#include <vala/valacodenode.h>




struct _ValaUnresolvedSymbolPrivate {
	ValaUnresolvedSymbol* _inner;
	gboolean _qualified;
};

#define VALA_UNRESOLVED_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolPrivate))
enum  {
	VALA_UNRESOLVED_SYMBOL_DUMMY_PROPERTY
};
static char* vala_unresolved_symbol_real_to_string (ValaCodeNode* base);
static gpointer vala_unresolved_symbol_parent_class = NULL;
static void vala_unresolved_symbol_finalize (ValaCodeNode* obj);



ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol* self;
	g_return_val_if_fail (inner == NULL || VALA_IS_UNRESOLVED_SYMBOL (inner), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaUnresolvedSymbol*) (g_type_create_instance (object_type)));
	vala_unresolved_symbol_set_inner (self, inner);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference) {
	return vala_unresolved_symbol_construct (VALA_TYPE_UNRESOLVED_SYMBOL, inner, name, source_reference);
}


static char* vala_unresolved_symbol_real_to_string (ValaCodeNode* base) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (base);
	if (self->priv->_inner == NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = vala_symbol_get_name (VALA_SYMBOL (self)), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		char* _tmp2;
		char* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = g_strdup_printf ("%s.%s", (_tmp2 = vala_code_node_to_string (VALA_CODE_NODE (self->priv->_inner))), vala_symbol_get_name (VALA_SYMBOL (self))), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
	}
}


ValaUnresolvedSymbol* vala_unresolved_symbol_copy (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), NULL);
	return vala_unresolved_symbol_new (self->priv->_inner, vala_symbol_get_name (VALA_SYMBOL (self)), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
}


ValaUnresolvedSymbol* vala_unresolved_symbol_get_inner (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), NULL);
	return self->priv->_inner;
}


void vala_unresolved_symbol_set_inner (ValaUnresolvedSymbol* self, ValaUnresolvedSymbol* value) {
	ValaUnresolvedSymbol* _tmp2;
	ValaUnresolvedSymbol* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL))), _tmp2);
}


gboolean vala_unresolved_symbol_get_qualified (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), FALSE);
	return self->priv->_qualified;
}


void vala_unresolved_symbol_set_qualified (ValaUnresolvedSymbol* self, gboolean value) {
	g_return_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self));
	self->priv->_qualified = value;
}


static void vala_unresolved_symbol_class_init (ValaUnresolvedSymbolClass * klass) {
	vala_unresolved_symbol_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_unresolved_symbol_finalize;
	g_type_class_add_private (klass, sizeof (ValaUnresolvedSymbolPrivate));
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_unresolved_symbol_real_to_string;
}


static void vala_unresolved_symbol_instance_init (ValaUnresolvedSymbol * self) {
	self->priv = VALA_UNRESOLVED_SYMBOL_GET_PRIVATE (self);
}


static void vala_unresolved_symbol_finalize (ValaCodeNode* obj) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)));
	VALA_CODE_NODE_CLASS (vala_unresolved_symbol_parent_class)->finalize (obj);
}


GType vala_unresolved_symbol_get_type (void) {
	static GType vala_unresolved_symbol_type_id = 0;
	if (vala_unresolved_symbol_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnresolvedSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unresolved_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnresolvedSymbol), 0, (GInstanceInitFunc) vala_unresolved_symbol_instance_init, NULL };
		vala_unresolved_symbol_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaUnresolvedSymbol", &g_define_type_info, 0);
	}
	return vala_unresolved_symbol_type_id;
}




