/* gstreamer-audio-0.10.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cprefix = "GST_AUDIO_CHANNEL_POSITION_", has_type_id = "0", cheader_filename = "gst/audio/multichannel.h")]
	public enum AudioChannelPosition {
		INVALID,
		FRONT_MONO,
		FRONT_LEFT,
		FRONT_RIGHT,
		REAR_CENTER,
		REAR_LEFT,
		REAR_RIGHT,
		LFE,
		FRONT_CENTER,
		FRONT_LEFT_OF_CENTER,
		FRONT_RIGHT_OF_CENTER,
		SIDE_LEFT,
		SIDE_RIGHT,
		NONE,
		NUM
	}
	[CCode (cprefix = "GST_AUDIO_FIELD_", has_type_id = "0", cheader_filename = "gst/audio/audio.h")]
	public enum AudioFieldFlag {
		RATE,
		CHANNELS,
		ENDIANNESS,
		WIDTH,
		DEPTH,
		SIGNED
	}
	[CCode (cprefix = "GST_BASE_AUDIO_SINK_SLAVE_", has_type_id = "0", cheader_filename = "gst/audio/gstbaseaudiosink.h")]
	public enum BaseAudioSinkSlaveMethod {
		RESAMPLE,
		SKEW,
		NONE
	}
	[CCode (cprefix = "GST_", has_type_id = "0", cheader_filename = "gst/audio/gstringbuffer.h")]
	public enum BufferFormat {
		UNKNOWN,
		S8,
		U8,
		S16_LE,
		S16_BE,
		U16_LE,
		U16_BE,
		S24_LE,
		S24_BE,
		U24_LE,
		U24_BE,
		S32_LE,
		S32_BE,
		U32_LE,
		U32_BE,
		S24_3LE,
		S24_3BE,
		U24_3LE,
		U24_3BE,
		S20_3LE,
		S20_3BE,
		U20_3LE,
		U20_3BE,
		S18_3LE,
		S18_3BE,
		U18_3LE,
		U18_3BE,
		FLOAT32_LE,
		FLOAT32_BE,
		FLOAT64_LE,
		FLOAT64_BE,
		MU_LAW,
		A_LAW,
		IMA_ADPCM,
		MPEG,
		GSM
	}
	[CCode (cprefix = "GST_BUFTYPE_", has_type_id = "0", cheader_filename = "gst/audio/gstringbuffer.h")]
	public enum BufferFormatType {
		LINEAR,
		FLOAT,
		MU_LAW,
		A_LAW,
		IMA_ADPCM,
		MPEG,
		GSM
	}
	[CCode (cprefix = "GST_SEGSTATE_", has_type_id = "0", cheader_filename = "gst/audio/gstringbuffer.h")]
	public enum RingBufferSegState {
		INVALID,
		EMPTY,
		FILLED,
		PARTIAL
	}
	[CCode (cprefix = "GST_RING_BUFFER_STATE_", has_type_id = "0", cheader_filename = "gst/audio/gstringbuffer.h")]
	public enum RingBufferState {
		STOPPED,
		PAUSED,
		STARTED
	}
	[Compact]
	[CCode (cheader_filename = "gst/audio/gstaudiofilter.h")]
	public class RingBufferSpec {
		public weak Gst.Caps caps;
		public Gst.BufferFormatType type;
		public Gst.BufferFormat format;
		public bool sign;
		public bool bigend;
		public int width;
		public int depth;
		public int rate;
		public int channels;
		public uint64 latency_time;
		public uint64 buffer_time;
		public int segsize;
		public int segtotal;
		public int bytes_per_sample;
		[NoArrayLength]
		public weak uchar[] silence_sample;
	}
	[CCode (cheader_filename = "gst/audio/gstaudioclock.h")]
	public class AudioClock : Gst.SystemClock {
		public weak Gst.AudioClockGetTimeFunc func;
		public void* user_data;
		public Gst.ClockTime last_time;
		[CCode (type = "GstClock*", has_construct_function = false)]
		public AudioClock (string name, Gst.AudioClockGetTimeFunc func);
	}
	[CCode (cheader_filename = "gst/audio/gstaudiofilter.h")]
	public class AudioFilter : Gst.BaseTransform {
		public weak Gst.RingBufferSpec format;
		[CCode (cname = "gst_audio_filter_class_add_pad_templates")]
		public class void add_pad_templates (Gst.Caps allowed_caps);
		[NoWrapper]
		public virtual bool setup (Gst.RingBufferSpec format);
	}
	[CCode (cheader_filename = "gst/audio/gstaudiosink.h")]
	public class AudioSink : Gst.BaseAudioSink {
		public weak GLib.Thread thread;
		[NoWrapper]
		public virtual bool close ();
		[NoWrapper]
		public virtual uint delay ();
		[NoWrapper]
		public virtual bool open ();
		[NoWrapper]
		public virtual bool prepare (Gst.RingBufferSpec spec);
		[NoWrapper]
		public virtual void reset ();
		[NoWrapper]
		public virtual bool unprepare ();
		[NoWrapper]
		public virtual uint write (void* data, uint length);
	}
	[CCode (cheader_filename = "gst/audio/gstaudiosrc.h")]
	public class AudioSrc : Gst.BaseAudioSrc {
		public weak GLib.Thread thread;
		[NoWrapper]
		public virtual bool close ();
		[NoWrapper]
		public virtual uint delay ();
		[NoWrapper]
		public virtual bool open ();
		[NoWrapper]
		public virtual bool prepare (Gst.RingBufferSpec spec);
		[NoWrapper]
		public virtual uint read (void* data, uint length);
		[NoWrapper]
		public virtual void reset ();
		[NoWrapper]
		public virtual bool unprepare ();
	}
	[CCode (cheader_filename = "gst/audio/gstaudiosink.h")]
	public class BaseAudioSink : Gst.BaseSink {
		public weak Gst.RingBuffer ringbuffer;
		public uint64 next_sample;
		public weak Gst.Clock provided_clock;
		public bool get_provide_clock ();
		public Gst.BaseAudioSinkSlaveMethod get_slave_method ();
		public void set_provide_clock (bool provide);
		public void set_slave_method (Gst.BaseAudioSinkSlaveMethod method);
		public virtual weak Gst.RingBuffer create_ringbuffer ();
		[NoAccessorMethod]
		public int64 buffer_time { get; set; }
		[NoAccessorMethod]
		public int64 latency_time { get; set; }
		public bool provide_clock { get; set; }
		public Gst.BaseAudioSinkSlaveMethod slave_method { get; set; }
	}
	[CCode (cheader_filename = "gst/audio/gstaudiosrc.h")]
	public class BaseAudioSrc : Gst.PushSrc {
		public weak Gst.RingBuffer ringbuffer;
		public uint64 next_sample;
		public weak Gst.Clock clock;
		public bool get_provide_clock ();
		public void set_provide_clock (bool provide);
		public virtual weak Gst.RingBuffer create_ringbuffer ();
		[NoAccessorMethod]
		public int64 buffer_time { get; set; }
		[NoAccessorMethod]
		public int64 latency_time { get; set; }
		public bool provide_clock { get; set; }
	}
	[CCode (cheader_filename = "gst/audio/gstaudiofilter.h")]
	public class RingBuffer : Gst.Object {
		public weak GLib.Cond cond;
		public bool open;
		public bool acquired;
		public weak Gst.Buffer data;
		public weak Gst.RingBufferSpec spec;
		public Gst.RingBufferSegState segstate;
		public int samples_per_seg;
		public uchar empty_seg;
		public int state;
		public int segdone;
		public int segbase;
		public int waiting;
		public weak Gst.RingBufferCallback callback;
		public void* cb_data;
		public void* abidata;
		public void advance (uint advance);
		public void clear (int segment);
		public void clear_all ();
		public uint commit (uint64 sample, uchar[] data, uint len);
		public uint commit_full (uint64 sample, uchar[] data, int in_samples, int out_samples, int accum);
		public static void debug_spec_buff (Gst.RingBufferSpec spec);
		public static void debug_spec_caps (Gst.RingBufferSpec spec);
		public bool device_is_open ();
		public bool is_acquired ();
		public void may_start (bool allowed);
		public static bool parse_caps (Gst.RingBufferSpec spec, Gst.Caps caps);
		public bool prepare_read (int segment, uchar readptr, int len);
		public uint read (uint64 sample, uchar[] data, uint len);
		public uint64 samples_done ();
		public void set_callback (Gst.RingBufferCallback cb);
		public void set_flushing (bool flushing);
		public void set_sample (uint64 sample);
		public virtual bool acquire (Gst.RingBufferSpec spec);
		public virtual bool close_device ();
		public virtual uint delay ();
		public virtual bool open_device ();
		public virtual bool pause ();
		public virtual bool release ();
		[NoWrapper]
		public virtual bool resume ();
		public virtual bool start ();
		public virtual bool stop ();
	}
	[CCode (cheader_filename = "gst/audio/gstaudioclock.h")]
	public delegate Gst.ClockTime AudioClockGetTimeFunc (Gst.Clock clock);
	[CCode (cheader_filename = "gst/audio/mixerutils.h")]
	public delegate bool AudioMixerFilterFunc (Gst.Mixer mixer);
	[CCode (cheader_filename = "gst/audio/gstringbuffer.h")]
	public delegate void RingBufferCallback (Gst.RingBuffer rbuf, uchar data, uint len);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public const int AUDIO_DEF_RATE;
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public const string AUDIO_FLOAT_PAD_TEMPLATE_CAPS;
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public const string AUDIO_FLOAT_STANDARD_PAD_TEMPLATE_CAPS;
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public const string AUDIO_INT_PAD_TEMPLATE_CAPS;
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public const string AUDIO_INT_STANDARD_PAD_TEMPLATE_CAPS;
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static weak Gst.Buffer audio_buffer_clip (Gst.Buffer buffer, Gst.Segment segment, int rate, int frame_size);
	[CCode (cheader_filename = "gst/audio/mixerutils.h")]
	public static weak GLib.List audio_default_registry_mixer_filter (Gst.AudioMixerFilterFunc filter_func, bool first);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static Gst.ClockTime audio_duration_from_pad_buffer (Gst.Pad pad, Gst.Buffer buf);
	[CCode (cheader_filename = "gst/audio/multichannel.h")]
	public static Gst.AudioChannelPosition audio_fixate_channel_positions (Gst.Structure str);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static int audio_frame_byte_size (Gst.Pad pad);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static long audio_frame_length (Gst.Pad pad, Gst.Buffer buf);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static Gst.AudioChannelPosition audio_get_channel_positions (Gst.Structure str);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static bool audio_is_buffer_framed (Gst.Pad pad, Gst.Buffer buf);
	[CCode (cheader_filename = "gst/audio/multichannel.h")]
	public static void audio_set_caps_channel_positions_list (Gst.Caps caps, Gst.AudioChannelPosition pos, int num_positions);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static void audio_set_channel_positions (Gst.Structure str, Gst.AudioChannelPosition pos);
	[CCode (cheader_filename = "gst/audio/multichannel.h")]
	public static void audio_set_structure_channel_positions_list (Gst.Structure str, Gst.AudioChannelPosition pos, int num_positions);
	[CCode (cheader_filename = "gst/audio/audio.h")]
	public static void audio_structure_set_int (Gst.Structure structure, Gst.AudioFieldFlag flag);
}
