/* readonlyset.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/readonlyset.h>


#define GEE_READ_ONLY_SET_TYPE_ITERATOR (gee_read_only_set_iterator_get_type ())
#define GEE_READ_ONLY_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_SET_TYPE_ITERATOR, GeeReadOnlySetIterator))
#define GEE_READ_ONLY_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_SET_TYPE_ITERATOR, GeeReadOnlySetIteratorClass))
#define GEE_READ_ONLY_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_SET_TYPE_ITERATOR))
#define GEE_READ_ONLY_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_SET_TYPE_ITERATOR))
#define GEE_READ_ONLY_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_SET_TYPE_ITERATOR, GeeReadOnlySetIteratorClass))

typedef struct _GeeReadOnlySetIterator GeeReadOnlySetIterator;
typedef struct _GeeReadOnlySetIteratorClass GeeReadOnlySetIteratorClass;
typedef struct _GeeReadOnlySetIteratorPrivate GeeReadOnlySetIteratorPrivate;

struct _GeeReadOnlySetIterator {
	GeeCollectionObject parent_instance;
	GeeReadOnlySetIteratorPrivate * priv;
};

struct _GeeReadOnlySetIteratorClass {
	GeeCollectionObjectClass parent_class;
};



struct _GeeReadOnlySetPrivate {
	GeeSet* _set;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

#define GEE_READ_ONLY_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySetPrivate))
enum  {
	GEE_READ_ONLY_SET_DUMMY_PROPERTY
};
static GType gee_read_only_set_real_get_element_type (GeeIterable* base);
static GeeIterator* gee_read_only_set_real_iterator (GeeIterable* base);
static gboolean gee_read_only_set_real_contains (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_set_real_add (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_set_real_remove (GeeCollection* base, gconstpointer item);
static void gee_read_only_set_real_clear (GeeCollection* base);
struct _GeeReadOnlySetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

#define GEE_READ_ONLY_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_READ_ONLY_SET_TYPE_ITERATOR, GeeReadOnlySetIteratorPrivate))
enum  {
	GEE_READ_ONLY_SET_ITERATOR_DUMMY_PROPERTY
};
static gboolean gee_read_only_set_iterator_real_next (GeeIterator* base);
static gpointer gee_read_only_set_iterator_real_get (GeeIterator* base);
static GeeReadOnlySetIterator* gee_read_only_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static GeeReadOnlySetIterator* gee_read_only_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static gpointer gee_read_only_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_read_only_set_iterator_gee_iterator_parent_iface = NULL;
static GType gee_read_only_set_iterator_get_type (void);
static gpointer gee_read_only_set_parent_class = NULL;
static GeeIterableIface* gee_read_only_set_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_read_only_set_gee_collection_parent_iface = NULL;
static GeeSetIface* gee_read_only_set_gee_set_parent_iface = NULL;
static void gee_read_only_set_finalize (GeeCollectionObject* obj);



GeeReadOnlySet* gee_read_only_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set) {
	GeeReadOnlySet* self;
	g_return_val_if_fail (set == NULL || GEE_IS_SET (set), NULL);
	self = ((GeeReadOnlySet*) (g_type_create_instance (object_type)));
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	gee_read_only_set_set_set (self, set);
	return self;
}


GeeReadOnlySet* gee_read_only_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set) {
	return gee_read_only_set_construct (GEE_TYPE_READ_ONLY_SET, g_type, g_dup_func, g_destroy_func, set);
}


static GType gee_read_only_set_real_get_element_type (GeeIterable* base) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	return self->priv->g_type;
}


static GeeIterator* gee_read_only_set_real_iterator (GeeIterable* base) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	if (self->priv->_set == NULL) {
		return GEE_ITERATOR (gee_read_only_set_iterator_new (self->priv->g_type, ((GBoxedCopyFunc) (self->priv->g_dup_func)), self->priv->g_destroy_func));
	}
	return gee_iterable_iterator (GEE_ITERABLE (self->priv->_set));
}


static gboolean gee_read_only_set_real_contains (GeeCollection* base, gconstpointer item) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	if (self->priv->_set == NULL) {
		return FALSE;
	}
	return gee_collection_contains (GEE_COLLECTION (self->priv->_set), item);
}


static gboolean gee_read_only_set_real_add (GeeCollection* base, gconstpointer item) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	g_assert_not_reached ();
}


static gboolean gee_read_only_set_real_remove (GeeCollection* base, gconstpointer item) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	g_assert_not_reached ();
}


static void gee_read_only_set_real_clear (GeeCollection* base) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (base);
	g_assert_not_reached ();
}


static gint gee_read_only_set_real_get_size (GeeCollection* base) {
	GeeReadOnlySet* self;
	self = GEE_READ_ONLY_SET (base);
	return gee_collection_get_size (GEE_COLLECTION (self->priv->_set));
}


void gee_read_only_set_set_set (GeeReadOnlySet* self, GeeSet* value) {
	GeeSet* _tmp1;
	GeeSet* _tmp0;
	g_return_if_fail (GEE_IS_READ_ONLY_SET (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_set = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL ? NULL : gee_collection_object_ref (_tmp0))), (self->priv->_set == NULL ? NULL : (self->priv->_set = (gee_collection_object_unref (self->priv->_set), NULL))), _tmp1);
}


static gboolean gee_read_only_set_iterator_real_next (GeeIterator* base) {
	GeeReadOnlySetIterator * self;
	self = GEE_READ_ONLY_SET_ITERATOR (base);
	return FALSE;
}


static gpointer gee_read_only_set_iterator_real_get (GeeIterator* base) {
	GeeReadOnlySetIterator * self;
	self = GEE_READ_ONLY_SET_ITERATOR (base);
	return NULL;
}


static GeeReadOnlySetIterator* gee_read_only_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeReadOnlySetIterator* self;
	self = ((GeeReadOnlySetIterator*) (g_type_create_instance (object_type)));
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static GeeReadOnlySetIterator* gee_read_only_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_read_only_set_iterator_construct (GEE_READ_ONLY_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func);
}


static void gee_read_only_set_iterator_class_init (GeeReadOnlySetIteratorClass * klass) {
	gee_read_only_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlySetIteratorPrivate));
}


static void gee_read_only_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_read_only_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_read_only_set_iterator_real_next;
	iface->get = gee_read_only_set_iterator_real_get;
}


static void gee_read_only_set_iterator_instance_init (GeeReadOnlySetIterator * self) {
	self->priv = GEE_READ_ONLY_SET_ITERATOR_GET_PRIVATE (self);
}


static GType gee_read_only_set_iterator_get_type (void) {
	static GType gee_read_only_set_iterator_type_id = 0;
	if (gee_read_only_set_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlySetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlySetIterator), 0, (GInstanceInitFunc) gee_read_only_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_read_only_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_set_iterator_type_id = g_type_register_static (GEE_TYPE_COLLECTION_OBJECT, "GeeReadOnlySetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_read_only_set_iterator_type_id;
}


static void gee_read_only_set_class_init (GeeReadOnlySetClass * klass) {
	gee_read_only_set_parent_class = g_type_class_peek_parent (klass);
	GEE_COLLECTION_OBJECT_CLASS (klass)->finalize = gee_read_only_set_finalize;
	g_type_class_add_private (klass, sizeof (GeeReadOnlySetPrivate));
}


static void gee_read_only_set_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_read_only_set_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = gee_read_only_set_real_get_element_type;
	iface->iterator = gee_read_only_set_real_iterator;
}


static void gee_read_only_set_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_read_only_set_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = gee_read_only_set_real_contains;
	iface->add = gee_read_only_set_real_add;
	iface->remove = gee_read_only_set_real_remove;
	iface->clear = gee_read_only_set_real_clear;
	iface->get_size = gee_read_only_set_real_get_size;
}


static void gee_read_only_set_gee_set_interface_init (GeeSetIface * iface) {
	gee_read_only_set_gee_set_parent_iface = g_type_interface_peek_parent (iface);
}


static void gee_read_only_set_instance_init (GeeReadOnlySet * self) {
	self->priv = GEE_READ_ONLY_SET_GET_PRIVATE (self);
}


static void gee_read_only_set_finalize (GeeCollectionObject* obj) {
	GeeReadOnlySet * self;
	self = GEE_READ_ONLY_SET (obj);
	(self->priv->_set == NULL ? NULL : (self->priv->_set = (gee_collection_object_unref (self->priv->_set), NULL)));
	GEE_COLLECTION_OBJECT_CLASS (gee_read_only_set_parent_class)->finalize (obj);
}


GType gee_read_only_set_get_type (void) {
	static GType gee_read_only_set_type_id = 0;
	if (gee_read_only_set_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlySetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlySet), 0, (GInstanceInitFunc) gee_read_only_set_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_set_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_read_only_set_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_set_info = { (GInterfaceInitFunc) gee_read_only_set_gee_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_set_type_id = g_type_register_static (GEE_TYPE_COLLECTION_OBJECT, "GeeReadOnlySet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_set_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_read_only_set_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_type_add_interface_static (gee_read_only_set_type_id, GEE_TYPE_SET, &gee_set_info);
	}
	return gee_read_only_set_type_id;
}




