/* valaccodedynamicsignalbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicsignalbinding.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valadatatype.h>
#include <vala/valatypesymbol.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valacodevisitor.h>
#include <vala/valamember.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <gee/list.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeDynamicSignalBindingPrivate {
	ValaSignal* _node;
	char* connect_wrapper_name;
	char* disconnect_wrapper_name;
	char* dynamic_cname;
};

#define VALA_CCODE_DYNAMIC_SIGNAL_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, ValaCCodeDynamicSignalBindingPrivate))
enum  {
	VALA_CCODE_DYNAMIC_SIGNAL_BINDING_DUMMY_PROPERTY
};
static gint vala_ccode_dynamic_signal_binding_signal_wrapper_id;
static void vala_ccode_dynamic_signal_binding_generate_gobject_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block);
static gpointer vala_ccode_dynamic_signal_binding_parent_class = NULL;
static void vala_ccode_dynamic_signal_binding_finalize (ValaCodeBinding* obj);



ValaCCodeDynamicSignalBinding* vala_ccode_dynamic_signal_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaDynamicSignal* node) {
	ValaCCodeDynamicSignalBinding* self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (node), NULL);
	self = ((ValaCCodeDynamicSignalBinding*) (g_type_create_instance (object_type)));
	vala_ccode_dynamic_signal_binding_set_node (self, VALA_SIGNAL (node));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


ValaCCodeDynamicSignalBinding* vala_ccode_dynamic_signal_binding_new (ValaCCodeGenerator* codegen, ValaDynamicSignal* node) {
	return vala_ccode_dynamic_signal_binding_construct (VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, codegen, node);
}


char* vala_ccode_dynamic_signal_binding_get_dynamic_cname (ValaCCodeDynamicSignalBinding* self) {
	const char* _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	if (self->priv->dynamic_cname == NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		self->priv->dynamic_cname = (_tmp0 = g_strdup_printf ("dynamic_%s%d_", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_signal_binding_signal_wrapper_id++), (self->priv->dynamic_cname = (g_free (self->priv->dynamic_cname), NULL)), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = self->priv->dynamic_cname, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
}


char* vala_ccode_dynamic_signal_binding_get_connect_wrapper_name (ValaCCodeDynamicSignalBinding* self) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	const char* _tmp10;
	char* _tmp11;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (self->priv->connect_wrapper_name == NULL) {
		char* _tmp2;
		char* _tmp1;
		ValaCCodeFunction* func;
		ValaCCodeFormalParameter* _tmp3;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeFormalParameter* _tmp6;
		ValaCCodeBlock* block;
		ValaCCodeFunction* _tmp9;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->connect_wrapper_name = (_tmp2 = g_strdup_printf ("_%sconnect", (_tmp1 = vala_ccode_dynamic_signal_binding_get_dynamic_cname (self))), (self->priv->connect_wrapper_name = (g_free (self->priv->connect_wrapper_name), NULL)), _tmp2);
		_tmp1 = (g_free (_tmp1), NULL);
		func = vala_ccode_function_new (self->priv->connect_wrapper_name, "void");
		_tmp3 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp3 = vala_ccode_formal_parameter_new ("obj", "gpointer")));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("signal_name", "const char *")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("handler", "GCallback")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp6 = vala_ccode_formal_parameter_new ("data", "gpointer")));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		block = vala_ccode_block_new ();
		if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
			vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (self, block);
		} else {
			if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
				vala_ccode_dynamic_signal_binding_generate_gobject_connect_wrapper (self, block);
			} else {
				char* _tmp8;
				char* _tmp7;
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp8 = g_strdup_printf ("dynamic signals are not supported for `%s'", (_tmp7 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_signal_get_dynamic_type (dynamic_signal)))))));
				_tmp8 = (g_free (_tmp8), NULL);
				_tmp7 = (g_free (_tmp7), NULL);
			}
		}
		/* append to C source file*/
		_tmp9 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp9 = vala_ccode_function_copy (func))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		vala_ccode_function_set_block (func, block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
		(func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL)));
		(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	return (_tmp11 = (_tmp10 = self->priv->connect_wrapper_name, (_tmp10 == NULL ? NULL : g_strdup (_tmp10))), (dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL))), _tmp11);
}


char* vala_ccode_dynamic_signal_binding_get_disconnect_wrapper_name (ValaCCodeDynamicSignalBinding* self) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	const char* _tmp10;
	char* _tmp11;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (self->priv->disconnect_wrapper_name == NULL) {
		char* _tmp2;
		char* _tmp1;
		ValaCCodeFunction* func;
		ValaCCodeFormalParameter* _tmp3;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeFormalParameter* _tmp6;
		ValaCCodeBlock* block;
		ValaCCodeFunction* _tmp9;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->disconnect_wrapper_name = (_tmp2 = g_strdup_printf ("_%sdisconnect", (_tmp1 = vala_ccode_dynamic_signal_binding_get_dynamic_cname (self))), (self->priv->disconnect_wrapper_name = (g_free (self->priv->disconnect_wrapper_name), NULL)), _tmp2);
		_tmp1 = (g_free (_tmp1), NULL);
		func = vala_ccode_function_new (self->priv->disconnect_wrapper_name, "void");
		_tmp3 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp3 = vala_ccode_formal_parameter_new ("obj", "gpointer")));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("signal_name", "const char *")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("handler", "GCallback")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp6 = vala_ccode_formal_parameter_new ("data", "gpointer")));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		block = vala_ccode_block_new ();
		if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
			vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (self, block);
		} else {
			char* _tmp8;
			char* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp8 = g_strdup_printf ("dynamic signals are not supported for `%s'", (_tmp7 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_signal_get_dynamic_type (dynamic_signal)))))));
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp7 = (g_free (_tmp7), NULL);
		}
		/* append to C source file*/
		_tmp9 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp9 = vala_ccode_function_copy (func))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		vala_ccode_function_set_block (func, block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
		(func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL)));
		(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	return (_tmp11 = (_tmp10 = self->priv->disconnect_wrapper_name, (_tmp10 == NULL ? NULL : g_strdup (_tmp10))), (dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL))), _tmp11);
}


static void vala_ccode_dynamic_signal_binding_generate_gobject_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	ValaMethod* _tmp1;
	ValaMethod* m;
	char* connect_func;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeExpressionStatement* _tmp10;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (dynamic_signal))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_node), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	connect_func = g_strdup ("g_signal_connect_object");
	if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
		char* _tmp2;
		_tmp2 = NULL;
		connect_func = (_tmp2 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp2);
	}
	_tmp3 = NULL;
	_tmp4 = NULL;
	call = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (connect_func)))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("obj"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("signal_name"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("handler"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("data"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeConstant* _tmp9;
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("0"))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	}
	_tmp10 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	(dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL)));
	(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	connect_func = (g_free (connect_func), NULL);
	(call == NULL ? NULL : (call = (vala_ccode_node_unref (call), NULL)));
}


static void vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	ValaMethod* _tmp1;
	ValaMethod* m;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* register_call;
	GeeList* _tmp4;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	GeeList* _tmp5;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* add_call;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeConstant* _tmp14;
	char* _tmp13;
	char* _tmp12;
	gboolean first;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeExpressionStatement* _tmp35;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeFunctionCall* _tmp37;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeIdentifier* _tmp41;
	ValaCCodeConstant* _tmp42;
	ValaCCodeExpressionStatement* _tmp43;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (dynamic_signal))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_node), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* FIXME should only be done once per marshaller*/
	_tmp2 = NULL;
	_tmp3 = NULL;
	register_call = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("dbus_g_object_register_marshaller")))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	vala_ccode_generator_generate_marshaller (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp4 = vala_signal_get_parameters (self->priv->_node)), vala_signal_get_return_type (self->priv->_node), TRUE);
	(_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp5 = vala_signal_get_parameters (self->priv->_node)), vala_signal_get_return_type (self->priv->_node), NULL, TRUE))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	_tmp10 = NULL;
	add_call = (_tmp10 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("dbus_g_proxy_add_signal")))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), _tmp10);
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("obj"))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ((_tmp13 = g_strdup_printf ("\"%s\"", (_tmp12 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (self->priv->_node))))))))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	first = TRUE;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaArrayType* _tmp16;
				ValaDataType* _tmp15;
				ValaArrayType* array_type;
				if (first) {
					/* skip sender parameter*/
					first = FALSE;
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					continue;
				}
				_tmp16 = NULL;
				_tmp15 = NULL;
				array_type = (_tmp16 = (_tmp15 = vala_formal_parameter_get_parameter_type (param), (VALA_IS_ARRAY_TYPE (_tmp15) ? ((ValaArrayType*) (_tmp15)) : NULL)), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16)));
				if (array_type != NULL) {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaCCodeIdentifier* _tmp17;
						ValaCCodeIdentifier* _tmp18;
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("G_TYPE_STRV"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
					} else {
						char* _tmp19;
						gboolean _tmp20;
						ValaCCodeIdentifier* _tmp21;
						ValaCCodeFunctionCall* _tmp22;
						ValaCCodeFunctionCall* carray_type;
						ValaCCodeConstant* _tmp23;
						ValaCCodeIdentifier* _tmp25;
						char* _tmp24;
						_tmp19 = NULL;
						if ((_tmp20 = (_tmp19 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)))) == NULL, (_tmp19 = (g_free (_tmp19), NULL)), _tmp20)) {
							vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter type for D-Bus signals");
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
							(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
							(dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL)));
							(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
							(register_call == NULL ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL)));
							(add_call == NULL ? NULL : (add_call = (vala_ccode_node_unref (add_call), NULL)));
							return;
						}
						_tmp21 = NULL;
						_tmp22 = NULL;
						carray_type = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), _tmp22);
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("\"GArray\""))));
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
						_tmp25 = NULL;
						_tmp24 = NULL;
						vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type))))))));
						(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
						_tmp24 = (g_free (_tmp24), NULL);
						vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION (carray_type));
						vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (carray_type));
						(carray_type == NULL ? NULL : (carray_type = (vala_ccode_node_unref (carray_type), NULL)));
					}
				} else {
					char* _tmp26;
					gboolean _tmp27;
					ValaCCodeIdentifier* _tmp29;
					char* _tmp28;
					ValaCCodeIdentifier* _tmp31;
					char* _tmp30;
					_tmp26 = NULL;
					if ((_tmp27 = (_tmp26 = vala_data_type_get_type_id (vala_formal_parameter_get_parameter_type (param))) == NULL, (_tmp26 = (g_free (_tmp26), NULL)), _tmp27)) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter type for D-Bus signals");
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
						(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
						(dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL)));
						(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
						(register_call == NULL ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL)));
						(add_call == NULL ? NULL : (add_call = (vala_ccode_node_unref (add_call), NULL)));
						return;
					}
					_tmp29 = NULL;
					_tmp28 = NULL;
					vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_data_type_get_type_id (vala_formal_parameter_get_parameter_type (param)))))));
					(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
					_tmp28 = (g_free (_tmp28), NULL);
					_tmp31 = NULL;
					_tmp30 = NULL;
					vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = vala_data_type_get_type_id (vala_formal_parameter_get_parameter_type (param)))))));
					(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
					_tmp30 = (g_free (_tmp30), NULL);
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
	_tmp33 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp34 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	_tmp35 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (add_call)))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	_tmp36 = NULL;
	_tmp37 = NULL;
	call = (_tmp37 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("dbus_g_proxy_connect_signal")))), (_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL))), _tmp37);
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("obj"))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("signal_name"))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("handler"))));
	(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("data"))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("NULL"))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	_tmp43 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp43 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	(dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL)));
	(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	(register_call == NULL ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL)));
	(add_call == NULL ? NULL : (add_call = (vala_ccode_node_unref (add_call), NULL)));
	(call == NULL ? NULL : (call = (vala_ccode_node_unref (call), NULL)));
}


static void vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeExpressionStatement* _tmp7;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	call = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("dbus_g_proxy_disconnect_signal")))), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL))), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("obj"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("signal_name"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("handler"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("data"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	(dynamic_signal == NULL ? NULL : (dynamic_signal = (vala_code_node_unref (dynamic_signal), NULL)));
	(call == NULL ? NULL : (call = (vala_ccode_node_unref (call), NULL)));
}


ValaSignal* vala_ccode_dynamic_signal_binding_get_node (ValaCCodeDynamicSignalBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	return self->priv->_node;
}


void vala_ccode_dynamic_signal_binding_set_node (ValaCCodeDynamicSignalBinding* self, ValaSignal* value) {
	ValaSignal* _tmp2;
	ValaSignal* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_node = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_node == NULL ? NULL : (self->priv->_node = (vala_code_node_unref (self->priv->_node), NULL))), _tmp2);
}


static void vala_ccode_dynamic_signal_binding_class_init (ValaCCodeDynamicSignalBindingClass * klass) {
	vala_ccode_dynamic_signal_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_ccode_dynamic_signal_binding_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeDynamicSignalBindingPrivate));
}


static void vala_ccode_dynamic_signal_binding_instance_init (ValaCCodeDynamicSignalBinding * self) {
	self->priv = VALA_CCODE_DYNAMIC_SIGNAL_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_dynamic_signal_binding_finalize (ValaCodeBinding* obj) {
	ValaCCodeDynamicSignalBinding * self;
	self = VALA_CCODE_DYNAMIC_SIGNAL_BINDING (obj);
	(self->priv->_node == NULL ? NULL : (self->priv->_node = (vala_code_node_unref (self->priv->_node), NULL)));
	self->priv->connect_wrapper_name = (g_free (self->priv->connect_wrapper_name), NULL);
	self->priv->disconnect_wrapper_name = (g_free (self->priv->disconnect_wrapper_name), NULL);
	self->priv->dynamic_cname = (g_free (self->priv->dynamic_cname), NULL);
	VALA_CODE_BINDING_CLASS (vala_ccode_dynamic_signal_binding_parent_class)->finalize (obj);
}


GType vala_ccode_dynamic_signal_binding_get_type (void) {
	static GType vala_ccode_dynamic_signal_binding_type_id = 0;
	if (vala_ccode_dynamic_signal_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicSignalBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_signal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicSignalBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_signal_binding_instance_init, NULL };
		vala_ccode_dynamic_signal_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeDynamicSignalBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_signal_binding_type_id;
}




