/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodbinding.h>
#include <vala/valacodenode.h>
#include <vala/valaattribute.h>
#include <vala/valacreationmethod.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valasymbol.h>
#include <vala/valainterface.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <float.h>
#include <math.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valavaluetype.h>
#include <ccode/valaccodestruct.h>
#include <vala/valaclasstype.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <vala/valatypeparameter.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valamethodtype.h>
#include <gee/list.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeMethodBindingPrivate {
	ValaMethod* _method;
};

#define VALA_CCODE_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingPrivate))
enum  {
	VALA_CCODE_METHOD_BINDING_DUMMY_PROPERTY
};
static char* vala_ccode_method_binding_get_creturn_type (ValaCCodeMethodBinding* self, const char* default_value);
static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base);
static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym);
static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params);
static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl);
static gpointer vala_ccode_method_binding_parent_class = NULL;
static void vala_ccode_method_binding_finalize (ValaCodeBinding* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* vala_ccode_method_binding_get_custom_creturn_type (ValaCCodeMethodBinding* self) {
	ValaAttribute* attr;
	char* _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	attr = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = type, (attr == NULL ? NULL : (attr = (vala_code_node_unref (attr), NULL))), _tmp0);
		}
		type = (g_free (type), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = NULL, (attr == NULL ? NULL : (attr = (vala_code_node_unref (attr), NULL))), _tmp1);
}


static char* vala_ccode_method_binding_get_creturn_type (ValaCCodeMethodBinding* self, const char* default_value) {
	char* type;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_method_binding_get_custom_creturn_type (self);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (type = (g_free (type), NULL)), _tmp1);
	}
	return type;
}


ValaCCodeMethodBinding* vala_ccode_method_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaMethod* method) {
	ValaCCodeMethodBinding* self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (method), NULL);
	self = ((ValaCCodeMethodBinding*) (g_type_create_instance (object_type)));
	vala_ccode_method_binding_set_method (self, method);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCCodeGenerator* codegen, ValaMethod* method) {
	return vala_ccode_method_binding_construct (VALA_TYPE_CCODE_METHOD_BINDING, codegen, method);
}


static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMethodBinding * self;
	ValaMethod* _tmp0;
	ValaMethod* m;
	ValaMethod* _tmp1;
	ValaMethod* old_method;
	ValaDataType* _tmp2;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp4;
	ValaSymbol* _tmp3;
	ValaMethod* _tmp6;
	ValaMethod* _tmp5;
	ValaDataType* _tmp8;
	ValaDataType* _tmp7;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp9;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp23;
	ValaSymbol* _tmp22;
	ValaMethod* _tmp25;
	ValaMethod* _tmp24;
	ValaDataType* _tmp27;
	ValaDataType* _tmp26;
	ValaCCodeFunction* _tmp32;
	char* _tmp31;
	char* _tmp30;
	char* _tmp29;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CCODE_METHOD_BINDING (base);
	_tmp0 = NULL;
	m = (_tmp0 = self->priv->_method, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	old_method = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	old_return_type = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	old_method_inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	old_next_temp_var_id = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp4 = (_tmp3 = VALA_SYMBOL (m), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp6 = (_tmp5 = m, (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp8 = (_tmp7 = vala_method_get_return_type (m), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp8);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = FALSE;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp9 = NULL;
	creturn_type = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp11;
		ValaTypeSymbol* _tmp10;
		ValaClass* cl;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = TRUE;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cl = (_tmp11 = (_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (VALA_IS_CLASS (_tmp10) ? ((ValaClass*) (_tmp10)) : NULL)), (_tmp11 == NULL ? NULL : vala_code_node_ref (_tmp11)));
		if (cl != NULL && !vala_class_get_is_compact (cl)) {
			in_gtypeinstance_creation_method = TRUE;
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp12;
			_tmp12 = NULL;
			creturn_type = (_tmp12 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl))), (creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL))), _tmp12);
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
				GeeList* _tmp15;
				/* set construct properties*/
				{
					GeeList* stmt_collection;
					int stmt_it;
					stmt_collection = vala_block_get_statements (vala_method_get_body (m));
					for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
						ValaCodeNode* stmt;
						stmt = ((ValaCodeNode*) (VALA_CODE_NODE (gee_list_get (GEE_LIST (stmt_collection), stmt_it))));
						{
							ValaExpressionStatement* _tmp14;
							ValaCodeNode* _tmp13;
							ValaExpressionStatement* expr_stmt;
							_tmp14 = NULL;
							_tmp13 = NULL;
							expr_stmt = (_tmp14 = (_tmp13 = stmt, (VALA_IS_EXPRESSION_STATEMENT (_tmp13) ? ((ValaExpressionStatement*) (_tmp13)) : NULL)), (_tmp14 == NULL ? NULL : vala_code_node_ref (_tmp14)));
							if (expr_stmt != NULL) {
								ValaProperty* prop;
								prop = vala_expression_statement_assigned_property (expr_stmt);
								if (prop != NULL && vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
									if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
										{
											GeeList* cstmt_collection;
											int cstmt_it;
											cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
											for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
												ValaCCodeNode* cstmt;
												cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
												{
													vala_ccode_block_add_statement (cblock, cstmt);
													(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
												}
											}
											(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
										}
									} else {
										vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
									}
								}
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
							}
							(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
							(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
						}
					}
					(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
				}
				_tmp15 = NULL;
				vala_ccode_method_binding_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp15 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0);
				(_tmp15 == NULL ? NULL : (_tmp15 = (gee_collection_object_unref (_tmp15), NULL)));
			} else {
				char* _tmp17;
				char* _tmp16;
				ValaCCodeDeclaration* _tmp18;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp19;
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp18 = NULL;
				cdeclaration = (_tmp18 = vala_ccode_declaration_new ((_tmp17 = g_strdup_printf ("%s *", (_tmp16 = vala_typesymbol_get_cname (VALA_TYPESYMBOL ((VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol))), FALSE))))), (_tmp17 = (g_free (_tmp17), NULL)), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
				_tmp19 = NULL;
				vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR ((_tmp19 = vala_ccode_variable_declarator_new ("self"))));
				(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdeclaration));
				(cdeclaration == NULL ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL)));
			}
			/* other initialization code*/
			{
				GeeList* stmt_collection;
				int stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
					ValaCodeNode* stmt;
					stmt = ((ValaCodeNode*) (VALA_CODE_NODE (gee_list_get (GEE_LIST (stmt_collection), stmt_it))));
					{
						ValaExpressionStatement* _tmp21;
						ValaCodeNode* _tmp20;
						ValaExpressionStatement* expr_stmt;
						_tmp21 = NULL;
						_tmp20 = NULL;
						expr_stmt = (_tmp21 = (_tmp20 = stmt, (VALA_IS_EXPRESSION_STATEMENT (_tmp20) ? ((ValaExpressionStatement*) (_tmp20)) : NULL)), (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21)));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							if (prop != NULL && vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
								(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
								(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
								continue;
							}
							(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						}
						if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
							{
								GeeList* cstmt_collection;
								int cstmt_it;
								cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
								for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
									ValaCCodeNode* cstmt;
									cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
									{
										vala_ccode_block_add_statement (cblock, cstmt);
										(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
									}
								}
								(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
							}
						} else {
							vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
						}
						(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
						(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
		}
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = FALSE;
	}
	inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp23 = (_tmp22 = vala_symbol_get_parent_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp23);
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp25 = (_tmp24 = old_method, (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp25);
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp27 = (_tmp26 = old_return_type, (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp27);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = old_method_inner_error;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
		ValaInterface* _tmp28;
		ValaInterface* iface;
		_tmp28 = NULL;
		iface = (_tmp28 = VALA_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			(old_method == NULL ? NULL : (old_method = (vala_code_node_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
			(creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
	}
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (_tmp32 = vala_ccode_function_new ((_tmp29 = vala_method_get_real_cname (m)), (_tmp31 = vala_ccode_method_binding_get_creturn_type (self, (_tmp30 = vala_data_type_get_cname (creturn_type))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), NULL))), _tmp32);
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp29 = (g_free (_tmp29), NULL);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp33;
		ValaClass* cl;
		_tmp33 = NULL;
		cl = (_tmp33 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp33 == NULL ? NULL : vala_code_node_ref (_tmp33)));
		if (!vala_class_get_is_compact (cl)) {
			ValaCCodeFormalParameter* _tmp34;
			_tmp34 = NULL;
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), (_tmp34 = vala_ccode_formal_parameter_new ("object_type", "GType")));
			(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m))) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaCCodeFormalParameter* instance_param;
			parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
			this_type = NULL;
			if (VALA_IS_CLASS (parent_type)) {
				ValaDataType* _tmp35;
				_tmp35 = NULL;
				this_type = (_tmp35 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (parent_type)))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp35);
			} else {
				if (VALA_IS_INTERFACE (parent_type)) {
					ValaDataType* _tmp36;
					_tmp36 = NULL;
					this_type = (_tmp36 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (parent_type)))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp36);
				} else {
					ValaDataType* _tmp37;
					_tmp37 = NULL;
					this_type = (_tmp37 = VALA_DATA_TYPE (vala_value_type_new (parent_type)), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp37);
				}
			}
			instance_param = NULL;
			if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp39;
				char* _tmp38;
				base_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m))))));
				_tmp39 = NULL;
				_tmp38 = NULL;
				instance_param = (_tmp39 = vala_ccode_formal_parameter_new ("base", (_tmp38 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp39);
				_tmp38 = (g_free (_tmp38), NULL);
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
			} else {
				if (vala_method_get_overrides (m)) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp41;
					char* _tmp40;
					base_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m))))));
					_tmp41 = NULL;
					_tmp40 = NULL;
					instance_param = (_tmp41 = vala_ccode_formal_parameter_new ("base", (_tmp40 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp41);
					_tmp40 = (g_free (_tmp40), NULL);
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				} else {
					if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))) {
						ValaCCodeFormalParameter* _tmp43;
						char* _tmp42;
						_tmp43 = NULL;
						_tmp42 = NULL;
						instance_param = (_tmp43 = vala_ccode_formal_parameter_new ("*self", (_tmp42 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp43);
						_tmp42 = (g_free (_tmp42), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp45;
						char* _tmp44;
						_tmp45 = NULL;
						_tmp44 = NULL;
						instance_param = (_tmp45 = vala_ccode_formal_parameter_new ("self", (_tmp44 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp45);
						_tmp44 = (g_free (_tmp44), NULL);
					}
				}
			}
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
			if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
				char* _tmp47;
				char* _tmp46;
				ValaCCodeDeclaration* _tmp48;
				ValaCCodeDeclaration* vdecl;
				ValaCCodeFunctionDeclarator* _tmp49;
				_tmp47 = NULL;
				_tmp46 = NULL;
				_tmp48 = NULL;
				vdecl = (_tmp48 = vala_ccode_declaration_new ((_tmp47 = vala_ccode_method_binding_get_creturn_type (self, (_tmp46 = vala_data_type_get_cname (creturn_type))))), (_tmp47 = (g_free (_tmp47), NULL)), (_tmp46 = (g_free (_tmp46), NULL)), _tmp48);
				_tmp49 = NULL;
				vdeclarator = (_tmp49 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL))), _tmp49);
				vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
				vala_ccode_struct_add_declaration (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, vdecl);
				(vdecl == NULL ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL)));
			}
			(parent_type == NULL ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL)));
			(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
			(instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)));
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaDataType* _tmp50;
				char* _tmp51;
				ValaCCodeFormalParameter* _tmp52;
				ValaCCodeFormalParameter* class_param;
				parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
				this_type = NULL;
				_tmp50 = NULL;
				this_type = (_tmp50 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp50);
				_tmp51 = NULL;
				_tmp52 = NULL;
				class_param = (_tmp52 = vala_ccode_formal_parameter_new ("klass", (_tmp51 = vala_data_type_get_cname (this_type))), (_tmp51 = (g_free (_tmp51), NULL)), _tmp52);
				gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
				(parent_type == NULL ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL)));
				(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
				(class_param == NULL ? NULL : (class_param = (vala_ccode_node_unref (class_param), NULL)));
			}
		}
	}
	vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, in_gtypeinstance_creation_method, GEE_MAP (cparam_map), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vdeclarator, NULL, NULL);
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (!vala_method_get_is_abstract (m) || (vala_method_get_is_abstract (m) && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol))) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp53;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp53 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp53 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
		} else {
			ValaCCodeFunction* _tmp54;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp54 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp54 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
			vala_ccode_node_set_line (VALA_CCODE_NODE (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
				ValaClass* _tmp55;
				ValaClass* cl;
				_tmp55 = NULL;
				cl = (_tmp55 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp55 == NULL ? NULL : vala_code_node_ref (_tmp55)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp62;
					ValaCCodeExpression* _tmp63;
					ValaCCodeExpression* cself;
					char* _tmp65;
					char* _tmp64;
					ValaCCodeDeclaration* _tmp66;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp67;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp57;
						ValaMethod* _tmp56;
						ValaReferenceType* _tmp58;
						_tmp57 = NULL;
						_tmp56 = NULL;
						base_method = (_tmp57 = (_tmp56 = vala_method_get_base_method (m), (_tmp56 == NULL ? NULL : vala_code_node_ref (_tmp56))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp57);
						_tmp58 = NULL;
						base_expression_type = (_tmp58 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)))))), (base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL))), _tmp58);
					} else {
						ValaMethod* _tmp60;
						ValaMethod* _tmp59;
						ValaReferenceType* _tmp61;
						_tmp60 = NULL;
						_tmp59 = NULL;
						base_method = (_tmp60 = (_tmp59 = vala_method_get_base_interface_method (m), (_tmp59 == NULL ? NULL : vala_code_node_ref (_tmp59))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp60);
						_tmp61 = NULL;
						base_expression_type = (_tmp61 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)))))), (base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL))), _tmp61);
					}
					self_target_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl));
					_tmp62 = NULL;
					_tmp63 = NULL;
					cself = (_tmp63 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("base"))), VALA_DATA_TYPE (base_expression_type), VALA_DATA_TYPE (self_target_type), NULL), (_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL))), _tmp63);
					_tmp65 = NULL;
					_tmp64 = NULL;
					_tmp66 = NULL;
					cdecl_ = (_tmp66 = vala_ccode_declaration_new ((_tmp65 = g_strdup_printf ("%s *", (_tmp64 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp65 = (g_free (_tmp65), NULL)), (_tmp64 = (g_free (_tmp64), NULL)), _tmp66);
					_tmp67 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp67 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, VALA_TYPESYMBOL (cl), TRUE, "self");
						vala_ccode_node_set_line (VALA_CCODE_NODE (ccheckstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (ccheckstmt));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (vala_ccode_node_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						ValaTypeSymbol* _tmp68;
						ValaTypeSymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							break;
						}
						_tmp68 = NULL;
						t = (_tmp68 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp68 == NULL ? NULL : vala_code_node_ref (_tmp68)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))), vala_symbol_get_name (VALA_SYMBOL (param)));
								if (type_check != NULL) {
									vala_ccode_node_set_line (VALA_CCODE_NODE (type_check), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
								}
								(type_check == NULL ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp71;
								ValaCCodeUnaryExpression* _tmp70;
								ValaCCodeIdentifier* _tmp69;
								ValaCCodeAssignment* _tmp72;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp73;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp71 = NULL;
								_tmp70 = NULL;
								_tmp69 = NULL;
								_tmp72 = NULL;
								a = (_tmp72 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))), VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL))), (_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL))), _tmp72);
								_tmp73 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp73 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (a)))));
								(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
								(a == NULL ? NULL : (a = (vala_ccode_node_unref (a), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						(t == NULL ? NULL : (t = (vala_code_node_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp75;
				ValaCCodeConstant* _tmp74;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp75 = NULL;
				_tmp74 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp75 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_constant_new ("NULL")))))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
				(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* _tmp76;
				_tmp76 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp76 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
			}
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					GeeList* _tmp77;
					gboolean _tmp78;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp77 = NULL;
					if ((_tmp78 = n_params > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp77 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0, (_tmp77 == NULL ? NULL : (_tmp77 = (gee_collection_object_unref (_tmp77), NULL))), _tmp78)) {
						ValaCCodeIdentifier* _tmp79;
						ValaCCodeFunctionCall* _tmp80;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp81;
						ValaCCodeConstant* _tmp84;
						char* _tmp83;
						GeeList* _tmp82;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp85;
						ValaCCodeDeclaration* _tmp86;
						ValaCCodeVariableDeclarator* _tmp88;
						ValaCCodeIdentifier* _tmp87;
						/* declare construction parameter array*/
						_tmp79 = NULL;
						_tmp80 = NULL;
						cparamsinit = (_tmp80 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ("g_new0")))), (_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL))), _tmp80);
						_tmp81 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
						_tmp84 = NULL;
						_tmp83 = NULL;
						_tmp82 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_constant_new ((_tmp83 = g_strdup_printf ("%i", (n_params + 3 * gee_collection_get_size (GEE_COLLECTION ((_tmp82 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))))))))));
						(_tmp84 == NULL ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)));
						_tmp83 = (g_free (_tmp83), NULL);
						(_tmp82 == NULL ? NULL : (_tmp82 = (gee_collection_object_unref (_tmp82), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp85 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp85 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp86 = NULL;
						cdecl_ = (_tmp86 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp86);
						_tmp88 = NULL;
						_tmp87 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp88 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new ("__params")))))));
						(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
						(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (vala_ccode_node_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* type_param_collection;
						int type_param_it;
						type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
						for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
							ValaTypeParameter* type_param;
							type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
							{
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp91;
								char* _tmp90;
								char* _tmp89;
								ValaCCodeIdentifier* _tmp94;
								char* _tmp93;
								char* _tmp92;
								ValaCCodeExpressionStatement* _tmp97;
								ValaCCodeExpression* _tmp96;
								ValaValueType* _tmp95;
								ValaCCodeConstant* _tmp100;
								char* _tmp99;
								char* _tmp98;
								ValaCCodeIdentifier* _tmp103;
								char* _tmp102;
								char* _tmp101;
								ValaCCodeExpressionStatement* _tmp107;
								ValaCCodeExpression* _tmp106;
								ValaPointerType* _tmp105;
								ValaVoidType* _tmp104;
								ValaCCodeConstant* _tmp110;
								char* _tmp109;
								char* _tmp108;
								ValaCCodeIdentifier* _tmp113;
								char* _tmp112;
								char* _tmp111;
								ValaCCodeExpressionStatement* _tmp117;
								ValaCCodeExpression* _tmp116;
								ValaPointerType* _tmp115;
								ValaVoidType* _tmp114;
								prop_name = NULL;
								param_name = NULL;
								_tmp91 = NULL;
								_tmp90 = NULL;
								_tmp89 = NULL;
								prop_name = (_tmp91 = vala_ccode_constant_new ((_tmp90 = g_strdup_printf ("\"%s-type\"", (_tmp89 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp91);
								_tmp90 = (g_free (_tmp90), NULL);
								_tmp89 = (g_free (_tmp89), NULL);
								_tmp94 = NULL;
								_tmp93 = NULL;
								_tmp92 = NULL;
								param_name = (_tmp94 = vala_ccode_identifier_new ((_tmp93 = g_strdup_printf ("%s_type", (_tmp92 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp94);
								_tmp93 = (g_free (_tmp93), NULL);
								_tmp92 = (g_free (_tmp92), NULL);
								_tmp97 = NULL;
								_tmp96 = NULL;
								_tmp95 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp97 = vala_ccode_expression_statement_new ((_tmp96 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp95 = vala_value_type_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtype_type))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
								(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
								(_tmp95 == NULL ? NULL : (_tmp95 = (vala_code_node_unref (_tmp95), NULL)));
								_tmp100 = NULL;
								_tmp99 = NULL;
								_tmp98 = NULL;
								prop_name = (_tmp100 = vala_ccode_constant_new ((_tmp99 = g_strdup_printf ("\"%s-dup-func\"", (_tmp98 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp100);
								_tmp99 = (g_free (_tmp99), NULL);
								_tmp98 = (g_free (_tmp98), NULL);
								_tmp103 = NULL;
								_tmp102 = NULL;
								_tmp101 = NULL;
								param_name = (_tmp103 = vala_ccode_identifier_new ((_tmp102 = g_strdup_printf ("%s_dup_func", (_tmp101 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp103);
								_tmp102 = (g_free (_tmp102), NULL);
								_tmp101 = (g_free (_tmp101), NULL);
								_tmp107 = NULL;
								_tmp106 = NULL;
								_tmp105 = NULL;
								_tmp104 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp107 = vala_ccode_expression_statement_new ((_tmp106 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp105 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp104 = vala_void_type_new ())), NULL))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
								(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
								(_tmp105 == NULL ? NULL : (_tmp105 = (vala_code_node_unref (_tmp105), NULL)));
								(_tmp104 == NULL ? NULL : (_tmp104 = (vala_code_node_unref (_tmp104), NULL)));
								_tmp110 = NULL;
								_tmp109 = NULL;
								_tmp108 = NULL;
								prop_name = (_tmp110 = vala_ccode_constant_new ((_tmp109 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp108 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp110);
								_tmp109 = (g_free (_tmp109), NULL);
								_tmp108 = (g_free (_tmp108), NULL);
								_tmp113 = NULL;
								_tmp112 = NULL;
								_tmp111 = NULL;
								param_name = (_tmp113 = vala_ccode_identifier_new ((_tmp112 = g_strdup_printf ("%s_destroy_func", (_tmp111 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp113);
								_tmp112 = (g_free (_tmp112), NULL);
								_tmp111 = (g_free (_tmp111), NULL);
								_tmp117 = NULL;
								_tmp116 = NULL;
								_tmp115 = NULL;
								_tmp114 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp117 = vala_ccode_expression_statement_new ((_tmp116 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp115 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp114 = vala_void_type_new ())), NULL))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp117 == NULL ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL)));
								(_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)));
								(_tmp115 == NULL ? NULL : (_tmp115 = (vala_code_node_unref (_tmp115), NULL)));
								(_tmp114 == NULL ? NULL : (_tmp114 = (vala_code_node_unref (_tmp114), NULL)));
								(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
								(prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)));
								(param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
					}
				} else {
					if (in_gtypeinstance_creation_method) {
						ValaClass* _tmp118;
						ValaClass* cl;
						char* _tmp120;
						char* _tmp119;
						ValaCCodeDeclaration* _tmp121;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp122;
						ValaCCodeFunctionCall* _tmp123;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp124;
						ValaCCodeVariableDeclarator* _tmp128;
						ValaCCodeCastExpression* _tmp127;
						char* _tmp126;
						char* _tmp125;
						_tmp118 = NULL;
						cl = (_tmp118 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp118 == NULL ? NULL : vala_code_node_ref (_tmp118)));
						_tmp120 = NULL;
						_tmp119 = NULL;
						_tmp121 = NULL;
						cdecl_ = (_tmp121 = vala_ccode_declaration_new ((_tmp120 = g_strconcat ((_tmp119 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp120 = (g_free (_tmp120), NULL)), (_tmp119 = (g_free (_tmp119), NULL)), _tmp121);
						_tmp122 = NULL;
						_tmp123 = NULL;
						ccall = (_tmp123 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_identifier_new ("g_type_create_instance")))), (_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL))), _tmp123);
						_tmp124 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("object_type"))));
						(_tmp124 == NULL ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL)));
						_tmp128 = NULL;
						_tmp127 = NULL;
						_tmp126 = NULL;
						_tmp125 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp128 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp126 = g_strconcat ((_tmp125 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))))))));
						(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
						(_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)));
						_tmp126 = (g_free (_tmp126), NULL);
						_tmp125 = (g_free (_tmp125), NULL);
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* type_param_collection;
							int type_param_it;
							type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
							for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
								ValaTypeParameter* type_param;
								type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
								{
									ValaCCodeIdentifier* param_name;
									ValaCCodeAssignment* assign;
									ValaCCodeIdentifier* _tmp129;
									ValaCCodeMemberAccess* _tmp130;
									ValaCCodeMemberAccess* priv_access;
									ValaCCodeIdentifier* _tmp133;
									char* _tmp132;
									char* _tmp131;
									ValaCCodeAssignment* _tmp135;
									ValaCCodeMemberAccess* _tmp134;
									ValaCCodeExpressionStatement* _tmp136;
									ValaCCodeIdentifier* _tmp139;
									char* _tmp138;
									char* _tmp137;
									ValaCCodeAssignment* _tmp141;
									ValaCCodeMemberAccess* _tmp140;
									ValaCCodeExpressionStatement* _tmp142;
									ValaCCodeIdentifier* _tmp145;
									char* _tmp144;
									char* _tmp143;
									ValaCCodeAssignment* _tmp147;
									ValaCCodeMemberAccess* _tmp146;
									ValaCCodeExpressionStatement* _tmp148;
									param_name = NULL;
									assign = NULL;
									_tmp129 = NULL;
									_tmp130 = NULL;
									priv_access = (_tmp130 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_identifier_new ("self"))), "priv"), (_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL))), _tmp130);
									_tmp133 = NULL;
									_tmp132 = NULL;
									_tmp131 = NULL;
									param_name = (_tmp133 = vala_ccode_identifier_new ((_tmp132 = g_strdup_printf ("%s_type", (_tmp131 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp133);
									_tmp132 = (g_free (_tmp132), NULL);
									_tmp131 = (g_free (_tmp131), NULL);
									_tmp135 = NULL;
									_tmp134 = NULL;
									assign = (_tmp135 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp134 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp135);
									(_tmp134 == NULL ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)));
									_tmp136 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp136 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp136 == NULL ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL)));
									_tmp139 = NULL;
									_tmp138 = NULL;
									_tmp137 = NULL;
									param_name = (_tmp139 = vala_ccode_identifier_new ((_tmp138 = g_strdup_printf ("%s_dup_func", (_tmp137 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp139);
									_tmp138 = (g_free (_tmp138), NULL);
									_tmp137 = (g_free (_tmp137), NULL);
									_tmp141 = NULL;
									_tmp140 = NULL;
									assign = (_tmp141 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp141);
									(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
									_tmp142 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp142 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)));
									_tmp145 = NULL;
									_tmp144 = NULL;
									_tmp143 = NULL;
									param_name = (_tmp145 = vala_ccode_identifier_new ((_tmp144 = g_strdup_printf ("%s_destroy_func", (_tmp143 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp145);
									_tmp144 = (g_free (_tmp144), NULL);
									_tmp143 = (g_free (_tmp143), NULL);
									_tmp147 = NULL;
									_tmp146 = NULL;
									assign = (_tmp147 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp147);
									(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
									_tmp148 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp148 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp148 == NULL ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL)));
									(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
									(param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)));
									(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
									(priv_access == NULL ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL)));
								}
							}
							(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
						}
						(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
					} else {
						if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
							ValaClass* _tmp149;
							ValaClass* cl;
							char* _tmp151;
							char* _tmp150;
							ValaCCodeDeclaration* _tmp152;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp153;
							ValaCCodeFunctionCall* _tmp154;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp156;
							char* _tmp155;
							ValaCCodeVariableDeclarator* _tmp157;
							ValaCCodeIdentifier* _tmp160;
							char* _tmp159;
							char* _tmp158;
							ValaCCodeFunctionCall* _tmp161;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp162;
							ValaCCodeExpressionStatement* _tmp163;
							_tmp149 = NULL;
							cl = (_tmp149 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp149 == NULL ? NULL : vala_code_node_ref (_tmp149)));
							_tmp151 = NULL;
							_tmp150 = NULL;
							_tmp152 = NULL;
							cdecl_ = (_tmp152 = vala_ccode_declaration_new ((_tmp151 = g_strconcat ((_tmp150 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp151 = (g_free (_tmp151), NULL)), (_tmp150 = (g_free (_tmp150), NULL)), _tmp152);
							_tmp153 = NULL;
							_tmp154 = NULL;
							ccall = (_tmp154 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp153 == NULL ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL))), _tmp154);
							_tmp156 = NULL;
							_tmp155 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ((_tmp155 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
							(_tmp156 == NULL ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL)));
							_tmp155 = (g_free (_tmp155), NULL);
							_tmp157 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp157 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
							(_tmp157 == NULL ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL)));
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
							_tmp160 = NULL;
							_tmp159 = NULL;
							_tmp158 = NULL;
							_tmp161 = NULL;
							cinitcall = (_tmp161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ((_tmp159 = g_strdup_printf ("%s_instance_init", (_tmp158 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))))))), (_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL))), (_tmp159 = (g_free (_tmp159), NULL)), (_tmp158 = (g_free (_tmp158), NULL)), _tmp161);
							_tmp162 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_identifier_new ("self"))));
							(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
							_tmp163 = NULL;
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp163 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinitcall)))));
							(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
							(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(cinitcall == NULL ? NULL : (cinitcall = (vala_ccode_node_unref (cinitcall), NULL)));
						} else {
							ValaStruct* _tmp164;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp165;
							ValaCCodeFunctionCall* _tmp166;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp167;
							ValaCCodeConstant* _tmp168;
							ValaCCodeIdentifier* _tmp171;
							char* _tmp170;
							char* _tmp169;
							ValaCCodeExpressionStatement* _tmp172;
							_tmp164 = NULL;
							st = (_tmp164 = VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp164 == NULL ? NULL : vala_code_node_ref (_tmp164)));
							/* memset needs string.h*/
							vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
							_tmp165 = NULL;
							_tmp166 = NULL;
							czero = (_tmp166 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_identifier_new ("memset")))), (_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL))), _tmp166);
							_tmp167 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp167 = vala_ccode_identifier_new ("self"))));
							(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
							_tmp168 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_constant_new ("0"))));
							(_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL)));
							_tmp171 = NULL;
							_tmp170 = NULL;
							_tmp169 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp171 = vala_ccode_identifier_new ((_tmp170 = g_strdup_printf ("sizeof (%s)", (_tmp169 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))))));
							(_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL)));
							_tmp170 = (g_free (_tmp170), NULL);
							_tmp169 = (g_free (_tmp169), NULL);
							_tmp172 = NULL;
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp172 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
							(_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL)));
							(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
							(czero == NULL ? NULL : (czero = (vala_ccode_node_unref (czero), NULL)));
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) == m && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment));
			}
			{
				GeeList* precondition_collection;
				int precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
					ValaExpression* precondition;
					precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
					{
						ValaCCodeStatement* _tmp173;
						_tmp173 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp173 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
						(_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)));
						(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* _tmp174;
				ValaCCodeIdentifier* _tmp175;
				ValaCCodeFunctionCall* _tmp176;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp177;
				ValaCCodeIdentifier* _tmp178;
				ValaCCodeFunctionCall* _tmp179;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp180;
				char* _tmp181;
				char* error_string;
				ValaCCodeIdentifier* _tmp182;
				ValaCCodeFunctionCall* _tmp183;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp184;
				ValaCCodeExpressionStatement* _tmp185;
				ValaCCodeReturnStatement* _tmp187;
				ValaCCodeExpression* _tmp186;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				_tmp174 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp174 = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, TRUE, "self"))));
				(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
				/* add critical warning that this method should not have been called*/
				_tmp175 = NULL;
				_tmp176 = NULL;
				type_from_instance_call = (_tmp176 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE")))), (_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL))), _tmp176);
				_tmp177 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_identifier_new ("self"))));
				(_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)));
				_tmp178 = NULL;
				_tmp179 = NULL;
				type_name_call = (_tmp179 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp178 = vala_ccode_identifier_new ("g_type_name")))), (_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL))), _tmp179);
				vala_ccode_function_call_add_argument (type_name_call, VALA_CCODE_EXPRESSION (type_from_instance_call));
				_tmp180 = NULL;
				_tmp181 = NULL;
				error_string = (_tmp181 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", (_tmp180 = vala_method_get_cname (m))), (_tmp180 = (g_free (_tmp180), NULL)), _tmp181);
				_tmp182 = NULL;
				_tmp183 = NULL;
				cerrorcall = (_tmp183 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ("g_critical")))), (_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL))), _tmp183);
				_tmp184 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, VALA_CCODE_EXPRESSION ((_tmp184 = vala_ccode_constant_new (error_string))));
				(_tmp184 == NULL ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL)));
				vala_ccode_function_call_add_argument (cerrorcall, VALA_CCODE_EXPRESSION (type_name_call));
				_tmp185 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp185 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cerrorcall)))));
				(_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)));
				/* add return statement*/
				_tmp187 = NULL;
				_tmp186 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp187 = vala_ccode_return_statement_new ((_tmp186 = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), creturn_type, FALSE))))));
				(_tmp187 == NULL ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL)));
				(_tmp186 == NULL ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)));
				vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, cblock);
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
				(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
				(type_from_instance_call == NULL ? NULL : (type_from_instance_call = (vala_ccode_node_unref (type_from_instance_call), NULL)));
				(type_name_call == NULL ? NULL : (type_name_call = (vala_ccode_node_unref (type_name_call), NULL)));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL ? NULL : (cerrorcall = (vala_ccode_node_unref (cerrorcall), NULL)));
			}
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp189;
		char* _tmp188;
		ValaCCodeFunction* _tmp190;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		GeeHashMap* _tmp193;
		GeeHashMap* carg_map;
		char* _tmp194;
		ValaCCodeFormalParameter* _tmp195;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp207;
		ValaCCodeMemberAccess* _tmp208;
		ValaCCodeFunctionCall* _tmp209;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp210;
		ValaCCodeStatement* cstmt;
		GeeList* _tmp221;
		gboolean _tmp222;
		_tmp189 = NULL;
		_tmp188 = NULL;
		_tmp190 = NULL;
		vfunc = (_tmp190 = vala_ccode_function_new ((_tmp188 = vala_method_get_cname (m)), (_tmp189 = vala_data_type_get_cname (creturn_type))), (_tmp189 = (g_free (_tmp189), NULL)), (_tmp188 = (g_free (_tmp188), NULL)), _tmp190);
		vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaReferenceType* _tmp191;
			_tmp191 = NULL;
			this_type = (_tmp191 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp191);
		} else {
			ValaReferenceType* _tmp192;
			_tmp192 = NULL;
			this_type = (_tmp192 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp192);
		}
		_tmp193 = NULL;
		cparam_map = (_tmp193 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), _tmp193);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp194 = NULL;
		_tmp195 = NULL;
		cparam = (_tmp195 = vala_ccode_formal_parameter_new ("self", (_tmp194 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type)))), (_tmp194 = (g_free (_tmp194), NULL)), _tmp195);
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeList* precondition_collection;
			int precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
				ValaExpression* precondition;
				precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
				{
					ValaCCodeStatement* _tmp196;
					_tmp196 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp196 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
					(_tmp196 == NULL ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL)));
					(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaInterface* _tmp197;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp201;
			ValaCCodeIdentifier* _tmp200;
			char* _tmp199;
			char* _tmp198;
			_tmp197 = NULL;
			iface = (_tmp197 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp197 == NULL ? NULL : vala_code_node_ref (_tmp197)));
			_tmp201 = NULL;
			_tmp200 = NULL;
			_tmp199 = NULL;
			_tmp198 = NULL;
			vcast = (_tmp201 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp200 = vala_ccode_identifier_new ((_tmp199 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp198 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp201);
			(_tmp200 == NULL ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL)));
			_tmp199 = (g_free (_tmp199), NULL);
			_tmp198 = (g_free (_tmp198), NULL);
			(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
		} else {
			ValaClass* _tmp202;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp206;
			ValaCCodeIdentifier* _tmp205;
			char* _tmp204;
			char* _tmp203;
			_tmp202 = NULL;
			cl = (_tmp202 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp202 == NULL ? NULL : vala_code_node_ref (_tmp202)));
			_tmp206 = NULL;
			_tmp205 = NULL;
			_tmp204 = NULL;
			_tmp203 = NULL;
			vcast = (_tmp206 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp205 = vala_ccode_identifier_new ((_tmp204 = g_strdup_printf ("%s_GET_CLASS", (_tmp203 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp206);
			(_tmp205 == NULL ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL)));
			_tmp204 = (g_free (_tmp204), NULL);
			_tmp203 = (g_free (_tmp203), NULL);
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
		}
		_tmp207 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp207 = vala_ccode_identifier_new ("self"))));
		(_tmp207 == NULL ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL)));
		_tmp208 = NULL;
		_tmp209 = NULL;
		vcall = (_tmp209 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp208 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp208 == NULL ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL))), _tmp209);
		_tmp210 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp210 = vala_ccode_identifier_new ("self"))));
		(_tmp210 == NULL ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL)));
		vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, in_gtypeinstance_creation_method, GEE_MAP (cparam_map), vfunc, NULL, GEE_MAP (carg_map), vcall);
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp211;
			_tmp211 = NULL;
			cstmt = (_tmp211 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp211);
		} else {
			GeeList* _tmp212;
			gboolean _tmp213;
			_tmp212 = NULL;
			if ((_tmp213 = gee_collection_get_size (GEE_COLLECTION ((_tmp212 = vala_method_get_postconditions (m)))) == 0, (_tmp212 == NULL ? NULL : (_tmp212 = (gee_collection_object_unref (_tmp212), NULL))), _tmp213)) {
				ValaCCodeStatement* _tmp214;
				/* pass method return value */
				_tmp214 = NULL;
				cstmt = (_tmp214 = VALA_CCODE_STATEMENT (vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp214);
			} else {
				char* _tmp216;
				char* _tmp215;
				ValaCCodeDeclaration* _tmp217;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp218;
				ValaCCodeStatement* _tmp220;
				ValaCCodeStatement* _tmp219;
				/* store method return value for postconditions */
				_tmp216 = NULL;
				_tmp215 = NULL;
				_tmp217 = NULL;
				cdecl_ = (_tmp217 = vala_ccode_declaration_new ((_tmp216 = vala_ccode_method_binding_get_creturn_type (self, (_tmp215 = vala_data_type_get_cname (creturn_type))))), (_tmp216 = (g_free (_tmp216), NULL)), (_tmp215 = (g_free (_tmp215), NULL)), _tmp217);
				_tmp218 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp218 = vala_ccode_variable_declarator_new_with_initializer ("result", VALA_CCODE_EXPRESSION (vcall)))));
				(_tmp218 == NULL ? NULL : (_tmp218 = (vala_ccode_node_unref (_tmp218), NULL)));
				_tmp220 = NULL;
				_tmp219 = NULL;
				cstmt = (_tmp220 = (_tmp219 = VALA_CCODE_STATEMENT (cdecl_), (_tmp219 == NULL ? NULL : vala_ccode_node_ref (_tmp219))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp220);
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
		}
		vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
		vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
		_tmp221 = NULL;
		if ((_tmp222 = gee_collection_get_size (GEE_COLLECTION ((_tmp221 = vala_method_get_postconditions (m)))) > 0, (_tmp221 == NULL ? NULL : (_tmp221 = (gee_collection_object_unref (_tmp221), NULL))), _tmp222)) {
			{
				GeeList* postcondition_collection;
				int postcondition_it;
				postcondition_collection = vala_method_get_postconditions (m);
				for (postcondition_it = 0; postcondition_it < gee_collection_get_size (GEE_COLLECTION (postcondition_collection)); postcondition_it = postcondition_it + 1) {
					ValaExpression* postcondition;
					postcondition = ((ValaExpression*) (gee_list_get (GEE_LIST (postcondition_collection), postcondition_it)));
					{
						ValaCCodeStatement* _tmp223;
						_tmp223 = NULL;
						vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp223 = vala_ccode_method_binding_create_postcondition_statement (self, postcondition))));
						(_tmp223 == NULL ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL)));
						(postcondition == NULL ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL)));
					}
				}
				(postcondition_collection == NULL ? NULL : (postcondition_collection = (gee_collection_object_unref (postcondition_collection), NULL)));
			}
			if (!(VALA_IS_VOID_TYPE (creturn_type))) {
				ValaCCodeIdentifier* _tmp224;
				ValaCCodeReturnStatement* _tmp225;
				ValaCCodeReturnStatement* cret_stmt;
				_tmp224 = NULL;
				_tmp225 = NULL;
				cret_stmt = (_tmp225 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp224 = vala_ccode_identifier_new ("result")))), (_tmp224 == NULL ? NULL : (_tmp224 = (vala_ccode_node_unref (_tmp224), NULL))), _tmp225);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
				vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cret_stmt));
				(cret_stmt == NULL ? NULL : (cret_stmt = (vala_ccode_node_unref (cret_stmt), NULL)));
			}
		}
		if (visible) {
			ValaCCodeFunction* _tmp226;
			_tmp226 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp226 = vala_ccode_function_copy (vfunc))));
			(_tmp226 == NULL ? NULL : (_tmp226 = (vala_ccode_node_unref (_tmp226), NULL)));
		} else {
			ValaCCodeFunction* _tmp227;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp227 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp227 = vala_ccode_function_copy (vfunc))));
			(_tmp227 == NULL ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
			ValaCCodeComment* _tmp228;
			_tmp228 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp228 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
			(_tmp228 == NULL ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL)));
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
		(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp240;
		gboolean _tmp241;
		if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class != NULL && !vala_class_get_is_compact (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)) {
			char* _tmp230;
			char* _tmp229;
			ValaCCodeFunction* _tmp231;
			ValaCCodeFunction* vfunc;
			ValaReferenceType* this_type;
			GeeHashMap* _tmp232;
			GeeHashMap* carg_map;
			ValaCCodeBlock* vblock;
			ValaCCodeIdentifier* _tmp234;
			char* _tmp233;
			ValaCCodeFunctionCall* _tmp235;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp237;
			char* _tmp236;
			ValaCCodeStatement* cstmt;
			_tmp230 = NULL;
			_tmp229 = NULL;
			_tmp231 = NULL;
			vfunc = (_tmp231 = vala_ccode_function_new ((_tmp229 = vala_method_get_cname (m)), (_tmp230 = vala_data_type_get_cname (creturn_type))), (_tmp230 = (g_free (_tmp230), NULL)), (_tmp229 = (g_free (_tmp229), NULL)), _tmp231);
			vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
			this_type = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))));
			_tmp232 = NULL;
			cparam_map = (_tmp232 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), _tmp232);
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			vblock = vala_ccode_block_new ();
			_tmp234 = NULL;
			_tmp233 = NULL;
			_tmp235 = NULL;
			vcall = (_tmp235 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp234 = vala_ccode_identifier_new ((_tmp233 = vala_method_get_real_cname (m)))))), (_tmp234 == NULL ? NULL : (_tmp234 = (vala_ccode_node_unref (_tmp234), NULL))), (_tmp233 = (g_free (_tmp233), NULL)), _tmp235);
			_tmp237 = NULL;
			_tmp236 = NULL;
			vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp237 = vala_ccode_identifier_new ((_tmp236 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))))));
			(_tmp237 == NULL ? NULL : (_tmp237 = (vala_ccode_node_unref (_tmp237), NULL)));
			_tmp236 = (g_free (_tmp236), NULL);
			vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, in_gtypeinstance_creation_method, GEE_MAP (cparam_map), vfunc, NULL, GEE_MAP (carg_map), vcall);
			cstmt = VALA_CCODE_STATEMENT (vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)));
			vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
			if (visible) {
				ValaCCodeFunction* _tmp238;
				_tmp238 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp238 = vala_ccode_function_copy (vfunc))));
				(_tmp238 == NULL ? NULL : (_tmp238 = (vala_ccode_node_unref (_tmp238), NULL)));
			} else {
				ValaCCodeFunction* _tmp239;
				vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp239 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp239 = vala_ccode_function_copy (vfunc))));
				(_tmp239 == NULL ? NULL : (_tmp239 = (vala_ccode_node_unref (_tmp239), NULL)));
			}
			vala_ccode_function_set_block (vfunc, vblock);
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vfunc));
			(vfunc == NULL ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL)));
			(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
			(vblock == NULL ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL)));
			(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
			(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
		}
		_tmp240 = NULL;
		if ((_tmp241 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp240 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0), (_tmp240 == NULL ? NULL : (_tmp240 = (gee_collection_object_unref (_tmp240), NULL))), _tmp241)) {
			ValaCCodeIdentifier* _tmp243;
			ValaCCodeIdentifier* _tmp242;
			ValaCCodeBinaryExpression* _tmp244;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp247;
			ValaCCodeUnaryExpression* _tmp246;
			ValaCCodeIdentifier* _tmp245;
			ValaCCodeIdentifier* _tmp248;
			ValaCCodeFunctionCall* _tmp249;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp252;
			ValaCCodeMemberAccess* _tmp251;
			ValaCCodeIdentifier* _tmp250;
			ValaCCodeExpressionStatement* _tmp253;
			ValaCCodeWhileStatement* _tmp254;
			ValaCCodeIdentifier* _tmp255;
			ValaCCodeFunctionCall* _tmp256;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp257;
			ValaCCodeExpressionStatement* _tmp258;
			_tmp243 = NULL;
			_tmp242 = NULL;
			_tmp244 = NULL;
			ccond = (_tmp244 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp242 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp243 = vala_ccode_identifier_new ("__params")))), (_tmp243 == NULL ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL))), (_tmp242 == NULL ? NULL : (_tmp242 = (vala_ccode_node_unref (_tmp242), NULL))), _tmp244);
			cdofreeparam = vala_ccode_block_new ();
			_tmp247 = NULL;
			_tmp246 = NULL;
			_tmp245 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp247 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp246 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp245 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp247 == NULL ? NULL : (_tmp247 = (vala_ccode_node_unref (_tmp247), NULL)));
			(_tmp246 == NULL ? NULL : (_tmp246 = (vala_ccode_node_unref (_tmp246), NULL)));
			(_tmp245 == NULL ? NULL : (_tmp245 = (vala_ccode_node_unref (_tmp245), NULL)));
			_tmp248 = NULL;
			_tmp249 = NULL;
			cunsetcall = (_tmp249 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp248 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp248 == NULL ? NULL : (_tmp248 = (vala_ccode_node_unref (_tmp248), NULL))), _tmp249);
			_tmp252 = NULL;
			_tmp251 = NULL;
			_tmp250 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp252 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp251 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp250 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp252 == NULL ? NULL : (_tmp252 = (vala_ccode_node_unref (_tmp252), NULL)));
			(_tmp251 == NULL ? NULL : (_tmp251 = (vala_ccode_node_unref (_tmp251), NULL)));
			(_tmp250 == NULL ? NULL : (_tmp250 = (vala_ccode_node_unref (_tmp250), NULL)));
			_tmp253 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp253 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp253 == NULL ? NULL : (_tmp253 = (vala_ccode_node_unref (_tmp253), NULL)));
			_tmp254 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp254 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp254 == NULL ? NULL : (_tmp254 = (vala_ccode_node_unref (_tmp254), NULL)));
			_tmp255 = NULL;
			_tmp256 = NULL;
			cfreeparams = (_tmp256 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp255 = vala_ccode_identifier_new ("g_free")))), (_tmp255 == NULL ? NULL : (_tmp255 = (vala_ccode_node_unref (_tmp255), NULL))), _tmp256);
			_tmp257 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp257 = vala_ccode_identifier_new ("__params"))));
			(_tmp257 == NULL ? NULL : (_tmp257 = (vala_ccode_node_unref (_tmp257), NULL)));
			_tmp258 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp258 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp258 == NULL ? NULL : (_tmp258 = (vala_ccode_node_unref (_tmp258), NULL)));
			(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (vala_ccode_node_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (vala_ccode_node_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (vala_ccode_node_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
			ValaCCodeExpression* cresult;
			char* _tmp259;
			gboolean _tmp260;
			ValaCCodeReturnStatement* creturn;
			cresult = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self"));
			_tmp259 = NULL;
			if ((_tmp260 = (_tmp259 = vala_ccode_method_binding_get_custom_creturn_type (self)) != NULL, (_tmp259 = (g_free (_tmp259), NULL)), _tmp260)) {
				ValaCCodeExpression* _tmp262;
				char* _tmp261;
				_tmp262 = NULL;
				_tmp261 = NULL;
				cresult = (_tmp262 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cresult, (_tmp261 = vala_ccode_method_binding_get_custom_creturn_type (self)))), (cresult == NULL ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL))), _tmp262);
				_tmp261 = (g_free (_tmp261), NULL);
			}
			creturn = vala_ccode_return_statement_new (NULL);
			vala_ccode_return_statement_set_return_expression (creturn, cresult);
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (creturn));
			(cresult == NULL ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL)));
			(creturn == NULL ? NULL : (creturn = (vala_ccode_node_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_method_binding_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp263;
		ValaCCodeFormalParameter* _tmp264;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp270;
		ValaCCodeIdentifier* _tmp269;
		ValaCCodeExpressionStatement* _tmp271;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp272;
		ValaCCodeFunctionCall* _tmp273;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (VALA_CCODE_NODE (cmain), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		_tmp263 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp263 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp263 == NULL ? NULL : (_tmp263 = (vala_ccode_node_unref (_tmp263), NULL)));
		_tmp264 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp264 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp264 == NULL ? NULL : (_tmp264 = (vala_ccode_node_unref (_tmp264), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context)) {
			ValaCCodeIdentifier* _tmp265;
			ValaCCodeFunctionCall* _tmp266;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp267;
			ValaCCodeExpressionStatement* _tmp268;
			_tmp265 = NULL;
			_tmp266 = NULL;
			thread_init_call = (_tmp266 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp265 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp265 == NULL ? NULL : (_tmp265 = (vala_ccode_node_unref (_tmp265), NULL))), _tmp266);
			vala_ccode_node_set_line (VALA_CCODE_NODE (thread_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			_tmp267 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp267 = vala_ccode_constant_new ("NULL"))));
			(_tmp267 == NULL ? NULL : (_tmp267 = (vala_ccode_node_unref (_tmp267), NULL)));
			_tmp268 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp268 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp268 == NULL ? NULL : (_tmp268 = (vala_ccode_node_unref (_tmp268), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (vala_ccode_node_unref (thread_init_call), NULL)));
		}
		_tmp270 = NULL;
		_tmp269 = NULL;
		_tmp271 = NULL;
		type_init_call = (_tmp271 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp270 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp269 = vala_ccode_identifier_new ("g_type_init"))))))), (_tmp270 == NULL ? NULL : (_tmp270 = (vala_ccode_node_unref (_tmp270), NULL))), (_tmp269 == NULL ? NULL : (_tmp269 = (vala_ccode_node_unref (_tmp269), NULL))), _tmp271);
		vala_ccode_node_set_line (VALA_CCODE_NODE (type_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (type_init_call));
		_tmp272 = NULL;
		_tmp273 = NULL;
		main_call = (_tmp273 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp272 = vala_ccode_identifier_new (vala_ccode_function_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))))), (_tmp272 == NULL ? NULL : (_tmp272 = (vala_ccode_node_unref (_tmp272), NULL))), _tmp273);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp274;
			ValaCCodeIdentifier* _tmp275;
			_tmp274 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp274 = vala_ccode_identifier_new ("argv"))));
			(_tmp274 == NULL ? NULL : (_tmp274 = (vala_ccode_node_unref (_tmp274), NULL)));
			_tmp275 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp275 = vala_ccode_identifier_new ("argc"))));
			(_tmp275 == NULL ? NULL : (_tmp275 = (vala_ccode_node_unref (_tmp275), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp276;
			ValaCCodeReturnStatement* _tmp277;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			_tmp276 = NULL;
			_tmp277 = NULL;
			ret_stmt = (_tmp277 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp276 = vala_ccode_constant_new ("0")))), (_tmp276 == NULL ? NULL : (_tmp276 = (vala_ccode_node_unref (_tmp276), NULL))), _tmp277);
			vala_ccode_node_set_line (VALA_CCODE_NODE (ret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (ret_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (vala_ccode_node_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (vala_ccode_node_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (vala_ccode_node_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (vala_ccode_node_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (vala_ccode_node_unref (main_call), NULL)));
	}
	(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	(old_method == NULL ? NULL : (old_method = (vala_code_node_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)));
}


void vala_ccode_method_binding_generate_cparameters (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall) {
	GeeList* _tmp44;
	gboolean _tmp45;
	gint last_pos;
	gint min_pos;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_METHOD (m));
	g_return_if_fail (VALA_IS_DATA_TYPE (creturn_type));
	g_return_if_fail (GEE_IS_MAP (cparam_map));
	g_return_if_fail (VALA_IS_CCODE_FUNCTION (func));
	g_return_if_fail (vdeclarator == NULL || VALA_IS_CCODE_FUNCTION_DECLARATOR (vdeclarator));
	g_return_if_fail (carg_map == NULL || GEE_IS_MAP (carg_map));
	g_return_if_fail (vcall == NULL || VALA_IS_CCODE_FUNCTION_CALL (vcall));
	if (in_gtypeinstance_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					ValaCCodeFormalParameter* _tmp2;
					char* _tmp1;
					char* _tmp0;
					ValaCCodeFormalParameter* _tmp5;
					char* _tmp4;
					char* _tmp3;
					ValaCCodeFormalParameter* _tmp8;
					char* _tmp7;
					char* _tmp6;
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.01, FALSE)), (_tmp2 = vala_ccode_formal_parameter_new ((_tmp1 = g_strdup_printf ("%s_type", (_tmp0 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GType")));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					_tmp0 = (g_free (_tmp0), NULL);
					_tmp5 = NULL;
					_tmp4 = NULL;
					_tmp3 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.02, FALSE)), (_tmp5 = vala_ccode_formal_parameter_new ((_tmp4 = g_strdup_printf ("%s_dup_func", (_tmp3 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
					_tmp4 = (g_free (_tmp4), NULL);
					_tmp3 = (g_free (_tmp3), NULL);
					_tmp8 = NULL;
					_tmp7 = NULL;
					_tmp6 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.03, FALSE)), (_tmp8 = vala_ccode_formal_parameter_new ((_tmp7 = g_strdup_printf ("%s_destroy_func", (_tmp6 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GDestroyNotify")));
					(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
					_tmp7 = (g_free (_tmp7), NULL);
					_tmp6 = (g_free (_tmp6), NULL);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp11;
						char* _tmp10;
						char* _tmp9;
						ValaCCodeIdentifier* _tmp14;
						char* _tmp13;
						char* _tmp12;
						ValaCCodeIdentifier* _tmp17;
						char* _tmp16;
						char* _tmp15;
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.01, FALSE)), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = g_strdup_printf ("%s_type", (_tmp9 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))))));
						(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
						_tmp10 = (g_free (_tmp10), NULL);
						_tmp9 = (g_free (_tmp9), NULL);
						_tmp14 = NULL;
						_tmp13 = NULL;
						_tmp12 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.02, FALSE)), VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = g_strdup_printf ("%s_dup_func", (_tmp12 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))))));
						(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
						_tmp13 = (g_free (_tmp13), NULL);
						_tmp12 = (g_free (_tmp12), NULL);
						_tmp17 = NULL;
						_tmp16 = NULL;
						_tmp15 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.03, FALSE)), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = g_strdup_printf ("%s_destroy_func", (_tmp15 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
						_tmp16 = (g_free (_tmp16), NULL);
						_tmp15 = (g_free (_tmp15), NULL);
					}
					type_param_index++;
					(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
		}
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp18;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp18 = NULL;
					array_type = (_tmp18 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp19;
						_tmp19 = NULL;
						length_ctype = (_tmp19 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp19);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp20;
							ValaCCodeFormalParameter* _tmp21;
							ValaCCodeFormalParameter* cparam;
							_tmp20 = NULL;
							_tmp21 = NULL;
							cparam = (_tmp21 = vala_ccode_formal_parameter_new ((_tmp20 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							if (carg_map != NULL) {
								ValaCCodeIdentifier* _tmp22;
								_tmp22 = NULL;
								gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
							}
							(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp23;
					_tmp23 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				}
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaDelegateType* _tmp24;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp25;
					ValaDelegate* d;
					_tmp24 = NULL;
					deleg_type = (_tmp24 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
					_tmp25 = NULL;
					d = (_tmp25 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp25 == NULL ? NULL : vala_code_node_ref (_tmp25)));
					if (vala_delegate_get_has_target (d)) {
						char* _tmp26;
						ValaCCodeFormalParameter* _tmp27;
						ValaCCodeFormalParameter* cparam;
						_tmp26 = NULL;
						_tmp27 = NULL;
						cparam = (_tmp27 = vala_ccode_formal_parameter_new ((_tmp26 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp28;
							_tmp28 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
							(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
						}
						if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
							ValaCCodeFormalParameter* _tmp30;
							char* _tmp29;
							_tmp30 = NULL;
							_tmp29 = NULL;
							cparam = (_tmp30 = vala_ccode_formal_parameter_new ((_tmp29 = vala_ccode_generator_get_delegate_target_destroy_notify_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "GDestroyNotify"), (cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL))), _tmp30);
							_tmp29 = (g_free (_tmp29), NULL);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
							if (carg_map != NULL) {
								ValaCCodeIdentifier* _tmp31;
								_tmp31 = NULL;
								gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
							}
						}
						(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
				} else {
					if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						char* _tmp32;
						ValaCCodeFormalParameter* _tmp33;
						ValaCCodeFormalParameter* cparam;
						_tmp32 = NULL;
						_tmp33 = NULL;
						cparam = (_tmp33 = vala_ccode_formal_parameter_new ((_tmp32 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp32 = (g_free (_tmp32), NULL)), _tmp33);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp34;
							_tmp34 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
							(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
						}
						(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
		ValaArrayType* _tmp35;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp35 = NULL;
		array_type = (_tmp35 = VALA_ARRAY_TYPE (creturn_type), (_tmp35 == NULL ? NULL : vala_code_node_ref (_tmp35)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp36;
				ValaCCodeFormalParameter* _tmp37;
				ValaCCodeFormalParameter* cparam;
				_tmp36 = NULL;
				_tmp37 = NULL;
				cparam = (_tmp37 = vala_ccode_formal_parameter_new ((_tmp36 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp36 = (g_free (_tmp36), NULL)), _tmp37);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp38;
					_tmp38 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
				}
				(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
			ValaDelegateType* _tmp39;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp40;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp39 = NULL;
			deleg_type = (_tmp39 = VALA_DELEGATE_TYPE (creturn_type), (_tmp39 == NULL ? NULL : vala_code_node_ref (_tmp39)));
			_tmp40 = NULL;
			d = (_tmp40 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp41;
				ValaCCodeFormalParameter* _tmp42;
				ValaCCodeFormalParameter* cparam;
				_tmp41 = NULL;
				_tmp42 = NULL;
				cparam = (_tmp42 = vala_ccode_formal_parameter_new ((_tmp41 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp41 = (g_free (_tmp41), NULL)), _tmp42);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp43;
					_tmp43 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
				}
				(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	_tmp44 = NULL;
	if ((_tmp45 = gee_collection_get_size (GEE_COLLECTION ((_tmp44 = vala_code_node_get_error_types (VALA_CODE_NODE (m))))) > 0, (_tmp44 == NULL ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL))), _tmp45)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), FALSE)), cparam);
		if (carg_map != NULL) {
			ValaCCodeIdentifier* _tmp46;
			_tmp46 = NULL;
			gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
			(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
		}
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp47;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (cparam_map);
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp47 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp47 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
		(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp48;
			_tmp48 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, (_tmp48 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
		}
		if (vcall != NULL) {
			ValaCCodeExpression* _tmp49;
			_tmp49 = NULL;
			vala_ccode_function_call_add_argument (vcall, (_tmp49 = ((ValaCCodeExpression*) (gee_map_get (carg_map, GINT_TO_POINTER (min_pos))))));
			(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
		}
		last_pos = min_pos;
	}
}


static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_generator_create_type_check_statement (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CODE_NODE (m), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (precondition), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (precondition))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeStatement* _tmp3;
			ValaCCodeStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("0"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp4);
		}
		(cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return (_tmp5 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp5);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (postcondition), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_assert")))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (postcondition))));
	_tmp2 = NULL;
	return (_tmp2 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert))), (cassert == NULL ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL))), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeList* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp7;
	ValaArrayType* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (VALA_SYMBOL (m)) == NULL || _vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (m)), "main") != 0) {
		/* method must be called "main"*/
		return FALSE;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* method must be static*/
		return FALSE;
	}
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type)) {
			(*return_value) = TRUE;
		} else {
			/* return type must be void or int*/
			return FALSE;
		}
	}
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (GEE_COLLECTION (params)) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (GEE_COLLECTION (params)) > 1) {
		gboolean _tmp4;
		/* method must not have more than one parameter*/
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp4);
	}
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		gboolean _tmp5;
		/* parameter must not be an out parameter*/
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp5);
	}
	if (!(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
		gboolean _tmp6;
		/* parameter must be an array*/
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp6);
	}
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
		gboolean _tmp8;
		/* parameter must be an array of strings*/
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp8);
	}
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	gboolean chain_up;
	ValaCreationMethod* cm;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp21;
	char* _tmp20;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	chain_up = FALSE;
	cm = NULL;
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCreationMethod* _tmp3;
		ValaCreationMethod* _tmp2;
		ValaMethod* _tmp1;
		GeeList* _tmp4;
		gboolean _tmp5;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cm = (_tmp3 = (_tmp2 = (_tmp1 = vala_class_get_default_construction_method (vala_class_get_base_class (cl)), (VALA_IS_CREATION_METHOD (_tmp1) ? ((ValaCreationMethod*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL))), _tmp3);
		_tmp4 = NULL;
		if ((_tmp5 = cm != NULL && gee_collection_get_size (GEE_COLLECTION ((_tmp4 = vala_method_get_parameters (VALA_METHOD (cm))))) == 0 && vala_method_get_has_construct_function (VALA_METHOD (cm)), (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5)) {
			if (!has_params) {
				chain_up = TRUE;
			}
		}
	}
	if (!has_params && !chain_up && VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) {
	}
	/* possibly report warning or error about missing base call*/
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	if (chain_up) {
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeCastExpression* _tmp12;
		char* _tmp11;
		char* _tmp10;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp8 = NULL;
		ccall = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_method_get_real_cname (VALA_METHOD (cm))))))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("object_type"))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp11 = g_strdup_printf ("%s*", (_tmp10 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		_tmp11 = (g_free (_tmp11), NULL);
		_tmp10 = (g_free (_tmp10), NULL);
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp13;
		ValaCCodeFunctionCall* _tmp14;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp15;
		_tmp13 = NULL;
		_tmp14 = NULL;
		ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
		_tmp15 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("object_type"))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		if (has_params) {
			ValaCCodeConstant* _tmp16;
			ValaCCodeConstant* _tmp17;
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("__params_it - __params"))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("__params"))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		} else {
			ValaCCodeConstant* _tmp18;
			ValaCCodeConstant* _tmp19;
			_tmp18 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("0"))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
			_tmp19 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("NULL"))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		}
		vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	}
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp22 = NULL;
	cdeclaration = (_tmp22 = vala_ccode_declaration_new ((_tmp21 = g_strdup_printf ("%s *", (_tmp20 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp21 = (g_free (_tmp21), NULL)), (_tmp20 = (g_free (_tmp20), NULL)), _tmp22);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL)));
}


static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl) {
	ValaClass* _tmp0;
	ValaClass* fundamental_class;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	_tmp0 = NULL;
	fundamental_class = (_tmp0 = cl, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	while (fundamental_class != NULL && vala_class_get_base_class (fundamental_class) != NULL) {
		ValaClass* _tmp2;
		ValaClass* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		fundamental_class = (_tmp2 = (_tmp1 = vala_class_get_base_class (fundamental_class), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (fundamental_class == NULL ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL))), _tmp2);
	}
	return fundamental_class;
}


ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	return self->priv->_method;
}


void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (vala_code_node_unref (self->priv->_method), NULL))), _tmp2);
}


gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self) {
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1);
}


static void vala_ccode_method_binding_class_init (ValaCCodeMethodBindingClass * klass) {
	vala_ccode_method_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_ccode_method_binding_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeMethodBindingPrivate));
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_method_binding_real_emit;
}


static void vala_ccode_method_binding_instance_init (ValaCCodeMethodBinding * self) {
	self->priv = VALA_CCODE_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_method_binding_finalize (ValaCodeBinding* obj) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (obj);
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (vala_code_node_unref (self->priv->_method), NULL)));
	VALA_CODE_BINDING_CLASS (vala_ccode_method_binding_parent_class)->finalize (obj);
}


GType vala_ccode_method_binding_get_type (void) {
	static GType vala_ccode_method_binding_type_id = 0;
	if (vala_ccode_method_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodBinding), 0, (GInstanceInitFunc) vala_ccode_method_binding_instance_init, NULL };
		vala_ccode_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_method_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




