/* valapointertype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valapointertype.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>
#include <vala/valasemanticanalyzer.h>




struct _ValaPointerTypePrivate {
	ValaDataType* _base_type;
};

#define VALA_POINTER_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POINTER_TYPE, ValaPointerTypePrivate))
enum  {
	VALA_POINTER_TYPE_DUMMY_PROPERTY
};
static char* vala_pointer_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static char* vala_pointer_type_real_get_cname (ValaDataType* base);
static ValaDataType* vala_pointer_type_real_copy (ValaDataType* base);
static gboolean vala_pointer_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static ValaSymbol* vala_pointer_type_real_get_pointer_member (ValaDataType* base, const char* member_name);
static GeeList* vala_pointer_type_real_get_symbols (ValaDataType* base);
static char* vala_pointer_type_real_get_type_id (ValaDataType* base);
static void vala_pointer_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_pointer_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_pointer_type_real_is_disposable (ValaDataType* base);
static gpointer vala_pointer_type_parent_class = NULL;
static void vala_pointer_type_finalize (ValaCodeNode* obj);



ValaPointerType* vala_pointer_type_construct (GType object_type, ValaDataType* base_type, ValaSourceReference* source_reference) {
	ValaPointerType* self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (base_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaPointerType*) (g_type_create_instance (object_type)));
	vala_pointer_type_set_base_type (self, base_type);
	vala_data_type_set_nullable (VALA_DATA_TYPE (self), TRUE);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


ValaPointerType* vala_pointer_type_new (ValaDataType* base_type, ValaSourceReference* source_reference) {
	return vala_pointer_type_construct (VALA_TYPE_POINTER_TYPE, base_type, source_reference);
}


static char* vala_pointer_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaPointerType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_POINTER_TYPE (base);
	g_return_val_if_fail (scope == NULL || VALA_IS_SCOPE (scope), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat ((_tmp0 = vala_data_type_to_qualified_string (vala_pointer_type_get_base_type (self), scope)), "*", NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_pointer_type_real_get_cname (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (self)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (self)))) {
		return vala_data_type_get_cname (vala_pointer_type_get_base_type (self));
	} else {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strconcat ((_tmp1 = vala_data_type_get_cname (vala_pointer_type_get_base_type (self))), "*", NULL), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	}
}


static ValaDataType* vala_pointer_type_real_copy (ValaDataType* base) {
	ValaPointerType * self;
	ValaDataType* _tmp0;
	ValaDataType* _tmp1;
	self = VALA_POINTER_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = VALA_DATA_TYPE (vala_pointer_type_new ((_tmp0 = vala_data_type_copy (vala_pointer_type_get_base_type (self))), NULL)), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1);
}


static gboolean vala_pointer_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaPointerType * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = VALA_POINTER_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_POINTER_TYPE (target_type) || (vala_data_type_get_data_type (target_type) != NULL && (_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (vala_data_type_get_data_type (target_type)), "PointerType")) != NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1)) {
		return TRUE;
	}
	/* temporarily ignore type parameters */
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		return TRUE;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (vala_pointer_type_get_base_type (self))) {
		/* Object* is compatible with Object if Object is a reference type*/
		return vala_data_type_compatible (vala_pointer_type_get_base_type (self), target_type);
	}
	return FALSE;
}


static ValaSymbol* vala_pointer_type_real_get_pointer_member (ValaDataType* base, const char* member_name) {
	ValaPointerType * self;
	ValaSymbol* _tmp0;
	ValaSymbol* base_symbol;
	ValaSymbol* _tmp2;
	self = VALA_POINTER_TYPE (base);
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0 = NULL;
	base_symbol = (_tmp0 = VALA_SYMBOL (vala_data_type_get_data_type (vala_pointer_type_get_base_type (self))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (base_symbol == NULL) {
		ValaSymbol* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = NULL, (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp1);
	}
	_tmp2 = NULL;
	return (_tmp2 = vala_semantic_analyzer_symbol_lookup_inherited (base_symbol, member_name), (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp2);
}


static GeeList* vala_pointer_type_real_get_symbols (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	return vala_data_type_get_symbols (vala_pointer_type_get_base_type (self));
}


static char* vala_pointer_type_real_get_type_id (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	return g_strdup ("G_TYPE_POINTER");
}


static void vala_pointer_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_pointer_type_get_base_type (self)), visitor);
}


static void vala_pointer_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	g_return_if_fail (VALA_IS_DATA_TYPE (old_type));
	g_return_if_fail (VALA_IS_DATA_TYPE (new_type));
	if (vala_pointer_type_get_base_type (self) == old_type) {
		vala_pointer_type_set_base_type (self, new_type);
	}
}


static gboolean vala_pointer_type_real_is_disposable (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	return FALSE;
}


ValaDataType* vala_pointer_type_get_base_type (ValaPointerType* self) {
	g_return_val_if_fail (VALA_IS_POINTER_TYPE (self), NULL);
	return self->priv->_base_type;
}


void vala_pointer_type_set_base_type (ValaPointerType* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_POINTER_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_base_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_base_type == NULL ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_base_type), VALA_CODE_NODE (self));
}


static void vala_pointer_type_class_init (ValaPointerTypeClass * klass) {
	vala_pointer_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_pointer_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaPointerTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_pointer_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_pointer_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_pointer_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_pointer_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->get_pointer_member = vala_pointer_type_real_get_pointer_member;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_pointer_type_real_get_symbols;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_pointer_type_real_get_type_id;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_pointer_type_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_pointer_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->is_disposable = vala_pointer_type_real_is_disposable;
}


static void vala_pointer_type_instance_init (ValaPointerType * self) {
	self->priv = VALA_POINTER_TYPE_GET_PRIVATE (self);
}


static void vala_pointer_type_finalize (ValaCodeNode* obj) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (obj);
	(self->priv->_base_type == NULL ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL)));
	VALA_CODE_NODE_CLASS (vala_pointer_type_parent_class)->finalize (obj);
}


GType vala_pointer_type_get_type (void) {
	static GType vala_pointer_type_type_id = 0;
	if (vala_pointer_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPointerTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_pointer_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPointerType), 0, (GInstanceInitFunc) vala_pointer_type_instance_init, NULL };
		vala_pointer_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaPointerType", &g_define_type_info, 0);
	}
	return vala_pointer_type_type_id;
}




