/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp282_ = FALSE;
	ValaMethod* _tmp283_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp635_ = FALSE;
	ValaMethod* _tmp636_;
	ValaMethod* _tmp688_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp884_;
	ValaIterator* _tmp885_;
	ValaIterator* _tmp1231_;
	gboolean _tmp1241_ = FALSE;
	gboolean _tmp1242_ = FALSE;
	ValaMethod* _tmp1243_;
	gboolean _tmp1370_ = FALSE;
	ValaDelegate* _tmp1371_;
	gboolean _tmp1470_ = FALSE;
	ValaMethod* _tmp1471_;
	gboolean _tmp1487_;
	gboolean _tmp1488_;
	gboolean _tmp1503_;
	ValaDataType* _tmp1528_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1552_;
	ValaDataType* _tmp1553_;
	ValaDataType* _tmp1554_;
	gboolean _tmp1555_;
	gboolean _tmp1556_ = FALSE;
	ValaDataType* _tmp1557_;
	ValaCCodeFunctionCall* _tmp1586_;
	ValaCCodeFunctionCall* _tmp1587_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1588_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1603_;
	ValaCCodeFunctionCall* _tmp1604_;
	ValaCCodeFunctionCall* _tmp1628_;
	gboolean _tmp1652_;
	gboolean _tmp1653_;
	gboolean _tmp1679_;
	gboolean _tmp1680_;
	gboolean _tmp1710_;
	gboolean _tmp1716_ = FALSE;
	gboolean _tmp1717_ = FALSE;
	ValaMethod* _tmp1718_;
	gboolean _tmp1756_ = FALSE;
	gboolean _tmp1757_ = FALSE;
	ValaMethod* _tmp1758_;
	ValaMethod* _tmp1777_;
	gboolean _tmp1894_ = FALSE;
	ValaCodeNode* _tmp1895_;
	ValaCodeNode* _tmp1896_;
	ValaList* _tmp1979_;
	ValaIterator* _tmp1980_;
	gboolean _tmp2065_ = FALSE;
	gboolean _tmp2066_ = FALSE;
	ValaMethod* _tmp2067_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeMemberAccess* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = vala_ccode_identifier_new ("_data_");
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp279_, "_res_");
					_tmp281_ = _tmp280_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp281_);
					_vala_ccode_node_unref0 (_tmp281_);
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
		}
	}
	_tmp283_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp284_;
		ValaSymbol* _tmp285_;
		ValaSymbol* _tmp286_;
		_tmp284_ = m;
		_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp282_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS);
	} else {
		_tmp282_ = FALSE;
	}
	if (_tmp282_) {
		ValaMethod* _tmp287_;
		ValaSymbol* _tmp288_;
		ValaSymbol* _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		ValaClass* _tmp295_;
		ValaClass* _tmp296_;
		gboolean _tmp297_;
		gboolean _tmp298_;
		_tmp287_ = m;
		_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass));
		_tmp291_ = _tmp290_;
		if (!_tmp291_) {
			ValaCCodeFunctionCall* _tmp292_;
			ValaCCodeExpression* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			_tmp292_ = ccall;
			_tmp293_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp294_ = _tmp293_;
			vala_ccode_function_call_add_argument (_tmp292_, _tmp294_);
			_vala_ccode_node_unref0 (_tmp294_);
		}
		_tmp295_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_class_get_is_compact (_tmp296_);
		_tmp298_ = _tmp297_;
		if (!_tmp298_) {
			ValaClass* _tmp299_;
			ValaClass* _tmp300_;
			ValaMethod* _tmp301_;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			_tmp299_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp300_ = _tmp299_;
			_tmp301_ = m;
			_tmp302_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp301_);
			_tmp303_ = _tmp302_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp303_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp304_;
					ValaClass* _tmp305_;
					ValaList* _tmp306_;
					gint _base_type_size = 0;
					ValaList* _tmp307_;
					gint _tmp308_;
					gint _tmp309_;
					gint _base_type_index = 0;
					_tmp304_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_class_get_base_types (_tmp305_);
					_base_type_list = _tmp306_;
					_tmp307_ = _base_type_list;
					_tmp308_ = vala_collection_get_size ((ValaCollection*) _tmp307_);
					_tmp309_ = _tmp308_;
					_base_type_size = _tmp309_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp310_;
						gint _tmp311_;
						gint _tmp312_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp313_;
						gint _tmp314_;
						gpointer _tmp315_;
						ValaDataType* _tmp316_;
						ValaTypeSymbol* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						_tmp310_ = _base_type_index;
						_base_type_index = _tmp310_ + 1;
						_tmp311_ = _base_type_index;
						_tmp312_ = _base_type_size;
						if (!(_tmp311_ < _tmp312_)) {
							break;
						}
						_tmp313_ = _base_type_list;
						_tmp314_ = _base_type_index;
						_tmp315_ = vala_list_get (_tmp313_, _tmp314_);
						base_type = (ValaDataType*) _tmp315_;
						_tmp316_ = base_type;
						_tmp317_ = vala_data_type_get_data_type (_tmp316_);
						_tmp318_ = _tmp317_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp319_;
							gchar* _tmp320_;
							gchar* _tmp321_;
							gboolean _tmp322_;
							ValaHashMap* _tmp327_;
							ValaDataType* _tmp328_;
							ValaList* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							type_parameters = NULL;
							_tmp319_ = m;
							_tmp320_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp319_);
							_tmp321_ = _tmp320_;
							_tmp322_ = g_strcmp0 (_tmp321_, "g_object_new") == 0;
							_g_free0 (_tmp321_);
							if (_tmp322_) {
								ValaDataType* _tmp323_;
								ValaTypeSymbol* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaList* _tmp326_;
								_tmp323_ = base_type;
								_tmp324_ = vala_data_type_get_data_type (_tmp323_);
								_tmp325_ = _tmp324_;
								_tmp326_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp326_;
							}
							_tmp327_ = in_arg_map;
							_tmp328_ = base_type;
							_tmp329_ = vala_data_type_get_type_arguments (_tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp327_, _tmp330_, (ValaCodeNode*) expr, TRUE, _tmp331_);
							_vala_iterable_unref0 (_tmp330_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp332_;
				ValaSymbol* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaClass* _tmp335_;
				type_param_index = 0;
				_tmp332_ = m;
				_tmp333_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp335_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp336_;
					ValaList* _tmp337_;
					gint _type_param_size = 0;
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					gint _type_param_index = 0;
					_tmp336_ = cl;
					_tmp337_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp336_);
					_type_param_list = _tmp337_;
					_tmp338_ = _type_param_list;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					_type_param_size = _tmp340_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp341_;
						gint _tmp342_;
						gint _tmp343_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp344_;
						gint _tmp345_;
						gpointer _tmp346_;
						ValaHashMap* _tmp347_;
						gint _tmp348_;
						ValaTypeParameter* _tmp349_;
						const gchar* _tmp350_;
						const gchar* _tmp351_;
						gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						ValaCCodeIdentifier* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaHashMap* _tmp358_;
						gint _tmp359_;
						ValaTypeParameter* _tmp360_;
						const gchar* _tmp361_;
						const gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						ValaCCodeIdentifier* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaHashMap* _tmp369_;
						gint _tmp370_;
						ValaTypeParameter* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						ValaCCodeIdentifier* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						gint _tmp380_;
						_tmp341_ = _type_param_index;
						_type_param_index = _tmp341_ + 1;
						_tmp342_ = _type_param_index;
						_tmp343_ = _type_param_size;
						if (!(_tmp342_ < _tmp343_)) {
							break;
						}
						_tmp344_ = _type_param_list;
						_tmp345_ = _type_param_index;
						_tmp346_ = vala_list_get (_tmp344_, _tmp345_);
						type_param = (ValaTypeParameter*) _tmp346_;
						_tmp347_ = in_arg_map;
						_tmp348_ = type_param_index;
						_tmp349_ = type_param;
						_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = g_utf8_strdown (_tmp351_, (gssize) -1);
						_tmp353_ = _tmp352_;
						_tmp354_ = g_strdup_printf ("%s_type", _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = vala_ccode_identifier_new (_tmp355_);
						_tmp357_ = _tmp356_;
						vala_map_set ((ValaMap*) _tmp347_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp348_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp357_);
						_vala_ccode_node_unref0 (_tmp357_);
						_g_free0 (_tmp355_);
						_g_free0 (_tmp353_);
						_tmp358_ = in_arg_map;
						_tmp359_ = type_param_index;
						_tmp360_ = type_param;
						_tmp361_ = vala_symbol_get_name ((ValaSymbol*) _tmp360_);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_utf8_strdown (_tmp362_, (gssize) -1);
						_tmp364_ = _tmp363_;
						_tmp365_ = g_strdup_printf ("%s_dup_func", _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = vala_ccode_identifier_new (_tmp366_);
						_tmp368_ = _tmp367_;
						vala_map_set ((ValaMap*) _tmp358_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp359_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp368_);
						_vala_ccode_node_unref0 (_tmp368_);
						_g_free0 (_tmp366_);
						_g_free0 (_tmp364_);
						_tmp369_ = in_arg_map;
						_tmp370_ = type_param_index;
						_tmp371_ = type_param;
						_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_utf8_strdown (_tmp373_, (gssize) -1);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("%s_destroy_func", _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_ccode_identifier_new (_tmp377_);
						_tmp379_ = _tmp378_;
						vala_map_set ((ValaMap*) _tmp369_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp370_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp379_);
						_vala_ccode_node_unref0 (_tmp379_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						_tmp380_ = type_param_index;
						type_param_index = _tmp380_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp381_;
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			_tmp381_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp382_ = _tmp381_;
			_tmp383_ = vala_class_get_base_class (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp384_ == _tmp385_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp386_;
				ValaClass* _tmp387_;
				gchar* _tmp388_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp389_;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				const gchar* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				gchar* _tmp396_;
				gchar* _tmp397_;
				ValaCCodeConstant* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeVariableDeclarator* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeFunction* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeDeclaration* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				ValaCCodeIdentifier* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeUnaryExpression* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp410_;
				ValaCCodeIdentifier* _tmp411_;
				ValaCCodeFunctionCall* _tmp412_;
				ValaCCodeFunctionCall* _tmp413_;
				ValaCCodeFunctionCall* _tmp414_;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				gchar* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				_tmp386_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp387_, NULL);
				class_prefix = _tmp388_;
				_tmp389_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp389_;
				_tmp390_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp390_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp391_ = funcs;
				_tmp392_ = class_prefix;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp392_, _tmp393_, _tmp394_, _tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_ccode_constant_new (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp399_, NULL);
				_tmp401_ = _tmp400_;
				vala_ccode_declaration_add_declarator (_tmp391_, (ValaCCodeDeclarator*) _tmp401_);
				_vala_ccode_node_unref0 (_tmp401_);
				_vala_ccode_node_unref0 (_tmp399_);
				_g_free0 (_tmp397_);
				_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp403_ = _tmp402_;
				_tmp404_ = funcs;
				vala_ccode_function_add_statement (_tmp403_, (ValaCCodeNode*) _tmp404_);
				_tmp405_ = ccall;
				_tmp406_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp407_);
				_tmp409_ = _tmp408_;
				vala_ccode_function_call_add_argument (_tmp405_, (ValaCCodeExpression*) _tmp409_);
				_vala_ccode_node_unref0 (_tmp409_);
				_vala_ccode_node_unref0 (_tmp407_);
				_tmp410_ = vala_ccode_identifier_new ("sizeof");
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp411_);
				_tmp413_ = _tmp412_;
				_vala_ccode_node_unref0 (_tmp411_);
				csizeof = _tmp413_;
				_tmp414_ = csizeof;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_name ((ValaCodeNode*) _tmp416_);
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_ccode_identifier_new (_tmp418_);
				_tmp420_ = _tmp419_;
				vala_ccode_function_call_add_argument (_tmp414_, (ValaCCodeExpression*) _tmp420_);
				_vala_ccode_node_unref0 (_tmp420_);
				_g_free0 (_tmp418_);
				_tmp421_ = ccall;
				_tmp422_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp421_, (ValaCCodeExpression*) _tmp422_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp423_ = FALSE;
		ValaMethod* _tmp424_;
		_tmp424_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp424_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp425_;
			ValaSymbol* _tmp426_;
			ValaSymbol* _tmp427_;
			_tmp425_ = m;
			_tmp426_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp425_);
			_tmp427_ = _tmp426_;
			_tmp423_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_STRUCT);
		} else {
			_tmp423_ = FALSE;
		}
		if (_tmp423_) {
			ValaCCodeFunctionCall* _tmp428_;
			ValaCCodeExpression* _tmp429_;
			ValaCCodeExpression* _tmp430_;
			_tmp428_ = ccall;
			_tmp429_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp430_ = _tmp429_;
			vala_ccode_function_call_add_argument (_tmp428_, _tmp430_);
			_vala_ccode_node_unref0 (_tmp430_);
		} else {
			gboolean _tmp431_ = FALSE;
			gboolean _tmp432_ = FALSE;
			gboolean _tmp433_ = FALSE;
			gboolean _tmp434_ = FALSE;
			ValaMethod* _tmp435_;
			_tmp435_ = m;
			if (_tmp435_ != NULL) {
				ValaMethod* _tmp436_;
				ValaList* _tmp437_;
				ValaList* _tmp438_;
				gint _tmp439_;
				gint _tmp440_;
				_tmp436_ = m;
				_tmp437_ = vala_method_get_type_parameters (_tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_collection_get_size ((ValaCollection*) _tmp438_);
				_tmp440_ = _tmp439_;
				_tmp434_ = _tmp440_ > 0;
				_vala_iterable_unref0 (_tmp438_);
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp433_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp433_ = FALSE;
			}
			if (_tmp433_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp432_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp432_ = FALSE;
			}
			if (_tmp432_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp431_ = _tmp443_;
			} else {
				_tmp431_ = FALSE;
			}
			if (_tmp431_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			gboolean _tmp561_;
			gboolean _tmp562_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = vala_method_call_get_is_yield_expression (expr);
			_tmp562_ = _tmp561_;
			if (_tmp562_) {
				ValaHashMap* _tmp563_;
				ValaMethod* _tmp564_;
				ValaCCodeExpression* _tmp565_;
				ValaMethod* _tmp566_;
				_tmp563_ = in_arg_map;
				_tmp564_ = m;
				_tmp565_ = instance;
				vala_map_set ((ValaMap*) _tmp563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp564_), FALSE)), _tmp565_);
				_tmp566_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_)) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
				}
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				const gchar* _tmp572_;
				const gchar* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_member_name (_tmp571_);
				_tmp573_ = _tmp572_;
				if (g_strcmp0 (_tmp573_, "end") != 0) {
					_tmp570_ = TRUE;
				} else {
					ValaMethod* _tmp574_;
					_tmp574_ = m;
					_tmp570_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_);
				}
				if (_tmp570_) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
					_tmp578_ = in_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp581_ = FALSE;
			ValaMethod* _tmp582_;
			_tmp582_ = m;
			if (_tmp582_ != NULL) {
				ValaMethod* _tmp583_;
				ValaMemberBinding _tmp584_;
				ValaMemberBinding _tmp585_;
				_tmp583_ = m;
				_tmp584_ = vala_method_get_binding (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp581_ = _tmp585_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp581_ = FALSE;
			}
			if (_tmp581_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp586_;
				ValaSymbol* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaClass* _tmp589_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp590_;
				gchar* _tmp591_;
				gchar* _tmp592_;
				gchar* _tmp593_;
				gchar* _tmp594_;
				ValaCCodeIdentifier* _tmp595_;
				ValaCCodeIdentifier* _tmp596_;
				ValaCCodeFunctionCall* _tmp597_;
				ValaCCodeFunctionCall* _tmp598_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp599_;
				ValaExpression* _tmp600_;
				ValaExpression* _tmp601_;
				ValaCCodeFunctionCall* _tmp627_;
				ValaCCodeExpression* _tmp628_;
				ValaHashMap* _tmp629_;
				ValaMethod* _tmp630_;
				ValaCCodeFunctionCall* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				_tmp586_ = m;
				_tmp587_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp589_;
				_tmp590_ = cl;
				_tmp591_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp590_, NULL);
				_tmp592_ = _tmp591_;
				_tmp593_ = g_strconcat (_tmp592_, "_CLASS", NULL);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_ccode_identifier_new (_tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp596_);
				_tmp598_ = _tmp597_;
				_vala_ccode_node_unref0 (_tmp596_);
				_g_free0 (_tmp594_);
				_g_free0 (_tmp592_);
				cast = _tmp598_;
				_tmp599_ = ma;
				_tmp600_ = vala_member_access_get_inner (_tmp599_);
				_tmp601_ = _tmp600_;
				if (_tmp601_ == NULL) {
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					gboolean _tmp604_;
					_tmp602_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp603_ = _tmp602_;
					_tmp604_ = _tmp603_ == NULL;
					_vala_code_node_unref0 (_tmp603_);
					if (_tmp604_) {
						ValaCCodeIdentifier* _tmp605_;
						_tmp605_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp605_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp606_;
						ValaCCodeIdentifier* _tmp607_;
						ValaCCodeFunctionCall* _tmp608_;
						ValaCCodeFunctionCall* _tmp609_;
						ValaCCodeFunctionCall* _tmp610_;
						ValaCCodeExpression* _tmp611_;
						ValaCCodeExpression* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						_tmp606_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp607_ = _tmp606_;
						_tmp608_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp607_);
						_tmp609_ = _tmp608_;
						_vala_ccode_node_unref0 (_tmp607_);
						k = _tmp609_;
						_tmp610_ = k;
						_tmp611_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp612_ = _tmp611_;
						vala_ccode_function_call_add_argument (_tmp610_, _tmp612_);
						_vala_ccode_node_unref0 (_tmp612_);
						_tmp613_ = k;
						_tmp614_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp613_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp614_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp615_;
					ValaCCodeIdentifier* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaCCodeFunctionCall* _tmp618_;
					ValaCCodeFunctionCall* _tmp619_;
					ValaMemberAccess* _tmp620_;
					ValaExpression* _tmp621_;
					ValaExpression* _tmp622_;
					ValaCCodeExpression* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					ValaCCodeFunctionCall* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					_tmp615_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp616_);
					_tmp618_ = _tmp617_;
					_vala_ccode_node_unref0 (_tmp616_);
					k = _tmp618_;
					_tmp619_ = k;
					_tmp620_ = ma;
					_tmp621_ = vala_member_access_get_inner (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp622_);
					_tmp624_ = _tmp623_;
					vala_ccode_function_call_add_argument (_tmp619_, _tmp624_);
					_vala_ccode_node_unref0 (_tmp624_);
					_tmp625_ = k;
					_tmp626_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp625_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp626_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp627_ = cast;
				_tmp628_ = klass;
				vala_ccode_function_call_add_argument (_tmp627_, _tmp628_);
				_tmp629_ = in_arg_map;
				_tmp630_ = m;
				_tmp631_ = cast;
				vala_map_set ((ValaMap*) _tmp629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp630_), FALSE)), (ValaCCodeExpression*) _tmp631_);
				_tmp632_ = out_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp636_ = m;
	if (_tmp636_ != NULL) {
		ValaMethod* _tmp637_;
		_tmp637_ = m;
		_tmp635_ = vala_get_ccode_has_generic_type_parameter (_tmp637_);
	} else {
		_tmp635_ = FALSE;
	}
	if (_tmp635_) {
		ValaMethod* _tmp638_;
		ValaList* _tmp639_;
		ValaList* _tmp640_;
		gint _tmp641_;
		gint _tmp642_;
		gboolean _tmp643_;
		_tmp638_ = m;
		_tmp639_ = vala_method_get_type_parameters (_tmp638_);
		_tmp640_ = _tmp639_;
		_tmp641_ = vala_collection_get_size ((ValaCollection*) _tmp640_);
		_tmp642_ = _tmp641_;
		_tmp643_ = _tmp642_ > 0;
		_vala_iterable_unref0 (_tmp640_);
		if (_tmp643_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp644_;
				ValaList* _tmp645_;
				gint _type_arg_size = 0;
				ValaList* _tmp646_;
				gint _tmp647_;
				gint _tmp648_;
				gint _type_arg_index = 0;
				_tmp644_ = ma;
				_tmp645_ = vala_member_access_get_type_arguments (_tmp644_);
				_type_arg_list = _tmp645_;
				_tmp646_ = _type_arg_list;
				_tmp647_ = vala_collection_get_size ((ValaCollection*) _tmp646_);
				_tmp648_ = _tmp647_;
				_type_arg_size = _tmp648_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp649_;
					gint _tmp650_;
					gint _tmp651_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp652_;
					gint _tmp653_;
					gpointer _tmp654_;
					ValaHashMap* _tmp655_;
					ValaMethod* _tmp656_;
					gint _tmp657_;
					ValaDataType* _tmp658_;
					gchar* _tmp659_;
					gchar* _tmp660_;
					ValaCCodeIdentifier* _tmp661_;
					ValaCCodeIdentifier* _tmp662_;
					gint _tmp663_;
					_tmp649_ = _type_arg_index;
					_type_arg_index = _tmp649_ + 1;
					_tmp650_ = _type_arg_index;
					_tmp651_ = _type_arg_size;
					if (!(_tmp650_ < _tmp651_)) {
						break;
					}
					_tmp652_ = _type_arg_list;
					_tmp653_ = _type_arg_index;
					_tmp654_ = vala_list_get (_tmp652_, _tmp653_);
					type_arg = (ValaDataType*) _tmp654_;
					_tmp655_ = in_arg_map;
					_tmp656_ = m;
					_tmp657_ = type_param_index;
					_tmp658_ = type_arg;
					_tmp659_ = vala_get_ccode_name ((ValaCodeNode*) _tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_ccode_identifier_new (_tmp660_);
					_tmp662_ = _tmp661_;
					vala_map_set ((ValaMap*) _tmp655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp656_) + (0.01 * _tmp657_), FALSE)), (ValaCCodeExpression*) _tmp662_);
					_vala_ccode_node_unref0 (_tmp662_);
					_g_free0 (_tmp660_);
					_tmp663_ = type_param_index;
					type_param_index = _tmp663_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaExpression* _tmp665_;
				ValaExpression* _tmp666_;
				ValaDataType* _tmp667_;
				ValaDataType* _tmp668_;
				ValaList* _tmp669_;
				gint _type_arg_size = 0;
				ValaList* _tmp670_;
				gint _tmp671_;
				gint _tmp672_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_inner (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_expression_get_value_type (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_data_type_get_type_arguments (_tmp668_);
				_type_arg_list = _tmp669_;
				_tmp670_ = _type_arg_list;
				_tmp671_ = vala_collection_get_size ((ValaCollection*) _tmp670_);
				_tmp672_ = _tmp671_;
				_type_arg_size = _tmp672_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp673_;
					gint _tmp674_;
					gint _tmp675_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp676_;
					gint _tmp677_;
					gpointer _tmp678_;
					ValaHashMap* _tmp679_;
					ValaMethod* _tmp680_;
					gint _tmp681_;
					ValaDataType* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					ValaCCodeIdentifier* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					gint _tmp687_;
					_tmp673_ = _type_arg_index;
					_type_arg_index = _tmp673_ + 1;
					_tmp674_ = _type_arg_index;
					_tmp675_ = _type_arg_size;
					if (!(_tmp674_ < _tmp675_)) {
						break;
					}
					_tmp676_ = _type_arg_list;
					_tmp677_ = _type_arg_index;
					_tmp678_ = vala_list_get (_tmp676_, _tmp677_);
					type_arg = (ValaDataType*) _tmp678_;
					_tmp679_ = in_arg_map;
					_tmp680_ = m;
					_tmp681_ = type_param_index;
					_tmp682_ = type_arg;
					_tmp683_ = vala_get_ccode_name ((ValaCodeNode*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_ccode_identifier_new (_tmp684_);
					_tmp686_ = _tmp685_;
					vala_map_set ((ValaMap*) _tmp679_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp680_) + (0.01 * _tmp681_), FALSE)), (ValaCCodeExpression*) _tmp686_);
					_vala_ccode_node_unref0 (_tmp686_);
					_g_free0 (_tmp684_);
					_tmp687_ = type_param_index;
					type_param_index = _tmp687_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp688_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp688_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp689_;
		ValaExpression* _tmp690_;
		ValaExpression* _tmp691_;
		ValaDataType* _tmp692_;
		ValaDataType* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp695_;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeFunctionCall* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaArrayType* _tmp700_;
		ValaDataType* _tmp701_;
		ValaDataType* _tmp702_;
		gchar* _tmp703_;
		gchar* _tmp704_;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaHashMap* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		_tmp689_ = ma;
		_tmp690_ = vala_member_access_get_inner (_tmp689_);
		_tmp691_ = _tmp690_;
		_tmp692_ = vala_expression_get_value_type (_tmp691_);
		_tmp693_ = _tmp692_;
		_tmp694_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp694_;
		_tmp695_ = vala_ccode_identifier_new ("sizeof");
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp696_);
		_tmp698_ = _tmp697_;
		_vala_ccode_node_unref0 (_tmp696_);
		csizeof = _tmp698_;
		_tmp699_ = csizeof;
		_tmp700_ = array_type;
		_tmp701_ = vala_array_type_get_element_type (_tmp700_);
		_tmp702_ = _tmp701_;
		_tmp703_ = vala_get_ccode_name ((ValaCodeNode*) _tmp702_);
		_tmp704_ = _tmp703_;
		_tmp705_ = vala_ccode_identifier_new (_tmp704_);
		_tmp706_ = _tmp705_;
		vala_ccode_function_call_add_argument (_tmp699_, (ValaCCodeExpression*) _tmp706_);
		_vala_ccode_node_unref0 (_tmp706_);
		_g_free0 (_tmp704_);
		_tmp707_ = in_arg_map;
		_tmp708_ = csizeof;
		vala_map_set ((ValaMap*) _tmp707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp708_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp709_;
		_tmp709_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp710_;
			gint param_nr = 0;
			ValaMethod* _tmp781_;
			_tmp710_ = m;
			vala_method_clear_parameters (_tmp710_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp711_;
				gint _arg_size = 0;
				ValaList* _tmp712_;
				gint _tmp713_;
				gint _tmp714_;
				gint _arg_index = 0;
				_tmp711_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp711_;
				_tmp712_ = _arg_list;
				_tmp713_ = vala_collection_get_size ((ValaCollection*) _tmp712_);
				_tmp714_ = _tmp713_;
				_arg_size = _tmp714_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp715_;
					gint _tmp716_;
					gint _tmp717_;
					ValaExpression* arg = NULL;
					ValaList* _tmp718_;
					gint _tmp719_;
					gpointer _tmp720_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp721_;
					ValaUnaryExpression* _tmp722_;
					gboolean _tmp723_ = FALSE;
					ValaUnaryExpression* _tmp724_;
					gint _tmp768_;
					_tmp715_ = _arg_index;
					_arg_index = _tmp715_ + 1;
					_tmp716_ = _arg_index;
					_tmp717_ = _arg_size;
					if (!(_tmp716_ < _tmp717_)) {
						break;
					}
					_tmp718_ = _arg_list;
					_tmp719_ = _arg_index;
					_tmp720_ = vala_list_get (_tmp718_, _tmp719_);
					arg = (ValaExpression*) _tmp720_;
					_tmp721_ = arg;
					_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp721_) : NULL);
					unary = _tmp722_;
					_tmp724_ = unary;
					if (_tmp724_ != NULL) {
						ValaUnaryExpression* _tmp725_;
						ValaUnaryOperator _tmp726_;
						ValaUnaryOperator _tmp727_;
						_tmp725_ = unary;
						_tmp726_ = vala_unary_expression_get_operator (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp723_ = _tmp727_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp723_ = FALSE;
					}
					if (_tmp723_) {
						ValaParameter* param = NULL;
						gint _tmp728_;
						gchar* _tmp729_;
						gchar* _tmp730_;
						ValaUnaryExpression* _tmp731_;
						ValaExpression* _tmp732_;
						ValaExpression* _tmp733_;
						ValaDataType* _tmp734_;
						ValaDataType* _tmp735_;
						ValaParameter* _tmp736_;
						ValaParameter* _tmp737_;
						ValaParameter* _tmp738_;
						ValaMethod* _tmp739_;
						ValaParameter* _tmp740_;
						_tmp728_ = param_nr;
						_tmp729_ = g_strdup_printf ("param%d", _tmp728_);
						_tmp730_ = _tmp729_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_inner (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp734_ = vala_expression_get_value_type (_tmp733_);
						_tmp735_ = _tmp734_;
						_tmp736_ = vala_parameter_new (_tmp730_, _tmp735_, NULL);
						_tmp737_ = _tmp736_;
						_g_free0 (_tmp730_);
						param = _tmp737_;
						_tmp738_ = param;
						vala_parameter_set_direction (_tmp738_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp739_ = m;
						_tmp740_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp739_, _tmp740_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp741_ = FALSE;
						ValaUnaryExpression* _tmp742_;
						_tmp742_ = unary;
						if (_tmp742_ != NULL) {
							ValaUnaryExpression* _tmp743_;
							ValaUnaryOperator _tmp744_;
							ValaUnaryOperator _tmp745_;
							_tmp743_ = unary;
							_tmp744_ = vala_unary_expression_get_operator (_tmp743_);
							_tmp745_ = _tmp744_;
							_tmp741_ = _tmp745_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp741_ = FALSE;
						}
						if (_tmp741_) {
							ValaParameter* param = NULL;
							gint _tmp746_;
							gchar* _tmp747_;
							gchar* _tmp748_;
							ValaUnaryExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaExpression* _tmp751_;
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							ValaParameter* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							ValaMethod* _tmp757_;
							ValaParameter* _tmp758_;
							_tmp746_ = param_nr;
							_tmp747_ = g_strdup_printf ("param%d", _tmp746_);
							_tmp748_ = _tmp747_;
							_tmp749_ = unary;
							_tmp750_ = vala_unary_expression_get_inner (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_expression_get_value_type (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_parameter_new (_tmp748_, _tmp753_, NULL);
							_tmp755_ = _tmp754_;
							_g_free0 (_tmp748_);
							param = _tmp755_;
							_tmp756_ = param;
							vala_parameter_set_direction (_tmp756_, VALA_PARAMETER_DIRECTION_REF);
							_tmp757_ = m;
							_tmp758_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp758_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp759_;
							gint _tmp760_;
							gchar* _tmp761_;
							gchar* _tmp762_;
							ValaExpression* _tmp763_;
							ValaDataType* _tmp764_;
							ValaDataType* _tmp765_;
							ValaParameter* _tmp766_;
							ValaParameter* _tmp767_;
							_tmp759_ = m;
							_tmp760_ = param_nr;
							_tmp761_ = g_strdup_printf ("param%d", _tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = arg;
							_tmp764_ = vala_expression_get_value_type (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = vala_parameter_new (_tmp762_, _tmp765_, NULL);
							_tmp767_ = _tmp766_;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp767_);
							_vala_code_node_unref0 (_tmp767_);
							_g_free0 (_tmp762_);
						}
					}
					_tmp768_ = param_nr;
					param_nr = _tmp768_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp769_;
				ValaList* _tmp770_;
				gint _param_size = 0;
				ValaList* _tmp771_;
				gint _tmp772_;
				gint _tmp773_;
				gint _param_index = 0;
				_tmp769_ = m;
				_tmp770_ = vala_callable_get_parameters ((ValaCallable*) _tmp769_);
				_param_list = _tmp770_;
				_tmp771_ = _param_list;
				_tmp772_ = vala_collection_get_size ((ValaCollection*) _tmp771_);
				_tmp773_ = _tmp772_;
				_param_size = _tmp773_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp774_;
					gint _tmp775_;
					gint _tmp776_;
					ValaParameter* param = NULL;
					ValaList* _tmp777_;
					gint _tmp778_;
					gpointer _tmp779_;
					ValaParameter* _tmp780_;
					_tmp774_ = _param_index;
					_param_index = _tmp774_ + 1;
					_tmp775_ = _param_index;
					_tmp776_ = _param_size;
					if (!(_tmp775_ < _tmp776_)) {
						break;
					}
					_tmp777_ = _param_list;
					_tmp778_ = _param_index;
					_tmp779_ = vala_list_get (_tmp777_, _tmp778_);
					param = (ValaParameter*) _tmp779_;
					_tmp780_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp780_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp781_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp782_ = FALSE;
			ValaMethod* _tmp783_;
			_tmp783_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp782_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CLASS);
			} else {
				_tmp782_ = FALSE;
			}
			if (_tmp782_) {
				ValaCCodeFunction* _tmp787_;
				ValaCCodeFunction* _tmp788_;
				ValaCCodeExpression* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeFunctionCall* _tmp791_;
				ValaClass* _tmp792_;
				ValaClass* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				ValaCCodeCastExpression* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				ValaBlock* _tmp802_;
				ValaBlock* _tmp803_;
				gboolean _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp832_ = FALSE;
				ValaClass* _tmp833_;
				ValaClass* _tmp834_;
				gboolean _tmp835_;
				gboolean _tmp836_;
				_tmp787_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = ccall;
				_tmp792_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_get_ccode_name ((ValaCodeNode*) _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp795_, "*", NULL);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp791_, _tmp797_);
				_tmp799_ = _tmp798_;
				vala_ccode_function_add_assignment (_tmp788_, _tmp790_, (ValaCCodeExpression*) _tmp799_);
				_vala_ccode_node_unref0 (_tmp799_);
				_g_free0 (_tmp797_);
				_g_free0 (_tmp795_);
				_vala_ccode_node_unref0 (_tmp790_);
				_tmp800_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_block_get_captured (_tmp803_);
				_tmp805_ = _tmp804_;
				if (_tmp805_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp806_;
					ValaClass* _tmp807_;
					ValaObjectType* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaSourceReference* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaCCodeExpression* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeFunctionCall* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeFunction* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaBlock* _tmp823_;
					ValaBlock* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeMemberAccess* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp807_);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp809_, _tmp811_, FALSE);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_function_call_new (_tmp813_);
					_tmp815_ = _tmp814_;
					_vala_ccode_node_unref0 (_tmp813_);
					_vala_code_node_unref0 (_tmp809_);
					ref_call = _tmp815_;
					_tmp816_ = ref_call;
					_tmp817_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp818_ = _tmp817_;
					vala_ccode_function_call_add_argument (_tmp816_, _tmp818_);
					_vala_ccode_node_unref0 (_tmp818_);
					_tmp819_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp824_));
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_member_access_new_pointer (_tmp828_, "self");
					_tmp830_ = _tmp829_;
					_tmp831_ = ref_call;
					vala_ccode_function_add_assignment (_tmp820_, (ValaCCodeExpression*) _tmp830_, (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp830_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp833_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_class_get_is_compact (_tmp834_);
				_tmp836_ = _tmp835_;
				if (!_tmp836_) {
					ValaClass* _tmp837_;
					ValaClass* _tmp838_;
					ValaList* _tmp839_;
					ValaList* _tmp840_;
					gint _tmp841_;
					gint _tmp842_;
					_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp839_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp832_ = _tmp842_ > 0;
					_vala_iterable_unref0 (_tmp840_);
				} else {
					_tmp832_ = FALSE;
				}
				if (_tmp832_) {
					gchar** suffices = NULL;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar* _tmp845_;
					gchar** _tmp846_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp843_ = g_strdup ("type");
					_tmp844_ = g_strdup ("dup_func");
					_tmp845_ = g_strdup ("destroy_func");
					_tmp846_ = g_new0 (gchar*, 3 + 1);
					_tmp846_[0] = _tmp843_;
					_tmp846_[1] = _tmp844_;
					_tmp846_[2] = _tmp845_;
					suffices = _tmp846_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp847_;
						ValaClass* _tmp848_;
						ValaList* _tmp849_;
						gint _type_param_size = 0;
						ValaList* _tmp850_;
						gint _tmp851_;
						gint _tmp852_;
						gint _type_param_index = 0;
						_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp848_ = _tmp847_;
						_tmp849_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp848_);
						_type_param_list = _tmp849_;
						_tmp850_ = _type_param_list;
						_tmp851_ = vala_collection_get_size ((ValaCollection*) _tmp850_);
						_tmp852_ = _tmp851_;
						_type_param_size = _tmp852_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp853_;
							gint _tmp854_;
							gint _tmp855_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp856_;
							gint _tmp857_;
							gpointer _tmp858_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp859_;
							ValaCCodeIdentifier* _tmp860_;
							ValaCCodeMemberAccess* _tmp861_;
							ValaCCodeMemberAccess* _tmp862_;
							gchar** _tmp863_;
							gint _tmp863__length1;
							_tmp853_ = _type_param_index;
							_type_param_index = _tmp853_ + 1;
							_tmp854_ = _type_param_index;
							_tmp855_ = _type_param_size;
							if (!(_tmp854_ < _tmp855_)) {
								break;
							}
							_tmp856_ = _type_param_list;
							_tmp857_ = _type_param_index;
							_tmp858_ = vala_list_get (_tmp856_, _tmp857_);
							type_param = (ValaTypeParameter*) _tmp858_;
							_tmp859_ = vala_ccode_identifier_new ("self");
							_tmp860_ = _tmp859_;
							_tmp861_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp860_, "priv");
							_tmp862_ = _tmp861_;
							_vala_ccode_node_unref0 (_tmp860_);
							priv_access = _tmp862_;
							_tmp863_ = suffices;
							_tmp863__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp863_;
								suffix_collection_length1 = _tmp863__length1;
								for (suffix_it = 0; suffix_it < _tmp863__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp864_;
									gchar* suffix = NULL;
									_tmp864_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp864_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp865_;
										const gchar* _tmp866_;
										const gchar* _tmp867_;
										gchar* _tmp868_;
										gchar* _tmp869_;
										const gchar* _tmp870_;
										gchar* _tmp871_;
										gchar* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										ValaCCodeIdentifier* _tmp874_;
										ValaCCodeFunction* _tmp875_;
										ValaCCodeFunction* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeIdentifier* _tmp878_;
										const gchar* _tmp879_;
										const gchar* _tmp880_;
										ValaCCodeMemberAccess* _tmp881_;
										ValaCCodeMemberAccess* _tmp882_;
										ValaCCodeIdentifier* _tmp883_;
										_tmp865_ = type_param;
										_tmp866_ = vala_symbol_get_name ((ValaSymbol*) _tmp865_);
										_tmp867_ = _tmp866_;
										_tmp868_ = g_utf8_strdown (_tmp867_, (gssize) -1);
										_tmp869_ = _tmp868_;
										_tmp870_ = suffix;
										_tmp871_ = g_strdup_printf ("%s_%s", _tmp869_, _tmp870_);
										_tmp872_ = _tmp871_;
										_tmp873_ = vala_ccode_identifier_new (_tmp872_);
										_tmp874_ = _tmp873_;
										_g_free0 (_tmp872_);
										_g_free0 (_tmp869_);
										param_name = _tmp874_;
										_tmp875_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp876_ = _tmp875_;
										_tmp877_ = priv_access;
										_tmp878_ = param_name;
										_tmp879_ = vala_ccode_identifier_get_name (_tmp878_);
										_tmp880_ = _tmp879_;
										_tmp881_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp877_, _tmp880_);
										_tmp882_ = _tmp881_;
										_tmp883_ = param_name;
										vala_ccode_function_add_assignment (_tmp876_, (ValaCCodeExpression*) _tmp882_, (ValaCCodeExpression*) _tmp883_);
										_vala_ccode_node_unref0 (_tmp882_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp884_ = params;
	_tmp885_ = vala_iterable_iterator ((ValaIterable*) _tmp884_);
	params_it = _tmp885_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp886_;
		gint _arg_size = 0;
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		gint _arg_index = 0;
		_tmp886_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp886_;
		_tmp887_ = _arg_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_arg_size = _tmp889_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp890_;
			gint _tmp891_;
			gint _tmp892_;
			ValaExpression* arg = NULL;
			ValaList* _tmp893_;
			gint _tmp894_;
			gpointer _tmp895_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp896_;
			ValaCCodeExpression* _tmp897_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp898_;
			ValaHashMap* _tmp899_;
			ValaIterator* _tmp900_;
			ValaHashMap* _tmp1206_;
			gint _tmp1207_;
			ValaCCodeExpression* _tmp1208_;
			gboolean _tmp1209_ = FALSE;
			ValaExpression* _tmp1210_;
			gint _tmp1230_;
			_tmp890_ = _arg_index;
			_arg_index = _tmp890_ + 1;
			_tmp891_ = _arg_index;
			_tmp892_ = _arg_size;
			if (!(_tmp891_ < _tmp892_)) {
				break;
			}
			_tmp893_ = _arg_list;
			_tmp894_ = _arg_index;
			_tmp895_ = vala_list_get (_tmp893_, _tmp894_);
			arg = (ValaExpression*) _tmp895_;
			_tmp896_ = arg;
			_tmp897_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp896_);
			cexpr = _tmp897_;
			_tmp898_ = in_arg_map;
			_tmp899_ = _vala_map_ref0 (_tmp898_);
			carg_map = _tmp899_;
			_tmp900_ = params_it;
			if (vala_iterator_next (_tmp900_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp901_;
				gpointer _tmp902_;
				gboolean _tmp903_ = FALSE;
				ValaParameter* _tmp904_;
				gboolean _tmp905_;
				gboolean _tmp906_;
				gboolean _tmp910_;
				ValaParameter* _tmp1199_;
				gboolean _tmp1200_;
				_tmp901_ = params_it;
				_tmp902_ = vala_iterator_get (_tmp901_);
				param = (ValaParameter*) _tmp902_;
				_tmp904_ = param;
				_tmp905_ = vala_parameter_get_params_array (_tmp904_);
				_tmp906_ = _tmp905_;
				if (_tmp906_) {
					_tmp903_ = TRUE;
				} else {
					ValaParameter* _tmp907_;
					gboolean _tmp908_;
					gboolean _tmp909_;
					_tmp907_ = param;
					_tmp908_ = vala_parameter_get_ellipsis (_tmp907_);
					_tmp909_ = _tmp908_;
					_tmp903_ = _tmp909_;
				}
				ellipsis = _tmp903_;
				_tmp910_ = ellipsis;
				if (!_tmp910_) {
					ValaParameter* _tmp911_;
					ValaParameterDirection _tmp912_;
					ValaParameterDirection _tmp913_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp916_;
					ValaUnaryExpression* _tmp917_;
					gboolean _tmp918_ = FALSE;
					ValaUnaryExpression* _tmp919_;
					ValaParameter* _tmp1187_;
					gchar* _tmp1188_;
					gchar* _tmp1189_;
					gboolean _tmp1190_;
					_tmp911_ = param;
					_tmp912_ = vala_parameter_get_direction (_tmp911_);
					_tmp913_ = _tmp912_;
					if (_tmp913_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp914_;
						ValaHashMap* _tmp915_;
						_tmp914_ = out_arg_map;
						_tmp915_ = _vala_map_ref0 (_tmp914_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp915_;
					}
					_tmp916_ = arg;
					_tmp917_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp916_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp916_) : NULL);
					unary = _tmp917_;
					_tmp919_ = unary;
					if (_tmp919_ == NULL) {
						_tmp918_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp920_;
						ValaUnaryOperator _tmp921_;
						ValaUnaryOperator _tmp922_;
						_tmp920_ = unary;
						_tmp921_ = vala_unary_expression_get_operator (_tmp920_);
						_tmp922_ = _tmp921_;
						_tmp918_ = _tmp922_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp918_) {
						gboolean _tmp923_ = FALSE;
						ValaParameter* _tmp924_;
						ValaParameter* _tmp1061_;
						ValaExpression* _tmp1062_;
						ValaCCodeExpression* _tmp1063_;
						ValaCCodeExpression* _tmp1064_;
						_tmp924_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp924_)) {
							ValaParameter* _tmp925_;
							ValaDataType* _tmp926_;
							ValaDataType* _tmp927_;
							_tmp925_ = param;
							_tmp926_ = vala_variable_get_variable_type ((ValaVariable*) _tmp925_);
							_tmp927_ = _tmp926_;
							_tmp923_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp927_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp923_ = FALSE;
						}
						if (_tmp923_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp928_;
							ValaDataType* _tmp929_;
							ValaDataType* _tmp930_;
							ValaArrayType* _tmp931_;
							_tmp928_ = param;
							_tmp929_ = vala_variable_get_variable_type ((ValaVariable*) _tmp928_);
							_tmp930_ = _tmp929_;
							_tmp931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp931_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp932_ = FALSE;
									_tmp932_ = TRUE;
									while (TRUE) {
										gint _tmp934_;
										ValaArrayType* _tmp935_;
										gint _tmp936_;
										gint _tmp937_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp938_;
										gchar* _tmp939_;
										gchar* _tmp940_;
										gboolean _tmp941_;
										ValaHashMap* _tmp958_;
										ValaParameter* _tmp959_;
										gint _tmp960_;
										ValaCCodeExpression* _tmp961_;
										if (!_tmp932_) {
											gint _tmp933_;
											_tmp933_ = dim;
											dim = _tmp933_ + 1;
										}
										_tmp932_ = FALSE;
										_tmp934_ = dim;
										_tmp935_ = array_type;
										_tmp936_ = vala_array_type_get_rank (_tmp935_);
										_tmp937_ = _tmp936_;
										if (!(_tmp934_ <= _tmp937_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp938_ = param;
										_tmp939_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp938_);
										_tmp940_ = _tmp939_;
										_tmp941_ = _tmp940_ != NULL;
										_g_free0 (_tmp940_);
										if (_tmp941_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp942_;
											gchar* _tmp943_;
											ValaUnaryExpression* _tmp944_;
											ValaUnaryOperator _tmp945_;
											ValaUnaryOperator _tmp946_;
											ValaExpression* _tmp949_;
											gint _tmp950_;
											ValaCCodeExpression* _tmp951_;
											ValaCCodeExpression* _tmp952_;
											const gchar* _tmp953_;
											ValaCCodeCastExpression* _tmp954_;
											_tmp942_ = param;
											_tmp943_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp942_);
											length_ctype = _tmp943_;
											_tmp944_ = unary;
											_tmp945_ = vala_unary_expression_get_operator (_tmp944_);
											_tmp946_ = _tmp945_;
											if (_tmp946_ == VALA_UNARY_OPERATOR_REF) {
												const gchar* _tmp947_;
												gchar* _tmp948_;
												_tmp947_ = length_ctype;
												_tmp948_ = g_strdup_printf ("%s*", _tmp947_);
												_g_free0 (length_ctype);
												length_ctype = _tmp948_;
											}
											_tmp949_ = arg;
											_tmp950_ = dim;
											_tmp951_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp949_, _tmp950_);
											_tmp952_ = _tmp951_;
											_tmp953_ = length_ctype;
											_tmp954_ = vala_ccode_cast_expression_new (_tmp952_, _tmp953_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp954_;
											_vala_ccode_node_unref0 (_tmp952_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp955_;
											gint _tmp956_;
											ValaCCodeExpression* _tmp957_;
											_tmp955_ = arg;
											_tmp956_ = dim;
											_tmp957_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp955_, _tmp956_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp957_;
										}
										_tmp958_ = carg_map;
										_tmp959_ = param;
										_tmp960_ = dim;
										_tmp961_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp958_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp959_) + (0.01 * _tmp960_), FALSE)), _tmp961_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp962_;
							ValaDataType* _tmp963_;
							ValaDataType* _tmp964_;
							_tmp962_ = param;
							_tmp963_ = vala_variable_get_variable_type ((ValaVariable*) _tmp962_);
							_tmp964_ = _tmp963_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp964_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp965_;
								ValaDataType* _tmp966_;
								ValaDataType* _tmp967_;
								ValaDelegateType* _tmp968_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp969_;
								ValaDelegate* _tmp970_;
								ValaDelegate* _tmp971_;
								ValaDelegate* _tmp972_;
								ValaDelegate* _tmp973_;
								gboolean _tmp974_;
								gboolean _tmp975_;
								_tmp965_ = param;
								_tmp966_ = vala_variable_get_variable_type ((ValaVariable*) _tmp965_);
								_tmp967_ = _tmp966_;
								_tmp968_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp967_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp968_;
								_tmp969_ = deleg_type;
								_tmp970_ = vala_delegate_type_get_delegate_symbol (_tmp969_);
								_tmp971_ = _tmp970_;
								_tmp972_ = _vala_code_node_ref0 (_tmp971_);
								d = _tmp972_;
								_tmp973_ = d;
								_tmp974_ = vala_delegate_get_has_target (_tmp973_);
								_tmp975_ = _tmp974_;
								if (_tmp975_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp976_;
									ValaCCodeExpression* _tmp977_ = NULL;
									ValaCCodeExpression* _tmp978_;
									ValaCCodeExpression* _tmp979_;
									ValaParameter* _tmp980_;
									gchar* _tmp981_;
									gchar* _tmp982_;
									gboolean _tmp983_;
									_tmp976_ = arg;
									_tmp978_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp976_, &_tmp977_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp977_;
									delegate_target = _tmp978_;
									_tmp979_ = delegate_target;
									_vala_assert (_tmp979_ != NULL, "delegate_target != null");
									_tmp980_ = param;
									_tmp981_ = vala_get_ccode_type ((ValaCodeNode*) _tmp980_);
									_tmp982_ = _tmp981_;
									_tmp983_ = g_strcmp0 (_tmp982_, "GClosure*") == 0;
									_g_free0 (_tmp982_);
									if (_tmp983_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp984_;
										ValaCCodeIdentifier* _tmp985_;
										ValaCCodeFunctionCall* _tmp986_;
										ValaCCodeFunctionCall* _tmp987_;
										ValaCCodeFunctionCall* _tmp988_;
										ValaCCodeExpression* _tmp989_;
										ValaCCodeCastExpression* _tmp990_;
										ValaCCodeCastExpression* _tmp991_;
										ValaCCodeFunctionCall* _tmp992_;
										ValaCCodeExpression* _tmp993_;
										ValaCCodeFunctionCall* _tmp994_;
										ValaCCodeExpression* _tmp995_;
										ValaCCodeCastExpression* _tmp996_;
										ValaCCodeCastExpression* _tmp997_;
										ValaCCodeExpression* _tmp998_;
										ValaCCodeIdentifier* _tmp999_;
										ValaCCodeIdentifier* _tmp1000_;
										ValaCCodeBinaryExpression* _tmp1001_;
										ValaCCodeBinaryExpression* _tmp1002_;
										ValaCCodeIdentifier* _tmp1003_;
										ValaCCodeIdentifier* _tmp1004_;
										ValaCCodeFunctionCall* _tmp1005_;
										ValaCCodeConditionalExpression* _tmp1006_;
										_tmp984_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp985_ = _tmp984_;
										_tmp986_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp985_);
										_tmp987_ = _tmp986_;
										_vala_ccode_node_unref0 (_tmp985_);
										closure_new = _tmp987_;
										_tmp988_ = closure_new;
										_tmp989_ = cexpr;
										_tmp990_ = vala_ccode_cast_expression_new (_tmp989_, "GCallback");
										_tmp991_ = _tmp990_;
										vala_ccode_function_call_add_argument (_tmp988_, (ValaCCodeExpression*) _tmp991_);
										_vala_ccode_node_unref0 (_tmp991_);
										_tmp992_ = closure_new;
										_tmp993_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp992_, _tmp993_);
										_tmp994_ = closure_new;
										_tmp995_ = delegate_target_destroy_notify;
										_tmp996_ = vala_ccode_cast_expression_new (_tmp995_, "GClosureNotify");
										_tmp997_ = _tmp996_;
										vala_ccode_function_call_add_argument (_tmp994_, (ValaCCodeExpression*) _tmp997_);
										_vala_ccode_node_unref0 (_tmp997_);
										_tmp998_ = cexpr;
										_tmp999_ = vala_ccode_identifier_new ("NULL");
										_tmp1000_ = _tmp999_;
										_tmp1001_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp998_, (ValaCCodeExpression*) _tmp1000_);
										_tmp1002_ = _tmp1001_;
										_tmp1003_ = vala_ccode_identifier_new ("NULL");
										_tmp1004_ = _tmp1003_;
										_tmp1005_ = closure_new;
										_tmp1006_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1002_, (ValaCCodeExpression*) _tmp1004_, (ValaCCodeExpression*) _tmp1005_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1006_;
										_vala_ccode_node_unref0 (_tmp1004_);
										_vala_ccode_node_unref0 (_tmp1002_);
										_vala_ccode_node_unref0 (_tmp1000_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1007_;
										ValaParameter* _tmp1008_;
										ValaCCodeExpression* _tmp1009_;
										ValaDelegateType* _tmp1010_;
										_tmp1007_ = carg_map;
										_tmp1008_ = param;
										_tmp1009_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1007_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1008_), FALSE)), _tmp1009_);
										_tmp1010_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1010_)) {
											ValaCCodeExpression* _tmp1011_;
											ValaHashMap* _tmp1012_;
											ValaParameter* _tmp1013_;
											ValaCCodeExpression* _tmp1014_;
											_tmp1011_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1011_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1012_ = carg_map;
											_tmp1013_ = param;
											_tmp1014_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1012_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1013_) + 0.01, FALSE)), _tmp1014_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1015_;
								ValaDataType* _tmp1016_;
								ValaDataType* _tmp1017_;
								_tmp1015_ = param;
								_tmp1016_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1015_);
								_tmp1017_ = _tmp1016_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1017_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1018_;
									ValaParameter* _tmp1019_;
									ValaExpression* _tmp1020_;
									ValaCCodeExpression* _tmp1021_ = NULL;
									ValaCCodeExpression* _tmp1022_;
									ValaCCodeExpression* _tmp1023_;
									_tmp1018_ = carg_map;
									_tmp1019_ = param;
									_tmp1020_ = arg;
									_tmp1022_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1020_, &_tmp1021_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1021_;
									_tmp1023_ = _tmp1022_;
									vala_map_set ((ValaMap*) _tmp1018_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1019_), FALSE)), _tmp1023_);
									_vala_ccode_node_unref0 (_tmp1023_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1024_;
									ValaDataType* _tmp1025_;
									ValaDataType* _tmp1026_;
									_tmp1024_ = param;
									_tmp1025_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1024_);
									_tmp1026_ = _tmp1025_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1026_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1027_ = FALSE;
										ValaMethod* _tmp1028_;
										_tmp1028_ = m;
										if (_tmp1028_ != NULL) {
											ValaMethod* _tmp1029_;
											_tmp1029_ = m;
											_tmp1027_ = vala_get_ccode_simple_generics (_tmp1029_);
										} else {
											_tmp1027_ = FALSE;
										}
										if (_tmp1027_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1030_;
											ValaDataType* _tmp1031_;
											ValaDataType* _tmp1032_;
											ValaGenericType* _tmp1033_;
											gint type_param_index = 0;
											ValaMethod* _tmp1034_;
											ValaGenericType* _tmp1035_;
											ValaTypeParameter* _tmp1036_;
											ValaTypeParameter* _tmp1037_;
											const gchar* _tmp1038_;
											const gchar* _tmp1039_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1040_;
											ValaList* _tmp1041_;
											ValaList* _tmp1042_;
											gint _tmp1043_;
											gpointer _tmp1044_;
											ValaDataType* _tmp1045_;
											ValaParameter* _tmp1046_;
											ValaDataType* _tmp1047_;
											ValaDataType* _tmp1048_;
											gboolean _tmp1049_;
											gboolean _tmp1050_;
											_tmp1030_ = param;
											_tmp1031_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1030_);
											_tmp1032_ = _tmp1031_;
											_tmp1033_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1032_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1033_;
											_tmp1034_ = m;
											_tmp1035_ = generic_type;
											_tmp1036_ = vala_generic_type_get_type_parameter (_tmp1035_);
											_tmp1037_ = _tmp1036_;
											_tmp1038_ = vala_symbol_get_name ((ValaSymbol*) _tmp1037_);
											_tmp1039_ = _tmp1038_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1034_, _tmp1039_);
											_tmp1040_ = ma;
											_tmp1041_ = vala_member_access_get_type_arguments (_tmp1040_);
											_tmp1042_ = _tmp1041_;
											_tmp1043_ = type_param_index;
											_tmp1044_ = vala_list_get (_tmp1042_, _tmp1043_);
											_tmp1045_ = (ValaDataType*) _tmp1044_;
											_vala_iterable_unref0 (_tmp1042_);
											type_arg = _tmp1045_;
											_tmp1046_ = param;
											_tmp1047_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1046_);
											_tmp1048_ = _tmp1047_;
											_tmp1049_ = vala_data_type_get_value_owned (_tmp1048_);
											_tmp1050_ = _tmp1049_;
											if (_tmp1050_) {
												ValaDataType* _tmp1051_;
												_tmp1051_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1051_)) {
													ValaHashMap* _tmp1052_;
													ValaParameter* _tmp1053_;
													ValaDataType* _tmp1054_;
													ValaCCodeExpression* _tmp1055_;
													ValaCCodeExpression* _tmp1056_;
													_tmp1052_ = carg_map;
													_tmp1053_ = param;
													_tmp1054_ = type_arg;
													_tmp1055_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1054_, FALSE);
													_tmp1056_ = _tmp1055_;
													vala_map_set ((ValaMap*) _tmp1052_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1053_), FALSE)), _tmp1056_);
													_vala_ccode_node_unref0 (_tmp1056_);
												} else {
													ValaHashMap* _tmp1057_;
													ValaParameter* _tmp1058_;
													ValaCCodeConstant* _tmp1059_;
													ValaCCodeConstant* _tmp1060_;
													_tmp1057_ = carg_map;
													_tmp1058_ = param;
													_tmp1059_ = vala_ccode_constant_new ("NULL");
													_tmp1060_ = _tmp1059_;
													vala_map_set ((ValaMap*) _tmp1057_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1058_), FALSE)), (ValaCCodeExpression*) _tmp1060_);
													_vala_ccode_node_unref0 (_tmp1060_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1061_ = param;
						_tmp1062_ = arg;
						_tmp1063_ = cexpr;
						_tmp1064_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1061_, _tmp1062_, _tmp1063_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1064_;
					} else {
						ValaExpression* _tmp1065_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1066_;
						ValaDataType* _tmp1067_;
						ValaDataType* _tmp1068_;
						ValaParameter* _tmp1069_;
						ValaDataType* _tmp1070_;
						ValaDataType* _tmp1071_;
						gboolean _tmp1072_;
						gboolean _tmp1073_;
						ValaLocalVariable* _tmp1074_;
						ValaLocalVariable* _tmp1075_;
						ValaExpression* _tmp1076_;
						ValaLocalVariable* _tmp1077_;
						const gchar* _tmp1078_;
						const gchar* _tmp1079_;
						ValaCCodeExpression* _tmp1080_;
						ValaCCodeExpression* _tmp1081_;
						ValaExpression* _tmp1082_;
						ValaTargetValue* _tmp1083_;
						ValaTargetValue* _tmp1084_;
						ValaExpression* _tmp1085_;
						ValaDataType* _tmp1086_;
						ValaDataType* _tmp1087_;
						ValaExpression* _tmp1088_;
						ValaCCodeExpression* _tmp1089_;
						ValaCCodeExpression* _tmp1090_;
						ValaCCodeUnaryExpression* _tmp1091_;
						gboolean _tmp1092_ = FALSE;
						ValaParameter* _tmp1093_;
						_tmp1065_ = arg;
						vala_expression_set_target_value (_tmp1065_, NULL);
						_tmp1066_ = param;
						_tmp1067_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1066_);
						_tmp1068_ = _tmp1067_;
						_tmp1069_ = param;
						_tmp1070_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1069_);
						_tmp1071_ = _tmp1070_;
						_tmp1072_ = vala_data_type_get_value_owned (_tmp1071_);
						_tmp1073_ = _tmp1072_;
						_tmp1074_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1068_, _tmp1073_, NULL, TRUE);
						temp_var = _tmp1074_;
						_tmp1075_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1075_);
						_tmp1076_ = arg;
						_tmp1077_ = temp_var;
						_tmp1078_ = vala_symbol_get_name ((ValaSymbol*) _tmp1077_);
						_tmp1079_ = _tmp1078_;
						_tmp1080_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1079_);
						_tmp1081_ = _tmp1080_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1076_, _tmp1081_);
						_vala_ccode_node_unref0 (_tmp1081_);
						_tmp1082_ = arg;
						_tmp1083_ = vala_expression_get_target_value (_tmp1082_);
						_tmp1084_ = _tmp1083_;
						_tmp1085_ = arg;
						_tmp1086_ = vala_expression_get_target_type (_tmp1085_);
						_tmp1087_ = _tmp1086_;
						vala_target_value_set_value_type (_tmp1084_, _tmp1087_);
						_tmp1088_ = arg;
						_tmp1089_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1088_);
						_tmp1090_ = _tmp1089_;
						_tmp1091_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1090_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1091_;
						_vala_ccode_node_unref0 (_tmp1090_);
						_tmp1093_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1093_)) {
							ValaParameter* _tmp1094_;
							ValaDataType* _tmp1095_;
							ValaDataType* _tmp1096_;
							_tmp1094_ = param;
							_tmp1095_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1094_);
							_tmp1096_ = _tmp1095_;
							_tmp1092_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1096_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1092_ = FALSE;
						}
						if (_tmp1092_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1097_;
							ValaDataType* _tmp1098_;
							ValaDataType* _tmp1099_;
							ValaArrayType* _tmp1100_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1101_;
							ValaDataType* _tmp1102_;
							ValaParameter* _tmp1103_;
							gchar* _tmp1104_;
							gchar* _tmp1105_;
							gboolean _tmp1106_;
							_tmp1097_ = param;
							_tmp1098_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1097_);
							_tmp1099_ = _tmp1098_;
							_tmp1100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1099_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1100_;
							_tmp1101_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1102_ = _vala_code_node_ref0 (_tmp1101_);
							array_length_type = _tmp1102_;
							_tmp1103_ = param;
							_tmp1104_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1103_);
							_tmp1105_ = _tmp1104_;
							_tmp1106_ = _tmp1105_ != NULL;
							_g_free0 (_tmp1105_);
							if (_tmp1106_) {
								ValaParameter* _tmp1107_;
								gchar* _tmp1108_;
								gchar* _tmp1109_;
								ValaCType* _tmp1110_;
								_tmp1107_ = param;
								_tmp1108_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1107_);
								_tmp1109_ = _tmp1108_;
								_tmp1110_ = vala_ctype_new (_tmp1109_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1110_;
								_g_free0 (_tmp1109_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1111_ = FALSE;
									_tmp1111_ = TRUE;
									while (TRUE) {
										gint _tmp1113_;
										ValaArrayType* _tmp1114_;
										gint _tmp1115_;
										gint _tmp1116_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1117_;
										ValaLocalVariable* _tmp1118_;
										ValaLocalVariable* _tmp1119_;
										ValaExpression* _tmp1120_;
										ValaLocalVariable* _tmp1121_;
										const gchar* _tmp1122_;
										const gchar* _tmp1123_;
										ValaCCodeExpression* _tmp1124_;
										ValaCCodeExpression* _tmp1125_;
										ValaHashMap* _tmp1126_;
										ValaParameter* _tmp1127_;
										gint _tmp1128_;
										ValaExpression* _tmp1129_;
										ValaList* _tmp1130_;
										ValaList* _tmp1131_;
										gint _tmp1132_;
										gpointer _tmp1133_;
										ValaCCodeExpression* _tmp1134_;
										ValaCCodeUnaryExpression* _tmp1135_;
										ValaCCodeUnaryExpression* _tmp1136_;
										if (!_tmp1111_) {
											gint _tmp1112_;
											_tmp1112_ = dim;
											dim = _tmp1112_ + 1;
										}
										_tmp1111_ = FALSE;
										_tmp1113_ = dim;
										_tmp1114_ = array_type;
										_tmp1115_ = vala_array_type_get_rank (_tmp1114_);
										_tmp1116_ = _tmp1115_;
										if (!(_tmp1113_ <= _tmp1116_)) {
											break;
										}
										_tmp1117_ = array_length_type;
										_tmp1118_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1117_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1118_;
										_tmp1119_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1119_);
										_tmp1120_ = arg;
										_tmp1121_ = temp_array_length;
										_tmp1122_ = vala_symbol_get_name ((ValaSymbol*) _tmp1121_);
										_tmp1123_ = _tmp1122_;
										_tmp1124_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1123_);
										_tmp1125_ = _tmp1124_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1120_, _tmp1125_);
										_vala_ccode_node_unref0 (_tmp1125_);
										_tmp1126_ = carg_map;
										_tmp1127_ = param;
										_tmp1128_ = dim;
										_tmp1129_ = arg;
										_tmp1130_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1129_);
										_tmp1131_ = _tmp1130_;
										_tmp1132_ = dim;
										_tmp1133_ = vala_list_get (_tmp1131_, _tmp1132_ - 1);
										_tmp1134_ = (ValaCCodeExpression*) _tmp1133_;
										_tmp1135_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1134_);
										_tmp1136_ = _tmp1135_;
										vala_map_set ((ValaMap*) _tmp1126_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1127_) + (0.01 * _tmp1128_), FALSE)), (ValaCCodeExpression*) _tmp1136_);
										_vala_ccode_node_unref0 (_tmp1136_);
										_vala_ccode_node_unref0 (_tmp1134_);
										_vala_iterable_unref0 (_tmp1131_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1137_;
							ValaDataType* _tmp1138_;
							ValaDataType* _tmp1139_;
							_tmp1137_ = param;
							_tmp1138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1137_);
							_tmp1139_ = _tmp1138_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1139_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1140_;
								ValaDataType* _tmp1141_;
								ValaDataType* _tmp1142_;
								ValaDelegateType* _tmp1143_;
								ValaDelegate* d = NULL;
								ValaDelegateType* _tmp1144_;
								ValaDelegate* _tmp1145_;
								ValaDelegate* _tmp1146_;
								ValaDelegate* _tmp1147_;
								ValaDelegate* _tmp1148_;
								gboolean _tmp1149_;
								gboolean _tmp1150_;
								_tmp1140_ = param;
								_tmp1141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1140_);
								_tmp1142_ = _tmp1141_;
								_tmp1143_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1142_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1143_;
								_tmp1144_ = deleg_type;
								_tmp1145_ = vala_delegate_type_get_delegate_symbol (_tmp1144_);
								_tmp1146_ = _tmp1145_;
								_tmp1147_ = _vala_code_node_ref0 (_tmp1146_);
								d = _tmp1147_;
								_tmp1148_ = d;
								_tmp1149_ = vala_delegate_get_has_target (_tmp1148_);
								_tmp1150_ = _tmp1149_;
								if (_tmp1150_) {
									ValaVoidType* _tmp1151_;
									ValaVoidType* _tmp1152_;
									ValaPointerType* _tmp1153_;
									ValaPointerType* _tmp1154_;
									ValaLocalVariable* _tmp1155_;
									ValaLocalVariable* _tmp1156_;
									ValaExpression* _tmp1157_;
									ValaLocalVariable* _tmp1158_;
									const gchar* _tmp1159_;
									const gchar* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaHashMap* _tmp1163_;
									ValaParameter* _tmp1164_;
									ValaExpression* _tmp1165_;
									ValaCCodeExpression* _tmp1166_;
									ValaCCodeExpression* _tmp1167_;
									ValaCCodeUnaryExpression* _tmp1168_;
									ValaCCodeUnaryExpression* _tmp1169_;
									ValaDelegateType* _tmp1170_;
									_tmp1151_ = vala_void_type_new (NULL);
									_tmp1152_ = _tmp1151_;
									_tmp1153_ = vala_pointer_type_new ((ValaDataType*) _tmp1152_, NULL);
									_tmp1154_ = _tmp1153_;
									_tmp1155_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1154_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1155_;
									_vala_code_node_unref0 (_tmp1154_);
									_vala_code_node_unref0 (_tmp1152_);
									_tmp1156_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1156_);
									_tmp1157_ = arg;
									_tmp1158_ = temp_var;
									_tmp1159_ = vala_symbol_get_name ((ValaSymbol*) _tmp1158_);
									_tmp1160_ = _tmp1159_;
									_tmp1161_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1160_);
									_tmp1162_ = _tmp1161_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1157_, _tmp1162_);
									_vala_ccode_node_unref0 (_tmp1162_);
									_tmp1163_ = carg_map;
									_tmp1164_ = param;
									_tmp1165_ = arg;
									_tmp1166_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1165_);
									_tmp1167_ = _tmp1166_;
									_tmp1168_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1167_);
									_tmp1169_ = _tmp1168_;
									vala_map_set ((ValaMap*) _tmp1163_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1164_), FALSE)), (ValaCCodeExpression*) _tmp1169_);
									_vala_ccode_node_unref0 (_tmp1169_);
									_vala_ccode_node_unref0 (_tmp1167_);
									_tmp1170_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1170_)) {
										ValaDataType* _tmp1171_;
										ValaLocalVariable* _tmp1172_;
										ValaLocalVariable* _tmp1173_;
										ValaExpression* _tmp1174_;
										ValaLocalVariable* _tmp1175_;
										const gchar* _tmp1176_;
										const gchar* _tmp1177_;
										ValaCCodeExpression* _tmp1178_;
										ValaCCodeExpression* _tmp1179_;
										ValaHashMap* _tmp1180_;
										ValaParameter* _tmp1181_;
										ValaExpression* _tmp1182_;
										ValaCCodeExpression* _tmp1183_;
										ValaCCodeExpression* _tmp1184_;
										ValaCCodeUnaryExpression* _tmp1185_;
										ValaCCodeUnaryExpression* _tmp1186_;
										_tmp1171_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1172_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1171_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1172_;
										_tmp1173_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1173_);
										_tmp1174_ = arg;
										_tmp1175_ = temp_var;
										_tmp1176_ = vala_symbol_get_name ((ValaSymbol*) _tmp1175_);
										_tmp1177_ = _tmp1176_;
										_tmp1178_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1177_);
										_tmp1179_ = _tmp1178_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1174_, _tmp1179_);
										_vala_ccode_node_unref0 (_tmp1179_);
										_tmp1180_ = carg_map;
										_tmp1181_ = param;
										_tmp1182_ = arg;
										_tmp1183_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1182_);
										_tmp1184_ = _tmp1183_;
										_tmp1185_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1184_);
										_tmp1186_ = _tmp1185_;
										vala_map_set ((ValaMap*) _tmp1180_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1181_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1186_);
										_vala_ccode_node_unref0 (_tmp1186_);
										_vala_ccode_node_unref0 (_tmp1184_);
									}
								}
								_vala_code_node_unref0 (d);
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1187_ = param;
					_tmp1188_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1190_ = _tmp1189_ != NULL;
					_g_free0 (_tmp1189_);
					if (_tmp1190_) {
						ValaCCodeExpression* _tmp1191_;
						ValaParameter* _tmp1192_;
						gchar* _tmp1193_;
						gchar* _tmp1194_;
						ValaCCodeCastExpression* _tmp1195_;
						_tmp1191_ = cexpr;
						_tmp1192_ = param;
						_tmp1193_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1192_);
						_tmp1194_ = _tmp1193_;
						_tmp1195_ = vala_ccode_cast_expression_new (_tmp1191_, _tmp1194_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1195_;
						_g_free0 (_tmp1194_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1196_;
					ValaCCodeExpression* _tmp1197_;
					ValaCCodeExpression* _tmp1198_;
					_tmp1196_ = arg;
					_tmp1197_ = cexpr;
					_tmp1198_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1196_, _tmp1197_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1198_;
				}
				_tmp1199_ = param;
				_tmp1200_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1199_), _tmp1200_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1201_;
				ValaCCodeExpression* _tmp1202_;
				ValaCCodeExpression* _tmp1203_;
				gint _tmp1204_;
				gboolean _tmp1205_;
				_tmp1201_ = arg;
				_tmp1202_ = cexpr;
				_tmp1203_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1201_, _tmp1202_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1203_;
				_tmp1204_ = i;
				_tmp1205_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1204_, _tmp1205_);
			}
			_tmp1206_ = carg_map;
			_tmp1207_ = arg_pos;
			_tmp1208_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1206_, (gpointer) ((gintptr) _tmp1207_), _tmp1208_);
			_tmp1210_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1210_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1211_;
				_tmp1211_ = ellipsis;
				_tmp1209_ = _tmp1211_;
			} else {
				_tmp1209_ = FALSE;
			}
			if (_tmp1209_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1212_;
				ValaNamedArgument* _tmp1213_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1214_;
				const gchar* _tmp1215_;
				const gchar* _tmp1216_;
				gchar** _tmp1217_;
				gchar** _tmp1218_;
				gchar** _tmp1219_;
				gint _tmp1219__length1;
				gchar* _tmp1220_;
				gchar* _tmp1221_;
				ValaHashMap* _tmp1222_;
				gint _tmp1223_;
				gboolean _tmp1224_;
				const gchar* _tmp1225_;
				gchar* _tmp1226_;
				gchar* _tmp1227_;
				ValaCCodeConstant* _tmp1228_;
				ValaCCodeConstant* _tmp1229_;
				_tmp1212_ = arg;
				_tmp1213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1212_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1213_;
				_tmp1214_ = named_arg;
				_tmp1215_ = vala_named_argument_get_name (_tmp1214_);
				_tmp1216_ = _tmp1215_;
				_tmp1218_ = _tmp1217_ = g_strsplit (_tmp1216_, "_", 0);
				_tmp1219_ = _tmp1218_;
				_tmp1219__length1 = _vala_array_length (_tmp1217_);
				_tmp1220_ = _vala_g_strjoinv ("-", _tmp1219_, _vala_array_length (_tmp1217_));
				_tmp1221_ = _tmp1220_;
				_tmp1219_ = (_vala_array_free (_tmp1219_, _tmp1219__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1221_;
				_tmp1222_ = carg_map;
				_tmp1223_ = i;
				_tmp1224_ = ellipsis;
				_tmp1225_ = name;
				_tmp1226_ = g_strdup_printf ("\"%s\"", _tmp1225_);
				_tmp1227_ = _tmp1226_;
				_tmp1228_ = vala_ccode_constant_new (_tmp1227_);
				_tmp1229_ = _tmp1228_;
				vala_map_set ((ValaMap*) _tmp1222_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1223_ - 0.1, _tmp1224_)), (ValaCCodeExpression*) _tmp1229_);
				_vala_ccode_node_unref0 (_tmp1229_);
				_g_free0 (_tmp1227_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1230_ = i;
			i = _tmp1230_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1231_ = params_it;
	if (vala_iterator_next (_tmp1231_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1232_;
		gpointer _tmp1233_;
		gboolean _tmp1234_ = FALSE;
		ValaParameter* _tmp1235_;
		gboolean _tmp1236_;
		gboolean _tmp1237_;
		_tmp1232_ = params_it;
		_tmp1233_ = vala_iterator_get (_tmp1232_);
		param = (ValaParameter*) _tmp1233_;
		_tmp1235_ = param;
		_tmp1236_ = vala_parameter_get_params_array (_tmp1235_);
		_tmp1237_ = _tmp1236_;
		if (_tmp1237_) {
			_tmp1234_ = TRUE;
		} else {
			ValaParameter* _tmp1238_;
			gboolean _tmp1239_;
			gboolean _tmp1240_;
			_tmp1238_ = param;
			_tmp1239_ = vala_parameter_get_ellipsis (_tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1234_ = _tmp1240_;
		}
		_vala_assert (_tmp1234_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1243_ = m;
	if (_tmp1243_ != NULL) {
		ValaMethod* _tmp1244_;
		ValaDataType* _tmp1245_;
		ValaDataType* _tmp1246_;
		_tmp1244_ = m;
		_tmp1245_ = vala_callable_get_return_type ((ValaCallable*) _tmp1244_);
		_tmp1246_ = _tmp1245_;
		_tmp1242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1246_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1242_ = FALSE;
	}
	if (_tmp1242_) {
		ValaCCodeFunctionCall* _tmp1247_;
		ValaCCodeFunctionCall* _tmp1248_;
		_tmp1247_ = async_call;
		_tmp1248_ = ccall;
		_tmp1241_ = _tmp1247_ != _tmp1248_;
	} else {
		_tmp1241_ = FALSE;
	}
	if (_tmp1241_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1249_;
		ValaDataType* _tmp1250_;
		ValaDataType* _tmp1251_;
		ValaArrayType* _tmp1252_;
		_tmp1249_ = m;
		_tmp1250_ = vala_callable_get_return_type ((ValaCallable*) _tmp1249_);
		_tmp1251_ = _tmp1250_;
		_tmp1252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1251_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1252_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1253_ = FALSE;
				_tmp1253_ = TRUE;
				while (TRUE) {
					gint _tmp1255_;
					ValaArrayType* _tmp1256_;
					gint _tmp1257_;
					gint _tmp1258_;
					ValaMethod* _tmp1259_;
					if (!_tmp1253_) {
						gint _tmp1254_;
						_tmp1254_ = dim;
						dim = _tmp1254_ + 1;
					}
					_tmp1253_ = FALSE;
					_tmp1255_ = dim;
					_tmp1256_ = array_type;
					_tmp1257_ = vala_array_type_get_rank (_tmp1256_);
					_tmp1258_ = _tmp1257_;
					if (!(_tmp1255_ <= _tmp1258_)) {
						break;
					}
					_tmp1259_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1259_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1260_;
						ValaDataType* _tmp1261_;
						ValaDataType* _tmp1262_;
						ValaLocalVariable* _tmp1263_;
						ValaLocalVariable* _tmp1264_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1265_;
						const gchar* _tmp1266_;
						const gchar* _tmp1267_;
						ValaCCodeExpression* _tmp1268_;
						ValaLocalVariable* _tmp1269_;
						ValaCCodeExpression* _tmp1270_;
						ValaCCodeExpression* _tmp1271_;
						ValaCCodeAssignment* _tmp1272_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1273_;
						ValaCCodeIdentifier* _tmp1274_;
						ValaCCodeFunctionCall* _tmp1275_;
						ValaCCodeFunctionCall* _tmp1276_;
						ValaCCodeFunctionCall* _tmp1277_;
						ValaCCodeExpression* _tmp1278_;
						ValaCCodeFunctionCall* _tmp1279_;
						_tmp1260_ = itype;
						_tmp1261_ = vala_data_type_get_return_type (_tmp1260_);
						_tmp1262_ = _tmp1261_;
						_tmp1263_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1262_, TRUE, NULL, FALSE);
						_tmp1264_ = _tmp1263_;
						_vala_code_node_unref0 (_tmp1262_);
						temp_var = _tmp1264_;
						_tmp1265_ = temp_var;
						_tmp1266_ = vala_symbol_get_name ((ValaSymbol*) _tmp1265_);
						_tmp1267_ = _tmp1266_;
						_tmp1268_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1267_);
						temp_ref = _tmp1268_;
						_tmp1269_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1269_);
						_tmp1270_ = temp_ref;
						_tmp1271_ = ccall_expr;
						_tmp1272_ = vala_ccode_assignment_new (_tmp1270_, _tmp1271_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1272_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1273_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1274_ = _tmp1273_;
						_tmp1275_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1274_);
						_tmp1276_ = _tmp1275_;
						_vala_ccode_node_unref0 (_tmp1274_);
						len_call = _tmp1276_;
						_tmp1277_ = len_call;
						_tmp1278_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1277_, _tmp1278_);
						_tmp1279_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1279_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1280_;
						_tmp1280_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1280_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1281_;
							gchar* _tmp1282_;
							gchar* _tmp1283_;
							gboolean _tmp1284_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1293_;
							const gchar* _tmp1294_;
							const gchar* _tmp1295_;
							ValaCCodeExpression* _tmp1296_;
							ValaLocalVariable* _tmp1297_;
							ValaHashMap* _tmp1298_;
							ValaMethod* _tmp1299_;
							gint _tmp1300_;
							ValaCCodeExpression* _tmp1301_;
							ValaCCodeUnaryExpression* _tmp1302_;
							ValaCCodeUnaryExpression* _tmp1303_;
							ValaCCodeExpression* _tmp1304_;
							_tmp1281_ = m;
							_tmp1282_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1281_);
							_tmp1283_ = _tmp1282_;
							_tmp1284_ = _tmp1283_ == NULL;
							_g_free0 (_tmp1283_);
							if (_tmp1284_) {
								ValaDataType* _tmp1285_;
								ValaLocalVariable* _tmp1286_;
								_tmp1285_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1286_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1285_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1286_;
							} else {
								ValaMethod* _tmp1287_;
								gchar* _tmp1288_;
								gchar* _tmp1289_;
								ValaCType* _tmp1290_;
								ValaCType* _tmp1291_;
								ValaLocalVariable* _tmp1292_;
								_tmp1287_ = m;
								_tmp1288_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1287_);
								_tmp1289_ = _tmp1288_;
								_tmp1290_ = vala_ctype_new (_tmp1289_);
								_tmp1291_ = _tmp1290_;
								_tmp1292_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1291_, TRUE, NULL, FALSE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1292_;
								_vala_code_node_unref0 (_tmp1291_);
								_g_free0 (_tmp1289_);
							}
							_tmp1293_ = temp_var;
							_tmp1294_ = vala_symbol_get_name ((ValaSymbol*) _tmp1293_);
							_tmp1295_ = _tmp1294_;
							_tmp1296_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1295_);
							temp_ref = _tmp1296_;
							_tmp1297_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1297_);
							_tmp1298_ = out_arg_map;
							_tmp1299_ = m;
							_tmp1300_ = dim;
							_tmp1301_ = temp_ref;
							_tmp1302_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1301_);
							_tmp1303_ = _tmp1302_;
							vala_map_set ((ValaMap*) _tmp1298_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1299_) + (0.01 * _tmp1300_), FALSE)), (ValaCCodeExpression*) _tmp1303_);
							_vala_ccode_node_unref0 (_tmp1303_);
							_tmp1304_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1304_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1305_;
							gchar* _tmp1306_;
							gchar* _tmp1307_;
							gboolean _tmp1308_;
							_tmp1305_ = m;
							_tmp1306_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1305_);
							_tmp1307_ = _tmp1306_;
							_tmp1308_ = _tmp1307_ != NULL;
							_g_free0 (_tmp1307_);
							if (_tmp1308_) {
								ValaMethod* _tmp1309_;
								gchar* _tmp1310_;
								gchar* _tmp1311_;
								ValaCCodeConstant* _tmp1312_;
								ValaCCodeConstant* _tmp1313_;
								_tmp1309_ = m;
								_tmp1310_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1309_);
								_tmp1311_ = _tmp1310_;
								_tmp1312_ = vala_ccode_constant_new (_tmp1311_);
								_tmp1313_ = _tmp1312_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1313_);
								_vala_ccode_node_unref0 (_tmp1313_);
								_g_free0 (_tmp1311_);
							} else {
								ValaCCodeConstant* _tmp1314_;
								ValaCCodeConstant* _tmp1315_;
								_tmp1314_ = vala_ccode_constant_new ("-1");
								_tmp1315_ = _tmp1314_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1315_);
								_vala_ccode_node_unref0 (_tmp1315_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1316_ = FALSE;
		gboolean _tmp1317_ = FALSE;
		ValaMethod* _tmp1318_;
		_tmp1318_ = m;
		if (_tmp1318_ != NULL) {
			ValaMethod* _tmp1319_;
			ValaDataType* _tmp1320_;
			ValaDataType* _tmp1321_;
			_tmp1319_ = m;
			_tmp1320_ = vala_callable_get_return_type ((ValaCallable*) _tmp1319_);
			_tmp1321_ = _tmp1320_;
			_tmp1317_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1321_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1317_ = FALSE;
		}
		if (_tmp1317_) {
			ValaCCodeFunctionCall* _tmp1322_;
			ValaCCodeFunctionCall* _tmp1323_;
			_tmp1322_ = async_call;
			_tmp1323_ = ccall;
			_tmp1316_ = _tmp1322_ != _tmp1323_;
		} else {
			_tmp1316_ = FALSE;
		}
		if (_tmp1316_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaDelegateType* _tmp1327_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1328_;
			ValaDelegate* _tmp1329_;
			ValaDelegate* _tmp1330_;
			ValaDelegate* _tmp1331_;
			ValaDelegate* _tmp1332_;
			gboolean _tmp1333_;
			gboolean _tmp1334_;
			_tmp1324_ = m;
			_tmp1325_ = vala_callable_get_return_type ((ValaCallable*) _tmp1324_);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1326_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1327_;
			_tmp1328_ = deleg_type;
			_tmp1329_ = vala_delegate_type_get_delegate_symbol (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = _vala_code_node_ref0 (_tmp1330_);
			d = _tmp1331_;
			_tmp1332_ = d;
			_tmp1333_ = vala_delegate_get_has_target (_tmp1332_);
			_tmp1334_ = _tmp1333_;
			if (_tmp1334_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1335_;
				ValaVoidType* _tmp1336_;
				ValaPointerType* _tmp1337_;
				ValaPointerType* _tmp1338_;
				ValaLocalVariable* _tmp1339_;
				ValaLocalVariable* _tmp1340_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1341_;
				const gchar* _tmp1342_;
				const gchar* _tmp1343_;
				ValaCCodeExpression* _tmp1344_;
				ValaLocalVariable* _tmp1345_;
				ValaHashMap* _tmp1346_;
				ValaMethod* _tmp1347_;
				ValaCCodeExpression* _tmp1348_;
				ValaCCodeUnaryExpression* _tmp1349_;
				ValaCCodeUnaryExpression* _tmp1350_;
				ValaCCodeExpression* _tmp1351_;
				ValaDelegateType* _tmp1352_;
				_tmp1335_ = vala_void_type_new (NULL);
				_tmp1336_ = _tmp1335_;
				_tmp1337_ = vala_pointer_type_new ((ValaDataType*) _tmp1336_, NULL);
				_tmp1338_ = _tmp1337_;
				_tmp1339_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1338_, TRUE, NULL, FALSE);
				_tmp1340_ = _tmp1339_;
				_vala_code_node_unref0 (_tmp1338_);
				_vala_code_node_unref0 (_tmp1336_);
				temp_var = _tmp1340_;
				_tmp1341_ = temp_var;
				_tmp1342_ = vala_symbol_get_name ((ValaSymbol*) _tmp1341_);
				_tmp1343_ = _tmp1342_;
				_tmp1344_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1343_);
				temp_ref = _tmp1344_;
				_tmp1345_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1345_);
				_tmp1346_ = out_arg_map;
				_tmp1347_ = m;
				_tmp1348_ = temp_ref;
				_tmp1349_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1348_);
				_tmp1350_ = _tmp1349_;
				vala_map_set ((ValaMap*) _tmp1346_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1347_), FALSE)), (ValaCCodeExpression*) _tmp1350_);
				_vala_ccode_node_unref0 (_tmp1350_);
				_tmp1351_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1351_);
				_tmp1352_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1352_)) {
					ValaDataType* _tmp1353_;
					ValaLocalVariable* _tmp1354_;
					ValaLocalVariable* _tmp1355_;
					const gchar* _tmp1356_;
					const gchar* _tmp1357_;
					ValaCCodeExpression* _tmp1358_;
					ValaLocalVariable* _tmp1359_;
					ValaHashMap* _tmp1360_;
					ValaMethod* _tmp1361_;
					ValaCCodeExpression* _tmp1362_;
					ValaCCodeUnaryExpression* _tmp1363_;
					ValaCCodeUnaryExpression* _tmp1364_;
					ValaCCodeExpression* _tmp1365_;
					_tmp1353_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1354_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1353_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1354_;
					_tmp1355_ = temp_var;
					_tmp1356_ = vala_symbol_get_name ((ValaSymbol*) _tmp1355_);
					_tmp1357_ = _tmp1356_;
					_tmp1358_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1357_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1358_;
					_tmp1359_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1359_);
					_tmp1360_ = out_arg_map;
					_tmp1361_ = m;
					_tmp1362_ = temp_ref;
					_tmp1363_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1362_);
					_tmp1364_ = _tmp1363_;
					vala_map_set ((ValaMap*) _tmp1360_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1361_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1364_);
					_vala_ccode_node_unref0 (_tmp1364_);
					_tmp1365_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1365_);
				} else {
					ValaCCodeConstant* _tmp1366_;
					ValaCCodeConstant* _tmp1367_;
					_tmp1366_ = vala_ccode_constant_new ("NULL");
					_tmp1367_ = _tmp1366_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1367_);
					_vala_ccode_node_unref0 (_tmp1367_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1368_;
				ValaCCodeConstant* _tmp1369_;
				_tmp1368_ = vala_ccode_constant_new ("NULL");
				_tmp1369_ = _tmp1368_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1369_);
				_vala_ccode_node_unref0 (_tmp1369_);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1371_ = deleg;
	if (_tmp1371_ != NULL) {
		ValaDelegate* _tmp1372_;
		ValaDataType* _tmp1373_;
		ValaDataType* _tmp1374_;
		_tmp1372_ = deleg;
		_tmp1373_ = vala_callable_get_return_type ((ValaCallable*) _tmp1372_);
		_tmp1374_ = _tmp1373_;
		_tmp1370_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1374_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1370_ = FALSE;
	}
	if (_tmp1370_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1375_;
		ValaDataType* _tmp1376_;
		ValaDataType* _tmp1377_;
		ValaArrayType* _tmp1378_;
		_tmp1375_ = deleg;
		_tmp1376_ = vala_callable_get_return_type ((ValaCallable*) _tmp1375_);
		_tmp1377_ = _tmp1376_;
		_tmp1378_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1377_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1378_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1379_ = FALSE;
				_tmp1379_ = TRUE;
				while (TRUE) {
					gint _tmp1381_;
					ValaArrayType* _tmp1382_;
					gint _tmp1383_;
					gint _tmp1384_;
					ValaDelegate* _tmp1385_;
					if (!_tmp1379_) {
						gint _tmp1380_;
						_tmp1380_ = dim;
						dim = _tmp1380_ + 1;
					}
					_tmp1379_ = FALSE;
					_tmp1381_ = dim;
					_tmp1382_ = array_type;
					_tmp1383_ = vala_array_type_get_rank (_tmp1382_);
					_tmp1384_ = _tmp1383_;
					if (!(_tmp1381_ <= _tmp1384_)) {
						break;
					}
					_tmp1385_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1385_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1386_;
						ValaDataType* _tmp1387_;
						ValaDataType* _tmp1388_;
						ValaLocalVariable* _tmp1389_;
						ValaLocalVariable* _tmp1390_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1391_;
						const gchar* _tmp1392_;
						const gchar* _tmp1393_;
						ValaCCodeExpression* _tmp1394_;
						ValaLocalVariable* _tmp1395_;
						ValaCCodeExpression* _tmp1396_;
						ValaCCodeExpression* _tmp1397_;
						ValaCCodeAssignment* _tmp1398_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1399_;
						ValaCCodeIdentifier* _tmp1400_;
						ValaCCodeFunctionCall* _tmp1401_;
						ValaCCodeFunctionCall* _tmp1402_;
						ValaCCodeFunctionCall* _tmp1403_;
						ValaCCodeExpression* _tmp1404_;
						ValaCCodeFunctionCall* _tmp1405_;
						_tmp1386_ = itype;
						_tmp1387_ = vala_data_type_get_return_type (_tmp1386_);
						_tmp1388_ = _tmp1387_;
						_tmp1389_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1388_, TRUE, NULL, FALSE);
						_tmp1390_ = _tmp1389_;
						_vala_code_node_unref0 (_tmp1388_);
						temp_var = _tmp1390_;
						_tmp1391_ = temp_var;
						_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
						_tmp1393_ = _tmp1392_;
						_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
						temp_ref = _tmp1394_;
						_tmp1395_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_);
						_tmp1396_ = temp_ref;
						_tmp1397_ = ccall_expr;
						_tmp1398_ = vala_ccode_assignment_new (_tmp1396_, _tmp1397_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1398_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1399_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1400_ = _tmp1399_;
						_tmp1401_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1400_);
						_tmp1402_ = _tmp1401_;
						_vala_ccode_node_unref0 (_tmp1400_);
						len_call = _tmp1402_;
						_tmp1403_ = len_call;
						_tmp1404_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1403_, _tmp1404_);
						_tmp1405_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1405_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1406_;
						_tmp1406_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1406_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1407_;
							ValaLocalVariable* _tmp1408_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1409_;
							const gchar* _tmp1410_;
							const gchar* _tmp1411_;
							ValaCCodeExpression* _tmp1412_;
							ValaLocalVariable* _tmp1413_;
							ValaHashMap* _tmp1414_;
							ValaDelegate* _tmp1415_;
							gint _tmp1416_;
							ValaCCodeExpression* _tmp1417_;
							ValaCCodeUnaryExpression* _tmp1418_;
							ValaCCodeUnaryExpression* _tmp1419_;
							ValaCCodeExpression* _tmp1420_;
							_tmp1407_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1408_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1407_, TRUE, NULL, FALSE);
							temp_var = _tmp1408_;
							_tmp1409_ = temp_var;
							_tmp1410_ = vala_symbol_get_name ((ValaSymbol*) _tmp1409_);
							_tmp1411_ = _tmp1410_;
							_tmp1412_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1411_);
							temp_ref = _tmp1412_;
							_tmp1413_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1413_);
							_tmp1414_ = out_arg_map;
							_tmp1415_ = deleg;
							_tmp1416_ = dim;
							_tmp1417_ = temp_ref;
							_tmp1418_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1417_);
							_tmp1419_ = _tmp1418_;
							vala_map_set ((ValaMap*) _tmp1414_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1415_) + (0.01 * _tmp1416_), FALSE)), (ValaCCodeExpression*) _tmp1419_);
							_vala_ccode_node_unref0 (_tmp1419_);
							_tmp1420_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1420_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1421_;
							ValaCCodeConstant* _tmp1422_;
							_tmp1421_ = vala_ccode_constant_new ("-1");
							_tmp1422_ = _tmp1421_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1422_);
							_vala_ccode_node_unref0 (_tmp1422_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1423_ = FALSE;
		ValaDelegate* _tmp1424_;
		_tmp1424_ = deleg;
		if (_tmp1424_ != NULL) {
			ValaDelegate* _tmp1425_;
			ValaDataType* _tmp1426_;
			ValaDataType* _tmp1427_;
			_tmp1425_ = deleg;
			_tmp1426_ = vala_callable_get_return_type ((ValaCallable*) _tmp1425_);
			_tmp1427_ = _tmp1426_;
			_tmp1423_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1427_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1423_ = FALSE;
		}
		if (_tmp1423_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1428_;
			ValaDataType* _tmp1429_;
			ValaDataType* _tmp1430_;
			ValaDelegateType* _tmp1431_;
			ValaDelegate* d = NULL;
			ValaDelegateType* _tmp1432_;
			ValaDelegate* _tmp1433_;
			ValaDelegate* _tmp1434_;
			ValaDelegate* _tmp1435_;
			ValaDelegate* _tmp1436_;
			gboolean _tmp1437_;
			gboolean _tmp1438_;
			_tmp1428_ = deleg;
			_tmp1429_ = vala_callable_get_return_type ((ValaCallable*) _tmp1428_);
			_tmp1430_ = _tmp1429_;
			_tmp1431_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1430_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1431_;
			_tmp1432_ = deleg_type;
			_tmp1433_ = vala_delegate_type_get_delegate_symbol (_tmp1432_);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = _vala_code_node_ref0 (_tmp1434_);
			d = _tmp1435_;
			_tmp1436_ = d;
			_tmp1437_ = vala_delegate_get_has_target (_tmp1436_);
			_tmp1438_ = _tmp1437_;
			if (_tmp1438_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1439_;
				ValaVoidType* _tmp1440_;
				ValaPointerType* _tmp1441_;
				ValaPointerType* _tmp1442_;
				ValaLocalVariable* _tmp1443_;
				ValaLocalVariable* _tmp1444_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1445_;
				const gchar* _tmp1446_;
				const gchar* _tmp1447_;
				ValaCCodeExpression* _tmp1448_;
				ValaLocalVariable* _tmp1449_;
				ValaHashMap* _tmp1450_;
				ValaDelegate* _tmp1451_;
				ValaCCodeExpression* _tmp1452_;
				ValaCCodeUnaryExpression* _tmp1453_;
				ValaCCodeUnaryExpression* _tmp1454_;
				ValaCCodeExpression* _tmp1455_;
				ValaDelegateType* _tmp1456_;
				_tmp1439_ = vala_void_type_new (NULL);
				_tmp1440_ = _tmp1439_;
				_tmp1441_ = vala_pointer_type_new ((ValaDataType*) _tmp1440_, NULL);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1442_, TRUE, NULL, FALSE);
				_tmp1444_ = _tmp1443_;
				_vala_code_node_unref0 (_tmp1442_);
				_vala_code_node_unref0 (_tmp1440_);
				temp_var = _tmp1444_;
				_tmp1445_ = temp_var;
				_tmp1446_ = vala_symbol_get_name ((ValaSymbol*) _tmp1445_);
				_tmp1447_ = _tmp1446_;
				_tmp1448_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1447_);
				temp_ref = _tmp1448_;
				_tmp1449_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1449_);
				_tmp1450_ = out_arg_map;
				_tmp1451_ = deleg;
				_tmp1452_ = temp_ref;
				_tmp1453_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1452_);
				_tmp1454_ = _tmp1453_;
				vala_map_set ((ValaMap*) _tmp1450_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1451_), FALSE)), (ValaCCodeExpression*) _tmp1454_);
				_vala_ccode_node_unref0 (_tmp1454_);
				_tmp1455_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1455_);
				_tmp1456_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1456_)) {
					ValaDataType* _tmp1457_;
					ValaLocalVariable* _tmp1458_;
					ValaLocalVariable* _tmp1459_;
					const gchar* _tmp1460_;
					const gchar* _tmp1461_;
					ValaCCodeExpression* _tmp1462_;
					ValaLocalVariable* _tmp1463_;
					ValaHashMap* _tmp1464_;
					ValaDelegate* _tmp1465_;
					ValaCCodeExpression* _tmp1466_;
					ValaCCodeUnaryExpression* _tmp1467_;
					ValaCCodeUnaryExpression* _tmp1468_;
					ValaCCodeExpression* _tmp1469_;
					_tmp1457_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1458_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1457_, TRUE, NULL, FALSE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1458_;
					_tmp1459_ = temp_var;
					_tmp1460_ = vala_symbol_get_name ((ValaSymbol*) _tmp1459_);
					_tmp1461_ = _tmp1460_;
					_tmp1462_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1461_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1462_;
					_tmp1463_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1463_);
					_tmp1464_ = out_arg_map;
					_tmp1465_ = deleg;
					_tmp1466_ = temp_ref;
					_tmp1467_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1466_);
					_tmp1468_ = _tmp1467_;
					vala_map_set ((ValaMap*) _tmp1464_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1465_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1468_);
					_vala_ccode_node_unref0 (_tmp1468_);
					_tmp1469_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1469_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (d);
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1471_ = m;
	if (_tmp1471_ != NULL) {
		ValaMethod* _tmp1472_;
		gboolean _tmp1473_;
		gboolean _tmp1474_;
		_tmp1472_ = m;
		_tmp1473_ = vala_method_get_coroutine (_tmp1472_);
		_tmp1474_ = _tmp1473_;
		_tmp1470_ = _tmp1474_;
	} else {
		_tmp1470_ = FALSE;
	}
	if (_tmp1470_) {
		gboolean _tmp1475_;
		gboolean _tmp1476_;
		_tmp1475_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1476_ = _tmp1475_;
		if (_tmp1476_) {
			ValaHashMap* _tmp1477_;
			ValaMethod* _tmp1478_;
			ValaMethod* _tmp1479_;
			gchar* _tmp1480_;
			gchar* _tmp1481_;
			ValaCCodeIdentifier* _tmp1482_;
			ValaCCodeIdentifier* _tmp1483_;
			ValaHashMap* _tmp1484_;
			ValaCCodeIdentifier* _tmp1485_;
			ValaCCodeIdentifier* _tmp1486_;
			_tmp1477_ = in_arg_map;
			_tmp1478_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1479_ = _tmp1478_;
			_tmp1480_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1479_);
			_tmp1481_ = _tmp1480_;
			_tmp1482_ = vala_ccode_identifier_new (_tmp1481_);
			_tmp1483_ = _tmp1482_;
			vala_map_set ((ValaMap*) _tmp1477_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1483_);
			_vala_ccode_node_unref0 (_tmp1483_);
			_g_free0 (_tmp1481_);
			_tmp1484_ = in_arg_map;
			_tmp1485_ = vala_ccode_identifier_new ("_data_");
			_tmp1486_ = _tmp1485_;
			vala_map_set ((ValaMap*) _tmp1484_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1486_);
			_vala_ccode_node_unref0 (_tmp1486_);
		}
	}
	_tmp1487_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1488_ = _tmp1487_;
	if (_tmp1488_) {
		ValaHashMap* _tmp1489_;
		ValaCCodeExpression* _tmp1490_;
		ValaCCodeExpression* _tmp1491_;
		ValaCCodeUnaryExpression* _tmp1492_;
		ValaCCodeUnaryExpression* _tmp1493_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1489_ = out_arg_map;
		_tmp1490_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1491_ = _tmp1490_;
		_tmp1492_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1491_);
		_tmp1493_ = _tmp1492_;
		vala_map_set ((ValaMap*) _tmp1489_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1493_);
		_vala_ccode_node_unref0 (_tmp1493_);
		_vala_ccode_node_unref0 (_tmp1491_);
	} else {
		gboolean _tmp1494_ = FALSE;
		gboolean _tmp1495_ = FALSE;
		ValaMethod* _tmp1496_;
		_tmp1496_ = m;
		if (_tmp1496_ != NULL) {
			ValaMethod* _tmp1497_;
			_tmp1497_ = m;
			_tmp1495_ = vala_method_has_error_type_parameter (_tmp1497_);
		} else {
			_tmp1495_ = FALSE;
		}
		if (_tmp1495_) {
			ValaCCodeFunctionCall* _tmp1498_;
			ValaCCodeFunctionCall* _tmp1499_;
			_tmp1498_ = async_call;
			_tmp1499_ = ccall;
			_tmp1494_ = _tmp1498_ != _tmp1499_;
		} else {
			_tmp1494_ = FALSE;
		}
		if (_tmp1494_) {
			ValaHashMap* _tmp1500_;
			ValaCCodeConstant* _tmp1501_;
			ValaCCodeConstant* _tmp1502_;
			_tmp1500_ = out_arg_map;
			_tmp1501_ = vala_ccode_constant_new ("NULL");
			_tmp1502_ = _tmp1501_;
			vala_map_set ((ValaMap*) _tmp1500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1502_);
			_vala_ccode_node_unref0 (_tmp1502_);
		}
	}
	_tmp1503_ = ellipsis;
	if (_tmp1503_) {
		ValaMethod* _tmp1504_;
		_tmp1504_ = m;
		if (_tmp1504_ == NULL) {
			ValaHashMap* _tmp1505_;
			ValaCCodeConstant* _tmp1506_;
			ValaCCodeConstant* _tmp1507_;
			_tmp1505_ = in_arg_map;
			_tmp1506_ = vala_ccode_constant_new ("NULL");
			_tmp1507_ = _tmp1506_;
			vala_map_set ((ValaMap*) _tmp1505_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1507_);
			_vala_ccode_node_unref0 (_tmp1507_);
		} else {
			gboolean _tmp1508_ = FALSE;
			gboolean _tmp1509_ = FALSE;
			gboolean _tmp1510_ = FALSE;
			ValaMethod* _tmp1511_;
			gboolean _tmp1512_;
			gboolean _tmp1513_;
			_tmp1511_ = m;
			_tmp1512_ = vala_method_get_printf_format (_tmp1511_);
			_tmp1513_ = _tmp1512_;
			if (!_tmp1513_) {
				ValaMethod* _tmp1514_;
				gboolean _tmp1515_;
				gboolean _tmp1516_;
				_tmp1514_ = m;
				_tmp1515_ = vala_method_get_scanf_format (_tmp1514_);
				_tmp1516_ = _tmp1515_;
				_tmp1510_ = !_tmp1516_;
			} else {
				_tmp1510_ = FALSE;
			}
			if (_tmp1510_) {
				ValaMethod* _tmp1517_;
				gchar* _tmp1518_;
				gchar* _tmp1519_;
				_tmp1517_ = m;
				_tmp1518_ = vala_get_ccode_sentinel (_tmp1517_);
				_tmp1519_ = _tmp1518_;
				_tmp1509_ = g_strcmp0 (_tmp1519_, "") != 0;
				_g_free0 (_tmp1519_);
			} else {
				_tmp1509_ = FALSE;
			}
			if (_tmp1509_) {
				gboolean _tmp1520_;
				gboolean _tmp1521_;
				_tmp1520_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1521_ = _tmp1520_;
				_tmp1508_ = !_tmp1521_;
			} else {
				_tmp1508_ = FALSE;
			}
			if (_tmp1508_) {
				ValaHashMap* _tmp1522_;
				ValaMethod* _tmp1523_;
				gchar* _tmp1524_;
				gchar* _tmp1525_;
				ValaCCodeConstant* _tmp1526_;
				ValaCCodeConstant* _tmp1527_;
				_tmp1522_ = in_arg_map;
				_tmp1523_ = m;
				_tmp1524_ = vala_get_ccode_sentinel (_tmp1523_);
				_tmp1525_ = _tmp1524_;
				_tmp1526_ = vala_ccode_constant_new (_tmp1525_);
				_tmp1527_ = _tmp1526_;
				vala_map_set ((ValaMap*) _tmp1522_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1527_);
				_vala_ccode_node_unref0 (_tmp1527_);
				_g_free0 (_tmp1525_);
			}
		}
	}
	_tmp1528_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1528_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1529_;
		ValaDelegateType* _tmp1530_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1531_;
		ValaDelegate* _tmp1532_;
		ValaDelegate* _tmp1533_;
		ValaDelegate* _tmp1534_;
		ValaDelegate* _tmp1535_;
		gboolean _tmp1536_;
		gboolean _tmp1537_;
		_tmp1529_ = itype;
		_tmp1530_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1529_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1530_;
		_tmp1531_ = deleg_type;
		_tmp1532_ = vala_delegate_type_get_delegate_symbol (_tmp1531_);
		_tmp1533_ = _tmp1532_;
		_tmp1534_ = _vala_code_node_ref0 (_tmp1533_);
		d = _tmp1534_;
		_tmp1535_ = d;
		_tmp1536_ = vala_delegate_get_has_target (_tmp1535_);
		_tmp1537_ = _tmp1536_;
		if (_tmp1537_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1538_;
			ValaDelegate* _tmp1539_;
			ValaExpression* _tmp1540_;
			ValaExpression* _tmp1541_;
			ValaCCodeExpression* _tmp1542_ = NULL;
			ValaCCodeExpression* _tmp1543_;
			ValaCCodeExpression* _tmp1544_;
			ValaHashMap* _tmp1545_;
			ValaDelegate* _tmp1546_;
			ValaExpression* _tmp1547_;
			ValaExpression* _tmp1548_;
			ValaCCodeExpression* _tmp1549_ = NULL;
			ValaCCodeExpression* _tmp1550_;
			ValaCCodeExpression* _tmp1551_;
			_tmp1538_ = in_arg_map;
			_tmp1539_ = d;
			_tmp1540_ = vala_method_call_get_call (expr);
			_tmp1541_ = _tmp1540_;
			_tmp1543_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1541_, &_tmp1542_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1542_;
			_tmp1544_ = _tmp1543_;
			vala_map_set ((ValaMap*) _tmp1538_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1539_), FALSE)), _tmp1544_);
			_vala_ccode_node_unref0 (_tmp1544_);
			_tmp1545_ = out_arg_map;
			_tmp1546_ = d;
			_tmp1547_ = vala_method_call_get_call (expr);
			_tmp1548_ = _tmp1547_;
			_tmp1550_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1548_, &_tmp1549_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1549_;
			_tmp1551_ = _tmp1550_;
			vala_map_set ((ValaMap*) _tmp1545_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1546_), FALSE)), _tmp1551_);
			_vala_ccode_node_unref0 (_tmp1551_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1552_ = itype;
	_tmp1553_ = vala_data_type_get_return_type (_tmp1552_);
	_tmp1554_ = _tmp1553_;
	_tmp1555_ = vala_data_type_is_real_non_null_struct_type (_tmp1554_);
	_vala_code_node_unref0 (_tmp1554_);
	return_result_via_out_param = _tmp1555_;
	_tmp1557_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1557_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1558_;
		ValaDataType* _tmp1559_;
		ValaDataType* _tmp1560_;
		_tmp1558_ = itype;
		_tmp1559_ = vala_data_type_get_return_type (_tmp1558_);
		_tmp1560_ = _tmp1559_;
		_tmp1556_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1560_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1560_);
	} else {
		_tmp1556_ = FALSE;
	}
	if (_tmp1556_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1561_;
		ValaSignal* _tmp1562_;
		ValaSignal* _tmp1563_;
		ValaSignal* _tmp1564_;
		gboolean _tmp1565_ = FALSE;
		gboolean _tmp1566_ = FALSE;
		ValaMemberAccess* _tmp1567_;
		_tmp1561_ = itype;
		_tmp1562_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1561_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1563_ = _tmp1562_;
		_tmp1564_ = _vala_code_node_ref0 (_tmp1563_);
		sig = _tmp1564_;
		_tmp1567_ = ma;
		if (_tmp1567_ != NULL) {
			ValaMemberAccess* _tmp1568_;
			ValaExpression* _tmp1569_;
			ValaExpression* _tmp1570_;
			_tmp1568_ = ma;
			_tmp1569_ = vala_member_access_get_inner (_tmp1568_);
			_tmp1570_ = _tmp1569_;
			_tmp1566_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1570_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1566_ = FALSE;
		}
		if (_tmp1566_) {
			ValaSignal* _tmp1571_;
			gboolean _tmp1572_;
			gboolean _tmp1573_;
			_tmp1571_ = sig;
			_tmp1572_ = vala_signal_get_is_virtual (_tmp1571_);
			_tmp1573_ = _tmp1572_;
			_tmp1565_ = _tmp1573_;
		} else {
			_tmp1565_ = FALSE;
		}
		if (_tmp1565_) {
		} else {
			gboolean _tmp1574_ = FALSE;
			ValaSignal* _tmp1575_;
			_tmp1575_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1575_)) {
				_tmp1574_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1576_;
				ValaSourceReference* _tmp1577_;
				ValaSourceReference* _tmp1578_;
				ValaSourceFile* _tmp1579_;
				ValaSourceFile* _tmp1580_;
				ValaSignal* _tmp1581_;
				ValaSourceReference* _tmp1582_;
				ValaSourceReference* _tmp1583_;
				ValaSourceFile* _tmp1584_;
				ValaSourceFile* _tmp1585_;
				_tmp1576_ = ma;
				_tmp1577_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = vala_source_reference_get_file (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = sig;
				_tmp1582_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1581_);
				_tmp1583_ = _tmp1582_;
				_tmp1584_ = vala_source_reference_get_file (_tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1574_ = _tmp1580_ == _tmp1585_;
			}
			if (_tmp1574_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1586_ = async_call;
	_tmp1587_ = ccall;
	if (_tmp1586_ == _tmp1587_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1588_ = return_result_via_out_param;
	if (_tmp1588_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1589_;
		ValaDataType* _tmp1590_;
		ValaDataType* _tmp1591_;
		ValaLocalVariable* _tmp1592_;
		ValaLocalVariable* _tmp1593_;
		ValaLocalVariable* _tmp1594_;
		const gchar* _tmp1595_;
		const gchar* _tmp1596_;
		ValaCCodeExpression* _tmp1597_;
		ValaLocalVariable* _tmp1598_;
		ValaHashMap* _tmp1599_;
		ValaCCodeExpression* _tmp1600_;
		ValaCCodeUnaryExpression* _tmp1601_;
		ValaCCodeUnaryExpression* _tmp1602_;
		_tmp1589_ = itype;
		_tmp1590_ = vala_data_type_get_return_type (_tmp1589_);
		_tmp1591_ = _tmp1590_;
		_tmp1592_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1591_, TRUE, NULL, TRUE);
		_tmp1593_ = _tmp1592_;
		_vala_code_node_unref0 (_tmp1591_);
		out_param_var = _tmp1593_;
		_tmp1594_ = out_param_var;
		_tmp1595_ = vala_symbol_get_name ((ValaSymbol*) _tmp1594_);
		_tmp1596_ = _tmp1595_;
		_tmp1597_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1596_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1597_;
		_tmp1598_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1598_);
		_tmp1599_ = out_arg_map;
		_tmp1600_ = out_param_ref;
		_tmp1601_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1600_);
		_tmp1602_ = _tmp1601_;
		vala_map_set ((ValaMap*) _tmp1599_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1602_);
		_vala_ccode_node_unref0 (_tmp1602_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1603_ = async_call;
	_tmp1604_ = ccall;
	if (_tmp1603_ != _tmp1604_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1621_;
			ValaCCodeFunctionCall* _tmp1622_;
			ValaHashMap* _tmp1623_;
			gint _tmp1624_;
			gpointer _tmp1625_;
			ValaCCodeExpression* _tmp1626_;
			gint _tmp1627_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1605_;
				ValaSet* _tmp1606_;
				ValaSet* _tmp1607_;
				ValaIterator* _tmp1608_;
				ValaIterator* _tmp1609_;
				_tmp1605_ = out_arg_map;
				_tmp1606_ = vala_map_get_keys ((ValaMap*) _tmp1605_);
				_tmp1607_ = _tmp1606_;
				_tmp1608_ = vala_iterable_iterator ((ValaIterable*) _tmp1607_);
				_tmp1609_ = _tmp1608_;
				_vala_iterable_unref0 (_tmp1607_);
				_pos_it = _tmp1609_;
				while (TRUE) {
					ValaIterator* _tmp1610_;
					gint pos = 0;
					ValaIterator* _tmp1611_;
					gpointer _tmp1612_;
					gboolean _tmp1613_ = FALSE;
					gint _tmp1614_;
					gint _tmp1615_;
					_tmp1610_ = _pos_it;
					if (!vala_iterator_next (_tmp1610_)) {
						break;
					}
					_tmp1611_ = _pos_it;
					_tmp1612_ = vala_iterator_get (_tmp1611_);
					pos = (gint) ((gintptr) _tmp1612_);
					_tmp1614_ = pos;
					_tmp1615_ = last_pos;
					if (_tmp1614_ > _tmp1615_) {
						gboolean _tmp1616_ = FALSE;
						gint _tmp1617_;
						_tmp1617_ = min_pos;
						if (_tmp1617_ == -1) {
							_tmp1616_ = TRUE;
						} else {
							gint _tmp1618_;
							gint _tmp1619_;
							_tmp1618_ = pos;
							_tmp1619_ = min_pos;
							_tmp1616_ = _tmp1618_ < _tmp1619_;
						}
						_tmp1613_ = _tmp1616_;
					} else {
						_tmp1613_ = FALSE;
					}
					if (_tmp1613_) {
						gint _tmp1620_;
						_tmp1620_ = pos;
						min_pos = _tmp1620_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1621_ = min_pos;
			if (_tmp1621_ == -1) {
				break;
			}
			_tmp1622_ = ccall;
			_tmp1623_ = out_arg_map;
			_tmp1624_ = min_pos;
			_tmp1625_ = vala_map_get ((ValaMap*) _tmp1623_, (gpointer) ((gintptr) _tmp1624_));
			_tmp1626_ = (ValaCCodeExpression*) _tmp1625_;
			vala_ccode_function_call_add_argument (_tmp1622_, _tmp1626_);
			_vala_ccode_node_unref0 (_tmp1626_);
			_tmp1627_ = min_pos;
			last_pos = _tmp1627_;
		}
	}
	_tmp1628_ = async_call;
	if (_tmp1628_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1645_;
			ValaCCodeFunctionCall* _tmp1646_;
			ValaHashMap* _tmp1647_;
			gint _tmp1648_;
			gpointer _tmp1649_;
			ValaCCodeExpression* _tmp1650_;
			gint _tmp1651_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1629_;
				ValaSet* _tmp1630_;
				ValaSet* _tmp1631_;
				ValaIterator* _tmp1632_;
				ValaIterator* _tmp1633_;
				_tmp1629_ = in_arg_map;
				_tmp1630_ = vala_map_get_keys ((ValaMap*) _tmp1629_);
				_tmp1631_ = _tmp1630_;
				_tmp1632_ = vala_iterable_iterator ((ValaIterable*) _tmp1631_);
				_tmp1633_ = _tmp1632_;
				_vala_iterable_unref0 (_tmp1631_);
				_pos_it = _tmp1633_;
				while (TRUE) {
					ValaIterator* _tmp1634_;
					gint pos = 0;
					ValaIterator* _tmp1635_;
					gpointer _tmp1636_;
					gboolean _tmp1637_ = FALSE;
					gint _tmp1638_;
					gint _tmp1639_;
					_tmp1634_ = _pos_it;
					if (!vala_iterator_next (_tmp1634_)) {
						break;
					}
					_tmp1635_ = _pos_it;
					_tmp1636_ = vala_iterator_get (_tmp1635_);
					pos = (gint) ((gintptr) _tmp1636_);
					_tmp1638_ = pos;
					_tmp1639_ = last_pos;
					if (_tmp1638_ > _tmp1639_) {
						gboolean _tmp1640_ = FALSE;
						gint _tmp1641_;
						_tmp1641_ = min_pos;
						if (_tmp1641_ == -1) {
							_tmp1640_ = TRUE;
						} else {
							gint _tmp1642_;
							gint _tmp1643_;
							_tmp1642_ = pos;
							_tmp1643_ = min_pos;
							_tmp1640_ = _tmp1642_ < _tmp1643_;
						}
						_tmp1637_ = _tmp1640_;
					} else {
						_tmp1637_ = FALSE;
					}
					if (_tmp1637_) {
						gint _tmp1644_;
						_tmp1644_ = pos;
						min_pos = _tmp1644_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1645_ = min_pos;
			if (_tmp1645_ == -1) {
				break;
			}
			_tmp1646_ = async_call;
			_tmp1647_ = in_arg_map;
			_tmp1648_ = min_pos;
			_tmp1649_ = vala_map_get ((ValaMap*) _tmp1647_, (gpointer) ((gintptr) _tmp1648_));
			_tmp1650_ = (ValaCCodeExpression*) _tmp1649_;
			vala_ccode_function_call_add_argument (_tmp1646_, _tmp1650_);
			_vala_ccode_node_unref0 (_tmp1650_);
			_tmp1651_ = min_pos;
			last_pos = _tmp1651_;
		}
	}
	_tmp1652_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1653_ = _tmp1652_;
	if (_tmp1653_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1654_;
		gint _tmp1655_;
		ValaCCodeFunction* _tmp1656_;
		ValaCCodeFunction* _tmp1657_;
		ValaCCodeIdentifier* _tmp1658_;
		ValaCCodeIdentifier* _tmp1659_;
		ValaCCodeMemberAccess* _tmp1660_;
		ValaCCodeMemberAccess* _tmp1661_;
		gint _tmp1662_;
		gchar* _tmp1663_;
		gchar* _tmp1664_;
		ValaCCodeConstant* _tmp1665_;
		ValaCCodeConstant* _tmp1666_;
		ValaCCodeFunction* _tmp1667_;
		ValaCCodeFunction* _tmp1668_;
		ValaCCodeFunctionCall* _tmp1669_;
		ValaCCodeFunction* _tmp1670_;
		ValaCCodeFunction* _tmp1671_;
		ValaCCodeConstant* _tmp1672_;
		ValaCCodeConstant* _tmp1673_;
		ValaCCodeFunction* _tmp1674_;
		ValaCCodeFunction* _tmp1675_;
		gint _tmp1676_;
		gchar* _tmp1677_;
		gchar* _tmp1678_;
		_tmp1654_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1655_ = _tmp1654_->next_coroutine_state;
		_tmp1654_->next_coroutine_state = _tmp1655_ + 1;
		state = _tmp1655_;
		_tmp1656_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1657_ = _tmp1656_;
		_tmp1658_ = vala_ccode_identifier_new ("_data_");
		_tmp1659_ = _tmp1658_;
		_tmp1660_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1659_, "_state_");
		_tmp1661_ = _tmp1660_;
		_tmp1662_ = state;
		_tmp1663_ = g_strdup_printf ("%i", _tmp1662_);
		_tmp1664_ = _tmp1663_;
		_tmp1665_ = vala_ccode_constant_new (_tmp1664_);
		_tmp1666_ = _tmp1665_;
		vala_ccode_function_add_assignment (_tmp1657_, (ValaCCodeExpression*) _tmp1661_, (ValaCCodeExpression*) _tmp1666_);
		_vala_ccode_node_unref0 (_tmp1666_);
		_g_free0 (_tmp1664_);
		_vala_ccode_node_unref0 (_tmp1661_);
		_vala_ccode_node_unref0 (_tmp1659_);
		_tmp1667_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1668_ = _tmp1667_;
		_tmp1669_ = async_call;
		vala_ccode_function_add_expression (_tmp1668_, (ValaCCodeExpression*) _tmp1669_);
		_tmp1670_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1671_ = _tmp1670_;
		_tmp1672_ = vala_ccode_constant_new ("FALSE");
		_tmp1673_ = _tmp1672_;
		vala_ccode_function_add_return (_tmp1671_, (ValaCCodeExpression*) _tmp1673_);
		_vala_ccode_node_unref0 (_tmp1673_);
		_tmp1674_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1675_ = _tmp1674_;
		_tmp1676_ = state;
		_tmp1677_ = g_strdup_printf ("_state_%d", _tmp1676_);
		_tmp1678_ = _tmp1677_;
		vala_ccode_function_add_label (_tmp1675_, _tmp1678_);
		_g_free0 (_tmp1678_);
	}
	_tmp1679_ = vala_method_call_get_is_assert (expr);
	_tmp1680_ = _tmp1679_;
	if (_tmp1680_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1681_;
		ValaSourceReference* _tmp1682_;
		ValaSourceLocation _tmp1683_ = {0};
		ValaSourceLocation _tmp1684_;
		gchar* _tmp1685_;
		ValaSourceReference* _tmp1686_;
		ValaSourceReference* _tmp1687_;
		ValaSourceLocation _tmp1688_ = {0};
		ValaSourceLocation _tmp1689_;
		gchar* _tmp1690_;
		ValaSourceReference* _tmp1691_;
		ValaSourceReference* _tmp1692_;
		ValaSourceLocation _tmp1693_ = {0};
		ValaSourceLocation _tmp1694_;
		gchar* _tmp1695_;
		gchar* _tmp1696_;
		ValaCCodeFunctionCall* _tmp1697_;
		ValaCCodeIdentifier* _tmp1698_;
		ValaCCodeIdentifier* _tmp1699_;
		ValaCCodeFunctionCall* _tmp1700_;
		const gchar* _tmp1701_;
		gchar* _tmp1702_;
		gchar* _tmp1703_;
		gchar* _tmp1704_;
		gchar* _tmp1705_;
		gchar* _tmp1706_;
		gchar* _tmp1707_;
		ValaCCodeConstant* _tmp1708_;
		ValaCCodeConstant* _tmp1709_;
		_tmp1681_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1682_ = _tmp1681_;
		vala_source_reference_get_begin (_tmp1682_, &_tmp1683_);
		_tmp1684_ = _tmp1683_;
		_tmp1685_ = _tmp1684_.pos;
		_tmp1686_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1687_ = _tmp1686_;
		vala_source_reference_get_end (_tmp1687_, &_tmp1688_);
		_tmp1689_ = _tmp1688_;
		_tmp1690_ = _tmp1689_.pos;
		_tmp1691_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1692_ = _tmp1691_;
		vala_source_reference_get_begin (_tmp1692_, &_tmp1693_);
		_tmp1694_ = _tmp1693_;
		_tmp1695_ = _tmp1694_.pos;
		_tmp1696_ = string_substring ((const gchar*) _tmp1685_, (glong) 0, (glong) ((gint) (_tmp1690_ - _tmp1695_)));
		message = _tmp1696_;
		_tmp1697_ = ccall;
		_tmp1698_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1699_ = _tmp1698_;
		vala_ccode_function_call_set_call (_tmp1697_, (ValaCCodeExpression*) _tmp1699_);
		_vala_ccode_node_unref0 (_tmp1699_);
		_tmp1700_ = ccall;
		_tmp1701_ = message;
		_tmp1702_ = string_replace (_tmp1701_, "\n", " ");
		_tmp1703_ = _tmp1702_;
		_tmp1704_ = g_strescape (_tmp1703_, "");
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = g_strdup_printf ("\"%s\"", _tmp1705_);
		_tmp1707_ = _tmp1706_;
		_tmp1708_ = vala_ccode_constant_new (_tmp1707_);
		_tmp1709_ = _tmp1708_;
		vala_ccode_function_call_add_argument (_tmp1700_, (ValaCCodeExpression*) _tmp1709_);
		_vala_ccode_node_unref0 (_tmp1709_);
		_g_free0 (_tmp1707_);
		_g_free0 (_tmp1705_);
		_g_free0 (_tmp1703_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1710_ = return_result_via_out_param;
	if (_tmp1710_) {
		ValaCCodeFunction* _tmp1711_;
		ValaCCodeFunction* _tmp1712_;
		ValaCCodeExpression* _tmp1713_;
		ValaCCodeExpression* _tmp1714_;
		ValaCCodeExpression* _tmp1715_;
		_tmp1711_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1712_ = _tmp1711_;
		_tmp1713_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1712_, _tmp1713_);
		_tmp1714_ = out_param_ref;
		_tmp1715_ = _vala_ccode_node_ref0 (_tmp1714_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1715_;
	}
	_tmp1718_ = m;
	if (_tmp1718_ != NULL) {
		ValaMethod* _tmp1719_;
		ValaMemberBinding _tmp1720_;
		ValaMemberBinding _tmp1721_;
		_tmp1719_ = m;
		_tmp1720_ = vala_method_get_binding (_tmp1719_);
		_tmp1721_ = _tmp1720_;
		_tmp1717_ = _tmp1721_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1717_ = FALSE;
	}
	if (_tmp1717_) {
		ValaMethod* _tmp1722_;
		gboolean _tmp1723_;
		gboolean _tmp1724_;
		_tmp1722_ = m;
		_tmp1723_ = vala_method_get_returns_modified_pointer (_tmp1722_);
		_tmp1724_ = _tmp1723_;
		_tmp1716_ = _tmp1724_;
	} else {
		_tmp1716_ = FALSE;
	}
	if (_tmp1716_) {
		gboolean _tmp1725_ = FALSE;
		gboolean _tmp1726_ = FALSE;
		ValaMemberAccess* _tmp1727_;
		_tmp1727_ = ma;
		if (_tmp1727_ != NULL) {
			ValaMemberAccess* _tmp1728_;
			ValaExpression* _tmp1729_;
			ValaExpression* _tmp1730_;
			ValaSymbol* _tmp1731_;
			ValaSymbol* _tmp1732_;
			_tmp1728_ = ma;
			_tmp1729_ = vala_member_access_get_inner (_tmp1728_);
			_tmp1730_ = _tmp1729_;
			_tmp1731_ = vala_expression_get_symbol_reference (_tmp1730_);
			_tmp1732_ = _tmp1731_;
			_tmp1726_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1732_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1726_ = FALSE;
		}
		if (_tmp1726_) {
			ValaMemberAccess* _tmp1733_;
			ValaExpression* _tmp1734_;
			ValaExpression* _tmp1735_;
			_tmp1733_ = ma;
			_tmp1734_ = vala_member_access_get_inner (_tmp1733_);
			_tmp1735_ = _tmp1734_;
			_tmp1725_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1735_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1725_ = FALSE;
		}
		if (_tmp1725_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1736_;
			ValaExpression* _tmp1737_;
			ValaExpression* _tmp1738_;
			ValaSymbol* _tmp1739_;
			ValaSymbol* _tmp1740_;
			ValaProperty* _tmp1741_;
			ValaProperty* _tmp1742_;
			ValaMemberAccess* _tmp1743_;
			ValaExpression* _tmp1744_;
			ValaExpression* _tmp1745_;
			ValaExpression* _tmp1746_;
			ValaExpression* _tmp1747_;
			ValaDataType* _tmp1748_;
			ValaDataType* _tmp1749_;
			ValaCCodeExpression* _tmp1750_;
			ValaGLibValue* _tmp1751_;
			ValaGLibValue* _tmp1752_;
			_tmp1736_ = ma;
			_tmp1737_ = vala_member_access_get_inner (_tmp1736_);
			_tmp1738_ = _tmp1737_;
			_tmp1739_ = vala_expression_get_symbol_reference (_tmp1738_);
			_tmp1740_ = _tmp1739_;
			_tmp1741_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1740_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1741_;
			_tmp1742_ = prop;
			_tmp1743_ = ma;
			_tmp1744_ = vala_member_access_get_inner (_tmp1743_);
			_tmp1745_ = _tmp1744_;
			_tmp1746_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1745_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1747_ = _tmp1746_;
			_tmp1748_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1749_ = _tmp1748_;
			_tmp1750_ = ccall_expr;
			_tmp1751_ = vala_glib_value_new (_tmp1749_, _tmp1750_, FALSE);
			_tmp1752_ = _tmp1751_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1742_, _tmp1747_, (ValaTargetValue*) _tmp1752_);
			_vala_target_value_unref0 (_tmp1752_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1753_;
			ValaCCodeExpression* _tmp1754_;
			ValaCCodeAssignment* _tmp1755_;
			_tmp1753_ = instance;
			_tmp1754_ = ccall_expr;
			_tmp1755_ = vala_ccode_assignment_new (_tmp1753_, _tmp1754_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1755_;
		}
	}
	_tmp1758_ = m;
	if (_tmp1758_ != NULL) {
		ValaMethod* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		_tmp1759_ = m;
		_tmp1760_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1757_ = _tmp1761_ != NULL;
		_g_free0 (_tmp1761_);
	} else {
		_tmp1757_ = FALSE;
	}
	if (_tmp1757_) {
		ValaMethod* _tmp1762_;
		gchar* _tmp1763_;
		gchar* _tmp1764_;
		ValaMethod* _tmp1765_;
		ValaDataType* _tmp1766_;
		ValaDataType* _tmp1767_;
		gchar* _tmp1768_;
		gchar* _tmp1769_;
		_tmp1762_ = m;
		_tmp1763_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1762_);
		_tmp1764_ = _tmp1763_;
		_tmp1765_ = m;
		_tmp1766_ = vala_callable_get_return_type ((ValaCallable*) _tmp1765_);
		_tmp1767_ = _tmp1766_;
		_tmp1768_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1767_);
		_tmp1769_ = _tmp1768_;
		_tmp1756_ = g_strcmp0 (_tmp1764_, _tmp1769_) != 0;
		_g_free0 (_tmp1769_);
		_g_free0 (_tmp1764_);
	} else {
		_tmp1756_ = FALSE;
	}
	if (_tmp1756_) {
		ValaCCodeExpression* _tmp1770_;
		ValaMethod* _tmp1771_;
		ValaDataType* _tmp1772_;
		ValaDataType* _tmp1773_;
		gchar* _tmp1774_;
		gchar* _tmp1775_;
		ValaCCodeCastExpression* _tmp1776_;
		_tmp1770_ = ccall_expr;
		_tmp1771_ = m;
		_tmp1772_ = vala_callable_get_return_type ((ValaCallable*) _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_tmp1774_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1776_ = vala_ccode_cast_expression_new (_tmp1770_, _tmp1775_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1776_;
		_g_free0 (_tmp1775_);
	}
	_tmp1777_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1777_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1778_;
		ValaList* _tmp1779_;
		ValaIterator* _tmp1780_;
		ValaIterator* _tmp1781_;
		ValaIterator* _tmp1782_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1783_;
		gpointer _tmp1784_;
		ValaExpression* _tmp1785_;
		ValaCCodeExpression* _tmp1786_;
		ValaCCodeExpression* _tmp1787_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1788_;
		ValaLocalVariable* _tmp1789_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1790_;
		const gchar* _tmp1791_;
		const gchar* _tmp1792_;
		ValaCCodeExpression* _tmp1793_;
		ValaLocalVariable* _tmp1794_;
		ValaCCodeFile* _tmp1795_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1796_;
		ValaExpression* _tmp1797_;
		ValaExpression* _tmp1798_;
		ValaCCodeExpression* _tmp1799_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1800_;
		ValaExpression* _tmp1801_;
		ValaExpression* _tmp1802_;
		ValaCCodeExpression* _tmp1803_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1804_;
		ValaExpression* _tmp1805_;
		ValaExpression* _tmp1806_;
		ValaDataType* _tmp1807_;
		ValaDataType* _tmp1808_;
		ValaArrayType* _tmp1809_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1810_;
		ValaDataType* _tmp1811_;
		ValaDataType* _tmp1812_;
		gchar* _tmp1813_;
		gchar* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		ValaCCodeIdentifier* _tmp1817_;
		ValaCCodeIdentifier* _tmp1818_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1819_;
		ValaCCodeExpression* _tmp1820_;
		ValaCCodeBinaryExpression* _tmp1821_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1822_;
		ValaCCodeExpression* _tmp1823_;
		ValaCCodeBinaryExpression* _tmp1824_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1825_;
		ValaCCodeIdentifier* _tmp1826_;
		ValaCCodeFunctionCall* _tmp1827_;
		ValaCCodeFunctionCall* _tmp1828_;
		ValaCCodeFunctionCall* _tmp1829_;
		ValaCCodeExpression* _tmp1830_;
		ValaCCodeExpression* _tmp1831_;
		ValaCCodeBinaryExpression* _tmp1832_;
		ValaCCodeBinaryExpression* _tmp1833_;
		ValaCCodeFunctionCall* _tmp1834_;
		ValaCCodeConstant* _tmp1835_;
		ValaCCodeConstant* _tmp1836_;
		ValaCCodeFunctionCall* _tmp1837_;
		ValaCCodeIdentifier* _tmp1838_;
		ValaCCodeBinaryExpression* _tmp1839_;
		ValaCCodeBinaryExpression* _tmp1840_;
		ValaCCodeBinaryExpression* _tmp1841_;
		ValaCCodeFunction* _tmp1842_;
		ValaCCodeFunction* _tmp1843_;
		ValaCCodeExpression* _tmp1844_;
		ValaCCodeExpression* _tmp1845_;
		ValaCCodeFunction* _tmp1846_;
		ValaCCodeFunction* _tmp1847_;
		ValaCCodeExpression* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeFunction* _tmp1850_;
		ValaCCodeBinaryExpression* _tmp1851_;
		ValaCCodeFunctionCall* _tmp1852_;
		ValaCCodeConstant* _tmp1853_;
		ValaCCodeConstant* _tmp1854_;
		ValaCCodeConditionalExpression* _tmp1855_;
		ValaCCodeConditionalExpression* _tmp1856_;
		ValaCCodeFunction* _tmp1857_;
		ValaCCodeFunction* _tmp1858_;
		ValaMemberAccess* _tmp1859_;
		ValaExpression* _tmp1860_;
		ValaExpression* _tmp1861_;
		ValaCCodeExpression* _tmp1862_;
		ValaCCodeExpression* _tmp1863_;
		ValaCCodeExpression* _tmp1864_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1865_;
		ValaExpression* _tmp1866_;
		ValaExpression* _tmp1867_;
		ValaSymbol* _tmp1868_;
		ValaSymbol* _tmp1869_;
		ValaSymbol* _tmp1870_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1871_;
		ValaLocalVariable* _tmp1872_;
		gboolean _tmp1873_ = FALSE;
		gboolean _tmp1874_ = FALSE;
		ValaSymbol* _tmp1875_;
		_tmp1778_ = vala_method_call_get_argument_list (expr);
		_tmp1779_ = _tmp1778_;
		_tmp1780_ = vala_iterable_iterator ((ValaIterable*) _tmp1779_);
		_tmp1781_ = _tmp1780_;
		_vala_iterable_unref0 (_tmp1779_);
		arg_it = _tmp1781_;
		_tmp1782_ = arg_it;
		vala_iterator_next (_tmp1782_);
		_tmp1783_ = arg_it;
		_tmp1784_ = vala_iterator_get (_tmp1783_);
		_tmp1785_ = (ValaExpression*) _tmp1784_;
		_tmp1786_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1785_);
		_tmp1787_ = _tmp1786_;
		_vala_code_node_unref0 (_tmp1785_);
		new_size = _tmp1787_;
		_tmp1788_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1789_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1788_, TRUE, NULL, FALSE);
		temp_decl = _tmp1789_;
		_tmp1790_ = temp_decl;
		_tmp1791_ = vala_symbol_get_name ((ValaSymbol*) _tmp1790_);
		_tmp1792_ = _tmp1791_;
		_tmp1793_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1792_);
		temp_ref = _tmp1793_;
		_tmp1794_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1794_);
		_tmp1795_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1795_, "string.h", FALSE);
		_tmp1796_ = ma;
		_tmp1797_ = vala_member_access_get_inner (_tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1798_, 1);
		clen = _tmp1799_;
		_tmp1800_ = ma;
		_tmp1801_ = vala_member_access_get_inner (_tmp1800_);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1802_);
		celems = _tmp1803_;
		_tmp1804_ = ma;
		_tmp1805_ = vala_member_access_get_inner (_tmp1804_);
		_tmp1806_ = _tmp1805_;
		_tmp1807_ = vala_expression_get_value_type (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1808_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1809_;
		_tmp1810_ = array_type;
		_tmp1811_ = vala_array_type_get_element_type (_tmp1810_);
		_tmp1812_ = _tmp1811_;
		_tmp1813_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = g_strdup_printf ("sizeof (%s)", _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1817_ = vala_ccode_identifier_new (_tmp1816_);
		_tmp1818_ = _tmp1817_;
		_g_free0 (_tmp1816_);
		_g_free0 (_tmp1814_);
		csizeof = _tmp1818_;
		_tmp1819_ = temp_ref;
		_tmp1820_ = clen;
		_tmp1821_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1819_, _tmp1820_);
		cdelta = _tmp1821_;
		_tmp1822_ = temp_ref;
		_tmp1823_ = clen;
		_tmp1824_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1822_, _tmp1823_);
		ccheck = _tmp1824_;
		_tmp1825_ = vala_ccode_identifier_new ("memset");
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_vala_ccode_node_unref0 (_tmp1826_);
		czero = _tmp1828_;
		_tmp1829_ = czero;
		_tmp1830_ = celems;
		_tmp1831_ = clen;
		_tmp1832_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1830_, _tmp1831_);
		_tmp1833_ = _tmp1832_;
		vala_ccode_function_call_add_argument (_tmp1829_, (ValaCCodeExpression*) _tmp1833_);
		_vala_ccode_node_unref0 (_tmp1833_);
		_tmp1834_ = czero;
		_tmp1835_ = vala_ccode_constant_new ("0");
		_tmp1836_ = _tmp1835_;
		vala_ccode_function_call_add_argument (_tmp1834_, (ValaCCodeExpression*) _tmp1836_);
		_vala_ccode_node_unref0 (_tmp1836_);
		_tmp1837_ = czero;
		_tmp1838_ = csizeof;
		_tmp1839_ = cdelta;
		_tmp1840_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1838_, (ValaCCodeExpression*) _tmp1839_);
		_tmp1841_ = _tmp1840_;
		vala_ccode_function_call_add_argument (_tmp1837_, (ValaCCodeExpression*) _tmp1841_);
		_vala_ccode_node_unref0 (_tmp1841_);
		_tmp1842_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1843_ = _tmp1842_;
		_tmp1844_ = temp_ref;
		_tmp1845_ = new_size;
		vala_ccode_function_add_assignment (_tmp1843_, _tmp1844_, _tmp1845_);
		_tmp1846_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1847_, _tmp1848_);
		_tmp1849_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = ccheck;
		_tmp1852_ = czero;
		_tmp1853_ = vala_ccode_constant_new ("NULL");
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1851_, (ValaCCodeExpression*) _tmp1852_, (ValaCCodeExpression*) _tmp1854_);
		_tmp1856_ = _tmp1855_;
		vala_ccode_function_add_expression (_tmp1850_, (ValaCCodeExpression*) _tmp1856_);
		_vala_ccode_node_unref0 (_tmp1856_);
		_vala_ccode_node_unref0 (_tmp1854_);
		_tmp1857_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = ma;
		_tmp1860_ = vala_member_access_get_inner (_tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1862_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1861_, 1);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1858_, _tmp1863_, _tmp1864_);
		_vala_ccode_node_unref0 (_tmp1863_);
		_tmp1865_ = ma;
		_tmp1866_ = vala_member_access_get_inner (_tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = vala_expression_get_symbol_reference (_tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = _vala_code_node_ref0 (_tmp1869_);
		array_var = _tmp1870_;
		_tmp1871_ = array_var;
		_tmp1872_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1871_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1871_) : NULL);
		array_local = _tmp1872_;
		_tmp1875_ = array_var;
		if (_tmp1875_ != NULL) {
			ValaSymbol* _tmp1876_;
			_tmp1876_ = array_var;
			_tmp1874_ = vala_symbol_is_internal_symbol (_tmp1876_);
		} else {
			_tmp1874_ = FALSE;
		}
		if (_tmp1874_) {
			gboolean _tmp1877_ = FALSE;
			gboolean _tmp1878_ = FALSE;
			ValaSymbol* _tmp1879_;
			_tmp1879_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1879_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1880_;
				gboolean _tmp1881_;
				gboolean _tmp1882_;
				_tmp1880_ = array_local;
				_tmp1881_ = vala_local_variable_get_captured (_tmp1880_);
				_tmp1882_ = _tmp1881_;
				_tmp1878_ = !_tmp1882_;
			} else {
				_tmp1878_ = FALSE;
			}
			if (_tmp1878_) {
				_tmp1877_ = TRUE;
			} else {
				ValaSymbol* _tmp1883_;
				_tmp1883_ = array_var;
				_tmp1877_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1883_, VALA_TYPE_FIELD);
			}
			_tmp1873_ = _tmp1877_;
		} else {
			_tmp1873_ = FALSE;
		}
		if (_tmp1873_) {
			ValaCCodeFunction* _tmp1884_;
			ValaCCodeFunction* _tmp1885_;
			ValaMemberAccess* _tmp1886_;
			ValaExpression* _tmp1887_;
			ValaExpression* _tmp1888_;
			ValaTargetValue* _tmp1889_;
			ValaTargetValue* _tmp1890_;
			ValaCCodeExpression* _tmp1891_;
			ValaCCodeExpression* _tmp1892_;
			ValaCCodeExpression* _tmp1893_;
			_tmp1884_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1885_ = _tmp1884_;
			_tmp1886_ = ma;
			_tmp1887_ = vala_member_access_get_inner (_tmp1886_);
			_tmp1888_ = _tmp1887_;
			_tmp1889_ = vala_expression_get_target_value (_tmp1888_);
			_tmp1890_ = _tmp1889_;
			_tmp1891_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1890_);
			_tmp1892_ = _tmp1891_;
			_tmp1893_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1885_, _tmp1892_, _tmp1893_);
			_vala_ccode_node_unref0 (_tmp1892_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1895_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1896_ = _tmp1895_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1896_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1897_;
		ValaDataType* _tmp1898_;
		_tmp1897_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1898_ = _tmp1897_;
		_tmp1894_ = !vala_data_type_is_disposable (_tmp1898_);
	} else {
		_tmp1894_ = FALSE;
	}
	if (_tmp1894_) {
		gboolean _tmp1899_ = FALSE;
		ValaCCodeExpression* _tmp1900_;
		_tmp1900_ = ccall_expr;
		if (_tmp1900_ != NULL) {
			gboolean _tmp1901_;
			_tmp1901_ = return_result_via_out_param;
			_tmp1899_ = !_tmp1901_;
		} else {
			_tmp1899_ = FALSE;
		}
		if (_tmp1899_) {
			ValaCCodeFunction* _tmp1902_;
			ValaCCodeFunction* _tmp1903_;
			ValaCCodeExpression* _tmp1904_;
			_tmp1902_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1903_ = _tmp1902_;
			_tmp1904_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1903_, _tmp1904_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1905_;
		ValaDataType* _tmp1906_;
		gboolean _tmp1907_ = FALSE;
		ValaDataType* _tmp1908_;
		ValaDataType* _tmp1909_;
		gboolean _tmp1936_ = FALSE;
		ValaMethod* _tmp1937_;
		_tmp1905_ = itype;
		_tmp1906_ = vala_data_type_get_return_type (_tmp1905_);
		result_type = _tmp1906_;
		_tmp1908_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1909_ = _tmp1908_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1909_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1910_;
			ValaDataType* _tmp1911_;
			_tmp1910_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1911_ = _tmp1910_;
			_tmp1907_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1911_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1907_ = FALSE;
		}
		if (_tmp1907_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1912_;
			ValaDataType* _tmp1913_;
			ValaTypeParameter* _tmp1914_;
			ValaTypeParameter* _tmp1915_;
			ValaTypeParameter* _tmp1916_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1917_;
			ValaSymbol* _tmp1918_;
			ValaSymbol* _tmp1919_;
			ValaSymbol* _tmp1920_;
			ValaSymbol* _tmp1921_;
			ValaStruct* _tmp1922_;
			gboolean _tmp1923_ = FALSE;
			ValaTypeParameter* _tmp1924_;
			ValaSymbol* _tmp1925_;
			ValaSymbol* _tmp1926_;
			ValaTypeSymbol* _tmp1927_;
			_tmp1912_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1913_ = _tmp1912_;
			_tmp1914_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1913_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1915_ = _tmp1914_;
			_tmp1916_ = _vala_code_node_ref0 (_tmp1915_);
			type_parameter = _tmp1916_;
			_tmp1917_ = type_parameter;
			_tmp1918_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1917_);
			_tmp1919_ = _tmp1918_;
			_tmp1920_ = vala_symbol_get_parent_symbol (_tmp1919_);
			_tmp1921_ = _tmp1920_;
			_tmp1922_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1921_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1921_) : NULL);
			st = _tmp1922_;
			_tmp1924_ = type_parameter;
			_tmp1925_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1924_);
			_tmp1926_ = _tmp1925_;
			_tmp1927_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1926_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1927_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1923_ = TRUE;
			} else {
				gboolean _tmp1928_ = FALSE;
				ValaStruct* _tmp1929_;
				_tmp1929_ = st;
				if (_tmp1929_ != NULL) {
					ValaStruct* _tmp1930_;
					gchar* _tmp1931_;
					gchar* _tmp1932_;
					_tmp1930_ = st;
					_tmp1931_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1930_);
					_tmp1932_ = _tmp1931_;
					_tmp1928_ = g_strcmp0 (_tmp1932_, "va_list") == 0;
					_g_free0 (_tmp1932_);
				} else {
					_tmp1928_ = FALSE;
				}
				_tmp1923_ = _tmp1928_;
			}
			if (_tmp1923_) {
				ValaDataType* _tmp1933_;
				ValaDataType* _tmp1934_;
				ValaDataType* _tmp1935_;
				_tmp1933_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1934_ = _tmp1933_;
				_tmp1935_ = _vala_code_node_ref0 (_tmp1934_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1935_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1937_ = m;
		if (_tmp1937_ != NULL) {
			ValaMethod* _tmp1938_;
			_tmp1938_ = m;
			_tmp1936_ = vala_method_get_format_arg_index (_tmp1938_) >= 0;
		} else {
			_tmp1936_ = FALSE;
		}
		if (_tmp1936_) {
			ValaCCodeExpression* _tmp1939_;
			_tmp1939_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1939_);
		} else {
			gboolean _tmp1940_ = FALSE;
			ValaMethod* _tmp1941_;
			_tmp1941_ = m;
			if (_tmp1941_ != NULL) {
				ValaMethod* _tmp1942_;
				_tmp1942_ = m;
				_tmp1940_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1942_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1940_ = FALSE;
			}
			if (_tmp1940_) {
				ValaCCodeExpression* _tmp1943_;
				_tmp1943_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1943_);
			} else {
				gboolean _tmp1944_ = FALSE;
				gboolean _tmp1945_ = FALSE;
				gboolean _tmp1946_;
				_tmp1946_ = return_result_via_out_param;
				if (!_tmp1946_) {
					gboolean _tmp1947_ = FALSE;
					gboolean _tmp1948_ = FALSE;
					ValaMethod* _tmp1949_;
					_tmp1949_ = m;
					if (_tmp1949_ != NULL) {
						ValaMethod* _tmp1950_;
						_tmp1950_ = m;
						_tmp1948_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1950_);
					} else {
						_tmp1948_ = FALSE;
					}
					if (_tmp1948_) {
						_tmp1947_ = TRUE;
					} else {
						gboolean _tmp1951_ = FALSE;
						ValaDelegate* _tmp1952_;
						_tmp1952_ = deleg;
						if (_tmp1952_ != NULL) {
							ValaDelegate* _tmp1953_;
							_tmp1953_ = deleg;
							_tmp1951_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1953_);
						} else {
							_tmp1951_ = FALSE;
						}
						_tmp1947_ = _tmp1951_;
					}
					_tmp1945_ = _tmp1947_;
				} else {
					_tmp1945_ = FALSE;
				}
				if (_tmp1945_) {
					gboolean _tmp1954_ = FALSE;
					ValaDataType* _tmp1955_;
					_tmp1955_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1955_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1956_;
						_tmp1956_ = result_type;
						_tmp1954_ = !vala_data_type_is_disposable (_tmp1956_);
					} else {
						_tmp1954_ = FALSE;
					}
					_tmp1944_ = _tmp1954_;
				} else {
					_tmp1944_ = FALSE;
				}
				if (_tmp1944_) {
					ValaCCodeExpression* _tmp1957_;
					_tmp1957_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1957_);
				} else {
					gboolean _tmp1958_;
					_tmp1958_ = return_result_via_out_param;
					if (!_tmp1958_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1959_;
						ValaDataType* _tmp1960_;
						gboolean _tmp1961_;
						gboolean _tmp1962_;
						ValaLocalVariable* _tmp1963_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1964_;
						const gchar* _tmp1965_;
						const gchar* _tmp1966_;
						ValaCCodeExpression* _tmp1967_;
						ValaLocalVariable* _tmp1968_;
						ValaCCodeFunction* _tmp1969_;
						ValaCCodeFunction* _tmp1970_;
						ValaCCodeExpression* _tmp1971_;
						ValaCCodeExpression* _tmp1972_;
						ValaCCodeExpression* _tmp1973_;
						ValaTargetValue* _tmp1974_;
						ValaTargetValue* _tmp1975_;
						_tmp1959_ = result_type;
						_tmp1960_ = result_type;
						_tmp1961_ = vala_data_type_get_value_owned (_tmp1960_);
						_tmp1962_ = _tmp1961_;
						_tmp1963_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1959_, _tmp1962_, NULL, FALSE);
						temp_var = _tmp1963_;
						_tmp1964_ = temp_var;
						_tmp1965_ = vala_symbol_get_name ((ValaSymbol*) _tmp1964_);
						_tmp1966_ = _tmp1965_;
						_tmp1967_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1966_);
						temp_ref = _tmp1967_;
						_tmp1968_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1968_);
						_tmp1969_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1970_ = _tmp1969_;
						_tmp1971_ = temp_ref;
						_tmp1972_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1970_, _tmp1971_, _tmp1972_);
						_tmp1973_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1973_);
						_tmp1974_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1975_ = _tmp1974_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1975_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1976_;
						ValaTargetValue* _tmp1977_;
						ValaTargetValue* _tmp1978_;
						_tmp1976_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1976_);
						_tmp1977_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1978_ = _tmp1977_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1978_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1979_ = params;
	_tmp1980_ = vala_iterable_iterator ((ValaIterable*) _tmp1979_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1980_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1981_;
		gint _arg_size = 0;
		ValaList* _tmp1982_;
		gint _tmp1983_;
		gint _tmp1984_;
		gint _arg_index = 0;
		_tmp1981_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1981_;
		_tmp1982_ = _arg_list;
		_tmp1983_ = vala_collection_get_size ((ValaCollection*) _tmp1982_);
		_tmp1984_ = _tmp1983_;
		_arg_size = _tmp1984_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1985_;
			gint _tmp1986_;
			gint _tmp1987_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1988_;
			gint _tmp1989_;
			gpointer _tmp1990_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1991_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2001_;
			ValaUnaryExpression* _tmp2002_;
			gboolean _tmp2003_ = FALSE;
			ValaUnaryExpression* _tmp2004_;
			ValaUnaryExpression* _tmp2008_;
			ValaExpression* _tmp2009_;
			ValaExpression* _tmp2010_;
			ValaDataType* _tmp2011_;
			ValaDataType* _tmp2012_;
			ValaUnaryExpression* _tmp2022_;
			ValaExpression* _tmp2023_;
			ValaExpression* _tmp2024_;
			ValaTargetValue* _tmp2025_;
			ValaTargetValue* _tmp2026_;
			ValaUnaryExpression* _tmp2027_;
			ValaTargetValue* _tmp2028_;
			ValaTargetValue* _tmp2029_;
			ValaUnaryExpression* _tmp2030_;
			ValaExpression* _tmp2031_;
			ValaExpression* _tmp2032_;
			ValaDataType* _tmp2033_;
			ValaDataType* _tmp2034_;
			ValaExpression* _tmp2035_;
			ValaTargetValue* _tmp2036_;
			ValaTargetValue* _tmp2037_;
			ValaSourceReference* _tmp2038_;
			ValaSourceReference* _tmp2039_;
			gboolean _tmp2040_ = FALSE;
			ValaParameter* _tmp2041_;
			_tmp1985_ = _arg_index;
			_arg_index = _tmp1985_ + 1;
			_tmp1986_ = _arg_index;
			_tmp1987_ = _arg_size;
			if (!(_tmp1986_ < _tmp1987_)) {
				break;
			}
			_tmp1988_ = _arg_list;
			_tmp1989_ = _arg_index;
			_tmp1990_ = vala_list_get (_tmp1988_, _tmp1989_);
			arg = (ValaExpression*) _tmp1990_;
			param = NULL;
			_tmp1991_ = params_it;
			if (vala_iterator_next (_tmp1991_)) {
				ValaIterator* _tmp1992_;
				gpointer _tmp1993_;
				gboolean _tmp1994_ = FALSE;
				ValaParameter* _tmp1995_;
				gboolean _tmp1996_;
				gboolean _tmp1997_;
				_tmp1992_ = params_it;
				_tmp1993_ = vala_iterator_get (_tmp1992_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1993_;
				_tmp1995_ = param;
				_tmp1996_ = vala_parameter_get_params_array (_tmp1995_);
				_tmp1997_ = _tmp1996_;
				if (_tmp1997_) {
					_tmp1994_ = TRUE;
				} else {
					ValaParameter* _tmp1998_;
					gboolean _tmp1999_;
					gboolean _tmp2000_;
					_tmp1998_ = param;
					_tmp1999_ = vala_parameter_get_ellipsis (_tmp1998_);
					_tmp2000_ = _tmp1999_;
					_tmp1994_ = _tmp2000_;
				}
				if (_tmp1994_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp2001_ = arg;
			_tmp2002_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2001_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2001_) : NULL);
			unary = _tmp2002_;
			_tmp2004_ = unary;
			if (_tmp2004_ == NULL) {
				_tmp2003_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2005_;
				ValaUnaryOperator _tmp2006_;
				ValaUnaryOperator _tmp2007_;
				_tmp2005_ = unary;
				_tmp2006_ = vala_unary_expression_get_operator (_tmp2005_);
				_tmp2007_ = _tmp2006_;
				_tmp2003_ = _tmp2007_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2003_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2008_ = unary;
			_tmp2009_ = vala_unary_expression_get_inner (_tmp2008_);
			_tmp2010_ = _tmp2009_;
			_tmp2011_ = vala_expression_get_value_type (_tmp2010_);
			_tmp2012_ = _tmp2011_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2012_)) {
				ValaCCodeFunction* _tmp2013_;
				ValaCCodeFunction* _tmp2014_;
				ValaUnaryExpression* _tmp2015_;
				ValaExpression* _tmp2016_;
				ValaExpression* _tmp2017_;
				ValaTargetValue* _tmp2018_;
				ValaTargetValue* _tmp2019_;
				ValaCCodeExpression* _tmp2020_;
				ValaCCodeExpression* _tmp2021_;
				_tmp2013_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2014_ = _tmp2013_;
				_tmp2015_ = unary;
				_tmp2016_ = vala_unary_expression_get_inner (_tmp2015_);
				_tmp2017_ = _tmp2016_;
				_tmp2018_ = vala_expression_get_target_value (_tmp2017_);
				_tmp2019_ = _tmp2018_;
				_tmp2020_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2019_, FALSE);
				_tmp2021_ = _tmp2020_;
				vala_ccode_function_add_expression (_tmp2014_, _tmp2021_);
				_vala_ccode_node_unref0 (_tmp2021_);
			}
			_tmp2022_ = unary;
			_tmp2023_ = vala_unary_expression_get_inner (_tmp2022_);
			_tmp2024_ = _tmp2023_;
			_tmp2025_ = vala_expression_get_target_value (_tmp2024_);
			_tmp2026_ = _tmp2025_;
			_tmp2027_ = unary;
			_tmp2028_ = vala_expression_get_target_value ((ValaExpression*) _tmp2027_);
			_tmp2029_ = _tmp2028_;
			_tmp2030_ = unary;
			_tmp2031_ = vala_unary_expression_get_inner (_tmp2030_);
			_tmp2032_ = _tmp2031_;
			_tmp2033_ = vala_expression_get_value_type (_tmp2032_);
			_tmp2034_ = _tmp2033_;
			_tmp2035_ = arg;
			_tmp2036_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2029_, _tmp2034_, (ValaCodeNode*) _tmp2035_);
			_tmp2037_ = _tmp2036_;
			_tmp2038_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2039_ = _tmp2038_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2026_, _tmp2037_, _tmp2039_);
			_vala_target_value_unref0 (_tmp2037_);
			_tmp2041_ = param;
			if (_tmp2041_ != NULL) {
				ValaParameter* _tmp2042_;
				_tmp2042_ = param;
				_tmp2040_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2042_);
			} else {
				_tmp2040_ = FALSE;
			}
			if (_tmp2040_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2043_;
				ValaCCodeIdentifier* _tmp2044_;
				ValaCCodeFunctionCall* _tmp2045_;
				ValaCCodeFunctionCall* _tmp2046_;
				ValaCCodeFunctionCall* _tmp2047_;
				ValaUnaryExpression* _tmp2048_;
				ValaExpression* _tmp2049_;
				ValaExpression* _tmp2050_;
				ValaTargetValue* _tmp2051_;
				ValaTargetValue* _tmp2052_;
				ValaCCodeExpression* _tmp2053_;
				ValaCCodeExpression* _tmp2054_;
				ValaCCodeFunction* _tmp2055_;
				ValaCCodeFunction* _tmp2056_;
				ValaUnaryExpression* _tmp2057_;
				ValaExpression* _tmp2058_;
				ValaExpression* _tmp2059_;
				ValaTargetValue* _tmp2060_;
				ValaTargetValue* _tmp2061_;
				ValaCCodeExpression* _tmp2062_;
				ValaCCodeExpression* _tmp2063_;
				ValaCCodeFunctionCall* _tmp2064_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2043_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2044_ = _tmp2043_;
				_tmp2045_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2044_);
				_tmp2046_ = _tmp2045_;
				_vala_ccode_node_unref0 (_tmp2044_);
				len_call = _tmp2046_;
				_tmp2047_ = len_call;
				_tmp2048_ = unary;
				_tmp2049_ = vala_unary_expression_get_inner (_tmp2048_);
				_tmp2050_ = _tmp2049_;
				_tmp2051_ = vala_expression_get_target_value (_tmp2050_);
				_tmp2052_ = _tmp2051_;
				_tmp2053_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2052_);
				_tmp2054_ = _tmp2053_;
				vala_ccode_function_call_add_argument (_tmp2047_, _tmp2054_);
				_vala_ccode_node_unref0 (_tmp2054_);
				_tmp2055_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2056_ = _tmp2055_;
				_tmp2057_ = unary;
				_tmp2058_ = vala_unary_expression_get_inner (_tmp2057_);
				_tmp2059_ = _tmp2058_;
				_tmp2060_ = vala_expression_get_target_value (_tmp2059_);
				_tmp2061_ = _tmp2060_;
				_tmp2062_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2061_, 1);
				_tmp2063_ = _tmp2062_;
				_tmp2064_ = len_call;
				vala_ccode_function_add_assignment (_tmp2056_, _tmp2063_, (ValaCCodeExpression*) _tmp2064_);
				_vala_ccode_node_unref0 (_tmp2063_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2067_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2067_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2068_;
		ValaSymbol* _tmp2069_;
		ValaSymbol* _tmp2070_;
		_tmp2068_ = m;
		_tmp2069_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2068_);
		_tmp2070_ = _tmp2069_;
		_tmp2066_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2070_, VALA_TYPE_CLASS);
	} else {
		_tmp2066_ = FALSE;
	}
	if (_tmp2066_) {
		gboolean _tmp2071_ = FALSE;
		gboolean _tmp2072_ = FALSE;
		ValaClass* _tmp2073_;
		ValaClass* _tmp2074_;
		gboolean _tmp2075_;
		gboolean _tmp2076_;
		_tmp2073_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2074_ = _tmp2073_;
		_tmp2075_ = vala_class_get_is_compact (_tmp2074_);
		_tmp2076_ = _tmp2075_;
		if (_tmp2076_) {
			ValaClass* _tmp2077_;
			ValaClass* _tmp2078_;
			ValaClass* _tmp2079_;
			ValaClass* _tmp2080_;
			_tmp2077_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2078_ = _tmp2077_;
			_tmp2079_ = vala_class_get_base_class (_tmp2078_);
			_tmp2080_ = _tmp2079_;
			_tmp2072_ = _tmp2080_ != NULL;
		} else {
			_tmp2072_ = FALSE;
		}
		if (_tmp2072_) {
			_tmp2071_ = TRUE;
		} else {
			ValaClass* _tmp2081_;
			ValaClass* _tmp2082_;
			ValaClass* _tmp2083_;
			ValaClass* _tmp2084_;
			ValaClass* _tmp2085_;
			_tmp2081_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2082_ = _tmp2081_;
			_tmp2083_ = vala_class_get_base_class (_tmp2082_);
			_tmp2084_ = _tmp2083_;
			_tmp2085_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2071_ = _tmp2084_ == _tmp2085_;
		}
		_tmp2065_ = _tmp2071_;
	} else {
		_tmp2065_ = FALSE;
	}
	if (_tmp2065_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2086_;
		ValaClass* _tmp2087_;
		gchar* _tmp2088_;
		gchar* _tmp2089_;
		gchar* _tmp2090_;
		gchar* _tmp2091_;
		ValaCCodeIdentifier* _tmp2092_;
		ValaCCodeIdentifier* _tmp2093_;
		ValaCCodeFunctionCall* _tmp2094_;
		ValaCCodeFunctionCall* _tmp2095_;
		ValaCCodeFunctionCall* _tmp2096_;
		ValaCCodeExpression* _tmp2097_;
		ValaCCodeExpression* _tmp2098_;
		ValaCCodeFunction* _tmp2099_;
		ValaCCodeFunction* _tmp2100_;
		ValaCCodeFunctionCall* _tmp2101_;
		_tmp2086_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2087_ = _tmp2086_;
		_tmp2088_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2087_, NULL);
		_tmp2089_ = _tmp2088_;
		_tmp2090_ = g_strdup_printf ("%s_instance_init", _tmp2089_);
		_tmp2091_ = _tmp2090_;
		_tmp2092_ = vala_ccode_identifier_new (_tmp2091_);
		_tmp2093_ = _tmp2092_;
		_tmp2094_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2093_);
		_tmp2095_ = _tmp2094_;
		_vala_ccode_node_unref0 (_tmp2093_);
		_g_free0 (_tmp2091_);
		_g_free0 (_tmp2089_);
		cinitcall = _tmp2095_;
		_tmp2096_ = cinitcall;
		_tmp2097_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2098_ = _tmp2097_;
		vala_ccode_function_call_add_argument (_tmp2096_, _tmp2098_);
		_vala_ccode_node_unref0 (_tmp2098_);
		_tmp2099_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2100_ = _tmp2099_;
		_tmp2101_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2100_, (ValaCCodeExpression*) _tmp2101_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



