/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaSet* all_basic_blocks;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};


static gint ValaFlowAnalyzer_private_offset;
static gpointer vala_flow_analyzer_parent_class = NULL;
static gint ValaFlowAnalyzerJumpTarget_private_offset;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_set_jump_target (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_take_jump_target (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                           ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                         ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                          ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                      ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                           ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                          ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                           ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                                                    ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                                                  ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                      ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                                   ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                                  ValaList* block_list,
                                                  ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                              ValaBasicBlock* current,
                                              ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                                              ValaBasicBlock** idoms,
                                              int idoms_length1,
                                              ValaBasicBlock* b1,
                                              ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                                ValaList* block_list,
                                                ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                               ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                                     ValaMap* var_map,
                                                     ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                                    ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                             ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                      ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                          ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                          ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                         ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                       ValaCodeNode* node,
                                       gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                                   ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                         ValaExpressionStatement* stmt);
static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                         ValaExpression* condition);
static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                          ValaExpression* condition);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                                 ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                     ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                         ValaLoop* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                                                      ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                      ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                                    ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                       ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                     ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                                    ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                                                 ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                                               ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                                                     ValaBasicBlock* basic_block,
                                                                                     ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                                             ValaCatchClause* catch_clause,
                                                                             ValaErrorDomain* error_domain,
                                                                             ValaErrorCode* error_code,
                                                                             ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block,
                                                                                   ValaCatchClause* catch_clause,
                                                                                   ValaErrorDomain* error_domain,
                                                                                   ValaErrorCode* error_code,
                                                                                   ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                                   ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                     ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                               ValaExpression* expr);
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                            gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                          gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                        gboolean value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaCatchClause* value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                           gboolean value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
vala_flow_analyzer_get_instance_private (ValaFlowAnalyzer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzer_private_offset);
}


ValaFlowAnalyzer*
vala_flow_analyzer_construct (GType object_type)
{
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}


ValaFlowAnalyzer*
vala_flow_analyzer_new (void)
{
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}


/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
vala_flow_analyzer_analyze (ValaFlowAnalyzer* self,
                            ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	ValaList* source_files = NULL;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_, _tmp2_);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = (ValaSet*) _tmp3_;
	_tmp4_ = vala_code_context_get_source_files (context);
	source_files = _tmp4_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _file_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _file_index = 0;
		_tmp5_ = source_files;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_file_list = _tmp6_;
		_tmp7_ = _file_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_file_size = _tmp9_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFileType _tmp17_;
			ValaSourceFileType _tmp18_;
			_tmp10_ = _file_index;
			_file_index = _tmp10_ + 1;
			_tmp11_ = _file_index;
			_tmp12_ = _file_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _file_list;
			_tmp14_ = _file_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			file = (ValaSourceFile*) _tmp15_;
			_tmp16_ = file;
			_tmp17_ = vala_source_file_get_file_type (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp19_;
				_tmp19_ = file;
				vala_source_file_accept (_tmp19_, (ValaCodeVisitor*) self);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = NULL;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_iterable_unref0 (source_files);
}


static void
vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                           ValaSourceFile* source_file)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                      ValaStruct* st)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                    ValaEnum* en)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* ed)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                     ValaField* f)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_symbol_get_used ((ValaSymbol*) f);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			gboolean _tmp4_ = FALSE;
			ValaCodeContext* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_internal_header_filename (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				_tmp4_ = TRUE;
			} else {
				ValaCodeContext* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp8_ = self->priv->context;
				_tmp9_ = vala_code_context_get_use_fast_vapi (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp4_ = _tmp10_;
			}
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
		} else {
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) f);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("field `%s' never used", _tmp14_);
			_tmp16_ = _tmp15_;
			vala_report_warning (_tmp12_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
		}
	}
}


static gpointer
_vala_basic_block_ref0 (gpointer self)
{
	return self ? vala_basic_block_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                 ValaLambdaExpression* le)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	gboolean _tmp2_;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	_tmp2_ = self->priv->unreachable_reported;
	old_unreachable_reported = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	old_jump_stack = _tmp4_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp6_;
	vala_code_node_accept_children ((ValaCodeNode*) le, (ValaCodeVisitor*) self);
	_tmp7_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp7_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp8_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp8_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}


static void
vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                      ValaMethod* m)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = vala_symbol_get_used ((ValaSymbol*) m);
		_tmp6_ = _tmp5_;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = vala_method_get_entry_point (m);
		_tmp8_ = _tmp7_;
		_tmp3_ = !_tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = vala_method_get_overrides (m);
		_tmp10_ = _tmp9_;
		_tmp2_ = !_tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_method (m);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			ValaMethod* _tmp14_;
			ValaMethod* _tmp15_;
			_tmp14_ = vala_method_get_base_interface_method (m);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == m;
		}
		_tmp1_ = _tmp11_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp16_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			gboolean _tmp17_ = FALSE;
			ValaCodeContext* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_internal_header_filename (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != NULL) {
				_tmp17_ = TRUE;
			} else {
				ValaCodeContext* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = self->priv->context;
				_tmp22_ = vala_code_context_get_use_fast_vapi (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp17_ = _tmp23_;
			}
			_tmp16_ = _tmp17_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
		} else {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp27_ = _tmp26_;
			if (_tmp27_ != NULL) {
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaAttribute* _tmp30_;
				_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp29_, "DBus");
				_tmp25_ = _tmp30_ != NULL;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				_tmp24_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "visible", TRUE);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
			} else {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) m);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup_printf ("method `%s' never used", _tmp34_);
				_tmp36_ = _tmp35_;
				vala_report_warning (_tmp32_, _tmp36_);
				_g_free0 (_tmp36_);
				_g_free0 (_tmp34_);
			}
		}
	}
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) m);
}


static void
vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                      ValaSignal* sig)
{
	ValaFlowAnalyzer * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_signal_get_default_handler (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_default_handler (sig);
		_tmp3_ = _tmp2_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp3_);
	}
}


static void
vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                     ValaSubroutine* m)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaSet* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaSet* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaSet* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp46_;
	ValaSet* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaBasicBlock* _tmp49_;
	ValaBasicBlock* _tmp50_;
	ValaBasicBlock* _tmp51_;
	ValaBasicBlock* _tmp52_;
	ValaList* _tmp53_;
	ValaBasicBlock* _tmp54_;
	ValaBasicBlock* _tmp55_;
	ValaFlowAnalyzerJumpTarget* _tmp56_;
	ValaFlowAnalyzerJumpTarget* _tmp57_;
	ValaList* _tmp58_;
	ValaBasicBlock* _tmp59_;
	ValaBasicBlock* _tmp60_;
	ValaFlowAnalyzerJumpTarget* _tmp61_;
	ValaFlowAnalyzerJumpTarget* _tmp62_;
	ValaList* _tmp63_;
	ValaList* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gpointer _tmp67_;
	ValaFlowAnalyzerJumpTarget* _tmp68_;
	ValaBasicBlock* _tmp69_;
	ValaBasicBlock* _tmp77_;
	ValaBasicBlock* _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_subroutine_get_body (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = vala_basic_block_new_entry ();
	_tmp3_ = _tmp2_;
	vala_subroutine_set_entry_block (m, _tmp3_);
	_vala_basic_block_unref0 (_tmp3_);
	_tmp4_ = self->priv->all_basic_blocks;
	_tmp5_ = vala_subroutine_get_entry_block (m);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp6_);
	_tmp7_ = vala_basic_block_new ();
	_tmp8_ = _tmp7_;
	vala_subroutine_set_return_block (m, _tmp8_);
	_vala_basic_block_unref0 (_tmp8_);
	_tmp9_ = self->priv->all_basic_blocks;
	_tmp10_ = vala_subroutine_get_return_block (m);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp9_, _tmp11_);
	_tmp12_ = vala_basic_block_new_exit ();
	_tmp13_ = _tmp12_;
	vala_subroutine_set_exit_block (m, _tmp13_);
	_vala_basic_block_unref0 (_tmp13_);
	_tmp14_ = self->priv->all_basic_blocks;
	_tmp15_ = vala_subroutine_get_exit_block (m);
	_tmp16_ = _tmp15_;
	vala_collection_add ((ValaCollection*) _tmp14_, _tmp16_);
	_tmp17_ = vala_subroutine_get_return_block (m);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_subroutine_get_exit_block (m);
	_tmp20_ = _tmp19_;
	vala_basic_block_connect (_tmp18_, _tmp20_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_METHOD)) {
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp21_;
			gint _param_size = 0;
			ValaList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _param_index = 0;
			_tmp21_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_METHOD, ValaMethod));
			_param_list = _tmp21_;
			_tmp22_ = _param_list;
			_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_param_size = _tmp24_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				ValaParameter* param = NULL;
				ValaList* _tmp28_;
				gint _tmp29_;
				gpointer _tmp30_;
				ValaParameter* _tmp31_;
				ValaParameterDirection _tmp32_;
				ValaParameterDirection _tmp33_;
				_tmp25_ = _param_index;
				_param_index = _tmp25_ + 1;
				_tmp26_ = _param_index;
				_tmp27_ = _param_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _param_list;
				_tmp29_ = _param_index;
				_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
				param = (ValaParameter*) _tmp30_;
				_tmp31_ = param;
				_tmp32_ = vala_parameter_get_direction (_tmp31_);
				_tmp33_ = _tmp32_;
				if (_tmp33_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					ValaParameter* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaSourceReference* _tmp39_;
					ValaMemberAccess* _tmp40_;
					ValaMemberAccess* _tmp41_;
					ValaParameter* _tmp42_;
					ValaBasicBlock* _tmp43_;
					ValaBasicBlock* _tmp44_;
					ValaMemberAccess* _tmp45_;
					_tmp34_ = param;
					_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = param;
					_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = vala_member_access_new_simple (_tmp36_, _tmp39_);
					param_ma = _tmp40_;
					_tmp41_ = param_ma;
					_tmp42_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp41_, (ValaSymbol*) _tmp42_);
					_tmp43_ = vala_subroutine_get_return_block (m);
					_tmp44_ = _tmp43_;
					_tmp45_ = param_ma;
					vala_basic_block_add_node (_tmp44_, (ValaCodeNode*) _tmp45_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp46_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp46_;
	_tmp47_ = self->priv->all_basic_blocks;
	_tmp48_ = self->priv->current_block;
	vala_collection_add ((ValaCollection*) _tmp47_, _tmp48_);
	_tmp49_ = vala_subroutine_get_entry_block (m);
	_tmp50_ = _tmp49_;
	_tmp51_ = self->priv->current_block;
	vala_basic_block_connect (_tmp50_, _tmp51_);
	_tmp52_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp52_, (ValaCodeNode*) m);
	_tmp53_ = self->priv->jump_stack;
	_tmp54_ = vala_subroutine_get_return_block (m);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_flow_analyzer_jump_target_new_return_target (_tmp55_);
	_tmp57_ = _tmp56_;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp57_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp57_);
	_tmp58_ = self->priv->jump_stack;
	_tmp59_ = vala_subroutine_get_exit_block (m);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp60_);
	_tmp62_ = _tmp61_;
	vala_collection_add ((ValaCollection*) _tmp58_, _tmp62_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp62_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp63_ = self->priv->jump_stack;
	_tmp64_ = self->priv->jump_stack;
	_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_list_remove_at (_tmp63_, _tmp66_ - 1);
	_tmp68_ = (ValaFlowAnalyzerJumpTarget*) _tmp67_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp68_);
	_tmp69_ = self->priv->current_block;
	if (_tmp69_ != NULL) {
		gboolean _tmp70_;
		gboolean _tmp71_;
		ValaBasicBlock* _tmp74_;
		ValaBasicBlock* _tmp75_;
		ValaBasicBlock* _tmp76_;
		_tmp70_ = vala_subroutine_get_has_result (m);
		_tmp71_ = _tmp70_;
		if (_tmp71_) {
			ValaSourceReference* _tmp72_;
			ValaSourceReference* _tmp73_;
			_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp73_ = _tmp72_;
			vala_report_error (_tmp73_, "missing return statement at end of subroutine body");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		}
		_tmp74_ = self->priv->current_block;
		_tmp75_ = vala_subroutine_get_return_block (m);
		_tmp76_ = _tmp75_;
		vala_basic_block_connect (_tmp74_, _tmp76_);
	}
	_tmp77_ = vala_subroutine_get_entry_block (m);
	_tmp78_ = _tmp77_;
	vala_flow_analyzer_analyze_body (self, _tmp78_);
}


static void
vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                 ValaBasicBlock* entry_block)
{
	ValaList* block_list = NULL;
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_depth_first_list (self, entry_block);
	block_list = _tmp0_;
	vala_flow_analyzer_build_dominator_tree (self, block_list, entry_block);
	vala_flow_analyzer_build_dominator_frontier (self, block_list, entry_block);
	vala_flow_analyzer_insert_phi_functions (self, block_list, entry_block);
	vala_flow_analyzer_check_variables (self, entry_block);
	_vala_iterable_unref0 (block_list);
}


static ValaList*
vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	vala_flow_analyzer_depth_first_traverse (self, entry_block, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}


static void
vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* current,
                                         ValaList* list)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_basic_block_get_postorder_visited (current);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_basic_block_set_postorder_visited (current, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp2_;
		gint _succ_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _succ_index = 0;
		_tmp2_ = vala_basic_block_get_successors (current);
		_succ_list = _tmp2_;
		_tmp3_ = _succ_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_succ_size = _tmp5_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaBasicBlock* _tmp12_;
			_tmp6_ = _succ_index;
			_succ_index = _tmp6_ + 1;
			_tmp7_ = _succ_index;
			_tmp8_ = _succ_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _succ_list;
			_tmp10_ = _succ_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			succ = (ValaBasicBlock*) _tmp11_;
			_tmp12_ = succ;
			vala_flow_analyzer_depth_first_traverse (self, _tmp12_, list);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	_tmp13_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp14_ = _tmp13_;
	vala_basic_block_set_postorder_number (current, _tmp14_);
	vala_list_insert (list, 0, current);
}


static void
vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaBasicBlock** idoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ValaBasicBlock** _tmp2_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (ValaBasicBlock*, _tmp1_ + 1);
	idoms = _tmp2_;
	idoms_length1 = _tmp1_;
	_idoms_size_ = idoms_length1;
	_tmp3_ = idoms;
	_tmp3__length1 = idoms_length1;
	_tmp4_ = vala_basic_block_get_postorder_number (entry_block);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_basic_block_ref0 (entry_block);
	_vala_basic_block_unref0 (_tmp3_[_tmp5_]);
	_tmp3_[_tmp5_] = _tmp6_;
	_tmp7_ = _tmp3_[_tmp5_];
	changed = TRUE;
	while (TRUE) {
		gboolean _tmp8_;
		_tmp8_ = changed;
		if (!_tmp8_) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			ValaList* _tmp9_;
			gint _block_size = 0;
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _block_index = 0;
			_tmp9_ = _vala_iterable_ref0 (block_list);
			_block_list = _tmp9_;
			_tmp10_ = _block_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_block_size = _tmp12_;
			_block_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_;
				ValaBasicBlock* _tmp19_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp43_;
				gint _tmp43__length1;
				ValaBasicBlock* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				ValaBasicBlock* _tmp47_;
				ValaBasicBlock* _tmp48_;
				_tmp13_ = _block_index;
				_block_index = _tmp13_ + 1;
				_tmp14_ = _block_index;
				_tmp15_ = _block_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _block_list;
				_tmp17_ = _block_index;
				_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
				block = (ValaBasicBlock*) _tmp18_;
				_tmp19_ = block;
				if (_tmp19_ == entry_block) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp20_;
					ValaList* _tmp21_;
					gint _pred_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _pred_index = 0;
					_tmp20_ = block;
					_tmp21_ = vala_basic_block_get_predecessors (_tmp20_);
					_pred_list = _tmp21_;
					_tmp22_ = _pred_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_pred_size = _tmp24_;
					_pred_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp28_;
						gint _tmp29_;
						gpointer _tmp30_;
						ValaBasicBlock** _tmp31_;
						gint _tmp31__length1;
						ValaBasicBlock* _tmp32_;
						gint _tmp33_;
						gint _tmp34_;
						ValaBasicBlock* _tmp35_;
						_tmp25_ = _pred_index;
						_pred_index = _tmp25_ + 1;
						_tmp26_ = _pred_index;
						_tmp27_ = _pred_size;
						if (!(_tmp26_ < _tmp27_)) {
							break;
						}
						_tmp28_ = _pred_list;
						_tmp29_ = _pred_index;
						_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
						pred = (ValaBasicBlock*) _tmp30_;
						_tmp31_ = idoms;
						_tmp31__length1 = idoms_length1;
						_tmp32_ = pred;
						_tmp33_ = vala_basic_block_get_postorder_number (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = _tmp31_[_tmp34_];
						if (_tmp35_ != NULL) {
							gboolean _tmp36_;
							_tmp36_ = first;
							if (_tmp36_) {
								ValaBasicBlock* _tmp37_;
								ValaBasicBlock* _tmp38_;
								_tmp37_ = pred;
								_tmp38_ = _vala_basic_block_ref0 (_tmp37_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp38_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp39_;
								gint _tmp39__length1;
								ValaBasicBlock* _tmp40_;
								ValaBasicBlock* _tmp41_;
								ValaBasicBlock* _tmp42_;
								_tmp39_ = idoms;
								_tmp39__length1 = idoms_length1;
								_tmp40_ = pred;
								_tmp41_ = new_idom;
								_tmp42_ = vala_flow_analyzer_intersect (self, _tmp39_, _tmp39__length1, _tmp40_, _tmp41_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp42_;
							}
						}
					}
					_vala_iterable_unref0 (_pred_list);
				}
				_tmp43_ = idoms;
				_tmp43__length1 = idoms_length1;
				_tmp44_ = block;
				_tmp45_ = vala_basic_block_get_postorder_number (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp43_[_tmp46_];
				_tmp48_ = new_idom;
				if (_tmp47_ != _tmp48_) {
					ValaBasicBlock** _tmp49_;
					gint _tmp49__length1;
					ValaBasicBlock* _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					ValaBasicBlock* _tmp53_;
					ValaBasicBlock* _tmp54_;
					ValaBasicBlock* _tmp55_;
					_tmp49_ = idoms;
					_tmp49__length1 = idoms_length1;
					_tmp50_ = block;
					_tmp51_ = vala_basic_block_get_postorder_number (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = new_idom;
					_tmp54_ = _vala_basic_block_ref0 (_tmp53_);
					_vala_basic_block_unref0 (_tmp49_[_tmp52_]);
					_tmp49_[_tmp52_] = _tmp54_;
					_tmp55_ = _tmp49_[_tmp52_];
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
			_vala_iterable_unref0 (_block_list);
		}
	}
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp56_;
		gint _block_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _block_index = 0;
		_tmp56_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp56_;
		_tmp57_ = _block_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_block_size = _tmp59_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaBasicBlock* _tmp66_;
			ValaBasicBlock** _tmp67_;
			gint _tmp67__length1;
			ValaBasicBlock* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			ValaBasicBlock* _tmp71_;
			ValaBasicBlock* _tmp72_;
			_tmp60_ = _block_index;
			_block_index = _tmp60_ + 1;
			_tmp61_ = _block_index;
			_tmp62_ = _block_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _block_list;
			_tmp64_ = _block_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			block = (ValaBasicBlock*) _tmp65_;
			_tmp66_ = block;
			if (_tmp66_ == entry_block) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp67_ = idoms;
			_tmp67__length1 = idoms_length1;
			_tmp68_ = block;
			_tmp69_ = vala_basic_block_get_postorder_number (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = _tmp67_[_tmp70_];
			_tmp72_ = block;
			vala_basic_block_add_child (_tmp71_, _tmp72_);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}


static ValaBasicBlock*
vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                              ValaBasicBlock** idoms,
                              int idoms_length1,
                              ValaBasicBlock* b1,
                              ValaBasicBlock* b2)
{
	ValaBasicBlock* result = NULL;
	ValaBasicBlock* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		if (!(b1 != b2)) {
			break;
		}
		while (TRUE) {
			gint _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			ValaBasicBlock* _tmp6_;
			_tmp0_ = vala_basic_block_get_postorder_number (b1);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_basic_block_get_postorder_number (b2);
			_tmp3_ = _tmp2_;
			if (!(_tmp1_ < _tmp3_)) {
				break;
			}
			_tmp4_ = vala_basic_block_get_postorder_number (b2);
			_tmp5_ = _tmp4_;
			_tmp6_ = idoms[_tmp5_];
			b1 = _tmp6_;
		}
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp7_ = vala_basic_block_get_postorder_number (b2);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_basic_block_get_postorder_number (b1);
			_tmp10_ = _tmp9_;
			if (!(_tmp8_ < _tmp10_)) {
				break;
			}
			_tmp11_ = vala_basic_block_get_postorder_number (b2);
			_tmp12_ = _tmp11_;
			_tmp13_ = idoms[_tmp12_];
			b2 = _tmp13_;
		}
	}
	_tmp14_ = _vala_basic_block_ref0 (b1);
	result = _tmp14_;
	return result;
}


static void
vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                             ValaList* block_list,
                                             ValaBasicBlock* entry_block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				ValaBasicBlock* block = NULL;
				gint _tmp5_;
				gpointer _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ >= 0)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = vala_list_get (block_list, _tmp5_);
				block = (ValaBasicBlock*) _tmp6_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp7_;
					ValaList* _tmp8_;
					gint _succ_size = 0;
					ValaList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _succ_index = 0;
					_tmp7_ = block;
					_tmp8_ = vala_basic_block_get_successors (_tmp7_);
					_succ_list = _tmp8_;
					_tmp9_ = _succ_list;
					_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_succ_size = _tmp11_;
					_succ_index = -1;
					while (TRUE) {
						gint _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp15_;
						gint _tmp16_;
						gpointer _tmp17_;
						ValaBasicBlock* _tmp18_;
						ValaBasicBlock* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						_tmp12_ = _succ_index;
						_succ_index = _tmp12_ + 1;
						_tmp13_ = _succ_index;
						_tmp14_ = _succ_size;
						if (!(_tmp13_ < _tmp14_)) {
							break;
						}
						_tmp15_ = _succ_list;
						_tmp16_ = _succ_index;
						_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
						succ = (ValaBasicBlock*) _tmp17_;
						_tmp18_ = succ;
						_tmp19_ = vala_basic_block_get_parent (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = block;
						if (_tmp20_ != _tmp21_) {
							ValaBasicBlock* _tmp22_;
							ValaBasicBlock* _tmp23_;
							_tmp22_ = block;
							_tmp23_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp22_, _tmp23_);
						}
					}
					_vala_iterable_unref0 (_succ_list);
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp24_;
					ValaList* _tmp25_;
					gint _child_size = 0;
					ValaList* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gint _child_index = 0;
					_tmp24_ = block;
					_tmp25_ = vala_basic_block_get_children (_tmp24_);
					_child_list = _tmp25_;
					_tmp26_ = _child_list;
					_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
					_tmp28_ = _tmp27_;
					_child_size = _tmp28_;
					_child_index = -1;
					while (TRUE) {
						gint _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						ValaBasicBlock* child = NULL;
						ValaList* _tmp32_;
						gint _tmp33_;
						gpointer _tmp34_;
						_tmp29_ = _child_index;
						_child_index = _tmp29_ + 1;
						_tmp30_ = _child_index;
						_tmp31_ = _child_size;
						if (!(_tmp30_ < _tmp31_)) {
							break;
						}
						_tmp32_ = _child_list;
						_tmp33_ = _child_index;
						_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
						child = (ValaBasicBlock*) _tmp34_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp35_;
							ValaSet* _tmp36_;
							ValaSet* _tmp37_;
							ValaIterator* _tmp38_;
							ValaIterator* _tmp39_;
							_tmp35_ = child;
							_tmp36_ = vala_basic_block_get_dominator_frontier (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = vala_iterable_iterator ((ValaIterable*) _tmp37_);
							_tmp39_ = _tmp38_;
							_vala_iterable_unref0 (_tmp37_);
							_child_frontier_it = _tmp39_;
							while (TRUE) {
								ValaIterator* _tmp40_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp41_;
								gpointer _tmp42_;
								ValaBasicBlock* _tmp43_;
								ValaBasicBlock* _tmp44_;
								ValaBasicBlock* _tmp45_;
								ValaBasicBlock* _tmp46_;
								_tmp40_ = _child_frontier_it;
								if (!vala_iterator_next (_tmp40_)) {
									break;
								}
								_tmp41_ = _child_frontier_it;
								_tmp42_ = vala_iterator_get (_tmp41_);
								child_frontier = (ValaBasicBlock*) _tmp42_;
								_tmp43_ = child_frontier;
								_tmp44_ = vala_basic_block_get_parent (_tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = block;
								if (_tmp45_ != _tmp46_) {
									ValaBasicBlock* _tmp47_;
									ValaBasicBlock* _tmp48_;
									_tmp47_ = block;
									_tmp48_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp47_, _tmp48_);
								}
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
					}
					_vala_iterable_unref0 (_child_list);
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}


static ValaMap*
vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                       ValaList* block_list,
                                       ValaBasicBlock* entry_block)
{
	ValaMap* result = NULL;
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp4_;
		gint _block_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _block_index = 0;
		_tmp4_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp4_;
		_tmp5_ = _block_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_block_size = _tmp7_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp14_;
			ValaArrayList* _tmp15_;
			_tmp8_ = _block_index;
			_block_index = _tmp8_ + 1;
			_tmp9_ = _block_index;
			_tmp10_ = _block_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _block_list;
			_tmp12_ = _block_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			block = (ValaBasicBlock*) _tmp13_;
			_tmp14_ = g_direct_equal;
			_tmp15_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
			defined_variables = _tmp15_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp16_;
				ValaList* _tmp17_;
				gint _node_size = 0;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _node_index = 0;
				_tmp16_ = block;
				_tmp17_ = vala_basic_block_get_nodes (_tmp16_);
				_node_list = _tmp17_;
				_tmp18_ = _node_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_node_size = _tmp20_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_;
					ValaCodeNode* _tmp27_;
					ValaArrayList* _tmp28_;
					_tmp21_ = _node_index;
					_node_index = _tmp21_ + 1;
					_tmp22_ = _node_index;
					_tmp23_ = _node_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _node_list;
					_tmp25_ = _node_index;
					_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
					node = (ValaCodeNode*) _tmp26_;
					_tmp27_ = node;
					_tmp28_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp27_, (ValaCollection*) _tmp28_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp29_;
				ValaArrayList* _tmp30_;
				gint _variable_size = 0;
				ValaArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _variable_index = 0;
				_tmp29_ = defined_variables;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_variable_list = _tmp30_;
				_tmp31_ = _variable_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_variable_size = _tmp33_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp37_;
					gint _tmp38_;
					gpointer _tmp39_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp40_;
					ValaVariable* _tmp41_;
					gpointer _tmp42_;
					ValaSet* _tmp43_;
					ValaSet* _tmp50_;
					ValaBasicBlock* _tmp51_;
					_tmp34_ = _variable_index;
					_variable_index = _tmp34_ + 1;
					_tmp35_ = _variable_index;
					_tmp36_ = _variable_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _variable_list;
					_tmp38_ = _variable_index;
					_tmp39_ = vala_list_get ((ValaList*) _tmp37_, _tmp38_);
					variable = (ValaVariable*) _tmp39_;
					_tmp40_ = map;
					_tmp41_ = variable;
					_tmp42_ = vala_map_get ((ValaMap*) _tmp40_, _tmp41_);
					block_set = (ValaSet*) _tmp42_;
					_tmp43_ = block_set;
					if (_tmp43_ == NULL) {
						GHashFunc _tmp44_;
						GEqualFunc _tmp45_;
						ValaHashSet* _tmp46_;
						ValaHashMap* _tmp47_;
						ValaVariable* _tmp48_;
						ValaSet* _tmp49_;
						_tmp44_ = g_direct_hash;
						_tmp45_ = g_direct_equal;
						_tmp46_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp44_, _tmp45_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp46_;
						_tmp47_ = map;
						_tmp48_ = variable;
						_tmp49_ = block_set;
						vala_map_set ((ValaMap*) _tmp47_, _tmp48_, _tmp49_);
					}
					_tmp50_ = block_set;
					_tmp51_ = block;
					vala_collection_add ((ValaCollection*) _tmp50_, _tmp51_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	result = (ValaMap*) map;
	return result;
}


static void
vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaMap* assign = NULL;
	ValaMap* _tmp0_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_assignment_map (self, block_list, entry_block);
	assign = _tmp0_;
	counter = 0;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_);
	work_list = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp3_, _tmp4_, _tmp5_);
	added = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp7_, _tmp8_, _tmp9_);
	phi = _tmp10_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp11_;
		gint _block_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _block_index = 0;
		_tmp11_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp11_;
		_tmp12_ = _block_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_block_size = _tmp14_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaHashMap* _tmp21_;
			ValaBasicBlock* _tmp22_;
			ValaHashMap* _tmp23_;
			ValaBasicBlock* _tmp24_;
			_tmp15_ = _block_index;
			_block_index = _tmp15_ + 1;
			_tmp16_ = _block_index;
			_tmp17_ = _block_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _block_list;
			_tmp19_ = _block_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			block = (ValaBasicBlock*) _tmp20_;
			_tmp21_ = added;
			_tmp22_ = block;
			vala_map_set ((ValaMap*) _tmp21_, _tmp22_, (gpointer) ((gintptr) 0));
			_tmp23_ = phi;
			_tmp24_ = block;
			vala_map_set ((ValaMap*) _tmp23_, _tmp24_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp25_;
		ValaSet* _tmp26_;
		ValaSet* _tmp27_;
		ValaIterator* _tmp28_;
		ValaIterator* _tmp29_;
		_tmp25_ = assign;
		_tmp26_ = vala_map_get_keys (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_iterable_iterator ((ValaIterable*) _tmp27_);
		_tmp29_ = _tmp28_;
		_vala_iterable_unref0 (_tmp27_);
		_variable_it = _tmp29_;
		while (TRUE) {
			ValaIterator* _tmp30_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp31_;
			gpointer _tmp32_;
			gint _tmp33_;
			_tmp30_ = _variable_it;
			if (!vala_iterator_next (_tmp30_)) {
				break;
			}
			_tmp31_ = _variable_it;
			_tmp32_ = vala_iterator_get (_tmp31_);
			variable = (ValaVariable*) _tmp32_;
			_tmp33_ = counter;
			counter = _tmp33_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp34_;
				ValaVariable* _tmp35_;
				gpointer _tmp36_;
				ValaSet* _tmp37_;
				ValaIterator* _tmp38_;
				ValaIterator* _tmp39_;
				_tmp34_ = assign;
				_tmp35_ = variable;
				_tmp36_ = vala_map_get (_tmp34_, _tmp35_);
				_tmp37_ = (ValaSet*) _tmp36_;
				_tmp38_ = vala_iterable_iterator ((ValaIterable*) _tmp37_);
				_tmp39_ = _tmp38_;
				_vala_iterable_unref0 (_tmp37_);
				_block_it = _tmp39_;
				while (TRUE) {
					ValaIterator* _tmp40_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp41_;
					gpointer _tmp42_;
					ValaArrayList* _tmp43_;
					ValaBasicBlock* _tmp44_;
					ValaHashMap* _tmp45_;
					ValaBasicBlock* _tmp46_;
					gint _tmp47_;
					_tmp40_ = _block_it;
					if (!vala_iterator_next (_tmp40_)) {
						break;
					}
					_tmp41_ = _block_it;
					_tmp42_ = vala_iterator_get (_tmp41_);
					block = (ValaBasicBlock*) _tmp42_;
					_tmp43_ = work_list;
					_tmp44_ = block;
					vala_collection_add ((ValaCollection*) _tmp43_, _tmp44_);
					_tmp45_ = added;
					_tmp46_ = block;
					_tmp47_ = counter;
					vala_map_set ((ValaMap*) _tmp45_, _tmp46_, (gpointer) ((gintptr) _tmp47_));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp51_;
				gpointer _tmp52_;
				_tmp48_ = work_list;
				_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp50_ > 0)) {
					break;
				}
				_tmp51_ = work_list;
				_tmp52_ = vala_list_remove_at ((ValaList*) _tmp51_, 0);
				block = (ValaBasicBlock*) _tmp52_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp53_;
					ValaSet* _tmp54_;
					ValaSet* _tmp55_;
					ValaIterator* _tmp56_;
					ValaIterator* _tmp57_;
					_tmp53_ = block;
					_tmp54_ = vala_basic_block_get_dominator_frontier (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_iterable_iterator ((ValaIterable*) _tmp55_);
					_tmp57_ = _tmp56_;
					_vala_iterable_unref0 (_tmp55_);
					_frontier_it = _tmp57_;
					while (TRUE) {
						ValaIterator* _tmp58_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp59_;
						gpointer _tmp60_;
						ValaBasicBlock* _tmp61_;
						gint blockPhi = 0;
						ValaHashMap* _tmp62_;
						ValaBasicBlock* _tmp63_;
						gpointer _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						_tmp58_ = _frontier_it;
						if (!vala_iterator_next (_tmp58_)) {
							break;
						}
						_tmp59_ = _frontier_it;
						_tmp60_ = vala_iterator_get (_tmp59_);
						_tmp61_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp60_);
						frontier = _tmp61_;
						_tmp62_ = phi;
						_tmp63_ = frontier;
						_tmp64_ = vala_map_get ((ValaMap*) _tmp62_, _tmp63_);
						blockPhi = (gint) ((gintptr) _tmp64_);
						_tmp65_ = blockPhi;
						_tmp66_ = counter;
						if (_tmp65_ < _tmp66_) {
							ValaBasicBlock* _tmp67_;
							ValaVariable* _tmp68_;
							ValaBasicBlock* _tmp69_;
							ValaList* _tmp70_;
							ValaList* _tmp71_;
							gint _tmp72_;
							gint _tmp73_;
							ValaPhiFunction* _tmp74_;
							ValaPhiFunction* _tmp75_;
							ValaHashMap* _tmp76_;
							ValaBasicBlock* _tmp77_;
							gint _tmp78_;
							gint block_added = 0;
							ValaHashMap* _tmp79_;
							ValaBasicBlock* _tmp80_;
							gpointer _tmp81_;
							gint _tmp82_;
							gint _tmp83_;
							_tmp67_ = frontier;
							_tmp68_ = variable;
							_tmp69_ = frontier;
							_tmp70_ = vala_basic_block_get_predecessors (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
							_tmp73_ = _tmp72_;
							_tmp74_ = vala_phi_function_new (_tmp68_, _tmp73_);
							_tmp75_ = _tmp74_;
							vala_basic_block_add_phi_function (_tmp67_, _tmp75_);
							_vala_phi_function_unref0 (_tmp75_);
							_vala_iterable_unref0 (_tmp71_);
							_tmp76_ = phi;
							_tmp77_ = frontier;
							_tmp78_ = counter;
							vala_map_set ((ValaMap*) _tmp76_, _tmp77_, (gpointer) ((gintptr) _tmp78_));
							_tmp79_ = added;
							_tmp80_ = frontier;
							_tmp81_ = vala_map_get ((ValaMap*) _tmp79_, _tmp80_);
							block_added = (gint) ((gintptr) _tmp81_);
							_tmp82_ = block_added;
							_tmp83_ = counter;
							if (_tmp82_ < _tmp83_) {
								ValaHashMap* _tmp84_;
								ValaBasicBlock* _tmp85_;
								gint _tmp86_;
								ValaArrayList* _tmp87_;
								ValaBasicBlock* _tmp88_;
								_tmp84_ = added;
								_tmp85_ = frontier;
								_tmp86_ = counter;
								vala_map_set ((ValaMap*) _tmp84_, _tmp85_, (gpointer) ((gintptr) _tmp86_));
								_tmp87_ = work_list;
								_tmp88_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp87_, _tmp88_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}


static void
vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                    ValaBasicBlock* entry_block)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp11_;
	ValaArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	vala_flow_analyzer_check_block_variables (self, entry_block);
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
	used_vars_queue = _tmp12_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp13_ = self->priv->used_vars;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_variable_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValaVariable* _tmp19_;
			_tmp15_ = _variable_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			variable = (ValaVariable*) _tmp17_;
			_tmp18_ = used_vars_queue;
			_tmp19_ = variable;
			vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp23_;
		gpointer _tmp24_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp25_;
		ValaVariable* _tmp26_;
		gpointer _tmp27_;
		ValaPhiFunction* _tmp28_;
		_tmp20_ = used_vars_queue;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		if (!(_tmp22_ > 0)) {
			break;
		}
		_tmp23_ = used_vars_queue;
		_tmp24_ = vala_list_remove_at ((ValaList*) _tmp23_, 0);
		used_var = (ValaVariable*) _tmp24_;
		_tmp25_ = self->priv->phi_functions;
		_tmp26_ = used_var;
		_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
		phi = (ValaPhiFunction*) _tmp27_;
		_tmp28_ = phi;
		if (_tmp28_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp29_;
				ValaList* _tmp30_;
				ValaList* _tmp31_;
				ValaList* _tmp32_;
				gint _variable_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _variable_index = 0;
				_tmp29_ = phi;
				_tmp30_ = vala_phi_function_get_operands (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _vala_iterable_ref0 (_tmp31_);
				_variable_list = _tmp32_;
				_tmp33_ = _variable_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_variable_size = _tmp35_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					ValaVariable* variable = NULL;
					ValaList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_;
					ValaVariable* _tmp42_;
					ValaSet* _tmp60_;
					ValaVariable* _tmp61_;
					_tmp36_ = _variable_index;
					_variable_index = _tmp36_ + 1;
					_tmp37_ = _variable_index;
					_tmp38_ = _variable_size;
					if (!(_tmp37_ < _tmp38_)) {
						break;
					}
					_tmp39_ = _variable_list;
					_tmp40_ = _variable_index;
					_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
					variable = (ValaVariable*) _tmp41_;
					_tmp42_ = variable;
					if (_tmp42_ == NULL) {
						ValaVariable* _tmp43_;
						_tmp43_ = used_var;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaVariable* _tmp44_;
							ValaSourceReference* _tmp45_;
							ValaSourceReference* _tmp46_;
							ValaVariable* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							_tmp44_ = used_var;
							_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = used_var;
							_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp49_);
							_tmp51_ = _tmp50_;
							vala_report_error (_tmp46_, _tmp51_);
							_g_free0 (_tmp51_);
						} else {
							ValaVariable* _tmp52_;
							ValaSourceReference* _tmp53_;
							ValaSourceReference* _tmp54_;
							ValaVariable* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp52_ = used_var;
							_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = used_var;
							_tmp56_ = vala_symbol_get_name ((ValaSymbol*) _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp57_);
							_tmp59_ = _tmp58_;
							vala_report_warning (_tmp54_, _tmp59_);
							_g_free0 (_tmp59_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp60_ = self->priv->used_vars;
					_tmp61_ = variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp60_, _tmp61_)) {
						ValaVariable* _tmp62_;
						ValaVariable* _tmp63_;
						ValaSourceReference* _tmp64_;
						ValaSourceReference* _tmp65_;
						ValaSet* _tmp66_;
						ValaVariable* _tmp67_;
						ValaArrayList* _tmp68_;
						ValaVariable* _tmp69_;
						_tmp62_ = variable;
						_tmp63_ = used_var;
						_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
						_tmp65_ = _tmp64_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp62_, _tmp65_);
						_tmp66_ = self->priv->used_vars;
						_tmp67_ = variable;
						vala_collection_add ((ValaCollection*) _tmp66_, _tmp67_);
						_tmp68_ = used_vars_queue;
						_tmp69_ = variable;
						vala_collection_add ((ValaCollection*) _tmp68_, _tmp69_);
					}
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = NULL;
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = NULL;
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = NULL;
	_vala_iterable_unref0 (used_vars_queue);
}


static void
vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                          ValaBasicBlock* block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp0_;
		ValaSet* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _tmp3_;
		_tmp0_ = vala_basic_block_get_phi_functions (block);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_vala_iterable_unref0 (_tmp1_);
		_phi_it = _tmp3_;
		while (TRUE) {
			ValaIterator* _tmp4_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp5_;
			gpointer _tmp6_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp7_;
			ValaPhiFunction* _tmp8_;
			ValaVariable* _tmp9_;
			ValaVariable* _tmp10_;
			ValaVariable* _tmp11_;
			ValaMap* _tmp12_;
			ValaVariable* _tmp13_;
			ValaPhiFunction* _tmp14_;
			_tmp4_ = _phi_it;
			if (!vala_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _phi_it;
			_tmp6_ = vala_iterator_get (_tmp5_);
			phi = (ValaPhiFunction*) _tmp6_;
			_tmp7_ = self->priv->var_map;
			_tmp8_ = phi;
			_tmp9_ = vala_phi_function_get_original_variable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_flow_analyzer_process_assignment (self, _tmp7_, _tmp10_);
			versioned_var = _tmp11_;
			_tmp12_ = self->priv->phi_functions;
			_tmp13_ = versioned_var;
			_tmp14_ = phi;
			vala_map_set (_tmp12_, _tmp13_, _tmp14_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp15_;
		gint _node_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _node_index = 0;
		_tmp15_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp15_;
		_tmp16_ = _node_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_node_size = _tmp18_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp25_;
			ValaArrayList* _tmp26_;
			ValaCodeNode* _tmp27_;
			ValaArrayList* _tmp28_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp78_;
			ValaArrayList* _tmp79_;
			ValaCodeNode* _tmp80_;
			ValaArrayList* _tmp81_;
			_tmp19_ = _node_index;
			_node_index = _tmp19_ + 1;
			_tmp20_ = _node_index;
			_tmp21_ = _node_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _node_list;
			_tmp23_ = _node_index;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			node = (ValaCodeNode*) _tmp24_;
			_tmp25_ = g_direct_equal;
			_tmp26_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp25_);
			used_variables = _tmp26_;
			_tmp27_ = node;
			_tmp28_ = used_variables;
			vala_code_node_get_used_variables (_tmp27_, (ValaCollection*) _tmp28_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp29_;
				ValaArrayList* _tmp30_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _var_symbol_index = 0;
				_tmp29_ = used_variables;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_var_symbol_list = _tmp30_;
				_tmp31_ = _var_symbol_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_var_symbol_size = _tmp33_;
				_var_symbol_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp37_;
					gint _tmp38_;
					gpointer _tmp39_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp40_;
					ValaVariable* _tmp41_;
					gpointer _tmp42_;
					gboolean _tmp43_ = FALSE;
					ValaList* _tmp44_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp65_;
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gpointer _tmp69_;
					ValaSet* _tmp70_;
					ValaVariable* _tmp71_;
					ValaSet* _tmp76_;
					ValaVariable* _tmp77_;
					_tmp34_ = _var_symbol_index;
					_var_symbol_index = _tmp34_ + 1;
					_tmp35_ = _var_symbol_index;
					_tmp36_ = _var_symbol_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _var_symbol_list;
					_tmp38_ = _var_symbol_index;
					_tmp39_ = vala_list_get ((ValaList*) _tmp37_, _tmp38_);
					var_symbol = (ValaVariable*) _tmp39_;
					_tmp40_ = self->priv->var_map;
					_tmp41_ = var_symbol;
					_tmp42_ = vala_map_get (_tmp40_, (ValaSymbol*) _tmp41_);
					variable_stack = (ValaList*) _tmp42_;
					_tmp44_ = variable_stack;
					if (_tmp44_ == NULL) {
						_tmp43_ = TRUE;
					} else {
						ValaList* _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						_tmp45_ = variable_stack;
						_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
						_tmp47_ = _tmp46_;
						_tmp43_ = _tmp47_ == 0;
					}
					if (_tmp43_) {
						ValaVariable* _tmp48_;
						_tmp48_ = var_symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaCodeNode* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaSourceReference* _tmp51_;
							ValaVariable* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp49_ = node;
							_tmp50_ = vala_code_node_get_source_reference (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = var_symbol;
							_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp54_);
							_tmp56_ = _tmp55_;
							vala_report_error (_tmp51_, _tmp56_);
							_g_free0 (_tmp56_);
						} else {
							ValaCodeNode* _tmp57_;
							ValaSourceReference* _tmp58_;
							ValaSourceReference* _tmp59_;
							ValaVariable* _tmp60_;
							const gchar* _tmp61_;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp57_ = node;
							_tmp58_ = vala_code_node_get_source_reference (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = var_symbol;
							_tmp61_ = vala_symbol_get_name ((ValaSymbol*) _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp62_);
							_tmp64_ = _tmp63_;
							vala_report_warning (_tmp59_, _tmp64_);
							_g_free0 (_tmp64_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp65_ = variable_stack;
					_tmp66_ = variable_stack;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = vala_list_get (_tmp65_, _tmp68_ - 1);
					versioned_variable = (ValaVariable*) _tmp69_;
					_tmp70_ = self->priv->used_vars;
					_tmp71_ = versioned_variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp70_, _tmp71_)) {
						ValaVariable* _tmp72_;
						ValaCodeNode* _tmp73_;
						ValaSourceReference* _tmp74_;
						ValaSourceReference* _tmp75_;
						_tmp72_ = versioned_variable;
						_tmp73_ = node;
						_tmp74_ = vala_code_node_get_source_reference (_tmp73_);
						_tmp75_ = _tmp74_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp75_);
					}
					_tmp76_ = self->priv->used_vars;
					_tmp77_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp76_, _tmp77_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
				_vala_iterable_unref0 (_var_symbol_list);
			}
			_tmp78_ = g_direct_equal;
			_tmp79_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp78_);
			defined_variables = _tmp79_;
			_tmp80_ = node;
			_tmp81_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp80_, (ValaCollection*) _tmp81_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp82_;
				ValaArrayList* _tmp83_;
				gint _variable_size = 0;
				ValaArrayList* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _variable_index = 0;
				_tmp82_ = defined_variables;
				_tmp83_ = _vala_iterable_ref0 (_tmp82_);
				_variable_list = _tmp83_;
				_tmp84_ = _variable_list;
				_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
				_tmp86_ = _tmp85_;
				_variable_size = _tmp86_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp90_;
					gint _tmp91_;
					gpointer _tmp92_;
					ValaMap* _tmp93_;
					ValaVariable* _tmp94_;
					ValaVariable* _tmp95_;
					ValaVariable* _tmp96_;
					_tmp87_ = _variable_index;
					_variable_index = _tmp87_ + 1;
					_tmp88_ = _variable_index;
					_tmp89_ = _variable_size;
					if (!(_tmp88_ < _tmp89_)) {
						break;
					}
					_tmp90_ = _variable_list;
					_tmp91_ = _variable_index;
					_tmp92_ = vala_list_get ((ValaList*) _tmp90_, _tmp91_);
					variable = (ValaVariable*) _tmp92_;
					_tmp93_ = self->priv->var_map;
					_tmp94_ = variable;
					_tmp95_ = vala_flow_analyzer_process_assignment (self, _tmp93_, _tmp94_);
					_tmp96_ = _tmp95_;
					_vala_code_node_unref0 (_tmp96_);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp97_;
		gint _succ_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _succ_index = 0;
		_tmp97_ = vala_basic_block_get_successors (block);
		_succ_list = _tmp97_;
		_tmp98_ = _succ_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_succ_size = _tmp100_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp104_;
			gint _tmp105_;
			gpointer _tmp106_;
			gint j = 0;
			_tmp101_ = _succ_index;
			_succ_index = _tmp101_ + 1;
			_tmp102_ = _succ_index;
			_tmp103_ = _succ_size;
			if (!(_tmp102_ < _tmp103_)) {
				break;
			}
			_tmp104_ = _succ_list;
			_tmp105_ = _succ_index;
			_tmp106_ = vala_list_get (_tmp104_, _tmp105_);
			succ = (ValaBasicBlock*) _tmp106_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp107_;
				ValaList* _tmp108_;
				gint _pred_size = 0;
				ValaList* _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				gint _pred_index = 0;
				_tmp107_ = succ;
				_tmp108_ = vala_basic_block_get_predecessors (_tmp107_);
				_pred_list = _tmp108_;
				_tmp109_ = _pred_list;
				_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
				_tmp111_ = _tmp110_;
				_pred_size = _tmp111_;
				_pred_index = -1;
				while (TRUE) {
					gint _tmp112_;
					gint _tmp113_;
					gint _tmp114_;
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp115_;
					gint _tmp116_;
					gpointer _tmp117_;
					ValaBasicBlock* _tmp118_;
					gint _tmp119_;
					_tmp112_ = _pred_index;
					_pred_index = _tmp112_ + 1;
					_tmp113_ = _pred_index;
					_tmp114_ = _pred_size;
					if (!(_tmp113_ < _tmp114_)) {
						break;
					}
					_tmp115_ = _pred_list;
					_tmp116_ = _pred_index;
					_tmp117_ = vala_list_get (_tmp115_, _tmp116_);
					pred = (ValaBasicBlock*) _tmp117_;
					_tmp118_ = pred;
					if (_tmp118_ == block) {
						break;
					}
					_tmp119_ = j;
					j = _tmp119_ + 1;
				}
				_vala_iterable_unref0 (_pred_list);
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp120_;
				ValaSet* _tmp121_;
				ValaSet* _tmp122_;
				ValaIterator* _tmp123_;
				ValaIterator* _tmp124_;
				_tmp120_ = succ;
				_tmp121_ = vala_basic_block_get_phi_functions (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = vala_iterable_iterator ((ValaIterable*) _tmp122_);
				_tmp124_ = _tmp123_;
				_vala_iterable_unref0 (_tmp122_);
				_phi_it = _tmp124_;
				while (TRUE) {
					ValaIterator* _tmp125_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp126_;
					gpointer _tmp127_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp128_;
					ValaPhiFunction* _tmp129_;
					ValaVariable* _tmp130_;
					ValaVariable* _tmp131_;
					gpointer _tmp132_;
					gboolean _tmp133_ = FALSE;
					ValaList* _tmp134_;
					_tmp125_ = _phi_it;
					if (!vala_iterator_next (_tmp125_)) {
						break;
					}
					_tmp126_ = _phi_it;
					_tmp127_ = vala_iterator_get (_tmp126_);
					phi = (ValaPhiFunction*) _tmp127_;
					_tmp128_ = self->priv->var_map;
					_tmp129_ = phi;
					_tmp130_ = vala_phi_function_get_original_variable (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = vala_map_get (_tmp128_, (ValaSymbol*) _tmp131_);
					variable_stack = (ValaList*) _tmp132_;
					_tmp134_ = variable_stack;
					if (_tmp134_ != NULL) {
						ValaList* _tmp135_;
						gint _tmp136_;
						gint _tmp137_;
						_tmp135_ = variable_stack;
						_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
						_tmp137_ = _tmp136_;
						_tmp133_ = _tmp137_ > 0;
					} else {
						_tmp133_ = FALSE;
					}
					if (_tmp133_) {
						ValaPhiFunction* _tmp138_;
						ValaList* _tmp139_;
						ValaList* _tmp140_;
						gint _tmp141_;
						ValaList* _tmp142_;
						ValaList* _tmp143_;
						gint _tmp144_;
						gint _tmp145_;
						gpointer _tmp146_;
						ValaVariable* _tmp147_;
						_tmp138_ = phi;
						_tmp139_ = vala_phi_function_get_operands (_tmp138_);
						_tmp140_ = _tmp139_;
						_tmp141_ = j;
						_tmp142_ = variable_stack;
						_tmp143_ = variable_stack;
						_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_list_get (_tmp142_, _tmp145_ - 1);
						_tmp147_ = (ValaVariable*) _tmp146_;
						vala_list_set (_tmp140_, _tmp141_, _tmp147_);
						_vala_code_node_unref0 (_tmp147_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
		}
		_vala_iterable_unref0 (_succ_list);
	}
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp148_;
		gint _child_size = 0;
		ValaList* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _child_index = 0;
		_tmp148_ = vala_basic_block_get_children (block);
		_child_list = _tmp148_;
		_tmp149_ = _child_list;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
		_tmp151_ = _tmp150_;
		_child_size = _tmp151_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			ValaBasicBlock* child = NULL;
			ValaList* _tmp155_;
			gint _tmp156_;
			gpointer _tmp157_;
			ValaBasicBlock* _tmp158_;
			_tmp152_ = _child_index;
			_child_index = _tmp152_ + 1;
			_tmp153_ = _child_index;
			_tmp154_ = _child_size;
			if (!(_tmp153_ < _tmp154_)) {
				break;
			}
			_tmp155_ = _child_list;
			_tmp156_ = _child_index;
			_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
			child = (ValaBasicBlock*) _tmp157_;
			_tmp158_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp158_);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp159_;
		ValaSet* _tmp160_;
		ValaIterator* _tmp161_;
		ValaIterator* _tmp162_;
		_tmp159_ = vala_basic_block_get_phi_functions (block);
		_tmp160_ = _tmp159_;
		_tmp161_ = vala_iterable_iterator ((ValaIterable*) _tmp160_);
		_tmp162_ = _tmp161_;
		_vala_iterable_unref0 (_tmp160_);
		_phi_it = _tmp162_;
		while (TRUE) {
			ValaIterator* _tmp163_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp164_;
			gpointer _tmp165_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp166_;
			ValaPhiFunction* _tmp167_;
			ValaVariable* _tmp168_;
			ValaVariable* _tmp169_;
			gpointer _tmp170_;
			ValaList* _tmp171_;
			ValaList* _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			gpointer _tmp175_;
			ValaVariable* _tmp176_;
			_tmp163_ = _phi_it;
			if (!vala_iterator_next (_tmp163_)) {
				break;
			}
			_tmp164_ = _phi_it;
			_tmp165_ = vala_iterator_get (_tmp164_);
			phi = (ValaPhiFunction*) _tmp165_;
			_tmp166_ = self->priv->var_map;
			_tmp167_ = phi;
			_tmp168_ = vala_phi_function_get_original_variable (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_map_get (_tmp166_, (ValaSymbol*) _tmp169_);
			variable_stack = (ValaList*) _tmp170_;
			_tmp171_ = variable_stack;
			_tmp172_ = variable_stack;
			_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_list_remove_at (_tmp171_, _tmp174_ - 1);
			_tmp176_ = (ValaVariable*) _tmp175_;
			_vala_code_node_unref0 (_tmp176_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp177_;
		gint _node_size = 0;
		ValaList* _tmp178_;
		gint _tmp179_;
		gint _tmp180_;
		gint _node_index = 0;
		_tmp177_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp177_;
		_tmp178_ = _node_list;
		_tmp179_ = vala_collection_get_size ((ValaCollection*) _tmp178_);
		_tmp180_ = _tmp179_;
		_node_size = _tmp180_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp181_;
			gint _tmp182_;
			gint _tmp183_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp184_;
			gint _tmp185_;
			gpointer _tmp186_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp187_;
			ValaArrayList* _tmp188_;
			ValaCodeNode* _tmp189_;
			ValaArrayList* _tmp190_;
			_tmp181_ = _node_index;
			_node_index = _tmp181_ + 1;
			_tmp182_ = _node_index;
			_tmp183_ = _node_size;
			if (!(_tmp182_ < _tmp183_)) {
				break;
			}
			_tmp184_ = _node_list;
			_tmp185_ = _node_index;
			_tmp186_ = vala_list_get (_tmp184_, _tmp185_);
			node = (ValaCodeNode*) _tmp186_;
			_tmp187_ = g_direct_equal;
			_tmp188_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp187_);
			defined_variables = _tmp188_;
			_tmp189_ = node;
			_tmp190_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp189_, (ValaCollection*) _tmp190_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp191_;
				ValaArrayList* _tmp192_;
				gint _variable_size = 0;
				ValaArrayList* _tmp193_;
				gint _tmp194_;
				gint _tmp195_;
				gint _variable_index = 0;
				_tmp191_ = defined_variables;
				_tmp192_ = _vala_iterable_ref0 (_tmp191_);
				_variable_list = _tmp192_;
				_tmp193_ = _variable_list;
				_tmp194_ = vala_collection_get_size ((ValaCollection*) _tmp193_);
				_tmp195_ = _tmp194_;
				_variable_size = _tmp195_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp196_;
					gint _tmp197_;
					gint _tmp198_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp199_;
					gint _tmp200_;
					gpointer _tmp201_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp202_;
					ValaVariable* _tmp203_;
					gpointer _tmp204_;
					ValaList* _tmp205_;
					ValaList* _tmp206_;
					gint _tmp207_;
					gint _tmp208_;
					gpointer _tmp209_;
					ValaVariable* _tmp210_;
					_tmp196_ = _variable_index;
					_variable_index = _tmp196_ + 1;
					_tmp197_ = _variable_index;
					_tmp198_ = _variable_size;
					if (!(_tmp197_ < _tmp198_)) {
						break;
					}
					_tmp199_ = _variable_list;
					_tmp200_ = _variable_index;
					_tmp201_ = vala_list_get ((ValaList*) _tmp199_, _tmp200_);
					variable = (ValaVariable*) _tmp201_;
					_tmp202_ = self->priv->var_map;
					_tmp203_ = variable;
					_tmp204_ = vala_map_get (_tmp202_, (ValaSymbol*) _tmp203_);
					variable_stack = (ValaList*) _tmp204_;
					_tmp205_ = variable_stack;
					_tmp206_ = variable_stack;
					_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
					_tmp208_ = _tmp207_;
					_tmp209_ = vala_list_remove_at (_tmp205_, _tmp208_ - 1);
					_tmp210_ = (ValaVariable*) _tmp209_;
					_vala_code_node_unref0 (_tmp210_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static ValaVariable*
vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                       ValaMap* var_map,
                                       ValaVariable* var_symbol)
{
	ValaVariable* result = NULL;
	ValaList* variable_stack = NULL;
	gpointer _tmp0_;
	ValaList* _tmp1_;
	ValaVariable* versioned_var = NULL;
	ValaList* _tmp23_;
	ValaVariable* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = vala_map_get (var_map, (ValaSymbol*) var_symbol);
	variable_stack = (ValaList*) _tmp0_;
	_tmp1_ = variable_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp3_;
		_tmp4_ = variable_stack;
		vala_map_set (var_map, (ValaSymbol*) var_symbol, _tmp4_);
		vala_variable_set_single_assignment (var_symbol, TRUE);
	} else {
		vala_variable_set_single_assignment (var_symbol, FALSE);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (var_symbol, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaLocalVariable* _tmp13_;
		_tmp5_ = vala_variable_get_variable_type (var_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_local_variable_new (_tmp8_, _tmp10_, NULL, _tmp12_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp13_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type (var_symbol);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new (_tmp15_, _tmp19_, _tmp21_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp22_;
		_vala_code_node_unref0 (_tmp19_);
	}
	_tmp23_ = variable_stack;
	_tmp24_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}


static void
vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                               ValaCreationMethod* m)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}


static void
vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                        ValaProperty* prop)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                 ValaPropertyAccessor* acc)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) acc);
}


static void
vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                     ValaBlock* b)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                     ValaDeclarationStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaBasicBlock* _tmp16_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaLocalVariable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaLocalVariable* _tmp21_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_declaration_statement_get_declaration (stmt);
		_tmp1_ = _tmp0_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp1_, TRUE);
		return;
	}
	_tmp2_ = vala_declaration_statement_get_declaration (stmt);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_used (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = vala_declaration_statement_get_declaration (stmt);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_declaration_statement_get_declaration (stmt);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("local variable `%s' declared but never used", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_warning (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp16_, (ValaCodeNode*) stmt);
	_tmp17_ = vala_declaration_statement_get_declaration (stmt);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp18_) : NULL);
	local = _tmp19_;
	_tmp21_ = local;
	if (_tmp21_ != NULL) {
		ValaLocalVariable* _tmp22_;
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp22_ = local;
		_tmp23_ = vala_variable_get_initializer ((ValaVariable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaLocalVariable* _tmp25_;
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp25_ = local;
		_tmp26_ = vala_variable_get_initializer ((ValaVariable*) _tmp25_);
		_tmp27_ = _tmp26_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp27_, FALSE);
	}
	_vala_code_node_unref0 (local);
}


static void
vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                              ValaLocalVariable* local)
{
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
}


static void
vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                    ValaExpressionStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, FALSE);
	_tmp1_ = vala_expression_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_METHOD_CALL)) {
		ValaMethodCall* expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaMethodCall* _tmp5_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaMemberAccess* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMemberAccess* _tmp12_;
		_tmp3_ = vala_expression_statement_get_expression (stmt);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
		expr = _tmp5_;
		_tmp6_ = expr;
		_tmp7_ = vala_method_call_get_call (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp8_) : NULL);
		ma = _tmp9_;
		_tmp12_ = ma;
		if (_tmp12_ != NULL) {
			ValaMemberAccess* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp13_ = ma;
			_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaMemberAccess* _tmp16_;
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaAttribute* _tmp19_;
			_tmp16_ = ma;
			_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp18_, "NoReturn");
			_tmp10_ = _tmp19_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			vala_flow_analyzer_mark_unreachable (self);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
			return;
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
}


static gboolean
vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void
vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                            ValaIfStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp14_;
	ValaBlock* _tmp15_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp29_;
	ValaBasicBlock* _tmp30_;
	gboolean _tmp31_ = FALSE;
	ValaBasicBlock* _tmp32_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_if_statement_get_condition (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_if_statement_get_condition (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = _vala_basic_block_ref0 (_tmp5_);
	last_block = _tmp6_;
	_tmp7_ = vala_if_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	if (vala_flow_analyzer_always_false (self, _tmp8_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp9_;
		ValaSet* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* _tmp12_;
		ValaBasicBlock* _tmp13_;
		_tmp9_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp9_;
		_tmp10_ = self->priv->all_basic_blocks;
		_tmp11_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
		_tmp12_ = last_block;
		_tmp13_ = self->priv->current_block;
		vala_basic_block_connect (_tmp12_, _tmp13_);
	}
	_tmp14_ = vala_if_statement_get_true_statement (stmt);
	_tmp15_ = _tmp14_;
	vala_code_node_accept ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
	_tmp16_ = self->priv->current_block;
	_tmp17_ = _vala_basic_block_ref0 (_tmp16_);
	last_true_block = _tmp17_;
	_tmp18_ = vala_if_statement_get_condition (stmt);
	_tmp19_ = _tmp18_;
	if (vala_flow_analyzer_always_true (self, _tmp19_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp20_;
		ValaSet* _tmp21_;
		ValaBasicBlock* _tmp22_;
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp20_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp20_;
		_tmp21_ = self->priv->all_basic_blocks;
		_tmp22_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
		_tmp23_ = last_block;
		_tmp24_ = self->priv->current_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = vala_if_statement_get_false_statement (stmt);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaBlock* _tmp27_;
		ValaBlock* _tmp28_;
		_tmp27_ = vala_if_statement_get_false_statement (stmt);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, (ValaCodeVisitor*) self);
	}
	_tmp29_ = self->priv->current_block;
	_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
	last_false_block = _tmp30_;
	_tmp32_ = last_true_block;
	if (_tmp32_ != NULL) {
		_tmp31_ = TRUE;
	} else {
		ValaBasicBlock* _tmp33_;
		_tmp33_ = last_false_block;
		_tmp31_ = _tmp33_ != NULL;
	}
	if (_tmp31_) {
		ValaBasicBlock* _tmp34_;
		ValaSet* _tmp35_;
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		ValaBasicBlock* _tmp40_;
		_tmp34_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp34_;
		_tmp35_ = self->priv->all_basic_blocks;
		_tmp36_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp35_, _tmp36_);
		_tmp37_ = last_true_block;
		if (_tmp37_ != NULL) {
			ValaBasicBlock* _tmp38_;
			ValaBasicBlock* _tmp39_;
			_tmp38_ = last_true_block;
			_tmp39_ = self->priv->current_block;
			vala_basic_block_connect (_tmp38_, _tmp39_);
		}
		_tmp40_ = last_false_block;
		if (_tmp40_ != NULL) {
			ValaBasicBlock* _tmp41_;
			ValaBasicBlock* _tmp42_;
			_tmp41_ = last_false_block;
			_tmp42_ = self->priv->current_block;
			vala_basic_block_connect (_tmp41_, _tmp42_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}


static void
vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                ValaSwitchStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	gboolean has_default_label = FALSE;
	gboolean _tmp49_;
	ValaBasicBlock* _tmp52_;
	ValaList* _tmp53_;
	ValaList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gboolean _tmp57_;
	ValaList* _tmp60_;
	ValaList* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gpointer _tmp64_;
	ValaFlowAnalyzerJumpTarget* _tmp65_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	after_switch_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = after_switch_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = after_switch_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_break_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = self->priv->current_block;
	_tmp8_ = vala_switch_statement_get_expression (stmt);
	_tmp9_ = _tmp8_;
	vala_basic_block_add_node (_tmp7_, (ValaCodeNode*) _tmp9_);
	_tmp10_ = self->priv->current_block;
	_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
	condition_block = _tmp11_;
	_tmp12_ = vala_switch_statement_get_expression (stmt);
	_tmp13_ = _tmp12_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp13_, FALSE);
	has_default_label = FALSE;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp14_;
		gint _section_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _section_index = 0;
		_tmp14_ = vala_switch_statement_get_sections (stmt);
		_section_list = _tmp14_;
		_tmp15_ = _section_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_section_size = _tmp17_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaBasicBlock* _tmp24_;
			ValaSet* _tmp25_;
			ValaBasicBlock* _tmp26_;
			ValaBasicBlock* _tmp27_;
			ValaBasicBlock* _tmp28_;
			ValaSwitchSection* _tmp41_;
			ValaBasicBlock* _tmp42_;
			_tmp18_ = _section_index;
			_section_index = _tmp18_ + 1;
			_tmp19_ = _section_index;
			_tmp20_ = _section_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _section_list;
			_tmp22_ = _section_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			section = (ValaSwitchSection*) _tmp23_;
			_tmp24_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp24_;
			_tmp25_ = self->priv->all_basic_blocks;
			_tmp26_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp25_, _tmp26_);
			_tmp27_ = condition_block;
			_tmp28_ = self->priv->current_block;
			vala_basic_block_connect (_tmp27_, _tmp28_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp29_;
				ValaList* _tmp30_;
				gint _section_stmt_size = 0;
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _section_stmt_index = 0;
				_tmp29_ = section;
				_tmp30_ = vala_block_get_statements ((ValaBlock*) _tmp29_);
				_section_stmt_list = _tmp30_;
				_tmp31_ = _section_stmt_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_section_stmt_size = _tmp33_;
				_section_stmt_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp37_;
					gint _tmp38_;
					gpointer _tmp39_;
					ValaStatement* _tmp40_;
					_tmp34_ = _section_stmt_index;
					_section_stmt_index = _tmp34_ + 1;
					_tmp35_ = _section_stmt_index;
					_tmp36_ = _section_stmt_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _section_stmt_list;
					_tmp38_ = _section_stmt_index;
					_tmp39_ = vala_list_get (_tmp37_, _tmp38_);
					section_stmt = (ValaStatement*) _tmp39_;
					_tmp40_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp40_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			_tmp41_ = section;
			if (vala_switch_section_has_default_label (_tmp41_)) {
				has_default_label = TRUE;
			}
			_tmp42_ = self->priv->current_block;
			if (_tmp42_ != NULL) {
				ValaSwitchSection* _tmp43_;
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaSwitchSection* _tmp46_;
				ValaBasicBlock* _tmp47_;
				ValaBasicBlock* _tmp48_;
				_tmp43_ = section;
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp45_, "missing break statement at end of switch section");
				_tmp46_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp46_, TRUE);
				_tmp47_ = self->priv->current_block;
				_tmp48_ = after_switch_block;
				vala_basic_block_connect (_tmp47_, _tmp48_);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp49_ = has_default_label;
	if (!_tmp49_) {
		ValaBasicBlock* _tmp50_;
		ValaBasicBlock* _tmp51_;
		_tmp50_ = condition_block;
		_tmp51_ = after_switch_block;
		vala_basic_block_connect (_tmp50_, _tmp51_);
	}
	_tmp52_ = after_switch_block;
	_tmp53_ = vala_basic_block_get_predecessors (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = _tmp56_ > 0;
	_vala_iterable_unref0 (_tmp54_);
	if (_tmp57_) {
		ValaBasicBlock* _tmp58_;
		ValaBasicBlock* _tmp59_;
		_tmp58_ = after_switch_block;
		_tmp59_ = _vala_basic_block_ref0 (_tmp58_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp59_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp60_ = self->priv->jump_stack;
	_tmp61_ = self->priv->jump_stack;
	_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_list_remove_at (_tmp60_, _tmp63_ - 1);
	_tmp65_ = (ValaFlowAnalyzerJumpTarget*) _tmp64_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp65_);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}


static void
vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                    ValaLoop* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp7_;
	ValaSet* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaList* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaFlowAnalyzerJumpTarget* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaList* _tmp33_;
	ValaList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gpointer _tmp37_;
	ValaFlowAnalyzerJumpTarget* _tmp38_;
	ValaList* _tmp39_;
	ValaList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gpointer _tmp43_;
	ValaFlowAnalyzerJumpTarget* _tmp44_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	loop_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = loop_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = vala_basic_block_new ();
	after_loop_block = _tmp7_;
	_tmp8_ = self->priv->all_basic_blocks;
	_tmp9_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
	_tmp10_ = self->priv->jump_stack;
	_tmp11_ = after_loop_block;
	_tmp12_ = vala_flow_analyzer_jump_target_new_break_target (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_collection_add ((ValaCollection*) _tmp10_, _tmp13_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp13_);
	_tmp14_ = self->priv->current_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	last_block = _tmp15_;
	_tmp16_ = last_block;
	_tmp17_ = loop_block;
	vala_basic_block_connect (_tmp16_, _tmp17_);
	_tmp18_ = loop_block;
	_tmp19_ = _vala_basic_block_ref0 (_tmp18_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp19_;
	_tmp20_ = vala_loop_get_body (stmt);
	_tmp21_ = _tmp20_;
	vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->current_block;
	if (_tmp22_ != NULL) {
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp23_ = self->priv->current_block;
		_tmp24_ = loop_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = after_loop_block;
	_tmp26_ = vala_basic_block_get_predecessors (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_ == 0;
	_vala_iterable_unref0 (_tmp27_);
	if (_tmp30_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp31_;
		ValaBasicBlock* _tmp32_;
		_tmp31_ = after_loop_block;
		_tmp32_ = _vala_basic_block_ref0 (_tmp31_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp32_;
	}
	_tmp33_ = self->priv->jump_stack;
	_tmp34_ = self->priv->jump_stack;
	_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_list_remove_at (_tmp33_, _tmp36_ - 1);
	_tmp38_ = (ValaFlowAnalyzerJumpTarget*) _tmp37_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp38_);
	_tmp39_ = self->priv->jump_stack;
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_list_remove_at (_tmp39_, _tmp42_ - 1);
	_tmp44_ = (ValaFlowAnalyzerJumpTarget*) _tmp43_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp44_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                 ValaForeachStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaSet* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaFlowAnalyzerJumpTarget* _tmp10_;
	ValaFlowAnalyzerJumpTarget* _tmp11_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp12_;
	ValaSet* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaList* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaFlowAnalyzerJumpTarget* _tmp17_;
	ValaFlowAnalyzerJumpTarget* _tmp18_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBlock* _tmp27_;
	ValaBasicBlock* _tmp28_;
	ValaBasicBlock* _tmp31_;
	ValaBasicBlock* _tmp32_;
	ValaBasicBlock* _tmp33_;
	ValaBasicBlock* _tmp36_;
	ValaBasicBlock* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gpointer _tmp42_;
	ValaFlowAnalyzerJumpTarget* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_;
	ValaFlowAnalyzerJumpTarget* _tmp49_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_foreach_statement_get_collection (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_foreach_statement_get_collection (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_basic_block_new ();
	loop_block = _tmp5_;
	_tmp6_ = self->priv->all_basic_blocks;
	_tmp7_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->jump_stack;
	_tmp9_ = loop_block;
	_tmp10_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp11_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp11_);
	_tmp12_ = vala_basic_block_new ();
	after_loop_block = _tmp12_;
	_tmp13_ = self->priv->all_basic_blocks;
	_tmp14_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->jump_stack;
	_tmp16_ = after_loop_block;
	_tmp17_ = vala_flow_analyzer_jump_target_new_break_target (_tmp16_);
	_tmp18_ = _tmp17_;
	vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
	_tmp19_ = self->priv->current_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	last_block = _tmp20_;
	_tmp21_ = last_block;
	_tmp22_ = loop_block;
	vala_basic_block_connect (_tmp21_, _tmp22_);
	_tmp23_ = loop_block;
	_tmp24_ = _vala_basic_block_ref0 (_tmp23_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp24_;
	_tmp25_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp25_, (ValaCodeNode*) stmt);
	_tmp26_ = vala_foreach_statement_get_body (stmt);
	_tmp27_ = _tmp26_;
	vala_code_node_accept ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
	_tmp28_ = self->priv->current_block;
	if (_tmp28_ != NULL) {
		ValaBasicBlock* _tmp29_;
		ValaBasicBlock* _tmp30_;
		_tmp29_ = self->priv->current_block;
		_tmp30_ = loop_block;
		vala_basic_block_connect (_tmp29_, _tmp30_);
	}
	_tmp31_ = last_block;
	_tmp32_ = after_loop_block;
	vala_basic_block_connect (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->current_block;
	if (_tmp33_ != NULL) {
		ValaBasicBlock* _tmp34_;
		ValaBasicBlock* _tmp35_;
		_tmp34_ = self->priv->current_block;
		_tmp35_ = after_loop_block;
		vala_basic_block_connect (_tmp34_, _tmp35_);
	}
	_tmp36_ = after_loop_block;
	_tmp37_ = _vala_basic_block_ref0 (_tmp36_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp37_;
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = self->priv->jump_stack;
	_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_list_remove_at (_tmp38_, _tmp41_ - 1);
	_tmp43_ = (ValaFlowAnalyzerJumpTarget*) _tmp42_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp43_);
	_tmp44_ = self->priv->jump_stack;
	_tmp45_ = self->priv->jump_stack;
	_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_list_remove_at (_tmp44_, _tmp47_ - 1);
	_tmp49_ = (ValaFlowAnalyzerJumpTarget*) _tmp48_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp49_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                               ValaBreakStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop or switch statement found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                  ValaContinueStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                ValaReturnStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	_tmp1_ = vala_return_statement_get_return_expression (stmt);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_return_statement_get_return_expression (stmt);
		_tmp4_ = _tmp3_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->jump_stack;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		i = _tmp7_ - 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaFlowAnalyzerJumpTarget* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ - 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ >= 0)) {
					break;
				}
				_tmp11_ = self->priv->jump_stack;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp13_;
				_tmp14_ = jump_target;
				_tmp15_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					ValaBasicBlock* _tmp17_;
					ValaFlowAnalyzerJumpTarget* _tmp18_;
					ValaBasicBlock* _tmp19_;
					ValaBasicBlock* _tmp20_;
					_tmp17_ = self->priv->current_block;
					_tmp18_ = jump_target;
					_tmp19_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp18_);
					_tmp20_ = _tmp19_;
					vala_basic_block_connect (_tmp17_, _tmp20_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp21_;
					gboolean _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = jump_target;
					_tmp22_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_) {
						ValaBasicBlock* _tmp24_;
						ValaFlowAnalyzerJumpTarget* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						ValaFlowAnalyzerJumpTarget* _tmp28_;
						ValaBasicBlock* _tmp29_;
						ValaBasicBlock* _tmp30_;
						ValaBasicBlock* _tmp31_;
						_tmp24_ = self->priv->current_block;
						_tmp25_ = jump_target;
						_tmp26_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp25_);
						_tmp27_ = _tmp26_;
						vala_basic_block_connect (_tmp24_, _tmp27_);
						_tmp28_ = jump_target;
						_tmp29_ = vala_flow_analyzer_jump_target_get_last_block (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = _vala_basic_block_ref0 (_tmp30_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp31_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp33_ = _tmp32_;
	vala_report_error (_tmp33_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                  ValaCodeNode* node,
                                  gboolean always_fail)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_code_node_get_tree_can_fail (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp2_;
		ValaBasicBlock* _tmp3_;
		_tmp2_ = self->priv->current_block;
		_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
		last_block = _tmp3_;
		{
			ValaList* _error_data_type_list = NULL;
			ValaList* _tmp4_;
			gint _error_data_type_size = 0;
			ValaList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _error_data_type_index = 0;
			_tmp4_ = vala_code_node_get_error_types (node);
			_error_data_type_list = _tmp4_;
			_tmp5_ = _error_data_type_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_error_data_type_size = _tmp7_;
			_error_data_type_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaDataType* error_data_type = NULL;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp14_;
				ValaErrorType* _tmp15_;
				ValaClass* error_class = NULL;
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaClass* _tmp19_;
				ValaBasicBlock* _tmp20_;
				ValaBasicBlock* _tmp21_;
				_tmp8_ = _error_data_type_index;
				_error_data_type_index = _tmp8_ + 1;
				_tmp9_ = _error_data_type_index;
				_tmp10_ = _error_data_type_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _error_data_type_list;
				_tmp12_ = _error_data_type_index;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				error_data_type = (ValaDataType*) _tmp13_;
				_tmp14_ = error_data_type;
				_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp14_) : NULL);
				error_type = _tmp15_;
				_tmp16_ = error_data_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp18_) : NULL);
				error_class = _tmp19_;
				_tmp20_ = last_block;
				_tmp21_ = _vala_basic_block_ref0 (_tmp20_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp21_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					_tmp22_ = self->priv->jump_stack;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					i = _tmp24_ - 1;
					{
						gboolean _tmp25_ = FALSE;
						_tmp25_ = TRUE;
						while (TRUE) {
							gint _tmp27_;
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp28_;
							gint _tmp29_;
							gpointer _tmp30_;
							ValaFlowAnalyzerJumpTarget* _tmp31_;
							gboolean _tmp32_;
							gboolean _tmp33_;
							if (!_tmp25_) {
								gint _tmp26_;
								_tmp26_ = i;
								i = _tmp26_ - 1;
							}
							_tmp25_ = FALSE;
							_tmp27_ = i;
							if (!(_tmp27_ >= 0)) {
								break;
							}
							_tmp28_ = self->priv->jump_stack;
							_tmp29_ = i;
							_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp30_;
							_tmp31_ = jump_target;
							_tmp32_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp31_);
							_tmp33_ = _tmp32_;
							if (_tmp33_) {
								ValaBasicBlock* _tmp34_;
								ValaFlowAnalyzerJumpTarget* _tmp35_;
								ValaBasicBlock* _tmp36_;
								ValaBasicBlock* _tmp37_;
								_tmp34_ = self->priv->current_block;
								_tmp35_ = jump_target;
								_tmp36_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp35_);
								_tmp37_ = _tmp36_;
								vala_basic_block_connect (_tmp34_, _tmp37_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp38_;
								gboolean _tmp39_;
								gboolean _tmp40_;
								_tmp38_ = jump_target;
								_tmp39_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp38_);
								_tmp40_ = _tmp39_;
								if (_tmp40_) {
									ValaCodeContext* _tmp41_;
									ValaProfile _tmp42_;
									ValaProfile _tmp43_;
									_tmp41_ = self->priv->context;
									_tmp42_ = vala_code_context_get_profile (_tmp41_);
									_tmp43_ = _tmp42_;
									if (_tmp43_ == VALA_PROFILE_GOBJECT) {
										gboolean _tmp44_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp45_;
										ValaErrorDomain* _tmp46_;
										ValaErrorDomain* _tmp47_;
										_tmp45_ = jump_target;
										_tmp46_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp45_);
										_tmp47_ = _tmp46_;
										if (_tmp47_ == NULL) {
											_tmp44_ = TRUE;
										} else {
											gboolean _tmp48_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp49_;
											ValaErrorDomain* _tmp50_;
											ValaErrorDomain* _tmp51_;
											ValaErrorType* _tmp52_;
											ValaErrorDomain* _tmp53_;
											ValaErrorDomain* _tmp54_;
											_tmp49_ = jump_target;
											_tmp50_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp49_);
											_tmp51_ = _tmp50_;
											_tmp52_ = error_type;
											_tmp53_ = vala_error_type_get_error_domain (_tmp52_);
											_tmp54_ = _tmp53_;
											if (_tmp51_ == _tmp54_) {
												gboolean _tmp55_ = FALSE;
												ValaFlowAnalyzerJumpTarget* _tmp56_;
												ValaErrorCode* _tmp57_;
												ValaErrorCode* _tmp58_;
												_tmp56_ = jump_target;
												_tmp57_ = vala_flow_analyzer_jump_target_get_error_code (_tmp56_);
												_tmp58_ = _tmp57_;
												if (_tmp58_ == NULL) {
													_tmp55_ = TRUE;
												} else {
													ValaFlowAnalyzerJumpTarget* _tmp59_;
													ValaErrorCode* _tmp60_;
													ValaErrorCode* _tmp61_;
													ValaErrorType* _tmp62_;
													ValaErrorCode* _tmp63_;
													ValaErrorCode* _tmp64_;
													_tmp59_ = jump_target;
													_tmp60_ = vala_flow_analyzer_jump_target_get_error_code (_tmp59_);
													_tmp61_ = _tmp60_;
													_tmp62_ = error_type;
													_tmp63_ = vala_error_type_get_error_code (_tmp62_);
													_tmp64_ = _tmp63_;
													_tmp55_ = _tmp61_ == _tmp64_;
												}
												_tmp48_ = _tmp55_;
											} else {
												_tmp48_ = FALSE;
											}
											_tmp44_ = _tmp48_;
										}
										if (_tmp44_) {
											ValaBasicBlock* _tmp65_;
											ValaFlowAnalyzerJumpTarget* _tmp66_;
											ValaBasicBlock* _tmp67_;
											ValaBasicBlock* _tmp68_;
											_tmp65_ = self->priv->current_block;
											_tmp66_ = jump_target;
											_tmp67_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp66_);
											_tmp68_ = _tmp67_;
											vala_basic_block_connect (_tmp65_, _tmp68_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											gboolean _tmp69_ = FALSE;
											ValaErrorType* _tmp70_;
											ValaErrorDomain* _tmp71_;
											ValaErrorDomain* _tmp72_;
											_tmp70_ = error_type;
											_tmp71_ = vala_error_type_get_error_domain (_tmp70_);
											_tmp72_ = _tmp71_;
											if (_tmp72_ == NULL) {
												_tmp69_ = TRUE;
											} else {
												gboolean _tmp73_ = FALSE;
												ValaErrorType* _tmp74_;
												ValaErrorDomain* _tmp75_;
												ValaErrorDomain* _tmp76_;
												ValaFlowAnalyzerJumpTarget* _tmp77_;
												ValaErrorDomain* _tmp78_;
												ValaErrorDomain* _tmp79_;
												_tmp74_ = error_type;
												_tmp75_ = vala_error_type_get_error_domain (_tmp74_);
												_tmp76_ = _tmp75_;
												_tmp77_ = jump_target;
												_tmp78_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp77_);
												_tmp79_ = _tmp78_;
												if (_tmp76_ == _tmp79_) {
													gboolean _tmp80_ = FALSE;
													ValaErrorType* _tmp81_;
													ValaErrorCode* _tmp82_;
													ValaErrorCode* _tmp83_;
													_tmp81_ = error_type;
													_tmp82_ = vala_error_type_get_error_code (_tmp81_);
													_tmp83_ = _tmp82_;
													if (_tmp83_ == NULL) {
														_tmp80_ = TRUE;
													} else {
														ValaErrorType* _tmp84_;
														ValaErrorCode* _tmp85_;
														ValaErrorCode* _tmp86_;
														ValaFlowAnalyzerJumpTarget* _tmp87_;
														ValaErrorCode* _tmp88_;
														ValaErrorCode* _tmp89_;
														_tmp84_ = error_type;
														_tmp85_ = vala_error_type_get_error_code (_tmp84_);
														_tmp86_ = _tmp85_;
														_tmp87_ = jump_target;
														_tmp88_ = vala_flow_analyzer_jump_target_get_error_code (_tmp87_);
														_tmp89_ = _tmp88_;
														_tmp80_ = _tmp86_ == _tmp89_;
													}
													_tmp73_ = _tmp80_;
												} else {
													_tmp73_ = FALSE;
												}
												_tmp69_ = _tmp73_;
											}
											if (_tmp69_) {
												ValaBasicBlock* _tmp90_;
												ValaFlowAnalyzerJumpTarget* _tmp91_;
												ValaBasicBlock* _tmp92_;
												ValaBasicBlock* _tmp93_;
												_tmp90_ = self->priv->current_block;
												_tmp91_ = jump_target;
												_tmp92_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp91_);
												_tmp93_ = _tmp92_;
												vala_basic_block_connect (_tmp90_, _tmp93_);
											}
										}
									} else {
										gboolean _tmp94_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp95_;
										ValaClass* _tmp96_;
										ValaClass* _tmp97_;
										_tmp95_ = jump_target;
										_tmp96_ = vala_flow_analyzer_jump_target_get_error_class (_tmp95_);
										_tmp97_ = _tmp96_;
										if (_tmp97_ == NULL) {
											_tmp94_ = TRUE;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp98_;
											ValaClass* _tmp99_;
											ValaClass* _tmp100_;
											ValaClass* _tmp101_;
											_tmp98_ = jump_target;
											_tmp99_ = vala_flow_analyzer_jump_target_get_error_class (_tmp98_);
											_tmp100_ = _tmp99_;
											_tmp101_ = error_class;
											_tmp94_ = _tmp100_ == _tmp101_;
										}
										if (_tmp94_) {
											ValaBasicBlock* _tmp102_;
											ValaFlowAnalyzerJumpTarget* _tmp103_;
											ValaBasicBlock* _tmp104_;
											ValaBasicBlock* _tmp105_;
											_tmp102_ = self->priv->current_block;
											_tmp103_ = jump_target;
											_tmp104_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp103_);
											_tmp105_ = _tmp104_;
											vala_basic_block_connect (_tmp102_, _tmp105_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp106_;
											ValaClass* _tmp107_;
											ValaClass* _tmp108_;
											ValaClass* _tmp109_;
											_tmp106_ = jump_target;
											_tmp107_ = vala_flow_analyzer_jump_target_get_error_class (_tmp106_);
											_tmp108_ = _tmp107_;
											_tmp109_ = error_class;
											if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp108_, (ValaTypeSymbol*) _tmp109_)) {
												ValaBasicBlock* _tmp110_;
												ValaFlowAnalyzerJumpTarget* _tmp111_;
												ValaBasicBlock* _tmp112_;
												ValaBasicBlock* _tmp113_;
												_tmp110_ = self->priv->current_block;
												_tmp111_ = jump_target;
												_tmp112_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp111_);
												_tmp113_ = _tmp112_;
												vala_basic_block_connect (_tmp110_, _tmp113_);
											}
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp114_;
									gboolean _tmp115_;
									gboolean _tmp116_;
									_tmp114_ = jump_target;
									_tmp115_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp114_);
									_tmp116_ = _tmp115_;
									if (_tmp116_) {
										ValaBasicBlock* _tmp117_;
										ValaFlowAnalyzerJumpTarget* _tmp118_;
										ValaBasicBlock* _tmp119_;
										ValaBasicBlock* _tmp120_;
										ValaFlowAnalyzerJumpTarget* _tmp121_;
										ValaBasicBlock* _tmp122_;
										ValaBasicBlock* _tmp123_;
										ValaBasicBlock* _tmp124_;
										_tmp117_ = self->priv->current_block;
										_tmp118_ = jump_target;
										_tmp119_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp118_);
										_tmp120_ = _tmp119_;
										vala_basic_block_connect (_tmp117_, _tmp120_);
										_tmp121_ = jump_target;
										_tmp122_ = vala_flow_analyzer_jump_target_get_last_block (_tmp121_);
										_tmp123_ = _tmp122_;
										_tmp124_ = _vala_basic_block_ref0 (_tmp123_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp124_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_class);
				_vala_code_node_unref0 (error_type);
				_vala_code_node_unref0 (error_data_type);
			}
			_vala_iterable_unref0 (_error_data_type_list);
		}
		if (!always_fail) {
			ValaBasicBlock* _tmp125_;
			ValaSet* _tmp126_;
			ValaBasicBlock* _tmp127_;
			ValaBasicBlock* _tmp128_;
			ValaBasicBlock* _tmp129_;
			_tmp125_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp125_;
			_tmp126_ = self->priv->all_basic_blocks;
			_tmp127_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp126_, _tmp127_);
			_tmp128_ = last_block;
			_tmp129_ = self->priv->current_block;
			vala_basic_block_connect (_tmp128_, _tmp129_);
		}
		_vala_basic_block_unref0 (last_block);
	}
}


static void
vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                               ValaYieldStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaSet* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* finally_block = NULL;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	ValaList* catch_clauses = NULL;
	ValaList* _tmp43_;
	ValaBasicBlock* _tmp96_;
	ValaBasicBlock* _tmp97_;
	ValaBlock* _tmp98_;
	ValaBlock* _tmp99_;
	ValaBasicBlock* _tmp100_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp108_;
	ValaArrayList* _tmp109_;
	ValaBasicBlock* _tmp206_;
	ValaBasicBlock* _tmp213_;
	ValaList* _tmp214_;
	ValaList* _tmp215_;
	gint _tmp216_;
	gint _tmp217_;
	gboolean _tmp218_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	before_try_block = _tmp1_;
	_tmp2_ = vala_basic_block_new ();
	after_try_block = _tmp2_;
	_tmp3_ = self->priv->all_basic_blocks;
	_tmp4_ = after_try_block;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp4_);
	finally_block = NULL;
	_tmp5_ = vala_try_statement_get_finally_body (stmt);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaBasicBlock* _tmp7_;
		ValaSet* _tmp8_;
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp12_;
		ValaSet* _tmp13_;
		ValaBasicBlock* _tmp14_;
		ValaList* _tmp15_;
		ValaBasicBlock* _tmp16_;
		ValaFlowAnalyzerJumpTarget* _tmp17_;
		ValaFlowAnalyzerJumpTarget* _tmp18_;
		ValaBlock* _tmp19_;
		ValaBlock* _tmp20_;
		ValaBasicBlock* _tmp21_;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gboolean _tmp26_;
		ValaList* _tmp29_;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gpointer _tmp33_;
		ValaFlowAnalyzerJumpTarget* _tmp34_;
		ValaList* _tmp35_;
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		ValaFlowAnalyzerJumpTarget* _tmp38_;
		ValaFlowAnalyzerJumpTarget* _tmp39_;
		_tmp7_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp7_;
		_tmp8_ = self->priv->all_basic_blocks;
		_tmp9_ = finally_block;
		vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
		_tmp10_ = finally_block;
		_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp11_;
		_tmp12_ = vala_basic_block_new ();
		invalid_block = _tmp12_;
		_tmp13_ = self->priv->all_basic_blocks;
		_tmp14_ = invalid_block;
		vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		_tmp15_ = self->priv->jump_stack;
		_tmp16_ = invalid_block;
		_tmp17_ = vala_flow_analyzer_jump_target_new_any_target (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
		_tmp19_ = vala_try_statement_get_finally_body (stmt);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
		_tmp21_ = invalid_block;
		_tmp22_ = vala_basic_block_get_predecessors (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_ > 0;
		_vala_iterable_unref0 (_tmp23_);
		if (_tmp26_) {
			ValaSourceReference* _tmp27_;
			ValaSourceReference* _tmp28_;
			_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp28_ = _tmp27_;
			vala_report_error (_tmp28_, "jump out of finally block not permitted");
			vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp29_ = self->priv->jump_stack;
		_tmp30_ = self->priv->jump_stack;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_list_remove_at (_tmp29_, _tmp32_ - 1);
		_tmp34_ = (ValaFlowAnalyzerJumpTarget*) _tmp33_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp34_);
		_tmp35_ = self->priv->jump_stack;
		_tmp36_ = finally_block;
		_tmp37_ = self->priv->current_block;
		_tmp38_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		vala_collection_add ((ValaCollection*) _tmp35_, _tmp39_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp39_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	finally_jump_stack_size = _tmp42_;
	_tmp43_ = vala_try_statement_get_catch_clauses (stmt);
	catch_clauses = _tmp43_;
	{
		gint i = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		_tmp44_ = catch_clauses;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		i = _tmp46_ - 1;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				gint _tmp49_;
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_;
				ValaBasicBlock* error_block = NULL;
				ValaBasicBlock* _tmp53_;
				ValaSet* _tmp54_;
				ValaBasicBlock* _tmp55_;
				ValaCatchClause* _tmp56_;
				ValaDataType* _tmp57_;
				ValaDataType* _tmp58_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ - 1;
				}
				_tmp47_ = FALSE;
				_tmp49_ = i;
				if (!(_tmp49_ >= 0)) {
					break;
				}
				_tmp50_ = catch_clauses;
				_tmp51_ = i;
				_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
				catch_clause = (ValaCatchClause*) _tmp52_;
				_tmp53_ = vala_basic_block_new ();
				error_block = _tmp53_;
				_tmp54_ = self->priv->all_basic_blocks;
				_tmp55_ = error_block;
				vala_collection_add ((ValaCollection*) _tmp54_, _tmp55_);
				_tmp56_ = catch_clause;
				_tmp57_ = vala_catch_clause_get_error_type (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ != NULL) {
					ValaCodeContext* _tmp59_;
					ValaProfile _tmp60_;
					ValaProfile _tmp61_;
					_tmp59_ = self->priv->context;
					_tmp60_ = vala_code_context_get_profile (_tmp59_);
					_tmp61_ = _tmp60_;
					if (_tmp61_ == VALA_PROFILE_GOBJECT) {
						ValaErrorType* error_type = NULL;
						ValaCatchClause* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaErrorType* _tmp65_;
						ValaList* _tmp66_;
						ValaBasicBlock* _tmp67_;
						ValaCatchClause* _tmp68_;
						ValaCatchClause* _tmp69_;
						ValaDataType* _tmp70_;
						ValaDataType* _tmp71_;
						ValaTypeSymbol* _tmp72_;
						ValaTypeSymbol* _tmp73_;
						ValaErrorType* _tmp74_;
						ValaErrorCode* _tmp75_;
						ValaErrorCode* _tmp76_;
						ValaFlowAnalyzerJumpTarget* _tmp77_;
						ValaFlowAnalyzerJumpTarget* _tmp78_;
						_tmp62_ = catch_clause;
						_tmp63_ = vala_catch_clause_get_error_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
						error_type = _tmp65_;
						_tmp66_ = self->priv->jump_stack;
						_tmp67_ = error_block;
						_tmp68_ = catch_clause;
						_tmp69_ = catch_clause;
						_tmp70_ = vala_catch_clause_get_error_type (_tmp69_);
						_tmp71_ = _tmp70_;
						_tmp72_ = vala_data_type_get_data_type (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = error_type;
						_tmp75_ = vala_error_type_get_error_code (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = vala_flow_analyzer_jump_target_new_error_target (_tmp67_, _tmp68_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, VALA_TYPE_ERROR_DOMAIN) ? ((ValaErrorDomain*) _tmp73_) : NULL, _tmp76_, NULL);
						_tmp78_ = _tmp77_;
						vala_collection_add ((ValaCollection*) _tmp66_, _tmp78_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp78_);
						_vala_code_node_unref0 (error_type);
					} else {
						ValaClass* error_class = NULL;
						ValaCatchClause* _tmp79_;
						ValaDataType* _tmp80_;
						ValaDataType* _tmp81_;
						ValaTypeSymbol* _tmp82_;
						ValaTypeSymbol* _tmp83_;
						ValaClass* _tmp84_;
						ValaList* _tmp85_;
						ValaBasicBlock* _tmp86_;
						ValaCatchClause* _tmp87_;
						ValaClass* _tmp88_;
						ValaFlowAnalyzerJumpTarget* _tmp89_;
						ValaFlowAnalyzerJumpTarget* _tmp90_;
						_tmp79_ = catch_clause;
						_tmp80_ = vala_catch_clause_get_error_type (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = vala_data_type_get_data_type (_tmp81_);
						_tmp83_ = _tmp82_;
						_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp83_) : NULL);
						error_class = _tmp84_;
						_tmp85_ = self->priv->jump_stack;
						_tmp86_ = error_block;
						_tmp87_ = catch_clause;
						_tmp88_ = error_class;
						_tmp89_ = vala_flow_analyzer_jump_target_new_error_target (_tmp86_, _tmp87_, NULL, NULL, _tmp88_);
						_tmp90_ = _tmp89_;
						vala_collection_add ((ValaCollection*) _tmp85_, _tmp90_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp90_);
						_vala_code_node_unref0 (error_class);
					}
				} else {
					ValaList* _tmp91_;
					ValaBasicBlock* _tmp92_;
					ValaCatchClause* _tmp93_;
					ValaFlowAnalyzerJumpTarget* _tmp94_;
					ValaFlowAnalyzerJumpTarget* _tmp95_;
					_tmp91_ = self->priv->jump_stack;
					_tmp92_ = error_block;
					_tmp93_ = catch_clause;
					_tmp94_ = vala_flow_analyzer_jump_target_new_error_target (_tmp92_, _tmp93_, NULL, NULL, NULL);
					_tmp95_ = _tmp94_;
					vala_collection_add ((ValaCollection*) _tmp91_, _tmp95_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp95_);
				}
				_vala_basic_block_unref0 (error_block);
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp96_ = before_try_block;
	_tmp97_ = _vala_basic_block_ref0 (_tmp96_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp97_;
	_tmp98_ = vala_try_statement_get_body (stmt);
	_tmp99_ = _tmp98_;
	vala_code_node_accept ((ValaCodeNode*) _tmp99_, (ValaCodeVisitor*) self);
	_tmp100_ = self->priv->current_block;
	if (_tmp100_ != NULL) {
		ValaBasicBlock* _tmp101_;
		ValaBasicBlock* _tmp106_;
		ValaBasicBlock* _tmp107_;
		_tmp101_ = finally_block;
		if (_tmp101_ != NULL) {
			ValaBasicBlock* _tmp102_;
			ValaBasicBlock* _tmp103_;
			ValaBasicBlock* _tmp104_;
			ValaBasicBlock* _tmp105_;
			_tmp102_ = self->priv->current_block;
			_tmp103_ = finally_block;
			vala_basic_block_connect (_tmp102_, _tmp103_);
			_tmp104_ = finally_block;
			_tmp105_ = _vala_basic_block_ref0 (_tmp104_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp105_;
		}
		_tmp106_ = self->priv->current_block;
		_tmp107_ = after_try_block;
		vala_basic_block_connect (_tmp106_, _tmp107_);
	}
	_tmp108_ = g_direct_equal;
	_tmp109_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp108_);
	catch_stack = (ValaList*) _tmp109_;
	{
		gint i = 0;
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		_tmp110_ = self->priv->jump_stack;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		i = _tmp112_ - 1;
		{
			gboolean _tmp113_ = FALSE;
			_tmp113_ = TRUE;
			while (TRUE) {
				gint _tmp115_;
				gint _tmp116_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp117_;
				gint _tmp118_;
				gpointer _tmp119_;
				ValaList* _tmp120_;
				ValaFlowAnalyzerJumpTarget* _tmp121_;
				if (!_tmp113_) {
					gint _tmp114_;
					_tmp114_ = i;
					i = _tmp114_ - 1;
				}
				_tmp113_ = FALSE;
				_tmp115_ = i;
				_tmp116_ = finally_jump_stack_size;
				if (!(_tmp115_ >= _tmp116_)) {
					break;
				}
				_tmp117_ = self->priv->jump_stack;
				_tmp118_ = i;
				_tmp119_ = vala_list_remove_at (_tmp117_, _tmp118_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp119_;
				_tmp120_ = catch_stack;
				_tmp121_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp120_, _tmp121_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp122_;
		ValaList* _tmp123_;
		gint _jump_target_size = 0;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gint _jump_target_index = 0;
		_tmp122_ = catch_stack;
		_tmp123_ = _vala_iterable_ref0 (_tmp122_);
		_jump_target_list = _tmp123_;
		_tmp124_ = _jump_target_list;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		_jump_target_size = _tmp126_;
		_jump_target_index = -1;
		while (TRUE) {
			gint _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp130_;
			gint _tmp131_;
			gpointer _tmp132_;
			ValaFlowAnalyzerJumpTarget* _tmp172_;
			ValaBasicBlock* _tmp173_;
			ValaBasicBlock* _tmp174_;
			ValaList* _tmp175_;
			ValaList* _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			gboolean _tmp179_;
			_tmp127_ = _jump_target_index;
			_jump_target_index = _tmp127_ + 1;
			_tmp128_ = _jump_target_index;
			_tmp129_ = _jump_target_size;
			if (!(_tmp128_ < _tmp129_)) {
				break;
			}
			_tmp130_ = _jump_target_list;
			_tmp131_ = _jump_target_index;
			_tmp132_ = vala_list_get (_tmp130_, _tmp131_);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp132_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp133_;
				ValaList* _tmp134_;
				gint _prev_target_size = 0;
				ValaList* _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
				gint _prev_target_index = 0;
				_tmp133_ = catch_stack;
				_tmp134_ = _vala_iterable_ref0 (_tmp133_);
				_prev_target_list = _tmp134_;
				_tmp135_ = _prev_target_list;
				_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
				_tmp137_ = _tmp136_;
				_prev_target_size = _tmp137_;
				_prev_target_index = -1;
				while (TRUE) {
					gint _tmp138_;
					gint _tmp139_;
					gint _tmp140_;
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp141_;
					gint _tmp142_;
					gpointer _tmp143_;
					ValaFlowAnalyzerJumpTarget* _tmp144_;
					ValaFlowAnalyzerJumpTarget* _tmp145_;
					ValaCodeContext* _tmp146_;
					ValaProfile _tmp147_;
					ValaProfile _tmp148_;
					_tmp138_ = _prev_target_index;
					_prev_target_index = _tmp138_ + 1;
					_tmp139_ = _prev_target_index;
					_tmp140_ = _prev_target_size;
					if (!(_tmp139_ < _tmp140_)) {
						break;
					}
					_tmp141_ = _prev_target_list;
					_tmp142_ = _prev_target_index;
					_tmp143_ = vala_list_get (_tmp141_, _tmp142_);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp143_;
					_tmp144_ = prev_target;
					_tmp145_ = jump_target;
					if (_tmp144_ == _tmp145_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp146_ = self->priv->context;
					_tmp147_ = vala_code_context_get_profile (_tmp146_);
					_tmp148_ = _tmp147_;
					if (_tmp148_ == VALA_PROFILE_GOBJECT) {
						gboolean _tmp149_ = FALSE;
						ValaFlowAnalyzerJumpTarget* _tmp150_;
						ValaErrorDomain* _tmp151_;
						ValaErrorDomain* _tmp152_;
						ValaFlowAnalyzerJumpTarget* _tmp153_;
						ValaErrorDomain* _tmp154_;
						ValaErrorDomain* _tmp155_;
						_tmp150_ = prev_target;
						_tmp151_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp150_);
						_tmp152_ = _tmp151_;
						_tmp153_ = jump_target;
						_tmp154_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp152_ == _tmp155_) {
							ValaFlowAnalyzerJumpTarget* _tmp156_;
							ValaErrorCode* _tmp157_;
							ValaErrorCode* _tmp158_;
							ValaFlowAnalyzerJumpTarget* _tmp159_;
							ValaErrorCode* _tmp160_;
							ValaErrorCode* _tmp161_;
							_tmp156_ = prev_target;
							_tmp157_ = vala_flow_analyzer_jump_target_get_error_code (_tmp156_);
							_tmp158_ = _tmp157_;
							_tmp159_ = jump_target;
							_tmp160_ = vala_flow_analyzer_jump_target_get_error_code (_tmp159_);
							_tmp161_ = _tmp160_;
							_tmp149_ = _tmp158_ == _tmp161_;
						} else {
							_tmp149_ = FALSE;
						}
						if (_tmp149_) {
							ValaSourceReference* _tmp162_;
							ValaSourceReference* _tmp163_;
							_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp163_ = _tmp162_;
							vala_report_error (_tmp163_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_iterable_unref0 (_prev_target_list);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (_jump_target_list);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					} else {
						ValaFlowAnalyzerJumpTarget* _tmp164_;
						ValaClass* _tmp165_;
						ValaClass* _tmp166_;
						ValaFlowAnalyzerJumpTarget* _tmp167_;
						ValaClass* _tmp168_;
						ValaClass* _tmp169_;
						_tmp164_ = prev_target;
						_tmp165_ = vala_flow_analyzer_jump_target_get_error_class (_tmp164_);
						_tmp166_ = _tmp165_;
						_tmp167_ = jump_target;
						_tmp168_ = vala_flow_analyzer_jump_target_get_error_class (_tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp166_ == _tmp169_) {
							ValaSourceReference* _tmp170_;
							ValaSourceReference* _tmp171_;
							_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp171_ = _tmp170_;
							vala_report_error (_tmp171_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_iterable_unref0 (_prev_target_list);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (_jump_target_list);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
				_vala_iterable_unref0 (_prev_target_list);
			}
			_tmp172_ = jump_target;
			_tmp173_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp172_);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_basic_block_get_predecessors (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_collection_get_size ((ValaCollection*) _tmp176_);
			_tmp178_ = _tmp177_;
			_tmp179_ = _tmp178_ == 0;
			_vala_iterable_unref0 (_tmp176_);
			if (_tmp179_) {
				ValaFlowAnalyzerJumpTarget* _tmp180_;
				ValaCatchClause* _tmp181_;
				ValaCatchClause* _tmp182_;
				ValaSourceReference* _tmp183_;
				ValaSourceReference* _tmp184_;
				_tmp180_ = jump_target;
				_tmp181_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
				_tmp184_ = _tmp183_;
				vala_report_warning (_tmp184_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp185_;
				ValaBasicBlock* _tmp186_;
				ValaBasicBlock* _tmp187_;
				ValaBasicBlock* _tmp188_;
				ValaBasicBlock* _tmp189_;
				ValaFlowAnalyzerJumpTarget* _tmp190_;
				ValaCatchClause* _tmp191_;
				ValaCatchClause* _tmp192_;
				ValaFlowAnalyzerJumpTarget* _tmp193_;
				ValaCatchClause* _tmp194_;
				ValaCatchClause* _tmp195_;
				ValaBlock* _tmp196_;
				ValaBlock* _tmp197_;
				ValaBasicBlock* _tmp198_;
				_tmp185_ = jump_target;
				_tmp186_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = _vala_basic_block_ref0 (_tmp187_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp188_;
				_tmp189_ = self->priv->current_block;
				_tmp190_ = jump_target;
				_tmp191_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp190_);
				_tmp192_ = _tmp191_;
				vala_basic_block_add_node (_tmp189_, (ValaCodeNode*) _tmp192_);
				_tmp193_ = jump_target;
				_tmp194_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_catch_clause_get_body (_tmp195_);
				_tmp197_ = _tmp196_;
				vala_code_node_accept ((ValaCodeNode*) _tmp197_, (ValaCodeVisitor*) self);
				_tmp198_ = self->priv->current_block;
				if (_tmp198_ != NULL) {
					ValaBasicBlock* _tmp199_;
					ValaBasicBlock* _tmp204_;
					ValaBasicBlock* _tmp205_;
					_tmp199_ = finally_block;
					if (_tmp199_ != NULL) {
						ValaBasicBlock* _tmp200_;
						ValaBasicBlock* _tmp201_;
						ValaBasicBlock* _tmp202_;
						ValaBasicBlock* _tmp203_;
						_tmp200_ = self->priv->current_block;
						_tmp201_ = finally_block;
						vala_basic_block_connect (_tmp200_, _tmp201_);
						_tmp202_ = finally_block;
						_tmp203_ = _vala_basic_block_ref0 (_tmp202_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp203_;
					}
					_tmp204_ = self->priv->current_block;
					_tmp205_ = after_try_block;
					vala_basic_block_connect (_tmp204_, _tmp205_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
		_vala_iterable_unref0 (_jump_target_list);
	}
	_tmp206_ = finally_block;
	if (_tmp206_ != NULL) {
		ValaList* _tmp207_;
		ValaList* _tmp208_;
		gint _tmp209_;
		gint _tmp210_;
		gpointer _tmp211_;
		ValaFlowAnalyzerJumpTarget* _tmp212_;
		_tmp207_ = self->priv->jump_stack;
		_tmp208_ = self->priv->jump_stack;
		_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
		_tmp210_ = _tmp209_;
		_tmp211_ = vala_list_remove_at (_tmp207_, _tmp210_ - 1);
		_tmp212_ = (ValaFlowAnalyzerJumpTarget*) _tmp211_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp212_);
	}
	_tmp213_ = after_try_block;
	_tmp214_ = vala_basic_block_get_predecessors (_tmp213_);
	_tmp215_ = _tmp214_;
	_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
	_tmp217_ = _tmp216_;
	_tmp218_ = _tmp217_ > 0;
	_vala_iterable_unref0 (_tmp215_);
	if (_tmp218_) {
		ValaBasicBlock* _tmp219_;
		ValaBasicBlock* _tmp220_;
		_tmp219_ = after_try_block;
		_tmp220_ = _vala_basic_block_ref0 (_tmp219_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp220_;
	} else {
		vala_try_statement_set_after_try_block_reachable (stmt, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}


static void
vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                              ValaLockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                ValaUnlockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                          ValaExpression* expr)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_LAMBDA_EXPRESSION)) {
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
	}
}


static gboolean
vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		vala_code_node_set_unreachable (node, TRUE);
		_tmp1_ = self->priv->unreachable_reported;
		if (!_tmp1_) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference (node);
			_tmp3_ = _tmp2_;
			vala_report_warning (_tmp3_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void
vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self)
{
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}


static inline gpointer
vala_flow_analyzer_jump_target_get_instance_private (ValaFlowAnalyzerJumpTarget* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzerJumpTarget_private_offset);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                       ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                          ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                        ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                      ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                       ValaBasicBlock* basic_block,
                                                       ValaCatchClause* catch_clause,
                                                       ValaErrorDomain* error_domain,
                                                       ValaErrorCode* error_code,
                                                       ValaClass* error_class)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_catch_clause (self, catch_clause);
	vala_flow_analyzer_jump_target_set_error_domain (self, error_domain);
	vala_flow_analyzer_jump_target_set_error_code (self, error_code);
	vala_flow_analyzer_jump_target_set_error_class (self, error_class);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                 ValaCatchClause* catch_clause,
                                                 ValaErrorDomain* error_domain,
                                                 ValaErrorCode* error_code,
                                                 ValaClass* error_class)
{
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                     ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                         ValaBasicBlock* basic_block,
                                                         ValaBasicBlock* last_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_last_block (self, last_block);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                   ValaBasicBlock* last_block)
{
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct (GType object_type)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new (void)
{
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}


static gboolean
vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_break_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_break_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_continue_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_continue_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_return_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_return_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_exit_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_exit_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_error_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_error_target = value;
}


static ValaErrorDomain*
vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaErrorDomain* value)
{
	ValaErrorDomain* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp0_;
}


static ValaErrorCode*
vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                               ValaErrorCode* value)
{
	ValaErrorCode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp0_;
}


static ValaClass*
vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp0_;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_finally_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_finally_clause = value;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp0_;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                               ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp0_;
}


static ValaCatchClause*
vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self)
{
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaCatchClause* value)
{
	ValaCatchClause* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp0_;
}


static void
vala_flow_analyzer_value_jump_target_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_flow_analyzer_value_jump_target_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}


static void
vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_flow_analyzer_value_jump_target_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_flow_analyzer_value_get_jump_target (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}


static void
vala_flow_analyzer_value_set_jump_target (GValue* value,
                                          gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_value_take_jump_target (GValue* value,
                                           gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass)
{
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzerJumpTarget_private_offset);
}


static void
vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self)
{
	self->priv = vala_flow_analyzer_jump_target_get_instance_private (self);
	self->ref_count = 1;
}


static void
vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}


static GType
vala_flow_analyzer_jump_target_get_type (void)
{
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaFlowAnalyzerJumpTarget_private_offset = g_type_add_instance_private (vala_flow_analyzer_jump_target_type_id, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}


static gpointer
vala_flow_analyzer_jump_target_ref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_flow_analyzer_jump_target_unref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass)
{
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzer_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor *, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor *, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor *, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor *, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor *, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor *, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor *, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor *, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor *, ValaLoop*)) vala_flow_analyzer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor *, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor *, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor *, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor *, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor *, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor *, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor *, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor *, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor *, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor *, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}


static void
vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_flow_analyzer_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}


static void
vala_flow_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}


/**
 * Code visitor building the control flow graph.
 */
GType
vala_flow_analyzer_get_type (void)
{
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
		ValaFlowAnalyzer_private_offset = g_type_add_instance_private (vala_flow_analyzer_type_id, sizeof (ValaFlowAnalyzerPrivate));
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



