/* markupwriter.c generated by valac, the Vala compiler
 * generated from markupwriter.vala, do not modify */

/* markupwriter.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValadocParamSpecMarkupWriter ValadocParamSpecMarkupWriter;

struct _ValadocMarkupWriterPrivate {
	gboolean wrap;
};

struct _ValadocParamSpecMarkupWriter {
	GParamSpec parent_instance;
};


static gint ValadocMarkupWriter_private_offset;
static gpointer valadoc_markup_writer_parent_class = NULL;

#define VALADOC_MARKUP_WRITER_MAX_COLUMN 150
static void valadoc_markup_writer_check_column (ValadocMarkupWriter* self,
                                         const gchar* name,
                                         gboolean end_tag);
static void valadoc_markup_writer_break_line (ValadocMarkupWriter* self);
static gboolean valadoc_markup_writer_real_inline_element (ValadocMarkupWriter* self,
                                                    const gchar* name);
static gboolean valadoc_markup_writer_real_content_inline_element (ValadocMarkupWriter* self,
                                                            const gchar* name);
static void valadoc_markup_writer_finalize (ValadocMarkupWriter * obj);


static inline gpointer
valadoc_markup_writer_get_instance_private (ValadocMarkupWriter* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocMarkupWriter_private_offset);
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


gchar*
valadoc_markup_writer_escape (const gchar* txt)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* start = NULL;
	const gchar* pos = NULL;
	gunichar c = 0U;
	g_return_val_if_fail (txt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	start = txt;
	{
		gboolean _tmp1_ = FALSE;
		pos = txt;
		_tmp1_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			gunichar _tmp5_;
			gunichar _tmp6_;
			if (!_tmp1_) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = pos;
				_tmp3_ = g_utf8_next_char (_tmp2_);
				pos = _tmp3_;
			}
			_tmp1_ = FALSE;
			_tmp4_ = pos;
			c = string_get_char (_tmp4_, (glong) 0);
			_tmp5_ = c;
			if (!(_tmp5_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp6_ = c;
			switch (_tmp6_) {
				case '"':
				{
					GString* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					GString* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp7_ = builder;
					_tmp8_ = start;
					_tmp9_ = pos;
					_tmp10_ = start;
					g_string_append_len (_tmp7_, _tmp8_, (gssize) (((gchar*) _tmp9_) - ((gchar*) _tmp10_)));
					_tmp11_ = builder;
					g_string_append (_tmp11_, "&quot;");
					_tmp12_ = pos;
					_tmp13_ = g_utf8_next_char (_tmp12_);
					start = _tmp13_;
					break;
				}
				case '<':
				{
					GString* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					GString* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					_tmp14_ = builder;
					_tmp15_ = start;
					_tmp16_ = pos;
					_tmp17_ = start;
					g_string_append_len (_tmp14_, _tmp15_, (gssize) (((gchar*) _tmp16_) - ((gchar*) _tmp17_)));
					_tmp18_ = builder;
					g_string_append (_tmp18_, "&lt;");
					_tmp19_ = pos;
					_tmp20_ = g_utf8_next_char (_tmp19_);
					start = _tmp20_;
					break;
				}
				case '>':
				{
					GString* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					GString* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					_tmp21_ = builder;
					_tmp22_ = start;
					_tmp23_ = pos;
					_tmp24_ = start;
					g_string_append_len (_tmp21_, _tmp22_, (gssize) (((gchar*) _tmp23_) - ((gchar*) _tmp24_)));
					_tmp25_ = builder;
					g_string_append (_tmp25_, "&gt;");
					_tmp26_ = pos;
					_tmp27_ = g_utf8_next_char (_tmp26_);
					start = _tmp27_;
					break;
				}
				case '&':
				{
					GString* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GString* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					_tmp28_ = builder;
					_tmp29_ = start;
					_tmp30_ = pos;
					_tmp31_ = start;
					g_string_append_len (_tmp28_, _tmp29_, (gssize) (((gchar*) _tmp30_) - ((gchar*) _tmp31_)));
					_tmp32_ = builder;
					g_string_append (_tmp32_, "&amp;");
					_tmp33_ = pos;
					_tmp34_ = g_utf8_next_char (_tmp33_);
					start = _tmp34_;
					break;
				}
				case '\'':
				{
					GString* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					GString* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					_tmp35_ = builder;
					_tmp36_ = start;
					_tmp37_ = pos;
					_tmp38_ = start;
					g_string_append_len (_tmp35_, _tmp36_, (gssize) (((gchar*) _tmp37_) - ((gchar*) _tmp38_)));
					_tmp39_ = builder;
					g_string_append (_tmp39_, "&apos;");
					_tmp40_ = pos;
					_tmp41_ = g_utf8_next_char (_tmp40_);
					start = _tmp41_;
					break;
				}
				default:
				break;
			}
		}
	}
	if ((&txt) == (&start)) {
		gchar* _tmp42_;
		_tmp42_ = g_strdup (txt);
		result = _tmp42_;
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		GString* _tmp47_;
		gchar* _tmp48_;
		_tmp43_ = builder;
		_tmp44_ = start;
		_tmp45_ = pos;
		_tmp46_ = start;
		g_string_append_len (_tmp43_, _tmp44_, (gssize) (((gchar*) _tmp45_) - ((gchar*) _tmp46_)));
		_tmp47_ = builder;
		_tmp48_ = _tmp47_->str;
		_tmp47_->str = NULL;
		result = _tmp48_;
		_g_string_free0 (builder);
		return result;
	}
	_g_string_free0 (builder);
}


/**
 * Initializes a new instance of the MarkupWriter
 *
 * @param write stream a WriteFunc
 * @param xml_declaration specifies whether this file starts with an xml-declaration
 */
ValadocMarkupWriter*
valadoc_markup_writer_construct (GType object_type,
                                 ValadocMarkupWriterWriteFunc write,
                                 gpointer write_target,
                                 GDestroyNotify write_target_destroy_notify,
                                 gboolean xml_declaration)
{
	ValadocMarkupWriter* self = NULL;
	ValadocMarkupWriterWriteFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = (ValadocMarkupWriter*) g_type_create_instance (object_type);
	_tmp0_ = write;
	_tmp0__target = write_target;
	_tmp0__target_destroy_notify = write_target_destroy_notify;
	write = NULL;
	write_target = NULL;
	write_target_destroy_notify = NULL;
	(self->write_target_destroy_notify == NULL) ? NULL : (self->write_target_destroy_notify (self->write_target), NULL);
	self->write = NULL;
	self->write_target = NULL;
	self->write_target_destroy_notify = NULL;
	self->write = _tmp0_;
	self->write_target = _tmp0__target;
	self->write_target_destroy_notify = _tmp0__target_destroy_notify;
	if (xml_declaration) {
		valadoc_markup_writer_do_write (self, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
	}
	self->indent = -1;
	self->last_was_tag = TRUE;
	(write_target_destroy_notify == NULL) ? NULL : (write_target_destroy_notify (write_target), NULL);
	write = NULL;
	write_target = NULL;
	write_target_destroy_notify = NULL;
	return self;
}


ValadocMarkupWriter*
valadoc_markup_writer_new (ValadocMarkupWriterWriteFunc write,
                           gpointer write_target,
                           GDestroyNotify write_target_destroy_notify,
                           gboolean xml_declaration)
{
	return valadoc_markup_writer_construct (VALADOC_TYPE_MARKUP_WRITER, write, write_target, write_target_destroy_notify, xml_declaration);
}


/**
 * Writes an start tag of a markup element to the file
 *
 * @param name the name of the markup
 * @param attributes a list of name/value pairs
 * @return this
 */
ValadocMarkupWriter*
valadoc_markup_writer_start_tag (ValadocMarkupWriter* self,
                                 const gchar* name,
                                 gchar** attributes,
                                 int attributes_length1)
{
	ValadocMarkupWriter* result = NULL;
	gint _tmp0_;
	GString* content = NULL;
	GString* _tmp4_;
	GString* _tmp5_;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->indent;
	self->indent = _tmp0_ + 1;
	valadoc_markup_writer_check_column (self, name, FALSE);
	if ((attributes_length1 % 2) != 0) {
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = attributes_length1 + 1;
		attributes = g_renew (gchar*, attributes, attributes_length1 + 1);
		(_tmp1_ > attributes_length1) ? memset (attributes + attributes_length1, 0, sizeof (gchar*) * (_tmp1_ - attributes_length1)) : NULL;
		attributes_length1 = _tmp1_;
		_tmp2_ = g_strdup ("");
		_g_free0 (attributes[attributes_length1 - 1]);
		attributes[attributes_length1 - 1] = _tmp2_;
		_tmp3_ = attributes[attributes_length1 - 1];
	}
	_tmp4_ = g_string_new ("<");
	content = _tmp4_;
	_tmp5_ = content;
	g_string_append (_tmp5_, name);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 2;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				if (!(_tmp8_ < attributes_length1)) {
					break;
				}
				_tmp9_ = i;
				_tmp10_ = attributes[_tmp9_ + 1];
				if (_tmp10_ != NULL) {
					GString* _tmp11_;
					gint _tmp12_;
					const gchar* _tmp13_;
					gint _tmp14_;
					const gchar* _tmp15_;
					_tmp11_ = content;
					_tmp12_ = i;
					_tmp13_ = attributes[_tmp12_];
					_tmp14_ = i;
					_tmp15_ = attributes[_tmp14_ + 1];
					g_string_append_printf (_tmp11_, " %s=\"%s\"", _tmp13_, _tmp15_);
				}
			}
		}
	}
	_tmp16_ = content;
	g_string_append (_tmp16_, ">");
	_tmp17_ = content;
	_tmp18_ = _tmp17_->str;
	valadoc_markup_writer_do_write (self, _tmp18_);
	self->last_was_tag = TRUE;
	result = self;
	_g_string_free0 (content);
	return result;
}


/**
 * Writes a simple tag (<name />) to the file
 *
 * @param name the name of the markup
 * @param attributes a list of name/value pairs
 * @return this
 */
ValadocMarkupWriter*
valadoc_markup_writer_simple_tag (ValadocMarkupWriter* self,
                                  const gchar* name,
                                  gchar** attributes,
                                  int attributes_length1)
{
	ValadocMarkupWriter* result = NULL;
	gint _tmp0_;
	GString* content = NULL;
	GString* _tmp4_;
	GString* _tmp5_;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->indent;
	self->indent = _tmp0_ + 1;
	valadoc_markup_writer_check_column (self, name, FALSE);
	if ((attributes_length1 % 2) != 0) {
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = attributes_length1 + 1;
		attributes = g_renew (gchar*, attributes, attributes_length1 + 1);
		(_tmp1_ > attributes_length1) ? memset (attributes + attributes_length1, 0, sizeof (gchar*) * (_tmp1_ - attributes_length1)) : NULL;
		attributes_length1 = _tmp1_;
		_tmp2_ = g_strdup ("");
		_g_free0 (attributes[attributes_length1 - 1]);
		attributes[attributes_length1 - 1] = _tmp2_;
		_tmp3_ = attributes[attributes_length1 - 1];
	}
	_tmp4_ = g_string_new ("<");
	content = _tmp4_;
	_tmp5_ = content;
	g_string_append (_tmp5_, name);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 2;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				if (!(_tmp8_ < attributes_length1)) {
					break;
				}
				_tmp9_ = i;
				_tmp10_ = attributes[_tmp9_ + 1];
				if (_tmp10_ != NULL) {
					GString* _tmp11_;
					gint _tmp12_;
					const gchar* _tmp13_;
					gint _tmp14_;
					const gchar* _tmp15_;
					_tmp11_ = content;
					_tmp12_ = i;
					_tmp13_ = attributes[_tmp12_];
					_tmp14_ = i;
					_tmp15_ = attributes[_tmp14_ + 1];
					g_string_append_printf (_tmp11_, " %s=\"%s\"", _tmp13_, _tmp15_);
				}
			}
		}
	}
	_tmp16_ = content;
	g_string_append (_tmp16_, "/>");
	_tmp17_ = content;
	_tmp18_ = _tmp17_->str;
	valadoc_markup_writer_do_write (self, _tmp18_);
	_tmp19_ = self->indent;
	self->indent = _tmp19_ - 1;
	self->last_was_tag = TRUE;
	result = self;
	_g_string_free0 (content);
	return result;
}


/**
 * Writes an end tag of a markup element to the file
 *
 * @param name the name of the markup
 * @return this
 */
ValadocMarkupWriter*
valadoc_markup_writer_end_tag (ValadocMarkupWriter* self,
                               const gchar* name)
{
	ValadocMarkupWriter* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	valadoc_markup_writer_check_column (self, name, TRUE);
	_tmp0_ = g_strdup_printf ("</%s>", name);
	_tmp1_ = _tmp0_;
	valadoc_markup_writer_do_write (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->indent;
	self->indent = _tmp2_ - 1;
	self->last_was_tag = TRUE;
	result = self;
	return result;
}


/**
 * Writes the specified string to the output stream
 *
 * @see raw_text
 * @return this
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


ValadocMarkupWriter*
valadoc_markup_writer_text (ValadocMarkupWriter* self,
                            const gchar* text)
{
	ValadocMarkupWriter* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp1_ = self->priv->wrap;
	if (_tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		glong _tmp4_;
		_tmp2_ = strlen (text);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->current_column;
		_tmp0_ = (_tmp3_ + _tmp4_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong wrote = 0L;
		wrote = (glong) 0;
		while (TRUE) {
			glong _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			glong space_pos = 0L;
			gint _tmp19_;
			gint _tmp20_;
			glong _tmp21_;
			glong _tmp22_;
			glong _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp5_ = wrote;
			_tmp6_ = strlen (text);
			_tmp7_ = _tmp6_;
			if (!(_tmp5_ < ((glong) _tmp7_))) {
				break;
			}
			space_pos = (glong) -1;
			{
				glong i = 0L;
				glong _tmp8_;
				_tmp8_ = wrote;
				i = _tmp8_ + 1;
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						glong _tmp11_;
						gint _tmp12_;
						gint _tmp13_;
						glong _tmp14_;
						if (!_tmp9_) {
							glong _tmp10_;
							_tmp10_ = i;
							i = _tmp10_ + 1;
						}
						_tmp9_ = FALSE;
						_tmp11_ = i;
						_tmp12_ = strlen (text);
						_tmp13_ = _tmp12_;
						if (!(_tmp11_ < ((glong) _tmp13_))) {
							break;
						}
						_tmp14_ = i;
						if (string_get (text, _tmp14_) == ' ') {
							glong _tmp15_;
							glong _tmp16_;
							glong _tmp17_;
							glong _tmp18_;
							_tmp15_ = i;
							_tmp16_ = wrote;
							_tmp17_ = self->current_column;
							if (((_tmp15_ - _tmp16_) + _tmp17_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN)) {
								break;
							}
							_tmp18_ = i;
							space_pos = _tmp18_;
						}
					}
				}
			}
			_tmp19_ = strlen (text);
			_tmp20_ = _tmp19_;
			_tmp21_ = wrote;
			_tmp22_ = self->current_column;
			if (((_tmp20_ - _tmp21_) + _tmp22_) <= ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN)) {
				glong _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp23_ = wrote;
				_tmp24_ = string_substring (text, _tmp23_, (glong) -1);
				_tmp25_ = _tmp24_;
				valadoc_markup_writer_do_write (self, _tmp25_);
				_g_free0 (_tmp25_);
				_tmp26_ = strlen (text);
				_tmp27_ = _tmp26_;
				wrote = (glong) (_tmp27_ + 1);
			} else {
				glong _tmp28_;
				_tmp28_ = space_pos;
				if (_tmp28_ == ((glong) -1)) {
				} else {
					glong _tmp29_;
					glong _tmp30_;
					glong _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					glong _tmp34_;
					_tmp29_ = wrote;
					_tmp30_ = space_pos;
					_tmp31_ = wrote;
					_tmp32_ = string_substring (text, _tmp29_, _tmp30_ - _tmp31_);
					_tmp33_ = _tmp32_;
					valadoc_markup_writer_do_write (self, _tmp33_);
					_g_free0 (_tmp33_);
					_tmp34_ = space_pos;
					wrote = _tmp34_ + 1;
				}
			}
			_tmp35_ = wrote;
			_tmp36_ = strlen (text);
			_tmp37_ = _tmp36_;
			if (_tmp35_ < ((glong) _tmp37_)) {
				valadoc_markup_writer_break_line (self);
				valadoc_markup_writer_do_write (self, "  ");
			}
		}
	} else {
		valadoc_markup_writer_do_write (self, text);
	}
	self->last_was_tag = FALSE;
	result = self;
	return result;
}


/**
 * Writes the specified string to the output stream
 *
 * @see text
 * @return this
 */
ValadocMarkupWriter*
valadoc_markup_writer_raw_text (ValadocMarkupWriter* self,
                                const gchar* text)
{
	ValadocMarkupWriter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	valadoc_markup_writer_do_write (self, text);
	self->last_was_tag = FALSE;
	result = self;
	return result;
}


void
valadoc_markup_writer_set_wrap (ValadocMarkupWriter* self,
                                gboolean wrap)
{
	g_return_if_fail (self != NULL);
	self->priv->wrap = wrap;
}


static void
valadoc_markup_writer_break_line (ValadocMarkupWriter* self)
{
	ValadocMarkupWriterWriteFunc _tmp0_;
	void* _tmp0__target;
	ValadocMarkupWriterWriteFunc _tmp1_;
	void* _tmp1__target;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->write;
	_tmp0__target = self->write_target;
	_tmp0_ ("\n", _tmp0__target);
	_tmp1_ = self->write;
	_tmp1__target = self->write_target;
	_tmp2_ = self->indent;
	_tmp3_ = g_strnfill ((gsize) (_tmp2_ * 2), ' ');
	_tmp4_ = _tmp3_;
	_tmp1_ (_tmp4_, _tmp1__target);
	_g_free0 (_tmp4_);
	_tmp5_ = self->indent;
	self->current_column = (glong) (_tmp5_ * 2);
}


void
valadoc_markup_writer_do_write (ValadocMarkupWriter* self,
                                const gchar* text)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocMarkupWriterWriteFunc _tmp5_;
	void* _tmp5__target;
	glong _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->wrap;
	if (_tmp1_) {
		glong _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->current_column;
		_tmp3_ = strlen (text);
		_tmp4_ = _tmp3_;
		_tmp0_ = (_tmp2_ + _tmp4_) > ((glong) VALADOC_MARKUP_WRITER_MAX_COLUMN);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		valadoc_markup_writer_break_line (self);
	}
	_tmp5_ = self->write;
	_tmp5__target = self->write_target;
	_tmp5_ (text, _tmp5__target);
	_tmp6_ = self->current_column;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	self->current_column = _tmp6_ + _tmp8_;
}


static void
valadoc_markup_writer_check_column (ValadocMarkupWriter* self,
                                    const gchar* name,
                                    gboolean end_tag)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->wrap;
	if (!_tmp0_) {
		return;
	} else {
		gboolean _tmp1_ = FALSE;
		if (!end_tag) {
			_tmp1_ = valadoc_markup_writer_inline_element (self, name);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			return;
		} else {
			gboolean _tmp2_ = FALSE;
			if (end_tag) {
				_tmp2_ = valadoc_markup_writer_content_inline_element (self, name);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				return;
			} else {
				gboolean _tmp3_ = FALSE;
				if (end_tag) {
					gboolean _tmp4_;
					_tmp4_ = self->last_was_tag;
					_tmp3_ = !_tmp4_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					return;
				}
			}
		}
	}
	valadoc_markup_writer_break_line (self);
}


static gboolean
valadoc_markup_writer_real_inline_element (ValadocMarkupWriter* self,
                                           const gchar* name)
{
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean
valadoc_markup_writer_inline_element (ValadocMarkupWriter* self,
                                      const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_MARKUP_WRITER_GET_CLASS (self)->inline_element (self, name);
}


static gboolean
valadoc_markup_writer_real_content_inline_element (ValadocMarkupWriter* self,
                                                   const gchar* name)
{
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean
valadoc_markup_writer_content_inline_element (ValadocMarkupWriter* self,
                                              const gchar* name)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_MARKUP_WRITER_GET_CLASS (self)->content_inline_element (self, name);
}


static void
valadoc_value_markup_writer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
valadoc_value_markup_writer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_markup_writer_unref (value->data[0].v_pointer);
	}
}


static void
valadoc_value_markup_writer_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_markup_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
valadoc_value_markup_writer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
valadoc_value_markup_writer_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocMarkupWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_markup_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
valadoc_value_markup_writer_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	ValadocMarkupWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_markup_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
valadoc_param_spec_markup_writer (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ValadocParamSpecMarkupWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_TYPE_MARKUP_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
valadoc_value_get_markup_writer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER), NULL);
	return value->data[0].v_pointer;
}


void
valadoc_value_set_markup_writer (GValue* value,
                                 gpointer v_object)
{
	ValadocMarkupWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_MARKUP_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_markup_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_markup_writer_unref (old);
	}
}


void
valadoc_value_take_markup_writer (GValue* value,
                                  gpointer v_object)
{
	ValadocMarkupWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_MARKUP_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_MARKUP_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_markup_writer_unref (old);
	}
}


static void
valadoc_markup_writer_class_init (ValadocMarkupWriterClass * klass)
{
	valadoc_markup_writer_parent_class = g_type_class_peek_parent (klass);
	((ValadocMarkupWriterClass *) klass)->finalize = valadoc_markup_writer_finalize;
	g_type_class_adjust_private_offset (klass, &ValadocMarkupWriter_private_offset);
	((ValadocMarkupWriterClass *) klass)->inline_element = (gboolean (*) (ValadocMarkupWriter *, const gchar*)) valadoc_markup_writer_real_inline_element;
	((ValadocMarkupWriterClass *) klass)->content_inline_element = (gboolean (*) (ValadocMarkupWriter *, const gchar*)) valadoc_markup_writer_real_content_inline_element;
}


static void
valadoc_markup_writer_instance_init (ValadocMarkupWriter * self)
{
	self->priv = valadoc_markup_writer_get_instance_private (self);
	self->current_column = (glong) 0;
	self->priv->wrap = TRUE;
	self->ref_count = 1;
}


static void
valadoc_markup_writer_finalize (ValadocMarkupWriter * obj)
{
	ValadocMarkupWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_MARKUP_WRITER, ValadocMarkupWriter);
	g_signal_handlers_destroy (self);
	(self->write_target_destroy_notify == NULL) ? NULL : (self->write_target_destroy_notify (self->write_target), NULL);
	self->write = NULL;
	self->write_target = NULL;
	self->write_target_destroy_notify = NULL;
}


/**
 * Writes markups and text to a file.
 */
GType
valadoc_markup_writer_get_type (void)
{
	static volatile gsize valadoc_markup_writer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_markup_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_value_markup_writer_init, valadoc_value_markup_writer_free_value, valadoc_value_markup_writer_copy_value, valadoc_value_markup_writer_peek_pointer, "p", valadoc_value_markup_writer_collect_value, "p", valadoc_value_markup_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocMarkupWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_markup_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocMarkupWriter), 0, (GInstanceInitFunc) valadoc_markup_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_markup_writer_type_id;
		valadoc_markup_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocMarkupWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValadocMarkupWriter_private_offset = g_type_add_instance_private (valadoc_markup_writer_type_id, sizeof (ValadocMarkupWriterPrivate));
		g_once_init_leave (&valadoc_markup_writer_type_id__volatile, valadoc_markup_writer_type_id);
	}
	return valadoc_markup_writer_type_id__volatile;
}


gpointer
valadoc_markup_writer_ref (gpointer instance)
{
	ValadocMarkupWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
valadoc_markup_writer_unref (gpointer instance)
{
	ValadocMarkupWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_MARKUP_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



