/* valaswitchlabel.c generated by valac, the Vala compiler
 * generated from valaswitchlabel.vala, do not modify */

/* valaswitchlabel.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaSwitchLabelPrivate {
	ValaExpression* _expression;
	ValaSwitchSection* _section;
};


static gint ValaSwitchLabel_private_offset;
static gpointer vala_switch_label_parent_class = NULL;

static void vala_switch_label_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor);
static void vala_switch_label_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor);
static gboolean vala_switch_label_real_check (ValaCodeNode* base,
                                       ValaCodeContext* context);
static void vala_switch_label_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen);
static void vala_switch_label_finalize (ValaCodeNode * obj);


static inline gpointer
vala_switch_label_get_instance_private (ValaSwitchLabel* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSwitchLabel_private_offset);
}


/**
 * Creates a new switch case label.
 *
 * @param expr   label expression
 * @param source reference to source code
 * @return       newly created switch case label
 */
ValaSwitchLabel*
vala_switch_label_construct (GType object_type,
                             ValaExpression* expr,
                             ValaSourceReference* source)
{
	ValaSwitchLabel* self = NULL;
	g_return_val_if_fail (expr != NULL, NULL);
	self = (ValaSwitchLabel*) vala_code_node_construct (object_type);
	vala_switch_label_set_expression (self, expr);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaSwitchLabel*
vala_switch_label_new (ValaExpression* expr,
                       ValaSourceReference* source)
{
	return vala_switch_label_construct (VALA_TYPE_SWITCH_LABEL, expr, source);
}


/**
 * Creates a new switch default label.
 *
 * @param source reference to source code
 * @return       newly created switch default label
 */
ValaSwitchLabel*
vala_switch_label_construct_with_default (GType object_type,
                                          ValaSourceReference* source)
{
	ValaSwitchLabel* self = NULL;
	self = (ValaSwitchLabel*) vala_code_node_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaSwitchLabel*
vala_switch_label_new_with_default (ValaSourceReference* source)
{
	return vala_switch_label_construct_with_default (VALA_TYPE_SWITCH_LABEL, source);
}


static void
vala_switch_label_real_accept (ValaCodeNode* base,
                               ValaCodeVisitor* visitor)
{
	ValaSwitchLabel * self;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_label (visitor, self);
}


static void
vala_switch_label_real_accept_children (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor)
{
	ValaSwitchLabel * self;
	ValaExpression* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_expression;
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = self->priv->_expression;
		vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
		_tmp2_ = self->priv->_expression;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp2_);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_switch_label_real_check (ValaCodeNode* base,
                              ValaCodeContext* context)
{
	ValaSwitchLabel * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->_expression;
	if (_tmp0_ != NULL) {
		ValaSwitchStatement* switch_statement = NULL;
		ValaSwitchSection* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaSwitchStatement* _tmp4_;
		ValaDataType* condition_target_type = NULL;
		ValaSwitchStatement* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		ValaExpression* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaExpression* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaSwitchStatement* _tmp56_;
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		_tmp1_ = self->priv->_section;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement));
		switch_statement = _tmp4_;
		_tmp5_ = switch_statement;
		_tmp6_ = vala_switch_statement_get_expression (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_target_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (_tmp9_);
		condition_target_type = _tmp10_;
		_tmp13_ = self->priv->_expression;
		_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			ValaDataType* _tmp16_;
			_tmp16_ = condition_target_type;
			_tmp12_ = _tmp16_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaDataType* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			ValaTypeSymbol* _tmp19_;
			_tmp17_ = condition_target_type;
			_tmp18_ = vala_data_type_get_data_type (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_ENUM);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaEnum* enum_type = NULL;
			ValaDataType* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaTypeSymbol* _tmp22_;
			ValaEnum* _tmp23_;
			_tmp20_ = condition_target_type;
			_tmp21_ = vala_data_type_get_data_type (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_ENUM, ValaEnum));
			enum_type = _tmp23_;
			{
				ValaList* _val_list = NULL;
				ValaEnum* _tmp24_;
				ValaList* _tmp25_;
				gint _val_size = 0;
				ValaList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _val_index = 0;
				_tmp24_ = enum_type;
				_tmp25_ = vala_enum_get_values (_tmp24_);
				_val_list = _tmp25_;
				_tmp26_ = _val_list;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_val_size = _tmp28_;
				_val_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					ValaEnumValue* val = NULL;
					ValaList* _tmp32_;
					gint _tmp33_;
					gpointer _tmp34_;
					ValaExpression* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					ValaEnumValue* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					gboolean _tmp41_;
					_tmp29_ = _val_index;
					_val_index = _tmp29_ + 1;
					_tmp30_ = _val_index;
					_tmp31_ = _val_size;
					if (!(_tmp30_ < _tmp31_)) {
						break;
					}
					_tmp32_ = _val_list;
					_tmp33_ = _val_index;
					_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
					val = (ValaEnumValue*) _tmp34_;
					_tmp35_ = self->priv->_expression;
					_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = val;
					_tmp39_ = vala_symbol_get_name ((ValaSymbol*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strcmp0 (_tmp37_, _tmp40_) == 0;
					_g_free0 (_tmp37_);
					if (_tmp41_) {
						ValaExpression* _tmp42_;
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						ValaDataType* _tmp45_;
						ValaExpression* _tmp46_;
						ValaEnumValue* _tmp47_;
						_tmp42_ = self->priv->_expression;
						_tmp43_ = condition_target_type;
						_tmp44_ = vala_data_type_copy (_tmp43_);
						_tmp45_ = _tmp44_;
						vala_expression_set_target_type (_tmp42_, _tmp45_);
						_vala_code_node_unref0 (_tmp45_);
						_tmp46_ = self->priv->_expression;
						_tmp47_ = val;
						vala_expression_set_symbol_reference (_tmp46_, (ValaSymbol*) _tmp47_);
						_vala_code_node_unref0 (val);
						break;
					}
					_vala_code_node_unref0 (val);
				}
				_vala_iterable_unref0 (_val_list);
			}
			_vala_code_node_unref0 (enum_type);
		}
		_tmp48_ = self->priv->_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
		_tmp49_ = self->priv->_expression;
		if (!vala_expression_is_constant (_tmp49_)) {
			ValaExpression* _tmp50_;
			ValaSourceReference* _tmp51_;
			ValaSourceReference* _tmp52_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp50_ = self->priv->_expression;
			_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp52_, "Expression must be constant");
			result = FALSE;
			_vala_code_node_unref0 (condition_target_type);
			_vala_code_node_unref0 (switch_statement);
			return result;
		}
		_tmp53_ = self->priv->_expression;
		_tmp54_ = vala_expression_get_value_type (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = switch_statement;
		_tmp57_ = vala_switch_statement_get_expression (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_expression_get_value_type (_tmp58_);
		_tmp60_ = _tmp59_;
		if (!vala_data_type_compatible (_tmp55_, _tmp60_)) {
			ValaExpression* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaExpression* _tmp64_;
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			ValaSwitchStatement* _tmp69_;
			ValaExpression* _tmp70_;
			ValaExpression* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp61_ = self->priv->_expression;
			_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = self->priv->_expression;
			_tmp65_ = vala_expression_get_value_type (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = switch_statement;
			_tmp70_ = vala_switch_statement_get_expression (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_expression_get_value_type (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_code_node_to_string ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp68_, _tmp75_);
			_tmp77_ = _tmp76_;
			vala_report_error (_tmp63_, _tmp77_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp68_);
			result = FALSE;
			_vala_code_node_unref0 (condition_target_type);
			_vala_code_node_unref0 (switch_statement);
			return result;
		}
		_vala_code_node_unref0 (condition_target_type);
		_vala_code_node_unref0 (switch_statement);
	}
	result = TRUE;
	return result;
}


static void
vala_switch_label_real_emit (ValaCodeNode* base,
                             ValaCodeGenerator* codegen)
{
	ValaSwitchLabel * self;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_switch_label ((ValaCodeVisitor*) codegen, self);
}


ValaExpression*
vala_switch_label_get_expression (ValaSwitchLabel* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


void
vala_switch_label_set_expression (ValaSwitchLabel* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression);
	self->priv->_expression = _tmp0_;
}


ValaSwitchSection*
vala_switch_label_get_section (ValaSwitchLabel* self)
{
	ValaSwitchSection* result;
	ValaSwitchSection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_section;
	result = _tmp0_;
	return result;
}


void
vala_switch_label_set_section (ValaSwitchLabel* self,
                               ValaSwitchSection* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_section = value;
}


static void
vala_switch_label_class_init (ValaSwitchLabelClass * klass)
{
	vala_switch_label_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_label_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSwitchLabel_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_label_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_label_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_switch_label_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_switch_label_real_emit;
}


static void
vala_switch_label_instance_init (ValaSwitchLabel * self)
{
	self->priv = vala_switch_label_get_instance_private (self);
}


static void
vala_switch_label_finalize (ValaCodeNode * obj)
{
	ValaSwitchLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel);
	_vala_code_node_unref0 (self->priv->_expression);
	VALA_CODE_NODE_CLASS (vala_switch_label_parent_class)->finalize (obj);
}


/**
 * Represents a switch label in the source code.
 */
GType
vala_switch_label_get_type (void)
{
	static volatile gsize vala_switch_label_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchLabel), 0, (GInstanceInitFunc) vala_switch_label_instance_init, NULL };
		GType vala_switch_label_type_id;
		vala_switch_label_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchLabel", &g_define_type_info, 0);
		ValaSwitchLabel_private_offset = g_type_add_instance_private (vala_switch_label_type_id, sizeof (ValaSwitchLabelPrivate));
		g_once_init_leave (&vala_switch_label_type_id__volatile, vala_switch_label_type_id);
	}
	return vala_switch_label_type_id__volatile;
}



