/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp236_;
	ValaExpression* _tmp237_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp238_;
	ValaExpression* _tmp239_;
	gboolean _tmp240_ = FALSE;
	gboolean _tmp241_ = FALSE;
	ValaAssignmentOperator _tmp242_;
	ValaMemberAccess* _tmp287_;
	ValaExpression* _tmp622_;
	ValaExpression* _tmp623_;
	ValaDataType* _tmp624_;
	ValaDataType* _tmp625_;
	gboolean _tmp634_;
	gboolean _tmp635_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		ValaMemberAccess* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp105_ = FALSE;
		gboolean _tmp106_ = FALSE;
		ValaMemberAccess* _tmp107_;
		ValaSymbol* _tmp108_;
		ValaSymbol* _tmp109_;
		ValaMemberAccess* _tmp125_;
		gboolean _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp137_ = FALSE;
		ValaMemberAccess* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		ValaMemberAccess* _tmp144_;
		ValaSymbol* _tmp145_;
		ValaSymbol* _tmp146_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp99_;
		_tmp100_ = ma;
		_tmp101_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp100_);
		_tmp102_ = _tmp101_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp103_;
			ValaSourceReference* _tmp104_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp104_ = _tmp103_;
			vala_report_error (_tmp104_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp107_ = ma;
		_tmp108_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp107_);
		_tmp109_ = _tmp108_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_DYNAMIC_PROPERTY)) {
			ValaMemberAccess* _tmp110_;
			ValaDataType* _tmp111_;
			ValaDataType* _tmp112_;
			_tmp110_ = ma;
			_tmp111_ = vala_expression_get_value_type ((ValaExpression*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp106_ = _tmp112_ == NULL;
		} else {
			_tmp106_ = FALSE;
		}
		if (_tmp106_) {
			_tmp105_ = TRUE;
		} else {
			gboolean _tmp113_ = FALSE;
			gboolean _tmp114_ = FALSE;
			ValaMemberAccess* _tmp115_;
			ValaExpression* _tmp116_;
			ValaExpression* _tmp117_;
			_tmp115_ = ma;
			_tmp116_ = vala_member_access_get_inner (_tmp115_);
			_tmp117_ = _tmp116_;
			if (_tmp117_ == NULL) {
				ValaMemberAccess* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				_tmp118_ = ma;
				_tmp119_ = vala_member_access_get_member_name (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp114_ = g_strcmp0 (_tmp120_, "this") == 0;
			} else {
				_tmp114_ = FALSE;
			}
			if (_tmp114_) {
				ValaSemanticAnalyzer* _tmp121_;
				ValaSemanticAnalyzer* _tmp122_;
				_tmp121_ = vala_code_context_get_analyzer (context);
				_tmp122_ = _tmp121_;
				_tmp113_ = vala_semantic_analyzer_is_in_instance_method (_tmp122_);
			} else {
				_tmp113_ = FALSE;
			}
			_tmp105_ = _tmp113_;
		}
		if (_tmp105_) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp124_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp125_ = ma;
		_tmp126_ = vala_member_access_get_prototype_access (_tmp125_);
		_tmp127_ = _tmp126_;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_full_name (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp134_);
			_tmp136_ = _tmp135_;
			vala_report_error (_tmp129_, _tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp138_ = ma;
		_tmp139_ = vala_code_node_get_error ((ValaCodeNode*) _tmp138_);
		_tmp140_ = _tmp139_;
		if (_tmp140_) {
			_tmp137_ = TRUE;
		} else {
			ValaMemberAccess* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp137_ = _tmp143_ == NULL;
		}
		if (_tmp137_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp144_ = ma;
		_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp144_);
		_tmp146_ = _tmp145_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp146_, VALA_TYPE_DYNAMIC_PROPERTY)) {
		} else {
			ValaExpression* _tmp147_;
			ValaExpression* _tmp148_;
			ValaMemberAccess* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaExpression* _tmp154_;
			ValaExpression* _tmp155_;
			ValaMemberAccess* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp147_ = vala_assignment_get_right (self);
			_tmp148_ = _tmp147_;
			_tmp149_ = ma;
			_tmp150_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_data_type_copy (_tmp151_);
			_tmp153_ = _tmp152_;
			vala_expression_set_formal_target_type (_tmp148_, _tmp153_);
			_vala_code_node_unref0 (_tmp153_);
			_tmp154_ = vala_assignment_get_right (self);
			_tmp155_ = _tmp154_;
			_tmp156_ = ma;
			_tmp157_ = vala_expression_get_value_type ((ValaExpression*) _tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_data_type_copy (_tmp158_);
			_tmp160_ = _tmp159_;
			vala_expression_set_target_type (_tmp155_, _tmp160_);
			_vala_code_node_unref0 (_tmp160_);
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp161_;
		ValaExpression* _tmp162_;
		_tmp161_ = vala_assignment_get_left (self);
		_tmp162_ = _tmp161_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaElementAccess* _tmp166_;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			ValaDataType* _tmp169_;
			ValaDataType* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaTypeSymbol* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaSemanticAnalyzer* _tmp174_;
			ValaDataType* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			ValaTypeSymbol* _tmp177_;
			_tmp163_ = vala_assignment_get_left (self);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp165_;
			_tmp166_ = ea;
			_tmp167_ = vala_element_access_get_container (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_expression_get_value_type (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_data_type_get_data_type (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_code_context_get_analyzer (context);
			_tmp174_ = _tmp173_;
			_tmp175_ = _tmp174_->string_type;
			_tmp176_ = vala_data_type_get_data_type (_tmp175_);
			_tmp177_ = _tmp176_;
			if (_tmp172_ == _tmp177_) {
				ValaElementAccess* _tmp178_;
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp178_ = ea;
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp180_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				ValaElementAccess* _tmp181_;
				ValaExpression* _tmp182_;
				ValaExpression* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				gboolean _tmp188_;
				_tmp181_ = ea;
				_tmp182_ = vala_element_access_get_container (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_expression_get_value_type (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_data_type_get_member (_tmp185_, "set");
				_tmp187_ = _tmp186_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp187_, VALA_TYPE_METHOD);
				_vala_code_node_unref0 (_tmp187_);
				if (_tmp188_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp189_;
					ValaExpression* _tmp190_;
					ValaExpression* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaSourceReference* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaMemberAccess* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp199_;
					ValaMethodCall* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaCodeNode* _tmp212_;
					ValaCodeNode* _tmp213_;
					ValaMethodCall* _tmp214_;
					ValaMethodCall* _tmp215_;
					_tmp189_ = ea;
					_tmp190_ = vala_element_access_get_container (_tmp189_);
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_member_access_new (_tmp191_, "set", _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_method_call_new ((ValaExpression*) _tmp195_, _tmp197_);
					_tmp199_ = _tmp198_;
					_vala_code_node_unref0 (_tmp195_);
					set_call = _tmp199_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp200_ = ea;
						_tmp201_ = vala_element_access_get_indices (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp205_;
							gpointer _tmp206_;
							ValaMethodCall* _tmp207_;
							ValaExpression* _tmp208_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp205_ = _e_list;
							_tmp206_ = vala_list_get (_tmp205_, _e_index);
							e = (ValaExpression*) _tmp206_;
							_tmp207_ = set_call;
							_tmp208_ = e;
							vala_method_call_add_argument (_tmp207_, _tmp208_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp209_ = set_call;
					_tmp210_ = vala_assignment_get_right (self);
					_tmp211_ = _tmp210_;
					vala_method_call_add_argument (_tmp209_, _tmp211_);
					_tmp212_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = set_call;
					vala_code_node_replace_expression (_tmp213_, (ValaExpression*) self, (ValaExpression*) _tmp214_);
					_tmp215_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
					_vala_code_node_unref0 (set_call);
					_vala_code_node_unref0 (ea);
					return result;
				} else {
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					_tmp216_ = vala_assignment_get_right (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_assignment_get_left (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_data_type_copy (_tmp221_);
					_tmp223_ = _tmp222_;
					vala_expression_set_target_type (_tmp217_, _tmp223_);
					_vala_code_node_unref0 (_tmp223_);
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp224_;
			ValaExpression* _tmp225_;
			_tmp224_ = vala_assignment_get_left (self);
			_tmp225_ = _tmp224_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp225_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				_tmp226_ = vala_assignment_get_right (self);
				_tmp227_ = _tmp226_;
				_tmp228_ = vala_assignment_get_left (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_expression_get_value_type (_tmp229_);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_data_type_copy (_tmp231_);
				_tmp233_ = _tmp232_;
				vala_expression_set_target_type (_tmp227_, _tmp233_);
				_vala_code_node_unref0 (_tmp233_);
			} else {
				ValaSourceReference* _tmp234_;
				ValaSourceReference* _tmp235_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp235_ = _tmp234_;
				vala_report_error (_tmp235_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp236_ = vala_assignment_get_right (self);
	_tmp237_ = _tmp236_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp237_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp238_ = vala_assignment_get_left (self);
	_tmp239_ = _tmp238_;
	ma = G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp239_) : NULL;
	_tmp242_ = self->priv->_operator;
	if (_tmp242_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp243_;
		_tmp243_ = ma;
		_tmp241_ = _tmp243_ != NULL;
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		gboolean _tmp244_ = FALSE;
		ValaExpression* _tmp245_;
		ValaExpression* _tmp246_;
		ValaDataType* _tmp247_;
		ValaDataType* _tmp248_;
		_tmp245_ = vala_assignment_get_left (self);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_expression_get_value_type (_tmp246_);
		_tmp248_ = _tmp247_;
		if (vala_data_type_is_non_null_simple_type (_tmp248_)) {
			ValaMemberAccess* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			_tmp249_ = ma;
			_tmp250_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp249_);
			_tmp251_ = _tmp250_;
			_tmp244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp251_, VALA_TYPE_LOCAL_VARIABLE);
		} else {
			_tmp244_ = FALSE;
		}
		_tmp240_ = !_tmp244_;
	} else {
		_tmp240_ = FALSE;
	}
	if (_tmp240_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp252_;
		ValaExpression* _tmp253_;
		ValaExpression* _tmp254_;
		ValaMemberAccess* _tmp255_;
		const gchar* _tmp256_;
		const gchar* _tmp257_;
		ValaMemberAccess* _tmp258_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp259_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp260_;
		ValaMemberAccess* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaBinaryExpression* _tmp266_;
		ValaBinaryExpression* _tmp267_;
		ValaExpression* _tmp268_;
		ValaExpression* _tmp269_;
		ValaDataType* _tmp270_;
		ValaDataType* _tmp271_;
		ValaExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaExpression* _tmp274_;
		ValaExpression* _tmp275_;
		ValaDataType* _tmp276_;
		ValaDataType* _tmp277_;
		ValaDataType* _tmp278_;
		ValaDataType* _tmp279_;
		ValaExpression* _tmp280_;
		ValaExpression* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaBinaryExpression* _tmp284_;
		ValaExpression* _tmp285_;
		ValaExpression* _tmp286_;
		_tmp252_ = ma;
		_tmp253_ = vala_member_access_get_inner (_tmp252_);
		_tmp254_ = _tmp253_;
		_tmp255_ = ma;
		_tmp256_ = vala_member_access_get_member_name (_tmp255_);
		_tmp257_ = _tmp256_;
		_tmp258_ = vala_member_access_new (_tmp254_, _tmp257_, NULL);
		old_value = _tmp258_;
		_tmp259_ = self->priv->_operator;
		switch (_tmp259_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
		_tmp260_ = bop;
		_tmp261_ = old_value;
		_tmp262_ = vala_assignment_get_right (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_binary_expression_new (_tmp260_, (ValaExpression*) _tmp261_, _tmp263_, _tmp265_);
		bin = _tmp266_;
		_tmp267_ = bin;
		_tmp268_ = vala_assignment_get_right (self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_expression_get_target_type (_tmp269_);
		_tmp271_ = _tmp270_;
		vala_expression_set_target_type ((ValaExpression*) _tmp267_, _tmp271_);
		_tmp272_ = vala_assignment_get_right (self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_assignment_get_right (self);
		_tmp275_ = _tmp274_;
		_tmp276_ = vala_expression_get_target_type (_tmp275_);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_data_type_copy (_tmp277_);
		_tmp279_ = _tmp278_;
		vala_expression_set_target_type (_tmp273_, _tmp279_);
		_vala_code_node_unref0 (_tmp279_);
		_tmp280_ = vala_assignment_get_right (self);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_expression_get_target_type (_tmp281_);
		_tmp283_ = _tmp282_;
		vala_data_type_set_value_owned (_tmp283_, FALSE);
		_tmp284_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp284_);
		_tmp285_ = vala_assignment_get_right (self);
		_tmp286_ = _tmp285_;
		vala_code_node_check ((ValaCodeNode*) _tmp286_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp287_ = ma;
	if (_tmp287_ != NULL) {
		ValaMemberAccess* _tmp288_;
		ValaSymbol* _tmp289_;
		ValaSymbol* _tmp290_;
		gboolean _tmp430_ = FALSE;
		ValaExpression* _tmp431_;
		ValaExpression* _tmp432_;
		ValaDataType* _tmp433_;
		ValaDataType* _tmp434_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp489_;
		ValaExpression* _tmp490_;
		ValaMemberAccess* _tmp491_;
		gboolean _tmp492_ = FALSE;
		ValaMemberAccess* _tmp493_;
		_tmp288_ = ma;
		_tmp289_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp288_);
		_tmp290_ = _tmp289_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp290_, VALA_TYPE_PROPERTY)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp291_;
			ValaSymbol* _tmp292_;
			ValaSymbol* _tmp293_;
			ValaProperty* _tmp294_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp295_;
			ValaDynamicProperty* _tmp296_;
			ValaDynamicProperty* _tmp297_;
			gboolean _tmp312_ = FALSE;
			ValaProperty* _tmp313_;
			ValaPropertyAccessor* _tmp314_;
			ValaPropertyAccessor* _tmp315_;
			_tmp291_ = ma;
			_tmp292_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp291_);
			_tmp293_ = _tmp292_;
			_tmp294_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp293_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp294_;
			_tmp295_ = prop;
			_tmp296_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp295_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp295_) : NULL);
			dynamic_prop = _tmp296_;
			_tmp297_ = dynamic_prop;
			if (_tmp297_ != NULL) {
				ValaDynamicProperty* _tmp298_;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaDataType* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				ValaDataType* _tmp304_;
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDynamicProperty* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				ValaDataType* _tmp310_;
				ValaDataType* _tmp311_;
				_tmp298_ = dynamic_prop;
				_tmp299_ = vala_assignment_get_right (self);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_expression_get_value_type (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_data_type_copy (_tmp302_);
				_tmp304_ = _tmp303_;
				vala_property_set_property_type ((ValaProperty*) _tmp298_, _tmp304_);
				_vala_code_node_unref0 (_tmp304_);
				_tmp305_ = vala_assignment_get_left (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = dynamic_prop;
				_tmp308_ = vala_property_get_property_type ((ValaProperty*) _tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_copy (_tmp309_);
				_tmp311_ = _tmp310_;
				vala_expression_set_value_type (_tmp306_, _tmp311_);
				_vala_code_node_unref0 (_tmp311_);
			}
			_tmp313_ = prop;
			_tmp314_ = vala_property_get_set_accessor (_tmp313_);
			_tmp315_ = _tmp314_;
			if (_tmp315_ == NULL) {
				_tmp312_ = TRUE;
			} else {
				gboolean _tmp316_ = FALSE;
				ValaProperty* _tmp317_;
				ValaPropertyAccessor* _tmp318_;
				ValaPropertyAccessor* _tmp319_;
				gboolean _tmp320_;
				gboolean _tmp321_;
				_tmp317_ = prop;
				_tmp318_ = vala_property_get_set_accessor (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_property_accessor_get_writable (_tmp319_);
				_tmp321_ = _tmp320_;
				if (!_tmp321_) {
					gboolean _tmp322_ = FALSE;
					ValaSemanticAnalyzer* _tmp323_;
					ValaSemanticAnalyzer* _tmp324_;
					ValaMethod* _tmp325_;
					ValaMethod* _tmp326_;
					gboolean _tmp327_;
					_tmp323_ = vala_code_context_get_analyzer (context);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_semantic_analyzer_find_current_method (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp326_, VALA_TYPE_CREATION_METHOD);
					_vala_code_node_unref0 (_tmp326_);
					if (_tmp327_) {
						_tmp322_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp328_;
						ValaSemanticAnalyzer* _tmp329_;
						_tmp328_ = vala_code_context_get_analyzer (context);
						_tmp329_ = _tmp328_;
						_tmp322_ = vala_semantic_analyzer_is_in_constructor (_tmp329_);
					}
					_tmp316_ = !_tmp322_;
				} else {
					_tmp316_ = FALSE;
				}
				_tmp312_ = _tmp316_;
			}
			if (_tmp312_) {
				ValaMemberAccess* _tmp330_;
				ValaMemberAccess* _tmp331_;
				ValaSourceReference* _tmp332_;
				ValaSourceReference* _tmp333_;
				ValaProperty* _tmp334_;
				gchar* _tmp335_;
				gchar* _tmp336_;
				gchar* _tmp337_;
				gchar* _tmp338_;
				_tmp330_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp330_, TRUE);
				_tmp331_ = ma;
				_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp331_);
				_tmp333_ = _tmp332_;
				_tmp334_ = prop;
				_tmp335_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp334_);
				_tmp336_ = _tmp335_;
				_tmp337_ = g_strdup_printf ("Property `%s' is read-only", _tmp336_);
				_tmp338_ = _tmp337_;
				vala_report_error (_tmp333_, _tmp338_);
				_g_free0 (_tmp338_);
				_g_free0 (_tmp336_);
				result = FALSE;
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
				return result;
			} else {
				gboolean _tmp339_ = FALSE;
				gboolean _tmp340_ = FALSE;
				gboolean _tmp341_;
				gboolean _tmp342_;
				_tmp341_ = vala_code_context_get_deprecated (context);
				_tmp342_ = _tmp341_;
				if (!_tmp342_) {
					ValaProperty* _tmp343_;
					ValaPropertyAccessor* _tmp344_;
					ValaPropertyAccessor* _tmp345_;
					gboolean _tmp346_;
					gboolean _tmp347_;
					_tmp343_ = prop;
					_tmp344_ = vala_property_get_set_accessor (_tmp343_);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_property_accessor_get_writable (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp340_ = !_tmp347_;
				} else {
					_tmp340_ = FALSE;
				}
				if (_tmp340_) {
					ValaSemanticAnalyzer* _tmp348_;
					ValaSemanticAnalyzer* _tmp349_;
					ValaMethod* _tmp350_;
					ValaMethod* _tmp351_;
					_tmp348_ = vala_code_context_get_analyzer (context);
					_tmp349_ = _tmp348_;
					_tmp350_ = vala_semantic_analyzer_find_current_method (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp339_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp351_, VALA_TYPE_CREATION_METHOD);
					_vala_code_node_unref0 (_tmp351_);
				} else {
					_tmp339_ = FALSE;
				}
				if (_tmp339_) {
					ValaMemberAccess* _tmp352_;
					ValaExpression* _tmp353_;
					ValaExpression* _tmp354_;
					ValaSymbol* _tmp355_;
					ValaSymbol* _tmp356_;
					ValaSemanticAnalyzer* _tmp357_;
					ValaSemanticAnalyzer* _tmp358_;
					ValaMethod* _tmp359_;
					ValaMethod* _tmp360_;
					ValaParameter* _tmp361_;
					ValaParameter* _tmp362_;
					gboolean _tmp363_;
					_tmp352_ = ma;
					_tmp353_ = vala_member_access_get_inner (_tmp352_);
					_tmp354_ = _tmp353_;
					_tmp355_ = vala_expression_get_symbol_reference (_tmp354_);
					_tmp356_ = _tmp355_;
					_tmp357_ = vala_code_context_get_analyzer (context);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_semantic_analyzer_find_current_method (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_method_get_this_parameter (_tmp360_);
					_tmp362_ = _tmp361_;
					_tmp363_ = _tmp356_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp362_, VALA_TYPE_SYMBOL, ValaSymbol);
					_vala_code_node_unref0 (_tmp360_);
					if (_tmp363_) {
						ValaMemberAccess* _tmp364_;
						ValaSourceReference* _tmp365_;
						ValaSourceReference* _tmp366_;
						ValaProperty* _tmp367_;
						gchar* _tmp368_;
						gchar* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						_tmp364_ = ma;
						_tmp365_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = prop;
						_tmp368_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = g_strdup_printf ("Property `%s' is read-only", _tmp369_);
						_tmp371_ = _tmp370_;
						vala_report_error (_tmp366_, _tmp371_);
						_g_free0 (_tmp371_);
						_g_free0 (_tmp369_);
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					} else {
						ValaMemberAccess* _tmp372_;
						ValaSourceReference* _tmp373_;
						ValaSourceReference* _tmp374_;
						_tmp372_ = ma;
						_tmp373_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp372_);
						_tmp374_ = _tmp373_;
						vala_report_error (_tmp374_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (dynamic_prop);
			_vala_code_node_unref0 (prop);
		} else {
			gboolean _tmp375_ = FALSE;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp378_, VALA_TYPE_VARIABLE)) {
				ValaExpression* _tmp379_;
				ValaExpression* _tmp380_;
				ValaDataType* _tmp381_;
				ValaDataType* _tmp382_;
				_tmp379_ = vala_assignment_get_right (self);
				_tmp380_ = _tmp379_;
				_tmp381_ = vala_expression_get_value_type (_tmp380_);
				_tmp382_ = _tmp381_;
				_tmp375_ = _tmp382_ == NULL;
			} else {
				_tmp375_ = FALSE;
			}
			if (_tmp375_) {
				ValaVariable* variable = NULL;
				ValaMemberAccess* _tmp383_;
				ValaSymbol* _tmp384_;
				ValaSymbol* _tmp385_;
				ValaVariable* _tmp386_;
				gboolean _tmp387_ = FALSE;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				_tmp383_ = ma;
				_tmp384_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp383_);
				_tmp385_ = _tmp384_;
				_tmp386_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp385_, VALA_TYPE_VARIABLE, ValaVariable));
				variable = _tmp386_;
				_tmp388_ = vala_assignment_get_right (self);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_symbol_reference (_tmp389_);
				_tmp391_ = _tmp390_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp391_, VALA_TYPE_METHOD)) {
					ValaVariable* _tmp392_;
					ValaDataType* _tmp393_;
					ValaDataType* _tmp394_;
					_tmp392_ = variable;
					_tmp393_ = vala_variable_get_variable_type (_tmp392_);
					_tmp394_ = _tmp393_;
					_tmp387_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp394_, VALA_TYPE_DELEGATE_TYPE);
				} else {
					_tmp387_ = FALSE;
				}
				if (_tmp387_) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp395_;
					ValaExpression* _tmp396_;
					ValaSymbol* _tmp397_;
					ValaSymbol* _tmp398_;
					ValaMethod* _tmp399_;
					ValaDelegateType* dt = NULL;
					ValaVariable* _tmp400_;
					ValaDataType* _tmp401_;
					ValaDataType* _tmp402_;
					ValaDelegateType* _tmp403_;
					ValaDelegate* cb = NULL;
					ValaDelegateType* _tmp404_;
					ValaDelegate* _tmp405_;
					ValaDelegate* _tmp406_;
					ValaDelegate* _tmp407_;
					ValaDelegate* _tmp408_;
					ValaMethod* _tmp409_;
					ValaDelegateType* _tmp410_;
					ValaExpression* _tmp421_;
					ValaExpression* _tmp422_;
					ValaVariable* _tmp423_;
					ValaDataType* _tmp424_;
					ValaDataType* _tmp425_;
					ValaDataType* _tmp426_;
					ValaDataType* _tmp427_;
					_tmp395_ = vala_assignment_get_right (self);
					_tmp396_ = _tmp395_;
					_tmp397_ = vala_expression_get_symbol_reference (_tmp396_);
					_tmp398_ = _tmp397_;
					_tmp399_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp398_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp399_;
					_tmp400_ = variable;
					_tmp401_ = vala_variable_get_variable_type (_tmp400_);
					_tmp402_ = _tmp401_;
					_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					dt = _tmp403_;
					_tmp404_ = dt;
					_tmp405_ = vala_delegate_type_get_delegate_symbol (_tmp404_);
					_tmp406_ = _tmp405_;
					_tmp407_ = _vala_code_node_ref0 (_tmp406_);
					cb = _tmp407_;
					_tmp408_ = cb;
					_tmp409_ = m;
					_tmp410_ = dt;
					if (!vala_delegate_matches_method (_tmp408_, _tmp409_, (ValaDataType*) _tmp410_)) {
						ValaSourceReference* _tmp411_;
						ValaSourceReference* _tmp412_;
						ValaMethod* _tmp413_;
						gchar* _tmp414_;
						gchar* _tmp415_;
						ValaDelegate* _tmp416_;
						gchar* _tmp417_;
						gchar* _tmp418_;
						gchar* _tmp419_;
						gchar* _tmp420_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp412_ = _tmp411_;
						_tmp413_ = m;
						_tmp414_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp413_);
						_tmp415_ = _tmp414_;
						_tmp416_ = cb;
						_tmp417_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp416_);
						_tmp418_ = _tmp417_;
						_tmp419_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp415_, _tmp418_);
						_tmp420_ = _tmp419_;
						vala_report_error (_tmp412_, _tmp420_);
						_g_free0 (_tmp420_);
						_g_free0 (_tmp418_);
						_g_free0 (_tmp415_);
						result = FALSE;
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (variable);
						return result;
					}
					_tmp421_ = vala_assignment_get_right (self);
					_tmp422_ = _tmp421_;
					_tmp423_ = variable;
					_tmp424_ = vala_variable_get_variable_type (_tmp423_);
					_tmp425_ = _tmp424_;
					_tmp426_ = vala_data_type_copy (_tmp425_);
					_tmp427_ = _tmp426_;
					vala_expression_set_value_type (_tmp422_, _tmp427_);
					_vala_code_node_unref0 (_tmp427_);
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
				} else {
					ValaSourceReference* _tmp428_;
					ValaSourceReference* _tmp429_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp429_ = _tmp428_;
					vala_report_error (_tmp429_, "Assignment: Invalid assignment attempt");
					result = FALSE;
					_vala_code_node_unref0 (variable);
					return result;
				}
				_vala_code_node_unref0 (variable);
			}
		}
		_tmp431_ = vala_assignment_get_left (self);
		_tmp432_ = _tmp431_;
		_tmp433_ = vala_expression_get_value_type (_tmp432_);
		_tmp434_ = _tmp433_;
		if (_tmp434_ != NULL) {
			ValaExpression* _tmp435_;
			ValaExpression* _tmp436_;
			ValaDataType* _tmp437_;
			ValaDataType* _tmp438_;
			_tmp435_ = vala_assignment_get_right (self);
			_tmp436_ = _tmp435_;
			_tmp437_ = vala_expression_get_value_type (_tmp436_);
			_tmp438_ = _tmp437_;
			_tmp430_ = _tmp438_ != NULL;
		} else {
			_tmp430_ = FALSE;
		}
		if (_tmp430_) {
			ValaExpression* _tmp439_;
			ValaExpression* _tmp440_;
			ValaDataType* _tmp441_;
			ValaDataType* _tmp442_;
			ValaExpression* _tmp443_;
			ValaExpression* _tmp444_;
			ValaDataType* _tmp445_;
			ValaDataType* _tmp446_;
			ValaMemberAccess* _tmp463_;
			ValaSymbol* _tmp464_;
			ValaSymbol* _tmp465_;
			_tmp439_ = vala_assignment_get_right (self);
			_tmp440_ = _tmp439_;
			_tmp441_ = vala_expression_get_value_type (_tmp440_);
			_tmp442_ = _tmp441_;
			_tmp443_ = vala_assignment_get_left (self);
			_tmp444_ = _tmp443_;
			_tmp445_ = vala_expression_get_value_type (_tmp444_);
			_tmp446_ = _tmp445_;
			if (!vala_data_type_compatible (_tmp442_, _tmp446_)) {
				ValaSourceReference* _tmp447_;
				ValaSourceReference* _tmp448_;
				ValaExpression* _tmp449_;
				ValaExpression* _tmp450_;
				ValaDataType* _tmp451_;
				ValaDataType* _tmp452_;
				gchar* _tmp453_;
				gchar* _tmp454_;
				ValaExpression* _tmp455_;
				ValaExpression* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				gchar* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				gchar* _tmp462_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_assignment_get_right (self);
				_tmp450_ = _tmp449_;
				_tmp451_ = vala_expression_get_value_type (_tmp450_);
				_tmp452_ = _tmp451_;
				_tmp453_ = vala_code_node_to_string ((ValaCodeNode*) _tmp452_);
				_tmp454_ = _tmp453_;
				_tmp455_ = vala_assignment_get_left (self);
				_tmp456_ = _tmp455_;
				_tmp457_ = vala_expression_get_value_type (_tmp456_);
				_tmp458_ = _tmp457_;
				_tmp459_ = vala_code_node_to_string ((ValaCodeNode*) _tmp458_);
				_tmp460_ = _tmp459_;
				_tmp461_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp454_, _tmp460_);
				_tmp462_ = _tmp461_;
				vala_report_error (_tmp448_, _tmp462_);
				_g_free0 (_tmp462_);
				_g_free0 (_tmp460_);
				_g_free0 (_tmp454_);
				result = FALSE;
				return result;
			}
			_tmp463_ = ma;
			_tmp464_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp463_);
			_tmp465_ = _tmp464_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp465_, VALA_TYPE_PROPERTY)) {
				ValaExpression* _tmp466_;
				ValaExpression* _tmp467_;
				ValaDataType* _tmp468_;
				ValaDataType* _tmp469_;
				_tmp466_ = vala_assignment_get_right (self);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_expression_get_value_type (_tmp467_);
				_tmp469_ = _tmp468_;
				if (vala_data_type_is_disposable (_tmp469_)) {
					gboolean _tmp470_ = FALSE;
					ValaExpression* _tmp471_;
					ValaExpression* _tmp472_;
					ValaDataType* _tmp473_;
					ValaDataType* _tmp474_;
					_tmp471_ = vala_assignment_get_left (self);
					_tmp472_ = _tmp471_;
					_tmp473_ = vala_expression_get_value_type (_tmp472_);
					_tmp474_ = _tmp473_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp474_, VALA_TYPE_POINTER_TYPE)) {
						ValaExpression* _tmp475_;
						ValaExpression* _tmp476_;
						ValaDataType* _tmp477_;
						ValaDataType* _tmp478_;
						gboolean _tmp479_;
						gboolean _tmp480_;
						_tmp475_ = vala_assignment_get_left (self);
						_tmp476_ = _tmp475_;
						_tmp477_ = vala_expression_get_value_type (_tmp476_);
						_tmp478_ = _tmp477_;
						_tmp479_ = vala_data_type_get_value_owned (_tmp478_);
						_tmp480_ = _tmp479_;
						_tmp470_ = !_tmp480_;
					} else {
						_tmp470_ = FALSE;
					}
					if (_tmp470_) {
						ValaSourceReference* _tmp481_;
						ValaSourceReference* _tmp482_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp482_ = _tmp481_;
						vala_report_error (_tmp482_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp483_;
					ValaExpression* _tmp484_;
					ValaDataType* _tmp485_;
					ValaDataType* _tmp486_;
					gboolean _tmp487_;
					gboolean _tmp488_;
					_tmp483_ = vala_assignment_get_left (self);
					_tmp484_ = _tmp483_;
					_tmp485_ = vala_expression_get_value_type (_tmp484_);
					_tmp486_ = _tmp485_;
					_tmp487_ = vala_data_type_get_value_owned (_tmp486_);
					_tmp488_ = _tmp487_;
					if (_tmp488_) {
					}
				}
			}
		}
		_tmp489_ = vala_assignment_get_right (self);
		_tmp490_ = _tmp489_;
		_tmp491_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp490_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp490_) : NULL);
		right_ma = _tmp491_;
		_tmp493_ = right_ma;
		if (_tmp493_ != NULL) {
			ValaMemberAccess* _tmp494_;
			ValaSymbol* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaMemberAccess* _tmp497_;
			ValaSymbol* _tmp498_;
			ValaSymbol* _tmp499_;
			_tmp494_ = ma;
			_tmp495_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp494_);
			_tmp496_ = _tmp495_;
			_tmp497_ = right_ma;
			_tmp498_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp497_);
			_tmp499_ = _tmp498_;
			_tmp492_ = _tmp496_ == _tmp499_;
		} else {
			_tmp492_ = FALSE;
		}
		if (_tmp492_) {
			gboolean _tmp500_ = FALSE;
			ValaMemberAccess* _tmp501_;
			ValaSymbol* _tmp502_;
			ValaSymbol* _tmp503_;
			_tmp501_ = ma;
			_tmp502_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp501_);
			_tmp503_ = _tmp502_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp503_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp500_ = TRUE;
			} else {
				ValaMemberAccess* _tmp504_;
				ValaSymbol* _tmp505_;
				ValaSymbol* _tmp506_;
				_tmp504_ = ma;
				_tmp505_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp504_);
				_tmp506_ = _tmp505_;
				_tmp500_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp506_, VALA_TYPE_PARAMETER);
			}
			if (_tmp500_) {
				ValaSourceReference* _tmp507_;
				ValaSourceReference* _tmp508_;
				_tmp507_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp508_ = _tmp507_;
				vala_report_warning (_tmp508_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp509_;
				ValaSymbol* _tmp510_;
				ValaSymbol* _tmp511_;
				_tmp509_ = ma;
				_tmp510_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp509_);
				_tmp511_ = _tmp510_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp511_, VALA_TYPE_FIELD)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp512_;
					ValaSymbol* _tmp513_;
					ValaSymbol* _tmp514_;
					ValaField* _tmp515_;
					ValaField* _tmp516_;
					ValaMemberBinding _tmp517_;
					ValaMemberBinding _tmp518_;
					_tmp512_ = ma;
					_tmp513_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp512_);
					_tmp514_ = _tmp513_;
					_tmp515_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp514_, VALA_TYPE_FIELD, ValaField));
					f = _tmp515_;
					_tmp516_ = f;
					_tmp517_ = vala_field_get_binding (_tmp516_);
					_tmp518_ = _tmp517_;
					if (_tmp518_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp519_;
						ValaSourceReference* _tmp520_;
						_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp520_ = _tmp519_;
						vala_report_warning (_tmp520_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp521_;
						ValaExpression* _tmp522_;
						ValaExpression* _tmp523_;
						ValaMemberAccess* _tmp524_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp525_;
						ValaExpression* _tmp526_;
						ValaExpression* _tmp527_;
						ValaMemberAccess* _tmp528_;
						gboolean _tmp529_ = FALSE;
						gboolean _tmp530_ = FALSE;
						gboolean _tmp531_ = FALSE;
						gboolean _tmp532_ = FALSE;
						gboolean _tmp533_ = FALSE;
						ValaMemberAccess* _tmp534_;
						_tmp521_ = ma;
						_tmp522_ = vala_member_access_get_inner (_tmp521_);
						_tmp523_ = _tmp522_;
						_tmp524_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp523_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp523_) : NULL);
						ma_inner = _tmp524_;
						_tmp525_ = right_ma;
						_tmp526_ = vala_member_access_get_inner (_tmp525_);
						_tmp527_ = _tmp526_;
						_tmp528_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp527_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp527_) : NULL);
						right_ma_inner = _tmp528_;
						_tmp534_ = ma_inner;
						if (_tmp534_ != NULL) {
							ValaMemberAccess* _tmp535_;
							const gchar* _tmp536_;
							const gchar* _tmp537_;
							_tmp535_ = ma_inner;
							_tmp536_ = vala_member_access_get_member_name (_tmp535_);
							_tmp537_ = _tmp536_;
							_tmp533_ = g_strcmp0 (_tmp537_, "this") == 0;
						} else {
							_tmp533_ = FALSE;
						}
						if (_tmp533_) {
							ValaMemberAccess* _tmp538_;
							ValaExpression* _tmp539_;
							ValaExpression* _tmp540_;
							_tmp538_ = ma_inner;
							_tmp539_ = vala_member_access_get_inner (_tmp538_);
							_tmp540_ = _tmp539_;
							_tmp532_ = _tmp540_ == NULL;
						} else {
							_tmp532_ = FALSE;
						}
						if (_tmp532_) {
							ValaMemberAccess* _tmp541_;
							_tmp541_ = right_ma_inner;
							_tmp531_ = _tmp541_ != NULL;
						} else {
							_tmp531_ = FALSE;
						}
						if (_tmp531_) {
							ValaMemberAccess* _tmp542_;
							const gchar* _tmp543_;
							const gchar* _tmp544_;
							_tmp542_ = right_ma_inner;
							_tmp543_ = vala_member_access_get_member_name (_tmp542_);
							_tmp544_ = _tmp543_;
							_tmp530_ = g_strcmp0 (_tmp544_, "this") == 0;
						} else {
							_tmp530_ = FALSE;
						}
						if (_tmp530_) {
							ValaMemberAccess* _tmp545_;
							ValaExpression* _tmp546_;
							ValaExpression* _tmp547_;
							_tmp545_ = right_ma_inner;
							_tmp546_ = vala_member_access_get_inner (_tmp545_);
							_tmp547_ = _tmp546_;
							_tmp529_ = _tmp547_ == NULL;
						} else {
							_tmp529_ = FALSE;
						}
						if (_tmp529_) {
							ValaSourceReference* _tmp548_;
							ValaSourceReference* _tmp549_;
							_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp549_ = _tmp548_;
							vala_report_warning (_tmp549_, "Assignment to same variable");
						}
						_vala_code_node_unref0 (right_ma_inner);
						_vala_code_node_unref0 (ma_inner);
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
	} else {
		ValaExpression* _tmp550_;
		ValaExpression* _tmp551_;
		_tmp550_ = vala_assignment_get_left (self);
		_tmp551_ = _tmp550_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp551_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp552_;
			ValaExpression* _tmp553_;
			ValaElementAccess* _tmp554_;
			ValaExpression* _tmp555_;
			ValaExpression* _tmp556_;
			ValaDataType* _tmp557_;
			ValaDataType* _tmp558_;
			ValaExpression* _tmp559_;
			ValaExpression* _tmp560_;
			ValaDataType* _tmp561_;
			ValaDataType* _tmp562_;
			ValaExpression* _tmp579_;
			ValaExpression* _tmp580_;
			ValaDataType* _tmp581_;
			ValaDataType* _tmp582_;
			_tmp552_ = vala_assignment_get_left (self);
			_tmp553_ = _tmp552_;
			_tmp554_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp553_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp554_;
			_tmp555_ = vala_assignment_get_right (self);
			_tmp556_ = _tmp555_;
			_tmp557_ = vala_expression_get_value_type (_tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = vala_assignment_get_left (self);
			_tmp560_ = _tmp559_;
			_tmp561_ = vala_expression_get_value_type (_tmp560_);
			_tmp562_ = _tmp561_;
			if (!vala_data_type_compatible (_tmp558_, _tmp562_)) {
				ValaSourceReference* _tmp563_;
				ValaSourceReference* _tmp564_;
				ValaExpression* _tmp565_;
				ValaExpression* _tmp566_;
				ValaDataType* _tmp567_;
				ValaDataType* _tmp568_;
				gchar* _tmp569_;
				gchar* _tmp570_;
				ValaExpression* _tmp571_;
				ValaExpression* _tmp572_;
				ValaDataType* _tmp573_;
				ValaDataType* _tmp574_;
				gchar* _tmp575_;
				gchar* _tmp576_;
				gchar* _tmp577_;
				gchar* _tmp578_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp564_ = _tmp563_;
				_tmp565_ = vala_assignment_get_right (self);
				_tmp566_ = _tmp565_;
				_tmp567_ = vala_expression_get_value_type (_tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_code_node_to_string ((ValaCodeNode*) _tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_assignment_get_left (self);
				_tmp572_ = _tmp571_;
				_tmp573_ = vala_expression_get_value_type (_tmp572_);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_code_node_to_string ((ValaCodeNode*) _tmp574_);
				_tmp576_ = _tmp575_;
				_tmp577_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp570_, _tmp576_);
				_tmp578_ = _tmp577_;
				vala_report_error (_tmp564_, _tmp578_);
				_g_free0 (_tmp578_);
				_g_free0 (_tmp576_);
				_g_free0 (_tmp570_);
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			}
			_tmp579_ = vala_assignment_get_right (self);
			_tmp580_ = _tmp579_;
			_tmp581_ = vala_expression_get_value_type (_tmp580_);
			_tmp582_ = _tmp581_;
			if (vala_data_type_is_disposable (_tmp582_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp583_;
				ValaExpression* _tmp584_;
				ValaExpression* _tmp585_;
				ValaDataType* _tmp586_;
				ValaDataType* _tmp587_;
				gboolean _tmp609_ = FALSE;
				ValaDataType* _tmp610_;
				_tmp583_ = ea;
				_tmp584_ = vala_element_access_get_container (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_expression_get_value_type (_tmp585_);
				_tmp587_ = _tmp586_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp587_, VALA_TYPE_ARRAY_TYPE)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp588_;
					ValaExpression* _tmp589_;
					ValaExpression* _tmp590_;
					ValaDataType* _tmp591_;
					ValaDataType* _tmp592_;
					ValaArrayType* _tmp593_;
					ValaArrayType* _tmp594_;
					ValaDataType* _tmp595_;
					ValaDataType* _tmp596_;
					ValaDataType* _tmp597_;
					_tmp588_ = ea;
					_tmp589_ = vala_element_access_get_container (_tmp588_);
					_tmp590_ = _tmp589_;
					_tmp591_ = vala_expression_get_value_type (_tmp590_);
					_tmp592_ = _tmp591_;
					_tmp593_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp592_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp593_;
					_tmp594_ = array_type;
					_tmp595_ = vala_array_type_get_element_type (_tmp594_);
					_tmp596_ = _tmp595_;
					_tmp597_ = _vala_code_node_ref0 (_tmp596_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp597_;
					_vala_code_node_unref0 (array_type);
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp598_;
					ValaExpression* _tmp599_;
					ValaExpression* _tmp600_;
					ValaDataType* _tmp601_;
					ValaDataType* _tmp602_;
					ValaList* _tmp603_;
					ValaList* _tmp604_;
					gint _tmp605_;
					gint _tmp606_;
					ValaList* _tmp607_;
					gpointer _tmp608_;
					_tmp598_ = ea;
					_tmp599_ = vala_element_access_get_container (_tmp598_);
					_tmp600_ = _tmp599_;
					_tmp601_ = vala_expression_get_value_type (_tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_data_type_get_type_arguments (_tmp602_);
					args = _tmp603_;
					_tmp604_ = args;
					_tmp605_ = vala_collection_get_size ((ValaCollection*) _tmp604_);
					_tmp606_ = _tmp605_;
					_vala_assert (_tmp606_ == 1, "args.size == 1");
					_tmp607_ = args;
					_tmp608_ = vala_list_get (_tmp607_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp608_;
					_vala_iterable_unref0 (args);
				}
				_tmp610_ = element_type;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp610_, VALA_TYPE_POINTER_TYPE)) {
					ValaDataType* _tmp611_;
					gboolean _tmp612_;
					gboolean _tmp613_;
					_tmp611_ = element_type;
					_tmp612_ = vala_data_type_get_value_owned (_tmp611_);
					_tmp613_ = _tmp612_;
					_tmp609_ = !_tmp613_;
				} else {
					_tmp609_ = FALSE;
				}
				if (_tmp609_) {
					ValaSourceReference* _tmp614_;
					ValaSourceReference* _tmp615_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp614_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp615_ = _tmp614_;
					vala_report_error (_tmp615_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (ea);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp616_;
				ValaExpression* _tmp617_;
				ValaDataType* _tmp618_;
				ValaDataType* _tmp619_;
				gboolean _tmp620_;
				gboolean _tmp621_;
				_tmp616_ = vala_assignment_get_left (self);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_expression_get_value_type (_tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_data_type_get_value_owned (_tmp619_);
				_tmp621_ = _tmp620_;
				if (_tmp621_) {
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp622_ = vala_assignment_get_left (self);
	_tmp623_ = _tmp622_;
	_tmp624_ = vala_expression_get_value_type (_tmp623_);
	_tmp625_ = _tmp624_;
	if (_tmp625_ != NULL) {
		ValaExpression* _tmp626_;
		ValaExpression* _tmp627_;
		ValaDataType* _tmp628_;
		ValaDataType* _tmp629_;
		ValaDataType* _tmp630_;
		ValaDataType* _tmp631_;
		ValaDataType* _tmp632_;
		ValaDataType* _tmp633_;
		_tmp626_ = vala_assignment_get_left (self);
		_tmp627_ = _tmp626_;
		_tmp628_ = vala_expression_get_value_type (_tmp627_);
		_tmp629_ = _tmp628_;
		_tmp630_ = vala_data_type_copy (_tmp629_);
		_tmp631_ = _tmp630_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp631_);
		_vala_code_node_unref0 (_tmp631_);
		_tmp632_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp633_ = _tmp632_;
		vala_data_type_set_value_owned (_tmp633_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp634_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp635_ = _tmp634_;
	result = !_tmp635_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp133_;
	ValaExpression* _tmp134_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			ValaExpression* _tmp62_;
			ValaExpression* _tmp63_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaTargetValue* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaLocalVariable* _tmp69_;
			ValaCodeNode* _tmp94_;
			ValaCodeNode* _tmp95_;
			if (instance) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				vala_code_node_emit ((ValaCodeNode*) _tmp61_, codegen);
			}
			_tmp62_ = vala_assignment_get_right (self);
			_tmp63_ = _tmp62_;
			vala_code_node_emit ((ValaCodeNode*) _tmp63_, codegen);
			_tmp64_ = vala_assignment_get_right (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_target_value (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _vala_target_value_ref0 (_tmp67_);
			new_value = _tmp68_;
			_tmp69_ = local;
			if (_tmp69_ != NULL) {
				ValaLocalVariable* _tmp70_;
				ValaTargetValue* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				_tmp70_ = local;
				_tmp71_ = new_value;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp73_ = _tmp72_;
				vala_code_generator_store_local (codegen, _tmp70_, _tmp71_, FALSE, _tmp73_);
			} else {
				ValaParameter* _tmp74_;
				_tmp74_ = param;
				if (_tmp74_ != NULL) {
					ValaParameter* _tmp75_;
					ValaTargetValue* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSourceReference* _tmp78_;
					_tmp75_ = param;
					_tmp76_ = new_value;
					_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp78_ = _tmp77_;
					vala_code_generator_store_parameter (codegen, _tmp75_, _tmp76_, FALSE, _tmp78_);
				} else {
					ValaField* _tmp79_;
					_tmp79_ = field;
					if (_tmp79_ != NULL) {
						ValaTargetValue* _tmp80_ = NULL;
						gboolean _tmp81_ = FALSE;
						ValaField* _tmp90_;
						ValaTargetValue* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						if (instance) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp81_ = _tmp84_ != NULL;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaTargetValue* _tmp88_;
							ValaTargetValue* _tmp89_;
							_tmp85_ = ma;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_target_value (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp80_ = _tmp89_;
						} else {
							_tmp80_ = NULL;
						}
						_tmp90_ = field;
						_tmp91_ = new_value;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp93_ = _tmp92_;
						vala_code_generator_store_field (codegen, _tmp90_, _tmp80_, _tmp91_, _tmp93_);
					}
				}
			}
			_tmp94_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp96_;
				_tmp96_ = local;
				if (_tmp96_ != NULL) {
					ValaLocalVariable* _tmp97_;
					ValaTargetValue* _tmp98_;
					ValaTargetValue* _tmp99_;
					_tmp97_ = local;
					_tmp98_ = vala_code_generator_load_local (codegen, _tmp97_);
					_tmp99_ = _tmp98_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp99_);
					_vala_target_value_unref0 (_tmp99_);
				} else {
					ValaParameter* _tmp100_;
					_tmp100_ = param;
					if (_tmp100_ != NULL) {
						ValaParameter* _tmp101_;
						ValaTargetValue* _tmp102_;
						ValaTargetValue* _tmp103_;
						_tmp101_ = param;
						_tmp102_ = vala_code_generator_load_parameter (codegen, _tmp101_);
						_tmp103_ = _tmp102_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp103_);
						_vala_target_value_unref0 (_tmp103_);
					} else {
						ValaField* _tmp104_;
						_tmp104_ = field;
						if (_tmp104_ != NULL) {
							ValaTargetValue* _tmp105_ = NULL;
							gboolean _tmp106_ = FALSE;
							ValaField* _tmp115_;
							ValaTargetValue* _tmp116_;
							ValaTargetValue* _tmp117_;
							if (instance) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp106_ = _tmp109_ != NULL;
							} else {
								_tmp106_ = FALSE;
							}
							if (_tmp106_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								ValaTargetValue* _tmp113_;
								ValaTargetValue* _tmp114_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = vala_expression_get_target_value (_tmp112_);
								_tmp114_ = _tmp113_;
								_tmp105_ = _tmp114_;
							} else {
								_tmp105_ = NULL;
							}
							_tmp115_ = field;
							_tmp116_ = vala_code_generator_load_field (codegen, _tmp115_, _tmp105_);
							_tmp117_ = _tmp116_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp117_);
							_vala_target_value_unref0 (_tmp117_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp120_;
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			_tmp120_ = ma;
			_tmp121_ = vala_member_access_get_inner (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp119_ = _tmp122_ != NULL;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaProperty* _tmp123_;
			_tmp123_ = property;
			_tmp118_ = _tmp123_ != NULL;
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			vala_code_node_emit ((ValaCodeNode*) _tmp126_, codegen);
		} else {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			if (_tmp127_ == NULL) {
				ValaMemberAccess* _tmp128_;
				_tmp128_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp128_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp129_;
		_tmp129_ = ea;
		if (_tmp129_ != NULL) {
			ValaElementAccess* _tmp130_;
			_tmp130_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaPointerIndirection* _tmp131_;
			_tmp131_ = pi;
			if (_tmp131_ != NULL) {
				ValaPointerIndirection* _tmp132_;
				_tmp132_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
	}
	_tmp133_ = vala_assignment_get_right (self);
	_tmp134_ = _tmp133_;
	vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

