/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean _tmp82_ = FALSE;
	ValaExpression* _tmp83_;
	ValaExpression* _tmp84_;
	ValaSemanticAnalyzer* _tmp203_;
	ValaSemanticAnalyzer* _tmp204_;
	ValaSymbol* _tmp205_;
	ValaSymbol* _tmp206_;
	ValaScope* _tmp207_;
	ValaScope* _tmp208_;
	const gchar* _tmp209_;
	const gchar* _tmp210_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp211_;
	ValaSemanticAnalyzer* _tmp212_;
	ValaSymbol* _tmp213_;
	ValaSymbol* _tmp214_;
	ValaBlock* _tmp215_;
	ValaBlock* _tmp216_;
	gboolean _tmp218_;
	gboolean _tmp219_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_REFERENCE_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp26_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp31_ = _tmp30_;
		vala_expression_set_target_type (_tmp29_, _tmp31_);
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_INITIALIZER_LIST)) {
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp34_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp37_ = _tmp36_;
			initializer_size = _tmp37_;
			is_initializer_list = TRUE;
		}
		_tmp38_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp39_ = _tmp38_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp39_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == NULL) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaExpression* _tmp52_;
		ValaExpression* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		ValaDataType* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		_tmp42_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		if (_tmp43_ == NULL) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp45_ = _tmp44_;
			vala_report_error (_tmp45_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			ValaSourceReference* _tmp50_;
			ValaSourceReference* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp51_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_expression_get_value_type (_tmp53_);
		_tmp55_ = _tmp54_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_FIELD_PROTOTYPE)) {
			ValaExpression* _tmp56_;
			ValaExpression* _tmp57_;
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaExpression* _tmp60_;
			ValaExpression* _tmp61_;
			ValaSymbol* _tmp62_;
			ValaSymbol* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp56_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_expression_get_symbol_reference (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_symbol_get_full_name (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp65_);
			_tmp67_ = _tmp66_;
			vala_report_error (_tmp59_, _tmp67_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
			result = FALSE;
			return result;
		}
		_tmp68_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_expression_get_value_type (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_data_type_copy (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp73_);
		_vala_code_node_unref0 (_tmp73_);
		_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp75_ = _tmp74_;
		vala_data_type_set_value_owned (_tmp75_, TRUE);
		_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp77_ = _tmp76_;
		vala_data_type_set_floating_reference (_tmp77_, FALSE);
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp81_ = _tmp80_;
		vala_expression_set_target_type (_tmp79_, _tmp81_);
	}
	_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaExpression* _tmp85_;
		ValaExpression* _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp88_;
		_tmp85_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_code_node_get_error ((ValaCodeNode*) _tmp86_);
		_tmp88_ = _tmp87_;
		_tmp82_ = !_tmp88_;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		ValaExpression* _tmp138_;
		ValaExpression* _tmp139_;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp158_;
		ValaDataType* _tmp159_;
		ValaArrayType* _tmp160_;
		gboolean _tmp161_ = FALSE;
		gboolean _tmp162_ = FALSE;
		gboolean _tmp163_ = FALSE;
		ValaArrayType* _tmp164_;
		gboolean _tmp178_ = FALSE;
		gboolean _tmp179_ = FALSE;
		ValaArrayType* _tmp180_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		ValaDataType* _tmp192_;
		ValaDataType* _tmp193_;
		_tmp89_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_expression_get_value_type (_tmp90_);
		_tmp92_ = _tmp91_;
		if (_tmp92_ == NULL) {
			gboolean _tmp93_ = FALSE;
			ValaExpression* _tmp94_;
			ValaExpression* _tmp95_;
			gboolean _tmp100_ = FALSE;
			ValaExpression* _tmp101_;
			ValaExpression* _tmp102_;
			ValaSymbol* _tmp103_;
			ValaSymbol* _tmp104_;
			_tmp94_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp95_ = _tmp94_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp96_;
				ValaExpression* _tmp97_;
				_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp97_ = _tmp96_;
				_tmp93_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_LAMBDA_EXPRESSION);
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaSourceReference* _tmp98_;
				ValaSourceReference* _tmp99_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp99_ = _tmp98_;
				vala_report_error (_tmp99_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp101_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_expression_get_symbol_reference (_tmp102_);
			_tmp104_ = _tmp103_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_METHOD)) {
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp106_ = _tmp105_;
				_tmp100_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_DELEGATE_TYPE);
			} else {
				_tmp100_ = FALSE;
			}
			if (_tmp100_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp107_;
				ValaExpression* _tmp108_;
				ValaSymbol* _tmp109_;
				ValaSymbol* _tmp110_;
				ValaMethod* _tmp111_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				ValaDelegateType* _tmp114_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp115_;
				ValaDelegate* _tmp116_;
				ValaDelegate* _tmp117_;
				ValaDelegate* _tmp118_;
				ValaDelegate* _tmp119_;
				ValaMethod* _tmp120_;
				ValaDelegateType* _tmp121_;
				ValaExpression* _tmp132_;
				ValaExpression* _tmp133_;
				ValaDataType* _tmp134_;
				ValaDataType* _tmp135_;
				_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp108_ = _tmp107_;
				_tmp109_ = vala_expression_get_symbol_reference (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp111_;
				_tmp112_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp113_ = _tmp112_;
				_tmp114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp114_;
				_tmp115_ = dt;
				_tmp116_ = vala_delegate_type_get_delegate_symbol (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				cb = _tmp118_;
				_tmp119_ = cb;
				_tmp120_ = m;
				_tmp121_ = dt;
				if (!vala_delegate_matches_method (_tmp119_, _tmp120_, (ValaDataType*) _tmp121_)) {
					ValaSourceReference* _tmp122_;
					ValaSourceReference* _tmp123_;
					ValaMethod* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					ValaDelegate* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp123_ = _tmp122_;
					_tmp124_ = m;
					_tmp125_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp124_);
					_tmp126_ = _tmp125_;
					_tmp127_ = cb;
					_tmp128_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp126_, _tmp129_);
					_tmp131_ = _tmp130_;
					vala_report_error (_tmp123_, _tmp131_);
					_g_free0 (_tmp131_);
					_g_free0 (_tmp129_);
					_g_free0 (_tmp126_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp135_ = _tmp134_;
				vala_expression_set_value_type (_tmp133_, _tmp135_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp136_;
				ValaSourceReference* _tmp137_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp137_ = _tmp136_;
				vala_report_error (_tmp137_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp138_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_expression_get_value_type (_tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp143_ = _tmp142_;
		if (!vala_data_type_compatible (_tmp141_, _tmp143_)) {
			ValaSourceReference* _tmp144_;
			ValaSourceReference* _tmp145_;
			ValaExpression* _tmp146_;
			ValaExpression* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_expression_get_value_type (_tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_code_node_to_string ((ValaCodeNode*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_code_node_to_string ((ValaCodeNode*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp151_, _tmp155_);
			_tmp157_ = _tmp156_;
			vala_report_error (_tmp145_, _tmp157_);
			_g_free0 (_tmp157_);
			_g_free0 (_tmp155_);
			_g_free0 (_tmp151_);
			result = FALSE;
			return result;
		}
		_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp159_) : NULL);
		variable_array_type = _tmp160_;
		_tmp164_ = variable_array_type;
		if (_tmp164_ != NULL) {
			ValaArrayType* _tmp165_;
			gboolean _tmp166_;
			gboolean _tmp167_;
			_tmp165_ = variable_array_type;
			_tmp166_ = vala_array_type_get_inline_allocated (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp163_ = _tmp167_;
		} else {
			_tmp163_ = FALSE;
		}
		if (_tmp163_) {
			ValaArrayType* _tmp168_;
			gboolean _tmp169_;
			gboolean _tmp170_;
			_tmp168_ = variable_array_type;
			_tmp169_ = vala_array_type_get_fixed_length (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp162_ = !_tmp170_;
		} else {
			_tmp162_ = FALSE;
		}
		if (_tmp162_) {
			_tmp161_ = is_initializer_list;
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			ValaArrayType* _tmp171_;
			gchar* _tmp172_;
			gchar* _tmp173_;
			ValaIntegerLiteral* _tmp174_;
			ValaIntegerLiteral* _tmp175_;
			ValaArrayType* _tmp176_;
			ValaArrayType* _tmp177_;
			_tmp171_ = variable_array_type;
			_tmp172_ = g_strdup_printf ("%i", initializer_size);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_integer_literal_new (_tmp173_, NULL);
			_tmp175_ = _tmp174_;
			vala_array_type_set_length (_tmp171_, (ValaExpression*) _tmp175_);
			_vala_code_node_unref0 (_tmp175_);
			_g_free0 (_tmp173_);
			_tmp176_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp176_, TRUE);
			_tmp177_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp177_, FALSE);
		}
		_tmp180_ = variable_array_type;
		if (_tmp180_ != NULL) {
			ValaArrayType* _tmp181_;
			gboolean _tmp182_;
			gboolean _tmp183_;
			_tmp181_ = variable_array_type;
			_tmp182_ = vala_array_type_get_inline_allocated (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp179_ = _tmp183_;
		} else {
			_tmp179_ = FALSE;
		}
		if (_tmp179_) {
			ValaExpression* _tmp184_;
			ValaExpression* _tmp185_;
			ValaDataType* _tmp186_;
			ValaDataType* _tmp187_;
			_tmp184_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_expression_get_value_type (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp178_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp187_, VALA_TYPE_ARRAY_TYPE) == FALSE;
		} else {
			_tmp178_ = FALSE;
		}
		if (_tmp178_) {
			ValaSourceReference* _tmp188_;
			ValaSourceReference* _tmp189_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp189_ = _tmp188_;
			vala_report_error (_tmp189_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (variable_array_type);
			return result;
		}
		_tmp190_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp191_ = _tmp190_;
		_tmp192_ = vala_expression_get_value_type (_tmp191_);
		_tmp193_ = _tmp192_;
		if (vala_data_type_is_disposable (_tmp193_)) {
			gboolean _tmp194_ = FALSE;
			ValaDataType* _tmp195_;
			ValaDataType* _tmp196_;
			_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp196_ = _tmp195_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp196_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp197_;
				ValaDataType* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp197_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_data_type_get_value_owned (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp194_ = !_tmp200_;
			} else {
				_tmp194_ = FALSE;
			}
			if (_tmp194_) {
				ValaSourceReference* _tmp201_;
				ValaSourceReference* _tmp202_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp202_ = _tmp201_;
				vala_report_error (_tmp202_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (variable_array_type);
				return result;
			}
		}
		_vala_code_node_unref0 (variable_array_type);
	}
	_tmp203_ = vala_code_context_get_analyzer (context);
	_tmp204_ = _tmp203_;
	_tmp205_ = vala_semantic_analyzer_get_current_symbol (_tmp204_);
	_tmp206_ = _tmp205_;
	_tmp207_ = vala_symbol_get_scope (_tmp206_);
	_tmp208_ = _tmp207_;
	_tmp209_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp210_ = _tmp209_;
	vala_scope_add (_tmp208_, _tmp210_, (ValaSymbol*) self);
	_tmp211_ = vala_code_context_get_analyzer (context);
	_tmp212_ = _tmp211_;
	_tmp213_ = vala_semantic_analyzer_get_current_symbol (_tmp212_);
	_tmp214_ = _tmp213_;
	_tmp215_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp214_) : NULL);
	block = _tmp215_;
	_tmp216_ = block;
	if (_tmp216_ != NULL) {
		ValaBlock* _tmp217_;
		_tmp217_ = block;
		vala_block_add_local_variable (_tmp217_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp218_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp219_ = _tmp218_;
	result = !_tmp219_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

