/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp315_ = FALSE;
	ValaMethod* _tmp316_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp479_;
	ValaCCodeExpression* _tmp480_;
	ValaMethod* _tmp481_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp505_ = FALSE;
	ValaMethod* _tmp506_;
	gboolean _tmp660_ = FALSE;
	ValaMethod* _tmp661_;
	ValaMethod* _tmp698_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp880_;
	ValaIterator* _tmp881_;
	ValaIterator* _tmp1253_;
	gboolean _tmp1263_ = FALSE;
	gboolean _tmp1264_ = FALSE;
	ValaMethod* _tmp1265_;
	gboolean _tmp1387_ = FALSE;
	ValaDelegate* _tmp1388_;
	gboolean _tmp1485_ = FALSE;
	ValaMethod* _tmp1486_;
	gboolean _tmp1502_;
	gboolean _tmp1503_;
	ValaDataType* _tmp1542_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1566_;
	ValaDataType* _tmp1567_;
	ValaDataType* _tmp1568_;
	gboolean _tmp1569_;
	gboolean _tmp1570_ = FALSE;
	ValaDataType* _tmp1571_;
	ValaCCodeFunctionCall* _tmp1600_;
	ValaCCodeFunctionCall* _tmp1601_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1616_;
	ValaCCodeFunctionCall* _tmp1617_;
	ValaCCodeFunctionCall* _tmp1632_;
	gboolean _tmp1647_;
	gboolean _tmp1648_;
	gboolean _tmp1672_;
	gboolean _tmp1673_;
	gboolean _tmp1708_ = FALSE;
	gboolean _tmp1709_ = FALSE;
	ValaMethod* _tmp1710_;
	gboolean _tmp1748_ = FALSE;
	gboolean _tmp1749_ = FALSE;
	ValaMethod* _tmp1750_;
	ValaMethod* _tmp1769_;
	gboolean _tmp1886_ = FALSE;
	ValaCodeNode* _tmp1887_;
	ValaCodeNode* _tmp1888_;
	ValaList* _tmp1961_;
	ValaIterator* _tmp1962_;
	gboolean _tmp2036_ = FALSE;
	gboolean _tmp2037_ = FALSE;
	ValaMethod* _tmp2038_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp265_ = FALSE;
		ValaMemberAccess* _tmp266_;
		const gchar* _tmp267_;
		const gchar* _tmp268_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeFunctionCall* _tmp215_;
				ValaCCodeFunctionCall* _tmp216_;
				ValaMethod* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				ValaCCodeMemberAccess* _tmp220_;
				ValaCCodeMemberAccess* _tmp221_;
				ValaCCodeFunctionCall* _tmp222_;
				ValaCCodeFunctionCall* _tmp223_;
				ValaMethod* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				ValaCCodeMemberAccess* _tmp227_;
				ValaCCodeMemberAccess* _tmp228_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_class_type_function (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_ccode_identifier_new (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
				_tmp205_ = _tmp204_;
				_vala_ccode_node_unref0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp205_;
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
				_tmp215_ = async_call;
				_tmp216_ = vcast;
				_tmp217_ = m;
				_tmp218_ = vala_get_ccode_vfunc_name (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp216_, _tmp219_);
				_tmp221_ = _tmp220_;
				vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp221_);
				_vala_ccode_node_unref0 (_tmp221_);
				_g_free0 (_tmp219_);
				_tmp222_ = finish_call;
				_tmp223_ = vcast;
				_tmp224_ = m;
				_tmp225_ = vala_get_ccode_finish_vfunc_name (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp223_, _tmp226_);
				_tmp228_ = _tmp227_;
				vala_ccode_function_call_set_call (_tmp222_, (ValaCCodeExpression*) _tmp228_);
				_vala_ccode_node_unref0 (_tmp228_);
				_g_free0 (_tmp226_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp229_;
				ValaMethod* _tmp230_;
				ValaMethod* _tmp231_;
				_tmp229_ = m;
				_tmp230_ = vala_method_get_base_interface_method (_tmp229_);
				_tmp231_ = _tmp230_;
				if (_tmp231_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp232_;
					ValaMethod* _tmp233_;
					ValaMethod* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaInterface* _tmp237_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp238_;
					ValaClass* _tmp239_;
					gchar* _tmp240_;
					gchar* _tmp241_;
					ValaInterface* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					ValaCCodeFunctionCall* _tmp247_;
					const gchar* _tmp248_;
					ValaCCodeIdentifier* _tmp249_;
					ValaCCodeIdentifier* _tmp250_;
					ValaMethod* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					ValaCCodeFunctionCall* _tmp256_;
					const gchar* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaMethod* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					ValaCCodeMemberAccess* _tmp263_;
					ValaCCodeMemberAccess* _tmp264_;
					_tmp232_ = m;
					_tmp233_ = vala_method_get_base_interface_method (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp237_;
					_tmp238_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp239_, NULL);
					_tmp241_ = _tmp240_;
					_tmp242_ = base_iface;
					_tmp243_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp242_, NULL);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("%s_%s_parent_iface", _tmp241_, _tmp244_);
					_tmp246_ = _tmp245_;
					_g_free0 (_tmp244_);
					_g_free0 (_tmp241_);
					parent_iface_var = _tmp246_;
					_tmp247_ = async_call;
					_tmp248_ = parent_iface_var;
					_tmp249_ = vala_ccode_identifier_new (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = m;
					_tmp252_ = vala_get_ccode_vfunc_name (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp250_, _tmp253_);
					_tmp255_ = _tmp254_;
					vala_ccode_function_call_set_call (_tmp247_, (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_g_free0 (_tmp253_);
					_vala_ccode_node_unref0 (_tmp250_);
					_tmp256_ = finish_call;
					_tmp257_ = parent_iface_var;
					_tmp258_ = vala_ccode_identifier_new (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = m;
					_tmp261_ = vala_get_ccode_finish_vfunc_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp259_, _tmp262_);
					_tmp264_ = _tmp263_;
					vala_ccode_function_call_set_call (_tmp256_, (ValaCCodeExpression*) _tmp264_);
					_vala_ccode_node_unref0 (_tmp264_);
					_g_free0 (_tmp262_);
					_vala_ccode_node_unref0 (_tmp259_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp266_ = ma;
		_tmp267_ = vala_member_access_get_member_name (_tmp266_);
		_tmp268_ = _tmp267_;
		if (g_strcmp0 (_tmp268_, "begin") == 0) {
			ValaMemberAccess* _tmp269_;
			ValaExpression* _tmp270_;
			ValaExpression* _tmp271_;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			ValaMemberAccess* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			_tmp269_ = ma;
			_tmp270_ = vala_member_access_get_inner (_tmp269_);
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_expression_get_symbol_reference (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = ma;
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp265_ = _tmp273_ == _tmp276_;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaMethod* _tmp279_;
			ValaList* _tmp280_;
			_tmp277_ = async_call;
			_tmp278_ = _vala_ccode_node_ref0 (_tmp277_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp278_;
			_tmp279_ = m;
			_tmp280_ = vala_method_get_async_begin_parameters (_tmp279_);
			_vala_iterable_unref0 (params);
			params = _tmp280_;
		} else {
			gboolean _tmp281_ = FALSE;
			ValaMemberAccess* _tmp282_;
			const gchar* _tmp283_;
			const gchar* _tmp284_;
			_tmp282_ = ma;
			_tmp283_ = vala_member_access_get_member_name (_tmp282_);
			_tmp284_ = _tmp283_;
			if (g_strcmp0 (_tmp284_, "end") == 0) {
				ValaMemberAccess* _tmp285_;
				ValaExpression* _tmp286_;
				ValaExpression* _tmp287_;
				ValaSymbol* _tmp288_;
				ValaSymbol* _tmp289_;
				ValaMemberAccess* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaSymbol* _tmp292_;
				_tmp285_ = ma;
				_tmp286_ = vala_member_access_get_inner (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_expression_get_symbol_reference (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = ma;
				_tmp291_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp281_ = _tmp289_ == _tmp292_;
			} else {
				_tmp281_ = FALSE;
			}
			if (_tmp281_) {
				ValaCCodeFunctionCall* _tmp293_;
				ValaCCodeFunctionCall* _tmp294_;
				ValaMethod* _tmp295_;
				ValaList* _tmp296_;
				_tmp293_ = finish_call;
				_tmp294_ = _vala_ccode_node_ref0 (_tmp293_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp294_;
				_tmp295_ = m;
				_tmp296_ = vala_method_get_async_end_parameters (_tmp295_);
				_vala_iterable_unref0 (params);
				params = _tmp296_;
			} else {
				gboolean _tmp297_;
				gboolean _tmp298_;
				_tmp297_ = vala_method_call_get_is_yield_expression (expr);
				_tmp298_ = _tmp297_;
				if (!_tmp298_) {
					ValaCCodeFunctionCall* _tmp299_;
					ValaCCodeFunctionCall* _tmp300_;
					ValaMethod* _tmp301_;
					ValaList* _tmp302_;
					_tmp299_ = async_call;
					_tmp300_ = _vala_ccode_node_ref0 (_tmp299_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp300_;
					_tmp301_ = m;
					_tmp302_ = vala_method_get_async_begin_parameters (_tmp301_);
					_vala_iterable_unref0 (params);
					params = _tmp302_;
				} else {
					ValaCCodeFunctionCall* _tmp303_;
					ValaCCodeFunctionCall* _tmp304_;
					GHashFunc _tmp305_;
					GEqualFunc _tmp306_;
					GEqualFunc _tmp307_;
					ValaHashMap* _tmp308_;
					ValaHashMap* _tmp309_;
					ValaMethod* _tmp310_;
					ValaCCodeIdentifier* _tmp311_;
					ValaCCodeIdentifier* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					ValaCCodeMemberAccess* _tmp314_;
					_tmp303_ = finish_call;
					_tmp304_ = _vala_ccode_node_ref0 (_tmp303_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp304_;
					_tmp305_ = g_direct_hash;
					_tmp306_ = g_direct_equal;
					_tmp307_ = g_direct_equal;
					_tmp308_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp305_, _tmp306_, _tmp307_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp308_;
					_tmp309_ = out_arg_map;
					_tmp310_ = m;
					_tmp311_ = vala_ccode_identifier_new ("_data_");
					_tmp312_ = _tmp311_;
					_tmp313_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp312_, "_res_");
					_tmp314_ = _tmp313_;
					vala_map_set ((ValaMap*) _tmp309_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp310_), FALSE)), (ValaCCodeExpression*) _tmp314_);
					_vala_ccode_node_unref0 (_tmp314_);
					_vala_ccode_node_unref0 (_tmp312_);
				}
			}
		}
	}
	_tmp316_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp317_;
		ValaSymbol* _tmp318_;
		ValaSymbol* _tmp319_;
		_tmp317_ = m;
		_tmp318_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp315_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		ValaCodeContext* _tmp320_;
		ValaCodeContext* _tmp321_;
		ValaProfile _tmp322_;
		ValaProfile _tmp323_;
		ValaClass* _tmp335_;
		ValaClass* _tmp336_;
		gboolean _tmp337_;
		gboolean _tmp338_;
		_tmp320_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_context_get_profile (_tmp321_);
		_tmp323_ = _tmp322_;
		if (_tmp323_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp324_;
			ValaSymbol* _tmp325_;
			ValaSymbol* _tmp326_;
			gboolean _tmp327_;
			gboolean _tmp328_;
			_tmp324_ = m;
			_tmp325_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp324_);
			_tmp326_ = _tmp325_;
			_tmp327_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
			_tmp328_ = _tmp327_;
			if (!_tmp328_) {
				ValaCCodeFunctionCall* _tmp329_;
				ValaCCodeExpression* _tmp330_;
				ValaCCodeExpression* _tmp331_;
				_tmp329_ = ccall;
				_tmp330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp331_ = _tmp330_;
				vala_ccode_function_call_add_argument (_tmp329_, _tmp331_);
				_vala_ccode_node_unref0 (_tmp331_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp332_;
			ValaCCodeExpression* _tmp333_;
			ValaCCodeExpression* _tmp334_;
			_tmp332_ = ccall;
			_tmp333_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp334_ = _tmp333_;
			vala_ccode_function_call_add_argument (_tmp332_, _tmp334_);
			_vala_ccode_node_unref0 (_tmp334_);
		}
		_tmp335_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_class_get_is_compact (_tmp336_);
		_tmp338_ = _tmp337_;
		if (!_tmp338_) {
			ValaClass* _tmp339_;
			ValaClass* _tmp340_;
			ValaMethod* _tmp341_;
			ValaSymbol* _tmp342_;
			ValaSymbol* _tmp343_;
			_tmp339_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp340_ = _tmp339_;
			_tmp341_ = m;
			_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
			_tmp343_ = _tmp342_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp340_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp343_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp344_;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _base_type_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _base_type_index = 0;
					_tmp344_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_class_get_base_types (_tmp345_);
					_base_type_list = _tmp346_;
					_tmp347_ = _base_type_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_base_type_size = _tmp349_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaDataType* _tmp352_;
						ValaTypeSymbol* _tmp353_;
						ValaTypeSymbol* _tmp354_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp350_ = _base_type_list;
						_tmp351_ = vala_list_get (_tmp350_, _base_type_index);
						base_type = (ValaDataType*) _tmp351_;
						_tmp352_ = base_type;
						_tmp353_ = vala_data_type_get_data_type (_tmp352_);
						_tmp354_ = _tmp353_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp355_;
							gchar* _tmp356_;
							gchar* _tmp357_;
							gboolean _tmp358_;
							ValaHashMap* _tmp363_;
							ValaDataType* _tmp364_;
							ValaList* _tmp365_;
							ValaList* _tmp366_;
							ValaList* _tmp367_;
							type_parameters = NULL;
							_tmp355_ = m;
							_tmp356_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = g_strcmp0 (_tmp357_, "g_object_new") == 0;
							_g_free0 (_tmp357_);
							if (_tmp358_) {
								ValaDataType* _tmp359_;
								ValaTypeSymbol* _tmp360_;
								ValaTypeSymbol* _tmp361_;
								ValaList* _tmp362_;
								_tmp359_ = base_type;
								_tmp360_ = vala_data_type_get_data_type (_tmp359_);
								_tmp361_ = _tmp360_;
								_tmp362_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp362_;
							}
							_tmp363_ = in_arg_map;
							_tmp364_ = base_type;
							_tmp365_ = vala_data_type_get_type_arguments (_tmp364_);
							_tmp366_ = _tmp365_;
							_tmp367_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp363_, _tmp366_, (ValaCodeNode*) expr, TRUE, _tmp367_);
							_vala_iterable_unref0 (_tmp366_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp368_;
				ValaSymbol* _tmp369_;
				ValaSymbol* _tmp370_;
				ValaClass* _tmp371_;
				type_param_index = 0;
				_tmp368_ = m;
				_tmp369_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp368_);
				_tmp370_ = _tmp369_;
				_tmp371_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp370_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp371_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp372_;
					ValaList* _tmp373_;
					gint _type_param_size = 0;
					ValaList* _tmp374_;
					gint _tmp375_;
					gint _tmp376_;
					gint _type_param_index = 0;
					_tmp372_ = cl;
					_tmp373_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp372_);
					_type_param_list = _tmp373_;
					_tmp374_ = _type_param_list;
					_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
					_tmp376_ = _tmp375_;
					_type_param_size = _tmp376_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp377_;
						gpointer _tmp378_;
						ValaHashMap* _tmp379_;
						ValaTypeParameter* _tmp380_;
						const gchar* _tmp381_;
						const gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						gchar* _tmp385_;
						gchar* _tmp386_;
						ValaCCodeIdentifier* _tmp387_;
						ValaCCodeIdentifier* _tmp388_;
						ValaHashMap* _tmp389_;
						ValaTypeParameter* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						gchar* _tmp396_;
						ValaCCodeIdentifier* _tmp397_;
						ValaCCodeIdentifier* _tmp398_;
						ValaHashMap* _tmp399_;
						ValaTypeParameter* _tmp400_;
						const gchar* _tmp401_;
						const gchar* _tmp402_;
						gchar* _tmp403_;
						gchar* _tmp404_;
						gchar* _tmp405_;
						gchar* _tmp406_;
						ValaCCodeIdentifier* _tmp407_;
						ValaCCodeIdentifier* _tmp408_;
						gint _tmp409_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp377_ = _type_param_list;
						_tmp378_ = vala_list_get (_tmp377_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp378_;
						_tmp379_ = in_arg_map;
						_tmp380_ = type_param;
						_tmp381_ = vala_symbol_get_name ((ValaSymbol*) _tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = g_utf8_strdown (_tmp382_, (gssize) -1);
						_tmp384_ = _tmp383_;
						_tmp385_ = g_strdup_printf ("%s_type", _tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_ccode_identifier_new (_tmp386_);
						_tmp388_ = _tmp387_;
						vala_map_set ((ValaMap*) _tmp379_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp388_);
						_vala_ccode_node_unref0 (_tmp388_);
						_g_free0 (_tmp386_);
						_g_free0 (_tmp384_);
						_tmp389_ = in_arg_map;
						_tmp390_ = type_param;
						_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = g_utf8_strdown (_tmp392_, (gssize) -1);
						_tmp394_ = _tmp393_;
						_tmp395_ = g_strdup_printf ("%s_dup_func", _tmp394_);
						_tmp396_ = _tmp395_;
						_tmp397_ = vala_ccode_identifier_new (_tmp396_);
						_tmp398_ = _tmp397_;
						vala_map_set ((ValaMap*) _tmp389_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp398_);
						_vala_ccode_node_unref0 (_tmp398_);
						_g_free0 (_tmp396_);
						_g_free0 (_tmp394_);
						_tmp399_ = in_arg_map;
						_tmp400_ = type_param;
						_tmp401_ = vala_symbol_get_name ((ValaSymbol*) _tmp400_);
						_tmp402_ = _tmp401_;
						_tmp403_ = g_utf8_strdown (_tmp402_, (gssize) -1);
						_tmp404_ = _tmp403_;
						_tmp405_ = g_strdup_printf ("%s_destroy_func", _tmp404_);
						_tmp406_ = _tmp405_;
						_tmp407_ = vala_ccode_identifier_new (_tmp406_);
						_tmp408_ = _tmp407_;
						vala_map_set ((ValaMap*) _tmp399_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp408_);
						_vala_ccode_node_unref0 (_tmp408_);
						_g_free0 (_tmp406_);
						_g_free0 (_tmp404_);
						_tmp409_ = type_param_index;
						type_param_index = _tmp409_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp410_;
			ValaClass* _tmp411_;
			ValaClass* _tmp412_;
			ValaClass* _tmp413_;
			ValaClass* _tmp414_;
			_tmp410_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp411_ = _tmp410_;
			_tmp412_ = vala_class_get_base_class (_tmp411_);
			_tmp413_ = _tmp412_;
			_tmp414_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp413_ == _tmp414_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp415_;
				ValaClass* _tmp416_;
				gchar* _tmp417_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp418_;
				ValaCCodeDeclaration* _tmp419_;
				ValaCCodeDeclaration* _tmp420_;
				const gchar* _tmp421_;
				const gchar* _tmp422_;
				const gchar* _tmp423_;
				const gchar* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeConstant* _tmp427_;
				ValaCCodeConstant* _tmp428_;
				ValaCCodeVariableDeclarator* _tmp429_;
				ValaCCodeVariableDeclarator* _tmp430_;
				ValaCCodeFunction* _tmp431_;
				ValaCCodeFunction* _tmp432_;
				ValaCCodeDeclaration* _tmp433_;
				ValaCCodeFunctionCall* _tmp434_;
				ValaCCodeIdentifier* _tmp435_;
				ValaCCodeIdentifier* _tmp436_;
				ValaCCodeUnaryExpression* _tmp437_;
				ValaCCodeUnaryExpression* _tmp438_;
				ValaCCodeCastExpression* _tmp439_;
				ValaCCodeCastExpression* _tmp440_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp441_;
				ValaCCodeIdentifier* _tmp442_;
				ValaCCodeFunctionCall* _tmp443_;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				ValaClass* _tmp446_;
				ValaClass* _tmp447_;
				gchar* _tmp448_;
				gchar* _tmp449_;
				ValaCCodeIdentifier* _tmp450_;
				ValaCCodeIdentifier* _tmp451_;
				ValaCCodeFunctionCall* _tmp452_;
				ValaCCodeFunctionCall* _tmp453_;
				_tmp415_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp416_, NULL);
				class_prefix = _tmp417_;
				_tmp418_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp418_;
				_tmp419_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp419_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp420_ = funcs;
				_tmp421_ = class_prefix;
				_tmp422_ = class_prefix;
				_tmp423_ = class_prefix;
				_tmp424_ = class_prefix;
				_tmp425_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp421_, _tmp422_, _tmp423_, _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_constant_new (_tmp426_);
				_tmp428_ = _tmp427_;
				_tmp429_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp428_, NULL);
				_tmp430_ = _tmp429_;
				vala_ccode_declaration_add_declarator (_tmp420_, (ValaCCodeDeclarator*) _tmp430_);
				_vala_ccode_node_unref0 (_tmp430_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp431_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp432_ = _tmp431_;
				_tmp433_ = funcs;
				vala_ccode_function_add_statement (_tmp432_, (ValaCCodeNode*) _tmp433_);
				_tmp434_ = ccall;
				_tmp435_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp436_ = _tmp435_;
				_tmp437_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp438_, "GSourceFuncs *");
				_tmp440_ = _tmp439_;
				vala_ccode_function_call_add_argument (_tmp434_, (ValaCCodeExpression*) _tmp440_);
				_vala_ccode_node_unref0 (_tmp440_);
				_vala_ccode_node_unref0 (_tmp438_);
				_vala_ccode_node_unref0 (_tmp436_);
				_tmp441_ = vala_ccode_identifier_new ("sizeof");
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp442_);
				_tmp444_ = _tmp443_;
				_vala_ccode_node_unref0 (_tmp442_);
				csizeof = _tmp444_;
				_tmp445_ = csizeof;
				_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_get_ccode_name ((ValaCodeNode*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_ccode_identifier_new (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_function_call_add_argument (_tmp445_, (ValaCCodeExpression*) _tmp451_);
				_vala_ccode_node_unref0 (_tmp451_);
				_g_free0 (_tmp449_);
				_tmp452_ = ccall;
				_tmp453_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp452_, (ValaCCodeExpression*) _tmp453_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp454_ = FALSE;
		ValaMethod* _tmp455_;
		_tmp455_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp455_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp456_;
			ValaSymbol* _tmp457_;
			ValaSymbol* _tmp458_;
			_tmp456_ = m;
			_tmp457_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp456_);
			_tmp458_ = _tmp457_;
			_tmp454_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_STRUCT);
		} else {
			_tmp454_ = FALSE;
		}
		if (_tmp454_) {
			ValaCCodeFunctionCall* _tmp459_;
			ValaCCodeExpression* _tmp460_;
			ValaCCodeExpression* _tmp461_;
			_tmp459_ = ccall;
			_tmp460_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp461_ = _tmp460_;
			vala_ccode_function_call_add_argument (_tmp459_, _tmp461_);
			_vala_ccode_node_unref0 (_tmp461_);
		} else {
			gboolean _tmp462_ = FALSE;
			gboolean _tmp463_ = FALSE;
			gboolean _tmp464_ = FALSE;
			gboolean _tmp465_ = FALSE;
			ValaMethod* _tmp466_;
			_tmp466_ = m;
			if (_tmp466_ != NULL) {
				ValaMethod* _tmp467_;
				_tmp467_ = m;
				_tmp465_ = vala_method_has_type_parameters (_tmp467_);
			} else {
				_tmp465_ = FALSE;
			}
			if (_tmp465_) {
				ValaMethod* _tmp468_;
				_tmp468_ = m;
				_tmp464_ = !vala_get_ccode_has_generic_type_parameter (_tmp468_);
			} else {
				_tmp464_ = FALSE;
			}
			if (_tmp464_) {
				ValaMethod* _tmp469_;
				_tmp469_ = m;
				_tmp463_ = !vala_get_ccode_simple_generics (_tmp469_);
			} else {
				_tmp463_ = FALSE;
			}
			if (_tmp463_) {
				gboolean _tmp470_ = FALSE;
				ValaCCodeFunctionCall* _tmp471_;
				ValaCCodeFunctionCall* _tmp472_;
				_tmp471_ = ccall;
				_tmp472_ = finish_call;
				if (_tmp471_ != _tmp472_) {
					_tmp470_ = TRUE;
				} else {
					gboolean _tmp473_;
					gboolean _tmp474_;
					_tmp473_ = vala_method_call_get_is_yield_expression (expr);
					_tmp474_ = _tmp473_;
					_tmp470_ = _tmp474_;
				}
				_tmp462_ = _tmp470_;
			} else {
				_tmp462_ = FALSE;
			}
			if (_tmp462_) {
				ValaHashMap* _tmp475_;
				ValaMemberAccess* _tmp476_;
				ValaList* _tmp477_;
				ValaList* _tmp478_;
				_tmp475_ = in_arg_map;
				_tmp476_ = ma;
				_tmp477_ = vala_member_access_get_type_arguments (_tmp476_);
				_tmp478_ = _tmp477_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp475_, _tmp478_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp478_);
			}
		}
	}
	_tmp479_ = ccall;
	_tmp480_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp479_);
	ccall_expr = _tmp480_;
	_tmp481_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp482_;
		ValaExpression* _tmp483_;
		ValaExpression* _tmp484_;
		ValaDataType* _tmp485_;
		ValaDataType* _tmp486_;
		ValaArrayType* _tmp487_;
		ValaHashMap* _tmp488_;
		ValaArrayType* _tmp489_;
		ValaDataType* _tmp490_;
		ValaDataType* _tmp491_;
		gchar* _tmp492_;
		gchar* _tmp493_;
		ValaCCodeIdentifier* _tmp494_;
		ValaCCodeIdentifier* _tmp495_;
		_tmp482_ = ma;
		_tmp483_ = vala_member_access_get_inner (_tmp482_);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_expression_get_value_type (_tmp484_);
		_tmp486_ = _tmp485_;
		_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp487_;
		_tmp488_ = in_arg_map;
		_tmp489_ = array_type;
		_tmp490_ = vala_array_type_get_element_type (_tmp489_);
		_tmp491_ = _tmp490_;
		_tmp492_ = vala_get_ccode_name ((ValaCodeNode*) _tmp491_);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_ccode_identifier_new (_tmp493_);
		_tmp495_ = _tmp494_;
		vala_map_set ((ValaMap*) _tmp488_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp495_);
		_vala_ccode_node_unref0 (_tmp495_);
		_g_free0 (_tmp493_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp496_;
		_tmp496_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp496_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp497_;
			_tmp497_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp498_;
				ValaExpression* _tmp499_;
				ValaExpression* _tmp500_;
				ValaTargetValue* _tmp501_;
				ValaTargetValue* _tmp502_;
				ValaTargetValue* _tmp503_;
				ValaTargetValue* _tmp504_;
				_tmp498_ = ma;
				_tmp499_ = vala_member_access_get_inner (_tmp498_);
				_tmp500_ = _tmp499_;
				_tmp501_ = vala_expression_get_target_value (_tmp500_);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp502_, (ValaCodeNode*) expr);
				_tmp504_ = _tmp503_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp504_);
				_vala_target_value_unref0 (_tmp504_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp506_ = m;
	if (_tmp506_ != NULL) {
		ValaMethod* _tmp507_;
		gboolean _tmp508_;
		gboolean _tmp509_;
		_tmp507_ = m;
		_tmp508_ = vala_method_get_is_async_callback (_tmp507_);
		_tmp509_ = _tmp508_;
		_tmp505_ = _tmp509_;
	} else {
		_tmp505_ = FALSE;
	}
	if (_tmp505_) {
		ValaMethod* _tmp510_;
		ValaMethod* _tmp511_;
		gboolean _tmp512_;
		gboolean _tmp513_;
		ValaHashMap* _tmp527_;
		ValaMethod* _tmp528_;
		ValaCCodeExpression* _tmp529_;
		ValaHashMap* _tmp530_;
		ValaMethod* _tmp531_;
		ValaCCodeExpression* _tmp532_;
		_tmp510_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp511_ = _tmp510_;
		_tmp512_ = vala_method_get_closure (_tmp511_);
		_tmp513_ = _tmp512_;
		if (_tmp513_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp514_;
			ValaSymbol* _tmp515_;
			ValaSymbol* _tmp516_;
			ValaBlock* _tmp517_;
			ValaBlock* _tmp518_;
			ValaBlock* _tmp519_;
			ValaBlock* _tmp520_;
			gchar* _tmp521_;
			gchar* _tmp522_;
			ValaCCodeExpression* _tmp523_;
			ValaCCodeExpression* _tmp524_;
			ValaCCodeMemberAccess* _tmp525_;
			_tmp514_ = m;
			_tmp515_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp514_);
			_tmp516_ = _tmp515_;
			_tmp517_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_METHOD, ValaMethod));
			_tmp518_ = _tmp517_;
			_tmp519_ = _vala_code_node_ref0 (_tmp518_);
			block = _tmp519_;
			_tmp520_ = block;
			_tmp521_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp520_));
			_tmp522_ = _tmp521_;
			_tmp523_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_ccode_member_access_new_pointer (_tmp524_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp525_;
			_vala_ccode_node_unref0 (_tmp524_);
			_g_free0 (_tmp522_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp526_;
			_tmp526_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp526_;
		}
		_tmp527_ = in_arg_map;
		_tmp528_ = m;
		_tmp529_ = instance;
		vala_map_set ((ValaMap*) _tmp527_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp528_), FALSE)), _tmp529_);
		_tmp530_ = out_arg_map;
		_tmp531_ = m;
		_tmp532_ = instance;
		vala_map_set ((ValaMap*) _tmp530_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp531_), FALSE)), _tmp532_);
	} else {
		gboolean _tmp533_ = FALSE;
		gboolean _tmp534_ = FALSE;
		ValaMethod* _tmp535_;
		_tmp535_ = m;
		if (_tmp535_ != NULL) {
			ValaMethod* _tmp536_;
			ValaMemberBinding _tmp537_;
			ValaMemberBinding _tmp538_;
			_tmp536_ = m;
			_tmp537_ = vala_method_get_binding (_tmp536_);
			_tmp538_ = _tmp537_;
			_tmp534_ = _tmp538_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp534_ = FALSE;
		}
		if (_tmp534_) {
			ValaMethod* _tmp539_;
			_tmp539_ = m;
			_tmp533_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp539_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp533_ = FALSE;
		}
		if (_tmp533_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp540_;
			ValaExpression* _tmp541_;
			ValaExpression* _tmp542_;
			ValaTargetValue* _tmp543_;
			ValaTargetValue* _tmp544_;
			ValaTargetValue* _tmp545_;
			gboolean _tmp546_ = FALSE;
			gboolean _tmp547_ = FALSE;
			ValaMemberAccess* _tmp548_;
			const gchar* _tmp549_;
			const gchar* _tmp550_;
			ValaTargetValue* _tmp572_;
			ValaCCodeExpression* _tmp573_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp574_;
			ValaSymbol* _tmp575_;
			ValaSymbol* _tmp576_;
			ValaStruct* _tmp577_;
			gboolean _tmp578_ = FALSE;
			ValaStruct* _tmp579_;
			gboolean _tmp588_;
			gboolean _tmp589_;
			_tmp540_ = ma;
			_tmp541_ = vala_member_access_get_inner (_tmp540_);
			_tmp542_ = _tmp541_;
			_tmp543_ = vala_expression_get_target_value (_tmp542_);
			_tmp544_ = _tmp543_;
			_tmp545_ = _vala_target_value_ref0 (_tmp544_);
			instance_value = _tmp545_;
			_tmp548_ = ma;
			_tmp549_ = vala_member_access_get_member_name (_tmp548_);
			_tmp550_ = _tmp549_;
			if (g_strcmp0 (_tmp550_, "begin") == 0) {
				_tmp547_ = TRUE;
			} else {
				ValaMemberAccess* _tmp551_;
				const gchar* _tmp552_;
				const gchar* _tmp553_;
				_tmp551_ = ma;
				_tmp552_ = vala_member_access_get_member_name (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp547_ = g_strcmp0 (_tmp553_, "end") == 0;
			}
			if (_tmp547_) {
				ValaMemberAccess* _tmp554_;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaMemberAccess* _tmp559_;
				ValaSymbol* _tmp560_;
				ValaSymbol* _tmp561_;
				_tmp554_ = ma;
				_tmp555_ = vala_member_access_get_inner (_tmp554_);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_symbol_reference (_tmp556_);
				_tmp558_ = _tmp557_;
				_tmp559_ = ma;
				_tmp560_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp559_);
				_tmp561_ = _tmp560_;
				_tmp546_ = _tmp558_ == _tmp561_;
			} else {
				_tmp546_ = FALSE;
			}
			if (_tmp546_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp562_;
				ValaExpression* _tmp563_;
				ValaExpression* _tmp564_;
				ValaMemberAccess* _tmp565_;
				ValaMemberAccess* _tmp566_;
				ValaExpression* _tmp567_;
				ValaExpression* _tmp568_;
				ValaTargetValue* _tmp569_;
				ValaTargetValue* _tmp570_;
				ValaTargetValue* _tmp571_;
				_tmp562_ = ma;
				_tmp563_ = vala_member_access_get_inner (_tmp562_);
				_tmp564_ = _tmp563_;
				_tmp565_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp564_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp565_;
				_tmp566_ = inner_ma;
				_tmp567_ = vala_member_access_get_inner (_tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_expression_get_target_value (_tmp568_);
				_tmp570_ = _tmp569_;
				_tmp571_ = _vala_target_value_ref0 (_tmp570_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp571_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp572_ = instance_value;
			_tmp573_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp572_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp573_;
			_tmp574_ = m;
			_tmp575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp574_);
			_tmp576_ = _tmp575_;
			_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp576_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp576_) : NULL);
			st = _tmp577_;
			_tmp579_ = st;
			if (_tmp579_ != NULL) {
				ValaStruct* _tmp580_;
				_tmp580_ = st;
				_tmp578_ = !vala_struct_is_simple_type (_tmp580_);
			} else {
				_tmp578_ = FALSE;
			}
			if (_tmp578_) {
				ValaTargetValue* _tmp581_;
				ValaTargetValue* _tmp584_;
				ValaCCodeExpression* _tmp585_;
				ValaCCodeExpression* _tmp586_;
				ValaCCodeUnaryExpression* _tmp587_;
				_tmp581_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp581_)) {
					ValaTargetValue* _tmp582_;
					ValaTargetValue* _tmp583_;
					_tmp582_ = instance_value;
					_tmp583_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp582_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp583_;
				}
				_tmp584_ = instance_value;
				_tmp585_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp584_);
				_tmp586_ = _tmp585_;
				_tmp587_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp586_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp587_;
				_vala_ccode_node_unref0 (_tmp586_);
			}
			_tmp588_ = vala_method_call_get_is_yield_expression (expr);
			_tmp589_ = _tmp588_;
			if (_tmp589_) {
				ValaHashMap* _tmp590_;
				ValaMethod* _tmp591_;
				ValaCCodeExpression* _tmp592_;
				ValaMethod* _tmp593_;
				_tmp590_ = in_arg_map;
				_tmp591_ = m;
				_tmp592_ = instance;
				vala_map_set ((ValaMap*) _tmp590_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp591_), FALSE)), _tmp592_);
				_tmp593_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp593_)) {
					ValaHashMap* _tmp594_;
					ValaMethod* _tmp595_;
					ValaCCodeExpression* _tmp596_;
					_tmp594_ = out_arg_map;
					_tmp595_ = m;
					_tmp596_ = instance;
					vala_map_set ((ValaMap*) _tmp594_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp595_), FALSE)), _tmp596_);
				}
			} else {
				gboolean _tmp597_ = FALSE;
				ValaMemberAccess* _tmp598_;
				const gchar* _tmp599_;
				const gchar* _tmp600_;
				_tmp598_ = ma;
				_tmp599_ = vala_member_access_get_member_name (_tmp598_);
				_tmp600_ = _tmp599_;
				if (g_strcmp0 (_tmp600_, "end") != 0) {
					_tmp597_ = TRUE;
				} else {
					ValaMethod* _tmp601_;
					_tmp601_ = m;
					_tmp597_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp601_);
				}
				if (_tmp597_) {
					ValaHashMap* _tmp602_;
					ValaMethod* _tmp603_;
					ValaCCodeExpression* _tmp604_;
					ValaHashMap* _tmp605_;
					ValaMethod* _tmp606_;
					ValaCCodeExpression* _tmp607_;
					_tmp602_ = out_arg_map;
					_tmp603_ = m;
					_tmp604_ = instance;
					vala_map_set ((ValaMap*) _tmp602_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp603_), FALSE)), _tmp604_);
					_tmp605_ = in_arg_map;
					_tmp606_ = m;
					_tmp607_ = instance;
					vala_map_set ((ValaMap*) _tmp605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp606_), FALSE)), _tmp607_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp608_ = FALSE;
			ValaMethod* _tmp609_;
			_tmp609_ = m;
			if (_tmp609_ != NULL) {
				ValaMethod* _tmp610_;
				ValaMemberBinding _tmp611_;
				ValaMemberBinding _tmp612_;
				_tmp610_ = m;
				_tmp611_ = vala_method_get_binding (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp608_ = _tmp612_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp608_ = FALSE;
			}
			if (_tmp608_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				ValaClass* _tmp616_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp617_;
				gchar* _tmp618_;
				gchar* _tmp619_;
				ValaCCodeIdentifier* _tmp620_;
				ValaCCodeIdentifier* _tmp621_;
				ValaCCodeFunctionCall* _tmp622_;
				ValaCCodeFunctionCall* _tmp623_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp624_;
				ValaExpression* _tmp625_;
				ValaExpression* _tmp626_;
				ValaCCodeFunctionCall* _tmp652_;
				ValaCCodeExpression* _tmp653_;
				ValaHashMap* _tmp654_;
				ValaMethod* _tmp655_;
				ValaCCodeFunctionCall* _tmp656_;
				ValaHashMap* _tmp657_;
				ValaMethod* _tmp658_;
				ValaCCodeFunctionCall* _tmp659_;
				_tmp613_ = m;
				_tmp614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp613_);
				_tmp615_ = _tmp614_;
				_tmp616_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp616_;
				_tmp617_ = cl;
				_tmp618_ = vala_get_ccode_class_type_function (_tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_ccode_identifier_new (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp621_);
				_tmp623_ = _tmp622_;
				_vala_ccode_node_unref0 (_tmp621_);
				_g_free0 (_tmp619_);
				cast = _tmp623_;
				_tmp624_ = ma;
				_tmp625_ = vala_member_access_get_inner (_tmp624_);
				_tmp626_ = _tmp625_;
				if (_tmp626_ == NULL) {
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					gboolean _tmp629_;
					_tmp627_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp628_ = _tmp627_;
					_tmp629_ = _tmp628_ == NULL;
					_vala_code_node_unref0 (_tmp628_);
					if (_tmp629_) {
						ValaCCodeIdentifier* _tmp630_;
						_tmp630_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp630_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp631_;
						ValaCCodeIdentifier* _tmp632_;
						ValaCCodeFunctionCall* _tmp633_;
						ValaCCodeFunctionCall* _tmp634_;
						ValaCCodeFunctionCall* _tmp635_;
						ValaCCodeExpression* _tmp636_;
						ValaCCodeExpression* _tmp637_;
						ValaCCodeFunctionCall* _tmp638_;
						ValaCCodeExpression* _tmp639_;
						_tmp631_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp632_ = _tmp631_;
						_tmp633_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp632_);
						_tmp634_ = _tmp633_;
						_vala_ccode_node_unref0 (_tmp632_);
						k = _tmp634_;
						_tmp635_ = k;
						_tmp636_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp637_ = _tmp636_;
						vala_ccode_function_call_add_argument (_tmp635_, _tmp637_);
						_vala_ccode_node_unref0 (_tmp637_);
						_tmp638_ = k;
						_tmp639_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp638_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp639_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp640_;
					ValaCCodeIdentifier* _tmp641_;
					ValaCCodeFunctionCall* _tmp642_;
					ValaCCodeFunctionCall* _tmp643_;
					ValaCCodeFunctionCall* _tmp644_;
					ValaMemberAccess* _tmp645_;
					ValaExpression* _tmp646_;
					ValaExpression* _tmp647_;
					ValaCCodeExpression* _tmp648_;
					ValaCCodeExpression* _tmp649_;
					ValaCCodeFunctionCall* _tmp650_;
					ValaCCodeExpression* _tmp651_;
					_tmp640_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp641_);
					_tmp643_ = _tmp642_;
					_vala_ccode_node_unref0 (_tmp641_);
					k = _tmp643_;
					_tmp644_ = k;
					_tmp645_ = ma;
					_tmp646_ = vala_member_access_get_inner (_tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp647_);
					_tmp649_ = _tmp648_;
					vala_ccode_function_call_add_argument (_tmp644_, _tmp649_);
					_vala_ccode_node_unref0 (_tmp649_);
					_tmp650_ = k;
					_tmp651_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp650_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp651_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp652_ = cast;
				_tmp653_ = klass;
				vala_ccode_function_call_add_argument (_tmp652_, _tmp653_);
				_tmp654_ = in_arg_map;
				_tmp655_ = m;
				_tmp656_ = cast;
				vala_map_set ((ValaMap*) _tmp654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp655_), FALSE)), (ValaCCodeExpression*) _tmp656_);
				_tmp657_ = out_arg_map;
				_tmp658_ = m;
				_tmp659_ = cast;
				vala_map_set ((ValaMap*) _tmp657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp658_), FALSE)), (ValaCCodeExpression*) _tmp659_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp661_ = m;
	if (_tmp661_ != NULL) {
		ValaMethod* _tmp662_;
		_tmp662_ = m;
		_tmp660_ = vala_get_ccode_has_generic_type_parameter (_tmp662_);
	} else {
		_tmp660_ = FALSE;
	}
	if (_tmp660_) {
		ValaMethod* _tmp663_;
		_tmp663_ = m;
		if (vala_method_has_type_parameters (_tmp663_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp664_;
				ValaList* _tmp665_;
				gint _type_arg_size = 0;
				ValaList* _tmp666_;
				gint _tmp667_;
				gint _tmp668_;
				gint _type_arg_index = 0;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_type_arguments (_tmp664_);
				_type_arg_list = _tmp665_;
				_tmp666_ = _type_arg_list;
				_tmp667_ = vala_collection_get_size ((ValaCollection*) _tmp666_);
				_tmp668_ = _tmp667_;
				_type_arg_size = _tmp668_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp669_;
					gpointer _tmp670_;
					ValaHashMap* _tmp671_;
					ValaMethod* _tmp672_;
					ValaDataType* _tmp673_;
					gchar* _tmp674_;
					gchar* _tmp675_;
					ValaCCodeIdentifier* _tmp676_;
					ValaCCodeIdentifier* _tmp677_;
					gint _tmp678_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp669_ = _type_arg_list;
					_tmp670_ = vala_list_get (_tmp669_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp670_;
					_tmp671_ = in_arg_map;
					_tmp672_ = m;
					_tmp673_ = type_arg;
					_tmp674_ = vala_get_ccode_name ((ValaCodeNode*) _tmp673_);
					_tmp675_ = _tmp674_;
					_tmp676_ = vala_ccode_identifier_new (_tmp675_);
					_tmp677_ = _tmp676_;
					vala_map_set ((ValaMap*) _tmp671_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp672_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp677_);
					_vala_ccode_node_unref0 (_tmp677_);
					_g_free0 (_tmp675_);
					_tmp678_ = type_param_index;
					type_param_index = _tmp678_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp679_;
				ValaExpression* _tmp680_;
				ValaExpression* _tmp681_;
				ValaDataType* _tmp682_;
				ValaDataType* _tmp683_;
				ValaList* _tmp684_;
				gint _type_arg_size = 0;
				ValaList* _tmp685_;
				gint _tmp686_;
				gint _tmp687_;
				gint _type_arg_index = 0;
				_tmp679_ = ma;
				_tmp680_ = vala_member_access_get_inner (_tmp679_);
				_tmp681_ = _tmp680_;
				_tmp682_ = vala_expression_get_value_type (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_data_type_get_type_arguments (_tmp683_);
				_type_arg_list = _tmp684_;
				_tmp685_ = _type_arg_list;
				_tmp686_ = vala_collection_get_size ((ValaCollection*) _tmp685_);
				_tmp687_ = _tmp686_;
				_type_arg_size = _tmp687_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp688_;
					gpointer _tmp689_;
					ValaHashMap* _tmp690_;
					ValaMethod* _tmp691_;
					ValaDataType* _tmp692_;
					gchar* _tmp693_;
					gchar* _tmp694_;
					ValaCCodeIdentifier* _tmp695_;
					ValaCCodeIdentifier* _tmp696_;
					gint _tmp697_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp688_ = _type_arg_list;
					_tmp689_ = vala_list_get (_tmp688_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp689_;
					_tmp690_ = in_arg_map;
					_tmp691_ = m;
					_tmp692_ = type_arg;
					_tmp693_ = vala_get_ccode_name ((ValaCodeNode*) _tmp692_);
					_tmp694_ = _tmp693_;
					_tmp695_ = vala_ccode_identifier_new (_tmp694_);
					_tmp696_ = _tmp695_;
					vala_map_set ((ValaMap*) _tmp690_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp691_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp696_);
					_vala_ccode_node_unref0 (_tmp696_);
					_g_free0 (_tmp694_);
					_tmp697_ = type_param_index;
					type_param_index = _tmp697_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp698_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp698_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp699_;
		ValaExpression* _tmp700_;
		ValaExpression* _tmp701_;
		ValaDataType* _tmp702_;
		ValaDataType* _tmp703_;
		ValaArrayType* _tmp704_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaCCodeFunctionCall* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		ValaCCodeFunctionCall* _tmp709_;
		ValaArrayType* _tmp710_;
		ValaDataType* _tmp711_;
		ValaDataType* _tmp712_;
		gchar* _tmp713_;
		gchar* _tmp714_;
		ValaCCodeIdentifier* _tmp715_;
		ValaCCodeIdentifier* _tmp716_;
		ValaHashMap* _tmp717_;
		ValaCCodeFunctionCall* _tmp718_;
		_tmp699_ = ma;
		_tmp700_ = vala_member_access_get_inner (_tmp699_);
		_tmp701_ = _tmp700_;
		_tmp702_ = vala_expression_get_value_type (_tmp701_);
		_tmp703_ = _tmp702_;
		_tmp704_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp703_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp704_;
		_tmp705_ = vala_ccode_identifier_new ("sizeof");
		_tmp706_ = _tmp705_;
		_tmp707_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp706_);
		_tmp708_ = _tmp707_;
		_vala_ccode_node_unref0 (_tmp706_);
		csizeof = _tmp708_;
		_tmp709_ = csizeof;
		_tmp710_ = array_type;
		_tmp711_ = vala_array_type_get_element_type (_tmp710_);
		_tmp712_ = _tmp711_;
		_tmp713_ = vala_get_ccode_name ((ValaCodeNode*) _tmp712_);
		_tmp714_ = _tmp713_;
		_tmp715_ = vala_ccode_identifier_new (_tmp714_);
		_tmp716_ = _tmp715_;
		vala_ccode_function_call_add_argument (_tmp709_, (ValaCCodeExpression*) _tmp716_);
		_vala_ccode_node_unref0 (_tmp716_);
		_g_free0 (_tmp714_);
		_tmp717_ = in_arg_map;
		_tmp718_ = csizeof;
		vala_map_set ((ValaMap*) _tmp717_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp718_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp719_;
		_tmp719_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp719_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp720_;
			gint param_nr = 0;
			ValaMethod* _tmp780_;
			_tmp720_ = m;
			vala_method_clear_parameters (_tmp720_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp721_;
				gint _arg_size = 0;
				ValaList* _tmp722_;
				gint _tmp723_;
				gint _tmp724_;
				gint _arg_index = 0;
				_tmp721_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp721_;
				_tmp722_ = _arg_list;
				_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
				_tmp724_ = _tmp723_;
				_arg_size = _tmp724_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp725_;
					gpointer _tmp726_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp727_;
					ValaUnaryExpression* _tmp728_;
					gboolean _tmp729_ = FALSE;
					ValaUnaryExpression* _tmp730_;
					gint _tmp771_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp725_ = _arg_list;
					_tmp726_ = vala_list_get (_tmp725_, _arg_index);
					arg = (ValaExpression*) _tmp726_;
					_tmp727_ = arg;
					_tmp728_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp727_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp727_) : NULL);
					unary = _tmp728_;
					_tmp730_ = unary;
					if (_tmp730_ != NULL) {
						ValaUnaryExpression* _tmp731_;
						ValaUnaryOperator _tmp732_;
						ValaUnaryOperator _tmp733_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_operator (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp729_ = _tmp733_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp729_ = FALSE;
					}
					if (_tmp729_) {
						ValaParameter* param = NULL;
						gchar* _tmp734_;
						gchar* _tmp735_;
						ValaUnaryExpression* _tmp736_;
						ValaExpression* _tmp737_;
						ValaExpression* _tmp738_;
						ValaDataType* _tmp739_;
						ValaDataType* _tmp740_;
						ValaParameter* _tmp741_;
						ValaParameter* _tmp742_;
						ValaParameter* _tmp743_;
						ValaMethod* _tmp744_;
						ValaParameter* _tmp745_;
						_tmp734_ = g_strdup_printf ("param%d", param_nr);
						_tmp735_ = _tmp734_;
						_tmp736_ = unary;
						_tmp737_ = vala_unary_expression_get_inner (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_expression_get_value_type (_tmp738_);
						_tmp740_ = _tmp739_;
						_tmp741_ = vala_parameter_new (_tmp735_, _tmp740_, NULL);
						_tmp742_ = _tmp741_;
						_g_free0 (_tmp735_);
						param = _tmp742_;
						_tmp743_ = param;
						vala_parameter_set_direction (_tmp743_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp744_ = m;
						_tmp745_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp744_, _tmp745_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp746_ = FALSE;
						ValaUnaryExpression* _tmp747_;
						_tmp747_ = unary;
						if (_tmp747_ != NULL) {
							ValaUnaryExpression* _tmp748_;
							ValaUnaryOperator _tmp749_;
							ValaUnaryOperator _tmp750_;
							_tmp748_ = unary;
							_tmp749_ = vala_unary_expression_get_operator (_tmp748_);
							_tmp750_ = _tmp749_;
							_tmp746_ = _tmp750_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp746_ = FALSE;
						}
						if (_tmp746_) {
							ValaParameter* param = NULL;
							gchar* _tmp751_;
							gchar* _tmp752_;
							ValaUnaryExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaExpression* _tmp755_;
							ValaDataType* _tmp756_;
							ValaDataType* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaParameter* _tmp760_;
							ValaMethod* _tmp761_;
							ValaParameter* _tmp762_;
							_tmp751_ = g_strdup_printf ("param%d", param_nr);
							_tmp752_ = _tmp751_;
							_tmp753_ = unary;
							_tmp754_ = vala_unary_expression_get_inner (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = vala_expression_get_value_type (_tmp755_);
							_tmp757_ = _tmp756_;
							_tmp758_ = vala_parameter_new (_tmp752_, _tmp757_, NULL);
							_tmp759_ = _tmp758_;
							_g_free0 (_tmp752_);
							param = _tmp759_;
							_tmp760_ = param;
							vala_parameter_set_direction (_tmp760_, VALA_PARAMETER_DIRECTION_REF);
							_tmp761_ = m;
							_tmp762_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp761_, _tmp762_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp763_;
							gchar* _tmp764_;
							gchar* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							_tmp763_ = m;
							_tmp764_ = g_strdup_printf ("param%d", param_nr);
							_tmp765_ = _tmp764_;
							_tmp766_ = arg;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp765_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							vala_callable_add_parameter ((ValaCallable*) _tmp763_, _tmp770_);
							_vala_code_node_unref0 (_tmp770_);
							_g_free0 (_tmp765_);
						}
					}
					_tmp771_ = param_nr;
					param_nr = _tmp771_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp772_;
				ValaList* _tmp773_;
				gint _param_size = 0;
				ValaList* _tmp774_;
				gint _tmp775_;
				gint _tmp776_;
				gint _param_index = 0;
				_tmp772_ = m;
				_tmp773_ = vala_callable_get_parameters ((ValaCallable*) _tmp772_);
				_param_list = _tmp773_;
				_tmp774_ = _param_list;
				_tmp775_ = vala_collection_get_size ((ValaCollection*) _tmp774_);
				_tmp776_ = _tmp775_;
				_param_size = _tmp776_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp777_;
					gpointer _tmp778_;
					ValaParameter* _tmp779_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp777_ = _param_list;
					_tmp778_ = vala_list_get (_tmp777_, _param_index);
					param = (ValaParameter*) _tmp778_;
					_tmp779_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp779_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp780_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp781_ = FALSE;
			gboolean _tmp782_ = FALSE;
			ValaMethod* _tmp783_;
			_tmp783_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp783_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp784_;
				ValaCodeContext* _tmp785_;
				ValaProfile _tmp786_;
				ValaProfile _tmp787_;
				_tmp784_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_code_context_get_profile (_tmp785_);
				_tmp787_ = _tmp786_;
				_tmp782_ = _tmp787_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp782_ = FALSE;
			}
			if (_tmp782_) {
				ValaMethod* _tmp788_;
				ValaSymbol* _tmp789_;
				ValaSymbol* _tmp790_;
				_tmp788_ = m;
				_tmp789_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp788_);
				_tmp790_ = _tmp789_;
				_tmp781_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp790_, VALA_TYPE_CLASS);
			} else {
				_tmp781_ = FALSE;
			}
			if (_tmp781_) {
				ValaCCodeFunction* _tmp791_;
				ValaCCodeFunction* _tmp792_;
				ValaCCodeExpression* _tmp793_;
				ValaCCodeExpression* _tmp794_;
				ValaCCodeFunctionCall* _tmp795_;
				ValaClass* _tmp796_;
				ValaClass* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				ValaCCodeCastExpression* _tmp802_;
				ValaCCodeCastExpression* _tmp803_;
				ValaMethod* _tmp804_;
				ValaMethod* _tmp805_;
				ValaBlock* _tmp806_;
				ValaBlock* _tmp807_;
				gboolean _tmp808_;
				gboolean _tmp809_;
				gboolean _tmp836_ = FALSE;
				ValaClass* _tmp837_;
				ValaClass* _tmp838_;
				gboolean _tmp839_;
				gboolean _tmp840_;
				_tmp791_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = ccall;
				_tmp796_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_get_ccode_name ((ValaCodeNode*) _tmp797_);
				_tmp799_ = _tmp798_;
				_tmp800_ = g_strconcat (_tmp799_, "*", NULL);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp795_, _tmp801_);
				_tmp803_ = _tmp802_;
				vala_ccode_function_add_assignment (_tmp792_, _tmp794_, (ValaCCodeExpression*) _tmp803_);
				_vala_ccode_node_unref0 (_tmp803_);
				_g_free0 (_tmp801_);
				_g_free0 (_tmp799_);
				_vala_ccode_node_unref0 (_tmp794_);
				_tmp804_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp805_ = _tmp804_;
				_tmp806_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp805_);
				_tmp807_ = _tmp806_;
				_tmp808_ = vala_block_get_captured (_tmp807_);
				_tmp809_ = _tmp808_;
				if (_tmp809_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp810_;
					ValaClass* _tmp811_;
					ValaObjectType* _tmp812_;
					ValaObjectType* _tmp813_;
					ValaSourceReference* _tmp814_;
					ValaSourceReference* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeFunctionCall* _tmp820_;
					ValaCCodeExpression* _tmp821_;
					ValaCCodeExpression* _tmp822_;
					ValaCCodeFunction* _tmp823_;
					ValaCCodeFunction* _tmp824_;
					ValaMethod* _tmp825_;
					ValaMethod* _tmp826_;
					ValaBlock* _tmp827_;
					ValaBlock* _tmp828_;
					gchar* _tmp829_;
					gchar* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeExpression* _tmp832_;
					ValaCCodeMemberAccess* _tmp833_;
					ValaCCodeMemberAccess* _tmp834_;
					ValaCCodeFunctionCall* _tmp835_;
					_tmp810_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp811_);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp813_, _tmp815_, FALSE);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_function_call_new (_tmp817_);
					_tmp819_ = _tmp818_;
					_vala_ccode_node_unref0 (_tmp817_);
					_vala_code_node_unref0 (_tmp813_);
					ref_call = _tmp819_;
					_tmp820_ = ref_call;
					_tmp821_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					vala_ccode_function_call_add_argument (_tmp820_, _tmp822_);
					_vala_ccode_node_unref0 (_tmp822_);
					_tmp823_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					_tmp825_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp828_));
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp830_);
					_tmp832_ = _tmp831_;
					_tmp833_ = vala_ccode_member_access_new_pointer (_tmp832_, "self");
					_tmp834_ = _tmp833_;
					_tmp835_ = ref_call;
					vala_ccode_function_add_assignment (_tmp824_, (ValaCCodeExpression*) _tmp834_, (ValaCCodeExpression*) _tmp835_);
					_vala_ccode_node_unref0 (_tmp834_);
					_vala_ccode_node_unref0 (_tmp832_);
					_g_free0 (_tmp830_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp838_ = _tmp837_;
				_tmp839_ = vala_class_get_is_compact (_tmp838_);
				_tmp840_ = _tmp839_;
				if (!_tmp840_) {
					ValaClass* _tmp841_;
					ValaClass* _tmp842_;
					_tmp841_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp842_ = _tmp841_;
					_tmp836_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp842_);
				} else {
					_tmp836_ = FALSE;
				}
				if (_tmp836_) {
					gchar** suffices = NULL;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar* _tmp845_;
					gchar** _tmp846_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp843_ = g_strdup ("type");
					_tmp844_ = g_strdup ("dup_func");
					_tmp845_ = g_strdup ("destroy_func");
					_tmp846_ = g_new0 (gchar*, 3 + 1);
					_tmp846_[0] = _tmp843_;
					_tmp846_[1] = _tmp844_;
					_tmp846_[2] = _tmp845_;
					suffices = _tmp846_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp847_;
						ValaClass* _tmp848_;
						ValaList* _tmp849_;
						gint _type_param_size = 0;
						ValaList* _tmp850_;
						gint _tmp851_;
						gint _tmp852_;
						gint _type_param_index = 0;
						_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp848_ = _tmp847_;
						_tmp849_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp848_);
						_type_param_list = _tmp849_;
						_tmp850_ = _type_param_list;
						_tmp851_ = vala_collection_get_size ((ValaCollection*) _tmp850_);
						_tmp852_ = _tmp851_;
						_type_param_size = _tmp852_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp853_;
							gpointer _tmp854_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp855_;
							ValaCCodeIdentifier* _tmp856_;
							ValaCCodeMemberAccess* _tmp857_;
							ValaCCodeMemberAccess* _tmp858_;
							gchar** _tmp859_;
							gint _tmp859__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp853_ = _type_param_list;
							_tmp854_ = vala_list_get (_tmp853_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp854_;
							_tmp855_ = vala_ccode_identifier_new ("self");
							_tmp856_ = _tmp855_;
							_tmp857_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp856_, "priv");
							_tmp858_ = _tmp857_;
							_vala_ccode_node_unref0 (_tmp856_);
							priv_access = _tmp858_;
							_tmp859_ = suffices;
							_tmp859__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp859_;
								suffix_collection_length1 = _tmp859__length1;
								for (suffix_it = 0; suffix_it < _tmp859__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp860_;
									gchar* suffix = NULL;
									_tmp860_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp860_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp861_;
										const gchar* _tmp862_;
										const gchar* _tmp863_;
										gchar* _tmp864_;
										gchar* _tmp865_;
										const gchar* _tmp866_;
										gchar* _tmp867_;
										gchar* _tmp868_;
										ValaCCodeIdentifier* _tmp869_;
										ValaCCodeIdentifier* _tmp870_;
										ValaCCodeFunction* _tmp871_;
										ValaCCodeFunction* _tmp872_;
										ValaCCodeMemberAccess* _tmp873_;
										ValaCCodeIdentifier* _tmp874_;
										const gchar* _tmp875_;
										const gchar* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeMemberAccess* _tmp878_;
										ValaCCodeIdentifier* _tmp879_;
										_tmp861_ = type_param;
										_tmp862_ = vala_symbol_get_name ((ValaSymbol*) _tmp861_);
										_tmp863_ = _tmp862_;
										_tmp864_ = g_utf8_strdown (_tmp863_, (gssize) -1);
										_tmp865_ = _tmp864_;
										_tmp866_ = suffix;
										_tmp867_ = g_strdup_printf ("%s_%s", _tmp865_, _tmp866_);
										_tmp868_ = _tmp867_;
										_tmp869_ = vala_ccode_identifier_new (_tmp868_);
										_tmp870_ = _tmp869_;
										_g_free0 (_tmp868_);
										_g_free0 (_tmp865_);
										param_name = _tmp870_;
										_tmp871_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp872_ = _tmp871_;
										_tmp873_ = priv_access;
										_tmp874_ = param_name;
										_tmp875_ = vala_ccode_identifier_get_name (_tmp874_);
										_tmp876_ = _tmp875_;
										_tmp877_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp873_, _tmp876_);
										_tmp878_ = _tmp877_;
										_tmp879_ = param_name;
										vala_ccode_function_add_assignment (_tmp872_, (ValaCCodeExpression*) _tmp878_, (ValaCCodeExpression*) _tmp879_);
										_vala_ccode_node_unref0 (_tmp878_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp880_ = params;
	_tmp881_ = vala_iterable_iterator ((ValaIterable*) _tmp880_);
	params_it = _tmp881_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp882_;
		gint _arg_size = 0;
		ValaList* _tmp883_;
		gint _tmp884_;
		gint _tmp885_;
		gint _arg_index = 0;
		_tmp882_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp882_;
		_tmp883_ = _arg_list;
		_tmp884_ = vala_collection_get_size ((ValaCollection*) _tmp883_);
		_tmp885_ = _tmp884_;
		_arg_size = _tmp885_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp886_;
			gpointer _tmp887_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp888_;
			ValaCCodeExpression* _tmp889_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp890_;
			ValaHashMap* _tmp891_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp892_;
			gboolean _tmp902_ = FALSE;
			ValaParameter* _tmp903_;
			gdouble _tmp1229_ = 0.0;
			ValaParameter* _tmp1230_;
			ValaHashMap* _tmp1232_;
			ValaCCodeExpression* _tmp1233_;
			gboolean _tmp1234_ = FALSE;
			ValaExpression* _tmp1235_;
			gint _tmp1252_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp886_ = _arg_list;
			_tmp887_ = vala_list_get (_tmp886_, _arg_index);
			arg = (ValaExpression*) _tmp887_;
			_tmp888_ = arg;
			_tmp889_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp888_);
			cexpr = _tmp889_;
			_tmp890_ = in_arg_map;
			_tmp891_ = _vala_map_ref0 (_tmp890_);
			carg_map = _tmp891_;
			param = NULL;
			_tmp892_ = params_it;
			if (vala_iterator_next (_tmp892_)) {
				ValaIterator* _tmp893_;
				gpointer _tmp894_;
				gboolean _tmp895_ = FALSE;
				ValaParameter* _tmp896_;
				gboolean _tmp897_;
				gboolean _tmp898_;
				_tmp893_ = params_it;
				_tmp894_ = vala_iterator_get (_tmp893_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp894_;
				_tmp896_ = param;
				_tmp897_ = vala_parameter_get_params_array (_tmp896_);
				_tmp898_ = _tmp897_;
				if (_tmp898_) {
					_tmp895_ = TRUE;
				} else {
					ValaParameter* _tmp899_;
					gboolean _tmp900_;
					gboolean _tmp901_;
					_tmp899_ = param;
					_tmp900_ = vala_parameter_get_ellipsis (_tmp899_);
					_tmp901_ = _tmp900_;
					_tmp895_ = _tmp901_;
				}
				ellipsis = _tmp895_;
			}
			_tmp903_ = param;
			if (_tmp903_ != NULL) {
				_tmp902_ = !ellipsis;
			} else {
				_tmp902_ = FALSE;
			}
			if (_tmp902_) {
				ValaParameter* _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaParameterDirection _tmp906_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp909_;
				ValaUnaryExpression* _tmp910_;
				gboolean _tmp911_ = FALSE;
				ValaUnaryExpression* _tmp912_;
				ValaParameter* _tmp1180_;
				gchar* _tmp1181_;
				gchar* _tmp1182_;
				gboolean _tmp1183_;
				_tmp904_ = param;
				_tmp905_ = vala_parameter_get_direction (_tmp904_);
				_tmp906_ = _tmp905_;
				if (_tmp906_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp907_;
					ValaHashMap* _tmp908_;
					_tmp907_ = out_arg_map;
					_tmp908_ = _vala_map_ref0 (_tmp907_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp908_;
				}
				_tmp909_ = arg;
				_tmp910_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp909_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp909_) : NULL);
				unary = _tmp910_;
				_tmp912_ = unary;
				if (_tmp912_ == NULL) {
					_tmp911_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp913_;
					ValaUnaryOperator _tmp914_;
					ValaUnaryOperator _tmp915_;
					_tmp913_ = unary;
					_tmp914_ = vala_unary_expression_get_operator (_tmp913_);
					_tmp915_ = _tmp914_;
					_tmp911_ = _tmp915_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp911_) {
					gboolean _tmp916_ = FALSE;
					gboolean _tmp917_ = FALSE;
					ValaParameter* _tmp918_;
					ValaParameter* _tmp1054_;
					ValaExpression* _tmp1055_;
					ValaCCodeExpression* _tmp1056_;
					ValaCCodeExpression* _tmp1057_;
					_tmp918_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp918_)) {
						ValaParameter* _tmp919_;
						ValaDataType* _tmp920_;
						ValaDataType* _tmp921_;
						_tmp919_ = param;
						_tmp920_ = vala_variable_get_variable_type ((ValaVariable*) _tmp919_);
						_tmp921_ = _tmp920_;
						_tmp917_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp921_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp917_ = FALSE;
					}
					if (_tmp917_) {
						ValaParameter* _tmp922_;
						ValaDataType* _tmp923_;
						ValaDataType* _tmp924_;
						gboolean _tmp925_;
						gboolean _tmp926_;
						_tmp922_ = param;
						_tmp923_ = vala_variable_get_variable_type ((ValaVariable*) _tmp922_);
						_tmp924_ = _tmp923_;
						_tmp925_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp924_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp926_ = _tmp925_;
						_tmp916_ = !_tmp926_;
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp927_;
						ValaDataType* _tmp928_;
						ValaDataType* _tmp929_;
						ValaArrayType* _tmp930_;
						gchar* _tmp931_ = NULL;
						ValaParameter* _tmp932_;
						gchar* _tmp933_;
						gchar* length_ctype = NULL;
						gchar* _tmp936_;
						gboolean _tmp937_ = FALSE;
						ValaUnaryExpression* _tmp938_;
						_tmp927_ = param;
						_tmp928_ = vala_variable_get_variable_type ((ValaVariable*) _tmp927_);
						_tmp929_ = _tmp928_;
						_tmp930_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp929_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp930_;
						_tmp932_ = param;
						_tmp933_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp932_);
						_tmp931_ = _tmp933_;
						if (_tmp931_ == NULL) {
							ValaArrayType* _tmp934_;
							gchar* _tmp935_;
							_tmp934_ = array_type;
							_tmp935_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp934_);
							_g_free0 (_tmp931_);
							_tmp931_ = _tmp935_;
						}
						_tmp936_ = g_strdup (_tmp931_);
						length_ctype = _tmp936_;
						_tmp938_ = unary;
						if (_tmp938_ != NULL) {
							ValaUnaryExpression* _tmp939_;
							ValaUnaryOperator _tmp940_;
							ValaUnaryOperator _tmp941_;
							_tmp939_ = unary;
							_tmp940_ = vala_unary_expression_get_operator (_tmp939_);
							_tmp941_ = _tmp940_;
							_tmp937_ = _tmp941_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp937_ = FALSE;
						}
						if (_tmp937_) {
							const gchar* _tmp942_;
							gchar* _tmp943_;
							_tmp942_ = length_ctype;
							_tmp943_ = g_strdup_printf ("%s*", _tmp942_);
							_g_free0 (length_ctype);
							length_ctype = _tmp943_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp944_ = FALSE;
								_tmp944_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp946_;
									gint _tmp947_;
									gint _tmp948_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp949_;
									ValaCCodeExpression* _tmp950_;
									ValaCCodeExpression* _tmp951_;
									const gchar* _tmp952_;
									ValaCCodeCastExpression* _tmp953_;
									ValaCCodeCastExpression* _tmp954_;
									ValaHashMap* _tmp955_;
									ValaParameter* _tmp956_;
									ValaCCodeCastExpression* _tmp957_;
									if (!_tmp944_) {
										gint _tmp945_;
										_tmp945_ = dim;
										dim = _tmp945_ + 1;
									}
									_tmp944_ = FALSE;
									_tmp946_ = array_type;
									_tmp947_ = vala_array_type_get_rank (_tmp946_);
									_tmp948_ = _tmp947_;
									if (!(dim <= _tmp948_)) {
										break;
									}
									_tmp949_ = arg;
									_tmp950_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp949_, dim);
									_tmp951_ = _tmp950_;
									_tmp952_ = length_ctype;
									_tmp953_ = vala_ccode_cast_expression_new (_tmp951_, _tmp952_);
									_tmp954_ = _tmp953_;
									_vala_ccode_node_unref0 (_tmp951_);
									array_length_expr = _tmp954_;
									_tmp955_ = carg_map;
									_tmp956_ = param;
									_tmp957_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp955_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp956_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp957_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp931_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp958_;
						ValaDataType* _tmp959_;
						ValaDataType* _tmp960_;
						_tmp958_ = param;
						_tmp959_ = vala_variable_get_variable_type ((ValaVariable*) _tmp958_);
						_tmp960_ = _tmp959_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp960_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp961_;
							ValaDataType* _tmp962_;
							ValaDataType* _tmp963_;
							ValaDelegateType* _tmp964_;
							ValaDelegateType* _tmp965_;
							ValaDelegate* _tmp966_;
							ValaDelegate* _tmp967_;
							gboolean _tmp968_;
							gboolean _tmp969_;
							_tmp961_ = param;
							_tmp962_ = vala_variable_get_variable_type ((ValaVariable*) _tmp961_);
							_tmp963_ = _tmp962_;
							_tmp964_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp963_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp964_;
							_tmp965_ = deleg_type;
							_tmp966_ = vala_delegate_type_get_delegate_symbol (_tmp965_);
							_tmp967_ = _tmp966_;
							_tmp968_ = vala_delegate_get_has_target (_tmp967_);
							_tmp969_ = _tmp968_;
							if (_tmp969_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp970_;
								ValaCCodeExpression* _tmp971_ = NULL;
								ValaCCodeExpression* _tmp972_;
								ValaCCodeExpression* _tmp973_;
								ValaParameter* _tmp974_;
								gchar* _tmp975_;
								gchar* _tmp976_;
								gboolean _tmp977_;
								_tmp970_ = arg;
								_tmp972_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp970_, &_tmp971_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp971_;
								delegate_target = _tmp972_;
								_tmp973_ = delegate_target;
								_vala_assert (_tmp973_ != NULL, "delegate_target != null");
								_tmp974_ = param;
								_tmp975_ = vala_get_ccode_type ((ValaCodeNode*) _tmp974_);
								_tmp976_ = _tmp975_;
								_tmp977_ = g_strcmp0 (_tmp976_, "GClosure*") == 0;
								_g_free0 (_tmp976_);
								if (_tmp977_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp978_;
									ValaCCodeIdentifier* _tmp979_;
									ValaCCodeFunctionCall* _tmp980_;
									ValaCCodeFunctionCall* _tmp981_;
									ValaCCodeFunctionCall* _tmp982_;
									ValaCCodeExpression* _tmp983_;
									ValaCCodeCastExpression* _tmp984_;
									ValaCCodeCastExpression* _tmp985_;
									ValaCCodeFunctionCall* _tmp986_;
									ValaCCodeExpression* _tmp987_;
									ValaCCodeFunctionCall* _tmp988_;
									ValaCCodeExpression* _tmp989_;
									ValaCCodeCastExpression* _tmp990_;
									ValaCCodeCastExpression* _tmp991_;
									ValaCCodeExpression* _tmp992_;
									ValaCCodeIdentifier* _tmp993_;
									ValaCCodeIdentifier* _tmp994_;
									ValaCCodeBinaryExpression* _tmp995_;
									ValaCCodeBinaryExpression* _tmp996_;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeFunctionCall* _tmp999_;
									ValaCCodeConditionalExpression* _tmp1000_;
									_tmp978_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp979_ = _tmp978_;
									_tmp980_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp979_);
									_tmp981_ = _tmp980_;
									_vala_ccode_node_unref0 (_tmp979_);
									closure_new = _tmp981_;
									_tmp982_ = closure_new;
									_tmp983_ = cexpr;
									_tmp984_ = vala_ccode_cast_expression_new (_tmp983_, "GCallback");
									_tmp985_ = _tmp984_;
									vala_ccode_function_call_add_argument (_tmp982_, (ValaCCodeExpression*) _tmp985_);
									_vala_ccode_node_unref0 (_tmp985_);
									_tmp986_ = closure_new;
									_tmp987_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp986_, _tmp987_);
									_tmp988_ = closure_new;
									_tmp989_ = delegate_target_destroy_notify;
									_tmp990_ = vala_ccode_cast_expression_new (_tmp989_, "GClosureNotify");
									_tmp991_ = _tmp990_;
									vala_ccode_function_call_add_argument (_tmp988_, (ValaCCodeExpression*) _tmp991_);
									_vala_ccode_node_unref0 (_tmp991_);
									_tmp992_ = cexpr;
									_tmp993_ = vala_ccode_identifier_new ("NULL");
									_tmp994_ = _tmp993_;
									_tmp995_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp992_, (ValaCCodeExpression*) _tmp994_);
									_tmp996_ = _tmp995_;
									_tmp997_ = vala_ccode_identifier_new ("NULL");
									_tmp998_ = _tmp997_;
									_tmp999_ = closure_new;
									_tmp1000_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp996_, (ValaCCodeExpression*) _tmp998_, (ValaCCodeExpression*) _tmp999_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1000_;
									_vala_ccode_node_unref0 (_tmp998_);
									_vala_ccode_node_unref0 (_tmp996_);
									_vala_ccode_node_unref0 (_tmp994_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1001_;
									ValaParameter* _tmp1002_;
									ValaCCodeExpression* _tmp1003_;
									ValaDelegateType* _tmp1004_;
									_tmp1001_ = carg_map;
									_tmp1002_ = param;
									_tmp1003_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1001_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1002_), FALSE)), _tmp1003_);
									_tmp1004_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1004_)) {
										ValaCCodeExpression* _tmp1005_;
										ValaHashMap* _tmp1006_;
										ValaParameter* _tmp1007_;
										ValaCCodeExpression* _tmp1008_;
										_tmp1005_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1005_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1006_ = carg_map;
										_tmp1007_ = param;
										_tmp1008_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1006_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1007_) + 0.01, FALSE)), _tmp1008_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1009_;
							ValaDataType* _tmp1010_;
							ValaDataType* _tmp1011_;
							_tmp1009_ = param;
							_tmp1010_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1009_);
							_tmp1011_ = _tmp1010_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1011_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1012_;
								ValaParameter* _tmp1013_;
								ValaExpression* _tmp1014_;
								ValaCCodeExpression* _tmp1015_ = NULL;
								ValaCCodeExpression* _tmp1016_;
								ValaCCodeExpression* _tmp1017_;
								_tmp1012_ = carg_map;
								_tmp1013_ = param;
								_tmp1014_ = arg;
								_tmp1016_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1014_, &_tmp1015_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1015_;
								_tmp1017_ = _tmp1016_;
								vala_map_set ((ValaMap*) _tmp1012_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1013_), FALSE)), _tmp1017_);
								_vala_ccode_node_unref0 (_tmp1017_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1018_;
								ValaDataType* _tmp1019_;
								ValaDataType* _tmp1020_;
								_tmp1018_ = param;
								_tmp1019_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1018_);
								_tmp1020_ = _tmp1019_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1020_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1021_ = FALSE;
									ValaMethod* _tmp1022_;
									_tmp1022_ = m;
									if (_tmp1022_ != NULL) {
										ValaMethod* _tmp1023_;
										_tmp1023_ = m;
										_tmp1021_ = vala_get_ccode_simple_generics (_tmp1023_);
									} else {
										_tmp1021_ = FALSE;
									}
									if (_tmp1021_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1024_;
										ValaDataType* _tmp1025_;
										ValaDataType* _tmp1026_;
										ValaGenericType* _tmp1027_;
										gint type_param_index = 0;
										ValaMethod* _tmp1028_;
										ValaGenericType* _tmp1029_;
										ValaTypeParameter* _tmp1030_;
										ValaTypeParameter* _tmp1031_;
										const gchar* _tmp1032_;
										const gchar* _tmp1033_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1034_;
										ValaList* _tmp1035_;
										ValaList* _tmp1036_;
										gpointer _tmp1037_;
										ValaDataType* _tmp1038_;
										ValaParameter* _tmp1039_;
										ValaDataType* _tmp1040_;
										ValaDataType* _tmp1041_;
										gboolean _tmp1042_;
										gboolean _tmp1043_;
										_tmp1024_ = param;
										_tmp1025_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1024_);
										_tmp1026_ = _tmp1025_;
										_tmp1027_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1026_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1027_;
										_tmp1028_ = m;
										_tmp1029_ = generic_type;
										_tmp1030_ = vala_generic_type_get_type_parameter (_tmp1029_);
										_tmp1031_ = _tmp1030_;
										_tmp1032_ = vala_symbol_get_name ((ValaSymbol*) _tmp1031_);
										_tmp1033_ = _tmp1032_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1028_, _tmp1033_);
										_tmp1034_ = ma;
										_tmp1035_ = vala_member_access_get_type_arguments (_tmp1034_);
										_tmp1036_ = _tmp1035_;
										_tmp1037_ = vala_list_get (_tmp1036_, type_param_index);
										_tmp1038_ = (ValaDataType*) _tmp1037_;
										_vala_iterable_unref0 (_tmp1036_);
										type_arg = _tmp1038_;
										_tmp1039_ = param;
										_tmp1040_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1039_);
										_tmp1041_ = _tmp1040_;
										_tmp1042_ = vala_data_type_get_value_owned (_tmp1041_);
										_tmp1043_ = _tmp1042_;
										if (_tmp1043_) {
											ValaDataType* _tmp1044_;
											_tmp1044_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1044_)) {
												ValaHashMap* _tmp1045_;
												ValaParameter* _tmp1046_;
												ValaDataType* _tmp1047_;
												ValaCCodeExpression* _tmp1048_;
												ValaCCodeExpression* _tmp1049_;
												_tmp1045_ = carg_map;
												_tmp1046_ = param;
												_tmp1047_ = type_arg;
												_tmp1048_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1047_, FALSE);
												_tmp1049_ = _tmp1048_;
												vala_map_set ((ValaMap*) _tmp1045_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1046_), FALSE)), _tmp1049_);
												_vala_ccode_node_unref0 (_tmp1049_);
											} else {
												ValaHashMap* _tmp1050_;
												ValaParameter* _tmp1051_;
												ValaCCodeConstant* _tmp1052_;
												ValaCCodeConstant* _tmp1053_;
												_tmp1050_ = carg_map;
												_tmp1051_ = param;
												_tmp1052_ = vala_ccode_constant_new ("NULL");
												_tmp1053_ = _tmp1052_;
												vala_map_set ((ValaMap*) _tmp1050_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1051_), FALSE)), (ValaCCodeExpression*) _tmp1053_);
												_vala_ccode_node_unref0 (_tmp1053_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1054_ = param;
					_tmp1055_ = arg;
					_tmp1056_ = cexpr;
					_tmp1057_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1054_, _tmp1055_, _tmp1056_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1057_;
				} else {
					ValaExpression* _tmp1058_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1059_;
					ValaDataType* _tmp1060_;
					ValaDataType* _tmp1061_;
					ValaParameter* _tmp1062_;
					ValaDataType* _tmp1063_;
					ValaDataType* _tmp1064_;
					gboolean _tmp1065_;
					gboolean _tmp1066_;
					ValaLocalVariable* _tmp1067_;
					ValaLocalVariable* _tmp1068_;
					ValaExpression* _tmp1069_;
					ValaLocalVariable* _tmp1070_;
					const gchar* _tmp1071_;
					const gchar* _tmp1072_;
					ValaCCodeExpression* _tmp1073_;
					ValaCCodeExpression* _tmp1074_;
					ValaExpression* _tmp1075_;
					ValaTargetValue* _tmp1076_;
					ValaTargetValue* _tmp1077_;
					ValaExpression* _tmp1078_;
					ValaDataType* _tmp1079_;
					ValaDataType* _tmp1080_;
					ValaExpression* _tmp1081_;
					ValaCCodeExpression* _tmp1082_;
					ValaCCodeExpression* _tmp1083_;
					ValaCCodeUnaryExpression* _tmp1084_;
					gboolean _tmp1085_ = FALSE;
					gboolean _tmp1086_ = FALSE;
					ValaParameter* _tmp1087_;
					_tmp1058_ = arg;
					vala_expression_set_target_value (_tmp1058_, NULL);
					_tmp1059_ = param;
					_tmp1060_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1059_);
					_tmp1061_ = _tmp1060_;
					_tmp1062_ = param;
					_tmp1063_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1062_);
					_tmp1064_ = _tmp1063_;
					_tmp1065_ = vala_data_type_get_value_owned (_tmp1064_);
					_tmp1066_ = _tmp1065_;
					_tmp1067_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1061_, _tmp1066_, NULL, TRUE);
					temp_var = _tmp1067_;
					_tmp1068_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1068_, FALSE);
					_tmp1069_ = arg;
					_tmp1070_ = temp_var;
					_tmp1071_ = vala_symbol_get_name ((ValaSymbol*) _tmp1070_);
					_tmp1072_ = _tmp1071_;
					_tmp1073_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1072_);
					_tmp1074_ = _tmp1073_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1069_, _tmp1074_);
					_vala_ccode_node_unref0 (_tmp1074_);
					_tmp1075_ = arg;
					_tmp1076_ = vala_expression_get_target_value (_tmp1075_);
					_tmp1077_ = _tmp1076_;
					_tmp1078_ = arg;
					_tmp1079_ = vala_expression_get_target_type (_tmp1078_);
					_tmp1080_ = _tmp1079_;
					vala_target_value_set_value_type (_tmp1077_, _tmp1080_);
					_tmp1081_ = arg;
					_tmp1082_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1081_);
					_tmp1083_ = _tmp1082_;
					_tmp1084_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1083_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1084_;
					_vala_ccode_node_unref0 (_tmp1083_);
					_tmp1087_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1087_)) {
						ValaParameter* _tmp1088_;
						ValaDataType* _tmp1089_;
						ValaDataType* _tmp1090_;
						_tmp1088_ = param;
						_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
						_tmp1090_ = _tmp1089_;
						_tmp1086_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1090_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1086_ = FALSE;
					}
					if (_tmp1086_) {
						ValaParameter* _tmp1091_;
						ValaDataType* _tmp1092_;
						ValaDataType* _tmp1093_;
						gboolean _tmp1094_;
						gboolean _tmp1095_;
						_tmp1091_ = param;
						_tmp1092_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1091_);
						_tmp1093_ = _tmp1092_;
						_tmp1094_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1093_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1095_ = _tmp1094_;
						_tmp1085_ = !_tmp1095_;
					} else {
						_tmp1085_ = FALSE;
					}
					if (_tmp1085_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1096_;
						ValaDataType* _tmp1097_;
						ValaDataType* _tmp1098_;
						ValaArrayType* _tmp1099_;
						gchar* _tmp1100_ = NULL;
						ValaParameter* _tmp1101_;
						gchar* _tmp1102_;
						gchar* length_ctype = NULL;
						gchar* _tmp1105_;
						_tmp1096_ = param;
						_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
						_tmp1098_ = _tmp1097_;
						_tmp1099_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1098_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1099_;
						_tmp1101_ = param;
						_tmp1102_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1101_);
						_tmp1100_ = _tmp1102_;
						if (_tmp1100_ == NULL) {
							ValaArrayType* _tmp1103_;
							gchar* _tmp1104_;
							_tmp1103_ = array_type;
							_tmp1104_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1103_);
							_g_free0 (_tmp1100_);
							_tmp1100_ = _tmp1104_;
						}
						_tmp1105_ = g_strdup (_tmp1100_);
						length_ctype = _tmp1105_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1106_ = FALSE;
								_tmp1106_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1108_;
									gint _tmp1109_;
									gint _tmp1110_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1111_;
									ValaCType* _tmp1112_;
									ValaCType* _tmp1113_;
									ValaLocalVariable* _tmp1114_;
									ValaLocalVariable* _tmp1115_;
									ValaLocalVariable* _tmp1116_;
									ValaExpression* _tmp1117_;
									ValaLocalVariable* _tmp1118_;
									const gchar* _tmp1119_;
									const gchar* _tmp1120_;
									ValaCCodeExpression* _tmp1121_;
									ValaCCodeExpression* _tmp1122_;
									ValaHashMap* _tmp1123_;
									ValaParameter* _tmp1124_;
									ValaExpression* _tmp1125_;
									ValaList* _tmp1126_;
									ValaList* _tmp1127_;
									gpointer _tmp1128_;
									ValaCCodeExpression* _tmp1129_;
									ValaCCodeUnaryExpression* _tmp1130_;
									ValaCCodeUnaryExpression* _tmp1131_;
									if (!_tmp1106_) {
										gint _tmp1107_;
										_tmp1107_ = dim;
										dim = _tmp1107_ + 1;
									}
									_tmp1106_ = FALSE;
									_tmp1108_ = array_type;
									_tmp1109_ = vala_array_type_get_rank (_tmp1108_);
									_tmp1110_ = _tmp1109_;
									if (!(dim <= _tmp1110_)) {
										break;
									}
									_tmp1111_ = length_ctype;
									_tmp1112_ = vala_ctype_new (_tmp1111_, "0");
									_tmp1113_ = _tmp1112_;
									_tmp1114_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1113_, TRUE, NULL, TRUE);
									_tmp1115_ = _tmp1114_;
									_vala_code_node_unref0 (_tmp1113_);
									temp_array_length = _tmp1115_;
									_tmp1116_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1116_, FALSE);
									_tmp1117_ = arg;
									_tmp1118_ = temp_array_length;
									_tmp1119_ = vala_symbol_get_name ((ValaSymbol*) _tmp1118_);
									_tmp1120_ = _tmp1119_;
									_tmp1121_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1120_);
									_tmp1122_ = _tmp1121_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1117_, _tmp1122_);
									_vala_ccode_node_unref0 (_tmp1122_);
									_tmp1123_ = carg_map;
									_tmp1124_ = param;
									_tmp1125_ = arg;
									_tmp1126_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1125_);
									_tmp1127_ = _tmp1126_;
									_tmp1128_ = vala_list_get (_tmp1127_, dim - 1);
									_tmp1129_ = (ValaCCodeExpression*) _tmp1128_;
									_tmp1130_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1129_);
									_tmp1131_ = _tmp1130_;
									vala_map_set ((ValaMap*) _tmp1123_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1124_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1131_);
									_vala_ccode_node_unref0 (_tmp1131_);
									_vala_ccode_node_unref0 (_tmp1129_);
									_vala_iterable_unref0 (_tmp1127_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1100_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1132_;
						ValaDataType* _tmp1133_;
						ValaDataType* _tmp1134_;
						_tmp1132_ = param;
						_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
						_tmp1134_ = _tmp1133_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1134_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1135_;
							ValaDataType* _tmp1136_;
							ValaDataType* _tmp1137_;
							ValaDelegateType* _tmp1138_;
							ValaDelegateType* _tmp1139_;
							ValaDelegate* _tmp1140_;
							ValaDelegate* _tmp1141_;
							gboolean _tmp1142_;
							gboolean _tmp1143_;
							_tmp1135_ = param;
							_tmp1136_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1135_);
							_tmp1137_ = _tmp1136_;
							_tmp1138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1137_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1138_;
							_tmp1139_ = deleg_type;
							_tmp1140_ = vala_delegate_type_get_delegate_symbol (_tmp1139_);
							_tmp1141_ = _tmp1140_;
							_tmp1142_ = vala_delegate_get_has_target (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							if (_tmp1143_) {
								ValaVoidType* _tmp1144_;
								ValaVoidType* _tmp1145_;
								ValaPointerType* _tmp1146_;
								ValaPointerType* _tmp1147_;
								ValaLocalVariable* _tmp1148_;
								ValaLocalVariable* _tmp1149_;
								ValaExpression* _tmp1150_;
								ValaLocalVariable* _tmp1151_;
								const gchar* _tmp1152_;
								const gchar* _tmp1153_;
								ValaCCodeExpression* _tmp1154_;
								ValaCCodeExpression* _tmp1155_;
								ValaHashMap* _tmp1156_;
								ValaParameter* _tmp1157_;
								ValaExpression* _tmp1158_;
								ValaCCodeExpression* _tmp1159_;
								ValaCCodeExpression* _tmp1160_;
								ValaCCodeUnaryExpression* _tmp1161_;
								ValaCCodeUnaryExpression* _tmp1162_;
								ValaDelegateType* _tmp1163_;
								_tmp1144_ = vala_void_type_new (NULL);
								_tmp1145_ = _tmp1144_;
								_tmp1146_ = vala_pointer_type_new ((ValaDataType*) _tmp1145_, NULL);
								_tmp1147_ = _tmp1146_;
								_tmp1148_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1147_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1148_;
								_vala_code_node_unref0 (_tmp1147_);
								_vala_code_node_unref0 (_tmp1145_);
								_tmp1149_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1149_, FALSE);
								_tmp1150_ = arg;
								_tmp1151_ = temp_var;
								_tmp1152_ = vala_symbol_get_name ((ValaSymbol*) _tmp1151_);
								_tmp1153_ = _tmp1152_;
								_tmp1154_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1153_);
								_tmp1155_ = _tmp1154_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1150_, _tmp1155_);
								_vala_ccode_node_unref0 (_tmp1155_);
								_tmp1156_ = carg_map;
								_tmp1157_ = param;
								_tmp1158_ = arg;
								_tmp1159_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1158_);
								_tmp1160_ = _tmp1159_;
								_tmp1161_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1160_);
								_tmp1162_ = _tmp1161_;
								vala_map_set ((ValaMap*) _tmp1156_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1157_), FALSE)), (ValaCCodeExpression*) _tmp1162_);
								_vala_ccode_node_unref0 (_tmp1162_);
								_vala_ccode_node_unref0 (_tmp1160_);
								_tmp1163_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1163_)) {
									ValaDataType* _tmp1164_;
									ValaLocalVariable* _tmp1165_;
									ValaLocalVariable* _tmp1166_;
									ValaExpression* _tmp1167_;
									ValaLocalVariable* _tmp1168_;
									const gchar* _tmp1169_;
									const gchar* _tmp1170_;
									ValaCCodeExpression* _tmp1171_;
									ValaCCodeExpression* _tmp1172_;
									ValaHashMap* _tmp1173_;
									ValaParameter* _tmp1174_;
									ValaExpression* _tmp1175_;
									ValaCCodeExpression* _tmp1176_;
									ValaCCodeExpression* _tmp1177_;
									ValaCCodeUnaryExpression* _tmp1178_;
									ValaCCodeUnaryExpression* _tmp1179_;
									_tmp1164_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1165_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1164_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1165_;
									_tmp1166_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1166_, FALSE);
									_tmp1167_ = arg;
									_tmp1168_ = temp_var;
									_tmp1169_ = vala_symbol_get_name ((ValaSymbol*) _tmp1168_);
									_tmp1170_ = _tmp1169_;
									_tmp1171_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1170_);
									_tmp1172_ = _tmp1171_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1167_, _tmp1172_);
									_vala_ccode_node_unref0 (_tmp1172_);
									_tmp1173_ = carg_map;
									_tmp1174_ = param;
									_tmp1175_ = arg;
									_tmp1176_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1175_);
									_tmp1177_ = _tmp1176_;
									_tmp1178_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1177_);
									_tmp1179_ = _tmp1178_;
									vala_map_set ((ValaMap*) _tmp1173_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1174_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1179_);
									_vala_ccode_node_unref0 (_tmp1179_);
									_vala_ccode_node_unref0 (_tmp1177_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1180_ = param;
				_tmp1181_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1180_);
				_tmp1182_ = _tmp1181_;
				_tmp1183_ = _tmp1182_ != NULL;
				_g_free0 (_tmp1182_);
				if (_tmp1183_) {
					ValaCCodeExpression* _tmp1184_;
					ValaParameter* _tmp1185_;
					gchar* _tmp1186_;
					gchar* _tmp1187_;
					ValaCCodeCastExpression* _tmp1188_;
					_tmp1184_ = cexpr;
					_tmp1185_ = param;
					_tmp1186_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1185_);
					_tmp1187_ = _tmp1186_;
					_tmp1188_ = vala_ccode_cast_expression_new (_tmp1184_, _tmp1187_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1188_;
					_g_free0 (_tmp1187_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1189_;
				ValaUnaryExpression* _tmp1190_;
				gboolean _tmp1191_ = FALSE;
				gboolean _tmp1192_ = FALSE;
				_tmp1189_ = arg;
				_tmp1190_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1189_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1189_) : NULL);
				unary = _tmp1190_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1193_;
					_tmp1193_ = unary;
					_tmp1192_ = _tmp1193_ != NULL;
				} else {
					_tmp1192_ = FALSE;
				}
				if (_tmp1192_) {
					ValaUnaryExpression* _tmp1194_;
					ValaUnaryOperator _tmp1195_;
					ValaUnaryOperator _tmp1196_;
					_tmp1194_ = unary;
					_tmp1195_ = vala_unary_expression_get_operator (_tmp1194_);
					_tmp1196_ = _tmp1195_;
					_tmp1191_ = _tmp1196_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1191_ = FALSE;
				}
				if (_tmp1191_) {
					ValaHashMap* _tmp1197_;
					ValaHashMap* _tmp1198_;
					ValaExpression* _tmp1199_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1200_;
					ValaDataType* _tmp1201_;
					ValaDataType* _tmp1202_;
					ValaExpression* _tmp1203_;
					ValaDataType* _tmp1204_;
					ValaDataType* _tmp1205_;
					gboolean _tmp1206_;
					gboolean _tmp1207_;
					ValaLocalVariable* _tmp1208_;
					ValaLocalVariable* _tmp1209_;
					ValaExpression* _tmp1210_;
					ValaLocalVariable* _tmp1211_;
					const gchar* _tmp1212_;
					const gchar* _tmp1213_;
					ValaCCodeExpression* _tmp1214_;
					ValaCCodeExpression* _tmp1215_;
					ValaExpression* _tmp1216_;
					ValaTargetValue* _tmp1217_;
					ValaTargetValue* _tmp1218_;
					ValaExpression* _tmp1219_;
					ValaDataType* _tmp1220_;
					ValaDataType* _tmp1221_;
					ValaExpression* _tmp1222_;
					ValaCCodeExpression* _tmp1223_;
					ValaCCodeExpression* _tmp1224_;
					ValaCCodeUnaryExpression* _tmp1225_;
					_tmp1197_ = out_arg_map;
					_tmp1198_ = _vala_map_ref0 (_tmp1197_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1198_;
					_tmp1199_ = arg;
					vala_expression_set_target_value (_tmp1199_, NULL);
					_tmp1200_ = arg;
					_tmp1201_ = vala_expression_get_value_type (_tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = arg;
					_tmp1204_ = vala_expression_get_value_type (_tmp1203_);
					_tmp1205_ = _tmp1204_;
					_tmp1206_ = vala_data_type_get_value_owned (_tmp1205_);
					_tmp1207_ = _tmp1206_;
					_tmp1208_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1202_, _tmp1207_, NULL, TRUE);
					temp_var = _tmp1208_;
					_tmp1209_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1209_, FALSE);
					_tmp1210_ = arg;
					_tmp1211_ = temp_var;
					_tmp1212_ = vala_symbol_get_name ((ValaSymbol*) _tmp1211_);
					_tmp1213_ = _tmp1212_;
					_tmp1214_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1213_);
					_tmp1215_ = _tmp1214_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1210_, _tmp1215_);
					_vala_ccode_node_unref0 (_tmp1215_);
					_tmp1216_ = arg;
					_tmp1217_ = vala_expression_get_target_value (_tmp1216_);
					_tmp1218_ = _tmp1217_;
					_tmp1219_ = arg;
					_tmp1220_ = vala_expression_get_value_type (_tmp1219_);
					_tmp1221_ = _tmp1220_;
					vala_target_value_set_value_type (_tmp1218_, _tmp1221_);
					_tmp1222_ = arg;
					_tmp1223_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1222_);
					_tmp1224_ = _tmp1223_;
					_tmp1225_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1224_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1225_;
					_vala_ccode_node_unref0 (_tmp1224_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1226_;
					ValaCCodeExpression* _tmp1227_;
					ValaCCodeExpression* _tmp1228_;
					_tmp1226_ = arg;
					_tmp1227_ = cexpr;
					_tmp1228_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1226_, _tmp1227_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1228_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1230_ = param;
			if (_tmp1230_ != NULL) {
				ValaParameter* _tmp1231_;
				_tmp1231_ = param;
				_tmp1229_ = vala_get_ccode_pos (_tmp1231_);
			} else {
				_tmp1229_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1229_, ellipsis);
			_tmp1232_ = carg_map;
			_tmp1233_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1232_, (gpointer) ((gintptr) arg_pos), _tmp1233_);
			_tmp1235_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1235_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1234_ = ellipsis;
			} else {
				_tmp1234_ = FALSE;
			}
			if (_tmp1234_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1236_;
				ValaNamedArgument* _tmp1237_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1238_;
				const gchar* _tmp1239_;
				const gchar* _tmp1240_;
				gchar** _tmp1241_;
				gchar** _tmp1242_;
				gchar** _tmp1243_;
				gint _tmp1243__length1;
				gchar* _tmp1244_;
				gchar* _tmp1245_;
				ValaHashMap* _tmp1246_;
				const gchar* _tmp1247_;
				gchar* _tmp1248_;
				gchar* _tmp1249_;
				ValaCCodeConstant* _tmp1250_;
				ValaCCodeConstant* _tmp1251_;
				_tmp1236_ = arg;
				_tmp1237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1236_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1237_;
				_tmp1238_ = named_arg;
				_tmp1239_ = vala_named_argument_get_name (_tmp1238_);
				_tmp1240_ = _tmp1239_;
				_tmp1242_ = _tmp1241_ = g_strsplit (_tmp1240_, "_", 0);
				_tmp1243_ = _tmp1242_;
				_tmp1243__length1 = _vala_array_length (_tmp1241_);
				_tmp1244_ = _vala_g_strjoinv ("-", _tmp1243_, (gint) _vala_array_length (_tmp1241_));
				_tmp1245_ = _tmp1244_;
				_tmp1243_ = (_vala_array_free (_tmp1243_, _tmp1243__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1245_;
				_tmp1246_ = carg_map;
				_tmp1247_ = name;
				_tmp1248_ = g_strdup_printf ("\"%s\"", _tmp1247_);
				_tmp1249_ = _tmp1248_;
				_tmp1250_ = vala_ccode_constant_new (_tmp1249_);
				_tmp1251_ = _tmp1250_;
				vala_map_set ((ValaMap*) _tmp1246_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1251_);
				_vala_ccode_node_unref0 (_tmp1251_);
				_g_free0 (_tmp1249_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1252_ = i;
			i = _tmp1252_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1253_ = params_it;
	if (vala_iterator_next (_tmp1253_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1254_;
		gpointer _tmp1255_;
		gboolean _tmp1256_ = FALSE;
		ValaParameter* _tmp1257_;
		gboolean _tmp1258_;
		gboolean _tmp1259_;
		_tmp1254_ = params_it;
		_tmp1255_ = vala_iterator_get (_tmp1254_);
		param = (ValaParameter*) _tmp1255_;
		_tmp1257_ = param;
		_tmp1258_ = vala_parameter_get_params_array (_tmp1257_);
		_tmp1259_ = _tmp1258_;
		if (_tmp1259_) {
			_tmp1256_ = TRUE;
		} else {
			ValaParameter* _tmp1260_;
			gboolean _tmp1261_;
			gboolean _tmp1262_;
			_tmp1260_ = param;
			_tmp1261_ = vala_parameter_get_ellipsis (_tmp1260_);
			_tmp1262_ = _tmp1261_;
			_tmp1256_ = _tmp1262_;
		}
		_vala_assert (_tmp1256_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1265_ = m;
	if (_tmp1265_ != NULL) {
		ValaMethod* _tmp1266_;
		ValaDataType* _tmp1267_;
		ValaDataType* _tmp1268_;
		_tmp1266_ = m;
		_tmp1267_ = vala_callable_get_return_type ((ValaCallable*) _tmp1266_);
		_tmp1268_ = _tmp1267_;
		_tmp1264_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1268_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1264_ = FALSE;
	}
	if (_tmp1264_) {
		ValaCCodeFunctionCall* _tmp1269_;
		ValaCCodeFunctionCall* _tmp1270_;
		_tmp1269_ = async_call;
		_tmp1270_ = ccall;
		_tmp1263_ = _tmp1269_ != _tmp1270_;
	} else {
		_tmp1263_ = FALSE;
	}
	if (_tmp1263_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1271_;
		ValaDataType* _tmp1272_;
		ValaDataType* _tmp1273_;
		ValaArrayType* _tmp1274_;
		_tmp1271_ = m;
		_tmp1272_ = vala_callable_get_return_type ((ValaCallable*) _tmp1271_);
		_tmp1273_ = _tmp1272_;
		_tmp1274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1273_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1274_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1275_ = FALSE;
				_tmp1275_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1277_;
					gint _tmp1278_;
					gint _tmp1279_;
					ValaMethod* _tmp1280_;
					if (!_tmp1275_) {
						gint _tmp1276_;
						_tmp1276_ = dim;
						dim = _tmp1276_ + 1;
					}
					_tmp1275_ = FALSE;
					_tmp1277_ = array_type;
					_tmp1278_ = vala_array_type_get_rank (_tmp1277_);
					_tmp1279_ = _tmp1278_;
					if (!(dim <= _tmp1279_)) {
						break;
					}
					_tmp1280_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1280_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1281_;
						ValaDataType* _tmp1282_;
						ValaDataType* _tmp1283_;
						ValaLocalVariable* _tmp1284_;
						ValaLocalVariable* _tmp1285_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1286_;
						const gchar* _tmp1287_;
						const gchar* _tmp1288_;
						ValaCCodeExpression* _tmp1289_;
						ValaLocalVariable* _tmp1290_;
						ValaCCodeExpression* _tmp1291_;
						ValaCCodeExpression* _tmp1292_;
						ValaCCodeAssignment* _tmp1293_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1294_;
						ValaCCodeIdentifier* _tmp1295_;
						ValaCCodeFunctionCall* _tmp1296_;
						ValaCCodeFunctionCall* _tmp1297_;
						ValaCCodeFunctionCall* _tmp1298_;
						ValaCCodeExpression* _tmp1299_;
						ValaCCodeFunctionCall* _tmp1300_;
						_tmp1281_ = itype;
						_tmp1282_ = vala_data_type_get_return_type (_tmp1281_);
						_tmp1283_ = _tmp1282_;
						_tmp1284_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1283_, TRUE, NULL, FALSE);
						_tmp1285_ = _tmp1284_;
						_vala_code_node_unref0 (_tmp1283_);
						temp_var = _tmp1285_;
						_tmp1286_ = temp_var;
						_tmp1287_ = vala_symbol_get_name ((ValaSymbol*) _tmp1286_);
						_tmp1288_ = _tmp1287_;
						_tmp1289_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1288_);
						temp_ref = _tmp1289_;
						_tmp1290_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1290_, FALSE);
						_tmp1291_ = temp_ref;
						_tmp1292_ = ccall_expr;
						_tmp1293_ = vala_ccode_assignment_new (_tmp1291_, _tmp1292_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1293_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1294_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1295_ = _tmp1294_;
						_tmp1296_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1295_);
						_tmp1297_ = _tmp1296_;
						_vala_ccode_node_unref0 (_tmp1295_);
						len_call = _tmp1297_;
						_tmp1298_ = len_call;
						_tmp1299_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1298_, _tmp1299_);
						_tmp1300_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1300_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1301_;
						_tmp1301_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1301_)) {
							gchar* _tmp1302_ = NULL;
							ValaMethod* _tmp1303_;
							gchar* _tmp1304_;
							gchar* length_ctype = NULL;
							gchar* _tmp1307_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1308_;
							ValaCType* _tmp1309_;
							ValaCType* _tmp1310_;
							ValaLocalVariable* _tmp1311_;
							ValaLocalVariable* _tmp1312_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1313_;
							const gchar* _tmp1314_;
							const gchar* _tmp1315_;
							ValaCCodeExpression* _tmp1316_;
							ValaLocalVariable* _tmp1317_;
							ValaHashMap* _tmp1318_;
							ValaMethod* _tmp1319_;
							ValaCCodeExpression* _tmp1320_;
							ValaCCodeUnaryExpression* _tmp1321_;
							ValaCCodeUnaryExpression* _tmp1322_;
							ValaCCodeExpression* _tmp1323_;
							_tmp1303_ = m;
							_tmp1304_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1303_);
							_tmp1302_ = _tmp1304_;
							if (_tmp1302_ == NULL) {
								ValaArrayType* _tmp1305_;
								gchar* _tmp1306_;
								_tmp1305_ = array_type;
								_tmp1306_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1305_);
								_g_free0 (_tmp1302_);
								_tmp1302_ = _tmp1306_;
							}
							_tmp1307_ = g_strdup (_tmp1302_);
							length_ctype = _tmp1307_;
							_tmp1308_ = length_ctype;
							_tmp1309_ = vala_ctype_new (_tmp1308_, "0");
							_tmp1310_ = _tmp1309_;
							_tmp1311_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1310_, TRUE, NULL, TRUE);
							_tmp1312_ = _tmp1311_;
							_vala_code_node_unref0 (_tmp1310_);
							temp_var = _tmp1312_;
							_tmp1313_ = temp_var;
							_tmp1314_ = vala_symbol_get_name ((ValaSymbol*) _tmp1313_);
							_tmp1315_ = _tmp1314_;
							_tmp1316_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1315_);
							temp_ref = _tmp1316_;
							_tmp1317_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1317_, FALSE);
							_tmp1318_ = out_arg_map;
							_tmp1319_ = m;
							_tmp1320_ = temp_ref;
							_tmp1321_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1320_);
							_tmp1322_ = _tmp1321_;
							vala_map_set ((ValaMap*) _tmp1318_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1319_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1322_);
							_vala_ccode_node_unref0 (_tmp1322_);
							_tmp1323_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1323_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1302_);
						} else {
							ValaMethod* _tmp1324_;
							gchar* _tmp1325_;
							gchar* _tmp1326_;
							gboolean _tmp1327_;
							_tmp1324_ = m;
							_tmp1325_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1324_);
							_tmp1326_ = _tmp1325_;
							_tmp1327_ = _tmp1326_ != NULL;
							_g_free0 (_tmp1326_);
							if (_tmp1327_) {
								ValaMethod* _tmp1328_;
								gchar* _tmp1329_;
								gchar* _tmp1330_;
								ValaCCodeConstant* _tmp1331_;
								ValaCCodeConstant* _tmp1332_;
								_tmp1328_ = m;
								_tmp1329_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1328_);
								_tmp1330_ = _tmp1329_;
								_tmp1331_ = vala_ccode_constant_new (_tmp1330_);
								_tmp1332_ = _tmp1331_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1332_);
								_vala_ccode_node_unref0 (_tmp1332_);
								_g_free0 (_tmp1330_);
							} else {
								ValaCCodeConstant* _tmp1333_;
								ValaCCodeConstant* _tmp1334_;
								_tmp1333_ = vala_ccode_constant_new ("-1");
								_tmp1334_ = _tmp1333_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1334_);
								_vala_ccode_node_unref0 (_tmp1334_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1335_ = FALSE;
		gboolean _tmp1336_ = FALSE;
		ValaMethod* _tmp1337_;
		_tmp1337_ = m;
		if (_tmp1337_ != NULL) {
			ValaMethod* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaDataType* _tmp1340_;
			_tmp1338_ = m;
			_tmp1339_ = vala_callable_get_return_type ((ValaCallable*) _tmp1338_);
			_tmp1340_ = _tmp1339_;
			_tmp1336_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1340_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1336_ = FALSE;
		}
		if (_tmp1336_) {
			ValaCCodeFunctionCall* _tmp1341_;
			ValaCCodeFunctionCall* _tmp1342_;
			_tmp1341_ = async_call;
			_tmp1342_ = ccall;
			_tmp1335_ = _tmp1341_ != _tmp1342_;
		} else {
			_tmp1335_ = FALSE;
		}
		if (_tmp1335_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1343_;
			ValaDataType* _tmp1344_;
			ValaDataType* _tmp1345_;
			ValaDelegateType* _tmp1346_;
			ValaDelegateType* _tmp1347_;
			ValaDelegate* _tmp1348_;
			ValaDelegate* _tmp1349_;
			gboolean _tmp1350_;
			gboolean _tmp1351_;
			_tmp1343_ = m;
			_tmp1344_ = vala_callable_get_return_type ((ValaCallable*) _tmp1343_);
			_tmp1345_ = _tmp1344_;
			_tmp1346_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1345_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1346_;
			_tmp1347_ = deleg_type;
			_tmp1348_ = vala_delegate_type_get_delegate_symbol (_tmp1347_);
			_tmp1349_ = _tmp1348_;
			_tmp1350_ = vala_delegate_get_has_target (_tmp1349_);
			_tmp1351_ = _tmp1350_;
			if (_tmp1351_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1352_;
				ValaVoidType* _tmp1353_;
				ValaPointerType* _tmp1354_;
				ValaPointerType* _tmp1355_;
				ValaLocalVariable* _tmp1356_;
				ValaLocalVariable* _tmp1357_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1358_;
				const gchar* _tmp1359_;
				const gchar* _tmp1360_;
				ValaCCodeExpression* _tmp1361_;
				ValaLocalVariable* _tmp1362_;
				ValaHashMap* _tmp1363_;
				ValaMethod* _tmp1364_;
				ValaCCodeExpression* _tmp1365_;
				ValaCCodeUnaryExpression* _tmp1366_;
				ValaCCodeUnaryExpression* _tmp1367_;
				ValaCCodeExpression* _tmp1368_;
				ValaDelegateType* _tmp1369_;
				_tmp1352_ = vala_void_type_new (NULL);
				_tmp1353_ = _tmp1352_;
				_tmp1354_ = vala_pointer_type_new ((ValaDataType*) _tmp1353_, NULL);
				_tmp1355_ = _tmp1354_;
				_tmp1356_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1355_, TRUE, NULL, TRUE);
				_tmp1357_ = _tmp1356_;
				_vala_code_node_unref0 (_tmp1355_);
				_vala_code_node_unref0 (_tmp1353_);
				temp_var = _tmp1357_;
				_tmp1358_ = temp_var;
				_tmp1359_ = vala_symbol_get_name ((ValaSymbol*) _tmp1358_);
				_tmp1360_ = _tmp1359_;
				_tmp1361_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1360_);
				temp_ref = _tmp1361_;
				_tmp1362_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1362_, FALSE);
				_tmp1363_ = out_arg_map;
				_tmp1364_ = m;
				_tmp1365_ = temp_ref;
				_tmp1366_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1365_);
				_tmp1367_ = _tmp1366_;
				vala_map_set ((ValaMap*) _tmp1363_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1364_), FALSE)), (ValaCCodeExpression*) _tmp1367_);
				_vala_ccode_node_unref0 (_tmp1367_);
				_tmp1368_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1368_);
				_tmp1369_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1369_)) {
					ValaDataType* _tmp1370_;
					ValaLocalVariable* _tmp1371_;
					ValaLocalVariable* _tmp1372_;
					const gchar* _tmp1373_;
					const gchar* _tmp1374_;
					ValaCCodeExpression* _tmp1375_;
					ValaLocalVariable* _tmp1376_;
					ValaHashMap* _tmp1377_;
					ValaMethod* _tmp1378_;
					ValaCCodeExpression* _tmp1379_;
					ValaCCodeUnaryExpression* _tmp1380_;
					ValaCCodeUnaryExpression* _tmp1381_;
					ValaCCodeExpression* _tmp1382_;
					_tmp1370_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1371_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1370_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1371_;
					_tmp1372_ = temp_var;
					_tmp1373_ = vala_symbol_get_name ((ValaSymbol*) _tmp1372_);
					_tmp1374_ = _tmp1373_;
					_tmp1375_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1374_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1375_;
					_tmp1376_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1376_, FALSE);
					_tmp1377_ = out_arg_map;
					_tmp1378_ = m;
					_tmp1379_ = temp_ref;
					_tmp1380_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1379_);
					_tmp1381_ = _tmp1380_;
					vala_map_set ((ValaMap*) _tmp1377_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1378_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1381_);
					_vala_ccode_node_unref0 (_tmp1381_);
					_tmp1382_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1382_);
				} else {
					ValaCCodeConstant* _tmp1383_;
					ValaCCodeConstant* _tmp1384_;
					_tmp1383_ = vala_ccode_constant_new ("NULL");
					_tmp1384_ = _tmp1383_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1384_);
					_vala_ccode_node_unref0 (_tmp1384_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1385_;
				ValaCCodeConstant* _tmp1386_;
				_tmp1385_ = vala_ccode_constant_new ("NULL");
				_tmp1386_ = _tmp1385_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1386_);
				_vala_ccode_node_unref0 (_tmp1386_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1388_ = deleg;
	if (_tmp1388_ != NULL) {
		ValaDelegate* _tmp1389_;
		ValaDataType* _tmp1390_;
		ValaDataType* _tmp1391_;
		_tmp1389_ = deleg;
		_tmp1390_ = vala_callable_get_return_type ((ValaCallable*) _tmp1389_);
		_tmp1391_ = _tmp1390_;
		_tmp1387_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1391_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1387_ = FALSE;
	}
	if (_tmp1387_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1392_;
		ValaDataType* _tmp1393_;
		ValaDataType* _tmp1394_;
		ValaArrayType* _tmp1395_;
		_tmp1392_ = deleg;
		_tmp1393_ = vala_callable_get_return_type ((ValaCallable*) _tmp1392_);
		_tmp1394_ = _tmp1393_;
		_tmp1395_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1394_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1395_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1396_ = FALSE;
				_tmp1396_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1398_;
					gint _tmp1399_;
					gint _tmp1400_;
					ValaDelegate* _tmp1401_;
					if (!_tmp1396_) {
						gint _tmp1397_;
						_tmp1397_ = dim;
						dim = _tmp1397_ + 1;
					}
					_tmp1396_ = FALSE;
					_tmp1398_ = array_type;
					_tmp1399_ = vala_array_type_get_rank (_tmp1398_);
					_tmp1400_ = _tmp1399_;
					if (!(dim <= _tmp1400_)) {
						break;
					}
					_tmp1401_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1401_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1402_;
						ValaDataType* _tmp1403_;
						ValaDataType* _tmp1404_;
						ValaLocalVariable* _tmp1405_;
						ValaLocalVariable* _tmp1406_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1407_;
						const gchar* _tmp1408_;
						const gchar* _tmp1409_;
						ValaCCodeExpression* _tmp1410_;
						ValaLocalVariable* _tmp1411_;
						ValaCCodeExpression* _tmp1412_;
						ValaCCodeExpression* _tmp1413_;
						ValaCCodeAssignment* _tmp1414_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1415_;
						ValaCCodeIdentifier* _tmp1416_;
						ValaCCodeFunctionCall* _tmp1417_;
						ValaCCodeFunctionCall* _tmp1418_;
						ValaCCodeFunctionCall* _tmp1419_;
						ValaCCodeExpression* _tmp1420_;
						ValaCCodeFunctionCall* _tmp1421_;
						_tmp1402_ = itype;
						_tmp1403_ = vala_data_type_get_return_type (_tmp1402_);
						_tmp1404_ = _tmp1403_;
						_tmp1405_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1404_, TRUE, NULL, FALSE);
						_tmp1406_ = _tmp1405_;
						_vala_code_node_unref0 (_tmp1404_);
						temp_var = _tmp1406_;
						_tmp1407_ = temp_var;
						_tmp1408_ = vala_symbol_get_name ((ValaSymbol*) _tmp1407_);
						_tmp1409_ = _tmp1408_;
						_tmp1410_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1409_);
						temp_ref = _tmp1410_;
						_tmp1411_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1411_, FALSE);
						_tmp1412_ = temp_ref;
						_tmp1413_ = ccall_expr;
						_tmp1414_ = vala_ccode_assignment_new (_tmp1412_, _tmp1413_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1414_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1415_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1416_ = _tmp1415_;
						_tmp1417_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1416_);
						_tmp1418_ = _tmp1417_;
						_vala_ccode_node_unref0 (_tmp1416_);
						len_call = _tmp1418_;
						_tmp1419_ = len_call;
						_tmp1420_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1419_, _tmp1420_);
						_tmp1421_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1421_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1422_;
						_tmp1422_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1422_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1423_;
							ValaDataType* _tmp1424_;
							ValaDataType* _tmp1425_;
							ValaLocalVariable* _tmp1426_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1427_;
							const gchar* _tmp1428_;
							const gchar* _tmp1429_;
							ValaCCodeExpression* _tmp1430_;
							ValaLocalVariable* _tmp1431_;
							ValaHashMap* _tmp1432_;
							ValaDelegate* _tmp1433_;
							ValaCCodeExpression* _tmp1434_;
							ValaCCodeUnaryExpression* _tmp1435_;
							ValaCCodeUnaryExpression* _tmp1436_;
							ValaCCodeExpression* _tmp1437_;
							_tmp1423_ = array_type;
							_tmp1424_ = vala_array_type_get_length_type (_tmp1423_);
							_tmp1425_ = _tmp1424_;
							_tmp1426_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1425_, TRUE, NULL, TRUE);
							temp_var = _tmp1426_;
							_tmp1427_ = temp_var;
							_tmp1428_ = vala_symbol_get_name ((ValaSymbol*) _tmp1427_);
							_tmp1429_ = _tmp1428_;
							_tmp1430_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1429_);
							temp_ref = _tmp1430_;
							_tmp1431_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1431_, FALSE);
							_tmp1432_ = out_arg_map;
							_tmp1433_ = deleg;
							_tmp1434_ = temp_ref;
							_tmp1435_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1434_);
							_tmp1436_ = _tmp1435_;
							vala_map_set ((ValaMap*) _tmp1432_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1433_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1436_);
							_vala_ccode_node_unref0 (_tmp1436_);
							_tmp1437_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1437_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1438_;
							ValaCCodeConstant* _tmp1439_;
							_tmp1438_ = vala_ccode_constant_new ("-1");
							_tmp1439_ = _tmp1438_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1439_);
							_vala_ccode_node_unref0 (_tmp1439_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1440_ = FALSE;
		ValaDelegate* _tmp1441_;
		_tmp1441_ = deleg;
		if (_tmp1441_ != NULL) {
			ValaDelegate* _tmp1442_;
			ValaDataType* _tmp1443_;
			ValaDataType* _tmp1444_;
			_tmp1442_ = deleg;
			_tmp1443_ = vala_callable_get_return_type ((ValaCallable*) _tmp1442_);
			_tmp1444_ = _tmp1443_;
			_tmp1440_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1444_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1440_ = FALSE;
		}
		if (_tmp1440_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1445_;
			ValaDataType* _tmp1446_;
			ValaDataType* _tmp1447_;
			ValaDelegateType* _tmp1448_;
			ValaDelegateType* _tmp1449_;
			ValaDelegate* _tmp1450_;
			ValaDelegate* _tmp1451_;
			gboolean _tmp1452_;
			gboolean _tmp1453_;
			_tmp1445_ = deleg;
			_tmp1446_ = vala_callable_get_return_type ((ValaCallable*) _tmp1445_);
			_tmp1447_ = _tmp1446_;
			_tmp1448_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1447_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1448_;
			_tmp1449_ = deleg_type;
			_tmp1450_ = vala_delegate_type_get_delegate_symbol (_tmp1449_);
			_tmp1451_ = _tmp1450_;
			_tmp1452_ = vala_delegate_get_has_target (_tmp1451_);
			_tmp1453_ = _tmp1452_;
			if (_tmp1453_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1454_;
				ValaVoidType* _tmp1455_;
				ValaPointerType* _tmp1456_;
				ValaPointerType* _tmp1457_;
				ValaLocalVariable* _tmp1458_;
				ValaLocalVariable* _tmp1459_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1460_;
				const gchar* _tmp1461_;
				const gchar* _tmp1462_;
				ValaCCodeExpression* _tmp1463_;
				ValaLocalVariable* _tmp1464_;
				ValaHashMap* _tmp1465_;
				ValaDelegate* _tmp1466_;
				ValaCCodeExpression* _tmp1467_;
				ValaCCodeUnaryExpression* _tmp1468_;
				ValaCCodeUnaryExpression* _tmp1469_;
				ValaCCodeExpression* _tmp1470_;
				ValaDelegateType* _tmp1471_;
				_tmp1454_ = vala_void_type_new (NULL);
				_tmp1455_ = _tmp1454_;
				_tmp1456_ = vala_pointer_type_new ((ValaDataType*) _tmp1455_, NULL);
				_tmp1457_ = _tmp1456_;
				_tmp1458_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1457_, TRUE, NULL, TRUE);
				_tmp1459_ = _tmp1458_;
				_vala_code_node_unref0 (_tmp1457_);
				_vala_code_node_unref0 (_tmp1455_);
				temp_var = _tmp1459_;
				_tmp1460_ = temp_var;
				_tmp1461_ = vala_symbol_get_name ((ValaSymbol*) _tmp1460_);
				_tmp1462_ = _tmp1461_;
				_tmp1463_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1462_);
				temp_ref = _tmp1463_;
				_tmp1464_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1464_, FALSE);
				_tmp1465_ = out_arg_map;
				_tmp1466_ = deleg;
				_tmp1467_ = temp_ref;
				_tmp1468_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1467_);
				_tmp1469_ = _tmp1468_;
				vala_map_set ((ValaMap*) _tmp1465_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1466_), FALSE)), (ValaCCodeExpression*) _tmp1469_);
				_vala_ccode_node_unref0 (_tmp1469_);
				_tmp1470_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1470_);
				_tmp1471_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1471_)) {
					ValaDataType* _tmp1472_;
					ValaLocalVariable* _tmp1473_;
					ValaLocalVariable* _tmp1474_;
					const gchar* _tmp1475_;
					const gchar* _tmp1476_;
					ValaCCodeExpression* _tmp1477_;
					ValaLocalVariable* _tmp1478_;
					ValaHashMap* _tmp1479_;
					ValaDelegate* _tmp1480_;
					ValaCCodeExpression* _tmp1481_;
					ValaCCodeUnaryExpression* _tmp1482_;
					ValaCCodeUnaryExpression* _tmp1483_;
					ValaCCodeExpression* _tmp1484_;
					_tmp1472_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1473_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1472_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1473_;
					_tmp1474_ = temp_var;
					_tmp1475_ = vala_symbol_get_name ((ValaSymbol*) _tmp1474_);
					_tmp1476_ = _tmp1475_;
					_tmp1477_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1476_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1477_;
					_tmp1478_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1478_, FALSE);
					_tmp1479_ = out_arg_map;
					_tmp1480_ = deleg;
					_tmp1481_ = temp_ref;
					_tmp1482_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1481_);
					_tmp1483_ = _tmp1482_;
					vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1480_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1483_);
					_vala_ccode_node_unref0 (_tmp1483_);
					_tmp1484_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1484_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1486_ = m;
	if (_tmp1486_ != NULL) {
		ValaMethod* _tmp1487_;
		gboolean _tmp1488_;
		gboolean _tmp1489_;
		_tmp1487_ = m;
		_tmp1488_ = vala_method_get_coroutine (_tmp1487_);
		_tmp1489_ = _tmp1488_;
		_tmp1485_ = _tmp1489_;
	} else {
		_tmp1485_ = FALSE;
	}
	if (_tmp1485_) {
		gboolean _tmp1490_;
		gboolean _tmp1491_;
		_tmp1490_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1491_ = _tmp1490_;
		if (_tmp1491_) {
			ValaHashMap* _tmp1492_;
			ValaMethod* _tmp1493_;
			ValaMethod* _tmp1494_;
			gchar* _tmp1495_;
			gchar* _tmp1496_;
			ValaCCodeIdentifier* _tmp1497_;
			ValaCCodeIdentifier* _tmp1498_;
			ValaHashMap* _tmp1499_;
			ValaCCodeIdentifier* _tmp1500_;
			ValaCCodeIdentifier* _tmp1501_;
			_tmp1492_ = in_arg_map;
			_tmp1493_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1494_ = _tmp1493_;
			_tmp1495_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1494_);
			_tmp1496_ = _tmp1495_;
			_tmp1497_ = vala_ccode_identifier_new (_tmp1496_);
			_tmp1498_ = _tmp1497_;
			vala_map_set ((ValaMap*) _tmp1492_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1498_);
			_vala_ccode_node_unref0 (_tmp1498_);
			_g_free0 (_tmp1496_);
			_tmp1499_ = in_arg_map;
			_tmp1500_ = vala_ccode_identifier_new ("_data_");
			_tmp1501_ = _tmp1500_;
			vala_map_set ((ValaMap*) _tmp1499_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1501_);
			_vala_ccode_node_unref0 (_tmp1501_);
		}
	}
	_tmp1502_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1503_ = _tmp1502_;
	if (_tmp1503_) {
		ValaHashMap* _tmp1504_;
		ValaCCodeExpression* _tmp1505_;
		ValaCCodeExpression* _tmp1506_;
		ValaCCodeUnaryExpression* _tmp1507_;
		ValaCCodeUnaryExpression* _tmp1508_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1504_ = out_arg_map;
		_tmp1505_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1506_ = _tmp1505_;
		_tmp1507_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1506_);
		_tmp1508_ = _tmp1507_;
		vala_map_set ((ValaMap*) _tmp1504_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1508_);
		_vala_ccode_node_unref0 (_tmp1508_);
		_vala_ccode_node_unref0 (_tmp1506_);
	} else {
		gboolean _tmp1509_ = FALSE;
		gboolean _tmp1510_ = FALSE;
		ValaMethod* _tmp1511_;
		_tmp1511_ = m;
		if (_tmp1511_ != NULL) {
			ValaMethod* _tmp1512_;
			_tmp1512_ = m;
			_tmp1510_ = vala_method_has_error_type_parameter (_tmp1512_);
		} else {
			_tmp1510_ = FALSE;
		}
		if (_tmp1510_) {
			ValaCCodeFunctionCall* _tmp1513_;
			ValaCCodeFunctionCall* _tmp1514_;
			_tmp1513_ = async_call;
			_tmp1514_ = ccall;
			_tmp1509_ = _tmp1513_ != _tmp1514_;
		} else {
			_tmp1509_ = FALSE;
		}
		if (_tmp1509_) {
			ValaHashMap* _tmp1515_;
			ValaCCodeConstant* _tmp1516_;
			ValaCCodeConstant* _tmp1517_;
			_tmp1515_ = out_arg_map;
			_tmp1516_ = vala_ccode_constant_new ("NULL");
			_tmp1517_ = _tmp1516_;
			vala_map_set ((ValaMap*) _tmp1515_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1517_);
			_vala_ccode_node_unref0 (_tmp1517_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1518_;
		_tmp1518_ = m;
		if (_tmp1518_ == NULL) {
			ValaHashMap* _tmp1519_;
			ValaCCodeConstant* _tmp1520_;
			ValaCCodeConstant* _tmp1521_;
			_tmp1519_ = in_arg_map;
			_tmp1520_ = vala_ccode_constant_new ("NULL");
			_tmp1521_ = _tmp1520_;
			vala_map_set ((ValaMap*) _tmp1519_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1521_);
			_vala_ccode_node_unref0 (_tmp1521_);
		} else {
			gboolean _tmp1522_ = FALSE;
			gboolean _tmp1523_ = FALSE;
			gboolean _tmp1524_ = FALSE;
			ValaMethod* _tmp1525_;
			gboolean _tmp1526_;
			gboolean _tmp1527_;
			_tmp1525_ = m;
			_tmp1526_ = vala_method_get_printf_format (_tmp1525_);
			_tmp1527_ = _tmp1526_;
			if (!_tmp1527_) {
				ValaMethod* _tmp1528_;
				gboolean _tmp1529_;
				gboolean _tmp1530_;
				_tmp1528_ = m;
				_tmp1529_ = vala_method_get_scanf_format (_tmp1528_);
				_tmp1530_ = _tmp1529_;
				_tmp1524_ = !_tmp1530_;
			} else {
				_tmp1524_ = FALSE;
			}
			if (_tmp1524_) {
				ValaMethod* _tmp1531_;
				gchar* _tmp1532_;
				gchar* _tmp1533_;
				_tmp1531_ = m;
				_tmp1532_ = vala_get_ccode_sentinel (_tmp1531_);
				_tmp1533_ = _tmp1532_;
				_tmp1523_ = g_strcmp0 (_tmp1533_, "") != 0;
				_g_free0 (_tmp1533_);
			} else {
				_tmp1523_ = FALSE;
			}
			if (_tmp1523_) {
				gboolean _tmp1534_;
				gboolean _tmp1535_;
				_tmp1534_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1535_ = _tmp1534_;
				_tmp1522_ = !_tmp1535_;
			} else {
				_tmp1522_ = FALSE;
			}
			if (_tmp1522_) {
				ValaHashMap* _tmp1536_;
				ValaMethod* _tmp1537_;
				gchar* _tmp1538_;
				gchar* _tmp1539_;
				ValaCCodeConstant* _tmp1540_;
				ValaCCodeConstant* _tmp1541_;
				_tmp1536_ = in_arg_map;
				_tmp1537_ = m;
				_tmp1538_ = vala_get_ccode_sentinel (_tmp1537_);
				_tmp1539_ = _tmp1538_;
				_tmp1540_ = vala_ccode_constant_new (_tmp1539_);
				_tmp1541_ = _tmp1540_;
				vala_map_set ((ValaMap*) _tmp1536_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1541_);
				_vala_ccode_node_unref0 (_tmp1541_);
				_g_free0 (_tmp1539_);
			}
		}
	}
	_tmp1542_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1542_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1543_;
		ValaDelegateType* _tmp1544_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1545_;
		ValaDelegate* _tmp1546_;
		ValaDelegate* _tmp1547_;
		ValaDelegate* _tmp1548_;
		ValaDelegate* _tmp1549_;
		gboolean _tmp1550_;
		gboolean _tmp1551_;
		_tmp1543_ = itype;
		_tmp1544_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1543_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1544_;
		_tmp1545_ = deleg_type;
		_tmp1546_ = vala_delegate_type_get_delegate_symbol (_tmp1545_);
		_tmp1547_ = _tmp1546_;
		_tmp1548_ = _vala_code_node_ref0 (_tmp1547_);
		d = _tmp1548_;
		_tmp1549_ = d;
		_tmp1550_ = vala_delegate_get_has_target (_tmp1549_);
		_tmp1551_ = _tmp1550_;
		if (_tmp1551_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1552_;
			ValaDelegate* _tmp1553_;
			ValaExpression* _tmp1554_;
			ValaExpression* _tmp1555_;
			ValaCCodeExpression* _tmp1556_ = NULL;
			ValaCCodeExpression* _tmp1557_;
			ValaCCodeExpression* _tmp1558_;
			ValaHashMap* _tmp1559_;
			ValaDelegate* _tmp1560_;
			ValaExpression* _tmp1561_;
			ValaExpression* _tmp1562_;
			ValaCCodeExpression* _tmp1563_ = NULL;
			ValaCCodeExpression* _tmp1564_;
			ValaCCodeExpression* _tmp1565_;
			_tmp1552_ = in_arg_map;
			_tmp1553_ = d;
			_tmp1554_ = vala_method_call_get_call (expr);
			_tmp1555_ = _tmp1554_;
			_tmp1557_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1555_, &_tmp1556_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1556_;
			_tmp1558_ = _tmp1557_;
			vala_map_set ((ValaMap*) _tmp1552_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1553_), FALSE)), _tmp1558_);
			_vala_ccode_node_unref0 (_tmp1558_);
			_tmp1559_ = out_arg_map;
			_tmp1560_ = d;
			_tmp1561_ = vala_method_call_get_call (expr);
			_tmp1562_ = _tmp1561_;
			_tmp1564_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1562_, &_tmp1563_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1563_;
			_tmp1565_ = _tmp1564_;
			vala_map_set ((ValaMap*) _tmp1559_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1560_), FALSE)), _tmp1565_);
			_vala_ccode_node_unref0 (_tmp1565_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1566_ = itype;
	_tmp1567_ = vala_data_type_get_return_type (_tmp1566_);
	_tmp1568_ = _tmp1567_;
	_tmp1569_ = vala_data_type_is_real_non_null_struct_type (_tmp1568_);
	_vala_code_node_unref0 (_tmp1568_);
	return_result_via_out_param = _tmp1569_;
	_tmp1571_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1571_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1572_;
		ValaDataType* _tmp1573_;
		ValaDataType* _tmp1574_;
		_tmp1572_ = itype;
		_tmp1573_ = vala_data_type_get_return_type (_tmp1572_);
		_tmp1574_ = _tmp1573_;
		_tmp1570_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1574_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1574_);
	} else {
		_tmp1570_ = FALSE;
	}
	if (_tmp1570_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1575_;
		ValaSignal* _tmp1576_;
		ValaSignal* _tmp1577_;
		ValaSignal* _tmp1578_;
		gboolean _tmp1579_ = FALSE;
		gboolean _tmp1580_ = FALSE;
		ValaMemberAccess* _tmp1581_;
		_tmp1575_ = itype;
		_tmp1576_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1575_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1577_ = _tmp1576_;
		_tmp1578_ = _vala_code_node_ref0 (_tmp1577_);
		sig = _tmp1578_;
		_tmp1581_ = ma;
		if (_tmp1581_ != NULL) {
			ValaMemberAccess* _tmp1582_;
			ValaExpression* _tmp1583_;
			ValaExpression* _tmp1584_;
			_tmp1582_ = ma;
			_tmp1583_ = vala_member_access_get_inner (_tmp1582_);
			_tmp1584_ = _tmp1583_;
			_tmp1580_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1584_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1580_ = FALSE;
		}
		if (_tmp1580_) {
			ValaSignal* _tmp1585_;
			gboolean _tmp1586_;
			gboolean _tmp1587_;
			_tmp1585_ = sig;
			_tmp1586_ = vala_signal_get_is_virtual (_tmp1585_);
			_tmp1587_ = _tmp1586_;
			_tmp1579_ = _tmp1587_;
		} else {
			_tmp1579_ = FALSE;
		}
		if (_tmp1579_) {
		} else {
			gboolean _tmp1588_ = FALSE;
			ValaSignal* _tmp1589_;
			_tmp1589_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1589_)) {
				_tmp1588_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1590_;
				ValaSourceReference* _tmp1591_;
				ValaSourceReference* _tmp1592_;
				ValaSourceFile* _tmp1593_;
				ValaSourceFile* _tmp1594_;
				ValaSignal* _tmp1595_;
				ValaSourceReference* _tmp1596_;
				ValaSourceReference* _tmp1597_;
				ValaSourceFile* _tmp1598_;
				ValaSourceFile* _tmp1599_;
				_tmp1590_ = ma;
				_tmp1591_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_source_reference_get_file (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1595_ = sig;
				_tmp1596_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1595_);
				_tmp1597_ = _tmp1596_;
				_tmp1598_ = vala_source_reference_get_file (_tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1588_ = _tmp1594_ == _tmp1599_;
			}
			if (_tmp1588_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1600_ = async_call;
	_tmp1601_ = ccall;
	if (_tmp1600_ == _tmp1601_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1602_;
		ValaDataType* _tmp1603_;
		ValaDataType* _tmp1604_;
		ValaLocalVariable* _tmp1605_;
		ValaLocalVariable* _tmp1606_;
		ValaLocalVariable* _tmp1607_;
		const gchar* _tmp1608_;
		const gchar* _tmp1609_;
		ValaCCodeExpression* _tmp1610_;
		ValaLocalVariable* _tmp1611_;
		ValaHashMap* _tmp1612_;
		ValaCCodeExpression* _tmp1613_;
		ValaCCodeUnaryExpression* _tmp1614_;
		ValaCCodeUnaryExpression* _tmp1615_;
		_tmp1602_ = itype;
		_tmp1603_ = vala_data_type_get_return_type (_tmp1602_);
		_tmp1604_ = _tmp1603_;
		_tmp1605_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1604_, TRUE, NULL, TRUE);
		_tmp1606_ = _tmp1605_;
		_vala_code_node_unref0 (_tmp1604_);
		out_param_var = _tmp1606_;
		_tmp1607_ = out_param_var;
		_tmp1608_ = vala_symbol_get_name ((ValaSymbol*) _tmp1607_);
		_tmp1609_ = _tmp1608_;
		_tmp1610_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1609_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1610_;
		_tmp1611_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1611_, FALSE);
		_tmp1612_ = out_arg_map;
		_tmp1613_ = out_param_ref;
		_tmp1614_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1613_);
		_tmp1615_ = _tmp1614_;
		vala_map_set ((ValaMap*) _tmp1612_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1615_);
		_vala_ccode_node_unref0 (_tmp1615_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1616_ = async_call;
	_tmp1617_ = ccall;
	if (_tmp1616_ != _tmp1617_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1628_;
			ValaHashMap* _tmp1629_;
			gpointer _tmp1630_;
			ValaCCodeExpression* _tmp1631_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1618_;
				ValaSet* _tmp1619_;
				ValaSet* _tmp1620_;
				ValaIterator* _tmp1621_;
				ValaIterator* _tmp1622_;
				_tmp1618_ = out_arg_map;
				_tmp1619_ = vala_map_get_keys ((ValaMap*) _tmp1618_);
				_tmp1620_ = _tmp1619_;
				_tmp1621_ = vala_iterable_iterator ((ValaIterable*) _tmp1620_);
				_tmp1622_ = _tmp1621_;
				_vala_iterable_unref0 (_tmp1620_);
				_pos_it = _tmp1622_;
				while (TRUE) {
					ValaIterator* _tmp1623_;
					gint pos = 0;
					ValaIterator* _tmp1624_;
					gpointer _tmp1625_;
					gboolean _tmp1626_ = FALSE;
					_tmp1623_ = _pos_it;
					if (!vala_iterator_next (_tmp1623_)) {
						break;
					}
					_tmp1624_ = _pos_it;
					_tmp1625_ = vala_iterator_get (_tmp1624_);
					pos = (gint) ((gintptr) _tmp1625_);
					if (pos > last_pos) {
						gboolean _tmp1627_ = FALSE;
						if (min_pos == -1) {
							_tmp1627_ = TRUE;
						} else {
							_tmp1627_ = pos < min_pos;
						}
						_tmp1626_ = _tmp1627_;
					} else {
						_tmp1626_ = FALSE;
					}
					if (_tmp1626_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1628_ = ccall;
			_tmp1629_ = out_arg_map;
			_tmp1630_ = vala_map_get ((ValaMap*) _tmp1629_, (gpointer) ((gintptr) min_pos));
			_tmp1631_ = (ValaCCodeExpression*) _tmp1630_;
			vala_ccode_function_call_add_argument (_tmp1628_, _tmp1631_);
			_vala_ccode_node_unref0 (_tmp1631_);
			last_pos = min_pos;
		}
	}
	_tmp1632_ = async_call;
	if (_tmp1632_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1643_;
			ValaHashMap* _tmp1644_;
			gpointer _tmp1645_;
			ValaCCodeExpression* _tmp1646_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1633_;
				ValaSet* _tmp1634_;
				ValaSet* _tmp1635_;
				ValaIterator* _tmp1636_;
				ValaIterator* _tmp1637_;
				_tmp1633_ = in_arg_map;
				_tmp1634_ = vala_map_get_keys ((ValaMap*) _tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1636_ = vala_iterable_iterator ((ValaIterable*) _tmp1635_);
				_tmp1637_ = _tmp1636_;
				_vala_iterable_unref0 (_tmp1635_);
				_pos_it = _tmp1637_;
				while (TRUE) {
					ValaIterator* _tmp1638_;
					gint pos = 0;
					ValaIterator* _tmp1639_;
					gpointer _tmp1640_;
					gboolean _tmp1641_ = FALSE;
					_tmp1638_ = _pos_it;
					if (!vala_iterator_next (_tmp1638_)) {
						break;
					}
					_tmp1639_ = _pos_it;
					_tmp1640_ = vala_iterator_get (_tmp1639_);
					pos = (gint) ((gintptr) _tmp1640_);
					if (pos > last_pos) {
						gboolean _tmp1642_ = FALSE;
						if (min_pos == -1) {
							_tmp1642_ = TRUE;
						} else {
							_tmp1642_ = pos < min_pos;
						}
						_tmp1641_ = _tmp1642_;
					} else {
						_tmp1641_ = FALSE;
					}
					if (_tmp1641_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1643_ = async_call;
			_tmp1644_ = in_arg_map;
			_tmp1645_ = vala_map_get ((ValaMap*) _tmp1644_, (gpointer) ((gintptr) min_pos));
			_tmp1646_ = (ValaCCodeExpression*) _tmp1645_;
			vala_ccode_function_call_add_argument (_tmp1643_, _tmp1646_);
			_vala_ccode_node_unref0 (_tmp1646_);
			last_pos = min_pos;
		}
	}
	_tmp1647_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1648_ = _tmp1647_;
	if (_tmp1648_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1649_;
		gint _tmp1650_;
		ValaCCodeFunction* _tmp1651_;
		ValaCCodeFunction* _tmp1652_;
		ValaCCodeIdentifier* _tmp1653_;
		ValaCCodeIdentifier* _tmp1654_;
		ValaCCodeMemberAccess* _tmp1655_;
		ValaCCodeMemberAccess* _tmp1656_;
		gchar* _tmp1657_;
		gchar* _tmp1658_;
		ValaCCodeConstant* _tmp1659_;
		ValaCCodeConstant* _tmp1660_;
		ValaCCodeFunction* _tmp1661_;
		ValaCCodeFunction* _tmp1662_;
		ValaCCodeFunctionCall* _tmp1663_;
		ValaCCodeFunction* _tmp1664_;
		ValaCCodeFunction* _tmp1665_;
		ValaCCodeConstant* _tmp1666_;
		ValaCCodeConstant* _tmp1667_;
		ValaCCodeFunction* _tmp1668_;
		ValaCCodeFunction* _tmp1669_;
		gchar* _tmp1670_;
		gchar* _tmp1671_;
		_tmp1649_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1650_ = _tmp1649_->next_coroutine_state;
		_tmp1649_->next_coroutine_state = _tmp1650_ + 1;
		state = _tmp1650_;
		_tmp1651_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1652_ = _tmp1651_;
		_tmp1653_ = vala_ccode_identifier_new ("_data_");
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1654_, "_state_");
		_tmp1656_ = _tmp1655_;
		_tmp1657_ = g_strdup_printf ("%i", state);
		_tmp1658_ = _tmp1657_;
		_tmp1659_ = vala_ccode_constant_new (_tmp1658_);
		_tmp1660_ = _tmp1659_;
		vala_ccode_function_add_assignment (_tmp1652_, (ValaCCodeExpression*) _tmp1656_, (ValaCCodeExpression*) _tmp1660_);
		_vala_ccode_node_unref0 (_tmp1660_);
		_g_free0 (_tmp1658_);
		_vala_ccode_node_unref0 (_tmp1656_);
		_vala_ccode_node_unref0 (_tmp1654_);
		_tmp1661_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1662_ = _tmp1661_;
		_tmp1663_ = async_call;
		vala_ccode_function_add_expression (_tmp1662_, (ValaCCodeExpression*) _tmp1663_);
		_tmp1664_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1665_ = _tmp1664_;
		_tmp1666_ = vala_ccode_constant_new ("FALSE");
		_tmp1667_ = _tmp1666_;
		vala_ccode_function_add_return (_tmp1665_, (ValaCCodeExpression*) _tmp1667_);
		_vala_ccode_node_unref0 (_tmp1667_);
		_tmp1668_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1669_ = _tmp1668_;
		_tmp1670_ = g_strdup_printf ("_state_%d", state);
		_tmp1671_ = _tmp1670_;
		vala_ccode_function_add_label (_tmp1669_, _tmp1671_);
		_g_free0 (_tmp1671_);
	}
	_tmp1672_ = vala_method_call_get_is_assert (expr);
	_tmp1673_ = _tmp1672_;
	if (_tmp1673_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1674_;
		ValaSourceReference* _tmp1675_;
		ValaSourceLocation _tmp1676_ = {0};
		ValaSourceLocation _tmp1677_;
		gchar* _tmp1678_;
		ValaSourceReference* _tmp1679_;
		ValaSourceReference* _tmp1680_;
		ValaSourceLocation _tmp1681_ = {0};
		ValaSourceLocation _tmp1682_;
		gchar* _tmp1683_;
		ValaSourceReference* _tmp1684_;
		ValaSourceReference* _tmp1685_;
		ValaSourceLocation _tmp1686_ = {0};
		ValaSourceLocation _tmp1687_;
		gchar* _tmp1688_;
		gchar* _tmp1689_;
		ValaCCodeFunctionCall* _tmp1690_;
		ValaCCodeIdentifier* _tmp1691_;
		ValaCCodeIdentifier* _tmp1692_;
		ValaCCodeFunctionCall* _tmp1693_;
		const gchar* _tmp1694_;
		gchar* _tmp1695_;
		gchar* _tmp1696_;
		gchar* _tmp1697_;
		gchar* _tmp1698_;
		gchar* _tmp1699_;
		gchar* _tmp1700_;
		ValaCCodeConstant* _tmp1701_;
		ValaCCodeConstant* _tmp1702_;
		_tmp1674_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1675_ = _tmp1674_;
		vala_source_reference_get_begin (_tmp1675_, &_tmp1676_);
		_tmp1677_ = _tmp1676_;
		_tmp1678_ = _tmp1677_.pos;
		_tmp1679_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1680_ = _tmp1679_;
		vala_source_reference_get_end (_tmp1680_, &_tmp1681_);
		_tmp1682_ = _tmp1681_;
		_tmp1683_ = _tmp1682_.pos;
		_tmp1684_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1685_ = _tmp1684_;
		vala_source_reference_get_begin (_tmp1685_, &_tmp1686_);
		_tmp1687_ = _tmp1686_;
		_tmp1688_ = _tmp1687_.pos;
		_tmp1689_ = string_substring ((const gchar*) _tmp1678_, (glong) 0, (glong) ((gint) (_tmp1683_ - _tmp1688_)));
		message = _tmp1689_;
		_tmp1690_ = ccall;
		_tmp1691_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1692_ = _tmp1691_;
		vala_ccode_function_call_set_call (_tmp1690_, (ValaCCodeExpression*) _tmp1692_);
		_vala_ccode_node_unref0 (_tmp1692_);
		_tmp1693_ = ccall;
		_tmp1694_ = message;
		_tmp1695_ = string_replace (_tmp1694_, "\n", " ");
		_tmp1696_ = _tmp1695_;
		_tmp1697_ = g_strescape (_tmp1696_, "");
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = g_strdup_printf ("\"%s\"", _tmp1698_);
		_tmp1700_ = _tmp1699_;
		_tmp1701_ = vala_ccode_constant_new (_tmp1700_);
		_tmp1702_ = _tmp1701_;
		vala_ccode_function_call_add_argument (_tmp1693_, (ValaCCodeExpression*) _tmp1702_);
		_vala_ccode_node_unref0 (_tmp1702_);
		_g_free0 (_tmp1700_);
		_g_free0 (_tmp1698_);
		_g_free0 (_tmp1696_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeExpression* _tmp1705_;
		ValaCCodeExpression* _tmp1706_;
		ValaCCodeExpression* _tmp1707_;
		_tmp1703_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1704_ = _tmp1703_;
		_tmp1705_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1704_, _tmp1705_);
		_tmp1706_ = out_param_ref;
		_tmp1707_ = _vala_ccode_node_ref0 (_tmp1706_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1707_;
	}
	_tmp1710_ = m;
	if (_tmp1710_ != NULL) {
		ValaMethod* _tmp1711_;
		ValaMemberBinding _tmp1712_;
		ValaMemberBinding _tmp1713_;
		_tmp1711_ = m;
		_tmp1712_ = vala_method_get_binding (_tmp1711_);
		_tmp1713_ = _tmp1712_;
		_tmp1709_ = _tmp1713_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1709_ = FALSE;
	}
	if (_tmp1709_) {
		ValaMethod* _tmp1714_;
		gboolean _tmp1715_;
		gboolean _tmp1716_;
		_tmp1714_ = m;
		_tmp1715_ = vala_method_get_returns_modified_pointer (_tmp1714_);
		_tmp1716_ = _tmp1715_;
		_tmp1708_ = _tmp1716_;
	} else {
		_tmp1708_ = FALSE;
	}
	if (_tmp1708_) {
		gboolean _tmp1717_ = FALSE;
		gboolean _tmp1718_ = FALSE;
		ValaMemberAccess* _tmp1719_;
		_tmp1719_ = ma;
		if (_tmp1719_ != NULL) {
			ValaMemberAccess* _tmp1720_;
			ValaExpression* _tmp1721_;
			ValaExpression* _tmp1722_;
			ValaSymbol* _tmp1723_;
			ValaSymbol* _tmp1724_;
			_tmp1720_ = ma;
			_tmp1721_ = vala_member_access_get_inner (_tmp1720_);
			_tmp1722_ = _tmp1721_;
			_tmp1723_ = vala_expression_get_symbol_reference (_tmp1722_);
			_tmp1724_ = _tmp1723_;
			_tmp1718_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1724_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1718_ = FALSE;
		}
		if (_tmp1718_) {
			ValaMemberAccess* _tmp1725_;
			ValaExpression* _tmp1726_;
			ValaExpression* _tmp1727_;
			_tmp1725_ = ma;
			_tmp1726_ = vala_member_access_get_inner (_tmp1725_);
			_tmp1727_ = _tmp1726_;
			_tmp1717_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1727_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1717_ = FALSE;
		}
		if (_tmp1717_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1728_;
			ValaExpression* _tmp1729_;
			ValaExpression* _tmp1730_;
			ValaSymbol* _tmp1731_;
			ValaSymbol* _tmp1732_;
			ValaProperty* _tmp1733_;
			ValaProperty* _tmp1734_;
			ValaMemberAccess* _tmp1735_;
			ValaExpression* _tmp1736_;
			ValaExpression* _tmp1737_;
			ValaExpression* _tmp1738_;
			ValaExpression* _tmp1739_;
			ValaDataType* _tmp1740_;
			ValaDataType* _tmp1741_;
			ValaCCodeExpression* _tmp1742_;
			ValaGLibValue* _tmp1743_;
			ValaGLibValue* _tmp1744_;
			_tmp1728_ = ma;
			_tmp1729_ = vala_member_access_get_inner (_tmp1728_);
			_tmp1730_ = _tmp1729_;
			_tmp1731_ = vala_expression_get_symbol_reference (_tmp1730_);
			_tmp1732_ = _tmp1731_;
			_tmp1733_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1732_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1733_;
			_tmp1734_ = prop;
			_tmp1735_ = ma;
			_tmp1736_ = vala_member_access_get_inner (_tmp1735_);
			_tmp1737_ = _tmp1736_;
			_tmp1738_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1737_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1739_ = _tmp1738_;
			_tmp1740_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1741_ = _tmp1740_;
			_tmp1742_ = ccall_expr;
			_tmp1743_ = vala_glib_value_new (_tmp1741_, _tmp1742_, FALSE);
			_tmp1744_ = _tmp1743_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1734_, _tmp1739_, (ValaTargetValue*) _tmp1744_);
			_vala_target_value_unref0 (_tmp1744_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1745_;
			ValaCCodeExpression* _tmp1746_;
			ValaCCodeAssignment* _tmp1747_;
			_tmp1745_ = instance;
			_tmp1746_ = ccall_expr;
			_tmp1747_ = vala_ccode_assignment_new (_tmp1745_, _tmp1746_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1747_;
		}
	}
	_tmp1750_ = m;
	if (_tmp1750_ != NULL) {
		ValaMethod* _tmp1751_;
		gchar* _tmp1752_;
		gchar* _tmp1753_;
		_tmp1751_ = m;
		_tmp1752_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1751_);
		_tmp1753_ = _tmp1752_;
		_tmp1749_ = _tmp1753_ != NULL;
		_g_free0 (_tmp1753_);
	} else {
		_tmp1749_ = FALSE;
	}
	if (_tmp1749_) {
		ValaMethod* _tmp1754_;
		gchar* _tmp1755_;
		gchar* _tmp1756_;
		ValaMethod* _tmp1757_;
		ValaDataType* _tmp1758_;
		ValaDataType* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		_tmp1754_ = m;
		_tmp1755_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1754_);
		_tmp1756_ = _tmp1755_;
		_tmp1757_ = m;
		_tmp1758_ = vala_callable_get_return_type ((ValaCallable*) _tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1759_);
		_tmp1761_ = _tmp1760_;
		_tmp1748_ = g_strcmp0 (_tmp1756_, _tmp1761_) != 0;
		_g_free0 (_tmp1761_);
		_g_free0 (_tmp1756_);
	} else {
		_tmp1748_ = FALSE;
	}
	if (_tmp1748_) {
		ValaCCodeExpression* _tmp1762_;
		ValaMethod* _tmp1763_;
		ValaDataType* _tmp1764_;
		ValaDataType* _tmp1765_;
		gchar* _tmp1766_;
		gchar* _tmp1767_;
		ValaCCodeCastExpression* _tmp1768_;
		_tmp1762_ = ccall_expr;
		_tmp1763_ = m;
		_tmp1764_ = vala_callable_get_return_type ((ValaCallable*) _tmp1763_);
		_tmp1765_ = _tmp1764_;
		_tmp1766_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1765_);
		_tmp1767_ = _tmp1766_;
		_tmp1768_ = vala_ccode_cast_expression_new (_tmp1762_, _tmp1767_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1768_;
		_g_free0 (_tmp1767_);
	}
	_tmp1769_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1769_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1770_;
		ValaList* _tmp1771_;
		ValaIterator* _tmp1772_;
		ValaIterator* _tmp1773_;
		ValaIterator* _tmp1774_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1775_;
		gpointer _tmp1776_;
		ValaExpression* _tmp1777_;
		ValaCCodeExpression* _tmp1778_;
		ValaCCodeExpression* _tmp1779_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1780_;
		ValaLocalVariable* _tmp1781_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1782_;
		const gchar* _tmp1783_;
		const gchar* _tmp1784_;
		ValaCCodeExpression* _tmp1785_;
		ValaLocalVariable* _tmp1786_;
		ValaCCodeFile* _tmp1787_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1788_;
		ValaExpression* _tmp1789_;
		ValaExpression* _tmp1790_;
		ValaCCodeExpression* _tmp1791_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1792_;
		ValaExpression* _tmp1793_;
		ValaExpression* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1796_;
		ValaExpression* _tmp1797_;
		ValaExpression* _tmp1798_;
		ValaDataType* _tmp1799_;
		ValaDataType* _tmp1800_;
		ValaArrayType* _tmp1801_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1802_;
		ValaDataType* _tmp1803_;
		ValaDataType* _tmp1804_;
		gchar* _tmp1805_;
		gchar* _tmp1806_;
		gchar* _tmp1807_;
		gchar* _tmp1808_;
		ValaCCodeIdentifier* _tmp1809_;
		ValaCCodeIdentifier* _tmp1810_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1811_;
		ValaCCodeExpression* _tmp1812_;
		ValaCCodeBinaryExpression* _tmp1813_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1814_;
		ValaCCodeExpression* _tmp1815_;
		ValaCCodeBinaryExpression* _tmp1816_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1817_;
		ValaCCodeIdentifier* _tmp1818_;
		ValaCCodeFunctionCall* _tmp1819_;
		ValaCCodeFunctionCall* _tmp1820_;
		ValaCCodeFunctionCall* _tmp1821_;
		ValaCCodeExpression* _tmp1822_;
		ValaCCodeExpression* _tmp1823_;
		ValaCCodeBinaryExpression* _tmp1824_;
		ValaCCodeBinaryExpression* _tmp1825_;
		ValaCCodeFunctionCall* _tmp1826_;
		ValaCCodeConstant* _tmp1827_;
		ValaCCodeConstant* _tmp1828_;
		ValaCCodeFunctionCall* _tmp1829_;
		ValaCCodeIdentifier* _tmp1830_;
		ValaCCodeBinaryExpression* _tmp1831_;
		ValaCCodeBinaryExpression* _tmp1832_;
		ValaCCodeBinaryExpression* _tmp1833_;
		ValaCCodeFunction* _tmp1834_;
		ValaCCodeFunction* _tmp1835_;
		ValaCCodeExpression* _tmp1836_;
		ValaCCodeExpression* _tmp1837_;
		ValaCCodeFunction* _tmp1838_;
		ValaCCodeFunction* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaCCodeFunction* _tmp1841_;
		ValaCCodeFunction* _tmp1842_;
		ValaCCodeBinaryExpression* _tmp1843_;
		ValaCCodeFunctionCall* _tmp1844_;
		ValaCCodeConstant* _tmp1845_;
		ValaCCodeConstant* _tmp1846_;
		ValaCCodeConditionalExpression* _tmp1847_;
		ValaCCodeConditionalExpression* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeFunction* _tmp1850_;
		ValaMemberAccess* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		ValaCCodeExpression* _tmp1856_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaExpression* _tmp1859_;
		ValaSymbol* _tmp1860_;
		ValaSymbol* _tmp1861_;
		ValaSymbol* _tmp1862_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1863_;
		ValaLocalVariable* _tmp1864_;
		gboolean _tmp1865_ = FALSE;
		gboolean _tmp1866_ = FALSE;
		ValaSymbol* _tmp1867_;
		_tmp1770_ = vala_method_call_get_argument_list (expr);
		_tmp1771_ = _tmp1770_;
		_tmp1772_ = vala_iterable_iterator ((ValaIterable*) _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_vala_iterable_unref0 (_tmp1771_);
		arg_it = _tmp1773_;
		_tmp1774_ = arg_it;
		vala_iterator_next (_tmp1774_);
		_tmp1775_ = arg_it;
		_tmp1776_ = vala_iterator_get (_tmp1775_);
		_tmp1777_ = (ValaExpression*) _tmp1776_;
		_tmp1778_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1777_);
		_tmp1779_ = _tmp1778_;
		_vala_code_node_unref0 (_tmp1777_);
		new_size = _tmp1779_;
		_tmp1780_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1781_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1780_, TRUE, NULL, FALSE);
		temp_decl = _tmp1781_;
		_tmp1782_ = temp_decl;
		_tmp1783_ = vala_symbol_get_name ((ValaSymbol*) _tmp1782_);
		_tmp1784_ = _tmp1783_;
		_tmp1785_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1784_);
		temp_ref = _tmp1785_;
		_tmp1786_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1786_, FALSE);
		_tmp1787_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1787_, "string.h", FALSE);
		_tmp1788_ = ma;
		_tmp1789_ = vala_member_access_get_inner (_tmp1788_);
		_tmp1790_ = _tmp1789_;
		_tmp1791_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1790_, 1);
		clen = _tmp1791_;
		_tmp1792_ = ma;
		_tmp1793_ = vala_member_access_get_inner (_tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1794_);
		celems = _tmp1795_;
		_tmp1796_ = ma;
		_tmp1797_ = vala_member_access_get_inner (_tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_expression_get_value_type (_tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1801_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1800_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1801_;
		_tmp1802_ = array_type;
		_tmp1803_ = vala_array_type_get_element_type (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1804_);
		_tmp1806_ = _tmp1805_;
		_tmp1807_ = g_strdup_printf ("sizeof (%s)", _tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_ccode_identifier_new (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_g_free0 (_tmp1808_);
		_g_free0 (_tmp1806_);
		csizeof = _tmp1810_;
		_tmp1811_ = temp_ref;
		_tmp1812_ = clen;
		_tmp1813_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1811_, _tmp1812_);
		cdelta = _tmp1813_;
		_tmp1814_ = temp_ref;
		_tmp1815_ = clen;
		_tmp1816_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1814_, _tmp1815_);
		ccheck = _tmp1816_;
		_tmp1817_ = vala_ccode_identifier_new ("memset");
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_vala_ccode_node_unref0 (_tmp1818_);
		czero = _tmp1820_;
		_tmp1821_ = czero;
		_tmp1822_ = celems;
		_tmp1823_ = clen;
		_tmp1824_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1822_, _tmp1823_);
		_tmp1825_ = _tmp1824_;
		vala_ccode_function_call_add_argument (_tmp1821_, (ValaCCodeExpression*) _tmp1825_);
		_vala_ccode_node_unref0 (_tmp1825_);
		_tmp1826_ = czero;
		_tmp1827_ = vala_ccode_constant_new ("0");
		_tmp1828_ = _tmp1827_;
		vala_ccode_function_call_add_argument (_tmp1826_, (ValaCCodeExpression*) _tmp1828_);
		_vala_ccode_node_unref0 (_tmp1828_);
		_tmp1829_ = czero;
		_tmp1830_ = csizeof;
		_tmp1831_ = cdelta;
		_tmp1832_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1830_, (ValaCCodeExpression*) _tmp1831_);
		_tmp1833_ = _tmp1832_;
		vala_ccode_function_call_add_argument (_tmp1829_, (ValaCCodeExpression*) _tmp1833_);
		_vala_ccode_node_unref0 (_tmp1833_);
		_tmp1834_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = temp_ref;
		_tmp1837_ = new_size;
		vala_ccode_function_add_assignment (_tmp1835_, _tmp1836_, _tmp1837_);
		_tmp1838_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1839_ = _tmp1838_;
		_tmp1840_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1839_, _tmp1840_);
		_tmp1841_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1842_ = _tmp1841_;
		_tmp1843_ = ccheck;
		_tmp1844_ = czero;
		_tmp1845_ = vala_ccode_constant_new ("NULL");
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1843_, (ValaCCodeExpression*) _tmp1844_, (ValaCCodeExpression*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		vala_ccode_function_add_expression (_tmp1842_, (ValaCCodeExpression*) _tmp1848_);
		_vala_ccode_node_unref0 (_tmp1848_);
		_vala_ccode_node_unref0 (_tmp1846_);
		_tmp1849_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1850_ = _tmp1849_;
		_tmp1851_ = ma;
		_tmp1852_ = vala_member_access_get_inner (_tmp1851_);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1853_, 1);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1850_, _tmp1855_, _tmp1856_);
		_vala_ccode_node_unref0 (_tmp1855_);
		_tmp1857_ = ma;
		_tmp1858_ = vala_member_access_get_inner (_tmp1857_);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = vala_expression_get_symbol_reference (_tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1862_ = _vala_code_node_ref0 (_tmp1861_);
		array_var = _tmp1862_;
		_tmp1863_ = array_var;
		_tmp1864_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1863_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1863_) : NULL);
		array_local = _tmp1864_;
		_tmp1867_ = array_var;
		if (_tmp1867_ != NULL) {
			ValaSymbol* _tmp1868_;
			_tmp1868_ = array_var;
			_tmp1866_ = vala_symbol_is_internal_symbol (_tmp1868_);
		} else {
			_tmp1866_ = FALSE;
		}
		if (_tmp1866_) {
			gboolean _tmp1869_ = FALSE;
			gboolean _tmp1870_ = FALSE;
			ValaSymbol* _tmp1871_;
			_tmp1871_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1871_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1872_;
				gboolean _tmp1873_;
				gboolean _tmp1874_;
				_tmp1872_ = array_local;
				_tmp1873_ = vala_local_variable_get_captured (_tmp1872_);
				_tmp1874_ = _tmp1873_;
				_tmp1870_ = !_tmp1874_;
			} else {
				_tmp1870_ = FALSE;
			}
			if (_tmp1870_) {
				_tmp1869_ = TRUE;
			} else {
				ValaSymbol* _tmp1875_;
				_tmp1875_ = array_var;
				_tmp1869_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1875_, VALA_TYPE_FIELD);
			}
			_tmp1865_ = _tmp1869_;
		} else {
			_tmp1865_ = FALSE;
		}
		if (_tmp1865_) {
			ValaCCodeFunction* _tmp1876_;
			ValaCCodeFunction* _tmp1877_;
			ValaMemberAccess* _tmp1878_;
			ValaExpression* _tmp1879_;
			ValaExpression* _tmp1880_;
			ValaTargetValue* _tmp1881_;
			ValaTargetValue* _tmp1882_;
			ValaCCodeExpression* _tmp1883_;
			ValaCCodeExpression* _tmp1884_;
			ValaCCodeExpression* _tmp1885_;
			_tmp1876_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1877_ = _tmp1876_;
			_tmp1878_ = ma;
			_tmp1879_ = vala_member_access_get_inner (_tmp1878_);
			_tmp1880_ = _tmp1879_;
			_tmp1881_ = vala_expression_get_target_value (_tmp1880_);
			_tmp1882_ = _tmp1881_;
			_tmp1883_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1882_);
			_tmp1884_ = _tmp1883_;
			_tmp1885_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1877_, _tmp1884_, _tmp1885_);
			_vala_ccode_node_unref0 (_tmp1884_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1887_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1888_ = _tmp1887_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1888_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1889_;
		ValaDataType* _tmp1890_;
		_tmp1889_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1890_ = _tmp1889_;
		_tmp1886_ = !vala_data_type_is_disposable (_tmp1890_);
	} else {
		_tmp1886_ = FALSE;
	}
	if (_tmp1886_) {
		gboolean _tmp1891_ = FALSE;
		ValaCCodeExpression* _tmp1892_;
		_tmp1892_ = ccall_expr;
		if (_tmp1892_ != NULL) {
			_tmp1891_ = !return_result_via_out_param;
		} else {
			_tmp1891_ = FALSE;
		}
		if (_tmp1891_) {
			ValaCCodeFunction* _tmp1893_;
			ValaCCodeFunction* _tmp1894_;
			ValaCCodeExpression* _tmp1895_;
			_tmp1893_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1894_ = _tmp1893_;
			_tmp1895_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1894_, _tmp1895_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1896_;
		ValaDataType* _tmp1897_;
		gboolean _tmp1898_ = FALSE;
		ValaDataType* _tmp1899_;
		ValaDataType* _tmp1900_;
		gboolean _tmp1927_ = FALSE;
		ValaMethod* _tmp1928_;
		_tmp1896_ = itype;
		_tmp1897_ = vala_data_type_get_return_type (_tmp1896_);
		result_type = _tmp1897_;
		_tmp1899_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1900_ = _tmp1899_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1900_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1901_;
			ValaDataType* _tmp1902_;
			_tmp1901_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1902_ = _tmp1901_;
			_tmp1898_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1902_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1898_ = FALSE;
		}
		if (_tmp1898_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1903_;
			ValaDataType* _tmp1904_;
			ValaTypeParameter* _tmp1905_;
			ValaTypeParameter* _tmp1906_;
			ValaTypeParameter* _tmp1907_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1908_;
			ValaSymbol* _tmp1909_;
			ValaSymbol* _tmp1910_;
			ValaSymbol* _tmp1911_;
			ValaSymbol* _tmp1912_;
			ValaStruct* _tmp1913_;
			gboolean _tmp1914_ = FALSE;
			ValaTypeParameter* _tmp1915_;
			ValaSymbol* _tmp1916_;
			ValaSymbol* _tmp1917_;
			ValaTypeSymbol* _tmp1918_;
			_tmp1903_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1904_ = _tmp1903_;
			_tmp1905_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1904_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1906_ = _tmp1905_;
			_tmp1907_ = _vala_code_node_ref0 (_tmp1906_);
			type_parameter = _tmp1907_;
			_tmp1908_ = type_parameter;
			_tmp1909_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1908_);
			_tmp1910_ = _tmp1909_;
			_tmp1911_ = vala_symbol_get_parent_symbol (_tmp1910_);
			_tmp1912_ = _tmp1911_;
			_tmp1913_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1912_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1912_) : NULL);
			st = _tmp1913_;
			_tmp1915_ = type_parameter;
			_tmp1916_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1915_);
			_tmp1917_ = _tmp1916_;
			_tmp1918_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1917_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1918_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1914_ = TRUE;
			} else {
				gboolean _tmp1919_ = FALSE;
				ValaStruct* _tmp1920_;
				_tmp1920_ = st;
				if (_tmp1920_ != NULL) {
					ValaStruct* _tmp1921_;
					gchar* _tmp1922_;
					gchar* _tmp1923_;
					_tmp1921_ = st;
					_tmp1922_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1921_);
					_tmp1923_ = _tmp1922_;
					_tmp1919_ = g_strcmp0 (_tmp1923_, "va_list") == 0;
					_g_free0 (_tmp1923_);
				} else {
					_tmp1919_ = FALSE;
				}
				_tmp1914_ = _tmp1919_;
			}
			if (_tmp1914_) {
				ValaDataType* _tmp1924_;
				ValaDataType* _tmp1925_;
				ValaDataType* _tmp1926_;
				_tmp1924_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1925_ = _tmp1924_;
				_tmp1926_ = _vala_code_node_ref0 (_tmp1925_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1926_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1928_ = m;
		if (_tmp1928_ != NULL) {
			ValaMethod* _tmp1929_;
			_tmp1929_ = m;
			_tmp1927_ = vala_method_get_format_arg_index (_tmp1929_) >= 0;
		} else {
			_tmp1927_ = FALSE;
		}
		if (_tmp1927_) {
			ValaCCodeExpression* _tmp1930_;
			_tmp1930_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1930_);
		} else {
			gboolean _tmp1931_ = FALSE;
			ValaMethod* _tmp1932_;
			_tmp1932_ = m;
			if (_tmp1932_ != NULL) {
				ValaMethod* _tmp1933_;
				_tmp1933_ = m;
				_tmp1931_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1933_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1931_ = FALSE;
			}
			if (_tmp1931_) {
				ValaCCodeExpression* _tmp1934_;
				_tmp1934_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1934_);
			} else {
				gboolean _tmp1935_ = FALSE;
				gboolean _tmp1936_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp1936_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1936_ = FALSE;
				}
				if (_tmp1936_) {
					gboolean _tmp1937_ = FALSE;
					ValaDataType* _tmp1938_;
					_tmp1938_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1938_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1939_;
						_tmp1939_ = result_type;
						_tmp1937_ = !vala_data_type_is_disposable (_tmp1939_);
					} else {
						_tmp1937_ = FALSE;
					}
					_tmp1935_ = _tmp1937_;
				} else {
					_tmp1935_ = FALSE;
				}
				if (_tmp1935_) {
					ValaCCodeExpression* _tmp1940_;
					_tmp1940_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1940_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1941_;
						ValaDataType* _tmp1942_;
						gboolean _tmp1943_;
						gboolean _tmp1944_;
						ValaLocalVariable* _tmp1945_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1946_;
						const gchar* _tmp1947_;
						const gchar* _tmp1948_;
						ValaCCodeExpression* _tmp1949_;
						ValaLocalVariable* _tmp1950_;
						ValaCCodeFunction* _tmp1951_;
						ValaCCodeFunction* _tmp1952_;
						ValaCCodeExpression* _tmp1953_;
						ValaCCodeExpression* _tmp1954_;
						ValaCCodeExpression* _tmp1955_;
						ValaTargetValue* _tmp1956_;
						ValaTargetValue* _tmp1957_;
						_tmp1941_ = result_type;
						_tmp1942_ = result_type;
						_tmp1943_ = vala_data_type_get_value_owned (_tmp1942_);
						_tmp1944_ = _tmp1943_;
						_tmp1945_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1941_, _tmp1944_, NULL, FALSE);
						temp_var = _tmp1945_;
						_tmp1946_ = temp_var;
						_tmp1947_ = vala_symbol_get_name ((ValaSymbol*) _tmp1946_);
						_tmp1948_ = _tmp1947_;
						_tmp1949_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1948_);
						temp_ref = _tmp1949_;
						_tmp1950_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1950_, FALSE);
						_tmp1951_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1952_ = _tmp1951_;
						_tmp1953_ = temp_ref;
						_tmp1954_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1952_, _tmp1953_, _tmp1954_);
						_tmp1955_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1955_);
						_tmp1956_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1957_ = _tmp1956_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1957_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1958_;
						ValaTargetValue* _tmp1959_;
						ValaTargetValue* _tmp1960_;
						_tmp1958_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1958_);
						_tmp1959_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1960_ = _tmp1959_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1960_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1961_ = params;
	_tmp1962_ = vala_iterable_iterator ((ValaIterable*) _tmp1961_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1962_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1963_;
		gint _arg_size = 0;
		ValaList* _tmp1964_;
		gint _tmp1965_;
		gint _tmp1966_;
		gint _arg_index = 0;
		_tmp1963_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1963_;
		_tmp1964_ = _arg_list;
		_tmp1965_ = vala_collection_get_size ((ValaCollection*) _tmp1964_);
		_tmp1966_ = _tmp1965_;
		_arg_size = _tmp1966_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1967_;
			gpointer _tmp1968_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1969_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1972_;
			ValaUnaryExpression* _tmp1973_;
			gboolean _tmp1974_ = FALSE;
			ValaUnaryExpression* _tmp1975_;
			ValaUnaryExpression* _tmp1979_;
			ValaExpression* _tmp1980_;
			ValaExpression* _tmp1981_;
			ValaDataType* _tmp1982_;
			ValaDataType* _tmp1983_;
			ValaUnaryExpression* _tmp1993_;
			ValaExpression* _tmp1994_;
			ValaExpression* _tmp1995_;
			ValaTargetValue* _tmp1996_;
			ValaTargetValue* _tmp1997_;
			ValaUnaryExpression* _tmp1998_;
			ValaTargetValue* _tmp1999_;
			ValaTargetValue* _tmp2000_;
			ValaUnaryExpression* _tmp2001_;
			ValaExpression* _tmp2002_;
			ValaExpression* _tmp2003_;
			ValaDataType* _tmp2004_;
			ValaDataType* _tmp2005_;
			ValaExpression* _tmp2006_;
			ValaTargetValue* _tmp2007_;
			ValaTargetValue* _tmp2008_;
			ValaSourceReference* _tmp2009_;
			ValaSourceReference* _tmp2010_;
			gboolean _tmp2011_ = FALSE;
			ValaParameter* _tmp2012_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1967_ = _arg_list;
			_tmp1968_ = vala_list_get (_tmp1967_, _arg_index);
			arg = (ValaExpression*) _tmp1968_;
			param = NULL;
			_tmp1969_ = params_it;
			if (vala_iterator_next (_tmp1969_)) {
				ValaIterator* _tmp1970_;
				gpointer _tmp1971_;
				_tmp1970_ = params_it;
				_tmp1971_ = vala_iterator_get (_tmp1970_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1971_;
			}
			_tmp1972_ = arg;
			_tmp1973_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1972_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1972_) : NULL);
			unary = _tmp1973_;
			_tmp1975_ = unary;
			if (_tmp1975_ == NULL) {
				_tmp1974_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp1976_;
				ValaUnaryOperator _tmp1977_;
				ValaUnaryOperator _tmp1978_;
				_tmp1976_ = unary;
				_tmp1977_ = vala_unary_expression_get_operator (_tmp1976_);
				_tmp1978_ = _tmp1977_;
				_tmp1974_ = _tmp1978_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1974_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp1979_ = unary;
			_tmp1980_ = vala_unary_expression_get_inner (_tmp1979_);
			_tmp1981_ = _tmp1980_;
			_tmp1982_ = vala_expression_get_value_type (_tmp1981_);
			_tmp1983_ = _tmp1982_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp1983_)) {
				ValaCCodeFunction* _tmp1984_;
				ValaCCodeFunction* _tmp1985_;
				ValaUnaryExpression* _tmp1986_;
				ValaExpression* _tmp1987_;
				ValaExpression* _tmp1988_;
				ValaTargetValue* _tmp1989_;
				ValaTargetValue* _tmp1990_;
				ValaCCodeExpression* _tmp1991_;
				ValaCCodeExpression* _tmp1992_;
				_tmp1984_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp1985_ = _tmp1984_;
				_tmp1986_ = unary;
				_tmp1987_ = vala_unary_expression_get_inner (_tmp1986_);
				_tmp1988_ = _tmp1987_;
				_tmp1989_ = vala_expression_get_target_value (_tmp1988_);
				_tmp1990_ = _tmp1989_;
				_tmp1991_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp1990_, FALSE);
				_tmp1992_ = _tmp1991_;
				vala_ccode_function_add_expression (_tmp1985_, _tmp1992_);
				_vala_ccode_node_unref0 (_tmp1992_);
			}
			_tmp1993_ = unary;
			_tmp1994_ = vala_unary_expression_get_inner (_tmp1993_);
			_tmp1995_ = _tmp1994_;
			_tmp1996_ = vala_expression_get_target_value (_tmp1995_);
			_tmp1997_ = _tmp1996_;
			_tmp1998_ = unary;
			_tmp1999_ = vala_expression_get_target_value ((ValaExpression*) _tmp1998_);
			_tmp2000_ = _tmp1999_;
			_tmp2001_ = unary;
			_tmp2002_ = vala_unary_expression_get_inner (_tmp2001_);
			_tmp2003_ = _tmp2002_;
			_tmp2004_ = vala_expression_get_value_type (_tmp2003_);
			_tmp2005_ = _tmp2004_;
			_tmp2006_ = arg;
			_tmp2007_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2000_, _tmp2005_, (ValaCodeNode*) _tmp2006_);
			_tmp2008_ = _tmp2007_;
			_tmp2009_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2010_ = _tmp2009_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp1997_, _tmp2008_, _tmp2010_);
			_vala_target_value_unref0 (_tmp2008_);
			_tmp2012_ = param;
			if (_tmp2012_ != NULL) {
				ValaParameter* _tmp2013_;
				_tmp2013_ = param;
				_tmp2011_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2013_);
			} else {
				_tmp2011_ = FALSE;
			}
			if (_tmp2011_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2014_;
				ValaCCodeIdentifier* _tmp2015_;
				ValaCCodeFunctionCall* _tmp2016_;
				ValaCCodeFunctionCall* _tmp2017_;
				ValaCCodeFunctionCall* _tmp2018_;
				ValaUnaryExpression* _tmp2019_;
				ValaExpression* _tmp2020_;
				ValaExpression* _tmp2021_;
				ValaTargetValue* _tmp2022_;
				ValaTargetValue* _tmp2023_;
				ValaCCodeExpression* _tmp2024_;
				ValaCCodeExpression* _tmp2025_;
				ValaCCodeFunction* _tmp2026_;
				ValaCCodeFunction* _tmp2027_;
				ValaUnaryExpression* _tmp2028_;
				ValaExpression* _tmp2029_;
				ValaExpression* _tmp2030_;
				ValaTargetValue* _tmp2031_;
				ValaTargetValue* _tmp2032_;
				ValaCCodeExpression* _tmp2033_;
				ValaCCodeExpression* _tmp2034_;
				ValaCCodeFunctionCall* _tmp2035_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2014_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2015_ = _tmp2014_;
				_tmp2016_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2015_);
				_tmp2017_ = _tmp2016_;
				_vala_ccode_node_unref0 (_tmp2015_);
				len_call = _tmp2017_;
				_tmp2018_ = len_call;
				_tmp2019_ = unary;
				_tmp2020_ = vala_unary_expression_get_inner (_tmp2019_);
				_tmp2021_ = _tmp2020_;
				_tmp2022_ = vala_expression_get_target_value (_tmp2021_);
				_tmp2023_ = _tmp2022_;
				_tmp2024_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2023_);
				_tmp2025_ = _tmp2024_;
				vala_ccode_function_call_add_argument (_tmp2018_, _tmp2025_);
				_vala_ccode_node_unref0 (_tmp2025_);
				_tmp2026_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2027_ = _tmp2026_;
				_tmp2028_ = unary;
				_tmp2029_ = vala_unary_expression_get_inner (_tmp2028_);
				_tmp2030_ = _tmp2029_;
				_tmp2031_ = vala_expression_get_target_value (_tmp2030_);
				_tmp2032_ = _tmp2031_;
				_tmp2033_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2032_, 1);
				_tmp2034_ = _tmp2033_;
				_tmp2035_ = len_call;
				vala_ccode_function_add_assignment (_tmp2027_, _tmp2034_, (ValaCCodeExpression*) _tmp2035_);
				_vala_ccode_node_unref0 (_tmp2034_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2038_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2038_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2039_;
		ValaSymbol* _tmp2040_;
		ValaSymbol* _tmp2041_;
		_tmp2039_ = m;
		_tmp2040_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2039_);
		_tmp2041_ = _tmp2040_;
		_tmp2037_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2041_, VALA_TYPE_CLASS);
	} else {
		_tmp2037_ = FALSE;
	}
	if (_tmp2037_) {
		gboolean _tmp2042_ = FALSE;
		gboolean _tmp2043_ = FALSE;
		ValaClass* _tmp2044_;
		ValaClass* _tmp2045_;
		gboolean _tmp2046_;
		gboolean _tmp2047_;
		_tmp2044_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2045_ = _tmp2044_;
		_tmp2046_ = vala_class_get_is_compact (_tmp2045_);
		_tmp2047_ = _tmp2046_;
		if (_tmp2047_) {
			ValaClass* _tmp2048_;
			ValaClass* _tmp2049_;
			ValaClass* _tmp2050_;
			ValaClass* _tmp2051_;
			_tmp2048_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2049_ = _tmp2048_;
			_tmp2050_ = vala_class_get_base_class (_tmp2049_);
			_tmp2051_ = _tmp2050_;
			_tmp2043_ = _tmp2051_ != NULL;
		} else {
			_tmp2043_ = FALSE;
		}
		if (_tmp2043_) {
			_tmp2042_ = TRUE;
		} else {
			ValaClass* _tmp2052_;
			ValaClass* _tmp2053_;
			ValaClass* _tmp2054_;
			ValaClass* _tmp2055_;
			ValaClass* _tmp2056_;
			_tmp2052_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2053_ = _tmp2052_;
			_tmp2054_ = vala_class_get_base_class (_tmp2053_);
			_tmp2055_ = _tmp2054_;
			_tmp2056_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2042_ = _tmp2055_ == _tmp2056_;
		}
		_tmp2036_ = _tmp2042_;
	} else {
		_tmp2036_ = FALSE;
	}
	if (_tmp2036_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2057_;
		ValaClass* _tmp2058_;
		gchar* _tmp2059_;
		gchar* _tmp2060_;
		gchar* _tmp2061_;
		gchar* _tmp2062_;
		ValaCCodeIdentifier* _tmp2063_;
		ValaCCodeIdentifier* _tmp2064_;
		ValaCCodeFunctionCall* _tmp2065_;
		ValaCCodeFunctionCall* _tmp2066_;
		ValaCCodeFunctionCall* _tmp2067_;
		ValaCCodeExpression* _tmp2068_;
		ValaCCodeExpression* _tmp2069_;
		ValaCCodeFunctionCall* _tmp2070_;
		ValaCCodeConstant* _tmp2071_;
		ValaCCodeConstant* _tmp2072_;
		ValaCCodeFunction* _tmp2073_;
		ValaCCodeFunction* _tmp2074_;
		ValaCCodeFunctionCall* _tmp2075_;
		_tmp2057_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2058_ = _tmp2057_;
		_tmp2059_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2058_, NULL);
		_tmp2060_ = _tmp2059_;
		_tmp2061_ = g_strdup_printf ("%s_instance_init", _tmp2060_);
		_tmp2062_ = _tmp2061_;
		_tmp2063_ = vala_ccode_identifier_new (_tmp2062_);
		_tmp2064_ = _tmp2063_;
		_tmp2065_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2064_);
		_tmp2066_ = _tmp2065_;
		_vala_ccode_node_unref0 (_tmp2064_);
		_g_free0 (_tmp2062_);
		_g_free0 (_tmp2060_);
		cinitcall = _tmp2066_;
		_tmp2067_ = cinitcall;
		_tmp2068_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2069_ = _tmp2068_;
		vala_ccode_function_call_add_argument (_tmp2067_, _tmp2069_);
		_vala_ccode_node_unref0 (_tmp2069_);
		_tmp2070_ = cinitcall;
		_tmp2071_ = vala_ccode_constant_new ("NULL");
		_tmp2072_ = _tmp2071_;
		vala_ccode_function_call_add_argument (_tmp2070_, (ValaCCodeExpression*) _tmp2072_);
		_vala_ccode_node_unref0 (_tmp2072_);
		_tmp2073_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2074_ = _tmp2073_;
		_tmp2075_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2074_, (ValaCCodeExpression*) _tmp2075_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaUnaryExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp4_ = _arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _arg_index);
			arg = (ValaExpression*) _tmp5_;
			_tmp6_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp6_) : NULL;
			_tmp8_ = unary;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValaUnaryExpression* _tmp10_;
				ValaUnaryOperator _tmp11_;
				ValaUnaryOperator _tmp12_;
				_tmp10_ = unary;
				_tmp11_ = vala_unary_expression_get_operator (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp9_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp13_;
					ValaUnaryOperator _tmp14_;
					ValaUnaryOperator _tmp15_;
					_tmp13_ = unary;
					_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	gchar* result = NULL;
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

