/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len = len + _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len = len + (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp288_ = FALSE;
	ValaMethod* _tmp289_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp452_;
	ValaCCodeExpression* _tmp453_;
	ValaMethod* _tmp454_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp478_ = FALSE;
	ValaMethod* _tmp479_;
	gboolean _tmp633_ = FALSE;
	ValaMethod* _tmp634_;
	ValaMethod* _tmp682_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp864_;
	ValaIterator* _tmp865_;
	ValaIterator* _tmp1237_;
	gboolean _tmp1247_ = FALSE;
	gboolean _tmp1248_ = FALSE;
	ValaMethod* _tmp1249_;
	gboolean _tmp1371_ = FALSE;
	ValaDelegate* _tmp1372_;
	gboolean _tmp1469_ = FALSE;
	ValaMethod* _tmp1470_;
	gboolean _tmp1486_;
	gboolean _tmp1487_;
	ValaDataType* _tmp1530_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1554_;
	ValaDataType* _tmp1555_;
	ValaDataType* _tmp1556_;
	gboolean _tmp1557_;
	gboolean _tmp1558_ = FALSE;
	ValaDataType* _tmp1559_;
	ValaCCodeFunctionCall* _tmp1588_;
	ValaCCodeFunctionCall* _tmp1589_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1604_;
	ValaCCodeFunctionCall* _tmp1605_;
	ValaCCodeFunctionCall* _tmp1620_;
	gboolean _tmp1635_;
	gboolean _tmp1636_;
	gboolean _tmp1660_;
	gboolean _tmp1661_;
	gboolean _tmp1696_ = FALSE;
	gboolean _tmp1697_ = FALSE;
	ValaMethod* _tmp1698_;
	gboolean _tmp1736_ = FALSE;
	gboolean _tmp1737_ = FALSE;
	gboolean _tmp1738_ = FALSE;
	gboolean _tmp1739_ = FALSE;
	gboolean _tmp1740_ = FALSE;
	ValaMethod* _tmp1741_;
	gboolean _tmp1758_ = FALSE;
	gboolean _tmp1759_ = FALSE;
	ValaMethod* _tmp1760_;
	ValaMethod* _tmp1779_;
	gboolean _tmp1896_ = FALSE;
	ValaCodeNode* _tmp1897_;
	ValaCodeNode* _tmp1898_;
	ValaList* _tmp1971_;
	ValaIterator* _tmp1972_;
	gboolean _tmp2046_ = FALSE;
	gboolean _tmp2047_ = FALSE;
	ValaMethod* _tmp2048_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp238_ = FALSE;
		ValaMemberAccess* _tmp239_;
		const gchar* _tmp240_;
		const gchar* _tmp241_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			ValaCCodeExpression* _tmp223_;
			vcast = NULL;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				ValaCCodeIdentifier* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeFunctionCall* _tmp203_;
				ValaCCodeExpression* _tmp204_;
				ValaClass* _tmp205_;
				ValaClass* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				ValaCCodeIdentifier* _tmp211_;
				ValaCCodeIdentifier* _tmp212_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass);
				_tmp198_ = base_class;
				_tmp199_ = vala_get_ccode_class_type_function (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_ccode_identifier_new (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp202_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp203_;
				_vala_ccode_node_unref0 (_tmp202_);
				_g_free0 (_tmp200_);
				_tmp204_ = vcast;
				_tmp205_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp206_, NULL);
				_tmp208_ = _tmp207_;
				_tmp209_ = g_strdup_printf ("%s_parent_class", _tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_ccode_identifier_new (_tmp210_);
				_tmp212_ = _tmp211_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp212_);
				_vala_ccode_node_unref0 (_tmp212_);
				_g_free0 (_tmp210_);
				_g_free0 (_tmp208_);
			} else {
				ValaMethod* _tmp213_;
				ValaMethod* _tmp214_;
				ValaMethod* _tmp215_;
				_tmp213_ = m;
				_tmp214_ = vala_method_get_base_interface_method (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp216_;
					ValaMethod* _tmp217_;
					ValaMethod* _tmp218_;
					ValaSymbol* _tmp219_;
					ValaSymbol* _tmp220_;
					ValaInterface* _tmp221_;
					ValaCCodeExpression* _tmp222_;
					_tmp216_ = m;
					_tmp217_ = vala_method_get_base_interface_method (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp218_);
					_tmp220_ = _tmp219_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp221_ = base_iface;
					_tmp222_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp221_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp222_;
				}
			}
			_tmp223_ = vcast;
			if (_tmp223_ != NULL) {
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeExpression* _tmp225_;
				ValaMethod* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				ValaCCodeMemberAccess* _tmp229_;
				ValaCCodeMemberAccess* _tmp230_;
				ValaCCodeFunctionCall* _tmp231_;
				ValaCCodeExpression* _tmp232_;
				ValaMethod* _tmp233_;
				gchar* _tmp234_;
				gchar* _tmp235_;
				ValaCCodeMemberAccess* _tmp236_;
				ValaCCodeMemberAccess* _tmp237_;
				_tmp224_ = async_call;
				_tmp225_ = vcast;
				_tmp226_ = m;
				_tmp227_ = vala_get_ccode_vfunc_name (_tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_ccode_member_access_new_pointer (_tmp225_, _tmp228_);
				_tmp230_ = _tmp229_;
				vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp230_);
				_vala_ccode_node_unref0 (_tmp230_);
				_g_free0 (_tmp228_);
				_tmp231_ = finish_call;
				_tmp232_ = vcast;
				_tmp233_ = m;
				_tmp234_ = vala_get_ccode_finish_vfunc_name (_tmp233_);
				_tmp235_ = _tmp234_;
				_tmp236_ = vala_ccode_member_access_new_pointer (_tmp232_, _tmp235_);
				_tmp237_ = _tmp236_;
				vala_ccode_function_call_set_call (_tmp231_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (_tmp237_);
				_g_free0 (_tmp235_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp239_ = ma;
		_tmp240_ = vala_member_access_get_member_name (_tmp239_);
		_tmp241_ = _tmp240_;
		if (g_strcmp0 (_tmp241_, "begin") == 0) {
			ValaMemberAccess* _tmp242_;
			ValaExpression* _tmp243_;
			ValaExpression* _tmp244_;
			ValaSymbol* _tmp245_;
			ValaSymbol* _tmp246_;
			ValaMemberAccess* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaSymbol* _tmp249_;
			_tmp242_ = ma;
			_tmp243_ = vala_member_access_get_inner (_tmp242_);
			_tmp244_ = _tmp243_;
			_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = ma;
			_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp247_);
			_tmp249_ = _tmp248_;
			_tmp238_ = _tmp246_ == _tmp249_;
		} else {
			_tmp238_ = FALSE;
		}
		if (_tmp238_) {
			ValaCCodeFunctionCall* _tmp250_;
			ValaCCodeFunctionCall* _tmp251_;
			ValaMethod* _tmp252_;
			ValaList* _tmp253_;
			_tmp250_ = async_call;
			_tmp251_ = _vala_ccode_node_ref0 (_tmp250_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp251_;
			_tmp252_ = m;
			_tmp253_ = vala_method_get_async_begin_parameters (_tmp252_);
			_vala_iterable_unref0 (params);
			params = _tmp253_;
		} else {
			gboolean _tmp254_ = FALSE;
			ValaMemberAccess* _tmp255_;
			const gchar* _tmp256_;
			const gchar* _tmp257_;
			_tmp255_ = ma;
			_tmp256_ = vala_member_access_get_member_name (_tmp255_);
			_tmp257_ = _tmp256_;
			if (g_strcmp0 (_tmp257_, "end") == 0) {
				ValaMemberAccess* _tmp258_;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				ValaMemberAccess* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				_tmp258_ = ma;
				_tmp259_ = vala_member_access_get_inner (_tmp258_);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = ma;
				_tmp264_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp263_);
				_tmp265_ = _tmp264_;
				_tmp254_ = _tmp262_ == _tmp265_;
			} else {
				_tmp254_ = FALSE;
			}
			if (_tmp254_) {
				ValaCCodeFunctionCall* _tmp266_;
				ValaCCodeFunctionCall* _tmp267_;
				ValaMethod* _tmp268_;
				ValaList* _tmp269_;
				_tmp266_ = finish_call;
				_tmp267_ = _vala_ccode_node_ref0 (_tmp266_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp267_;
				_tmp268_ = m;
				_tmp269_ = vala_method_get_async_end_parameters (_tmp268_);
				_vala_iterable_unref0 (params);
				params = _tmp269_;
			} else {
				gboolean _tmp270_;
				gboolean _tmp271_;
				_tmp270_ = vala_method_call_get_is_yield_expression (expr);
				_tmp271_ = _tmp270_;
				if (!_tmp271_) {
					ValaCCodeFunctionCall* _tmp272_;
					ValaCCodeFunctionCall* _tmp273_;
					ValaMethod* _tmp274_;
					ValaList* _tmp275_;
					_tmp272_ = async_call;
					_tmp273_ = _vala_ccode_node_ref0 (_tmp272_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp273_;
					_tmp274_ = m;
					_tmp275_ = vala_method_get_async_begin_parameters (_tmp274_);
					_vala_iterable_unref0 (params);
					params = _tmp275_;
				} else {
					ValaCCodeFunctionCall* _tmp276_;
					ValaCCodeFunctionCall* _tmp277_;
					GHashFunc _tmp278_;
					GEqualFunc _tmp279_;
					GEqualFunc _tmp280_;
					ValaHashMap* _tmp281_;
					ValaHashMap* _tmp282_;
					ValaMethod* _tmp283_;
					ValaCCodeIdentifier* _tmp284_;
					ValaCCodeIdentifier* _tmp285_;
					ValaCCodeMemberAccess* _tmp286_;
					ValaCCodeMemberAccess* _tmp287_;
					_tmp276_ = finish_call;
					_tmp277_ = _vala_ccode_node_ref0 (_tmp276_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp277_;
					_tmp278_ = g_direct_hash;
					_tmp279_ = g_direct_equal;
					_tmp280_ = g_direct_equal;
					_tmp281_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp278_, _tmp279_, _tmp280_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp281_;
					_tmp282_ = out_arg_map;
					_tmp283_ = m;
					_tmp284_ = vala_ccode_identifier_new ("_data_");
					_tmp285_ = _tmp284_;
					_tmp286_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp285_, "_res_");
					_tmp287_ = _tmp286_;
					vala_map_set ((ValaMap*) _tmp282_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp283_), FALSE)), (ValaCCodeExpression*) _tmp287_);
					_vala_ccode_node_unref0 (_tmp287_);
					_vala_ccode_node_unref0 (_tmp285_);
				}
			}
		}
	}
	_tmp289_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp289_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp290_;
		ValaSymbol* _tmp291_;
		ValaSymbol* _tmp292_;
		_tmp290_ = m;
		_tmp291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp288_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CLASS);
	} else {
		_tmp288_ = FALSE;
	}
	if (_tmp288_) {
		ValaCodeContext* _tmp293_;
		ValaCodeContext* _tmp294_;
		ValaProfile _tmp295_;
		ValaProfile _tmp296_;
		ValaClass* _tmp308_;
		ValaClass* _tmp309_;
		gboolean _tmp310_;
		gboolean _tmp311_;
		_tmp293_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_code_context_get_profile (_tmp294_);
		_tmp296_ = _tmp295_;
		if (_tmp296_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			gboolean _tmp300_;
			gboolean _tmp301_;
			_tmp297_ = m;
			_tmp298_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_CLASS, ValaClass));
			_tmp301_ = _tmp300_;
			if (!_tmp301_) {
				ValaCCodeFunctionCall* _tmp302_;
				ValaCCodeExpression* _tmp303_;
				ValaCCodeExpression* _tmp304_;
				_tmp302_ = ccall;
				_tmp303_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp304_ = _tmp303_;
				vala_ccode_function_call_add_argument (_tmp302_, _tmp304_);
				_vala_ccode_node_unref0 (_tmp304_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp305_;
			ValaCCodeExpression* _tmp306_;
			ValaCCodeExpression* _tmp307_;
			_tmp305_ = ccall;
			_tmp306_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp307_ = _tmp306_;
			vala_ccode_function_call_add_argument (_tmp305_, _tmp307_);
			_vala_ccode_node_unref0 (_tmp307_);
		}
		_tmp308_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = vala_class_get_is_compact (_tmp309_);
		_tmp311_ = _tmp310_;
		if (!_tmp311_) {
			ValaClass* _tmp312_;
			ValaClass* _tmp313_;
			ValaMethod* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp312_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp313_ = _tmp312_;
			_tmp314_ = m;
			_tmp315_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp314_);
			_tmp316_ = _tmp315_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp316_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp317_;
					ValaClass* _tmp318_;
					ValaList* _tmp319_;
					gint _base_type_size = 0;
					ValaList* _tmp320_;
					gint _tmp321_;
					gint _tmp322_;
					gint _base_type_index = 0;
					_tmp317_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_class_get_base_types (_tmp318_);
					_base_type_list = _tmp319_;
					_tmp320_ = _base_type_list;
					_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
					_tmp322_ = _tmp321_;
					_base_type_size = _tmp322_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp323_;
						gpointer _tmp324_;
						ValaDataType* _tmp325_;
						ValaTypeSymbol* _tmp326_;
						ValaTypeSymbol* _tmp327_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp323_ = _base_type_list;
						_tmp324_ = vala_list_get (_tmp323_, _base_type_index);
						base_type = (ValaDataType*) _tmp324_;
						_tmp325_ = base_type;
						_tmp326_ = vala_data_type_get_data_type (_tmp325_);
						_tmp327_ = _tmp326_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp327_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp328_;
							gchar* _tmp329_;
							gchar* _tmp330_;
							gboolean _tmp331_;
							ValaHashMap* _tmp336_;
							ValaDataType* _tmp337_;
							ValaList* _tmp338_;
							ValaList* _tmp339_;
							ValaList* _tmp340_;
							type_parameters = NULL;
							_tmp328_ = m;
							_tmp329_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = g_strcmp0 (_tmp330_, "g_object_new") == 0;
							_g_free0 (_tmp330_);
							if (_tmp331_) {
								ValaDataType* _tmp332_;
								ValaTypeSymbol* _tmp333_;
								ValaTypeSymbol* _tmp334_;
								ValaList* _tmp335_;
								_tmp332_ = base_type;
								_tmp333_ = vala_data_type_get_data_type (_tmp332_);
								_tmp334_ = _tmp333_;
								_tmp335_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp334_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp335_;
							}
							_tmp336_ = in_arg_map;
							_tmp337_ = base_type;
							_tmp338_ = vala_data_type_get_type_arguments (_tmp337_);
							_tmp339_ = _tmp338_;
							_tmp340_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp336_, _tmp339_, (ValaCodeNode*) expr, TRUE, _tmp340_);
							_vala_iterable_unref0 (_tmp339_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp341_;
				ValaSymbol* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaClass* _tmp344_;
				type_param_index = 0;
				_tmp341_ = m;
				_tmp342_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp341_);
				_tmp343_ = _tmp342_;
				_tmp344_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp343_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp344_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp345_;
					ValaList* _tmp346_;
					gint _type_param_size = 0;
					ValaList* _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _type_param_index = 0;
					_tmp345_ = cl;
					_tmp346_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp345_);
					_type_param_list = _tmp346_;
					_tmp347_ = _type_param_list;
					_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
					_tmp349_ = _tmp348_;
					_type_param_size = _tmp349_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp350_;
						gpointer _tmp351_;
						ValaHashMap* _tmp352_;
						ValaTypeParameter* _tmp353_;
						const gchar* _tmp354_;
						const gchar* _tmp355_;
						gchar* _tmp356_;
						gchar* _tmp357_;
						gchar* _tmp358_;
						gchar* _tmp359_;
						ValaCCodeIdentifier* _tmp360_;
						ValaCCodeIdentifier* _tmp361_;
						ValaHashMap* _tmp362_;
						ValaTypeParameter* _tmp363_;
						const gchar* _tmp364_;
						const gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						gchar* _tmp368_;
						gchar* _tmp369_;
						ValaCCodeIdentifier* _tmp370_;
						ValaCCodeIdentifier* _tmp371_;
						ValaHashMap* _tmp372_;
						ValaTypeParameter* _tmp373_;
						const gchar* _tmp374_;
						const gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						gchar* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						ValaCCodeIdentifier* _tmp381_;
						gint _tmp382_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp350_ = _type_param_list;
						_tmp351_ = vala_list_get (_tmp350_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp351_;
						_tmp352_ = in_arg_map;
						_tmp353_ = type_param;
						_tmp354_ = vala_symbol_get_name ((ValaSymbol*) _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = g_utf8_strdown (_tmp355_, (gssize) -1);
						_tmp357_ = _tmp356_;
						_tmp358_ = g_strdup_printf ("%s_type", _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = vala_ccode_identifier_new (_tmp359_);
						_tmp361_ = _tmp360_;
						vala_map_set ((ValaMap*) _tmp352_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp361_);
						_vala_ccode_node_unref0 (_tmp361_);
						_g_free0 (_tmp359_);
						_g_free0 (_tmp357_);
						_tmp362_ = in_arg_map;
						_tmp363_ = type_param;
						_tmp364_ = vala_symbol_get_name ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_utf8_strdown (_tmp365_, (gssize) -1);
						_tmp367_ = _tmp366_;
						_tmp368_ = g_strdup_printf ("%s_dup_func", _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = vala_ccode_identifier_new (_tmp369_);
						_tmp371_ = _tmp370_;
						vala_map_set ((ValaMap*) _tmp362_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp371_);
						_vala_ccode_node_unref0 (_tmp371_);
						_g_free0 (_tmp369_);
						_g_free0 (_tmp367_);
						_tmp372_ = in_arg_map;
						_tmp373_ = type_param;
						_tmp374_ = vala_symbol_get_name ((ValaSymbol*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_utf8_strdown (_tmp375_, (gssize) -1);
						_tmp377_ = _tmp376_;
						_tmp378_ = g_strdup_printf ("%s_destroy_func", _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = vala_ccode_identifier_new (_tmp379_);
						_tmp381_ = _tmp380_;
						vala_map_set ((ValaMap*) _tmp372_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp381_);
						_vala_ccode_node_unref0 (_tmp381_);
						_g_free0 (_tmp379_);
						_g_free0 (_tmp377_);
						_tmp382_ = type_param_index;
						type_param_index = _tmp382_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			ValaClass* _tmp387_;
			_tmp383_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_class_get_base_class (_tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp386_ == _tmp387_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp388_;
				ValaClass* _tmp389_;
				gchar* _tmp390_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				ValaCCodeDeclaration* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				const gchar* _tmp397_;
				gchar* _tmp398_;
				gchar* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeConstant* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeVariableDeclarator* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeFunction* _tmp405_;
				ValaCCodeDeclaration* _tmp406_;
				ValaCCodeFunctionCall* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeIdentifier* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeUnaryExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeCastExpression* _tmp413_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeIdentifier* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaCCodeFunctionCall* _tmp418_;
				ValaClass* _tmp419_;
				ValaClass* _tmp420_;
				gchar* _tmp421_;
				gchar* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeIdentifier* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				ValaCCodeFunctionCall* _tmp426_;
				_tmp388_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp389_, NULL);
				class_prefix = _tmp390_;
				_tmp391_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp391_;
				_tmp392_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp392_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp393_ = funcs;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = class_prefix;
				_tmp398_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp394_, _tmp395_, _tmp396_, _tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = vala_ccode_constant_new (_tmp399_);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp401_, NULL);
				_tmp403_ = _tmp402_;
				vala_ccode_declaration_add_declarator (_tmp393_, (ValaCCodeDeclarator*) _tmp403_);
				_vala_ccode_node_unref0 (_tmp403_);
				_vala_ccode_node_unref0 (_tmp401_);
				_g_free0 (_tmp399_);
				_tmp404_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp405_ = _tmp404_;
				_tmp406_ = funcs;
				vala_ccode_function_add_statement (_tmp405_, (ValaCCodeNode*) _tmp406_);
				_tmp407_ = ccall;
				_tmp408_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp409_);
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp411_, "GSourceFuncs *");
				_tmp413_ = _tmp412_;
				vala_ccode_function_call_add_argument (_tmp407_, (ValaCCodeExpression*) _tmp413_);
				_vala_ccode_node_unref0 (_tmp413_);
				_vala_ccode_node_unref0 (_tmp411_);
				_vala_ccode_node_unref0 (_tmp409_);
				_tmp414_ = vala_ccode_identifier_new ("sizeof");
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp415_);
				_tmp417_ = _tmp416_;
				_vala_ccode_node_unref0 (_tmp415_);
				csizeof = _tmp417_;
				_tmp418_ = csizeof;
				_tmp419_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_get_ccode_name ((ValaCodeNode*) _tmp420_);
				_tmp422_ = _tmp421_;
				_tmp423_ = vala_ccode_identifier_new (_tmp422_);
				_tmp424_ = _tmp423_;
				vala_ccode_function_call_add_argument (_tmp418_, (ValaCCodeExpression*) _tmp424_);
				_vala_ccode_node_unref0 (_tmp424_);
				_g_free0 (_tmp422_);
				_tmp425_ = ccall;
				_tmp426_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp425_, (ValaCCodeExpression*) _tmp426_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp427_ = FALSE;
		ValaMethod* _tmp428_;
		_tmp428_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp428_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			_tmp429_ = m;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp427_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp431_, VALA_TYPE_STRUCT);
		} else {
			_tmp427_ = FALSE;
		}
		if (_tmp427_) {
			ValaCCodeFunctionCall* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			ValaCCodeExpression* _tmp434_;
			_tmp432_ = ccall;
			_tmp433_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp434_ = _tmp433_;
			vala_ccode_function_call_add_argument (_tmp432_, _tmp434_);
			_vala_ccode_node_unref0 (_tmp434_);
		} else {
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			gboolean _tmp438_ = FALSE;
			ValaMethod* _tmp439_;
			_tmp439_ = m;
			if (_tmp439_ != NULL) {
				ValaMethod* _tmp440_;
				_tmp440_ = m;
				_tmp438_ = vala_method_has_type_parameters (_tmp440_);
			} else {
				_tmp438_ = FALSE;
			}
			if (_tmp438_) {
				ValaMethod* _tmp441_;
				_tmp441_ = m;
				_tmp437_ = !vala_get_ccode_has_generic_type_parameter (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp442_;
				_tmp442_ = m;
				_tmp436_ = !vala_get_ccode_simple_generics (_tmp442_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				gboolean _tmp443_ = FALSE;
				ValaCCodeFunctionCall* _tmp444_;
				ValaCCodeFunctionCall* _tmp445_;
				_tmp444_ = ccall;
				_tmp445_ = finish_call;
				if (_tmp444_ != _tmp445_) {
					_tmp443_ = TRUE;
				} else {
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp446_ = vala_method_call_get_is_yield_expression (expr);
					_tmp447_ = _tmp446_;
					_tmp443_ = _tmp447_;
				}
				_tmp435_ = _tmp443_;
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				ValaHashMap* _tmp448_;
				ValaMemberAccess* _tmp449_;
				ValaList* _tmp450_;
				ValaList* _tmp451_;
				_tmp448_ = in_arg_map;
				_tmp449_ = ma;
				_tmp450_ = vala_member_access_get_type_arguments (_tmp449_);
				_tmp451_ = _tmp450_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp448_, _tmp451_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp451_);
			}
		}
	}
	_tmp452_ = ccall;
	_tmp453_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp452_);
	ccall_expr = _tmp453_;
	_tmp454_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp455_;
		ValaExpression* _tmp456_;
		ValaExpression* _tmp457_;
		ValaDataType* _tmp458_;
		ValaDataType* _tmp459_;
		ValaArrayType* _tmp460_;
		ValaHashMap* _tmp461_;
		ValaArrayType* _tmp462_;
		ValaDataType* _tmp463_;
		ValaDataType* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		ValaCCodeIdentifier* _tmp467_;
		ValaCCodeIdentifier* _tmp468_;
		_tmp455_ = ma;
		_tmp456_ = vala_member_access_get_inner (_tmp455_);
		_tmp457_ = _tmp456_;
		_tmp458_ = vala_expression_get_value_type (_tmp457_);
		_tmp459_ = _tmp458_;
		_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp460_;
		_tmp461_ = in_arg_map;
		_tmp462_ = array_type;
		_tmp463_ = vala_array_type_get_element_type (_tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_get_ccode_name ((ValaCodeNode*) _tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_ccode_identifier_new (_tmp466_);
		_tmp468_ = _tmp467_;
		vala_map_set ((ValaMap*) _tmp461_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp468_);
		_vala_ccode_node_unref0 (_tmp468_);
		_g_free0 (_tmp466_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp469_;
		_tmp469_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp469_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp470_;
			_tmp470_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp471_;
				ValaExpression* _tmp472_;
				ValaExpression* _tmp473_;
				ValaTargetValue* _tmp474_;
				ValaTargetValue* _tmp475_;
				ValaTargetValue* _tmp476_;
				ValaTargetValue* _tmp477_;
				_tmp471_ = ma;
				_tmp472_ = vala_member_access_get_inner (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_expression_get_target_value (_tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp475_, (ValaCodeNode*) expr);
				_tmp477_ = _tmp476_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp477_);
				_vala_target_value_unref0 (_tmp477_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp479_ = m;
	if (_tmp479_ != NULL) {
		ValaMethod* _tmp480_;
		gboolean _tmp481_;
		gboolean _tmp482_;
		_tmp480_ = m;
		_tmp481_ = vala_method_get_is_async_callback (_tmp480_);
		_tmp482_ = _tmp481_;
		_tmp478_ = _tmp482_;
	} else {
		_tmp478_ = FALSE;
	}
	if (_tmp478_) {
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		ValaHashMap* _tmp500_;
		ValaMethod* _tmp501_;
		ValaCCodeExpression* _tmp502_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		_tmp483_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_closure (_tmp484_);
		_tmp486_ = _tmp485_;
		if (_tmp486_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp487_;
			ValaSymbol* _tmp488_;
			ValaSymbol* _tmp489_;
			ValaBlock* _tmp490_;
			ValaBlock* _tmp491_;
			ValaBlock* _tmp492_;
			ValaBlock* _tmp493_;
			gchar* _tmp494_;
			gchar* _tmp495_;
			ValaCCodeExpression* _tmp496_;
			ValaCCodeExpression* _tmp497_;
			ValaCCodeMemberAccess* _tmp498_;
			_tmp487_ = m;
			_tmp488_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp487_);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD, ValaMethod));
			_tmp491_ = _tmp490_;
			_tmp492_ = _vala_code_node_ref0 (_tmp491_);
			block = _tmp492_;
			_tmp493_ = block;
			_tmp494_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp493_));
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_ccode_member_access_new_pointer (_tmp497_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp498_;
			_vala_ccode_node_unref0 (_tmp497_);
			_g_free0 (_tmp495_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp499_;
			_tmp499_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp499_;
		}
		_tmp500_ = in_arg_map;
		_tmp501_ = m;
		_tmp502_ = instance;
		vala_map_set ((ValaMap*) _tmp500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp501_), FALSE)), _tmp502_);
		_tmp503_ = out_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
	} else {
		gboolean _tmp506_ = FALSE;
		gboolean _tmp507_ = FALSE;
		ValaMethod* _tmp508_;
		_tmp508_ = m;
		if (_tmp508_ != NULL) {
			ValaMethod* _tmp509_;
			ValaMemberBinding _tmp510_;
			ValaMemberBinding _tmp511_;
			_tmp509_ = m;
			_tmp510_ = vala_method_get_binding (_tmp509_);
			_tmp511_ = _tmp510_;
			_tmp507_ = _tmp511_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp507_ = FALSE;
		}
		if (_tmp507_) {
			ValaMethod* _tmp512_;
			_tmp512_ = m;
			_tmp506_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaTargetValue* _tmp516_;
			ValaTargetValue* _tmp517_;
			ValaTargetValue* _tmp518_;
			gboolean _tmp519_ = FALSE;
			gboolean _tmp520_ = FALSE;
			ValaMemberAccess* _tmp521_;
			const gchar* _tmp522_;
			const gchar* _tmp523_;
			ValaTargetValue* _tmp545_;
			ValaCCodeExpression* _tmp546_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaStruct* _tmp550_;
			gboolean _tmp551_ = FALSE;
			ValaStruct* _tmp552_;
			gboolean _tmp561_;
			gboolean _tmp562_;
			_tmp513_ = ma;
			_tmp514_ = vala_member_access_get_inner (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_expression_get_target_value (_tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_target_value_ref0 (_tmp517_);
			instance_value = _tmp518_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_member_name (_tmp521_);
			_tmp523_ = _tmp522_;
			if (g_strcmp0 (_tmp523_, "begin") == 0) {
				_tmp520_ = TRUE;
			} else {
				ValaMemberAccess* _tmp524_;
				const gchar* _tmp525_;
				const gchar* _tmp526_;
				_tmp524_ = ma;
				_tmp525_ = vala_member_access_get_member_name (_tmp524_);
				_tmp526_ = _tmp525_;
				_tmp520_ = g_strcmp0 (_tmp526_, "end") == 0;
			}
			if (_tmp520_) {
				ValaMemberAccess* _tmp527_;
				ValaExpression* _tmp528_;
				ValaExpression* _tmp529_;
				ValaSymbol* _tmp530_;
				ValaSymbol* _tmp531_;
				ValaMemberAccess* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_inner (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_expression_get_symbol_reference (_tmp529_);
				_tmp531_ = _tmp530_;
				_tmp532_ = ma;
				_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp519_ = _tmp531_ == _tmp534_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaMemberAccess* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaTargetValue* _tmp542_;
				ValaTargetValue* _tmp543_;
				ValaTargetValue* _tmp544_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp537_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp538_;
				_tmp539_ = inner_ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_target_value (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = _vala_target_value_ref0 (_tmp543_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp544_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp545_ = instance_value;
			_tmp546_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp545_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp546_;
			_tmp547_ = m;
			_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp549_) : NULL);
			st = _tmp550_;
			_tmp552_ = st;
			if (_tmp552_ != NULL) {
				ValaStruct* _tmp553_;
				_tmp553_ = st;
				_tmp551_ = !vala_struct_is_simple_type (_tmp553_);
			} else {
				_tmp551_ = FALSE;
			}
			if (_tmp551_) {
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp557_;
				ValaCCodeExpression* _tmp558_;
				ValaCCodeExpression* _tmp559_;
				ValaCCodeUnaryExpression* _tmp560_;
				_tmp554_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp554_)) {
					ValaTargetValue* _tmp555_;
					ValaTargetValue* _tmp556_;
					_tmp555_ = instance_value;
					_tmp556_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp555_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp556_;
				}
				_tmp557_ = instance_value;
				_tmp558_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp559_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp560_;
				_vala_ccode_node_unref0 (_tmp559_);
			}
			_tmp561_ = vala_method_call_get_is_yield_expression (expr);
			_tmp562_ = _tmp561_;
			if (_tmp562_) {
				ValaHashMap* _tmp563_;
				ValaMethod* _tmp564_;
				ValaCCodeExpression* _tmp565_;
				ValaMethod* _tmp566_;
				_tmp563_ = in_arg_map;
				_tmp564_ = m;
				_tmp565_ = instance;
				vala_map_set ((ValaMap*) _tmp563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp564_), FALSE)), _tmp565_);
				_tmp566_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp566_)) {
					ValaHashMap* _tmp567_;
					ValaMethod* _tmp568_;
					ValaCCodeExpression* _tmp569_;
					_tmp567_ = out_arg_map;
					_tmp568_ = m;
					_tmp569_ = instance;
					vala_map_set ((ValaMap*) _tmp567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp568_), FALSE)), _tmp569_);
				}
			} else {
				gboolean _tmp570_ = FALSE;
				ValaMemberAccess* _tmp571_;
				const gchar* _tmp572_;
				const gchar* _tmp573_;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_member_name (_tmp571_);
				_tmp573_ = _tmp572_;
				if (g_strcmp0 (_tmp573_, "end") != 0) {
					_tmp570_ = TRUE;
				} else {
					ValaMethod* _tmp574_;
					_tmp574_ = m;
					_tmp570_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_);
				}
				if (_tmp570_) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
					_tmp578_ = in_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp581_ = FALSE;
			ValaMethod* _tmp582_;
			_tmp582_ = m;
			if (_tmp582_ != NULL) {
				ValaMethod* _tmp583_;
				ValaMemberBinding _tmp584_;
				ValaMemberBinding _tmp585_;
				_tmp583_ = m;
				_tmp584_ = vala_method_get_binding (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp581_ = _tmp585_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp581_ = FALSE;
			}
			if (_tmp581_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp586_;
				ValaSymbol* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaClass* _tmp589_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp590_;
				gchar* _tmp591_;
				gchar* _tmp592_;
				ValaCCodeIdentifier* _tmp593_;
				ValaCCodeIdentifier* _tmp594_;
				ValaCCodeFunctionCall* _tmp595_;
				ValaCCodeFunctionCall* _tmp596_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				ValaCCodeFunctionCall* _tmp625_;
				ValaCCodeExpression* _tmp626_;
				ValaHashMap* _tmp627_;
				ValaMethod* _tmp628_;
				ValaCCodeFunctionCall* _tmp629_;
				ValaHashMap* _tmp630_;
				ValaMethod* _tmp631_;
				ValaCCodeFunctionCall* _tmp632_;
				_tmp586_ = m;
				_tmp587_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				_tmp589_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp589_;
				_tmp590_ = cl;
				_tmp591_ = vala_get_ccode_class_type_function (_tmp590_);
				_tmp592_ = _tmp591_;
				_tmp593_ = vala_ccode_identifier_new (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp594_);
				_tmp596_ = _tmp595_;
				_vala_ccode_node_unref0 (_tmp594_);
				_g_free0 (_tmp592_);
				cast = _tmp596_;
				_tmp597_ = ma;
				_tmp598_ = vala_member_access_get_inner (_tmp597_);
				_tmp599_ = _tmp598_;
				if (_tmp599_ == NULL) {
					ValaDataType* _tmp600_;
					ValaDataType* _tmp601_;
					gboolean _tmp602_;
					_tmp600_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp601_ = _tmp600_;
					_tmp602_ = _tmp601_ == NULL;
					_vala_code_node_unref0 (_tmp601_);
					if (_tmp602_) {
						ValaCCodeIdentifier* _tmp603_;
						_tmp603_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp603_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp604_;
						ValaCCodeIdentifier* _tmp605_;
						ValaCCodeFunctionCall* _tmp606_;
						ValaCCodeFunctionCall* _tmp607_;
						ValaCCodeFunctionCall* _tmp608_;
						ValaCCodeExpression* _tmp609_;
						ValaCCodeExpression* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeExpression* _tmp612_;
						_tmp604_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp605_ = _tmp604_;
						_tmp606_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp605_);
						_tmp607_ = _tmp606_;
						_vala_ccode_node_unref0 (_tmp605_);
						k = _tmp607_;
						_tmp608_ = k;
						_tmp609_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp610_ = _tmp609_;
						vala_ccode_function_call_add_argument (_tmp608_, _tmp610_);
						_vala_ccode_node_unref0 (_tmp610_);
						_tmp611_ = k;
						_tmp612_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp611_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp612_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp613_;
					ValaCCodeIdentifier* _tmp614_;
					ValaCCodeFunctionCall* _tmp615_;
					ValaCCodeFunctionCall* _tmp616_;
					ValaCCodeFunctionCall* _tmp617_;
					ValaMemberAccess* _tmp618_;
					ValaExpression* _tmp619_;
					ValaExpression* _tmp620_;
					ValaCCodeExpression* _tmp621_;
					ValaCCodeExpression* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaCCodeExpression* _tmp624_;
					_tmp613_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp614_);
					_tmp616_ = _tmp615_;
					_vala_ccode_node_unref0 (_tmp614_);
					k = _tmp616_;
					_tmp617_ = k;
					_tmp618_ = ma;
					_tmp619_ = vala_member_access_get_inner (_tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp620_);
					_tmp622_ = _tmp621_;
					vala_ccode_function_call_add_argument (_tmp617_, _tmp622_);
					_vala_ccode_node_unref0 (_tmp622_);
					_tmp623_ = k;
					_tmp624_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp623_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp624_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp625_ = cast;
				_tmp626_ = klass;
				vala_ccode_function_call_add_argument (_tmp625_, _tmp626_);
				_tmp627_ = in_arg_map;
				_tmp628_ = m;
				_tmp629_ = cast;
				vala_map_set ((ValaMap*) _tmp627_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp628_), FALSE)), (ValaCCodeExpression*) _tmp629_);
				_tmp630_ = out_arg_map;
				_tmp631_ = m;
				_tmp632_ = cast;
				vala_map_set ((ValaMap*) _tmp630_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp631_), FALSE)), (ValaCCodeExpression*) _tmp632_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp634_ = m;
	if (_tmp634_ != NULL) {
		ValaMethod* _tmp635_;
		_tmp635_ = m;
		_tmp633_ = vala_get_ccode_has_generic_type_parameter (_tmp635_);
	} else {
		_tmp633_ = FALSE;
	}
	if (_tmp633_) {
		ValaMethod* _tmp636_;
		_tmp636_ = m;
		if (vala_method_has_type_parameters (_tmp636_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp637_;
				ValaList* _tmp638_;
				gint _type_arg_size = 0;
				ValaList* _tmp639_;
				gint _tmp640_;
				gint _tmp641_;
				gint _type_arg_index = 0;
				_tmp637_ = ma;
				_tmp638_ = vala_member_access_get_type_arguments (_tmp637_);
				_type_arg_list = _tmp638_;
				_tmp639_ = _type_arg_list;
				_tmp640_ = vala_collection_get_size ((ValaCollection*) _tmp639_);
				_tmp641_ = _tmp640_;
				_type_arg_size = _tmp641_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp642_;
					gpointer _tmp643_;
					gboolean _tmp644_ = FALSE;
					gboolean _tmp645_ = FALSE;
					gboolean _tmp646_ = FALSE;
					ValaMethod* _tmp647_;
					ValaHashMap* _tmp655_;
					ValaMethod* _tmp656_;
					ValaDataType* _tmp657_;
					gchar* _tmp658_;
					gchar* _tmp659_;
					ValaCCodeIdentifier* _tmp660_;
					ValaCCodeIdentifier* _tmp661_;
					gint _tmp662_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp642_ = _type_arg_list;
					_tmp643_ = vala_list_get (_tmp642_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp643_;
					_tmp647_ = m;
					if (vala_get_ccode_simple_generics (_tmp647_)) {
						ValaDataType* _tmp648_;
						_tmp648_ = type_arg;
						_tmp646_ = vala_data_type_is_real_struct_type (_tmp648_);
					} else {
						_tmp646_ = FALSE;
					}
					if (_tmp646_) {
						ValaDataType* _tmp649_;
						gboolean _tmp650_;
						gboolean _tmp651_;
						_tmp649_ = type_arg;
						_tmp650_ = vala_data_type_get_nullable (_tmp649_);
						_tmp651_ = _tmp650_;
						_tmp645_ = !_tmp651_;
					} else {
						_tmp645_ = FALSE;
					}
					if (_tmp645_) {
						ValaDataType* _tmp652_;
						_tmp652_ = type_arg;
						_tmp644_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp652_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp644_ = FALSE;
					}
					if (_tmp644_) {
						ValaDataType* _tmp653_;
						ValaPointerType* _tmp654_;
						_tmp653_ = type_arg;
						_tmp654_ = vala_pointer_type_new (_tmp653_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp654_;
					}
					_tmp655_ = in_arg_map;
					_tmp656_ = m;
					_tmp657_ = type_arg;
					_tmp658_ = vala_get_ccode_name ((ValaCodeNode*) _tmp657_);
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_ccode_identifier_new (_tmp659_);
					_tmp661_ = _tmp660_;
					vala_map_set ((ValaMap*) _tmp655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp656_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp661_);
					_vala_ccode_node_unref0 (_tmp661_);
					_g_free0 (_tmp659_);
					_tmp662_ = type_param_index;
					type_param_index = _tmp662_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp663_;
				ValaExpression* _tmp664_;
				ValaExpression* _tmp665_;
				ValaDataType* _tmp666_;
				ValaDataType* _tmp667_;
				ValaList* _tmp668_;
				gint _type_arg_size = 0;
				ValaList* _tmp669_;
				gint _tmp670_;
				gint _tmp671_;
				gint _type_arg_index = 0;
				_tmp663_ = ma;
				_tmp664_ = vala_member_access_get_inner (_tmp663_);
				_tmp665_ = _tmp664_;
				_tmp666_ = vala_expression_get_value_type (_tmp665_);
				_tmp667_ = _tmp666_;
				_tmp668_ = vala_data_type_get_type_arguments (_tmp667_);
				_type_arg_list = _tmp668_;
				_tmp669_ = _type_arg_list;
				_tmp670_ = vala_collection_get_size ((ValaCollection*) _tmp669_);
				_tmp671_ = _tmp670_;
				_type_arg_size = _tmp671_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp672_;
					gpointer _tmp673_;
					ValaHashMap* _tmp674_;
					ValaMethod* _tmp675_;
					ValaDataType* _tmp676_;
					gchar* _tmp677_;
					gchar* _tmp678_;
					ValaCCodeIdentifier* _tmp679_;
					ValaCCodeIdentifier* _tmp680_;
					gint _tmp681_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp672_ = _type_arg_list;
					_tmp673_ = vala_list_get (_tmp672_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp673_;
					_tmp674_ = in_arg_map;
					_tmp675_ = m;
					_tmp676_ = type_arg;
					_tmp677_ = vala_get_ccode_name ((ValaCodeNode*) _tmp676_);
					_tmp678_ = _tmp677_;
					_tmp679_ = vala_ccode_identifier_new (_tmp678_);
					_tmp680_ = _tmp679_;
					vala_map_set ((ValaMap*) _tmp674_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp675_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp680_);
					_vala_ccode_node_unref0 (_tmp680_);
					_g_free0 (_tmp678_);
					_tmp681_ = type_param_index;
					type_param_index = _tmp681_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp682_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp682_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp683_;
		ValaExpression* _tmp684_;
		ValaExpression* _tmp685_;
		ValaDataType* _tmp686_;
		ValaDataType* _tmp687_;
		ValaArrayType* _tmp688_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp689_;
		ValaCCodeIdentifier* _tmp690_;
		ValaCCodeFunctionCall* _tmp691_;
		ValaCCodeFunctionCall* _tmp692_;
		ValaCCodeFunctionCall* _tmp693_;
		ValaArrayType* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		gchar* _tmp697_;
		gchar* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeIdentifier* _tmp700_;
		ValaHashMap* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		_tmp683_ = ma;
		_tmp684_ = vala_member_access_get_inner (_tmp683_);
		_tmp685_ = _tmp684_;
		_tmp686_ = vala_expression_get_value_type (_tmp685_);
		_tmp687_ = _tmp686_;
		_tmp688_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp687_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp688_;
		_tmp689_ = vala_ccode_identifier_new ("sizeof");
		_tmp690_ = _tmp689_;
		_tmp691_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp690_);
		_tmp692_ = _tmp691_;
		_vala_ccode_node_unref0 (_tmp690_);
		csizeof = _tmp692_;
		_tmp693_ = csizeof;
		_tmp694_ = array_type;
		_tmp695_ = vala_array_type_get_element_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = vala_get_ccode_name ((ValaCodeNode*) _tmp696_);
		_tmp698_ = _tmp697_;
		_tmp699_ = vala_ccode_identifier_new (_tmp698_);
		_tmp700_ = _tmp699_;
		vala_ccode_function_call_add_argument (_tmp693_, (ValaCCodeExpression*) _tmp700_);
		_vala_ccode_node_unref0 (_tmp700_);
		_g_free0 (_tmp698_);
		_tmp701_ = in_arg_map;
		_tmp702_ = csizeof;
		vala_map_set ((ValaMap*) _tmp701_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp702_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp703_;
		_tmp703_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp703_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp704_;
			gint param_nr = 0;
			ValaMethod* _tmp764_;
			_tmp704_ = m;
			vala_method_clear_parameters (_tmp704_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp705_;
				gint _arg_size = 0;
				ValaList* _tmp706_;
				gint _tmp707_;
				gint _tmp708_;
				gint _arg_index = 0;
				_tmp705_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp705_;
				_tmp706_ = _arg_list;
				_tmp707_ = vala_collection_get_size ((ValaCollection*) _tmp706_);
				_tmp708_ = _tmp707_;
				_arg_size = _tmp708_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp709_;
					gpointer _tmp710_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp711_;
					ValaUnaryExpression* _tmp712_;
					gboolean _tmp713_ = FALSE;
					ValaUnaryExpression* _tmp714_;
					gint _tmp755_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp709_ = _arg_list;
					_tmp710_ = vala_list_get (_tmp709_, _arg_index);
					arg = (ValaExpression*) _tmp710_;
					_tmp711_ = arg;
					_tmp712_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp711_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp711_) : NULL);
					unary = _tmp712_;
					_tmp714_ = unary;
					if (_tmp714_ != NULL) {
						ValaUnaryExpression* _tmp715_;
						ValaUnaryOperator _tmp716_;
						ValaUnaryOperator _tmp717_;
						_tmp715_ = unary;
						_tmp716_ = vala_unary_expression_get_operator (_tmp715_);
						_tmp717_ = _tmp716_;
						_tmp713_ = _tmp717_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp713_ = FALSE;
					}
					if (_tmp713_) {
						ValaParameter* param = NULL;
						gchar* _tmp718_;
						gchar* _tmp719_;
						ValaUnaryExpression* _tmp720_;
						ValaExpression* _tmp721_;
						ValaExpression* _tmp722_;
						ValaDataType* _tmp723_;
						ValaDataType* _tmp724_;
						ValaParameter* _tmp725_;
						ValaParameter* _tmp726_;
						ValaParameter* _tmp727_;
						ValaMethod* _tmp728_;
						ValaParameter* _tmp729_;
						_tmp718_ = g_strdup_printf ("param%d", param_nr);
						_tmp719_ = _tmp718_;
						_tmp720_ = unary;
						_tmp721_ = vala_unary_expression_get_inner (_tmp720_);
						_tmp722_ = _tmp721_;
						_tmp723_ = vala_expression_get_value_type (_tmp722_);
						_tmp724_ = _tmp723_;
						_tmp725_ = vala_parameter_new (_tmp719_, _tmp724_, NULL);
						_tmp726_ = _tmp725_;
						_g_free0 (_tmp719_);
						param = _tmp726_;
						_tmp727_ = param;
						vala_parameter_set_direction (_tmp727_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp728_ = m;
						_tmp729_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp728_, _tmp729_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp730_ = FALSE;
						ValaUnaryExpression* _tmp731_;
						_tmp731_ = unary;
						if (_tmp731_ != NULL) {
							ValaUnaryExpression* _tmp732_;
							ValaUnaryOperator _tmp733_;
							ValaUnaryOperator _tmp734_;
							_tmp732_ = unary;
							_tmp733_ = vala_unary_expression_get_operator (_tmp732_);
							_tmp734_ = _tmp733_;
							_tmp730_ = _tmp734_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp730_ = FALSE;
						}
						if (_tmp730_) {
							ValaParameter* param = NULL;
							gchar* _tmp735_;
							gchar* _tmp736_;
							ValaUnaryExpression* _tmp737_;
							ValaExpression* _tmp738_;
							ValaExpression* _tmp739_;
							ValaDataType* _tmp740_;
							ValaDataType* _tmp741_;
							ValaParameter* _tmp742_;
							ValaParameter* _tmp743_;
							ValaParameter* _tmp744_;
							ValaMethod* _tmp745_;
							ValaParameter* _tmp746_;
							_tmp735_ = g_strdup_printf ("param%d", param_nr);
							_tmp736_ = _tmp735_;
							_tmp737_ = unary;
							_tmp738_ = vala_unary_expression_get_inner (_tmp737_);
							_tmp739_ = _tmp738_;
							_tmp740_ = vala_expression_get_value_type (_tmp739_);
							_tmp741_ = _tmp740_;
							_tmp742_ = vala_parameter_new (_tmp736_, _tmp741_, NULL);
							_tmp743_ = _tmp742_;
							_g_free0 (_tmp736_);
							param = _tmp743_;
							_tmp744_ = param;
							vala_parameter_set_direction (_tmp744_, VALA_PARAMETER_DIRECTION_REF);
							_tmp745_ = m;
							_tmp746_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp745_, _tmp746_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp747_;
							gchar* _tmp748_;
							gchar* _tmp749_;
							ValaExpression* _tmp750_;
							ValaDataType* _tmp751_;
							ValaDataType* _tmp752_;
							ValaParameter* _tmp753_;
							ValaParameter* _tmp754_;
							_tmp747_ = m;
							_tmp748_ = g_strdup_printf ("param%d", param_nr);
							_tmp749_ = _tmp748_;
							_tmp750_ = arg;
							_tmp751_ = vala_expression_get_value_type (_tmp750_);
							_tmp752_ = _tmp751_;
							_tmp753_ = vala_parameter_new (_tmp749_, _tmp752_, NULL);
							_tmp754_ = _tmp753_;
							vala_callable_add_parameter ((ValaCallable*) _tmp747_, _tmp754_);
							_vala_code_node_unref0 (_tmp754_);
							_g_free0 (_tmp749_);
						}
					}
					_tmp755_ = param_nr;
					param_nr = _tmp755_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp756_;
				ValaList* _tmp757_;
				gint _param_size = 0;
				ValaList* _tmp758_;
				gint _tmp759_;
				gint _tmp760_;
				gint _param_index = 0;
				_tmp756_ = m;
				_tmp757_ = vala_callable_get_parameters ((ValaCallable*) _tmp756_);
				_param_list = _tmp757_;
				_tmp758_ = _param_list;
				_tmp759_ = vala_collection_get_size ((ValaCollection*) _tmp758_);
				_tmp760_ = _tmp759_;
				_param_size = _tmp760_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp761_;
					gpointer _tmp762_;
					ValaParameter* _tmp763_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp761_ = _param_list;
					_tmp762_ = vala_list_get (_tmp761_, _param_index);
					param = (ValaParameter*) _tmp762_;
					_tmp763_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp763_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp764_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp764_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp765_ = FALSE;
			gboolean _tmp766_ = FALSE;
			ValaMethod* _tmp767_;
			_tmp767_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp767_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp768_;
				ValaCodeContext* _tmp769_;
				ValaProfile _tmp770_;
				ValaProfile _tmp771_;
				_tmp768_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp769_ = _tmp768_;
				_tmp770_ = vala_code_context_get_profile (_tmp769_);
				_tmp771_ = _tmp770_;
				_tmp766_ = _tmp771_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp766_ = FALSE;
			}
			if (_tmp766_) {
				ValaMethod* _tmp772_;
				ValaSymbol* _tmp773_;
				ValaSymbol* _tmp774_;
				_tmp772_ = m;
				_tmp773_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp772_);
				_tmp774_ = _tmp773_;
				_tmp765_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp774_, VALA_TYPE_CLASS);
			} else {
				_tmp765_ = FALSE;
			}
			if (_tmp765_) {
				ValaCCodeFunction* _tmp775_;
				ValaCCodeFunction* _tmp776_;
				ValaCCodeExpression* _tmp777_;
				ValaCCodeExpression* _tmp778_;
				ValaCCodeFunctionCall* _tmp779_;
				ValaClass* _tmp780_;
				ValaClass* _tmp781_;
				gchar* _tmp782_;
				gchar* _tmp783_;
				gchar* _tmp784_;
				gchar* _tmp785_;
				ValaCCodeCastExpression* _tmp786_;
				ValaCCodeCastExpression* _tmp787_;
				ValaMethod* _tmp788_;
				ValaMethod* _tmp789_;
				ValaBlock* _tmp790_;
				ValaBlock* _tmp791_;
				gboolean _tmp792_;
				gboolean _tmp793_;
				gboolean _tmp820_ = FALSE;
				ValaClass* _tmp821_;
				ValaClass* _tmp822_;
				gboolean _tmp823_;
				gboolean _tmp824_;
				_tmp775_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp776_ = _tmp775_;
				_tmp777_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp778_ = _tmp777_;
				_tmp779_ = ccall;
				_tmp780_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp781_ = _tmp780_;
				_tmp782_ = vala_get_ccode_name ((ValaCodeNode*) _tmp781_);
				_tmp783_ = _tmp782_;
				_tmp784_ = g_strconcat (_tmp783_, "*", NULL);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp779_, _tmp785_);
				_tmp787_ = _tmp786_;
				vala_ccode_function_add_assignment (_tmp776_, _tmp778_, (ValaCCodeExpression*) _tmp787_);
				_vala_ccode_node_unref0 (_tmp787_);
				_g_free0 (_tmp785_);
				_g_free0 (_tmp783_);
				_vala_ccode_node_unref0 (_tmp778_);
				_tmp788_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp789_ = _tmp788_;
				_tmp790_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp789_);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_block_get_captured (_tmp791_);
				_tmp793_ = _tmp792_;
				if (_tmp793_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp794_;
					ValaClass* _tmp795_;
					ValaObjectType* _tmp796_;
					ValaObjectType* _tmp797_;
					ValaSourceReference* _tmp798_;
					ValaSourceReference* _tmp799_;
					ValaCCodeExpression* _tmp800_;
					ValaCCodeExpression* _tmp801_;
					ValaCCodeFunctionCall* _tmp802_;
					ValaCCodeFunctionCall* _tmp803_;
					ValaCCodeFunctionCall* _tmp804_;
					ValaCCodeExpression* _tmp805_;
					ValaCCodeExpression* _tmp806_;
					ValaCCodeFunction* _tmp807_;
					ValaCCodeFunction* _tmp808_;
					ValaMethod* _tmp809_;
					ValaMethod* _tmp810_;
					ValaBlock* _tmp811_;
					ValaBlock* _tmp812_;
					gchar* _tmp813_;
					gchar* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeMemberAccess* _tmp817_;
					ValaCCodeMemberAccess* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					_tmp794_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp795_ = _tmp794_;
					_tmp796_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp795_);
					_tmp797_ = _tmp796_;
					_tmp798_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp799_ = _tmp798_;
					_tmp800_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp797_, _tmp799_, FALSE);
					_tmp801_ = _tmp800_;
					_tmp802_ = vala_ccode_function_call_new (_tmp801_);
					_tmp803_ = _tmp802_;
					_vala_ccode_node_unref0 (_tmp801_);
					_vala_code_node_unref0 (_tmp797_);
					ref_call = _tmp803_;
					_tmp804_ = ref_call;
					_tmp805_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp806_ = _tmp805_;
					vala_ccode_function_call_add_argument (_tmp804_, _tmp806_);
					_vala_ccode_node_unref0 (_tmp806_);
					_tmp807_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp812_));
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp814_);
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_member_access_new_pointer (_tmp816_, "self");
					_tmp818_ = _tmp817_;
					_tmp819_ = ref_call;
					vala_ccode_function_add_assignment (_tmp808_, (ValaCCodeExpression*) _tmp818_, (ValaCCodeExpression*) _tmp819_);
					_vala_ccode_node_unref0 (_tmp818_);
					_vala_ccode_node_unref0 (_tmp816_);
					_g_free0 (_tmp814_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp821_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp822_ = _tmp821_;
				_tmp823_ = vala_class_get_is_compact (_tmp822_);
				_tmp824_ = _tmp823_;
				if (!_tmp824_) {
					ValaClass* _tmp825_;
					ValaClass* _tmp826_;
					_tmp825_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp826_ = _tmp825_;
					_tmp820_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp826_);
				} else {
					_tmp820_ = FALSE;
				}
				if (_tmp820_) {
					gchar** suffices = NULL;
					gchar* _tmp827_;
					gchar* _tmp828_;
					gchar* _tmp829_;
					gchar** _tmp830_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp827_ = g_strdup ("type");
					_tmp828_ = g_strdup ("dup_func");
					_tmp829_ = g_strdup ("destroy_func");
					_tmp830_ = g_new0 (gchar*, 3 + 1);
					_tmp830_[0] = _tmp827_;
					_tmp830_[1] = _tmp828_;
					_tmp830_[2] = _tmp829_;
					suffices = _tmp830_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp831_;
						ValaClass* _tmp832_;
						ValaList* _tmp833_;
						gint _type_param_size = 0;
						ValaList* _tmp834_;
						gint _tmp835_;
						gint _tmp836_;
						gint _type_param_index = 0;
						_tmp831_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp832_ = _tmp831_;
						_tmp833_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp832_);
						_type_param_list = _tmp833_;
						_tmp834_ = _type_param_list;
						_tmp835_ = vala_collection_get_size ((ValaCollection*) _tmp834_);
						_tmp836_ = _tmp835_;
						_type_param_size = _tmp836_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp837_;
							gpointer _tmp838_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp839_;
							ValaCCodeIdentifier* _tmp840_;
							ValaCCodeMemberAccess* _tmp841_;
							ValaCCodeMemberAccess* _tmp842_;
							gchar** _tmp843_;
							gint _tmp843__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp837_ = _type_param_list;
							_tmp838_ = vala_list_get (_tmp837_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp838_;
							_tmp839_ = vala_ccode_identifier_new ("self");
							_tmp840_ = _tmp839_;
							_tmp841_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp840_, "priv");
							_tmp842_ = _tmp841_;
							_vala_ccode_node_unref0 (_tmp840_);
							priv_access = _tmp842_;
							_tmp843_ = suffices;
							_tmp843__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp843_;
								suffix_collection_length1 = _tmp843__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp844_;
									gchar* suffix = NULL;
									_tmp844_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp844_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp845_;
										const gchar* _tmp846_;
										const gchar* _tmp847_;
										gchar* _tmp848_;
										gchar* _tmp849_;
										const gchar* _tmp850_;
										gchar* _tmp851_;
										gchar* _tmp852_;
										ValaCCodeIdentifier* _tmp853_;
										ValaCCodeIdentifier* _tmp854_;
										ValaCCodeFunction* _tmp855_;
										ValaCCodeFunction* _tmp856_;
										ValaCCodeMemberAccess* _tmp857_;
										ValaCCodeIdentifier* _tmp858_;
										const gchar* _tmp859_;
										const gchar* _tmp860_;
										ValaCCodeMemberAccess* _tmp861_;
										ValaCCodeMemberAccess* _tmp862_;
										ValaCCodeIdentifier* _tmp863_;
										_tmp845_ = type_param;
										_tmp846_ = vala_symbol_get_name ((ValaSymbol*) _tmp845_);
										_tmp847_ = _tmp846_;
										_tmp848_ = g_utf8_strdown (_tmp847_, (gssize) -1);
										_tmp849_ = _tmp848_;
										_tmp850_ = suffix;
										_tmp851_ = g_strdup_printf ("%s_%s", _tmp849_, _tmp850_);
										_tmp852_ = _tmp851_;
										_tmp853_ = vala_ccode_identifier_new (_tmp852_);
										_tmp854_ = _tmp853_;
										_g_free0 (_tmp852_);
										_g_free0 (_tmp849_);
										param_name = _tmp854_;
										_tmp855_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp856_ = _tmp855_;
										_tmp857_ = priv_access;
										_tmp858_ = param_name;
										_tmp859_ = vala_ccode_identifier_get_name (_tmp858_);
										_tmp860_ = _tmp859_;
										_tmp861_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp857_, _tmp860_);
										_tmp862_ = _tmp861_;
										_tmp863_ = param_name;
										vala_ccode_function_add_assignment (_tmp856_, (ValaCCodeExpression*) _tmp862_, (ValaCCodeExpression*) _tmp863_);
										_vala_ccode_node_unref0 (_tmp862_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp864_ = params;
	_tmp865_ = vala_iterable_iterator ((ValaIterable*) _tmp864_);
	params_it = _tmp865_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp866_;
		gint _arg_size = 0;
		ValaList* _tmp867_;
		gint _tmp868_;
		gint _tmp869_;
		gint _arg_index = 0;
		_tmp866_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp866_;
		_tmp867_ = _arg_list;
		_tmp868_ = vala_collection_get_size ((ValaCollection*) _tmp867_);
		_tmp869_ = _tmp868_;
		_arg_size = _tmp869_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp870_;
			gpointer _tmp871_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp872_;
			ValaCCodeExpression* _tmp873_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp874_;
			ValaHashMap* _tmp875_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp876_;
			gboolean _tmp886_ = FALSE;
			ValaParameter* _tmp887_;
			gdouble _tmp1213_ = 0.0;
			ValaParameter* _tmp1214_;
			ValaHashMap* _tmp1216_;
			ValaCCodeExpression* _tmp1217_;
			gboolean _tmp1218_ = FALSE;
			ValaExpression* _tmp1219_;
			gint _tmp1236_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp870_ = _arg_list;
			_tmp871_ = vala_list_get (_tmp870_, _arg_index);
			arg = (ValaExpression*) _tmp871_;
			_tmp872_ = arg;
			_tmp873_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp872_);
			cexpr = _tmp873_;
			_tmp874_ = in_arg_map;
			_tmp875_ = _vala_map_ref0 (_tmp874_);
			carg_map = _tmp875_;
			param = NULL;
			_tmp876_ = params_it;
			if (vala_iterator_next (_tmp876_)) {
				ValaIterator* _tmp877_;
				gpointer _tmp878_;
				gboolean _tmp879_ = FALSE;
				ValaParameter* _tmp880_;
				gboolean _tmp881_;
				gboolean _tmp882_;
				_tmp877_ = params_it;
				_tmp878_ = vala_iterator_get (_tmp877_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp878_;
				_tmp880_ = param;
				_tmp881_ = vala_parameter_get_params_array (_tmp880_);
				_tmp882_ = _tmp881_;
				if (_tmp882_) {
					_tmp879_ = TRUE;
				} else {
					ValaParameter* _tmp883_;
					gboolean _tmp884_;
					gboolean _tmp885_;
					_tmp883_ = param;
					_tmp884_ = vala_parameter_get_ellipsis (_tmp883_);
					_tmp885_ = _tmp884_;
					_tmp879_ = _tmp885_;
				}
				ellipsis = _tmp879_;
			}
			_tmp887_ = param;
			if (_tmp887_ != NULL) {
				_tmp886_ = !ellipsis;
			} else {
				_tmp886_ = FALSE;
			}
			if (_tmp886_) {
				ValaParameter* _tmp888_;
				ValaParameterDirection _tmp889_;
				ValaParameterDirection _tmp890_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp893_;
				ValaUnaryExpression* _tmp894_;
				gboolean _tmp895_ = FALSE;
				ValaUnaryExpression* _tmp896_;
				ValaParameter* _tmp1164_;
				gchar* _tmp1165_;
				gchar* _tmp1166_;
				gboolean _tmp1167_;
				_tmp888_ = param;
				_tmp889_ = vala_parameter_get_direction (_tmp888_);
				_tmp890_ = _tmp889_;
				if (_tmp890_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp891_;
					ValaHashMap* _tmp892_;
					_tmp891_ = out_arg_map;
					_tmp892_ = _vala_map_ref0 (_tmp891_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp892_;
				}
				_tmp893_ = arg;
				_tmp894_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp893_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp893_) : NULL);
				unary = _tmp894_;
				_tmp896_ = unary;
				if (_tmp896_ == NULL) {
					_tmp895_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp897_;
					ValaUnaryOperator _tmp898_;
					ValaUnaryOperator _tmp899_;
					_tmp897_ = unary;
					_tmp898_ = vala_unary_expression_get_operator (_tmp897_);
					_tmp899_ = _tmp898_;
					_tmp895_ = _tmp899_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp895_) {
					gboolean _tmp900_ = FALSE;
					gboolean _tmp901_ = FALSE;
					ValaParameter* _tmp902_;
					ValaParameter* _tmp1038_;
					ValaExpression* _tmp1039_;
					ValaCCodeExpression* _tmp1040_;
					ValaCCodeExpression* _tmp1041_;
					_tmp902_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp902_)) {
						ValaParameter* _tmp903_;
						ValaDataType* _tmp904_;
						ValaDataType* _tmp905_;
						_tmp903_ = param;
						_tmp904_ = vala_variable_get_variable_type ((ValaVariable*) _tmp903_);
						_tmp905_ = _tmp904_;
						_tmp901_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp905_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp901_ = FALSE;
					}
					if (_tmp901_) {
						ValaParameter* _tmp906_;
						ValaDataType* _tmp907_;
						ValaDataType* _tmp908_;
						gboolean _tmp909_;
						gboolean _tmp910_;
						_tmp906_ = param;
						_tmp907_ = vala_variable_get_variable_type ((ValaVariable*) _tmp906_);
						_tmp908_ = _tmp907_;
						_tmp909_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp908_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp910_ = _tmp909_;
						_tmp900_ = !_tmp910_;
					} else {
						_tmp900_ = FALSE;
					}
					if (_tmp900_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp911_;
						ValaDataType* _tmp912_;
						ValaDataType* _tmp913_;
						ValaArrayType* _tmp914_;
						gchar* _tmp915_ = NULL;
						ValaParameter* _tmp916_;
						gchar* _tmp917_;
						gchar* length_ctype = NULL;
						gchar* _tmp920_;
						gboolean _tmp921_ = FALSE;
						ValaUnaryExpression* _tmp922_;
						_tmp911_ = param;
						_tmp912_ = vala_variable_get_variable_type ((ValaVariable*) _tmp911_);
						_tmp913_ = _tmp912_;
						_tmp914_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp913_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp914_;
						_tmp916_ = param;
						_tmp917_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp916_);
						_tmp915_ = _tmp917_;
						if (_tmp915_ == NULL) {
							ValaArrayType* _tmp918_;
							gchar* _tmp919_;
							_tmp918_ = array_type;
							_tmp919_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp918_);
							_g_free0 (_tmp915_);
							_tmp915_ = _tmp919_;
						}
						_tmp920_ = g_strdup (_tmp915_);
						length_ctype = _tmp920_;
						_tmp922_ = unary;
						if (_tmp922_ != NULL) {
							ValaUnaryExpression* _tmp923_;
							ValaUnaryOperator _tmp924_;
							ValaUnaryOperator _tmp925_;
							_tmp923_ = unary;
							_tmp924_ = vala_unary_expression_get_operator (_tmp923_);
							_tmp925_ = _tmp924_;
							_tmp921_ = _tmp925_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp921_ = FALSE;
						}
						if (_tmp921_) {
							const gchar* _tmp926_;
							gchar* _tmp927_;
							_tmp926_ = length_ctype;
							_tmp927_ = g_strdup_printf ("%s*", _tmp926_);
							_g_free0 (length_ctype);
							length_ctype = _tmp927_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp928_ = FALSE;
								_tmp928_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp930_;
									gint _tmp931_;
									gint _tmp932_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp933_;
									ValaCCodeExpression* _tmp934_;
									ValaCCodeExpression* _tmp935_;
									const gchar* _tmp936_;
									ValaCCodeCastExpression* _tmp937_;
									ValaCCodeCastExpression* _tmp938_;
									ValaHashMap* _tmp939_;
									ValaParameter* _tmp940_;
									ValaCCodeCastExpression* _tmp941_;
									if (!_tmp928_) {
										gint _tmp929_;
										_tmp929_ = dim;
										dim = _tmp929_ + 1;
									}
									_tmp928_ = FALSE;
									_tmp930_ = array_type;
									_tmp931_ = vala_array_type_get_rank (_tmp930_);
									_tmp932_ = _tmp931_;
									if (!(dim <= _tmp932_)) {
										break;
									}
									_tmp933_ = arg;
									_tmp934_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp933_, dim);
									_tmp935_ = _tmp934_;
									_tmp936_ = length_ctype;
									_tmp937_ = vala_ccode_cast_expression_new (_tmp935_, _tmp936_);
									_tmp938_ = _tmp937_;
									_vala_ccode_node_unref0 (_tmp935_);
									array_length_expr = _tmp938_;
									_tmp939_ = carg_map;
									_tmp940_ = param;
									_tmp941_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp939_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp940_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp941_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp915_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp942_;
						ValaDataType* _tmp943_;
						ValaDataType* _tmp944_;
						_tmp942_ = param;
						_tmp943_ = vala_variable_get_variable_type ((ValaVariable*) _tmp942_);
						_tmp944_ = _tmp943_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp944_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp945_;
							ValaDataType* _tmp946_;
							ValaDataType* _tmp947_;
							ValaDelegateType* _tmp948_;
							ValaDelegateType* _tmp949_;
							ValaDelegate* _tmp950_;
							ValaDelegate* _tmp951_;
							gboolean _tmp952_;
							gboolean _tmp953_;
							_tmp945_ = param;
							_tmp946_ = vala_variable_get_variable_type ((ValaVariable*) _tmp945_);
							_tmp947_ = _tmp946_;
							_tmp948_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp947_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp948_;
							_tmp949_ = deleg_type;
							_tmp950_ = vala_delegate_type_get_delegate_symbol (_tmp949_);
							_tmp951_ = _tmp950_;
							_tmp952_ = vala_delegate_get_has_target (_tmp951_);
							_tmp953_ = _tmp952_;
							if (_tmp953_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp954_;
								ValaCCodeExpression* _tmp955_ = NULL;
								ValaCCodeExpression* _tmp956_;
								ValaCCodeExpression* _tmp957_;
								ValaParameter* _tmp958_;
								gchar* _tmp959_;
								gchar* _tmp960_;
								gboolean _tmp961_;
								_tmp954_ = arg;
								_tmp956_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp954_, &_tmp955_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp955_;
								delegate_target = _tmp956_;
								_tmp957_ = delegate_target;
								_vala_assert (_tmp957_ != NULL, "delegate_target != null");
								_tmp958_ = param;
								_tmp959_ = vala_get_ccode_type ((ValaCodeNode*) _tmp958_);
								_tmp960_ = _tmp959_;
								_tmp961_ = g_strcmp0 (_tmp960_, "GClosure*") == 0;
								_g_free0 (_tmp960_);
								if (_tmp961_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp962_;
									ValaCCodeIdentifier* _tmp963_;
									ValaCCodeFunctionCall* _tmp964_;
									ValaCCodeFunctionCall* _tmp965_;
									ValaCCodeFunctionCall* _tmp966_;
									ValaCCodeExpression* _tmp967_;
									ValaCCodeCastExpression* _tmp968_;
									ValaCCodeCastExpression* _tmp969_;
									ValaCCodeFunctionCall* _tmp970_;
									ValaCCodeExpression* _tmp971_;
									ValaCCodeFunctionCall* _tmp972_;
									ValaCCodeExpression* _tmp973_;
									ValaCCodeCastExpression* _tmp974_;
									ValaCCodeCastExpression* _tmp975_;
									ValaCCodeExpression* _tmp976_;
									ValaCCodeIdentifier* _tmp977_;
									ValaCCodeIdentifier* _tmp978_;
									ValaCCodeBinaryExpression* _tmp979_;
									ValaCCodeBinaryExpression* _tmp980_;
									ValaCCodeIdentifier* _tmp981_;
									ValaCCodeIdentifier* _tmp982_;
									ValaCCodeFunctionCall* _tmp983_;
									ValaCCodeConditionalExpression* _tmp984_;
									_tmp962_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp963_ = _tmp962_;
									_tmp964_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp963_);
									_tmp965_ = _tmp964_;
									_vala_ccode_node_unref0 (_tmp963_);
									closure_new = _tmp965_;
									_tmp966_ = closure_new;
									_tmp967_ = cexpr;
									_tmp968_ = vala_ccode_cast_expression_new (_tmp967_, "GCallback");
									_tmp969_ = _tmp968_;
									vala_ccode_function_call_add_argument (_tmp966_, (ValaCCodeExpression*) _tmp969_);
									_vala_ccode_node_unref0 (_tmp969_);
									_tmp970_ = closure_new;
									_tmp971_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp970_, _tmp971_);
									_tmp972_ = closure_new;
									_tmp973_ = delegate_target_destroy_notify;
									_tmp974_ = vala_ccode_cast_expression_new (_tmp973_, "GClosureNotify");
									_tmp975_ = _tmp974_;
									vala_ccode_function_call_add_argument (_tmp972_, (ValaCCodeExpression*) _tmp975_);
									_vala_ccode_node_unref0 (_tmp975_);
									_tmp976_ = cexpr;
									_tmp977_ = vala_ccode_identifier_new ("NULL");
									_tmp978_ = _tmp977_;
									_tmp979_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp976_, (ValaCCodeExpression*) _tmp978_);
									_tmp980_ = _tmp979_;
									_tmp981_ = vala_ccode_identifier_new ("NULL");
									_tmp982_ = _tmp981_;
									_tmp983_ = closure_new;
									_tmp984_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp980_, (ValaCCodeExpression*) _tmp982_, (ValaCCodeExpression*) _tmp983_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp984_;
									_vala_ccode_node_unref0 (_tmp982_);
									_vala_ccode_node_unref0 (_tmp980_);
									_vala_ccode_node_unref0 (_tmp978_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp985_;
									ValaParameter* _tmp986_;
									ValaCCodeExpression* _tmp987_;
									ValaDelegateType* _tmp988_;
									_tmp985_ = carg_map;
									_tmp986_ = param;
									_tmp987_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp985_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp986_), FALSE)), _tmp987_);
									_tmp988_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp988_)) {
										ValaCCodeExpression* _tmp989_;
										ValaHashMap* _tmp990_;
										ValaParameter* _tmp991_;
										ValaCCodeExpression* _tmp992_;
										_tmp989_ = delegate_target_destroy_notify;
										_vala_assert (_tmp989_ != NULL, "delegate_target_destroy_notify != null");
										_tmp990_ = carg_map;
										_tmp991_ = param;
										_tmp992_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp990_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp991_) + 0.01, FALSE)), _tmp992_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp993_;
							ValaDataType* _tmp994_;
							ValaDataType* _tmp995_;
							_tmp993_ = param;
							_tmp994_ = vala_variable_get_variable_type ((ValaVariable*) _tmp993_);
							_tmp995_ = _tmp994_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp995_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp996_;
								ValaParameter* _tmp997_;
								ValaExpression* _tmp998_;
								ValaCCodeExpression* _tmp999_ = NULL;
								ValaCCodeExpression* _tmp1000_;
								ValaCCodeExpression* _tmp1001_;
								_tmp996_ = carg_map;
								_tmp997_ = param;
								_tmp998_ = arg;
								_tmp1000_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp998_, &_tmp999_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp999_;
								_tmp1001_ = _tmp1000_;
								vala_map_set ((ValaMap*) _tmp996_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp997_), FALSE)), _tmp1001_);
								_vala_ccode_node_unref0 (_tmp1001_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1002_;
								ValaDataType* _tmp1003_;
								ValaDataType* _tmp1004_;
								_tmp1002_ = param;
								_tmp1003_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1002_);
								_tmp1004_ = _tmp1003_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1004_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1005_ = FALSE;
									ValaMethod* _tmp1006_;
									_tmp1006_ = m;
									if (_tmp1006_ != NULL) {
										ValaMethod* _tmp1007_;
										_tmp1007_ = m;
										_tmp1005_ = vala_get_ccode_simple_generics (_tmp1007_);
									} else {
										_tmp1005_ = FALSE;
									}
									if (_tmp1005_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1008_;
										ValaDataType* _tmp1009_;
										ValaDataType* _tmp1010_;
										ValaGenericType* _tmp1011_;
										gint type_param_index = 0;
										ValaMethod* _tmp1012_;
										ValaGenericType* _tmp1013_;
										ValaTypeParameter* _tmp1014_;
										ValaTypeParameter* _tmp1015_;
										const gchar* _tmp1016_;
										const gchar* _tmp1017_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1018_;
										ValaList* _tmp1019_;
										ValaList* _tmp1020_;
										gpointer _tmp1021_;
										ValaDataType* _tmp1022_;
										ValaParameter* _tmp1023_;
										ValaDataType* _tmp1024_;
										ValaDataType* _tmp1025_;
										gboolean _tmp1026_;
										gboolean _tmp1027_;
										_tmp1008_ = param;
										_tmp1009_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1008_);
										_tmp1010_ = _tmp1009_;
										_tmp1011_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1010_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1011_;
										_tmp1012_ = m;
										_tmp1013_ = generic_type;
										_tmp1014_ = vala_generic_type_get_type_parameter (_tmp1013_);
										_tmp1015_ = _tmp1014_;
										_tmp1016_ = vala_symbol_get_name ((ValaSymbol*) _tmp1015_);
										_tmp1017_ = _tmp1016_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1012_, _tmp1017_);
										_tmp1018_ = ma;
										_tmp1019_ = vala_member_access_get_type_arguments (_tmp1018_);
										_tmp1020_ = _tmp1019_;
										_tmp1021_ = vala_list_get (_tmp1020_, type_param_index);
										_tmp1022_ = (ValaDataType*) _tmp1021_;
										_vala_iterable_unref0 (_tmp1020_);
										type_arg = _tmp1022_;
										_tmp1023_ = param;
										_tmp1024_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1023_);
										_tmp1025_ = _tmp1024_;
										_tmp1026_ = vala_data_type_get_value_owned (_tmp1025_);
										_tmp1027_ = _tmp1026_;
										if (_tmp1027_) {
											ValaDataType* _tmp1028_;
											_tmp1028_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1028_)) {
												ValaHashMap* _tmp1029_;
												ValaParameter* _tmp1030_;
												ValaDataType* _tmp1031_;
												ValaCCodeExpression* _tmp1032_;
												ValaCCodeExpression* _tmp1033_;
												_tmp1029_ = carg_map;
												_tmp1030_ = param;
												_tmp1031_ = type_arg;
												_tmp1032_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1031_, FALSE);
												_tmp1033_ = _tmp1032_;
												vala_map_set ((ValaMap*) _tmp1029_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1030_), FALSE)), _tmp1033_);
												_vala_ccode_node_unref0 (_tmp1033_);
											} else {
												ValaHashMap* _tmp1034_;
												ValaParameter* _tmp1035_;
												ValaCCodeConstant* _tmp1036_;
												ValaCCodeConstant* _tmp1037_;
												_tmp1034_ = carg_map;
												_tmp1035_ = param;
												_tmp1036_ = vala_ccode_constant_new ("NULL");
												_tmp1037_ = _tmp1036_;
												vala_map_set ((ValaMap*) _tmp1034_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1035_), FALSE)), (ValaCCodeExpression*) _tmp1037_);
												_vala_ccode_node_unref0 (_tmp1037_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1038_ = param;
					_tmp1039_ = arg;
					_tmp1040_ = cexpr;
					_tmp1041_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1038_, _tmp1039_, _tmp1040_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1041_;
				} else {
					ValaExpression* _tmp1042_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1043_;
					ValaDataType* _tmp1044_;
					ValaDataType* _tmp1045_;
					ValaParameter* _tmp1046_;
					ValaDataType* _tmp1047_;
					ValaDataType* _tmp1048_;
					gboolean _tmp1049_;
					gboolean _tmp1050_;
					ValaLocalVariable* _tmp1051_;
					ValaLocalVariable* _tmp1052_;
					ValaExpression* _tmp1053_;
					ValaLocalVariable* _tmp1054_;
					const gchar* _tmp1055_;
					const gchar* _tmp1056_;
					ValaCCodeExpression* _tmp1057_;
					ValaCCodeExpression* _tmp1058_;
					ValaExpression* _tmp1059_;
					ValaTargetValue* _tmp1060_;
					ValaTargetValue* _tmp1061_;
					ValaExpression* _tmp1062_;
					ValaDataType* _tmp1063_;
					ValaDataType* _tmp1064_;
					ValaExpression* _tmp1065_;
					ValaCCodeExpression* _tmp1066_;
					ValaCCodeExpression* _tmp1067_;
					ValaCCodeUnaryExpression* _tmp1068_;
					gboolean _tmp1069_ = FALSE;
					gboolean _tmp1070_ = FALSE;
					ValaParameter* _tmp1071_;
					_tmp1042_ = arg;
					vala_expression_set_target_value (_tmp1042_, NULL);
					_tmp1043_ = param;
					_tmp1044_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1043_);
					_tmp1045_ = _tmp1044_;
					_tmp1046_ = param;
					_tmp1047_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1046_);
					_tmp1048_ = _tmp1047_;
					_tmp1049_ = vala_data_type_get_value_owned (_tmp1048_);
					_tmp1050_ = _tmp1049_;
					_tmp1051_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1045_, _tmp1050_, NULL, TRUE);
					temp_var = _tmp1051_;
					_tmp1052_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1052_, FALSE);
					_tmp1053_ = arg;
					_tmp1054_ = temp_var;
					_tmp1055_ = vala_symbol_get_name ((ValaSymbol*) _tmp1054_);
					_tmp1056_ = _tmp1055_;
					_tmp1057_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1056_);
					_tmp1058_ = _tmp1057_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1053_, _tmp1058_);
					_vala_ccode_node_unref0 (_tmp1058_);
					_tmp1059_ = arg;
					_tmp1060_ = vala_expression_get_target_value (_tmp1059_);
					_tmp1061_ = _tmp1060_;
					_tmp1062_ = arg;
					_tmp1063_ = vala_expression_get_target_type (_tmp1062_);
					_tmp1064_ = _tmp1063_;
					vala_target_value_set_value_type (_tmp1061_, _tmp1064_);
					_tmp1065_ = arg;
					_tmp1066_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1065_);
					_tmp1067_ = _tmp1066_;
					_tmp1068_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1067_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1068_;
					_vala_ccode_node_unref0 (_tmp1067_);
					_tmp1071_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1071_)) {
						ValaParameter* _tmp1072_;
						ValaDataType* _tmp1073_;
						ValaDataType* _tmp1074_;
						_tmp1072_ = param;
						_tmp1073_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1072_);
						_tmp1074_ = _tmp1073_;
						_tmp1070_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1074_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1070_ = FALSE;
					}
					if (_tmp1070_) {
						ValaParameter* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						gboolean _tmp1078_;
						gboolean _tmp1079_;
						_tmp1075_ = param;
						_tmp1076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1078_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1077_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1079_ = _tmp1078_;
						_tmp1069_ = !_tmp1079_;
					} else {
						_tmp1069_ = FALSE;
					}
					if (_tmp1069_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1080_;
						ValaDataType* _tmp1081_;
						ValaDataType* _tmp1082_;
						ValaArrayType* _tmp1083_;
						gchar* _tmp1084_ = NULL;
						ValaParameter* _tmp1085_;
						gchar* _tmp1086_;
						gchar* length_ctype = NULL;
						gchar* _tmp1089_;
						_tmp1080_ = param;
						_tmp1081_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1080_);
						_tmp1082_ = _tmp1081_;
						_tmp1083_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1082_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1083_;
						_tmp1085_ = param;
						_tmp1086_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1085_);
						_tmp1084_ = _tmp1086_;
						if (_tmp1084_ == NULL) {
							ValaArrayType* _tmp1087_;
							gchar* _tmp1088_;
							_tmp1087_ = array_type;
							_tmp1088_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1087_);
							_g_free0 (_tmp1084_);
							_tmp1084_ = _tmp1088_;
						}
						_tmp1089_ = g_strdup (_tmp1084_);
						length_ctype = _tmp1089_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1090_ = FALSE;
								_tmp1090_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1092_;
									gint _tmp1093_;
									gint _tmp1094_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1095_;
									ValaCType* _tmp1096_;
									ValaCType* _tmp1097_;
									ValaLocalVariable* _tmp1098_;
									ValaLocalVariable* _tmp1099_;
									ValaLocalVariable* _tmp1100_;
									ValaExpression* _tmp1101_;
									ValaLocalVariable* _tmp1102_;
									const gchar* _tmp1103_;
									const gchar* _tmp1104_;
									ValaCCodeExpression* _tmp1105_;
									ValaCCodeExpression* _tmp1106_;
									ValaHashMap* _tmp1107_;
									ValaParameter* _tmp1108_;
									ValaExpression* _tmp1109_;
									ValaList* _tmp1110_;
									ValaList* _tmp1111_;
									gpointer _tmp1112_;
									ValaCCodeExpression* _tmp1113_;
									ValaCCodeUnaryExpression* _tmp1114_;
									ValaCCodeUnaryExpression* _tmp1115_;
									if (!_tmp1090_) {
										gint _tmp1091_;
										_tmp1091_ = dim;
										dim = _tmp1091_ + 1;
									}
									_tmp1090_ = FALSE;
									_tmp1092_ = array_type;
									_tmp1093_ = vala_array_type_get_rank (_tmp1092_);
									_tmp1094_ = _tmp1093_;
									if (!(dim <= _tmp1094_)) {
										break;
									}
									_tmp1095_ = length_ctype;
									_tmp1096_ = vala_ctype_new (_tmp1095_, "0");
									_tmp1097_ = _tmp1096_;
									_tmp1098_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1097_, TRUE, NULL, TRUE);
									_tmp1099_ = _tmp1098_;
									_vala_code_node_unref0 (_tmp1097_);
									temp_array_length = _tmp1099_;
									_tmp1100_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1100_, FALSE);
									_tmp1101_ = arg;
									_tmp1102_ = temp_array_length;
									_tmp1103_ = vala_symbol_get_name ((ValaSymbol*) _tmp1102_);
									_tmp1104_ = _tmp1103_;
									_tmp1105_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1104_);
									_tmp1106_ = _tmp1105_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1101_, _tmp1106_);
									_vala_ccode_node_unref0 (_tmp1106_);
									_tmp1107_ = carg_map;
									_tmp1108_ = param;
									_tmp1109_ = arg;
									_tmp1110_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1109_);
									_tmp1111_ = _tmp1110_;
									_tmp1112_ = vala_list_get (_tmp1111_, dim - 1);
									_tmp1113_ = (ValaCCodeExpression*) _tmp1112_;
									_tmp1114_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1113_);
									_tmp1115_ = _tmp1114_;
									vala_map_set ((ValaMap*) _tmp1107_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1108_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1115_);
									_vala_ccode_node_unref0 (_tmp1115_);
									_vala_ccode_node_unref0 (_tmp1113_);
									_vala_iterable_unref0 (_tmp1111_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1084_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1116_;
						ValaDataType* _tmp1117_;
						ValaDataType* _tmp1118_;
						_tmp1116_ = param;
						_tmp1117_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1116_);
						_tmp1118_ = _tmp1117_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1118_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1119_;
							ValaDataType* _tmp1120_;
							ValaDataType* _tmp1121_;
							ValaDelegateType* _tmp1122_;
							ValaDelegateType* _tmp1123_;
							ValaDelegate* _tmp1124_;
							ValaDelegate* _tmp1125_;
							gboolean _tmp1126_;
							gboolean _tmp1127_;
							_tmp1119_ = param;
							_tmp1120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1119_);
							_tmp1121_ = _tmp1120_;
							_tmp1122_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1121_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1122_;
							_tmp1123_ = deleg_type;
							_tmp1124_ = vala_delegate_type_get_delegate_symbol (_tmp1123_);
							_tmp1125_ = _tmp1124_;
							_tmp1126_ = vala_delegate_get_has_target (_tmp1125_);
							_tmp1127_ = _tmp1126_;
							if (_tmp1127_) {
								ValaVoidType* _tmp1128_;
								ValaVoidType* _tmp1129_;
								ValaPointerType* _tmp1130_;
								ValaPointerType* _tmp1131_;
								ValaLocalVariable* _tmp1132_;
								ValaLocalVariable* _tmp1133_;
								ValaExpression* _tmp1134_;
								ValaLocalVariable* _tmp1135_;
								const gchar* _tmp1136_;
								const gchar* _tmp1137_;
								ValaCCodeExpression* _tmp1138_;
								ValaCCodeExpression* _tmp1139_;
								ValaHashMap* _tmp1140_;
								ValaParameter* _tmp1141_;
								ValaExpression* _tmp1142_;
								ValaCCodeExpression* _tmp1143_;
								ValaCCodeExpression* _tmp1144_;
								ValaCCodeUnaryExpression* _tmp1145_;
								ValaCCodeUnaryExpression* _tmp1146_;
								ValaDelegateType* _tmp1147_;
								_tmp1128_ = vala_void_type_new (NULL);
								_tmp1129_ = _tmp1128_;
								_tmp1130_ = vala_pointer_type_new ((ValaDataType*) _tmp1129_, NULL);
								_tmp1131_ = _tmp1130_;
								_tmp1132_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1131_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1132_;
								_vala_code_node_unref0 (_tmp1131_);
								_vala_code_node_unref0 (_tmp1129_);
								_tmp1133_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1133_, FALSE);
								_tmp1134_ = arg;
								_tmp1135_ = temp_var;
								_tmp1136_ = vala_symbol_get_name ((ValaSymbol*) _tmp1135_);
								_tmp1137_ = _tmp1136_;
								_tmp1138_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1137_);
								_tmp1139_ = _tmp1138_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1134_, _tmp1139_);
								_vala_ccode_node_unref0 (_tmp1139_);
								_tmp1140_ = carg_map;
								_tmp1141_ = param;
								_tmp1142_ = arg;
								_tmp1143_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1142_);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1144_);
								_tmp1146_ = _tmp1145_;
								vala_map_set ((ValaMap*) _tmp1140_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1141_), FALSE)), (ValaCCodeExpression*) _tmp1146_);
								_vala_ccode_node_unref0 (_tmp1146_);
								_vala_ccode_node_unref0 (_tmp1144_);
								_tmp1147_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1147_)) {
									ValaDataType* _tmp1148_;
									ValaLocalVariable* _tmp1149_;
									ValaLocalVariable* _tmp1150_;
									ValaExpression* _tmp1151_;
									ValaLocalVariable* _tmp1152_;
									const gchar* _tmp1153_;
									const gchar* _tmp1154_;
									ValaCCodeExpression* _tmp1155_;
									ValaCCodeExpression* _tmp1156_;
									ValaHashMap* _tmp1157_;
									ValaParameter* _tmp1158_;
									ValaExpression* _tmp1159_;
									ValaCCodeExpression* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeUnaryExpression* _tmp1162_;
									ValaCCodeUnaryExpression* _tmp1163_;
									_tmp1148_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1149_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1148_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1149_;
									_tmp1150_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1150_, FALSE);
									_tmp1151_ = arg;
									_tmp1152_ = temp_var;
									_tmp1153_ = vala_symbol_get_name ((ValaSymbol*) _tmp1152_);
									_tmp1154_ = _tmp1153_;
									_tmp1155_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1154_);
									_tmp1156_ = _tmp1155_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1151_, _tmp1156_);
									_vala_ccode_node_unref0 (_tmp1156_);
									_tmp1157_ = carg_map;
									_tmp1158_ = param;
									_tmp1159_ = arg;
									_tmp1160_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1159_);
									_tmp1161_ = _tmp1160_;
									_tmp1162_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1161_);
									_tmp1163_ = _tmp1162_;
									vala_map_set ((ValaMap*) _tmp1157_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1158_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1163_);
									_vala_ccode_node_unref0 (_tmp1163_);
									_vala_ccode_node_unref0 (_tmp1161_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1164_ = param;
				_tmp1165_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1164_);
				_tmp1166_ = _tmp1165_;
				_tmp1167_ = _tmp1166_ != NULL;
				_g_free0 (_tmp1166_);
				if (_tmp1167_) {
					ValaCCodeExpression* _tmp1168_;
					ValaParameter* _tmp1169_;
					gchar* _tmp1170_;
					gchar* _tmp1171_;
					ValaCCodeCastExpression* _tmp1172_;
					_tmp1168_ = cexpr;
					_tmp1169_ = param;
					_tmp1170_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1169_);
					_tmp1171_ = _tmp1170_;
					_tmp1172_ = vala_ccode_cast_expression_new (_tmp1168_, _tmp1171_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1172_;
					_g_free0 (_tmp1171_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1173_;
				ValaUnaryExpression* _tmp1174_;
				gboolean _tmp1175_ = FALSE;
				gboolean _tmp1176_ = FALSE;
				_tmp1173_ = arg;
				_tmp1174_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1173_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1173_) : NULL);
				unary = _tmp1174_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1177_;
					_tmp1177_ = unary;
					_tmp1176_ = _tmp1177_ != NULL;
				} else {
					_tmp1176_ = FALSE;
				}
				if (_tmp1176_) {
					ValaUnaryExpression* _tmp1178_;
					ValaUnaryOperator _tmp1179_;
					ValaUnaryOperator _tmp1180_;
					_tmp1178_ = unary;
					_tmp1179_ = vala_unary_expression_get_operator (_tmp1178_);
					_tmp1180_ = _tmp1179_;
					_tmp1175_ = _tmp1180_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1175_ = FALSE;
				}
				if (_tmp1175_) {
					ValaHashMap* _tmp1181_;
					ValaHashMap* _tmp1182_;
					ValaExpression* _tmp1183_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1184_;
					ValaDataType* _tmp1185_;
					ValaDataType* _tmp1186_;
					ValaExpression* _tmp1187_;
					ValaDataType* _tmp1188_;
					ValaDataType* _tmp1189_;
					gboolean _tmp1190_;
					gboolean _tmp1191_;
					ValaLocalVariable* _tmp1192_;
					ValaLocalVariable* _tmp1193_;
					ValaExpression* _tmp1194_;
					ValaLocalVariable* _tmp1195_;
					const gchar* _tmp1196_;
					const gchar* _tmp1197_;
					ValaCCodeExpression* _tmp1198_;
					ValaCCodeExpression* _tmp1199_;
					ValaExpression* _tmp1200_;
					ValaTargetValue* _tmp1201_;
					ValaTargetValue* _tmp1202_;
					ValaExpression* _tmp1203_;
					ValaDataType* _tmp1204_;
					ValaDataType* _tmp1205_;
					ValaExpression* _tmp1206_;
					ValaCCodeExpression* _tmp1207_;
					ValaCCodeExpression* _tmp1208_;
					ValaCCodeUnaryExpression* _tmp1209_;
					_tmp1181_ = out_arg_map;
					_tmp1182_ = _vala_map_ref0 (_tmp1181_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1182_;
					_tmp1183_ = arg;
					vala_expression_set_target_value (_tmp1183_, NULL);
					_tmp1184_ = arg;
					_tmp1185_ = vala_expression_get_value_type (_tmp1184_);
					_tmp1186_ = _tmp1185_;
					_tmp1187_ = arg;
					_tmp1188_ = vala_expression_get_value_type (_tmp1187_);
					_tmp1189_ = _tmp1188_;
					_tmp1190_ = vala_data_type_get_value_owned (_tmp1189_);
					_tmp1191_ = _tmp1190_;
					_tmp1192_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1186_, _tmp1191_, NULL, TRUE);
					temp_var = _tmp1192_;
					_tmp1193_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1193_, FALSE);
					_tmp1194_ = arg;
					_tmp1195_ = temp_var;
					_tmp1196_ = vala_symbol_get_name ((ValaSymbol*) _tmp1195_);
					_tmp1197_ = _tmp1196_;
					_tmp1198_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1197_);
					_tmp1199_ = _tmp1198_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1194_, _tmp1199_);
					_vala_ccode_node_unref0 (_tmp1199_);
					_tmp1200_ = arg;
					_tmp1201_ = vala_expression_get_target_value (_tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = arg;
					_tmp1204_ = vala_expression_get_value_type (_tmp1203_);
					_tmp1205_ = _tmp1204_;
					vala_target_value_set_value_type (_tmp1202_, _tmp1205_);
					_tmp1206_ = arg;
					_tmp1207_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1206_);
					_tmp1208_ = _tmp1207_;
					_tmp1209_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1208_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1209_;
					_vala_ccode_node_unref0 (_tmp1208_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					ValaCCodeExpression* _tmp1212_;
					_tmp1210_ = arg;
					_tmp1211_ = cexpr;
					_tmp1212_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1210_, _tmp1211_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1212_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1214_ = param;
			if (_tmp1214_ != NULL) {
				ValaParameter* _tmp1215_;
				_tmp1215_ = param;
				_tmp1213_ = vala_get_ccode_pos (_tmp1215_);
			} else {
				_tmp1213_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1213_, ellipsis);
			_tmp1216_ = carg_map;
			_tmp1217_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1216_, (gpointer) ((gintptr) arg_pos), _tmp1217_);
			_tmp1219_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1219_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1218_ = ellipsis;
			} else {
				_tmp1218_ = FALSE;
			}
			if (_tmp1218_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1220_;
				ValaNamedArgument* _tmp1221_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1222_;
				const gchar* _tmp1223_;
				const gchar* _tmp1224_;
				gchar** _tmp1225_;
				gchar** _tmp1226_;
				gchar** _tmp1227_;
				gint _tmp1227__length1;
				gchar* _tmp1228_;
				gchar* _tmp1229_;
				ValaHashMap* _tmp1230_;
				const gchar* _tmp1231_;
				gchar* _tmp1232_;
				gchar* _tmp1233_;
				ValaCCodeConstant* _tmp1234_;
				ValaCCodeConstant* _tmp1235_;
				_tmp1220_ = arg;
				_tmp1221_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1220_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1221_;
				_tmp1222_ = named_arg;
				_tmp1223_ = vala_named_argument_get_name (_tmp1222_);
				_tmp1224_ = _tmp1223_;
				_tmp1226_ = _tmp1225_ = g_strsplit (_tmp1224_, "_", 0);
				_tmp1227_ = _tmp1226_;
				_tmp1227__length1 = _vala_array_length (_tmp1225_);
				_tmp1228_ = _vala_g_strjoinv ("-", _tmp1227_, (gint) _vala_array_length (_tmp1225_));
				_tmp1229_ = _tmp1228_;
				_tmp1227_ = (_vala_array_free (_tmp1227_, _tmp1227__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1229_;
				_tmp1230_ = carg_map;
				_tmp1231_ = name;
				_tmp1232_ = g_strdup_printf ("\"%s\"", _tmp1231_);
				_tmp1233_ = _tmp1232_;
				_tmp1234_ = vala_ccode_constant_new (_tmp1233_);
				_tmp1235_ = _tmp1234_;
				vala_map_set ((ValaMap*) _tmp1230_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1235_);
				_vala_ccode_node_unref0 (_tmp1235_);
				_g_free0 (_tmp1233_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1236_ = i;
			i = _tmp1236_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1237_ = params_it;
	if (vala_iterator_next (_tmp1237_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1238_;
		gpointer _tmp1239_;
		gboolean _tmp1240_ = FALSE;
		ValaParameter* _tmp1241_;
		gboolean _tmp1242_;
		gboolean _tmp1243_;
		_tmp1238_ = params_it;
		_tmp1239_ = vala_iterator_get (_tmp1238_);
		param = (ValaParameter*) _tmp1239_;
		_tmp1241_ = param;
		_tmp1242_ = vala_parameter_get_params_array (_tmp1241_);
		_tmp1243_ = _tmp1242_;
		if (_tmp1243_) {
			_tmp1240_ = TRUE;
		} else {
			ValaParameter* _tmp1244_;
			gboolean _tmp1245_;
			gboolean _tmp1246_;
			_tmp1244_ = param;
			_tmp1245_ = vala_parameter_get_ellipsis (_tmp1244_);
			_tmp1246_ = _tmp1245_;
			_tmp1240_ = _tmp1246_;
		}
		_vala_assert (_tmp1240_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1249_ = m;
	if (_tmp1249_ != NULL) {
		ValaMethod* _tmp1250_;
		ValaDataType* _tmp1251_;
		ValaDataType* _tmp1252_;
		_tmp1250_ = m;
		_tmp1251_ = vala_callable_get_return_type ((ValaCallable*) _tmp1250_);
		_tmp1252_ = _tmp1251_;
		_tmp1248_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1252_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1248_ = FALSE;
	}
	if (_tmp1248_) {
		ValaCCodeFunctionCall* _tmp1253_;
		ValaCCodeFunctionCall* _tmp1254_;
		_tmp1253_ = async_call;
		_tmp1254_ = ccall;
		_tmp1247_ = _tmp1253_ != _tmp1254_;
	} else {
		_tmp1247_ = FALSE;
	}
	if (_tmp1247_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1255_;
		ValaDataType* _tmp1256_;
		ValaDataType* _tmp1257_;
		ValaArrayType* _tmp1258_;
		_tmp1255_ = m;
		_tmp1256_ = vala_callable_get_return_type ((ValaCallable*) _tmp1255_);
		_tmp1257_ = _tmp1256_;
		_tmp1258_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1257_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1258_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1259_ = FALSE;
				_tmp1259_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1261_;
					gint _tmp1262_;
					gint _tmp1263_;
					ValaMethod* _tmp1264_;
					if (!_tmp1259_) {
						gint _tmp1260_;
						_tmp1260_ = dim;
						dim = _tmp1260_ + 1;
					}
					_tmp1259_ = FALSE;
					_tmp1261_ = array_type;
					_tmp1262_ = vala_array_type_get_rank (_tmp1261_);
					_tmp1263_ = _tmp1262_;
					if (!(dim <= _tmp1263_)) {
						break;
					}
					_tmp1264_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1264_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1265_;
						ValaDataType* _tmp1266_;
						ValaDataType* _tmp1267_;
						ValaLocalVariable* _tmp1268_;
						ValaLocalVariable* _tmp1269_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1270_;
						const gchar* _tmp1271_;
						const gchar* _tmp1272_;
						ValaCCodeExpression* _tmp1273_;
						ValaLocalVariable* _tmp1274_;
						ValaCCodeExpression* _tmp1275_;
						ValaCCodeExpression* _tmp1276_;
						ValaCCodeAssignment* _tmp1277_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1278_;
						ValaCCodeIdentifier* _tmp1279_;
						ValaCCodeFunctionCall* _tmp1280_;
						ValaCCodeFunctionCall* _tmp1281_;
						ValaCCodeFunctionCall* _tmp1282_;
						ValaCCodeExpression* _tmp1283_;
						ValaCCodeFunctionCall* _tmp1284_;
						_tmp1265_ = itype;
						_tmp1266_ = vala_data_type_get_return_type (_tmp1265_);
						_tmp1267_ = _tmp1266_;
						_tmp1268_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1267_, TRUE, NULL, FALSE);
						_tmp1269_ = _tmp1268_;
						_vala_code_node_unref0 (_tmp1267_);
						temp_var = _tmp1269_;
						_tmp1270_ = temp_var;
						_tmp1271_ = vala_symbol_get_name ((ValaSymbol*) _tmp1270_);
						_tmp1272_ = _tmp1271_;
						_tmp1273_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1272_);
						temp_ref = _tmp1273_;
						_tmp1274_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1274_, FALSE);
						_tmp1275_ = temp_ref;
						_tmp1276_ = ccall_expr;
						_tmp1277_ = vala_ccode_assignment_new (_tmp1275_, _tmp1276_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1277_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1278_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1279_ = _tmp1278_;
						_tmp1280_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1279_);
						_tmp1281_ = _tmp1280_;
						_vala_ccode_node_unref0 (_tmp1279_);
						len_call = _tmp1281_;
						_tmp1282_ = len_call;
						_tmp1283_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1282_, _tmp1283_);
						_tmp1284_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1284_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1285_;
						_tmp1285_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1285_)) {
							gchar* _tmp1286_ = NULL;
							ValaMethod* _tmp1287_;
							gchar* _tmp1288_;
							gchar* length_ctype = NULL;
							gchar* _tmp1291_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1292_;
							ValaCType* _tmp1293_;
							ValaCType* _tmp1294_;
							ValaLocalVariable* _tmp1295_;
							ValaLocalVariable* _tmp1296_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1297_;
							const gchar* _tmp1298_;
							const gchar* _tmp1299_;
							ValaCCodeExpression* _tmp1300_;
							ValaLocalVariable* _tmp1301_;
							ValaHashMap* _tmp1302_;
							ValaMethod* _tmp1303_;
							ValaCCodeExpression* _tmp1304_;
							ValaCCodeUnaryExpression* _tmp1305_;
							ValaCCodeUnaryExpression* _tmp1306_;
							ValaCCodeExpression* _tmp1307_;
							_tmp1287_ = m;
							_tmp1288_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1287_);
							_tmp1286_ = _tmp1288_;
							if (_tmp1286_ == NULL) {
								ValaArrayType* _tmp1289_;
								gchar* _tmp1290_;
								_tmp1289_ = array_type;
								_tmp1290_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1289_);
								_g_free0 (_tmp1286_);
								_tmp1286_ = _tmp1290_;
							}
							_tmp1291_ = g_strdup (_tmp1286_);
							length_ctype = _tmp1291_;
							_tmp1292_ = length_ctype;
							_tmp1293_ = vala_ctype_new (_tmp1292_, "0");
							_tmp1294_ = _tmp1293_;
							_tmp1295_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1294_, TRUE, NULL, TRUE);
							_tmp1296_ = _tmp1295_;
							_vala_code_node_unref0 (_tmp1294_);
							temp_var = _tmp1296_;
							_tmp1297_ = temp_var;
							_tmp1298_ = vala_symbol_get_name ((ValaSymbol*) _tmp1297_);
							_tmp1299_ = _tmp1298_;
							_tmp1300_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1299_);
							temp_ref = _tmp1300_;
							_tmp1301_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1301_, FALSE);
							_tmp1302_ = out_arg_map;
							_tmp1303_ = m;
							_tmp1304_ = temp_ref;
							_tmp1305_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1304_);
							_tmp1306_ = _tmp1305_;
							vala_map_set ((ValaMap*) _tmp1302_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1303_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1306_);
							_vala_ccode_node_unref0 (_tmp1306_);
							_tmp1307_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1307_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1286_);
						} else {
							ValaMethod* _tmp1308_;
							gchar* _tmp1309_;
							gchar* _tmp1310_;
							gboolean _tmp1311_;
							_tmp1308_ = m;
							_tmp1309_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1308_);
							_tmp1310_ = _tmp1309_;
							_tmp1311_ = _tmp1310_ != NULL;
							_g_free0 (_tmp1310_);
							if (_tmp1311_) {
								ValaMethod* _tmp1312_;
								gchar* _tmp1313_;
								gchar* _tmp1314_;
								ValaCCodeConstant* _tmp1315_;
								ValaCCodeConstant* _tmp1316_;
								_tmp1312_ = m;
								_tmp1313_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1312_);
								_tmp1314_ = _tmp1313_;
								_tmp1315_ = vala_ccode_constant_new (_tmp1314_);
								_tmp1316_ = _tmp1315_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1316_);
								_vala_ccode_node_unref0 (_tmp1316_);
								_g_free0 (_tmp1314_);
							} else {
								ValaCCodeConstant* _tmp1317_;
								ValaCCodeConstant* _tmp1318_;
								_tmp1317_ = vala_ccode_constant_new ("-1");
								_tmp1318_ = _tmp1317_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1318_);
								_vala_ccode_node_unref0 (_tmp1318_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1319_ = FALSE;
		gboolean _tmp1320_ = FALSE;
		ValaMethod* _tmp1321_;
		_tmp1321_ = m;
		if (_tmp1321_ != NULL) {
			ValaMethod* _tmp1322_;
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			_tmp1322_ = m;
			_tmp1323_ = vala_callable_get_return_type ((ValaCallable*) _tmp1322_);
			_tmp1324_ = _tmp1323_;
			_tmp1320_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1324_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaCCodeFunctionCall* _tmp1325_;
			ValaCCodeFunctionCall* _tmp1326_;
			_tmp1325_ = async_call;
			_tmp1326_ = ccall;
			_tmp1319_ = _tmp1325_ != _tmp1326_;
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaDelegateType* _tmp1330_;
			ValaDelegateType* _tmp1331_;
			ValaDelegate* _tmp1332_;
			ValaDelegate* _tmp1333_;
			gboolean _tmp1334_;
			gboolean _tmp1335_;
			_tmp1327_ = m;
			_tmp1328_ = vala_callable_get_return_type ((ValaCallable*) _tmp1327_);
			_tmp1329_ = _tmp1328_;
			_tmp1330_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1329_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1330_;
			_tmp1331_ = deleg_type;
			_tmp1332_ = vala_delegate_type_get_delegate_symbol (_tmp1331_);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_delegate_get_has_target (_tmp1333_);
			_tmp1335_ = _tmp1334_;
			if (_tmp1335_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1336_;
				ValaVoidType* _tmp1337_;
				ValaPointerType* _tmp1338_;
				ValaPointerType* _tmp1339_;
				ValaLocalVariable* _tmp1340_;
				ValaLocalVariable* _tmp1341_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1342_;
				const gchar* _tmp1343_;
				const gchar* _tmp1344_;
				ValaCCodeExpression* _tmp1345_;
				ValaLocalVariable* _tmp1346_;
				ValaHashMap* _tmp1347_;
				ValaMethod* _tmp1348_;
				ValaCCodeExpression* _tmp1349_;
				ValaCCodeUnaryExpression* _tmp1350_;
				ValaCCodeUnaryExpression* _tmp1351_;
				ValaCCodeExpression* _tmp1352_;
				ValaDelegateType* _tmp1353_;
				_tmp1336_ = vala_void_type_new (NULL);
				_tmp1337_ = _tmp1336_;
				_tmp1338_ = vala_pointer_type_new ((ValaDataType*) _tmp1337_, NULL);
				_tmp1339_ = _tmp1338_;
				_tmp1340_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1339_, TRUE, NULL, TRUE);
				_tmp1341_ = _tmp1340_;
				_vala_code_node_unref0 (_tmp1339_);
				_vala_code_node_unref0 (_tmp1337_);
				temp_var = _tmp1341_;
				_tmp1342_ = temp_var;
				_tmp1343_ = vala_symbol_get_name ((ValaSymbol*) _tmp1342_);
				_tmp1344_ = _tmp1343_;
				_tmp1345_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1344_);
				temp_ref = _tmp1345_;
				_tmp1346_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1346_, FALSE);
				_tmp1347_ = out_arg_map;
				_tmp1348_ = m;
				_tmp1349_ = temp_ref;
				_tmp1350_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1349_);
				_tmp1351_ = _tmp1350_;
				vala_map_set ((ValaMap*) _tmp1347_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1348_), FALSE)), (ValaCCodeExpression*) _tmp1351_);
				_vala_ccode_node_unref0 (_tmp1351_);
				_tmp1352_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1352_);
				_tmp1353_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1353_)) {
					ValaDataType* _tmp1354_;
					ValaLocalVariable* _tmp1355_;
					ValaLocalVariable* _tmp1356_;
					const gchar* _tmp1357_;
					const gchar* _tmp1358_;
					ValaCCodeExpression* _tmp1359_;
					ValaLocalVariable* _tmp1360_;
					ValaHashMap* _tmp1361_;
					ValaMethod* _tmp1362_;
					ValaCCodeExpression* _tmp1363_;
					ValaCCodeUnaryExpression* _tmp1364_;
					ValaCCodeUnaryExpression* _tmp1365_;
					ValaCCodeExpression* _tmp1366_;
					_tmp1354_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1355_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1354_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1355_;
					_tmp1356_ = temp_var;
					_tmp1357_ = vala_symbol_get_name ((ValaSymbol*) _tmp1356_);
					_tmp1358_ = _tmp1357_;
					_tmp1359_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1358_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1359_;
					_tmp1360_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1360_, FALSE);
					_tmp1361_ = out_arg_map;
					_tmp1362_ = m;
					_tmp1363_ = temp_ref;
					_tmp1364_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1363_);
					_tmp1365_ = _tmp1364_;
					vala_map_set ((ValaMap*) _tmp1361_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1362_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1365_);
					_vala_ccode_node_unref0 (_tmp1365_);
					_tmp1366_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1366_);
				} else {
					ValaCCodeConstant* _tmp1367_;
					ValaCCodeConstant* _tmp1368_;
					_tmp1367_ = vala_ccode_constant_new ("NULL");
					_tmp1368_ = _tmp1367_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1368_);
					_vala_ccode_node_unref0 (_tmp1368_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1369_;
				ValaCCodeConstant* _tmp1370_;
				_tmp1369_ = vala_ccode_constant_new ("NULL");
				_tmp1370_ = _tmp1369_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1370_);
				_vala_ccode_node_unref0 (_tmp1370_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1372_ = deleg;
	if (_tmp1372_ != NULL) {
		ValaDelegate* _tmp1373_;
		ValaDataType* _tmp1374_;
		ValaDataType* _tmp1375_;
		_tmp1373_ = deleg;
		_tmp1374_ = vala_callable_get_return_type ((ValaCallable*) _tmp1373_);
		_tmp1375_ = _tmp1374_;
		_tmp1371_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1375_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1371_ = FALSE;
	}
	if (_tmp1371_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1376_;
		ValaDataType* _tmp1377_;
		ValaDataType* _tmp1378_;
		ValaArrayType* _tmp1379_;
		_tmp1376_ = deleg;
		_tmp1377_ = vala_callable_get_return_type ((ValaCallable*) _tmp1376_);
		_tmp1378_ = _tmp1377_;
		_tmp1379_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1378_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1379_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1380_ = FALSE;
				_tmp1380_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1382_;
					gint _tmp1383_;
					gint _tmp1384_;
					ValaDelegate* _tmp1385_;
					if (!_tmp1380_) {
						gint _tmp1381_;
						_tmp1381_ = dim;
						dim = _tmp1381_ + 1;
					}
					_tmp1380_ = FALSE;
					_tmp1382_ = array_type;
					_tmp1383_ = vala_array_type_get_rank (_tmp1382_);
					_tmp1384_ = _tmp1383_;
					if (!(dim <= _tmp1384_)) {
						break;
					}
					_tmp1385_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1385_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1386_;
						ValaDataType* _tmp1387_;
						ValaDataType* _tmp1388_;
						ValaLocalVariable* _tmp1389_;
						ValaLocalVariable* _tmp1390_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1391_;
						const gchar* _tmp1392_;
						const gchar* _tmp1393_;
						ValaCCodeExpression* _tmp1394_;
						ValaLocalVariable* _tmp1395_;
						ValaCCodeExpression* _tmp1396_;
						ValaCCodeExpression* _tmp1397_;
						ValaCCodeAssignment* _tmp1398_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1399_;
						ValaCCodeIdentifier* _tmp1400_;
						ValaCCodeFunctionCall* _tmp1401_;
						ValaCCodeFunctionCall* _tmp1402_;
						ValaCCodeFunctionCall* _tmp1403_;
						ValaCCodeExpression* _tmp1404_;
						ValaCCodeFunctionCall* _tmp1405_;
						_tmp1386_ = itype;
						_tmp1387_ = vala_data_type_get_return_type (_tmp1386_);
						_tmp1388_ = _tmp1387_;
						_tmp1389_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1388_, TRUE, NULL, FALSE);
						_tmp1390_ = _tmp1389_;
						_vala_code_node_unref0 (_tmp1388_);
						temp_var = _tmp1390_;
						_tmp1391_ = temp_var;
						_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
						_tmp1393_ = _tmp1392_;
						_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
						temp_ref = _tmp1394_;
						_tmp1395_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_, FALSE);
						_tmp1396_ = temp_ref;
						_tmp1397_ = ccall_expr;
						_tmp1398_ = vala_ccode_assignment_new (_tmp1396_, _tmp1397_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1398_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1399_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1400_ = _tmp1399_;
						_tmp1401_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1400_);
						_tmp1402_ = _tmp1401_;
						_vala_ccode_node_unref0 (_tmp1400_);
						len_call = _tmp1402_;
						_tmp1403_ = len_call;
						_tmp1404_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1403_, _tmp1404_);
						_tmp1405_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1405_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1406_;
						_tmp1406_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1406_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1407_;
							ValaDataType* _tmp1408_;
							ValaDataType* _tmp1409_;
							ValaLocalVariable* _tmp1410_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1411_;
							const gchar* _tmp1412_;
							const gchar* _tmp1413_;
							ValaCCodeExpression* _tmp1414_;
							ValaLocalVariable* _tmp1415_;
							ValaHashMap* _tmp1416_;
							ValaDelegate* _tmp1417_;
							ValaCCodeExpression* _tmp1418_;
							ValaCCodeUnaryExpression* _tmp1419_;
							ValaCCodeUnaryExpression* _tmp1420_;
							ValaCCodeExpression* _tmp1421_;
							_tmp1407_ = array_type;
							_tmp1408_ = vala_array_type_get_length_type (_tmp1407_);
							_tmp1409_ = _tmp1408_;
							_tmp1410_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1409_, TRUE, NULL, TRUE);
							temp_var = _tmp1410_;
							_tmp1411_ = temp_var;
							_tmp1412_ = vala_symbol_get_name ((ValaSymbol*) _tmp1411_);
							_tmp1413_ = _tmp1412_;
							_tmp1414_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1413_);
							temp_ref = _tmp1414_;
							_tmp1415_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1415_, FALSE);
							_tmp1416_ = out_arg_map;
							_tmp1417_ = deleg;
							_tmp1418_ = temp_ref;
							_tmp1419_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1418_);
							_tmp1420_ = _tmp1419_;
							vala_map_set ((ValaMap*) _tmp1416_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1417_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1420_);
							_vala_ccode_node_unref0 (_tmp1420_);
							_tmp1421_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1421_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1422_;
							ValaCCodeConstant* _tmp1423_;
							_tmp1422_ = vala_ccode_constant_new ("-1");
							_tmp1423_ = _tmp1422_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1423_);
							_vala_ccode_node_unref0 (_tmp1423_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1424_ = FALSE;
		ValaDelegate* _tmp1425_;
		_tmp1425_ = deleg;
		if (_tmp1425_ != NULL) {
			ValaDelegate* _tmp1426_;
			ValaDataType* _tmp1427_;
			ValaDataType* _tmp1428_;
			_tmp1426_ = deleg;
			_tmp1427_ = vala_callable_get_return_type ((ValaCallable*) _tmp1426_);
			_tmp1428_ = _tmp1427_;
			_tmp1424_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1428_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1424_ = FALSE;
		}
		if (_tmp1424_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1429_;
			ValaDataType* _tmp1430_;
			ValaDataType* _tmp1431_;
			ValaDelegateType* _tmp1432_;
			ValaDelegateType* _tmp1433_;
			ValaDelegate* _tmp1434_;
			ValaDelegate* _tmp1435_;
			gboolean _tmp1436_;
			gboolean _tmp1437_;
			_tmp1429_ = deleg;
			_tmp1430_ = vala_callable_get_return_type ((ValaCallable*) _tmp1429_);
			_tmp1431_ = _tmp1430_;
			_tmp1432_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1431_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1432_;
			_tmp1433_ = deleg_type;
			_tmp1434_ = vala_delegate_type_get_delegate_symbol (_tmp1433_);
			_tmp1435_ = _tmp1434_;
			_tmp1436_ = vala_delegate_get_has_target (_tmp1435_);
			_tmp1437_ = _tmp1436_;
			if (_tmp1437_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1438_;
				ValaVoidType* _tmp1439_;
				ValaPointerType* _tmp1440_;
				ValaPointerType* _tmp1441_;
				ValaLocalVariable* _tmp1442_;
				ValaLocalVariable* _tmp1443_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1444_;
				const gchar* _tmp1445_;
				const gchar* _tmp1446_;
				ValaCCodeExpression* _tmp1447_;
				ValaLocalVariable* _tmp1448_;
				ValaHashMap* _tmp1449_;
				ValaDelegate* _tmp1450_;
				ValaCCodeExpression* _tmp1451_;
				ValaCCodeUnaryExpression* _tmp1452_;
				ValaCCodeUnaryExpression* _tmp1453_;
				ValaCCodeExpression* _tmp1454_;
				ValaDelegateType* _tmp1455_;
				_tmp1438_ = vala_void_type_new (NULL);
				_tmp1439_ = _tmp1438_;
				_tmp1440_ = vala_pointer_type_new ((ValaDataType*) _tmp1439_, NULL);
				_tmp1441_ = _tmp1440_;
				_tmp1442_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1441_, TRUE, NULL, TRUE);
				_tmp1443_ = _tmp1442_;
				_vala_code_node_unref0 (_tmp1441_);
				_vala_code_node_unref0 (_tmp1439_);
				temp_var = _tmp1443_;
				_tmp1444_ = temp_var;
				_tmp1445_ = vala_symbol_get_name ((ValaSymbol*) _tmp1444_);
				_tmp1446_ = _tmp1445_;
				_tmp1447_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1446_);
				temp_ref = _tmp1447_;
				_tmp1448_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1448_, FALSE);
				_tmp1449_ = out_arg_map;
				_tmp1450_ = deleg;
				_tmp1451_ = temp_ref;
				_tmp1452_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1451_);
				_tmp1453_ = _tmp1452_;
				vala_map_set ((ValaMap*) _tmp1449_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1450_), FALSE)), (ValaCCodeExpression*) _tmp1453_);
				_vala_ccode_node_unref0 (_tmp1453_);
				_tmp1454_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1454_);
				_tmp1455_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1455_)) {
					ValaDataType* _tmp1456_;
					ValaLocalVariable* _tmp1457_;
					ValaLocalVariable* _tmp1458_;
					const gchar* _tmp1459_;
					const gchar* _tmp1460_;
					ValaCCodeExpression* _tmp1461_;
					ValaLocalVariable* _tmp1462_;
					ValaHashMap* _tmp1463_;
					ValaDelegate* _tmp1464_;
					ValaCCodeExpression* _tmp1465_;
					ValaCCodeUnaryExpression* _tmp1466_;
					ValaCCodeUnaryExpression* _tmp1467_;
					ValaCCodeExpression* _tmp1468_;
					_tmp1456_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1457_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1456_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1457_;
					_tmp1458_ = temp_var;
					_tmp1459_ = vala_symbol_get_name ((ValaSymbol*) _tmp1458_);
					_tmp1460_ = _tmp1459_;
					_tmp1461_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1460_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1461_;
					_tmp1462_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1462_, FALSE);
					_tmp1463_ = out_arg_map;
					_tmp1464_ = deleg;
					_tmp1465_ = temp_ref;
					_tmp1466_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1465_);
					_tmp1467_ = _tmp1466_;
					vala_map_set ((ValaMap*) _tmp1463_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1464_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1467_);
					_vala_ccode_node_unref0 (_tmp1467_);
					_tmp1468_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1468_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1470_ = m;
	if (_tmp1470_ != NULL) {
		ValaMethod* _tmp1471_;
		gboolean _tmp1472_;
		gboolean _tmp1473_;
		_tmp1471_ = m;
		_tmp1472_ = vala_method_get_coroutine (_tmp1471_);
		_tmp1473_ = _tmp1472_;
		_tmp1469_ = _tmp1473_;
	} else {
		_tmp1469_ = FALSE;
	}
	if (_tmp1469_) {
		gboolean _tmp1474_;
		gboolean _tmp1475_;
		_tmp1474_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1475_ = _tmp1474_;
		if (_tmp1475_) {
			ValaHashMap* _tmp1476_;
			ValaMethod* _tmp1477_;
			ValaMethod* _tmp1478_;
			gchar* _tmp1479_;
			gchar* _tmp1480_;
			ValaCCodeIdentifier* _tmp1481_;
			ValaCCodeIdentifier* _tmp1482_;
			ValaHashMap* _tmp1483_;
			ValaCCodeIdentifier* _tmp1484_;
			ValaCCodeIdentifier* _tmp1485_;
			_tmp1476_ = in_arg_map;
			_tmp1477_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1478_ = _tmp1477_;
			_tmp1479_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1478_);
			_tmp1480_ = _tmp1479_;
			_tmp1481_ = vala_ccode_identifier_new (_tmp1480_);
			_tmp1482_ = _tmp1481_;
			vala_map_set ((ValaMap*) _tmp1476_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1482_);
			_vala_ccode_node_unref0 (_tmp1482_);
			_g_free0 (_tmp1480_);
			_tmp1483_ = in_arg_map;
			_tmp1484_ = vala_ccode_identifier_new ("_data_");
			_tmp1485_ = _tmp1484_;
			vala_map_set ((ValaMap*) _tmp1483_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1485_);
			_vala_ccode_node_unref0 (_tmp1485_);
		}
	}
	_tmp1486_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1487_ = _tmp1486_;
	if (_tmp1487_) {
		ValaCallable* _tmp1488_ = NULL;
		ValaMethod* _tmp1489_;
		ValaHashMap* _tmp1491_;
		ValaCCodeExpression* _tmp1492_;
		ValaCCodeExpression* _tmp1493_;
		ValaCCodeUnaryExpression* _tmp1494_;
		ValaCCodeUnaryExpression* _tmp1495_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1489_ = m;
		_tmp1488_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1489_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1488_ == NULL) {
			ValaDelegate* _tmp1490_;
			_tmp1490_ = deleg;
			_tmp1488_ = (ValaCallable*) _tmp1490_;
		}
		_tmp1491_ = out_arg_map;
		_tmp1492_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1493_ = _tmp1492_;
		_tmp1494_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1493_);
		_tmp1495_ = _tmp1494_;
		vala_map_set ((ValaMap*) _tmp1491_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1488_), FALSE)), (ValaCCodeExpression*) _tmp1495_);
		_vala_ccode_node_unref0 (_tmp1495_);
		_vala_ccode_node_unref0 (_tmp1493_);
	} else {
		gboolean _tmp1496_ = FALSE;
		gboolean _tmp1497_ = FALSE;
		ValaMethod* _tmp1498_;
		_tmp1498_ = m;
		if (_tmp1498_ != NULL) {
			ValaMethod* _tmp1499_;
			_tmp1499_ = m;
			_tmp1497_ = vala_method_has_error_type_parameter (_tmp1499_);
		} else {
			_tmp1497_ = FALSE;
		}
		if (_tmp1497_) {
			ValaCCodeFunctionCall* _tmp1500_;
			ValaCCodeFunctionCall* _tmp1501_;
			_tmp1500_ = async_call;
			_tmp1501_ = ccall;
			_tmp1496_ = _tmp1500_ != _tmp1501_;
		} else {
			_tmp1496_ = FALSE;
		}
		if (_tmp1496_) {
			ValaHashMap* _tmp1502_;
			ValaMethod* _tmp1503_;
			ValaCCodeConstant* _tmp1504_;
			ValaCCodeConstant* _tmp1505_;
			_tmp1502_ = out_arg_map;
			_tmp1503_ = m;
			_tmp1504_ = vala_ccode_constant_new ("NULL");
			_tmp1505_ = _tmp1504_;
			vala_map_set ((ValaMap*) _tmp1502_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1503_), FALSE)), (ValaCCodeExpression*) _tmp1505_);
			_vala_ccode_node_unref0 (_tmp1505_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1506_;
		_tmp1506_ = m;
		if (_tmp1506_ == NULL) {
			ValaHashMap* _tmp1507_;
			ValaCCodeConstant* _tmp1508_;
			ValaCCodeConstant* _tmp1509_;
			_tmp1507_ = in_arg_map;
			_tmp1508_ = vala_ccode_constant_new ("NULL");
			_tmp1509_ = _tmp1508_;
			vala_map_set ((ValaMap*) _tmp1507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1509_);
			_vala_ccode_node_unref0 (_tmp1509_);
		} else {
			gboolean _tmp1510_ = FALSE;
			gboolean _tmp1511_ = FALSE;
			gboolean _tmp1512_ = FALSE;
			ValaMethod* _tmp1513_;
			gboolean _tmp1514_;
			gboolean _tmp1515_;
			_tmp1513_ = m;
			_tmp1514_ = vala_method_get_printf_format (_tmp1513_);
			_tmp1515_ = _tmp1514_;
			if (!_tmp1515_) {
				ValaMethod* _tmp1516_;
				gboolean _tmp1517_;
				gboolean _tmp1518_;
				_tmp1516_ = m;
				_tmp1517_ = vala_method_get_scanf_format (_tmp1516_);
				_tmp1518_ = _tmp1517_;
				_tmp1512_ = !_tmp1518_;
			} else {
				_tmp1512_ = FALSE;
			}
			if (_tmp1512_) {
				ValaMethod* _tmp1519_;
				gchar* _tmp1520_;
				gchar* _tmp1521_;
				_tmp1519_ = m;
				_tmp1520_ = vala_get_ccode_sentinel (_tmp1519_);
				_tmp1521_ = _tmp1520_;
				_tmp1511_ = g_strcmp0 (_tmp1521_, "") != 0;
				_g_free0 (_tmp1521_);
			} else {
				_tmp1511_ = FALSE;
			}
			if (_tmp1511_) {
				gboolean _tmp1522_;
				gboolean _tmp1523_;
				_tmp1522_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1523_ = _tmp1522_;
				_tmp1510_ = !_tmp1523_;
			} else {
				_tmp1510_ = FALSE;
			}
			if (_tmp1510_) {
				ValaHashMap* _tmp1524_;
				ValaMethod* _tmp1525_;
				gchar* _tmp1526_;
				gchar* _tmp1527_;
				ValaCCodeConstant* _tmp1528_;
				ValaCCodeConstant* _tmp1529_;
				_tmp1524_ = in_arg_map;
				_tmp1525_ = m;
				_tmp1526_ = vala_get_ccode_sentinel (_tmp1525_);
				_tmp1527_ = _tmp1526_;
				_tmp1528_ = vala_ccode_constant_new (_tmp1527_);
				_tmp1529_ = _tmp1528_;
				vala_map_set ((ValaMap*) _tmp1524_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1529_);
				_vala_ccode_node_unref0 (_tmp1529_);
				_g_free0 (_tmp1527_);
			}
		}
	}
	_tmp1530_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1530_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1531_;
		ValaDelegateType* _tmp1532_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1533_;
		ValaDelegate* _tmp1534_;
		ValaDelegate* _tmp1535_;
		ValaDelegate* _tmp1536_;
		ValaDelegate* _tmp1537_;
		gboolean _tmp1538_;
		gboolean _tmp1539_;
		_tmp1531_ = itype;
		_tmp1532_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1531_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1532_;
		_tmp1533_ = deleg_type;
		_tmp1534_ = vala_delegate_type_get_delegate_symbol (_tmp1533_);
		_tmp1535_ = _tmp1534_;
		_tmp1536_ = _vala_code_node_ref0 (_tmp1535_);
		d = _tmp1536_;
		_tmp1537_ = d;
		_tmp1538_ = vala_delegate_get_has_target (_tmp1537_);
		_tmp1539_ = _tmp1538_;
		if (_tmp1539_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1540_;
			ValaDelegate* _tmp1541_;
			ValaExpression* _tmp1542_;
			ValaExpression* _tmp1543_;
			ValaCCodeExpression* _tmp1544_ = NULL;
			ValaCCodeExpression* _tmp1545_;
			ValaCCodeExpression* _tmp1546_;
			ValaHashMap* _tmp1547_;
			ValaDelegate* _tmp1548_;
			ValaExpression* _tmp1549_;
			ValaExpression* _tmp1550_;
			ValaCCodeExpression* _tmp1551_ = NULL;
			ValaCCodeExpression* _tmp1552_;
			ValaCCodeExpression* _tmp1553_;
			_tmp1540_ = in_arg_map;
			_tmp1541_ = d;
			_tmp1542_ = vala_method_call_get_call (expr);
			_tmp1543_ = _tmp1542_;
			_tmp1545_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1543_, &_tmp1544_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1544_;
			_tmp1546_ = _tmp1545_;
			vala_map_set ((ValaMap*) _tmp1540_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1541_), FALSE)), _tmp1546_);
			_vala_ccode_node_unref0 (_tmp1546_);
			_tmp1547_ = out_arg_map;
			_tmp1548_ = d;
			_tmp1549_ = vala_method_call_get_call (expr);
			_tmp1550_ = _tmp1549_;
			_tmp1552_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1550_, &_tmp1551_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1551_;
			_tmp1553_ = _tmp1552_;
			vala_map_set ((ValaMap*) _tmp1547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1548_), FALSE)), _tmp1553_);
			_vala_ccode_node_unref0 (_tmp1553_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1554_ = itype;
	_tmp1555_ = vala_data_type_get_return_type (_tmp1554_);
	_tmp1556_ = _tmp1555_;
	_tmp1557_ = vala_data_type_is_real_non_null_struct_type (_tmp1556_);
	_vala_code_node_unref0 (_tmp1556_);
	return_result_via_out_param = _tmp1557_;
	_tmp1559_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1559_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1560_;
		ValaDataType* _tmp1561_;
		ValaDataType* _tmp1562_;
		_tmp1560_ = itype;
		_tmp1561_ = vala_data_type_get_return_type (_tmp1560_);
		_tmp1562_ = _tmp1561_;
		_tmp1558_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1562_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1562_);
	} else {
		_tmp1558_ = FALSE;
	}
	if (_tmp1558_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1563_;
		ValaSignal* _tmp1564_;
		ValaSignal* _tmp1565_;
		ValaSignal* _tmp1566_;
		gboolean _tmp1567_ = FALSE;
		gboolean _tmp1568_ = FALSE;
		ValaMemberAccess* _tmp1569_;
		_tmp1563_ = itype;
		_tmp1564_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1563_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1565_ = _tmp1564_;
		_tmp1566_ = _vala_code_node_ref0 (_tmp1565_);
		sig = _tmp1566_;
		_tmp1569_ = ma;
		if (_tmp1569_ != NULL) {
			ValaMemberAccess* _tmp1570_;
			ValaExpression* _tmp1571_;
			ValaExpression* _tmp1572_;
			_tmp1570_ = ma;
			_tmp1571_ = vala_member_access_get_inner (_tmp1570_);
			_tmp1572_ = _tmp1571_;
			_tmp1568_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1572_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1568_ = FALSE;
		}
		if (_tmp1568_) {
			ValaSignal* _tmp1573_;
			gboolean _tmp1574_;
			gboolean _tmp1575_;
			_tmp1573_ = sig;
			_tmp1574_ = vala_signal_get_is_virtual (_tmp1573_);
			_tmp1575_ = _tmp1574_;
			_tmp1567_ = _tmp1575_;
		} else {
			_tmp1567_ = FALSE;
		}
		if (_tmp1567_) {
		} else {
			gboolean _tmp1576_ = FALSE;
			ValaSignal* _tmp1577_;
			_tmp1577_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1577_)) {
				_tmp1576_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1578_;
				ValaSourceReference* _tmp1579_;
				ValaSourceReference* _tmp1580_;
				ValaSourceFile* _tmp1581_;
				ValaSourceFile* _tmp1582_;
				ValaSignal* _tmp1583_;
				ValaSourceReference* _tmp1584_;
				ValaSourceReference* _tmp1585_;
				ValaSourceFile* _tmp1586_;
				ValaSourceFile* _tmp1587_;
				_tmp1578_ = ma;
				_tmp1579_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = vala_source_reference_get_file (_tmp1580_);
				_tmp1582_ = _tmp1581_;
				_tmp1583_ = sig;
				_tmp1584_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1586_ = vala_source_reference_get_file (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1576_ = _tmp1582_ == _tmp1587_;
			}
			if (_tmp1576_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1588_ = async_call;
	_tmp1589_ = ccall;
	if (_tmp1588_ == _tmp1589_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1590_;
		ValaDataType* _tmp1591_;
		ValaDataType* _tmp1592_;
		ValaLocalVariable* _tmp1593_;
		ValaLocalVariable* _tmp1594_;
		ValaLocalVariable* _tmp1595_;
		const gchar* _tmp1596_;
		const gchar* _tmp1597_;
		ValaCCodeExpression* _tmp1598_;
		ValaLocalVariable* _tmp1599_;
		ValaHashMap* _tmp1600_;
		ValaCCodeExpression* _tmp1601_;
		ValaCCodeUnaryExpression* _tmp1602_;
		ValaCCodeUnaryExpression* _tmp1603_;
		_tmp1590_ = itype;
		_tmp1591_ = vala_data_type_get_return_type (_tmp1590_);
		_tmp1592_ = _tmp1591_;
		_tmp1593_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1592_, TRUE, NULL, TRUE);
		_tmp1594_ = _tmp1593_;
		_vala_code_node_unref0 (_tmp1592_);
		out_param_var = _tmp1594_;
		_tmp1595_ = out_param_var;
		_tmp1596_ = vala_symbol_get_name ((ValaSymbol*) _tmp1595_);
		_tmp1597_ = _tmp1596_;
		_tmp1598_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1597_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1598_;
		_tmp1599_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1599_, FALSE);
		_tmp1600_ = out_arg_map;
		_tmp1601_ = out_param_ref;
		_tmp1602_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1601_);
		_tmp1603_ = _tmp1602_;
		vala_map_set ((ValaMap*) _tmp1600_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1603_);
		_vala_ccode_node_unref0 (_tmp1603_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1604_ = async_call;
	_tmp1605_ = ccall;
	if (_tmp1604_ != _tmp1605_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1616_;
			ValaHashMap* _tmp1617_;
			gpointer _tmp1618_;
			ValaCCodeExpression* _tmp1619_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1606_;
				ValaSet* _tmp1607_;
				ValaSet* _tmp1608_;
				ValaIterator* _tmp1609_;
				ValaIterator* _tmp1610_;
				_tmp1606_ = out_arg_map;
				_tmp1607_ = vala_map_get_keys ((ValaMap*) _tmp1606_);
				_tmp1608_ = _tmp1607_;
				_tmp1609_ = vala_iterable_iterator ((ValaIterable*) _tmp1608_);
				_tmp1610_ = _tmp1609_;
				_vala_iterable_unref0 (_tmp1608_);
				_pos_it = _tmp1610_;
				while (TRUE) {
					ValaIterator* _tmp1611_;
					gint pos = 0;
					ValaIterator* _tmp1612_;
					gpointer _tmp1613_;
					gboolean _tmp1614_ = FALSE;
					_tmp1611_ = _pos_it;
					if (!vala_iterator_next (_tmp1611_)) {
						break;
					}
					_tmp1612_ = _pos_it;
					_tmp1613_ = vala_iterator_get (_tmp1612_);
					pos = (gint) ((gintptr) _tmp1613_);
					if (pos > last_pos) {
						gboolean _tmp1615_ = FALSE;
						if (min_pos == -1) {
							_tmp1615_ = TRUE;
						} else {
							_tmp1615_ = pos < min_pos;
						}
						_tmp1614_ = _tmp1615_;
					} else {
						_tmp1614_ = FALSE;
					}
					if (_tmp1614_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1616_ = ccall;
			_tmp1617_ = out_arg_map;
			_tmp1618_ = vala_map_get ((ValaMap*) _tmp1617_, (gpointer) ((gintptr) min_pos));
			_tmp1619_ = (ValaCCodeExpression*) _tmp1618_;
			vala_ccode_function_call_add_argument (_tmp1616_, _tmp1619_);
			_vala_ccode_node_unref0 (_tmp1619_);
			last_pos = min_pos;
		}
	}
	_tmp1620_ = async_call;
	if (_tmp1620_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1631_;
			ValaHashMap* _tmp1632_;
			gpointer _tmp1633_;
			ValaCCodeExpression* _tmp1634_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1621_;
				ValaSet* _tmp1622_;
				ValaSet* _tmp1623_;
				ValaIterator* _tmp1624_;
				ValaIterator* _tmp1625_;
				_tmp1621_ = in_arg_map;
				_tmp1622_ = vala_map_get_keys ((ValaMap*) _tmp1621_);
				_tmp1623_ = _tmp1622_;
				_tmp1624_ = vala_iterable_iterator ((ValaIterable*) _tmp1623_);
				_tmp1625_ = _tmp1624_;
				_vala_iterable_unref0 (_tmp1623_);
				_pos_it = _tmp1625_;
				while (TRUE) {
					ValaIterator* _tmp1626_;
					gint pos = 0;
					ValaIterator* _tmp1627_;
					gpointer _tmp1628_;
					gboolean _tmp1629_ = FALSE;
					_tmp1626_ = _pos_it;
					if (!vala_iterator_next (_tmp1626_)) {
						break;
					}
					_tmp1627_ = _pos_it;
					_tmp1628_ = vala_iterator_get (_tmp1627_);
					pos = (gint) ((gintptr) _tmp1628_);
					if (pos > last_pos) {
						gboolean _tmp1630_ = FALSE;
						if (min_pos == -1) {
							_tmp1630_ = TRUE;
						} else {
							_tmp1630_ = pos < min_pos;
						}
						_tmp1629_ = _tmp1630_;
					} else {
						_tmp1629_ = FALSE;
					}
					if (_tmp1629_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1631_ = async_call;
			_tmp1632_ = in_arg_map;
			_tmp1633_ = vala_map_get ((ValaMap*) _tmp1632_, (gpointer) ((gintptr) min_pos));
			_tmp1634_ = (ValaCCodeExpression*) _tmp1633_;
			vala_ccode_function_call_add_argument (_tmp1631_, _tmp1634_);
			_vala_ccode_node_unref0 (_tmp1634_);
			last_pos = min_pos;
		}
	}
	_tmp1635_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1636_ = _tmp1635_;
	if (_tmp1636_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1637_;
		gint _tmp1638_;
		ValaCCodeFunction* _tmp1639_;
		ValaCCodeFunction* _tmp1640_;
		ValaCCodeIdentifier* _tmp1641_;
		ValaCCodeIdentifier* _tmp1642_;
		ValaCCodeMemberAccess* _tmp1643_;
		ValaCCodeMemberAccess* _tmp1644_;
		gchar* _tmp1645_;
		gchar* _tmp1646_;
		ValaCCodeConstant* _tmp1647_;
		ValaCCodeConstant* _tmp1648_;
		ValaCCodeFunction* _tmp1649_;
		ValaCCodeFunction* _tmp1650_;
		ValaCCodeFunctionCall* _tmp1651_;
		ValaCCodeFunction* _tmp1652_;
		ValaCCodeFunction* _tmp1653_;
		ValaCCodeConstant* _tmp1654_;
		ValaCCodeConstant* _tmp1655_;
		ValaCCodeFunction* _tmp1656_;
		ValaCCodeFunction* _tmp1657_;
		gchar* _tmp1658_;
		gchar* _tmp1659_;
		_tmp1637_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1638_ = _tmp1637_->next_coroutine_state;
		_tmp1637_->next_coroutine_state = _tmp1638_ + 1;
		state = _tmp1638_;
		_tmp1639_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1640_ = _tmp1639_;
		_tmp1641_ = vala_ccode_identifier_new ("_data_");
		_tmp1642_ = _tmp1641_;
		_tmp1643_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1642_, "_state_");
		_tmp1644_ = _tmp1643_;
		_tmp1645_ = g_strdup_printf ("%i", state);
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = vala_ccode_constant_new (_tmp1646_);
		_tmp1648_ = _tmp1647_;
		vala_ccode_function_add_assignment (_tmp1640_, (ValaCCodeExpression*) _tmp1644_, (ValaCCodeExpression*) _tmp1648_);
		_vala_ccode_node_unref0 (_tmp1648_);
		_g_free0 (_tmp1646_);
		_vala_ccode_node_unref0 (_tmp1644_);
		_vala_ccode_node_unref0 (_tmp1642_);
		_tmp1649_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = async_call;
		vala_ccode_function_add_expression (_tmp1650_, (ValaCCodeExpression*) _tmp1651_);
		_tmp1652_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1653_ = _tmp1652_;
		_tmp1654_ = vala_ccode_constant_new ("FALSE");
		_tmp1655_ = _tmp1654_;
		vala_ccode_function_add_return (_tmp1653_, (ValaCCodeExpression*) _tmp1655_);
		_vala_ccode_node_unref0 (_tmp1655_);
		_tmp1656_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1657_ = _tmp1656_;
		_tmp1658_ = g_strdup_printf ("_state_%d", state);
		_tmp1659_ = _tmp1658_;
		vala_ccode_function_add_label (_tmp1657_, _tmp1659_);
		_g_free0 (_tmp1659_);
	}
	_tmp1660_ = vala_method_call_get_is_assert (expr);
	_tmp1661_ = _tmp1660_;
	if (_tmp1661_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1662_;
		ValaSourceReference* _tmp1663_;
		ValaSourceLocation _tmp1664_ = {0};
		ValaSourceLocation _tmp1665_;
		gchar* _tmp1666_;
		ValaSourceReference* _tmp1667_;
		ValaSourceReference* _tmp1668_;
		ValaSourceLocation _tmp1669_ = {0};
		ValaSourceLocation _tmp1670_;
		gchar* _tmp1671_;
		ValaSourceReference* _tmp1672_;
		ValaSourceReference* _tmp1673_;
		ValaSourceLocation _tmp1674_ = {0};
		ValaSourceLocation _tmp1675_;
		gchar* _tmp1676_;
		gchar* _tmp1677_;
		ValaCCodeFunctionCall* _tmp1678_;
		ValaCCodeIdentifier* _tmp1679_;
		ValaCCodeIdentifier* _tmp1680_;
		ValaCCodeFunctionCall* _tmp1681_;
		const gchar* _tmp1682_;
		gchar* _tmp1683_;
		gchar* _tmp1684_;
		gchar* _tmp1685_;
		gchar* _tmp1686_;
		gchar* _tmp1687_;
		gchar* _tmp1688_;
		ValaCCodeConstant* _tmp1689_;
		ValaCCodeConstant* _tmp1690_;
		_tmp1662_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1663_ = _tmp1662_;
		vala_source_reference_get_begin (_tmp1663_, &_tmp1664_);
		_tmp1665_ = _tmp1664_;
		_tmp1666_ = _tmp1665_.pos;
		_tmp1667_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1668_ = _tmp1667_;
		vala_source_reference_get_end (_tmp1668_, &_tmp1669_);
		_tmp1670_ = _tmp1669_;
		_tmp1671_ = _tmp1670_.pos;
		_tmp1672_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1673_ = _tmp1672_;
		vala_source_reference_get_begin (_tmp1673_, &_tmp1674_);
		_tmp1675_ = _tmp1674_;
		_tmp1676_ = _tmp1675_.pos;
		_tmp1677_ = string_substring ((const gchar*) _tmp1666_, (glong) 0, (glong) ((gint) (_tmp1671_ - _tmp1676_)));
		message = _tmp1677_;
		_tmp1678_ = ccall;
		_tmp1679_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1680_ = _tmp1679_;
		vala_ccode_function_call_set_call (_tmp1678_, (ValaCCodeExpression*) _tmp1680_);
		_vala_ccode_node_unref0 (_tmp1680_);
		_tmp1681_ = ccall;
		_tmp1682_ = message;
		_tmp1683_ = string_replace (_tmp1682_, "\n", " ");
		_tmp1684_ = _tmp1683_;
		_tmp1685_ = g_strescape (_tmp1684_, "");
		_tmp1686_ = _tmp1685_;
		_tmp1687_ = g_strdup_printf ("\"%s\"", _tmp1686_);
		_tmp1688_ = _tmp1687_;
		_tmp1689_ = vala_ccode_constant_new (_tmp1688_);
		_tmp1690_ = _tmp1689_;
		vala_ccode_function_call_add_argument (_tmp1681_, (ValaCCodeExpression*) _tmp1690_);
		_vala_ccode_node_unref0 (_tmp1690_);
		_g_free0 (_tmp1688_);
		_g_free0 (_tmp1686_);
		_g_free0 (_tmp1684_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1691_;
		ValaCCodeFunction* _tmp1692_;
		ValaCCodeExpression* _tmp1693_;
		ValaCCodeExpression* _tmp1694_;
		ValaCCodeExpression* _tmp1695_;
		_tmp1691_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1692_ = _tmp1691_;
		_tmp1693_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1692_, _tmp1693_);
		_tmp1694_ = out_param_ref;
		_tmp1695_ = _vala_ccode_node_ref0 (_tmp1694_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1695_;
	}
	_tmp1698_ = m;
	if (_tmp1698_ != NULL) {
		ValaMethod* _tmp1699_;
		ValaMemberBinding _tmp1700_;
		ValaMemberBinding _tmp1701_;
		_tmp1699_ = m;
		_tmp1700_ = vala_method_get_binding (_tmp1699_);
		_tmp1701_ = _tmp1700_;
		_tmp1697_ = _tmp1701_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1697_ = FALSE;
	}
	if (_tmp1697_) {
		ValaMethod* _tmp1702_;
		gboolean _tmp1703_;
		gboolean _tmp1704_;
		_tmp1702_ = m;
		_tmp1703_ = vala_method_get_returns_modified_pointer (_tmp1702_);
		_tmp1704_ = _tmp1703_;
		_tmp1696_ = _tmp1704_;
	} else {
		_tmp1696_ = FALSE;
	}
	if (_tmp1696_) {
		gboolean _tmp1705_ = FALSE;
		gboolean _tmp1706_ = FALSE;
		ValaMemberAccess* _tmp1707_;
		_tmp1707_ = ma;
		if (_tmp1707_ != NULL) {
			ValaMemberAccess* _tmp1708_;
			ValaExpression* _tmp1709_;
			ValaExpression* _tmp1710_;
			ValaSymbol* _tmp1711_;
			ValaSymbol* _tmp1712_;
			_tmp1708_ = ma;
			_tmp1709_ = vala_member_access_get_inner (_tmp1708_);
			_tmp1710_ = _tmp1709_;
			_tmp1711_ = vala_expression_get_symbol_reference (_tmp1710_);
			_tmp1712_ = _tmp1711_;
			_tmp1706_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1712_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1706_ = FALSE;
		}
		if (_tmp1706_) {
			ValaMemberAccess* _tmp1713_;
			ValaExpression* _tmp1714_;
			ValaExpression* _tmp1715_;
			_tmp1713_ = ma;
			_tmp1714_ = vala_member_access_get_inner (_tmp1713_);
			_tmp1715_ = _tmp1714_;
			_tmp1705_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1715_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1705_ = FALSE;
		}
		if (_tmp1705_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1716_;
			ValaExpression* _tmp1717_;
			ValaExpression* _tmp1718_;
			ValaSymbol* _tmp1719_;
			ValaSymbol* _tmp1720_;
			ValaProperty* _tmp1721_;
			ValaProperty* _tmp1722_;
			ValaMemberAccess* _tmp1723_;
			ValaExpression* _tmp1724_;
			ValaExpression* _tmp1725_;
			ValaExpression* _tmp1726_;
			ValaExpression* _tmp1727_;
			ValaDataType* _tmp1728_;
			ValaDataType* _tmp1729_;
			ValaCCodeExpression* _tmp1730_;
			ValaGLibValue* _tmp1731_;
			ValaGLibValue* _tmp1732_;
			_tmp1716_ = ma;
			_tmp1717_ = vala_member_access_get_inner (_tmp1716_);
			_tmp1718_ = _tmp1717_;
			_tmp1719_ = vala_expression_get_symbol_reference (_tmp1718_);
			_tmp1720_ = _tmp1719_;
			_tmp1721_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1720_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1721_;
			_tmp1722_ = prop;
			_tmp1723_ = ma;
			_tmp1724_ = vala_member_access_get_inner (_tmp1723_);
			_tmp1725_ = _tmp1724_;
			_tmp1726_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1725_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1727_ = _tmp1726_;
			_tmp1728_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1729_ = _tmp1728_;
			_tmp1730_ = ccall_expr;
			_tmp1731_ = vala_glib_value_new (_tmp1729_, _tmp1730_, FALSE);
			_tmp1732_ = _tmp1731_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1722_, _tmp1727_, (ValaTargetValue*) _tmp1732_);
			_vala_target_value_unref0 (_tmp1732_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1733_;
			ValaCCodeExpression* _tmp1734_;
			ValaCCodeAssignment* _tmp1735_;
			_tmp1733_ = instance;
			_tmp1734_ = ccall_expr;
			_tmp1735_ = vala_ccode_assignment_new (_tmp1733_, _tmp1734_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1735_;
		}
	}
	_tmp1741_ = m;
	if (_tmp1741_ != NULL) {
		ValaMethod* _tmp1742_;
		_tmp1742_ = m;
		_tmp1740_ = vala_get_ccode_simple_generics (_tmp1742_);
	} else {
		_tmp1740_ = FALSE;
	}
	if (_tmp1740_) {
		ValaMethod* _tmp1743_;
		ValaDataType* _tmp1744_;
		ValaDataType* _tmp1745_;
		_tmp1743_ = m;
		_tmp1744_ = vala_callable_get_return_type ((ValaCallable*) _tmp1743_);
		_tmp1745_ = _tmp1744_;
		_tmp1739_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1745_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1739_ = FALSE;
	}
	if (_tmp1739_) {
		ValaDataType* _tmp1746_;
		ValaDataType* _tmp1747_;
		_tmp1746_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1747_ = _tmp1746_;
		_tmp1738_ = vala_data_type_is_real_struct_type (_tmp1747_);
	} else {
		_tmp1738_ = FALSE;
	}
	if (_tmp1738_) {
		ValaDataType* _tmp1748_;
		ValaDataType* _tmp1749_;
		gboolean _tmp1750_;
		gboolean _tmp1751_;
		_tmp1748_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1749_ = _tmp1748_;
		_tmp1750_ = vala_data_type_get_nullable (_tmp1749_);
		_tmp1751_ = _tmp1750_;
		_tmp1737_ = !_tmp1751_;
	} else {
		_tmp1737_ = FALSE;
	}
	if (_tmp1737_) {
		ValaDataType* _tmp1752_;
		ValaDataType* _tmp1753_;
		_tmp1752_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1753_ = _tmp1752_;
		_tmp1736_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1753_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1736_ = FALSE;
	}
	if (_tmp1736_) {
		ValaCCodeExpression* _tmp1754_;
		ValaCCodeParenthesizedExpression* _tmp1755_;
		ValaCCodeParenthesizedExpression* _tmp1756_;
		ValaCCodeUnaryExpression* _tmp1757_;
		_tmp1754_ = ccall_expr;
		_tmp1755_ = vala_ccode_parenthesized_expression_new (_tmp1754_);
		_tmp1756_ = _tmp1755_;
		_tmp1757_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1756_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1757_;
		_vala_ccode_node_unref0 (_tmp1756_);
	}
	_tmp1760_ = m;
	if (_tmp1760_ != NULL) {
		ValaMethod* _tmp1761_;
		gchar* _tmp1762_;
		gchar* _tmp1763_;
		_tmp1761_ = m;
		_tmp1762_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1761_);
		_tmp1763_ = _tmp1762_;
		_tmp1759_ = _tmp1763_ != NULL;
		_g_free0 (_tmp1763_);
	} else {
		_tmp1759_ = FALSE;
	}
	if (_tmp1759_) {
		ValaMethod* _tmp1764_;
		gchar* _tmp1765_;
		gchar* _tmp1766_;
		ValaMethod* _tmp1767_;
		ValaDataType* _tmp1768_;
		ValaDataType* _tmp1769_;
		gchar* _tmp1770_;
		gchar* _tmp1771_;
		_tmp1764_ = m;
		_tmp1765_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1764_);
		_tmp1766_ = _tmp1765_;
		_tmp1767_ = m;
		_tmp1768_ = vala_callable_get_return_type ((ValaCallable*) _tmp1767_);
		_tmp1769_ = _tmp1768_;
		_tmp1770_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1758_ = g_strcmp0 (_tmp1766_, _tmp1771_) != 0;
		_g_free0 (_tmp1771_);
		_g_free0 (_tmp1766_);
	} else {
		_tmp1758_ = FALSE;
	}
	if (_tmp1758_) {
		ValaCCodeExpression* _tmp1772_;
		ValaMethod* _tmp1773_;
		ValaDataType* _tmp1774_;
		ValaDataType* _tmp1775_;
		gchar* _tmp1776_;
		gchar* _tmp1777_;
		ValaCCodeCastExpression* _tmp1778_;
		_tmp1772_ = ccall_expr;
		_tmp1773_ = m;
		_tmp1774_ = vala_callable_get_return_type ((ValaCallable*) _tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1776_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1775_);
		_tmp1777_ = _tmp1776_;
		_tmp1778_ = vala_ccode_cast_expression_new (_tmp1772_, _tmp1777_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1778_;
		_g_free0 (_tmp1777_);
	}
	_tmp1779_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1779_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1780_;
		ValaList* _tmp1781_;
		ValaIterator* _tmp1782_;
		ValaIterator* _tmp1783_;
		ValaIterator* _tmp1784_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1785_;
		gpointer _tmp1786_;
		ValaExpression* _tmp1787_;
		ValaCCodeExpression* _tmp1788_;
		ValaCCodeExpression* _tmp1789_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1790_;
		ValaLocalVariable* _tmp1791_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1792_;
		const gchar* _tmp1793_;
		const gchar* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaLocalVariable* _tmp1796_;
		ValaCCodeFile* _tmp1797_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1798_;
		ValaExpression* _tmp1799_;
		ValaExpression* _tmp1800_;
		ValaCCodeExpression* _tmp1801_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1802_;
		ValaExpression* _tmp1803_;
		ValaExpression* _tmp1804_;
		ValaCCodeExpression* _tmp1805_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1806_;
		ValaExpression* _tmp1807_;
		ValaExpression* _tmp1808_;
		ValaDataType* _tmp1809_;
		ValaDataType* _tmp1810_;
		ValaArrayType* _tmp1811_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1812_;
		ValaDataType* _tmp1813_;
		ValaDataType* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		gchar* _tmp1817_;
		gchar* _tmp1818_;
		ValaCCodeIdentifier* _tmp1819_;
		ValaCCodeIdentifier* _tmp1820_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1821_;
		ValaCCodeExpression* _tmp1822_;
		ValaCCodeBinaryExpression* _tmp1823_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1824_;
		ValaCCodeExpression* _tmp1825_;
		ValaCCodeBinaryExpression* _tmp1826_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1827_;
		ValaCCodeIdentifier* _tmp1828_;
		ValaCCodeFunctionCall* _tmp1829_;
		ValaCCodeFunctionCall* _tmp1830_;
		ValaCCodeFunctionCall* _tmp1831_;
		ValaCCodeExpression* _tmp1832_;
		ValaCCodeExpression* _tmp1833_;
		ValaCCodeBinaryExpression* _tmp1834_;
		ValaCCodeBinaryExpression* _tmp1835_;
		ValaCCodeFunctionCall* _tmp1836_;
		ValaCCodeConstant* _tmp1837_;
		ValaCCodeConstant* _tmp1838_;
		ValaCCodeFunctionCall* _tmp1839_;
		ValaCCodeIdentifier* _tmp1840_;
		ValaCCodeBinaryExpression* _tmp1841_;
		ValaCCodeBinaryExpression* _tmp1842_;
		ValaCCodeBinaryExpression* _tmp1843_;
		ValaCCodeFunction* _tmp1844_;
		ValaCCodeFunction* _tmp1845_;
		ValaCCodeExpression* _tmp1846_;
		ValaCCodeExpression* _tmp1847_;
		ValaCCodeFunction* _tmp1848_;
		ValaCCodeFunction* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaCCodeFunction* _tmp1851_;
		ValaCCodeFunction* _tmp1852_;
		ValaCCodeBinaryExpression* _tmp1853_;
		ValaCCodeFunctionCall* _tmp1854_;
		ValaCCodeConstant* _tmp1855_;
		ValaCCodeConstant* _tmp1856_;
		ValaCCodeConditionalExpression* _tmp1857_;
		ValaCCodeConditionalExpression* _tmp1858_;
		ValaCCodeFunction* _tmp1859_;
		ValaCCodeFunction* _tmp1860_;
		ValaMemberAccess* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaExpression* _tmp1863_;
		ValaCCodeExpression* _tmp1864_;
		ValaCCodeExpression* _tmp1865_;
		ValaCCodeExpression* _tmp1866_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1867_;
		ValaExpression* _tmp1868_;
		ValaExpression* _tmp1869_;
		ValaSymbol* _tmp1870_;
		ValaSymbol* _tmp1871_;
		ValaSymbol* _tmp1872_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1873_;
		ValaLocalVariable* _tmp1874_;
		gboolean _tmp1875_ = FALSE;
		gboolean _tmp1876_ = FALSE;
		ValaSymbol* _tmp1877_;
		_tmp1780_ = vala_method_call_get_argument_list (expr);
		_tmp1781_ = _tmp1780_;
		_tmp1782_ = vala_iterable_iterator ((ValaIterable*) _tmp1781_);
		_tmp1783_ = _tmp1782_;
		_vala_iterable_unref0 (_tmp1781_);
		arg_it = _tmp1783_;
		_tmp1784_ = arg_it;
		vala_iterator_next (_tmp1784_);
		_tmp1785_ = arg_it;
		_tmp1786_ = vala_iterator_get (_tmp1785_);
		_tmp1787_ = (ValaExpression*) _tmp1786_;
		_tmp1788_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1787_);
		_tmp1789_ = _tmp1788_;
		_vala_code_node_unref0 (_tmp1787_);
		new_size = _tmp1789_;
		_tmp1790_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1791_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1790_, TRUE, NULL, FALSE);
		temp_decl = _tmp1791_;
		_tmp1792_ = temp_decl;
		_tmp1793_ = vala_symbol_get_name ((ValaSymbol*) _tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1794_);
		temp_ref = _tmp1795_;
		_tmp1796_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1796_, FALSE);
		_tmp1797_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1797_, "string.h", FALSE);
		_tmp1798_ = ma;
		_tmp1799_ = vala_member_access_get_inner (_tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1801_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1800_, 1);
		clen = _tmp1801_;
		_tmp1802_ = ma;
		_tmp1803_ = vala_member_access_get_inner (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1804_);
		celems = _tmp1805_;
		_tmp1806_ = ma;
		_tmp1807_ = vala_member_access_get_inner (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1809_ = vala_expression_get_value_type (_tmp1808_);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1810_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1811_;
		_tmp1812_ = array_type;
		_tmp1813_ = vala_array_type_get_element_type (_tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1817_ = g_strdup_printf ("sizeof (%s)", _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_ccode_identifier_new (_tmp1818_);
		_tmp1820_ = _tmp1819_;
		_g_free0 (_tmp1818_);
		_g_free0 (_tmp1816_);
		csizeof = _tmp1820_;
		_tmp1821_ = temp_ref;
		_tmp1822_ = clen;
		_tmp1823_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1821_, _tmp1822_);
		cdelta = _tmp1823_;
		_tmp1824_ = temp_ref;
		_tmp1825_ = clen;
		_tmp1826_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1824_, _tmp1825_);
		ccheck = _tmp1826_;
		_tmp1827_ = vala_ccode_identifier_new ("memset");
		_tmp1828_ = _tmp1827_;
		_tmp1829_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1828_);
		_tmp1830_ = _tmp1829_;
		_vala_ccode_node_unref0 (_tmp1828_);
		czero = _tmp1830_;
		_tmp1831_ = czero;
		_tmp1832_ = celems;
		_tmp1833_ = clen;
		_tmp1834_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1832_, _tmp1833_);
		_tmp1835_ = _tmp1834_;
		vala_ccode_function_call_add_argument (_tmp1831_, (ValaCCodeExpression*) _tmp1835_);
		_vala_ccode_node_unref0 (_tmp1835_);
		_tmp1836_ = czero;
		_tmp1837_ = vala_ccode_constant_new ("0");
		_tmp1838_ = _tmp1837_;
		vala_ccode_function_call_add_argument (_tmp1836_, (ValaCCodeExpression*) _tmp1838_);
		_vala_ccode_node_unref0 (_tmp1838_);
		_tmp1839_ = czero;
		_tmp1840_ = csizeof;
		_tmp1841_ = cdelta;
		_tmp1842_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1840_, (ValaCCodeExpression*) _tmp1841_);
		_tmp1843_ = _tmp1842_;
		vala_ccode_function_call_add_argument (_tmp1839_, (ValaCCodeExpression*) _tmp1843_);
		_vala_ccode_node_unref0 (_tmp1843_);
		_tmp1844_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = temp_ref;
		_tmp1847_ = new_size;
		vala_ccode_function_add_assignment (_tmp1845_, _tmp1846_, _tmp1847_);
		_tmp1848_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1849_ = _tmp1848_;
		_tmp1850_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1849_, _tmp1850_);
		_tmp1851_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = ccheck;
		_tmp1854_ = czero;
		_tmp1855_ = vala_ccode_constant_new ("NULL");
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1853_, (ValaCCodeExpression*) _tmp1854_, (ValaCCodeExpression*) _tmp1856_);
		_tmp1858_ = _tmp1857_;
		vala_ccode_function_add_expression (_tmp1852_, (ValaCCodeExpression*) _tmp1858_);
		_vala_ccode_node_unref0 (_tmp1858_);
		_vala_ccode_node_unref0 (_tmp1856_);
		_tmp1859_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1860_ = _tmp1859_;
		_tmp1861_ = ma;
		_tmp1862_ = vala_member_access_get_inner (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1863_, 1);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1860_, _tmp1865_, _tmp1866_);
		_vala_ccode_node_unref0 (_tmp1865_);
		_tmp1867_ = ma;
		_tmp1868_ = vala_member_access_get_inner (_tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = vala_expression_get_symbol_reference (_tmp1869_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = _vala_code_node_ref0 (_tmp1871_);
		array_var = _tmp1872_;
		_tmp1873_ = array_var;
		_tmp1874_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1873_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1873_) : NULL);
		array_local = _tmp1874_;
		_tmp1877_ = array_var;
		if (_tmp1877_ != NULL) {
			ValaSymbol* _tmp1878_;
			_tmp1878_ = array_var;
			_tmp1876_ = vala_symbol_is_internal_symbol (_tmp1878_);
		} else {
			_tmp1876_ = FALSE;
		}
		if (_tmp1876_) {
			gboolean _tmp1879_ = FALSE;
			gboolean _tmp1880_ = FALSE;
			ValaSymbol* _tmp1881_;
			_tmp1881_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1881_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1882_;
				gboolean _tmp1883_;
				gboolean _tmp1884_;
				_tmp1882_ = array_local;
				_tmp1883_ = vala_local_variable_get_captured (_tmp1882_);
				_tmp1884_ = _tmp1883_;
				_tmp1880_ = !_tmp1884_;
			} else {
				_tmp1880_ = FALSE;
			}
			if (_tmp1880_) {
				_tmp1879_ = TRUE;
			} else {
				ValaSymbol* _tmp1885_;
				_tmp1885_ = array_var;
				_tmp1879_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1885_, VALA_TYPE_FIELD);
			}
			_tmp1875_ = _tmp1879_;
		} else {
			_tmp1875_ = FALSE;
		}
		if (_tmp1875_) {
			ValaCCodeFunction* _tmp1886_;
			ValaCCodeFunction* _tmp1887_;
			ValaMemberAccess* _tmp1888_;
			ValaExpression* _tmp1889_;
			ValaExpression* _tmp1890_;
			ValaTargetValue* _tmp1891_;
			ValaTargetValue* _tmp1892_;
			ValaCCodeExpression* _tmp1893_;
			ValaCCodeExpression* _tmp1894_;
			ValaCCodeExpression* _tmp1895_;
			_tmp1886_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1887_ = _tmp1886_;
			_tmp1888_ = ma;
			_tmp1889_ = vala_member_access_get_inner (_tmp1888_);
			_tmp1890_ = _tmp1889_;
			_tmp1891_ = vala_expression_get_target_value (_tmp1890_);
			_tmp1892_ = _tmp1891_;
			_tmp1893_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1892_);
			_tmp1894_ = _tmp1893_;
			_tmp1895_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1887_, _tmp1894_, _tmp1895_);
			_vala_ccode_node_unref0 (_tmp1894_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1897_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1898_ = _tmp1897_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1898_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1899_;
		ValaDataType* _tmp1900_;
		_tmp1899_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1900_ = _tmp1899_;
		_tmp1896_ = !vala_data_type_is_disposable (_tmp1900_);
	} else {
		_tmp1896_ = FALSE;
	}
	if (_tmp1896_) {
		gboolean _tmp1901_ = FALSE;
		ValaCCodeExpression* _tmp1902_;
		_tmp1902_ = ccall_expr;
		if (_tmp1902_ != NULL) {
			_tmp1901_ = !return_result_via_out_param;
		} else {
			_tmp1901_ = FALSE;
		}
		if (_tmp1901_) {
			ValaCCodeFunction* _tmp1903_;
			ValaCCodeFunction* _tmp1904_;
			ValaCCodeExpression* _tmp1905_;
			_tmp1903_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1904_ = _tmp1903_;
			_tmp1905_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1904_, _tmp1905_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1906_;
		ValaDataType* _tmp1907_;
		gboolean _tmp1908_ = FALSE;
		ValaDataType* _tmp1909_;
		ValaDataType* _tmp1910_;
		gboolean _tmp1937_ = FALSE;
		ValaMethod* _tmp1938_;
		_tmp1906_ = itype;
		_tmp1907_ = vala_data_type_get_return_type (_tmp1906_);
		result_type = _tmp1907_;
		_tmp1909_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1910_ = _tmp1909_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1910_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1911_;
			ValaDataType* _tmp1912_;
			_tmp1911_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1912_ = _tmp1911_;
			_tmp1908_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1912_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1908_ = FALSE;
		}
		if (_tmp1908_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1913_;
			ValaDataType* _tmp1914_;
			ValaTypeParameter* _tmp1915_;
			ValaTypeParameter* _tmp1916_;
			ValaTypeParameter* _tmp1917_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1918_;
			ValaSymbol* _tmp1919_;
			ValaSymbol* _tmp1920_;
			ValaSymbol* _tmp1921_;
			ValaSymbol* _tmp1922_;
			ValaStruct* _tmp1923_;
			gboolean _tmp1924_ = FALSE;
			ValaTypeParameter* _tmp1925_;
			ValaSymbol* _tmp1926_;
			ValaSymbol* _tmp1927_;
			ValaTypeSymbol* _tmp1928_;
			_tmp1913_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1914_ = _tmp1913_;
			_tmp1915_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1914_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1916_ = _tmp1915_;
			_tmp1917_ = _vala_code_node_ref0 (_tmp1916_);
			type_parameter = _tmp1917_;
			_tmp1918_ = type_parameter;
			_tmp1919_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1918_);
			_tmp1920_ = _tmp1919_;
			_tmp1921_ = vala_symbol_get_parent_symbol (_tmp1920_);
			_tmp1922_ = _tmp1921_;
			_tmp1923_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1922_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1922_) : NULL);
			st = _tmp1923_;
			_tmp1925_ = type_parameter;
			_tmp1926_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1925_);
			_tmp1927_ = _tmp1926_;
			_tmp1928_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1927_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1928_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1924_ = TRUE;
			} else {
				gboolean _tmp1929_ = FALSE;
				ValaStruct* _tmp1930_;
				_tmp1930_ = st;
				if (_tmp1930_ != NULL) {
					ValaStruct* _tmp1931_;
					gchar* _tmp1932_;
					gchar* _tmp1933_;
					_tmp1931_ = st;
					_tmp1932_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1931_);
					_tmp1933_ = _tmp1932_;
					_tmp1929_ = g_strcmp0 (_tmp1933_, "va_list") == 0;
					_g_free0 (_tmp1933_);
				} else {
					_tmp1929_ = FALSE;
				}
				_tmp1924_ = _tmp1929_;
			}
			if (_tmp1924_) {
				ValaDataType* _tmp1934_;
				ValaDataType* _tmp1935_;
				ValaDataType* _tmp1936_;
				_tmp1934_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1935_ = _tmp1934_;
				_tmp1936_ = _vala_code_node_ref0 (_tmp1935_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1936_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1938_ = m;
		if (_tmp1938_ != NULL) {
			ValaMethod* _tmp1939_;
			_tmp1939_ = m;
			_tmp1937_ = vala_method_get_format_arg_index (_tmp1939_) >= 0;
		} else {
			_tmp1937_ = FALSE;
		}
		if (_tmp1937_) {
			ValaCCodeExpression* _tmp1940_;
			_tmp1940_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1940_);
		} else {
			gboolean _tmp1941_ = FALSE;
			ValaMethod* _tmp1942_;
			_tmp1942_ = m;
			if (_tmp1942_ != NULL) {
				ValaMethod* _tmp1943_;
				_tmp1943_ = m;
				_tmp1941_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1943_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1941_ = FALSE;
			}
			if (_tmp1941_) {
				ValaCCodeExpression* _tmp1944_;
				_tmp1944_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1944_);
			} else {
				gboolean _tmp1945_ = FALSE;
				gboolean _tmp1946_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp1946_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1946_ = FALSE;
				}
				if (_tmp1946_) {
					gboolean _tmp1947_ = FALSE;
					ValaDataType* _tmp1948_;
					_tmp1948_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1948_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1949_;
						_tmp1949_ = result_type;
						_tmp1947_ = !vala_data_type_is_disposable (_tmp1949_);
					} else {
						_tmp1947_ = FALSE;
					}
					_tmp1945_ = _tmp1947_;
				} else {
					_tmp1945_ = FALSE;
				}
				if (_tmp1945_) {
					ValaCCodeExpression* _tmp1950_;
					_tmp1950_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1950_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1951_;
						ValaDataType* _tmp1952_;
						gboolean _tmp1953_;
						gboolean _tmp1954_;
						ValaLocalVariable* _tmp1955_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1956_;
						const gchar* _tmp1957_;
						const gchar* _tmp1958_;
						ValaCCodeExpression* _tmp1959_;
						ValaLocalVariable* _tmp1960_;
						ValaCCodeFunction* _tmp1961_;
						ValaCCodeFunction* _tmp1962_;
						ValaCCodeExpression* _tmp1963_;
						ValaCCodeExpression* _tmp1964_;
						ValaCCodeExpression* _tmp1965_;
						ValaTargetValue* _tmp1966_;
						ValaTargetValue* _tmp1967_;
						_tmp1951_ = result_type;
						_tmp1952_ = result_type;
						_tmp1953_ = vala_data_type_get_value_owned (_tmp1952_);
						_tmp1954_ = _tmp1953_;
						_tmp1955_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1951_, _tmp1954_, NULL, FALSE);
						temp_var = _tmp1955_;
						_tmp1956_ = temp_var;
						_tmp1957_ = vala_symbol_get_name ((ValaSymbol*) _tmp1956_);
						_tmp1958_ = _tmp1957_;
						_tmp1959_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1958_);
						temp_ref = _tmp1959_;
						_tmp1960_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1960_, FALSE);
						_tmp1961_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1962_ = _tmp1961_;
						_tmp1963_ = temp_ref;
						_tmp1964_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1962_, _tmp1963_, _tmp1964_);
						_tmp1965_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1965_);
						_tmp1966_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1967_ = _tmp1966_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1967_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1968_;
						ValaTargetValue* _tmp1969_;
						ValaTargetValue* _tmp1970_;
						_tmp1968_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1968_);
						_tmp1969_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1970_ = _tmp1969_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1970_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1971_ = params;
	_tmp1972_ = vala_iterable_iterator ((ValaIterable*) _tmp1971_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1972_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1973_;
		gint _arg_size = 0;
		ValaList* _tmp1974_;
		gint _tmp1975_;
		gint _tmp1976_;
		gint _arg_index = 0;
		_tmp1973_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1973_;
		_tmp1974_ = _arg_list;
		_tmp1975_ = vala_collection_get_size ((ValaCollection*) _tmp1974_);
		_tmp1976_ = _tmp1975_;
		_arg_size = _tmp1976_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1977_;
			gpointer _tmp1978_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1979_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1982_;
			ValaUnaryExpression* _tmp1983_;
			gboolean _tmp1984_ = FALSE;
			ValaUnaryExpression* _tmp1985_;
			ValaUnaryExpression* _tmp1989_;
			ValaExpression* _tmp1990_;
			ValaExpression* _tmp1991_;
			ValaDataType* _tmp1992_;
			ValaDataType* _tmp1993_;
			ValaUnaryExpression* _tmp2003_;
			ValaExpression* _tmp2004_;
			ValaExpression* _tmp2005_;
			ValaTargetValue* _tmp2006_;
			ValaTargetValue* _tmp2007_;
			ValaUnaryExpression* _tmp2008_;
			ValaTargetValue* _tmp2009_;
			ValaTargetValue* _tmp2010_;
			ValaUnaryExpression* _tmp2011_;
			ValaExpression* _tmp2012_;
			ValaExpression* _tmp2013_;
			ValaDataType* _tmp2014_;
			ValaDataType* _tmp2015_;
			ValaExpression* _tmp2016_;
			ValaTargetValue* _tmp2017_;
			ValaTargetValue* _tmp2018_;
			ValaSourceReference* _tmp2019_;
			ValaSourceReference* _tmp2020_;
			gboolean _tmp2021_ = FALSE;
			ValaParameter* _tmp2022_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1977_ = _arg_list;
			_tmp1978_ = vala_list_get (_tmp1977_, _arg_index);
			arg = (ValaExpression*) _tmp1978_;
			param = NULL;
			_tmp1979_ = params_it;
			if (vala_iterator_next (_tmp1979_)) {
				ValaIterator* _tmp1980_;
				gpointer _tmp1981_;
				_tmp1980_ = params_it;
				_tmp1981_ = vala_iterator_get (_tmp1980_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1981_;
			}
			_tmp1982_ = arg;
			_tmp1983_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1982_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1982_) : NULL);
			unary = _tmp1983_;
			_tmp1985_ = unary;
			if (_tmp1985_ == NULL) {
				_tmp1984_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp1986_;
				ValaUnaryOperator _tmp1987_;
				ValaUnaryOperator _tmp1988_;
				_tmp1986_ = unary;
				_tmp1987_ = vala_unary_expression_get_operator (_tmp1986_);
				_tmp1988_ = _tmp1987_;
				_tmp1984_ = _tmp1988_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1984_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp1989_ = unary;
			_tmp1990_ = vala_unary_expression_get_inner (_tmp1989_);
			_tmp1991_ = _tmp1990_;
			_tmp1992_ = vala_expression_get_value_type (_tmp1991_);
			_tmp1993_ = _tmp1992_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp1993_)) {
				ValaCCodeFunction* _tmp1994_;
				ValaCCodeFunction* _tmp1995_;
				ValaUnaryExpression* _tmp1996_;
				ValaExpression* _tmp1997_;
				ValaExpression* _tmp1998_;
				ValaTargetValue* _tmp1999_;
				ValaTargetValue* _tmp2000_;
				ValaCCodeExpression* _tmp2001_;
				ValaCCodeExpression* _tmp2002_;
				_tmp1994_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp1995_ = _tmp1994_;
				_tmp1996_ = unary;
				_tmp1997_ = vala_unary_expression_get_inner (_tmp1996_);
				_tmp1998_ = _tmp1997_;
				_tmp1999_ = vala_expression_get_target_value (_tmp1998_);
				_tmp2000_ = _tmp1999_;
				_tmp2001_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2000_, FALSE);
				_tmp2002_ = _tmp2001_;
				vala_ccode_function_add_expression (_tmp1995_, _tmp2002_);
				_vala_ccode_node_unref0 (_tmp2002_);
			}
			_tmp2003_ = unary;
			_tmp2004_ = vala_unary_expression_get_inner (_tmp2003_);
			_tmp2005_ = _tmp2004_;
			_tmp2006_ = vala_expression_get_target_value (_tmp2005_);
			_tmp2007_ = _tmp2006_;
			_tmp2008_ = unary;
			_tmp2009_ = vala_expression_get_target_value ((ValaExpression*) _tmp2008_);
			_tmp2010_ = _tmp2009_;
			_tmp2011_ = unary;
			_tmp2012_ = vala_unary_expression_get_inner (_tmp2011_);
			_tmp2013_ = _tmp2012_;
			_tmp2014_ = vala_expression_get_value_type (_tmp2013_);
			_tmp2015_ = _tmp2014_;
			_tmp2016_ = arg;
			_tmp2017_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2010_, _tmp2015_, (ValaCodeNode*) _tmp2016_);
			_tmp2018_ = _tmp2017_;
			_tmp2019_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2020_ = _tmp2019_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2007_, _tmp2018_, _tmp2020_);
			_vala_target_value_unref0 (_tmp2018_);
			_tmp2022_ = param;
			if (_tmp2022_ != NULL) {
				ValaParameter* _tmp2023_;
				_tmp2023_ = param;
				_tmp2021_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2023_);
			} else {
				_tmp2021_ = FALSE;
			}
			if (_tmp2021_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2024_;
				ValaCCodeIdentifier* _tmp2025_;
				ValaCCodeFunctionCall* _tmp2026_;
				ValaCCodeFunctionCall* _tmp2027_;
				ValaCCodeFunctionCall* _tmp2028_;
				ValaUnaryExpression* _tmp2029_;
				ValaExpression* _tmp2030_;
				ValaExpression* _tmp2031_;
				ValaTargetValue* _tmp2032_;
				ValaTargetValue* _tmp2033_;
				ValaCCodeExpression* _tmp2034_;
				ValaCCodeExpression* _tmp2035_;
				ValaCCodeFunction* _tmp2036_;
				ValaCCodeFunction* _tmp2037_;
				ValaUnaryExpression* _tmp2038_;
				ValaExpression* _tmp2039_;
				ValaExpression* _tmp2040_;
				ValaTargetValue* _tmp2041_;
				ValaTargetValue* _tmp2042_;
				ValaCCodeExpression* _tmp2043_;
				ValaCCodeExpression* _tmp2044_;
				ValaCCodeFunctionCall* _tmp2045_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2024_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2025_ = _tmp2024_;
				_tmp2026_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2025_);
				_tmp2027_ = _tmp2026_;
				_vala_ccode_node_unref0 (_tmp2025_);
				len_call = _tmp2027_;
				_tmp2028_ = len_call;
				_tmp2029_ = unary;
				_tmp2030_ = vala_unary_expression_get_inner (_tmp2029_);
				_tmp2031_ = _tmp2030_;
				_tmp2032_ = vala_expression_get_target_value (_tmp2031_);
				_tmp2033_ = _tmp2032_;
				_tmp2034_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2033_);
				_tmp2035_ = _tmp2034_;
				vala_ccode_function_call_add_argument (_tmp2028_, _tmp2035_);
				_vala_ccode_node_unref0 (_tmp2035_);
				_tmp2036_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2037_ = _tmp2036_;
				_tmp2038_ = unary;
				_tmp2039_ = vala_unary_expression_get_inner (_tmp2038_);
				_tmp2040_ = _tmp2039_;
				_tmp2041_ = vala_expression_get_target_value (_tmp2040_);
				_tmp2042_ = _tmp2041_;
				_tmp2043_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2042_, 1);
				_tmp2044_ = _tmp2043_;
				_tmp2045_ = len_call;
				vala_ccode_function_add_assignment (_tmp2037_, _tmp2044_, (ValaCCodeExpression*) _tmp2045_);
				_vala_ccode_node_unref0 (_tmp2044_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2048_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2048_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2049_;
		ValaSymbol* _tmp2050_;
		ValaSymbol* _tmp2051_;
		_tmp2049_ = m;
		_tmp2050_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2049_);
		_tmp2051_ = _tmp2050_;
		_tmp2047_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2051_, VALA_TYPE_CLASS);
	} else {
		_tmp2047_ = FALSE;
	}
	if (_tmp2047_) {
		gboolean _tmp2052_ = FALSE;
		gboolean _tmp2053_ = FALSE;
		ValaClass* _tmp2054_;
		ValaClass* _tmp2055_;
		gboolean _tmp2056_;
		gboolean _tmp2057_;
		_tmp2054_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2055_ = _tmp2054_;
		_tmp2056_ = vala_class_get_is_compact (_tmp2055_);
		_tmp2057_ = _tmp2056_;
		if (_tmp2057_) {
			ValaClass* _tmp2058_;
			ValaClass* _tmp2059_;
			ValaClass* _tmp2060_;
			ValaClass* _tmp2061_;
			_tmp2058_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2059_ = _tmp2058_;
			_tmp2060_ = vala_class_get_base_class (_tmp2059_);
			_tmp2061_ = _tmp2060_;
			_tmp2053_ = _tmp2061_ != NULL;
		} else {
			_tmp2053_ = FALSE;
		}
		if (_tmp2053_) {
			_tmp2052_ = TRUE;
		} else {
			ValaClass* _tmp2062_;
			ValaClass* _tmp2063_;
			ValaClass* _tmp2064_;
			ValaClass* _tmp2065_;
			ValaClass* _tmp2066_;
			_tmp2062_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2063_ = _tmp2062_;
			_tmp2064_ = vala_class_get_base_class (_tmp2063_);
			_tmp2065_ = _tmp2064_;
			_tmp2066_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2052_ = _tmp2065_ == _tmp2066_;
		}
		_tmp2046_ = _tmp2052_;
	} else {
		_tmp2046_ = FALSE;
	}
	if (_tmp2046_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2067_;
		ValaClass* _tmp2068_;
		gchar* _tmp2069_;
		gchar* _tmp2070_;
		gchar* _tmp2071_;
		gchar* _tmp2072_;
		ValaCCodeIdentifier* _tmp2073_;
		ValaCCodeIdentifier* _tmp2074_;
		ValaCCodeFunctionCall* _tmp2075_;
		ValaCCodeFunctionCall* _tmp2076_;
		ValaCCodeFunctionCall* _tmp2077_;
		ValaCCodeExpression* _tmp2078_;
		ValaCCodeExpression* _tmp2079_;
		ValaClass* _tmp2080_;
		ValaClass* _tmp2081_;
		gboolean _tmp2082_;
		gboolean _tmp2083_;
		ValaCCodeFunction* _tmp2087_;
		ValaCCodeFunction* _tmp2088_;
		ValaCCodeFunctionCall* _tmp2089_;
		_tmp2067_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2068_ = _tmp2067_;
		_tmp2069_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2068_, NULL);
		_tmp2070_ = _tmp2069_;
		_tmp2071_ = g_strdup_printf ("%s_instance_init", _tmp2070_);
		_tmp2072_ = _tmp2071_;
		_tmp2073_ = vala_ccode_identifier_new (_tmp2072_);
		_tmp2074_ = _tmp2073_;
		_tmp2075_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2074_);
		_tmp2076_ = _tmp2075_;
		_vala_ccode_node_unref0 (_tmp2074_);
		_g_free0 (_tmp2072_);
		_g_free0 (_tmp2070_);
		cinitcall = _tmp2076_;
		_tmp2077_ = cinitcall;
		_tmp2078_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2079_ = _tmp2078_;
		vala_ccode_function_call_add_argument (_tmp2077_, _tmp2079_);
		_vala_ccode_node_unref0 (_tmp2079_);
		_tmp2080_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2081_ = _tmp2080_;
		_tmp2082_ = vala_class_get_is_compact (_tmp2081_);
		_tmp2083_ = _tmp2082_;
		if (!_tmp2083_) {
			ValaCCodeFunctionCall* _tmp2084_;
			ValaCCodeConstant* _tmp2085_;
			ValaCCodeConstant* _tmp2086_;
			_tmp2084_ = cinitcall;
			_tmp2085_ = vala_ccode_constant_new ("NULL");
			_tmp2086_ = _tmp2085_;
			vala_ccode_function_call_add_argument (_tmp2084_, (ValaCCodeExpression*) _tmp2086_);
			_vala_ccode_node_unref0 (_tmp2086_);
		}
		_tmp2087_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2088_ = _tmp2087_;
		_tmp2089_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2088_, (ValaCCodeExpression*) _tmp2089_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaUnaryExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp4_ = _arg_list;
			_tmp5_ = vala_list_get (_tmp4_, _arg_index);
			arg = (ValaExpression*) _tmp5_;
			_tmp6_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp6_) : NULL;
			_tmp8_ = unary;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValaUnaryExpression* _tmp10_;
				ValaUnaryOperator _tmp11_;
				ValaUnaryOperator _tmp12_;
				_tmp10_ = unary;
				_tmp11_ = vala_unary_expression_get_operator (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp9_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp13_;
					ValaUnaryOperator _tmp14_;
					ValaUnaryOperator _tmp15_;
					_tmp13_ = unary;
					_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

