/* tree.c generated by valac, the Vala compiler
 * generated from tree.vala, do not modify */

/* tree.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER (valadoc_api_tree_inherit_doc_container_get_type ())
#define VALADOC_API_TREE_INHERIT_DOC_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, ValadocApiTreeInheritDocContainer))
#define VALADOC_API_TREE_INHERIT_DOC_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, ValadocApiTreeInheritDocContainerClass))
#define VALADOC_API_TREE_IS_INHERIT_DOC_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER))
#define VALADOC_API_TREE_IS_INHERIT_DOC_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER))
#define VALADOC_API_TREE_INHERIT_DOC_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, ValadocApiTreeInheritDocContainerClass))

typedef struct _ValadocApiTreeInheritDocContainer ValadocApiTreeInheritDocContainer;
typedef struct _ValadocApiTreeInheritDocContainerClass ValadocApiTreeInheritDocContainerClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_tree_inherit_doc_container_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_inherit_doc_container_unref (var), NULL)))
typedef struct _ValadocApiTreeInheritDocContainerPrivate ValadocApiTreeInheritDocContainerPrivate;
typedef struct _ValadocApiTreeParamSpecInheritDocContainer ValadocApiTreeParamSpecInheritDocContainer;
typedef struct _ValadocApiParamSpecTree ValadocApiParamSpecTree;

struct _ValadocApiTreePrivate {
	ValaList* inheritdocs;
	ValaArrayList* external_c_files;
	ValaArrayList* packages;
	ValadocApiPackage* source_package;
	ValadocSettings* settings;
	ValadocErrorReporter* reporter;
	ValadocHighlighterHighlighter* _highlighter;
	ValadocCTypeResolver* _cresolver;
	ValadocApiPackage* _source_package;
	ValaCodeContext* _context;
	ValadocWikiPageTree* _wikitree;
};

struct _ValadocApiTreeInheritDocContainer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValadocTagletsInheritDoc* taglet;
	ValadocApiNode* taglet_container;
	ValadocApiTreeInheritDocContainerPrivate * priv;
};

struct _ValadocApiTreeInheritDocContainerClass {
	GTypeClass parent_class;
	void (*finalize) (ValadocApiTreeInheritDocContainer *self);
};

struct _ValadocApiTreeParamSpecInheritDocContainer {
	GParamSpec parent_instance;
};

struct _ValadocApiParamSpecTree {
	GParamSpec parent_instance;
};

static gint ValadocApiTree_private_offset;
static gpointer valadoc_api_tree_parent_class = NULL;
static gpointer valadoc_api_tree_inherit_doc_container_parent_class = NULL;

static gpointer valadoc_api_tree_inherit_doc_container_ref (gpointer instance);
static void valadoc_api_tree_inherit_doc_container_unref (gpointer instance);
static GParamSpec* valadoc_api_tree_param_spec_inherit_doc_container (const gchar* name,
                                                               const gchar* nick,
                                                               const gchar* blurb,
                                                               GType object_type,
                                                               GParamFlags flags) G_GNUC_UNUSED;
static void valadoc_api_tree_value_set_inherit_doc_container (GValue* value,
                                                       gpointer v_object) G_GNUC_UNUSED;
static void valadoc_api_tree_value_take_inherit_doc_container (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED;
static gpointer valadoc_api_tree_value_get_inherit_doc_container (const GValue* value) G_GNUC_UNUSED;
static GType valadoc_api_tree_inherit_doc_container_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void valadoc_api_tree_add_dependencies_to_source_package (ValadocApiTree* self);
G_GNUC_INTERNAL void valadoc_api_package_set_dependency_list (ValadocApiPackage* self,
                                              ValaArrayList* list);
static ValadocApiNode* valadoc_api_tree_search_relative_to (ValadocApiTree* self,
                                                     ValadocApiNode* element,
                                                     gchar** path,
                                                     gint path_length1);
static gchar** valadoc_api_tree_split_name (ValadocApiTree* self,
                                     const gchar* full_name,
                                     gint* result_length1);
static gchar* valadoc_api_tree_get_file_path (ValadocApiTree* self,
                                       const gchar* basename,
                                       gchar** directories,
                                       gint directories_length1);
static ValadocApiPackage* valadoc_api_tree_get_source_package (ValadocApiTree* self);
static void valadoc_api_tree_parse_wiki (ValadocApiTree* self,
                                  ValadocDocumentationParser* docparser);
static void valadoc_api_tree_set_wikitree (ValadocApiTree* self,
                                    ValadocWikiPageTree* value);
static void valadoc_api_tree_check_wiki (ValadocApiTree* self,
                                  ValadocDocumentationParser* docparser);
G_GNUC_INTERNAL void valadoc_api_item_parse_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_item_check_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
static void valadoc_api_tree_postprocess_inheritdoc (ValadocApiTree* self,
                                              ValadocDocumentationParser* docparser);
G_GNUC_INTERNAL void valadoc_api_tree_register_inheritdoc (ValadocApiTree* self,
                                           ValadocApiNode* container,
                                           ValadocTagletsInheritDoc* taglet);
static ValadocApiTreeInheritDocContainer* valadoc_api_tree_inherit_doc_container_new (ValadocApiNode* taglet_container,
                                                                               ValadocTagletsInheritDoc* taglet);
static ValadocApiTreeInheritDocContainer* valadoc_api_tree_inherit_doc_container_construct (GType object_type,
                                                                                     ValadocApiNode* taglet_container,
                                                                                     ValadocTagletsInheritDoc* taglet);
static void valadoc_api_tree_inherit_doc_container_finalize (ValadocApiTreeInheritDocContainer * obj);
static void valadoc_api_tree_finalize (ValadocApiTree * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
valadoc_api_tree_get_instance_private (ValadocApiTree* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiTree_private_offset);
}

void
valadoc_api_tree_add_package (ValadocApiTree* self,
                              ValadocApiPackage* package)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = self->priv->packages;
	vala_collection_add ((ValaCollection*) _tmp0_, package);
}

/**
 * Returns a list of C source files.
 *
 * @return list of C source files
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaCollection*
valadoc_api_tree_get_external_c_files (ValadocApiTree* self)
{
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->external_c_files;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
valadoc_api_tree_add_external_c_files (ValadocApiTree* self,
                                       const gchar* name)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->external_c_files;
	vala_collection_add ((ValaCollection*) _tmp0_, name);
}

/**
 * Returns a list of all packages in the tree
 *
 * @return list of all packages
 */
ValaCollection*
valadoc_api_tree_get_package_list (ValadocApiTree* self)
{
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->packages;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
valadoc_api_tree_add_dependencies_to_source_package (ValadocApiTree* self)
{
	ValadocApiPackage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_package;
	if (_tmp0_ != NULL) {
		ValaArrayList* deplst = NULL;
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		ValadocApiPackage* _tmp14_;
		ValaArrayList* _tmp15_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALADOC_API_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
		deplst = _tmp2_;
		{
			ValaArrayList* _pkg_list = NULL;
			ValaArrayList* _tmp3_;
			ValaArrayList* _tmp4_;
			gint _pkg_size = 0;
			ValaArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _pkg_index = 0;
			_tmp3_ = self->priv->packages;
			_tmp4_ = _vala_iterable_ref0 (_tmp3_);
			_pkg_list = _tmp4_;
			_tmp5_ = _pkg_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_pkg_size = _tmp7_;
			_pkg_index = -1;
			while (TRUE) {
				ValadocApiPackage* pkg = NULL;
				ValaArrayList* _tmp8_;
				gpointer _tmp9_;
				ValadocApiPackage* _tmp10_;
				ValadocApiPackage* _tmp11_;
				_pkg_index = _pkg_index + 1;
				if (!(_pkg_index < _pkg_size)) {
					break;
				}
				_tmp8_ = _pkg_list;
				_tmp9_ = vala_list_get ((ValaList*) _tmp8_, _pkg_index);
				pkg = (ValadocApiPackage*) _tmp9_;
				_tmp10_ = pkg;
				_tmp11_ = self->priv->source_package;
				if (_tmp10_ != _tmp11_) {
					ValaArrayList* _tmp12_;
					ValadocApiPackage* _tmp13_;
					_tmp12_ = deplst;
					_tmp13_ = pkg;
					vala_collection_add ((ValaCollection*) _tmp12_, _tmp13_);
				}
				_g_object_unref0 (pkg);
			}
			_vala_iterable_unref0 (_pkg_list);
		}
		_tmp14_ = self->priv->source_package;
		_tmp15_ = deplst;
		valadoc_api_package_set_dependency_list (_tmp14_, _tmp15_);
		_vala_iterable_unref0 (deplst);
	}
}

/**
 * Visits this node with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 */
void
valadoc_api_tree_accept (ValadocApiTree* self,
                         ValadocApiVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	valadoc_api_visitor_visit_tree (visitor, self);
}

/**
 * Visits all children of this node with the given types with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 */
void
valadoc_api_tree_accept_children (ValadocApiTree* self,
                                  ValadocApiVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = self->priv->packages;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			ValadocApiNode* node = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValadocApiNode* _tmp7_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp5_ = _node_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _node_index);
			node = (ValadocApiNode*) ((ValadocApiPackage*) _tmp6_);
			_tmp7_ = node;
			valadoc_api_node_accept (_tmp7_, visitor);
			_g_object_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ValadocApiNode*
valadoc_api_tree_search_relative_to (ValadocApiTree* self,
                                     ValadocApiNode* element,
                                     gchar** path,
                                     gint path_length1)
{
	ValadocApiNode* node = NULL;
	ValadocApiNode* _tmp0_;
	gboolean _tmp6_ = FALSE;
	ValadocApiNode* _tmp7_;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = _g_object_ref0 (element);
	node = _tmp0_;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = path;
		name_collection_length1 = path_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp1_;
			gchar* name = NULL;
			_tmp1_ = g_strdup (name_collection[name_it]);
			name = _tmp1_;
			{
				ValadocApiNode* _tmp2_;
				const gchar* _tmp3_;
				ValadocApiNode* _tmp4_;
				ValadocApiNode* _tmp5_;
				_tmp2_ = node;
				_tmp3_ = name;
				_tmp4_ = valadoc_api_node_find_by_name (_tmp2_, _tmp3_);
				_g_object_unref0 (node);
				node = _tmp4_;
				_tmp5_ = node;
				if (_tmp5_ == NULL) {
					_g_free0 (name);
					break;
				}
				_g_free0 (name);
			}
		}
	}
	_tmp7_ = node;
	if (_tmp7_ == NULL) {
		ValadocApiItem* _tmp8_;
		ValadocApiItem* _tmp9_;
		_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) element);
		_tmp9_ = _tmp8_;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocApiItem* _tmp10_;
		ValadocApiItem* _tmp11_;
		ValadocApiNode* _tmp12_;
		_tmp10_ = valadoc_api_item_get_parent ((ValadocApiItem*) element);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_api_tree_search_relative_to (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALADOC_API_TYPE_NODE, ValadocApiNode), path, (gint) path_length1);
		_g_object_unref0 (node);
		node = _tmp12_;
	}
	result = node;
	return result;
}

ValadocApiNode*
valadoc_api_tree_search_symbol_path (ValadocApiTree* self,
                                     ValadocApiNode* element,
                                     gchar** path,
                                     gint path_length1)
{
	ValadocApiNode* node = NULL;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	node = NULL;
	if (element != NULL) {
		ValadocApiNode* _tmp0_;
		ValadocApiNode* _tmp1_;
		_tmp0_ = valadoc_api_tree_search_relative_to (self, element, path, (gint) path_length1);
		_g_object_unref0 (node);
		node = _tmp0_;
		_tmp1_ = node;
		if (_tmp1_ != NULL) {
			result = node;
			return result;
		}
	}
	{
		ValaArrayList* _package_list = NULL;
		ValaArrayList* _tmp2_;
		ValaArrayList* _tmp3_;
		gint _package_size = 0;
		ValaArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _package_index = 0;
		_tmp2_ = self->priv->packages;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_package_list = _tmp3_;
		_tmp4_ = _package_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_package_size = _tmp6_;
		_package_index = -1;
		while (TRUE) {
			ValadocApiPackage* package = NULL;
			ValaArrayList* _tmp7_;
			gpointer _tmp8_;
			ValadocApiNode* global = NULL;
			ValadocApiPackage* _tmp9_;
			ValadocApiNode* _tmp10_;
			ValadocApiNode* _tmp11_;
			_package_index = _package_index + 1;
			if (!(_package_index < _package_size)) {
				break;
			}
			_tmp7_ = _package_list;
			_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _package_index);
			package = (ValadocApiPackage*) _tmp8_;
			_tmp9_ = package;
			_tmp10_ = valadoc_api_node_find_by_name ((ValadocApiNode*) _tmp9_, "");
			global = _tmp10_;
			_tmp11_ = global;
			if (_tmp11_ != NULL) {
				ValadocApiNode* _tmp12_;
				ValadocApiNode* _tmp13_;
				ValadocApiNode* _tmp14_;
				_tmp12_ = global;
				_tmp13_ = valadoc_api_tree_search_relative_to (self, _tmp12_, path, (gint) path_length1);
				_g_object_unref0 (node);
				node = _tmp13_;
				_tmp14_ = node;
				if (_tmp14_ != NULL) {
					result = node;
					_g_object_unref0 (global);
					_g_object_unref0 (package);
					_vala_iterable_unref0 (_package_list);
					return result;
				}
			}
			_g_object_unref0 (global);
			_g_object_unref0 (package);
		}
		_vala_iterable_unref0 (_package_list);
	}
	result = NULL;
	_g_object_unref0 (node);
	return result;
}

ValadocApiTypeSymbol*
valadoc_api_tree_search_symbol_type_cstr (ValadocApiTree* self,
                                          const gchar* cname)
{
	ValadocCTypeResolver* _tmp0_;
	ValadocCTypeResolver* _tmp2_;
	ValadocApiTypeSymbol* _tmp3_;
	ValadocApiTypeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	_tmp0_ = self->priv->_cresolver;
	if (_tmp0_ == NULL) {
		ValadocCTypeResolver* _tmp1_;
		_tmp1_ = valadoc_ctype_resolver_new (self);
		_g_object_unref0 (self->priv->_cresolver);
		self->priv->_cresolver = _tmp1_;
	}
	_tmp2_ = self->priv->_cresolver;
	_tmp3_ = valadoc_ctype_resolver_resolve_symbol_type (_tmp2_, cname);
	result = _tmp3_;
	return result;
}

ValadocApiNode*
valadoc_api_tree_search_symbol_cstr (ValadocApiTree* self,
                                     ValadocApiNode* element,
                                     const gchar* cname)
{
	ValadocCTypeResolver* _tmp0_;
	ValadocCTypeResolver* _tmp2_;
	ValadocApiNode* _tmp3_;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	_tmp0_ = self->priv->_cresolver;
	if (_tmp0_ == NULL) {
		ValadocCTypeResolver* _tmp1_;
		_tmp1_ = valadoc_ctype_resolver_new (self);
		_g_object_unref0 (self->priv->_cresolver);
		self->priv->_cresolver = _tmp1_;
	}
	_tmp2_ = self->priv->_cresolver;
	_tmp3_ = valadoc_ctype_resolver_resolve_symbol (_tmp2_, element, cname);
	result = _tmp3_;
	return result;
}

ValadocApiNode*
valadoc_api_tree_search_symbol_str (ValadocApiTree* self,
                                    ValadocApiNode* element,
                                    const gchar* symname)
{
	gchar** path = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint path_length1;
	gint _path_size_;
	ValadocApiNode* node = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	ValadocApiNode* _tmp3_;
	ValadocApiNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symname != NULL, NULL);
	_tmp1_ = valadoc_api_tree_split_name (self, symname, &_tmp0_);
	path = _tmp1_;
	path_length1 = _tmp0_;
	_path_size_ = path_length1;
	_tmp2_ = path;
	_tmp2__length1 = path_length1;
	_tmp3_ = valadoc_api_tree_search_symbol_path (self, element, _tmp2_, (gint) _tmp2__length1);
	node = _tmp3_;
	_tmp4_ = node;
	if (_tmp4_ != NULL) {
		result = node;
		path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp6_ = path;
	_tmp6__length1 = path_length1;
	if (_tmp6__length1 >= 2) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		_tmp7_ = path;
		_tmp7__length1 = path_length1;
		_tmp8_ = path;
		_tmp8__length1 = path_length1;
		_tmp9_ = _tmp7_[_tmp8__length1 - 2];
		_tmp10_ = path;
		_tmp10__length1 = path_length1;
		_tmp11_ = path;
		_tmp11__length1 = path_length1;
		_tmp12_ = _tmp10_[_tmp11__length1 - 2];
		_tmp5_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		ValadocApiNode* _tmp27_;
		_tmp13_ = path;
		_tmp13__length1 = path_length1;
		_tmp14_ = path;
		_tmp14__length1 = path_length1;
		_tmp15_ = path;
		_tmp15__length1 = path_length1;
		_tmp16_ = path;
		_tmp16__length1 = path_length1;
		_tmp17_ = _tmp15_[_tmp16__length1 - 2];
		_tmp18_ = g_strconcat (_tmp17_, ".", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = path;
		_tmp20__length1 = path_length1;
		_tmp21_ = path;
		_tmp21__length1 = path_length1;
		_tmp22_ = _tmp20_[_tmp21__length1 - 1];
		_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
		_g_free0 (_tmp13_[_tmp14__length1 - 2]);
		_tmp13_[_tmp14__length1 - 2] = _tmp23_;
		_g_free0 (_tmp19_);
		_tmp24_ = path;
		_tmp24__length1 = path_length1;
		_tmp25_ = _tmp24__length1 - 1;
		path = g_renew (gchar*, path, _tmp24__length1 - 1);
		(_tmp25_ > path_length1) ? memset (path + path_length1, 0, sizeof (gchar*) * (_tmp25_ - path_length1)) : NULL;
		path_length1 = _tmp25_;
		_path_size_ = _tmp25_;
		_tmp26_ = path;
		_tmp26__length1 = path_length1;
		_tmp27_ = valadoc_api_tree_search_symbol_path (self, element, _tmp26_, (gint) _tmp26__length1);
		result = _tmp27_;
		_g_object_unref0 (node);
		path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = NULL;
	_g_object_unref0 (node);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
valadoc_api_tree_split_name (ValadocApiTree* self,
                             const gchar* full_name,
                             gint* result_length1)
{
	gchar** params = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint params_length1;
	gint _params_size_;
	gint i = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (full_name, ".", -1);
	params = _tmp1_;
	params_length1 = _vala_array_length (_tmp0_);
	_params_size_ = params_length1;
	i = 0;
	while (TRUE) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gint _tmp4_;
		_tmp2_ = params;
		_tmp2__length1 = params_length1;
		_tmp3_ = _tmp2_[i];
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = i;
		i = _tmp4_ + 1;
	}
	params_length1 = i;
	_tmp5_ = params;
	_tmp5__length1 = params_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

ValadocApiTree*
valadoc_api_tree_construct (GType object_type,
                            ValadocErrorReporter* reporter,
                            ValadocSettings* settings,
                            ValaCodeContext* context)
{
	ValadocApiTree* self = NULL;
	ValadocSettings* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	g_return_val_if_fail (reporter != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValadocApiTree*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	valadoc_api_tree_set_context (self, context);
	return self;
}

ValadocApiTree*
valadoc_api_tree_new (ValadocErrorReporter* reporter,
                      ValadocSettings* settings,
                      ValaCodeContext* context)
{
	return valadoc_api_tree_construct (VALADOC_API_TYPE_TREE, reporter, settings, context);
}

static gchar*
valadoc_api_tree_get_file_path (ValadocApiTree* self,
                                const gchar* basename,
                                gchar** directories,
                                gint directories_length1)
{
	gchar* filename = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	filename = NULL;
	if (directories != NULL) {
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = directories;
			dir_collection_length1 = directories_length1;
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				gchar* _tmp0_;
				gchar* dir = NULL;
				_tmp0_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp0_;
				{
					const gchar* _tmp1_;
					gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp1_ = dir;
					_tmp2_ = g_build_filename (_tmp1_, basename, NULL);
					_g_free0 (filename);
					filename = _tmp2_;
					_tmp3_ = filename;
					if (g_file_test (_tmp3_, G_FILE_TEST_EXISTS)) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	_tmp5_ = _tmp4_ = g_get_system_data_dirs ();
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp5_;
		dir_collection_length1 = _vala_array_length (_tmp4_);
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp6_;
			gchar* dir = NULL;
			_tmp6_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp6_;
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = dir;
				_tmp8_ = g_build_filename (_tmp7_, basename, NULL);
				_g_free0 (filename);
				filename = _tmp8_;
				_tmp9_ = filename;
				if (g_file_test (_tmp9_, G_FILE_TEST_EXISTS)) {
					result = filename;
					_g_free0 (dir);
					return result;
				}
				_g_free0 (dir);
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}

gboolean
valadoc_api_tree_create_tree (ValadocApiTree* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	valadoc_api_tree_add_dependencies_to_source_package (self);
	result = TRUE;
	return result;
}

static ValadocApiPackage*
valadoc_api_tree_get_source_package (ValadocApiTree* self)
{
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp13_;
	ValadocApiPackage* _tmp14_;
	ValadocApiPackage* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_package;
	if (_tmp0_ == NULL) {
		{
			ValaArrayList* _pkg_list = NULL;
			ValaArrayList* _tmp1_;
			ValaArrayList* _tmp2_;
			gint _pkg_size = 0;
			ValaArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _pkg_index = 0;
			_tmp1_ = self->priv->packages;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_pkg_list = _tmp2_;
			_tmp3_ = _pkg_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_pkg_size = _tmp5_;
			_pkg_index = -1;
			while (TRUE) {
				ValadocApiPackage* pkg = NULL;
				ValaArrayList* _tmp6_;
				gpointer _tmp7_;
				ValadocApiPackage* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_pkg_index = _pkg_index + 1;
				if (!(_pkg_index < _pkg_size)) {
					break;
				}
				_tmp6_ = _pkg_list;
				_tmp7_ = vala_list_get ((ValaList*) _tmp6_, _pkg_index);
				pkg = (ValadocApiPackage*) _tmp7_;
				_tmp8_ = pkg;
				_tmp9_ = valadoc_api_package_get_is_package (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					ValadocApiPackage* _tmp11_;
					ValadocApiPackage* _tmp12_;
					_tmp11_ = pkg;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (self->priv->_source_package);
					self->priv->_source_package = _tmp12_;
					_g_object_unref0 (pkg);
					break;
				}
				_g_object_unref0 (pkg);
			}
			_vala_iterable_unref0 (_pkg_list);
		}
	}
	_tmp13_ = self->priv->_source_package;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	result = _tmp14_;
	return result;
}

static void
valadoc_api_tree_parse_wiki (ValadocApiTree* self,
                             ValadocDocumentationParser* docparser)
{
	ValadocWikiPageTree* _tmp0_;
	ValadocWikiPageTree* _tmp1_;
	ValadocApiPackage* pkg = NULL;
	ValadocApiPackage* _tmp2_;
	ValadocApiPackage* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	_tmp0_ = valadoc_wiki_page_tree_new ();
	_tmp1_ = _tmp0_;
	valadoc_api_tree_set_wikitree (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = valadoc_api_tree_get_source_package (self);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ != NULL) {
		ValadocWikiPageTree* _tmp4_;
		ValadocSettings* _tmp5_;
		ValadocApiPackage* _tmp6_;
		ValadocErrorReporter* _tmp7_;
		_tmp4_ = self->priv->_wikitree;
		_tmp5_ = self->priv->settings;
		_tmp6_ = pkg;
		_tmp7_ = self->priv->reporter;
		valadoc_wiki_page_tree_parse (_tmp4_, _tmp5_, docparser, _tmp6_, _tmp7_);
	}
	_g_object_unref0 (pkg);
}

static void
valadoc_api_tree_check_wiki (ValadocApiTree* self,
                             ValadocDocumentationParser* docparser)
{
	ValadocApiPackage* pkg = NULL;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	_tmp0_ = valadoc_api_tree_get_source_package (self);
	pkg = _tmp0_;
	_tmp1_ = pkg;
	if (_tmp1_ != NULL) {
		ValadocWikiPageTree* _tmp2_;
		ValadocSettings* _tmp3_;
		ValadocApiPackage* _tmp4_;
		_tmp2_ = self->priv->_wikitree;
		_tmp3_ = self->priv->settings;
		_tmp4_ = pkg;
		valadoc_wiki_page_tree_check (_tmp2_, _tmp3_, docparser, _tmp4_);
	}
	_g_object_unref0 (pkg);
}

void
valadoc_api_tree_parse_comments (ValadocApiTree* self,
                                 ValadocDocumentationParser* docparser)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	valadoc_api_tree_parse_wiki (self, docparser);
	{
		ValaArrayList* _pkg_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _pkg_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pkg_index = 0;
		_tmp0_ = self->priv->packages;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_pkg_list = _tmp1_;
		_tmp2_ = _pkg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pkg_size = _tmp4_;
		_pkg_index = -1;
		while (TRUE) {
			ValadocApiPackage* pkg = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValadocApiPackage* _tmp7_;
			ValadocSettings* _tmp8_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp5_ = _pkg_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _pkg_index);
			pkg = (ValadocApiPackage*) _tmp6_;
			_tmp7_ = pkg;
			_tmp8_ = self->priv->settings;
			if (valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp7_, _tmp8_)) {
				ValadocApiPackage* _tmp9_;
				ValadocSettings* _tmp10_;
				_tmp9_ = pkg;
				_tmp10_ = self->priv->settings;
				valadoc_api_item_parse_comments ((ValadocApiItem*) _tmp9_, _tmp10_, docparser);
			}
			_g_object_unref0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
}

void
valadoc_api_tree_check_comments (ValadocApiTree* self,
                                 ValadocDocumentationParser* docparser)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	valadoc_api_tree_check_wiki (self, docparser);
	{
		ValaArrayList* _pkg_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _pkg_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pkg_index = 0;
		_tmp0_ = self->priv->packages;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_pkg_list = _tmp1_;
		_tmp2_ = _pkg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pkg_size = _tmp4_;
		_pkg_index = -1;
		while (TRUE) {
			ValadocApiPackage* pkg = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValadocApiPackage* _tmp7_;
			ValadocSettings* _tmp8_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp5_ = _pkg_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _pkg_index);
			pkg = (ValadocApiPackage*) _tmp6_;
			_tmp7_ = pkg;
			_tmp8_ = self->priv->settings;
			if (valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp7_, _tmp8_)) {
				ValadocApiPackage* _tmp9_;
				ValadocSettings* _tmp10_;
				_tmp9_ = pkg;
				_tmp10_ = self->priv->settings;
				valadoc_api_item_check_comments ((ValadocApiItem*) _tmp9_, _tmp10_, docparser);
				valadoc_api_tree_postprocess_inheritdoc (self, docparser);
			}
			_g_object_unref0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
}

G_GNUC_INTERNAL void
valadoc_api_tree_register_inheritdoc (ValadocApiTree* self,
                                      ValadocApiNode* container,
                                      ValadocTagletsInheritDoc* taglet)
{
	ValaList* _tmp0_;
	ValadocApiTreeInheritDocContainer* _tmp1_;
	ValadocApiTreeInheritDocContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (taglet != NULL);
	_tmp0_ = self->priv->inheritdocs;
	_tmp1_ = valadoc_api_tree_inherit_doc_container_new (container, taglet);
	_tmp2_ = _tmp1_;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp2_);
	_valadoc_api_tree_inherit_doc_container_unref0 (_tmp2_);
}

static void
valadoc_api_tree_postprocess_inheritdoc (ValadocApiTree* self,
                                         ValadocDocumentationParser* docparser)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	while (TRUE) {
		ValaList* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		ValadocApiTreeInheritDocContainer* container = NULL;
		ValaList* _tmp3_;
		gpointer _tmp4_;
		ValadocApiTreeInheritDocContainer* _tmp5_;
		ValadocApiNode* _tmp6_;
		ValadocApiTreeInheritDocContainer* _tmp7_;
		ValadocTagletsInheritDoc* _tmp8_;
		_tmp0_ = self->priv->inheritdocs;
		_tmp1_ = vala_collection_get_is_empty ((ValaCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		if (!(!_tmp2_)) {
			break;
		}
		_tmp3_ = self->priv->inheritdocs;
		_tmp4_ = vala_list_remove_at (_tmp3_, 0);
		container = (ValadocApiTreeInheritDocContainer*) _tmp4_;
		_tmp5_ = container;
		_tmp6_ = _tmp5_->taglet_container;
		_tmp7_ = container;
		_tmp8_ = _tmp7_->taglet;
		valadoc_documentation_parser_transform_inheritdoc (docparser, _tmp6_, _tmp8_);
		_valadoc_api_tree_inherit_doc_container_unref0 (container);
	}
}

/**
 * Import documentation from various sources
 *
 * @param importers a list of importers
 * @param packages sources
 * @param import_directories List of directories where to find the files
 */
void
valadoc_api_tree_import_comments (ValadocApiTree* self,
                                  ValadocImporterDocumentationImporter** importers,
                                  gint importers_length1,
                                  gchar** packages,
                                  gint packages_length1,
                                  gchar** import_directories,
                                  gint import_directories_length1)
{
	ValaHashSet* processed = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	processed = _tmp2_;
	{
		gchar** pkg_name_collection = NULL;
		gint pkg_name_collection_length1 = 0;
		gint _pkg_name_collection_size_ = 0;
		gint pkg_name_it = 0;
		pkg_name_collection = packages;
		pkg_name_collection_length1 = packages_length1;
		for (pkg_name_it = 0; pkg_name_it < pkg_name_collection_length1; pkg_name_it = pkg_name_it + 1) {
			gchar* _tmp3_;
			gchar* pkg_name = NULL;
			_tmp3_ = g_strdup (pkg_name_collection[pkg_name_it]);
			pkg_name = _tmp3_;
			{
				gboolean imported = FALSE;
				imported = FALSE;
				{
					ValadocImporterDocumentationImporter** importer_collection = NULL;
					gint importer_collection_length1 = 0;
					gint _importer_collection_size_ = 0;
					gint importer_it = 0;
					importer_collection = importers;
					importer_collection_length1 = importers_length1;
					for (importer_it = 0; importer_it < importer_collection_length1; importer_it = importer_it + 1) {
						ValadocImporterDocumentationImporter* _tmp4_;
						ValadocImporterDocumentationImporter* importer = NULL;
						_tmp4_ = _g_object_ref0 (importer_collection[importer_it]);
						importer = _tmp4_;
						{
							gchar* path = NULL;
							const gchar* _tmp5_;
							ValadocImporterDocumentationImporter* _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							const gchar* _tmp13_;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							ValaHashSet* _tmp16_;
							const gchar* _tmp17_;
							_tmp5_ = pkg_name;
							_tmp6_ = importer;
							_tmp7_ = valadoc_importer_documentation_importer_get_file_extension (_tmp6_);
							_tmp8_ = _tmp7_;
							_tmp9_ = g_strdup_printf ("%s.%s", _tmp5_, _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = valadoc_api_tree_get_file_path (self, _tmp10_, import_directories, (gint) import_directories_length1);
							_tmp12_ = _tmp11_;
							_g_free0 (_tmp10_);
							path = _tmp12_;
							_tmp13_ = path;
							if (_tmp13_ == NULL) {
								_g_free0 (path);
								_g_object_unref0 (importer);
								continue;
							}
							_tmp14_ = path;
							_tmp15_ = vala_code_context_realpath (_tmp14_);
							_g_free0 (path);
							path = _tmp15_;
							imported = TRUE;
							_tmp16_ = processed;
							_tmp17_ = path;
							if (!vala_collection_contains ((ValaCollection*) _tmp16_, _tmp17_)) {
								ValadocImporterDocumentationImporter* _tmp18_;
								const gchar* _tmp19_;
								ValaHashSet* _tmp20_;
								const gchar* _tmp21_;
								_tmp18_ = importer;
								_tmp19_ = path;
								valadoc_importer_documentation_importer_process (_tmp18_, _tmp19_);
								_tmp20_ = processed;
								_tmp21_ = path;
								vala_collection_add ((ValaCollection*) _tmp20_, _tmp21_);
							}
							_g_free0 (path);
							_g_object_unref0 (importer);
						}
					}
				}
				if (imported == FALSE) {
					ValadocErrorReporter* _tmp22_;
					const gchar* _tmp23_;
					_tmp22_ = self->priv->reporter;
					_tmp23_ = pkg_name;
					valadoc_error_reporter_simple_error (_tmp22_, NULL, "'%s' not found in specified import directories", _tmp23_);
				}
				_g_free0 (pkg_name);
			}
		}
	}
	_vala_iterable_unref0 (processed);
}

ValaCodeContext*
valadoc_api_tree_get_context (ValadocApiTree* self)
{
	ValaCodeContext* result;
	ValaCodeContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

void
valadoc_api_tree_set_context (ValadocApiTree* self,
                              ValaCodeContext* value)
{
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_context_ref0 (value);
	_vala_code_context_unref0 (self->priv->_context);
	self->priv->_context = _tmp0_;
}

ValadocHighlighterHighlighter*
valadoc_api_tree_get_highlighter (ValadocApiTree* self)
{
	ValadocHighlighterHighlighter* result;
	ValadocHighlighterHighlighter* _tmp0_;
	ValadocHighlighterHighlighter* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_highlighter;
	if (_tmp0_ == NULL) {
		ValadocHighlighterHighlighter* _tmp1_;
		_tmp1_ = valadoc_highlighter_highlighter_new ();
		_g_object_unref0 (self->priv->_highlighter);
		self->priv->_highlighter = _tmp1_;
	}
	_tmp2_ = self->priv->_highlighter;
	result = _tmp2_;
	return result;
}

ValadocWikiPageTree*
valadoc_api_tree_get_wikitree (ValadocApiTree* self)
{
	ValadocWikiPageTree* result;
	ValadocWikiPageTree* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wikitree;
	result = _tmp0_;
	return result;
}

static void
valadoc_api_tree_set_wikitree (ValadocApiTree* self,
                               ValadocWikiPageTree* value)
{
	ValadocWikiPageTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_wikitree);
	self->priv->_wikitree = _tmp0_;
}

static ValadocApiTreeInheritDocContainer*
valadoc_api_tree_inherit_doc_container_construct (GType object_type,
                                                  ValadocApiNode* taglet_container,
                                                  ValadocTagletsInheritDoc* taglet)
{
	ValadocApiTreeInheritDocContainer* self = NULL;
	g_return_val_if_fail (taglet_container != NULL, NULL);
	g_return_val_if_fail (taglet != NULL, NULL);
	self = (ValadocApiTreeInheritDocContainer*) g_type_create_instance (object_type);
	self->taglet_container = taglet_container;
	self->taglet = taglet;
	return self;
}

static ValadocApiTreeInheritDocContainer*
valadoc_api_tree_inherit_doc_container_new (ValadocApiNode* taglet_container,
                                            ValadocTagletsInheritDoc* taglet)
{
	return valadoc_api_tree_inherit_doc_container_construct (VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, taglet_container, taglet);
}

static void
valadoc_api_tree_value_inherit_doc_container_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
valadoc_api_tree_value_inherit_doc_container_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_api_tree_inherit_doc_container_unref (value->data[0].v_pointer);
	}
}

static void
valadoc_api_tree_value_inherit_doc_container_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_api_tree_inherit_doc_container_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
valadoc_api_tree_value_inherit_doc_container_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
valadoc_api_tree_value_inherit_doc_container_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocApiTreeInheritDocContainer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_api_tree_inherit_doc_container_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
valadoc_api_tree_value_inherit_doc_container_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	ValadocApiTreeInheritDocContainer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_api_tree_inherit_doc_container_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
valadoc_api_tree_param_spec_inherit_doc_container (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	ValadocApiTreeParamSpecInheritDocContainer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
valadoc_api_tree_value_get_inherit_doc_container (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER), NULL);
	return value->data[0].v_pointer;
}

static void
valadoc_api_tree_value_set_inherit_doc_container (GValue* value,
                                                  gpointer v_object)
{
	ValadocApiTreeInheritDocContainer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_api_tree_inherit_doc_container_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_api_tree_inherit_doc_container_unref (old);
	}
}

static void
valadoc_api_tree_value_take_inherit_doc_container (GValue* value,
                                                   gpointer v_object)
{
	ValadocApiTreeInheritDocContainer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_api_tree_inherit_doc_container_unref (old);
	}
}

static void
valadoc_api_tree_inherit_doc_container_class_init (ValadocApiTreeInheritDocContainerClass * klass,
                                                   gpointer klass_data)
{
	valadoc_api_tree_inherit_doc_container_parent_class = g_type_class_peek_parent (klass);
	((ValadocApiTreeInheritDocContainerClass *) klass)->finalize = valadoc_api_tree_inherit_doc_container_finalize;
}

static void
valadoc_api_tree_inherit_doc_container_instance_init (ValadocApiTreeInheritDocContainer * self,
                                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
valadoc_api_tree_inherit_doc_container_finalize (ValadocApiTreeInheritDocContainer * obj)
{
	ValadocApiTreeInheritDocContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, ValadocApiTreeInheritDocContainer);
	g_signal_handlers_destroy (self);
}

static GType
valadoc_api_tree_inherit_doc_container_get_type (void)
{
	static volatile gsize valadoc_api_tree_inherit_doc_container_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_tree_inherit_doc_container_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_api_tree_value_inherit_doc_container_init, valadoc_api_tree_value_inherit_doc_container_free_value, valadoc_api_tree_value_inherit_doc_container_copy_value, valadoc_api_tree_value_inherit_doc_container_peek_pointer, "p", valadoc_api_tree_value_inherit_doc_container_collect_value, "p", valadoc_api_tree_value_inherit_doc_container_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiTreeInheritDocContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_tree_inherit_doc_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiTreeInheritDocContainer), 0, (GInstanceInitFunc) valadoc_api_tree_inherit_doc_container_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_api_tree_inherit_doc_container_type_id;
		valadoc_api_tree_inherit_doc_container_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocApiTreeInheritDocContainer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_api_tree_inherit_doc_container_type_id__volatile, valadoc_api_tree_inherit_doc_container_type_id);
	}
	return valadoc_api_tree_inherit_doc_container_type_id__volatile;
}

static gpointer
valadoc_api_tree_inherit_doc_container_ref (gpointer instance)
{
	ValadocApiTreeInheritDocContainer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
valadoc_api_tree_inherit_doc_container_unref (gpointer instance)
{
	ValadocApiTreeInheritDocContainer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_API_TREE_INHERIT_DOC_CONTAINER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
valadoc_api_value_tree_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
valadoc_api_value_tree_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_api_tree_unref (value->data[0].v_pointer);
	}
}

static void
valadoc_api_value_tree_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_api_tree_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
valadoc_api_value_tree_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
valadoc_api_value_tree_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocApiTree * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_api_tree_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
valadoc_api_value_tree_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	ValadocApiTree ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_api_tree_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
valadoc_api_param_spec_tree (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ValadocApiParamSpecTree* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_API_TYPE_TREE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
valadoc_api_value_get_tree (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TYPE_TREE), NULL);
	return value->data[0].v_pointer;
}

void
valadoc_api_value_set_tree (GValue* value,
                            gpointer v_object)
{
	ValadocApiTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TYPE_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_API_TYPE_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_api_tree_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_api_tree_unref (old);
	}
}

void
valadoc_api_value_take_tree (GValue* value,
                             gpointer v_object)
{
	ValadocApiTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_API_TYPE_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_API_TYPE_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_api_tree_unref (old);
	}
}

static void
valadoc_api_tree_class_init (ValadocApiTreeClass * klass,
                             gpointer klass_data)
{
	valadoc_api_tree_parent_class = g_type_class_peek_parent (klass);
	((ValadocApiTreeClass *) klass)->finalize = valadoc_api_tree_finalize;
	g_type_class_adjust_private_offset (klass, &ValadocApiTree_private_offset);
}

static void
valadoc_api_tree_instance_init (ValadocApiTree * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = valadoc_api_tree_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TREE_TYPE_INHERIT_DOC_CONTAINER, (GBoxedCopyFunc) valadoc_api_tree_inherit_doc_container_ref, (GDestroyNotify) valadoc_api_tree_inherit_doc_container_unref, _tmp0_);
	self->priv->inheritdocs = (ValaList*) _tmp1_;
	_tmp2_ = g_str_equal;
	_tmp3_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_);
	self->priv->external_c_files = _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALADOC_API_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_);
	self->priv->packages = _tmp5_;
	self->priv->source_package = NULL;
	self->priv->_cresolver = NULL;
	self->ref_count = 1;
}

static void
valadoc_api_tree_finalize (ValadocApiTree * obj)
{
	ValadocApiTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_TREE, ValadocApiTree);
	g_signal_handlers_destroy (self);
	_vala_iterable_unref0 (self->priv->inheritdocs);
	_vala_iterable_unref0 (self->priv->external_c_files);
	_vala_iterable_unref0 (self->priv->packages);
	_g_object_unref0 (self->priv->source_package);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->_highlighter);
	_g_object_unref0 (self->priv->_cresolver);
	_g_object_unref0 (self->priv->_source_package);
	_vala_code_context_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->_wikitree);
}

/**
 * The root of the code tree.
 */
GType
valadoc_api_tree_get_type (void)
{
	static volatile gsize valadoc_api_tree_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_api_value_tree_init, valadoc_api_value_tree_free_value, valadoc_api_value_tree_copy_value, valadoc_api_value_tree_peek_pointer, "p", valadoc_api_value_tree_collect_value, "p", valadoc_api_value_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiTree), 0, (GInstanceInitFunc) valadoc_api_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_api_tree_type_id;
		valadoc_api_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocApiTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValadocApiTree_private_offset = g_type_add_instance_private (valadoc_api_tree_type_id, sizeof (ValadocApiTreePrivate));
		g_once_init_leave (&valadoc_api_tree_type_id__volatile, valadoc_api_tree_type_id);
	}
	return valadoc_api_tree_type_id__volatile;
}

gpointer
valadoc_api_tree_ref (gpointer instance)
{
	ValadocApiTree * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
valadoc_api_tree_unref (gpointer instance)
{
	ValadocApiTree * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_API_TREE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

