/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp531_ = FALSE;
	gboolean _tmp532_ = FALSE;
	gboolean _tmp533_ = FALSE;
	ValaExpression* _tmp534_;
	ValaExpression* _tmp535_;
	ValaSymbol* _tmp561_;
	ValaSymbol* _tmp562_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp585_;
	ValaSymbol* _tmp586_;
	ValaSymbol* _tmp587_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp588_;
	ValaSymbol* _tmp589_;
	ValaSymbol* _tmp1011_;
	ValaSymbol* _tmp1012_;
	ValaVersionAttribute* _tmp1013_;
	ValaVersionAttribute* _tmp1014_;
	ValaSourceReference* _tmp1015_;
	ValaSourceReference* _tmp1016_;
	gboolean _tmp1017_ = FALSE;
	ValaSymbolAccessibility _tmp1018_;
	gboolean _tmp1077_ = FALSE;
	gboolean _tmp1108_ = FALSE;
	gboolean _tmp1109_ = FALSE;
	ValaDataType* _tmp1364_;
	ValaDataType* _tmp1365_;
	gboolean _tmp1368_;
	gboolean _tmp1369_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaScope* _tmp170_;
						ValaScope* _tmp171_;
						const gchar* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaSymbol* _tmp174_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_using_directive_get_namespace_symbol (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = vala_symbol_get_scope (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = self->priv->_member_name;
						_tmp173_ = vala_scope_lookup (_tmp171_, _tmp172_);
						local_sym = _tmp173_;
						_tmp174_ = local_sym;
						if (_tmp174_ != NULL) {
							gboolean _tmp175_ = FALSE;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp193_;
							_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp177_ = _tmp176_;
							if (_tmp177_ != NULL) {
								ValaSymbol* _tmp178_;
								ValaSymbol* _tmp179_;
								ValaSymbol* _tmp180_;
								_tmp178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp179_ = _tmp178_;
								_tmp180_ = local_sym;
								_tmp175_ = _tmp179_ != _tmp180_;
							} else {
								_tmp175_ = FALSE;
							}
							if (_tmp175_) {
								ValaSourceReference* _tmp181_;
								ValaSourceReference* _tmp182_;
								const gchar* _tmp183_;
								ValaSymbol* _tmp184_;
								ValaSymbol* _tmp185_;
								gchar* _tmp186_;
								gchar* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								gchar* _tmp191_;
								gchar* _tmp192_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = self->priv->_member_name;
								_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_symbol_get_full_name (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = local_sym;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp183_, _tmp187_, _tmp190_);
								_tmp192_ = _tmp191_;
								vala_report_error (_tmp182_, _tmp192_);
								_g_free0 (_tmp192_);
								_g_free0 (_tmp190_);
								_g_free0 (_tmp187_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp193_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp194_;
			ValaExpression* _tmp195_;
			gboolean _tmp196_;
			gboolean _tmp197_;
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			ValaDataType* _tmp200_;
			ValaDataType* _tmp201_;
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			gboolean _tmp237_ = FALSE;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			gboolean _tmp261_ = FALSE;
			ValaSymbol* _tmp262_;
			ValaSymbol* _tmp263_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_ = FALSE;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp513_ = FALSE;
			ValaSymbol* _tmp514_;
			ValaSymbol* _tmp515_;
			_tmp194_ = vala_member_access_get_inner (self);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp198_ = vala_member_access_get_inner (self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_expression_get_value_type (_tmp199_);
			_tmp201_ = _tmp200_;
			if (VALA_IS_POINTER_TYPE (_tmp201_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaPointerType* _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaPointerType* _tmp208_;
				_tmp202_ = vala_member_access_get_inner (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp205_) ? ((ValaPointerType*) _tmp205_) : NULL);
				pointer_type = _tmp206_;
				_tmp208_ = pointer_type;
				if (_tmp208_ != NULL) {
					ValaPointerType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					_tmp209_ = pointer_type;
					_tmp210_ = vala_pointer_type_get_base_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp207_ = VALA_IS_VALUE_TYPE (_tmp211_);
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaPointerIndirection* _tmp216_;
					ValaPointerIndirection* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					_tmp212_ = vala_member_access_get_inner (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_pointer_indirection_new (_tmp213_, _tmp215_);
					_tmp217_ = _tmp216_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_member_access_get_inner (self);
					_tmp219_ = _tmp218_;
					vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp220_ = vala_member_access_get_inner (self);
			_tmp221_ = _tmp220_;
			if (VALA_IS_MEMBER_ACCESS (_tmp221_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaMemberAccess* _tmp224_;
				ValaMemberAccess* _tmp225_;
				gboolean _tmp226_;
				_tmp222_ = vala_member_access_get_inner (self);
				_tmp223_ = _tmp222_;
				_tmp224_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp224_;
				_tmp225_ = ma;
				_tmp226_ = _tmp225_->priv->_prototype_access;
				if (_tmp226_) {
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSymbol* _tmp231_;
					ValaSymbol* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					gchar* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_symbol_get_full_name (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp234_);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp228_, _tmp236_);
					_g_free0 (_tmp236_);
					_g_free0 (_tmp234_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp238_ = vala_member_access_get_inner (self);
			_tmp239_ = _tmp238_;
			if (VALA_IS_MEMBER_ACCESS (_tmp239_)) {
				_tmp237_ = TRUE;
			} else {
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				_tmp240_ = vala_member_access_get_inner (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = VALA_IS_BASE_ACCESS (_tmp241_);
			}
			if (_tmp237_) {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				ValaSymbol* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				gboolean _tmp247_ = FALSE;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = vala_member_access_get_inner (self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = _vala_code_node_ref0 (_tmp245_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp246_;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp249_ = _tmp248_;
				if (_tmp249_ == NULL) {
					gboolean _tmp250_ = FALSE;
					ValaSymbol* _tmp251_;
					_tmp251_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp251_)) {
						_tmp250_ = TRUE;
					} else {
						ValaSymbol* _tmp252_;
						_tmp252_ = base_symbol;
						_tmp250_ = VALA_IS_TYPESYMBOL (_tmp252_);
					}
					_tmp247_ = _tmp250_;
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
					ValaSymbol* _tmp253_;
					ValaScope* _tmp254_;
					ValaScope* _tmp255_;
					const gchar* _tmp256_;
					ValaSymbol* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaExpression* _tmp259_;
					ValaExpression* _tmp260_;
					_tmp253_ = base_symbol;
					_tmp254_ = vala_symbol_get_scope (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = self->priv->_member_name;
					_tmp257_ = vala_scope_lookup (_tmp255_, _tmp256_);
					_tmp258_ = _tmp257_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp258_);
					_vala_code_node_unref0 (_tmp258_);
					_tmp259_ = vala_member_access_get_inner (self);
					_tmp260_ = _tmp259_;
					if (VALA_IS_BASE_ACCESS (_tmp260_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp263_ = _tmp262_;
			if (_tmp263_ == NULL) {
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				_tmp264_ = vala_member_access_get_inner (self);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_expression_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp261_ = _tmp267_ != NULL;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				gboolean _tmp268_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				_tmp268_ = self->priv->_pointer_member_access;
				if (_tmp268_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					const gchar* _tmp273_;
					ValaSymbol* _tmp274_;
					ValaSymbol* _tmp275_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = self->priv->_member_name;
					_tmp274_ = vala_data_type_get_pointer_member (_tmp272_, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp275_);
					_vala_code_node_unref0 (_tmp275_);
				} else {
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaTypeSymbol* _tmp280_;
					ValaTypeSymbol* _tmp281_;
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					_tmp276_ = vala_member_access_get_inner (self);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_value_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_data_type_get_data_type (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ != NULL) {
						ValaExpression* _tmp282_;
						ValaExpression* _tmp283_;
						ValaDataType* _tmp284_;
						ValaDataType* _tmp285_;
						ValaTypeSymbol* _tmp286_;
						ValaTypeSymbol* _tmp287_;
						ValaSymbol* _tmp288_;
						_tmp282_ = vala_member_access_get_inner (self);
						_tmp283_ = _tmp282_;
						_tmp284_ = vala_expression_get_value_type (_tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_data_type_get_data_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp287_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp288_;
					}
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_data_type_get_member (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
				}
				_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp297_ = _tmp296_;
				if (_tmp297_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp301_ = _tmp300_;
			if (_tmp301_ == NULL) {
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				_tmp302_ = vala_member_access_get_inner (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp299_ = _tmp305_ != NULL;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_expression_get_value_type (_tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_get_is_dynamic (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp298_ = _tmp311_;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaObjectType* _tmp316_;
				ValaCodeNode* _tmp317_;
				ValaCodeNode* _tmp318_;
				ValaSymbol* _tmp461_;
				ValaSymbol* _tmp462_;
				ValaSymbol* _tmp511_;
				ValaSymbol* _tmp512_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp316_;
				_tmp317_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				if (VALA_IS_METHOD_CALL (_tmp318_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp319_;
					ValaCodeNode* _tmp320_;
					ValaMethodCall* _tmp321_;
					ValaMethodCall* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp319_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp321_;
					_tmp322_ = invoc;
					_tmp323_ = vala_method_call_get_call (_tmp322_);
					_tmp324_ = _tmp323_;
					if (_tmp324_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp342_;
						ValaExpression* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						const gchar* _tmp346_;
						ValaDataType* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						ValaDynamicMethod* _tmp350_;
						ValaDynamicMethod* _tmp351_;
						ValaMethodCall* _tmp352_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp353_;
						ValaErrorType* _tmp354_;
						ValaDynamicMethod* _tmp355_;
						ValaErrorType* _tmp356_;
						ValaDynamicMethod* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaParameter* _tmp359_;
						ValaParameter* _tmp360_;
						ValaObjectType* _tmp361_;
						ValaObjectTypeSymbol* _tmp362_;
						ValaObjectTypeSymbol* _tmp363_;
						ValaScope* _tmp364_;
						ValaScope* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						_tmp325_ = invoc;
						_tmp326_ = vala_expression_get_target_type ((ValaExpression*) _tmp325_);
						_tmp327_ = _tmp326_;
						if (_tmp327_ != NULL) {
							ValaMethodCall* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							ValaDataType* _tmp331_;
							ValaDataType* _tmp332_;
							_tmp328_ = invoc;
							_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = vala_data_type_copy (_tmp330_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp331_;
							_tmp332_ = ret_type;
							vala_data_type_set_value_owned (_tmp332_, TRUE);
						} else {
							ValaMethodCall* _tmp333_;
							ValaCodeNode* _tmp334_;
							ValaCodeNode* _tmp335_;
							_tmp333_ = invoc;
							_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp335_)) {
								ValaVoidType* _tmp336_;
								_tmp336_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp336_;
							} else {
								ValaExpression* _tmp337_;
								ValaExpression* _tmp338_;
								ValaDataType* _tmp339_;
								ValaDataType* _tmp340_;
								ValaDataType* _tmp341_;
								_tmp337_ = vala_member_access_get_inner (self);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_expression_get_value_type (_tmp338_);
								_tmp340_ = _tmp339_;
								_tmp341_ = vala_data_type_copy (_tmp340_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp341_;
							}
						}
						_tmp342_ = vala_member_access_get_inner (self);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_expression_get_value_type (_tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = self->priv->_member_name;
						_tmp347_ = ret_type;
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_dynamic_method_new (_tmp345_, _tmp346_, _tmp347_, _tmp349_, NULL);
						m = _tmp350_;
						_tmp351_ = m;
						_tmp352_ = invoc;
						vala_dynamic_method_set_invocation (_tmp351_, _tmp352_);
						_tmp353_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp353_;
						_tmp354_ = err;
						vala_error_type_set_dynamic_error (_tmp354_, TRUE);
						_tmp355_ = m;
						_tmp356_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp355_, (ValaDataType*) _tmp356_);
						_tmp357_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp357_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp358_ = m;
						_tmp359_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp360_ = _tmp359_;
						vala_callable_add_parameter ((ValaCallable*) _tmp358_, _tmp360_);
						_vala_code_node_unref0 (_tmp360_);
						_tmp361_ = dynamic_object_type;
						_tmp362_ = vala_object_type_get_type_symbol (_tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_symbol_get_scope ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = m;
						vala_scope_add (_tmp365_, NULL, (ValaSymbol*) _tmp366_);
						_tmp367_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp367_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp368_;
					ValaCodeNode* _tmp369_;
					_tmp368_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp369_ = _tmp368_;
					if (VALA_IS_ASSIGNMENT (_tmp369_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp370_;
						ValaCodeNode* _tmp371_;
						ValaAssignment* _tmp372_;
						ValaAssignment* _tmp373_;
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						_tmp370_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp371_ = _tmp370_;
						_tmp372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp372_;
						_tmp373_ = a;
						_tmp374_ = vala_assignment_get_left (_tmp373_);
						_tmp375_ = _tmp374_;
						if (_tmp375_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp376_;
							ValaExpression* _tmp377_;
							ValaDataType* _tmp378_;
							ValaDataType* _tmp379_;
							const gchar* _tmp380_;
							ValaSourceReference* _tmp381_;
							ValaSourceReference* _tmp382_;
							ValaDynamicProperty* _tmp383_;
							ValaDynamicProperty* _tmp384_;
							ValaDynamicProperty* _tmp385_;
							ValaDynamicProperty* _tmp386_;
							ValaSourceReference* _tmp387_;
							ValaSourceReference* _tmp388_;
							ValaPropertyAccessor* _tmp389_;
							ValaPropertyAccessor* _tmp390_;
							ValaDynamicProperty* _tmp391_;
							ValaExpression* _tmp392_;
							ValaExpression* _tmp393_;
							ValaDataType* _tmp394_;
							ValaDataType* _tmp395_;
							ValaTypeSymbol* _tmp396_;
							ValaTypeSymbol* _tmp397_;
							ValaScope* _tmp398_;
							ValaScope* _tmp399_;
							ValaObjectType* _tmp400_;
							ValaObjectTypeSymbol* _tmp401_;
							ValaObjectTypeSymbol* _tmp402_;
							ValaScope* _tmp403_;
							ValaScope* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaDynamicProperty* _tmp406_;
							_tmp376_ = vala_member_access_get_inner (self);
							_tmp377_ = _tmp376_;
							_tmp378_ = vala_expression_get_value_type (_tmp377_);
							_tmp379_ = _tmp378_;
							_tmp380_ = self->priv->_member_name;
							_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp382_ = _tmp381_;
							_tmp383_ = vala_dynamic_property_new (_tmp379_, _tmp380_, _tmp382_, NULL);
							prop = _tmp383_;
							_tmp384_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp384_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp385_ = prop;
							_tmp386_ = prop;
							_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp386_);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp388_, NULL);
							_tmp390_ = _tmp389_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp385_, _tmp390_);
							_vala_code_node_unref0 (_tmp390_);
							_tmp391_ = prop;
							_tmp392_ = vala_member_access_get_inner (self);
							_tmp393_ = _tmp392_;
							_tmp394_ = vala_expression_get_value_type (_tmp393_);
							_tmp395_ = _tmp394_;
							_tmp396_ = vala_data_type_get_data_type (_tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = vala_symbol_get_scope ((ValaSymbol*) _tmp397_);
							_tmp399_ = _tmp398_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp391_, _tmp399_);
							_tmp400_ = dynamic_object_type;
							_tmp401_ = vala_object_type_get_type_symbol (_tmp400_);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_symbol_get_scope ((ValaSymbol*) _tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = prop;
							vala_scope_add (_tmp404_, NULL, (ValaSymbol*) _tmp405_);
							_tmp406_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp406_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp407_ = FALSE;
						gboolean _tmp408_ = FALSE;
						ValaCodeNode* _tmp409_;
						ValaCodeNode* _tmp410_;
						_tmp409_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp410_ = _tmp409_;
						if (VALA_IS_MEMBER_ACCESS (_tmp410_)) {
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp408_ = VALA_IS_MEMBER_ACCESS (_tmp412_);
						} else {
							_tmp408_ = FALSE;
						}
						if (_tmp408_) {
							ValaCodeNode* _tmp413_;
							ValaCodeNode* _tmp414_;
							ValaCodeNode* _tmp415_;
							ValaCodeNode* _tmp416_;
							_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_code_node_get_parent_node (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp407_ = VALA_IS_METHOD_CALL (_tmp416_);
						} else {
							_tmp407_ = FALSE;
						}
						if (_tmp407_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp417_;
							ValaCodeNode* _tmp418_;
							ValaMemberAccess* _tmp419_;
							gboolean _tmp420_ = FALSE;
							ValaMemberAccess* _tmp421_;
							const gchar* _tmp422_;
							_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp418_ = _tmp417_;
							_tmp419_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp418_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp419_;
							_tmp421_ = ma;
							_tmp422_ = _tmp421_->priv->_member_name;
							if (g_strcmp0 (_tmp422_, "connect") == 0) {
								_tmp420_ = TRUE;
							} else {
								ValaMemberAccess* _tmp423_;
								const gchar* _tmp424_;
								_tmp423_ = ma;
								_tmp424_ = _tmp423_->priv->_member_name;
								_tmp420_ = g_strcmp0 (_tmp424_, "connect_after") == 0;
							}
							if (_tmp420_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp425_;
								ValaExpression* _tmp426_;
								ValaDataType* _tmp427_;
								ValaDataType* _tmp428_;
								const gchar* _tmp429_;
								ValaVoidType* _tmp430_;
								ValaVoidType* _tmp431_;
								ValaSourceReference* _tmp432_;
								ValaSourceReference* _tmp433_;
								ValaDynamicSignal* _tmp434_;
								ValaDynamicSignal* _tmp435_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp436_;
								ValaCodeNode* _tmp437_;
								ValaCodeNode* _tmp438_;
								ValaCodeNode* _tmp439_;
								ValaMethodCall* _tmp440_;
								ValaMethodCall* _tmp441_;
								ValaList* _tmp442_;
								ValaList* _tmp443_;
								gint _tmp444_;
								gint _tmp445_;
								gboolean _tmp446_;
								ValaDynamicSignal* _tmp453_;
								ValaObjectType* _tmp454_;
								ValaObjectTypeSymbol* _tmp455_;
								ValaObjectTypeSymbol* _tmp456_;
								ValaScope* _tmp457_;
								ValaScope* _tmp458_;
								ValaDynamicSignal* _tmp459_;
								ValaDynamicSignal* _tmp460_;
								_tmp425_ = vala_member_access_get_inner (self);
								_tmp426_ = _tmp425_;
								_tmp427_ = vala_expression_get_value_type (_tmp426_);
								_tmp428_ = _tmp427_;
								_tmp429_ = self->priv->_member_name;
								_tmp430_ = vala_void_type_new (NULL);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_dynamic_signal_new (_tmp428_, _tmp429_, (ValaDataType*) _tmp431_, _tmp433_, NULL);
								_tmp435_ = _tmp434_;
								_vala_code_node_unref0 (_tmp431_);
								s = _tmp435_;
								_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_code_node_get_parent_node (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp440_;
								_tmp441_ = mcall;
								_tmp442_ = vala_method_call_get_argument_list (_tmp441_);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
								_tmp445_ = _tmp444_;
								_tmp446_ = _tmp445_ > 0;
								_vala_iterable_unref0 (_tmp443_);
								if (_tmp446_) {
									ValaDynamicSignal* _tmp447_;
									ValaMethodCall* _tmp448_;
									ValaList* _tmp449_;
									ValaList* _tmp450_;
									gpointer _tmp451_;
									ValaExpression* _tmp452_;
									_tmp447_ = s;
									_tmp448_ = mcall;
									_tmp449_ = vala_method_call_get_argument_list (_tmp448_);
									_tmp450_ = _tmp449_;
									_tmp451_ = vala_list_get (_tmp450_, 0);
									_tmp452_ = (ValaExpression*) _tmp451_;
									vala_dynamic_signal_set_handler (_tmp447_, _tmp452_);
									_vala_code_node_unref0 (_tmp452_);
									_vala_iterable_unref0 (_tmp450_);
								}
								_tmp453_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp454_ = dynamic_object_type;
								_tmp455_ = vala_object_type_get_type_symbol (_tmp454_);
								_tmp456_ = _tmp455_;
								_tmp457_ = vala_symbol_get_scope ((ValaSymbol*) _tmp456_);
								_tmp458_ = _tmp457_;
								_tmp459_ = s;
								vala_scope_add (_tmp458_, NULL, (ValaSymbol*) _tmp459_);
								_tmp460_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp460_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp462_ = _tmp461_;
				if (_tmp462_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp463_;
					ValaExpression* _tmp464_;
					ValaDataType* _tmp465_;
					ValaDataType* _tmp466_;
					const gchar* _tmp467_;
					ValaSourceReference* _tmp468_;
					ValaSourceReference* _tmp469_;
					ValaDynamicProperty* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaDynamicProperty* _tmp483_;
					ValaDynamicProperty* _tmp484_;
					ValaDynamicProperty* _tmp485_;
					ValaDataType* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDataType* _tmp488_;
					ValaDataType* _tmp489_;
					ValaDynamicProperty* _tmp490_;
					ValaSourceReference* _tmp491_;
					ValaSourceReference* _tmp492_;
					ValaPropertyAccessor* _tmp493_;
					ValaPropertyAccessor* _tmp494_;
					ValaDynamicProperty* _tmp495_;
					ValaExpression* _tmp496_;
					ValaExpression* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaTypeSymbol* _tmp500_;
					ValaTypeSymbol* _tmp501_;
					ValaScope* _tmp502_;
					ValaScope* _tmp503_;
					ValaObjectType* _tmp504_;
					ValaObjectTypeSymbol* _tmp505_;
					ValaObjectTypeSymbol* _tmp506_;
					ValaScope* _tmp507_;
					ValaScope* _tmp508_;
					ValaDynamicProperty* _tmp509_;
					ValaDynamicProperty* _tmp510_;
					_tmp463_ = vala_member_access_get_inner (self);
					_tmp464_ = _tmp463_;
					_tmp465_ = vala_expression_get_value_type (_tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = self->priv->_member_name;
					_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp469_ = _tmp468_;
					_tmp470_ = vala_dynamic_property_new (_tmp466_, _tmp467_, _tmp469_, NULL);
					prop = _tmp470_;
					_tmp471_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp472_ = _tmp471_;
					if (_tmp472_ != NULL) {
						ValaDynamicProperty* _tmp473_;
						ValaDataType* _tmp474_;
						ValaDataType* _tmp475_;
						_tmp473_ = prop;
						_tmp474_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp475_ = _tmp474_;
						vala_property_set_property_type ((ValaProperty*) _tmp473_, _tmp475_);
					} else {
						ValaDynamicProperty* _tmp476_;
						ValaExpression* _tmp477_;
						ValaExpression* _tmp478_;
						ValaDataType* _tmp479_;
						ValaDataType* _tmp480_;
						ValaDataType* _tmp481_;
						ValaDataType* _tmp482_;
						_tmp476_ = prop;
						_tmp477_ = vala_member_access_get_inner (self);
						_tmp478_ = _tmp477_;
						_tmp479_ = vala_expression_get_value_type (_tmp478_);
						_tmp480_ = _tmp479_;
						_tmp481_ = vala_data_type_copy (_tmp480_);
						_tmp482_ = _tmp481_;
						vala_property_set_property_type ((ValaProperty*) _tmp476_, _tmp482_);
						_vala_code_node_unref0 (_tmp482_);
					}
					_tmp483_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp483_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp484_ = prop;
					_tmp485_ = prop;
					_tmp486_ = vala_property_get_property_type ((ValaProperty*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp488_ = vala_data_type_copy (_tmp487_);
					_tmp489_ = _tmp488_;
					_tmp490_ = prop;
					_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
					_tmp492_ = _tmp491_;
					_tmp493_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp489_, NULL, _tmp492_, NULL);
					_tmp494_ = _tmp493_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp484_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_vala_code_node_unref0 (_tmp489_);
					_tmp495_ = prop;
					_tmp496_ = vala_member_access_get_inner (self);
					_tmp497_ = _tmp496_;
					_tmp498_ = vala_expression_get_value_type (_tmp497_);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_data_type_get_data_type (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
					_tmp503_ = _tmp502_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
					_tmp504_ = dynamic_object_type;
					_tmp505_ = vala_object_type_get_type_symbol (_tmp504_);
					_tmp506_ = _tmp505_;
					_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = prop;
					vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
					_tmp510_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
					_vala_code_node_unref0 (prop);
				}
				_tmp511_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp512_ = _tmp511_;
				if (_tmp512_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp514_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp515_ = _tmp514_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp515_)) {
				ValaExpression* _tmp516_;
				ValaExpression* _tmp517_;
				ValaDataType* _tmp518_;
				ValaDataType* _tmp519_;
				_tmp516_ = vala_member_access_get_inner (self);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_expression_get_value_type (_tmp517_);
				_tmp519_ = _tmp518_;
				_tmp513_ = VALA_IS_ARRAY_TYPE (_tmp519_);
			} else {
				_tmp513_ = FALSE;
			}
			if (_tmp513_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp520_;
				ValaExpression* _tmp521_;
				ValaDataType* _tmp522_;
				ValaDataType* _tmp523_;
				gboolean _tmp524_ = FALSE;
				ValaArrayType* _tmp525_;
				_tmp520_ = vala_member_access_get_inner (self);
				_tmp521_ = _tmp520_;
				_tmp522_ = vala_expression_get_value_type (_tmp521_);
				_tmp523_ = _tmp522_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp523_) ? ((ValaArrayType*) _tmp523_) : NULL;
				_tmp525_ = value_array_type;
				if (_tmp525_ != NULL) {
					ValaArrayType* _tmp526_;
					gboolean _tmp527_;
					gboolean _tmp528_;
					_tmp526_ = value_array_type;
					_tmp527_ = vala_array_type_get_inline_allocated (_tmp526_);
					_tmp528_ = _tmp527_;
					_tmp524_ = _tmp528_;
				} else {
					_tmp524_ = FALSE;
				}
				if (_tmp524_) {
					ValaSourceReference* _tmp529_;
					ValaSourceReference* _tmp530_;
					_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp530_ = _tmp529_;
					vala_report_error (_tmp530_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp534_ = vala_member_access_get_inner (self);
	_tmp535_ = _tmp534_;
	if (_tmp535_ == NULL) {
		ValaSymbol* _tmp536_;
		ValaSymbol* _tmp537_;
		_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp537_ = _tmp536_;
		_tmp533_ = _tmp537_ == NULL;
	} else {
		_tmp533_ = FALSE;
	}
	if (_tmp533_) {
		ValaDataType* _tmp538_;
		ValaDataType* _tmp539_;
		_tmp538_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp539_ = _tmp538_;
		_tmp532_ = _tmp539_ != NULL;
	} else {
		_tmp532_ = FALSE;
	}
	if (_tmp532_) {
		ValaDataType* _tmp540_;
		ValaDataType* _tmp541_;
		ValaTypeSymbol* _tmp542_;
		ValaTypeSymbol* _tmp543_;
		_tmp540_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp541_ = _tmp540_;
		_tmp542_ = vala_data_type_get_data_type (_tmp541_);
		_tmp543_ = _tmp542_;
		_tmp531_ = VALA_IS_ENUM (_tmp543_);
	} else {
		_tmp531_ = FALSE;
	}
	if (_tmp531_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp544_;
		ValaDataType* _tmp545_;
		ValaTypeSymbol* _tmp546_;
		ValaTypeSymbol* _tmp547_;
		ValaEnum* _tmp548_;
		_tmp544_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp545_ = _tmp544_;
		_tmp546_ = vala_data_type_get_data_type (_tmp545_);
		_tmp547_ = _tmp546_;
		_tmp548_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp547_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp548_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp549_;
			ValaList* _tmp550_;
			gint _val_size = 0;
			ValaList* _tmp551_;
			gint _tmp552_;
			gint _tmp553_;
			gint _val_index = 0;
			_tmp549_ = enum_type;
			_tmp550_ = vala_enum_get_values (_tmp549_);
			_val_list = _tmp550_;
			_tmp551_ = _val_list;
			_tmp552_ = vala_collection_get_size ((ValaCollection*) _tmp551_);
			_tmp553_ = _tmp552_;
			_val_size = _tmp553_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp554_;
				gpointer _tmp555_;
				const gchar* _tmp556_;
				ValaEnumValue* _tmp557_;
				const gchar* _tmp558_;
				const gchar* _tmp559_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp554_ = _val_list;
				_tmp555_ = vala_list_get (_tmp554_, _val_index);
				val = (ValaEnumValue*) _tmp555_;
				_tmp556_ = self->priv->_member_name;
				_tmp557_ = val;
				_tmp558_ = vala_symbol_get_name ((ValaSymbol*) _tmp557_);
				_tmp559_ = _tmp558_;
				if (g_strcmp0 (_tmp556_, _tmp559_) == 0) {
					ValaEnumValue* _tmp560_;
					_tmp560_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp560_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp562_ = _tmp561_;
	if (_tmp562_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp563_;
		gboolean _tmp564_ = FALSE;
		ValaExpression* _tmp565_;
		ValaExpression* _tmp566_;
		ValaSourceReference* _tmp579_;
		ValaSourceReference* _tmp580_;
		const gchar* _tmp581_;
		const gchar* _tmp582_;
		gchar* _tmp583_;
		gchar* _tmp584_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp563_ = g_strdup ("(null)");
		base_type_name = _tmp563_;
		_tmp565_ = vala_member_access_get_inner (self);
		_tmp566_ = _tmp565_;
		if (_tmp566_ != NULL) {
			ValaExpression* _tmp567_;
			ValaExpression* _tmp568_;
			ValaDataType* _tmp569_;
			ValaDataType* _tmp570_;
			_tmp567_ = vala_member_access_get_inner (self);
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_expression_get_value_type (_tmp568_);
			_tmp570_ = _tmp569_;
			_tmp564_ = _tmp570_ != NULL;
		} else {
			_tmp564_ = FALSE;
		}
		if (_tmp564_) {
			ValaExpression* _tmp571_;
			ValaExpression* _tmp572_;
			ValaDataType* _tmp573_;
			ValaDataType* _tmp574_;
			gchar* _tmp575_;
			_tmp571_ = vala_member_access_get_inner (self);
			_tmp572_ = _tmp571_;
			_tmp573_ = vala_expression_get_value_type (_tmp572_);
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_code_node_to_string ((ValaCodeNode*) _tmp574_);
			_g_free0 (base_type_name);
			base_type_name = _tmp575_;
		} else {
			ValaSymbol* _tmp576_;
			_tmp576_ = base_symbol;
			if (_tmp576_ != NULL) {
				ValaSymbol* _tmp577_;
				gchar* _tmp578_;
				_tmp577_ = base_symbol;
				_tmp578_ = vala_symbol_get_full_name (_tmp577_);
				_g_free0 (base_type_name);
				base_type_name = _tmp578_;
			}
		}
		_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp580_ = _tmp579_;
		_tmp581_ = self->priv->_member_name;
		_tmp582_ = base_type_name;
		_tmp583_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp581_, _tmp582_);
		_tmp584_ = _tmp583_;
		vala_report_error (_tmp580_, _tmp584_);
		_g_free0 (_tmp584_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp585_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp586_ = _tmp585_;
	_tmp587_ = _vala_code_node_ref0 (_tmp586_);
	member = _tmp587_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp588_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp588_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp589_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp589_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp590_;
		ValaLocalVariable* _tmp591_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp592_;
		ValaSymbol* _tmp593_;
		ValaSymbol* _tmp594_;
		ValaBlock* _tmp595_;
		gboolean _tmp596_ = FALSE;
		ValaBlock* _tmp597_;
		_tmp590_ = member;
		_tmp591_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp590_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp591_;
		_tmp592_ = local;
		_tmp593_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp592_);
		_tmp594_ = _tmp593_;
		_tmp595_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp594_) ? ((ValaBlock*) _tmp594_) : NULL);
		block = _tmp595_;
		_tmp597_ = block;
		if (_tmp597_ != NULL) {
			ValaSemanticAnalyzer* _tmp598_;
			ValaSemanticAnalyzer* _tmp599_;
			ValaBlock* _tmp600_;
			ValaSymbol* _tmp601_;
			ValaSymbol* _tmp602_;
			ValaSemanticAnalyzer* _tmp603_;
			ValaSemanticAnalyzer* _tmp604_;
			ValaSymbol* _tmp605_;
			ValaSymbol* _tmp606_;
			_tmp598_ = vala_code_context_get_analyzer (context);
			_tmp599_ = _tmp598_;
			_tmp600_ = block;
			_tmp601_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp599_, (ValaSymbol*) _tmp600_);
			_tmp602_ = _tmp601_;
			_tmp603_ = vala_code_context_get_analyzer (context);
			_tmp604_ = _tmp603_;
			_tmp605_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp604_);
			_tmp606_ = _tmp605_;
			_tmp596_ = _tmp602_ != _tmp606_;
			_vala_code_node_unref0 (_tmp602_);
		} else {
			_tmp596_ = FALSE;
		}
		if (_tmp596_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp607_;
			ValaSemanticAnalyzer* _tmp608_;
			ValaSymbol* _tmp609_;
			ValaSymbol* _tmp610_;
			ValaSymbol* _tmp611_;
			ValaLocalVariable* _tmp624_;
			ValaBlock* _tmp625_;
			_tmp607_ = vala_code_context_get_analyzer (context);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp608_);
			_tmp610_ = _tmp609_;
			_tmp611_ = _vala_code_node_ref0 (_tmp610_);
			sym = _tmp611_;
			while (TRUE) {
				ValaSymbol* _tmp612_;
				ValaBlock* _tmp613_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp614_;
				ValaMethod* _tmp615_;
				ValaMethod* _tmp616_;
				ValaSymbol* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaSymbol* _tmp622_;
				ValaSymbol* _tmp623_;
				_tmp612_ = sym;
				_tmp613_ = block;
				if (!(_tmp612_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp613_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp614_ = sym;
				_tmp615_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp614_) ? ((ValaMethod*) _tmp614_) : NULL);
				method = _tmp615_;
				_tmp616_ = method;
				if (_tmp616_ != NULL) {
					ValaMethod* _tmp617_;
					ValaMethod* _tmp618_;
					ValaLocalVariable* _tmp619_;
					_tmp617_ = method;
					vala_method_set_closure (_tmp617_, TRUE);
					_tmp618_ = method;
					_tmp619_ = local;
					vala_method_add_captured_variable (_tmp618_, _tmp619_);
				}
				_tmp620_ = sym;
				_tmp621_ = vala_symbol_get_parent_symbol (_tmp620_);
				_tmp622_ = _tmp621_;
				_tmp623_ = _vala_code_node_ref0 (_tmp622_);
				_vala_code_node_unref0 (sym);
				sym = _tmp623_;
				_vala_code_node_unref0 (method);
			}
			_tmp624_ = local;
			vala_local_variable_set_captured (_tmp624_, TRUE);
			_tmp625_ = block;
			vala_block_set_captured (_tmp625_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp626_;
		_tmp626_ = member;
		if (VALA_IS_PARAMETER (_tmp626_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp627_;
			ValaParameter* _tmp628_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp629_;
			ValaSymbol* _tmp630_;
			ValaSymbol* _tmp631_;
			ValaMethod* _tmp632_;
			gboolean _tmp633_ = FALSE;
			gboolean _tmp634_ = FALSE;
			ValaMethod* _tmp635_;
			_tmp627_ = member;
			_tmp628_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp627_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp628_;
			_tmp629_ = param;
			_tmp630_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp631_) ? ((ValaMethod*) _tmp631_) : NULL);
			m = _tmp632_;
			_tmp635_ = m;
			if (_tmp635_ != NULL) {
				ValaMethod* _tmp636_;
				ValaSemanticAnalyzer* _tmp637_;
				ValaSemanticAnalyzer* _tmp638_;
				ValaSymbol* _tmp639_;
				ValaSymbol* _tmp640_;
				_tmp636_ = m;
				_tmp637_ = vala_code_context_get_analyzer (context);
				_tmp638_ = _tmp637_;
				_tmp639_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp638_);
				_tmp640_ = _tmp639_;
				_tmp634_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp636_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp640_;
			} else {
				_tmp634_ = FALSE;
			}
			if (_tmp634_) {
				ValaParameter* _tmp641_;
				ValaMethod* _tmp642_;
				ValaParameter* _tmp643_;
				ValaParameter* _tmp644_;
				_tmp641_ = param;
				_tmp642_ = m;
				_tmp643_ = vala_method_get_this_parameter (_tmp642_);
				_tmp644_ = _tmp643_;
				_tmp633_ = _tmp641_ != _tmp644_;
			} else {
				_tmp633_ = FALSE;
			}
			if (_tmp633_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp645_;
				ValaSemanticAnalyzer* _tmp646_;
				ValaSymbol* _tmp647_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				ValaParameter* _tmp660_;
				ValaMethod* _tmp661_;
				ValaBlock* _tmp662_;
				ValaBlock* _tmp663_;
				ValaParameter* _tmp664_;
				ValaParameterDirection _tmp665_;
				ValaParameterDirection _tmp666_;
				_tmp645_ = vala_code_context_get_analyzer (context);
				_tmp646_ = _tmp645_;
				_tmp647_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp646_);
				_tmp648_ = _tmp647_;
				_tmp649_ = _vala_code_node_ref0 (_tmp648_);
				sym = _tmp649_;
				while (TRUE) {
					ValaSymbol* _tmp650_;
					ValaMethod* _tmp651_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp652_;
					ValaMethod* _tmp653_;
					ValaMethod* _tmp654_;
					ValaSymbol* _tmp656_;
					ValaSymbol* _tmp657_;
					ValaSymbol* _tmp658_;
					ValaSymbol* _tmp659_;
					_tmp650_ = sym;
					_tmp651_ = m;
					if (!(_tmp650_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp652_ = sym;
					_tmp653_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp652_) ? ((ValaMethod*) _tmp652_) : NULL);
					method = _tmp653_;
					_tmp654_ = method;
					if (_tmp654_ != NULL) {
						ValaMethod* _tmp655_;
						_tmp655_ = method;
						vala_method_set_closure (_tmp655_, TRUE);
					}
					_tmp656_ = sym;
					_tmp657_ = vala_symbol_get_parent_symbol (_tmp656_);
					_tmp658_ = _tmp657_;
					_tmp659_ = _vala_code_node_ref0 (_tmp658_);
					_vala_code_node_unref0 (sym);
					sym = _tmp659_;
					_vala_code_node_unref0 (method);
				}
				_tmp660_ = param;
				vala_parameter_set_captured (_tmp660_, TRUE);
				_tmp661_ = m;
				_tmp662_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp661_);
				_tmp663_ = _tmp662_;
				vala_block_set_captured (_tmp663_, TRUE);
				_tmp664_ = param;
				_tmp665_ = vala_parameter_get_direction (_tmp664_);
				_tmp666_ = _tmp665_;
				if (_tmp666_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp667_;
					ValaSourceReference* _tmp668_;
					ValaParameter* _tmp669_;
					gchar* _tmp670_;
					gchar* _tmp671_;
					gchar* _tmp672_;
					gchar* _tmp673_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp667_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp668_ = _tmp667_;
					_tmp669_ = param;
					_tmp670_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp671_);
					_tmp673_ = _tmp672_;
					vala_report_error (_tmp668_, _tmp673_);
					_g_free0 (_tmp673_);
					_g_free0 (_tmp671_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp674_;
				ValaSymbol* _tmp675_;
				ValaSymbol* _tmp676_;
				ValaSymbol* _tmp677_;
				ValaSymbol* _tmp678_;
				ValaPropertyAccessor* _tmp679_;
				gboolean _tmp680_ = FALSE;
				gboolean _tmp681_ = FALSE;
				ValaPropertyAccessor* _tmp682_;
				_tmp674_ = param;
				_tmp675_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp674_);
				_tmp676_ = _tmp675_;
				_tmp677_ = vala_symbol_get_parent_symbol (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp679_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp678_) ? ((ValaPropertyAccessor*) _tmp678_) : NULL);
				acc = _tmp679_;
				_tmp682_ = acc;
				if (_tmp682_ != NULL) {
					ValaPropertyAccessor* _tmp683_;
					ValaSemanticAnalyzer* _tmp684_;
					ValaSemanticAnalyzer* _tmp685_;
					ValaSymbol* _tmp686_;
					ValaSymbol* _tmp687_;
					_tmp683_ = acc;
					_tmp684_ = vala_code_context_get_analyzer (context);
					_tmp685_ = _tmp684_;
					_tmp686_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp685_);
					_tmp687_ = _tmp686_;
					_tmp681_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp683_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp687_;
				} else {
					_tmp681_ = FALSE;
				}
				if (_tmp681_) {
					ValaParameter* _tmp688_;
					ValaPropertyAccessor* _tmp689_;
					ValaProperty* _tmp690_;
					ValaProperty* _tmp691_;
					ValaParameter* _tmp692_;
					ValaParameter* _tmp693_;
					_tmp688_ = param;
					_tmp689_ = acc;
					_tmp690_ = vala_property_accessor_get_prop (_tmp689_);
					_tmp691_ = _tmp690_;
					_tmp692_ = vala_property_get_this_parameter (_tmp691_);
					_tmp693_ = _tmp692_;
					_tmp680_ = _tmp688_ != _tmp693_;
				} else {
					_tmp680_ = FALSE;
				}
				if (_tmp680_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp694_;
					ValaSemanticAnalyzer* _tmp695_;
					ValaSymbol* _tmp696_;
					ValaSymbol* _tmp697_;
					ValaSymbol* _tmp698_;
					ValaParameter* _tmp709_;
					ValaPropertyAccessor* _tmp710_;
					ValaBlock* _tmp711_;
					ValaBlock* _tmp712_;
					_tmp694_ = vala_code_context_get_analyzer (context);
					_tmp695_ = _tmp694_;
					_tmp696_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp695_);
					_tmp697_ = _tmp696_;
					_tmp698_ = _vala_code_node_ref0 (_tmp697_);
					sym = _tmp698_;
					while (TRUE) {
						ValaSymbol* _tmp699_;
						ValaMethod* _tmp700_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp701_;
						ValaMethod* _tmp702_;
						ValaMethod* _tmp703_;
						ValaSymbol* _tmp705_;
						ValaSymbol* _tmp706_;
						ValaSymbol* _tmp707_;
						ValaSymbol* _tmp708_;
						_tmp699_ = sym;
						_tmp700_ = m;
						if (!(_tmp699_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp700_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp701_ = sym;
						_tmp702_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp701_) ? ((ValaMethod*) _tmp701_) : NULL);
						method = _tmp702_;
						_tmp703_ = method;
						if (_tmp703_ != NULL) {
							ValaMethod* _tmp704_;
							_tmp704_ = method;
							vala_method_set_closure (_tmp704_, TRUE);
						}
						_tmp705_ = sym;
						_tmp706_ = vala_symbol_get_parent_symbol (_tmp705_);
						_tmp707_ = _tmp706_;
						_tmp708_ = _vala_code_node_ref0 (_tmp707_);
						_vala_code_node_unref0 (sym);
						sym = _tmp708_;
						_vala_code_node_unref0 (method);
					}
					_tmp709_ = param;
					vala_parameter_set_captured (_tmp709_, TRUE);
					_tmp710_ = acc;
					_tmp711_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp710_);
					_tmp712_ = _tmp711_;
					vala_block_set_captured (_tmp712_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp713_;
			_tmp713_ = member;
			if (VALA_IS_FIELD (_tmp713_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp714_;
				ValaField* _tmp715_;
				ValaField* _tmp716_;
				ValaSymbolAccessibility _tmp717_;
				ValaSymbolAccessibility _tmp718_;
				ValaField* _tmp719_;
				ValaMemberBinding _tmp720_;
				ValaMemberBinding _tmp721_;
				ValaField* _tmp722_;
				ValaMemberBinding _tmp723_;
				ValaMemberBinding _tmp724_;
				ValaField* _tmp725_;
				ValaDataType* _tmp726_;
				ValaDataType* _tmp727_;
				_tmp714_ = member;
				_tmp715_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp714_, VALA_TYPE_FIELD, ValaField));
				f = _tmp715_;
				_tmp716_ = f;
				_tmp717_ = vala_symbol_get_access ((ValaSymbol*) _tmp716_);
				_tmp718_ = _tmp717_;
				access = _tmp718_;
				_tmp719_ = f;
				_tmp720_ = vala_field_get_binding (_tmp719_);
				_tmp721_ = _tmp720_;
				instance = _tmp721_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp722_ = f;
				_tmp723_ = vala_field_get_binding (_tmp722_);
				_tmp724_ = _tmp723_;
				klass = _tmp724_ == VALA_MEMBER_BINDING_CLASS;
				_tmp725_ = f;
				_tmp726_ = vala_variable_get_variable_type ((ValaVariable*) _tmp725_);
				_tmp727_ = _tmp726_;
				if (VALA_IS_GENERIC_TYPE (_tmp727_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp728_;
				_tmp728_ = member;
				if (VALA_IS_CONSTANT (_tmp728_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp729_;
					ValaConstant* _tmp730_;
					ValaConstant* _tmp731_;
					ValaSymbolAccessibility _tmp732_;
					ValaSymbolAccessibility _tmp733_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp734_;
					ValaSymbol* _tmp735_;
					ValaSymbol* _tmp736_;
					ValaBlock* _tmp737_;
					gboolean _tmp738_ = FALSE;
					ValaBlock* _tmp739_;
					_tmp729_ = member;
					_tmp730_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp729_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp730_;
					_tmp731_ = c;
					_tmp732_ = vala_symbol_get_access ((ValaSymbol*) _tmp731_);
					_tmp733_ = _tmp732_;
					access = _tmp733_;
					_tmp734_ = c;
					_tmp735_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp734_);
					_tmp736_ = _tmp735_;
					_tmp737_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp736_) ? ((ValaBlock*) _tmp736_) : NULL);
					block = _tmp737_;
					_tmp739_ = block;
					if (_tmp739_ != NULL) {
						ValaSemanticAnalyzer* _tmp740_;
						ValaSemanticAnalyzer* _tmp741_;
						ValaBlock* _tmp742_;
						ValaSymbol* _tmp743_;
						ValaSymbol* _tmp744_;
						ValaSemanticAnalyzer* _tmp745_;
						ValaSemanticAnalyzer* _tmp746_;
						ValaSymbol* _tmp747_;
						ValaSymbol* _tmp748_;
						_tmp740_ = vala_code_context_get_analyzer (context);
						_tmp741_ = _tmp740_;
						_tmp742_ = block;
						_tmp743_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp741_, (ValaSymbol*) _tmp742_);
						_tmp744_ = _tmp743_;
						_tmp745_ = vala_code_context_get_analyzer (context);
						_tmp746_ = _tmp745_;
						_tmp747_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp746_);
						_tmp748_ = _tmp747_;
						_tmp738_ = _tmp744_ != _tmp748_;
						_vala_code_node_unref0 (_tmp744_);
					} else {
						_tmp738_ = FALSE;
					}
					if (_tmp738_) {
						ValaSourceReference* _tmp749_;
						ValaSourceReference* _tmp750_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp749_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp750_ = _tmp749_;
						vala_report_error (_tmp750_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp751_;
					_tmp751_ = member;
					if (VALA_IS_METHOD (_tmp751_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp752_;
						ValaMethod* _tmp753_;
						ValaMethod* _tmp754_;
						gboolean _tmp755_;
						gboolean _tmp756_;
						ValaMethod* _tmp858_;
						ValaSymbolAccessibility _tmp859_;
						ValaSymbolAccessibility _tmp860_;
						ValaMethod* _tmp861_;
						ValaMethod* _tmp865_;
						ValaMemberBinding _tmp866_;
						ValaMemberBinding _tmp867_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp886_;
						ValaDataType* _tmp887_;
						ValaDataType* _tmp888_;
						ValaGenericType* _tmp889_;
						gboolean _tmp890_ = FALSE;
						ValaGenericType* _tmp891_;
						_tmp752_ = member;
						_tmp753_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp752_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp753_;
						_tmp754_ = m;
						_tmp755_ = vala_method_get_is_async_callback (_tmp754_);
						_tmp756_ = _tmp755_;
						if (_tmp756_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp757_;
							ValaSemanticAnalyzer* _tmp758_;
							ValaMethod* _tmp759_;
							ValaMethod* _tmp760_;
							ValaMethod* _tmp761_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp762_;
							ValaMethod* _tmp795_;
							ValaSemanticAnalyzer* _tmp796_;
							ValaSemanticAnalyzer* _tmp797_;
							ValaMethod* _tmp798_;
							ValaMethod* _tmp799_;
							ValaMethod* _tmp818_;
							ValaMethod* _tmp819_;
							ValaMethod* _tmp820_;
							ValaSymbol* _tmp821_;
							ValaSymbol* _tmp822_;
							ValaSymbol* _tmp823_;
							_tmp757_ = vala_code_context_get_analyzer (context);
							_tmp758_ = _tmp757_;
							_tmp759_ = vala_semantic_analyzer_get_current_async_method (_tmp758_);
							_tmp760_ = _tmp759_;
							_tmp761_ = _vala_code_node_ref0 (_tmp760_);
							async_method = _tmp761_;
							is_valid_access = FALSE;
							_tmp762_ = async_method;
							if (_tmp762_ != NULL) {
								ValaMethod* _tmp763_;
								ValaMethod* _tmp764_;
								ValaMethod* _tmp765_;
								ValaMethod* _tmp766_;
								gboolean _tmp767_;
								_tmp763_ = m;
								_tmp764_ = async_method;
								_tmp765_ = vala_method_get_callback_method (_tmp764_);
								_tmp766_ = _tmp765_;
								_tmp767_ = _tmp763_ == _tmp766_;
								_vala_code_node_unref0 (_tmp766_);
								if (_tmp767_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp768_ = FALSE;
									ValaMethod* _tmp769_;
									ValaMethod* _tmp770_;
									ValaMethod* _tmp771_;
									_tmp769_ = async_method;
									_tmp770_ = vala_method_get_base_method (_tmp769_);
									_tmp771_ = _tmp770_;
									if (_tmp771_ != NULL) {
										ValaMethod* _tmp772_;
										ValaMethod* _tmp773_;
										ValaMethod* _tmp774_;
										ValaMethod* _tmp775_;
										ValaMethod* _tmp776_;
										ValaMethod* _tmp777_;
										_tmp772_ = m;
										_tmp773_ = async_method;
										_tmp774_ = vala_method_get_base_method (_tmp773_);
										_tmp775_ = _tmp774_;
										_tmp776_ = vala_method_get_callback_method (_tmp775_);
										_tmp777_ = _tmp776_;
										_tmp768_ = _tmp772_ == _tmp777_;
										_vala_code_node_unref0 (_tmp777_);
									} else {
										_tmp768_ = FALSE;
									}
									if (_tmp768_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp778_ = FALSE;
										ValaMethod* _tmp779_;
										ValaMethod* _tmp780_;
										ValaMethod* _tmp781_;
										_tmp779_ = async_method;
										_tmp780_ = vala_method_get_base_interface_method (_tmp779_);
										_tmp781_ = _tmp780_;
										if (_tmp781_ != NULL) {
											ValaMethod* _tmp782_;
											ValaMethod* _tmp783_;
											ValaMethod* _tmp784_;
											ValaMethod* _tmp785_;
											ValaMethod* _tmp786_;
											ValaMethod* _tmp787_;
											_tmp782_ = m;
											_tmp783_ = async_method;
											_tmp784_ = vala_method_get_base_interface_method (_tmp783_);
											_tmp785_ = _tmp784_;
											_tmp786_ = vala_method_get_callback_method (_tmp785_);
											_tmp787_ = _tmp786_;
											_tmp778_ = _tmp782_ == _tmp787_;
											_vala_code_node_unref0 (_tmp787_);
										} else {
											_tmp778_ = FALSE;
										}
										if (_tmp778_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp788_;
								ValaSourceReference* _tmp789_;
								ValaMethod* _tmp790_;
								gchar* _tmp791_;
								gchar* _tmp792_;
								gchar* _tmp793_;
								gchar* _tmp794_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp788_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp789_ = _tmp788_;
								_tmp790_ = m;
								_tmp791_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp790_);
								_tmp792_ = _tmp791_;
								_tmp793_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp792_);
								_tmp794_ = _tmp793_;
								vala_report_error (_tmp789_, _tmp794_);
								_g_free0 (_tmp794_);
								_g_free0 (_tmp792_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp795_ = async_method;
							_tmp796_ = vala_code_context_get_analyzer (context);
							_tmp797_ = _tmp796_;
							_tmp798_ = vala_semantic_analyzer_get_current_method (_tmp797_);
							_tmp799_ = _tmp798_;
							if (_tmp795_ != _tmp799_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp800_;
								ValaSemanticAnalyzer* _tmp801_;
								ValaMethod* _tmp802_;
								ValaMethod* _tmp803_;
								ValaSymbol* _tmp804_;
								ValaMethod* _tmp815_;
								ValaBlock* _tmp816_;
								ValaBlock* _tmp817_;
								_tmp800_ = vala_code_context_get_analyzer (context);
								_tmp801_ = _tmp800_;
								_tmp802_ = vala_semantic_analyzer_get_current_method (_tmp801_);
								_tmp803_ = _tmp802_;
								_tmp804_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp803_);
								sym = _tmp804_;
								while (TRUE) {
									ValaSymbol* _tmp805_;
									ValaMethod* _tmp806_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp807_;
									ValaMethod* _tmp808_;
									ValaMethod* _tmp809_;
									ValaSymbol* _tmp811_;
									ValaSymbol* _tmp812_;
									ValaSymbol* _tmp813_;
									ValaSymbol* _tmp814_;
									_tmp805_ = sym;
									_tmp806_ = async_method;
									if (!(_tmp805_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp806_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp807_ = sym;
									_tmp808_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp807_) ? ((ValaMethod*) _tmp807_) : NULL);
									method = _tmp808_;
									_tmp809_ = method;
									if (_tmp809_ != NULL) {
										ValaMethod* _tmp810_;
										_tmp810_ = method;
										vala_method_set_closure (_tmp810_, TRUE);
									}
									_tmp811_ = sym;
									_tmp812_ = vala_symbol_get_parent_symbol (_tmp811_);
									_tmp813_ = _tmp812_;
									_tmp814_ = _vala_code_node_ref0 (_tmp813_);
									_vala_code_node_unref0 (sym);
									sym = _tmp814_;
									_vala_code_node_unref0 (method);
								}
								_tmp815_ = async_method;
								_tmp816_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp815_);
								_tmp817_ = _tmp816_;
								vala_block_set_captured (_tmp817_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp818_ = async_method;
							_tmp819_ = vala_method_get_callback_method (_tmp818_);
							_vala_code_node_unref0 (m);
							m = _tmp819_;
							_tmp820_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp820_);
							_tmp821_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp822_ = _tmp821_;
							_tmp823_ = _vala_code_node_ref0 (_tmp822_);
							_vala_code_node_unref0 (member);
							member = _tmp823_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp824_;
							ValaMethod* _tmp825_;
							ValaMethod* _tmp826_;
							_tmp824_ = m;
							_tmp825_ = vala_method_get_base_method (_tmp824_);
							_tmp826_ = _tmp825_;
							if (_tmp826_ != NULL) {
								ValaMethod* _tmp827_;
								ValaMethod* _tmp828_;
								ValaMethod* _tmp829_;
								ValaMethod* _tmp830_;
								ValaMethod* _tmp831_;
								ValaSignal* _tmp832_;
								ValaSignal* _tmp833_;
								ValaSymbol* _tmp838_;
								ValaSymbol* _tmp839_;
								ValaSymbol* _tmp840_;
								_tmp827_ = m;
								_tmp828_ = vala_method_get_base_method (_tmp827_);
								_tmp829_ = _tmp828_;
								_tmp830_ = _vala_code_node_ref0 (_tmp829_);
								_vala_code_node_unref0 (m);
								m = _tmp830_;
								_tmp831_ = m;
								_tmp832_ = vala_method_get_signal_reference (_tmp831_);
								_tmp833_ = _tmp832_;
								if (_tmp833_ != NULL) {
									ValaMethod* _tmp834_;
									ValaSignal* _tmp835_;
									ValaSignal* _tmp836_;
									_tmp834_ = m;
									_tmp835_ = vala_method_get_signal_reference (_tmp834_);
									_tmp836_ = _tmp835_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp836_);
								} else {
									ValaMethod* _tmp837_;
									_tmp837_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp837_);
								}
								_tmp838_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp839_ = _tmp838_;
								_tmp840_ = _vala_code_node_ref0 (_tmp839_);
								_vala_code_node_unref0 (member);
								member = _tmp840_;
							} else {
								ValaMethod* _tmp841_;
								ValaMethod* _tmp842_;
								ValaMethod* _tmp843_;
								_tmp841_ = m;
								_tmp842_ = vala_method_get_base_interface_method (_tmp841_);
								_tmp843_ = _tmp842_;
								if (_tmp843_ != NULL) {
									ValaMethod* _tmp844_;
									ValaMethod* _tmp845_;
									ValaMethod* _tmp846_;
									ValaMethod* _tmp847_;
									ValaMethod* _tmp848_;
									ValaSignal* _tmp849_;
									ValaSignal* _tmp850_;
									ValaSymbol* _tmp855_;
									ValaSymbol* _tmp856_;
									ValaSymbol* _tmp857_;
									_tmp844_ = m;
									_tmp845_ = vala_method_get_base_interface_method (_tmp844_);
									_tmp846_ = _tmp845_;
									_tmp847_ = _vala_code_node_ref0 (_tmp846_);
									_vala_code_node_unref0 (m);
									m = _tmp847_;
									_tmp848_ = m;
									_tmp849_ = vala_method_get_signal_reference (_tmp848_);
									_tmp850_ = _tmp849_;
									if (_tmp850_ != NULL) {
										ValaMethod* _tmp851_;
										ValaSignal* _tmp852_;
										ValaSignal* _tmp853_;
										_tmp851_ = m;
										_tmp852_ = vala_method_get_signal_reference (_tmp851_);
										_tmp853_ = _tmp852_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp853_);
									} else {
										ValaMethod* _tmp854_;
										_tmp854_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp854_);
									}
									_tmp855_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp856_ = _tmp855_;
									_tmp857_ = _vala_code_node_ref0 (_tmp856_);
									_vala_code_node_unref0 (member);
									member = _tmp857_;
								}
							}
						}
						_tmp858_ = m;
						_tmp859_ = vala_symbol_get_access ((ValaSymbol*) _tmp858_);
						_tmp860_ = _tmp859_;
						access = _tmp860_;
						_tmp861_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp861_)) {
							ValaMethod* _tmp862_;
							ValaMemberBinding _tmp863_;
							ValaMemberBinding _tmp864_;
							_tmp862_ = m;
							_tmp863_ = vala_method_get_binding (_tmp862_);
							_tmp864_ = _tmp863_;
							instance = _tmp864_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp865_ = m;
						_tmp866_ = vala_method_get_binding (_tmp865_);
						_tmp867_ = _tmp866_;
						klass = _tmp867_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp868_;
							ValaList* _tmp869_;
							gint _param_size = 0;
							ValaList* _tmp870_;
							gint _tmp871_;
							gint _tmp872_;
							gint _param_index = 0;
							_tmp868_ = m;
							_tmp869_ = vala_callable_get_parameters ((ValaCallable*) _tmp868_);
							_param_list = _tmp869_;
							_tmp870_ = _param_list;
							_tmp871_ = vala_collection_get_size ((ValaCollection*) _tmp870_);
							_tmp872_ = _tmp871_;
							_param_size = _tmp872_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp873_;
								gpointer _tmp874_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp875_;
								ValaDataType* _tmp876_;
								ValaDataType* _tmp877_;
								ValaGenericType* _tmp878_;
								gboolean _tmp879_ = FALSE;
								ValaGenericType* _tmp880_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp873_ = _param_list;
								_tmp874_ = vala_list_get (_tmp873_, _param_index);
								param = (ValaParameter*) _tmp874_;
								_tmp875_ = param;
								_tmp876_ = vala_variable_get_variable_type ((ValaVariable*) _tmp875_);
								_tmp877_ = _tmp876_;
								_tmp878_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp877_) ? ((ValaGenericType*) _tmp877_) : NULL);
								generic_type = _tmp878_;
								_tmp880_ = generic_type;
								if (_tmp880_ != NULL) {
									ValaGenericType* _tmp881_;
									ValaTypeParameter* _tmp882_;
									ValaTypeParameter* _tmp883_;
									ValaSymbol* _tmp884_;
									ValaSymbol* _tmp885_;
									_tmp881_ = generic_type;
									_tmp882_ = vala_generic_type_get_type_parameter (_tmp881_);
									_tmp883_ = _tmp882_;
									_tmp884_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp883_);
									_tmp885_ = _tmp884_;
									_tmp879_ = VALA_IS_TYPESYMBOL (_tmp885_);
								} else {
									_tmp879_ = FALSE;
								}
								if (_tmp879_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp886_ = m;
						_tmp887_ = vala_callable_get_return_type ((ValaCallable*) _tmp886_);
						_tmp888_ = _tmp887_;
						_tmp889_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp888_) ? ((ValaGenericType*) _tmp888_) : NULL);
						generic_type = _tmp889_;
						_tmp891_ = generic_type;
						if (_tmp891_ != NULL) {
							ValaGenericType* _tmp892_;
							ValaTypeParameter* _tmp893_;
							ValaTypeParameter* _tmp894_;
							ValaSymbol* _tmp895_;
							ValaSymbol* _tmp896_;
							_tmp892_ = generic_type;
							_tmp893_ = vala_generic_type_get_type_parameter (_tmp892_);
							_tmp894_ = _tmp893_;
							_tmp895_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp894_);
							_tmp896_ = _tmp895_;
							_tmp890_ = VALA_IS_TYPESYMBOL (_tmp896_);
						} else {
							_tmp890_ = FALSE;
						}
						if (_tmp890_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp897_;
						_tmp897_ = member;
						if (VALA_IS_PROPERTY (_tmp897_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp898_;
							ValaProperty* _tmp899_;
							ValaProperty* _tmp900_;
							ValaProperty* _tmp901_;
							ValaProperty* _tmp902_;
							ValaProperty* _tmp903_;
							ValaProperty* _tmp923_;
							ValaSymbolAccessibility _tmp924_;
							ValaSymbolAccessibility _tmp925_;
							gboolean _tmp926_;
							gboolean _tmp927_;
							ValaProperty* _tmp992_;
							ValaMemberBinding _tmp993_;
							ValaMemberBinding _tmp994_;
							ValaProperty* _tmp995_;
							ValaDataType* _tmp996_;
							ValaDataType* _tmp997_;
							_tmp898_ = member;
							_tmp899_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp898_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp899_;
							_tmp900_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp900_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp901_ = prop;
							_tmp902_ = vala_property_get_base_property (_tmp901_);
							_tmp903_ = _tmp902_;
							if (_tmp903_ != NULL) {
								ValaProperty* _tmp904_;
								ValaProperty* _tmp905_;
								ValaProperty* _tmp906_;
								ValaProperty* _tmp907_;
								ValaProperty* _tmp908_;
								ValaSymbol* _tmp909_;
								ValaSymbol* _tmp910_;
								ValaSymbol* _tmp911_;
								_tmp904_ = prop;
								_tmp905_ = vala_property_get_base_property (_tmp904_);
								_tmp906_ = _tmp905_;
								_tmp907_ = _vala_code_node_ref0 (_tmp906_);
								_vala_code_node_unref0 (prop);
								prop = _tmp907_;
								_tmp908_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp908_);
								_tmp909_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp910_ = _tmp909_;
								_tmp911_ = _vala_code_node_ref0 (_tmp910_);
								_vala_code_node_unref0 (member);
								member = _tmp911_;
							} else {
								ValaProperty* _tmp912_;
								ValaProperty* _tmp913_;
								ValaProperty* _tmp914_;
								_tmp912_ = prop;
								_tmp913_ = vala_property_get_base_interface_property (_tmp912_);
								_tmp914_ = _tmp913_;
								if (_tmp914_ != NULL) {
									ValaProperty* _tmp915_;
									ValaProperty* _tmp916_;
									ValaProperty* _tmp917_;
									ValaProperty* _tmp918_;
									ValaProperty* _tmp919_;
									ValaSymbol* _tmp920_;
									ValaSymbol* _tmp921_;
									ValaSymbol* _tmp922_;
									_tmp915_ = prop;
									_tmp916_ = vala_property_get_base_interface_property (_tmp915_);
									_tmp917_ = _tmp916_;
									_tmp918_ = _vala_code_node_ref0 (_tmp917_);
									_vala_code_node_unref0 (prop);
									prop = _tmp918_;
									_tmp919_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp919_);
									_tmp920_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp921_ = _tmp920_;
									_tmp922_ = _vala_code_node_ref0 (_tmp921_);
									_vala_code_node_unref0 (member);
									member = _tmp922_;
								}
							}
							_tmp923_ = prop;
							_tmp924_ = vala_symbol_get_access ((ValaSymbol*) _tmp923_);
							_tmp925_ = _tmp924_;
							access = _tmp925_;
							_tmp926_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp927_ = _tmp926_;
							if (_tmp927_) {
								ValaProperty* _tmp928_;
								ValaPropertyAccessor* _tmp929_;
								ValaPropertyAccessor* _tmp930_;
								ValaProperty* _tmp938_;
								ValaSymbolAccessibility _tmp939_;
								ValaSymbolAccessibility _tmp940_;
								_tmp928_ = prop;
								_tmp929_ = vala_property_get_set_accessor (_tmp928_);
								_tmp930_ = _tmp929_;
								if (_tmp930_ == NULL) {
									ValaSourceReference* _tmp931_;
									ValaSourceReference* _tmp932_;
									ValaProperty* _tmp933_;
									gchar* _tmp934_;
									gchar* _tmp935_;
									gchar* _tmp936_;
									gchar* _tmp937_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp931_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp932_ = _tmp931_;
									_tmp933_ = prop;
									_tmp934_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp933_);
									_tmp935_ = _tmp934_;
									_tmp936_ = g_strdup_printf ("Property `%s' is read-only", _tmp935_);
									_tmp937_ = _tmp936_;
									vala_report_error (_tmp932_, _tmp937_);
									_g_free0 (_tmp937_);
									_g_free0 (_tmp935_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp938_ = prop;
								_tmp939_ = vala_symbol_get_access ((ValaSymbol*) _tmp938_);
								_tmp940_ = _tmp939_;
								if (_tmp940_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp941_;
									ValaPropertyAccessor* _tmp942_;
									ValaPropertyAccessor* _tmp943_;
									ValaSymbolAccessibility _tmp944_;
									ValaSymbolAccessibility _tmp945_;
									_tmp941_ = prop;
									_tmp942_ = vala_property_get_set_accessor (_tmp941_);
									_tmp943_ = _tmp942_;
									_tmp944_ = vala_symbol_get_access ((ValaSymbol*) _tmp943_);
									_tmp945_ = _tmp944_;
									access = _tmp945_;
								} else {
									gboolean _tmp946_ = FALSE;
									ValaProperty* _tmp947_;
									ValaSymbolAccessibility _tmp948_;
									ValaSymbolAccessibility _tmp949_;
									_tmp947_ = prop;
									_tmp948_ = vala_symbol_get_access ((ValaSymbol*) _tmp947_);
									_tmp949_ = _tmp948_;
									if (_tmp949_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp950_;
										ValaPropertyAccessor* _tmp951_;
										ValaPropertyAccessor* _tmp952_;
										ValaSymbolAccessibility _tmp953_;
										ValaSymbolAccessibility _tmp954_;
										_tmp950_ = prop;
										_tmp951_ = vala_property_get_set_accessor (_tmp950_);
										_tmp952_ = _tmp951_;
										_tmp953_ = vala_symbol_get_access ((ValaSymbol*) _tmp952_);
										_tmp954_ = _tmp953_;
										_tmp946_ = _tmp954_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp946_ = FALSE;
									}
									if (_tmp946_) {
										ValaProperty* _tmp955_;
										ValaPropertyAccessor* _tmp956_;
										ValaPropertyAccessor* _tmp957_;
										ValaSymbolAccessibility _tmp958_;
										ValaSymbolAccessibility _tmp959_;
										_tmp955_ = prop;
										_tmp956_ = vala_property_get_set_accessor (_tmp955_);
										_tmp957_ = _tmp956_;
										_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
										_tmp959_ = _tmp958_;
										access = _tmp959_;
									}
								}
							} else {
								ValaProperty* _tmp960_;
								ValaPropertyAccessor* _tmp961_;
								ValaPropertyAccessor* _tmp962_;
								ValaProperty* _tmp970_;
								ValaSymbolAccessibility _tmp971_;
								ValaSymbolAccessibility _tmp972_;
								_tmp960_ = prop;
								_tmp961_ = vala_property_get_get_accessor (_tmp960_);
								_tmp962_ = _tmp961_;
								if (_tmp962_ == NULL) {
									ValaSourceReference* _tmp963_;
									ValaSourceReference* _tmp964_;
									ValaProperty* _tmp965_;
									gchar* _tmp966_;
									gchar* _tmp967_;
									gchar* _tmp968_;
									gchar* _tmp969_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp963_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp964_ = _tmp963_;
									_tmp965_ = prop;
									_tmp966_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp965_);
									_tmp967_ = _tmp966_;
									_tmp968_ = g_strdup_printf ("Property `%s' is write-only", _tmp967_);
									_tmp969_ = _tmp968_;
									vala_report_error (_tmp964_, _tmp969_);
									_g_free0 (_tmp969_);
									_g_free0 (_tmp967_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp970_ = prop;
								_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
								_tmp972_ = _tmp971_;
								if (_tmp972_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp973_;
									ValaPropertyAccessor* _tmp974_;
									ValaPropertyAccessor* _tmp975_;
									ValaSymbolAccessibility _tmp976_;
									ValaSymbolAccessibility _tmp977_;
									_tmp973_ = prop;
									_tmp974_ = vala_property_get_get_accessor (_tmp973_);
									_tmp975_ = _tmp974_;
									_tmp976_ = vala_symbol_get_access ((ValaSymbol*) _tmp975_);
									_tmp977_ = _tmp976_;
									access = _tmp977_;
								} else {
									gboolean _tmp978_ = FALSE;
									ValaProperty* _tmp979_;
									ValaSymbolAccessibility _tmp980_;
									ValaSymbolAccessibility _tmp981_;
									_tmp979_ = prop;
									_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
									_tmp981_ = _tmp980_;
									if (_tmp981_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp982_;
										ValaPropertyAccessor* _tmp983_;
										ValaPropertyAccessor* _tmp984_;
										ValaSymbolAccessibility _tmp985_;
										ValaSymbolAccessibility _tmp986_;
										_tmp982_ = prop;
										_tmp983_ = vala_property_get_get_accessor (_tmp982_);
										_tmp984_ = _tmp983_;
										_tmp985_ = vala_symbol_get_access ((ValaSymbol*) _tmp984_);
										_tmp986_ = _tmp985_;
										_tmp978_ = _tmp986_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp978_ = FALSE;
									}
									if (_tmp978_) {
										ValaProperty* _tmp987_;
										ValaPropertyAccessor* _tmp988_;
										ValaPropertyAccessor* _tmp989_;
										ValaSymbolAccessibility _tmp990_;
										ValaSymbolAccessibility _tmp991_;
										_tmp987_ = prop;
										_tmp988_ = vala_property_get_get_accessor (_tmp987_);
										_tmp989_ = _tmp988_;
										_tmp990_ = vala_symbol_get_access ((ValaSymbol*) _tmp989_);
										_tmp991_ = _tmp990_;
										access = _tmp991_;
									}
								}
							}
							_tmp992_ = prop;
							_tmp993_ = vala_property_get_binding (_tmp992_);
							_tmp994_ = _tmp993_;
							instance = _tmp994_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp995_ = prop;
							_tmp996_ = vala_property_get_property_type (_tmp995_);
							_tmp997_ = _tmp996_;
							if (VALA_IS_GENERIC_TYPE (_tmp997_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp998_;
							_tmp998_ = member;
							if (VALA_IS_SIGNAL (_tmp998_)) {
								ValaSymbol* _tmp999_;
								ValaSymbolAccessibility _tmp1000_;
								ValaSymbolAccessibility _tmp1001_;
								instance = TRUE;
								_tmp999_ = member;
								_tmp1000_ = vala_symbol_get_access (_tmp999_);
								_tmp1001_ = _tmp1000_;
								access = _tmp1001_;
							} else {
								gboolean _tmp1002_ = FALSE;
								gboolean _tmp1003_;
								_tmp1003_ = self->priv->_creation_member;
								if (!_tmp1003_) {
									ValaSymbol* _tmp1004_;
									_tmp1004_ = member;
									_tmp1002_ = VALA_IS_ERROR_CODE (_tmp1004_);
								} else {
									_tmp1002_ = FALSE;
								}
								if (_tmp1002_) {
									ValaSymbol* _tmp1005_;
									ValaConstant* _tmp1006_;
									ValaConstant* _tmp1007_;
									ValaSymbol* _tmp1008_;
									ValaSymbol* _tmp1009_;
									ValaSymbol* _tmp1010_;
									_tmp1005_ = member;
									_tmp1006_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1005_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1007_ = _tmp1006_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1007_);
									_tmp1008_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1009_ = _tmp1008_;
									_tmp1010_ = _vala_code_node_ref0 (_tmp1009_);
									_vala_code_node_unref0 (member);
									member = _tmp1010_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1011_ = member;
	vala_symbol_set_used (_tmp1011_, TRUE);
	_tmp1012_ = member;
	_tmp1013_ = vala_symbol_get_version (_tmp1012_);
	_tmp1014_ = _tmp1013_;
	_tmp1015_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1016_ = _tmp1015_;
	vala_version_attribute_check (_tmp1014_, _tmp1016_);
	_tmp1018_ = access;
	if (_tmp1018_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1019_;
		ValaSymbol* _tmp1020_;
		ValaSymbol* _tmp1021_;
		_tmp1019_ = member;
		_tmp1020_ = vala_symbol_get_parent_symbol (_tmp1019_);
		_tmp1021_ = _tmp1020_;
		_tmp1017_ = VALA_IS_TYPESYMBOL (_tmp1021_);
	} else {
		_tmp1017_ = FALSE;
	}
	if (_tmp1017_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1022_;
		ValaSymbol* _tmp1023_;
		ValaSymbol* _tmp1024_;
		ValaTypeSymbol* _tmp1025_;
		gboolean in_subtype = FALSE;
		_tmp1022_ = member;
		_tmp1023_ = vala_symbol_get_parent_symbol (_tmp1022_);
		_tmp1024_ = _tmp1023_;
		_tmp1025_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1024_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1025_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1026_;
			ValaSemanticAnalyzer* _tmp1027_;
			ValaSymbol* _tmp1028_;
			ValaSymbol* _tmp1029_;
			ValaSymbol* _tmp1030_;
			_tmp1026_ = vala_code_context_get_analyzer (context);
			_tmp1027_ = _tmp1026_;
			_tmp1028_ = vala_semantic_analyzer_get_current_symbol (_tmp1027_);
			_tmp1029_ = _tmp1028_;
			_tmp1030_ = _vala_code_node_ref0 (_tmp1029_);
			this_symbol = _tmp1030_;
			{
				gboolean _tmp1031_ = FALSE;
				_tmp1031_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1036_;
					ValaSymbol* _tmp1037_;
					ValaTypeSymbol* _tmp1038_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1039_;
					ValaClass* _tmp1040_;
					gboolean _tmp1041_ = FALSE;
					ValaClass* _tmp1042_;
					if (!_tmp1031_) {
						ValaSymbol* _tmp1032_;
						ValaSymbol* _tmp1033_;
						ValaSymbol* _tmp1034_;
						ValaSymbol* _tmp1035_;
						_tmp1032_ = this_symbol;
						_tmp1033_ = vala_symbol_get_parent_symbol (_tmp1032_);
						_tmp1034_ = _tmp1033_;
						_tmp1035_ = _vala_code_node_ref0 (_tmp1034_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1035_;
					}
					_tmp1031_ = FALSE;
					_tmp1036_ = this_symbol;
					if (!(_tmp1036_ != NULL)) {
						break;
					}
					_tmp1037_ = this_symbol;
					_tmp1038_ = target_type;
					if (_tmp1037_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1038_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1039_ = this_symbol;
					_tmp1040_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1039_) ? ((ValaClass*) _tmp1039_) : NULL);
					cl = _tmp1040_;
					_tmp1042_ = cl;
					if (_tmp1042_ != NULL) {
						ValaClass* _tmp1043_;
						ValaTypeSymbol* _tmp1044_;
						_tmp1043_ = cl;
						_tmp1044_ = target_type;
						_tmp1041_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1043_, _tmp1044_);
					} else {
						_tmp1041_ = FALSE;
					}
					if (_tmp1041_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1045_;
			ValaSourceReference* _tmp1046_;
			ValaSymbol* _tmp1047_;
			gchar* _tmp1048_;
			gchar* _tmp1049_;
			gchar* _tmp1050_;
			gchar* _tmp1051_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1045_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1046_ = _tmp1045_;
			_tmp1047_ = member;
			_tmp1048_ = vala_symbol_get_full_name (_tmp1047_);
			_tmp1049_ = _tmp1048_;
			_tmp1050_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1049_);
			_tmp1051_ = _tmp1050_;
			vala_report_error (_tmp1046_, _tmp1051_);
			_g_free0 (_tmp1051_);
			_g_free0 (_tmp1049_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1052_;
		_tmp1052_ = access;
		if (_tmp1052_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1053_;
			ValaSymbol* _tmp1054_;
			ValaSymbol* _tmp1055_;
			ValaSymbol* _tmp1056_;
			gboolean in_target_type = FALSE;
			_tmp1053_ = member;
			_tmp1054_ = vala_symbol_get_parent_symbol (_tmp1053_);
			_tmp1055_ = _tmp1054_;
			_tmp1056_ = _vala_code_node_ref0 (_tmp1055_);
			target_type = _tmp1056_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1057_;
				ValaSemanticAnalyzer* _tmp1058_;
				ValaSymbol* _tmp1059_;
				ValaSymbol* _tmp1060_;
				ValaSymbol* _tmp1061_;
				_tmp1057_ = vala_code_context_get_analyzer (context);
				_tmp1058_ = _tmp1057_;
				_tmp1059_ = vala_semantic_analyzer_get_current_symbol (_tmp1058_);
				_tmp1060_ = _tmp1059_;
				_tmp1061_ = _vala_code_node_ref0 (_tmp1060_);
				this_symbol = _tmp1061_;
				{
					gboolean _tmp1062_ = FALSE;
					_tmp1062_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1067_;
						ValaSymbol* _tmp1068_;
						ValaSymbol* _tmp1069_;
						if (!_tmp1062_) {
							ValaSymbol* _tmp1063_;
							ValaSymbol* _tmp1064_;
							ValaSymbol* _tmp1065_;
							ValaSymbol* _tmp1066_;
							_tmp1063_ = this_symbol;
							_tmp1064_ = vala_symbol_get_parent_symbol (_tmp1063_);
							_tmp1065_ = _tmp1064_;
							_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1066_;
						}
						_tmp1062_ = FALSE;
						_tmp1067_ = this_symbol;
						if (!(_tmp1067_ != NULL)) {
							break;
						}
						_tmp1068_ = target_type;
						_tmp1069_ = this_symbol;
						if (_tmp1068_ == _tmp1069_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1070_;
				ValaSourceReference* _tmp1071_;
				ValaSymbol* _tmp1072_;
				gchar* _tmp1073_;
				gchar* _tmp1074_;
				gchar* _tmp1075_;
				gchar* _tmp1076_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1070_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = member;
				_tmp1073_ = vala_symbol_get_full_name (_tmp1072_);
				_tmp1074_ = _tmp1073_;
				_tmp1075_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1074_);
				_tmp1076_ = _tmp1075_;
				vala_report_error (_tmp1071_, _tmp1076_);
				_g_free0 (_tmp1076_);
				_g_free0 (_tmp1074_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1078_;
		ValaExpression* _tmp1079_;
		_tmp1078_ = vala_member_access_get_inner (self);
		_tmp1079_ = _tmp1078_;
		_tmp1077_ = _tmp1079_ != NULL;
	} else {
		_tmp1077_ = FALSE;
	}
	if (_tmp1077_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1080_;
		ValaExpression* _tmp1081_;
		ValaDataType* _tmp1082_;
		ValaDataType* _tmp1083_;
		ValaDataType* _tmp1084_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1085_;
		ValaExpression* _tmp1086_;
		ValaDataType* _tmp1087_;
		ValaDataType* _tmp1088_;
		ValaPointerType* _tmp1089_;
		ValaPointerType* _tmp1090_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1095_;
		ValaObjectType* _tmp1096_;
		gboolean _tmp1097_ = FALSE;
		gboolean _tmp1098_ = FALSE;
		ValaObjectType* _tmp1099_;
		_tmp1080_ = vala_member_access_get_inner (self);
		_tmp1081_ = _tmp1080_;
		_tmp1082_ = vala_expression_get_value_type (_tmp1081_);
		_tmp1083_ = _tmp1082_;
		_tmp1084_ = _vala_code_node_ref0 (_tmp1083_);
		instance_type = _tmp1084_;
		_tmp1085_ = vala_member_access_get_inner (self);
		_tmp1086_ = _tmp1085_;
		_tmp1087_ = vala_expression_get_value_type (_tmp1086_);
		_tmp1088_ = _tmp1087_;
		_tmp1089_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1088_) ? ((ValaPointerType*) _tmp1088_) : NULL);
		pointer_type = _tmp1089_;
		_tmp1090_ = pointer_type;
		if (_tmp1090_ != NULL) {
			ValaPointerType* _tmp1091_;
			ValaDataType* _tmp1092_;
			ValaDataType* _tmp1093_;
			ValaDataType* _tmp1094_;
			_tmp1091_ = pointer_type;
			_tmp1092_ = vala_pointer_type_get_base_type (_tmp1091_);
			_tmp1093_ = _tmp1092_;
			_tmp1094_ = _vala_code_node_ref0 (_tmp1093_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1094_;
		}
		_tmp1095_ = instance_type;
		_tmp1096_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1095_) ? ((ValaObjectType*) _tmp1095_) : NULL);
		object_type = _tmp1096_;
		_tmp1099_ = object_type;
		if (_tmp1099_ != NULL) {
			ValaObjectType* _tmp1100_;
			ValaObjectTypeSymbol* _tmp1101_;
			ValaObjectTypeSymbol* _tmp1102_;
			_tmp1100_ = object_type;
			_tmp1101_ = vala_object_type_get_type_symbol (_tmp1100_);
			_tmp1102_ = _tmp1101_;
			_tmp1098_ = vala_object_type_symbol_has_type_parameters (_tmp1102_);
		} else {
			_tmp1098_ = FALSE;
		}
		if (_tmp1098_) {
			ValaDataType* _tmp1103_;
			_tmp1103_ = instance_type;
			_tmp1097_ = !vala_data_type_has_type_arguments (_tmp1103_);
		} else {
			_tmp1097_ = FALSE;
		}
		if (_tmp1097_) {
			ValaExpression* _tmp1104_;
			ValaExpression* _tmp1105_;
			ValaSourceReference* _tmp1106_;
			ValaSourceReference* _tmp1107_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1104_ = vala_member_access_get_inner (self);
			_tmp1105_ = _tmp1104_;
			_tmp1106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1105_);
			_tmp1107_ = _tmp1106_;
			vala_report_error (_tmp1107_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1109_ = !may_access_instance_members;
	} else {
		_tmp1109_ = FALSE;
	}
	if (_tmp1109_) {
		_tmp1108_ = TRUE;
	} else {
		gboolean _tmp1110_ = FALSE;
		if (klass) {
			_tmp1110_ = !may_access_klass_members;
		} else {
			_tmp1110_ = FALSE;
		}
		_tmp1108_ = _tmp1110_;
	}
	if (_tmp1108_) {
		ValaSymbol* _tmp1111_;
		ValaSymbol* _tmp1112_;
		ValaDataType* _tmp1135_;
		ValaDataType* _tmp1136_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1112_ = _tmp1111_;
		if (VALA_IS_METHOD (_tmp1112_)) {
			ValaSemanticAnalyzer* _tmp1113_;
			ValaSemanticAnalyzer* _tmp1114_;
			ValaSymbol* _tmp1115_;
			ValaSymbol* _tmp1116_;
			gboolean _tmp1117_;
			gboolean _tmp1118_;
			ValaDataType* _tmp1119_;
			ValaDataType* _tmp1120_;
			_tmp1113_ = vala_code_context_get_analyzer (context);
			_tmp1114_ = _tmp1113_;
			_tmp1115_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1116_ = _tmp1115_;
			_tmp1117_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1118_ = _tmp1117_;
			_tmp1119_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1114_, _tmp1116_, _tmp1118_);
			_tmp1120_ = _tmp1119_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1120_);
			_vala_code_node_unref0 (_tmp1120_);
		} else {
			ValaSymbol* _tmp1121_;
			ValaSymbol* _tmp1122_;
			_tmp1121_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1122_ = _tmp1121_;
			if (VALA_IS_FIELD (_tmp1122_)) {
				ValaSymbol* _tmp1123_;
				ValaSymbol* _tmp1124_;
				ValaFieldPrototype* _tmp1125_;
				ValaFieldPrototype* _tmp1126_;
				_tmp1123_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1124_ = _tmp1123_;
				_tmp1125_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1124_, VALA_TYPE_FIELD, ValaField));
				_tmp1126_ = _tmp1125_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1126_);
				_vala_code_node_unref0 (_tmp1126_);
			} else {
				ValaSymbol* _tmp1127_;
				ValaSymbol* _tmp1128_;
				_tmp1127_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1128_ = _tmp1127_;
				if (VALA_IS_PROPERTY (_tmp1128_)) {
					ValaSymbol* _tmp1129_;
					ValaSymbol* _tmp1130_;
					ValaPropertyPrototype* _tmp1131_;
					ValaPropertyPrototype* _tmp1132_;
					_tmp1129_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1130_ = _tmp1129_;
					_tmp1131_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1130_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1132_ = _tmp1131_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1132_);
					_vala_code_node_unref0 (_tmp1132_);
				} else {
					ValaInvalidType* _tmp1133_;
					ValaInvalidType* _tmp1134_;
					_tmp1133_ = vala_invalid_type_new ();
					_tmp1134_ = _tmp1133_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1134_);
					_vala_code_node_unref0 (_tmp1134_);
				}
			}
		}
		_tmp1135_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1136_ = _tmp1135_;
		if (_tmp1136_ != NULL) {
			ValaDataType* _tmp1137_;
			ValaDataType* _tmp1138_;
			ValaDataType* _tmp1139_;
			ValaDataType* _tmp1140_;
			gboolean _tmp1141_;
			gboolean _tmp1142_;
			_tmp1137_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1138_ = _tmp1137_;
			_tmp1139_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1140_ = _tmp1139_;
			_tmp1141_ = vala_data_type_get_value_owned (_tmp1140_);
			_tmp1142_ = _tmp1141_;
			vala_data_type_set_value_owned (_tmp1138_, _tmp1142_);
		}
	} else {
		gboolean _tmp1143_ = FALSE;
		gboolean _tmp1164_ = FALSE;
		gboolean _tmp1165_ = FALSE;
		gboolean _tmp1166_ = FALSE;
		gboolean _tmp1167_ = FALSE;
		gboolean _tmp1184_ = FALSE;
		gboolean _tmp1185_ = FALSE;
		gboolean _tmp1186_ = FALSE;
		gboolean _tmp1187_ = FALSE;
		gboolean _tmp1188_ = FALSE;
		gboolean _tmp1189_;
		gboolean _tmp1190_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1217_;
		ValaSymbol* _tmp1218_;
		ValaMethod* _tmp1219_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1220_;
		ValaExpression* _tmp1221_;
		ValaMemberAccess* _tmp1222_;
		gboolean _tmp1223_ = FALSE;
		gboolean _tmp1224_ = FALSE;
		gboolean _tmp1225_ = FALSE;
		gboolean _tmp1226_ = FALSE;
		gboolean _tmp1227_ = FALSE;
		ValaMethod* _tmp1228_;
		ValaSemanticAnalyzer* _tmp1265_;
		ValaSemanticAnalyzer* _tmp1266_;
		ValaSymbol* _tmp1267_;
		ValaSymbol* _tmp1268_;
		gboolean _tmp1269_;
		gboolean _tmp1270_;
		ValaDataType* _tmp1271_;
		ValaDataType* _tmp1272_;
		gboolean _tmp1273_ = FALSE;
		ValaExpression* _tmp1274_;
		ValaExpression* _tmp1275_;
		ValaSymbol* _tmp1288_;
		ValaSymbol* _tmp1289_;
		if (instance) {
			ValaExpression* _tmp1144_;
			ValaExpression* _tmp1145_;
			_tmp1144_ = vala_member_access_get_inner (self);
			_tmp1145_ = _tmp1144_;
			_tmp1143_ = _tmp1145_ == NULL;
		} else {
			_tmp1143_ = FALSE;
		}
		if (_tmp1143_) {
			ValaSourceReference* _tmp1146_;
			ValaSourceReference* _tmp1147_;
			ValaMemberAccess* _tmp1148_;
			ValaMemberAccess* _tmp1149_;
			ValaExpression* _tmp1150_;
			ValaExpression* _tmp1151_;
			ValaParameter* _tmp1152_;
			ValaDataType* _tmp1153_;
			ValaDataType* _tmp1154_;
			ValaDataType* _tmp1155_;
			ValaDataType* _tmp1156_;
			ValaExpression* _tmp1157_;
			ValaExpression* _tmp1158_;
			ValaDataType* _tmp1159_;
			ValaDataType* _tmp1160_;
			ValaExpression* _tmp1161_;
			ValaExpression* _tmp1162_;
			ValaParameter* _tmp1163_;
			_tmp1146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1147_ = _tmp1146_;
			_tmp1148_ = vala_member_access_new (NULL, "this", _tmp1147_);
			_tmp1149_ = _tmp1148_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1149_);
			_vala_code_node_unref0 (_tmp1149_);
			_tmp1150_ = vala_member_access_get_inner (self);
			_tmp1151_ = _tmp1150_;
			_tmp1152_ = this_parameter;
			_tmp1153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1152_);
			_tmp1154_ = _tmp1153_;
			_tmp1155_ = vala_data_type_copy (_tmp1154_);
			_tmp1156_ = _tmp1155_;
			vala_expression_set_value_type (_tmp1151_, _tmp1156_);
			_vala_code_node_unref0 (_tmp1156_);
			_tmp1157_ = vala_member_access_get_inner (self);
			_tmp1158_ = _tmp1157_;
			_tmp1159_ = vala_expression_get_value_type (_tmp1158_);
			_tmp1160_ = _tmp1159_;
			vala_data_type_set_value_owned (_tmp1160_, FALSE);
			_tmp1161_ = vala_member_access_get_inner (self);
			_tmp1162_ = _tmp1161_;
			_tmp1163_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1162_, (ValaSymbol*) _tmp1163_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1167_ = !klass;
		} else {
			_tmp1167_ = FALSE;
		}
		if (_tmp1167_) {
			ValaSymbol* _tmp1168_;
			ValaSymbol* _tmp1169_;
			_tmp1168_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1169_ = _tmp1168_;
			_tmp1166_ = !VALA_IS_CREATION_METHOD (_tmp1169_);
		} else {
			_tmp1166_ = FALSE;
		}
		if (_tmp1166_) {
			_tmp1165_ = may_access_instance_members;
		} else {
			_tmp1165_ = FALSE;
		}
		if (_tmp1165_) {
			ValaExpression* _tmp1170_;
			ValaExpression* _tmp1171_;
			_tmp1170_ = vala_member_access_get_inner (self);
			_tmp1171_ = _tmp1170_;
			_tmp1164_ = _tmp1171_ != NULL;
		} else {
			_tmp1164_ = FALSE;
		}
		if (_tmp1164_) {
			ValaExpression* _tmp1172_;
			ValaExpression* _tmp1173_;
			ValaSymbol* _tmp1174_;
			ValaSymbol* _tmp1175_;
			_tmp1172_ = vala_member_access_get_inner (self);
			_tmp1173_ = _tmp1172_;
			_tmp1174_ = vala_expression_get_symbol_reference (_tmp1173_);
			_tmp1175_ = _tmp1174_;
			if (VALA_IS_METHOD (_tmp1175_)) {
			} else {
				ValaSourceReference* _tmp1176_;
				ValaSourceReference* _tmp1177_;
				ValaSymbol* _tmp1178_;
				ValaSymbol* _tmp1179_;
				gchar* _tmp1180_;
				gchar* _tmp1181_;
				gchar* _tmp1182_;
				gchar* _tmp1183_;
				_tmp1176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1177_ = _tmp1176_;
				_tmp1178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1179_ = _tmp1178_;
				_tmp1180_ = vala_symbol_get_full_name (_tmp1179_);
				_tmp1181_ = _tmp1180_;
				_tmp1182_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1181_);
				_tmp1183_ = _tmp1182_;
				vala_report_warning (_tmp1177_, _tmp1183_);
				_g_free0 (_tmp1183_);
				_g_free0 (_tmp1181_);
			}
		}
		_tmp1189_ = vala_code_context_get_experimental_non_null (context);
		_tmp1190_ = _tmp1189_;
		if (_tmp1190_) {
			_tmp1188_ = instance;
		} else {
			_tmp1188_ = FALSE;
		}
		if (_tmp1188_) {
			ValaExpression* _tmp1191_;
			ValaExpression* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaDataType* _tmp1194_;
			gboolean _tmp1195_;
			gboolean _tmp1196_;
			_tmp1191_ = vala_member_access_get_inner (self);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_expression_get_value_type (_tmp1192_);
			_tmp1194_ = _tmp1193_;
			_tmp1195_ = vala_data_type_get_nullable (_tmp1194_);
			_tmp1196_ = _tmp1195_;
			_tmp1187_ = _tmp1196_;
		} else {
			_tmp1187_ = FALSE;
		}
		if (_tmp1187_) {
			ValaExpression* _tmp1197_;
			ValaExpression* _tmp1198_;
			ValaDataType* _tmp1199_;
			ValaDataType* _tmp1200_;
			_tmp1197_ = vala_member_access_get_inner (self);
			_tmp1198_ = _tmp1197_;
			_tmp1199_ = vala_expression_get_value_type (_tmp1198_);
			_tmp1200_ = _tmp1199_;
			_tmp1186_ = !VALA_IS_POINTER_TYPE (_tmp1200_);
		} else {
			_tmp1186_ = FALSE;
		}
		if (_tmp1186_) {
			ValaExpression* _tmp1201_;
			ValaExpression* _tmp1202_;
			ValaDataType* _tmp1203_;
			ValaDataType* _tmp1204_;
			_tmp1201_ = vala_member_access_get_inner (self);
			_tmp1202_ = _tmp1201_;
			_tmp1203_ = vala_expression_get_value_type (_tmp1202_);
			_tmp1204_ = _tmp1203_;
			_tmp1185_ = !VALA_IS_GENERIC_TYPE (_tmp1204_);
		} else {
			_tmp1185_ = FALSE;
		}
		if (_tmp1185_) {
			ValaExpression* _tmp1205_;
			ValaExpression* _tmp1206_;
			ValaDataType* _tmp1207_;
			ValaDataType* _tmp1208_;
			_tmp1205_ = vala_member_access_get_inner (self);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = vala_expression_get_value_type (_tmp1206_);
			_tmp1208_ = _tmp1207_;
			_tmp1184_ = !VALA_IS_ARRAY_TYPE (_tmp1208_);
		} else {
			_tmp1184_ = FALSE;
		}
		if (_tmp1184_) {
			ValaSourceReference* _tmp1209_;
			ValaSourceReference* _tmp1210_;
			ValaSymbol* _tmp1211_;
			ValaSymbol* _tmp1212_;
			gchar* _tmp1213_;
			gchar* _tmp1214_;
			gchar* _tmp1215_;
			gchar* _tmp1216_;
			_tmp1209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1210_ = _tmp1209_;
			_tmp1211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1212_ = _tmp1211_;
			_tmp1213_ = vala_symbol_get_full_name (_tmp1212_);
			_tmp1214_ = _tmp1213_;
			_tmp1215_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1214_);
			_tmp1216_ = _tmp1215_;
			vala_report_error (_tmp1210_, _tmp1216_);
			_g_free0 (_tmp1216_);
			_g_free0 (_tmp1214_);
		}
		_tmp1217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1218_ = _tmp1217_;
		_tmp1219_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1218_) ? ((ValaMethod*) _tmp1218_) : NULL);
		m = _tmp1219_;
		_tmp1220_ = vala_member_access_get_inner (self);
		_tmp1221_ = _tmp1220_;
		_tmp1222_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1221_) ? ((ValaMemberAccess*) _tmp1221_) : NULL);
		inner_ma = _tmp1222_;
		_tmp1228_ = m;
		if (_tmp1228_ != NULL) {
			ValaMethod* _tmp1229_;
			ValaMemberBinding _tmp1230_;
			ValaMemberBinding _tmp1231_;
			_tmp1229_ = m;
			_tmp1230_ = vala_method_get_binding (_tmp1229_);
			_tmp1231_ = _tmp1230_;
			_tmp1227_ = _tmp1231_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1227_ = FALSE;
		}
		if (_tmp1227_) {
			ValaMethod* _tmp1232_;
			ValaSymbol* _tmp1233_;
			ValaSymbol* _tmp1234_;
			_tmp1232_ = m;
			_tmp1233_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1232_);
			_tmp1234_ = _tmp1233_;
			_tmp1226_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1234_);
		} else {
			_tmp1226_ = FALSE;
		}
		if (_tmp1226_) {
			ValaExpression* _tmp1235_;
			ValaExpression* _tmp1236_;
			_tmp1235_ = vala_member_access_get_inner (self);
			_tmp1236_ = _tmp1235_;
			_tmp1225_ = _tmp1236_ != NULL;
		} else {
			_tmp1225_ = FALSE;
		}
		if (_tmp1225_) {
			ValaExpression* _tmp1237_;
			ValaExpression* _tmp1238_;
			ValaDataType* _tmp1239_;
			ValaDataType* _tmp1240_;
			_tmp1237_ = vala_member_access_get_inner (self);
			_tmp1238_ = _tmp1237_;
			_tmp1239_ = vala_expression_get_value_type (_tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1224_ = _tmp1240_ == NULL;
		} else {
			_tmp1224_ = FALSE;
		}
		if (_tmp1224_) {
			ValaMemberAccess* _tmp1241_;
			ValaList* _tmp1242_;
			gint _tmp1243_;
			gint _tmp1244_;
			_tmp1241_ = inner_ma;
			_tmp1242_ = _tmp1241_->priv->type_argument_list;
			_tmp1243_ = vala_collection_get_size ((ValaCollection*) _tmp1242_);
			_tmp1244_ = _tmp1243_;
			_tmp1223_ = _tmp1244_ > 0;
		} else {
			_tmp1223_ = FALSE;
		}
		if (_tmp1223_) {
			ValaExpression* _tmp1245_;
			ValaExpression* _tmp1246_;
			ValaMethod* _tmp1247_;
			ValaSymbol* _tmp1248_;
			ValaSymbol* _tmp1249_;
			ValaObjectType* _tmp1250_;
			ValaObjectType* _tmp1251_;
			_tmp1245_ = vala_member_access_get_inner (self);
			_tmp1246_ = _tmp1245_;
			_tmp1247_ = m;
			_tmp1248_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1247_);
			_tmp1249_ = _tmp1248_;
			_tmp1250_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1249_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1251_ = _tmp1250_;
			vala_expression_set_value_type (_tmp1246_, (ValaDataType*) _tmp1251_);
			_vala_code_node_unref0 (_tmp1251_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1252_;
				ValaList* _tmp1253_;
				ValaList* _tmp1254_;
				gint _type_argument_size = 0;
				ValaList* _tmp1255_;
				gint _tmp1256_;
				gint _tmp1257_;
				gint _type_argument_index = 0;
				_tmp1252_ = inner_ma;
				_tmp1253_ = _tmp1252_->priv->type_argument_list;
				_tmp1254_ = _vala_iterable_ref0 (_tmp1253_);
				_type_argument_list = _tmp1254_;
				_tmp1255_ = _type_argument_list;
				_tmp1256_ = vala_collection_get_size ((ValaCollection*) _tmp1255_);
				_tmp1257_ = _tmp1256_;
				_type_argument_size = _tmp1257_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1258_;
					gpointer _tmp1259_;
					ValaExpression* _tmp1260_;
					ValaExpression* _tmp1261_;
					ValaDataType* _tmp1262_;
					ValaDataType* _tmp1263_;
					ValaDataType* _tmp1264_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1258_ = _type_argument_list;
					_tmp1259_ = vala_list_get (_tmp1258_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1259_;
					_tmp1260_ = vala_member_access_get_inner (self);
					_tmp1261_ = _tmp1260_;
					_tmp1262_ = vala_expression_get_value_type (_tmp1261_);
					_tmp1263_ = _tmp1262_;
					_tmp1264_ = type_argument;
					vala_data_type_add_type_argument (_tmp1263_, _tmp1264_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1265_ = vala_code_context_get_analyzer (context);
		_tmp1266_ = _tmp1265_;
		_tmp1267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1268_ = _tmp1267_;
		_tmp1269_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1270_ = _tmp1269_;
		_tmp1271_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1266_, _tmp1268_, _tmp1270_);
		_tmp1272_ = _tmp1271_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1272_);
		_vala_code_node_unref0 (_tmp1272_);
		_tmp1274_ = vala_member_access_get_inner (self);
		_tmp1275_ = _tmp1274_;
		if (_tmp1275_ != NULL) {
			ValaDataType* _tmp1276_;
			ValaDataType* _tmp1277_;
			_tmp1276_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1277_ = _tmp1276_;
			_tmp1273_ = _tmp1277_ != NULL;
		} else {
			_tmp1273_ = FALSE;
		}
		if (_tmp1273_) {
			ValaDataType* _tmp1278_;
			ValaDataType* _tmp1279_;
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaDataType* _tmp1282_;
			ValaDataType* _tmp1283_;
			ValaDataType* _tmp1284_;
			ValaDataType* _tmp1285_;
			_tmp1278_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1279_ = _tmp1278_;
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_expression_get_value_type (_tmp1281_);
			_tmp1283_ = _tmp1282_;
			_tmp1284_ = vala_data_type_get_actual_type (_tmp1279_, _tmp1283_, NULL, (ValaCodeNode*) self);
			_tmp1285_ = _tmp1284_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1285_);
			_vala_code_node_unref0 (_tmp1285_);
		} else {
			ValaDataType* _tmp1286_;
			ValaDataType* _tmp1287_;
			_tmp1286_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1287_ = _tmp1286_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1287_);
		}
		_tmp1288_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1289_ = _tmp1288_;
		if (VALA_IS_METHOD (_tmp1289_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1290_;
			ValaSymbol* _tmp1291_;
			ValaMethod* _tmp1292_;
			ValaDataType* _tmp1293_;
			ValaDataType* _tmp1294_;
			gboolean _tmp1301_ = FALSE;
			_tmp1290_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1291_ = _tmp1290_;
			_tmp1292_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1291_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1292_;
			_tmp1293_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1294_ = _tmp1293_;
			if (_tmp1294_ != NULL) {
				ValaDataType* _tmp1295_;
				ValaDataType* _tmp1296_;
				ValaDataType* _tmp1297_;
				ValaDataType* _tmp1298_;
				gboolean _tmp1299_;
				gboolean _tmp1300_;
				_tmp1295_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1296_ = _tmp1295_;
				_tmp1297_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1298_ = _tmp1297_;
				_tmp1299_ = vala_data_type_get_value_owned (_tmp1298_);
				_tmp1300_ = _tmp1299_;
				vala_data_type_set_value_owned (_tmp1296_, _tmp1300_);
			}
			if (instance) {
				ValaMethod* _tmp1302_;
				ValaSymbol* _tmp1303_;
				ValaSymbol* _tmp1304_;
				_tmp1302_ = method;
				_tmp1303_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1302_);
				_tmp1304_ = _tmp1303_;
				_tmp1301_ = VALA_IS_TYPESYMBOL (_tmp1304_);
			} else {
				_tmp1301_ = FALSE;
			}
			if (_tmp1301_) {
				ValaExpression* _tmp1305_;
				ValaExpression* _tmp1306_;
				ValaMethod* _tmp1307_;
				ValaSymbol* _tmp1308_;
				ValaSymbol* _tmp1309_;
				ValaDataType* _tmp1310_;
				ValaDataType* _tmp1311_;
				ValaExpression* _tmp1312_;
				ValaExpression* _tmp1313_;
				ValaDataType* _tmp1314_;
				ValaDataType* _tmp1315_;
				ValaMethod* _tmp1316_;
				ValaParameter* _tmp1317_;
				ValaParameter* _tmp1318_;
				ValaDataType* _tmp1319_;
				ValaDataType* _tmp1320_;
				gboolean _tmp1321_;
				gboolean _tmp1322_;
				_tmp1305_ = vala_member_access_get_inner (self);
				_tmp1306_ = _tmp1305_;
				_tmp1307_ = method;
				_tmp1308_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1307_);
				_tmp1309_ = _tmp1308_;
				_tmp1310_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1309_);
				_tmp1311_ = _tmp1310_;
				vala_expression_set_target_type (_tmp1306_, _tmp1311_);
				_vala_code_node_unref0 (_tmp1311_);
				_tmp1312_ = vala_member_access_get_inner (self);
				_tmp1313_ = _tmp1312_;
				_tmp1314_ = vala_expression_get_target_type (_tmp1313_);
				_tmp1315_ = _tmp1314_;
				_tmp1316_ = method;
				_tmp1317_ = vala_method_get_this_parameter (_tmp1316_);
				_tmp1318_ = _tmp1317_;
				_tmp1319_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1318_);
				_tmp1320_ = _tmp1319_;
				_tmp1321_ = vala_data_type_get_value_owned (_tmp1320_);
				_tmp1322_ = _tmp1321_;
				vala_data_type_set_value_owned (_tmp1315_, _tmp1322_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1323_;
			ValaSymbol* _tmp1324_;
			_tmp1323_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1324_ = _tmp1323_;
			if (VALA_IS_PROPERTY (_tmp1324_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1325_;
				ValaSymbol* _tmp1326_;
				ValaProperty* _tmp1327_;
				gboolean _tmp1328_ = FALSE;
				_tmp1325_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1326_ = _tmp1325_;
				_tmp1327_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1326_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1327_;
				if (instance) {
					ValaProperty* _tmp1329_;
					ValaSymbol* _tmp1330_;
					ValaSymbol* _tmp1331_;
					_tmp1329_ = prop;
					_tmp1330_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1329_);
					_tmp1331_ = _tmp1330_;
					_tmp1328_ = _tmp1331_ != NULL;
				} else {
					_tmp1328_ = FALSE;
				}
				if (_tmp1328_) {
					ValaExpression* _tmp1332_;
					ValaExpression* _tmp1333_;
					ValaProperty* _tmp1334_;
					ValaSymbol* _tmp1335_;
					ValaSymbol* _tmp1336_;
					ValaDataType* _tmp1337_;
					ValaDataType* _tmp1338_;
					_tmp1332_ = vala_member_access_get_inner (self);
					_tmp1333_ = _tmp1332_;
					_tmp1334_ = prop;
					_tmp1335_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1334_);
					_tmp1336_ = _tmp1335_;
					_tmp1337_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1336_);
					_tmp1338_ = _tmp1337_;
					vala_expression_set_target_type (_tmp1333_, _tmp1338_);
					_vala_code_node_unref0 (_tmp1338_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1339_ = FALSE;
				gboolean _tmp1340_ = FALSE;
				gboolean _tmp1341_ = FALSE;
				ValaSymbol* _tmp1342_;
				ValaSymbol* _tmp1343_;
				_tmp1342_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1343_ = _tmp1342_;
				if (VALA_IS_FIELD (_tmp1343_)) {
					_tmp1341_ = TRUE;
				} else {
					ValaSymbol* _tmp1344_;
					ValaSymbol* _tmp1345_;
					_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1345_ = _tmp1344_;
					_tmp1341_ = VALA_IS_SIGNAL (_tmp1345_);
				}
				if (_tmp1341_) {
					_tmp1340_ = instance;
				} else {
					_tmp1340_ = FALSE;
				}
				if (_tmp1340_) {
					ValaSymbol* _tmp1346_;
					ValaSymbol* _tmp1347_;
					ValaSymbol* _tmp1348_;
					ValaSymbol* _tmp1349_;
					_tmp1346_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1347_ = _tmp1346_;
					_tmp1348_ = vala_symbol_get_parent_symbol (_tmp1347_);
					_tmp1349_ = _tmp1348_;
					_tmp1339_ = _tmp1349_ != NULL;
				} else {
					_tmp1339_ = FALSE;
				}
				if (_tmp1339_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1350_;
					ValaSymbol* _tmp1351_;
					ValaSymbol* _tmp1352_;
					ValaSymbol* _tmp1353_;
					ValaDataType* _tmp1354_;
					ValaExpression* _tmp1355_;
					ValaExpression* _tmp1356_;
					ValaDataType* _tmp1357_;
					ValaExpression* _tmp1358_;
					ValaExpression* _tmp1359_;
					ValaDataType* _tmp1360_;
					ValaDataType* _tmp1361_;
					ValaDataType* _tmp1362_;
					ValaDataType* _tmp1363_;
					_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1351_ = _tmp1350_;
					_tmp1352_ = vala_symbol_get_parent_symbol (_tmp1351_);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1353_);
					parent_type = _tmp1354_;
					_tmp1355_ = vala_member_access_get_inner (self);
					_tmp1356_ = _tmp1355_;
					_tmp1357_ = parent_type;
					_tmp1358_ = vala_member_access_get_inner (self);
					_tmp1359_ = _tmp1358_;
					_tmp1360_ = vala_expression_get_value_type (_tmp1359_);
					_tmp1361_ = _tmp1360_;
					_tmp1362_ = vala_data_type_get_actual_type (_tmp1357_, _tmp1361_, NULL, (ValaCodeNode*) self);
					_tmp1363_ = _tmp1362_;
					vala_expression_set_target_type (_tmp1356_, _tmp1363_);
					_vala_code_node_unref0 (_tmp1363_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1364_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1365_ = _tmp1364_;
	if (_tmp1365_ != NULL) {
		ValaDataType* _tmp1366_;
		ValaDataType* _tmp1367_;
		_tmp1366_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1367_ = _tmp1366_;
		vala_code_node_check ((ValaCodeNode*) _tmp1367_, context);
	}
	_tmp1368_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1369_ = _tmp1368_;
	result = !_tmp1369_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

