/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};

static gint ValaCompiler_private_offset;
static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gboolean vala_compiler_abi_stability;
static gboolean vala_compiler_abi_stability = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args;
static gchar* vala_compiler_run_args = NULL;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_deprecated (const gchar* option_name,
                                          const gchar* val,
                                          void* data,
                                          GError** error);
static gboolean vala_compiler_option_parse_color (const gchar* option_name,
                                           const gchar* val,
                                           void* data,
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args,
                               gint args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GPid pid,
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid,
                                     gint status,
                                     gpointer self);
static gint vala_compiler_main (gchar** args,
                         gint args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[60] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executeable", NULL}, {"abi-stability", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_abi_stability, "Enable support for ABI stability", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_compiler_get_instance_private (ValaCompiler* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCompiler_private_offset);
}

static gboolean
vala_compiler_option_parse_color (const gchar* option_name,
                                  const gchar* val,
                                  void* data,
                                  GError** error)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_deprecated (const gchar* option_name,
                                 const gchar* val,
                                 void* data,
                                 GError** error)
{
	gboolean result = FALSE;
	FILE* _tmp0_;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_compiler_quit (ValaCompiler* self)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp11_ = vala_report_get_warnings (_tmp14_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			_tmp15_ = stdout;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp18_));
		}
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaReport* _tmp21_;
			ValaReport* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			_tmp19_ = stdout;
			_tmp20_ = self->priv->context;
			_tmp21_ = vala_code_context_get_report (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			fprintf (_tmp19_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp22_), vala_report_get_warnings (_tmp25_));
		}
		result = 1;
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_compiler_run (ValaCompiler* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReportColored _tmp2_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValaCodeContext* _tmp26_;
	ValaCodeContext* _tmp27_;
	ValaCodeContext* _tmp28_;
	ValaCodeContext* _tmp29_;
	ValaCodeContext* _tmp30_;
	ValaCodeContext* _tmp31_;
	ValaCodeContext* _tmp32_;
	ValaCodeContext* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaReport* _tmp35_;
	ValaReport* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaReport* _tmp38_;
	ValaReport* _tmp39_;
	ValaCodeContext* _tmp40_;
	ValaCodeContext* _tmp41_;
	ValaCodeContext* _tmp42_;
	gboolean _tmp43_ = FALSE;
	ValaCodeContext* _tmp45_;
	ValaCodeContext* _tmp46_;
	ValaCodeContext* _tmp47_;
	const gchar* _tmp48_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	ValaCodeContext* _tmp51_;
	ValaCodeContext* _tmp52_;
	const gchar* _tmp53_;
	ValaCodeContext* _tmp54_;
	const gchar* _tmp55_;
	ValaCodeContext* _tmp56_;
	const gchar* _tmp57_;
	ValaCodeContext* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_ = FALSE;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp70_;
	ValaCodeContext* _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	ValaCodeContext* _tmp81_;
	ValaCodeContext* _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	ValaCodeContext* _tmp84_;
	gchar** _tmp85_;
	gint _tmp85__length1;
	ValaCodeContext* _tmp86_;
	ValaCodeContext* _tmp87_;
	ValaCodeContext* _tmp88_;
	gboolean _tmp89_ = FALSE;
	const gchar* _tmp90_;
	const gchar* _tmp103_;
	ValaCodeContext* _tmp104_;
	ValaCodeContext* _tmp105_;
	const gchar* _tmp106_;
	ValaCodeContext* _tmp107_;
	const gchar* _tmp108_;
	ValaCodeContext* _tmp112_;
	const gchar* _tmp113_;
	gchar** _tmp114_;
	gint _tmp114__length1;
	ValaCodeContext* _tmp119_;
	ValaProfile _tmp120_;
	ValaProfile _tmp121_;
	gchar** _tmp131_;
	gint _tmp131__length1;
	gchar** _tmp136_;
	gint _tmp136__length1;
	ValaCodeContext* _tmp147_;
	gchar** _tmp148_;
	gint _tmp148__length1;
	ValaCodeContext* _tmp149_;
	gchar** _tmp150_;
	gint _tmp150__length1;
	gboolean _tmp151_ = FALSE;
	ValaCodeContext* _tmp152_;
	ValaReport* _tmp153_;
	ValaReport* _tmp154_;
	ValaCodeContext* _tmp159_;
	ValaProfile _tmp160_;
	ValaProfile _tmp161_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp168_;
	gint _tmp168__length1;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp176_ = FALSE;
	ValaCodeContext* _tmp177_;
	ValaReport* _tmp178_;
	ValaReport* _tmp179_;
	ValaParser* parser = NULL;
	ValaParser* _tmp184_;
	ValaParser* _tmp185_;
	ValaCodeContext* _tmp186_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp187_;
	ValaGenieParser* _tmp188_;
	ValaCodeContext* _tmp189_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp190_;
	ValaGirParser* _tmp191_;
	ValaCodeContext* _tmp192_;
	gboolean _tmp193_ = FALSE;
	ValaCodeContext* _tmp194_;
	ValaReport* _tmp195_;
	ValaReport* _tmp196_;
	const gchar* _tmp201_;
	ValaCodeContext* _tmp206_;
	gboolean _tmp207_ = FALSE;
	ValaCodeContext* _tmp208_;
	ValaReport* _tmp209_;
	ValaReport* _tmp210_;
	gboolean _tmp215_ = FALSE;
	gboolean _tmp216_ = FALSE;
	const gchar* _tmp222_;
	gboolean _tmp227_ = FALSE;
	ValaCodeContext* _tmp228_;
	ValaReport* _tmp229_;
	ValaReport* _tmp230_;
	ValaCodeContext* _tmp235_;
	ValaCodeGenerator* _tmp236_;
	ValaCodeGenerator* _tmp237_;
	ValaCodeContext* _tmp238_;
	gboolean _tmp239_ = FALSE;
	ValaCodeContext* _tmp240_;
	ValaReport* _tmp241_;
	ValaReport* _tmp242_;
	gboolean _tmp247_ = FALSE;
	const gchar* _tmp248_;
	const gchar* _tmp252_;
	const gchar* _tmp299_;
	const gchar* _tmp312_;
	const gchar* _tmp355_;
	gboolean _tmp358_ = FALSE;
	ValaCodeContext* _tmp359_;
	ValaReport* _tmp360_;
	ValaReport* _tmp361_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	if (vala_compiler_disable_colored_output) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp2_ = vala_compiler_colored_output;
	if (_tmp2_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			const gchar* _tmp8_;
			ValaReportColored _tmp9_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			_tmp9_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp7_, _tmp8_, _tmp9_);
		} else {
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaReportColored _tmp13_;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp12_, VALA_COMPILER_DEFAULT_COLORS, _tmp13_);
		}
	}
	if (!vala_compiler_ccode_only) {
		_tmp15_ = !vala_compiler_compile_only;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = vala_compiler_output;
		_tmp14_ = _tmp16_ == NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		if (string_last_index_of_char (_tmp18_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp19_;
			gint _tmp19__length1;
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp19_ = vala_compiler_sources;
			_tmp19__length1 = _vala_array_length (vala_compiler_sources);
			_tmp20_ = _tmp19_[0];
			dot = string_last_index_of_char (_tmp20_, (gunichar) '.', 0);
			_tmp21_ = vala_compiler_sources;
			_tmp21__length1 = _vala_array_length (vala_compiler_sources);
			_tmp22_ = _tmp21_[0];
			_tmp23_ = string_substring (_tmp22_, (glong) 0, (glong) dot);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_path_get_basename (_tmp24_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp25_;
			_g_free0 (_tmp24_);
		}
	}
	_tmp26_ = self->priv->context;
	vala_code_context_set_assert (_tmp26_, !vala_compiler_disable_assert);
	_tmp27_ = self->priv->context;
	vala_code_context_set_checking (_tmp27_, vala_compiler_enable_checking);
	_tmp28_ = self->priv->context;
	vala_code_context_set_deprecated (_tmp28_, vala_compiler_deprecated);
	_tmp29_ = self->priv->context;
	vala_code_context_set_since_check (_tmp29_, !vala_compiler_disable_since_check);
	_tmp30_ = self->priv->context;
	vala_code_context_set_hide_internal (_tmp30_, vala_compiler_hide_internal);
	_tmp31_ = self->priv->context;
	vala_code_context_set_experimental (_tmp31_, vala_compiler_experimental);
	_tmp32_ = self->priv->context;
	vala_code_context_set_experimental_non_null (_tmp32_, vala_compiler_experimental_non_null);
	_tmp33_ = self->priv->context;
	vala_code_context_set_gobject_tracing (_tmp33_, vala_compiler_gobject_tracing);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_code_context_get_report (_tmp34_);
	_tmp36_ = _tmp35_;
	vala_report_set_enable_warnings (_tmp36_, !vala_compiler_disable_warnings);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	vala_report_set_verbose_errors (_tmp39_, !vala_compiler_quiet_mode);
	_tmp40_ = self->priv->context;
	vala_code_context_set_verbose_mode (_tmp40_, vala_compiler_verbose_mode);
	_tmp41_ = self->priv->context;
	vala_code_context_set_version_header (_tmp41_, !vala_compiler_disable_version_header);
	_tmp42_ = self->priv->context;
	vala_code_context_set_ccode_only (_tmp42_, vala_compiler_ccode_only);
	if (vala_compiler_ccode_only) {
		gchar** _tmp44_;
		gint _tmp44__length1;
		_tmp44_ = vala_compiler_cc_options;
		_tmp44__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp43_ = _tmp44_ != NULL;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp45_ = self->priv->context;
	vala_code_context_set_abi_stability (_tmp45_, vala_compiler_abi_stability);
	_tmp46_ = self->priv->context;
	vala_code_context_set_compile_only (_tmp46_, vala_compiler_compile_only);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp47_, _tmp48_);
	_tmp50_ = vala_compiler_header_filename;
	if (_tmp50_ == NULL) {
		_tmp49_ = vala_compiler_use_header;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp51_ = self->priv->context;
	vala_code_context_set_use_header (_tmp51_, vala_compiler_use_header);
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp52_, _tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp56_, _tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_output;
	vala_code_context_set_output (_tmp58_, _tmp59_);
	_tmp61_ = vala_compiler_output;
	if (_tmp61_ != NULL) {
		_tmp60_ = vala_compiler_ccode_only;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp62_ = vala_compiler_basedir;
	if (_tmp62_ == NULL) {
		ValaCodeContext* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp63_ = self->priv->context;
		_tmp64_ = vala_code_context_realpath (".");
		_tmp65_ = _tmp64_;
		vala_code_context_set_basedir (_tmp63_, _tmp65_);
		_g_free0 (_tmp65_);
	} else {
		ValaCodeContext* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_compiler_basedir;
		_tmp68_ = vala_code_context_realpath (_tmp67_);
		_tmp69_ = _tmp68_;
		vala_code_context_set_basedir (_tmp66_, _tmp69_);
		_g_free0 (_tmp69_);
	}
	_tmp70_ = vala_compiler_directory;
	if (_tmp70_ != NULL) {
		ValaCodeContext* _tmp71_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp71_ = self->priv->context;
		_tmp72_ = vala_compiler_directory;
		_tmp73_ = vala_code_context_realpath (_tmp72_);
		_tmp74_ = _tmp73_;
		vala_code_context_set_directory (_tmp71_, _tmp74_);
		_g_free0 (_tmp74_);
	} else {
		ValaCodeContext* _tmp75_;
		ValaCodeContext* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		_tmp75_ = self->priv->context;
		_tmp76_ = self->priv->context;
		_tmp77_ = vala_code_context_get_basedir (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_code_context_set_directory (_tmp75_, _tmp78_);
	}
	_tmp79_ = self->priv->context;
	_tmp80_ = vala_compiler_vapi_directories;
	_tmp80__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp79_, _tmp80_, _tmp80__length1);
	_tmp81_ = self->priv->context;
	vala_code_context_set_vapi_comments (_tmp81_, vala_compiler_vapi_comments);
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_gir_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp82_, _tmp83_, _tmp83__length1);
	_tmp84_ = self->priv->context;
	_tmp85_ = vala_compiler_metadata_directories;
	_tmp85__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp84_, _tmp85_, _tmp85__length1);
	_tmp86_ = self->priv->context;
	vala_code_context_set_debug (_tmp86_, vala_compiler_debug);
	_tmp87_ = self->priv->context;
	vala_code_context_set_mem_profiler (_tmp87_, vala_compiler_mem_profiler);
	_tmp88_ = self->priv->context;
	vala_code_context_set_save_temps (_tmp88_, vala_compiler_save_temps);
	if (vala_compiler_ccode_only) {
		_tmp89_ = vala_compiler_save_temps;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp90_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp90_, "posix") == 0) {
		ValaCodeContext* _tmp91_;
		ValaCodeContext* _tmp92_;
		_tmp91_ = self->priv->context;
		vala_code_context_set_profile (_tmp91_, VALA_PROFILE_POSIX);
		_tmp92_ = self->priv->context;
		vala_code_context_add_define (_tmp92_, "POSIX");
	} else {
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		const gchar* _tmp95_;
		_tmp95_ = vala_compiler_profile;
		if (g_strcmp0 (_tmp95_, "gobject-2.0") == 0) {
			_tmp94_ = TRUE;
		} else {
			const gchar* _tmp96_;
			_tmp96_ = vala_compiler_profile;
			_tmp94_ = g_strcmp0 (_tmp96_, "gobject") == 0;
		}
		if (_tmp94_) {
			_tmp93_ = TRUE;
		} else {
			const gchar* _tmp97_;
			_tmp97_ = vala_compiler_profile;
			_tmp93_ = _tmp97_ == NULL;
		}
		if (_tmp93_) {
			ValaCodeContext* _tmp98_;
			ValaCodeContext* _tmp99_;
			_tmp98_ = self->priv->context;
			vala_code_context_set_profile (_tmp98_, VALA_PROFILE_GOBJECT);
			_tmp99_ = self->priv->context;
			vala_code_context_add_define (_tmp99_, "GOBJECT");
		} else {
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			_tmp100_ = vala_compiler_profile;
			_tmp101_ = g_strdup_printf ("Unknown profile %s", _tmp100_);
			_tmp102_ = _tmp101_;
			vala_report_error (NULL, _tmp102_);
			_g_free0 (_tmp102_);
		}
	}
	_tmp103_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = vala_compiler_nostdpkg | (_tmp103_ != NULL);
	_tmp104_ = self->priv->context;
	vala_code_context_set_nostdpkg (_tmp104_, vala_compiler_nostdpkg);
	_tmp105_ = self->priv->context;
	_tmp106_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp105_, _tmp106_);
	_tmp107_ = self->priv->context;
	vala_code_context_set_run_output (_tmp107_, vala_compiler_run_output);
	_tmp108_ = vala_compiler_pkg_config_command;
	if (_tmp108_ == NULL) {
		const gchar* _tmp109_ = NULL;
		const gchar* _tmp110_;
		gchar* _tmp111_;
		_tmp110_ = g_getenv ("PKG_CONFIG");
		_tmp109_ = _tmp110_;
		if (_tmp109_ == NULL) {
			_tmp109_ = "pkg-config";
		}
		_tmp111_ = g_strdup (_tmp109_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp111_;
	}
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp112_, _tmp113_);
	_tmp114_ = vala_compiler_defines;
	_tmp114__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp114_ != NULL) {
		gchar** _tmp115_;
		gint _tmp115__length1;
		_tmp115_ = vala_compiler_defines;
		_tmp115__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp115_;
			define_collection_length1 = _tmp115__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp116_;
				gchar* define = NULL;
				_tmp116_ = g_strdup (define_collection[define_it]);
				define = _tmp116_;
				{
					ValaCodeContext* _tmp117_;
					const gchar* _tmp118_;
					_tmp117_ = self->priv->context;
					_tmp118_ = define;
					vala_code_context_add_define (_tmp117_, _tmp118_);
					_g_free0 (define);
				}
			}
		}
	}
	_tmp119_ = self->priv->context;
	_tmp120_ = vala_code_context_get_profile (_tmp119_);
	_tmp121_ = _tmp120_;
	if (_tmp121_ == VALA_PROFILE_POSIX) {
		if (!vala_compiler_nostdpkg) {
			ValaCodeContext* _tmp122_;
			_tmp122_ = self->priv->context;
			vala_code_context_add_external_package (_tmp122_, "posix");
		}
	} else {
		ValaCodeContext* _tmp123_;
		ValaProfile _tmp124_;
		ValaProfile _tmp125_;
		_tmp123_ = self->priv->context;
		_tmp124_ = vala_code_context_get_profile (_tmp123_);
		_tmp125_ = _tmp124_;
		if (_tmp125_ == VALA_PROFILE_GOBJECT) {
			const gchar* _tmp126_;
			_tmp126_ = vala_compiler_target_glib;
			if (_tmp126_ != NULL) {
				ValaCodeContext* _tmp127_;
				const gchar* _tmp128_;
				_tmp127_ = self->priv->context;
				_tmp128_ = vala_compiler_target_glib;
				vala_code_context_set_target_glib_version (_tmp127_, _tmp128_);
			}
			if (!vala_compiler_nostdpkg) {
				ValaCodeContext* _tmp129_;
				ValaCodeContext* _tmp130_;
				_tmp129_ = self->priv->context;
				vala_code_context_add_external_package (_tmp129_, "glib-2.0");
				_tmp130_ = self->priv->context;
				vala_code_context_add_external_package (_tmp130_, "gobject-2.0");
			}
		}
	}
	_tmp131_ = vala_compiler_packages;
	_tmp131__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp131_ != NULL) {
		gchar** _tmp132_;
		gint _tmp132__length1;
		_tmp132_ = vala_compiler_packages;
		_tmp132__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp132_;
			package_collection_length1 = _tmp132__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp133_;
				gchar* package = NULL;
				_tmp133_ = g_strdup (package_collection[package_it]);
				package = _tmp133_;
				{
					ValaCodeContext* _tmp134_;
					const gchar* _tmp135_;
					_tmp134_ = self->priv->context;
					_tmp135_ = package;
					vala_code_context_add_external_package (_tmp134_, _tmp135_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp136_ = vala_compiler_fast_vapis;
	_tmp136__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp136_ != NULL) {
		gchar** _tmp137_;
		gint _tmp137__length1;
		ValaCodeContext* _tmp146_;
		_tmp137_ = vala_compiler_fast_vapis;
		_tmp137__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp137_;
			vapi_collection_length1 = _tmp137__length1;
			for (vapi_it = 0; vapi_it < vapi_collection_length1; vapi_it = vapi_it + 1) {
				gchar* _tmp138_;
				gchar* vapi = NULL;
				_tmp138_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp138_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp139_;
					gchar* _tmp140_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp141_;
					const gchar* _tmp142_;
					ValaSourceFile* _tmp143_;
					ValaCodeContext* _tmp144_;
					ValaSourceFile* _tmp145_;
					_tmp139_ = vapi;
					_tmp140_ = vala_code_context_realpath (_tmp139_);
					rpath = _tmp140_;
					_tmp141_ = self->priv->context;
					_tmp142_ = rpath;
					_tmp143_ = vala_source_file_new (_tmp141_, VALA_SOURCE_FILE_TYPE_FAST, _tmp142_, NULL, FALSE);
					source_file = _tmp143_;
					_tmp144_ = self->priv->context;
					_tmp145_ = source_file;
					vala_code_context_add_source_file (_tmp144_, _tmp145_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp146_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp146_, TRUE);
	}
	_tmp147_ = self->priv->context;
	_tmp148_ = vala_compiler_gresources;
	_tmp148__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp147_, _tmp148_, _tmp148__length1);
	_tmp149_ = self->priv->context;
	_tmp150_ = vala_compiler_gresources_directories;
	_tmp150__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp149_, _tmp150_, _tmp150__length1);
	_tmp152_ = self->priv->context;
	_tmp153_ = vala_code_context_get_report (_tmp152_);
	_tmp154_ = _tmp153_;
	if (vala_report_get_errors (_tmp154_) > 0) {
		_tmp151_ = TRUE;
	} else {
		gboolean _tmp155_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp156_;
			ValaReport* _tmp157_;
			ValaReport* _tmp158_;
			_tmp156_ = self->priv->context;
			_tmp157_ = vala_code_context_get_report (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp155_ = vala_report_get_warnings (_tmp158_) > 0;
		} else {
			_tmp155_ = FALSE;
		}
		_tmp151_ = _tmp155_;
	}
	if (_tmp151_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp159_ = self->priv->context;
	_tmp160_ = vala_code_context_get_profile (_tmp159_);
	_tmp161_ = _tmp160_;
	if (_tmp161_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp162_;
		ValaGDBusServerModule* _tmp163_;
		ValaGDBusServerModule* _tmp164_;
		_tmp162_ = self->priv->context;
		_tmp163_ = vala_gd_bus_server_module_new ();
		_tmp164_ = _tmp163_;
		vala_code_context_set_codegen (_tmp162_, (ValaCodeGenerator*) _tmp164_);
		_vala_code_visitor_unref0 (_tmp164_);
	} else {
		ValaCodeContext* _tmp165_;
		ValaCCodeDelegateModule* _tmp166_;
		ValaCCodeDelegateModule* _tmp167_;
		_tmp165_ = self->priv->context;
		_tmp166_ = vala_ccode_delegate_module_new ();
		_tmp167_ = _tmp166_;
		vala_code_context_set_codegen (_tmp165_, (ValaCodeGenerator*) _tmp167_);
		_vala_code_visitor_unref0 (_tmp167_);
	}
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp168_ = vala_compiler_sources;
	_tmp168__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp168_;
		source_collection_length1 = _tmp168__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp169_;
			gchar* source = NULL;
			_tmp169_ = g_strdup (source_collection[source_it]);
			source = _tmp169_;
			{
				ValaCodeContext* _tmp170_;
				const gchar* _tmp171_;
				_tmp170_ = self->priv->context;
				_tmp171_ = source;
				if (vala_code_context_add_source_filename (_tmp170_, _tmp171_, vala_compiler_run_output, TRUE)) {
					const gchar* _tmp172_;
					_tmp172_ = source;
					if (g_str_has_suffix (_tmp172_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp173_;
						_tmp173_ = source;
						if (g_str_has_suffix (_tmp173_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	if (vala_compiler_ccode_only) {
		gboolean _tmp175_ = FALSE;
		if (has_c_files) {
			_tmp175_ = TRUE;
		} else {
			_tmp175_ = has_h_files;
		}
		_tmp174_ = _tmp175_;
	} else {
		_tmp174_ = FALSE;
	}
	if (_tmp174_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp177_ = self->priv->context;
	_tmp178_ = vala_code_context_get_report (_tmp177_);
	_tmp179_ = _tmp178_;
	if (vala_report_get_errors (_tmp179_) > 0) {
		_tmp176_ = TRUE;
	} else {
		gboolean _tmp180_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp181_;
			ValaReport* _tmp182_;
			ValaReport* _tmp183_;
			_tmp181_ = self->priv->context;
			_tmp182_ = vala_code_context_get_report (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp180_ = vala_report_get_warnings (_tmp183_) > 0;
		} else {
			_tmp180_ = FALSE;
		}
		_tmp176_ = _tmp180_;
	}
	if (_tmp176_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp184_ = vala_parser_new ();
	parser = _tmp184_;
	_tmp185_ = parser;
	_tmp186_ = self->priv->context;
	vala_parser_parse (_tmp185_, _tmp186_);
	_tmp187_ = vala_genie_parser_new ();
	genie_parser = _tmp187_;
	_tmp188_ = genie_parser;
	_tmp189_ = self->priv->context;
	vala_genie_parser_parse (_tmp188_, _tmp189_);
	_tmp190_ = vala_gir_parser_new ();
	gir_parser = _tmp190_;
	_tmp191_ = gir_parser;
	_tmp192_ = self->priv->context;
	vala_gir_parser_parse (_tmp191_, _tmp192_);
	_tmp194_ = self->priv->context;
	_tmp195_ = vala_code_context_get_report (_tmp194_);
	_tmp196_ = _tmp195_;
	if (vala_report_get_errors (_tmp196_) > 0) {
		_tmp193_ = TRUE;
	} else {
		gboolean _tmp197_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp198_;
			ValaReport* _tmp199_;
			ValaReport* _tmp200_;
			_tmp198_ = self->priv->context;
			_tmp199_ = vala_code_context_get_report (_tmp198_);
			_tmp200_ = _tmp199_;
			_tmp197_ = vala_report_get_warnings (_tmp200_) > 0;
		} else {
			_tmp197_ = FALSE;
		}
		_tmp193_ = _tmp197_;
	}
	if (_tmp193_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp201_ = vala_compiler_fast_vapi_filename;
	if (_tmp201_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp202_;
		ValaCodeWriter* _tmp203_;
		ValaCodeContext* _tmp204_;
		const gchar* _tmp205_;
		_tmp202_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp202_;
		_tmp203_ = interface_writer;
		_tmp204_ = self->priv->context;
		_tmp205_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp203_, _tmp204_, _tmp205_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp206_ = self->priv->context;
	vala_code_context_check (_tmp206_);
	_tmp208_ = self->priv->context;
	_tmp209_ = vala_code_context_get_report (_tmp208_);
	_tmp210_ = _tmp209_;
	if (vala_report_get_errors (_tmp210_) > 0) {
		_tmp207_ = TRUE;
	} else {
		gboolean _tmp211_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp212_;
			ValaReport* _tmp213_;
			ValaReport* _tmp214_;
			_tmp212_ = self->priv->context;
			_tmp213_ = vala_code_context_get_report (_tmp212_);
			_tmp214_ = _tmp213_;
			_tmp211_ = vala_report_get_warnings (_tmp214_) > 0;
		} else {
			_tmp211_ = FALSE;
		}
		_tmp207_ = _tmp211_;
	}
	if (_tmp207_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		_tmp216_ = !vala_compiler_compile_only;
	} else {
		_tmp216_ = FALSE;
	}
	if (_tmp216_) {
		const gchar* _tmp217_;
		_tmp217_ = vala_compiler_library;
		_tmp215_ = _tmp217_ == NULL;
	} else {
		_tmp215_ = FALSE;
	}
	if (_tmp215_) {
		gboolean _tmp218_ = FALSE;
		if (!has_c_files) {
			ValaCodeContext* _tmp219_;
			ValaMethod* _tmp220_;
			ValaMethod* _tmp221_;
			_tmp219_ = self->priv->context;
			_tmp220_ = vala_code_context_get_entry_point (_tmp219_);
			_tmp221_ = _tmp220_;
			_tmp218_ = _tmp221_ == NULL;
		} else {
			_tmp218_ = FALSE;
		}
		if (_tmp218_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp222_ = vala_compiler_dump_tree;
	if (_tmp222_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp223_;
		ValaCodeWriter* _tmp224_;
		ValaCodeContext* _tmp225_;
		const gchar* _tmp226_;
		_tmp223_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp223_;
		_tmp224_ = code_writer;
		_tmp225_ = self->priv->context;
		_tmp226_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp224_, _tmp225_, _tmp226_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp228_ = self->priv->context;
	_tmp229_ = vala_code_context_get_report (_tmp228_);
	_tmp230_ = _tmp229_;
	if (vala_report_get_errors (_tmp230_) > 0) {
		_tmp227_ = TRUE;
	} else {
		gboolean _tmp231_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp232_;
			ValaReport* _tmp233_;
			ValaReport* _tmp234_;
			_tmp232_ = self->priv->context;
			_tmp233_ = vala_code_context_get_report (_tmp232_);
			_tmp234_ = _tmp233_;
			_tmp231_ = vala_report_get_warnings (_tmp234_) > 0;
		} else {
			_tmp231_ = FALSE;
		}
		_tmp227_ = _tmp231_;
	}
	if (_tmp227_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp235_ = self->priv->context;
	_tmp236_ = vala_code_context_get_codegen (_tmp235_);
	_tmp237_ = _tmp236_;
	_tmp238_ = self->priv->context;
	vala_code_generator_emit (_tmp237_, _tmp238_);
	_tmp240_ = self->priv->context;
	_tmp241_ = vala_code_context_get_report (_tmp240_);
	_tmp242_ = _tmp241_;
	if (vala_report_get_errors (_tmp242_) > 0) {
		_tmp239_ = TRUE;
	} else {
		gboolean _tmp243_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp244_;
			ValaReport* _tmp245_;
			ValaReport* _tmp246_;
			_tmp244_ = self->priv->context;
			_tmp245_ = vala_code_context_get_report (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp243_ = vala_report_get_warnings (_tmp246_) > 0;
		} else {
			_tmp243_ = FALSE;
		}
		_tmp239_ = _tmp243_;
	}
	if (_tmp239_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp248_ = vala_compiler_vapi_filename;
	if (_tmp248_ == NULL) {
		const gchar* _tmp249_;
		_tmp249_ = vala_compiler_library;
		_tmp247_ = _tmp249_ != NULL;
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		const gchar* _tmp250_;
		gchar* _tmp251_;
		_tmp250_ = vala_compiler_library;
		_tmp251_ = g_strdup_printf ("%s.vapi", _tmp250_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp251_;
	}
	_tmp252_ = vala_compiler_library;
	if (_tmp252_ != NULL) {
		const gchar* _tmp253_;
		_tmp253_ = vala_compiler_gir;
		if (_tmp253_ != NULL) {
			ValaCodeContext* _tmp254_;
			ValaProfile _tmp255_;
			ValaProfile _tmp256_;
			_tmp254_ = self->priv->context;
			_tmp255_ = vala_code_context_get_profile (_tmp254_);
			_tmp256_ = _tmp255_;
			if (_tmp256_ == VALA_PROFILE_GOBJECT) {
				gchar* gir_base = NULL;
				const gchar* _tmp257_;
				gchar* _tmp258_;
				glong gir_len = 0L;
				const gchar* _tmp259_;
				gint _tmp260_;
				gint _tmp261_;
				gint last_hyphen = 0;
				const gchar* _tmp262_;
				gboolean _tmp263_ = FALSE;
				_tmp257_ = vala_compiler_gir;
				_tmp258_ = g_path_get_basename (_tmp257_);
				gir_base = _tmp258_;
				_tmp259_ = gir_base;
				_tmp260_ = strlen (_tmp259_);
				_tmp261_ = _tmp260_;
				gir_len = (glong) _tmp261_;
				_tmp262_ = gir_base;
				last_hyphen = string_last_index_of_char (_tmp262_, (gunichar) '-', 0);
				if (last_hyphen == -1) {
					_tmp263_ = TRUE;
				} else {
					const gchar* _tmp264_;
					_tmp264_ = gir_base;
					_tmp263_ = !g_str_has_suffix (_tmp264_, ".gir");
				}
				if (_tmp263_) {
					const gchar* _tmp265_;
					gchar* _tmp266_;
					gchar* _tmp267_;
					_tmp265_ = vala_compiler_gir;
					_tmp266_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp265_);
					_tmp267_ = _tmp266_;
					vala_report_error (NULL, _tmp267_);
					_g_free0 (_tmp267_);
				} else {
					gchar* gir_namespace = NULL;
					const gchar* _tmp268_;
					gchar* _tmp269_;
					gchar* gir_version = NULL;
					const gchar* _tmp270_;
					gchar* _tmp271_;
					const gchar* _tmp272_;
					gboolean _tmp273_ = FALSE;
					gboolean _tmp274_ = FALSE;
					gboolean _tmp275_ = FALSE;
					const gchar* _tmp276_;
					_tmp268_ = gir_base;
					_tmp269_ = string_substring (_tmp268_, (glong) 0, (glong) last_hyphen);
					gir_namespace = _tmp269_;
					_tmp270_ = gir_base;
					_tmp271_ = string_substring (_tmp270_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
					gir_version = _tmp271_;
					_tmp272_ = gir_version;
					g_strcanon (_tmp272_, "0123456789.", '?');
					_tmp276_ = gir_namespace;
					if (g_strcmp0 (_tmp276_, "") == 0) {
						_tmp275_ = TRUE;
					} else {
						const gchar* _tmp277_;
						_tmp277_ = gir_version;
						_tmp275_ = g_strcmp0 (_tmp277_, "") == 0;
					}
					if (_tmp275_) {
						_tmp274_ = TRUE;
					} else {
						const gchar* _tmp278_;
						_tmp278_ = gir_version;
						_tmp274_ = !g_ascii_isdigit (string_get (_tmp278_, (glong) 0));
					}
					if (_tmp274_) {
						_tmp273_ = TRUE;
					} else {
						const gchar* _tmp279_;
						_tmp279_ = gir_version;
						_tmp273_ = string_contains (_tmp279_, "?");
					}
					if (_tmp273_) {
						const gchar* _tmp280_;
						gchar* _tmp281_;
						gchar* _tmp282_;
						_tmp280_ = vala_compiler_gir;
						_tmp281_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp280_);
						_tmp282_ = _tmp281_;
						vala_report_error (NULL, _tmp282_);
						_g_free0 (_tmp282_);
					} else {
						ValaGIRWriter* gir_writer = NULL;
						ValaGIRWriter* _tmp283_;
						gchar* gir_directory = NULL;
						gchar* _tmp284_;
						const gchar* _tmp285_;
						ValaGIRWriter* _tmp290_;
						ValaCodeContext* _tmp291_;
						const gchar* _tmp292_;
						const gchar* _tmp293_;
						const gchar* _tmp294_;
						const gchar* _tmp295_;
						const gchar* _tmp296_;
						const gchar* _tmp297_;
						_tmp283_ = vala_gir_writer_new ();
						gir_writer = _tmp283_;
						_tmp284_ = g_strdup (".");
						gir_directory = _tmp284_;
						_tmp285_ = vala_compiler_directory;
						if (_tmp285_ != NULL) {
							ValaCodeContext* _tmp286_;
							const gchar* _tmp287_;
							const gchar* _tmp288_;
							gchar* _tmp289_;
							_tmp286_ = self->priv->context;
							_tmp287_ = vala_code_context_get_directory (_tmp286_);
							_tmp288_ = _tmp287_;
							_tmp289_ = g_strdup (_tmp288_);
							_g_free0 (gir_directory);
							gir_directory = _tmp289_;
						}
						_tmp290_ = gir_writer;
						_tmp291_ = self->priv->context;
						_tmp292_ = gir_directory;
						_tmp293_ = vala_compiler_gir;
						_tmp294_ = gir_namespace;
						_tmp295_ = gir_version;
						_tmp296_ = vala_compiler_library;
						_tmp297_ = vala_compiler_shared_library;
						vala_gir_writer_write_file (_tmp290_, _tmp291_, _tmp292_, _tmp293_, _tmp294_, _tmp295_, _tmp296_, _tmp297_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
				_g_free0 (gir_base);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp298_;
		_tmp298_ = vala_compiler_gir;
		if (_tmp298_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp299_ = vala_compiler_vapi_filename;
	if (_tmp299_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp300_;
		gboolean _tmp301_ = FALSE;
		const gchar* _tmp302_;
		ValaCodeWriter* _tmp309_;
		ValaCodeContext* _tmp310_;
		const gchar* _tmp311_;
		_tmp300_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp300_;
		_tmp302_ = vala_compiler_directory;
		if (_tmp302_ != NULL) {
			const gchar* _tmp303_;
			_tmp303_ = vala_compiler_vapi_filename;
			_tmp301_ = !g_path_is_absolute (_tmp303_);
		} else {
			_tmp301_ = FALSE;
		}
		if (_tmp301_) {
			ValaCodeContext* _tmp304_;
			const gchar* _tmp305_;
			const gchar* _tmp306_;
			const gchar* _tmp307_;
			gchar* _tmp308_;
			_tmp304_ = self->priv->context;
			_tmp305_ = vala_code_context_get_directory (_tmp304_);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_compiler_vapi_filename;
			_tmp308_ = g_strdup_printf ("%s%c%s", _tmp306_, (gint) G_DIR_SEPARATOR, _tmp307_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp308_;
		}
		_tmp309_ = interface_writer;
		_tmp310_ = self->priv->context;
		_tmp311_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp309_, _tmp310_, _tmp311_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp312_ = vala_compiler_internal_vapi_filename;
	if (_tmp312_ != NULL) {
		gboolean _tmp313_ = FALSE;
		const gchar* _tmp314_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp316_;
		ValaCodeContext* _tmp317_;
		const gchar* _tmp318_;
		const gchar* _tmp319_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp342_;
		gchar* _tmp343_;
		gboolean _tmp344_ = FALSE;
		const gchar* _tmp345_;
		ValaCodeWriter* _tmp352_;
		ValaCodeContext* _tmp353_;
		const gchar* _tmp354_;
		_tmp314_ = vala_compiler_internal_header_filename;
		if (_tmp314_ == NULL) {
			_tmp313_ = TRUE;
		} else {
			const gchar* _tmp315_;
			_tmp315_ = vala_compiler_header_filename;
			_tmp313_ = _tmp315_ == NULL;
		}
		if (_tmp313_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp316_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp316_;
		_tmp317_ = self->priv->context;
		_tmp318_ = vala_code_context_get_includedir (_tmp317_);
		_tmp319_ = _tmp318_;
		if (_tmp319_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp320_;
			const gchar* _tmp321_;
			const gchar* _tmp322_;
			const gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp328_;
			const gchar* _tmp329_;
			const gchar* _tmp330_;
			const gchar* _tmp331_;
			gchar* _tmp332_;
			gchar* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			ValaCodeWriter* _tmp336_;
			const gchar* _tmp337_;
			const gchar* _tmp338_;
			_tmp320_ = self->priv->context;
			_tmp321_ = vala_code_context_get_includedir (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_compiler_header_filename;
			_tmp324_ = g_path_get_basename (_tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = g_build_path ("/", _tmp322_, _tmp325_, NULL);
			_tmp327_ = _tmp326_;
			_g_free0 (_tmp325_);
			prefixed_header_filename = _tmp327_;
			_tmp328_ = self->priv->context;
			_tmp329_ = vala_code_context_get_includedir (_tmp328_);
			_tmp330_ = _tmp329_;
			_tmp331_ = vala_compiler_internal_header_filename;
			_tmp332_ = g_path_get_basename (_tmp331_);
			_tmp333_ = _tmp332_;
			_tmp334_ = g_build_path ("/", _tmp330_, _tmp333_, NULL);
			_tmp335_ = _tmp334_;
			_g_free0 (_tmp333_);
			prefixed_internal_header_filename = _tmp335_;
			_tmp336_ = interface_writer;
			_tmp337_ = prefixed_header_filename;
			_tmp338_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp336_, _tmp337_, _tmp338_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp339_;
			const gchar* _tmp340_;
			const gchar* _tmp341_;
			_tmp339_ = interface_writer;
			_tmp340_ = vala_compiler_header_filename;
			_tmp341_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp339_, _tmp340_, _tmp341_);
		}
		_tmp342_ = vala_compiler_internal_vapi_filename;
		_tmp343_ = g_strdup (_tmp342_);
		vapi_filename = _tmp343_;
		_tmp345_ = vala_compiler_directory;
		if (_tmp345_ != NULL) {
			const gchar* _tmp346_;
			_tmp346_ = vapi_filename;
			_tmp344_ = !g_path_is_absolute (_tmp346_);
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCodeContext* _tmp347_;
			const gchar* _tmp348_;
			const gchar* _tmp349_;
			const gchar* _tmp350_;
			gchar* _tmp351_;
			_tmp347_ = self->priv->context;
			_tmp348_ = vala_code_context_get_directory (_tmp347_);
			_tmp349_ = _tmp348_;
			_tmp350_ = vapi_filename;
			_tmp351_ = g_strdup_printf ("%s%c%s", _tmp349_, (gint) G_DIR_SEPARATOR, _tmp350_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp351_;
		}
		_tmp352_ = interface_writer;
		_tmp353_ = self->priv->context;
		_tmp354_ = vapi_filename;
		vala_code_writer_write_file (_tmp352_, _tmp353_, _tmp354_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp355_ = vala_compiler_dependencies;
	if (_tmp355_ != NULL) {
		ValaCodeContext* _tmp356_;
		const gchar* _tmp357_;
		_tmp356_ = self->priv->context;
		_tmp357_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp356_, _tmp357_);
	}
	_tmp359_ = self->priv->context;
	_tmp360_ = vala_code_context_get_report (_tmp359_);
	_tmp361_ = _tmp360_;
	if (vala_report_get_errors (_tmp361_) > 0) {
		_tmp358_ = TRUE;
	} else {
		gboolean _tmp362_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp363_;
			ValaReport* _tmp364_;
			ValaReport* _tmp365_;
			_tmp363_ = self->priv->context;
			_tmp364_ = vala_code_context_get_report (_tmp363_);
			_tmp365_ = _tmp364_;
			_tmp362_ = vala_report_get_warnings (_tmp365_) > 0;
		} else {
			_tmp362_ = FALSE;
		}
		_tmp358_ = _tmp362_;
	}
	if (_tmp358_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp366_;
		gboolean _tmp367_ = FALSE;
		const gchar* _tmp368_;
		gchar** _tmp372_;
		gint _tmp372__length1;
		_tmp366_ = vala_ccode_compiler_new ();
		ccompiler = _tmp366_;
		_tmp368_ = vala_compiler_cc_command;
		if (_tmp368_ == NULL) {
			const gchar* _tmp369_;
			_tmp369_ = g_getenv ("CC");
			_tmp367_ = _tmp369_ != NULL;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			const gchar* _tmp370_;
			gchar* _tmp371_;
			_tmp370_ = g_getenv ("CC");
			_tmp371_ = g_strdup (_tmp370_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp371_;
		}
		_tmp372_ = vala_compiler_cc_options;
		_tmp372__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp372_ == NULL) {
			ValaCCodeCompiler* _tmp373_;
			ValaCodeContext* _tmp374_;
			const gchar* _tmp375_;
			gchar** _tmp376_;
			gchar** _tmp377_;
			gint _tmp377__length1;
			_tmp373_ = ccompiler;
			_tmp374_ = self->priv->context;
			_tmp375_ = vala_compiler_cc_command;
			_tmp376_ = g_new0 (gchar*, 0 + 1);
			_tmp377_ = _tmp376_;
			_tmp377__length1 = 0;
			vala_ccode_compiler_compile (_tmp373_, _tmp374_, _tmp375_, _tmp377_, (gint) 0);
			_tmp377_ = (_vala_array_free (_tmp377_, _tmp377__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp378_;
			ValaCodeContext* _tmp379_;
			const gchar* _tmp380_;
			gchar** _tmp381_;
			gint _tmp381__length1;
			_tmp378_ = ccompiler;
			_tmp379_ = self->priv->context;
			_tmp380_ = vala_compiler_cc_command;
			_tmp381_ = vala_compiler_cc_options;
			_tmp381__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp378_, _tmp379_, _tmp380_, _tmp381_, (gint) _tmp381__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GPid pid,
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
____lambda4__gchild_watch_func (GPid pid,
                                gint status,
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}

static gint
vala_compiler_run_source (gchar** args,
                          gint args_length1)
{
	gint result = 0;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint outputfd = 0;
	const gchar* _tmp21_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp22_;
	gint ret = 0;
	ValaCompiler* _tmp23_;
	const gchar* _tmp24_;
	gchar** target_args = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint target_args_length1;
	gint _target_args_size_;
	const gchar* _tmp29_;
	gint _tmp47_ = -1;
	GError* _inner_error0_ = NULL;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_compiler_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp12_;
			_tmp12_ = stdout;
			fprintf (_tmp12_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp13_ = vala_compiler_sources;
	_tmp13__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = g_get_tmp_dir ();
	_tmp16_ = vala_compiler_sources;
	_tmp16__length1 = _vala_array_length (vala_compiler_sources);
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_path_get_basename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp15_, _tmp19_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp21_);
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp22_ = vala_compiler_new ();
	compiler = _tmp22_;
	_tmp23_ = compiler;
	ret = vala_compiler_run (_tmp23_);
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	_tmp24_ = vala_compiler_output;
	if (g_chmod (_tmp24_, 0700) != 0) {
		const gchar* _tmp25_;
		_tmp25_ = vala_compiler_output;
		g_unlink (_tmp25_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp26_ = vala_compiler_output;
	_tmp27_ = g_strdup (_tmp26_);
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	target_args = _tmp28_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp29_ = vala_compiler_run_args;
	if (_tmp29_ != NULL) {
		gchar** target_run_args = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gint target_run_args_length1;
		gint _target_run_args_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp30_ = vala_compiler_run_args;
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, " ", 0);
		target_run_args = _tmp32_;
		target_run_args_length1 = _vala_array_length (_tmp31_);
		_target_run_args_size_ = target_run_args_length1;
		_tmp33_ = target_run_args;
		_tmp33__length1 = target_run_args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp33_;
			arg_collection_length1 = _tmp33__length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp34_;
				gchar* arg = NULL;
				_tmp34_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp34_;
				{
					gchar** _tmp35_;
					gint _tmp35__length1;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp35_ = target_args;
					_tmp35__length1 = target_args_length1;
					_tmp36_ = arg;
					_tmp37_ = g_strdup (_tmp36_);
					_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp37_);
					_g_free0 (arg);
				}
			}
		}
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp38_;
		gchar** _tmp39_;
		gint _tmp39__length1;
		GPid _tmp40_ = 0;
		const gchar* _tmp42_;
		GMainLoop* _tmp43_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp38_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp38_;
		_data1_->child_status = 0;
		_tmp39_ = target_args;
		_tmp39__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp39_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp40_, &_inner_error0_);
		pid = _tmp40_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp41_ = -1;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp41_;
		}
		_tmp42_ = vala_compiler_output;
		g_unlink (_tmp42_);
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp43_ = _data1_->loop;
		g_main_loop_run (_tmp43_);
		result = _data1_->child_status;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp44_;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = stdout;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		fprintf (_tmp44_, "%s\n", _tmp46_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp47_;
}

static gint
vala_compiler_main (gchar** args,
                    gint args_length1)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp21_ = FALSE;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp25_;
	ValaCompiler* _tmp26_;
	GError* _inner_error0_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "vala") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = args[0];
		_tmp6_ = g_path_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, (gint) args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		GOptionContext* _tmp10_;
		GOptionContext* _tmp11_;
		_tmp8_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp8_;
		_tmp9_ = opt_context;
		g_option_context_set_help_enabled (_tmp9_, TRUE);
		_tmp10_ = opt_context;
		g_option_context_add_main_entries (_tmp10_, VALA_COMPILER_options, NULL);
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp12_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_tmp16_ = stdout;
		_tmp17_ = args[0];
		fprintf (_tmp16_, "Run '%s --help' to see a full list of available command line options.\n", _tmp17_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp18_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	if (vala_compiler_version) {
		FILE* _tmp19_;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp20_;
			_tmp20_ = stdout;
			fprintf (_tmp20_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp22_ = vala_compiler_sources;
	_tmp22__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp22_ == NULL) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp23_ = vala_compiler_fast_vapis;
		_tmp23__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp21_ = _tmp23_ == NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		FILE* _tmp24_;
		_tmp24_ = stderr;
		fprintf (_tmp24_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp25_ = vala_compiler_new ();
	compiler = _tmp25_;
	_tmp26_ = compiler;
	result = vala_compiler_run (_tmp26_);
	_vala_compiler_unref0 (compiler);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}

G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}

G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}

static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_compiler_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_compiler_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_compiler_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value,
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value,
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

static void
vala_compiler_class_init (ValaCompilerClass * klass,
                          gpointer klass_data)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCompiler_private_offset);
}

static void
vala_compiler_instance_init (ValaCompiler * self,
                             gpointer klass)
{
	self->priv = vala_compiler_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaCompiler_private_offset = g_type_add_instance_private (vala_compiler_type_id, sizeof (ValaCompilerPrivate));
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

