/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	gchar* gir_shared_library;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaTypeSymbol* ginitiallyunowned_type;
	ValaTypeSymbol* gtypeinterface_type;
	ValaTypeSymbol* gtypeinstance_type;
	ValaTypeSymbol* gtype_type;
	ValaArrayList* externals;
	gint enum_value;
};

static gint ValaGIRWriter_private_offset;
static gpointer vala_gir_writer_parent_class = NULL;

static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self,
                                         ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self,
                                              ValaGIRWriterGIRNamespace* g);
static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self,
                                                   ValaInterface* iface);
static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self,
                                                ValaStruct* st);
static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self,
                                              ValaEnum* en);
static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self,
                                               ValaClass* c);
static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self,
                                                    ValaErrorCode* ecode);
static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self,
                                                    ValaEnumValue* ev);
static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self,
                                                  ValaConstant* c);
static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self,
                                                      ValaErrorDomain* edomain);
static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self,
                                               ValaField* f);
static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self,
                                                  ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self,
                                                ValaMethod* m);
static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self,
                                                  ValaProperty* prop);
static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self,
                                                         ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self,
                                                       ValaSignal* sig);
static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self,
                                                       ValaMethod* m);
static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self,
                                                ValaSignal* sig);
static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self,
                                                   ValaParameter* param);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
static void vala_gir_writer_write_package (ValaGIRWriter* self,
                                    const gchar* package);
static void vala_gir_writer_write_doc (ValaGIRWriter* self,
                                const gchar* comment);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self,
                                       ValaNamespace* ns);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self,
                                      const gchar* name);
static void vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base,
                                           ValaNamespace* ns);
static gboolean vala_gir_writer_is_visibility (ValaGIRWriter* self,
                                        ValaSymbol* sym);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self,
                                              ValaSymbol* symbol);
static gboolean vala_gir_writer_is_introspectable (ValaGIRWriter* self,
                                            ValaSymbol* sym);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base,
                                       ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self,
                                              ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self,
                                     ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self,
                                             ValaTypeSymbol* symbol);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self,
                                     ValaTypeSymbol* type_symbol);
static void vala_gir_writer_write_type_parameter (ValaGIRWriter* self,
                                           ValaTypeParameter* type_parameter,
                                           const gchar* tag_type);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self,
                                             ValaTypeSymbol* symbol,
                                             const gchar* suffix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self,
                                         ValaMethod* m,
                                         const gchar* tag_name,
                                         gboolean instance,
                                         const gchar* name,
                                         const gchar* cname,
                                         ValaList* params,
                                         ValaDataType* return_type,
                                         gboolean can_fail,
                                         gboolean write_comment);
static void vala_gir_writer_write_signature (ValaGIRWriter* self,
                                      ValaMethod* m,
                                      const gchar* tag_name,
                                      gboolean write_doc,
                                      gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base,
                                        ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base,
                                           ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base,
                                      ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base,
                                            ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self,
                                                           ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                              ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base,
                                            ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base,
                                          ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self,
                                 ValaDataType* type,
                                 gint index,
                                 ValaParameterDirection direction);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self,
                                            ValaDataType* type,
                                            gint* index,
                                            gboolean has_array_length,
                                            const gchar* name,
                                            ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self,
                                            ValaDataType* type,
                                            gboolean is_parameter,
                                            gint* index,
                                            gboolean has_array_length,
                                            const gchar* name,
                                            const gchar* comment,
                                            ValaParameterDirection direction,
                                            gboolean constructor,
                                            gboolean caller_allocates,
                                            gboolean ellipsis);
static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self,
                                           ValaDataType* type,
                                           gint* index,
                                           gboolean has_array_length);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self,
                                              ValaList* params,
                                              ValaList* type_params,
                                              ValaDataType* return_type,
                                              gboolean return_array_length,
                                              const gchar* return_comment,
                                              gboolean constructor,
                                              ValaDataType* instance_type,
                                              gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base,
                                          ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* m);
static gboolean vala_gir_writer_is_type_introspectable (ValaGIRWriter* self,
                                                 ValaDataType* type);
static gboolean vala_gir_writer_is_method_introspectable (ValaGIRWriter* self,
                                                   ValaMethod* m);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                                 ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base,
                                        ValaSignal* sig);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self,
                                          ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self,
                                         const gchar* ns,
                                         const gchar* version);
static void vala_gir_writer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_gir_writer_get_instance_private (ValaGIRWriter* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGIRWriter_private_offset);
}

static gchar*
vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self,
                                            ValaInterface* iface)
{
	gchar* result = NULL;
	g_return_val_if_fail (iface != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_interface_comment (ValaGIRWriter* self,
                                       ValaInterface* iface)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_interface_comment (self, iface);
}

static gchar*
vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self,
                                         ValaStruct* st)
{
	gchar* result = NULL;
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_struct_comment (ValaGIRWriter* self,
                                    ValaStruct* st)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_struct_comment (self, st);
}

static gchar*
vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self,
                                       ValaEnum* en)
{
	gchar* result = NULL;
	g_return_val_if_fail (en != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_enum_comment (ValaGIRWriter* self,
                                  ValaEnum* en)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_comment (self, en);
}

static gchar*
vala_gir_writer_real_get_class_comment (ValaGIRWriter* self,
                                        ValaClass* c)
{
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_class_comment (ValaGIRWriter* self,
                                   ValaClass* c)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_class_comment (self, c);
}

static gchar*
vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self,
                                             ValaErrorCode* ecode)
{
	gchar* result = NULL;
	g_return_val_if_fail (ecode != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_error_code_comment (ValaGIRWriter* self,
                                        ValaErrorCode* ecode)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_code_comment (self, ecode);
}

static gchar*
vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self,
                                             ValaEnumValue* ev)
{
	gchar* result = NULL;
	g_return_val_if_fail (ev != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self,
                                        ValaEnumValue* ev)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_value_comment (self, ev);
}

static gchar*
vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self,
                                           ValaConstant* c)
{
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_constant_comment (ValaGIRWriter* self,
                                      ValaConstant* c)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_constant_comment (self, c);
}

static gchar*
vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self,
                                               ValaErrorDomain* edomain)
{
	gchar* result = NULL;
	g_return_val_if_fail (edomain != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self,
                                          ValaErrorDomain* edomain)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_domain_comment (self, edomain);
}

static gchar*
vala_gir_writer_real_get_field_comment (ValaGIRWriter* self,
                                        ValaField* f)
{
	gchar* result = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_field_comment (ValaGIRWriter* self,
                                   ValaField* f)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_field_comment (self, f);
}

static gchar*
vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self,
                                           ValaDelegate* cb)
{
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_delegate_comment (ValaGIRWriter* self,
                                      ValaDelegate* cb)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_comment (self, cb);
}

static gchar*
vala_gir_writer_real_get_method_comment (ValaGIRWriter* self,
                                         ValaMethod* m)
{
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_method_comment (ValaGIRWriter* self,
                                    ValaMethod* m)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_comment (self, m);
}

static gchar*
vala_gir_writer_real_get_property_comment (ValaGIRWriter* self,
                                           ValaProperty* prop)
{
	gchar* result = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_property_comment (ValaGIRWriter* self,
                                      ValaProperty* prop)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_property_comment (self, prop);
}

static gchar*
vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self,
                                                  ValaDelegate* cb)
{
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self,
                                             ValaDelegate* cb)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_return_comment (self, cb);
}

static gchar*
vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self,
                                                ValaSignal* sig)
{
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self,
                                           ValaSignal* sig)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_return_comment (self, sig);
}

static gchar*
vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self,
                                                ValaMethod* m)
{
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_method_return_comment (ValaGIRWriter* self,
                                           ValaMethod* m)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_return_comment (self, m);
}

static gchar*
vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self,
                                         ValaSignal* sig)
{
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_signal_comment (ValaGIRWriter* self,
                                    ValaSignal* sig)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_comment (self, sig);
}

static gchar*
vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self,
                                            ValaParameter* param)
{
	gchar* result = NULL;
	g_return_val_if_fail (param != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_parameter_comment (ValaGIRWriter* self,
                                       ValaParameter* param)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_parameter_comment (self, param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_gir_writer_write_includes (ValaGIRWriter* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _i_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _i_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _i_index = 0;
		_tmp0_ = self->priv->externals;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_i_list = _tmp1_;
		_tmp2_ = _i_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_i_size = _tmp4_;
		_i_index = -1;
		while (TRUE) {
			ValaGIRWriterGIRNamespace* i = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValaGIRWriterGIRNamespace* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_i_index = _i_index + 1;
			if (!(_i_index < _i_size)) {
				break;
			}
			_tmp5_ = _i_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _i_index);
			i = (ValaGIRWriterGIRNamespace*) _tmp6_;
			_tmp7_ = i;
			_tmp8_ = (*_tmp7_).ns;
			_tmp9_ = self->priv->gir_namespace;
			if (g_strcmp0 (_tmp8_, _tmp9_) != 0) {
				FILE* _tmp10_;
				ValaGIRWriterGIRNamespace* _tmp11_;
				const gchar* _tmp12_;
				ValaGIRWriterGIRNamespace* _tmp13_;
				const gchar* _tmp14_;
				vala_gir_writer_write_indent_stream (self);
				_tmp10_ = self->priv->stream;
				_tmp11_ = i;
				_tmp12_ = (*_tmp11_).ns;
				_tmp13_ = i;
				_tmp14_ = (*_tmp13_).version;
				fprintf (_tmp10_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp12_, _tmp14_);
			}
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}

/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context      a code context
 * @param gir_filename a relative or absolute filename
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_gir_writer_write_file (ValaGIRWriter* self,
                            ValaCodeContext* context,
                            const gchar* directory,
                            const gchar* gir_filename,
                            const gchar* gir_namespace,
                            const gchar* gir_version,
                            const gchar* package,
                            const gchar* gir_shared_library)
{
	ValaCodeContext* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaNamespace* root_symbol = NULL;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaSymbol* glib_ns = NULL;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	ValaSymbol* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	gint _tmp39_;
	GString* _tmp40_;
	gchar* filename = NULL;
	gchar* _tmp41_;
	gboolean file_exists = FALSE;
	const gchar* _tmp42_;
	gchar* temp_filename = NULL;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	FILE* _tmp49_;
	FILE* _tmp53_;
	gchar* _tmp54_ = NULL;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gchar* header = NULL;
	gchar* _tmp67_;
	FILE* _tmp68_;
	const gchar* _tmp69_;
	FILE* _tmp70_;
	FILE* _tmp71_;
	FILE* _tmp72_;
	FILE* _tmp73_;
	FILE* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	FILE* _tmp77_;
	GString* _tmp78_;
	const gchar* _tmp79_;
	ValaHashSet* _tmp123_;
	gint _tmp124_;
	gint _tmp125_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_filename != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = g_strdup (directory);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp1_;
	_tmp2_ = g_strdup (gir_namespace);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp2_;
	_tmp3_ = g_strdup (gir_version);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp3_;
	_tmp4_ = g_strdup (gir_shared_library);
	_g_free0 (self->priv->gir_shared_library);
	self->priv->gir_shared_library = _tmp4_;
	_tmp5_ = vala_code_context_get_root (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	root_symbol = _tmp7_;
	_tmp8_ = root_symbol;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	glib_ns = _tmp11_;
	_tmp12_ = glib_ns;
	_tmp13_ = vala_symbol_get_scope (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp16_ = glib_ns;
	_tmp17_ = vala_symbol_get_scope (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "InitiallyUnowned");
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	self->priv->ginitiallyunowned_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp20_ = glib_ns;
	_tmp21_ = vala_symbol_get_scope (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_scope_lookup (_tmp22_, "TypeInterface");
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	self->priv->gtypeinterface_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp24_ = glib_ns;
	_tmp25_ = vala_symbol_get_scope (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_scope_lookup (_tmp26_, "TypeInstance");
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	self->priv->gtypeinstance_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "Type");
	_vala_code_node_unref0 (self->priv->gtype_type);
	self->priv->gtype_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	vala_gir_writer_write_package (self, package);
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp32_;
		gint _file_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _file_index = 0;
		_tmp32_ = vala_code_context_get_source_files (context);
		_file_list = _tmp32_;
		_tmp33_ = _file_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_file_size = _tmp35_;
		_file_index = -1;
		while (TRUE) {
			ValaSourceFile* file = NULL;
			ValaList* _tmp36_;
			gpointer _tmp37_;
			ValaSourceFile* _tmp38_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp36_ = _file_list;
			_tmp37_ = vala_list_get (_tmp36_, _file_index);
			file = (ValaSourceFile*) _tmp37_;
			_tmp38_ = file;
			vala_source_file_accept (_tmp38_, (ValaCodeVisitor*) self);
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_tmp39_ = self->priv->indent;
	self->priv->indent = _tmp39_ - 1;
	_tmp40_ = self->priv->buffer;
	g_string_append_printf (_tmp40_, "</repository>\n");
	_tmp41_ = g_strdup_printf ("%s%c%s", directory, (gint) G_DIR_SEPARATOR, gir_filename);
	filename = _tmp41_;
	_tmp42_ = filename;
	file_exists = g_file_test (_tmp42_, G_FILE_TEST_EXISTS);
	_tmp43_ = filename;
	_tmp44_ = g_strdup_printf ("%s.valatmp", _tmp43_);
	temp_filename = _tmp44_;
	if (file_exists) {
		const gchar* _tmp45_;
		FILE* _tmp46_;
		_tmp45_ = temp_filename;
		_tmp46_ = g_fopen (_tmp45_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp46_;
	} else {
		const gchar* _tmp47_;
		FILE* _tmp48_;
		_tmp47_ = filename;
		_tmp48_ = g_fopen (_tmp47_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp48_;
	}
	_tmp49_ = self->priv->stream;
	if (_tmp49_ == NULL) {
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp50_ = filename;
		_tmp51_ = g_strdup_printf ("unable to open `%s' for writing", _tmp50_);
		_tmp52_ = _tmp51_;
		vala_report_error (NULL, _tmp52_);
		_g_free0 (_tmp52_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
		_g_free0 (temp_filename);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp53_ = self->priv->stream;
	fprintf (_tmp53_, "<?xml version=\"1.0\"?>\n");
	_tmp55_ = vala_code_context_get_version_header (context);
	_tmp56_ = _tmp55_;
	if (_tmp56_) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp57_ = filename;
		_tmp58_ = g_path_get_basename (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_get_prgname ();
		_tmp61_ = g_strdup_printf ("<!-- %s generated by %s %s, do not modify. -->", _tmp59_, _tmp60_, VALA_BUILD_VERSION);
		_g_free0 (_tmp54_);
		_tmp54_ = _tmp61_;
		_g_free0 (_tmp59_);
	} else {
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp62_ = filename;
		_tmp63_ = g_path_get_basename (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_get_prgname ();
		_tmp66_ = g_strdup_printf ("<!-- %s generated by %s, do not modify. -->", _tmp64_, _tmp65_);
		_g_free0 (_tmp54_);
		_tmp54_ = _tmp66_;
		_g_free0 (_tmp64_);
	}
	_tmp67_ = g_strdup (_tmp54_);
	header = _tmp67_;
	_tmp68_ = self->priv->stream;
	_tmp69_ = header;
	fprintf (_tmp68_, "%s\n", _tmp69_);
	_tmp70_ = self->priv->stream;
	fprintf (_tmp70_, "<repository version=\"1.2\"");
	_tmp71_ = self->priv->stream;
	fprintf (_tmp71_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp72_ = self->priv->stream;
	fprintf (_tmp72_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp73_ = self->priv->stream;
	fprintf (_tmp73_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp74_ = self->priv->stream;
	fprintf (_tmp74_, ">\n");
	_tmp75_ = self->priv->indent;
	self->priv->indent = _tmp75_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp76_ = self->priv->indent;
	self->priv->indent = _tmp76_ - 1;
	_tmp77_ = self->priv->stream;
	_tmp78_ = self->priv->buffer;
	_tmp79_ = _tmp78_->str;
	fputs (_tmp79_, _tmp77_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	if (file_exists) {
		gboolean changed = FALSE;
		changed = TRUE;
		{
			GMappedFile* old_file = NULL;
			const gchar* _tmp80_;
			GMappedFile* _tmp81_;
			GMappedFile* new_file = NULL;
			const gchar* _tmp82_;
			GMappedFile* _tmp83_;
			gsize len = 0UL;
			GMappedFile* _tmp84_;
			GMappedFile* _tmp85_;
			_tmp80_ = filename;
			_tmp81_ = g_mapped_file_new (_tmp80_, FALSE, &_inner_error0_);
			old_file = _tmp81_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch6_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp54_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp82_ = temp_filename;
			_tmp83_ = g_mapped_file_new (_tmp82_, FALSE, &_inner_error0_);
			new_file = _tmp83_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (old_file);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch6_g_file_error;
				}
				_g_mapped_file_unref0 (old_file);
				_g_free0 (header);
				_g_free0 (_tmp54_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp84_ = old_file;
			len = g_mapped_file_get_length (_tmp84_);
			_tmp85_ = new_file;
			if (len == g_mapped_file_get_length (_tmp85_)) {
				GMappedFile* _tmp86_;
				gchar* _tmp87_;
				GMappedFile* _tmp88_;
				gchar* _tmp89_;
				_tmp86_ = old_file;
				_tmp87_ = g_mapped_file_get_contents (_tmp86_);
				_tmp88_ = new_file;
				_tmp89_ = g_mapped_file_get_contents (_tmp88_);
				if (memcmp (_tmp87_, _tmp89_, len) == 0) {
					changed = FALSE;
				}
			}
			_g_mapped_file_unref0 (old_file);
			old_file = NULL;
			_g_mapped_file_unref0 (new_file);
			new_file = NULL;
			_g_mapped_file_unref0 (new_file);
			_g_mapped_file_unref0 (old_file);
		}
		goto __finally6;
		__catch6_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (header);
			_g_free0 (_tmp54_);
			_g_free0 (temp_filename);
			_g_free0 (filename);
			_vala_code_node_unref0 (glib_ns);
			_vala_code_node_unref0 (root_symbol);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (changed) {
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			_tmp90_ = temp_filename;
			_tmp91_ = filename;
			g_rename (_tmp90_, _tmp91_);
		} else {
			const gchar* _tmp92_;
			_tmp92_ = temp_filename;
			g_unlink (_tmp92_);
		}
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp93_;
		ValaIterator* _tmp94_;
		_tmp93_ = self->priv->unannotated_namespaces;
		_tmp94_ = vala_iterable_iterator ((ValaIterable*) _tmp93_);
		_ns_it = _tmp94_;
		while (TRUE) {
			ValaIterator* _tmp95_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp96_;
			gpointer _tmp97_;
			ValaHashSet* _tmp98_;
			ValaNamespace* _tmp99_;
			_tmp95_ = _ns_it;
			if (!vala_iterator_next (_tmp95_)) {
				break;
			}
			_tmp96_ = _ns_it;
			_tmp97_ = vala_iterator_get (_tmp96_);
			ns = (ValaNamespace*) _tmp97_;
			_tmp98_ = self->priv->our_namespaces;
			_tmp99_ = ns;
			if (!vala_collection_contains ((ValaCollection*) _tmp98_, _tmp99_)) {
				ValaNamespace* _tmp100_;
				ValaSourceReference* _tmp101_;
				ValaSourceReference* _tmp102_;
				ValaNamespace* _tmp103_;
				const gchar* _tmp104_;
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				_tmp100_ = ns;
				_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
				_tmp102_ = _tmp101_;
				_tmp103_ = ns;
				_tmp104_ = vala_symbol_get_name ((ValaSymbol*) _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp105_);
				_tmp107_ = _tmp106_;
				vala_report_warning (_tmp102_, _tmp107_);
				_g_free0 (_tmp107_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp108_;
		ValaIterator* _tmp109_;
		_tmp108_ = self->priv->our_namespaces;
		_tmp109_ = vala_iterable_iterator ((ValaIterable*) _tmp108_);
		_ns_it = _tmp109_;
		while (TRUE) {
			ValaIterator* _tmp110_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp111_;
			gpointer _tmp112_;
			ValaNamespace* _tmp113_;
			ValaSourceReference* _tmp114_;
			ValaSourceReference* _tmp115_;
			ValaSourceFile* _tmp116_;
			ValaSourceFile* _tmp117_;
			ValaNamespace* _tmp118_;
			ValaSourceReference* _tmp119_;
			ValaSourceReference* _tmp120_;
			ValaSourceFile* _tmp121_;
			ValaSourceFile* _tmp122_;
			_tmp110_ = _ns_it;
			if (!vala_iterator_next (_tmp110_)) {
				break;
			}
			_tmp111_ = _ns_it;
			_tmp112_ = vala_iterator_get (_tmp111_);
			ns = (ValaNamespace*) _tmp112_;
			_tmp113_ = ns;
			_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_source_reference_get_file (_tmp115_);
			_tmp117_ = _tmp116_;
			vala_source_file_set_gir_namespace (_tmp117_, gir_namespace);
			_tmp118_ = ns;
			_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp118_);
			_tmp120_ = _tmp119_;
			_tmp121_ = vala_source_reference_get_file (_tmp120_);
			_tmp122_ = _tmp121_;
			vala_source_file_set_gir_version (_tmp122_, gir_version);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_tmp123_ = self->priv->our_namespaces;
	_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
	_tmp125_ = _tmp124_;
	if (_tmp125_ == 0) {
		vala_report_error (NULL, "No suitable namespace found to export for GIR");
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_g_free0 (header);
	_g_free0 (_tmp54_);
	_g_free0 (temp_filename);
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}

static void
vala_gir_writer_write_doc (ValaGIRWriter* self,
                           const gchar* comment)
{
	g_return_if_fail (self != NULL);
	if (comment != NULL) {
		GString* _tmp0_;
		GString* _tmp1_;
		GString* _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp0_ = self->priv->buffer;
		g_string_append (_tmp0_, "<doc xml:whitespace=\"preserve\">");
		_tmp1_ = self->priv->buffer;
		g_string_append (_tmp1_, comment);
		_tmp2_ = self->priv->buffer;
		g_string_append (_tmp2_, "</doc>\n");
	}
}

static void
vala_gir_writer_write_package (ValaGIRWriter* self,
                               const gchar* package)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", package);
}

static void
vala_gir_writer_write_c_includes (ValaGIRWriter* self,
                                  ValaNamespace* ns)
{
	ValaSet* header_filenames = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = vala_get_ccode_header_filenames ((ValaSymbol*) ns);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp7_;
		c_header_filename_collection_length1 = _tmp7__length1;
		for (c_header_filename_it = 0; c_header_filename_it < _tmp7__length1; c_header_filename_it = c_header_filename_it + 1) {
			const gchar* c_header_filename = NULL;
			c_header_filename = c_header_filename_collection[c_header_filename_it];
			{
				ValaSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = header_filenames;
				_tmp9_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _symbol_it = NULL;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMap* _tmp12_;
		ValaMap* _tmp13_;
		ValaCollection* _tmp14_;
		ValaCollection* _tmp15_;
		ValaIterator* _tmp16_;
		ValaIterator* _tmp17_;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) ns);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_scope_get_symbol_table (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_map_get_values (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_iterable_iterator ((ValaIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vala_iterable_unref0 (_tmp15_);
		_vala_map_unref0 (_tmp13_);
		_symbol_it = _tmp17_;
		while (TRUE) {
			ValaIterator* _tmp18_;
			ValaSymbol* symbol = NULL;
			ValaIterator* _tmp19_;
			gpointer _tmp20_;
			ValaSymbol* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			ValaSymbol* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp18_ = _symbol_it;
			if (!vala_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _symbol_it;
			_tmp20_ = vala_iterator_get (_tmp19_);
			symbol = (ValaSymbol*) _tmp20_;
			_tmp21_ = symbol;
			_tmp22_ = vala_symbol_get_external_package (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				_vala_code_node_unref0 (symbol);
				continue;
			}
			_tmp24_ = symbol;
			_tmp25_ = vala_get_ccode_header_filenames (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, ",", 0);
			_tmp29_ = _tmp28_;
			_tmp29__length1 = _vala_array_length (_tmp27_);
			_g_free0 (_tmp26_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp29_;
				c_header_filename_collection_length1 = _tmp29__length1;
				for (c_header_filename_it = 0; c_header_filename_it < _tmp29__length1; c_header_filename_it = c_header_filename_it + 1) {
					const gchar* c_header_filename = NULL;
					c_header_filename = c_header_filename_collection[c_header_filename_it];
					{
						ValaSet* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = header_filenames;
						_tmp31_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp30_, _tmp31_);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaIterator* _c_header_filename_it = NULL;
		ValaSet* _tmp32_;
		ValaIterator* _tmp33_;
		_tmp32_ = header_filenames;
		_tmp33_ = vala_iterable_iterator ((ValaIterable*) _tmp32_);
		_c_header_filename_it = _tmp33_;
		while (TRUE) {
			ValaIterator* _tmp34_;
			gchar* c_header_filename = NULL;
			ValaIterator* _tmp35_;
			gpointer _tmp36_;
			const gchar* _tmp37_;
			_tmp34_ = _c_header_filename_it;
			if (!vala_iterator_next (_tmp34_)) {
				break;
			}
			_tmp35_ = _c_header_filename_it;
			_tmp36_ = vala_iterator_get (_tmp35_);
			c_header_filename = (gchar*) _tmp36_;
			_tmp37_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp37_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}

static void
vala_gir_writer_write_c_include (ValaGIRWriter* self,
                                 const gchar* name)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", name);
}

static void
vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGIRWriter * self;
	ValaSourceFileType _tmp0_;
	ValaSourceFileType _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_file_type (source_file);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_SOURCE_FILE_TYPE_PACKAGE) {
		return;
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp2_;
		gint _node_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _node_index = 0;
		_tmp2_ = vala_source_file_get_nodes (source_file);
		_node_list = _tmp2_;
		_tmp3_ = _node_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_node_size = _tmp5_;
		_node_index = -1;
		while (TRUE) {
			ValaCodeNode* node = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaCodeNode* _tmp9_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp6_ = _node_list;
			_tmp7_ = vala_list_get (_tmp6_, _node_index);
			node = (ValaCodeNode*) _tmp7_;
			_tmp9_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_NAMESPACE)) {
				ValaCodeNode* _tmp10_;
				ValaSymbol* _tmp11_;
				ValaSymbol* _tmp12_;
				ValaCodeContext* _tmp13_;
				ValaNamespace* _tmp14_;
				ValaNamespace* _tmp15_;
				_tmp10_ = node;
				_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_tmp12_ = _tmp11_;
				_tmp13_ = self->priv->context;
				_tmp14_ = vala_code_context_get_root (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp8_ = _tmp12_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_SYMBOL, ValaSymbol);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaAttribute* a = NULL;
				ValaCodeNode* _tmp16_;
				ValaAttribute* _tmp17_;
				ValaAttribute* _tmp18_;
				gboolean _tmp19_ = FALSE;
				ValaAttribute* _tmp20_;
				gboolean _tmp25_ = FALSE;
				ValaAttribute* _tmp26_;
				_tmp16_ = node;
				_tmp17_ = vala_code_node_get_attribute (_tmp16_, "CCode");
				_tmp18_ = _vala_code_node_ref0 (_tmp17_);
				a = _tmp18_;
				_tmp20_ = a;
				if (_tmp20_ != NULL) {
					ValaAttribute* _tmp21_;
					_tmp21_ = a;
					_tmp19_ = vala_attribute_has_argument (_tmp21_, "gir_namespace");
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					ValaAttribute* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = a;
					_tmp23_ = vala_attribute_get_string (_tmp22_, "gir_namespace", NULL);
					_tmp24_ = _tmp23_;
					vala_source_file_set_gir_namespace (source_file, _tmp24_);
					_g_free0 (_tmp24_);
				}
				_tmp26_ = a;
				if (_tmp26_ != NULL) {
					ValaAttribute* _tmp27_;
					_tmp27_ = a;
					_tmp25_ = vala_attribute_has_argument (_tmp27_, "gir_version");
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					ValaAttribute* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp28_ = a;
					_tmp29_ = vala_attribute_get_string (_tmp28_, "gir_version", NULL);
					_tmp30_ = _tmp29_;
					vala_source_file_set_gir_version (source_file, _tmp30_);
					_g_free0 (_tmp30_);
				}
				_vala_code_node_unref0 (a);
				_vala_code_node_unref0 (node);
				break;
			}
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static void
vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base,
                                      ValaNamespace* ns)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* cprefix = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp19_;
	GString* _tmp22_;
	gint _tmp23_;
	ValaArrayList* _tmp24_;
	ValaArrayList* _tmp25_;
	gpointer _tmp26_;
	ValaSymbol* _tmp27_;
	gint _tmp28_;
	GString* _tmp29_;
	ValaHashSet* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_is_visibility (self, (ValaSymbol*) ns)) {
		return;
	}
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		gpointer _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp4_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp4_, 0, (ValaSymbol*) ns);
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		_tmp5_ = self->priv->hierarchy;
		_tmp6_ = vala_list_remove_at ((ValaList*) _tmp5_, 0);
		_tmp7_ = (ValaSymbol*) _tmp6_;
		_vala_code_node_unref0 (_tmp7_);
		return;
	}
	_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) ns);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_symbol_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		return;
	}
	vala_gir_writer_write_c_includes (self, ns);
	vala_gir_writer_write_indent (self);
	_tmp12_ = self->priv->buffer;
	_tmp13_ = self->priv->gir_namespace;
	_tmp14_ = self->priv->gir_version;
	g_string_append_printf (_tmp12_, "<namespace name=\"%s\" version=\"%s\"", _tmp13_, _tmp14_);
	_tmp15_ = vala_get_ccode_prefix ((ValaSymbol*) ns);
	cprefix = _tmp15_;
	_tmp16_ = self->priv->gir_shared_library;
	if (_tmp16_ != NULL) {
		GString* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->buffer;
		_tmp18_ = self->priv->gir_shared_library;
		g_string_append_printf (_tmp17_, " shared-library=\"%s\"", _tmp18_);
	}
	_tmp19_ = cprefix;
	if (_tmp19_ != NULL) {
		GString* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = self->priv->buffer;
		_tmp21_ = cprefix;
		g_string_append_printf (_tmp20_, " c:prefix=\"%s\"", _tmp21_);
	}
	_tmp22_ = self->priv->buffer;
	g_string_append_printf (_tmp22_, ">\n");
	_tmp23_ = self->priv->indent;
	self->priv->indent = _tmp23_ + 1;
	_tmp24_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp24_, 0, (ValaSymbol*) ns);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
	_tmp25_ = self->priv->hierarchy;
	_tmp26_ = vala_list_remove_at ((ValaList*) _tmp25_, 0);
	_tmp27_ = (ValaSymbol*) _tmp26_;
	_vala_code_node_unref0 (_tmp27_);
	_tmp28_ = self->priv->indent;
	self->priv->indent = _tmp28_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp29_ = self->priv->buffer;
	g_string_append_printf (_tmp29_, "</namespace>\n");
	_tmp30_ = self->priv->our_namespaces;
	vala_collection_add ((ValaCollection*) _tmp30_, ns);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}

static void
vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self,
                                         ValaSymbol* symbol)
{
	ValaVersionAttribute* _tmp1_;
	ValaVersionAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaVersionAttribute* _tmp18_;
	ValaVersionAttribute* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	if (!vala_gir_writer_is_introspectable (self, symbol)) {
		GString* _tmp0_;
		_tmp0_ = self->priv->buffer;
		g_string_append_printf (_tmp0_, " introspectable=\"0\"");
	}
	_tmp1_ = vala_symbol_get_version (symbol);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_version_attribute_get_deprecated (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GString* _tmp5_;
		ValaVersionAttribute* _tmp6_;
		ValaVersionAttribute* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp5_ = self->priv->buffer;
		g_string_append_printf (_tmp5_, " deprecated=\"1\"");
		_tmp6_ = vala_symbol_get_version (symbol);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_version_attribute_get_deprecated_since (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ != NULL;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			GString* _tmp12_;
			ValaVersionAttribute* _tmp13_;
			ValaVersionAttribute* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = self->priv->buffer;
			_tmp13_ = vala_symbol_get_version (symbol);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_version_attribute_get_deprecated_since (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			g_string_append_printf (_tmp12_, " deprecated-version=\"%s\"", _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
	_tmp18_ = vala_symbol_get_version (symbol);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_version_attribute_get_since (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_ != NULL;
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		GString* _tmp24_;
		ValaVersionAttribute* _tmp25_;
		ValaVersionAttribute* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp24_ = self->priv->buffer;
		_tmp25_ = vala_symbol_get_version (symbol);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_version_attribute_get_since (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		g_string_append_printf (_tmp24_, " version=\"%s\"", _tmp29_);
		_g_free0 (_tmp29_);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
vala_gir_writer_real_visit_class (ValaCodeVisitor* base,
                                  ValaClass* cl)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cl)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) cl);
		return;
	}
	_tmp7_ = vala_class_get_is_compact (cl);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		gchar* gtype_struct_name = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GString* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		ValaClass* _tmp18_;
		ValaClass* _tmp19_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		GString* _tmp41_;
		gint _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		GString* _tmp62_;
		gint _tmp63_;
		ValaClass* _tmp64_;
		ValaClass* _tmp65_;
		gint _tmp82_;
		GString* _tmp83_;
		ValaClass* _tmp84_;
		ValaClass* _tmp85_;
		GString* _tmp91_;
		gint _tmp92_;
		GString* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gint _tmp98_;
		GString* _tmp99_;
		gboolean _tmp100_ = FALSE;
		ValaClass* _tmp101_;
		ValaClass* _tmp102_;
		ValaArrayList* _tmp113_;
		ValaArrayList* _tmp114_;
		gpointer _tmp115_;
		ValaSymbol* _tmp116_;
		gint _tmp117_;
		GString* _tmp118_;
		GString* _tmp119_;
		const gchar* _tmp120_;
		GString* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		GString* _tmp124_;
		gint _tmp125_;
		GString* _tmp126_;
		gint _tmp127_;
		ValaClass* _tmp128_;
		ValaClass* _tmp129_;
		gint _tmp143_;
		GString* _tmp144_;
		gint _tmp255_;
		GString* _tmp256_;
		GString* _tmp257_;
		gchar* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		_tmp9_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "Class", NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		gtype_struct_name = _tmp12_;
		vala_gir_writer_write_indent (self);
		_tmp13_ = self->priv->buffer;
		_tmp14_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp15_ = _tmp14_;
		g_string_append_printf (_tmp13_, "<class name=\"%s\"", _tmp15_);
		_g_free0 (_tmp15_);
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) cl);
		_tmp16_ = self->priv->buffer;
		_tmp17_ = gtype_struct_name;
		g_string_append_printf (_tmp16_, " glib:type-struct=\"%s\"", _tmp17_);
		_tmp18_ = vala_class_get_base_class (cl);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			GString* _tmp20_;
			GString* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GString* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GString* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GString* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp20_ = self->priv->buffer;
			g_string_append_printf (_tmp20_, " glib:fundamental=\"1\"");
			_tmp21_ = self->priv->buffer;
			_tmp22_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) cl);
			_tmp23_ = _tmp22_;
			g_string_append_printf (_tmp21_, " glib:ref-func=\"%s\"", _tmp23_);
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->buffer;
			_tmp25_ = vala_get_ccode_unref_function ((ValaObjectTypeSymbol*) cl);
			_tmp26_ = _tmp25_;
			g_string_append_printf (_tmp24_, " glib:unref-func=\"%s\"", _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->buffer;
			_tmp28_ = vala_get_ccode_set_value_function ((ValaCodeNode*) cl);
			_tmp29_ = _tmp28_;
			g_string_append_printf (_tmp27_, " glib:set-value-func=\"%s\"", _tmp29_);
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->buffer;
			_tmp31_ = vala_get_ccode_get_value_function ((ValaCodeNode*) cl);
			_tmp32_ = _tmp31_;
			g_string_append_printf (_tmp30_, " glib:get-value-func=\"%s\"", _tmp32_);
			_g_free0 (_tmp32_);
		} else {
			GString* _tmp33_;
			ValaClass* _tmp34_;
			ValaClass* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp33_ = self->priv->buffer;
			_tmp34_ = vala_class_get_base_class (cl);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			g_string_append_printf (_tmp33_, " parent=\"%s\"", _tmp37_);
			_g_free0 (_tmp37_);
		}
		_tmp38_ = vala_class_get_is_abstract (cl);
		_tmp39_ = _tmp38_;
		if (_tmp39_) {
			GString* _tmp40_;
			_tmp40_ = self->priv->buffer;
			g_string_append_printf (_tmp40_, " abstract=\"1\"");
		}
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		_tmp41_ = self->priv->buffer;
		g_string_append_printf (_tmp41_, ">\n");
		_tmp42_ = self->priv->indent;
		self->priv->indent = _tmp42_ + 1;
		_tmp43_ = vala_gir_writer_get_class_comment (self, cl);
		_tmp44_ = _tmp43_;
		vala_gir_writer_write_doc (self, _tmp44_);
		_g_free0 (_tmp44_);
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp45_;
			gint _base_type_size = 0;
			ValaList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _base_type_index = 0;
			_tmp45_ = vala_class_get_base_types (cl);
			_base_type_list = _tmp45_;
			_tmp46_ = _base_type_list;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_base_type_size = _tmp48_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp49_;
				gpointer _tmp50_;
				ValaObjectType* object_type = NULL;
				ValaDataType* _tmp51_;
				ValaObjectType* _tmp52_;
				ValaObjectType* _tmp53_;
				ValaObjectTypeSymbol* _tmp54_;
				ValaObjectTypeSymbol* _tmp55_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp49_ = _base_type_list;
				_tmp50_ = vala_list_get (_tmp49_, _base_type_index);
				base_type = (ValaDataType*) _tmp50_;
				_tmp51_ = base_type;
				_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				object_type = _tmp52_;
				_tmp53_ = object_type;
				_tmp54_ = vala_object_type_get_type_symbol (_tmp53_);
				_tmp55_ = _tmp54_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_INTERFACE)) {
					GString* _tmp56_;
					ValaObjectType* _tmp57_;
					ValaObjectTypeSymbol* _tmp58_;
					ValaObjectTypeSymbol* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					vala_gir_writer_write_indent (self);
					_tmp56_ = self->priv->buffer;
					_tmp57_ = object_type;
					_tmp58_ = vala_object_type_get_type_symbol (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp59_);
					_tmp61_ = _tmp60_;
					g_string_append_printf (_tmp56_, "<implements name=\"%s\"/>\n", _tmp61_);
					_g_free0 (_tmp61_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		vala_gir_writer_write_indent (self);
		_tmp62_ = self->priv->buffer;
		g_string_append_printf (_tmp62_, "<field name=\"parent_instance\">\n");
		_tmp63_ = self->priv->indent;
		self->priv->indent = _tmp63_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp64_ = vala_class_get_base_class (cl);
		_tmp65_ = _tmp64_;
		if (_tmp65_ == NULL) {
			GString* _tmp66_;
			ValaTypeSymbol* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			ValaTypeSymbol* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp66_ = self->priv->buffer;
			_tmp67_ = self->priv->gtypeinstance_type;
			_tmp68_ = vala_gir_writer_gi_type_name (self, _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = self->priv->gtypeinstance_type;
			_tmp71_ = vala_get_ccode_name ((ValaCodeNode*) _tmp70_);
			_tmp72_ = _tmp71_;
			g_string_append_printf (_tmp66_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp69_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp69_);
		} else {
			GString* _tmp73_;
			ValaClass* _tmp74_;
			ValaClass* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			ValaClass* _tmp78_;
			ValaClass* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			_tmp73_ = self->priv->buffer;
			_tmp74_ = vala_class_get_base_class (cl);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_class_get_base_class (cl);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_get_ccode_name ((ValaCodeNode*) _tmp79_);
			_tmp81_ = _tmp80_;
			g_string_append_printf (_tmp73_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp77_, _tmp81_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp77_);
		}
		_tmp82_ = self->priv->indent;
		self->priv->indent = _tmp82_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp83_ = self->priv->buffer;
		g_string_append_printf (_tmp83_, "</field>\n");
		_tmp84_ = vala_class_get_base_class (cl);
		_tmp85_ = _tmp84_;
		if (_tmp85_ == NULL) {
			GString* _tmp86_;
			gint _tmp87_;
			GString* _tmp88_;
			gint _tmp89_;
			GString* _tmp90_;
			vala_gir_writer_write_indent (self);
			_tmp86_ = self->priv->buffer;
			g_string_append_printf (_tmp86_, "<field name=\"ref_count\">\n");
			_tmp87_ = self->priv->indent;
			self->priv->indent = _tmp87_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp88_ = self->priv->buffer;
			g_string_append_printf (_tmp88_, "<type name=\"gint\" c:type=\"volatile int\"/>\n");
			_tmp89_ = self->priv->indent;
			self->priv->indent = _tmp89_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp90_ = self->priv->buffer;
			g_string_append_printf (_tmp90_, "</field>\n");
		}
		vala_gir_writer_write_indent (self);
		_tmp91_ = self->priv->buffer;
		g_string_append_printf (_tmp91_, "<field name=\"priv\">\n");
		_tmp92_ = self->priv->indent;
		self->priv->indent = _tmp92_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp93_ = self->priv->buffer;
		_tmp94_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_get_ccode_name ((ValaCodeNode*) cl);
		_tmp97_ = _tmp96_;
		g_string_append_printf (_tmp93_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp95_, _tmp97_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
		_tmp98_ = self->priv->indent;
		self->priv->indent = _tmp98_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp99_ = self->priv->buffer;
		g_string_append_printf (_tmp99_, "</field>\n");
		_tmp101_ = vala_class_get_base_class (cl);
		_tmp102_ = _tmp101_;
		if (_tmp102_ != NULL) {
			ValaClass* _tmp103_;
			ValaClass* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			_tmp103_ = vala_class_get_base_class (cl);
			_tmp104_ = _tmp103_;
			_tmp105_ = self->priv->gobject_type;
			_tmp100_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp104_, _tmp105_);
		} else {
			_tmp100_ = FALSE;
		}
		if (_tmp100_) {
			{
				ValaList* _p_list = NULL;
				ValaList* _tmp106_;
				gint _p_size = 0;
				ValaList* _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gint _p_index = 0;
				_tmp106_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
				_p_list = _tmp106_;
				_tmp107_ = _p_list;
				_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
				_tmp109_ = _tmp108_;
				_p_size = _tmp109_;
				_p_index = -1;
				while (TRUE) {
					ValaTypeParameter* p = NULL;
					ValaList* _tmp110_;
					gpointer _tmp111_;
					ValaTypeParameter* _tmp112_;
					_p_index = _p_index + 1;
					if (!(_p_index < _p_size)) {
						break;
					}
					_tmp110_ = _p_list;
					_tmp111_ = vala_list_get (_tmp110_, _p_index);
					p = (ValaTypeParameter*) _tmp111_;
					_tmp112_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp112_, "property");
					_vala_code_node_unref0 (p);
				}
				_vala_iterable_unref0 (_p_list);
			}
		}
		_tmp113_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp113_, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		_tmp114_ = self->priv->hierarchy;
		_tmp115_ = vala_list_remove_at ((ValaList*) _tmp114_, 0);
		_tmp116_ = (ValaSymbol*) _tmp115_;
		_vala_code_node_unref0 (_tmp116_);
		_tmp117_ = self->priv->indent;
		self->priv->indent = _tmp117_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp118_ = self->priv->buffer;
		g_string_append_printf (_tmp118_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp119_ = self->priv->buffer;
		_tmp120_ = gtype_struct_name;
		g_string_append_printf (_tmp119_, "<record name=\"%s\"", _tmp120_);
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) cl, "Class");
		_tmp121_ = self->priv->buffer;
		_tmp122_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp123_ = _tmp122_;
		g_string_append_printf (_tmp121_, " glib:is-gtype-struct-for=\"%s\"", _tmp123_);
		_g_free0 (_tmp123_);
		_tmp124_ = self->priv->buffer;
		g_string_append_printf (_tmp124_, ">\n");
		_tmp125_ = self->priv->indent;
		self->priv->indent = _tmp125_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp126_ = self->priv->buffer;
		g_string_append_printf (_tmp126_, "<field name=\"parent_class\">\n");
		_tmp127_ = self->priv->indent;
		self->priv->indent = _tmp127_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp128_ = vala_class_get_base_class (cl);
		_tmp129_ = _tmp128_;
		if (_tmp129_ == NULL) {
			GString* _tmp130_;
			ValaTypeSymbol* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			_tmp130_ = self->priv->buffer;
			_tmp131_ = self->priv->gtype_type;
			_tmp132_ = vala_get_ccode_name ((ValaCodeNode*) _tmp131_);
			_tmp133_ = _tmp132_;
			g_string_append_printf (_tmp130_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", "GObject.Type", _tmp133_);
			_g_free0 (_tmp133_);
		} else {
			GString* _tmp134_;
			ValaClass* _tmp135_;
			ValaClass* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaClass* _tmp139_;
			ValaClass* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			_tmp134_ = self->priv->buffer;
			_tmp135_ = vala_class_get_base_class (cl);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_class_get_base_class (cl);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_get_ccode_name ((ValaCodeNode*) _tmp140_);
			_tmp142_ = _tmp141_;
			g_string_append_printf (_tmp134_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp138_, _tmp142_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp138_);
		}
		_tmp143_ = self->priv->indent;
		self->priv->indent = _tmp143_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp144_ = self->priv->buffer;
		g_string_append_printf (_tmp144_, "</field>\n");
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp145_;
			gint _m_size = 0;
			ValaList* _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			gint _m_index = 0;
			_tmp145_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
			_m_list = _tmp145_;
			_tmp146_ = _m_list;
			_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
			_tmp148_ = _tmp147_;
			_m_size = _tmp148_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp149_;
				gpointer _tmp150_;
				gboolean _tmp151_ = FALSE;
				ValaMethod* _tmp152_;
				gboolean _tmp153_;
				gboolean _tmp154_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp149_ = _m_list;
				_tmp150_ = vala_list_get (_tmp149_, _m_index);
				m = (ValaMethod*) _tmp150_;
				_tmp152_ = m;
				_tmp153_ = vala_method_get_is_abstract (_tmp152_);
				_tmp154_ = _tmp153_;
				if (_tmp154_) {
					_tmp151_ = TRUE;
				} else {
					ValaMethod* _tmp155_;
					gboolean _tmp156_;
					gboolean _tmp157_;
					_tmp155_ = m;
					_tmp156_ = vala_method_get_is_virtual (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp151_ = _tmp157_;
				}
				if (_tmp151_) {
					ValaMethod* _tmp158_;
					gboolean _tmp159_;
					gboolean _tmp160_;
					_tmp158_ = m;
					_tmp159_ = vala_method_get_coroutine (_tmp158_);
					_tmp160_ = _tmp159_;
					if (_tmp160_) {
						gchar* finish_name = NULL;
						ValaMethod* _tmp161_;
						const gchar* _tmp162_;
						const gchar* _tmp163_;
						gchar* _tmp164_;
						const gchar* _tmp165_;
						const gchar* _tmp173_;
						gchar* _tmp174_;
						GString* _tmp175_;
						ValaMethod* _tmp176_;
						const gchar* _tmp177_;
						const gchar* _tmp178_;
						gint _tmp179_;
						ValaMethod* _tmp180_;
						ValaMethod* _tmp181_;
						const gchar* _tmp182_;
						const gchar* _tmp183_;
						ValaMethod* _tmp184_;
						gchar* _tmp185_;
						gchar* _tmp186_;
						ValaMethod* _tmp187_;
						ValaList* _tmp188_;
						ValaList* _tmp189_;
						ValaVoidType* _tmp190_;
						ValaVoidType* _tmp191_;
						gint _tmp192_;
						GString* _tmp193_;
						GString* _tmp194_;
						const gchar* _tmp195_;
						gint _tmp196_;
						ValaMethod* _tmp197_;
						const gchar* _tmp198_;
						ValaMethod* _tmp199_;
						gchar* _tmp200_;
						gchar* _tmp201_;
						ValaMethod* _tmp202_;
						ValaList* _tmp203_;
						ValaList* _tmp204_;
						ValaMethod* _tmp205_;
						ValaDataType* _tmp206_;
						ValaDataType* _tmp207_;
						ValaMethod* _tmp208_;
						gboolean _tmp209_;
						gboolean _tmp210_;
						gint _tmp211_;
						GString* _tmp212_;
						_tmp161_ = m;
						_tmp162_ = vala_symbol_get_name ((ValaSymbol*) _tmp161_);
						_tmp163_ = _tmp162_;
						_tmp164_ = g_strdup (_tmp163_);
						finish_name = _tmp164_;
						_tmp165_ = finish_name;
						if (g_str_has_suffix (_tmp165_, "_async")) {
							const gchar* _tmp166_;
							const gchar* _tmp167_;
							gint _tmp168_;
							gint _tmp169_;
							gint _tmp170_;
							gint _tmp171_;
							gchar* _tmp172_;
							_tmp166_ = finish_name;
							_tmp167_ = finish_name;
							_tmp168_ = strlen (_tmp167_);
							_tmp169_ = _tmp168_;
							_tmp170_ = strlen ("_async");
							_tmp171_ = _tmp170_;
							_tmp172_ = string_substring (_tmp166_, (glong) 0, (glong) (_tmp169_ - _tmp171_));
							_g_free0 (finish_name);
							finish_name = _tmp172_;
						}
						_tmp173_ = finish_name;
						_tmp174_ = g_strconcat (_tmp173_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp174_;
						vala_gir_writer_write_indent (self);
						_tmp175_ = self->priv->buffer;
						_tmp176_ = m;
						_tmp177_ = vala_symbol_get_name ((ValaSymbol*) _tmp176_);
						_tmp178_ = _tmp177_;
						g_string_append_printf (_tmp175_, "<field name=\"%s\">\n", _tmp178_);
						_tmp179_ = self->priv->indent;
						self->priv->indent = _tmp179_ + 1;
						_tmp180_ = m;
						_tmp181_ = m;
						_tmp182_ = vala_symbol_get_name ((ValaSymbol*) _tmp181_);
						_tmp183_ = _tmp182_;
						_tmp184_ = m;
						_tmp185_ = vala_get_ccode_name ((ValaCodeNode*) _tmp184_);
						_tmp186_ = _tmp185_;
						_tmp187_ = m;
						_tmp188_ = vala_method_get_async_begin_parameters (_tmp187_);
						_tmp189_ = _tmp188_;
						_tmp190_ = vala_void_type_new (NULL);
						_tmp191_ = _tmp190_;
						vala_gir_writer_do_write_signature (self, _tmp180_, "callback", TRUE, _tmp183_, _tmp186_, _tmp189_, (ValaDataType*) _tmp191_, FALSE, FALSE);
						_vala_code_node_unref0 (_tmp191_);
						_vala_iterable_unref0 (_tmp189_);
						_g_free0 (_tmp186_);
						_tmp192_ = self->priv->indent;
						self->priv->indent = _tmp192_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp193_ = self->priv->buffer;
						g_string_append_printf (_tmp193_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp194_ = self->priv->buffer;
						_tmp195_ = finish_name;
						g_string_append_printf (_tmp194_, "<field name=\"%s\">\n", _tmp195_);
						_tmp196_ = self->priv->indent;
						self->priv->indent = _tmp196_ + 1;
						_tmp197_ = m;
						_tmp198_ = finish_name;
						_tmp199_ = m;
						_tmp200_ = vala_get_ccode_finish_name (_tmp199_);
						_tmp201_ = _tmp200_;
						_tmp202_ = m;
						_tmp203_ = vala_method_get_async_end_parameters (_tmp202_);
						_tmp204_ = _tmp203_;
						_tmp205_ = m;
						_tmp206_ = vala_callable_get_return_type ((ValaCallable*) _tmp205_);
						_tmp207_ = _tmp206_;
						_tmp208_ = m;
						_tmp209_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp208_);
						_tmp210_ = _tmp209_;
						vala_gir_writer_do_write_signature (self, _tmp197_, "callback", TRUE, _tmp198_, _tmp201_, _tmp204_, _tmp207_, _tmp210_, FALSE);
						_vala_iterable_unref0 (_tmp204_);
						_g_free0 (_tmp201_);
						_tmp211_ = self->priv->indent;
						self->priv->indent = _tmp211_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp212_ = self->priv->buffer;
						g_string_append_printf (_tmp212_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp213_;
						ValaMethod* _tmp214_;
						const gchar* _tmp215_;
						const gchar* _tmp216_;
						gint _tmp217_;
						ValaMethod* _tmp218_;
						ValaMethod* _tmp219_;
						const gchar* _tmp220_;
						const gchar* _tmp221_;
						ValaMethod* _tmp222_;
						gchar* _tmp223_;
						gchar* _tmp224_;
						ValaMethod* _tmp225_;
						ValaList* _tmp226_;
						ValaList* _tmp227_;
						ValaMethod* _tmp228_;
						ValaDataType* _tmp229_;
						ValaDataType* _tmp230_;
						ValaMethod* _tmp231_;
						gboolean _tmp232_;
						gboolean _tmp233_;
						gint _tmp234_;
						GString* _tmp235_;
						vala_gir_writer_write_indent (self);
						_tmp213_ = self->priv->buffer;
						_tmp214_ = m;
						_tmp215_ = vala_symbol_get_name ((ValaSymbol*) _tmp214_);
						_tmp216_ = _tmp215_;
						g_string_append_printf (_tmp213_, "<field name=\"%s\">\n", _tmp216_);
						_tmp217_ = self->priv->indent;
						self->priv->indent = _tmp217_ + 1;
						_tmp218_ = m;
						_tmp219_ = m;
						_tmp220_ = vala_symbol_get_name ((ValaSymbol*) _tmp219_);
						_tmp221_ = _tmp220_;
						_tmp222_ = m;
						_tmp223_ = vala_get_ccode_name ((ValaCodeNode*) _tmp222_);
						_tmp224_ = _tmp223_;
						_tmp225_ = m;
						_tmp226_ = vala_callable_get_parameters ((ValaCallable*) _tmp225_);
						_tmp227_ = _tmp226_;
						_tmp228_ = m;
						_tmp229_ = vala_callable_get_return_type ((ValaCallable*) _tmp228_);
						_tmp230_ = _tmp229_;
						_tmp231_ = m;
						_tmp232_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp231_);
						_tmp233_ = _tmp232_;
						vala_gir_writer_do_write_signature (self, _tmp218_, "callback", TRUE, _tmp221_, _tmp224_, _tmp227_, _tmp230_, _tmp233_, FALSE);
						_vala_iterable_unref0 (_tmp227_);
						_g_free0 (_tmp224_);
						_tmp234_ = self->priv->indent;
						self->priv->indent = _tmp234_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp235_ = self->priv->buffer;
						g_string_append_printf (_tmp235_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp236_;
			gint _sig_size = 0;
			ValaList* _tmp237_;
			gint _tmp238_;
			gint _tmp239_;
			gint _sig_index = 0;
			_tmp236_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl);
			_sig_list = _tmp236_;
			_tmp237_ = _sig_list;
			_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
			_tmp239_ = _tmp238_;
			_sig_size = _tmp239_;
			_sig_index = -1;
			while (TRUE) {
				ValaSignal* sig = NULL;
				ValaList* _tmp240_;
				gpointer _tmp241_;
				ValaSignal* _tmp242_;
				ValaMethod* _tmp243_;
				ValaMethod* _tmp244_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp240_ = _sig_list;
				_tmp241_ = vala_list_get (_tmp240_, _sig_index);
				sig = (ValaSignal*) _tmp241_;
				_tmp242_ = sig;
				_tmp243_ = vala_signal_get_default_handler (_tmp242_);
				_tmp244_ = _tmp243_;
				if (_tmp244_ != NULL) {
					GString* _tmp245_;
					ValaSignal* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					gint _tmp249_;
					ValaSignal* _tmp250_;
					ValaMethod* _tmp251_;
					ValaMethod* _tmp252_;
					gint _tmp253_;
					GString* _tmp254_;
					vala_gir_writer_write_indent (self);
					_tmp245_ = self->priv->buffer;
					_tmp246_ = sig;
					_tmp247_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp246_, NULL);
					_tmp248_ = _tmp247_;
					g_string_append_printf (_tmp245_, "<field name=\"%s\">\n", _tmp248_);
					_g_free0 (_tmp248_);
					_tmp249_ = self->priv->indent;
					self->priv->indent = _tmp249_ + 1;
					_tmp250_ = sig;
					_tmp251_ = vala_signal_get_default_handler (_tmp250_);
					_tmp252_ = _tmp251_;
					vala_gir_writer_write_signature (self, _tmp252_, "callback", FALSE, TRUE);
					_tmp253_ = self->priv->indent;
					self->priv->indent = _tmp253_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp254_ = self->priv->buffer;
					g_string_append_printf (_tmp254_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp255_ = self->priv->indent;
		self->priv->indent = _tmp255_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp256_ = self->priv->buffer;
		g_string_append_printf (_tmp256_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp257_ = self->priv->buffer;
		_tmp258_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_get_ccode_name ((ValaCodeNode*) cl);
		_tmp261_ = _tmp260_;
		g_string_append_printf (_tmp257_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp259_, _tmp261_);
		_g_free0 (_tmp261_);
		_g_free0 (_tmp259_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		GString* _tmp265_;
		gint _tmp266_;
		gchar* _tmp267_;
		gchar* _tmp268_;
		ValaArrayList* _tmp269_;
		ValaArrayList* _tmp270_;
		gpointer _tmp271_;
		ValaSymbol* _tmp272_;
		gint _tmp273_;
		GString* _tmp274_;
		vala_gir_writer_write_indent (self);
		_tmp262_ = self->priv->buffer;
		_tmp263_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp264_ = _tmp263_;
		g_string_append_printf (_tmp262_, "<record name=\"%s\"", _tmp264_);
		_g_free0 (_tmp264_);
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		_tmp265_ = self->priv->buffer;
		g_string_append_printf (_tmp265_, ">\n");
		_tmp266_ = self->priv->indent;
		self->priv->indent = _tmp266_ + 1;
		_tmp267_ = vala_gir_writer_get_class_comment (self, cl);
		_tmp268_ = _tmp267_;
		vala_gir_writer_write_doc (self, _tmp268_);
		_g_free0 (_tmp268_);
		_tmp269_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp269_, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		_tmp270_ = self->priv->hierarchy;
		_tmp271_ = vala_list_remove_at ((ValaList*) _tmp270_, 0);
		_tmp272_ = (ValaSymbol*) _tmp271_;
		_vala_code_node_unref0 (_tmp272_);
		_tmp273_ = self->priv->indent;
		self->priv->indent = _tmp273_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp274_ = self->priv->buffer;
		g_string_append_printf (_tmp274_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_struct (ValaCodeVisitor* base,
                                   ValaStruct* st)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	GString* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GString* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaArrayList* _tmp14_;
	ValaArrayList* _tmp15_;
	gpointer _tmp16_;
	ValaSymbol* _tmp17_;
	gint _tmp18_;
	GString* _tmp19_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) st)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) st);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp7_ = self->priv->buffer;
	_tmp8_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) st);
	_tmp9_ = _tmp8_;
	g_string_append_printf (_tmp7_, "<record name=\"%s\"", _tmp9_);
	_g_free0 (_tmp9_);
	if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) st)) {
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) st);
	} else {
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) st, "");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) st);
	_tmp10_ = self->priv->buffer;
	g_string_append_printf (_tmp10_, ">\n");
	_tmp11_ = self->priv->indent;
	self->priv->indent = _tmp11_ + 1;
	_tmp12_ = vala_gir_writer_get_struct_comment (self, st);
	_tmp13_ = _tmp12_;
	vala_gir_writer_write_doc (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp14_, 0, (ValaSymbol*) st);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	_tmp15_ = self->priv->hierarchy;
	_tmp16_ = vala_list_remove_at ((ValaList*) _tmp15_, 0);
	_tmp17_ = (ValaSymbol*) _tmp16_;
	_vala_code_node_unref0 (_tmp17_);
	_tmp18_ = self->priv->indent;
	self->priv->indent = _tmp18_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp19_ = self->priv->buffer;
	g_string_append_printf (_tmp19_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_interface (ValaCodeVisitor* base,
                                      ValaInterface* iface)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	gchar* gtype_struct_name = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GString* _tmp14_;
	const gchar* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaList* _tmp20_;
	ValaList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_;
	ValaArrayList* _tmp37_;
	ValaArrayList* _tmp38_;
	gpointer _tmp39_;
	ValaSymbol* _tmp40_;
	gint _tmp41_;
	GString* _tmp42_;
	GString* _tmp43_;
	const gchar* _tmp44_;
	GString* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GString* _tmp48_;
	gint _tmp49_;
	GString* _tmp50_;
	gint _tmp51_;
	GString* _tmp52_;
	ValaTypeSymbol* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gint _tmp59_;
	GString* _tmp60_;
	gint _tmp231_;
	GString* _tmp232_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) iface)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) iface);
		return;
	}
	_tmp7_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "Iface", NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	gtype_struct_name = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp13_ = _tmp12_;
	g_string_append_printf (_tmp11_, "<interface name=\"%s\"", _tmp13_);
	_g_free0 (_tmp13_);
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) iface);
	_tmp14_ = self->priv->buffer;
	_tmp15_ = gtype_struct_name;
	g_string_append_printf (_tmp14_, " glib:type-struct=\"%s\"", _tmp15_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) iface);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = vala_gir_writer_get_interface_comment (self, iface);
	_tmp19_ = _tmp18_;
	vala_gir_writer_write_doc (self, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = vala_interface_get_prerequisites (iface);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_ > 0;
	_vala_iterable_unref0 (_tmp21_);
	if (_tmp24_) {
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp25_;
			gint _base_type_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _base_type_index = 0;
			_tmp25_ = vala_interface_get_prerequisites (iface);
			_base_type_list = _tmp25_;
			_tmp26_ = _base_type_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_base_type_size = _tmp28_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				GString* _tmp31_;
				ValaDataType* _tmp32_;
				ValaObjectTypeSymbol* _tmp33_;
				ValaObjectTypeSymbol* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp29_ = _base_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _base_type_index);
				base_type = (ValaDataType*) _tmp30_;
				vala_gir_writer_write_indent (self);
				_tmp31_ = self->priv->buffer;
				_tmp32_ = base_type;
				_tmp33_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp34_);
				_tmp36_ = _tmp35_;
				g_string_append_printf (_tmp31_, "<prerequisite name=\"%s\"/>\n", _tmp36_);
				_g_free0 (_tmp36_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp37_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp37_, 0, (ValaSymbol*) iface);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	_tmp38_ = self->priv->hierarchy;
	_tmp39_ = vala_list_remove_at ((ValaList*) _tmp38_, 0);
	_tmp40_ = (ValaSymbol*) _tmp39_;
	_vala_code_node_unref0 (_tmp40_);
	_tmp41_ = self->priv->indent;
	self->priv->indent = _tmp41_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp42_ = self->priv->buffer;
	g_string_append_printf (_tmp42_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp43_ = self->priv->buffer;
	_tmp44_ = gtype_struct_name;
	g_string_append_printf (_tmp43_, "<record name=\"%s\"", _tmp44_);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) iface, "Iface");
	_tmp45_ = self->priv->buffer;
	_tmp46_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp47_ = _tmp46_;
	g_string_append_printf (_tmp45_, " glib:is-gtype-struct-for=\"%s\"", _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->buffer;
	g_string_append_printf (_tmp48_, ">\n");
	_tmp49_ = self->priv->indent;
	self->priv->indent = _tmp49_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp50_ = self->priv->buffer;
	g_string_append_printf (_tmp50_, "<field name=\"parent_iface\">\n");
	_tmp51_ = self->priv->indent;
	self->priv->indent = _tmp51_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp52_ = self->priv->buffer;
	_tmp53_ = self->priv->gtypeinterface_type;
	_tmp54_ = vala_gir_writer_gi_type_name (self, _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = self->priv->gtypeinterface_type;
	_tmp57_ = vala_get_ccode_name ((ValaCodeNode*) _tmp56_);
	_tmp58_ = _tmp57_;
	g_string_append_printf (_tmp52_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp55_, _tmp58_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp55_);
	_tmp59_ = self->priv->indent;
	self->priv->indent = _tmp59_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp60_ = self->priv->buffer;
	g_string_append_printf (_tmp60_, "</field>\n");
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp61_;
		gint _m_size = 0;
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _m_index = 0;
		_tmp61_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
		_m_list = _tmp61_;
		_tmp62_ = _m_list;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_m_size = _tmp64_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp65_;
			gpointer _tmp66_;
			gboolean _tmp67_ = FALSE;
			ValaMethod* _tmp68_;
			gboolean _tmp69_;
			gboolean _tmp70_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp65_ = _m_list;
			_tmp66_ = vala_list_get (_tmp65_, _m_index);
			m = (ValaMethod*) _tmp66_;
			_tmp68_ = m;
			_tmp69_ = vala_method_get_is_abstract (_tmp68_);
			_tmp70_ = _tmp69_;
			if (_tmp70_) {
				_tmp67_ = TRUE;
			} else {
				ValaMethod* _tmp71_;
				gboolean _tmp72_;
				gboolean _tmp73_;
				_tmp71_ = m;
				_tmp72_ = vala_method_get_is_virtual (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp67_ = _tmp73_;
			}
			if (_tmp67_) {
				ValaMethod* _tmp74_;
				gboolean _tmp75_;
				gboolean _tmp76_;
				_tmp74_ = m;
				_tmp75_ = vala_method_get_coroutine (_tmp74_);
				_tmp76_ = _tmp75_;
				if (_tmp76_) {
					gchar* finish_name = NULL;
					ValaMethod* _tmp77_;
					const gchar* _tmp78_;
					const gchar* _tmp79_;
					gchar* _tmp80_;
					const gchar* _tmp81_;
					const gchar* _tmp89_;
					gchar* _tmp90_;
					GString* _tmp91_;
					ValaMethod* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					gint _tmp95_;
					ValaMethod* _tmp96_;
					ValaMethod* _tmp97_;
					const gchar* _tmp98_;
					const gchar* _tmp99_;
					ValaMethod* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					ValaMethod* _tmp103_;
					ValaList* _tmp104_;
					ValaList* _tmp105_;
					ValaVoidType* _tmp106_;
					ValaVoidType* _tmp107_;
					gint _tmp108_;
					GString* _tmp109_;
					GString* _tmp110_;
					const gchar* _tmp111_;
					gint _tmp112_;
					ValaMethod* _tmp113_;
					const gchar* _tmp114_;
					ValaMethod* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					ValaMethod* _tmp118_;
					ValaList* _tmp119_;
					ValaList* _tmp120_;
					ValaMethod* _tmp121_;
					ValaDataType* _tmp122_;
					ValaDataType* _tmp123_;
					ValaMethod* _tmp124_;
					gboolean _tmp125_;
					gboolean _tmp126_;
					gint _tmp127_;
					GString* _tmp128_;
					_tmp77_ = m;
					_tmp78_ = vala_symbol_get_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strdup (_tmp79_);
					finish_name = _tmp80_;
					_tmp81_ = finish_name;
					if (g_str_has_suffix (_tmp81_, "_async")) {
						const gchar* _tmp82_;
						const gchar* _tmp83_;
						gint _tmp84_;
						gint _tmp85_;
						gint _tmp86_;
						gint _tmp87_;
						gchar* _tmp88_;
						_tmp82_ = finish_name;
						_tmp83_ = finish_name;
						_tmp84_ = strlen (_tmp83_);
						_tmp85_ = _tmp84_;
						_tmp86_ = strlen ("_async");
						_tmp87_ = _tmp86_;
						_tmp88_ = string_substring (_tmp82_, (glong) 0, (glong) (_tmp85_ - _tmp87_));
						_g_free0 (finish_name);
						finish_name = _tmp88_;
					}
					_tmp89_ = finish_name;
					_tmp90_ = g_strconcat (_tmp89_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp90_;
					vala_gir_writer_write_indent (self);
					_tmp91_ = self->priv->buffer;
					_tmp92_ = m;
					_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
					_tmp94_ = _tmp93_;
					g_string_append_printf (_tmp91_, "<field name=\"%s\">\n", _tmp94_);
					_tmp95_ = self->priv->indent;
					self->priv->indent = _tmp95_ + 1;
					_tmp96_ = m;
					_tmp97_ = m;
					_tmp98_ = vala_symbol_get_name ((ValaSymbol*) _tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = m;
					_tmp101_ = vala_get_ccode_name ((ValaCodeNode*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = m;
					_tmp104_ = vala_method_get_async_begin_parameters (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_void_type_new (NULL);
					_tmp107_ = _tmp106_;
					vala_gir_writer_do_write_signature (self, _tmp96_, "callback", TRUE, _tmp99_, _tmp102_, _tmp105_, (ValaDataType*) _tmp107_, FALSE, FALSE);
					_vala_code_node_unref0 (_tmp107_);
					_vala_iterable_unref0 (_tmp105_);
					_g_free0 (_tmp102_);
					_tmp108_ = self->priv->indent;
					self->priv->indent = _tmp108_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp109_ = self->priv->buffer;
					g_string_append_printf (_tmp109_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp110_ = self->priv->buffer;
					_tmp111_ = finish_name;
					g_string_append_printf (_tmp110_, "<field name=\"%s\">\n", _tmp111_);
					_tmp112_ = self->priv->indent;
					self->priv->indent = _tmp112_ + 1;
					_tmp113_ = m;
					_tmp114_ = finish_name;
					_tmp115_ = m;
					_tmp116_ = vala_get_ccode_finish_name (_tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = m;
					_tmp119_ = vala_method_get_async_end_parameters (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = m;
					_tmp122_ = vala_callable_get_return_type ((ValaCallable*) _tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = m;
					_tmp125_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp124_);
					_tmp126_ = _tmp125_;
					vala_gir_writer_do_write_signature (self, _tmp113_, "callback", TRUE, _tmp114_, _tmp117_, _tmp120_, _tmp123_, _tmp126_, FALSE);
					_vala_iterable_unref0 (_tmp120_);
					_g_free0 (_tmp117_);
					_tmp127_ = self->priv->indent;
					self->priv->indent = _tmp127_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp128_ = self->priv->buffer;
					g_string_append_printf (_tmp128_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp129_;
					ValaMethod* _tmp130_;
					const gchar* _tmp131_;
					const gchar* _tmp132_;
					gint _tmp133_;
					ValaMethod* _tmp134_;
					ValaMethod* _tmp135_;
					const gchar* _tmp136_;
					const gchar* _tmp137_;
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					ValaMethod* _tmp141_;
					ValaList* _tmp142_;
					ValaList* _tmp143_;
					ValaMethod* _tmp144_;
					ValaDataType* _tmp145_;
					ValaDataType* _tmp146_;
					ValaMethod* _tmp147_;
					gboolean _tmp148_;
					gboolean _tmp149_;
					gint _tmp150_;
					GString* _tmp151_;
					vala_gir_writer_write_indent (self);
					_tmp129_ = self->priv->buffer;
					_tmp130_ = m;
					_tmp131_ = vala_symbol_get_name ((ValaSymbol*) _tmp130_);
					_tmp132_ = _tmp131_;
					g_string_append_printf (_tmp129_, "<field name=\"%s\">\n", _tmp132_);
					_tmp133_ = self->priv->indent;
					self->priv->indent = _tmp133_ + 1;
					_tmp134_ = m;
					_tmp135_ = m;
					_tmp136_ = vala_symbol_get_name ((ValaSymbol*) _tmp135_);
					_tmp137_ = _tmp136_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_name ((ValaCodeNode*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = m;
					_tmp142_ = vala_callable_get_parameters ((ValaCallable*) _tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = m;
					_tmp145_ = vala_callable_get_return_type ((ValaCallable*) _tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = m;
					_tmp148_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp147_);
					_tmp149_ = _tmp148_;
					vala_gir_writer_do_write_signature (self, _tmp134_, "callback", TRUE, _tmp137_, _tmp140_, _tmp143_, _tmp146_, _tmp149_, FALSE);
					_vala_iterable_unref0 (_tmp143_);
					_g_free0 (_tmp140_);
					_tmp150_ = self->priv->indent;
					self->priv->indent = _tmp150_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp151_ = self->priv->buffer;
					g_string_append_printf (_tmp151_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp152_;
		gint _prop_size = 0;
		ValaList* _tmp153_;
		gint _tmp154_;
		gint _tmp155_;
		gint _prop_index = 0;
		_tmp152_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
		_prop_list = _tmp152_;
		_tmp153_ = _prop_list;
		_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
		_tmp155_ = _tmp154_;
		_prop_size = _tmp155_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp156_;
			gpointer _tmp157_;
			gboolean _tmp158_ = FALSE;
			ValaProperty* _tmp159_;
			gboolean _tmp160_;
			gboolean _tmp161_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp156_ = _prop_list;
			_tmp157_ = vala_list_get (_tmp156_, _prop_index);
			prop = (ValaProperty*) _tmp157_;
			_tmp159_ = prop;
			_tmp160_ = vala_property_get_is_abstract (_tmp159_);
			_tmp161_ = _tmp160_;
			if (_tmp161_) {
				_tmp158_ = TRUE;
			} else {
				ValaProperty* _tmp162_;
				gboolean _tmp163_;
				gboolean _tmp164_;
				_tmp162_ = prop;
				_tmp163_ = vala_property_get_is_virtual (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp158_ = _tmp164_;
			}
			if (_tmp158_) {
				ValaProperty* _tmp165_;
				ValaPropertyAccessor* _tmp166_;
				ValaPropertyAccessor* _tmp167_;
				gboolean _tmp195_ = FALSE;
				ValaProperty* _tmp196_;
				ValaPropertyAccessor* _tmp197_;
				ValaPropertyAccessor* _tmp198_;
				_tmp165_ = prop;
				_tmp166_ = vala_property_get_get_accessor (_tmp165_);
				_tmp167_ = _tmp166_;
				if (_tmp167_ != NULL) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp168_;
					ValaPropertyAccessor* _tmp169_;
					ValaPropertyAccessor* _tmp170_;
					ValaMethod* _tmp171_;
					GString* _tmp172_;
					ValaMethod* _tmp173_;
					const gchar* _tmp174_;
					const gchar* _tmp175_;
					gint _tmp176_;
					ValaMethod* _tmp177_;
					ValaMethod* _tmp178_;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					ValaMethod* _tmp181_;
					gchar* _tmp182_;
					gchar* _tmp183_;
					ValaMethod* _tmp184_;
					ValaList* _tmp185_;
					ValaList* _tmp186_;
					ValaMethod* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					ValaMethod* _tmp190_;
					gboolean _tmp191_;
					gboolean _tmp192_;
					gint _tmp193_;
					GString* _tmp194_;
					_tmp168_ = prop;
					_tmp169_ = vala_property_get_get_accessor (_tmp168_);
					_tmp170_ = _tmp169_;
					_tmp171_ = vala_property_accessor_get_method (_tmp170_);
					m = _tmp171_;
					vala_gir_writer_write_indent (self);
					_tmp172_ = self->priv->buffer;
					_tmp173_ = m;
					_tmp174_ = vala_symbol_get_name ((ValaSymbol*) _tmp173_);
					_tmp175_ = _tmp174_;
					g_string_append_printf (_tmp172_, "<field name=\"%s\">\n", _tmp175_);
					_tmp176_ = self->priv->indent;
					self->priv->indent = _tmp176_ + 1;
					_tmp177_ = m;
					_tmp178_ = m;
					_tmp179_ = vala_symbol_get_name ((ValaSymbol*) _tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = m;
					_tmp182_ = vala_get_ccode_name ((ValaCodeNode*) _tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = m;
					_tmp185_ = vala_callable_get_parameters ((ValaCallable*) _tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = m;
					_tmp188_ = vala_callable_get_return_type ((ValaCallable*) _tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = m;
					_tmp191_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp190_);
					_tmp192_ = _tmp191_;
					vala_gir_writer_do_write_signature (self, _tmp177_, "callback", TRUE, _tmp180_, _tmp183_, _tmp186_, _tmp189_, _tmp192_, FALSE);
					_vala_iterable_unref0 (_tmp186_);
					_g_free0 (_tmp183_);
					_tmp193_ = self->priv->indent;
					self->priv->indent = _tmp193_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp194_ = self->priv->buffer;
					g_string_append_printf (_tmp194_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
				_tmp196_ = prop;
				_tmp197_ = vala_property_get_set_accessor (_tmp196_);
				_tmp198_ = _tmp197_;
				if (_tmp198_ != NULL) {
					ValaProperty* _tmp199_;
					ValaPropertyAccessor* _tmp200_;
					ValaPropertyAccessor* _tmp201_;
					gboolean _tmp202_;
					gboolean _tmp203_;
					_tmp199_ = prop;
					_tmp200_ = vala_property_get_set_accessor (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_property_accessor_get_writable (_tmp201_);
					_tmp203_ = _tmp202_;
					_tmp195_ = _tmp203_;
				} else {
					_tmp195_ = FALSE;
				}
				if (_tmp195_) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp204_;
					ValaPropertyAccessor* _tmp205_;
					ValaPropertyAccessor* _tmp206_;
					ValaMethod* _tmp207_;
					GString* _tmp208_;
					ValaMethod* _tmp209_;
					const gchar* _tmp210_;
					const gchar* _tmp211_;
					gint _tmp212_;
					ValaMethod* _tmp213_;
					ValaMethod* _tmp214_;
					const gchar* _tmp215_;
					const gchar* _tmp216_;
					ValaMethod* _tmp217_;
					gchar* _tmp218_;
					gchar* _tmp219_;
					ValaMethod* _tmp220_;
					ValaList* _tmp221_;
					ValaList* _tmp222_;
					ValaMethod* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					ValaMethod* _tmp226_;
					gboolean _tmp227_;
					gboolean _tmp228_;
					gint _tmp229_;
					GString* _tmp230_;
					_tmp204_ = prop;
					_tmp205_ = vala_property_get_set_accessor (_tmp204_);
					_tmp206_ = _tmp205_;
					_tmp207_ = vala_property_accessor_get_method (_tmp206_);
					m = _tmp207_;
					vala_gir_writer_write_indent (self);
					_tmp208_ = self->priv->buffer;
					_tmp209_ = m;
					_tmp210_ = vala_symbol_get_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					g_string_append_printf (_tmp208_, "<field name=\"%s\">\n", _tmp211_);
					_tmp212_ = self->priv->indent;
					self->priv->indent = _tmp212_ + 1;
					_tmp213_ = m;
					_tmp214_ = m;
					_tmp215_ = vala_symbol_get_name ((ValaSymbol*) _tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = m;
					_tmp218_ = vala_get_ccode_name ((ValaCodeNode*) _tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = m;
					_tmp221_ = vala_callable_get_parameters ((ValaCallable*) _tmp220_);
					_tmp222_ = _tmp221_;
					_tmp223_ = m;
					_tmp224_ = vala_callable_get_return_type ((ValaCallable*) _tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = m;
					_tmp227_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp226_);
					_tmp228_ = _tmp227_;
					vala_gir_writer_do_write_signature (self, _tmp213_, "callback", TRUE, _tmp216_, _tmp219_, _tmp222_, _tmp225_, _tmp228_, FALSE);
					_vala_iterable_unref0 (_tmp222_);
					_g_free0 (_tmp219_);
					_tmp229_ = self->priv->indent;
					self->priv->indent = _tmp229_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp230_ = self->priv->buffer;
					g_string_append_printf (_tmp230_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp231_ = self->priv->indent;
	self->priv->indent = _tmp231_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp232_ = self->priv->buffer;
	g_string_append_printf (_tmp232_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}

static void
vala_gir_writer_visit_deferred (ValaGIRWriter* self)
{
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		gint _node_size = 0;
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _node_index = 0;
		_tmp4_ = nodes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_node_list = _tmp5_;
		_tmp6_ = _node_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_node_size = _tmp8_;
		_node_index = -1;
		while (TRUE) {
			ValaCodeNode* node = NULL;
			ValaArrayList* _tmp9_;
			gpointer _tmp10_;
			ValaCodeNode* _tmp11_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp9_ = _node_list;
			_tmp10_ = vala_list_get ((ValaList*) _tmp9_, _node_index);
			node = (ValaCodeNode*) _tmp10_;
			_tmp11_ = node;
			vala_code_node_accept (_tmp11_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}

static gchar*
vala_gir_writer_get_gir_name (ValaGIRWriter* self,
                              ValaSymbol* symbol)
{
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaSymbol* h0 = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* cur_sym = NULL;
		ValaSymbol* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (symbol);
		cur_sym = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp8_;
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				gchar* cur_name = NULL;
				ValaSymbol* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				if (!_tmp3_) {
					ValaSymbol* _tmp4_;
					ValaSymbol* _tmp5_;
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					_tmp4_ = cur_sym;
					_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = _vala_code_node_ref0 (_tmp6_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp7_;
				}
				_tmp3_ = FALSE;
				_tmp8_ = cur_sym;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = cur_sym;
				_tmp10_ = h0;
				if (_tmp9_ == _tmp10_) {
					break;
				}
				_tmp11_ = cur_sym;
				_tmp12_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp11_, "GIR", "name", NULL);
				cur_name = _tmp12_;
				_tmp13_ = cur_name;
				if (_tmp13_ == NULL) {
					ValaSymbol* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp14_ = cur_sym;
					_tmp15_ = vala_symbol_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (cur_name);
					cur_name = _tmp17_;
				}
				_tmp18_ = cur_name;
				_tmp19_ = gir_name;
				_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp20_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}

static void
vala_gir_writer_real_visit_enum (ValaCodeVisitor* base,
                                 ValaEnum* en)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gchar* element_name = NULL;
	gchar* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GString* _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaArrayList* _tmp19_;
	ValaArrayList* _tmp20_;
	gpointer _tmp21_;
	ValaSymbol* _tmp22_;
	gint _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) en)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) en);
		return;
	}
	_tmp8_ = vala_enum_get_is_flags (en);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp7_ = "bitfield";
	} else {
		_tmp7_ = "enumeration";
	}
	_tmp10_ = g_strdup (_tmp7_);
	element_name = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = element_name;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) en);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<%s name=\"%s\"", _tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) en)) {
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) en);
	} else {
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) en, "");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) en);
	_tmp15_ = self->priv->buffer;
	g_string_append_printf (_tmp15_, ">\n");
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ + 1;
	_tmp17_ = vala_gir_writer_get_enum_comment (self, en);
	_tmp18_ = _tmp17_;
	vala_gir_writer_write_doc (self, _tmp18_);
	_g_free0 (_tmp18_);
	self->priv->enum_value = 0;
	_tmp19_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp19_, 0, (ValaSymbol*) en);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	_tmp20_ = self->priv->hierarchy;
	_tmp21_ = vala_list_remove_at ((ValaList*) _tmp20_, 0);
	_tmp22_ = (ValaSymbol*) _tmp21_;
	_vala_code_node_unref0 (_tmp22_);
	_tmp23_ = self->priv->indent;
	self->priv->indent = _tmp23_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp24_ = self->priv->buffer;
	_tmp25_ = element_name;
	g_string_append_printf (_tmp24_, "</%s>\n", _tmp25_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}

static void
vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base,
                                       ValaEnumValue* ev)
{
	ValaGIRWriter * self;
	ValaEnum* en = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gchar* comment = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp1_, VALA_TYPE_ENUM, ValaEnum);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) ev);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_get_ccode_name ((ValaCodeNode*) ev);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = vala_constant_get_value ((ValaConstant*) ev);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		gchar* value = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		gchar* _tmp13_;
		GString* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = vala_constant_get_value ((ValaConstant*) ev);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp12_);
		value = _tmp13_;
		_tmp14_ = self->priv->buffer;
		_tmp15_ = value;
		g_string_append_printf (_tmp14_, " value=\"%s\"", _tmp15_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = en;
		_tmp17_ = vala_enum_get_is_flags (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			GString* _tmp19_;
			gint _tmp20_;
			_tmp19_ = self->priv->buffer;
			_tmp20_ = self->priv->enum_value;
			self->priv->enum_value = _tmp20_ + 1;
			g_string_append_printf (_tmp19_, " value=\"%d\"", 1 << _tmp20_);
		} else {
			GString* _tmp21_;
			gint _tmp22_;
			_tmp21_ = self->priv->buffer;
			_tmp22_ = self->priv->enum_value;
			self->priv->enum_value = _tmp22_ + 1;
			g_string_append_printf (_tmp21_, " value=\"%d\"", _tmp22_);
		}
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ev);
	_tmp23_ = vala_gir_writer_get_enum_value_comment (self, ev);
	comment = _tmp23_;
	_tmp24_ = comment;
	if (_tmp24_ == NULL) {
		GString* _tmp25_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, "/>\n");
	} else {
		GString* _tmp26_;
		gint _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		GString* _tmp30_;
		_tmp26_ = self->priv->buffer;
		g_string_append_printf (_tmp26_, ">\n");
		_tmp27_ = self->priv->indent;
		self->priv->indent = _tmp27_ + 1;
		_tmp28_ = comment;
		vala_gir_writer_write_doc (self, _tmp28_);
		_tmp29_ = self->priv->indent;
		self->priv->indent = _tmp29_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp30_ = self->priv->buffer;
		g_string_append_printf (_tmp30_, "</member>\n");
	}
	_g_free0 (comment);
	_vala_code_node_unref0 (en);
}

static void
vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                         ValaErrorDomain* edomain)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GString* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaArrayList* _tmp12_;
	ValaArrayList* _tmp13_;
	gpointer _tmp14_;
	ValaSymbol* _tmp15_;
	gint _tmp16_;
	GString* _tmp17_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) edomain)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<enumeration name=\"%s\"", _tmp4_);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) edomain, "");
	_tmp5_ = self->priv->buffer;
	_tmp6_ = vala_get_ccode_quark_name (edomain);
	_tmp7_ = _tmp6_;
	g_string_append_printf (_tmp5_, " glib:error-domain=\"%s\"", _tmp7_);
	_g_free0 (_tmp7_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) edomain);
	_tmp8_ = self->priv->buffer;
	g_string_append_printf (_tmp8_, ">\n");
	_tmp9_ = self->priv->indent;
	self->priv->indent = _tmp9_ + 1;
	_tmp10_ = vala_gir_writer_get_error_domain_comment (self, edomain);
	_tmp11_ = _tmp10_;
	vala_gir_writer_write_doc (self, _tmp11_);
	_g_free0 (_tmp11_);
	self->priv->enum_value = 0;
	_tmp12_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp12_, 0, (ValaSymbol*) edomain);
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	_tmp13_ = self->priv->hierarchy;
	_tmp14_ = vala_list_remove_at ((ValaList*) _tmp13_, 0);
	_tmp15_ = (ValaSymbol*) _tmp14_;
	_vala_code_node_unref0 (_tmp15_);
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	g_string_append_printf (_tmp17_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base,
                                       ValaErrorCode* ecode)
{
	ValaGIRWriter * self;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	gchar* comment = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) ecode);
	_tmp6_ = _tmp5_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = vala_error_code_get_value (ecode);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		gchar* value = NULL;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		gchar* _tmp11_;
		GString* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_ = vala_error_code_get_value (ecode);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp10_);
		value = _tmp11_;
		_tmp12_ = self->priv->buffer;
		_tmp13_ = value;
		g_string_append_printf (_tmp12_, " value=\"%s\"", _tmp13_);
		_g_free0 (value);
	} else {
		GString* _tmp14_;
		gint _tmp15_;
		_tmp14_ = self->priv->buffer;
		_tmp15_ = self->priv->enum_value;
		self->priv->enum_value = _tmp15_ + 1;
		g_string_append_printf (_tmp14_, " value=\"%d\"", _tmp15_);
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ecode);
	_tmp16_ = vala_gir_writer_get_error_code_comment (self, ecode);
	comment = _tmp16_;
	_tmp17_ = comment;
	if (_tmp17_ == NULL) {
		GString* _tmp18_;
		_tmp18_ = self->priv->buffer;
		g_string_append_printf (_tmp18_, "/>\n");
	} else {
		GString* _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		GString* _tmp23_;
		_tmp19_ = self->priv->buffer;
		g_string_append_printf (_tmp19_, ">\n");
		_tmp20_ = self->priv->indent;
		self->priv->indent = _tmp20_ + 1;
		_tmp21_ = comment;
		vala_gir_writer_write_doc (self, _tmp21_);
		_tmp22_ = self->priv->indent;
		self->priv->indent = _tmp22_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp23_ = self->priv->buffer;
		g_string_append_printf (_tmp23_, "</member>\n");
	}
	_g_free0 (comment);
}

static void
vala_gir_writer_real_visit_constant (ValaCodeVisitor* base,
                                     ValaConstant* c)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* initializer = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* value = NULL;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaExpression* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gint _tmp21_;
	GString* _tmp22_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) c);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) c)) {
		return;
	}
	_tmp2_ = vala_constant_get_value (c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	initializer = _tmp4_;
	_tmp5_ = initializer;
	_tmp6_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp5_);
	value = _tmp6_;
	vala_gir_writer_write_indent (self);
	_tmp7_ = self->priv->buffer;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_get_ccode_name ((ValaCodeNode*) c);
	_tmp11_ = _tmp10_;
	g_string_append_printf (_tmp7_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->buffer;
	_tmp13_ = value;
	g_string_append_printf (_tmp12_, " value=\"%s\"", _tmp13_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) c);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	_tmp16_ = vala_gir_writer_get_constant_comment (self, c);
	_tmp17_ = _tmp16_;
	vala_gir_writer_write_doc (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = initializer;
	_tmp19_ = vala_expression_get_value_type (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_type (self, _tmp20_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp21_ = self->priv->indent;
	self->priv->indent = _tmp21_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp22_ = self->priv->buffer;
	g_string_append_printf (_tmp22_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}

static void
vala_gir_writer_real_visit_field (ValaCodeVisitor* base,
                                  ValaField* f)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GString* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	gint _tmp16_;
	GString* _tmp17_;
	gboolean _tmp18_ = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) f)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_get_ccode_name ((ValaCodeNode*) f);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<field name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_data_type_get_nullable (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GString* _tmp9_;
		_tmp9_ = self->priv->buffer;
		g_string_append_printf (_tmp9_, " allow-none=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
	_tmp10_ = self->priv->buffer;
	g_string_append_printf (_tmp10_, ">\n");
	_tmp11_ = self->priv->indent;
	self->priv->indent = _tmp11_ + 1;
	_tmp12_ = vala_gir_writer_get_field_comment (self, f);
	_tmp13_ = _tmp12_;
	vala_gir_writer_write_doc (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp15_ = _tmp14_;
	vala_gir_writer_write_type (self, _tmp15_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	g_string_append_printf (_tmp17_, "</field>\n");
	_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp20_ = _tmp19_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ARRAY_TYPE)) {
		_tmp18_ = vala_get_ccode_array_length ((ValaCodeNode*) f);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaArrayType* _tmp23_;
		ValaArrayType* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) f);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp23_;
		_tmp24_ = array_type;
		_tmp25_ = vala_array_type_get_fixed_length (_tmp24_);
		_tmp26_ = _tmp25_;
		if (!_tmp26_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						ValaArrayType* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						GString* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						GString* _tmp35_;
						gint _tmp36_;
						ValaArrayType* _tmp37_;
						ValaDataType* _tmp38_;
						ValaDataType* _tmp39_;
						gint _tmp40_;
						GString* _tmp41_;
						if (!_tmp27_) {
							gint _tmp28_;
							_tmp28_ = i;
							i = _tmp28_ + 1;
						}
						_tmp27_ = FALSE;
						_tmp29_ = array_type;
						_tmp30_ = vala_array_type_get_rank (_tmp29_);
						_tmp31_ = _tmp30_;
						if (!(i < _tmp31_)) {
							break;
						}
						vala_gir_writer_write_indent (self);
						_tmp32_ = self->priv->buffer;
						_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) f);
						_tmp34_ = _tmp33_;
						g_string_append_printf (_tmp32_, "<field name=\"%s_length%i\"", _tmp34_, i + 1);
						_g_free0 (_tmp34_);
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
						_tmp35_ = self->priv->buffer;
						g_string_append_printf (_tmp35_, ">\n");
						_tmp36_ = self->priv->indent;
						self->priv->indent = _tmp36_ + 1;
						_tmp37_ = array_type;
						_tmp38_ = vala_array_type_get_length_type (_tmp37_);
						_tmp39_ = _tmp38_;
						vala_gir_writer_write_type (self, _tmp39_, -1, VALA_PARAMETER_DIRECTION_IN);
						_tmp40_ = self->priv->indent;
						self->priv->indent = _tmp40_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp41_ = self->priv->buffer;
						g_string_append_printf (_tmp41_, "</field>\n");
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) f);
		_tmp43_ = _tmp42_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDelegateType* _tmp46_;
			ValaDelegateType* _tmp47_;
			ValaDelegate* _tmp48_;
			ValaDelegate* _tmp49_;
			gboolean _tmp50_;
			gboolean _tmp51_;
			_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) f);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp46_;
			_tmp47_ = deleg_type;
			_tmp48_ = vala_delegate_type_get_delegate_symbol (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_delegate_get_has_target (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_) {
				GString* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				GString* _tmp55_;
				gint _tmp56_;
				GString* _tmp57_;
				gint _tmp58_;
				GString* _tmp59_;
				ValaDelegateType* _tmp60_;
				vala_gir_writer_write_indent (self);
				_tmp52_ = self->priv->buffer;
				_tmp53_ = vala_get_ccode_delegate_target_name ((ValaVariable*) f);
				_tmp54_ = _tmp53_;
				g_string_append_printf (_tmp52_, "<field name=\"%s\"", _tmp54_);
				_g_free0 (_tmp54_);
				vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
				_tmp55_ = self->priv->buffer;
				g_string_append_printf (_tmp55_, ">\n");
				_tmp56_ = self->priv->indent;
				self->priv->indent = _tmp56_ + 1;
				vala_gir_writer_write_indent (self);
				_tmp57_ = self->priv->buffer;
				g_string_append_printf (_tmp57_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
				_tmp58_ = self->priv->indent;
				self->priv->indent = _tmp58_ - 1;
				vala_gir_writer_write_indent (self);
				_tmp59_ = self->priv->buffer;
				g_string_append_printf (_tmp59_, "</field>\n");
				_tmp60_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp60_)) {
					GString* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					GString* _tmp64_;
					gint _tmp65_;
					GString* _tmp66_;
					gint _tmp67_;
					GString* _tmp68_;
					vala_gir_writer_write_indent (self);
					_tmp61_ = self->priv->buffer;
					_tmp62_ = vala_get_ccode_delegate_target_destroy_notify_name ((ValaVariable*) f);
					_tmp63_ = _tmp62_;
					g_string_append_printf (_tmp61_, "<field name=\"%s\"", _tmp63_);
					_g_free0 (_tmp63_);
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
					_tmp64_ = self->priv->buffer;
					g_string_append_printf (_tmp64_, ">\n");
					_tmp65_ = self->priv->indent;
					self->priv->indent = _tmp65_ + 1;
					vala_gir_writer_write_indent (self);
					_tmp66_ = self->priv->buffer;
					g_string_append_printf (_tmp66_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
					_tmp67_ = self->priv->indent;
					self->priv->indent = _tmp67_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp68_ = self->priv->buffer;
					g_string_append_printf (_tmp68_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static void
vala_gir_writer_write_implicit_params (ValaGIRWriter* self,
                                       ValaDataType* type,
                                       gint* index,
                                       gboolean has_array_length,
                                       const gchar* name,
                                       ValaParameterDirection direction)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					gint _tmp4_;
					ValaDataType* _tmp5_;
					ValaDataType* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp4_ = _tmp3_;
					if (!(i < _tmp4_)) {
						break;
					}
					_tmp5_ = vala_array_type_get_length_type (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup_printf ("%s_length%i", name, i + 1);
					_tmp8_ = _tmp7_;
					vala_gir_writer_write_param_or_return (self, _tmp6_, TRUE, index, has_array_length, _tmp8_, NULL, direction, FALSE, FALSE, FALSE);
					_g_free0 (_tmp8_);
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegateType* _tmp9_;
			ValaDelegateType* _tmp10_;
			ValaDelegate* _tmp11_;
			ValaDelegate* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp9_;
			_tmp10_ = deleg_type;
			_tmp11_ = vala_delegate_type_get_delegate_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_delegate_get_has_target (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				ValaPointerType* data_type = NULL;
				ValaVoidType* _tmp15_;
				ValaVoidType* _tmp16_;
				ValaPointerType* _tmp17_;
				ValaPointerType* _tmp18_;
				ValaPointerType* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				ValaDelegateType* _tmp22_;
				_tmp15_ = vala_void_type_new (NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_pointer_type_new ((ValaDataType*) _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_vala_code_node_unref0 (_tmp16_);
				data_type = _tmp18_;
				_tmp19_ = data_type;
				_tmp20_ = g_strdup_printf ("%s_target", name);
				_tmp21_ = _tmp20_;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp19_, TRUE, index, FALSE, _tmp21_, NULL, direction, FALSE, FALSE, FALSE);
				_g_free0 (_tmp21_);
				_tmp22_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp22_)) {
					ValaDelegateType* notify_type = NULL;
					ValaCodeContext* _tmp23_;
					ValaNamespace* _tmp24_;
					ValaNamespace* _tmp25_;
					ValaScope* _tmp26_;
					ValaScope* _tmp27_;
					ValaSymbol* _tmp28_;
					ValaSymbol* _tmp29_;
					ValaScope* _tmp30_;
					ValaScope* _tmp31_;
					ValaSymbol* _tmp32_;
					ValaDelegate* _tmp33_;
					ValaDelegate* _tmp34_;
					ValaDelegateType* _tmp35_;
					ValaDelegateType* _tmp36_;
					ValaDelegateType* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp23_ = self->priv->context;
					_tmp24_ = vala_code_context_get_root (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_scope_lookup (_tmp27_, "GLib");
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_symbol_get_scope (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_scope_lookup (_tmp31_, "DestroyNotify");
					_tmp33_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_DELEGATE) ? ((ValaDelegate*) _tmp32_) : NULL;
					if (_tmp33_ == NULL) {
						_vala_code_node_unref0 (_tmp32_);
					}
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_delegate_type_new (_tmp34_);
					_tmp36_ = _tmp35_;
					_vala_code_node_unref0 (_tmp34_);
					_vala_code_node_unref0 (_tmp29_);
					notify_type = _tmp36_;
					_tmp37_ = notify_type;
					_tmp38_ = g_strdup_printf ("%s_target_destroy_notify", name);
					_tmp39_ = _tmp38_;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp37_, TRUE, index, FALSE, _tmp39_, NULL, direction, FALSE, FALSE, FALSE);
					_g_free0 (_tmp39_);
					_vala_code_node_unref0 (notify_type);
				}
				_vala_code_node_unref0 (data_type);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static void
vala_gir_writer_skip_implicit_params (ValaGIRWriter* self,
                                      ValaDataType* type,
                                      gint* index,
                                      gboolean has_array_length)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp2_ = _tmp1_;
		*index = (*index) + _tmp2_;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
			gint _tmp3_;
			ValaDelegateType* deleg_type = NULL;
			ValaDelegateType* _tmp4_;
			ValaDelegateType* _tmp5_;
			_tmp3_ = *index;
			*index = _tmp3_ + 1;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp4_;
			_tmp5_ = deleg_type;
			if (vala_data_type_is_disposable ((ValaDataType*) _tmp5_)) {
				gint _tmp6_;
				_tmp6_ = *index;
				*index = _tmp6_ + 1;
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static void
vala_gir_writer_write_type_parameter (ValaGIRWriter* self,
                                      ValaTypeParameter* type_parameter,
                                      const gchar* tag_type)
{
	gint _tmp10_;
	GString* _tmp11_;
	gint _tmp12_;
	GString* _tmp13_;
	gint _tmp24_;
	GString* _tmp25_;
	gint _tmp26_;
	GString* _tmp27_;
	gint _tmp38_;
	GString* _tmp39_;
	gint _tmp40_;
	GString* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_parameter != NULL);
	g_return_if_fail (tag_type != NULL);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->buffer;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
		_tmp4_ = _tmp3_;
		g_string_append_printf (_tmp0_, "<%s name=\"%s-type\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		GString* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->buffer;
		_tmp6_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
		_tmp9_ = _tmp8_;
		g_string_append_printf (_tmp5_, "<%s name=\"%s_type\" transfer-ownership=\"none\">\n", tag_type, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = self->priv->indent;
	self->priv->indent = _tmp10_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	g_string_append_printf (_tmp11_, "<type name=\"GType\" c:type=\"GType\"/>\n");
	_tmp12_ = self->priv->indent;
	self->priv->indent = _tmp12_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp13_ = self->priv->buffer;
	g_string_append_printf (_tmp13_, "</%s>\n", tag_type);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = self->priv->buffer;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		g_string_append_printf (_tmp14_, "<%s name=\"%s-dup-func\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp18_);
		_g_free0 (_tmp18_);
	} else {
		GString* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp19_ = self->priv->buffer;
		_tmp20_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
		_tmp23_ = _tmp22_;
		g_string_append_printf (_tmp19_, "<%s name=\"%s_dup_func\" transfer-ownership=\"none\">\n", tag_type, _tmp23_);
		_g_free0 (_tmp23_);
	}
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp25_ = self->priv->buffer;
	g_string_append_printf (_tmp25_, "<type name=\"GObject.BoxedCopyFunc\" c:type=\"GBoxedCopyFunc\"/>\n");
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp27_ = self->priv->buffer;
	g_string_append_printf (_tmp27_, "</%s>\n", tag_type);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = self->priv->buffer;
		_tmp29_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) -1);
		_tmp32_ = _tmp31_;
		g_string_append_printf (_tmp28_, "<%s name=\"%s-destroy-func\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp32_);
		_g_free0 (_tmp32_);
	} else {
		GString* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp33_ = self->priv->buffer;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) type_parameter);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_utf8_strdown (_tmp35_, (gssize) -1);
		_tmp37_ = _tmp36_;
		g_string_append_printf (_tmp33_, "<%s name=\"%s_destroy_func\" transfer-ownership=\"none\">\n", tag_type, _tmp37_);
		_g_free0 (_tmp37_);
	}
	_tmp38_ = self->priv->indent;
	self->priv->indent = _tmp38_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp39_ = self->priv->buffer;
	g_string_append_printf (_tmp39_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
	_tmp40_ = self->priv->indent;
	self->priv->indent = _tmp40_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp41_ = self->priv->buffer;
	g_string_append_printf (_tmp41_, "</%s>\n", tag_type);
}

static void
vala_gir_writer_write_params_and_return (ValaGIRWriter* self,
                                         ValaList* params,
                                         ValaList* type_params,
                                         ValaDataType* return_type,
                                         gboolean return_array_length,
                                         const gchar* return_comment,
                                         gboolean constructor,
                                         ValaDataType* instance_type,
                                         gboolean user_data)
{
	gint last_index = 0;
	gboolean _tmp0_ = FALSE;
	gboolean ret_is_struct = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gint _tmp32_;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	if (return_type != NULL) {
		_tmp0_ = vala_data_type_is_real_non_null_struct_type (return_type);
	} else {
		_tmp0_ = FALSE;
	}
	ret_is_struct = _tmp0_;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) params);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != 0) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = instance_type != NULL;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			_tmp7_ = return_array_length;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp3_ = _tmp7_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ret_is_struct;
	}
	if (_tmp1_) {
		gint index = 0;
		index = 0;
		if (instance_type != NULL) {
			gint _tmp8_;
			_tmp8_ = index;
			index = _tmp8_ + 1;
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp9_;
			gint _param_size = 0;
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _param_index = 0;
			_tmp9_ = _vala_iterable_ref0 (params);
			_param_list = _tmp9_;
			_tmp10_ = _param_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_param_size = _tmp12_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp13_;
				gpointer _tmp14_;
				gint _tmp15_;
				ValaParameter* _tmp16_;
				ValaDataType* _tmp17_;
				ValaDataType* _tmp18_;
				ValaParameter* _tmp19_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp13_ = _param_list;
				_tmp14_ = vala_list_get (_tmp13_, _param_index);
				param = (ValaParameter*) _tmp14_;
				_tmp15_ = index;
				index = _tmp15_ + 1;
				_tmp16_ = param;
				_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = param;
				vala_gir_writer_skip_implicit_params (self, _tmp18_, &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp19_));
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		if (ret_is_struct) {
			gint _tmp20_;
			_tmp20_ = index;
			index = _tmp20_ + 1;
		} else {
			gboolean _tmp21_ = FALSE;
			vala_gir_writer_skip_implicit_params (self, return_type, &index, return_array_length);
			if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
				_tmp21_ = return_array_length;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gint _tmp22_;
				gint _tmp23_;
				_tmp22_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (return_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp23_ = _tmp22_;
				index -= _tmp23_ - 1;
			}
		}
		last_index = index - 1;
	}
	if (return_type != NULL) {
		_tmp24_ = !ret_is_struct;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		vala_gir_writer_write_param_or_return (self, return_type, FALSE, &last_index, return_array_length, NULL, return_comment, VALA_PARAMETER_DIRECTION_IN, constructor, FALSE, FALSE);
	} else {
		if (ret_is_struct) {
			ValaVoidType* _tmp25_;
			ValaVoidType* _tmp26_;
			_tmp25_ = vala_void_type_new (NULL);
			_tmp26_ = _tmp25_;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp26_, FALSE, &last_index, FALSE, NULL, return_comment, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp26_);
		}
	}
	_tmp32_ = vala_collection_get_size ((ValaCollection*) params);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != 0) {
		_tmp31_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		if (type_params != NULL) {
			gint _tmp35_;
			gint _tmp36_;
			_tmp35_ = vala_collection_get_size ((ValaCollection*) type_params);
			_tmp36_ = _tmp35_;
			_tmp34_ = _tmp36_ > 0;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp31_ = _tmp34_;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = instance_type != NULL;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		gboolean _tmp37_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			_tmp37_ = return_array_length;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp29_ = _tmp37_;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = ret_is_struct;
	}
	if (_tmp27_) {
		GString* _tmp38_;
		gint _tmp39_;
		gint index = 0;
		gint _tmp84_;
		GString* _tmp85_;
		vala_gir_writer_write_indent (self);
		_tmp38_ = self->priv->buffer;
		g_string_append_printf (_tmp38_, "<parameters>\n");
		_tmp39_ = self->priv->indent;
		self->priv->indent = _tmp39_ + 1;
		index = 0;
		if (instance_type != NULL) {
			vala_gir_writer_write_param_or_return (self, instance_type, TRUE, &index, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
		}
		if (type_params != NULL) {
			{
				ValaList* _p_list = NULL;
				ValaList* _tmp40_;
				gint _p_size = 0;
				ValaList* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gint _p_index = 0;
				_tmp40_ = _vala_iterable_ref0 (type_params);
				_p_list = _tmp40_;
				_tmp41_ = _p_list;
				_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
				_tmp43_ = _tmp42_;
				_p_size = _tmp43_;
				_p_index = -1;
				while (TRUE) {
					ValaTypeParameter* p = NULL;
					ValaList* _tmp44_;
					gpointer _tmp45_;
					ValaTypeParameter* _tmp46_;
					_p_index = _p_index + 1;
					if (!(_p_index < _p_size)) {
						break;
					}
					_tmp44_ = _p_list;
					_tmp45_ = vala_list_get (_tmp44_, _p_index);
					p = (ValaTypeParameter*) _tmp45_;
					_tmp46_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp46_, "parameter");
					index += 3;
					_vala_code_node_unref0 (p);
				}
				_vala_iterable_unref0 (_p_list);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp47_;
			gint _param_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _param_index = 0;
			_tmp47_ = _vala_iterable_ref0 (params);
			_param_list = _tmp47_;
			_tmp48_ = _param_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_param_size = _tmp50_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaParameter* _tmp53_;
				ValaDataType* _tmp54_;
				ValaDataType* _tmp55_;
				ValaParameter* _tmp56_;
				ValaParameter* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				ValaParameter* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				ValaParameter* _tmp63_;
				ValaParameterDirection _tmp64_;
				ValaParameterDirection _tmp65_;
				ValaParameter* _tmp66_;
				gboolean _tmp67_;
				gboolean _tmp68_;
				ValaParameter* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaParameter* _tmp72_;
				ValaParameter* _tmp73_;
				const gchar* _tmp74_;
				const gchar* _tmp75_;
				ValaParameter* _tmp76_;
				ValaParameterDirection _tmp77_;
				ValaParameterDirection _tmp78_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp51_ = _param_list;
				_tmp52_ = vala_list_get (_tmp51_, _param_index);
				param = (ValaParameter*) _tmp52_;
				_tmp53_ = param;
				_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = param;
				_tmp57_ = param;
				_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = param;
				_tmp61_ = vala_gir_writer_get_parameter_comment (self, _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = param;
				_tmp64_ = vala_parameter_get_direction (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = param;
				_tmp67_ = vala_parameter_get_ellipsis (_tmp66_);
				_tmp68_ = _tmp67_;
				vala_gir_writer_write_param_or_return (self, _tmp55_, TRUE, &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp56_), _tmp59_, _tmp62_, _tmp65_, FALSE, FALSE, _tmp68_);
				_g_free0 (_tmp62_);
				_tmp69_ = param;
				_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) _tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = param;
				_tmp73_ = param;
				_tmp74_ = vala_symbol_get_name ((ValaSymbol*) _tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = param;
				_tmp77_ = vala_parameter_get_direction (_tmp76_);
				_tmp78_ = _tmp77_;
				vala_gir_writer_write_implicit_params (self, _tmp71_, &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp72_), _tmp75_, _tmp78_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		if (ret_is_struct) {
			vala_gir_writer_write_param_or_return (self, return_type, TRUE, &index, FALSE, "result", return_comment, VALA_PARAMETER_DIRECTION_OUT, constructor, TRUE, FALSE);
		} else {
			vala_gir_writer_write_implicit_params (self, return_type, &index, return_array_length, "result", VALA_PARAMETER_DIRECTION_OUT);
		}
		if (user_data) {
			GString* _tmp79_;
			gint _tmp80_;
			GString* _tmp81_;
			gint _tmp82_;
			GString* _tmp83_;
			vala_gir_writer_write_indent (self);
			_tmp79_ = self->priv->buffer;
			g_string_append_printf (_tmp79_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", index);
			_tmp80_ = self->priv->indent;
			self->priv->indent = _tmp80_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp81_ = self->priv->buffer;
			g_string_append_printf (_tmp81_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp82_ = self->priv->indent;
			self->priv->indent = _tmp82_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp83_ = self->priv->buffer;
			g_string_append_printf (_tmp83_, "</parameter>\n");
		}
		_tmp84_ = self->priv->indent;
		self->priv->indent = _tmp84_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp85_ = self->priv->buffer;
		g_string_append_printf (_tmp85_, "</parameters>\n");
	}
}

static void
vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base,
                                     ValaDelegate* cb)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GString* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gint _tmp25_;
	GString* _tmp26_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cb);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cb)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) cb);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<callback name=\"%s\"", _tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = vala_get_ccode_name ((ValaCodeNode*) cb);
	_tmp7_ = _tmp6_;
	g_string_append_printf (_tmp5_, " c:type=\"%s\"", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) cb);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GString* _tmp10_;
		_tmp10_ = self->priv->buffer;
		g_string_append_printf (_tmp10_, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cb);
	_tmp11_ = self->priv->buffer;
	g_string_append_printf (_tmp11_, ">\n");
	_tmp12_ = self->priv->indent;
	self->priv->indent = _tmp12_ + 1;
	_tmp13_ = vala_gir_writer_get_delegate_comment (self, cb);
	_tmp14_ = _tmp13_;
	vala_gir_writer_write_doc (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) cb);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_delegate_get_type_parameters (cb);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) cb);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_gir_writer_get_delegate_return_comment (self, cb);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_delegate_get_has_target (cb);
	_tmp24_ = _tmp23_;
	vala_gir_writer_write_params_and_return (self, _tmp16_, _tmp18_, _tmp20_, vala_get_ccode_array_length ((ValaCodeNode*) cb), _tmp22_, FALSE, NULL, _tmp24_);
	_g_free0 (_tmp22_);
	_vala_iterable_unref0 (_tmp18_);
	_vala_iterable_unref0 (_tmp16_);
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, "</callback>\n");
}

static void
vala_gir_writer_real_visit_method (ValaCodeVisitor* base,
                                   ValaMethod* m)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* tag_name = NULL;
	gchar* _tmp14_;
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp15_;
	gpointer _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaSymbol* _tmp21_;
	const gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	gboolean _tmp31_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_method_get_overrides (m);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_interface_method (m);
		_tmp9_ = _tmp8_;
		if (_tmp9_ != NULL) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = vala_method_get_is_abstract (m);
			_tmp11_ = _tmp10_;
			_tmp7_ = !_tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp12_ = vala_method_get_is_virtual (m);
			_tmp13_ = _tmp12_;
			_tmp6_ = !_tmp13_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		return;
	}
	_tmp14_ = g_strdup ("method");
	tag_name = _tmp14_;
	_tmp15_ = self->priv->hierarchy;
	_tmp16_ = vala_list_get ((ValaList*) _tmp15_, 0);
	parent = (ValaSymbol*) _tmp16_;
	_tmp17_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_ENUM)) {
		ValaArrayList* _tmp18_;
		_tmp18_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp18_, (ValaCodeNode*) m);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp21_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_NAMESPACE)) {
		_tmp20_ = TRUE;
	} else {
		ValaMemberBinding _tmp22_;
		ValaMemberBinding _tmp23_;
		_tmp22_ = vala_method_get_binding (m);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ == VALA_MEMBER_BINDING_STATIC;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp24_ = parent;
		_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp26_ = _tmp25_;
		_tmp19_ = _tmp24_ != _tmp26_;
	}
	if (_tmp19_) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp27_;
	}
	_tmp28_ = tag_name;
	vala_gir_writer_write_signature (self, m, _tmp28_, TRUE, FALSE);
	_tmp30_ = vala_method_get_is_abstract (m);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		_tmp29_ = TRUE;
	} else {
		gboolean _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = vala_method_get_is_virtual (m);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_;
	}
	if (_tmp29_) {
		vala_gir_writer_write_signature (self, m, "virtual-method", TRUE, FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}

static gboolean
vala_gir_writer_is_type_introspectable (ValaGIRWriter* self,
                                        ValaDataType* type)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "va_list") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_writer_is_method_introspectable (ValaGIRWriter* self,
                                          ValaMethod* m)
{
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp1_ = _tmp0_;
	if (!vala_gir_writer_is_type_introspectable (self, _tmp1_)) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp2_ = vala_callable_get_parameters ((ValaCallable*) m);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaParameter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_ellipsis (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				_tmp8_ = TRUE;
			} else {
				ValaParameter* _tmp12_;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				_tmp12_ = param;
				_tmp13_ = vala_variable_get_variable_type ((ValaVariable*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = !vala_gir_writer_is_type_introspectable (self, _tmp14_);
			}
			if (_tmp8_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_writer_is_introspectable (ValaGIRWriter* self,
                                   ValaSymbol* sym)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
		_tmp0_ = !vala_gir_writer_is_method_introspectable (self, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = vala_gir_writer_is_visibility (self, sym);
	return result;
}

static void
vala_gir_writer_write_signature (ValaGIRWriter* self,
                                 ValaMethod* m,
                                 const gchar* tag_name,
                                 gboolean write_doc,
                                 gboolean instance)
{
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* name = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	_tmp4_ = parent;
	if (_tmp3_ != _tmp4_) {
		gchar* _tmp5_;
		gchar* parent_prefix = NULL;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		instance = FALSE;
		_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_g_free0 (name);
		name = _tmp5_;
		_tmp6_ = parent;
		_tmp7_ = vala_get_ccode_lower_case_prefix (_tmp6_);
		parent_prefix = _tmp7_;
		_tmp8_ = name;
		_tmp9_ = parent_prefix;
		if (g_str_has_prefix (_tmp8_, _tmp9_)) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = name;
			_tmp11_ = parent_prefix;
			_tmp12_ = strlen (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) -1);
			_g_free0 (name);
			name = _tmp14_;
		}
		_g_free0 (parent_prefix);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = vala_method_get_coroutine (m);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		gchar* finish_name = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		ValaVoidType* _tmp37_;
		ValaVoidType* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaList* _tmp42_;
		ValaList* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp20_ = name;
		_tmp21_ = g_strdup (_tmp20_);
		finish_name = _tmp21_;
		_tmp22_ = finish_name;
		if (g_str_has_suffix (_tmp22_, "_async")) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = finish_name;
			_tmp24_ = finish_name;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = strlen ("_async");
			_tmp28_ = _tmp27_;
			_tmp29_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - _tmp28_));
			_g_free0 (finish_name);
			finish_name = _tmp29_;
		}
		_tmp30_ = finish_name;
		_tmp31_ = g_strconcat (_tmp30_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp31_;
		_tmp32_ = name;
		_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_method_get_async_begin_parameters (m);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_void_type_new (NULL);
		_tmp38_ = _tmp37_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp32_, _tmp34_, _tmp36_, (ValaDataType*) _tmp38_, FALSE, TRUE);
		_vala_code_node_unref0 (_tmp38_);
		_vala_iterable_unref0 (_tmp36_);
		_g_free0 (_tmp34_);
		_tmp39_ = finish_name;
		_tmp40_ = vala_get_ccode_finish_name (m);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_method_get_async_end_parameters (m);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		_tmp47_ = _tmp46_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp39_, _tmp41_, _tmp43_, _tmp45_, _tmp47_, FALSE);
		_vala_iterable_unref0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (finish_name);
	} else {
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		gboolean _tmp55_;
		gboolean _tmp56_;
		_tmp48_ = name;
		_tmp49_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_callable_get_parameters ((ValaCallable*) m);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		_tmp56_ = _tmp55_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp48_, _tmp50_, _tmp52_, _tmp54_, _tmp56_, TRUE);
		_vala_iterable_unref0 (_tmp52_);
		_g_free0 (_tmp50_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}

static void
vala_gir_writer_do_write_signature (ValaGIRWriter* self,
                                    ValaMethod* m,
                                    const gchar* tag_name,
                                    gboolean instance,
                                    const gchar* name,
                                    const gchar* cname,
                                    ValaList* params,
                                    ValaDataType* return_type,
                                    gboolean can_fail,
                                    gboolean write_comment)
{
	GString* _tmp0_;
	GString* _tmp5_;
	gint _tmp6_;
	gchar* return_comment = NULL;
	ValaDataType* instance_type = NULL;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	gint _tmp17_;
	GString* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", tag_name, name);
	if (g_strcmp0 (tag_name, "virtual-method") == 0) {
		GString* _tmp1_;
		_tmp1_ = self->priv->buffer;
		g_string_append_printf (_tmp1_, " invoker=\"%s\"", name);
	} else {
		if (g_strcmp0 (tag_name, "callback") == 0) {
			GString* _tmp2_;
			_tmp2_ = self->priv->buffer;
			g_string_append_printf (_tmp2_, " c:type=\"%s\"", name);
		} else {
			GString* _tmp3_;
			_tmp3_ = self->priv->buffer;
			g_string_append_printf (_tmp3_, " c:identifier=\"%s\"", cname);
		}
	}
	if (can_fail) {
		GString* _tmp4_;
		_tmp4_ = self->priv->buffer;
		g_string_append_printf (_tmp4_, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) m);
	_tmp5_ = self->priv->buffer;
	g_string_append_printf (_tmp5_, ">\n");
	_tmp6_ = self->priv->indent;
	self->priv->indent = _tmp6_ + 1;
	return_comment = NULL;
	if (write_comment) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = vala_gir_writer_get_method_return_comment (self, m);
		_g_free0 (return_comment);
		return_comment = _tmp7_;
		_tmp8_ = vala_gir_writer_get_method_comment (self, m);
		_tmp9_ = _tmp8_;
		vala_gir_writer_write_doc (self, _tmp9_);
		_g_free0 (_tmp9_);
	}
	instance_type = NULL;
	if (instance) {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp12_;
	}
	_tmp13_ = vala_method_get_type_parameters (m);
	_tmp14_ = _tmp13_;
	_tmp15_ = return_comment;
	_tmp16_ = instance_type;
	vala_gir_writer_write_params_and_return (self, params, _tmp14_, return_type, vala_get_ccode_array_length ((ValaCodeNode*) m), _tmp15_, FALSE, _tmp16_, FALSE);
	_vala_iterable_unref0 (_tmp14_);
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, "</%s>\n", tag_name);
	_vala_code_node_unref0 (instance_type);
	_g_free0 (return_comment);
}

static void
vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                            ValaCreationMethod* m)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean is_struct = FALSE;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* tag_name = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GString* _tmp44_;
	gint _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	ValaDataType* datatype = NULL;
	ValaSymbol* _tmp48_;
	ValaSymbol* _tmp49_;
	ValaDataType* _tmp50_;
	ValaList* type_params = NULL;
	ValaSymbol* _tmp51_;
	ValaSymbol* _tmp52_;
	ValaList* _tmp56_;
	ValaList* _tmp57_;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gint _tmp62_;
	GString* _tmp63_;
	const gchar* _tmp64_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		return;
	}
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_CLASS, ValaClass));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp10_ = _tmp9_;
	is_struct = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
	if (is_struct) {
		_tmp11_ = "function";
	} else {
		_tmp11_ = "constructor";
	}
	_tmp12_ = g_strdup (_tmp11_);
	tag_name = _tmp12_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaCreationMethod* _tmp19_;
		ValaCreationMethod* _tmp20_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_class_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass));
		_tmp20_ = _tmp19_;
		_tmp14_ = m == _tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp23_ = _tmp22_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_STRUCT)) {
			ValaSymbol* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_struct_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp27_ = _tmp26_;
			_tmp21_ = m == _tmp27_;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp13_ = _tmp21_;
	}
	if (_tmp13_) {
		const gchar* _tmp28_ = NULL;
		gchar* m_name = NULL;
		gchar* _tmp29_;
		GString* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		if (is_struct) {
			_tmp28_ = "init";
		} else {
			_tmp28_ = "new";
		}
		_tmp29_ = g_strdup (_tmp28_);
		m_name = _tmp29_;
		_tmp30_ = self->priv->buffer;
		_tmp31_ = tag_name;
		_tmp32_ = m_name;
		_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp34_ = _tmp33_;
		g_string_append_printf (_tmp30_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp31_, _tmp32_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (m_name);
	} else {
		GString* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp35_ = self->priv->buffer;
		_tmp36_ = tag_name;
		_tmp37_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp40_ = _tmp39_;
		g_string_append_printf (_tmp35_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp36_, _tmp38_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	_tmp41_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
	_tmp42_ = _tmp41_;
	if (_tmp42_) {
		GString* _tmp43_;
		_tmp43_ = self->priv->buffer;
		g_string_append_printf (_tmp43_, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) m);
	_tmp44_ = self->priv->buffer;
	g_string_append_printf (_tmp44_, ">\n");
	_tmp45_ = self->priv->indent;
	self->priv->indent = _tmp45_ + 1;
	_tmp46_ = vala_gir_writer_get_method_comment (self, (ValaMethod*) m);
	_tmp47_ = _tmp46_;
	vala_gir_writer_write_doc (self, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	datatype = _tmp50_;
	type_params = NULL;
	_tmp51_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp52_ = _tmp51_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp53_;
		ValaSymbol* _tmp54_;
		ValaList* _tmp55_;
		_tmp53_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_CLASS, ValaClass));
		_vala_iterable_unref0 (type_params);
		type_params = _tmp55_;
	}
	_tmp56_ = vala_callable_get_parameters ((ValaCallable*) m);
	_tmp57_ = _tmp56_;
	_tmp58_ = type_params;
	_tmp59_ = datatype;
	_tmp60_ = vala_gir_writer_get_method_return_comment (self, (ValaMethod*) m);
	_tmp61_ = _tmp60_;
	vala_gir_writer_write_params_and_return (self, _tmp57_, _tmp58_, _tmp59_, FALSE, _tmp61_, TRUE, NULL, FALSE);
	_g_free0 (_tmp61_);
	_vala_iterable_unref0 (_tmp57_);
	_tmp62_ = self->priv->indent;
	self->priv->indent = _tmp62_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp63_ = self->priv->buffer;
	_tmp64_ = tag_name;
	g_string_append_printf (_tmp63_, "</%s>\n", _tmp64_);
	_vala_iterable_unref0 (type_params);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}

static void
vala_gir_writer_real_visit_property (ValaCodeVisitor* base,
                                     ValaProperty* prop)
{
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp12_;
	ValaSemanticAnalyzer* _tmp13_;
	ValaSemanticAnalyzer* _tmp14_;
	ValaPropertyAccessor* _tmp42_;
	ValaPropertyAccessor* _tmp43_;
	ValaPropertyAccessor* _tmp49_;
	ValaPropertyAccessor* _tmp50_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) prop)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_property_get_overrides (prop);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaProperty* _tmp6_;
		ValaProperty* _tmp7_;
		_tmp6_ = vala_property_get_base_interface_property (prop);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = vala_property_get_is_abstract (prop);
			_tmp9_ = _tmp8_;
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = vala_property_get_is_virtual (prop);
			_tmp11_ = _tmp10_;
			_tmp4_ = !_tmp11_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp12_ = self->priv->context;
	_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
	_tmp14_ = _tmp13_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp14_, prop)) {
		GString* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaPropertyAccessor* _tmp18_;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp21_;
		ValaPropertyAccessor* _tmp22_;
		GString* _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		gint _tmp40_;
		GString* _tmp41_;
		vala_gir_writer_write_indent (self);
		_tmp15_ = self->priv->buffer;
		_tmp16_ = vala_get_ccode_name ((ValaCodeNode*) prop);
		_tmp17_ = _tmp16_;
		g_string_append_printf (_tmp15_, "<property name=\"%s\"", _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = vala_property_get_get_accessor (prop);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			GString* _tmp20_;
			_tmp20_ = self->priv->buffer;
			g_string_append_printf (_tmp20_, " readable=\"0\"");
		}
		_tmp21_ = vala_property_get_set_accessor (prop);
		_tmp22_ = _tmp21_;
		if (_tmp22_ != NULL) {
			GString* _tmp23_;
			ValaPropertyAccessor* _tmp24_;
			ValaPropertyAccessor* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp23_ = self->priv->buffer;
			g_string_append_printf (_tmp23_, " writable=\"1\"");
			_tmp24_ = vala_property_get_set_accessor (prop);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_property_accessor_get_construction (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_) {
				ValaPropertyAccessor* _tmp28_;
				ValaPropertyAccessor* _tmp29_;
				gboolean _tmp30_;
				gboolean _tmp31_;
				_tmp28_ = vala_property_get_set_accessor (prop);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_property_accessor_get_writable (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					GString* _tmp32_;
					_tmp32_ = self->priv->buffer;
					g_string_append_printf (_tmp32_, " construct-only=\"1\"");
				} else {
					GString* _tmp33_;
					_tmp33_ = self->priv->buffer;
					g_string_append_printf (_tmp33_, " construct=\"1\"");
				}
			}
		}
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) prop);
		_tmp34_ = self->priv->buffer;
		g_string_append_printf (_tmp34_, ">\n");
		_tmp35_ = self->priv->indent;
		self->priv->indent = _tmp35_ + 1;
		_tmp36_ = vala_gir_writer_get_property_comment (self, prop);
		_tmp37_ = _tmp36_;
		vala_gir_writer_write_doc (self, _tmp37_);
		_g_free0 (_tmp37_);
		_tmp38_ = vala_property_get_property_type (prop);
		_tmp39_ = _tmp38_;
		vala_gir_writer_write_type (self, _tmp39_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp40_ = self->priv->indent;
		self->priv->indent = _tmp40_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp41_ = self->priv->buffer;
		g_string_append_printf (_tmp41_, "</property>\n");
	}
	_tmp42_ = vala_property_get_get_accessor (prop);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaMethod* m = NULL;
		ValaPropertyAccessor* _tmp44_;
		ValaPropertyAccessor* _tmp45_;
		ValaMethod* _tmp46_;
		ValaMethod* _tmp47_;
		_tmp44_ = vala_property_get_get_accessor (prop);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_property_accessor_get_method (_tmp45_);
		m = _tmp46_;
		_tmp47_ = m;
		if (_tmp47_ != NULL) {
			ValaMethod* _tmp48_;
			_tmp48_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp48_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp49_ = vala_property_get_set_accessor (prop);
	_tmp50_ = _tmp49_;
	if (_tmp50_ != NULL) {
		ValaMethod* m = NULL;
		ValaPropertyAccessor* _tmp51_;
		ValaPropertyAccessor* _tmp52_;
		ValaMethod* _tmp53_;
		ValaMethod* _tmp54_;
		_tmp51_ = vala_property_get_set_accessor (prop);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_property_accessor_get_method (_tmp52_);
		m = _tmp53_;
		_tmp54_ = m;
		if (_tmp54_ != NULL) {
			ValaMethod* _tmp55_;
			_tmp55_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp55_);
		}
		_vala_code_node_unref0 (m);
	}
}

static void
vala_gir_writer_real_visit_signal (ValaCodeVisitor* base,
                                   ValaSignal* sig)
{
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	GString* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GString* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaList* _tmp11_;
	ValaList* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	GString* _tmp18_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) sig)) {
		return;
	}
	_tmp0_ = vala_signal_get_emitter (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_emitter (sig);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
	vala_gir_writer_write_indent (self);
	_tmp4_ = self->priv->buffer;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	g_string_append_printf (_tmp4_, "<glib:signal name=\"%s\"", _tmp6_);
	_g_free0 (_tmp6_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) sig);
	_tmp7_ = self->priv->buffer;
	g_string_append_printf (_tmp7_, ">\n");
	_tmp8_ = self->priv->indent;
	self->priv->indent = _tmp8_ + 1;
	_tmp9_ = vala_gir_writer_get_signal_comment (self, sig);
	_tmp10_ = _tmp9_;
	vala_gir_writer_write_doc (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_gir_writer_get_signal_return_comment (self, sig);
	_tmp16_ = _tmp15_;
	vala_gir_writer_write_params_and_return (self, _tmp12_, NULL, _tmp14_, FALSE, _tmp16_, FALSE, NULL, FALSE);
	_g_free0 (_tmp16_);
	_vala_iterable_unref0 (_tmp12_);
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, "</glib:signal>\n");
}

static void
vala_gir_writer_write_indent (ValaGIRWriter* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			GString* _tmp2_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			_tmp2_ = self->priv->buffer;
			g_string_append_c (_tmp2_, '\t');
		}
	}
}

static void
vala_gir_writer_write_indent_stream (ValaGIRWriter* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			FILE* _tmp2_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			_tmp2_ = self->priv->stream;
			fputc ('\t', _tmp2_);
		}
	}
}

static void
vala_gir_writer_write_param_or_return (ValaGIRWriter* self,
                                       ValaDataType* type,
                                       gboolean is_parameter,
                                       gint* index,
                                       gboolean has_array_length,
                                       const gchar* name,
                                       const gchar* comment,
                                       ValaParameterDirection direction,
                                       gboolean constructor,
                                       gboolean caller_allocates,
                                       gboolean ellipsis)
{
	const gchar* _tmp0_ = NULL;
	gchar* tag = NULL;
	gchar* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	ValaDelegateType* delegate_type = NULL;
	ValaArrayType* array_type = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp43_ = FALSE;
	ValaDelegateType* _tmp44_;
	GString* _tmp65_;
	gint _tmp66_;
	gint _tmp69_;
	GString* _tmp70_;
	const gchar* _tmp71_;
	gint _tmp72_;
	g_return_if_fail (self != NULL);
	vala_gir_writer_write_indent (self);
	if (is_parameter) {
		_tmp0_ = "parameter";
	} else {
		_tmp0_ = "return-value";
	}
	_tmp1_ = g_strdup (_tmp0_);
	tag = _tmp1_;
	_tmp2_ = self->priv->buffer;
	_tmp3_ = tag;
	g_string_append_printf (_tmp2_, "<%s", _tmp3_);
	if (ellipsis) {
		name = "...";
	}
	if (name != NULL) {
		GString* _tmp4_;
		_tmp4_ = self->priv->buffer;
		g_string_append_printf (_tmp4_, " name=\"%s\"", name);
	}
	if (direction == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp5_;
		_tmp5_ = self->priv->buffer;
		g_string_append_printf (_tmp5_, " direction=\"inout\"");
	} else {
		if (direction == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp6_;
			_tmp6_ = self->priv->buffer;
			g_string_append_printf (_tmp6_, " direction=\"out\"");
		}
	}
	delegate_type = G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) type) : NULL;
	array_type = G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) type) : NULL;
	if (type != NULL) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = vala_data_type_get_value_owned (type);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			ValaDelegateType* _tmp12_;
			_tmp12_ = delegate_type;
			_tmp9_ = _tmp12_ == NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp13_ = FALSE;
			if (constructor) {
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = vala_data_type_get_data_type (type);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->ginitiallyunowned_type;
				_tmp13_ = !vala_typesymbol_is_subtype_of (_tmp15_, _tmp16_);
			} else {
				_tmp13_ = FALSE;
			}
			_tmp8_ = _tmp13_;
		}
		_tmp7_ = _tmp8_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean any_owned = FALSE;
		gboolean _tmp26_ = FALSE;
		any_owned = FALSE;
		{
			ValaList* _generic_arg_list = NULL;
			ValaList* _tmp17_;
			gint _generic_arg_size = 0;
			ValaList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _generic_arg_index = 0;
			_tmp17_ = vala_data_type_get_type_arguments (type);
			_generic_arg_list = _tmp17_;
			_tmp18_ = _generic_arg_list;
			_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_generic_arg_size = _tmp20_;
			_generic_arg_index = -1;
			while (TRUE) {
				ValaDataType* generic_arg = NULL;
				ValaList* _tmp21_;
				gpointer _tmp22_;
				ValaDataType* _tmp23_;
				gboolean _tmp24_;
				gboolean _tmp25_;
				_generic_arg_index = _generic_arg_index + 1;
				if (!(_generic_arg_index < _generic_arg_size)) {
					break;
				}
				_tmp21_ = _generic_arg_list;
				_tmp22_ = vala_list_get (_tmp21_, _generic_arg_index);
				generic_arg = (ValaDataType*) _tmp22_;
				_tmp23_ = generic_arg;
				_tmp24_ = vala_data_type_get_value_owned (_tmp23_);
				_tmp25_ = _tmp24_;
				any_owned |= _tmp25_;
				_vala_code_node_unref0 (generic_arg);
			}
			_vala_iterable_unref0 (_generic_arg_list);
		}
		if (vala_data_type_has_type_arguments (type)) {
			_tmp26_ = !any_owned;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			GString* _tmp27_;
			_tmp27_ = self->priv->buffer;
			g_string_append_printf (_tmp27_, " transfer-ownership=\"container\"");
		} else {
			gboolean _tmp28_ = FALSE;
			ValaArrayType* _tmp29_;
			_tmp29_ = array_type;
			if (_tmp29_ != NULL) {
				ValaArrayType* _tmp30_;
				ValaDataType* _tmp31_;
				ValaDataType* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = array_type;
				_tmp31_ = vala_array_type_get_element_type (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_data_type_get_value_owned (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp28_ = !_tmp34_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				GString* _tmp35_;
				_tmp35_ = self->priv->buffer;
				g_string_append_printf (_tmp35_, " transfer-ownership=\"container\"");
			} else {
				GString* _tmp36_;
				_tmp36_ = self->priv->buffer;
				g_string_append_printf (_tmp36_, " transfer-ownership=\"full\"");
			}
		}
	} else {
		GString* _tmp37_;
		_tmp37_ = self->priv->buffer;
		g_string_append_printf (_tmp37_, " transfer-ownership=\"none\"");
	}
	if (caller_allocates) {
		GString* _tmp38_;
		_tmp38_ = self->priv->buffer;
		g_string_append_printf (_tmp38_, " caller-allocates=\"1\"");
	}
	if (type != NULL) {
		gboolean _tmp40_;
		gboolean _tmp41_;
		_tmp40_ = vala_data_type_get_nullable (type);
		_tmp41_ = _tmp40_;
		_tmp39_ = _tmp41_;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		GString* _tmp42_;
		_tmp42_ = self->priv->buffer;
		g_string_append_printf (_tmp42_, " allow-none=\"1\"");
	}
	_tmp44_ = delegate_type;
	if (_tmp44_ != NULL) {
		ValaDelegateType* _tmp45_;
		ValaDelegate* _tmp46_;
		ValaDelegate* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp45_ = delegate_type;
		_tmp46_ = vala_delegate_type_get_delegate_symbol (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_delegate_get_has_target (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp43_ = _tmp49_;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		gint _tmp50_ = 0;
		gint closure_index = 0;
		GString* _tmp54_;
		ValaDelegateType* _tmp55_;
		gboolean _tmp56_;
		gboolean _tmp57_;
		if (is_parameter) {
			_tmp50_ = (*index) + 1;
		} else {
			gint _tmp51_ = 0;
			gboolean _tmp52_;
			gboolean _tmp53_;
			_tmp52_ = vala_data_type_get_value_owned (type);
			_tmp53_ = _tmp52_;
			if (_tmp53_) {
				_tmp51_ = (*index) - 1;
			} else {
				_tmp51_ = *index;
			}
			_tmp50_ = _tmp51_;
		}
		closure_index = _tmp50_;
		_tmp54_ = self->priv->buffer;
		g_string_append_printf (_tmp54_, " closure=\"%i\"", closure_index);
		_tmp55_ = delegate_type;
		_tmp56_ = vala_delegate_type_get_is_called_once (_tmp55_);
		_tmp57_ = _tmp56_;
		if (_tmp57_) {
			GString* _tmp58_;
			_tmp58_ = self->priv->buffer;
			g_string_append (_tmp58_, " scope=\"async\"");
		} else {
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp59_ = vala_data_type_get_value_owned (type);
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				GString* _tmp61_;
				_tmp61_ = self->priv->buffer;
				g_string_append_printf (_tmp61_, " scope=\"notified\" destroy=\"%i\"", closure_index + 1);
			} else {
				GString* _tmp62_;
				_tmp62_ = self->priv->buffer;
				g_string_append (_tmp62_, " scope=\"call\"");
			}
		}
	} else {
		ValaDelegateType* _tmp63_;
		_tmp63_ = delegate_type;
		if (_tmp63_ != NULL) {
			GString* _tmp64_;
			_tmp64_ = self->priv->buffer;
			g_string_append (_tmp64_, " scope=\"call\"");
		}
	}
	_tmp65_ = self->priv->buffer;
	g_string_append_printf (_tmp65_, ">\n");
	_tmp66_ = self->priv->indent;
	self->priv->indent = _tmp66_ + 1;
	vala_gir_writer_write_doc (self, comment);
	if (ellipsis) {
		GString* _tmp67_;
		vala_gir_writer_write_indent (self);
		_tmp67_ = self->priv->buffer;
		g_string_append (_tmp67_, "<varargs/>\n");
	} else {
		if (type != NULL) {
			gint length_param_index = 0;
			length_param_index = -1;
			if (has_array_length) {
				gint _tmp68_ = 0;
				if (is_parameter) {
					_tmp68_ = (*index) + 1;
				} else {
					_tmp68_ = *index;
				}
				length_param_index = _tmp68_;
			}
			vala_gir_writer_write_type (self, type, length_param_index, direction);
		}
	}
	_tmp69_ = self->priv->indent;
	self->priv->indent = _tmp69_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp70_ = self->priv->buffer;
	_tmp71_ = tag;
	g_string_append_printf (_tmp70_, "</%s>\n", _tmp71_);
	_tmp72_ = *index;
	*index = _tmp72_ + 1;
	_g_free0 (tag);
}

static void
vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self,
                                        ValaTypeSymbol* symbol,
                                        const gchar* suffix)
{
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_get_ccode_name ((ValaCodeNode*) symbol);
	_tmp2_ = _tmp1_;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp2_, suffix);
	_g_free0 (_tmp2_);
}

static void
vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self,
                                        ValaTypeSymbol* symbol)
{
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GString* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	vala_gir_writer_write_ctype_attributes (self, symbol, "");
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_get_ccode_name ((ValaCodeNode*) symbol);
	_tmp2_ = _tmp1_;
	g_string_append_printf (_tmp0_, " glib:type-name=\"%s\"", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->buffer;
	_tmp4_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) symbol);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp3_, " glib:get-type=\"%sget_type\"", _tmp5_);
	_g_free0 (_tmp5_);
}

static void
vala_gir_writer_write_type (ValaGIRWriter* self,
                            ValaDataType* type,
                            gint index,
                            ValaParameterDirection direction)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaArrayType* _tmp0_;
		GString* _tmp1_;
		gboolean _tmp2_ = FALSE;
		ValaArrayType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		const gchar* _tmp18_ = NULL;
		GString* _tmp19_;
		ValaArrayType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GString* _tmp25_;
		gint _tmp26_;
		ValaArrayType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		gint _tmp30_;
		GString* _tmp31_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp0_;
		vala_gir_writer_write_indent (self);
		_tmp1_ = self->priv->buffer;
		g_string_append_printf (_tmp1_, "<array");
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_fixed_length (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ValaArrayType* _tmp6_;
			ValaExpression* _tmp7_;
			ValaExpression* _tmp8_;
			_tmp6_ = array_type;
			_tmp7_ = vala_array_type_get_length (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_INTEGER_LITERAL);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaIntegerLiteral* lit = NULL;
			ValaArrayType* _tmp9_;
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaIntegerLiteral* _tmp12_;
			GString* _tmp13_;
			ValaIntegerLiteral* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp9_ = array_type;
			_tmp10_ = vala_array_type_get_length (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
			lit = _tmp12_;
			_tmp13_ = self->priv->buffer;
			_tmp14_ = lit;
			_tmp15_ = vala_integer_literal_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			g_string_append_printf (_tmp13_, " fixed-size=\"%i\"", atoi (_tmp16_));
			_vala_code_node_unref0 (lit);
		} else {
			if (index != -1) {
				GString* _tmp17_;
				_tmp17_ = self->priv->buffer;
				g_string_append_printf (_tmp17_, " length=\"%i\"", index);
			}
		}
		if (direction == VALA_PARAMETER_DIRECTION_IN) {
			_tmp18_ = "*";
		} else {
			_tmp18_ = "**";
		}
		_tmp19_ = self->priv->buffer;
		_tmp20_ = array_type;
		_tmp21_ = vala_array_type_get_element_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_get_ccode_name ((ValaCodeNode*) _tmp22_);
		_tmp24_ = _tmp23_;
		g_string_append_printf (_tmp19_, " c:type=\"%s%s\"", _tmp24_, _tmp18_);
		_g_free0 (_tmp24_);
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, ">\n");
		_tmp26_ = self->priv->indent;
		self->priv->indent = _tmp26_ + 1;
		_tmp27_ = array_type;
		_tmp28_ = vala_array_type_get_element_type (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_gir_writer_write_type (self, _tmp29_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp30_ = self->priv->indent;
		self->priv->indent = _tmp30_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_VOID_TYPE)) {
			GString* _tmp32_;
			vala_gir_writer_write_indent (self);
			_tmp32_ = self->priv->buffer;
			g_string_append_printf (_tmp32_, "<type name=\"none\"/>\n");
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_POINTER_TYPE)) {
				const gchar* _tmp33_ = NULL;
				GString* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				vala_gir_writer_write_indent (self);
				if (direction == VALA_PARAMETER_DIRECTION_IN) {
					_tmp33_ = "";
				} else {
					_tmp33_ = "*";
				}
				_tmp34_ = self->priv->buffer;
				_tmp35_ = vala_get_ccode_name ((ValaCodeNode*) type);
				_tmp36_ = _tmp35_;
				g_string_append_printf (_tmp34_, "<type name=\"gpointer\" c:type=\"%s%s\"/>\n", _tmp36_, _tmp33_);
				_g_free0 (_tmp36_);
			} else {
				ValaTypeSymbol* _tmp37_;
				ValaTypeSymbol* _tmp38_;
				_tmp37_ = vala_data_type_get_data_type (type);
				_tmp38_ = _tmp37_;
				if (_tmp38_ != NULL) {
					gchar* type_name = NULL;
					ValaTypeSymbol* _tmp39_;
					ValaTypeSymbol* _tmp40_;
					gchar* _tmp41_;
					gboolean is_array = FALSE;
					gboolean _tmp42_ = FALSE;
					const gchar* _tmp43_;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					GString* _tmp47_;
					ValaTypeSymbol* _tmp48_;
					ValaTypeSymbol* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					ValaList* type_arguments = NULL;
					ValaList* _tmp54_;
					ValaList* _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					vala_gir_writer_write_indent (self);
					_tmp39_ = vala_data_type_get_data_type (type);
					_tmp40_ = _tmp39_;
					_tmp41_ = vala_gir_writer_gi_type_name (self, _tmp40_);
					type_name = _tmp41_;
					is_array = FALSE;
					_tmp43_ = type_name;
					if (g_strcmp0 (_tmp43_, "GLib.Array") == 0) {
						_tmp42_ = TRUE;
					} else {
						const gchar* _tmp44_;
						_tmp44_ = type_name;
						_tmp42_ = g_strcmp0 (_tmp44_, "GLib.PtrArray") == 0;
					}
					if (_tmp42_) {
						is_array = TRUE;
					}
					if (is_array) {
						_tmp45_ = "array";
					} else {
						_tmp45_ = "type";
					}
					if (direction == VALA_PARAMETER_DIRECTION_IN) {
						_tmp46_ = "";
					} else {
						_tmp46_ = "*";
					}
					_tmp47_ = self->priv->buffer;
					_tmp48_ = vala_data_type_get_data_type (type);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_gir_writer_gi_type_name (self, _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = vala_get_ccode_name ((ValaCodeNode*) type);
					_tmp53_ = _tmp52_;
					g_string_append_printf (_tmp47_, "<%s name=\"%s\" c:type=\"%s%s\"", _tmp45_, _tmp51_, _tmp53_, _tmp46_);
					_g_free0 (_tmp53_);
					_g_free0 (_tmp51_);
					_tmp54_ = vala_data_type_get_type_arguments (type);
					type_arguments = _tmp54_;
					_tmp55_ = type_arguments;
					_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_ == 0) {
						GString* _tmp58_;
						_tmp58_ = self->priv->buffer;
						g_string_append_printf (_tmp58_, "/>\n");
					} else {
						GString* _tmp59_;
						gint _tmp60_;
						gint _tmp69_;
						const gchar* _tmp70_ = NULL;
						GString* _tmp71_;
						_tmp59_ = self->priv->buffer;
						g_string_append_printf (_tmp59_, ">\n");
						_tmp60_ = self->priv->indent;
						self->priv->indent = _tmp60_ + 1;
						{
							ValaList* _type_argument_list = NULL;
							ValaList* _tmp61_;
							ValaList* _tmp62_;
							gint _type_argument_size = 0;
							ValaList* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							gint _type_argument_index = 0;
							_tmp61_ = type_arguments;
							_tmp62_ = _vala_iterable_ref0 (_tmp61_);
							_type_argument_list = _tmp62_;
							_tmp63_ = _type_argument_list;
							_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
							_tmp65_ = _tmp64_;
							_type_argument_size = _tmp65_;
							_type_argument_index = -1;
							while (TRUE) {
								ValaDataType* type_argument = NULL;
								ValaList* _tmp66_;
								gpointer _tmp67_;
								ValaDataType* _tmp68_;
								_type_argument_index = _type_argument_index + 1;
								if (!(_type_argument_index < _type_argument_size)) {
									break;
								}
								_tmp66_ = _type_argument_list;
								_tmp67_ = vala_list_get (_tmp66_, _type_argument_index);
								type_argument = (ValaDataType*) _tmp67_;
								_tmp68_ = type_argument;
								vala_gir_writer_write_type (self, _tmp68_, -1, VALA_PARAMETER_DIRECTION_IN);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						_tmp69_ = self->priv->indent;
						self->priv->indent = _tmp69_ - 1;
						vala_gir_writer_write_indent (self);
						if (is_array) {
							_tmp70_ = "array";
						} else {
							_tmp70_ = "type";
						}
						_tmp71_ = self->priv->buffer;
						g_string_append_printf (_tmp71_, "</%s>\n", _tmp70_);
					}
					_vala_iterable_unref0 (type_arguments);
					_g_free0 (type_name);
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDelegateType* deleg_type = NULL;
						ValaDelegateType* _tmp72_;
						const gchar* _tmp73_ = NULL;
						GString* _tmp74_;
						ValaDelegateType* _tmp75_;
						ValaDelegate* _tmp76_;
						ValaDelegate* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						deleg_type = _tmp72_;
						vala_gir_writer_write_indent (self);
						if (direction == VALA_PARAMETER_DIRECTION_IN) {
							_tmp73_ = "";
						} else {
							_tmp73_ = "*";
						}
						_tmp74_ = self->priv->buffer;
						_tmp75_ = deleg_type;
						_tmp76_ = vala_delegate_type_get_delegate_symbol (_tmp75_);
						_tmp77_ = _tmp76_;
						_tmp78_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp77_);
						_tmp79_ = _tmp78_;
						_tmp80_ = vala_get_ccode_name ((ValaCodeNode*) type);
						_tmp81_ = _tmp80_;
						g_string_append_printf (_tmp74_, "<type name=\"%s\" c:type=\"%s%s\"/>\n", _tmp79_, _tmp81_, _tmp73_);
						_g_free0 (_tmp81_);
						_g_free0 (_tmp79_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_GENERIC_TYPE)) {
							GString* _tmp82_;
							vala_gir_writer_write_indent (self);
							_tmp82_ = self->priv->buffer;
							g_string_append (_tmp82_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							GString* _tmp83_;
							gchar* _tmp84_;
							gchar* _tmp85_;
							vala_gir_writer_write_indent (self);
							_tmp83_ = self->priv->buffer;
							_tmp84_ = vala_code_node_to_string ((ValaCodeNode*) type);
							_tmp85_ = _tmp84_;
							g_string_append_printf (_tmp83_, "<type name=\"%s\"/>\n", _tmp85_);
							_g_free0 (_tmp85_);
						}
					}
				}
			}
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
vala_gir_writer_get_full_gir_name (ValaGIRWriter* self,
                                   ValaSymbol* sym)
{
	gchar* result = NULL;
	gchar* gir_fullname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* gir_name = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* parent_gir_name = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gchar* self_gir_name = NULL;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "GIR", "fullname", NULL);
	gir_fullname = _tmp0_;
	_tmp1_ = gir_fullname;
	if (_tmp1_ != NULL) {
		result = gir_fullname;
		return result;
	}
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "GIR", "name", NULL);
	gir_name = _tmp2_;
	_tmp4_ = gir_name;
	if (_tmp4_ == NULL) {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "gir_namespace", NULL);
		_g_free0 (gir_name);
		gir_name = _tmp5_;
	}
	_tmp6_ = gir_name;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = vala_symbol_get_name (sym);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (gir_name);
		gir_name = _tmp9_;
	}
	_tmp10_ = vala_symbol_get_parent_symbol (sym);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		result = gir_name;
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp12_ = vala_symbol_get_name (sym);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = vala_symbol_get_parent_symbol (sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_writer_get_full_gir_name (self, _tmp15_);
		result = _tmp16_;
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp17_ = vala_symbol_get_parent_symbol (sym);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_gir_writer_get_full_gir_name (self, _tmp18_);
	parent_gir_name = _tmp19_;
	_tmp20_ = parent_gir_name;
	if (_tmp20_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp22_ = gir_name;
	if (g_str_has_prefix (_tmp22_, ".")) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = gir_name;
		_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) -1);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = gir_name;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp26_;
	}
	_tmp27_ = g_strdup (_tmp21_);
	self_gir_name = _tmp27_;
	_tmp28_ = parent_gir_name;
	if (string_contains (_tmp28_, ".")) {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = parent_gir_name;
		_tmp30_ = self_gir_name;
		_tmp31_ = g_strdup_printf ("%s%s", _tmp29_, _tmp30_);
		result = _tmp31_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp21_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	} else {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp32_ = parent_gir_name;
		_tmp33_ = self_gir_name;
		_tmp34_ = g_strdup_printf ("%s.%s", _tmp32_, _tmp33_);
		result = _tmp34_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp21_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_g_free0 (self_gir_name);
	_g_free0 (_tmp21_);
	_g_free0 (parent_gir_name);
	_g_free0 (gir_name);
	_g_free0 (gir_fullname);
}

static gchar*
vala_gir_writer_gi_type_name (ValaGIRWriter* self,
                              ValaTypeSymbol* type_symbol)
{
	gchar* result = NULL;
	ValaSymbol* parent = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) type_symbol);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_NAMESPACE)) {
		ValaNamespace* ns = NULL;
		ValaSymbol* _tmp4_;
		ValaNamespace* _tmp5_;
		gchar* _tmp6_ = NULL;
		ValaNamespace* _tmp7_;
		gchar* _tmp8_;
		gchar* ns_gir_name = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp4_ = parent;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp4_) : NULL);
		ns = _tmp5_;
		_tmp7_ = ns;
		_tmp8_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp7_, "GIR", "name", NULL);
		_tmp6_ = _tmp8_;
		if (_tmp6_ == NULL) {
			ValaNamespace* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp9_ = ns;
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp12_;
		}
		_tmp13_ = g_strdup (_tmp6_);
		ns_gir_name = _tmp13_;
		_tmp14_ = ns_gir_name;
		if (_tmp14_ != NULL) {
			ValaSourceReference* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaSourceFile* _tmp17_;
			ValaSourceFile* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_source_reference_get_file (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_source_file_get_gir_namespace (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != NULL) {
				ValaGIRWriterGIRNamespace external = {0};
				ValaSourceReference* _tmp21_;
				ValaSourceReference* _tmp22_;
				ValaSourceFile* _tmp23_;
				ValaSourceFile* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceFile* _tmp29_;
				ValaSourceFile* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				ValaArrayList* _tmp33_;
				ValaGIRWriterGIRNamespace _tmp34_;
				gchar* gir_fullname = NULL;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_;
				gchar* type_name = NULL;
				gchar* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceFile* _tmp47_;
				ValaSourceFile* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_source_reference_get_file (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_source_file_get_gir_namespace (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_source_reference_get_file (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_source_file_get_gir_version (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_gir_writer_gir_namespace_init (&external, _tmp26_, _tmp32_);
				_tmp33_ = self->priv->externals;
				_tmp34_ = external;
				if (!vala_collection_contains ((ValaCollection*) _tmp33_, &_tmp34_)) {
					ValaArrayList* _tmp35_;
					ValaGIRWriterGIRNamespace _tmp36_;
					_tmp35_ = self->priv->externals;
					_tmp36_ = external;
					vala_collection_add ((ValaCollection*) _tmp35_, &_tmp36_);
				}
				_tmp37_ = vala_code_node_get_attribute_string ((ValaCodeNode*) type_symbol, "GIR", "fullname", NULL);
				gir_fullname = _tmp37_;
				_tmp38_ = gir_fullname;
				if (_tmp38_ != NULL) {
					result = gir_fullname;
					vala_gir_writer_gir_namespace_destroy (&external);
					_g_free0 (ns_gir_name);
					_g_free0 (_tmp6_);
					_vala_code_node_unref0 (ns);
					_vala_code_node_unref0 (parent);
					return result;
				}
				_tmp40_ = vala_code_node_get_attribute_string ((ValaCodeNode*) type_symbol, "GIR", "name", NULL);
				_tmp39_ = _tmp40_;
				if (_tmp39_ == NULL) {
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp41_ = vala_symbol_get_name ((ValaSymbol*) type_symbol);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strdup (_tmp42_);
					_g_free0 (_tmp39_);
					_tmp39_ = _tmp43_;
				}
				_tmp44_ = g_strdup (_tmp39_);
				type_name = _tmp44_;
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_source_reference_get_file (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_source_file_get_gir_namespace (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = type_name;
				_tmp52_ = g_strdup_printf ("%s.%s", _tmp50_, _tmp51_);
				result = _tmp52_;
				_g_free0 (type_name);
				_g_free0 (_tmp39_);
				_g_free0 (gir_fullname);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp6_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp53_;
				ValaNamespace* _tmp54_;
				_tmp53_ = self->priv->unannotated_namespaces;
				_tmp54_ = ns;
				vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp6_);
		_vala_code_node_unref0 (ns);
	}
	_tmp55_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) type_symbol);
	result = _tmp55_;
	_vala_code_node_unref0 (parent);
	return result;
}

static gchar*
vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self,
                                                    ValaExpression* literal)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_STRING_LITERAL)) {
		ValaStringLiteral* lit = NULL;
		ValaStringLiteral* _tmp0_;
		ValaStringLiteral* _tmp1_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) literal) : NULL);
		lit = _tmp0_;
		_tmp1_ = lit;
		if (_tmp1_ != NULL) {
			ValaStringLiteral* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = lit;
			_tmp3_ = vala_string_literal_eval (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			result = _tmp6_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_CHARACTER_LITERAL)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup_printf ("%c", (gint) ((gchar) vala_character_literal_get_char (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))));
			result = _tmp7_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_BOOLEAN_LITERAL)) {
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_;
				gboolean _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = vala_boolean_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral));
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					_tmp8_ = "true";
				} else {
					_tmp8_ = "false";
				}
				_tmp11_ = g_strdup (_tmp8_);
				result = _tmp11_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_REAL_LITERAL)) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup (_tmp13_);
					result = _tmp14_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_INTEGER_LITERAL)) {
						const gchar* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						_tmp15_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp16_ = _tmp15_;
						_tmp17_ = g_strdup (_tmp16_);
						result = _tmp17_;
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_UNARY_EXPRESSION)) {
							ValaUnaryExpression* unary = NULL;
							ValaUnaryExpression* _tmp18_;
							ValaUnaryExpression* _tmp19_;
							ValaUnaryOperator _tmp20_;
							ValaUnaryOperator _tmp21_;
							_tmp18_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
							unary = _tmp18_;
							_tmp19_ = unary;
							_tmp20_ = vala_unary_expression_get_operator (_tmp19_);
							_tmp21_ = _tmp20_;
							if (_tmp21_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp22_;
								ValaExpression* _tmp23_;
								ValaExpression* _tmp24_;
								_tmp22_ = unary;
								_tmp23_ = vala_unary_expression_get_inner (_tmp22_);
								_tmp24_ = _tmp23_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_REAL_LITERAL)) {
									ValaUnaryExpression* _tmp25_;
									ValaExpression* _tmp26_;
									ValaExpression* _tmp27_;
									const gchar* _tmp28_;
									const gchar* _tmp29_;
									gchar* _tmp30_;
									_tmp25_ = unary;
									_tmp26_ = vala_unary_expression_get_inner (_tmp25_);
									_tmp27_ = _tmp26_;
									_tmp28_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
									_tmp29_ = _tmp28_;
									_tmp30_ = g_strconcat ("-", _tmp29_, NULL);
									result = _tmp30_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp31_;
									ValaExpression* _tmp32_;
									ValaExpression* _tmp33_;
									_tmp31_ = unary;
									_tmp32_ = vala_unary_expression_get_inner (_tmp31_);
									_tmp33_ = _tmp32_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_INTEGER_LITERAL)) {
										ValaUnaryExpression* _tmp34_;
										ValaExpression* _tmp35_;
										ValaExpression* _tmp36_;
										const gchar* _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										_tmp34_ = unary;
										_tmp35_ = vala_unary_expression_get_inner (_tmp34_);
										_tmp36_ = _tmp35_;
										_tmp37_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
										_tmp38_ = _tmp37_;
										_tmp39_ = g_strconcat ("-", _tmp38_, NULL);
										result = _tmp39_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gboolean
vala_gir_writer_check_accessibility (ValaGIRWriter* self,
                                     ValaSymbol* sym)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_symbol_get_access (sym);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbolAccessibility _tmp3_;
		ValaSymbolAccessibility _tmp4_;
		_tmp3_ = vala_symbol_get_access (sym);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gir_writer_is_visibility (ValaGIRWriter* self,
                               ValaSymbol* sym)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) sym, "GIR", "visible", TRUE);
	return result;
}

ValaGIRWriter*
vala_gir_writer_construct (GType object_type)
{
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGIRWriter*
vala_gir_writer_new (void)
{
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}

static void
vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self,
                                    const gchar* ns,
                                    const gchar* version)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = g_strdup (ns);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp0_;
	_tmp1_ = g_strdup (version);
	_g_free0 ((*self).version);
	(*self).version = _tmp1_;
}

static gboolean
vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self,
                                     ValaGIRWriterGIRNamespace* g)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self,
                                    ValaGIRWriterGIRNamespace* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}

static void
vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self)
{
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}

static ValaGIRWriterGIRNamespace*
vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self)
{
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}

static void
vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self)
{
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}

static GType
vala_gir_writer_gir_namespace_get_type (void)
{
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}

static void
vala_gir_writer_class_init (ValaGIRWriterClass * klass,
                            gpointer klass_data)
{
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_writer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGIRWriter_private_offset);
	((ValaGIRWriterClass *) klass)->get_interface_comment = (gchar* (*) (ValaGIRWriter*, ValaInterface*)) vala_gir_writer_real_get_interface_comment;
	((ValaGIRWriterClass *) klass)->get_struct_comment = (gchar* (*) (ValaGIRWriter*, ValaStruct*)) vala_gir_writer_real_get_struct_comment;
	((ValaGIRWriterClass *) klass)->get_enum_comment = (gchar* (*) (ValaGIRWriter*, ValaEnum*)) vala_gir_writer_real_get_enum_comment;
	((ValaGIRWriterClass *) klass)->get_class_comment = (gchar* (*) (ValaGIRWriter*, ValaClass*)) vala_gir_writer_real_get_class_comment;
	((ValaGIRWriterClass *) klass)->get_error_code_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorCode*)) vala_gir_writer_real_get_error_code_comment;
	((ValaGIRWriterClass *) klass)->get_enum_value_comment = (gchar* (*) (ValaGIRWriter*, ValaEnumValue*)) vala_gir_writer_real_get_enum_value_comment;
	((ValaGIRWriterClass *) klass)->get_constant_comment = (gchar* (*) (ValaGIRWriter*, ValaConstant*)) vala_gir_writer_real_get_constant_comment;
	((ValaGIRWriterClass *) klass)->get_error_domain_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorDomain*)) vala_gir_writer_real_get_error_domain_comment;
	((ValaGIRWriterClass *) klass)->get_field_comment = (gchar* (*) (ValaGIRWriter*, ValaField*)) vala_gir_writer_real_get_field_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_comment;
	((ValaGIRWriterClass *) klass)->get_method_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_comment;
	((ValaGIRWriterClass *) klass)->get_property_comment = (gchar* (*) (ValaGIRWriter*, ValaProperty*)) vala_gir_writer_real_get_property_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_return_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_return_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_return_comment;
	((ValaGIRWriterClass *) klass)->get_method_return_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_comment;
	((ValaGIRWriterClass *) klass)->get_parameter_comment = (gchar* (*) (ValaGIRWriter*, ValaParameter*)) vala_gir_writer_real_get_parameter_comment;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_writer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_gir_writer_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gir_writer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_gir_writer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gir_writer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gir_writer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor*, ValaEnumValue*)) vala_gir_writer_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gir_writer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor*, ValaErrorCode*)) vala_gir_writer_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) vala_gir_writer_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_gir_writer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_gir_writer_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_gir_writer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_gir_writer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gir_writer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gir_writer_real_visit_signal;
}

static void
vala_gir_writer_instance_init (ValaGIRWriter * self,
                               gpointer klass)
{
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = vala_gir_writer_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GDestroyNotify) vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}

static void
vala_gir_writer_finalize (ValaCodeVisitor * obj)
{
	ValaGIRWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_WRITER, ValaGIRWriter);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_free0 (self->priv->gir_shared_library);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	_vala_code_node_unref0 (self->priv->gtype_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}

/**
 * Code visitor generating .gir file for the public interface.
 */
GType
vala_gir_writer_get_type (void)
{
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		ValaGIRWriter_private_offset = g_type_add_instance_private (vala_gir_writer_type_id, sizeof (ValaGIRWriterPrivate));
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

