/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

static gint ValaSignal_private_offset;
static gpointer vala_signal_parent_class = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_finalize (ValaCodeNode * obj);

static inline gpointer
vala_signal_get_instance_private (ValaSignal* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSignal_private_offset);
}

/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDelegate* result = NULL;
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDelegate* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean is_generic = FALSE;
	ValaScope* _tmp77_;
	ValaScope* _tmp78_;
	ValaDelegate* _tmp79_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_delegate_new (NULL, _tmp3_, NULL, NULL);
	generated_delegate = _tmp4_;
	_tmp5_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp5_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp6_ = generated_delegate;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp6_, _tmp8_);
	_tmp9_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp9_;
	_tmp10_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp10_, FALSE);
	_tmp11_ = sender_param_type;
	vala_data_type_set_nullable (_tmp11_, FALSE);
	_tmp12_ = generated_delegate;
	_tmp13_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp12_, _tmp13_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		gint _param_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _param_index = 0;
		_tmp14_ = self->priv->parameters;
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_param_list = _tmp15_;
		_tmp16_ = _param_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_param_size = _tmp18_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp21_;
			ValaParameter* _tmp22_;
			ValaParameter* _tmp23_;
			ValaParameter* _tmp24_;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDelegate* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = vala_list_get (_tmp19_, _param_index);
			param = (ValaParameter*) _tmp20_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_copy (_tmp21_);
			actual_param = _tmp22_;
			_tmp23_ = actual_param;
			_tmp24_ = actual_param;
			_tmp25_ = vala_variable_get_variable_type ((ValaVariable*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_data_type_get_actual_type (_tmp26_, sender_type, NULL, node_reference);
			_tmp28_ = _tmp27_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp23_, _tmp28_);
			_vala_code_node_unref0 (_tmp28_);
			_tmp29_ = generated_delegate;
			_tmp30_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp29_, _tmp30_);
			_tmp31_ = actual_param;
			_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (VALA_IS_GENERIC_TYPE (_tmp33_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	if (is_generic) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaObjectTypeSymbol* _tmp36_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		cl = _tmp36_;
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp37_;
			ValaList* _tmp38_;
			gint _type_param_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _type_param_index = 0;
			_tmp37_ = cl;
			_tmp38_ = vala_object_type_symbol_get_type_parameters (_tmp37_);
			_type_param_list = _tmp38_;
			_tmp39_ = _type_param_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_type_param_size = _tmp41_;
			_type_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaDelegate* _tmp44_;
				ValaTypeParameter* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				ValaTypeParameter* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTypeParameter* _tmp51_;
				ValaTypeParameter* _tmp52_;
				_type_param_index = _type_param_index + 1;
				if (!(_type_param_index < _type_param_size)) {
					break;
				}
				_tmp42_ = _type_param_list;
				_tmp43_ = vala_list_get (_tmp42_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp43_;
				_tmp44_ = generated_delegate;
				_tmp45_ = type_param;
				_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = type_param;
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_typeparameter_new (_tmp47_, _tmp50_);
				_tmp52_ = _tmp51_;
				vala_delegate_add_type_parameter (_tmp44_, _tmp52_);
				_vala_code_node_unref0 (_tmp52_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp53_;
			ValaList* _tmp54_;
			gint _param_size = 0;
			ValaList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _param_index = 0;
			_tmp53_ = generated_delegate;
			_tmp54_ = vala_callable_get_parameters ((ValaCallable*) _tmp53_);
			_param_list = _tmp54_;
			_tmp55_ = _param_list;
			_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_param_size = _tmp57_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp58_;
				gpointer _tmp59_;
				ValaGenericType* generic_type = NULL;
				ValaParameter* _tmp60_;
				ValaDataType* _tmp61_;
				ValaDataType* _tmp62_;
				ValaGenericType* _tmp63_;
				ValaGenericType* _tmp64_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp58_ = _param_list;
				_tmp59_ = vala_list_get (_tmp58_, _param_index);
				param = (ValaParameter*) _tmp59_;
				_tmp60_ = param;
				_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp62_) ? ((ValaGenericType*) _tmp62_) : NULL);
				generic_type = _tmp63_;
				_tmp64_ = generic_type;
				if (_tmp64_ != NULL) {
					ValaGenericType* _tmp65_;
					ValaDelegate* _tmp66_;
					ValaList* _tmp67_;
					ValaList* _tmp68_;
					ValaDelegate* _tmp69_;
					ValaGenericType* _tmp70_;
					ValaTypeParameter* _tmp71_;
					ValaTypeParameter* _tmp72_;
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					gpointer _tmp75_;
					ValaTypeParameter* _tmp76_;
					_tmp65_ = generic_type;
					_tmp66_ = generated_delegate;
					_tmp67_ = vala_delegate_get_type_parameters (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = generated_delegate;
					_tmp70_ = generic_type;
					_tmp71_ = vala_generic_type_get_type_parameter (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_symbol_get_name ((ValaSymbol*) _tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_list_get (_tmp68_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp69_, _tmp74_));
					_tmp76_ = (ValaTypeParameter*) _tmp75_;
					vala_generic_type_set_type_parameter (_tmp65_, _tmp76_);
					_vala_code_node_unref0 (_tmp76_);
					_vala_iterable_unref0 (_tmp68_);
				}
				_vala_code_node_unref0 (generic_type);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp77_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = generated_delegate;
	vala_scope_add (_tmp78_, NULL, (ValaSymbol*) _tmp79_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}

static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}

static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp10_ = FALSE;
	ValaMethod* _tmp11_;
	ValaMethod* _tmp18_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp11_ = self->priv->_default_handler;
	if (_tmp11_ == NULL) {
		ValaBlock* _tmp12_;
		ValaBlock* _tmp13_;
		_tmp12_ = vala_signal_get_body (self);
		_tmp13_ = _tmp12_;
		_tmp10_ = _tmp13_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ValaBlock* _tmp14_;
		ValaBlock* _tmp15_;
		_tmp14_ = vala_signal_get_body (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	} else {
		ValaMethod* _tmp16_;
		_tmp16_ = self->priv->_default_handler;
		if (_tmp16_ != NULL) {
			ValaMethod* _tmp17_;
			_tmp17_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
		}
	}
	_tmp18_ = self->priv->_emitter;
	if (_tmp18_ != NULL) {
		ValaMethod* _tmp19_;
		_tmp19_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}

static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}

static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaClass* parent_cl = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp6_;
	gboolean _tmp7_ = FALSE;
	ValaClass* _tmp8_;
	ValaClass* _tmp14_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_;
	gboolean _tmp56_;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_;
	gboolean _tmp99_;
	gboolean _tmp167_ = FALSE;
	gboolean _tmp168_ = FALSE;
	gboolean _tmp169_;
	gboolean _tmp170_;
	gboolean _tmp185_;
	gboolean _tmp186_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL);
	parent_cl = _tmp6_;
	_tmp8_ = parent_cl;
	if (_tmp8_ != NULL) {
		ValaClass* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = parent_cl;
		_tmp10_ = vala_class_get_is_compact (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Signals are not supported in compact classes");
		result = FALSE;
		_vala_code_node_unref0 (parent_cl);
		return result;
	}
	_tmp14_ = parent_cl;
	if (_tmp14_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp15_;
			ValaList* _tmp16_;
			gint _base_type_size = 0;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _base_type_index = 0;
			_tmp15_ = parent_cl;
			_tmp16_ = vala_class_get_base_types (_tmp15_);
			_base_type_list = _tmp16_;
			_tmp17_ = _base_type_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_base_type_size = _tmp19_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp20_;
				gpointer _tmp21_;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gboolean _tmp29_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp20_ = _base_type_list;
				_tmp21_ = vala_list_get (_tmp20_, _base_type_index);
				base_type = (ValaDataType*) _tmp21_;
				_tmp22_ = base_type;
				_tmp23_ = vala_data_type_get_data_type (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp24_, _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = VALA_IS_SIGNAL (_tmp28_);
				_vala_code_node_unref0 (_tmp28_);
				if (_tmp29_) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					result = FALSE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					_vala_code_node_unref0 (parent_cl);
					return result;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	if (VALA_IS_DYNAMIC_SIGNAL (self)) {
		gboolean _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		result = !_tmp33_;
		_vala_code_node_unref0 (parent_cl);
		return result;
	}
	_tmp34_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp35_ = _tmp34_;
	vala_code_node_check ((ValaCodeNode*) _tmp35_, context);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _param_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _param_index = 0;
		_tmp36_ = self->priv->parameters;
		_tmp37_ = _vala_iterable_ref0 (_tmp36_);
		_param_list = _tmp37_;
		_tmp38_ = _param_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_param_size = _tmp40_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaParameter* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			ValaParameter* _tmp49_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp41_ = _param_list;
			_tmp42_ = vala_list_get (_tmp41_, _param_index);
			param = (ValaParameter*) _tmp42_;
			_tmp43_ = param;
			_tmp44_ = vala_parameter_get_ellipsis (_tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_) {
				ValaParameter* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaSourceReference* _tmp48_;
				_tmp46_ = param;
				_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp46_);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp48_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (parent_cl);
				return result;
			}
			_tmp49_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp49_, context);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp51_ = self->priv->_is_virtual;
	if (!_tmp51_) {
		ValaBlock* _tmp52_;
		ValaBlock* _tmp53_;
		_tmp52_ = vala_signal_get_body (self);
		_tmp53_ = _tmp52_;
		_tmp50_ = _tmp53_ != NULL;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		ValaSourceReference* _tmp54_;
		ValaSourceReference* _tmp55_;
		_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp55_ = _tmp54_;
		vala_report_error (_tmp55_, "Only virtual signals can have a default signal handler body");
	}
	_tmp56_ = self->priv->_is_virtual;
	if (_tmp56_) {
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaSourceReference* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaMethod* _tmp63_;
		ValaMethod* _tmp64_;
		ValaMethod* _tmp65_;
		ValaScope* _tmp66_;
		ValaScope* _tmp67_;
		ValaMethod* _tmp68_;
		ValaSymbolAccessibility _tmp69_;
		ValaSymbolAccessibility _tmp70_;
		ValaMethod* _tmp71_;
		gboolean _tmp72_;
		gboolean _tmp73_;
		ValaMethod* _tmp74_;
		gboolean _tmp75_;
		gboolean _tmp76_;
		ValaMethod* _tmp77_;
		ValaMethod* _tmp78_;
		ValaMethod* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* _tmp81_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		ValaObjectTypeSymbol* _tmp93_;
		ValaObjectTypeSymbol* _tmp94_;
		ValaMethod* _tmp95_;
		ValaMethod* _tmp96_;
		_tmp57_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_method_new (_tmp58_, _tmp60_, _tmp62_, NULL);
		_tmp64_ = _tmp63_;
		vala_signal_set_default_handler (self, _tmp64_);
		_vala_code_node_unref0 (_tmp64_);
		_tmp65_ = self->priv->_default_handler;
		_tmp66_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp67_ = _tmp66_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp65_, _tmp67_);
		_tmp68_ = self->priv->_default_handler;
		_tmp69_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp70_ = _tmp69_;
		vala_symbol_set_access ((ValaSymbol*) _tmp68_, _tmp70_);
		_tmp71_ = self->priv->_default_handler;
		_tmp72_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp73_ = _tmp72_;
		vala_symbol_set_external ((ValaSymbol*) _tmp71_, _tmp73_);
		_tmp74_ = self->priv->_default_handler;
		_tmp75_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp74_, _tmp76_);
		_tmp77_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp77_, TRUE);
		_tmp78_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp78_, self);
		_tmp79_ = self->priv->_default_handler;
		_tmp80_ = vala_signal_get_body (self);
		_tmp81_ = _tmp80_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp79_, _tmp81_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp82_;
			ValaList* _tmp83_;
			gint _param_size = 0;
			ValaList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _param_index = 0;
			_tmp82_ = self->priv->parameters;
			_tmp83_ = _vala_iterable_ref0 (_tmp82_);
			_param_list = _tmp83_;
			_tmp84_ = _param_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_param_size = _tmp86_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp87_;
				gpointer _tmp88_;
				ValaMethod* _tmp89_;
				ValaParameter* _tmp90_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp87_ = _param_list;
				_tmp88_ = vala_list_get (_tmp87_, _param_index);
				param = (ValaParameter*) _tmp88_;
				_tmp89_ = self->priv->_default_handler;
				_tmp90_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp89_, _tmp90_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp92_) ? ((ValaObjectTypeSymbol*) _tmp92_) : NULL);
		cl = _tmp93_;
		_tmp94_ = cl;
		_tmp95_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp94_, _tmp95_);
		_tmp96_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp96_, context);
		_vala_code_node_unref0 (cl);
	}
	_tmp98_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp99_ = _tmp98_;
	if (!_tmp99_) {
		ValaAttribute* _tmp100_;
		_tmp100_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
		_tmp97_ = _tmp100_ != NULL;
	} else {
		_tmp97_ = FALSE;
	}
	if (_tmp97_) {
		const gchar* _tmp101_;
		const gchar* _tmp102_;
		ValaDataType* _tmp103_;
		ValaDataType* _tmp104_;
		ValaSourceReference* _tmp105_;
		ValaSourceReference* _tmp106_;
		ValaMethod* _tmp107_;
		ValaMethod* _tmp108_;
		ValaMethod* _tmp109_;
		ValaScope* _tmp110_;
		ValaScope* _tmp111_;
		ValaMethod* _tmp112_;
		ValaSymbolAccessibility _tmp113_;
		ValaSymbolAccessibility _tmp114_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		ValaBlock* _tmp117_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp118_;
		const gchar* _tmp119_;
		ValaSourceReference* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaMemberAccess* _tmp122_;
		ValaMemberAccess* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaMethodCall* _tmp126_;
		ValaMethodCall* _tmp127_;
		ValaDataType* _tmp145_;
		ValaDataType* _tmp146_;
		ValaMethod* _tmp159_;
		ValaBlock* _tmp160_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp161_;
		ValaSymbol* _tmp162_;
		ValaObjectTypeSymbol* _tmp163_;
		ValaObjectTypeSymbol* _tmp164_;
		ValaMethod* _tmp165_;
		ValaMethod* _tmp166_;
		_tmp101_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_method_new (_tmp102_, _tmp104_, _tmp106_, NULL);
		_tmp108_ = _tmp107_;
		vala_signal_set_emitter (self, _tmp108_);
		_vala_code_node_unref0 (_tmp108_);
		_tmp109_ = self->priv->_emitter;
		_tmp110_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp111_ = _tmp110_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp109_, _tmp111_);
		_tmp112_ = self->priv->_emitter;
		_tmp113_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp114_ = _tmp113_;
		vala_symbol_set_access ((ValaSymbol*) _tmp112_, _tmp114_);
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_block_new (_tmp116_);
		body = _tmp117_;
		_tmp118_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_member_access_new_simple (_tmp119_, _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_method_call_new ((ValaExpression*) _tmp123_, _tmp125_);
		_tmp127_ = _tmp126_;
		_vala_code_node_unref0 (_tmp123_);
		call = _tmp127_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp128_;
			ValaList* _tmp129_;
			gint _param_size = 0;
			ValaList* _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			gint _param_index = 0;
			_tmp128_ = self->priv->parameters;
			_tmp129_ = _vala_iterable_ref0 (_tmp128_);
			_param_list = _tmp129_;
			_tmp130_ = _param_list;
			_tmp131_ = vala_collection_get_size ((ValaCollection*) _tmp130_);
			_tmp132_ = _tmp131_;
			_param_size = _tmp132_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp133_;
				gpointer _tmp134_;
				ValaMethod* _tmp135_;
				ValaParameter* _tmp136_;
				ValaMethodCall* _tmp137_;
				ValaParameter* _tmp138_;
				const gchar* _tmp139_;
				const gchar* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				ValaMemberAccess* _tmp143_;
				ValaMemberAccess* _tmp144_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp133_ = _param_list;
				_tmp134_ = vala_list_get (_tmp133_, _param_index);
				param = (ValaParameter*) _tmp134_;
				_tmp135_ = self->priv->_emitter;
				_tmp136_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp135_, _tmp136_);
				_tmp137_ = call;
				_tmp138_ = param;
				_tmp139_ = vala_symbol_get_name ((ValaSymbol*) _tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_member_access_new_simple (_tmp140_, _tmp142_);
				_tmp144_ = _tmp143_;
				vala_method_call_add_argument (_tmp137_, (ValaExpression*) _tmp144_);
				_vala_code_node_unref0 (_tmp144_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp145_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp146_ = _tmp145_;
		if (VALA_IS_VOID_TYPE (_tmp146_)) {
			ValaBlock* _tmp147_;
			ValaMethodCall* _tmp148_;
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			ValaExpressionStatement* _tmp151_;
			ValaExpressionStatement* _tmp152_;
			_tmp147_ = body;
			_tmp148_ = call;
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_expression_statement_new ((ValaExpression*) _tmp148_, _tmp150_);
			_tmp152_ = _tmp151_;
			vala_block_add_statement (_tmp147_, (ValaStatement*) _tmp152_);
			_vala_code_node_unref0 (_tmp152_);
		} else {
			ValaBlock* _tmp153_;
			ValaMethodCall* _tmp154_;
			ValaSourceReference* _tmp155_;
			ValaSourceReference* _tmp156_;
			ValaReturnStatement* _tmp157_;
			ValaReturnStatement* _tmp158_;
			_tmp153_ = body;
			_tmp154_ = call;
			_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp156_ = _tmp155_;
			_tmp157_ = vala_return_statement_new ((ValaExpression*) _tmp154_, _tmp156_);
			_tmp158_ = _tmp157_;
			vala_block_add_statement (_tmp153_, (ValaStatement*) _tmp158_);
			_vala_code_node_unref0 (_tmp158_);
		}
		_tmp159_ = self->priv->_emitter;
		_tmp160_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp159_, _tmp160_);
		_tmp161_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp162_ = _tmp161_;
		_tmp163_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp162_) ? ((ValaObjectTypeSymbol*) _tmp162_) : NULL);
		cl = _tmp163_;
		_tmp164_ = cl;
		_tmp165_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp164_, _tmp165_);
		_tmp166_ = self->priv->_emitter;
		vala_code_node_check ((ValaCodeNode*) _tmp166_, context);
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp169_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp170_ = _tmp169_;
	if (!_tmp170_) {
		gboolean _tmp171_;
		gboolean _tmp172_;
		_tmp171_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp172_ = _tmp171_;
		_tmp168_ = !_tmp172_;
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		ValaSymbol* _tmp173_;
		ValaSymbol* _tmp174_;
		_tmp173_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp174_ = _tmp173_;
		_tmp167_ = _tmp174_ != NULL;
		_vala_code_node_unref0 (_tmp174_);
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaSourceReference* _tmp175_;
		ValaSourceReference* _tmp176_;
		gchar* _tmp177_;
		gchar* _tmp178_;
		ValaSymbol* _tmp179_;
		ValaSymbol* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		gchar* _tmp184_;
		_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_symbol_get_full_name (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp178_, _tmp182_);
		_tmp184_ = _tmp183_;
		vala_report_warning (_tmp176_, _tmp184_);
		_g_free0 (_tmp184_);
		_g_free0 (_tmp182_);
		_vala_code_node_unref0 (_tmp180_);
		_g_free0 (_tmp178_);
	}
	_tmp185_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp186_ = _tmp185_;
	result = !_tmp186_;
	_vala_code_node_unref0 (parent_cl);
	return result;
}

static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}

ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}

static void
vala_signal_class_init (ValaSignalClass * klass,
                        gpointer klass_data)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSignal_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}

static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}

static void
vala_signal_instance_init (ValaSignal * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_signal_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}

/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaSignal_private_offset = g_type_add_instance_private (vala_signal_type_id, sizeof (ValaSignalPrivate));
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}

