/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};

static gint ValaPropertyAccessor_private_offset;
static gpointer vala_property_accessor_parent_class = NULL;

static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);

static inline gpointer
vala_property_accessor_get_instance_private (ValaPropertyAccessor* self)
{
	return G_STRUCT_MEMBER_P (self, ValaPropertyAccessor_private_offset);
}

/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}

static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}

static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* result = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
	}
	result = m;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaProfile _tmp24_;
	ValaProfile _tmp25_;
	ValaProperty* _tmp92_;
	ValaProperty* _tmp93_;
	ValaSourceFileType _tmp94_;
	ValaSourceFileType _tmp95_;
	gboolean _tmp151_ = FALSE;
	gboolean _tmp152_ = FALSE;
	gboolean _tmp153_ = FALSE;
	ValaProperty* _tmp154_;
	ValaProperty* _tmp155_;
	gboolean _tmp156_;
	gboolean _tmp157_;
	gboolean _tmp176_ = FALSE;
	ValaProfile _tmp177_;
	ValaProfile _tmp178_;
	gboolean _tmp205_ = FALSE;
	ValaBlock* _tmp206_;
	ValaBlock* _tmp207_;
	ValaBlock* _tmp220_;
	ValaBlock* _tmp221_;
	ValaSemanticAnalyzer* _tmp258_;
	ValaSemanticAnalyzer* _tmp259_;
	ValaSymbol* _tmp260_;
	gboolean _tmp261_;
	gboolean _tmp262_;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
	}
	_tmp24_ = vala_code_context_get_profile (context);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == VALA_PROFILE_GOBJECT) {
		gboolean _tmp26_;
		_tmp26_ = self->priv->_readable;
		_tmp23_ = _tmp26_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaProperty* _tmp27_;
		ValaProperty* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSemanticAnalyzer* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaClass* _tmp33_;
		_tmp27_ = vala_property_accessor_get_prop (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_context_get_analyzer (context);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->object_type;
		_tmp22_ = vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp33_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaAttribute* _tmp36_;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp35_, "NoAccessorMethod");
		if (_tmp36_ != NULL) {
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			_tmp37_ = vala_property_accessor_get_value_type (self);
			_tmp38_ = _tmp37_;
			if (vala_data_type_is_real_struct_type (_tmp38_)) {
				gboolean _tmp39_ = FALSE;
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				if (_tmp41_ == NULL) {
					_tmp39_ = TRUE;
				} else {
					ValaSourceReference* _tmp42_;
					ValaSourceReference* _tmp43_;
					ValaSourceFile* _tmp44_;
					ValaSourceFile* _tmp45_;
					_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp43_ = _tmp42_;
					_tmp44_ = vala_source_reference_get_file (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp39_ = _tmp45_ == NULL;
				}
				if (_tmp39_) {
				} else {
					gboolean _tmp46_ = FALSE;
					ValaDataType* _tmp47_;
					ValaDataType* _tmp48_;
					gboolean _tmp49_;
					gboolean _tmp50_;
					_tmp47_ = vala_property_accessor_get_value_type (self);
					_tmp48_ = _tmp47_;
					_tmp49_ = vala_data_type_get_value_owned (_tmp48_);
					_tmp50_ = _tmp49_;
					if (!_tmp50_) {
						ValaSourceReference* _tmp51_;
						ValaSourceReference* _tmp52_;
						ValaSourceFile* _tmp53_;
						ValaSourceFile* _tmp54_;
						ValaSourceFileType _tmp55_;
						ValaSourceFileType _tmp56_;
						_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp52_ = _tmp51_;
						_tmp53_ = vala_source_reference_get_file (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = vala_source_file_get_file_type (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp46_ = _tmp56_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						ValaSourceReference* _tmp57_;
						ValaSourceReference* _tmp58_;
						ValaProperty* _tmp59_;
						ValaProperty* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp58_ = _tmp57_;
						_tmp59_ = vala_property_accessor_get_prop (self);
						_tmp60_ = _tmp59_;
						_tmp61_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = g_strdup_printf ("unowned return value for getter of property `%s' not supported without" \
" accessor", _tmp62_);
						_tmp64_ = _tmp63_;
						vala_report_error (_tmp58_, _tmp64_);
						_g_free0 (_tmp64_);
						_g_free0 (_tmp62_);
					}
				}
			} else {
				gboolean _tmp65_ = FALSE;
				ValaDataType* _tmp66_;
				ValaDataType* _tmp67_;
				gboolean _tmp68_;
				gboolean _tmp69_;
				_tmp66_ = vala_property_accessor_get_value_type (self);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_data_type_get_value_owned (_tmp67_);
				_tmp69_ = _tmp68_;
				if (_tmp69_) {
					gboolean _tmp70_ = FALSE;
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp72_ = _tmp71_;
					if (_tmp72_ == NULL) {
						_tmp70_ = TRUE;
					} else {
						ValaSourceReference* _tmp73_;
						ValaSourceReference* _tmp74_;
						ValaSourceFile* _tmp75_;
						ValaSourceFile* _tmp76_;
						_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp74_ = _tmp73_;
						_tmp75_ = vala_source_reference_get_file (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp70_ = _tmp76_ == NULL;
					}
					_tmp65_ = _tmp70_;
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					gboolean _tmp77_ = FALSE;
					gboolean _tmp78_ = FALSE;
					ValaDataType* _tmp79_;
					ValaDataType* _tmp80_;
					_tmp79_ = vala_property_accessor_get_value_type (self);
					_tmp80_ = _tmp79_;
					if (VALA_IS_DELEGATE_TYPE (_tmp80_)) {
						_tmp78_ = TRUE;
					} else {
						ValaDataType* _tmp81_;
						ValaDataType* _tmp82_;
						_tmp81_ = vala_property_accessor_get_value_type (self);
						_tmp82_ = _tmp81_;
						_tmp78_ = VALA_IS_POINTER_TYPE (_tmp82_);
					}
					if (_tmp78_) {
						_tmp77_ = TRUE;
					} else {
						gboolean _tmp83_ = FALSE;
						ValaDataType* _tmp84_;
						ValaDataType* _tmp85_;
						_tmp84_ = vala_property_accessor_get_value_type (self);
						_tmp85_ = _tmp84_;
						if (VALA_IS_VALUE_TYPE (_tmp85_)) {
							ValaDataType* _tmp86_;
							ValaDataType* _tmp87_;
							gboolean _tmp88_;
							gboolean _tmp89_;
							_tmp86_ = vala_property_accessor_get_value_type (self);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_data_type_get_nullable (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp83_ = !_tmp89_;
						} else {
							_tmp83_ = FALSE;
						}
						_tmp77_ = _tmp83_;
					}
					if (_tmp77_) {
						ValaDataType* _tmp90_;
						ValaDataType* _tmp91_;
						_tmp90_ = vala_property_accessor_get_value_type (self);
						_tmp91_ = _tmp90_;
						vala_data_type_set_value_owned (_tmp91_, FALSE);
					}
				}
			}
		}
	}
	_tmp92_ = vala_property_accessor_get_prop (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp93_);
	_tmp95_ = _tmp94_;
	if (_tmp95_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp96_ = FALSE;
		gboolean _tmp97_ = FALSE;
		ValaBlock* _tmp98_;
		ValaBlock* _tmp99_;
		_tmp98_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp99_ = _tmp98_;
		if (_tmp99_ == NULL) {
			ValaProperty* _tmp100_;
			ValaProperty* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			_tmp100_ = vala_property_accessor_get_prop (self);
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_property_get_interface_only (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp97_ = !_tmp103_;
		} else {
			_tmp97_ = FALSE;
		}
		if (_tmp97_) {
			ValaProperty* _tmp104_;
			ValaProperty* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp104_ = vala_property_accessor_get_prop (self);
			_tmp105_ = _tmp104_;
			_tmp106_ = vala_property_get_is_abstract (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp96_ = !_tmp107_;
		} else {
			_tmp96_ = FALSE;
		}
		if (_tmp96_) {
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			ValaBlock* _tmp110_;
			ValaBlock* _tmp111_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp112_;
			ValaProperty* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			ValaSourceReference* _tmp118_;
			ValaSourceReference* _tmp119_;
			ValaMemberAccess* _tmp120_;
			ValaMemberAccess* _tmp121_;
			gboolean _tmp122_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			_tmp110_ = vala_block_new (_tmp109_);
			_tmp111_ = _tmp110_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp111_);
			_vala_code_node_unref0 (_tmp111_);
			_tmp112_ = vala_property_accessor_get_prop (self);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_symbol_get_name ((ValaSymbol*) _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = g_strdup_printf ("_%s", _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_member_access_new_simple (_tmp117_, _tmp119_);
			_tmp121_ = _tmp120_;
			_g_free0 (_tmp117_);
			ma = _tmp121_;
			_tmp122_ = self->priv->_readable;
			if (_tmp122_) {
				ValaBlock* _tmp123_;
				ValaBlock* _tmp124_;
				ValaMemberAccess* _tmp125_;
				ValaSourceReference* _tmp126_;
				ValaSourceReference* _tmp127_;
				ValaReturnStatement* _tmp128_;
				ValaReturnStatement* _tmp129_;
				_tmp123_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp124_ = _tmp123_;
				_tmp125_ = ma;
				_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_return_statement_new ((ValaExpression*) _tmp125_, _tmp127_);
				_tmp129_ = _tmp128_;
				vala_block_add_statement (_tmp124_, (ValaStatement*) _tmp129_);
				_vala_code_node_unref0 (_tmp129_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp130_;
				ValaSourceReference* _tmp131_;
				ValaMemberAccess* _tmp132_;
				ValaDataType* _tmp133_;
				ValaDataType* _tmp134_;
				gboolean _tmp135_;
				gboolean _tmp136_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp141_;
				ValaExpression* _tmp142_;
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaAssignment* _tmp145_;
				ValaBlock* _tmp146_;
				ValaBlock* _tmp147_;
				ValaAssignment* _tmp148_;
				ValaExpressionStatement* _tmp149_;
				ValaExpressionStatement* _tmp150_;
				_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_member_access_new_simple ("value", _tmp131_);
				value = (ValaExpression*) _tmp132_;
				_tmp133_ = vala_property_accessor_get_value_type (self);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_data_type_get_value_owned (_tmp134_);
				_tmp136_ = _tmp135_;
				if (_tmp136_) {
					ValaExpression* _tmp137_;
					ValaSourceReference* _tmp138_;
					ValaSourceReference* _tmp139_;
					ValaReferenceTransferExpression* _tmp140_;
					_tmp137_ = value;
					_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp139_ = _tmp138_;
					_tmp140_ = vala_reference_transfer_expression_new (_tmp137_, _tmp139_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp140_;
				}
				_tmp141_ = ma;
				_tmp142_ = value;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_assignment_new ((ValaExpression*) _tmp141_, _tmp142_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp144_);
				assignment = _tmp145_;
				_tmp146_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp147_ = _tmp146_;
				_tmp148_ = assignment;
				_tmp149_ = vala_expression_statement_new ((ValaExpression*) _tmp148_, NULL);
				_tmp150_ = _tmp149_;
				vala_block_add_statement (_tmp147_, (ValaStatement*) _tmp150_);
				_vala_code_node_unref0 (_tmp150_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp154_ = vala_property_accessor_get_prop (self);
	_tmp155_ = _tmp154_;
	_tmp156_ = vala_property_get_is_abstract (_tmp155_);
	_tmp157_ = _tmp156_;
	if (_tmp157_) {
		_tmp153_ = TRUE;
	} else {
		ValaProperty* _tmp158_;
		ValaProperty* _tmp159_;
		gboolean _tmp160_;
		gboolean _tmp161_;
		_tmp158_ = vala_property_accessor_get_prop (self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_property_get_is_virtual (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp153_ = _tmp161_;
	}
	if (_tmp153_) {
		_tmp152_ = TRUE;
	} else {
		ValaProperty* _tmp162_;
		ValaProperty* _tmp163_;
		gboolean _tmp164_;
		gboolean _tmp165_;
		_tmp162_ = vala_property_accessor_get_prop (self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_property_get_overrides (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp152_ = _tmp165_;
	}
	if (_tmp152_) {
		ValaSymbolAccessibility _tmp166_;
		ValaSymbolAccessibility _tmp167_;
		_tmp166_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp167_ = _tmp166_;
		_tmp151_ = _tmp167_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		ValaSourceReference* _tmp168_;
		ValaSourceReference* _tmp169_;
		ValaProperty* _tmp170_;
		ValaProperty* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_property_accessor_get_prop (self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp171_);
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strdup_printf ("Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp173_);
		_tmp175_ = _tmp174_;
		vala_report_error (_tmp169_, _tmp175_);
		_g_free0 (_tmp175_);
		_g_free0 (_tmp173_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp177_ = vala_code_context_get_profile (context);
	_tmp178_ = _tmp177_;
	if (_tmp178_ == VALA_PROFILE_POSIX) {
		gboolean _tmp179_;
		_tmp179_ = self->priv->_construction;
		_tmp176_ = _tmp179_;
	} else {
		_tmp176_ = FALSE;
	}
	if (_tmp176_) {
		ValaSourceReference* _tmp180_;
		ValaSourceReference* _tmp181_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp181_ = _tmp180_;
		vala_report_error (_tmp181_, "`construct' is not supported in POSIX profile");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	} else {
		gboolean _tmp182_ = FALSE;
		gboolean _tmp183_;
		_tmp183_ = self->priv->_construction;
		if (_tmp183_) {
			ValaProperty* _tmp184_;
			ValaProperty* _tmp185_;
			ValaSymbol* _tmp186_;
			ValaSymbol* _tmp187_;
			ValaSemanticAnalyzer* _tmp188_;
			ValaSemanticAnalyzer* _tmp189_;
			ValaClass* _tmp190_;
			_tmp184_ = vala_property_accessor_get_prop (self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp185_);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_code_context_get_analyzer (context);
			_tmp189_ = _tmp188_;
			_tmp190_ = _tmp189_->object_type;
			_tmp182_ = !vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp187_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp190_);
		} else {
			_tmp182_ = FALSE;
		}
		if (_tmp182_) {
			ValaSourceReference* _tmp191_;
			ValaSourceReference* _tmp192_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp192_ = _tmp191_;
			vala_report_error (_tmp192_, "construct properties require `GLib.Object'");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			return result;
		} else {
			gboolean _tmp193_ = FALSE;
			gboolean _tmp194_;
			_tmp194_ = self->priv->_construction;
			if (_tmp194_) {
				ValaSemanticAnalyzer* _tmp195_;
				ValaSemanticAnalyzer* _tmp196_;
				ValaProperty* _tmp197_;
				ValaProperty* _tmp198_;
				_tmp195_ = vala_code_context_get_analyzer (context);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_property_accessor_get_prop (self);
				_tmp198_ = _tmp197_;
				_tmp193_ = !vala_semantic_analyzer_is_gobject_property (_tmp196_, _tmp198_);
			} else {
				_tmp193_ = FALSE;
			}
			if (_tmp193_) {
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp199_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp200_ = _tmp199_;
				if (_tmp200_) {
					ValaSourceReference* _tmp201_;
					ValaSourceReference* _tmp202_;
					_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp202_ = _tmp201_;
					vala_report_warning (_tmp202_, "construct properties not supported for specified property type");
				} else {
					ValaSourceReference* _tmp203_;
					ValaSourceReference* _tmp204_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp204_ = _tmp203_;
					vala_report_error (_tmp204_, "construct properties not supported for specified property type");
					result = FALSE;
					_vala_code_node_unref0 (old_symbol);
					return result;
				}
			}
		}
	}
	_tmp206_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp207_ = _tmp206_;
	if (_tmp207_ != NULL) {
		ValaProperty* _tmp208_;
		ValaProperty* _tmp209_;
		gboolean _tmp210_;
		gboolean _tmp211_;
		_tmp208_ = vala_property_accessor_get_prop (self);
		_tmp209_ = _tmp208_;
		_tmp210_ = vala_property_get_is_abstract (_tmp209_);
		_tmp211_ = _tmp210_;
		_tmp205_ = _tmp211_;
	} else {
		_tmp205_ = FALSE;
	}
	if (_tmp205_) {
		ValaSourceReference* _tmp212_;
		ValaSourceReference* _tmp213_;
		ValaProperty* _tmp214_;
		ValaProperty* _tmp215_;
		gchar* _tmp216_;
		gchar* _tmp217_;
		gchar* _tmp218_;
		gchar* _tmp219_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp213_ = _tmp212_;
		_tmp214_ = vala_property_accessor_get_prop (self);
		_tmp215_ = _tmp214_;
		_tmp216_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp215_);
		_tmp217_ = _tmp216_;
		_tmp218_ = g_strdup_printf ("Accessor of abstract property `%s' cannot have body", _tmp217_);
		_tmp219_ = _tmp218_;
		vala_report_error (_tmp213_, _tmp219_);
		_g_free0 (_tmp219_);
		_g_free0 (_tmp217_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp220_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp221_ = _tmp220_;
	if (_tmp221_ != NULL) {
		gboolean _tmp222_ = FALSE;
		gboolean _tmp223_;
		ValaBlock* _tmp233_;
		ValaBlock* _tmp234_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp235_;
		ValaArrayList* _tmp236_;
		ValaBlock* _tmp237_;
		ValaBlock* _tmp238_;
		ValaArrayList* _tmp239_;
		_tmp223_ = self->priv->_writable;
		if (_tmp223_) {
			_tmp222_ = TRUE;
		} else {
			gboolean _tmp224_;
			_tmp224_ = self->priv->_construction;
			_tmp222_ = _tmp224_;
		}
		if (_tmp222_) {
			ValaBlock* _tmp225_;
			ValaBlock* _tmp226_;
			ValaScope* _tmp227_;
			ValaScope* _tmp228_;
			ValaParameter* _tmp229_;
			const gchar* _tmp230_;
			const gchar* _tmp231_;
			ValaParameter* _tmp232_;
			_tmp225_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp226_ = _tmp225_;
			_tmp227_ = vala_symbol_get_scope ((ValaSymbol*) _tmp226_);
			_tmp228_ = _tmp227_;
			_tmp229_ = self->priv->_value_parameter;
			_tmp230_ = vala_symbol_get_name ((ValaSymbol*) _tmp229_);
			_tmp231_ = _tmp230_;
			_tmp232_ = self->priv->_value_parameter;
			vala_scope_add (_tmp228_, _tmp231_, (ValaSymbol*) _tmp232_);
		}
		_tmp233_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp234_ = _tmp233_;
		vala_code_node_check ((ValaCodeNode*) _tmp234_, context);
		_tmp235_ = g_direct_equal;
		_tmp236_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp235_);
		error_types = _tmp236_;
		_tmp237_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp238_ = _tmp237_;
		_tmp239_ = error_types;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp238_, (ValaCollection*) _tmp239_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp240_;
			ValaArrayList* _tmp241_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp242_;
			gint _tmp243_;
			gint _tmp244_;
			gint _body_error_type_index = 0;
			_tmp240_ = error_types;
			_tmp241_ = _vala_iterable_ref0 (_tmp240_);
			_body_error_type_list = _tmp241_;
			_tmp242_ = _body_error_type_list;
			_tmp243_ = vala_collection_get_size ((ValaCollection*) _tmp242_);
			_tmp244_ = _tmp243_;
			_body_error_type_size = _tmp244_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp245_;
				gpointer _tmp246_;
				ValaDataType* _tmp247_;
				gboolean _tmp248_;
				gboolean _tmp249_;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp245_ = _body_error_type_list;
				_tmp246_ = vala_list_get ((ValaList*) _tmp245_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp246_;
				_tmp247_ = body_error_type;
				_tmp248_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp247_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp249_ = _tmp248_;
				if (!_tmp249_) {
					ValaDataType* _tmp250_;
					ValaSourceReference* _tmp251_;
					ValaSourceReference* _tmp252_;
					ValaDataType* _tmp253_;
					gchar* _tmp254_;
					gchar* _tmp255_;
					gchar* _tmp256_;
					gchar* _tmp257_;
					_tmp250_ = body_error_type;
					_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = body_error_type;
					_tmp254_ = vala_code_node_to_string ((ValaCodeNode*) _tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = g_strdup_printf ("unhandled error `%s'", _tmp255_);
					_tmp257_ = _tmp256_;
					vala_report_warning (_tmp252_, _tmp257_);
					_g_free0 (_tmp257_);
					_g_free0 (_tmp255_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (error_types);
	}
	_tmp258_ = vala_code_context_get_analyzer (context);
	_tmp259_ = _tmp258_;
	_tmp260_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp259_, _tmp260_);
	_tmp261_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp262_ = _tmp261_;
	result = !_tmp262_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}

ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_PROPERTY (_tmp1_) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}

ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readable;
	return result;
}

static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}

gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_writable;
	return result;
}

static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}

gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_construction;
	return result;
}

static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}

gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic_body;
	return result;
}

static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}

static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}

ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}

static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass,
                                   gpointer klass_data)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_adjust_private_offset (klass, &ValaPropertyAccessor_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}

static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self,
                                      gpointer klass)
{
	self->priv = vala_property_accessor_get_instance_private (self);
}

static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}

/**
 * Represents a get or set accessor of a property in the source code.
 */
GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
		ValaPropertyAccessor_private_offset = g_type_add_instance_private (vala_property_accessor_type_id, sizeof (ValaPropertyAccessorPrivate));
		g_once_init_leave (&vala_property_accessor_type_id__volatile, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__volatile;
}

