/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	if (params == NULL) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_ == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = ret;
		_tmp10_ = g_strconcat (_tmp9_, "_VOID", NULL);
		_g_free0 (ret);
		ret = _tmp10_;
	} else {
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp11_;
			gint _p_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _p_index = 0;
			_tmp11_ = _vala_iterable_ref0 (params);
			_p_list = _tmp11_;
			_tmp12_ = _p_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_p_size = _tmp14_;
			_p_index = -1;
			while (TRUE) {
				ValaParameter* p = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				const gchar* _tmp17_;
				ValaParameter* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp15_ = _p_list;
				_tmp16_ = vala_list_get (_tmp15_, _p_index);
				p = (ValaParameter*) _tmp16_;
				_tmp17_ = ret;
				_tmp18_ = p;
				_tmp19_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_replace (_tmp20_, ",", "_");
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%s_%s", _tmp17_, _tmp22_);
				_g_free0 (ret);
				ret = _tmp23_;
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_data_type (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_data_type (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_data_type (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							ValaStruct* _tmp25_;
							_tmp22_ = vala_data_type_get_data_type (t);
							_tmp23_ = _tmp22_;
							_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct));
							st = _tmp24_;
							_tmp25_ = st;
							if (vala_struct_is_simple_type (_tmp25_)) {
								ValaTypeSymbol* _tmp26_;
								ValaTypeSymbol* _tmp27_;
								gchar* _tmp28_;
								_tmp26_ = vala_data_type_get_data_type (t);
								_tmp27_ = _tmp26_;
								_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
								result = _tmp28_;
								_vala_code_node_unref0 (st);
								return result;
							} else {
								gchar* _tmp29_;
								_tmp29_ = g_strdup ("gpointer");
								result = _tmp29_;
								_vala_code_node_unref0 (st);
								return result;
							}
							_vala_code_node_unref0 (st);
						} else {
							ValaTypeSymbol* _tmp30_;
							ValaTypeSymbol* _tmp31_;
							_tmp30_ = vala_data_type_get_data_type (t);
							_tmp31_ = _tmp30_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp32_;
								ValaTypeSymbol* _tmp33_;
								ValaEnum* _tmp34_;
								ValaEnum* _tmp35_;
								gboolean _tmp36_;
								gboolean _tmp37_;
								_tmp32_ = vala_data_type_get_data_type (t);
								_tmp33_ = _tmp32_;
								_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_ENUM, ValaEnum));
								en = _tmp34_;
								_tmp35_ = en;
								_tmp36_ = vala_enum_get_is_flags (_tmp35_);
								_tmp37_ = _tmp36_;
								if (_tmp37_) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("guint");
									result = _tmp38_;
									_vala_code_node_unref0 (en);
									return result;
								} else {
									gchar* _tmp39_;
									_tmp39_ = g_strdup ("gint");
									result = _tmp39_;
									_vala_code_node_unref0 (en);
									return result;
								}
								_vala_code_node_unref0 (en);
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp40_;
									_tmp40_ = g_strdup ("gpointer");
									result = _tmp40_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp41_;
										_tmp41_ = g_strdup ("gpointer");
										result = _tmp41_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp42_;
											_tmp42_ = g_strdup ("gpointer");
											result = _tmp42_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	if (params == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ == 0;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = signature;
		_tmp7_ = g_strconcat (_tmp6_, "VOID", NULL);
		_g_free0 (signature);
		signature = _tmp7_;
	} else {
		gboolean first = FALSE;
		first = TRUE;
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp8_;
			gint _p_size = 0;
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _p_index = 0;
			_tmp8_ = _vala_iterable_ref0 (params);
			_p_list = _tmp8_;
			_tmp9_ = _p_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_p_size = _tmp11_;
			_p_index = -1;
			while (TRUE) {
				ValaParameter* p = NULL;
				ValaList* _tmp12_;
				gpointer _tmp13_;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp12_ = _p_list;
				_tmp13_ = vala_list_get (_tmp12_, _p_index);
				p = (ValaParameter*) _tmp13_;
				if (first) {
					const gchar* _tmp14_;
					ValaParameter* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp14_ = signature;
					_tmp15_ = p;
					_tmp16_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
					_g_free0 (signature);
					signature = _tmp18_;
					_g_free0 (_tmp17_);
					first = FALSE;
				} else {
					const gchar* _tmp19_;
					ValaParameter* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp19_ = signature;
					_tmp20_ = p;
					_tmp21_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%s,%s", _tmp19_, _tmp22_);
					_g_free0 (signature);
					signature = _tmp23_;
					_g_free0 (_tmp22_);
				}
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = signature;
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	ValaTargetValue* _tmp8_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	ValaTargetValue* _tmp11_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeConstant* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaTargetValue* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaTargetValue* _tmp31_;
	ValaCCodeExpression* _tmp32_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp1_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp2_);
		_tmp4_ = (ValaCCodeExpression*) _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_expression_get_value_type (detail_expr);
	_tmp6_ = _tmp5_;
	_tmp7_ = TRUE;
	_tmp8_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp6_, FALSE, node, &_tmp7_);
	detail_value = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = detail_value;
	vala_list_insert ((ValaList*) _tmp10_, 0, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	ccall = _tmp15_;
	_tmp16_ = ccall;
	_tmp17_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = ccall;
	_tmp20_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = ccall;
	_tmp23_ = vala_ccode_constant_new ("NULL");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = detail_value;
	_tmp28_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	vala_ccode_function_add_assignment (_tmp26_, _tmp29_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp31_ = detail_value;
	_tmp32_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp31_);
	result = _tmp32_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	detail_cexpr = _tmp0_;
	_tmp1_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, _tmp1_)) {
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		_tmp2_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
	} else {
		ValaCCodeIdentifier* _tmp5_;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		_tmp5_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp7_;
		_vala_ccode_node_unref0 (_tmp6_);
	}
	_tmp8_ = detail_ccall;
	_tmp9_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp8_, _tmp9_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}

static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCCodeEnum* _tmp1_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp1_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp3_ = _tmp2_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		ValaCCodeEnumValue* _tmp14_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_ccode_enum_value_new (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_ccode_enum_add_value (_tmp4_, _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp15_;
		gint _p_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _p_index = 0;
		_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_p_list = _tmp15_;
		_tmp16_ = _p_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_p_size = _tmp18_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* _tmp21_;
			ValaCCodeFile* _tmp22_;
			GHashFunc _tmp23_;
			GEqualFunc _tmp24_;
			GEqualFunc _tmp25_;
			ValaHashMap* _tmp26_;
			ValaHashMap* _tmp27_;
			ValaCCodeParameter* _tmp28_;
			ValaCCodeParameter* _tmp29_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = vala_list_get (_tmp19_, _p_index);
			p = (ValaParameter*) _tmp20_;
			_tmp21_ = p;
			_tmp22_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp23_ = g_direct_hash;
			_tmp24_ = g_direct_equal;
			_tmp25_ = g_direct_equal;
			_tmp26_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp23_, _tmp24_, _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp21_, _tmp22_, (ValaMap*) _tmp27_, NULL);
			_tmp29_ = _tmp28_;
			_vala_ccode_node_unref0 (_tmp29_);
			_vala_map_unref0 (_tmp27_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp30_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp33_ = _tmp32_;
	vala_gsignal_module_generate_marshaller (self, _tmp31_, _tmp33_);
	_vala_iterable_unref0 (_tmp31_);
}

static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaCCodeFunctionDeclarator* _tmp103_;
	ValaCCodeParameter* _tmp104_;
	ValaCCodeParameter* _tmp105_;
	ValaCCodeFunction* _tmp106_;
	ValaCCodeFunction* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	ValaCCodeFunctionDeclarator* _tmp110_;
	ValaCCodeTypeDefinition* _tmp111_;
	ValaCCodeTypeDefinition* _tmp112_;
	ValaCCodeFunction* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	ValaCCodeVariableDeclarator* _tmp117_;
	ValaCCodeVariableDeclarator* _tmp118_;
	ValaCCodeFunction* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeIdentifier* _tmp121_;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeCastExpression* _tmp123_;
	ValaCCodeCastExpression* _tmp124_;
	ValaCCodeVariableDeclarator* _tmp125_;
	ValaCCodeVariableDeclarator* _tmp126_;
	ValaCCodeFunction* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeVariableDeclarator* _tmp129_;
	ValaCCodeVariableDeclarator* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	ValaCCodeFunction* _tmp132_;
	ValaCCodeVariableDeclarator* _tmp133_;
	ValaCCodeVariableDeclarator* _tmp134_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp135_ = FALSE;
	ValaTypeSymbol* _tmp136_;
	ValaTypeSymbol* _tmp137_;
	ValaCCodeIdentifier* _tmp157_;
	ValaCCodeIdentifier* _tmp158_;
	ValaCCodeFunctionCall* _tmp159_;
	ValaCCodeFunctionCall* _tmp160_;
	ValaCCodeIdentifier* _tmp161_;
	ValaCCodeIdentifier* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	ValaCCodeConstant* _tmp165_;
	ValaCCodeConstant* _tmp166_;
	ValaCCodeBinaryExpression* _tmp167_;
	ValaCCodeBinaryExpression* _tmp168_;
	ValaCCodeFunction* _tmp169_;
	ValaCCodeFunction* _tmp170_;
	ValaCCodeFunctionCall* _tmp171_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp172_;
	ValaCCodeIdentifier* _tmp173_;
	ValaCCodeMemberAccess* _tmp174_;
	ValaCCodeMemberAccess* _tmp175_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp176_;
	ValaCCodeIdentifier* _tmp177_;
	ValaCCodeMemberAccess* _tmp178_;
	ValaCCodeMemberAccess* _tmp179_;
	ValaCCodeMemberAccess* _tmp180_;
	ValaCCodeMemberAccess* _tmp181_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp182_;
	ValaCCodeConstant* _tmp183_;
	ValaCCodeFunctionCall* _tmp184_;
	ValaCCodeFunctionCall* _tmp185_;
	ValaCCodeFunctionCall* _tmp186_;
	ValaCCodeIdentifier* _tmp187_;
	ValaCCodeIdentifier* _tmp188_;
	ValaCCodeFunction* _tmp189_;
	ValaCCodeFunction* _tmp190_;
	ValaCCodeFunctionCall* _tmp191_;
	ValaCCodeFunction* _tmp192_;
	ValaCCodeFunction* _tmp193_;
	ValaCCodeIdentifier* _tmp194_;
	ValaCCodeIdentifier* _tmp195_;
	ValaCCodeMemberAccess* _tmp196_;
	ValaCCodeFunction* _tmp197_;
	ValaCCodeFunction* _tmp198_;
	ValaCCodeIdentifier* _tmp199_;
	ValaCCodeIdentifier* _tmp200_;
	ValaCCodeMemberAccess* _tmp201_;
	ValaCCodeFunction* _tmp202_;
	ValaCCodeFunction* _tmp203_;
	ValaCCodeFunction* _tmp204_;
	ValaCCodeFunction* _tmp205_;
	ValaCCodeIdentifier* _tmp206_;
	ValaCCodeIdentifier* _tmp207_;
	ValaCCodeMemberAccess* _tmp208_;
	ValaCCodeFunction* _tmp209_;
	ValaCCodeFunction* _tmp210_;
	ValaCCodeIdentifier* _tmp211_;
	ValaCCodeIdentifier* _tmp212_;
	ValaCCodeMemberAccess* _tmp213_;
	ValaCCodeFunction* _tmp214_;
	ValaCCodeFunction* _tmp215_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp216_;
	ValaCCodeIdentifier* _tmp217_;
	ValaCCodeIdentifier* _tmp218_;
	ValaCCodeIdentifier* _tmp219_;
	ValaCCodeIdentifier* _tmp220_;
	ValaCCodeIdentifier* _tmp221_;
	ValaCCodeMemberAccess* _tmp222_;
	ValaCCodeMemberAccess* _tmp223_;
	ValaCCodeConditionalExpression* _tmp224_;
	ValaCCodeConditionalExpression* _tmp225_;
	gchar* _tmp226_;
	gchar* _tmp227_;
	ValaCCodeCastExpression* _tmp228_;
	ValaCCodeCastExpression* _tmp229_;
	ValaCCodeFunction* _tmp230_;
	ValaCCodeFunction* _tmp231_;
	ValaCCodeIdentifier* _tmp232_;
	ValaCCodeIdentifier* _tmp233_;
	ValaCCodeCastExpression* _tmp234_;
	ValaCCodeIdentifier* _tmp235_;
	ValaCCodeIdentifier* _tmp236_;
	ValaCCodeFunctionCall* _tmp237_;
	ValaCCodeFunctionCall* _tmp238_;
	ValaCCodeIdentifier* _tmp239_;
	ValaCCodeIdentifier* _tmp240_;
	ValaCCodeFunctionCall* _tmp396_;
	ValaCCodeIdentifier* _tmp397_;
	ValaCCodeIdentifier* _tmp398_;
	gboolean _tmp399_ = FALSE;
	ValaTypeSymbol* _tmp400_;
	ValaTypeSymbol* _tmp401_;
	ValaCCodeFile* _tmp467_;
	ValaCCodeFunction* _tmp468_;
	ValaCCodeFile* _tmp469_;
	ValaCCodeFunction* _tmp470_;
	ValaSet* _tmp471_;
	const gchar* _tmp472_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaCCodeFunctionDeclarator* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaParameter* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCCodeParameter* _tmp49_;
			ValaCCodeParameter* _tmp50_;
			gint _tmp51_;
			ValaParameter* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp41_ = _p_list;
			_tmp42_ = vala_list_get (_tmp41_, _p_index);
			p = (ValaParameter*) _tmp42_;
			_tmp43_ = callback_decl;
			_tmp44_ = g_strdup_printf ("arg_%d", n_params);
			_tmp45_ = _tmp44_;
			_tmp46_ = p;
			_tmp47_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_parameter_new (_tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			vala_ccode_function_declarator_add_parameter (_tmp43_, _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
			_tmp51_ = n_params;
			n_params = _tmp51_ + 1;
			_tmp52_ = p;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
			_tmp54_ = _tmp53_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp55_;
				ValaDataType* _tmp56_;
				ValaDataType* _tmp57_;
				ValaArrayType* _tmp58_;
				gchar* length_ctype = NULL;
				ValaArrayType* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = p;
				_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp58_;
				_tmp59_ = array_type;
				_tmp60_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp59_);
				length_ctype = _tmp60_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp61_ = FALSE;
						_tmp61_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							ValaCCodeFunctionDeclarator* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							const gchar* _tmp69_;
							ValaCCodeParameter* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							gint _tmp72_;
							if (!_tmp61_) {
								gint _tmp62_;
								_tmp62_ = j;
								j = _tmp62_ + 1;
							}
							_tmp61_ = FALSE;
							_tmp63_ = array_type;
							_tmp64_ = vala_array_type_get_rank (_tmp63_);
							_tmp65_ = _tmp64_;
							if (!(j < _tmp65_)) {
								break;
							}
							_tmp66_ = callback_decl;
							_tmp67_ = g_strdup_printf ("arg_%d", n_params);
							_tmp68_ = _tmp67_;
							_tmp69_ = length_ctype;
							_tmp70_ = vala_ccode_parameter_new (_tmp68_, _tmp69_);
							_tmp71_ = _tmp70_;
							vala_ccode_function_declarator_add_parameter (_tmp66_, _tmp71_);
							_vala_ccode_node_unref0 (_tmp71_);
							_g_free0 (_tmp68_);
							_tmp72_ = n_params;
							n_params = _tmp72_ + 1;
						}
					}
				}
				_g_free0 (length_ctype);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp73_ = p;
				_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
				_tmp75_ = _tmp74_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDelegateType* _tmp79_;
					ValaDelegate* _tmp80_;
					ValaDelegate* _tmp81_;
					gboolean _tmp82_;
					gboolean _tmp83_;
					_tmp76_ = p;
					_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
					_tmp78_ = _tmp77_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp79_ = delegate_type;
					_tmp80_ = vala_delegate_type_get_delegate_symbol (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_delegate_get_has_target (_tmp81_);
					_tmp83_ = _tmp82_;
					if (_tmp83_) {
						ValaCCodeFunctionDeclarator* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						ValaDataType* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						ValaCCodeParameter* _tmp90_;
						ValaCCodeParameter* _tmp91_;
						gint _tmp92_;
						ValaDelegateType* _tmp93_;
						_tmp84_ = callback_decl;
						_tmp85_ = g_strdup_printf ("arg_%d", n_params);
						_tmp86_ = _tmp85_;
						_tmp87_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
						_tmp88_ = vala_get_ccode_name ((ValaCodeNode*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = vala_ccode_parameter_new (_tmp86_, _tmp89_);
						_tmp91_ = _tmp90_;
						vala_ccode_function_declarator_add_parameter (_tmp84_, _tmp91_);
						_vala_ccode_node_unref0 (_tmp91_);
						_g_free0 (_tmp89_);
						_g_free0 (_tmp86_);
						_tmp92_ = n_params;
						n_params = _tmp92_ + 1;
						_tmp93_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp93_)) {
							ValaCCodeFunctionDeclarator* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaDelegateType* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							ValaCCodeParameter* _tmp100_;
							ValaCCodeParameter* _tmp101_;
							gint _tmp102_;
							_tmp94_ = callback_decl;
							_tmp95_ = g_strdup_printf ("arg_%d", n_params);
							_tmp96_ = _tmp95_;
							_tmp97_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
							_tmp98_ = vala_get_ccode_name ((ValaCodeNode*) _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = vala_ccode_parameter_new (_tmp96_, _tmp99_);
							_tmp101_ = _tmp100_;
							vala_ccode_function_declarator_add_parameter (_tmp94_, _tmp101_);
							_vala_ccode_node_unref0 (_tmp101_);
							_g_free0 (_tmp99_);
							_g_free0 (_tmp96_);
							_tmp102_ = n_params;
							n_params = _tmp102_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp103_ = callback_decl;
	_tmp104_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp105_ = _tmp104_;
	vala_ccode_function_declarator_add_parameter (_tmp103_, _tmp105_);
	_vala_ccode_node_unref0 (_tmp105_);
	_tmp106_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp109_ = _tmp108_;
	_tmp110_ = callback_decl;
	_tmp111_ = vala_ccode_type_definition_new (_tmp109_, (ValaCCodeDeclarator*) _tmp110_);
	_tmp112_ = _tmp111_;
	vala_ccode_function_add_statement (_tmp107_, (ValaCCodeNode*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_g_free0 (_tmp109_);
	_tmp113_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp118_ = _tmp117_;
	vala_ccode_function_add_declaration (_tmp114_, _tmp116_, (ValaCCodeDeclarator*) _tmp118_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp118_);
	_g_free0 (_tmp116_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_identifier_new ("closure");
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp122_, "GCClosure *");
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp124_, NULL);
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_declaration (_tmp120_, "GCClosure *", (ValaCCodeDeclarator*) _tmp126_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp126_);
	_vala_ccode_node_unref0 (_tmp124_);
	_vala_ccode_node_unref0 (_tmp122_);
	_tmp127_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp130_ = _tmp129_;
	vala_ccode_function_add_declaration (_tmp128_, "gpointer", (ValaCCodeDeclarator*) _tmp130_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp130_);
	_tmp131_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp134_ = _tmp133_;
	vala_ccode_function_add_declaration (_tmp132_, "gpointer", (ValaCCodeDeclarator*) _tmp134_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp134_);
	_tmp136_ = vala_data_type_get_data_type (return_type);
	_tmp137_ = _tmp136_;
	if (_tmp137_ != NULL) {
		_tmp135_ = TRUE;
	} else {
		_tmp135_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp135_) {
		ValaCCodeFunction* _tmp138_;
		ValaCCodeFunction* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		ValaCCodeVariableDeclarator* _tmp142_;
		ValaCCodeVariableDeclarator* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaCCodeFunctionCall* _tmp147_;
		ValaCCodeIdentifier* _tmp148_;
		ValaCCodeIdentifier* _tmp149_;
		ValaCCodeConstant* _tmp150_;
		ValaCCodeConstant* _tmp151_;
		ValaCCodeBinaryExpression* _tmp152_;
		ValaCCodeBinaryExpression* _tmp153_;
		ValaCCodeFunction* _tmp154_;
		ValaCCodeFunction* _tmp155_;
		ValaCCodeFunctionCall* _tmp156_;
		_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp143_ = _tmp142_;
		vala_ccode_function_add_declaration (_tmp139_, _tmp141_, (ValaCCodeDeclarator*) _tmp143_, 0);
		_vala_ccode_node_unref0 (_tmp143_);
		_g_free0 (_tmp141_);
		_tmp144_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_tmp147_ = fc;
		_tmp148_ = vala_ccode_identifier_new ("return_value");
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_constant_new ("NULL");
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp149_, (ValaCCodeExpression*) _tmp151_);
		_tmp153_ = _tmp152_;
		vala_ccode_function_call_add_argument (_tmp147_, (ValaCCodeExpression*) _tmp153_);
		_vala_ccode_node_unref0 (_tmp153_);
		_vala_ccode_node_unref0 (_tmp151_);
		_vala_ccode_node_unref0 (_tmp149_);
		_tmp154_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = fc;
		vala_ccode_function_add_expression (_tmp155_, (ValaCCodeExpression*) _tmp156_);
	}
	_tmp157_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp158_ = _tmp157_;
	_tmp159_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp158_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp159_;
	_vala_ccode_node_unref0 (_tmp158_);
	_tmp160_ = fc;
	_tmp161_ = vala_ccode_identifier_new ("n_param_values");
	_tmp162_ = _tmp161_;
	_tmp163_ = g_strdup_printf ("%i", n_params);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_constant_new (_tmp164_);
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp162_, (ValaCCodeExpression*) _tmp166_);
	_tmp168_ = _tmp167_;
	vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp168_);
	_vala_ccode_node_unref0 (_tmp168_);
	_vala_ccode_node_unref0 (_tmp166_);
	_g_free0 (_tmp164_);
	_vala_ccode_node_unref0 (_tmp162_);
	_tmp169_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp170_ = _tmp169_;
	_tmp171_ = fc;
	vala_ccode_function_add_expression (_tmp170_, (ValaCCodeExpression*) _tmp171_);
	_tmp172_ = vala_ccode_identifier_new ("closure");
	_tmp173_ = _tmp172_;
	_tmp174_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp173_, "data", TRUE);
	_tmp175_ = _tmp174_;
	_vala_ccode_node_unref0 (_tmp173_);
	data = _tmp175_;
	_tmp176_ = vala_ccode_identifier_new ("param_values");
	_tmp177_ = _tmp176_;
	_tmp178_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp177_, "data[0]", TRUE);
	_tmp179_ = _tmp178_;
	_tmp180_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp179_, "v_pointer", FALSE);
	_tmp181_ = _tmp180_;
	_vala_ccode_node_unref0 (_tmp179_);
	_vala_ccode_node_unref0 (_tmp177_);
	param = _tmp181_;
	_tmp182_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp183_ = _tmp182_;
	_tmp184_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp183_);
	_tmp185_ = _tmp184_;
	_vala_ccode_node_unref0 (_tmp183_);
	cond = _tmp185_;
	_tmp186_ = cond;
	_tmp187_ = vala_ccode_identifier_new ("closure");
	_tmp188_ = _tmp187_;
	vala_ccode_function_call_add_argument (_tmp186_, (ValaCCodeExpression*) _tmp188_);
	_vala_ccode_node_unref0 (_tmp188_);
	_tmp189_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp190_ = _tmp189_;
	_tmp191_ = cond;
	vala_ccode_function_open_if (_tmp190_, (ValaCCodeExpression*) _tmp191_);
	_tmp192_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_ccode_identifier_new ("data1");
	_tmp195_ = _tmp194_;
	_tmp196_ = data;
	vala_ccode_function_add_assignment (_tmp193_, (ValaCCodeExpression*) _tmp195_, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp195_);
	_tmp197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp198_ = _tmp197_;
	_tmp199_ = vala_ccode_identifier_new ("data2");
	_tmp200_ = _tmp199_;
	_tmp201_ = param;
	vala_ccode_function_add_assignment (_tmp198_, (ValaCCodeExpression*) _tmp200_, (ValaCCodeExpression*) _tmp201_);
	_vala_ccode_node_unref0 (_tmp200_);
	_tmp202_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp203_ = _tmp202_;
	vala_ccode_function_add_else (_tmp203_);
	_tmp204_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_ccode_identifier_new ("data1");
	_tmp207_ = _tmp206_;
	_tmp208_ = param;
	vala_ccode_function_add_assignment (_tmp205_, (ValaCCodeExpression*) _tmp207_, (ValaCCodeExpression*) _tmp208_);
	_vala_ccode_node_unref0 (_tmp207_);
	_tmp209_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp210_ = _tmp209_;
	_tmp211_ = vala_ccode_identifier_new ("data2");
	_tmp212_ = _tmp211_;
	_tmp213_ = data;
	vala_ccode_function_add_assignment (_tmp210_, (ValaCCodeExpression*) _tmp212_, (ValaCCodeExpression*) _tmp213_);
	_vala_ccode_node_unref0 (_tmp212_);
	_tmp214_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp215_ = _tmp214_;
	vala_ccode_function_close (_tmp215_);
	_tmp216_ = vala_ccode_identifier_new ("marshal_data");
	_tmp217_ = _tmp216_;
	_tmp218_ = vala_ccode_identifier_new ("marshal_data");
	_tmp219_ = _tmp218_;
	_tmp220_ = vala_ccode_identifier_new ("cc");
	_tmp221_ = _tmp220_;
	_tmp222_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp221_, "callback", TRUE);
	_tmp223_ = _tmp222_;
	_tmp224_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp217_, (ValaCCodeExpression*) _tmp219_, (ValaCCodeExpression*) _tmp223_);
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp225_, _tmp227_);
	_tmp229_ = _tmp228_;
	_g_free0 (_tmp227_);
	_vala_ccode_node_unref0 (_tmp225_);
	_vala_ccode_node_unref0 (_tmp223_);
	_vala_ccode_node_unref0 (_tmp221_);
	_vala_ccode_node_unref0 (_tmp219_);
	_vala_ccode_node_unref0 (_tmp217_);
	c_assign_rhs = _tmp229_;
	_tmp230_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_ccode_identifier_new ("callback");
	_tmp233_ = _tmp232_;
	_tmp234_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp231_, (ValaCCodeExpression*) _tmp233_, (ValaCCodeExpression*) _tmp234_);
	_vala_ccode_node_unref0 (_tmp233_);
	_tmp235_ = vala_ccode_identifier_new ("callback");
	_tmp236_ = _tmp235_;
	_tmp237_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp236_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp237_;
	_vala_ccode_node_unref0 (_tmp236_);
	_tmp238_ = fc;
	_tmp239_ = vala_ccode_identifier_new ("data1");
	_tmp240_ = _tmp239_;
	vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
	_vala_ccode_node_unref0 (_tmp240_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp241_;
		gint _p_size = 0;
		ValaList* _tmp242_;
		gint _tmp243_;
		gint _tmp244_;
		gint _p_index = 0;
		_tmp241_ = _vala_iterable_ref0 (params);
		_p_list = _tmp241_;
		_tmp242_ = _p_list;
		_tmp243_ = vala_collection_get_size ((ValaCollection*) _tmp242_);
		_tmp244_ = _tmp243_;
		_p_size = _tmp244_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			gchar* get_value_function = NULL;
			ValaParameter* _tmp247_;
			ValaParameterDirection _tmp248_;
			ValaParameterDirection _tmp249_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			const gchar* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeIdentifier* _tmp300_;
			ValaCCodeFunctionCall* _tmp301_;
			ValaCCodeFunctionCall* _tmp302_;
			ValaCCodeFunctionCall* _tmp303_;
			ValaCCodeIdentifier* _tmp304_;
			ValaCCodeIdentifier* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			ValaCCodeIdentifier* _tmp308_;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeBinaryExpression* _tmp310_;
			ValaCCodeBinaryExpression* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			gint _tmp314_;
			ValaParameter* _tmp315_;
			ValaDataType* _tmp316_;
			ValaDataType* _tmp317_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp245_ = _p_list;
			_tmp246_ = vala_list_get (_tmp245_, _p_index);
			p = (ValaParameter*) _tmp246_;
			_tmp247_ = p;
			_tmp248_ = vala_parameter_get_direction (_tmp247_);
			_tmp249_ = _tmp248_;
			if (_tmp249_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* _tmp250_;
				_tmp250_ = g_strdup ("g_value_get_pointer");
				_g_free0 (get_value_function);
				get_value_function = _tmp250_;
			} else {
				ValaParameter* _tmp251_;
				ValaDataType* _tmp252_;
				ValaDataType* _tmp253_;
				_tmp251_ = p;
				_tmp252_ = vala_variable_get_variable_type ((ValaVariable*) _tmp251_);
				_tmp253_ = _tmp252_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp253_, VALA_TYPE_ARRAY_TYPE)) {
					ValaParameter* _tmp254_;
					ValaDataType* _tmp255_;
					ValaDataType* _tmp256_;
					ValaDataType* _tmp257_;
					ValaDataType* _tmp258_;
					ValaTypeSymbol* _tmp259_;
					ValaTypeSymbol* _tmp260_;
					ValaDataType* _tmp261_;
					ValaTypeSymbol* _tmp262_;
					ValaTypeSymbol* _tmp263_;
					_tmp254_ = p;
					_tmp255_ = vala_variable_get_variable_type ((ValaVariable*) _tmp254_);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp256_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_data_type_get_data_type (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp262_ = vala_data_type_get_data_type (_tmp261_);
					_tmp263_ = _tmp262_;
					if (_tmp260_ == _tmp263_) {
						gchar* _tmp264_;
						_tmp264_ = g_strdup ("g_value_get_boxed");
						_g_free0 (get_value_function);
						get_value_function = _tmp264_;
					} else {
						gchar* _tmp265_;
						_tmp265_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp265_;
					}
				} else {
					ValaParameter* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					_tmp266_ = p;
					_tmp267_ = vala_variable_get_variable_type ((ValaVariable*) _tmp266_);
					_tmp268_ = _tmp267_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp268_, VALA_TYPE_DELEGATE_TYPE)) {
						gchar* _tmp269_;
						_tmp269_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp269_;
					} else {
						gboolean _tmp270_ = FALSE;
						ValaParameter* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						_tmp271_ = p;
						_tmp272_ = vala_variable_get_variable_type ((ValaVariable*) _tmp271_);
						_tmp273_ = _tmp272_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, VALA_TYPE_POINTER_TYPE)) {
							_tmp270_ = TRUE;
						} else {
							ValaParameter* _tmp274_;
							ValaDataType* _tmp275_;
							ValaDataType* _tmp276_;
							_tmp274_ = p;
							_tmp275_ = vala_variable_get_variable_type ((ValaVariable*) _tmp274_);
							_tmp276_ = _tmp275_;
							_tmp270_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp276_, VALA_TYPE_GENERIC_TYPE);
						}
						if (_tmp270_) {
							gchar* _tmp277_;
							_tmp277_ = g_strdup ("g_value_get_pointer");
							_g_free0 (get_value_function);
							get_value_function = _tmp277_;
						} else {
							ValaParameter* _tmp278_;
							ValaDataType* _tmp279_;
							ValaDataType* _tmp280_;
							_tmp278_ = p;
							_tmp279_ = vala_variable_get_variable_type ((ValaVariable*) _tmp278_);
							_tmp280_ = _tmp279_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp280_, VALA_TYPE_ERROR_TYPE)) {
								gchar* _tmp281_;
								_tmp281_ = g_strdup ("g_value_get_pointer");
								_g_free0 (get_value_function);
								get_value_function = _tmp281_;
							} else {
								gboolean _tmp282_ = FALSE;
								ValaParameter* _tmp283_;
								ValaDataType* _tmp284_;
								ValaDataType* _tmp285_;
								_tmp283_ = p;
								_tmp284_ = vala_variable_get_variable_type ((ValaVariable*) _tmp283_);
								_tmp285_ = _tmp284_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp285_, VALA_TYPE_VALUE_TYPE)) {
									ValaParameter* _tmp286_;
									ValaDataType* _tmp287_;
									ValaDataType* _tmp288_;
									gboolean _tmp289_;
									gboolean _tmp290_;
									_tmp286_ = p;
									_tmp287_ = vala_variable_get_variable_type ((ValaVariable*) _tmp286_);
									_tmp288_ = _tmp287_;
									_tmp289_ = vala_data_type_get_nullable (_tmp288_);
									_tmp290_ = _tmp289_;
									_tmp282_ = _tmp290_;
								} else {
									_tmp282_ = FALSE;
								}
								if (_tmp282_) {
									gchar* _tmp291_;
									_tmp291_ = g_strdup ("g_value_get_pointer");
									_g_free0 (get_value_function);
									get_value_function = _tmp291_;
								} else {
									ValaParameter* _tmp292_;
									ValaDataType* _tmp293_;
									ValaDataType* _tmp294_;
									ValaTypeSymbol* _tmp295_;
									ValaTypeSymbol* _tmp296_;
									gchar* _tmp297_;
									_tmp292_ = p;
									_tmp293_ = vala_variable_get_variable_type ((ValaVariable*) _tmp292_);
									_tmp294_ = _tmp293_;
									_tmp295_ = vala_data_type_get_data_type (_tmp294_);
									_tmp296_ = _tmp295_;
									_tmp297_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp296_);
									_g_free0 (get_value_function);
									get_value_function = _tmp297_;
								}
							}
						}
					}
				}
			}
			_tmp298_ = get_value_function;
			_tmp299_ = vala_ccode_identifier_new (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp300_);
			_tmp302_ = _tmp301_;
			_vala_ccode_node_unref0 (_tmp300_);
			inner_fc = _tmp302_;
			_tmp303_ = inner_fc;
			_tmp304_ = vala_ccode_identifier_new ("param_values");
			_tmp305_ = _tmp304_;
			_tmp306_ = g_strdup_printf ("%i", i);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_ccode_identifier_new (_tmp307_);
			_tmp309_ = _tmp308_;
			_tmp310_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp305_, (ValaCCodeExpression*) _tmp309_);
			_tmp311_ = _tmp310_;
			vala_ccode_function_call_add_argument (_tmp303_, (ValaCCodeExpression*) _tmp311_);
			_vala_ccode_node_unref0 (_tmp311_);
			_vala_ccode_node_unref0 (_tmp309_);
			_g_free0 (_tmp307_);
			_vala_ccode_node_unref0 (_tmp305_);
			_tmp312_ = fc;
			_tmp313_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp312_, (ValaCCodeExpression*) _tmp313_);
			_tmp314_ = i;
			i = _tmp314_ + 1;
			_tmp315_ = p;
			_tmp316_ = vala_variable_get_variable_type ((ValaVariable*) _tmp315_);
			_tmp317_ = _tmp316_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp320_;
				ValaArrayType* _tmp321_;
				gchar* length_value_function = NULL;
				ValaArrayType* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				ValaTypeSymbol* _tmp325_;
				ValaTypeSymbol* _tmp326_;
				gchar* _tmp327_;
				gboolean _tmp328_ = FALSE;
				const gchar* _tmp329_;
				_tmp318_ = p;
				_tmp319_ = vala_variable_get_variable_type ((ValaVariable*) _tmp318_);
				_tmp320_ = _tmp319_;
				_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp321_;
				_tmp322_ = array_type;
				_tmp323_ = vala_array_type_get_length_type (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_get_data_type (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp326_);
				length_value_function = _tmp327_;
				_tmp329_ = length_value_function;
				if (_tmp329_ != NULL) {
					const gchar* _tmp330_;
					_tmp330_ = length_value_function;
					_tmp328_ = g_strcmp0 (_tmp330_, "") != 0;
				} else {
					_tmp328_ = FALSE;
				}
				_vala_assert (_tmp328_, "length_value_function != null && length_value_function != \"\"");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp331_ = FALSE;
						_tmp331_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp333_;
							gint _tmp334_;
							gint _tmp335_;
							const gchar* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeIdentifier* _tmp338_;
							ValaCCodeFunctionCall* _tmp339_;
							ValaCCodeFunctionCall* _tmp340_;
							ValaCCodeIdentifier* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							gchar* _tmp343_;
							gchar* _tmp344_;
							ValaCCodeIdentifier* _tmp345_;
							ValaCCodeIdentifier* _tmp346_;
							ValaCCodeBinaryExpression* _tmp347_;
							ValaCCodeBinaryExpression* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							gint _tmp351_;
							if (!_tmp331_) {
								gint _tmp332_;
								_tmp332_ = j;
								j = _tmp332_ + 1;
							}
							_tmp331_ = FALSE;
							_tmp333_ = array_type;
							_tmp334_ = vala_array_type_get_rank (_tmp333_);
							_tmp335_ = _tmp334_;
							if (!(j < _tmp335_)) {
								break;
							}
							_tmp336_ = length_value_function;
							_tmp337_ = vala_ccode_identifier_new (_tmp336_);
							_tmp338_ = _tmp337_;
							_tmp339_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp338_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp339_;
							_vala_ccode_node_unref0 (_tmp338_);
							_tmp340_ = inner_fc;
							_tmp341_ = vala_ccode_identifier_new ("param_values");
							_tmp342_ = _tmp341_;
							_tmp343_ = g_strdup_printf ("%i", i);
							_tmp344_ = _tmp343_;
							_tmp345_ = vala_ccode_identifier_new (_tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp342_, (ValaCCodeExpression*) _tmp346_);
							_tmp348_ = _tmp347_;
							vala_ccode_function_call_add_argument (_tmp340_, (ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (_tmp348_);
							_vala_ccode_node_unref0 (_tmp346_);
							_g_free0 (_tmp344_);
							_vala_ccode_node_unref0 (_tmp342_);
							_tmp349_ = fc;
							_tmp350_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp349_, (ValaCCodeExpression*) _tmp350_);
							_tmp351_ = i;
							i = _tmp351_ + 1;
						}
					}
				}
				_g_free0 (length_value_function);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				_tmp352_ = p;
				_tmp353_ = vala_variable_get_variable_type ((ValaVariable*) _tmp352_);
				_tmp354_ = _tmp353_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp355_;
					ValaDataType* _tmp356_;
					ValaDataType* _tmp357_;
					ValaDelegateType* _tmp358_;
					ValaDelegate* _tmp359_;
					ValaDelegate* _tmp360_;
					gboolean _tmp361_;
					gboolean _tmp362_;
					_tmp355_ = p;
					_tmp356_ = vala_variable_get_variable_type ((ValaVariable*) _tmp355_);
					_tmp357_ = _tmp356_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp358_ = delegate_type;
					_tmp359_ = vala_delegate_type_get_delegate_symbol (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_delegate_get_has_target (_tmp360_);
					_tmp362_ = _tmp361_;
					if (_tmp362_) {
						const gchar* _tmp363_;
						ValaCCodeIdentifier* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaCCodeFunctionCall* _tmp366_;
						ValaCCodeFunctionCall* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						ValaCCodeIdentifier* _tmp372_;
						ValaCCodeIdentifier* _tmp373_;
						ValaCCodeBinaryExpression* _tmp374_;
						ValaCCodeBinaryExpression* _tmp375_;
						ValaCCodeFunctionCall* _tmp376_;
						ValaCCodeFunctionCall* _tmp377_;
						gint _tmp378_;
						ValaDelegateType* _tmp379_;
						_tmp363_ = get_value_function;
						_tmp364_ = vala_ccode_identifier_new (_tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp365_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp366_;
						_vala_ccode_node_unref0 (_tmp365_);
						_tmp367_ = inner_fc;
						_tmp368_ = vala_ccode_identifier_new ("param_values");
						_tmp369_ = _tmp368_;
						_tmp370_ = g_strdup_printf ("%i", i);
						_tmp371_ = _tmp370_;
						_tmp372_ = vala_ccode_identifier_new (_tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp369_, (ValaCCodeExpression*) _tmp373_);
						_tmp375_ = _tmp374_;
						vala_ccode_function_call_add_argument (_tmp367_, (ValaCCodeExpression*) _tmp375_);
						_vala_ccode_node_unref0 (_tmp375_);
						_vala_ccode_node_unref0 (_tmp373_);
						_g_free0 (_tmp371_);
						_vala_ccode_node_unref0 (_tmp369_);
						_tmp376_ = fc;
						_tmp377_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp376_, (ValaCCodeExpression*) _tmp377_);
						_tmp378_ = i;
						i = _tmp378_ + 1;
						_tmp379_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp379_)) {
							const gchar* _tmp380_;
							ValaCCodeIdentifier* _tmp381_;
							ValaCCodeIdentifier* _tmp382_;
							ValaCCodeFunctionCall* _tmp383_;
							ValaCCodeFunctionCall* _tmp384_;
							ValaCCodeIdentifier* _tmp385_;
							ValaCCodeIdentifier* _tmp386_;
							gchar* _tmp387_;
							gchar* _tmp388_;
							ValaCCodeIdentifier* _tmp389_;
							ValaCCodeIdentifier* _tmp390_;
							ValaCCodeBinaryExpression* _tmp391_;
							ValaCCodeBinaryExpression* _tmp392_;
							ValaCCodeFunctionCall* _tmp393_;
							ValaCCodeFunctionCall* _tmp394_;
							gint _tmp395_;
							_tmp380_ = get_value_function;
							_tmp381_ = vala_ccode_identifier_new (_tmp380_);
							_tmp382_ = _tmp381_;
							_tmp383_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp382_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp383_;
							_vala_ccode_node_unref0 (_tmp382_);
							_tmp384_ = inner_fc;
							_tmp385_ = vala_ccode_identifier_new ("param_values");
							_tmp386_ = _tmp385_;
							_tmp387_ = g_strdup_printf ("%i", i);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_ccode_identifier_new (_tmp388_);
							_tmp390_ = _tmp389_;
							_tmp391_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp386_, (ValaCCodeExpression*) _tmp390_);
							_tmp392_ = _tmp391_;
							vala_ccode_function_call_add_argument (_tmp384_, (ValaCCodeExpression*) _tmp392_);
							_vala_ccode_node_unref0 (_tmp392_);
							_vala_ccode_node_unref0 (_tmp390_);
							_g_free0 (_tmp388_);
							_vala_ccode_node_unref0 (_tmp386_);
							_tmp393_ = fc;
							_tmp394_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp393_, (ValaCCodeExpression*) _tmp394_);
							_tmp395_ = i;
							i = _tmp395_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_g_free0 (get_value_function);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp396_ = fc;
	_tmp397_ = vala_ccode_identifier_new ("data2");
	_tmp398_ = _tmp397_;
	vala_ccode_function_call_add_argument (_tmp396_, (ValaCCodeExpression*) _tmp398_);
	_vala_ccode_node_unref0 (_tmp398_);
	_tmp400_ = vala_data_type_get_data_type (return_type);
	_tmp401_ = _tmp400_;
	if (_tmp401_ != NULL) {
		_tmp399_ = TRUE;
	} else {
		_tmp399_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp399_) {
		ValaCCodeFunction* _tmp402_;
		ValaCCodeFunction* _tmp403_;
		ValaCCodeIdentifier* _tmp404_;
		ValaCCodeIdentifier* _tmp405_;
		ValaCCodeFunctionCall* _tmp406_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp455_;
		ValaCCodeIdentifier* _tmp456_;
		ValaCCodeIdentifier* _tmp457_;
		ValaCCodeFunctionCall* _tmp458_;
		ValaCCodeIdentifier* _tmp459_;
		ValaCCodeIdentifier* _tmp460_;
		ValaCCodeFunction* _tmp461_;
		ValaCCodeFunction* _tmp462_;
		ValaCCodeFunctionCall* _tmp463_;
		_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp403_ = _tmp402_;
		_tmp404_ = vala_ccode_identifier_new ("v_return");
		_tmp405_ = _tmp404_;
		_tmp406_ = fc;
		vala_ccode_function_add_assignment (_tmp403_, (ValaCCodeExpression*) _tmp405_, (ValaCCodeExpression*) _tmp406_);
		_vala_ccode_node_unref0 (_tmp405_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			ValaDataType* _tmp407_;
			ValaDataType* _tmp408_;
			ValaTypeSymbol* _tmp409_;
			ValaTypeSymbol* _tmp410_;
			ValaDataType* _tmp411_;
			ValaTypeSymbol* _tmp412_;
			ValaTypeSymbol* _tmp413_;
			_tmp407_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (return_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp408_ = _tmp407_;
			_tmp409_ = vala_data_type_get_data_type (_tmp408_);
			_tmp410_ = _tmp409_;
			_tmp411_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp412_ = vala_data_type_get_data_type (_tmp411_);
			_tmp413_ = _tmp412_;
			if (_tmp410_ == _tmp413_) {
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeIdentifier* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				_tmp414_ = vala_ccode_identifier_new ("g_value_take_boxed");
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp415_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp416_;
				_vala_ccode_node_unref0 (_tmp415_);
			} else {
				ValaCCodeIdentifier* _tmp417_;
				ValaCCodeIdentifier* _tmp418_;
				ValaCCodeFunctionCall* _tmp419_;
				_tmp417_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp418_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp419_;
				_vala_ccode_node_unref0 (_tmp418_);
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_GENERIC_TYPE)) {
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeIdentifier* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				_tmp420_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp421_ = _tmp420_;
				_tmp422_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp421_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp422_;
				_vala_ccode_node_unref0 (_tmp421_);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ERROR_TYPE)) {
					ValaCCodeIdentifier* _tmp423_;
					ValaCCodeIdentifier* _tmp424_;
					ValaCCodeFunctionCall* _tmp425_;
					_tmp423_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp424_ = _tmp423_;
					_tmp425_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp424_);
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp425_;
					_vala_ccode_node_unref0 (_tmp424_);
				} else {
					ValaTypeSymbol* _tmp426_;
					ValaTypeSymbol* _tmp427_;
					ValaDataType* _tmp428_;
					ValaTypeSymbol* _tmp429_;
					ValaTypeSymbol* _tmp430_;
					_tmp426_ = vala_data_type_get_data_type (return_type);
					_tmp427_ = _tmp426_;
					_tmp428_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp429_ = vala_data_type_get_data_type (_tmp428_);
					_tmp430_ = _tmp429_;
					if (_tmp427_ == _tmp430_) {
						ValaCCodeIdentifier* _tmp431_;
						ValaCCodeIdentifier* _tmp432_;
						ValaCCodeFunctionCall* _tmp433_;
						_tmp431_ = vala_ccode_identifier_new ("g_value_take_string");
						_tmp432_ = _tmp431_;
						_tmp433_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp432_);
						_vala_ccode_node_unref0 (set_fc);
						set_fc = _tmp433_;
						_vala_ccode_node_unref0 (_tmp432_);
					} else {
						gboolean _tmp434_ = FALSE;
						ValaTypeSymbol* _tmp435_;
						ValaTypeSymbol* _tmp436_;
						_tmp435_ = vala_data_type_get_data_type (return_type);
						_tmp436_ = _tmp435_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_CLASS)) {
							_tmp434_ = TRUE;
						} else {
							ValaTypeSymbol* _tmp437_;
							ValaTypeSymbol* _tmp438_;
							_tmp437_ = vala_data_type_get_data_type (return_type);
							_tmp438_ = _tmp437_;
							_tmp434_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp438_, VALA_TYPE_INTERFACE);
						}
						if (_tmp434_) {
							ValaCCodeIdentifier* _tmp439_;
							ValaCCodeIdentifier* _tmp440_;
							ValaCCodeFunctionCall* _tmp441_;
							_tmp439_ = vala_ccode_identifier_new ("g_value_take_object");
							_tmp440_ = _tmp439_;
							_tmp441_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp440_);
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp441_;
							_vala_ccode_node_unref0 (_tmp440_);
						} else {
							gboolean _tmp442_ = FALSE;
							if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
								gboolean _tmp443_;
								gboolean _tmp444_;
								_tmp443_ = vala_data_type_get_nullable (return_type);
								_tmp444_ = _tmp443_;
								_tmp442_ = _tmp444_;
							} else {
								_tmp442_ = FALSE;
							}
							if (_tmp442_) {
								ValaCCodeIdentifier* _tmp445_;
								ValaCCodeIdentifier* _tmp446_;
								ValaCCodeFunctionCall* _tmp447_;
								_tmp445_ = vala_ccode_identifier_new ("g_value_set_pointer");
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp446_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp447_;
								_vala_ccode_node_unref0 (_tmp446_);
							} else {
								ValaTypeSymbol* _tmp448_;
								ValaTypeSymbol* _tmp449_;
								gchar* _tmp450_;
								gchar* _tmp451_;
								ValaCCodeIdentifier* _tmp452_;
								ValaCCodeIdentifier* _tmp453_;
								ValaCCodeFunctionCall* _tmp454_;
								_tmp448_ = vala_data_type_get_data_type (return_type);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp449_);
								_tmp451_ = _tmp450_;
								_tmp452_ = vala_ccode_identifier_new (_tmp451_);
								_tmp453_ = _tmp452_;
								_tmp454_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp453_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp454_;
								_vala_ccode_node_unref0 (_tmp453_);
								_g_free0 (_tmp451_);
							}
						}
					}
				}
			}
		}
		_tmp455_ = set_fc;
		_tmp456_ = vala_ccode_identifier_new ("return_value");
		_tmp457_ = _tmp456_;
		vala_ccode_function_call_add_argument (_tmp455_, (ValaCCodeExpression*) _tmp457_);
		_vala_ccode_node_unref0 (_tmp457_);
		_tmp458_ = set_fc;
		_tmp459_ = vala_ccode_identifier_new ("v_return");
		_tmp460_ = _tmp459_;
		vala_ccode_function_call_add_argument (_tmp458_, (ValaCCodeExpression*) _tmp460_);
		_vala_ccode_node_unref0 (_tmp460_);
		_tmp461_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp462_ = _tmp461_;
		_tmp463_ = set_fc;
		vala_ccode_function_add_expression (_tmp462_, (ValaCCodeExpression*) _tmp463_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp464_;
		ValaCCodeFunction* _tmp465_;
		ValaCCodeFunctionCall* _tmp466_;
		_tmp464_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp465_ = _tmp464_;
		_tmp466_ = fc;
		vala_ccode_function_add_expression (_tmp465_, (ValaCCodeExpression*) _tmp466_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp467_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp468_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp467_, _tmp468_);
	_tmp469_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp470_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp469_, _tmp470_);
	_tmp471_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp472_ = signature;
	vala_collection_add ((ValaCollection*) _tmp471_, _tmp472_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp34_;
	ValaVersionAttribute* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	ValaCCodeFunctionCall* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaMethod* _tmp46_;
	ValaMethod* _tmp47_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeConstant* _tmp77_;
	ValaCCodeConstant* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeConstant* _tmp80_;
	ValaCCodeConstant* _tmp81_;
	gchar* marshaller = NULL;
	ValaList* _tmp82_;
	ValaList* _tmp83_;
	ValaDataType* _tmp84_;
	ValaDataType* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaList* params = NULL;
	ValaList* _tmp92_;
	gboolean _tmp93_ = FALSE;
	ValaDataType* _tmp94_;
	ValaDataType* _tmp95_;
	gint params_len = 0;
	ValaCCodeFunctionCall* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	ValaCCodeConstant* _tmp165_;
	ValaCCodeConstant* _tmp166_;
	ValaCCodeIdentifier* _tmp278_;
	const gchar* _tmp279_;
	ValaCCodeExpression* _tmp280_;
	ValaCCodeExpression* _tmp281_;
	ValaCCodeFunctionCall* _tmp282_;
	ValaCCodeAssignment* _tmp283_;
	ValaCCodeExpression* _tmp284_;
	ValaCCodeExpression* result = NULL;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		_tmp19_ = flags;
		_tmp19__length1 = flags_length1;
		_tmp20_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp20_);
	} else {
		const gchar* _tmp21_;
		_tmp21_ = run_type;
		if (g_strcmp0 (_tmp21_, "cleanup") == 0) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
			_tmp22_ = flags;
			_tmp22__length1 = flags_length1;
			_tmp23_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		} else {
			gchar** _tmp24_;
			gint _tmp24__length1;
			gchar* _tmp25_;
			_tmp24_ = flags;
			_tmp24__length1 = flags_length1;
			_tmp25_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp25_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = flags;
		_tmp26__length1 = flags_length1;
		_tmp27_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = flags;
		_tmp28__length1 = flags_length1;
		_tmp29_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp29_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		_tmp30_ = flags;
		_tmp30__length1 = flags_length1;
		_tmp31_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		_tmp32_ = flags;
		_tmp32__length1 = flags_length1;
		_tmp33_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_version_attribute_get_deprecated (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		_tmp38_ = flags;
		_tmp38__length1 = flags_length1;
		_tmp39_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp39_);
	}
	_tmp40_ = csignew;
	_tmp41_ = flags;
	_tmp41__length1 = flags_length1;
	_tmp42_ = _vala_g_strjoinv (" | ", _tmp41_, (gint) _tmp41__length1);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_constant_new (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = vala_signal_get_default_handler (sig);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeConstant* _tmp49_;
		ValaCCodeConstant* _tmp50_;
		_tmp48_ = csignew;
		_tmp49_ = vala_ccode_constant_new ("0");
		_tmp50_ = _tmp49_;
		vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp50_);
		_vala_ccode_node_unref0 (_tmp50_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		_tmp51_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp52_);
		_tmp54_ = _tmp53_;
		_vala_ccode_node_unref0 (_tmp52_);
		struct_offset = _tmp54_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeIdentifier* _tmp61_;
			_tmp55_ = struct_offset;
			_tmp56_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("%sClass", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_identifier_new (_tmp59_);
			_tmp61_ = _tmp60_;
			vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (_tmp61_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			_tmp62_ = struct_offset;
			_tmp63_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_identifier_new (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp66_);
			_vala_ccode_node_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
		}
		_tmp67_ = struct_offset;
		_tmp68_ = vala_signal_get_default_handler (sig);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_vfunc_name (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_identifier_new (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_g_free0 (_tmp71_);
		_tmp74_ = csignew;
		_tmp75_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp76_ = csignew;
	_tmp77_ = vala_ccode_constant_new ("NULL");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = csignew;
	_tmp80_ = vala_ccode_constant_new ("NULL");
	_tmp81_ = _tmp80_;
	vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
	_vala_ccode_node_unref0 (_tmp81_);
	_tmp82_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_gsignal_module_get_marshaller_function (self, _tmp83_, _tmp85_, NULL);
	_tmp87_ = _tmp86_;
	_vala_iterable_unref0 (_tmp83_);
	marshaller = _tmp87_;
	_tmp88_ = marshaller;
	_tmp89_ = vala_ccode_identifier_new (_tmp88_);
	marshal_arg = _tmp89_;
	_tmp90_ = csignew;
	_tmp91_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp91_);
	_tmp92_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp92_;
	_tmp94_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp95_ = _tmp94_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_POINTER_TYPE)) {
		_tmp93_ = TRUE;
	} else {
		ValaDataType* _tmp96_;
		ValaDataType* _tmp97_;
		_tmp96_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp97_ = _tmp96_;
		_tmp93_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp93_) {
		ValaCCodeFunctionCall* _tmp98_;
		ValaCCodeConstant* _tmp99_;
		ValaCCodeConstant* _tmp100_;
		_tmp98_ = csignew;
		_tmp99_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp100_ = _tmp99_;
		vala_ccode_function_call_add_argument (_tmp98_, (ValaCCodeExpression*) _tmp100_);
		_vala_ccode_node_unref0 (_tmp100_);
	} else {
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		_tmp101_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp102_ = _tmp101_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeConstant* _tmp104_;
			ValaCCodeConstant* _tmp105_;
			_tmp103_ = csignew;
			_tmp104_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp105_ = _tmp104_;
			vala_ccode_function_call_add_argument (_tmp103_, (ValaCCodeExpression*) _tmp105_);
			_vala_ccode_node_unref0 (_tmp105_);
		} else {
			gboolean _tmp106_ = FALSE;
			ValaDataType* _tmp107_;
			ValaDataType* _tmp108_;
			_tmp107_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp108_ = _tmp107_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp109_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_data_type_get_nullable (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp106_ = _tmp112_;
			} else {
				_tmp106_ = FALSE;
			}
			if (_tmp106_) {
				ValaCCodeFunctionCall* _tmp113_;
				ValaCCodeConstant* _tmp114_;
				ValaCCodeConstant* _tmp115_;
				_tmp113_ = csignew;
				_tmp114_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp115_ = _tmp114_;
				vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
				_vala_ccode_node_unref0 (_tmp115_);
			} else {
				ValaDataType* _tmp116_;
				ValaDataType* _tmp117_;
				ValaTypeSymbol* _tmp118_;
				ValaTypeSymbol* _tmp119_;
				_tmp116_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_data_type_get_data_type (_tmp117_);
				_tmp119_ = _tmp118_;
				if (_tmp119_ == NULL) {
					ValaCCodeFunctionCall* _tmp120_;
					ValaCCodeConstant* _tmp121_;
					ValaCCodeConstant* _tmp122_;
					_tmp120_ = csignew;
					_tmp121_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp122_ = _tmp121_;
					vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
					_vala_ccode_node_unref0 (_tmp122_);
				} else {
					ValaCCodeFunctionCall* _tmp123_;
					ValaDataType* _tmp124_;
					ValaDataType* _tmp125_;
					ValaTypeSymbol* _tmp126_;
					ValaTypeSymbol* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					ValaCCodeConstant* _tmp130_;
					ValaCCodeConstant* _tmp131_;
					_tmp123_ = csignew;
					_tmp124_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp125_ = _tmp124_;
					_tmp126_ = vala_data_type_get_data_type (_tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = vala_ccode_constant_new (_tmp129_);
					_tmp131_ = _tmp130_;
					vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp131_);
					_vala_ccode_node_unref0 (_tmp131_);
					_g_free0 (_tmp129_);
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp132_;
		ValaList* _tmp133_;
		gint _param_size = 0;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _param_index = 0;
		_tmp132_ = params;
		_tmp133_ = _vala_iterable_ref0 (_tmp132_);
		_param_list = _tmp133_;
		_tmp134_ = _param_list;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_param_size = _tmp136_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp137_;
			gpointer _tmp138_;
			gint _tmp139_;
			ValaParameter* _tmp140_;
			ValaDataType* _tmp141_;
			ValaDataType* _tmp142_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp137_ = _param_list;
			_tmp138_ = vala_list_get (_tmp137_, _param_index);
			param = (ValaParameter*) _tmp138_;
			_tmp139_ = params_len;
			params_len = _tmp139_ + 1;
			_tmp140_ = param;
			_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
			_tmp142_ = _tmp141_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_ARRAY_TYPE)) {
				ValaParameter* _tmp143_;
				ValaDataType* _tmp144_;
				ValaDataType* _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				_tmp143_ = param;
				_tmp144_ = vala_variable_get_variable_type ((ValaVariable*) _tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp147_ = _tmp146_;
				params_len += _tmp147_;
			} else {
				ValaParameter* _tmp148_;
				ValaDataType* _tmp149_;
				ValaDataType* _tmp150_;
				_tmp148_ = param;
				_tmp149_ = vala_variable_get_variable_type ((ValaVariable*) _tmp148_);
				_tmp150_ = _tmp149_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp150_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp151_;
					ValaDataType* _tmp152_;
					ValaDataType* _tmp153_;
					ValaDelegateType* _tmp154_;
					ValaDelegate* _tmp155_;
					ValaDelegate* _tmp156_;
					gboolean _tmp157_;
					gboolean _tmp158_;
					_tmp151_ = param;
					_tmp152_ = vala_variable_get_variable_type ((ValaVariable*) _tmp151_);
					_tmp153_ = _tmp152_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp154_ = delegate_type;
					_tmp155_ = vala_delegate_type_get_delegate_symbol (_tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = vala_delegate_get_has_target (_tmp156_);
					_tmp158_ = _tmp157_;
					if (_tmp158_) {
						gint _tmp159_;
						ValaDelegateType* _tmp160_;
						_tmp159_ = params_len;
						params_len = _tmp159_ + 1;
						_tmp160_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp160_)) {
							gint _tmp161_;
							_tmp161_ = params_len;
							params_len = _tmp161_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp162_ = csignew;
	_tmp163_ = g_strdup_printf ("%d", params_len);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_constant_new (_tmp164_);
	_tmp166_ = _tmp165_;
	vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp166_);
	_vala_ccode_node_unref0 (_tmp166_);
	_g_free0 (_tmp164_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp167_;
		ValaList* _tmp168_;
		gint _param_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _param_index = 0;
		_tmp167_ = params;
		_tmp168_ = _vala_iterable_ref0 (_tmp167_);
		_param_list = _tmp168_;
		_tmp169_ = _param_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_param_size = _tmp171_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp172_;
			gpointer _tmp173_;
			ValaParameter* _tmp174_;
			ValaDataType* _tmp175_;
			ValaDataType* _tmp176_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp172_ = _param_list;
			_tmp173_ = vala_list_get (_tmp172_, _param_index);
			param = (ValaParameter*) _tmp173_;
			_tmp174_ = param;
			_tmp175_ = vala_variable_get_variable_type ((ValaVariable*) _tmp174_);
			_tmp176_ = _tmp175_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp176_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDataType* _tmp179_;
				ValaArrayType* _tmp180_;
				ValaArrayType* _tmp181_;
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				ValaTypeSymbol* _tmp184_;
				ValaTypeSymbol* _tmp185_;
				ValaDataType* _tmp186_;
				ValaTypeSymbol* _tmp187_;
				ValaTypeSymbol* _tmp188_;
				ValaArrayType* _tmp195_;
				ValaDataType* _tmp196_;
				ValaDataType* _tmp197_;
				ValaTypeSymbol* _tmp198_;
				ValaTypeSymbol* _tmp199_;
				gchar* length_type_id = NULL;
				ValaArrayType* _tmp200_;
				ValaDataType* _tmp201_;
				ValaDataType* _tmp202_;
				ValaTypeSymbol* _tmp203_;
				ValaTypeSymbol* _tmp204_;
				gchar* _tmp205_;
				_tmp177_ = param;
				_tmp178_ = vala_variable_get_variable_type ((ValaVariable*) _tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp180_;
				_tmp181_ = array_type;
				_tmp182_ = vala_array_type_get_element_type (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_data_type_get_data_type (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp187_ = vala_data_type_get_data_type (_tmp186_);
				_tmp188_ = _tmp187_;
				if (_tmp185_ == _tmp188_) {
					ValaCCodeFunctionCall* _tmp189_;
					ValaCCodeConstant* _tmp190_;
					ValaCCodeConstant* _tmp191_;
					_tmp189_ = csignew;
					_tmp190_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp191_ = _tmp190_;
					vala_ccode_function_call_add_argument (_tmp189_, (ValaCCodeExpression*) _tmp191_);
					_vala_ccode_node_unref0 (_tmp191_);
				} else {
					ValaCCodeFunctionCall* _tmp192_;
					ValaCCodeConstant* _tmp193_;
					ValaCCodeConstant* _tmp194_;
					_tmp192_ = csignew;
					_tmp193_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp194_ = _tmp193_;
					vala_ccode_function_call_add_argument (_tmp192_, (ValaCCodeExpression*) _tmp194_);
					_vala_ccode_node_unref0 (_tmp194_);
				}
				_tmp195_ = array_type;
				_tmp196_ = vala_array_type_get_length_type (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_data_type_get_data_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_vala_assert (vala_get_ccode_has_type_id (_tmp199_), "get_ccode_has_type_id (array_type.length_type.data_type)");
				_tmp200_ = array_type;
				_tmp201_ = vala_array_type_get_length_type (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_data_type_get_data_type (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp204_);
				length_type_id = _tmp205_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp206_ = FALSE;
						_tmp206_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp208_;
							gint _tmp209_;
							gint _tmp210_;
							ValaCCodeFunctionCall* _tmp211_;
							const gchar* _tmp212_;
							ValaCCodeConstant* _tmp213_;
							ValaCCodeConstant* _tmp214_;
							if (!_tmp206_) {
								gint _tmp207_;
								_tmp207_ = i;
								i = _tmp207_ + 1;
							}
							_tmp206_ = FALSE;
							_tmp208_ = array_type;
							_tmp209_ = vala_array_type_get_rank (_tmp208_);
							_tmp210_ = _tmp209_;
							if (!(i < _tmp210_)) {
								break;
							}
							_tmp211_ = csignew;
							_tmp212_ = length_type_id;
							_tmp213_ = vala_ccode_constant_new (_tmp212_);
							_tmp214_ = _tmp213_;
							vala_ccode_function_call_add_argument (_tmp211_, (ValaCCodeExpression*) _tmp214_);
							_vala_ccode_node_unref0 (_tmp214_);
						}
					}
				}
				_g_free0 (length_type_id);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp215_;
				ValaDataType* _tmp216_;
				ValaDataType* _tmp217_;
				_tmp215_ = param;
				_tmp216_ = vala_variable_get_variable_type ((ValaVariable*) _tmp215_);
				_tmp217_ = _tmp216_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaCCodeFunctionCall* _tmp221_;
					ValaCCodeConstant* _tmp222_;
					ValaCCodeConstant* _tmp223_;
					ValaDelegateType* _tmp224_;
					ValaDelegate* _tmp225_;
					ValaDelegate* _tmp226_;
					gboolean _tmp227_;
					gboolean _tmp228_;
					_tmp218_ = param;
					_tmp219_ = vala_variable_get_variable_type ((ValaVariable*) _tmp218_);
					_tmp220_ = _tmp219_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp221_ = csignew;
					_tmp222_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_add_argument (_tmp221_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_tmp224_ = delegate_type;
					_tmp225_ = vala_delegate_type_get_delegate_symbol (_tmp224_);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_delegate_get_has_target (_tmp226_);
					_tmp228_ = _tmp227_;
					if (_tmp228_) {
						ValaCCodeFunctionCall* _tmp229_;
						ValaCCodeConstant* _tmp230_;
						ValaCCodeConstant* _tmp231_;
						ValaDelegateType* _tmp232_;
						_tmp229_ = csignew;
						_tmp230_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp231_ = _tmp230_;
						vala_ccode_function_call_add_argument (_tmp229_, (ValaCCodeExpression*) _tmp231_);
						_vala_ccode_node_unref0 (_tmp231_);
						_tmp232_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp232_)) {
							ValaCCodeFunctionCall* _tmp233_;
							ValaCCodeConstant* _tmp234_;
							ValaCCodeConstant* _tmp235_;
							_tmp233_ = csignew;
							_tmp234_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp235_ = _tmp234_;
							vala_ccode_function_call_add_argument (_tmp233_, (ValaCCodeExpression*) _tmp235_);
							_vala_ccode_node_unref0 (_tmp235_);
						}
					}
				} else {
					gboolean _tmp236_ = FALSE;
					gboolean _tmp237_ = FALSE;
					ValaParameter* _tmp238_;
					ValaDataType* _tmp239_;
					ValaDataType* _tmp240_;
					_tmp238_ = param;
					_tmp239_ = vala_variable_get_variable_type ((ValaVariable*) _tmp238_);
					_tmp240_ = _tmp239_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_POINTER_TYPE)) {
						_tmp237_ = TRUE;
					} else {
						ValaParameter* _tmp241_;
						ValaDataType* _tmp242_;
						ValaDataType* _tmp243_;
						_tmp241_ = param;
						_tmp242_ = vala_variable_get_variable_type ((ValaVariable*) _tmp241_);
						_tmp243_ = _tmp242_;
						_tmp237_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp243_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp237_) {
						_tmp236_ = TRUE;
					} else {
						ValaParameter* _tmp244_;
						ValaParameterDirection _tmp245_;
						ValaParameterDirection _tmp246_;
						_tmp244_ = param;
						_tmp245_ = vala_parameter_get_direction (_tmp244_);
						_tmp246_ = _tmp245_;
						_tmp236_ = _tmp246_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp236_) {
						ValaCCodeFunctionCall* _tmp247_;
						ValaCCodeConstant* _tmp248_;
						ValaCCodeConstant* _tmp249_;
						_tmp247_ = csignew;
						_tmp248_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp249_ = _tmp248_;
						vala_ccode_function_call_add_argument (_tmp247_, (ValaCCodeExpression*) _tmp249_);
						_vala_ccode_node_unref0 (_tmp249_);
					} else {
						ValaParameter* _tmp250_;
						ValaDataType* _tmp251_;
						ValaDataType* _tmp252_;
						_tmp250_ = param;
						_tmp251_ = vala_variable_get_variable_type ((ValaVariable*) _tmp250_);
						_tmp252_ = _tmp251_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp253_;
							ValaCCodeConstant* _tmp254_;
							ValaCCodeConstant* _tmp255_;
							_tmp253_ = csignew;
							_tmp254_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp255_ = _tmp254_;
							vala_ccode_function_call_add_argument (_tmp253_, (ValaCCodeExpression*) _tmp255_);
							_vala_ccode_node_unref0 (_tmp255_);
						} else {
							gboolean _tmp256_ = FALSE;
							ValaParameter* _tmp257_;
							ValaDataType* _tmp258_;
							ValaDataType* _tmp259_;
							_tmp257_ = param;
							_tmp258_ = vala_variable_get_variable_type ((ValaVariable*) _tmp257_);
							_tmp259_ = _tmp258_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp260_;
								ValaDataType* _tmp261_;
								ValaDataType* _tmp262_;
								gboolean _tmp263_;
								gboolean _tmp264_;
								_tmp260_ = param;
								_tmp261_ = vala_variable_get_variable_type ((ValaVariable*) _tmp260_);
								_tmp262_ = _tmp261_;
								_tmp263_ = vala_data_type_get_nullable (_tmp262_);
								_tmp264_ = _tmp263_;
								_tmp256_ = _tmp264_;
							} else {
								_tmp256_ = FALSE;
							}
							if (_tmp256_) {
								ValaCCodeFunctionCall* _tmp265_;
								ValaCCodeConstant* _tmp266_;
								ValaCCodeConstant* _tmp267_;
								_tmp265_ = csignew;
								_tmp266_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp267_ = _tmp266_;
								vala_ccode_function_call_add_argument (_tmp265_, (ValaCCodeExpression*) _tmp267_);
								_vala_ccode_node_unref0 (_tmp267_);
							} else {
								ValaCCodeFunctionCall* _tmp268_;
								ValaParameter* _tmp269_;
								ValaDataType* _tmp270_;
								ValaDataType* _tmp271_;
								ValaTypeSymbol* _tmp272_;
								ValaTypeSymbol* _tmp273_;
								gchar* _tmp274_;
								gchar* _tmp275_;
								ValaCCodeConstant* _tmp276_;
								ValaCCodeConstant* _tmp277_;
								_tmp268_ = csignew;
								_tmp269_ = param;
								_tmp270_ = vala_variable_get_variable_type ((ValaVariable*) _tmp269_);
								_tmp271_ = _tmp270_;
								_tmp272_ = vala_data_type_get_data_type (_tmp271_);
								_tmp273_ = _tmp272_;
								_tmp274_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp273_);
								_tmp275_ = _tmp274_;
								_tmp276_ = vala_ccode_constant_new (_tmp275_);
								_tmp277_ = _tmp276_;
								vala_ccode_function_call_add_argument (_tmp268_, (ValaCCodeExpression*) _tmp277_);
								_vala_ccode_node_unref0 (_tmp277_);
								_g_free0 (_tmp275_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp278_ = marshal_arg;
	_tmp279_ = marshaller;
	vala_ccode_identifier_set_name (_tmp278_, _tmp279_);
	_tmp280_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp281_ = _tmp280_;
	_tmp282_ = csignew;
	_tmp283_ = vala_ccode_assignment_new (_tmp281_, (ValaCCodeExpression*) _tmp282_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp284_ = (ValaCCodeExpression*) _tmp283_;
	_vala_ccode_node_unref0 (_tmp281_);
	result = _tmp284_;
	_vala_iterable_unref0 (params);
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}

static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp19_ = FALSE;
			ValaSignal* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaCCodeFunctionCall* _tmp63_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_list_get (_tmp16_, 0);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_vala_iterable_unref0 (_tmp16_);
			detail_expr = _tmp18_;
			_tmp20_ = sig;
			_tmp21_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceFile* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSignal* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceFile* _tmp30_;
				ValaSourceFile* _tmp31_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_source_reference_get_file (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = sig;
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_reference_get_file (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp19_ = _tmp26_ == _tmp31_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeIdentifier* _tmp34_;
				ValaCCodeIdentifier* _tmp35_;
				ValaCCodeFunctionCall* _tmp36_;
				ValaCCodeFunctionCall* _tmp37_;
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaCCodeExpression* _tmp41_;
				ValaCCodeExpression* _tmp42_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaSignal* _tmp44_;
				ValaCCodeExpression* _tmp45_;
				ValaCCodeExpression* _tmp46_;
				ValaCCodeFunctionCall* _tmp47_;
				ValaCCodeExpression* _tmp48_;
				_tmp32_ = detail_expr;
				_tmp33_ = vala_gsignal_module_get_detail_cexpression (self, _tmp32_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp33_;
				_tmp34_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp36_;
				_vala_ccode_node_unref0 (_tmp35_);
				_tmp37_ = ccall;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp40_);
				_tmp42_ = _tmp41_;
				vala_ccode_function_call_add_argument (_tmp37_, _tmp42_);
				_vala_ccode_node_unref0 (_tmp42_);
				_tmp43_ = ccall;
				_tmp44_ = sig;
				_tmp45_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp44_);
				_tmp46_ = _tmp45_;
				vala_ccode_function_call_add_argument (_tmp43_, _tmp46_);
				_vala_ccode_node_unref0 (_tmp46_);
				_tmp47_ = ccall;
				_tmp48_ = detail_cexpr;
				vala_ccode_function_call_add_argument (_tmp47_, _tmp48_);
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp49_;
				ValaExpression* _tmp50_;
				ValaCCodeExpression* _tmp51_;
				ValaCCodeIdentifier* _tmp52_;
				ValaCCodeIdentifier* _tmp53_;
				ValaCCodeFunctionCall* _tmp54_;
				ValaCCodeFunctionCall* _tmp55_;
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				ValaCCodeExpression* _tmp59_;
				ValaCCodeExpression* _tmp60_;
				ValaCCodeFunctionCall* _tmp61_;
				ValaCCodeExpression* _tmp62_;
				_tmp49_ = sig;
				_tmp50_ = detail_expr;
				_tmp51_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp49_, _tmp50_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp51_;
				_tmp52_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp53_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp54_;
				_vala_ccode_node_unref0 (_tmp53_);
				_tmp55_ = ccall;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp58_);
				_tmp60_ = _tmp59_;
				vala_ccode_function_call_add_argument (_tmp55_, _tmp60_);
				_vala_ccode_node_unref0 (_tmp60_);
				_tmp61_ = ccall;
				_tmp62_ = signal_name_cexpr;
				vala_ccode_function_call_add_argument (_tmp61_, _tmp62_);
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp63_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp63_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}

static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSignal* _tmp9_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gboolean _tmp50_ = FALSE;
		ValaSignal* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp6_;
		}
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp9_;
		_tmp10_ = sig;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp13_;
		_tmp15_ = vala_member_access_get_inner (expr);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = sig;
			_tmp18_ = vala_signal_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp14_ = _tmp19_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaClass* _tmp27_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunctionCall* _tmp33_;
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaClass* _tmp36_;
			ValaClass* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeIdentifier* _tmp42_;
			ValaCCodeIdentifier* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaCCodeMemberAccess* _tmp48_;
			ValaCCodeMemberAccess* _tmp49_;
			_tmp20_ = sig;
			_tmp21_ = vala_signal_get_default_handler (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (_tmp22_);
			m = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp27_;
			_tmp28_ = base_class;
			_tmp29_ = vala_get_ccode_class_type_function (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
			_tmp34_ = _tmp33_;
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			vcast = _tmp34_;
			_tmp35_ = vcast;
			_tmp36_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strdup_printf ("%s_parent_class", _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_identifier_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_call_add_argument (_tmp35_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_tmp44_ = vcast;
			_tmp45_ = m;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp44_, _tmp47_);
			_tmp49_ = _tmp48_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp49_);
			_vala_ccode_node_unref0 (_tmp49_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp51_ = sig;
		_tmp52_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		if (!_tmp53_) {
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaSourceFile* _tmp56_;
			ValaSourceFile* _tmp57_;
			ValaSignal* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaSourceFile* _tmp61_;
			ValaSourceFile* _tmp62_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_source_reference_get_file (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = sig;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_source_reference_get_file (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp50_ = _tmp57_ == _tmp62_;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeFunctionCall* _tmp65_;
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeExpression* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaSignal* _tmp70_;
			ValaCCodeExpression* _tmp71_;
			ValaCCodeExpression* _tmp72_;
			ValaCCodeFunctionCall* _tmp73_;
			ValaCCodeConstant* _tmp74_;
			ValaCCodeConstant* _tmp75_;
			ValaCCodeFunctionCall* _tmp76_;
			_tmp63_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
			_tmp66_ = _tmp65_;
			_vala_ccode_node_unref0 (_tmp64_);
			ccall = _tmp66_;
			_tmp67_ = ccall;
			_tmp68_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp67_, _tmp68_);
			_tmp69_ = ccall;
			_tmp70_ = sig;
			_tmp71_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp70_);
			_tmp72_ = _tmp71_;
			vala_ccode_function_call_add_argument (_tmp69_, _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
			_tmp73_ = ccall;
			_tmp74_ = vala_ccode_constant_new ("0");
			_tmp75_ = _tmp74_;
			vala_ccode_function_call_add_argument (_tmp73_, (ValaCCodeExpression*) _tmp75_);
			_vala_ccode_node_unref0 (_tmp75_);
			_tmp76_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp76_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp77_;
			_tmp77_ = sig;
			if (vala_get_ccode_has_emitter (_tmp77_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp78_;
				ValaMethod* _tmp79_;
				ValaMethod* _tmp80_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp109_;
				ValaCCodeIdentifier* _tmp110_;
				ValaCCodeIdentifier* _tmp111_;
				ValaCCodeFunctionCall* _tmp112_;
				ValaCCodeFunctionCall* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeExpression* _tmp115_;
				ValaCCodeFunctionCall* _tmp116_;
				_tmp78_ = sig;
				_tmp79_ = vala_signal_get_emitter (_tmp78_);
				_tmp80_ = _tmp79_;
				if (_tmp80_ != NULL) {
					gboolean _tmp81_ = FALSE;
					ValaSignal* _tmp82_;
					gboolean _tmp83_;
					gboolean _tmp84_;
					ValaSignal* _tmp98_;
					ValaMethod* _tmp99_;
					ValaMethod* _tmp100_;
					gchar* _tmp101_;
					_tmp82_ = sig;
					_tmp83_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp82_);
					_tmp84_ = _tmp83_;
					if (!_tmp84_) {
						ValaSourceReference* _tmp85_;
						ValaSourceReference* _tmp86_;
						ValaSourceFile* _tmp87_;
						ValaSourceFile* _tmp88_;
						ValaSignal* _tmp89_;
						ValaSourceReference* _tmp90_;
						ValaSourceReference* _tmp91_;
						ValaSourceFile* _tmp92_;
						ValaSourceFile* _tmp93_;
						_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp86_ = _tmp85_;
						_tmp87_ = vala_source_reference_get_file (_tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = sig;
						_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = vala_source_reference_get_file (_tmp91_);
						_tmp93_ = _tmp92_;
						_tmp81_ = _tmp88_ != _tmp93_;
					} else {
						_tmp81_ = FALSE;
					}
					if (_tmp81_) {
						ValaSignal* _tmp94_;
						ValaMethod* _tmp95_;
						ValaMethod* _tmp96_;
						ValaCCodeFile* _tmp97_;
						_tmp94_ = sig;
						_tmp95_ = vala_signal_get_emitter (_tmp94_);
						_tmp96_ = _tmp95_;
						_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
					}
					_tmp98_ = sig;
					_tmp99_ = vala_signal_get_emitter (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp100_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp101_;
				} else {
					ValaTypeSymbol* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					ValaSignal* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					_tmp102_ = cl;
					_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
					_tmp104_ = _tmp103_;
					_tmp105_ = sig;
					_tmp106_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp105_, NULL);
					_tmp107_ = _tmp106_;
					_tmp108_ = g_strdup_printf ("%s_%s", _tmp104_, _tmp107_);
					_g_free0 (emitter_func);
					emitter_func = _tmp108_;
					_g_free0 (_tmp107_);
					_g_free0 (_tmp104_);
				}
				_tmp109_ = emitter_func;
				_tmp110_ = vala_ccode_identifier_new (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp111_);
				_tmp113_ = _tmp112_;
				_vala_ccode_node_unref0 (_tmp111_);
				ccall = _tmp113_;
				_tmp114_ = ccall;
				_tmp115_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp114_, _tmp115_);
				_tmp116_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp116_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp117_;
				ValaCCodeIdentifier* _tmp118_;
				ValaCCodeFunctionCall* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeExpression* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaSignal* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				ValaCCodeFunctionCall* _tmp127_;
				_tmp117_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp118_);
				_tmp120_ = _tmp119_;
				_vala_ccode_node_unref0 (_tmp118_);
				ccall = _tmp120_;
				_tmp121_ = ccall;
				_tmp122_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp121_, _tmp122_);
				_tmp123_ = ccall;
				_tmp124_ = sig;
				_tmp125_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp124_, NULL);
				_tmp126_ = _tmp125_;
				vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp126_);
				_vala_ccode_node_unref0 (_tmp126_);
				_tmp127_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp127_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	ValaList* _tmp24_;
	gpointer _tmp25_;
	ValaExpression* _tmp26_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMethod* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean after = FALSE;
	ValaMethodType* _tmp32_;
	ValaMethod* _tmp33_;
	ValaMethod* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaCCodeExpression* _tmp40_;
	ValaCCodeExpression* _tmp41_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_list_get (_tmp24_, 0);
	_tmp26_ = (ValaExpression*) _tmp25_;
	_vala_iterable_unref0 (_tmp24_);
	handler = _tmp26_;
	_tmp27_ = method_type;
	_tmp28_ = vala_method_type_get_method_symbol (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
	_tmp31_ = _tmp30_;
	disconnect = g_strcmp0 (_tmp31_, "disconnect") == 0;
	_tmp32_ = method_type;
	_tmp33_ = vala_method_type_get_method_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	after = g_strcmp0 (_tmp36_, "connect_after") == 0;
	_tmp37_ = sig;
	_tmp38_ = signal_access;
	_tmp39_ = handler;
	_tmp40_ = vala_gsignal_module_connect_signal (self, _tmp37_, _tmp38_, _tmp39_, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp40_;
	_tmp41_ = cexpr;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp41_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}

static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp67_;
	ValaExpression* _tmp68_;
	ValaExpression* _tmp69_;
	ValaCCodeFunctionCall* _tmp162_;
	ValaCCodeExpression* _tmp163_;
	ValaCCodeExpression* _tmp164_;
	ValaCCodeCastExpression* _tmp165_;
	ValaCCodeCastExpression* _tmp166_;
	gboolean _tmp167_ = FALSE;
	ValaMethod* _tmp168_;
	gboolean _tmp244_ = FALSE;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp26_;
				_tmp26_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp26_;
			} else {
				gchar* _tmp27_;
				_tmp27_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp27_;
			}
		} else {
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			ValaMethod* _tmp30_;
			_tmp30_ = m;
			if (_tmp30_ != NULL) {
				ValaMethod* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = m;
				_tmp32_ = vala_method_get_closure (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaDelegateType* _tmp35_;
				_tmp35_ = dt;
				if (_tmp35_ != NULL) {
					ValaDelegateType* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = dt;
					_tmp37_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp34_ = _tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp28_ = _tmp34_;
			}
			if (_tmp28_) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp39_;
			} else {
				gboolean _tmp40_ = FALSE;
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				if (_tmp41_ != NULL) {
					ValaMethod* _tmp42_;
					_tmp42_ = m;
					_tmp40_ = vala_gsignal_module_in_gobject_instance (self, _tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					if (!after) {
						gchar* _tmp44_;
						_tmp44_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp44_;
					} else {
						gchar* _tmp45_;
						_tmp45_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp45_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp46_;
			_tmp46_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp47_;
		}
	}
	_tmp48_ = connect_func;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	ccall = _tmp52_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp53_;
		ValaElementAccess* _tmp54_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp58_;
		ValaList* _tmp59_;
		ValaList* _tmp60_;
		gpointer _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaCCodeExpression* _tmp64_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_container (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp57_;
		_tmp58_ = ea;
		_tmp59_ = vala_element_access_get_indices (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_list_get (_tmp60_, 0);
		_tmp62_ = (ValaExpression*) _tmp61_;
		_vala_iterable_unref0 (_tmp60_);
		detail_expr = _tmp62_;
		_tmp63_ = detail_expr;
		_tmp64_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp63_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp64_;
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp65_;
		ValaCCodeExpression* _tmp66_;
		_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
		_tmp66_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp66_;
	}
	_tmp67_ = ma;
	_tmp68_ = vala_member_access_get_inner (_tmp67_);
	_tmp69_ = _tmp68_;
	if (_tmp69_ != NULL) {
		ValaCCodeFunctionCall* _tmp70_;
		ValaMemberAccess* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaCCodeExpression* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		_tmp70_ = ccall;
		_tmp71_ = ma;
		_tmp72_ = vala_member_access_get_inner (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp73_);
		_tmp75_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp70_, _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
	} else {
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeExpression* _tmp77_;
		ValaCCodeExpression* _tmp78_;
		_tmp76_ = ccall;
		_tmp77_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		vala_ccode_function_call_add_argument (_tmp76_, _tmp78_);
		_vala_ccode_node_unref0 (_tmp78_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		ValaCCodeConstant* _tmp84_;
		ValaCCodeConstant* _tmp85_;
		_tmp79_ = ccall;
		_tmp80_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup_printf ("\"%s\"", _tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_ccode_constant_new (_tmp83_);
		_tmp85_ = _tmp84_;
		vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp85_);
		_vala_ccode_node_unref0 (_tmp85_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp86_;
			ValaCCodeExpression* _tmp87_;
			_tmp86_ = ccall;
			_tmp87_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp86_, _tmp87_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp94_;
			ValaLocalVariable* _tmp95_;
			ValaLocalVariable* _tmp96_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeIdentifier* _tmp98_;
			ValaCCodeFunctionCall* _tmp99_;
			ValaCCodeFunctionCall* _tmp100_;
			ValaCCodeFunctionCall* _tmp101_;
			ValaCCodeExpression* _tmp102_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp103_;
			ValaSymbol* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			ValaTypeSymbol* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			ValaCCodeIdentifier* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaLocalVariable* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			ValaCCodeExpression* _tmp116_;
			ValaCCodeExpression* _tmp117_;
			ValaCCodeUnaryExpression* _tmp118_;
			ValaCCodeUnaryExpression* _tmp119_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp140_;
			ValaCCodeFunction* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			ValaCCodeFunctionCall* _tmp143_;
			ValaLocalVariable* _tmp144_;
			const gchar* _tmp145_;
			const gchar* _tmp146_;
			ValaCCodeExpression* _tmp147_;
			ValaCCodeExpression* _tmp148_;
			ValaLocalVariable* _tmp149_;
			ValaCCodeFunctionCall* _tmp159_;
			ValaCCodeConstant* _tmp160_;
			ValaCCodeConstant* _tmp161_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp88_;
				ValaCCodeConstant* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_add_argument (_tmp88_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
			} else {
				ValaCCodeFunctionCall* _tmp91_;
				ValaCCodeConstant* _tmp92_;
				ValaCCodeConstant* _tmp93_;
				_tmp91_ = ccall;
				_tmp92_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp93_ = _tmp92_;
				vala_ccode_function_call_add_argument (_tmp91_, (ValaCCodeExpression*) _tmp93_);
				_vala_ccode_node_unref0 (_tmp93_);
			}
			_tmp94_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp95_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp94_, TRUE, NULL, FALSE);
			temp_decl = _tmp95_;
			_tmp96_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp96_, FALSE);
			_tmp97_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp98_);
			_tmp100_ = _tmp99_;
			_vala_ccode_node_unref0 (_tmp98_);
			parse_call = _tmp100_;
			_tmp101_ = parse_call;
			_tmp102_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp101_, _tmp102_);
			_tmp103_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp104_ = _tmp103_;
			_tmp105_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp105_;
			_tmp106_ = parse_call;
			_tmp107_ = decl_type;
			_tmp108_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = vala_ccode_identifier_new (_tmp109_);
			_tmp111_ = _tmp110_;
			vala_ccode_function_call_add_argument (_tmp106_, (ValaCCodeExpression*) _tmp111_);
			_vala_ccode_node_unref0 (_tmp111_);
			_g_free0 (_tmp109_);
			_tmp112_ = parse_call;
			_tmp113_ = temp_decl;
			_tmp114_ = vala_symbol_get_name ((ValaSymbol*) _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp117_);
			_tmp119_ = _tmp118_;
			vala_ccode_function_call_add_argument (_tmp112_, (ValaCCodeExpression*) _tmp119_);
			_vala_ccode_node_unref0 (_tmp119_);
			_vala_ccode_node_unref0 (_tmp117_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeConstant* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaCCodeConstant* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				_tmp120_ = parse_call;
				_tmp121_ = vala_ccode_constant_new ("NULL");
				_tmp122_ = _tmp121_;
				vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
				_vala_ccode_node_unref0 (_tmp122_);
				_tmp123_ = parse_call;
				_tmp124_ = vala_ccode_constant_new ("FALSE");
				_tmp125_ = _tmp124_;
				vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp125_);
				_vala_ccode_node_unref0 (_tmp125_);
			} else {
				ValaDataType* _tmp126_;
				ValaLocalVariable* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaCCodeFunctionCall* _tmp129_;
				ValaLocalVariable* _tmp130_;
				const gchar* _tmp131_;
				const gchar* _tmp132_;
				ValaCCodeExpression* _tmp133_;
				ValaCCodeExpression* _tmp134_;
				ValaCCodeUnaryExpression* _tmp135_;
				ValaCCodeUnaryExpression* _tmp136_;
				ValaCCodeFunctionCall* _tmp137_;
				ValaCCodeConstant* _tmp138_;
				ValaCCodeConstant* _tmp139_;
				_tmp126_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp127_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp126_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp127_;
				_tmp128_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp128_, FALSE);
				_tmp129_ = parse_call;
				_tmp130_ = detail_temp_decl;
				_tmp131_ = vala_symbol_get_name ((ValaSymbol*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp134_);
				_tmp136_ = _tmp135_;
				vala_ccode_function_call_add_argument (_tmp129_, (ValaCCodeExpression*) _tmp136_);
				_vala_ccode_node_unref0 (_tmp136_);
				_vala_ccode_node_unref0 (_tmp134_);
				_tmp137_ = parse_call;
				_tmp138_ = vala_ccode_constant_new ("TRUE");
				_tmp139_ = _tmp138_;
				vala_ccode_function_call_add_argument (_tmp137_, (ValaCCodeExpression*) _tmp139_);
				_vala_ccode_node_unref0 (_tmp139_);
			}
			_tmp140_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp141_ = _tmp140_;
			_tmp142_ = parse_call;
			vala_ccode_function_add_expression (_tmp141_, (ValaCCodeExpression*) _tmp142_);
			_tmp143_ = ccall;
			_tmp144_ = temp_decl;
			_tmp145_ = vala_symbol_get_name ((ValaSymbol*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp146_);
			_tmp148_ = _tmp147_;
			vala_ccode_function_call_add_argument (_tmp143_, _tmp148_);
			_vala_ccode_node_unref0 (_tmp148_);
			_tmp149_ = detail_temp_decl;
			if (_tmp149_ == NULL) {
				ValaCCodeFunctionCall* _tmp150_;
				ValaCCodeConstant* _tmp151_;
				ValaCCodeConstant* _tmp152_;
				_tmp150_ = ccall;
				_tmp151_ = vala_ccode_constant_new ("0");
				_tmp152_ = _tmp151_;
				vala_ccode_function_call_add_argument (_tmp150_, (ValaCCodeExpression*) _tmp152_);
				_vala_ccode_node_unref0 (_tmp152_);
			} else {
				ValaCCodeFunctionCall* _tmp153_;
				ValaLocalVariable* _tmp154_;
				const gchar* _tmp155_;
				const gchar* _tmp156_;
				ValaCCodeExpression* _tmp157_;
				ValaCCodeExpression* _tmp158_;
				_tmp153_ = ccall;
				_tmp154_ = detail_temp_decl;
				_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp156_);
				_tmp158_ = _tmp157_;
				vala_ccode_function_call_add_argument (_tmp153_, _tmp158_);
				_vala_ccode_node_unref0 (_tmp158_);
			}
			_tmp159_ = ccall;
			_tmp160_ = vala_ccode_constant_new ("NULL");
			_tmp161_ = _tmp160_;
			vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp161_);
			_vala_ccode_node_unref0 (_tmp161_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp162_ = ccall;
	_tmp163_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_cast_expression_new (_tmp164_, "GCallback");
	_tmp166_ = _tmp165_;
	vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp166_);
	_vala_ccode_node_unref0 (_tmp166_);
	_vala_ccode_node_unref0 (_tmp164_);
	_tmp168_ = m;
	if (_tmp168_ != NULL) {
		ValaMethod* _tmp169_;
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp169_ = m;
		_tmp170_ = vala_method_get_closure (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp167_ = _tmp171_;
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp172_;
		ValaCCodeExpression* _tmp173_ = NULL;
		ValaCCodeExpression* _tmp174_;
		ValaCCodeExpression* _tmp175_;
		ValaCCodeFunctionCall* _tmp176_;
		ValaCCodeExpression* _tmp177_;
		ValaCCodeCastExpression* _tmp178_;
		ValaCCodeCastExpression* _tmp179_;
		_tmp172_ = ccall;
		_tmp174_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp173_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp173_;
		_tmp175_ = _tmp174_;
		vala_ccode_function_call_add_argument (_tmp172_, _tmp175_);
		_vala_ccode_node_unref0 (_tmp175_);
		_tmp176_ = ccall;
		_tmp177_ = handler_destroy_notify;
		_tmp178_ = vala_ccode_cast_expression_new (_tmp177_, "GClosureNotify");
		_tmp179_ = _tmp178_;
		vala_ccode_function_call_add_argument (_tmp176_, (ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (_tmp179_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp180_;
			ValaCCodeConstant* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			_tmp180_ = ccall;
			_tmp181_ = vala_ccode_constant_new ("0");
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp180_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
		} else {
			ValaCCodeFunctionCall* _tmp183_;
			ValaCCodeConstant* _tmp184_;
			ValaCCodeConstant* _tmp185_;
			_tmp183_ = ccall;
			_tmp184_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp185_ = _tmp184_;
			vala_ccode_function_call_add_argument (_tmp183_, (ValaCCodeExpression*) _tmp185_);
			_vala_ccode_node_unref0 (_tmp185_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp186_ = FALSE;
		ValaMethod* _tmp187_;
		_tmp187_ = m;
		if (_tmp187_ != NULL) {
			ValaMethod* _tmp188_;
			ValaMemberBinding _tmp189_;
			ValaMemberBinding _tmp190_;
			_tmp188_ = m;
			_tmp189_ = vala_method_get_binding (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp186_ = _tmp190_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp186_ = FALSE;
		}
		if (_tmp186_) {
			gboolean _tmp207_ = FALSE;
			gboolean _tmp208_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp191_;
				ValaMemberAccess* _tmp192_;
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				_tmp191_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp191_;
				_tmp192_ = right_ma;
				_tmp193_ = vala_member_access_get_inner (_tmp192_);
				_tmp194_ = _tmp193_;
				if (_tmp194_ != NULL) {
					ValaCCodeFunctionCall* _tmp195_;
					ValaMemberAccess* _tmp196_;
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaCCodeExpression* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					_tmp195_ = ccall;
					_tmp196_ = right_ma;
					_tmp197_ = vala_member_access_get_inner (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp198_);
					_tmp200_ = _tmp199_;
					vala_ccode_function_call_add_argument (_tmp195_, _tmp200_);
					_vala_ccode_node_unref0 (_tmp200_);
				} else {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeExpression* _tmp202_;
					ValaCCodeExpression* _tmp203_;
					_tmp201_ = ccall;
					_tmp202_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp204_;
					ValaCCodeExpression* _tmp205_;
					ValaCCodeExpression* _tmp206_;
					_tmp204_ = ccall;
					_tmp205_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp206_ = _tmp205_;
					vala_ccode_function_call_add_argument (_tmp204_, _tmp206_);
					_vala_ccode_node_unref0 (_tmp206_);
				}
			}
			if (!disconnect) {
				_tmp208_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				ValaMethod* _tmp209_;
				_tmp209_ = m;
				_tmp207_ = vala_gsignal_module_in_gobject_instance (self, _tmp209_);
			} else {
				_tmp207_ = FALSE;
			}
			if (_tmp207_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					_tmp210_ = ccall;
					_tmp211_ = vala_ccode_constant_new ("0");
					_tmp212_ = _tmp211_;
					vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
					_vala_ccode_node_unref0 (_tmp212_);
				} else {
					ValaCCodeFunctionCall* _tmp213_;
					ValaCCodeConstant* _tmp214_;
					ValaCCodeConstant* _tmp215_;
					_tmp213_ = ccall;
					_tmp214_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp215_ = _tmp214_;
					vala_ccode_function_call_add_argument (_tmp213_, (ValaCCodeExpression*) _tmp215_);
					_vala_ccode_node_unref0 (_tmp215_);
				}
			}
		} else {
			gboolean _tmp216_ = FALSE;
			ValaDelegateType* _tmp217_;
			_tmp217_ = dt;
			if (_tmp217_ != NULL) {
				ValaDelegateType* _tmp218_;
				ValaDelegate* _tmp219_;
				ValaDelegate* _tmp220_;
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp218_ = dt;
				_tmp219_ = vala_delegate_type_get_delegate_symbol (_tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_delegate_get_has_target (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp216_ = _tmp222_;
			} else {
				_tmp216_ = FALSE;
			}
			if (_tmp216_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp223_;
				ValaCCodeExpression* _tmp224_ = NULL;
				ValaCCodeExpression* _tmp225_;
				ValaCCodeExpression* _tmp226_;
				gboolean _tmp227_ = FALSE;
				_tmp223_ = ccall;
				_tmp225_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp224_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp224_;
				_tmp226_ = _tmp225_;
				vala_ccode_function_call_add_argument (_tmp223_, _tmp226_);
				_vala_ccode_node_unref0 (_tmp226_);
				if (!disconnect) {
					ValaDelegateType* _tmp228_;
					gboolean _tmp229_;
					gboolean _tmp230_;
					_tmp228_ = dt;
					_tmp229_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp228_);
					_tmp230_ = _tmp229_;
					_tmp227_ = _tmp230_;
				} else {
					_tmp227_ = FALSE;
				}
				if (_tmp227_) {
					ValaCCodeFunctionCall* _tmp231_;
					ValaCCodeExpression* _tmp232_;
					ValaCCodeCastExpression* _tmp233_;
					ValaCCodeCastExpression* _tmp234_;
					_tmp231_ = ccall;
					_tmp232_ = handler_destroy_notify;
					_tmp233_ = vala_ccode_cast_expression_new (_tmp232_, "GClosureNotify");
					_tmp234_ = _tmp233_;
					vala_ccode_function_call_add_argument (_tmp231_, (ValaCCodeExpression*) _tmp234_);
					_vala_ccode_node_unref0 (_tmp234_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp235_;
						ValaCCodeConstant* _tmp236_;
						ValaCCodeConstant* _tmp237_;
						_tmp235_ = ccall;
						_tmp236_ = vala_ccode_constant_new ("0");
						_tmp237_ = _tmp236_;
						vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp237_);
						_vala_ccode_node_unref0 (_tmp237_);
					} else {
						ValaCCodeFunctionCall* _tmp238_;
						ValaCCodeConstant* _tmp239_;
						ValaCCodeConstant* _tmp240_;
						_tmp238_ = ccall;
						_tmp239_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp240_ = _tmp239_;
						vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
						_vala_ccode_node_unref0 (_tmp240_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp241_;
				ValaCCodeConstant* _tmp242_;
				ValaCCodeConstant* _tmp243_;
				_tmp241_ = ccall;
				_tmp242_ = vala_ccode_constant_new ("NULL");
				_tmp243_ = _tmp242_;
				vala_ccode_function_call_add_argument (_tmp241_, (ValaCCodeExpression*) _tmp243_);
				_vala_ccode_node_unref0 (_tmp243_);
			}
		}
	}
	if (disconnect) {
		_tmp244_ = TRUE;
	} else {
		ValaCodeNode* _tmp245_;
		ValaCodeNode* _tmp246_;
		_tmp245_ = vala_code_node_get_parent_node (expr);
		_tmp246_ = _tmp245_;
		_tmp244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp246_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp244_) {
		ValaCCodeFunction* _tmp247_;
		ValaCCodeFunction* _tmp248_;
		ValaCCodeFunctionCall* _tmp249_;
		_tmp247_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp248_ = _tmp247_;
		_tmp249_ = ccall;
		vala_ccode_function_add_expression (_tmp248_, (ValaCCodeExpression*) _tmp249_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp250_;
		ValaLocalVariable* _tmp251_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp252_;
		const gchar* _tmp253_;
		const gchar* _tmp254_;
		ValaCCodeExpression* _tmp255_;
		ValaLocalVariable* _tmp256_;
		ValaCCodeFunction* _tmp257_;
		ValaCCodeFunction* _tmp258_;
		ValaCCodeExpression* _tmp259_;
		ValaCCodeFunctionCall* _tmp260_;
		_tmp250_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp251_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp250_, TRUE, NULL, FALSE);
		temp_var = _tmp251_;
		_tmp252_ = temp_var;
		_tmp253_ = vala_symbol_get_name ((ValaSymbol*) _tmp252_);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp254_);
		temp_ref = _tmp255_;
		_tmp256_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp256_, FALSE);
		_tmp257_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp258_ = _tmp257_;
		_tmp259_ = temp_ref;
		_tmp260_ = ccall;
		vala_ccode_function_add_assignment (_tmp258_, _tmp259_, (ValaCCodeExpression*) _tmp260_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}

ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}

ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}

static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass,
                                gpointer klass_data)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}

static void
vala_gsignal_module_instance_init (ValaGSignalModule * self,
                                   gpointer klass)
{
}

GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

