/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp318_ = FALSE;
	gboolean _tmp319_ = FALSE;
	ValaDataType* _tmp320_;
	ValaDataType* _tmp321_;
	ValaExpression* _tmp341_;
	ValaExpression* _tmp342_;
	gboolean _tmp343_ = FALSE;
	gboolean _tmp344_ = FALSE;
	ValaExpression* _tmp345_;
	ValaExpression* _tmp346_;
	ValaDataType* _tmp347_;
	ValaDataType* _tmp348_;
	ValaExpression* _tmp366_;
	ValaExpression* _tmp367_;
	gboolean _tmp368_ = FALSE;
	gboolean _tmp369_ = FALSE;
	ValaExpression* _tmp370_;
	ValaExpression* _tmp371_;
	ValaDataType* _tmp372_;
	ValaDataType* _tmp373_;
	gboolean _tmp391_ = FALSE;
	ValaExpression* _tmp392_;
	ValaExpression* _tmp393_;
	ValaExpression* _tmp396_;
	ValaExpression* _tmp397_;
	ValaDataType* _tmp398_;
	ValaDataType* _tmp399_;
	gboolean _tmp404_ = FALSE;
	ValaBinaryOperator _tmp405_;
	gboolean _tmp414_ = FALSE;
	ValaExpression* _tmp415_;
	ValaExpression* _tmp416_;
	ValaDataType* _tmp417_;
	ValaDataType* _tmp418_;
	gboolean _tmp435_ = FALSE;
	ValaExpression* _tmp436_;
	ValaExpression* _tmp437_;
	ValaDataType* _tmp438_;
	ValaDataType* _tmp439_;
	ValaExpression* _tmp456_;
	ValaExpression* _tmp457_;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaDataType* _tmp460_;
	ValaDataType* _tmp461_;
	ValaDataType* _tmp462_;
	ValaDataType* _tmp463_;
	ValaExpression* _tmp464_;
	ValaExpression* _tmp465_;
	ValaDataType* _tmp466_;
	ValaDataType* _tmp467_;
	ValaExpression* _tmp468_;
	ValaExpression* _tmp469_;
	ValaExpression* _tmp470_;
	ValaExpression* _tmp471_;
	ValaDataType* _tmp472_;
	ValaDataType* _tmp473_;
	ValaDataType* _tmp474_;
	ValaDataType* _tmp475_;
	ValaExpression* _tmp476_;
	ValaExpression* _tmp477_;
	ValaDataType* _tmp478_;
	ValaDataType* _tmp479_;
	gboolean _tmp480_ = FALSE;
	ValaExpression* _tmp481_;
	ValaExpression* _tmp482_;
	ValaDataType* _tmp483_;
	ValaDataType* _tmp484_;
	ValaTypeSymbol* _tmp485_;
	ValaTypeSymbol* _tmp486_;
	ValaSemanticAnalyzer* _tmp487_;
	ValaSemanticAnalyzer* _tmp488_;
	ValaDataType* _tmp489_;
	ValaTypeSymbol* _tmp490_;
	ValaTypeSymbol* _tmp491_;
	ValaDataType* _tmp1143_;
	ValaDataType* _tmp1144_;
	gboolean _tmp1145_;
	gboolean _tmp1146_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp131_ = FALSE;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ValaExpression* _tmp221_;
		ValaExpression* _tmp222_;
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaLocalVariable* _tmp225_;
		ValaLocalVariable* _tmp226_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp227_;
		ValaSourceReference* _tmp228_;
		ValaSourceReference* _tmp229_;
		ValaDeclarationStatement* _tmp230_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp231_;
		const gchar* _tmp232_;
		const gchar* _tmp233_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaSourceReference* _tmp237_;
		ValaMemberAccess* _tmp238_;
		ValaMemberAccess* _tmp239_;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		ValaAssignment* _tmp246_;
		ValaAssignment* _tmp247_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaExpressionStatement* _tmp252_;
		ValaExpressionStatement* _tmp253_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaExpressionStatement* _tmp258_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaNullLiteral* _tmp270_;
		ValaNullLiteral* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp276_;
		ValaBlock* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaIfStatement* _tmp280_;
		ValaSemanticAnalyzer* _tmp281_;
		ValaSemanticAnalyzer* _tmp282_;
		ValaBlock* _tmp283_;
		ValaDeclarationStatement* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaBlock* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaDeclarationStatement* _tmp289_;
		ValaIfStatement* _tmp290_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaExpression* _tmp294_;
		gboolean _tmp295_ = FALSE;
		ValaCodeNode* _tmp314_;
		ValaCodeNode* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		_tmp127_ = vala_binary_expression_get_left (self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp129_ = vala_binary_expression_get_right (self);
		_tmp130_ = _tmp129_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp130_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp132_ = vala_binary_expression_get_left (self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (VALA_IS_NULL_TYPE (_tmp135_)) {
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp136_ = vala_binary_expression_get_right (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_expression_get_value_type (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_ != NULL;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp140_ = vala_binary_expression_get_left (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_warning (_tmp143_, "left operand is always null");
			_tmp144_ = vala_binary_expression_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_expression_get_value_type (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp148_;
			_tmp149_ = local_type;
			vala_data_type_set_nullable (_tmp149_, TRUE);
			_tmp150_ = vala_binary_expression_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_value_type (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_nullable (_tmp153_);
			_tmp155_ = _tmp154_;
			if (!_tmp155_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp156_ = vala_binary_expression_get_left (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaDataType* _tmp168_;
				ValaDataType* _tmp169_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_tmp160_ = vala_binary_expression_get_left (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_value_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_copy (_tmp163_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp164_;
				_tmp166_ = vala_binary_expression_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_value_type (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ != NULL) {
					ValaExpression* _tmp170_;
					ValaExpression* _tmp171_;
					ValaDataType* _tmp172_;
					ValaDataType* _tmp173_;
					gboolean _tmp174_;
					gboolean _tmp175_;
					_tmp170_ = vala_binary_expression_get_right (self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_expression_get_value_type (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = vala_data_type_get_value_owned (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp165_ = _tmp175_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaDataType* _tmp176_;
					_tmp176_ = local_type;
					vala_data_type_set_value_owned (_tmp176_, TRUE);
				}
				_tmp177_ = vala_code_context_get_experimental_non_null (context);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					ValaDataType* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = local_type;
					_tmp180_ = vala_data_type_get_nullable (_tmp179_);
					_tmp181_ = _tmp180_;
					if (!_tmp181_) {
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						gboolean _tmp186_ = FALSE;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						_tmp182_ = vala_binary_expression_get_left (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
						_tmp185_ = _tmp184_;
						vala_report_warning (_tmp185_, "left operand is never null");
						_tmp187_ = vala_binary_expression_get_right (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ != NULL) {
							ValaExpression* _tmp191_;
							ValaExpression* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							gboolean _tmp195_;
							gboolean _tmp196_;
							_tmp191_ = vala_binary_expression_get_right (self);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_expression_get_value_type (_tmp192_);
							_tmp194_ = _tmp193_;
							_tmp195_ = vala_data_type_get_nullable (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp186_ = _tmp196_;
						} else {
							_tmp186_ = FALSE;
						}
						if (_tmp186_) {
							ValaDataType* _tmp197_;
							_tmp197_ = local_type;
							vala_data_type_set_nullable (_tmp197_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp198_ = FALSE;
						ValaExpression* _tmp199_;
						ValaExpression* _tmp200_;
						ValaDataType* _tmp201_;
						ValaDataType* _tmp202_;
						_tmp199_ = vala_binary_expression_get_right (self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_expression_get_value_type (_tmp200_);
						_tmp202_ = _tmp201_;
						if (_tmp202_ != NULL) {
							ValaExpression* _tmp203_;
							ValaExpression* _tmp204_;
							ValaDataType* _tmp205_;
							ValaDataType* _tmp206_;
							gboolean _tmp207_;
							gboolean _tmp208_;
							_tmp203_ = vala_binary_expression_get_right (self);
							_tmp204_ = _tmp203_;
							_tmp205_ = vala_expression_get_value_type (_tmp204_);
							_tmp206_ = _tmp205_;
							_tmp207_ = vala_data_type_get_nullable (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp198_ = !_tmp208_;
						} else {
							_tmp198_ = FALSE;
						}
						if (_tmp198_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp209_;
				ValaExpression* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				_tmp209_ = vala_binary_expression_get_right (self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_expression_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					_tmp213_ = vala_binary_expression_get_right (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_copy (_tmp216_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp217_;
				}
			}
		}
		_tmp218_ = local_type;
		_tmp219_ = vala_code_node_get_temp_name ();
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_binary_expression_get_left (self);
		_tmp222_ = _tmp221_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_local_variable_new (_tmp218_, _tmp220_, _tmp222_, _tmp224_);
		_tmp226_ = _tmp225_;
		_g_free0 (_tmp220_);
		local = _tmp226_;
		_tmp227_ = local;
		_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_declaration_statement_new ((ValaSymbol*) _tmp227_, _tmp229_);
		decl = _tmp230_;
		_tmp231_ = local;
		_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_binary_expression_get_right (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_member_access_new_simple (_tmp233_, _tmp237_);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_binary_expression_get_right (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_binary_expression_get_right (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_assignment_new ((ValaExpression*) _tmp239_, _tmp241_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_binary_expression_get_right (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_expression_statement_new ((ValaExpression*) _tmp247_, _tmp251_);
		_tmp253_ = _tmp252_;
		_vala_code_node_unref0 (_tmp247_);
		_vala_code_node_unref0 (_tmp239_);
		right_stmt = _tmp253_;
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_block_new (_tmp255_);
		true_block = _tmp256_;
		_tmp257_ = true_block;
		_tmp258_ = right_stmt;
		vala_block_add_statement (_tmp257_, (ValaStatement*) _tmp258_);
		_tmp259_ = local;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_binary_expression_get_left (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new_simple (_tmp261_, _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_null_literal_new (_tmp269_);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp267_, (ValaExpression*) _tmp271_, _tmp273_);
		_tmp275_ = _tmp274_;
		_vala_code_node_unref0 (_tmp271_);
		_vala_code_node_unref0 (_tmp267_);
		cond = _tmp275_;
		_tmp276_ = cond;
		_tmp277_ = true_block;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_if_statement_new ((ValaExpression*) _tmp276_, _tmp277_, NULL, _tmp279_);
		if_stmt = _tmp280_;
		_tmp281_ = vala_code_context_get_analyzer (context);
		_tmp282_ = _tmp281_;
		_tmp283_ = _tmp282_->insert_block;
		_tmp284_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp283_, (ValaStatement*) _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->insert_block;
		_tmp288_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp287_, (ValaStatement*) _tmp288_);
		_tmp289_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp289_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp290_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp290_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp291_ = local;
		_tmp292_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_semantic_analyzer_create_temp_access (_tmp291_, _tmp293_);
		replace_expr = _tmp294_;
		if (cast_non_null) {
			ValaExpression* _tmp296_;
			ValaDataType* _tmp297_;
			ValaDataType* _tmp298_;
			_tmp296_ = replace_expr;
			_tmp297_ = vala_expression_get_target_type (_tmp296_);
			_tmp298_ = _tmp297_;
			_tmp295_ = _tmp298_ != NULL;
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp299_;
			ValaSourceReference* _tmp300_;
			ValaSourceReference* _tmp301_;
			ValaCastExpression* _tmp302_;
			ValaCastExpression* _tmp303_;
			ValaExpression* _tmp304_;
			ValaDataType* _tmp305_;
			ValaDataType* _tmp306_;
			ValaDataType* _tmp307_;
			ValaDataType* _tmp308_;
			ValaCastExpression* _tmp309_;
			ValaDataType* _tmp310_;
			ValaDataType* _tmp311_;
			ValaCastExpression* _tmp312_;
			ValaExpression* _tmp313_;
			_tmp299_ = replace_expr;
			_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_cast_expression_new_non_null (_tmp299_, _tmp301_);
			cast = _tmp302_;
			_tmp303_ = cast;
			_tmp304_ = replace_expr;
			_tmp305_ = vala_expression_get_target_type (_tmp304_);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_data_type_copy (_tmp306_);
			_tmp308_ = _tmp307_;
			vala_expression_set_target_type ((ValaExpression*) _tmp303_, _tmp308_);
			_vala_code_node_unref0 (_tmp308_);
			_tmp309_ = cast;
			_tmp310_ = vala_expression_get_target_type ((ValaExpression*) _tmp309_);
			_tmp311_ = _tmp310_;
			vala_data_type_set_nullable (_tmp311_, FALSE);
			_tmp312_ = cast;
			_tmp313_ = _vala_code_node_ref0 ((ValaExpression*) _tmp312_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp313_;
			_vala_code_node_unref0 (cast);
		}
		_tmp314_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp315_ = _tmp314_;
		_tmp316_ = replace_expr;
		vala_code_node_replace_expression (_tmp315_, (ValaExpression*) self, _tmp316_);
		_tmp317_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp317_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		return result;
	}
	_tmp320_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp321_ = _tmp320_;
	if (_tmp321_ != NULL) {
		ValaDataType* _tmp322_;
		ValaDataType* _tmp323_;
		ValaTypeSymbol* _tmp324_;
		ValaTypeSymbol* _tmp325_;
		_tmp322_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_data_type_get_data_type (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp319_ = VALA_IS_ENUM (_tmp325_);
	} else {
		_tmp319_ = FALSE;
	}
	if (_tmp319_) {
		gboolean _tmp326_ = FALSE;
		ValaBinaryOperator _tmp327_;
		_tmp327_ = self->priv->_operator;
		if (_tmp327_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp326_ = TRUE;
		} else {
			ValaBinaryOperator _tmp328_;
			_tmp328_ = self->priv->_operator;
			_tmp326_ = _tmp328_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp318_ = _tmp326_;
	} else {
		_tmp318_ = FALSE;
	}
	if (_tmp318_) {
		ValaExpression* _tmp329_;
		ValaExpression* _tmp330_;
		ValaDataType* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaExpression* _tmp335_;
		ValaExpression* _tmp336_;
		ValaDataType* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		_tmp329_ = vala_binary_expression_get_left (self);
		_tmp330_ = _tmp329_;
		_tmp331_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp332_ = _tmp331_;
		_tmp333_ = vala_data_type_copy (_tmp332_);
		_tmp334_ = _tmp333_;
		vala_expression_set_target_type (_tmp330_, _tmp334_);
		_vala_code_node_unref0 (_tmp334_);
		_tmp335_ = vala_binary_expression_get_right (self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp338_ = _tmp337_;
		_tmp339_ = vala_data_type_copy (_tmp338_);
		_tmp340_ = _tmp339_;
		vala_expression_set_target_type (_tmp336_, _tmp340_);
		_vala_code_node_unref0 (_tmp340_);
	}
	_tmp341_ = vala_binary_expression_get_left (self);
	_tmp342_ = _tmp341_;
	vala_code_node_check ((ValaCodeNode*) _tmp342_, context);
	_tmp345_ = vala_binary_expression_get_left (self);
	_tmp346_ = _tmp345_;
	_tmp347_ = vala_expression_get_value_type (_tmp346_);
	_tmp348_ = _tmp347_;
	if (_tmp348_ != NULL) {
		ValaExpression* _tmp349_;
		ValaExpression* _tmp350_;
		ValaDataType* _tmp351_;
		ValaDataType* _tmp352_;
		ValaTypeSymbol* _tmp353_;
		ValaTypeSymbol* _tmp354_;
		_tmp349_ = vala_binary_expression_get_left (self);
		_tmp350_ = _tmp349_;
		_tmp351_ = vala_expression_get_value_type (_tmp350_);
		_tmp352_ = _tmp351_;
		_tmp353_ = vala_data_type_get_data_type (_tmp352_);
		_tmp354_ = _tmp353_;
		_tmp344_ = VALA_IS_ENUM (_tmp354_);
	} else {
		_tmp344_ = FALSE;
	}
	if (_tmp344_) {
		gboolean _tmp355_ = FALSE;
		ValaBinaryOperator _tmp356_;
		_tmp356_ = self->priv->_operator;
		if (_tmp356_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp355_ = TRUE;
		} else {
			ValaBinaryOperator _tmp357_;
			_tmp357_ = self->priv->_operator;
			_tmp355_ = _tmp357_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp343_ = _tmp355_;
	} else {
		_tmp343_ = FALSE;
	}
	if (_tmp343_) {
		ValaExpression* _tmp358_;
		ValaExpression* _tmp359_;
		ValaExpression* _tmp360_;
		ValaExpression* _tmp361_;
		ValaDataType* _tmp362_;
		ValaDataType* _tmp363_;
		ValaDataType* _tmp364_;
		ValaDataType* _tmp365_;
		_tmp358_ = vala_binary_expression_get_right (self);
		_tmp359_ = _tmp358_;
		_tmp360_ = vala_binary_expression_get_left (self);
		_tmp361_ = _tmp360_;
		_tmp362_ = vala_expression_get_value_type (_tmp361_);
		_tmp363_ = _tmp362_;
		_tmp364_ = vala_data_type_copy (_tmp363_);
		_tmp365_ = _tmp364_;
		vala_expression_set_target_type (_tmp359_, _tmp365_);
		_vala_code_node_unref0 (_tmp365_);
	}
	_tmp366_ = vala_binary_expression_get_right (self);
	_tmp367_ = _tmp366_;
	vala_code_node_check ((ValaCodeNode*) _tmp367_, context);
	_tmp370_ = vala_binary_expression_get_right (self);
	_tmp371_ = _tmp370_;
	_tmp372_ = vala_expression_get_value_type (_tmp371_);
	_tmp373_ = _tmp372_;
	if (_tmp373_ != NULL) {
		ValaExpression* _tmp374_;
		ValaExpression* _tmp375_;
		ValaDataType* _tmp376_;
		ValaDataType* _tmp377_;
		ValaTypeSymbol* _tmp378_;
		ValaTypeSymbol* _tmp379_;
		_tmp374_ = vala_binary_expression_get_right (self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_expression_get_value_type (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = vala_data_type_get_data_type (_tmp377_);
		_tmp379_ = _tmp378_;
		_tmp369_ = VALA_IS_ENUM (_tmp379_);
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		gboolean _tmp380_ = FALSE;
		ValaBinaryOperator _tmp381_;
		_tmp381_ = self->priv->_operator;
		if (_tmp381_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp380_ = TRUE;
		} else {
			ValaBinaryOperator _tmp382_;
			_tmp382_ = self->priv->_operator;
			_tmp380_ = _tmp382_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp368_ = _tmp380_;
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		ValaExpression* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		ValaDataType* _tmp390_;
		_tmp383_ = vala_binary_expression_get_left (self);
		_tmp384_ = _tmp383_;
		_tmp385_ = vala_binary_expression_get_right (self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_expression_get_value_type (_tmp386_);
		_tmp388_ = _tmp387_;
		_tmp389_ = vala_data_type_copy (_tmp388_);
		_tmp390_ = _tmp389_;
		vala_expression_set_target_type (_tmp384_, _tmp390_);
		_vala_code_node_unref0 (_tmp390_);
	}
	_tmp392_ = vala_binary_expression_get_left (self);
	_tmp393_ = _tmp392_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
		_tmp391_ = TRUE;
	} else {
		ValaExpression* _tmp394_;
		ValaExpression* _tmp395_;
		_tmp394_ = vala_binary_expression_get_right (self);
		_tmp395_ = _tmp394_;
		_tmp391_ = !vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
	}
	if (_tmp391_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp396_ = vala_binary_expression_get_left (self);
	_tmp397_ = _tmp396_;
	_tmp398_ = vala_expression_get_value_type (_tmp397_);
	_tmp399_ = _tmp398_;
	if (_tmp399_ == NULL) {
		ValaExpression* _tmp400_;
		ValaExpression* _tmp401_;
		ValaSourceReference* _tmp402_;
		ValaSourceReference* _tmp403_;
		_tmp400_ = vala_binary_expression_get_left (self);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp401_);
		_tmp403_ = _tmp402_;
		vala_report_error (_tmp403_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp405_ = self->priv->_operator;
	if (_tmp405_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp406_;
		ValaExpression* _tmp407_;
		ValaDataType* _tmp408_;
		ValaDataType* _tmp409_;
		_tmp406_ = vala_binary_expression_get_right (self);
		_tmp407_ = _tmp406_;
		_tmp408_ = vala_expression_get_value_type (_tmp407_);
		_tmp409_ = _tmp408_;
		_tmp404_ = _tmp409_ == NULL;
	} else {
		_tmp404_ = FALSE;
	}
	if (_tmp404_) {
		ValaExpression* _tmp410_;
		ValaExpression* _tmp411_;
		ValaSourceReference* _tmp412_;
		ValaSourceReference* _tmp413_;
		_tmp410_ = vala_binary_expression_get_right (self);
		_tmp411_ = _tmp410_;
		_tmp412_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp411_);
		_tmp413_ = _tmp412_;
		vala_report_error (_tmp413_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp415_ = vala_binary_expression_get_left (self);
	_tmp416_ = _tmp415_;
	_tmp417_ = vala_expression_get_value_type (_tmp416_);
	_tmp418_ = _tmp417_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp418_)) {
		_tmp414_ = TRUE;
	} else {
		ValaExpression* _tmp419_;
		ValaExpression* _tmp420_;
		ValaDataType* _tmp421_;
		ValaDataType* _tmp422_;
		_tmp419_ = vala_binary_expression_get_left (self);
		_tmp420_ = _tmp419_;
		_tmp421_ = vala_expression_get_value_type (_tmp420_);
		_tmp422_ = _tmp421_;
		_tmp414_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp422_);
	}
	if (_tmp414_) {
		ValaExpression* _tmp423_;
		ValaExpression* _tmp424_;
		ValaSourceReference* _tmp425_;
		ValaSourceReference* _tmp426_;
		ValaExpression* _tmp427_;
		ValaExpression* _tmp428_;
		ValaSymbol* _tmp429_;
		ValaSymbol* _tmp430_;
		gchar* _tmp431_;
		gchar* _tmp432_;
		gchar* _tmp433_;
		gchar* _tmp434_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp423_ = vala_binary_expression_get_left (self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp424_);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_binary_expression_get_left (self);
		_tmp428_ = _tmp427_;
		_tmp429_ = vala_expression_get_symbol_reference (_tmp428_);
		_tmp430_ = _tmp429_;
		_tmp431_ = vala_symbol_get_full_name (_tmp430_);
		_tmp432_ = _tmp431_;
		_tmp433_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp432_);
		_tmp434_ = _tmp433_;
		vala_report_error (_tmp426_, _tmp434_);
		_g_free0 (_tmp434_);
		_g_free0 (_tmp432_);
		result = FALSE;
		return result;
	}
	_tmp436_ = vala_binary_expression_get_right (self);
	_tmp437_ = _tmp436_;
	_tmp438_ = vala_expression_get_value_type (_tmp437_);
	_tmp439_ = _tmp438_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp439_)) {
		_tmp435_ = TRUE;
	} else {
		ValaExpression* _tmp440_;
		ValaExpression* _tmp441_;
		ValaDataType* _tmp442_;
		ValaDataType* _tmp443_;
		_tmp440_ = vala_binary_expression_get_right (self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_expression_get_value_type (_tmp441_);
		_tmp443_ = _tmp442_;
		_tmp435_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp443_);
	}
	if (_tmp435_) {
		ValaExpression* _tmp444_;
		ValaExpression* _tmp445_;
		ValaSourceReference* _tmp446_;
		ValaSourceReference* _tmp447_;
		ValaExpression* _tmp448_;
		ValaExpression* _tmp449_;
		ValaSymbol* _tmp450_;
		ValaSymbol* _tmp451_;
		gchar* _tmp452_;
		gchar* _tmp453_;
		gchar* _tmp454_;
		gchar* _tmp455_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp444_ = vala_binary_expression_get_right (self);
		_tmp445_ = _tmp444_;
		_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp445_);
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_binary_expression_get_right (self);
		_tmp449_ = _tmp448_;
		_tmp450_ = vala_expression_get_symbol_reference (_tmp449_);
		_tmp451_ = _tmp450_;
		_tmp452_ = vala_symbol_get_full_name (_tmp451_);
		_tmp453_ = _tmp452_;
		_tmp454_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp453_);
		_tmp455_ = _tmp454_;
		vala_report_error (_tmp447_, _tmp455_);
		_g_free0 (_tmp455_);
		_g_free0 (_tmp453_);
		result = FALSE;
		return result;
	}
	_tmp456_ = vala_binary_expression_get_left (self);
	_tmp457_ = _tmp456_;
	_tmp458_ = vala_binary_expression_get_left (self);
	_tmp459_ = _tmp458_;
	_tmp460_ = vala_expression_get_value_type (_tmp459_);
	_tmp461_ = _tmp460_;
	_tmp462_ = vala_data_type_copy (_tmp461_);
	_tmp463_ = _tmp462_;
	vala_expression_set_target_type (_tmp457_, _tmp463_);
	_vala_code_node_unref0 (_tmp463_);
	_tmp464_ = vala_binary_expression_get_left (self);
	_tmp465_ = _tmp464_;
	_tmp466_ = vala_expression_get_target_type (_tmp465_);
	_tmp467_ = _tmp466_;
	vala_data_type_set_value_owned (_tmp467_, FALSE);
	_tmp468_ = vala_binary_expression_get_right (self);
	_tmp469_ = _tmp468_;
	_tmp470_ = vala_binary_expression_get_right (self);
	_tmp471_ = _tmp470_;
	_tmp472_ = vala_expression_get_value_type (_tmp471_);
	_tmp473_ = _tmp472_;
	_tmp474_ = vala_data_type_copy (_tmp473_);
	_tmp475_ = _tmp474_;
	vala_expression_set_target_type (_tmp469_, _tmp475_);
	_vala_code_node_unref0 (_tmp475_);
	_tmp476_ = vala_binary_expression_get_right (self);
	_tmp477_ = _tmp476_;
	_tmp478_ = vala_expression_get_target_type (_tmp477_);
	_tmp479_ = _tmp478_;
	vala_data_type_set_value_owned (_tmp479_, FALSE);
	_tmp481_ = vala_binary_expression_get_left (self);
	_tmp482_ = _tmp481_;
	_tmp483_ = vala_expression_get_value_type (_tmp482_);
	_tmp484_ = _tmp483_;
	_tmp485_ = vala_data_type_get_data_type (_tmp484_);
	_tmp486_ = _tmp485_;
	_tmp487_ = vala_code_context_get_analyzer (context);
	_tmp488_ = _tmp487_;
	_tmp489_ = _tmp488_->string_type;
	_tmp490_ = vala_data_type_get_data_type (_tmp489_);
	_tmp491_ = _tmp490_;
	if (_tmp486_ == _tmp491_) {
		ValaBinaryOperator _tmp492_;
		_tmp492_ = self->priv->_operator;
		_tmp480_ = _tmp492_ == VALA_BINARY_OPERATOR_PLUS;
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		gboolean _tmp493_ = FALSE;
		ValaExpression* _tmp494_;
		ValaExpression* _tmp495_;
		ValaDataType* _tmp496_;
		ValaDataType* _tmp497_;
		ValaSemanticAnalyzer* _tmp511_;
		ValaSemanticAnalyzer* _tmp512_;
		ValaDataType* _tmp513_;
		ValaDataType* _tmp514_;
		ValaDataType* _tmp515_;
		gboolean _tmp516_ = FALSE;
		ValaExpression* _tmp517_;
		ValaExpression* _tmp518_;
		_tmp494_ = vala_binary_expression_get_right (self);
		_tmp495_ = _tmp494_;
		_tmp496_ = vala_expression_get_value_type (_tmp495_);
		_tmp497_ = _tmp496_;
		if (_tmp497_ == NULL) {
			_tmp493_ = TRUE;
		} else {
			ValaExpression* _tmp498_;
			ValaExpression* _tmp499_;
			ValaDataType* _tmp500_;
			ValaDataType* _tmp501_;
			ValaTypeSymbol* _tmp502_;
			ValaTypeSymbol* _tmp503_;
			ValaSemanticAnalyzer* _tmp504_;
			ValaSemanticAnalyzer* _tmp505_;
			ValaDataType* _tmp506_;
			ValaTypeSymbol* _tmp507_;
			ValaTypeSymbol* _tmp508_;
			_tmp498_ = vala_binary_expression_get_right (self);
			_tmp499_ = _tmp498_;
			_tmp500_ = vala_expression_get_value_type (_tmp499_);
			_tmp501_ = _tmp500_;
			_tmp502_ = vala_data_type_get_data_type (_tmp501_);
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_code_context_get_analyzer (context);
			_tmp505_ = _tmp504_;
			_tmp506_ = _tmp505_->string_type;
			_tmp507_ = vala_data_type_get_data_type (_tmp506_);
			_tmp508_ = _tmp507_;
			_tmp493_ = _tmp503_ != _tmp508_;
		}
		if (_tmp493_) {
			ValaSourceReference* _tmp509_;
			ValaSourceReference* _tmp510_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp509_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp510_ = _tmp509_;
			vala_report_error (_tmp510_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp511_ = vala_code_context_get_analyzer (context);
		_tmp512_ = _tmp511_;
		_tmp513_ = _tmp512_->string_type;
		_tmp514_ = vala_data_type_copy (_tmp513_);
		_tmp515_ = _tmp514_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp515_);
		_vala_code_node_unref0 (_tmp515_);
		_tmp517_ = vala_binary_expression_get_left (self);
		_tmp518_ = _tmp517_;
		if (vala_expression_is_constant (_tmp518_)) {
			ValaExpression* _tmp519_;
			ValaExpression* _tmp520_;
			_tmp519_ = vala_binary_expression_get_right (self);
			_tmp520_ = _tmp519_;
			_tmp516_ = vala_expression_is_constant (_tmp520_);
		} else {
			_tmp516_ = FALSE;
		}
		if (_tmp516_) {
			ValaDataType* _tmp521_;
			ValaDataType* _tmp522_;
			_tmp521_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp522_ = _tmp521_;
			vala_data_type_set_value_owned (_tmp522_, FALSE);
		} else {
			ValaDataType* _tmp523_;
			ValaDataType* _tmp524_;
			_tmp523_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp524_ = _tmp523_;
			vala_data_type_set_value_owned (_tmp524_, TRUE);
		}
	} else {
		gboolean _tmp525_ = FALSE;
		ValaExpression* _tmp526_;
		ValaExpression* _tmp527_;
		ValaDataType* _tmp528_;
		ValaDataType* _tmp529_;
		_tmp526_ = vala_binary_expression_get_left (self);
		_tmp527_ = _tmp526_;
		_tmp528_ = vala_expression_get_value_type (_tmp527_);
		_tmp529_ = _tmp528_;
		if (VALA_IS_ARRAY_TYPE (_tmp529_)) {
			ValaBinaryOperator _tmp530_;
			_tmp530_ = self->priv->_operator;
			_tmp525_ = _tmp530_ == VALA_BINARY_OPERATOR_PLUS;
		} else {
			_tmp525_ = FALSE;
		}
		if (_tmp525_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp531_;
			ValaExpression* _tmp532_;
			ValaDataType* _tmp533_;
			ValaDataType* _tmp534_;
			ValaArrayType* _tmp535_;
			ValaArrayType* _tmp536_;
			gboolean _tmp537_;
			gboolean _tmp538_;
			gboolean _tmp541_ = FALSE;
			ValaExpression* _tmp542_;
			ValaExpression* _tmp543_;
			ValaDataType* _tmp544_;
			ValaDataType* _tmp545_;
			ValaExpression* _tmp555_;
			ValaExpression* _tmp556_;
			ValaArrayType* _tmp557_;
			ValaDataType* _tmp558_;
			ValaDataType* _tmp559_;
			ValaDataType* _tmp560_;
			ValaDataType* _tmp561_;
			ValaArrayType* _tmp562_;
			ValaDataType* _tmp563_;
			ValaDataType* _tmp564_;
			ValaDataType* _tmp565_;
			ValaDataType* _tmp566_;
			_tmp531_ = vala_binary_expression_get_left (self);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_expression_get_value_type (_tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp534_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp535_;
			_tmp536_ = array_type;
			_tmp537_ = vala_array_type_get_inline_allocated (_tmp536_);
			_tmp538_ = _tmp537_;
			if (_tmp538_) {
				ValaSourceReference* _tmp539_;
				ValaSourceReference* _tmp540_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp540_ = _tmp539_;
				vala_report_error (_tmp540_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp542_ = vala_binary_expression_get_right (self);
			_tmp543_ = _tmp542_;
			_tmp544_ = vala_expression_get_value_type (_tmp543_);
			_tmp545_ = _tmp544_;
			if (_tmp545_ == NULL) {
				_tmp541_ = TRUE;
			} else {
				ValaExpression* _tmp546_;
				ValaExpression* _tmp547_;
				ValaDataType* _tmp548_;
				ValaDataType* _tmp549_;
				ValaArrayType* _tmp550_;
				ValaDataType* _tmp551_;
				ValaDataType* _tmp552_;
				_tmp546_ = vala_binary_expression_get_right (self);
				_tmp547_ = _tmp546_;
				_tmp548_ = vala_expression_get_value_type (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = array_type;
				_tmp551_ = vala_array_type_get_element_type (_tmp550_);
				_tmp552_ = _tmp551_;
				_tmp541_ = !vala_data_type_compatible (_tmp549_, _tmp552_);
			}
			if (_tmp541_) {
				ValaSourceReference* _tmp553_;
				ValaSourceReference* _tmp554_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp554_ = _tmp553_;
				vala_report_error (_tmp554_, "Incompatible operand");
				result = FALSE;
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp555_ = vala_binary_expression_get_right (self);
			_tmp556_ = _tmp555_;
			_tmp557_ = array_type;
			_tmp558_ = vala_array_type_get_element_type (_tmp557_);
			_tmp559_ = _tmp558_;
			_tmp560_ = vala_data_type_copy (_tmp559_);
			_tmp561_ = _tmp560_;
			vala_expression_set_target_type (_tmp556_, _tmp561_);
			_vala_code_node_unref0 (_tmp561_);
			_tmp562_ = array_type;
			_tmp563_ = vala_data_type_copy ((ValaDataType*) _tmp562_);
			_tmp564_ = _tmp563_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp564_);
			_vala_code_node_unref0 (_tmp564_);
			_tmp565_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp566_ = _tmp565_;
			vala_data_type_set_value_owned (_tmp566_, TRUE);
			_vala_code_node_unref0 (array_type);
		} else {
			gboolean _tmp567_ = FALSE;
			gboolean _tmp568_ = FALSE;
			gboolean _tmp569_ = FALSE;
			ValaBinaryOperator _tmp570_;
			_tmp570_ = self->priv->_operator;
			if (_tmp570_ == VALA_BINARY_OPERATOR_PLUS) {
				_tmp569_ = TRUE;
			} else {
				ValaBinaryOperator _tmp571_;
				_tmp571_ = self->priv->_operator;
				_tmp569_ = _tmp571_ == VALA_BINARY_OPERATOR_MINUS;
			}
			if (_tmp569_) {
				_tmp568_ = TRUE;
			} else {
				ValaBinaryOperator _tmp572_;
				_tmp572_ = self->priv->_operator;
				_tmp568_ = _tmp572_ == VALA_BINARY_OPERATOR_MUL;
			}
			if (_tmp568_) {
				_tmp567_ = TRUE;
			} else {
				ValaBinaryOperator _tmp573_;
				_tmp573_ = self->priv->_operator;
				_tmp567_ = _tmp573_ == VALA_BINARY_OPERATOR_DIV;
			}
			if (_tmp567_) {
				ValaExpression* _tmp574_;
				ValaExpression* _tmp575_;
				ValaDataType* _tmp576_;
				ValaDataType* _tmp577_;
				ValaDataType* _tmp622_;
				ValaDataType* _tmp623_;
				ValaDataType* _tmp636_;
				ValaDataType* _tmp637_;
				_tmp574_ = vala_binary_expression_get_left (self);
				_tmp575_ = _tmp574_;
				_tmp576_ = vala_expression_get_value_type (_tmp575_);
				_tmp577_ = _tmp576_;
				if (VALA_IS_POINTER_TYPE (_tmp577_)) {
					ValaPointerType* pointer_type = NULL;
					ValaExpression* _tmp578_;
					ValaExpression* _tmp579_;
					ValaDataType* _tmp580_;
					ValaDataType* _tmp581_;
					ValaPointerType* _tmp582_;
					ValaPointerType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaStruct* offset_type = NULL;
					ValaExpression* _tmp588_;
					ValaExpression* _tmp589_;
					ValaDataType* _tmp590_;
					ValaDataType* _tmp591_;
					ValaTypeSymbol* _tmp592_;
					ValaTypeSymbol* _tmp593_;
					ValaStruct* _tmp594_;
					gboolean _tmp595_ = FALSE;
					ValaStruct* _tmp596_;
					_tmp578_ = vala_binary_expression_get_left (self);
					_tmp579_ = _tmp578_;
					_tmp580_ = vala_expression_get_value_type (_tmp579_);
					_tmp581_ = _tmp580_;
					_tmp582_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					pointer_type = _tmp582_;
					_tmp583_ = pointer_type;
					_tmp584_ = vala_pointer_type_get_base_type (_tmp583_);
					_tmp585_ = _tmp584_;
					if (VALA_IS_VOID_TYPE (_tmp585_)) {
						ValaSourceReference* _tmp586_;
						ValaSourceReference* _tmp587_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp587_ = _tmp586_;
						vala_report_error (_tmp587_, "Pointer arithmetic not supported for `void*'");
						result = FALSE;
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_tmp588_ = vala_binary_expression_get_right (self);
					_tmp589_ = _tmp588_;
					_tmp590_ = vala_expression_get_value_type (_tmp589_);
					_tmp591_ = _tmp590_;
					_tmp592_ = vala_data_type_get_data_type (_tmp591_);
					_tmp593_ = _tmp592_;
					_tmp594_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp593_) ? ((ValaStruct*) _tmp593_) : NULL);
					offset_type = _tmp594_;
					_tmp596_ = offset_type;
					if (_tmp596_ != NULL) {
						ValaStruct* _tmp597_;
						_tmp597_ = offset_type;
						_tmp595_ = vala_struct_is_integer_type (_tmp597_);
					} else {
						_tmp595_ = FALSE;
					}
					if (_tmp595_) {
						gboolean _tmp598_ = FALSE;
						ValaBinaryOperator _tmp599_;
						_tmp599_ = self->priv->_operator;
						if (_tmp599_ == VALA_BINARY_OPERATOR_PLUS) {
							_tmp598_ = TRUE;
						} else {
							ValaBinaryOperator _tmp600_;
							_tmp600_ = self->priv->_operator;
							_tmp598_ = _tmp600_ == VALA_BINARY_OPERATOR_MINUS;
						}
						if (_tmp598_) {
							ValaExpression* _tmp601_;
							ValaExpression* _tmp602_;
							ValaDataType* _tmp603_;
							ValaDataType* _tmp604_;
							ValaDataType* _tmp605_;
							ValaDataType* _tmp606_;
							_tmp601_ = vala_binary_expression_get_left (self);
							_tmp602_ = _tmp601_;
							_tmp603_ = vala_expression_get_value_type (_tmp602_);
							_tmp604_ = _tmp603_;
							_tmp605_ = vala_data_type_copy (_tmp604_);
							_tmp606_ = _tmp605_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp606_);
							_vala_code_node_unref0 (_tmp606_);
						}
					} else {
						ValaExpression* _tmp607_;
						ValaExpression* _tmp608_;
						ValaDataType* _tmp609_;
						ValaDataType* _tmp610_;
						_tmp607_ = vala_binary_expression_get_right (self);
						_tmp608_ = _tmp607_;
						_tmp609_ = vala_expression_get_value_type (_tmp608_);
						_tmp610_ = _tmp609_;
						if (VALA_IS_POINTER_TYPE (_tmp610_)) {
							ValaSemanticAnalyzer* _tmp611_;
							ValaSemanticAnalyzer* _tmp612_;
							ValaDataType* _tmp613_;
							_tmp611_ = vala_code_context_get_analyzer (context);
							_tmp612_ = _tmp611_;
							_tmp613_ = _tmp612_->size_t_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp613_);
						}
					}
					_vala_code_node_unref0 (offset_type);
					_vala_code_node_unref0 (pointer_type);
				} else {
					ValaExpression* _tmp614_;
					ValaExpression* _tmp615_;
					ValaDataType* _tmp616_;
					ValaDataType* _tmp617_;
					ValaExpression* _tmp618_;
					ValaExpression* _tmp619_;
					ValaDataType* _tmp620_;
					ValaDataType* _tmp621_;
					_tmp614_ = vala_binary_expression_get_left (self);
					_tmp615_ = _tmp614_;
					_tmp616_ = vala_expression_get_target_type (_tmp615_);
					_tmp617_ = _tmp616_;
					vala_data_type_set_nullable (_tmp617_, FALSE);
					_tmp618_ = vala_binary_expression_get_right (self);
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_expression_get_target_type (_tmp619_);
					_tmp621_ = _tmp620_;
					vala_data_type_set_nullable (_tmp621_, FALSE);
				}
				_tmp622_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp623_ = _tmp622_;
				if (_tmp623_ == NULL) {
					ValaSemanticAnalyzer* _tmp624_;
					ValaSemanticAnalyzer* _tmp625_;
					ValaExpression* _tmp626_;
					ValaExpression* _tmp627_;
					ValaDataType* _tmp628_;
					ValaDataType* _tmp629_;
					ValaExpression* _tmp630_;
					ValaExpression* _tmp631_;
					ValaDataType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					ValaDataType* _tmp635_;
					_tmp624_ = vala_code_context_get_analyzer (context);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_binary_expression_get_left (self);
					_tmp627_ = _tmp626_;
					_tmp628_ = vala_expression_get_target_type (_tmp627_);
					_tmp629_ = _tmp628_;
					_tmp630_ = vala_binary_expression_get_right (self);
					_tmp631_ = _tmp630_;
					_tmp632_ = vala_expression_get_target_type (_tmp631_);
					_tmp633_ = _tmp632_;
					_tmp634_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp625_, _tmp629_, _tmp633_);
					_tmp635_ = _tmp634_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp635_);
					_vala_code_node_unref0 (_tmp635_);
				}
				_tmp636_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp637_ = _tmp636_;
				if (_tmp637_ == NULL) {
					ValaSourceReference* _tmp638_;
					ValaSourceReference* _tmp639_;
					ValaExpression* _tmp640_;
					ValaExpression* _tmp641_;
					ValaDataType* _tmp642_;
					ValaDataType* _tmp643_;
					gchar* _tmp644_;
					gchar* _tmp645_;
					ValaExpression* _tmp646_;
					ValaExpression* _tmp647_;
					ValaDataType* _tmp648_;
					ValaDataType* _tmp649_;
					gchar* _tmp650_;
					gchar* _tmp651_;
					gchar* _tmp652_;
					gchar* _tmp653_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp638_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp639_ = _tmp638_;
					_tmp640_ = vala_binary_expression_get_left (self);
					_tmp641_ = _tmp640_;
					_tmp642_ = vala_expression_get_value_type (_tmp641_);
					_tmp643_ = _tmp642_;
					_tmp644_ = vala_code_node_to_string ((ValaCodeNode*) _tmp643_);
					_tmp645_ = _tmp644_;
					_tmp646_ = vala_binary_expression_get_right (self);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_expression_get_value_type (_tmp647_);
					_tmp649_ = _tmp648_;
					_tmp650_ = vala_code_node_to_string ((ValaCodeNode*) _tmp649_);
					_tmp651_ = _tmp650_;
					_tmp652_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp645_, _tmp651_);
					_tmp653_ = _tmp652_;
					vala_report_error (_tmp639_, _tmp653_);
					_g_free0 (_tmp653_);
					_g_free0 (_tmp651_);
					_g_free0 (_tmp645_);
					result = FALSE;
					return result;
				}
			} else {
				gboolean _tmp654_ = FALSE;
				gboolean _tmp655_ = FALSE;
				ValaBinaryOperator _tmp656_;
				_tmp656_ = self->priv->_operator;
				if (_tmp656_ == VALA_BINARY_OPERATOR_MOD) {
					_tmp655_ = TRUE;
				} else {
					ValaBinaryOperator _tmp657_;
					_tmp657_ = self->priv->_operator;
					_tmp655_ = _tmp657_ == VALA_BINARY_OPERATOR_SHIFT_LEFT;
				}
				if (_tmp655_) {
					_tmp654_ = TRUE;
				} else {
					ValaBinaryOperator _tmp658_;
					_tmp658_ = self->priv->_operator;
					_tmp654_ = _tmp658_ == VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				}
				if (_tmp654_) {
					ValaExpression* _tmp659_;
					ValaExpression* _tmp660_;
					ValaDataType* _tmp661_;
					ValaDataType* _tmp662_;
					ValaExpression* _tmp663_;
					ValaExpression* _tmp664_;
					ValaDataType* _tmp665_;
					ValaDataType* _tmp666_;
					ValaSemanticAnalyzer* _tmp667_;
					ValaSemanticAnalyzer* _tmp668_;
					ValaExpression* _tmp669_;
					ValaExpression* _tmp670_;
					ValaDataType* _tmp671_;
					ValaDataType* _tmp672_;
					ValaExpression* _tmp673_;
					ValaExpression* _tmp674_;
					ValaDataType* _tmp675_;
					ValaDataType* _tmp676_;
					ValaDataType* _tmp677_;
					ValaDataType* _tmp678_;
					ValaDataType* _tmp679_;
					ValaDataType* _tmp680_;
					_tmp659_ = vala_binary_expression_get_left (self);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_expression_get_target_type (_tmp660_);
					_tmp662_ = _tmp661_;
					vala_data_type_set_nullable (_tmp662_, FALSE);
					_tmp663_ = vala_binary_expression_get_right (self);
					_tmp664_ = _tmp663_;
					_tmp665_ = vala_expression_get_target_type (_tmp664_);
					_tmp666_ = _tmp665_;
					vala_data_type_set_nullable (_tmp666_, FALSE);
					_tmp667_ = vala_code_context_get_analyzer (context);
					_tmp668_ = _tmp667_;
					_tmp669_ = vala_binary_expression_get_left (self);
					_tmp670_ = _tmp669_;
					_tmp671_ = vala_expression_get_target_type (_tmp670_);
					_tmp672_ = _tmp671_;
					_tmp673_ = vala_binary_expression_get_right (self);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_expression_get_target_type (_tmp674_);
					_tmp676_ = _tmp675_;
					_tmp677_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp668_, _tmp672_, _tmp676_);
					_tmp678_ = _tmp677_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp678_);
					_vala_code_node_unref0 (_tmp678_);
					_tmp679_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp680_ = _tmp679_;
					if (_tmp680_ == NULL) {
						ValaSourceReference* _tmp681_;
						ValaSourceReference* _tmp682_;
						ValaExpression* _tmp683_;
						ValaExpression* _tmp684_;
						ValaDataType* _tmp685_;
						ValaDataType* _tmp686_;
						gchar* _tmp687_;
						gchar* _tmp688_;
						ValaExpression* _tmp689_;
						ValaExpression* _tmp690_;
						ValaDataType* _tmp691_;
						ValaDataType* _tmp692_;
						gchar* _tmp693_;
						gchar* _tmp694_;
						gchar* _tmp695_;
						gchar* _tmp696_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp681_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp682_ = _tmp681_;
						_tmp683_ = vala_binary_expression_get_left (self);
						_tmp684_ = _tmp683_;
						_tmp685_ = vala_expression_get_value_type (_tmp684_);
						_tmp686_ = _tmp685_;
						_tmp687_ = vala_code_node_to_string ((ValaCodeNode*) _tmp686_);
						_tmp688_ = _tmp687_;
						_tmp689_ = vala_binary_expression_get_right (self);
						_tmp690_ = _tmp689_;
						_tmp691_ = vala_expression_get_value_type (_tmp690_);
						_tmp692_ = _tmp691_;
						_tmp693_ = vala_code_node_to_string ((ValaCodeNode*) _tmp692_);
						_tmp694_ = _tmp693_;
						_tmp695_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp688_, _tmp694_);
						_tmp696_ = _tmp695_;
						vala_report_error (_tmp682_, _tmp696_);
						_g_free0 (_tmp696_);
						_g_free0 (_tmp694_);
						_g_free0 (_tmp688_);
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp697_ = FALSE;
					gboolean _tmp698_ = FALSE;
					gboolean _tmp699_ = FALSE;
					ValaBinaryOperator _tmp700_;
					_tmp700_ = self->priv->_operator;
					if (_tmp700_ == VALA_BINARY_OPERATOR_LESS_THAN) {
						_tmp699_ = TRUE;
					} else {
						ValaBinaryOperator _tmp701_;
						_tmp701_ = self->priv->_operator;
						_tmp699_ = _tmp701_ == VALA_BINARY_OPERATOR_GREATER_THAN;
					}
					if (_tmp699_) {
						_tmp698_ = TRUE;
					} else {
						ValaBinaryOperator _tmp702_;
						_tmp702_ = self->priv->_operator;
						_tmp698_ = _tmp702_ == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
					}
					if (_tmp698_) {
						_tmp697_ = TRUE;
					} else {
						ValaBinaryOperator _tmp703_;
						_tmp703_ = self->priv->_operator;
						_tmp697_ = _tmp703_ == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
					}
					if (_tmp697_) {
						gboolean _tmp704_ = FALSE;
						ValaExpression* _tmp705_;
						ValaExpression* _tmp706_;
						ValaDataType* _tmp707_;
						ValaDataType* _tmp708_;
						ValaSemanticAnalyzer* _tmp709_;
						ValaSemanticAnalyzer* _tmp710_;
						ValaDataType* _tmp711_;
						ValaSemanticAnalyzer* _tmp791_;
						ValaSemanticAnalyzer* _tmp792_;
						ValaDataType* _tmp793_;
						_tmp705_ = vala_binary_expression_get_left (self);
						_tmp706_ = _tmp705_;
						_tmp707_ = vala_expression_get_value_type (_tmp706_);
						_tmp708_ = _tmp707_;
						_tmp709_ = vala_code_context_get_analyzer (context);
						_tmp710_ = _tmp709_;
						_tmp711_ = _tmp710_->string_type;
						if (vala_data_type_compatible (_tmp708_, _tmp711_)) {
							ValaExpression* _tmp712_;
							ValaExpression* _tmp713_;
							ValaDataType* _tmp714_;
							ValaDataType* _tmp715_;
							ValaSemanticAnalyzer* _tmp716_;
							ValaSemanticAnalyzer* _tmp717_;
							ValaDataType* _tmp718_;
							_tmp712_ = vala_binary_expression_get_right (self);
							_tmp713_ = _tmp712_;
							_tmp714_ = vala_expression_get_value_type (_tmp713_);
							_tmp715_ = _tmp714_;
							_tmp716_ = vala_code_context_get_analyzer (context);
							_tmp717_ = _tmp716_;
							_tmp718_ = _tmp717_->string_type;
							_tmp704_ = vala_data_type_compatible (_tmp715_, _tmp718_);
						} else {
							_tmp704_ = FALSE;
						}
						if (_tmp704_) {
						} else {
							gboolean _tmp719_ = FALSE;
							ValaExpression* _tmp720_;
							ValaExpression* _tmp721_;
							ValaDataType* _tmp722_;
							ValaDataType* _tmp723_;
							_tmp720_ = vala_binary_expression_get_left (self);
							_tmp721_ = _tmp720_;
							_tmp722_ = vala_expression_get_value_type (_tmp721_);
							_tmp723_ = _tmp722_;
							if (VALA_IS_POINTER_TYPE (_tmp723_)) {
								ValaExpression* _tmp724_;
								ValaExpression* _tmp725_;
								ValaDataType* _tmp726_;
								ValaDataType* _tmp727_;
								_tmp724_ = vala_binary_expression_get_right (self);
								_tmp725_ = _tmp724_;
								_tmp726_ = vala_expression_get_value_type (_tmp725_);
								_tmp727_ = _tmp726_;
								_tmp719_ = VALA_IS_POINTER_TYPE (_tmp727_);
							} else {
								_tmp719_ = FALSE;
							}
							if (_tmp719_) {
							} else {
								ValaDataType* resulting_type = NULL;
								gboolean _tmp728_;
								ValaDataType* _tmp755_;
								gboolean _tmp772_;
								ValaExpression* _tmp778_;
								ValaExpression* _tmp779_;
								ValaDataType* _tmp780_;
								ValaDataType* _tmp781_;
								ValaDataType* _tmp782_;
								ValaExpression* _tmp783_;
								ValaExpression* _tmp784_;
								ValaDataType* _tmp785_;
								ValaDataType* _tmp786_;
								ValaExpression* _tmp787_;
								ValaExpression* _tmp788_;
								ValaDataType* _tmp789_;
								ValaDataType* _tmp790_;
								_tmp728_ = self->priv->_is_chained;
								if (_tmp728_) {
									ValaBinaryExpression* lbe = NULL;
									ValaExpression* _tmp729_;
									ValaExpression* _tmp730_;
									ValaBinaryExpression* _tmp731_;
									ValaSemanticAnalyzer* _tmp732_;
									ValaSemanticAnalyzer* _tmp733_;
									ValaBinaryExpression* _tmp734_;
									ValaExpression* _tmp735_;
									ValaExpression* _tmp736_;
									ValaDataType* _tmp737_;
									ValaDataType* _tmp738_;
									ValaExpression* _tmp739_;
									ValaExpression* _tmp740_;
									ValaDataType* _tmp741_;
									ValaDataType* _tmp742_;
									ValaDataType* _tmp743_;
									_tmp729_ = vala_binary_expression_get_left (self);
									_tmp730_ = _tmp729_;
									_tmp731_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp730_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
									lbe = _tmp731_;
									_tmp732_ = vala_code_context_get_analyzer (context);
									_tmp733_ = _tmp732_;
									_tmp734_ = lbe;
									_tmp735_ = vala_binary_expression_get_right (_tmp734_);
									_tmp736_ = _tmp735_;
									_tmp737_ = vala_expression_get_target_type (_tmp736_);
									_tmp738_ = _tmp737_;
									_tmp739_ = vala_binary_expression_get_right (self);
									_tmp740_ = _tmp739_;
									_tmp741_ = vala_expression_get_target_type (_tmp740_);
									_tmp742_ = _tmp741_;
									_tmp743_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp733_, _tmp738_, _tmp742_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp743_;
									_vala_code_node_unref0 (lbe);
								} else {
									ValaSemanticAnalyzer* _tmp744_;
									ValaSemanticAnalyzer* _tmp745_;
									ValaExpression* _tmp746_;
									ValaExpression* _tmp747_;
									ValaDataType* _tmp748_;
									ValaDataType* _tmp749_;
									ValaExpression* _tmp750_;
									ValaExpression* _tmp751_;
									ValaDataType* _tmp752_;
									ValaDataType* _tmp753_;
									ValaDataType* _tmp754_;
									_tmp744_ = vala_code_context_get_analyzer (context);
									_tmp745_ = _tmp744_;
									_tmp746_ = vala_binary_expression_get_left (self);
									_tmp747_ = _tmp746_;
									_tmp748_ = vala_expression_get_target_type (_tmp747_);
									_tmp749_ = _tmp748_;
									_tmp750_ = vala_binary_expression_get_right (self);
									_tmp751_ = _tmp750_;
									_tmp752_ = vala_expression_get_target_type (_tmp751_);
									_tmp753_ = _tmp752_;
									_tmp754_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp745_, _tmp749_, _tmp753_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp754_;
								}
								_tmp755_ = resulting_type;
								if (_tmp755_ == NULL) {
									ValaSourceReference* _tmp756_;
									ValaSourceReference* _tmp757_;
									ValaExpression* _tmp758_;
									ValaExpression* _tmp759_;
									ValaDataType* _tmp760_;
									ValaDataType* _tmp761_;
									gchar* _tmp762_;
									gchar* _tmp763_;
									ValaExpression* _tmp764_;
									ValaExpression* _tmp765_;
									ValaDataType* _tmp766_;
									ValaDataType* _tmp767_;
									gchar* _tmp768_;
									gchar* _tmp769_;
									gchar* _tmp770_;
									gchar* _tmp771_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp756_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp757_ = _tmp756_;
									_tmp758_ = vala_binary_expression_get_left (self);
									_tmp759_ = _tmp758_;
									_tmp760_ = vala_expression_get_value_type (_tmp759_);
									_tmp761_ = _tmp760_;
									_tmp762_ = vala_code_node_to_string ((ValaCodeNode*) _tmp761_);
									_tmp763_ = _tmp762_;
									_tmp764_ = vala_binary_expression_get_right (self);
									_tmp765_ = _tmp764_;
									_tmp766_ = vala_expression_get_value_type (_tmp765_);
									_tmp767_ = _tmp766_;
									_tmp768_ = vala_code_node_to_string ((ValaCodeNode*) _tmp767_);
									_tmp769_ = _tmp768_;
									_tmp770_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp763_, _tmp769_);
									_tmp771_ = _tmp770_;
									vala_report_error (_tmp757_, _tmp771_);
									_g_free0 (_tmp771_);
									_g_free0 (_tmp769_);
									_g_free0 (_tmp763_);
									result = FALSE;
									_vala_code_node_unref0 (resulting_type);
									return result;
								}
								_tmp772_ = self->priv->_is_chained;
								if (!_tmp772_) {
									ValaExpression* _tmp773_;
									ValaExpression* _tmp774_;
									ValaDataType* _tmp775_;
									ValaDataType* _tmp776_;
									ValaDataType* _tmp777_;
									_tmp773_ = vala_binary_expression_get_left (self);
									_tmp774_ = _tmp773_;
									_tmp775_ = resulting_type;
									_tmp776_ = vala_data_type_copy (_tmp775_);
									_tmp777_ = _tmp776_;
									vala_expression_set_target_type (_tmp774_, _tmp777_);
									_vala_code_node_unref0 (_tmp777_);
								}
								_tmp778_ = vala_binary_expression_get_right (self);
								_tmp779_ = _tmp778_;
								_tmp780_ = resulting_type;
								_tmp781_ = vala_data_type_copy (_tmp780_);
								_tmp782_ = _tmp781_;
								vala_expression_set_target_type (_tmp779_, _tmp782_);
								_vala_code_node_unref0 (_tmp782_);
								_tmp783_ = vala_binary_expression_get_left (self);
								_tmp784_ = _tmp783_;
								_tmp785_ = vala_expression_get_target_type (_tmp784_);
								_tmp786_ = _tmp785_;
								vala_data_type_set_nullable (_tmp786_, FALSE);
								_tmp787_ = vala_binary_expression_get_right (self);
								_tmp788_ = _tmp787_;
								_tmp789_ = vala_expression_get_target_type (_tmp788_);
								_tmp790_ = _tmp789_;
								vala_data_type_set_nullable (_tmp790_, FALSE);
								_vala_code_node_unref0 (resulting_type);
							}
						}
						_tmp791_ = vala_code_context_get_analyzer (context);
						_tmp792_ = _tmp791_;
						_tmp793_ = _tmp792_->bool_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp793_);
					} else {
						gboolean _tmp794_ = FALSE;
						ValaBinaryOperator _tmp795_;
						_tmp795_ = self->priv->_operator;
						if (_tmp795_ == VALA_BINARY_OPERATOR_EQUALITY) {
							_tmp794_ = TRUE;
						} else {
							ValaBinaryOperator _tmp796_;
							_tmp796_ = self->priv->_operator;
							_tmp794_ = _tmp796_ == VALA_BINARY_OPERATOR_INEQUALITY;
						}
						if (_tmp794_) {
							ValaProfile _tmp797_;
							ValaProfile _tmp798_;
							gboolean _tmp867_ = FALSE;
							ValaExpression* _tmp868_;
							ValaExpression* _tmp869_;
							ValaDataType* _tmp870_;
							ValaDataType* _tmp871_;
							ValaExpression* _tmp872_;
							ValaExpression* _tmp873_;
							ValaDataType* _tmp874_;
							ValaDataType* _tmp875_;
							ValaDataType* resulting_type = NULL;
							ValaSemanticAnalyzer* _tmp900_;
							ValaSemanticAnalyzer* _tmp901_;
							ValaExpression* _tmp902_;
							ValaExpression* _tmp903_;
							ValaDataType* _tmp904_;
							ValaDataType* _tmp905_;
							ValaExpression* _tmp906_;
							ValaExpression* _tmp907_;
							ValaDataType* _tmp908_;
							ValaDataType* _tmp909_;
							ValaDataType* _tmp910_;
							ValaDataType* _tmp911_;
							ValaExpression* _tmp922_;
							ValaExpression* _tmp923_;
							ValaDataType* _tmp924_;
							ValaDataType* _tmp925_;
							ValaExpression* _tmp926_;
							ValaExpression* _tmp927_;
							ValaDataType* _tmp928_;
							ValaDataType* _tmp929_;
							ValaExpression* _tmp930_;
							ValaExpression* _tmp931_;
							ValaDataType* _tmp932_;
							ValaDataType* _tmp933_;
							gboolean _tmp934_;
							gboolean _tmp935_;
							ValaExpression* _tmp936_;
							ValaExpression* _tmp937_;
							ValaDataType* _tmp938_;
							ValaDataType* _tmp939_;
							gboolean _tmp940_;
							gboolean _tmp941_;
							ValaSemanticAnalyzer* _tmp950_;
							ValaSemanticAnalyzer* _tmp951_;
							ValaDataType* _tmp952_;
							_tmp797_ = vala_code_context_get_profile (context);
							_tmp798_ = _tmp797_;
							if (_tmp798_ == VALA_PROFILE_GOBJECT) {
								ValaTypeSymbol* gvalue_type = NULL;
								ValaSemanticAnalyzer* _tmp799_;
								ValaSemanticAnalyzer* _tmp800_;
								ValaStructValueType* _tmp801_;
								ValaTypeSymbol* _tmp802_;
								ValaTypeSymbol* _tmp803_;
								ValaTypeSymbol* _tmp804_;
								gboolean _tmp805_ = FALSE;
								gboolean _tmp806_ = FALSE;
								ValaExpression* _tmp807_;
								ValaExpression* _tmp808_;
								ValaDataType* _tmp809_;
								ValaDataType* _tmp810_;
								ValaTypeSymbol* _tmp811_;
								ValaTypeSymbol* _tmp812_;
								ValaTypeSymbol* _tmp813_;
								_tmp799_ = vala_code_context_get_analyzer (context);
								_tmp800_ = _tmp799_;
								_tmp801_ = _tmp800_->gvalue_type;
								_tmp802_ = vala_data_type_get_data_type ((ValaDataType*) _tmp801_);
								_tmp803_ = _tmp802_;
								_tmp804_ = _vala_code_node_ref0 (_tmp803_);
								gvalue_type = _tmp804_;
								_tmp807_ = vala_binary_expression_get_left (self);
								_tmp808_ = _tmp807_;
								_tmp809_ = vala_expression_get_target_type (_tmp808_);
								_tmp810_ = _tmp809_;
								_tmp811_ = vala_data_type_get_data_type (_tmp810_);
								_tmp812_ = _tmp811_;
								_tmp813_ = gvalue_type;
								if (_tmp812_ == _tmp813_) {
									ValaExpression* _tmp814_;
									ValaExpression* _tmp815_;
									ValaDataType* _tmp816_;
									ValaDataType* _tmp817_;
									ValaTypeSymbol* _tmp818_;
									ValaTypeSymbol* _tmp819_;
									ValaTypeSymbol* _tmp820_;
									_tmp814_ = vala_binary_expression_get_right (self);
									_tmp815_ = _tmp814_;
									_tmp816_ = vala_expression_get_target_type (_tmp815_);
									_tmp817_ = _tmp816_;
									_tmp818_ = vala_data_type_get_data_type (_tmp817_);
									_tmp819_ = _tmp818_;
									_tmp820_ = gvalue_type;
									_tmp806_ = _tmp819_ != _tmp820_;
								} else {
									_tmp806_ = FALSE;
								}
								if (_tmp806_) {
									_tmp805_ = TRUE;
								} else {
									gboolean _tmp821_ = FALSE;
									ValaExpression* _tmp822_;
									ValaExpression* _tmp823_;
									ValaDataType* _tmp824_;
									ValaDataType* _tmp825_;
									ValaTypeSymbol* _tmp826_;
									ValaTypeSymbol* _tmp827_;
									ValaTypeSymbol* _tmp828_;
									_tmp822_ = vala_binary_expression_get_left (self);
									_tmp823_ = _tmp822_;
									_tmp824_ = vala_expression_get_target_type (_tmp823_);
									_tmp825_ = _tmp824_;
									_tmp826_ = vala_data_type_get_data_type (_tmp825_);
									_tmp827_ = _tmp826_;
									_tmp828_ = gvalue_type;
									if (_tmp827_ != _tmp828_) {
										ValaExpression* _tmp829_;
										ValaExpression* _tmp830_;
										ValaDataType* _tmp831_;
										ValaDataType* _tmp832_;
										ValaTypeSymbol* _tmp833_;
										ValaTypeSymbol* _tmp834_;
										ValaTypeSymbol* _tmp835_;
										_tmp829_ = vala_binary_expression_get_right (self);
										_tmp830_ = _tmp829_;
										_tmp831_ = vala_expression_get_target_type (_tmp830_);
										_tmp832_ = _tmp831_;
										_tmp833_ = vala_data_type_get_data_type (_tmp832_);
										_tmp834_ = _tmp833_;
										_tmp835_ = gvalue_type;
										_tmp821_ = _tmp834_ == _tmp835_;
									} else {
										_tmp821_ = FALSE;
									}
									_tmp805_ = _tmp821_;
								}
								if (_tmp805_) {
									ValaExpression* gvalue_expr = NULL;
									ValaDataType* target_type = NULL;
									ValaExpression* _tmp836_;
									ValaExpression* _tmp837_;
									ValaDataType* _tmp838_;
									ValaDataType* _tmp839_;
									ValaTypeSymbol* _tmp840_;
									ValaTypeSymbol* _tmp841_;
									ValaTypeSymbol* _tmp842_;
									ValaCastExpression* cast_expr = NULL;
									ValaExpression* _tmp859_;
									ValaDataType* _tmp860_;
									ValaExpression* _tmp861_;
									ValaSourceReference* _tmp862_;
									ValaSourceReference* _tmp863_;
									ValaCastExpression* _tmp864_;
									ValaExpression* _tmp865_;
									ValaCastExpression* _tmp866_;
									_tmp836_ = vala_binary_expression_get_left (self);
									_tmp837_ = _tmp836_;
									_tmp838_ = vala_expression_get_target_type (_tmp837_);
									_tmp839_ = _tmp838_;
									_tmp840_ = vala_data_type_get_data_type (_tmp839_);
									_tmp841_ = _tmp840_;
									_tmp842_ = gvalue_type;
									if (_tmp841_ == _tmp842_) {
										ValaExpression* _tmp843_;
										ValaExpression* _tmp844_;
										ValaExpression* _tmp845_;
										ValaExpression* _tmp846_;
										ValaExpression* _tmp847_;
										ValaDataType* _tmp848_;
										ValaDataType* _tmp849_;
										ValaDataType* _tmp850_;
										_tmp843_ = vala_binary_expression_get_left (self);
										_tmp844_ = _tmp843_;
										_tmp845_ = _vala_code_node_ref0 (_tmp844_);
										_vala_code_node_unref0 (gvalue_expr);
										gvalue_expr = _tmp845_;
										_tmp846_ = vala_binary_expression_get_right (self);
										_tmp847_ = _tmp846_;
										_tmp848_ = vala_expression_get_target_type (_tmp847_);
										_tmp849_ = _tmp848_;
										_tmp850_ = _vala_code_node_ref0 (_tmp849_);
										_vala_code_node_unref0 (target_type);
										target_type = _tmp850_;
									} else {
										ValaExpression* _tmp851_;
										ValaExpression* _tmp852_;
										ValaExpression* _tmp853_;
										ValaExpression* _tmp854_;
										ValaExpression* _tmp855_;
										ValaDataType* _tmp856_;
										ValaDataType* _tmp857_;
										ValaDataType* _tmp858_;
										_tmp851_ = vala_binary_expression_get_right (self);
										_tmp852_ = _tmp851_;
										_tmp853_ = _vala_code_node_ref0 (_tmp852_);
										_vala_code_node_unref0 (gvalue_expr);
										gvalue_expr = _tmp853_;
										_tmp854_ = vala_binary_expression_get_left (self);
										_tmp855_ = _tmp854_;
										_tmp856_ = vala_expression_get_target_type (_tmp855_);
										_tmp857_ = _tmp856_;
										_tmp858_ = _vala_code_node_ref0 (_tmp857_);
										_vala_code_node_unref0 (target_type);
										target_type = _tmp858_;
									}
									_tmp859_ = gvalue_expr;
									_tmp860_ = target_type;
									_tmp861_ = gvalue_expr;
									_tmp862_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp861_);
									_tmp863_ = _tmp862_;
									_tmp864_ = vala_cast_expression_new (_tmp859_, _tmp860_, _tmp863_);
									cast_expr = _tmp864_;
									_tmp865_ = gvalue_expr;
									_tmp866_ = cast_expr;
									vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp865_, (ValaExpression*) _tmp866_);
									vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
									result = vala_code_node_check ((ValaCodeNode*) self, context);
									_vala_code_node_unref0 (cast_expr);
									_vala_code_node_unref0 (target_type);
									_vala_code_node_unref0 (gvalue_expr);
									_vala_code_node_unref0 (gvalue_type);
									return result;
								}
								_vala_code_node_unref0 (gvalue_type);
							}
							_tmp868_ = vala_binary_expression_get_right (self);
							_tmp869_ = _tmp868_;
							_tmp870_ = vala_expression_get_value_type (_tmp869_);
							_tmp871_ = _tmp870_;
							_tmp872_ = vala_binary_expression_get_left (self);
							_tmp873_ = _tmp872_;
							_tmp874_ = vala_expression_get_value_type (_tmp873_);
							_tmp875_ = _tmp874_;
							if (!vala_data_type_compatible (_tmp871_, _tmp875_)) {
								ValaExpression* _tmp876_;
								ValaExpression* _tmp877_;
								ValaDataType* _tmp878_;
								ValaDataType* _tmp879_;
								ValaExpression* _tmp880_;
								ValaExpression* _tmp881_;
								ValaDataType* _tmp882_;
								ValaDataType* _tmp883_;
								_tmp876_ = vala_binary_expression_get_left (self);
								_tmp877_ = _tmp876_;
								_tmp878_ = vala_expression_get_value_type (_tmp877_);
								_tmp879_ = _tmp878_;
								_tmp880_ = vala_binary_expression_get_right (self);
								_tmp881_ = _tmp880_;
								_tmp882_ = vala_expression_get_value_type (_tmp881_);
								_tmp883_ = _tmp882_;
								_tmp867_ = !vala_data_type_compatible (_tmp879_, _tmp883_);
							} else {
								_tmp867_ = FALSE;
							}
							if (_tmp867_) {
								ValaSourceReference* _tmp884_;
								ValaSourceReference* _tmp885_;
								ValaExpression* _tmp886_;
								ValaExpression* _tmp887_;
								ValaDataType* _tmp888_;
								ValaDataType* _tmp889_;
								gchar* _tmp890_;
								gchar* _tmp891_;
								ValaExpression* _tmp892_;
								ValaExpression* _tmp893_;
								ValaDataType* _tmp894_;
								ValaDataType* _tmp895_;
								gchar* _tmp896_;
								gchar* _tmp897_;
								gchar* _tmp898_;
								gchar* _tmp899_;
								_tmp884_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp885_ = _tmp884_;
								_tmp886_ = vala_binary_expression_get_right (self);
								_tmp887_ = _tmp886_;
								_tmp888_ = vala_expression_get_value_type (_tmp887_);
								_tmp889_ = _tmp888_;
								_tmp890_ = vala_code_node_to_string ((ValaCodeNode*) _tmp889_);
								_tmp891_ = _tmp890_;
								_tmp892_ = vala_binary_expression_get_left (self);
								_tmp893_ = _tmp892_;
								_tmp894_ = vala_expression_get_value_type (_tmp893_);
								_tmp895_ = _tmp894_;
								_tmp896_ = vala_code_node_to_string ((ValaCodeNode*) _tmp895_);
								_tmp897_ = _tmp896_;
								_tmp898_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp891_, _tmp897_);
								_tmp899_ = _tmp898_;
								vala_report_error (_tmp885_, _tmp899_);
								_g_free0 (_tmp899_);
								_g_free0 (_tmp897_);
								_g_free0 (_tmp891_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp900_ = vala_code_context_get_analyzer (context);
							_tmp901_ = _tmp900_;
							_tmp902_ = vala_binary_expression_get_left (self);
							_tmp903_ = _tmp902_;
							_tmp904_ = vala_expression_get_target_type (_tmp903_);
							_tmp905_ = _tmp904_;
							_tmp906_ = vala_binary_expression_get_right (self);
							_tmp907_ = _tmp906_;
							_tmp908_ = vala_expression_get_target_type (_tmp907_);
							_tmp909_ = _tmp908_;
							_tmp910_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp901_, _tmp905_, _tmp909_);
							resulting_type = _tmp910_;
							_tmp911_ = resulting_type;
							if (_tmp911_ != NULL) {
								ValaExpression* _tmp912_;
								ValaExpression* _tmp913_;
								ValaDataType* _tmp914_;
								ValaDataType* _tmp915_;
								ValaDataType* _tmp916_;
								ValaExpression* _tmp917_;
								ValaExpression* _tmp918_;
								ValaDataType* _tmp919_;
								ValaDataType* _tmp920_;
								ValaDataType* _tmp921_;
								_tmp912_ = vala_binary_expression_get_left (self);
								_tmp913_ = _tmp912_;
								_tmp914_ = resulting_type;
								_tmp915_ = vala_data_type_copy (_tmp914_);
								_tmp916_ = _tmp915_;
								vala_expression_set_target_type (_tmp913_, _tmp916_);
								_vala_code_node_unref0 (_tmp916_);
								_tmp917_ = vala_binary_expression_get_right (self);
								_tmp918_ = _tmp917_;
								_tmp919_ = resulting_type;
								_tmp920_ = vala_data_type_copy (_tmp919_);
								_tmp921_ = _tmp920_;
								vala_expression_set_target_type (_tmp918_, _tmp921_);
								_vala_code_node_unref0 (_tmp921_);
							}
							_tmp922_ = vala_binary_expression_get_left (self);
							_tmp923_ = _tmp922_;
							_tmp924_ = vala_expression_get_target_type (_tmp923_);
							_tmp925_ = _tmp924_;
							vala_data_type_set_value_owned (_tmp925_, FALSE);
							_tmp926_ = vala_binary_expression_get_right (self);
							_tmp927_ = _tmp926_;
							_tmp928_ = vala_expression_get_target_type (_tmp927_);
							_tmp929_ = _tmp928_;
							vala_data_type_set_value_owned (_tmp929_, FALSE);
							_tmp930_ = vala_binary_expression_get_left (self);
							_tmp931_ = _tmp930_;
							_tmp932_ = vala_expression_get_value_type (_tmp931_);
							_tmp933_ = _tmp932_;
							_tmp934_ = vala_data_type_get_nullable (_tmp933_);
							_tmp935_ = _tmp934_;
							_tmp936_ = vala_binary_expression_get_right (self);
							_tmp937_ = _tmp936_;
							_tmp938_ = vala_expression_get_value_type (_tmp937_);
							_tmp939_ = _tmp938_;
							_tmp940_ = vala_data_type_get_nullable (_tmp939_);
							_tmp941_ = _tmp940_;
							if (_tmp935_ != _tmp941_) {
								ValaExpression* _tmp942_;
								ValaExpression* _tmp943_;
								ValaDataType* _tmp944_;
								ValaDataType* _tmp945_;
								ValaExpression* _tmp946_;
								ValaExpression* _tmp947_;
								ValaDataType* _tmp948_;
								ValaDataType* _tmp949_;
								_tmp942_ = vala_binary_expression_get_left (self);
								_tmp943_ = _tmp942_;
								_tmp944_ = vala_expression_get_target_type (_tmp943_);
								_tmp945_ = _tmp944_;
								vala_data_type_set_nullable (_tmp945_, TRUE);
								_tmp946_ = vala_binary_expression_get_right (self);
								_tmp947_ = _tmp946_;
								_tmp948_ = vala_expression_get_target_type (_tmp947_);
								_tmp949_ = _tmp948_;
								vala_data_type_set_nullable (_tmp949_, TRUE);
							}
							_tmp950_ = vala_code_context_get_analyzer (context);
							_tmp951_ = _tmp950_;
							_tmp952_ = _tmp951_->bool_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp952_);
							_vala_code_node_unref0 (resulting_type);
						} else {
							gboolean _tmp953_ = FALSE;
							gboolean _tmp954_ = FALSE;
							ValaBinaryOperator _tmp955_;
							_tmp955_ = self->priv->_operator;
							if (_tmp955_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
								_tmp954_ = TRUE;
							} else {
								ValaBinaryOperator _tmp956_;
								_tmp956_ = self->priv->_operator;
								_tmp954_ = _tmp956_ == VALA_BINARY_OPERATOR_BITWISE_OR;
							}
							if (_tmp954_) {
								_tmp953_ = TRUE;
							} else {
								ValaBinaryOperator _tmp957_;
								_tmp957_ = self->priv->_operator;
								_tmp953_ = _tmp957_ == VALA_BINARY_OPERATOR_BITWISE_XOR;
							}
							if (_tmp953_) {
								ValaExpression* _tmp958_;
								ValaExpression* _tmp959_;
								ValaDataType* _tmp960_;
								ValaDataType* _tmp961_;
								ValaExpression* _tmp962_;
								ValaExpression* _tmp963_;
								ValaDataType* _tmp964_;
								ValaDataType* _tmp965_;
								gboolean _tmp966_ = FALSE;
								ValaExpression* _tmp967_;
								ValaExpression* _tmp968_;
								ValaDataType* _tmp969_;
								ValaDataType* _tmp970_;
								ValaSemanticAnalyzer* _tmp971_;
								ValaSemanticAnalyzer* _tmp972_;
								ValaDataType* _tmp973_;
								_tmp958_ = vala_binary_expression_get_left (self);
								_tmp959_ = _tmp958_;
								_tmp960_ = vala_expression_get_target_type (_tmp959_);
								_tmp961_ = _tmp960_;
								vala_data_type_set_nullable (_tmp961_, FALSE);
								_tmp962_ = vala_binary_expression_get_right (self);
								_tmp963_ = _tmp962_;
								_tmp964_ = vala_expression_get_target_type (_tmp963_);
								_tmp965_ = _tmp964_;
								vala_data_type_set_nullable (_tmp965_, FALSE);
								_tmp967_ = vala_binary_expression_get_left (self);
								_tmp968_ = _tmp967_;
								_tmp969_ = vala_expression_get_value_type (_tmp968_);
								_tmp970_ = _tmp969_;
								_tmp971_ = vala_code_context_get_analyzer (context);
								_tmp972_ = _tmp971_;
								_tmp973_ = _tmp972_->bool_type;
								if (vala_data_type_compatible (_tmp970_, _tmp973_)) {
									ValaExpression* _tmp974_;
									ValaExpression* _tmp975_;
									ValaDataType* _tmp976_;
									ValaDataType* _tmp977_;
									ValaSemanticAnalyzer* _tmp978_;
									ValaSemanticAnalyzer* _tmp979_;
									ValaDataType* _tmp980_;
									_tmp974_ = vala_binary_expression_get_right (self);
									_tmp975_ = _tmp974_;
									_tmp976_ = vala_expression_get_value_type (_tmp975_);
									_tmp977_ = _tmp976_;
									_tmp978_ = vala_code_context_get_analyzer (context);
									_tmp979_ = _tmp978_;
									_tmp980_ = _tmp979_->bool_type;
									_tmp966_ = !vala_data_type_compatible (_tmp977_, _tmp980_);
								} else {
									_tmp966_ = FALSE;
								}
								if (_tmp966_) {
									ValaExpression* _tmp981_;
									ValaExpression* _tmp982_;
									ValaDataType* _tmp983_;
									ValaDataType* _tmp984_;
									ValaDataType* _tmp985_;
									ValaDataType* _tmp986_;
									_tmp981_ = vala_binary_expression_get_right (self);
									_tmp982_ = _tmp981_;
									_tmp983_ = vala_expression_get_target_type (_tmp982_);
									_tmp984_ = _tmp983_;
									_tmp985_ = vala_data_type_copy (_tmp984_);
									_tmp986_ = _tmp985_;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp986_);
									_vala_code_node_unref0 (_tmp986_);
								} else {
									ValaExpression* _tmp987_;
									ValaExpression* _tmp988_;
									ValaDataType* _tmp989_;
									ValaDataType* _tmp990_;
									ValaDataType* _tmp991_;
									ValaDataType* _tmp992_;
									_tmp987_ = vala_binary_expression_get_left (self);
									_tmp988_ = _tmp987_;
									_tmp989_ = vala_expression_get_target_type (_tmp988_);
									_tmp990_ = _tmp989_;
									_tmp991_ = vala_data_type_copy (_tmp990_);
									_tmp992_ = _tmp991_;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp992_);
									_vala_code_node_unref0 (_tmp992_);
								}
							} else {
								gboolean _tmp993_ = FALSE;
								ValaBinaryOperator _tmp994_;
								_tmp994_ = self->priv->_operator;
								if (_tmp994_ == VALA_BINARY_OPERATOR_AND) {
									_tmp993_ = TRUE;
								} else {
									ValaBinaryOperator _tmp995_;
									_tmp995_ = self->priv->_operator;
									_tmp993_ = _tmp995_ == VALA_BINARY_OPERATOR_OR;
								}
								if (_tmp993_) {
									gboolean _tmp996_ = FALSE;
									ValaExpression* _tmp997_;
									ValaExpression* _tmp998_;
									ValaDataType* _tmp999_;
									ValaDataType* _tmp1000_;
									ValaSemanticAnalyzer* _tmp1001_;
									ValaSemanticAnalyzer* _tmp1002_;
									ValaDataType* _tmp1003_;
									ValaExpression* _tmp1013_;
									ValaExpression* _tmp1014_;
									ValaDataType* _tmp1015_;
									ValaDataType* _tmp1016_;
									ValaExpression* _tmp1017_;
									ValaExpression* _tmp1018_;
									ValaDataType* _tmp1019_;
									ValaDataType* _tmp1020_;
									ValaSemanticAnalyzer* _tmp1021_;
									ValaSemanticAnalyzer* _tmp1022_;
									ValaDataType* _tmp1023_;
									_tmp997_ = vala_binary_expression_get_left (self);
									_tmp998_ = _tmp997_;
									_tmp999_ = vala_expression_get_value_type (_tmp998_);
									_tmp1000_ = _tmp999_;
									_tmp1001_ = vala_code_context_get_analyzer (context);
									_tmp1002_ = _tmp1001_;
									_tmp1003_ = _tmp1002_->bool_type;
									if (!vala_data_type_compatible (_tmp1000_, _tmp1003_)) {
										_tmp996_ = TRUE;
									} else {
										ValaExpression* _tmp1004_;
										ValaExpression* _tmp1005_;
										ValaDataType* _tmp1006_;
										ValaDataType* _tmp1007_;
										ValaSemanticAnalyzer* _tmp1008_;
										ValaSemanticAnalyzer* _tmp1009_;
										ValaDataType* _tmp1010_;
										_tmp1004_ = vala_binary_expression_get_right (self);
										_tmp1005_ = _tmp1004_;
										_tmp1006_ = vala_expression_get_value_type (_tmp1005_);
										_tmp1007_ = _tmp1006_;
										_tmp1008_ = vala_code_context_get_analyzer (context);
										_tmp1009_ = _tmp1008_;
										_tmp1010_ = _tmp1009_->bool_type;
										_tmp996_ = !vala_data_type_compatible (_tmp1007_, _tmp1010_);
									}
									if (_tmp996_) {
										ValaSourceReference* _tmp1011_;
										ValaSourceReference* _tmp1012_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp1011_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp1012_ = _tmp1011_;
										vala_report_error (_tmp1012_, "Operands must be boolean");
									}
									_tmp1013_ = vala_binary_expression_get_left (self);
									_tmp1014_ = _tmp1013_;
									_tmp1015_ = vala_expression_get_target_type (_tmp1014_);
									_tmp1016_ = _tmp1015_;
									vala_data_type_set_nullable (_tmp1016_, FALSE);
									_tmp1017_ = vala_binary_expression_get_right (self);
									_tmp1018_ = _tmp1017_;
									_tmp1019_ = vala_expression_get_target_type (_tmp1018_);
									_tmp1020_ = _tmp1019_;
									vala_data_type_set_nullable (_tmp1020_, FALSE);
									_tmp1021_ = vala_code_context_get_analyzer (context);
									_tmp1022_ = _tmp1021_;
									_tmp1023_ = _tmp1022_->bool_type;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp1023_);
								} else {
									ValaBinaryOperator _tmp1024_;
									_tmp1024_ = self->priv->_operator;
									if (_tmp1024_ == VALA_BINARY_OPERATOR_IN) {
										gboolean _tmp1025_ = FALSE;
										ValaExpression* _tmp1026_;
										ValaExpression* _tmp1027_;
										ValaDataType* _tmp1028_;
										ValaDataType* _tmp1029_;
										ValaSemanticAnalyzer* _tmp1030_;
										ValaSemanticAnalyzer* _tmp1031_;
										ValaDataType* _tmp1032_;
										ValaSemanticAnalyzer* _tmp1138_;
										ValaSemanticAnalyzer* _tmp1139_;
										ValaDataType* _tmp1140_;
										_tmp1026_ = vala_binary_expression_get_left (self);
										_tmp1027_ = _tmp1026_;
										_tmp1028_ = vala_expression_get_value_type (_tmp1027_);
										_tmp1029_ = _tmp1028_;
										_tmp1030_ = vala_code_context_get_analyzer (context);
										_tmp1031_ = _tmp1030_;
										_tmp1032_ = _tmp1031_->int_type;
										if (vala_data_type_compatible (_tmp1029_, _tmp1032_)) {
											ValaExpression* _tmp1033_;
											ValaExpression* _tmp1034_;
											ValaDataType* _tmp1035_;
											ValaDataType* _tmp1036_;
											ValaSemanticAnalyzer* _tmp1037_;
											ValaSemanticAnalyzer* _tmp1038_;
											ValaDataType* _tmp1039_;
											_tmp1033_ = vala_binary_expression_get_right (self);
											_tmp1034_ = _tmp1033_;
											_tmp1035_ = vala_expression_get_value_type (_tmp1034_);
											_tmp1036_ = _tmp1035_;
											_tmp1037_ = vala_code_context_get_analyzer (context);
											_tmp1038_ = _tmp1037_;
											_tmp1039_ = _tmp1038_->int_type;
											_tmp1025_ = vala_data_type_compatible (_tmp1036_, _tmp1039_);
										} else {
											_tmp1025_ = FALSE;
										}
										if (_tmp1025_) {
											ValaExpression* _tmp1040_;
											ValaExpression* _tmp1041_;
											ValaDataType* _tmp1042_;
											ValaDataType* _tmp1043_;
											ValaExpression* _tmp1044_;
											ValaExpression* _tmp1045_;
											ValaDataType* _tmp1046_;
											ValaDataType* _tmp1047_;
											_tmp1040_ = vala_binary_expression_get_left (self);
											_tmp1041_ = _tmp1040_;
											_tmp1042_ = vala_expression_get_target_type (_tmp1041_);
											_tmp1043_ = _tmp1042_;
											vala_data_type_set_nullable (_tmp1043_, FALSE);
											_tmp1044_ = vala_binary_expression_get_right (self);
											_tmp1045_ = _tmp1044_;
											_tmp1046_ = vala_expression_get_target_type (_tmp1045_);
											_tmp1047_ = _tmp1046_;
											vala_data_type_set_nullable (_tmp1047_, FALSE);
										} else {
											ValaExpression* _tmp1048_;
											ValaExpression* _tmp1049_;
											ValaDataType* _tmp1050_;
											ValaDataType* _tmp1051_;
											_tmp1048_ = vala_binary_expression_get_right (self);
											_tmp1049_ = _tmp1048_;
											_tmp1050_ = vala_expression_get_value_type (_tmp1049_);
											_tmp1051_ = _tmp1050_;
											if (VALA_IS_ARRAY_TYPE (_tmp1051_)) {
												ValaExpression* _tmp1052_;
												ValaExpression* _tmp1053_;
												ValaDataType* _tmp1054_;
												ValaDataType* _tmp1055_;
												ValaExpression* _tmp1056_;
												ValaExpression* _tmp1057_;
												ValaDataType* _tmp1058_;
												ValaDataType* _tmp1059_;
												ValaDataType* _tmp1060_;
												ValaDataType* _tmp1061_;
												_tmp1052_ = vala_binary_expression_get_left (self);
												_tmp1053_ = _tmp1052_;
												_tmp1054_ = vala_expression_get_value_type (_tmp1053_);
												_tmp1055_ = _tmp1054_;
												_tmp1056_ = vala_binary_expression_get_right (self);
												_tmp1057_ = _tmp1056_;
												_tmp1058_ = vala_expression_get_value_type (_tmp1057_);
												_tmp1059_ = _tmp1058_;
												_tmp1060_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1059_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
												_tmp1061_ = _tmp1060_;
												if (!vala_data_type_compatible (_tmp1055_, _tmp1061_)) {
													ValaSourceReference* _tmp1062_;
													ValaSourceReference* _tmp1063_;
													ValaExpression* _tmp1064_;
													ValaExpression* _tmp1065_;
													ValaDataType* _tmp1066_;
													ValaDataType* _tmp1067_;
													gchar* _tmp1068_;
													gchar* _tmp1069_;
													ValaExpression* _tmp1070_;
													ValaExpression* _tmp1071_;
													ValaDataType* _tmp1072_;
													ValaDataType* _tmp1073_;
													gchar* _tmp1074_;
													gchar* _tmp1075_;
													gchar* _tmp1076_;
													gchar* _tmp1077_;
													_tmp1062_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1063_ = _tmp1062_;
													_tmp1064_ = vala_binary_expression_get_left (self);
													_tmp1065_ = _tmp1064_;
													_tmp1066_ = vala_expression_get_value_type (_tmp1065_);
													_tmp1067_ = _tmp1066_;
													_tmp1068_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1067_);
													_tmp1069_ = _tmp1068_;
													_tmp1070_ = vala_binary_expression_get_right (self);
													_tmp1071_ = _tmp1070_;
													_tmp1072_ = vala_expression_get_value_type (_tmp1071_);
													_tmp1073_ = _tmp1072_;
													_tmp1074_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1073_);
													_tmp1075_ = _tmp1074_;
													_tmp1076_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp1069_, _tmp1075_);
													_tmp1077_ = _tmp1076_;
													vala_report_error (_tmp1063_, _tmp1077_);
													_g_free0 (_tmp1077_);
													_g_free0 (_tmp1075_);
													_g_free0 (_tmp1069_);
												}
											} else {
												ValaMethod* contains_method = NULL;
												ValaExpression* _tmp1078_;
												ValaExpression* _tmp1079_;
												ValaDataType* _tmp1080_;
												ValaDataType* _tmp1081_;
												ValaSymbol* _tmp1082_;
												ValaMethod* _tmp1083_;
												ValaMethod* _tmp1084_;
												ValaMethod* _tmp1095_;
												ValaList* _tmp1096_;
												ValaList* _tmp1097_;
												gint _tmp1098_;
												gint _tmp1099_;
												gboolean _tmp1100_;
												ValaMethod* _tmp1108_;
												ValaDataType* _tmp1109_;
												ValaDataType* _tmp1110_;
												ValaSemanticAnalyzer* _tmp1111_;
												ValaSemanticAnalyzer* _tmp1112_;
												ValaDataType* _tmp1113_;
												ValaMethodCall* contains_call = NULL;
												ValaExpression* _tmp1121_;
												ValaExpression* _tmp1122_;
												ValaSourceReference* _tmp1123_;
												ValaSourceReference* _tmp1124_;
												ValaMemberAccess* _tmp1125_;
												ValaMemberAccess* _tmp1126_;
												ValaSourceReference* _tmp1127_;
												ValaSourceReference* _tmp1128_;
												ValaMethodCall* _tmp1129_;
												ValaMethodCall* _tmp1130_;
												ValaMethodCall* _tmp1131_;
												ValaExpression* _tmp1132_;
												ValaExpression* _tmp1133_;
												ValaCodeNode* _tmp1134_;
												ValaCodeNode* _tmp1135_;
												ValaMethodCall* _tmp1136_;
												ValaMethodCall* _tmp1137_;
												_tmp1078_ = vala_binary_expression_get_right (self);
												_tmp1079_ = _tmp1078_;
												_tmp1080_ = vala_expression_get_value_type (_tmp1079_);
												_tmp1081_ = _tmp1080_;
												_tmp1082_ = vala_data_type_get_member (_tmp1081_, "contains");
												_tmp1083_ = VALA_IS_METHOD (_tmp1082_) ? ((ValaMethod*) _tmp1082_) : NULL;
												if (_tmp1083_ == NULL) {
													_vala_code_node_unref0 (_tmp1082_);
												}
												contains_method = _tmp1083_;
												_tmp1084_ = contains_method;
												if (_tmp1084_ == NULL) {
													ValaSourceReference* _tmp1085_;
													ValaSourceReference* _tmp1086_;
													ValaExpression* _tmp1087_;
													ValaExpression* _tmp1088_;
													ValaDataType* _tmp1089_;
													ValaDataType* _tmp1090_;
													gchar* _tmp1091_;
													gchar* _tmp1092_;
													gchar* _tmp1093_;
													gchar* _tmp1094_;
													_tmp1085_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1086_ = _tmp1085_;
													_tmp1087_ = vala_binary_expression_get_right (self);
													_tmp1088_ = _tmp1087_;
													_tmp1089_ = vala_expression_get_value_type (_tmp1088_);
													_tmp1090_ = _tmp1089_;
													_tmp1091_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1090_);
													_tmp1092_ = _tmp1091_;
													_tmp1093_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp1092_);
													_tmp1094_ = _tmp1093_;
													vala_report_error (_tmp1086_, _tmp1094_);
													_g_free0 (_tmp1094_);
													_g_free0 (_tmp1092_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1095_ = contains_method;
												_tmp1096_ = vala_callable_get_parameters ((ValaCallable*) _tmp1095_);
												_tmp1097_ = _tmp1096_;
												_tmp1098_ = vala_collection_get_size ((ValaCollection*) _tmp1097_);
												_tmp1099_ = _tmp1098_;
												_tmp1100_ = _tmp1099_ != 1;
												_vala_iterable_unref0 (_tmp1097_);
												if (_tmp1100_) {
													ValaSourceReference* _tmp1101_;
													ValaSourceReference* _tmp1102_;
													ValaMethod* _tmp1103_;
													gchar* _tmp1104_;
													gchar* _tmp1105_;
													gchar* _tmp1106_;
													gchar* _tmp1107_;
													_tmp1101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1102_ = _tmp1101_;
													_tmp1103_ = contains_method;
													_tmp1104_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1103_);
													_tmp1105_ = _tmp1104_;
													_tmp1106_ = g_strdup_printf ("`%s' must have one parameter", _tmp1105_);
													_tmp1107_ = _tmp1106_;
													vala_report_error (_tmp1102_, _tmp1107_);
													_g_free0 (_tmp1107_);
													_g_free0 (_tmp1105_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1108_ = contains_method;
												_tmp1109_ = vala_callable_get_return_type ((ValaCallable*) _tmp1108_);
												_tmp1110_ = _tmp1109_;
												_tmp1111_ = vala_code_context_get_analyzer (context);
												_tmp1112_ = _tmp1111_;
												_tmp1113_ = _tmp1112_->bool_type;
												if (!vala_data_type_compatible (_tmp1110_, _tmp1113_)) {
													ValaSourceReference* _tmp1114_;
													ValaSourceReference* _tmp1115_;
													ValaMethod* _tmp1116_;
													gchar* _tmp1117_;
													gchar* _tmp1118_;
													gchar* _tmp1119_;
													gchar* _tmp1120_;
													_tmp1114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1115_ = _tmp1114_;
													_tmp1116_ = contains_method;
													_tmp1117_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1116_);
													_tmp1118_ = _tmp1117_;
													_tmp1119_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1118_);
													_tmp1120_ = _tmp1119_;
													vala_report_error (_tmp1115_, _tmp1120_);
													_g_free0 (_tmp1120_);
													_g_free0 (_tmp1118_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1121_ = vala_binary_expression_get_right (self);
												_tmp1122_ = _tmp1121_;
												_tmp1123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1124_ = _tmp1123_;
												_tmp1125_ = vala_member_access_new (_tmp1122_, "contains", _tmp1124_);
												_tmp1126_ = _tmp1125_;
												_tmp1127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1128_ = _tmp1127_;
												_tmp1129_ = vala_method_call_new ((ValaExpression*) _tmp1126_, _tmp1128_);
												_tmp1130_ = _tmp1129_;
												_vala_code_node_unref0 (_tmp1126_);
												contains_call = _tmp1130_;
												_tmp1131_ = contains_call;
												_tmp1132_ = vala_binary_expression_get_left (self);
												_tmp1133_ = _tmp1132_;
												vala_method_call_add_argument (_tmp1131_, _tmp1133_);
												_tmp1134_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
												_tmp1135_ = _tmp1134_;
												_tmp1136_ = contains_call;
												vala_code_node_replace_expression (_tmp1135_, (ValaExpression*) self, (ValaExpression*) _tmp1136_);
												_tmp1137_ = contains_call;
												result = vala_code_node_check ((ValaCodeNode*) _tmp1137_, context);
												_vala_code_node_unref0 (contains_call);
												_vala_code_node_unref0 (contains_method);
												return result;
											}
										}
										_tmp1138_ = vala_code_context_get_analyzer (context);
										_tmp1139_ = _tmp1138_;
										_tmp1140_ = _tmp1139_->bool_type;
										vala_expression_set_value_type ((ValaExpression*) self, _tmp1140_);
									} else {
										ValaSourceReference* _tmp1141_;
										ValaSourceReference* _tmp1142_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp1141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp1142_ = _tmp1141_;
										vala_report_error (_tmp1142_, "internal error: unsupported binary operator");
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1143_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1144_ = _tmp1143_;
	vala_code_node_check ((ValaCodeNode*) _tmp1144_, context);
	_tmp1145_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1146_ = _tmp1145_;
	result = !_tmp1146_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
		ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

