/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp560_ = FALSE;
	gboolean _tmp561_ = FALSE;
	gboolean _tmp562_ = FALSE;
	ValaExpression* _tmp563_;
	ValaExpression* _tmp564_;
	ValaSymbol* _tmp590_;
	ValaSymbol* _tmp591_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp618_;
	ValaSymbol* _tmp619_;
	ValaSymbol* _tmp620_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp621_;
	ValaSymbol* _tmp622_;
	ValaSymbol* _tmp1044_;
	ValaSymbol* _tmp1045_;
	ValaVersionAttribute* _tmp1046_;
	ValaVersionAttribute* _tmp1047_;
	ValaSourceReference* _tmp1048_;
	ValaSourceReference* _tmp1049_;
	gboolean _tmp1050_ = FALSE;
	ValaSymbolAccessibility _tmp1051_;
	gboolean _tmp1110_ = FALSE;
	gboolean _tmp1141_ = FALSE;
	gboolean _tmp1142_ = FALSE;
	ValaDataType* _tmp1397_;
	ValaDataType* _tmp1398_;
	gboolean _tmp1401_;
	gboolean _tmp1402_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaUsingDirective* _tmp167_;
						gboolean _tmp168_;
						gboolean _tmp169_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaScope* _tmp173_;
						ValaScope* _tmp174_;
						const gchar* _tmp175_;
						ValaSymbol* _tmp176_;
						ValaSymbol* _tmp177_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_code_node_get_error ((ValaCodeNode*) _tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp170_ = ns;
						_tmp171_ = vala_using_directive_get_namespace_symbol (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = vala_symbol_get_scope (_tmp172_);
						_tmp174_ = _tmp173_;
						_tmp175_ = self->priv->_member_name;
						_tmp176_ = vala_scope_lookup (_tmp174_, _tmp175_);
						local_sym = _tmp176_;
						_tmp177_ = local_sym;
						if (_tmp177_ != NULL) {
							gboolean _tmp178_ = FALSE;
							ValaSymbol* _tmp179_;
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp196_;
							_tmp179_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp180_ = _tmp179_;
							if (_tmp180_ != NULL) {
								ValaSymbol* _tmp181_;
								ValaSymbol* _tmp182_;
								ValaSymbol* _tmp183_;
								_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = local_sym;
								_tmp178_ = _tmp182_ != _tmp183_;
							} else {
								_tmp178_ = FALSE;
							}
							if (_tmp178_) {
								ValaSourceReference* _tmp184_;
								ValaSourceReference* _tmp185_;
								const gchar* _tmp186_;
								ValaSymbol* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								ValaSymbol* _tmp191_;
								gchar* _tmp192_;
								gchar* _tmp193_;
								gchar* _tmp194_;
								gchar* _tmp195_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = self->priv->_member_name;
								_tmp187_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp188_ = _tmp187_;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = local_sym;
								_tmp192_ = vala_symbol_get_full_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp186_, _tmp190_, _tmp193_);
								_tmp195_ = _tmp194_;
								vala_report_error (_tmp185_, _tmp195_);
								_g_free0 (_tmp195_);
								_g_free0 (_tmp193_);
								_g_free0 (_tmp190_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp196_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp196_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp197_;
			ValaExpression* _tmp198_;
			gboolean _tmp199_;
			gboolean _tmp200_;
			ValaExpression* _tmp201_;
			ValaExpression* _tmp202_;
			ValaDataType* _tmp203_;
			ValaDataType* _tmp204_;
			ValaExpression* _tmp223_;
			ValaExpression* _tmp224_;
			gboolean _tmp240_ = FALSE;
			ValaExpression* _tmp241_;
			ValaExpression* _tmp242_;
			gboolean _tmp264_ = FALSE;
			ValaSymbol* _tmp265_;
			ValaSymbol* _tmp266_;
			gboolean _tmp301_ = FALSE;
			gboolean _tmp302_ = FALSE;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			gboolean _tmp542_ = FALSE;
			ValaSymbol* _tmp543_;
			ValaSymbol* _tmp544_;
			_tmp197_ = vala_member_access_get_inner (self);
			_tmp198_ = _tmp197_;
			_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
			_tmp200_ = _tmp199_;
			if (_tmp200_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp201_ = vala_member_access_get_inner (self);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_expression_get_value_type (_tmp202_);
			_tmp204_ = _tmp203_;
			if (VALA_IS_POINTER_TYPE (_tmp204_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp205_;
				ValaExpression* _tmp206_;
				ValaDataType* _tmp207_;
				ValaDataType* _tmp208_;
				ValaPointerType* _tmp209_;
				gboolean _tmp210_ = FALSE;
				ValaPointerType* _tmp211_;
				_tmp205_ = vala_member_access_get_inner (self);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_expression_get_value_type (_tmp206_);
				_tmp208_ = _tmp207_;
				_tmp209_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp208_) ? ((ValaPointerType*) _tmp208_) : NULL);
				pointer_type = _tmp209_;
				_tmp211_ = pointer_type;
				if (_tmp211_ != NULL) {
					ValaPointerType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaDataType* _tmp214_;
					_tmp212_ = pointer_type;
					_tmp213_ = vala_pointer_type_get_base_type (_tmp212_);
					_tmp214_ = _tmp213_;
					_tmp210_ = VALA_IS_VALUE_TYPE (_tmp214_);
				} else {
					_tmp210_ = FALSE;
				}
				if (_tmp210_) {
					ValaExpression* _tmp215_;
					ValaExpression* _tmp216_;
					ValaSourceReference* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaPointerIndirection* _tmp219_;
					ValaPointerIndirection* _tmp220_;
					ValaExpression* _tmp221_;
					ValaExpression* _tmp222_;
					_tmp215_ = vala_member_access_get_inner (self);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_pointer_indirection_new (_tmp216_, _tmp218_);
					_tmp220_ = _tmp219_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp220_);
					_vala_code_node_unref0 (_tmp220_);
					_tmp221_ = vala_member_access_get_inner (self);
					_tmp222_ = _tmp221_;
					vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp223_ = vala_member_access_get_inner (self);
			_tmp224_ = _tmp223_;
			if (VALA_IS_MEMBER_ACCESS (_tmp224_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				ValaMemberAccess* _tmp227_;
				ValaMemberAccess* _tmp228_;
				gboolean _tmp229_;
				_tmp225_ = vala_member_access_get_inner (self);
				_tmp226_ = _tmp225_;
				_tmp227_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp227_;
				_tmp228_ = ma;
				_tmp229_ = _tmp228_->priv->_prototype_access;
				if (_tmp229_) {
					ValaSourceReference* _tmp230_;
					ValaSourceReference* _tmp231_;
					ValaExpression* _tmp232_;
					ValaExpression* _tmp233_;
					ValaSymbol* _tmp234_;
					ValaSymbol* _tmp235_;
					gchar* _tmp236_;
					gchar* _tmp237_;
					gchar* _tmp238_;
					gchar* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp231_ = _tmp230_;
					_tmp232_ = vala_member_access_get_inner (self);
					_tmp233_ = _tmp232_;
					_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_symbol_get_full_name (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp237_);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp231_, _tmp239_);
					_g_free0 (_tmp239_);
					_g_free0 (_tmp237_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp241_ = vala_member_access_get_inner (self);
			_tmp242_ = _tmp241_;
			if (VALA_IS_MEMBER_ACCESS (_tmp242_)) {
				_tmp240_ = TRUE;
			} else {
				ValaExpression* _tmp243_;
				ValaExpression* _tmp244_;
				_tmp243_ = vala_member_access_get_inner (self);
				_tmp244_ = _tmp243_;
				_tmp240_ = VALA_IS_BASE_ACCESS (_tmp244_);
			}
			if (_tmp240_) {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaSymbol* _tmp247_;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				gboolean _tmp250_ = FALSE;
				ValaSymbol* _tmp251_;
				ValaSymbol* _tmp252_;
				_tmp245_ = vala_member_access_get_inner (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = _vala_code_node_ref0 (_tmp248_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp249_;
				_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp252_ = _tmp251_;
				if (_tmp252_ == NULL) {
					gboolean _tmp253_ = FALSE;
					ValaSymbol* _tmp254_;
					_tmp254_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp254_)) {
						_tmp253_ = TRUE;
					} else {
						ValaSymbol* _tmp255_;
						_tmp255_ = base_symbol;
						_tmp253_ = VALA_IS_TYPESYMBOL (_tmp255_);
					}
					_tmp250_ = _tmp253_;
				} else {
					_tmp250_ = FALSE;
				}
				if (_tmp250_) {
					ValaSymbol* _tmp256_;
					ValaScope* _tmp257_;
					ValaScope* _tmp258_;
					const gchar* _tmp259_;
					ValaSymbol* _tmp260_;
					ValaSymbol* _tmp261_;
					ValaExpression* _tmp262_;
					ValaExpression* _tmp263_;
					_tmp256_ = base_symbol;
					_tmp257_ = vala_symbol_get_scope (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = self->priv->_member_name;
					_tmp260_ = vala_scope_lookup (_tmp258_, _tmp259_);
					_tmp261_ = _tmp260_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp261_);
					_vala_code_node_unref0 (_tmp261_);
					_tmp262_ = vala_member_access_get_inner (self);
					_tmp263_ = _tmp262_;
					if (VALA_IS_BASE_ACCESS (_tmp263_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp265_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp266_ = _tmp265_;
			if (_tmp266_ == NULL) {
				ValaExpression* _tmp267_;
				ValaExpression* _tmp268_;
				ValaDataType* _tmp269_;
				ValaDataType* _tmp270_;
				_tmp267_ = vala_member_access_get_inner (self);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_expression_get_value_type (_tmp268_);
				_tmp270_ = _tmp269_;
				_tmp264_ = _tmp270_ != NULL;
			} else {
				_tmp264_ = FALSE;
			}
			if (_tmp264_) {
				gboolean _tmp271_;
				ValaSymbol* _tmp299_;
				ValaSymbol* _tmp300_;
				_tmp271_ = self->priv->_pointer_member_access;
				if (_tmp271_) {
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaDataType* _tmp274_;
					ValaDataType* _tmp275_;
					const gchar* _tmp276_;
					ValaSymbol* _tmp277_;
					ValaSymbol* _tmp278_;
					_tmp272_ = vala_member_access_get_inner (self);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_expression_get_value_type (_tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = self->priv->_member_name;
					_tmp277_ = vala_data_type_get_pointer_member (_tmp275_, _tmp276_);
					_tmp278_ = _tmp277_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp278_);
					_vala_code_node_unref0 (_tmp278_);
				} else {
					ValaExpression* _tmp279_;
					ValaExpression* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					ValaTypeSymbol* _tmp283_;
					ValaTypeSymbol* _tmp284_;
					ValaExpression* _tmp292_;
					ValaExpression* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					const gchar* _tmp296_;
					ValaSymbol* _tmp297_;
					ValaSymbol* _tmp298_;
					_tmp279_ = vala_member_access_get_inner (self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_expression_get_value_type (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_data_type_get_data_type (_tmp282_);
					_tmp284_ = _tmp283_;
					if (_tmp284_ != NULL) {
						ValaExpression* _tmp285_;
						ValaExpression* _tmp286_;
						ValaDataType* _tmp287_;
						ValaDataType* _tmp288_;
						ValaTypeSymbol* _tmp289_;
						ValaTypeSymbol* _tmp290_;
						ValaSymbol* _tmp291_;
						_tmp285_ = vala_member_access_get_inner (self);
						_tmp286_ = _tmp285_;
						_tmp287_ = vala_expression_get_value_type (_tmp286_);
						_tmp288_ = _tmp287_;
						_tmp289_ = vala_data_type_get_data_type (_tmp288_);
						_tmp290_ = _tmp289_;
						_tmp291_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp290_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp291_;
					}
					_tmp292_ = vala_member_access_get_inner (self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_expression_get_value_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = self->priv->_member_name;
					_tmp297_ = vala_data_type_get_member (_tmp295_, _tmp296_);
					_tmp298_ = _tmp297_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp298_);
					_vala_code_node_unref0 (_tmp298_);
				}
				_tmp299_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp300_ = _tmp299_;
				if (_tmp300_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp304_ = _tmp303_;
			if (_tmp304_ == NULL) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_expression_get_value_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp302_ = _tmp308_ != NULL;
			} else {
				_tmp302_ = FALSE;
			}
			if (_tmp302_) {
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				gboolean _tmp313_;
				gboolean _tmp314_;
				_tmp309_ = vala_member_access_get_inner (self);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_expression_get_value_type (_tmp310_);
				_tmp312_ = _tmp311_;
				_tmp313_ = vala_data_type_get_is_dynamic (_tmp312_);
				_tmp314_ = _tmp313_;
				_tmp301_ = _tmp314_;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaObjectType* _tmp319_;
				ValaCodeNode* _tmp320_;
				ValaCodeNode* _tmp321_;
				ValaSymbol* _tmp490_;
				ValaSymbol* _tmp491_;
				ValaSymbol* _tmp540_;
				ValaSymbol* _tmp541_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_expression_get_value_type (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp319_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp318_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp319_;
				_tmp320_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				if (VALA_IS_METHOD_CALL (_tmp321_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp322_;
					ValaCodeNode* _tmp323_;
					ValaMethodCall* _tmp324_;
					ValaMethodCall* _tmp325_;
					ValaExpression* _tmp326_;
					ValaExpression* _tmp327_;
					_tmp322_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp323_ = _tmp322_;
					_tmp324_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp324_;
					_tmp325_ = invoc;
					_tmp326_ = vala_method_call_get_call (_tmp325_);
					_tmp327_ = _tmp326_;
					if (_tmp327_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp328_;
						ValaDataType* _tmp329_;
						ValaDataType* _tmp330_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp345_;
						ValaExpression* _tmp346_;
						ValaDataType* _tmp347_;
						ValaDataType* _tmp348_;
						const gchar* _tmp349_;
						ValaDataType* _tmp350_;
						ValaSourceReference* _tmp351_;
						ValaSourceReference* _tmp352_;
						ValaDynamicMethod* _tmp353_;
						ValaDynamicMethod* _tmp354_;
						ValaMethodCall* _tmp355_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp356_;
						ValaErrorType* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaErrorType* _tmp359_;
						ValaDynamicMethod* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaParameter* _tmp362_;
						ValaParameter* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaObjectType* _tmp365_;
						ValaDataType* _tmp366_;
						ValaDataType* _tmp367_;
						ValaParameter* _tmp368_;
						ValaParameter* _tmp369_;
						ValaObjectType* _tmp370_;
						ValaObjectTypeSymbol* _tmp371_;
						ValaObjectTypeSymbol* _tmp372_;
						ValaScope* _tmp373_;
						ValaScope* _tmp374_;
						ValaDynamicMethod* _tmp375_;
						ValaDynamicMethod* _tmp376_;
						_tmp328_ = invoc;
						_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
						_tmp330_ = _tmp329_;
						if (_tmp330_ != NULL) {
							ValaMethodCall* _tmp331_;
							ValaDataType* _tmp332_;
							ValaDataType* _tmp333_;
							ValaDataType* _tmp334_;
							ValaDataType* _tmp335_;
							_tmp331_ = invoc;
							_tmp332_ = vala_expression_get_target_type ((ValaExpression*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = vala_data_type_copy (_tmp333_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp334_;
							_tmp335_ = ret_type;
							vala_data_type_set_value_owned (_tmp335_, TRUE);
						} else {
							ValaMethodCall* _tmp336_;
							ValaCodeNode* _tmp337_;
							ValaCodeNode* _tmp338_;
							_tmp336_ = invoc;
							_tmp337_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp336_);
							_tmp338_ = _tmp337_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp338_)) {
								ValaVoidType* _tmp339_;
								_tmp339_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp339_;
							} else {
								ValaExpression* _tmp340_;
								ValaExpression* _tmp341_;
								ValaDataType* _tmp342_;
								ValaDataType* _tmp343_;
								ValaDataType* _tmp344_;
								_tmp340_ = vala_member_access_get_inner (self);
								_tmp341_ = _tmp340_;
								_tmp342_ = vala_expression_get_value_type (_tmp341_);
								_tmp343_ = _tmp342_;
								_tmp344_ = vala_data_type_copy (_tmp343_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp344_;
							}
						}
						_tmp345_ = vala_member_access_get_inner (self);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_expression_get_value_type (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = self->priv->_member_name;
						_tmp350_ = ret_type;
						_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp352_ = _tmp351_;
						_tmp353_ = vala_dynamic_method_new (_tmp348_, _tmp349_, _tmp350_, _tmp352_, NULL);
						m = _tmp353_;
						_tmp354_ = m;
						_tmp355_ = invoc;
						vala_dynamic_method_set_invocation (_tmp354_, _tmp355_);
						_tmp356_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp356_;
						_tmp357_ = err;
						vala_error_type_set_dynamic_error (_tmp357_, TRUE);
						_tmp358_ = m;
						_tmp359_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp358_, (ValaDataType*) _tmp359_);
						_tmp360_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp360_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp361_ = m;
						_tmp362_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp363_ = _tmp362_;
						vala_callable_add_parameter ((ValaCallable*) _tmp361_, _tmp363_);
						_vala_code_node_unref0 (_tmp363_);
						_tmp364_ = m;
						_tmp365_ = dynamic_object_type;
						_tmp366_ = vala_data_type_copy ((ValaDataType*) _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_parameter_new ("this", _tmp367_, NULL);
						_tmp369_ = _tmp368_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp364_, _tmp369_);
						_vala_code_node_unref0 (_tmp369_);
						_vala_code_node_unref0 (_tmp367_);
						_tmp370_ = dynamic_object_type;
						_tmp371_ = vala_object_type_get_type_symbol (_tmp370_);
						_tmp372_ = _tmp371_;
						_tmp373_ = vala_symbol_get_scope ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = m;
						vala_scope_add (_tmp374_, NULL, (ValaSymbol*) _tmp375_);
						_tmp376_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp376_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp377_;
					ValaCodeNode* _tmp378_;
					_tmp377_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp378_ = _tmp377_;
					if (VALA_IS_ASSIGNMENT (_tmp378_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp379_;
						ValaCodeNode* _tmp380_;
						ValaAssignment* _tmp381_;
						ValaAssignment* _tmp382_;
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						_tmp379_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp380_ = _tmp379_;
						_tmp381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp381_;
						_tmp382_ = a;
						_tmp383_ = vala_assignment_get_left (_tmp382_);
						_tmp384_ = _tmp383_;
						if (_tmp384_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp385_;
							ValaExpression* _tmp386_;
							ValaDataType* _tmp387_;
							ValaDataType* _tmp388_;
							const gchar* _tmp389_;
							ValaSourceReference* _tmp390_;
							ValaSourceReference* _tmp391_;
							ValaDynamicProperty* _tmp392_;
							ValaDynamicProperty* _tmp393_;
							ValaDynamicProperty* _tmp394_;
							ValaDynamicProperty* _tmp395_;
							ValaSourceReference* _tmp396_;
							ValaSourceReference* _tmp397_;
							ValaPropertyAccessor* _tmp398_;
							ValaPropertyAccessor* _tmp399_;
							ValaDynamicProperty* _tmp400_;
							ValaExpression* _tmp401_;
							ValaExpression* _tmp402_;
							ValaDataType* _tmp403_;
							ValaDataType* _tmp404_;
							ValaTypeSymbol* _tmp405_;
							ValaTypeSymbol* _tmp406_;
							ValaScope* _tmp407_;
							ValaScope* _tmp408_;
							ValaObjectType* _tmp409_;
							ValaObjectTypeSymbol* _tmp410_;
							ValaObjectTypeSymbol* _tmp411_;
							ValaScope* _tmp412_;
							ValaScope* _tmp413_;
							ValaDynamicProperty* _tmp414_;
							ValaDynamicProperty* _tmp415_;
							_tmp385_ = vala_member_access_get_inner (self);
							_tmp386_ = _tmp385_;
							_tmp387_ = vala_expression_get_value_type (_tmp386_);
							_tmp388_ = _tmp387_;
							_tmp389_ = self->priv->_member_name;
							_tmp390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp391_ = _tmp390_;
							_tmp392_ = vala_dynamic_property_new (_tmp388_, _tmp389_, _tmp391_, NULL);
							prop = _tmp392_;
							_tmp393_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp393_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp394_ = prop;
							_tmp395_ = prop;
							_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp397_, NULL);
							_tmp399_ = _tmp398_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp394_, _tmp399_);
							_vala_code_node_unref0 (_tmp399_);
							_tmp400_ = prop;
							_tmp401_ = vala_member_access_get_inner (self);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_expression_get_value_type (_tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_data_type_get_data_type (_tmp404_);
							_tmp406_ = _tmp405_;
							_tmp407_ = vala_symbol_get_scope ((ValaSymbol*) _tmp406_);
							_tmp408_ = _tmp407_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp400_, _tmp408_);
							_tmp409_ = dynamic_object_type;
							_tmp410_ = vala_object_type_get_type_symbol (_tmp409_);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_symbol_get_scope ((ValaSymbol*) _tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = prop;
							vala_scope_add (_tmp413_, NULL, (ValaSymbol*) _tmp414_);
							_tmp415_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp415_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp416_ = FALSE;
						gboolean _tmp417_ = FALSE;
						ValaCodeNode* _tmp418_;
						ValaCodeNode* _tmp419_;
						_tmp418_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp419_ = _tmp418_;
						if (VALA_IS_MEMBER_ACCESS (_tmp419_)) {
							ValaExpression* _tmp420_;
							ValaExpression* _tmp421_;
							_tmp420_ = vala_member_access_get_inner (self);
							_tmp421_ = _tmp420_;
							_tmp417_ = VALA_IS_MEMBER_ACCESS (_tmp421_);
						} else {
							_tmp417_ = FALSE;
						}
						if (_tmp417_) {
							ValaCodeNode* _tmp422_;
							ValaCodeNode* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp422_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_code_node_get_parent_node (_tmp423_);
							_tmp425_ = _tmp424_;
							_tmp416_ = VALA_IS_METHOD_CALL (_tmp425_);
						} else {
							_tmp416_ = FALSE;
						}
						if (_tmp416_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp426_;
							ValaCodeNode* _tmp427_;
							ValaMemberAccess* _tmp428_;
							gboolean _tmp429_ = FALSE;
							ValaMemberAccess* _tmp430_;
							const gchar* _tmp431_;
							_tmp426_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp427_ = _tmp426_;
							_tmp428_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp427_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp428_;
							_tmp430_ = ma;
							_tmp431_ = _tmp430_->priv->_member_name;
							if (g_strcmp0 (_tmp431_, "connect") == 0) {
								_tmp429_ = TRUE;
							} else {
								ValaMemberAccess* _tmp432_;
								const gchar* _tmp433_;
								_tmp432_ = ma;
								_tmp433_ = _tmp432_->priv->_member_name;
								_tmp429_ = g_strcmp0 (_tmp433_, "connect_after") == 0;
							}
							if (_tmp429_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp434_;
								ValaExpression* _tmp435_;
								ValaDataType* _tmp436_;
								ValaDataType* _tmp437_;
								const gchar* _tmp438_;
								ValaVoidType* _tmp439_;
								ValaVoidType* _tmp440_;
								ValaSourceReference* _tmp441_;
								ValaSourceReference* _tmp442_;
								ValaDynamicSignal* _tmp443_;
								ValaDynamicSignal* _tmp444_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp445_;
								ValaCodeNode* _tmp446_;
								ValaCodeNode* _tmp447_;
								ValaCodeNode* _tmp448_;
								ValaMethodCall* _tmp449_;
								ValaMethodCall* _tmp450_;
								ValaList* _tmp451_;
								ValaList* _tmp452_;
								gint _tmp453_;
								gint _tmp454_;
								gboolean _tmp455_;
								ValaDynamicSignal* _tmp482_;
								ValaObjectType* _tmp483_;
								ValaObjectTypeSymbol* _tmp484_;
								ValaObjectTypeSymbol* _tmp485_;
								ValaScope* _tmp486_;
								ValaScope* _tmp487_;
								ValaDynamicSignal* _tmp488_;
								ValaDynamicSignal* _tmp489_;
								_tmp434_ = vala_member_access_get_inner (self);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_expression_get_value_type (_tmp435_);
								_tmp437_ = _tmp436_;
								_tmp438_ = self->priv->_member_name;
								_tmp439_ = vala_void_type_new (NULL);
								_tmp440_ = _tmp439_;
								_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp442_ = _tmp441_;
								_tmp443_ = vala_dynamic_signal_new (_tmp437_, _tmp438_, (ValaDataType*) _tmp440_, _tmp442_, NULL);
								_tmp444_ = _tmp443_;
								_vala_code_node_unref0 (_tmp440_);
								s = _tmp444_;
								_tmp445_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_code_node_get_parent_node (_tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp448_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp449_;
								_tmp450_ = mcall;
								_tmp451_ = vala_method_call_get_argument_list (_tmp450_);
								_tmp452_ = _tmp451_;
								_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
								_tmp454_ = _tmp453_;
								_tmp455_ = _tmp454_ > 0;
								_vala_iterable_unref0 (_tmp452_);
								if (_tmp455_) {
									ValaDynamicSignal* _tmp456_;
									ValaMethodCall* _tmp457_;
									ValaList* _tmp458_;
									ValaList* _tmp459_;
									gpointer _tmp460_;
									ValaExpression* _tmp461_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp462_;
									ValaExpression* _tmp463_;
									ValaExpression* _tmp464_;
									gboolean _tmp465_ = FALSE;
									gboolean _tmp466_ = FALSE;
									ValaMemberAccess* _tmp467_;
									_tmp456_ = s;
									_tmp457_ = mcall;
									_tmp458_ = vala_method_call_get_argument_list (_tmp457_);
									_tmp459_ = _tmp458_;
									_tmp460_ = vala_list_get (_tmp459_, 0);
									_tmp461_ = (ValaExpression*) _tmp460_;
									vala_dynamic_signal_set_handler (_tmp456_, _tmp461_);
									_vala_code_node_unref0 (_tmp461_);
									_vala_iterable_unref0 (_tmp459_);
									_tmp462_ = s;
									_tmp463_ = vala_dynamic_signal_get_handler (_tmp462_);
									_tmp464_ = _tmp463_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp464_) ? ((ValaMemberAccess*) _tmp464_) : NULL;
									_tmp467_ = arg;
									if (_tmp467_ == NULL) {
										_tmp466_ = TRUE;
									} else {
										ValaMemberAccess* _tmp468_;
										_tmp468_ = arg;
										_tmp466_ = !vala_code_node_check ((ValaCodeNode*) _tmp468_, context);
									}
									if (_tmp466_) {
										_tmp465_ = TRUE;
									} else {
										ValaMemberAccess* _tmp469_;
										ValaSymbol* _tmp470_;
										ValaSymbol* _tmp471_;
										_tmp469_ = arg;
										_tmp470_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp469_);
										_tmp471_ = _tmp470_;
										_tmp465_ = !VALA_IS_METHOD (_tmp471_);
									}
									if (_tmp465_) {
										ValaDynamicSignal* _tmp472_;
										ValaExpression* _tmp473_;
										ValaExpression* _tmp474_;
										ValaSourceReference* _tmp475_;
										ValaSourceReference* _tmp476_;
										ValaDynamicSignal* _tmp477_;
										gchar* _tmp478_;
										gchar* _tmp479_;
										gchar* _tmp480_;
										gchar* _tmp481_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp472_ = s;
										_tmp473_ = vala_dynamic_signal_get_handler (_tmp472_);
										_tmp474_ = _tmp473_;
										_tmp475_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp474_);
										_tmp476_ = _tmp475_;
										_tmp477_ = s;
										_tmp478_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp477_);
										_tmp479_ = _tmp478_;
										_tmp480_ = g_strdup_printf ("Invalid handler for `%s'", _tmp479_);
										_tmp481_ = _tmp480_;
										vala_report_error (_tmp476_, _tmp481_);
										_g_free0 (_tmp481_);
										_g_free0 (_tmp479_);
									}
								}
								_tmp482_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp482_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp483_ = dynamic_object_type;
								_tmp484_ = vala_object_type_get_type_symbol (_tmp483_);
								_tmp485_ = _tmp484_;
								_tmp486_ = vala_symbol_get_scope ((ValaSymbol*) _tmp485_);
								_tmp487_ = _tmp486_;
								_tmp488_ = s;
								vala_scope_add (_tmp487_, NULL, (ValaSymbol*) _tmp488_);
								_tmp489_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp489_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp490_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp491_ = _tmp490_;
				if (_tmp491_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp492_;
					ValaExpression* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					const gchar* _tmp496_;
					ValaSourceReference* _tmp497_;
					ValaSourceReference* _tmp498_;
					ValaDynamicProperty* _tmp499_;
					ValaDataType* _tmp500_;
					ValaDataType* _tmp501_;
					ValaDynamicProperty* _tmp512_;
					ValaDynamicProperty* _tmp513_;
					ValaDynamicProperty* _tmp514_;
					ValaDataType* _tmp515_;
					ValaDataType* _tmp516_;
					ValaDataType* _tmp517_;
					ValaDataType* _tmp518_;
					ValaDynamicProperty* _tmp519_;
					ValaSourceReference* _tmp520_;
					ValaSourceReference* _tmp521_;
					ValaPropertyAccessor* _tmp522_;
					ValaPropertyAccessor* _tmp523_;
					ValaDynamicProperty* _tmp524_;
					ValaExpression* _tmp525_;
					ValaExpression* _tmp526_;
					ValaDataType* _tmp527_;
					ValaDataType* _tmp528_;
					ValaTypeSymbol* _tmp529_;
					ValaTypeSymbol* _tmp530_;
					ValaScope* _tmp531_;
					ValaScope* _tmp532_;
					ValaObjectType* _tmp533_;
					ValaObjectTypeSymbol* _tmp534_;
					ValaObjectTypeSymbol* _tmp535_;
					ValaScope* _tmp536_;
					ValaScope* _tmp537_;
					ValaDynamicProperty* _tmp538_;
					ValaDynamicProperty* _tmp539_;
					_tmp492_ = vala_member_access_get_inner (self);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_expression_get_value_type (_tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = self->priv->_member_name;
					_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_dynamic_property_new (_tmp495_, _tmp496_, _tmp498_, NULL);
					prop = _tmp499_;
					_tmp500_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp501_ = _tmp500_;
					if (_tmp501_ != NULL) {
						ValaDynamicProperty* _tmp502_;
						ValaDataType* _tmp503_;
						ValaDataType* _tmp504_;
						_tmp502_ = prop;
						_tmp503_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp504_ = _tmp503_;
						vala_property_set_property_type ((ValaProperty*) _tmp502_, _tmp504_);
					} else {
						ValaDynamicProperty* _tmp505_;
						ValaExpression* _tmp506_;
						ValaExpression* _tmp507_;
						ValaDataType* _tmp508_;
						ValaDataType* _tmp509_;
						ValaDataType* _tmp510_;
						ValaDataType* _tmp511_;
						_tmp505_ = prop;
						_tmp506_ = vala_member_access_get_inner (self);
						_tmp507_ = _tmp506_;
						_tmp508_ = vala_expression_get_value_type (_tmp507_);
						_tmp509_ = _tmp508_;
						_tmp510_ = vala_data_type_copy (_tmp509_);
						_tmp511_ = _tmp510_;
						vala_property_set_property_type ((ValaProperty*) _tmp505_, _tmp511_);
						_vala_code_node_unref0 (_tmp511_);
					}
					_tmp512_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp512_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp513_ = prop;
					_tmp514_ = prop;
					_tmp515_ = vala_property_get_property_type ((ValaProperty*) _tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_data_type_copy (_tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = prop;
					_tmp520_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp519_);
					_tmp521_ = _tmp520_;
					_tmp522_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp518_, NULL, _tmp521_, NULL);
					_tmp523_ = _tmp522_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp513_, _tmp523_);
					_vala_code_node_unref0 (_tmp523_);
					_vala_code_node_unref0 (_tmp518_);
					_tmp524_ = prop;
					_tmp525_ = vala_member_access_get_inner (self);
					_tmp526_ = _tmp525_;
					_tmp527_ = vala_expression_get_value_type (_tmp526_);
					_tmp528_ = _tmp527_;
					_tmp529_ = vala_data_type_get_data_type (_tmp528_);
					_tmp530_ = _tmp529_;
					_tmp531_ = vala_symbol_get_scope ((ValaSymbol*) _tmp530_);
					_tmp532_ = _tmp531_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp524_, _tmp532_);
					_tmp533_ = dynamic_object_type;
					_tmp534_ = vala_object_type_get_type_symbol (_tmp533_);
					_tmp535_ = _tmp534_;
					_tmp536_ = vala_symbol_get_scope ((ValaSymbol*) _tmp535_);
					_tmp537_ = _tmp536_;
					_tmp538_ = prop;
					vala_scope_add (_tmp537_, NULL, (ValaSymbol*) _tmp538_);
					_tmp539_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp539_);
					_vala_code_node_unref0 (prop);
				}
				_tmp540_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp541_ = _tmp540_;
				if (_tmp541_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp543_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp544_ = _tmp543_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp544_)) {
				ValaExpression* _tmp545_;
				ValaExpression* _tmp546_;
				ValaDataType* _tmp547_;
				ValaDataType* _tmp548_;
				_tmp545_ = vala_member_access_get_inner (self);
				_tmp546_ = _tmp545_;
				_tmp547_ = vala_expression_get_value_type (_tmp546_);
				_tmp548_ = _tmp547_;
				_tmp542_ = VALA_IS_ARRAY_TYPE (_tmp548_);
			} else {
				_tmp542_ = FALSE;
			}
			if (_tmp542_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp549_;
				ValaExpression* _tmp550_;
				ValaDataType* _tmp551_;
				ValaDataType* _tmp552_;
				gboolean _tmp553_ = FALSE;
				ValaArrayType* _tmp554_;
				_tmp549_ = vala_member_access_get_inner (self);
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_expression_get_value_type (_tmp550_);
				_tmp552_ = _tmp551_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp552_) ? ((ValaArrayType*) _tmp552_) : NULL;
				_tmp554_ = value_array_type;
				if (_tmp554_ != NULL) {
					ValaArrayType* _tmp555_;
					gboolean _tmp556_;
					gboolean _tmp557_;
					_tmp555_ = value_array_type;
					_tmp556_ = vala_array_type_get_inline_allocated (_tmp555_);
					_tmp557_ = _tmp556_;
					_tmp553_ = _tmp557_;
				} else {
					_tmp553_ = FALSE;
				}
				if (_tmp553_) {
					ValaSourceReference* _tmp558_;
					ValaSourceReference* _tmp559_;
					_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp559_ = _tmp558_;
					vala_report_error (_tmp559_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp563_ = vala_member_access_get_inner (self);
	_tmp564_ = _tmp563_;
	if (_tmp564_ == NULL) {
		ValaSymbol* _tmp565_;
		ValaSymbol* _tmp566_;
		_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp566_ = _tmp565_;
		_tmp562_ = _tmp566_ == NULL;
	} else {
		_tmp562_ = FALSE;
	}
	if (_tmp562_) {
		ValaDataType* _tmp567_;
		ValaDataType* _tmp568_;
		_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp568_ = _tmp567_;
		_tmp561_ = _tmp568_ != NULL;
	} else {
		_tmp561_ = FALSE;
	}
	if (_tmp561_) {
		ValaDataType* _tmp569_;
		ValaDataType* _tmp570_;
		ValaTypeSymbol* _tmp571_;
		ValaTypeSymbol* _tmp572_;
		_tmp569_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp570_ = _tmp569_;
		_tmp571_ = vala_data_type_get_data_type (_tmp570_);
		_tmp572_ = _tmp571_;
		_tmp560_ = VALA_IS_ENUM (_tmp572_);
	} else {
		_tmp560_ = FALSE;
	}
	if (_tmp560_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp573_;
		ValaDataType* _tmp574_;
		ValaTypeSymbol* _tmp575_;
		ValaTypeSymbol* _tmp576_;
		ValaEnum* _tmp577_;
		_tmp573_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp574_ = _tmp573_;
		_tmp575_ = vala_data_type_get_data_type (_tmp574_);
		_tmp576_ = _tmp575_;
		_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp576_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp577_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp578_;
			ValaList* _tmp579_;
			gint _val_size = 0;
			ValaList* _tmp580_;
			gint _tmp581_;
			gint _tmp582_;
			gint _val_index = 0;
			_tmp578_ = enum_type;
			_tmp579_ = vala_enum_get_values (_tmp578_);
			_val_list = _tmp579_;
			_tmp580_ = _val_list;
			_tmp581_ = vala_collection_get_size ((ValaCollection*) _tmp580_);
			_tmp582_ = _tmp581_;
			_val_size = _tmp582_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp583_;
				gpointer _tmp584_;
				const gchar* _tmp585_;
				ValaEnumValue* _tmp586_;
				const gchar* _tmp587_;
				const gchar* _tmp588_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp583_ = _val_list;
				_tmp584_ = vala_list_get (_tmp583_, _val_index);
				val = (ValaEnumValue*) _tmp584_;
				_tmp585_ = self->priv->_member_name;
				_tmp586_ = val;
				_tmp587_ = vala_symbol_get_name ((ValaSymbol*) _tmp586_);
				_tmp588_ = _tmp587_;
				if (g_strcmp0 (_tmp585_, _tmp588_) == 0) {
					ValaEnumValue* _tmp589_;
					_tmp589_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp589_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp590_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp591_ = _tmp590_;
	if (_tmp591_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp592_;
		gboolean _tmp593_ = FALSE;
		ValaExpression* _tmp594_;
		ValaExpression* _tmp595_;
		ValaSourceReference* _tmp608_;
		ValaSourceReference* _tmp609_;
		const gchar* _tmp610_;
		const gchar* _tmp611_;
		gchar* _tmp612_;
		gchar* _tmp613_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp592_ = g_strdup ("(null)");
		base_type_name = _tmp592_;
		_tmp594_ = vala_member_access_get_inner (self);
		_tmp595_ = _tmp594_;
		if (_tmp595_ != NULL) {
			ValaExpression* _tmp596_;
			ValaExpression* _tmp597_;
			ValaDataType* _tmp598_;
			ValaDataType* _tmp599_;
			_tmp596_ = vala_member_access_get_inner (self);
			_tmp597_ = _tmp596_;
			_tmp598_ = vala_expression_get_value_type (_tmp597_);
			_tmp599_ = _tmp598_;
			_tmp593_ = _tmp599_ != NULL;
		} else {
			_tmp593_ = FALSE;
		}
		if (_tmp593_) {
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaDataType* _tmp602_;
			ValaDataType* _tmp603_;
			gchar* _tmp604_;
			_tmp600_ = vala_member_access_get_inner (self);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_expression_get_value_type (_tmp601_);
			_tmp603_ = _tmp602_;
			_tmp604_ = vala_code_node_to_string ((ValaCodeNode*) _tmp603_);
			_g_free0 (base_type_name);
			base_type_name = _tmp604_;
		} else {
			ValaSymbol* _tmp605_;
			_tmp605_ = base_symbol;
			if (_tmp605_ != NULL) {
				ValaSymbol* _tmp606_;
				gchar* _tmp607_;
				_tmp606_ = base_symbol;
				_tmp607_ = vala_symbol_get_full_name (_tmp606_);
				_g_free0 (base_type_name);
				base_type_name = _tmp607_;
			}
		}
		_tmp608_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp609_ = _tmp608_;
		_tmp610_ = self->priv->_member_name;
		_tmp611_ = base_type_name;
		_tmp612_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp610_, _tmp611_);
		_tmp613_ = _tmp612_;
		vala_report_error (_tmp609_, _tmp613_);
		_g_free0 (_tmp613_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp614_;
		ValaSymbol* _tmp615_;
		gboolean _tmp616_;
		gboolean _tmp617_;
		_tmp614_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp615_ = _tmp614_;
		_tmp616_ = vala_code_node_get_error ((ValaCodeNode*) _tmp615_);
		_tmp617_ = _tmp616_;
		if (_tmp617_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp618_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp619_ = _tmp618_;
	_tmp620_ = _vala_code_node_ref0 (_tmp619_);
	member = _tmp620_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp621_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp621_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp622_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp622_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp623_;
		ValaLocalVariable* _tmp624_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp625_;
		ValaSymbol* _tmp626_;
		ValaSymbol* _tmp627_;
		ValaBlock* _tmp628_;
		gboolean _tmp629_ = FALSE;
		ValaBlock* _tmp630_;
		_tmp623_ = member;
		_tmp624_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp623_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp624_;
		_tmp625_ = local;
		_tmp626_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp625_);
		_tmp627_ = _tmp626_;
		_tmp628_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp627_) ? ((ValaBlock*) _tmp627_) : NULL);
		block = _tmp628_;
		_tmp630_ = block;
		if (_tmp630_ != NULL) {
			ValaSemanticAnalyzer* _tmp631_;
			ValaSemanticAnalyzer* _tmp632_;
			ValaBlock* _tmp633_;
			ValaSymbol* _tmp634_;
			ValaSymbol* _tmp635_;
			ValaSemanticAnalyzer* _tmp636_;
			ValaSemanticAnalyzer* _tmp637_;
			ValaSymbol* _tmp638_;
			ValaSymbol* _tmp639_;
			_tmp631_ = vala_code_context_get_analyzer (context);
			_tmp632_ = _tmp631_;
			_tmp633_ = block;
			_tmp634_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp632_, (ValaSymbol*) _tmp633_);
			_tmp635_ = _tmp634_;
			_tmp636_ = vala_code_context_get_analyzer (context);
			_tmp637_ = _tmp636_;
			_tmp638_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp637_);
			_tmp639_ = _tmp638_;
			_tmp629_ = _tmp635_ != _tmp639_;
			_vala_code_node_unref0 (_tmp635_);
		} else {
			_tmp629_ = FALSE;
		}
		if (_tmp629_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp640_;
			ValaSemanticAnalyzer* _tmp641_;
			ValaSymbol* _tmp642_;
			ValaSymbol* _tmp643_;
			ValaSymbol* _tmp644_;
			ValaLocalVariable* _tmp657_;
			ValaBlock* _tmp658_;
			_tmp640_ = vala_code_context_get_analyzer (context);
			_tmp641_ = _tmp640_;
			_tmp642_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp641_);
			_tmp643_ = _tmp642_;
			_tmp644_ = _vala_code_node_ref0 (_tmp643_);
			sym = _tmp644_;
			while (TRUE) {
				ValaSymbol* _tmp645_;
				ValaBlock* _tmp646_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp647_;
				ValaMethod* _tmp648_;
				ValaMethod* _tmp649_;
				ValaSymbol* _tmp653_;
				ValaSymbol* _tmp654_;
				ValaSymbol* _tmp655_;
				ValaSymbol* _tmp656_;
				_tmp645_ = sym;
				_tmp646_ = block;
				if (!(_tmp645_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp646_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp647_ = sym;
				_tmp648_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp647_) ? ((ValaMethod*) _tmp647_) : NULL);
				method = _tmp648_;
				_tmp649_ = method;
				if (_tmp649_ != NULL) {
					ValaMethod* _tmp650_;
					ValaMethod* _tmp651_;
					ValaLocalVariable* _tmp652_;
					_tmp650_ = method;
					vala_method_set_closure (_tmp650_, TRUE);
					_tmp651_ = method;
					_tmp652_ = local;
					vala_method_add_captured_variable (_tmp651_, _tmp652_);
				}
				_tmp653_ = sym;
				_tmp654_ = vala_symbol_get_parent_symbol (_tmp653_);
				_tmp655_ = _tmp654_;
				_tmp656_ = _vala_code_node_ref0 (_tmp655_);
				_vala_code_node_unref0 (sym);
				sym = _tmp656_;
				_vala_code_node_unref0 (method);
			}
			_tmp657_ = local;
			vala_local_variable_set_captured (_tmp657_, TRUE);
			_tmp658_ = block;
			vala_block_set_captured (_tmp658_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp659_;
		_tmp659_ = member;
		if (VALA_IS_PARAMETER (_tmp659_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp660_;
			ValaParameter* _tmp661_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp662_;
			ValaSymbol* _tmp663_;
			ValaSymbol* _tmp664_;
			ValaMethod* _tmp665_;
			gboolean _tmp666_ = FALSE;
			gboolean _tmp667_ = FALSE;
			ValaMethod* _tmp668_;
			_tmp660_ = member;
			_tmp661_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp660_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp661_;
			_tmp662_ = param;
			_tmp663_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp662_);
			_tmp664_ = _tmp663_;
			_tmp665_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp664_) ? ((ValaMethod*) _tmp664_) : NULL);
			m = _tmp665_;
			_tmp668_ = m;
			if (_tmp668_ != NULL) {
				ValaMethod* _tmp669_;
				ValaSemanticAnalyzer* _tmp670_;
				ValaSemanticAnalyzer* _tmp671_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				_tmp669_ = m;
				_tmp670_ = vala_code_context_get_analyzer (context);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp667_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp669_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp673_;
			} else {
				_tmp667_ = FALSE;
			}
			if (_tmp667_) {
				ValaParameter* _tmp674_;
				ValaMethod* _tmp675_;
				ValaParameter* _tmp676_;
				ValaParameter* _tmp677_;
				_tmp674_ = param;
				_tmp675_ = m;
				_tmp676_ = vala_method_get_this_parameter (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp666_ = _tmp674_ != _tmp677_;
			} else {
				_tmp666_ = FALSE;
			}
			if (_tmp666_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp678_;
				ValaSemanticAnalyzer* _tmp679_;
				ValaSymbol* _tmp680_;
				ValaSymbol* _tmp681_;
				ValaSymbol* _tmp682_;
				ValaParameter* _tmp693_;
				ValaMethod* _tmp694_;
				ValaBlock* _tmp695_;
				ValaBlock* _tmp696_;
				ValaParameter* _tmp697_;
				ValaParameterDirection _tmp698_;
				ValaParameterDirection _tmp699_;
				_tmp678_ = vala_code_context_get_analyzer (context);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp679_);
				_tmp681_ = _tmp680_;
				_tmp682_ = _vala_code_node_ref0 (_tmp681_);
				sym = _tmp682_;
				while (TRUE) {
					ValaSymbol* _tmp683_;
					ValaMethod* _tmp684_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp685_;
					ValaMethod* _tmp686_;
					ValaMethod* _tmp687_;
					ValaSymbol* _tmp689_;
					ValaSymbol* _tmp690_;
					ValaSymbol* _tmp691_;
					ValaSymbol* _tmp692_;
					_tmp683_ = sym;
					_tmp684_ = m;
					if (!(_tmp683_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp684_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp685_ = sym;
					_tmp686_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp685_) ? ((ValaMethod*) _tmp685_) : NULL);
					method = _tmp686_;
					_tmp687_ = method;
					if (_tmp687_ != NULL) {
						ValaMethod* _tmp688_;
						_tmp688_ = method;
						vala_method_set_closure (_tmp688_, TRUE);
					}
					_tmp689_ = sym;
					_tmp690_ = vala_symbol_get_parent_symbol (_tmp689_);
					_tmp691_ = _tmp690_;
					_tmp692_ = _vala_code_node_ref0 (_tmp691_);
					_vala_code_node_unref0 (sym);
					sym = _tmp692_;
					_vala_code_node_unref0 (method);
				}
				_tmp693_ = param;
				vala_parameter_set_captured (_tmp693_, TRUE);
				_tmp694_ = m;
				_tmp695_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp694_);
				_tmp696_ = _tmp695_;
				vala_block_set_captured (_tmp696_, TRUE);
				_tmp697_ = param;
				_tmp698_ = vala_parameter_get_direction (_tmp697_);
				_tmp699_ = _tmp698_;
				if (_tmp699_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp700_;
					ValaSourceReference* _tmp701_;
					ValaParameter* _tmp702_;
					gchar* _tmp703_;
					gchar* _tmp704_;
					gchar* _tmp705_;
					gchar* _tmp706_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp700_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp701_ = _tmp700_;
					_tmp702_ = param;
					_tmp703_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp702_);
					_tmp704_ = _tmp703_;
					_tmp705_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp704_);
					_tmp706_ = _tmp705_;
					vala_report_error (_tmp701_, _tmp706_);
					_g_free0 (_tmp706_);
					_g_free0 (_tmp704_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp707_;
				ValaSymbol* _tmp708_;
				ValaSymbol* _tmp709_;
				ValaSymbol* _tmp710_;
				ValaSymbol* _tmp711_;
				ValaPropertyAccessor* _tmp712_;
				gboolean _tmp713_ = FALSE;
				gboolean _tmp714_ = FALSE;
				ValaPropertyAccessor* _tmp715_;
				_tmp707_ = param;
				_tmp708_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp707_);
				_tmp709_ = _tmp708_;
				_tmp710_ = vala_symbol_get_parent_symbol (_tmp709_);
				_tmp711_ = _tmp710_;
				_tmp712_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp711_) ? ((ValaPropertyAccessor*) _tmp711_) : NULL);
				acc = _tmp712_;
				_tmp715_ = acc;
				if (_tmp715_ != NULL) {
					ValaPropertyAccessor* _tmp716_;
					ValaSemanticAnalyzer* _tmp717_;
					ValaSemanticAnalyzer* _tmp718_;
					ValaSymbol* _tmp719_;
					ValaSymbol* _tmp720_;
					_tmp716_ = acc;
					_tmp717_ = vala_code_context_get_analyzer (context);
					_tmp718_ = _tmp717_;
					_tmp719_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp718_);
					_tmp720_ = _tmp719_;
					_tmp714_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp720_;
				} else {
					_tmp714_ = FALSE;
				}
				if (_tmp714_) {
					ValaParameter* _tmp721_;
					ValaPropertyAccessor* _tmp722_;
					ValaProperty* _tmp723_;
					ValaProperty* _tmp724_;
					ValaParameter* _tmp725_;
					ValaParameter* _tmp726_;
					_tmp721_ = param;
					_tmp722_ = acc;
					_tmp723_ = vala_property_accessor_get_prop (_tmp722_);
					_tmp724_ = _tmp723_;
					_tmp725_ = vala_property_get_this_parameter (_tmp724_);
					_tmp726_ = _tmp725_;
					_tmp713_ = _tmp721_ != _tmp726_;
				} else {
					_tmp713_ = FALSE;
				}
				if (_tmp713_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp727_;
					ValaSemanticAnalyzer* _tmp728_;
					ValaSymbol* _tmp729_;
					ValaSymbol* _tmp730_;
					ValaSymbol* _tmp731_;
					ValaParameter* _tmp742_;
					ValaPropertyAccessor* _tmp743_;
					ValaBlock* _tmp744_;
					ValaBlock* _tmp745_;
					_tmp727_ = vala_code_context_get_analyzer (context);
					_tmp728_ = _tmp727_;
					_tmp729_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp728_);
					_tmp730_ = _tmp729_;
					_tmp731_ = _vala_code_node_ref0 (_tmp730_);
					sym = _tmp731_;
					while (TRUE) {
						ValaSymbol* _tmp732_;
						ValaMethod* _tmp733_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp734_;
						ValaMethod* _tmp735_;
						ValaMethod* _tmp736_;
						ValaSymbol* _tmp738_;
						ValaSymbol* _tmp739_;
						ValaSymbol* _tmp740_;
						ValaSymbol* _tmp741_;
						_tmp732_ = sym;
						_tmp733_ = m;
						if (!(_tmp732_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp733_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp734_ = sym;
						_tmp735_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp734_) ? ((ValaMethod*) _tmp734_) : NULL);
						method = _tmp735_;
						_tmp736_ = method;
						if (_tmp736_ != NULL) {
							ValaMethod* _tmp737_;
							_tmp737_ = method;
							vala_method_set_closure (_tmp737_, TRUE);
						}
						_tmp738_ = sym;
						_tmp739_ = vala_symbol_get_parent_symbol (_tmp738_);
						_tmp740_ = _tmp739_;
						_tmp741_ = _vala_code_node_ref0 (_tmp740_);
						_vala_code_node_unref0 (sym);
						sym = _tmp741_;
						_vala_code_node_unref0 (method);
					}
					_tmp742_ = param;
					vala_parameter_set_captured (_tmp742_, TRUE);
					_tmp743_ = acc;
					_tmp744_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp743_);
					_tmp745_ = _tmp744_;
					vala_block_set_captured (_tmp745_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp746_;
			_tmp746_ = member;
			if (VALA_IS_FIELD (_tmp746_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp747_;
				ValaField* _tmp748_;
				ValaField* _tmp749_;
				ValaSymbolAccessibility _tmp750_;
				ValaSymbolAccessibility _tmp751_;
				ValaField* _tmp752_;
				ValaMemberBinding _tmp753_;
				ValaMemberBinding _tmp754_;
				ValaField* _tmp755_;
				ValaMemberBinding _tmp756_;
				ValaMemberBinding _tmp757_;
				ValaField* _tmp758_;
				ValaDataType* _tmp759_;
				ValaDataType* _tmp760_;
				_tmp747_ = member;
				_tmp748_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_FIELD, ValaField));
				f = _tmp748_;
				_tmp749_ = f;
				_tmp750_ = vala_symbol_get_access ((ValaSymbol*) _tmp749_);
				_tmp751_ = _tmp750_;
				access = _tmp751_;
				_tmp752_ = f;
				_tmp753_ = vala_field_get_binding (_tmp752_);
				_tmp754_ = _tmp753_;
				instance = _tmp754_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp755_ = f;
				_tmp756_ = vala_field_get_binding (_tmp755_);
				_tmp757_ = _tmp756_;
				klass = _tmp757_ == VALA_MEMBER_BINDING_CLASS;
				_tmp758_ = f;
				_tmp759_ = vala_variable_get_variable_type ((ValaVariable*) _tmp758_);
				_tmp760_ = _tmp759_;
				if (VALA_IS_GENERIC_TYPE (_tmp760_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp761_;
				_tmp761_ = member;
				if (VALA_IS_CONSTANT (_tmp761_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp762_;
					ValaConstant* _tmp763_;
					ValaConstant* _tmp764_;
					ValaSymbolAccessibility _tmp765_;
					ValaSymbolAccessibility _tmp766_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp767_;
					ValaSymbol* _tmp768_;
					ValaSymbol* _tmp769_;
					ValaBlock* _tmp770_;
					gboolean _tmp771_ = FALSE;
					ValaBlock* _tmp772_;
					_tmp762_ = member;
					_tmp763_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp763_;
					_tmp764_ = c;
					_tmp765_ = vala_symbol_get_access ((ValaSymbol*) _tmp764_);
					_tmp766_ = _tmp765_;
					access = _tmp766_;
					_tmp767_ = c;
					_tmp768_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp767_);
					_tmp769_ = _tmp768_;
					_tmp770_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp769_) ? ((ValaBlock*) _tmp769_) : NULL);
					block = _tmp770_;
					_tmp772_ = block;
					if (_tmp772_ != NULL) {
						ValaSemanticAnalyzer* _tmp773_;
						ValaSemanticAnalyzer* _tmp774_;
						ValaBlock* _tmp775_;
						ValaSymbol* _tmp776_;
						ValaSymbol* _tmp777_;
						ValaSemanticAnalyzer* _tmp778_;
						ValaSemanticAnalyzer* _tmp779_;
						ValaSymbol* _tmp780_;
						ValaSymbol* _tmp781_;
						_tmp773_ = vala_code_context_get_analyzer (context);
						_tmp774_ = _tmp773_;
						_tmp775_ = block;
						_tmp776_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp774_, (ValaSymbol*) _tmp775_);
						_tmp777_ = _tmp776_;
						_tmp778_ = vala_code_context_get_analyzer (context);
						_tmp779_ = _tmp778_;
						_tmp780_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp779_);
						_tmp781_ = _tmp780_;
						_tmp771_ = _tmp777_ != _tmp781_;
						_vala_code_node_unref0 (_tmp777_);
					} else {
						_tmp771_ = FALSE;
					}
					if (_tmp771_) {
						ValaSourceReference* _tmp782_;
						ValaSourceReference* _tmp783_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp782_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp783_ = _tmp782_;
						vala_report_error (_tmp783_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp784_;
					_tmp784_ = member;
					if (VALA_IS_METHOD (_tmp784_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp785_;
						ValaMethod* _tmp786_;
						ValaMethod* _tmp787_;
						gboolean _tmp788_;
						gboolean _tmp789_;
						ValaMethod* _tmp891_;
						ValaSymbolAccessibility _tmp892_;
						ValaSymbolAccessibility _tmp893_;
						ValaMethod* _tmp894_;
						ValaMethod* _tmp898_;
						ValaMemberBinding _tmp899_;
						ValaMemberBinding _tmp900_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp919_;
						ValaDataType* _tmp920_;
						ValaDataType* _tmp921_;
						ValaGenericType* _tmp922_;
						gboolean _tmp923_ = FALSE;
						ValaGenericType* _tmp924_;
						_tmp785_ = member;
						_tmp786_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp785_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp786_;
						_tmp787_ = m;
						_tmp788_ = vala_method_get_is_async_callback (_tmp787_);
						_tmp789_ = _tmp788_;
						if (_tmp789_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp790_;
							ValaSemanticAnalyzer* _tmp791_;
							ValaMethod* _tmp792_;
							ValaMethod* _tmp793_;
							ValaMethod* _tmp794_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp795_;
							ValaMethod* _tmp828_;
							ValaSemanticAnalyzer* _tmp829_;
							ValaSemanticAnalyzer* _tmp830_;
							ValaMethod* _tmp831_;
							ValaMethod* _tmp832_;
							ValaMethod* _tmp851_;
							ValaMethod* _tmp852_;
							ValaMethod* _tmp853_;
							ValaSymbol* _tmp854_;
							ValaSymbol* _tmp855_;
							ValaSymbol* _tmp856_;
							_tmp790_ = vala_code_context_get_analyzer (context);
							_tmp791_ = _tmp790_;
							_tmp792_ = vala_semantic_analyzer_get_current_async_method (_tmp791_);
							_tmp793_ = _tmp792_;
							_tmp794_ = _vala_code_node_ref0 (_tmp793_);
							async_method = _tmp794_;
							is_valid_access = FALSE;
							_tmp795_ = async_method;
							if (_tmp795_ != NULL) {
								ValaMethod* _tmp796_;
								ValaMethod* _tmp797_;
								ValaMethod* _tmp798_;
								ValaMethod* _tmp799_;
								gboolean _tmp800_;
								_tmp796_ = m;
								_tmp797_ = async_method;
								_tmp798_ = vala_method_get_callback_method (_tmp797_);
								_tmp799_ = _tmp798_;
								_tmp800_ = _tmp796_ == _tmp799_;
								_vala_code_node_unref0 (_tmp799_);
								if (_tmp800_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp801_ = FALSE;
									ValaMethod* _tmp802_;
									ValaMethod* _tmp803_;
									ValaMethod* _tmp804_;
									_tmp802_ = async_method;
									_tmp803_ = vala_method_get_base_method (_tmp802_);
									_tmp804_ = _tmp803_;
									if (_tmp804_ != NULL) {
										ValaMethod* _tmp805_;
										ValaMethod* _tmp806_;
										ValaMethod* _tmp807_;
										ValaMethod* _tmp808_;
										ValaMethod* _tmp809_;
										ValaMethod* _tmp810_;
										_tmp805_ = m;
										_tmp806_ = async_method;
										_tmp807_ = vala_method_get_base_method (_tmp806_);
										_tmp808_ = _tmp807_;
										_tmp809_ = vala_method_get_callback_method (_tmp808_);
										_tmp810_ = _tmp809_;
										_tmp801_ = _tmp805_ == _tmp810_;
										_vala_code_node_unref0 (_tmp810_);
									} else {
										_tmp801_ = FALSE;
									}
									if (_tmp801_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp811_ = FALSE;
										ValaMethod* _tmp812_;
										ValaMethod* _tmp813_;
										ValaMethod* _tmp814_;
										_tmp812_ = async_method;
										_tmp813_ = vala_method_get_base_interface_method (_tmp812_);
										_tmp814_ = _tmp813_;
										if (_tmp814_ != NULL) {
											ValaMethod* _tmp815_;
											ValaMethod* _tmp816_;
											ValaMethod* _tmp817_;
											ValaMethod* _tmp818_;
											ValaMethod* _tmp819_;
											ValaMethod* _tmp820_;
											_tmp815_ = m;
											_tmp816_ = async_method;
											_tmp817_ = vala_method_get_base_interface_method (_tmp816_);
											_tmp818_ = _tmp817_;
											_tmp819_ = vala_method_get_callback_method (_tmp818_);
											_tmp820_ = _tmp819_;
											_tmp811_ = _tmp815_ == _tmp820_;
											_vala_code_node_unref0 (_tmp820_);
										} else {
											_tmp811_ = FALSE;
										}
										if (_tmp811_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp821_;
								ValaSourceReference* _tmp822_;
								ValaMethod* _tmp823_;
								gchar* _tmp824_;
								gchar* _tmp825_;
								gchar* _tmp826_;
								gchar* _tmp827_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp821_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp822_ = _tmp821_;
								_tmp823_ = m;
								_tmp824_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp823_);
								_tmp825_ = _tmp824_;
								_tmp826_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp825_);
								_tmp827_ = _tmp826_;
								vala_report_error (_tmp822_, _tmp827_);
								_g_free0 (_tmp827_);
								_g_free0 (_tmp825_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp828_ = async_method;
							_tmp829_ = vala_code_context_get_analyzer (context);
							_tmp830_ = _tmp829_;
							_tmp831_ = vala_semantic_analyzer_get_current_method (_tmp830_);
							_tmp832_ = _tmp831_;
							if (_tmp828_ != _tmp832_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp833_;
								ValaSemanticAnalyzer* _tmp834_;
								ValaMethod* _tmp835_;
								ValaMethod* _tmp836_;
								ValaSymbol* _tmp837_;
								ValaMethod* _tmp848_;
								ValaBlock* _tmp849_;
								ValaBlock* _tmp850_;
								_tmp833_ = vala_code_context_get_analyzer (context);
								_tmp834_ = _tmp833_;
								_tmp835_ = vala_semantic_analyzer_get_current_method (_tmp834_);
								_tmp836_ = _tmp835_;
								_tmp837_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp836_);
								sym = _tmp837_;
								while (TRUE) {
									ValaSymbol* _tmp838_;
									ValaMethod* _tmp839_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp840_;
									ValaMethod* _tmp841_;
									ValaMethod* _tmp842_;
									ValaSymbol* _tmp844_;
									ValaSymbol* _tmp845_;
									ValaSymbol* _tmp846_;
									ValaSymbol* _tmp847_;
									_tmp838_ = sym;
									_tmp839_ = async_method;
									if (!(_tmp838_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp839_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp840_ = sym;
									_tmp841_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp840_) ? ((ValaMethod*) _tmp840_) : NULL);
									method = _tmp841_;
									_tmp842_ = method;
									if (_tmp842_ != NULL) {
										ValaMethod* _tmp843_;
										_tmp843_ = method;
										vala_method_set_closure (_tmp843_, TRUE);
									}
									_tmp844_ = sym;
									_tmp845_ = vala_symbol_get_parent_symbol (_tmp844_);
									_tmp846_ = _tmp845_;
									_tmp847_ = _vala_code_node_ref0 (_tmp846_);
									_vala_code_node_unref0 (sym);
									sym = _tmp847_;
									_vala_code_node_unref0 (method);
								}
								_tmp848_ = async_method;
								_tmp849_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp848_);
								_tmp850_ = _tmp849_;
								vala_block_set_captured (_tmp850_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp851_ = async_method;
							_tmp852_ = vala_method_get_callback_method (_tmp851_);
							_vala_code_node_unref0 (m);
							m = _tmp852_;
							_tmp853_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp853_);
							_tmp854_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp855_ = _tmp854_;
							_tmp856_ = _vala_code_node_ref0 (_tmp855_);
							_vala_code_node_unref0 (member);
							member = _tmp856_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp857_;
							ValaMethod* _tmp858_;
							ValaMethod* _tmp859_;
							_tmp857_ = m;
							_tmp858_ = vala_method_get_base_method (_tmp857_);
							_tmp859_ = _tmp858_;
							if (_tmp859_ != NULL) {
								ValaMethod* _tmp860_;
								ValaMethod* _tmp861_;
								ValaMethod* _tmp862_;
								ValaMethod* _tmp863_;
								ValaMethod* _tmp864_;
								ValaSignal* _tmp865_;
								ValaSignal* _tmp866_;
								ValaSymbol* _tmp871_;
								ValaSymbol* _tmp872_;
								ValaSymbol* _tmp873_;
								_tmp860_ = m;
								_tmp861_ = vala_method_get_base_method (_tmp860_);
								_tmp862_ = _tmp861_;
								_tmp863_ = _vala_code_node_ref0 (_tmp862_);
								_vala_code_node_unref0 (m);
								m = _tmp863_;
								_tmp864_ = m;
								_tmp865_ = vala_method_get_signal_reference (_tmp864_);
								_tmp866_ = _tmp865_;
								if (_tmp866_ != NULL) {
									ValaMethod* _tmp867_;
									ValaSignal* _tmp868_;
									ValaSignal* _tmp869_;
									_tmp867_ = m;
									_tmp868_ = vala_method_get_signal_reference (_tmp867_);
									_tmp869_ = _tmp868_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp869_);
								} else {
									ValaMethod* _tmp870_;
									_tmp870_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp870_);
								}
								_tmp871_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp872_ = _tmp871_;
								_tmp873_ = _vala_code_node_ref0 (_tmp872_);
								_vala_code_node_unref0 (member);
								member = _tmp873_;
							} else {
								ValaMethod* _tmp874_;
								ValaMethod* _tmp875_;
								ValaMethod* _tmp876_;
								_tmp874_ = m;
								_tmp875_ = vala_method_get_base_interface_method (_tmp874_);
								_tmp876_ = _tmp875_;
								if (_tmp876_ != NULL) {
									ValaMethod* _tmp877_;
									ValaMethod* _tmp878_;
									ValaMethod* _tmp879_;
									ValaMethod* _tmp880_;
									ValaMethod* _tmp881_;
									ValaSignal* _tmp882_;
									ValaSignal* _tmp883_;
									ValaSymbol* _tmp888_;
									ValaSymbol* _tmp889_;
									ValaSymbol* _tmp890_;
									_tmp877_ = m;
									_tmp878_ = vala_method_get_base_interface_method (_tmp877_);
									_tmp879_ = _tmp878_;
									_tmp880_ = _vala_code_node_ref0 (_tmp879_);
									_vala_code_node_unref0 (m);
									m = _tmp880_;
									_tmp881_ = m;
									_tmp882_ = vala_method_get_signal_reference (_tmp881_);
									_tmp883_ = _tmp882_;
									if (_tmp883_ != NULL) {
										ValaMethod* _tmp884_;
										ValaSignal* _tmp885_;
										ValaSignal* _tmp886_;
										_tmp884_ = m;
										_tmp885_ = vala_method_get_signal_reference (_tmp884_);
										_tmp886_ = _tmp885_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp886_);
									} else {
										ValaMethod* _tmp887_;
										_tmp887_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp887_);
									}
									_tmp888_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp889_ = _tmp888_;
									_tmp890_ = _vala_code_node_ref0 (_tmp889_);
									_vala_code_node_unref0 (member);
									member = _tmp890_;
								}
							}
						}
						_tmp891_ = m;
						_tmp892_ = vala_symbol_get_access ((ValaSymbol*) _tmp891_);
						_tmp893_ = _tmp892_;
						access = _tmp893_;
						_tmp894_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp894_)) {
							ValaMethod* _tmp895_;
							ValaMemberBinding _tmp896_;
							ValaMemberBinding _tmp897_;
							_tmp895_ = m;
							_tmp896_ = vala_method_get_binding (_tmp895_);
							_tmp897_ = _tmp896_;
							instance = _tmp897_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp898_ = m;
						_tmp899_ = vala_method_get_binding (_tmp898_);
						_tmp900_ = _tmp899_;
						klass = _tmp900_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp901_;
							ValaList* _tmp902_;
							gint _param_size = 0;
							ValaList* _tmp903_;
							gint _tmp904_;
							gint _tmp905_;
							gint _param_index = 0;
							_tmp901_ = m;
							_tmp902_ = vala_callable_get_parameters ((ValaCallable*) _tmp901_);
							_param_list = _tmp902_;
							_tmp903_ = _param_list;
							_tmp904_ = vala_collection_get_size ((ValaCollection*) _tmp903_);
							_tmp905_ = _tmp904_;
							_param_size = _tmp905_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp906_;
								gpointer _tmp907_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp908_;
								ValaDataType* _tmp909_;
								ValaDataType* _tmp910_;
								ValaGenericType* _tmp911_;
								gboolean _tmp912_ = FALSE;
								ValaGenericType* _tmp913_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp906_ = _param_list;
								_tmp907_ = vala_list_get (_tmp906_, _param_index);
								param = (ValaParameter*) _tmp907_;
								_tmp908_ = param;
								_tmp909_ = vala_variable_get_variable_type ((ValaVariable*) _tmp908_);
								_tmp910_ = _tmp909_;
								_tmp911_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp910_) ? ((ValaGenericType*) _tmp910_) : NULL);
								generic_type = _tmp911_;
								_tmp913_ = generic_type;
								if (_tmp913_ != NULL) {
									ValaGenericType* _tmp914_;
									ValaTypeParameter* _tmp915_;
									ValaTypeParameter* _tmp916_;
									ValaSymbol* _tmp917_;
									ValaSymbol* _tmp918_;
									_tmp914_ = generic_type;
									_tmp915_ = vala_generic_type_get_type_parameter (_tmp914_);
									_tmp916_ = _tmp915_;
									_tmp917_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp916_);
									_tmp918_ = _tmp917_;
									_tmp912_ = VALA_IS_TYPESYMBOL (_tmp918_);
								} else {
									_tmp912_ = FALSE;
								}
								if (_tmp912_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp919_ = m;
						_tmp920_ = vala_callable_get_return_type ((ValaCallable*) _tmp919_);
						_tmp921_ = _tmp920_;
						_tmp922_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp921_) ? ((ValaGenericType*) _tmp921_) : NULL);
						generic_type = _tmp922_;
						_tmp924_ = generic_type;
						if (_tmp924_ != NULL) {
							ValaGenericType* _tmp925_;
							ValaTypeParameter* _tmp926_;
							ValaTypeParameter* _tmp927_;
							ValaSymbol* _tmp928_;
							ValaSymbol* _tmp929_;
							_tmp925_ = generic_type;
							_tmp926_ = vala_generic_type_get_type_parameter (_tmp925_);
							_tmp927_ = _tmp926_;
							_tmp928_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp927_);
							_tmp929_ = _tmp928_;
							_tmp923_ = VALA_IS_TYPESYMBOL (_tmp929_);
						} else {
							_tmp923_ = FALSE;
						}
						if (_tmp923_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp930_;
						_tmp930_ = member;
						if (VALA_IS_PROPERTY (_tmp930_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp931_;
							ValaProperty* _tmp932_;
							ValaProperty* _tmp933_;
							ValaProperty* _tmp934_;
							ValaProperty* _tmp935_;
							ValaProperty* _tmp936_;
							ValaProperty* _tmp956_;
							ValaSymbolAccessibility _tmp957_;
							ValaSymbolAccessibility _tmp958_;
							gboolean _tmp959_;
							gboolean _tmp960_;
							ValaProperty* _tmp1025_;
							ValaMemberBinding _tmp1026_;
							ValaMemberBinding _tmp1027_;
							ValaProperty* _tmp1028_;
							ValaDataType* _tmp1029_;
							ValaDataType* _tmp1030_;
							_tmp931_ = member;
							_tmp932_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp931_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp932_;
							_tmp933_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp933_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp934_ = prop;
							_tmp935_ = vala_property_get_base_property (_tmp934_);
							_tmp936_ = _tmp935_;
							if (_tmp936_ != NULL) {
								ValaProperty* _tmp937_;
								ValaProperty* _tmp938_;
								ValaProperty* _tmp939_;
								ValaProperty* _tmp940_;
								ValaProperty* _tmp941_;
								ValaSymbol* _tmp942_;
								ValaSymbol* _tmp943_;
								ValaSymbol* _tmp944_;
								_tmp937_ = prop;
								_tmp938_ = vala_property_get_base_property (_tmp937_);
								_tmp939_ = _tmp938_;
								_tmp940_ = _vala_code_node_ref0 (_tmp939_);
								_vala_code_node_unref0 (prop);
								prop = _tmp940_;
								_tmp941_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp941_);
								_tmp942_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp943_ = _tmp942_;
								_tmp944_ = _vala_code_node_ref0 (_tmp943_);
								_vala_code_node_unref0 (member);
								member = _tmp944_;
							} else {
								ValaProperty* _tmp945_;
								ValaProperty* _tmp946_;
								ValaProperty* _tmp947_;
								_tmp945_ = prop;
								_tmp946_ = vala_property_get_base_interface_property (_tmp945_);
								_tmp947_ = _tmp946_;
								if (_tmp947_ != NULL) {
									ValaProperty* _tmp948_;
									ValaProperty* _tmp949_;
									ValaProperty* _tmp950_;
									ValaProperty* _tmp951_;
									ValaProperty* _tmp952_;
									ValaSymbol* _tmp953_;
									ValaSymbol* _tmp954_;
									ValaSymbol* _tmp955_;
									_tmp948_ = prop;
									_tmp949_ = vala_property_get_base_interface_property (_tmp948_);
									_tmp950_ = _tmp949_;
									_tmp951_ = _vala_code_node_ref0 (_tmp950_);
									_vala_code_node_unref0 (prop);
									prop = _tmp951_;
									_tmp952_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp952_);
									_tmp953_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp954_ = _tmp953_;
									_tmp955_ = _vala_code_node_ref0 (_tmp954_);
									_vala_code_node_unref0 (member);
									member = _tmp955_;
								}
							}
							_tmp956_ = prop;
							_tmp957_ = vala_symbol_get_access ((ValaSymbol*) _tmp956_);
							_tmp958_ = _tmp957_;
							access = _tmp958_;
							_tmp959_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp960_ = _tmp959_;
							if (_tmp960_) {
								ValaProperty* _tmp961_;
								ValaPropertyAccessor* _tmp962_;
								ValaPropertyAccessor* _tmp963_;
								ValaProperty* _tmp971_;
								ValaSymbolAccessibility _tmp972_;
								ValaSymbolAccessibility _tmp973_;
								_tmp961_ = prop;
								_tmp962_ = vala_property_get_set_accessor (_tmp961_);
								_tmp963_ = _tmp962_;
								if (_tmp963_ == NULL) {
									ValaSourceReference* _tmp964_;
									ValaSourceReference* _tmp965_;
									ValaProperty* _tmp966_;
									gchar* _tmp967_;
									gchar* _tmp968_;
									gchar* _tmp969_;
									gchar* _tmp970_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp964_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp965_ = _tmp964_;
									_tmp966_ = prop;
									_tmp967_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp966_);
									_tmp968_ = _tmp967_;
									_tmp969_ = g_strdup_printf ("Property `%s' is read-only", _tmp968_);
									_tmp970_ = _tmp969_;
									vala_report_error (_tmp965_, _tmp970_);
									_g_free0 (_tmp970_);
									_g_free0 (_tmp968_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp971_ = prop;
								_tmp972_ = vala_symbol_get_access ((ValaSymbol*) _tmp971_);
								_tmp973_ = _tmp972_;
								if (_tmp973_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp974_;
									ValaPropertyAccessor* _tmp975_;
									ValaPropertyAccessor* _tmp976_;
									ValaSymbolAccessibility _tmp977_;
									ValaSymbolAccessibility _tmp978_;
									_tmp974_ = prop;
									_tmp975_ = vala_property_get_set_accessor (_tmp974_);
									_tmp976_ = _tmp975_;
									_tmp977_ = vala_symbol_get_access ((ValaSymbol*) _tmp976_);
									_tmp978_ = _tmp977_;
									access = _tmp978_;
								} else {
									gboolean _tmp979_ = FALSE;
									ValaProperty* _tmp980_;
									ValaSymbolAccessibility _tmp981_;
									ValaSymbolAccessibility _tmp982_;
									_tmp980_ = prop;
									_tmp981_ = vala_symbol_get_access ((ValaSymbol*) _tmp980_);
									_tmp982_ = _tmp981_;
									if (_tmp982_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp983_;
										ValaPropertyAccessor* _tmp984_;
										ValaPropertyAccessor* _tmp985_;
										ValaSymbolAccessibility _tmp986_;
										ValaSymbolAccessibility _tmp987_;
										_tmp983_ = prop;
										_tmp984_ = vala_property_get_set_accessor (_tmp983_);
										_tmp985_ = _tmp984_;
										_tmp986_ = vala_symbol_get_access ((ValaSymbol*) _tmp985_);
										_tmp987_ = _tmp986_;
										_tmp979_ = _tmp987_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp979_ = FALSE;
									}
									if (_tmp979_) {
										ValaProperty* _tmp988_;
										ValaPropertyAccessor* _tmp989_;
										ValaPropertyAccessor* _tmp990_;
										ValaSymbolAccessibility _tmp991_;
										ValaSymbolAccessibility _tmp992_;
										_tmp988_ = prop;
										_tmp989_ = vala_property_get_set_accessor (_tmp988_);
										_tmp990_ = _tmp989_;
										_tmp991_ = vala_symbol_get_access ((ValaSymbol*) _tmp990_);
										_tmp992_ = _tmp991_;
										access = _tmp992_;
									}
								}
							} else {
								ValaProperty* _tmp993_;
								ValaPropertyAccessor* _tmp994_;
								ValaPropertyAccessor* _tmp995_;
								ValaProperty* _tmp1003_;
								ValaSymbolAccessibility _tmp1004_;
								ValaSymbolAccessibility _tmp1005_;
								_tmp993_ = prop;
								_tmp994_ = vala_property_get_get_accessor (_tmp993_);
								_tmp995_ = _tmp994_;
								if (_tmp995_ == NULL) {
									ValaSourceReference* _tmp996_;
									ValaSourceReference* _tmp997_;
									ValaProperty* _tmp998_;
									gchar* _tmp999_;
									gchar* _tmp1000_;
									gchar* _tmp1001_;
									gchar* _tmp1002_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp996_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp997_ = _tmp996_;
									_tmp998_ = prop;
									_tmp999_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp998_);
									_tmp1000_ = _tmp999_;
									_tmp1001_ = g_strdup_printf ("Property `%s' is write-only", _tmp1000_);
									_tmp1002_ = _tmp1001_;
									vala_report_error (_tmp997_, _tmp1002_);
									_g_free0 (_tmp1002_);
									_g_free0 (_tmp1000_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1003_ = prop;
								_tmp1004_ = vala_symbol_get_access ((ValaSymbol*) _tmp1003_);
								_tmp1005_ = _tmp1004_;
								if (_tmp1005_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1006_;
									ValaPropertyAccessor* _tmp1007_;
									ValaPropertyAccessor* _tmp1008_;
									ValaSymbolAccessibility _tmp1009_;
									ValaSymbolAccessibility _tmp1010_;
									_tmp1006_ = prop;
									_tmp1007_ = vala_property_get_get_accessor (_tmp1006_);
									_tmp1008_ = _tmp1007_;
									_tmp1009_ = vala_symbol_get_access ((ValaSymbol*) _tmp1008_);
									_tmp1010_ = _tmp1009_;
									access = _tmp1010_;
								} else {
									gboolean _tmp1011_ = FALSE;
									ValaProperty* _tmp1012_;
									ValaSymbolAccessibility _tmp1013_;
									ValaSymbolAccessibility _tmp1014_;
									_tmp1012_ = prop;
									_tmp1013_ = vala_symbol_get_access ((ValaSymbol*) _tmp1012_);
									_tmp1014_ = _tmp1013_;
									if (_tmp1014_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1015_;
										ValaPropertyAccessor* _tmp1016_;
										ValaPropertyAccessor* _tmp1017_;
										ValaSymbolAccessibility _tmp1018_;
										ValaSymbolAccessibility _tmp1019_;
										_tmp1015_ = prop;
										_tmp1016_ = vala_property_get_get_accessor (_tmp1015_);
										_tmp1017_ = _tmp1016_;
										_tmp1018_ = vala_symbol_get_access ((ValaSymbol*) _tmp1017_);
										_tmp1019_ = _tmp1018_;
										_tmp1011_ = _tmp1019_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1011_ = FALSE;
									}
									if (_tmp1011_) {
										ValaProperty* _tmp1020_;
										ValaPropertyAccessor* _tmp1021_;
										ValaPropertyAccessor* _tmp1022_;
										ValaSymbolAccessibility _tmp1023_;
										ValaSymbolAccessibility _tmp1024_;
										_tmp1020_ = prop;
										_tmp1021_ = vala_property_get_get_accessor (_tmp1020_);
										_tmp1022_ = _tmp1021_;
										_tmp1023_ = vala_symbol_get_access ((ValaSymbol*) _tmp1022_);
										_tmp1024_ = _tmp1023_;
										access = _tmp1024_;
									}
								}
							}
							_tmp1025_ = prop;
							_tmp1026_ = vala_property_get_binding (_tmp1025_);
							_tmp1027_ = _tmp1026_;
							instance = _tmp1027_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1028_ = prop;
							_tmp1029_ = vala_property_get_property_type (_tmp1028_);
							_tmp1030_ = _tmp1029_;
							if (VALA_IS_GENERIC_TYPE (_tmp1030_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1031_;
							_tmp1031_ = member;
							if (VALA_IS_SIGNAL (_tmp1031_)) {
								ValaSymbol* _tmp1032_;
								ValaSymbolAccessibility _tmp1033_;
								ValaSymbolAccessibility _tmp1034_;
								instance = TRUE;
								_tmp1032_ = member;
								_tmp1033_ = vala_symbol_get_access (_tmp1032_);
								_tmp1034_ = _tmp1033_;
								access = _tmp1034_;
							} else {
								gboolean _tmp1035_ = FALSE;
								gboolean _tmp1036_;
								_tmp1036_ = self->priv->_creation_member;
								if (!_tmp1036_) {
									ValaSymbol* _tmp1037_;
									_tmp1037_ = member;
									_tmp1035_ = VALA_IS_ERROR_CODE (_tmp1037_);
								} else {
									_tmp1035_ = FALSE;
								}
								if (_tmp1035_) {
									ValaSymbol* _tmp1038_;
									ValaConstant* _tmp1039_;
									ValaConstant* _tmp1040_;
									ValaSymbol* _tmp1041_;
									ValaSymbol* _tmp1042_;
									ValaSymbol* _tmp1043_;
									_tmp1038_ = member;
									_tmp1039_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1038_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1040_ = _tmp1039_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1040_);
									_tmp1041_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1042_ = _tmp1041_;
									_tmp1043_ = _vala_code_node_ref0 (_tmp1042_);
									_vala_code_node_unref0 (member);
									member = _tmp1043_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1044_ = member;
	vala_symbol_set_used (_tmp1044_, TRUE);
	_tmp1045_ = member;
	_tmp1046_ = vala_symbol_get_version (_tmp1045_);
	_tmp1047_ = _tmp1046_;
	_tmp1048_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1049_ = _tmp1048_;
	vala_version_attribute_check (_tmp1047_, _tmp1049_);
	_tmp1051_ = access;
	if (_tmp1051_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1052_;
		ValaSymbol* _tmp1053_;
		ValaSymbol* _tmp1054_;
		_tmp1052_ = member;
		_tmp1053_ = vala_symbol_get_parent_symbol (_tmp1052_);
		_tmp1054_ = _tmp1053_;
		_tmp1050_ = VALA_IS_TYPESYMBOL (_tmp1054_);
	} else {
		_tmp1050_ = FALSE;
	}
	if (_tmp1050_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1055_;
		ValaSymbol* _tmp1056_;
		ValaSymbol* _tmp1057_;
		ValaTypeSymbol* _tmp1058_;
		gboolean in_subtype = FALSE;
		_tmp1055_ = member;
		_tmp1056_ = vala_symbol_get_parent_symbol (_tmp1055_);
		_tmp1057_ = _tmp1056_;
		_tmp1058_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1057_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1058_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1059_;
			ValaSemanticAnalyzer* _tmp1060_;
			ValaSymbol* _tmp1061_;
			ValaSymbol* _tmp1062_;
			ValaSymbol* _tmp1063_;
			_tmp1059_ = vala_code_context_get_analyzer (context);
			_tmp1060_ = _tmp1059_;
			_tmp1061_ = vala_semantic_analyzer_get_current_symbol (_tmp1060_);
			_tmp1062_ = _tmp1061_;
			_tmp1063_ = _vala_code_node_ref0 (_tmp1062_);
			this_symbol = _tmp1063_;
			{
				gboolean _tmp1064_ = FALSE;
				_tmp1064_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1069_;
					ValaSymbol* _tmp1070_;
					ValaTypeSymbol* _tmp1071_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1072_;
					ValaClass* _tmp1073_;
					gboolean _tmp1074_ = FALSE;
					ValaClass* _tmp1075_;
					if (!_tmp1064_) {
						ValaSymbol* _tmp1065_;
						ValaSymbol* _tmp1066_;
						ValaSymbol* _tmp1067_;
						ValaSymbol* _tmp1068_;
						_tmp1065_ = this_symbol;
						_tmp1066_ = vala_symbol_get_parent_symbol (_tmp1065_);
						_tmp1067_ = _tmp1066_;
						_tmp1068_ = _vala_code_node_ref0 (_tmp1067_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1068_;
					}
					_tmp1064_ = FALSE;
					_tmp1069_ = this_symbol;
					if (!(_tmp1069_ != NULL)) {
						break;
					}
					_tmp1070_ = this_symbol;
					_tmp1071_ = target_type;
					if (_tmp1070_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1071_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1072_ = this_symbol;
					_tmp1073_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1072_) ? ((ValaClass*) _tmp1072_) : NULL);
					cl = _tmp1073_;
					_tmp1075_ = cl;
					if (_tmp1075_ != NULL) {
						ValaClass* _tmp1076_;
						ValaTypeSymbol* _tmp1077_;
						_tmp1076_ = cl;
						_tmp1077_ = target_type;
						_tmp1074_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1076_, _tmp1077_);
					} else {
						_tmp1074_ = FALSE;
					}
					if (_tmp1074_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1078_;
			ValaSourceReference* _tmp1079_;
			ValaSymbol* _tmp1080_;
			gchar* _tmp1081_;
			gchar* _tmp1082_;
			gchar* _tmp1083_;
			gchar* _tmp1084_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1078_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1079_ = _tmp1078_;
			_tmp1080_ = member;
			_tmp1081_ = vala_symbol_get_full_name (_tmp1080_);
			_tmp1082_ = _tmp1081_;
			_tmp1083_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1082_);
			_tmp1084_ = _tmp1083_;
			vala_report_error (_tmp1079_, _tmp1084_);
			_g_free0 (_tmp1084_);
			_g_free0 (_tmp1082_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1085_;
		_tmp1085_ = access;
		if (_tmp1085_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1086_;
			ValaSymbol* _tmp1087_;
			ValaSymbol* _tmp1088_;
			ValaSymbol* _tmp1089_;
			gboolean in_target_type = FALSE;
			_tmp1086_ = member;
			_tmp1087_ = vala_symbol_get_parent_symbol (_tmp1086_);
			_tmp1088_ = _tmp1087_;
			_tmp1089_ = _vala_code_node_ref0 (_tmp1088_);
			target_type = _tmp1089_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1090_;
				ValaSemanticAnalyzer* _tmp1091_;
				ValaSymbol* _tmp1092_;
				ValaSymbol* _tmp1093_;
				ValaSymbol* _tmp1094_;
				_tmp1090_ = vala_code_context_get_analyzer (context);
				_tmp1091_ = _tmp1090_;
				_tmp1092_ = vala_semantic_analyzer_get_current_symbol (_tmp1091_);
				_tmp1093_ = _tmp1092_;
				_tmp1094_ = _vala_code_node_ref0 (_tmp1093_);
				this_symbol = _tmp1094_;
				{
					gboolean _tmp1095_ = FALSE;
					_tmp1095_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1100_;
						ValaSymbol* _tmp1101_;
						ValaSymbol* _tmp1102_;
						if (!_tmp1095_) {
							ValaSymbol* _tmp1096_;
							ValaSymbol* _tmp1097_;
							ValaSymbol* _tmp1098_;
							ValaSymbol* _tmp1099_;
							_tmp1096_ = this_symbol;
							_tmp1097_ = vala_symbol_get_parent_symbol (_tmp1096_);
							_tmp1098_ = _tmp1097_;
							_tmp1099_ = _vala_code_node_ref0 (_tmp1098_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1099_;
						}
						_tmp1095_ = FALSE;
						_tmp1100_ = this_symbol;
						if (!(_tmp1100_ != NULL)) {
							break;
						}
						_tmp1101_ = target_type;
						_tmp1102_ = this_symbol;
						if (_tmp1101_ == _tmp1102_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1103_;
				ValaSourceReference* _tmp1104_;
				ValaSymbol* _tmp1105_;
				gchar* _tmp1106_;
				gchar* _tmp1107_;
				gchar* _tmp1108_;
				gchar* _tmp1109_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1104_ = _tmp1103_;
				_tmp1105_ = member;
				_tmp1106_ = vala_symbol_get_full_name (_tmp1105_);
				_tmp1107_ = _tmp1106_;
				_tmp1108_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1107_);
				_tmp1109_ = _tmp1108_;
				vala_report_error (_tmp1104_, _tmp1109_);
				_g_free0 (_tmp1109_);
				_g_free0 (_tmp1107_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1111_;
		ValaExpression* _tmp1112_;
		_tmp1111_ = vala_member_access_get_inner (self);
		_tmp1112_ = _tmp1111_;
		_tmp1110_ = _tmp1112_ != NULL;
	} else {
		_tmp1110_ = FALSE;
	}
	if (_tmp1110_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1113_;
		ValaExpression* _tmp1114_;
		ValaDataType* _tmp1115_;
		ValaDataType* _tmp1116_;
		ValaDataType* _tmp1117_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1118_;
		ValaExpression* _tmp1119_;
		ValaDataType* _tmp1120_;
		ValaDataType* _tmp1121_;
		ValaPointerType* _tmp1122_;
		ValaPointerType* _tmp1123_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1128_;
		ValaObjectType* _tmp1129_;
		gboolean _tmp1130_ = FALSE;
		gboolean _tmp1131_ = FALSE;
		ValaObjectType* _tmp1132_;
		_tmp1113_ = vala_member_access_get_inner (self);
		_tmp1114_ = _tmp1113_;
		_tmp1115_ = vala_expression_get_value_type (_tmp1114_);
		_tmp1116_ = _tmp1115_;
		_tmp1117_ = _vala_code_node_ref0 (_tmp1116_);
		instance_type = _tmp1117_;
		_tmp1118_ = vala_member_access_get_inner (self);
		_tmp1119_ = _tmp1118_;
		_tmp1120_ = vala_expression_get_value_type (_tmp1119_);
		_tmp1121_ = _tmp1120_;
		_tmp1122_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1121_) ? ((ValaPointerType*) _tmp1121_) : NULL);
		pointer_type = _tmp1122_;
		_tmp1123_ = pointer_type;
		if (_tmp1123_ != NULL) {
			ValaPointerType* _tmp1124_;
			ValaDataType* _tmp1125_;
			ValaDataType* _tmp1126_;
			ValaDataType* _tmp1127_;
			_tmp1124_ = pointer_type;
			_tmp1125_ = vala_pointer_type_get_base_type (_tmp1124_);
			_tmp1126_ = _tmp1125_;
			_tmp1127_ = _vala_code_node_ref0 (_tmp1126_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1127_;
		}
		_tmp1128_ = instance_type;
		_tmp1129_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1128_) ? ((ValaObjectType*) _tmp1128_) : NULL);
		object_type = _tmp1129_;
		_tmp1132_ = object_type;
		if (_tmp1132_ != NULL) {
			ValaObjectType* _tmp1133_;
			ValaObjectTypeSymbol* _tmp1134_;
			ValaObjectTypeSymbol* _tmp1135_;
			_tmp1133_ = object_type;
			_tmp1134_ = vala_object_type_get_type_symbol (_tmp1133_);
			_tmp1135_ = _tmp1134_;
			_tmp1131_ = vala_object_type_symbol_has_type_parameters (_tmp1135_);
		} else {
			_tmp1131_ = FALSE;
		}
		if (_tmp1131_) {
			ValaDataType* _tmp1136_;
			_tmp1136_ = instance_type;
			_tmp1130_ = !vala_data_type_has_type_arguments (_tmp1136_);
		} else {
			_tmp1130_ = FALSE;
		}
		if (_tmp1130_) {
			ValaExpression* _tmp1137_;
			ValaExpression* _tmp1138_;
			ValaSourceReference* _tmp1139_;
			ValaSourceReference* _tmp1140_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1137_ = vala_member_access_get_inner (self);
			_tmp1138_ = _tmp1137_;
			_tmp1139_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1138_);
			_tmp1140_ = _tmp1139_;
			vala_report_error (_tmp1140_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1142_ = !may_access_instance_members;
	} else {
		_tmp1142_ = FALSE;
	}
	if (_tmp1142_) {
		_tmp1141_ = TRUE;
	} else {
		gboolean _tmp1143_ = FALSE;
		if (klass) {
			_tmp1143_ = !may_access_klass_members;
		} else {
			_tmp1143_ = FALSE;
		}
		_tmp1141_ = _tmp1143_;
	}
	if (_tmp1141_) {
		ValaSymbol* _tmp1144_;
		ValaSymbol* _tmp1145_;
		ValaDataType* _tmp1168_;
		ValaDataType* _tmp1169_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1145_ = _tmp1144_;
		if (VALA_IS_METHOD (_tmp1145_)) {
			ValaSemanticAnalyzer* _tmp1146_;
			ValaSemanticAnalyzer* _tmp1147_;
			ValaSymbol* _tmp1148_;
			ValaSymbol* _tmp1149_;
			gboolean _tmp1150_;
			gboolean _tmp1151_;
			ValaDataType* _tmp1152_;
			ValaDataType* _tmp1153_;
			_tmp1146_ = vala_code_context_get_analyzer (context);
			_tmp1147_ = _tmp1146_;
			_tmp1148_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1149_ = _tmp1148_;
			_tmp1150_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1151_ = _tmp1150_;
			_tmp1152_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1147_, _tmp1149_, _tmp1151_);
			_tmp1153_ = _tmp1152_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1153_);
			_vala_code_node_unref0 (_tmp1153_);
		} else {
			ValaSymbol* _tmp1154_;
			ValaSymbol* _tmp1155_;
			_tmp1154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1155_ = _tmp1154_;
			if (VALA_IS_FIELD (_tmp1155_)) {
				ValaSymbol* _tmp1156_;
				ValaSymbol* _tmp1157_;
				ValaFieldPrototype* _tmp1158_;
				ValaFieldPrototype* _tmp1159_;
				_tmp1156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1157_ = _tmp1156_;
				_tmp1158_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1157_, VALA_TYPE_FIELD, ValaField));
				_tmp1159_ = _tmp1158_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1159_);
				_vala_code_node_unref0 (_tmp1159_);
			} else {
				ValaSymbol* _tmp1160_;
				ValaSymbol* _tmp1161_;
				_tmp1160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1161_ = _tmp1160_;
				if (VALA_IS_PROPERTY (_tmp1161_)) {
					ValaSymbol* _tmp1162_;
					ValaSymbol* _tmp1163_;
					ValaPropertyPrototype* _tmp1164_;
					ValaPropertyPrototype* _tmp1165_;
					_tmp1162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1163_ = _tmp1162_;
					_tmp1164_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1163_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1165_ = _tmp1164_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1165_);
					_vala_code_node_unref0 (_tmp1165_);
				} else {
					ValaInvalidType* _tmp1166_;
					ValaInvalidType* _tmp1167_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1166_ = vala_invalid_type_new ();
					_tmp1167_ = _tmp1166_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1167_);
					_vala_code_node_unref0 (_tmp1167_);
				}
			}
		}
		_tmp1168_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1169_ = _tmp1168_;
		if (_tmp1169_ != NULL) {
			ValaDataType* _tmp1170_;
			ValaDataType* _tmp1171_;
			ValaDataType* _tmp1172_;
			ValaDataType* _tmp1173_;
			gboolean _tmp1174_;
			gboolean _tmp1175_;
			_tmp1170_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1171_ = _tmp1170_;
			_tmp1172_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1173_ = _tmp1172_;
			_tmp1174_ = vala_data_type_get_value_owned (_tmp1173_);
			_tmp1175_ = _tmp1174_;
			vala_data_type_set_value_owned (_tmp1171_, _tmp1175_);
		}
	} else {
		gboolean _tmp1176_ = FALSE;
		gboolean _tmp1197_ = FALSE;
		gboolean _tmp1198_ = FALSE;
		gboolean _tmp1199_ = FALSE;
		gboolean _tmp1200_ = FALSE;
		gboolean _tmp1217_ = FALSE;
		gboolean _tmp1218_ = FALSE;
		gboolean _tmp1219_ = FALSE;
		gboolean _tmp1220_ = FALSE;
		gboolean _tmp1221_ = FALSE;
		gboolean _tmp1222_;
		gboolean _tmp1223_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1250_;
		ValaSymbol* _tmp1251_;
		ValaMethod* _tmp1252_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1253_;
		ValaExpression* _tmp1254_;
		ValaMemberAccess* _tmp1255_;
		gboolean _tmp1256_ = FALSE;
		gboolean _tmp1257_ = FALSE;
		gboolean _tmp1258_ = FALSE;
		gboolean _tmp1259_ = FALSE;
		gboolean _tmp1260_ = FALSE;
		ValaMethod* _tmp1261_;
		ValaSemanticAnalyzer* _tmp1298_;
		ValaSemanticAnalyzer* _tmp1299_;
		ValaSymbol* _tmp1300_;
		ValaSymbol* _tmp1301_;
		gboolean _tmp1302_;
		gboolean _tmp1303_;
		ValaDataType* _tmp1304_;
		ValaDataType* _tmp1305_;
		gboolean _tmp1306_ = FALSE;
		ValaExpression* _tmp1307_;
		ValaExpression* _tmp1308_;
		ValaSymbol* _tmp1321_;
		ValaSymbol* _tmp1322_;
		if (instance) {
			ValaExpression* _tmp1177_;
			ValaExpression* _tmp1178_;
			_tmp1177_ = vala_member_access_get_inner (self);
			_tmp1178_ = _tmp1177_;
			_tmp1176_ = _tmp1178_ == NULL;
		} else {
			_tmp1176_ = FALSE;
		}
		if (_tmp1176_) {
			ValaSourceReference* _tmp1179_;
			ValaSourceReference* _tmp1180_;
			ValaMemberAccess* _tmp1181_;
			ValaMemberAccess* _tmp1182_;
			ValaExpression* _tmp1183_;
			ValaExpression* _tmp1184_;
			ValaParameter* _tmp1185_;
			ValaDataType* _tmp1186_;
			ValaDataType* _tmp1187_;
			ValaDataType* _tmp1188_;
			ValaDataType* _tmp1189_;
			ValaExpression* _tmp1190_;
			ValaExpression* _tmp1191_;
			ValaDataType* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaExpression* _tmp1194_;
			ValaExpression* _tmp1195_;
			ValaParameter* _tmp1196_;
			_tmp1179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1180_ = _tmp1179_;
			_tmp1181_ = vala_member_access_new (NULL, "this", _tmp1180_);
			_tmp1182_ = _tmp1181_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1182_);
			_vala_code_node_unref0 (_tmp1182_);
			_tmp1183_ = vala_member_access_get_inner (self);
			_tmp1184_ = _tmp1183_;
			_tmp1185_ = this_parameter;
			_tmp1186_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1185_);
			_tmp1187_ = _tmp1186_;
			_tmp1188_ = vala_data_type_copy (_tmp1187_);
			_tmp1189_ = _tmp1188_;
			vala_expression_set_value_type (_tmp1184_, _tmp1189_);
			_vala_code_node_unref0 (_tmp1189_);
			_tmp1190_ = vala_member_access_get_inner (self);
			_tmp1191_ = _tmp1190_;
			_tmp1192_ = vala_expression_get_value_type (_tmp1191_);
			_tmp1193_ = _tmp1192_;
			vala_data_type_set_value_owned (_tmp1193_, FALSE);
			_tmp1194_ = vala_member_access_get_inner (self);
			_tmp1195_ = _tmp1194_;
			_tmp1196_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1195_, (ValaSymbol*) _tmp1196_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1200_ = !klass;
		} else {
			_tmp1200_ = FALSE;
		}
		if (_tmp1200_) {
			ValaSymbol* _tmp1201_;
			ValaSymbol* _tmp1202_;
			_tmp1201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1202_ = _tmp1201_;
			_tmp1199_ = !VALA_IS_CREATION_METHOD (_tmp1202_);
		} else {
			_tmp1199_ = FALSE;
		}
		if (_tmp1199_) {
			_tmp1198_ = may_access_instance_members;
		} else {
			_tmp1198_ = FALSE;
		}
		if (_tmp1198_) {
			ValaExpression* _tmp1203_;
			ValaExpression* _tmp1204_;
			_tmp1203_ = vala_member_access_get_inner (self);
			_tmp1204_ = _tmp1203_;
			_tmp1197_ = _tmp1204_ != NULL;
		} else {
			_tmp1197_ = FALSE;
		}
		if (_tmp1197_) {
			ValaExpression* _tmp1205_;
			ValaExpression* _tmp1206_;
			ValaSymbol* _tmp1207_;
			ValaSymbol* _tmp1208_;
			_tmp1205_ = vala_member_access_get_inner (self);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = vala_expression_get_symbol_reference (_tmp1206_);
			_tmp1208_ = _tmp1207_;
			if (VALA_IS_METHOD (_tmp1208_)) {
			} else {
				ValaSourceReference* _tmp1209_;
				ValaSourceReference* _tmp1210_;
				ValaSymbol* _tmp1211_;
				ValaSymbol* _tmp1212_;
				gchar* _tmp1213_;
				gchar* _tmp1214_;
				gchar* _tmp1215_;
				gchar* _tmp1216_;
				_tmp1209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1210_ = _tmp1209_;
				_tmp1211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1212_ = _tmp1211_;
				_tmp1213_ = vala_symbol_get_full_name (_tmp1212_);
				_tmp1214_ = _tmp1213_;
				_tmp1215_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1214_);
				_tmp1216_ = _tmp1215_;
				vala_report_warning (_tmp1210_, _tmp1216_);
				_g_free0 (_tmp1216_);
				_g_free0 (_tmp1214_);
			}
		}
		_tmp1222_ = vala_code_context_get_experimental_non_null (context);
		_tmp1223_ = _tmp1222_;
		if (_tmp1223_) {
			_tmp1221_ = instance;
		} else {
			_tmp1221_ = FALSE;
		}
		if (_tmp1221_) {
			ValaExpression* _tmp1224_;
			ValaExpression* _tmp1225_;
			ValaDataType* _tmp1226_;
			ValaDataType* _tmp1227_;
			gboolean _tmp1228_;
			gboolean _tmp1229_;
			_tmp1224_ = vala_member_access_get_inner (self);
			_tmp1225_ = _tmp1224_;
			_tmp1226_ = vala_expression_get_value_type (_tmp1225_);
			_tmp1227_ = _tmp1226_;
			_tmp1228_ = vala_data_type_get_nullable (_tmp1227_);
			_tmp1229_ = _tmp1228_;
			_tmp1220_ = _tmp1229_;
		} else {
			_tmp1220_ = FALSE;
		}
		if (_tmp1220_) {
			ValaExpression* _tmp1230_;
			ValaExpression* _tmp1231_;
			ValaDataType* _tmp1232_;
			ValaDataType* _tmp1233_;
			_tmp1230_ = vala_member_access_get_inner (self);
			_tmp1231_ = _tmp1230_;
			_tmp1232_ = vala_expression_get_value_type (_tmp1231_);
			_tmp1233_ = _tmp1232_;
			_tmp1219_ = !VALA_IS_POINTER_TYPE (_tmp1233_);
		} else {
			_tmp1219_ = FALSE;
		}
		if (_tmp1219_) {
			ValaExpression* _tmp1234_;
			ValaExpression* _tmp1235_;
			ValaDataType* _tmp1236_;
			ValaDataType* _tmp1237_;
			_tmp1234_ = vala_member_access_get_inner (self);
			_tmp1235_ = _tmp1234_;
			_tmp1236_ = vala_expression_get_value_type (_tmp1235_);
			_tmp1237_ = _tmp1236_;
			_tmp1218_ = !VALA_IS_GENERIC_TYPE (_tmp1237_);
		} else {
			_tmp1218_ = FALSE;
		}
		if (_tmp1218_) {
			ValaExpression* _tmp1238_;
			ValaExpression* _tmp1239_;
			ValaDataType* _tmp1240_;
			ValaDataType* _tmp1241_;
			_tmp1238_ = vala_member_access_get_inner (self);
			_tmp1239_ = _tmp1238_;
			_tmp1240_ = vala_expression_get_value_type (_tmp1239_);
			_tmp1241_ = _tmp1240_;
			_tmp1217_ = !VALA_IS_ARRAY_TYPE (_tmp1241_);
		} else {
			_tmp1217_ = FALSE;
		}
		if (_tmp1217_) {
			ValaSourceReference* _tmp1242_;
			ValaSourceReference* _tmp1243_;
			ValaSymbol* _tmp1244_;
			ValaSymbol* _tmp1245_;
			gchar* _tmp1246_;
			gchar* _tmp1247_;
			gchar* _tmp1248_;
			gchar* _tmp1249_;
			_tmp1242_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1243_ = _tmp1242_;
			_tmp1244_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1245_ = _tmp1244_;
			_tmp1246_ = vala_symbol_get_full_name (_tmp1245_);
			_tmp1247_ = _tmp1246_;
			_tmp1248_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1247_);
			_tmp1249_ = _tmp1248_;
			vala_report_error (_tmp1243_, _tmp1249_);
			_g_free0 (_tmp1249_);
			_g_free0 (_tmp1247_);
		}
		_tmp1250_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1251_ = _tmp1250_;
		_tmp1252_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1251_) ? ((ValaMethod*) _tmp1251_) : NULL);
		m = _tmp1252_;
		_tmp1253_ = vala_member_access_get_inner (self);
		_tmp1254_ = _tmp1253_;
		_tmp1255_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1254_) ? ((ValaMemberAccess*) _tmp1254_) : NULL);
		inner_ma = _tmp1255_;
		_tmp1261_ = m;
		if (_tmp1261_ != NULL) {
			ValaMethod* _tmp1262_;
			ValaMemberBinding _tmp1263_;
			ValaMemberBinding _tmp1264_;
			_tmp1262_ = m;
			_tmp1263_ = vala_method_get_binding (_tmp1262_);
			_tmp1264_ = _tmp1263_;
			_tmp1260_ = _tmp1264_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1260_ = FALSE;
		}
		if (_tmp1260_) {
			ValaMethod* _tmp1265_;
			ValaSymbol* _tmp1266_;
			ValaSymbol* _tmp1267_;
			_tmp1265_ = m;
			_tmp1266_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1265_);
			_tmp1267_ = _tmp1266_;
			_tmp1259_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1267_);
		} else {
			_tmp1259_ = FALSE;
		}
		if (_tmp1259_) {
			ValaExpression* _tmp1268_;
			ValaExpression* _tmp1269_;
			_tmp1268_ = vala_member_access_get_inner (self);
			_tmp1269_ = _tmp1268_;
			_tmp1258_ = _tmp1269_ != NULL;
		} else {
			_tmp1258_ = FALSE;
		}
		if (_tmp1258_) {
			ValaExpression* _tmp1270_;
			ValaExpression* _tmp1271_;
			ValaDataType* _tmp1272_;
			ValaDataType* _tmp1273_;
			_tmp1270_ = vala_member_access_get_inner (self);
			_tmp1271_ = _tmp1270_;
			_tmp1272_ = vala_expression_get_value_type (_tmp1271_);
			_tmp1273_ = _tmp1272_;
			_tmp1257_ = _tmp1273_ == NULL;
		} else {
			_tmp1257_ = FALSE;
		}
		if (_tmp1257_) {
			ValaMemberAccess* _tmp1274_;
			ValaList* _tmp1275_;
			gint _tmp1276_;
			gint _tmp1277_;
			_tmp1274_ = inner_ma;
			_tmp1275_ = _tmp1274_->priv->type_argument_list;
			_tmp1276_ = vala_collection_get_size ((ValaCollection*) _tmp1275_);
			_tmp1277_ = _tmp1276_;
			_tmp1256_ = _tmp1277_ > 0;
		} else {
			_tmp1256_ = FALSE;
		}
		if (_tmp1256_) {
			ValaExpression* _tmp1278_;
			ValaExpression* _tmp1279_;
			ValaMethod* _tmp1280_;
			ValaSymbol* _tmp1281_;
			ValaSymbol* _tmp1282_;
			ValaObjectType* _tmp1283_;
			ValaObjectType* _tmp1284_;
			_tmp1278_ = vala_member_access_get_inner (self);
			_tmp1279_ = _tmp1278_;
			_tmp1280_ = m;
			_tmp1281_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1280_);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1284_ = _tmp1283_;
			vala_expression_set_value_type (_tmp1279_, (ValaDataType*) _tmp1284_);
			_vala_code_node_unref0 (_tmp1284_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1285_;
				ValaList* _tmp1286_;
				ValaList* _tmp1287_;
				gint _type_argument_size = 0;
				ValaList* _tmp1288_;
				gint _tmp1289_;
				gint _tmp1290_;
				gint _type_argument_index = 0;
				_tmp1285_ = inner_ma;
				_tmp1286_ = _tmp1285_->priv->type_argument_list;
				_tmp1287_ = _vala_iterable_ref0 (_tmp1286_);
				_type_argument_list = _tmp1287_;
				_tmp1288_ = _type_argument_list;
				_tmp1289_ = vala_collection_get_size ((ValaCollection*) _tmp1288_);
				_tmp1290_ = _tmp1289_;
				_type_argument_size = _tmp1290_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1291_;
					gpointer _tmp1292_;
					ValaExpression* _tmp1293_;
					ValaExpression* _tmp1294_;
					ValaDataType* _tmp1295_;
					ValaDataType* _tmp1296_;
					ValaDataType* _tmp1297_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1291_ = _type_argument_list;
					_tmp1292_ = vala_list_get (_tmp1291_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1292_;
					_tmp1293_ = vala_member_access_get_inner (self);
					_tmp1294_ = _tmp1293_;
					_tmp1295_ = vala_expression_get_value_type (_tmp1294_);
					_tmp1296_ = _tmp1295_;
					_tmp1297_ = type_argument;
					vala_data_type_add_type_argument (_tmp1296_, _tmp1297_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1298_ = vala_code_context_get_analyzer (context);
		_tmp1299_ = _tmp1298_;
		_tmp1300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1301_ = _tmp1300_;
		_tmp1302_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1303_ = _tmp1302_;
		_tmp1304_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1299_, _tmp1301_, _tmp1303_);
		_tmp1305_ = _tmp1304_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1305_);
		_vala_code_node_unref0 (_tmp1305_);
		_tmp1307_ = vala_member_access_get_inner (self);
		_tmp1308_ = _tmp1307_;
		if (_tmp1308_ != NULL) {
			ValaDataType* _tmp1309_;
			ValaDataType* _tmp1310_;
			_tmp1309_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1310_ = _tmp1309_;
			_tmp1306_ = _tmp1310_ != NULL;
		} else {
			_tmp1306_ = FALSE;
		}
		if (_tmp1306_) {
			ValaDataType* _tmp1311_;
			ValaDataType* _tmp1312_;
			ValaExpression* _tmp1313_;
			ValaExpression* _tmp1314_;
			ValaDataType* _tmp1315_;
			ValaDataType* _tmp1316_;
			ValaDataType* _tmp1317_;
			ValaDataType* _tmp1318_;
			_tmp1311_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1312_ = _tmp1311_;
			_tmp1313_ = vala_member_access_get_inner (self);
			_tmp1314_ = _tmp1313_;
			_tmp1315_ = vala_expression_get_value_type (_tmp1314_);
			_tmp1316_ = _tmp1315_;
			_tmp1317_ = vala_data_type_get_actual_type (_tmp1312_, _tmp1316_, NULL, (ValaCodeNode*) self);
			_tmp1318_ = _tmp1317_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1318_);
			_vala_code_node_unref0 (_tmp1318_);
		} else {
			ValaDataType* _tmp1319_;
			ValaDataType* _tmp1320_;
			_tmp1319_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1320_ = _tmp1319_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1320_);
		}
		_tmp1321_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1322_ = _tmp1321_;
		if (VALA_IS_METHOD (_tmp1322_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1323_;
			ValaSymbol* _tmp1324_;
			ValaMethod* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaDataType* _tmp1327_;
			gboolean _tmp1334_ = FALSE;
			_tmp1323_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1324_ = _tmp1323_;
			_tmp1325_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1324_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1325_;
			_tmp1326_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1327_ = _tmp1326_;
			if (_tmp1327_ != NULL) {
				ValaDataType* _tmp1328_;
				ValaDataType* _tmp1329_;
				ValaDataType* _tmp1330_;
				ValaDataType* _tmp1331_;
				gboolean _tmp1332_;
				gboolean _tmp1333_;
				_tmp1328_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1329_ = _tmp1328_;
				_tmp1330_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = vala_data_type_get_value_owned (_tmp1331_);
				_tmp1333_ = _tmp1332_;
				vala_data_type_set_value_owned (_tmp1329_, _tmp1333_);
			}
			if (instance) {
				ValaMethod* _tmp1335_;
				ValaSymbol* _tmp1336_;
				ValaSymbol* _tmp1337_;
				_tmp1335_ = method;
				_tmp1336_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1335_);
				_tmp1337_ = _tmp1336_;
				_tmp1334_ = VALA_IS_TYPESYMBOL (_tmp1337_);
			} else {
				_tmp1334_ = FALSE;
			}
			if (_tmp1334_) {
				ValaExpression* _tmp1338_;
				ValaExpression* _tmp1339_;
				ValaMethod* _tmp1340_;
				ValaSymbol* _tmp1341_;
				ValaSymbol* _tmp1342_;
				ValaDataType* _tmp1343_;
				ValaDataType* _tmp1344_;
				ValaExpression* _tmp1345_;
				ValaExpression* _tmp1346_;
				ValaDataType* _tmp1347_;
				ValaDataType* _tmp1348_;
				ValaMethod* _tmp1349_;
				ValaParameter* _tmp1350_;
				ValaParameter* _tmp1351_;
				ValaDataType* _tmp1352_;
				ValaDataType* _tmp1353_;
				gboolean _tmp1354_;
				gboolean _tmp1355_;
				_tmp1338_ = vala_member_access_get_inner (self);
				_tmp1339_ = _tmp1338_;
				_tmp1340_ = method;
				_tmp1341_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1340_);
				_tmp1342_ = _tmp1341_;
				_tmp1343_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1342_);
				_tmp1344_ = _tmp1343_;
				vala_expression_set_target_type (_tmp1339_, _tmp1344_);
				_vala_code_node_unref0 (_tmp1344_);
				_tmp1345_ = vala_member_access_get_inner (self);
				_tmp1346_ = _tmp1345_;
				_tmp1347_ = vala_expression_get_target_type (_tmp1346_);
				_tmp1348_ = _tmp1347_;
				_tmp1349_ = method;
				_tmp1350_ = vala_method_get_this_parameter (_tmp1349_);
				_tmp1351_ = _tmp1350_;
				_tmp1352_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1351_);
				_tmp1353_ = _tmp1352_;
				_tmp1354_ = vala_data_type_get_value_owned (_tmp1353_);
				_tmp1355_ = _tmp1354_;
				vala_data_type_set_value_owned (_tmp1348_, _tmp1355_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1356_;
			ValaSymbol* _tmp1357_;
			_tmp1356_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1357_ = _tmp1356_;
			if (VALA_IS_PROPERTY (_tmp1357_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1358_;
				ValaSymbol* _tmp1359_;
				ValaProperty* _tmp1360_;
				gboolean _tmp1361_ = FALSE;
				_tmp1358_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1359_ = _tmp1358_;
				_tmp1360_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1359_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1360_;
				if (instance) {
					ValaProperty* _tmp1362_;
					ValaSymbol* _tmp1363_;
					ValaSymbol* _tmp1364_;
					_tmp1362_ = prop;
					_tmp1363_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1362_);
					_tmp1364_ = _tmp1363_;
					_tmp1361_ = _tmp1364_ != NULL;
				} else {
					_tmp1361_ = FALSE;
				}
				if (_tmp1361_) {
					ValaExpression* _tmp1365_;
					ValaExpression* _tmp1366_;
					ValaProperty* _tmp1367_;
					ValaSymbol* _tmp1368_;
					ValaSymbol* _tmp1369_;
					ValaDataType* _tmp1370_;
					ValaDataType* _tmp1371_;
					_tmp1365_ = vala_member_access_get_inner (self);
					_tmp1366_ = _tmp1365_;
					_tmp1367_ = prop;
					_tmp1368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1367_);
					_tmp1369_ = _tmp1368_;
					_tmp1370_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1369_);
					_tmp1371_ = _tmp1370_;
					vala_expression_set_target_type (_tmp1366_, _tmp1371_);
					_vala_code_node_unref0 (_tmp1371_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1372_ = FALSE;
				gboolean _tmp1373_ = FALSE;
				gboolean _tmp1374_ = FALSE;
				ValaSymbol* _tmp1375_;
				ValaSymbol* _tmp1376_;
				_tmp1375_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1376_ = _tmp1375_;
				if (VALA_IS_FIELD (_tmp1376_)) {
					_tmp1374_ = TRUE;
				} else {
					ValaSymbol* _tmp1377_;
					ValaSymbol* _tmp1378_;
					_tmp1377_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1378_ = _tmp1377_;
					_tmp1374_ = VALA_IS_SIGNAL (_tmp1378_);
				}
				if (_tmp1374_) {
					_tmp1373_ = instance;
				} else {
					_tmp1373_ = FALSE;
				}
				if (_tmp1373_) {
					ValaSymbol* _tmp1379_;
					ValaSymbol* _tmp1380_;
					ValaSymbol* _tmp1381_;
					ValaSymbol* _tmp1382_;
					_tmp1379_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1380_ = _tmp1379_;
					_tmp1381_ = vala_symbol_get_parent_symbol (_tmp1380_);
					_tmp1382_ = _tmp1381_;
					_tmp1372_ = _tmp1382_ != NULL;
				} else {
					_tmp1372_ = FALSE;
				}
				if (_tmp1372_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1383_;
					ValaSymbol* _tmp1384_;
					ValaSymbol* _tmp1385_;
					ValaSymbol* _tmp1386_;
					ValaDataType* _tmp1387_;
					ValaExpression* _tmp1388_;
					ValaExpression* _tmp1389_;
					ValaDataType* _tmp1390_;
					ValaExpression* _tmp1391_;
					ValaExpression* _tmp1392_;
					ValaDataType* _tmp1393_;
					ValaDataType* _tmp1394_;
					ValaDataType* _tmp1395_;
					ValaDataType* _tmp1396_;
					_tmp1383_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1384_ = _tmp1383_;
					_tmp1385_ = vala_symbol_get_parent_symbol (_tmp1384_);
					_tmp1386_ = _tmp1385_;
					_tmp1387_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1386_);
					parent_type = _tmp1387_;
					_tmp1388_ = vala_member_access_get_inner (self);
					_tmp1389_ = _tmp1388_;
					_tmp1390_ = parent_type;
					_tmp1391_ = vala_member_access_get_inner (self);
					_tmp1392_ = _tmp1391_;
					_tmp1393_ = vala_expression_get_value_type (_tmp1392_);
					_tmp1394_ = _tmp1393_;
					_tmp1395_ = vala_data_type_get_actual_type (_tmp1390_, _tmp1394_, NULL, (ValaCodeNode*) self);
					_tmp1396_ = _tmp1395_;
					vala_expression_set_target_type (_tmp1389_, _tmp1396_);
					_vala_code_node_unref0 (_tmp1396_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1397_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1398_ = _tmp1397_;
	if (_tmp1398_ != NULL) {
		ValaDataType* _tmp1399_;
		ValaDataType* _tmp1400_;
		_tmp1399_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1400_ = _tmp1399_;
		vala_code_node_check ((ValaCodeNode*) _tmp1400_, context);
	}
	_tmp1401_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1402_ = _tmp1401_;
	result = !_tmp1402_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

