/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaSignal* sig,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaSignal* sig,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaSignal* sig,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp6_;
		gint _p_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp6_ = _vala_iterable_ref0 (params);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			ValaParameter* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = vala_list_get (_tmp10_, _p_index);
			p = (ValaParameter*) _tmp11_;
			_tmp12_ = ret;
			_tmp13_ = p;
			_tmp14_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_replace (_tmp15_, ",", "_");
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s_%s", _tmp12_, _tmp17_);
			_g_free0 (ret);
			ret = _tmp18_;
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp20_ = _tmp19_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp20_)) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp21_ = ret;
		_tmp22_ = g_strconcat (_tmp21_, "_POINTER", NULL);
		_g_free0 (ret);
		ret = _tmp22_;
	} else {
		gint _tmp23_;
		gint _tmp24_;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == 0) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = ret;
			_tmp26_ = g_strconcat (_tmp25_, "_VOID", NULL);
			_g_free0 (ret);
			ret = _tmp26_;
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_data_type (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_data_type (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_data_type (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							ValaStruct* _tmp25_;
							_tmp22_ = vala_data_type_get_data_type (t);
							_tmp23_ = _tmp22_;
							_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct));
							st = _tmp24_;
							_tmp25_ = st;
							if (vala_struct_is_simple_type (_tmp25_)) {
								ValaTypeSymbol* _tmp26_;
								ValaTypeSymbol* _tmp27_;
								gchar* _tmp28_;
								_tmp26_ = vala_data_type_get_data_type (t);
								_tmp27_ = _tmp26_;
								_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
								result = _tmp28_;
								_vala_code_node_unref0 (st);
								return result;
							} else {
								gchar* _tmp29_;
								_tmp29_ = g_strdup ("gpointer");
								result = _tmp29_;
								_vala_code_node_unref0 (st);
								return result;
							}
							_vala_code_node_unref0 (st);
						} else {
							ValaTypeSymbol* _tmp30_;
							ValaTypeSymbol* _tmp31_;
							_tmp30_ = vala_data_type_get_data_type (t);
							_tmp31_ = _tmp30_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp32_;
								ValaTypeSymbol* _tmp33_;
								ValaEnum* _tmp34_;
								ValaEnum* _tmp35_;
								gboolean _tmp36_;
								gboolean _tmp37_;
								_tmp32_ = vala_data_type_get_data_type (t);
								_tmp33_ = _tmp32_;
								_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_ENUM, ValaEnum));
								en = _tmp34_;
								_tmp35_ = en;
								_tmp36_ = vala_enum_get_is_flags (_tmp35_);
								_tmp37_ = _tmp36_;
								if (_tmp37_) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("guint");
									result = _tmp38_;
									_vala_code_node_unref0 (en);
									return result;
								} else {
									gchar* _tmp39_;
									_tmp39_ = g_strdup ("gint");
									result = _tmp39_;
									_vala_code_node_unref0 (en);
									return result;
								}
								_vala_code_node_unref0 (en);
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp40_;
									_tmp40_ = g_strdup ("gpointer");
									result = _tmp40_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp41_;
										_tmp41_ = g_strdup ("gpointer");
										result = _tmp41_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp42_;
											_tmp42_ = g_strdup ("gpointer");
											result = _tmp42_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean first = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	first = TRUE;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp3_;
		gint _p_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp3_ = _vala_iterable_ref0 (params);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = vala_list_get (_tmp7_, _p_index);
			p = (ValaParameter*) _tmp8_;
			if (first) {
				const gchar* _tmp9_;
				ValaParameter* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp9_ = signature;
				_tmp10_ = p;
				_tmp11_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
				_g_free0 (signature);
				signature = _tmp13_;
				_g_free0 (_tmp12_);
				first = FALSE;
			} else {
				const gchar* _tmp14_;
				ValaParameter* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = signature;
				_tmp15_ = p;
				_tmp16_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf ("%s,%s", _tmp14_, _tmp17_);
				_g_free0 (signature);
				signature = _tmp18_;
				_g_free0 (_tmp17_);
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp20_ = _tmp19_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp20_)) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		if (first) {
			_tmp21_ = "POINTER";
		} else {
			_tmp21_ = ",POINTER";
		}
		_tmp22_ = signature;
		_tmp23_ = g_strconcat (_tmp22_, _tmp21_, NULL);
		_g_free0 (signature);
		signature = _tmp23_;
	} else {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = signature;
			_tmp27_ = g_strconcat (_tmp26_, "VOID", NULL);
			_g_free0 (signature);
			signature = _tmp27_;
		}
	}
	result = signature;
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	ValaTargetValue* _tmp8_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	ValaTargetValue* _tmp11_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeConstant* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaTargetValue* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaTargetValue* _tmp31_;
	ValaCCodeExpression* _tmp32_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp1_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp2_);
		_tmp4_ = (ValaCCodeExpression*) _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_expression_get_value_type (detail_expr);
	_tmp6_ = _tmp5_;
	_tmp7_ = TRUE;
	_tmp8_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp6_, FALSE, node, &_tmp7_);
	detail_value = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = detail_value;
	vala_list_insert ((ValaList*) _tmp10_, 0, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	ccall = _tmp15_;
	_tmp16_ = ccall;
	_tmp17_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = ccall;
	_tmp20_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = ccall;
	_tmp23_ = vala_ccode_constant_new ("NULL");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = detail_value;
	_tmp28_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	vala_ccode_function_add_assignment (_tmp26_, _tmp29_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp31_ = detail_value;
	_tmp32_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp31_);
	result = _tmp32_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	detail_cexpr = _tmp0_;
	_tmp1_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, _tmp1_)) {
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		_tmp2_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
	} else {
		ValaCCodeIdentifier* _tmp5_;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		_tmp5_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp7_;
		_vala_ccode_node_unref0 (_tmp6_);
	}
	_tmp8_ = detail_ccall;
	_tmp9_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp8_, _tmp9_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}

static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCCodeEnum* _tmp1_;
	ValaList* params = NULL;
	ValaList* _tmp15_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp1_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp3_ = _tmp2_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		ValaCCodeEnumValue* _tmp14_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_ccode_enum_value_new (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_ccode_enum_add_value (_tmp4_, _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp15_;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _p_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _p_index = 0;
		_tmp16_ = params;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_p_list = _tmp17_;
		_tmp18_ = _p_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_p_size = _tmp20_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			ValaCCodeFile* _tmp24_;
			GHashFunc _tmp25_;
			GEqualFunc _tmp26_;
			GEqualFunc _tmp27_;
			ValaHashMap* _tmp28_;
			ValaHashMap* _tmp29_;
			ValaCCodeParameter* _tmp30_;
			ValaCCodeParameter* _tmp31_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp21_ = _p_list;
			_tmp22_ = vala_list_get (_tmp21_, _p_index);
			p = (ValaParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp25_ = g_direct_hash;
			_tmp26_ = g_direct_equal;
			_tmp27_ = g_direct_equal;
			_tmp28_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp25_, _tmp26_, _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp23_, _tmp24_, (ValaMap*) _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			_vala_ccode_node_unref0 (_tmp31_);
			_vala_map_unref0 (_tmp29_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp33_ = _tmp32_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp33_)) {
		ValaList* _tmp34_;
		ValaVoidType* _tmp35_;
		ValaVoidType* _tmp36_;
		_tmp34_ = params;
		_tmp35_ = vala_void_type_new (NULL);
		_tmp36_ = _tmp35_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp34_, (ValaDataType*) _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
	} else {
		ValaList* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp37_ = params;
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp39_ = _tmp38_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp37_, _tmp39_);
	}
	_vala_iterable_unref0 (params);
}

static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaSignal* sig,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaCCodeFunctionDeclarator* _tmp111_;
	ValaCCodeParameter* _tmp112_;
	ValaCCodeParameter* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	ValaCCodeFunction* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	ValaCCodeFunctionDeclarator* _tmp118_;
	ValaCCodeTypeDefinition* _tmp119_;
	ValaCCodeTypeDefinition* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunction* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	ValaCCodeVariableDeclarator* _tmp125_;
	ValaCCodeVariableDeclarator* _tmp126_;
	ValaCCodeFunction* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeIdentifier* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeCastExpression* _tmp131_;
	ValaCCodeCastExpression* _tmp132_;
	ValaCCodeVariableDeclarator* _tmp133_;
	ValaCCodeVariableDeclarator* _tmp134_;
	ValaCCodeFunction* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	ValaCCodeVariableDeclarator* _tmp137_;
	ValaCCodeVariableDeclarator* _tmp138_;
	ValaCCodeFunction* _tmp139_;
	ValaCCodeFunction* _tmp140_;
	ValaCCodeVariableDeclarator* _tmp141_;
	ValaCCodeVariableDeclarator* _tmp142_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp143_ = FALSE;
	ValaTypeSymbol* _tmp144_;
	ValaTypeSymbol* _tmp145_;
	ValaCCodeIdentifier* _tmp165_;
	ValaCCodeIdentifier* _tmp166_;
	ValaCCodeFunctionCall* _tmp167_;
	ValaCCodeFunctionCall* _tmp168_;
	ValaCCodeIdentifier* _tmp169_;
	ValaCCodeIdentifier* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	ValaCCodeConstant* _tmp173_;
	ValaCCodeConstant* _tmp174_;
	ValaCCodeBinaryExpression* _tmp175_;
	ValaCCodeBinaryExpression* _tmp176_;
	ValaCCodeFunction* _tmp177_;
	ValaCCodeFunction* _tmp178_;
	ValaCCodeFunctionCall* _tmp179_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp180_;
	ValaCCodeIdentifier* _tmp181_;
	ValaCCodeMemberAccess* _tmp182_;
	ValaCCodeMemberAccess* _tmp183_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp184_;
	ValaCCodeIdentifier* _tmp185_;
	ValaCCodeMemberAccess* _tmp186_;
	ValaCCodeMemberAccess* _tmp187_;
	ValaCCodeMemberAccess* _tmp188_;
	ValaCCodeMemberAccess* _tmp189_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp190_;
	ValaCCodeConstant* _tmp191_;
	ValaCCodeFunctionCall* _tmp192_;
	ValaCCodeFunctionCall* _tmp193_;
	ValaCCodeFunctionCall* _tmp194_;
	ValaCCodeIdentifier* _tmp195_;
	ValaCCodeIdentifier* _tmp196_;
	ValaCCodeFunction* _tmp197_;
	ValaCCodeFunction* _tmp198_;
	ValaCCodeFunctionCall* _tmp199_;
	ValaCCodeFunction* _tmp200_;
	ValaCCodeFunction* _tmp201_;
	ValaCCodeIdentifier* _tmp202_;
	ValaCCodeIdentifier* _tmp203_;
	ValaCCodeMemberAccess* _tmp204_;
	ValaCCodeFunction* _tmp205_;
	ValaCCodeFunction* _tmp206_;
	ValaCCodeIdentifier* _tmp207_;
	ValaCCodeIdentifier* _tmp208_;
	ValaCCodeMemberAccess* _tmp209_;
	ValaCCodeFunction* _tmp210_;
	ValaCCodeFunction* _tmp211_;
	ValaCCodeFunction* _tmp212_;
	ValaCCodeFunction* _tmp213_;
	ValaCCodeIdentifier* _tmp214_;
	ValaCCodeIdentifier* _tmp215_;
	ValaCCodeMemberAccess* _tmp216_;
	ValaCCodeFunction* _tmp217_;
	ValaCCodeFunction* _tmp218_;
	ValaCCodeIdentifier* _tmp219_;
	ValaCCodeIdentifier* _tmp220_;
	ValaCCodeMemberAccess* _tmp221_;
	ValaCCodeFunction* _tmp222_;
	ValaCCodeFunction* _tmp223_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp224_;
	ValaCCodeIdentifier* _tmp225_;
	ValaCCodeIdentifier* _tmp226_;
	ValaCCodeIdentifier* _tmp227_;
	ValaCCodeIdentifier* _tmp228_;
	ValaCCodeIdentifier* _tmp229_;
	ValaCCodeMemberAccess* _tmp230_;
	ValaCCodeMemberAccess* _tmp231_;
	ValaCCodeConditionalExpression* _tmp232_;
	ValaCCodeConditionalExpression* _tmp233_;
	gchar* _tmp234_;
	gchar* _tmp235_;
	ValaCCodeCastExpression* _tmp236_;
	ValaCCodeCastExpression* _tmp237_;
	ValaCCodeFunction* _tmp238_;
	ValaCCodeFunction* _tmp239_;
	ValaCCodeIdentifier* _tmp240_;
	ValaCCodeIdentifier* _tmp241_;
	ValaCCodeCastExpression* _tmp242_;
	ValaCCodeIdentifier* _tmp243_;
	ValaCCodeIdentifier* _tmp244_;
	ValaCCodeFunctionCall* _tmp245_;
	ValaCCodeFunctionCall* _tmp246_;
	ValaCCodeIdentifier* _tmp247_;
	ValaCCodeIdentifier* _tmp248_;
	ValaDataType* _tmp370_;
	ValaDataType* _tmp371_;
	ValaCCodeFunctionCall* _tmp388_;
	ValaCCodeIdentifier* _tmp389_;
	ValaCCodeIdentifier* _tmp390_;
	gboolean _tmp391_ = FALSE;
	ValaTypeSymbol* _tmp392_;
	ValaTypeSymbol* _tmp393_;
	ValaCCodeFile* _tmp422_;
	ValaCCodeFunction* _tmp423_;
	ValaCCodeFile* _tmp424_;
	ValaCCodeFunction* _tmp425_;
	ValaSet* _tmp426_;
	const gchar* _tmp427_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaCCodeFunctionDeclarator* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaParameter* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCCodeParameter* _tmp49_;
			ValaCCodeParameter* _tmp50_;
			gint _tmp51_;
			ValaParameter* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp41_ = _p_list;
			_tmp42_ = vala_list_get (_tmp41_, _p_index);
			p = (ValaParameter*) _tmp42_;
			_tmp43_ = callback_decl;
			_tmp44_ = g_strdup_printf ("arg_%d", n_params);
			_tmp45_ = _tmp44_;
			_tmp46_ = p;
			_tmp47_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_parameter_new (_tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			vala_ccode_function_declarator_add_parameter (_tmp43_, _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
			_tmp51_ = n_params;
			n_params = _tmp51_ + 1;
			_tmp52_ = p;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
			_tmp54_ = _tmp53_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp55_;
				ValaDataType* _tmp56_;
				ValaDataType* _tmp57_;
				ValaArrayType* _tmp58_;
				gchar* length_ctype = NULL;
				ValaArrayType* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = p;
				_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp58_;
				_tmp59_ = array_type;
				_tmp60_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp59_);
				length_ctype = _tmp60_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp61_ = FALSE;
						_tmp61_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							ValaCCodeFunctionDeclarator* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							const gchar* _tmp69_;
							ValaCCodeParameter* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							gint _tmp72_;
							if (!_tmp61_) {
								gint _tmp62_;
								_tmp62_ = j;
								j = _tmp62_ + 1;
							}
							_tmp61_ = FALSE;
							_tmp63_ = array_type;
							_tmp64_ = vala_array_type_get_rank (_tmp63_);
							_tmp65_ = _tmp64_;
							if (!(j < _tmp65_)) {
								break;
							}
							_tmp66_ = callback_decl;
							_tmp67_ = g_strdup_printf ("arg_%d", n_params);
							_tmp68_ = _tmp67_;
							_tmp69_ = length_ctype;
							_tmp70_ = vala_ccode_parameter_new (_tmp68_, _tmp69_);
							_tmp71_ = _tmp70_;
							vala_ccode_function_declarator_add_parameter (_tmp66_, _tmp71_);
							_vala_ccode_node_unref0 (_tmp71_);
							_g_free0 (_tmp68_);
							_tmp72_ = n_params;
							n_params = _tmp72_ + 1;
						}
					}
				}
				_g_free0 (length_ctype);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp73_ = p;
				_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
				_tmp75_ = _tmp74_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDelegateType* _tmp79_;
					ValaDelegate* _tmp80_;
					ValaDelegate* _tmp81_;
					gboolean _tmp82_;
					gboolean _tmp83_;
					_tmp76_ = p;
					_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
					_tmp78_ = _tmp77_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp79_ = delegate_type;
					_tmp80_ = vala_delegate_type_get_delegate_symbol (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_delegate_get_has_target (_tmp81_);
					_tmp83_ = _tmp82_;
					if (_tmp83_) {
						ValaCCodeFunctionDeclarator* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						ValaDataType* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						ValaCCodeParameter* _tmp90_;
						ValaCCodeParameter* _tmp91_;
						gint _tmp92_;
						ValaDelegateType* _tmp93_;
						_tmp84_ = callback_decl;
						_tmp85_ = g_strdup_printf ("arg_%d", n_params);
						_tmp86_ = _tmp85_;
						_tmp87_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
						_tmp88_ = vala_get_ccode_name ((ValaCodeNode*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = vala_ccode_parameter_new (_tmp86_, _tmp89_);
						_tmp91_ = _tmp90_;
						vala_ccode_function_declarator_add_parameter (_tmp84_, _tmp91_);
						_vala_ccode_node_unref0 (_tmp91_);
						_g_free0 (_tmp89_);
						_g_free0 (_tmp86_);
						_tmp92_ = n_params;
						n_params = _tmp92_ + 1;
						_tmp93_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp93_)) {
							ValaCCodeFunctionDeclarator* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaDelegateType* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							ValaCCodeParameter* _tmp100_;
							ValaCCodeParameter* _tmp101_;
							gint _tmp102_;
							_tmp94_ = callback_decl;
							_tmp95_ = g_strdup_printf ("arg_%d", n_params);
							_tmp96_ = _tmp95_;
							_tmp97_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
							_tmp98_ = vala_get_ccode_name ((ValaCodeNode*) _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = vala_ccode_parameter_new (_tmp96_, _tmp99_);
							_tmp101_ = _tmp100_;
							vala_ccode_function_declarator_add_parameter (_tmp94_, _tmp101_);
							_vala_ccode_node_unref0 (_tmp101_);
							_g_free0 (_tmp99_);
							_g_free0 (_tmp96_);
							_tmp102_ = n_params;
							n_params = _tmp102_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp103_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp104_ = _tmp103_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp104_)) {
		ValaCCodeFunctionDeclarator* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		ValaCCodeParameter* _tmp108_;
		ValaCCodeParameter* _tmp109_;
		gint _tmp110_;
		_tmp105_ = callback_decl;
		_tmp106_ = g_strdup_printf ("arg_%d", n_params);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_ccode_parameter_new (_tmp107_, "gpointer");
		_tmp109_ = _tmp108_;
		vala_ccode_function_declarator_add_parameter (_tmp105_, _tmp109_);
		_vala_ccode_node_unref0 (_tmp109_);
		_g_free0 (_tmp107_);
		_tmp110_ = n_params;
		n_params = _tmp110_ + 1;
	}
	_tmp111_ = callback_decl;
	_tmp112_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp113_ = _tmp112_;
	vala_ccode_function_declarator_add_parameter (_tmp111_, _tmp113_);
	_vala_ccode_node_unref0 (_tmp113_);
	_tmp114_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp117_ = _tmp116_;
	_tmp118_ = callback_decl;
	_tmp119_ = vala_ccode_type_definition_new (_tmp117_, (ValaCCodeDeclarator*) _tmp118_);
	_tmp120_ = _tmp119_;
	vala_ccode_function_add_statement (_tmp115_, (ValaCCodeNode*) _tmp120_);
	_vala_ccode_node_unref0 (_tmp120_);
	_g_free0 (_tmp117_);
	_tmp121_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_declaration (_tmp122_, _tmp124_, (ValaCCodeDeclarator*) _tmp126_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp126_);
	_g_free0 (_tmp124_);
	_tmp127_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_identifier_new ("closure");
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp130_, "GCClosure *");
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp132_, NULL);
	_tmp134_ = _tmp133_;
	vala_ccode_function_add_declaration (_tmp128_, "GCClosure *", (ValaCCodeDeclarator*) _tmp134_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp134_);
	_vala_ccode_node_unref0 (_tmp132_);
	_vala_ccode_node_unref0 (_tmp130_);
	_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp138_ = _tmp137_;
	vala_ccode_function_add_declaration (_tmp136_, "gpointer", (ValaCCodeDeclarator*) _tmp138_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp138_);
	_tmp139_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp142_ = _tmp141_;
	vala_ccode_function_add_declaration (_tmp140_, "gpointer", (ValaCCodeDeclarator*) _tmp142_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp142_);
	_tmp144_ = vala_data_type_get_data_type (return_type);
	_tmp145_ = _tmp144_;
	if (_tmp145_ != NULL) {
		_tmp143_ = TRUE;
	} else {
		_tmp143_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp143_) {
		ValaCCodeFunction* _tmp146_;
		ValaCCodeFunction* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeVariableDeclarator* _tmp150_;
		ValaCCodeVariableDeclarator* _tmp151_;
		ValaCCodeIdentifier* _tmp152_;
		ValaCCodeIdentifier* _tmp153_;
		ValaCCodeFunctionCall* _tmp154_;
		ValaCCodeFunctionCall* _tmp155_;
		ValaCCodeIdentifier* _tmp156_;
		ValaCCodeIdentifier* _tmp157_;
		ValaCCodeConstant* _tmp158_;
		ValaCCodeConstant* _tmp159_;
		ValaCCodeBinaryExpression* _tmp160_;
		ValaCCodeBinaryExpression* _tmp161_;
		ValaCCodeFunction* _tmp162_;
		ValaCCodeFunction* _tmp163_;
		ValaCCodeFunctionCall* _tmp164_;
		_tmp146_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp151_ = _tmp150_;
		vala_ccode_function_add_declaration (_tmp147_, _tmp149_, (ValaCCodeDeclarator*) _tmp151_, 0);
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp152_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp153_ = _tmp152_;
		_tmp154_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp153_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp154_;
		_vala_ccode_node_unref0 (_tmp153_);
		_tmp155_ = fc;
		_tmp156_ = vala_ccode_identifier_new ("return_value");
		_tmp157_ = _tmp156_;
		_tmp158_ = vala_ccode_constant_new ("NULL");
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp157_, (ValaCCodeExpression*) _tmp159_);
		_tmp161_ = _tmp160_;
		vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp161_);
		_vala_ccode_node_unref0 (_tmp161_);
		_vala_ccode_node_unref0 (_tmp159_);
		_vala_ccode_node_unref0 (_tmp157_);
		_tmp162_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp163_ = _tmp162_;
		_tmp164_ = fc;
		vala_ccode_function_add_expression (_tmp163_, (ValaCCodeExpression*) _tmp164_);
	}
	_tmp165_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp166_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp167_;
	_vala_ccode_node_unref0 (_tmp166_);
	_tmp168_ = fc;
	_tmp169_ = vala_ccode_identifier_new ("n_param_values");
	_tmp170_ = _tmp169_;
	_tmp171_ = g_strdup_printf ("%i", n_params);
	_tmp172_ = _tmp171_;
	_tmp173_ = vala_ccode_constant_new (_tmp172_);
	_tmp174_ = _tmp173_;
	_tmp175_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp170_, (ValaCCodeExpression*) _tmp174_);
	_tmp176_ = _tmp175_;
	vala_ccode_function_call_add_argument (_tmp168_, (ValaCCodeExpression*) _tmp176_);
	_vala_ccode_node_unref0 (_tmp176_);
	_vala_ccode_node_unref0 (_tmp174_);
	_g_free0 (_tmp172_);
	_vala_ccode_node_unref0 (_tmp170_);
	_tmp177_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp178_ = _tmp177_;
	_tmp179_ = fc;
	vala_ccode_function_add_expression (_tmp178_, (ValaCCodeExpression*) _tmp179_);
	_tmp180_ = vala_ccode_identifier_new ("closure");
	_tmp181_ = _tmp180_;
	_tmp182_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp181_, "data", TRUE);
	_tmp183_ = _tmp182_;
	_vala_ccode_node_unref0 (_tmp181_);
	data = _tmp183_;
	_tmp184_ = vala_ccode_identifier_new ("param_values");
	_tmp185_ = _tmp184_;
	_tmp186_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp185_, "data[0]", TRUE);
	_tmp187_ = _tmp186_;
	_tmp188_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp187_, "v_pointer", FALSE);
	_tmp189_ = _tmp188_;
	_vala_ccode_node_unref0 (_tmp187_);
	_vala_ccode_node_unref0 (_tmp185_);
	param = _tmp189_;
	_tmp190_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp191_ = _tmp190_;
	_tmp192_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp191_);
	_tmp193_ = _tmp192_;
	_vala_ccode_node_unref0 (_tmp191_);
	cond = _tmp193_;
	_tmp194_ = cond;
	_tmp195_ = vala_ccode_identifier_new ("closure");
	_tmp196_ = _tmp195_;
	vala_ccode_function_call_add_argument (_tmp194_, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp196_);
	_tmp197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp198_ = _tmp197_;
	_tmp199_ = cond;
	vala_ccode_function_open_if (_tmp198_, (ValaCCodeExpression*) _tmp199_);
	_tmp200_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_ccode_identifier_new ("data1");
	_tmp203_ = _tmp202_;
	_tmp204_ = data;
	vala_ccode_function_add_assignment (_tmp201_, (ValaCCodeExpression*) _tmp203_, (ValaCCodeExpression*) _tmp204_);
	_vala_ccode_node_unref0 (_tmp203_);
	_tmp205_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp206_ = _tmp205_;
	_tmp207_ = vala_ccode_identifier_new ("data2");
	_tmp208_ = _tmp207_;
	_tmp209_ = param;
	vala_ccode_function_add_assignment (_tmp206_, (ValaCCodeExpression*) _tmp208_, (ValaCCodeExpression*) _tmp209_);
	_vala_ccode_node_unref0 (_tmp208_);
	_tmp210_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp211_ = _tmp210_;
	vala_ccode_function_add_else (_tmp211_);
	_tmp212_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp213_ = _tmp212_;
	_tmp214_ = vala_ccode_identifier_new ("data1");
	_tmp215_ = _tmp214_;
	_tmp216_ = param;
	vala_ccode_function_add_assignment (_tmp213_, (ValaCCodeExpression*) _tmp215_, (ValaCCodeExpression*) _tmp216_);
	_vala_ccode_node_unref0 (_tmp215_);
	_tmp217_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp218_ = _tmp217_;
	_tmp219_ = vala_ccode_identifier_new ("data2");
	_tmp220_ = _tmp219_;
	_tmp221_ = data;
	vala_ccode_function_add_assignment (_tmp218_, (ValaCCodeExpression*) _tmp220_, (ValaCCodeExpression*) _tmp221_);
	_vala_ccode_node_unref0 (_tmp220_);
	_tmp222_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp223_ = _tmp222_;
	vala_ccode_function_close (_tmp223_);
	_tmp224_ = vala_ccode_identifier_new ("marshal_data");
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_ccode_identifier_new ("marshal_data");
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_ccode_identifier_new ("cc");
	_tmp229_ = _tmp228_;
	_tmp230_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp229_, "callback", TRUE);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp225_, (ValaCCodeExpression*) _tmp227_, (ValaCCodeExpression*) _tmp231_);
	_tmp233_ = _tmp232_;
	_tmp234_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp235_ = _tmp234_;
	_tmp236_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp233_, _tmp235_);
	_tmp237_ = _tmp236_;
	_g_free0 (_tmp235_);
	_vala_ccode_node_unref0 (_tmp233_);
	_vala_ccode_node_unref0 (_tmp231_);
	_vala_ccode_node_unref0 (_tmp229_);
	_vala_ccode_node_unref0 (_tmp227_);
	_vala_ccode_node_unref0 (_tmp225_);
	c_assign_rhs = _tmp237_;
	_tmp238_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp239_ = _tmp238_;
	_tmp240_ = vala_ccode_identifier_new ("callback");
	_tmp241_ = _tmp240_;
	_tmp242_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp239_, (ValaCCodeExpression*) _tmp241_, (ValaCCodeExpression*) _tmp242_);
	_vala_ccode_node_unref0 (_tmp241_);
	_tmp243_ = vala_ccode_identifier_new ("callback");
	_tmp244_ = _tmp243_;
	_tmp245_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp244_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp245_;
	_vala_ccode_node_unref0 (_tmp244_);
	_tmp246_ = fc;
	_tmp247_ = vala_ccode_identifier_new ("data1");
	_tmp248_ = _tmp247_;
	vala_ccode_function_call_add_argument (_tmp246_, (ValaCCodeExpression*) _tmp248_);
	_vala_ccode_node_unref0 (_tmp248_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp249_;
		gint _p_size = 0;
		ValaList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gint _p_index = 0;
		_tmp249_ = _vala_iterable_ref0 (params);
		_p_list = _tmp249_;
		_tmp250_ = _p_list;
		_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
		_tmp252_ = _tmp251_;
		_p_size = _tmp252_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp253_;
			gpointer _tmp254_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			ValaParameter* _tmp255_;
			ValaParameterDirection _tmp256_;
			ValaParameterDirection _tmp257_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeIdentifier* _tmp280_;
			ValaCCodeIdentifier* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeBinaryExpression* _tmp286_;
			ValaCCodeBinaryExpression* _tmp287_;
			ValaCCodeFunctionCall* _tmp288_;
			ValaCCodeFunctionCall* _tmp289_;
			gint _tmp290_;
			ValaParameter* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp253_ = _p_list;
			_tmp254_ = vala_list_get (_tmp253_, _p_index);
			p = (ValaParameter*) _tmp254_;
			_tmp255_ = p;
			_tmp256_ = vala_parameter_get_direction (_tmp255_);
			_tmp257_ = _tmp256_;
			if (_tmp257_ != VALA_PARAMETER_DIRECTION_IN) {
				ValaCCodeIdentifier* _tmp258_;
				ValaCCodeIdentifier* _tmp259_;
				ValaCCodeFunctionCall* _tmp260_;
				_tmp258_ = vala_ccode_identifier_new ("g_value_get_pointer");
				_tmp259_ = _tmp258_;
				_tmp260_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp259_);
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp260_;
				_vala_ccode_node_unref0 (_tmp259_);
			} else {
				gboolean _tmp261_ = FALSE;
				ValaParameter* _tmp262_;
				ValaDataType* _tmp263_;
				ValaDataType* _tmp264_;
				_tmp262_ = p;
				_tmp263_ = vala_variable_get_variable_type ((ValaVariable*) _tmp262_);
				_tmp264_ = _tmp263_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp264_, VALA_TYPE_VALUE_TYPE)) {
					ValaParameter* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					gboolean _tmp268_;
					gboolean _tmp269_;
					_tmp265_ = p;
					_tmp266_ = vala_variable_get_variable_type ((ValaVariable*) _tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_data_type_get_nullable (_tmp267_);
					_tmp269_ = _tmp268_;
					_tmp261_ = _tmp269_;
				} else {
					_tmp261_ = FALSE;
				}
				if (_tmp261_) {
					ValaCCodeIdentifier* _tmp270_;
					ValaCCodeIdentifier* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					_tmp270_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp271_ = _tmp270_;
					_tmp272_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp271_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp272_;
					_vala_ccode_node_unref0 (_tmp271_);
				} else {
					ValaParameter* _tmp273_;
					ValaDataType* _tmp274_;
					ValaDataType* _tmp275_;
					ValaCCodeIdentifier* _tmp276_;
					ValaCCodeIdentifier* _tmp277_;
					ValaCCodeFunctionCall* _tmp278_;
					_tmp273_ = p;
					_tmp274_ = vala_variable_get_variable_type ((ValaVariable*) _tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = vala_ccode_base_module_get_value_getter_function ((ValaCCodeBaseModule*) self, _tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp277_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp278_;
					_vala_ccode_node_unref0 (_tmp277_);
				}
			}
			_tmp279_ = inner_fc;
			_tmp280_ = vala_ccode_identifier_new ("param_values");
			_tmp281_ = _tmp280_;
			_tmp282_ = g_strdup_printf ("%i", i);
			_tmp283_ = _tmp282_;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp281_, (ValaCCodeExpression*) _tmp285_);
			_tmp287_ = _tmp286_;
			vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_g_free0 (_tmp283_);
			_vala_ccode_node_unref0 (_tmp281_);
			_tmp288_ = fc;
			_tmp289_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp288_, (ValaCCodeExpression*) _tmp289_);
			_tmp290_ = i;
			i = _tmp290_ + 1;
			_tmp291_ = p;
			_tmp292_ = vala_variable_get_variable_type ((ValaVariable*) _tmp291_);
			_tmp293_ = _tmp292_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp293_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp294_;
				ValaDataType* _tmp295_;
				ValaDataType* _tmp296_;
				ValaArrayType* _tmp297_;
				gchar* length_value_function = NULL;
				ValaArrayType* _tmp298_;
				ValaDataType* _tmp299_;
				ValaDataType* _tmp300_;
				ValaTypeSymbol* _tmp301_;
				ValaTypeSymbol* _tmp302_;
				gchar* _tmp303_;
				gboolean _tmp304_ = FALSE;
				const gchar* _tmp305_;
				_tmp294_ = p;
				_tmp295_ = vala_variable_get_variable_type ((ValaVariable*) _tmp294_);
				_tmp296_ = _tmp295_;
				_tmp297_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp296_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp297_;
				_tmp298_ = array_type;
				_tmp299_ = vala_array_type_get_length_type (_tmp298_);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_data_type_get_data_type (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp302_);
				length_value_function = _tmp303_;
				_tmp305_ = length_value_function;
				if (_tmp305_ != NULL) {
					const gchar* _tmp306_;
					_tmp306_ = length_value_function;
					_tmp304_ = g_strcmp0 (_tmp306_, "") != 0;
				} else {
					_tmp304_ = FALSE;
				}
				_vala_assert (_tmp304_, "length_value_function != null && length_value_function != \"\"");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp307_ = FALSE;
						_tmp307_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp309_;
							gint _tmp310_;
							gint _tmp311_;
							const gchar* _tmp312_;
							ValaCCodeIdentifier* _tmp313_;
							ValaCCodeIdentifier* _tmp314_;
							ValaCCodeFunctionCall* _tmp315_;
							ValaCCodeFunctionCall* _tmp316_;
							ValaCCodeIdentifier* _tmp317_;
							ValaCCodeIdentifier* _tmp318_;
							gchar* _tmp319_;
							gchar* _tmp320_;
							ValaCCodeIdentifier* _tmp321_;
							ValaCCodeIdentifier* _tmp322_;
							ValaCCodeBinaryExpression* _tmp323_;
							ValaCCodeBinaryExpression* _tmp324_;
							ValaCCodeFunctionCall* _tmp325_;
							ValaCCodeFunctionCall* _tmp326_;
							gint _tmp327_;
							if (!_tmp307_) {
								gint _tmp308_;
								_tmp308_ = j;
								j = _tmp308_ + 1;
							}
							_tmp307_ = FALSE;
							_tmp309_ = array_type;
							_tmp310_ = vala_array_type_get_rank (_tmp309_);
							_tmp311_ = _tmp310_;
							if (!(j < _tmp311_)) {
								break;
							}
							_tmp312_ = length_value_function;
							_tmp313_ = vala_ccode_identifier_new (_tmp312_);
							_tmp314_ = _tmp313_;
							_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp315_;
							_vala_ccode_node_unref0 (_tmp314_);
							_tmp316_ = inner_fc;
							_tmp317_ = vala_ccode_identifier_new ("param_values");
							_tmp318_ = _tmp317_;
							_tmp319_ = g_strdup_printf ("%i", i);
							_tmp320_ = _tmp319_;
							_tmp321_ = vala_ccode_identifier_new (_tmp320_);
							_tmp322_ = _tmp321_;
							_tmp323_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp318_, (ValaCCodeExpression*) _tmp322_);
							_tmp324_ = _tmp323_;
							vala_ccode_function_call_add_argument (_tmp316_, (ValaCCodeExpression*) _tmp324_);
							_vala_ccode_node_unref0 (_tmp324_);
							_vala_ccode_node_unref0 (_tmp322_);
							_g_free0 (_tmp320_);
							_vala_ccode_node_unref0 (_tmp318_);
							_tmp325_ = fc;
							_tmp326_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp325_, (ValaCCodeExpression*) _tmp326_);
							_tmp327_ = i;
							i = _tmp327_ + 1;
						}
					}
				}
				_g_free0 (length_value_function);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp328_;
				ValaDataType* _tmp329_;
				ValaDataType* _tmp330_;
				_tmp328_ = p;
				_tmp329_ = vala_variable_get_variable_type ((ValaVariable*) _tmp328_);
				_tmp330_ = _tmp329_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp331_;
					ValaDataType* _tmp332_;
					ValaDataType* _tmp333_;
					ValaDelegateType* _tmp334_;
					ValaDelegate* _tmp335_;
					ValaDelegate* _tmp336_;
					gboolean _tmp337_;
					gboolean _tmp338_;
					_tmp331_ = p;
					_tmp332_ = vala_variable_get_variable_type ((ValaVariable*) _tmp331_);
					_tmp333_ = _tmp332_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp334_ = delegate_type;
					_tmp335_ = vala_delegate_type_get_delegate_symbol (_tmp334_);
					_tmp336_ = _tmp335_;
					_tmp337_ = vala_delegate_get_has_target (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_) {
						ValaCCodeIdentifier* _tmp339_;
						ValaCCodeIdentifier* _tmp340_;
						ValaCCodeFunctionCall* _tmp341_;
						ValaCCodeFunctionCall* _tmp342_;
						ValaCCodeIdentifier* _tmp343_;
						ValaCCodeIdentifier* _tmp344_;
						gchar* _tmp345_;
						gchar* _tmp346_;
						ValaCCodeIdentifier* _tmp347_;
						ValaCCodeIdentifier* _tmp348_;
						ValaCCodeBinaryExpression* _tmp349_;
						ValaCCodeBinaryExpression* _tmp350_;
						ValaCCodeFunctionCall* _tmp351_;
						ValaCCodeFunctionCall* _tmp352_;
						gint _tmp353_;
						ValaDelegateType* _tmp354_;
						_tmp339_ = vala_ccode_identifier_new ("g_value_get_pointer");
						_tmp340_ = _tmp339_;
						_tmp341_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp340_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp341_;
						_vala_ccode_node_unref0 (_tmp340_);
						_tmp342_ = inner_fc;
						_tmp343_ = vala_ccode_identifier_new ("param_values");
						_tmp344_ = _tmp343_;
						_tmp345_ = g_strdup_printf ("%i", i);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_ccode_identifier_new (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp344_, (ValaCCodeExpression*) _tmp348_);
						_tmp350_ = _tmp349_;
						vala_ccode_function_call_add_argument (_tmp342_, (ValaCCodeExpression*) _tmp350_);
						_vala_ccode_node_unref0 (_tmp350_);
						_vala_ccode_node_unref0 (_tmp348_);
						_g_free0 (_tmp346_);
						_vala_ccode_node_unref0 (_tmp344_);
						_tmp351_ = fc;
						_tmp352_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp351_, (ValaCCodeExpression*) _tmp352_);
						_tmp353_ = i;
						i = _tmp353_ + 1;
						_tmp354_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp354_)) {
							ValaCCodeIdentifier* _tmp355_;
							ValaCCodeIdentifier* _tmp356_;
							ValaCCodeFunctionCall* _tmp357_;
							ValaCCodeFunctionCall* _tmp358_;
							ValaCCodeIdentifier* _tmp359_;
							ValaCCodeIdentifier* _tmp360_;
							gchar* _tmp361_;
							gchar* _tmp362_;
							ValaCCodeIdentifier* _tmp363_;
							ValaCCodeIdentifier* _tmp364_;
							ValaCCodeBinaryExpression* _tmp365_;
							ValaCCodeBinaryExpression* _tmp366_;
							ValaCCodeFunctionCall* _tmp367_;
							ValaCCodeFunctionCall* _tmp368_;
							gint _tmp369_;
							_tmp355_ = vala_ccode_identifier_new ("g_value_get_pointer");
							_tmp356_ = _tmp355_;
							_tmp357_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp356_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp357_;
							_vala_ccode_node_unref0 (_tmp356_);
							_tmp358_ = inner_fc;
							_tmp359_ = vala_ccode_identifier_new ("param_values");
							_tmp360_ = _tmp359_;
							_tmp361_ = g_strdup_printf ("%i", i);
							_tmp362_ = _tmp361_;
							_tmp363_ = vala_ccode_identifier_new (_tmp362_);
							_tmp364_ = _tmp363_;
							_tmp365_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp360_, (ValaCCodeExpression*) _tmp364_);
							_tmp366_ = _tmp365_;
							vala_ccode_function_call_add_argument (_tmp358_, (ValaCCodeExpression*) _tmp366_);
							_vala_ccode_node_unref0 (_tmp366_);
							_vala_ccode_node_unref0 (_tmp364_);
							_g_free0 (_tmp362_);
							_vala_ccode_node_unref0 (_tmp360_);
							_tmp367_ = fc;
							_tmp368_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp367_, (ValaCCodeExpression*) _tmp368_);
							_tmp369_ = i;
							i = _tmp369_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp370_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp371_ = _tmp370_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp371_)) {
		ValaCCodeFunctionCall* inner_fc = NULL;
		ValaCCodeIdentifier* _tmp372_;
		ValaCCodeIdentifier* _tmp373_;
		ValaCCodeFunctionCall* _tmp374_;
		ValaCCodeFunctionCall* _tmp375_;
		ValaCCodeFunctionCall* _tmp376_;
		ValaCCodeIdentifier* _tmp377_;
		ValaCCodeIdentifier* _tmp378_;
		gchar* _tmp379_;
		gchar* _tmp380_;
		ValaCCodeIdentifier* _tmp381_;
		ValaCCodeIdentifier* _tmp382_;
		ValaCCodeBinaryExpression* _tmp383_;
		ValaCCodeBinaryExpression* _tmp384_;
		ValaCCodeFunctionCall* _tmp385_;
		ValaCCodeFunctionCall* _tmp386_;
		gint _tmp387_;
		_tmp372_ = vala_ccode_identifier_new ("g_value_get_pointer");
		_tmp373_ = _tmp372_;
		_tmp374_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp373_);
		_tmp375_ = _tmp374_;
		_vala_ccode_node_unref0 (_tmp373_);
		inner_fc = _tmp375_;
		_tmp376_ = inner_fc;
		_tmp377_ = vala_ccode_identifier_new ("param_values");
		_tmp378_ = _tmp377_;
		_tmp379_ = g_strdup_printf ("%i", i);
		_tmp380_ = _tmp379_;
		_tmp381_ = vala_ccode_identifier_new (_tmp380_);
		_tmp382_ = _tmp381_;
		_tmp383_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp378_, (ValaCCodeExpression*) _tmp382_);
		_tmp384_ = _tmp383_;
		vala_ccode_function_call_add_argument (_tmp376_, (ValaCCodeExpression*) _tmp384_);
		_vala_ccode_node_unref0 (_tmp384_);
		_vala_ccode_node_unref0 (_tmp382_);
		_g_free0 (_tmp380_);
		_vala_ccode_node_unref0 (_tmp378_);
		_tmp385_ = fc;
		_tmp386_ = inner_fc;
		vala_ccode_function_call_add_argument (_tmp385_, (ValaCCodeExpression*) _tmp386_);
		_tmp387_ = i;
		i = _tmp387_ + 1;
		_vala_ccode_node_unref0 (inner_fc);
	}
	_tmp388_ = fc;
	_tmp389_ = vala_ccode_identifier_new ("data2");
	_tmp390_ = _tmp389_;
	vala_ccode_function_call_add_argument (_tmp388_, (ValaCCodeExpression*) _tmp390_);
	_vala_ccode_node_unref0 (_tmp390_);
	_tmp392_ = vala_data_type_get_data_type (return_type);
	_tmp393_ = _tmp392_;
	if (_tmp393_ != NULL) {
		_tmp391_ = TRUE;
	} else {
		_tmp391_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp391_) {
		ValaCCodeFunction* _tmp394_;
		ValaCCodeFunction* _tmp395_;
		ValaCCodeIdentifier* _tmp396_;
		ValaCCodeIdentifier* _tmp397_;
		ValaCCodeFunctionCall* _tmp398_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp410_;
		ValaCCodeIdentifier* _tmp411_;
		ValaCCodeIdentifier* _tmp412_;
		ValaCCodeFunctionCall* _tmp413_;
		ValaCCodeIdentifier* _tmp414_;
		ValaCCodeIdentifier* _tmp415_;
		ValaCCodeFunction* _tmp416_;
		ValaCCodeFunction* _tmp417_;
		ValaCCodeFunctionCall* _tmp418_;
		_tmp394_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp395_ = _tmp394_;
		_tmp396_ = vala_ccode_identifier_new ("v_return");
		_tmp397_ = _tmp396_;
		_tmp398_ = fc;
		vala_ccode_function_add_assignment (_tmp395_, (ValaCCodeExpression*) _tmp397_, (ValaCCodeExpression*) _tmp398_);
		_vala_ccode_node_unref0 (_tmp397_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
			gboolean _tmp399_;
			gboolean _tmp400_;
			_tmp399_ = vala_data_type_get_nullable (return_type);
			_tmp400_ = _tmp399_;
			if (_tmp400_) {
				ValaCCodeIdentifier* _tmp401_;
				ValaCCodeIdentifier* _tmp402_;
				ValaCCodeFunctionCall* _tmp403_;
				_tmp401_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp402_ = _tmp401_;
				_tmp403_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp402_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp403_;
				_vala_ccode_node_unref0 (_tmp402_);
			} else {
				ValaCCodeIdentifier* _tmp404_;
				ValaCCodeIdentifier* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				_tmp404_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, return_type);
				_tmp405_ = _tmp404_;
				_tmp406_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp405_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp406_;
				_vala_ccode_node_unref0 (_tmp405_);
			}
		} else {
			ValaCCodeIdentifier* _tmp407_;
			ValaCCodeIdentifier* _tmp408_;
			ValaCCodeFunctionCall* _tmp409_;
			_tmp407_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, return_type);
			_tmp408_ = _tmp407_;
			_tmp409_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp408_);
			_vala_ccode_node_unref0 (set_fc);
			set_fc = _tmp409_;
			_vala_ccode_node_unref0 (_tmp408_);
		}
		_tmp410_ = set_fc;
		_tmp411_ = vala_ccode_identifier_new ("return_value");
		_tmp412_ = _tmp411_;
		vala_ccode_function_call_add_argument (_tmp410_, (ValaCCodeExpression*) _tmp412_);
		_vala_ccode_node_unref0 (_tmp412_);
		_tmp413_ = set_fc;
		_tmp414_ = vala_ccode_identifier_new ("v_return");
		_tmp415_ = _tmp414_;
		vala_ccode_function_call_add_argument (_tmp413_, (ValaCCodeExpression*) _tmp415_);
		_vala_ccode_node_unref0 (_tmp415_);
		_tmp416_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp417_ = _tmp416_;
		_tmp418_ = set_fc;
		vala_ccode_function_add_expression (_tmp417_, (ValaCCodeExpression*) _tmp418_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp419_;
		ValaCCodeFunction* _tmp420_;
		ValaCCodeFunctionCall* _tmp421_;
		_tmp419_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp420_ = _tmp419_;
		_tmp421_ = fc;
		vala_ccode_function_add_expression (_tmp420_, (ValaCCodeExpression*) _tmp421_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp422_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp423_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp422_, _tmp423_);
	_tmp424_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp425_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp424_, _tmp425_);
	_tmp426_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp427_ = signature;
	vala_collection_add ((ValaCollection*) _tmp426_, _tmp427_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp34_;
	ValaVersionAttribute* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	ValaCCodeFunctionCall* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaMethod* _tmp46_;
	ValaMethod* _tmp47_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeConstant* _tmp77_;
	ValaCCodeConstant* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeConstant* _tmp80_;
	ValaCCodeConstant* _tmp81_;
	ValaList* params = NULL;
	ValaList* _tmp82_;
	gchar* marshaller = NULL;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	gboolean _tmp97_ = FALSE;
	ValaDataType* _tmp98_;
	ValaDataType* _tmp99_;
	gint params_len = 0;
	ValaDataType* _tmp171_;
	ValaDataType* _tmp172_;
	ValaCCodeFunctionCall* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	ValaCCodeConstant* _tmp177_;
	ValaCCodeConstant* _tmp178_;
	ValaDataType* _tmp290_;
	ValaDataType* _tmp291_;
	ValaCCodeIdentifier* _tmp295_;
	const gchar* _tmp296_;
	ValaCCodeExpression* _tmp297_;
	ValaCCodeExpression* _tmp298_;
	ValaCCodeFunctionCall* _tmp299_;
	ValaCCodeAssignment* _tmp300_;
	ValaCCodeExpression* _tmp301_;
	ValaCCodeExpression* result = NULL;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		_tmp19_ = flags;
		_tmp19__length1 = flags_length1;
		_tmp20_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp20_);
	} else {
		const gchar* _tmp21_;
		_tmp21_ = run_type;
		if (g_strcmp0 (_tmp21_, "cleanup") == 0) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
			_tmp22_ = flags;
			_tmp22__length1 = flags_length1;
			_tmp23_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		} else {
			gchar** _tmp24_;
			gint _tmp24__length1;
			gchar* _tmp25_;
			_tmp24_ = flags;
			_tmp24__length1 = flags_length1;
			_tmp25_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp25_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = flags;
		_tmp26__length1 = flags_length1;
		_tmp27_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = flags;
		_tmp28__length1 = flags_length1;
		_tmp29_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp29_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		_tmp30_ = flags;
		_tmp30__length1 = flags_length1;
		_tmp31_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		_tmp32_ = flags;
		_tmp32__length1 = flags_length1;
		_tmp33_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_version_attribute_get_deprecated (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		_tmp38_ = flags;
		_tmp38__length1 = flags_length1;
		_tmp39_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp39_);
	}
	_tmp40_ = csignew;
	_tmp41_ = flags;
	_tmp41__length1 = flags_length1;
	_tmp42_ = _vala_g_strjoinv (" | ", _tmp41_, (gint) _tmp41__length1);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_constant_new (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = vala_signal_get_default_handler (sig);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeConstant* _tmp49_;
		ValaCCodeConstant* _tmp50_;
		_tmp48_ = csignew;
		_tmp49_ = vala_ccode_constant_new ("0");
		_tmp50_ = _tmp49_;
		vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp50_);
		_vala_ccode_node_unref0 (_tmp50_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		_tmp51_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp52_);
		_tmp54_ = _tmp53_;
		_vala_ccode_node_unref0 (_tmp52_);
		struct_offset = _tmp54_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeIdentifier* _tmp61_;
			_tmp55_ = struct_offset;
			_tmp56_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("%sClass", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_identifier_new (_tmp59_);
			_tmp61_ = _tmp60_;
			vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (_tmp61_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			_tmp62_ = struct_offset;
			_tmp63_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_identifier_new (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp66_);
			_vala_ccode_node_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
		}
		_tmp67_ = struct_offset;
		_tmp68_ = vala_signal_get_default_handler (sig);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_vfunc_name (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_identifier_new (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_g_free0 (_tmp71_);
		_tmp74_ = csignew;
		_tmp75_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp76_ = csignew;
	_tmp77_ = vala_ccode_constant_new ("NULL");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = csignew;
	_tmp80_ = vala_ccode_constant_new ("NULL");
	_tmp81_ = _tmp80_;
	vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
	_vala_ccode_node_unref0 (_tmp81_);
	_tmp82_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp82_;
	_tmp83_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp84_ = _tmp83_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp84_)) {
		ValaList* _tmp85_;
		ValaVoidType* _tmp86_;
		ValaVoidType* _tmp87_;
		gchar* _tmp88_;
		_tmp85_ = params;
		_tmp86_ = vala_void_type_new (NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp85_, (ValaDataType*) _tmp87_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp88_;
		_vala_code_node_unref0 (_tmp87_);
	} else {
		ValaList* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = params;
		_tmp90_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp89_, _tmp91_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp92_;
	}
	_tmp93_ = marshaller;
	_tmp94_ = vala_ccode_identifier_new (_tmp93_);
	marshal_arg = _tmp94_;
	_tmp95_ = csignew;
	_tmp96_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp96_);
	_tmp98_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp99_ = _tmp98_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_POINTER_TYPE)) {
		_tmp97_ = TRUE;
	} else {
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		_tmp100_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp101_ = _tmp100_;
		_tmp97_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp97_) {
		ValaCCodeFunctionCall* _tmp102_;
		ValaCCodeConstant* _tmp103_;
		ValaCCodeConstant* _tmp104_;
		_tmp102_ = csignew;
		_tmp103_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp104_ = _tmp103_;
		vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
		_vala_ccode_node_unref0 (_tmp104_);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		_tmp105_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp106_ = _tmp105_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp107_;
			ValaCCodeConstant* _tmp108_;
			ValaCCodeConstant* _tmp109_;
			_tmp107_ = csignew;
			_tmp108_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp109_ = _tmp108_;
			vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
			_vala_ccode_node_unref0 (_tmp109_);
		} else {
			gboolean _tmp110_ = FALSE;
			ValaDataType* _tmp111_;
			ValaDataType* _tmp112_;
			_tmp111_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp112_ = _tmp111_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp113_;
				ValaDataType* _tmp114_;
				gboolean _tmp115_;
				gboolean _tmp116_;
				_tmp113_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_data_type_get_nullable (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp110_ = _tmp116_;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaCCodeFunctionCall* _tmp117_;
				ValaCCodeConstant* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				_tmp117_ = csignew;
				_tmp118_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp119_ = _tmp118_;
				vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
				_vala_ccode_node_unref0 (_tmp119_);
			} else {
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaTypeSymbol* _tmp122_;
				ValaTypeSymbol* _tmp123_;
				_tmp120_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp121_ = _tmp120_;
				_tmp122_ = vala_data_type_get_data_type (_tmp121_);
				_tmp123_ = _tmp122_;
				if (_tmp123_ == NULL) {
					ValaCCodeFunctionCall* _tmp124_;
					ValaCCodeConstant* _tmp125_;
					ValaCCodeConstant* _tmp126_;
					_tmp124_ = csignew;
					_tmp125_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp126_ = _tmp125_;
					vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp126_);
					_vala_ccode_node_unref0 (_tmp126_);
				} else {
					ValaDataType* _tmp127_;
					ValaDataType* _tmp128_;
					_tmp127_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp128_ = _tmp127_;
					if (vala_data_type_is_real_non_null_struct_type (_tmp128_)) {
						ValaCCodeFunctionCall* _tmp129_;
						ValaCCodeConstant* _tmp130_;
						ValaCCodeConstant* _tmp131_;
						_tmp129_ = csignew;
						_tmp130_ = vala_ccode_constant_new ("G_TYPE_NONE");
						_tmp131_ = _tmp130_;
						vala_ccode_function_call_add_argument (_tmp129_, (ValaCCodeExpression*) _tmp131_);
						_vala_ccode_node_unref0 (_tmp131_);
					} else {
						ValaCCodeFunctionCall* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaTypeSymbol* _tmp135_;
						ValaTypeSymbol* _tmp136_;
						gchar* _tmp137_;
						gchar* _tmp138_;
						ValaCCodeConstant* _tmp139_;
						ValaCCodeConstant* _tmp140_;
						_tmp132_ = csignew;
						_tmp133_ = vala_callable_get_return_type ((ValaCallable*) sig);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_get_data_type (_tmp134_);
						_tmp136_ = _tmp135_;
						_tmp137_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp136_);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_ccode_constant_new (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_ccode_function_call_add_argument (_tmp132_, (ValaCCodeExpression*) _tmp140_);
						_vala_ccode_node_unref0 (_tmp140_);
						_g_free0 (_tmp138_);
					}
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp141_;
		ValaList* _tmp142_;
		gint _param_size = 0;
		ValaList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _param_index = 0;
		_tmp141_ = params;
		_tmp142_ = _vala_iterable_ref0 (_tmp141_);
		_param_list = _tmp142_;
		_tmp143_ = _param_list;
		_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
		_tmp145_ = _tmp144_;
		_param_size = _tmp145_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp146_;
			gpointer _tmp147_;
			gint _tmp148_;
			ValaParameter* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp146_ = _param_list;
			_tmp147_ = vala_list_get (_tmp146_, _param_index);
			param = (ValaParameter*) _tmp147_;
			_tmp148_ = params_len;
			params_len = _tmp148_ + 1;
			_tmp149_ = param;
			_tmp150_ = vala_variable_get_variable_type ((ValaVariable*) _tmp149_);
			_tmp151_ = _tmp150_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp151_, VALA_TYPE_ARRAY_TYPE)) {
				ValaParameter* _tmp152_;
				ValaDataType* _tmp153_;
				ValaDataType* _tmp154_;
				gint _tmp155_;
				gint _tmp156_;
				_tmp152_ = param;
				_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp156_ = _tmp155_;
				params_len += _tmp156_;
			} else {
				ValaParameter* _tmp157_;
				ValaDataType* _tmp158_;
				ValaDataType* _tmp159_;
				_tmp157_ = param;
				_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
				_tmp159_ = _tmp158_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp160_;
					ValaDataType* _tmp161_;
					ValaDataType* _tmp162_;
					ValaDelegateType* _tmp163_;
					ValaDelegate* _tmp164_;
					ValaDelegate* _tmp165_;
					gboolean _tmp166_;
					gboolean _tmp167_;
					_tmp160_ = param;
					_tmp161_ = vala_variable_get_variable_type ((ValaVariable*) _tmp160_);
					_tmp162_ = _tmp161_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp163_ = delegate_type;
					_tmp164_ = vala_delegate_type_get_delegate_symbol (_tmp163_);
					_tmp165_ = _tmp164_;
					_tmp166_ = vala_delegate_get_has_target (_tmp165_);
					_tmp167_ = _tmp166_;
					if (_tmp167_) {
						gint _tmp168_;
						ValaDelegateType* _tmp169_;
						_tmp168_ = params_len;
						params_len = _tmp168_ + 1;
						_tmp169_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp169_)) {
							gint _tmp170_;
							_tmp170_ = params_len;
							params_len = _tmp170_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp171_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp172_ = _tmp171_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp172_)) {
		gint _tmp173_;
		_tmp173_ = params_len;
		params_len = _tmp173_ + 1;
	}
	_tmp174_ = csignew;
	_tmp175_ = g_strdup_printf ("%d", params_len);
	_tmp176_ = _tmp175_;
	_tmp177_ = vala_ccode_constant_new (_tmp176_);
	_tmp178_ = _tmp177_;
	vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp178_);
	_vala_ccode_node_unref0 (_tmp178_);
	_g_free0 (_tmp176_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp179_;
		ValaList* _tmp180_;
		gint _param_size = 0;
		ValaList* _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		gint _param_index = 0;
		_tmp179_ = params;
		_tmp180_ = _vala_iterable_ref0 (_tmp179_);
		_param_list = _tmp180_;
		_tmp181_ = _param_list;
		_tmp182_ = vala_collection_get_size ((ValaCollection*) _tmp181_);
		_tmp183_ = _tmp182_;
		_param_size = _tmp183_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp184_;
			gpointer _tmp185_;
			ValaParameter* _tmp186_;
			ValaDataType* _tmp187_;
			ValaDataType* _tmp188_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp184_ = _param_list;
			_tmp185_ = vala_list_get (_tmp184_, _param_index);
			param = (ValaParameter*) _tmp185_;
			_tmp186_ = param;
			_tmp187_ = vala_variable_get_variable_type ((ValaVariable*) _tmp186_);
			_tmp188_ = _tmp187_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp188_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				ValaArrayType* _tmp192_;
				ValaArrayType* _tmp193_;
				ValaDataType* _tmp194_;
				ValaDataType* _tmp195_;
				ValaTypeSymbol* _tmp196_;
				ValaTypeSymbol* _tmp197_;
				ValaDataType* _tmp198_;
				ValaTypeSymbol* _tmp199_;
				ValaTypeSymbol* _tmp200_;
				ValaArrayType* _tmp207_;
				ValaDataType* _tmp208_;
				ValaDataType* _tmp209_;
				ValaTypeSymbol* _tmp210_;
				ValaTypeSymbol* _tmp211_;
				gchar* length_type_id = NULL;
				ValaArrayType* _tmp212_;
				ValaDataType* _tmp213_;
				ValaDataType* _tmp214_;
				ValaTypeSymbol* _tmp215_;
				ValaTypeSymbol* _tmp216_;
				gchar* _tmp217_;
				_tmp189_ = param;
				_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) _tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp192_;
				_tmp193_ = array_type;
				_tmp194_ = vala_array_type_get_element_type (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_data_type_get_data_type (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp199_ = vala_data_type_get_data_type (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp197_ == _tmp200_) {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeConstant* _tmp202_;
					ValaCCodeConstant* _tmp203_;
					_tmp201_ = csignew;
					_tmp202_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, (ValaCCodeExpression*) _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
				} else {
					ValaCCodeFunctionCall* _tmp204_;
					ValaCCodeConstant* _tmp205_;
					ValaCCodeConstant* _tmp206_;
					_tmp204_ = csignew;
					_tmp205_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp206_ = _tmp205_;
					vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp206_);
					_vala_ccode_node_unref0 (_tmp206_);
				}
				_tmp207_ = array_type;
				_tmp208_ = vala_array_type_get_length_type (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_data_type_get_data_type (_tmp209_);
				_tmp211_ = _tmp210_;
				_vala_assert (vala_get_ccode_has_type_id (_tmp211_), "get_ccode_has_type_id (array_type.length_type.data_type)");
				_tmp212_ = array_type;
				_tmp213_ = vala_array_type_get_length_type (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_data_type_get_data_type (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp216_);
				length_type_id = _tmp217_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp218_ = FALSE;
						_tmp218_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp220_;
							gint _tmp221_;
							gint _tmp222_;
							ValaCCodeFunctionCall* _tmp223_;
							const gchar* _tmp224_;
							ValaCCodeConstant* _tmp225_;
							ValaCCodeConstant* _tmp226_;
							if (!_tmp218_) {
								gint _tmp219_;
								_tmp219_ = i;
								i = _tmp219_ + 1;
							}
							_tmp218_ = FALSE;
							_tmp220_ = array_type;
							_tmp221_ = vala_array_type_get_rank (_tmp220_);
							_tmp222_ = _tmp221_;
							if (!(i < _tmp222_)) {
								break;
							}
							_tmp223_ = csignew;
							_tmp224_ = length_type_id;
							_tmp225_ = vala_ccode_constant_new (_tmp224_);
							_tmp226_ = _tmp225_;
							vala_ccode_function_call_add_argument (_tmp223_, (ValaCCodeExpression*) _tmp226_);
							_vala_ccode_node_unref0 (_tmp226_);
						}
					}
				}
				_g_free0 (length_type_id);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp227_;
				ValaDataType* _tmp228_;
				ValaDataType* _tmp229_;
				_tmp227_ = param;
				_tmp228_ = vala_variable_get_variable_type ((ValaVariable*) _tmp227_);
				_tmp229_ = _tmp228_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp229_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					ValaCCodeFunctionCall* _tmp233_;
					ValaCCodeConstant* _tmp234_;
					ValaCCodeConstant* _tmp235_;
					ValaDelegateType* _tmp236_;
					ValaDelegate* _tmp237_;
					ValaDelegate* _tmp238_;
					gboolean _tmp239_;
					gboolean _tmp240_;
					_tmp230_ = param;
					_tmp231_ = vala_variable_get_variable_type ((ValaVariable*) _tmp230_);
					_tmp232_ = _tmp231_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp232_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp233_ = csignew;
					_tmp234_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp235_ = _tmp234_;
					vala_ccode_function_call_add_argument (_tmp233_, (ValaCCodeExpression*) _tmp235_);
					_vala_ccode_node_unref0 (_tmp235_);
					_tmp236_ = delegate_type;
					_tmp237_ = vala_delegate_type_get_delegate_symbol (_tmp236_);
					_tmp238_ = _tmp237_;
					_tmp239_ = vala_delegate_get_has_target (_tmp238_);
					_tmp240_ = _tmp239_;
					if (_tmp240_) {
						ValaCCodeFunctionCall* _tmp241_;
						ValaCCodeConstant* _tmp242_;
						ValaCCodeConstant* _tmp243_;
						ValaDelegateType* _tmp244_;
						_tmp241_ = csignew;
						_tmp242_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp243_ = _tmp242_;
						vala_ccode_function_call_add_argument (_tmp241_, (ValaCCodeExpression*) _tmp243_);
						_vala_ccode_node_unref0 (_tmp243_);
						_tmp244_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp244_)) {
							ValaCCodeFunctionCall* _tmp245_;
							ValaCCodeConstant* _tmp246_;
							ValaCCodeConstant* _tmp247_;
							_tmp245_ = csignew;
							_tmp246_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp247_ = _tmp246_;
							vala_ccode_function_call_add_argument (_tmp245_, (ValaCCodeExpression*) _tmp247_);
							_vala_ccode_node_unref0 (_tmp247_);
						}
					}
				} else {
					gboolean _tmp248_ = FALSE;
					gboolean _tmp249_ = FALSE;
					ValaParameter* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					_tmp250_ = param;
					_tmp251_ = vala_variable_get_variable_type ((ValaVariable*) _tmp250_);
					_tmp252_ = _tmp251_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_POINTER_TYPE)) {
						_tmp249_ = TRUE;
					} else {
						ValaParameter* _tmp253_;
						ValaDataType* _tmp254_;
						ValaDataType* _tmp255_;
						_tmp253_ = param;
						_tmp254_ = vala_variable_get_variable_type ((ValaVariable*) _tmp253_);
						_tmp255_ = _tmp254_;
						_tmp249_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp255_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp249_) {
						_tmp248_ = TRUE;
					} else {
						ValaParameter* _tmp256_;
						ValaParameterDirection _tmp257_;
						ValaParameterDirection _tmp258_;
						_tmp256_ = param;
						_tmp257_ = vala_parameter_get_direction (_tmp256_);
						_tmp258_ = _tmp257_;
						_tmp248_ = _tmp258_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp248_) {
						ValaCCodeFunctionCall* _tmp259_;
						ValaCCodeConstant* _tmp260_;
						ValaCCodeConstant* _tmp261_;
						_tmp259_ = csignew;
						_tmp260_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp261_ = _tmp260_;
						vala_ccode_function_call_add_argument (_tmp259_, (ValaCCodeExpression*) _tmp261_);
						_vala_ccode_node_unref0 (_tmp261_);
					} else {
						ValaParameter* _tmp262_;
						ValaDataType* _tmp263_;
						ValaDataType* _tmp264_;
						_tmp262_ = param;
						_tmp263_ = vala_variable_get_variable_type ((ValaVariable*) _tmp262_);
						_tmp264_ = _tmp263_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp264_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp265_;
							ValaCCodeConstant* _tmp266_;
							ValaCCodeConstant* _tmp267_;
							_tmp265_ = csignew;
							_tmp266_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp267_ = _tmp266_;
							vala_ccode_function_call_add_argument (_tmp265_, (ValaCCodeExpression*) _tmp267_);
							_vala_ccode_node_unref0 (_tmp267_);
						} else {
							gboolean _tmp268_ = FALSE;
							ValaParameter* _tmp269_;
							ValaDataType* _tmp270_;
							ValaDataType* _tmp271_;
							_tmp269_ = param;
							_tmp270_ = vala_variable_get_variable_type ((ValaVariable*) _tmp269_);
							_tmp271_ = _tmp270_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp271_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp272_;
								ValaDataType* _tmp273_;
								ValaDataType* _tmp274_;
								gboolean _tmp275_;
								gboolean _tmp276_;
								_tmp272_ = param;
								_tmp273_ = vala_variable_get_variable_type ((ValaVariable*) _tmp272_);
								_tmp274_ = _tmp273_;
								_tmp275_ = vala_data_type_get_nullable (_tmp274_);
								_tmp276_ = _tmp275_;
								_tmp268_ = _tmp276_;
							} else {
								_tmp268_ = FALSE;
							}
							if (_tmp268_) {
								ValaCCodeFunctionCall* _tmp277_;
								ValaCCodeConstant* _tmp278_;
								ValaCCodeConstant* _tmp279_;
								_tmp277_ = csignew;
								_tmp278_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp279_ = _tmp278_;
								vala_ccode_function_call_add_argument (_tmp277_, (ValaCCodeExpression*) _tmp279_);
								_vala_ccode_node_unref0 (_tmp279_);
							} else {
								ValaCCodeFunctionCall* _tmp280_;
								ValaParameter* _tmp281_;
								ValaDataType* _tmp282_;
								ValaDataType* _tmp283_;
								ValaTypeSymbol* _tmp284_;
								ValaTypeSymbol* _tmp285_;
								gchar* _tmp286_;
								gchar* _tmp287_;
								ValaCCodeConstant* _tmp288_;
								ValaCCodeConstant* _tmp289_;
								_tmp280_ = csignew;
								_tmp281_ = param;
								_tmp282_ = vala_variable_get_variable_type ((ValaVariable*) _tmp281_);
								_tmp283_ = _tmp282_;
								_tmp284_ = vala_data_type_get_data_type (_tmp283_);
								_tmp285_ = _tmp284_;
								_tmp286_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp285_);
								_tmp287_ = _tmp286_;
								_tmp288_ = vala_ccode_constant_new (_tmp287_);
								_tmp289_ = _tmp288_;
								vala_ccode_function_call_add_argument (_tmp280_, (ValaCCodeExpression*) _tmp289_);
								_vala_ccode_node_unref0 (_tmp289_);
								_g_free0 (_tmp287_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp290_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp291_ = _tmp290_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp291_)) {
		ValaCCodeFunctionCall* _tmp292_;
		ValaCCodeConstant* _tmp293_;
		ValaCCodeConstant* _tmp294_;
		_tmp292_ = csignew;
		_tmp293_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp294_ = _tmp293_;
		vala_ccode_function_call_add_argument (_tmp292_, (ValaCCodeExpression*) _tmp294_);
		_vala_ccode_node_unref0 (_tmp294_);
	}
	_tmp295_ = marshal_arg;
	_tmp296_ = marshaller;
	vala_ccode_identifier_set_name (_tmp295_, _tmp296_);
	_tmp297_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp298_ = _tmp297_;
	_tmp299_ = csignew;
	_tmp300_ = vala_ccode_assignment_new (_tmp298_, (ValaCCodeExpression*) _tmp299_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp301_ = (ValaCCodeExpression*) _tmp300_;
	_vala_ccode_node_unref0 (_tmp298_);
	result = _tmp301_;
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_vala_iterable_unref0 (params);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}

static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp19_ = FALSE;
			ValaSignal* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaCCodeFunctionCall* _tmp63_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_list_get (_tmp16_, 0);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_vala_iterable_unref0 (_tmp16_);
			detail_expr = _tmp18_;
			_tmp20_ = sig;
			_tmp21_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceFile* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSignal* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceFile* _tmp30_;
				ValaSourceFile* _tmp31_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_source_reference_get_file (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = sig;
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_reference_get_file (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp19_ = _tmp26_ == _tmp31_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeIdentifier* _tmp34_;
				ValaCCodeIdentifier* _tmp35_;
				ValaCCodeFunctionCall* _tmp36_;
				ValaCCodeFunctionCall* _tmp37_;
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaCCodeExpression* _tmp41_;
				ValaCCodeExpression* _tmp42_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaSignal* _tmp44_;
				ValaCCodeExpression* _tmp45_;
				ValaCCodeExpression* _tmp46_;
				ValaCCodeFunctionCall* _tmp47_;
				ValaCCodeExpression* _tmp48_;
				_tmp32_ = detail_expr;
				_tmp33_ = vala_gsignal_module_get_detail_cexpression (self, _tmp32_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp33_;
				_tmp34_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp36_;
				_vala_ccode_node_unref0 (_tmp35_);
				_tmp37_ = ccall;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp40_);
				_tmp42_ = _tmp41_;
				vala_ccode_function_call_add_argument (_tmp37_, _tmp42_);
				_vala_ccode_node_unref0 (_tmp42_);
				_tmp43_ = ccall;
				_tmp44_ = sig;
				_tmp45_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp44_);
				_tmp46_ = _tmp45_;
				vala_ccode_function_call_add_argument (_tmp43_, _tmp46_);
				_vala_ccode_node_unref0 (_tmp46_);
				_tmp47_ = ccall;
				_tmp48_ = detail_cexpr;
				vala_ccode_function_call_add_argument (_tmp47_, _tmp48_);
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp49_;
				ValaExpression* _tmp50_;
				ValaCCodeExpression* _tmp51_;
				ValaCCodeIdentifier* _tmp52_;
				ValaCCodeIdentifier* _tmp53_;
				ValaCCodeFunctionCall* _tmp54_;
				ValaCCodeFunctionCall* _tmp55_;
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				ValaCCodeExpression* _tmp59_;
				ValaCCodeExpression* _tmp60_;
				ValaCCodeFunctionCall* _tmp61_;
				ValaCCodeExpression* _tmp62_;
				_tmp49_ = sig;
				_tmp50_ = detail_expr;
				_tmp51_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp49_, _tmp50_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp51_;
				_tmp52_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp53_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp54_;
				_vala_ccode_node_unref0 (_tmp53_);
				_tmp55_ = ccall;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp58_);
				_tmp60_ = _tmp59_;
				vala_ccode_function_call_add_argument (_tmp55_, _tmp60_);
				_vala_ccode_node_unref0 (_tmp60_);
				_tmp61_ = ccall;
				_tmp62_ = signal_name_cexpr;
				vala_ccode_function_call_add_argument (_tmp61_, _tmp62_);
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp63_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp63_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}

static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSignal* _tmp9_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gboolean _tmp50_ = FALSE;
		ValaSignal* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp6_;
		}
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp9_;
		_tmp10_ = sig;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp13_;
		_tmp15_ = vala_member_access_get_inner (expr);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = sig;
			_tmp18_ = vala_signal_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp14_ = _tmp19_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaClass* _tmp27_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunctionCall* _tmp33_;
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaClass* _tmp36_;
			ValaClass* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeIdentifier* _tmp42_;
			ValaCCodeIdentifier* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaCCodeMemberAccess* _tmp48_;
			ValaCCodeMemberAccess* _tmp49_;
			_tmp20_ = sig;
			_tmp21_ = vala_signal_get_default_handler (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (_tmp22_);
			m = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp27_;
			_tmp28_ = base_class;
			_tmp29_ = vala_get_ccode_class_type_function (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
			_tmp34_ = _tmp33_;
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			vcast = _tmp34_;
			_tmp35_ = vcast;
			_tmp36_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strdup_printf ("%s_parent_class", _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_identifier_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_call_add_argument (_tmp35_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_tmp44_ = vcast;
			_tmp45_ = m;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp44_, _tmp47_);
			_tmp49_ = _tmp48_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp49_);
			_vala_ccode_node_unref0 (_tmp49_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp51_ = sig;
		_tmp52_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		if (!_tmp53_) {
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaSourceFile* _tmp56_;
			ValaSourceFile* _tmp57_;
			ValaSignal* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaSourceFile* _tmp61_;
			ValaSourceFile* _tmp62_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_source_reference_get_file (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = sig;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_source_reference_get_file (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp50_ = _tmp57_ == _tmp62_;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeFunctionCall* _tmp65_;
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeExpression* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaSignal* _tmp70_;
			ValaCCodeExpression* _tmp71_;
			ValaCCodeExpression* _tmp72_;
			ValaCCodeFunctionCall* _tmp73_;
			ValaCCodeConstant* _tmp74_;
			ValaCCodeConstant* _tmp75_;
			ValaCCodeFunctionCall* _tmp76_;
			_tmp63_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
			_tmp66_ = _tmp65_;
			_vala_ccode_node_unref0 (_tmp64_);
			ccall = _tmp66_;
			_tmp67_ = ccall;
			_tmp68_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp67_, _tmp68_);
			_tmp69_ = ccall;
			_tmp70_ = sig;
			_tmp71_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp70_);
			_tmp72_ = _tmp71_;
			vala_ccode_function_call_add_argument (_tmp69_, _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
			_tmp73_ = ccall;
			_tmp74_ = vala_ccode_constant_new ("0");
			_tmp75_ = _tmp74_;
			vala_ccode_function_call_add_argument (_tmp73_, (ValaCCodeExpression*) _tmp75_);
			_vala_ccode_node_unref0 (_tmp75_);
			_tmp76_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp76_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp77_;
			_tmp77_ = sig;
			if (vala_get_ccode_has_emitter (_tmp77_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp78_;
				ValaMethod* _tmp79_;
				ValaMethod* _tmp80_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp109_;
				ValaCCodeIdentifier* _tmp110_;
				ValaCCodeIdentifier* _tmp111_;
				ValaCCodeFunctionCall* _tmp112_;
				ValaCCodeFunctionCall* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeExpression* _tmp115_;
				ValaCCodeFunctionCall* _tmp116_;
				_tmp78_ = sig;
				_tmp79_ = vala_signal_get_emitter (_tmp78_);
				_tmp80_ = _tmp79_;
				if (_tmp80_ != NULL) {
					gboolean _tmp81_ = FALSE;
					ValaSignal* _tmp82_;
					gboolean _tmp83_;
					gboolean _tmp84_;
					ValaSignal* _tmp98_;
					ValaMethod* _tmp99_;
					ValaMethod* _tmp100_;
					gchar* _tmp101_;
					_tmp82_ = sig;
					_tmp83_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp82_);
					_tmp84_ = _tmp83_;
					if (!_tmp84_) {
						ValaSourceReference* _tmp85_;
						ValaSourceReference* _tmp86_;
						ValaSourceFile* _tmp87_;
						ValaSourceFile* _tmp88_;
						ValaSignal* _tmp89_;
						ValaSourceReference* _tmp90_;
						ValaSourceReference* _tmp91_;
						ValaSourceFile* _tmp92_;
						ValaSourceFile* _tmp93_;
						_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp86_ = _tmp85_;
						_tmp87_ = vala_source_reference_get_file (_tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = sig;
						_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = vala_source_reference_get_file (_tmp91_);
						_tmp93_ = _tmp92_;
						_tmp81_ = _tmp88_ != _tmp93_;
					} else {
						_tmp81_ = FALSE;
					}
					if (_tmp81_) {
						ValaSignal* _tmp94_;
						ValaMethod* _tmp95_;
						ValaMethod* _tmp96_;
						ValaCCodeFile* _tmp97_;
						_tmp94_ = sig;
						_tmp95_ = vala_signal_get_emitter (_tmp94_);
						_tmp96_ = _tmp95_;
						_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
					}
					_tmp98_ = sig;
					_tmp99_ = vala_signal_get_emitter (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp100_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp101_;
				} else {
					ValaTypeSymbol* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					ValaSignal* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					_tmp102_ = cl;
					_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
					_tmp104_ = _tmp103_;
					_tmp105_ = sig;
					_tmp106_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp105_, NULL);
					_tmp107_ = _tmp106_;
					_tmp108_ = g_strdup_printf ("%s_%s", _tmp104_, _tmp107_);
					_g_free0 (emitter_func);
					emitter_func = _tmp108_;
					_g_free0 (_tmp107_);
					_g_free0 (_tmp104_);
				}
				_tmp109_ = emitter_func;
				_tmp110_ = vala_ccode_identifier_new (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp111_);
				_tmp113_ = _tmp112_;
				_vala_ccode_node_unref0 (_tmp111_);
				ccall = _tmp113_;
				_tmp114_ = ccall;
				_tmp115_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp114_, _tmp115_);
				_tmp116_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp116_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp117_;
				ValaCCodeIdentifier* _tmp118_;
				ValaCCodeFunctionCall* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeExpression* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaSignal* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				ValaCCodeFunctionCall* _tmp127_;
				_tmp117_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp118_);
				_tmp120_ = _tmp119_;
				_vala_ccode_node_unref0 (_tmp118_);
				ccall = _tmp120_;
				_tmp121_ = ccall;
				_tmp122_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp121_, _tmp122_);
				_tmp123_ = ccall;
				_tmp124_ = sig;
				_tmp125_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp124_, NULL);
				_tmp126_ = _tmp125_;
				vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp126_);
				_vala_ccode_node_unref0 (_tmp126_);
				_tmp127_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp127_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	ValaList* _tmp24_;
	gpointer _tmp25_;
	ValaExpression* _tmp26_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMethod* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean after = FALSE;
	ValaMethodType* _tmp32_;
	ValaMethod* _tmp33_;
	ValaMethod* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaCCodeExpression* _tmp40_;
	ValaCCodeExpression* _tmp41_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_list_get (_tmp24_, 0);
	_tmp26_ = (ValaExpression*) _tmp25_;
	_vala_iterable_unref0 (_tmp24_);
	handler = _tmp26_;
	_tmp27_ = method_type;
	_tmp28_ = vala_method_type_get_method_symbol (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
	_tmp31_ = _tmp30_;
	disconnect = g_strcmp0 (_tmp31_, "disconnect") == 0;
	_tmp32_ = method_type;
	_tmp33_ = vala_method_type_get_method_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	after = g_strcmp0 (_tmp36_, "connect_after") == 0;
	_tmp37_ = sig;
	_tmp38_ = signal_access;
	_tmp39_ = handler;
	_tmp40_ = vala_gsignal_module_connect_signal (self, _tmp37_, _tmp38_, _tmp39_, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp40_;
	_tmp41_ = cexpr;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp41_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}

static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp67_;
	ValaExpression* _tmp68_;
	ValaExpression* _tmp69_;
	ValaCCodeFunctionCall* _tmp162_;
	ValaCCodeExpression* _tmp163_;
	ValaCCodeExpression* _tmp164_;
	ValaCCodeCastExpression* _tmp165_;
	ValaCCodeCastExpression* _tmp166_;
	gboolean _tmp167_ = FALSE;
	ValaMethod* _tmp168_;
	gboolean _tmp244_ = FALSE;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp26_;
				_tmp26_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp26_;
			} else {
				gchar* _tmp27_;
				_tmp27_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp27_;
			}
		} else {
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			ValaMethod* _tmp30_;
			_tmp30_ = m;
			if (_tmp30_ != NULL) {
				ValaMethod* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = m;
				_tmp32_ = vala_method_get_closure (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaDelegateType* _tmp35_;
				_tmp35_ = dt;
				if (_tmp35_ != NULL) {
					ValaDelegateType* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = dt;
					_tmp37_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp34_ = _tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp28_ = _tmp34_;
			}
			if (_tmp28_) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp39_;
			} else {
				gboolean _tmp40_ = FALSE;
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				if (_tmp41_ != NULL) {
					ValaMethod* _tmp42_;
					_tmp42_ = m;
					_tmp40_ = vala_gsignal_module_in_gobject_instance (self, _tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					if (!after) {
						gchar* _tmp44_;
						_tmp44_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp44_;
					} else {
						gchar* _tmp45_;
						_tmp45_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp45_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp46_;
			_tmp46_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp47_;
		}
	}
	_tmp48_ = connect_func;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	ccall = _tmp52_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp53_;
		ValaElementAccess* _tmp54_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp58_;
		ValaList* _tmp59_;
		ValaList* _tmp60_;
		gpointer _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaCCodeExpression* _tmp64_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_container (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp57_;
		_tmp58_ = ea;
		_tmp59_ = vala_element_access_get_indices (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_list_get (_tmp60_, 0);
		_tmp62_ = (ValaExpression*) _tmp61_;
		_vala_iterable_unref0 (_tmp60_);
		detail_expr = _tmp62_;
		_tmp63_ = detail_expr;
		_tmp64_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp63_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp64_;
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp65_;
		ValaCCodeExpression* _tmp66_;
		_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
		_tmp66_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp66_;
	}
	_tmp67_ = ma;
	_tmp68_ = vala_member_access_get_inner (_tmp67_);
	_tmp69_ = _tmp68_;
	if (_tmp69_ != NULL) {
		ValaCCodeFunctionCall* _tmp70_;
		ValaMemberAccess* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaCCodeExpression* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		_tmp70_ = ccall;
		_tmp71_ = ma;
		_tmp72_ = vala_member_access_get_inner (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp73_);
		_tmp75_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp70_, _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
	} else {
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeExpression* _tmp77_;
		ValaCCodeExpression* _tmp78_;
		_tmp76_ = ccall;
		_tmp77_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		vala_ccode_function_call_add_argument (_tmp76_, _tmp78_);
		_vala_ccode_node_unref0 (_tmp78_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		ValaCCodeConstant* _tmp84_;
		ValaCCodeConstant* _tmp85_;
		_tmp79_ = ccall;
		_tmp80_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup_printf ("\"%s\"", _tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_ccode_constant_new (_tmp83_);
		_tmp85_ = _tmp84_;
		vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp85_);
		_vala_ccode_node_unref0 (_tmp85_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp86_;
			ValaCCodeExpression* _tmp87_;
			_tmp86_ = ccall;
			_tmp87_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp86_, _tmp87_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp94_;
			ValaLocalVariable* _tmp95_;
			ValaLocalVariable* _tmp96_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeIdentifier* _tmp98_;
			ValaCCodeFunctionCall* _tmp99_;
			ValaCCodeFunctionCall* _tmp100_;
			ValaCCodeFunctionCall* _tmp101_;
			ValaCCodeExpression* _tmp102_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp103_;
			ValaSymbol* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			ValaTypeSymbol* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			ValaCCodeIdentifier* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaLocalVariable* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			ValaCCodeExpression* _tmp116_;
			ValaCCodeExpression* _tmp117_;
			ValaCCodeUnaryExpression* _tmp118_;
			ValaCCodeUnaryExpression* _tmp119_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp140_;
			ValaCCodeFunction* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			ValaCCodeFunctionCall* _tmp143_;
			ValaLocalVariable* _tmp144_;
			const gchar* _tmp145_;
			const gchar* _tmp146_;
			ValaCCodeExpression* _tmp147_;
			ValaCCodeExpression* _tmp148_;
			ValaLocalVariable* _tmp149_;
			ValaCCodeFunctionCall* _tmp159_;
			ValaCCodeConstant* _tmp160_;
			ValaCCodeConstant* _tmp161_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp88_;
				ValaCCodeConstant* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_add_argument (_tmp88_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
			} else {
				ValaCCodeFunctionCall* _tmp91_;
				ValaCCodeConstant* _tmp92_;
				ValaCCodeConstant* _tmp93_;
				_tmp91_ = ccall;
				_tmp92_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp93_ = _tmp92_;
				vala_ccode_function_call_add_argument (_tmp91_, (ValaCCodeExpression*) _tmp93_);
				_vala_ccode_node_unref0 (_tmp93_);
			}
			_tmp94_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp95_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp94_, TRUE, NULL, FALSE);
			temp_decl = _tmp95_;
			_tmp96_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp96_, FALSE);
			_tmp97_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp98_);
			_tmp100_ = _tmp99_;
			_vala_ccode_node_unref0 (_tmp98_);
			parse_call = _tmp100_;
			_tmp101_ = parse_call;
			_tmp102_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp101_, _tmp102_);
			_tmp103_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp104_ = _tmp103_;
			_tmp105_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp105_;
			_tmp106_ = parse_call;
			_tmp107_ = decl_type;
			_tmp108_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = vala_ccode_identifier_new (_tmp109_);
			_tmp111_ = _tmp110_;
			vala_ccode_function_call_add_argument (_tmp106_, (ValaCCodeExpression*) _tmp111_);
			_vala_ccode_node_unref0 (_tmp111_);
			_g_free0 (_tmp109_);
			_tmp112_ = parse_call;
			_tmp113_ = temp_decl;
			_tmp114_ = vala_symbol_get_name ((ValaSymbol*) _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp117_);
			_tmp119_ = _tmp118_;
			vala_ccode_function_call_add_argument (_tmp112_, (ValaCCodeExpression*) _tmp119_);
			_vala_ccode_node_unref0 (_tmp119_);
			_vala_ccode_node_unref0 (_tmp117_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeConstant* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaCCodeConstant* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				_tmp120_ = parse_call;
				_tmp121_ = vala_ccode_constant_new ("NULL");
				_tmp122_ = _tmp121_;
				vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
				_vala_ccode_node_unref0 (_tmp122_);
				_tmp123_ = parse_call;
				_tmp124_ = vala_ccode_constant_new ("FALSE");
				_tmp125_ = _tmp124_;
				vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp125_);
				_vala_ccode_node_unref0 (_tmp125_);
			} else {
				ValaDataType* _tmp126_;
				ValaLocalVariable* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaCCodeFunctionCall* _tmp129_;
				ValaLocalVariable* _tmp130_;
				const gchar* _tmp131_;
				const gchar* _tmp132_;
				ValaCCodeExpression* _tmp133_;
				ValaCCodeExpression* _tmp134_;
				ValaCCodeUnaryExpression* _tmp135_;
				ValaCCodeUnaryExpression* _tmp136_;
				ValaCCodeFunctionCall* _tmp137_;
				ValaCCodeConstant* _tmp138_;
				ValaCCodeConstant* _tmp139_;
				_tmp126_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp127_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp126_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp127_;
				_tmp128_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp128_, FALSE);
				_tmp129_ = parse_call;
				_tmp130_ = detail_temp_decl;
				_tmp131_ = vala_symbol_get_name ((ValaSymbol*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp134_);
				_tmp136_ = _tmp135_;
				vala_ccode_function_call_add_argument (_tmp129_, (ValaCCodeExpression*) _tmp136_);
				_vala_ccode_node_unref0 (_tmp136_);
				_vala_ccode_node_unref0 (_tmp134_);
				_tmp137_ = parse_call;
				_tmp138_ = vala_ccode_constant_new ("TRUE");
				_tmp139_ = _tmp138_;
				vala_ccode_function_call_add_argument (_tmp137_, (ValaCCodeExpression*) _tmp139_);
				_vala_ccode_node_unref0 (_tmp139_);
			}
			_tmp140_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp141_ = _tmp140_;
			_tmp142_ = parse_call;
			vala_ccode_function_add_expression (_tmp141_, (ValaCCodeExpression*) _tmp142_);
			_tmp143_ = ccall;
			_tmp144_ = temp_decl;
			_tmp145_ = vala_symbol_get_name ((ValaSymbol*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp146_);
			_tmp148_ = _tmp147_;
			vala_ccode_function_call_add_argument (_tmp143_, _tmp148_);
			_vala_ccode_node_unref0 (_tmp148_);
			_tmp149_ = detail_temp_decl;
			if (_tmp149_ == NULL) {
				ValaCCodeFunctionCall* _tmp150_;
				ValaCCodeConstant* _tmp151_;
				ValaCCodeConstant* _tmp152_;
				_tmp150_ = ccall;
				_tmp151_ = vala_ccode_constant_new ("0");
				_tmp152_ = _tmp151_;
				vala_ccode_function_call_add_argument (_tmp150_, (ValaCCodeExpression*) _tmp152_);
				_vala_ccode_node_unref0 (_tmp152_);
			} else {
				ValaCCodeFunctionCall* _tmp153_;
				ValaLocalVariable* _tmp154_;
				const gchar* _tmp155_;
				const gchar* _tmp156_;
				ValaCCodeExpression* _tmp157_;
				ValaCCodeExpression* _tmp158_;
				_tmp153_ = ccall;
				_tmp154_ = detail_temp_decl;
				_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp156_);
				_tmp158_ = _tmp157_;
				vala_ccode_function_call_add_argument (_tmp153_, _tmp158_);
				_vala_ccode_node_unref0 (_tmp158_);
			}
			_tmp159_ = ccall;
			_tmp160_ = vala_ccode_constant_new ("NULL");
			_tmp161_ = _tmp160_;
			vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp161_);
			_vala_ccode_node_unref0 (_tmp161_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp162_ = ccall;
	_tmp163_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_cast_expression_new (_tmp164_, "GCallback");
	_tmp166_ = _tmp165_;
	vala_ccode_function_call_add_argument (_tmp162_, (ValaCCodeExpression*) _tmp166_);
	_vala_ccode_node_unref0 (_tmp166_);
	_vala_ccode_node_unref0 (_tmp164_);
	_tmp168_ = m;
	if (_tmp168_ != NULL) {
		ValaMethod* _tmp169_;
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp169_ = m;
		_tmp170_ = vala_method_get_closure (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp167_ = _tmp171_;
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp172_;
		ValaCCodeExpression* _tmp173_ = NULL;
		ValaCCodeExpression* _tmp174_;
		ValaCCodeExpression* _tmp175_;
		ValaCCodeFunctionCall* _tmp176_;
		ValaCCodeExpression* _tmp177_;
		ValaCCodeCastExpression* _tmp178_;
		ValaCCodeCastExpression* _tmp179_;
		_tmp172_ = ccall;
		_tmp174_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp173_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp173_;
		_tmp175_ = _tmp174_;
		vala_ccode_function_call_add_argument (_tmp172_, _tmp175_);
		_vala_ccode_node_unref0 (_tmp175_);
		_tmp176_ = ccall;
		_tmp177_ = handler_destroy_notify;
		_tmp178_ = vala_ccode_cast_expression_new (_tmp177_, "GClosureNotify");
		_tmp179_ = _tmp178_;
		vala_ccode_function_call_add_argument (_tmp176_, (ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (_tmp179_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp180_;
			ValaCCodeConstant* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			_tmp180_ = ccall;
			_tmp181_ = vala_ccode_constant_new ("0");
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp180_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
		} else {
			ValaCCodeFunctionCall* _tmp183_;
			ValaCCodeConstant* _tmp184_;
			ValaCCodeConstant* _tmp185_;
			_tmp183_ = ccall;
			_tmp184_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp185_ = _tmp184_;
			vala_ccode_function_call_add_argument (_tmp183_, (ValaCCodeExpression*) _tmp185_);
			_vala_ccode_node_unref0 (_tmp185_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp186_ = FALSE;
		ValaMethod* _tmp187_;
		_tmp187_ = m;
		if (_tmp187_ != NULL) {
			ValaMethod* _tmp188_;
			ValaMemberBinding _tmp189_;
			ValaMemberBinding _tmp190_;
			_tmp188_ = m;
			_tmp189_ = vala_method_get_binding (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp186_ = _tmp190_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp186_ = FALSE;
		}
		if (_tmp186_) {
			gboolean _tmp207_ = FALSE;
			gboolean _tmp208_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp191_;
				ValaMemberAccess* _tmp192_;
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				_tmp191_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp191_;
				_tmp192_ = right_ma;
				_tmp193_ = vala_member_access_get_inner (_tmp192_);
				_tmp194_ = _tmp193_;
				if (_tmp194_ != NULL) {
					ValaCCodeFunctionCall* _tmp195_;
					ValaMemberAccess* _tmp196_;
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaCCodeExpression* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					_tmp195_ = ccall;
					_tmp196_ = right_ma;
					_tmp197_ = vala_member_access_get_inner (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp198_);
					_tmp200_ = _tmp199_;
					vala_ccode_function_call_add_argument (_tmp195_, _tmp200_);
					_vala_ccode_node_unref0 (_tmp200_);
				} else {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeExpression* _tmp202_;
					ValaCCodeExpression* _tmp203_;
					_tmp201_ = ccall;
					_tmp202_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp204_;
					ValaCCodeExpression* _tmp205_;
					ValaCCodeExpression* _tmp206_;
					_tmp204_ = ccall;
					_tmp205_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp206_ = _tmp205_;
					vala_ccode_function_call_add_argument (_tmp204_, _tmp206_);
					_vala_ccode_node_unref0 (_tmp206_);
				}
			}
			if (!disconnect) {
				_tmp208_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				ValaMethod* _tmp209_;
				_tmp209_ = m;
				_tmp207_ = vala_gsignal_module_in_gobject_instance (self, _tmp209_);
			} else {
				_tmp207_ = FALSE;
			}
			if (_tmp207_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					_tmp210_ = ccall;
					_tmp211_ = vala_ccode_constant_new ("0");
					_tmp212_ = _tmp211_;
					vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
					_vala_ccode_node_unref0 (_tmp212_);
				} else {
					ValaCCodeFunctionCall* _tmp213_;
					ValaCCodeConstant* _tmp214_;
					ValaCCodeConstant* _tmp215_;
					_tmp213_ = ccall;
					_tmp214_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp215_ = _tmp214_;
					vala_ccode_function_call_add_argument (_tmp213_, (ValaCCodeExpression*) _tmp215_);
					_vala_ccode_node_unref0 (_tmp215_);
				}
			}
		} else {
			gboolean _tmp216_ = FALSE;
			ValaDelegateType* _tmp217_;
			_tmp217_ = dt;
			if (_tmp217_ != NULL) {
				ValaDelegateType* _tmp218_;
				ValaDelegate* _tmp219_;
				ValaDelegate* _tmp220_;
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp218_ = dt;
				_tmp219_ = vala_delegate_type_get_delegate_symbol (_tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_delegate_get_has_target (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp216_ = _tmp222_;
			} else {
				_tmp216_ = FALSE;
			}
			if (_tmp216_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp223_;
				ValaCCodeExpression* _tmp224_ = NULL;
				ValaCCodeExpression* _tmp225_;
				ValaCCodeExpression* _tmp226_;
				gboolean _tmp227_ = FALSE;
				_tmp223_ = ccall;
				_tmp225_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp224_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp224_;
				_tmp226_ = _tmp225_;
				vala_ccode_function_call_add_argument (_tmp223_, _tmp226_);
				_vala_ccode_node_unref0 (_tmp226_);
				if (!disconnect) {
					ValaDelegateType* _tmp228_;
					gboolean _tmp229_;
					gboolean _tmp230_;
					_tmp228_ = dt;
					_tmp229_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp228_);
					_tmp230_ = _tmp229_;
					_tmp227_ = _tmp230_;
				} else {
					_tmp227_ = FALSE;
				}
				if (_tmp227_) {
					ValaCCodeFunctionCall* _tmp231_;
					ValaCCodeExpression* _tmp232_;
					ValaCCodeCastExpression* _tmp233_;
					ValaCCodeCastExpression* _tmp234_;
					_tmp231_ = ccall;
					_tmp232_ = handler_destroy_notify;
					_tmp233_ = vala_ccode_cast_expression_new (_tmp232_, "GClosureNotify");
					_tmp234_ = _tmp233_;
					vala_ccode_function_call_add_argument (_tmp231_, (ValaCCodeExpression*) _tmp234_);
					_vala_ccode_node_unref0 (_tmp234_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp235_;
						ValaCCodeConstant* _tmp236_;
						ValaCCodeConstant* _tmp237_;
						_tmp235_ = ccall;
						_tmp236_ = vala_ccode_constant_new ("0");
						_tmp237_ = _tmp236_;
						vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp237_);
						_vala_ccode_node_unref0 (_tmp237_);
					} else {
						ValaCCodeFunctionCall* _tmp238_;
						ValaCCodeConstant* _tmp239_;
						ValaCCodeConstant* _tmp240_;
						_tmp238_ = ccall;
						_tmp239_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp240_ = _tmp239_;
						vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
						_vala_ccode_node_unref0 (_tmp240_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp241_;
				ValaCCodeConstant* _tmp242_;
				ValaCCodeConstant* _tmp243_;
				_tmp241_ = ccall;
				_tmp242_ = vala_ccode_constant_new ("NULL");
				_tmp243_ = _tmp242_;
				vala_ccode_function_call_add_argument (_tmp241_, (ValaCCodeExpression*) _tmp243_);
				_vala_ccode_node_unref0 (_tmp243_);
			}
		}
	}
	if (disconnect) {
		_tmp244_ = TRUE;
	} else {
		ValaCodeNode* _tmp245_;
		ValaCodeNode* _tmp246_;
		_tmp245_ = vala_code_node_get_parent_node (expr);
		_tmp246_ = _tmp245_;
		_tmp244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp246_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp244_) {
		ValaCCodeFunction* _tmp247_;
		ValaCCodeFunction* _tmp248_;
		ValaCCodeFunctionCall* _tmp249_;
		_tmp247_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp248_ = _tmp247_;
		_tmp249_ = ccall;
		vala_ccode_function_add_expression (_tmp248_, (ValaCCodeExpression*) _tmp249_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp250_;
		ValaLocalVariable* _tmp251_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp252_;
		const gchar* _tmp253_;
		const gchar* _tmp254_;
		ValaCCodeExpression* _tmp255_;
		ValaLocalVariable* _tmp256_;
		ValaCCodeFunction* _tmp257_;
		ValaCCodeFunction* _tmp258_;
		ValaCCodeExpression* _tmp259_;
		ValaCCodeFunctionCall* _tmp260_;
		_tmp250_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp251_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp250_, TRUE, NULL, FALSE);
		temp_var = _tmp251_;
		_tmp252_ = temp_var;
		_tmp253_ = vala_symbol_get_name ((ValaSymbol*) _tmp252_);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp254_);
		temp_ref = _tmp255_;
		_tmp256_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp256_, FALSE);
		_tmp257_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp258_ = _tmp257_;
		_tmp259_ = temp_ref;
		_tmp260_ = ccall;
		vala_ccode_function_add_assignment (_tmp258_, _tmp259_, (ValaCCodeExpression*) _tmp260_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}

ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}

ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}

static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass,
                                gpointer klass_data)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}

static void
vala_gsignal_module_instance_init (ValaGSignalModule * self,
                                   gpointer klass)
{
}

GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

