/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	gboolean _tmp244_ = FALSE;
	gboolean _tmp245_ = FALSE;
	ValaAssignmentOperator _tmp246_;
	ValaMemberAccess* _tmp293_;
	ValaExpression* _tmp675_;
	ValaExpression* _tmp676_;
	ValaDataType* _tmp677_;
	ValaDataType* _tmp678_;
	ValaDataType* _tmp687_;
	ValaDataType* _tmp688_;
	gboolean _tmp691_;
	gboolean _tmp692_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (VALA_IS_MEMBER_ACCESS (_tmp96_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		ValaMemberAccess* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp105_ = FALSE;
		gboolean _tmp106_ = FALSE;
		ValaMemberAccess* _tmp107_;
		ValaSymbol* _tmp108_;
		ValaSymbol* _tmp109_;
		ValaMemberAccess* _tmp125_;
		gboolean _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp137_ = FALSE;
		ValaMemberAccess* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		ValaMemberAccess* _tmp144_;
		ValaSymbol* _tmp145_;
		ValaSymbol* _tmp146_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp99_;
		_tmp100_ = ma;
		_tmp101_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp100_);
		_tmp102_ = _tmp101_;
		if (VALA_IS_CONSTANT (_tmp102_)) {
			ValaSourceReference* _tmp103_;
			ValaSourceReference* _tmp104_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp104_ = _tmp103_;
			vala_report_error (_tmp104_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp107_ = ma;
		_tmp108_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp107_);
		_tmp109_ = _tmp108_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp109_)) {
			ValaMemberAccess* _tmp110_;
			ValaDataType* _tmp111_;
			ValaDataType* _tmp112_;
			_tmp110_ = ma;
			_tmp111_ = vala_expression_get_value_type ((ValaExpression*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp106_ = _tmp112_ == NULL;
		} else {
			_tmp106_ = FALSE;
		}
		if (_tmp106_) {
			_tmp105_ = TRUE;
		} else {
			gboolean _tmp113_ = FALSE;
			gboolean _tmp114_ = FALSE;
			ValaMemberAccess* _tmp115_;
			ValaExpression* _tmp116_;
			ValaExpression* _tmp117_;
			_tmp115_ = ma;
			_tmp116_ = vala_member_access_get_inner (_tmp115_);
			_tmp117_ = _tmp116_;
			if (_tmp117_ == NULL) {
				ValaMemberAccess* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				_tmp118_ = ma;
				_tmp119_ = vala_member_access_get_member_name (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp114_ = g_strcmp0 (_tmp120_, "this") == 0;
			} else {
				_tmp114_ = FALSE;
			}
			if (_tmp114_) {
				ValaSemanticAnalyzer* _tmp121_;
				ValaSemanticAnalyzer* _tmp122_;
				_tmp121_ = vala_code_context_get_analyzer (context);
				_tmp122_ = _tmp121_;
				_tmp113_ = vala_semantic_analyzer_is_in_instance_method (_tmp122_);
			} else {
				_tmp113_ = FALSE;
			}
			_tmp105_ = _tmp113_;
		}
		if (_tmp105_) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp124_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp125_ = ma;
		_tmp126_ = vala_member_access_get_prototype_access (_tmp125_);
		_tmp127_ = _tmp126_;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_full_name (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp134_);
			_tmp136_ = _tmp135_;
			vala_report_error (_tmp129_, _tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp138_ = ma;
		_tmp139_ = vala_code_node_get_error ((ValaCodeNode*) _tmp138_);
		_tmp140_ = _tmp139_;
		if (_tmp140_) {
			_tmp137_ = TRUE;
		} else {
			ValaMemberAccess* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp137_ = _tmp143_ == NULL;
		}
		if (_tmp137_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp144_ = ma;
		_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp144_);
		_tmp146_ = _tmp145_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp146_)) {
		} else {
			ValaExpression* _tmp147_;
			ValaExpression* _tmp148_;
			ValaMemberAccess* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaExpression* _tmp154_;
			ValaExpression* _tmp155_;
			ValaMemberAccess* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp147_ = vala_assignment_get_right (self);
			_tmp148_ = _tmp147_;
			_tmp149_ = ma;
			_tmp150_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_data_type_copy (_tmp151_);
			_tmp153_ = _tmp152_;
			vala_expression_set_formal_target_type (_tmp148_, _tmp153_);
			_vala_code_node_unref0 (_tmp153_);
			_tmp154_ = vala_assignment_get_right (self);
			_tmp155_ = _tmp154_;
			_tmp156_ = ma;
			_tmp157_ = vala_expression_get_value_type ((ValaExpression*) _tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_data_type_copy (_tmp158_);
			_tmp160_ = _tmp159_;
			vala_expression_set_target_type (_tmp155_, _tmp160_);
			_vala_code_node_unref0 (_tmp160_);
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp161_;
		ValaExpression* _tmp162_;
		_tmp161_ = vala_assignment_get_left (self);
		_tmp162_ = _tmp161_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp162_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaElementAccess* _tmp166_;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			ValaDataType* _tmp169_;
			ValaDataType* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaTypeSymbol* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaSemanticAnalyzer* _tmp174_;
			ValaDataType* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			ValaTypeSymbol* _tmp177_;
			_tmp163_ = vala_assignment_get_left (self);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp165_;
			_tmp166_ = ea;
			_tmp167_ = vala_element_access_get_container (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_expression_get_value_type (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_data_type_get_data_type (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_code_context_get_analyzer (context);
			_tmp174_ = _tmp173_;
			_tmp175_ = _tmp174_->string_type;
			_tmp176_ = vala_data_type_get_data_type (_tmp175_);
			_tmp177_ = _tmp176_;
			if (_tmp172_ == _tmp177_) {
				ValaElementAccess* _tmp178_;
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp178_ = ea;
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp180_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				ValaElementAccess* _tmp181_;
				ValaExpression* _tmp182_;
				ValaExpression* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				gboolean _tmp188_;
				_tmp181_ = ea;
				_tmp182_ = vala_element_access_get_container (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_expression_get_value_type (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_data_type_get_member (_tmp185_, "set");
				_tmp187_ = _tmp186_;
				_tmp188_ = VALA_IS_METHOD (_tmp187_);
				_vala_code_node_unref0 (_tmp187_);
				if (_tmp188_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp189_;
					ValaExpression* _tmp190_;
					ValaExpression* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaSourceReference* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaMemberAccess* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp199_;
					ValaMethodCall* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaCodeNode* _tmp212_;
					ValaCodeNode* _tmp213_;
					ValaMethodCall* _tmp214_;
					ValaMethodCall* _tmp215_;
					_tmp189_ = ea;
					_tmp190_ = vala_element_access_get_container (_tmp189_);
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_member_access_new (_tmp191_, "set", _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_method_call_new ((ValaExpression*) _tmp195_, _tmp197_);
					_tmp199_ = _tmp198_;
					_vala_code_node_unref0 (_tmp195_);
					set_call = _tmp199_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp200_ = ea;
						_tmp201_ = vala_element_access_get_indices (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp205_;
							gpointer _tmp206_;
							ValaMethodCall* _tmp207_;
							ValaExpression* _tmp208_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp205_ = _e_list;
							_tmp206_ = vala_list_get (_tmp205_, _e_index);
							e = (ValaExpression*) _tmp206_;
							_tmp207_ = set_call;
							_tmp208_ = e;
							vala_method_call_add_argument (_tmp207_, _tmp208_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp209_ = set_call;
					_tmp210_ = vala_assignment_get_right (self);
					_tmp211_ = _tmp210_;
					vala_method_call_add_argument (_tmp209_, _tmp211_);
					_tmp212_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = set_call;
					vala_code_node_replace_expression (_tmp213_, (ValaExpression*) self, (ValaExpression*) _tmp214_);
					_tmp215_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
					_vala_code_node_unref0 (set_call);
					_vala_code_node_unref0 (ea);
					return result;
				} else {
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					_tmp216_ = vala_assignment_get_right (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_assignment_get_left (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_data_type_copy (_tmp221_);
					_tmp223_ = _tmp222_;
					vala_expression_set_target_type (_tmp217_, _tmp223_);
					_vala_code_node_unref0 (_tmp223_);
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp224_;
			ValaExpression* _tmp225_;
			_tmp224_ = vala_assignment_get_left (self);
			_tmp225_ = _tmp224_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp225_)) {
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				_tmp226_ = vala_assignment_get_right (self);
				_tmp227_ = _tmp226_;
				_tmp228_ = vala_assignment_get_left (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_expression_get_value_type (_tmp229_);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_data_type_copy (_tmp231_);
				_tmp233_ = _tmp232_;
				vala_expression_set_target_type (_tmp227_, _tmp233_);
				_vala_code_node_unref0 (_tmp233_);
			} else {
				ValaExpression* _tmp234_;
				ValaExpression* _tmp235_;
				_tmp234_ = vala_assignment_get_left (self);
				_tmp235_ = _tmp234_;
				if (VALA_IS_LITERAL (_tmp235_)) {
					ValaSourceReference* _tmp236_;
					ValaSourceReference* _tmp237_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp237_ = _tmp236_;
					vala_report_error (_tmp237_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp239_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp240_ = vala_assignment_get_right (self);
	_tmp241_ = _tmp240_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp241_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp242_ = vala_assignment_get_left (self);
	_tmp243_ = _tmp242_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp243_) ? ((ValaMemberAccess*) _tmp243_) : NULL;
	_tmp246_ = self->priv->_operator;
	if (_tmp246_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp247_;
		_tmp247_ = ma;
		_tmp245_ = _tmp247_ != NULL;
	} else {
		_tmp245_ = FALSE;
	}
	if (_tmp245_) {
		gboolean _tmp248_ = FALSE;
		ValaExpression* _tmp249_;
		ValaExpression* _tmp250_;
		ValaDataType* _tmp251_;
		ValaDataType* _tmp252_;
		_tmp249_ = vala_assignment_get_left (self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_expression_get_value_type (_tmp250_);
		_tmp252_ = _tmp251_;
		if (vala_data_type_is_non_null_simple_type (_tmp252_)) {
			ValaMemberAccess* _tmp253_;
			ValaSymbol* _tmp254_;
			ValaSymbol* _tmp255_;
			_tmp253_ = ma;
			_tmp254_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp253_);
			_tmp255_ = _tmp254_;
			_tmp248_ = VALA_IS_LOCAL_VARIABLE (_tmp255_);
		} else {
			_tmp248_ = FALSE;
		}
		_tmp244_ = !_tmp248_;
	} else {
		_tmp244_ = FALSE;
	}
	if (_tmp244_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp256_;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaMemberAccess* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaMemberAccess* _tmp262_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp263_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaExpression* _tmp268_;
		ValaExpression* _tmp269_;
		ValaSourceReference* _tmp270_;
		ValaSourceReference* _tmp271_;
		ValaBinaryExpression* _tmp272_;
		ValaBinaryExpression* _tmp273_;
		ValaExpression* _tmp274_;
		ValaExpression* _tmp275_;
		ValaDataType* _tmp276_;
		ValaDataType* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaExpression* _tmp280_;
		ValaExpression* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaDataType* _tmp285_;
		ValaExpression* _tmp286_;
		ValaExpression* _tmp287_;
		ValaDataType* _tmp288_;
		ValaDataType* _tmp289_;
		ValaBinaryExpression* _tmp290_;
		ValaExpression* _tmp291_;
		ValaExpression* _tmp292_;
		_tmp256_ = ma;
		_tmp257_ = vala_member_access_get_inner (_tmp256_);
		_tmp258_ = _tmp257_;
		_tmp259_ = ma;
		_tmp260_ = vala_member_access_get_member_name (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_member_access_new (_tmp258_, _tmp261_, NULL);
		old_value = _tmp262_;
		_tmp263_ = self->priv->_operator;
		switch (_tmp263_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp264_;
				ValaSourceReference* _tmp265_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp265_ = _tmp264_;
				vala_report_error (_tmp265_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp266_ = bop;
		_tmp267_ = old_value;
		_tmp268_ = vala_assignment_get_right (self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_binary_expression_new (_tmp266_, (ValaExpression*) _tmp267_, _tmp269_, _tmp271_);
		bin = _tmp272_;
		_tmp273_ = bin;
		_tmp274_ = vala_assignment_get_right (self);
		_tmp275_ = _tmp274_;
		_tmp276_ = vala_expression_get_target_type (_tmp275_);
		_tmp277_ = _tmp276_;
		vala_expression_set_target_type ((ValaExpression*) _tmp273_, _tmp277_);
		_tmp278_ = vala_assignment_get_right (self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_assignment_get_right (self);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_expression_get_target_type (_tmp281_);
		_tmp283_ = _tmp282_;
		_tmp284_ = vala_data_type_copy (_tmp283_);
		_tmp285_ = _tmp284_;
		vala_expression_set_target_type (_tmp279_, _tmp285_);
		_vala_code_node_unref0 (_tmp285_);
		_tmp286_ = vala_assignment_get_right (self);
		_tmp287_ = _tmp286_;
		_tmp288_ = vala_expression_get_target_type (_tmp287_);
		_tmp289_ = _tmp288_;
		vala_data_type_set_value_owned (_tmp289_, FALSE);
		_tmp290_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp290_);
		_tmp291_ = vala_assignment_get_right (self);
		_tmp292_ = _tmp291_;
		vala_code_node_check ((ValaCodeNode*) _tmp292_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp293_ = ma;
	if (_tmp293_ != NULL) {
		ValaMemberAccess* _tmp294_;
		ValaSymbol* _tmp295_;
		ValaSymbol* _tmp296_;
		gboolean _tmp483_ = FALSE;
		ValaExpression* _tmp484_;
		ValaExpression* _tmp485_;
		ValaDataType* _tmp486_;
		ValaDataType* _tmp487_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp542_;
		ValaExpression* _tmp543_;
		ValaMemberAccess* _tmp544_;
		gboolean _tmp545_ = FALSE;
		ValaMemberAccess* _tmp546_;
		_tmp294_ = ma;
		_tmp295_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp294_);
		_tmp296_ = _tmp295_;
		if (VALA_IS_PROPERTY (_tmp296_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			ValaProperty* _tmp300_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp301_;
			ValaDynamicProperty* _tmp302_;
			ValaDynamicProperty* _tmp303_;
			gboolean _tmp318_ = FALSE;
			ValaProperty* _tmp319_;
			ValaPropertyAccessor* _tmp320_;
			ValaPropertyAccessor* _tmp321_;
			_tmp297_ = ma;
			_tmp298_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp300_;
			_tmp301_ = prop;
			_tmp302_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_PROPERTY (_tmp301_) ? ((ValaDynamicProperty*) _tmp301_) : NULL);
			dynamic_prop = _tmp302_;
			_tmp303_ = dynamic_prop;
			if (_tmp303_ != NULL) {
				ValaDynamicProperty* _tmp304_;
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				ValaDataType* _tmp310_;
				ValaExpression* _tmp311_;
				ValaExpression* _tmp312_;
				ValaDynamicProperty* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				_tmp304_ = dynamic_prop;
				_tmp305_ = vala_assignment_get_right (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_expression_get_value_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_data_type_copy (_tmp308_);
				_tmp310_ = _tmp309_;
				vala_property_set_property_type ((ValaProperty*) _tmp304_, _tmp310_);
				_vala_code_node_unref0 (_tmp310_);
				_tmp311_ = vala_assignment_get_left (self);
				_tmp312_ = _tmp311_;
				_tmp313_ = dynamic_prop;
				_tmp314_ = vala_property_get_property_type ((ValaProperty*) _tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_data_type_copy (_tmp315_);
				_tmp317_ = _tmp316_;
				vala_expression_set_value_type (_tmp312_, _tmp317_);
				_vala_code_node_unref0 (_tmp317_);
			}
			_tmp319_ = prop;
			_tmp320_ = vala_property_get_set_accessor (_tmp319_);
			_tmp321_ = _tmp320_;
			if (_tmp321_ == NULL) {
				_tmp318_ = TRUE;
			} else {
				gboolean _tmp322_ = FALSE;
				ValaProperty* _tmp323_;
				ValaPropertyAccessor* _tmp324_;
				ValaPropertyAccessor* _tmp325_;
				gboolean _tmp326_;
				gboolean _tmp327_;
				_tmp323_ = prop;
				_tmp324_ = vala_property_get_set_accessor (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp326_ = vala_property_accessor_get_writable (_tmp325_);
				_tmp327_ = _tmp326_;
				if (!_tmp327_) {
					gboolean _tmp328_ = FALSE;
					ValaSemanticAnalyzer* _tmp329_;
					ValaSemanticAnalyzer* _tmp330_;
					ValaMethod* _tmp331_;
					ValaMethod* _tmp332_;
					gboolean _tmp333_;
					_tmp329_ = vala_code_context_get_analyzer (context);
					_tmp330_ = _tmp329_;
					_tmp331_ = vala_semantic_analyzer_find_current_method (_tmp330_);
					_tmp332_ = _tmp331_;
					_tmp333_ = VALA_IS_CREATION_METHOD (_tmp332_);
					_vala_code_node_unref0 (_tmp332_);
					if (_tmp333_) {
						_tmp328_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp334_;
						ValaSemanticAnalyzer* _tmp335_;
						_tmp334_ = vala_code_context_get_analyzer (context);
						_tmp335_ = _tmp334_;
						_tmp328_ = vala_semantic_analyzer_is_in_constructor (_tmp335_);
					}
					_tmp322_ = !_tmp328_;
				} else {
					_tmp322_ = FALSE;
				}
				_tmp318_ = _tmp322_;
			}
			if (_tmp318_) {
				ValaMemberAccess* _tmp336_;
				ValaMemberAccess* _tmp337_;
				ValaSourceReference* _tmp338_;
				ValaSourceReference* _tmp339_;
				ValaProperty* _tmp340_;
				gchar* _tmp341_;
				gchar* _tmp342_;
				gchar* _tmp343_;
				gchar* _tmp344_;
				_tmp336_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp336_, TRUE);
				_tmp337_ = ma;
				_tmp338_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp337_);
				_tmp339_ = _tmp338_;
				_tmp340_ = prop;
				_tmp341_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp340_);
				_tmp342_ = _tmp341_;
				_tmp343_ = g_strdup_printf ("Property `%s' is read-only", _tmp342_);
				_tmp344_ = _tmp343_;
				vala_report_error (_tmp339_, _tmp344_);
				_g_free0 (_tmp344_);
				_g_free0 (_tmp342_);
				result = FALSE;
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
				return result;
			} else {
				gboolean _tmp345_ = FALSE;
				gboolean _tmp346_ = FALSE;
				gboolean _tmp347_;
				gboolean _tmp348_;
				_tmp347_ = vala_code_context_get_deprecated (context);
				_tmp348_ = _tmp347_;
				if (!_tmp348_) {
					ValaProperty* _tmp349_;
					ValaPropertyAccessor* _tmp350_;
					ValaPropertyAccessor* _tmp351_;
					gboolean _tmp352_;
					gboolean _tmp353_;
					_tmp349_ = prop;
					_tmp350_ = vala_property_get_set_accessor (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp352_ = vala_property_accessor_get_writable (_tmp351_);
					_tmp353_ = _tmp352_;
					_tmp346_ = !_tmp353_;
				} else {
					_tmp346_ = FALSE;
				}
				if (_tmp346_) {
					ValaSemanticAnalyzer* _tmp354_;
					ValaSemanticAnalyzer* _tmp355_;
					ValaMethod* _tmp356_;
					ValaMethod* _tmp357_;
					_tmp354_ = vala_code_context_get_analyzer (context);
					_tmp355_ = _tmp354_;
					_tmp356_ = vala_semantic_analyzer_find_current_method (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp345_ = VALA_IS_CREATION_METHOD (_tmp357_);
					_vala_code_node_unref0 (_tmp357_);
				} else {
					_tmp345_ = FALSE;
				}
				if (_tmp345_) {
					ValaMemberAccess* _tmp358_;
					ValaExpression* _tmp359_;
					ValaExpression* _tmp360_;
					ValaSymbol* _tmp361_;
					ValaSymbol* _tmp362_;
					ValaSemanticAnalyzer* _tmp363_;
					ValaSemanticAnalyzer* _tmp364_;
					ValaMethod* _tmp365_;
					ValaMethod* _tmp366_;
					ValaParameter* _tmp367_;
					ValaParameter* _tmp368_;
					gboolean _tmp369_;
					_tmp358_ = ma;
					_tmp359_ = vala_member_access_get_inner (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_expression_get_symbol_reference (_tmp360_);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_code_context_get_analyzer (context);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_semantic_analyzer_find_current_method (_tmp364_);
					_tmp366_ = _tmp365_;
					_tmp367_ = vala_method_get_this_parameter (_tmp366_);
					_tmp368_ = _tmp367_;
					_tmp369_ = _tmp362_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp368_, VALA_TYPE_SYMBOL, ValaSymbol);
					_vala_code_node_unref0 (_tmp366_);
					if (_tmp369_) {
						ValaMemberAccess* _tmp370_;
						ValaSourceReference* _tmp371_;
						ValaSourceReference* _tmp372_;
						ValaProperty* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp370_ = ma;
						_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp370_);
						_tmp372_ = _tmp371_;
						_tmp373_ = prop;
						_tmp374_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("Property `%s' is read-only", _tmp375_);
						_tmp377_ = _tmp376_;
						vala_report_error (_tmp372_, _tmp377_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					} else {
						ValaMemberAccess* _tmp378_;
						ValaSourceReference* _tmp379_;
						ValaSourceReference* _tmp380_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp378_ = ma;
						_tmp379_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp378_);
						_tmp380_ = _tmp379_;
						vala_report_error (_tmp380_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (dynamic_prop);
			_vala_code_node_unref0 (prop);
		} else {
			gboolean _tmp381_ = FALSE;
			ValaMemberAccess* _tmp382_;
			ValaSymbol* _tmp383_;
			ValaSymbol* _tmp384_;
			_tmp382_ = ma;
			_tmp383_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp382_);
			_tmp384_ = _tmp383_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp384_)) {
				ValaMemberAccess* _tmp385_;
				ValaExpression* _tmp386_;
				ValaExpression* _tmp387_;
				ValaDataType* _tmp388_;
				ValaDataType* _tmp389_;
				gboolean _tmp390_;
				gboolean _tmp391_;
				_tmp385_ = ma;
				_tmp386_ = vala_member_access_get_inner (_tmp385_);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_expression_get_value_type (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp389_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp391_ = _tmp390_;
				_tmp381_ = _tmp391_;
			} else {
				_tmp381_ = FALSE;
			}
			if (_tmp381_) {
				ValaSourceReference* _tmp392_;
				ValaSourceReference* _tmp393_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp393_ = _tmp392_;
				vala_report_error (_tmp393_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp394_ = FALSE;
				ValaMemberAccess* _tmp395_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp395_ = ma;
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp395_);
				_tmp397_ = _tmp396_;
				if (VALA_IS_VARIABLE (_tmp397_)) {
					ValaExpression* _tmp398_;
					ValaExpression* _tmp399_;
					ValaDataType* _tmp400_;
					ValaDataType* _tmp401_;
					_tmp398_ = vala_assignment_get_right (self);
					_tmp399_ = _tmp398_;
					_tmp400_ = vala_expression_get_value_type (_tmp399_);
					_tmp401_ = _tmp400_;
					_tmp394_ = _tmp401_ == NULL;
				} else {
					_tmp394_ = FALSE;
				}
				if (_tmp394_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp402_;
					ValaSymbol* _tmp403_;
					ValaSymbol* _tmp404_;
					ValaVariable* _tmp405_;
					gboolean _tmp406_ = FALSE;
					ValaExpression* _tmp407_;
					ValaExpression* _tmp408_;
					ValaSymbol* _tmp409_;
					ValaSymbol* _tmp410_;
					_tmp402_ = ma;
					_tmp403_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp402_);
					_tmp404_ = _tmp403_;
					_tmp405_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp404_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp405_;
					_tmp407_ = vala_assignment_get_right (self);
					_tmp408_ = _tmp407_;
					_tmp409_ = vala_expression_get_symbol_reference (_tmp408_);
					_tmp410_ = _tmp409_;
					if (VALA_IS_METHOD (_tmp410_)) {
						ValaVariable* _tmp411_;
						ValaDataType* _tmp412_;
						ValaDataType* _tmp413_;
						_tmp411_ = variable;
						_tmp412_ = vala_variable_get_variable_type (_tmp411_);
						_tmp413_ = _tmp412_;
						_tmp406_ = VALA_IS_DELEGATE_TYPE (_tmp413_);
					} else {
						_tmp406_ = FALSE;
					}
					if (_tmp406_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp414_;
						ValaExpression* _tmp415_;
						ValaSymbol* _tmp416_;
						ValaSymbol* _tmp417_;
						ValaMethod* _tmp418_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDataType* _tmp421_;
						ValaDelegateType* _tmp422_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp423_;
						ValaDelegate* _tmp424_;
						ValaDelegate* _tmp425_;
						ValaDelegate* _tmp426_;
						ValaDelegate* _tmp427_;
						ValaMethod* _tmp428_;
						ValaDelegateType* _tmp429_;
						ValaExpression* _tmp440_;
						ValaExpression* _tmp441_;
						ValaVariable* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						ValaDataType* _tmp445_;
						ValaDataType* _tmp446_;
						_tmp414_ = vala_assignment_get_right (self);
						_tmp415_ = _tmp414_;
						_tmp416_ = vala_expression_get_symbol_reference (_tmp415_);
						_tmp417_ = _tmp416_;
						_tmp418_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp417_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp418_;
						_tmp419_ = variable;
						_tmp420_ = vala_variable_get_variable_type (_tmp419_);
						_tmp421_ = _tmp420_;
						_tmp422_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp421_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp422_;
						_tmp423_ = dt;
						_tmp424_ = vala_delegate_type_get_delegate_symbol (_tmp423_);
						_tmp425_ = _tmp424_;
						_tmp426_ = _vala_code_node_ref0 (_tmp425_);
						cb = _tmp426_;
						_tmp427_ = cb;
						_tmp428_ = m;
						_tmp429_ = dt;
						if (!vala_delegate_matches_method (_tmp427_, _tmp428_, (ValaDataType*) _tmp429_)) {
							ValaSourceReference* _tmp430_;
							ValaSourceReference* _tmp431_;
							ValaMethod* _tmp432_;
							gchar* _tmp433_;
							gchar* _tmp434_;
							ValaDelegate* _tmp435_;
							gchar* _tmp436_;
							gchar* _tmp437_;
							gchar* _tmp438_;
							gchar* _tmp439_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp430_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp431_ = _tmp430_;
							_tmp432_ = m;
							_tmp433_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp432_);
							_tmp434_ = _tmp433_;
							_tmp435_ = cb;
							_tmp436_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp435_);
							_tmp437_ = _tmp436_;
							_tmp438_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp434_, _tmp437_);
							_tmp439_ = _tmp438_;
							vala_report_error (_tmp431_, _tmp439_);
							_g_free0 (_tmp439_);
							_g_free0 (_tmp437_);
							_g_free0 (_tmp434_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							return result;
						}
						_tmp440_ = vala_assignment_get_right (self);
						_tmp441_ = _tmp440_;
						_tmp442_ = variable;
						_tmp443_ = vala_variable_get_variable_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = vala_data_type_copy (_tmp444_);
						_tmp446_ = _tmp445_;
						vala_expression_set_value_type (_tmp441_, _tmp446_);
						_vala_code_node_unref0 (_tmp446_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						vala_report_error (_tmp448_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						return result;
					}
					_vala_code_node_unref0 (variable);
				} else {
					ValaMemberAccess* _tmp449_;
					ValaSymbol* _tmp450_;
					ValaSymbol* _tmp451_;
					_tmp449_ = ma;
					_tmp450_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp449_);
					_tmp451_ = _tmp450_;
					if (VALA_IS_VARIABLE (_tmp451_)) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp452_;
						ValaSymbol* _tmp453_;
						ValaSymbol* _tmp454_;
						ValaArrayType* variable_array_type = NULL;
						ValaVariable* _tmp455_;
						ValaDataType* _tmp456_;
						ValaDataType* _tmp457_;
						gboolean _tmp458_ = FALSE;
						gboolean _tmp459_ = FALSE;
						gboolean _tmp460_ = FALSE;
						ValaArrayType* _tmp461_;
						_tmp452_ = ma;
						_tmp453_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp452_);
						_tmp454_ = _tmp453_;
						variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp454_, VALA_TYPE_VARIABLE, ValaVariable);
						_tmp455_ = variable;
						_tmp456_ = vala_variable_get_variable_type (_tmp455_);
						_tmp457_ = _tmp456_;
						variable_array_type = VALA_IS_ARRAY_TYPE (_tmp457_) ? ((ValaArrayType*) _tmp457_) : NULL;
						_tmp461_ = variable_array_type;
						if (_tmp461_ != NULL) {
							ValaArrayType* _tmp462_;
							gboolean _tmp463_;
							gboolean _tmp464_;
							_tmp462_ = variable_array_type;
							_tmp463_ = vala_array_type_get_inline_allocated (_tmp462_);
							_tmp464_ = _tmp463_;
							_tmp460_ = _tmp464_;
						} else {
							_tmp460_ = FALSE;
						}
						if (_tmp460_) {
							ValaExpression* _tmp465_;
							ValaExpression* _tmp466_;
							_tmp465_ = vala_assignment_get_right (self);
							_tmp466_ = _tmp465_;
							_tmp459_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp466_);
						} else {
							_tmp459_ = FALSE;
						}
						if (_tmp459_) {
							ValaExpression* _tmp467_;
							ValaExpression* _tmp468_;
							ValaInitializerList* _tmp469_;
							ValaInitializerList* _tmp470_;
							_tmp467_ = vala_assignment_get_right (self);
							_tmp468_ = _tmp467_;
							_tmp469_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
							_tmp470_ = _tmp469_;
							_tmp458_ = _tmp470_ == NULL;
						} else {
							_tmp458_ = FALSE;
						}
						if (_tmp458_) {
							ValaSourceReference* _tmp471_;
							ValaSourceReference* _tmp472_;
							ValaCodeNode* _tmp473_;
							ValaCodeNode* _tmp474_;
							ValaCodeNode* _tmp475_;
							ValaCodeNode* _tmp476_;
							ValaCodeNode* _tmp477_;
							ValaCodeNode* _tmp478_;
							ValaSourceReference* _tmp479_;
							ValaSourceReference* _tmp480_;
							ValaEmptyStatement* _tmp481_;
							ValaEmptyStatement* _tmp482_;
							_tmp471_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp472_ = _tmp471_;
							vala_report_warning (_tmp472_, "Inline allocated arrays don't require an explicit instantiation");
							_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp474_ = _tmp473_;
							_tmp475_ = vala_code_node_get_parent_node (_tmp474_);
							_tmp476_ = _tmp475_;
							_tmp477_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp478_ = _tmp477_;
							_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp480_ = _tmp479_;
							_tmp481_ = vala_empty_statement_new (_tmp480_);
							_tmp482_ = _tmp481_;
							vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp478_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp482_);
							_vala_code_node_unref0 (_tmp482_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
		_tmp484_ = vala_assignment_get_left (self);
		_tmp485_ = _tmp484_;
		_tmp486_ = vala_expression_get_value_type (_tmp485_);
		_tmp487_ = _tmp486_;
		if (_tmp487_ != NULL) {
			ValaExpression* _tmp488_;
			ValaExpression* _tmp489_;
			ValaDataType* _tmp490_;
			ValaDataType* _tmp491_;
			_tmp488_ = vala_assignment_get_right (self);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_expression_get_value_type (_tmp489_);
			_tmp491_ = _tmp490_;
			_tmp483_ = _tmp491_ != NULL;
		} else {
			_tmp483_ = FALSE;
		}
		if (_tmp483_) {
			ValaExpression* _tmp492_;
			ValaExpression* _tmp493_;
			ValaDataType* _tmp494_;
			ValaDataType* _tmp495_;
			ValaExpression* _tmp496_;
			ValaExpression* _tmp497_;
			ValaDataType* _tmp498_;
			ValaDataType* _tmp499_;
			ValaMemberAccess* _tmp516_;
			ValaSymbol* _tmp517_;
			ValaSymbol* _tmp518_;
			_tmp492_ = vala_assignment_get_right (self);
			_tmp493_ = _tmp492_;
			_tmp494_ = vala_expression_get_value_type (_tmp493_);
			_tmp495_ = _tmp494_;
			_tmp496_ = vala_assignment_get_left (self);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_expression_get_value_type (_tmp497_);
			_tmp499_ = _tmp498_;
			if (!vala_data_type_compatible (_tmp495_, _tmp499_)) {
				ValaSourceReference* _tmp500_;
				ValaSourceReference* _tmp501_;
				ValaExpression* _tmp502_;
				ValaExpression* _tmp503_;
				ValaDataType* _tmp504_;
				ValaDataType* _tmp505_;
				gchar* _tmp506_;
				gchar* _tmp507_;
				ValaExpression* _tmp508_;
				ValaExpression* _tmp509_;
				ValaDataType* _tmp510_;
				ValaDataType* _tmp511_;
				gchar* _tmp512_;
				gchar* _tmp513_;
				gchar* _tmp514_;
				gchar* _tmp515_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp501_ = _tmp500_;
				_tmp502_ = vala_assignment_get_right (self);
				_tmp503_ = _tmp502_;
				_tmp504_ = vala_expression_get_value_type (_tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = vala_code_node_to_string ((ValaCodeNode*) _tmp505_);
				_tmp507_ = _tmp506_;
				_tmp508_ = vala_assignment_get_left (self);
				_tmp509_ = _tmp508_;
				_tmp510_ = vala_expression_get_value_type (_tmp509_);
				_tmp511_ = _tmp510_;
				_tmp512_ = vala_code_node_to_string ((ValaCodeNode*) _tmp511_);
				_tmp513_ = _tmp512_;
				_tmp514_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp507_, _tmp513_);
				_tmp515_ = _tmp514_;
				vala_report_error (_tmp501_, _tmp515_);
				_g_free0 (_tmp515_);
				_g_free0 (_tmp513_);
				_g_free0 (_tmp507_);
				result = FALSE;
				return result;
			}
			_tmp516_ = ma;
			_tmp517_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp516_);
			_tmp518_ = _tmp517_;
			if (!VALA_IS_PROPERTY (_tmp518_)) {
				ValaExpression* _tmp519_;
				ValaExpression* _tmp520_;
				ValaDataType* _tmp521_;
				ValaDataType* _tmp522_;
				_tmp519_ = vala_assignment_get_right (self);
				_tmp520_ = _tmp519_;
				_tmp521_ = vala_expression_get_value_type (_tmp520_);
				_tmp522_ = _tmp521_;
				if (vala_data_type_is_disposable (_tmp522_)) {
					gboolean _tmp523_ = FALSE;
					ValaExpression* _tmp524_;
					ValaExpression* _tmp525_;
					ValaDataType* _tmp526_;
					ValaDataType* _tmp527_;
					_tmp524_ = vala_assignment_get_left (self);
					_tmp525_ = _tmp524_;
					_tmp526_ = vala_expression_get_value_type (_tmp525_);
					_tmp527_ = _tmp526_;
					if (!VALA_IS_POINTER_TYPE (_tmp527_)) {
						ValaExpression* _tmp528_;
						ValaExpression* _tmp529_;
						ValaDataType* _tmp530_;
						ValaDataType* _tmp531_;
						gboolean _tmp532_;
						gboolean _tmp533_;
						_tmp528_ = vala_assignment_get_left (self);
						_tmp529_ = _tmp528_;
						_tmp530_ = vala_expression_get_value_type (_tmp529_);
						_tmp531_ = _tmp530_;
						_tmp532_ = vala_data_type_get_value_owned (_tmp531_);
						_tmp533_ = _tmp532_;
						_tmp523_ = !_tmp533_;
					} else {
						_tmp523_ = FALSE;
					}
					if (_tmp523_) {
						ValaSourceReference* _tmp534_;
						ValaSourceReference* _tmp535_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp534_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp535_ = _tmp534_;
						vala_report_error (_tmp535_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp536_;
					ValaExpression* _tmp537_;
					ValaDataType* _tmp538_;
					ValaDataType* _tmp539_;
					gboolean _tmp540_;
					gboolean _tmp541_;
					_tmp536_ = vala_assignment_get_left (self);
					_tmp537_ = _tmp536_;
					_tmp538_ = vala_expression_get_value_type (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = vala_data_type_get_value_owned (_tmp539_);
					_tmp541_ = _tmp540_;
					if (_tmp541_) {
					}
				}
			}
		}
		_tmp542_ = vala_assignment_get_right (self);
		_tmp543_ = _tmp542_;
		_tmp544_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp543_) ? ((ValaMemberAccess*) _tmp543_) : NULL);
		right_ma = _tmp544_;
		_tmp546_ = right_ma;
		if (_tmp546_ != NULL) {
			ValaMemberAccess* _tmp547_;
			ValaSymbol* _tmp548_;
			ValaSymbol* _tmp549_;
			ValaMemberAccess* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaSymbol* _tmp552_;
			_tmp547_ = ma;
			_tmp548_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp547_);
			_tmp549_ = _tmp548_;
			_tmp550_ = right_ma;
			_tmp551_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp550_);
			_tmp552_ = _tmp551_;
			_tmp545_ = _tmp549_ == _tmp552_;
		} else {
			_tmp545_ = FALSE;
		}
		if (_tmp545_) {
			gboolean _tmp553_ = FALSE;
			ValaMemberAccess* _tmp554_;
			ValaSymbol* _tmp555_;
			ValaSymbol* _tmp556_;
			_tmp554_ = ma;
			_tmp555_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp554_);
			_tmp556_ = _tmp555_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp556_)) {
				_tmp553_ = TRUE;
			} else {
				ValaMemberAccess* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp559_;
				_tmp557_ = ma;
				_tmp558_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp553_ = VALA_IS_PARAMETER (_tmp559_);
			}
			if (_tmp553_) {
				ValaSourceReference* _tmp560_;
				ValaSourceReference* _tmp561_;
				_tmp560_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp561_ = _tmp560_;
				vala_report_warning (_tmp561_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp562_;
				ValaSymbol* _tmp563_;
				ValaSymbol* _tmp564_;
				_tmp562_ = ma;
				_tmp563_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp562_);
				_tmp564_ = _tmp563_;
				if (VALA_IS_FIELD (_tmp564_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp565_;
					ValaSymbol* _tmp566_;
					ValaSymbol* _tmp567_;
					ValaField* _tmp568_;
					ValaField* _tmp569_;
					ValaMemberBinding _tmp570_;
					ValaMemberBinding _tmp571_;
					_tmp565_ = ma;
					_tmp566_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp565_);
					_tmp567_ = _tmp566_;
					_tmp568_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp567_, VALA_TYPE_FIELD, ValaField));
					f = _tmp568_;
					_tmp569_ = f;
					_tmp570_ = vala_field_get_binding (_tmp569_);
					_tmp571_ = _tmp570_;
					if (_tmp571_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp572_;
						ValaSourceReference* _tmp573_;
						_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp573_ = _tmp572_;
						vala_report_warning (_tmp573_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp574_;
						ValaExpression* _tmp575_;
						ValaExpression* _tmp576_;
						ValaMemberAccess* _tmp577_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp578_;
						ValaExpression* _tmp579_;
						ValaExpression* _tmp580_;
						ValaMemberAccess* _tmp581_;
						gboolean _tmp582_ = FALSE;
						gboolean _tmp583_ = FALSE;
						gboolean _tmp584_ = FALSE;
						gboolean _tmp585_ = FALSE;
						gboolean _tmp586_ = FALSE;
						ValaMemberAccess* _tmp587_;
						_tmp574_ = ma;
						_tmp575_ = vala_member_access_get_inner (_tmp574_);
						_tmp576_ = _tmp575_;
						_tmp577_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp576_) ? ((ValaMemberAccess*) _tmp576_) : NULL);
						ma_inner = _tmp577_;
						_tmp578_ = right_ma;
						_tmp579_ = vala_member_access_get_inner (_tmp578_);
						_tmp580_ = _tmp579_;
						_tmp581_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp580_) ? ((ValaMemberAccess*) _tmp580_) : NULL);
						right_ma_inner = _tmp581_;
						_tmp587_ = ma_inner;
						if (_tmp587_ != NULL) {
							ValaMemberAccess* _tmp588_;
							const gchar* _tmp589_;
							const gchar* _tmp590_;
							_tmp588_ = ma_inner;
							_tmp589_ = vala_member_access_get_member_name (_tmp588_);
							_tmp590_ = _tmp589_;
							_tmp586_ = g_strcmp0 (_tmp590_, "this") == 0;
						} else {
							_tmp586_ = FALSE;
						}
						if (_tmp586_) {
							ValaMemberAccess* _tmp591_;
							ValaExpression* _tmp592_;
							ValaExpression* _tmp593_;
							_tmp591_ = ma_inner;
							_tmp592_ = vala_member_access_get_inner (_tmp591_);
							_tmp593_ = _tmp592_;
							_tmp585_ = _tmp593_ == NULL;
						} else {
							_tmp585_ = FALSE;
						}
						if (_tmp585_) {
							ValaMemberAccess* _tmp594_;
							_tmp594_ = right_ma_inner;
							_tmp584_ = _tmp594_ != NULL;
						} else {
							_tmp584_ = FALSE;
						}
						if (_tmp584_) {
							ValaMemberAccess* _tmp595_;
							const gchar* _tmp596_;
							const gchar* _tmp597_;
							_tmp595_ = right_ma_inner;
							_tmp596_ = vala_member_access_get_member_name (_tmp595_);
							_tmp597_ = _tmp596_;
							_tmp583_ = g_strcmp0 (_tmp597_, "this") == 0;
						} else {
							_tmp583_ = FALSE;
						}
						if (_tmp583_) {
							ValaMemberAccess* _tmp598_;
							ValaExpression* _tmp599_;
							ValaExpression* _tmp600_;
							_tmp598_ = right_ma_inner;
							_tmp599_ = vala_member_access_get_inner (_tmp598_);
							_tmp600_ = _tmp599_;
							_tmp582_ = _tmp600_ == NULL;
						} else {
							_tmp582_ = FALSE;
						}
						if (_tmp582_) {
							ValaSourceReference* _tmp601_;
							ValaSourceReference* _tmp602_;
							_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp602_ = _tmp601_;
							vala_report_warning (_tmp602_, "Assignment to same variable");
						}
						_vala_code_node_unref0 (right_ma_inner);
						_vala_code_node_unref0 (ma_inner);
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
	} else {
		ValaExpression* _tmp603_;
		ValaExpression* _tmp604_;
		_tmp603_ = vala_assignment_get_left (self);
		_tmp604_ = _tmp603_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp604_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp605_;
			ValaExpression* _tmp606_;
			ValaElementAccess* _tmp607_;
			ValaExpression* _tmp608_;
			ValaExpression* _tmp609_;
			ValaDataType* _tmp610_;
			ValaDataType* _tmp611_;
			ValaExpression* _tmp612_;
			ValaExpression* _tmp613_;
			ValaDataType* _tmp614_;
			ValaDataType* _tmp615_;
			ValaExpression* _tmp632_;
			ValaExpression* _tmp633_;
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			_tmp605_ = vala_assignment_get_left (self);
			_tmp606_ = _tmp605_;
			_tmp607_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp606_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp607_;
			_tmp608_ = vala_assignment_get_right (self);
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_expression_get_value_type (_tmp609_);
			_tmp611_ = _tmp610_;
			_tmp612_ = vala_assignment_get_left (self);
			_tmp613_ = _tmp612_;
			_tmp614_ = vala_expression_get_value_type (_tmp613_);
			_tmp615_ = _tmp614_;
			if (!vala_data_type_compatible (_tmp611_, _tmp615_)) {
				ValaSourceReference* _tmp616_;
				ValaSourceReference* _tmp617_;
				ValaExpression* _tmp618_;
				ValaExpression* _tmp619_;
				ValaDataType* _tmp620_;
				ValaDataType* _tmp621_;
				gchar* _tmp622_;
				gchar* _tmp623_;
				ValaExpression* _tmp624_;
				ValaExpression* _tmp625_;
				ValaDataType* _tmp626_;
				ValaDataType* _tmp627_;
				gchar* _tmp628_;
				gchar* _tmp629_;
				gchar* _tmp630_;
				gchar* _tmp631_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp616_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_assignment_get_right (self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_expression_get_value_type (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_code_node_to_string ((ValaCodeNode*) _tmp621_);
				_tmp623_ = _tmp622_;
				_tmp624_ = vala_assignment_get_left (self);
				_tmp625_ = _tmp624_;
				_tmp626_ = vala_expression_get_value_type (_tmp625_);
				_tmp627_ = _tmp626_;
				_tmp628_ = vala_code_node_to_string ((ValaCodeNode*) _tmp627_);
				_tmp629_ = _tmp628_;
				_tmp630_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp623_, _tmp629_);
				_tmp631_ = _tmp630_;
				vala_report_error (_tmp617_, _tmp631_);
				_g_free0 (_tmp631_);
				_g_free0 (_tmp629_);
				_g_free0 (_tmp623_);
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			}
			_tmp632_ = vala_assignment_get_right (self);
			_tmp633_ = _tmp632_;
			_tmp634_ = vala_expression_get_value_type (_tmp633_);
			_tmp635_ = _tmp634_;
			if (vala_data_type_is_disposable (_tmp635_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp636_;
				ValaExpression* _tmp637_;
				ValaExpression* _tmp638_;
				ValaDataType* _tmp639_;
				ValaDataType* _tmp640_;
				gboolean _tmp662_ = FALSE;
				ValaDataType* _tmp663_;
				_tmp636_ = ea;
				_tmp637_ = vala_element_access_get_container (_tmp636_);
				_tmp638_ = _tmp637_;
				_tmp639_ = vala_expression_get_value_type (_tmp638_);
				_tmp640_ = _tmp639_;
				if (VALA_IS_ARRAY_TYPE (_tmp640_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp641_;
					ValaExpression* _tmp642_;
					ValaExpression* _tmp643_;
					ValaDataType* _tmp644_;
					ValaDataType* _tmp645_;
					ValaArrayType* _tmp646_;
					ValaArrayType* _tmp647_;
					ValaDataType* _tmp648_;
					ValaDataType* _tmp649_;
					ValaDataType* _tmp650_;
					_tmp641_ = ea;
					_tmp642_ = vala_element_access_get_container (_tmp641_);
					_tmp643_ = _tmp642_;
					_tmp644_ = vala_expression_get_value_type (_tmp643_);
					_tmp645_ = _tmp644_;
					_tmp646_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp645_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp646_;
					_tmp647_ = array_type;
					_tmp648_ = vala_array_type_get_element_type (_tmp647_);
					_tmp649_ = _tmp648_;
					_tmp650_ = _vala_code_node_ref0 (_tmp649_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp650_;
					_vala_code_node_unref0 (array_type);
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp651_;
					ValaExpression* _tmp652_;
					ValaExpression* _tmp653_;
					ValaDataType* _tmp654_;
					ValaDataType* _tmp655_;
					ValaList* _tmp656_;
					ValaList* _tmp657_;
					gint _tmp658_;
					gint _tmp659_;
					ValaList* _tmp660_;
					gpointer _tmp661_;
					_tmp651_ = ea;
					_tmp652_ = vala_element_access_get_container (_tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_expression_get_value_type (_tmp653_);
					_tmp655_ = _tmp654_;
					_tmp656_ = vala_data_type_get_type_arguments (_tmp655_);
					args = _tmp656_;
					_tmp657_ = args;
					_tmp658_ = vala_collection_get_size ((ValaCollection*) _tmp657_);
					_tmp659_ = _tmp658_;
					_vala_assert (_tmp659_ == 1, "args.size == 1");
					_tmp660_ = args;
					_tmp661_ = vala_list_get (_tmp660_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp661_;
					_vala_iterable_unref0 (args);
				}
				_tmp663_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp663_)) {
					ValaDataType* _tmp664_;
					gboolean _tmp665_;
					gboolean _tmp666_;
					_tmp664_ = element_type;
					_tmp665_ = vala_data_type_get_value_owned (_tmp664_);
					_tmp666_ = _tmp665_;
					_tmp662_ = !_tmp666_;
				} else {
					_tmp662_ = FALSE;
				}
				if (_tmp662_) {
					ValaSourceReference* _tmp667_;
					ValaSourceReference* _tmp668_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp667_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp668_ = _tmp667_;
					vala_report_error (_tmp668_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (ea);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp669_;
				ValaExpression* _tmp670_;
				ValaDataType* _tmp671_;
				ValaDataType* _tmp672_;
				gboolean _tmp673_;
				gboolean _tmp674_;
				_tmp669_ = vala_assignment_get_left (self);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_expression_get_value_type (_tmp670_);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_data_type_get_value_owned (_tmp672_);
				_tmp674_ = _tmp673_;
				if (_tmp674_) {
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp675_ = vala_assignment_get_left (self);
	_tmp676_ = _tmp675_;
	_tmp677_ = vala_expression_get_value_type (_tmp676_);
	_tmp678_ = _tmp677_;
	if (_tmp678_ != NULL) {
		ValaExpression* _tmp679_;
		ValaExpression* _tmp680_;
		ValaDataType* _tmp681_;
		ValaDataType* _tmp682_;
		ValaDataType* _tmp683_;
		ValaDataType* _tmp684_;
		ValaDataType* _tmp685_;
		ValaDataType* _tmp686_;
		_tmp679_ = vala_assignment_get_left (self);
		_tmp680_ = _tmp679_;
		_tmp681_ = vala_expression_get_value_type (_tmp680_);
		_tmp682_ = _tmp681_;
		_tmp683_ = vala_data_type_copy (_tmp682_);
		_tmp684_ = _tmp683_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp684_);
		_vala_code_node_unref0 (_tmp684_);
		_tmp685_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp686_ = _tmp685_;
		vala_data_type_set_value_owned (_tmp686_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp687_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp688_ = _tmp687_;
	if (_tmp688_ != NULL) {
		ValaDataType* _tmp689_;
		ValaDataType* _tmp690_;
		_tmp689_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp690_ = _tmp689_;
		vala_code_node_check ((ValaCodeNode*) _tmp690_, context);
	}
	_tmp691_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp692_ = _tmp691_;
	result = !_tmp692_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = VALA_IS_ARRAY_TYPE (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp133_;
	ValaExpression* _tmp134_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_POINTER_INDIRECTION (_tmp7_) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp12_) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp16_) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp20_) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (VALA_IS_PROPERTY (_tmp24_) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp47_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp54_);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			ValaExpression* _tmp62_;
			ValaExpression* _tmp63_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaTargetValue* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaLocalVariable* _tmp69_;
			ValaCodeNode* _tmp94_;
			ValaCodeNode* _tmp95_;
			if (instance) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				vala_code_node_emit ((ValaCodeNode*) _tmp61_, codegen);
			}
			_tmp62_ = vala_assignment_get_right (self);
			_tmp63_ = _tmp62_;
			vala_code_node_emit ((ValaCodeNode*) _tmp63_, codegen);
			_tmp64_ = vala_assignment_get_right (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_target_value (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _vala_target_value_ref0 (_tmp67_);
			new_value = _tmp68_;
			_tmp69_ = local;
			if (_tmp69_ != NULL) {
				ValaLocalVariable* _tmp70_;
				ValaTargetValue* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				_tmp70_ = local;
				_tmp71_ = new_value;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp73_ = _tmp72_;
				vala_code_generator_store_local (codegen, _tmp70_, _tmp71_, FALSE, _tmp73_);
			} else {
				ValaParameter* _tmp74_;
				_tmp74_ = param;
				if (_tmp74_ != NULL) {
					ValaParameter* _tmp75_;
					ValaTargetValue* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSourceReference* _tmp78_;
					_tmp75_ = param;
					_tmp76_ = new_value;
					_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp78_ = _tmp77_;
					vala_code_generator_store_parameter (codegen, _tmp75_, _tmp76_, FALSE, _tmp78_);
				} else {
					ValaField* _tmp79_;
					_tmp79_ = field;
					if (_tmp79_ != NULL) {
						ValaTargetValue* _tmp80_ = NULL;
						gboolean _tmp81_ = FALSE;
						ValaField* _tmp90_;
						ValaTargetValue* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						if (instance) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp81_ = _tmp84_ != NULL;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaTargetValue* _tmp88_;
							ValaTargetValue* _tmp89_;
							_tmp85_ = ma;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_target_value (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp80_ = _tmp89_;
						} else {
							_tmp80_ = NULL;
						}
						_tmp90_ = field;
						_tmp91_ = new_value;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp93_ = _tmp92_;
						vala_code_generator_store_field (codegen, _tmp90_, _tmp80_, _tmp91_, _tmp93_);
					}
				}
			}
			_tmp94_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp95_)) {
				ValaLocalVariable* _tmp96_;
				_tmp96_ = local;
				if (_tmp96_ != NULL) {
					ValaLocalVariable* _tmp97_;
					ValaTargetValue* _tmp98_;
					ValaTargetValue* _tmp99_;
					_tmp97_ = local;
					_tmp98_ = vala_code_generator_load_local (codegen, _tmp97_);
					_tmp99_ = _tmp98_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp99_);
					_vala_target_value_unref0 (_tmp99_);
				} else {
					ValaParameter* _tmp100_;
					_tmp100_ = param;
					if (_tmp100_ != NULL) {
						ValaParameter* _tmp101_;
						ValaTargetValue* _tmp102_;
						ValaTargetValue* _tmp103_;
						_tmp101_ = param;
						_tmp102_ = vala_code_generator_load_parameter (codegen, _tmp101_);
						_tmp103_ = _tmp102_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp103_);
						_vala_target_value_unref0 (_tmp103_);
					} else {
						ValaField* _tmp104_;
						_tmp104_ = field;
						if (_tmp104_ != NULL) {
							ValaTargetValue* _tmp105_ = NULL;
							gboolean _tmp106_ = FALSE;
							ValaField* _tmp115_;
							ValaTargetValue* _tmp116_;
							ValaTargetValue* _tmp117_;
							if (instance) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp106_ = _tmp109_ != NULL;
							} else {
								_tmp106_ = FALSE;
							}
							if (_tmp106_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								ValaTargetValue* _tmp113_;
								ValaTargetValue* _tmp114_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = vala_expression_get_target_value (_tmp112_);
								_tmp114_ = _tmp113_;
								_tmp105_ = _tmp114_;
							} else {
								_tmp105_ = NULL;
							}
							_tmp115_ = field;
							_tmp116_ = vala_code_generator_load_field (codegen, _tmp115_, _tmp105_);
							_tmp117_ = _tmp116_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp117_);
							_vala_target_value_unref0 (_tmp117_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp120_;
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			_tmp120_ = ma;
			_tmp121_ = vala_member_access_get_inner (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp119_ = _tmp122_ != NULL;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaProperty* _tmp123_;
			_tmp123_ = property;
			_tmp118_ = _tmp123_ != NULL;
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			vala_code_node_emit ((ValaCodeNode*) _tmp126_, codegen);
		} else {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			if (_tmp127_ == NULL) {
				ValaMemberAccess* _tmp128_;
				_tmp128_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp128_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp129_;
		_tmp129_ = ea;
		if (_tmp129_ != NULL) {
			ValaElementAccess* _tmp130_;
			_tmp130_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaPointerIndirection* _tmp131_;
			_tmp131_ = pi;
			if (_tmp131_ != NULL) {
				ValaPointerIndirection* _tmp132_;
				_tmp132_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
	}
	_tmp133_ = vala_assignment_get_right (self);
	_tmp134_ = _tmp133_;
	vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

