/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaSet* all_basic_blocks;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};

static gint ValaFlowAnalyzer_private_offset;
static gpointer vala_flow_analyzer_parent_class = NULL;
static gint ValaFlowAnalyzerJumpTarget_private_offset;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_set_jump_target (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_take_jump_target (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                           ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                         ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                          ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                      ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                           ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                          ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                           ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                                                    ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                                                  ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                      ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                                   ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                                  ValaList* block_list,
                                                  ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                              ValaBasicBlock* current,
                                              ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                                              ValaBasicBlock** idoms,
                                              gint idoms_length1,
                                              ValaBasicBlock* b1,
                                              ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                                ValaList* block_list,
                                                ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                               ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                                     ValaMap* var_map,
                                                     ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                                    ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                             ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                      ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                          ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                          ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                         ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                       ValaCodeNode* node,
                                       gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                                   ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                         ValaExpressionStatement* stmt);
static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                         ValaExpression* condition);
static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                          ValaExpression* condition);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                                 ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                     ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                         ValaLoop* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                                                      ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                      ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                                    ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                       ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                     ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                                    ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                                                 ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                                               ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                                                     ValaBasicBlock* basic_block,
                                                                                     ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                                             ValaCatchClause* catch_clause,
                                                                             ValaErrorDomain* error_domain,
                                                                             ValaErrorCode* error_code,
                                                                             ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block,
                                                                                   ValaCatchClause* catch_clause,
                                                                                   ValaErrorDomain* error_domain,
                                                                                   ValaErrorCode* error_code,
                                                                                   ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                                   ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                     ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                               ValaExpression* expr);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                            gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                          gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                        gboolean value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                           gboolean value);
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaCatchClause* value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static GType vala_flow_analyzer_jump_target_get_type_once (void);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static GType vala_flow_analyzer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
vala_flow_analyzer_get_instance_private (ValaFlowAnalyzer* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzer_private_offset);
}

ValaFlowAnalyzer*
vala_flow_analyzer_construct (GType object_type)
{
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}

ValaFlowAnalyzer*
vala_flow_analyzer_new (void)
{
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}

/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_flow_analyzer_analyze (ValaFlowAnalyzer* self,
                            ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	ValaList* source_files = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_, _tmp2_);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = (ValaSet*) _tmp3_;
	_tmp4_ = vala_code_context_get_source_files (context);
	_tmp5_ = _vala_iterable_ref0 (_tmp4_);
	source_files = _tmp5_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _file_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _file_index = 0;
		_tmp6_ = source_files;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_file_list = _tmp7_;
		_tmp8_ = _file_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_file_size = _tmp10_;
		_file_index = -1;
		while (TRUE) {
			ValaSourceFile* file = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaSourceFile* _tmp13_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp11_ = _file_list;
			_tmp12_ = vala_list_get (_tmp11_, _file_index);
			file = (ValaSourceFile*) _tmp12_;
			_tmp13_ = file;
			vala_source_file_accept (_tmp13_, (ValaCodeVisitor*) self);
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	self->priv->all_basic_blocks = NULL;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_iterable_unref0 (source_files);
}

static void
vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                           ValaSourceFile* source_file)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                      ValaStruct* st)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                    ValaEnum* en)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* ed)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                     ValaField* f)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_used ((ValaSymbol*) f);
		_tmp3_ = _tmp2_;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_symbol_get_external_package ((ValaSymbol*) f);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp6_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			gboolean _tmp7_ = FALSE;
			ValaCodeContext* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_internal_header_filename (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaCodeContext* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = self->priv->context;
				_tmp12_ = vala_code_context_get_use_fast_vapi (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			_tmp6_ = _tmp7_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
		} else {
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_symbol_get_full_name ((ValaSymbol*) f);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("field `%s' never used", _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_warning (_tmp15_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
		}
	}
}

static gpointer
_vala_basic_block_ref0 (gpointer self)
{
	return self ? vala_basic_block_ref (self) : NULL;
}

static void
vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                 ValaLambdaExpression* le)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaList* _tmp7_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	old_unreachable_reported = self->priv->unreachable_reported;
	_tmp2_ = self->priv->jump_stack;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	old_jump_stack = _tmp3_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp5_;
	vala_code_node_accept_children ((ValaCodeNode*) le, (ValaCodeVisitor*) self);
	_tmp6_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp6_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp7_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp7_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}

static void
vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                      ValaMethod* m)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = vala_symbol_get_used ((ValaSymbol*) m);
		_tmp7_ = _tmp6_;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = vala_method_get_entry_point (m);
		_tmp9_ = _tmp8_;
		_tmp4_ = !_tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = vala_symbol_get_external_package ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp3_ = !_tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = vala_method_get_overrides (m);
		_tmp13_ = _tmp12_;
		_tmp2_ = !_tmp13_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp14_ = FALSE;
		ValaMethod* _tmp15_;
		ValaMethod* _tmp16_;
		_tmp15_ = vala_method_get_base_interface_method (m);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			_tmp17_ = vala_method_get_base_interface_method (m);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == m;
		}
		_tmp1_ = _tmp14_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp19_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			gboolean _tmp20_ = FALSE;
			ValaCodeContext* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = self->priv->context;
			_tmp22_ = vala_code_context_get_internal_header_filename (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ != NULL) {
				_tmp20_ = TRUE;
			} else {
				ValaCodeContext* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = self->priv->context;
				_tmp25_ = vala_code_context_get_use_fast_vapi (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = _tmp26_;
			}
			_tmp19_ = _tmp20_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			ValaSymbol* _tmp29_;
			ValaSymbol* _tmp30_;
			_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp30_ = _tmp29_;
			if (_tmp30_ != NULL) {
				ValaSymbol* _tmp31_;
				ValaSymbol* _tmp32_;
				ValaAttribute* _tmp33_;
				_tmp31_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp32_, "DBus");
				_tmp28_ = _tmp33_ != NULL;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				_tmp27_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "visible", TRUE);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
			} else {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) m);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strdup_printf ("method `%s' never used", _tmp37_);
				_tmp39_ = _tmp38_;
				vala_report_warning (_tmp35_, _tmp39_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
			}
		}
	}
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) m);
}

static void
vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                      ValaSignal* sig)
{
	ValaFlowAnalyzer * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_signal_get_default_handler (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_default_handler (sig);
		_tmp3_ = _tmp2_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp3_);
	}
}

static void
vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                     ValaSubroutine* m)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaSet* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaSet* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaSet* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp43_;
	ValaSet* _tmp44_;
	ValaBasicBlock* _tmp45_;
	ValaBasicBlock* _tmp46_;
	ValaBasicBlock* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaBasicBlock* _tmp49_;
	ValaList* _tmp50_;
	ValaBasicBlock* _tmp51_;
	ValaBasicBlock* _tmp52_;
	ValaFlowAnalyzerJumpTarget* _tmp53_;
	ValaFlowAnalyzerJumpTarget* _tmp54_;
	ValaList* _tmp55_;
	ValaBasicBlock* _tmp56_;
	ValaBasicBlock* _tmp57_;
	ValaFlowAnalyzerJumpTarget* _tmp58_;
	ValaFlowAnalyzerJumpTarget* _tmp59_;
	ValaList* _tmp60_;
	ValaList* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gpointer _tmp64_;
	ValaFlowAnalyzerJumpTarget* _tmp65_;
	ValaBasicBlock* _tmp66_;
	ValaBasicBlock* _tmp74_;
	ValaBasicBlock* _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_subroutine_get_body (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = vala_basic_block_new_entry ();
	_tmp3_ = _tmp2_;
	vala_subroutine_set_entry_block (m, _tmp3_);
	_vala_basic_block_unref0 (_tmp3_);
	_tmp4_ = self->priv->all_basic_blocks;
	_tmp5_ = vala_subroutine_get_entry_block (m);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp6_);
	_tmp7_ = vala_basic_block_new ();
	_tmp8_ = _tmp7_;
	vala_subroutine_set_return_block (m, _tmp8_);
	_vala_basic_block_unref0 (_tmp8_);
	_tmp9_ = self->priv->all_basic_blocks;
	_tmp10_ = vala_subroutine_get_return_block (m);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp9_, _tmp11_);
	_tmp12_ = vala_basic_block_new_exit ();
	_tmp13_ = _tmp12_;
	vala_subroutine_set_exit_block (m, _tmp13_);
	_vala_basic_block_unref0 (_tmp13_);
	_tmp14_ = self->priv->all_basic_blocks;
	_tmp15_ = vala_subroutine_get_exit_block (m);
	_tmp16_ = _tmp15_;
	vala_collection_add ((ValaCollection*) _tmp14_, _tmp16_);
	_tmp17_ = vala_subroutine_get_return_block (m);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_subroutine_get_exit_block (m);
	_tmp20_ = _tmp19_;
	vala_basic_block_connect (_tmp18_, _tmp20_);
	if (VALA_IS_METHOD (m)) {
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp21_;
			ValaList* _tmp22_;
			gint _param_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _param_index = 0;
			_tmp21_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_METHOD, ValaMethod));
			_tmp22_ = _vala_iterable_ref0 (_tmp21_);
			_param_list = _tmp22_;
			_tmp23_ = _param_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_param_size = _tmp25_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp26_;
				gpointer _tmp27_;
				ValaParameter* _tmp28_;
				ValaParameterDirection _tmp29_;
				ValaParameterDirection _tmp30_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp26_ = _param_list;
				_tmp27_ = vala_list_get (_tmp26_, _param_index);
				param = (ValaParameter*) _tmp27_;
				_tmp28_ = param;
				_tmp29_ = vala_parameter_get_direction (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					ValaParameter* _tmp34_;
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					ValaMemberAccess* _tmp37_;
					ValaMemberAccess* _tmp38_;
					ValaParameter* _tmp39_;
					ValaBasicBlock* _tmp40_;
					ValaBasicBlock* _tmp41_;
					ValaMemberAccess* _tmp42_;
					_tmp31_ = param;
					_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = param;
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_member_access_new_simple (_tmp33_, _tmp36_);
					param_ma = _tmp37_;
					_tmp38_ = param_ma;
					_tmp39_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp38_, (ValaSymbol*) _tmp39_);
					_tmp40_ = vala_subroutine_get_return_block (m);
					_tmp41_ = _tmp40_;
					_tmp42_ = param_ma;
					vala_basic_block_add_node (_tmp41_, (ValaCodeNode*) _tmp42_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp43_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp43_;
	_tmp44_ = self->priv->all_basic_blocks;
	_tmp45_ = self->priv->current_block;
	vala_collection_add ((ValaCollection*) _tmp44_, _tmp45_);
	_tmp46_ = vala_subroutine_get_entry_block (m);
	_tmp47_ = _tmp46_;
	_tmp48_ = self->priv->current_block;
	vala_basic_block_connect (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp49_, (ValaCodeNode*) m);
	_tmp50_ = self->priv->jump_stack;
	_tmp51_ = vala_subroutine_get_return_block (m);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_flow_analyzer_jump_target_new_return_target (_tmp52_);
	_tmp54_ = _tmp53_;
	vala_collection_add ((ValaCollection*) _tmp50_, _tmp54_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp54_);
	_tmp55_ = self->priv->jump_stack;
	_tmp56_ = vala_subroutine_get_exit_block (m);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp57_);
	_tmp59_ = _tmp58_;
	vala_collection_add ((ValaCollection*) _tmp55_, _tmp59_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp59_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp60_ = self->priv->jump_stack;
	_tmp61_ = self->priv->jump_stack;
	_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_list_remove_at (_tmp60_, _tmp63_ - 1);
	_tmp65_ = (ValaFlowAnalyzerJumpTarget*) _tmp64_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp65_);
	_tmp66_ = self->priv->current_block;
	if (_tmp66_ != NULL) {
		gboolean _tmp67_;
		gboolean _tmp68_;
		ValaBasicBlock* _tmp71_;
		ValaBasicBlock* _tmp72_;
		ValaBasicBlock* _tmp73_;
		_tmp67_ = vala_subroutine_get_has_result (m);
		_tmp68_ = _tmp67_;
		if (_tmp68_) {
			ValaSourceReference* _tmp69_;
			ValaSourceReference* _tmp70_;
			_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp70_ = _tmp69_;
			vala_report_error (_tmp70_, "missing return statement at end of subroutine body");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		}
		_tmp71_ = self->priv->current_block;
		_tmp72_ = vala_subroutine_get_return_block (m);
		_tmp73_ = _tmp72_;
		vala_basic_block_connect (_tmp71_, _tmp73_);
	}
	_tmp74_ = vala_subroutine_get_entry_block (m);
	_tmp75_ = _tmp74_;
	vala_flow_analyzer_analyze_body (self, _tmp75_);
}

static void
vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                 ValaBasicBlock* entry_block)
{
	ValaList* block_list = NULL;
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_depth_first_list (self, entry_block);
	block_list = _tmp0_;
	vala_flow_analyzer_build_dominator_tree (self, block_list, entry_block);
	vala_flow_analyzer_build_dominator_frontier (self, block_list, entry_block);
	vala_flow_analyzer_insert_phi_functions (self, block_list, entry_block);
	vala_flow_analyzer_check_variables (self, entry_block);
	_vala_iterable_unref0 (block_list);
}

static ValaList*
vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block)
{
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	vala_flow_analyzer_depth_first_traverse (self, entry_block, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}

static void
vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* current,
                                         ValaList* list)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_basic_block_get_postorder_visited (current);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_basic_block_set_postorder_visited (current, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _succ_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _succ_index = 0;
		_tmp2_ = vala_basic_block_get_successors (current);
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_succ_list = _tmp3_;
		_tmp4_ = _succ_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_succ_size = _tmp6_;
		_succ_index = -1;
		while (TRUE) {
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaBasicBlock* _tmp9_;
			_succ_index = _succ_index + 1;
			if (!(_succ_index < _succ_size)) {
				break;
			}
			_tmp7_ = _succ_list;
			_tmp8_ = vala_list_get (_tmp7_, _succ_index);
			succ = (ValaBasicBlock*) _tmp8_;
			_tmp9_ = succ;
			vala_flow_analyzer_depth_first_traverse (self, _tmp9_, list);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	_tmp10_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp11_ = _tmp10_;
	vala_basic_block_set_postorder_number (current, _tmp11_);
	vala_list_insert (list, 0, current);
}

static void
vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaBasicBlock** idoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ValaBasicBlock** _tmp2_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	ValaBasicBlock* _tmp6_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (ValaBasicBlock*, _tmp1_ + 1);
	idoms = _tmp2_;
	idoms_length1 = _tmp1_;
	_idoms_size_ = idoms_length1;
	_tmp3_ = idoms;
	_tmp3__length1 = idoms_length1;
	_tmp4_ = vala_basic_block_get_postorder_number (entry_block);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_basic_block_ref0 (entry_block);
	_vala_basic_block_unref0 (_tmp3_[_tmp5_]);
	_tmp3_[_tmp5_] = _tmp6_;
	changed = TRUE;
	while (TRUE) {
		if (!changed) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			ValaList* _tmp7_;
			gint _block_size = 0;
			ValaList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _block_index = 0;
			_tmp7_ = _vala_iterable_ref0 (block_list);
			_block_list = _tmp7_;
			_tmp8_ = _block_list;
			_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_block_size = _tmp10_;
			_block_index = -1;
			while (TRUE) {
				ValaBasicBlock* block = NULL;
				ValaList* _tmp11_;
				gpointer _tmp12_;
				ValaBasicBlock* _tmp13_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp33_;
				gint _tmp33__length1;
				ValaBasicBlock* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				ValaBasicBlock* _tmp37_;
				ValaBasicBlock* _tmp38_;
				_block_index = _block_index + 1;
				if (!(_block_index < _block_size)) {
					break;
				}
				_tmp11_ = _block_list;
				_tmp12_ = vala_list_get (_tmp11_, _block_index);
				block = (ValaBasicBlock*) _tmp12_;
				_tmp13_ = block;
				if (_tmp13_ == entry_block) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp14_;
					ValaList* _tmp15_;
					ValaList* _tmp16_;
					gint _pred_size = 0;
					ValaList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _pred_index = 0;
					_tmp14_ = block;
					_tmp15_ = vala_basic_block_get_predecessors (_tmp14_);
					_tmp16_ = _vala_iterable_ref0 (_tmp15_);
					_pred_list = _tmp16_;
					_tmp17_ = _pred_list;
					_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					_pred_size = _tmp19_;
					_pred_index = -1;
					while (TRUE) {
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp20_;
						gpointer _tmp21_;
						ValaBasicBlock** _tmp22_;
						gint _tmp22__length1;
						ValaBasicBlock* _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						ValaBasicBlock* _tmp26_;
						_pred_index = _pred_index + 1;
						if (!(_pred_index < _pred_size)) {
							break;
						}
						_tmp20_ = _pred_list;
						_tmp21_ = vala_list_get (_tmp20_, _pred_index);
						pred = (ValaBasicBlock*) _tmp21_;
						_tmp22_ = idoms;
						_tmp22__length1 = idoms_length1;
						_tmp23_ = pred;
						_tmp24_ = vala_basic_block_get_postorder_number (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = _tmp22_[_tmp25_];
						if (_tmp26_ != NULL) {
							if (first) {
								ValaBasicBlock* _tmp27_;
								ValaBasicBlock* _tmp28_;
								_tmp27_ = pred;
								_tmp28_ = _vala_basic_block_ref0 (_tmp27_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp28_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp29_;
								gint _tmp29__length1;
								ValaBasicBlock* _tmp30_;
								ValaBasicBlock* _tmp31_;
								ValaBasicBlock* _tmp32_;
								_tmp29_ = idoms;
								_tmp29__length1 = idoms_length1;
								_tmp30_ = pred;
								_tmp31_ = new_idom;
								_tmp32_ = vala_flow_analyzer_intersect (self, _tmp29_, (gint) _tmp29__length1, _tmp30_, _tmp31_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp32_;
							}
						}
					}
					_vala_iterable_unref0 (_pred_list);
				}
				_tmp33_ = idoms;
				_tmp33__length1 = idoms_length1;
				_tmp34_ = block;
				_tmp35_ = vala_basic_block_get_postorder_number (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = _tmp33_[_tmp36_];
				_tmp38_ = new_idom;
				if (_tmp37_ != _tmp38_) {
					ValaBasicBlock** _tmp39_;
					gint _tmp39__length1;
					ValaBasicBlock* _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					ValaBasicBlock* _tmp43_;
					ValaBasicBlock* _tmp44_;
					_tmp39_ = idoms;
					_tmp39__length1 = idoms_length1;
					_tmp40_ = block;
					_tmp41_ = vala_basic_block_get_postorder_number (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = new_idom;
					_tmp44_ = _vala_basic_block_ref0 (_tmp43_);
					_vala_basic_block_unref0 (_tmp39_[_tmp42_]);
					_tmp39_[_tmp42_] = _tmp44_;
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
			_vala_iterable_unref0 (_block_list);
		}
	}
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp45_;
		gint _block_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _block_index = 0;
		_tmp45_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp45_;
		_tmp46_ = _block_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_block_size = _tmp48_;
		_block_index = -1;
		while (TRUE) {
			ValaBasicBlock* block = NULL;
			ValaList* _tmp49_;
			gpointer _tmp50_;
			ValaBasicBlock* _tmp51_;
			ValaBasicBlock** _tmp52_;
			gint _tmp52__length1;
			ValaBasicBlock* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			ValaBasicBlock* _tmp56_;
			ValaBasicBlock* _tmp57_;
			_block_index = _block_index + 1;
			if (!(_block_index < _block_size)) {
				break;
			}
			_tmp49_ = _block_list;
			_tmp50_ = vala_list_get (_tmp49_, _block_index);
			block = (ValaBasicBlock*) _tmp50_;
			_tmp51_ = block;
			if (_tmp51_ == entry_block) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp52_ = idoms;
			_tmp52__length1 = idoms_length1;
			_tmp53_ = block;
			_tmp54_ = vala_basic_block_get_postorder_number (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = _tmp52_[_tmp55_];
			_tmp57_ = block;
			vala_basic_block_add_child (_tmp56_, _tmp57_);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}

static ValaBasicBlock*
vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                              ValaBasicBlock** idoms,
                              gint idoms_length1,
                              ValaBasicBlock* b1,
                              ValaBasicBlock* b2)
{
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		if (!(b1 != b2)) {
			break;
		}
		while (TRUE) {
			gint _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			ValaBasicBlock* _tmp6_;
			_tmp0_ = vala_basic_block_get_postorder_number (b1);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_basic_block_get_postorder_number (b2);
			_tmp3_ = _tmp2_;
			if (!(_tmp1_ < _tmp3_)) {
				break;
			}
			_tmp4_ = vala_basic_block_get_postorder_number (b2);
			_tmp5_ = _tmp4_;
			_tmp6_ = idoms[_tmp5_];
			b1 = _tmp6_;
		}
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp7_ = vala_basic_block_get_postorder_number (b2);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_basic_block_get_postorder_number (b1);
			_tmp10_ = _tmp9_;
			if (!(_tmp8_ < _tmp10_)) {
				break;
			}
			_tmp11_ = vala_basic_block_get_postorder_number (b2);
			_tmp12_ = _tmp11_;
			_tmp13_ = idoms[_tmp12_];
			b2 = _tmp13_;
		}
	}
	_tmp14_ = _vala_basic_block_ref0 (b1);
	result = _tmp14_;
	return result;
}

static void
vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                             ValaList* block_list,
                                             ValaBasicBlock* entry_block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaBasicBlock* block = NULL;
				gpointer _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp4_ = vala_list_get (block_list, i);
				block = (ValaBasicBlock*) _tmp4_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp5_;
					ValaList* _tmp6_;
					ValaList* _tmp7_;
					gint _succ_size = 0;
					ValaList* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gint _succ_index = 0;
					_tmp5_ = block;
					_tmp6_ = vala_basic_block_get_successors (_tmp5_);
					_tmp7_ = _vala_iterable_ref0 (_tmp6_);
					_succ_list = _tmp7_;
					_tmp8_ = _succ_list;
					_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
					_tmp10_ = _tmp9_;
					_succ_size = _tmp10_;
					_succ_index = -1;
					while (TRUE) {
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp11_;
						gpointer _tmp12_;
						ValaBasicBlock* _tmp13_;
						ValaBasicBlock* _tmp14_;
						ValaBasicBlock* _tmp15_;
						ValaBasicBlock* _tmp16_;
						_succ_index = _succ_index + 1;
						if (!(_succ_index < _succ_size)) {
							break;
						}
						_tmp11_ = _succ_list;
						_tmp12_ = vala_list_get (_tmp11_, _succ_index);
						succ = (ValaBasicBlock*) _tmp12_;
						_tmp13_ = succ;
						_tmp14_ = vala_basic_block_get_parent (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = block;
						if (_tmp15_ != _tmp16_) {
							ValaBasicBlock* _tmp17_;
							ValaBasicBlock* _tmp18_;
							_tmp17_ = block;
							_tmp18_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp17_, _tmp18_);
						}
					}
					_vala_iterable_unref0 (_succ_list);
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp19_;
					ValaList* _tmp20_;
					ValaList* _tmp21_;
					gint _child_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _child_index = 0;
					_tmp19_ = block;
					_tmp20_ = vala_basic_block_get_children (_tmp19_);
					_tmp21_ = _vala_iterable_ref0 (_tmp20_);
					_child_list = _tmp21_;
					_tmp22_ = _child_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_child_size = _tmp24_;
					_child_index = -1;
					while (TRUE) {
						ValaBasicBlock* child = NULL;
						ValaList* _tmp25_;
						gpointer _tmp26_;
						_child_index = _child_index + 1;
						if (!(_child_index < _child_size)) {
							break;
						}
						_tmp25_ = _child_list;
						_tmp26_ = vala_list_get (_tmp25_, _child_index);
						child = (ValaBasicBlock*) _tmp26_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp27_;
							ValaSet* _tmp28_;
							ValaIterator* _tmp29_;
							_tmp27_ = child;
							_tmp28_ = vala_basic_block_get_dominator_frontier (_tmp27_);
							_tmp29_ = vala_iterable_iterator ((ValaIterable*) _tmp28_);
							_child_frontier_it = _tmp29_;
							while (TRUE) {
								ValaIterator* _tmp30_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp31_;
								gpointer _tmp32_;
								ValaBasicBlock* _tmp33_;
								ValaBasicBlock* _tmp34_;
								ValaBasicBlock* _tmp35_;
								ValaBasicBlock* _tmp36_;
								_tmp30_ = _child_frontier_it;
								if (!vala_iterator_next (_tmp30_)) {
									break;
								}
								_tmp31_ = _child_frontier_it;
								_tmp32_ = vala_iterator_get (_tmp31_);
								child_frontier = (ValaBasicBlock*) _tmp32_;
								_tmp33_ = child_frontier;
								_tmp34_ = vala_basic_block_get_parent (_tmp33_);
								_tmp35_ = _tmp34_;
								_tmp36_ = block;
								if (_tmp35_ != _tmp36_) {
									ValaBasicBlock* _tmp37_;
									ValaBasicBlock* _tmp38_;
									_tmp37_ = block;
									_tmp38_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp37_, _tmp38_);
								}
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
					}
					_vala_iterable_unref0 (_child_list);
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}

static ValaMap*
vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                       ValaList* block_list,
                                       ValaBasicBlock* entry_block)
{
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp4_;
		gint _block_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _block_index = 0;
		_tmp4_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp4_;
		_tmp5_ = _block_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_block_size = _tmp7_;
		_block_index = -1;
		while (TRUE) {
			ValaBasicBlock* block = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp10_;
			ValaArrayList* _tmp11_;
			_block_index = _block_index + 1;
			if (!(_block_index < _block_size)) {
				break;
			}
			_tmp8_ = _block_list;
			_tmp9_ = vala_list_get (_tmp8_, _block_index);
			block = (ValaBasicBlock*) _tmp9_;
			_tmp10_ = g_direct_equal;
			_tmp11_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
			defined_variables = _tmp11_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp12_;
				ValaList* _tmp13_;
				ValaList* _tmp14_;
				gint _node_size = 0;
				ValaList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _node_index = 0;
				_tmp12_ = block;
				_tmp13_ = vala_basic_block_get_nodes (_tmp12_);
				_tmp14_ = _vala_iterable_ref0 (_tmp13_);
				_node_list = _tmp14_;
				_tmp15_ = _node_list;
				_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				_node_size = _tmp17_;
				_node_index = -1;
				while (TRUE) {
					ValaCodeNode* node = NULL;
					ValaList* _tmp18_;
					gpointer _tmp19_;
					ValaCodeNode* _tmp20_;
					ValaArrayList* _tmp21_;
					_node_index = _node_index + 1;
					if (!(_node_index < _node_size)) {
						break;
					}
					_tmp18_ = _node_list;
					_tmp19_ = vala_list_get (_tmp18_, _node_index);
					node = (ValaCodeNode*) _tmp19_;
					_tmp20_ = node;
					_tmp21_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp20_, (ValaCollection*) _tmp21_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp22_;
				ValaArrayList* _tmp23_;
				gint _variable_size = 0;
				ValaArrayList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _variable_index = 0;
				_tmp22_ = defined_variables;
				_tmp23_ = _vala_iterable_ref0 (_tmp22_);
				_variable_list = _tmp23_;
				_tmp24_ = _variable_list;
				_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				_variable_size = _tmp26_;
				_variable_index = -1;
				while (TRUE) {
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp27_;
					gpointer _tmp28_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp29_;
					ValaVariable* _tmp30_;
					gpointer _tmp31_;
					ValaSet* _tmp32_;
					ValaSet* _tmp39_;
					ValaBasicBlock* _tmp40_;
					_variable_index = _variable_index + 1;
					if (!(_variable_index < _variable_size)) {
						break;
					}
					_tmp27_ = _variable_list;
					_tmp28_ = vala_list_get ((ValaList*) _tmp27_, _variable_index);
					variable = (ValaVariable*) _tmp28_;
					_tmp29_ = map;
					_tmp30_ = variable;
					_tmp31_ = vala_map_get ((ValaMap*) _tmp29_, _tmp30_);
					block_set = (ValaSet*) _tmp31_;
					_tmp32_ = block_set;
					if (_tmp32_ == NULL) {
						GHashFunc _tmp33_;
						GEqualFunc _tmp34_;
						ValaHashSet* _tmp35_;
						ValaHashMap* _tmp36_;
						ValaVariable* _tmp37_;
						ValaSet* _tmp38_;
						_tmp33_ = g_direct_hash;
						_tmp34_ = g_direct_equal;
						_tmp35_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp33_, _tmp34_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp35_;
						_tmp36_ = map;
						_tmp37_ = variable;
						_tmp38_ = block_set;
						vala_map_set ((ValaMap*) _tmp36_, _tmp37_, _tmp38_);
					}
					_tmp39_ = block_set;
					_tmp40_ = block;
					vala_collection_add ((ValaCollection*) _tmp39_, _tmp40_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	result = (ValaMap*) map;
	return result;
}

static void
vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaMap* assign = NULL;
	ValaMap* _tmp0_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_assignment_map (self, block_list, entry_block);
	assign = _tmp0_;
	counter = 0;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_);
	work_list = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp3_, _tmp4_, _tmp5_);
	added = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp7_, _tmp8_, _tmp9_);
	phi = _tmp10_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp11_;
		gint _block_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _block_index = 0;
		_tmp11_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp11_;
		_tmp12_ = _block_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_block_size = _tmp14_;
		_block_index = -1;
		while (TRUE) {
			ValaBasicBlock* block = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaHashMap* _tmp17_;
			ValaBasicBlock* _tmp18_;
			ValaHashMap* _tmp19_;
			ValaBasicBlock* _tmp20_;
			_block_index = _block_index + 1;
			if (!(_block_index < _block_size)) {
				break;
			}
			_tmp15_ = _block_list;
			_tmp16_ = vala_list_get (_tmp15_, _block_index);
			block = (ValaBasicBlock*) _tmp16_;
			_tmp17_ = added;
			_tmp18_ = block;
			vala_map_set ((ValaMap*) _tmp17_, _tmp18_, (gpointer) ((gintptr) 0));
			_tmp19_ = phi;
			_tmp20_ = block;
			vala_map_set ((ValaMap*) _tmp19_, _tmp20_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp21_;
		ValaSet* _tmp22_;
		ValaSet* _tmp23_;
		ValaIterator* _tmp24_;
		ValaIterator* _tmp25_;
		_tmp21_ = assign;
		_tmp22_ = vala_map_get_keys (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_iterable_iterator ((ValaIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_vala_iterable_unref0 (_tmp23_);
		_variable_it = _tmp25_;
		while (TRUE) {
			ValaIterator* _tmp26_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp27_;
			gpointer _tmp28_;
			gint _tmp29_;
			_tmp26_ = _variable_it;
			if (!vala_iterator_next (_tmp26_)) {
				break;
			}
			_tmp27_ = _variable_it;
			_tmp28_ = vala_iterator_get (_tmp27_);
			variable = (ValaVariable*) _tmp28_;
			_tmp29_ = counter;
			counter = _tmp29_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp30_;
				ValaVariable* _tmp31_;
				gpointer _tmp32_;
				ValaSet* _tmp33_;
				ValaIterator* _tmp34_;
				ValaIterator* _tmp35_;
				_tmp30_ = assign;
				_tmp31_ = variable;
				_tmp32_ = vala_map_get (_tmp30_, _tmp31_);
				_tmp33_ = (ValaSet*) _tmp32_;
				_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
				_tmp35_ = _tmp34_;
				_vala_iterable_unref0 (_tmp33_);
				_block_it = _tmp35_;
				while (TRUE) {
					ValaIterator* _tmp36_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp37_;
					gpointer _tmp38_;
					ValaArrayList* _tmp39_;
					ValaBasicBlock* _tmp40_;
					ValaHashMap* _tmp41_;
					ValaBasicBlock* _tmp42_;
					_tmp36_ = _block_it;
					if (!vala_iterator_next (_tmp36_)) {
						break;
					}
					_tmp37_ = _block_it;
					_tmp38_ = vala_iterator_get (_tmp37_);
					block = (ValaBasicBlock*) _tmp38_;
					_tmp39_ = work_list;
					_tmp40_ = block;
					vala_collection_add ((ValaCollection*) _tmp39_, _tmp40_);
					_tmp41_ = added;
					_tmp42_ = block;
					vala_map_set ((ValaMap*) _tmp41_, _tmp42_, (gpointer) ((gintptr) counter));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp46_;
				gpointer _tmp47_;
				_tmp43_ = work_list;
				_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				if (!(_tmp45_ > 0)) {
					break;
				}
				_tmp46_ = work_list;
				_tmp47_ = vala_list_remove_at ((ValaList*) _tmp46_, 0);
				block = (ValaBasicBlock*) _tmp47_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp48_;
					ValaSet* _tmp49_;
					ValaIterator* _tmp50_;
					_tmp48_ = block;
					_tmp49_ = vala_basic_block_get_dominator_frontier (_tmp48_);
					_tmp50_ = vala_iterable_iterator ((ValaIterable*) _tmp49_);
					_frontier_it = _tmp50_;
					while (TRUE) {
						ValaIterator* _tmp51_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp52_;
						gpointer _tmp53_;
						ValaBasicBlock* _tmp54_;
						gint blockPhi = 0;
						ValaHashMap* _tmp55_;
						ValaBasicBlock* _tmp56_;
						gpointer _tmp57_;
						_tmp51_ = _frontier_it;
						if (!vala_iterator_next (_tmp51_)) {
							break;
						}
						_tmp52_ = _frontier_it;
						_tmp53_ = vala_iterator_get (_tmp52_);
						_tmp54_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp53_);
						frontier = _tmp54_;
						_tmp55_ = phi;
						_tmp56_ = frontier;
						_tmp57_ = vala_map_get ((ValaMap*) _tmp55_, _tmp56_);
						blockPhi = (gint) ((gintptr) _tmp57_);
						if (blockPhi < counter) {
							ValaBasicBlock* _tmp58_;
							ValaVariable* _tmp59_;
							ValaBasicBlock* _tmp60_;
							ValaList* _tmp61_;
							gint _tmp62_;
							gint _tmp63_;
							ValaPhiFunction* _tmp64_;
							ValaPhiFunction* _tmp65_;
							ValaHashMap* _tmp66_;
							ValaBasicBlock* _tmp67_;
							gint block_added = 0;
							ValaHashMap* _tmp68_;
							ValaBasicBlock* _tmp69_;
							gpointer _tmp70_;
							_tmp58_ = frontier;
							_tmp59_ = variable;
							_tmp60_ = frontier;
							_tmp61_ = vala_basic_block_get_predecessors (_tmp60_);
							_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = vala_phi_function_new (_tmp59_, _tmp63_);
							_tmp65_ = _tmp64_;
							vala_basic_block_add_phi_function (_tmp58_, _tmp65_);
							_vala_phi_function_unref0 (_tmp65_);
							_tmp66_ = phi;
							_tmp67_ = frontier;
							vala_map_set ((ValaMap*) _tmp66_, _tmp67_, (gpointer) ((gintptr) counter));
							_tmp68_ = added;
							_tmp69_ = frontier;
							_tmp70_ = vala_map_get ((ValaMap*) _tmp68_, _tmp69_);
							block_added = (gint) ((gintptr) _tmp70_);
							if (block_added < counter) {
								ValaHashMap* _tmp71_;
								ValaBasicBlock* _tmp72_;
								ValaArrayList* _tmp73_;
								ValaBasicBlock* _tmp74_;
								_tmp71_ = added;
								_tmp72_ = frontier;
								vala_map_set ((ValaMap*) _tmp71_, _tmp72_, (gpointer) ((gintptr) counter));
								_tmp73_ = work_list;
								_tmp74_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp73_, _tmp74_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}

static void
vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                    ValaBasicBlock* entry_block)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp11_;
	ValaArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	vala_flow_analyzer_check_block_variables (self, entry_block);
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
	used_vars_queue = _tmp12_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp13_ = self->priv->used_vars;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_variable_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValaVariable* _tmp19_;
			_tmp15_ = _variable_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			variable = (ValaVariable*) _tmp17_;
			_tmp18_ = used_vars_queue;
			_tmp19_ = variable;
			vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp23_;
		gpointer _tmp24_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp25_;
		ValaVariable* _tmp26_;
		gpointer _tmp27_;
		ValaPhiFunction* _tmp28_;
		_tmp20_ = used_vars_queue;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		if (!(_tmp22_ > 0)) {
			break;
		}
		_tmp23_ = used_vars_queue;
		_tmp24_ = vala_list_remove_at ((ValaList*) _tmp23_, 0);
		used_var = (ValaVariable*) _tmp24_;
		_tmp25_ = self->priv->phi_functions;
		_tmp26_ = used_var;
		_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
		phi = (ValaPhiFunction*) _tmp27_;
		_tmp28_ = phi;
		if (_tmp28_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp29_;
				ValaList* _tmp30_;
				ValaList* _tmp31_;
				ValaList* _tmp32_;
				gint _variable_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _variable_index = 0;
				_tmp29_ = phi;
				_tmp30_ = vala_phi_function_get_operands (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _vala_iterable_ref0 (_tmp31_);
				_variable_list = _tmp32_;
				_tmp33_ = _variable_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_variable_size = _tmp35_;
				_variable_index = -1;
				while (TRUE) {
					ValaVariable* variable = NULL;
					ValaList* _tmp36_;
					gpointer _tmp37_;
					ValaVariable* _tmp38_;
					ValaSet* _tmp56_;
					ValaVariable* _tmp57_;
					_variable_index = _variable_index + 1;
					if (!(_variable_index < _variable_size)) {
						break;
					}
					_tmp36_ = _variable_list;
					_tmp37_ = vala_list_get (_tmp36_, _variable_index);
					variable = (ValaVariable*) _tmp37_;
					_tmp38_ = variable;
					if (_tmp38_ == NULL) {
						ValaVariable* _tmp39_;
						_tmp39_ = used_var;
						if (VALA_IS_LOCAL_VARIABLE (_tmp39_)) {
							ValaVariable* _tmp40_;
							ValaSourceReference* _tmp41_;
							ValaSourceReference* _tmp42_;
							ValaVariable* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp40_ = used_var;
							_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = used_var;
							_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp45_);
							_tmp47_ = _tmp46_;
							vala_report_error (_tmp42_, _tmp47_);
							_g_free0 (_tmp47_);
						} else {
							ValaVariable* _tmp48_;
							ValaSourceReference* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaVariable* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp48_ = used_var;
							_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = used_var;
							_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp53_);
							_tmp55_ = _tmp54_;
							vala_report_warning (_tmp50_, _tmp55_);
							_g_free0 (_tmp55_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp56_ = self->priv->used_vars;
					_tmp57_ = variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp56_, _tmp57_)) {
						ValaVariable* _tmp58_;
						ValaVariable* _tmp59_;
						ValaSourceReference* _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSet* _tmp62_;
						ValaVariable* _tmp63_;
						ValaArrayList* _tmp64_;
						ValaVariable* _tmp65_;
						_tmp58_ = variable;
						_tmp59_ = used_var;
						_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
						_tmp61_ = _tmp60_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp58_, _tmp61_);
						_tmp62_ = self->priv->used_vars;
						_tmp63_ = variable;
						vala_collection_add ((ValaCollection*) _tmp62_, _tmp63_);
						_tmp64_ = used_vars_queue;
						_tmp65_ = variable;
						vala_collection_add ((ValaCollection*) _tmp64_, _tmp65_);
					}
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = NULL;
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = NULL;
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = NULL;
	_vala_iterable_unref0 (used_vars_queue);
}

static void
vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                          ValaBasicBlock* block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp0_;
		ValaIterator* _tmp1_;
		_tmp0_ = vala_basic_block_get_phi_functions (block);
		_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
		_phi_it = _tmp1_;
		while (TRUE) {
			ValaIterator* _tmp2_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp3_;
			gpointer _tmp4_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp5_;
			ValaPhiFunction* _tmp6_;
			ValaVariable* _tmp7_;
			ValaVariable* _tmp8_;
			ValaVariable* _tmp9_;
			ValaMap* _tmp10_;
			ValaVariable* _tmp11_;
			ValaPhiFunction* _tmp12_;
			_tmp2_ = _phi_it;
			if (!vala_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _phi_it;
			_tmp4_ = vala_iterator_get (_tmp3_);
			phi = (ValaPhiFunction*) _tmp4_;
			_tmp5_ = self->priv->var_map;
			_tmp6_ = phi;
			_tmp7_ = vala_phi_function_get_original_variable (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_flow_analyzer_process_assignment (self, _tmp5_, _tmp8_);
			versioned_var = _tmp9_;
			_tmp10_ = self->priv->phi_functions;
			_tmp11_ = versioned_var;
			_tmp12_ = phi;
			vala_map_set (_tmp10_, _tmp11_, _tmp12_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _node_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _node_index = 0;
		_tmp13_ = vala_basic_block_get_nodes (block);
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_node_list = _tmp14_;
		_tmp15_ = _node_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_node_size = _tmp17_;
		_node_index = -1;
		while (TRUE) {
			ValaCodeNode* node = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp20_;
			ValaArrayList* _tmp21_;
			ValaCodeNode* _tmp22_;
			ValaArrayList* _tmp23_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp69_;
			ValaArrayList* _tmp70_;
			ValaCodeNode* _tmp71_;
			ValaArrayList* _tmp72_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp18_ = _node_list;
			_tmp19_ = vala_list_get (_tmp18_, _node_index);
			node = (ValaCodeNode*) _tmp19_;
			_tmp20_ = g_direct_equal;
			_tmp21_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
			used_variables = _tmp21_;
			_tmp22_ = node;
			_tmp23_ = used_variables;
			vala_code_node_get_used_variables (_tmp22_, (ValaCollection*) _tmp23_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp24_;
				ValaArrayList* _tmp25_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _var_symbol_index = 0;
				_tmp24_ = used_variables;
				_tmp25_ = _vala_iterable_ref0 (_tmp24_);
				_var_symbol_list = _tmp25_;
				_tmp26_ = _var_symbol_list;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_var_symbol_size = _tmp28_;
				_var_symbol_index = -1;
				while (TRUE) {
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp29_;
					gpointer _tmp30_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp31_;
					ValaVariable* _tmp32_;
					gpointer _tmp33_;
					gboolean _tmp34_ = FALSE;
					ValaList* _tmp35_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp56_;
					ValaList* _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					gpointer _tmp60_;
					ValaSet* _tmp61_;
					ValaVariable* _tmp62_;
					ValaSet* _tmp67_;
					ValaVariable* _tmp68_;
					_var_symbol_index = _var_symbol_index + 1;
					if (!(_var_symbol_index < _var_symbol_size)) {
						break;
					}
					_tmp29_ = _var_symbol_list;
					_tmp30_ = vala_list_get ((ValaList*) _tmp29_, _var_symbol_index);
					var_symbol = (ValaVariable*) _tmp30_;
					_tmp31_ = self->priv->var_map;
					_tmp32_ = var_symbol;
					_tmp33_ = vala_map_get (_tmp31_, (ValaSymbol*) _tmp32_);
					variable_stack = (ValaList*) _tmp33_;
					_tmp35_ = variable_stack;
					if (_tmp35_ == NULL) {
						_tmp34_ = TRUE;
					} else {
						ValaList* _tmp36_;
						gint _tmp37_;
						gint _tmp38_;
						_tmp36_ = variable_stack;
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp34_ = _tmp38_ == 0;
					}
					if (_tmp34_) {
						ValaVariable* _tmp39_;
						_tmp39_ = var_symbol;
						if (VALA_IS_LOCAL_VARIABLE (_tmp39_)) {
							ValaCodeNode* _tmp40_;
							ValaSourceReference* _tmp41_;
							ValaSourceReference* _tmp42_;
							ValaVariable* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp40_ = node;
							_tmp41_ = vala_code_node_get_source_reference (_tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = var_symbol;
							_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp45_);
							_tmp47_ = _tmp46_;
							vala_report_error (_tmp42_, _tmp47_);
							_g_free0 (_tmp47_);
						} else {
							ValaCodeNode* _tmp48_;
							ValaSourceReference* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaVariable* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							_tmp48_ = node;
							_tmp49_ = vala_code_node_get_source_reference (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = var_symbol;
							_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp53_);
							_tmp55_ = _tmp54_;
							vala_report_warning (_tmp50_, _tmp55_);
							_g_free0 (_tmp55_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp56_ = variable_stack;
					_tmp57_ = variable_stack;
					_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = vala_list_get (_tmp56_, _tmp59_ - 1);
					versioned_variable = (ValaVariable*) _tmp60_;
					_tmp61_ = self->priv->used_vars;
					_tmp62_ = versioned_variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp61_, _tmp62_)) {
						ValaVariable* _tmp63_;
						ValaCodeNode* _tmp64_;
						ValaSourceReference* _tmp65_;
						ValaSourceReference* _tmp66_;
						_tmp63_ = versioned_variable;
						_tmp64_ = node;
						_tmp65_ = vala_code_node_get_source_reference (_tmp64_);
						_tmp66_ = _tmp65_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp63_, _tmp66_);
					}
					_tmp67_ = self->priv->used_vars;
					_tmp68_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp67_, _tmp68_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
				_vala_iterable_unref0 (_var_symbol_list);
			}
			_tmp69_ = g_direct_equal;
			_tmp70_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp69_);
			defined_variables = _tmp70_;
			_tmp71_ = node;
			_tmp72_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp71_, (ValaCollection*) _tmp72_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp73_;
				ValaArrayList* _tmp74_;
				gint _variable_size = 0;
				ValaArrayList* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _variable_index = 0;
				_tmp73_ = defined_variables;
				_tmp74_ = _vala_iterable_ref0 (_tmp73_);
				_variable_list = _tmp74_;
				_tmp75_ = _variable_list;
				_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
				_tmp77_ = _tmp76_;
				_variable_size = _tmp77_;
				_variable_index = -1;
				while (TRUE) {
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp78_;
					gpointer _tmp79_;
					ValaMap* _tmp80_;
					ValaVariable* _tmp81_;
					ValaVariable* _tmp82_;
					ValaVariable* _tmp83_;
					_variable_index = _variable_index + 1;
					if (!(_variable_index < _variable_size)) {
						break;
					}
					_tmp78_ = _variable_list;
					_tmp79_ = vala_list_get ((ValaList*) _tmp78_, _variable_index);
					variable = (ValaVariable*) _tmp79_;
					_tmp80_ = self->priv->var_map;
					_tmp81_ = variable;
					_tmp82_ = vala_flow_analyzer_process_assignment (self, _tmp80_, _tmp81_);
					_tmp83_ = _tmp82_;
					_vala_code_node_unref0 (_tmp83_);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp84_;
		ValaList* _tmp85_;
		gint _succ_size = 0;
		ValaList* _tmp86_;
		gint _tmp87_;
		gint _tmp88_;
		gint _succ_index = 0;
		_tmp84_ = vala_basic_block_get_successors (block);
		_tmp85_ = _vala_iterable_ref0 (_tmp84_);
		_succ_list = _tmp85_;
		_tmp86_ = _succ_list;
		_tmp87_ = vala_collection_get_size ((ValaCollection*) _tmp86_);
		_tmp88_ = _tmp87_;
		_succ_size = _tmp88_;
		_succ_index = -1;
		while (TRUE) {
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp89_;
			gpointer _tmp90_;
			gint j = 0;
			_succ_index = _succ_index + 1;
			if (!(_succ_index < _succ_size)) {
				break;
			}
			_tmp89_ = _succ_list;
			_tmp90_ = vala_list_get (_tmp89_, _succ_index);
			succ = (ValaBasicBlock*) _tmp90_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp91_;
				ValaList* _tmp92_;
				ValaList* _tmp93_;
				gint _pred_size = 0;
				ValaList* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				gint _pred_index = 0;
				_tmp91_ = succ;
				_tmp92_ = vala_basic_block_get_predecessors (_tmp91_);
				_tmp93_ = _vala_iterable_ref0 (_tmp92_);
				_pred_list = _tmp93_;
				_tmp94_ = _pred_list;
				_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
				_tmp96_ = _tmp95_;
				_pred_size = _tmp96_;
				_pred_index = -1;
				while (TRUE) {
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp97_;
					gpointer _tmp98_;
					ValaBasicBlock* _tmp99_;
					gint _tmp100_;
					_pred_index = _pred_index + 1;
					if (!(_pred_index < _pred_size)) {
						break;
					}
					_tmp97_ = _pred_list;
					_tmp98_ = vala_list_get (_tmp97_, _pred_index);
					pred = (ValaBasicBlock*) _tmp98_;
					_tmp99_ = pred;
					if (_tmp99_ == block) {
						break;
					}
					_tmp100_ = j;
					j = _tmp100_ + 1;
				}
				_vala_iterable_unref0 (_pred_list);
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp101_;
				ValaSet* _tmp102_;
				ValaIterator* _tmp103_;
				_tmp101_ = succ;
				_tmp102_ = vala_basic_block_get_phi_functions (_tmp101_);
				_tmp103_ = vala_iterable_iterator ((ValaIterable*) _tmp102_);
				_phi_it = _tmp103_;
				while (TRUE) {
					ValaIterator* _tmp104_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp105_;
					gpointer _tmp106_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp107_;
					ValaPhiFunction* _tmp108_;
					ValaVariable* _tmp109_;
					ValaVariable* _tmp110_;
					gpointer _tmp111_;
					gboolean _tmp112_ = FALSE;
					ValaList* _tmp113_;
					_tmp104_ = _phi_it;
					if (!vala_iterator_next (_tmp104_)) {
						break;
					}
					_tmp105_ = _phi_it;
					_tmp106_ = vala_iterator_get (_tmp105_);
					phi = (ValaPhiFunction*) _tmp106_;
					_tmp107_ = self->priv->var_map;
					_tmp108_ = phi;
					_tmp109_ = vala_phi_function_get_original_variable (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp111_ = vala_map_get (_tmp107_, (ValaSymbol*) _tmp110_);
					variable_stack = (ValaList*) _tmp111_;
					_tmp113_ = variable_stack;
					if (_tmp113_ != NULL) {
						ValaList* _tmp114_;
						gint _tmp115_;
						gint _tmp116_;
						_tmp114_ = variable_stack;
						_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
						_tmp116_ = _tmp115_;
						_tmp112_ = _tmp116_ > 0;
					} else {
						_tmp112_ = FALSE;
					}
					if (_tmp112_) {
						ValaPhiFunction* _tmp117_;
						ValaList* _tmp118_;
						ValaList* _tmp119_;
						ValaList* _tmp120_;
						ValaList* _tmp121_;
						gint _tmp122_;
						gint _tmp123_;
						gpointer _tmp124_;
						ValaVariable* _tmp125_;
						_tmp117_ = phi;
						_tmp118_ = vala_phi_function_get_operands (_tmp117_);
						_tmp119_ = _tmp118_;
						_tmp120_ = variable_stack;
						_tmp121_ = variable_stack;
						_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_list_get (_tmp120_, _tmp123_ - 1);
						_tmp125_ = (ValaVariable*) _tmp124_;
						vala_list_set (_tmp119_, j, _tmp125_);
						_vala_code_node_unref0 (_tmp125_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
		}
		_vala_iterable_unref0 (_succ_list);
	}
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp126_;
		ValaList* _tmp127_;
		gint _child_size = 0;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gint _child_index = 0;
		_tmp126_ = vala_basic_block_get_children (block);
		_tmp127_ = _vala_iterable_ref0 (_tmp126_);
		_child_list = _tmp127_;
		_tmp128_ = _child_list;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_child_size = _tmp130_;
		_child_index = -1;
		while (TRUE) {
			ValaBasicBlock* child = NULL;
			ValaList* _tmp131_;
			gpointer _tmp132_;
			ValaBasicBlock* _tmp133_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp131_ = _child_list;
			_tmp132_ = vala_list_get (_tmp131_, _child_index);
			child = (ValaBasicBlock*) _tmp132_;
			_tmp133_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp133_);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp134_;
		ValaIterator* _tmp135_;
		_tmp134_ = vala_basic_block_get_phi_functions (block);
		_tmp135_ = vala_iterable_iterator ((ValaIterable*) _tmp134_);
		_phi_it = _tmp135_;
		while (TRUE) {
			ValaIterator* _tmp136_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp137_;
			gpointer _tmp138_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp139_;
			ValaPhiFunction* _tmp140_;
			ValaVariable* _tmp141_;
			ValaVariable* _tmp142_;
			gpointer _tmp143_;
			ValaList* _tmp144_;
			ValaList* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			gpointer _tmp148_;
			ValaVariable* _tmp149_;
			_tmp136_ = _phi_it;
			if (!vala_iterator_next (_tmp136_)) {
				break;
			}
			_tmp137_ = _phi_it;
			_tmp138_ = vala_iterator_get (_tmp137_);
			phi = (ValaPhiFunction*) _tmp138_;
			_tmp139_ = self->priv->var_map;
			_tmp140_ = phi;
			_tmp141_ = vala_phi_function_get_original_variable (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_map_get (_tmp139_, (ValaSymbol*) _tmp142_);
			variable_stack = (ValaList*) _tmp143_;
			_tmp144_ = variable_stack;
			_tmp145_ = variable_stack;
			_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_list_remove_at (_tmp144_, _tmp147_ - 1);
			_tmp149_ = (ValaVariable*) _tmp148_;
			_vala_code_node_unref0 (_tmp149_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp150_;
		ValaList* _tmp151_;
		gint _node_size = 0;
		ValaList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		gint _node_index = 0;
		_tmp150_ = vala_basic_block_get_nodes (block);
		_tmp151_ = _vala_iterable_ref0 (_tmp150_);
		_node_list = _tmp151_;
		_tmp152_ = _node_list;
		_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		_node_size = _tmp154_;
		_node_index = -1;
		while (TRUE) {
			ValaCodeNode* node = NULL;
			ValaList* _tmp155_;
			gpointer _tmp156_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp157_;
			ValaArrayList* _tmp158_;
			ValaCodeNode* _tmp159_;
			ValaArrayList* _tmp160_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp155_ = _node_list;
			_tmp156_ = vala_list_get (_tmp155_, _node_index);
			node = (ValaCodeNode*) _tmp156_;
			_tmp157_ = g_direct_equal;
			_tmp158_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp157_);
			defined_variables = _tmp158_;
			_tmp159_ = node;
			_tmp160_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp159_, (ValaCollection*) _tmp160_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp161_;
				ValaArrayList* _tmp162_;
				gint _variable_size = 0;
				ValaArrayList* _tmp163_;
				gint _tmp164_;
				gint _tmp165_;
				gint _variable_index = 0;
				_tmp161_ = defined_variables;
				_tmp162_ = _vala_iterable_ref0 (_tmp161_);
				_variable_list = _tmp162_;
				_tmp163_ = _variable_list;
				_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
				_tmp165_ = _tmp164_;
				_variable_size = _tmp165_;
				_variable_index = -1;
				while (TRUE) {
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp166_;
					gpointer _tmp167_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp168_;
					ValaVariable* _tmp169_;
					gpointer _tmp170_;
					ValaList* _tmp171_;
					ValaList* _tmp172_;
					gint _tmp173_;
					gint _tmp174_;
					gpointer _tmp175_;
					ValaVariable* _tmp176_;
					_variable_index = _variable_index + 1;
					if (!(_variable_index < _variable_size)) {
						break;
					}
					_tmp166_ = _variable_list;
					_tmp167_ = vala_list_get ((ValaList*) _tmp166_, _variable_index);
					variable = (ValaVariable*) _tmp167_;
					_tmp168_ = self->priv->var_map;
					_tmp169_ = variable;
					_tmp170_ = vala_map_get (_tmp168_, (ValaSymbol*) _tmp169_);
					variable_stack = (ValaList*) _tmp170_;
					_tmp171_ = variable_stack;
					_tmp172_ = variable_stack;
					_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
					_tmp174_ = _tmp173_;
					_tmp175_ = vala_list_remove_at (_tmp171_, _tmp174_ - 1);
					_tmp176_ = (ValaVariable*) _tmp175_;
					_vala_code_node_unref0 (_tmp176_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static ValaVariable*
vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                       ValaMap* var_map,
                                       ValaVariable* var_symbol)
{
	ValaList* variable_stack = NULL;
	gpointer _tmp0_;
	ValaList* _tmp1_;
	ValaVariable* versioned_var = NULL;
	ValaList* _tmp23_;
	ValaVariable* _tmp24_;
	ValaVariable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = vala_map_get (var_map, (ValaSymbol*) var_symbol);
	variable_stack = (ValaList*) _tmp0_;
	_tmp1_ = variable_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp3_;
		_tmp4_ = variable_stack;
		vala_map_set (var_map, (ValaSymbol*) var_symbol, _tmp4_);
		vala_variable_set_single_assignment (var_symbol, TRUE);
	} else {
		vala_variable_set_single_assignment (var_symbol, FALSE);
	}
	if (VALA_IS_LOCAL_VARIABLE (var_symbol)) {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaLocalVariable* _tmp13_;
		_tmp5_ = vala_variable_get_variable_type (var_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_local_variable_new (_tmp8_, _tmp10_, NULL, _tmp12_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp13_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type (var_symbol);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new (_tmp15_, _tmp19_, _tmp21_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp22_;
		_vala_code_node_unref0 (_tmp19_);
	}
	_tmp23_ = variable_stack;
	_tmp24_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}

static void
vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                               ValaCreationMethod* m)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}

static void
vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                        ValaProperty* prop)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                 ValaPropertyAccessor* acc)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) acc);
}

static void
vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                     ValaBlock* b)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                     ValaDeclarationStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaBasicBlock* _tmp16_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	gboolean _tmp19_ = FALSE;
	ValaLocalVariable* _tmp20_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_declaration_statement_get_declaration (stmt);
		_tmp1_ = _tmp0_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp1_, TRUE);
		return;
	}
	_tmp2_ = vala_declaration_statement_get_declaration (stmt);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_used (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = vala_declaration_statement_get_declaration (stmt);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_declaration_statement_get_declaration (stmt);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("local variable `%s' declared but never used", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_warning (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp16_, (ValaCodeNode*) stmt);
	_tmp17_ = vala_declaration_statement_get_declaration (stmt);
	_tmp18_ = _tmp17_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp18_) ? ((ValaLocalVariable*) _tmp18_) : NULL;
	_tmp20_ = local;
	if (_tmp20_ != NULL) {
		ValaLocalVariable* _tmp21_;
		ValaExpression* _tmp22_;
		ValaExpression* _tmp23_;
		_tmp21_ = local;
		_tmp22_ = vala_variable_get_initializer ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaLocalVariable* _tmp24_;
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp24_ = local;
		_tmp25_ = vala_variable_get_initializer ((ValaVariable*) _tmp24_);
		_tmp26_ = _tmp25_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp26_, FALSE);
	}
}

static void
vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                              ValaLocalVariable* local)
{
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
}

static void
vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                    ValaExpressionStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, FALSE);
	_tmp1_ = vala_expression_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	if (VALA_IS_METHOD_CALL (_tmp2_)) {
		ValaMethodCall* expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaMemberAccess* _tmp10_;
		_tmp3_ = vala_expression_statement_get_expression (stmt);
		_tmp4_ = _tmp3_;
		expr = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
		_tmp5_ = expr;
		_tmp6_ = vala_method_call_get_call (_tmp5_);
		_tmp7_ = _tmp6_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp7_) ? ((ValaMemberAccess*) _tmp7_) : NULL;
		_tmp10_ = ma;
		if (_tmp10_ != NULL) {
			ValaMemberAccess* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp11_ = ma;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaMemberAccess* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaAttribute* _tmp17_;
			_tmp14_ = ma;
			_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp16_, "NoReturn");
			_tmp8_ = _tmp17_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			vala_flow_analyzer_mark_unreachable (self);
			return;
		}
	}
}

static gboolean
vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                ValaExpression* condition)
{
	ValaBooleanLiteral* literal = NULL;
	gboolean _tmp0_ = FALSE;
	ValaBooleanLiteral* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	literal = VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL;
	_tmp1_ = literal;
	if (_tmp1_ != NULL) {
		ValaBooleanLiteral* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = literal;
		_tmp3_ = vala_boolean_literal_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                 ValaExpression* condition)
{
	ValaBooleanLiteral* literal = NULL;
	gboolean _tmp0_ = FALSE;
	ValaBooleanLiteral* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	literal = VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL;
	_tmp1_ = literal;
	if (_tmp1_ != NULL) {
		ValaBooleanLiteral* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = literal;
		_tmp3_ = vala_boolean_literal_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                            ValaIfStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp14_;
	ValaBlock* _tmp15_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp29_;
	ValaBasicBlock* _tmp30_;
	gboolean _tmp31_ = FALSE;
	ValaBasicBlock* _tmp32_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_if_statement_get_condition (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_if_statement_get_condition (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = _vala_basic_block_ref0 (_tmp5_);
	last_block = _tmp6_;
	_tmp7_ = vala_if_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	if (vala_flow_analyzer_always_false (self, _tmp8_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp9_;
		ValaSet* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* _tmp12_;
		ValaBasicBlock* _tmp13_;
		_tmp9_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp9_;
		_tmp10_ = self->priv->all_basic_blocks;
		_tmp11_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
		_tmp12_ = last_block;
		_tmp13_ = self->priv->current_block;
		vala_basic_block_connect (_tmp12_, _tmp13_);
	}
	_tmp14_ = vala_if_statement_get_true_statement (stmt);
	_tmp15_ = _tmp14_;
	vala_code_node_accept ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
	_tmp16_ = self->priv->current_block;
	_tmp17_ = _vala_basic_block_ref0 (_tmp16_);
	last_true_block = _tmp17_;
	_tmp18_ = vala_if_statement_get_condition (stmt);
	_tmp19_ = _tmp18_;
	if (vala_flow_analyzer_always_true (self, _tmp19_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp20_;
		ValaSet* _tmp21_;
		ValaBasicBlock* _tmp22_;
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp20_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp20_;
		_tmp21_ = self->priv->all_basic_blocks;
		_tmp22_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
		_tmp23_ = last_block;
		_tmp24_ = self->priv->current_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = vala_if_statement_get_false_statement (stmt);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaBlock* _tmp27_;
		ValaBlock* _tmp28_;
		_tmp27_ = vala_if_statement_get_false_statement (stmt);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, (ValaCodeVisitor*) self);
	}
	_tmp29_ = self->priv->current_block;
	_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
	last_false_block = _tmp30_;
	_tmp32_ = last_true_block;
	if (_tmp32_ != NULL) {
		_tmp31_ = TRUE;
	} else {
		ValaBasicBlock* _tmp33_;
		_tmp33_ = last_false_block;
		_tmp31_ = _tmp33_ != NULL;
	}
	if (_tmp31_) {
		ValaBasicBlock* _tmp34_;
		ValaSet* _tmp35_;
		ValaBasicBlock* _tmp36_;
		ValaBasicBlock* _tmp37_;
		ValaBasicBlock* _tmp40_;
		_tmp34_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp34_;
		_tmp35_ = self->priv->all_basic_blocks;
		_tmp36_ = self->priv->current_block;
		vala_collection_add ((ValaCollection*) _tmp35_, _tmp36_);
		_tmp37_ = last_true_block;
		if (_tmp37_ != NULL) {
			ValaBasicBlock* _tmp38_;
			ValaBasicBlock* _tmp39_;
			_tmp38_ = last_true_block;
			_tmp39_ = self->priv->current_block;
			vala_basic_block_connect (_tmp38_, _tmp39_);
		}
		_tmp40_ = last_false_block;
		if (_tmp40_ != NULL) {
			ValaBasicBlock* _tmp41_;
			ValaBasicBlock* _tmp42_;
			_tmp41_ = last_false_block;
			_tmp42_ = self->priv->current_block;
			vala_basic_block_connect (_tmp41_, _tmp42_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}

static void
vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                ValaSwitchStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	gboolean has_default_label = FALSE;
	ValaBasicBlock* _tmp44_;
	ValaList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	ValaList* _tmp50_;
	ValaList* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gpointer _tmp54_;
	ValaFlowAnalyzerJumpTarget* _tmp55_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	after_switch_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = after_switch_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = after_switch_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_break_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = self->priv->current_block;
	_tmp8_ = vala_switch_statement_get_expression (stmt);
	_tmp9_ = _tmp8_;
	vala_basic_block_add_node (_tmp7_, (ValaCodeNode*) _tmp9_);
	_tmp10_ = self->priv->current_block;
	_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
	condition_block = _tmp11_;
	_tmp12_ = vala_switch_statement_get_expression (stmt);
	_tmp13_ = _tmp12_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp13_, FALSE);
	has_default_label = FALSE;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		gint _section_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _section_index = 0;
		_tmp14_ = vala_switch_statement_get_sections (stmt);
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_section_list = _tmp15_;
		_tmp16_ = _section_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_section_size = _tmp18_;
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaBasicBlock* _tmp21_;
			ValaSet* _tmp22_;
			ValaBasicBlock* _tmp23_;
			ValaBasicBlock* _tmp24_;
			ValaBasicBlock* _tmp25_;
			ValaSwitchSection* _tmp34_;
			ValaBasicBlock* _tmp35_;
			_section_index = _section_index + 1;
			if (!(_section_index < _section_size)) {
				break;
			}
			_tmp19_ = _section_list;
			_tmp20_ = vala_list_get (_tmp19_, _section_index);
			section = (ValaSwitchSection*) _tmp20_;
			_tmp21_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp21_;
			_tmp22_ = self->priv->all_basic_blocks;
			_tmp23_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp22_, _tmp23_);
			_tmp24_ = condition_block;
			_tmp25_ = self->priv->current_block;
			vala_basic_block_connect (_tmp24_, _tmp25_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp26_;
				ValaList* _tmp27_;
				gint _section_stmt_size = 0;
				ValaList* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _section_stmt_index = 0;
				_tmp26_ = section;
				_tmp27_ = vala_block_get_statements ((ValaBlock*) _tmp26_);
				_section_stmt_list = _tmp27_;
				_tmp28_ = _section_stmt_list;
				_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				_section_stmt_size = _tmp30_;
				_section_stmt_index = -1;
				while (TRUE) {
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp31_;
					gpointer _tmp32_;
					ValaStatement* _tmp33_;
					_section_stmt_index = _section_stmt_index + 1;
					if (!(_section_stmt_index < _section_stmt_size)) {
						break;
					}
					_tmp31_ = _section_stmt_list;
					_tmp32_ = vala_list_get (_tmp31_, _section_stmt_index);
					section_stmt = (ValaStatement*) _tmp32_;
					_tmp33_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp33_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			_tmp34_ = section;
			if (vala_switch_section_has_default_label (_tmp34_)) {
				has_default_label = TRUE;
			}
			_tmp35_ = self->priv->current_block;
			if (_tmp35_ != NULL) {
				ValaSwitchSection* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaSwitchSection* _tmp39_;
				ValaBasicBlock* _tmp40_;
				ValaBasicBlock* _tmp41_;
				_tmp36_ = section;
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp38_, "missing break statement at end of switch section");
				_tmp39_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp39_, TRUE);
				_tmp40_ = self->priv->current_block;
				_tmp41_ = after_switch_block;
				vala_basic_block_connect (_tmp40_, _tmp41_);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	if (!has_default_label) {
		ValaBasicBlock* _tmp42_;
		ValaBasicBlock* _tmp43_;
		_tmp42_ = condition_block;
		_tmp43_ = after_switch_block;
		vala_basic_block_connect (_tmp42_, _tmp43_);
	}
	_tmp44_ = after_switch_block;
	_tmp45_ = vala_basic_block_get_predecessors (_tmp44_);
	_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_ > 0) {
		ValaBasicBlock* _tmp48_;
		ValaBasicBlock* _tmp49_;
		_tmp48_ = after_switch_block;
		_tmp49_ = _vala_basic_block_ref0 (_tmp48_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp49_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp50_ = self->priv->jump_stack;
	_tmp51_ = self->priv->jump_stack;
	_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_list_remove_at (_tmp50_, _tmp53_ - 1);
	_tmp55_ = (ValaFlowAnalyzerJumpTarget*) _tmp54_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp55_);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}

static void
vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                    ValaLoop* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaSet* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaList* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaFlowAnalyzerJumpTarget* _tmp5_;
	ValaFlowAnalyzerJumpTarget* _tmp6_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp7_;
	ValaSet* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaList* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaFlowAnalyzerJumpTarget* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gpointer _tmp35_;
	ValaFlowAnalyzerJumpTarget* _tmp36_;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gpointer _tmp41_;
	ValaFlowAnalyzerJumpTarget* _tmp42_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	loop_block = _tmp0_;
	_tmp1_ = self->priv->all_basic_blocks;
	_tmp2_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = loop_block;
	_tmp5_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp4_);
	_tmp6_ = _tmp5_;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp6_);
	_tmp7_ = vala_basic_block_new ();
	after_loop_block = _tmp7_;
	_tmp8_ = self->priv->all_basic_blocks;
	_tmp9_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
	_tmp10_ = self->priv->jump_stack;
	_tmp11_ = after_loop_block;
	_tmp12_ = vala_flow_analyzer_jump_target_new_break_target (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_collection_add ((ValaCollection*) _tmp10_, _tmp13_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp13_);
	_tmp14_ = self->priv->current_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	last_block = _tmp15_;
	_tmp16_ = last_block;
	_tmp17_ = loop_block;
	vala_basic_block_connect (_tmp16_, _tmp17_);
	_tmp18_ = loop_block;
	_tmp19_ = _vala_basic_block_ref0 (_tmp18_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp19_;
	_tmp20_ = vala_loop_get_body (stmt);
	_tmp21_ = _tmp20_;
	vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->current_block;
	if (_tmp22_ != NULL) {
		ValaBasicBlock* _tmp23_;
		ValaBasicBlock* _tmp24_;
		_tmp23_ = self->priv->current_block;
		_tmp24_ = loop_block;
		vala_basic_block_connect (_tmp23_, _tmp24_);
	}
	_tmp25_ = after_loop_block;
	_tmp26_ = vala_basic_block_get_predecessors (_tmp25_);
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == 0) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp29_;
		ValaBasicBlock* _tmp30_;
		_tmp29_ = after_loop_block;
		_tmp30_ = _vala_basic_block_ref0 (_tmp29_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp30_;
	}
	_tmp31_ = self->priv->jump_stack;
	_tmp32_ = self->priv->jump_stack;
	_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_list_remove_at (_tmp31_, _tmp34_ - 1);
	_tmp36_ = (ValaFlowAnalyzerJumpTarget*) _tmp35_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp36_);
	_tmp37_ = self->priv->jump_stack;
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_list_remove_at (_tmp37_, _tmp40_ - 1);
	_tmp42_ = (ValaFlowAnalyzerJumpTarget*) _tmp41_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp42_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}

static void
vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                 ValaForeachStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaSet* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaFlowAnalyzerJumpTarget* _tmp10_;
	ValaFlowAnalyzerJumpTarget* _tmp11_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp12_;
	ValaSet* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaList* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaFlowAnalyzerJumpTarget* _tmp17_;
	ValaFlowAnalyzerJumpTarget* _tmp18_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBasicBlock* _tmp22_;
	ValaBasicBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp25_;
	ValaBlock* _tmp26_;
	ValaBlock* _tmp27_;
	ValaBasicBlock* _tmp28_;
	ValaBasicBlock* _tmp31_;
	ValaBasicBlock* _tmp32_;
	ValaBasicBlock* _tmp33_;
	ValaBasicBlock* _tmp36_;
	ValaBasicBlock* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gpointer _tmp42_;
	ValaFlowAnalyzerJumpTarget* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_;
	ValaFlowAnalyzerJumpTarget* _tmp49_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_foreach_statement_get_collection (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_foreach_statement_get_collection (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_basic_block_new ();
	loop_block = _tmp5_;
	_tmp6_ = self->priv->all_basic_blocks;
	_tmp7_ = loop_block;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->jump_stack;
	_tmp9_ = loop_block;
	_tmp10_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, _tmp11_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp11_);
	_tmp12_ = vala_basic_block_new ();
	after_loop_block = _tmp12_;
	_tmp13_ = self->priv->all_basic_blocks;
	_tmp14_ = after_loop_block;
	vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->jump_stack;
	_tmp16_ = after_loop_block;
	_tmp17_ = vala_flow_analyzer_jump_target_new_break_target (_tmp16_);
	_tmp18_ = _tmp17_;
	vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
	_tmp19_ = self->priv->current_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	last_block = _tmp20_;
	_tmp21_ = last_block;
	_tmp22_ = loop_block;
	vala_basic_block_connect (_tmp21_, _tmp22_);
	_tmp23_ = loop_block;
	_tmp24_ = _vala_basic_block_ref0 (_tmp23_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp24_;
	_tmp25_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp25_, (ValaCodeNode*) stmt);
	_tmp26_ = vala_foreach_statement_get_body (stmt);
	_tmp27_ = _tmp26_;
	vala_code_node_accept ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
	_tmp28_ = self->priv->current_block;
	if (_tmp28_ != NULL) {
		ValaBasicBlock* _tmp29_;
		ValaBasicBlock* _tmp30_;
		_tmp29_ = self->priv->current_block;
		_tmp30_ = loop_block;
		vala_basic_block_connect (_tmp29_, _tmp30_);
	}
	_tmp31_ = last_block;
	_tmp32_ = after_loop_block;
	vala_basic_block_connect (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->current_block;
	if (_tmp33_ != NULL) {
		ValaBasicBlock* _tmp34_;
		ValaBasicBlock* _tmp35_;
		_tmp34_ = self->priv->current_block;
		_tmp35_ = after_loop_block;
		vala_basic_block_connect (_tmp34_, _tmp35_);
	}
	_tmp36_ = after_loop_block;
	_tmp37_ = _vala_basic_block_ref0 (_tmp36_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp37_;
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = self->priv->jump_stack;
	_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_list_remove_at (_tmp38_, _tmp41_ - 1);
	_tmp43_ = (ValaFlowAnalyzerJumpTarget*) _tmp42_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp43_);
	_tmp44_ = self->priv->jump_stack;
	_tmp45_ = self->priv->jump_stack;
	_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_list_remove_at (_tmp44_, _tmp47_ - 1);
	_tmp49_ = (ValaFlowAnalyzerJumpTarget*) _tmp48_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp49_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}

static void
vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                               ValaBreakStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaFlowAnalyzerJumpTarget* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = self->priv->jump_stack;
				_tmp7_ = vala_list_get (_tmp6_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp7_;
				_tmp8_ = jump_target;
				_tmp9_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					ValaBasicBlock* _tmp11_;
					ValaFlowAnalyzerJumpTarget* _tmp12_;
					ValaBasicBlock* _tmp13_;
					ValaBasicBlock* _tmp14_;
					_tmp11_ = self->priv->current_block;
					_tmp12_ = jump_target;
					_tmp13_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp12_);
					_tmp14_ = _tmp13_;
					vala_basic_block_connect (_tmp11_, _tmp14_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = jump_target;
					_tmp16_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						ValaBasicBlock* _tmp18_;
						ValaFlowAnalyzerJumpTarget* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaFlowAnalyzerJumpTarget* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						_tmp18_ = self->priv->current_block;
						_tmp19_ = jump_target;
						_tmp20_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp19_);
						_tmp21_ = _tmp20_;
						vala_basic_block_connect (_tmp18_, _tmp21_);
						_tmp22_ = jump_target;
						_tmp23_ = vala_flow_analyzer_jump_target_get_last_block (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _vala_basic_block_ref0 (_tmp24_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp25_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp27_ = _tmp26_;
	vala_report_error (_tmp27_, "no enclosing loop or switch statement found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                  ValaContinueStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaFlowAnalyzerJumpTarget* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = self->priv->jump_stack;
				_tmp7_ = vala_list_get (_tmp6_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp7_;
				_tmp8_ = jump_target;
				_tmp9_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					ValaBasicBlock* _tmp11_;
					ValaFlowAnalyzerJumpTarget* _tmp12_;
					ValaBasicBlock* _tmp13_;
					ValaBasicBlock* _tmp14_;
					_tmp11_ = self->priv->current_block;
					_tmp12_ = jump_target;
					_tmp13_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp12_);
					_tmp14_ = _tmp13_;
					vala_basic_block_connect (_tmp11_, _tmp14_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp15_ = jump_target;
					_tmp16_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						ValaBasicBlock* _tmp18_;
						ValaFlowAnalyzerJumpTarget* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaFlowAnalyzerJumpTarget* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						_tmp18_ = self->priv->current_block;
						_tmp19_ = jump_target;
						_tmp20_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp19_);
						_tmp21_ = _tmp20_;
						vala_basic_block_connect (_tmp18_, _tmp21_);
						_tmp22_ = jump_target;
						_tmp23_ = vala_flow_analyzer_jump_target_get_last_block (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _vala_basic_block_ref0 (_tmp24_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp25_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp27_ = _tmp26_;
	vala_report_error (_tmp27_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                ValaReturnStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp30_;
	ValaSourceReference* _tmp31_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	_tmp1_ = vala_return_statement_get_return_expression (stmt);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_return_statement_get_return_expression (stmt);
		_tmp4_ = _tmp3_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->jump_stack;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		i = _tmp7_ - 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp10_;
				gpointer _tmp11_;
				ValaFlowAnalyzerJumpTarget* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ - 1;
				}
				_tmp8_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp10_ = self->priv->jump_stack;
				_tmp11_ = vala_list_get (_tmp10_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp11_;
				_tmp12_ = jump_target;
				_tmp13_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					ValaBasicBlock* _tmp15_;
					ValaFlowAnalyzerJumpTarget* _tmp16_;
					ValaBasicBlock* _tmp17_;
					ValaBasicBlock* _tmp18_;
					_tmp15_ = self->priv->current_block;
					_tmp16_ = jump_target;
					_tmp17_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp16_);
					_tmp18_ = _tmp17_;
					vala_basic_block_connect (_tmp15_, _tmp18_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp19_;
					gboolean _tmp20_;
					gboolean _tmp21_;
					_tmp19_ = jump_target;
					_tmp20_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp19_);
					_tmp21_ = _tmp20_;
					if (_tmp21_) {
						ValaBasicBlock* _tmp22_;
						ValaFlowAnalyzerJumpTarget* _tmp23_;
						ValaBasicBlock* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaFlowAnalyzerJumpTarget* _tmp26_;
						ValaBasicBlock* _tmp27_;
						ValaBasicBlock* _tmp28_;
						ValaBasicBlock* _tmp29_;
						_tmp22_ = self->priv->current_block;
						_tmp23_ = jump_target;
						_tmp24_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp23_);
						_tmp25_ = _tmp24_;
						vala_basic_block_connect (_tmp22_, _tmp25_);
						_tmp26_ = jump_target;
						_tmp27_ = vala_flow_analyzer_jump_target_get_last_block (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = _vala_basic_block_ref0 (_tmp28_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp29_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp31_ = _tmp30_;
	vala_report_error (_tmp31_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                  ValaCodeNode* node,
                                  gboolean always_fail)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_code_node_get_tree_can_fail (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp2_;
		ValaBasicBlock* _tmp3_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaArrayList* _tmp6_;
		_tmp2_ = self->priv->current_block;
		_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
		last_block = _tmp3_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		error_types = _tmp5_;
		_tmp6_ = error_types;
		vala_code_node_get_error_types (node, (ValaCollection*) _tmp6_, NULL);
		{
			ValaArrayList* _error_data_type_list = NULL;
			ValaArrayList* _tmp7_;
			ValaArrayList* _tmp8_;
			gint _error_data_type_size = 0;
			ValaArrayList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _error_data_type_index = 0;
			_tmp7_ = error_types;
			_tmp8_ = _vala_iterable_ref0 (_tmp7_);
			_error_data_type_list = _tmp8_;
			_tmp9_ = _error_data_type_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_error_data_type_size = _tmp11_;
			_error_data_type_index = -1;
			while (TRUE) {
				ValaDataType* error_data_type = NULL;
				ValaArrayList* _tmp12_;
				gpointer _tmp13_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp14_;
				ValaClass* error_class = NULL;
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaBasicBlock* _tmp18_;
				ValaBasicBlock* _tmp19_;
				_error_data_type_index = _error_data_type_index + 1;
				if (!(_error_data_type_index < _error_data_type_size)) {
					break;
				}
				_tmp12_ = _error_data_type_list;
				_tmp13_ = vala_list_get ((ValaList*) _tmp12_, _error_data_type_index);
				error_data_type = (ValaDataType*) _tmp13_;
				_tmp14_ = error_data_type;
				error_type = VALA_IS_ERROR_TYPE (_tmp14_) ? ((ValaErrorType*) _tmp14_) : NULL;
				_tmp15_ = error_data_type;
				_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				error_class = VALA_IS_CLASS (_tmp17_) ? ((ValaClass*) _tmp17_) : NULL;
				_tmp18_ = last_block;
				_tmp19_ = _vala_basic_block_ref0 (_tmp18_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp19_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					_tmp20_ = self->priv->jump_stack;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					i = _tmp22_ - 1;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp25_;
							gpointer _tmp26_;
							ValaFlowAnalyzerJumpTarget* _tmp27_;
							gboolean _tmp28_;
							gboolean _tmp29_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = i;
								i = _tmp24_ - 1;
							}
							_tmp23_ = FALSE;
							if (!(i >= 0)) {
								break;
							}
							_tmp25_ = self->priv->jump_stack;
							_tmp26_ = vala_list_get (_tmp25_, i);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp26_;
							_tmp27_ = jump_target;
							_tmp28_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp27_);
							_tmp29_ = _tmp28_;
							if (_tmp29_) {
								ValaBasicBlock* _tmp30_;
								ValaFlowAnalyzerJumpTarget* _tmp31_;
								ValaBasicBlock* _tmp32_;
								ValaBasicBlock* _tmp33_;
								_tmp30_ = self->priv->current_block;
								_tmp31_ = jump_target;
								_tmp32_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp31_);
								_tmp33_ = _tmp32_;
								vala_basic_block_connect (_tmp30_, _tmp33_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp34_;
								gboolean _tmp35_;
								gboolean _tmp36_;
								_tmp34_ = jump_target;
								_tmp35_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp34_);
								_tmp36_ = _tmp35_;
								if (_tmp36_) {
									ValaCodeContext* _tmp37_;
									ValaProfile _tmp38_;
									ValaProfile _tmp39_;
									_tmp37_ = self->priv->context;
									_tmp38_ = vala_code_context_get_profile (_tmp37_);
									_tmp39_ = _tmp38_;
									if (_tmp39_ == VALA_PROFILE_GOBJECT) {
										gboolean _tmp40_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp41_;
										ValaErrorDomain* _tmp42_;
										ValaErrorDomain* _tmp43_;
										_tmp41_ = jump_target;
										_tmp42_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp41_);
										_tmp43_ = _tmp42_;
										if (_tmp43_ == NULL) {
											_tmp40_ = TRUE;
										} else {
											gboolean _tmp44_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp45_;
											ValaErrorDomain* _tmp46_;
											ValaErrorDomain* _tmp47_;
											ValaErrorType* _tmp48_;
											ValaErrorDomain* _tmp49_;
											ValaErrorDomain* _tmp50_;
											_tmp45_ = jump_target;
											_tmp46_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp45_);
											_tmp47_ = _tmp46_;
											_tmp48_ = error_type;
											_tmp49_ = vala_error_type_get_error_domain (_tmp48_);
											_tmp50_ = _tmp49_;
											if (_tmp47_ == _tmp50_) {
												gboolean _tmp51_ = FALSE;
												ValaFlowAnalyzerJumpTarget* _tmp52_;
												ValaErrorCode* _tmp53_;
												ValaErrorCode* _tmp54_;
												_tmp52_ = jump_target;
												_tmp53_ = vala_flow_analyzer_jump_target_get_error_code (_tmp52_);
												_tmp54_ = _tmp53_;
												if (_tmp54_ == NULL) {
													_tmp51_ = TRUE;
												} else {
													ValaFlowAnalyzerJumpTarget* _tmp55_;
													ValaErrorCode* _tmp56_;
													ValaErrorCode* _tmp57_;
													ValaErrorType* _tmp58_;
													ValaErrorCode* _tmp59_;
													ValaErrorCode* _tmp60_;
													_tmp55_ = jump_target;
													_tmp56_ = vala_flow_analyzer_jump_target_get_error_code (_tmp55_);
													_tmp57_ = _tmp56_;
													_tmp58_ = error_type;
													_tmp59_ = vala_error_type_get_error_code (_tmp58_);
													_tmp60_ = _tmp59_;
													_tmp51_ = _tmp57_ == _tmp60_;
												}
												_tmp44_ = _tmp51_;
											} else {
												_tmp44_ = FALSE;
											}
											_tmp40_ = _tmp44_;
										}
										if (_tmp40_) {
											ValaBasicBlock* _tmp61_;
											ValaFlowAnalyzerJumpTarget* _tmp62_;
											ValaBasicBlock* _tmp63_;
											ValaBasicBlock* _tmp64_;
											_tmp61_ = self->priv->current_block;
											_tmp62_ = jump_target;
											_tmp63_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp62_);
											_tmp64_ = _tmp63_;
											vala_basic_block_connect (_tmp61_, _tmp64_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											gboolean _tmp65_ = FALSE;
											ValaErrorType* _tmp66_;
											ValaErrorDomain* _tmp67_;
											ValaErrorDomain* _tmp68_;
											_tmp66_ = error_type;
											_tmp67_ = vala_error_type_get_error_domain (_tmp66_);
											_tmp68_ = _tmp67_;
											if (_tmp68_ == NULL) {
												_tmp65_ = TRUE;
											} else {
												gboolean _tmp69_ = FALSE;
												ValaErrorType* _tmp70_;
												ValaErrorDomain* _tmp71_;
												ValaErrorDomain* _tmp72_;
												ValaFlowAnalyzerJumpTarget* _tmp73_;
												ValaErrorDomain* _tmp74_;
												ValaErrorDomain* _tmp75_;
												_tmp70_ = error_type;
												_tmp71_ = vala_error_type_get_error_domain (_tmp70_);
												_tmp72_ = _tmp71_;
												_tmp73_ = jump_target;
												_tmp74_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp73_);
												_tmp75_ = _tmp74_;
												if (_tmp72_ == _tmp75_) {
													gboolean _tmp76_ = FALSE;
													ValaErrorType* _tmp77_;
													ValaErrorCode* _tmp78_;
													ValaErrorCode* _tmp79_;
													_tmp77_ = error_type;
													_tmp78_ = vala_error_type_get_error_code (_tmp77_);
													_tmp79_ = _tmp78_;
													if (_tmp79_ == NULL) {
														_tmp76_ = TRUE;
													} else {
														ValaErrorType* _tmp80_;
														ValaErrorCode* _tmp81_;
														ValaErrorCode* _tmp82_;
														ValaFlowAnalyzerJumpTarget* _tmp83_;
														ValaErrorCode* _tmp84_;
														ValaErrorCode* _tmp85_;
														_tmp80_ = error_type;
														_tmp81_ = vala_error_type_get_error_code (_tmp80_);
														_tmp82_ = _tmp81_;
														_tmp83_ = jump_target;
														_tmp84_ = vala_flow_analyzer_jump_target_get_error_code (_tmp83_);
														_tmp85_ = _tmp84_;
														_tmp76_ = _tmp82_ == _tmp85_;
													}
													_tmp69_ = _tmp76_;
												} else {
													_tmp69_ = FALSE;
												}
												_tmp65_ = _tmp69_;
											}
											if (_tmp65_) {
												ValaBasicBlock* _tmp86_;
												ValaFlowAnalyzerJumpTarget* _tmp87_;
												ValaBasicBlock* _tmp88_;
												ValaBasicBlock* _tmp89_;
												_tmp86_ = self->priv->current_block;
												_tmp87_ = jump_target;
												_tmp88_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp87_);
												_tmp89_ = _tmp88_;
												vala_basic_block_connect (_tmp86_, _tmp89_);
											}
										}
									} else {
										gboolean _tmp90_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp91_;
										ValaClass* _tmp92_;
										ValaClass* _tmp93_;
										_tmp91_ = jump_target;
										_tmp92_ = vala_flow_analyzer_jump_target_get_error_class (_tmp91_);
										_tmp93_ = _tmp92_;
										if (_tmp93_ == NULL) {
											_tmp90_ = TRUE;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp94_;
											ValaClass* _tmp95_;
											ValaClass* _tmp96_;
											ValaClass* _tmp97_;
											_tmp94_ = jump_target;
											_tmp95_ = vala_flow_analyzer_jump_target_get_error_class (_tmp94_);
											_tmp96_ = _tmp95_;
											_tmp97_ = error_class;
											_tmp90_ = _tmp96_ == _tmp97_;
										}
										if (_tmp90_) {
											ValaBasicBlock* _tmp98_;
											ValaFlowAnalyzerJumpTarget* _tmp99_;
											ValaBasicBlock* _tmp100_;
											ValaBasicBlock* _tmp101_;
											_tmp98_ = self->priv->current_block;
											_tmp99_ = jump_target;
											_tmp100_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp99_);
											_tmp101_ = _tmp100_;
											vala_basic_block_connect (_tmp98_, _tmp101_);
											vala_flow_analyzer_mark_unreachable (self);
											_vala_flow_analyzer_jump_target_unref0 (jump_target);
											break;
										} else {
											ValaFlowAnalyzerJumpTarget* _tmp102_;
											ValaClass* _tmp103_;
											ValaClass* _tmp104_;
											ValaClass* _tmp105_;
											_tmp102_ = jump_target;
											_tmp103_ = vala_flow_analyzer_jump_target_get_error_class (_tmp102_);
											_tmp104_ = _tmp103_;
											_tmp105_ = error_class;
											if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp104_, (ValaTypeSymbol*) _tmp105_)) {
												ValaBasicBlock* _tmp106_;
												ValaFlowAnalyzerJumpTarget* _tmp107_;
												ValaBasicBlock* _tmp108_;
												ValaBasicBlock* _tmp109_;
												_tmp106_ = self->priv->current_block;
												_tmp107_ = jump_target;
												_tmp108_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp107_);
												_tmp109_ = _tmp108_;
												vala_basic_block_connect (_tmp106_, _tmp109_);
											}
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp110_;
									gboolean _tmp111_;
									gboolean _tmp112_;
									_tmp110_ = jump_target;
									_tmp111_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp110_);
									_tmp112_ = _tmp111_;
									if (_tmp112_) {
										ValaBasicBlock* _tmp113_;
										ValaFlowAnalyzerJumpTarget* _tmp114_;
										ValaBasicBlock* _tmp115_;
										ValaBasicBlock* _tmp116_;
										ValaFlowAnalyzerJumpTarget* _tmp117_;
										ValaBasicBlock* _tmp118_;
										ValaBasicBlock* _tmp119_;
										ValaBasicBlock* _tmp120_;
										_tmp113_ = self->priv->current_block;
										_tmp114_ = jump_target;
										_tmp115_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp114_);
										_tmp116_ = _tmp115_;
										vala_basic_block_connect (_tmp113_, _tmp116_);
										_tmp117_ = jump_target;
										_tmp118_ = vala_flow_analyzer_jump_target_get_last_block (_tmp117_);
										_tmp119_ = _tmp118_;
										_tmp120_ = _vala_basic_block_ref0 (_tmp119_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp120_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_data_type);
			}
			_vala_iterable_unref0 (_error_data_type_list);
		}
		if (!always_fail) {
			ValaBasicBlock* _tmp121_;
			ValaSet* _tmp122_;
			ValaBasicBlock* _tmp123_;
			ValaBasicBlock* _tmp124_;
			ValaBasicBlock* _tmp125_;
			_tmp121_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp121_;
			_tmp122_ = self->priv->all_basic_blocks;
			_tmp123_ = self->priv->current_block;
			vala_collection_add ((ValaCollection*) _tmp122_, _tmp123_);
			_tmp124_ = last_block;
			_tmp125_ = self->priv->current_block;
			vala_basic_block_connect (_tmp124_, _tmp125_);
		}
		_vala_iterable_unref0 (error_types);
		_vala_basic_block_unref0 (last_block);
	}
}

static void
vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                               ValaYieldStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, TRUE);
}

static void
vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaSet* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* finally_block = NULL;
	ValaBlock* _tmp5_;
	ValaBlock* _tmp6_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	ValaList* catch_clauses = NULL;
	ValaList* _tmp41_;
	ValaList* _tmp42_;
	ValaBasicBlock* _tmp91_;
	ValaBasicBlock* _tmp92_;
	ValaBlock* _tmp93_;
	ValaBlock* _tmp94_;
	ValaBasicBlock* _tmp95_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp103_;
	ValaArrayList* _tmp104_;
	ValaBasicBlock* _tmp188_;
	ValaBasicBlock* _tmp195_;
	ValaList* _tmp196_;
	gint _tmp197_;
	gint _tmp198_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	before_try_block = _tmp1_;
	_tmp2_ = vala_basic_block_new ();
	after_try_block = _tmp2_;
	_tmp3_ = self->priv->all_basic_blocks;
	_tmp4_ = after_try_block;
	vala_collection_add ((ValaCollection*) _tmp3_, _tmp4_);
	finally_block = NULL;
	_tmp5_ = vala_try_statement_get_finally_body (stmt);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaBasicBlock* _tmp7_;
		ValaSet* _tmp8_;
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* _tmp11_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp12_;
		ValaSet* _tmp13_;
		ValaBasicBlock* _tmp14_;
		ValaList* _tmp15_;
		ValaBasicBlock* _tmp16_;
		ValaFlowAnalyzerJumpTarget* _tmp17_;
		ValaFlowAnalyzerJumpTarget* _tmp18_;
		ValaBlock* _tmp19_;
		ValaBlock* _tmp20_;
		ValaBasicBlock* _tmp21_;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		ValaList* _tmp27_;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gpointer _tmp31_;
		ValaFlowAnalyzerJumpTarget* _tmp32_;
		ValaList* _tmp33_;
		ValaBasicBlock* _tmp34_;
		ValaBasicBlock* _tmp35_;
		ValaFlowAnalyzerJumpTarget* _tmp36_;
		ValaFlowAnalyzerJumpTarget* _tmp37_;
		_tmp7_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp7_;
		_tmp8_ = self->priv->all_basic_blocks;
		_tmp9_ = finally_block;
		vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
		_tmp10_ = finally_block;
		_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp11_;
		_tmp12_ = vala_basic_block_new ();
		invalid_block = _tmp12_;
		_tmp13_ = self->priv->all_basic_blocks;
		_tmp14_ = invalid_block;
		vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
		_tmp15_ = self->priv->jump_stack;
		_tmp16_ = invalid_block;
		_tmp17_ = vala_flow_analyzer_jump_target_new_any_target (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_collection_add ((ValaCollection*) _tmp15_, _tmp18_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp18_);
		_tmp19_ = vala_try_statement_get_finally_body (stmt);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
		_tmp21_ = invalid_block;
		_tmp22_ = vala_basic_block_get_predecessors (_tmp21_);
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ > 0) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "jump out of finally block not permitted");
			vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp27_ = self->priv->jump_stack;
		_tmp28_ = self->priv->jump_stack;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_list_remove_at (_tmp27_, _tmp30_ - 1);
		_tmp32_ = (ValaFlowAnalyzerJumpTarget*) _tmp31_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp32_);
		_tmp33_ = self->priv->jump_stack;
		_tmp34_ = finally_block;
		_tmp35_ = self->priv->current_block;
		_tmp36_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp34_, _tmp35_);
		_tmp37_ = _tmp36_;
		vala_collection_add ((ValaCollection*) _tmp33_, _tmp37_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp37_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp38_ = self->priv->jump_stack;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	finally_jump_stack_size = _tmp40_;
	_tmp41_ = vala_try_statement_get_catch_clauses (stmt);
	_tmp42_ = _vala_iterable_ref0 (_tmp41_);
	catch_clauses = _tmp42_;
	{
		gint i = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp43_ = catch_clauses;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		i = _tmp45_ - 1;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaBasicBlock* error_block = NULL;
				ValaBasicBlock* _tmp50_;
				ValaSet* _tmp51_;
				ValaBasicBlock* _tmp52_;
				ValaCatchClause* _tmp53_;
				ValaDataType* _tmp54_;
				ValaDataType* _tmp55_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ - 1;
				}
				_tmp46_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp48_ = catch_clauses;
				_tmp49_ = vala_list_get (_tmp48_, i);
				catch_clause = (ValaCatchClause*) _tmp49_;
				_tmp50_ = vala_basic_block_new ();
				error_block = _tmp50_;
				_tmp51_ = self->priv->all_basic_blocks;
				_tmp52_ = error_block;
				vala_collection_add ((ValaCollection*) _tmp51_, _tmp52_);
				_tmp53_ = catch_clause;
				_tmp54_ = vala_catch_clause_get_error_type (_tmp53_);
				_tmp55_ = _tmp54_;
				if (_tmp55_ != NULL) {
					ValaCodeContext* _tmp56_;
					ValaProfile _tmp57_;
					ValaProfile _tmp58_;
					_tmp56_ = self->priv->context;
					_tmp57_ = vala_code_context_get_profile (_tmp56_);
					_tmp58_ = _tmp57_;
					if (_tmp58_ == VALA_PROFILE_GOBJECT) {
						ValaErrorType* error_type = NULL;
						ValaCatchClause* _tmp59_;
						ValaDataType* _tmp60_;
						ValaDataType* _tmp61_;
						ValaList* _tmp62_;
						ValaBasicBlock* _tmp63_;
						ValaCatchClause* _tmp64_;
						ValaCatchClause* _tmp65_;
						ValaDataType* _tmp66_;
						ValaDataType* _tmp67_;
						ValaTypeSymbol* _tmp68_;
						ValaTypeSymbol* _tmp69_;
						ValaErrorType* _tmp70_;
						ValaErrorCode* _tmp71_;
						ValaErrorCode* _tmp72_;
						ValaFlowAnalyzerJumpTarget* _tmp73_;
						ValaFlowAnalyzerJumpTarget* _tmp74_;
						_tmp59_ = catch_clause;
						_tmp60_ = vala_catch_clause_get_error_type (_tmp59_);
						_tmp61_ = _tmp60_;
						error_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_ERROR_TYPE, ValaErrorType);
						_tmp62_ = self->priv->jump_stack;
						_tmp63_ = error_block;
						_tmp64_ = catch_clause;
						_tmp65_ = catch_clause;
						_tmp66_ = vala_catch_clause_get_error_type (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = vala_data_type_get_type_symbol (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = error_type;
						_tmp71_ = vala_error_type_get_error_code (_tmp70_);
						_tmp72_ = _tmp71_;
						_tmp73_ = vala_flow_analyzer_jump_target_new_error_target (_tmp63_, _tmp64_, VALA_IS_ERROR_DOMAIN (_tmp69_) ? ((ValaErrorDomain*) _tmp69_) : NULL, _tmp72_, NULL);
						_tmp74_ = _tmp73_;
						vala_collection_add ((ValaCollection*) _tmp62_, _tmp74_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp74_);
					} else {
						ValaClass* error_class = NULL;
						ValaCatchClause* _tmp75_;
						ValaDataType* _tmp76_;
						ValaDataType* _tmp77_;
						ValaTypeSymbol* _tmp78_;
						ValaTypeSymbol* _tmp79_;
						ValaList* _tmp80_;
						ValaBasicBlock* _tmp81_;
						ValaCatchClause* _tmp82_;
						ValaClass* _tmp83_;
						ValaFlowAnalyzerJumpTarget* _tmp84_;
						ValaFlowAnalyzerJumpTarget* _tmp85_;
						_tmp75_ = catch_clause;
						_tmp76_ = vala_catch_clause_get_error_type (_tmp75_);
						_tmp77_ = _tmp76_;
						_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
						_tmp79_ = _tmp78_;
						error_class = VALA_IS_CLASS (_tmp79_) ? ((ValaClass*) _tmp79_) : NULL;
						_tmp80_ = self->priv->jump_stack;
						_tmp81_ = error_block;
						_tmp82_ = catch_clause;
						_tmp83_ = error_class;
						_tmp84_ = vala_flow_analyzer_jump_target_new_error_target (_tmp81_, _tmp82_, NULL, NULL, _tmp83_);
						_tmp85_ = _tmp84_;
						vala_collection_add ((ValaCollection*) _tmp80_, _tmp85_);
						_vala_flow_analyzer_jump_target_unref0 (_tmp85_);
					}
				} else {
					ValaList* _tmp86_;
					ValaBasicBlock* _tmp87_;
					ValaCatchClause* _tmp88_;
					ValaFlowAnalyzerJumpTarget* _tmp89_;
					ValaFlowAnalyzerJumpTarget* _tmp90_;
					_tmp86_ = self->priv->jump_stack;
					_tmp87_ = error_block;
					_tmp88_ = catch_clause;
					_tmp89_ = vala_flow_analyzer_jump_target_new_error_target (_tmp87_, _tmp88_, NULL, NULL, NULL);
					_tmp90_ = _tmp89_;
					vala_collection_add ((ValaCollection*) _tmp86_, _tmp90_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp90_);
				}
				_vala_basic_block_unref0 (error_block);
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp91_ = before_try_block;
	_tmp92_ = _vala_basic_block_ref0 (_tmp91_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp92_;
	_tmp93_ = vala_try_statement_get_body (stmt);
	_tmp94_ = _tmp93_;
	vala_code_node_accept ((ValaCodeNode*) _tmp94_, (ValaCodeVisitor*) self);
	_tmp95_ = self->priv->current_block;
	if (_tmp95_ != NULL) {
		ValaBasicBlock* _tmp96_;
		ValaBasicBlock* _tmp101_;
		ValaBasicBlock* _tmp102_;
		_tmp96_ = finally_block;
		if (_tmp96_ != NULL) {
			ValaBasicBlock* _tmp97_;
			ValaBasicBlock* _tmp98_;
			ValaBasicBlock* _tmp99_;
			ValaBasicBlock* _tmp100_;
			_tmp97_ = self->priv->current_block;
			_tmp98_ = finally_block;
			vala_basic_block_connect (_tmp97_, _tmp98_);
			_tmp99_ = finally_block;
			_tmp100_ = _vala_basic_block_ref0 (_tmp99_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp100_;
		}
		_tmp101_ = self->priv->current_block;
		_tmp102_ = after_try_block;
		vala_basic_block_connect (_tmp101_, _tmp102_);
	}
	_tmp103_ = g_direct_equal;
	_tmp104_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp103_);
	catch_stack = (ValaList*) _tmp104_;
	{
		gint i = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		_tmp105_ = self->priv->jump_stack;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		i = _tmp107_ - 1;
		{
			gboolean _tmp108_ = FALSE;
			_tmp108_ = TRUE;
			while (TRUE) {
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp110_;
				gpointer _tmp111_;
				ValaList* _tmp112_;
				ValaFlowAnalyzerJumpTarget* _tmp113_;
				if (!_tmp108_) {
					gint _tmp109_;
					_tmp109_ = i;
					i = _tmp109_ - 1;
				}
				_tmp108_ = FALSE;
				if (!(i >= finally_jump_stack_size)) {
					break;
				}
				_tmp110_ = self->priv->jump_stack;
				_tmp111_ = vala_list_remove_at (_tmp110_, i);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp111_;
				_tmp112_ = catch_stack;
				_tmp113_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp112_, _tmp113_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		gint _jump_target_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _jump_target_index = 0;
		_tmp114_ = catch_stack;
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_jump_target_list = _tmp115_;
		_tmp116_ = _jump_target_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_jump_target_size = _tmp118_;
		_jump_target_index = -1;
		while (TRUE) {
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp119_;
			gpointer _tmp120_;
			ValaFlowAnalyzerJumpTarget* _tmp156_;
			ValaBasicBlock* _tmp157_;
			ValaBasicBlock* _tmp158_;
			ValaList* _tmp159_;
			gint _tmp160_;
			gint _tmp161_;
			_jump_target_index = _jump_target_index + 1;
			if (!(_jump_target_index < _jump_target_size)) {
				break;
			}
			_tmp119_ = _jump_target_list;
			_tmp120_ = vala_list_get (_tmp119_, _jump_target_index);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp120_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp121_;
				ValaList* _tmp122_;
				gint _prev_target_size = 0;
				ValaList* _tmp123_;
				gint _tmp124_;
				gint _tmp125_;
				gint _prev_target_index = 0;
				_tmp121_ = catch_stack;
				_tmp122_ = _vala_iterable_ref0 (_tmp121_);
				_prev_target_list = _tmp122_;
				_tmp123_ = _prev_target_list;
				_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
				_tmp125_ = _tmp124_;
				_prev_target_size = _tmp125_;
				_prev_target_index = -1;
				while (TRUE) {
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp126_;
					gpointer _tmp127_;
					ValaFlowAnalyzerJumpTarget* _tmp128_;
					ValaFlowAnalyzerJumpTarget* _tmp129_;
					ValaCodeContext* _tmp130_;
					ValaProfile _tmp131_;
					ValaProfile _tmp132_;
					_prev_target_index = _prev_target_index + 1;
					if (!(_prev_target_index < _prev_target_size)) {
						break;
					}
					_tmp126_ = _prev_target_list;
					_tmp127_ = vala_list_get (_tmp126_, _prev_target_index);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp127_;
					_tmp128_ = prev_target;
					_tmp129_ = jump_target;
					if (_tmp128_ == _tmp129_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp130_ = self->priv->context;
					_tmp131_ = vala_code_context_get_profile (_tmp130_);
					_tmp132_ = _tmp131_;
					if (_tmp132_ == VALA_PROFILE_GOBJECT) {
						gboolean _tmp133_ = FALSE;
						ValaFlowAnalyzerJumpTarget* _tmp134_;
						ValaErrorDomain* _tmp135_;
						ValaErrorDomain* _tmp136_;
						ValaFlowAnalyzerJumpTarget* _tmp137_;
						ValaErrorDomain* _tmp138_;
						ValaErrorDomain* _tmp139_;
						_tmp134_ = prev_target;
						_tmp135_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp134_);
						_tmp136_ = _tmp135_;
						_tmp137_ = jump_target;
						_tmp138_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp137_);
						_tmp139_ = _tmp138_;
						if (_tmp136_ == _tmp139_) {
							ValaFlowAnalyzerJumpTarget* _tmp140_;
							ValaErrorCode* _tmp141_;
							ValaErrorCode* _tmp142_;
							ValaFlowAnalyzerJumpTarget* _tmp143_;
							ValaErrorCode* _tmp144_;
							ValaErrorCode* _tmp145_;
							_tmp140_ = prev_target;
							_tmp141_ = vala_flow_analyzer_jump_target_get_error_code (_tmp140_);
							_tmp142_ = _tmp141_;
							_tmp143_ = jump_target;
							_tmp144_ = vala_flow_analyzer_jump_target_get_error_code (_tmp143_);
							_tmp145_ = _tmp144_;
							_tmp133_ = _tmp142_ == _tmp145_;
						} else {
							_tmp133_ = FALSE;
						}
						if (_tmp133_) {
							ValaSourceReference* _tmp146_;
							ValaSourceReference* _tmp147_;
							_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp147_ = _tmp146_;
							vala_report_error (_tmp147_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_iterable_unref0 (_prev_target_list);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (_jump_target_list);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					} else {
						ValaFlowAnalyzerJumpTarget* _tmp148_;
						ValaClass* _tmp149_;
						ValaClass* _tmp150_;
						ValaFlowAnalyzerJumpTarget* _tmp151_;
						ValaClass* _tmp152_;
						ValaClass* _tmp153_;
						_tmp148_ = prev_target;
						_tmp149_ = vala_flow_analyzer_jump_target_get_error_class (_tmp148_);
						_tmp150_ = _tmp149_;
						_tmp151_ = jump_target;
						_tmp152_ = vala_flow_analyzer_jump_target_get_error_class (_tmp151_);
						_tmp153_ = _tmp152_;
						if (_tmp150_ == _tmp153_) {
							ValaSourceReference* _tmp154_;
							ValaSourceReference* _tmp155_;
							_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
							_tmp155_ = _tmp154_;
							vala_report_error (_tmp155_, "double catch clause of same error detected");
							vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
							_vala_flow_analyzer_jump_target_unref0 (prev_target);
							_vala_iterable_unref0 (_prev_target_list);
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
							_vala_iterable_unref0 (_jump_target_list);
							_vala_iterable_unref0 (catch_stack);
							_vala_iterable_unref0 (catch_clauses);
							_vala_basic_block_unref0 (finally_block);
							_vala_basic_block_unref0 (after_try_block);
							_vala_basic_block_unref0 (before_try_block);
							return;
						}
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
				_vala_iterable_unref0 (_prev_target_list);
			}
			_tmp156_ = jump_target;
			_tmp157_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_basic_block_get_predecessors (_tmp158_);
			_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
			_tmp161_ = _tmp160_;
			if (_tmp161_ == 0) {
				ValaFlowAnalyzerJumpTarget* _tmp162_;
				ValaCatchClause* _tmp163_;
				ValaCatchClause* _tmp164_;
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				_tmp162_ = jump_target;
				_tmp163_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp164_);
				_tmp166_ = _tmp165_;
				vala_report_warning (_tmp166_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp167_;
				ValaBasicBlock* _tmp168_;
				ValaBasicBlock* _tmp169_;
				ValaBasicBlock* _tmp170_;
				ValaBasicBlock* _tmp171_;
				ValaFlowAnalyzerJumpTarget* _tmp172_;
				ValaCatchClause* _tmp173_;
				ValaCatchClause* _tmp174_;
				ValaFlowAnalyzerJumpTarget* _tmp175_;
				ValaCatchClause* _tmp176_;
				ValaCatchClause* _tmp177_;
				ValaBlock* _tmp178_;
				ValaBlock* _tmp179_;
				ValaBasicBlock* _tmp180_;
				_tmp167_ = jump_target;
				_tmp168_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = _vala_basic_block_ref0 (_tmp169_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp170_;
				_tmp171_ = self->priv->current_block;
				_tmp172_ = jump_target;
				_tmp173_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp172_);
				_tmp174_ = _tmp173_;
				vala_basic_block_add_node (_tmp171_, (ValaCodeNode*) _tmp174_);
				_tmp175_ = jump_target;
				_tmp176_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_catch_clause_get_body (_tmp177_);
				_tmp179_ = _tmp178_;
				vala_code_node_accept ((ValaCodeNode*) _tmp179_, (ValaCodeVisitor*) self);
				_tmp180_ = self->priv->current_block;
				if (_tmp180_ != NULL) {
					ValaBasicBlock* _tmp181_;
					ValaBasicBlock* _tmp186_;
					ValaBasicBlock* _tmp187_;
					_tmp181_ = finally_block;
					if (_tmp181_ != NULL) {
						ValaBasicBlock* _tmp182_;
						ValaBasicBlock* _tmp183_;
						ValaBasicBlock* _tmp184_;
						ValaBasicBlock* _tmp185_;
						_tmp182_ = self->priv->current_block;
						_tmp183_ = finally_block;
						vala_basic_block_connect (_tmp182_, _tmp183_);
						_tmp184_ = finally_block;
						_tmp185_ = _vala_basic_block_ref0 (_tmp184_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp185_;
					}
					_tmp186_ = self->priv->current_block;
					_tmp187_ = after_try_block;
					vala_basic_block_connect (_tmp186_, _tmp187_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
		_vala_iterable_unref0 (_jump_target_list);
	}
	_tmp188_ = finally_block;
	if (_tmp188_ != NULL) {
		ValaList* _tmp189_;
		ValaList* _tmp190_;
		gint _tmp191_;
		gint _tmp192_;
		gpointer _tmp193_;
		ValaFlowAnalyzerJumpTarget* _tmp194_;
		_tmp189_ = self->priv->jump_stack;
		_tmp190_ = self->priv->jump_stack;
		_tmp191_ = vala_collection_get_size ((ValaCollection*) _tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_list_remove_at (_tmp189_, _tmp192_ - 1);
		_tmp194_ = (ValaFlowAnalyzerJumpTarget*) _tmp193_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp194_);
	}
	_tmp195_ = after_try_block;
	_tmp196_ = vala_basic_block_get_predecessors (_tmp195_);
	_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
	_tmp198_ = _tmp197_;
	if (_tmp198_ > 0) {
		ValaBasicBlock* _tmp199_;
		ValaBasicBlock* _tmp200_;
		_tmp199_ = after_try_block;
		_tmp200_ = _vala_basic_block_ref0 (_tmp199_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp200_;
	} else {
		vala_try_statement_set_after_try_block_reachable (stmt, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}

static void
vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                              ValaLockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}

static void
vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                ValaUnlockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}

static void
vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                          ValaExpression* expr)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	if (!VALA_IS_LAMBDA_EXPRESSION (expr)) {
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
	}
}

static gboolean
vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                ValaCodeNode* node)
{
	ValaBasicBlock* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		vala_code_node_set_unreachable (node, TRUE);
		if (!self->priv->unreachable_reported) {
			ValaSourceReference* _tmp1_;
			ValaSourceReference* _tmp2_;
			_tmp1_ = vala_code_node_get_source_reference (node);
			_tmp2_ = _tmp1_;
			vala_report_warning (_tmp2_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self)
{
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}

static inline gpointer
vala_flow_analyzer_jump_target_get_instance_private (ValaFlowAnalyzerJumpTarget* self)
{
	return G_STRUCT_MEMBER_P (self, ValaFlowAnalyzerJumpTarget_private_offset);
}

static gboolean
vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_break_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_break_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_continue_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_continue_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_return_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_return_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_exit_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_exit_target = value;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_error_target;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_error_target = value;
}

static ValaErrorDomain*
vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaErrorDomain* value)
{
	ValaErrorDomain* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp0_;
}

static ValaErrorCode*
vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                               ValaErrorCode* value)
{
	ValaErrorCode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp0_;
}

static ValaClass*
vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp0_;
}

static gboolean
vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_finally_clause;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_finally_clause = value;
}

static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp0_;
}

static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                               ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp0_;
}

static ValaCatchClause*
vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self)
{
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}

static void
vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaCatchClause* value)
{
	ValaCatchClause* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp0_;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                       ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                          ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                        ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                      ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                       ValaBasicBlock* basic_block,
                                                       ValaCatchClause* catch_clause,
                                                       ValaErrorDomain* error_domain,
                                                       ValaErrorCode* error_code,
                                                       ValaClass* error_class)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_catch_clause (self, catch_clause);
	vala_flow_analyzer_jump_target_set_error_domain (self, error_domain);
	vala_flow_analyzer_jump_target_set_error_code (self, error_code);
	vala_flow_analyzer_jump_target_set_error_class (self, error_class);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                 ValaCatchClause* catch_clause,
                                                 ValaErrorDomain* error_domain,
                                                 ValaErrorCode* error_code,
                                                 ValaClass* error_class)
{
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                     ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                         ValaBasicBlock* basic_block,
                                                         ValaBasicBlock* last_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_last_block (self, last_block);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                   ValaBasicBlock* last_block)
{
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct (GType object_type)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}

static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new (void)
{
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}

static void
vala_flow_analyzer_value_jump_target_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_flow_analyzer_value_jump_target_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}

static void
vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_flow_analyzer_value_jump_target_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_flow_analyzer_value_get_jump_target (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}

static void
vala_flow_analyzer_value_set_jump_target (GValue* value,
                                          gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}

static void
vala_flow_analyzer_value_take_jump_target (GValue* value,
                                           gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}

static void
vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass,
                                           gpointer klass_data)
{
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzerJumpTarget_private_offset);
}

static void
vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self,
                                              gpointer klass)
{
	self->priv = vala_flow_analyzer_jump_target_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}

static GType
vala_flow_analyzer_jump_target_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_flow_analyzer_jump_target_type_id;
	vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaFlowAnalyzerJumpTarget_private_offset = g_type_add_instance_private (vala_flow_analyzer_jump_target_type_id, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
	return vala_flow_analyzer_jump_target_type_id;
}

static GType
vala_flow_analyzer_jump_target_get_type (void)
{
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = vala_flow_analyzer_jump_target_get_type_once ();
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}

static gpointer
vala_flow_analyzer_jump_target_ref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_flow_analyzer_jump_target_unref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass,
                               gpointer klass_data)
{
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaFlowAnalyzer_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor*, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor*, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor*, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor*, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor*, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor*, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor*, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor*, ValaLoop*)) vala_flow_analyzer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor*, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor*, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor*, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor*, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor*, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor*, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor*, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor*, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}

static void
vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_flow_analyzer_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}

static void
vala_flow_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_iterable_unref0 (self->priv->all_basic_blocks);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}

/**
 * Code visitor building the control flow graph.
 */
static GType
vala_flow_analyzer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
	GType vala_flow_analyzer_type_id;
	vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
	ValaFlowAnalyzer_private_offset = g_type_add_instance_private (vala_flow_analyzer_type_id, sizeof (ValaFlowAnalyzerPrivate));
	return vala_flow_analyzer_type_id;
}

GType
vala_flow_analyzer_get_type (void)
{
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = vala_flow_analyzer_get_type_once ();
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

