/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValaDataType* _tmp17_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp167_;
	GEqualFunc _tmp168_;
	GEqualFunc _tmp169_;
	ValaHashMap* _tmp170_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp171_;
	ValaHashMap* _tmp172_;
	gboolean _tmp173_ = FALSE;
	ValaMethod* _tmp174_;
	gboolean _tmp291_ = FALSE;
	ValaMethod* _tmp292_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp456_;
	ValaCCodeExpression* _tmp457_;
	gboolean _tmp458_ = FALSE;
	ValaMethod* _tmp459_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp487_ = FALSE;
	ValaMethod* _tmp488_;
	gboolean _tmp640_ = FALSE;
	ValaMethod* _tmp641_;
	ValaMethod* _tmp691_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp879_;
	ValaIterator* _tmp880_;
	ValaIterator* _tmp1299_;
	gboolean _tmp1309_ = FALSE;
	gboolean _tmp1310_ = FALSE;
	ValaMethod* _tmp1311_;
	gboolean _tmp1431_ = FALSE;
	ValaDelegate* _tmp1432_;
	gboolean _tmp1527_ = FALSE;
	ValaMethod* _tmp1528_;
	gboolean _tmp1544_;
	gboolean _tmp1545_;
	ValaDataType* _tmp1588_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1612_;
	ValaDataType* _tmp1613_;
	gboolean _tmp1614_ = FALSE;
	ValaDataType* _tmp1615_;
	ValaCCodeFunctionCall* _tmp1643_;
	ValaCCodeFunctionCall* _tmp1644_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1657_;
	ValaCCodeFunctionCall* _tmp1658_;
	ValaCCodeFunctionCall* _tmp1673_;
	gboolean _tmp1688_;
	gboolean _tmp1689_;
	gboolean _tmp1713_;
	gboolean _tmp1714_;
	gboolean _tmp1749_ = FALSE;
	gboolean _tmp1750_ = FALSE;
	ValaMethod* _tmp1751_;
	gboolean _tmp1789_ = FALSE;
	gboolean _tmp1790_ = FALSE;
	gboolean _tmp1791_ = FALSE;
	gboolean _tmp1792_ = FALSE;
	gboolean _tmp1793_ = FALSE;
	ValaMethod* _tmp1794_;
	gboolean _tmp1811_ = FALSE;
	gboolean _tmp1812_ = FALSE;
	ValaMethod* _tmp1813_;
	ValaMethod* _tmp1832_;
	gboolean _tmp1947_ = FALSE;
	ValaCodeNode* _tmp1948_;
	ValaCodeNode* _tmp1949_;
	ValaList* _tmp2049_;
	ValaIterator* _tmp2050_;
	gboolean _tmp2144_ = FALSE;
	gboolean _tmp2145_ = FALSE;
	ValaMethod* _tmp2146_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_tmp16_ = _vala_iterable_ref0 (_tmp15_);
	_vala_iterable_unref0 (params);
	params = _tmp16_;
	_tmp17_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp18_;
		ValaDataType* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		ValaMethod* _tmp23_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaMemberAccess* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		_tmp18_ = ma;
		_vala_assert (_tmp18_ != NULL, "ma != null");
		_tmp19_ = itype;
		_tmp20_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		_vala_code_node_unref0 (m);
		m = _tmp22_;
		_tmp23_ = m;
		if (!vala_get_ccode_simple_generics (_tmp23_)) {
			ValaCodeContext* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaSemanticAnalyzer* _tmp26_;
			ValaSemanticAnalyzer* _tmp27_;
			ValaMemberAccess* _tmp28_;
			_tmp24_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp27_, _tmp28_);
		}
		_tmp31_ = ma;
		_tmp32_ = vala_member_access_get_inner (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ != NULL) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp30_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaMemberAccess* _tmp39_;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			ValaDataType* _tmp42_;
			ValaDataType* _tmp43_;
			ValaMethod* _tmp44_;
			ValaMethod* _tmp45_;
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_inner (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_expression_get_value_type (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp45_ = m;
			_tmp29_ = _tmp44_ == _tmp45_;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp46_;
			ValaExpression* _tmp47_;
			ValaExpression* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			ValaTypeSymbol* _tmp51_;
			ValaTypeSymbol* _tmp52_;
			ValaCCodeFunctionCall* _tmp53_;
			ValaEnum* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaCCodeIdentifier* _tmp57_;
			ValaCCodeIdentifier* _tmp58_;
			_tmp46_ = ma;
			_tmp47_ = vala_member_access_get_inner (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_expression_get_value_type (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
			_tmp52_ = _tmp51_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_ENUM, ValaEnum);
			_tmp53_ = ccall;
			_tmp54_ = en;
			_tmp55_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_identifier_new (_tmp56_);
			_tmp58_ = _tmp57_;
			vala_ccode_function_call_set_call (_tmp53_, (ValaCCodeExpression*) _tmp58_);
			_vala_ccode_node_unref0 (_tmp58_);
			_g_free0 (_tmp56_);
		} else {
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			gboolean _tmp61_ = FALSE;
			gboolean _tmp62_ = FALSE;
			ValaCodeContext* _tmp63_;
			ValaCodeContext* _tmp64_;
			ValaProfile _tmp65_;
			ValaProfile _tmp66_;
			_tmp63_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_code_context_get_profile (_tmp64_);
			_tmp66_ = _tmp65_;
			if (_tmp66_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp62_ = _tmp69_ != NULL;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				ValaDataType* _tmp73_;
				ValaDataType* _tmp74_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_expression_get_value_type (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp61_ = _tmp74_ != NULL;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaMemberAccess* _tmp75_;
				ValaExpression* _tmp76_;
				ValaExpression* _tmp77_;
				ValaDataType* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaDataType* _tmp82_;
				ValaTypeSymbol* _tmp83_;
				ValaTypeSymbol* _tmp84_;
				_tmp75_ = ma;
				_tmp76_ = vala_member_access_get_inner (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_get_value_type (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_data_type_get_type_symbol (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp83_ = vala_data_type_get_type_symbol (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp60_ = _tmp81_ == _tmp84_;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp85_;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
				_tmp85_ = ma;
				_tmp86_ = vala_member_access_get_member_name (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp59_ = g_strcmp0 (_tmp87_, "printf") == 0;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaCCodeFunctionCall* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				ValaCCodeIdentifier* _tmp91_;
				ValaCCodeIdentifier* _tmp92_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_ccode_identifier_new (_tmp90_);
				_tmp92_ = _tmp91_;
				vala_ccode_function_call_set_call (_tmp88_, (ValaCCodeExpression*) _tmp92_);
				_vala_ccode_node_unref0 (_tmp92_);
				_g_free0 (_tmp90_);
			} else {
				gboolean _tmp93_;
				gboolean _tmp94_;
				_tmp93_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp94_ = _tmp93_;
				if (_tmp94_) {
					ValaCCodeFunctionCall* _tmp95_;
					ValaMethod* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					ValaCCodeIdentifier* _tmp99_;
					ValaCCodeIdentifier* _tmp100_;
					_tmp95_ = ccall;
					_tmp96_ = m;
					_tmp97_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_ccode_identifier_new (_tmp98_);
					_tmp100_ = _tmp99_;
					vala_ccode_function_call_set_call (_tmp95_, (ValaCCodeExpression*) _tmp100_);
					_vala_ccode_node_unref0 (_tmp100_);
					_g_free0 (_tmp98_);
				}
			}
		}
	} else {
		ValaDataType* _tmp101_;
		_tmp101_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp102_;
			ValaSignalType* _tmp103_;
			gboolean _tmp104_ = FALSE;
			gboolean _tmp105_ = FALSE;
			ValaMemberAccess* _tmp106_;
			_tmp102_ = itype;
			_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp103_;
			_tmp106_ = ma;
			if (_tmp106_ != NULL) {
				ValaMemberAccess* _tmp107_;
				ValaExpression* _tmp108_;
				ValaExpression* _tmp109_;
				_tmp107_ = ma;
				_tmp108_ = vala_member_access_get_inner (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp105_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp105_ = FALSE;
			}
			if (_tmp105_) {
				ValaSignalType* _tmp110_;
				ValaSignal* _tmp111_;
				ValaSignal* _tmp112_;
				gboolean _tmp113_;
				gboolean _tmp114_;
				_tmp110_ = sig_type;
				_tmp111_ = vala_signal_type_get_signal_symbol (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_signal_get_is_virtual (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp104_ = _tmp114_;
			} else {
				_tmp104_ = FALSE;
			}
			if (_tmp104_) {
				ValaSignalType* _tmp115_;
				ValaSignal* _tmp116_;
				ValaSignal* _tmp117_;
				ValaMethod* _tmp118_;
				ValaMethod* _tmp119_;
				ValaMethod* _tmp120_;
				_tmp115_ = sig_type;
				_tmp116_ = vala_signal_type_get_signal_symbol (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_signal_get_default_handler (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = _vala_code_node_ref0 (_tmp119_);
				_vala_code_node_unref0 (m);
				m = _tmp120_;
			} else {
				ValaExpression* _tmp121_;
				ValaExpression* _tmp122_;
				ValaCCodeExpression* _tmp123_;
				_tmp121_ = vala_method_call_get_call (expr);
				_tmp122_ = _tmp121_;
				_tmp123_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp122_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp124_;
			_tmp124_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp124_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaTypeSymbol* _tmp127_;
				ValaClass* _tmp128_;
				ValaClass* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaCreationMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaMethod* _tmp133_;
				ValaCCodeFile* _tmp134_;
				gchar* real_name = NULL;
				ValaMethod* _tmp135_;
				gchar* _tmp136_;
				gboolean _tmp137_;
				gboolean _tmp138_;
				const gchar* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeIdentifier* _tmp143_;
				ValaCCodeFunctionCall* _tmp144_;
				_tmp125_ = itype;
				_tmp126_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp127_ = _tmp126_;
				_tmp128_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp128_;
				_tmp129_ = cl;
				_tmp130_ = vala_class_get_default_construction_method (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = _vala_code_node_ref0 ((ValaMethod*) _tmp131_);
				_vala_code_node_unref0 (m);
				m = _tmp132_;
				_tmp133_ = m;
				_tmp134_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp133_, _tmp134_);
				_tmp135_ = m;
				_tmp136_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp135_);
				real_name = _tmp136_;
				_tmp137_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp138_ = _tmp137_;
				if (_tmp138_) {
					ValaMethod* _tmp139_;
					gchar* _tmp140_;
					_tmp139_ = m;
					_tmp140_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp140_;
				}
				_tmp141_ = real_name;
				_tmp142_ = vala_ccode_identifier_new (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp143_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp144_;
				_vala_ccode_node_unref0 (_tmp143_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp145_;
				_tmp145_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaTypeSymbol* _tmp148_;
					ValaStruct* _tmp149_;
					ValaStruct* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaCreationMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaMethod* _tmp154_;
					ValaCCodeFile* _tmp155_;
					ValaMethod* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeIdentifier* _tmp160_;
					ValaCCodeFunctionCall* _tmp161_;
					_tmp146_ = itype;
					_tmp147_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp149_;
					_tmp150_ = st;
					_tmp151_ = vala_struct_get_default_construction_method (_tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = _vala_code_node_ref0 ((ValaMethod*) _tmp152_);
					_vala_code_node_unref0 (m);
					m = _tmp153_;
					_tmp154_ = m;
					_tmp155_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp154_, _tmp155_);
					_tmp156_ = m;
					_tmp157_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_ccode_identifier_new (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp160_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp161_;
					_vala_ccode_node_unref0 (_tmp160_);
					_g_free0 (_tmp158_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp162_;
					_tmp162_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						ValaDelegate* _tmp166_;
						_tmp163_ = itype;
						_tmp164_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp165_ = _tmp164_;
						_tmp166_ = _vala_code_node_ref0 (_tmp165_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp166_;
					}
				}
			}
		}
	}
	_tmp167_ = g_direct_hash;
	_tmp168_ = g_direct_equal;
	_tmp169_ = g_direct_equal;
	_tmp170_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp167_, _tmp168_, _tmp169_);
	in_arg_map = _tmp170_;
	_tmp171_ = in_arg_map;
	_tmp172_ = _vala_map_ref0 (_tmp171_);
	out_arg_map = _tmp172_;
	_tmp174_ = m;
	if (_tmp174_ != NULL) {
		ValaMethod* _tmp175_;
		gboolean _tmp176_;
		gboolean _tmp177_;
		_tmp175_ = m;
		_tmp176_ = vala_method_get_coroutine (_tmp175_);
		_tmp177_ = _tmp176_;
		_tmp173_ = _tmp177_;
	} else {
		_tmp173_ = FALSE;
	}
	if (_tmp173_) {
		ValaMethod* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeIdentifier* _tmp182_;
		ValaCCodeFunctionCall* _tmp183_;
		ValaMethod* _tmp184_;
		gchar* _tmp185_;
		gchar* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeIdentifier* _tmp188_;
		ValaCCodeFunctionCall* _tmp189_;
		ValaMemberAccess* _tmp190_;
		ValaExpression* _tmp191_;
		ValaExpression* _tmp192_;
		gboolean _tmp241_ = FALSE;
		ValaMemberAccess* _tmp242_;
		const gchar* _tmp243_;
		const gchar* _tmp244_;
		_tmp178_ = m;
		_tmp179_ = vala_get_ccode_name ((ValaCodeNode*) _tmp178_);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_ccode_identifier_new (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp182_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp183_;
		_vala_ccode_node_unref0 (_tmp182_);
		_g_free0 (_tmp180_);
		_tmp184_ = m;
		_tmp185_ = vala_get_ccode_finish_name (_tmp184_);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_ccode_identifier_new (_tmp186_);
		_tmp188_ = _tmp187_;
		_tmp189_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp188_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp189_;
		_vala_ccode_node_unref0 (_tmp188_);
		_g_free0 (_tmp186_);
		_tmp190_ = ma;
		_tmp191_ = vala_member_access_get_inner (_tmp190_);
		_tmp192_ = _tmp191_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaMethod* _tmp195_;
			ValaCCodeExpression* _tmp226_;
			vcast = NULL;
			_tmp193_ = m;
			_tmp194_ = vala_method_get_base_method (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaSymbol* _tmp200_;
				ValaClass* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeIdentifier* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaCCodeExpression* _tmp207_;
				ValaClass* _tmp208_;
				ValaClass* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeIdentifier* _tmp215_;
				_tmp196_ = m;
				_tmp197_ = vala_method_get_base_method (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp198_);
				_tmp200_ = _tmp199_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_CLASS, ValaClass);
				_tmp201_ = base_class;
				_tmp202_ = vala_get_ccode_class_type_function (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_identifier_new (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp205_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp206_;
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp203_);
				_tmp207_ = vcast;
				_tmp208_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp209_ = _tmp208_;
				_tmp210_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp209_, NULL);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strdup_printf ("%s_parent_class", _tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_ccode_identifier_new (_tmp213_);
				_tmp215_ = _tmp214_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp215_);
				_vala_ccode_node_unref0 (_tmp215_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
			} else {
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				ValaMethod* _tmp218_;
				_tmp216_ = m;
				_tmp217_ = vala_method_get_base_interface_method (_tmp216_);
				_tmp218_ = _tmp217_;
				if (_tmp218_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaMethod* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaSymbol* _tmp223_;
					ValaInterface* _tmp224_;
					ValaCCodeExpression* _tmp225_;
					_tmp219_ = m;
					_tmp220_ = vala_method_get_base_interface_method (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp221_);
					_tmp223_ = _tmp222_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp224_ = base_iface;
					_tmp225_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp224_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp225_;
				}
			}
			_tmp226_ = vcast;
			if (_tmp226_ != NULL) {
				ValaCCodeFunctionCall* _tmp227_;
				ValaCCodeExpression* _tmp228_;
				ValaMethod* _tmp229_;
				gchar* _tmp230_;
				gchar* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeMemberAccess* _tmp233_;
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeExpression* _tmp235_;
				ValaMethod* _tmp236_;
				gchar* _tmp237_;
				gchar* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				ValaCCodeMemberAccess* _tmp240_;
				_tmp227_ = async_call;
				_tmp228_ = vcast;
				_tmp229_ = m;
				_tmp230_ = vala_get_ccode_vfunc_name (_tmp229_);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_ccode_member_access_new_pointer (_tmp228_, _tmp231_);
				_tmp233_ = _tmp232_;
				vala_ccode_function_call_set_call (_tmp227_, (ValaCCodeExpression*) _tmp233_);
				_vala_ccode_node_unref0 (_tmp233_);
				_g_free0 (_tmp231_);
				_tmp234_ = finish_call;
				_tmp235_ = vcast;
				_tmp236_ = m;
				_tmp237_ = vala_get_ccode_finish_vfunc_name (_tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_ccode_member_access_new_pointer (_tmp235_, _tmp238_);
				_tmp240_ = _tmp239_;
				vala_ccode_function_call_set_call (_tmp234_, (ValaCCodeExpression*) _tmp240_);
				_vala_ccode_node_unref0 (_tmp240_);
				_g_free0 (_tmp238_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp242_ = ma;
		_tmp243_ = vala_member_access_get_member_name (_tmp242_);
		_tmp244_ = _tmp243_;
		if (g_strcmp0 (_tmp244_, "begin") == 0) {
			ValaMemberAccess* _tmp245_;
			ValaExpression* _tmp246_;
			ValaExpression* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaSymbol* _tmp249_;
			ValaMemberAccess* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			_tmp245_ = ma;
			_tmp246_ = vala_member_access_get_inner (_tmp245_);
			_tmp247_ = _tmp246_;
			_tmp248_ = vala_expression_get_symbol_reference (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp250_ = ma;
			_tmp251_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp250_);
			_tmp252_ = _tmp251_;
			_tmp241_ = _tmp249_ == _tmp252_;
		} else {
			_tmp241_ = FALSE;
		}
		if (_tmp241_) {
			ValaCCodeFunctionCall* _tmp253_;
			ValaCCodeFunctionCall* _tmp254_;
			ValaMethod* _tmp255_;
			ValaList* _tmp256_;
			_tmp253_ = async_call;
			_tmp254_ = _vala_ccode_node_ref0 (_tmp253_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp254_;
			_tmp255_ = m;
			_tmp256_ = vala_method_get_async_begin_parameters (_tmp255_);
			_vala_iterable_unref0 (params);
			params = _tmp256_;
		} else {
			gboolean _tmp257_ = FALSE;
			ValaMemberAccess* _tmp258_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			_tmp258_ = ma;
			_tmp259_ = vala_member_access_get_member_name (_tmp258_);
			_tmp260_ = _tmp259_;
			if (g_strcmp0 (_tmp260_, "end") == 0) {
				ValaMemberAccess* _tmp261_;
				ValaExpression* _tmp262_;
				ValaExpression* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				ValaMemberAccess* _tmp266_;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				_tmp261_ = ma;
				_tmp262_ = vala_member_access_get_inner (_tmp261_);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = ma;
				_tmp267_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp266_);
				_tmp268_ = _tmp267_;
				_tmp257_ = _tmp265_ == _tmp268_;
			} else {
				_tmp257_ = FALSE;
			}
			if (_tmp257_) {
				ValaCCodeFunctionCall* _tmp269_;
				ValaCCodeFunctionCall* _tmp270_;
				ValaMethod* _tmp271_;
				ValaList* _tmp272_;
				_tmp269_ = finish_call;
				_tmp270_ = _vala_ccode_node_ref0 (_tmp269_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp270_;
				_tmp271_ = m;
				_tmp272_ = vala_method_get_async_end_parameters (_tmp271_);
				_vala_iterable_unref0 (params);
				params = _tmp272_;
			} else {
				gboolean _tmp273_;
				gboolean _tmp274_;
				_tmp273_ = vala_method_call_get_is_yield_expression (expr);
				_tmp274_ = _tmp273_;
				if (!_tmp274_) {
					ValaCCodeFunctionCall* _tmp275_;
					ValaCCodeFunctionCall* _tmp276_;
					ValaMethod* _tmp277_;
					ValaList* _tmp278_;
					_tmp275_ = async_call;
					_tmp276_ = _vala_ccode_node_ref0 (_tmp275_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp276_;
					_tmp277_ = m;
					_tmp278_ = vala_method_get_async_begin_parameters (_tmp277_);
					_vala_iterable_unref0 (params);
					params = _tmp278_;
				} else {
					ValaCCodeFunctionCall* _tmp279_;
					ValaCCodeFunctionCall* _tmp280_;
					GHashFunc _tmp281_;
					GEqualFunc _tmp282_;
					GEqualFunc _tmp283_;
					ValaHashMap* _tmp284_;
					ValaHashMap* _tmp285_;
					ValaMethod* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeIdentifier* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					ValaCCodeMemberAccess* _tmp290_;
					_tmp279_ = finish_call;
					_tmp280_ = _vala_ccode_node_ref0 (_tmp279_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp280_;
					_tmp281_ = g_direct_hash;
					_tmp282_ = g_direct_equal;
					_tmp283_ = g_direct_equal;
					_tmp284_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp281_, _tmp282_, _tmp283_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp284_;
					_tmp285_ = out_arg_map;
					_tmp286_ = m;
					_tmp287_ = vala_ccode_identifier_new ("_data_");
					_tmp288_ = _tmp287_;
					_tmp289_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp288_, "_res_");
					_tmp290_ = _tmp289_;
					vala_map_set ((ValaMap*) _tmp285_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp286_), FALSE)), (ValaCCodeExpression*) _tmp290_);
					_vala_ccode_node_unref0 (_tmp290_);
					_vala_ccode_node_unref0 (_tmp288_);
				}
			}
		}
	}
	_tmp292_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp293_;
		ValaSymbol* _tmp294_;
		ValaSymbol* _tmp295_;
		_tmp293_ = m;
		_tmp294_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp293_);
		_tmp295_ = _tmp294_;
		_tmp291_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp295_, VALA_TYPE_CLASS);
	} else {
		_tmp291_ = FALSE;
	}
	if (_tmp291_) {
		ValaCodeContext* _tmp296_;
		ValaCodeContext* _tmp297_;
		ValaProfile _tmp298_;
		ValaProfile _tmp299_;
		ValaClass* _tmp311_;
		ValaClass* _tmp312_;
		gboolean _tmp313_;
		gboolean _tmp314_;
		_tmp296_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp297_ = _tmp296_;
		_tmp298_ = vala_code_context_get_profile (_tmp297_);
		_tmp299_ = _tmp298_;
		if (_tmp299_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp300_;
			ValaSymbol* _tmp301_;
			ValaSymbol* _tmp302_;
			gboolean _tmp303_;
			gboolean _tmp304_;
			_tmp300_ = m;
			_tmp301_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp300_);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_CLASS, ValaClass));
			_tmp304_ = _tmp303_;
			if (!_tmp304_) {
				ValaCCodeFunctionCall* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				ValaCCodeExpression* _tmp307_;
				_tmp305_ = ccall;
				_tmp306_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp307_ = _tmp306_;
				vala_ccode_function_call_add_argument (_tmp305_, _tmp307_);
				_vala_ccode_node_unref0 (_tmp307_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			ValaCCodeExpression* _tmp310_;
			_tmp308_ = ccall;
			_tmp309_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp310_ = _tmp309_;
			vala_ccode_function_call_add_argument (_tmp308_, _tmp310_);
			_vala_ccode_node_unref0 (_tmp310_);
		}
		_tmp311_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp312_ = _tmp311_;
		_tmp313_ = vala_class_get_is_compact (_tmp312_);
		_tmp314_ = _tmp313_;
		if (!_tmp314_) {
			ValaClass* _tmp315_;
			ValaClass* _tmp316_;
			ValaMethod* _tmp317_;
			ValaSymbol* _tmp318_;
			ValaSymbol* _tmp319_;
			_tmp315_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp316_ = _tmp315_;
			_tmp317_ = m;
			_tmp318_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp317_);
			_tmp319_ = _tmp318_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp316_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp319_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp320_;
					ValaClass* _tmp321_;
					ValaList* _tmp322_;
					ValaList* _tmp323_;
					gint _base_type_size = 0;
					ValaList* _tmp324_;
					gint _tmp325_;
					gint _tmp326_;
					gint _base_type_index = 0;
					_tmp320_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp321_ = _tmp320_;
					_tmp322_ = vala_class_get_base_types (_tmp321_);
					_tmp323_ = _vala_iterable_ref0 (_tmp322_);
					_base_type_list = _tmp323_;
					_tmp324_ = _base_type_list;
					_tmp325_ = vala_collection_get_size ((ValaCollection*) _tmp324_);
					_tmp326_ = _tmp325_;
					_base_type_size = _tmp326_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp327_;
						gpointer _tmp328_;
						ValaDataType* _tmp329_;
						ValaTypeSymbol* _tmp330_;
						ValaTypeSymbol* _tmp331_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp327_ = _base_type_list;
						_tmp328_ = vala_list_get (_tmp327_, _base_type_index);
						base_type = (ValaDataType*) _tmp328_;
						_tmp329_ = base_type;
						_tmp330_ = vala_data_type_get_type_symbol (_tmp329_);
						_tmp331_ = _tmp330_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp331_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp332_;
							gchar* _tmp333_;
							gchar* _tmp334_;
							gboolean _tmp335_;
							ValaHashMap* _tmp341_;
							ValaDataType* _tmp342_;
							ValaList* _tmp343_;
							ValaList* _tmp344_;
							type_parameters = NULL;
							_tmp332_ = m;
							_tmp333_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp332_);
							_tmp334_ = _tmp333_;
							_tmp335_ = g_strcmp0 (_tmp334_, "g_object_new") == 0;
							_g_free0 (_tmp334_);
							if (_tmp335_) {
								ValaDataType* _tmp336_;
								ValaTypeSymbol* _tmp337_;
								ValaTypeSymbol* _tmp338_;
								ValaList* _tmp339_;
								ValaList* _tmp340_;
								_tmp336_ = base_type;
								_tmp337_ = vala_data_type_get_type_symbol (_tmp336_);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, VALA_TYPE_CLASS, ValaClass));
								_tmp340_ = _vala_iterable_ref0 (_tmp339_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp340_;
							}
							_tmp341_ = in_arg_map;
							_tmp342_ = base_type;
							_tmp343_ = vala_data_type_get_type_arguments (_tmp342_);
							_tmp344_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp341_, _tmp343_, (ValaCodeNode*) expr, TRUE, _tmp344_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaClass* _tmp348_;
				type_param_index = 0;
				_tmp345_ = m;
				_tmp346_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp348_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp349_;
					ValaList* _tmp350_;
					ValaList* _tmp351_;
					gint _type_param_size = 0;
					ValaList* _tmp352_;
					gint _tmp353_;
					gint _tmp354_;
					gint _type_param_index = 0;
					_tmp349_ = cl;
					_tmp350_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp349_);
					_tmp351_ = _vala_iterable_ref0 (_tmp350_);
					_type_param_list = _tmp351_;
					_tmp352_ = _type_param_list;
					_tmp353_ = vala_collection_get_size ((ValaCollection*) _tmp352_);
					_tmp354_ = _tmp353_;
					_type_param_size = _tmp354_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp355_;
						gpointer _tmp356_;
						ValaHashMap* _tmp357_;
						ValaTypeParameter* _tmp358_;
						const gchar* _tmp359_;
						const gchar* _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						gchar* _tmp363_;
						gchar* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaCCodeIdentifier* _tmp366_;
						ValaHashMap* _tmp367_;
						ValaTypeParameter* _tmp368_;
						const gchar* _tmp369_;
						const gchar* _tmp370_;
						gchar* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						gchar* _tmp374_;
						ValaCCodeIdentifier* _tmp375_;
						ValaCCodeIdentifier* _tmp376_;
						ValaHashMap* _tmp377_;
						ValaTypeParameter* _tmp378_;
						const gchar* _tmp379_;
						const gchar* _tmp380_;
						gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						ValaCCodeIdentifier* _tmp385_;
						ValaCCodeIdentifier* _tmp386_;
						gint _tmp387_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp355_ = _type_param_list;
						_tmp356_ = vala_list_get (_tmp355_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp356_;
						_tmp357_ = in_arg_map;
						_tmp358_ = type_param;
						_tmp359_ = vala_symbol_get_name ((ValaSymbol*) _tmp358_);
						_tmp360_ = _tmp359_;
						_tmp361_ = g_utf8_strdown (_tmp360_, (gssize) -1);
						_tmp362_ = _tmp361_;
						_tmp363_ = g_strdup_printf ("%s_type", _tmp362_);
						_tmp364_ = _tmp363_;
						_tmp365_ = vala_ccode_identifier_new (_tmp364_);
						_tmp366_ = _tmp365_;
						vala_map_set ((ValaMap*) _tmp357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp366_);
						_vala_ccode_node_unref0 (_tmp366_);
						_g_free0 (_tmp364_);
						_g_free0 (_tmp362_);
						_tmp367_ = in_arg_map;
						_tmp368_ = type_param;
						_tmp369_ = vala_symbol_get_name ((ValaSymbol*) _tmp368_);
						_tmp370_ = _tmp369_;
						_tmp371_ = g_utf8_strdown (_tmp370_, (gssize) -1);
						_tmp372_ = _tmp371_;
						_tmp373_ = g_strdup_printf ("%s_dup_func", _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = vala_ccode_identifier_new (_tmp374_);
						_tmp376_ = _tmp375_;
						vala_map_set ((ValaMap*) _tmp367_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp376_);
						_vala_ccode_node_unref0 (_tmp376_);
						_g_free0 (_tmp374_);
						_g_free0 (_tmp372_);
						_tmp377_ = in_arg_map;
						_tmp378_ = type_param;
						_tmp379_ = vala_symbol_get_name ((ValaSymbol*) _tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = g_utf8_strdown (_tmp380_, (gssize) -1);
						_tmp382_ = _tmp381_;
						_tmp383_ = g_strdup_printf ("%s_destroy_func", _tmp382_);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_ccode_identifier_new (_tmp384_);
						_tmp386_ = _tmp385_;
						vala_map_set ((ValaMap*) _tmp377_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp386_);
						_vala_ccode_node_unref0 (_tmp386_);
						_g_free0 (_tmp384_);
						_g_free0 (_tmp382_);
						_tmp387_ = type_param_index;
						type_param_index = _tmp387_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp388_;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaClass* _tmp391_;
			ValaClass* _tmp392_;
			_tmp388_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp389_ = _tmp388_;
			_tmp390_ = vala_class_get_base_class (_tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp391_ == _tmp392_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp393_;
				ValaClass* _tmp394_;
				gchar* _tmp395_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp396_;
				ValaCCodeDeclaration* _tmp397_;
				ValaCCodeDeclaration* _tmp398_;
				const gchar* _tmp399_;
				const gchar* _tmp400_;
				const gchar* _tmp401_;
				const gchar* _tmp402_;
				gchar* _tmp403_;
				gchar* _tmp404_;
				ValaCCodeConstant* _tmp405_;
				ValaCCodeConstant* _tmp406_;
				ValaCCodeVariableDeclarator* _tmp407_;
				ValaCCodeVariableDeclarator* _tmp408_;
				ValaCCodeFunction* _tmp409_;
				ValaCCodeFunction* _tmp410_;
				ValaCCodeDeclaration* _tmp411_;
				ValaCCodeFunctionCall* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeUnaryExpression* _tmp415_;
				ValaCCodeUnaryExpression* _tmp416_;
				ValaCCodeCastExpression* _tmp417_;
				ValaCCodeCastExpression* _tmp418_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				ValaCCodeFunctionCall* _tmp423_;
				ValaClass* _tmp424_;
				ValaClass* _tmp425_;
				gchar* _tmp426_;
				gchar* _tmp427_;
				ValaCCodeIdentifier* _tmp428_;
				ValaCCodeIdentifier* _tmp429_;
				ValaCCodeFunctionCall* _tmp430_;
				ValaCCodeFunctionCall* _tmp431_;
				_tmp393_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp394_, NULL);
				class_prefix = _tmp395_;
				_tmp396_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp396_;
				_tmp397_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp397_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp398_ = funcs;
				_tmp399_ = class_prefix;
				_tmp400_ = class_prefix;
				_tmp401_ = class_prefix;
				_tmp402_ = class_prefix;
				_tmp403_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp399_, _tmp400_, _tmp401_, _tmp402_);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_ccode_constant_new (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp406_, NULL);
				_tmp408_ = _tmp407_;
				vala_ccode_declaration_add_declarator (_tmp398_, (ValaCCodeDeclarator*) _tmp408_);
				_vala_ccode_node_unref0 (_tmp408_);
				_vala_ccode_node_unref0 (_tmp406_);
				_g_free0 (_tmp404_);
				_tmp409_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp410_ = _tmp409_;
				_tmp411_ = funcs;
				vala_ccode_function_add_statement (_tmp410_, (ValaCCodeNode*) _tmp411_);
				_tmp412_ = ccall;
				_tmp413_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp416_, "GSourceFuncs *");
				_tmp418_ = _tmp417_;
				vala_ccode_function_call_add_argument (_tmp412_, (ValaCCodeExpression*) _tmp418_);
				_vala_ccode_node_unref0 (_tmp418_);
				_vala_ccode_node_unref0 (_tmp416_);
				_vala_ccode_node_unref0 (_tmp414_);
				_tmp419_ = vala_ccode_identifier_new ("sizeof");
				_tmp420_ = _tmp419_;
				_tmp421_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp420_);
				_tmp422_ = _tmp421_;
				_vala_ccode_node_unref0 (_tmp420_);
				csizeof = _tmp422_;
				_tmp423_ = csizeof;
				_tmp424_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp425_ = _tmp424_;
				_tmp426_ = vala_get_ccode_name ((ValaCodeNode*) _tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = vala_ccode_identifier_new (_tmp427_);
				_tmp429_ = _tmp428_;
				vala_ccode_function_call_add_argument (_tmp423_, (ValaCCodeExpression*) _tmp429_);
				_vala_ccode_node_unref0 (_tmp429_);
				_g_free0 (_tmp427_);
				_tmp430_ = ccall;
				_tmp431_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp430_, (ValaCCodeExpression*) _tmp431_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp432_ = FALSE;
		ValaMethod* _tmp433_;
		_tmp433_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp433_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp434_;
			ValaSymbol* _tmp435_;
			ValaSymbol* _tmp436_;
			_tmp434_ = m;
			_tmp435_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp434_);
			_tmp436_ = _tmp435_;
			_tmp432_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_STRUCT);
		} else {
			_tmp432_ = FALSE;
		}
		if (_tmp432_) {
			ValaCCodeFunctionCall* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			ValaCCodeExpression* _tmp439_;
			_tmp437_ = ccall;
			_tmp438_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp439_ = _tmp438_;
			vala_ccode_function_call_add_argument (_tmp437_, _tmp439_);
			_vala_ccode_node_unref0 (_tmp439_);
		} else {
			gboolean _tmp440_ = FALSE;
			gboolean _tmp441_ = FALSE;
			gboolean _tmp442_ = FALSE;
			gboolean _tmp443_ = FALSE;
			ValaMethod* _tmp444_;
			_tmp444_ = m;
			if (_tmp444_ != NULL) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp443_ = vala_method_has_type_parameters (_tmp445_);
			} else {
				_tmp443_ = FALSE;
			}
			if (_tmp443_) {
				ValaMethod* _tmp446_;
				_tmp446_ = m;
				_tmp442_ = !vala_get_ccode_has_generic_type_parameter (_tmp446_);
			} else {
				_tmp442_ = FALSE;
			}
			if (_tmp442_) {
				ValaMethod* _tmp447_;
				_tmp447_ = m;
				_tmp441_ = !vala_get_ccode_simple_generics (_tmp447_);
			} else {
				_tmp441_ = FALSE;
			}
			if (_tmp441_) {
				gboolean _tmp448_ = FALSE;
				ValaCCodeFunctionCall* _tmp449_;
				ValaCCodeFunctionCall* _tmp450_;
				_tmp449_ = ccall;
				_tmp450_ = finish_call;
				if (_tmp449_ != _tmp450_) {
					_tmp448_ = TRUE;
				} else {
					gboolean _tmp451_;
					gboolean _tmp452_;
					_tmp451_ = vala_method_call_get_is_yield_expression (expr);
					_tmp452_ = _tmp451_;
					_tmp448_ = _tmp452_;
				}
				_tmp440_ = _tmp448_;
			} else {
				_tmp440_ = FALSE;
			}
			if (_tmp440_) {
				ValaHashMap* _tmp453_;
				ValaMemberAccess* _tmp454_;
				ValaList* _tmp455_;
				_tmp453_ = in_arg_map;
				_tmp454_ = ma;
				_tmp455_ = vala_member_access_get_type_arguments (_tmp454_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp453_, _tmp455_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp456_ = ccall;
	_tmp457_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp456_);
	ccall_expr = _tmp457_;
	_tmp459_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp460_;
		ValaCodeContext* _tmp461_;
		ValaProfile _tmp462_;
		ValaProfile _tmp463_;
		_tmp460_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp461_ = _tmp460_;
		_tmp462_ = vala_code_context_get_profile (_tmp461_);
		_tmp463_ = _tmp462_;
		_tmp458_ = _tmp463_ != VALA_PROFILE_POSIX;
	} else {
		_tmp458_ = FALSE;
	}
	if (_tmp458_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp464_;
		ValaExpression* _tmp465_;
		ValaExpression* _tmp466_;
		ValaDataType* _tmp467_;
		ValaDataType* _tmp468_;
		ValaArrayType* _tmp469_;
		ValaHashMap* _tmp470_;
		ValaArrayType* _tmp471_;
		ValaDataType* _tmp472_;
		ValaDataType* _tmp473_;
		gchar* _tmp474_;
		gchar* _tmp475_;
		ValaCCodeIdentifier* _tmp476_;
		ValaCCodeIdentifier* _tmp477_;
		_tmp464_ = ma;
		_tmp465_ = vala_member_access_get_inner (_tmp464_);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_expression_get_value_type (_tmp466_);
		_tmp468_ = _tmp467_;
		_tmp469_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp469_;
		_tmp470_ = in_arg_map;
		_tmp471_ = array_type;
		_tmp472_ = vala_array_type_get_element_type (_tmp471_);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_get_ccode_name ((ValaCodeNode*) _tmp473_);
		_tmp475_ = _tmp474_;
		_tmp476_ = vala_ccode_identifier_new (_tmp475_);
		_tmp477_ = _tmp476_;
		vala_map_set ((ValaMap*) _tmp470_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp477_);
		_vala_ccode_node_unref0 (_tmp477_);
		_g_free0 (_tmp475_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp478_;
		_tmp478_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp479_;
			_tmp479_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp479_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp480_;
				ValaExpression* _tmp481_;
				ValaExpression* _tmp482_;
				ValaTargetValue* _tmp483_;
				ValaTargetValue* _tmp484_;
				ValaTargetValue* _tmp485_;
				ValaTargetValue* _tmp486_;
				_tmp480_ = ma;
				_tmp481_ = vala_member_access_get_inner (_tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_expression_get_target_value (_tmp482_);
				_tmp484_ = _tmp483_;
				_tmp485_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp484_, (ValaCodeNode*) expr);
				_tmp486_ = _tmp485_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp486_);
				_vala_target_value_unref0 (_tmp486_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp488_ = m;
	if (_tmp488_ != NULL) {
		ValaMethod* _tmp489_;
		gboolean _tmp490_;
		gboolean _tmp491_;
		_tmp489_ = m;
		_tmp490_ = vala_method_get_is_async_callback (_tmp489_);
		_tmp491_ = _tmp490_;
		_tmp487_ = _tmp491_;
	} else {
		_tmp487_ = FALSE;
	}
	if (_tmp487_) {
		ValaMethod* _tmp492_;
		ValaMethod* _tmp493_;
		gboolean _tmp494_;
		gboolean _tmp495_;
		ValaHashMap* _tmp509_;
		ValaMethod* _tmp510_;
		ValaCCodeExpression* _tmp511_;
		ValaHashMap* _tmp512_;
		ValaMethod* _tmp513_;
		ValaCCodeExpression* _tmp514_;
		_tmp492_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_method_get_closure (_tmp493_);
		_tmp495_ = _tmp494_;
		if (_tmp495_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp496_;
			ValaSymbol* _tmp497_;
			ValaSymbol* _tmp498_;
			ValaBlock* _tmp499_;
			ValaBlock* _tmp500_;
			ValaBlock* _tmp501_;
			ValaBlock* _tmp502_;
			gchar* _tmp503_;
			gchar* _tmp504_;
			ValaCCodeExpression* _tmp505_;
			ValaCCodeExpression* _tmp506_;
			ValaCCodeMemberAccess* _tmp507_;
			_tmp496_ = m;
			_tmp497_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp496_);
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp498_, VALA_TYPE_METHOD, ValaMethod));
			_tmp500_ = _tmp499_;
			_tmp501_ = _vala_code_node_ref0 (_tmp500_);
			block = _tmp501_;
			_tmp502_ = block;
			_tmp503_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp502_));
			_tmp504_ = _tmp503_;
			_tmp505_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp504_);
			_tmp506_ = _tmp505_;
			_tmp507_ = vala_ccode_member_access_new_pointer (_tmp506_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp507_;
			_vala_ccode_node_unref0 (_tmp506_);
			_g_free0 (_tmp504_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp508_;
			_tmp508_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp508_;
		}
		_tmp509_ = in_arg_map;
		_tmp510_ = m;
		_tmp511_ = instance;
		vala_map_set ((ValaMap*) _tmp509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp510_), FALSE)), _tmp511_);
		_tmp512_ = out_arg_map;
		_tmp513_ = m;
		_tmp514_ = instance;
		vala_map_set ((ValaMap*) _tmp512_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp513_), FALSE)), _tmp514_);
	} else {
		gboolean _tmp515_ = FALSE;
		gboolean _tmp516_ = FALSE;
		ValaMethod* _tmp517_;
		_tmp517_ = m;
		if (_tmp517_ != NULL) {
			ValaMethod* _tmp518_;
			ValaMemberBinding _tmp519_;
			ValaMemberBinding _tmp520_;
			_tmp518_ = m;
			_tmp519_ = vala_method_get_binding (_tmp518_);
			_tmp520_ = _tmp519_;
			_tmp516_ = _tmp520_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp516_ = FALSE;
		}
		if (_tmp516_) {
			ValaMethod* _tmp521_;
			_tmp521_ = m;
			_tmp515_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp521_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp522_;
			ValaExpression* _tmp523_;
			ValaExpression* _tmp524_;
			ValaTargetValue* _tmp525_;
			ValaTargetValue* _tmp526_;
			ValaTargetValue* _tmp527_;
			gboolean _tmp528_ = FALSE;
			gboolean _tmp529_ = FALSE;
			ValaMemberAccess* _tmp530_;
			const gchar* _tmp531_;
			const gchar* _tmp532_;
			ValaTargetValue* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp556_;
			ValaSymbol* _tmp557_;
			ValaSymbol* _tmp558_;
			ValaStruct* _tmp559_;
			gboolean _tmp560_ = FALSE;
			ValaStruct* _tmp561_;
			gboolean _tmp570_;
			gboolean _tmp571_;
			_tmp522_ = ma;
			_tmp523_ = vala_member_access_get_inner (_tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_expression_get_target_value (_tmp524_);
			_tmp526_ = _tmp525_;
			_tmp527_ = _vala_target_value_ref0 (_tmp526_);
			instance_value = _tmp527_;
			_tmp530_ = ma;
			_tmp531_ = vala_member_access_get_member_name (_tmp530_);
			_tmp532_ = _tmp531_;
			if (g_strcmp0 (_tmp532_, "begin") == 0) {
				_tmp529_ = TRUE;
			} else {
				ValaMemberAccess* _tmp533_;
				const gchar* _tmp534_;
				const gchar* _tmp535_;
				_tmp533_ = ma;
				_tmp534_ = vala_member_access_get_member_name (_tmp533_);
				_tmp535_ = _tmp534_;
				_tmp529_ = g_strcmp0 (_tmp535_, "end") == 0;
			}
			if (_tmp529_) {
				ValaMemberAccess* _tmp536_;
				ValaExpression* _tmp537_;
				ValaExpression* _tmp538_;
				ValaSymbol* _tmp539_;
				ValaSymbol* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaSymbol* _tmp542_;
				ValaSymbol* _tmp543_;
				_tmp536_ = ma;
				_tmp537_ = vala_member_access_get_inner (_tmp536_);
				_tmp538_ = _tmp537_;
				_tmp539_ = vala_expression_get_symbol_reference (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = ma;
				_tmp542_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp541_);
				_tmp543_ = _tmp542_;
				_tmp528_ = _tmp540_ == _tmp543_;
			} else {
				_tmp528_ = FALSE;
			}
			if (_tmp528_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp544_;
				ValaExpression* _tmp545_;
				ValaExpression* _tmp546_;
				ValaMemberAccess* _tmp547_;
				ValaMemberAccess* _tmp548_;
				ValaExpression* _tmp549_;
				ValaExpression* _tmp550_;
				ValaTargetValue* _tmp551_;
				ValaTargetValue* _tmp552_;
				ValaTargetValue* _tmp553_;
				_tmp544_ = ma;
				_tmp545_ = vala_member_access_get_inner (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp546_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp547_;
				_tmp548_ = inner_ma;
				_tmp549_ = vala_member_access_get_inner (_tmp548_);
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_expression_get_target_value (_tmp550_);
				_tmp552_ = _tmp551_;
				_tmp553_ = _vala_target_value_ref0 (_tmp552_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp553_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp554_ = instance_value;
			_tmp555_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp554_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp555_;
			_tmp556_ = m;
			_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp558_) : NULL);
			st = _tmp559_;
			_tmp561_ = st;
			if (_tmp561_ != NULL) {
				ValaStruct* _tmp562_;
				_tmp562_ = st;
				_tmp560_ = !vala_struct_is_simple_type (_tmp562_);
			} else {
				_tmp560_ = FALSE;
			}
			if (_tmp560_) {
				ValaTargetValue* _tmp563_;
				ValaTargetValue* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaCCodeExpression* _tmp568_;
				ValaCCodeUnaryExpression* _tmp569_;
				_tmp563_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp563_)) {
					ValaTargetValue* _tmp564_;
					ValaTargetValue* _tmp565_;
					_tmp564_ = instance_value;
					_tmp565_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp564_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp565_;
				}
				_tmp566_ = instance_value;
				_tmp567_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp566_);
				_tmp568_ = _tmp567_;
				_tmp569_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp568_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp569_;
				_vala_ccode_node_unref0 (_tmp568_);
			}
			_tmp570_ = vala_method_call_get_is_yield_expression (expr);
			_tmp571_ = _tmp570_;
			if (_tmp571_) {
				ValaHashMap* _tmp572_;
				ValaMethod* _tmp573_;
				ValaCCodeExpression* _tmp574_;
				ValaMethod* _tmp575_;
				_tmp572_ = in_arg_map;
				_tmp573_ = m;
				_tmp574_ = instance;
				vala_map_set ((ValaMap*) _tmp572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp573_), FALSE)), _tmp574_);
				_tmp575_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp575_)) {
					ValaHashMap* _tmp576_;
					ValaMethod* _tmp577_;
					ValaCCodeExpression* _tmp578_;
					_tmp576_ = out_arg_map;
					_tmp577_ = m;
					_tmp578_ = instance;
					vala_map_set ((ValaMap*) _tmp576_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp577_), FALSE)), _tmp578_);
				}
			} else {
				gboolean _tmp579_ = FALSE;
				ValaMemberAccess* _tmp580_;
				const gchar* _tmp581_;
				const gchar* _tmp582_;
				_tmp580_ = ma;
				_tmp581_ = vala_member_access_get_member_name (_tmp580_);
				_tmp582_ = _tmp581_;
				if (g_strcmp0 (_tmp582_, "end") != 0) {
					_tmp579_ = TRUE;
				} else {
					ValaMethod* _tmp583_;
					_tmp583_ = m;
					_tmp579_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp583_);
				}
				if (_tmp579_) {
					ValaHashMap* _tmp584_;
					ValaMethod* _tmp585_;
					ValaCCodeExpression* _tmp586_;
					ValaHashMap* _tmp587_;
					ValaMethod* _tmp588_;
					ValaCCodeExpression* _tmp589_;
					_tmp584_ = out_arg_map;
					_tmp585_ = m;
					_tmp586_ = instance;
					vala_map_set ((ValaMap*) _tmp584_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp585_), FALSE)), _tmp586_);
					_tmp587_ = in_arg_map;
					_tmp588_ = m;
					_tmp589_ = instance;
					vala_map_set ((ValaMap*) _tmp587_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp588_), FALSE)), _tmp589_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp590_ = FALSE;
			ValaMethod* _tmp591_;
			_tmp591_ = m;
			if (_tmp591_ != NULL) {
				ValaMethod* _tmp592_;
				ValaMemberBinding _tmp593_;
				ValaMemberBinding _tmp594_;
				_tmp592_ = m;
				_tmp593_ = vala_method_get_binding (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp590_ = _tmp594_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp590_ = FALSE;
			}
			if (_tmp590_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp595_;
				ValaSymbol* _tmp596_;
				ValaSymbol* _tmp597_;
				ValaClass* _tmp598_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp599_;
				gchar* _tmp600_;
				gchar* _tmp601_;
				ValaCCodeIdentifier* _tmp602_;
				ValaCCodeIdentifier* _tmp603_;
				ValaCCodeFunctionCall* _tmp604_;
				ValaCCodeFunctionCall* _tmp605_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp606_;
				ValaExpression* _tmp607_;
				ValaExpression* _tmp608_;
				ValaCCodeFunctionCall* _tmp632_;
				ValaCCodeExpression* _tmp633_;
				ValaHashMap* _tmp634_;
				ValaMethod* _tmp635_;
				ValaCCodeFunctionCall* _tmp636_;
				ValaHashMap* _tmp637_;
				ValaMethod* _tmp638_;
				ValaCCodeFunctionCall* _tmp639_;
				_tmp595_ = m;
				_tmp596_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp595_);
				_tmp597_ = _tmp596_;
				_tmp598_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp597_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp598_;
				_tmp599_ = cl;
				_tmp600_ = vala_get_ccode_class_type_function (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_ccode_identifier_new (_tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp603_);
				_tmp605_ = _tmp604_;
				_vala_ccode_node_unref0 (_tmp603_);
				_g_free0 (_tmp601_);
				cast = _tmp605_;
				_tmp606_ = ma;
				_tmp607_ = vala_member_access_get_inner (_tmp606_);
				_tmp608_ = _tmp607_;
				if (_tmp608_ == NULL) {
					ValaDataType* _tmp609_;
					_tmp609_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp609_ == NULL) {
						ValaCCodeIdentifier* _tmp610_;
						_tmp610_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp610_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp611_;
						ValaCCodeIdentifier* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeFunctionCall* _tmp614_;
						ValaCCodeFunctionCall* _tmp615_;
						ValaCCodeExpression* _tmp616_;
						ValaCCodeExpression* _tmp617_;
						ValaCCodeFunctionCall* _tmp618_;
						ValaCCodeExpression* _tmp619_;
						_tmp611_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp612_ = _tmp611_;
						_tmp613_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp612_);
						_tmp614_ = _tmp613_;
						_vala_ccode_node_unref0 (_tmp612_);
						k = _tmp614_;
						_tmp615_ = k;
						_tmp616_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp617_ = _tmp616_;
						vala_ccode_function_call_add_argument (_tmp615_, _tmp617_);
						_vala_ccode_node_unref0 (_tmp617_);
						_tmp618_ = k;
						_tmp619_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp618_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp619_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp620_;
					ValaCCodeIdentifier* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaCCodeFunctionCall* _tmp624_;
					ValaMemberAccess* _tmp625_;
					ValaExpression* _tmp626_;
					ValaExpression* _tmp627_;
					ValaCCodeExpression* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					ValaCCodeFunctionCall* _tmp630_;
					ValaCCodeExpression* _tmp631_;
					_tmp620_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp621_ = _tmp620_;
					_tmp622_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp621_);
					_tmp623_ = _tmp622_;
					_vala_ccode_node_unref0 (_tmp621_);
					k = _tmp623_;
					_tmp624_ = k;
					_tmp625_ = ma;
					_tmp626_ = vala_member_access_get_inner (_tmp625_);
					_tmp627_ = _tmp626_;
					_tmp628_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp627_);
					_tmp629_ = _tmp628_;
					vala_ccode_function_call_add_argument (_tmp624_, _tmp629_);
					_vala_ccode_node_unref0 (_tmp629_);
					_tmp630_ = k;
					_tmp631_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp630_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp631_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp632_ = cast;
				_tmp633_ = klass;
				vala_ccode_function_call_add_argument (_tmp632_, _tmp633_);
				_tmp634_ = in_arg_map;
				_tmp635_ = m;
				_tmp636_ = cast;
				vala_map_set ((ValaMap*) _tmp634_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp635_), FALSE)), (ValaCCodeExpression*) _tmp636_);
				_tmp637_ = out_arg_map;
				_tmp638_ = m;
				_tmp639_ = cast;
				vala_map_set ((ValaMap*) _tmp637_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp638_), FALSE)), (ValaCCodeExpression*) _tmp639_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp641_ = m;
	if (_tmp641_ != NULL) {
		ValaMethod* _tmp642_;
		_tmp642_ = m;
		_tmp640_ = vala_get_ccode_has_generic_type_parameter (_tmp642_);
	} else {
		_tmp640_ = FALSE;
	}
	if (_tmp640_) {
		ValaMethod* _tmp643_;
		_tmp643_ = m;
		if (vala_method_has_type_parameters (_tmp643_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp644_;
				ValaList* _tmp645_;
				ValaList* _tmp646_;
				gint _type_arg_size = 0;
				ValaList* _tmp647_;
				gint _tmp648_;
				gint _tmp649_;
				gint _type_arg_index = 0;
				_tmp644_ = ma;
				_tmp645_ = vala_member_access_get_type_arguments (_tmp644_);
				_tmp646_ = _vala_iterable_ref0 (_tmp645_);
				_type_arg_list = _tmp646_;
				_tmp647_ = _type_arg_list;
				_tmp648_ = vala_collection_get_size ((ValaCollection*) _tmp647_);
				_tmp649_ = _tmp648_;
				_type_arg_size = _tmp649_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp650_;
					gpointer _tmp651_;
					gboolean _tmp652_ = FALSE;
					gboolean _tmp653_ = FALSE;
					gboolean _tmp654_ = FALSE;
					ValaMethod* _tmp655_;
					ValaHashMap* _tmp663_;
					ValaMethod* _tmp664_;
					ValaDataType* _tmp665_;
					gchar* _tmp666_;
					gchar* _tmp667_;
					ValaCCodeIdentifier* _tmp668_;
					ValaCCodeIdentifier* _tmp669_;
					gint _tmp670_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp650_ = _type_arg_list;
					_tmp651_ = vala_list_get (_tmp650_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp651_;
					_tmp655_ = m;
					if (vala_get_ccode_simple_generics (_tmp655_)) {
						ValaDataType* _tmp656_;
						_tmp656_ = type_arg;
						_tmp654_ = vala_data_type_is_real_struct_type (_tmp656_);
					} else {
						_tmp654_ = FALSE;
					}
					if (_tmp654_) {
						ValaDataType* _tmp657_;
						gboolean _tmp658_;
						gboolean _tmp659_;
						_tmp657_ = type_arg;
						_tmp658_ = vala_data_type_get_nullable (_tmp657_);
						_tmp659_ = _tmp658_;
						_tmp653_ = !_tmp659_;
					} else {
						_tmp653_ = FALSE;
					}
					if (_tmp653_) {
						ValaDataType* _tmp660_;
						_tmp660_ = type_arg;
						_tmp652_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp660_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp652_ = FALSE;
					}
					if (_tmp652_) {
						ValaDataType* _tmp661_;
						ValaPointerType* _tmp662_;
						_tmp661_ = type_arg;
						_tmp662_ = vala_pointer_type_new (_tmp661_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp662_;
					}
					_tmp663_ = in_arg_map;
					_tmp664_ = m;
					_tmp665_ = type_arg;
					_tmp666_ = vala_get_ccode_name ((ValaCodeNode*) _tmp665_);
					_tmp667_ = _tmp666_;
					_tmp668_ = vala_ccode_identifier_new (_tmp667_);
					_tmp669_ = _tmp668_;
					vala_map_set ((ValaMap*) _tmp663_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp664_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp669_);
					_vala_ccode_node_unref0 (_tmp669_);
					_g_free0 (_tmp667_);
					_tmp670_ = type_param_index;
					type_param_index = _tmp670_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp671_;
				ValaExpression* _tmp672_;
				ValaExpression* _tmp673_;
				ValaDataType* _tmp674_;
				ValaDataType* _tmp675_;
				ValaList* _tmp676_;
				ValaList* _tmp677_;
				gint _type_arg_size = 0;
				ValaList* _tmp678_;
				gint _tmp679_;
				gint _tmp680_;
				gint _type_arg_index = 0;
				_tmp671_ = ma;
				_tmp672_ = vala_member_access_get_inner (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_expression_get_value_type (_tmp673_);
				_tmp675_ = _tmp674_;
				_tmp676_ = vala_data_type_get_type_arguments (_tmp675_);
				_tmp677_ = _vala_iterable_ref0 (_tmp676_);
				_type_arg_list = _tmp677_;
				_tmp678_ = _type_arg_list;
				_tmp679_ = vala_collection_get_size ((ValaCollection*) _tmp678_);
				_tmp680_ = _tmp679_;
				_type_arg_size = _tmp680_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp681_;
					gpointer _tmp682_;
					ValaHashMap* _tmp683_;
					ValaMethod* _tmp684_;
					ValaDataType* _tmp685_;
					gchar* _tmp686_;
					gchar* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					ValaCCodeIdentifier* _tmp689_;
					gint _tmp690_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp681_ = _type_arg_list;
					_tmp682_ = vala_list_get (_tmp681_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp682_;
					_tmp683_ = in_arg_map;
					_tmp684_ = m;
					_tmp685_ = type_arg;
					_tmp686_ = vala_get_ccode_name ((ValaCodeNode*) _tmp685_);
					_tmp687_ = _tmp686_;
					_tmp688_ = vala_ccode_identifier_new (_tmp687_);
					_tmp689_ = _tmp688_;
					vala_map_set ((ValaMap*) _tmp683_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp684_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp689_);
					_vala_ccode_node_unref0 (_tmp689_);
					_g_free0 (_tmp687_);
					_tmp690_ = type_param_index;
					type_param_index = _tmp690_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp691_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp691_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp692_;
		ValaExpression* _tmp693_;
		ValaExpression* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		ValaArrayType* _tmp697_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaCCodeFunctionCall* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		ValaArrayType* _tmp703_;
		ValaDataType* _tmp704_;
		ValaDataType* _tmp705_;
		gchar* _tmp706_;
		gchar* _tmp707_;
		ValaCCodeIdentifier* _tmp708_;
		ValaCCodeIdentifier* _tmp709_;
		ValaHashMap* _tmp710_;
		ValaCCodeFunctionCall* _tmp711_;
		_tmp692_ = ma;
		_tmp693_ = vala_member_access_get_inner (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = vala_expression_get_value_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp697_;
		_tmp698_ = vala_ccode_identifier_new ("sizeof");
		_tmp699_ = _tmp698_;
		_tmp700_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp699_);
		_tmp701_ = _tmp700_;
		_vala_ccode_node_unref0 (_tmp699_);
		csizeof = _tmp701_;
		_tmp702_ = csizeof;
		_tmp703_ = array_type;
		_tmp704_ = vala_array_type_get_element_type (_tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_get_ccode_name ((ValaCodeNode*) _tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = vala_ccode_identifier_new (_tmp707_);
		_tmp709_ = _tmp708_;
		vala_ccode_function_call_add_argument (_tmp702_, (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (_tmp709_);
		_g_free0 (_tmp707_);
		_tmp710_ = in_arg_map;
		_tmp711_ = csizeof;
		vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp711_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp712_;
		_tmp712_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp712_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp713_;
			ValaMethod* _tmp714_;
			ValaMethod* _tmp715_;
			gint param_nr = 0;
			ValaMethod* _tmp777_;
			ValaCCodeBaseModuleEmitContext* _tmp778_;
			_tmp713_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp714_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp713_, (ValaSymbol*) _tmp714_);
			_tmp715_ = m;
			vala_method_clear_parameters (_tmp715_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp716_;
				ValaList* _tmp717_;
				gint _arg_size = 0;
				ValaList* _tmp718_;
				gint _tmp719_;
				gint _tmp720_;
				gint _arg_index = 0;
				_tmp716_ = vala_method_call_get_argument_list (expr);
				_tmp717_ = _vala_iterable_ref0 (_tmp716_);
				_arg_list = _tmp717_;
				_tmp718_ = _arg_list;
				_tmp719_ = vala_collection_get_size ((ValaCollection*) _tmp718_);
				_tmp720_ = _tmp719_;
				_arg_size = _tmp720_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp721_;
					gpointer _tmp722_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp723_;
					ValaUnaryExpression* _tmp724_;
					gboolean _tmp725_ = FALSE;
					ValaUnaryExpression* _tmp726_;
					gint _tmp767_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp721_ = _arg_list;
					_tmp722_ = vala_list_get (_tmp721_, _arg_index);
					arg = (ValaExpression*) _tmp722_;
					_tmp723_ = arg;
					_tmp724_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp723_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp723_) : NULL);
					unary = _tmp724_;
					_tmp726_ = unary;
					if (_tmp726_ != NULL) {
						ValaUnaryExpression* _tmp727_;
						ValaUnaryOperator _tmp728_;
						ValaUnaryOperator _tmp729_;
						_tmp727_ = unary;
						_tmp728_ = vala_unary_expression_get_operator (_tmp727_);
						_tmp729_ = _tmp728_;
						_tmp725_ = _tmp729_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp725_ = FALSE;
					}
					if (_tmp725_) {
						ValaParameter* param = NULL;
						gchar* _tmp730_;
						gchar* _tmp731_;
						ValaUnaryExpression* _tmp732_;
						ValaExpression* _tmp733_;
						ValaExpression* _tmp734_;
						ValaDataType* _tmp735_;
						ValaDataType* _tmp736_;
						ValaParameter* _tmp737_;
						ValaParameter* _tmp738_;
						ValaParameter* _tmp739_;
						ValaMethod* _tmp740_;
						ValaParameter* _tmp741_;
						_tmp730_ = g_strdup_printf ("param%d", param_nr);
						_tmp731_ = _tmp730_;
						_tmp732_ = unary;
						_tmp733_ = vala_unary_expression_get_inner (_tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = vala_expression_get_value_type (_tmp734_);
						_tmp736_ = _tmp735_;
						_tmp737_ = vala_parameter_new (_tmp731_, _tmp736_, NULL);
						_tmp738_ = _tmp737_;
						_g_free0 (_tmp731_);
						param = _tmp738_;
						_tmp739_ = param;
						vala_parameter_set_direction (_tmp739_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp740_ = m;
						_tmp741_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp740_, _tmp741_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp742_ = FALSE;
						ValaUnaryExpression* _tmp743_;
						_tmp743_ = unary;
						if (_tmp743_ != NULL) {
							ValaUnaryExpression* _tmp744_;
							ValaUnaryOperator _tmp745_;
							ValaUnaryOperator _tmp746_;
							_tmp744_ = unary;
							_tmp745_ = vala_unary_expression_get_operator (_tmp744_);
							_tmp746_ = _tmp745_;
							_tmp742_ = _tmp746_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp742_ = FALSE;
						}
						if (_tmp742_) {
							ValaParameter* param = NULL;
							gchar* _tmp747_;
							gchar* _tmp748_;
							ValaUnaryExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaExpression* _tmp751_;
							ValaDataType* _tmp752_;
							ValaDataType* _tmp753_;
							ValaParameter* _tmp754_;
							ValaParameter* _tmp755_;
							ValaParameter* _tmp756_;
							ValaMethod* _tmp757_;
							ValaParameter* _tmp758_;
							_tmp747_ = g_strdup_printf ("param%d", param_nr);
							_tmp748_ = _tmp747_;
							_tmp749_ = unary;
							_tmp750_ = vala_unary_expression_get_inner (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_expression_get_value_type (_tmp751_);
							_tmp753_ = _tmp752_;
							_tmp754_ = vala_parameter_new (_tmp748_, _tmp753_, NULL);
							_tmp755_ = _tmp754_;
							_g_free0 (_tmp748_);
							param = _tmp755_;
							_tmp756_ = param;
							vala_parameter_set_direction (_tmp756_, VALA_PARAMETER_DIRECTION_REF);
							_tmp757_ = m;
							_tmp758_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp758_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp759_;
							gchar* _tmp760_;
							gchar* _tmp761_;
							ValaExpression* _tmp762_;
							ValaDataType* _tmp763_;
							ValaDataType* _tmp764_;
							ValaParameter* _tmp765_;
							ValaParameter* _tmp766_;
							_tmp759_ = m;
							_tmp760_ = g_strdup_printf ("param%d", param_nr);
							_tmp761_ = _tmp760_;
							_tmp762_ = arg;
							_tmp763_ = vala_expression_get_value_type (_tmp762_);
							_tmp764_ = _tmp763_;
							_tmp765_ = vala_parameter_new (_tmp761_, _tmp764_, NULL);
							_tmp766_ = _tmp765_;
							vala_callable_add_parameter ((ValaCallable*) _tmp759_, _tmp766_);
							_vala_code_node_unref0 (_tmp766_);
							_g_free0 (_tmp761_);
						}
					}
					_tmp767_ = param_nr;
					param_nr = _tmp767_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp768_;
				ValaList* _tmp769_;
				ValaList* _tmp770_;
				gint _param_size = 0;
				ValaList* _tmp771_;
				gint _tmp772_;
				gint _tmp773_;
				gint _param_index = 0;
				_tmp768_ = m;
				_tmp769_ = vala_callable_get_parameters ((ValaCallable*) _tmp768_);
				_tmp770_ = _vala_iterable_ref0 (_tmp769_);
				_param_list = _tmp770_;
				_tmp771_ = _param_list;
				_tmp772_ = vala_collection_get_size ((ValaCollection*) _tmp771_);
				_tmp773_ = _tmp772_;
				_param_size = _tmp773_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp774_;
					gpointer _tmp775_;
					ValaParameter* _tmp776_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp774_ = _param_list;
					_tmp775_ = vala_list_get (_tmp774_, _param_index);
					param = (ValaParameter*) _tmp775_;
					_tmp776_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp776_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp777_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp777_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp778_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp778_);
		} else {
			gboolean _tmp779_ = FALSE;
			gboolean _tmp780_ = FALSE;
			ValaMethod* _tmp781_;
			_tmp781_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp781_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp782_;
				ValaCodeContext* _tmp783_;
				ValaProfile _tmp784_;
				ValaProfile _tmp785_;
				_tmp782_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp783_ = _tmp782_;
				_tmp784_ = vala_code_context_get_profile (_tmp783_);
				_tmp785_ = _tmp784_;
				_tmp780_ = _tmp785_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp780_ = FALSE;
			}
			if (_tmp780_) {
				ValaMethod* _tmp786_;
				ValaSymbol* _tmp787_;
				ValaSymbol* _tmp788_;
				_tmp786_ = m;
				_tmp787_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp786_);
				_tmp788_ = _tmp787_;
				_tmp779_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp788_, VALA_TYPE_CLASS);
			} else {
				_tmp779_ = FALSE;
			}
			if (_tmp779_) {
				ValaCCodeFunction* _tmp789_;
				ValaCCodeFunction* _tmp790_;
				ValaCCodeExpression* _tmp791_;
				ValaCCodeExpression* _tmp792_;
				ValaCCodeFunctionCall* _tmp793_;
				ValaClass* _tmp794_;
				ValaClass* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				ValaCCodeCastExpression* _tmp800_;
				ValaCCodeCastExpression* _tmp801_;
				ValaMethod* _tmp802_;
				ValaMethod* _tmp803_;
				ValaBlock* _tmp804_;
				ValaBlock* _tmp805_;
				gboolean _tmp806_;
				gboolean _tmp807_;
				gboolean _tmp834_ = FALSE;
				ValaClass* _tmp835_;
				ValaClass* _tmp836_;
				gboolean _tmp837_;
				gboolean _tmp838_;
				_tmp789_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = ccall;
				_tmp794_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp795_ = _tmp794_;
				_tmp796_ = vala_get_ccode_name ((ValaCodeNode*) _tmp795_);
				_tmp797_ = _tmp796_;
				_tmp798_ = g_strconcat (_tmp797_, "*", NULL);
				_tmp799_ = _tmp798_;
				_tmp800_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp793_, _tmp799_);
				_tmp801_ = _tmp800_;
				vala_ccode_function_add_assignment (_tmp790_, _tmp792_, (ValaCCodeExpression*) _tmp801_);
				_vala_ccode_node_unref0 (_tmp801_);
				_g_free0 (_tmp799_);
				_g_free0 (_tmp797_);
				_vala_ccode_node_unref0 (_tmp792_);
				_tmp802_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp803_);
				_tmp805_ = _tmp804_;
				_tmp806_ = vala_block_get_captured (_tmp805_);
				_tmp807_ = _tmp806_;
				if (_tmp807_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp808_;
					ValaClass* _tmp809_;
					ValaObjectType* _tmp810_;
					ValaObjectType* _tmp811_;
					ValaSourceReference* _tmp812_;
					ValaSourceReference* _tmp813_;
					ValaCCodeExpression* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeExpression* _tmp820_;
					ValaCCodeFunction* _tmp821_;
					ValaCCodeFunction* _tmp822_;
					ValaMethod* _tmp823_;
					ValaMethod* _tmp824_;
					ValaBlock* _tmp825_;
					ValaBlock* _tmp826_;
					gchar* _tmp827_;
					gchar* _tmp828_;
					ValaCCodeExpression* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeMemberAccess* _tmp831_;
					ValaCCodeMemberAccess* _tmp832_;
					ValaCCodeFunctionCall* _tmp833_;
					_tmp808_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp809_);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp811_, _tmp813_, FALSE);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_ccode_function_call_new (_tmp815_);
					_tmp817_ = _tmp816_;
					_vala_ccode_node_unref0 (_tmp815_);
					_vala_code_node_unref0 (_tmp811_);
					ref_call = _tmp817_;
					_tmp818_ = ref_call;
					_tmp819_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					vala_ccode_function_call_add_argument (_tmp818_, _tmp820_);
					_vala_ccode_node_unref0 (_tmp820_);
					_tmp821_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					_tmp825_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp824_);
					_tmp826_ = _tmp825_;
					_tmp827_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp826_));
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_ccode_member_access_new_pointer (_tmp830_, "self");
					_tmp832_ = _tmp831_;
					_tmp833_ = ref_call;
					vala_ccode_function_add_assignment (_tmp822_, (ValaCCodeExpression*) _tmp832_, (ValaCCodeExpression*) _tmp833_);
					_vala_ccode_node_unref0 (_tmp832_);
					_vala_ccode_node_unref0 (_tmp830_);
					_g_free0 (_tmp828_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp835_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_class_get_is_compact (_tmp836_);
				_tmp838_ = _tmp837_;
				if (!_tmp838_) {
					ValaClass* _tmp839_;
					ValaClass* _tmp840_;
					_tmp839_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp840_ = _tmp839_;
					_tmp834_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp840_);
				} else {
					_tmp834_ = FALSE;
				}
				if (_tmp834_) {
					gchar** suffices = NULL;
					gchar* _tmp841_;
					gchar* _tmp842_;
					gchar* _tmp843_;
					gchar** _tmp844_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp841_ = g_strdup ("type");
					_tmp842_ = g_strdup ("dup_func");
					_tmp843_ = g_strdup ("destroy_func");
					_tmp844_ = g_new0 (gchar*, 3 + 1);
					_tmp844_[0] = _tmp841_;
					_tmp844_[1] = _tmp842_;
					_tmp844_[2] = _tmp843_;
					suffices = _tmp844_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp845_;
						ValaClass* _tmp846_;
						ValaList* _tmp847_;
						ValaList* _tmp848_;
						gint _type_param_size = 0;
						ValaList* _tmp849_;
						gint _tmp850_;
						gint _tmp851_;
						gint _type_param_index = 0;
						_tmp845_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp846_ = _tmp845_;
						_tmp847_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp846_);
						_tmp848_ = _vala_iterable_ref0 (_tmp847_);
						_type_param_list = _tmp848_;
						_tmp849_ = _type_param_list;
						_tmp850_ = vala_collection_get_size ((ValaCollection*) _tmp849_);
						_tmp851_ = _tmp850_;
						_type_param_size = _tmp851_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp852_;
							gpointer _tmp853_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp854_;
							ValaCCodeIdentifier* _tmp855_;
							ValaCCodeMemberAccess* _tmp856_;
							ValaCCodeMemberAccess* _tmp857_;
							gchar** _tmp858_;
							gint _tmp858__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp852_ = _type_param_list;
							_tmp853_ = vala_list_get (_tmp852_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp853_;
							_tmp854_ = vala_ccode_identifier_new ("self");
							_tmp855_ = _tmp854_;
							_tmp856_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp855_, "priv");
							_tmp857_ = _tmp856_;
							_vala_ccode_node_unref0 (_tmp855_);
							priv_access = _tmp857_;
							_tmp858_ = suffices;
							_tmp858__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp858_;
								suffix_collection_length1 = _tmp858__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp859_;
									gchar* suffix = NULL;
									_tmp859_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp859_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp860_;
										const gchar* _tmp861_;
										const gchar* _tmp862_;
										gchar* _tmp863_;
										gchar* _tmp864_;
										const gchar* _tmp865_;
										gchar* _tmp866_;
										gchar* _tmp867_;
										ValaCCodeIdentifier* _tmp868_;
										ValaCCodeIdentifier* _tmp869_;
										ValaCCodeFunction* _tmp870_;
										ValaCCodeFunction* _tmp871_;
										ValaCCodeMemberAccess* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										const gchar* _tmp874_;
										const gchar* _tmp875_;
										ValaCCodeMemberAccess* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeIdentifier* _tmp878_;
										_tmp860_ = type_param;
										_tmp861_ = vala_symbol_get_name ((ValaSymbol*) _tmp860_);
										_tmp862_ = _tmp861_;
										_tmp863_ = g_utf8_strdown (_tmp862_, (gssize) -1);
										_tmp864_ = _tmp863_;
										_tmp865_ = suffix;
										_tmp866_ = g_strdup_printf ("%s_%s", _tmp864_, _tmp865_);
										_tmp867_ = _tmp866_;
										_tmp868_ = vala_ccode_identifier_new (_tmp867_);
										_tmp869_ = _tmp868_;
										_g_free0 (_tmp867_);
										_g_free0 (_tmp864_);
										param_name = _tmp869_;
										_tmp870_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp871_ = _tmp870_;
										_tmp872_ = priv_access;
										_tmp873_ = param_name;
										_tmp874_ = vala_ccode_identifier_get_name (_tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp872_, _tmp875_);
										_tmp877_ = _tmp876_;
										_tmp878_ = param_name;
										vala_ccode_function_add_assignment (_tmp871_, (ValaCCodeExpression*) _tmp877_, (ValaCCodeExpression*) _tmp878_);
										_vala_ccode_node_unref0 (_tmp877_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp879_ = params;
	_tmp880_ = vala_iterable_iterator ((ValaIterable*) _tmp879_);
	params_it = _tmp880_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp881_;
		ValaList* _tmp882_;
		gint _arg_size = 0;
		ValaList* _tmp883_;
		gint _tmp884_;
		gint _tmp885_;
		gint _arg_index = 0;
		_tmp881_ = vala_method_call_get_argument_list (expr);
		_tmp882_ = _vala_iterable_ref0 (_tmp881_);
		_arg_list = _tmp882_;
		_tmp883_ = _arg_list;
		_tmp884_ = vala_collection_get_size ((ValaCollection*) _tmp883_);
		_tmp885_ = _tmp884_;
		_arg_size = _tmp885_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp886_;
			gpointer _tmp887_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp888_;
			ValaCCodeExpression* _tmp889_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp890_;
			ValaHashMap* _tmp891_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp892_;
			gboolean _tmp902_ = FALSE;
			ValaParameter* _tmp903_;
			gdouble _tmp1249_ = 0.0;
			ValaParameter* _tmp1250_;
			ValaHashMap* _tmp1252_;
			ValaCCodeExpression* _tmp1253_;
			gboolean _tmp1254_ = FALSE;
			ValaMethod* _tmp1255_;
			gboolean _tmp1280_ = FALSE;
			ValaExpression* _tmp1281_;
			gint _tmp1298_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp886_ = _arg_list;
			_tmp887_ = vala_list_get (_tmp886_, _arg_index);
			arg = (ValaExpression*) _tmp887_;
			_tmp888_ = arg;
			_tmp889_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp888_);
			cexpr = _tmp889_;
			_tmp890_ = in_arg_map;
			_tmp891_ = _vala_map_ref0 (_tmp890_);
			carg_map = _tmp891_;
			param = NULL;
			_tmp892_ = params_it;
			if (vala_iterator_next (_tmp892_)) {
				ValaIterator* _tmp893_;
				gpointer _tmp894_;
				gboolean _tmp895_ = FALSE;
				ValaParameter* _tmp896_;
				gboolean _tmp897_;
				gboolean _tmp898_;
				_tmp893_ = params_it;
				_tmp894_ = vala_iterator_get (_tmp893_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp894_;
				_tmp896_ = param;
				_tmp897_ = vala_parameter_get_params_array (_tmp896_);
				_tmp898_ = _tmp897_;
				if (_tmp898_) {
					_tmp895_ = TRUE;
				} else {
					ValaParameter* _tmp899_;
					gboolean _tmp900_;
					gboolean _tmp901_;
					_tmp899_ = param;
					_tmp900_ = vala_parameter_get_ellipsis (_tmp899_);
					_tmp901_ = _tmp900_;
					_tmp895_ = _tmp901_;
				}
				ellipsis = _tmp895_;
			}
			_tmp903_ = param;
			if (_tmp903_ != NULL) {
				_tmp902_ = !ellipsis;
			} else {
				_tmp902_ = FALSE;
			}
			if (_tmp902_) {
				ValaParameter* _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaParameterDirection _tmp906_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp909_;
				ValaUnaryExpression* _tmp910_;
				gboolean _tmp911_ = FALSE;
				ValaUnaryExpression* _tmp912_;
				ValaParameter* _tmp1178_;
				gchar* _tmp1179_;
				gchar* _tmp1180_;
				gboolean _tmp1181_;
				_tmp904_ = param;
				_tmp905_ = vala_parameter_get_direction (_tmp904_);
				_tmp906_ = _tmp905_;
				if (_tmp906_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp907_;
					ValaHashMap* _tmp908_;
					_tmp907_ = out_arg_map;
					_tmp908_ = _vala_map_ref0 (_tmp907_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp908_;
				}
				_tmp909_ = arg;
				_tmp910_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp909_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp909_) : NULL);
				unary = _tmp910_;
				_tmp912_ = unary;
				if (_tmp912_ == NULL) {
					_tmp911_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp913_;
					ValaUnaryOperator _tmp914_;
					ValaUnaryOperator _tmp915_;
					_tmp913_ = unary;
					_tmp914_ = vala_unary_expression_get_operator (_tmp913_);
					_tmp915_ = _tmp914_;
					_tmp911_ = _tmp915_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp911_) {
					gboolean _tmp916_ = FALSE;
					gboolean _tmp917_ = FALSE;
					ValaParameter* _tmp918_;
					ValaParameter* _tmp1052_;
					ValaExpression* _tmp1053_;
					ValaCCodeExpression* _tmp1054_;
					ValaCCodeExpression* _tmp1055_;
					_tmp918_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp918_)) {
						ValaParameter* _tmp919_;
						ValaDataType* _tmp920_;
						ValaDataType* _tmp921_;
						_tmp919_ = param;
						_tmp920_ = vala_variable_get_variable_type ((ValaVariable*) _tmp919_);
						_tmp921_ = _tmp920_;
						_tmp917_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp921_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp917_ = FALSE;
					}
					if (_tmp917_) {
						ValaParameter* _tmp922_;
						ValaDataType* _tmp923_;
						ValaDataType* _tmp924_;
						gboolean _tmp925_;
						gboolean _tmp926_;
						_tmp922_ = param;
						_tmp923_ = vala_variable_get_variable_type ((ValaVariable*) _tmp922_);
						_tmp924_ = _tmp923_;
						_tmp925_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp924_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp926_ = _tmp925_;
						_tmp916_ = !_tmp926_;
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp927_;
						ValaDataType* _tmp928_;
						ValaDataType* _tmp929_;
						ValaArrayType* _tmp930_;
						gchar* _tmp931_ = NULL;
						ValaParameter* _tmp932_;
						gchar* _tmp933_;
						gchar* length_ctype = NULL;
						gchar* _tmp936_;
						gboolean _tmp937_ = FALSE;
						ValaUnaryExpression* _tmp938_;
						_tmp927_ = param;
						_tmp928_ = vala_variable_get_variable_type ((ValaVariable*) _tmp927_);
						_tmp929_ = _tmp928_;
						_tmp930_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp929_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp930_;
						_tmp932_ = param;
						_tmp933_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp932_);
						_tmp931_ = _tmp933_;
						if (_tmp931_ == NULL) {
							ValaArrayType* _tmp934_;
							gchar* _tmp935_;
							_tmp934_ = array_type;
							_tmp935_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp934_);
							_g_free0 (_tmp931_);
							_tmp931_ = _tmp935_;
						}
						_tmp936_ = _tmp931_;
						_tmp931_ = NULL;
						length_ctype = _tmp936_;
						_tmp938_ = unary;
						if (_tmp938_ != NULL) {
							ValaUnaryExpression* _tmp939_;
							ValaUnaryOperator _tmp940_;
							ValaUnaryOperator _tmp941_;
							_tmp939_ = unary;
							_tmp940_ = vala_unary_expression_get_operator (_tmp939_);
							_tmp941_ = _tmp940_;
							_tmp937_ = _tmp941_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp937_ = FALSE;
						}
						if (_tmp937_) {
							const gchar* _tmp942_;
							gchar* _tmp943_;
							_tmp942_ = length_ctype;
							_tmp943_ = g_strdup_printf ("%s*", _tmp942_);
							_g_free0 (length_ctype);
							length_ctype = _tmp943_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp944_ = FALSE;
								_tmp944_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp946_;
									gint _tmp947_;
									gint _tmp948_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp949_;
									ValaCCodeExpression* _tmp950_;
									ValaCCodeExpression* _tmp951_;
									const gchar* _tmp952_;
									ValaCCodeCastExpression* _tmp953_;
									ValaCCodeCastExpression* _tmp954_;
									ValaHashMap* _tmp955_;
									ValaParameter* _tmp956_;
									ValaCCodeCastExpression* _tmp957_;
									if (!_tmp944_) {
										gint _tmp945_;
										_tmp945_ = dim;
										dim = _tmp945_ + 1;
									}
									_tmp944_ = FALSE;
									_tmp946_ = array_type;
									_tmp947_ = vala_array_type_get_rank (_tmp946_);
									_tmp948_ = _tmp947_;
									if (!(dim <= _tmp948_)) {
										break;
									}
									_tmp949_ = arg;
									_tmp950_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp949_, dim);
									_tmp951_ = _tmp950_;
									_tmp952_ = length_ctype;
									_tmp953_ = vala_ccode_cast_expression_new (_tmp951_, _tmp952_);
									_tmp954_ = _tmp953_;
									_vala_ccode_node_unref0 (_tmp951_);
									array_length_expr = _tmp954_;
									_tmp955_ = carg_map;
									_tmp956_ = param;
									_tmp957_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp955_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp956_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp957_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp931_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp958_;
						ValaDataType* _tmp959_;
						ValaDataType* _tmp960_;
						_tmp958_ = param;
						_tmp959_ = vala_variable_get_variable_type ((ValaVariable*) _tmp958_);
						_tmp960_ = _tmp959_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp960_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp961_;
							ValaDataType* _tmp962_;
							ValaDataType* _tmp963_;
							ValaDelegateType* _tmp964_;
							ValaDelegateType* _tmp965_;
							ValaDelegate* _tmp966_;
							ValaDelegate* _tmp967_;
							gboolean _tmp968_;
							gboolean _tmp969_;
							_tmp961_ = param;
							_tmp962_ = vala_variable_get_variable_type ((ValaVariable*) _tmp961_);
							_tmp963_ = _tmp962_;
							_tmp964_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp963_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp964_;
							_tmp965_ = deleg_type;
							_tmp966_ = vala_delegate_type_get_delegate_symbol (_tmp965_);
							_tmp967_ = _tmp966_;
							_tmp968_ = vala_delegate_get_has_target (_tmp967_);
							_tmp969_ = _tmp968_;
							if (_tmp969_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp970_;
								ValaCCodeExpression* _tmp971_ = NULL;
								ValaCCodeExpression* _tmp972_;
								ValaCCodeExpression* _tmp973_;
								ValaParameter* _tmp974_;
								gchar* _tmp975_;
								gchar* _tmp976_;
								gboolean _tmp977_;
								_tmp970_ = arg;
								_tmp972_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp970_, &_tmp971_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp971_;
								delegate_target = _tmp972_;
								_tmp973_ = delegate_target;
								_vala_assert (_tmp973_ != NULL, "delegate_target != null");
								_tmp974_ = param;
								_tmp975_ = vala_get_ccode_type ((ValaCodeNode*) _tmp974_);
								_tmp976_ = _tmp975_;
								_tmp977_ = g_strcmp0 (_tmp976_, "GClosure*") == 0;
								_g_free0 (_tmp976_);
								if (_tmp977_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp978_;
									ValaCCodeIdentifier* _tmp979_;
									ValaCCodeFunctionCall* _tmp980_;
									ValaCCodeFunctionCall* _tmp981_;
									ValaCCodeFunctionCall* _tmp982_;
									ValaCCodeExpression* _tmp983_;
									ValaCCodeCastExpression* _tmp984_;
									ValaCCodeCastExpression* _tmp985_;
									ValaCCodeFunctionCall* _tmp986_;
									ValaCCodeExpression* _tmp987_;
									ValaCCodeFunctionCall* _tmp988_;
									ValaCCodeExpression* _tmp989_;
									ValaCCodeCastExpression* _tmp990_;
									ValaCCodeCastExpression* _tmp991_;
									ValaCCodeExpression* _tmp992_;
									ValaCCodeIdentifier* _tmp993_;
									ValaCCodeIdentifier* _tmp994_;
									ValaCCodeBinaryExpression* _tmp995_;
									ValaCCodeBinaryExpression* _tmp996_;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeFunctionCall* _tmp999_;
									ValaCCodeConditionalExpression* _tmp1000_;
									_tmp978_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp979_ = _tmp978_;
									_tmp980_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp979_);
									_tmp981_ = _tmp980_;
									_vala_ccode_node_unref0 (_tmp979_);
									closure_new = _tmp981_;
									_tmp982_ = closure_new;
									_tmp983_ = cexpr;
									_tmp984_ = vala_ccode_cast_expression_new (_tmp983_, "GCallback");
									_tmp985_ = _tmp984_;
									vala_ccode_function_call_add_argument (_tmp982_, (ValaCCodeExpression*) _tmp985_);
									_vala_ccode_node_unref0 (_tmp985_);
									_tmp986_ = closure_new;
									_tmp987_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp986_, _tmp987_);
									_tmp988_ = closure_new;
									_tmp989_ = delegate_target_destroy_notify;
									_tmp990_ = vala_ccode_cast_expression_new (_tmp989_, "GClosureNotify");
									_tmp991_ = _tmp990_;
									vala_ccode_function_call_add_argument (_tmp988_, (ValaCCodeExpression*) _tmp991_);
									_vala_ccode_node_unref0 (_tmp991_);
									_tmp992_ = cexpr;
									_tmp993_ = vala_ccode_identifier_new ("NULL");
									_tmp994_ = _tmp993_;
									_tmp995_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp992_, (ValaCCodeExpression*) _tmp994_);
									_tmp996_ = _tmp995_;
									_tmp997_ = vala_ccode_identifier_new ("NULL");
									_tmp998_ = _tmp997_;
									_tmp999_ = closure_new;
									_tmp1000_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp996_, (ValaCCodeExpression*) _tmp998_, (ValaCCodeExpression*) _tmp999_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1000_;
									_vala_ccode_node_unref0 (_tmp998_);
									_vala_ccode_node_unref0 (_tmp996_);
									_vala_ccode_node_unref0 (_tmp994_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1001_;
									ValaParameter* _tmp1002_;
									ValaCCodeExpression* _tmp1003_;
									ValaDelegateType* _tmp1004_;
									_tmp1001_ = carg_map;
									_tmp1002_ = param;
									_tmp1003_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1001_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1002_), FALSE)), _tmp1003_);
									_tmp1004_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1004_)) {
										ValaCCodeExpression* _tmp1005_;
										ValaHashMap* _tmp1006_;
										ValaParameter* _tmp1007_;
										ValaCCodeExpression* _tmp1008_;
										_tmp1005_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1005_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1006_ = carg_map;
										_tmp1007_ = param;
										_tmp1008_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1006_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1007_) + 0.01, FALSE)), _tmp1008_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1009_;
							ValaDataType* _tmp1010_;
							ValaDataType* _tmp1011_;
							_tmp1009_ = param;
							_tmp1010_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1009_);
							_tmp1011_ = _tmp1010_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1011_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1012_;
								ValaParameter* _tmp1013_;
								ValaExpression* _tmp1014_;
								ValaCCodeExpression* _tmp1015_ = NULL;
								ValaCCodeExpression* _tmp1016_;
								ValaCCodeExpression* _tmp1017_;
								_tmp1012_ = carg_map;
								_tmp1013_ = param;
								_tmp1014_ = arg;
								_tmp1016_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1014_, &_tmp1015_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1015_;
								_tmp1017_ = _tmp1016_;
								vala_map_set ((ValaMap*) _tmp1012_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1013_), FALSE)), _tmp1017_);
								_vala_ccode_node_unref0 (_tmp1017_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1018_;
								ValaDataType* _tmp1019_;
								ValaDataType* _tmp1020_;
								_tmp1018_ = param;
								_tmp1019_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1018_);
								_tmp1020_ = _tmp1019_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1020_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1021_ = FALSE;
									ValaMethod* _tmp1022_;
									_tmp1022_ = m;
									if (_tmp1022_ != NULL) {
										ValaMethod* _tmp1023_;
										_tmp1023_ = m;
										_tmp1021_ = vala_get_ccode_simple_generics (_tmp1023_);
									} else {
										_tmp1021_ = FALSE;
									}
									if (_tmp1021_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1024_;
										ValaDataType* _tmp1025_;
										ValaDataType* _tmp1026_;
										ValaGenericType* _tmp1027_;
										gint type_param_index = 0;
										ValaMethod* _tmp1028_;
										ValaGenericType* _tmp1029_;
										ValaTypeParameter* _tmp1030_;
										ValaTypeParameter* _tmp1031_;
										const gchar* _tmp1032_;
										const gchar* _tmp1033_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1034_;
										ValaList* _tmp1035_;
										gpointer _tmp1036_;
										ValaParameter* _tmp1037_;
										ValaDataType* _tmp1038_;
										ValaDataType* _tmp1039_;
										gboolean _tmp1040_;
										gboolean _tmp1041_;
										_tmp1024_ = param;
										_tmp1025_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1024_);
										_tmp1026_ = _tmp1025_;
										_tmp1027_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1026_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1027_;
										_tmp1028_ = m;
										_tmp1029_ = generic_type;
										_tmp1030_ = vala_generic_type_get_type_parameter (_tmp1029_);
										_tmp1031_ = _tmp1030_;
										_tmp1032_ = vala_symbol_get_name ((ValaSymbol*) _tmp1031_);
										_tmp1033_ = _tmp1032_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1028_, _tmp1033_);
										_tmp1034_ = ma;
										_tmp1035_ = vala_member_access_get_type_arguments (_tmp1034_);
										_tmp1036_ = vala_list_get (_tmp1035_, type_param_index);
										type_arg = (ValaDataType*) _tmp1036_;
										_tmp1037_ = param;
										_tmp1038_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1037_);
										_tmp1039_ = _tmp1038_;
										_tmp1040_ = vala_data_type_get_value_owned (_tmp1039_);
										_tmp1041_ = _tmp1040_;
										if (_tmp1041_) {
											ValaDataType* _tmp1042_;
											_tmp1042_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1042_)) {
												ValaHashMap* _tmp1043_;
												ValaParameter* _tmp1044_;
												ValaDataType* _tmp1045_;
												ValaCCodeExpression* _tmp1046_;
												ValaCCodeExpression* _tmp1047_;
												_tmp1043_ = carg_map;
												_tmp1044_ = param;
												_tmp1045_ = type_arg;
												_tmp1046_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1045_, FALSE);
												_tmp1047_ = _tmp1046_;
												vala_map_set ((ValaMap*) _tmp1043_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1044_), FALSE)), _tmp1047_);
												_vala_ccode_node_unref0 (_tmp1047_);
											} else {
												ValaHashMap* _tmp1048_;
												ValaParameter* _tmp1049_;
												ValaCCodeConstant* _tmp1050_;
												ValaCCodeConstant* _tmp1051_;
												_tmp1048_ = carg_map;
												_tmp1049_ = param;
												_tmp1050_ = vala_ccode_constant_new ("NULL");
												_tmp1051_ = _tmp1050_;
												vala_map_set ((ValaMap*) _tmp1048_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1049_), FALSE)), (ValaCCodeExpression*) _tmp1051_);
												_vala_ccode_node_unref0 (_tmp1051_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1052_ = param;
					_tmp1053_ = arg;
					_tmp1054_ = cexpr;
					_tmp1055_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1052_, _tmp1053_, _tmp1054_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1055_;
				} else {
					ValaExpression* _tmp1056_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1057_;
					ValaDataType* _tmp1058_;
					ValaDataType* _tmp1059_;
					ValaParameter* _tmp1060_;
					ValaDataType* _tmp1061_;
					ValaDataType* _tmp1062_;
					gboolean _tmp1063_;
					gboolean _tmp1064_;
					ValaLocalVariable* _tmp1065_;
					ValaLocalVariable* _tmp1066_;
					ValaExpression* _tmp1067_;
					ValaLocalVariable* _tmp1068_;
					const gchar* _tmp1069_;
					const gchar* _tmp1070_;
					ValaCCodeExpression* _tmp1071_;
					ValaCCodeExpression* _tmp1072_;
					ValaExpression* _tmp1073_;
					ValaTargetValue* _tmp1074_;
					ValaTargetValue* _tmp1075_;
					ValaExpression* _tmp1076_;
					ValaDataType* _tmp1077_;
					ValaDataType* _tmp1078_;
					ValaExpression* _tmp1079_;
					ValaCCodeExpression* _tmp1080_;
					ValaCCodeExpression* _tmp1081_;
					ValaCCodeUnaryExpression* _tmp1082_;
					gboolean _tmp1083_ = FALSE;
					gboolean _tmp1084_ = FALSE;
					ValaParameter* _tmp1085_;
					_tmp1056_ = arg;
					vala_expression_set_target_value (_tmp1056_, NULL);
					_tmp1057_ = param;
					_tmp1058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1057_);
					_tmp1059_ = _tmp1058_;
					_tmp1060_ = param;
					_tmp1061_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1060_);
					_tmp1062_ = _tmp1061_;
					_tmp1063_ = vala_data_type_get_value_owned (_tmp1062_);
					_tmp1064_ = _tmp1063_;
					_tmp1065_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1059_, _tmp1064_, NULL, TRUE);
					temp_var = _tmp1065_;
					_tmp1066_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1066_, FALSE);
					_tmp1067_ = arg;
					_tmp1068_ = temp_var;
					_tmp1069_ = vala_symbol_get_name ((ValaSymbol*) _tmp1068_);
					_tmp1070_ = _tmp1069_;
					_tmp1071_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1070_);
					_tmp1072_ = _tmp1071_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1067_, _tmp1072_);
					_vala_ccode_node_unref0 (_tmp1072_);
					_tmp1073_ = arg;
					_tmp1074_ = vala_expression_get_target_value (_tmp1073_);
					_tmp1075_ = _tmp1074_;
					_tmp1076_ = arg;
					_tmp1077_ = vala_expression_get_target_type (_tmp1076_);
					_tmp1078_ = _tmp1077_;
					vala_target_value_set_value_type (_tmp1075_, _tmp1078_);
					_tmp1079_ = arg;
					_tmp1080_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1079_);
					_tmp1081_ = _tmp1080_;
					_tmp1082_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1081_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1082_;
					_vala_ccode_node_unref0 (_tmp1081_);
					_tmp1085_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1085_)) {
						ValaParameter* _tmp1086_;
						ValaDataType* _tmp1087_;
						ValaDataType* _tmp1088_;
						_tmp1086_ = param;
						_tmp1087_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1086_);
						_tmp1088_ = _tmp1087_;
						_tmp1084_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1088_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1084_ = FALSE;
					}
					if (_tmp1084_) {
						ValaParameter* _tmp1089_;
						ValaDataType* _tmp1090_;
						ValaDataType* _tmp1091_;
						gboolean _tmp1092_;
						gboolean _tmp1093_;
						_tmp1089_ = param;
						_tmp1090_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1089_);
						_tmp1091_ = _tmp1090_;
						_tmp1092_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1091_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1093_ = _tmp1092_;
						_tmp1083_ = !_tmp1093_;
					} else {
						_tmp1083_ = FALSE;
					}
					if (_tmp1083_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1094_;
						ValaDataType* _tmp1095_;
						ValaDataType* _tmp1096_;
						ValaArrayType* _tmp1097_;
						gchar* _tmp1098_ = NULL;
						ValaParameter* _tmp1099_;
						gchar* _tmp1100_;
						gchar* length_ctype = NULL;
						gchar* _tmp1103_;
						_tmp1094_ = param;
						_tmp1095_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1094_);
						_tmp1096_ = _tmp1095_;
						_tmp1097_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1096_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1097_;
						_tmp1099_ = param;
						_tmp1100_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1099_);
						_tmp1098_ = _tmp1100_;
						if (_tmp1098_ == NULL) {
							ValaArrayType* _tmp1101_;
							gchar* _tmp1102_;
							_tmp1101_ = array_type;
							_tmp1102_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1101_);
							_g_free0 (_tmp1098_);
							_tmp1098_ = _tmp1102_;
						}
						_tmp1103_ = _tmp1098_;
						_tmp1098_ = NULL;
						length_ctype = _tmp1103_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1104_ = FALSE;
								_tmp1104_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1106_;
									gint _tmp1107_;
									gint _tmp1108_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1109_;
									ValaCType* _tmp1110_;
									ValaCType* _tmp1111_;
									ValaLocalVariable* _tmp1112_;
									ValaLocalVariable* _tmp1113_;
									ValaLocalVariable* _tmp1114_;
									ValaExpression* _tmp1115_;
									ValaLocalVariable* _tmp1116_;
									const gchar* _tmp1117_;
									const gchar* _tmp1118_;
									ValaCCodeExpression* _tmp1119_;
									ValaCCodeExpression* _tmp1120_;
									ValaHashMap* _tmp1121_;
									ValaParameter* _tmp1122_;
									ValaExpression* _tmp1123_;
									ValaList* _tmp1124_;
									ValaList* _tmp1125_;
									gpointer _tmp1126_;
									ValaCCodeExpression* _tmp1127_;
									ValaCCodeUnaryExpression* _tmp1128_;
									ValaCCodeUnaryExpression* _tmp1129_;
									if (!_tmp1104_) {
										gint _tmp1105_;
										_tmp1105_ = dim;
										dim = _tmp1105_ + 1;
									}
									_tmp1104_ = FALSE;
									_tmp1106_ = array_type;
									_tmp1107_ = vala_array_type_get_rank (_tmp1106_);
									_tmp1108_ = _tmp1107_;
									if (!(dim <= _tmp1108_)) {
										break;
									}
									_tmp1109_ = length_ctype;
									_tmp1110_ = vala_ctype_new (_tmp1109_, "0");
									_tmp1111_ = _tmp1110_;
									_tmp1112_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1111_, TRUE, NULL, TRUE);
									_tmp1113_ = _tmp1112_;
									_vala_code_node_unref0 (_tmp1111_);
									temp_array_length = _tmp1113_;
									_tmp1114_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1114_, FALSE);
									_tmp1115_ = arg;
									_tmp1116_ = temp_array_length;
									_tmp1117_ = vala_symbol_get_name ((ValaSymbol*) _tmp1116_);
									_tmp1118_ = _tmp1117_;
									_tmp1119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1118_);
									_tmp1120_ = _tmp1119_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1115_, _tmp1120_);
									_vala_ccode_node_unref0 (_tmp1120_);
									_tmp1121_ = carg_map;
									_tmp1122_ = param;
									_tmp1123_ = arg;
									_tmp1124_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1123_);
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = vala_list_get (_tmp1125_, dim - 1);
									_tmp1127_ = (ValaCCodeExpression*) _tmp1126_;
									_tmp1128_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1127_);
									_tmp1129_ = _tmp1128_;
									vala_map_set ((ValaMap*) _tmp1121_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1122_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1129_);
									_vala_ccode_node_unref0 (_tmp1129_);
									_vala_ccode_node_unref0 (_tmp1127_);
									_vala_iterable_unref0 (_tmp1125_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_g_free0 (_tmp1098_);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1130_;
						ValaDataType* _tmp1131_;
						ValaDataType* _tmp1132_;
						_tmp1130_ = param;
						_tmp1131_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1130_);
						_tmp1132_ = _tmp1131_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1132_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1133_;
							ValaDataType* _tmp1134_;
							ValaDataType* _tmp1135_;
							ValaDelegateType* _tmp1136_;
							ValaDelegateType* _tmp1137_;
							ValaDelegate* _tmp1138_;
							ValaDelegate* _tmp1139_;
							gboolean _tmp1140_;
							gboolean _tmp1141_;
							_tmp1133_ = param;
							_tmp1134_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1133_);
							_tmp1135_ = _tmp1134_;
							_tmp1136_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1135_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1136_;
							_tmp1137_ = deleg_type;
							_tmp1138_ = vala_delegate_type_get_delegate_symbol (_tmp1137_);
							_tmp1139_ = _tmp1138_;
							_tmp1140_ = vala_delegate_get_has_target (_tmp1139_);
							_tmp1141_ = _tmp1140_;
							if (_tmp1141_) {
								ValaVoidType* _tmp1142_;
								ValaVoidType* _tmp1143_;
								ValaPointerType* _tmp1144_;
								ValaPointerType* _tmp1145_;
								ValaLocalVariable* _tmp1146_;
								ValaLocalVariable* _tmp1147_;
								ValaExpression* _tmp1148_;
								ValaLocalVariable* _tmp1149_;
								const gchar* _tmp1150_;
								const gchar* _tmp1151_;
								ValaCCodeExpression* _tmp1152_;
								ValaCCodeExpression* _tmp1153_;
								ValaHashMap* _tmp1154_;
								ValaParameter* _tmp1155_;
								ValaExpression* _tmp1156_;
								ValaCCodeExpression* _tmp1157_;
								ValaCCodeExpression* _tmp1158_;
								ValaCCodeUnaryExpression* _tmp1159_;
								ValaCCodeUnaryExpression* _tmp1160_;
								ValaDelegateType* _tmp1161_;
								_tmp1142_ = vala_void_type_new (NULL);
								_tmp1143_ = _tmp1142_;
								_tmp1144_ = vala_pointer_type_new ((ValaDataType*) _tmp1143_, NULL);
								_tmp1145_ = _tmp1144_;
								_tmp1146_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1145_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1146_;
								_vala_code_node_unref0 (_tmp1145_);
								_vala_code_node_unref0 (_tmp1143_);
								_tmp1147_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1147_, FALSE);
								_tmp1148_ = arg;
								_tmp1149_ = temp_var;
								_tmp1150_ = vala_symbol_get_name ((ValaSymbol*) _tmp1149_);
								_tmp1151_ = _tmp1150_;
								_tmp1152_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1151_);
								_tmp1153_ = _tmp1152_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1148_, _tmp1153_);
								_vala_ccode_node_unref0 (_tmp1153_);
								_tmp1154_ = carg_map;
								_tmp1155_ = param;
								_tmp1156_ = arg;
								_tmp1157_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1156_);
								_tmp1158_ = _tmp1157_;
								_tmp1159_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1158_);
								_tmp1160_ = _tmp1159_;
								vala_map_set ((ValaMap*) _tmp1154_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1155_), FALSE)), (ValaCCodeExpression*) _tmp1160_);
								_vala_ccode_node_unref0 (_tmp1160_);
								_vala_ccode_node_unref0 (_tmp1158_);
								_tmp1161_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1161_)) {
									ValaDataType* _tmp1162_;
									ValaLocalVariable* _tmp1163_;
									ValaLocalVariable* _tmp1164_;
									ValaExpression* _tmp1165_;
									ValaLocalVariable* _tmp1166_;
									const gchar* _tmp1167_;
									const gchar* _tmp1168_;
									ValaCCodeExpression* _tmp1169_;
									ValaCCodeExpression* _tmp1170_;
									ValaHashMap* _tmp1171_;
									ValaParameter* _tmp1172_;
									ValaExpression* _tmp1173_;
									ValaCCodeExpression* _tmp1174_;
									ValaCCodeExpression* _tmp1175_;
									ValaCCodeUnaryExpression* _tmp1176_;
									ValaCCodeUnaryExpression* _tmp1177_;
									_tmp1162_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1163_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1162_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1163_;
									_tmp1164_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1164_, FALSE);
									_tmp1165_ = arg;
									_tmp1166_ = temp_var;
									_tmp1167_ = vala_symbol_get_name ((ValaSymbol*) _tmp1166_);
									_tmp1168_ = _tmp1167_;
									_tmp1169_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1168_);
									_tmp1170_ = _tmp1169_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1165_, _tmp1170_);
									_vala_ccode_node_unref0 (_tmp1170_);
									_tmp1171_ = carg_map;
									_tmp1172_ = param;
									_tmp1173_ = arg;
									_tmp1174_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1173_);
									_tmp1175_ = _tmp1174_;
									_tmp1176_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1175_);
									_tmp1177_ = _tmp1176_;
									vala_map_set ((ValaMap*) _tmp1171_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1172_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1177_);
									_vala_ccode_node_unref0 (_tmp1177_);
									_vala_ccode_node_unref0 (_tmp1175_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1178_ = param;
				_tmp1179_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1178_);
				_tmp1180_ = _tmp1179_;
				_tmp1181_ = _tmp1180_ != NULL;
				_g_free0 (_tmp1180_);
				if (_tmp1181_) {
					ValaCCodeExpression* _tmp1182_;
					ValaParameter* _tmp1183_;
					gchar* _tmp1184_;
					gchar* _tmp1185_;
					ValaCCodeCastExpression* _tmp1186_;
					_tmp1182_ = cexpr;
					_tmp1183_ = param;
					_tmp1184_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1183_);
					_tmp1185_ = _tmp1184_;
					_tmp1186_ = vala_ccode_cast_expression_new (_tmp1182_, _tmp1185_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1186_;
					_g_free0 (_tmp1185_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1187_;
				ValaUnaryExpression* _tmp1188_;
				gboolean _tmp1189_ = FALSE;
				gboolean _tmp1190_ = FALSE;
				_tmp1187_ = arg;
				_tmp1188_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1187_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1187_) : NULL);
				unary = _tmp1188_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1191_;
					_tmp1191_ = unary;
					_tmp1190_ = _tmp1191_ != NULL;
				} else {
					_tmp1190_ = FALSE;
				}
				if (_tmp1190_) {
					ValaUnaryExpression* _tmp1192_;
					ValaUnaryOperator _tmp1193_;
					ValaUnaryOperator _tmp1194_;
					_tmp1192_ = unary;
					_tmp1193_ = vala_unary_expression_get_operator (_tmp1192_);
					_tmp1194_ = _tmp1193_;
					_tmp1189_ = _tmp1194_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1189_ = FALSE;
				}
				if (_tmp1189_) {
					ValaHashMap* _tmp1195_;
					ValaHashMap* _tmp1196_;
					ValaExpression* _tmp1197_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1198_;
					ValaDataType* _tmp1199_;
					ValaDataType* _tmp1200_;
					ValaExpression* _tmp1201_;
					ValaDataType* _tmp1202_;
					ValaDataType* _tmp1203_;
					gboolean _tmp1204_;
					gboolean _tmp1205_;
					ValaLocalVariable* _tmp1206_;
					ValaLocalVariable* _tmp1207_;
					ValaExpression* _tmp1208_;
					ValaLocalVariable* _tmp1209_;
					const gchar* _tmp1210_;
					const gchar* _tmp1211_;
					ValaCCodeExpression* _tmp1212_;
					ValaCCodeExpression* _tmp1213_;
					ValaExpression* _tmp1214_;
					ValaTargetValue* _tmp1215_;
					ValaTargetValue* _tmp1216_;
					ValaExpression* _tmp1217_;
					ValaDataType* _tmp1218_;
					ValaDataType* _tmp1219_;
					gboolean _tmp1220_ = FALSE;
					ValaExpression* _tmp1221_;
					ValaDataType* _tmp1222_;
					ValaDataType* _tmp1223_;
					ValaExpression* _tmp1242_;
					ValaCCodeExpression* _tmp1243_;
					ValaCCodeExpression* _tmp1244_;
					ValaCCodeUnaryExpression* _tmp1245_;
					_tmp1195_ = out_arg_map;
					_tmp1196_ = _vala_map_ref0 (_tmp1195_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1196_;
					_tmp1197_ = arg;
					vala_expression_set_target_value (_tmp1197_, NULL);
					_tmp1198_ = arg;
					_tmp1199_ = vala_expression_get_value_type (_tmp1198_);
					_tmp1200_ = _tmp1199_;
					_tmp1201_ = arg;
					_tmp1202_ = vala_expression_get_value_type (_tmp1201_);
					_tmp1203_ = _tmp1202_;
					_tmp1204_ = vala_data_type_get_value_owned (_tmp1203_);
					_tmp1205_ = _tmp1204_;
					_tmp1206_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1200_, _tmp1205_, NULL, TRUE);
					temp_var = _tmp1206_;
					_tmp1207_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1207_, FALSE);
					_tmp1208_ = arg;
					_tmp1209_ = temp_var;
					_tmp1210_ = vala_symbol_get_name ((ValaSymbol*) _tmp1209_);
					_tmp1211_ = _tmp1210_;
					_tmp1212_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1211_);
					_tmp1213_ = _tmp1212_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1208_, _tmp1213_);
					_vala_ccode_node_unref0 (_tmp1213_);
					_tmp1214_ = arg;
					_tmp1215_ = vala_expression_get_target_value (_tmp1214_);
					_tmp1216_ = _tmp1215_;
					_tmp1217_ = arg;
					_tmp1218_ = vala_expression_get_value_type (_tmp1217_);
					_tmp1219_ = _tmp1218_;
					vala_target_value_set_value_type (_tmp1216_, _tmp1219_);
					_tmp1221_ = arg;
					_tmp1222_ = vala_expression_get_value_type (_tmp1221_);
					_tmp1223_ = _tmp1222_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1223_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1224_;
						ValaDataType* _tmp1225_;
						ValaDataType* _tmp1226_;
						ValaDelegate* _tmp1227_;
						ValaDelegate* _tmp1228_;
						gboolean _tmp1229_;
						gboolean _tmp1230_;
						_tmp1224_ = arg;
						_tmp1225_ = vala_expression_get_value_type (_tmp1224_);
						_tmp1226_ = _tmp1225_;
						_tmp1227_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1226_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1228_ = _tmp1227_;
						_tmp1229_ = vala_delegate_get_has_target (_tmp1228_);
						_tmp1230_ = _tmp1229_;
						_tmp1220_ = _tmp1230_;
					} else {
						_tmp1220_ = FALSE;
					}
					if (_tmp1220_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1231_;
						ValaTargetValue* _tmp1232_;
						ValaTargetValue* _tmp1233_;
						ValaGLibValue* _tmp1234_;
						ValaCCodeExpression* _tmp1235_;
						ValaGLibValue* _tmp1238_;
						ValaCCodeExpression* _tmp1239_;
						_tmp1231_ = arg;
						_tmp1232_ = vala_expression_get_target_value (_tmp1231_);
						_tmp1233_ = _tmp1232_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1233_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1234_ = arg_value;
						_tmp1235_ = _tmp1234_->delegate_target_cvalue;
						if (_tmp1235_ == NULL) {
							ValaGLibValue* _tmp1236_;
							ValaCCodeConstant* _tmp1237_;
							_tmp1236_ = arg_value;
							_tmp1237_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1236_->delegate_target_cvalue);
							_tmp1236_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1237_;
						}
						_tmp1238_ = arg_value;
						_tmp1239_ = _tmp1238_->delegate_target_destroy_notify_cvalue;
						if (_tmp1239_ == NULL) {
							ValaGLibValue* _tmp1240_;
							ValaCCodeConstant* _tmp1241_;
							_tmp1240_ = arg_value;
							_tmp1241_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1240_->delegate_target_destroy_notify_cvalue);
							_tmp1240_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1241_;
						}
					}
					_tmp1242_ = arg;
					_tmp1243_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1242_);
					_tmp1244_ = _tmp1243_;
					_tmp1245_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1244_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1245_;
					_vala_ccode_node_unref0 (_tmp1244_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1246_;
					ValaCCodeExpression* _tmp1247_;
					ValaCCodeExpression* _tmp1248_;
					_tmp1246_ = arg;
					_tmp1247_ = cexpr;
					_tmp1248_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1246_, _tmp1247_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1248_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1250_ = param;
			if (_tmp1250_ != NULL) {
				ValaParameter* _tmp1251_;
				_tmp1251_ = param;
				_tmp1249_ = vala_get_ccode_pos (_tmp1251_);
			} else {
				_tmp1249_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1249_, ellipsis);
			_tmp1252_ = carg_map;
			_tmp1253_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1252_, (gpointer) ((gintptr) arg_pos), _tmp1253_);
			_tmp1255_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1255_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1256_;
				ValaCodeContext* _tmp1257_;
				ValaProfile _tmp1258_;
				ValaProfile _tmp1259_;
				_tmp1256_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1257_ = _tmp1256_;
				_tmp1258_ = vala_code_context_get_profile (_tmp1257_);
				_tmp1259_ = _tmp1258_;
				_tmp1254_ = _tmp1259_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1254_ = FALSE;
			}
			if (_tmp1254_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1260_;
				ValaExpression* _tmp1261_;
				ValaExpression* _tmp1262_;
				ValaDataType* _tmp1263_;
				ValaDataType* _tmp1264_;
				ValaDataType* _tmp1265_;
				ValaDataType* _tmp1266_;
				gchar* _tmp1267_;
				gchar* _tmp1268_;
				gchar* _tmp1269_;
				gchar* _tmp1270_;
				ValaCCodeIdentifier* _tmp1271_;
				ValaCCodeIdentifier* _tmp1272_;
				ValaHashMap* _tmp1273_;
				ValaCCodeIdentifier* _tmp1274_;
				ValaCCodeExpression* _tmp1275_;
				ValaCCodeBinaryExpression* _tmp1276_;
				ValaCCodeBinaryExpression* _tmp1277_;
				_tmp1260_ = ma;
				_tmp1261_ = vala_member_access_get_inner (_tmp1260_);
				_tmp1262_ = _tmp1261_;
				_tmp1263_ = vala_expression_get_value_type (_tmp1262_);
				_tmp1264_ = _tmp1263_;
				_tmp1265_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1264_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1266_ = _tmp1265_;
				_tmp1267_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1266_);
				_tmp1268_ = _tmp1267_;
				_tmp1269_ = g_strdup_printf ("sizeof (%s)", _tmp1268_);
				_tmp1270_ = _tmp1269_;
				_tmp1271_ = vala_ccode_identifier_new (_tmp1270_);
				_tmp1272_ = _tmp1271_;
				_g_free0 (_tmp1270_);
				_g_free0 (_tmp1268_);
				csizeof = _tmp1272_;
				_tmp1273_ = carg_map;
				_tmp1274_ = csizeof;
				_tmp1275_ = cexpr;
				_tmp1276_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1274_, _tmp1275_);
				_tmp1277_ = _tmp1276_;
				vala_map_set ((ValaMap*) _tmp1273_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1277_);
				_vala_ccode_node_unref0 (_tmp1277_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1278_;
				ValaCCodeExpression* _tmp1279_;
				_tmp1278_ = carg_map;
				_tmp1279_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1278_, (gpointer) ((gintptr) arg_pos), _tmp1279_);
			}
			_tmp1281_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1281_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1280_ = ellipsis;
			} else {
				_tmp1280_ = FALSE;
			}
			if (_tmp1280_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1282_;
				ValaNamedArgument* _tmp1283_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1284_;
				const gchar* _tmp1285_;
				const gchar* _tmp1286_;
				gchar** _tmp1287_;
				gchar** _tmp1288_;
				gchar** _tmp1289_;
				gint _tmp1289__length1;
				gchar* _tmp1290_;
				gchar* _tmp1291_;
				ValaHashMap* _tmp1292_;
				const gchar* _tmp1293_;
				gchar* _tmp1294_;
				gchar* _tmp1295_;
				ValaCCodeConstant* _tmp1296_;
				ValaCCodeConstant* _tmp1297_;
				_tmp1282_ = arg;
				_tmp1283_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1283_;
				_tmp1284_ = named_arg;
				_tmp1285_ = vala_named_argument_get_name (_tmp1284_);
				_tmp1286_ = _tmp1285_;
				_tmp1288_ = _tmp1287_ = g_strsplit (_tmp1286_, "_", 0);
				_tmp1289_ = _tmp1288_;
				_tmp1289__length1 = _vala_array_length (_tmp1287_);
				_tmp1290_ = _vala_g_strjoinv ("-", _tmp1289_, (gint) _vala_array_length (_tmp1287_));
				_tmp1291_ = _tmp1290_;
				_tmp1289_ = (_vala_array_free (_tmp1289_, _tmp1289__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1291_;
				_tmp1292_ = carg_map;
				_tmp1293_ = name;
				_tmp1294_ = g_strdup_printf ("\"%s\"", _tmp1293_);
				_tmp1295_ = _tmp1294_;
				_tmp1296_ = vala_ccode_constant_new (_tmp1295_);
				_tmp1297_ = _tmp1296_;
				vala_map_set ((ValaMap*) _tmp1292_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1297_);
				_vala_ccode_node_unref0 (_tmp1297_);
				_g_free0 (_tmp1295_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1298_ = i;
			i = _tmp1298_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1299_ = params_it;
	if (vala_iterator_next (_tmp1299_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1300_;
		gpointer _tmp1301_;
		gboolean _tmp1302_ = FALSE;
		ValaParameter* _tmp1303_;
		gboolean _tmp1304_;
		gboolean _tmp1305_;
		_tmp1300_ = params_it;
		_tmp1301_ = vala_iterator_get (_tmp1300_);
		param = (ValaParameter*) _tmp1301_;
		_tmp1303_ = param;
		_tmp1304_ = vala_parameter_get_params_array (_tmp1303_);
		_tmp1305_ = _tmp1304_;
		if (_tmp1305_) {
			_tmp1302_ = TRUE;
		} else {
			ValaParameter* _tmp1306_;
			gboolean _tmp1307_;
			gboolean _tmp1308_;
			_tmp1306_ = param;
			_tmp1307_ = vala_parameter_get_ellipsis (_tmp1306_);
			_tmp1308_ = _tmp1307_;
			_tmp1302_ = _tmp1308_;
		}
		_vala_assert (_tmp1302_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1311_ = m;
	if (_tmp1311_ != NULL) {
		ValaMethod* _tmp1312_;
		ValaDataType* _tmp1313_;
		ValaDataType* _tmp1314_;
		_tmp1312_ = m;
		_tmp1313_ = vala_callable_get_return_type ((ValaCallable*) _tmp1312_);
		_tmp1314_ = _tmp1313_;
		_tmp1310_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1314_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1310_ = FALSE;
	}
	if (_tmp1310_) {
		ValaCCodeFunctionCall* _tmp1315_;
		ValaCCodeFunctionCall* _tmp1316_;
		_tmp1315_ = async_call;
		_tmp1316_ = ccall;
		_tmp1309_ = _tmp1315_ != _tmp1316_;
	} else {
		_tmp1309_ = FALSE;
	}
	if (_tmp1309_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1317_;
		ValaDataType* _tmp1318_;
		ValaDataType* _tmp1319_;
		ValaArrayType* _tmp1320_;
		_tmp1317_ = m;
		_tmp1318_ = vala_callable_get_return_type ((ValaCallable*) _tmp1317_);
		_tmp1319_ = _tmp1318_;
		_tmp1320_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1319_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1320_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1321_ = FALSE;
				_tmp1321_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1323_;
					gint _tmp1324_;
					gint _tmp1325_;
					ValaMethod* _tmp1326_;
					if (!_tmp1321_) {
						gint _tmp1322_;
						_tmp1322_ = dim;
						dim = _tmp1322_ + 1;
					}
					_tmp1321_ = FALSE;
					_tmp1323_ = array_type;
					_tmp1324_ = vala_array_type_get_rank (_tmp1323_);
					_tmp1325_ = _tmp1324_;
					if (!(dim <= _tmp1325_)) {
						break;
					}
					_tmp1326_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1326_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1327_;
						ValaDataType* _tmp1328_;
						ValaLocalVariable* _tmp1329_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1330_;
						const gchar* _tmp1331_;
						const gchar* _tmp1332_;
						ValaCCodeExpression* _tmp1333_;
						ValaLocalVariable* _tmp1334_;
						ValaCCodeExpression* _tmp1335_;
						ValaCCodeExpression* _tmp1336_;
						ValaCCodeAssignment* _tmp1337_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1338_;
						ValaCCodeIdentifier* _tmp1339_;
						ValaCCodeFunctionCall* _tmp1340_;
						ValaCCodeFunctionCall* _tmp1341_;
						ValaCCodeFunctionCall* _tmp1342_;
						ValaCCodeExpression* _tmp1343_;
						ValaCCodeFunctionCall* _tmp1344_;
						_tmp1327_ = itype;
						_tmp1328_ = vala_data_type_get_return_type (_tmp1327_);
						_tmp1329_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1328_, TRUE, NULL, FALSE);
						temp_var = _tmp1329_;
						_tmp1330_ = temp_var;
						_tmp1331_ = vala_symbol_get_name ((ValaSymbol*) _tmp1330_);
						_tmp1332_ = _tmp1331_;
						_tmp1333_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1332_);
						temp_ref = _tmp1333_;
						_tmp1334_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1334_, FALSE);
						_tmp1335_ = temp_ref;
						_tmp1336_ = ccall_expr;
						_tmp1337_ = vala_ccode_assignment_new (_tmp1335_, _tmp1336_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1337_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1338_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1339_ = _tmp1338_;
						_tmp1340_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1339_);
						_tmp1341_ = _tmp1340_;
						_vala_ccode_node_unref0 (_tmp1339_);
						len_call = _tmp1341_;
						_tmp1342_ = len_call;
						_tmp1343_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1342_, _tmp1343_);
						_tmp1344_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1344_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1345_;
						_tmp1345_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1345_)) {
							gchar* _tmp1346_ = NULL;
							ValaMethod* _tmp1347_;
							gchar* _tmp1348_;
							gchar* length_ctype = NULL;
							gchar* _tmp1351_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1352_;
							ValaCType* _tmp1353_;
							ValaCType* _tmp1354_;
							ValaLocalVariable* _tmp1355_;
							ValaLocalVariable* _tmp1356_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1357_;
							const gchar* _tmp1358_;
							const gchar* _tmp1359_;
							ValaCCodeExpression* _tmp1360_;
							ValaLocalVariable* _tmp1361_;
							ValaHashMap* _tmp1362_;
							ValaMethod* _tmp1363_;
							ValaCCodeExpression* _tmp1364_;
							ValaCCodeUnaryExpression* _tmp1365_;
							ValaCCodeUnaryExpression* _tmp1366_;
							ValaCCodeExpression* _tmp1367_;
							_tmp1347_ = m;
							_tmp1348_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1347_);
							_tmp1346_ = _tmp1348_;
							if (_tmp1346_ == NULL) {
								ValaArrayType* _tmp1349_;
								gchar* _tmp1350_;
								_tmp1349_ = array_type;
								_tmp1350_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1349_);
								_g_free0 (_tmp1346_);
								_tmp1346_ = _tmp1350_;
							}
							_tmp1351_ = _tmp1346_;
							_tmp1346_ = NULL;
							length_ctype = _tmp1351_;
							_tmp1352_ = length_ctype;
							_tmp1353_ = vala_ctype_new (_tmp1352_, "0");
							_tmp1354_ = _tmp1353_;
							_tmp1355_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1354_, TRUE, NULL, TRUE);
							_tmp1356_ = _tmp1355_;
							_vala_code_node_unref0 (_tmp1354_);
							temp_var = _tmp1356_;
							_tmp1357_ = temp_var;
							_tmp1358_ = vala_symbol_get_name ((ValaSymbol*) _tmp1357_);
							_tmp1359_ = _tmp1358_;
							_tmp1360_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1359_);
							temp_ref = _tmp1360_;
							_tmp1361_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1361_, FALSE);
							_tmp1362_ = out_arg_map;
							_tmp1363_ = m;
							_tmp1364_ = temp_ref;
							_tmp1365_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1364_);
							_tmp1366_ = _tmp1365_;
							vala_map_set ((ValaMap*) _tmp1362_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1363_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1366_);
							_vala_ccode_node_unref0 (_tmp1366_);
							_tmp1367_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1367_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1346_);
						} else {
							ValaMethod* _tmp1368_;
							gchar* _tmp1369_;
							gchar* _tmp1370_;
							gboolean _tmp1371_;
							_tmp1368_ = m;
							_tmp1369_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1368_);
							_tmp1370_ = _tmp1369_;
							_tmp1371_ = _tmp1370_ != NULL;
							_g_free0 (_tmp1370_);
							if (_tmp1371_) {
								ValaMethod* _tmp1372_;
								gchar* _tmp1373_;
								gchar* _tmp1374_;
								ValaCCodeConstant* _tmp1375_;
								ValaCCodeConstant* _tmp1376_;
								_tmp1372_ = m;
								_tmp1373_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1372_);
								_tmp1374_ = _tmp1373_;
								_tmp1375_ = vala_ccode_constant_new (_tmp1374_);
								_tmp1376_ = _tmp1375_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1376_);
								_vala_ccode_node_unref0 (_tmp1376_);
								_g_free0 (_tmp1374_);
							} else {
								ValaCCodeConstant* _tmp1377_;
								ValaCCodeConstant* _tmp1378_;
								_tmp1377_ = vala_ccode_constant_new ("-1");
								_tmp1378_ = _tmp1377_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1378_);
								_vala_ccode_node_unref0 (_tmp1378_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1379_ = FALSE;
		gboolean _tmp1380_ = FALSE;
		ValaMethod* _tmp1381_;
		_tmp1381_ = m;
		if (_tmp1381_ != NULL) {
			ValaMethod* _tmp1382_;
			ValaDataType* _tmp1383_;
			ValaDataType* _tmp1384_;
			_tmp1382_ = m;
			_tmp1383_ = vala_callable_get_return_type ((ValaCallable*) _tmp1382_);
			_tmp1384_ = _tmp1383_;
			_tmp1380_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1384_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1380_ = FALSE;
		}
		if (_tmp1380_) {
			ValaCCodeFunctionCall* _tmp1385_;
			ValaCCodeFunctionCall* _tmp1386_;
			_tmp1385_ = async_call;
			_tmp1386_ = ccall;
			_tmp1379_ = _tmp1385_ != _tmp1386_;
		} else {
			_tmp1379_ = FALSE;
		}
		if (_tmp1379_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaDataType* _tmp1389_;
			ValaDelegateType* _tmp1390_;
			ValaDelegateType* _tmp1391_;
			ValaDelegate* _tmp1392_;
			ValaDelegate* _tmp1393_;
			gboolean _tmp1394_;
			gboolean _tmp1395_;
			_tmp1387_ = m;
			_tmp1388_ = vala_callable_get_return_type ((ValaCallable*) _tmp1387_);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1389_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1390_;
			_tmp1391_ = deleg_type;
			_tmp1392_ = vala_delegate_type_get_delegate_symbol (_tmp1391_);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_delegate_get_has_target (_tmp1393_);
			_tmp1395_ = _tmp1394_;
			if (_tmp1395_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1396_;
				ValaVoidType* _tmp1397_;
				ValaPointerType* _tmp1398_;
				ValaPointerType* _tmp1399_;
				ValaLocalVariable* _tmp1400_;
				ValaLocalVariable* _tmp1401_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1402_;
				const gchar* _tmp1403_;
				const gchar* _tmp1404_;
				ValaCCodeExpression* _tmp1405_;
				ValaLocalVariable* _tmp1406_;
				ValaHashMap* _tmp1407_;
				ValaMethod* _tmp1408_;
				ValaCCodeExpression* _tmp1409_;
				ValaCCodeUnaryExpression* _tmp1410_;
				ValaCCodeUnaryExpression* _tmp1411_;
				ValaCCodeExpression* _tmp1412_;
				ValaDelegateType* _tmp1413_;
				_tmp1396_ = vala_void_type_new (NULL);
				_tmp1397_ = _tmp1396_;
				_tmp1398_ = vala_pointer_type_new ((ValaDataType*) _tmp1397_, NULL);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1399_, TRUE, NULL, TRUE);
				_tmp1401_ = _tmp1400_;
				_vala_code_node_unref0 (_tmp1399_);
				_vala_code_node_unref0 (_tmp1397_);
				temp_var = _tmp1401_;
				_tmp1402_ = temp_var;
				_tmp1403_ = vala_symbol_get_name ((ValaSymbol*) _tmp1402_);
				_tmp1404_ = _tmp1403_;
				_tmp1405_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1404_);
				temp_ref = _tmp1405_;
				_tmp1406_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1406_, FALSE);
				_tmp1407_ = out_arg_map;
				_tmp1408_ = m;
				_tmp1409_ = temp_ref;
				_tmp1410_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1409_);
				_tmp1411_ = _tmp1410_;
				vala_map_set ((ValaMap*) _tmp1407_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1408_), FALSE)), (ValaCCodeExpression*) _tmp1411_);
				_vala_ccode_node_unref0 (_tmp1411_);
				_tmp1412_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1412_);
				_tmp1413_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1413_)) {
					ValaDataType* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					ValaLocalVariable* _tmp1416_;
					const gchar* _tmp1417_;
					const gchar* _tmp1418_;
					ValaCCodeExpression* _tmp1419_;
					ValaLocalVariable* _tmp1420_;
					ValaHashMap* _tmp1421_;
					ValaMethod* _tmp1422_;
					ValaCCodeExpression* _tmp1423_;
					ValaCCodeUnaryExpression* _tmp1424_;
					ValaCCodeUnaryExpression* _tmp1425_;
					ValaCCodeExpression* _tmp1426_;
					_tmp1414_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1415_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1414_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1415_;
					_tmp1416_ = temp_var;
					_tmp1417_ = vala_symbol_get_name ((ValaSymbol*) _tmp1416_);
					_tmp1418_ = _tmp1417_;
					_tmp1419_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1418_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1419_;
					_tmp1420_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1420_, FALSE);
					_tmp1421_ = out_arg_map;
					_tmp1422_ = m;
					_tmp1423_ = temp_ref;
					_tmp1424_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1423_);
					_tmp1425_ = _tmp1424_;
					vala_map_set ((ValaMap*) _tmp1421_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1422_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1425_);
					_vala_ccode_node_unref0 (_tmp1425_);
					_tmp1426_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1426_);
				} else {
					ValaCCodeConstant* _tmp1427_;
					ValaCCodeConstant* _tmp1428_;
					_tmp1427_ = vala_ccode_constant_new ("NULL");
					_tmp1428_ = _tmp1427_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1428_);
					_vala_ccode_node_unref0 (_tmp1428_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1429_;
				ValaCCodeConstant* _tmp1430_;
				_tmp1429_ = vala_ccode_constant_new ("NULL");
				_tmp1430_ = _tmp1429_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1430_);
				_vala_ccode_node_unref0 (_tmp1430_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1432_ = deleg;
	if (_tmp1432_ != NULL) {
		ValaDelegate* _tmp1433_;
		ValaDataType* _tmp1434_;
		ValaDataType* _tmp1435_;
		_tmp1433_ = deleg;
		_tmp1434_ = vala_callable_get_return_type ((ValaCallable*) _tmp1433_);
		_tmp1435_ = _tmp1434_;
		_tmp1431_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1435_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1431_ = FALSE;
	}
	if (_tmp1431_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1436_;
		ValaDataType* _tmp1437_;
		ValaDataType* _tmp1438_;
		ValaArrayType* _tmp1439_;
		_tmp1436_ = deleg;
		_tmp1437_ = vala_callable_get_return_type ((ValaCallable*) _tmp1436_);
		_tmp1438_ = _tmp1437_;
		_tmp1439_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1438_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1439_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1440_ = FALSE;
				_tmp1440_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1442_;
					gint _tmp1443_;
					gint _tmp1444_;
					ValaDelegate* _tmp1445_;
					if (!_tmp1440_) {
						gint _tmp1441_;
						_tmp1441_ = dim;
						dim = _tmp1441_ + 1;
					}
					_tmp1440_ = FALSE;
					_tmp1442_ = array_type;
					_tmp1443_ = vala_array_type_get_rank (_tmp1442_);
					_tmp1444_ = _tmp1443_;
					if (!(dim <= _tmp1444_)) {
						break;
					}
					_tmp1445_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1445_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1446_;
						ValaDataType* _tmp1447_;
						ValaLocalVariable* _tmp1448_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1449_;
						const gchar* _tmp1450_;
						const gchar* _tmp1451_;
						ValaCCodeExpression* _tmp1452_;
						ValaLocalVariable* _tmp1453_;
						ValaCCodeExpression* _tmp1454_;
						ValaCCodeExpression* _tmp1455_;
						ValaCCodeAssignment* _tmp1456_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1457_;
						ValaCCodeIdentifier* _tmp1458_;
						ValaCCodeFunctionCall* _tmp1459_;
						ValaCCodeFunctionCall* _tmp1460_;
						ValaCCodeFunctionCall* _tmp1461_;
						ValaCCodeExpression* _tmp1462_;
						ValaCCodeFunctionCall* _tmp1463_;
						_tmp1446_ = itype;
						_tmp1447_ = vala_data_type_get_return_type (_tmp1446_);
						_tmp1448_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1447_, TRUE, NULL, FALSE);
						temp_var = _tmp1448_;
						_tmp1449_ = temp_var;
						_tmp1450_ = vala_symbol_get_name ((ValaSymbol*) _tmp1449_);
						_tmp1451_ = _tmp1450_;
						_tmp1452_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1451_);
						temp_ref = _tmp1452_;
						_tmp1453_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1453_, FALSE);
						_tmp1454_ = temp_ref;
						_tmp1455_ = ccall_expr;
						_tmp1456_ = vala_ccode_assignment_new (_tmp1454_, _tmp1455_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1456_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1457_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1458_ = _tmp1457_;
						_tmp1459_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1458_);
						_tmp1460_ = _tmp1459_;
						_vala_ccode_node_unref0 (_tmp1458_);
						len_call = _tmp1460_;
						_tmp1461_ = len_call;
						_tmp1462_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1461_, _tmp1462_);
						_tmp1463_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1463_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1464_;
						_tmp1464_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1464_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1465_;
							ValaDataType* _tmp1466_;
							ValaDataType* _tmp1467_;
							ValaLocalVariable* _tmp1468_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1469_;
							const gchar* _tmp1470_;
							const gchar* _tmp1471_;
							ValaCCodeExpression* _tmp1472_;
							ValaLocalVariable* _tmp1473_;
							ValaHashMap* _tmp1474_;
							ValaDelegate* _tmp1475_;
							ValaCCodeExpression* _tmp1476_;
							ValaCCodeUnaryExpression* _tmp1477_;
							ValaCCodeUnaryExpression* _tmp1478_;
							ValaCCodeExpression* _tmp1479_;
							_tmp1465_ = array_type;
							_tmp1466_ = vala_array_type_get_length_type (_tmp1465_);
							_tmp1467_ = _tmp1466_;
							_tmp1468_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1467_, TRUE, NULL, TRUE);
							temp_var = _tmp1468_;
							_tmp1469_ = temp_var;
							_tmp1470_ = vala_symbol_get_name ((ValaSymbol*) _tmp1469_);
							_tmp1471_ = _tmp1470_;
							_tmp1472_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1471_);
							temp_ref = _tmp1472_;
							_tmp1473_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1473_, FALSE);
							_tmp1474_ = out_arg_map;
							_tmp1475_ = deleg;
							_tmp1476_ = temp_ref;
							_tmp1477_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1476_);
							_tmp1478_ = _tmp1477_;
							vala_map_set ((ValaMap*) _tmp1474_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1475_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1478_);
							_vala_ccode_node_unref0 (_tmp1478_);
							_tmp1479_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1479_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1480_;
							ValaCCodeConstant* _tmp1481_;
							_tmp1480_ = vala_ccode_constant_new ("-1");
							_tmp1481_ = _tmp1480_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1481_);
							_vala_ccode_node_unref0 (_tmp1481_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1482_ = FALSE;
		ValaDelegate* _tmp1483_;
		_tmp1483_ = deleg;
		if (_tmp1483_ != NULL) {
			ValaDelegate* _tmp1484_;
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			_tmp1484_ = deleg;
			_tmp1485_ = vala_callable_get_return_type ((ValaCallable*) _tmp1484_);
			_tmp1486_ = _tmp1485_;
			_tmp1482_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1486_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1482_ = FALSE;
		}
		if (_tmp1482_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1487_;
			ValaDataType* _tmp1488_;
			ValaDataType* _tmp1489_;
			ValaDelegateType* _tmp1490_;
			ValaDelegateType* _tmp1491_;
			ValaDelegate* _tmp1492_;
			ValaDelegate* _tmp1493_;
			gboolean _tmp1494_;
			gboolean _tmp1495_;
			_tmp1487_ = deleg;
			_tmp1488_ = vala_callable_get_return_type ((ValaCallable*) _tmp1487_);
			_tmp1489_ = _tmp1488_;
			_tmp1490_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1489_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1490_;
			_tmp1491_ = deleg_type;
			_tmp1492_ = vala_delegate_type_get_delegate_symbol (_tmp1491_);
			_tmp1493_ = _tmp1492_;
			_tmp1494_ = vala_delegate_get_has_target (_tmp1493_);
			_tmp1495_ = _tmp1494_;
			if (_tmp1495_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1496_;
				ValaVoidType* _tmp1497_;
				ValaPointerType* _tmp1498_;
				ValaPointerType* _tmp1499_;
				ValaLocalVariable* _tmp1500_;
				ValaLocalVariable* _tmp1501_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1502_;
				const gchar* _tmp1503_;
				const gchar* _tmp1504_;
				ValaCCodeExpression* _tmp1505_;
				ValaLocalVariable* _tmp1506_;
				ValaHashMap* _tmp1507_;
				ValaDelegate* _tmp1508_;
				ValaCCodeExpression* _tmp1509_;
				ValaCCodeUnaryExpression* _tmp1510_;
				ValaCCodeUnaryExpression* _tmp1511_;
				ValaCCodeExpression* _tmp1512_;
				ValaDelegateType* _tmp1513_;
				_tmp1496_ = vala_void_type_new (NULL);
				_tmp1497_ = _tmp1496_;
				_tmp1498_ = vala_pointer_type_new ((ValaDataType*) _tmp1497_, NULL);
				_tmp1499_ = _tmp1498_;
				_tmp1500_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1499_, TRUE, NULL, TRUE);
				_tmp1501_ = _tmp1500_;
				_vala_code_node_unref0 (_tmp1499_);
				_vala_code_node_unref0 (_tmp1497_);
				temp_var = _tmp1501_;
				_tmp1502_ = temp_var;
				_tmp1503_ = vala_symbol_get_name ((ValaSymbol*) _tmp1502_);
				_tmp1504_ = _tmp1503_;
				_tmp1505_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1504_);
				temp_ref = _tmp1505_;
				_tmp1506_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1506_, FALSE);
				_tmp1507_ = out_arg_map;
				_tmp1508_ = deleg;
				_tmp1509_ = temp_ref;
				_tmp1510_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1509_);
				_tmp1511_ = _tmp1510_;
				vala_map_set ((ValaMap*) _tmp1507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1508_), FALSE)), (ValaCCodeExpression*) _tmp1511_);
				_vala_ccode_node_unref0 (_tmp1511_);
				_tmp1512_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1512_);
				_tmp1513_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1513_)) {
					ValaDataType* _tmp1514_;
					ValaLocalVariable* _tmp1515_;
					ValaLocalVariable* _tmp1516_;
					const gchar* _tmp1517_;
					const gchar* _tmp1518_;
					ValaCCodeExpression* _tmp1519_;
					ValaLocalVariable* _tmp1520_;
					ValaHashMap* _tmp1521_;
					ValaDelegate* _tmp1522_;
					ValaCCodeExpression* _tmp1523_;
					ValaCCodeUnaryExpression* _tmp1524_;
					ValaCCodeUnaryExpression* _tmp1525_;
					ValaCCodeExpression* _tmp1526_;
					_tmp1514_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1515_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1514_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1515_;
					_tmp1516_ = temp_var;
					_tmp1517_ = vala_symbol_get_name ((ValaSymbol*) _tmp1516_);
					_tmp1518_ = _tmp1517_;
					_tmp1519_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1518_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1519_;
					_tmp1520_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1520_, FALSE);
					_tmp1521_ = out_arg_map;
					_tmp1522_ = deleg;
					_tmp1523_ = temp_ref;
					_tmp1524_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1523_);
					_tmp1525_ = _tmp1524_;
					vala_map_set ((ValaMap*) _tmp1521_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1522_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1525_);
					_vala_ccode_node_unref0 (_tmp1525_);
					_tmp1526_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1526_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1528_ = m;
	if (_tmp1528_ != NULL) {
		ValaMethod* _tmp1529_;
		gboolean _tmp1530_;
		gboolean _tmp1531_;
		_tmp1529_ = m;
		_tmp1530_ = vala_method_get_coroutine (_tmp1529_);
		_tmp1531_ = _tmp1530_;
		_tmp1527_ = _tmp1531_;
	} else {
		_tmp1527_ = FALSE;
	}
	if (_tmp1527_) {
		gboolean _tmp1532_;
		gboolean _tmp1533_;
		_tmp1532_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1533_ = _tmp1532_;
		if (_tmp1533_) {
			ValaHashMap* _tmp1534_;
			ValaMethod* _tmp1535_;
			ValaMethod* _tmp1536_;
			gchar* _tmp1537_;
			gchar* _tmp1538_;
			ValaCCodeIdentifier* _tmp1539_;
			ValaCCodeIdentifier* _tmp1540_;
			ValaHashMap* _tmp1541_;
			ValaCCodeIdentifier* _tmp1542_;
			ValaCCodeIdentifier* _tmp1543_;
			_tmp1534_ = in_arg_map;
			_tmp1535_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1536_ = _tmp1535_;
			_tmp1537_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1536_);
			_tmp1538_ = _tmp1537_;
			_tmp1539_ = vala_ccode_identifier_new (_tmp1538_);
			_tmp1540_ = _tmp1539_;
			vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1540_);
			_vala_ccode_node_unref0 (_tmp1540_);
			_g_free0 (_tmp1538_);
			_tmp1541_ = in_arg_map;
			_tmp1542_ = vala_ccode_identifier_new ("_data_");
			_tmp1543_ = _tmp1542_;
			vala_map_set ((ValaMap*) _tmp1541_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1543_);
			_vala_ccode_node_unref0 (_tmp1543_);
		}
	}
	_tmp1544_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1545_ = _tmp1544_;
	if (_tmp1545_) {
		ValaCallable* _tmp1546_ = NULL;
		ValaMethod* _tmp1547_;
		ValaHashMap* _tmp1549_;
		ValaCCodeExpression* _tmp1550_;
		ValaCCodeExpression* _tmp1551_;
		ValaCCodeUnaryExpression* _tmp1552_;
		ValaCCodeUnaryExpression* _tmp1553_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1547_ = m;
		_tmp1546_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1547_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1546_ == NULL) {
			ValaDelegate* _tmp1548_;
			_tmp1548_ = deleg;
			_tmp1546_ = (ValaCallable*) _tmp1548_;
		}
		_tmp1549_ = out_arg_map;
		_tmp1550_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1551_ = _tmp1550_;
		_tmp1552_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1551_);
		_tmp1553_ = _tmp1552_;
		vala_map_set ((ValaMap*) _tmp1549_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1546_), FALSE)), (ValaCCodeExpression*) _tmp1553_);
		_vala_ccode_node_unref0 (_tmp1553_);
		_vala_ccode_node_unref0 (_tmp1551_);
	} else {
		gboolean _tmp1554_ = FALSE;
		gboolean _tmp1555_ = FALSE;
		ValaMethod* _tmp1556_;
		_tmp1556_ = m;
		if (_tmp1556_ != NULL) {
			ValaMethod* _tmp1557_;
			_tmp1557_ = m;
			_tmp1555_ = vala_method_has_error_type_parameter (_tmp1557_);
		} else {
			_tmp1555_ = FALSE;
		}
		if (_tmp1555_) {
			ValaCCodeFunctionCall* _tmp1558_;
			ValaCCodeFunctionCall* _tmp1559_;
			_tmp1558_ = async_call;
			_tmp1559_ = ccall;
			_tmp1554_ = _tmp1558_ != _tmp1559_;
		} else {
			_tmp1554_ = FALSE;
		}
		if (_tmp1554_) {
			ValaHashMap* _tmp1560_;
			ValaMethod* _tmp1561_;
			ValaCCodeConstant* _tmp1562_;
			ValaCCodeConstant* _tmp1563_;
			_tmp1560_ = out_arg_map;
			_tmp1561_ = m;
			_tmp1562_ = vala_ccode_constant_new ("NULL");
			_tmp1563_ = _tmp1562_;
			vala_map_set ((ValaMap*) _tmp1560_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1561_), FALSE)), (ValaCCodeExpression*) _tmp1563_);
			_vala_ccode_node_unref0 (_tmp1563_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1564_;
		_tmp1564_ = m;
		if (_tmp1564_ == NULL) {
			ValaHashMap* _tmp1565_;
			ValaCCodeConstant* _tmp1566_;
			ValaCCodeConstant* _tmp1567_;
			_tmp1565_ = in_arg_map;
			_tmp1566_ = vala_ccode_constant_new ("NULL");
			_tmp1567_ = _tmp1566_;
			vala_map_set ((ValaMap*) _tmp1565_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1567_);
			_vala_ccode_node_unref0 (_tmp1567_);
		} else {
			gboolean _tmp1568_ = FALSE;
			gboolean _tmp1569_ = FALSE;
			gboolean _tmp1570_ = FALSE;
			ValaMethod* _tmp1571_;
			gboolean _tmp1572_;
			gboolean _tmp1573_;
			_tmp1571_ = m;
			_tmp1572_ = vala_method_get_printf_format (_tmp1571_);
			_tmp1573_ = _tmp1572_;
			if (!_tmp1573_) {
				ValaMethod* _tmp1574_;
				gboolean _tmp1575_;
				gboolean _tmp1576_;
				_tmp1574_ = m;
				_tmp1575_ = vala_method_get_scanf_format (_tmp1574_);
				_tmp1576_ = _tmp1575_;
				_tmp1570_ = !_tmp1576_;
			} else {
				_tmp1570_ = FALSE;
			}
			if (_tmp1570_) {
				ValaMethod* _tmp1577_;
				gchar* _tmp1578_;
				gchar* _tmp1579_;
				_tmp1577_ = m;
				_tmp1578_ = vala_get_ccode_sentinel (_tmp1577_);
				_tmp1579_ = _tmp1578_;
				_tmp1569_ = g_strcmp0 (_tmp1579_, "") != 0;
				_g_free0 (_tmp1579_);
			} else {
				_tmp1569_ = FALSE;
			}
			if (_tmp1569_) {
				gboolean _tmp1580_;
				gboolean _tmp1581_;
				_tmp1580_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1581_ = _tmp1580_;
				_tmp1568_ = !_tmp1581_;
			} else {
				_tmp1568_ = FALSE;
			}
			if (_tmp1568_) {
				ValaHashMap* _tmp1582_;
				ValaMethod* _tmp1583_;
				gchar* _tmp1584_;
				gchar* _tmp1585_;
				ValaCCodeConstant* _tmp1586_;
				ValaCCodeConstant* _tmp1587_;
				_tmp1582_ = in_arg_map;
				_tmp1583_ = m;
				_tmp1584_ = vala_get_ccode_sentinel (_tmp1583_);
				_tmp1585_ = _tmp1584_;
				_tmp1586_ = vala_ccode_constant_new (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				vala_map_set ((ValaMap*) _tmp1582_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1587_);
				_vala_ccode_node_unref0 (_tmp1587_);
				_g_free0 (_tmp1585_);
			}
		}
	}
	_tmp1588_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1588_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1589_;
		ValaDelegateType* _tmp1590_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1591_;
		ValaDelegate* _tmp1592_;
		ValaDelegate* _tmp1593_;
		ValaDelegate* _tmp1594_;
		ValaDelegate* _tmp1595_;
		gboolean _tmp1596_;
		gboolean _tmp1597_;
		_tmp1589_ = itype;
		_tmp1590_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1589_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1590_;
		_tmp1591_ = deleg_type;
		_tmp1592_ = vala_delegate_type_get_delegate_symbol (_tmp1591_);
		_tmp1593_ = _tmp1592_;
		_tmp1594_ = _vala_code_node_ref0 (_tmp1593_);
		d = _tmp1594_;
		_tmp1595_ = d;
		_tmp1596_ = vala_delegate_get_has_target (_tmp1595_);
		_tmp1597_ = _tmp1596_;
		if (_tmp1597_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1598_;
			ValaDelegate* _tmp1599_;
			ValaExpression* _tmp1600_;
			ValaExpression* _tmp1601_;
			ValaCCodeExpression* _tmp1602_ = NULL;
			ValaCCodeExpression* _tmp1603_;
			ValaCCodeExpression* _tmp1604_;
			ValaHashMap* _tmp1605_;
			ValaDelegate* _tmp1606_;
			ValaExpression* _tmp1607_;
			ValaExpression* _tmp1608_;
			ValaCCodeExpression* _tmp1609_ = NULL;
			ValaCCodeExpression* _tmp1610_;
			ValaCCodeExpression* _tmp1611_;
			_tmp1598_ = in_arg_map;
			_tmp1599_ = d;
			_tmp1600_ = vala_method_call_get_call (expr);
			_tmp1601_ = _tmp1600_;
			_tmp1603_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1601_, &_tmp1602_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1602_;
			_tmp1604_ = _tmp1603_;
			vala_map_set ((ValaMap*) _tmp1598_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1599_), FALSE)), _tmp1604_);
			_vala_ccode_node_unref0 (_tmp1604_);
			_tmp1605_ = out_arg_map;
			_tmp1606_ = d;
			_tmp1607_ = vala_method_call_get_call (expr);
			_tmp1608_ = _tmp1607_;
			_tmp1610_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1608_, &_tmp1609_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1609_;
			_tmp1611_ = _tmp1610_;
			vala_map_set ((ValaMap*) _tmp1605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1606_), FALSE)), _tmp1611_);
			_vala_ccode_node_unref0 (_tmp1611_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1612_ = itype;
	_tmp1613_ = vala_data_type_get_return_type (_tmp1612_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1613_);
	_tmp1615_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1615_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1616_;
		ValaDataType* _tmp1617_;
		_tmp1616_ = itype;
		_tmp1617_ = vala_data_type_get_return_type (_tmp1616_);
		_tmp1614_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1617_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1614_ = FALSE;
	}
	if (_tmp1614_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1618_;
		ValaSignal* _tmp1619_;
		ValaSignal* _tmp1620_;
		ValaSignal* _tmp1621_;
		gboolean _tmp1622_ = FALSE;
		gboolean _tmp1623_ = FALSE;
		ValaMemberAccess* _tmp1624_;
		_tmp1618_ = itype;
		_tmp1619_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1618_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1620_ = _tmp1619_;
		_tmp1621_ = _vala_code_node_ref0 (_tmp1620_);
		sig = _tmp1621_;
		_tmp1624_ = ma;
		if (_tmp1624_ != NULL) {
			ValaMemberAccess* _tmp1625_;
			ValaExpression* _tmp1626_;
			ValaExpression* _tmp1627_;
			_tmp1625_ = ma;
			_tmp1626_ = vala_member_access_get_inner (_tmp1625_);
			_tmp1627_ = _tmp1626_;
			_tmp1623_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1627_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1623_ = FALSE;
		}
		if (_tmp1623_) {
			ValaSignal* _tmp1628_;
			gboolean _tmp1629_;
			gboolean _tmp1630_;
			_tmp1628_ = sig;
			_tmp1629_ = vala_signal_get_is_virtual (_tmp1628_);
			_tmp1630_ = _tmp1629_;
			_tmp1622_ = _tmp1630_;
		} else {
			_tmp1622_ = FALSE;
		}
		if (_tmp1622_) {
		} else {
			gboolean _tmp1631_ = FALSE;
			ValaSignal* _tmp1632_;
			_tmp1632_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1632_)) {
				_tmp1631_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1633_;
				ValaSourceReference* _tmp1634_;
				ValaSourceReference* _tmp1635_;
				ValaSourceFile* _tmp1636_;
				ValaSourceFile* _tmp1637_;
				ValaSignal* _tmp1638_;
				ValaSourceReference* _tmp1639_;
				ValaSourceReference* _tmp1640_;
				ValaSourceFile* _tmp1641_;
				ValaSourceFile* _tmp1642_;
				_tmp1633_ = ma;
				_tmp1634_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1636_ = vala_source_reference_get_file (_tmp1635_);
				_tmp1637_ = _tmp1636_;
				_tmp1638_ = sig;
				_tmp1639_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1638_);
				_tmp1640_ = _tmp1639_;
				_tmp1641_ = vala_source_reference_get_file (_tmp1640_);
				_tmp1642_ = _tmp1641_;
				_tmp1631_ = _tmp1637_ == _tmp1642_;
			}
			if (_tmp1631_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1643_ = async_call;
	_tmp1644_ = ccall;
	if (_tmp1643_ == _tmp1644_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1645_;
		ValaDataType* _tmp1646_;
		ValaLocalVariable* _tmp1647_;
		ValaLocalVariable* _tmp1648_;
		const gchar* _tmp1649_;
		const gchar* _tmp1650_;
		ValaCCodeExpression* _tmp1651_;
		ValaLocalVariable* _tmp1652_;
		ValaHashMap* _tmp1653_;
		ValaCCodeExpression* _tmp1654_;
		ValaCCodeUnaryExpression* _tmp1655_;
		ValaCCodeUnaryExpression* _tmp1656_;
		_tmp1645_ = itype;
		_tmp1646_ = vala_data_type_get_return_type (_tmp1645_);
		_tmp1647_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1646_, TRUE, NULL, TRUE);
		out_param_var = _tmp1647_;
		_tmp1648_ = out_param_var;
		_tmp1649_ = vala_symbol_get_name ((ValaSymbol*) _tmp1648_);
		_tmp1650_ = _tmp1649_;
		_tmp1651_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1650_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1651_;
		_tmp1652_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1652_, FALSE);
		_tmp1653_ = out_arg_map;
		_tmp1654_ = out_param_ref;
		_tmp1655_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1654_);
		_tmp1656_ = _tmp1655_;
		vala_map_set ((ValaMap*) _tmp1653_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1656_);
		_vala_ccode_node_unref0 (_tmp1656_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1657_ = async_call;
	_tmp1658_ = ccall;
	if (_tmp1657_ != _tmp1658_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1669_;
			ValaHashMap* _tmp1670_;
			gpointer _tmp1671_;
			ValaCCodeExpression* _tmp1672_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1659_;
				ValaSet* _tmp1660_;
				ValaSet* _tmp1661_;
				ValaIterator* _tmp1662_;
				ValaIterator* _tmp1663_;
				_tmp1659_ = out_arg_map;
				_tmp1660_ = vala_map_get_keys ((ValaMap*) _tmp1659_);
				_tmp1661_ = _tmp1660_;
				_tmp1662_ = vala_iterable_iterator ((ValaIterable*) _tmp1661_);
				_tmp1663_ = _tmp1662_;
				_vala_iterable_unref0 (_tmp1661_);
				_pos_it = _tmp1663_;
				while (TRUE) {
					ValaIterator* _tmp1664_;
					gint pos = 0;
					ValaIterator* _tmp1665_;
					gpointer _tmp1666_;
					gboolean _tmp1667_ = FALSE;
					_tmp1664_ = _pos_it;
					if (!vala_iterator_next (_tmp1664_)) {
						break;
					}
					_tmp1665_ = _pos_it;
					_tmp1666_ = vala_iterator_get (_tmp1665_);
					pos = (gint) ((gintptr) _tmp1666_);
					if (pos > last_pos) {
						gboolean _tmp1668_ = FALSE;
						if (min_pos == -1) {
							_tmp1668_ = TRUE;
						} else {
							_tmp1668_ = pos < min_pos;
						}
						_tmp1667_ = _tmp1668_;
					} else {
						_tmp1667_ = FALSE;
					}
					if (_tmp1667_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1669_ = ccall;
			_tmp1670_ = out_arg_map;
			_tmp1671_ = vala_map_get ((ValaMap*) _tmp1670_, (gpointer) ((gintptr) min_pos));
			_tmp1672_ = (ValaCCodeExpression*) _tmp1671_;
			vala_ccode_function_call_add_argument (_tmp1669_, _tmp1672_);
			_vala_ccode_node_unref0 (_tmp1672_);
			last_pos = min_pos;
		}
	}
	_tmp1673_ = async_call;
	if (_tmp1673_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1684_;
			ValaHashMap* _tmp1685_;
			gpointer _tmp1686_;
			ValaCCodeExpression* _tmp1687_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1674_;
				ValaSet* _tmp1675_;
				ValaSet* _tmp1676_;
				ValaIterator* _tmp1677_;
				ValaIterator* _tmp1678_;
				_tmp1674_ = in_arg_map;
				_tmp1675_ = vala_map_get_keys ((ValaMap*) _tmp1674_);
				_tmp1676_ = _tmp1675_;
				_tmp1677_ = vala_iterable_iterator ((ValaIterable*) _tmp1676_);
				_tmp1678_ = _tmp1677_;
				_vala_iterable_unref0 (_tmp1676_);
				_pos_it = _tmp1678_;
				while (TRUE) {
					ValaIterator* _tmp1679_;
					gint pos = 0;
					ValaIterator* _tmp1680_;
					gpointer _tmp1681_;
					gboolean _tmp1682_ = FALSE;
					_tmp1679_ = _pos_it;
					if (!vala_iterator_next (_tmp1679_)) {
						break;
					}
					_tmp1680_ = _pos_it;
					_tmp1681_ = vala_iterator_get (_tmp1680_);
					pos = (gint) ((gintptr) _tmp1681_);
					if (pos > last_pos) {
						gboolean _tmp1683_ = FALSE;
						if (min_pos == -1) {
							_tmp1683_ = TRUE;
						} else {
							_tmp1683_ = pos < min_pos;
						}
						_tmp1682_ = _tmp1683_;
					} else {
						_tmp1682_ = FALSE;
					}
					if (_tmp1682_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1684_ = async_call;
			_tmp1685_ = in_arg_map;
			_tmp1686_ = vala_map_get ((ValaMap*) _tmp1685_, (gpointer) ((gintptr) min_pos));
			_tmp1687_ = (ValaCCodeExpression*) _tmp1686_;
			vala_ccode_function_call_add_argument (_tmp1684_, _tmp1687_);
			_vala_ccode_node_unref0 (_tmp1687_);
			last_pos = min_pos;
		}
	}
	_tmp1688_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1689_ = _tmp1688_;
	if (_tmp1689_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1690_;
		gint _tmp1691_;
		ValaCCodeFunction* _tmp1692_;
		ValaCCodeFunction* _tmp1693_;
		ValaCCodeIdentifier* _tmp1694_;
		ValaCCodeIdentifier* _tmp1695_;
		ValaCCodeMemberAccess* _tmp1696_;
		ValaCCodeMemberAccess* _tmp1697_;
		gchar* _tmp1698_;
		gchar* _tmp1699_;
		ValaCCodeConstant* _tmp1700_;
		ValaCCodeConstant* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeFunction* _tmp1703_;
		ValaCCodeFunctionCall* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeFunction* _tmp1706_;
		ValaCCodeConstant* _tmp1707_;
		ValaCCodeConstant* _tmp1708_;
		ValaCCodeFunction* _tmp1709_;
		ValaCCodeFunction* _tmp1710_;
		gchar* _tmp1711_;
		gchar* _tmp1712_;
		_tmp1690_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1691_ = _tmp1690_->next_coroutine_state;
		_tmp1690_->next_coroutine_state = _tmp1691_ + 1;
		state = _tmp1691_;
		_tmp1692_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = vala_ccode_identifier_new ("_data_");
		_tmp1695_ = _tmp1694_;
		_tmp1696_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1695_, "_state_");
		_tmp1697_ = _tmp1696_;
		_tmp1698_ = g_strdup_printf ("%i", state);
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = vala_ccode_constant_new (_tmp1699_);
		_tmp1701_ = _tmp1700_;
		vala_ccode_function_add_assignment (_tmp1693_, (ValaCCodeExpression*) _tmp1697_, (ValaCCodeExpression*) _tmp1701_);
		_vala_ccode_node_unref0 (_tmp1701_);
		_g_free0 (_tmp1699_);
		_vala_ccode_node_unref0 (_tmp1697_);
		_vala_ccode_node_unref0 (_tmp1695_);
		_tmp1702_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1703_ = _tmp1702_;
		_tmp1704_ = async_call;
		vala_ccode_function_add_expression (_tmp1703_, (ValaCCodeExpression*) _tmp1704_);
		_tmp1705_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1706_ = _tmp1705_;
		_tmp1707_ = vala_ccode_constant_new ("FALSE");
		_tmp1708_ = _tmp1707_;
		vala_ccode_function_add_return (_tmp1706_, (ValaCCodeExpression*) _tmp1708_);
		_vala_ccode_node_unref0 (_tmp1708_);
		_tmp1709_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1710_ = _tmp1709_;
		_tmp1711_ = g_strdup_printf ("_state_%d", state);
		_tmp1712_ = _tmp1711_;
		vala_ccode_function_add_label (_tmp1710_, _tmp1712_);
		_g_free0 (_tmp1712_);
	}
	_tmp1713_ = vala_method_call_get_is_assert (expr);
	_tmp1714_ = _tmp1713_;
	if (_tmp1714_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1715_;
		ValaSourceReference* _tmp1716_;
		ValaSourceLocation _tmp1717_ = {0};
		ValaSourceLocation _tmp1718_;
		gchar* _tmp1719_;
		ValaSourceReference* _tmp1720_;
		ValaSourceReference* _tmp1721_;
		ValaSourceLocation _tmp1722_ = {0};
		ValaSourceLocation _tmp1723_;
		gchar* _tmp1724_;
		ValaSourceReference* _tmp1725_;
		ValaSourceReference* _tmp1726_;
		ValaSourceLocation _tmp1727_ = {0};
		ValaSourceLocation _tmp1728_;
		gchar* _tmp1729_;
		gchar* _tmp1730_;
		ValaCCodeFunctionCall* _tmp1731_;
		ValaCCodeIdentifier* _tmp1732_;
		ValaCCodeIdentifier* _tmp1733_;
		ValaCCodeFunctionCall* _tmp1734_;
		const gchar* _tmp1735_;
		gchar* _tmp1736_;
		gchar* _tmp1737_;
		gchar* _tmp1738_;
		gchar* _tmp1739_;
		gchar* _tmp1740_;
		gchar* _tmp1741_;
		ValaCCodeConstant* _tmp1742_;
		ValaCCodeConstant* _tmp1743_;
		_tmp1715_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1716_ = _tmp1715_;
		vala_source_reference_get_begin (_tmp1716_, &_tmp1717_);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = _tmp1718_.pos;
		_tmp1720_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1721_ = _tmp1720_;
		vala_source_reference_get_end (_tmp1721_, &_tmp1722_);
		_tmp1723_ = _tmp1722_;
		_tmp1724_ = _tmp1723_.pos;
		_tmp1725_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1726_ = _tmp1725_;
		vala_source_reference_get_begin (_tmp1726_, &_tmp1727_);
		_tmp1728_ = _tmp1727_;
		_tmp1729_ = _tmp1728_.pos;
		_tmp1730_ = string_substring ((const gchar*) _tmp1719_, (glong) 0, (glong) ((gint) (_tmp1724_ - _tmp1729_)));
		message = _tmp1730_;
		_tmp1731_ = ccall;
		_tmp1732_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1733_ = _tmp1732_;
		vala_ccode_function_call_set_call (_tmp1731_, (ValaCCodeExpression*) _tmp1733_);
		_vala_ccode_node_unref0 (_tmp1733_);
		_tmp1734_ = ccall;
		_tmp1735_ = message;
		_tmp1736_ = string_replace (_tmp1735_, "\n", " ");
		_tmp1737_ = _tmp1736_;
		_tmp1738_ = g_strescape (_tmp1737_, "");
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = g_strdup_printf ("\"%s\"", _tmp1739_);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = vala_ccode_constant_new (_tmp1741_);
		_tmp1743_ = _tmp1742_;
		vala_ccode_function_call_add_argument (_tmp1734_, (ValaCCodeExpression*) _tmp1743_);
		_vala_ccode_node_unref0 (_tmp1743_);
		_g_free0 (_tmp1741_);
		_g_free0 (_tmp1739_);
		_g_free0 (_tmp1737_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1744_;
		ValaCCodeFunction* _tmp1745_;
		ValaCCodeExpression* _tmp1746_;
		ValaCCodeExpression* _tmp1747_;
		ValaCCodeExpression* _tmp1748_;
		_tmp1744_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1745_ = _tmp1744_;
		_tmp1746_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1745_, _tmp1746_);
		_tmp1747_ = out_param_ref;
		_tmp1748_ = _vala_ccode_node_ref0 (_tmp1747_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1748_;
	}
	_tmp1751_ = m;
	if (_tmp1751_ != NULL) {
		ValaMethod* _tmp1752_;
		ValaMemberBinding _tmp1753_;
		ValaMemberBinding _tmp1754_;
		_tmp1752_ = m;
		_tmp1753_ = vala_method_get_binding (_tmp1752_);
		_tmp1754_ = _tmp1753_;
		_tmp1750_ = _tmp1754_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1750_ = FALSE;
	}
	if (_tmp1750_) {
		ValaMethod* _tmp1755_;
		gboolean _tmp1756_;
		gboolean _tmp1757_;
		_tmp1755_ = m;
		_tmp1756_ = vala_method_get_returns_modified_pointer (_tmp1755_);
		_tmp1757_ = _tmp1756_;
		_tmp1749_ = _tmp1757_;
	} else {
		_tmp1749_ = FALSE;
	}
	if (_tmp1749_) {
		gboolean _tmp1758_ = FALSE;
		gboolean _tmp1759_ = FALSE;
		ValaMemberAccess* _tmp1760_;
		_tmp1760_ = ma;
		if (_tmp1760_ != NULL) {
			ValaMemberAccess* _tmp1761_;
			ValaExpression* _tmp1762_;
			ValaExpression* _tmp1763_;
			ValaSymbol* _tmp1764_;
			ValaSymbol* _tmp1765_;
			_tmp1761_ = ma;
			_tmp1762_ = vala_member_access_get_inner (_tmp1761_);
			_tmp1763_ = _tmp1762_;
			_tmp1764_ = vala_expression_get_symbol_reference (_tmp1763_);
			_tmp1765_ = _tmp1764_;
			_tmp1759_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1765_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1759_ = FALSE;
		}
		if (_tmp1759_) {
			ValaMemberAccess* _tmp1766_;
			ValaExpression* _tmp1767_;
			ValaExpression* _tmp1768_;
			_tmp1766_ = ma;
			_tmp1767_ = vala_member_access_get_inner (_tmp1766_);
			_tmp1768_ = _tmp1767_;
			_tmp1758_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1768_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1758_ = FALSE;
		}
		if (_tmp1758_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1769_;
			ValaExpression* _tmp1770_;
			ValaExpression* _tmp1771_;
			ValaSymbol* _tmp1772_;
			ValaSymbol* _tmp1773_;
			ValaProperty* _tmp1774_;
			ValaProperty* _tmp1775_;
			ValaMemberAccess* _tmp1776_;
			ValaExpression* _tmp1777_;
			ValaExpression* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaDataType* _tmp1781_;
			ValaDataType* _tmp1782_;
			ValaCCodeExpression* _tmp1783_;
			ValaGLibValue* _tmp1784_;
			ValaGLibValue* _tmp1785_;
			_tmp1769_ = ma;
			_tmp1770_ = vala_member_access_get_inner (_tmp1769_);
			_tmp1771_ = _tmp1770_;
			_tmp1772_ = vala_expression_get_symbol_reference (_tmp1771_);
			_tmp1773_ = _tmp1772_;
			_tmp1774_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1773_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1774_;
			_tmp1775_ = prop;
			_tmp1776_ = ma;
			_tmp1777_ = vala_member_access_get_inner (_tmp1776_);
			_tmp1778_ = _tmp1777_;
			_tmp1779_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1778_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1780_ = _tmp1779_;
			_tmp1781_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1782_ = _tmp1781_;
			_tmp1783_ = ccall_expr;
			_tmp1784_ = vala_glib_value_new (_tmp1782_, _tmp1783_, FALSE);
			_tmp1785_ = _tmp1784_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1775_, _tmp1780_, (ValaTargetValue*) _tmp1785_);
			_vala_target_value_unref0 (_tmp1785_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1786_;
			ValaCCodeExpression* _tmp1787_;
			ValaCCodeAssignment* _tmp1788_;
			_tmp1786_ = instance;
			_tmp1787_ = ccall_expr;
			_tmp1788_ = vala_ccode_assignment_new (_tmp1786_, _tmp1787_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1788_;
		}
	}
	_tmp1794_ = m;
	if (_tmp1794_ != NULL) {
		ValaMethod* _tmp1795_;
		_tmp1795_ = m;
		_tmp1793_ = vala_get_ccode_simple_generics (_tmp1795_);
	} else {
		_tmp1793_ = FALSE;
	}
	if (_tmp1793_) {
		ValaMethod* _tmp1796_;
		ValaDataType* _tmp1797_;
		ValaDataType* _tmp1798_;
		_tmp1796_ = m;
		_tmp1797_ = vala_callable_get_return_type ((ValaCallable*) _tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1792_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1798_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1792_ = FALSE;
	}
	if (_tmp1792_) {
		ValaDataType* _tmp1799_;
		ValaDataType* _tmp1800_;
		_tmp1799_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1800_ = _tmp1799_;
		_tmp1791_ = vala_data_type_is_real_struct_type (_tmp1800_);
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaDataType* _tmp1801_;
		ValaDataType* _tmp1802_;
		gboolean _tmp1803_;
		gboolean _tmp1804_;
		_tmp1801_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_data_type_get_nullable (_tmp1802_);
		_tmp1804_ = _tmp1803_;
		_tmp1790_ = !_tmp1804_;
	} else {
		_tmp1790_ = FALSE;
	}
	if (_tmp1790_) {
		ValaDataType* _tmp1805_;
		ValaDataType* _tmp1806_;
		_tmp1805_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1806_ = _tmp1805_;
		_tmp1789_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1806_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1789_ = FALSE;
	}
	if (_tmp1789_) {
		ValaCCodeExpression* _tmp1807_;
		ValaCCodeParenthesizedExpression* _tmp1808_;
		ValaCCodeParenthesizedExpression* _tmp1809_;
		ValaCCodeUnaryExpression* _tmp1810_;
		_tmp1807_ = ccall_expr;
		_tmp1808_ = vala_ccode_parenthesized_expression_new (_tmp1807_);
		_tmp1809_ = _tmp1808_;
		_tmp1810_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1809_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1810_;
		_vala_ccode_node_unref0 (_tmp1809_);
	}
	_tmp1813_ = m;
	if (_tmp1813_ != NULL) {
		ValaMethod* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		_tmp1814_ = m;
		_tmp1815_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1812_ = _tmp1816_ != NULL;
		_g_free0 (_tmp1816_);
	} else {
		_tmp1812_ = FALSE;
	}
	if (_tmp1812_) {
		ValaMethod* _tmp1817_;
		gchar* _tmp1818_;
		gchar* _tmp1819_;
		ValaMethod* _tmp1820_;
		ValaDataType* _tmp1821_;
		ValaDataType* _tmp1822_;
		gchar* _tmp1823_;
		gchar* _tmp1824_;
		_tmp1817_ = m;
		_tmp1818_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1817_);
		_tmp1819_ = _tmp1818_;
		_tmp1820_ = m;
		_tmp1821_ = vala_callable_get_return_type ((ValaCallable*) _tmp1820_);
		_tmp1822_ = _tmp1821_;
		_tmp1823_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1811_ = g_strcmp0 (_tmp1819_, _tmp1824_) != 0;
		_g_free0 (_tmp1824_);
		_g_free0 (_tmp1819_);
	} else {
		_tmp1811_ = FALSE;
	}
	if (_tmp1811_) {
		ValaCCodeExpression* _tmp1825_;
		ValaMethod* _tmp1826_;
		ValaDataType* _tmp1827_;
		ValaDataType* _tmp1828_;
		gchar* _tmp1829_;
		gchar* _tmp1830_;
		ValaCCodeCastExpression* _tmp1831_;
		_tmp1825_ = ccall_expr;
		_tmp1826_ = m;
		_tmp1827_ = vala_callable_get_return_type ((ValaCallable*) _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_tmp1829_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1828_);
		_tmp1830_ = _tmp1829_;
		_tmp1831_ = vala_ccode_cast_expression_new (_tmp1825_, _tmp1830_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1831_;
		_g_free0 (_tmp1830_);
	}
	_tmp1832_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1832_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1833_;
		ValaIterator* _tmp1834_;
		ValaIterator* _tmp1835_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1836_;
		gpointer _tmp1837_;
		ValaExpression* _tmp1838_;
		ValaCCodeExpression* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1841_;
		ValaLocalVariable* _tmp1842_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1843_;
		const gchar* _tmp1844_;
		const gchar* _tmp1845_;
		ValaCCodeExpression* _tmp1846_;
		ValaLocalVariable* _tmp1847_;
		ValaCCodeFile* _tmp1848_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1849_;
		ValaExpression* _tmp1850_;
		ValaExpression* _tmp1851_;
		ValaCCodeExpression* _tmp1852_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1853_;
		ValaExpression* _tmp1854_;
		ValaExpression* _tmp1855_;
		ValaCCodeExpression* _tmp1856_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaExpression* _tmp1859_;
		ValaDataType* _tmp1860_;
		ValaDataType* _tmp1861_;
		ValaArrayType* _tmp1862_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1863_;
		ValaDataType* _tmp1864_;
		ValaDataType* _tmp1865_;
		gchar* _tmp1866_;
		gchar* _tmp1867_;
		gchar* _tmp1868_;
		gchar* _tmp1869_;
		ValaCCodeIdentifier* _tmp1870_;
		ValaCCodeIdentifier* _tmp1871_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1872_;
		ValaCCodeExpression* _tmp1873_;
		ValaCCodeBinaryExpression* _tmp1874_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeExpression* _tmp1876_;
		ValaCCodeBinaryExpression* _tmp1877_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1878_;
		ValaCCodeIdentifier* _tmp1879_;
		ValaCCodeFunctionCall* _tmp1880_;
		ValaCCodeFunctionCall* _tmp1881_;
		ValaCCodeFunctionCall* _tmp1882_;
		ValaCCodeExpression* _tmp1883_;
		ValaCCodeExpression* _tmp1884_;
		ValaCCodeBinaryExpression* _tmp1885_;
		ValaCCodeBinaryExpression* _tmp1886_;
		ValaCCodeFunctionCall* _tmp1887_;
		ValaCCodeConstant* _tmp1888_;
		ValaCCodeConstant* _tmp1889_;
		ValaCCodeFunctionCall* _tmp1890_;
		ValaCCodeIdentifier* _tmp1891_;
		ValaCCodeBinaryExpression* _tmp1892_;
		ValaCCodeBinaryExpression* _tmp1893_;
		ValaCCodeBinaryExpression* _tmp1894_;
		ValaCCodeFunction* _tmp1895_;
		ValaCCodeFunction* _tmp1896_;
		ValaCCodeExpression* _tmp1897_;
		ValaCCodeExpression* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeExpression* _tmp1901_;
		ValaCCodeFunction* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeBinaryExpression* _tmp1904_;
		ValaCCodeFunctionCall* _tmp1905_;
		ValaCCodeConstant* _tmp1906_;
		ValaCCodeConstant* _tmp1907_;
		ValaCCodeConditionalExpression* _tmp1908_;
		ValaCCodeConditionalExpression* _tmp1909_;
		ValaCCodeFunction* _tmp1910_;
		ValaCCodeFunction* _tmp1911_;
		ValaMemberAccess* _tmp1912_;
		ValaExpression* _tmp1913_;
		ValaExpression* _tmp1914_;
		ValaCCodeExpression* _tmp1915_;
		ValaCCodeExpression* _tmp1916_;
		ValaCCodeExpression* _tmp1917_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1918_;
		ValaExpression* _tmp1919_;
		ValaExpression* _tmp1920_;
		ValaSymbol* _tmp1921_;
		ValaSymbol* _tmp1922_;
		ValaSymbol* _tmp1923_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1924_;
		ValaLocalVariable* _tmp1925_;
		gboolean _tmp1926_ = FALSE;
		gboolean _tmp1927_ = FALSE;
		ValaSymbol* _tmp1928_;
		_tmp1833_ = vala_method_call_get_argument_list (expr);
		_tmp1834_ = vala_iterable_iterator ((ValaIterable*) _tmp1833_);
		arg_it = _tmp1834_;
		_tmp1835_ = arg_it;
		vala_iterator_next (_tmp1835_);
		_tmp1836_ = arg_it;
		_tmp1837_ = vala_iterator_get (_tmp1836_);
		_tmp1838_ = (ValaExpression*) _tmp1837_;
		_tmp1839_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1838_);
		_tmp1840_ = _tmp1839_;
		_vala_code_node_unref0 (_tmp1838_);
		new_size = _tmp1840_;
		_tmp1841_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1842_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1841_, TRUE, NULL, FALSE);
		temp_decl = _tmp1842_;
		_tmp1843_ = temp_decl;
		_tmp1844_ = vala_symbol_get_name ((ValaSymbol*) _tmp1843_);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1845_);
		temp_ref = _tmp1846_;
		_tmp1847_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1847_, FALSE);
		_tmp1848_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1848_, "string.h", FALSE);
		_tmp1849_ = ma;
		_tmp1850_ = vala_member_access_get_inner (_tmp1849_);
		_tmp1851_ = _tmp1850_;
		_tmp1852_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1851_, 1);
		clen = _tmp1852_;
		_tmp1853_ = ma;
		_tmp1854_ = vala_member_access_get_inner (_tmp1853_);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1855_);
		celems = _tmp1856_;
		_tmp1857_ = ma;
		_tmp1858_ = vala_member_access_get_inner (_tmp1857_);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = vala_expression_get_value_type (_tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1862_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1861_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1862_;
		_tmp1863_ = array_type;
		_tmp1864_ = vala_array_type_get_element_type (_tmp1863_);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = g_strdup_printf ("sizeof (%s)", _tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = vala_ccode_identifier_new (_tmp1869_);
		_tmp1871_ = _tmp1870_;
		_g_free0 (_tmp1869_);
		_g_free0 (_tmp1867_);
		csizeof = _tmp1871_;
		_tmp1872_ = temp_ref;
		_tmp1873_ = clen;
		_tmp1874_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1872_, _tmp1873_);
		cdelta = _tmp1874_;
		_tmp1875_ = temp_ref;
		_tmp1876_ = clen;
		_tmp1877_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1875_, _tmp1876_);
		ccheck = _tmp1877_;
		_tmp1878_ = vala_ccode_identifier_new ("memset");
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1879_);
		_tmp1881_ = _tmp1880_;
		_vala_ccode_node_unref0 (_tmp1879_);
		czero = _tmp1881_;
		_tmp1882_ = czero;
		_tmp1883_ = celems;
		_tmp1884_ = clen;
		_tmp1885_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1883_, _tmp1884_);
		_tmp1886_ = _tmp1885_;
		vala_ccode_function_call_add_argument (_tmp1882_, (ValaCCodeExpression*) _tmp1886_);
		_vala_ccode_node_unref0 (_tmp1886_);
		_tmp1887_ = czero;
		_tmp1888_ = vala_ccode_constant_new ("0");
		_tmp1889_ = _tmp1888_;
		vala_ccode_function_call_add_argument (_tmp1887_, (ValaCCodeExpression*) _tmp1889_);
		_vala_ccode_node_unref0 (_tmp1889_);
		_tmp1890_ = czero;
		_tmp1891_ = csizeof;
		_tmp1892_ = cdelta;
		_tmp1893_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1891_, (ValaCCodeExpression*) _tmp1892_);
		_tmp1894_ = _tmp1893_;
		vala_ccode_function_call_add_argument (_tmp1890_, (ValaCCodeExpression*) _tmp1894_);
		_vala_ccode_node_unref0 (_tmp1894_);
		_tmp1895_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1896_ = _tmp1895_;
		_tmp1897_ = temp_ref;
		_tmp1898_ = new_size;
		vala_ccode_function_add_assignment (_tmp1896_, _tmp1897_, _tmp1898_);
		_tmp1899_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1900_ = _tmp1899_;
		_tmp1901_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1900_, _tmp1901_);
		_tmp1902_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1903_ = _tmp1902_;
		_tmp1904_ = ccheck;
		_tmp1905_ = czero;
		_tmp1906_ = vala_ccode_constant_new ("NULL");
		_tmp1907_ = _tmp1906_;
		_tmp1908_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1904_, (ValaCCodeExpression*) _tmp1905_, (ValaCCodeExpression*) _tmp1907_);
		_tmp1909_ = _tmp1908_;
		vala_ccode_function_add_expression (_tmp1903_, (ValaCCodeExpression*) _tmp1909_);
		_vala_ccode_node_unref0 (_tmp1909_);
		_vala_ccode_node_unref0 (_tmp1907_);
		_tmp1910_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1911_ = _tmp1910_;
		_tmp1912_ = ma;
		_tmp1913_ = vala_member_access_get_inner (_tmp1912_);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1914_, 1);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1911_, _tmp1916_, _tmp1917_);
		_vala_ccode_node_unref0 (_tmp1916_);
		_tmp1918_ = ma;
		_tmp1919_ = vala_member_access_get_inner (_tmp1918_);
		_tmp1920_ = _tmp1919_;
		_tmp1921_ = vala_expression_get_symbol_reference (_tmp1920_);
		_tmp1922_ = _tmp1921_;
		_tmp1923_ = _vala_code_node_ref0 (_tmp1922_);
		array_var = _tmp1923_;
		_tmp1924_ = array_var;
		_tmp1925_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1924_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1924_) : NULL);
		array_local = _tmp1925_;
		_tmp1928_ = array_var;
		if (_tmp1928_ != NULL) {
			ValaSymbol* _tmp1929_;
			_tmp1929_ = array_var;
			_tmp1927_ = vala_symbol_is_internal_symbol (_tmp1929_);
		} else {
			_tmp1927_ = FALSE;
		}
		if (_tmp1927_) {
			gboolean _tmp1930_ = FALSE;
			gboolean _tmp1931_ = FALSE;
			ValaSymbol* _tmp1932_;
			_tmp1932_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1932_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1933_;
				gboolean _tmp1934_;
				gboolean _tmp1935_;
				_tmp1933_ = array_local;
				_tmp1934_ = vala_local_variable_get_captured (_tmp1933_);
				_tmp1935_ = _tmp1934_;
				_tmp1931_ = !_tmp1935_;
			} else {
				_tmp1931_ = FALSE;
			}
			if (_tmp1931_) {
				_tmp1930_ = TRUE;
			} else {
				ValaSymbol* _tmp1936_;
				_tmp1936_ = array_var;
				_tmp1930_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1936_, VALA_TYPE_FIELD);
			}
			_tmp1926_ = _tmp1930_;
		} else {
			_tmp1926_ = FALSE;
		}
		if (_tmp1926_) {
			ValaCCodeFunction* _tmp1937_;
			ValaCCodeFunction* _tmp1938_;
			ValaMemberAccess* _tmp1939_;
			ValaExpression* _tmp1940_;
			ValaExpression* _tmp1941_;
			ValaTargetValue* _tmp1942_;
			ValaTargetValue* _tmp1943_;
			ValaCCodeExpression* _tmp1944_;
			ValaCCodeExpression* _tmp1945_;
			ValaCCodeExpression* _tmp1946_;
			_tmp1937_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1938_ = _tmp1937_;
			_tmp1939_ = ma;
			_tmp1940_ = vala_member_access_get_inner (_tmp1939_);
			_tmp1941_ = _tmp1940_;
			_tmp1942_ = vala_expression_get_target_value (_tmp1941_);
			_tmp1943_ = _tmp1942_;
			_tmp1944_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1943_);
			_tmp1945_ = _tmp1944_;
			_tmp1946_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1938_, _tmp1945_, _tmp1946_);
			_vala_ccode_node_unref0 (_tmp1945_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1948_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1949_ = _tmp1948_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1949_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1950_;
		ValaDataType* _tmp1951_;
		_tmp1950_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1951_ = _tmp1950_;
		_tmp1947_ = !vala_data_type_is_disposable (_tmp1951_);
	} else {
		_tmp1947_ = FALSE;
	}
	if (_tmp1947_) {
		gboolean _tmp1952_ = FALSE;
		ValaCCodeExpression* _tmp1953_;
		_tmp1953_ = ccall_expr;
		if (_tmp1953_ != NULL) {
			_tmp1952_ = !return_result_via_out_param;
		} else {
			_tmp1952_ = FALSE;
		}
		if (_tmp1952_) {
			ValaCCodeFunction* _tmp1954_;
			ValaCCodeFunction* _tmp1955_;
			ValaCCodeExpression* _tmp1956_;
			_tmp1954_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1955_ = _tmp1954_;
			_tmp1956_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1955_, _tmp1956_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1957_;
		ValaDataType* _tmp1958_;
		ValaDataType* _tmp1959_;
		gboolean _tmp1960_ = FALSE;
		ValaDataType* _tmp1961_;
		ValaDataType* _tmp1962_;
		gboolean _tmp2015_ = FALSE;
		ValaMethod* _tmp2016_;
		_tmp1957_ = itype;
		_tmp1958_ = vala_data_type_get_return_type (_tmp1957_);
		_tmp1959_ = _vala_code_node_ref0 (_tmp1958_);
		result_type = _tmp1959_;
		_tmp1961_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1962_ = _tmp1961_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1962_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1963_;
			ValaDataType* _tmp1964_;
			_tmp1963_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1964_ = _tmp1963_;
			_tmp1960_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1964_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1960_ = FALSE;
		}
		if (_tmp1960_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1965_;
			ValaDataType* _tmp1966_;
			ValaTypeParameter* _tmp1967_;
			ValaTypeParameter* _tmp1968_;
			ValaTypeParameter* _tmp1969_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1970_;
			ValaSymbol* _tmp1971_;
			ValaSymbol* _tmp1972_;
			ValaSymbol* _tmp1973_;
			ValaSymbol* _tmp1974_;
			ValaStruct* _tmp1975_;
			gboolean _tmp1976_ = FALSE;
			ValaTypeParameter* _tmp1977_;
			ValaSymbol* _tmp1978_;
			ValaSymbol* _tmp1979_;
			ValaTypeSymbol* _tmp1980_;
			gboolean _tmp1989_ = FALSE;
			gboolean _tmp1990_ = FALSE;
			ValaStruct* _tmp1991_;
			_tmp1965_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1966_ = _tmp1965_;
			_tmp1967_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1966_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1968_ = _tmp1967_;
			_tmp1969_ = _vala_code_node_ref0 (_tmp1968_);
			type_parameter = _tmp1969_;
			_tmp1970_ = type_parameter;
			_tmp1971_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1970_);
			_tmp1972_ = _tmp1971_;
			_tmp1973_ = vala_symbol_get_parent_symbol (_tmp1972_);
			_tmp1974_ = _tmp1973_;
			_tmp1975_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1974_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1974_) : NULL);
			st = _tmp1975_;
			_tmp1977_ = type_parameter;
			_tmp1978_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1977_);
			_tmp1979_ = _tmp1978_;
			_tmp1980_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1979_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1980_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1976_ = TRUE;
			} else {
				gboolean _tmp1981_ = FALSE;
				ValaStruct* _tmp1982_;
				_tmp1982_ = st;
				if (_tmp1982_ != NULL) {
					ValaStruct* _tmp1983_;
					gchar* _tmp1984_;
					gchar* _tmp1985_;
					_tmp1983_ = st;
					_tmp1984_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1983_);
					_tmp1985_ = _tmp1984_;
					_tmp1981_ = g_strcmp0 (_tmp1985_, "va_list") == 0;
					_g_free0 (_tmp1985_);
				} else {
					_tmp1981_ = FALSE;
				}
				_tmp1976_ = _tmp1981_;
			}
			if (_tmp1976_) {
				ValaDataType* _tmp1986_;
				ValaDataType* _tmp1987_;
				ValaDataType* _tmp1988_;
				_tmp1986_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1987_ = _tmp1986_;
				_tmp1988_ = _vala_code_node_ref0 (_tmp1987_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1988_;
			}
			_tmp1991_ = st;
			if (_tmp1991_ != NULL) {
				ValaStruct* _tmp1992_;
				gchar* _tmp1993_;
				gchar* _tmp1994_;
				_tmp1992_ = st;
				_tmp1993_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1992_);
				_tmp1994_ = _tmp1993_;
				_tmp1990_ = g_strcmp0 (_tmp1994_, "va_list") == 0;
				_g_free0 (_tmp1994_);
			} else {
				_tmp1990_ = FALSE;
			}
			if (_tmp1990_) {
				ValaMemberAccess* _tmp1995_;
				const gchar* _tmp1996_;
				const gchar* _tmp1997_;
				_tmp1995_ = ma;
				_tmp1996_ = vala_member_access_get_member_name (_tmp1995_);
				_tmp1997_ = _tmp1996_;
				_tmp1989_ = g_strcmp0 (_tmp1997_, "arg") == 0;
			} else {
				_tmp1989_ = FALSE;
			}
			if (_tmp1989_) {
				gboolean _tmp1998_ = FALSE;
				ValaDataType* _tmp1999_;
				_tmp1999_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1999_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2000_;
					ValaDelegate* _tmp2001_;
					ValaDelegate* _tmp2002_;
					gboolean _tmp2003_;
					gboolean _tmp2004_;
					_tmp2000_ = result_type;
					_tmp2001_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2000_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2002_ = _tmp2001_;
					_tmp2003_ = vala_delegate_get_has_target (_tmp2002_);
					_tmp2004_ = _tmp2003_;
					_tmp1998_ = _tmp2004_;
				} else {
					_tmp1998_ = FALSE;
				}
				if (_tmp1998_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2005_;
					ValaTargetValue* _tmp2006_;
					ValaGLibValue* _tmp2007_;
					ValaCCodeExpression* _tmp2008_;
					ValaGLibValue* _tmp2011_;
					ValaCCodeExpression* _tmp2012_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, NULL);
					_tmp2005_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2006_ = _tmp2005_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2006_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2007_ = arg_value;
					_tmp2008_ = _tmp2007_->delegate_target_cvalue;
					if (_tmp2008_ == NULL) {
						ValaGLibValue* _tmp2009_;
						ValaCCodeConstant* _tmp2010_;
						_tmp2009_ = arg_value;
						_tmp2010_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2009_->delegate_target_cvalue);
						_tmp2009_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2010_;
					}
					_tmp2011_ = arg_value;
					_tmp2012_ = _tmp2011_->delegate_target_destroy_notify_cvalue;
					if (_tmp2012_ == NULL) {
						ValaGLibValue* _tmp2013_;
						ValaCCodeConstant* _tmp2014_;
						_tmp2013_ = arg_value;
						_tmp2014_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2013_->delegate_target_destroy_notify_cvalue);
						_tmp2013_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2014_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2016_ = m;
		if (_tmp2016_ != NULL) {
			ValaMethod* _tmp2017_;
			_tmp2017_ = m;
			_tmp2015_ = vala_method_get_format_arg_index (_tmp2017_) >= 0;
		} else {
			_tmp2015_ = FALSE;
		}
		if (_tmp2015_) {
			ValaCCodeExpression* _tmp2018_;
			_tmp2018_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2018_);
		} else {
			gboolean _tmp2019_ = FALSE;
			ValaMethod* _tmp2020_;
			_tmp2020_ = m;
			if (_tmp2020_ != NULL) {
				ValaMethod* _tmp2021_;
				_tmp2021_ = m;
				_tmp2019_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2021_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2019_ = FALSE;
			}
			if (_tmp2019_) {
				ValaCCodeExpression* _tmp2022_;
				_tmp2022_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2022_);
			} else {
				gboolean _tmp2023_ = FALSE;
				gboolean _tmp2024_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2024_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2024_ = FALSE;
				}
				if (_tmp2024_) {
					gboolean _tmp2025_ = FALSE;
					ValaDataType* _tmp2026_;
					_tmp2026_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2026_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2027_;
						_tmp2027_ = result_type;
						_tmp2025_ = !vala_data_type_is_disposable (_tmp2027_);
					} else {
						_tmp2025_ = FALSE;
					}
					_tmp2023_ = _tmp2025_;
				} else {
					_tmp2023_ = FALSE;
				}
				if (_tmp2023_) {
					ValaCCodeExpression* _tmp2028_;
					_tmp2028_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2028_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2029_;
						ValaDataType* _tmp2030_;
						gboolean _tmp2031_;
						gboolean _tmp2032_;
						ValaLocalVariable* _tmp2033_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2034_;
						const gchar* _tmp2035_;
						const gchar* _tmp2036_;
						ValaCCodeExpression* _tmp2037_;
						ValaLocalVariable* _tmp2038_;
						ValaCCodeFunction* _tmp2039_;
						ValaCCodeFunction* _tmp2040_;
						ValaCCodeExpression* _tmp2041_;
						ValaCCodeExpression* _tmp2042_;
						ValaCCodeExpression* _tmp2043_;
						ValaTargetValue* _tmp2044_;
						ValaTargetValue* _tmp2045_;
						_tmp2029_ = result_type;
						_tmp2030_ = result_type;
						_tmp2031_ = vala_data_type_get_value_owned (_tmp2030_);
						_tmp2032_ = _tmp2031_;
						_tmp2033_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2029_, _tmp2032_, NULL, FALSE);
						temp_var = _tmp2033_;
						_tmp2034_ = temp_var;
						_tmp2035_ = vala_symbol_get_name ((ValaSymbol*) _tmp2034_);
						_tmp2036_ = _tmp2035_;
						_tmp2037_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2036_);
						temp_ref = _tmp2037_;
						_tmp2038_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2038_, FALSE);
						_tmp2039_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2040_ = _tmp2039_;
						_tmp2041_ = temp_ref;
						_tmp2042_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2040_, _tmp2041_, _tmp2042_);
						_tmp2043_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2043_);
						_tmp2044_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2045_ = _tmp2044_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2045_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2046_;
						ValaTargetValue* _tmp2047_;
						ValaTargetValue* _tmp2048_;
						_tmp2046_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2046_);
						_tmp2047_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2048_ = _tmp2047_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2048_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2049_ = params;
	_tmp2050_ = vala_iterable_iterator ((ValaIterable*) _tmp2049_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2050_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2051_;
		ValaList* _tmp2052_;
		gint _arg_size = 0;
		ValaList* _tmp2053_;
		gint _tmp2054_;
		gint _tmp2055_;
		gint _arg_index = 0;
		_tmp2051_ = vala_method_call_get_argument_list (expr);
		_tmp2052_ = _vala_iterable_ref0 (_tmp2051_);
		_arg_list = _tmp2052_;
		_tmp2053_ = _arg_list;
		_tmp2054_ = vala_collection_get_size ((ValaCollection*) _tmp2053_);
		_tmp2055_ = _tmp2054_;
		_arg_size = _tmp2055_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2056_;
			gpointer _tmp2057_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2058_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2061_;
			ValaUnaryExpression* _tmp2062_;
			gboolean _tmp2063_ = FALSE;
			ValaUnaryExpression* _tmp2064_;
			ValaUnaryExpression* _tmp2068_;
			ValaExpression* _tmp2069_;
			ValaExpression* _tmp2070_;
			ValaDataType* _tmp2071_;
			ValaDataType* _tmp2072_;
			gboolean _tmp2082_ = FALSE;
			ValaMemberAccess* _tmp2083_;
			ValaSymbol* _tmp2084_;
			ValaSymbol* _tmp2085_;
			ValaUnaryExpression* _tmp2101_;
			ValaExpression* _tmp2102_;
			ValaExpression* _tmp2103_;
			ValaTargetValue* _tmp2104_;
			ValaTargetValue* _tmp2105_;
			ValaUnaryExpression* _tmp2106_;
			ValaTargetValue* _tmp2107_;
			ValaTargetValue* _tmp2108_;
			ValaUnaryExpression* _tmp2109_;
			ValaExpression* _tmp2110_;
			ValaExpression* _tmp2111_;
			ValaDataType* _tmp2112_;
			ValaDataType* _tmp2113_;
			ValaExpression* _tmp2114_;
			ValaTargetValue* _tmp2115_;
			ValaTargetValue* _tmp2116_;
			ValaSourceReference* _tmp2117_;
			ValaSourceReference* _tmp2118_;
			gboolean _tmp2119_ = FALSE;
			ValaParameter* _tmp2120_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2056_ = _arg_list;
			_tmp2057_ = vala_list_get (_tmp2056_, _arg_index);
			arg = (ValaExpression*) _tmp2057_;
			param = NULL;
			_tmp2058_ = params_it;
			if (vala_iterator_next (_tmp2058_)) {
				ValaIterator* _tmp2059_;
				gpointer _tmp2060_;
				_tmp2059_ = params_it;
				_tmp2060_ = vala_iterator_get (_tmp2059_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2060_;
			}
			_tmp2061_ = arg;
			_tmp2062_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2061_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2061_) : NULL);
			unary = _tmp2062_;
			_tmp2064_ = unary;
			if (_tmp2064_ == NULL) {
				_tmp2063_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2065_;
				ValaUnaryOperator _tmp2066_;
				ValaUnaryOperator _tmp2067_;
				_tmp2065_ = unary;
				_tmp2066_ = vala_unary_expression_get_operator (_tmp2065_);
				_tmp2067_ = _tmp2066_;
				_tmp2063_ = _tmp2067_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2063_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2068_ = unary;
			_tmp2069_ = vala_unary_expression_get_inner (_tmp2068_);
			_tmp2070_ = _tmp2069_;
			_tmp2071_ = vala_expression_get_value_type (_tmp2070_);
			_tmp2072_ = _tmp2071_;
			if (vala_ccode_base_module_requires_destroy (_tmp2072_)) {
				ValaCCodeFunction* _tmp2073_;
				ValaCCodeFunction* _tmp2074_;
				ValaUnaryExpression* _tmp2075_;
				ValaExpression* _tmp2076_;
				ValaExpression* _tmp2077_;
				ValaTargetValue* _tmp2078_;
				ValaTargetValue* _tmp2079_;
				ValaCCodeExpression* _tmp2080_;
				ValaCCodeExpression* _tmp2081_;
				_tmp2073_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2074_ = _tmp2073_;
				_tmp2075_ = unary;
				_tmp2076_ = vala_unary_expression_get_inner (_tmp2075_);
				_tmp2077_ = _tmp2076_;
				_tmp2078_ = vala_expression_get_target_value (_tmp2077_);
				_tmp2079_ = _tmp2078_;
				_tmp2080_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2079_, FALSE);
				_tmp2081_ = _tmp2080_;
				vala_ccode_function_add_expression (_tmp2074_, _tmp2081_);
				_vala_ccode_node_unref0 (_tmp2081_);
			}
			_tmp2083_ = ma;
			_tmp2084_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2083_);
			_tmp2085_ = _tmp2084_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2085_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2086_;
				ValaTargetValue* _tmp2087_;
				ValaTargetValue* _tmp2088_;
				ValaDataType* _tmp2089_;
				ValaDataType* _tmp2090_;
				_tmp2086_ = unary;
				_tmp2087_ = vala_expression_get_target_value ((ValaExpression*) _tmp2086_);
				_tmp2088_ = _tmp2087_;
				_tmp2089_ = vala_target_value_get_value_type (_tmp2088_);
				_tmp2090_ = _tmp2089_;
				_tmp2082_ = _tmp2090_ == NULL;
			} else {
				_tmp2082_ = FALSE;
			}
			if (_tmp2082_) {
				ValaUnaryExpression* _tmp2091_;
				ValaTargetValue* _tmp2092_;
				ValaTargetValue* _tmp2093_;
				ValaUnaryExpression* _tmp2094_;
				ValaExpression* _tmp2095_;
				ValaExpression* _tmp2096_;
				ValaDataType* _tmp2097_;
				ValaDataType* _tmp2098_;
				ValaDataType* _tmp2099_;
				ValaDataType* _tmp2100_;
				_tmp2091_ = unary;
				_tmp2092_ = vala_expression_get_target_value ((ValaExpression*) _tmp2091_);
				_tmp2093_ = _tmp2092_;
				_tmp2094_ = unary;
				_tmp2095_ = vala_unary_expression_get_inner (_tmp2094_);
				_tmp2096_ = _tmp2095_;
				_tmp2097_ = vala_expression_get_value_type (_tmp2096_);
				_tmp2098_ = _tmp2097_;
				_tmp2099_ = vala_data_type_copy (_tmp2098_);
				_tmp2100_ = _tmp2099_;
				vala_target_value_set_value_type (_tmp2093_, _tmp2100_);
				_vala_code_node_unref0 (_tmp2100_);
			}
			_tmp2101_ = unary;
			_tmp2102_ = vala_unary_expression_get_inner (_tmp2101_);
			_tmp2103_ = _tmp2102_;
			_tmp2104_ = vala_expression_get_target_value (_tmp2103_);
			_tmp2105_ = _tmp2104_;
			_tmp2106_ = unary;
			_tmp2107_ = vala_expression_get_target_value ((ValaExpression*) _tmp2106_);
			_tmp2108_ = _tmp2107_;
			_tmp2109_ = unary;
			_tmp2110_ = vala_unary_expression_get_inner (_tmp2109_);
			_tmp2111_ = _tmp2110_;
			_tmp2112_ = vala_expression_get_value_type (_tmp2111_);
			_tmp2113_ = _tmp2112_;
			_tmp2114_ = arg;
			_tmp2115_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2108_, _tmp2113_, (ValaCodeNode*) _tmp2114_);
			_tmp2116_ = _tmp2115_;
			_tmp2117_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2118_ = _tmp2117_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2105_, _tmp2116_, _tmp2118_);
			_vala_target_value_unref0 (_tmp2116_);
			_tmp2120_ = param;
			if (_tmp2120_ != NULL) {
				ValaParameter* _tmp2121_;
				_tmp2121_ = param;
				_tmp2119_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2121_);
			} else {
				_tmp2119_ = FALSE;
			}
			if (_tmp2119_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2122_;
				ValaCCodeIdentifier* _tmp2123_;
				ValaCCodeFunctionCall* _tmp2124_;
				ValaCCodeFunctionCall* _tmp2125_;
				ValaCCodeFunctionCall* _tmp2126_;
				ValaUnaryExpression* _tmp2127_;
				ValaExpression* _tmp2128_;
				ValaExpression* _tmp2129_;
				ValaTargetValue* _tmp2130_;
				ValaTargetValue* _tmp2131_;
				ValaCCodeExpression* _tmp2132_;
				ValaCCodeExpression* _tmp2133_;
				ValaCCodeFunction* _tmp2134_;
				ValaCCodeFunction* _tmp2135_;
				ValaUnaryExpression* _tmp2136_;
				ValaExpression* _tmp2137_;
				ValaExpression* _tmp2138_;
				ValaTargetValue* _tmp2139_;
				ValaTargetValue* _tmp2140_;
				ValaCCodeExpression* _tmp2141_;
				ValaCCodeExpression* _tmp2142_;
				ValaCCodeFunctionCall* _tmp2143_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2122_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2123_ = _tmp2122_;
				_tmp2124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2123_);
				_tmp2125_ = _tmp2124_;
				_vala_ccode_node_unref0 (_tmp2123_);
				len_call = _tmp2125_;
				_tmp2126_ = len_call;
				_tmp2127_ = unary;
				_tmp2128_ = vala_unary_expression_get_inner (_tmp2127_);
				_tmp2129_ = _tmp2128_;
				_tmp2130_ = vala_expression_get_target_value (_tmp2129_);
				_tmp2131_ = _tmp2130_;
				_tmp2132_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2131_);
				_tmp2133_ = _tmp2132_;
				vala_ccode_function_call_add_argument (_tmp2126_, _tmp2133_);
				_vala_ccode_node_unref0 (_tmp2133_);
				_tmp2134_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2135_ = _tmp2134_;
				_tmp2136_ = unary;
				_tmp2137_ = vala_unary_expression_get_inner (_tmp2136_);
				_tmp2138_ = _tmp2137_;
				_tmp2139_ = vala_expression_get_target_value (_tmp2138_);
				_tmp2140_ = _tmp2139_;
				_tmp2141_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2140_, 1);
				_tmp2142_ = _tmp2141_;
				_tmp2143_ = len_call;
				vala_ccode_function_add_assignment (_tmp2135_, _tmp2142_, (ValaCCodeExpression*) _tmp2143_);
				_vala_ccode_node_unref0 (_tmp2142_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2146_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2146_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2147_;
		ValaSymbol* _tmp2148_;
		ValaSymbol* _tmp2149_;
		_tmp2147_ = m;
		_tmp2148_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2147_);
		_tmp2149_ = _tmp2148_;
		_tmp2145_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2149_, VALA_TYPE_CLASS);
	} else {
		_tmp2145_ = FALSE;
	}
	if (_tmp2145_) {
		gboolean _tmp2150_ = FALSE;
		gboolean _tmp2151_ = FALSE;
		ValaClass* _tmp2152_;
		ValaClass* _tmp2153_;
		gboolean _tmp2154_;
		gboolean _tmp2155_;
		_tmp2152_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2153_ = _tmp2152_;
		_tmp2154_ = vala_class_get_is_compact (_tmp2153_);
		_tmp2155_ = _tmp2154_;
		if (_tmp2155_) {
			ValaClass* _tmp2156_;
			ValaClass* _tmp2157_;
			ValaClass* _tmp2158_;
			ValaClass* _tmp2159_;
			_tmp2156_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2157_ = _tmp2156_;
			_tmp2158_ = vala_class_get_base_class (_tmp2157_);
			_tmp2159_ = _tmp2158_;
			_tmp2151_ = _tmp2159_ != NULL;
		} else {
			_tmp2151_ = FALSE;
		}
		if (_tmp2151_) {
			_tmp2150_ = TRUE;
		} else {
			ValaClass* _tmp2160_;
			ValaClass* _tmp2161_;
			ValaClass* _tmp2162_;
			ValaClass* _tmp2163_;
			ValaClass* _tmp2164_;
			_tmp2160_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2161_ = _tmp2160_;
			_tmp2162_ = vala_class_get_base_class (_tmp2161_);
			_tmp2163_ = _tmp2162_;
			_tmp2164_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2150_ = _tmp2163_ == _tmp2164_;
		}
		_tmp2144_ = _tmp2150_;
	} else {
		_tmp2144_ = FALSE;
	}
	if (_tmp2144_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2165_;
		ValaClass* _tmp2166_;
		gchar* _tmp2167_;
		gchar* _tmp2168_;
		gchar* _tmp2169_;
		gchar* _tmp2170_;
		ValaCCodeIdentifier* _tmp2171_;
		ValaCCodeIdentifier* _tmp2172_;
		ValaCCodeFunctionCall* _tmp2173_;
		ValaCCodeFunctionCall* _tmp2174_;
		ValaCCodeFunctionCall* _tmp2175_;
		ValaCCodeExpression* _tmp2176_;
		ValaCCodeExpression* _tmp2177_;
		ValaClass* _tmp2178_;
		ValaClass* _tmp2179_;
		gboolean _tmp2180_;
		gboolean _tmp2181_;
		ValaCCodeFunction* _tmp2185_;
		ValaCCodeFunction* _tmp2186_;
		ValaCCodeFunctionCall* _tmp2187_;
		_tmp2165_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2166_ = _tmp2165_;
		_tmp2167_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2166_, NULL);
		_tmp2168_ = _tmp2167_;
		_tmp2169_ = g_strdup_printf ("%s_instance_init", _tmp2168_);
		_tmp2170_ = _tmp2169_;
		_tmp2171_ = vala_ccode_identifier_new (_tmp2170_);
		_tmp2172_ = _tmp2171_;
		_tmp2173_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2172_);
		_tmp2174_ = _tmp2173_;
		_vala_ccode_node_unref0 (_tmp2172_);
		_g_free0 (_tmp2170_);
		_g_free0 (_tmp2168_);
		cinitcall = _tmp2174_;
		_tmp2175_ = cinitcall;
		_tmp2176_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2177_ = _tmp2176_;
		vala_ccode_function_call_add_argument (_tmp2175_, _tmp2177_);
		_vala_ccode_node_unref0 (_tmp2177_);
		_tmp2178_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2179_ = _tmp2178_;
		_tmp2180_ = vala_class_get_is_compact (_tmp2179_);
		_tmp2181_ = _tmp2180_;
		if (!_tmp2181_) {
			ValaCCodeFunctionCall* _tmp2182_;
			ValaCCodeConstant* _tmp2183_;
			ValaCCodeConstant* _tmp2184_;
			_tmp2182_ = cinitcall;
			_tmp2183_ = vala_ccode_constant_new ("NULL");
			_tmp2184_ = _tmp2183_;
			vala_ccode_function_call_add_argument (_tmp2182_, (ValaCCodeExpression*) _tmp2184_);
			_vala_ccode_node_unref0 (_tmp2184_);
		}
		_tmp2185_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2186_ = _tmp2185_;
		_tmp2187_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2186_, (ValaCCodeExpression*) _tmp2187_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaEnumValue* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaEnumValue* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp25_ = _enum_value_list;
			_tmp26_ = vala_list_get (_tmp25_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp26_;
			_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = enum_value;
			_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_case (_tmp28_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = enum_value;
			_tmp37_ = vala_get_ccode_name ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_return (_tmp35_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	vala_ccode_function_close (_tmp46_);
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_constant_new ("NULL");
	_tmp50_ = _tmp49_;
	vala_ccode_function_add_return (_tmp48_, (ValaCCodeExpression*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = function;
	vala_ccode_file_add_function_declaration (_tmp51_, _tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function (_tmp53_, _tmp54_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaUnaryExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp7_) : NULL;
			_tmp9_ = unary;
			if (_tmp9_ != NULL) {
				gboolean _tmp10_ = FALSE;
				ValaUnaryExpression* _tmp11_;
				ValaUnaryOperator _tmp12_;
				ValaUnaryOperator _tmp13_;
				_tmp11_ = unary;
				_tmp12_ = vala_unary_expression_get_operator (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp10_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp14_;
					ValaUnaryOperator _tmp15_;
					ValaUnaryOperator _tmp16_;
					_tmp14_ = unary;
					_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = _tmp16_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

