/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp239_;
	ValaExpression* _tmp240_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp241_;
	ValaExpression* _tmp242_;
	gboolean _tmp243_ = FALSE;
	gboolean _tmp244_ = FALSE;
	ValaAssignmentOperator _tmp245_;
	ValaMemberAccess* _tmp292_;
	ValaExpression* _tmp649_;
	ValaExpression* _tmp650_;
	ValaDataType* _tmp651_;
	ValaDataType* _tmp652_;
	ValaDataType* _tmp661_;
	ValaDataType* _tmp662_;
	gboolean _tmp665_;
	gboolean _tmp666_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (VALA_IS_MEMBER_ACCESS (_tmp96_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp104_ = FALSE;
		gboolean _tmp105_ = FALSE;
		ValaMemberAccess* _tmp106_;
		ValaSymbol* _tmp107_;
		ValaSymbol* _tmp108_;
		ValaMemberAccess* _tmp124_;
		gboolean _tmp125_;
		gboolean _tmp126_;
		gboolean _tmp136_ = FALSE;
		ValaMemberAccess* _tmp137_;
		gboolean _tmp138_;
		gboolean _tmp139_;
		ValaMemberAccess* _tmp143_;
		ValaSymbol* _tmp144_;
		ValaSymbol* _tmp145_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp99_ = ma;
		_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
		_tmp101_ = _tmp100_;
		if (VALA_IS_CONSTANT (_tmp101_)) {
			ValaSourceReference* _tmp102_;
			ValaSourceReference* _tmp103_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp103_ = _tmp102_;
			vala_report_error (_tmp103_, "Assignment to constant after initialization");
			result = FALSE;
			return result;
		}
		_tmp106_ = ma;
		_tmp107_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp106_);
		_tmp108_ = _tmp107_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp108_)) {
			ValaMemberAccess* _tmp109_;
			ValaDataType* _tmp110_;
			ValaDataType* _tmp111_;
			_tmp109_ = ma;
			_tmp110_ = vala_expression_get_value_type ((ValaExpression*) _tmp109_);
			_tmp111_ = _tmp110_;
			_tmp105_ = _tmp111_ == NULL;
		} else {
			_tmp105_ = FALSE;
		}
		if (_tmp105_) {
			_tmp104_ = TRUE;
		} else {
			gboolean _tmp112_ = FALSE;
			gboolean _tmp113_ = FALSE;
			ValaMemberAccess* _tmp114_;
			ValaExpression* _tmp115_;
			ValaExpression* _tmp116_;
			_tmp114_ = ma;
			_tmp115_ = vala_member_access_get_inner (_tmp114_);
			_tmp116_ = _tmp115_;
			if (_tmp116_ == NULL) {
				ValaMemberAccess* _tmp117_;
				const gchar* _tmp118_;
				const gchar* _tmp119_;
				_tmp117_ = ma;
				_tmp118_ = vala_member_access_get_member_name (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp113_ = g_strcmp0 (_tmp119_, "this") == 0;
			} else {
				_tmp113_ = FALSE;
			}
			if (_tmp113_) {
				ValaSemanticAnalyzer* _tmp120_;
				ValaSemanticAnalyzer* _tmp121_;
				_tmp120_ = vala_code_context_get_analyzer (context);
				_tmp121_ = _tmp120_;
				_tmp112_ = vala_semantic_analyzer_is_in_instance_method (_tmp121_);
			} else {
				_tmp112_ = FALSE;
			}
			_tmp104_ = _tmp112_;
		}
		if (_tmp104_) {
			ValaSourceReference* _tmp122_;
			ValaSourceReference* _tmp123_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp123_ = _tmp122_;
			vala_report_error (_tmp123_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp124_ = ma;
		_tmp125_ = vala_member_access_get_prototype_access (_tmp124_);
		_tmp126_ = _tmp125_;
		if (_tmp126_) {
			ValaSourceReference* _tmp127_;
			ValaSourceReference* _tmp128_;
			ValaMemberAccess* _tmp129_;
			ValaSymbol* _tmp130_;
			ValaSymbol* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp128_ = _tmp127_;
			_tmp129_ = ma;
			_tmp130_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp129_);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_symbol_get_full_name (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp133_);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp128_, _tmp135_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp133_);
			result = FALSE;
			return result;
		}
		_tmp137_ = ma;
		_tmp138_ = vala_code_node_get_error ((ValaCodeNode*) _tmp137_);
		_tmp139_ = _tmp138_;
		if (_tmp139_) {
			_tmp136_ = TRUE;
		} else {
			ValaMemberAccess* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp136_ = _tmp142_ == NULL;
		}
		if (_tmp136_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp143_ = ma;
		_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp143_);
		_tmp145_ = _tmp144_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp145_)) {
		} else {
			ValaExpression* _tmp146_;
			ValaExpression* _tmp147_;
			ValaMemberAccess* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaExpression* _tmp153_;
			ValaExpression* _tmp154_;
			ValaMemberAccess* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp146_ = vala_assignment_get_right (self);
			_tmp147_ = _tmp146_;
			_tmp148_ = ma;
			_tmp149_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp148_);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_data_type_copy (_tmp150_);
			_tmp152_ = _tmp151_;
			vala_expression_set_formal_target_type (_tmp147_, _tmp152_);
			_vala_code_node_unref0 (_tmp152_);
			_tmp153_ = vala_assignment_get_right (self);
			_tmp154_ = _tmp153_;
			_tmp155_ = ma;
			_tmp156_ = vala_expression_get_value_type ((ValaExpression*) _tmp155_);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_data_type_copy (_tmp157_);
			_tmp159_ = _tmp158_;
			vala_expression_set_target_type (_tmp154_, _tmp159_);
			_vala_code_node_unref0 (_tmp159_);
		}
	} else {
		ValaExpression* _tmp160_;
		ValaExpression* _tmp161_;
		_tmp160_ = vala_assignment_get_left (self);
		_tmp161_ = _tmp160_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp161_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp162_;
			ValaExpression* _tmp163_;
			ValaElementAccess* _tmp164_;
			ValaExpression* _tmp165_;
			ValaExpression* _tmp166_;
			ValaDataType* _tmp167_;
			ValaDataType* _tmp168_;
			ValaTypeSymbol* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			ValaSemanticAnalyzer* _tmp171_;
			ValaSemanticAnalyzer* _tmp172_;
			ValaDataType* _tmp173_;
			ValaTypeSymbol* _tmp174_;
			ValaTypeSymbol* _tmp175_;
			_tmp162_ = vala_assignment_get_left (self);
			_tmp163_ = _tmp162_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp164_ = ea;
			_tmp165_ = vala_element_access_get_container (_tmp164_);
			_tmp166_ = _tmp165_;
			_tmp167_ = vala_expression_get_value_type (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_data_type_get_type_symbol (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_code_context_get_analyzer (context);
			_tmp172_ = _tmp171_;
			_tmp173_ = _tmp172_->string_type;
			_tmp174_ = vala_data_type_get_type_symbol (_tmp173_);
			_tmp175_ = _tmp174_;
			if (_tmp170_ == _tmp175_) {
				ValaElementAccess* _tmp176_;
				ValaSourceReference* _tmp177_;
				ValaSourceReference* _tmp178_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp176_ = ea;
				_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp176_);
				_tmp178_ = _tmp177_;
				vala_report_error (_tmp178_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp179_;
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				gboolean _tmp186_;
				_tmp179_ = ea;
				_tmp180_ = vala_element_access_get_container (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_value_type (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_data_type_get_member (_tmp183_, "set");
				_tmp185_ = _tmp184_;
				_tmp186_ = VALA_IS_METHOD (_tmp185_);
				_vala_code_node_unref0 (_tmp185_);
				if (_tmp186_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp187_;
					ValaExpression* _tmp188_;
					ValaExpression* _tmp189_;
					ValaSourceReference* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaMemberAccess* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaMethodCall* _tmp196_;
					ValaMethodCall* _tmp197_;
					ValaMethodCall* _tmp208_;
					ValaExpression* _tmp209_;
					ValaExpression* _tmp210_;
					ValaCodeNode* _tmp211_;
					ValaCodeNode* _tmp212_;
					ValaMethodCall* _tmp213_;
					ValaMethodCall* _tmp214_;
					_tmp187_ = ea;
					_tmp188_ = vala_element_access_get_container (_tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_member_access_new (_tmp189_, "set", _tmp191_);
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_method_call_new ((ValaExpression*) _tmp193_, _tmp195_);
					_tmp197_ = _tmp196_;
					_vala_code_node_unref0 (_tmp193_);
					set_call = _tmp197_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp198_;
						ValaList* _tmp199_;
						ValaList* _tmp200_;
						gint _e_size = 0;
						ValaList* _tmp201_;
						gint _tmp202_;
						gint _tmp203_;
						gint _e_index = 0;
						_tmp198_ = ea;
						_tmp199_ = vala_element_access_get_indices (_tmp198_);
						_tmp200_ = _vala_iterable_ref0 (_tmp199_);
						_e_list = _tmp200_;
						_tmp201_ = _e_list;
						_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
						_tmp203_ = _tmp202_;
						_e_size = _tmp203_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp204_;
							gpointer _tmp205_;
							ValaMethodCall* _tmp206_;
							ValaExpression* _tmp207_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp204_ = _e_list;
							_tmp205_ = vala_list_get (_tmp204_, _e_index);
							e = (ValaExpression*) _tmp205_;
							_tmp206_ = set_call;
							_tmp207_ = e;
							vala_method_call_add_argument (_tmp206_, _tmp207_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp208_ = set_call;
					_tmp209_ = vala_assignment_get_right (self);
					_tmp210_ = _tmp209_;
					vala_method_call_add_argument (_tmp208_, _tmp210_);
					_tmp211_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					_tmp213_ = set_call;
					vala_code_node_replace_expression (_tmp212_, (ValaExpression*) self, (ValaExpression*) _tmp213_);
					_tmp214_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaExpression* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					_tmp215_ = vala_assignment_get_right (self);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_assignment_get_left (self);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_expression_get_value_type (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_data_type_copy (_tmp220_);
					_tmp222_ = _tmp221_;
					vala_expression_set_target_type (_tmp216_, _tmp222_);
					_vala_code_node_unref0 (_tmp222_);
				}
			}
		} else {
			ValaExpression* _tmp223_;
			ValaExpression* _tmp224_;
			_tmp223_ = vala_assignment_get_left (self);
			_tmp224_ = _tmp223_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp224_)) {
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaDataType* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				_tmp225_ = vala_assignment_get_right (self);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_assignment_get_left (self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_expression_get_value_type (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_data_type_copy (_tmp230_);
				_tmp232_ = _tmp231_;
				vala_expression_set_target_type (_tmp226_, _tmp232_);
				_vala_code_node_unref0 (_tmp232_);
			} else {
				ValaExpression* _tmp233_;
				ValaExpression* _tmp234_;
				_tmp233_ = vala_assignment_get_left (self);
				_tmp234_ = _tmp233_;
				if (VALA_IS_LITERAL (_tmp234_)) {
					ValaSourceReference* _tmp235_;
					ValaSourceReference* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp236_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp237_;
					ValaSourceReference* _tmp238_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp238_ = _tmp237_;
					vala_report_error (_tmp238_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp239_ = vala_assignment_get_right (self);
	_tmp240_ = _tmp239_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp240_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp241_ = vala_assignment_get_left (self);
	_tmp242_ = _tmp241_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp242_) ? ((ValaMemberAccess*) _tmp242_) : NULL;
	_tmp245_ = self->priv->_operator;
	if (_tmp245_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp246_;
		_tmp246_ = ma;
		_tmp244_ = _tmp246_ != NULL;
	} else {
		_tmp244_ = FALSE;
	}
	if (_tmp244_) {
		gboolean _tmp247_ = FALSE;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaDataType* _tmp250_;
		ValaDataType* _tmp251_;
		_tmp248_ = vala_assignment_get_left (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_expression_get_value_type (_tmp249_);
		_tmp251_ = _tmp250_;
		if (vala_data_type_is_non_null_simple_type (_tmp251_)) {
			ValaMemberAccess* _tmp252_;
			ValaSymbol* _tmp253_;
			ValaSymbol* _tmp254_;
			_tmp252_ = ma;
			_tmp253_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp252_);
			_tmp254_ = _tmp253_;
			_tmp247_ = VALA_IS_LOCAL_VARIABLE (_tmp254_);
		} else {
			_tmp247_ = FALSE;
		}
		_tmp243_ = !_tmp247_;
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp255_;
		ValaExpression* _tmp256_;
		ValaExpression* _tmp257_;
		ValaMemberAccess* _tmp258_;
		const gchar* _tmp259_;
		const gchar* _tmp260_;
		ValaMemberAccess* _tmp261_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp262_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaExpression* _tmp267_;
		ValaExpression* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaSourceReference* _tmp270_;
		ValaBinaryExpression* _tmp271_;
		ValaBinaryExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaExpression* _tmp274_;
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaExpression* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaExpression* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaExpression* _tmp285_;
		ValaExpression* _tmp286_;
		ValaDataType* _tmp287_;
		ValaDataType* _tmp288_;
		ValaBinaryExpression* _tmp289_;
		ValaExpression* _tmp290_;
		ValaExpression* _tmp291_;
		_tmp255_ = ma;
		_tmp256_ = vala_member_access_get_inner (_tmp255_);
		_tmp257_ = _tmp256_;
		_tmp258_ = ma;
		_tmp259_ = vala_member_access_get_member_name (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_member_access_new (_tmp257_, _tmp260_, NULL);
		old_value = _tmp261_;
		_tmp262_ = self->priv->_operator;
		switch (_tmp262_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp263_;
				ValaSourceReference* _tmp264_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp264_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp265_ = bop;
		_tmp266_ = old_value;
		_tmp267_ = vala_assignment_get_right (self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_binary_expression_new (_tmp265_, (ValaExpression*) _tmp266_, _tmp268_, _tmp270_);
		bin = _tmp271_;
		_tmp272_ = bin;
		_tmp273_ = vala_assignment_get_right (self);
		_tmp274_ = _tmp273_;
		_tmp275_ = vala_expression_get_target_type (_tmp274_);
		_tmp276_ = _tmp275_;
		vala_expression_set_target_type ((ValaExpression*) _tmp272_, _tmp276_);
		_tmp277_ = vala_assignment_get_right (self);
		_tmp278_ = _tmp277_;
		_tmp279_ = vala_assignment_get_right (self);
		_tmp280_ = _tmp279_;
		_tmp281_ = vala_expression_get_target_type (_tmp280_);
		_tmp282_ = _tmp281_;
		_tmp283_ = vala_data_type_copy (_tmp282_);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type (_tmp278_, _tmp284_);
		_vala_code_node_unref0 (_tmp284_);
		_tmp285_ = vala_assignment_get_right (self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_expression_get_target_type (_tmp286_);
		_tmp288_ = _tmp287_;
		vala_data_type_set_value_owned (_tmp288_, FALSE);
		_tmp289_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp289_);
		_tmp290_ = vala_assignment_get_right (self);
		_tmp291_ = _tmp290_;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp292_ = ma;
	if (_tmp292_ != NULL) {
		ValaMemberAccess* _tmp293_;
		ValaSymbol* _tmp294_;
		ValaSymbol* _tmp295_;
		gboolean _tmp462_ = FALSE;
		ValaExpression* _tmp463_;
		ValaExpression* _tmp464_;
		ValaDataType* _tmp465_;
		ValaDataType* _tmp466_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp521_;
		ValaExpression* _tmp522_;
		gboolean _tmp523_ = FALSE;
		ValaMemberAccess* _tmp524_;
		_tmp293_ = ma;
		_tmp294_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp293_);
		_tmp295_ = _tmp294_;
		if (VALA_IS_PROPERTY (_tmp295_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp296_;
			ValaSymbol* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp299_;
			ValaDynamicProperty* _tmp300_;
			gboolean _tmp315_ = FALSE;
			ValaProperty* _tmp316_;
			ValaPropertyAccessor* _tmp317_;
			ValaPropertyAccessor* _tmp318_;
			_tmp296_ = ma;
			_tmp297_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp296_);
			_tmp298_ = _tmp297_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp299_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp299_) ? ((ValaDynamicProperty*) _tmp299_) : NULL;
			_tmp300_ = dynamic_prop;
			if (_tmp300_ != NULL) {
				ValaDynamicProperty* _tmp301_;
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				ValaDataType* _tmp306_;
				ValaDataType* _tmp307_;
				ValaExpression* _tmp308_;
				ValaExpression* _tmp309_;
				ValaDynamicProperty* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				ValaDataType* _tmp313_;
				ValaDataType* _tmp314_;
				_tmp301_ = dynamic_prop;
				_tmp302_ = vala_assignment_get_right (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp306_ = vala_data_type_copy (_tmp305_);
				_tmp307_ = _tmp306_;
				vala_property_set_property_type ((ValaProperty*) _tmp301_, _tmp307_);
				_vala_code_node_unref0 (_tmp307_);
				_tmp308_ = vala_assignment_get_left (self);
				_tmp309_ = _tmp308_;
				_tmp310_ = dynamic_prop;
				_tmp311_ = vala_property_get_property_type ((ValaProperty*) _tmp310_);
				_tmp312_ = _tmp311_;
				_tmp313_ = vala_data_type_copy (_tmp312_);
				_tmp314_ = _tmp313_;
				vala_expression_set_value_type (_tmp309_, _tmp314_);
				_vala_code_node_unref0 (_tmp314_);
			}
			_tmp316_ = prop;
			_tmp317_ = vala_property_get_set_accessor (_tmp316_);
			_tmp318_ = _tmp317_;
			if (_tmp318_ == NULL) {
				_tmp315_ = TRUE;
			} else {
				gboolean _tmp319_ = FALSE;
				ValaProperty* _tmp320_;
				ValaPropertyAccessor* _tmp321_;
				ValaPropertyAccessor* _tmp322_;
				gboolean _tmp323_;
				gboolean _tmp324_;
				_tmp320_ = prop;
				_tmp321_ = vala_property_get_set_accessor (_tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_property_accessor_get_writable (_tmp322_);
				_tmp324_ = _tmp323_;
				if (!_tmp324_) {
					gboolean _tmp325_ = FALSE;
					ValaSemanticAnalyzer* _tmp326_;
					ValaSemanticAnalyzer* _tmp327_;
					ValaMethod* _tmp328_;
					_tmp326_ = vala_code_context_get_analyzer (context);
					_tmp327_ = _tmp326_;
					_tmp328_ = vala_semantic_analyzer_find_current_method (_tmp327_);
					if (VALA_IS_CREATION_METHOD (_tmp328_)) {
						_tmp325_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp329_;
						ValaSemanticAnalyzer* _tmp330_;
						_tmp329_ = vala_code_context_get_analyzer (context);
						_tmp330_ = _tmp329_;
						_tmp325_ = vala_semantic_analyzer_is_in_constructor (_tmp330_);
					}
					_tmp319_ = !_tmp325_;
				} else {
					_tmp319_ = FALSE;
				}
				_tmp315_ = _tmp319_;
			}
			if (_tmp315_) {
				ValaMemberAccess* _tmp331_;
				ValaMemberAccess* _tmp332_;
				ValaSourceReference* _tmp333_;
				ValaSourceReference* _tmp334_;
				ValaProperty* _tmp335_;
				gchar* _tmp336_;
				gchar* _tmp337_;
				gchar* _tmp338_;
				gchar* _tmp339_;
				_tmp331_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp331_, TRUE);
				_tmp332_ = ma;
				_tmp333_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp332_);
				_tmp334_ = _tmp333_;
				_tmp335_ = prop;
				_tmp336_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = g_strdup_printf ("Property `%s' is read-only", _tmp337_);
				_tmp339_ = _tmp338_;
				vala_report_error (_tmp334_, _tmp339_);
				_g_free0 (_tmp339_);
				_g_free0 (_tmp337_);
				result = FALSE;
				return result;
			} else {
				gboolean _tmp340_ = FALSE;
				gboolean _tmp341_ = FALSE;
				gboolean _tmp342_;
				gboolean _tmp343_;
				_tmp342_ = vala_code_context_get_deprecated (context);
				_tmp343_ = _tmp342_;
				if (!_tmp343_) {
					ValaProperty* _tmp344_;
					ValaPropertyAccessor* _tmp345_;
					ValaPropertyAccessor* _tmp346_;
					gboolean _tmp347_;
					gboolean _tmp348_;
					_tmp344_ = prop;
					_tmp345_ = vala_property_get_set_accessor (_tmp344_);
					_tmp346_ = _tmp345_;
					_tmp347_ = vala_property_accessor_get_writable (_tmp346_);
					_tmp348_ = _tmp347_;
					_tmp341_ = !_tmp348_;
				} else {
					_tmp341_ = FALSE;
				}
				if (_tmp341_) {
					ValaSemanticAnalyzer* _tmp349_;
					ValaSemanticAnalyzer* _tmp350_;
					ValaMethod* _tmp351_;
					_tmp349_ = vala_code_context_get_analyzer (context);
					_tmp350_ = _tmp349_;
					_tmp351_ = vala_semantic_analyzer_find_current_method (_tmp350_);
					_tmp340_ = VALA_IS_CREATION_METHOD (_tmp351_);
				} else {
					_tmp340_ = FALSE;
				}
				if (_tmp340_) {
					ValaMemberAccess* _tmp352_;
					ValaExpression* _tmp353_;
					ValaExpression* _tmp354_;
					ValaSymbol* _tmp355_;
					ValaSymbol* _tmp356_;
					ValaSemanticAnalyzer* _tmp357_;
					ValaSemanticAnalyzer* _tmp358_;
					ValaMethod* _tmp359_;
					ValaParameter* _tmp360_;
					ValaParameter* _tmp361_;
					_tmp352_ = ma;
					_tmp353_ = vala_member_access_get_inner (_tmp352_);
					_tmp354_ = _tmp353_;
					_tmp355_ = vala_expression_get_symbol_reference (_tmp354_);
					_tmp356_ = _tmp355_;
					_tmp357_ = vala_code_context_get_analyzer (context);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_semantic_analyzer_find_current_method (_tmp358_);
					_tmp360_ = vala_method_get_this_parameter (_tmp359_);
					_tmp361_ = _tmp360_;
					if (_tmp356_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp361_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						ValaMemberAccess* _tmp362_;
						ValaSourceReference* _tmp363_;
						ValaSourceReference* _tmp364_;
						ValaProperty* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						gchar* _tmp368_;
						gchar* _tmp369_;
						_tmp362_ = ma;
						_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp362_);
						_tmp364_ = _tmp363_;
						_tmp365_ = prop;
						_tmp366_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = g_strdup_printf ("Property `%s' is read-only", _tmp367_);
						_tmp369_ = _tmp368_;
						vala_report_error (_tmp364_, _tmp369_);
						_g_free0 (_tmp369_);
						_g_free0 (_tmp367_);
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp370_;
						ValaSourceReference* _tmp371_;
						ValaSourceReference* _tmp372_;
						_tmp370_ = ma;
						_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp370_);
						_tmp372_ = _tmp371_;
						vala_report_error (_tmp372_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						return result;
					}
				}
			}
		} else {
			gboolean _tmp373_ = FALSE;
			ValaMemberAccess* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaSymbol* _tmp376_;
			_tmp374_ = ma;
			_tmp375_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp374_);
			_tmp376_ = _tmp375_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp376_)) {
				ValaMemberAccess* _tmp377_;
				ValaExpression* _tmp378_;
				ValaExpression* _tmp379_;
				ValaDataType* _tmp380_;
				ValaDataType* _tmp381_;
				gboolean _tmp382_;
				gboolean _tmp383_;
				_tmp377_ = ma;
				_tmp378_ = vala_member_access_get_inner (_tmp377_);
				_tmp379_ = _tmp378_;
				_tmp380_ = vala_expression_get_value_type (_tmp379_);
				_tmp381_ = _tmp380_;
				_tmp382_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp381_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp383_ = _tmp382_;
				_tmp373_ = _tmp383_;
			} else {
				_tmp373_ = FALSE;
			}
			if (_tmp373_) {
				ValaSourceReference* _tmp384_;
				ValaSourceReference* _tmp385_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp385_ = _tmp384_;
				vala_report_error (_tmp385_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp386_ = FALSE;
				ValaMemberAccess* _tmp387_;
				ValaSymbol* _tmp388_;
				ValaSymbol* _tmp389_;
				_tmp387_ = ma;
				_tmp388_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp387_);
				_tmp389_ = _tmp388_;
				if (VALA_IS_VARIABLE (_tmp389_)) {
					ValaExpression* _tmp390_;
					ValaExpression* _tmp391_;
					ValaDataType* _tmp392_;
					ValaDataType* _tmp393_;
					_tmp390_ = vala_assignment_get_right (self);
					_tmp391_ = _tmp390_;
					_tmp392_ = vala_expression_get_value_type (_tmp391_);
					_tmp393_ = _tmp392_;
					_tmp386_ = VALA_IS_METHOD_TYPE (_tmp393_);
				} else {
					_tmp386_ = FALSE;
				}
				if (_tmp386_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp394_;
					ValaSymbol* _tmp395_;
					ValaSymbol* _tmp396_;
					ValaVariable* _tmp397_;
					ValaDataType* _tmp398_;
					ValaDataType* _tmp399_;
					_tmp394_ = ma;
					_tmp395_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp394_);
					_tmp396_ = _tmp395_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp396_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp397_ = variable;
					_tmp398_ = vala_variable_get_variable_type (_tmp397_);
					_tmp399_ = _tmp398_;
					if (VALA_IS_DELEGATE_TYPE (_tmp399_)) {
						ValaExpression* _tmp400_;
						ValaExpression* _tmp401_;
						ValaDataType* _tmp402_;
						ValaDataType* _tmp403_;
						ValaVariable* _tmp404_;
						ValaDataType* _tmp405_;
						ValaDataType* _tmp406_;
						_tmp400_ = vala_assignment_get_right (self);
						_tmp401_ = _tmp400_;
						_tmp402_ = vala_expression_get_value_type (_tmp401_);
						_tmp403_ = _tmp402_;
						_tmp404_ = variable;
						_tmp405_ = vala_variable_get_variable_type (_tmp404_);
						_tmp406_ = _tmp405_;
						if (!vala_data_type_compatible (_tmp403_, _tmp406_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp407_;
							ValaExpression* _tmp408_;
							ValaSymbol* _tmp409_;
							ValaSymbol* _tmp410_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp411_;
							ValaDataType* _tmp412_;
							ValaDataType* _tmp413_;
							ValaDelegate* _tmp414_;
							ValaDelegate* _tmp415_;
							ValaSourceReference* _tmp416_;
							ValaSourceReference* _tmp417_;
							ValaMethod* _tmp418_;
							gchar* _tmp419_;
							gchar* _tmp420_;
							ValaDelegate* _tmp421_;
							gchar* _tmp422_;
							gchar* _tmp423_;
							gchar* _tmp424_;
							gchar* _tmp425_;
							_tmp407_ = vala_assignment_get_right (self);
							_tmp408_ = _tmp407_;
							_tmp409_ = vala_expression_get_symbol_reference (_tmp408_);
							_tmp410_ = _tmp409_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp410_, VALA_TYPE_METHOD, ValaMethod);
							_tmp411_ = variable;
							_tmp412_ = vala_variable_get_variable_type (_tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp413_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp415_ = _tmp414_;
							cb = _tmp415_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp416_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp417_ = _tmp416_;
							_tmp418_ = m;
							_tmp419_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = cb;
							_tmp422_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp420_, _tmp423_);
							_tmp425_ = _tmp424_;
							vala_report_error (_tmp417_, _tmp425_);
							_g_free0 (_tmp425_);
							_g_free0 (_tmp423_);
							_g_free0 (_tmp420_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp426_;
						ValaSourceReference* _tmp427_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp427_ = _tmp426_;
						vala_report_error (_tmp427_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					ValaMemberAccess* _tmp428_;
					ValaSymbol* _tmp429_;
					ValaSymbol* _tmp430_;
					_tmp428_ = ma;
					_tmp429_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp428_);
					_tmp430_ = _tmp429_;
					if (VALA_IS_VARIABLE (_tmp430_)) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp431_;
						ValaSymbol* _tmp432_;
						ValaSymbol* _tmp433_;
						ValaArrayType* variable_array_type = NULL;
						ValaVariable* _tmp434_;
						ValaDataType* _tmp435_;
						ValaDataType* _tmp436_;
						gboolean _tmp437_ = FALSE;
						gboolean _tmp438_ = FALSE;
						gboolean _tmp439_ = FALSE;
						ValaArrayType* _tmp440_;
						_tmp431_ = ma;
						_tmp432_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp431_);
						_tmp433_ = _tmp432_;
						variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp433_, VALA_TYPE_VARIABLE, ValaVariable);
						_tmp434_ = variable;
						_tmp435_ = vala_variable_get_variable_type (_tmp434_);
						_tmp436_ = _tmp435_;
						variable_array_type = VALA_IS_ARRAY_TYPE (_tmp436_) ? ((ValaArrayType*) _tmp436_) : NULL;
						_tmp440_ = variable_array_type;
						if (_tmp440_ != NULL) {
							ValaArrayType* _tmp441_;
							gboolean _tmp442_;
							gboolean _tmp443_;
							_tmp441_ = variable_array_type;
							_tmp442_ = vala_array_type_get_fixed_length (_tmp441_);
							_tmp443_ = _tmp442_;
							_tmp439_ = _tmp443_;
						} else {
							_tmp439_ = FALSE;
						}
						if (_tmp439_) {
							ValaExpression* _tmp444_;
							ValaExpression* _tmp445_;
							_tmp444_ = vala_assignment_get_right (self);
							_tmp445_ = _tmp444_;
							_tmp438_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp445_);
						} else {
							_tmp438_ = FALSE;
						}
						if (_tmp438_) {
							ValaExpression* _tmp446_;
							ValaExpression* _tmp447_;
							ValaInitializerList* _tmp448_;
							ValaInitializerList* _tmp449_;
							_tmp446_ = vala_assignment_get_right (self);
							_tmp447_ = _tmp446_;
							_tmp448_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp447_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
							_tmp449_ = _tmp448_;
							_tmp437_ = _tmp449_ == NULL;
						} else {
							_tmp437_ = FALSE;
						}
						if (_tmp437_) {
							ValaSourceReference* _tmp450_;
							ValaSourceReference* _tmp451_;
							ValaCodeNode* _tmp452_;
							ValaCodeNode* _tmp453_;
							ValaCodeNode* _tmp454_;
							ValaCodeNode* _tmp455_;
							ValaCodeNode* _tmp456_;
							ValaCodeNode* _tmp457_;
							ValaSourceReference* _tmp458_;
							ValaSourceReference* _tmp459_;
							ValaEmptyStatement* _tmp460_;
							ValaEmptyStatement* _tmp461_;
							_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp451_ = _tmp450_;
							vala_report_warning (_tmp451_, "Arrays with fixed length don't require an explicit instantiation");
							_tmp452_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp453_ = _tmp452_;
							_tmp454_ = vala_code_node_get_parent_node (_tmp453_);
							_tmp455_ = _tmp454_;
							_tmp456_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp457_ = _tmp456_;
							_tmp458_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp459_ = _tmp458_;
							_tmp460_ = vala_empty_statement_new (_tmp459_);
							_tmp461_ = _tmp460_;
							vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp455_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp461_);
							_vala_code_node_unref0 (_tmp461_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
		_tmp463_ = vala_assignment_get_left (self);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_expression_get_value_type (_tmp464_);
		_tmp466_ = _tmp465_;
		if (_tmp466_ != NULL) {
			ValaExpression* _tmp467_;
			ValaExpression* _tmp468_;
			ValaDataType* _tmp469_;
			ValaDataType* _tmp470_;
			_tmp467_ = vala_assignment_get_right (self);
			_tmp468_ = _tmp467_;
			_tmp469_ = vala_expression_get_value_type (_tmp468_);
			_tmp470_ = _tmp469_;
			_tmp462_ = _tmp470_ != NULL;
		} else {
			_tmp462_ = FALSE;
		}
		if (_tmp462_) {
			ValaExpression* _tmp471_;
			ValaExpression* _tmp472_;
			ValaDataType* _tmp473_;
			ValaDataType* _tmp474_;
			ValaExpression* _tmp475_;
			ValaExpression* _tmp476_;
			ValaDataType* _tmp477_;
			ValaDataType* _tmp478_;
			ValaMemberAccess* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaSymbol* _tmp497_;
			_tmp471_ = vala_assignment_get_right (self);
			_tmp472_ = _tmp471_;
			_tmp473_ = vala_expression_get_value_type (_tmp472_);
			_tmp474_ = _tmp473_;
			_tmp475_ = vala_assignment_get_left (self);
			_tmp476_ = _tmp475_;
			_tmp477_ = vala_expression_get_value_type (_tmp476_);
			_tmp478_ = _tmp477_;
			if (!vala_data_type_compatible (_tmp474_, _tmp478_)) {
				ValaSourceReference* _tmp479_;
				ValaSourceReference* _tmp480_;
				ValaExpression* _tmp481_;
				ValaExpression* _tmp482_;
				ValaDataType* _tmp483_;
				ValaDataType* _tmp484_;
				gchar* _tmp485_;
				gchar* _tmp486_;
				ValaExpression* _tmp487_;
				ValaExpression* _tmp488_;
				ValaDataType* _tmp489_;
				ValaDataType* _tmp490_;
				gchar* _tmp491_;
				gchar* _tmp492_;
				gchar* _tmp493_;
				gchar* _tmp494_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp480_ = _tmp479_;
				_tmp481_ = vala_assignment_get_right (self);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_expression_get_value_type (_tmp482_);
				_tmp484_ = _tmp483_;
				_tmp485_ = vala_code_node_to_string ((ValaCodeNode*) _tmp484_);
				_tmp486_ = _tmp485_;
				_tmp487_ = vala_assignment_get_left (self);
				_tmp488_ = _tmp487_;
				_tmp489_ = vala_expression_get_value_type (_tmp488_);
				_tmp490_ = _tmp489_;
				_tmp491_ = vala_code_node_to_string ((ValaCodeNode*) _tmp490_);
				_tmp492_ = _tmp491_;
				_tmp493_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp486_, _tmp492_);
				_tmp494_ = _tmp493_;
				vala_report_error (_tmp480_, _tmp494_);
				_g_free0 (_tmp494_);
				_g_free0 (_tmp492_);
				_g_free0 (_tmp486_);
				result = FALSE;
				return result;
			}
			_tmp495_ = ma;
			_tmp496_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp495_);
			_tmp497_ = _tmp496_;
			if (!VALA_IS_PROPERTY (_tmp497_)) {
				ValaExpression* _tmp498_;
				ValaExpression* _tmp499_;
				ValaDataType* _tmp500_;
				ValaDataType* _tmp501_;
				_tmp498_ = vala_assignment_get_right (self);
				_tmp499_ = _tmp498_;
				_tmp500_ = vala_expression_get_value_type (_tmp499_);
				_tmp501_ = _tmp500_;
				if (vala_data_type_is_disposable (_tmp501_)) {
					gboolean _tmp502_ = FALSE;
					ValaExpression* _tmp503_;
					ValaExpression* _tmp504_;
					ValaDataType* _tmp505_;
					ValaDataType* _tmp506_;
					_tmp503_ = vala_assignment_get_left (self);
					_tmp504_ = _tmp503_;
					_tmp505_ = vala_expression_get_value_type (_tmp504_);
					_tmp506_ = _tmp505_;
					if (!VALA_IS_POINTER_TYPE (_tmp506_)) {
						ValaExpression* _tmp507_;
						ValaExpression* _tmp508_;
						ValaDataType* _tmp509_;
						ValaDataType* _tmp510_;
						gboolean _tmp511_;
						gboolean _tmp512_;
						_tmp507_ = vala_assignment_get_left (self);
						_tmp508_ = _tmp507_;
						_tmp509_ = vala_expression_get_value_type (_tmp508_);
						_tmp510_ = _tmp509_;
						_tmp511_ = vala_data_type_get_value_owned (_tmp510_);
						_tmp512_ = _tmp511_;
						_tmp502_ = !_tmp512_;
					} else {
						_tmp502_ = FALSE;
					}
					if (_tmp502_) {
						ValaSourceReference* _tmp513_;
						ValaSourceReference* _tmp514_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp513_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp514_ = _tmp513_;
						vala_report_error (_tmp514_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp515_;
					ValaExpression* _tmp516_;
					ValaDataType* _tmp517_;
					ValaDataType* _tmp518_;
					gboolean _tmp519_;
					gboolean _tmp520_;
					_tmp515_ = vala_assignment_get_left (self);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_expression_get_value_type (_tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_data_type_get_value_owned (_tmp518_);
					_tmp520_ = _tmp519_;
					if (_tmp520_) {
					}
				}
			}
		}
		_tmp521_ = vala_assignment_get_right (self);
		_tmp522_ = _tmp521_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp522_) ? ((ValaMemberAccess*) _tmp522_) : NULL;
		_tmp524_ = right_ma;
		if (_tmp524_ != NULL) {
			ValaMemberAccess* _tmp525_;
			ValaSymbol* _tmp526_;
			ValaSymbol* _tmp527_;
			ValaMemberAccess* _tmp528_;
			ValaSymbol* _tmp529_;
			ValaSymbol* _tmp530_;
			_tmp525_ = ma;
			_tmp526_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp525_);
			_tmp527_ = _tmp526_;
			_tmp528_ = right_ma;
			_tmp529_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp528_);
			_tmp530_ = _tmp529_;
			_tmp523_ = _tmp527_ == _tmp530_;
		} else {
			_tmp523_ = FALSE;
		}
		if (_tmp523_) {
			gboolean _tmp531_ = FALSE;
			ValaMemberAccess* _tmp532_;
			ValaSymbol* _tmp533_;
			ValaSymbol* _tmp534_;
			_tmp532_ = ma;
			_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
			_tmp534_ = _tmp533_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp534_)) {
				_tmp531_ = TRUE;
			} else {
				ValaMemberAccess* _tmp535_;
				ValaSymbol* _tmp536_;
				ValaSymbol* _tmp537_;
				_tmp535_ = ma;
				_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp535_);
				_tmp537_ = _tmp536_;
				_tmp531_ = VALA_IS_PARAMETER (_tmp537_);
			}
			if (_tmp531_) {
				ValaSourceReference* _tmp538_;
				ValaSourceReference* _tmp539_;
				_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp539_ = _tmp538_;
				vala_report_warning (_tmp539_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp540_;
				ValaSymbol* _tmp541_;
				ValaSymbol* _tmp542_;
				_tmp540_ = ma;
				_tmp541_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp540_);
				_tmp542_ = _tmp541_;
				if (VALA_IS_FIELD (_tmp542_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp543_;
					ValaSymbol* _tmp544_;
					ValaSymbol* _tmp545_;
					ValaField* _tmp546_;
					ValaMemberBinding _tmp547_;
					ValaMemberBinding _tmp548_;
					_tmp543_ = ma;
					_tmp544_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp543_);
					_tmp545_ = _tmp544_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp545_, VALA_TYPE_FIELD, ValaField);
					_tmp546_ = f;
					_tmp547_ = vala_field_get_binding (_tmp546_);
					_tmp548_ = _tmp547_;
					if (_tmp548_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp549_;
						ValaSourceReference* _tmp550_;
						_tmp549_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp550_ = _tmp549_;
						vala_report_warning (_tmp550_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp551_;
						ValaExpression* _tmp552_;
						ValaExpression* _tmp553_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp554_;
						ValaExpression* _tmp555_;
						ValaExpression* _tmp556_;
						gboolean _tmp557_ = FALSE;
						gboolean _tmp558_ = FALSE;
						gboolean _tmp559_ = FALSE;
						gboolean _tmp560_ = FALSE;
						gboolean _tmp561_ = FALSE;
						ValaMemberAccess* _tmp562_;
						_tmp551_ = ma;
						_tmp552_ = vala_member_access_get_inner (_tmp551_);
						_tmp553_ = _tmp552_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp553_) ? ((ValaMemberAccess*) _tmp553_) : NULL;
						_tmp554_ = right_ma;
						_tmp555_ = vala_member_access_get_inner (_tmp554_);
						_tmp556_ = _tmp555_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp556_) ? ((ValaMemberAccess*) _tmp556_) : NULL;
						_tmp562_ = ma_inner;
						if (_tmp562_ != NULL) {
							ValaMemberAccess* _tmp563_;
							const gchar* _tmp564_;
							const gchar* _tmp565_;
							_tmp563_ = ma_inner;
							_tmp564_ = vala_member_access_get_member_name (_tmp563_);
							_tmp565_ = _tmp564_;
							_tmp561_ = g_strcmp0 (_tmp565_, "this") == 0;
						} else {
							_tmp561_ = FALSE;
						}
						if (_tmp561_) {
							ValaMemberAccess* _tmp566_;
							ValaExpression* _tmp567_;
							ValaExpression* _tmp568_;
							_tmp566_ = ma_inner;
							_tmp567_ = vala_member_access_get_inner (_tmp566_);
							_tmp568_ = _tmp567_;
							_tmp560_ = _tmp568_ == NULL;
						} else {
							_tmp560_ = FALSE;
						}
						if (_tmp560_) {
							ValaMemberAccess* _tmp569_;
							_tmp569_ = right_ma_inner;
							_tmp559_ = _tmp569_ != NULL;
						} else {
							_tmp559_ = FALSE;
						}
						if (_tmp559_) {
							ValaMemberAccess* _tmp570_;
							const gchar* _tmp571_;
							const gchar* _tmp572_;
							_tmp570_ = right_ma_inner;
							_tmp571_ = vala_member_access_get_member_name (_tmp570_);
							_tmp572_ = _tmp571_;
							_tmp558_ = g_strcmp0 (_tmp572_, "this") == 0;
						} else {
							_tmp558_ = FALSE;
						}
						if (_tmp558_) {
							ValaMemberAccess* _tmp573_;
							ValaExpression* _tmp574_;
							ValaExpression* _tmp575_;
							_tmp573_ = right_ma_inner;
							_tmp574_ = vala_member_access_get_inner (_tmp573_);
							_tmp575_ = _tmp574_;
							_tmp557_ = _tmp575_ == NULL;
						} else {
							_tmp557_ = FALSE;
						}
						if (_tmp557_) {
							ValaSourceReference* _tmp576_;
							ValaSourceReference* _tmp577_;
							_tmp576_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp577_ = _tmp576_;
							vala_report_warning (_tmp577_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaExpression* _tmp578_;
		ValaExpression* _tmp579_;
		_tmp578_ = vala_assignment_get_left (self);
		_tmp579_ = _tmp578_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp579_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp580_;
			ValaExpression* _tmp581_;
			ValaExpression* _tmp582_;
			ValaExpression* _tmp583_;
			ValaDataType* _tmp584_;
			ValaDataType* _tmp585_;
			ValaExpression* _tmp586_;
			ValaExpression* _tmp587_;
			ValaDataType* _tmp588_;
			ValaDataType* _tmp589_;
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			_tmp580_ = vala_assignment_get_left (self);
			_tmp581_ = _tmp580_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp582_ = vala_assignment_get_right (self);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_expression_get_value_type (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_assignment_get_left (self);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_expression_get_value_type (_tmp587_);
			_tmp589_ = _tmp588_;
			if (!vala_data_type_compatible (_tmp585_, _tmp589_)) {
				ValaSourceReference* _tmp590_;
				ValaSourceReference* _tmp591_;
				ValaExpression* _tmp592_;
				ValaExpression* _tmp593_;
				ValaDataType* _tmp594_;
				ValaDataType* _tmp595_;
				gchar* _tmp596_;
				gchar* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				ValaDataType* _tmp600_;
				ValaDataType* _tmp601_;
				gchar* _tmp602_;
				gchar* _tmp603_;
				gchar* _tmp604_;
				gchar* _tmp605_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp591_ = _tmp590_;
				_tmp592_ = vala_assignment_get_right (self);
				_tmp593_ = _tmp592_;
				_tmp594_ = vala_expression_get_value_type (_tmp593_);
				_tmp595_ = _tmp594_;
				_tmp596_ = vala_code_node_to_string ((ValaCodeNode*) _tmp595_);
				_tmp597_ = _tmp596_;
				_tmp598_ = vala_assignment_get_left (self);
				_tmp599_ = _tmp598_;
				_tmp600_ = vala_expression_get_value_type (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_code_node_to_string ((ValaCodeNode*) _tmp601_);
				_tmp603_ = _tmp602_;
				_tmp604_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp597_, _tmp603_);
				_tmp605_ = _tmp604_;
				vala_report_error (_tmp591_, _tmp605_);
				_g_free0 (_tmp605_);
				_g_free0 (_tmp603_);
				_g_free0 (_tmp597_);
				result = FALSE;
				return result;
			}
			_tmp606_ = vala_assignment_get_right (self);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_expression_get_value_type (_tmp607_);
			_tmp609_ = _tmp608_;
			if (vala_data_type_is_disposable (_tmp609_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp610_;
				ValaExpression* _tmp611_;
				ValaExpression* _tmp612_;
				ValaDataType* _tmp613_;
				ValaDataType* _tmp614_;
				gboolean _tmp636_ = FALSE;
				ValaDataType* _tmp637_;
				_tmp610_ = ea;
				_tmp611_ = vala_element_access_get_container (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_expression_get_value_type (_tmp612_);
				_tmp614_ = _tmp613_;
				if (VALA_IS_ARRAY_TYPE (_tmp614_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp615_;
					ValaExpression* _tmp616_;
					ValaExpression* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaArrayType* _tmp620_;
					ValaDataType* _tmp621_;
					ValaDataType* _tmp622_;
					ValaDataType* _tmp623_;
					_tmp615_ = ea;
					_tmp616_ = vala_element_access_get_container (_tmp615_);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_expression_get_value_type (_tmp617_);
					_tmp619_ = _tmp618_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp619_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp620_ = array_type;
					_tmp621_ = vala_array_type_get_element_type (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp623_ = _vala_code_node_ref0 (_tmp622_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp623_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					ValaList* _tmp629_;
					ValaList* _tmp630_;
					ValaList* _tmp631_;
					gint _tmp632_;
					gint _tmp633_;
					ValaList* _tmp634_;
					gpointer _tmp635_;
					_tmp624_ = ea;
					_tmp625_ = vala_element_access_get_container (_tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_expression_get_value_type (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_data_type_get_type_arguments (_tmp628_);
					_tmp630_ = _vala_iterable_ref0 (_tmp629_);
					args = _tmp630_;
					_tmp631_ = args;
					_tmp632_ = vala_collection_get_size ((ValaCollection*) _tmp631_);
					_tmp633_ = _tmp632_;
					_vala_assert (_tmp633_ == 1, "args.size == 1");
					_tmp634_ = args;
					_tmp635_ = vala_list_get (_tmp634_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp635_;
					_vala_iterable_unref0 (args);
				}
				_tmp637_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp637_)) {
					ValaDataType* _tmp638_;
					gboolean _tmp639_;
					gboolean _tmp640_;
					_tmp638_ = element_type;
					_tmp639_ = vala_data_type_get_value_owned (_tmp638_);
					_tmp640_ = _tmp639_;
					_tmp636_ = !_tmp640_;
				} else {
					_tmp636_ = FALSE;
				}
				if (_tmp636_) {
					ValaSourceReference* _tmp641_;
					ValaSourceReference* _tmp642_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp641_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp642_ = _tmp641_;
					vala_report_error (_tmp642_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp643_;
				ValaExpression* _tmp644_;
				ValaDataType* _tmp645_;
				ValaDataType* _tmp646_;
				gboolean _tmp647_;
				gboolean _tmp648_;
				_tmp643_ = vala_assignment_get_left (self);
				_tmp644_ = _tmp643_;
				_tmp645_ = vala_expression_get_value_type (_tmp644_);
				_tmp646_ = _tmp645_;
				_tmp647_ = vala_data_type_get_value_owned (_tmp646_);
				_tmp648_ = _tmp647_;
				if (_tmp648_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp649_ = vala_assignment_get_left (self);
	_tmp650_ = _tmp649_;
	_tmp651_ = vala_expression_get_value_type (_tmp650_);
	_tmp652_ = _tmp651_;
	if (_tmp652_ != NULL) {
		ValaExpression* _tmp653_;
		ValaExpression* _tmp654_;
		ValaDataType* _tmp655_;
		ValaDataType* _tmp656_;
		ValaDataType* _tmp657_;
		ValaDataType* _tmp658_;
		ValaDataType* _tmp659_;
		ValaDataType* _tmp660_;
		_tmp653_ = vala_assignment_get_left (self);
		_tmp654_ = _tmp653_;
		_tmp655_ = vala_expression_get_value_type (_tmp654_);
		_tmp656_ = _tmp655_;
		_tmp657_ = vala_data_type_copy (_tmp656_);
		_tmp658_ = _tmp657_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp658_);
		_vala_code_node_unref0 (_tmp658_);
		_tmp659_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp660_ = _tmp659_;
		vala_data_type_set_value_owned (_tmp660_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp661_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp662_ = _tmp661_;
	if (_tmp662_ != NULL) {
		ValaDataType* _tmp663_;
		ValaDataType* _tmp664_;
		_tmp663_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp664_ = _tmp663_;
		vala_code_node_check ((ValaCodeNode*) _tmp664_, context);
	}
	_tmp665_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp666_ = _tmp665_;
	result = !_tmp666_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

