/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp8_;
	ValaBlock* _tmp33_;
	ValaBlock* _tmp34_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp8_ = ((ValaMethod*) self)->error_types;
	if (_tmp8_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp9_ = ((ValaMethod*) self)->error_types;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp14_ = _error_type_list;
				_tmp15_ = vala_list_get (_tmp14_, _error_type_index);
				error_type = (ValaDataType*) _tmp15_;
				_tmp16_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _precondition_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _precondition_index = 0;
		_tmp17_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_precondition_list = _tmp18_;
		_tmp19_ = _precondition_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_precondition_size = _tmp21_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp22_ = _precondition_list;
			_tmp23_ = vala_list_get (_tmp22_, _precondition_index);
			precondition = (ValaExpression*) _tmp23_;
			_tmp24_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _postcondition_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _postcondition_index = 0;
		_tmp25_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_postcondition_list = _tmp26_;
		_tmp27_ = _postcondition_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_postcondition_size = _tmp29_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaExpression* _tmp32_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp30_ = _postcondition_list;
			_tmp31_ = vala_list_get (_tmp30_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp31_;
			_tmp32_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp33_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaBlock* _tmp35_;
		ValaBlock* _tmp36_;
		_tmp35_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	gint i = 0;
	ValaList* _tmp65_;
	ValaBlock* _tmp90_;
	ValaBlock* _tmp91_;
	ValaSemanticAnalyzer* _tmp215_;
	ValaSemanticAnalyzer* _tmp216_;
	ValaSourceFile* _tmp217_;
	ValaSemanticAnalyzer* _tmp218_;
	ValaSemanticAnalyzer* _tmp219_;
	ValaSymbol* _tmp220_;
	gboolean _tmp221_ = FALSE;
	gboolean _tmp222_ = FALSE;
	gboolean _tmp223_;
	gboolean _tmp224_;
	gboolean _tmp235_ = FALSE;
	ValaBlock* _tmp236_;
	ValaBlock* _tmp237_;
	gboolean _tmp276_;
	gboolean _tmp277_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaParameter* _tmp24_;
		ValaParameter* _tmp25_;
		_tmp24_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp46_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp51_;
			gpointer _tmp52_;
			ValaParameter* _tmp53_;
			gboolean _tmp54_ = FALSE;
			gboolean _tmp55_ = FALSE;
			gint _tmp64_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp51_ = _param_list;
			_tmp52_ = vala_list_get (_tmp51_, _param_index);
			param = (ValaParameter*) _tmp52_;
			_tmp53_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp53_, context);
			if (i == 0) {
				ValaParameter* _tmp56_;
				gboolean _tmp57_;
				gboolean _tmp58_;
				_tmp56_ = param;
				_tmp57_ = vala_parameter_get_ellipsis (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaBlock* _tmp59_;
				ValaBlock* _tmp60_;
				_tmp59_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp60_ = _tmp59_;
				_tmp54_ = _tmp60_ != NULL;
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				ValaParameter* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp61_ = param;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp63_, "Named parameter required before `...'");
			}
			_tmp64_ = i;
			i = _tmp64_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp65_ = ((ValaMethod*) self)->error_types;
	if (_tmp65_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _error_type_size = 0;
			ValaList* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _error_type_index = 0;
			_tmp66_ = ((ValaMethod*) self)->error_types;
			_tmp67_ = _vala_iterable_ref0 (_tmp66_);
			_error_type_list = _tmp67_;
			_tmp68_ = _error_type_list;
			_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_error_type_size = _tmp70_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp71_;
				gpointer _tmp72_;
				ValaDataType* _tmp73_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp71_ = _error_type_list;
				_tmp72_ = vala_list_get (_tmp71_, _error_type_index);
				error_type = (ValaDataType*) _tmp72_;
				_tmp73_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp73_, context);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp74_;
		ValaList* _tmp75_;
		gint _precondition_size = 0;
		ValaList* _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint _precondition_index = 0;
		_tmp74_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp75_ = _vala_iterable_ref0 (_tmp74_);
		_precondition_list = _tmp75_;
		_tmp76_ = _precondition_list;
		_tmp77_ = vala_collection_get_size ((ValaCollection*) _tmp76_);
		_tmp78_ = _tmp77_;
		_precondition_size = _tmp78_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp79_;
			gpointer _tmp80_;
			ValaExpression* _tmp81_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp79_ = _precondition_list;
			_tmp80_ = vala_list_get (_tmp79_, _precondition_index);
			precondition = (ValaExpression*) _tmp80_;
			_tmp81_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp81_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp82_;
		ValaList* _tmp83_;
		gint _postcondition_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _postcondition_index = 0;
		_tmp82_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp83_ = _vala_iterable_ref0 (_tmp82_);
		_postcondition_list = _tmp83_;
		_tmp84_ = _postcondition_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_postcondition_size = _tmp86_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			ValaExpression* _tmp89_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp87_ = _postcondition_list;
			_tmp88_ = vala_list_get (_tmp87_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp88_;
			_tmp89_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp89_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp90_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp91_ = _tmp90_;
	if (_tmp91_ != NULL) {
		ValaBlock* _tmp92_;
		ValaBlock* _tmp93_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		gboolean _tmp96_ = FALSE;
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_;
		_tmp92_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp93_ = _tmp92_;
		vala_code_node_check ((ValaCodeNode*) _tmp93_, context);
		_tmp94_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp95_ = _tmp94_;
		cl = VALA_IS_CLASS (_tmp95_) ? ((ValaClass*) _tmp95_) : NULL;
		_tmp98_ = self->priv->_chain_up;
		if (!_tmp98_) {
			ValaClass* _tmp99_;
			_tmp99_ = cl;
			_tmp97_ = _tmp99_ != NULL;
		} else {
			_tmp97_ = FALSE;
		}
		if (_tmp97_) {
			ValaClass* _tmp100_;
			ValaClass* _tmp101_;
			ValaClass* _tmp102_;
			_tmp100_ = cl;
			_tmp101_ = vala_class_get_base_class (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp96_ = _tmp102_ != NULL;
		} else {
			_tmp96_ = FALSE;
		}
		if (_tmp96_) {
			gboolean _tmp103_ = FALSE;
			gboolean _tmp104_ = FALSE;
			ValaProfile _tmp105_;
			ValaProfile _tmp106_;
			_tmp105_ = vala_code_context_get_profile (context);
			_tmp106_ = _tmp105_;
			if (_tmp106_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp107_;
				ValaClass* _tmp108_;
				ValaClass* _tmp109_;
				ValaCreationMethod* _tmp110_;
				ValaCreationMethod* _tmp111_;
				_tmp107_ = cl;
				_tmp108_ = vala_class_get_base_class (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_class_get_default_construction_method (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp104_ = _tmp111_ != NULL;
			} else {
				_tmp104_ = FALSE;
			}
			if (_tmp104_) {
				ValaClass* _tmp112_;
				ValaClass* _tmp113_;
				ValaClass* _tmp114_;
				ValaCreationMethod* _tmp115_;
				ValaCreationMethod* _tmp116_;
				gboolean _tmp117_;
				gboolean _tmp118_;
				_tmp112_ = cl;
				_tmp113_ = vala_class_get_base_class (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_class_get_default_construction_method (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp116_);
				_tmp118_ = _tmp117_;
				_tmp103_ = !_tmp118_;
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp119_;
				ValaSemanticAnalyzer* _tmp120_;
				ValaBlock* _tmp121_;
				ValaBlock* _tmp122_;
				ValaSemanticAnalyzer* _tmp123_;
				ValaSemanticAnalyzer* _tmp124_;
				ValaBlock* _tmp125_;
				ValaBlock* _tmp126_;
				ValaSemanticAnalyzer* _tmp127_;
				ValaSemanticAnalyzer* _tmp128_;
				ValaBlock* _tmp129_;
				ValaBlock* _tmp130_;
				ValaBlock* _tmp131_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp132_;
				ValaSourceReference* _tmp133_;
				ValaMemberAccess* _tmp134_;
				ValaMemberAccess* _tmp135_;
				ValaSourceReference* _tmp136_;
				ValaSourceReference* _tmp137_;
				ValaMemberAccess* _tmp138_;
				ValaMemberAccess* _tmp139_;
				ValaSourceReference* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaMethodCall* _tmp142_;
				ValaMethodCall* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				ValaExpressionStatement* _tmp146_;
				ValaExpressionStatement* _tmp147_;
				ValaBlock* _tmp148_;
				ValaBlock* _tmp149_;
				ValaExpressionStatement* _tmp150_;
				ValaExpressionStatement* _tmp151_;
				ValaSemanticAnalyzer* _tmp152_;
				ValaSemanticAnalyzer* _tmp153_;
				ValaSemanticAnalyzer* _tmp154_;
				ValaSemanticAnalyzer* _tmp155_;
				ValaBlock* _tmp156_;
				ValaBlock* _tmp157_;
				_tmp119_ = vala_code_context_get_analyzer (context);
				_tmp120_ = _tmp119_;
				_tmp121_ = _tmp120_->insert_block;
				_tmp122_ = _vala_code_node_ref0 (_tmp121_);
				old_insert_block = _tmp122_;
				_tmp123_ = vala_code_context_get_analyzer (context);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp126_ = _tmp125_;
				vala_semantic_analyzer_set_current_symbol (_tmp124_, (ValaSymbol*) _tmp126_);
				_tmp127_ = vala_code_context_get_analyzer (context);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 (_tmp130_);
				_vala_code_node_unref0 (_tmp128_->insert_block);
				_tmp128_->insert_block = _tmp131_;
				_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_member_access_new_simple ("GLib", _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_member_access_new ((ValaExpression*) _tmp135_, "Object", _tmp137_);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_method_call_new ((ValaExpression*) _tmp139_, _tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_expression_statement_new ((ValaExpression*) _tmp143_, _tmp145_);
				_tmp147_ = _tmp146_;
				_vala_code_node_unref0 (_tmp143_);
				_vala_code_node_unref0 (_tmp139_);
				_vala_code_node_unref0 (_tmp135_);
				stmt = _tmp147_;
				_tmp148_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp149_ = _tmp148_;
				_tmp150_ = stmt;
				vala_block_insert_statement (_tmp149_, 0, (ValaStatement*) _tmp150_);
				_tmp151_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp151_, context);
				_tmp152_ = vala_code_context_get_analyzer (context);
				_tmp153_ = _tmp152_;
				vala_semantic_analyzer_set_current_symbol (_tmp153_, (ValaSymbol*) self);
				_tmp154_ = vala_code_context_get_analyzer (context);
				_tmp155_ = _tmp154_;
				_tmp156_ = old_insert_block;
				_tmp157_ = _vala_code_node_ref0 (_tmp156_);
				_vala_code_node_unref0 (_tmp155_->insert_block);
				_tmp155_->insert_block = _tmp157_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp158_ = FALSE;
				ValaClass* _tmp159_;
				ValaClass* _tmp160_;
				ValaClass* _tmp161_;
				ValaCreationMethod* _tmp162_;
				ValaCreationMethod* _tmp163_;
				_tmp159_ = cl;
				_tmp160_ = vala_class_get_base_class (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_class_get_default_construction_method (_tmp161_);
				_tmp163_ = _tmp162_;
				if (_tmp163_ == NULL) {
					_tmp158_ = TRUE;
				} else {
					ValaClass* _tmp164_;
					ValaClass* _tmp165_;
					ValaClass* _tmp166_;
					ValaCreationMethod* _tmp167_;
					ValaCreationMethod* _tmp168_;
					ValaSymbolAccessibility _tmp169_;
					ValaSymbolAccessibility _tmp170_;
					_tmp164_ = cl;
					_tmp165_ = vala_class_get_base_class (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
					_tmp168_ = _tmp167_;
					_tmp169_ = vala_symbol_get_access ((ValaSymbol*) _tmp168_);
					_tmp170_ = _tmp169_;
					_tmp158_ = _tmp170_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp158_) {
					ValaSourceReference* _tmp171_;
					ValaSourceReference* _tmp172_;
					_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp172_ = _tmp171_;
					vala_report_error (_tmp172_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp173_;
					ValaClass* _tmp174_;
					ValaClass* _tmp175_;
					ValaCreationMethod* _tmp176_;
					ValaCreationMethod* _tmp177_;
					_tmp173_ = cl;
					_tmp174_ = vala_class_get_base_class (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp176_ = vala_class_get_default_construction_method (_tmp175_);
					_tmp177_ = _tmp176_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp177_) > 0) {
						ValaSourceReference* _tmp178_;
						ValaSourceReference* _tmp179_;
						_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp179_ = _tmp178_;
						vala_report_error (_tmp179_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp180_;
						ValaSemanticAnalyzer* _tmp181_;
						ValaBlock* _tmp182_;
						ValaBlock* _tmp183_;
						ValaSemanticAnalyzer* _tmp184_;
						ValaSemanticAnalyzer* _tmp185_;
						ValaBlock* _tmp186_;
						ValaBlock* _tmp187_;
						ValaSemanticAnalyzer* _tmp188_;
						ValaSemanticAnalyzer* _tmp189_;
						ValaBlock* _tmp190_;
						ValaBlock* _tmp191_;
						ValaBlock* _tmp192_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp193_;
						ValaSourceReference* _tmp194_;
						ValaBaseAccess* _tmp195_;
						ValaBaseAccess* _tmp196_;
						ValaSourceReference* _tmp197_;
						ValaSourceReference* _tmp198_;
						ValaMethodCall* _tmp199_;
						ValaMethodCall* _tmp200_;
						ValaSourceReference* _tmp201_;
						ValaSourceReference* _tmp202_;
						ValaExpressionStatement* _tmp203_;
						ValaExpressionStatement* _tmp204_;
						ValaBlock* _tmp205_;
						ValaBlock* _tmp206_;
						ValaExpressionStatement* _tmp207_;
						ValaExpressionStatement* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaSemanticAnalyzer* _tmp210_;
						ValaSemanticAnalyzer* _tmp211_;
						ValaSemanticAnalyzer* _tmp212_;
						ValaBlock* _tmp213_;
						ValaBlock* _tmp214_;
						_tmp180_ = vala_code_context_get_analyzer (context);
						_tmp181_ = _tmp180_;
						_tmp182_ = _tmp181_->insert_block;
						_tmp183_ = _vala_code_node_ref0 (_tmp182_);
						old_insert_block = _tmp183_;
						_tmp184_ = vala_code_context_get_analyzer (context);
						_tmp185_ = _tmp184_;
						_tmp186_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp187_ = _tmp186_;
						vala_semantic_analyzer_set_current_symbol (_tmp185_, (ValaSymbol*) _tmp187_);
						_tmp188_ = vala_code_context_get_analyzer (context);
						_tmp189_ = _tmp188_;
						_tmp190_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp191_ = _tmp190_;
						_tmp192_ = _vala_code_node_ref0 (_tmp191_);
						_vala_code_node_unref0 (_tmp189_->insert_block);
						_tmp189_->insert_block = _tmp192_;
						_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp194_ = _tmp193_;
						_tmp195_ = vala_base_access_new (_tmp194_);
						_tmp196_ = _tmp195_;
						_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp198_ = _tmp197_;
						_tmp199_ = vala_method_call_new ((ValaExpression*) _tmp196_, _tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp202_ = _tmp201_;
						_tmp203_ = vala_expression_statement_new ((ValaExpression*) _tmp200_, _tmp202_);
						_tmp204_ = _tmp203_;
						_vala_code_node_unref0 (_tmp200_);
						_vala_code_node_unref0 (_tmp196_);
						stmt = _tmp204_;
						_tmp205_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp206_ = _tmp205_;
						_tmp207_ = stmt;
						vala_block_insert_statement (_tmp206_, 0, (ValaStatement*) _tmp207_);
						_tmp208_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
						_tmp209_ = vala_code_context_get_analyzer (context);
						_tmp210_ = _tmp209_;
						vala_semantic_analyzer_set_current_symbol (_tmp210_, (ValaSymbol*) self);
						_tmp211_ = vala_code_context_get_analyzer (context);
						_tmp212_ = _tmp211_;
						_tmp213_ = old_insert_block;
						_tmp214_ = _vala_code_node_ref0 (_tmp213_);
						_vala_code_node_unref0 (_tmp212_->insert_block);
						_tmp212_->insert_block = _tmp214_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp215_ = vala_code_context_get_analyzer (context);
	_tmp216_ = _tmp215_;
	_tmp217_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp216_, _tmp217_);
	_tmp218_ = vala_code_context_get_analyzer (context);
	_tmp219_ = _tmp218_;
	_tmp220_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp219_, _tmp220_);
	_tmp223_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp224_ = _tmp223_;
	if (_tmp224_) {
		_tmp222_ = TRUE;
	} else {
		gboolean _tmp225_;
		gboolean _tmp226_;
		_tmp225_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp226_ = _tmp225_;
		_tmp222_ = _tmp226_;
	}
	if (_tmp222_) {
		_tmp221_ = TRUE;
	} else {
		gboolean _tmp227_;
		gboolean _tmp228_;
		_tmp227_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp228_ = _tmp227_;
		_tmp221_ = _tmp228_;
	}
	if (_tmp221_) {
		ValaSourceReference* _tmp229_;
		ValaSourceReference* _tmp230_;
		gchar* _tmp231_;
		gchar* _tmp232_;
		gchar* _tmp233_;
		gchar* _tmp234_;
		_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp230_ = _tmp229_;
		_tmp231_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp232_);
		_tmp234_ = _tmp233_;
		vala_report_error (_tmp230_, _tmp234_);
		_g_free0 (_tmp234_);
		_g_free0 (_tmp232_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp236_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp237_ = _tmp236_;
	if (_tmp237_ != NULL) {
		ValaBlock* _tmp238_;
		ValaBlock* _tmp239_;
		gboolean _tmp240_;
		gboolean _tmp241_;
		_tmp238_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_code_node_get_error ((ValaCodeNode*) _tmp239_);
		_tmp241_ = _tmp240_;
		_tmp235_ = !_tmp241_;
	} else {
		_tmp235_ = FALSE;
	}
	if (_tmp235_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp242_;
		ValaArrayList* _tmp243_;
		ValaBlock* _tmp244_;
		ValaBlock* _tmp245_;
		ValaArrayList* _tmp246_;
		_tmp242_ = g_direct_equal;
		_tmp243_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp242_);
		body_errors = _tmp243_;
		_tmp244_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp245_ = _tmp244_;
		_tmp246_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp245_, (ValaCollection*) _tmp246_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp247_;
			ValaArrayList* _tmp248_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp249_;
			gint _tmp250_;
			gint _tmp251_;
			gint _body_error_type_index = 0;
			_tmp247_ = body_errors;
			_tmp248_ = _vala_iterable_ref0 (_tmp247_);
			_body_error_type_list = _tmp248_;
			_tmp249_ = _body_error_type_list;
			_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
			_tmp251_ = _tmp250_;
			_body_error_type_size = _tmp251_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp252_;
				gpointer _tmp253_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp254_;
				gboolean _tmp264_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp252_ = _body_error_type_list;
				_tmp253_ = vala_list_get ((ValaList*) _tmp252_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp253_;
				can_propagate_error = FALSE;
				_tmp254_ = ((ValaMethod*) self)->error_types;
				if (_tmp254_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp255_;
						ValaList* _tmp256_;
						gint _method_error_type_size = 0;
						ValaList* _tmp257_;
						gint _tmp258_;
						gint _tmp259_;
						gint _method_error_type_index = 0;
						_tmp255_ = ((ValaMethod*) self)->error_types;
						_tmp256_ = _vala_iterable_ref0 (_tmp255_);
						_method_error_type_list = _tmp256_;
						_tmp257_ = _method_error_type_list;
						_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
						_tmp259_ = _tmp258_;
						_method_error_type_size = _tmp259_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp260_;
							gpointer _tmp261_;
							ValaDataType* _tmp262_;
							ValaDataType* _tmp263_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp260_ = _method_error_type_list;
							_tmp261_ = vala_list_get (_tmp260_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp261_;
							_tmp262_ = body_error_type;
							_tmp263_ = method_error_type;
							if (vala_data_type_compatible (_tmp262_, _tmp263_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp265_;
					gboolean _tmp266_;
					gboolean _tmp267_;
					_tmp265_ = body_error_type;
					_tmp266_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp265_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp267_ = _tmp266_;
					_tmp264_ = !_tmp267_;
				} else {
					_tmp264_ = FALSE;
				}
				if (_tmp264_) {
					ValaDataType* _tmp268_;
					ValaSourceReference* _tmp269_;
					ValaSourceReference* _tmp270_;
					ValaDataType* _tmp271_;
					gchar* _tmp272_;
					gchar* _tmp273_;
					gchar* _tmp274_;
					gchar* _tmp275_;
					_tmp268_ = body_error_type;
					_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = body_error_type;
					_tmp272_ = vala_code_node_to_string ((ValaCodeNode*) _tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = g_strdup_printf ("unhandled error `%s'", _tmp273_);
					_tmp275_ = _tmp274_;
					vala_report_warning (_tmp270_, _tmp275_);
					_g_free0 (_tmp275_);
					_g_free0 (_tmp273_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp276_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp277_ = _tmp276_;
	result = !_tmp277_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

