/* valaarraytype.c generated by valac, the Vala compiler
 * generated from valaarraytype.vala, do not modify */

/* valaarraytype.vala
 *
 * Copyright (C) 2007-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaArrayTypePrivate {
	gboolean _invalid_syntax;
	gboolean _inline_allocated;
	gboolean _fixed_length;
	gint _rank;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaExpression* _length;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
	ValaArrayCopyMethod* copy_method;
};

static gint ValaArrayType_private_offset;
static gpointer vala_array_type_parent_class = NULL;

static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base,
                                             const gchar* member_name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaArrayCopyMethod* vala_array_type_get_copy_method (ValaArrayType* self);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base,
                                                 ValaScope* scope);
static gboolean vala_array_type_real_compatible (ValaDataType* base,
                                          ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static void vala_array_type_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base,
                                        ValaDataType* old_type,
                                        ValaDataType* new_type);
static gboolean vala_array_type_real_is_accessible (ValaDataType* base,
                                             ValaSymbol* sym);
static gboolean vala_array_type_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base,
                                                    ValaDataType* derived_instance_type,
                                                    ValaList* method_type_arguments,
                                                    ValaCodeNode* node_reference);
static ValaDataType* vala_array_type_real_infer_type_argument (ValaDataType* base,
                                                        ValaTypeParameter* type_param,
                                                        ValaDataType* value_type);
static gboolean vala_array_type_real_is_disposable (ValaDataType* base);
static void vala_array_type_finalize (ValaCodeNode * obj);
static GType vala_array_type_get_type_once (void);

static inline gpointer
vala_array_type_get_instance_private (ValaArrayType* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayType_private_offset);
}

ValaDataType*
vala_array_type_get_element_type (ValaArrayType* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_array_type_set_element_type (ValaArrayType* self,
                                  ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_type_get_length_type (ValaArrayType* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_type_set_length_type (ValaArrayType* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_array_type_get_invalid_syntax (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_invalid_syntax;
	return result;
}

void
vala_array_type_set_invalid_syntax (ValaArrayType* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_invalid_syntax = value;
}

gboolean
vala_array_type_get_inline_allocated (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inline_allocated;
	return result;
}

void
vala_array_type_set_inline_allocated (ValaArrayType* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_inline_allocated = value;
}

gboolean
vala_array_type_get_fixed_length (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed_length;
	return result;
}

void
vala_array_type_set_fixed_length (ValaArrayType* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_fixed_length = value;
}

ValaExpression*
vala_array_type_get_length (ValaArrayType* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}

void
vala_array_type_set_length (ValaArrayType* self,
                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length);
	self->priv->_length = _tmp0_;
	_tmp1_ = self->priv->_length;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_length;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_type_get_rank (ValaArrayType* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

void
vala_array_type_set_rank (ValaArrayType* self,
                          gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaArrayType*
vala_array_type_construct (GType object_type,
                           ValaDataType* element_type,
                           gint rank,
                           ValaSourceReference* source_reference)
{
	ValaArrayType* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) vala_reference_type_construct (object_type, NULL);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaArrayType*
vala_array_type_new (ValaDataType* element_type,
                     gint rank,
                     ValaSourceReference* source_reference)
{
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}

static ValaSymbol*
vala_array_type_real_get_member (ValaDataType* base,
                                 const gchar* member_name)
{
	ValaArrayType * self;
	ValaSymbol* result = NULL;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if (g_strcmp0 (member_name, "length") == 0) {
		ValaArrayLengthField* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_array_type_get_length_field (self);
		_tmp1_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp0_);
		result = _tmp1_;
		return result;
	} else {
		if (g_strcmp0 (member_name, "move") == 0) {
			ValaArrayMoveMethod* _tmp2_;
			ValaSymbol* _tmp3_;
			_tmp2_ = vala_array_type_get_move_method (self);
			_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (g_strcmp0 (member_name, "resize") == 0) {
				gint _tmp4_;
				ValaArrayResizeMethod* _tmp5_;
				ValaSymbol* _tmp6_;
				_tmp4_ = self->priv->_rank;
				if (_tmp4_ > 1) {
					result = NULL;
					return result;
				}
				_tmp5_ = vala_array_type_get_resize_method (self);
				_tmp6_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp5_);
				result = _tmp6_;
				return result;
			} else {
				if (g_strcmp0 (member_name, "copy") == 0) {
					ValaArrayCopyMethod* _tmp7_;
					ValaSymbol* _tmp8_;
					_tmp7_ = vala_array_type_get_copy_method (self);
					_tmp8_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp7_);
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static ValaArrayLengthField*
vala_array_type_get_length_field (ValaArrayType* self)
{
	ValaArrayLengthField* _tmp0_;
	ValaArrayLengthField* _tmp20_;
	ValaArrayLengthField* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->length_field;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayLengthField* _tmp3_;
		ValaArrayLengthField* _tmp4_;
		gint _tmp5_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_length_field_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->length_field);
		self->priv->length_field = _tmp3_;
		_tmp4_ = self->priv->length_field;
		vala_symbol_set_access ((ValaSymbol*) _tmp4_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp5_ = self->priv->_rank;
		if (_tmp5_ > 1) {
			ValaArrayLengthField* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaDataType* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaArrayType* _tmp13_;
			ValaArrayType* _tmp14_;
			_tmp6_ = self->priv->length_field;
			_tmp7_ = vala_array_type_get_length_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_copy (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_array_type_new (_tmp10_, 1, _tmp12_);
			_tmp14_ = _tmp13_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp6_, (ValaDataType*) _tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			_vala_code_node_unref0 (_tmp10_);
		} else {
			ValaArrayLengthField* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp15_ = self->priv->length_field;
			_tmp16_ = vala_array_type_get_length_type (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_data_type_copy (_tmp17_);
			_tmp19_ = _tmp18_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp15_, _tmp19_);
			_vala_code_node_unref0 (_tmp19_);
		}
	}
	_tmp20_ = self->priv->length_field;
	result = _tmp20_;
	return result;
}

static ValaArrayResizeMethod*
vala_array_type_get_resize_method (ValaArrayType* self)
{
	ValaArrayResizeMethod* _tmp0_;
	ValaArrayResizeMethod* _tmp21_;
	ValaArrayResizeMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->resize_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayResizeMethod* _tmp3_;
		ValaArrayResizeMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayResizeMethod* _tmp7_;
		ValaCodeContext* _tmp8_;
		ValaCodeContext* _tmp9_;
		ValaProfile _tmp10_;
		ValaProfile _tmp11_;
		gboolean _tmp12_;
		ValaArrayResizeMethod* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		ValaArrayResizeMethod* _tmp20_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_resize_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->resize_method);
		self->priv->resize_method = _tmp3_;
		_tmp4_ = self->priv->resize_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->resize_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = vala_code_context_get ();
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_context_get_profile (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ == VALA_PROFILE_POSIX;
		_vala_code_context_unref0 (_tmp9_);
		if (_tmp12_) {
			ValaArrayResizeMethod* _tmp13_;
			_tmp13_ = self->priv->resize_method;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp13_, "CCode", "cname", "realloc", NULL);
		} else {
			ValaArrayResizeMethod* _tmp14_;
			_tmp14_ = self->priv->resize_method;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp14_, "CCode", "cname", "g_renew", NULL);
		}
		_tmp15_ = self->priv->resize_method;
		_tmp16_ = vala_array_type_get_length_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_parameter_new ("length", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		vala_callable_add_parameter ((ValaCallable*) _tmp15_, _tmp19_);
		_vala_code_node_unref0 (_tmp19_);
		_tmp20_ = self->priv->resize_method;
		vala_method_set_returns_modified_pointer ((ValaMethod*) _tmp20_, TRUE);
	}
	_tmp21_ = self->priv->resize_method;
	result = _tmp21_;
	return result;
}

static ValaArrayMoveMethod*
vala_array_type_get_move_method (ValaArrayType* self)
{
	ValaArrayMoveMethod* _tmp0_;
	ValaArrayMoveMethod* _tmp24_;
	ValaArrayMoveMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->move_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayMoveMethod* _tmp3_;
		ValaArrayMoveMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayMoveMethod* _tmp7_;
		ValaArrayMoveMethod* _tmp8_;
		ValaArrayMoveMethod* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		ValaArrayMoveMethod* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		ValaArrayMoveMethod* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_move_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->move_method);
		self->priv->move_method = _tmp3_;
		_tmp4_ = self->priv->move_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->move_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->move_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "cname", "_vala_array_move", NULL);
		_tmp9_ = self->priv->move_method;
		_tmp10_ = vala_array_type_get_length_type (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_parameter_new ("src", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_callable_add_parameter ((ValaCallable*) _tmp9_, _tmp13_);
		_vala_code_node_unref0 (_tmp13_);
		_tmp14_ = self->priv->move_method;
		_tmp15_ = vala_array_type_get_length_type (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_parameter_new ("dest", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		vala_callable_add_parameter ((ValaCallable*) _tmp14_, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp19_ = self->priv->move_method;
		_tmp20_ = vala_array_type_get_length_type (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new ("length", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		vala_callable_add_parameter ((ValaCallable*) _tmp19_, _tmp23_);
		_vala_code_node_unref0 (_tmp23_);
	}
	_tmp24_ = self->priv->move_method;
	result = _tmp24_;
	return result;
}

static ValaArrayCopyMethod*
vala_array_type_get_copy_method (ValaArrayType* self)
{
	ValaArrayCopyMethod* _tmp0_;
	ValaArrayCopyMethod* _tmp12_;
	ValaArrayCopyMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->copy_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayCopyMethod* _tmp3_;
		ValaArrayCopyMethod* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaArrayCopyMethod* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaArrayCopyMethod* _tmp10_;
		ValaArrayCopyMethod* _tmp11_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_copy_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->copy_method);
		self->priv->copy_method = _tmp3_;
		_tmp4_ = self->priv->copy_method;
		_tmp5_ = vala_data_type_copy ((ValaDataType*) self);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->copy_method;
		_tmp8_ = vala_callable_get_return_type ((ValaCallable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
		_tmp10_ = self->priv->copy_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp10_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp11_ = self->priv->copy_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp11_, "CCode", "cname", "_vala_array_copy", NULL);
	}
	_tmp12_ = self->priv->copy_method;
	result = _tmp12_;
	return result;
}

static ValaDataType*
vala_array_type_real_copy (ValaDataType* base)
{
	ValaArrayType * self;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gint _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaArrayType* _tmp7_;
	ValaArrayType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaArrayType* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ValaArrayType* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	ValaArrayType* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	ValaArrayType* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ValaDataType* result = NULL;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_copy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_rank;
	_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_array_type_new (_tmp3_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_code_node_unref0 (_tmp3_);
	_result_ = _tmp8_;
	_tmp9_ = vala_array_type_get_length_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaArrayType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp11_ = _result_;
		_tmp12_ = vala_array_type_get_length_type (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_array_type_set_length_type (_tmp11_, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
	}
	_tmp16_ = _result_;
	_tmp17_ = vala_data_type_get_value_owned ((ValaDataType*) self);
	_tmp18_ = _tmp17_;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp16_, _tmp18_);
	_tmp19_ = _result_;
	_tmp20_ = vala_data_type_get_nullable ((ValaDataType*) self);
	_tmp21_ = _tmp20_;
	vala_data_type_set_nullable ((ValaDataType*) _tmp19_, _tmp21_);
	_tmp22_ = _result_;
	_tmp23_ = vala_data_type_get_floating_reference ((ValaDataType*) self);
	_tmp24_ = _tmp23_;
	vala_data_type_set_floating_reference ((ValaDataType*) _tmp22_, _tmp24_);
	_tmp25_ = _result_;
	_tmp26_ = self->priv->_inline_allocated;
	vala_array_type_set_inline_allocated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->_fixed_length;
	if (_tmp27_) {
		ValaArrayType* _tmp28_;
		ValaArrayType* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp28_ = _result_;
		vala_array_type_set_fixed_length (_tmp28_, TRUE);
		_tmp29_ = _result_;
		_tmp30_ = vala_array_type_get_length (self);
		_tmp31_ = _tmp30_;
		vala_array_type_set_length (_tmp29_, _tmp31_);
	}
	result = (ValaDataType*) _result_;
	return result;
}

static gchar*
vala_array_type_real_to_qualified_string (ValaDataType* base,
                                          ValaScope* scope)
{
	ValaArrayType * self;
	gchar* elem_str = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp10_;
	gchar* result = NULL;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_to_qualified_string (_tmp1_, scope);
	elem_str = _tmp2_;
	_tmp4_ = vala_array_type_get_element_type (self);
	_tmp5_ = _tmp4_;
	if (vala_data_type_is_weak (_tmp5_)) {
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		_tmp6_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		_tmp3_ = !VALA_IS_CONSTANT (_tmp7_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = elem_str;
		_tmp9_ = g_strdup_printf ("(unowned %s)", _tmp8_);
		_g_free0 (elem_str);
		elem_str = _tmp9_;
	}
	_tmp10_ = self->priv->_fixed_length;
	if (!_tmp10_) {
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_;
		gboolean _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = vala_data_type_get_nullable ((ValaDataType*) self);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			_tmp11_ = "?";
		} else {
			_tmp11_ = "";
		}
		_tmp14_ = elem_str;
		_tmp15_ = self->priv->_rank;
		_tmp16_ = g_strnfill ((gsize) (_tmp15_ - 1), ',');
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s[%s]%s", _tmp14_, _tmp17_, _tmp11_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		result = _tmp19_;
		_g_free0 (elem_str);
		return result;
	} else {
		result = elem_str;
		return result;
	}
	_g_free0 (elem_str);
}

static gboolean
vala_array_type_real_compatible (ValaDataType* base,
                                 ValaDataType* target_type)
{
	ValaArrayType * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaProfile _tmp3_;
	ValaProfile _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp41_ = FALSE;
	ValaArrayType* target_array_type = NULL;
	ValaArrayType* _tmp48_;
	ValaArrayType* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gboolean _tmp52_ = FALSE;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	ValaArrayType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	gboolean _tmp69_ = FALSE;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	ValaArrayType* _tmp72_;
	ValaDataType* _tmp73_;
	ValaDataType* _tmp74_;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_profile (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == VALA_PROFILE_GOBJECT;
	_vala_code_context_unref0 (_tmp2_);
	if (_tmp5_) {
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		_tmp6_ = vala_data_type_get_type_symbol (target_type);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp8_ = FALSE;
		ValaTypeSymbol* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		ValaCodeContext* _tmp11_;
		ValaCodeContext* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaStructValueType* _tmp15_;
		ValaTypeSymbol* _tmp16_;
		ValaTypeSymbol* _tmp17_;
		gboolean _tmp18_;
		ValaTypeSymbol* _tmp31_;
		ValaTypeSymbol* _tmp32_;
		ValaCodeContext* _tmp33_;
		ValaCodeContext* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSemanticAnalyzer* _tmp36_;
		ValaObjectType* _tmp37_;
		ValaTypeSymbol* _tmp38_;
		ValaTypeSymbol* _tmp39_;
		gboolean _tmp40_;
		_tmp9_ = vala_data_type_get_type_symbol (target_type);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get ();
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->gvalue_type;
		_tmp16_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_typesymbol_is_subtype_of (_tmp10_, _tmp17_);
		_vala_code_context_unref0 (_tmp12_);
		if (_tmp18_) {
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaTypeSymbol* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaCodeContext* _tmp24_;
			ValaNamespace* _tmp25_;
			ValaNamespace* _tmp26_;
			ValaScope* _tmp27_;
			ValaScope* _tmp28_;
			ValaSymbol* _tmp29_;
			ValaSymbol* _tmp30_;
			_tmp19_ = vala_array_type_get_element_type (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_context_get ();
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_code_context_get_root (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_symbol_get_scope ((ValaSymbol*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_scope_lookup (_tmp28_, "string");
			_tmp30_ = _tmp29_;
			_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp30_;
			_vala_code_node_unref0 (_tmp30_);
			_vala_code_context_unref0 (_tmp24_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			result = TRUE;
			return result;
		}
		_tmp31_ = vala_data_type_get_type_symbol (target_type);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_code_context_get ();
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_code_context_get_analyzer (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_->gvariant_type;
		_tmp38_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_typesymbol_is_subtype_of (_tmp32_, _tmp39_);
		_vala_code_context_unref0 (_tmp34_);
		if (_tmp40_) {
			result = TRUE;
			return result;
		}
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp41_ = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		ValaTypeSymbol* _tmp43_;
		ValaTypeSymbol* _tmp44_;
		_tmp43_ = vala_data_type_get_type_symbol (target_type);
		_tmp44_ = _tmp43_;
		if (_tmp44_ != NULL) {
			ValaTypeSymbol* _tmp45_;
			ValaTypeSymbol* _tmp46_;
			ValaAttribute* _tmp47_;
			_tmp45_ = vala_data_type_get_type_symbol (target_type);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp46_, "PointerType");
			_tmp42_ = _tmp47_ != NULL;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp41_ = _tmp42_;
	}
	if (_tmp41_) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (target_type)) {
		result = TRUE;
		return result;
	}
	target_array_type = VALA_IS_ARRAY_TYPE (target_type) ? ((ValaArrayType*) target_type) : NULL;
	_tmp48_ = target_array_type;
	if (_tmp48_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp49_ = target_array_type;
	_tmp50_ = _tmp49_->priv->_rank;
	_tmp51_ = self->priv->_rank;
	if (_tmp50_ != _tmp51_) {
		result = FALSE;
		return result;
	}
	_tmp53_ = vala_array_type_get_element_type (self);
	_tmp54_ = _tmp53_;
	if (VALA_IS_VALUE_TYPE (_tmp54_)) {
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		ValaArrayType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		gboolean _tmp62_;
		gboolean _tmp63_;
		_tmp55_ = vala_array_type_get_element_type (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_data_type_get_nullable (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = target_array_type;
		_tmp60_ = vala_array_type_get_element_type (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_data_type_get_nullable (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp52_ = _tmp58_ != _tmp63_;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		result = FALSE;
		return result;
	}
	_tmp64_ = vala_array_type_get_length_type (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = target_array_type;
	_tmp67_ = vala_array_type_get_length_type (_tmp66_);
	_tmp68_ = _tmp67_;
	if (!vala_data_type_compatible (_tmp65_, _tmp68_)) {
		result = FALSE;
		return result;
	}
	_tmp70_ = vala_array_type_get_element_type (self);
	_tmp71_ = _tmp70_;
	_tmp72_ = target_array_type;
	_tmp73_ = vala_array_type_get_element_type (_tmp72_);
	_tmp74_ = _tmp73_;
	if (vala_data_type_compatible (_tmp71_, _tmp74_)) {
		ValaArrayType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		_tmp75_ = target_array_type;
		_tmp76_ = vala_array_type_get_element_type (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_array_type_get_element_type (self);
		_tmp79_ = _tmp78_;
		_tmp69_ = vala_data_type_compatible (_tmp77_, _tmp79_);
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base)
{
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}

static void
vala_array_type_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_array_type_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_array_type_get_length_type (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_array_type_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type)
{
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_type_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_type_set_length_type (self, new_type);
	}
}

static gboolean
vala_array_type_real_is_accessible (ValaDataType* base,
                                    ValaSymbol* sym)
{
	ValaArrayType * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_type_get_length_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_type_get_length_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_array_type_get_element_type (self);
	_tmp6_ = _tmp5_;
	result = vala_data_type_is_accessible (_tmp6_, sym);
	return result;
}

static gboolean
vala_array_type_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaArrayType * self;
	gboolean _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->_invalid_syntax;
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, no expression allowed between array brackets");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_fixed_length;
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_array_type_get_length (self);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp7_ = vala_array_type_get_length (self);
		_tmp8_ = _tmp7_;
		vala_code_node_check ((ValaCodeNode*) _tmp8_, context);
		_tmp11_ = vala_array_type_get_length (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_expression_get_value_type (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			ValaExpression* _tmp15_;
			ValaExpression* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = vala_array_type_get_length (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_expression_get_value_type (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp10_ = !VALA_IS_INTEGER_TYPE (_tmp18_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaExpression* _tmp19_;
			ValaExpression* _tmp20_;
			_tmp19_ = vala_array_type_get_length (self);
			_tmp20_ = _tmp19_;
			_tmp9_ = !vala_expression_is_constant (_tmp20_);
		}
		if (_tmp9_) {
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp21_ = vala_array_type_get_length (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
			_tmp24_ = _tmp23_;
			vala_report_error (_tmp24_, "Expression of constant integer type expected");
			result = FALSE;
			return result;
		}
	}
	_tmp25_ = vala_array_type_get_element_type (self);
	_tmp26_ = _tmp25_;
	if (VALA_IS_ARRAY_TYPE (_tmp26_)) {
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		vala_report_error (_tmp28_, "Stacked arrays are not supported");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp29_;
		ValaDataType* _tmp30_;
		_tmp29_ = vala_array_type_get_element_type (self);
		_tmp30_ = _tmp29_;
		if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDelegateType* _tmp33_;
			ValaDelegateType* _tmp34_;
			ValaDelegate* _tmp35_;
			ValaDelegate* _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp38_;
			_tmp31_ = vala_array_type_get_element_type (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp33_;
			_tmp34_ = delegate_type;
			_tmp35_ = vala_delegate_type_get_delegate_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_delegate_get_has_target (_tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp40_, "Delegates with target are not supported as array element type");
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				return result;
			}
			_vala_code_node_unref0 (delegate_type);
		}
	}
	_tmp41_ = vala_array_type_get_length_type (self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ == NULL) {
		ValaSemanticAnalyzer* _tmp43_;
		ValaSemanticAnalyzer* _tmp44_;
		ValaDataType* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		_tmp43_ = vala_code_context_get_analyzer (context);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_->int_type;
		_tmp46_ = vala_data_type_copy (_tmp45_);
		_tmp47_ = _tmp46_;
		vala_array_type_set_length_type (self, _tmp47_);
		_vala_code_node_unref0 (_tmp47_);
	} else {
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_array_type_get_length_type (self);
		_tmp49_ = _tmp48_;
		vala_code_node_check ((ValaCodeNode*) _tmp49_, context);
		_tmp50_ = vala_array_type_get_length_type (self);
		_tmp51_ = _tmp50_;
		if (!VALA_IS_INTEGER_TYPE (_tmp51_)) {
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp52_ = vala_array_type_get_length_type (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
			_tmp55_ = _tmp54_;
			vala_report_error (_tmp55_, "Expected integer type as length type of array");
			result = FALSE;
			return result;
		}
	}
	_tmp56_ = vala_array_type_get_element_type (self);
	_tmp57_ = _tmp56_;
	result = vala_code_node_check ((ValaCodeNode*) _tmp57_, context);
	return result;
}

static ValaDataType*
vala_array_type_real_get_actual_type (ValaDataType* base,
                                      ValaDataType* derived_instance_type,
                                      ValaList* method_type_arguments,
                                      ValaCodeNode* node_reference)
{
	ValaArrayType * self;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* result = NULL;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_data_type_copy ((ValaDataType*) self);
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	if (derived_instance_type == NULL) {
		_tmp1_ = method_type_arguments == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (ValaDataType*) _result_;
		return result;
	}
	_tmp3_ = vala_array_type_get_element_type (self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_GENERIC_TYPE (_tmp4_)) {
		_tmp2_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp5_ = vala_array_type_get_element_type (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = vala_data_type_has_type_arguments (_tmp6_);
	}
	if (_tmp2_) {
		ValaArrayType* _tmp7_;
		ValaArrayType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = _result_;
		_tmp8_ = _result_;
		_tmp9_ = vala_array_type_get_element_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_data_type_get_actual_type (_tmp10_, derived_instance_type, method_type_arguments, node_reference);
		_tmp12_ = _tmp11_;
		vala_array_type_set_element_type (_tmp7_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
	}
	result = (ValaDataType*) _result_;
	return result;
}

static ValaDataType*
vala_array_type_real_infer_type_argument (ValaDataType* base,
                                          ValaTypeParameter* type_param,
                                          ValaDataType* value_type)
{
	ValaArrayType * self;
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp0_;
	ValaDataType* result = NULL;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	array_type = VALA_IS_ARRAY_TYPE (value_type) ? ((ValaArrayType*) value_type) : NULL;
	_tmp0_ = array_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaArrayType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp1_ = vala_array_type_get_element_type (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_element_type (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_infer_type_argument (_tmp2_, type_param, _tmp5_);
		result = _tmp6_;
		return result;
	}
	result = NULL;
	return result;
}

static gboolean
vala_array_type_real_is_disposable (ValaDataType* base)
{
	ValaArrayType * self;
	gboolean _tmp0_;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	_tmp0_ = self->priv->_fixed_length;
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		_tmp1_ = vala_array_type_get_element_type (self);
		_tmp2_ = _tmp1_;
		result = vala_data_type_is_disposable (_tmp2_);
		return result;
	} else {
		result = VALA_DATA_TYPE_CLASS (vala_array_type_parent_class)->is_disposable ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_REFERENCE_TYPE, ValaReferenceType));
		return result;
	}
}

static void
vala_array_type_class_init (ValaArrayTypeClass * klass,
                            gpointer klass_data)
{
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_type_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayType_private_offset);
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_array_type_real_get_member;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_array_type_real_copy;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType*, ValaScope*)) vala_array_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_array_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType*)) vala_array_type_real_is_reference_type_or_type_parameter;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_type_real_replace_type;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType*, ValaSymbol*)) vala_array_type_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_type_real_check;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType*, ValaDataType*, ValaList*, ValaCodeNode*)) vala_array_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType*, ValaTypeParameter*, ValaDataType*)) vala_array_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType*)) vala_array_type_real_is_disposable;
}

static void
vala_array_type_instance_init (ValaArrayType * self,
                               gpointer klass)
{
	self->priv = vala_array_type_get_instance_private (self);
}

static void
vala_array_type_finalize (ValaCodeNode * obj)
{
	ValaArrayType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_length);
	_vala_code_node_unref0 (self->priv->length_field);
	_vala_code_node_unref0 (self->priv->resize_method);
	_vala_code_node_unref0 (self->priv->move_method);
	_vala_code_node_unref0 (self->priv->copy_method);
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}

/**
 * An array type.
 */
static GType
vala_array_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
	GType vala_array_type_type_id;
	vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	ValaArrayType_private_offset = g_type_add_instance_private (vala_array_type_type_id, sizeof (ValaArrayTypePrivate));
	return vala_array_type_type_id;
}

GType
vala_array_type_get_type (void)
{
	static volatile gsize vala_array_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_type_type_id__volatile)) {
		GType vala_array_type_type_id;
		vala_array_type_type_id = vala_array_type_get_type_once ();
		g_once_init_leave (&vala_array_type_type_id__volatile, vala_array_type_type_id);
	}
	return vala_array_type_type_id__volatile;
}

