/* valaarraycreationexpression.c generated by valac, the Vala compiler
 * generated from valaarraycreationexpression.vala, do not modify */

/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	ValaList* sizes;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaInitializerList* _initializer_list;
};

static gint ValaArrayCreationExpression_private_offset;
static gpointer vala_array_creation_expression_parent_class = NULL;

static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                          ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                            ValaSymbol* sym);
static gchar* vala_array_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                             ValaExpression* old_node,
                                                             ValaExpression* new_node);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                       ValaDataType* old_type,
                                                       ValaDataType* new_type);
static gint vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                        ValaCodeContext* context,
                                                                        ValaInitializerList* il,
                                                                        gint rank,
                                                                        ValaList* sl);
static gboolean vala_array_creation_expression_real_check (ValaCodeNode* base,
                                                    ValaCodeContext* context);
static void vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                               ValaCodeGenerator* codegen);
static void vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_array_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_array_creation_expression_get_type_once (void);

static inline gpointer
vala_array_creation_expression_get_instance_private (ValaArrayCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayCreationExpression_private_offset);
}

ValaDataType*
vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self,
                                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_creation_expression_get_length_type (ValaArrayCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_length_type (ValaArrayCreationExpression* self,
                                                ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

void
vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self,
                                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaInitializerList*
vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	ValaInitializerList* result;
	ValaInitializerList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer_list;
	result = _tmp0_;
	return result;
}

void
vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self,
                                                     ValaInitializerList* value)
{
	ValaInitializerList* _tmp0_;
	ValaInitializerList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	self->priv->_initializer_list = _tmp0_;
	_tmp1_ = self->priv->_initializer_list;
	if (_tmp1_ != NULL) {
		ValaInitializerList* _tmp2_;
		_tmp2_ = self->priv->_initializer_list;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

/**
 * Add a size expression.
 */
void
vala_array_creation_expression_append_size (ValaArrayCreationExpression* self,
                                            ValaExpression* size)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->sizes;
	vala_collection_add ((ValaCollection*) _tmp0_, size);
	if (size != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) size, (ValaCodeNode*) self);
	}
}

/**
 * Get the sizes for all dimensions ascending from left to right.
 */
ValaList*
vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sizes;
	result = _tmp0_;
	return result;
}

ValaArrayCreationExpression*
vala_array_creation_expression_construct (GType object_type,
                                          ValaDataType* element_type,
                                          gint rank,
                                          ValaInitializerList* initializer_list,
                                          ValaSourceReference* source_reference)
{
	ValaArrayCreationExpression* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayCreationExpression*) vala_expression_construct (object_type);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaArrayCreationExpression*
vala_array_creation_expression_new (ValaDataType* element_type,
                                    gint rank,
                                    ValaInitializerList* initializer_list,
                                    ValaSourceReference* source_reference)
{
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_array_creation_expression_real_accept_children (ValaCodeNode* base,
                                                     ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaInitializerList* _tmp18_;
	ValaInitializerList* _tmp19_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_array_creation_expression_get_element_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_array_creation_expression_get_length_type (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_array_creation_expression_get_length_type (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _e_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _e_index = 0;
		_tmp8_ = self->priv->sizes;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* e = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_e_index = _e_index + 1;
			_tmp13_ = _e_index;
			_tmp14_ = _e_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _e_list;
			_tmp16_ = vala_list_get (_tmp15_, _e_index);
			e = (ValaExpression*) _tmp16_;
			_tmp17_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp18_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaInitializerList* _tmp20_;
		ValaInitializerList* _tmp21_;
		_tmp20_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp21_ = _tmp20_;
		vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
	}
}

static void
vala_array_creation_expression_real_accept (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_array_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaArrayCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_array_creation_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaInitializerList* _tmp20_;
	ValaInitializerList* _tmp21_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_creation_expression_get_element_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_creation_expression_get_element_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_array_creation_expression_get_length_type (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_array_creation_expression_get_length_type (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = !vala_data_type_is_accessible (_tmp9_, sym);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _e_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _e_index = 0;
		_tmp10_ = self->priv->sizes;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_e_list = _tmp11_;
		_tmp12_ = _e_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_e_size = _tmp14_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaExpression* e = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			_e_index = _e_index + 1;
			_tmp15_ = _e_index;
			_tmp16_ = _e_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _e_list;
			_tmp18_ = vala_list_get (_tmp17_, _e_index);
			e = (ValaExpression*) _tmp18_;
			_tmp19_ = e;
			if (!vala_expression_is_accessible (_tmp19_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (e);
				_vala_iterable_unref0 (_e_list);
				return result;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp20_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaInitializerList* _tmp22_;
		ValaInitializerList* _tmp23_;
		_tmp22_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp23_ = _tmp22_;
		result = vala_expression_is_accessible ((ValaExpression*) _tmp23_, sym);
		return result;
	}
	result = TRUE;
	return result;
}

static gchar*
vala_array_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaArrayCreationExpression * self;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	GString* _tmp23_;
	ValaInitializerList* _tmp24_;
	ValaInitializerList* _tmp25_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result = NULL;
	self = (ValaArrayCreationExpression*) base;
	_tmp0_ = g_string_new ("new ");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = vala_array_creation_expression_get_element_type (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp1_, "%s[", _tmp5_);
	_g_free0 (_tmp5_);
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _size_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _size_index = 0;
		_tmp6_ = self->priv->sizes;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_size_list = _tmp7_;
		_tmp8_ = _size_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_size_size = _tmp10_;
		_size_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* size = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			_size_index = _size_index + 1;
			_tmp11_ = _size_index;
			_tmp12_ = _size_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _size_list;
			_tmp14_ = vala_list_get (_tmp13_, _size_index);
			size = (ValaExpression*) _tmp14_;
			if (first) {
				GString* _tmp15_;
				ValaExpression* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = builder;
				_tmp16_ = size;
				_tmp17_ = vala_code_node_to_string ((ValaCodeNode*) _tmp16_);
				_tmp18_ = _tmp17_;
				g_string_append (_tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				first = FALSE;
			} else {
				GString* _tmp19_;
				ValaExpression* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = builder;
				_tmp20_ = size;
				_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				g_string_append_printf (_tmp19_, ", %s", _tmp22_);
				_g_free0 (_tmp22_);
			}
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	_tmp23_ = builder;
	g_string_append_c (_tmp23_, ']');
	_tmp24_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		GString* _tmp26_;
		ValaInitializerList* _tmp27_;
		ValaInitializerList* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = builder;
		_tmp27_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_code_node_to_string ((ValaCodeNode*) _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append (_tmp26_, _tmp30_);
		_g_free0 (_tmp30_);
	}
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_array_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                        ValaExpression* old_node,
                                                        ValaExpression* new_node)
{
	ValaArrayCreationExpression * self;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->sizes;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->sizes;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->sizes;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_array_creation_expression_real_replace_type (ValaCodeNode* base,
                                                  ValaDataType* old_type,
                                                  ValaDataType* new_type)
{
	ValaArrayCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_creation_expression_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_creation_expression_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_creation_expression_set_length_type (self, new_type);
	}
}

static gint
vala_array_creation_expression_create_sizes_from_initializer_list (ValaArrayCreationExpression* self,
                                                                   ValaCodeContext* context,
                                                                   ValaInitializerList* il,
                                                                   gint rank,
                                                                   ValaList* sl)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint subsize = 0;
	gint _tmp41_;
	gint _tmp42_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (context != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) sl);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_rank;
	if (_tmp1_ == (_tmp2_ - rank)) {
		ValaIntegerLiteral* init = NULL;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaIntegerLiteral* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		_tmp3_ = vala_initializer_list_get_size (il);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_integer_literal_new (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		init = _tmp10_;
		_tmp11_ = init;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
		_tmp12_ = init;
		vala_collection_add ((ValaCollection*) sl, (ValaLiteral*) _tmp12_);
		_vala_code_node_unref0 (init);
	}
	subsize = -1;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _e_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _e_index = 0;
		_tmp13_ = vala_initializer_list_get_initializers (il);
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_e_list = _tmp14_;
		_tmp15_ = _e_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_e_size = _tmp17_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* e = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			gboolean _tmp22_ = FALSE;
			ValaExpression* _tmp23_;
			_e_index = _e_index + 1;
			_tmp18_ = _e_index;
			_tmp19_ = _e_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _e_list;
			_tmp21_ = vala_list_get (_tmp20_, _e_index);
			e = (ValaExpression*) _tmp21_;
			_tmp23_ = e;
			if (VALA_IS_INITIALIZER_LIST (_tmp23_)) {
				ValaExpression* _tmp24_;
				ValaDataType* _tmp25_;
				ValaDataType* _tmp26_;
				_tmp24_ = e;
				_tmp25_ = vala_expression_get_target_type (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp22_ = VALA_IS_ARRAY_TYPE (_tmp26_);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				gint size = 0;
				ValaExpression* _tmp31_;
				gboolean _tmp32_ = FALSE;
				if (rank == 1) {
					ValaExpression* _tmp27_;
					ValaExpression* _tmp28_;
					ValaSourceReference* _tmp29_;
					ValaSourceReference* _tmp30_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp27_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp27_, TRUE);
					_tmp28_ = e;
					_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
					_tmp30_ = _tmp29_;
					vala_report_error (_tmp30_, "Expected array element, got array initializer list");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp31_ = e;
				size = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList), rank - 1, sl);
				if (size == -1) {
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				if (subsize >= 0) {
					_tmp32_ = subsize != size;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) il);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp34_, _tmp36_);
					_g_free0 (_tmp36_);
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				} else {
					subsize = size;
				}
			} else {
				if (rank != 1) {
					ValaExpression* _tmp37_;
					ValaExpression* _tmp38_;
					ValaSourceReference* _tmp39_;
					ValaSourceReference* _tmp40_;
					vala_code_node_set_error ((ValaCodeNode*) il, TRUE);
					_tmp37_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp37_, TRUE);
					_tmp38_ = e;
					_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
					_tmp40_ = _tmp39_;
					vala_report_error (_tmp40_, "Expected array initializer list, got array element");
					result = -1;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp41_ = vala_initializer_list_get_size (il);
	_tmp42_ = _tmp41_;
	result = _tmp42_;
	return result;
}

static gboolean
vala_array_creation_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context)
{
	ValaArrayCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* sizes = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	ValaInitializerList* initlist = NULL;
	ValaInitializerList* _tmp6_;
	ValaInitializerList* _tmp7_;
	ValaInitializerList* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaArrayList* calc_sizes = NULL;
	GEqualFunc _tmp45_;
	ValaArrayList* _tmp46_;
	ValaInitializerList* _tmp47_;
	ValaList* _tmp94_;
	gint _tmp95_;
	gint _tmp96_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	gboolean _tmp134_ = FALSE;
	ValaInitializerList* _tmp135_;
	ValaInitializerList* _tmp136_;
	ValaDataType* _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp146_;
	gint _tmp147_;
	ValaSourceReference* _tmp148_;
	ValaSourceReference* _tmp149_;
	ValaArrayType* _tmp150_;
	ValaArrayType* _tmp151_;
	ValaDataType* _tmp152_;
	ValaDataType* _tmp153_;
	ValaDataType* _tmp154_;
	ValaDataType* _tmp155_;
	ValaDataType* _tmp156_;
	ValaDataType* _tmp157_;
	ValaDataType* _tmp158_;
	ValaDataType* _tmp159_;
	ValaDataType* _tmp172_;
	ValaDataType* _tmp173_;
	ValaDataType* _tmp174_;
	ValaDataType* _tmp175_;
	gboolean _tmp176_;
	gboolean _tmp177_;
	gboolean result = FALSE;
	self = (ValaArrayCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_array_creation_expression_get_sizes (self);
	_tmp5_ = _vala_iterable_ref0 (_tmp4_);
	sizes = _tmp5_;
	_tmp6_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initlist = _tmp8_;
	_tmp9_ = vala_array_creation_expression_get_element_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp11_ = vala_array_creation_expression_get_element_type (self);
		_tmp12_ = _tmp11_;
		vala_code_node_check ((ValaCodeNode*) _tmp12_, context);
		_tmp13_ = vala_array_creation_expression_get_element_type (self);
		_tmp14_ = _tmp13_;
		if (!vala_data_type_check_type_arguments (_tmp14_, context, TRUE)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (initlist);
			_vala_iterable_unref0 (sizes);
			return result;
		}
	}
	_tmp15_ = vala_array_creation_expression_get_length_type (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		ValaSemanticAnalyzer* _tmp17_;
		ValaSemanticAnalyzer* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		_tmp17_ = vala_code_context_get_analyzer (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->int_type;
		_tmp20_ = vala_data_type_copy (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_array_creation_expression_set_length_type (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
	} else {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		_tmp22_ = vala_array_creation_expression_get_length_type (self);
		_tmp23_ = _tmp22_;
		vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
		_tmp25_ = vala_array_creation_expression_get_length_type (self);
		_tmp26_ = _tmp25_;
		if (!VALA_IS_INTEGER_TYPE (_tmp26_)) {
			_tmp24_ = TRUE;
		} else {
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp27_ = vala_array_creation_expression_get_length_type (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_data_type_get_nullable (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp24_ = _tmp30_;
		}
		if (_tmp24_) {
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaSourceReference* _tmp34_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp31_ = vala_array_creation_expression_get_length_type (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			vala_report_error (_tmp34_, "Expected integer type as length type of array");
		}
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		gint _e_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _e_index = 0;
		_tmp35_ = sizes;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_e_list = _tmp36_;
		_tmp37_ = _e_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_e_size = _tmp39_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			ValaExpression* e = NULL;
			ValaList* _tmp42_;
			gpointer _tmp43_;
			ValaExpression* _tmp44_;
			_e_index = _e_index + 1;
			_tmp40_ = _e_index;
			_tmp41_ = _e_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _e_list;
			_tmp43_ = vala_list_get (_tmp42_, _e_index);
			e = (ValaExpression*) _tmp43_;
			_tmp44_ = e;
			vala_code_node_check ((ValaCodeNode*) _tmp44_, context);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp45_ = g_direct_equal;
	_tmp46_ = vala_array_list_new (VALA_TYPE_LITERAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp45_);
	calc_sizes = _tmp46_;
	_tmp47_ = initlist;
	if (_tmp47_ != NULL) {
		ValaInitializerList* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		gint _tmp51_;
		ValaSourceReference* _tmp52_;
		ValaSourceReference* _tmp53_;
		ValaArrayType* _tmp54_;
		ValaArrayType* _tmp55_;
		ValaInitializerList* _tmp56_;
		ValaDataType* _tmp57_;
		ValaDataType* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaInitializerList* _tmp63_;
		gint ret = 0;
		ValaInitializerList* _tmp64_;
		gint _tmp65_;
		ValaArrayList* _tmp66_;
		ValaArrayList* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		_tmp48_ = initlist;
		_tmp49_ = vala_array_creation_expression_get_element_type (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->_rank;
		_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_array_type_new (_tmp50_, _tmp51_, _tmp53_);
		_tmp55_ = _tmp54_;
		vala_expression_set_target_type ((ValaExpression*) _tmp48_, (ValaDataType*) _tmp55_);
		_vala_code_node_unref0 (_tmp55_);
		_tmp56_ = initlist;
		_tmp57_ = vala_expression_get_target_type ((ValaExpression*) _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_array_creation_expression_get_length_type (self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_data_type_copy (_tmp60_);
		_tmp62_ = _tmp61_;
		vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp62_);
		_vala_code_node_unref0 (_tmp62_);
		_tmp63_ = initlist;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp63_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp64_ = initlist;
		_tmp65_ = self->priv->_rank;
		_tmp66_ = calc_sizes;
		ret = vala_array_creation_expression_create_sizes_from_initializer_list (self, context, _tmp64_, _tmp65_, (ValaList*) _tmp66_);
		if (ret == -1) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
		_tmp67_ = calc_sizes;
		_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = self->priv->_rank;
		if (_tmp69_ != _tmp70_) {
			ValaArrayType* actual_type = NULL;
			ValaDataType* _tmp71_;
			ValaDataType* _tmp72_;
			ValaArrayList* _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceReference* _tmp77_;
			ValaArrayType* _tmp78_;
			ValaArrayType* _tmp79_;
			ValaDataType* _tmp80_;
			ValaDataType* _tmp81_;
			ValaInitializerList* _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaDataType* _tmp85_;
			ValaDataType* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			ValaArrayType* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp71_ = vala_array_creation_expression_get_element_type (self);
			_tmp72_ = _tmp71_;
			_tmp73_ = calc_sizes;
			_tmp74_ = vala_collection_get_size ((ValaCollection*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_array_type_new (_tmp72_, _tmp75_, _tmp77_);
			actual_type = _tmp78_;
			_tmp79_ = actual_type;
			_tmp80_ = vala_array_creation_expression_get_length_type (self);
			_tmp81_ = _tmp80_;
			vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp81_);
			_tmp82_ = initlist;
			_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_code_node_to_string ((ValaCodeNode*) _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = actual_type;
			_tmp90_ = vala_code_node_to_string ((ValaCodeNode*) _tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = g_strdup_printf ("Expected initializer for `%s' but got `%s'", _tmp88_, _tmp91_);
			_tmp93_ = _tmp92_;
			vala_report_error (_tmp84_, _tmp93_);
			_g_free0 (_tmp93_);
			_g_free0 (_tmp91_);
			_g_free0 (_tmp88_);
			_vala_code_node_unref0 (actual_type);
		}
	}
	_tmp94_ = sizes;
	_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
	_tmp96_ = _tmp95_;
	if (_tmp96_ > 0) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp97_;
			ValaList* _tmp98_;
			gint _e_size = 0;
			ValaList* _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			gint _e_index = 0;
			_tmp97_ = sizes;
			_tmp98_ = _vala_iterable_ref0 (_tmp97_);
			_e_list = _tmp98_;
			_tmp99_ = _e_list;
			_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
			_tmp101_ = _tmp100_;
			_e_size = _tmp101_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp102_;
				gint _tmp103_;
				ValaExpression* e = NULL;
				ValaList* _tmp104_;
				gpointer _tmp105_;
				ValaExpression* _tmp106_;
				ValaDataType* _tmp107_;
				ValaDataType* _tmp108_;
				_e_index = _e_index + 1;
				_tmp102_ = _e_index;
				_tmp103_ = _e_size;
				if (!(_tmp102_ < _tmp103_)) {
					break;
				}
				_tmp104_ = _e_list;
				_tmp105_ = vala_list_get (_tmp104_, _e_index);
				e = (ValaExpression*) _tmp105_;
				_tmp106_ = e;
				_tmp107_ = vala_expression_get_value_type (_tmp106_);
				_tmp108_ = _tmp107_;
				if (_tmp108_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_iterable_unref0 (calc_sizes);
					_vala_code_node_unref0 (initlist);
					_vala_iterable_unref0 (sizes);
					return result;
				} else {
					gboolean _tmp109_ = FALSE;
					ValaExpression* _tmp110_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp110_ = e;
					_tmp111_ = vala_expression_get_value_type (_tmp110_);
					_tmp112_ = _tmp111_;
					if (VALA_IS_INTEGER_TYPE (_tmp112_)) {
						_tmp109_ = TRUE;
					} else {
						ValaExpression* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						_tmp113_ = e;
						_tmp114_ = vala_expression_get_value_type (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp109_ = VALA_IS_ENUM_VALUE_TYPE (_tmp115_);
					}
					if (!_tmp109_) {
						ValaExpression* _tmp116_;
						ValaSourceReference* _tmp117_;
						ValaSourceReference* _tmp118_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp116_ = e;
						_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp116_);
						_tmp118_ = _tmp117_;
						vala_report_error (_tmp118_, "Expression of integer type expected");
					}
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	} else {
		ValaInitializerList* _tmp119_;
		_tmp119_ = initlist;
		if (_tmp119_ == NULL) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp121_, "internal error: initializer list expected");
		} else {
			{
				ValaArrayList* _size_list = NULL;
				ValaArrayList* _tmp122_;
				ValaArrayList* _tmp123_;
				gint _size_size = 0;
				ValaArrayList* _tmp124_;
				gint _tmp125_;
				gint _tmp126_;
				gint _size_index = 0;
				_tmp122_ = calc_sizes;
				_tmp123_ = _vala_iterable_ref0 (_tmp122_);
				_size_list = _tmp123_;
				_tmp124_ = _size_list;
				_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
				_tmp126_ = _tmp125_;
				_size_size = _tmp126_;
				_size_index = -1;
				while (TRUE) {
					gint _tmp127_;
					gint _tmp128_;
					ValaExpression* size = NULL;
					ValaArrayList* _tmp129_;
					gpointer _tmp130_;
					ValaExpression* _tmp131_;
					_size_index = _size_index + 1;
					_tmp127_ = _size_index;
					_tmp128_ = _size_size;
					if (!(_tmp127_ < _tmp128_)) {
						break;
					}
					_tmp129_ = _size_list;
					_tmp130_ = vala_list_get ((ValaList*) _tmp129_, _size_index);
					size = (ValaExpression*) ((ValaLiteral*) _tmp130_);
					_tmp131_ = size;
					vala_array_creation_expression_append_size (self, _tmp131_);
					_vala_code_node_unref0 (size);
				}
				_vala_iterable_unref0 (_size_list);
			}
		}
	}
	_tmp132_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp133_ = _tmp132_;
	if (_tmp133_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp135_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp136_ = _tmp135_;
	if (_tmp136_ != NULL) {
		ValaInitializerList* _tmp137_;
		ValaInitializerList* _tmp138_;
		ValaDataType* _tmp139_;
		ValaDataType* _tmp140_;
		_tmp137_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_expression_get_value_type ((ValaExpression*) _tmp138_);
		_tmp140_ = _tmp139_;
		_tmp134_ = _tmp140_ == NULL;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp141_ = vala_array_creation_expression_get_element_type (self);
	_tmp142_ = _tmp141_;
	if (_tmp142_ == NULL) {
		ValaSourceReference* _tmp143_;
		ValaSourceReference* _tmp144_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp144_ = _tmp143_;
		vala_report_error (_tmp144_, "Cannot determine the element type of the created array");
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp145_ = vala_array_creation_expression_get_element_type (self);
	_tmp146_ = _tmp145_;
	_tmp147_ = self->priv->_rank;
	_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp149_ = _tmp148_;
	_tmp150_ = vala_array_type_new (_tmp146_, _tmp147_, _tmp149_);
	_tmp151_ = _tmp150_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp151_);
	_vala_code_node_unref0 (_tmp151_);
	_tmp152_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp153_ = _tmp152_;
	_tmp154_ = vala_array_creation_expression_get_length_type (self);
	_tmp155_ = _tmp154_;
	_tmp156_ = vala_data_type_copy (_tmp155_);
	_tmp157_ = _tmp156_;
	vala_array_type_set_length_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp157_);
	_vala_code_node_unref0 (_tmp157_);
	_tmp158_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp159_ = _tmp158_;
	if (VALA_IS_ARRAY_TYPE (_tmp159_)) {
		ValaDataType* _tmp160_;
		ValaDataType* _tmp161_;
		ValaDataType* _tmp162_;
		ValaDataType* _tmp163_;
		gboolean _tmp164_;
		gboolean _tmp165_;
		ValaDataType* _tmp166_;
		ValaDataType* _tmp167_;
		ValaDataType* _tmp168_;
		ValaDataType* _tmp169_;
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp160_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp165_ = _tmp164_;
		vala_array_type_set_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp165_);
		_tmp166_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp171_ = _tmp170_;
		vala_array_type_set_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp167_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), _tmp171_);
	}
	_tmp172_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp173_ = _tmp172_;
	vala_data_type_set_value_owned (_tmp173_, TRUE);
	_tmp174_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp175_ = _tmp174_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp175_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (calc_sizes);
		_vala_code_node_unref0 (initlist);
		_vala_iterable_unref0 (sizes);
		return result;
	}
	_tmp176_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp177_ = _tmp176_;
	result = !_tmp177_;
	_vala_iterable_unref0 (calc_sizes);
	_vala_code_node_unref0 (initlist);
	_vala_iterable_unref0 (sizes);
	return result;
}

static void
vala_array_creation_expression_real_emit (ValaCodeNode* base,
                                          ValaCodeGenerator* codegen)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp10_;
	ValaInitializerList* _tmp11_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaInitializerList* _tmp12_;
		ValaInitializerList* _tmp13_;
		_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp13_ = _tmp12_;
		vala_code_node_emit ((ValaCodeNode*) _tmp13_, codegen);
	}
	vala_code_visitor_visit_array_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_array_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaArrayCreationExpression * self;
	ValaInitializerList* _tmp10_;
	ValaInitializerList* _tmp11_;
	self = (ValaArrayCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _e_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = self->priv->sizes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp10_ = vala_array_creation_expression_get_initializer_list (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaInitializerList* _tmp12_;
		ValaInitializerList* _tmp13_;
		_tmp12_ = vala_array_creation_expression_get_initializer_list (self);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	}
}

static void
vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass,
                                           gpointer klass_data)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_creation_expression_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_array_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_array_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_array_creation_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_array_creation_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_array_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_array_creation_expression_real_get_used_variables;
}

static void
vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self,
                                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_array_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sizes = (ValaList*) _tmp1_;
}

static void
vala_array_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaArrayCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression);
	_vala_iterable_unref0 (self->priv->sizes);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_initializer_list);
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an array creation expression.
 *
 * {{{ new int[] { 1, 2, 3 } }}}
 */
static GType
vala_array_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
	GType vala_array_creation_expression_type_id;
	vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	ValaArrayCreationExpression_private_offset = g_type_add_instance_private (vala_array_creation_expression_type_id, sizeof (ValaArrayCreationExpressionPrivate));
	return vala_array_creation_expression_type_id;
}

GType
vala_array_creation_expression_get_type (void)
{
	static volatile gsize vala_array_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_creation_expression_type_id__volatile)) {
		GType vala_array_creation_expression_type_id;
		vala_array_creation_expression_type_id = vala_array_creation_expression_get_type_once ();
		g_once_init_leave (&vala_array_creation_expression_type_id__volatile, vala_array_creation_expression_type_id);
	}
	return vala_array_creation_expression_type_id__volatile;
}

