/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);
static GType vala_binary_expression_get_type_once (void);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_operator;
	return result;
}

void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp367_ = FALSE;
	gboolean _tmp368_ = FALSE;
	ValaDataType* _tmp369_;
	ValaDataType* _tmp370_;
	ValaExpression* _tmp407_;
	ValaExpression* _tmp408_;
	gboolean _tmp409_ = FALSE;
	gboolean _tmp410_ = FALSE;
	ValaExpression* _tmp411_;
	ValaExpression* _tmp412_;
	ValaDataType* _tmp413_;
	ValaDataType* _tmp414_;
	ValaExpression* _tmp432_;
	ValaExpression* _tmp433_;
	gboolean _tmp434_ = FALSE;
	gboolean _tmp435_ = FALSE;
	ValaExpression* _tmp436_;
	ValaExpression* _tmp437_;
	ValaDataType* _tmp438_;
	ValaDataType* _tmp439_;
	gboolean _tmp457_ = FALSE;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaExpression* _tmp462_;
	ValaExpression* _tmp463_;
	ValaDataType* _tmp464_;
	ValaDataType* _tmp465_;
	gboolean _tmp470_ = FALSE;
	ValaBinaryOperator _tmp471_;
	gboolean _tmp480_ = FALSE;
	ValaExpression* _tmp481_;
	ValaExpression* _tmp482_;
	ValaDataType* _tmp483_;
	ValaDataType* _tmp484_;
	gboolean _tmp501_ = FALSE;
	ValaExpression* _tmp502_;
	ValaExpression* _tmp503_;
	ValaDataType* _tmp504_;
	ValaDataType* _tmp505_;
	ValaExpression* _tmp522_;
	ValaExpression* _tmp523_;
	ValaExpression* _tmp524_;
	ValaExpression* _tmp525_;
	ValaDataType* _tmp526_;
	ValaDataType* _tmp527_;
	ValaDataType* _tmp528_;
	ValaDataType* _tmp529_;
	ValaExpression* _tmp530_;
	ValaExpression* _tmp531_;
	ValaDataType* _tmp532_;
	ValaDataType* _tmp533_;
	ValaExpression* _tmp534_;
	ValaExpression* _tmp535_;
	ValaExpression* _tmp536_;
	ValaExpression* _tmp537_;
	ValaDataType* _tmp538_;
	ValaDataType* _tmp539_;
	ValaDataType* _tmp540_;
	ValaDataType* _tmp541_;
	ValaExpression* _tmp542_;
	ValaExpression* _tmp543_;
	ValaDataType* _tmp544_;
	ValaDataType* _tmp545_;
	gboolean _tmp546_ = FALSE;
	gboolean _tmp547_ = FALSE;
	ValaBinaryOperator _tmp548_;
	ValaBinaryOperator _tmp643_;
	ValaDataType* _tmp1186_;
	ValaDataType* _tmp1187_;
	gboolean _tmp1188_;
	gboolean _tmp1189_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaExpression* _tmp141_;
		ValaExpression* _tmp142_;
		gchar* temp_name = NULL;
		gchar* _tmp143_;
		ValaLocalVariable* right_local = NULL;
		const gchar* _tmp144_;
		ValaExpression* _tmp145_;
		ValaExpression* _tmp146_;
		ValaExpression* _tmp147_;
		ValaExpression* _tmp148_;
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaLocalVariable* _tmp151_;
		ValaDeclarationStatement* right_decl = NULL;
		ValaLocalVariable* _tmp152_;
		ValaExpression* _tmp153_;
		ValaExpression* _tmp154_;
		ValaSourceReference* _tmp155_;
		ValaSourceReference* _tmp156_;
		ValaDeclarationStatement* _tmp157_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		ValaDeclarationStatement* _tmp162_;
		ValaBlock* _tmp163_;
		ValaLocalVariable* _tmp164_;
		ValaExpression* _tmp165_;
		ValaExpression* _tmp166_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp167_ = FALSE;
		ValaExpression* _tmp168_;
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		gboolean _tmp254_ = FALSE;
		gboolean _tmp255_ = FALSE;
		ValaDataType* _tmp256_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp268_;
		const gchar* _tmp269_;
		ValaExpression* _tmp270_;
		ValaExpression* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaLocalVariable* _tmp274_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp275_;
		ValaSourceReference* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaDeclarationStatement* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaSemanticAnalyzer* _tmp280_;
		ValaBlock* _tmp281_;
		ValaDeclarationStatement* _tmp282_;
		ValaDeclarationStatement* _tmp283_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp284_;
		const gchar* _tmp285_;
		const gchar* _tmp286_;
		ValaExpression* _tmp287_;
		ValaExpression* _tmp288_;
		ValaSourceReference* _tmp289_;
		ValaSourceReference* _tmp290_;
		ValaMemberAccess* _tmp291_;
		ValaMemberAccess* _tmp292_;
		ValaExpression* _tmp293_;
		ValaExpression* _tmp294_;
		ValaExpression* _tmp295_;
		ValaExpression* _tmp296_;
		ValaSourceReference* _tmp297_;
		ValaSourceReference* _tmp298_;
		ValaAssignment* _tmp299_;
		ValaAssignment* _tmp300_;
		ValaExpression* _tmp301_;
		ValaExpression* _tmp302_;
		ValaSourceReference* _tmp303_;
		ValaSourceReference* _tmp304_;
		ValaExpressionStatement* _tmp305_;
		ValaExpressionStatement* _tmp306_;
		ValaBlock* _tmp307_;
		ValaLocalVariable* _tmp308_;
		ValaBlock* _tmp309_;
		ValaDeclarationStatement* _tmp310_;
		ValaExpressionStatement* _tmp311_;
		ValaExpressionStatement* _tmp312_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp313_;
		const gchar* _tmp314_;
		const gchar* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		ValaMemberAccess* _tmp320_;
		ValaMemberAccess* _tmp321_;
		ValaSourceReference* _tmp322_;
		ValaSourceReference* _tmp323_;
		ValaNullLiteral* _tmp324_;
		ValaNullLiteral* _tmp325_;
		ValaSourceReference* _tmp326_;
		ValaSourceReference* _tmp327_;
		ValaBinaryExpression* _tmp328_;
		ValaBinaryExpression* _tmp329_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp330_;
		ValaBlock* _tmp331_;
		ValaSourceReference* _tmp332_;
		ValaSourceReference* _tmp333_;
		ValaIfStatement* _tmp334_;
		ValaSemanticAnalyzer* _tmp335_;
		ValaSemanticAnalyzer* _tmp336_;
		ValaBlock* _tmp337_;
		ValaIfStatement* _tmp338_;
		ValaIfStatement* _tmp339_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp340_;
		ValaDataType* _tmp341_;
		ValaDataType* _tmp342_;
		ValaExpression* _tmp343_;
		gboolean _tmp344_ = FALSE;
		ValaCodeNode* _tmp363_;
		ValaCodeNode* _tmp364_;
		ValaExpression* _tmp365_;
		ValaExpression* _tmp366_;
		_tmp127_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp128_ = _tmp127_;
		if (_tmp128_ != NULL) {
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			ValaDataType* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			_tmp129_ = vala_binary_expression_get_left (self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_data_type_copy (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_expression_set_target_type (_tmp130_, _tmp134_);
			_vala_code_node_unref0 (_tmp134_);
			_tmp135_ = vala_binary_expression_get_right (self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_data_type_copy (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_target_type (_tmp136_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
		}
		_tmp141_ = vala_binary_expression_get_left (self);
		_tmp142_ = _tmp141_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp142_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp143_ = vala_code_node_get_temp_name ();
		temp_name = _tmp143_;
		_tmp144_ = temp_name;
		_tmp145_ = vala_binary_expression_get_right (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_binary_expression_get_right (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_local_variable_new (NULL, _tmp144_, _tmp146_, _tmp150_);
		right_local = _tmp151_;
		_tmp152_ = right_local;
		_tmp153_ = vala_binary_expression_get_right (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_declaration_statement_new ((ValaSymbol*) _tmp152_, _tmp156_);
		right_decl = _tmp157_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_block_new (_tmp159_);
		true_block = _tmp160_;
		_tmp161_ = true_block;
		_tmp162_ = right_decl;
		vala_block_add_statement (_tmp161_, (ValaStatement*) _tmp162_);
		_tmp163_ = true_block;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp163_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp164_ = right_local;
		_tmp165_ = vala_variable_get_initializer ((ValaVariable*) _tmp164_);
		_tmp166_ = _tmp165_;
		vala_binary_expression_set_right (self, _tmp166_);
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp168_ = vala_binary_expression_get_left (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_expression_get_value_type (_tmp169_);
		_tmp171_ = _tmp170_;
		if (VALA_IS_NULL_TYPE (_tmp171_)) {
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp172_ = vala_binary_expression_get_right (self);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_expression_get_value_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp167_ = _tmp175_ != NULL;
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaDataType* _tmp182_;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			ValaExpression* _tmp186_;
			ValaExpression* _tmp187_;
			ValaDataType* _tmp188_;
			ValaDataType* _tmp189_;
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp176_ = vala_binary_expression_get_left (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
			_tmp179_ = _tmp178_;
			vala_report_warning (_tmp179_, "left operand is always null");
			_tmp180_ = vala_binary_expression_get_right (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_value_type (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_data_type_copy (_tmp183_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp184_;
			_tmp185_ = local_type;
			vala_data_type_set_nullable (_tmp185_, TRUE);
			_tmp186_ = vala_binary_expression_get_right (self);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_expression_get_value_type (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_data_type_get_nullable (_tmp189_);
			_tmp191_ = _tmp190_;
			if (!_tmp191_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			ValaDataType* _tmp194_;
			ValaDataType* _tmp195_;
			_tmp192_ = vala_binary_expression_get_left (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_expression_get_value_type (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				gboolean _tmp201_ = FALSE;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp196_ = vala_binary_expression_get_left (self);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_expression_get_value_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_data_type_copy (_tmp199_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp200_;
				_tmp202_ = vala_binary_expression_get_right (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp205_ != NULL) {
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					gboolean _tmp210_;
					gboolean _tmp211_;
					_tmp206_ = vala_binary_expression_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_value_type (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_value_owned (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp201_ = _tmp211_;
				} else {
					_tmp201_ = FALSE;
				}
				if (_tmp201_) {
					ValaDataType* _tmp212_;
					_tmp212_ = local_type;
					vala_data_type_set_value_owned (_tmp212_, TRUE);
				}
				_tmp213_ = vala_code_context_get_experimental_non_null (context);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					ValaDataType* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp215_ = local_type;
					_tmp216_ = vala_data_type_get_nullable (_tmp215_);
					_tmp217_ = _tmp216_;
					if (!_tmp217_) {
						ValaExpression* _tmp218_;
						ValaExpression* _tmp219_;
						ValaSourceReference* _tmp220_;
						ValaSourceReference* _tmp221_;
						gboolean _tmp222_ = FALSE;
						ValaExpression* _tmp223_;
						ValaExpression* _tmp224_;
						ValaDataType* _tmp225_;
						ValaDataType* _tmp226_;
						_tmp218_ = vala_binary_expression_get_left (self);
						_tmp219_ = _tmp218_;
						_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp219_);
						_tmp221_ = _tmp220_;
						vala_report_warning (_tmp221_, "left operand is never null");
						_tmp223_ = vala_binary_expression_get_right (self);
						_tmp224_ = _tmp223_;
						_tmp225_ = vala_expression_get_value_type (_tmp224_);
						_tmp226_ = _tmp225_;
						if (_tmp226_ != NULL) {
							ValaExpression* _tmp227_;
							ValaExpression* _tmp228_;
							ValaDataType* _tmp229_;
							ValaDataType* _tmp230_;
							gboolean _tmp231_;
							gboolean _tmp232_;
							_tmp227_ = vala_binary_expression_get_right (self);
							_tmp228_ = _tmp227_;
							_tmp229_ = vala_expression_get_value_type (_tmp228_);
							_tmp230_ = _tmp229_;
							_tmp231_ = vala_data_type_get_nullable (_tmp230_);
							_tmp232_ = _tmp231_;
							_tmp222_ = _tmp232_;
						} else {
							_tmp222_ = FALSE;
						}
						if (_tmp222_) {
							ValaDataType* _tmp233_;
							_tmp233_ = local_type;
							vala_data_type_set_nullable (_tmp233_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp234_ = FALSE;
						ValaExpression* _tmp235_;
						ValaExpression* _tmp236_;
						ValaDataType* _tmp237_;
						ValaDataType* _tmp238_;
						_tmp235_ = vala_binary_expression_get_right (self);
						_tmp236_ = _tmp235_;
						_tmp237_ = vala_expression_get_value_type (_tmp236_);
						_tmp238_ = _tmp237_;
						if (_tmp238_ != NULL) {
							ValaExpression* _tmp239_;
							ValaExpression* _tmp240_;
							ValaDataType* _tmp241_;
							ValaDataType* _tmp242_;
							gboolean _tmp243_;
							gboolean _tmp244_;
							_tmp239_ = vala_binary_expression_get_right (self);
							_tmp240_ = _tmp239_;
							_tmp241_ = vala_expression_get_value_type (_tmp240_);
							_tmp242_ = _tmp241_;
							_tmp243_ = vala_data_type_get_nullable (_tmp242_);
							_tmp244_ = _tmp243_;
							_tmp234_ = !_tmp244_;
						} else {
							_tmp234_ = FALSE;
						}
						if (_tmp234_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaDataType* _tmp247_;
				ValaDataType* _tmp248_;
				_tmp245_ = vala_binary_expression_get_right (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_value_type (_tmp246_);
				_tmp248_ = _tmp247_;
				if (_tmp248_ != NULL) {
					ValaExpression* _tmp249_;
					ValaExpression* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					_tmp249_ = vala_binary_expression_get_right (self);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_expression_get_value_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_data_type_copy (_tmp252_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp253_;
				}
			}
		}
		_tmp256_ = local_type;
		if (_tmp256_ != NULL) {
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			ValaDataType* _tmp259_;
			ValaDataType* _tmp260_;
			_tmp257_ = vala_binary_expression_get_right (self);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_expression_get_value_type (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp255_ = VALA_IS_VALUE_TYPE (_tmp260_);
		} else {
			_tmp255_ = FALSE;
		}
		if (_tmp255_) {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaDataType* _tmp263_;
			ValaDataType* _tmp264_;
			gboolean _tmp265_;
			gboolean _tmp266_;
			_tmp261_ = vala_binary_expression_get_right (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_value_type (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_data_type_get_nullable (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp254_ = !_tmp266_;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			ValaDataType* _tmp267_;
			_tmp267_ = local_type;
			vala_data_type_set_value_owned (_tmp267_, TRUE);
		}
		_tmp268_ = local_type;
		_tmp269_ = temp_name;
		_tmp270_ = vala_binary_expression_get_left (self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_local_variable_new (_tmp268_, _tmp269_, _tmp271_, _tmp273_);
		local = _tmp274_;
		_tmp275_ = local;
		_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_declaration_statement_new ((ValaSymbol*) _tmp275_, _tmp277_);
		decl = _tmp278_;
		_tmp279_ = vala_code_context_get_analyzer (context);
		_tmp280_ = _tmp279_;
		_tmp281_ = _tmp280_->insert_block;
		_tmp282_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp281_, (ValaStatement*) _tmp282_);
		_tmp283_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp283_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp284_ = local;
		_tmp285_ = vala_symbol_get_name ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_binary_expression_get_right (self);
		_tmp288_ = _tmp287_;
		_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_member_access_new_simple (_tmp286_, _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp293_ = vala_binary_expression_get_right (self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_binary_expression_get_right (self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
		_tmp298_ = _tmp297_;
		_tmp299_ = vala_assignment_new ((ValaExpression*) _tmp292_, _tmp294_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp298_);
		_tmp300_ = _tmp299_;
		_tmp301_ = vala_binary_expression_get_right (self);
		_tmp302_ = _tmp301_;
		_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
		_tmp304_ = _tmp303_;
		_tmp305_ = vala_expression_statement_new ((ValaExpression*) _tmp300_, _tmp304_);
		_tmp306_ = _tmp305_;
		_vala_code_node_unref0 (_tmp300_);
		_vala_code_node_unref0 (_tmp292_);
		right_stmt = _tmp306_;
		_tmp307_ = true_block;
		_tmp308_ = right_local;
		vala_block_remove_local_variable (_tmp307_, _tmp308_);
		_tmp309_ = true_block;
		_tmp310_ = right_decl;
		_tmp311_ = right_stmt;
		vala_block_replace_statement (_tmp309_, (ValaStatement*) _tmp310_, (ValaStatement*) _tmp311_);
		_tmp312_ = right_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp312_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp313_ = local;
		_tmp314_ = vala_symbol_get_name ((ValaSymbol*) _tmp313_);
		_tmp315_ = _tmp314_;
		_tmp316_ = vala_binary_expression_get_left (self);
		_tmp317_ = _tmp316_;
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp320_ = vala_member_access_new_simple (_tmp315_, _tmp319_);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_null_literal_new (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp327_ = _tmp326_;
		_tmp328_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp321_, (ValaExpression*) _tmp325_, _tmp327_);
		_tmp329_ = _tmp328_;
		_vala_code_node_unref0 (_tmp325_);
		_vala_code_node_unref0 (_tmp321_);
		cond = _tmp329_;
		_tmp330_ = cond;
		_tmp331_ = true_block;
		_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_if_statement_new ((ValaExpression*) _tmp330_, _tmp331_, NULL, _tmp333_);
		if_stmt = _tmp334_;
		_tmp335_ = vala_code_context_get_analyzer (context);
		_tmp336_ = _tmp335_;
		_tmp337_ = _tmp336_->insert_block;
		_tmp338_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp337_, (ValaStatement*) _tmp338_);
		_tmp339_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp339_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp340_ = local;
		_tmp341_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp342_ = _tmp341_;
		_tmp343_ = vala_semantic_analyzer_create_temp_access (_tmp340_, _tmp342_);
		replace_expr = _tmp343_;
		if (cast_non_null) {
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			_tmp345_ = replace_expr;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			_tmp344_ = _tmp347_ != NULL;
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp348_;
			ValaSourceReference* _tmp349_;
			ValaSourceReference* _tmp350_;
			ValaCastExpression* _tmp351_;
			ValaCastExpression* _tmp352_;
			ValaExpression* _tmp353_;
			ValaDataType* _tmp354_;
			ValaDataType* _tmp355_;
			ValaDataType* _tmp356_;
			ValaDataType* _tmp357_;
			ValaCastExpression* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaCastExpression* _tmp361_;
			ValaExpression* _tmp362_;
			_tmp348_ = replace_expr;
			_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_cast_expression_new_non_null (_tmp348_, _tmp350_);
			cast = _tmp351_;
			_tmp352_ = cast;
			_tmp353_ = replace_expr;
			_tmp354_ = vala_expression_get_target_type (_tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_data_type_copy (_tmp355_);
			_tmp357_ = _tmp356_;
			vala_expression_set_target_type ((ValaExpression*) _tmp352_, _tmp357_);
			_vala_code_node_unref0 (_tmp357_);
			_tmp358_ = cast;
			_tmp359_ = vala_expression_get_target_type ((ValaExpression*) _tmp358_);
			_tmp360_ = _tmp359_;
			vala_data_type_set_nullable (_tmp360_, FALSE);
			_tmp361_ = cast;
			_tmp362_ = _vala_code_node_ref0 ((ValaExpression*) _tmp361_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp362_;
			_vala_code_node_unref0 (cast);
		}
		_tmp363_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp364_ = _tmp363_;
		_tmp365_ = replace_expr;
		vala_code_node_replace_expression (_tmp364_, (ValaExpression*) self, _tmp365_);
		_tmp366_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp366_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_decl);
		_vala_code_node_unref0 (right_local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp369_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp370_ = _tmp369_;
	if (_tmp370_ != NULL) {
		ValaDataType* _tmp371_;
		ValaDataType* _tmp372_;
		ValaTypeSymbol* _tmp373_;
		ValaTypeSymbol* _tmp374_;
		_tmp371_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_data_type_get_type_symbol (_tmp372_);
		_tmp374_ = _tmp373_;
		_tmp368_ = VALA_IS_ENUM (_tmp374_);
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		gboolean _tmp375_ = FALSE;
		ValaBinaryOperator _tmp376_;
		_tmp376_ = self->priv->_operator;
		if (_tmp376_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp375_ = TRUE;
		} else {
			ValaBinaryOperator _tmp377_;
			_tmp377_ = self->priv->_operator;
			_tmp375_ = _tmp377_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp367_ = _tmp375_;
	} else {
		_tmp367_ = FALSE;
	}
	if (_tmp367_) {
		ValaExpression* _tmp378_;
		ValaExpression* _tmp379_;
		ValaDataType* _tmp380_;
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		ValaDataType* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaDataType* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		_tmp378_ = vala_binary_expression_get_left (self);
		_tmp379_ = _tmp378_;
		_tmp380_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp381_ = _tmp380_;
		_tmp382_ = vala_data_type_copy (_tmp381_);
		_tmp383_ = _tmp382_;
		vala_expression_set_target_type (_tmp379_, _tmp383_);
		_vala_code_node_unref0 (_tmp383_);
		_tmp384_ = vala_binary_expression_get_right (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_data_type_copy (_tmp387_);
		_tmp389_ = _tmp388_;
		vala_expression_set_target_type (_tmp385_, _tmp389_);
		_vala_code_node_unref0 (_tmp389_);
	} else {
		ValaBinaryOperator _tmp390_;
		_tmp390_ = self->priv->_operator;
		if (_tmp390_ == VALA_BINARY_OPERATOR_IN) {
			ValaExpression* _tmp391_;
			ValaExpression* _tmp392_;
			ValaExpression* _tmp393_;
			ValaExpression* _tmp394_;
			ValaDataType* _tmp395_;
			ValaDataType* _tmp396_;
			ValaTypeSymbol* _tmp397_;
			ValaTypeSymbol* _tmp398_;
			_tmp391_ = vala_binary_expression_get_right (self);
			_tmp392_ = _tmp391_;
			vala_code_node_check ((ValaCodeNode*) _tmp392_, context);
			_tmp393_ = vala_binary_expression_get_right (self);
			_tmp394_ = _tmp393_;
			_tmp395_ = vala_expression_get_value_type (_tmp394_);
			_tmp396_ = _tmp395_;
			_tmp397_ = vala_data_type_get_type_symbol (_tmp396_);
			_tmp398_ = _tmp397_;
			if (VALA_IS_ENUM (_tmp398_)) {
				ValaExpression* _tmp399_;
				ValaExpression* _tmp400_;
				ValaExpression* _tmp401_;
				ValaExpression* _tmp402_;
				ValaDataType* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				_tmp399_ = vala_binary_expression_get_left (self);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_binary_expression_get_right (self);
				_tmp402_ = _tmp401_;
				_tmp403_ = vala_expression_get_value_type (_tmp402_);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_data_type_copy (_tmp404_);
				_tmp406_ = _tmp405_;
				vala_expression_set_target_type (_tmp400_, _tmp406_);
				_vala_code_node_unref0 (_tmp406_);
			}
		}
	}
	_tmp407_ = vala_binary_expression_get_left (self);
	_tmp408_ = _tmp407_;
	vala_code_node_check ((ValaCodeNode*) _tmp408_, context);
	_tmp411_ = vala_binary_expression_get_left (self);
	_tmp412_ = _tmp411_;
	_tmp413_ = vala_expression_get_value_type (_tmp412_);
	_tmp414_ = _tmp413_;
	if (_tmp414_ != NULL) {
		ValaExpression* _tmp415_;
		ValaExpression* _tmp416_;
		ValaDataType* _tmp417_;
		ValaDataType* _tmp418_;
		ValaTypeSymbol* _tmp419_;
		ValaTypeSymbol* _tmp420_;
		_tmp415_ = vala_binary_expression_get_left (self);
		_tmp416_ = _tmp415_;
		_tmp417_ = vala_expression_get_value_type (_tmp416_);
		_tmp418_ = _tmp417_;
		_tmp419_ = vala_data_type_get_type_symbol (_tmp418_);
		_tmp420_ = _tmp419_;
		_tmp410_ = VALA_IS_ENUM (_tmp420_);
	} else {
		_tmp410_ = FALSE;
	}
	if (_tmp410_) {
		gboolean _tmp421_ = FALSE;
		ValaBinaryOperator _tmp422_;
		_tmp422_ = self->priv->_operator;
		if (_tmp422_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp421_ = TRUE;
		} else {
			ValaBinaryOperator _tmp423_;
			_tmp423_ = self->priv->_operator;
			_tmp421_ = _tmp423_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp409_ = _tmp421_;
	} else {
		_tmp409_ = FALSE;
	}
	if (_tmp409_) {
		ValaExpression* _tmp424_;
		ValaExpression* _tmp425_;
		ValaExpression* _tmp426_;
		ValaExpression* _tmp427_;
		ValaDataType* _tmp428_;
		ValaDataType* _tmp429_;
		ValaDataType* _tmp430_;
		ValaDataType* _tmp431_;
		_tmp424_ = vala_binary_expression_get_right (self);
		_tmp425_ = _tmp424_;
		_tmp426_ = vala_binary_expression_get_left (self);
		_tmp427_ = _tmp426_;
		_tmp428_ = vala_expression_get_value_type (_tmp427_);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_data_type_copy (_tmp429_);
		_tmp431_ = _tmp430_;
		vala_expression_set_target_type (_tmp425_, _tmp431_);
		_vala_code_node_unref0 (_tmp431_);
	}
	_tmp432_ = vala_binary_expression_get_right (self);
	_tmp433_ = _tmp432_;
	vala_code_node_check ((ValaCodeNode*) _tmp433_, context);
	_tmp436_ = vala_binary_expression_get_right (self);
	_tmp437_ = _tmp436_;
	_tmp438_ = vala_expression_get_value_type (_tmp437_);
	_tmp439_ = _tmp438_;
	if (_tmp439_ != NULL) {
		ValaExpression* _tmp440_;
		ValaExpression* _tmp441_;
		ValaDataType* _tmp442_;
		ValaDataType* _tmp443_;
		ValaTypeSymbol* _tmp444_;
		ValaTypeSymbol* _tmp445_;
		_tmp440_ = vala_binary_expression_get_right (self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_expression_get_value_type (_tmp441_);
		_tmp443_ = _tmp442_;
		_tmp444_ = vala_data_type_get_type_symbol (_tmp443_);
		_tmp445_ = _tmp444_;
		_tmp435_ = VALA_IS_ENUM (_tmp445_);
	} else {
		_tmp435_ = FALSE;
	}
	if (_tmp435_) {
		gboolean _tmp446_ = FALSE;
		ValaBinaryOperator _tmp447_;
		_tmp447_ = self->priv->_operator;
		if (_tmp447_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp446_ = TRUE;
		} else {
			ValaBinaryOperator _tmp448_;
			_tmp448_ = self->priv->_operator;
			_tmp446_ = _tmp448_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp434_ = _tmp446_;
	} else {
		_tmp434_ = FALSE;
	}
	if (_tmp434_) {
		ValaExpression* _tmp449_;
		ValaExpression* _tmp450_;
		ValaExpression* _tmp451_;
		ValaExpression* _tmp452_;
		ValaDataType* _tmp453_;
		ValaDataType* _tmp454_;
		ValaDataType* _tmp455_;
		ValaDataType* _tmp456_;
		_tmp449_ = vala_binary_expression_get_left (self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_binary_expression_get_right (self);
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_expression_get_value_type (_tmp452_);
		_tmp454_ = _tmp453_;
		_tmp455_ = vala_data_type_copy (_tmp454_);
		_tmp456_ = _tmp455_;
		vala_expression_set_target_type (_tmp450_, _tmp456_);
		_vala_code_node_unref0 (_tmp456_);
	}
	_tmp458_ = vala_binary_expression_get_left (self);
	_tmp459_ = _tmp458_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp459_, context)) {
		_tmp457_ = TRUE;
	} else {
		ValaExpression* _tmp460_;
		ValaExpression* _tmp461_;
		_tmp460_ = vala_binary_expression_get_right (self);
		_tmp461_ = _tmp460_;
		_tmp457_ = !vala_code_node_check ((ValaCodeNode*) _tmp461_, context);
	}
	if (_tmp457_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp462_ = vala_binary_expression_get_left (self);
	_tmp463_ = _tmp462_;
	_tmp464_ = vala_expression_get_value_type (_tmp463_);
	_tmp465_ = _tmp464_;
	if (_tmp465_ == NULL) {
		ValaExpression* _tmp466_;
		ValaExpression* _tmp467_;
		ValaSourceReference* _tmp468_;
		ValaSourceReference* _tmp469_;
		_tmp466_ = vala_binary_expression_get_left (self);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
		_tmp469_ = _tmp468_;
		vala_report_error (_tmp469_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp471_ = self->priv->_operator;
	if (_tmp471_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp472_;
		ValaExpression* _tmp473_;
		ValaDataType* _tmp474_;
		ValaDataType* _tmp475_;
		_tmp472_ = vala_binary_expression_get_right (self);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_expression_get_value_type (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp470_ = _tmp475_ == NULL;
	} else {
		_tmp470_ = FALSE;
	}
	if (_tmp470_) {
		ValaExpression* _tmp476_;
		ValaExpression* _tmp477_;
		ValaSourceReference* _tmp478_;
		ValaSourceReference* _tmp479_;
		_tmp476_ = vala_binary_expression_get_right (self);
		_tmp477_ = _tmp476_;
		_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp477_);
		_tmp479_ = _tmp478_;
		vala_report_error (_tmp479_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp481_ = vala_binary_expression_get_left (self);
	_tmp482_ = _tmp481_;
	_tmp483_ = vala_expression_get_value_type (_tmp482_);
	_tmp484_ = _tmp483_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp484_)) {
		_tmp480_ = TRUE;
	} else {
		ValaExpression* _tmp485_;
		ValaExpression* _tmp486_;
		ValaDataType* _tmp487_;
		ValaDataType* _tmp488_;
		_tmp485_ = vala_binary_expression_get_left (self);
		_tmp486_ = _tmp485_;
		_tmp487_ = vala_expression_get_value_type (_tmp486_);
		_tmp488_ = _tmp487_;
		_tmp480_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp488_);
	}
	if (_tmp480_) {
		ValaExpression* _tmp489_;
		ValaExpression* _tmp490_;
		ValaSourceReference* _tmp491_;
		ValaSourceReference* _tmp492_;
		ValaExpression* _tmp493_;
		ValaExpression* _tmp494_;
		ValaSymbol* _tmp495_;
		ValaSymbol* _tmp496_;
		gchar* _tmp497_;
		gchar* _tmp498_;
		gchar* _tmp499_;
		gchar* _tmp500_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp489_ = vala_binary_expression_get_left (self);
		_tmp490_ = _tmp489_;
		_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_binary_expression_get_left (self);
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_expression_get_symbol_reference (_tmp494_);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_symbol_get_full_name (_tmp496_);
		_tmp498_ = _tmp497_;
		_tmp499_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp498_);
		_tmp500_ = _tmp499_;
		vala_report_error (_tmp492_, _tmp500_);
		_g_free0 (_tmp500_);
		_g_free0 (_tmp498_);
		result = FALSE;
		return result;
	}
	_tmp502_ = vala_binary_expression_get_right (self);
	_tmp503_ = _tmp502_;
	_tmp504_ = vala_expression_get_value_type (_tmp503_);
	_tmp505_ = _tmp504_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp505_)) {
		_tmp501_ = TRUE;
	} else {
		ValaExpression* _tmp506_;
		ValaExpression* _tmp507_;
		ValaDataType* _tmp508_;
		ValaDataType* _tmp509_;
		_tmp506_ = vala_binary_expression_get_right (self);
		_tmp507_ = _tmp506_;
		_tmp508_ = vala_expression_get_value_type (_tmp507_);
		_tmp509_ = _tmp508_;
		_tmp501_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp509_);
	}
	if (_tmp501_) {
		ValaExpression* _tmp510_;
		ValaExpression* _tmp511_;
		ValaSourceReference* _tmp512_;
		ValaSourceReference* _tmp513_;
		ValaExpression* _tmp514_;
		ValaExpression* _tmp515_;
		ValaSymbol* _tmp516_;
		ValaSymbol* _tmp517_;
		gchar* _tmp518_;
		gchar* _tmp519_;
		gchar* _tmp520_;
		gchar* _tmp521_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp510_ = vala_binary_expression_get_right (self);
		_tmp511_ = _tmp510_;
		_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp511_);
		_tmp513_ = _tmp512_;
		_tmp514_ = vala_binary_expression_get_right (self);
		_tmp515_ = _tmp514_;
		_tmp516_ = vala_expression_get_symbol_reference (_tmp515_);
		_tmp517_ = _tmp516_;
		_tmp518_ = vala_symbol_get_full_name (_tmp517_);
		_tmp519_ = _tmp518_;
		_tmp520_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp519_);
		_tmp521_ = _tmp520_;
		vala_report_error (_tmp513_, _tmp521_);
		_g_free0 (_tmp521_);
		_g_free0 (_tmp519_);
		result = FALSE;
		return result;
	}
	_tmp522_ = vala_binary_expression_get_left (self);
	_tmp523_ = _tmp522_;
	_tmp524_ = vala_binary_expression_get_left (self);
	_tmp525_ = _tmp524_;
	_tmp526_ = vala_expression_get_value_type (_tmp525_);
	_tmp527_ = _tmp526_;
	_tmp528_ = vala_data_type_copy (_tmp527_);
	_tmp529_ = _tmp528_;
	vala_expression_set_target_type (_tmp523_, _tmp529_);
	_vala_code_node_unref0 (_tmp529_);
	_tmp530_ = vala_binary_expression_get_left (self);
	_tmp531_ = _tmp530_;
	_tmp532_ = vala_expression_get_target_type (_tmp531_);
	_tmp533_ = _tmp532_;
	vala_data_type_set_value_owned (_tmp533_, FALSE);
	_tmp534_ = vala_binary_expression_get_right (self);
	_tmp535_ = _tmp534_;
	_tmp536_ = vala_binary_expression_get_right (self);
	_tmp537_ = _tmp536_;
	_tmp538_ = vala_expression_get_value_type (_tmp537_);
	_tmp539_ = _tmp538_;
	_tmp540_ = vala_data_type_copy (_tmp539_);
	_tmp541_ = _tmp540_;
	vala_expression_set_target_type (_tmp535_, _tmp541_);
	_vala_code_node_unref0 (_tmp541_);
	_tmp542_ = vala_binary_expression_get_right (self);
	_tmp543_ = _tmp542_;
	_tmp544_ = vala_expression_get_target_type (_tmp543_);
	_tmp545_ = _tmp544_;
	vala_data_type_set_value_owned (_tmp545_, FALSE);
	_tmp548_ = self->priv->_operator;
	if (_tmp548_ == VALA_BINARY_OPERATOR_PLUS) {
		ValaExpression* _tmp549_;
		ValaExpression* _tmp550_;
		ValaDataType* _tmp551_;
		ValaDataType* _tmp552_;
		_tmp549_ = vala_binary_expression_get_left (self);
		_tmp550_ = _tmp549_;
		_tmp551_ = vala_expression_get_value_type (_tmp550_);
		_tmp552_ = _tmp551_;
		_tmp547_ = !VALA_IS_POINTER_TYPE (_tmp552_);
	} else {
		_tmp547_ = FALSE;
	}
	if (_tmp547_) {
		ValaExpression* _tmp553_;
		ValaExpression* _tmp554_;
		ValaDataType* _tmp555_;
		ValaDataType* _tmp556_;
		ValaSemanticAnalyzer* _tmp557_;
		ValaSemanticAnalyzer* _tmp558_;
		ValaDataType* _tmp559_;
		_tmp553_ = vala_binary_expression_get_left (self);
		_tmp554_ = _tmp553_;
		_tmp555_ = vala_expression_get_value_type (_tmp554_);
		_tmp556_ = _tmp555_;
		_tmp557_ = vala_code_context_get_analyzer (context);
		_tmp558_ = _tmp557_;
		_tmp559_ = _tmp558_->string_type;
		_tmp546_ = vala_data_type_compatible (_tmp556_, _tmp559_);
	} else {
		_tmp546_ = FALSE;
	}
	if (_tmp546_) {
		gboolean _tmp560_ = FALSE;
		gboolean _tmp561_ = FALSE;
		gboolean _tmp562_ = FALSE;
		ValaExpression* _tmp563_;
		ValaExpression* _tmp564_;
		ValaDataType* _tmp565_;
		ValaDataType* _tmp566_;
		ValaSemanticAnalyzer* _tmp580_;
		ValaSemanticAnalyzer* _tmp581_;
		ValaDataType* _tmp582_;
		ValaDataType* _tmp583_;
		ValaDataType* _tmp584_;
		gboolean _tmp585_ = FALSE;
		ValaExpression* _tmp586_;
		ValaExpression* _tmp587_;
		ValaDataType* _tmp594_;
		ValaDataType* _tmp595_;
		gboolean _tmp596_;
		gboolean _tmp597_;
		_tmp563_ = vala_binary_expression_get_right (self);
		_tmp564_ = _tmp563_;
		_tmp565_ = vala_expression_get_value_type (_tmp564_);
		_tmp566_ = _tmp565_;
		if (_tmp566_ == NULL) {
			_tmp562_ = TRUE;
		} else {
			ValaExpression* _tmp567_;
			ValaExpression* _tmp568_;
			ValaDataType* _tmp569_;
			ValaDataType* _tmp570_;
			ValaSemanticAnalyzer* _tmp571_;
			ValaSemanticAnalyzer* _tmp572_;
			ValaDataType* _tmp573_;
			_tmp567_ = vala_binary_expression_get_right (self);
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_expression_get_value_type (_tmp568_);
			_tmp570_ = _tmp569_;
			_tmp571_ = vala_code_context_get_analyzer (context);
			_tmp572_ = _tmp571_;
			_tmp573_ = _tmp572_->string_type;
			_tmp562_ = !vala_data_type_compatible (_tmp570_, _tmp573_);
		}
		if (_tmp562_) {
			_tmp561_ = TRUE;
		} else {
			ValaExpression* _tmp574_;
			ValaExpression* _tmp575_;
			_tmp574_ = vala_binary_expression_get_left (self);
			_tmp575_ = _tmp574_;
			_tmp561_ = VALA_IS_NULL_LITERAL (_tmp575_);
		}
		if (_tmp561_) {
			_tmp560_ = TRUE;
		} else {
			ValaExpression* _tmp576_;
			ValaExpression* _tmp577_;
			_tmp576_ = vala_binary_expression_get_right (self);
			_tmp577_ = _tmp576_;
			_tmp560_ = VALA_IS_NULL_LITERAL (_tmp577_);
		}
		if (_tmp560_) {
			ValaSourceReference* _tmp578_;
			ValaSourceReference* _tmp579_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp578_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp579_ = _tmp578_;
			vala_report_error (_tmp579_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp580_ = vala_code_context_get_analyzer (context);
		_tmp581_ = _tmp580_;
		_tmp582_ = _tmp581_->string_type;
		_tmp583_ = vala_data_type_copy (_tmp582_);
		_tmp584_ = _tmp583_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp584_);
		_vala_code_node_unref0 (_tmp584_);
		_tmp586_ = vala_binary_expression_get_left (self);
		_tmp587_ = _tmp586_;
		if (vala_expression_is_constant (_tmp587_)) {
			ValaExpression* _tmp588_;
			ValaExpression* _tmp589_;
			_tmp588_ = vala_binary_expression_get_right (self);
			_tmp589_ = _tmp588_;
			_tmp585_ = vala_expression_is_constant (_tmp589_);
		} else {
			_tmp585_ = FALSE;
		}
		if (_tmp585_) {
			ValaDataType* _tmp590_;
			ValaDataType* _tmp591_;
			_tmp590_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp591_ = _tmp590_;
			vala_data_type_set_value_owned (_tmp591_, FALSE);
		} else {
			ValaDataType* _tmp592_;
			ValaDataType* _tmp593_;
			_tmp592_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp593_ = _tmp592_;
			vala_data_type_set_value_owned (_tmp593_, TRUE);
		}
		_tmp594_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp595_ = _tmp594_;
		vala_code_node_check ((ValaCodeNode*) _tmp595_, context);
		_tmp596_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp597_ = _tmp596_;
		result = !_tmp597_;
		return result;
	} else {
		gboolean _tmp598_ = FALSE;
		ValaBinaryOperator _tmp599_;
		_tmp599_ = self->priv->_operator;
		if (_tmp599_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaDataType* _tmp602_;
			ValaDataType* _tmp603_;
			_tmp600_ = vala_binary_expression_get_left (self);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_expression_get_value_type (_tmp601_);
			_tmp603_ = _tmp602_;
			_tmp598_ = VALA_IS_ARRAY_TYPE (_tmp603_);
		} else {
			_tmp598_ = FALSE;
		}
		if (_tmp598_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp604_;
			ValaExpression* _tmp605_;
			ValaDataType* _tmp606_;
			ValaDataType* _tmp607_;
			ValaArrayType* _tmp608_;
			gboolean _tmp609_;
			gboolean _tmp610_;
			gboolean _tmp613_ = FALSE;
			ValaExpression* _tmp614_;
			ValaExpression* _tmp615_;
			ValaDataType* _tmp616_;
			ValaDataType* _tmp617_;
			ValaExpression* _tmp627_;
			ValaExpression* _tmp628_;
			ValaArrayType* _tmp629_;
			ValaDataType* _tmp630_;
			ValaDataType* _tmp631_;
			ValaDataType* _tmp632_;
			ValaDataType* _tmp633_;
			ValaArrayType* _tmp634_;
			ValaDataType* _tmp635_;
			ValaDataType* _tmp636_;
			ValaDataType* _tmp637_;
			ValaDataType* _tmp638_;
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			gboolean _tmp641_;
			gboolean _tmp642_;
			_tmp604_ = vala_binary_expression_get_left (self);
			_tmp605_ = _tmp604_;
			_tmp606_ = vala_expression_get_value_type (_tmp605_);
			_tmp607_ = _tmp606_;
			array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
			_tmp608_ = array_type;
			_tmp609_ = vala_array_type_get_inline_allocated (_tmp608_);
			_tmp610_ = _tmp609_;
			if (_tmp610_) {
				ValaSourceReference* _tmp611_;
				ValaSourceReference* _tmp612_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp611_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp612_ = _tmp611_;
				vala_report_error (_tmp612_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp614_ = vala_binary_expression_get_right (self);
			_tmp615_ = _tmp614_;
			_tmp616_ = vala_expression_get_value_type (_tmp615_);
			_tmp617_ = _tmp616_;
			if (_tmp617_ == NULL) {
				_tmp613_ = TRUE;
			} else {
				ValaExpression* _tmp618_;
				ValaExpression* _tmp619_;
				ValaDataType* _tmp620_;
				ValaDataType* _tmp621_;
				ValaArrayType* _tmp622_;
				ValaDataType* _tmp623_;
				ValaDataType* _tmp624_;
				_tmp618_ = vala_binary_expression_get_right (self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_expression_get_value_type (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = array_type;
				_tmp623_ = vala_array_type_get_element_type (_tmp622_);
				_tmp624_ = _tmp623_;
				_tmp613_ = !vala_data_type_compatible (_tmp621_, _tmp624_);
			}
			if (_tmp613_) {
				ValaSourceReference* _tmp625_;
				ValaSourceReference* _tmp626_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp625_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp626_ = _tmp625_;
				vala_report_error (_tmp626_, "Incompatible operand");
				result = FALSE;
				return result;
			}
			_tmp627_ = vala_binary_expression_get_right (self);
			_tmp628_ = _tmp627_;
			_tmp629_ = array_type;
			_tmp630_ = vala_array_type_get_element_type (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_data_type_copy (_tmp631_);
			_tmp633_ = _tmp632_;
			vala_expression_set_target_type (_tmp628_, _tmp633_);
			_vala_code_node_unref0 (_tmp633_);
			_tmp634_ = array_type;
			_tmp635_ = vala_data_type_copy ((ValaDataType*) _tmp634_);
			_tmp636_ = _tmp635_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp636_);
			_vala_code_node_unref0 (_tmp636_);
			_tmp637_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp638_ = _tmp637_;
			vala_data_type_set_value_owned (_tmp638_, TRUE);
			_tmp639_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp640_ = _tmp639_;
			vala_code_node_check ((ValaCodeNode*) _tmp640_, context);
			_tmp641_ = vala_code_node_get_error ((ValaCodeNode*) self);
			_tmp642_ = _tmp641_;
			result = !_tmp642_;
			return result;
		}
	}
	_tmp643_ = self->priv->_operator;
	switch (_tmp643_) {
		case VALA_BINARY_OPERATOR_PLUS:
		case VALA_BINARY_OPERATOR_MINUS:
		case VALA_BINARY_OPERATOR_MUL:
		case VALA_BINARY_OPERATOR_DIV:
		{
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaDataType* _tmp646_;
			ValaDataType* _tmp647_;
			ValaDataType* _tmp690_;
			ValaDataType* _tmp691_;
			ValaDataType* _tmp703_;
			ValaDataType* _tmp704_;
			_tmp644_ = vala_binary_expression_get_left (self);
			_tmp645_ = _tmp644_;
			_tmp646_ = vala_expression_get_value_type (_tmp645_);
			_tmp647_ = _tmp646_;
			if (VALA_IS_POINTER_TYPE (_tmp647_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp648_;
				ValaExpression* _tmp649_;
				ValaDataType* _tmp650_;
				ValaDataType* _tmp651_;
				ValaPointerType* _tmp652_;
				ValaDataType* _tmp653_;
				ValaDataType* _tmp654_;
				ValaStruct* offset_type = NULL;
				ValaExpression* _tmp657_;
				ValaExpression* _tmp658_;
				ValaDataType* _tmp659_;
				ValaDataType* _tmp660_;
				ValaTypeSymbol* _tmp661_;
				ValaTypeSymbol* _tmp662_;
				gboolean _tmp663_ = FALSE;
				ValaStruct* _tmp664_;
				_tmp648_ = vala_binary_expression_get_left (self);
				_tmp649_ = _tmp648_;
				_tmp650_ = vala_expression_get_value_type (_tmp649_);
				_tmp651_ = _tmp650_;
				pointer_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_POINTER_TYPE, ValaPointerType);
				_tmp652_ = pointer_type;
				_tmp653_ = vala_pointer_type_get_base_type (_tmp652_);
				_tmp654_ = _tmp653_;
				if (VALA_IS_VOID_TYPE (_tmp654_)) {
					ValaSourceReference* _tmp655_;
					ValaSourceReference* _tmp656_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp655_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp656_ = _tmp655_;
					vala_report_error (_tmp656_, "Pointer arithmetic not supported for `void*'");
					result = FALSE;
					return result;
				}
				_tmp657_ = vala_binary_expression_get_right (self);
				_tmp658_ = _tmp657_;
				_tmp659_ = vala_expression_get_value_type (_tmp658_);
				_tmp660_ = _tmp659_;
				_tmp661_ = vala_data_type_get_type_symbol (_tmp660_);
				_tmp662_ = _tmp661_;
				offset_type = VALA_IS_STRUCT (_tmp662_) ? ((ValaStruct*) _tmp662_) : NULL;
				_tmp664_ = offset_type;
				if (_tmp664_ != NULL) {
					ValaStruct* _tmp665_;
					_tmp665_ = offset_type;
					_tmp663_ = vala_struct_is_integer_type (_tmp665_);
				} else {
					_tmp663_ = FALSE;
				}
				if (_tmp663_) {
					gboolean _tmp666_ = FALSE;
					ValaBinaryOperator _tmp667_;
					_tmp667_ = self->priv->_operator;
					if (_tmp667_ == VALA_BINARY_OPERATOR_PLUS) {
						_tmp666_ = TRUE;
					} else {
						ValaBinaryOperator _tmp668_;
						_tmp668_ = self->priv->_operator;
						_tmp666_ = _tmp668_ == VALA_BINARY_OPERATOR_MINUS;
					}
					if (_tmp666_) {
						ValaExpression* _tmp669_;
						ValaExpression* _tmp670_;
						ValaDataType* _tmp671_;
						ValaDataType* _tmp672_;
						ValaDataType* _tmp673_;
						ValaDataType* _tmp674_;
						_tmp669_ = vala_binary_expression_get_left (self);
						_tmp670_ = _tmp669_;
						_tmp671_ = vala_expression_get_value_type (_tmp670_);
						_tmp672_ = _tmp671_;
						_tmp673_ = vala_data_type_copy (_tmp672_);
						_tmp674_ = _tmp673_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp674_);
						_vala_code_node_unref0 (_tmp674_);
					}
				} else {
					ValaExpression* _tmp675_;
					ValaExpression* _tmp676_;
					ValaDataType* _tmp677_;
					ValaDataType* _tmp678_;
					_tmp675_ = vala_binary_expression_get_right (self);
					_tmp676_ = _tmp675_;
					_tmp677_ = vala_expression_get_value_type (_tmp676_);
					_tmp678_ = _tmp677_;
					if (VALA_IS_POINTER_TYPE (_tmp678_)) {
						ValaSemanticAnalyzer* _tmp679_;
						ValaSemanticAnalyzer* _tmp680_;
						ValaDataType* _tmp681_;
						_tmp679_ = vala_code_context_get_analyzer (context);
						_tmp680_ = _tmp679_;
						_tmp681_ = _tmp680_->size_t_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp681_);
					}
				}
			} else {
				ValaExpression* _tmp682_;
				ValaExpression* _tmp683_;
				ValaDataType* _tmp684_;
				ValaDataType* _tmp685_;
				ValaExpression* _tmp686_;
				ValaExpression* _tmp687_;
				ValaDataType* _tmp688_;
				ValaDataType* _tmp689_;
				_tmp682_ = vala_binary_expression_get_left (self);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_expression_get_target_type (_tmp683_);
				_tmp685_ = _tmp684_;
				vala_data_type_set_nullable (_tmp685_, FALSE);
				_tmp686_ = vala_binary_expression_get_right (self);
				_tmp687_ = _tmp686_;
				_tmp688_ = vala_expression_get_target_type (_tmp687_);
				_tmp689_ = _tmp688_;
				vala_data_type_set_nullable (_tmp689_, FALSE);
			}
			_tmp690_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp691_ = _tmp690_;
			if (_tmp691_ == NULL) {
				ValaSemanticAnalyzer* _tmp692_;
				ValaSemanticAnalyzer* _tmp693_;
				ValaExpression* _tmp694_;
				ValaExpression* _tmp695_;
				ValaDataType* _tmp696_;
				ValaDataType* _tmp697_;
				ValaExpression* _tmp698_;
				ValaExpression* _tmp699_;
				ValaDataType* _tmp700_;
				ValaDataType* _tmp701_;
				ValaDataType* _tmp702_;
				_tmp692_ = vala_code_context_get_analyzer (context);
				_tmp693_ = _tmp692_;
				_tmp694_ = vala_binary_expression_get_left (self);
				_tmp695_ = _tmp694_;
				_tmp696_ = vala_expression_get_target_type (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_binary_expression_get_right (self);
				_tmp699_ = _tmp698_;
				_tmp700_ = vala_expression_get_target_type (_tmp699_);
				_tmp701_ = _tmp700_;
				_tmp702_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp693_, _tmp697_, _tmp701_);
				vala_expression_set_value_type ((ValaExpression*) self, _tmp702_);
			}
			_tmp703_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp704_ = _tmp703_;
			if (_tmp704_ == NULL) {
				ValaSourceReference* _tmp705_;
				ValaSourceReference* _tmp706_;
				ValaExpression* _tmp707_;
				ValaExpression* _tmp708_;
				ValaDataType* _tmp709_;
				ValaDataType* _tmp710_;
				gchar* _tmp711_;
				gchar* _tmp712_;
				ValaExpression* _tmp713_;
				ValaExpression* _tmp714_;
				ValaDataType* _tmp715_;
				ValaDataType* _tmp716_;
				gchar* _tmp717_;
				gchar* _tmp718_;
				gchar* _tmp719_;
				gchar* _tmp720_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp705_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp706_ = _tmp705_;
				_tmp707_ = vala_binary_expression_get_left (self);
				_tmp708_ = _tmp707_;
				_tmp709_ = vala_expression_get_value_type (_tmp708_);
				_tmp710_ = _tmp709_;
				_tmp711_ = vala_code_node_to_string ((ValaCodeNode*) _tmp710_);
				_tmp712_ = _tmp711_;
				_tmp713_ = vala_binary_expression_get_right (self);
				_tmp714_ = _tmp713_;
				_tmp715_ = vala_expression_get_value_type (_tmp714_);
				_tmp716_ = _tmp715_;
				_tmp717_ = vala_code_node_to_string ((ValaCodeNode*) _tmp716_);
				_tmp718_ = _tmp717_;
				_tmp719_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp712_, _tmp718_);
				_tmp720_ = _tmp719_;
				vala_report_error (_tmp706_, _tmp720_);
				_g_free0 (_tmp720_);
				_g_free0 (_tmp718_);
				_g_free0 (_tmp712_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			ValaExpression* _tmp721_;
			ValaExpression* _tmp722_;
			ValaDataType* _tmp723_;
			ValaDataType* _tmp724_;
			ValaExpression* _tmp725_;
			ValaExpression* _tmp726_;
			ValaDataType* _tmp727_;
			ValaDataType* _tmp728_;
			ValaSemanticAnalyzer* _tmp729_;
			ValaSemanticAnalyzer* _tmp730_;
			ValaExpression* _tmp731_;
			ValaExpression* _tmp732_;
			ValaDataType* _tmp733_;
			ValaDataType* _tmp734_;
			ValaExpression* _tmp735_;
			ValaExpression* _tmp736_;
			ValaDataType* _tmp737_;
			ValaDataType* _tmp738_;
			ValaDataType* _tmp739_;
			ValaDataType* _tmp740_;
			ValaDataType* _tmp741_;
			_tmp721_ = vala_binary_expression_get_left (self);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_expression_get_target_type (_tmp722_);
			_tmp724_ = _tmp723_;
			vala_data_type_set_nullable (_tmp724_, FALSE);
			_tmp725_ = vala_binary_expression_get_right (self);
			_tmp726_ = _tmp725_;
			_tmp727_ = vala_expression_get_target_type (_tmp726_);
			_tmp728_ = _tmp727_;
			vala_data_type_set_nullable (_tmp728_, FALSE);
			_tmp729_ = vala_code_context_get_analyzer (context);
			_tmp730_ = _tmp729_;
			_tmp731_ = vala_binary_expression_get_left (self);
			_tmp732_ = _tmp731_;
			_tmp733_ = vala_expression_get_target_type (_tmp732_);
			_tmp734_ = _tmp733_;
			_tmp735_ = vala_binary_expression_get_right (self);
			_tmp736_ = _tmp735_;
			_tmp737_ = vala_expression_get_target_type (_tmp736_);
			_tmp738_ = _tmp737_;
			_tmp739_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp730_, _tmp734_, _tmp738_);
			vala_expression_set_value_type ((ValaExpression*) self, _tmp739_);
			_tmp740_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp741_ = _tmp740_;
			if (_tmp741_ == NULL) {
				ValaSourceReference* _tmp742_;
				ValaSourceReference* _tmp743_;
				ValaExpression* _tmp744_;
				ValaExpression* _tmp745_;
				ValaDataType* _tmp746_;
				ValaDataType* _tmp747_;
				gchar* _tmp748_;
				gchar* _tmp749_;
				ValaExpression* _tmp750_;
				ValaExpression* _tmp751_;
				ValaDataType* _tmp752_;
				ValaDataType* _tmp753_;
				gchar* _tmp754_;
				gchar* _tmp755_;
				gchar* _tmp756_;
				gchar* _tmp757_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp742_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp743_ = _tmp742_;
				_tmp744_ = vala_binary_expression_get_left (self);
				_tmp745_ = _tmp744_;
				_tmp746_ = vala_expression_get_value_type (_tmp745_);
				_tmp747_ = _tmp746_;
				_tmp748_ = vala_code_node_to_string ((ValaCodeNode*) _tmp747_);
				_tmp749_ = _tmp748_;
				_tmp750_ = vala_binary_expression_get_right (self);
				_tmp751_ = _tmp750_;
				_tmp752_ = vala_expression_get_value_type (_tmp751_);
				_tmp753_ = _tmp752_;
				_tmp754_ = vala_code_node_to_string ((ValaCodeNode*) _tmp753_);
				_tmp755_ = _tmp754_;
				_tmp756_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp749_, _tmp755_);
				_tmp757_ = _tmp756_;
				vala_report_error (_tmp743_, _tmp757_);
				_g_free0 (_tmp757_);
				_g_free0 (_tmp755_);
				_g_free0 (_tmp749_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			gboolean _tmp758_ = FALSE;
			ValaExpression* _tmp759_;
			ValaExpression* _tmp760_;
			ValaDataType* _tmp761_;
			ValaDataType* _tmp762_;
			ValaSemanticAnalyzer* _tmp763_;
			ValaSemanticAnalyzer* _tmp764_;
			ValaDataType* _tmp765_;
			ValaSemanticAnalyzer* _tmp847_;
			ValaSemanticAnalyzer* _tmp848_;
			ValaDataType* _tmp849_;
			_tmp759_ = vala_binary_expression_get_left (self);
			_tmp760_ = _tmp759_;
			_tmp761_ = vala_expression_get_value_type (_tmp760_);
			_tmp762_ = _tmp761_;
			_tmp763_ = vala_code_context_get_analyzer (context);
			_tmp764_ = _tmp763_;
			_tmp765_ = _tmp764_->string_type;
			if (vala_data_type_compatible (_tmp762_, _tmp765_)) {
				ValaExpression* _tmp766_;
				ValaExpression* _tmp767_;
				ValaDataType* _tmp768_;
				ValaDataType* _tmp769_;
				ValaSemanticAnalyzer* _tmp770_;
				ValaSemanticAnalyzer* _tmp771_;
				ValaDataType* _tmp772_;
				_tmp766_ = vala_binary_expression_get_right (self);
				_tmp767_ = _tmp766_;
				_tmp768_ = vala_expression_get_value_type (_tmp767_);
				_tmp769_ = _tmp768_;
				_tmp770_ = vala_code_context_get_analyzer (context);
				_tmp771_ = _tmp770_;
				_tmp772_ = _tmp771_->string_type;
				_tmp758_ = vala_data_type_compatible (_tmp769_, _tmp772_);
			} else {
				_tmp758_ = FALSE;
			}
			if (_tmp758_) {
			} else {
				gboolean _tmp773_ = FALSE;
				ValaExpression* _tmp774_;
				ValaExpression* _tmp775_;
				ValaDataType* _tmp776_;
				ValaDataType* _tmp777_;
				_tmp774_ = vala_binary_expression_get_left (self);
				_tmp775_ = _tmp774_;
				_tmp776_ = vala_expression_get_value_type (_tmp775_);
				_tmp777_ = _tmp776_;
				if (VALA_IS_POINTER_TYPE (_tmp777_)) {
					ValaExpression* _tmp778_;
					ValaExpression* _tmp779_;
					ValaDataType* _tmp780_;
					ValaDataType* _tmp781_;
					_tmp778_ = vala_binary_expression_get_right (self);
					_tmp779_ = _tmp778_;
					_tmp780_ = vala_expression_get_value_type (_tmp779_);
					_tmp781_ = _tmp780_;
					_tmp773_ = VALA_IS_POINTER_TYPE (_tmp781_);
				} else {
					_tmp773_ = FALSE;
				}
				if (_tmp773_) {
				} else {
					ValaDataType* resulting_type = NULL;
					gboolean _tmp782_;
					ValaDataType* _tmp811_;
					gboolean _tmp828_;
					ValaExpression* _tmp834_;
					ValaExpression* _tmp835_;
					ValaDataType* _tmp836_;
					ValaDataType* _tmp837_;
					ValaDataType* _tmp838_;
					ValaExpression* _tmp839_;
					ValaExpression* _tmp840_;
					ValaDataType* _tmp841_;
					ValaDataType* _tmp842_;
					ValaExpression* _tmp843_;
					ValaExpression* _tmp844_;
					ValaDataType* _tmp845_;
					ValaDataType* _tmp846_;
					_tmp782_ = self->priv->_is_chained;
					if (_tmp782_) {
						ValaBinaryExpression* lbe = NULL;
						ValaExpression* _tmp783_;
						ValaExpression* _tmp784_;
						ValaBinaryExpression* _tmp785_;
						ValaSemanticAnalyzer* _tmp786_;
						ValaSemanticAnalyzer* _tmp787_;
						ValaBinaryExpression* _tmp788_;
						ValaExpression* _tmp789_;
						ValaExpression* _tmp790_;
						ValaDataType* _tmp791_;
						ValaDataType* _tmp792_;
						ValaExpression* _tmp793_;
						ValaExpression* _tmp794_;
						ValaDataType* _tmp795_;
						ValaDataType* _tmp796_;
						ValaDataType* _tmp797_;
						ValaDataType* _tmp798_;
						_tmp783_ = vala_binary_expression_get_left (self);
						_tmp784_ = _tmp783_;
						_tmp785_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp784_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
						lbe = _tmp785_;
						_tmp786_ = vala_code_context_get_analyzer (context);
						_tmp787_ = _tmp786_;
						_tmp788_ = lbe;
						_tmp789_ = vala_binary_expression_get_right (_tmp788_);
						_tmp790_ = _tmp789_;
						_tmp791_ = vala_expression_get_target_type (_tmp790_);
						_tmp792_ = _tmp791_;
						_tmp793_ = vala_binary_expression_get_right (self);
						_tmp794_ = _tmp793_;
						_tmp795_ = vala_expression_get_target_type (_tmp794_);
						_tmp796_ = _tmp795_;
						_tmp797_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp787_, _tmp792_, _tmp796_);
						_tmp798_ = _vala_code_node_ref0 (_tmp797_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp798_;
						_vala_code_node_unref0 (lbe);
					} else {
						ValaSemanticAnalyzer* _tmp799_;
						ValaSemanticAnalyzer* _tmp800_;
						ValaExpression* _tmp801_;
						ValaExpression* _tmp802_;
						ValaDataType* _tmp803_;
						ValaDataType* _tmp804_;
						ValaExpression* _tmp805_;
						ValaExpression* _tmp806_;
						ValaDataType* _tmp807_;
						ValaDataType* _tmp808_;
						ValaDataType* _tmp809_;
						ValaDataType* _tmp810_;
						_tmp799_ = vala_code_context_get_analyzer (context);
						_tmp800_ = _tmp799_;
						_tmp801_ = vala_binary_expression_get_left (self);
						_tmp802_ = _tmp801_;
						_tmp803_ = vala_expression_get_target_type (_tmp802_);
						_tmp804_ = _tmp803_;
						_tmp805_ = vala_binary_expression_get_right (self);
						_tmp806_ = _tmp805_;
						_tmp807_ = vala_expression_get_target_type (_tmp806_);
						_tmp808_ = _tmp807_;
						_tmp809_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp800_, _tmp804_, _tmp808_);
						_tmp810_ = _vala_code_node_ref0 (_tmp809_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp810_;
					}
					_tmp811_ = resulting_type;
					if (_tmp811_ == NULL) {
						ValaSourceReference* _tmp812_;
						ValaSourceReference* _tmp813_;
						ValaExpression* _tmp814_;
						ValaExpression* _tmp815_;
						ValaDataType* _tmp816_;
						ValaDataType* _tmp817_;
						gchar* _tmp818_;
						gchar* _tmp819_;
						ValaExpression* _tmp820_;
						ValaExpression* _tmp821_;
						ValaDataType* _tmp822_;
						ValaDataType* _tmp823_;
						gchar* _tmp824_;
						gchar* _tmp825_;
						gchar* _tmp826_;
						gchar* _tmp827_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp812_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp813_ = _tmp812_;
						_tmp814_ = vala_binary_expression_get_left (self);
						_tmp815_ = _tmp814_;
						_tmp816_ = vala_expression_get_value_type (_tmp815_);
						_tmp817_ = _tmp816_;
						_tmp818_ = vala_code_node_to_string ((ValaCodeNode*) _tmp817_);
						_tmp819_ = _tmp818_;
						_tmp820_ = vala_binary_expression_get_right (self);
						_tmp821_ = _tmp820_;
						_tmp822_ = vala_expression_get_value_type (_tmp821_);
						_tmp823_ = _tmp822_;
						_tmp824_ = vala_code_node_to_string ((ValaCodeNode*) _tmp823_);
						_tmp825_ = _tmp824_;
						_tmp826_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp819_, _tmp825_);
						_tmp827_ = _tmp826_;
						vala_report_error (_tmp813_, _tmp827_);
						_g_free0 (_tmp827_);
						_g_free0 (_tmp825_);
						_g_free0 (_tmp819_);
						result = FALSE;
						_vala_code_node_unref0 (resulting_type);
						return result;
					}
					_tmp828_ = self->priv->_is_chained;
					if (!_tmp828_) {
						ValaExpression* _tmp829_;
						ValaExpression* _tmp830_;
						ValaDataType* _tmp831_;
						ValaDataType* _tmp832_;
						ValaDataType* _tmp833_;
						_tmp829_ = vala_binary_expression_get_left (self);
						_tmp830_ = _tmp829_;
						_tmp831_ = resulting_type;
						_tmp832_ = vala_data_type_copy (_tmp831_);
						_tmp833_ = _tmp832_;
						vala_expression_set_target_type (_tmp830_, _tmp833_);
						_vala_code_node_unref0 (_tmp833_);
					}
					_tmp834_ = vala_binary_expression_get_right (self);
					_tmp835_ = _tmp834_;
					_tmp836_ = resulting_type;
					_tmp837_ = vala_data_type_copy (_tmp836_);
					_tmp838_ = _tmp837_;
					vala_expression_set_target_type (_tmp835_, _tmp838_);
					_vala_code_node_unref0 (_tmp838_);
					_tmp839_ = vala_binary_expression_get_left (self);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_expression_get_target_type (_tmp840_);
					_tmp842_ = _tmp841_;
					vala_data_type_set_nullable (_tmp842_, FALSE);
					_tmp843_ = vala_binary_expression_get_right (self);
					_tmp844_ = _tmp843_;
					_tmp845_ = vala_expression_get_target_type (_tmp844_);
					_tmp846_ = _tmp845_;
					vala_data_type_set_nullable (_tmp846_, FALSE);
					_vala_code_node_unref0 (resulting_type);
				}
			}
			_tmp847_ = vala_code_context_get_analyzer (context);
			_tmp848_ = _tmp847_;
			_tmp849_ = _tmp848_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp849_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			ValaProfile _tmp850_;
			ValaProfile _tmp851_;
			gboolean _tmp920_ = FALSE;
			ValaExpression* _tmp921_;
			ValaExpression* _tmp922_;
			ValaDataType* _tmp923_;
			ValaDataType* _tmp924_;
			ValaExpression* _tmp925_;
			ValaExpression* _tmp926_;
			ValaDataType* _tmp927_;
			ValaDataType* _tmp928_;
			ValaDataType* resulting_type = NULL;
			ValaSemanticAnalyzer* _tmp953_;
			ValaSemanticAnalyzer* _tmp954_;
			ValaExpression* _tmp955_;
			ValaExpression* _tmp956_;
			ValaDataType* _tmp957_;
			ValaDataType* _tmp958_;
			ValaExpression* _tmp959_;
			ValaExpression* _tmp960_;
			ValaDataType* _tmp961_;
			ValaDataType* _tmp962_;
			ValaDataType* _tmp963_;
			ValaDataType* _tmp964_;
			ValaDataType* _tmp965_;
			ValaExpression* _tmp976_;
			ValaExpression* _tmp977_;
			ValaDataType* _tmp978_;
			ValaDataType* _tmp979_;
			ValaExpression* _tmp980_;
			ValaExpression* _tmp981_;
			ValaDataType* _tmp982_;
			ValaDataType* _tmp983_;
			ValaExpression* _tmp984_;
			ValaExpression* _tmp985_;
			ValaDataType* _tmp986_;
			ValaDataType* _tmp987_;
			gboolean _tmp988_;
			gboolean _tmp989_;
			ValaExpression* _tmp990_;
			ValaExpression* _tmp991_;
			ValaDataType* _tmp992_;
			ValaDataType* _tmp993_;
			gboolean _tmp994_;
			gboolean _tmp995_;
			ValaSemanticAnalyzer* _tmp1004_;
			ValaSemanticAnalyzer* _tmp1005_;
			ValaDataType* _tmp1006_;
			_tmp850_ = vala_code_context_get_profile (context);
			_tmp851_ = _tmp850_;
			if (_tmp851_ == VALA_PROFILE_GOBJECT) {
				ValaTypeSymbol* gvalue_type = NULL;
				ValaSemanticAnalyzer* _tmp852_;
				ValaSemanticAnalyzer* _tmp853_;
				ValaStructValueType* _tmp854_;
				ValaTypeSymbol* _tmp855_;
				ValaTypeSymbol* _tmp856_;
				ValaTypeSymbol* _tmp857_;
				gboolean _tmp858_ = FALSE;
				gboolean _tmp859_ = FALSE;
				ValaExpression* _tmp860_;
				ValaExpression* _tmp861_;
				ValaDataType* _tmp862_;
				ValaDataType* _tmp863_;
				ValaTypeSymbol* _tmp864_;
				ValaTypeSymbol* _tmp865_;
				ValaTypeSymbol* _tmp866_;
				_tmp852_ = vala_code_context_get_analyzer (context);
				_tmp853_ = _tmp852_;
				_tmp854_ = _tmp853_->gvalue_type;
				_tmp855_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp854_);
				_tmp856_ = _tmp855_;
				_tmp857_ = _vala_code_node_ref0 (_tmp856_);
				gvalue_type = _tmp857_;
				_tmp860_ = vala_binary_expression_get_left (self);
				_tmp861_ = _tmp860_;
				_tmp862_ = vala_expression_get_target_type (_tmp861_);
				_tmp863_ = _tmp862_;
				_tmp864_ = vala_data_type_get_type_symbol (_tmp863_);
				_tmp865_ = _tmp864_;
				_tmp866_ = gvalue_type;
				if (_tmp865_ == _tmp866_) {
					ValaExpression* _tmp867_;
					ValaExpression* _tmp868_;
					ValaDataType* _tmp869_;
					ValaDataType* _tmp870_;
					ValaTypeSymbol* _tmp871_;
					ValaTypeSymbol* _tmp872_;
					ValaTypeSymbol* _tmp873_;
					_tmp867_ = vala_binary_expression_get_right (self);
					_tmp868_ = _tmp867_;
					_tmp869_ = vala_expression_get_target_type (_tmp868_);
					_tmp870_ = _tmp869_;
					_tmp871_ = vala_data_type_get_type_symbol (_tmp870_);
					_tmp872_ = _tmp871_;
					_tmp873_ = gvalue_type;
					_tmp859_ = _tmp872_ != _tmp873_;
				} else {
					_tmp859_ = FALSE;
				}
				if (_tmp859_) {
					_tmp858_ = TRUE;
				} else {
					gboolean _tmp874_ = FALSE;
					ValaExpression* _tmp875_;
					ValaExpression* _tmp876_;
					ValaDataType* _tmp877_;
					ValaDataType* _tmp878_;
					ValaTypeSymbol* _tmp879_;
					ValaTypeSymbol* _tmp880_;
					ValaTypeSymbol* _tmp881_;
					_tmp875_ = vala_binary_expression_get_left (self);
					_tmp876_ = _tmp875_;
					_tmp877_ = vala_expression_get_target_type (_tmp876_);
					_tmp878_ = _tmp877_;
					_tmp879_ = vala_data_type_get_type_symbol (_tmp878_);
					_tmp880_ = _tmp879_;
					_tmp881_ = gvalue_type;
					if (_tmp880_ != _tmp881_) {
						ValaExpression* _tmp882_;
						ValaExpression* _tmp883_;
						ValaDataType* _tmp884_;
						ValaDataType* _tmp885_;
						ValaTypeSymbol* _tmp886_;
						ValaTypeSymbol* _tmp887_;
						ValaTypeSymbol* _tmp888_;
						_tmp882_ = vala_binary_expression_get_right (self);
						_tmp883_ = _tmp882_;
						_tmp884_ = vala_expression_get_target_type (_tmp883_);
						_tmp885_ = _tmp884_;
						_tmp886_ = vala_data_type_get_type_symbol (_tmp885_);
						_tmp887_ = _tmp886_;
						_tmp888_ = gvalue_type;
						_tmp874_ = _tmp887_ == _tmp888_;
					} else {
						_tmp874_ = FALSE;
					}
					_tmp858_ = _tmp874_;
				}
				if (_tmp858_) {
					ValaExpression* gvalue_expr = NULL;
					ValaDataType* target_type = NULL;
					ValaExpression* _tmp889_;
					ValaExpression* _tmp890_;
					ValaDataType* _tmp891_;
					ValaDataType* _tmp892_;
					ValaTypeSymbol* _tmp893_;
					ValaTypeSymbol* _tmp894_;
					ValaTypeSymbol* _tmp895_;
					ValaCastExpression* cast_expr = NULL;
					ValaExpression* _tmp912_;
					ValaDataType* _tmp913_;
					ValaExpression* _tmp914_;
					ValaSourceReference* _tmp915_;
					ValaSourceReference* _tmp916_;
					ValaCastExpression* _tmp917_;
					ValaExpression* _tmp918_;
					ValaCastExpression* _tmp919_;
					_tmp889_ = vala_binary_expression_get_left (self);
					_tmp890_ = _tmp889_;
					_tmp891_ = vala_expression_get_target_type (_tmp890_);
					_tmp892_ = _tmp891_;
					_tmp893_ = vala_data_type_get_type_symbol (_tmp892_);
					_tmp894_ = _tmp893_;
					_tmp895_ = gvalue_type;
					if (_tmp894_ == _tmp895_) {
						ValaExpression* _tmp896_;
						ValaExpression* _tmp897_;
						ValaExpression* _tmp898_;
						ValaExpression* _tmp899_;
						ValaExpression* _tmp900_;
						ValaDataType* _tmp901_;
						ValaDataType* _tmp902_;
						ValaDataType* _tmp903_;
						_tmp896_ = vala_binary_expression_get_left (self);
						_tmp897_ = _tmp896_;
						_tmp898_ = _vala_code_node_ref0 (_tmp897_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp898_;
						_tmp899_ = vala_binary_expression_get_right (self);
						_tmp900_ = _tmp899_;
						_tmp901_ = vala_expression_get_target_type (_tmp900_);
						_tmp902_ = _tmp901_;
						_tmp903_ = _vala_code_node_ref0 (_tmp902_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp903_;
					} else {
						ValaExpression* _tmp904_;
						ValaExpression* _tmp905_;
						ValaExpression* _tmp906_;
						ValaExpression* _tmp907_;
						ValaExpression* _tmp908_;
						ValaDataType* _tmp909_;
						ValaDataType* _tmp910_;
						ValaDataType* _tmp911_;
						_tmp904_ = vala_binary_expression_get_right (self);
						_tmp905_ = _tmp904_;
						_tmp906_ = _vala_code_node_ref0 (_tmp905_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp906_;
						_tmp907_ = vala_binary_expression_get_left (self);
						_tmp908_ = _tmp907_;
						_tmp909_ = vala_expression_get_target_type (_tmp908_);
						_tmp910_ = _tmp909_;
						_tmp911_ = _vala_code_node_ref0 (_tmp910_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp911_;
					}
					_tmp912_ = gvalue_expr;
					_tmp913_ = target_type;
					_tmp914_ = gvalue_expr;
					_tmp915_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp914_);
					_tmp916_ = _tmp915_;
					_tmp917_ = vala_cast_expression_new (_tmp912_, _tmp913_, _tmp916_);
					cast_expr = _tmp917_;
					_tmp918_ = gvalue_expr;
					_tmp919_ = cast_expr;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp918_, (ValaExpression*) _tmp919_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					result = vala_code_node_check ((ValaCodeNode*) self, context);
					_vala_code_node_unref0 (cast_expr);
					_vala_code_node_unref0 (target_type);
					_vala_code_node_unref0 (gvalue_expr);
					_vala_code_node_unref0 (gvalue_type);
					return result;
				}
				_vala_code_node_unref0 (gvalue_type);
			}
			_tmp921_ = vala_binary_expression_get_right (self);
			_tmp922_ = _tmp921_;
			_tmp923_ = vala_expression_get_value_type (_tmp922_);
			_tmp924_ = _tmp923_;
			_tmp925_ = vala_binary_expression_get_left (self);
			_tmp926_ = _tmp925_;
			_tmp927_ = vala_expression_get_value_type (_tmp926_);
			_tmp928_ = _tmp927_;
			if (!vala_data_type_compatible (_tmp924_, _tmp928_)) {
				ValaExpression* _tmp929_;
				ValaExpression* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaExpression* _tmp933_;
				ValaExpression* _tmp934_;
				ValaDataType* _tmp935_;
				ValaDataType* _tmp936_;
				_tmp929_ = vala_binary_expression_get_left (self);
				_tmp930_ = _tmp929_;
				_tmp931_ = vala_expression_get_value_type (_tmp930_);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_binary_expression_get_right (self);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_expression_get_value_type (_tmp934_);
				_tmp936_ = _tmp935_;
				_tmp920_ = !vala_data_type_compatible (_tmp932_, _tmp936_);
			} else {
				_tmp920_ = FALSE;
			}
			if (_tmp920_) {
				ValaSourceReference* _tmp937_;
				ValaSourceReference* _tmp938_;
				ValaExpression* _tmp939_;
				ValaExpression* _tmp940_;
				ValaDataType* _tmp941_;
				ValaDataType* _tmp942_;
				gchar* _tmp943_;
				gchar* _tmp944_;
				ValaExpression* _tmp945_;
				ValaExpression* _tmp946_;
				ValaDataType* _tmp947_;
				ValaDataType* _tmp948_;
				gchar* _tmp949_;
				gchar* _tmp950_;
				gchar* _tmp951_;
				gchar* _tmp952_;
				_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_binary_expression_get_right (self);
				_tmp940_ = _tmp939_;
				_tmp941_ = vala_expression_get_value_type (_tmp940_);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_code_node_to_string ((ValaCodeNode*) _tmp942_);
				_tmp944_ = _tmp943_;
				_tmp945_ = vala_binary_expression_get_left (self);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_expression_get_value_type (_tmp946_);
				_tmp948_ = _tmp947_;
				_tmp949_ = vala_code_node_to_string ((ValaCodeNode*) _tmp948_);
				_tmp950_ = _tmp949_;
				_tmp951_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp944_, _tmp950_);
				_tmp952_ = _tmp951_;
				vala_report_error (_tmp938_, _tmp952_);
				_g_free0 (_tmp952_);
				_g_free0 (_tmp950_);
				_g_free0 (_tmp944_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp953_ = vala_code_context_get_analyzer (context);
			_tmp954_ = _tmp953_;
			_tmp955_ = vala_binary_expression_get_left (self);
			_tmp956_ = _tmp955_;
			_tmp957_ = vala_expression_get_target_type (_tmp956_);
			_tmp958_ = _tmp957_;
			_tmp959_ = vala_binary_expression_get_right (self);
			_tmp960_ = _tmp959_;
			_tmp961_ = vala_expression_get_target_type (_tmp960_);
			_tmp962_ = _tmp961_;
			_tmp963_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp954_, _tmp958_, _tmp962_);
			_tmp964_ = _vala_code_node_ref0 (_tmp963_);
			resulting_type = _tmp964_;
			_tmp965_ = resulting_type;
			if (_tmp965_ != NULL) {
				ValaExpression* _tmp966_;
				ValaExpression* _tmp967_;
				ValaDataType* _tmp968_;
				ValaDataType* _tmp969_;
				ValaDataType* _tmp970_;
				ValaExpression* _tmp971_;
				ValaExpression* _tmp972_;
				ValaDataType* _tmp973_;
				ValaDataType* _tmp974_;
				ValaDataType* _tmp975_;
				_tmp966_ = vala_binary_expression_get_left (self);
				_tmp967_ = _tmp966_;
				_tmp968_ = resulting_type;
				_tmp969_ = vala_data_type_copy (_tmp968_);
				_tmp970_ = _tmp969_;
				vala_expression_set_target_type (_tmp967_, _tmp970_);
				_vala_code_node_unref0 (_tmp970_);
				_tmp971_ = vala_binary_expression_get_right (self);
				_tmp972_ = _tmp971_;
				_tmp973_ = resulting_type;
				_tmp974_ = vala_data_type_copy (_tmp973_);
				_tmp975_ = _tmp974_;
				vala_expression_set_target_type (_tmp972_, _tmp975_);
				_vala_code_node_unref0 (_tmp975_);
			}
			_tmp976_ = vala_binary_expression_get_left (self);
			_tmp977_ = _tmp976_;
			_tmp978_ = vala_expression_get_target_type (_tmp977_);
			_tmp979_ = _tmp978_;
			vala_data_type_set_value_owned (_tmp979_, FALSE);
			_tmp980_ = vala_binary_expression_get_right (self);
			_tmp981_ = _tmp980_;
			_tmp982_ = vala_expression_get_target_type (_tmp981_);
			_tmp983_ = _tmp982_;
			vala_data_type_set_value_owned (_tmp983_, FALSE);
			_tmp984_ = vala_binary_expression_get_left (self);
			_tmp985_ = _tmp984_;
			_tmp986_ = vala_expression_get_value_type (_tmp985_);
			_tmp987_ = _tmp986_;
			_tmp988_ = vala_data_type_get_nullable (_tmp987_);
			_tmp989_ = _tmp988_;
			_tmp990_ = vala_binary_expression_get_right (self);
			_tmp991_ = _tmp990_;
			_tmp992_ = vala_expression_get_value_type (_tmp991_);
			_tmp993_ = _tmp992_;
			_tmp994_ = vala_data_type_get_nullable (_tmp993_);
			_tmp995_ = _tmp994_;
			if (_tmp989_ != _tmp995_) {
				ValaExpression* _tmp996_;
				ValaExpression* _tmp997_;
				ValaDataType* _tmp998_;
				ValaDataType* _tmp999_;
				ValaExpression* _tmp1000_;
				ValaExpression* _tmp1001_;
				ValaDataType* _tmp1002_;
				ValaDataType* _tmp1003_;
				_tmp996_ = vala_binary_expression_get_left (self);
				_tmp997_ = _tmp996_;
				_tmp998_ = vala_expression_get_target_type (_tmp997_);
				_tmp999_ = _tmp998_;
				vala_data_type_set_nullable (_tmp999_, TRUE);
				_tmp1000_ = vala_binary_expression_get_right (self);
				_tmp1001_ = _tmp1000_;
				_tmp1002_ = vala_expression_get_target_type (_tmp1001_);
				_tmp1003_ = _tmp1002_;
				vala_data_type_set_nullable (_tmp1003_, TRUE);
			}
			_tmp1004_ = vala_code_context_get_analyzer (context);
			_tmp1005_ = _tmp1004_;
			_tmp1006_ = _tmp1005_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1006_);
			_vala_code_node_unref0 (resulting_type);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			ValaExpression* _tmp1007_;
			ValaExpression* _tmp1008_;
			ValaDataType* _tmp1009_;
			ValaDataType* _tmp1010_;
			ValaExpression* _tmp1011_;
			ValaExpression* _tmp1012_;
			ValaDataType* _tmp1013_;
			ValaDataType* _tmp1014_;
			gboolean _tmp1015_ = FALSE;
			ValaExpression* _tmp1016_;
			ValaExpression* _tmp1017_;
			ValaDataType* _tmp1018_;
			ValaDataType* _tmp1019_;
			ValaSemanticAnalyzer* _tmp1020_;
			ValaSemanticAnalyzer* _tmp1021_;
			ValaDataType* _tmp1022_;
			_tmp1007_ = vala_binary_expression_get_left (self);
			_tmp1008_ = _tmp1007_;
			_tmp1009_ = vala_expression_get_target_type (_tmp1008_);
			_tmp1010_ = _tmp1009_;
			vala_data_type_set_nullable (_tmp1010_, FALSE);
			_tmp1011_ = vala_binary_expression_get_right (self);
			_tmp1012_ = _tmp1011_;
			_tmp1013_ = vala_expression_get_target_type (_tmp1012_);
			_tmp1014_ = _tmp1013_;
			vala_data_type_set_nullable (_tmp1014_, FALSE);
			_tmp1016_ = vala_binary_expression_get_left (self);
			_tmp1017_ = _tmp1016_;
			_tmp1018_ = vala_expression_get_value_type (_tmp1017_);
			_tmp1019_ = _tmp1018_;
			_tmp1020_ = vala_code_context_get_analyzer (context);
			_tmp1021_ = _tmp1020_;
			_tmp1022_ = _tmp1021_->bool_type;
			if (vala_data_type_compatible (_tmp1019_, _tmp1022_)) {
				ValaExpression* _tmp1023_;
				ValaExpression* _tmp1024_;
				ValaDataType* _tmp1025_;
				ValaDataType* _tmp1026_;
				ValaSemanticAnalyzer* _tmp1027_;
				ValaSemanticAnalyzer* _tmp1028_;
				ValaDataType* _tmp1029_;
				_tmp1023_ = vala_binary_expression_get_right (self);
				_tmp1024_ = _tmp1023_;
				_tmp1025_ = vala_expression_get_value_type (_tmp1024_);
				_tmp1026_ = _tmp1025_;
				_tmp1027_ = vala_code_context_get_analyzer (context);
				_tmp1028_ = _tmp1027_;
				_tmp1029_ = _tmp1028_->bool_type;
				_tmp1015_ = !vala_data_type_compatible (_tmp1026_, _tmp1029_);
			} else {
				_tmp1015_ = FALSE;
			}
			if (_tmp1015_) {
				ValaExpression* _tmp1030_;
				ValaExpression* _tmp1031_;
				ValaDataType* _tmp1032_;
				ValaDataType* _tmp1033_;
				ValaDataType* _tmp1034_;
				ValaDataType* _tmp1035_;
				_tmp1030_ = vala_binary_expression_get_right (self);
				_tmp1031_ = _tmp1030_;
				_tmp1032_ = vala_expression_get_target_type (_tmp1031_);
				_tmp1033_ = _tmp1032_;
				_tmp1034_ = vala_data_type_copy (_tmp1033_);
				_tmp1035_ = _tmp1034_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1035_);
				_vala_code_node_unref0 (_tmp1035_);
			} else {
				ValaExpression* _tmp1036_;
				ValaExpression* _tmp1037_;
				ValaDataType* _tmp1038_;
				ValaDataType* _tmp1039_;
				ValaDataType* _tmp1040_;
				ValaDataType* _tmp1041_;
				_tmp1036_ = vala_binary_expression_get_left (self);
				_tmp1037_ = _tmp1036_;
				_tmp1038_ = vala_expression_get_target_type (_tmp1037_);
				_tmp1039_ = _tmp1038_;
				_tmp1040_ = vala_data_type_copy (_tmp1039_);
				_tmp1041_ = _tmp1040_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1041_);
				_vala_code_node_unref0 (_tmp1041_);
			}
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		case VALA_BINARY_OPERATOR_OR:
		{
			gboolean _tmp1042_ = FALSE;
			ValaExpression* _tmp1043_;
			ValaExpression* _tmp1044_;
			ValaDataType* _tmp1045_;
			ValaDataType* _tmp1046_;
			ValaSemanticAnalyzer* _tmp1047_;
			ValaSemanticAnalyzer* _tmp1048_;
			ValaDataType* _tmp1049_;
			ValaExpression* _tmp1059_;
			ValaExpression* _tmp1060_;
			ValaDataType* _tmp1061_;
			ValaDataType* _tmp1062_;
			ValaExpression* _tmp1063_;
			ValaExpression* _tmp1064_;
			ValaDataType* _tmp1065_;
			ValaDataType* _tmp1066_;
			ValaSemanticAnalyzer* _tmp1067_;
			ValaSemanticAnalyzer* _tmp1068_;
			ValaDataType* _tmp1069_;
			_tmp1043_ = vala_binary_expression_get_left (self);
			_tmp1044_ = _tmp1043_;
			_tmp1045_ = vala_expression_get_value_type (_tmp1044_);
			_tmp1046_ = _tmp1045_;
			_tmp1047_ = vala_code_context_get_analyzer (context);
			_tmp1048_ = _tmp1047_;
			_tmp1049_ = _tmp1048_->bool_type;
			if (!vala_data_type_compatible (_tmp1046_, _tmp1049_)) {
				_tmp1042_ = TRUE;
			} else {
				ValaExpression* _tmp1050_;
				ValaExpression* _tmp1051_;
				ValaDataType* _tmp1052_;
				ValaDataType* _tmp1053_;
				ValaSemanticAnalyzer* _tmp1054_;
				ValaSemanticAnalyzer* _tmp1055_;
				ValaDataType* _tmp1056_;
				_tmp1050_ = vala_binary_expression_get_right (self);
				_tmp1051_ = _tmp1050_;
				_tmp1052_ = vala_expression_get_value_type (_tmp1051_);
				_tmp1053_ = _tmp1052_;
				_tmp1054_ = vala_code_context_get_analyzer (context);
				_tmp1055_ = _tmp1054_;
				_tmp1056_ = _tmp1055_->bool_type;
				_tmp1042_ = !vala_data_type_compatible (_tmp1053_, _tmp1056_);
			}
			if (_tmp1042_) {
				ValaSourceReference* _tmp1057_;
				ValaSourceReference* _tmp1058_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1057_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1058_ = _tmp1057_;
				vala_report_error (_tmp1058_, "Operands must be boolean");
			}
			_tmp1059_ = vala_binary_expression_get_left (self);
			_tmp1060_ = _tmp1059_;
			_tmp1061_ = vala_expression_get_target_type (_tmp1060_);
			_tmp1062_ = _tmp1061_;
			vala_data_type_set_nullable (_tmp1062_, FALSE);
			_tmp1063_ = vala_binary_expression_get_right (self);
			_tmp1064_ = _tmp1063_;
			_tmp1065_ = vala_expression_get_target_type (_tmp1064_);
			_tmp1066_ = _tmp1065_;
			vala_data_type_set_nullable (_tmp1066_, FALSE);
			_tmp1067_ = vala_code_context_get_analyzer (context);
			_tmp1068_ = _tmp1067_;
			_tmp1069_ = _tmp1068_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1069_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			gboolean _tmp1070_ = FALSE;
			ValaExpression* _tmp1071_;
			ValaExpression* _tmp1072_;
			ValaDataType* _tmp1073_;
			ValaDataType* _tmp1074_;
			ValaSemanticAnalyzer* _tmp1075_;
			ValaSemanticAnalyzer* _tmp1076_;
			ValaDataType* _tmp1077_;
			ValaSemanticAnalyzer* _tmp1181_;
			ValaSemanticAnalyzer* _tmp1182_;
			ValaDataType* _tmp1183_;
			_tmp1071_ = vala_binary_expression_get_left (self);
			_tmp1072_ = _tmp1071_;
			_tmp1073_ = vala_expression_get_value_type (_tmp1072_);
			_tmp1074_ = _tmp1073_;
			_tmp1075_ = vala_code_context_get_analyzer (context);
			_tmp1076_ = _tmp1075_;
			_tmp1077_ = _tmp1076_->int_type;
			if (vala_data_type_compatible (_tmp1074_, _tmp1077_)) {
				ValaExpression* _tmp1078_;
				ValaExpression* _tmp1079_;
				ValaDataType* _tmp1080_;
				ValaDataType* _tmp1081_;
				ValaSemanticAnalyzer* _tmp1082_;
				ValaSemanticAnalyzer* _tmp1083_;
				ValaDataType* _tmp1084_;
				_tmp1078_ = vala_binary_expression_get_right (self);
				_tmp1079_ = _tmp1078_;
				_tmp1080_ = vala_expression_get_value_type (_tmp1079_);
				_tmp1081_ = _tmp1080_;
				_tmp1082_ = vala_code_context_get_analyzer (context);
				_tmp1083_ = _tmp1082_;
				_tmp1084_ = _tmp1083_->int_type;
				_tmp1070_ = vala_data_type_compatible (_tmp1081_, _tmp1084_);
			} else {
				_tmp1070_ = FALSE;
			}
			if (_tmp1070_) {
				ValaExpression* _tmp1085_;
				ValaExpression* _tmp1086_;
				ValaDataType* _tmp1087_;
				ValaDataType* _tmp1088_;
				ValaExpression* _tmp1089_;
				ValaExpression* _tmp1090_;
				ValaDataType* _tmp1091_;
				ValaDataType* _tmp1092_;
				_tmp1085_ = vala_binary_expression_get_left (self);
				_tmp1086_ = _tmp1085_;
				_tmp1087_ = vala_expression_get_target_type (_tmp1086_);
				_tmp1088_ = _tmp1087_;
				vala_data_type_set_nullable (_tmp1088_, FALSE);
				_tmp1089_ = vala_binary_expression_get_right (self);
				_tmp1090_ = _tmp1089_;
				_tmp1091_ = vala_expression_get_target_type (_tmp1090_);
				_tmp1092_ = _tmp1091_;
				vala_data_type_set_nullable (_tmp1092_, FALSE);
			} else {
				ValaExpression* _tmp1093_;
				ValaExpression* _tmp1094_;
				ValaDataType* _tmp1095_;
				ValaDataType* _tmp1096_;
				_tmp1093_ = vala_binary_expression_get_right (self);
				_tmp1094_ = _tmp1093_;
				_tmp1095_ = vala_expression_get_value_type (_tmp1094_);
				_tmp1096_ = _tmp1095_;
				if (VALA_IS_ARRAY_TYPE (_tmp1096_)) {
					ValaExpression* _tmp1097_;
					ValaExpression* _tmp1098_;
					ValaDataType* _tmp1099_;
					ValaDataType* _tmp1100_;
					ValaExpression* _tmp1101_;
					ValaExpression* _tmp1102_;
					ValaDataType* _tmp1103_;
					ValaDataType* _tmp1104_;
					ValaDataType* _tmp1105_;
					ValaDataType* _tmp1106_;
					_tmp1097_ = vala_binary_expression_get_left (self);
					_tmp1098_ = _tmp1097_;
					_tmp1099_ = vala_expression_get_value_type (_tmp1098_);
					_tmp1100_ = _tmp1099_;
					_tmp1101_ = vala_binary_expression_get_right (self);
					_tmp1102_ = _tmp1101_;
					_tmp1103_ = vala_expression_get_value_type (_tmp1102_);
					_tmp1104_ = _tmp1103_;
					_tmp1105_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1104_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp1106_ = _tmp1105_;
					if (!vala_data_type_compatible (_tmp1100_, _tmp1106_)) {
						ValaSourceReference* _tmp1107_;
						ValaSourceReference* _tmp1108_;
						ValaExpression* _tmp1109_;
						ValaExpression* _tmp1110_;
						ValaDataType* _tmp1111_;
						ValaDataType* _tmp1112_;
						gchar* _tmp1113_;
						gchar* _tmp1114_;
						ValaExpression* _tmp1115_;
						ValaExpression* _tmp1116_;
						ValaDataType* _tmp1117_;
						ValaDataType* _tmp1118_;
						gchar* _tmp1119_;
						gchar* _tmp1120_;
						gchar* _tmp1121_;
						gchar* _tmp1122_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1108_ = _tmp1107_;
						_tmp1109_ = vala_binary_expression_get_left (self);
						_tmp1110_ = _tmp1109_;
						_tmp1111_ = vala_expression_get_value_type (_tmp1110_);
						_tmp1112_ = _tmp1111_;
						_tmp1113_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1112_);
						_tmp1114_ = _tmp1113_;
						_tmp1115_ = vala_binary_expression_get_right (self);
						_tmp1116_ = _tmp1115_;
						_tmp1117_ = vala_expression_get_value_type (_tmp1116_);
						_tmp1118_ = _tmp1117_;
						_tmp1119_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1118_);
						_tmp1120_ = _tmp1119_;
						_tmp1121_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp1114_, _tmp1120_);
						_tmp1122_ = _tmp1121_;
						vala_report_error (_tmp1108_, _tmp1122_);
						_g_free0 (_tmp1122_);
						_g_free0 (_tmp1120_);
						_g_free0 (_tmp1114_);
					}
				} else {
					ValaMethod* contains_method = NULL;
					ValaExpression* _tmp1123_;
					ValaExpression* _tmp1124_;
					ValaDataType* _tmp1125_;
					ValaDataType* _tmp1126_;
					ValaSymbol* _tmp1127_;
					ValaMethod* _tmp1128_;
					ValaMethod* _tmp1129_;
					ValaMethod* _tmp1140_;
					ValaList* _tmp1141_;
					gint _tmp1142_;
					gint _tmp1143_;
					ValaMethod* _tmp1151_;
					ValaDataType* _tmp1152_;
					ValaDataType* _tmp1153_;
					ValaSemanticAnalyzer* _tmp1154_;
					ValaSemanticAnalyzer* _tmp1155_;
					ValaDataType* _tmp1156_;
					ValaMethodCall* contains_call = NULL;
					ValaExpression* _tmp1164_;
					ValaExpression* _tmp1165_;
					ValaSourceReference* _tmp1166_;
					ValaSourceReference* _tmp1167_;
					ValaMemberAccess* _tmp1168_;
					ValaMemberAccess* _tmp1169_;
					ValaSourceReference* _tmp1170_;
					ValaSourceReference* _tmp1171_;
					ValaMethodCall* _tmp1172_;
					ValaMethodCall* _tmp1173_;
					ValaMethodCall* _tmp1174_;
					ValaExpression* _tmp1175_;
					ValaExpression* _tmp1176_;
					ValaCodeNode* _tmp1177_;
					ValaCodeNode* _tmp1178_;
					ValaMethodCall* _tmp1179_;
					ValaMethodCall* _tmp1180_;
					_tmp1123_ = vala_binary_expression_get_right (self);
					_tmp1124_ = _tmp1123_;
					_tmp1125_ = vala_expression_get_value_type (_tmp1124_);
					_tmp1126_ = _tmp1125_;
					_tmp1127_ = vala_data_type_get_member (_tmp1126_, "contains");
					_tmp1128_ = VALA_IS_METHOD (_tmp1127_) ? ((ValaMethod*) _tmp1127_) : NULL;
					if (_tmp1128_ == NULL) {
						_vala_code_node_unref0 (_tmp1127_);
					}
					contains_method = _tmp1128_;
					_tmp1129_ = contains_method;
					if (_tmp1129_ == NULL) {
						ValaSourceReference* _tmp1130_;
						ValaSourceReference* _tmp1131_;
						ValaExpression* _tmp1132_;
						ValaExpression* _tmp1133_;
						ValaDataType* _tmp1134_;
						ValaDataType* _tmp1135_;
						gchar* _tmp1136_;
						gchar* _tmp1137_;
						gchar* _tmp1138_;
						gchar* _tmp1139_;
						_tmp1130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1131_ = _tmp1130_;
						_tmp1132_ = vala_binary_expression_get_right (self);
						_tmp1133_ = _tmp1132_;
						_tmp1134_ = vala_expression_get_value_type (_tmp1133_);
						_tmp1135_ = _tmp1134_;
						_tmp1136_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1135_);
						_tmp1137_ = _tmp1136_;
						_tmp1138_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp1137_);
						_tmp1139_ = _tmp1138_;
						vala_report_error (_tmp1131_, _tmp1139_);
						_g_free0 (_tmp1139_);
						_g_free0 (_tmp1137_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1140_ = contains_method;
					_tmp1141_ = vala_callable_get_parameters ((ValaCallable*) _tmp1140_);
					_tmp1142_ = vala_collection_get_size ((ValaCollection*) _tmp1141_);
					_tmp1143_ = _tmp1142_;
					if (_tmp1143_ != 1) {
						ValaSourceReference* _tmp1144_;
						ValaSourceReference* _tmp1145_;
						ValaMethod* _tmp1146_;
						gchar* _tmp1147_;
						gchar* _tmp1148_;
						gchar* _tmp1149_;
						gchar* _tmp1150_;
						_tmp1144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1145_ = _tmp1144_;
						_tmp1146_ = contains_method;
						_tmp1147_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1146_);
						_tmp1148_ = _tmp1147_;
						_tmp1149_ = g_strdup_printf ("`%s' must have one parameter", _tmp1148_);
						_tmp1150_ = _tmp1149_;
						vala_report_error (_tmp1145_, _tmp1150_);
						_g_free0 (_tmp1150_);
						_g_free0 (_tmp1148_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1151_ = contains_method;
					_tmp1152_ = vala_callable_get_return_type ((ValaCallable*) _tmp1151_);
					_tmp1153_ = _tmp1152_;
					_tmp1154_ = vala_code_context_get_analyzer (context);
					_tmp1155_ = _tmp1154_;
					_tmp1156_ = _tmp1155_->bool_type;
					if (!vala_data_type_compatible (_tmp1153_, _tmp1156_)) {
						ValaSourceReference* _tmp1157_;
						ValaSourceReference* _tmp1158_;
						ValaMethod* _tmp1159_;
						gchar* _tmp1160_;
						gchar* _tmp1161_;
						gchar* _tmp1162_;
						gchar* _tmp1163_;
						_tmp1157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1158_ = _tmp1157_;
						_tmp1159_ = contains_method;
						_tmp1160_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1159_);
						_tmp1161_ = _tmp1160_;
						_tmp1162_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1161_);
						_tmp1163_ = _tmp1162_;
						vala_report_error (_tmp1158_, _tmp1163_);
						_g_free0 (_tmp1163_);
						_g_free0 (_tmp1161_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1164_ = vala_binary_expression_get_right (self);
					_tmp1165_ = _tmp1164_;
					_tmp1166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1167_ = _tmp1166_;
					_tmp1168_ = vala_member_access_new (_tmp1165_, "contains", _tmp1167_);
					_tmp1169_ = _tmp1168_;
					_tmp1170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1171_ = _tmp1170_;
					_tmp1172_ = vala_method_call_new ((ValaExpression*) _tmp1169_, _tmp1171_);
					_tmp1173_ = _tmp1172_;
					_vala_code_node_unref0 (_tmp1169_);
					contains_call = _tmp1173_;
					_tmp1174_ = contains_call;
					_tmp1175_ = vala_binary_expression_get_left (self);
					_tmp1176_ = _tmp1175_;
					vala_method_call_add_argument (_tmp1174_, _tmp1176_);
					_tmp1177_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp1178_ = _tmp1177_;
					_tmp1179_ = contains_call;
					vala_code_node_replace_expression (_tmp1178_, (ValaExpression*) self, (ValaExpression*) _tmp1179_);
					_tmp1180_ = contains_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp1180_, context);
					_vala_code_node_unref0 (contains_call);
					_vala_code_node_unref0 (contains_method);
					return result;
				}
			}
			_tmp1181_ = vala_code_context_get_analyzer (context);
			_tmp1182_ = _tmp1181_;
			_tmp1183_ = _tmp1182_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1183_);
			break;
		}
		default:
		{
			ValaSourceReference* _tmp1184_;
			ValaSourceReference* _tmp1185_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1185_ = _tmp1184_;
			vala_report_error (_tmp1185_, "internal error: unsupported binary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp1186_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1187_ = _tmp1186_;
	vala_code_node_check ((ValaCodeNode*) _tmp1187_, context);
	_tmp1188_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1189_ = _tmp1188_;
	result = !_tmp1189_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
static GType
vala_binary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
	GType vala_binary_expression_type_id;
	vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
	ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
	return vala_binary_expression_type_id;
}

GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = vala_binary_expression_get_type_once ();
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_binary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
	GType vala_binary_operator_type_id;
	vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
	return vala_binary_operator_type_id;
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = vala_binary_operator_get_type_once ();
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

