/* dbus.c generated by valac, the Vala compiler
 * generated from dbus.vala, do not modify */

/* doclet.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <valagee.h>
#include <valadoc.h>
#include <glib/gstdio.h>

#define GTKDOC_DBUS_TYPE_PARAMETER (gtkdoc_dbus_parameter_get_type ())
#define GTKDOC_DBUS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter))
#define GTKDOC_DBUS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))
#define GTKDOC_DBUS_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))

typedef struct _GtkdocDBusParameter GtkdocDBusParameter;
typedef struct _GtkdocDBusParameterClass GtkdocDBusParameterClass;
typedef struct _GtkdocDBusParameterPrivate GtkdocDBusParameterPrivate;
typedef enum  {
	GTKDOC_DBUS_PARAMETER_DIRECTION_NONE,
	GTKDOC_DBUS_PARAMETER_DIRECTION_IN,
	GTKDOC_DBUS_PARAMETER_DIRECTION_OUT
} GtkdocDBusParameterDirection;

#define GTKDOC_DBUS_PARAMETER_TYPE_DIRECTION (gtkdoc_dbus_parameter_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocDBusParamSpecParameter GtkdocDBusParamSpecParameter;

#define GTKDOC_DBUS_TYPE_MEMBER (gtkdoc_dbus_member_get_type ())
#define GTKDOC_DBUS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember))
#define GTKDOC_DBUS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))
#define GTKDOC_DBUS_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))

typedef struct _GtkdocDBusMember GtkdocDBusMember;
typedef struct _GtkdocDBusMemberClass GtkdocDBusMemberClass;
typedef struct _GtkdocDBusMemberPrivate GtkdocDBusMemberPrivate;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;

#define GTKDOC_DBUS_TYPE_INTERFACE (gtkdoc_dbus_interface_get_type ())
#define GTKDOC_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface))
#define GTKDOC_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))
#define GTKDOC_DBUS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))

typedef struct _GtkdocDBusInterface GtkdocDBusInterface;
typedef struct _GtkdocDBusInterfaceClass GtkdocDBusInterfaceClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_gcomment_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_gcomment_unref (var), NULL)))
#define _gtkdoc_dbus_interface_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_interface_unref (var), NULL)))
#define _gtkdoc_dbus_parameter_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_parameter_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocDBusParamSpecMember GtkdocDBusParamSpecMember;
typedef struct _GtkdocDBusInterfacePrivate GtkdocDBusInterfacePrivate;

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
#define _gtkdoc_text_writer_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_text_writer_unref (var), NULL)))
#define _gtkdoc_dbus_member_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_member_unref (var), NULL)))
typedef struct _GtkdocDBusParamSpecInterface GtkdocDBusParamSpecInterface;

struct _GtkdocDBusParameter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar* signature;
	GtkdocDBusParameterDirection direction;
	GtkdocDBusParameterPrivate * priv;
};

struct _GtkdocDBusParameterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusParameter *self);
};

struct _GtkdocDBusParamSpecParameter {
	GParamSpec parent_instance;
};

struct _GtkdocDBusMember {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	ValaList* parameters;
	GtkdocGComment* comment;
	GtkdocDBusInterface* iface;
	GtkdocDBusMemberPrivate * priv;
};

struct _GtkdocDBusMemberClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusMember *self);
};

struct _GtkdocDBusParamSpecMember {
	GParamSpec parent_instance;
};

struct _GtkdocDBusInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* package_name;
	gchar* name;
	gchar* purpose;
	gchar* description;
	ValaList* methods;
	ValaList* signals;
	GtkdocDBusInterfacePrivate * priv;
};

struct _GtkdocDBusInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusInterface *self);
};

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* filename;
	gchar* mode;
	GtkdocTextWriterPrivate * priv;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocDBusParamSpecInterface {
	GParamSpec parent_instance;
};

static gpointer gtkdoc_dbus_parameter_parent_class = NULL;
static gpointer gtkdoc_dbus_member_parent_class = NULL;
static gpointer gtkdoc_dbus_interface_parent_class = NULL;

gpointer gtkdoc_dbus_parameter_ref (gpointer instance);
void gtkdoc_dbus_parameter_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_parameter (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_parameter (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_parameter (const GValue* value);
GType gtkdoc_dbus_parameter_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusParameter, gtkdoc_dbus_parameter_unref)
GType gtkdoc_dbus_parameter_direction_get_type (void) G_GNUC_CONST;
const gchar* gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self);
GtkdocDBusParameter* gtkdoc_dbus_parameter_new (const gchar* name,
                                                const gchar* signature,
                                                GtkdocDBusParameterDirection direction);
GtkdocDBusParameter* gtkdoc_dbus_parameter_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* signature,
                                                      GtkdocDBusParameterDirection direction);
gchar* gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self);
static void gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj);
static GType gtkdoc_dbus_parameter_get_type_once (void);
gpointer gtkdoc_dbus_member_ref (gpointer instance);
void gtkdoc_dbus_member_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_member (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_dbus_value_set_member (GValue* value,
                                   gpointer v_object);
void gtkdoc_dbus_value_take_member (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_dbus_value_get_member (const GValue* value);
GType gtkdoc_dbus_member_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusMember, gtkdoc_dbus_member_unref)
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGComment, gtkdoc_gcomment_unref)
gpointer gtkdoc_dbus_interface_ref (gpointer instance);
void gtkdoc_dbus_interface_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_interface (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_interface (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_interface (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_interface (const GValue* value);
GType gtkdoc_dbus_interface_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusInterface, gtkdoc_dbus_interface_unref)
GtkdocDBusMember* gtkdoc_dbus_member_new (const gchar* name);
GtkdocDBusMember* gtkdoc_dbus_member_construct (GType object_type,
                                                const gchar* name);
void gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                       GtkdocDBusParameter* parameter);
gchar* gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self);
gchar* gtkdoc_to_docbook_id (const gchar* name);
gchar* gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                                     gint indent,
                                     gboolean link);
gchar* gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self);
static void gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj);
static GType gtkdoc_dbus_member_get_type_once (void);
GtkdocDBusInterface* gtkdoc_dbus_interface_new (const gchar* package_name,
                                                const gchar* name,
                                                const gchar* purpose,
                                                const gchar* description);
GtkdocDBusInterface* gtkdoc_dbus_interface_construct (GType object_type,
                                                      const gchar* package_name,
                                                      const gchar* name,
                                                      const gchar* purpose,
                                                      const gchar* description);
void gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
void gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
gboolean gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                                      ValadocSettings* settings,
                                      ValadocErrorReporter* reporter);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value,
                                   gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocTextWriter, gtkdoc_text_writer_unref)
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename,
                                          const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type,
                                                const gchar* filename,
                                                const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                                    const gchar* line);
gchar* gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                        ValadocErrorReporter* reporter);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
static void gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj);
static GType gtkdoc_dbus_interface_get_type_once (void);

const gchar*
gtkdoc_dbus_parameter_direction_to_string (GtkdocDBusParameterDirection self)
{
	const gchar* result = NULL;
	switch (self) {
		case GTKDOC_DBUS_PARAMETER_DIRECTION_NONE:
		{
			result = "";
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_IN:
		{
			result = "in";
			return result;
		}
		case GTKDOC_DBUS_PARAMETER_DIRECTION_OUT:
		{
			result = "out";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
gtkdoc_dbus_parameter_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{GTKDOC_DBUS_PARAMETER_DIRECTION_NONE, "GTKDOC_DBUS_PARAMETER_DIRECTION_NONE", "none"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_IN, "GTKDOC_DBUS_PARAMETER_DIRECTION_IN", "in"}, {GTKDOC_DBUS_PARAMETER_DIRECTION_OUT, "GTKDOC_DBUS_PARAMETER_DIRECTION_OUT", "out"}, {0, NULL, NULL}};
	GType gtkdoc_dbus_parameter_direction_type_id;
	gtkdoc_dbus_parameter_direction_type_id = g_enum_register_static ("GtkdocDBusParameterDirection", values);
	return gtkdoc_dbus_parameter_direction_type_id;
}

GType
gtkdoc_dbus_parameter_direction_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_direction_type_id__volatile)) {
		GType gtkdoc_dbus_parameter_direction_type_id;
		gtkdoc_dbus_parameter_direction_type_id = gtkdoc_dbus_parameter_direction_get_type_once ();
		g_once_init_leave (&gtkdoc_dbus_parameter_direction_type_id__volatile, gtkdoc_dbus_parameter_direction_type_id);
	}
	return gtkdoc_dbus_parameter_direction_type_id__volatile;
}

GtkdocDBusParameter*
gtkdoc_dbus_parameter_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* signature,
                                 GtkdocDBusParameterDirection direction)
{
	GtkdocDBusParameter* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	self = (GtkdocDBusParameter*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (signature);
	_g_free0 (self->signature);
	self->signature = _tmp1_;
	self->direction = direction;
	return self;
}

GtkdocDBusParameter*
gtkdoc_dbus_parameter_new (const gchar* name,
                           const gchar* signature,
                           GtkdocDBusParameterDirection direction)
{
	return gtkdoc_dbus_parameter_construct (GTKDOC_DBUS_TYPE_PARAMETER, name, signature, direction);
}

gchar*
gtkdoc_dbus_parameter_to_string (GtkdocDBusParameter* self)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->direction == GTKDOC_DBUS_PARAMETER_DIRECTION_NONE) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->signature;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup_printf ("<parameter><type>'%s'</type> %s</parameter>", _tmp0_, _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = gtkdoc_dbus_parameter_direction_to_string (self->direction);
		_tmp4_ = self->signature;
		_tmp5_ = self->name;
		_tmp6_ = g_strdup_printf ("<parameter>%s <type>'%s'</type> %s</parameter>", _tmp3_, _tmp4_, _tmp5_);
		result = _tmp6_;
		return result;
	}
}

static void
gtkdoc_dbus_value_parameter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_parameter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_parameter_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_parameter_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_parameter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_parameter_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusParameter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_parameter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_parameter_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusParameter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecParameter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_parameter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_parameter (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_parameter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}

void
gtkdoc_dbus_value_take_parameter (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusParameter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_PARAMETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_PARAMETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_parameter_unref (old);
	}
}

static void
gtkdoc_dbus_parameter_class_init (GtkdocDBusParameterClass * klass,
                                  gpointer klass_data)
{
	gtkdoc_dbus_parameter_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusParameterClass *) klass)->finalize = gtkdoc_dbus_parameter_finalize;
}

static void
gtkdoc_dbus_parameter_instance_init (GtkdocDBusParameter * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_dbus_parameter_finalize (GtkdocDBusParameter * obj)
{
	GtkdocDBusParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->signature);
}

static GType
gtkdoc_dbus_parameter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_parameter_init, gtkdoc_dbus_value_parameter_free_value, gtkdoc_dbus_value_parameter_copy_value, gtkdoc_dbus_value_parameter_peek_pointer, "p", gtkdoc_dbus_value_parameter_collect_value, "p", gtkdoc_dbus_value_parameter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusParameter), 0, (GInstanceInitFunc) gtkdoc_dbus_parameter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_dbus_parameter_type_id;
	gtkdoc_dbus_parameter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusParameter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_dbus_parameter_type_id;
}

GType
gtkdoc_dbus_parameter_get_type (void)
{
	static volatile gsize gtkdoc_dbus_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_parameter_type_id__volatile)) {
		GType gtkdoc_dbus_parameter_type_id;
		gtkdoc_dbus_parameter_type_id = gtkdoc_dbus_parameter_get_type_once ();
		g_once_init_leave (&gtkdoc_dbus_parameter_type_id__volatile, gtkdoc_dbus_parameter_type_id);
	}
	return gtkdoc_dbus_parameter_type_id__volatile;
}

gpointer
gtkdoc_dbus_parameter_ref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_parameter_unref (gpointer instance)
{
	GtkdocDBusParameter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_PARAMETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GtkdocDBusMember*
gtkdoc_dbus_member_construct (GType object_type,
                              const gchar* name)
{
	GtkdocDBusMember* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocDBusMember*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

GtkdocDBusMember*
gtkdoc_dbus_member_new (const gchar* name)
{
	return gtkdoc_dbus_member_construct (GTKDOC_DBUS_TYPE_MEMBER, name);
}

void
gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                  GtkdocDBusParameter* parameter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	_tmp0_ = self->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, parameter);
}

gchar*
gtkdoc_dbus_member_get_docbook_id (GtkdocDBusMember* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
gtkdoc_dbus_member_to_string (GtkdocDBusMember* self,
                              gint indent,
                              gboolean link)
{
	GString* builder = NULL;
	GString* _tmp0_;
	ValaList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GString* _tmp44_;
	GString* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (link) {
		GString* _tmp1_;
		GtkdocDBusInterface* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = builder;
		_tmp2_ = self->iface;
		_tmp3_ = gtkdoc_dbus_interface_get_docbook_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtkdoc_dbus_member_get_docbook_id (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = self->name;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strnfill ((gsize) (indent - _tmp10_), ' ');
		_tmp12_ = _tmp11_;
		g_string_append_printf (_tmp1_, "\n<link linkend=\"%s-%s\">%s</link>%s(", _tmp4_, _tmp6_, _tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		GString* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = builder;
		_tmp14_ = self->name;
		_tmp15_ = self->name;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strnfill ((gsize) (indent - _tmp17_), ' ');
		_tmp19_ = _tmp18_;
		g_string_append_printf (_tmp13_, "\n%s%s(", _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->parameters;
	_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		GString* _tmp23_;
		ValaList* _tmp24_;
		gpointer _tmp25_;
		GtkdocDBusParameter* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = builder;
		_tmp24_ = self->parameters;
		_tmp25_ = vala_list_get (_tmp24_, 0);
		_tmp26_ = (GtkdocDBusParameter*) _tmp25_;
		_tmp27_ = gtkdoc_dbus_parameter_to_string (_tmp26_);
		_tmp28_ = _tmp27_;
		g_string_append (_tmp23_, _tmp28_);
		_g_free0 (_tmp28_);
		_gtkdoc_dbus_parameter_unref0 (_tmp26_);
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				GString* _tmp34_;
				GString* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GString* _tmp38_;
				ValaList* _tmp39_;
				gpointer _tmp40_;
				GtkdocDBusParameter* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = self->parameters;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				if (!(i < _tmp33_)) {
					break;
				}
				_tmp34_ = builder;
				g_string_append (_tmp34_, ",\n");
				_tmp35_ = builder;
				_tmp36_ = g_strnfill ((gsize) (indent + 1), ' ');
				_tmp37_ = _tmp36_;
				g_string_append (_tmp35_, _tmp37_);
				_g_free0 (_tmp37_);
				_tmp38_ = builder;
				_tmp39_ = self->parameters;
				_tmp40_ = vala_list_get (_tmp39_, i);
				_tmp41_ = (GtkdocDBusParameter*) _tmp40_;
				_tmp42_ = gtkdoc_dbus_parameter_to_string (_tmp41_);
				_tmp43_ = _tmp42_;
				g_string_append (_tmp38_, _tmp43_);
				_g_free0 (_tmp43_);
				_gtkdoc_dbus_parameter_unref0 (_tmp41_);
			}
		}
	}
	_tmp44_ = builder;
	g_string_append_c (_tmp44_, ')');
	_tmp45_ = builder;
	_tmp46_ = _tmp45_->str;
	_tmp47_ = g_strdup (_tmp46_);
	result = _tmp47_;
	_g_string_free0 (builder);
	return result;
}

static void
gtkdoc_dbus_value_member_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_member_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_member_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_member_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_member_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_member_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_member_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusMember * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_member_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_member_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GtkdocDBusMember ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_member (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GtkdocDBusParamSpecMember* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_member (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_member (GValue* value,
                              gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_member_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}

void
gtkdoc_dbus_value_take_member (GValue* value,
                               gpointer v_object)
{
	GtkdocDBusMember * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_MEMBER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_MEMBER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_member_unref (old);
	}
}

static void
gtkdoc_dbus_member_class_init (GtkdocDBusMemberClass * klass,
                               gpointer klass_data)
{
	gtkdoc_dbus_member_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusMemberClass *) klass)->finalize = gtkdoc_dbus_member_finalize;
}

static void
gtkdoc_dbus_member_instance_init (GtkdocDBusMember * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_PARAMETER, (GBoxedCopyFunc) gtkdoc_dbus_parameter_ref, (GDestroyNotify) gtkdoc_dbus_parameter_unref, _tmp0_);
	self->parameters = (ValaList*) _tmp1_;
	self->ref_count = 1;
}

static void
gtkdoc_dbus_member_finalize (GtkdocDBusMember * obj)
{
	GtkdocDBusMember * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_vala_iterable_unref0 (self->parameters);
	_gtkdoc_gcomment_unref0 (self->comment);
	_gtkdoc_dbus_interface_unref0 (self->iface);
}

static GType
gtkdoc_dbus_member_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_member_init, gtkdoc_dbus_value_member_free_value, gtkdoc_dbus_value_member_copy_value, gtkdoc_dbus_value_member_peek_pointer, "p", gtkdoc_dbus_value_member_collect_value, "p", gtkdoc_dbus_value_member_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusMemberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_member_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusMember), 0, (GInstanceInitFunc) gtkdoc_dbus_member_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_dbus_member_type_id;
	gtkdoc_dbus_member_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusMember", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_dbus_member_type_id;
}

GType
gtkdoc_dbus_member_get_type (void)
{
	static volatile gsize gtkdoc_dbus_member_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_member_type_id__volatile)) {
		GType gtkdoc_dbus_member_type_id;
		gtkdoc_dbus_member_type_id = gtkdoc_dbus_member_get_type_once ();
		g_once_init_leave (&gtkdoc_dbus_member_type_id__volatile, gtkdoc_dbus_member_type_id);
	}
	return gtkdoc_dbus_member_type_id__volatile;
}

gpointer
gtkdoc_dbus_member_ref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_member_unref (gpointer instance)
{
	GtkdocDBusMember * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_MEMBER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GtkdocDBusInterface*
gtkdoc_dbus_interface_construct (GType object_type,
                                 const gchar* package_name,
                                 const gchar* name,
                                 const gchar* purpose,
                                 const gchar* description)
{
	GtkdocDBusInterface* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (package_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (purpose != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (GtkdocDBusInterface*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (package_name);
	_g_free0 (self->package_name);
	self->package_name = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = g_strdup (purpose);
	_g_free0 (self->purpose);
	self->purpose = _tmp2_;
	_tmp3_ = g_strdup (description);
	_g_free0 (self->description);
	self->description = _tmp3_;
	return self;
}

GtkdocDBusInterface*
gtkdoc_dbus_interface_new (const gchar* package_name,
                           const gchar* name,
                           const gchar* purpose,
                           const gchar* description)
{
	return gtkdoc_dbus_interface_construct (GTKDOC_DBUS_TYPE_INTERFACE, package_name, name, purpose, description);
}

static gpointer
_gtkdoc_dbus_interface_ref0 (gpointer self)
{
	return self ? gtkdoc_dbus_interface_ref (self) : NULL;
}

void
gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->methods;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}

void
gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                  GtkdocDBusMember* member)
{
	GtkdocDBusInterface* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (member != NULL);
	_tmp0_ = _gtkdoc_dbus_interface_ref0 (self);
	_gtkdoc_dbus_interface_unref0 (member->iface);
	member->iface = _tmp0_;
	_tmp1_ = self->signals;
	vala_collection_add ((ValaCollection*) _tmp1_, member);
}

gchar*
gtkdoc_dbus_interface_get_docbook_id (GtkdocDBusInterface* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = gtkdoc_to_docbook_id (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                             ValadocSettings* settings,
                             ValadocErrorReporter* reporter)
{
	gchar* xml_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* xml_file = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkdocTextWriter* writer = NULL;
	const gchar* _tmp11_;
	GtkdocTextWriter* _tmp12_;
	GtkdocTextWriter* _tmp13_;
	GtkdocTextWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkdocTextWriter* _tmp19_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = settings->path;
	_tmp1_ = g_build_filename (_tmp0_, "xml", NULL);
	xml_dir = _tmp1_;
	_tmp2_ = xml_dir;
	g_mkdir_with_parents (_tmp2_, 0777);
	_tmp3_ = xml_dir;
	_tmp4_ = self->name;
	_tmp5_ = gtkdoc_to_docbook_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s.xml", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp3_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	xml_file = _tmp10_;
	_tmp11_ = xml_file;
	_tmp12_ = gtkdoc_text_writer_new (_tmp11_, "w");
	writer = _tmp12_;
	_tmp13_ = writer;
	if (!gtkdoc_text_writer_open (_tmp13_)) {
		GtkdocTextWriter* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = writer;
		_tmp15_ = _tmp14_->filename;
		valadoc_error_reporter_simple_error (reporter, "GtkDoc", "unable to open '%s' for writing", _tmp15_);
		result = FALSE;
		_gtkdoc_text_writer_unref0 (writer);
		_g_free0 (xml_file);
		_g_free0 (xml_dir);
		return result;
	}
	_tmp16_ = writer;
	_tmp17_ = gtkdoc_dbus_interface_to_string (self, reporter);
	_tmp18_ = _tmp17_;
	gtkdoc_text_writer_write_line (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = writer;
	gtkdoc_text_writer_close (_tmp19_);
	result = TRUE;
	_gtkdoc_text_writer_unref0 (writer);
	_g_free0 (xml_file);
	_g_free0 (xml_dir);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

gchar*
gtkdoc_dbus_interface_to_string (GtkdocDBusInterface* self,
                                 ValadocErrorReporter* reporter)
{
	gint method_indent = 0;
	gint signal_indent = 0;
	GString* builder = NULL;
	GString* _tmp26_;
	gchar* docbook_id = NULL;
	gchar* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	ValaList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	ValaList* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GString* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	ValaList* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	ValaList* _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	GString* _tmp144_;
	GString* _tmp145_;
	const gchar* _tmp146_;
	gchar* _tmp147_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	method_indent = 0;
	{
		ValaList* _method_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _method_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _method_index = 0;
		_tmp0_ = self->methods;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_method_list = _tmp1_;
		_tmp2_ = _method_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_method_size = _tmp4_;
		_method_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GtkdocDBusMember* method = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			GtkdocDBusMember* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_method_index = _method_index + 1;
			_tmp5_ = _method_index;
			_tmp6_ = _method_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _method_list;
			_tmp8_ = vala_list_get (_tmp7_, _method_index);
			method = (GtkdocDBusMember*) _tmp8_;
			_tmp9_ = method;
			_tmp10_ = _tmp9_->name;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			method_indent = MAX (method_indent, (gint) _tmp12_);
			_gtkdoc_dbus_member_unref0 (method);
		}
		_vala_iterable_unref0 (_method_list);
	}
	method_indent += 5;
	signal_indent = 0;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _sig_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _sig_index = 0;
		_tmp13_ = self->signals;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_sig_list = _tmp14_;
		_tmp15_ = _sig_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_sig_size = _tmp17_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			GtkdocDBusMember* sig = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GtkdocDBusMember* _tmp22_;
			const gchar* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_sig_index = _sig_index + 1;
			_tmp18_ = _sig_index;
			_tmp19_ = _sig_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _sig_list;
			_tmp21_ = vala_list_get (_tmp20_, _sig_index);
			sig = (GtkdocDBusMember*) _tmp21_;
			_tmp22_ = sig;
			_tmp23_ = _tmp22_->name;
			_tmp24_ = strlen (_tmp23_);
			_tmp25_ = _tmp24_;
			signal_indent = MAX (signal_indent, (gint) _tmp25_);
			_gtkdoc_dbus_member_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	signal_indent += 5;
	_tmp26_ = g_string_new ("");
	builder = _tmp26_;
	_tmp27_ = gtkdoc_dbus_interface_get_docbook_id (self);
	docbook_id = _tmp27_;
	_tmp28_ = builder;
	g_string_append (_tmp28_, "<?xml version=\"1.0\"?><!DOCTYPE refentry PUBLIC \"-//OASIS//DTD DocBo" \
"ok XML V4.3//EN\" \"http://www.oasis-open.org/docbook/xml/4.3/docbookx" \
".dtd\"");
	_tmp30_ = self->purpose;
	_tmp29_ = _tmp30_;
	if (_tmp29_ == NULL) {
		_tmp29_ = "";
	}
	_tmp31_ = builder;
	_tmp32_ = docbook_id;
	_tmp33_ = docbook_id;
	_tmp34_ = self->name;
	_tmp35_ = self->package_name;
	_tmp36_ = g_ascii_strup (_tmp35_, (gssize) -1);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->name;
	g_string_append_printf (_tmp31_, "\n" \
"[<!ENTITY %% local.common.attrib \"xmlns:xi  CDATA  #FIXED 'http://www" \
".w3.org/2003/XInclude'\">]>\n" \
"<refentry id=\"docs-%s\">\n" \
"<refmeta>\n" \
"<refentrytitle role=\"top_of_page\" id=\"docs-%s.top_of_page\">%s</ref" \
"entrytitle>\n" \
"<manvolnum>3</manvolnum>\n" \
"<refmiscinfo>\n" \
"%s D-Bus API\n" \
"</refmiscinfo>\n" \
"</refmeta>\n" \
"<refnamediv>\n" \
"<refname>%s</refname>\n" \
"<refpurpose>%s</refpurpose>\n" \
"</refnamediv>", _tmp32_, _tmp33_, _tmp34_, _tmp37_, _tmp38_, _tmp29_);
	_g_free0 (_tmp37_);
	_tmp39_ = self->methods;
	_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ > 0) {
		GString* _tmp42_;
		const gchar* _tmp43_;
		GString* _tmp57_;
		_tmp42_ = builder;
		_tmp43_ = docbook_id;
		g_string_append_printf (_tmp42_, "\n" \
"<refsynopsisdiv id=\"docs-%s.synopsis\" role=\"synopsis\">\n" \
"<title role=\"synopsis.title\">Methods</title>\n" \
"<synopsis>", _tmp43_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			gint _method_size = 0;
			ValaList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _method_index = 0;
			_tmp44_ = self->methods;
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_method_list = _tmp45_;
			_tmp46_ = _method_list;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_method_size = _tmp48_;
			_method_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				GString* _tmp53_;
				GtkdocDBusMember* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				_method_index = _method_index + 1;
				_tmp49_ = _method_index;
				_tmp50_ = _method_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _method_list;
				_tmp52_ = vala_list_get (_tmp51_, _method_index);
				method = (GtkdocDBusMember*) _tmp52_;
				_tmp53_ = builder;
				_tmp54_ = method;
				_tmp55_ = gtkdoc_dbus_member_to_string (_tmp54_, method_indent, TRUE);
				_tmp56_ = _tmp55_;
				g_string_append (_tmp53_, _tmp56_);
				_g_free0 (_tmp56_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp57_ = builder;
		g_string_append (_tmp57_, "</synopsis></refsynopsisdiv>");
	}
	_tmp58_ = self->signals;
	_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ > 0) {
		GString* _tmp61_;
		const gchar* _tmp62_;
		GString* _tmp76_;
		_tmp61_ = builder;
		_tmp62_ = docbook_id;
		g_string_append_printf (_tmp61_, "\n" \
"<refsynopsisdiv id=\"docs-%s.signals\" role=\"signal_proto\">\n" \
"<title role=\"signal_proto.title\">Signals</title>\n" \
"<synopsis>", _tmp62_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp63_;
			ValaList* _tmp64_;
			gint _sig_size = 0;
			ValaList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			gint _sig_index = 0;
			_tmp63_ = self->signals;
			_tmp64_ = _vala_iterable_ref0 (_tmp63_);
			_sig_list = _tmp64_;
			_tmp65_ = _sig_list;
			_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			_sig_size = _tmp67_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp68_;
				gint _tmp69_;
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp70_;
				gpointer _tmp71_;
				GString* _tmp72_;
				GtkdocDBusMember* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				_sig_index = _sig_index + 1;
				_tmp68_ = _sig_index;
				_tmp69_ = _sig_size;
				if (!(_tmp68_ < _tmp69_)) {
					break;
				}
				_tmp70_ = _sig_list;
				_tmp71_ = vala_list_get (_tmp70_, _sig_index);
				sig = (GtkdocDBusMember*) _tmp71_;
				_tmp72_ = builder;
				_tmp73_ = sig;
				_tmp74_ = gtkdoc_dbus_member_to_string (_tmp73_, signal_indent, TRUE);
				_tmp75_ = _tmp74_;
				g_string_append (_tmp72_, _tmp75_);
				_g_free0 (_tmp75_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp76_ = builder;
		g_string_append (_tmp76_, "</synopsis></refsynopsisdiv>");
	}
	_tmp77_ = builder;
	_tmp78_ = docbook_id;
	_tmp79_ = self->description;
	g_string_append_printf (_tmp77_, "\n" \
"<refsect1 id=\"docs-%s.description\" role=\"desc\">\n" \
"<title role=\"desc.title\">Description</title>\n" \
"%s\n" \
"</refsect1>", _tmp78_, _tmp79_);
	_tmp80_ = self->methods;
	_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ > 0) {
		GString* _tmp83_;
		const gchar* _tmp84_;
		GString* _tmp111_;
		_tmp83_ = builder;
		_tmp84_ = docbook_id;
		g_string_append_printf (_tmp83_, "\n" \
"<refsect1 id=\"docs-%s.details\" role=\"details\">\n" \
"<title role=\"details.title\">Details</title>", _tmp84_);
		{
			ValaList* _method_list = NULL;
			ValaList* _tmp85_;
			ValaList* _tmp86_;
			gint _method_size = 0;
			ValaList* _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
			gint _method_index = 0;
			_tmp85_ = self->methods;
			_tmp86_ = _vala_iterable_ref0 (_tmp85_);
			_method_list = _tmp86_;
			_tmp87_ = _method_list;
			_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
			_tmp89_ = _tmp88_;
			_method_size = _tmp89_;
			_method_index = -1;
			while (TRUE) {
				gint _tmp90_;
				gint _tmp91_;
				GtkdocDBusMember* method = NULL;
				ValaList* _tmp92_;
				gpointer _tmp93_;
				gchar* _tmp94_ = NULL;
				GtkdocDBusMember* _tmp95_;
				GtkdocGComment* _tmp96_;
				GString* _tmp101_;
				const gchar* _tmp102_;
				GtkdocDBusMember* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				GtkdocDBusMember* _tmp106_;
				const gchar* _tmp107_;
				GtkdocDBusMember* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				_method_index = _method_index + 1;
				_tmp90_ = _method_index;
				_tmp91_ = _method_size;
				if (!(_tmp90_ < _tmp91_)) {
					break;
				}
				_tmp92_ = _method_list;
				_tmp93_ = vala_list_get (_tmp92_, _method_index);
				method = (GtkdocDBusMember*) _tmp93_;
				_tmp95_ = method;
				_tmp96_ = _tmp95_->comment;
				if (_tmp96_ != NULL) {
					GtkdocDBusMember* _tmp97_;
					GtkdocGComment* _tmp98_;
					gchar* _tmp99_;
					_tmp97_ = method;
					_tmp98_ = _tmp97_->comment;
					_tmp99_ = gtkdoc_gcomment_to_docbook (_tmp98_, reporter);
					_g_free0 (_tmp94_);
					_tmp94_ = _tmp99_;
				} else {
					gchar* _tmp100_;
					_tmp100_ = g_strdup ("");
					_g_free0 (_tmp94_);
					_tmp94_ = _tmp100_;
				}
				_tmp101_ = builder;
				_tmp102_ = docbook_id;
				_tmp103_ = method;
				_tmp104_ = gtkdoc_dbus_member_get_docbook_id (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = method;
				_tmp107_ = _tmp106_->name;
				_tmp108_ = method;
				_tmp109_ = gtkdoc_dbus_member_to_string (_tmp108_, method_indent, FALSE);
				_tmp110_ = _tmp109_;
				g_string_append_printf (_tmp101_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"function\">\n" \
"<title>%s ()</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp102_, _tmp105_, _tmp107_, _tmp110_, _tmp94_);
				_g_free0 (_tmp110_);
				_g_free0 (_tmp105_);
				_g_free0 (_tmp94_);
				_gtkdoc_dbus_member_unref0 (method);
			}
			_vala_iterable_unref0 (_method_list);
		}
		_tmp111_ = builder;
		g_string_append (_tmp111_, "</refsect1>");
	}
	_tmp112_ = self->signals;
	_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
	_tmp114_ = _tmp113_;
	if (_tmp114_ > 0) {
		GString* _tmp115_;
		const gchar* _tmp116_;
		GString* _tmp143_;
		_tmp115_ = builder;
		_tmp116_ = docbook_id;
		g_string_append_printf (_tmp115_, "\n" \
"<refsect1 id=\"docs-%s.signal-details\" role=\"signals\">\n" \
"<title role=\"signals.title\">Signal Details</title>", _tmp116_);
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp117_;
			ValaList* _tmp118_;
			gint _sig_size = 0;
			ValaList* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			gint _sig_index = 0;
			_tmp117_ = self->signals;
			_tmp118_ = _vala_iterable_ref0 (_tmp117_);
			_sig_list = _tmp118_;
			_tmp119_ = _sig_list;
			_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
			_tmp121_ = _tmp120_;
			_sig_size = _tmp121_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp122_;
				gint _tmp123_;
				GtkdocDBusMember* sig = NULL;
				ValaList* _tmp124_;
				gpointer _tmp125_;
				gchar* _tmp126_ = NULL;
				GtkdocDBusMember* _tmp127_;
				GtkdocGComment* _tmp128_;
				GString* _tmp133_;
				const gchar* _tmp134_;
				GtkdocDBusMember* _tmp135_;
				gchar* _tmp136_;
				gchar* _tmp137_;
				GtkdocDBusMember* _tmp138_;
				const gchar* _tmp139_;
				GtkdocDBusMember* _tmp140_;
				gchar* _tmp141_;
				gchar* _tmp142_;
				_sig_index = _sig_index + 1;
				_tmp122_ = _sig_index;
				_tmp123_ = _sig_size;
				if (!(_tmp122_ < _tmp123_)) {
					break;
				}
				_tmp124_ = _sig_list;
				_tmp125_ = vala_list_get (_tmp124_, _sig_index);
				sig = (GtkdocDBusMember*) _tmp125_;
				_tmp127_ = sig;
				_tmp128_ = _tmp127_->comment;
				if (_tmp128_ != NULL) {
					GtkdocDBusMember* _tmp129_;
					GtkdocGComment* _tmp130_;
					gchar* _tmp131_;
					_tmp129_ = sig;
					_tmp130_ = _tmp129_->comment;
					_tmp131_ = gtkdoc_gcomment_to_docbook (_tmp130_, reporter);
					_g_free0 (_tmp126_);
					_tmp126_ = _tmp131_;
				} else {
					gchar* _tmp132_;
					_tmp132_ = g_strdup ("");
					_g_free0 (_tmp126_);
					_tmp126_ = _tmp132_;
				}
				_tmp133_ = builder;
				_tmp134_ = docbook_id;
				_tmp135_ = sig;
				_tmp136_ = gtkdoc_dbus_member_get_docbook_id (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = sig;
				_tmp139_ = _tmp138_->name;
				_tmp140_ = sig;
				_tmp141_ = gtkdoc_dbus_member_to_string (_tmp140_, signal_indent, FALSE);
				_tmp142_ = _tmp141_;
				g_string_append_printf (_tmp133_, "\n" \
"<refsect2 id=\"%s-%s\" role=\"signal\">\n" \
"<title>The <literal>%s</literal> signal</title>\n" \
"<programlisting>%s\n" \
"</programlisting>\n" \
"%s\n" \
"</refsect2>", _tmp134_, _tmp137_, _tmp139_, _tmp142_, _tmp126_);
				_g_free0 (_tmp142_);
				_g_free0 (_tmp137_);
				_g_free0 (_tmp126_);
				_gtkdoc_dbus_member_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp143_ = builder;
		g_string_append (_tmp143_, "</refsect1>");
	}
	_tmp144_ = builder;
	g_string_append (_tmp144_, "</refentry>");
	_tmp145_ = builder;
	_tmp146_ = _tmp145_->str;
	_tmp147_ = g_strdup (_tmp146_);
	result = _tmp147_;
	_g_free0 (docbook_id);
	_g_string_free0 (builder);
	return result;
}

static void
gtkdoc_dbus_value_interface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_dbus_value_interface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_dbus_interface_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_dbus_value_interface_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_dbus_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_dbus_value_interface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_dbus_value_interface_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocDBusInterface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_dbus_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_dbus_value_interface_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GtkdocDBusInterface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_dbus_param_spec_interface (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GtkdocDBusParamSpecInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_dbus_value_get_interface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_dbus_value_set_interface (GValue* value,
                                 gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_dbus_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}

void
gtkdoc_dbus_value_take_interface (GValue* value,
                                  gpointer v_object)
{
	GtkdocDBusInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_DBUS_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_DBUS_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_dbus_interface_unref (old);
	}
}

static void
gtkdoc_dbus_interface_class_init (GtkdocDBusInterfaceClass * klass,
                                  gpointer klass_data)
{
	gtkdoc_dbus_interface_parent_class = g_type_class_peek_parent (klass);
	((GtkdocDBusInterfaceClass *) klass)->finalize = gtkdoc_dbus_interface_finalize;
}

static void
gtkdoc_dbus_interface_instance_init (GtkdocDBusInterface * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp0_);
	self->methods = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_DBUS_TYPE_MEMBER, (GBoxedCopyFunc) gtkdoc_dbus_member_ref, (GDestroyNotify) gtkdoc_dbus_member_unref, _tmp2_);
	self->signals = (ValaList*) _tmp3_;
	self->ref_count = 1;
}

static void
gtkdoc_dbus_interface_finalize (GtkdocDBusInterface * obj)
{
	GtkdocDBusInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface);
	g_signal_handlers_destroy (self);
	_g_free0 (self->package_name);
	_g_free0 (self->name);
	_g_free0 (self->purpose);
	_g_free0 (self->description);
	_vala_iterable_unref0 (self->methods);
	_vala_iterable_unref0 (self->signals);
}

static GType
gtkdoc_dbus_interface_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_dbus_value_interface_init, gtkdoc_dbus_value_interface_free_value, gtkdoc_dbus_value_interface_copy_value, gtkdoc_dbus_value_interface_peek_pointer, "p", gtkdoc_dbus_value_interface_collect_value, "p", gtkdoc_dbus_value_interface_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocDBusInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_dbus_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDBusInterface), 0, (GInstanceInitFunc) gtkdoc_dbus_interface_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_dbus_interface_type_id;
	gtkdoc_dbus_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocDBusInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_dbus_interface_type_id;
}

GType
gtkdoc_dbus_interface_get_type (void)
{
	static volatile gsize gtkdoc_dbus_interface_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_dbus_interface_type_id__volatile)) {
		GType gtkdoc_dbus_interface_type_id;
		gtkdoc_dbus_interface_type_id = gtkdoc_dbus_interface_get_type_once ();
		g_once_init_leave (&gtkdoc_dbus_interface_type_id__volatile, gtkdoc_dbus_interface_type_id);
	}
	return gtkdoc_dbus_interface_type_id__volatile;
}

gpointer
gtkdoc_dbus_interface_ref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_dbus_interface_unref (gpointer instance)
{
	GtkdocDBusInterface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_DBUS_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

